/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser;

import com.aptana.browser.BrowserPlugin;
import com.aptana.core.logging.IdeLog;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageResource {
    private static ImageRegistry imageRegistry;
    private static final String URL_PREFIX = "$nl$/icons/";
    private static final String URL_OBJ = "$nl$/icons/obj16/";
    private static final String URL_ELCL = "$nl$/icons/elcl16/";
    private static final String URL_DLCL = "$nl$/icons/dlcl16/";
    public static final String IMG_OBJ_BROWSER = "IMG_OBJ_BROWSER";
    public static final String IMG_ELCL_NAV_BACKWARD = "IMG_ELCL_NAV_BACKWARD";
    public static final String IMG_ELCL_NAV_FORWARD = "IMG_ELCL_NAV_FORWARD";
    public static final String IMG_ELCL_NAV_STOP = "IMG_ELCL_NAV_STOP";
    public static final String IMG_ELCL_NAV_REFRESH = "IMG_ELCL_NAV_REFRESH";
    public static final String IMG_ELCL_NAV_GO = "IMG_ELCL_NAV_GO";
    public static final String IMG_ELCL_NAV_HOME = "IMG_ELCL_NAV_HOME";
    public static final String IMG_ELCL_COMMAND = "IMG_ELCL_COMMAND";
    public static final String IMG_DLCL_NAV_BACKWARD = "IMG_DLCL_NAV_BACKWARD";
    public static final String IMG_DLCL_NAV_FORWARD = "IMG_DLCL_NAV_FORWARD";
    public static final String IMG_DLCL_NAV_STOP = "IMG_DLCL_NAV_STOP";
    public static final String IMG_DLCL_NAV_REFRESH = "IMG_DLCL_NAV_REFRESH";
    public static final String IMG_DLCL_NAV_GO = "IMG_DLCL_NAV_GO";
    public static final String IMG_DLCL_NAV_HOME = "IMG_DLCL_NAV_HOME";

    private ImageResource() {
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return imageRegistry.getDescriptor(key);
    }

    private static void registerImage(String key, String partialURL) {
        try {
            URL url = FileLocator.find((Bundle)BrowserPlugin.getDefault().getBundle(), (IPath)new Path(partialURL), null);
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
            imageRegistry.put(key, id);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)BrowserPlugin.getDefault(), (String)MessageFormat.format("Error registering image {0} from {1}", key, partialURL), (Throwable)e);
        }
    }

    private static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        ImageResource.registerImage(IMG_OBJ_BROWSER, "$nl$/icons/obj16/browser.png");
        ImageResource.registerImage(IMG_ELCL_NAV_BACKWARD, "$nl$/icons/elcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_FORWARD, "$nl$/icons/elcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_STOP, "$nl$/icons/elcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_REFRESH, "$nl$/icons/elcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_GO, "$nl$/icons/elcl16/nav_go.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_HOME, "$nl$/icons/elcl16/nav_home.gif");
        ImageResource.registerImage(IMG_ELCL_COMMAND, "$nl$/icons/elcl16/command.png");
        ImageResource.registerImage(IMG_DLCL_NAV_BACKWARD, "$nl$/icons/dlcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_FORWARD, "$nl$/icons/dlcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_STOP, "$nl$/icons/dlcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_REFRESH, "$nl$/icons/dlcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_GO, "$nl$/icons/dlcl16/nav_go.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_HOME, "$nl$/icons/dlcl16/nav_home.gif");
    }
}

