/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser;

import com.aptana.browser.BrowserPlugin;
import com.aptana.browser.CustomSizeDialog;
import com.aptana.browser.ImageResource;
import com.aptana.browser.Messages;
import com.aptana.browser.internal.BrowserBackgroundImage;
import com.aptana.browser.internal.BrowserSize;
import com.aptana.browser.internal.BrowserSizeCategory;
import com.aptana.core.CoreStrings;
import com.aptana.swt.webkitbrowser.OpenWindowEvent;
import com.aptana.swt.webkitbrowser.WebKitBrowser;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class WebBrowserViewer
extends Composite {
    public static final int NAVIGATION_BAR = 1;
    private WebKitBrowser browser;
    private IAction backAction;
    private IAction forwardAction;
    private IAction stopAction;
    private IAction refreshAction;
    private IAction goAction;
    private ToolBarManager toolBarManager;
    private Combo urlCombo;
    private boolean loadInProgress = false;
    private final boolean showNavigatorBar;
    private boolean newWindow;
    private Composite backgroundArea;
    private Composite browserArea;
    private BrowserSize currentSize;
    private Image currentImage;

    public WebBrowserViewer(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createActions();
        this.showNavigatorBar = (style & 1) != 0;
        this.backgroundArea = new Composite((Composite)this, 0);
        this.backgroundArea.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.backgroundArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.backgroundArea.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                WebBrowserViewer.this.resizeBackground();
            }

            public void controlResized(ControlEvent e) {
                WebBrowserViewer.this.resizeBackground();
            }
        });
        this.backgroundArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (WebBrowserViewer.this.currentImage != null) {
                    GC gc = new GC((Drawable)WebBrowserViewer.this.backgroundArea);
                    gc.drawImage(WebBrowserViewer.this.currentImage, 0, 0);
                    gc.dispose();
                }
            }
        });
        this.browserArea = new Composite(this.backgroundArea, 0);
        this.browserArea.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.browserArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.browserArea.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                WebBrowserViewer.this.resizeBrowser();
            }

            public void controlResized(ControlEvent e) {
                WebBrowserViewer.this.resizeBrowser();
            }
        });
        if (this.showNavigatorBar) {
            Composite container = new Composite(this.browserArea, 0);
            container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            container.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
            this.createCommandBar(container);
            this.createNavigationBar(container);
        }
        this.browser = new WebKitBrowser(this.browserArea, 0);
        this.browser.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        if (this.showNavigatorBar) {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (!WebBrowserViewer.this.loadInProgress) {
                        WebBrowserViewer.this.loadInProgress = true;
                        WebBrowserViewer.this.updateNavigationButtons();
                    }
                }

                public void completed(ProgressEvent event) {
                    WebBrowserViewer.this.loadInProgress = false;
                    WebBrowserViewer.this.updateNavigationButtons();
                }
            });
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    WebBrowserViewer.this.urlCombo.setText(WebBrowserViewer.this.browser.getUrl());
                }
            });
            this.updateNavigationButtons();
        }
        MenuManager menuManager = new MenuManager("#Popup");
        menuManager.add(this.backAction);
        menuManager.add(this.forwardAction);
        menuManager.add(this.refreshAction);
        this.browser.setMenu(menuManager.createContextMenu((Control)this.browser));
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell2 = new Shell(WebBrowserViewer.this.getShell(), 1264);
                shell2.setLayout((Layout)new FillLayout());
                shell2.setText(Messages.WebBrowserViewer_WindowShellTitle);
                shell2.setImage(WebBrowserViewer.this.getShell().getImage());
                if (event.location != null) {
                    shell2.setLocation(event.location);
                }
                if (event.size != null) {
                    shell2.setSize(event.size);
                }
                int style = 0;
                if (WebBrowserViewer.this.showNavigatorBar) {
                    ++style;
                }
                shell2.setVisible(true);
                WebBrowserViewer browser2 = new WebBrowserViewer((Composite)shell2, style);
                shell2.layout();
                browser2.newWindow = true;
                if (event instanceof OpenWindowEvent) {
                    ((OpenWindowEvent)event).browser = browser2.browser;
                } else {
                    event.browser = (Browser)browser2.getBrowser();
                }
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                if (WebBrowserViewer.this.newWindow) {
                    WebBrowserViewer.this.getShell().dispose();
                }
            }
        });
    }

    public void dispose() {
        this.disposeImage();
        super.dispose();
    }

    public void addProgressListener(ProgressListener listener) {
        this.browser.addProgressListener(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.browser.removeProgressListener(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.browser.addTitleListener(listener);
    }

    public void removeTitleListener(TitleListener listener) {
        this.browser.removeTitleListener(listener);
    }

    private void createCommandBar(Composite parent) {
        final MenuManager menuManager = new MenuManager("#CommandMenu");
        MenuManager sizeMenuManager = new MenuManager(Messages.WebBrowserViewer_LBL_SetSize);
        sizeMenuManager.add((IAction)new Action(Messages.WebBrowserViewer_LBL_FullEditor){

            public void run() {
                WebBrowserViewer.this.currentSize = null;
                WebBrowserViewer.this.layout();
            }
        });
        menuManager.add((IContributionItem)sizeMenuManager);
        Object[] categories = BrowserPlugin.getDefault().getBrowserConfigurationManager().getSizeCategories();
        Arrays.sort(categories);
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserSize[] sizes;
            Object category = objectArray[n2];
            MenuManager categoryMenuManager = new MenuManager(((BrowserSizeCategory)category).getName());
            sizeMenuManager.add((IContributionItem)categoryMenuManager);
            BrowserSize[] browserSizeArray = sizes = ((BrowserSizeCategory)category).getSizes();
            int n3 = sizes.length;
            int n4 = 0;
            while (n4 < n3) {
                final BrowserSize size = browserSizeArray[n4];
                categoryMenuManager.add((IAction)new Action(size.getName()){

                    public void run() {
                        WebBrowserViewer.this.disposeImage();
                        WebBrowserViewer.this.currentSize = size;
                        boolean blackBackground = false;
                        BrowserBackgroundImage image = WebBrowserViewer.this.currentSize.getImage();
                        if (image != null) {
                            WebBrowserViewer.this.currentImage = image.getImageDescriptor().createImage();
                            blackBackground = image.isBlackBackground();
                        }
                        Color background = blackBackground ? WebBrowserViewer.this.getDisplay().getSystemColor(2) : WebBrowserViewer.this.getDisplay().getSystemColor(1);
                        WebBrowserViewer.this.setBackground(background);
                        WebBrowserViewer.this.backgroundArea.setBackground(background);
                        WebBrowserViewer.this.resizeBackground();
                    }
                });
                ++n4;
            }
            ++n2;
        }
        sizeMenuManager.add((IAction)new Action(Messages.WebBrowserViewer_LBL_Custom){

            public void run() {
                WebBrowserViewer.this.setCustomSize();
            }
        });
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        Action action = new Action("Command", 4){

            public void run() {
            }
        };
        action.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_COMMAND"));
        action.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                return menuManager.createContextMenu(parent);
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        });
        toolBarManager.add((IAction)action);
        ToolBar sizeToolBar = toolBarManager.createControl(parent);
        sizeToolBar.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    private void createNavigationBar(Composite parent) {
        this.toolBarManager = new ToolBarManager(0x800000);
        this.toolBarManager.add(this.backAction);
        this.toolBarManager.add(this.forwardAction);
        this.toolBarManager.add(this.stopAction);
        this.toolBarManager.add(this.refreshAction);
        ToolBar toolbar = this.toolBarManager.createControl(parent);
        toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.urlCombo = new Combo(parent, 4);
        this.urlCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.urlCombo.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                WebBrowserViewer.this.setURL(WebBrowserViewer.this.urlCombo.getText());
            }
        });
        ToolBarManager toolBarManager2 = new ToolBarManager(0x800000);
        toolBarManager2.add(this.goAction);
        toolbar = toolBarManager2.createControl(parent);
        toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    private void createActions() {
        this.backAction = new Action(Messages.WebBrowserViewer_LBL_Back){
            {
                this.setToolTipText(Messages.WebBrowserViewer_TTP_Back);
                this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_BACKWARD"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_BACKWARD"));
            }

            public void run() {
                WebBrowserViewer.this.browser.back();
            }
        };
        this.forwardAction = new Action(Messages.WebBrowserViewer_LBL_Forward){
            {
                this.setToolTipText(Messages.WebBrowserViewer_TTP_Forward);
                this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_FORWARD"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_FORWARD"));
            }

            public void run() {
                WebBrowserViewer.this.browser.forward();
            }
        };
        this.stopAction = new Action(Messages.WebBrowserViewer_LBL_Stop){
            {
                this.setToolTipText(Messages.WebBrowserViewer_TTP_Stop);
                this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_STOP"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_STOP"));
            }

            public void run() {
                WebBrowserViewer.this.browser.stop();
            }
        };
        this.refreshAction = new Action(CoreStrings.REFRESH){
            {
                this.setToolTipText(Messages.WebBrowserViewer_TTP_Refresh);
                this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_REFRESH"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_REFRESH"));
            }

            public void run() {
                WebBrowserViewer.this.browser.refresh();
            }
        };
        this.goAction = new Action(Messages.WebBrowserViewer_LBL_Go){
            {
                this.setToolTipText(Messages.WebBrowserViewer_TTP_Go);
                this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_GO"));
                this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_GO"));
            }

            public void run() {
                WebBrowserViewer.this.browser.setUrl(WebBrowserViewer.this.urlCombo.getText());
            }
        };
    }

    private void updateNavigationButtons() {
        this.backAction.setEnabled(!this.loadInProgress && this.browser.isBackEnabled());
        this.forwardAction.setEnabled(!this.loadInProgress && this.browser.isForwardEnabled());
        this.stopAction.setEnabled(this.loadInProgress);
        this.refreshAction.setEnabled(!this.loadInProgress);
    }

    public boolean setFocus() {
        return this.browser.setFocus();
    }

    public Control getBrowser() {
        return this.browser;
    }

    public boolean setText(String html) {
        return this.browser.setText(html);
    }

    public boolean setURL(String url) {
        return this.browser.setUrl(url);
    }

    private void disposeImage() {
        if (this.currentImage != null) {
            this.currentImage.dispose();
            this.currentImage = null;
        }
    }

    private void resizeBackground() {
        if (this.currentSize != null) {
            if (this.currentImage == null) {
                this.backgroundArea.setSize(this.currentSize.getWidth(), this.currentSize.getHeight());
            } else {
                ImageData imageData = this.currentImage.getImageData();
                this.backgroundArea.setSize(imageData.width, imageData.height);
            }
        }
    }

    private void resizeBrowser() {
        BrowserBackgroundImage image;
        if (this.currentSize != null && (image = this.currentSize.getImage()) != null) {
            this.browserArea.setSize(this.currentSize.getWidth(), this.currentSize.getHeight());
            this.browserArea.setLocation(image.getHorizontalIndent(), image.getVerticalIndent());
        }
    }

    private void setCustomSize() {
        CustomSizeDialog dialog = new CustomSizeDialog(this.getShell());
        if (dialog.open() == 0) {
            this.currentSize = new BrowserSize("custom", dialog.fWidth, dialog.fHeight, null, null);
            this.backgroundArea.setSize(this.currentSize.getWidth(), this.currentSize.getHeight());
        }
    }
}

