/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser.internal;

import com.aptana.browser.BrowserPlugin;
import com.aptana.browser.internal.BrowserBackgroundImage;
import com.aptana.browser.internal.BrowserSize;
import com.aptana.browser.internal.BrowserSizeCategory;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BrowserConfigurationManager {
    private static final String EXTENSION_POINT_ID = "configuration";
    private static final String ELEMENT_SIZE = "size";
    private static final String ELEMENT_SIZE_CATEGORY = "sizeCategory";
    private static final String ELEMENT_BACKGROUND_IMAGE = "backgroundImage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ORDER = "order";
    private static final String ATT_WIDTH = "width";
    private static final String ATT_HEIGHT = "height";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_IMAGE = "image";
    private static final String ATT_PATH = "path";
    private static final String ATT_HOR_INDENT = "horizontalIndent";
    private static final String ATT_VER_INDENT = "verticalIndent";
    private static final String ATT_BG_COLOR = "bgcolor";
    private Map<String, BrowserSizeCategory> sizeCategories = new HashMap<String, BrowserSizeCategory>();
    private Map<String, BrowserBackgroundImage> backgroundImages = new HashMap<String, BrowserBackgroundImage>();
    private List<BrowserSize> sizes = new ArrayList<BrowserSize>();

    public BrowserConfigurationManager() {
        this.readExtensionRegistry();
    }

    public void clear() {
        this.sizeCategories.clear();
        this.backgroundImages.clear();
        this.sizes.clear();
    }

    public BrowserSizeCategory[] getSizeCategories() {
        Collection<BrowserSizeCategory> categories = this.sizeCategories.values();
        return categories.toArray(new BrowserSizeCategory[categories.size()]);
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.browser", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                BrowserConfigurationManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newInOrderSet((Object[])new String[]{BrowserConfigurationManager.ELEMENT_SIZE_CATEGORY, BrowserConfigurationManager.ELEMENT_BACKGROUND_IMAGE, BrowserConfigurationManager.ELEMENT_SIZE});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        String name = element.getName();
        if (ELEMENT_SIZE_CATEGORY.equals(name)) {
            String categoryId = element.getAttribute(ATT_ID);
            if (StringUtil.isEmpty((String)categoryId)) {
                return;
            }
            String categoryName = element.getAttribute(ATT_NAME);
            if (StringUtil.isEmpty((String)categoryName)) {
                return;
            }
            int order = 127;
            String orderStr = element.getAttribute(ATT_ORDER);
            if (!StringUtil.isEmpty((String)orderStr)) {
                try {
                    order = Integer.parseInt(orderStr);
                }
                catch (NumberFormatException e) {
                    IdeLog.logWarning((Plugin)BrowserPlugin.getDefault(), (Throwable)e);
                }
            }
            this.sizeCategories.put(categoryId, new BrowserSizeCategory(categoryId, categoryName, order));
        } else if (ELEMENT_BACKGROUND_IMAGE.equals(name)) {
            String imageId = element.getAttribute(ATT_ID);
            if (StringUtil.isEmpty((String)imageId)) {
                return;
            }
            String imagePath = element.getAttribute(ATT_PATH);
            if (StringUtil.isEmpty((String)imagePath)) {
                return;
            }
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)imagePath);
            int horizontalIndent = 0;
            try {
                horizontalIndent = Integer.parseInt(element.getAttribute(ATT_HOR_INDENT));
                if (horizontalIndent < 0) {
                    horizontalIndent = 0;
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)BrowserPlugin.getDefault(), (Throwable)e);
            }
            int verticalIndent = 0;
            try {
                verticalIndent = Integer.parseInt(element.getAttribute(ATT_VER_INDENT));
                if (verticalIndent < 0) {
                    verticalIndent = 0;
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)BrowserPlugin.getDefault(), (Throwable)e);
            }
            boolean blackBackground = false;
            String bgcolor = element.getAttribute(ATT_BG_COLOR);
            if (!StringUtil.isEmpty((String)bgcolor)) {
                blackBackground = Boolean.parseBoolean(bgcolor);
            }
            this.backgroundImages.put(imageId, new BrowserBackgroundImage(imageId, imageDescriptor, horizontalIndent, verticalIndent, blackBackground));
        } else if (ELEMENT_SIZE.equals(element.getName())) {
            String defaultCategoryId;
            String categoryId;
            String heightStr;
            String sizeName = element.getAttribute(ATT_NAME);
            if (StringUtil.isEmpty((String)sizeName)) {
                return;
            }
            String widthStr = element.getAttribute(ATT_WIDTH);
            if (StringUtil.isEmpty((String)widthStr)) {
                return;
            }
            int width = 0;
            try {
                width = Integer.parseInt(widthStr);
                if (width < 0) {
                    width = 0;
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)BrowserPlugin.getDefault(), (Throwable)e);
            }
            if (StringUtil.isEmpty((String)(heightStr = element.getAttribute(ATT_HEIGHT)))) {
                return;
            }
            int height = 0;
            try {
                height = Integer.parseInt(heightStr);
                if (height < 0) {
                    height = 0;
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)BrowserPlugin.getDefault(), (Throwable)e);
            }
            if (StringUtil.isEmpty((String)(categoryId = element.getAttribute(ATT_CATEGORY)))) {
                categoryId = "";
            }
            String imageId = element.getAttribute(ATT_IMAGE);
            BrowserSizeCategory category = this.sizeCategories.get(categoryId);
            if (category == null && (category = this.sizeCategories.get(defaultCategoryId = "default")) == null) {
                category = new BrowserSizeCategory(defaultCategoryId, "Default", Integer.MAX_VALUE);
                this.sizeCategories.put(defaultCategoryId, category);
            }
            BrowserSize size = new BrowserSize(sizeName, width, height, category, this.backgroundImages.get(imageId));
            this.sizes.add(size);
            category.addSize(size);
        }
    }
}

