/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser.internal;

import com.aptana.browser.internal.BrowserSize;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSizeCategory
implements Comparable<BrowserSizeCategory> {
    private final String id;
    private final String name;
    private final int order;
    private final List<BrowserSize> sizes;

    public BrowserSizeCategory(String id, String name, int order) {
        this.id = id;
        this.name = name;
        this.order = order;
        this.sizes = new ArrayList<BrowserSize>();
    }

    public void addSize(BrowserSize size) {
        this.sizes.add(size);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public BrowserSize[] getSizes() {
        return this.sizes.toArray(new BrowserSize[this.sizes.size()]);
    }

    @Override
    public int compareTo(BrowserSizeCategory o) {
        if (this.order != o.order) {
            return this.order - o.order;
        }
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSizeCategory)) {
            return false;
        }
        BrowserSizeCategory other = (BrowserSizeCategory)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.getName();
    }
}

