/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser.parts;

import com.aptana.browser.WebBrowserViewer;
import com.aptana.swt.webkitbrowser.WebKitBrowser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.part.EditorPart;

public class WebBrowserEditor
extends EditorPart {
    public static final String EDITOR_ID = "com.aptana.browser.editors.webbrowser";
    protected WebBrowserViewer webBrowser;
    private int progressWorked;
    private String initialURL;
    private Image image;
    private boolean disposed;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof WebBrowserEditorInput) {
            WebBrowserEditorInput wbei = (WebBrowserEditorInput)input;
            this.initialURL = null;
            if (wbei.getURL() != null) {
                this.initialURL = wbei.getURL().toExternalForm();
            }
            if (this.webBrowser != null) {
                this.webBrowser.setURL(this.initialURL);
                site.getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
            }
            this.setPartName(wbei.getName());
            this.setTitleToolTip(wbei.getToolTipText());
            Image oldImage = this.image;
            ImageDescriptor id = wbei.getImageDescriptor();
            this.image = id.createImage();
            this.setTitleImage(this.image);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        super.dispose();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        WebBrowserEditorInput input = this.getWebBrowserEditorInput();
        int style = 0;
        if (input == null || input.isLocationBarLocal()) {
            style |= 1;
        }
        if (input == null || input.isToolbarLocal()) {
            style |= 1;
        }
        this.webBrowser = new WebBrowserViewer(parent, style);
        WebKitBrowser browser = (WebKitBrowser)this.webBrowser.getBrowser();
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                if (event.current == 0) {
                    IProgressMonitor progressMonitor = WebBrowserEditor.this.getStatusBarProgressMonitor();
                    progressMonitor.done();
                    progressMonitor.beginTask("", event.total);
                    WebBrowserEditor.this.progressWorked = 0;
                }
                if (WebBrowserEditor.this.progressWorked < event.current) {
                    WebBrowserEditor.this.getStatusBarProgressMonitor().worked(event.current - WebBrowserEditor.this.progressWorked);
                    WebBrowserEditor.this.progressWorked = event.current;
                }
            }

            public void completed(ProgressEvent event) {
                WebBrowserEditor.this.getStatusBarProgressMonitor().done();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowserEditor.this.setTitleToolTip(event.title);
            }
        });
        this.webBrowser.setURL(this.initialURL);
    }

    public void setFocus() {
        if (this.webBrowser != null) {
            this.webBrowser.setFocus();
        }
    }

    private IProgressMonitor getStatusBarProgressMonitor() {
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        return statusLineManager.getProgressMonitor();
    }

    public boolean close() {
        final boolean[] result = new boolean[1];
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                result[0] = WebBrowserEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)WebBrowserEditor.this, false);
            }
        });
        return result[0];
    }

    protected WebBrowserEditorInput getWebBrowserEditorInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof WebBrowserEditorInput) {
            return (WebBrowserEditorInput)input;
        }
        return null;
    }
}

