/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser.support;

import com.aptana.browser.support.BrowserEditorInstance;
import com.aptana.browser.support.BrowserViewInstance;
import java.util.HashMap;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultBrowserSupport;
import org.eclipse.ui.internal.browser.InternalBrowserInstance;

public class WorkbenchBrowserSupport
extends DefaultBrowserSupport {
    private static final String DEFAULT_ID_BASE = "com.aptana.browser.defaultBrowser";

    public WorkbenchBrowserSupport() {
        WorkbenchBrowserSupport.setDefaultInstance(this);
    }

    private static void setDefaultInstance(DefaultBrowserSupport object) {
        instance = object;
    }

    public IWebBrowser createBrowser(int style, String browserId, String name, String tooltip) throws PartInitException {
        if (browserId == null) {
            browserId = this.getDefaultId();
        }
        if (this.getExistingWebBrowser(browserId) instanceof InternalBrowserInstance) {
            return super.createBrowser(style, browserId, name, tooltip);
        }
        if ((style & 0x80) != 0) {
            return super.createBrowser(style, browserId, name, tooltip);
        }
        InternalBrowserInstance webBrowser = null;
        webBrowser = (style & 0x40) != 0 ? new BrowserViewInstance(browserId, style, name, tooltip) : new BrowserEditorInstance(browserId, style, name, tooltip);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Integer key = workbenchWindow.hashCode();
        HashMap<Integer, InternalBrowserInstance> wmap = (HashMap<Integer, InternalBrowserInstance>)this.browserIdMap.get(browserId);
        if (wmap == null) {
            wmap = new HashMap<Integer, InternalBrowserInstance>();
            this.browserIdMap.put(browserId, wmap);
        }
        wmap.put(key, webBrowser);
        return webBrowser;
    }

    public boolean isInternalWebBrowserAvailable() {
        return true;
    }

    private String getDefaultId() {
        String id = null;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            id = DEFAULT_ID_BASE + i;
            if (this.browserIdMap.get(id) == null) break;
            ++i;
        }
        return id;
    }
}

