/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.common.text.rules.WordDetector;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class HTMLDoctypeScanner
extends RuleBasedScanner {
    public HTMLDoctypeScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("\"", "\"", this.createToken("string.quoted.double.doctype.identifiers-and-DTDs.html"), '\\'));
        rules.add(new MultiLineRule("'", "'", this.createToken("string.quoted.single.doctype.identifiers-and-DTDs.html"), '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), this.createToken(""), true);
        wordRule.addWord("DOCTYPE", this.createToken("entity.name.tag.doctype.html"));
        rules.add(wordRule);
        CharacterMapRule rule = new CharacterMapRule();
        rule.add('>', this.createToken(HTMLTokenType.TAG_END));
        rule.add('=', this.createToken(HTMLTokenType.EQUAL));
        rules.add(rule);
        rules.add((Object)new TagStartRule(new TagStartWordDetector(), this.createToken(HTMLTokenType.TAG_START), false));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(this.createToken(""));
    }

    protected IToken createToken(HTMLTokenType type) {
        return this.createToken(type.getScope());
    }

    protected IToken createToken(String string) {
        return new Token((Object)string);
    }

    private static final class TagStartRule
    extends ExtendedWordRule {
        private Pattern pattern;

        private TagStartRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile("<(/)?");
            }
            return this.pattern.matcher(word).matches();
        }
    }

    private static final class TagStartWordDetector
    implements IWordDetector {
        private TagStartWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '<';
        }

        public boolean isWordPart(char c) {
            return c == '/';
        }
    }
}

