/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IEditorLinkedResources;
import com.aptana.editor.common.outline.CommonOutlinePage;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.html.HTMLEditorLinkedResources;
import com.aptana.editor.html.HTMLFoldingComputer;
import com.aptana.editor.html.HTMLOpenTagCloser;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceViewerConfiguration;
import com.aptana.editor.html.outline.HTMLOutlineContentProvider;
import com.aptana.editor.html.outline.HTMLOutlineLabelProvider;
import com.aptana.editor.xml.TagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class HTMLEditor
extends AbstractThemeableEditor {
    private static final char[] HTML_PAIR_MATCHING_CHARS = new char[]{'(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"', '<', '>', '\u201c', '\u201d', '\u2018', '\u2019'};
    private Map<Annotation, Position> fTagPairOccurrences;
    private static Collection<String> tagPartitions = new ArrayList<String>();
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("HTML_OUTLINE_TAG_ATTRIBUTES".equals(event.getKey())) {
                HTMLEditor.this.getOutlinePage().refresh();
            }
        }
    };

    static {
        tagPartitions.add("__html_tag");
        tagPartitions.add("__html_tag_close");
        tagPartitions.add("__html_script");
        tagPartitions.add("__html_style");
        tagPartitions.add("__html_svg");
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(HTMLEditor.getChainedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new HTMLSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(HTMLPlugin.getDefault().getHTMLDocumentProvider());
    }

    public void dispose() {
        try {
            EclipseUtil.instanceScope().getNode("com.aptana.editor.html").removePreferenceChangeListener(this.fPreferenceListener);
        }
        finally {
            super.dispose();
        }
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{HTMLPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    protected CommonOutlinePage createOutlinePage() {
        CommonOutlinePage outlinePage = super.createOutlinePage();
        EclipseUtil.instanceScope().getNode("com.aptana.editor.html").addPreferenceChangeListener(this.fPreferenceListener);
        return outlinePage;
    }

    public String getContentType() {
        return "com.aptana.contenttype.html";
    }

    public char[] getPairMatchingCharacters() {
        return HTML_PAIR_MATCHING_CHARS;
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return new HTMLOutlineContentProvider(this);
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new HTMLOutlineLabelProvider();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.installOpenTagCloser();
    }

    protected void installOpenTagCloser() {
        new HTMLOpenTagCloser((ITextViewer)this.getSourceViewer()).install();
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }

    protected void selectionChanged() {
        super.selectionChanged();
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        this.highlightTagPair(offset);
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }

    private void highlightTagPair(int offset) {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        if (this.fTagPairOccurrences != null) {
            for (Position pos : this.fTagPairOccurrences.values()) {
                if (!pos.includes(offset)) continue;
                return;
            }
            for (Annotation a : this.fTagPairOccurrences.keySet()) {
                annotationModel.removeAnnotation(a);
            }
            this.fTagPairOccurrences = null;
        }
        HashMap<Annotation, Position> occurrences = new HashMap<Annotation, Position>();
        IDocument document = this.getSourceViewer().getDocument();
        IRegion match = TagUtil.findMatchingTag((IDocument)document, (int)offset, tagPartitions);
        if (match != null) {
            occurrences.put(new Annotation("com.aptana.html.tagPair.occurrences", false, null), new Position(match.getOffset(), match.getLength()));
            try {
                ITypedRegion partition = document.getPartition(offset);
                occurrences.put(new Annotation("com.aptana.html.tagPair.occurrences", false, null), new Position(partition.getOffset(), partition.getLength()));
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
            for (Map.Entry entry : occurrences.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
            this.fTagPairOccurrences = occurrences;
        } else {
            this.fTagPairOccurrences = null;
        }
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new HTMLFoldingComputer(this, document);
    }

    public Object getAdapter(Class adapter) {
        if (IEditorLinkedResources.class == adapter) {
            return new HTMLEditorLinkedResources((IEditorPart)this);
        }
        return super.getAdapter(adapter);
    }
}

