/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.editor.xml.TagUtil;
import com.aptana.parsing.lexer.Lexeme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTagUtil {
    public static boolean isTag(Lexeme<HTMLTokenType> lexeme) {
        if (lexeme != null) {
            HTMLTokenType type = (HTMLTokenType)((Object)lexeme.getType());
            return HTMLTokenType.STRUCTURE_TAG.equals((Object)type) || HTMLTokenType.BLOCK_TAG.equals((Object)type) || HTMLTokenType.INLINE_TAG.equals((Object)type);
        }
        return false;
    }

    public static List<String> getUnclosedTagNames(IDocument document, int offset) {
        HTMLParseState state = new HTMLParseState(document.get());
        ArrayList<String> unclosedElements = new ArrayList<String>();
        try {
            ITypedRegion previousPartition;
            String src;
            String tagName;
            ITypedRegion[] partitions = document.computePartitioning(0, offset);
            if (partitions.length > 1 && !"".equals(tagName = TagUtil.getTagName((String)(src = document.get((previousPartition = partitions[partitions.length - 2]).getOffset(), previousPartition.getLength())))) && TagUtil.isStartTag((String)src) && !HTMLParseState.isEmptyTagType(tagName) && TagUtil.tagClosed((IDocument)document, (String)tagName)) {
                return unclosedElements;
            }
            ITypedRegion[] iTypedRegionArray = partitions;
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                int greaterThanIndex;
                String src2;
                int lessThanIndex;
                ITypedRegion partition = iTypedRegionArray[n2];
                if (partition != null && "__html_tag".equals(partition.getType()) && (lessThanIndex = (src2 = document.get(partition.getOffset(), partition.getLength())).indexOf(60)) != -1 && lessThanIndex < src2.length() - 1 && (greaterThanIndex = src2.indexOf(62)) != -1) {
                    String tagName2 = TagUtil.getTagName((String)src2);
                    if (!(unclosedElements.contains(tagName2 = tagName2.toLowerCase()) || HTMLParseState.isEmptyTagType(tagName2) || TagUtil.tagClosed((IDocument)document, (String)tagName2))) {
                        unclosedElements.add(tagName2);
                    }
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        Collections.reverse(unclosedElements);
        return unclosedElements;
    }
}

