/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.contentassist.index.HTMLIndexReader;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLIndexQueryHelper {
    private HTMLIndexReader _reader = new HTMLIndexReader();

    public static Index getIndex() {
        return HTMLIndexQueryHelper.getIndexManager().getIndex(URI.create("metadata:/html"));
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    private List<AttributeElement> getAttribute(String name) {
        if (name != null && name.length() > 0) {
            return this._reader.getAttribute(HTMLIndexQueryHelper.getIndex(), name);
        }
        return Collections.emptyList();
    }

    public AttributeElement getAttribute(String elementName, String attributeName) {
        AttributeElement result = null;
        if (elementName != null && elementName.length() > 0) {
            AttributeElement defaultAttribute = null;
            AttributeElement candidateAttribute = null;
            for (AttributeElement attribute : this.getAttribute(attributeName)) {
                String elementRef = attribute.getElement();
                if (elementRef != null && elementRef.length() > 0) {
                    if (!elementName.equals(elementRef)) continue;
                    candidateAttribute = attribute;
                    continue;
                }
                defaultAttribute = attribute;
            }
            if (candidateAttribute != null) {
                result = candidateAttribute;
            } else if (defaultAttribute != null) {
                result = defaultAttribute;
            }
        }
        return result;
    }

    public List<AttributeElement> getAttributes() {
        return this._reader.getAttributes(HTMLIndexQueryHelper.getIndex());
    }

    public List<AttributeElement> getAttributes(ElementElement element) {
        List<AttributeElement> attributes;
        List<AttributeElement> result = Collections.emptyList();
        if (element != null && (attributes = this._reader.getAttributes(HTMLIndexQueryHelper.getIndex(), element.getAttributes())) != null && !attributes.isEmpty()) {
            String elementName = element.getName();
            HashMap<String, AttributeElement> attributeMap = new HashMap<String, AttributeElement>();
            for (AttributeElement attribute : attributes) {
                boolean previousHasElement;
                boolean validAttribute;
                String attributeName = attribute.getName();
                String owningElement = attribute.getElement();
                boolean bl = validAttribute = owningElement == null || owningElement.length() == 0 || owningElement.equals(elementName);
                if (!validAttribute) continue;
                AttributeElement previousAttribute = (AttributeElement)attributeMap.get(attributeName);
                if (previousAttribute == null) {
                    attributeMap.put(attributeName, attribute);
                    continue;
                }
                boolean currentHasElement = !StringUtil.isEmpty((String)owningElement);
                boolean bl2 = previousHasElement = !StringUtil.isEmpty((String)previousAttribute.getName());
                if (currentHasElement && previousHasElement || !currentHasElement && !previousHasElement) {
                    attributeMap.put(attributeName, attribute);
                    continue;
                }
                if (!currentHasElement) continue;
                attributeMap.put(attributeName, attribute);
            }
            result = new ArrayList(attributeMap.values());
        }
        return result;
    }

    public Map<String, String> getClasses(Index index) {
        return this._reader.getValues(index, "css.class");
    }

    public Map<String, String> getCSSReferences(Index index) {
        return this._reader.getValues(index, "html.resource.css");
    }

    public ElementElement getElement(String name) {
        List<ElementElement> elements;
        if (name != null && name.length() > 0 && !(elements = this._reader.getElements(HTMLIndexQueryHelper.getIndex(), name)).isEmpty()) {
            return elements.get(0);
        }
        return null;
    }

    public List<ElementElement> getElements() {
        return this._reader.getElements(HTMLIndexQueryHelper.getIndex());
    }

    public List<EntityElement> getEntities() {
        return this._reader.getEntities(HTMLIndexQueryHelper.getIndex());
    }

    public List<EventElement> getEvents() {
        return this._reader.getEvents(HTMLIndexQueryHelper.getIndex());
    }

    public List<EventElement> getEvents(ElementElement element) {
        if (element != null) {
            List<String> names = element.getEvents();
            return this._reader.getEvents(HTMLIndexQueryHelper.getIndex(), names);
        }
        return Collections.emptyList();
    }

    public List<EventElement> getEvents(String elementName) {
        return this.getEvents(this.getElement(elementName));
    }

    public Map<String, String> getIDs(Index index) {
        return this._reader.getValues(index, "css.identifier");
    }

    public Map<String, String> getJSReferences(Index index) {
        return this._reader.getValues(index, "html.resource.js");
    }
}

