/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.MetadataReader;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.contentassist.model.SpecificationElement;
import com.aptana.editor.html.contentassist.model.UserAgentElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLMetadataReader
extends MetadataReader {
    private static final String HTML_METADATA_SCHEMA = "/metadata/HTMLMetadataSchema.xml";
    private List<ElementElement> _elements = new LinkedList<ElementElement>();
    private ElementElement _currentElement;
    private List<AttributeElement> _attributes = new LinkedList<AttributeElement>();
    private AttributeElement _currentAttribute;
    private UserAgentElement _currentUserAgent;
    private ValueElement _currentValue;
    private List<EventElement> _events = new LinkedList<EventElement>();
    private EventElement _currentEvent;
    private List<EntityElement> _entities = new LinkedList<EntityElement>();
    private EntityElement _currentEntity;

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        super.startElement(namespaceURI, localName, qualifiedName, attributes);
        switch (Element.fromString(localName)) {
            case ATTRIBUTE: {
                this.enterAttribute(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ATTRIBUTE_REF: {
                this.enterAttributeReference(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case BROWSER: {
                this.enterBrowser(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ELEMENT: {
                this.enterElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ENTITY: {
                this.enterEntity(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case EVENT: {
                this.enterEvent(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case EVENT_REF: {
                this.enterEventReference(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case REFERENCE: {
                this.enterReference(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case SPECIFICATION: {
                this.enterSpecification(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case VALUE: {
                this.enterValue(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case HINT: 
            case DEPRECATED: 
            case DESCRIPTION: 
            case REMARKS: 
            case EXAMPLE: {
                this.startTextBuffer(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        switch (Element.fromString(localName)) {
            case ATTRIBUTE: {
                this.exitAttribute(namespaceURI, localName, qualifiedName);
                break;
            }
            case AVAILABILITY: {
                this.exitAvailability(namespaceURI, localName, qualifiedName);
                break;
            }
            case BROWSER: {
                this.exitBrowser(namespaceURI, localName, qualifiedName);
                break;
            }
            case DEPRECATED: {
                this.exitDeprecated(namespaceURI, localName, qualifiedName);
                break;
            }
            case DESCRIPTION: {
                this.exitDescription(namespaceURI, localName, qualifiedName);
                break;
            }
            case ELEMENT: {
                this.exitElement(namespaceURI, localName, qualifiedName);
                break;
            }
            case ENTITY: {
                this.exitEntity(namespaceURI, localName, qualifiedName);
                break;
            }
            case EVENT: {
                this.exitEvent(namespaceURI, localName, qualifiedName);
                break;
            }
            case EXAMPLE: {
                this.exitExample(namespaceURI, localName, qualifiedName);
                break;
            }
            case HINT: {
                this.exitHint(namespaceURI, localName, qualifiedName);
                break;
            }
            case REMARKS: {
                this.exitRemarks(namespaceURI, localName, qualifiedName);
                break;
            }
            case VALUE: {
                this.exitValue(namespaceURI, localName, qualifiedName);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    public void enterAttribute(String ns, String name, String qname, Attributes attributes) {
        AttributeElement attribute = new AttributeElement();
        attribute.setName(attributes.getValue("name"));
        attribute.setType(attributes.getValue("type"));
        attribute.setElement(attributes.getValue("element"));
        this._currentAttribute = attribute;
    }

    public void enterAttributeReference(String ns, String name, String qname, Attributes attributes) {
        this._currentElement.addAttribute(attributes.getValue("name"));
    }

    public void enterBrowser(String ns, String name, String qname, Attributes attributes) {
        UserAgentElement userAgent = new UserAgentElement();
        userAgent.setPlatform(attributes.getValue("platform"));
        userAgent.setVersion(attributes.getValue("version"));
        this._currentUserAgent = userAgent;
    }

    public void enterElement(String ns, String name, String qname, Attributes attributes) {
        ElementElement element = new ElementElement();
        element.setName(attributes.getValue("name"));
        element.setRelatedClass(attributes.getValue("related-class"));
        element.setDisplayName(attributes.getValue("display-name"));
        this._currentElement = element;
    }

    public void enterEntity(String ns, String name, String qname, Attributes attributes) {
        EntityElement entity = new EntityElement();
        entity.setName(attributes.getValue("name"));
        entity.setDecimalValue(attributes.getValue("decimal"));
        entity.setHexValue(attributes.getValue("hex"));
        this._currentEntity = entity;
    }

    public void enterEvent(String ns, String name, String qname, Attributes attributes) {
        EventElement event = new EventElement();
        event.setName(attributes.getValue("name"));
        event.setType(attributes.getValue("type"));
        this._currentEvent = event;
    }

    public void enterEventReference(String ns, String name, String qname, Attributes attributes) {
        this._currentElement.addEvent(attributes.getValue("name"));
    }

    public void enterReference(String ns, String name, String qname, Attributes attributes) {
        String reference = attributes.getValue("name");
        if (this._currentAttribute != null) {
            this._currentAttribute.addReference(reference);
        } else if (this._currentElement != null) {
            this._currentElement.addReference(reference);
        }
    }

    public void enterSpecification(String ns, String name, String qname, Attributes attributes) {
        SpecificationElement specification = new SpecificationElement();
        specification.setName(attributes.getValue("name"));
        specification.setVersion(attributes.getValue("version"));
        if (this._currentAttribute != null) {
            this._currentAttribute.addSpecification(specification);
        } else if (this._currentElement != null) {
            this._currentElement.addSpecification(specification);
        } else if (this._currentEvent != null) {
            this._currentEvent.addSpecification(specification);
        }
    }

    public void enterValue(String ns, String name, String qname, Attributes attributes) {
        ValueElement value = new ValueElement();
        value.setName(attributes.getValue("name"));
        value.setDescription(attributes.getValue("description"));
        this._currentValue = value;
    }

    public void exitAttribute(String ns, String name, String qname) {
        this._attributes.add(this._currentAttribute);
        this._currentAttribute = null;
    }

    public void exitAvailability(String ns, String name, String qname) {
    }

    public void exitBrowser(String ns, String name, String qname) {
        if (this._currentAttribute != null) {
            this._currentAttribute.addUserAgent(this._currentUserAgent);
        } else if (this._currentElement != null) {
            this._currentElement.addUserAgent(this._currentUserAgent);
        } else if (this._currentEvent != null) {
            this._currentEvent.addUserAgent(this._currentUserAgent);
        }
        this._currentUserAgent = null;
    }

    public void exitDeprecated(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentAttribute != null) {
            this._currentAttribute.setDeprecated(this.resolveEntities(text));
        } else if (this._currentElement != null) {
            this._currentElement.setDeprecated(this.resolveEntities(text));
        }
    }

    public void exitDescription(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentAttribute != null) {
            this._currentAttribute.setDescription(this.resolveEntities(text));
        } else if (this._currentElement != null) {
            this._currentElement.setDescription(this.resolveEntities(text));
        } else if (this._currentEvent != null) {
            this._currentEvent.setDescription(this.resolveEntities(text));
        } else if (this._currentEntity != null) {
            this._currentEntity.setDescription(this.resolveEntities(text));
        }
    }

    public void exitElement(String ns, String name, String qname) {
        this._elements.add(this._currentElement);
        this._currentElement = null;
    }

    public void exitEntity(String ns, String name, String qname) {
        this._entities.add(this._currentEntity);
        this._currentEntity = null;
    }

    public void exitEvent(String ns, String name, String qname) {
        this._events.add(this._currentEvent);
        this._currentEvent = null;
    }

    public void exitExample(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentElement != null) {
            this._currentElement.setExample(text);
        }
    }

    public void exitHint(String ns, String name, String qname) {
        String text = this.getText();
        this._currentAttribute.setHint(text);
    }

    public void exitRemarks(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentAttribute != null) {
            this._currentAttribute.setRemark(text);
        } else if (this._currentElement != null) {
            this._currentElement.setRemark(text);
        } else if (this._currentEvent != null) {
            this._currentEvent.setRemark(text);
        }
    }

    public void exitValue(String ns, String name, String qname) {
        this._currentAttribute.addValue(this._currentValue);
        this._currentValue = null;
    }

    public List<AttributeElement> getAttributes() {
        return this._attributes;
    }

    public List<ElementElement> getElements() {
        return this._elements;
    }

    public List<EntityElement> getEntities() {
        return this._entities;
    }

    public List<EventElement> getEvents() {
        return this._events;
    }

    protected InputStream getSchemaStream() {
        try {
            return FileLocator.openStream((Bundle)HTMLPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)HTML_METADATA_SCHEMA), (boolean)false);
        }
        catch (IOException iOException) {
            return ((Object)((Object)this)).getClass().getResourceAsStream(HTML_METADATA_SCHEMA);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Element {
        AVAILABILITY("availability"),
        HINT("hint"),
        DEPRECATED("deprecated"),
        DESCRIPTION("description"),
        REMARKS("remarks"),
        EXAMPLE("example"),
        VALUE("value"),
        SPECIFICATION("specification"),
        REFERENCE("reference"),
        EVENT_REF("event-ref"),
        EVENT("event"),
        ENTITY("entity"),
        ELEMENT("element"),
        BROWSER("browser"),
        ATTRIBUTE_REF("attribute-ref"),
        ATTRIBUTE("attribute"),
        ATTRIBUTES("attributes"),
        ATTRIBUTE_REFS("attribute-refs"),
        BROWSERS("browsers"),
        HTML("html"),
        ELEMENTS("elements"),
        ENTITIES("entities"),
        ESCAPE_CODES("escape-codes"),
        ESCAPE_CODE("escape-code"),
        EVENTS("events"),
        EVENT_REFS("event-refs"),
        VALUES("values"),
        REFERENCES("references"),
        UNDEFINED(null);

        private String name;

        private Element(String name) {
            this.name = name;
        }

        private static Element fromString(String name) {
            if (name != null) {
                Element[] elementArray = Element.values();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element b = elementArray[n2];
                    if (name.equals(b.name)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return UNDEFINED;
        }
    }
}

