/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.editor.html.contentassist.model.SpecificationElement;
import com.aptana.editor.html.contentassist.model.UserAgentElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementElement
extends BaseElement<Property> {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private static final String REFERENCES_PROPERTY = "references";
    private static final String EVENTS_PROPERTY = "events";
    private static final String ATTRIBUTES_PROPERTY = "attributes";
    private static final String REMARK_PROPERTY = "remark";
    private static final String RELATED_CLASS_PROPERTY = "relatedClass";
    private static final String EXAMPLE_PROPERTY = "example";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private String _displayName;
    private String _relatedClass;
    private List<String> _attributes;
    private List<SpecificationElement> _specifications;
    private List<UserAgentElement> _userAgents;
    private String _deprecated;
    private List<String> _events;
    private String _example;
    private List<String> _references;
    private String _remark;

    public void addAttribute(String attribute) {
        if (attribute != null && attribute.length() > 0) {
            if (this._attributes == null) {
                this._attributes = new ArrayList<String>();
            }
            this._attributes.add(attribute);
        }
    }

    public void addEvent(String event) {
        if (event != null && event.length() > 0) {
            if (this._events == null) {
                this._events = new ArrayList<String>();
            }
            this._events.add(event);
        }
    }

    public void addReference(String reference) {
        if (reference != null && reference.length() > 0) {
            if (this._references == null) {
                this._references = new ArrayList<String>();
            }
            this._references.add(reference);
        }
    }

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == null) {
                this._userAgents = new ArrayList<UserAgentElement>();
            }
            this._userAgents.add(userAgent);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setDisplayName(StringUtil.getStringValue(object.get(DISPLAY_NAME_PROPERTY)));
        this.setDeprecated(StringUtil.getStringValue(object.get(DEPRECATED_PROPERTY)));
        this.setExample(StringUtil.getStringValue(object.get(EXAMPLE_PROPERTY)));
        this.setRelatedClass(StringUtil.getStringValue(object.get(RELATED_CLASS_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this._attributes = IndexUtil.createList(object.get(ATTRIBUTES_PROPERTY));
        this._events = IndexUtil.createList(object.get(EVENTS_PROPERTY));
        this._references = IndexUtil.createList(object.get(REFERENCES_PROPERTY));
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
        this._userAgents = IndexUtil.createList(object.get(USER_AGENTS_PROPERTY), UserAgentElement.class);
    }

    public List<String> getAttributes() {
        return CollectionsUtil.getListValue(this._attributes);
    }

    public String getDeprecated() {
        return StringUtil.getStringValue((Object)this._deprecated);
    }

    public String getDisplayName() {
        return StringUtil.getStringValue((Object)this._displayName);
    }

    public List<String> getEvents() {
        return CollectionsUtil.getListValue(this._events);
    }

    public String getExample() {
        return StringUtil.getStringValue((Object)this._example);
    }

    public List<String> getReferences() {
        return CollectionsUtil.getListValue(this._references);
    }

    public String getRelatedClass() {
        return StringUtil.getStringValue((Object)this._relatedClass);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public List<SpecificationElement> getSpecifications() {
        return CollectionsUtil.getListValue(this._specifications);
    }

    public List<String> getUserAgentNames() {
        return CollectionsUtil.map(this.getUserAgents(), (IMap)new IMap<UserAgentElement, String>(){

            public String map(UserAgentElement userAgent) {
                return userAgent.getPlatform();
            }
        });
    }

    public List<UserAgentElement> getUserAgents() {
        return CollectionsUtil.getListValue(this._userAgents);
    }

    public void setDeprecated(String deprecated) {
        this._deprecated = deprecated;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public void setRelatedClass(String relatedClass) {
        this._relatedClass = relatedClass;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(DISPLAY_NAME_PROPERTY, (Object)this.getDisplayName());
        out.add(DEPRECATED_PROPERTY, (Object)this.getDeprecated());
        out.add(EXAMPLE_PROPERTY, (Object)this.getExample());
        out.add(RELATED_CLASS_PROPERTY, (Object)this.getRelatedClass());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(ATTRIBUTES_PROPERTY, this.getAttributes());
        out.add(EVENTS_PROPERTY, this.getEvents());
        out.add(REFERENCES_PROPERTY, this.getReferences());
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
        out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElementElement)) {
            return false;
        }
        ElementElement other = (ElementElement)obj;
        return ObjectUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<ElementElement>
    {
        NAME(Messages.ElementElement_NameLabel){

            public Object getPropertyValue(ElementElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

