/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.internal.build;

import com.aptana.core.IFilter;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.css.internal.build.CSSTaskDetector;
import com.aptana.editor.html.parsing.ast.HTMLCommentNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.js.internal.build.JSTaskDetector;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTaskDetector
extends RequiredBuildParticipant {
    private static final String COMMENT_ENDING = "-->";
    private static final String ELEMENT_SCRIPT = "script";
    private static final String ATTRIBUTE_SRC = "src";

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        Collection<IProblem> tasks = this.detectTasks(context, monitor);
        context.putProblems("com.aptana.core.task", tasks);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.core.task");
    }

    private Collection<IProblem> detectTasks(BuildContext context, IProgressMonitor monitor) {
        ArrayList<IProblem> tasks = new ArrayList<IProblem>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IParseRootNode rootNode = null;
        try {
            rootNode = context.getAST();
        }
        catch (CoreException coreException) {}
        if (rootNode != null) {
            tasks.addAll(this.walkAST(context, (IParseNode)rootNode, (IProgressMonitor)sub.newChild(1)));
            tasks.addAll(this.processComments(context, rootNode, (IProgressMonitor)sub.newChild(1)));
        }
        sub.done();
        return tasks;
    }

    private Collection<IProblem> processComments(BuildContext context, IParseRootNode rootNode, IProgressMonitor monitor) {
        Object[] comments = rootNode.getCommentNodes();
        if (ArrayUtil.isEmpty((Object[])comments)) {
            return Collections.emptyList();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)comments.length);
        ArrayList<IProblem> tasks = new ArrayList<IProblem>(comments.length);
        try {
            String source = context.getContents();
            String filePath = context.getURI().toString();
            Object[] objectArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                Object commentNode = objectArray[n2];
                if (commentNode instanceof HTMLCommentNode) {
                    tasks.addAll(this.processCommentNode(filePath, source, 0, (IParseNode)commentNode, COMMENT_ENDING));
                }
                sub.worked(1);
                ++n2;
            }
        }
        finally {
            sub.done();
        }
        return tasks;
    }

    private Collection<IProblem> processHTMLSpecialNode(BuildContext context, HTMLSpecialNode htmlSpecialNode) {
        String jsSource;
        String language;
        IParseNode child = htmlSpecialNode.getChild(0);
        if (child != null && "com.aptana.contenttype.css".equals(language = child.getLanguage())) {
            CSSTaskDetector detector = new CSSTaskDetector();
            return detector.detectTasks((IParseRootNode)child, context, null);
        }
        if (ELEMENT_SCRIPT.equalsIgnoreCase(htmlSpecialNode.getName()) && (jsSource = htmlSpecialNode.getAttributeValue(ATTRIBUTE_SRC)) == null && child != null && "com.aptana.contenttype.js".equals(child.getLanguage())) {
            JSTaskDetector detector = new JSTaskDetector();
            return detector.detectTasks((IParseRootNode)child, context, null);
        }
        return Collections.emptyList();
    }

    private Collection<IProblem> walkAST(final BuildContext context, IParseNode parent, IProgressMonitor monitor) {
        final ArrayList<IProblem> tasks = new ArrayList<IProblem>();
        if (parent != null) {
            ParseUtil.treeApply((IParseNode)parent, (IFilter)new IFilter<IParseNode>(){

                public boolean include(IParseNode item) {
                    if (item instanceof HTMLSpecialNode) {
                        tasks.addAll(HTMLTaskDetector.this.processHTMLSpecialNode(context, (HTMLSpecialNode)item));
                    }
                    return true;
                }
            });
        }
        return tasks;
    }
}

