/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.HTMLParserScanner;
import com.aptana.editor.html.parsing.HTMLTokenScanner;
import com.aptana.editor.html.parsing.HTMLUtils;
import com.aptana.editor.html.parsing.Messages;
import com.aptana.editor.html.parsing.ast.HTMLCommentNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.parsing.AbstractParser;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.ast.ParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.parsing.util.ParseUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.rules.ITokenScanner;

public class HTMLParser
extends AbstractParser {
    public static final HTMLNode[] NO_HTML_NODES = new HTMLNode[0];
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_LANG = "language";
    private static final String[] CSS_VALID_TYPE_ATTR = new String[]{"text/css"};
    private static final String[] JS_VALID_TYPE_ATTR = new String[]{"application/javascript", "application/ecmascript", "application/x-javascript", "application/x-ecmascript", "text/javascript", "text/ecmascript", "text/jscript"};
    private static final String[] JS_VALID_LANG_ATTR = new String[]{"JavaScript"};
    private HTMLParserScanner fScanner;
    private HTMLParseState fParseState;
    private Stack<IParseNode> fElementStack;
    private static final Pattern attributes = Pattern.compile("\\s+(\\w[\\w\\-:]*)\\s*?(=\\s*(('[^']*')|(\"[^\"]*\")))?");
    private IParseNode fCurrentElement;
    private Symbol fCurrentSymbol;
    private IProgressMonitor fMonitor;
    private List<IParseNode> fCommentNodes;
    private boolean previousSymbolSkipped;
    private WorkingParseResult fWorkingParseResult;

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fMonitor = parseState.getProgressMonitor();
        this.fScanner = new HTMLParserScanner();
        this.fElementStack = new Stack();
        this.fCommentNodes = new ArrayList<IParseNode>();
        this.fWorkingParseResult = working;
        String source = parseState.getSource();
        if (parseState instanceof HTMLParseState) {
            this.fParseState = (HTMLParseState)parseState;
        } else {
            this.fParseState = new HTMLParseState(source, parseState.getStartingOffset(), parseState.getSkippedRanges());
            this.fParseState.setProgressMonitor(parseState.getProgressMonitor());
        }
        this.fScanner.setSource(source);
        int startingOffset = this.fParseState.getStartingOffset();
        ParseRootNode root = new ParseRootNode("com.aptana.contenttype.html", (Symbol[])NO_HTML_NODES, startingOffset, startingOffset + source.length() - 1);
        try {
            this.fCurrentElement = root;
            this.parseAll(source);
            root.setCommentNodes(this.fCommentNodes.toArray(new IParseNode[this.fCommentNodes.size()]));
            ParseUtil.trimToSize((IParseNode)root);
            working.setParseResult((IParseRootNode)root);
        }
        finally {
            this.fWorkingParseResult = null;
            this.fMonitor = null;
            this.fScanner = null;
            this.fElementStack = null;
            this.fCurrentElement = null;
            this.fCurrentSymbol = null;
            this.fParseState = null;
            this.fCommentNodes = null;
        }
    }

    protected void processSymbol(Symbol symbol, String source) throws IOException, Scanner.Exception {
        switch (symbol.getId()) {
            case 8: {
                this.processComment();
                break;
            }
            case 3: {
                this.processStartTag();
                break;
            }
            case 5: {
                this.processEndTag();
                break;
            }
            case 1: {
                this.processStyleTag();
                break;
            }
            case 2: {
                this.processScriptTag();
                break;
            }
            case 4: {
                this.processText(source);
            }
        }
    }

    protected void processLanguage(String language, short endToken) throws IOException, Scanner.Exception {
        ITokenScanner tokenScanner = this.fScanner.getTokenScanner().getPrimaryTokenScanner();
        if (tokenScanner instanceof HTMLTokenScanner) {
            ((HTMLTokenScanner)tokenScanner).setInsideSpecialTag(true);
        }
        Symbol startTag = this.fCurrentSymbol;
        this.advance();
        int start = this.fCurrentSymbol.getStart();
        int end = start - 1;
        short id = this.fCurrentSymbol.getId();
        while (id != endToken && id != 0) {
            end = this.fCurrentSymbol.getEnd();
            this.advance();
            id = this.fCurrentSymbol.getId();
        }
        if (tokenScanner instanceof HTMLTokenScanner) {
            ((HTMLTokenScanner)tokenScanner).setInsideSpecialTag(false);
        }
        IParseNode[] nested = this.getParseResult(language, start, end);
        if (this.fCurrentElement != null) {
            HTMLSpecialNode node = new HTMLSpecialNode(startTag, nested, startTag.getStart(), this.fCurrentSymbol.getEnd());
            node.setEndNode(this.fCurrentSymbol.getStart(), this.fCurrentSymbol.getEnd());
            this.parseAttribute(node, startTag);
            this.fCurrentElement.addChild((IParseNode)node);
        }
    }

    protected HTMLElementNode processCurrentTag() {
        HTMLElementNode element = new HTMLElementNode(this.fCurrentSymbol, this.fCurrentSymbol.getStart(), this.fCurrentSymbol.getEnd());
        this.parseAttribute(element, this.fCurrentSymbol);
        if (element.isSelfClosing() && !HTMLParseState.isEndForbiddenOrEmptyTag(element.getName())) {
            this.fWorkingParseResult.addError((IParseError)new ParseError("com.aptana.contenttype.html", element.getStartingOffset(), element.getLength(), Messages.HTMLParser_self_closing_syntax_on_non_void_element_error, IParseError.Severity.ERROR));
        }
        return element;
    }

    private void parseAll(String source) throws IOException, Scanner.Exception {
        this.advance();
        while (this.fCurrentSymbol.getId() != 0 && !this.fMonitor.isCanceled()) {
            if (this.isSkipped(this.fCurrentSymbol.getStart(), this.fCurrentSymbol.getEnd())) {
                this.previousSymbolSkipped = true;
            } else {
                this.processSymbol(this.fCurrentSymbol, source);
                this.previousSymbolSkipped = false;
            }
            this.advance();
        }
        ArrayList<HTMLElementNode> elementsToClose = new ArrayList<HTMLElementNode>();
        if (this.fCurrentElement instanceof HTMLElementNode) {
            elementsToClose.add((HTMLElementNode)this.fCurrentElement);
            this.addMissingEndTagError((HTMLElementNode)this.fCurrentElement);
        }
        int i = this.fElementStack.size() - 1;
        while (i >= 0) {
            IParseNode node = (IParseNode)this.fElementStack.get(i);
            if (node instanceof HTMLElementNode) {
                elementsToClose.add((HTMLElementNode)node);
                this.addMissingEndTagError((HTMLElementNode)node);
            }
            --i;
        }
        int end = this.fCurrentSymbol.getStart() - 1;
        for (HTMLElementNode element : elementsToClose) {
            element.setLocation(element.getStartingOffset(), end);
            element.setEndNode(end, end);
        }
    }

    private void advance() throws IOException, Scanner.Exception {
        this.fCurrentSymbol = this.fScanner.nextToken();
    }

    private boolean isSkipped(int start, int end) {
        IRange[] ranges = this.fParseState.getSkippedRanges();
        if (ranges != null) {
            int length = ranges.length;
            int i = 0;
            while (i < length) {
                IRange range = ranges[i];
                if (start >= range.getStartingOffset() && end <= range.getEndingOffset()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IParseNode[] getParseResult(String language, int start, int end) {
        if (start <= end) {
            try {
                String text = this.fScanner.getSource().get(start, end - start + 1);
                ParseState subParseState = new ParseState(text, start);
                ParseResult subParseResult = ParserPoolFactory.parse((String)language, (IParseState)subParseState);
                Object node = subParseResult.getRootNode();
                for (IParseError subError : subParseResult.getErrors()) {
                    this.fWorkingParseResult.addError((IParseError)new ParseError(language, start + subError.getOffset(), subError.getLength(), subError.getMessage(), subError.getSeverity()));
                }
                if (node == null) {
                    node = new HTMLTextNode(text, start, end);
                }
                return new IParseNode[]{node};
            }
            catch (Exception exception) {}
        }
        return new IParseNode[0];
    }

    private void processComment() {
        HTMLCommentNode comment = new HTMLCommentNode(this.fCurrentSymbol.value.toString(), this.fCurrentSymbol.getStart(), this.fCurrentSymbol.getEnd());
        this.fCommentNodes.add((IParseNode)comment);
        if (this.fCurrentElement != null) {
            this.fCurrentElement.addChild((IParseNode)comment);
        }
    }

    private void processStartTag() {
        HTMLElementNode element = this.processCurrentTag();
        this.openElement(element);
    }

    private void processEndTag() {
        String tagName = HTMLUtils.stripTagEndings(this.fCurrentSymbol.value.toString());
        ArrayList<HTMLElementNode> elementsToClose = new ArrayList<HTMLElementNode>();
        if (this.fCurrentElement instanceof HTMLElementNode && ((HTMLElementNode)this.fCurrentElement).getName().equalsIgnoreCase(tagName)) {
            elementsToClose.add((HTMLElementNode)this.fCurrentElement);
        } else {
            IParseNode node;
            boolean hasOpenTag = false;
            int i = this.fElementStack.size() - 1;
            while (i >= 0) {
                node = (IParseNode)this.fElementStack.get(i);
                if (node instanceof HTMLElementNode && ((HTMLElementNode)node).getName().equalsIgnoreCase(tagName)) {
                    hasOpenTag = true;
                    break;
                }
                --i;
            }
            if (hasOpenTag) {
                if (this.fCurrentElement instanceof HTMLElementNode) {
                    elementsToClose.add((HTMLElementNode)this.fCurrentElement);
                    this.addMissingEndTagError((HTMLElementNode)this.fCurrentElement);
                }
                int j = this.fElementStack.size() - 1;
                while (j >= i) {
                    node = (IParseNode)this.fElementStack.get(j);
                    if (node instanceof HTMLElementNode) {
                        elementsToClose.add((HTMLElementNode)node);
                        if (!((HTMLElementNode)node).getName().equalsIgnoreCase(tagName)) {
                            this.addMissingEndTagError((HTMLElementNode)node);
                        }
                    }
                    --j;
                }
            } else {
                this.fWorkingParseResult.addError((IParseError)new ParseError("com.aptana.contenttype.html", this.fCurrentSymbol, String.valueOf(Messages.HTMLParser_unexpected_error) + this.fCurrentSymbol.value, IParseError.Severity.WARNING));
            }
        }
        int currentStart = this.fCurrentSymbol.getStart();
        int currentEnd = this.fCurrentSymbol.getEnd();
        int size = elementsToClose.size();
        int i = 0;
        while (i < size) {
            HTMLElementNode element = (HTMLElementNode)((Object)elementsToClose.get(i));
            if (i < size - 1) {
                element.setLocation(element.getStartingOffset(), currentStart - 1);
                element.setEndNode(currentStart - 1, currentStart - 1);
            } else {
                element.setLocation(element.getStartingOffset(), currentEnd);
                element.setEndNode(currentStart, currentEnd);
            }
            this.closeElement();
            ++i;
        }
    }

    private void addMissingEndTagError(HTMLElementNode node) {
        if (this.fParseState.getCloseTagType(node.getName()) != 2) {
            this.fWorkingParseResult.addError((IParseError)new ParseError("com.aptana.contenttype.html", node.getStartingOffset(), node.getLength(), MessageFormat.format(Messages.HTMLParser_missing_end_tag_error, node.getName()), IParseError.Severity.WARNING));
        }
    }

    private void processStyleTag() throws IOException, Scanner.Exception {
        HTMLElementNode node = this.processCurrentTag();
        String language = null;
        String type = node.getAttributeValue(ATTR_TYPE);
        if (type == null || HTMLParser.isInArray(type, CSS_VALID_TYPE_ATTR)) {
            language = "com.aptana.contenttype.css";
        } else if (HTMLParser.isJavaScript(node)) {
            language = "com.aptana.contenttype.js";
        }
        this.processLanguage(language, (short)10);
    }

    private void processScriptTag() throws IOException, Scanner.Exception {
        HTMLElementNode node = this.processCurrentTag();
        String language = null;
        String type = node.getAttributeValue(ATTR_TYPE);
        if (type == null || HTMLParser.isJavaScript(node)) {
            language = "com.aptana.contenttype.js";
        }
        this.processLanguage(language, (short)11);
    }

    private void parseAttribute(HTMLElementNode element, Symbol tagSymbol) {
        String tag = tagSymbol.value.toString();
        String tagName = element.getElementName();
        int index = tag.indexOf(tagName);
        tag = tag.substring(index + tagName.length());
        int startOftagText = tagSymbol.getStart() + index + tagName.length();
        Matcher m = attributes.matcher(tag);
        while (m.find()) {
            String name = m.group(1);
            String value = m.group(3);
            Range nameRange = new Range(startOftagText + m.start(1), startOftagText + m.end(1));
            Range valueRange = new Range(startOftagText + m.start(3), startOftagText + m.end(3));
            int absoluteOffset = startOftagText + m.start(3);
            if (value != null) {
                value = value.substring(1, value.length() - 1).trim();
            }
            element.setAttribute(name, value == null ? "" : value, (IRange)nameRange, (IRange)valueRange);
            if (StringUtil.isEmpty((String)value)) continue;
            if (HTMLUtils.isCSSAttribute(name)) {
                String text = String.valueOf(tagName) + " {" + value + "}";
                try {
                    CSSDeclarationNode[] declarations;
                    IParseNode rule;
                    int startingOffset = absoluteOffset - (tagName.length() + 1);
                    IParseRootNode node = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (String)text, (int)startingOffset).getRootNode();
                    if (!node.hasChildren() || !((rule = node.getChild(0)) instanceof CSSRuleNode)) continue;
                    CSSDeclarationNode[] cSSDeclarationNodeArray = declarations = ((CSSRuleNode)rule).getDeclarations();
                    int n = declarations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CSSDeclarationNode declaration = cSSDeclarationNodeArray[n2];
                        element.addCSSStyleNode((IParseNode)declaration);
                        ++n2;
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            if (!HTMLUtils.isJSAttribute(tagName, name)) continue;
            try {
                int startingOffset = absoluteOffset + 1;
                IParseRootNode node = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (String)value, (int)startingOffset).getRootNode();
                for (IParseNode child : node) {
                    element.addJSAttributeNode(child);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void processText(String source) {
        String text = this.fCurrentSymbol.value.toString().trim();
        if (text.startsWith("<")) {
            this.fWorkingParseResult.addError((IParseError)new ParseError("com.aptana.contenttype.html", this.fCurrentSymbol.getStart(), this.fCurrentSymbol.getEnd() - this.fCurrentSymbol.getStart() + 1, MessageFormat.format(Messages.HTMLParser_ERR_TagMissingEnd, text), IParseError.Severity.ERROR));
        }
        if (!this.previousSymbolSkipped && this.fCurrentElement.getChildCount() > 0 && this.fCurrentElement.getLastChild().getNodeType() == 5) {
            HTMLTextNode node = (HTMLTextNode)this.fCurrentElement.getLastChild();
            int start = node.getStartingOffset();
            int end = this.fCurrentSymbol.getEnd();
            node.setLocation(start, end);
            node.setText(source.substring(start, end + 1));
        } else {
            this.fCurrentElement.addChild((IParseNode)new HTMLTextNode(this.fCurrentSymbol.value.toString(), this.fCurrentSymbol.getStart(), this.fCurrentSymbol.getEnd()));
        }
    }

    private void openElement(HTMLElementNode element) {
        String tagName = element.getName();
        int closeTagType = this.fParseState.getCloseTagType(tagName);
        if (closeTagType == 2 && this.fCurrentElement != null && tagName.equals(this.fCurrentElement.getNameNode().getName())) {
            int end = this.fCurrentSymbol.getStart() - 1;
            ((HTMLNode)this.fCurrentElement).setLocation(this.fCurrentElement.getStartingOffset(), end);
            if (this.fCurrentElement instanceof HTMLElementNode) {
                ((HTMLElementNode)this.fCurrentElement).setEndNode(end, end);
            }
            this.closeElement();
        }
        if (this.fCurrentElement != null) {
            this.fCurrentElement.addChild((IParseNode)element);
        }
        if (closeTagType != 4 && !element.isSelfClosing()) {
            this.fElementStack.push(this.fCurrentElement);
            this.fCurrentElement = element;
        }
    }

    private void closeElement() {
        this.fCurrentElement = this.fElementStack.size() > 0 ? this.fElementStack.pop() : null;
    }

    public static boolean isJavaScript(HTMLElementNode node) {
        String type = node.getAttributeValue(ATTR_TYPE);
        if (HTMLParser.isInArray(type, JS_VALID_TYPE_ATTR)) {
            return true;
        }
        String langAttr = node.getAttributeValue(ATTR_LANG);
        return langAttr != null && HTMLParser.isInArray(langAttr, JS_VALID_LANG_ATTR);
    }

    private static boolean isInArray(String element, String[] array) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String arrayElement = stringArray[n2];
            if (element.startsWith(arrayElement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

