/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text;

import com.aptana.editor.common.contentassist.CommonTextHover;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.HTMLModelFormatter;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;

public class HTMLTextHover
extends CommonTextHover
implements ITextHover,
ITextHoverExtension2 {
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IParseNode activeNode = this.getActiveNode(textViewer, hoverRegion.getOffset());
        if (!(activeNode instanceof HTMLElementNode)) {
            return null;
        }
        BaseElement element = this.getMatchingElement(textViewer, hoverRegion, (HTMLElementNode)activeNode);
        if (element != null) {
            return this.getHoverInfo(element, this.isBrowserControlAvailable(textViewer), null, (IEditorPart)this.getEditor(textViewer), hoverRegion);
        }
        return null;
    }

    protected BaseElement getMatchingElement(ITextViewer textViewer, IRegion hoverRegion, HTMLElementNode node) {
        IRange elementNameRange = node.getNameNode().getNameRange();
        if (!elementNameRange.contains(hoverRegion.getOffset())) {
            return null;
        }
        try {
            IDocument doc = textViewer.getDocument();
            String openTagContent = doc.get(elementNameRange.getStartingOffset(), elementNameRange.getLength());
            int index = openTagContent.indexOf(node.getName());
            Range tagNameRange = new Range(elementNameRange.getStartingOffset() + index, elementNameRange.getStartingOffset() + index + node.getName().length());
            if (tagNameRange.contains(hoverRegion.getOffset())) {
                return new HTMLIndexQueryHelper().getElement(node.getElementName().toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        IParseNodeAttribute attr = node.getAttributeAtOffset(hoverRegion.getOffset());
        if (attr == null) {
            return null;
        }
        IRange nameRange = attr.getNameRange();
        if (nameRange != null && nameRange.contains(hoverRegion.getOffset())) {
            return new HTMLIndexQueryHelper().getAttribute(node.getElementName().toLowerCase(), attr.getName());
        }
        return null;
    }

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (!(element instanceof BaseElement)) {
            return null;
        }
        return HTMLModelFormatter.TEXT_HOVER.getHeader((BaseElement)element);
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (!(element instanceof BaseElement)) {
            return null;
        }
        return HTMLModelFormatter.TEXT_HOVER.getDocumentation((BaseElement)element);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IParseNode activeNode = this.getActiveNode(textViewer, offset);
        if (!(activeNode instanceof HTMLElementNode)) {
            return null;
        }
        HTMLElementNode node = (HTMLElementNode)activeNode;
        IRange elementNameRange = node.getNameNode().getNameRange();
        if (!elementNameRange.contains(offset)) {
            return null;
        }
        try {
            IDocument doc = textViewer.getDocument();
            String openTagContent = doc.get(elementNameRange.getStartingOffset(), elementNameRange.getLength());
            int start = elementNameRange.getStartingOffset() + openTagContent.indexOf(node.getName());
            Range tagNameRange = new Range(start, start + node.getName().length() - 1);
            if (tagNameRange.contains(offset)) {
                return new Region(tagNameRange.getStartingOffset(), tagNameRange.getLength());
            }
        }
        catch (BadLocationException badLocationException) {}
        IParseNodeAttribute attr = node.getAttributeAtOffset(offset);
        if (attr == null) {
            return null;
        }
        IRange nameRange = attr.getNameRange();
        if (nameRange != null && nameRange.contains(offset)) {
            return new Region(nameRange.getStartingOffset(), nameRange.getLength());
        }
        return null;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
    }
}

