/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLCommentNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.html.validator.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.util.ParseUtil;
import com.aptana.parsing.xpath.ParseNodeNavigator;
import com.aptana.parsing.xpath.ParseNodeXPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTidyValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.html.validator.TidyValidator";
    private static final Pattern DOCTYPE_PATTERN = Pattern.compile("<!(DOCTYPE)\\s+HTML(\\s+((SYSTEM)\\s+[\"']about:legacy-compat[\"']|(PUBLIC)\\s+[\"']\\-//(W3C)//(DTD)\\s+[^/]+//(EN)[\"'](\\s+[\"'].+[\"'])?))?>", 10);
    private static final Pattern ENTITY_PATTERN = Pattern.compile("&(\\S+)?");
    private static ParseNodeXPath FRAMESET_TAG;
    private static ParseNodeXPath BODY_TAG;
    private static ParseNodeXPath NOFRAMES_TAG;
    private static ParseNodeXPath HTML_CHILDREN;
    private HTMLIndexQueryHelper fQueryHelper;
    private Map<String, ElementElement> fElementsMap;
    private Map<String, AttributeElement> fAttributesMap;
    private Map<String, EntityElement> fEntityMap;
    private Map<String, EventElement> fEventMap;
    private Set<String> fIds;
    private boolean foundTitle;

    static {
        try {
            ParseNodeNavigator caseInsensitive = new ParseNodeNavigator(true);
            BODY_TAG = new ParseNodeXPath("/html/body", caseInsensitive);
            FRAMESET_TAG = new ParseNodeXPath("/html/frameset", caseInsensitive);
            NOFRAMES_TAG = new ParseNodeXPath("/html/frameset/noframes", caseInsensitive);
            HTML_CHILDREN = new ParseNodeXPath("/html/*", caseInsensitive);
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.html.tidy_problem");
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        this.fQueryHelper = new HTMLIndexQueryHelper();
        this.fIds = new HashSet<String>();
        try {
            String sourcePath = context.getURI().toString();
            List<IProblem> problems = new ArrayList<IProblem>();
            try {
                String source = context.getContents();
                if (!StringUtil.isEmpty((String)source)) {
                    Document doc = new Document(source);
                    problems.addAll(this.validateDoctype(sourcePath, (IDocument)doc));
                    IParseRootNode ast = context.getAST();
                    if (ast != null) {
                        this.foundTitle = false;
                        problems.addAll(this.validateFrames(ast, (IDocument)doc, sourcePath));
                        problems.addAll(this.validateAST(ast, (IDocument)doc, sourcePath));
                        if (!this.foundTitle) {
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_InsertMissingTitle, 1, 0, 0, sourcePath));
                        }
                    }
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Failed to validate {0} using HTML Tidy validator", sourcePath), (Throwable)e);
            }
            final List filters = this.getFilters();
            problems = CollectionsUtil.filter(problems, (IFilter)new IFilter<IProblem>(){

                public boolean include(IProblem item) {
                    return !HTMLTidyValidator.this.isIgnored(item.getMessage(), filters);
                }
            });
            context.putProblems("com.aptana.editor.html.tidy_problem", problems);
        }
        finally {
            this.fElementsMap = null;
            this.fAttributesMap = null;
            this.fEntityMap = null;
            this.fIds = null;
            this.fQueryHelper = null;
        }
    }

    private Collection<IProblem> checkLink(HTMLElementNode aNode, IDocument doc, String sourcePath) {
        String id = aNode.getAttributeValue("id");
        String name = aNode.getAttributeValue("name");
        if (id != null && name != null && !name.equals(id)) {
            try {
                int offset = aNode.getStartingOffset();
                int length = aNode.getLength();
                return CollectionsUtil.newList((Object[])new IProblem[]{this.createError(Messages.HTMLTidyValidator_IdNameAttributeMismatch, doc.getLineOfOffset(offset) + 1, offset, length, sourcePath)});
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private Collection<IProblem> validateFrames(IParseRootNode ast, IDocument doc, String sourcePath) {
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        try {
            List framesetNodes = (List)FRAMESET_TAG.evaluate((Object)ast);
            if (!CollectionsUtil.isEmpty((Collection)framesetNodes)) {
                int i = 0;
                while (i < framesetNodes.size()) {
                    if (i != 0) {
                        HTMLElementNode framesetNode = (HTMLElementNode)((Object)framesetNodes.get(i));
                        IRange range = framesetNode.getNameNode().getNameRange();
                        int offset = range.getStartingOffset();
                        int length = range.getLength();
                        problems.add(this.createWarning(Messages.HTMLTidyValidator_RepeatedFrameset, doc.getLineOfOffset(offset) + 1, offset, length, sourcePath));
                    }
                    ++i;
                }
                List noFramesNodes = (List)NOFRAMES_TAG.evaluate((Object)ast);
                HTMLElementNode noFrames = null;
                if (!CollectionsUtil.isEmpty((Collection)noFramesNodes)) {
                    noFrames = (HTMLElementNode)((Object)noFramesNodes.get(0));
                }
                if (noFrames == null) {
                    List bodyNode = (List)BODY_TAG.evaluate((Object)ast);
                    if (!CollectionsUtil.isEmpty((Collection)bodyNode)) {
                        IRange range = ((HTMLElementNode)((Object)bodyNode.iterator().next())).getNameNode().getNameRange();
                        int offset = range.getStartingOffset();
                        problems.add(this.createWarning(Messages.HTMLTidyValidator_InsertImplicitNoFrames, doc.getLineOfOffset(offset) + 1, offset, range.getLength(), sourcePath));
                    } else {
                        HTMLElementNode invalidContentNode = this.invalidContentNode(ast);
                        if (invalidContentNode != null) {
                            IRange range = invalidContentNode.getNameNode().getNameRange();
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_MissingNoFrames, doc.getLineOfOffset(range.getStartingOffset()) + 1, range.getStartingOffset(), range.getLength(), sourcePath));
                        }
                    }
                } else {
                    HTMLElementNode invalidContentNode = this.invalidContentNode(ast);
                    if (invalidContentNode != null) {
                        IRange range = invalidContentNode.getNameNode().getNameRange();
                        problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_ElementNotInsideNoFrames, invalidContentNode.getElementName()), doc.getLineOfOffset(range.getStartingOffset()) + 1, range.getStartingOffset(), range.getLength(), sourcePath));
                    }
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return problems;
    }

    private HTMLElementNode invalidContentNode(IParseRootNode ast) {
        try {
            List htmlChildren = (List)HTML_CHILDREN.evaluate((Object)ast);
            if (!CollectionsUtil.isEmpty((Collection)htmlChildren)) {
                Set validTags = CollectionsUtil.newSet((Object[])new String[]{"body", "head", "frameset"});
                for (HTMLNode htmlChild : htmlChildren) {
                    HTMLElementNode element;
                    String tagName;
                    if (!(htmlChild instanceof HTMLElementNode) || validTags.contains(tagName = (element = (HTMLElementNode)htmlChild).getElementName().toLowerCase())) continue;
                    return element;
                }
            }
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private Collection<IProblem> validateAST(IParseRootNode root, final IDocument doc, final String sourcePath) {
        final ArrayList<IProblem> problems = new ArrayList<IProblem>();
        ParseUtil.treeApply((IParseNode)root, (IFilter)new IFilter<IParseNode>(){

            public boolean include(IParseNode node) {
                problems.addAll(HTMLTidyValidator.this.handleNode(node, doc, sourcePath));
                return true;
            }
        });
        return problems;
    }

    private Collection<IProblem> handleNode(IParseNode node, IDocument doc, String sourcePath) {
        if (!(node instanceof HTMLNode)) {
            return Collections.emptyList();
        }
        switch (node.getNodeType()) {
            case 2: 
            case 3: {
                return this.validateElement((HTMLElementNode)node, doc, sourcePath);
            }
            case 4: {
                return this.validateComment((HTMLCommentNode)node, doc, sourcePath);
            }
            case 5: {
                return this.validateTextContent((HTMLTextNode)node, doc, sourcePath);
            }
        }
        return Collections.emptyList();
    }

    private Collection<IProblem> validateElement(HTMLElementNode element, IDocument doc, String sourcePath) {
        ArrayList<IProblem> problems = new ArrayList<IProblem>(2);
        try {
            ElementElement ee;
            String tagName = element.getName().toLowerCase();
            if (!this.foundTitle && "title".equals(tagName)) {
                this.foundTitle = true;
            }
            if ((ee = this.getElement(tagName)) == null) {
                int offset = element.getStartingOffset();
                int length = element.getLength();
                problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_ElementNotRecognized, tagName), doc.getLineOfOffset(offset) + 1, offset, length, sourcePath));
            } else {
                int offset;
                problems.addAll(this.validateAttributes(element, doc, sourcePath));
                String deprecated = ee.getDeprecated();
                if (!StringUtil.isEmpty((String)deprecated)) {
                    offset = element.getStartingOffset();
                    problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_DeprecatedElement, tagName, deprecated), doc.getLineOfOffset(offset) + 1, offset, element.getLength(), sourcePath));
                }
                if (!HTMLParseState.isEmptyTagType(tagName) && ArrayUtil.isEmpty((Object[])element.getChildren()) && (!"script".equals(tagName) || StringUtil.isEmpty((String)element.getAttributeValue("src")))) {
                    offset = element.getStartingOffset();
                    problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_TrimEmptyElement, tagName), doc.getLineOfOffset(offset) + 1, offset, element.getLength(), sourcePath));
                }
                if (HTMLParseState.isEmptyTagType(tagName) && !ArrayUtil.isEmpty((Object[])element.getChildren())) {
                    offset = element.getStartingOffset();
                    problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_ElementNotEmptyOrClosed, tagName), doc.getLineOfOffset(offset) + 1, offset, element.getLength(), sourcePath));
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return problems;
    }

    private Collection<IProblem> validateAttributes(HTMLElementNode element, IDocument doc, String sourcePath) throws BadLocationException {
        Object[] attributes = element.getAttributes();
        if (ArrayUtil.isEmpty((Object[])attributes)) {
            return Collections.emptyList();
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>(attributes.length);
        String tagName = element.getElementName();
        if ("a".equalsIgnoreCase(tagName)) {
            problems.addAll(this.checkLink(element, doc, sourcePath));
        }
        Object[] objectArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            int offset;
            AttributeElement ae;
            Object attr = objectArray[n2];
            String attrName = attr.getName();
            if ("id".equalsIgnoreCase(attrName)) {
                String id = attr.getValue();
                if (this.fIds.contains(id)) {
                    int offset2 = element.getStartingOffset();
                    problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_NonUniqueIdValue, tagName, attr.getValue()), doc.getLineOfOffset(offset2) + 1, offset2, element.getNameNode().getNameRange().getLength(), sourcePath));
                } else {
                    this.fIds.add(id);
                }
            }
            if ((ae = this.getAttribute(tagName, attrName)) == null) {
                EventElement event = this.getEvent(attrName);
                if (event == null) {
                    offset = element.getStartingOffset();
                    problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_ProprietaryAttribute, tagName, attrName, attr.getValue()), doc.getLineOfOffset(offset) + 1, offset, element.getNameNode().getNameRange().getLength(), sourcePath));
                }
            } else {
                List<ValueElement> values;
                String deprecated = ae.getDeprecated();
                if (!StringUtil.isEmpty((String)deprecated)) {
                    offset = element.getStartingOffset();
                    problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_DeprecatedAttribute, tagName, attrName, attr.getValue()), doc.getLineOfOffset(offset) + 1, offset, element.getNameNode().getNameRange().getLength(), sourcePath));
                }
                if (!CollectionsUtil.isEmpty(values = ae.getValues())) {
                    boolean matchingValue = false;
                    for (ValueElement value : values) {
                        String valueName = value.getName();
                        if (!valueName.equals(attr.getValue()) && !"*".equals(valueName)) continue;
                        matchingValue = true;
                        break;
                    }
                    if (!matchingValue) {
                        int offset3 = element.getStartingOffset();
                        problems.add(this.createWarning(MessageFormat.format(Messages.HTMLTidyValidator_InvalidAttributeValue, tagName, attrName, attr.getValue()), doc.getLineOfOffset(offset3) + 1, offset3, element.getNameNode().getNameRange().getLength(), sourcePath));
                    }
                }
            }
            ++n2;
        }
        return problems;
    }

    private Collection<IProblem> validateComment(HTMLCommentNode comment, IDocument doc, String sourcePath) {
        return Collections.emptyList();
    }

    private Collection<IProblem> validateTextContent(HTMLTextNode textNode, IDocument doc, String sourcePath) {
        String text = textNode.getText();
        if (StringUtil.isEmpty((String)text) || text.indexOf(38) == -1) {
            return Collections.emptyList();
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>(2);
        Matcher m = ENTITY_PATTERN.matcher(text);
        while (m.find()) {
            try {
                int offset = textNode.getStartingOffset() + m.start();
                String entity = m.group(1);
                if (entity == null) {
                    problems.add(this.createWarning(Messages.HTMLTidyValidator_UnescapedAmpersand, doc.getLineOfOffset(offset) + 1, offset, 1, sourcePath));
                    continue;
                }
                if (entity.endsWith(";")) continue;
                EntityElement entityEl = this.getEntity(String.valueOf('&') + entity + ';');
                String msg = entityEl != null ? MessageFormat.format(Messages.HTMLTidyValidator_EntityMissingSemicolon, entity) : MessageFormat.format(Messages.HTMLTidyValidator_UnknownEntity, entity);
                problems.add(this.createWarning(msg, doc.getLineOfOffset(offset) + 1, offset, entity.length() + 1, sourcePath));
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return problems;
    }

    private EntityElement getEntity(String entityName) {
        if (this.fEntityMap == null) {
            List<EntityElement> entities = this.fQueryHelper.getEntities();
            this.fEntityMap = CollectionsUtil.mapFromValues(entities, (IMap)new IMap<EntityElement, String>(){

                public String map(EntityElement item) {
                    return item.getName();
                }
            });
        }
        return this.fEntityMap.get(entityName);
    }

    private EventElement getEvent(String eventName) {
        if (this.fEventMap == null) {
            List<EventElement> events = this.fQueryHelper.getEvents();
            this.fEventMap = CollectionsUtil.mapFromValues(events, (IMap)new IMap<EventElement, String>(){

                public String map(EventElement item) {
                    return item.getName();
                }
            });
        }
        return this.fEventMap.get(eventName);
    }

    private ElementElement getElement(String tagName) {
        if (this.fElementsMap == null) {
            List<ElementElement> elements = this.fQueryHelper.getElements();
            this.fElementsMap = CollectionsUtil.mapFromValues(elements, (IMap)new IMap<ElementElement, String>(){

                public String map(ElementElement item) {
                    return item.getName();
                }
            });
        }
        return this.fElementsMap.get(tagName);
    }

    private AttributeElement getAttribute(String tagName, String attributeName) {
        AttributeElement ae;
        if (this.fAttributesMap == null) {
            List<AttributeElement> attrs = this.fQueryHelper.getAttributes();
            this.fAttributesMap = CollectionsUtil.mapFromValues(attrs, (IMap)new IMap<AttributeElement, String>(){

                public String map(AttributeElement item) {
                    String element = item.getElement();
                    if (StringUtil.isEmpty((String)element)) {
                        return item.getName();
                    }
                    return String.valueOf(element) + "_" + item.getName();
                }
            });
        }
        if ((ae = this.fAttributesMap.get(String.valueOf(tagName.toLowerCase()) + "_" + attributeName)) != null) {
            return ae;
        }
        return this.fAttributesMap.get(attributeName);
    }

    private Collection<IProblem> validateDoctype(String sourcePath, IDocument doc) {
        String source = doc.get();
        int doctypeIndex = source.indexOf("<!DOCTYPE");
        if (doctypeIndex == -1) {
            return CollectionsUtil.newList((Object[])new IProblem[]{this.createWarning(Messages.HTMLTidyValidator_MissingDoctype, 1, 0, 0, sourcePath)});
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>(2);
        try {
            String before;
            Matcher m = DOCTYPE_PATTERN.matcher(source);
            if (m.find()) {
                String rest = m.group(2);
                if (!StringUtil.isEmpty((String)rest)) {
                    String publicStr;
                    String systemStr = m.group(4);
                    if (systemStr != null) {
                        int offsetUppercase = m.start(4);
                        if (!systemStr.equals("SYSTEM")) {
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_UppercaseDoctype, doc.getLineOfOffset(offsetUppercase) + 1, offsetUppercase, 6, sourcePath));
                        }
                    }
                    if ((publicStr = m.group(5)) != null) {
                        int offsetUppercase = m.start(5);
                        if (!publicStr.equals("PUBLIC")) {
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_UppercaseDoctype, doc.getLineOfOffset(offsetUppercase) + 1, offsetUppercase, 6, sourcePath));
                        }
                        String w3cStr = m.group(6);
                        offsetUppercase = m.start(6);
                        if (!w3cStr.equals("W3C")) {
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_UppercaseDoctype, doc.getLineOfOffset(offsetUppercase) + 1, offsetUppercase, 3, sourcePath));
                        }
                        String dtdStr = m.group(7);
                        offsetUppercase = m.start(7);
                        if (!dtdStr.equals("DTD")) {
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_UppercaseDoctype, doc.getLineOfOffset(offsetUppercase) + 1, offsetUppercase, 3, sourcePath));
                        }
                        String enStr = m.group(8);
                        offsetUppercase = m.start(8);
                        if (!enStr.equals("EN")) {
                            problems.add(this.createWarning(Messages.HTMLTidyValidator_UppercaseDoctype, doc.getLineOfOffset(offsetUppercase) + 1, offsetUppercase, 2, sourcePath));
                        }
                    }
                }
            } else {
                problems.add(this.createWarning(Messages.HTMLTidyValidator_MalformedDoctype, doc.getLineOfOffset(doctypeIndex) + 1, doctypeIndex, 9, sourcePath));
            }
            if (!StringUtil.isEmpty((String)(before = source.substring(0, doctypeIndex)))) {
                problems.add(this.createWarning(Messages.HTMLTidyValidator_DoctypeAfterElements, doc.getLineOfOffset(doctypeIndex) + 1, doctypeIndex, 9, sourcePath));
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return problems;
    }
}

