/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.customizations.app_engine.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.customizations.app_engine.wizards.AppEngineConfigWizardPage;
import org.python.pydev.customizations.app_engine.wizards.AppEngineTemplatePage;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.NewProjectNameAndLocationWizardPage;
import org.python.pydev.ui.wizards.project.PythonProjectWizard;

public class AppEngineWizard
extends PythonProjectWizard {
    private AppEngineConfigWizardPage appEngineConfigWizardPage;
    private AppEngineTemplatePage appEngineTemplatePage;

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
        this.appEngineConfigWizardPage = new AppEngineConfigWizardPage("Goole App Engine Page");
        this.appEngineConfigWizardPage.setTitle("Google App Engine");
        this.appEngineConfigWizardPage.setDescription("Set Google App Engine Configuration");
        this.addPage((IWizardPage)this.appEngineConfigWizardPage);
        this.appEngineTemplatePage = new AppEngineTemplatePage("Initial Structure");
        this.addPage((IWizardPage)this.appEngineTemplatePage);
    }

    protected IWizardNewProjectNameAndLocationPage createProjectPage() {
        return new NewProjectNameAndLocationWizardPage("Setting project properties");
    }

    protected void createAndConfigProject(IProject newProjectHandle, IProjectDescription description, String projectType, String projectInterpreter, IProgressMonitor monitor, Object ... additionalArgsToConfigProject) throws CoreException {
        IProject sourceFolder;
        ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback = new ICallback<List<IContainer>, IProject>(){

            public List<IContainer> call(IProject projectHandle) {
                int sourceFolderConfigurationStyle = AppEngineWizard.this.projectPage.getSourceFolderConfigurationStyle();
                switch (sourceFolderConfigurationStyle) {
                    case 1: {
                        ArrayList<IContainer> ret = new ArrayList<IContainer>();
                        ret.add((IContainer)projectHandle);
                        return ret;
                    }
                    case 2: {
                        return new ArrayList<IContainer>();
                    }
                }
                IFolder folder = projectHandle.getFolder("src");
                ArrayList<IContainer> ret = new ArrayList<IContainer>();
                ret.add((IContainer)folder);
                return ret;
            }
        };
        ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback = new ICallback<List<String>, IProject>(){

            public List<String> call(IProject projectHandle) {
                return AppEngineWizard.this.appEngineConfigWizardPage.getExternalSourceFolders();
            }
        };
        ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback = new ICallback<Map<String, String>, IProject>(){

            public Map<String, String> call(IProject projectHandle) {
                return AppEngineWizard.this.appEngineConfigWizardPage.getVariableSubstitution();
            }
        };
        PyStructureConfigHelpers.createPydevProject((IProjectDescription)description, (IProject)newProjectHandle, (IProgressMonitor)monitor, (String)projectType, (String)projectInterpreter, (ICallback)getSourceFolderHandlesCallback, (ICallback)getExternalSourceFolderHandlesCallback, (ICallback)getVariableSubstitutionCallback);
        int sourceFolderConfigurationStyle = this.projectPage.getSourceFolderConfigurationStyle();
        switch (sourceFolderConfigurationStyle) {
            case 1: 
            case 2: {
                sourceFolder = newProjectHandle;
                break;
            }
            default: {
                sourceFolder = newProjectHandle.getFolder("src");
            }
        }
        this.appEngineTemplatePage.fillSourceFolder((IContainer)sourceFolder);
    }
}

