/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core.build;

import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.index.core.IndexPlugin;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParseStateCacheKey;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseRootNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildContext {
    public static final IContentType[] NO_CONTENT_TYPES = new IContentType[0];
    private IFile file;
    protected Map<String, Collection<IProblem>> problems = new HashMap<String, Collection<IProblem>>();
    private IParseStateCacheKey fParseStateCacheKey;
    private ParseResult fParseResult;
    private String fContents;

    protected BuildContext() {
    }

    public BuildContext(IFile file) {
        this();
        this.file = file;
    }

    public IProject getProject() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public IFile getFile() {
        return this.file;
    }

    public URI getURI() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getLocationURI();
    }

    public IParseRootNode getAST() throws CoreException {
        return this.getAST((IParseState)new ParseState(this.getContents())).getRootNode();
    }

    public synchronized ParseResult getAST(IParseState parseState) throws CoreException {
        try {
            String contentType = this.getContentType();
            IParseStateCacheKey newCacheKey = parseState.getCacheKey(contentType);
            if (this.fParseResult != null && this.fParseStateCacheKey != null && !this.fParseStateCacheKey.requiresReparse(newCacheKey)) {
                ParseResult parseResult = this.fParseResult;
                return parseResult;
            }
            this.fParseStateCacheKey = newCacheKey;
            try {
                WorkingParseResult working = new WorkingParseResult();
                this.fParseResult = this.parse(contentType, parseState, working);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.index.core", e.getMessage(), (Throwable)e));
            }
            if (this.fParseResult == null) {
                ParseResult parseResult = ParseResult.EMPTY;
                return parseResult;
            }
            ParseResult parseResult = this.fParseResult;
            return parseResult;
        }
        finally {
            if (parseState != null) {
                parseState.clearEditState();
            }
        }
    }

    protected ParseResult parse(String contentType, IParseState parseState, WorkingParseResult working) throws Exception {
        return ParserPoolFactory.parse((String)contentType, (IParseState)parseState);
    }

    public synchronized void resetAST() {
        this.fParseResult = null;
        this.fParseStateCacheKey = null;
    }

    public synchronized String getContents() {
        if (this.fContents == null) {
            try {
                this.fContents = IOUtil.read((InputStream)this.openInputStream((IProgressMonitor)new NullProgressMonitor()), (String)this.getCharset());
            }
            catch (CoreException coreException) {
                this.fContents = "";
            }
        }
        return this.fContents;
    }

    public String getCharset() throws CoreException {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getCharset(true);
    }

    public String getContentType() throws CoreException {
        Object[] types = this.getContentTypes();
        if (ArrayUtil.isEmpty((Object[])types)) {
            return null;
        }
        return types[0].getId();
    }

    protected IContentType[] getContentTypes() throws CoreException {
        IProject theProject = this.getProject();
        if (theProject != null) {
            IContentTypeMatcher matcher = theProject.getContentTypeMatcher();
            return matcher.findContentTypesFor(this.getName());
        }
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (ArrayUtil.isEmpty((Object[])projects)) {
            return Platform.getContentTypeManager().findContentTypesFor(this.getName());
        }
        Object[] objectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Object project = objectArray[n2];
            try {
                IContentType[] type = project.getContentTypeMatcher().findContentTypesFor(this.getName());
                if (type != null) {
                    return type;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        return NO_CONTENT_TYPES;
    }

    public String getName() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public void removeProblems(String markerType) {
        this.problems.remove(markerType);
    }

    public void putProblems(String markerType, Collection<IProblem> problems) {
        this.problems.put(markerType, problems);
    }

    public Map<String, Collection<IProblem>> getProblems() {
        return Collections.unmodifiableMap(this.problems);
    }

    public Collection<IParseError> getParseErrors() {
        if (this.fParseResult == null) {
            return Collections.emptyList();
        }
        return this.fParseResult.getErrors();
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws CoreException {
        IFile file = this.getFile();
        if (file == null) {
            return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
        }
        file.refreshLocal(0, null);
        if (!file.exists()) {
            return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
        }
        return file.getContents();
    }
}

