/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.index.core;

import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.aptana.internal.index.core.MemoryIndex;
import com.aptana.internal.index.core.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskIndex {
    private static final String SIGNATURE = "INDEX VERSION 0.1";
    private static final int CHUNK_SIZE = 100;
    private static final int RE_INDEXED = -1;
    private static final int DELETED = -2;
    private static final boolean DEBUG = true;
    public File indexFile;
    private int headerInfoOffset;
    private int streamRead;
    private int numberOfChunks;
    private int sizeOfLastChunk;
    private int documentReferenceSize;
    private char separator = (char)47;
    private int[] chunkOffsets;
    private int startOfCategoryTables;
    private Map<String, Integer> categoryOffsets;
    private Map<String, Integer> categoryEnds;
    private Map<String, Map<String, Object>> categoryTables;
    private int streamEnd;
    private String[][] cachedChunks;
    private String[] categoriesToDiscard;

    public DiskIndex(String fileName) {
        this.indexFile = new File(fileName);
        this.headerInfoOffset = -1;
        this.numberOfChunks = -1;
        this.sizeOfLastChunk = -1;
        this.chunkOffsets = null;
        this.documentReferenceSize = -1;
        this.categoryTables = null;
        this.categoryOffsets = null;
        this.categoryEnds = null;
        this.categoriesToDiscard = null;
    }

    public Set<String> addDocumentNames(String substring, MemoryIndex memoryIndex) throws IOException {
        List<String> docNames = this.readAllDocumentNames();
        HashSet<String> results = new HashSet<String>(docNames.size());
        if (substring == null) {
            if (memoryIndex == null) {
                return new HashSet<String>(docNames);
            }
            Map<String, Map<String, Set<String>>> docsToRefs = memoryIndex.getDocumentsToReferences();
            for (String docName : docNames) {
                if (docsToRefs.containsKey(docName)) continue;
                results.add(docName);
            }
        } else if (memoryIndex == null) {
            for (String docName : docNames) {
                if (!docName.startsWith(substring, 0)) continue;
                results.add(docName);
            }
        } else {
            Map<String, Map<String, Set<String>>> docsToRefs = memoryIndex.getDocumentsToReferences();
            for (String docName : docNames) {
                if (!docName.startsWith(substring, 0) || docsToRefs.containsKey(docName)) continue;
                results.add(docName);
            }
        }
        return results;
    }

    private Map<String, QueryResult> addQueryResult(Map<String, QueryResult> results, String word, Map<String, Object> wordsToDocNumbers, MemoryIndex memoryIndex) throws IOException {
        if (results == null) {
            results = new HashMap<String, QueryResult>(13);
        }
        QueryResult result = results.get(word);
        if (memoryIndex == null) {
            if (result == null) {
                result = new QueryResult(word, null);
                results.put(word, result);
            }
            result.addDocumentTable(wordsToDocNumbers);
            List<Integer> docNumbers = this.readDocumentNumbers(wordsToDocNumbers.get(word));
            for (Integer docNumber : docNumbers) {
                result.addDocumentName(this.readDocumentName(docNumber));
            }
        } else {
            Map<String, Map<String, Set<String>>> docsToRefs = memoryIndex.getDocumentsToReferences();
            if (result == null) {
                result = new QueryResult(word, null);
            }
            List<Integer> docNumbers = this.readDocumentNumbers(wordsToDocNumbers.get(word));
            for (Integer docNumber : docNumbers) {
                String docName = this.readDocumentName(docNumber);
                if (docsToRefs.containsKey(docName)) continue;
                result.addDocumentName(docName);
            }
            if (!result.isEmpty()) {
                results.put(word, result);
            }
        }
        return results;
    }

    public Map<String, QueryResult> addQueryResults(String[] categories, String key, int matchRule, MemoryIndex memoryIndex) throws IOException {
        if (this.categoryOffsets == null) {
            return null;
        }
        Map<String, QueryResult> results = null;
        if ((matchRule == 1 || matchRule == 9) && "".equals(key)) {
            key = null;
        } else if ((matchRule == 2 || matchRule == 10) && "*".equals(key)) {
            key = null;
        }
        if (key == null) {
            int i = 0;
            int l = categories.length;
            while (i < l) {
                Map<String, Object> wordsToDocNumbers = this.readCategoryTable(categories[i], true);
                if (wordsToDocNumbers != null) {
                    if (results == null) {
                        results = new HashMap<String, QueryResult>(wordsToDocNumbers.size());
                    }
                    for (String word : wordsToDocNumbers.keySet()) {
                        if (word == null) continue;
                        results = this.addQueryResult(results, word, wordsToDocNumbers, memoryIndex);
                    }
                }
                ++i;
            }
            if (results != null && this.cachedChunks == null) {
                this.cacheDocumentNames();
            }
        } else {
            switch (matchRule) {
                case 8: {
                    int i = 0;
                    int l = categories.length;
                    while (i < l) {
                        Map<String, Object> wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                        if (wordsToDocNumbers != null && wordsToDocNumbers.containsKey(key)) {
                            results = this.addQueryResult(results, key, wordsToDocNumbers, memoryIndex);
                        }
                        ++i;
                    }
                    break;
                }
                case 9: {
                    int i = 0;
                    int l = categories.length;
                    while (i < l) {
                        Map<String, Object> wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                        if (wordsToDocNumbers != null) {
                            for (String word : wordsToDocNumbers.keySet()) {
                                if (word == null || !word.startsWith(key)) continue;
                                results = this.addQueryResult(results, word, wordsToDocNumbers, memoryIndex);
                            }
                        }
                        ++i;
                    }
                    break;
                }
                default: {
                    int i = 0;
                    int l = categories.length;
                    while (i < l) {
                        Map<String, Object> wordsToDocNumbers = this.readCategoryTable(categories[i], false);
                        if (wordsToDocNumbers != null) {
                            for (String word : wordsToDocNumbers.keySet()) {
                                if (word == null || !Index.isMatch(key, word, matchRule)) continue;
                                results = this.addQueryResult(results, word, wordsToDocNumbers, memoryIndex);
                            }
                        }
                        ++i;
                    }
                    break block0;
                }
            }
        }
        return results;
    }

    private void cacheDocumentNames() throws IOException {
        this.cachedChunks = new String[this.numberOfChunks][];
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.indexFile));
        try {
            try {
                int offset = this.chunkOffsets[0];
                this.skip(stream, offset);
                int i = 0;
                while (i < this.numberOfChunks) {
                    int size = i == this.numberOfChunks - 1 ? this.sizeOfLastChunk : 100;
                    this.cachedChunks[i] = new String[size];
                    this.readChunk(this.cachedChunks[i], stream, 0, size);
                    ++i;
                }
            }
            catch (IOException e) {
                this.cachedChunks = null;
                throw e;
            }
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    private List<String> computeDocumentNames(List<String> onDiskNames, int[] positions, Map<String, Integer> indexedDocuments, MemoryIndex memoryIndex) {
        int onDiskLength = onDiskNames.size();
        Map<String, Map<String, Set<String>>> memIndexDocs = memoryIndex.getDocumentsToReferences();
        if (onDiskLength == 0) {
            for (Map.Entry<String, Map<String, Set<String>>> entry : memIndexDocs.entrySet()) {
                Map<String, Set<String>> refTable = entry.getValue();
                if (refTable == null) continue;
                indexedDocuments.put(entry.getKey(), null);
            }
            ArrayList<String> newDocNames = new ArrayList<String>(indexedDocuments.size());
            Set<String> added = indexedDocuments.keySet();
            for (String adddedString : added) {
                if (adddedString == null) continue;
                newDocNames.add(adddedString);
            }
            Collections.sort(newDocNames);
            int i = 0;
            int l = newDocNames.size();
            while (i < l) {
                indexedDocuments.put((String)newDocNames.get(i), new Integer(i));
                ++i;
            }
            return newDocNames;
        }
        int i = 0;
        while (i < onDiskLength) {
            positions[i] = i;
            ++i;
        }
        int numDeletedDocNames = 0;
        block8: for (Map.Entry<String, Map<String, Set<String>>> entry : memIndexDocs.entrySet()) {
            String docName = entry.getKey();
            if (docName == null) continue;
            int j = 0;
            while (j < onDiskLength) {
                if (docName.equals(onDiskNames.get(j))) {
                    if (entry.getValue() == null) {
                        positions[j] = -2;
                        ++numDeletedDocNames;
                        continue block8;
                    }
                    positions[j] = -1;
                    continue block8;
                }
                ++j;
            }
            if (entry.getValue() == null) continue;
            indexedDocuments.put(docName, null);
        }
        List<String> newDocNames = onDiskNames;
        if (numDeletedDocNames > 0 || indexedDocuments.size() > 0) {
            newDocNames = new ArrayList<String>(onDiskLength + indexedDocuments.size() - numDeletedDocNames);
            int i2 = 0;
            while (i2 < onDiskLength) {
                if (positions[i2] >= -1) {
                    newDocNames.add(onDiskNames.get(i2));
                }
                ++i2;
            }
            Set<String> added = indexedDocuments.keySet();
            for (String addedString : added) {
                if (addedString == null) continue;
                newDocNames.add(addedString);
            }
            Collections.sort(newDocNames);
            int i3 = 0;
            int l = newDocNames.size();
            while (i3 < l) {
                if (indexedDocuments.containsKey(newDocNames.get(i3))) {
                    indexedDocuments.put(newDocNames.get(i3), new Integer(i3));
                }
                ++i3;
            }
        }
        int count = -1;
        int i4 = 0;
        block13: while (i4 < onDiskLength) {
            switch (positions[i4]) {
                case -2: {
                    ++i4;
                    break;
                }
                case -1: {
                    String newName = newDocNames.get(++count);
                    if (!newName.equals(onDiskNames.get(i4))) continue block13;
                    indexedDocuments.put(newName, new Integer(count));
                    ++i4;
                    break;
                }
                default: {
                    if (!newDocNames.get(++count).equals(onDiskNames.get(i4))) continue block13;
                    positions[i4++] = count;
                }
            }
        }
        return newDocNames;
    }

    private void copyQueryResults(Map<String, Set<String>> categoryToWords, int newPosition) {
        for (Map.Entry<String, Set<String>> entry : categoryToWords.entrySet()) {
            String categoryName = entry.getKey();
            if (categoryName == null) continue;
            Map<String, Object> wordsToDocs = this.categoryTables.get(categoryName);
            if (wordsToDocs == null) {
                wordsToDocs = new HashMap<String, Object>();
                this.categoryTables.put(categoryName, wordsToDocs);
            }
            for (String word : entry.getValue()) {
                if (word == null) continue;
                ArrayList positions = wordsToDocs.get(word);
                if (positions == null) {
                    positions = new ArrayList();
                    wordsToDocs.put(word, positions);
                }
                ((List)positions).add(newPosition);
            }
        }
    }

    public List<String> getCategories() {
        List<String> result = this.categoryOffsets == null ? Collections.emptyList() : new ArrayList<String>(this.categoryOffsets.keySet());
        return result;
    }

    public List<String> getDocuments() {
        List<String> result = Collections.emptyList();
        try {
            result = this.readAllDocumentNames();
        }
        catch (IOException iOException) {}
        return result;
    }

    public void initialize(boolean reuseExistingFile) throws IOException {
        if (this.indexFile.exists()) {
            if (reuseExistingFile) {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.indexFile));
                try {
                    this.streamRead = 0;
                    String signature = this.readString(stream);
                    if (!signature.equals(SIGNATURE)) {
                        throw new IOException(Messages.DiskIndex_Wrong_Format);
                    }
                    this.headerInfoOffset = this.readStreamInt(stream);
                    if (this.headerInfoOffset > 0) {
                        this.skip(stream, this.headerInfoOffset - this.streamRead);
                        this.readHeaderInfo(stream);
                    }
                }
                finally {
                    ((InputStream)stream).close();
                }
                return;
            }
            if (!this.indexFile.delete()) {
                System.out.println("initialize - Failed to delete index " + this.indexFile);
                throw new IOException("Failed to delete index " + this.indexFile);
            }
        }
        if (this.indexFile.createNewFile()) {
            FileOutputStream stream = new FileOutputStream(this.indexFile, false);
            try {
                this.writeString(stream, SIGNATURE);
                stream.write(-1);
            }
            finally {
                stream.close();
            }
        } else {
            System.out.println("initialize - Failed to create new index " + this.indexFile);
            throw new IOException(String.valueOf(Messages.DiskIndex_Unable_To_Create_Index_File) + this.indexFile);
        }
    }

    private void initializeFrom(DiskIndex diskIndex, File newIndexFile) throws IOException {
        if (newIndexFile.exists() && !newIndexFile.delete()) {
            System.out.println("initializeFrom - Failed to delete temp index " + this.indexFile);
        } else if (!newIndexFile.createNewFile()) {
            System.out.println("initializeFrom - Failed to create temp index " + this.indexFile);
            throw new IOException("Failed to create temp index " + this.indexFile);
        }
        int size = diskIndex.categoryOffsets == null ? 8 : diskIndex.categoryOffsets.size();
        this.categoryOffsets = new HashMap<String, Integer>(size);
        this.categoryEnds = new HashMap<String, Integer>(size);
        this.categoryTables = new HashMap<String, Map<String, Object>>(size);
        this.separator = diskIndex.separator;
        this.categoriesToDiscard = diskIndex.categoriesToDiscard;
    }

    private void mergeCategories(DiskIndex onDisk, int[] positions, OutputStream stream) throws IOException {
        Set<String> oldNames = onDisk.categoryOffsets.keySet();
        for (String oldName : oldNames) {
            if (oldName == null || this.categoryTables.containsKey(oldName)) continue;
            this.categoryTables.put(oldName, null);
        }
        Set<String> categoryNames = this.categoryTables.keySet();
        for (String categoryName : categoryNames) {
            if (categoryName == null) continue;
            this.mergeCategory(categoryName, onDisk, positions, stream);
        }
        this.categoryTables = null;
    }

    private void mergeCategory(String categoryName, DiskIndex onDisk, int[] positions, OutputStream stream) throws IOException {
        Map<String, Object> oldWordsToDocs;
        Map<String, Object> wordsToDocs = this.categoryTables.get(categoryName);
        if (wordsToDocs == null) {
            wordsToDocs = new HashMap<String, Object>(3);
        }
        if ((oldWordsToDocs = onDisk.readCategoryTable(categoryName, true)) != null) {
            for (Map.Entry<String, Object> entry : oldWordsToDocs.entrySet()) {
                String oldWord = entry.getKey();
                if (oldWord == null) continue;
                List oldDocNumbers = (List)entry.getValue();
                ArrayList<Integer> mappedNumbers = new ArrayList<Integer>(oldDocNumbers.size());
                for (Integer oldDocNumber : oldDocNumbers) {
                    int pos = positions[oldDocNumber];
                    if (pos <= -1) continue;
                    mappedNumbers.add(pos);
                }
                if (mappedNumbers.isEmpty()) continue;
                Object o = wordsToDocs.get(oldWord);
                if (o == null) {
                    wordsToDocs.put(oldWord, mappedNumbers);
                    continue;
                }
                ArrayList<Integer> list = null;
                if (o instanceof List) {
                    list = (ArrayList<Integer>)o;
                } else {
                    list = new ArrayList<Integer>();
                    wordsToDocs.put(oldWord, list);
                }
                list.addAll(mappedNumbers);
            }
            onDisk.categoryTables.put(categoryName, null);
        }
        this.writeCategoryTable(categoryName, wordsToDocs, stream);
    }

    public DiskIndex mergeWith(MemoryIndex memoryIndex) throws IOException {
        HashMap<String, Integer> indexedDocuments;
        List<String> names = this.readAllDocumentNames();
        int previousLength = names.size();
        int[] positions = new int[previousLength];
        if ((names = this.computeDocumentNames(names, positions, indexedDocuments = new HashMap<String, Integer>(3), memoryIndex)).isEmpty()) {
            if (previousLength == 0) {
                return this;
            }
            DiskIndex newDiskIndex = new DiskIndex(this.indexFile.getPath());
            newDiskIndex.initialize(false);
            return newDiskIndex;
        }
        this.streamEnd = 0;
        DiskIndex newDiskIndex = new DiskIndex(String.valueOf(this.indexFile.getPath()) + ".tmp");
        try {
            newDiskIndex.initializeFrom(this, newDiskIndex.indexFile);
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(newDiskIndex.indexFile, false));
            int offsetToHeader = -1;
            try {
                newDiskIndex.writeDocumentNames(stream, names);
                names = null;
                if (!indexedDocuments.isEmpty()) {
                    for (Map.Entry entry : indexedDocuments.entrySet()) {
                        if (entry.getKey() == null) continue;
                        newDiskIndex.copyQueryResults(memoryIndex.getCategoriesForDocument((String)entry.getKey()), (Integer)entry.getValue());
                    }
                }
                indexedDocuments = null;
                if (previousLength == 0) {
                    newDiskIndex.writeCategories(stream);
                } else {
                    newDiskIndex.mergeCategories(this, positions, stream);
                }
                offsetToHeader = newDiskIndex.streamEnd;
                newDiskIndex.writeHeaderInfo(stream);
                positions = null;
            }
            finally {
                ((OutputStream)stream).close();
            }
            newDiskIndex.writeOffsetToHeader(offsetToHeader);
            if (this.indexFile.exists() && !this.indexFile.delete()) {
                throw new IOException("Failed to delete index file " + this.indexFile);
            }
            if (!newDiskIndex.indexFile.renameTo(this.indexFile)) {
                throw new IOException("Failed to rename index file " + this.indexFile);
            }
        }
        catch (IOException e) {
            if (newDiskIndex.indexFile.exists() && !newDiskIndex.indexFile.delete()) {
                System.out.println("mergeWith - Failed to delete temp index " + newDiskIndex.indexFile);
            }
            throw e;
        }
        newDiskIndex.indexFile = this.indexFile;
        return newDiskIndex;
    }

    private int read(InputStream stream) throws IOException {
        int val = stream.read();
        ++this.streamRead;
        return val;
    }

    private synchronized List<String> readAllDocumentNames() throws IOException {
        if (this.numberOfChunks <= 0) {
            return Collections.emptyList();
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.indexFile));
        try {
            int offset = this.chunkOffsets[0];
            this.skip(stream, offset);
            int lastIndex = this.numberOfChunks - 1;
            String[] docNames = new String[lastIndex * 100 + this.sizeOfLastChunk];
            int i = 0;
            while (i < this.numberOfChunks) {
                this.readChunk(docNames, stream, i * 100, i < lastIndex ? 100 : this.sizeOfLastChunk);
                ++i;
            }
            List<String> list = Arrays.asList(docNames);
            return list;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    private synchronized Map<String, Object> readCategoryTable(String categoryName, boolean readDocNumbers) throws IOException {
        Integer offset = this.categoryOffsets.get(categoryName);
        if (offset == null) {
            return null;
        }
        if (this.categoryTables == null) {
            this.categoryTables = new HashMap<String, Map<String, Object>>(3);
        } else {
            Map<String, Object> cachedTable = this.categoryTables.get(categoryName);
            if (cachedTable != null) {
                if (readDocNumbers) {
                    HashMap<String, Object> copy = new HashMap<String, Object>(cachedTable);
                    for (Map.Entry<String, Object> entry : cachedTable.entrySet()) {
                        Object arrayOffset = entry.getValue();
                        if (!(arrayOffset instanceof Integer)) continue;
                        copy.put(entry.getKey(), this.readDocumentNumbers(arrayOffset));
                    }
                    cachedTable = copy;
                }
                return cachedTable;
            }
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.indexFile));
        HashMap<String, Object> categoryTable = null;
        String[] matchingWords = null;
        int count = 0;
        int firstOffset = -1;
        try {
            this.skip(stream, offset.intValue());
            int size = this.readStreamInt(stream);
            try {
                if (size < 0) {
                    System.err.println("-------------------- DEBUG --------------------");
                    System.err.println("file = " + this.indexFile);
                    System.err.println("offset = " + offset);
                    System.err.println("size = " + size);
                    System.err.println("--------------------   END   --------------------");
                }
                categoryTable = new HashMap<String, Object>(size);
            }
            catch (OutOfMemoryError oom) {
                oom.printStackTrace();
                System.err.println("-------------------- DEBUG --------------------");
                System.err.println("file = " + this.indexFile);
                System.err.println("offset = " + offset);
                System.err.println("size = " + size);
                System.err.println("--------------------   END   --------------------");
                throw oom;
            }
            int largeArraySize = 256;
            int i = 0;
            while (i < size) {
                String word = this.readString(stream);
                int arrayOffset = this.readStreamInt(stream);
                if (arrayOffset <= 0) {
                    ArrayList<Integer> positions = new ArrayList<Integer>();
                    positions.add(-arrayOffset);
                    categoryTable.put(word, positions);
                } else if (arrayOffset < largeArraySize) {
                    categoryTable.put(word, this.readStreamDocumentArray(stream, arrayOffset));
                } else {
                    arrayOffset = this.readStreamInt(stream);
                    if (readDocNumbers) {
                        if (matchingWords == null) {
                            matchingWords = new String[size];
                        }
                        if (count == 0) {
                            firstOffset = arrayOffset;
                        }
                        matchingWords[count++] = word;
                    }
                    categoryTable.put(word, new Integer(arrayOffset));
                }
                ++i;
            }
            this.categoryTables.put(categoryName, categoryTable);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (matchingWords != null && count > 0) {
            stream = new BufferedInputStream(new FileInputStream(this.indexFile));
            try {
                this.skip(stream, firstOffset);
                int i = 0;
                while (i < count) {
                    categoryTable.put(matchingWords[i], this.readStreamDocumentArray(stream, this.readStreamInt(stream)));
                    ++i;
                }
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        return categoryTable;
    }

    private void readChunk(String[] docNames, InputStream stream, int index, int size) throws IOException {
        String current = this.readString(stream);
        docNames[index++] = current;
        int i = 1;
        while (i < size) {
            int length;
            int start = this.read(stream) & 0xFF;
            int end = this.read(stream) & 0xFF;
            String next = this.readString(stream);
            if (start > 0) {
                if (end > 0) {
                    length = current.length();
                    next = String.valueOf(current.substring(0, start)) + next + current.substring(length - end, length);
                } else {
                    next = String.valueOf(current.substring(0, start)) + next;
                }
            } else if (end > 0) {
                length = current.length();
                next = String.valueOf(next) + current.substring(length - end, length);
            }
            docNames[index++] = next;
            current = next;
            ++i;
        }
    }

    private synchronized String readDocumentName(int docNumber) throws IOException {
        int chunkNumber;
        String[] chunk;
        if (this.cachedChunks == null) {
            this.cachedChunks = new String[this.numberOfChunks][];
        }
        if ((chunk = this.cachedChunks[chunkNumber = docNumber / 100]) == null) {
            int start;
            boolean isLastChunk = chunkNumber == this.numberOfChunks - 1;
            int numberOfBytes = (isLastChunk ? this.startOfCategoryTables : this.chunkOffsets[chunkNumber + 1]) - (start = this.chunkOffsets[chunkNumber]);
            if (numberOfBytes < 0) {
                throw new IllegalArgumentException();
            }
            BufferedInputStream file = new BufferedInputStream(new FileInputStream(this.indexFile));
            try {
                this.skip(file, start);
                int numberOfNames = isLastChunk ? this.sizeOfLastChunk : 100;
                chunk = new String[numberOfNames];
                this.readChunk(chunk, file, 0, numberOfNames);
            }
            finally {
                ((InputStream)file).close();
            }
            this.cachedChunks[chunkNumber] = chunk;
        }
        return chunk[docNumber - chunkNumber * 100];
    }

    private synchronized List<Integer> readDocumentNumbers(Object arrayOffset) throws IOException {
        if (arrayOffset instanceof List) {
            return (List)arrayOffset;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.indexFile));
        try {
            int offset = (Integer)arrayOffset;
            this.skip(stream, offset);
            List<Integer> list = this.readStreamDocumentArray(stream, this.readStreamInt(stream));
            return list;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    private void readHeaderInfo(InputStream stream) throws IOException {
        this.numberOfChunks = this.readStreamInt(stream);
        if (this.numberOfChunks < 0) {
            throw new IOException(MessageFormat.format("Corrupt index file, reported {0} chunks", this.numberOfChunks));
        }
        this.sizeOfLastChunk = this.read(stream) & 0xFF;
        this.documentReferenceSize = this.read(stream) & 0xFF;
        this.separator = (char)(this.read(stream) & 0xFF);
        this.chunkOffsets = new int[this.numberOfChunks];
        int i = 0;
        while (i < this.numberOfChunks) {
            this.chunkOffsets[i] = this.readStreamInt(stream);
            ++i;
        }
        this.startOfCategoryTables = this.readStreamInt(stream);
        int size = this.readStreamInt(stream);
        this.categoryOffsets = new HashMap<String, Integer>(size);
        this.categoryEnds = new HashMap<String, Integer>(size);
        String previousCategory = null;
        int offset = -1;
        int i2 = 0;
        while (i2 < size) {
            String categoryName = this.readString(stream);
            offset = this.readStreamInt(stream);
            this.categoryOffsets.put(categoryName, offset);
            if (previousCategory != null) {
                this.categoryEnds.put(previousCategory, offset);
            }
            previousCategory = categoryName;
            ++i2;
        }
        if (previousCategory != null) {
            this.categoryEnds.put(previousCategory, this.headerInfoOffset);
        }
        this.categoryTables = new HashMap<String, Map<String, Object>>(3);
    }

    private List<Integer> readStreamDocumentArray(InputStream stream, int arraySize) throws IOException {
        if (arraySize == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < arraySize) {
            int value = 0;
            switch (this.documentReferenceSize) {
                case 1: {
                    value = this.read(stream) & 0xFF;
                    break;
                }
                case 2: {
                    value = (this.read(stream) & 0xFF) << 8;
                    value += this.read(stream) & 0xFF;
                    break;
                }
                default: {
                    value = this.readStreamInt(stream);
                }
            }
            indexes.add(value);
            ++i;
        }
        return indexes;
    }

    private int readStreamInt(InputStream stream) throws IOException {
        int val = (this.read(stream) & 0xFF) << 24;
        val += (this.read(stream) & 0xFF) << 16;
        return (val += (this.read(stream) & 0xFF) << 8) + (this.read(stream) & 0xFF);
    }

    private String readString(InputStream stream) throws IOException {
        int length = (this.read(stream) & 0xFF) << 8;
        char[] word = new char[length += this.read(stream) & 0xFF];
        int i = 0;
        while (i < length) {
            byte b = (byte)this.read(stream);
            switch (b & 0xF0) {
                case 0: 
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: 
                case 96: 
                case 112: {
                    word[i++] = (char)b;
                    break;
                }
                case 192: 
                case 208: {
                    char next = (char)this.read(stream);
                    if ((next & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    char ch = (char)((b & 0x1F) << 6);
                    ch = (char)(ch | next & 0x3F);
                    word[i++] = ch;
                    break;
                }
                case 224: {
                    char first = (char)this.read(stream);
                    char second = (char)this.read(stream);
                    if ((first & second & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    char ch = (char)((b & 0xF) << 12);
                    ch = (char)(ch | (first & 0x3F) << 6);
                    ch = (char)(ch | second & 0x3F);
                    word[i++] = ch;
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(word);
    }

    public DiskIndex removeCategories(String[] categoryNames, MemoryIndex memoryIndex) throws IOException {
        this.categoriesToDiscard = categoryNames;
        DiskIndex newIndex = this.mergeWith(memoryIndex);
        newIndex.categoriesToDiscard = null;
        return newIndex;
    }

    private long skip(InputStream stream, long n) throws IOException {
        long wantToSkip = n;
        long actuallySkipped = 0L;
        while (n > 0L) {
            long skipped = stream.skip(n);
            n -= skipped;
            if ((actuallySkipped += skipped) == wantToSkip) {
                return actuallySkipped;
            }
            int read = stream.read();
            if (read == -1) {
                return actuallySkipped;
            }
            --n;
            ++actuallySkipped;
        }
        return actuallySkipped;
    }

    private void writeCategories(OutputStream stream) throws IOException {
        for (Map.Entry<String, Map<String, Object>> entry : this.categoryTables.entrySet()) {
            String categoryName = entry.getKey();
            if (categoryName == null) continue;
            this.writeCategoryTable(categoryName, entry.getValue(), stream);
        }
        this.categoryTables = null;
    }

    private void writeCategoryTable(String categoryName, Map<String, Object> wordsToDocs, OutputStream stream) throws IOException {
        if (this.categoriesToDiscard != null) {
            String[] stringArray = this.categoriesToDiscard;
            int n = this.categoriesToDiscard.length;
            int n2 = 0;
            while (n2 < n) {
                Object categoryToDiscard = stringArray[n2];
                if (categoryName.equals(categoryToDiscard)) {
                    return;
                }
                ++n2;
            }
        }
        HashMap<String, Integer> longArrays = new HashMap<String, Integer>();
        int largeArraySize = 256;
        for (Map.Entry entry : wordsToDocs.entrySet()) {
            List docNumbers = (List)entry.getValue();
            if (docNumbers.size() < largeArraySize) continue;
            longArrays.put((String)entry.getKey(), new Integer(this.streamEnd));
            this.writeDocumentNumbers(docNumbers, stream);
        }
        this.categoryOffsets.put(categoryName, this.streamEnd);
        this.categoryTables.put(categoryName, null);
        this.writeStreamInt(stream, wordsToDocs.size());
        for (Map.Entry entry : wordsToDocs.entrySet()) {
            this.writeString(stream, (String)entry.getKey());
            if (longArrays.containsKey(entry.getKey())) {
                this.writeStreamInt(stream, largeArraySize);
                this.writeStreamInt(stream, (Integer)longArrays.get(entry.getKey()));
                continue;
            }
            List documentNumbers = (List)entry.getValue();
            if (documentNumbers.size() == 1) {
                this.writeStreamInt(stream, -((Integer)documentNumbers.get(0)).intValue());
                continue;
            }
            this.writeDocumentNumbers(documentNumbers, stream);
        }
    }

    private void writeDocumentNames(OutputStream stream, List<String> sortedDocNames) throws IOException {
        this.writeString(stream, SIGNATURE);
        this.headerInfoOffset = this.streamEnd;
        this.writeStreamInt(stream, -1);
        int size = sortedDocNames.size();
        this.numberOfChunks = size / 100 + 1;
        this.sizeOfLastChunk = size % 100;
        if (this.sizeOfLastChunk == 0) {
            --this.numberOfChunks;
            this.sizeOfLastChunk = 100;
        }
        this.documentReferenceSize = size <= 127 ? 1 : (size <= Short.MAX_VALUE ? 2 : 4);
        this.chunkOffsets = new int[this.numberOfChunks];
        int lastIndex = this.numberOfChunks - 1;
        int i = 0;
        while (i < this.numberOfChunks) {
            this.chunkOffsets[i] = this.streamEnd;
            int chunkSize = i == lastIndex ? this.sizeOfLastChunk : 100;
            int chunkIndex = i * 100;
            String current = sortedDocNames.get(chunkIndex);
            this.writeString(stream, current);
            int j = 1;
            while (j < chunkSize) {
                int len2;
                String next = sortedDocNames.get(chunkIndex + j);
                int len1 = current.length();
                int max = len1 < (len2 = next.length()) ? len1 : len2;
                int start = 0;
                while (current.charAt(start) == next.charAt(start)) {
                    if (max == ++start) break;
                }
                if (start > 255) {
                    start = 255;
                }
                int end = 0;
                while (current.charAt(--len1) == next.charAt(--len2)) {
                    ++end;
                    if (len2 == start || len1 == 0) break;
                }
                if (end > 255) {
                    end = 255;
                }
                stream.write((byte)start);
                stream.write((byte)end);
                this.streamEnd += 2;
                int last = next.length() - end;
                this.writeString(stream, start < last ? next.substring(start, last) : "");
                current = next;
                ++j;
            }
            ++i;
        }
        this.startOfCategoryTables = this.streamEnd + 1;
    }

    private void writeDocumentNumbers(List<Integer> documentNumbers, OutputStream stream) throws IOException {
        int length = documentNumbers.size();
        this.writeStreamInt(stream, length);
        Collections.sort(documentNumbers);
        for (Integer docNumber : documentNumbers) {
            int value = docNumber;
            switch (this.documentReferenceSize) {
                case 1: {
                    stream.write((byte)value);
                    ++this.streamEnd;
                    break;
                }
                case 2: {
                    stream.write((byte)(value >> 8));
                    stream.write((byte)value);
                    this.streamEnd += 2;
                    break;
                }
                default: {
                    this.writeStreamInt(stream, value);
                }
            }
        }
        stream.flush();
    }

    private void writeHeaderInfo(OutputStream stream) throws IOException {
        this.writeStreamInt(stream, this.numberOfChunks);
        stream.write((byte)this.sizeOfLastChunk);
        stream.write((byte)this.documentReferenceSize);
        stream.write((byte)this.separator);
        this.streamEnd += 3;
        int i = 0;
        while (i < this.numberOfChunks) {
            this.writeStreamInt(stream, this.chunkOffsets[i]);
            ++i;
        }
        this.writeStreamInt(stream, this.startOfCategoryTables);
        this.writeStreamInt(stream, this.categoryOffsets.size());
        for (Map.Entry<String, Integer> entry : this.categoryOffsets.entrySet()) {
            this.writeString(stream, entry.getKey());
            this.writeStreamInt(stream, entry.getValue());
        }
        stream.flush();
    }

    private void writeOffsetToHeader(int offsetToHeader) throws IOException {
        if (offsetToHeader > 0) {
            RandomAccessFile file = new RandomAccessFile(this.indexFile, "rw");
            try {
                file.seek(this.headerInfoOffset);
                file.writeInt(offsetToHeader);
                this.headerInfoOffset = offsetToHeader;
            }
            finally {
                file.close();
            }
        }
    }

    private void writeStreamInt(OutputStream stream, int val) throws IOException {
        stream.write((byte)(val >> 24));
        stream.write((byte)(val >> 16));
        stream.write((byte)(val >> 8));
        stream.write((byte)val);
        this.streamEnd += 4;
        stream.flush();
    }

    private void writeString(OutputStream stream, String signature) throws IOException {
        char[] array = signature.toCharArray();
        int length = array.length;
        stream.write((byte)(length >>> 8 & 0xFF));
        stream.write((byte)(length & 0xFF));
        this.streamEnd += 2;
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte b;
            char ch = cArray[n2];
            if ((ch & 0x7F) == ch) {
                stream.write((byte)ch);
                ++this.streamEnd;
            } else if ((ch & 0x7FF) == ch) {
                b = (byte)(ch >> 6);
                b = (byte)(b & 0x1F);
                b = (byte)(b | 0xC0);
                stream.write(b);
                ++this.streamEnd;
                b = (byte)(ch & 0x3F);
                b = (byte)(b | 0x80);
                stream.write(b);
                ++this.streamEnd;
            } else {
                b = (byte)(ch >> 12);
                b = (byte)(b & 0xF);
                b = (byte)(b | 0xE0);
                stream.write(b);
                ++this.streamEnd;
                b = (byte)(ch >> 6);
                b = (byte)(b & 0x3F);
                b = (byte)(b | 0x80);
                stream.write(b);
                ++this.streamEnd;
                b = (byte)(ch & 0x3F);
                b = (byte)(b | 0x80);
                stream.write(b);
                ++this.streamEnd;
            }
            ++n2;
        }
        stream.flush();
    }
}

