/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.internal.index.core;

import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryIndex {
    private static final int MERGE_THRESHOLD = 100;
    private HashMap<String, Map<String, Set<String>>> documentsToTable = new HashMap();

    public Set<String> addDocumentNames(String substring) {
        HashSet<String> results = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : this.documentsToTable.entrySet()) {
            if (substring == null) {
                if (entry.getValue() == null) continue;
                results.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == null || !entry.getKey().startsWith(substring, 0)) continue;
            results.add(entry.getKey());
        }
        return results;
    }

    public void addEntry(String category, String key, String filePath) {
        Set<String> words;
        Map<String, Set<String>> categoriesToWords = this.documentsToTable.get(filePath);
        if (categoriesToWords == null) {
            categoriesToWords = new HashMap<String, Set<String>>();
            this.documentsToTable.put(filePath, categoriesToWords);
        }
        if ((words = categoriesToWords.get(category)) == null) {
            words = new HashSet<String>();
            categoriesToWords.put(category, words);
        }
        words.add(key);
    }

    public Map<String, QueryResult> addQueryResults(String[] categories, String key, int matchRules, Map<String, QueryResult> results) {
        if (results == null) {
            results = new HashMap<String, QueryResult>();
        }
        for (Map.Entry<String, Map<String, Set<String>>> entry : this.documentsToTable.entrySet()) {
            Map<String, Set<String>> categoriesToWords = entry.getValue();
            if (categoriesToWords == null) continue;
            String[] stringArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                Set<String> words = categoriesToWords.get(category);
                if (words != null) {
                    if (matchRules == 8) {
                        if (words.contains(key)) {
                            QueryResult result = results.get(key);
                            if (result == null) {
                                result = new QueryResult(key);
                            }
                            result.addDocumentName(entry.getKey());
                            results.put(key, result);
                        }
                    } else {
                        for (String word : words) {
                            if (!Index.isMatch(key, word, matchRules)) continue;
                            QueryResult result = results.get(word);
                            if (result == null) {
                                result = new QueryResult(word);
                            }
                            result.addDocumentName(entry.getKey());
                            results.put(word, result);
                        }
                    }
                }
                ++n2;
            }
        }
        return results;
    }

    public List<String> getCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (Map<String, Set<String>> value : this.documentsToTable.values()) {
            if (value == null) continue;
            categories.addAll(value.keySet());
        }
        return new ArrayList<String>(categories);
    }

    Map<String, Set<String>> getCategoriesForDocument(String docname) {
        return this.documentsToTable.get(docname);
    }

    Map<String, Map<String, Set<String>>> getDocumentsToReferences() {
        return Collections.unmodifiableMap(this.documentsToTable);
    }

    public boolean hasChanged() {
        return this.numberOfChanges() > 0;
    }

    public boolean hasDocument(String documentName) {
        return this.documentsToTable.get(documentName) != null;
    }

    public int numberOfChanges() {
        return this.documentsToTable.size();
    }

    public void remove(String documentName) {
        this.documentsToTable.put(documentName, null);
    }

    public void removeCategories(String[] categoryNames) {
        for (Map<String, Set<String>> categoriesToWords : this.documentsToTable.values()) {
            if (categoriesToWords == null) continue;
            String[] stringArray = categoryNames;
            int n = categoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                categoriesToWords.remove(category);
                ++n2;
            }
        }
    }

    public boolean shouldMerge() {
        return this.numberOfChanges() >= 100;
    }
}

