/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.efs;

import com.aptana.core.io.efs.WorkspaceFileSystem;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EFSUtils {
    private EFSUtils() {
    }

    public static IFileStore getFileStore(IResource resource) {
        if (resource == null) {
            return null;
        }
        return WorkspaceFileSystem.getInstance().getStore(resource.getFullPath());
    }

    public static IFileStore getLocalFileStore(File file) {
        if (file == null) {
            return null;
        }
        return EFS.getLocalFileSystem().fromLocalFile(file);
    }

    public static IFileStore fromLocalFile(File file) {
        IFileStore fileStore = WorkspaceFileSystem.getInstance().fromLocalFile(file);
        if (fileStore == null) {
            fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        }
        return fileStore;
    }

    public static void setModificationTime(long modifiedTime, IFileStore destFile) throws CoreException {
        FileInfo fi = new FileInfo();
        fi.setLastModified(modifiedTime);
        destFile.putInfo((IFileInfo)fi, 2048, null);
    }

    public static IFileStore[] getFiles(IFileStore file, boolean recurse, boolean includeCloakedFiles) throws CoreException {
        return EFSUtils.getFiles(file, recurse, includeCloakedFiles, null);
    }

    public static String getAbsolutePath(IFileStore file) {
        URI uri;
        if (file != null && (uri = file.toURI()) != null) {
            return uri.getPath();
        }
        return null;
    }

    public static String getRelativePath(IFileStore parent, IFileStore file, Object obsoleted) {
        if (parent.equals(file) || parent.isParentOf(file)) {
            String rootFile = EFSUtils.getAbsolutePath(parent);
            String childFile = EFSUtils.getAbsolutePath(file);
            if (rootFile != null && childFile != null) {
                return childFile.substring(rootFile.length());
            }
        }
        return null;
    }

    public static IFileStore createFile(IFileStore sourceRoot, IFileStore sourceStore, IFileStore destinationRoot) {
        String relativePath = EFSUtils.getRelativePath(sourceRoot, sourceStore, null);
        if (relativePath != null) {
            return destinationRoot.getFileStore((IPath)new Path(relativePath));
        }
        return null;
    }

    public static String getRelativePath(IConnectionPoint point, IFileStore file, Object obsoleted) {
        try {
            return EFSUtils.getRelativePath(point.getRoot(), file, obsoleted);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IFileStore[] getFiles(IFileStore file, boolean recurse, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Object resource = file.getAdapter(IResource.class);
        if (resource != null && resource instanceof IContainer) {
            ((IResource)resource).refreshLocal(2, (IProgressMonitor)progress.newChild(10));
        }
        ArrayList<IFileStore> list = new ArrayList<IFileStore>();
        EFSUtils.getFiles(file, recurse, list, includeCloakedFiles, (IProgressMonitor)progress.newChild(90));
        return list.toArray(new IFileStore[list.size()]);
    }

    private static IFileStore[] getFiles(IFileStore[] files, boolean recurse, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFileStore> fileList = new ArrayList<IFileStore>();
        IFileStore[] iFileStoreArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore file = iFileStoreArray[n2];
            fileList.addAll(Arrays.asList(EFSUtils.getFiles(file, recurse, includeCloakedFiles, monitor)));
            ++n2;
        }
        return fileList.toArray(new IFileStore[fileList.size()]);
    }

    public static IFileStore[] getAllFiles(IFileStore[] files, boolean recurse, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFileStore> fileList = new ArrayList<IFileStore>();
        fileList.addAll(Arrays.asList(files));
        fileList.addAll(Arrays.asList(EFSUtils.getFiles(files, true, false, monitor)));
        return fileList.toArray(new IFileStore[fileList.size()]);
    }

    private static void getFiles(IFileStore file, boolean recurse, List<IFileStore> list, boolean includeCloakedFiles, IProgressMonitor monitor) throws CoreException {
        IFileStore[] children;
        if (file == null) {
            return;
        }
        if (monitor != null) {
            Policy.checkCanceled((IProgressMonitor)monitor);
        }
        if (EFSUtils.isFolder(file, monitor) && (children = file.childStores(0, monitor)) != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
            IFileStore[] iFileStoreArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                Policy.checkCanceled((IProgressMonitor)progress);
                boolean addingFile = false;
                if (includeCloakedFiles || !CloakingUtils.isFileCloaked(child)) {
                    list.add(child);
                    addingFile = true;
                }
                if (recurse && addingFile && EFSUtils.isFolder(child, (IProgressMonitor)progress)) {
                    EFSUtils.getFiles(child, recurse, list, includeCloakedFiles, (IProgressMonitor)progress.newChild(1));
                }
                ++n2;
            }
        }
    }

    private static boolean isFolder(IFileStore file, IProgressMonitor monitor) throws CoreException {
        IResource resource = (IResource)file.getAdapter(IResource.class);
        if (resource instanceof IContainer) {
            return true;
        }
        return !(resource instanceof IFile) && file.fetchInfo(0, monitor).isDirectory();
    }

    public static IPath getRelativePath(IConnectionPoint connectionPoint, IFileStore fileStore) throws CoreException {
        return EFSUtils.getRelativePath(connectionPoint.getRoot(), fileStore);
    }

    public static IPath getRelativePath(IFileStore parentFileStore, IFileStore childFileStore) {
        if (parentFileStore.isParentOf(childFileStore)) {
            IPath parentPath = Path.fromPortableString((String)parentFileStore.toURI().getPath());
            IPath childPath = Path.fromPortableString((String)childFileStore.toURI().getPath());
            return childPath.makeRelativeTo(parentPath);
        }
        return null;
    }
}

