/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.core.epl.IMemento;
import com.aptana.core.io.efs.WorkspaceFileSystem;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint15Constants;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class WorkspaceConnectionPoint
extends ConnectionPoint {
    public static final String TYPE = "workspace";
    private static final String ELEMENT_PATH = "path";
    private static IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private IPath path;

    public WorkspaceConnectionPoint() {
        super(TYPE);
    }

    WorkspaceConnectionPoint(IContainer resource) {
        super(TYPE);
        this.path = resource.getFullPath();
    }

    public Object getAdapter(Class adapter) {
        Object result;
        IContainer resource;
        if (IResource.class.isAssignableFrom(adapter) && (resource = this.getResource()) != null && (result = resource.getAdapter(adapter)) != null) {
            return result;
        }
        return super.getAdapter(adapter);
    }

    public URI getRootURI() {
        return WorkspaceFileSystem.getInstance().getStore(this.path).toURI();
    }

    public IFileStore getRoot() throws CoreException {
        return WorkspaceFileSystem.getInstance().getStore(this.path);
    }

    public IContainer getResource() {
        IResource resource = workspaceRoot.findMember(this.path);
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return null;
    }

    public void setResource(IContainer resource) {
        this.path = resource.getFullPath();
    }

    public IPath getPath() {
        return this.path;
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        IMemento child = memento.getChild(ELEMENT_PATH);
        if (child != null) {
            this.path = Path.fromPortableString((String)child.getTextData());
        }
    }

    protected void saveState(IMemento memento) {
        super.saveState(memento);
        memento.createChild(ELEMENT_PATH).putTextData(this.path.toPortableString());
    }

    public boolean load15Data(String data) {
        String[] items = data.split(IConnectionPoint15Constants.DELIMITER);
        if (items.length < 3) {
            return false;
        }
        if (items[0] == null || "".equals(items[0])) {
            return false;
        }
        this.setName(items[0]);
        if (items[1] == null || "".equals(items[1])) {
            return false;
        }
        IResource resource = workspaceRoot.findMember(items[1]);
        if (!(resource instanceof IContainer)) {
            return false;
        }
        this.setResource((IContainer)resource);
        this.setId(items[2]);
        return true;
    }
}

