/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.auth;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.auth.IAuthenticationManager;
import com.aptana.ide.core.io.auth.IAuthenticationPrompt;
import com.aptana.ide.core.io.auth.Messages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public final class AuthenticationManager
implements IAuthenticationManager {
    private static final String SECURITY_NODE = "com.aptana.core.io.auth";
    private static final String PROP_PASSWORD = "password";
    private static AuthenticationManager instance;
    private transient Map<String, char[]> sessionPasswords = new HashMap<String, char[]>();

    private AuthenticationManager() {
    }

    public static AuthenticationManager getInstance() {
        if (instance == null) {
            instance = new AuthenticationManager();
        }
        return instance;
    }

    public boolean hasPersistent(String authId) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences.nodeExists(authId)) {
            ISecurePreferences node = preferences.node(authId);
            return Arrays.asList(node.keys()).contains(PROP_PASSWORD);
        }
        return false;
    }

    public char[] getPassword(String authId) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences.nodeExists(authId)) {
            try {
                ISecurePreferences node = preferences.node(authId);
                String password = node.get(PROP_PASSWORD, null);
                if (password != null) {
                    return password.toCharArray();
                }
            }
            catch (StorageException e) {
                IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.AuthenticationManager_FailedGetSecurePreference, (Throwable)e);
            }
        }
        if (this.sessionPasswords.containsKey(authId)) {
            return this.sessionPasswords.get(authId);
        }
        return null;
    }

    public char[] promptPassword(String authId, String login, String title, String message) {
        IAuthenticationPrompt authPrompt = (IAuthenticationPrompt)Platform.getAdapterManager().getAdapter((Object)this, IAuthenticationPrompt.class);
        if (authPrompt == null && Platform.getAdapterManager().hasAdapter((Object)this, IAuthenticationPrompt.class.getName())) {
            authPrompt = (IAuthenticationPrompt)Platform.getAdapterManager().loadAdapter((Object)this, IAuthenticationPrompt.class.getName());
        }
        if (authPrompt != null && authPrompt.promptPassword(this, authId, login, title, message)) {
            return this.sessionPasswords.get(authId);
        }
        return null;
    }

    public void resetPassword(String authId) {
        ISecurePreferences preferences = this.getSecurePreferences();
        if (preferences.nodeExists(authId)) {
            ISecurePreferences node = preferences.node(authId);
            node.removeNode();
        }
        this.sessionPasswords.remove(authId);
    }

    public void setPassword(String authId, char[] password, boolean persistent) {
        ISecurePreferences node = this.getSecurePreferences().node(authId);
        try {
            this.sessionPasswords.remove(authId);
            if (password != null) {
                this.sessionPasswords.put(authId, password);
                if (persistent) {
                    node.put(PROP_PASSWORD, String.copyValueOf(password), true);
                } else {
                    node.removeNode();
                }
            }
            this.getSecurePreferences().flush();
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.AuthenticationManager_FailedSaveSecurePreference, (Throwable)e);
        }
    }

    private ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(SECURITY_NODE);
    }
}

