/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.downloader;

import com.aptana.ide.core.io.downloader.ContentDownloadRequest;
import com.aptana.ide.core.io.downloader.Messages;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadManager {
    private List<ContentDownloadRequest> downloads = new ArrayList<ContentDownloadRequest>();
    private List<String> completedDownloadsPaths = new ArrayList<String>();

    public void addURL(URL url) throws CoreException {
        if (url != null) {
            this.downloads.add(new ContentDownloadRequest(url));
        }
    }

    public void addURL(URL url, File saveTo) throws CoreException {
        if (url != null) {
            this.downloads.add(new ContentDownloadRequest(url, saveTo));
        }
    }

    public void addURLs(List<URL> urls) throws CoreException {
        if (urls != null) {
            for (URL url : urls) {
                if (url == null) continue;
                this.downloads.add(new ContentDownloadRequest(url));
            }
        }
    }

    public IStatus start(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DownloadManager_downloadngContent, (int)1000);
        try {
            if (this.downloads.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.download(subMonitor);
            IStatus iStatus = this.getStatus(monitor);
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    protected void download(SubMonitor monitor) {
        int workUnits = 1000 / this.downloads.size();
        Iterator<ContentDownloadRequest> iterator = this.downloads.iterator();
        while (iterator.hasNext()) {
            ContentDownloadRequest request = iterator.next();
            request.execute((IProgressMonitor)monitor.newChild(workUnits));
            if (request.getResult() != null && request.getResult().isOK()) {
                this.completedDownloadsPaths.add(request.getDownloadLocation());
                iterator.remove();
            }
            monitor.setWorkRemaining(this.downloads.size());
        }
    }

    public String[] getContentsLocations() {
        return this.completedDownloadsPaths.toArray(new String[this.completedDownloadsPaths.size()]);
    }

    private IStatus getStatus(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.downloads.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus result = new MultiStatus("com.aptana.core.io", 0, null, null);
        for (ContentDownloadRequest request : this.downloads) {
            IStatus failed = request.getResult();
            if (failed == null || failed.isOK()) continue;
            result.add(failed);
        }
        return result;
    }
}

