/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.CoreIOPlugin;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class CloakingUtils {
    public static void addCloakFileType(String filetype) {
        ArrayList<String> newList = new ArrayList<String>();
        String[] filetypes = CloakingUtils.getCloakedFileTypes();
        boolean found = false;
        String[] stringArray = filetypes;
        int n = filetypes.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (extension.equals(filetype)) {
                found = true;
            }
            newList.add(extension);
            ++n2;
        }
        if (!found) {
            newList.add(filetype);
        }
        CloakingUtils.setCloakedFileTypes(newList.toArray(new String[newList.size()]));
    }

    public static void removeCloakFileType(String filetype) {
        String[] filetypes;
        ArrayList<String> newList = new ArrayList<String>();
        String[] stringArray = filetypes = CloakingUtils.getCloakedFileTypes();
        int n = filetypes.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!extension.equals(filetype)) {
                newList.add(extension);
            }
            ++n2;
        }
        CloakingUtils.setCloakedFileTypes(newList.toArray(new String[newList.size()]));
    }

    public static boolean isFileCloaked(IFileStore fileStore) {
        String[] expressions;
        String filename = fileStore.getName();
        String filepath = fileStore.toString();
        String[] stringArray = expressions = CloakingUtils.getCloakedExpressions();
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            String expression = stringArray[n2];
            if (filename.matches(expression) || filepath.matches(expression)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] getCloakedExpressions() {
        String[] filetypes = CloakingUtils.getCloakedFileTypes();
        String[] expressions = new String[filetypes.length];
        int i = 0;
        while (i < expressions.length) {
            expressions[i] = CloakingUtils.convertCloakExpressionToRegex(filetypes[i]);
            ++i;
        }
        return expressions;
    }

    private static String convertCloakExpressionToRegex(String expression) {
        if (expression == null) {
            return null;
        }
        String result = null;
        if (expression.length() > 1 && expression.charAt(0) == '/' && expression.charAt(expression.length() - 1) == '/') {
            return expression.substring(1, expression.length() - 1);
        }
        if (expression.contains("\\")) {
            expression = expression.replaceAll("\\\\", "/");
        }
        result = expression.replaceAll("\\.(?=[^\\*])", "\\\\.");
        result = result.replaceAll("\\.\\*", "^\\\\..*");
        result = "(?i)" + result.replaceAll("(?<!\\.)\\*", ".*");
        return result;
    }

    public static String[] getDefaultCloakedFileTypes() {
        return ".svn;.tmp*~;.settings;CVS;.git;.DS_Store".split(";");
    }

    public static String[] getCloakedFileTypes() {
        String extensions = Platform.getPreferencesService().getString("com.aptana.core.io", "GLOBAL_CLOAKING_EXTENSIONS", ".svn;.tmp*~;.settings;CVS;.git;.DS_Store", null);
        if ("".equals(extensions)) {
            return ArrayUtil.NO_STRINGS;
        }
        return extensions.split(";");
    }

    public static void setCloakedFileTypes(String[] filetypes) {
        String value = StringUtil.join((String)";", (String[])filetypes);
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.core.io");
        prefs.put("GLOBAL_CLOAKING_EXTENSIONS", value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
    }
}

