/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.ftp;

import com.aptana.deploy.IDeployProvider;
import com.aptana.deploy.ftp.Messages;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ResourceSynchronizationUtils;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.actions.SynchronizeProjectAction;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class FTPDeployProvider
implements IDeployProvider {
    public static final String ID = "com.aptana.deploy.ftp.provider";

    public void deploy(IContainer selectedContainer, IProgressMonitor monitor) {
        SynchronizeProjectAction action = new SynchronizeProjectAction();
        action.setActivePart(null, UIUtils.getActivePart());
        action.setSelection((ISelection)new StructuredSelection((Object)selectedContainer));
        ISiteConnection[] sites = SiteConnectionUtils.findSitesForSource((IAdaptable)selectedContainer, (boolean)true);
        if (sites.length > 1) {
            String lastConnection = ResourceSynchronizationUtils.getLastSyncConnection((IContainer)selectedContainer);
            if (lastConnection == null) {
                lastConnection = DeployPreferenceUtil.getDeployEndpoint((IContainer)selectedContainer);
            }
            if (lastConnection != null) {
                action.setSelectedSite(SiteConnectionUtils.getSiteWithDestination((String)lastConnection, (ISiteConnection[])sites));
            }
        }
        action.run(null);
    }

    public boolean handles(IContainer selectedContainer) {
        ISiteConnection[] siteConnections = SiteConnectionUtils.findSitesForSource((IAdaptable)selectedContainer, (boolean)false);
        return siteConnections.length > 0;
    }

    public String getDeployMenuName() {
        return Messages.FTPDeployProvider_DeployMenuName;
    }
}

