/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.ftp.internal.handlers;

import com.aptana.deploy.ftp.ui.wizard.FTPDeployPropertyDialog;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ResourceSynchronizationUtils;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.dialogs.ChooseSiteConnectionDialog;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public class DeploySettingsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource selectedResource = UIUtils.getSelectedResource((IEvaluationContext)((IEvaluationContext)event.getApplicationContext()));
        if (selectedResource == null) {
            return null;
        }
        IContainer container = selectedResource instanceof IContainer ? (IContainer)selectedResource : selectedResource.getParent();
        FTPDeployPropertyDialog settingsDialog = new FTPDeployPropertyDialog(UIUtils.getActiveShell());
        settingsDialog.setProject(container.getProject());
        ISiteConnection[] siteConnections = SiteConnectionUtils.findSitesForSource((IAdaptable)container);
        ISiteConnection lastSiteConnection = null;
        if (siteConnections.length > 1) {
            String lastConnection = null;
            if (ResourceSynchronizationUtils.isRememberDecision((IContainer)container)) {
                lastConnection = ResourceSynchronizationUtils.getLastSyncConnection((IContainer)container);
            }
            if (lastConnection == null) {
                lastConnection = DeployPreferenceUtil.getDeployEndpoint((IContainer)container);
            }
            if (lastConnection != null) {
                lastSiteConnection = SiteConnectionUtils.getSiteWithDestination((String)lastConnection, (ISiteConnection[])siteConnections);
            }
        } else if (siteConnections.length == 1) {
            lastSiteConnection = siteConnections[0];
        }
        if (lastSiteConnection != null) {
            settingsDialog.setPropertySource(lastSiteConnection.getDestination());
        } else if (siteConnections.length > 1) {
            ChooseSiteConnectionDialog dialog = new ChooseSiteConnectionDialog(UIUtils.getActiveShell(), siteConnections);
            dialog.setShowRememberMyDecision(true);
            dialog.open();
            IConnectionPoint destination = null;
            ISiteConnection site = dialog.getSelectedSite();
            if (site != null) {
                ResourceSynchronizationUtils.setRememberDecision((IContainer)container, (boolean)dialog.isRememberMyDecision());
                destination = site.getDestination();
                if (destination != null) {
                    ResourceSynchronizationUtils.setLastSyncConnection((IContainer)container, (String)destination.getName());
                }
            }
            settingsDialog.setPropertySource(destination);
        }
        settingsDialog.open();
        return null;
    }
}

