/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.ftp.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.deploy.ftp.FTPDeployPlugin;
import com.aptana.deploy.ftp.ui.wizard.FTPDeployWizardPage;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.deploy.ui.wizard.AbstractDeployWizard;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.actions.DownloadAction;
import com.aptana.ide.syncing.ui.actions.SynchronizeProjectAction;
import com.aptana.ide.syncing.ui.actions.UploadAction;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.syncing.ui.preferences.IPreferenceConstants;
import com.aptana.ui.util.UIUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class FTPDeployWizard
extends AbstractDeployWizard {
    private IContainer selectedContainer;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource resource;
        super.init(workbench, selection);
        Object element = selection.getFirstElement();
        if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
            this.selectedContainer = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
        }
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new FTPDeployWizardPage(this.selectedContainer));
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        FTPDeployWizardPage page = (FTPDeployWizardPage)currentPage;
        IRunnableWithProgress runnable = this.createFTPDeployRunnable(page);
        DeployPreferenceUtil.setDeployType((IContainer)this.selectedContainer, (String)"com.aptana.deploy.ftp.provider");
        DeployPreferenceUtil.setDeployEndpoint((IContainer)this.selectedContainer, (String)page.getConnectionPoint().getName());
        if (runnable != null) {
            try {
                this.getContainer().run(true, false, runnable);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)FTPDeployPlugin.getDefault(), (Throwable)e);
            }
        }
        return true;
    }

    protected IRunnableWithProgress createFTPDeployRunnable(FTPDeployWizardPage page) {
        if (!page.completePage()) {
            return null;
        }
        IBaseRemoteConnectionPoint destinationConnectionPoint = page.getConnectionPoint();
        boolean isAutoSyncSelected = page.isAutoSyncSelected();
        IPreferenceConstants.SyncDirection direction = page.getSyncDirection();
        IWorkbenchPart activePart = UIUtils.getActivePart();
        IRunnableWithProgress runnable = new IRunnableWithProgress((IConnectionPoint)destinationConnectionPoint, isAutoSyncSelected, direction, activePart){
            private final /* synthetic */ IConnectionPoint val$destinationConnectionPoint;
            private final /* synthetic */ boolean val$isAutoSyncSelected;
            private final /* synthetic */ IPreferenceConstants.SyncDirection val$direction;
            private final /* synthetic */ IWorkbenchPart val$activePart;
            {
                this.val$destinationConnectionPoint = iConnectionPoint;
                this.val$isAutoSyncSelected = bl;
                this.val$direction = syncDirection;
                this.val$activePart = iWorkbenchPart;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ISiteConnection site = null;
                    ISiteConnection[] sites = SiteConnectionUtils.findSites((IAdaptable)FTPDeployWizard.this.selectedContainer, (IConnectionPoint)this.val$destinationConnectionPoint);
                    if (sites.length == 0) {
                        IConnectionPoint sourceConnectionPoint = SyncUtils.findOrCreateConnectionPointFor((IAdaptable)FTPDeployWizard.this.selectedContainer);
                        CoreIOPlugin.getConnectionPointManager().addConnectionPoint(sourceConnectionPoint);
                        site = SiteConnectionUtils.createSite((String)MessageFormat.format("{0} <-> {1}", FTPDeployWizard.this.selectedContainer.getName(), this.val$destinationConnectionPoint.getName()), (IConnectionPoint)sourceConnectionPoint, (IConnectionPoint)this.val$destinationConnectionPoint);
                        SyncingPlugin.getSiteConnectionManager().addSiteConnection(site);
                    } else if (sites.length == 1) {
                        site = sites[0];
                    } else {
                        String lastConnection = DeployPreferenceUtil.getDeployEndpoint((IContainer)FTPDeployWizard.this.selectedContainer);
                        if (lastConnection != null) {
                            site = SiteConnectionUtils.getSiteWithDestination((String)lastConnection, (ISiteConnection[])sites);
                        }
                    }
                    if (this.val$isAutoSyncSelected) {
                        UploadAction action = null;
                        switch (this.val$direction) {
                            case UPLOAD: {
                                action = new UploadAction();
                                break;
                            }
                            case DOWNLOAD: {
                                action = new DownloadAction();
                                break;
                            }
                            case BOTH: {
                                action = new SynchronizeProjectAction();
                            }
                        }
                        action.setActivePart(null, this.val$activePart);
                        action.setSelection((ISelection)new StructuredSelection((Object)FTPDeployWizard.this.selectedContainer));
                        action.setSelectedSite(site);
                        action.run(null);
                    }
                }
                finally {
                    sub.done();
                }
            }
        };
        return runnable;
    }
}

