/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.ftp.ui.wizard;

import com.aptana.deploy.ftp.FTPDeployPlugin;
import com.aptana.deploy.ftp.ui.wizard.FTPDeployComposite;
import com.aptana.deploy.ftp.ui.wizard.Messages;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.preferences.IPreferenceConstants;
import com.aptana.ide.syncing.ui.preferences.SyncPreferenceUtil;
import com.aptana.ui.ftp.internal.FTPConnectionPropertyComposite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FTPDeployWizardPage
extends WizardPage
implements FTPConnectionPropertyComposite.IListener {
    public static final String NAME = "FTPDeployment";
    private static final String ICON_PATH = "icons/ftp.png";
    private IContainer container;
    private FTPDeployComposite ftpConnectionComposite;
    private IBaseRemoteConnectionPoint connectionPoint;

    protected FTPDeployWizardPage(IContainer container) {
        super(NAME, Messages.FTPDeployWizardPage_Title, FTPDeployPlugin.getImageDescriptor(ICON_PATH));
        this.container = container;
        ISiteConnection[] sites = SiteConnectionUtils.findSitesForSource((IAdaptable)container, (boolean)true);
        String lastConnection = DeployPreferenceUtil.getDeployEndpoint((IContainer)container);
        ISiteConnection[] iSiteConnectionArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            IConnectionPoint connection = site.getDestination();
            if (connection != null && connection.getName().equals(lastConnection) || lastConnection == null && connection instanceof IBaseRemoteConnectionPoint) {
                this.connectionPoint = (IBaseRemoteConnectionPoint)connection;
                break;
            }
            ++n2;
        }
    }

    public IBaseRemoteConnectionPoint getConnectionPoint() {
        return this.ftpConnectionComposite.getConnectionPoint();
    }

    public boolean isAutoSyncSelected() {
        return this.ftpConnectionComposite.isAutoSyncSelected();
    }

    public IPreferenceConstants.SyncDirection getSyncDirection() {
        return this.ftpConnectionComposite.getSyncDirection();
    }

    public boolean completePage() {
        boolean complete = this.ftpConnectionComposite.completeConnection();
        boolean autoSync = this.isAutoSyncSelected();
        IProject project = this.container.getProject();
        SyncPreferenceUtil.setAutoSync((IProject)project, (boolean)autoSync);
        if (autoSync) {
            SyncPreferenceUtil.setAutoSyncDirection((IProject)project, (IPreferenceConstants.SyncDirection)this.getSyncDirection());
        }
        return complete;
    }

    public void createControl(Composite parent) {
        this.ftpConnectionComposite = new FTPDeployComposite(parent, 0, this.connectionPoint, this);
        this.ftpConnectionComposite.setLayoutData(new GridData(272));
        this.setControl((Control)this.ftpConnectionComposite);
        this.initializeDialogUnits((Control)parent);
        Dialog.applyDialogFont((Control)this.ftpConnectionComposite);
        IProject project = this.container.getProject();
        boolean autoSync = SyncPreferenceUtil.isAutoSync((IProject)project);
        this.ftpConnectionComposite.setAutoSyncSelected(autoSync);
        if (autoSync) {
            this.ftpConnectionComposite.setSyncDirection(SyncPreferenceUtil.getAutoSyncDirection((IProject)project));
        }
        this.ftpConnectionComposite.validate();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean close() {
        return false;
    }

    public void error(String message) {
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(message);
        }
        this.setPageComplete(message == null);
    }

    public void layoutShell() {
    }

    public void lockUI(boolean lock) {
    }

    public void setValid(boolean valid) {
    }
}

