/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.core.launching;

import com.aptana.core.util.PlatformUtil;
import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.debug.core.launching.Messages;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;

public class InterruptingProcessFactory
implements IProcessFactory {
    public static final String ID = "com.aptana.ruby.debug.core.interruptingProcessFactory";

    public IProcess newProcess(ILaunch launch, Process process, String label, Map attributes) {
        return new RuntimeProcess(launch, process, label, attributes){

            public void terminate() throws DebugException {
                if (!Platform.getOS().equals("win32")) {
                    this.killProcess();
                }
                super.terminate();
            }

            private Integer grabPid() {
                try {
                    Process realProcess = this.getSystemProcess();
                    Field f = realProcess.getClass().getDeclaredField("pid");
                    f.setAccessible(true);
                    return (Integer)f.get(realProcess);
                }
                catch (Exception exception) {
                    return -1;
                }
            }

            private IStatus killProcess() {
                int pid = this.grabPid();
                if (pid <= 0) {
                    return new Status(4, RubyDebugCorePlugin.getPluginIdentifier(), Messages.InterruptingProcessFactory_UnableToGrabPIDMsg);
                }
                PlatformUtil.killProcess((int)pid, (int)2);
                return Status.OK_STATUS;
            }
        };
    }
}

