/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.breakpoints;

import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.RubyDebugModel;
import com.aptana.ruby.internal.debug.core.breakpoints.Messages;
import com.aptana.ruby.internal.debug.core.breakpoints.RubyBreakpoint;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyLineBreakpoint
extends RubyBreakpoint
implements IRubyLineBreakpoint {
    public static final String RUBY_LINE_BREAKPOINT = "com.aptana.ruby.debug.core.rubyLineBreakpointMarker";
    protected static final String CONDITION = "com.aptana.ruby.debug.core.condition";
    protected static final String CONDITION_ENABLED = "com.aptana.ruby.debug.core.conditionEnabled";
    protected static final String CONDITION_SUSPEND_ON_TRUE = "com.aptana.ruby.debug.core.conditionSuspendOnTrue";
    public static final String EXTERNAL_FILENAME = "externalFileName";
    private int index = -1;

    public RubyLineBreakpoint() {
    }

    public RubyLineBreakpoint(IResource resource, IPath fileName, String typeName, int lineNumber, int charStart, int charEnd, int hitCount, boolean add, Map<String, Object> attributes) throws DebugException {
        this(resource, fileName, typeName, lineNumber, charStart, charEnd, hitCount, add, attributes, RUBY_LINE_BREAKPOINT);
    }

    protected RubyLineBreakpoint(final IResource resource, final IPath fileName, final String typeName, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean add, final Map<String, Object> attributes, String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RubyLineBreakpoint.this.setMarker(resource.createMarker(RubyLineBreakpoint.RUBY_LINE_BREAKPOINT));
                String msgFilename = resource.getFullPath().toString();
                if (resource.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                    attributes.put(RubyLineBreakpoint.EXTERNAL_FILENAME, fileName.toPortableString());
                    msgFilename = fileName.toOSString();
                }
                attributes.put("message", MessageFormat.format(Messages.RubyLineBreakpoint_Message, msgFilename, Integer.toString(lineNumber)));
                RubyLineBreakpoint.this.addLineBreakpointAttributes(attributes, RubyLineBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                RubyLineBreakpoint.this.addTypeNameAndHitCount(attributes, typeName, hitCount);
                RubyLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                RubyLineBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public void addLineBreakpointAttributes(Map<String, Object> attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
    }

    public void addTypeNameAndHitCount(Map<String, Object> attributes, String typeName, int hitCount) {
        attributes.put("com.aptana.ruby.debug.core.typeName", typeName);
        if (hitCount > 0) {
            attributes.put("com.aptana.ruby.debug.core.hitCount", new Integer(hitCount));
            attributes.put("com.aptana.ruby.debug.core.expired", Boolean.FALSE);
        }
    }

    @Override
    public IPath getFilePath() throws CoreException {
        IResource resource = this.ensureMarker().getResource();
        if (resource.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
            return Path.fromPortableString((String)this.ensureMarker().getAttribute(EXTERNAL_FILENAME, ""));
        }
        return resource.getProjectRelativePath();
    }

    @Override
    public IPath getLocation() throws CoreException {
        IResource resource = this.ensureMarker().getResource();
        if (resource.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
            return Path.fromPortableString((String)this.ensureMarker().getAttribute(EXTERNAL_FILENAME, ""));
        }
        return resource.getLocation();
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return RUBY_LINE_BREAKPOINT;
    }

    @Override
    public String getModelIdentifier() {
        return RubyDebugModel.getModelIdentifier();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    @Override
    public boolean isConditionSuspendOnTrue() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    @Override
    public void setCondition(String condition) throws CoreException {
        if (condition != null && condition.trim().length() == 0) {
            condition = null;
        }
        this.setAttributes(new String[]{CONDITION}, new Object[]{condition});
        this.recreate();
    }

    @Override
    public void setConditionEnabled(boolean conditionEnabled) throws CoreException {
        this.setAttributes(new String[]{CONDITION_ENABLED}, new Object[]{conditionEnabled});
        this.recreate();
    }

    @Override
    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        if (this.isConditionSuspendOnTrue() != suspendOnTrue) {
            this.setAttributes(new String[]{CONDITION_SUSPEND_ON_TRUE}, new Object[]{suspendOnTrue});
            this.recreate();
        }
    }

    @Override
    public boolean supportsCondition() {
        return true;
    }
}

