/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.breakpoints;

import com.aptana.ruby.debug.core.IRubyMethodBreakpoint;
import com.aptana.ruby.internal.debug.core.breakpoints.RubyLineBreakpoint;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyMethodBreakpoint
extends RubyLineBreakpoint
implements IRubyMethodBreakpoint {
    private static final String RUBY_METHOD_BREAKPOINT = "com.aptana.ruby.debug.rubyMethodBreakpointMarker";
    private static final String METHOD_NAME = "com.aptana.ruby.debug.core.methodName";
    private static final String ENTRY = "com.aptana.ruby.debug.core.entry";
    private static final String EXIT = "com.aptana.ruby.debug.core.exit";
    private String fMethodName = null;

    public RubyMethodBreakpoint() {
    }

    public RubyMethodBreakpoint(final IResource resource, final String typePattern, final String methodName, final boolean entry, final boolean exit, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean register, final Map<String, Object> attributes) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RubyMethodBreakpoint.this.setMarker(resource.createMarker(RubyMethodBreakpoint.RUBY_METHOD_BREAKPOINT));
                RubyMethodBreakpoint.this.addLineBreakpointAttributes(attributes, RubyMethodBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                RubyMethodBreakpoint.this.addMethodNameAndSignature(attributes, methodName, null);
                RubyMethodBreakpoint.this.addTypeNameAndHitCount(attributes, typePattern, hitCount);
                attributes.put(RubyMethodBreakpoint.ENTRY, entry);
                attributes.put(RubyMethodBreakpoint.EXIT, exit);
                RubyMethodBreakpoint.this.ensureMarker().setAttributes(attributes);
                RubyMethodBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    private void addMethodNameAndSignature(Map<String, Object> attributes, String methodName, String methodSignature) {
        if (methodName != null) {
            attributes.put(METHOD_NAME, methodName);
        }
        this.fMethodName = methodName;
    }

    @Override
    public String getMethodName() {
        return this.fMethodName;
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.fMethodName = marker.getAttribute(METHOD_NAME, null);
    }
}

