/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.launching;

import com.aptana.ruby.internal.debug.core.launching.RootSourceContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubySourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList<Object> sourceContainers = new ArrayList<Object>();
        String workingDir = configuration.getAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", null);
        sourceContainers.addAll(this.addPath(workingDir));
        if (sourceContainers.isEmpty()) {
            String path = configuration.getAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", null);
            sourceContainers.addAll(this.addParent(path));
        }
        sourceContainers.add(new WorkspaceSourceContainer());
        sourceContainers.add((Object)new RootSourceContainer());
        return sourceContainers.toArray(new ISourceContainer[sourceContainers.size()]);
    }

    private Collection<? extends ISourceContainer> addParent(String path) {
        IFile resource;
        if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path))) != null) {
            IContainer container = resource.getParent();
            return this.addPath(container.getLocation().toPortableString());
        }
        return Collections.emptyList();
    }

    private Collection<? extends ISourceContainer> addPath(String path) {
        ArrayList<Object> sourceContainers = new ArrayList<Object>();
        if (path != null) {
            IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromOSString((String)path));
            if (resource != null && resource instanceof IContainer && resource.exists()) {
                IContainer container = resource;
                if (container.getType() == 2) {
                    sourceContainers.add(new FolderSourceContainer(container, false));
                } else if (container.getType() == 4) {
                    sourceContainers.add(new ProjectSourceContainer(resource.getProject(), false));
                }
            } else {
                sourceContainers.add(new DirectorySourceContainer(new File(path), false));
            }
        }
        return sourceContainers;
    }
}

