/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.model;

import com.aptana.ruby.debug.core.model.IRubyValue;
import com.aptana.ruby.internal.debug.core.model.RubyDebugElement;
import com.aptana.ruby.internal.debug.core.model.RubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class RubyValue
extends RubyDebugElement
implements IRubyValue {
    private String valueString;
    private String referenceTypeName;
    private boolean hasChildren;
    private RubyVariable owner;
    private RubyVariable[] variables;

    public RubyValue(RubyVariable owner) {
        this(owner, "nil", null, false);
    }

    public RubyValue(RubyVariable owner, String valueString, String type, boolean hasChildren) {
        super(owner.getDebugTarget());
        this.valueString = valueString;
        if (type != null && type.equals("String")) {
            this.valueString = String.valueOf('\"') + this.valueString + '\"';
        } else if (this.valueString.startsWith("Empty ")) {
            this.valueString = String.valueOf(this.valueString.substring(6)) + "[0]";
        } else if (this.valueString.endsWith("element(s))")) {
            int index = this.valueString.substring(0, this.valueString.length() - 11).lastIndexOf("(");
            this.valueString = String.valueOf(this.valueString.substring(0, index).trim()) + "[" + this.valueString.substring(index + 1, this.valueString.length() - 11).trim() + "]";
        } else if (type != null && type.equals("Symbol")) {
            this.valueString = String.valueOf(':') + this.valueString;
        }
        if (type == null && "nil".equals(this.valueString)) {
            type = "NilClass";
        }
        this.owner = owner;
        this.hasChildren = hasChildren;
        this.referenceTypeName = type;
    }

    public String getReferenceTypeName() {
        return this.referenceTypeName;
    }

    public String getValueString() {
        return this.valueString;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (!this.hasChildren) {
            return new RubyVariable[0];
        }
        if (this.variables == null) {
            this.variables = ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy().readInstanceVariables(this.owner);
        }
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return this.hasChildren;
    }

    public String toString() {
        if (this.getReferenceTypeName() == null) {
            return this.getValueString();
        }
        return this.getValueString();
    }

    public RubyVariable getOwner() {
        return this.owner;
    }
}

