/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.parsing;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReader;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReaderException;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MultiReaderStrategy
extends AbstractReadStrategy {
    private Map<XmlStreamReader, Thread> threads = new HashMap<XmlStreamReader, Thread>();
    private XmlStreamReader currentReader;
    private boolean isConnected = true;

    public MultiReaderStrategy(XmlPullParser xpp) {
        super(xpp);
        new Thread("xml reader"){

            public void run() {
                block14: {
                    try {
                        MultiReaderStrategy.this.readLoop();
                    }
                    catch (SocketException socketException) {
                        RubyDebugCorePlugin.debug("read loop stopped because socket has been closed.");
                        MultiReaderStrategy.this.isConnected = false;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        MultiReaderStrategy.this.releaseAllReaders();
                        break block14;
                    }
                    catch (Exception e) {
                        try {
                            RubyDebugCorePlugin.debug("read loop stopped due to error : ", e);
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            MultiReaderStrategy.this.isConnected = false;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            MultiReaderStrategy.this.releaseAllReaders();
                            throw throwable;
                        }
                        MultiReaderStrategy.this.isConnected = false;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        MultiReaderStrategy.this.releaseAllReaders();
                        break block14;
                    }
                    MultiReaderStrategy.this.isConnected = false;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    MultiReaderStrategy.this.releaseAllReaders();
                }
            }
        }.start();
    }

    protected void readLoop() throws XmlPullParserException, IOException, XmlStreamReaderException {
        RubyDebugCorePlugin.debug("Starting xml read loop.");
        int eventType = this.xpp.getEventType();
        do {
            if (eventType == 2) {
                this.dispatchStartTag();
                continue;
            }
            if (eventType == 3 && this.currentReader != null) {
                if (!this.currentReader.processEndElement(this.xpp)) continue;
                this.removeReader(this.currentReader);
                this.currentReader = null;
                continue;
            }
            if (eventType != 4 || this.currentReader == null) continue;
            this.currentReader.processContent(this.xpp.getText());
        } while ((eventType = this.xpp.next()) != 1);
        RubyDebugCorePlugin.debug("Read loop stopped because end of stream was reached.");
    }

    protected void dispatchStartTag() throws XmlPullParserException, IOException, XmlStreamReaderException {
        RubyDebugCorePlugin.debug("Dispatching start tag " + this.xpp.getName());
        if (this.currentReader != null) {
            if (this.currentReader.processStartElement(this.xpp)) {
                return;
            }
            RubyDebugCorePlugin.debug("Current Reader can not process tag " + this.xpp.getName());
            this.currentReader = null;
        }
        int missed = 0;
        RubyDebugCorePlugin.debug("Searching reader for start tag " + this.xpp.getName());
        do {
            this.findReaderForTag();
            if (this.currentReader != null) continue;
            ++missed;
            RubyDebugCorePlugin.debug("Missed Start Tag : " + this.xpp.getName());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        } while (this.currentReader == null && missed < 10);
    }

    private synchronized void findReaderForTag() throws XmlStreamReaderException {
        for (XmlStreamReader streamReader : this.threads.keySet()) {
            if (!streamReader.processStartElement(this.xpp)) continue;
            this.currentReader = streamReader;
            break;
        }
    }

    protected synchronized void releaseAllReaders() {
        Iterator<Map.Entry<XmlStreamReader, Thread>> iter = this.threads.entrySet().iterator();
        while (iter.hasNext()) {
            Thread thread = iter.next().getValue();
            thread.interrupt();
            iter.remove();
        }
    }

    protected synchronized void removeReader(XmlStreamReader streamReader) {
        this.threads.get(streamReader).interrupt();
        this.threads.remove(streamReader);
    }

    protected synchronized void addReader(XmlStreamReader streamReader) {
        this.threads.put(streamReader, Thread.currentThread());
    }

    public void readElement(XmlStreamReader streamReader) throws IOException {
        this.readElement(streamReader, Long.MAX_VALUE);
    }

    public void readElement(XmlStreamReader streamReader, long maxWaitTime) throws IOException {
        if (!this.isConnected) {
            throw new IOException("Read loop has finished");
        }
        this.addReader(streamReader);
        try {
            RubyDebugCorePlugin.debug("Thread is waiting for input: " + Thread.currentThread());
            Thread.sleep(maxWaitTime);
            streamReader.setWaitTimeExpired(true);
        }
        catch (InterruptedException interruptedException) {
            RubyDebugCorePlugin.debug("Thread has finished processing : " + Thread.currentThread());
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }
}

