/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.parsing;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.internal.debug.core.BreakpointSuspensionPoint;
import com.aptana.ruby.internal.debug.core.ExceptionSuspensionPoint;
import com.aptana.ruby.internal.debug.core.StepSuspensionPoint;
import com.aptana.ruby.internal.debug.core.SuspensionPoint;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReader;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReaderException;
import java.io.IOException;
import java.text.MessageFormat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SuspensionReader
extends XmlStreamReader {
    private SuspensionPoint suspensionPoint;

    public SuspensionReader(XmlPullParser xpp) {
        super(xpp);
    }

    public SuspensionReader(AbstractReadStrategy readStrategy) {
        super(readStrategy);
    }

    public SuspensionPoint readSuspension() throws XmlPullParserException, IOException, XmlStreamReaderException {
        this.read();
        return this.suspensionPoint;
    }

    protected boolean processStartElement(XmlPullParser xpp) throws XmlStreamReaderException {
        String name = xpp.getName();
        if (name.equals("breakpoint")) {
            this.suspensionPoint = new BreakpointSuspensionPoint();
        } else if (name.equals("exception")) {
            ExceptionSuspensionPoint exceptionPoint = new ExceptionSuspensionPoint();
            exceptionPoint.setExceptionMessage(xpp.getAttributeValue("", "message"));
            exceptionPoint.setExceptionType(xpp.getAttributeValue("", "type"));
            this.suspensionPoint = exceptionPoint;
        } else if (name.equals("suspended")) {
            StepSuspensionPoint stepPoint = new StepSuspensionPoint();
            String frameNoAttribute = xpp.getAttributeValue("", "frames");
            try {
                stepPoint.setFramesNumber(Integer.parseInt(frameNoAttribute));
                this.suspensionPoint = stepPoint;
            }
            catch (NumberFormatException numberFormatException) {
                RubyDebugCorePlugin.debug(MessageFormat.format("Could not parse: {0}, {1}", frameNoAttribute, xpp.getText()));
                return false;
            }
        } else {
            return false;
        }
        int line = 0;
        try {
            line = Integer.parseInt(xpp.getAttributeValue("", "line"));
        }
        catch (NumberFormatException e) {
            RubyDebugCorePlugin.log(e);
        }
        this.suspensionPoint.setLine(line);
        this.suspensionPoint.setFile(xpp.getAttributeValue("", "file"));
        this.suspensionPoint.setThreadId(Integer.parseInt(xpp.getAttributeValue("", "threadId")));
        return true;
    }
}

