package com.rmtheis.langdetect.profile;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

import java.util.HashMap;

public class AR {
  private static final String name = "ar";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public AR() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 713000;
    n_words[1] = 862096;
    n_words[2] = 654143;

    freq.put("فضو", 13);
    freq.put("فضي", 21);
    freq.put("فضل", 144);
    freq.put("فضف", 12);
    freq.put("ُحت", 11);
    freq.put("ُحب", 41);
    freq.put("ﺿ", 11);
    freq.put("هوب", 15);
    freq.put("ُحم", 10);
    freq.put("ُحَ", 9);
    freq.put("لك ", 1170);
    freq.put("ُحِ", 14);
    freq.put("شو ", 24);
    freq.put("غضب", 38);
    freq.put("فضح", 19);
    freq.put("فضة", 9);
    freq.put("فضا", 19);
    freq.put("يأس", 20);
    freq.put("لب ", 355);
    freq.put("ﻟم", 10);
    freq.put("َخْ", 10);
    freq.put("يأت", 40);
    freq.put("عور", 74);
    freq.put("", 11);
    freq.put("هْ ", 19);
    freq.put("وت ", 259);
    freq.put("صة ", 66);
    freq.put("در ", 275);
    freq.put("ور ", 581);
    freq.put("لشر", 90);
    freq.put("ّه ", 88);
    freq.put("متح", 65);
    freq.put("متب", 11);
    freq.put("سفي", 20);
    freq.put("متا", 331);
    freq.put("تر ", 180);
    freq.put("متأ", 15);
    freq.put("متع", 74);
    freq.put("متض", 25);
    freq.put("ثني", 60);
    freq.put("متر", 21);
    freq.put("متز", 9);
    freq.put("متس", 12);
    freq.put("اطا", 15);
    freq.put("اطئ", 14);
    freq.put("عطر", 29);
    freq.put("اطة", 14);
    freq.put("اطب", 11);
    freq.put("قة ", 292);
    freq.put("عطا", 41);
    freq.put("اطر", 82);
    freq.put("لوز", 22);
    freq.put("اطع", 18);
    freq.put("اطم", 14);
    freq.put("اطل", 41);
    freq.put("اطه", 9);
    freq.put("اطن", 30);
    freq.put("اطف", 35);
    freq.put("اطق", 11);
    freq.put("اطي", 28);
    freq.put("عطن", 19);
    freq.put("عطل", 12);
    freq.put("عطي", 103);
    freq.put("عطو", 19);
    freq.put("متَ", 14);
    freq.put("متُ", 10);
    freq.put("متو", 120);
    freq.put("متى", 89);
    freq.put("متي", 66);
    freq.put("متل", 32);
    freq.put("متم", 18);
    freq.put("متن", 44);
    freq.put("مته", 82);
    freq.put("رًا", 57);
    freq.put("متف", 14);
    freq.put("متك", 98);
    freq.put("ثنا", 38);
    freq.put("ثنت", 9);
    freq.put("متْ", 9);
    freq.put("ليد", 32);
    freq.put("زم ", 95);
    freq.put("ٌن", 12);
    freq.put("ٌل", 14);
    freq.put("ٌم", 11);
    freq.put("ٌق", 9);
    freq.put("ٌك", 9);
    freq.put("ٌو", 10);
    freq.put("شاق", 17);
    freq.put("شاك", 35);
    freq.put("شاف", 58);
    freq.put("شان", 134);
    freq.put("شاه", 72);
    freq.put("شال", 21);
    freq.put("شام", 57);
    freq.put("شاي", 30);
    freq.put(" ﻷن", 9);
    freq.put("ٌا", 13);
    freq.put("شار", 137);
    freq.put("م", 40095);
    freq.put("شاط", 13);
    freq.put("شاع", 95);
    freq.put("شاء", 127);
    freq.put("شاا", 11);
    freq.put("ٌر", 11);
    freq.put("شاب", 31);
    freq.put("همك", 31);
    freq.put("وز ", 79);
    freq.put("ِــ", 16);
    freq.put("ُد", 78);
    freq.put("ُخ", 43);
    freq.put("ُح", 133);
    freq.put("ُج", 42);
    freq.put("مُه", 11);
    freq.put("ُت", 53);
    freq.put("مُم", 11);
    freq.put("ُب", 202);
    freq.put("ُا", 24);
    freq.put("ُؤ", 30);
    freq.put("طوو", 9);
    freq.put("طوي", 64);
    freq.put("اهم", 137);
    freq.put("اهل", 175);
    freq.put("اهه", 17);
    freq.put("اهن", 10);
    freq.put("ُغ", 33);
    freq.put("ُع", 112);
    freq.put("اب،", 10);
    freq.put("ُض", 27);
    freq.put("اهُ", 17);
    freq.put("ُش", 30);
    freq.put("ُس", 74);
    freq.put("ُز", 32);
    freq.put("ُر", 169);
    freq.put("ُذ", 16);
    freq.put("غم ", 46);
    freq.put("ابط", 34);
    freq.put("ابر", 82);
    freq.put("ابس", 26);
    freq.put("حِد", 9);
    freq.put("تيس", 19);
    freq.put("ابع", 478);
    freq.put("تير", 21);
    freq.put("بِي", 39);
    freq.put("ابا", 86);
    freq.put("تيت", 10);
    freq.put("تية", 14);
    freq.put("تيب", 25);
    freq.put("بِك", 26);
    freq.put("ابح", 13);
    freq.put("ـيا", 12);
    freq.put("ابد", 87);
    freq.put("بِه", 20);
    freq.put("ابة", 77);
    freq.put("ابت", 164);
    freq.put("ضمك", 9);
    freq.put("ۃ", 15);
    freq.put("حِك", 9);
    freq.put("مہ ", 35);
    freq.put("بِر", 11);
    freq.put("حِي", 39);
    freq.put("تيّ", 22);
    freq.put("ابل", 74);
    freq.put("تيَ", 11);
    freq.put("ابن", 155);
    freq.put("ابه", 104);
    freq.put("ابـ", 14);
    freq.put("تيي", 9);
    freq.put("ابق", 53);
    freq.put("ابك", 129);
    freq.put("تيه", 14);
    freq.put("تين", 115);
    freq.put("ابَ", 14);
    freq.put("ابُ", 16);
    freq.put("ابو", 129);
    freq.put("تيق", 30);
    freq.put("ابي", 238);
    freq.put("نآس", 26);
    freq.put("طوا", 31);
    freq.put("اهر", 44);
    freq.put("ُي", 23);
    freq.put("اهز", 12);
    freq.put("ُه", 96);
    freq.put("ُن", 258);
    freq.put("ُم", 290);
    freq.put("ُل", 221);
    freq.put("ُك", 139);
    freq.put("ُق", 70);
    freq.put("ُف", 43);
    freq.put("ُـ", 32);
    freq.put("مُس", 28);
    freq.put("اثر", 13);
    freq.put("اها", 110);
    freq.put("طوط", 10);
    freq.put("طور", 49);
    freq.put("اهد", 116);
    freq.put("اهب", 10);
    freq.put("ُّ", 38);
    freq.put("اهت", 37);
    freq.put("ناش", 16);
    freq.put("مج ", 47);
    freq.put("عوه", 23);
    freq.put("اهہ", 11);
    freq.put("نَا", 72);
    freq.put("اص ", 152);
    freq.put("ِه ", 17);
    freq.put("ﺨ", 16);
    freq.put("عر ", 144);
    freq.put("ذآ ", 43);
    freq.put("نكِ", 14);
    freq.put("مغف", 23);
    freq.put(" ﻵ ", 9);
    freq.put("وعه", 17);
    freq.put("رم ", 90);
    freq.put("كله", 170);
    freq.put("قــ", 34);
    freq.put("ثل ", 117);
    freq.put("ُہ", 15);
    freq.put("قـل", 19);
    freq.put("لتر", 110);
    freq.put("لتس", 37);
    freq.put("وَق", 12);
    freq.put("وَم", 22);
    freq.put("وَل", 52);
    freq.put("لتط", 14);
    freq.put("لتض", 13);
    freq.put("لتع", 104);
    freq.put("وَي", 10);
    freq.put("ﻣﻦ", 10);
    freq.put("لتأ", 13);
    freq.put("أطي", 10);
    freq.put("نگ ", 11);
    freq.put("لتا", 85);
    freq.put("قـو", 16);
    freq.put("أطف", 32);
    freq.put("لتب", 17);
    freq.put("لتح", 57);
    freq.put("أطل", 19);
    freq.put("لتد", 26);
    freq.put("لتخ", 15);
    freq.put("صاً", 14);
    freq.put("صاي", 21);
    freq.put("شيا", 123);
    freq.put("شيئ", 80);
    freq.put("شيب", 12);
    freq.put("صاف", 25);
    freq.put("صان", 13);
    freq.put("صام", 25);
    freq.put("خ", 6080);
    freq.put("شير", 18);
    freq.put("دسي", 9);
    freq.put("شيط", 36);
    freq.put("شيع", 30);
    freq.put("نكم", 64);
    freq.put("صاب", 75);
    freq.put("صاد", 72);
    freq.put("شيل", 35);
    freq.put("صاح", 99);
    freq.put("شين", 26);
    freq.put("شيو", 11);
    freq.put("صائ", 32);
    freq.put("شيَ", 10);
    freq.put("شيّ", 9);
    freq.put("نكو", 21);
    freq.put("دست", 15);
    freq.put("ہّ ", 24);
    freq.put("صار", 148);
    freq.put("ﺪ ", 13);
    freq.put("صاص", 15);
    freq.put("لتِ", 11);
    freq.put("وَأ", 23);
    freq.put("ﻣﺎ", 12);
    freq.put("وَا", 68);
    freq.put("دُع", 19);
    freq.put("وَت", 14);
    freq.put("وَح", 15);
    freq.put("وَج", 14);
    freq.put("وَر", 9);
    freq.put("وَس", 12);
    freq.put("لتق", 56);
    freq.put("لتم", 40);
    freq.put("نكَ", 22);
    freq.put("لته", 68);
    freq.put("لتن", 43);
    freq.put("وَع", 12);
    freq.put("لتو", 172);
    freq.put("لتي", 218);
    freq.put("لتُ", 17);
    freq.put("لتَ", 11);
    freq.put("تدر", 99);
    freq.put("ان،", 11);
    freq.put("دف ", 28);
    freq.put("تدع", 28);
    freq.put("ائع", 56);
    freq.put("ةة ", 35);
    freq.put("تدا", 33);
    freq.put("تدب", 20);
    freq.put("يأخ", 16);
    freq.put("تدخ", 34);
    freq.put("قطر", 36);
    freq.put("يتَ", 19);
    freq.put("دُك", 9);
    freq.put("وست", 21);
    freq.put("قطع", 82);
    freq.put("وسخ", 9);
    freq.put("ورض", 22);
    freq.put("وسر", 13);
    freq.put("وسط", 40);
    freq.put("قطا", 24);
    freq.put("قطت", 9);
    freq.put("وسع", 44);
    freq.put("وسك", 21);
    freq.put("ضة ", 39);
    freq.put("ائر", 39);
    freq.put("◄", 26);
    freq.put("وسل", 124);
    freq.put("وسم", 34);
    freq.put("وسي", 46);
    freq.put("وسو", 29);
    freq.put("وسَ", 10);
    freq.put("مَآ", 12);
    freq.put("دُو", 25);
    freq.put("سو ", 22);
    freq.put("قطق", 22);
    freq.put("انع", 20);
    freq.put("ائش", 10);
    freq.put("حيث", 28);
    freq.put("أب ", 16);
    freq.put("لتہ", 9);
    freq.put("تدف", 13);
    freq.put("تدل", 13);
    freq.put("تدم", 15);
    freq.put("مَة", 17);
    freq.put("تدو", 16);
    freq.put("تدي", 27);
    freq.put("مْد", 15);
    freq.put("ائد", 46);
    freq.put("ﺮﺍ", 10);
    freq.put("نكا", 9);
    freq.put("م ", 8655);
    freq.put("َبّ", 27);
    freq.put("َبِ", 15);
    freq.put("َبْ", 15);
    freq.put("ثم ", 145);
    freq.put("مَر", 14);
    freq.put("انب", 37);
    freq.put("نى ", 212);
    freq.put("مَس", 9);
    freq.put("اب ", 740);
    freq.put("ـي ", 189);
    freq.put("اند", 50);
    freq.put(" اﻟ", 35);
    freq.put("انح", 23);
    freq.put("غمَ", 9);
    freq.put("بِ ", 114);
    freq.put(" اﻷ", 16);
    freq.put("َبا", 12);
    freq.put("مُ ", 66);
    freq.put("حث ", 34);
    freq.put(" اﻻ", 27);
    freq.put("نآ ", 133);
    freq.put(" ︽ ", 9);
    freq.put("اه ", 364);
    freq.put("━", 30);
    freq.put("بِا", 19);
    freq.put("رمك", 12);
    freq.put("جلب", 12);
    freq.put("مجد", 10);
    freq.put("ثلي", 14);
    freq.put("رمن", 29);
    freq.put("رمو", 26);
    freq.put("ثله", 24);
    freq.put("مجا", 66);
    freq.put("ثلك", 14);
    freq.put("مَك", 17);
    freq.put("مجر", 47);
    freq.put("ىَ ", 98);
    freq.put("جلس", 55);
    freq.put("اصا", 42);
    freq.put("عرب", 105);
    freq.put("اصة", 18);
    freq.put("اصب", 61);
    freq.put("اصد", 31);
    freq.put("اصح", 20);
    freq.put("مَو", 9);
    freq.put("اصر", 39);
    freq.put("عرش", 45);
    freq.put("اصع", 10);
    freq.put("عرض", 56);
    freq.put("انِ", 35);
    freq.put("عرس", 13);
    freq.put("اصه", 12);
    freq.put("عرو", 40);
    freq.put("اصم", 9);
    freq.put("اصل", 80);
    freq.put("اصي", 62);
    freq.put("عره", 22);
    freq.put("اصو", 11);
    freq.put("عرف", 346);
    freq.put("عرك", 29);
    freq.put("مجي", 16);
    freq.put("رما", 36);
    freq.put("كد ", 43);
    freq.put("رمة", 12);
    freq.put("قفي", 11);
    freq.put("ثلا", 117);
    freq.put("مجن", 27);
    freq.put("", 9);
    freq.put("مجل", 19);
    freq.put("مجم", 28);
    freq.put("رمض", 52);
    freq.put("ﻼ", 10);
    freq.put("انُ", 11);
    freq.put("̄", 16);
    freq.put("̶̶̶", 12);
    freq.put("لت ", 345);
    freq.put("ﻤﺎ", 13);
    freq.put("شي ", 263);
    freq.put("يتف", 13);
    freq.put("ّم ", 30);
    freq.put("صا ", 16);
    freq.put("معج", 14);
    freq.put("يوخ", 11);
    freq.put("دس ", 18);
    freq.put("وَ ", 210);
    freq.put(" مظ", 12);
    freq.put("دفا", 18);
    freq.put("أبق", 12);
    freq.put("أبك", 21);
    freq.put(" ثا", 67);
    freq.put("أبن", 25);
    freq.put("أبو", 70);
    freq.put("أبي", 99);
    freq.put("تد ", 10);
    freq.put(" ثر", 11);
    freq.put("جَم", 38);
    freq.put("دفع", 30);
    freq.put("سوّ", 9);
    freq.put("وس ", 121);
    freq.put("يجو", 27);
    freq.put("قط ", 175);
    freq.put("سوف", 34);
    freq.put("سوق", 24);
    freq.put("سول", 156);
    freq.put("سون", 43);
    freq.put("سوه", 11);
    freq.put("سوو", 23);
    freq.put("سوى", 37);
    freq.put("سوي", 204);
    freq.put("يجي", 122);
    freq.put("︽", 9);
    freq.put("سور", 270);
    freq.put("سوس", 12);
    freq.put("سوء", 36);
    freq.put("سوأ", 9);
    freq.put("سوا", 89);
    freq.put("سوب", 13);
    freq.put("سوة", 10);
    freq.put("سود", 39);
    freq.put(" ثق", 59);
    freq.put("دفن", 16);
    freq.put("جَع", 16);
    freq.put(" ثل", 88);
    freq.put(" ثم", 175);
    freq.put("أبت", 21);
    freq.put("جَر", 11);
    freq.put(" ثُ", 18);
    freq.put("أبد", 83);
    freq.put("أبر", 16);
    freq.put("جَد", 11);
    freq.put("ثير", 221);
    freq.put("مْ ", 109);
    freq.put("أبع", 20);
    freq.put("جَا", 10);
    freq.put("ﻢ ", 18);
    freq.put("ـا ", 132);
    freq.put("كــ", 45);
    freq.put("̶̶ ", 12);
    freq.put("لكَ", 49);
    freq.put("يد ", 696);
    freq.put("لكي", 79);
    freq.put("لكو", 121);
    freq.put("لكن", 291);
    freq.put("لكه", 32);
    freq.put("لكل", 216);
    freq.put("لكم", 111);
    freq.put("لكك", 36);
    freq.put("رحي", 73);
    freq.put(" ٱل", 29);
    freq.put("شوي", 71);
    freq.put("شون", 10);
    freq.put("ﺻ", 25);
    freq.put("شوق", 84);
    freq.put("شوف", 204);
    freq.put("لكت", 92);
    freq.put("لكث", 41);
    freq.put("لكب", 45);
    freq.put("لكة", 16);
    freq.put("لكا", 67);
    freq.put("شور", 20);
    freq.put("شوا", 42);
    freq.put("رحك", 9);
    freq.put("لكذ", 19);
    freq.put("لكر", 66);
    freq.put("لك،", 12);
    freq.put("غض ", 9);
    freq.put("فض ", 27);
    freq.put("لبد", 47);
    freq.put("لبخ", 20);
    freq.put("لبح", 89);
    freq.put("لبت", 22);
    freq.put("لبة", 24);
    freq.put("ــق", 15);
    freq.put("لبا", 170);
    freq.put("مَد", 18);
    freq.put("ّهِ", 13);
    freq.put("ّهُ", 24);
    freq.put("ّهَ", 15);
    freq.put("أصل", 29);
    freq.put("لبع", 121);
    freq.put("لبط", 20);
    freq.put("ــه", 59);
    freq.put("لبص", 15);
    freq.put("لبش", 86);
    freq.put("لبس", 62);
    freq.put("لبر", 91);
    freq.put("أصو", 15);
    freq.put("نصر", 145);
    freq.put("دره", 33);
    freq.put("ورى", 13);
    freq.put("وري", 337);
    freq.put("ورً", 10);
    freq.put("درك", 51);
    freq.put("ورق", 34);
    freq.put("ورك", 40);
    freq.put("دري", 314);
    freq.put("ورن", 31);
    freq.put("درو", 51);
    freq.put("ورع", 10);
    freq.put("درس", 80);
    freq.put("درر", 13);
    freq.put("ورز", 20);
    freq.put("ورس", 21);
    freq.put("درع", 18);
    freq.put("درا", 72);
    freq.put("ورة", 234);
    freq.put("ورت", 55);
    freq.put("ورح", 26);
    freq.put("ورد", 62);
    freq.put("ورآ", 11);
    freq.put("درج", 73);
    freq.put("درت", 17);
    freq.put("درة", 22);
    freq.put("درب", 59);
    freq.put("لبُ", 21);
    freq.put("لبَ", 27);
    freq.put("ً، ", 18);
    freq.put("لبي", 328);
    freq.put("لبى", 15);
    freq.put("يكم", 110);
    freq.put("لبه", 78);
    freq.put("لبن", 146);
    freq.put("لبل", 51);
    freq.put("لبك", 121);
    freq.put("لشع", 73);
    freq.put("أصع", 15);
    freq.put("👆?", 10);
    freq.put("أصا", 13);
    freq.put("أصد", 34);
    freq.put("أصح", 29);
    freq.put("رُب", 11);
    freq.put("أصب", 90);
    freq.put("ترد", 36);
    freq.put("ترج", 35);
    freq.put("ترح", 29);
    freq.put("ترت", 48);
    freq.put("ترب", 55);
    freq.put("ترة", 23);
    freq.put("ترا", 229);
    freq.put("ترآ", 13);
    freq.put("ﺑ", 96);
    freq.put("ترع", 15);
    freq.put("ترض", 34);
    freq.put("ترز", 10);
    freq.put("ترس", 15);
    freq.put("صآر", 9);
    freq.put("نْ ", 250);
    freq.put("اط ", 59);
    freq.put("عدن", 45);
    freq.put("َقَ", 14);
    freq.put("هَذ", 18);
    freq.put("يجر", 29);
    freq.put("تري", 107);
    freq.put("ترو", 42);
    freq.put("ترى", 96);
    freq.put("ترن", 13);
    freq.put("تره", 28);
    freq.put("ترم", 57);
    freq.put("ترق", 32);
    freq.put("╬", 16);
    freq.put("ترف", 60);
    freq.put("طحت", 9);
    freq.put("ٰ ", 22);
    freq.put("وبن", 69);
    freq.put("يجع", 49);
    freq.put("ىء ", 13);
    freq.put(" مك", 195);
    freq.put("ﮨ", 11);
    freq.put("ف", 16797);
    freq.put("ٌ ", 279);
    freq.put("شا ", 11);
    freq.put("فّ ", 10);
    freq.put("كري", 163);
    freq.put("🔷?", 9);
    freq.put("نيت", 55);
    freq.put("يجب", 38);
    freq.put("وقَ", 11);
    freq.put(" ح ", 11);
    freq.put("وقو", 24);
    freq.put("وقي", 67);
    freq.put("يغا", 11);
    freq.put("دك ", 264);
    freq.put("وقه", 16);
    freq.put("وقن", 11);
    freq.put("َفَ", 9);
    freq.put("وقـ", 13);
    freq.put("وقك", 12);
    freq.put(" ،و", 19);
    freq.put("َفْ", 10);
    freq.put("لحص", 14);
    freq.put("لاج", 98);
    freq.put("يغض", 10);
    freq.put("يغر", 15);
    freq.put("شنب", 10);
    freq.put("لاس", 159);
    freq.put("̲", 9);
    freq.put("لعش", 44);
    freq.put("رسة", 19);
    freq.put("لاط", 21);
    freq.put("ﻡ ", 11);
    freq.put("ضد ", 19);
    freq.put("شنو", 17);
    freq.put("جو ", 33);
    freq.put(" ،،", 179);
    freq.put("عُ ", 27);
    freq.put("ٱل", 33);
    freq.put("ٱن", 12);
    freq.put("ب ", 4576);
    freq.put(" ،ا", 27);
    freq.put("وقد", 38);
    freq.put("يغي", 28);
    freq.put("وقت", 185);
    freq.put("أت ", 32);
    freq.put("يغف", 14);
    freq.put("⁰", 46);
    freq.put("وقع", 95);
    freq.put("وقر", 10);
    freq.put("لئك", 11);
    freq.put("تو ", 47);
    freq.put("متـ", 13);
    freq.put("تثب", 12);
    freq.put("سر ", 137);
    freq.put("؟", 968);
    freq.put("عبت", 23);
    freq.put("عبث", 12);
    freq.put("عبة", 20);
    freq.put("ﺤ", 36);
    freq.put("وطا", 21);
    freq.put("عبا", 99);
    freq.put("نُ ", 56);
    freq.put("لاً", 140);
    freq.put("عبر", 66);
    freq.put("نقا", 37);
    freq.put("لاو", 85);
    freq.put("ات ", 1477);
    freq.put("عبي", 42);
    freq.put("عبو", 23);
    freq.put("وطن", 85);
    freq.put("وطه", 11);
    freq.put("عبن", 9);
    freq.put("عبه", 27);
    freq.put("قسو", 19);
    freq.put("قسى", 15);
    freq.put("قسم", 43);
    freq.put("بْ ", 42);
    freq.put("مٍ ", 19);
    freq.put("حة ", 202);
    freq.put("طي ", 58);
    freq.put("تثن", 13);
    freq.put("طلق", 33);
    freq.put("تثق", 12);
    freq.put("اف ", 201);
    freq.put("ةع", 11);
    freq.put("وشه", 14);
    freq.put("🔺 ", 12);
    freq.put("وكل", 126);
    freq.put("وكم", 45);
    freq.put("ةة", 44);
    freq.put("وشل", 18);
    freq.put("ةا", 13);
    freq.put("برع", 16);
    freq.put("وشف", 11);
    freq.put("ة؟", 22);
    freq.put("برر", 14);
    freq.put("برش", 18);
    freq.put("برض", 9);
    freq.put("برب", 10);
    freq.put("برة", 19);
    freq.put("برت", 34);
    freq.put("برج", 9);
    freq.put("ة،", 70);
    freq.put("آء ", 64);
    freq.put("برد", 22);
    freq.put("ِلا", 24);
    freq.put("برا", 130);
    freq.put("وبس", 13);
    freq.put("َ ", 2436);
    freq.put("ِلّ", 15);
    freq.put("فغا", 10);
    freq.put("برو", 102);
    freq.put("ِلَ", 33);
    freq.put("بري", 133);
    freq.put("ِلي", 17);
    freq.put("برق", 9);
    freq.put("برك", 54);
    freq.put("ِلك", 13);
    freq.put("برم", 16);
    freq.put("برن", 59);
    freq.put("بره", 68);
    freq.put("ﻥ", 41);
    freq.put("ةِ", 32);
    freq.put("كُ ", 15);
    freq.put("ةً", 59);
    freq.put("ةٍ", 30);
    freq.put("ةٌ", 19);
    freq.put("ةُ", 33);
    freq.put("ةَ", 37);
    freq.put("وبع", 46);
    freq.put("صون", 13);
    freq.put("َك ", 33);
    freq.put("شل ", 42);
    freq.put("مَي", 9);
    freq.put("وبا", 202);
    freq.put("ت?", 10);
    freq.put("ت ", 6330);
    freq.put("َآت", 9);
    freq.put("إخل", 11);
    freq.put("إخو", 36);
    freq.put("زيـ", 21);
    freq.put(" ﺎل", 101);
    freq.put(" ﺎن", 17);
    freq.put("خـل", 13);
    freq.put("تح ", 82);
    freq.put("خــ", 22);
    freq.put("آيا", 21);
    freq.put("وص ", 10);
    freq.put("آية", 14);
    freq.put("أضح", 12);
    freq.put("قص ", 32);
    freq.put("طة ", 90);
    freq.put("ُزن", 18);
    freq.put("إخت", 40);
    freq.put("أخل", 31);
    freq.put("مِ ", 20);
    freq.put(" وﻻ", 19);
    freq.put("صه ", 33);
    freq.put("أجو", 10);
    freq.put("أجي", 18);
    freq.put("أجل", 74);
    freq.put("أجم", 105);
    freq.put("أجه", 9);
    freq.put(" دآ", 19);
    freq.put(" دع", 153);
    freq.put("وُق", 9);
    freq.put("🔝 ", 10);
    freq.put(" در", 138);
    freq.put("جيو", 11);
    freq.put("ضحي", 14);
    freq.put("ُد ", 21);
    freq.put("دبي", 28);
    freq.put("أخي", 44);
    freq.put("جيك", 38);
    freq.put("جيل", 37);
    freq.put("جيه", 20);
    freq.put("جين", 52);
    freq.put("أخو", 35);
    freq.put("جية", 30);
    freq.put("جيب", 110);
    freq.put("جيت", 52);
    freq.put("ﻷ", 44);
    freq.put("جيد", 59);
    freq.put("دبا", 12);
    freq.put("رگ ", 10);
    freq.put("دبر", 13);
    freq.put(" دَ", 22);
    freq.put(" دُ", 23);
    freq.put("أجد", 13);
    freq.put(" دي", 144);
    freq.put(" دو", 237);
    freq.put(" دن", 38);
    freq.put(" ده", 38);
    freq.put(" دل", 62);
    freq.put("أجا", 12);
    freq.put(" دق", 66);
    freq.put(" دك", 9);
    freq.put(" دف", 23);
    freq.put("أجع", 12);
    freq.put("قمر", 28);
    freq.put("أجر", 36);
    freq.put("تنت", 58);
    freq.put("تنة", 23);
    freq.put("تنب", 17);
    freq.put("تند", 10);
    freq.put("تنح", 10);
    freq.put("تنج", 12);
    freq.put("ضنا", 12);
    freq.put("تنآ", 11);
    freq.put("ذكر", 330);
    freq.put("تنا", 266);
    freq.put("سسس", 19);
    freq.put("██", 36);
    freq.put("تنظ", 23);
    freq.put("اگ", 18);
    freq.put("تنز", 19);
    freq.put("سسا", 12);
    freq.put("حطو", 10);
    freq.put("تنط", 14);
    freq.put("ذكا", 47);
    freq.put("يء ", 323);
    freq.put("تنش", 15);
    freq.put("اكف", 17);
    freq.put("اكك", 16);
    freq.put("اكم", 60);
    freq.put("اكل", 64);
    freq.put("اكن", 39);
    freq.put("اكو", 26);
    freq.put("اكي", 43);
    freq.put("ً،", 20);
    freq.put("اكِ", 16);
    freq.put("ھا ", 24);
    freq.put("اكا", 35);
    freq.put("اكب", 59);
    freq.put("اكث", 102);
    freq.put("اكت", 101);
    freq.put("اكد", 13);
    freq.put("اكر", 203);
    freq.put("۞ ", 22);
    freq.put("اكس", 28);
    freq.put("هاج", 28);
    freq.put("قمي", 15);
    freq.put("تني", 125);
    freq.put("تنو", 12);
    freq.put("تنَ", 13);
    freq.put("تنك", 12);
    freq.put("تنق", 21);
    freq.put("تنف", 33);
    freq.put("تنه", 21);
    freq.put(" ﷺ ", 33);
    freq.put("تنم", 18);
    freq.put("ذكي", 23);
    freq.put("حطا", 15);
    freq.put("،،،", 94);
    freq.put("حطة", 10);
    freq.put("اط", 400);
    freq.put("اض", 476);
    freq.put("اص", 597);
    freq.put("اش", 648);
    freq.put("اس", 2094);
    freq.put("از", 314);
    freq.put("ار", 2986);
    freq.put("اذ", 564);
    freq.put("اغ", 238);
    freq.put("اع", 1447);
    freq.put("اظ", 44);
    freq.put("اا", 1433);
    freq.put("ائ", 829);
    freq.put("اإ", 23);
    freq.put("اؤ", 33);
    freq.put("اأ", 45);
    freq.put("اآ", 26);
    freq.put("اء", 1668);
    freq.put("اد", 1865);
    freq.put("اخ", 878);
    freq.put("اح", 2063);
    freq.put("اج", 1232);
    freq.put("اث", 214);
    freq.put("ات", 3260);
    freq.put("اة", 410);
    freq.put("اب", 2821);
    freq.put("يَّ", 10);
    freq.put("نِ ", 28);
    freq.put("ا؟", 19);
    freq.put("يّه", 16);
    freq.put("يّل", 12);
    freq.put("يّـ", 12);
    freq.put("ار ", 844);
    freq.put("عكس", 25);
    freq.put("آدت", 9);
    freq.put("ا،", 95);
    freq.put("يّت", 14);
    freq.put("يّب", 11);
    freq.put("يّة", 15);
    freq.put("ى", 4747);
    freq.put("يّا", 20);
    freq.put("اٺ", 15);
    freq.put("آدي", 11);
    freq.put("آدم", 15);
    freq.put("۞", 27);
    freq.put("آ", 13);
    freq.put("اّ", 24);
    freq.put("اِ", 64);
    freq.put("كفر", 24);
    freq.put("إرز", 9);
    freq.put("رى ", 290);
    freq.put("إرض", 9);
    freq.put("اه", 1306);
    freq.put("ان", 6172);
    freq.put("ام", 2929);
    freq.put("ال", 30342);
    freq.put("اك", 1525);
    freq.put("اق", 1242);
    freq.put("اف", 1202);
    freq.put("اُ", 28);
    freq.put("اَ", 180);
    freq.put("اً", 1349);
    freq.put("اي", 1505);
    freq.put("اى", 10);
    freq.put("او", 777);
    freq.put("طول", 94);
    freq.put("مُق", 9);
    freq.put("تحز", 19);
    freq.put("تحس", 62);
    freq.put("تحر", 78);
    freq.put("تحض", 11);
    freq.put("تحط", 13);
    freq.put("تحص", 17);
    freq.put("تحت", 135);
    freq.put("تحب", 124);
    freq.put(" ⁰ ", 12);
    freq.put("مِي", 52);
    freq.put("تحد", 97);
    freq.put("مِن", 185);
    freq.put("زعي", 17);
    freq.put("مِل", 11);
    freq.put("تحا", 167);
    freq.put("ﯾ", 35);
    freq.put("وصا", 38);
    freq.put("آي ", 14);
    freq.put("عتب", 39);
    freq.put("وصح", 13);
    freq.put("وصخ", 9);
    freq.put("وصد", 15);
    freq.put("عتد", 14);
    freq.put("عتذ", 34);
    freq.put("ﺎ ", 49);
    freq.put("عتز", 13);
    freq.put("قصة", 23);
    freq.put("ﻨﺎ", 17);
    freq.put("قصد", 36);
    freq.put("ﺷ", 22);
    freq.put("زعل", 63);
    freq.put("وصل", 93);
    freq.put("نبو", 20);
    freq.put("عتق", 62);
    freq.put("عتك", 34);
    freq.put("عتم", 26);
    freq.put("عتن", 16);
    freq.put("عته", 40);
    freq.put("بہ ", 48);
    freq.put("عتي", 35);
    freq.put("وصو", 32);
    freq.put("وصي", 20);
    freq.put("قصي", 122);
    freq.put("قصو", 11);
    freq.put("قصف", 19);
    freq.put("قصه", 10);
    freq.put("يرة", 133);
    freq.put("تحِ", 10);
    freq.put("ئك ", 39);
    freq.put("تحو", 31);
    freq.put("تي،", 10);
    freq.put("تحَ", 15);
    freq.put("تحق", 130);
    freq.put("تحك", 39);
    freq.put("تحـ", 11);
    freq.put("تحف", 18);
    freq.put("تحه", 16);
    freq.put("تحل", 35);
    freq.put("تحم", 54);
    freq.put("خال", 105);
    freq.put("خام", 14);
    freq.put("خان", 19);
    freq.put("⬅", 16);
    freq.put("خاف", 80);
    freq.put("قها", 74);
    freq.put("خاو", 9);
    freq.put("خاي", 36);
    freq.put("ُط", 23);
    freq.put("﷽ ", 28);
    freq.put("ُص", 35);
    freq.put("فشل", 45);
    freq.put("أخا", 25);
    freq.put("اهو", 54);
    freq.put("ُدر", 12);
    freq.put("اهي", 117);
    freq.put("ِقت", 9);
    freq.put("جي ", 122);
    freq.put("دب ", 33);
    freq.put("ضح ", 27);
    freq.put("ِقُ", 11);
    freq.put("خائ", 12);
    freq.put("خاا", 9);
    freq.put("قم ", 44);
    freq.put("خاب", 26);
    freq.put("خات", 20);
    freq.put("خاص", 111);
    freq.put("خاط", 53);
    freq.put("خار", 44);
    freq.put("لظر", 17);
    freq.put("ً ", 1435);
    freq.put("تن ", 31);
    freq.put("ﺍ", 180);
    freq.put("ضن ", 18);
    freq.put("ابغ", 12);
    freq.put("ذك ", 10);
    freq.put("سس ", 19);
    freq.put("ةِ ", 31);
    freq.put("غفا", 46);
    freq.put(" ٱ", 55);
    freq.put("ز", 3631);
    freq.put("نٍ ", 15);
    freq.put("غفر", 379);
    freq.put("اك ", 617);
    freq.put("غفو", 16);
    freq.put("غفل", 18);
    freq.put("تيا", 58);
    freq.put("،، ", 173);
    freq.put("بِـ", 28);
    freq.put("َجع", 12);
    freq.put("ـيء", 9);
    freq.put("ۈلا", 11);
    freq.put("╰", 9);
    freq.put("حط ", 38);
    freq.put("بِم", 20);
    freq.put("هور", 72);
    freq.put("رىَ", 10);
    freq.put("ذمت", 10);
    freq.put("مبر", 44);
    freq.put("ا?", 12);
    freq.put("مبا", 80);
    freq.put("ا ", 15764);
    freq.put("مبد", 29);
    freq.put("مبت", 18);
    freq.put("ثون", 18);
    freq.put("ارد", 59);
    freq.put("ارح", 100);
    freq.put("ارج", 77);
    freq.put("ارث", 9);
    freq.put("ارت", 87);
    freq.put("ارة", 113);
    freq.put("ارب", 274);
    freq.put("ارا", 267);
    freq.put("عصب", 18);
    freq.put("ارغ", 11);
    freq.put("ارع", 53);
    freq.put("آد ", 18);
    freq.put("ارض", 60);
    freq.put("يجة", 13);
    freq.put("ارس", 73);
    freq.put("ارز", 38);
    freq.put("عصا", 28);
    freq.put("ارَ", 12);
    freq.put("اري", 252);
    freq.put("ارى", 18);
    freq.put("ارو", 72);
    freq.put("اره", 117);
    freq.put("ارن", 24);
    freq.put("ارك", 175);
    freq.put("ارق", 83);
    freq.put("ارف", 41);
    freq.put("نِي", 90);
    freq.put("عصي", 34);
    freq.put("مغا", 11);
    freq.put("وآل", 32);
    freq.put("ارِ", 20);
    freq.put("ِب ", 21);
    freq.put("ثور", 53);
    freq.put("ثوب", 19);
    freq.put("مبك", 10);
    freq.put("بِد", 11);
    freq.put("كف ", 15);
    freq.put("مبي", 14);
    freq.put(" 🇪", 10);
    freq.put("ثوا", 28);
    freq.put("أتي", 66);
    freq.put("أتو", 49);
    freq.put(" حا", 344);
    freq.put("بِح", 24);
    freq.put(" حآ", 22);
    freq.put(" حج", 53);
    freq.put(" حح", 11);
    freq.put("تيو", 16);
    freq.put(" حب", 283);
    freq.put(" حت", 264);
    freq.put("أتم", 24);
    freq.put(" حش", 14);
    freq.put(" حص", 42);
    freq.put(" حض", 31);
    freq.put(" حط", 29);
    freq.put(" حذ", 16);
    freq.put(" حر", 177);
    freq.put(" حز", 128);
    freq.put(" حس", 278);
    freq.put("نقط", 28);
    freq.put(" حظ", 59);
    freq.put("تيم", 18);
    freq.put("جوه", 21);
    freq.put("جون", 20);
    freq.put("جوم", 21);
    freq.put("تيل", 12);
    freq.put("جوك", 18);
    freq.put("نقص", 16);
    freq.put("جوف", 11);
    freq.put("عُو", 23);
    freq.put("بْ", 90);
    freq.put("تيك", 25);
    freq.put("بِ", 388);
    freq.put("بّ", 176);
    freq.put("جوي", 11);
    freq.put("دخل", 132);
    freq.put("ـيـ", 47);
    freq.put("بي", 2875);
    freq.put("بً", 21);
    freq.put("بو", 815);
    freq.put("بى", 56);
    freq.put("بَ", 300);
    freq.put("بُ", 156);
    freq.put("بٌ", 24);
    freq.put("بٍ", 15);
    freq.put("بق", 520);
    freq.put("بك", 1203);
    freq.put("بـ", 402);
    freq.put("بف", 48);
    freq.put("بن", 1039);
    freq.put("به", 1150);
    freq.put("بل", 903);
    freq.put("بم", 320);
    freq.put("جوا", 123);
    freq.put("بع", 1672);
    freq.put("جود", 100);
    freq.put("بس", 661);
    freq.put("بذ", 75);
    freq.put("بر", 1263);
    freq.put("بض", 84);
    freq.put("بط", 234);
    freq.put("بش", 286);
    freq.put("بص", 158);
    freq.put("بت", 942);
    freq.put("بث", 45);
    freq.put("بب", 265);
    freq.put("بة", 365);
    freq.put("بخ", 166);
    freq.put("بد", 875);
    freq.put("جور", 10);
    freq.put("بح", 864);
    freq.put("بآ", 102);
    freq.put("جة ", 120);
    freq.put("سيء", 18);
    freq.put("بئ", 20);
    freq.put("با", 3425);
    freq.put("جوع", 17);
    freq.put("بإ", 90);
    freq.put(" حل", 211);
    freq.put(" حم", 152);
    freq.put(" حن", 51);
    freq.put(" حـ", 41);
    freq.put(" حف", 36);
    freq.put(" حق", 204);
    freq.put(" ، ", 1766);
    freq.put(" حَ", 65);
    freq.put(" حُ", 72);
    freq.put("دكم", 30);
    freq.put("وق ", 257);
    freq.put(" حي", 442);
    freq.put("قهر", 36);
    freq.put("أتع", 23);
    freq.put(" حِ", 33);
    freq.put("ب،", 34);
    freq.put("مُت", 28);
    freq.put("يقك", 28);
    freq.put("أتذ", 11);
    freq.put("أتر", 9);
    freq.put("فتح", 114);
    freq.put("قهہ", 9);
    freq.put("سرع", 61);
    freq.put("مُب", 12);
    freq.put("ٍ ", 218);
    freq.put("توا", 201);
    freq.put("طين", 51);
    freq.put("توب", 122);
    freq.put("طيل", 9);
    freq.put("توت", 17);
    freq.put("توح", 35);
    freq.put("توج", 18);
    freq.put("تود", 34);
    freq.put("قة", 318);
    freq.put("تور", 51);
    freq.put("سرت", 20);
    freq.put("ات،", 15);
    freq.put("سرب", 9);
    freq.put("توص", 25);
    freq.put("افي", 232);
    freq.put("سرح", 19);
    freq.put("افو", 22);
    freq.put("توع", 15);
    freq.put("افن", 21);
    freq.put("؛", 250);
    freq.put("افل", 37);
    freq.put("افك", 27);
    freq.put("افق", 55);
    freq.put("افـ", 9);
    freq.put("ﺠ", 12);
    freq.put("اتغ", 14);
    freq.put("اتع", 57);
    freq.put("اتش", 24);
    freq.put("اتص", 32);
    freq.put("اتز", 10);
    freq.put("اتس", 57);
    freq.put("اتذ", 14);
    freq.put("اتر", 51);
    freq.put("اتخ", 29);
    freq.put("اتد", 11);
    freq.put("اتج", 33);
    freq.put("ا̄", 15);
    freq.put("اتت", 41);
    freq.put("اتب", 91);
    freq.put(" © ", 41);
    freq.put("اتا", 19);
    freq.put("بہ", 73);
    freq.put("بھ", 11);
    freq.put("اتِ", 40);
    freq.put("اتّ", 10);
    freq.put("اتَ", 17);
    freq.put("اتُ", 27);
    freq.put("بک", 13);
    freq.put("اتي", 209);
    freq.put("بگ", 18);
    freq.put("اتو", 61);
    freq.put("اتن", 105);
    freq.put("اته", 172);
    freq.put("اتل", 34);
    freq.put("اتم", 67);
    freq.put("اتق", 36);
    freq.put("اتك", 192);
    freq.put("اتـ", 13);
    freq.put("دُ ", 55);
    freq.put("توف", 113);
    freq.put("توك", 38);
    freq.put("توق", 134);
    freq.put("توم", 10);
    freq.put("تول", 20);
    freq.put("توه", 16);
    freq.put("افظ", 40);
    freq.put("توى", 15);
    freq.put("افض", 45);
    freq.put("توي", 757);
    freq.put("افس", 19);
    freq.put("افر", 61);
    freq.put("افذ", 9);
    freq.put("سري", 80);
    freq.put("افح", 14);
    freq.put("سرو", 24);
    freq.put("افت", 78);
    freq.put("افة", 89);
    freq.put("طيع", 86);
    freq.put("افا", 49);
    freq.put("سرق", 25);
    freq.put("سره", 18);
    freq.put("نٺ", 17);
    freq.put("طير", 61);
    freq.put(" 🌟", 15);
    freq.put("إسم", 24);
    freq.put("إسل", 45);
    freq.put("كُم", 26);
    freq.put("كُل", 111);
    freq.put(" 🌀", 15);
    freq.put("ة ", 7372);
    freq.put("َو", 152);
    freq.put("َى", 103);
    freq.put("َي", 276);
    freq.put("هوا", 48);
    freq.put("ََ", 11);
    freq.put("َـ", 96);
    freq.put("َف", 86);
    freq.put("َق", 122);
    freq.put("َك", 166);
    freq.put("َل", 456);
    freq.put("َم", 285);
    freq.put("َن", 305);
    freq.put("َه", 211);
    freq.put("بر ", 420);
    freq.put("َّ", 147);
    freq.put("تہ", 57);
    freq.put("ِل ", 33);
    freq.put("َب", 191);
    freq.put("َة", 94);
    freq.put("تھ", 19);
    freq.put("َث", 26);
    freq.put("َج", 79);
    freq.put("َح", 127);
    freq.put("َخ", 53);
    freq.put("َد", 216);
    freq.put("َء", 10);
    freq.put("َآ", 83);
    freq.put("َأ", 60);
    freq.put("َإ", 18);
    freq.put("َئ", 9);
    freq.put("َا", 879);
    freq.put(" 🍇", 10);
    freq.put("َع", 201);
    freq.put("َغ", 33);
    freq.put("تگ", 12);
    freq.put(" 🍃", 26);
    freq.put(" 🍁", 13);
    freq.put("َذ", 51);
    freq.put("َر", 191);
    freq.put("َز", 16);
    freq.put("َس", 108);
    freq.put("َش", 49);
    freq.put("َص", 35);
    freq.put("َض", 23);
    freq.put("َط", 51);
    freq.put("ﻡ", 13);
    freq.put("َ،", 9);
    freq.put("إسر", 20);
    freq.put("تا ", 38);
    freq.put("إست", 84);
    freq.put("چ", 10);
    freq.put("َكت", 15);
    freq.put("شلت", 10);
    freq.put("َہ", 36);
    freq.put("تِ", 202);
    freq.put("تّ", 76);
    freq.put("تْ", 58);
    freq.put("تٌ", 26);
    freq.put("تٍ", 16);
    freq.put("تَ", 499);
    freq.put("تُ", 386);
    freq.put("تو", 1825);
    freq.put("تى", 369);
    freq.put("تي", 1553);
    freq.put("تل", 581);
    freq.put("تم", 974);
    freq.put("تن", 868);
    freq.put("ته", 1271);
    freq.put("تـ", 228);
    freq.put("تف", 596);
    freq.put("تق", 829);
    freq.put("تك", 1420);
    freq.put("شلو", 53);
    freq.put("تظ", 147);
    freq.put("تع", 1222);
    freq.put("تغ", 761);
    freq.put("تش", 408);
    freq.put("تص", 418);
    freq.put("تض", 183);
    freq.put("تط", 284);
    freq.put("تذ", 201);
    freq.put("تر", 1434);
    freq.put("تز", 193);
    freq.put("تس", 837);
    freq.put("تج", 474);
    freq.put("تح", 1305);
    freq.put("تخ", 393);
    freq.put("تد", 336);
    freq.put("تب", 1044);
    freq.put("تة", 29);
    freq.put("تت", 456);
    freq.put("تث", 50);
    freq.put("تؤ", 34);
    freq.put("تئ", 16);
    freq.put("تا", 1419);
    freq.put(" 🏉", 12);
    freq.put("تأ", 194);
    freq.put("ت؟", 17);
    freq.put("َكِ", 12);
    freq.put("َكْ", 11);
    freq.put("ت،", 32);
    freq.put("َكَ", 16);
    freq.put("َكُ", 22);
    freq.put("َآ ", 15);
    freq.put("ھَ ", 10);
    freq.put("تقط", 23);
    freq.put("سطو", 15);
    freq.put("تقص", 24);
    freq.put("سطي", 22);
    freq.put("شتغ", 12);
    freq.put("تقر", 58);
    freq.put("ذب ", 60);
    freq.put("تقع", 20);
    freq.put("تقا", 69);
    freq.put("ضيت", 16);
    freq.put("ضية", 35);
    freq.put("مهو", 43);
    freq.put("حسي", 32);
    freq.put("ضيح", 11);
    freq.put("حسو", 13);
    freq.put("تقد", 125);
    freq.put("حسن", 220);
    freq.put("ءً ", 16);
    freq.put("ضيا", 23);
    freq.put("تقت", 54);
    freq.put("مهم", 170);
    freq.put("تقب", 88);
    freq.put("نتي", 172);
    freq.put("سـت", 9);
    freq.put("حه ", 176);
    freq.put("نتُ", 16);
    freq.put("نتَ", 47);
    freq.put("نتك", 32);
    freq.put(" لس", 125);
    freq.put("نتف", 20);
    freq.put("نته", 101);
    freq.put("نتن", 11);
    freq.put("نتم", 59);
    freq.put("سـا", 15);
    freq.put("ـان", 42);
    freq.put("اس ", 535);
    freq.put("ـال", 44);
    freq.put("ـام", 13);
    freq.put("ـاق", 12);
    freq.put("ـاك", 10);
    freq.put("نتِ", 41);
    freq.put("ـاي", 11);
    freq.put("ـاً", 20);
    freq.put("اُح", 9);
    freq.put("يقط", 11);
    freq.put("ثي ", 11);
    freq.put("نتب", 19);
    freq.put("ـاس", 22);
    freq.put("نتح", 19);
    freq.put("ـار", 27);
    freq.put("ســ", 43);
    freq.put("نتا", 39);
    freq.put("ـاا", 10);
    freq.put("نتع", 10);
    freq.put("جل ", 292);
    freq.put("ـاء", 17);
    freq.put("ـاد", 31);
    freq.put("هدا", 83);
    freq.put("ـات", 18);
    freq.put("ـاب", 27);
    freq.put("نتش", 23);
    freq.put("سطة", 12);
    freq.put("ذها", 19);
    freq.put("٤", 43);
    freq.put("تقِ", 10);
    freq.put("ضيّ", 9);
    freq.put("حسر", 10);
    freq.put("حسد", 15);
    freq.put("تقن", 18);
    freq.put("تقل", 58);
    freq.put("ت، ", 29);
    freq.put("تقف", 12);
    freq.put("حسب", 122);
    freq.put("حسا", 183);
    freq.put("ضيق", 84);
    freq.put("ضيف", 183);
    freq.put("ضيه", 20);
    freq.put("حسآ", 11);
    freq.put("تقو", 183);
    freq.put("وآح", 20);
    freq.put("مهہ", 12);
    freq.put("بوس", 29);
    freq.put("يقا", 81);
    freq.put("بور", 67);
    freq.put("كمل", 46);
    freq.put("فأن", 50);
    freq.put("بوع", 56);
    freq.put("فتي", 52);
    freq.put("رآ ", 28);
    freq.put(" ﻻ ", 50);
    freq.put("بوا", 98);
    freq.put(" ̶̶", 20);
    freq.put("بوت", 14);
    freq.put("بوب", 27);
    freq.put("بود", 9);
    freq.put("بوح", 52);
    freq.put("بوج", 28);
    freq.put("كما", 127);
    freq.put("لة ", 510);
    freq.put("نقل", 45);
    freq.put("فأح", 14);
    freq.put("بوك", 32);
    freq.put("بوق", 13);
    freq.put("بوه", 22);
    freq.put("بون", 130);
    freq.put("بول", 29);
    freq.put("بوي", 44);
    freq.put("فأع", 9);
    freq.put("فتق", 39);
    freq.put("فتك", 55);
    freq.put("ق، ", 16);
    freq.put("ﻴ", 93);
    freq.put("هَل", 13);
    freq.put("ئف ", 9);
    freq.put("فته", 52);
    freq.put("َمَ", 32);
    freq.put("لآي", 19);
    freq.put("َمي", 23);
    freq.put("رخص", 10);
    freq.put("َمل", 9);
    freq.put("٣٠", 9);
    freq.put("لآم", 28);
    freq.put("ظلم", 62);
    freq.put("لآه", 9);
    freq.put("لآن", 114);
    freq.put("زه ", 40);
    freq.put("ونو", 43);
    freq.put("وني", 266);
    freq.put("يضح", 16);
    freq.put("ونَ", 69);
    freq.put("ونف", 15);
    freq.put("ونـ", 18);
    freq.put("ونك", 113);
    freq.put("ونق", 14);
    freq.put("َمْ", 50);
    freq.put("َمِ", 21);
    freq.put("َمّ", 11);
    freq.put("¡", 16);
    freq.put("؟؟ ", 48);
    freq.put("شقت", 9);
    freq.put("ها ", 2411);
    freq.put("غ", 3664);
    freq.put("شقا", 16);
    freq.put(" م ", 144);
    freq.put("ّها", 18);
    freq.put(" ۆ ", 33);
    freq.put("شقي", 21);
    freq.put("ون،", 11);
    freq.put("دت ", 108);
    freq.put("شقك", 11);
    freq.put("عك ", 164);
    freq.put("شقه", 15);
    freq.put("ونع", 31);
    freq.put("وآت", 12);
    freq.put("لآت", 10);
    freq.put("َمت", 19);
    freq.put("نش ", 13);
    freq.put("َما", 20);
    freq.put("ونس", 39);
    freq.put("قك ", 138);
    freq.put("ونش", 14);
    freq.put("ونة", 29);
    freq.put("يضي", 74);
    freq.put("ونت", 29);
    freq.put("ونح", 16);
    freq.put("ﻝ ", 13);
    freq.put("وند", 11);
    freq.put("هله", 63);
    freq.put("هلو", 11);
    freq.put("هلي", 64);
    freq.put("ونا", 123);
    freq.put("رِي", 27);
    freq.put("تاي", 36);
    freq.put("تاً", 13);
    freq.put(" رَ", 58);
    freq.put("تاف", 10);
    freq.put("تاق", 84);
    freq.put("تاك", 19);
    freq.put("تال", 33);
    freq.put("تل ", 76);
    freq.put("تان", 95);
    freq.put("تاه", 40);
    freq.put("ضل ", 117);
    freq.put("ـِ ", 24);
    freq.put(" ● ", 15);
    freq.put("▄▄▄", 10);
    freq.put("عجز", 41);
    freq.put("وخا", 10);
    freq.put("سَ ", 82);
    freq.put("عجا", 18);
    freq.put("وثا", 11);
    freq.put("عجب", 81);
    freq.put("ططط", 19);
    freq.put("يدر", 30);
    freq.put("ﻊ", 13);
    freq.put("عجل", 33);
    freq.put("ــ ", 44);
    freq.put("عجي", 13);
    freq.put("عذب", 31);
    freq.put("عجو", 11);
    freq.put("ﻭ ", 9);
    freq.put("تاب", 530);
    freq.put("تاة", 39);
    freq.put("تات", 24);
    freq.put("تاج", 146);
    freq.put("تاح", 58);
    freq.put("تاخ", 18);
    freq.put("تاء", 13);
    freq.put("تائ", 11);
    freq.put("تاا", 16);
    freq.put("تاع", 23);
    freq.put("تاذ", 38);
    freq.put("تار", 83);
    freq.put("تاز", 13);
    freq.put("", 9);
    freq.put("آح ", 23);
    freq.put("٤ ", 24);
    freq.put("لتز", 62);
    freq.put("جرو", 42);
    freq.put(" لہ", 22);
    freq.put("جري", 52);
    freq.put("جرم", 10);
    freq.put("جرن", 14);
    freq.put("جره", 20);
    freq.put("لتش", 30);
    freq.put("ﺳ", 49);
    freq.put("̶", 91);
    freq.put("لتغ", 112);
    freq.put("يُ ", 29);
    freq.put("غد ", 11);
    freq.put("جرح", 81);
    freq.put("جرد", 35);
    freq.put("جرب", 48);
    freq.put("جرة", 14);
    freq.put("جرت", 11);
    freq.put("جرا", 38);
    freq.put("كك ", 177);
    freq.put(" لگ", 16);
    freq.put("مؤل", 45);
    freq.put("مؤم", 48);
    freq.put("هُو", 38);
    freq.put("حما", 53);
    freq.put("حمد", 531);
    freq.put("حمة", 41);
    freq.put("حمت", 46);
    freq.put("حمص", 9);
    freq.put("آج", 83);
    freq.put("حمر", 17);
    freq.put("حمس", 10);
    freq.put("حمل", 96);
    freq.put("حمه", 65);
    freq.put("حمن", 71);
    freq.put("حمَ", 9);
    freq.put("حمو", 19);
    freq.put("حمي", 93);
    freq.put("ئ ", 157);
    freq.put("حمّ", 12);
    freq.put("ُّ ", 13);
    freq.put("ْعَ", 20);
    freq.put("َه ", 46);
    freq.put(" لھ", 9);
    freq.put("مؤت", 9);
    freq.put("مؤث", 12);
    freq.put("يدك", 49);
    freq.put("ول ", 1036);
    freq.put("يدن", 24);
    freq.put("قر ", 50);
    freq.put("ﻭﺍ", 10);
    freq.put("يده", 157);
    freq.put("شيد", 12);
    freq.put("ئهم", 18);
    freq.put("صال", 112);
    freq.put("خلو", 70);
    freq.put("خلي", 186);
    freq.put("خلف", 66);
    freq.put("خلك", 26);
    freq.put("خلق", 125);
    freq.put("خله", 37);
    freq.put("خلن", 20);
    freq.put("وة ", 177);
    freq.put("يدَ", 9);
    freq.put("خلّ", 9);
    freq.put("خلت", 20);
    freq.put("ﷺ ", 35);
    freq.put("خلا", 163);
    freq.put("نہ ", 54);
    freq.put("خلص", 56);
    freq.put("رْ ", 15);
    freq.put("تة ", 23);
    freq.put("ئها", 12);
    freq.put("ِن ", 125);
    freq.put("بس ", 388);
    freq.put(" سع", 166);
    freq.put(" سر", 102);
    freq.put(" سط", 15);
    freq.put(" ست", 127);
    freq.put(" سب", 262);
    freq.put("زمة", 10);
    freq.put(" سخ", 19);
    freq.put(" سد", 14);
    freq.put(" سج", 39);
    freq.put(" سح", 25);
    freq.put(" سآ", 9);
    freq.put(" سأ", 62);
    freq.put(" سئ", 17);
    freq.put(" سا", 279);
    freq.put(" سؤ", 62);
    freq.put(" ̶ ", 22);
    freq.put("ّما", 9);
    freq.put("▄ ", 30);
    freq.put("ضرو", 28);
    freq.put("عفو", 56);
    freq.put("عفي", 10);
    freq.put("ضرك", 9);
    freq.put("ضره", 10);
    freq.put(" ۈل", 17);
    freq.put("ضرر", 15);
    freq.put("فظ ", 78);
    freq.put("عفا", 12);
    freq.put(" ۈا", 15);
    freq.put("ضرا", 15);
    freq.put(" سِ", 24);
    freq.put(" سي", 277);
    freq.put("ه، ", 86);
    freq.put(" سو", 404);
    freq.put(" سَ", 114);
    freq.put(" سُ", 46);
    freq.put(" سق", 35);
    freq.put(" سك", 74);
    freq.put(" سـ", 24);
    freq.put(" سف", 25);
    freq.put(" سن", 167);
    freq.put(" سه", 88);
    freq.put(" سل", 131);
    freq.put(" سم", 126);
    freq.put("˘̩̩", 15);
    freq.put("آحب", 36);
    freq.put("،", 3338);
    freq.put("آحس", 12);
    freq.put("شره", 54);
    freq.put("ولہ", 11);
    freq.put("ككم", 11);
    freq.put("ككك", 36);
    freq.put("شرف", 33);
    freq.put("شرق", 29);
    freq.put("إت", 30);
    freq.put("ئہ", 12);
    freq.put("يُق", 17);
    freq.put("يُم", 18);
    freq.put("يُن", 20);
    freq.put("يُو", 21);
    freq.put("فهم", 138);
    freq.put("يُر", 24);
    freq.put("يُس", 12);
    freq.put("يُش", 9);
    freq.put("يُص", 11);
    freq.put("يُع", 25);
    freq.put("٤٠", 9);
    freq.put("?🌹", 34);
    freq.put("يُب", 11);
    freq.put("يُح", 30);
    freq.put("يُخ", 9);
    freq.put("⃣", 31);
    freq.put("غدا", 66);
    freq.put("آحي", 9);
    freq.put("ككر", 9);
    freq.put(" س", 2770);
    freq.put("وَب", 12);
    freq.put("جر ", 114);
    freq.put("َهم", 12);
    freq.put("َهَ", 17);
    freq.put("َهُ", 63);
    freq.put("وله", 183);
    freq.put("ولن", 51);
    freq.put("ولم", 53);
    freq.put("ولل", 30);
    freq.put(" ذ", 588);
    freq.put("ولف", 41);
    freq.put("ولـ", 35);
    freq.put("ولَ", 23);
    freq.put("ولي", 224);
    freq.put("ولى", 35);
    freq.put("ولو", 510);
    freq.put("ئِ", 50);
    freq.put("لتف", 67);
    freq.put("لزم", 90);
    freq.put("حم ", 71);
    freq.put("شـر", 9);
    freq.put("لتك", 60);
    freq.put("ئـ", 12);
    freq.put("ئف", 23);
    freq.put("ئق", 36);
    freq.put("ئك", 65);
    freq.put("ئل", 118);
    freq.put("ئم", 151);
    freq.put("ئن", 72);
    freq.put("ئه", 78);
    freq.put("ئو", 13);
    freq.put("¸", 11);
    freq.put("ئي", 198);
    freq.put("ئً", 12);
    freq.put("لتل", 33);
    freq.put("ئر", 47);
    freq.put("ئز", 13);
    freq.put("ئس", 9);
    freq.put("ئش", 10);
    freq.put("ئع", 62);
    freq.put("ئا", 118);
    freq.put("ئب", 53);
    freq.put("ئة", 54);
    freq.put("ئت", 46);
    freq.put("ئح", 14);
    freq.put("ئد", 50);
    freq.put("َها", 14);
    freq.put("ولس", 12);
    freq.put(" ط", 922);
    freq.put("ولا", 756);
    freq.put("ولئ", 14);
    freq.put("ولأ", 10);
    freq.put("يظل", 9);
    freq.put("يظه", 14);
    freq.put("ولد", 72);
    freq.put("رٍ ", 16);
    freq.put("ولت", 28);
    freq.put("ولة", 76);
    freq.put("قرا", 99);
    freq.put("قرآ", 63);
    freq.put("قرأ", 63);
    freq.put("قرب", 89);
    freq.put("ؤتم", 10);
    freq.put("قرر", 15);
    freq.put("ْلِ", 13);
    freq.put("خل ", 138);
    freq.put("ْلَ", 11);
    freq.put("ﻝ", 14);
    freq.put("قرن", 12);
    freq.put("قري", 92);
    freq.put("قرو", 24);
    freq.put("⁰ ", 18);
    freq.put("رْض", 9);
    freq.put("ئه ", 37);
    freq.put("بسا", 23);
    freq.put("ِنا", 15);
    freq.put("بسب", 40);
    freq.put("🔙ل", 9);
    freq.put("ِند", 17);
    freq.put("بسس", 9);
    freq.put("بسر", 15);
    freq.put("بسط", 26);
    freq.put(" س ", 17);
    freq.put("ﻮﻥ", 11);
    freq.put("فظك", 11);
    freq.put("فظه", 27);
    freq.put("فظي", 9);
    freq.put("فظو", 12);
    freq.put("ﻮﺍ", 10);
    freq.put("سدح", 14);
    freq.put("ٍ", 254);
    freq.put("ضر ", 39);
    freq.put(" ۈ ", 49);
    freq.put("عف ", 22);
    freq.put("وسا", 23);
    freq.put("ِنك", 11);
    freq.put("بسه", 17);
    freq.put("بسم", 40);
    freq.put("بسي", 34);
    freq.put("بسو", 12);
    freq.put("ِني", 9);
    freq.put("ِنَ", 35);
    freq.put("ِنّ", 25);
    freq.put("ِنْ", 46);
    freq.put("قف ", 87);
    freq.put(" طع", 28);
    freq.put("ذبة", 10);
    freq.put("ذبح", 14);
    freq.put("رُك", 15);
    freq.put("ضي ", 140);
    freq.put("رُو", 32);
    freq.put("اسر", 50);
    freq.put("حها", 20);
    freq.put("اسط", 21);
    freq.put("اسع", 41);
    freq.put("اسأ", 47);
    freq.put("اسا", 61);
    freq.put("اسئ", 10);
    freq.put("اسة", 42);
    freq.put("اسب", 79);
    freq.put("است", 539);
    freq.put("اسج", 9);
    freq.put("اسد", 13);
    freq.put("اسّ", 13);
    freq.put("حهم", 13);
    freq.put("نت ", 920);
    freq.put("اسف", 26);
    freq.put("اسـ", 10);
    freq.put("اسك", 50);
    freq.put("اسق", 11);
    freq.put("اسم", 176);
    freq.put("اسل", 62);
    freq.put("اسه", 38);
    freq.put("اسن", 11);
    freq.put("اسو", 60);
    freq.put("اسي", 113);
    freq.put("٠", 161);
    freq.put("ؤه ", 13);
    freq.put("ذه ", 165);
    freq.put("سط ", 50);
    freq.put("إي", 134);
    freq.put("ذبه", 20);
    freq.put("ذبن", 12);
    freq.put("فها", 59);
    freq.put("إل", 973);
    freq.put("مه ", 440);
    freq.put("إه", 35);
    freq.put("مئن", 21);
    freq.put("حس ", 85);
    freq.put("إن", 903);
    freq.put("شرب", 40);
    freq.put("وسف", 16);
    freq.put("إك", 17);
    freq.put("عى ", 25);
    freq.put("خنق", 12);
    freq.put("رآء", 9);
    freq.put("بو ", 110);
    freq.put("شأن", 14);
    freq.put("رآت", 11);
    freq.put("رآح", 11);
    freq.put("حهہ", 9);
    freq.put("آوي", 10);
    freq.put("كم ", 846);
    freq.put("آول", 14);
    freq.put("سلط", 30);
    freq.put("رآم", 9);
    freq.put("رآن", 64);
    freq.put("⭕⭕", 12);
    freq.put("إجا", 18);
    freq.put("شرع", 12);
    freq.put("ﻰ", 20);
    freq.put("إجع", 17);
    freq.put("زهر", 22);
    freq.put(" رز", 16);
    freq.put(" رس", 146);
    freq.put(" رص", 9);
    freq.put(" رض", 67);
    freq.put("قكم", 15);
    freq.put(" رغ", 52);
    freq.put("هل ", 385);
    freq.put(" رآ", 25);
    freq.put(" رأ", 82);
    freq.put(" رؤ", 18);
    freq.put(" رئ", 30);
    freq.put(" را", 320);
    freq.put(" رب", 471);
    freq.put("ها،", 27);
    freq.put(" رت", 339);
    freq.put("يض ", 65);
    freq.put(" رج", 167);
    freq.put(" رح", 157);
    freq.put(" رخ", 10);
    freq.put(" رد", 69);
    freq.put("هاش", 31);
    freq.put("هار", 58);
    freq.put("هاذ", 14);
    freq.put("هاز", 16);
    freq.put("جہ ", 11);
    freq.put("دتن", 15);
    freq.put("دته", 37);
    freq.put("هاا", 54);
    freq.put("هائ", 40);
    freq.put("هاء", 14);
    freq.put("دتك", 48);
    freq.put("ض", 3636);
    freq.put("شق ", 113);
    freq.put("هاد", 96);
    freq.put("دتي", 50);
    freq.put("هاب", 46);
    freq.put("عكم", 17);
    freq.put("هات", 52);
    freq.put("ة، ", 60);
    freq.put("ﻬﺎ", 9);
    freq.put("٣ ", 30);
    freq.put("هام", 39);
    freq.put("هال", 164);
    freq.put("هاه", 16);
    freq.put("هان", 39);
    freq.put("هاك", 9);
    freq.put("سلح", 13);
    freq.put("هاو", 25);
    freq.put("هاي", 87);
    freq.put("أخط", 31);
    freq.put("أخذ", 41);
    freq.put("أخر", 87);
    freq.put("لآ ", 227);
    freq.put("َم ", 38);
    freq.put(" رف", 63);
    freq.put(" رق", 45);
    freq.put(" رك", 31);
    freq.put(" رم", 62);
    freq.put(" رو", 212);
    freq.put("ون ", 1803);
    freq.put(" ري", 338);
    freq.put("أخت", 39);
    freq.put("أخب", 44);
    freq.put(" رُ", 26);
    freq.put("مكا", 108);
    freq.put("تلب", 15);
    freq.put("تلت", 16);
    freq.put("تلا", 73);
    freq.put("حصل", 38);
    freq.put("حصن", 12);
    freq.put("تلع", 23);
    freq.put("ضلا", 19);
    freq.put("حصو", 11);
    freq.put("حصي", 10);
    freq.put("سَا", 49);
    freq.put("عمَ", 10);
    freq.put("سَت", 14);
    freq.put("سَب", 19);
    freq.put("سَر", 12);
    freq.put("وث ", 10);
    freq.put("عمك", 10);
    freq.put("سَع", 21);
    freq.put("سَن", 9);
    freq.put("سَل", 16);
    freq.put("سَي", 13);
    freq.put("سَى", 10);
    freq.put("طط ", 12);
    freq.put("سَّ", 9);
    freq.put("لآق", 10);
    freq.put("تلى", 14);
    freq.put("تلو", 29);
    freq.put("تلي", 38);
    freq.put("تلم", 22);
    freq.put("تله", 20);
    freq.put("تلن", 9);
    freq.put("تلف", 59);
    freq.put("تلك", 68);
    freq.put("تلق", 61);
    freq.put("حصا", 12);
    freq.put("ضله", 10);
    freq.put("ضلو", 14);
    freq.put("ؤمن", 64);
    freq.put("سلف", 18);
    freq.put("ثار", 15);
    freq.put("ِال", 17);
    freq.put("ثاء", 10);
    freq.put("قما", 17);
    freq.put(" ̸ ", 13);
    freq.put("ﻚ ", 20);
    freq.put("ُّو", 11);
    freq.put("شْ", 15);
    freq.put("ئًا", 11);
    freq.put("ُ ", 972);
    freq.put("رؤي", 24);
    freq.put("?🔮", 16);
    freq.put("?🔰", 9);
    freq.put("ثال", 40);
    freq.put("ثان", 104);
    freq.put("ثاً", 13);
    freq.put(" طه", 10);
    freq.put(" طل", 85);
    freq.put(" طم", 23);
    freq.put(" طق", 9);
    freq.put(" طـ", 9);
    freq.put(" طف", 59);
    freq.put(" طَ", 14);
    freq.put(" طي", 136);
    freq.put(" طو", 118);
    freq.put("كلت", 45);
    freq.put("كأس", 22);
    freq.put("لمي", 268);
    freq.put("نخل", 12);
    freq.put("٥ ", 21);
    freq.put("الص", 736);
    freq.put(" طا", 160);
    freq.put(" ٢٠", 10);
    freq.put(" طح", 13);
    freq.put(" طب", 81);
    freq.put(" طر", 142);
    freq.put("◾", 30);
    freq.put("?👆", 9);
    freq.put("عمة", 22);
    freq.put("مكن", 145);
    freq.put("مكم", 20);
    freq.put("عمت", 12);
    freq.put("عمد", 15);
    freq.put("سلس", 15);
    freq.put("مكي", 36);
    freq.put("عما", 88);
    freq.put("حك ", 141);
    freq.put("سلا", 201);
    freq.put("عمر", 205);
    freq.put("غمض", 14);
    freq.put("سلب", 13);
    freq.put("سلت", 9);
    freq.put("عمى", 15);
    freq.put("عمو", 16);
    freq.put("عمي", 32);
    freq.put("سلّ", 11);
    freq.put("يذك", 18);
    freq.put("ﻠ", 74);
    freq.put("💔 ", 9);
    freq.put("عمق", 11);
    freq.put("عمل", 358);
    freq.put("عمه", 26);
    freq.put("سلم", 327);
    freq.put("سله", 11);
    freq.put("مكس", 14);
    freq.put("💔?", 9);
    freq.put("مكر", 27);
    freq.put("سلك", 14);
    freq.put("سلو", 49);
    freq.put("سلي", 43);
    freq.put("ضَا", 13);
    freq.put("ؤكد", 14);
    freq.put("مآ ", 128);
    freq.put("ءُ ", 11);
    freq.put("اً،", 20);
    freq.put("تي ", 1027);
    freq.put("نصا", 23);
    freq.put("فاً", 24);
    freq.put("فاي", 37);
    freq.put("فاو", 9);
    freq.put("فاه", 33);
    freq.put("فان", 92);
    freq.put("فال", 145);
    freq.put("فاك", 29);
    freq.put("فاق", 60);
    freq.put("فاف", 22);
    freq.put("رئ ", 16);
    freq.put("?💃", 13);
    freq.put("فاح", 18);
    freq.put("فاج", 25);
    freq.put("فات", 118);
    freq.put("ئم ", 34);
    freq.put("فاا", 14);
    freq.put("فائ", 28);
    freq.put("فاؤ", 10);
    freq.put("ظاه", 20);
    freq.put("?💍", 17);
    freq.put("?〰", 14);
    freq.put("فاع", 37);
    freq.put("فاظ", 11);
    freq.put("فاط", 10);
    freq.put("فاض", 29);
    freq.put("?💙", 10);
    freq.put("فاش", 16);
    freq.put("فاس", 39);
    freq.put("فاز", 9);
    freq.put("فار", 144);
    freq.put("?💜", 16);
    freq.put("?💧", 10);
    freq.put("ذرا", 17);
    freq.put("يآ ", 43);
    freq.put("ل؟ ", 11);
    freq.put(" ص ", 12);
    freq.put("وحش", 33);
    freq.put("وحس", 18);
    freq.put("وحد", 169);
    freq.put("وحب", 23);
    freq.put("طري", 168);
    freq.put("عآد", 25);
    freq.put("طره", 19);
    freq.put("وحا", 24);
    freq.put("طرك", 15);
    freq.put("طرق", 22);
    freq.put("طرف", 28);
    freq.put("ِّ ", 13);
    freq.put("طرد", 12);
    freq.put("وحو", 11);
    freq.put("طرة", 12);
    freq.put("طرب", 9);
    freq.put("طرا", 35);
    freq.put("وحن", 13);
    freq.put("وحه", 21);
    freq.put("عآل", 16);
    freq.put("عآم", 9);
    freq.put("وحق", 11);
    freq.put("وحك", 13);
    freq.put("ذرو", 10);
    freq.put("٨", 23);
    freq.put("ذري", 12);
    freq.put("ﻌ", 45);
    freq.put("قُ ", 38);
    freq.put("فاد", 16);
    freq.put("ِيد", 12);
    freq.put("أى ", 16);
    freq.put("بطب", 9);
    freq.put("بطا", 26);
    freq.put("ِيا", 14);
    freq.put("آآآ", 16);
    freq.put("ِيع", 11);
    freq.put("زع ", 20);
    freq.put("يخي", 19);
    freq.put("ﺘ", 53);
    freq.put("ِير", 27);
    freq.put("بطر", 26);
    freq.put("دئ ", 12);
    freq.put("فاة", 11);
    freq.put("عه ", 252);
    freq.put("▪", 20);
    freq.put("يم،", 16);
    freq.put("َبر", 14);
    freq.put("حر ", 80);
    freq.put("٢٠", 15);
    freq.put("نب ", 55);
    freq.put("فاء", 67);
    freq.put("ـة ", 50);
    freq.put("ِيَ", 18);
    freq.put("بطي", 21);
    freq.put("بطو", 16);
    freq.put("بطن", 13);
    freq.put("ِيل", 36);
    freq.put("بطل", 26);
    freq.put("ِين", 86);
    freq.put("ِيك", 13);
    freq.put("ِيق", 13);
    freq.put("سة ", 109);
    freq.put("ِيّ", 39);
    freq.put("ِيِ", 10);
    freq.put("ِيْ", 33);
    freq.put("مجت", 29);
    freq.put("٠ ", 74);
    freq.put("?🙏", 25);
    freq.put("آة ", 25);
    freq.put("̐", 12);
    freq.put("فاص", 28);
    freq.put(" ", 19);
    freq.put("رمه", 21);
    freq.put("ک", 108);
    freq.put("١٠٠", 14);
    freq.put("بي ", 1054);
    freq.put("?😂", 71);
    freq.put("?😁", 12);
    freq.put("رمي", 33);
    freq.put("كه ", 57);
    freq.put("ُك ", 55);
    freq.put("ہا ", 35);
    freq.put("ا̄ﻟ", 13);
    freq.put("?😭", 11);
    freq.put("اعا", 80);
    freq.put("اعد", 117);
    freq.put("اعج", 15);
    freq.put("اعت", 116);
    freq.put("اعة", 116);
    freq.put("اعب", 76);
    freq.put("اعط", 25);
    freq.put("اعش", 28);
    freq.put("اعز", 21);
    freq.put("اعر", 139);
    freq.put("هن ", 37);
    freq.put("يش ", 270);
    freq.put("اعظ", 12);
    freq.put("حفر", 13);
    freq.put("حفظ", 107);
    freq.put("ن", 38977);
    freq.put("ثِق", 13);
    freq.put("ثِي", 10);
    freq.put("🇸 ", 19);
    freq.put("حفل", 16);
    freq.put("اعه", 77);
    freq.put("اعن", 30);
    freq.put("اعم", 86);
    freq.put("اعل", 98);
    freq.put("اعك", 9);
    freq.put("اعف", 9);
    freq.put("اعـ", 12);
    freq.put("اعَ", 10);
    freq.put("اگ ", 11);
    freq.put("اعو", 20);
    freq.put("لغز", 9);
    freq.put("اعِ", 13);
    freq.put("?🚸", 9);
    freq.put("عرا", 56);
    freq.put("ذر ", 55);
    freq.put(" صع", 33);
    freq.put(" صغ", 51);
    freq.put("ئية", 20);
    freq.put("قُو", 19);
    freq.put(" صح", 141);
    freq.put(" صد", 259);
    freq.put(" صب", 276);
    freq.put(" صا", 259);
    freq.put("قُل", 36);
    freq.put(" صآ", 15);
    freq.put("ِّي", 9);
    freq.put("صغي", 54);
    freq.put("رتب", 14);
    freq.put("وح ", 234);
    freq.put("ضطر", 20);
    freq.put("جِد", 16);
    freq.put("يخط", 16);
    freq.put("صغر", 22);
    freq.put("طر ", 144);
    freq.put(" ٠٠", 9);
    freq.put("قُر", 19);
    freq.put("قُب", 9);
    freq.put("طلو", 15);
    freq.put(" صَ", 67);
    freq.put(" صُ", 12);
    freq.put(" صو", 231);
    freq.put(" صي", 28);
    freq.put(" صل", 270);
    freq.put(" صم", 36);
    freq.put(" صن", 22);
    freq.put(" صـ", 29);
    freq.put("دَ ", 51);
    freq.put("٢ ", 28);
    freq.put("تـر", 13);
    freq.put("ضور", 29);
    freq.put("ِي ", 323);
    freq.put("بط ", 60);
    freq.put("ممَ", 12);
    freq.put("تـح", 10);
    freq.put("ممي", 35);
    freq.put("ممم", 65);
    freq.put("ممل", 23);
    freq.put("ضوا", 17);
    freq.put("ممن", 38);
    freq.put("ضوء", 17);
    freq.put("تـا", 14);
    freq.put("حرف", 34);
    freq.put("حرك", 39);
    freq.put("حرق", 29);
    freq.put("حرم", 77);
    freq.put("ْرِ", 9);
    freq.put("ا", 91633);
    freq.put("نبي", 143);
    freq.put("عهد", 21);
    freq.put("حرو", 34);
    freq.put("نبه", 15);
    freq.put("حري", 111);
    freq.put("حرّ", 9);
    freq.put("ُا ", 11);
    freq.put("عهم", 40);
    freq.put("حرا", 71);
    freq.put("نبت", 23);
    freq.put("حرب", 43);
    freq.put("لگ ", 27);
    freq.put("ولك", 228);
    freq.put("حرس", 16);
    freq.put("حرص", 11);
    freq.put("نبغ", 13);
    freq.put("سقي", 10);
    freq.put("سقو", 19);
    freq.put("شش ", 23);
    freq.put(" كِ", 23);
    freq.put("ك؟ ", 21);
    freq.put("ﻬ", 34);
    freq.put("تـو", 15);
    freq.put("ممت", 16);
    freq.put("تــ", 63);
    freq.put("تـك", 12);
    freq.put("تـم", 10);
    freq.put("تـه", 14);
    freq.put("🈵?", 9);
    freq.put("كرت", 55);
    freq.put("لىَ", 41);
    freq.put("↓", 21);
    freq.put("بيص", 11);
    freq.put("بيط", 9);
    freq.put("بيض", 37);
    freq.put("بير", 158);
    freq.put("بيس", 32);
    freq.put("©", 42);
    freq.put("بيع", 88);
    freq.put("بيا", 64);
    freq.put("بيح", 34);
    freq.put("بيج", 20);
    freq.put("بيد", 31);
    freq.put("بية", 78);
    freq.put("بيب", 175);
    freq.put("بيث", 11);
    freq.put("بيت", 169);
    freq.put("ـآ", 100);
    freq.put("٠٠", 50);
    freq.put("بيّ", 36);
    freq.put("كها", 31);
    freq.put("بيل", 71);
    freq.put("بيه", 92);
    freq.put("بين", 464);
    freq.put("بيـ", 16);
    freq.put("بيك", 55);
    freq.put("بيق", 23);
    freq.put("كهر", 16);
    freq.put("بيَ", 22);
    freq.put("بيو", 30);
    freq.put("بيي", 11);
    freq.put("١٠ ", 9);
    freq.put("̵ ", 23);
    freq.put("رمت", 11);
    freq.put("يشع", 16);
    freq.put("اع ", 164);
    freq.put("يشر", 14);
    freq.put("مجه", 12);
    freq.put("يشب", 19);
    freq.put("يشت", 32);
    freq.put("هنآ", 11);
    freq.put("يشا", 22);
    freq.put("س، ", 11);
    freq.put("هنا", 153);
    freq.put("حف ", 12);
    freq.put("وأح", 41);
    freq.put("ملع", 9);
    freq.put("ءٍ ", 10);
    freq.put("هني", 36);
    freq.put("يشو", 26);
    freq.put("يشي", 28);
    freq.put("يشه", 17);
    freq.put("يشف", 13);
    freq.put("يشك", 13);
    freq.put("هنم", 17);
    freq.put("ﻨﺎ ", 9);
    freq.put("بصا", 13);
    freq.put("وحي", 137);
    freq.put("بصد", 11);
    freq.put("وحل", 18);
    freq.put("بصر", 39);
    freq.put("وزع", 13);
    freq.put("وﻻ", 19);
    freq.put("ﺫ", 12);
    freq.put("شغل", 43);
    freq.put("شغا", 15);
    freq.put("ُّ ", 11);
    freq.put("بصم", 12);
    freq.put("ِوى", 13);
    freq.put("سّ ", 21);
    freq.put("̵̵", 33);
    freq.put("بصو", 47);
    freq.put("٥٠", 12);
    freq.put("جسم", 22);
    freq.put(" ٢ ", 22);
    freq.put("جسا", 9);
    freq.put("قٍ ", 9);
    freq.put("جسد", 31);
    freq.put("زف ", 10);
    freq.put("ﺁ", 24);
    freq.put("مآن", 17);
    freq.put("مآه", 9);
    freq.put("َسُ", 9);
    freq.put("حكت", 20);
    freq.put("حكة", 10);
    freq.put("حكا", 48);
    freq.put("عم ", 182);
    freq.put(" ▄▄", 28);
    freq.put("سل ", 67);
    freq.put("حكي", 82);
    freq.put("حكى", 16);
    freq.put("حكو", 38);
    freq.put("حكم", 135);
    freq.put("اً ", 1268);
    freq.put("ّنا", 10);
    freq.put("ستم", 102);
    freq.put("مآت", 10);
    freq.put("سمك", 32);
    freq.put("وفن", 11);
    freq.put("مآع", 13);
    freq.put("لغف", 10);
    freq.put("إبن", 13);
    freq.put("إبل", 16);
    freq.put("سمَ", 9);
    freq.put("ئمي", 14);
    freq.put("〓〓〓", 14);
    freq.put("مغل", 10);
    freq.put("رئا", 10);
    freq.put("بٌ ", 16);
    freq.put("ئما", 64);
    freq.put("ئمة", 16);
    freq.put("ّ", 2963);
    freq.put("رئي", 45);
    freq.put(" 🌹", 72);
    freq.put("إبر", 16);
    freq.put("غة ", 27);
    freq.put("إبت", 47);
    freq.put("حم", 1188);
    freq.put("　", 14);
    freq.put("زبد", 13);
    freq.put("هـ ", 37);
    freq.put("زبا", 10);
    freq.put("ضاي", 56);
    freq.put("يى ", 13);
    freq.put("أشو", 20);
    freq.put("ضاً", 18);
    freq.put("فـا", 17);
    freq.put("جعل", 307);
    freq.put("لص ", 29);
    freq.put("جعن", 10);
    freq.put("جعه", 16);
    freq.put("لّ ", 46);
    freq.put("جعَ", 15);
    freq.put("فـر", 15);
    freq.put("جعو", 23);
    freq.put("حُ", 180);
    freq.put("جعي", 17);
    freq.put("فـي", 32);
    freq.put("فـو", 17);
    freq.put("ضاه", 11);
    freq.put("بنص", 15);
    freq.put("فــ", 49);
    freq.put("فـه", 9);
    freq.put("بنش", 9);
    freq.put("ضاق", 25);
    freq.put("وتر", 86);
    freq.put("ضاك", 12);
    freq.put("تفل", 20);
    freq.put("جعت", 17);
    freq.put("يز ", 106);
    freq.put("يِ ", 27);
    freq.put("ود ", 316);
    freq.put("دكَ", 10);
    freq.put("ﺔ", 25);
    freq.put("َسْ", 22);
    freq.put("نري", 23);
    freq.put("نتو", 39);
    freq.put("نرى", 14);
    freq.put("طمن", 13);
    freq.put("ٺي", 9);
    freq.put("اِل", 11);
    freq.put("اِن", 11);
    freq.put("أوا", 16);
    freq.put("د", 17868);
    freq.put("ﺟ", 26);
    freq.put("███", 30);
    freq.put("طمئ", 21);
    freq.put("نرج", 10);
    freq.put("وزي", 63);
    freq.put("نرا", 16);
    freq.put(" إد", 12);
    freq.put("ٺع", 15);
    freq.put("نرض", 9);
    freq.put("أور", 24);
    freq.put("أوز", 11);
    freq.put("أبـ", 12);
    freq.put("ربط", 13);
    freq.put("ربع", 58);
    freq.put("بة ", 343);
    freq.put("ربا", 62);
    freq.put("ربت", 26);
    freq.put("ربة", 19);
    freq.put("ﮧ", 18);
    freq.put("", 12);
    freq.put("رخي", 9);
    freq.put(" ثب", 18);
    freq.put("دًا", 37);
    freq.put("لک ", 13);
    freq.put("نهم", 195);
    freq.put("يح ", 156);
    freq.put("،وا", 14);
    freq.put("ربِ", 17);
    freq.put("ربّ", 31);
    freq.put("نهـ", 9);
    freq.put("ذى ", 16);
    freq.put("ربـ", 12);
    freq.put("ربن", 52);
    freq.put("ربه", 65);
    freq.put("ربم", 42);
    freq.put("ربي", 334);
    freq.put("ربو", 37);
    freq.put("ربَ", 10);
    freq.put("ِيه", 11);
    freq.put("ّاس", 11);
    freq.put("دّه", 10);
    freq.put("دّم", 9);
    freq.put("زت ", 15);
    freq.put("دّي", 11);
    freq.put("فق ", 59);
    freq.put("لوح", 63);
    freq.put("٠٠٠", 14);
    freq.put("لوت", 36);
    freq.put("لوة", 17);
    freq.put("لوب", 352);
    freq.put("لوا", 278);
    freq.put("لوآ", 9);
    freq.put("اجب", 36);
    freq.put("سْت", 22);
    freq.put("أظل", 13);
    freq.put("لوع", 30);
    freq.put("لوط", 44);
    freq.put("لوض", 27);
    freq.put("لوص", 25);
    freq.put("لوس", 45);
    freq.put("نهض", 10);
    freq.put("لور", 70);
    freq.put("سمآ", 12);
    freq.put("لوُ", 18);
    freq.put("١ ", 24);
    freq.put("لوي", 31);
    freq.put("لوو", 30);
    freq.put("لوه", 42);
    freq.put("لون", 256);
    freq.put("لوم", 170);
    freq.put("لول", 87);
    freq.put("لوك", 53);
    freq.put("لوق", 103);
    freq.put("لوف", 33);
    freq.put("د؟ ", 9);
    freq.put("وّر", 9);
    freq.put("اجت", 43);
    freq.put("مم ", 44);
    freq.put("وّد", 11);
    freq.put("دّث", 9);
    freq.put("وّا", 15);
    freq.put("بَا", 27);
    freq.put("ملأ", 13);
    freq.put("بَر", 12);
    freq.put("تيج", 24);
    freq.put("غاي", 19);
    freq.put("بَش", 10);
    freq.put("بَع", 13);
    freq.put("غال", 102);
    freq.put("غام", 15);
    freq.put("غان", 33);
    freq.put("ملا", 125);
    freq.put("فإن", 92);
    freq.put("😄 ", 12);
    freq.put("حُ ", 12);
    freq.put("نس ", 42);
    freq.put("فإذ", 13);
    freq.put("ـحـ", 31);
    freq.put("يهہ", 14);
    freq.put("َست", 14);
    freq.put("ملح", 12);
    freq.put("̩̩", 18);
    freq.put("بَل", 13);
    freq.put("بَه", 12);
    freq.put("غار", 45);
    freq.put("غاز", 9);
    freq.put("بَي", 14);
    freq.put("غاب", 27);
    freq.put("اوا", 33);
    freq.put("غاد", 19);
    freq.put("غاء", 10);
    freq.put("ضائ", 20);
    freq.put("غائ", 11);
    freq.put("اجد", 126);
    freq.put(" فآ", 11);
    freq.put(" فأ", 131);
    freq.put("يه،", 15);
    freq.put(" فإ", 108);
    freq.put(" فا", 361);
    freq.put(" فب", 22);
    freq.put(" فت", 163);
    freq.put("حذر", 30);
    freq.put(" فج", 39);
    freq.put(" فح", 16);
    freq.put(" فخ", 15);
    freq.put(" فد", 38);
    freq.put(" فذ", 12);
    freq.put("اوج", 15);
    freq.put(" فز", 9);
    freq.put(" فس", 35);
    freq.put(" فش", 23);
    freq.put(" فص", 16);
    freq.put(" فض", 52);
    freq.put(" فط", 24);
    freq.put("لظه", 14);
    freq.put(" فع", 87);
    freq.put("ثة ", 37);
    freq.put("يهت", 15);
    freq.put("اود", 22);
    freq.put("يهد", 27);
    freq.put("اوب", 11);
    freq.put("يهآ", 10);
    freq.put("رٌ", 31);
    freq.put("بني", 125);
    freq.put("اوت", 11);
    freq.put("يهز", 11);
    freq.put("تَغ", 24);
    freq.put("يهو", 14);
    freq.put("يهي", 9);
    freq.put("يهَ", 12);
    freq.put("َجْ", 10);
    freq.put("حز", 276);
    freq.put("يهم", 140);
    freq.put("يهن", 10);
    freq.put("يهه", 17);
    freq.put("يهِ", 9);
    freq.put(" فـ", 142);
    freq.put(" فف", 11);
    freq.put(" فق", 327);
    freq.put(" فك", 120);
    freq.put(" فل", 333);
    freq.put(" فم", 76);
    freq.put(" فن", 48);
    freq.put(" فه", 131);
    freq.put(" فو", 476);
    freq.put(" فى", 77);
    freq.put(" في", 2976);
    freq.put(" فَ", 209);
    freq.put(" فُ", 17);
    freq.put(" فِ", 142);
    freq.put("جـر", 14);
    freq.put("لظا", 33);
    freq.put("سعآ", 13);
    freq.put("هد ", 133);
    freq.put("قعد", 45);
    freq.put("ّء ", 10);
    freq.put("لَ ", 68);
    freq.put(" ٤ ", 15);
    freq.put(" ﭑ", 19);
    freq.put("مصا", 51);
    freq.put("دفه", 10);
    freq.put("نظر", 142);
    freq.put("لبو", 60);
    freq.put("اجئ", 9);
    freq.put(" ع ", 116);
    freq.put("قعي", 12);
    freq.put("قعو", 9);
    freq.put("قعه", 9);
    freq.put(" ثو", 34);
    freq.put("نفو", 38);
    freq.put(" ﯾ", 12);
    freq.put("مصط", 9);
    freq.put("دآ ", 23);
    freq.put("ةَ ", 36);
    freq.put("سن ", 170);
    freq.put("خسا", 17);
    freq.put("ذيك", 14);
    freq.put("خسر", 37);
    freq.put("ﺂﻟ", 9);
    freq.put("لذّ", 16);
    freq.put(" دم", 115);
    freq.put("لذِ", 18);
    freq.put("سح ", 25);
    freq.put("ذِك", 13);
    freq.put("بَ ", 118);
    freq.put("سبن", 11);
    freq.put("ذِي", 32);
    freq.put("سبه", 27);
    freq.put("↙", 12);
    freq.put("سبي", 87);
    freq.put("ـح ", 12);
    freq.put("نسم", 13);
    freq.put("ﺧ", 22);
    freq.put("نسه", 16);
    freq.put("نسو", 33);
    freq.put("حُز", 19);
    freq.put("نسي", 122);
    freq.put("نسَ", 14);
    freq.put("نسّ", 9);
    freq.put("حُب", 90);
    freq.put("نسآ", 13);
    freq.put("نسأ", 26);
    freq.put("نسا", 253);
    freq.put("نسب", 45);
    freq.put("نست", 51);
    freq.put("نسد", 10);
    freq.put("حُو", 12);
    freq.put("مله", 96);
    freq.put("ملل", 15);
    freq.put("رض", 472);
    freq.put("ملي", 150);
    freq.put("🔮?", 16);
    freq.put(" ف ", 142);
    freq.put("رتد", 15);
    freq.put("رتا", 45);
    freq.put("تِي", 35);
    freq.put("اول", 224);
    freq.put("يه ", 1257);
    freq.put("ئت ", 31);
    freq.put(" ﻣﻦ", 10);
    freq.put("اون", 24);
    freq.put("اوه", 13);
    freq.put("محم", 183);
    freq.put("اوق", 15);
    freq.put("لكُ", 14);
    freq.put("رئ", 73);
    freq.put("قن ", 11);
    freq.put("يبد", 37);
    freq.put("ظف ", 10);
    freq.put("لآس", 14);
    freq.put("رتو", 397);
    freq.put("لذا", 30);
    freq.put("رتي", 62);
    freq.put("رتَ", 10);
    freq.put("رتُ", 10);
    freq.put("رتـ", 16);
    freq.put("رتف", 17);
    freq.put("رتق", 9);
    freq.put("رتك", 42);
    freq.put("رتم", 9);
    freq.put("رتن", 21);
    freq.put("بًا", 17);
    freq.put("اوي", 117);
    freq.put(" عو", 61);
    freq.put(" عي", 365);
    freq.put(" عَ", 185);
    freq.put(" عُ", 21);
    freq.put(" عـ", 64);
    freq.put(" عف", 37);
    freq.put(" عق", 99);
    freq.put(" عك", 11);
    freq.put(" عل", 2567);
    freq.put(" عم", 404);
    freq.put(" عن", 1388);
    freq.put(" عه", 15);
    freq.put(" عِ", 46);
    freq.put("كنت", 203);
    freq.put("قع ", 110);
    freq.put("لَا", 24);
    freq.put("لِّ", 13);
    freq.put("ِـ ", 33);
    freq.put("كنا", 38);
    freq.put("لَم", 39);
    freq.put("لَه", 36);
    freq.put("ق", 14081);
    freq.put("رني", 114);
    freq.put("لَك", 23);
    freq.put("لَى", 37);
    freq.put("لَي", 28);
    freq.put("لَّ", 56);
    freq.put(" ﴿", 29);
    freq.put("سنہ", 9);
    freq.put(" عب", 245);
    freq.put(" عت", 27);
    freq.put(" عث", 10);
    freq.put(" عج", 80);
    freq.put("هدو", 37);
    freq.put(" عد", 178);
    freq.put("هدم", 9);
    freq.put(" عآ", 24);
    freq.put("هدف", 32);
    freq.put(" عا", 506);
    freq.put(" عظ", 51);
    freq.put(" عع", 12);
    freq.put("لكِ", 48);
    freq.put("مصل", 11);
    freq.put(" عذ", 52);
    freq.put(" عر", 149);
    freq.put(" عز", 89);
    freq.put(" عس", 66);
    freq.put(" عش", 218);
    freq.put(" عص", 41);
    freq.put(" عط", 77);
    freq.put("ضك ", 13);
    freq.put("لتج", 27);
    freq.put(" ﷺ", 50);
    freq.put("بث ", 20);
    freq.put("سحق", 9);
    freq.put(" ﷽", 28);
    freq.put("مفي", 17);
    freq.put("مفق", 17);
    freq.put("̯", 9);
    freq.put("نجو", 18);
    freq.put("راس", 91);
    freq.put("نجي", 19);
    freq.put("سنت", 22);
    freq.put("سنة", 59);
    freq.put("سنا", 67);
    freq.put("نجم", 18);
    freq.put("نجل", 23);
    freq.put("مفت", 36);
    freq.put("نجر", 19);
    freq.put("نما", 96);
    freq.put("مفا", 34);
    freq.put("سنّ", 9);
    freq.put("سني", 49);
    freq.put("سنو", 44);
    freq.put("سنن", 12);
    freq.put("سنه", 51);
    freq.put("محت", 81);
    freq.put("نجا", 60);
    freq.put("مفض", 17);
    freq.put("سحر", 11);
    freq.put("سحب", 32);
    freq.put("سحا", 19);
    freq.put("يزي", 82);
    freq.put("يزو", 13);
    freq.put("كأن", 56);
    freq.put("زب ", 72);
    freq.put("هـا", 21);
    freq.put("هـآ", 11);
    freq.put("لبِ", 17);
    freq.put("فـ ", 57);
    freq.put("لكس", 24);
    freq.put("لّا", 10);
    freq.put("لِّ", 12);
    freq.put("لّم", 24);
    freq.put("لّه", 41);
    freq.put("جع ", 129);
    freq.put("لّق", 15);
    freq.put("لَّ", 64);
    freq.put("لّي", 16);
    freq.put(" ︽", 9);
    freq.put("يزا", 43);
    freq.put("يزة", 17);
    freq.put("هـو", 10);
    freq.put("هـم", 25);
    freq.put("ﻻ", 150);
    freq.put("هــ", 52);
    freq.put("يزع", 13);
    freq.put(" ﻣ", 96);
    freq.put(" ﻧ", 23);
    freq.put(" ﻫ", 13);
    freq.put("ودت", 16);
    freq.put(" ﻭ", 61);
    freq.put("تأل", 42);
    freq.put(" ﻳ", 53);
    freq.put(" ﻷ", 13);
    freq.put("تأك", 37);
    freq.put(" ﻻ", 74);
    freq.put("ودع", 54);
    freq.put("😂?", 80);
    freq.put(" ﻋ", 47);
    freq.put("ث", 2710);
    freq.put(" ﻏ", 9);
    freq.put(" ﻓ", 49);
    freq.put(" ﻗ", 15);
    freq.put(" ﻛ", 17);
    freq.put("😂 ", 42);
    freq.put(" ﻟ", 63);
    freq.put(" ﺣ", 23);
    freq.put("طم ", 9);
    freq.put(" ﺧ", 13);
    freq.put("اِ ", 9);
    freq.put(" ﺭ", 17);
    freq.put(" ﺳ", 23);
    freq.put(" ﺷ", 13);
    freq.put(" ﺻ", 10);
    freq.put(" ﺂ", 66);
    freq.put(" ﺃ", 46);
    freq.put(" ﺁ", 11);
    freq.put(" ﺇ", 12);
    freq.put("آبك", 16);
    freq.put(" ﺎ", 172);
    freq.put("ودو", 21);
    freq.put(" ﺍ", 119);
    freq.put(" ﺑ", 58);
    freq.put(" ﺗ", 50);
    freq.put("ودّ", 9);
    freq.put("تأخ", 24);
    freq.put(" ﺟ", 12);
    freq.put("تأت", 23);
    freq.put("تأث", 12);
    freq.put("رب ", 636);
    freq.put("نتر", 15);
    freq.put("نمت", 10);
    freq.put("لهِ", 15);
    freq.put("كنو", 9);
    freq.put("،و ", 9);
    freq.put("كنه", 49);
    freq.put("رعة", 10);
    freq.put("رعب", 11);
    freq.put("١١", 11);
    freq.put("١٠", 27);
    freq.put("اعي", 119);
    freq.put("بّ ", 73);
    freq.put("هة ", 43);
    freq.put("ﻮ", 87);
    freq.put("رعا", 31);
    freq.put("ّا ", 67);
    freq.put("َغْ", 15);
    freq.put("فقا", 63);
    freq.put("فقة", 12);
    freq.put("فقت", 13);
    freq.put("فقد", 133);
    freq.put("لو?", 11);
    freq.put("فقر", 34);
    freq.put("فقط", 157);
    freq.put("مَ ", 205);
    freq.put("فقك", 37);
    freq.put("فقن", 26);
    freq.put("فقه", 26);
    freq.put("فقو", 28);
    freq.put("فقي", 38);
    freq.put("قى ", 215);
    freq.put("لِد", 9);
    freq.put("مكت", 32);
    freq.put("مة", 606);
    freq.put("صى ", 11);
    freq.put("٠٠ ", 27);
    freq.put("لهذ", 42);
    freq.put("مكة", 16);
    freq.put("دّ ", 40);
    freq.put("وّ ", 16);
    freq.put("가가", 11);
    freq.put("وإذ", 27);
    freq.put("وإر", 9);
    freq.put("ةٌ ", 18);
    freq.put("ِيم", 22);
    freq.put("ورو", 45);
    freq.put("ظما", 11);
    freq.put("ءات", 13);
    freq.put("ضع ", 62);
    freq.put("ِہ", 13);
    freq.put("سد ", 55);
    freq.put("ظمه", 9);
    freq.put("ءال", 28);
    freq.put(" صر", 77);
    freq.put("كدو", 13);
    freq.put("ان ", 2475);
    freq.put(" گل", 24);
    freq.put("ورم", 9);
    freq.put("وإل", 25);
    freq.put("وإن", 92);
    freq.put("ةال", 12);
    freq.put("وره", 126);
    freq.put("بدن", 10);
    freq.put("بده", 24);
    freq.put("بدل", 38);
    freq.put("بدك", 14);
    freq.put("بـ ", 166);
    freq.put("بدي", 60);
    freq.put("ررب", 9);
    freq.put("بدو", 121);
    freq.put("ررر", 70);
    freq.put("آس ", 35);
    freq.put("ِّ", 47);
    freq.put("يقة", 112);
    freq.put("كنك", 19);
    freq.put("ـد ", 52);
    freq.put("ِق", 92);
    freq.put("ِك", 139);
    freq.put("ِـ", 78);
    freq.put("ِف", 43);
    freq.put("ِن", 337);
    freq.put("ِه", 76);
    freq.put("ِل", 207);
    freq.put("ِم", 114);
    freq.put("ِي", 736);
    freq.put("ِو", 32);
    freq.put("خطو", 57);
    freq.put("طعت", 19);
    freq.put("خطي", 41);
    freq.put("ِز", 9);
    freq.put("ِس", 50);
    freq.put("ِذ", 20);
    freq.put("خطط", 13);
    freq.put("ِض", 17);
    freq.put("خطر", 11);
    freq.put("ِش", 25);
    freq.put("ِص", 15);
    freq.put("ِغ", 11);
    freq.put("ِع", 47);
    freq.put("ِأ", 15);
    freq.put("خطئ", 19);
    freq.put("خطا", 77);
    freq.put("ِئ", 13);
    freq.put("ِا", 40);
    freq.put("خطأ", 41);
    freq.put("ِت", 52);
    freq.put("ِث", 14);
    freq.put("ِب", 97);
    freq.put("خطب", 14);
    freq.put("ِد", 88);
    freq.put("ِج", 12);
    freq.put("ِح", 59);
    freq.put("بدا", 248);
    freq.put("رره", 16);
    freq.put("ڳ ", 13);
    freq.put("بدآ", 11);
    freq.put("بدأ", 67);
    freq.put("بدء", 10);
    freq.put("رري", 19);
    freq.put("بدر", 41);
    freq.put("بدع", 40);
    freq.put(" آم", 104);
    freq.put(" آل", 547);
    freq.put(" آه", 27);
    freq.put(" آن", 170);
    freq.put(" آف", 15);
    freq.put(" آك", 39);
    freq.put(" آق", 12);
    freq.put("┈", 12);
    freq.put(" ك ", 23);
    freq.put(" آو", 24);
    freq.put(" ﭑﻟ", 10);
    freq.put("شجر", 19);
    freq.put("ورأ", 9);
    freq.put("فلس", 32);
    freq.put("شجع", 18);
    freq.put("?لل", 9);
    freq.put("ئب ", 34);
    freq.put("فلا", 160);
    freq.put("يم ", 473);
    freq.put("شجا", 11);
    freq.put("ﻴﻦ", 9);
    freq.put("ورا", 158);
    freq.put("فلت", 16);
    freq.put("فلة", 21);
    freq.put("لغ ", 25);
    freq.put("لجب", 23);
    freq.put("جہ", 17);
    freq.put("نن ", 37);
    freq.put("ي", 54978);
    freq.put("فلن", 19);
    freq.put("فله", 25);
    freq.put("فلم", 26);
    freq.put("فلك", 12);
    freq.put("فلي", 39);
    freq.put(" ٦", 9);
    freq.put(" آا", 10);
    freq.put("دَة", 9);
    freq.put(" آآ", 11);
    freq.put(" آح", 85);
    freq.put(" آج", 36);
    freq.put(" آد", 22);
    freq.put(" آخ", 102);
    freq.put(" آب", 28);
    freq.put(" آث", 14);
    freq.put(" آت", 30);
    freq.put("ﻴﺮ", 12);
    freq.put(" آش", 32);
    freq.put(" آض", 9);
    freq.put(" آر", 29);
    freq.put(" آذ", 11);
    freq.put(" آس", 58);
    freq.put("ووا", 24);
    freq.put(" آع", 31);
    freq.put(" آغ", 9);
    freq.put("ـفـ", 13);
    freq.put("بل ", 393);
    freq.put("لبق", 40);
    freq.put("رصة", 15);
    freq.put("نـا", 67);
    freq.put("اءت", 9);
    freq.put("اءة", 25);
    freq.put("نـآ", 14);
    freq.put("اءا", 44);
    freq.put("لبـ", 17);
    freq.put("ْحَ", 29);
    freq.put("اءء", 11);
    freq.put("نـت", 16);
    freq.put("جئ", 19);
    freq.put("جا", 906);
    freq.put("ظك ", 25);
    freq.put("جآ", 40);
    freq.put("ءء ", 20);
    freq.put("طفى", 10);
    freq.put("جما", 115);
    freq.put("جد", 706);
    freq.put("جج", 27);
    freq.put("جح", 50);
    freq.put("جت", 168);
    freq.put("جب", 301);
    freq.put("جة", 130);
    freq.put("سّت", 19);
    freq.put("😭?", 13);
    freq.put("اء،", 9);
    freq.put("جز", 191);
    freq.put("جس", 86);
    freq.put("جذ", 25);
    freq.put("جر", 540);
    freq.put("جمع", 126);
    freq.put("ووج", 10);
    freq.put("سّا", 12);
    freq.put("نصو", 13);
    freq.put("جع", 587);
    freq.put("??", 28);
    freq.put("جه", 476);
    freq.put("جل", 565);
    freq.put("جم", 1032);
    freq.put("جمل", 191);
    freq.put("جك", 30);
    freq.put("جـ", 88);
    freq.put("جمه", 49);
    freq.put("جمو", 18);
    freq.put("جُ", 64);
    freq.put("جمي", 392);
    freq.put("جي", 648);
    freq.put("جمَ", 21);
    freq.put("جى", 9);
    freq.put("جمِ", 10);
    freq.put("جمّ", 12);
    freq.put("جْ", 20);
    freq.put("جِ", 41);
    freq.put("جّ", 31);
    freq.put("نصد", 10);
    freq.put("طفش", 12);
    freq.put("سّم", 14);
    freq.put("? ", 19);
    freq.put("اءْ", 12);
    freq.put("اءِ", 16);
    freq.put("اءَ", 15);
    freq.put("نـه", 13);
    freq.put("اءً", 12);
    freq.put("نــ", 89);
    freq.put("نـك", 13);
    freq.put("اءه", 13);
    freq.put("ﻟ ", 10);
    freq.put("اءك", 13);
    freq.put("نـي", 50);
    freq.put("رس ", 101);
    freq.put("بح ", 162);
    freq.put("لي،", 15);
    freq.put("لير", 16);
    freq.put("ﺣ", 60);
    freq.put("ليز", 32);
    freq.put("ليش", 70);
    freq.put("ليع", 9);
    freq.put("ﺃﻧ", 9);
    freq.put("ليأ", 13);
    freq.put("ليا", 140);
    freq.put("ليئ", 12);
    freq.put("لية", 80);
    freq.put("ليب", 44);
    freq.put("أغف", 11);
    freq.put("أغن", 22);
    freq.put("ليج", 53);
    freq.put("أغل", 37);
    freq.put("ليّ", 54);
    freq.put("ليْ", 10);
    freq.put("مت ", 224);
    freq.put("أغر", 13);
    freq.put("ُو ", 21);
    freq.put("ليف", 29);
    freq.put("ليـ", 27);
    freq.put("خر ", 204);
    freq.put("ليق", 48);
    freq.put("ليم", 110);
    freq.put("ليل", 274);
    freq.put("ليه", 656);
    freq.put("لين", 281);
    freq.put("ليو", 286);
    freq.put("˛", 11);
    freq.put("ليي", 30);
    freq.put("أغا", 9);
    freq.put("ليَ", 19);
    freq.put("صها", 9);
    freq.put("أفع", 20);
    freq.put("أفر", 18);
    freq.put("أفض", 60);
    freq.put("أفت", 16);
    freq.put("تظن", 11);
    freq.put("ضِي", 12);
    freq.put("نآم", 10);
    freq.put("فن ", 34);
    freq.put("س", 15657);
    freq.put("زها", 15);
    freq.put("ۈ", 125);
    freq.put("ﻣﻦ ", 10);
    freq.put("ليہ", 25);
    freq.put("دٌ ", 30);
    freq.put("وظف", 15);
    freq.put(" صف", 79);
    freq.put("تظا", 34);
    freq.put("أفك", 21);
    freq.put("أفق", 9);
    freq.put("أفل", 12);
    freq.put("بقد", 25);
    freq.put("بقة", 11);
    freq.put("بقت", 10);
    freq.put("بقا", 68);
    freq.put("آري", 19);
    freq.put("نق ", 20);
    freq.put("نمو", 26);
    freq.put("اا ", 277);
    freq.put("ضوع", 20);
    freq.put("ٓ ", 40);
    freq.put("بقر", 22);
    freq.put("ختك", 10);
    freq.put("ختف", 23);
    freq.put("ختن", 11);
    freq.put("ختم", 15);
    freq.put("ختل", 44);
    freq.put("ختي", 49);
    freq.put("ـرا", 22);
    freq.put("ـرت", 11);
    freq.put("ـرح", 14);
    freq.put("ختا", 28);
    freq.put("طه ", 52);
    freq.put("ختب", 192);
    freq.put("ـرف", 10);
    freq.put("ختر", 30);
    freq.put("ـرك", 9);
    freq.put("ختص", 20);
    freq.put("ـره", 13);
    freq.put("ـرو", 14);
    freq.put("آمَ", 13);
    freq.put("ـري", 24);
    freq.put("لجن", 235);
    freq.put("هوَ", 19);
    freq.put("بقى", 154);
    freq.put("بقو", 39);
    freq.put("بقي", 44);
    freq.put("بقل", 41);
    freq.put("لجل", 31);
    freq.put("آرب", 13);
    freq.put(" مج", 144);
    freq.put(" مح", 451);
    freq.put(" مخ", 105);
    freq.put(" مد", 243);
    freq.put(" مب", 160);
    freq.put(" مت", 528);
    freq.put(" مث", 178);
    freq.put(" مؤ", 95);
    freq.put(" ما", 2355);
    freq.put(" مآ", 118);
    freq.put(" مأ", 14);
    freq.put("يجم", 20);
    freq.put("يجه", 10);
    freq.put("رخ ", 10);
    freq.put(" مع", 949);
    freq.put(" مغ", 88);
    freq.put("هَم", 19);
    freq.put(" مش", 270);
    freq.put(" مص", 154);
    freq.put(" مض", 38);
    freq.put(" مط", 81);
    freq.put(" مذ", 22);
    freq.put(" مر", 449);
    freq.put(" مز", 66);
    freq.put(" مس", 488);
    freq.put("لشي", 155);
    freq.put("💜 ", 11);
    freq.put("لشو", 77);
    freq.put("يكر", 16);
    freq.put("يكس", 19);
    freq.put("لشك", 28);
    freq.put("لشق", 13);
    freq.put("لشف", 20);
    freq.put("لشه", 71);
    freq.put("ووف", 12);
    freq.put("لشم", 52);
    freq.put("يكا", 31);
    freq.put("ممك", 55);
    freq.put("لشّ", 15);
    freq.put("💜?", 18);
    freq.put("يكت", 51);
    freq.put("عها", 74);
    freq.put("لشب", 40);
    freq.put("يكِ", 13);
    freq.put("لشخ", 56);
    freq.put("لشج", 12);
    freq.put("لشا", 134);
    freq.put("يكل", 13);
    freq.put("صحح", 10);
    freq.put("يكن", 25);
    freq.put("يكف", 55);
    freq.put("يكك", 38);
    freq.put("يكَ", 18);
    freq.put("يكُ", 12);
    freq.put("يكو", 174);
    freq.put("يكي", 43);
    freq.put("سقط", 30);
    freq.put(" مَ", 337);
    freq.put(" مُ", 188);
    freq.put(" مو", 397);
    freq.put(" مي", 205);
    freq.put("يجز", 19);
    freq.put(" مل", 244);
    freq.put(" مم", 193);
    freq.put(" من", 3926);
    freq.put(" مه", 129);
    freq.put(" مـ", 107);
    freq.put(" مف", 91);
    freq.put(" مق", 158);
    freq.put("د ", 4940);
    freq.put("يجا", 26);
    freq.put("ِح ", 11);
    freq.put("هَا", 51);
    freq.put("نبل", 9);
    freq.put("يجد", 19);
    freq.put(" مِ", 195);
    freq.put(" مّ", 14);
    freq.put("يجت", 13);
    freq.put("가", 15);
    freq.put("رسا", 62);
    freq.put("رست", 18);
    freq.put("بحض", 11);
    freq.put("بحر", 102);
    freq.put("بحس", 19);
    freq.put("بحب", 27);
    freq.put("بحت", 39);
    freq.put("بحث", 47);
    freq.put("﴾ ", 25);
    freq.put("بحا", 187);
    freq.put("بحآ", 10);
    freq.put("ُوَ", 26);
    freq.put("ُول", 32);
    freq.put("ُوم", 12);
    freq.put("ُون", 80);
    freq.put("ُوه", 12);
    freq.put("لي ", 2105);
    freq.put("خرف", 10);
    freq.put("خره", 18);
    freq.put("خري", 96);
    freq.put("خرو", 36);
    freq.put("خرى", 34);
    freq.put("ُوج", 11);
    freq.put("ُوح", 10);
    freq.put("ُوب", 22);
    freq.put("ُوا", 47);
    freq.put("ة؟ ", 14);
    freq.put("خرا", 34);
    freq.put("خرت", 9);
    freq.put("خرب", 23);
    freq.put("خرة", 35);
    freq.put("ُور", 25);
    freq.put("خرج", 59);
    freq.put("رسه", 16);
    freq.put("رسن", 10);
    freq.put("رسم", 47);
    freq.put("رسل", 51);
    freq.put("رسي", 38);
    freq.put("رسى", 9);
    freq.put("رسو", 126);
    freq.put("بحَ", 13);
    freq.put("بحو", 32);
    freq.put("بحي", 30);
    freq.put("بحم", 55);
    freq.put("بحن", 44);
    freq.put("ﻬﺎ ", 9);
    freq.put("بحق", 14);
    freq.put("بحك", 11);
    freq.put("وظ ", 12);
    freq.put("زر ", 12);
    freq.put("نبد", 11);
    freq.put("ترك", 212);
    freq.put("فنج", 10);
    freq.put("فنا", 57);
    freq.put("نبا", 22);
    freq.put("فنى", 12);
    freq.put("فني", 122);
    freq.put("وشو", 9);
    freq.put("ضِ ", 10);
    freq.put("نبع", 9);
    freq.put("ااش", 10);
    freq.put(" ˘̩", 12);
    freq.put("اار", 33);
    freq.put("ااس", 28);
    freq.put("ْدُ", 9);
    freq.put("بق ", 48);
    freq.put("َِ", 9);
    freq.put("ااا", 528);
    freq.put("ااء", 25);
    freq.put("ااح", 40);
    freq.put("ااج", 20);
    freq.put("ااد", 23);
    freq.put("ااخ", 10);
    freq.put("نقد", 14);
    freq.put("ااب", 20);
    freq.put("اات", 43);
    freq.put("نبض", 46);
    freq.put("نطل", 19);
    freq.put("نوي", 34);
    freq.put("نطق", 53);
    freq.put("ـر ", 87);
    freq.put("نوم", 125);
    freq.put("طها", 12);
    freq.put("خت ", 19);
    freq.put("عُن", 9);
    freq.put("نطا", 13);
    freq.put("طهر", 16);
    freq.put("فة ", 245);
    freq.put("عُم", 17);
    freq.put("ااِ", 21);
    freq.put("آر ", 26);
    freq.put("مغر", 81);
    freq.put("اام", 32);
    freq.put("اال", 72);
    freq.put("ااه", 26);
    freq.put("اان", 69);
    freq.put("ااف", 15);
    freq.put("ااك", 22);
    freq.put("ااق", 26);
    freq.put("نقي", 27);
    freq.put("نقو", 33);
    freq.put("ٓم", 11);
    freq.put("ااي", 17);
    freq.put("دُ", 150);
    freq.put("دَ", 148);
    freq.put("دٍ", 25);
    freq.put("دٌ", 33);
    freq.put("دً", 39);
    freq.put("دي", 2179);
    freq.put("دى", 105);
    freq.put("دو", 984);
    freq.put("ده", 971);
    freq.put("دن", 475);
    freq.put("دم", 723);
    freq.put("دل", 347);
    freq.put("دك", 378);
    freq.put("دق", 338);
    freq.put("دف", 139);
    freq.put("ک ", 79);
    freq.put("دْ", 38);
    freq.put("دّ", 130);
    freq.put("دِ", 90);
    freq.put("كذل", 21);
    freq.put("يك ", 689);
    freq.put("كذب", 65);
    freq.put("د،", 26);
    freq.put("لش ", 16);
    freq.put("كذا", 91);
    freq.put("د؟", 10);
    freq.put("نهي", 21);
    freq.put("مما", 60);
    freq.put("دد", 261);
    freq.put("دخ", 184);
    freq.put("دح", 49);
    freq.put("دج", 15);
    freq.put("دث", 129);
    freq.put("دت", 287);
    freq.put("دة", 764);
    freq.put("دب", 118);
    freq.put("دا", 1707);
    freq.put("دئ", 20);
    freq.put("دأ", 81);
    freq.put("دآ", 95);
    freq.put("دء", 10);
    freq.put("لسط", 24);
    freq.put("هَ ", 139);
    freq.put("يج ", 66);
    freq.put("دع", 497);
    freq.put("دش", 18);
    freq.put("دس", 57);
    freq.put("دز", 12);
    freq.put("در", 1132);
    freq.put("تغي", 140);
    freq.put("تغن", 19);
    freq.put("تغل", 38);
    freq.put("مل ", 629);
    freq.put("تغف", 316);
    freq.put("أُح", 11);
    freq.put("ظم ", 32);
    freq.put("سدي", 25);
    freq.put("مضط", 12);
    freq.put("َاد", 31);
    freq.put("💧?", 10);
    freq.put("لْق", 9);
    freq.put("ضعف", 34);
    freq.put("ضعه", 9);
    freq.put("ضعي", 31);
    freq.put("تغا", 16);
    freq.put("ٰ", 39);
    freq.put("أُم", 12);
    freq.put("تغط", 10);
    freq.put("كعب", 10);
    freq.put("تغر", 168);
    freq.put("بـت", 14);
    freq.put("بـد", 12);
    freq.put("رر ", 53);
    freq.put("̉", 10);
    freq.put("بـا", 16);
    freq.put("آسر", 11);
    freq.put("آست", 16);
    freq.put("بـر", 10);
    freq.put("ﺔ ", 20);
    freq.put("══", 20);
    freq.put("ـدة", 10);
    freq.put("ـدا", 17);
    freq.put("َاع", 17);
    freq.put("طع ", 82);
    freq.put("ـدر", 20);
    freq.put("ـدي", 16);
    freq.put("ـده", 12);
    freq.put("ِ ", 816);
    freq.put("خط ", 30);
    freq.put("ماص", 9);
    freq.put("بـي", 24);
    freq.put("بـو", 10);
    freq.put("بد ", 133);
    freq.put("بـك", 11);
    freq.put("بــ", 55);
    freq.put("بـه", 17);
    freq.put("آسي", 11);
    freq.put("بـِ", 9);
    freq.put(" كت", 130);
    freq.put(" كث", 229);
    freq.put(" كب", 110);
    freq.put(" كد", 38);
    freq.put(" كح", 11);
    freq.put(" كآ", 25);
    freq.put(" كأ", 54);
    freq.put(" كا", 584);
    freq.put("يخف", 10);
    freq.put("لطر", 45);
    freq.put("يخه", 9);
    freq.put("يخن", 9);
    freq.put("يخل", 52);
    freq.put(" كس", 42);
    freq.put(" كذ", 92);
    freq.put(" كر", 108);
    freq.put(" كش", 18);
    freq.put("يمز", 9);
    freq.put("يمس", 20);
    freq.put("يمر", 19);
    freq.put("يمض", 9);
    freq.put("لغل", 31);
    freq.put("يمش", 19);
    freq.put("لغن", 29);
    freq.put("َبي", 17);
    freq.put("لغي", 114);
    freq.put("لغُ", 9);
    freq.put("يما", 121);
    freq.put("فل ", 93);
    freq.put("ثي", 277);
    freq.put("يمت", 28);
    freq.put("يمث", 12);
    freq.put("يمة", 67);
    freq.put("يمد", 17);
    freq.put("لغا", 71);
    freq.put("ئبي", 9);
    freq.put("لغة", 17);
    freq.put("لغب", 11);
    freq.put("لغد", 10);
    freq.put("لغر", 67);
    freq.put("يمك", 81);
    freq.put("عث ", 13);
    freq.put("يمن", 51);
    freq.put("يمه", 59);
    freq.put("يمل", 33);
    freq.put("يمي", 65);
    freq.put("نكك", 20);
    freq.put("يمو", 36);
    freq.put("يمَ", 16);
    freq.put("نوب", 70);
    freq.put(" كي", 251);
    freq.put(" كو", 79);
    freq.put("ل، ", 38);
    freq.put(" كَ", 94);
    freq.put(" كُ", 148);
    freq.put(" كك", 10);
    freq.put(" كـ", 57);
    freq.put(" كف", 82);
    freq.put(" كن", 287);
    freq.put(" كه", 9);
    freq.put(" كل", 1271);
    freq.put(" كم", 249);
    freq.put("يخا", 31);
    freq.put("إِن", 22);
    freq.put("يخت", 33);
    freq.put("إِل", 53);
    freq.put("يخب", 9);
    freq.put("نوا", 189);
    freq.put("وأس", 25);
    freq.put("وأر", 29);
    freq.put("وأط", 11);
    freq.put("وأش", 21);
    freq.put("وأص", 24);
    freq.put("حى ", 36);
    freq.put("وأع", 35);
    freq.put("وأت", 48);
    freq.put("وأب", 26);
    freq.put("وأخ", 18);
    freq.put("وأج", 23);
    freq.put("اء ", 1416);
    freq.put("جم ", 56);
    freq.put("ءءء", 52);
    freq.put("ج ", 628);
    freq.put("?ل", 9);
    freq.put("طف ", 26);
    freq.put("نص ", 44);
    freq.put("?ا", 10);
    freq.put("ـف ", 30);
    freq.put("َہ ", 29);
    freq.put("لسؤ", 13);
    freq.put("وأق", 13);
    freq.put("وأك", 12);
    freq.put("وأف", 13);
    freq.put("وأن", 192);
    freq.put("وأه", 16);
    freq.put("وأل", 10);
    freq.put("وأم", 40);
    freq.put("وأي", 13);
    freq.put("وأو", 16);
    freq.put("بنع", 16);
    freq.put("حل", 670);
    freq.put("حه", 234);
    freq.put("حن", 391);
    freq.put("حف", 178);
    freq.put("حـ", 184);
    freq.put("حك", 534);
    freq.put("حق", 531);
    freq.put("حٌ", 14);
    freq.put("بنس", 21);
    freq.put("حَ", 295);
    freq.put("حى", 38);
    freq.put("حو", 312);
    freq.put("حً", 11);
    freq.put("حي", 1543);
    freq.put("بنت", 122);
    freq.put("حّ", 35);
    freq.put("حِ", 123);
    freq.put("بند", 13);
    freq.put("حْ", 47);
    freq.put("بنآ", 9);
    freq.put("بنا", 319);
    freq.put("💚 ", 18);
    freq.put("ؤ", 582);
    freq.put("وقل", 64);
    freq.put("خخخ", 57);
    freq.put("فهو", 45);
    freq.put("ح،", 12);
    freq.put("ف، ", 9);
    freq.put("كز ", 29);
    freq.put("َاه", 10);
    freq.put("ْ ", 817);
    freq.put("هدى", 9);
    freq.put("ﺖ ", 28);
    freq.put("حا", 1213);
    freq.put("حآ", 54);
    freq.put("حح", 98);
    freq.put("حج", 107);
    freq.put("حد", 1176);
    freq.put("حة", 211);
    freq.put("حب", 1417);
    freq.put("حث", 54);
    freq.put("حت", 927);
    freq.put("حص", 110);
    freq.put("حش", 101);
    freq.put("حط", 106);
    freq.put("حض", 102);
    freq.put("حر", 609);
    freq.put("حذ", 53);
    freq.put("حس", 738);
    freq.put("بنَ", 10);
    freq.put("بنف", 38);
    freq.put("بنك", 13);
    freq.put("حظ", 195);
    freq.put("بنه", 18);
    freq.put("ب، ", 23);
    freq.put("حہ", 26);
    freq.put("هيّ", 9);
    freq.put("هيَ", 18);
    freq.put("هين", 23);
    freq.put("هيه", 14);
    freq.put("هيل", 16);
    freq.put("هيم", 35);
    freq.put("هيك", 11);
    freq.put("فحة", 22);
    freq.put("يبك", 44);
    freq.put("يبق", 70);
    freq.put("يبل", 14);
    freq.put("يبه", 81);
    freq.put("يبن", 18);
    freq.put("يبو", 41);
    freq.put("يبي", 164);
    freq.put("فحا", 14);
    freq.put("لذه", 25);
    freq.put("لذن", 28);
    freq.put("لذل", 24);
    freq.put("لذك", 43);
    freq.put("لل ", 55);
    freq.put("لذي", 312);
    freq.put("لذو", 10);
    freq.put("̷̷̷", 391);
    freq.put("يبا", 84);
    freq.put("̷ ", 89);
    freq.put("يبة", 61);
    freq.put("يبت", 83);
    freq.put("يبح", 19);
    freq.put("فحه", 15);
    freq.put("ﺍﻟﻤ", 11);
    freq.put("يبر", 20);
    freq.put("يبع", 17);
    freq.put("يبغ", 10);
    freq.put("لذة", 14);
    freq.put("هير", 50);
    freq.put("هيد", 29);
    freq.put("هيت", 11);
    freq.put("و🔙", 10);
    freq.put("هيب", 24);
    freq.put("هية", 11);
    freq.put("هيئ", 15);
    freq.put("هيا", 24);
    freq.put("سجي", 12);
    freq.put("خ ", 253);
    freq.put("كَم", 14);
    freq.put("رقم", 33);
    freq.put("رقن", 12);
    freq.put("رقه", 26);
    freq.put("رقو", 13);
    freq.put("رقى", 16);
    freq.put("رقي", 34);
    freq.put("روا", 196);
    freq.put("هلا", 143);
    freq.put("رقص", 14);
    freq.put("٣", 66);
    freq.put("روت", 12);
    freq.put("رقا", 43);
    freq.put("رقب", 13);
    freq.put("رقة", 40);
    freq.put("رقت", 20);
    freq.put("روب", 66);
    freq.put("هند", 32);
    freq.put("آما", 11);
    freq.put("بأن", 96);
    freq.put("رصا", 11);
    freq.put("بأم", 14);
    freq.put("بأي", 22);
    freq.put("رصت", 45);
    freq.put("شني", 10);
    freq.put("كثي", 202);
    freq.put("̷", 628);
    freq.put("ـس ", 11);
    freq.put("━━━", 17);
    freq.put("لطي", 92);
    freq.put("كثر", 353);
    freq.put("يضا", 46);
    freq.put("لطو", 41);
    freq.put("آمي", 33);
    freq.put("بأس", 20);
    freq.put("٥", 56);
    freq.put("آمن", 34);
    freq.put("آمل", 11);
    freq.put("بأخ", 10);
    freq.put("بأح", 15);
    freq.put("ـكـ", 24);
    freq.put("ننس", 14);
    freq.put("غي ", 29);
    freq.put("ننت", 15);
    freq.put(" ه ", 16);
    freq.put("ننا", 112);
    freq.put("سي ", 278);
    freq.put("جهت", 10);
    freq.put("مضى", 9);
    freq.put("مضي", 27);
    freq.put("جهة", 20);
    freq.put("جهد", 11);
    freq.put("حآل", 11);
    freq.put("حسّ", 10);
    freq.put("كّ ", 16);
    freq.put("جها", 79);
    freq.put("يف ", 374);
    freq.put("جهي", 12);
    freq.put("قه ", 257);
    freq.put("جهو", 15);
    freq.put("جهك", 40);
    freq.put("جهن", 19);
    freq.put("جهه", 28);
    freq.put("جهل", 23);
    freq.put("مضا", 56);
    freq.put("هرو", 17);
    freq.put("َّ ", 33);
    freq.put("رط ", 15);
    freq.put("ماد", 64);
    freq.put("يت?", 10);
    freq.put("مَه", 12);
    freq.put("اأح", 9);
    freq.put("ﻳ", 71);
    freq.put("هو ", 590);
    freq.put("نني", 70);
    freq.put("ننن", 23);
    freq.put("وقا", 82);
    freq.put("يت ", 1167);
    freq.put("ثك", 21);
    freq.put("ثق", 153);
    freq.put("ثـ", 14);
    freq.put("ثه", 26);
    freq.put("ثن", 121);
    freq.put("ثم", 209);
    freq.put("ثل", 323);
    freq.put("ﺈ", 9);
    freq.put("ثى", 60);
    freq.put("ثو", 127);
    freq.put("ثُ", 45);
    freq.put("ثَ", 33);
    freq.put("ثّ", 11);
    freq.put("ثِ", 26);
    freq.put("ثره", 14);
    freq.put("ثري", 9);
    freq.put("ثرو", 15);
    freq.put("وا ", 842);
    freq.put("َفس", 11);
    freq.put("ظه ", 40);
    freq.put("كشف", 27);
    freq.put("رضو", 12);
    freq.put("لنظ", 76);
    freq.put("ثا", 219);
    freq.put("رضي", 65);
    freq.put("ثث", 20);
    freq.put("ثت", 12);
    freq.put("ثة", 39);
    freq.put("ثب", 60);
    freq.put("ثر", 476);
    freq.put("ثرا", 9);
    freq.put("ثرت", 12);
    freq.put("ثرة", 26);
    freq.put("آه ", 29);
    freq.put("ّھ", 10);
    freq.put("إهت", 17);
    freq.put("̶̶", 33);
    freq.put("لنع", 38);
    freq.put("َين", 22);
    freq.put("َيل", 11);
    freq.put("لنص", 85);
    freq.put("لنش", 35);
    freq.put("َيُ", 12);
    freq.put("لند", 23);
    freq.put("لنس", 96);
    freq.put("لنح", 12);
    freq.put("َيْ", 43);
    freq.put("َيّ", 14);
    freq.put("لنب", 44);
    freq.put("لنت", 28);
    freq.put("لنا", 669);
    freq.put("لنآ", 31);
    freq.put("َيء", 14);
    freq.put("كة ", 120);
    freq.put("َيا", 29);
    freq.put("َيت", 9);
    freq.put("َيب", 13);
    freq.put("لنّ", 33);
    freq.put("لنِ", 20);
    freq.put("●", 18);
    freq.put("َ", 7805);
    freq.put("َير", 15);
    freq.put("لنَ", 17);
    freq.put("لنو", 148);
    freq.put("لني", 119);
    freq.put("ُل ", 102);
    freq.put("وش ", 215);
    freq.put("لنه", 72);
    freq.put("لنف", 111);
    freq.put("لنـ", 22);
    freq.put("خص ", 200);
    freq.put("لنق", 29);
    freq.put("ِش ", 9);
    freq.put("ّہ", 34);
    freq.put("أمه", 18);
    freq.put("أمن", 48);
    freq.put("ّس", 15);
    freq.put("أمل", 63);
    freq.put("أمك", 12);
    freq.put("ّض", 12);
    freq.put("ّع", 28);
    freq.put("أمَ", 13);
    freq.put("أمي", 91);
    freq.put("أمو", 61);
    freq.put("ّء", 10);
    freq.put("ّآ", 10);
    freq.put("تشو", 54);
    freq.put("ّا", 169);
    freq.put("تشي", 22);
    freq.put("ّة", 67);
    freq.put("© ", 41);
    freq.put("تشه", 15);
    freq.put("ّت", 80);
    freq.put("ّح", 22);
    freq.put("ّج", 11);
    freq.put("ّد", 68);
    freq.put("رضت", 10);
    freq.put("في ", 2613);
    freq.put("لو ", 732);
    freq.put("̷̷", 489);
    freq.put("̷̷ ", 64);
    freq.put("لنْ", 14);
    freq.put("عبد", 180);
    freq.put("أما", 85);
    freq.put("ِّ", 47);
    freq.put("تشع", 35);
    freq.put("تشغ", 20);
    freq.put("دو ", 54);
    freq.put("أمت", 22);
    freq.put("أمة", 15);
    freq.put("ّف", 17);
    freq.put("ّـ", 60);
    freq.put("ّك", 75);
    freq.put("أمش", 10);
    freq.put("أمس", 60);
    freq.put("تشب", 31);
    freq.put("أمر", 143);
    freq.put("تشت", 37);
    freq.put("ّى", 31);
    freq.put("ّو", 40);
    freq.put("تشا", 44);
    freq.put("ّي", 154);
    freq.put("ُّ", 33);
    freq.put("َّ", 181);
    freq.put("فتخ", 14);
    freq.put(" هز", 12);
    freq.put("غيت", 19);
    freq.put(" هذ", 486);
    freq.put(" هر", 28);
    freq.put("غيا", 99);
    freq.put("عــ", 60);
    freq.put("زرع", 20);
    freq.put("يتُ", 14);
    freq.put(" ها", 299);
    freq.put("هون", 40);
    freq.put(" هآ", 15);
    freq.put("يتي", 96);
    freq.put("مُك", 9);
    freq.put("يتو", 307);
    freq.put("يته", 144);
    freq.put(" هد", 82);
    freq.put(" هج", 22);
    freq.put(" هت", 21);
    freq.put("يتق", 19);
    freq.put(" هب", 17);
    freq.put("سكو", 23);
    freq.put("فدا", 15);
    freq.put("زنك", 12);
    freq.put("عـل", 16);
    freq.put("يفع", 24);
    freq.put("يفض", 9);
    freq.put("جه ", 167);
    freq.put("سكي", 26);
    freq.put("يفر", 25);
    freq.put("سكم", 17);
    freq.put("َّـ", 10);
    freq.put("يفت", 48);
    freq.put("َّه", 37);
    freq.put("يفة", 50);
    freq.put("زنه", 13);
    freq.put("▄▄ ", 27);
    freq.put("لضح", 24);
    freq.put("سكن", 60);
    freq.put(" ذم", 14);
    freq.put("مض ", 9);
    freq.put("لضا", 11);
    freq.put("فدي", 32);
    freq.put("يفَ", 9);
    freq.put("يفي", 65);
    freq.put("َّا", 11);
    freq.put("يفو", 46);

    init2();
  }
  private static void init2() {
    
    freq.put("زني", 15);
    freq.put("يفن", 56);
    freq.put("جآب", 9);
    freq.put("يفق", 15);
    freq.put("يفك", 80);
    freq.put("غيي", 24);
    freq.put(" هِ", 15);
    freq.put("غيو", 9);
    freq.put("ـك ", 104);
    freq.put("يتش", 9);
    freq.put("يتس", 14);
    freq.put(" ٰ", 12);
    freq.put("يتر", 108);
    freq.put("غيـ", 12);
    freq.put(" هن", 183);
    freq.put(" هه", 358);
    freq.put(" هل", 184);
    freq.put(" هم", 174);
    freq.put("زرق", 10);
    freq.put(" هك", 35);
    freq.put(" هـ", 46);
    freq.put("يتب", 25);
    freq.put(" هَ", 64);
    freq.put(" هُ", 83);
    freq.put("هود", 29);
    freq.put(" هي", 294);
    freq.put("هوة", 13);
    freq.put(" هو", 454);
    freq.put("واغ", 22);
    freq.put("واع", 89);
    freq.put("واض", 36);
    freq.put("واط", 62);
    freq.put("واش", 27);
    freq.put("واص", 66);
    freq.put("واز", 28);
    freq.put("واس", 111);
    freq.put("واذ", 44);
    freq.put("وار", 157);
    freq.put("واخ", 72);
    freq.put("واد", 62);
    freq.put("واج", 221);
    freq.put("واح", 291);
    freq.put("وات", 263);
    freq.put("واث", 12);
    freq.put("واب", 126);
    freq.put("وائ", 25);
    freq.put("واا", 31);
    freq.put("واء", 58);
    freq.put("ظها", 16);
    freq.put("مُن", 25);
    freq.put("💘?", 17);
    freq.put("ط", 4908);
    freq.put("ماأ", 14);
    freq.put("ظهر", 53);
    freq.put("يص ", 11);
    freq.put("⭕", 77);
    freq.put(" ﺍﻟ", 76);
    freq.put("ﻜ", 37);
    freq.put(" ه", 2939);
    freq.put("ث ", 380);
    freq.put("نصف", 33);
    freq.put(" ل", 9928);
    freq.put("عظي", 148);
    freq.put("ثر ", 349);
    freq.put("واي", 47);
    freq.put("واً", 12);
    freq.put("واو", 9);
    freq.put("وان", 540);
    freq.put("زنا", 17);
    freq.put("وال", 1702);
    freq.put("وام", 56);
    freq.put("واق", 124);
    freq.put("واك", 49);
    freq.put("عظم", 58);
    freq.put("ّر", 94);
    freq.put("رطة", 17);
    freq.put("ّذ", 14);
    freq.put("رطا", 11);
    freq.put("قَط", 11);
    freq.put("فتا", 77);
    freq.put("ُعا", 34);
    freq.put("زنة", 16);
    freq.put(" ْ", 13);
    freq.put("ُلِ", 17);
    freq.put("ُلّ", 13);
    freq.put("ئر ", 22);
    freq.put("أمـ", 14);
    freq.put("خصَ", 9);
    freq.put("خصي", 35);
    freq.put("خصو", 14);
    freq.put("ُب ", 57);
    freq.put("ُلم", 15);
    freq.put("تكف", 37);
    freq.put("َي ", 32);
    freq.put("خصص", 10);
    freq.put("َب ", 12);
    freq.put("خصا", 19);
    freq.put("مُو", 39);
    freq.put("آهل", 11);
    freq.put("تكو", 155);
    freq.put("آهي", 9);
    freq.put("ّة ", 51);
    freq.put("عز ", 31);
    freq.put("ُعَ", 9);
    freq.put("تكي", 21);
    freq.put("َد ", 38);
    freq.put("ُعل", 9);
    freq.put("خفو", 9);
    freq.put("أمّ", 12);
    freq.put("دوي", 14);
    freq.put("وخ ", 31);
    freq.put("دول", 78);
    freq.put("دوم", 44);
    freq.put("دون", 325);
    freq.put("دوه", 13);
    freq.put("دوك", 11);
    freq.put("ّ ", 1044);
    freq.put("ّب", 55);
    freq.put("تكذ", 9);
    freq.put("ّث", 13);
    freq.put("تكر", 42);
    freq.put("شخص", 247);
    freq.put("فيذ", 11);
    freq.put("تشف", 35);
    freq.put("تكس", 18);
    freq.put("فيش", 12);
    freq.put("فيص", 21);
    freq.put("فيض", 10);
    freq.put("فية", 54);
    freq.put("شخا", 41);
    freq.put("دمه", 28);
    freq.put("تشك", 20);
    freq.put("فيد", 70);
    freq.put("فيا", 44);
    freq.put("فيّ", 22);
    freq.put("فيْ", 10);
    freq.put("فيو", 9);
    freq.put("فيَ", 11);
    freq.put("فيـ", 16);
    freq.put("فيف", 27);
    freq.put("فيق", 101);
    freq.put("فيك", 144);
    freq.put("فيل", 28);
    freq.put("فيم", 29);
    freq.put("فين", 196);
    freq.put("فيه", 396);
    freq.put(" ز", 503);
    freq.put("دود", 52);
    freq.put("هذي", 77);
    freq.put("أم ", 74);
    freq.put("دوا", 133);
    freq.put("دوء", 32);
    freq.put("تكا", 19);
    freq.put("تش ", 19);
    freq.put("دوس", 24);
    freq.put(" ش", 2422);
    freq.put("رجع", 114);
    freq.put("▄▄", 43);
    freq.put(" ص", 1940);
    freq.put("ِدَ", 10);
    freq.put("رجت", 10);
    freq.put("رجة", 29);
    freq.put("بن ", 247);
    freq.put(" ظ", 157);
    freq.put(" ع", 7225);
    freq.put("للھ", 18);
    freq.put("زو", 223);
    freq.put("طئ ", 18);
    freq.put("ْل", 48);
    freq.put("ْم", 45);
    freq.put("ْن", 39);
    freq.put("ْه", 29);
    freq.put("ْـ", 22);
    freq.put("ْف", 40);
    freq.put("ْق", 20);
    freq.put("ْك", 23);
    freq.put("ι", 17);
    freq.put("ْو", 15);
    freq.put("ْي", 20);
    freq.put("ْض", 13);
    freq.put("ْر", 47);
    freq.put("ْس", 29);
    freq.put("◾〰", 30);
    freq.put("ْع", 31);
    freq.put("ْا", 20);
    freq.put("ْح", 40);
    freq.put("للہ", 90);
    freq.put("ْد", 36);
    freq.put("ْب", 28);
    freq.put("ْت", 57);
    freq.put("ح ", 1722);
    freq.put("ك، ", 60);
    freq.put("رجي", 29);
    freq.put("〰🔲", 12);
    freq.put("رجه", 19);
    freq.put("رجل", 138);
    freq.put("رجم", 13);
    freq.put("صمي", 12);
    freq.put("صمم", 9);
    freq.put("للغ", 15);
    freq.put("ىٰ ", 9);
    freq.put("للس", 29);
    freq.put("للر", 25);
    freq.put("للذ", 13);
    freq.put("للط", 18);
    freq.put("للص", 19);
    freq.put("للش", 22);
    freq.put("للت", 110);
    freq.put("للب", 47);
    freq.put("للد", 15);
    freq.put("للخ", 19);
    freq.put("للح", 98);
    freq.put("للج", 94);
    freq.put("للأ", 62);
    freq.put("للا", 104);
    freq.put("ه؟ ", 26);
    freq.put("للإ", 23);
    freq.put("يب ", 515);
    freq.put("خِل", 24);
    freq.put("للّ", 105);
    freq.put("دام", 130);
    freq.put("للى", 20);
    freq.put("للو", 42);
    freq.put("للَ", 36);
    freq.put(" ؛", 198);
    freq.put("للك", 26);
    freq.put("للق", 58);
    freq.put("للف", 26);
    freq.put("للـ", 40);
    freq.put("لله", 3166);
    freq.put("للن", 45);
    freq.put("للم", 170);
    freq.put("للل", 31);
    freq.put("صمت", 98);
    freq.put("سكر", 60);
    freq.put("سكس", 16);
    freq.put("هي ", 371);
    freq.put("وغا", 14);
    freq.put("🌺 ", 10);
    freq.put("أكر", 29);
    freq.put("تضي", 29);
    freq.put("أكد", 34);
    freq.put("وغر", 11);
    freq.put("أكب", 56);
    freq.put("أكث", 158);
    freq.put("أكت", 35);
    freq.put("هوي", 21);
    freq.put("تضم", 13);
    freq.put("خب", 221);
    freq.put("خة", 11);
    freq.put("خت", 459);
    freq.put("خج", 21);
    freq.put("خخ", 90);
    freq.put("خد", 125);
    freq.put("سأل", 218);
    freq.put("خآ", 30);
    freq.put("خا", 583);
    freq.put("خذ", 213);
    freq.put("خر", 602);
    freq.put("خز", 13);
    freq.put("خس", 70);
    freq.put("خش", 63);
    freq.put("خص", 323);
    freq.put("خض", 16);
    freq.put("برح", 20);
    freq.put("خو", 326);
    freq.put("خي", 808);
    freq.put("خَ", 93);
    freq.put("خُ", 36);
    freq.put("خـ", 71);
    freq.put("خف", 103);
    freq.put("خل", 976);
    freq.put("خم", 64);
    freq.put("خن", 53);
    freq.put("خه", 25);
    freq.put("رق ", 178);
    freq.put("خِ", 43);
    freq.put("خّ", 9);
    freq.put("خْ", 18);
    freq.put("عہ ", 20);
    freq.put("تضع", 11);
    freq.put("تضر", 27);
    freq.put("كبه", 9);
    freq.put("وغي", 24);
    freq.put("سْ ", 12);
    freq.put("أكو", 23);
    freq.put("تضح", 34);
    freq.put("أكي", 14);
    freq.put("أكم", 11);
    freq.put("أكل", 29);
    freq.put("تضا", 40);
    freq.put("بلس", 17);
    freq.put("تشر", 38);
    freq.put("آم ", 38);
    freq.put("بلغ", 56);
    freq.put("بلع", 10);
    freq.put("بلا", 127);
    freq.put("رص ", 16);
    freq.put("ﺐ ", 14);
    freq.put("بلآ", 10);
    freq.put("بلد", 38);
    freq.put("بلت", 12);
    freq.put("بلة", 23);
    freq.put("تهد", 37);
    freq.put("خبي", 23);
    freq.put("ّق", 31);
    freq.put("ّم", 104);
    freq.put("ّل", 88);
    freq.put("خبا", 47);
    freq.put("ّه", 185);
    freq.put("ّن", 67);
    freq.put("مسا", 196);
    freq.put("خبط", 11);
    freq.put("لٌ ", 21);
    freq.put("خبر", 88);
    freq.put("ﮪﮪ", 16);
    freq.put("ـسـ", 30);
    freq.put("تها", 303);
    freq.put("١", 106);
    freq.put("بله", 36);
    freq.put("منذ", 28);
    freq.put("بلك", 17);
    freq.put("بلق", 12);
    freq.put("بلي", 55);
    freq.put("بلو", 29);
    freq.put("لقة", 18);
    freq.put("لقب", 67);
    freq.put("فو ", 76);
    freq.put("لقت", 32);
    freq.put("ہَ ", 71);
    freq.put("لقد", 90);
    freq.put("منش", 20);
    freq.put("لقا", 201);
    freq.put("هز ", 9);
    freq.put("تهر", 12);
    freq.put("لقر", 116);
    freq.put("غيث", 13);
    freq.put("لقص", 102);
    freq.put("لقط", 26);
    freq.put("فيس", 24);
    freq.put("لدي", 167);
    freq.put("ُن ", 55);
    freq.put("🔮", 20);
    freq.put("لدُ", 29);
    freq.put("كوا", 33);
    freq.put(" ﻓﻲ", 11);
    freq.put("لدك", 19);
    freq.put("كوت", 16);
    freq.put("غيب", 80);
    freq.put("لدن", 176);
    freq.put("لده", 32);
    freq.put("لدل", 13);
    freq.put("لدم", 48);
    freq.put("كور", 43);
    freq.put("لدّ", 10);
    freq.put("نغر", 10);
    freq.put("لدت", 18);
    freq.put("لدب", 11);
    freq.put("كوك", 10);
    freq.put("لدخ", 13);
    freq.put("كوم", 29);
    freq.put("كون", 447);
    freq.put("كوو", 10);
    freq.put("كوي", 76);
    freq.put("لدا", 61);
    freq.put("غيآ", 10);
    freq.put("لدع", 57);
    freq.put("لدس", 11);
    freq.put("لدر", 72);
    freq.put("لقى", 38);
    freq.put("هول", 24);
    freq.put("لقي", 163);
    freq.put("لقُ", 26);
    freq.put("زرا", 10);
    freq.put("لقـ", 11);
    freq.put("لقك", 27);
    freq.put("لقم", 37);
    freq.put("إكت", 9);
    freq.put("لقه", 59);
    freq.put("لقن", 50);
    freq.put("دي ", 596);
    freq.put("گل ", 13);
    freq.put("لقِ", 9);
    freq.put("قبو", 40);
    freq.put("قبي", 20);
    freq.put("ﺄ", 21);
    freq.put("قبل", 311);
    freq.put("قبه", 15);
    freq.put("يتن", 50);
    freq.put("يتم", 54);
    freq.put("يتك", 136);
    freq.put("تذك", 109);
    freq.put("هوى", 27);
    freq.put("غير", 527);
    freq.put("ذوق", 41);
    freq.put("يتـ", 14);
    freq.put("لْح", 13);
    freq.put("تذا", 31);
    freq.put("مش ", 77);
    freq.put("أزم", 10);
    freq.put("تذر", 29);
    freq.put("ّــ", 15);
    freq.put("قيل", 40);
    freq.put("صتك", 45);
    freq.put("قبة", 13);
    freq.put("🌟 ", 9);
    freq.put("منى", 81);
    freq.put("اح ", 441);
    freq.put("ـم ", 90);
    freq.put("تّ ", 44);
    freq.put("َبب", 9);
    freq.put("لضم", 12);
    freq.put("قبر", 54);
    freq.put("🅾 ", 10);
    freq.put("وذل", 9);
    freq.put("منَ", 28);
    freq.put("ك،", 75);
    freq.put("بغى", 21);
    freq.put("بغي", 70);
    freq.put("ك؟", 31);
    freq.put("٨ ", 11);
    freq.put("منق", 10);
    freq.put("كث", 589);
    freq.put("كت", 688);
    freq.put("كة", 127);
    freq.put("كب", 363);
    freq.put("كد", 113);
    freq.put("كح", 21);
    freq.put("كأ", 85);
    freq.put("كآ", 47);
    freq.put("كا", 1219);
    freq.put("كع", 31);
    freq.put("كس", 233);
    freq.put("كز", 46);
    freq.put("كر", 1288);
    freq.put("كذ", 189);
    freq.put("كض", 16);
    freq.put("كش", 55);
    freq.put("كي", 962);
    freq.put("كى", 44);
    freq.put("كو", 754);
    freq.put("كُ", 248);
    freq.put("كَ", 413);
    freq.put("كك", 310);
    freq.put("كف", 228);
    freq.put("كـ", 176);
    freq.put("كه", 132);
    freq.put("كن", 965);
    freq.put("كم", 1172);
    freq.put("كل", 2123);
    freq.put("يفا", 79);
    freq.put("كْ", 38);
    freq.put("كّ", 34);
    freq.put("كِ", 244);
    freq.put("كض ", 13);
    freq.put("نا،", 23);
    freq.put("ـعـ", 31);
    freq.put("بغد", 14);
    freq.put("آعر", 12);
    freq.put("حِب", 26);
    freq.put("؟؟", 115);
    freq.put("لـ ", 111);
    freq.put("غلط", 48);
    freq.put("رِ ", 20);
    freq.put("غلب", 35);
    freq.put("غلا", 58);
    freq.put("فرص", 69);
    freq.put("˘̩", 21);
    freq.put("يؤم", 10);
    freq.put("يؤل", 11);
    freq.put("ڪ", 19);
    freq.put("يؤك", 9);
    freq.put("فرا", 203);
    freq.put("فرح", 140);
    freq.put("فرج", 49);
    freq.put("فرد", 30);
    freq.put("فرة", 21);
    freq.put("فرت", 29);
    freq.put("لح ", 76);
    freq.put("َو ", 9);
    freq.put("ف ", 2212);
    freq.put("؟؟؟", 37);
    freq.put("ﺏ ", 9);
    freq.put("وى ", 177);
    freq.put("فره", 18);
    freq.put("فرن", 21);
    freq.put("ت؟ ", 12);
    freq.put("فرك", 18);
    freq.put("فرق", 76);
    freq.put("فرَ", 12);
    freq.put("يؤذ", 9);
    freq.put("مية", 68);
    freq.put("ظة ", 39);
    freq.put("ل ", 8389);
    freq.put("هّ ", 23);
    freq.put("ل?", 10);
    freq.put("غلى", 26);
    freq.put("غلي", 18);
    freq.put("صف ", 81);
    freq.put("تكت", 49);
    freq.put("غلق", 18);
    freq.put("مآل", 14);
    freq.put("ناط", 10);
    freq.put("آكت", 11);
    freq.put("آكث", 9);
    freq.put("دش ", 12);
    freq.put("َتى", 9);
    freq.put("بإن", 11);
    freq.put("يفه", 80);
    freq.put(" بہ", 14);
    freq.put("قّ ", 20);
    freq.put("ب", 27496);
    freq.put("كحل", 11);
    freq.put("ّق ", 19);
    freq.put("ميع", 210);
    freq.put("تز ", 15);
    freq.put("كلب", 33);
    freq.put("︽ ", 9);
    freq.put("سا ", 26);
    freq.put("يتغ", 20);
    freq.put("ناا", 107);
    freq.put("بإذ", 28);
    freq.put("يتع", 37);
    freq.put("قت ", 240);
    freq.put("أه ", 29);
    freq.put("م، ", 65);
    freq.put("مير", 87);
    freq.put("  ", 19);
    freq.put("فَا", 24);
    freq.put("شتا", 96);
    freq.put("فَأ", 9);
    freq.put("شتب", 11);
    freq.put(" بِ", 284);
    freq.put("🔝〰", 14);
    freq.put("فَت", 11);
    freq.put("دلو", 22);
    freq.put(" بي", 613);
    freq.put("دلي", 36);
    freq.put("→", 13);
    freq.put(" بُ", 23);
    freq.put(" بَ", 134);
    freq.put(" بك", 374);
    freq.put(" بق", 208);
    freq.put(" بف", 44);
    freq.put(" بـ", 231);
    freq.put("دلل", 123);
    freq.put(" بن", 391);
    freq.put(" بم", 257);
    freq.put(" بل", 297);
    freq.put("يتخ", 14);
    freq.put("يتح", 49);
    freq.put("لجر", 46);
    freq.put("يتج", 20);
    freq.put("ﺍﻟ", 83);
    freq.put("زمي", 11);
    freq.put("يتا", 44);
    freq.put("ﻘ", 32);
    freq.put("فَل", 15);
    freq.put(" بغ", 77);
    freq.put(" بع", 763);
    freq.put("شتق", 32);
    freq.put("فَـ", 11);
    freq.put("شته", 37);
    freq.put(" بس", 501);
    freq.put(" بز", 19);
    freq.put(" بر", 273);
    freq.put(" بذ", 62);
    freq.put(" بط", 85);
    freq.put(" بض", 19);
    freq.put(" بص", 119);
    freq.put(" بش", 150);
    freq.put(" بث", 17);
    freq.put(" بت", 197);
    freq.put(" بب", 41);
    freq.put(" بد", 287);
    freq.put(" بخ", 112);
    freq.put(" بح", 205);
    freq.put(" بج", 79);
    freq.put(" بأ", 227);
    freq.put(" بآ", 41);
    freq.put(" با", 1591);
    freq.put(" بإ", 86);
    freq.put("دلا", 23);
    freq.put("نيي", 13);
    freq.put("ادَ", 19);
    freq.put("ادى", 11);
    freq.put("ادو", 37);
    freq.put("ادي", 267);
    freq.put("ادم", 63);
    freq.put("ادل", 37);
    freq.put("اده", 118);
    freq.put("ادن", 12);
    freq.put("نيه", 91);
    freq.put("نين", 229);
    freq.put("ادك", 26);
    freq.put("ادق", 47);
    freq.put("نال", 45);
    freq.put("تُق", 9);
    freq.put("تُك", 27);
    freq.put("تُم", 13);
    freq.put("تُن", 11);
    freq.put("تُه", 22);
    freq.put("تُو", 15);
    freq.put("نيْ", 9);
    freq.put("نيّ", 76);
    freq.put("ادِ", 15);
    freq.put("ههه", 4617);
    freq.put("ميّ", 16);
    freq.put("فس ", 121);
    freq.put("لمْ", 31);
    freq.put("مزي", 34);
    freq.put("ني،", 26);
    freq.put("يئ ", 11);
    freq.put("يقه", 118);
    freq.put("ﺑ ", 14);
    freq.put("مزا", 27);
    freq.put("ني؟", 11);
    freq.put("مزح", 14);
    freq.put("تہ ", 37);
    freq.put("تُر", 15);
    freq.put(" ً ", 23);
    freq.put("ادخ", 16);
    freq.put("ادة", 343);
    freq.put("تُص", 9);
    freq.put("ادث", 32);
    freq.put("ادت", 77);
    freq.put("تُع", 22);
    freq.put("تُغ", 10);
    freq.put("ادئ", 11);
    freq.put("يقن", 21);
    freq.put("نيئ", 16);
    freq.put("ـها", 9);
    freq.put("ادع", 50);
    freq.put("تُب", 19);
    freq.put("نير", 12);
    freq.put("ادر", 116);
    freq.put("تُح", 26);
    freq.put("تُخ", 9);
    freq.put("لمَ", 59);
    freq.put("اقي", 146);
    freq.put("نيہ", 19);
    freq.put("د، ", 20);
    freq.put("يقل", 28);
    freq.put("مك ", 280);
    freq.put("ﺮ", 82);
    freq.put("يطر", 15);
    freq.put("لمه", 142);
    freq.put("ءة ", 26);
    freq.put("مد ", 357);
    freq.put("نع ", 70);
    freq.put("٩", 41);
    freq.put("هها", 18);
    freq.put("〰◾〰", 30);
    freq.put("ﻊ ", 10);
    freq.put("قته", 45);
    freq.put("أهو", 9);
    freq.put("يقف", 12);
    freq.put("قتل", 102);
    freq.put("قتك", 41);
    freq.put("قتُ", 13);
    freq.put("أهم", 30);
    freq.put("أهل", 118);
    freq.put("ﺗ", 74);
    freq.put("كآن", 26);
    freq.put("يقـ", 14);
    freq.put("تزم", 32);
    freq.put("ثك ", 11);
    freq.put("تزي", 21);
    freq.put("تزو", 29);
    freq.put("ساو", 24);
    freq.put("ساً", 13);
    freq.put("ساي", 10);
    freq.put("ساف", 38);
    freq.put("ساك", 57);
    freq.put("ساق", 13);
    freq.put("سام", 170);
    freq.put("سال", 139);
    freq.put("ساه", 61);
    freq.put("سان", 242);
    freq.put("تزا", 44);
    freq.put("كلم", 361);
    freq.put("سار", 43);
    freq.put("?ال", 10);
    freq.put("ساس", 75);
    freq.put("أذك", 37);
    freq.put("ـﺎ", 9);
    freq.put("أذن", 24);
    freq.put("ساب", 162);
    freq.put("سات", 33);
    freq.put("ساح", 19);
    freq.put("ساج", 17);
    freq.put("ساد", 28);
    freq.put("ساخ", 10);
    freq.put("ساء", 134);
    freq.put("يقَ", 13);
    freq.put("تزع", 18);
    freq.put("سائ", 50);
    freq.put("قتا", 12);
    freq.put("أهد", 19);
    freq.put("كلك", 26);
    freq.put("غيّ", 15);
    freq.put("أها", 12);
    freq.put(" ", 22);
    freq.put("شت ", 14);
    freq.put("فَ ", 132);
    freq.put("ہٌ ", 9);
    freq.put("كلي", 45);
    freq.put("خجل", 18);
    freq.put("كلّ", 19);
    freq.put("عت ", 135);
    freq.put("وفت", 18);
    freq.put("يقي", 88);
    freq.put("يين", 125);
    freq.put("ﻴﺮ ", 9);
    freq.put("ﺎﻟ", 18);
    freq.put("دل ", 69);
    freq.put(" ب ", 124);
    freq.put("قَد", 30);
    freq.put("يقو", 269);
    freq.put("وفا", 71);
    freq.put("غنا", 24);
    freq.put("يئً", 10);
    freq.put("يئه", 20);
    freq.put("لزو", 46);
    freq.put("لزي", 157);
    freq.put("فسا", 13);
    freq.put("جك ", 19);
    freq.put("فست", 11);
    freq.put("ضت ", 21);
    freq.put("فسد", 11);
    freq.put("لزل", 22);
    freq.put("لزه", 17);
    freq.put("لزع", 13);
    freq.put("يئة", 36);
    freq.put("يئا", 90);
    freq.put("فسك", 127);
    freq.put("لزب", 18);
    freq.put("ْ", 1553);
    freq.put("فسه", 97);
    freq.put("فسن", 14);
    freq.put("وفر", 23);
    freq.put("فسي", 141);
    freq.put("تتم", 36);
    freq.put("لزا", 12);
    freq.put("ندا", 22);
    freq.put("وجَ", 18);
    freq.put("ني ", 2680);
    freq.put("اد ", 451);
    freq.put("تُ ", 114);
    freq.put("غني", 79);
    freq.put("ـه ", 164);
    freq.put("وجو", 79);
    freq.put("لمص", 63);
    freq.put("⭕ ", 28);
    freq.put("مدك", 9);
    freq.put("مدف", 9);
    freq.put("مده", 55);
    freq.put("تتع", 32);
    freq.put("مدل", 119);
    freq.put("مدي", 99);
    freq.put("مدى", 19);
    freq.put("مدو", 11);
    freq.put("مدُ", 13);
    freq.put("وفق", 85);
    freq.put("مدا", 80);
    freq.put("ماج", 34);
    freq.put("مدة", 39);
    freq.put("مدد", 9);
    freq.put("مدح", 18);
    freq.put("مدر", 170);
    freq.put("لأح", 110);
    freq.put("تتر", 35);
    freq.put("واه", 89);
    freq.put("واف", 70);
    freq.put("قَا", 24);
    freq.put("ہَا", 9);
    freq.put("فوا", 75);
    freq.put("ديّ", 12);
    freq.put("فوت", 15);
    freq.put("لق ", 168);
    freq.put("تتب", 11);
    freq.put("ﻴﻦ ", 9);
    freq.put("دين", 451);
    freq.put("تتا", 18);
    freq.put("ديل", 42);
    freq.put("ديم", 63);
    freq.put("ديق", 111);
    freq.put("ديك", 68);
    freq.put("ديـ", 14);
    freq.put("ديف", 44);
    freq.put("ديي", 17);
    freq.put("ديو", 56);
    freq.put("كو ", 24);
    freq.put("هبل", 13);
    freq.put("ُنا", 56);
    freq.put("شبع", 21);
    freq.put("ُنت", 22);
    freq.put("ُنس", 9);
    freq.put("شبا", 77);
    freq.put("لأغ", 11);
    freq.put("ُني", 25);
    freq.put("ُنو", 14);
    freq.put("ُنَ", 12);
    freq.put("ُنْ", 9);
    freq.put("شبي", 22);
    freq.put("٧ ", 13);
    freq.put("شبه", 44);
    freq.put("شبك", 13);
    freq.put("فوق", 87);
    freq.put("ُعد", 10);
    freq.put("فوف", 14);
    freq.put("فون", 104);
    freq.put("فوه", 12);
    freq.put("فول", 398);
    freq.put(" ظا", 9);
    freq.put("فوي", 11);
    freq.put("ﻫ", 35);
    freq.put("ديا", 31);
    freq.put("ديد", 153);
    freq.put("ديت", 64);
    freq.put("ديث", 85);
    freq.put("دية", 133);
    freq.put("ﺀ", 11);
    freq.put("احو", 29);
    freq.put("احَ", 19);
    freq.put("احك", 60);
    freq.put("احق", 12);
    freq.put("احف", 32);
    freq.put("احـ", 20);
    freq.put("احه", 66);
    freq.put("احن", 42);
    freq.put("احم", 55);
    freq.put("احل", 101);
    freq.put("فهي", 19);
    freq.put("احْ", 9);
    freq.put("احِ", 21);
    freq.put("َذا", 12);
    freq.put("جفا", 22);
    freq.put("مشق", 28);
    freq.put("مشك", 64);
    freq.put("مشه", 12);
    freq.put("مشي", 68);
    freq.put("مشو", 9);
    freq.put("صت ", 17);
    freq.put("?", 1254);
    freq.put("مشر", 33);
    freq.put("مشا", 130);
    freq.put("مشت", 35);
    freq.put("فا ", 53);
    freq.put("َذِ", 12);
    freq.put("احت", 138);
    freq.put("احة", 66);
    freq.put("احب", 244);
    freq.put("احد", 330);
    freq.put("احح", 12);
    freq.put("م?", 9);
    freq.put("قب ", 36);
    freq.put("احا", 37);
    freq.put("احظ", 14);
    freq.put("احس", 95);
    freq.put("احز", 11);
    freq.put("احر", 18);
    freq.put("احذ", 12);
    freq.put("ُلْ", 11);
    freq.put(" دخ", 64);
    freq.put("وهو", 119);
    freq.put("ـع ", 27);
    freq.put("لہ", 214);
    freq.put("", 28);
    freq.put("ُلو", 12);
    freq.put(" دب", 18);
    freq.put("نعت", 15);
    freq.put("̨", 11);
    freq.put("ك ", 7358);
    freq.put("حہ ", 19);
    freq.put("نعر", 9);
    freq.put("ك?", 18);
    freq.put("نعش", 12);
    freq.put(" دا", 276);
    freq.put("نعن", 9);
    freq.put("نعه", 13);
    freq.put("نعل", 20);
    freq.put("نعم", 143);
    freq.put("نعي", 50);
    freq.put("نعو", 16);
    freq.put("رجو", 58);
    freq.put("?〰◾", 10);
    freq.put("لگ", 45);
    freq.put("لک", 20);
    freq.put("لن ", 207);
    freq.put("لھ", 47);
    freq.put("قده", 23);
    freq.put("آع ", 13);
    freq.put("لَ", 387);
    freq.put("لُ", 117);
    freq.put("لٌ", 24);
    freq.put("لٍ", 16);
    freq.put("لي", 5409);
    freq.put("لً", 15);
    freq.put("لو", 2726);
    freq.put("لى", 2211);
    freq.put("لن", 2040);
    freq.put("له", 5459);
    freq.put("لل", 5536);
    freq.put("لم", 5284);
    freq.put("لق", 1569);
    freq.put("لك", 2648);
    freq.put("لـ", 570);
    freq.put("لف", 1200);
    freq.put("صفو", 19);
    freq.put("صفي", 13);
    freq.put("إمت", 16);
    freq.put("إما", 47);
    freq.put("صفق", 13);
    freq.put("لْ", 101);
    freq.put("غل ", 44);
    freq.put("لِ", 338);
    freq.put("لّ", 307);
    freq.put("َوم", 25);
    freq.put("لحف", 16);
    freq.put("لحق", 107);
    freq.put("لحك", 68);
    freq.put("لحل", 68);
    freq.put("لحم", 284);
    freq.put("لحن", 53);
    freq.put("لحه", 13);
    freq.put("لحو", 27);
    freq.put("لحي", 357);
    freq.put("َوَ", 9);
    freq.put("لحَ", 54);
    freq.put("لحُ", 61);
    freq.put("لٺ", 9);
    freq.put("فر ", 292);
    freq.put("َوْ", 19);
    freq.put("؟ ", 659);
    freq.put("ل،", 46);
    freq.put("لحا", 118);
    freq.put("لحب", 186);
    freq.put("لحة", 14);
    freq.put("لحج", 26);
    freq.put("لحح", 10);
    freq.put("َوت", 13);
    freq.put("ل؟", 16);
    freq.put("لحز", 61);
    freq.put("لحس", 86);
    freq.put("لحش", 13);
    freq.put("ﮪﮪﮪ", 15);
    freq.put("لحض", 18);
    freq.put("لحظ", 98);
    freq.put("٩ ", 13);
    freq.put("لخ", 628);
    freq.put("لد", 1042);
    freq.put("لج", 975);
    freq.put("لح", 2101);
    freq.put("لت", 1964);
    freq.put("لث", 231);
    freq.put("لب", 2119);
    freq.put("لة", 546);
    freq.put("لئ", 41);
    freq.put("لا", 7537);
    freq.put("لؤ", 15);
    freq.put("لإ", 515);
    freq.put("لآ", 637);
    freq.put("لأ", 1631);
    freq.put("لـى", 11);
    freq.put("لـو", 38);
    freq.put("صفة", 9);
    freq.put("لغ", 488);
    freq.put("لظ", 116);
    freq.put("لع", 1868);
    freq.put("لض", 151);
    freq.put("لط", 497);
    freq.put("لش", 913);
    freq.put("لص", 859);
    freq.put("لز", 420);
    freq.put("لس", 1470);
    freq.put("لذ", 551);
    freq.put("لر", 802);
    freq.put("عوت", 15);
    freq.put("عوب", 10);
    freq.put("عوة", 28);
    freq.put("عود", 269);
    freq.put("نَّ", 23);
    freq.put("ددد", 17);
    freq.put("عوا", 93);
    freq.put("ضحك", 139);
    freq.put("نَه", 15);
    freq.put("اثي", 12);
    freq.put("نَك", 15);
    freq.put("نَف", 18);
    freq.put("فيہ", 19);
    freq.put("عوذ", 50);
    freq.put("اثق", 12);
    freq.put("عوض", 28);
    freq.put("نَي", 17);
    freq.put("اثن", 45);
    freq.put("قنا", 138);
    freq.put("جب ", 73);
    freq.put("ؤول", 18);
    freq.put("أثر", 13);
    freq.put("فتن", 50);
    freq.put("مـا", 36);
    freq.put("قنع", 24);
    freq.put("قدا", 77);
    freq.put("ِق ", 22);
    freq.put("أثن", 17);
    freq.put("مح ", 50);
    freq.put("قني", 93);
    freq.put("قنو", 12);
    freq.put("ودا", 47);
    freq.put("انہ", 12);
    freq.put("رن ", 37);
    freq.put("عوي", 10);
    freq.put("دده", 9);
    freq.put("جُل", 9);
    freq.put("〓〓", 20);
    freq.put("عوك", 9);
    freq.put("جُو", 22);
    freq.put("عون", 114);
    freq.put("ددو", 9);
    freq.put("ﭑﻟ", 14);
    freq.put("اثة", 20);
    freq.put("نَح", 12);
    freq.put("عوّ", 11);
    freq.put("نَت", 16);
    freq.put("اثا", 25);
    freq.put("━━", 22);
    freq.put("بّر", 9);
    freq.put("̸̸", 9);
    freq.put("آف ", 10);
    freq.put("مُؤ", 12);
    freq.put("رع ", 125);
    freq.put("انظ", 21);
    freq.put("حتا", 120);
    freq.put("فش ", 9);
    freq.put("مَا", 162);
    freq.put("انز", 21);
    freq.put("انس", 131);
    freq.put("انط", 12);
    freq.put("انش", 45);
    freq.put("انص", 36);
    freq.put("انت", 666);
    freq.put("انث", 22);
    freq.put("حتض", 16);
    freq.put("انة", 35);
    freq.put("حتر", 102);
    freq.put("انج", 30);
    freq.put("حتس", 9);
    freq.put("انآ", 10);
    freq.put("مَع", 32);
    freq.put("انا", 665);
    freq.put("حتل", 15);
    freq.put("حتم", 18);
    freq.put("حته", 42);
    freq.put("مَل", 43);
    freq.put("حتف", 16);
    freq.put("مَن", 81);
    freq.put("حتك", 19);
    freq.put("انْ", 26);
    freq.put("حتَ", 9);
    freq.put("انّ", 20);
    freq.put("حتو", 33);
    freq.put("حتى", 233);
    freq.put("حتي", 48);
    freq.put("اني", 653);
    freq.put("مَّ", 15);
    freq.put("انو", 140);
    freq.put("انى", 15);
    freq.put("انَ", 65);
    freq.put("حتّ", 10);
    freq.put("انق", 59);
    freq.put("انك", 255);
    freq.put("انـ", 38);
    freq.put("انف", 44);
    freq.put("انن", 50);
    freq.put("انه", 311);
    freq.put("انم", 10);
    freq.put("بّي", 9);
    freq.put("بَّ", 14);
    freq.put("بُّ", 9);
    freq.put("بّك", 17);
    freq.put("مُح", 34);
    freq.put("با ", 124);
    freq.put("بّه", 10);
    freq.put("ہْ ", 10);
    freq.put("ندس", 11);
    freq.put("بُو", 15);
    freq.put("مُج", 20);
    freq.put("َقِ", 13);
    freq.put("ُق ", 11);
    freq.put("جيش", 57);
    freq.put("َقي", 12);
    freq.put("لثل", 27);
    freq.put("سجد", 50);
    freq.put("لثق", 34);
    freq.put("إشا", 10);
    freq.put("إشت", 15);
    freq.put("لثو", 49);
    freq.put("قمت", 19);
    freq.put("دن ", 44);
    freq.put("هذا", 345);
    freq.put("َقر", 11);
    freq.put("لثا", 62);
    freq.put("قمة", 24);
    freq.put("يْه", 16);
    freq.put("يْن", 16);
    freq.put("ئعه", 9);
    freq.put("ذَا", 16);
    freq.put("﴾", 27);
    freq.put(" ت ", 15);
    freq.put("عي ", 232);
    freq.put("ّلا", 10);
    freq.put("┃", 27);
    freq.put("دح ", 15);
    freq.put("وشك", 27);
    freq.put("عثم", 10);
    freq.put("وشي", 10);
    freq.put("غش ", 16);
    freq.put("سى ", 145);
    freq.put("ﻮﻥ ", 11);
    freq.put("هْ", 30);
    freq.put("أة ", 73);
    freq.put("", 17);
    freq.put("وُد", 12);
    freq.put("ﺪ", 52);
    freq.put("لود", 19);
    freq.put("تجم", 36);
    freq.put("تجل", 20);
    freq.put("تجن", 19);
    freq.put("ضب ", 25);
    freq.put("تجي", 82);
    freq.put("وُن", 33);
    freq.put("وُم", 9);
    freq.put("تجر", 33);
    freq.put("تجع", 56);
    freq.put("تجا", 95);
    freq.put("أضي", 10);
    freq.put("تجد", 48);
    freq.put("تجب", 10);
    freq.put("وشا", 12);
    freq.put("ّله", 9);
    freq.put("ُخر", 10);
    freq.put("اخل", 146);
    freq.put("نو ", 82);
    freq.put("عثر", 26);
    freq.put("وشر", 10);
    freq.put("اة ", 385);
    freq.put("ـى ", 33);
    freq.put("سجو", 18);
    freq.put("تٍ ", 16);
    freq.put("قل", 1418);
    freq.put("قم", 174);
    freq.put("قن", 320);
    freq.put("قه", 480);
    freq.put("قـ", 146);
    freq.put("قف", 182);
    freq.put("قق", 74);
    freq.put("قك", 179);
    freq.put("قٌ", 13);
    freq.put("قٍ", 9);
    freq.put("قَ", 188);
    freq.put("قُ", 149);
    freq.put("قو", 1165);
    freq.put("قى", 235);
    freq.put("قي", 1014);
    freq.put("قً", 12);
    freq.put("سجل", 17);
    freq.put("ﺓ", 9);
    freq.put("قِ", 84);
    freq.put("قّ", 45);
    freq.put("قْ", 41);
    freq.put("ًا", 246);
    freq.put("بمل", 12);
    freq.put("حج ", 13);
    freq.put("فيت", 39);
    freq.put("فطر", 12);
    freq.put("ال ", 1326);
    freq.put("يآن", 16);
    freq.put("اھ", 9);
    freq.put("يآر", 19);
    freq.put("ق،", 17);
    freq.put("يآء", 14);
    freq.put("فطو", 10);
    freq.put("يآت", 19);
    freq.put("يآة", 9);
    freq.put("يآب", 14);
    freq.put("زعج", 12);
    freq.put("قا", 1555);
    freq.put("مُع", 13);
    freq.put("قآ", 38);
    freq.put("قح", 15);
    freq.put("قد", 954);
    freq.put("قب", 581);
    freq.put("تنع", 14);
    freq.put("قت", 627);
    freq.put("قش", 23);
    freq.put("قص", 333);
    freq.put("قض", 76);
    freq.put("قط", 412);
    freq.put("قذ", 27);
    freq.put("قر", 577);
    freq.put("قز", 12);
    freq.put("قس", 103);
    freq.put("ۈ ", 50);
    freq.put("قظ", 29);
    freq.put("قع", 211);
    freq.put("اشف", 28);
    freq.put("اشق", 21);
    freq.put("اشك", 33);
    freq.put("اشل", 17);
    freq.put("قہ", 45);
    freq.put("اشه", 21);
    freq.put("اشو", 57);
    freq.put("اشي", 83);
    freq.put("ﺎلل", 14);
    freq.put("ﺎلن", 10);
    freq.put("بک ", 12);
    freq.put("تنس", 61);
    freq.put("شـي", 9);
    freq.put("حطي", 11);
    freq.put("عذي", 12);
    freq.put("شى ", 42);
    freq.put("كي ", 290);
    freq.put("مثل", 188);
    freq.put("مثق", 10);
    freq.put("مرة", 82);
    freq.put("أقو", 74);
    freq.put("ك", 20822);
    freq.put("جتي", 19);
    freq.put("مثا", 16);
    freq.put("جتك", 11);
    freq.put("جتم", 60);
    freq.put("جته", 39);
    freq.put("جتن", 10);
    freq.put("ـ ", 545);
    freq.put("عذر", 35);
    freq.put("اشا", 35);
    freq.put("اشب", 10);
    freq.put("اشت", 106);
    freq.put("ودر", 17);
    freq.put("ﺎلا", 11);
    freq.put("اشد", 19);
    freq.put("ﺎلع", 9);
    freq.put("اشر", 62);
    freq.put("عذا", 46);
    freq.put("نشا", 34);
    freq.put("اشع", 25);
    freq.put("قھ", 9);
    freq.put("صب ", 29);
    freq.put("يلَ", 13);
    freq.put("ّمَ", 11);
    freq.put("اكَ", 17);
    freq.put("ُري", 22);
    freq.put("ُرو", 11);
    freq.put("ضلك", 11);
    freq.put("يلي", 93);
    freq.put("ّن ", 19);
    freq.put("ا، ", 74);
    freq.put("رلي", 9);
    freq.put("طائ", 43);
    freq.put("يلك", 49);
    freq.put("ؤذي", 21);
    freq.put("ُرا", 14);
    freq.put("ُرب", 22);
    freq.put("هذه", 140);
    freq.put("مُد", 13);
    freq.put("شئت", 25);
    freq.put("̸ ", 16);
    freq.put("٦ ", 16);
    freq.put(" جه", 56);
    freq.put(" جن", 133);
    freq.put(" جم", 422);
    freq.put(" جل", 36);
    freq.put(" جف", 29);
    freq.put(" جـ", 12);
    freq.put(" جُ", 19);
    freq.put(" جَ", 45);
    freq.put("", 13);
    freq.put(" جي", 127);
    freq.put(" جو", 126);
    freq.put("سآن", 14);
    freq.put("﴿", 29);
    freq.put(" جا", 234);
    freq.put(" جد", 265);
    freq.put(" جت", 12);
    freq.put(" جب", 64);
    freq.put(" جس", 41);
    freq.put(" جز", 62);
    freq.put(" جر", 116);
    freq.put(" جذ", 10);
    freq.put(" جع", 61);
    freq.put("دور", 130);
    freq.put("ـہ", 33);
    freq.put("ﺎح", 10);
    freq.put("مُخ", 12);
    freq.put("ۈل", 17);
    freq.put("الذ", 454);
    freq.put("الر", 700);
    freq.put("الز", 231);
    freq.put("الس", 1144);
    freq.put("الش", 801);
    freq.put("حجا", 17);
    freq.put("الض", 139);
    freq.put("الط", 316);
    freq.put("الظ", 110);
    freq.put("الع", 1417);
    freq.put("الغ", 329);
    freq.put("حجة", 9);
    freq.put("ج", 8687);
    freq.put("لجـ", 12);
    freq.put("الآ", 267);
    freq.put("الأ", 1197);
    freq.put("الإ", 440);
    freq.put("الا", 1514);
    freq.put("الب", 1010);
    freq.put("الة", 92);
    freq.put("الت", 1115);
    freq.put("الث", 206);
    freq.put("الج", 758);
    freq.put("الح", 1670);
    freq.put("الخ", 557);
    freq.put("الد", 764);
    freq.put("الِ", 20);
    freq.put("الّ", 18);
    freq.put("الْ", 50);
    freq.put("ﺍ ", 14);
    freq.put("حجم", 29);
    freq.put("لجه", 35);
    freq.put("الـ", 146);
    freq.put("الف", 811);
    freq.put("الق", 914);
    freq.put("الك", 803);
    freq.put("الل", 4021);
    freq.put("الم", 2690);
    freq.put("الن", 1227);
    freq.put("اله", 458);
    freq.put("الو", 658);
    freq.put("الى", 185);
    freq.put("الي", 914);
    freq.put("لصا", 72);
    freq.put("الَ", 27);
    freq.put("ضني", 11);
    freq.put("ﺎً", 10);
    freq.put("ق ", 2109);
    freq.put("ﻧ", 83);
    freq.put("ﺎل", 107);
    freq.put("ـگ", 11);
    freq.put("ﺎن", 18);
    freq.put("مًا", 37);
    freq.put("ـَـ", 12);
    freq.put("ۈا", 15);
    freq.put("ـق", 57);
    freq.put("ـك", 153);
    freq.put("ــ", 2734);
    freq.put("ـف", 56);
    freq.put("ـن", 215);
    freq.put("ـه", 237);
    freq.put("ـل", 227);
    freq.put("ـم", 172);
    freq.put("ـي", 352);
    freq.put("لجم", 209);
    freq.put("ـو", 262);
    freq.put("ـى", 33);
    freq.put("ـَ", 38);
    freq.put("ـْ", 20);
    freq.put("ـِ", 37);
    freq.put("ـّ", 23);
    freq.put("رجا", 128);
    freq.put("متِ", 9);
    freq.put("كيت", 13);
    freq.put("كيب", 9);
    freq.put("كية", 18);
    freq.put("كيد", 39);
    freq.put("🇪?", 21);
    freq.put("جت ", 23);
    freq.put("َة ", 65);
    freq.put("ﮪ", 20);
    freq.put("كيا", 46);
    freq.put("الھ", 10);
    freq.put("إضا", 9);
    freq.put("👇 ", 11);
    freq.put("كير", 58);
    freq.put("كيو", 12);
    freq.put("كيك", 13);
    freq.put("كيف", 215);
    freq.put("كين", 70);
    freq.put("كيه", 20);
    freq.put("كيل", 53);
    freq.put("كيم", 42);
    freq.put("الہ", 11);
    freq.put("اش ", 58);
    freq.put("ـأ", 19);
    freq.put("ـا", 502);
    freq.put("ـت", 169);
    freq.put("ـث", 9);
    freq.put("ـب", 117);
    freq.put("ـة", 55);
    freq.put("ـخ", 9);
    freq.put("ـد", 187);
    freq.put("ـج", 18);
    freq.put("ـح", 62);
    freq.put("ـز", 41);
    freq.put("ـس", 65);
    freq.put("ـذ", 39);
    freq.put("ـر", 278);
    freq.put("ـض", 11);
    freq.put("ـط", 17);
    freq.put("ـش", 31);
    freq.put("ـص", 18);
    freq.put("إفر", 11);
    freq.put("ـظ", 10);
    freq.put("ـع", 78);
    freq.put("صبا", 261);
    freq.put("صبآ", 18);
    freq.put("هہ", 218);
    freq.put("صبح", 249);
    freq.put("صبر", 94);
    freq.put("قضي", 35);
    freq.put("وزا", 50);
    freq.put("√", 15);
    freq.put("صبع", 13);
    freq.put("أشع", 10);
    freq.put("ثه ", 14);
    freq.put("تخف", 14);
    freq.put("تخل", 52);
    freq.put("تخي", 42);
    freq.put("أشخ", 37);
    freq.put("تخو", 18);
    freq.put("أشت", 31);
    freq.put("تخس", 19);
    freq.put("لٍ ", 12);
    freq.put("تخر", 43);
    freq.put("تخذ", 24);
    freq.put("تخط", 15);
    freq.put("تخش", 10);
    freq.put("أشه", 23);
    freq.put("تخا", 33);
    freq.put("ّني", 20);
    freq.put("أشك", 12);
    freq.put("تخت", 25);
    freq.put("تخب", 26);
    freq.put("تخد", 42);
    freq.put("أشي", 82);
    freq.put("و?", 11);
    freq.put("يقر", 32);
    freq.put("كفي", 85);
    freq.put("صبَ", 9);
    freq.put("صبي", 9);
    freq.put("كفى", 15);
    freq.put("كفو", 21);
    freq.put("قضا", 16);
    freq.put("ُر ", 27);
    freq.put("وزه", 9);
    freq.put("وزن", 32);
    freq.put(" ٣ ", 23);
    freq.put("مب ", 13);
    freq.put("شئ ", 24);
    freq.put("كفن", 18);
    freq.put("إره", 16);
    freq.put("ذاق", 9);
    freq.put("يّن", 18);
    freq.put("عزي", 86);
    freq.put("دد ", 177);
    freq.put("عو ", 38);
    freq.put("〰🔝", 14);
    freq.put("جبا", 36);
    freq.put("محل", 30);
    freq.put("يحف", 26);
    freq.put("عتر", 40);
    freq.put("محك", 16);
    freq.put("ماي", 155);
    freq.put("جبت", 28);
    freq.put("محي", 25);
    freq.put("مھ", 9);
    freq.put("جبر", 33);
    freq.put("جبه", 36);
    freq.put("جبن", 35);
    freq.put("محا", 87);
    freq.put("جبك", 15);
    freq.put("كَ ", 248);
    freq.put("وآ ", 26);
    freq.put("محد", 49);
    freq.put("مہ", 46);
    freq.put("جبي", 15);
    freq.put("رنس", 16);
    freq.put("محش", 26);
    freq.put("محط", 15);
    freq.put("محر", 14);
    freq.put("محس", 13);
    freq.put("ماق", 41);
    freq.put("رنا", 151);
    freq.put("محظ", 10);
    freq.put("عزت", 10);
    freq.put("ماه", 112);
    freq.put("عزا", 25);
    freq.put("نَ ", 269);
    freq.put("اث ", 68);
    freq.put("م،", 76);
    freq.put("ﻓﻲ ", 11);
    freq.put("ماغ", 19);
    freq.put("لصل", 74);
    freq.put("م؟", 16);
    freq.put("باي", 56);
    freq.put("باً", 110);
    freq.put("بان", 108);
    freq.put("باه", 17);
    freq.put("بال", 1293);
    freq.put("بام", 12);
    freq.put("باق", 70);
    freq.put("باك", 219);
    freq.put("مح", 758);
    freq.put("مج", 319);
    freq.put("مد", 1074);
    freq.put("مخ", 169);
    freq.put("حت ", 177);
    freq.put("مب", 263);
    freq.put("مث", 240);
    freq.put("مت", 1489);
    freq.put("ثما", 17);
    freq.put("مؤ", 166);
    freq.put("ما", 5179);
    freq.put("مئ", 30);
    freq.put("مأ", 24);
    freq.put("مآ", 259);
    freq.put("مع", 1613);
    freq.put("مظ", 26);
    freq.put("كده", 22);
    freq.put("مغ", 152);
    freq.put("مص", 238);
    freq.put("مش", 506);
    freq.put("مط", 177);
    freq.put("مض", 157);
    freq.put("مر", 1388);
    freq.put("مذ", 53);
    freq.put("مس", 1089);
    freq.put("مز", 135);
    freq.put("مٍ", 19);
    freq.put("مٌ", 34);
    freq.put("مُ", 410);
    freq.put("مَ", 731);
    freq.put("مى", 56);
    freq.put("مو", 1236);
    freq.put("مً", 47);
    freq.put("مي", 2040);
    freq.put("مم", 405);
    freq.put("ثمن", 12);
    freq.put("مه", 910);
    freq.put("من", 5200);
    freq.put("مف", 174);
    freq.put("مـ", 293);
    freq.put("مك", 747);
    freq.put("مق", 268);
    freq.put("ﻐ", 9);
    freq.put("ذاب", 59);
    freq.put("كدا", 10);
    freq.put("ِدا", 16);
    freq.put("كدة", 9);
    freq.put("˘", 40);
    freq.put("ماش", 46);
    freq.put("مّ", 237);
    freq.put("مِ", 340);
    freq.put("مٓ", 11);
    freq.put("مْ", 160);
    freq.put("َحن", 14);
    freq.put("باع", 35);
    freq.put("باط", 33);
    freq.put("باش", 22);
    freq.put("باص", 13);
    freq.put("باس", 52);
    freq.put("بار", 390);
    freq.put("باد", 83);
    freq.put("باح", 270);
    freq.put("بات", 136);
    freq.put("رعو", 15);
    freq.put("باب", 219);
    freq.put("رعي", 17);
    freq.put("بائ", 23);
    freq.put("باا", 43);
    freq.put("رعه", 20);
    freq.put("مٱ", 10);
    freq.put("باء", 50);
    freq.put("ئع ", 35);
    freq.put("لعط", 35);
    freq.put("ماح", 20);
    freq.put("يْ ", 73);
    freq.put("لعذ", 22);
    freq.put("مُر", 16);
    freq.put("ذار", 27);
    freq.put(" تِ", 18);
    freq.put("َحَ", 12);
    freq.put(" تُ", 163);
    freq.put(" تَ", 196);
    freq.put(" تو", 317);
    freq.put(" تي", 29);
    freq.put(" تم", 257);
    freq.put(" تل", 181);
    freq.put(" ته", 78);
    freq.put(" تن", 304);
    freq.put(" تف", 247);
    freq.put(" تـ", 74);
    freq.put(" تك", 344);
    freq.put(" تق", 320);
    freq.put("دنـ", 9);
    freq.put("دني", 287);
    freq.put("ُقا", 13);
    freq.put("َـ ", 19);
    freq.put("يّر", 18);
    freq.put("🔲〰", 12);
    freq.put("ہ", 1208);
    freq.put("دنا", 95);
    freq.put("خُل", 10);
    freq.put("لث ", 21);
    freq.put("Ⓜ ", 85);
    freq.put("َق ", 11);
    freq.put(" تع", 676);
    freq.put(" تظ", 20);
    freq.put(" تغ", 189);
    freq.put(" تص", 184);
    freq.put(" تش", 208);
    freq.put(" تط", 106);
    freq.put(" تض", 83);
    freq.put(" تر", 528);
    freq.put(" تذ", 90);
    freq.put(" تس", 437);
    freq.put(" تز", 57);
    freq.put(" تح", 576);
    freq.put(" تج", 259);
    freq.put(" تد", 197);
    freq.put(" تخ", 184);
    freq.put(" تب", 310);
    freq.put(" تث", 24);
    freq.put(" تت", 305);
    freq.put(" تؤ", 27);
    freq.put(" تا", 161);
    freq.put(" تأ", 88);
    freq.put(" تآ", 11);
    freq.put("يقد", 30);
    freq.put("نوو", 17);
    freq.put("ّل ", 40);
    freq.put("عيا", 37);
    freq.put("عيب", 46);
    freq.put("عية", 50);
    freq.put("عيت", 9);
    freq.put("نون", 158);
    freq.put("عيد", 203);
    freq.put("عيس", 10);
    freq.put("عيش", 115);
    freq.put(" ۞ ", 17);
    freq.put("دز ", 9);
    freq.put("وُ ", 20);
    freq.put("ضبط", 11);
    freq.put("يرى", 29);
    freq.put("إرح", 10);
    freq.put("ضبا", 12);
    freq.put("Ⓜ", 92);
    freq.put("قتر", 36);
    freq.put("للع", 37);
    freq.put("يرك", 116);
    freq.put("تج ", 13);
    freq.put("مذا", 26);
    freq.put("عيـ", 14);
    freq.put("عيف", 18);
    freq.put("نود", 12);
    freq.put("عيك", 14);
    freq.put("عيل", 18);
    freq.put("عيم", 40);
    freq.put("عين", 545);
    freq.put("عيه", 23);
    freq.put("عيو", 177);
    freq.put("كفا", 23);
    freq.put("عيي", 13);
    freq.put("عيُ", 10);
    freq.put("عيّ", 23);
    freq.put("نوع", 42);
    freq.put("إرا", 12);
    freq.put("آني", 40);
    freq.put("نور", 110);
    freq.put("ﺏ", 13);
    freq.put("ﻻ ", 88);
    freq.put("رأه", 17);
    freq.put("يقت", 74);
    freq.put("رأي", 63);
    freq.put("رأى", 12);
    freq.put("روس", 27);
    freq.put("رور", 69);
    freq.put("روض", 40);
    freq.put("روط", 10);
    freq.put("روع", 60);
    freq.put("لعف", 26);
    freq.put("👇", 19);
    freq.put("👆", 17);
    freq.put("ش", 7900);
    freq.put("👍", 9);
    freq.put("مّ ", 74);
    freq.put("👏", 10);
    freq.put("روخ", 9);
    freq.put("رود", 27);
    freq.put("روج", 19);
    freq.put("روح", 244);
    freq.put("فِر", 27);
    freq.put("روق", 39);
    freq.put("روك", 26);
    freq.put("روف", 112);
    freq.put("رون", 170);
    freq.put("روه", 24);
    freq.put("روم", 30);
    freq.put("روي", 30);
    freq.put("روو", 21);
    freq.put("روُ", 13);
    freq.put("رأس", 31);
    freq.put("ِف ", 12);
    freq.put("رأت", 14);
    freq.put("رأة", 54);
    freq.put("خفا", 15);
    freq.put("مرج", 12);
    freq.put("هؤل", 11);
    freq.put("ربك", 75);
    freq.put("غط ", 15);
    freq.put("إحت", 26);
    freq.put(" ذك", 116);
    freq.put("طفك", 10);
    freq.put("؛ ", 219);
    freq.put(" ذه", 25);
    freq.put(" ذن", 69);
    freq.put("إحس", 26);
    freq.put(" ذل", 90);
    freq.put(" ذي", 33);
    freq.put(" ذو", 24);
    freq.put(" ذَ", 10);
    freq.put(" ذر", 23);
    freq.put(" ذآ", 13);
    freq.put("💧", 15);
    freq.put(" ذا", 141);
    freq.put("💠", 13);
    freq.put("إدا", 14);
    freq.put("💯", 19);
    freq.put(" ذب", 12);
    freq.put("💫", 23);
    freq.put("💕", 27);
    freq.put("💔", 33);
    freq.put("خفف", 10);
    freq.put("💐", 9);
    freq.put("للي", 815);
    freq.put("خفي", 37);
    freq.put("💜", 30);
    freq.put("💟", 18);
    freq.put("عتا", 26);
    freq.put("💙", 47);
    freq.put("💘", 18);
    freq.put("💚", 28);
    freq.put("زا ", 12);
    freq.put("وف ", 267);
    freq.put("💃", 21);
    freq.put(" خـ", 20);
    freq.put("💍", 17);
    freq.put("💏", 9);
    freq.put("💎", 13);
    freq.put("قصر", 30);
    freq.put("سُو", 15);
    freq.put("قصص", 9);
    freq.put("أدر", 32);
    freq.put("تهى", 12);
    freq.put("تهي", 62);
    freq.put("اذك", 47);
    freq.put("ققت", 9);
    freq.put("تهُ", 12);
    freq.put("أدع", 19);
    freq.put("ضهم", 14);
    freq.put("تهل", 9);
    freq.put("تهم", 130);
    freq.put("تهن", 12);
    freq.put("أدا", 11);
    freq.put("ذله", 9);
    freq.put("أدب", 26);
    freq.put("دُن", 23);
    freq.put("ذلك", 146);
    freq.put("ؤلم", 61);
    freq.put("تهب", 16);
    freq.put("🔴", 22);
    freq.put("🔷", 10);
    freq.put("🔰", 9);
    freq.put("🔳", 9);
    freq.put("🔲", 28);
    freq.put("اﻻ ", 9);
    freq.put("ضها", 13);
    freq.put("🔺", 13);
    freq.put("مة ", 559);
    freq.put("أدو", 12);
    freq.put("أدي", 9);
    freq.put("ؤلا", 15);
    freq.put("◾〰?", 10);
    freq.put("ته،", 10);
    freq.put("🔝", 25);
    freq.put("سُب", 31);
    freq.put("اض ", 75);
    freq.put("🔙", 11);
    freq.put("وّي", 9);
    freq.put("قصا", 18);
    freq.put("عض ", 226);
    freq.put("دثو", 11);
    freq.put("ّى ", 26);
    freq.put("اقا", 44);
    freq.put("̶ ", 35);
    freq.put("اقد", 63);
    freq.put("اقت", 70);
    freq.put("اقب", 54);
    freq.put("اقة", 34);
    freq.put("اقض", 14);
    freq.put("اقش", 10);
    freq.put("اقص", 22);
    freq.put("اقس", 21);
    freq.put("اقر", 35);
    freq.put("آجم", 11);
    freq.put("آجل", 15);
    freq.put("̵̵ ", 13);
    freq.put("اقع", 47);
    freq.put("حضر", 24);
    freq.put("ميد", 84);
    freq.put("ناظ", 15);
    freq.put("ناع", 51);
    freq.put("ميت", 57);
    freq.put("ري ", 843);
    freq.put("تهہ", 10);
    freq.put(" خخ", 12);
    freq.put("نار", 73);
    freq.put("ناز", 24);
    freq.put("ناس", 434);
    freq.put("ناج", 20);
    freq.put("ناح", 13);
    freq.put("ناد", 114);
    freq.put("ناب", 22);
    freq.put("ناة", 24);
    freq.put("نات", 166);
    freq.put("حضا", 11);
    freq.put("نائ", 40);
    freq.put("ثى ", 55);
    freq.put("ناء", 70);
    freq.put("ميز", 59);
    freq.put("ميس", 27);
    freq.put("قىَ", 11);
    freq.put("ميو", 9);
    freq.put("ميي", 30);
    freq.put("ميل", 242);
    freq.put("ميم", 30);
    freq.put("مين", 373);
    freq.put("ميه", 46);
    freq.put("ميـ", 11);
    freq.put("ميك", 24);
    freq.put("ناَ", 10);
    freq.put("لوج", 61);
    freq.put("ناو", 17);
    freq.put("حضن", 28);
    freq.put("ناً", 86);
    freq.put("حضو", 28);
    freq.put("نام", 146);
    freq.put("نان", 106);
    freq.put("ناه", 85);
    freq.put("ناف", 61);
    freq.put("ناق", 52);
    freq.put("ناك", 129);
    freq.put("اقن", 17);
    freq.put("اقه", 62);
    freq.put("اقل", 63);
    freq.put("آجع", 10);
    freq.put("اقك", 19);
    freq.put("اقـ", 11);
    freq.put("اقف", 26);
    freq.put("اقَ", 9);
    freq.put("اقُ", 12);
    freq.put("√ ", 15);
    freq.put("اقو", 100);
    freq.put("وضو", 34);
    freq.put("ّيت", 16);
    freq.put("وضي", 19);
    freq.put("وضه", 10);
    freq.put("وضن", 9);
    freq.put(" 😍", 16);
    freq.put("فِ ", 26);
    freq.put(" ﻋﻠ", 11);
    freq.put("وفج", 13);
    freq.put(" ﻋﻨ", 9);
    freq.put(" خش", 17);
    freq.put("ئق ", 29);
    freq.put(" خط", 137);
    freq.put("تتو", 37);
    freq.put("تتن", 10);
    freq.put("🙏", 30);
    freq.put("تتك", 26);
    freq.put("تتف", 9);
    freq.put("وفو", 32);
    freq.put("وفى", 12);
    freq.put("وفي", 240);
    freq.put("تتغ", 18);
    freq.put("😳", 14);
    freq.put("وفـ", 15);
    freq.put("سيف", 20);
    freq.put("تتص", 9);
    freq.put("وفك", 49);
    freq.put("تتس", 13);
    freq.put("دق ", 120);
    freq.put("وفه", 49);
    freq.put("تتخ", 16);
    freq.put("تتح", 33);
    freq.put("تتج", 14);
    freq.put("تتت", 21);
    freq.put("😢", 11);
    freq.put("😭", 23);
    freq.put("تتأ", 16);
    freq.put("😔", 16);
    freq.put("ﻣ", 117);
    freq.put("وضح", 13);
    freq.put("😜", 15);
    freq.put("😘", 18);
    freq.put("وضا", 11);
    freq.put("گ ", 153);
    freq.put("وضع", 44);
    freq.put("😄", 16);
    freq.put("😁", 44);
    freq.put("😃", 9);
    freq.put("😂", 165);
    freq.put("😍", 31);
    freq.put("ه😂", 11);
    freq.put("😉", 20);
    freq.put("😊", 17);
    freq.put("طبا", 15);
    freq.put("جى ", 9);
    freq.put("لوَ", 12);
    freq.put("̵̵̵", 9);
    freq.put("طبخ", 21);
    freq.put("عَ ", 46);
    freq.put("دة ", 693);
    freq.put("ِكَ", 32);
    freq.put("بذك", 21);
    freq.put("طبع", 26);
    freq.put("بذل", 21);
    freq.put("تحي", 95);
    freq.put("قل ", 196);
    freq.put("طفي", 19);
    freq.put("لأط", 21);
    freq.put("مِح", 9);
    freq.put("ؤدي", 10);
    freq.put("تى ", 354);
    freq.put("ضف ", 59);
    freq.put("🚸", 16);
    freq.put("🚩", 15);
    freq.put("طبل", 9);
    freq.put("ىى", 19);
    freq.put("طبق", 16);
    freq.put("ِكر", 12);
    freq.put("لأص", 37);
    freq.put("طبي", 73);
    freq.put("نٌ ", 22);
    freq.put("ﷺ", 56);
    freq.put("بذا", 12);
    freq.put("يخر", 16);
    freq.put("ـآ ", 36);
    freq.put("💎 ", 9);
    freq.put("هرك", 11);
    freq.put("ِسا", 12);
    freq.put("نكس", 23);
    freq.put("مٌ ", 19);
    freq.put("حب ", 434);
    freq.put("غصب", 15);
    freq.put("ححب", 11);
    freq.put(" د ", 19);
    freq.put("خط", 328);
    freq.put("نّي", 36);
    freq.put("نَّ", 22);
    freq.put("اذي", 16);
    freq.put("نّك", 13);
    freq.put("اذن", 19);
    freq.put("اذه", 12);
    freq.put("نّه", 28);
    freq.put("● ", 16);
    freq.put("عشو", 9);
    freq.put("عشق", 114);
    freq.put("ذان", 11);
    freq.put("ذال", 10);
    freq.put("شغ", 73);
    freq.put("ذاك", 158);
    freq.put("شع", 320);
    freq.put("شط", 23);
    freq.put("شش", 58);
    freq.put("شس", 10);
    freq.put("شر", 788);
    freq.put("شخ", 321);
    freq.put("شد", 115);
    freq.put("شج", 56);
    freq.put("شح", 19);
    freq.put("شت", 347);
    freq.put("ماَ", 13);
    freq.put("شب", 206);
    freq.put("شة", 32);
    freq.put("شئ", 56);
    freq.put("شا", 906);
    freq.put("ماف", 87);
    freq.put("شآ", 40);
    freq.put("شأ", 23);
    freq.put("مام", 192);
    freq.put("مال", 316);
    freq.put("ذاا", 17);
    freq.put("ماع", 141);
    freq.put("َحْ", 16);
    freq.put("ذاء", 12);
    freq.put("ماس", 54);
    freq.put("ماز", 27);
    freq.put("مار", 156);
    freq.put("ماذ", 85);
    freq.put("ذات", 56);
    freq.put("ماض", 35);
    freq.put("شِ", 35);
    freq.put("شّ", 45);
    freq.put("شَ", 91);
    freq.put("شُ", 31);
    freq.put("ماب", 67);
    freq.put("شي", 1102);
    freq.put("ماخ", 17);
    freq.put("شو", 512);
    freq.put("شى", 48);
    freq.put("شن", 77);
    freq.put("شه", 290);
    freq.put("شل", 149);
    freq.put("شم", 162);
    freq.put("شق", 231);
    freq.put("شك", 429);
    freq.put("شـ", 85);
    freq.put("شف", 283);
    freq.put("نّة", 11);
    freq.put("اذب", 20);
    freq.put("شم ", 12);
    freq.put("اذا", 389);
    freq.put("نّا", 29);
    freq.put("عشر", 56);
    freq.put("عشا", 127);
    freq.put("عشآ", 13);
    freq.put("گو", 10);
    freq.put("ّي ", 90);
    freq.put("گن", 15);
    freq.put("گم", 10);
    freq.put("گل", 33);
    freq.put("هِي", 17);
    freq.put("گـ", 12);
    freq.put("فہ ", 20);
    freq.put(" خو", 60);
    freq.put(" خي", 287);
    freq.put("دقي", 46);
    freq.put(" خُ", 13);
    freq.put(" خَ", 43);
    freq.put(" خف", 45);
    freq.put("دقه", 28);
    freq.put(" خم", 23);
    freq.put(" خل", 372);
    freq.put(" خن", 11);
    freq.put("َسَ", 27);
    freq.put(" 😔", 10);
    freq.put(" خب", 62);
    freq.put("دقت", 12);
    freq.put(" خد", 28);
    freq.put("دقة", 24);
    freq.put(" 😜", 10);
    freq.put("دقا", 75);
    freq.put(" خآ", 16);
    freq.put(" 😘", 9);
    freq.put(" خا", 253);
    freq.put(" 😁", 22);
    freq.put(" 😂", 62);
    freq.put(" خر", 46);
    freq.put(" خذ", 44);
    freq.put(" خس", 33);
    freq.put(" خص", 17);
    freq.put(" 😉", 10);
    freq.put(" 😊", 10);
    freq.put("تت ", 38);
    freq.put("گث", 10);
    freq.put("عة ", 329);
    freq.put("گا", 9);
    freq.put("وض ", 45);
    freq.put("فِي", 139);
    freq.put("نهه", 9);
    freq.put("ُمْ", 33);
    freq.put(" 😭", 11);
    freq.put("ُمّ", 22);
    freq.put("گر", 14);
    freq.put("عَد", 23);
    freq.put("طب ", 34);
    freq.put("عَا", 46);
    freq.put("〓", 26);
    freq.put("مقا", 64);
    freq.put("عَر", 9);
    freq.put("قلـ", 12);
    freq.put("أحد", 231);
    freq.put("قلا", 25);
    freq.put("دة،", 10);
    freq.put("أحت", 21);
    freq.put("أحب", 186);
    freq.put("أحا", 17);
    freq.put("قلق", 24);
    freq.put("قلة", 17);
    freq.put("قلب", 619);
    freq.put("قلت", 104);
    freq.put("أحض", 10);
    freq.put("أحس", 87);
    freq.put("أحز", 21);
    freq.put("أحر", 14);
    freq.put("قلم", 29);
    freq.put("أحَ", 20);
    freq.put("قله", 20);
    freq.put("قلن", 9);
    freq.put("أحي", 68);
    freq.put("ه", 29927);
    freq.put("أحو", 11);
    freq.put("أحم", 32);
    freq.put("أحل", 58);
    freq.put("أحق", 12);
    freq.put("أحف", 10);
    freq.put("أحـ", 20);
    freq.put("ؤية", 10);
    freq.put("ؤيت", 13);
    freq.put("ضفض", 11);
    freq.put("ودي", 238);
    freq.put("عَي", 17);
    freq.put("عَل", 121);
    freq.put("عَن", 42);
    freq.put("ۆ ", 39);
    freq.put("ِك ", 49);
    freq.put(" 🚩", 11);
    freq.put("آخي", 9);
    freq.put("لج ", 21);
    freq.put("آخل", 9);
    freq.put("حبت", 46);
    freq.put("حبب", 49);
    freq.put("حبة", 20);
    freq.put("حبا", 79);
    freq.put("̴", 11);
    freq.put("حبَ", 10);
    freq.put("حبُ", 18);
    freq.put("ﻋﻠ", 11);
    freq.put("حبي", 231);
    freq.put("حبو", 33);
    freq.put("حبن", 25);
    freq.put("حبه", 132);
    freq.put("ﻋﻨ", 9);
    freq.put("حبك", 204);
    freq.put("حبـ", 13);
    freq.put("جال", 96);
    freq.put("حبّ", 51);
    freq.put("ـآل", 9);
    freq.put("ولآ", 48);
    freq.put("آخر", 185);
    freq.put("آخت", 10);
    freq.put("مقد", 32);
    freq.put("شمه", 10);
    freq.put("يِر", 11);
    freq.put("كَا", 32);
    freq.put("لإي", 35);
    freq.put("َـَ", 10);
    freq.put("لإف", 13);
    freq.put("لإق", 12);
    freq.put("كَت", 16);
    freq.put("َــ", 17);
    freq.put("ش ", 872);
    freq.put("لإه", 15);
    freq.put("لإع", 24);
    freq.put("ذا ", 1145);
    freq.put("لإر", 15);
    freq.put("لإس", 88);
    freq.put("لإب", 23);
    freq.put("لإت", 13);
    freq.put("لإث", 10);
    freq.put("لإج", 15);
    freq.put("لإح", 24);
    freq.put("لإخ", 42);
    freq.put("لإد", 11);
    freq.put("حوي", 9);
    freq.put("ما ", 2249);
    freq.put("نّ ", 148);
    freq.put("اذ ", 32);
    freq.put("شما", 30);
    freq.put("شمر", 13);
    freq.put("شمس", 56);
    freq.put("عش ", 26);
    freq.put(" 👇", 9);
    freq.put("نفي", 15);
    freq.put("ّب ", 20);
    freq.put("ذ", 4237);
    freq.put("رو ", 34);
    freq.put("مّد", 12);
    freq.put("ْدِ", 9);
    freq.put("مقص", 9);
    freq.put("نفق", 14);
    freq.put("مّي", 16);
    freq.put("مَّ", 16);
    freq.put("مّل", 15);
    freq.put("مّه", 10);
    freq.put("مّن", 12);
    freq.put("رأ ", 45);
    freq.put("غـي", 13);
    freq.put("زاك", 27);
    freq.put("زال", 63);
    freq.put("زام", 37);
    freq.put("زان", 60);
    freq.put("زاي", 22);
    freq.put("زاً", 11);
    freq.put("يلو", 30);
    freq.put("حوا", 60);
    freq.put(" 💔", 16);
    freq.put("غطي", 10);
    freq.put("نفر", 12);
    freq.put("طفا", 45);
    freq.put(" 💜", 10);
    freq.put(" 💟", 10);
    freq.put(" 💘", 18);
    freq.put(" 💙", 32);
    freq.put(" 💚", 13);
    freq.put("زن ", 132);
    freq.put(" 💎", 10);
    freq.put("زار", 41);
    freq.put("زاز", 10);
    freq.put("فصل", 23);
    freq.put("زاء", 26);
    freq.put(" 💠", 10);
    freq.put("زائ", 21);
    freq.put("زاب", 10);
    freq.put("زات", 22);
    freq.put(" 💯", 18);
    freq.put("زاج", 18);
    freq.put(" 💫", 11);
    freq.put("اضي", 130);
    freq.put("ندي", 123);
    freq.put("اضـ", 13);
    freq.put("اضف", 55);
    freq.put("اضل", 13);
    freq.put("دث ", 78);
    freq.put("عضه", 16);
    freq.put("يگ ", 15);
    freq.put("َدا", 11);
    freq.put("قق ", 34);
    freq.put("ّمُ", 10);
    freq.put("رت ", 235);
    freq.put("َدر", 17);
    freq.put("فہ", 23);
    freq.put("َدَ", 16);
    freq.put("َدُ", 14);
    freq.put("َدي", 27);
    freq.put("ته ", 543);
    freq.put(" 🔝", 10);
    freq.put("ضه ", 36);
    freq.put("يذه", 15);
    freq.put("ؤل ", 10);
    freq.put("َدِ", 13);
    freq.put("َدّ", 12);
    freq.put("َدْ", 9);
    freq.put("ذل ", 26);
    freq.put(" 🔴", 17);
    freq.put("سُ ", 16);
    freq.put(" 🔲", 16);
    freq.put("اضح", 33);
    freq.put("اضا", 67);
    freq.put(" 🔺", 9);
    freq.put("اضغ", 9);
    freq.put("اضع", 16);
    freq.put("اضر", 23);
    freq.put("اق ", 310);
    freq.put("ف،", 11);
    freq.put("لظن", 22);
    freq.put("ريب", 128);
    freq.put("رية", 132);
    freq.put("فأ", 133);
    freq.put("فآ", 54);
    freq.put("فإ", 112);
    freq.put("فؤ", 9);
    freq.put("فا", 1158);
    freq.put("فئ", 25);
    freq.put("فة", 258);
    freq.put("فب", 25);
    freq.put("ريآ", 11);
    freq.put("فت", 755);
    freq.put("فح", 90);
    freq.put("فج", 117);
    freq.put("فد", 66);
    freq.put("فخ", 23);
    freq.put("فر", 1204);
    freq.put("فذ", 31);
    freq.put("فس", 619);
    freq.put("فز", 47);
    freq.put("فص", 41);
    freq.put("فش", 80);
    freq.put("فط", 55);
    freq.put("فض", 292);
    freq.put("فع", 421);
    freq.put("فظ", 162);
    freq.put("ريز", 16);
    freq.put("فغ", 14);
    freq.put("نا ", 2629);
    freq.put("ريض", 34);
    freq.put("ريط", 16);
    freq.put("فف", 51);
    freq.put("فـ", 241);
    freq.put("فك", 434);
    freq.put("فق", 674);
    freq.put("فم", 84);
    freq.put("فل", 597);
    freq.put("فه", 531);
    freq.put("فن", 283);
    freq.put("فى", 152);
    freq.put("فو", 964);
    freq.put("ريق", 180);
    freq.put("في", 4013);
    freq.put("ريم", 85);
    freq.put("فُ", 60);
    freq.put("فَ", 306);
    freq.put("فّ", 42);
    freq.put("فِ", 226);
    freq.put("فْ", 24);
    freq.put("ريّ", 15);
    freq.put("ٱ", 129);
    freq.put("لـد", 11);
    freq.put("ُست", 13);
    freq.put("آج ", 10);
    freq.put("شعب", 52);
    freq.put("شعا", 27);
    freq.put("يَ ", 225);
    freq.put("لقح", 10);
    freq.put("يها", 352);
    freq.put("شعر", 135);
    freq.put("ياو", 12);
    freq.put("لـح", 12);
    freq.put("غرد", 103);
    freq.put("غرب", 82);
    freq.put("كـ ", 33);
    freq.put("غرا", 49);
    freq.put("إذ ", 11);
    freq.put("🇸", 20);
    freq.put("غري", 196);
    freq.put("غرو", 19);
    freq.put("🇪", 22);
    freq.put("ﻟ", 303);
    freq.put("غرف", 23);
    freq.put("شعُ", 12);
    freq.put("شعو", 62);
    freq.put("بگ ", 13);
    freq.put(" ⃣ ", 24);
    freq.put("شه ", 38);
    freq.put("حلي", 52);
    freq.put("حلو", 121);
    freq.put("حلى", 44);
    freq.put("جزا", 56);
    freq.put("حلق", 27);
    freq.put("حلف", 19);
    freq.put("حله", 21);
    freq.put("حلل", 17);
    freq.put("حلم", 69);
    freq.put("لا ", 3177);
    freq.put("ذر", 135);
    freq.put("َن ", 100);
    freq.put("ذآ", 60);
    freq.put("يهـ", 10);
    freq.put("وك ", 156);
    freq.put("ذا", 1548);
    freq.put("ذت", 19);
    freq.put("ذب", 165);
    freq.put("ذة", 31);
    freq.put("ذِ", 59);
    freq.put("ذّ", 24);
    freq.put("لـب", 13);
    freq.put("🅾", 17);
    freq.put("لدو", 122);
    freq.put("ُ", 3826);
    freq.put("ذك", 438);
    freq.put("ذف", 18);
    freq.put("ذن", 218);
    freq.put("ذه", 269);
    freq.put("ذل", 233);
    freq.put("ذم", 29);
    freq.put("ذي", 531);
    freq.put("ذو", 101);
    freq.put("ذى", 18);
    freq.put("ذَ", 33);
    freq.put("ذُ", 20);
    freq.put("حلب", 12);
    freq.put("حلة", 20);
    freq.put("جزي", 25);
    freq.put("حلا", 105);
    freq.put("عد ", 571);
    freq.put("كوب", 11);
    freq.put("وب ", 377);
    freq.put(" ⭕ ", 19);
    freq.put("ـيّ", 10);
    freq.put("،ا", 53);
    freq.put("لدف", 18);
    freq.put("،أ", 9);
    freq.put("طت ", 19);
    freq.put("راً", 222);
    freq.put("راي", 67);
    freq.put("راو", 24);
    freq.put("راه", 101);
    freq.put("ران", 163);
    freq.put("رام", 149);
    freq.put("رال", 128);
    freq.put(" ̵ ", 9);
    freq.put("راق", 163);
    freq.put("راف", 77);
    freq.put("تب ", 183);
    freq.put("〰", 81);
    freq.put("،،", 327);
    freq.put("ينس", 28);
    freq.put("لعظ", 116);
    freq.put("،ل", 11);
    freq.put("راغ", 18);
    freq.put("راع", 44);
    freq.put("،ف", 14);
    freq.put("راض", 55);
    freq.put("راش", 25);
    freq.put("،ي", 12);
    freq.put("راز", 19);
    freq.put("،و", 59);
    freq.put("راد", 72);
    freq.put("راح", 239);
    freq.put("راج", 80);
    freq.put("رات", 302);
    freq.put("راة", 16);
    freq.put("ﻨ", 66);
    freq.put("راا", 24);
    freq.put("رائ", 85);
    freq.put("ِم ", 23);
    freq.put("راء", 116);
    freq.put("نىَ", 9);
    freq.put("ئلة", 19);
    freq.put("ئلت", 14);
    freq.put("فع ", 137);
    freq.put("يذا", 17);
    freq.put("خمس", 28);
    freq.put("إ", 3653);
    freq.put("يام", 235);
    freq.put(" شِ", 10);
    freq.put(" شُ", 14);
    freq.put(" شَ", 53);
    freq.put(" شي", 574);
    freq.put(" شو", 179);
    freq.put(" شه", 72);
    freq.put(" شن", 31);
    freq.put(" شم", 53);
    freq.put("ں", 20);
    freq.put(" شك", 165);
    freq.put(" شق", 25);
    freq.put(" شف", 132);
    freq.put(" شـ", 33);
    freq.put(" شغ", 13);
    freq.put(" شع", 123);
    freq.put(" شط", 9);
    freq.put(" شر", 199);
    freq.put(" شد", 29);
    freq.put(" شخ", 196);
    freq.put(" شج", 15);
    freq.put(" شت", 14);
    freq.put(" شب", 64);
    freq.put(" شا", 270);
    freq.put(" شئ", 52);
    freq.put("كوُ", 10);
    freq.put(" شأ", 10);
    freq.put("لعص", 34);
    freq.put("شيء", 276);
    freq.put("خمي", 12);
    freq.put("ئله", 20);
    freq.put("ينص", 17);
    freq.put("عصر", 18);
    freq.put(" ̵̵", 17);
    freq.put("صّ", 45);
    freq.put("صِ", 31);
    freq.put("صْ", 17);
    freq.put("صُ", 28);
    freq.put("صَ", 141);
    freq.put("صى", 12);
    freq.put("صو", 579);
    freq.put("صي", 560);
    freq.put("صم", 160);
    freq.put("صل", 753);
    freq.put("صه", 51);
    freq.put("صن", 107);
    freq.put("صف", 251);
    freq.put("صـ", 63);
    freq.put("صك", 13);
    freq.put("صق", 11);
    freq.put("موض", 24);
    freq.put("َع ", 22);
    freq.put("موس", 49);
    freq.put("مور", 64);
    freq.put("ذنب", 55);
    freq.put("حشر", 12);
    freq.put("آتي", 17);
    freq.put("حشش", 21);
    freq.put("موع", 69);
    freq.put("موا", 211);
    freq.put(" ﷽ ", 28);
    freq.put("ظ", 1503);
    freq.put("موج", 37);
    freq.put("موح", 17);
    freq.put("موت", 173);
    freq.put("🚩ا", 10);
    freq.put("نِس", 12);
    freq.put("لقو", 57);
    freq.put("ذة ", 30);
    freq.put("ذنو", 49);
    freq.put("ذني", 27);
    freq.put("مون", 161);
    freq.put("موه", 20);
    freq.put("مول", 36);
    freq.put("موم", 49);
    freq.put("موق", 46);
    freq.put("موك", 10);
    freq.put("موي", 17);
    freq.put("حشه", 9);
    freq.put("موو", 10);
    freq.put("حن ", 95);
    freq.put("صع", 90);
    freq.put("صغ", 87);
    freq.put("صص", 41);
    freq.put("نِع", 9);
    freq.put("صط", 21);
    freq.put("لقَ", 13);
    freq.put("صر", 536);
    freq.put("كَث", 12);
    freq.put("صح", 337);
    freq.put("صج", 9);
    freq.put("صد", 574);
    freq.put("صخ", 15);
    freq.put("صة", 74);
    freq.put("صب", 725);
    freq.put("از ", 53);
    freq.put("صت", 73);
    freq.put("صا", 693);
    freq.put("لإل", 16);
    freq.put("🏉", 22);
    freq.put("🌷", 10);
    freq.put("🌿", 9);
    freq.put("🌺", 30);
    freq.put("🌸", 10);
    freq.put("🌹", 156);
    freq.put("شفن", 13);
    freq.put("لإم", 30);
    freq.put("شفى", 9);
    freq.put("شفي", 33);
    freq.put("همّ", 28);
    freq.put("نِك", 10);
    freq.put("🌟", 35);
    freq.put("يعن", 156);
    freq.put("يعه", 29);
    freq.put("يعل", 73);
    freq.put("يعم", 55);
    freq.put("رَ ", 43);
    freq.put("همن", 27);
    freq.put("🌀", 15);
    freq.put("همل", 11);
    freq.put("يعَ", 15);
    freq.put("يعُ", 15);
    freq.put("همو", 48);
    freq.put("يعي", 99);
    freq.put("همَ", 12);
    freq.put("يعو", 51);
    freq.put("همس", 14);
    freq.put("يعط", 29);
    freq.put("ـين", 17);
    freq.put("يعر", 62);
    freq.put("يعا", 62);
    freq.put("🍤", 9);
    freq.put("🍥", 9);
    freq.put("هما", 137);
    freq.put("يّ ", 279);
    freq.put("رهن", 10);
    freq.put("يعد", 15);
    freq.put("يعج", 20);
    freq.put("يعت", 40);
    freq.put("يعب", 9);
    freq.put("يعة", 28);
    freq.put("كَل", 18);
    freq.put("🍇", 10);
    freq.put("شفا", 37);
    freq.put(" ٺع", 11);
    freq.put("🍃", 56);
    freq.put("🍁", 16);
    freq.put("س ", 2232);
    freq.put("شفت", 104);
    freq.put("هم،", 13);
    freq.put("لاد", 68);
    freq.put("خه ", 17);
    freq.put("وتِ", 9);
    freq.put("ْمِ", 9);
    freq.put("وتم", 17);
    freq.put("وتل", 20);
    freq.put("وته", 45);
    freq.put("َّا", 12);
    freq.put("ْمَ", 16);
    freq.put("وتـ", 12);
    freq.put("وتك", 74);
    freq.put("وتق", 58);
    freq.put("وتُ", 20);
    freq.put("وتَ", 10);
    freq.put("وتو", 45);
    freq.put("وتي", 64);
    freq.put("ومش", 16);
    freq.put("َلب", 22);
    freq.put("ومر", 26);
    freq.put("ومس", 38);
    freq.put("كا ", 32);
    freq.put("ومع", 32);
    freq.put("َلا", 53);
    freq.put(" ﺑ ", 14);
    freq.put("وما", 284);
    freq.put("ومآ", 11);
    freq.put("ومح", 20);
    freq.put("ومد", 27);
    freq.put("ومب", 13);
    freq.put("ومة", 37);
    freq.put("ومت", 21);
    freq.put("ئن ", 26);
    freq.put("َلى", 39);
    freq.put("َلو", 12);
    freq.put("ثقہ", 9);
    freq.put("ومِ", 12);
    freq.put("َلُ", 13);
    freq.put("َلَ", 60);
    freq.put("َلك", 13);
    freq.put("َلم", 25);
    freq.put("ومل", 19);
    freq.put("⭐", 11);
    freq.put("ومن", 151);
    freq.put("ومه", 59);
    freq.put("ومـ", 21);
    freq.put("زل ", 89);
    freq.put("ومك", 26);
    freq.put("َلّ", 14);
    freq.put("َلِ", 21);
    freq.put("ومَ", 27);
    freq.put("َلْ", 19);
    freq.put("ومو", 38);
    freq.put("ومي", 190);
    freq.put("ومً", 10);
    freq.put("ظيم", 150);
    freq.put("وتش", 19);
    freq.put("وتط", 30);
    freq.put("ظيف", 16);
    freq.put("وتذ", 14);
    freq.put("وتس", 45);
    freq.put("وتع", 45);
    freq.put("ـنـ", 44);
    freq.put("وتغ", 18);
    freq.put("وتا", 33);
    freq.put("َّه", 36);
    freq.put("وتح", 42);
    freq.put("وتج", 18);
    freq.put("وتد", 9);
    freq.put("وتخ", 17);
    freq.put("وتب", 35);
    freq.put("عري", 55);
    freq.put("وتت", 28);
    freq.put("🈵", 9);
    freq.put("ِتَ", 9);
    freq.put("يِن", 9);
    freq.put("شيخ", 90);
    freq.put("بشك", 35);
    freq.put("ؤثر", 15);
    freq.put("رّة", 9);
    freq.put("بشي", 15);
    freq.put("بشو", 13);
    freq.put("لار", 64);
    freq.put("ِهِ", 15);
    freq.put("يہ ", 88);
    freq.put("بشا", 29);
    freq.put("ِها", 25);
    freq.put("بشد", 14);
    freq.put("تم ", 199);
    freq.put("بشر", 138);
    freq.put("سف ", 61);
    freq.put("صية", 24);
    freq.put("ﺇ", 12);
    freq.put("حنو", 12);
    freq.put("حني", 88);
    freq.put("حنُ", 16);
    freq.put("ازه", 16);
    freq.put("ازل", 36);
    freq.put("دكت", 21);
    freq.put("سہ", 13);
    freq.put("ازي", 37);
    freq.put("قهم", 26);
    freq.put("ذن ", 58);
    freq.put("ُو", 386);
    freq.put("قهو", 29);
    freq.put("مو ", 134);
    freq.put("جذب", 13);
    freq.put(" حد", 127);
    freq.put("آت ", 55);
    freq.put("ِد ", 23);
    freq.put("دكا", 12);
    freq.put("َأَ", 18);
    freq.put("َأن", 11);
    freq.put("حنا", 133);
    freq.put("ازع", 13);
    freq.put("ازا", 50);
    freq.put("قلع", 14);
    freq.put("ص ", 569);
    freq.put("ازة", 11);
    freq.put("لأي", 50);
    freq.put("سْ", 72);
    freq.put("سّ", 121);
    freq.put("سِ", 81);
    freq.put("سي", 1142);
    freq.put("سى", 156);
    freq.put("سو", 1076);
    freq.put("سُ", 95);
    freq.put("سَ", 312);
    freq.put("سٍ", 10);
    freq.put("سٌ", 11);
    freq.put("سك", 477);
    freq.put("سق", 84);
    freq.put("سف", 167);
    freq.put("سـ", 144);
    freq.put("سه", 439);
    freq.put("سن", 560);
    freq.put("سم", 891);
    freq.put("سل", 852);
    freq.put("〰?", 32);
    freq.put("لئ ", 20);
    freq.put("رَا", 38);
    freq.put("رَج", 9);
    freq.put("رَح", 19);
    freq.put("رَب", 41);
    freq.put("رَة", 9);
    freq.put("إ ", 34);
    freq.put("دخو", 30);
    freq.put("جول", 24);
    freq.put("يع ", 384);
    freq.put("س،", 11);
    freq.put("سع", 662);
    freq.put("سس", 107);
    freq.put("سر", 547);
    freq.put("سط", 143);
    freq.put("ست", 1811);
    freq.put("سة", 115);
    freq.put("سب", 752);
    freq.put("سد", 138);
    freq.put("سخ", 56);
    freq.put("سح", 118);
    freq.put("سج", 126);
    freq.put("سأ", 270);
    freq.put("سآ", 68);
    freq.put("سا", 1562);
    freq.put("سئ", 50);
    freq.put("سؤ", 96);
    freq.put("سيّ", 15);
    freq.put("ظي ", 11);
    freq.put("رج ", 110);
    freq.put("ضاف", 81);
    freq.put("شن ", 16);
    freq.put("قوت", 9);
    freq.put("َّ ", 43);
    freq.put("كاب", 22);
    freq.put("كات", 86);
    freq.put("كاد", 13);
    freq.put("ٱ ", 25);
    freq.put("كاء", 39);
    freq.put("َل ", 75);
    freq.put("سيو", 14);
    freq.put("كاا", 17);
    freq.put("كائ", 11);
    freq.put(" زم", 62);
    freq.put(" زل", 19);
    freq.put(" زه", 14);
    freq.put(" زف", 12);
    freq.put("ئنا", 30);
    freq.put("كاذ", 16);
    freq.put("كاس", 31);
    freq.put(" زَ", 11);
    freq.put(" زو", 75);
    freq.put(" زي", 134);
    freq.put("كاو", 12);
    freq.put("كاي", 30);
    freq.put(" زر", 12);
    freq.put("كاف", 40);
    freq.put(" زع", 38);
    freq.put("كال", 88);
    freq.put("كان", 573);
    freq.put("سيق", 18);
    freq.put(" زا", 61);
    freq.put("سيك", 27);
    freq.put(" زح", 15);
    freq.put("زلة", 14);
    freq.put(" زب", 19);
    freq.put("زلت", 33);
    freq.put("٢", 70);
    freq.put("سين", 95);
    freq.put("سيه", 26);
    freq.put("سيل", 31);
    freq.put("سيم", 17);
    freq.put("بغ", 141);
    freq.put("سفه", 11);
    freq.put("سفل", 14);
    freq.put("عقب", 26);
    freq.put("سيع", 12);
    freq.put("قبا", 35);
    freq.put("عقد", 21);
    freq.put("عقا", 9);
    freq.put("قلك", 14);
    freq.put("رّ ", 32);
    freq.put("وقف", 83);
    freq.put("ضمن", 18);
    freq.put("بز", 27);
    freq.put("تمن", 158);
    freq.put("تمه", 13);
    freq.put("تمل", 41);
    freq.put("سيس", 11);
    freq.put("تمي", 41);
    freq.put("تمو", 36);
    freq.put("قـت", 9);
    freq.put("ضمي", 30);
    freq.put("قـد", 9);
    freq.put("تمس", 28);
    freq.put("تمر", 103);
    freq.put("تمش", 19);
    freq.put("تمع", 57);
    freq.put("سيط", 27);
    freq.put("يہَ", 9);
    freq.put("ضما", 9);
    freq.put("تما", 108);
    freq.put("تمت", 42);
    freq.put("تمث", 12);
    freq.put("جوب", 11);
    freq.put("تمد", 27);
    freq.put("تمح", 9);
    freq.put("سيت", 61);
    freq.put("سفة", 9);
    freq.put(" ̷ ", 24);
    freq.put("سيب", 11);
    freq.put("عقو", 45);
    freq.put("عقي", 14);
    freq.put("ﻲ", 70);
    freq.put("سفر", 28);
    freq.put("قبض", 15);
    freq.put("عقل", 86);
    freq.put("جوز", 39);
    freq.put("يَس", 16);
    freq.put("يَر", 9);
    freq.put("بج", 96);
    freq.put("يَع", 21);
    freq.put("سيح", 13);
    freq.put("ناص", 35);
    freq.put("يَا", 71);
    freq.put("بأ", 237);
    freq.put("شهي", 25);
    freq.put("يَت", 9);
    freq.put("شهو", 24);
    freq.put("يَب", 11);
    freq.put("يَد", 10);
    freq.put("يَخ", 10);
    freq.put("يَح", 11);
    freq.put("يَج", 10);
    freq.put("سيئ", 32);
    freq.put("سيا", 141);
    freq.put("عُر", 9);
    freq.put("إذا", 306);
    freq.put("إذآ", 10);
    freq.put("غر ", 28);
    freq.put("كـا", 12);
    freq.put("ـہ ", 20);
    freq.put("زء ", 22);
    freq.put("إذن", 34);
    freq.put("ﻛ", 31);
    freq.put("كـل", 23);
    freq.put("كـن", 16);
    freq.put("شهر", 60);
    freq.put(" حك", 99);
    freq.put("يَك", 15);
    freq.put("يَق", 9);
    freq.put("قلو", 168);
    freq.put("شها", 62);
    freq.put("يَم", 10);
    freq.put("يَل", 9);
    freq.put("يَو", 25);
    freq.put("دكك", 11);
    freq.put("ْهِ", 12);
    freq.put("جز ", 38);
    freq.put("َء ", 9);
    freq.put("وبِ", 10);
    freq.put("ظوا", 12);
    freq.put("عدي", 83);
    freq.put("عدو", 70);
    freq.put("عده", 94);
    freq.put(" حو", 77);
    freq.put("عدم", 51);
    freq.put("عدل", 31);
    freq.put("عدك", 53);
    freq.put("وبك", 74);
    freq.put("وبـ", 13);
    freq.put("وبه", 52);
    freq.put("ّوا", 14);
    freq.put("وبل", 10);
    freq.put(" ⭕ل", 34);
    freq.put("وبي", 84);
    freq.put("ظوظ", 17);
    freq.put("وبَ", 12);
    freq.put("َنا", 14);
    freq.put("لاأ", 9);
    freq.put("وكذ", 13);
    freq.put("لاء", 50);
    freq.put("لائ", 20);
    freq.put("لاا", 103);
    freq.put("لات", 446);
    freq.put("لاث", 121);
    freq.put("لاب", 167);
    freq.put("لاة", 108);
    freq.put("لاخ", 176);
    freq.put("َنت", 13);
    freq.put("قلي", 122);
    freq.put("لاح", 131);
    freq.put("لاز", 57);
    freq.put("وكأ", 14);
    freq.put("ذ ", 242);
    freq.put("═══", 12);
    freq.put("لاض", 13);
    freq.put("وكا", 42);
    freq.put("لاش", 79);
    freq.put("لاص", 92);
    freq.put("لاغ", 22);
    freq.put("وكب", 10);
    freq.put("لاع", 135);
    freq.put("لاق", 175);
    freq.put("لاك", 75);
    freq.put("لاف", 72);
    freq.put("لان", 374);
    freq.put("لاه", 83);
    freq.put("لال", 207);
    freq.put("لام", 661);
    freq.put("لاي", 198);
    freq.put("َنَ", 16);
    freq.put("ً", 1815);
    freq.put("لاَ", 69);
    freq.put("َني", 24);
    freq.put("لاّ", 21);
    freq.put("وكن", 16);
    freq.put("َنْ", 46);
    freq.put("َنّ", 14);
    freq.put("َنِ", 17);
    freq.put("وكي", 65);
    freq.put("عدد", 117);
    freq.put("وبر", 36);
    freq.put("عدت", 26);
    freq.put("عدة", 25);
    freq.put("عدا", 67);
    freq.put("حل ", 123);
    freq.put(" ̷̷", 98);
    freq.put("ّون", 9);
    freq.put("وبت", 18);
    freq.put("وبة", 37);
    freq.put("وبد", 14);
    freq.put("وبح", 54);
    freq.put("💕 ", 14);
    freq.put("، ", 2721);
    freq.put("ثُ ", 19);
    freq.put("ُبك", 19);
    freq.put("ِمَ", 13);
    freq.put("ِمُ", 9);
    freq.put("نج ", 20);
    freq.put("ِمن", 13);
    freq.put("ُبّ", 9);
    freq.put("ُبْ", 19);
    freq.put("تبآ", 10);
    freq.put("طيو", 16);
    freq.put("تبا", 231);
    freq.put("تبت", 43);
    freq.put("تبد", 36);
    freq.put("ضين", 9);
    freq.put("تبر", 71);
    freq.put("تبس", 10);
    freq.put("تبط", 12);
    freq.put("طيه", 25);
    freq.put("تبع", 58);
    freq.put("̸", 33);
    freq.put("تبغ", 14);
    freq.put("رٌ ", 27);
    freq.put("تبك", 33);
    freq.put("تبق", 64);
    freq.put("تبل", 20);
    freq.put("تبه", 43);
    freq.put("تبن", 17);
    freq.put("تبو", 27);
    freq.put("تبي", 104);
    freq.put("طيك", 28);
    freq.put("طيـ", 10);
    freq.put("طيف", 21);
    freq.put("ﻷن", 10);
    freq.put("ُبت", 9);
    freq.put("ُبا", 21);
    freq.put("توس", 24);
    freq.put("ِما", 17);
    freq.put("را ", 272);
    freq.put("ئل ", 53);
    freq.put("فعت", 9);
    freq.put("فعا", 28);
    freq.put("توض", 9);
    freq.put("ں ", 10);
    freq.put("افه", 75);
    freq.put("ء", 2409);
    freq.put("سرا", 68);
    freq.put(" ر", 2872);
    freq.put("لعه", 21);
    freq.put("طيّ", 9);
    freq.put("شرح", 39);
    freq.put("غسل", 15);
    freq.put("زق ", 22);
    freq.put("فعو", 12);
    freq.put("فعي", 13);
    freq.put("فعل", 148);
    freq.put("فعه", 21);
    freq.put("فعك", 11);
    freq.put("م؟ ", 13);
    freq.put("عب ", 239);
    freq.put("ِّ ", 17);
    freq.put("تهت", 23);
    freq.put("وط ", 39);
    freq.put("دا ", 226);
    freq.put("يطا", 67);
    freq.put("وخل", 26);
    freq.put("ْفَ", 10);
    freq.put("يصب", 31);
    freq.put("وخي", 18);
    freq.put("يصد", 20);
    freq.put("اتح", 135);
    freq.put("ز ", 457);
    freq.put("ْفِ", 20);
    freq.put("قَ ", 29);
    freq.put("يصن", 11);
    freq.put("يصل", 62);
    freq.put("يصي", 47);
    freq.put("ينه", 164);
    freq.put("يصو", 13);
    freq.put("ينن", 22);
    freq.put("وخر", 9);
    freq.put("تك ", 659);
    freq.put("ينم", 57);
    freq.put(" ?", 579);
    freq.put("سك ", 184);
    freq.put("ةً ", 58);
    freq.put("معن", 111);
    freq.put("اَ ", 94);
    freq.put("ينْ", 21);
    freq.put("ـب ", 52);
    freq.put("ينّ", 24);
    freq.put("ينِ", 9);
    freq.put("يتذ", 13);
    freq.put("لْم", 11);
    freq.put("ببه", 10);
    freq.put("ببن", 10);
    freq.put("من ", 3702);
    freq.put("ببي", 10);
    freq.put("تآج", 9);
    freq.put("ببر", 10);
    freq.put("?🍃", 14);
    freq.put("آب ", 28);
    freq.put(" ©", 42);
    freq.put("ببا", 12);
    freq.put("ببت", 31);
    freq.put(" ¸", 10);
    freq.put("ببب", 33);
    freq.put("بْح", 17);
    freq.put("هُم", 135);
    freq.put("?🍥", 9);
    freq.put("ؤال", 78);
    freq.put("بى ", 52);
    freq.put("نسى", 66);
    freq.put("كل ", 1106);
    freq.put("فكن", 10);
    freq.put("فكم", 11);
    freq.put("فكل", 10);
    freq.put("فكي", 45);
    freq.put("فكِ", 9);
    freq.put("يي ", 46);
    freq.put("نُو", 22);
    freq.put("زحم", 13);
    freq.put("اتف", 57);
    freq.put("هُن", 33);
    freq.put("سير", 99);
    freq.put("هه?", 9);
    freq.put("طيح", 20);
    freq.put("هه ", 360);
    freq.put("يط ", 33);
    freq.put("ضـف", 10);
    freq.put("ححح", 17);
    freq.put("فكا", 31);
    freq.put("افع", 57);
    freq.put("تون", 59);
    freq.put("فكر", 102);
    freq.put("مرت", 68);
    freq.put("توو", 10);
    freq.put("مرح", 38);
    freq.put("شك ", 36);
    freq.put("رف ", 334);
    freq.put("مرد", 11);
    freq.put("قفت", 10);
    freq.put("حـل", 10);
    freq.put("حــ", 56);
    freq.put("مرأ", 60);
    freq.put("مرآ", 11);
    freq.put("لأ ", 24);
    freq.put("عى", 27);
    freq.put("وه ", 196);
    freq.put("يلة", 108);
    freq.put("سرك", 10);
    freq.put("فرض", 11);
    freq.put("اظر", 16);
    freq.put("حـس", 10);
    freq.put("سرن", 9);
    freq.put("حـا", 19);
    freq.put("حـد", 13);
    freq.put("زاد", 23);
    freq.put("حـب", 16);
    freq.put("وج ", 43);
    freq.put("ﺃ", 51);
    freq.put("عنہ", 9);
    freq.put("ئيس", 44);
    freq.put(" ١٠", 19);
    freq.put("ككِ", 10);
    freq.put("سية", 42);
    freq.put("صَل", 24);
    freq.put("صَم", 15);
    freq.put("صَو", 13);
    freq.put("لہ ", 140);
    freq.put("بض ", 34);
    freq.put("ו", 16);
    freq.put("صَا", 10);
    freq.put("صَب", 22);
    freq.put("صَد", 16);
    freq.put("?🇪", 11);
    freq.put("سيد", 49);
    freq.put("ئيل", 21);
    freq.put("ينآ", 24);
    freq.put("?🇸", 20);
    freq.put("يلا", 147);
    freq.put("لـم", 35);
    freq.put("عنه", 114);
    freq.put("عنـ", 13);
    freq.put("عنف", 10);
    freq.put("سمّ", 10);
    freq.put("عنك", 70);
    freq.put("ينا", 365);
    freq.put("كُن", 47);
    freq.put("عنو", 24);
    freq.put("عنى", 57);
    freq.put("عني", 340);
    freq.put("سمه", 53);
    freq.put("سمن", 11);
    freq.put("َات", 38);
    freq.put("عنِ", 9);
    freq.put("عنّ", 18);
    freq.put("كُو", 23);
    freq.put("سمُ", 9);
    freq.put("صعب", 68);
    freq.put("سمي", 96);
    freq.put("سمى", 10);
    freq.put("سمو", 40);
    freq.put("أوف", 9);
    freq.put("أوق", 18);
    freq.put("أول", 129);
    freq.put(" ضا", 69);
    freq.put(" ضح", 47);
    freq.put(" ضد", 22);
    freq.put(" ضر", 39);
    freq.put("ينظ", 11);
    freq.put("تفي", 56);
    freq.put("تفو", 29);
    freq.put(" ضع", 53);
    freq.put("تفه", 23);
    freq.put(" ˘", 22);
    freq.put("تفق", 34);
    freq.put("تفك", 63);
    freq.put(" ضف", 9);
    freq.put("لحـ", 15);
    freq.put(" ضم", 50);
    freq.put(" ضل", 13);
    freq.put("تفع", 37);
    freq.put("تفض", 25);
    freq.put("تفش", 11);
    freq.put(" ضي", 133);
    freq.put("أوج", 22);
    freq.put("تفس", 21);
    freq.put("تفر", 45);
    freq.put("حَ ", 18);
    freq.put("ٓ", 117);
    freq.put("أوس", 10);
    freq.put("تفت", 49);
    freq.put("تفا", 112);
    freq.put("تفآ", 11);
    freq.put("ككَ", 22);
    freq.put("عنا", 134);
    freq.put("عنآ", 16);
    freq.put("منز", 32);
    freq.put("عند", 491);
    freq.put("سمع", 144);
    freq.put("سما", 149);
    freq.put("ّہ ", 30);
    freq.put("عنز", 9);
    freq.put("سمح", 33);
    freq.put("ينش", 13);
    freq.put("سمت", 17);
    freq.put("سمة", 15);
    freq.put("رّ", 135);
    freq.put("رِ", 101);
    freq.put("اوض", 9);
    freq.put("رْ", 52);
    freq.put("َا ", 256);
    freq.put("اور", 29);
    freq.put("اوز", 28);
    freq.put("ملت", 49);
    freq.put("ملة", 66);
    freq.put(" 🌺", 19);
    freq.put("رف", 804);
    freq.put("رك", 1057);
    freq.put("رق", 494);
    freq.put("رم", 361);
    freq.put("رل", 34);
    freq.put("ره", 1187);
    freq.put("رن", 364);
    freq.put("رى", 314);
    freq.put("رو", 1322);
    freq.put("رً", 66);
    freq.put("ري", 3433);
    freq.put("رٍ", 19);
    freq.put("اوة", 21);
    freq.put("رُ", 164);
    freq.put("رَ", 245);
    freq.put("ذيب", 18);
    freq.put("سبع", 16);
    freq.put("رٺ", 9);
    freq.put("فرو", 61);
    freq.put("سبا", 63);
    freq.put("سبب", 107);
    freq.put("سبة", 34);
    freq.put("سبت", 19);
    freq.put("ـول", 36);
    freq.put("سبح", 169);
    freq.put("ﺂل", 31);
    freq.put("ﺂن", 10);
    freq.put("ذين", 96);
    freq.put("ر؟", 11);
    freq.put("ﻞ ", 26);
    freq.put("سبق", 25);
    freq.put(" ̶", 54);
    freq.put(" ̷", 137);
    freq.put(" ̴", 10);
    freq.put(" ̵", 28);
    freq.put("سبو", 70);
    freq.put(" ̸", 23);
    freq.put("ر،", 53);
    freq.put("رر", 207);
    freq.put("ملك", 216);
    freq.put("رس", 538);
    freq.put("رز", 170);
    freq.put("رص", 119);
    freq.put("رش", 129);
    freq.put("رط", 63);
    freq.put("حذف", 11);
    freq.put("رع", 264);
    freq.put("ملو", 56);
    freq.put("رغ", 110);
    freq.put("حق ", 174);
    freq.put("مي ", 526);
    freq.put("رء", 11);
    freq.put("اوم", 20);
    freq.put("رأ", 259);
    freq.put("رآ", 193);
    freq.put("رؤ", 39);
    freq.put("را", 2871);
    freq.put("اوك", 13);
    freq.put("رة", 945);
    freq.put("رب", 1574);
    freq.put("رث", 30);
    freq.put("رت", 1048);
    freq.put("رح", 900);
    freq.put("رج", 702);
    freq.put("رد", 582);
    freq.put("رخ", 54);
    freq.put("يوف", 63);
    freq.put("هٌ ", 14);
    freq.put("يوق", 11);
    freq.put("يوم", 684);
    freq.put("يول", 26);
    freq.put("يوه", 17);
    freq.put("يون", 284);
    freq.put("يوو", 19);
    freq.put("يوي", 14);
    freq.put("َت", 151);
    freq.put("ئاس", 9);
    freq.put("لِم", 32);
    freq.put("لِل", 25);
    freq.put("لِك", 21);
    freq.put("لِق", 16);
    freq.put("ئات", 16);
    freq.put("لِـ", 12);
    freq.put("لِي", 42);
    freq.put("ءَ ", 23);
    freq.put("ة", 7992);
    freq.put("غبا", 27);
    freq.put("ن، ", 44);
    freq.put("غبت", 19);
    freq.put("ﻵ ", 15);
    freq.put("ھ", 269);
    freq.put("ّد ", 30);
    freq.put("يسا", 45);
    freq.put("غبي", 16);
    freq.put("مرك", 71);
    freq.put("كنَ", 10);
    freq.put("َظ", 26);
    freq.put("كني", 41);
    freq.put("يوا", 48);
    freq.put("كنن", 28);
    freq.put("يوب", 42);
    freq.put("يوت", 39);
    freq.put("يوج", 42);
    freq.put("رھ", 12);
    freq.put("يور", 23);
    freq.put("يوس", 18);
    freq.put("يوز", 11);
    freq.put("يوص", 15);
    freq.put("مره", 114);
    freq.put("ئاً", 52);
    freq.put("رک", 10);
    freq.put("مرن", 19);
    freq.put("لِت", 9);
    freq.put("رگ", 12);
    freq.put("كنّ", 12);
    freq.put("يسب", 19);
    freq.put("¸ ", 11);
    freq.put("ئي ", 85);
    freq.put(" ﻣن", 15);
    freq.put("لخا", 86);
    freq.put("ويض", 11);
    freq.put("ُؤل", 12);
    freq.put("لہم", 9);
    freq.put("لہَ", 14);
    freq.put("لہُ", 17);
    freq.put("كت ", 69);
    freq.put("هآ ", 99);
    freq.put("ويع", 27);
    freq.put("صَ ", 13);
    freq.put("ﻗ", 37);
    freq.put(" ١ ", 19);
    freq.put("لخط", 62);
    freq.put("يَن", 14);
    freq.put("يسل", 26);
    freq.put("يسم", 43);
    freq.put("ويح", 34);
    freq.put("🙏?", 26);
    freq.put("ورب", 39);
    freq.put("يسق", 15);
    freq.put("عضا", 9);
    freq.put("قٌ ", 9);
    freq.put("أو ", 154);
    freq.put("عات", 91);
    freq.put("تف ", 16);
    freq.put("عن ", 596);
    freq.put("دء ", 10);
    freq.put("سم ", 214);
    freq.put("َائ", 22);
    freq.put("حقو", 25);
    freq.put("َاء", 47);
    freq.put("حقي", 149);
    freq.put("زيا", 184);
    freq.put("َاح", 23);
    freq.put("حقن", 11);
    freq.put("حقه", 17);
    freq.put("َاب", 23);
    freq.put("حقق", 49);
    freq.put("حقك", 14);
    freq.put("نة ", 356);
    freq.put("او ", 107);
    freq.put("َار", 46);
    freq.put("َاس", 14);
    freq.put("ـت ", 93);
    freq.put("ضى ", 70);
    freq.put("ﺂ ", 15);
    freq.put("ﺭ", 41);
    freq.put("ذي ", 345);
    freq.put("سب ", 87);
    freq.put("═", 28);
    freq.put("َال", 103);
    freq.put("َام", 32);
    freq.put("َان", 86);
    freq.put("حقد", 10);
    freq.put("َاف", 18);
    freq.put("َاق", 9);
    freq.put("َاك", 18);
    freq.put("حقا", 47);
    freq.put("ر ", 7096);
    freq.put("يذ ", 11);
    freq.put("كن ", 513);
    freq.put("رته", 90);
    freq.put("ئا ", 24);
    freq.put("عِش", 11);
    freq.put("ۃ ", 14);
    freq.put("غب ", 11);
    freq.put(" ו", 14);
    freq.put("شرت", 16);
    freq.put("ريت", 320);
    freq.put("ريج", 16);
    freq.put("ريح", 77);
    freq.put("يو ", 76);
    freq.put("ريخ", 44);
    freq.put("ريد", 348);
    freq.put("لِ ", 98);
    freq.put("نعا", 26);
    freq.put(" ٢", 54);
    freq.put(" ٣", 48);
    freq.put(" ٠", 22);
    freq.put(" ١", 72);
    freq.put("داع", 39);
    freq.put(" ٧", 10);
    freq.put(" ٤", 22);
    freq.put(" ٥", 19);
    freq.put("عـي", 11);
    freq.put("شلا", 12);
    freq.put(" ٩", 10);
    freq.put("دار", 105);
    freq.put("هدد", 9);
    freq.put("داد", 74);
    freq.put("داخ", 105);
    freq.put("داب", 11);
    freq.put("داث", 13);
    freq.put("دات", 49);
    freq.put(" ٺ", 62);
    freq.put("داا", 20);
    freq.put("دائ", 103);
    freq.put("داء", 73);
    freq.put(" ق", 3008);
    freq.put(" ك", 4057);
    freq.put(" ـ", 56);
    freq.put(" ف", 6726);
    freq.put(" ن", 2833);
    freq.put("زر", 70);
    freq.put("زز", 10);
    freq.put(" م", 13575);
    freq.put(" ي", 8465);
    freq.put(" ً", 30);
    freq.put(" و", 13641);
    freq.put(" َ", 9);
    freq.put("زع", 149);
    freq.put(" ٍ", 9);
    freq.put("تكل", 94);
    freq.put("تكم", 113);
    freq.put("تكن", 40);
    freq.put("زا", 450);
    freq.put("تكـ", 17);
    freq.put("زء", 28);
    freq.put("زآ", 20);
    freq.put("تكك", 20);
    freq.put("زج", 12);
    freq.put("زح", 43);
    freq.put("تكَ", 14);
    freq.put("زد", 31);
    freq.put("زب", 116);
    freq.put("زة", 64);
    freq.put("زت", 37);
    freq.put(" آ", 1532);
    freq.put(" أ", 7245);
    freq.put(" ء", 13);
    freq.put("زِ", 14);
    freq.put(" ا", 32314);
    freq.put(" ؤ", 34);
    freq.put(" إ", 2597);
    freq.put(" ت", 7279);
    freq.put(" ث", 518);
    freq.put(" ب", 8472);
    freq.put(" ة", 10);
    freq.put(" خ", 1576);
    freq.put(" د", 1491);
    freq.put(" ج", 1923);
    freq.put(" ح", 3383);
    freq.put("زل", 214);
    freq.put("زم", 294);
    freq.put("زن", 241);
    freq.put("زه", 106);
    freq.put(" ض", 476);
    freq.put("زف", 28);
    freq.put("زق", 124);
    freq.put("زك", 28);
    freq.put(" غ", 1020);
    freq.put("زَ", 28);
    freq.put("زُ", 12);
    freq.put("تكب", 27);
    freq.put("زى", 9);
    freq.put("زي", 762);
    freq.put("قَل", 30);
    freq.put("ريس", 26);
    freq.put("عـا", 13);
    freq.put("سكت", 30);
    freq.put("سكا", 26);
    freq.put("عـد", 13);
    freq.put(" ،", 2059);
    freq.put("عـر", 11);
    freq.put("داو", 34);
    freq.put("داً", 199);
    freq.put("داي", 82);
    freq.put("تك،", 13);
    freq.put("دال", 147);
    freq.put("داه", 26);
    freq.put("دان", 136);
    freq.put("داف", 46);
    freq.put(" ؟", 552);
    freq.put("داك", 23);
    freq.put("داق", 21);
    freq.put("ريو", 11);
    freq.put("لخَ", 12);
    freq.put("منّ", 44);
    freq.put("ريي", 18);
    freq.put("نثر", 9);
    freq.put("منظ", 12);
    freq.put("منع", 33);
    freq.put("آبي", 13);
    freq.put(" ۆ", 80);
    freq.put("ريَ", 15);
    freq.put("̩", 39);
    freq.put(" ۈ", 116);
    freq.put("منس", 19);
    freq.put("ذوا", 11);
    freq.put("منص", 13);
    freq.put("منط", 29);
    freq.put("ريـ", 33);
    freq.put("منت", 55);
    freq.put("حزب", 66);
    freq.put("منح", 25);
    freq.put("ريف", 59);
    freq.put("ويف", 16);
    freq.put("ذور", 12);
    freq.put("حزا", 26);
    freq.put(" ۞", 20);
    freq.put("منا", 232);
    freq.put("آبت", 9);
    freq.put("منِ", 10);
    freq.put("شله", 10);
    freq.put("منْ", 33);
    freq.put(" گ", 63);
    freq.put("منو", 72);
    freq.put(" ڳ", 9);
    freq.put("مني", 279);
    freq.put("بب ", 93);
    freq.put("رين", 302);
    freq.put("حزي", 33);
    freq.put("منـ", 17);
    freq.put("حزن", 136);
    freq.put("ريه", 58);
    freq.put(" ھ", 14);
    freq.put("منه", 220);
    freq.put("نثى", 59);
    freq.put("شة ", 30);
    freq.put("اَن", 10);
    freq.put("اَل", 19);
    freq.put("ـبـ", 35);
    freq.put("كلا", 168);
    freq.put("ييس", 9);
    freq.put("كلة", 23);
    freq.put("يير", 46);
    freq.put("شكي", 20);
    freq.put("شكو", 32);
    freq.put("شكل", 170);
    freq.put("", 11);
    freq.put("ظال", 33);
    freq.put("ظام", 44);
    freq.put("ظاف", 11);
    freq.put("يطو", 11);
    freq.put("يطي", 25);
    freq.put("تآ", 45);
    freq.put("ههَ", 29);
    freq.put("يطل", 61);
    freq.put("ظات", 20);
    freq.put("لإن", 87);
    freq.put("ﻓﻲ", 12);
    freq.put("يطة", 12);
    freq.put("زح ", 13);
    freq.put("هز", 64);
    freq.put("ظار", 37);
    freq.put("شتر", 46);
    freq.put("كلن", 36);
    freq.put("فك ", 153);
    freq.put("كلف", 10);
    freq.put("٦", 34);
    freq.put("►◄", 17);
    freq.put("كلو", 15);
    freq.put("عـن", 18);
    freq.put("شكر", 137);
    freq.put(" بو", 170);
    freq.put("ييي", 184);
    freq.put("ييه", 12);
    freq.put("شكا", 19);
    freq.put("ييل", 15);
    freq.put("ييك", 11);
    freq.put("ضات", 10);
    freq.put("فَر", 17);
    freq.put("شتع", 9);
    freq.put("قًا", 9);
    freq.put("وجي", 40);
    freq.put("ﺖ", 35);
    freq.put("وجه", 179);
    freq.put("وجن", 9);
    freq.put("وجم", 16);
    freq.put("وجل", 21);
    freq.put("لأخ", 87);
    freq.put("لأد", 27);
    freq.put("لأج", 61);
    freq.put("دلك", 10);
    freq.put("لأب", 68);
    freq.put(" به", 328);
    freq.put("وهذ", 22);
    freq.put("فَع", 13);
    freq.put("وهد", 9);
    freq.put("ههہ", 21);
    freq.put("لأع", 55);
    freq.put("وها", 80);
    freq.put("لأش", 75);
    freq.put("دله", 15);
    freq.put("لأز", 13);
    freq.put("لأس", 105);
    freq.put("لأذ", 21);
    freq.put("لأر", 108);
    freq.put("لأَ", 9);
    freq.put("اظ ", 12);
    freq.put("لأو", 78);
    freq.put("لأن", 258);
    freq.put("لأه", 30);
    freq.put("لأل", 52);
    freq.put("لأم", 201);
    freq.put("لأق", 39);
    freq.put("لأك", 18);
    freq.put("لأف", 39);
    freq.put("وهي", 54);
    freq.put("ع، ", 15);
    freq.put("وهن", 17);
    freq.put("وهل", 10);
    freq.put("وهم", 84);
    freq.put("وجع", 68);
    freq.put("وجز", 9);
    freq.put("وجر", 9);
    freq.put("وجد", 79);
    freq.put("وجت", 35);
    freq.put("وجة", 13);
    freq.put("وجب", 17);
    freq.put("وجا", 33);
    freq.put("نز ", 9);
    freq.put("ه؟", 39);
    freq.put("ـخـ", 9);
    freq.put("يلہ", 24);
    freq.put("ضيع", 41);
    freq.put("نحر", 15);
    freq.put("نحت", 26);
    freq.put("نحب", 25);
    freq.put("مـع", 10);
    freq.put("نحا", 21);
    freq.put("ه،", 107);
    freq.put("مـر", 9);
    freq.put("هض", 11);
    freq.put("هش", 19);
    freq.put("بُك", 24);
    freq.put("هر", 408);
    freq.put("هذ", 588);
    freq.put("گ", 324);
    freq.put("ها", 3381);
    freq.put("هؤ", 13);
    freq.put("هآ", 130);
    freq.put("هد", 497);
    freq.put("هخ", 9);
    freq.put("هج", 87);
    freq.put("🍁 ", 12);
    freq.put("هت", 167);
    freq.put("هة", 46);
    freq.put("هب", 142);
    freq.put("يتأ", 17);
    freq.put("ل", 73071);
    freq.put("هّ", 43);
    freq.put("هِ", 137);
    freq.put("ضاء", 46);
    freq.put("هه", 5201);
    freq.put("هن", 334);
    freq.put("هم", 2601);
    freq.put("هل", 740);
    freq.put("هك", 106);
    freq.put("هق", 29);
    freq.put("هف", 23);
    freq.put("هـ", 197);
    freq.put("هُ", 384);
    freq.put("هَ", 290);
    freq.put("سجن", 20);
    freq.put("هٌ", 23);
    freq.put("هً", 11);
    freq.put("هي", 714);
    freq.put("هى", 27);
    freq.put("هو", 946);
    freq.put("أنص", 17);
    freq.put("مـي", 16);
    freq.put("مـن", 42);
    freq.put("مـه", 10);
    freq.put("مـل", 9);
    freq.put("هدي", 96);
    freq.put("مــ", 86);
    freq.put("نحي", 10);
    freq.put("نحو", 23);
    freq.put("نحن", 93);
    freq.put("نحم", 12);
    freq.put("هده", 15);
    freq.put("أث", 52);
    freq.put("أت", 306);
    freq.put("أة", 76);
    freq.put("أب", 467);
    freq.put("أد", 148);
    freq.put("أخ", 430);
    freq.put("أح", 860);
    freq.put("أج", 322);
    freq.put("يلم", 18);
    freq.put("يله", 129);
    freq.put("يلف", 11);
    freq.put("أإ", 13);
    freq.put("يلق", 11);
    freq.put("أغ", 120);
    freq.put("أع", 426);
    freq.put("أظ", 19);
    freq.put("أس", 616);
    freq.put("أز", 46);
    freq.put("أر", 445);
    freq.put("أذ", 114);
    freq.put("أط", 93);
    freq.put("أض", 61);
    freq.put("أص", 253);
    freq.put("أش", 284);
    freq.put(" قم", 73);
    freq.put(" قل", 747);
    freq.put(" قه", 22);
    freq.put(" قن", 41);
    freq.put(" قف", 20);
    freq.put(" قـ", 32);
    freq.put("منك", 124);
    freq.put("مهه", 10);
    freq.put(" قُ", 50);
    freq.put(" قَ", 67);
    freq.put(" قو", 190);
    freq.put(" قي", 75);
    freq.put(" قِ", 14);
    freq.put(" قا", 563);
    freq.put(" قآ", 11);
    freq.put("هج ", 20);
    freq.put(" قد", 314);
    freq.put(" قب", 274);
    freq.put(" قت", 34);
    freq.put(" قص", 123);
    freq.put(" قط", 72);
    freq.put(" قض", 23);
    freq.put(" قر", 173);
    freq.put(" قذ", 10);
    freq.put(" قس", 42);
    freq.put(" قع", 9);
    freq.put("يلح", 15);
    freq.put("أي", 375);
    freq.put("أى", 16);
    freq.put("أو", 463);
    freq.put("أُ", 59);
    freq.put("أَ", 153);
    freq.put("يلت", 56);
    freq.put("أك", 432);
    freq.put("أق", 234);
    freq.put("أف", 200);
    freq.put("أه", 236);
    freq.put("أن", 2329);
    freq.put("أم", 790);
    freq.put("أل", 539);
    freq.put("ﻰ ", 19);
    freq.put("يلع", 16);
    freq.put("نتق", 43);
    freq.put("و ", 4110);
    freq.put("يلس", 9);
    freq.put("ير،", 15);
    freq.put("قي ", 260);
    freq.put("يرد", 38);
    freq.put("يرج", 37);
    freq.put("يرح", 48);
    freq.put("يرت", 63);
    freq.put("يرب", 9);
    freq.put("ـاه", 10);
    freq.put("نيـ", 14);
    freq.put("يرا", 280);
    freq.put("وآن", 34);
    freq.put("يرآ", 12);
    freq.put("لعر", 176);
    freq.put("لعز", 47);
    freq.put("لعس", 20);
    freq.put("لعج", 19);
    freq.put("لعد", 35);
    freq.put("لعب", 128);
    freq.put("لعة", 9);
    freq.put("لعت", 45);
    freq.put("لعث", 9);
    freq.put("يرض", 13);
    freq.put("لعا", 268);
    freq.put("يرز", 18);
    freq.put("يرس", 16);
    freq.put("لعآ", 11);
    freq.put("يرر", 11);
    freq.put("قا ", 59);
    freq.put("يرُ", 14);
    freq.put("يرٌ", 12);
    freq.put("وآخ", 13);
    freq.put("يري", 184);
    freq.put("يرً", 15);
    freq.put("يرو", 66);
    freq.put("دلع", 12);
    freq.put("يرن", 31);
    freq.put("يره", 146);
    freq.put("أي ", 86);
    freq.put("شتك", 22);
    freq.put("ؤ ", 20);
    freq.put("يرف", 20);
    freq.put("يسع", 71);
    freq.put("لعَ", 32);
    freq.put("لعُ", 12);
    freq.put("لعو", 40);
    freq.put("لعي", 170);
    freq.put("لعل", 129);
    freq.put("لعم", 112);
    freq.put("لعن", 77);
    freq.put("نٺ ", 13);
    freq.put("ا؟ ", 13);
    freq.put("لعق", 72);
    freq.put("لعك", 13);
    freq.put("فَق", 16);
    freq.put("دأ ", 55);
    freq.put("عل ", 292);
    freq.put("سه ", 155);
    freq.put("ةُ ", 33);
    freq.put("شتي", 26);
    freq.put("مق ", 14);
    freq.put("ند ", 193);
    freq.put("ى،", 12);
    freq.put("اي ", 168);
    freq.put("نتخ", 24);
    freq.put("ضُ ", 18);
    freq.put("نتج", 12);
    freq.put("بجي", 9);
    freq.put("بجو", 12);
    freq.put("ىء", 14);
    freq.put("بجن", 12);
    freq.put("ست ", 113);
    freq.put("ىّ", 32);
    freq.put("ىْ", 15);
    freq.put("بجد", 15);
    freq.put("ىُ", 9);
    freq.put("ىَ", 101);
    freq.put("بجا", 18);
    freq.put(" ﻟ ", 10);
    freq.put("ىٰ", 10);
    freq.put("ﻪ", 29);
    freq.put("نتظ", 106);
    freq.put("ريك", 79);
    freq.put("بٍ ", 15);
    freq.put("حَي", 44);
    freq.put("نيو", 25);
    freq.put("حَق", 14);
    freq.put("حَل", 16);
    freq.put("حَم", 33);
    freq.put("حَن", 14);
    freq.put("نيَ", 26);
    freq.put("اغي", 16);
    freq.put("اغن", 26);
    freq.put("غرق", 20);
    freq.put("اغل", 38);
    freq.put("اغف", 53);
    freq.put("نيك", 54);
    freq.put("نتص", 39);
    freq.put("نيق", 11);
    freq.put("نيف", 25);
    freq.put(" ـ ", 12);
    freq.put("اغت", 15);
    freq.put(" Ⓜ ", 73);
    freq.put("اغا", 17);
    freq.put("محن", 14);
    freq.put("ﻓ", 68);
    freq.put("نيم", 14);
    freq.put("نيل", 17);
    freq.put("اغر", 9);
    freq.put("ي?", 15);
    freq.put("ين ", 2676);
    freq.put("حَب", 13);
    freq.put("حَت", 10);
    freq.put("ﻲ ", 64);
    freq.put("حَد", 47);
    freq.put("لْ ", 34);
    freq.put("ي ", 15892);
    freq.put("حَا", 34);
    freq.put("نذا", 9);
    freq.put("ـهـ", 30);
    freq.put("ﮧ ", 12);
    freq.put("ذهب", 63);
    freq.put("هك ", 53);
    freq.put("يس ", 344);
    freq.put("عا ", 63);
    freq.put("رُ ", 56);
    freq.put("ﭑ", 37);
    freq.put("ضيك", 12);
    freq.put("ثبت", 41);
    freq.put("قظ ", 14);
    freq.put("ثبا", 10);
    freq.put("مها", 123);
    freq.put("تقي", 30);
    freq.put("اج ", 192);
    freq.put("نجح", 24);
    freq.put("جزء", 24);
    freq.put("لُو", 15);
    freq.put("نجد", 19);
    freq.put("مفر", 30);
    freq.put("لُّ", 15);
    freq.put("ـن ", 117);
    freq.put("ﺩ", 15);
    freq.put("لتص", 45);
    freq.put("صيل", 38);
    freq.put("صيم", 9);
    freq.put("صين", 24);
    freq.put("صيه", 10);
    freq.put("صيف", 25);
    freq.put("جزت", 9);
    freq.put("صير", 182);
    freq.put("صيح", 38);
    freq.put("صيد", 37);
    freq.put("صيب", 70);
    freq.put("بت ", 198);
    freq.put("صيت", 21);
    freq.put("صيا", 39);
    freq.put("ونص", 18);
    freq.put("محو", 18);
    freq.put("قوة", 50);
    freq.put("أعز", 12);
    freq.put("أعر", 44);
    freq.put("أعذ", 10);
    freq.put("أعط", 25);
    freq.put("▄", 79);
    freq.put("قود", 31);
    freq.put("أعش", 14);
    freq.put("أعظ", 18);
    freq.put("قوا", 61);
    freq.put("أعا", 12);
    freq.put("أعت", 25);
    freq.put("أعد", 11);
    freq.put("قوط", 15);
    freq.put("أعج", 15);
    freq.put(" غد", 68);
    freq.put(" غب", 37);
    freq.put(" غا", 121);
    freq.put(" غآ", 12);
    freq.put(" غص", 23);
    freq.put(" غش", 13);
    freq.put(" غض", 23);
    freq.put(" غر", 135);
    freq.put(" غس", 10);
    freq.put("كمه", 10);
    freq.put(" غَ", 19);
    freq.put(" غي", 387);
    freq.put(" غم", 10);
    freq.put(" غل", 64);
    freq.put(" غف", 37);
    freq.put(" غـ", 11);
    freq.put("قوى", 50);
    freq.put("قوو", 15);
    freq.put("قوي", 43);
    freq.put("فف ", 20);
    freq.put("قوف", 14);
    freq.put("قوق", 25);
    freq.put("قوم", 107);
    freq.put("قول", 639);
    freq.put("قوه", 15);
    freq.put("قون", 57);
    freq.put("أعن", 11);
    freq.put("أعم", 53);
    freq.put("أعل", 69);
    freq.put("أعي", 39);
    freq.put("أعو", 32);
    freq.put("يني", 500);
    freq.put("ينو", 18);
    freq.put("ينُ", 9);
    freq.put("ينَ", 75);
    freq.put("ينك", 210);
    freq.put("ينق", 24);
    freq.put("ينف", 44);
    freq.put("ينـ", 21);
    freq.put("يِ", 99);
    freq.put("يّ", 494);
    freq.put("يْ", 150);
    freq.put("يٓ", 9);
    freq.put("يٌ", 32);
    freq.put("يَ", 554);
    freq.put("يُ", 304);
    freq.put("يو", 1478);
    freq.put("يى", 14);
    freq.put("يي", 513);
    freq.put("يً", 17);
    freq.put("يل", 1584);
    freq.put("يم", 1237);
    freq.put("ين", 4811);
    freq.put("يه", 2030);
    freq.put("يـ", 443);

    init3();
  }
  private static void init3() {
    
    freq.put("يف", 1022);
    freq.put("يق", 1386);
    freq.put("يك", 1400);
    freq.put(" ــ", 31);
    freq.put("يٺ", 15);
    freq.put("ي؟", 31);
    freq.put("ين،", 19);
    freq.put("نية", 129);
    freq.put("اغ ", 23);
    freq.put("ي،", 106);
    freq.put("نيب", 11);
    freq.put("ين؟", 16);
    freq.put("نيد", 11);
    freq.put("ادب", 10);
    freq.put("ينت", 81);
    freq.put("ينة", 75);
    freq.put("ينب", 38);
    freq.put("يظ", 34);
    freq.put("يع", 1229);
    freq.put("يغ", 144);
    freq.put("ينج", 24);
    freq.put("يش", 528);
    freq.put("يص", 248);
    freq.put("يض", 280);
    freq.put("يط", 257);
    freq.put("يذ", 80);
    freq.put("ير", 2849);
    freq.put("يز", 311);
    freq.put("يس", 1217);
    freq.put("يج", 495);
    freq.put("يح", 677);
    freq.put("يخ", 369);
    freq.put("يد", 1699);
    freq.put("يب", 1370);
    freq.put("ية", 1234);
    freq.put("يت", 2552);
    freq.put("يث", 176);
    freq.put("يؤ", 60);
    freq.put("ينز", 18);
    freq.put("يئ", 190);
    freq.put("يا", 4141);
    freq.put("ينط", 17);
    freq.put("يء", 357);
    freq.put("يآ", 193);
    freq.put("يأ", 93);
    freq.put("نذ ", 31);
    freq.put("🍃 ", 16);
    freq.put("نيا", 274);
    freq.put("اّ ", 17);
    freq.put("🍃?", 28);
    freq.put("💟 ", 13);
    freq.put("يہ", 117);
    freq.put("عاه", 28);
    freq.put("عان", 92);
    freq.put("عام", 169);
    freq.put("عال", 343);
    freq.put("عاك", 26);
    freq.put("عاق", 27);
    freq.put("عاف", 78);
    freq.put("يسأ", 33);
    freq.put("عاً", 36);
    freq.put("عاي", 52);
    freq.put("يست", 254);
    freq.put("عاو", 19);
    freq.put("ءْ ", 16);
    freq.put("هكذ", 34);
    freq.put("يسر", 69);
    freq.put("يسس", 9);
    freq.put("ﺼ", 16);
    freq.put("عاا", 33);
    freq.put("عائ", 39);
    freq.put("يسه", 36);
    freq.put("يسـ", 9);
    freq.put("عاء", 99);
    freq.put("يسك", 27);
    freq.put("عاد", 410);
    freq.put("يسَ", 34);
    freq.put("عاج", 56);
    freq.put("يسو", 70);
    freq.put("رة ", 886);
    freq.put("يسي", 43);
    freq.put("عاب", 37);
    freq.put("عاط", 15);
    freq.put("نيس", 16);
    freq.put("عاص", 14);
    freq.put("عاش", 36);
    freq.put("يسّ", 13);
    freq.put("عار", 88);
    freq.put("يھ", 20);
    freq.put("ريئ", 9);
    freq.put("ه?", 26);
    freq.put("يگ", 27);
    freq.put("ماً", 161);
    freq.put("ريا", 367);
    freq.put("ىّ ", 30);
    freq.put("ياح", 60);
    freq.put("لسع", 231);
    freq.put("بتل", 41);
    freq.put("بته", 63);
    freq.put("بتن", 29);
    freq.put("بتف", 12);
    freq.put("بتك", 51);
    freq.put("بتق", 10);
    freq.put("بتُ", 12);
    freq.put("بتَ", 10);
    freq.put("بتو", 37);
    freq.put("بتي", 72);
    freq.put("بتص", 9);
    freq.put("ريع", 49);
    freq.put("بتر", 15);
    freq.put("بتس", 172);
    freq.put("بتع", 54);
    freq.put("بتا", 20);
    freq.put("ي، ", 91);
    freq.put("بتح", 15);
    freq.put("بتج", 9);
    freq.put("بتد", 20);
    freq.put("لسر", 53);
    freq.put("صي ", 19);
    freq.put("ماو", 29);
    freq.put("بتت", 12);
    freq.put("ياع", 43);
    freq.put("لقض", 16);
    freq.put("لُ ", 38);
    freq.put(" ٥ ", 9);
    freq.put("ففف", 10);
    freq.put("ﺒ", 43);
    freq.put("لسا", 160);
    freq.put("صص ", 17);
    freq.put("ح", 15894);
    freq.put("ياص", 16);
    freq.put("ةٍ ", 30);
    freq.put("ماك", 60);
    freq.put("قہ ", 36);
    freq.put("لّـ", 15);
    freq.put("نزع", 9);
    freq.put("ﮩ", 10);
    freq.put("رير", 59);
    freq.put("ه ", 11469);
    freq.put("يضر", 32);
    freq.put("ـ", 7204);
    freq.put("ونْ", 17);
    freq.put("بُ ", 68);
    freq.put("لآل", 13);
    freq.put("نزل", 98);
    freq.put("نزي", 20);
    freq.put("﷽", 30);
    freq.put("ونُ", 13);
    freq.put("وْ", 37);
    freq.put("مان", 349);
    freq.put("وِ", 13);
    freq.put("أ ", 219);
    freq.put("وي", 2375);
    freq.put("وو", 550);
    freq.put("وى", 192);
    freq.put("وَ", 559);
    freq.put("وُ", 145);
    freq.put("وٌ", 26);
    freq.put("وق", 1042);
    freq.put("وك", 569);
    freq.put("وف", 943);
    freq.put("ون", 2996);
    freq.put("وه", 669);
    freq.put("ول", 3568);
    freq.put("وم", 2063);
    freq.put("هجو", 14);
    freq.put("راك", 78);
    freq.put("ونه", 149);
    freq.put("ِبر", 9);
    freq.put("ونن", 15);
    freq.put("ِبُ", 10);
    freq.put("هجر", 30);
    freq.put("وغ", 84);
    freq.put("وظ", 54);
    freq.put("وع", 665);
    freq.put("وز", 286);
    freq.put("وس", 631);
    freq.put("وذ", 96);
    freq.put("ور", 1982);
    freq.put("وض", 222);
    freq.put("وط", 209);
    freq.put("وش", 368);
    freq.put("وص", 296);
    freq.put("وت", 1201);
    freq.put("وث", 54);
    freq.put("وب", 1222);
    freq.put("وة", 188);
    freq.put("وخ", 143);
    freq.put("ود", 929);
    freq.put("وج", 712);
    freq.put("وح", 834);
    freq.put("وآ", 203);
    freq.put("وأ", 679);
    freq.put("وء", 97);
    freq.put("وئ", 10);
    freq.put("وا", 5380);
    freq.put("وإ", 199);
    freq.put("علَ", 19);
    freq.put("علي", 1016);
    freq.put("علو", 68);
    freq.put("على", 1473);
    freq.put("علن", 95);
    freq.put("عله", 74);
    freq.put("علم", 416);
    freq.put("علق", 65);
    freq.put("علك", 38);
    freq.put("علـ", 17);
    freq.put("سهو", 9);
    freq.put("سهي", 10);
    freq.put("قير", 23);
    freq.put("طِي", 15);
    freq.put("سهم", 37);
    freq.put("سهل", 117);
    freq.put("قيع", 34);
    freq.put("علّ", 31);
    freq.put("قاف", 28);
    freq.put("قاك", 18);
    freq.put("ؤي", 36);
    freq.put("قام", 81);
    freq.put("ؤو", 38);
    freq.put("قاه", 31);
    freq.put("ؤن", 11);
    freq.put("أيك", 15);
    freq.put("ؤل", 111);
    freq.put("ؤم", 72);
    freq.put("أين", 33);
    freq.put("أيه", 30);
    freq.put("ير ", 1363);
    freq.put("طيت", 30);
    freq.put(" ظر", 17);
    freq.put("أيّ", 10);
    freq.put("لع ", 119);
    freq.put("محب", 59);
    freq.put("أيت", 29);
    freq.put("ؤد", 16);
    freq.put("ؤج", 9);
    freq.put("وّ", 101);
    freq.put("ؤت", 13);
    freq.put("أيد", 17);
    freq.put("قائ", 83);
    freq.put("قاا", 11);
    freq.put("قاب", 56);
    freq.put("ؤا", 91);
    freq.put("قات", 113);
    freq.put(" ظه", 28);
    freq.put(" ظن", 40);
    freq.put(" ظل", 43);
    freq.put("قار", 33);
    freq.put("كى ", 41);
    freq.put("قاش", 13);
    freq.put("قاض", 9);
    freq.put("قاط", 30);
    freq.put("قاع", 64);
    freq.put("ودة", 36);
    freq.put("أيض", 21);
    freq.put("ؤس", 14);
    freq.put("ؤذ", 27);
    freq.put("قيه", 34);
    freq.put("قين", 77);
    freq.put("قيم", 66);
    freq.put("دأت", 12);
    freq.put("علت", 35);
    freq.put("قيق", 172);
    freq.put("تأم", 21);
    freq.put("علئ", 11);
    freq.put("علا", 194);
    freq.put("قيو", 31);
    freq.put("طيب", 146);
    freq.put("قيّ", 14);
    freq.put("علش", 21);
    freq.put("ضغط", 18);
    freq.put("سها", 34);
    freq.put("ايہ", 9);
    freq.put("ياك", 76);
    freq.put("عسى", 27);
    freq.put("ندر", 24);
    freq.put("ايع", 37);
    freq.put("ايط", 19);
    freq.put("ايش", 39);
    freq.put(" ﻵ", 15);
    freq.put("ايز", 19);
    freq.put("ايس", 29);
    freq.put("مقت", 26);
    freq.put("اير", 64);
    freq.put("ايخ", 16);
    freq.put("ايد", 61);
    freq.put("ايج", 23);
    freq.put("ايح", 41);
    freq.put("ايت", 36);
    freq.put("مقر", 18);
    freq.put("ايب", 74);
    freq.put("اية", 94);
    freq.put("ايا", 152);
    freq.put("لسّ", 30);
    freq.put("ستغ", 346);
    freq.put("ستع", 76);
    freq.put("ستس", 9);
    freq.put("ستر", 92);
    freq.put("ستض", 10);
    freq.put("ستط", 97);
    freq.put("ستش", 29);
    freq.put("ستص", 14);
    freq.put("ستت", 12);
    freq.put("ستث", 14);
    freq.put("ستب", 25);
    freq.put("همه", 34);
    freq.put("ستخ", 56);
    freq.put("ستد", 12);
    freq.put("ستج", 47);
    freq.put("ستح", 164);
    freq.put("ى ", 4453);
    freq.put("ستا", 111);
    freq.put("طيا", 12);
    freq.put("ستي", 57);
    freq.put("ستو", 88);
    freq.put("ستَ", 30);
    freq.put("ستُ", 19);
    freq.put("⭕ل", 34);
    freq.put("ستق", 108);
    freq.put("ستك", 12);
    freq.put("ستف", 41);
    freq.put("ستن", 23);
    freq.put("سته", 33);
    freq.put("ستل", 24);
    freq.put("آشت", 11);
    freq.put("مقل", 12);
    freq.put("ﻦ", 41);
    freq.put("مقو", 13);
    freq.put("لسك", 25);
    freq.put("ندم", 191);
    freq.put("ندن", 21);
    freq.put("نده", 53);
    freq.put("ايي", 25);
    freq.put("ايو", 37);
    freq.put("ندك", 57);
    freq.put("اين", 67);
    freq.put("ايه", 87);
    freq.put("ايل", 49);
    freq.put("ايم", 99);
    freq.put("ايق", 84);
    freq.put("ايك", 40);
    freq.put("ر، ", 42);
    freq.put("ايف", 69);
    freq.put("كسب", 26);
    freq.put("قتن", 25);
    freq.put("خذ ", 80);
    freq.put("كسر", 53);
    freq.put("زك ", 19);
    freq.put("ُبح", 15);
    freq.put("ہ ", 840);
    freq.put("إيم", 28);
    freq.put("إيه", 12);
    freq.put("شِي", 16);
    freq.put("فور", 38);
    freq.put("هتم", 92);
    freq.put("إيج", 9);
    freq.put("◉", 16);
    freq.put("آك ", 25);
    freq.put("إيا", 20);
    freq.put("ماط", 19);
    freq.put("ادا", 61);
    freq.put("ﻏ", 14);
    freq.put("قتي", 58);
    freq.put("لٱ ", 11);
    freq.put("إير", 32);
    freq.put("زة ", 63);
    freq.put("شر ", 234);
    freq.put("كسو", 22);
    freq.put("كسي", 28);
    freq.put("كسل", 10);
    freq.put("لآخ", 105);
    freq.put("فه ", 188);
    freq.put("ہم ", 14);
    freq.put("وصف", 30);
    freq.put("صرو", 9);
    freq.put("صري", 60);
    freq.put("صرف", 42);
    freq.put("ثُم", 16);
    freq.put("صرك", 13);
    freq.put("نمل", 15);
    freq.put("صره", 30);
    freq.put("صرن", 11);
    freq.put("دعي", 46);
    freq.put("دعو", 141);
    freq.put("دعن", 9);
    freq.put("دعم", 42);
    freq.put("دعك", 20);
    freq.put("ھم ", 23);
    freq.put("وعق", 10);
    freq.put("دٍ ", 24);
    freq.put("وعل", 74);
    freq.put("وعم", 18);
    freq.put("وعن", 36);
    freq.put("ونب", 9);
    freq.put("زور", 20);
    freq.put("وعي", 65);
    freq.put("صنا", 23);
    freq.put("صنع", 47);
    freq.put("هلك", 25);
    freq.put("زوج", 89);
    freq.put("زود", 15);
    freq.put("زوا", 32);
    freq.put("ونج", 15);
    freq.put("😁 ", 12);
    freq.put("حٌ ", 9);
    freq.put("وعا", 42);
    freq.put("وعب", 22);
    freq.put("ٺ ", 54);
    freq.put("راب", 96);
    freq.put("وعد", 58);
    freq.put("وعر", 9);
    freq.put("زوم", 13);
    freq.put("زول", 17);
    freq.put("😁?", 14);
    freq.put("صرة", 23);
    freq.put("مات", 315);
    freq.put("صرت", 44);
    freq.put("̄ﻟ", 13);
    freq.put("صرا", 66);
    freq.put("دعت", 20);
    freq.put("دعا", 113);
    freq.put("لّہ", 18);
    freq.put("طل ", 37);
    freq.put("حا ", 24);
    freq.put("وﻻ ", 18);
    freq.put("حظة", 31);
    freq.put("حظا", 20);
    freq.put("أذا", 22);
    freq.put("ـزي", 12);
    freq.put("تعط", 35);
    freq.put("تعش", 19);
    freq.put("تعص", 9);
    freq.put("تعز", 11);
    freq.put("تعذ", 23);
    freq.put("تعر", 132);
    freq.put("تعا", 220);
    freq.put("بكل", 79);
    freq.put("بكم", 61);
    freq.put("بكي", 84);
    freq.put("تعد", 77);
    freq.put("ءِ ", 21);
    freq.put("بكى", 10);
    freq.put("بكَ", 28);
    freq.put("تعث", 9);
    freq.put("تعب", 115);
    freq.put("ودن", 12);
    freq.put("بكر", 77);
    freq.put("وده", 44);
    freq.put("تام", 21);
    freq.put("تعن", 32);
    freq.put("تعل", 188);
    freq.put("تعم", 46);
    freq.put("بكا", 50);
    freq.put("تعـ", 14);
    freq.put("رد ", 280);
    freq.put("بكت", 10);
    freq.put("بكث", 20);
    freq.put("تعي", 68);
    freq.put("لنج", 40);
    freq.put("تعو", 58);
    freq.put("ودك", 49);
    freq.put("لخد", 14);
    freq.put("حظي", 11);
    freq.put("حظو", 18);
    freq.put("حظه", 30);
    freq.put("حظك", 18);
    freq.put("ساع", 150);
    freq.put("█", 43);
    freq.put("كر ", 360);
    freq.put("يل ", 767);
    freq.put("يـو", 11);
    freq.put("سرة", 14);
    freq.put("يــ", 138);
    freq.put("يـك", 14);
    freq.put("يـق", 11);
    freq.put("يـل", 10);
    freq.put("يـه", 25);
    freq.put("يـن", 36);
    freq.put(" نِ", 17);
    freq.put(" نف", 395);
    freq.put(" نـ", 32);
    freq.put(" نك", 61);
    freq.put(" نق", 96);
    freq.put("ص", 6738);
    freq.put(" نل", 16);
    freq.put(" نه", 79);
    freq.put(" نن", 41);
    freq.put("ىْ ", 14);
    freq.put(" نو", 148);
    freq.put(" ني", 57);
    freq.put(" نُ", 32);
    freq.put(" نَ", 69);
    freq.put(" نر", 75);
    freq.put(" نذ", 9);
    freq.put(" نس", 157);
    freq.put(" نز", 27);
    freq.put(" نص", 181);
    freq.put(" نش", 92);
    freq.put(" نط", 30);
    freq.put(" نض", 11);
    freq.put(" نع", 174);
    freq.put(" نظ", 73);
    freq.put(" نغ", 12);
    freq.put(" نآ", 9);
    freq.put("هب ", 66);
    freq.put("ساط", 12);
    freq.put(" نا", 316);
    freq.put(" نب", 137);
    freq.put(" نت", 107);
    freq.put(" نح", 158);
    freq.put(" نج", 79);
    freq.put(" ند", 34);
    freq.put(" نخ", 32);
    freq.put("يـع", 14);
    freq.put("يـر", 36);
    freq.put("لى ", 2124);
    freq.put("ماء", 150);
    freq.put("يـب", 11);
    freq.put("يـت", 31);
    freq.put("يـد", 18);
    freq.put("ئدة", 9);
    freq.put("يـا", 31);
    freq.put("قيا", 77);
    freq.put("رزق", 107);
    freq.put("ماا", 85);
    freq.put("قيد", 16);
    freq.put("ڳ", 31);
    freq.put("دِ ", 18);
    freq.put("ساا", 20);
    freq.put("زي ", 111);
    freq.put("رزا", 9);
    freq.put("و", 36838);
    freq.put("مائ", 28);
    freq.put("كتو", 54);
    freq.put("قيت", 60);
    freq.put("زقه", 12);
    freq.put("قية", 57);
    freq.put("زقن", 61);
    freq.put(" شل", 35);
    freq.put("زقك", 11);
    freq.put("كته", 28);
    freq.put("فمن", 29);
    freq.put("بخا", 22);
    freq.put("غِي", 17);
    freq.put("بخط", 12);
    freq.put("ﺸ", 13);
    freq.put("بخل", 18);
    freq.put("بخي", 63);
    freq.put("ِرُ", 20);
    freq.put("قال", 530);
    freq.put("قان", 44);
    freq.put("قاو", 16);
    freq.put("فما", 28);
    freq.put("ؤه", 28);
    freq.put("قاي", 25);
    freq.put("جلك", 21);
    freq.put("قاً", 55);
    freq.put("جله", 29);
    freq.put("جلي", 37);
    freq.put("جلو", 9);
    freq.put("ؤك", 27);
    freq.put("فت ", 141);
    freq.put("حيل", 113);
    freq.put("حيم", 28);
    freq.put("حين", 301);
    freq.put("حيه", 20);
    freq.put("حيـ", 21);
    freq.put("حيف", 18);
    freq.put("ائِ", 38);
    freq.put("حيو", 23);
    freq.put("حيى", 11);
    freq.put("حيي", 25);
    freq.put("ائي", 132);
    freq.put("", 16);
    freq.put("حيّ", 9);
    freq.put("نكه", 9);
    freq.put("ائق", 36);
    freq.put("ائك", 42);
    freq.put("ائف", 23);
    freq.put("ائن", 30);
    freq.put("ائه", 42);
    freq.put("ائل", 72);
    freq.put("ائم", 138);
    freq.put("نكر", 27);
    freq.put("حيا", 503);
    freq.put("حيآ", 29);
    freq.put("ائز", 12);
    freq.put("حيح", 47);
    freq.put("حيد", 64);
    freq.put("حية", 32);
    freq.put("حيت", 11);
    freq.put(" ل ", 55);
    freq.put("ائب", 49);
    freq.put("حيط", 12);
    freq.put("حير", 13);
    freq.put("ائح", 14);
    freq.put("نكب", 11);
    freq.put("نكت", 28);
    freq.put("جلا", 49);
    freq.put("ﻮ ", 9);
    freq.put("┃ ", 9);
    freq.put("ن?", 9);
    freq.put("ن ", 15090);
    freq.put("ئة ", 50);
    freq.put("جلط", 13);
    freq.put("يق ", 353);
    freq.put("نك،", 10);
    freq.put("نشر", 97);
    freq.put("معا", 154);
    freq.put("قاء", 120);
    freq.put("معة", 41);
    freq.put("جا ", 25);
    freq.put("معت", 80);
    freq.put("طنا", 10);
    freq.put("معد", 24);
    freq.put("ﺎ", 343);
    freq.put("معر", 53);
    freq.put("معص", 14);
    freq.put("معط", 12);
    freq.put("نشب", 10);
    freq.put("ؤث", 16);
    freq.put("ــآ", 18);
    freq.put("ــا", 174);
    freq.put("مى ", 51);
    freq.put("ــت", 48);
    freq.put("ــة", 17);
    freq.put("ــب", 31);
    freq.put("ــد", 62);
    freq.put("هُ ", 150);
    freq.put("ــح", 22);
    freq.put("ــس", 16);
    freq.put("ــز", 12);
    freq.put("ــر", 81);
    freq.put("ــذ", 13);
    freq.put("رحَ", 14);
    freq.put("ــع", 19);
    freq.put("رحم", 283);
    freq.put("رحل", 88);
    freq.put("رحه", 30);
    freq.put("رحن", 17);
    freq.put("ــك", 55);
    freq.put(" Ⓜ", 79);
    freq.put("ــف", 17);
    freq.put("ـــ", 1585);
    freq.put("آ ", 886);
    freq.put("ــن", 52);
    freq.put("ــم", 55);
    freq.put("ــل", 64);
    freq.put("ــي", 89);
    freq.put("ــو", 81);
    freq.put(" اش", 271);
    freq.put("أيا", 73);
    freq.put("رحة", 21);
    freq.put("رحب", 16);
    freq.put("رحت", 44);
    freq.put("ظن ", 38);
    freq.put("قاد", 72);
    freq.put("رحا", 31);
    freq.put("طني", 50);
    freq.put("معـ", 9);
    freq.put("معك", 99);
    freq.put("معم", 10);
    freq.put("معل", 73);
    freq.put("معه", 108);
    freq.put("ظل ", 21);
    freq.put("معو", 24);
    freq.put("معي", 110);
    freq.put("معَ", 15);
    freq.put("نشك", 9);
    freq.put("قاس", 18);
    freq.put("نشن", 10);
    freq.put("نشو", 27);
    freq.put("نشي", 11);
    freq.put("دمش", 24);
    freq.put("صوا", 35);
    freq.put("ـني", 16);
    freq.put("زيز", 71);
    freq.put("زير", 61);
    freq.put("دمت", 40);
    freq.put("صوت", 128);
    freq.put("نيآ", 23);
    freq.put("أَن", 37);
    freq.put("صوص", 18);
    freq.put("أَك", 13);
    freq.put("صور", 272);
    freq.put("زيد", 71);
    freq.put("أَي", 9);
    freq.put("زيت", 13);
    freq.put("زية", 10);
    freq.put("رز ", 28);
    freq.put("صول", 25);
    freq.put("صوم", 16);
    freq.put("أَس", 9);
    freq.put("صوي", 36);
    freq.put("زين", 128);
    freq.put("زيم", 13);
    freq.put("زيل", 29);
    freq.put("دمآ", 19);
    freq.put("أَح", 14);
    freq.put("دِي", 30);
    freq.put("زيو", 12);
    freq.put("دما", 181);
    freq.put("سهر", 43);
    freq.put("يرَ", 12);
    freq.put("سخر", 19);
    freq.put("ِر ", 41);
    freq.put("بخ ", 20);
    freq.put("◾〰◾", 20);
    freq.put("⃣ ", 24);
    freq.put("كمة", 27);
    freq.put("̵", 71);
    freq.put("وور", 24);
    freq.put("صطف", 13);
    freq.put("بفض", 10);
    freq.put("دمي", 31);
    freq.put("دمو", 51);
    freq.put("ـذا", 15);
    freq.put("دمَ", 12);
    freq.put("نِ", 186);
    freq.put("نّ", 340);
    freq.put("نْ", 298);
    freq.put("فتر", 49);
    freq.put("نـ", 321);
    freq.put("نف", 794);
    freq.put("نق", 314);
    freq.put("نك", 1120);
    freq.put("نل", 34);
    freq.put("نم", 230);
    freq.put("نن", 325);
    freq.put("نه", 1639);
    freq.put("نو", 930);
    freq.put("نى", 235);
    freq.put("ني", 4014);
    freq.put("نً", 12);
    freq.put("نٌ", 29);
    freq.put("نٍ", 19);
    freq.put("نَ", 543);
    freq.put("نُ", 134);
    freq.put(" لَ", 114);
    freq.put(" لي", 1039);
    freq.put(" لو", 483);
    freq.put(" له", 567);
    freq.put(" لن", 371);
    freq.put(" لم", 695);
    freq.put(" لل", 1112);
    freq.put(" لك", 720);
    freq.put(" لق", 135);
    freq.put(" لف", 33);
    freq.put(" لـ", 192);
    freq.put(" لِ", 154);
    freq.put(" لد", 105);
    freq.put(" لخ", 27);
    freq.put(" لح", 166);
    freq.put(" لج", 67);
    freq.put("حي ", 203);
    freq.put(" لت", 133);
    freq.put(" لب", 97);
    freq.put(" لا", 2419);
    freq.put("مقب", 21);
    freq.put(" لإ", 41);
    freq.put(" لأ", 319);
    freq.put(" لآ", 171);
    freq.put("ن؟", 30);
    freq.put("نك ", 785);
    freq.put("غُر", 9);
    freq.put(" لغ", 47);
    freq.put(" لع", 113);
    freq.put("مود", 29);
    freq.put(" لط", 30);
    freq.put(" لص", 22);
    freq.put(" لش", 33);
    freq.put("ن،", 54);
    freq.put(" لز", 143);
    freq.put(" لر", 48);
    freq.put(" لذ", 55);
    freq.put("نذ", 50);
    freq.put("نر", 102);
    freq.put("نز", 162);
    freq.put("نس", 779);
    freq.put("نش", 274);
    freq.put("نص", 408);
    freq.put("نض", 39);
    freq.put("نط", 131);
    freq.put("نظ", 237);
    freq.put("نع", 434);
    freq.put("نغ", 40);
    freq.put("يقظ", 22);
    freq.put("فتو", 40);
    freq.put("نآ", 230);
    freq.put("مقط", 22);
    freq.put("موب", 20);
    freq.put("نا", 4768);
    freq.put("نب", 438);
    freq.put("نة", 399);
    freq.put("نت", 1902);
    freq.put("نث", 79);
    freq.put("نج", 254);
    freq.put("نح", 277);
    freq.put("نخ", 53);
    freq.put("ند", 767);
    freq.put("جات", 52);
    freq.put("مع ", 574);
    freq.put("جاب", 115);
    freq.put("جاد", 16);
    freq.put("جاج", 16);
    freq.put("جاح", 38);
    freq.put("طن ", 82);
    freq.put("جاء", 49);
    freq.put("جائ", 23);
    freq.put("جاا", 10);
    freq.put("ظلو", 15);
    freq.put("نہ", 82);
    freq.put("جاع", 30);
    freq.put("جاز", 35);
    freq.put("جار", 57);
    freq.put("يد،", 9);
    freq.put("آل", 734);
    freq.put("آم", 201);
    freq.put("آن", 543);
    freq.put("آه", 83);
    freq.put("آف", 48);
    freq.put("آق", 74);
    freq.put("آك", 90);
    freq.put("يدع", 42);
    freq.put("آو", 56);
    freq.put("آي", 115);
    freq.put("شرن", 21);
    freq.put("يدا", 201);
    freq.put("يدة", 132);
    freq.put("يدت", 14);
    freq.put("يدخ", 30);
    freq.put("آؤ", 10);
    freq.put("آإ", 15);
    freq.put("آئ", 35);
    freq.put("آا", 51);
    freq.put("آء", 87);
    freq.put("آآ", 59);
    freq.put("", 9);
    freq.put("آح", 166);
    freq.put("آخ", 250);
    freq.put("آد", 94);
    freq.put("آب", 120);
    freq.put("آة", 27);
    freq.put("آت", 156);
    freq.put("آث", 22);
    freq.put("آش", 53);
    freq.put("آص", 42);
    freq.put("آض", 23);
    freq.put("آط", 14);
    freq.put("آذ", 21);
    freq.put("آر", 125);
    freq.put("آز", 11);
    freq.put("آس", 140);
    freq.put("يدو", 39);
    freq.put("رح ", 220);
    freq.put("يدي", 152);
    freq.put("آع", 84);
    freq.put("آغ", 14);
    freq.put("يدُ", 10);
    freq.put("جاي", 39);
    freq.put("جاو", 33);
    freq.put("ﻢ", 27);
    freq.put("جاف", 9);
    freq.put("جان", 60);
    freq.put("جاه", 110);
    freq.put("نھ", 20);
    freq.put("جام", 61);
    freq.put("لنم", 16);
    freq.put("نک", 10);
    freq.put("نگ", 17);
    freq.put("إح", 92);
    freq.put("إج", 45);
    freq.put("إد", 27);
    freq.put("إخ", 108);
    freq.put("إب", 112);
    freq.put("إث", 17);
    freq.put("خذت", 13);
    freq.put("فهن", 11);
    freq.put("إا", 10);
    freq.put("فهل", 10);
    freq.put("شرو", 54);
    freq.put("كس ", 51);
    freq.put("شري", 76);
    freq.put("إع", 69);
    freq.put("إغ", 20);
    freq.put("إص", 25);
    freq.put("إش", 44);
    freq.put("إط", 24);
    freq.put("إض", 14);
    freq.put("إر", 79);
    freq.put("إذ", 365);
    freq.put("إس", 213);
    freq.put("إز", 14);
    freq.put("ہا", 41);
    freq.put("غْف", 17);
    freq.put("لضي", 29);
    freq.put("ہم", 19);
    freq.put("ﻋ", 70);
    freq.put("ہي", 10);
    freq.put("ہٌ", 11);
    freq.put("ہُ", 61);
    freq.put("ہَ", 85);
    freq.put("ہّ", 26);
    freq.put("ہْ", 13);
    freq.put("نقت", 11);
    freq.put("هت ", 25);
    freq.put("فهد", 20);
    freq.put("حدث", 88);
    freq.put("شرا", 45);
    freq.put("خذو", 16);
    freq.put("خذي", 11);
    freq.put("إم", 82);
    freq.put("خذل", 30);
    freq.put("خذه", 16);
    freq.put("خذن", 26);
    freq.put("إف", 18);
    freq.put("شرة", 24);
    freq.put("خذك", 11);
    freq.put("إق", 33);
    freq.put("شرط", 32);
    freq.put("إِ", 85);
    freq.put("لقل", 187);
    freq.put("َعا", 18);
    freq.put("لنك", 10);
    freq.put("ًا ", 230);
    freq.put("▲", 9);
    freq.put("اؤل", 9);
    freq.put("اؤه", 12);
    freq.put("دْ ", 25);
    freq.put("وع ", 186);
    freq.put("بع ", 165);
    freq.put("اجة", 58);
    freq.put("عً", 11);
    freq.put("َعْ", 9);
    freq.put("صر ", 186);
    freq.put("عَ", 409);
    freq.put("َعي", 12);
    freq.put("َعَ", 27);
    freq.put("َعُ", 13);
    freq.put("⭕لم", 27);
    freq.put("صآ", 28);
    freq.put("تَع", 28);
    freq.put("َعل", 24);
    freq.put("دع ", 62);
    freq.put("حاا", 14);
    freq.put("طلا", 50);
    freq.put("طلب", 106);
    freq.put("حات", 40);
    freq.put("حاب", 72);
    freq.put("حاد", 128);
    freq.put("حاج", 128);
    freq.put("حاس", 37);
    freq.put("حار", 51);
    freq.put("حاط", 15);
    freq.put("حاض", 15);
    freq.put("حاش", 9);
    freq.put("طلع", 129);
    freq.put("اجا", 60);
    freq.put("حظ ", 39);
    freq.put("رده", 40);
    freq.put("ردن", 25);
    freq.put("تع ", 23);
    freq.put("نفس", 508);
    freq.put("صحب", 21);
    freq.put("ردي", 40);
    freq.put("ردو", 39);
    freq.put("ردا", 21);
    freq.put("بك ", 637);
    freq.put("اجر", 62);
    freq.put("ردد", 40);
    freq.put("ردت", 22);
    freq.put("ردة", 21);
    freq.put("حاك", 26);
    freq.put("حاق", 9);
    freq.put("حاف", 62);
    freq.put("تَب", 14);
    freq.put("حان", 224);
    freq.put("حام", 35);
    freq.put("حال", 172);
    freq.put("حاً", 29);
    freq.put("حاي", 14);
    freq.put("نضم", 9);
    freq.put("حاو", 79);
    freq.put("اجو", 15);
    freq.put("كرة", 54);
    freq.put("كرآ", 12);
    freq.put("كرا", 138);
    freq.put("عث", 68);
    freq.put("كرس", 10);
    freq.put("كرر", 24);
    freq.put("لىّ", 13);
    freq.put("ر", 29034);
    freq.put("هبو", 10);
    freq.put("عآ", 93);
    freq.put("ندق", 10);
    freq.put("ۆ", 110);
    freq.put("نمي", 9);
    freq.put("صِي", 10);
    freq.put("أ", 11266);
    freq.put(" ن ", 14);
    freq.put("عا", 1899);
    freq.put("كرً", 12);
    freq.put("تَك", 19);
    freq.put("كرى", 39);
    freq.put("كرو", 57);
    freq.put("كرَ", 11);
    freq.put("عظ", 217);
    freq.put("كرك", 43);
    freq.put("ندو", 19);
    freq.put("كره", 180);
    freq.put("كرن", 22);
    freq.put("كرم", 54);
    freq.put("ئد ", 28);
    freq.put("ايـ", 17);
    freq.put("لزح", 9);
    freq.put("موظ", 11);
    freq.put("غد", 101);
    freq.put("غب", 105);
    freq.put("غة", 28);
    freq.put("غت", 51);
    freq.put("غث", 10);
    freq.put("ضال", 9);
    freq.put("ضام", 10);
    freq.put("ضان", 69);
    freq.put("غا", 326);
    freq.put("", 11);
    freq.put("غآ", 21);
    freq.put("جــ", 35);
    freq.put(" ؛ ", 179);
    freq.put("غش", 33);
    freq.put("غص", 31);
    freq.put("غض", 56);
    freq.put("غط", 41);
    freq.put("غذ", 11);
    freq.put("غر", 564);
    freq.put("غز", 22);
    freq.put("غس", 31);
    freq.put(" إج", 29);
    freq.put(" إح", 53);
    freq.put(" إخ", 56);
    freq.put("تَو", 13);
    freq.put(" إب", 78);
    freq.put(" إت", 10);
    freq.put("ظر ", 133);
    freq.put("نهَ", 10);
    freq.put("نهُ", 19);
    freq.put("نهو", 24);
    freq.put(" إع", 37);
    freq.put(" إغ", 13);
    freq.put("هى ", 24);
    freq.put(" إش", 32);
    freq.put(" إص", 11);
    freq.put(" إض", 12);
    freq.put(" إط", 15);
    freq.put(" إذ", 295);
    freq.put(" إر", 44);
    freq.put(" إس", 107);
    freq.put("همم", 9);
    freq.put(" إي", 88);
    freq.put(" إل", 906);
    freq.put(" إم", 39);
    freq.put(" إن", 605);
    freq.put(" إه", 19);
    freq.put("نهر", 12);
    freq.put(" إق", 16);
    freq.put(" إك", 10);
    freq.put("نهج", 21);
    freq.put("طون", 16);
    freq.put("عع ", 9);
    freq.put("همي", 33);
    freq.put("نها", 419);
    freq.put(" إِ", 74);
    freq.put("نهآ", 14);
    freq.put("غَ", 40);
    freq.put("غُ", 16);
    freq.put("غو", 40);
    freq.put("غى", 24);
    freq.put("غي", 874);
    freq.put("غل", 291);
    freq.put("غم", 106);
    freq.put("غن", 129);
    freq.put("غه", 15);
    freq.put("غـ", 46);
    freq.put("غف", 497);
    freq.put("طوه", 18);
    freq.put("ضاع", 18);
    freq.put("غِ", 22);
    freq.put("ضار", 10);
    freq.put("غْ", 22);
    freq.put("طقط", 22);
    freq.put("مصد", 16);
    freq.put("سعا", 163);
    freq.put("سعة", 12);
    freq.put("سعد", 160);
    freq.put("يعش", 20);
    freq.put("نظا", 57);
    freq.put("مصر", 79);
    freq.put("طقة", 20);
    freq.put("شرك", 36);
    freq.put("ـلا", 39);
    freq.put(" ¸ ", 10);
    freq.put("طوف", 12);
    freq.put("مسم", 18);
    freq.put("مسل", 139);
    freq.put("ﺴ", 43);
    freq.put("مسك", 62);
    freq.put("نهہ", 12);
    freq.put("آن ", 259);
    freq.put("تِك", 10);
    freq.put("تِل", 14);
    freq.put("ـلـ", 46);
    freq.put("فوس", 24);
    freq.put("ْبَ", 9);
    freq.put("مصو", 9);
    freq.put("مصي", 32);
    freq.put("سعي", 57);
    freq.put("سعى", 10);
    freq.put("سعو", 166);
    freq.put("سعَ", 12);
    freq.put("مسي", 64);
    freq.put("طقه", 13);
    freq.put("نظي", 15);
    freq.put("ء ", 2012);
    freq.put("همت", 16);
    freq.put("ُم ", 121);
    freq.put("همة", 10);
    freq.put("لهـ", 31);
    freq.put("لهن", 24);
    freq.put("لهه", 16);
    freq.put("لهل", 57);
    freq.put("لهم", 855);
    freq.put("لهي", 30);
    freq.put("إنّ", 26);
    freq.put("لهو", 43);
    freq.put("لهَ", 31);
    freq.put("لهُ", 76);
    freq.put("إني", 100);
    freq.put("إنَ", 11);
    freq.put("إنف", 11);
    freq.put("إنق", 14);
    freq.put("إنك", 49);
    freq.put("إنم", 30);
    freq.put("إنن", 12);
    freq.put("إنه", 62);
    freq.put("لهآ", 16);
    freq.put("لها", 436);
    freq.put("لهب", 9);
    freq.put("إنس", 89);
    freq.put("لهد", 31);
    freq.put("لهج", 21);
    freq.put("هر ", 182);
    freq.put("إنت", 62);
    freq.put("لهر", 18);
    freq.put("إنا", 24);
    freq.put("〰◾", 30);
    freq.put("له،", 29);
    freq.put("ﻵ", 26);
    freq.put("ٺ", 206);
    freq.put("أري", 33);
    freq.put("أرى", 9);
    freq.put("أرو", 42);
    freq.put("لجا", 70);
    freq.put("أرَ", 9);
    freq.put("أرق", 17);
    freq.put("أرف", 13);
    freq.put("قِي", 26);
    freq.put("لجد", 41);
    freq.put("لجس", 19);
    freq.put("لجز", 22);
    freq.put("صحه", 9);
    freq.put("صحف", 9);
    freq.put("صحك", 13);
    freq.put("لـت", 10);
    freq.put("صحى", 13);
    freq.put("ووح", 12);
    freq.put("صحي", 74);
    freq.put("لهہ", 21);
    freq.put(" أ ", 12);
    freq.put("دى ", 100);
    freq.put("لَن", 14);
    freq.put("مّا", 31);
    freq.put("😍 ", 13);
    freq.put("حو ", 30);
    freq.put("نف ", 14);
    freq.put("مدن", 16);
    freq.put("أرت", 14);
    freq.put("لجف", 12);
    freq.put("أرب", 16);
    freq.put("أرد", 32);
    freq.put("جن ", 27);
    freq.put("أرح", 32);
    freq.put("أرج", 23);
    freq.put("لجي", 71);
    freq.put("لجو", 73);
    freq.put("أرا", 43);
    freq.put("لجَ", 24);
    freq.put("قِد", 12);
    freq.put("ووك", 9);
    freq.put("ووق", 14);
    freq.put("صحا", 58);
    freq.put("ووه", 14);
    freq.put("وون", 35);
    freq.put("ووم", 22);
    freq.put("وول", 22);
    freq.put("أرس", 12);
    freq.put("أرز", 20);
    freq.put("ووو", 252);
    freq.put("صحة", 16);
    freq.put("أرض", 82);
    freq.put("صحت", 17);
    freq.put("كِي", 16);
    freq.put("كِل", 13);
    freq.put("كِن", 31);
    freq.put("🚸?", 9);
    freq.put("َّذ", 12);
    freq.put("ـق ", 21);
    freq.put("تْ ", 47);
    freq.put("سطه", 9);
    freq.put(" وي", 652);
    freq.put(" وو", 61);
    freq.put(" وُ", 25);
    freq.put(" وَ", 437);
    freq.put(" وٌ", 9);
    freq.put(" وك", 278);
    freq.put(" وق", 337);
    freq.put(" وف", 205);
    freq.put(" وه", 320);
    freq.put(" ون", 238);
    freq.put(" وم", 610);
    freq.put(" ول", 1271);
    freq.put(" وغ", 68);
    freq.put(" وع", 294);
    freq.put(" وظ", 9);
    freq.put(" وس", 322);
    freq.put(" وز", 104);
    freq.put(" ور", 302);
    freq.put(" وذ", 28);
    freq.put(" وط", 81);
    freq.put(" وض", 56);
    freq.put(" وص", 175);
    freq.put(" وش", 310);
    freq.put(" وث", 22);
    freq.put(" وت", 633);
    freq.put(" وب", 335);
    freq.put(" ود", 179);
    freq.put(" وخ", 97);
    freq.put(" وح", 351);
    freq.put(" وج", 314);
    freq.put(" وأ", 649);
    freq.put(" وآ", 122);
    freq.put(" وا", 2908);
    freq.put(" وإ", 196);
    freq.put("فوو", 12);
    freq.put("💙 ", 19);
    freq.put("وتن", 45);
    freq.put("فخر", 10);
    freq.put("💙?", 12);
    freq.put("وتف", 10);
    freq.put("ظت", 10);
    freq.put("ظب", 11);
    freq.put("ظة", 43);
    freq.put("ظآ", 11);
    freq.put("لطع", 9);
    freq.put("ظا", 175);
    freq.put("لطا", 92);
    freq.put("لطب", 28);
    freq.put("ظر", 286);
    freq.put("جأة", 15);
    freq.put("لًا", 9);
    freq.put("🔴 ", 15);
    freq.put("لفج", 45);
    freq.put("لشد", 10);
    freq.put("►", 23);
    freq.put("", 19);
    freq.put("ظي", 195);
    freq.put("ظو", 37);
    freq.put("ظَ", 10);
    freq.put("ظُ", 15);
    freq.put("ظك", 31);
    freq.put("ظـ", 13);
    freq.put("ظف", 19);
    freq.put("ظن", 103);
    freq.put("ظه", 133);
    freq.put("ظل", 119);
    freq.put("ظم", 78);
    freq.put("جأه", 15);
    freq.put("لطف", 34);
    freq.put("لطه", 14);
    freq.put("لطل", 31);
    freq.put("لطم", 10);
    freq.put("لم ", 1087);
    freq.put("ظِ", 16);
    freq.put("ىى ", 12);
    freq.put("ركز", 35);
    freq.put("ركض", 14);
    freq.put("ركع", 16);
    freq.put("زّ", 15);
    freq.put("ركا", 55);
    freq.put("ركت", 39);
    freq.put("ركة", 61);
    freq.put("ركب", 25);
    freq.put("قْ ", 25);
    freq.put("آلم", 55);
    freq.put("آلل", 67);
    freq.put("آله", 21);
    freq.put("آلن", 29);
    freq.put("آلف", 15);
    freq.put("رضى", 54);
    freq.put("آلك", 24);
    freq.put("آلق", 28);
    freq.put("ّت ", 24);
    freq.put("آلُ", 12);
    freq.put("رضه", 11);
    freq.put("آلو", 9);
    freq.put("آلي", 42);
    freq.put("صل ", 217);
    freq.put("آلِ", 12);
    freq.put(" ⭕", 58);
    freq.put("اﻷ", 20);
    freq.put("آلا", 21);
    freq.put("رضة", 14);
    freq.put("آلأ", 13);
    freq.put("آلآ", 29);
    freq.put("آلح", 44);
    freq.put("آلج", 19);
    freq.put("آلد", 12);
    freq.put("رضا", 84);
    freq.put("اﻻ", 29);
    freq.put("آلب", 23);
    freq.put("آلت", 28);
    freq.put("آلص", 18);
    freq.put("آلش", 13);
    freq.put("آلط", 10);
    freq.put("آلر", 16);
    freq.put("آلذ", 12);
    freq.put("آلس", 12);
    freq.put("قد ", 336);
    freq.put("آلع", 31);
    freq.put("آلغ", 16);
    freq.put("إعا", 10);
    freq.put(" ⬅", 10);
    freq.put("اﻟ", 40);
    freq.put("ركك", 24);
    freq.put("صد ", 30);
    freq.put("ركه", 38);
    freq.put("ركن", 15);
    freq.put("ركم", 32);
    freq.put("ركي", 106);
    freq.put("ركو", 22);
    freq.put("ركَ", 13);
    freq.put("خيف", 9);
    freq.put("خيـ", 14);
    freq.put("خيل", 51);
    freq.put("خيي", 9);
    freq.put("كبد", 13);
    freq.put("شدي", 16);
    freq.put("كبر", 189);
    freq.put("خيّ", 10);
    freq.put("َلي", 23);
    freq.put("ُها", 24);
    freq.put("شده", 10);
    freq.put("بآح", 21);
    freq.put("ہُم", 11);
    freq.put("بآب", 9);
    freq.put("ع", 22268);
    freq.put("بآر", 10);
    freq.put("بآل", 18);
    freq.put("ﻞ", 28);
    freq.put("خيا", 47);
    freq.put("طا ", 18);
    freq.put("ومم", 12);
    freq.put("كبو", 11);
    freq.put("كبي", 79);
    freq.put("خيب", 41);
    freq.put("وعو", 10);
    freq.put("خير", 478);
    freq.put("شدة", 13);
    freq.put("ُهم", 13);
    freq.put("ـش ", 14);
    freq.put("مطب", 19);
    freq.put("خة ", 11);
    freq.put("مطا", 53);
    freq.put("مطع", 11);
    freq.put("مطر", 39);
    freq.put("ﻪ ", 21);
    freq.put("طعا", 10);
    freq.put("وتص", 20);
    freq.put("ـقـ", 21);
    freq.put("ٌ", 432);
    freq.put("ْتَ", 31);
    freq.put(" و ", 1580);
    freq.put("فوز", 37);
    freq.put("ديه", 99);
    freq.put("كِ ", 138);
    freq.put("طــ", 15);
    freq.put("ھہ ", 9);
    freq.put("مطل", 29);
    freq.put("لضر", 22);
    freq.put("سؤا", 72);
    freq.put("طعة", 9);
    freq.put("فوض", 9);
    freq.put("لمِ", 17);
    freq.put("لمّ", 27);
    freq.put("ظ ", 174);
    freq.put("شـو", 9);
    freq.put("لمو", 285);
    freq.put("لط ", 53);
    freq.put("ِر", 120);
    freq.put("لمٌ", 10);
    freq.put("جأ ", 10);
    freq.put("لمُ", 95);
    freq.put("لمـ", 20);
    freq.put("لمف", 72);
    freq.put("لمق", 70);
    freq.put("لمك", 112);
    freq.put("لمل", 162);
    freq.put("لمم", 38);
    freq.put("لمن", 253);
    freq.put("ِط", 14);
    freq.put("وعة", 23);
    freq.put("يث ", 98);
    freq.put("يصر", 13);
    freq.put("🌹 ", 37);
    freq.put("لم،", 10);
    freq.put("🌹?", 11);
    freq.put("لمظ", 14);
    freq.put("لمع", 142);
    freq.put("لمغ", 54);
    freq.put("طعن", 12);
    freq.put("لمذ", 26);
    freq.put("لمر", 206);
    freq.put("لمز", 34);
    freq.put("لمس", 257);
    freq.put("لمش", 112);
    freq.put("طعم", 35);
    freq.put("لمض", 18);
    freq.put("لمط", 66);
    freq.put("لمب", 55);
    freq.put("لمة", 112);
    freq.put("لمت", 312);
    freq.put("لمث", 16);
    freq.put("لمج", 103);
    freq.put("لمح", 146);
    freq.put("لمخ", 49);
    freq.put("لمد", 147);
    freq.put("لمآ", 19);
    freq.put("لمؤ", 63);
    freq.put("لما", 460);
    freq.put("ن؟ ", 25);
    freq.put("صدق", 176);
    freq.put("صدف", 10);
    freq.put("رك ", 506);
    freq.put("صده", 10);
    freq.put("صدم", 25);
    freq.put("صدي", 123);
    freq.put("صدو", 28);
    freq.put("آ", 4606);
    freq.put("قدّ", 13);
    freq.put("قدو", 33);
    freq.put("قدي", 84);
    freq.put("صلا", 184);
    freq.put("صلت", 23);
    freq.put("وسه", 23);
    freq.put("قدك", 11);
    freq.put("قدم", 83);
    freq.put("قدن", 14);
    freq.put("صلح", 33);
    freq.put("صلِ", 14);
    freq.put("صلّ", 17);
    freq.put("آل ", 59);
    freq.put("قدر", 206);
    freq.put("قدس", 13);
    freq.put("رض ", 176);
    freq.put("صلك", 13);
    freq.put("قدت", 18);
    freq.put("صلن", 9);
    freq.put("صله", 16);
    freq.put("صلي", 66);
    freq.put("صلو", 33);
    freq.put("صلى", 91);
    freq.put("ﻤ", 74);
    freq.put("صدر", 95);
    freq.put("ناي", 54);
    freq.put("صرخ", 16);
    freq.put("قفل", 16);
    freq.put("صدا", 31);
    freq.put("كب ", 18);
    freq.put("طال", 136);
    freq.put("طاه", 11);
    freq.put("طان", 95);
    freq.put("طاف", 10);
    freq.put("طاق", 28);
    freq.put("طاو", 15);
    freq.put("طاي", 19);
    freq.put("ُه ", 25);
    freq.put("ـشـ", 12);
    freq.put("تطع", 24);
    freq.put("تطر", 13);
    freq.put("أقد", 26);
    freq.put("زما", 66);
    freq.put("تطب", 21);
    freq.put("أقس", 12);
    freq.put("بمن", 31);
    freq.put("أقر", 32);
    freq.put("قفو", 12);
    freq.put("أقص", 12);
    freq.put("لد ", 119);
    freq.put("تطا", 16);
    freq.put("بمش", 11);
    freq.put("أقل", 32);
    freq.put("ہُ ", 47);
    freq.put("مل", 1544);
    freq.put("بمع", 14);
    freq.put("تطو", 31);
    freq.put("تطي", 94);
    freq.put("بما", 139);
    freq.put("ألي", 26);
    freq.put("بمآ", 9);
    freq.put("بمح", 10);
    freq.put("بمد", 12);
    freq.put("تطل", 59);
    freq.put("تطم", 9);
    freq.put("خي ", 100);
    freq.put("طاء", 50);
    freq.put("بهد", 14);
    freq.put("طاح", 24);
    freq.put("طاب", 43);
    freq.put("طات", 15);
    freq.put("طار", 71);
    freq.put("شد ", 36);
    freq.put("طاع", 52);
    freq.put("فى ", 143);
    freq.put("لصب", 127);
    freq.put("ظنو", 10);
    freq.put("لصت", 15);
    freq.put("ظني", 13);
    freq.put("لصح", 56);
    freq.put("لصد", 80);
    freq.put("ظنك", 14);
    freq.put("غ ", 86);
    freq.put("رّب", 13);
    freq.put("لصع", 13);
    freq.put("لصغ", 16);
    freq.put("لصر", 26);
    freq.put("ظرة", 17);
    freq.put("ظرت", 10);
    freq.put("يحس", 29);
    freq.put("يحر", 17);
    freq.put("يحط", 13);
    freq.put("يحص", 10);
    freq.put("يحت", 57);
    freq.put("يحب", 72);
    freq.put("يحة", 40);
    freq.put("يحد", 17);
    freq.put("گم ", 9);
    freq.put("يحا", 42);
    freq.put("ظرو", 50);
    freq.put("ظري", 16);
    freq.put("ظرك", 14);
    freq.put("ععع", 27);
    freq.put("ظره", 29);
    freq.put("يحي", 33);
    freq.put("يحق", 13);
    freq.put("يحك", 22);
    freq.put(" آي", 38);
    freq.put("نه ", 781);
    freq.put("يحه", 22);
    freq.put("يحل", 14);
    freq.put("يحم", 29);
    freq.put("لصو", 101);
    freq.put("لصي", 50);
    freq.put("💠 ", 10);
    freq.put("لصَ", 23);
    freq.put("لصف", 37);
    freq.put("دير", 62);
    freq.put("ضا ", 47);
    freq.put("لصم", 63);
    freq.put("لصن", 13);
    freq.put("لصه", 10);
    freq.put("لصّ", 23);
    freq.put("ثق ", 32);
    freq.put("سع ", 29);
    freq.put("مص ", 11);
    freq.put("طق ", 35);
    freq.put("آنك", 19);
    freq.put("آنه", 14);
    freq.put("اآ ", 12);
    freq.put("تِ ", 66);
    freq.put("ـل ", 86);
    freq.put("ﺰ", 11);
    freq.put("آنآ", 23);
    freq.put("آنا", 35);
    freq.put("آنت", 52);
    freq.put("بكِ", 27);
    freq.put("آنس", 19);
    freq.put("ّح ", 12);
    freq.put("هزي", 9);
    freq.put("ضرب", 46);
    freq.put("ءء", 76);
    freq.put("جنہ", 11);
    freq.put("ضم ", 21);
    freq.put("ءا", 49);
    freq.put("احي", 111);
    freq.put("ءة", 28);
    freq.put("ُمر", 11);
    freq.put("ءت", 11);
    freq.put("هري", 51);
    freq.put("بكك", 37);
    freq.put("هره", 15);
    freq.put("هرن", 10);
    freq.put("هرم", 12);
    freq.put("🔲 ", 10);
    freq.put("ء،", 10);
    freq.put("له ", 3470);
    freq.put("ِسَ", 11);
    freq.put("هرة", 15);
    freq.put("هرب", 33);
    freq.put("هرا", 28);
    freq.put("ـمـ", 45);
    freq.put("إن ", 351);
    freq.put("تعج", 37);
    freq.put(" ﺂل", 31);
    freq.put("ءك", 13);
    freq.put("ءه", 14);
    freq.put("تعت", 36);
    freq.put("ءً", 17);
    freq.put("ُمِ", 9);
    freq.put("ءٍ", 10);
    freq.put("ءُ", 12);
    freq.put("ءَ", 28);
    freq.put("خشى", 20);
    freq.put("ءِ", 21);
    freq.put("ءْ", 18);
    freq.put("ُمَ", 29);
    freq.put("ُمك", 9);
    freq.put("فير", 32);
    freq.put("جنه", 53);
    freq.put("جنن", 17);
    freq.put("جنو", 75);
    freq.put("جني", 27);
    freq.put("سِو", 18);
    freq.put("وو ", 39);
    freq.put("جنّ", 20);
    freq.put("سِم", 11);
    freq.put(" أت", 136);
    freq.put(" أث", 27);
    freq.put(" أب", 345);
    freq.put("وذ ", 48);
    freq.put(" أخ", 260);
    freq.put(" أد", 103);
    freq.put(" أج", 216);
    freq.put(" أح", 657);
    freq.put("حون", 56);
    freq.put("حول", 87);
    freq.put("حوم", 9);
    freq.put(" أغ", 93);
    freq.put(" أظ", 12);
    freq.put(" أع", 315);
    freq.put(" أز", 25);
    freq.put(" أس", 372);
    freq.put(" أذ", 75);
    freq.put(" أر", 283);
    freq.put(" أض", 45);
    freq.put(" أط", 57);
    freq.put(" أش", 180);
    freq.put(" أص", 179);
    freq.put(" أي", 217);
    freq.put(" أو", 348);
    freq.put("نفع", 50);
    freq.put(" أَ", 106);
    freq.put(" أُ", 46);
    freq.put(" أق", 170);
    freq.put(" أك", 338);
    freq.put("نفذ", 9);
    freq.put(" أف", 142);
    freq.put(" أن", 1608);
    freq.put(" أه", 141);
    freq.put(" أل", 197);
    freq.put(" أم", 497);
    freq.put("نفت", 20);
    freq.put("نفج", 9);
    freq.put("نفا", 38);
    freq.put("جنا", 39);
    freq.put("زمن", 67);
    freq.put("جند", 18);
    freq.put("جنة", 120);
    freq.put("جنب", 35);
    freq.put("جنت", 13);
    freq.put("ّك ", 60);
    freq.put("صح ", 63);
    freq.put("جنس", 15);
    freq.put("ثقي", 20);
    freq.put("مخا", 25);
    freq.put("مخت", 22);
    freq.put("ثقه", 11);
    freq.put("ثقل", 19);
    freq.put("مخد", 11);
    freq.put("تعَ", 15);
    freq.put(" ⁰", 33);
    freq.put("مخط", 15);
    freq.put("رها", 197);
    freq.put("أل ", 69);
    freq.put("عسا", 21);
    freq.put("ﻟﻮ", 10);
    freq.put("فلو", 107);
    freq.put("عسر", 9);
    freq.put("ﻟﻤ", 17);
    freq.put("رغم", 48);
    freq.put("ﻟﻠ", 14);
    freq.put("عسي", 15);
    freq.put("ْسَ", 13);
    freq.put("ﻟﺘ", 11);
    freq.put("عسك", 20);
    freq.put("آحد", 33);
    freq.put("رغب", 34);
    freq.put("ِع ", 13);
    freq.put("به ", 598);
    freq.put("ثقت", 11);
    freq.put("ثقة", 15);
    freq.put("مخل", 20);
    freq.put("⭕⭕⭕", 10);
    freq.put("مخي", 23);
    freq.put("ثقا", 25);
    freq.put("رهُ", 11);
    freq.put("رهَ", 15);
    freq.put("ازم", 56);
    freq.put("رهي", 9);
    freq.put("رهو", 12);
    freq.put("رهه", 42);
    freq.put("ھہ", 13);
    freq.put("رهم", 92);
    freq.put(" يق", 411);
    freq.put("رهق", 14);
    freq.put(" ⃣", 31);
    freq.put("خَي", 17);
    freq.put("ُكَ", 26);
    freq.put("خَل", 19);
    freq.put("دَا", 25);
    freq.put("لھم", 14);
    freq.put("ُكِ", 26);
    freq.put("ھا", 29);
    freq.put(" آص", 17);
    freq.put("ى، ", 10);
    freq.put("يخ ", 112);
    freq.put("غى ", 24);
    freq.put(" ي ", 175);
    freq.put("خَا", 15);
    freq.put("ھٓ", 22);
    freq.put("ھو", 10);
    freq.put("كْ ", 21);
    freq.put("ھَ", 16);
    freq.put("خَط", 12);
    freq.put("ھم", 41);
    freq.put("رهہ", 20);
    freq.put("ضآ", 21);
    freq.put("َطِ", 9);
    freq.put("ية ", 1148);
    freq.put("ضا", 466);
    freq.put("ضب", 66);
    freq.put("ضة", 46);
    freq.put("ضت", 32);
    freq.put("ضج", 22);
    freq.put("ضح", 219);
    freq.put("ضد", 24);
    freq.put("ضر", 194);
    freq.put("امہ", 12);
    freq.put("ضط", 23);
    freq.put("جح ", 22);
    freq.put("ضع", 165);
    freq.put("ضغ", 26);
    freq.put(" ؟ ", 396);
    freq.put("ت", 30334);
    freq.put("دهر", 9);
    freq.put("هہَ", 23);
    freq.put("دها", 137);
    freq.put("عًا", 9);
    freq.put("دهُ", 19);
    freq.put("دهم", 96);
    freq.put("دهه", 14);
    freq.put("شهد", 64);
    freq.put("ضـ", 44);
    freq.put("ضف", 90);
    freq.put("ضك", 17);
    freq.put("ضل", 198);
    freq.put("ضم", 114);
    freq.put("ضن", 61);
    freq.put("ضه", 66);
    freq.put("ضو", 114);
    freq.put("ضى", 76);
    freq.put("ضي", 624);
    freq.put("وأ ", 12);
    freq.put("ضَ", 47);
    freq.put("ضُ", 37);
    freq.put("ضِ", 36);
    freq.put("ضّ", 18);
    freq.put("فجا", 17);
    freq.put("امِ", 20);
    freq.put("مرر", 11);
    freq.put("مرس", 34);
    freq.put("مرض", 50);
    freq.put("امك", 97);
    freq.put(" ا̄", 15);
    freq.put("امـ", 20);
    freq.put("امه", 113);
    freq.put("امن", 88);
    freq.put("امم", 12);
    freq.put("امل", 174);
    freq.put("امي", 239);
    freq.put("امى", 12);
    freq.put("امو", 64);
    freq.put("امُ", 17);
    freq.put("امَ", 25);
    freq.put("مرا", 184);
    freq.put("اخذ", 67);
    freq.put("اخر", 107);
    freq.put("اخط", 22);
    freq.put("ـور", 9);
    freq.put("ﮬ", 10);
    freq.put("نًا", 11);
    freq.put("ـوب", 14);
    freq.put("ـود", 12);
    freq.put("اخا", 19);
    freq.put("اخت", 246);
    freq.put("اخب", 31);
    freq.put("ـوا", 23);
    freq.put("اخِ", 19);
    freq.put("ط ", 630);
    freq.put("مظل", 18);
    freq.put("آق ", 15);
    freq.put("ـوي", 17);
    freq.put("رش ", 41);
    freq.put("اخي", 77);
    freq.put("ـوق", 11);
    freq.put("اخو", 90);
    freq.put("ﻚ", 24);
    freq.put("دهہ", 18);
    freq.put("ـون", 29);
    freq.put("ـوم", 25);
    freq.put("جأ", 42);
    freq.put("امس", 43);
    freq.put("مهن", 15);
    freq.put("امر", 94);
    freq.put("امش", 13);
    freq.put("مرّ", 18);
    freq.put("امع", 56);
    freq.put("طفو", 18);
    freq.put("مرو", 39);
    freq.put("مري", 172);
    freq.put("اما", 186);
    freq.put("ححي", 12);
    freq.put("امت", 133);
    freq.put("امة", 126);
    freq.put("امب", 12);
    freq.put("امد", 19);
    freq.put("امح", 61);
    freq.put("امج", 45);
    freq.put("ويص", 18);
    freq.put("ويش", 34);
    freq.put("ويط", 16);
    freq.put("طفل", 51);
    freq.put("وير", 61);
    freq.put("أسو", 31);
    freq.put("ويس", 80);
    freq.put("أسي", 11);
    freq.put("أسم", 39);
    freq.put("أسل", 31);
    freq.put("أسه", 14);
    freq.put("أسف", 30);
    freq.put("لخب", 22);
    freq.put("أسك", 13);
    freq.put("لخص", 13);
    freq.put("ويا", 96);
    freq.put("لخر", 28);
    freq.put("", 23);
    freq.put(" فر", 310);
    freq.put("ويج", 37);
    freq.put("ويد", 25);
    freq.put("ويخ", 18);
    freq.put("وية", 58);
    freq.put("ويب", 24);
    freq.put("ويت", 858);
    freq.put("إلآ", 17);
    freq.put("إلا", 319);
    freq.put("إلت", 16);
    freq.put("َحي", 13);
    freq.put("صـد", 16);
    freq.put("عِن", 21);
    freq.put("عِل", 10);
    freq.put("عِي", 22);
    freq.put(" نم", 49);
    freq.put("ﻃ", 11);
    freq.put("إله", 116);
    freq.put("إلل", 12);
    freq.put("فُ ", 11);
    freq.put("إلي", 180);
    freq.put("إلى", 241);
    freq.put("إلّ", 10);
    freq.put("ﻠﻴ", 12);
    freq.put("صــ", 19);
    freq.put("لخم", 23);
    freq.put("لخل", 82);
    freq.put("أسد", 13);
    freq.put("لخن", 12);
    freq.put("لخف", 9);
    freq.put("أسب", 37);
    freq.put("أست", 147);
    freq.put("نصي", 77);
    freq.put("أسا", 42);
    freq.put("أسئ", 13);
    freq.put("لخو", 30);
    freq.put("أسأ", 43);
    freq.put("لخي", 186);
    freq.put("ويم", 21);
    freq.put("ويل", 108);
    freq.put("ويه", 84);
    freq.put("وين", 175);
    freq.put("أسع", 28);
    freq.put("ويـ", 40);
    freq.put("ويك", 25);
    freq.put("ويق", 41);
    freq.put("ويُ", 9);
    freq.put("أسر", 37);
    freq.put("ويو", 29);
    freq.put("ويي", 17);
    freq.put("جن", 498);
    freq.put("تسا", 118);
    freq.put("تسأ", 33);
    freq.put("تسج", 10);
    freq.put("تسح", 11);
    freq.put("تسب", 34);
    freq.put("تست", 179);
    freq.put("تسر", 16);
    freq.put("تسع", 38);
    freq.put("جمم", 9);
    freq.put("أند", 16);
    freq.put("أنت", 279);
    freq.put("أنث", 46);
    freq.put("أنب", 17);
    freq.put("ﺮ ", 25);
    freq.put("أنا", 330);
    freq.put("جف", 49);
    freq.put("أنآ", 14);
    freq.put("جَ", 125);
    freq.put(" ا ", 54);
    freq.put("أنع", 11);
    freq.put("لشَ", 9);
    freq.put("دم ", 181);
    freq.put("أنز", 10);
    freq.put("أنس", 30);
    freq.put("أنَ", 22);
    freq.put("ووي", 17);
    freq.put("أني", 98);
    freq.put("أنو", 26);
    freq.put("أنن", 46);
    freq.put("أنه", 167);
    freq.put("أنق", 11);
    freq.put("أنك", 74);
    freq.put("أنـ", 31);
    freq.put("أنف", 67);
    freq.put("جو", 496);
    freq.put("أنْ", 42);
    freq.put("أنّ", 58);
    freq.put("تسل", 63);
    freq.put("تسم", 109);
    freq.put("تسه", 18);
    freq.put("تسك", 22);
    freq.put("تسو", 55);
    freq.put("تسي", 15);
    freq.put("َر ", 31);
    freq.put("تسِ", 9);
    freq.put("سئل", 38);
    freq.put("ﻔ", 24);
    freq.put("مس ", 134);
    freq.put("فزي", 9);
    freq.put("حد ", 511);
    freq.put("نصح", 35);
    freq.put("نم ", 32);
    freq.put("بعا", 42);
    freq.put("بعب", 11);
    freq.put("بعة", 58);
    freq.put("بعت", 30);
    freq.put("بعث", 37);
    freq.put("بعد", 496);
    freq.put("بعر", 9);
    freq.put("تَ ", 108);
    freq.put("بعض", 266);
    freq.put("بعـ", 11);
    freq.put("بعك", 25);
    freq.put("بعم", 12);
    freq.put("بعن", 50);
    freq.put("بعه", 30);
    freq.put("بعو", 30);
    freq.put("ع ", 2702);
    freq.put("بعي", 311);
    freq.put("هق ", 11);
    freq.put("بعَ", 9);
    freq.put("فزع", 13);
    freq.put("َهِ", 13);
    freq.put("يٌ ", 20);
    freq.put("ياب", 152);
    freq.put("ياة", 175);
    freq.put("يات", 409);
    freq.put("ياج", 35);
    freq.put("جده", 23);
    freq.put("ياخ", 82);
    freq.put("ياد", 189);
    freq.put("جدي", 195);
    freq.put("ياء", 175);
    freq.put("جدو", 24);
    freq.put("َتَ", 22);
    freq.put("يائ", 21);
    freq.put("ياا", 101);
    freq.put("َتْ", 9);
    freq.put("لسج", 26);
    freq.put("لسح", 17);
    freq.put("لست", 64);
    freq.put("لسب", 50);
    freq.put("لسة", 11);
    freq.put("يار", 305);
    freq.put("ياز", 9);
    freq.put("ياس", 66);
    freq.put("ياش", 18);
    freq.put("تظر", 75);
    freq.put("ياض", 79);
    freq.put("ياط", 15);
    freq.put("آا ", 12);
    freq.put("يا،", 13);
    freq.put("🔰?", 9);
    freq.put("ﻣن", 16);
    freq.put("لف ", 275);
    freq.put("جدآ", 10);
    freq.put("ياي", 15);
    freq.put("ياً", 63);
    freq.put("جدا", 127);
    freq.put("جدت", 31);
    freq.put("ياق", 28);
    freq.put("جدة", 25);
    freq.put("يال", 286);
    freq.put("جدد", 23);
    freq.put("يان", 207);
    freq.put("ياه", 107);
    freq.put("لسَ", 26);
    freq.put("لسي", 106);
    freq.put("لسو", 112);
    freq.put("لسن", 90);
    freq.put("لسه", 41);
    freq.put("لسل", 129);
    freq.put("لسم", 115);
    freq.put("⁽", 9);
    freq.put("لظل", 19);
    freq.put("لسف", 38);
    freq.put("خول", 31);
    freq.put("كتب", 202);
    freq.put("خون", 34);
    freq.put("خوف", 48);
    freq.put("خوك", 11);
    freq.put("َى ", 88);
    freq.put("كتا", 105);
    freq.put("خوي", 33);
    freq.put("وي ", 348);
    freq.put("كتر", 27);
    freq.put("كتش", 30);
    freq.put("هِ ", 93);
    freq.put("فُو", 10);
    freq.put("ـتـ", 29);
    freq.put("وء ", 90);
    freq.put("فُس", 9);
    freq.put("فُر", 12);
    freq.put("ميا", 55);
    freq.put("كتي", 34);
    freq.put("خوا", 114);
    freq.put("كتُ", 15);
    freq.put("كتك", 14);
    freq.put("كتف", 33);
    freq.put("خوة", 14);
    freq.put("أس ", 53);
    freq.put("كتل", 9);
    freq.put("كتم", 23);
    freq.put("َرْ", 10);
    freq.put("تس ", 37);
    freq.put("َري", 12);
    freq.put("َرَ", 20);
    freq.put(" اض", 168);
    freq.put(" اط", 62);
    freq.put("دمع", 62);
    freq.put(" اص", 162);
    freq.put(" از", 27);
    freq.put(" اس", 787);
    freq.put(" اذ", 309);
    freq.put(" ار", 303);
    freq.put(" اغ", 116);
    freq.put("ﺬ", 13);
    freq.put("أن ", 849);
    freq.put(" اع", 329);
    freq.put(" اا", 109);
    freq.put("دمة", 28);
    freq.put(" اخ", 346);
    freq.put(" اد", 125);
    freq.put(" اج", 255);
    freq.put(" اح", 667);
    freq.put(" ات", 262);
    freq.put(" اث", 41);
    freq.put(" اب", 546);
    freq.put("طوب", 10);
    freq.put(" اِ", 19);
    freq.put("ر؟ ", 9);
    freq.put("ليس", 309);
    freq.put(" ان", 1947);
    freq.put(" اه", 169);
    freq.put(" ال", 23420);
    freq.put(" ام", 384);
    freq.put(" اق", 213);
    freq.put(" اك", 315);
    freq.put(" اف", 163);
    freq.put(" اَ", 40);
    freq.put(" اُ", 27);
    freq.put(" اي", 255);
    freq.put("دمن", 15);
    freq.put(" او", 282);
    freq.put("طوة", 16);
    freq.put("٧", 24);
    freq.put("ﻣن ", 13);
    freq.put("طأ ", 31);
    freq.put("هم ", 2076);
    freq.put("َرا", 9);
    freq.put("َرح", 17);
    freq.put("مسس", 10);
    freq.put("مسر", 15);
    freq.put("شــ", 25);
    freq.put("ﻦ ", 38);
    freq.put("حدت", 13);
    freq.put("حدة", 55);
    freq.put("مسؤ", 18);
    freq.put("حدد", 15);
    freq.put("مسح", 36);
    freq.put("مسج", 23);
    freq.put("حدا", 44);
    freq.put("مست", 207);
    freq.put("مسة", 14);
    freq.put("تَس", 14);
    freq.put("عو", 802);
    freq.put("تَر", 24);
    freq.put("عي", 1660);
    freq.put("اجح", 13);
    freq.put("عُ", 123);
    freq.put("تَش", 13);
    freq.put("عف", 134);
    freq.put("عـ", 191);
    freq.put("عك", 232);
    freq.put("عق", 218);
    freq.put("عم", 1042);
    freq.put("عل", 3919);
    freq.put("عه", 445);
    freq.put("عن", 1970);
    freq.put("اجع", 144);
    freq.put("تَا", 13);
    freq.put("نمس", 9);
    freq.put("ـنا", 12);
    freq.put("عّ", 38);
    freq.put("عِ", 109);
    freq.put("اجز", 14);
    freq.put("عْ", 26);
    freq.put("تَخ", 10);
    freq.put("تَح", 22);
    freq.put("تَج", 17);
    freq.put("عة", 361);
    freq.put("عب", 794);
    freq.put("اجي", 52);
    freq.put("عت", 551);
    freq.put("عج", 236);
    freq.put("عد", 1273);
    freq.put("اجـ", 16);
    freq.put("رفع", 86);
    freq.put("اجك", 16);
    freq.put("اجل", 94);
    freq.put("اجم", 91);
    freq.put("اجن", 11);
    freq.put("اجه", 118);
    freq.put("عع", 73);
    freq.put("تَق", 21);
    freq.put("تَف", 19);
    freq.put("تَه", 31);
    freq.put("تَن", 15);
    freq.put("تَم", 17);
    freq.put("تَل", 12);
    freq.put("عر", 945);
    freq.put("عذ", 132);
    freq.put("عس", 116);
    freq.put("عز", 210);
    freq.put("عص", 118);
    freq.put("عش", 396);
    freq.put("عط", 265);
    freq.put("عض", 295);
    freq.put(" ┃", 10);
    freq.put("ليت", 150);
    freq.put("ع،", 16);
    freq.put("ليح", 9);
    freq.put("حدّ", 20);
    freq.put("ﻭ", 92);
    freq.put("سطا", 10);
    freq.put("مسه", 10);
    freq.put("حدي", 117);
    freq.put("حدى", 16);
    freq.put("حدو", 35);
    freq.put("كبا", 12);
    freq.put("رار", 94);
    freq.put("حدٍ", 12);
    freq.put("مسـ", 9);
    freq.put("حدك", 26);
    freq.put("مسَ", 10);
    freq.put("حده", 138);
    freq.put("حدن", 25);
    freq.put("مسو", 54);
    freq.put("ﺂ", 110);
    freq.put("إعل", 30);
    freq.put("يا ", 1087);
    freq.put("ولع", 12);
    freq.put("لس ", 63);
    freq.put("لفل", 45);
    freq.put("لفن", 27);
    freq.put("لفه", 43);
    freq.put("لفق", 47);
    freq.put("لفك", 21);
    freq.put("عہ", 31);
    freq.put("لفَ", 13);
    freq.put("لفو", 87);
    freq.put(" ●", 17);
    freq.put("لفي", 81);
    freq.put("شف ", 49);
    freq.put("شَي", 21);
    freq.put("فَي", 9);
    freq.put("لفا", 92);
    freq.put("شَر", 12);
    freq.put(" ▪", 18);
    freq.put("لفة", 25);
    freq.put("لفت", 73);
    freq.put("لفش", 15);
    freq.put("لفص", 9);
    freq.put("لفض", 24);
    freq.put("ے", 10);
    freq.put("لفر", 171);
    freq.put("لفز", 13);
    freq.put("شَخ", 13);
    freq.put("لفع", 10);
    freq.put("جد ", 197);
    freq.put("َت ", 33);
    freq.put(" ▄", 30);
    freq.put("إعت", 13);
    freq.put("ليك", 363);
    freq.put("فري", 67);
    freq.put("مخ ", 9);
    freq.put("لشت", 10);
    freq.put("ءك ", 11);
    freq.put("تصا", 69);
    freq.put("تصب", 50);
    freq.put("تصد", 32);
    freq.put("تصح", 17);
    freq.put("تصر", 54);
    freq.put("ره ", 683);
    freq.put("ألا", 27);
    freq.put("ألب", 16);
    freq.put("رشل", 15);
    freq.put("ألت", 22);
    freq.put("بهَ", 9);
    freq.put("بهو", 9);
    freq.put("ﺐ", 16);
    freq.put("بهه", 10);
    freq.put("بهم", 104);
    freq.put("ألم", 95);
    freq.put("ألن", 23);
    freq.put("أله", 18);
    freq.put("ألف", 55);
    freq.put("ألق", 9);
    freq.put("ألك", 70);
    freq.put("ألو", 35);
    freq.put("بهذ", 20);
    freq.put("ِ", 3538);
    freq.put("بهة", 12);
    freq.put("رغ ", 9);
    freq.put("بها", 251);
    freq.put("بهآ", 17);
    freq.put("تصف", 24);
    freq.put("تصن", 18);
    freq.put("تصل", 42);
    freq.put("تصم", 16);
    freq.put("تصي", 17);
    freq.put("تصو", 52);
    freq.put("لٱ", 23);
    freq.put("سؤو", 20);
    freq.put("خدا", 22);
    freq.put("َوا", 14);
    freq.put("نک ", 10);
    freq.put("خدع", 13);
    freq.put("ھ ", 66);
    freq.put("سطر", 13);
    freq.put(" يُ", 214);
    freq.put(" يَ", 313);
    freq.put(" يو", 620);
    freq.put(" يي", 9);
    freq.put(" يم", 264);
    freq.put(" يل", 152);
    freq.put(" يه", 91);
    freq.put(" ين", 326);
    freq.put(" يف", 179);
    freq.put(" يـ", 52);
    freq.put(" يك", 296);
    freq.put("بهہ", 14);
    freq.put(" يع", 550);
    freq.put(" يظ", 26);
    freq.put(" يغ", 106);
    freq.put(" يص", 163);
    freq.put(" يش", 157);
    freq.put(" يط", 100);
    freq.put(" يض", 147);
    freq.put(" ير", 326);
    freq.put(" يذ", 39);
    freq.put(" يس", 537);
    freq.put(" يز", 46);
    freq.put(" يح", 312);
    freq.put(" يج", 281);
    freq.put(" يد", 235);
    freq.put(" يخ", 179);
    freq.put(" يب", 268);
    freq.put(" يث", 16);
    freq.put(" يت", 371);
    freq.put(" يؤ", 52);
    freq.put(" يا", 1302);
    freq.put("لحد", 81);
    freq.put(" يأ", 54);
    freq.put(" يآ", 54);
    freq.put("لحر", 139);
    freq.put("خدم", 49);
    freq.put("خده", 9);
    freq.put("فجأ", 24);
    freq.put("فجر", 50);
    freq.put("ض ", 717);
    freq.put("لرض", 24);
    freq.put("لرز", 15);
    freq.put("لرس", 46);
    freq.put("لرغ", 13);
    freq.put("طية", 10);
    freq.put("لرؤ", 11);
    freq.put("لرئ", 20);
    freq.put("لرا", 95);
    freq.put("لرأ", 12);
    freq.put("لرج", 116);
    freq.put("لرح", 97);
    freq.put("لرد", 26);
    freq.put("لرب", 29);
    freq.put("لرت", 30);
    freq.put("ي؟ ", 24);
    freq.put(" ؟؟", 51);
    freq.put("ّر ", 45);
    freq.put("طہ", 9);
    freq.put("ئ", 1528);
    freq.put("ية،", 14);
    freq.put("زله", 27);
    freq.put("وم ", 870);
    freq.put("ده ", 591);
    freq.put("لـه", 48);
    freq.put("ﻥ ", 39);
    freq.put("دَي", 10);
    freq.put("كار", 90);
    freq.put("لـل", 10);
    freq.put("لـك", 24);
    freq.put("حْ ", 9);
    freq.put("هہ ", 161);
    freq.put("لرّ", 14);
    freq.put("لــ", 103);
    freq.put("صفر", 11);
    freq.put("جحي", 10);
    freq.put("َط ", 15);
    freq.put("لرف", 9);
    freq.put("لرق", 19);
    freq.put("لرك", 9);
    freq.put("لرَ", 10);
    freq.put("لرو", 65);
    freq.put("لري", 89);
    freq.put("ثــ", 9);
    freq.put("رفض", 23);
    freq.put("،ان", 11);
    freq.put("،ال", 16);
    freq.put("لـي", 29);
    freq.put("رفا", 28);
    freq.put("مر ", 307);
    freq.put("رفة", 36);
    freq.put("حح ", 14);
    freq.put("رفت", 68);
    freq.put("طه", 102);
    freq.put("طن", 180);
    freq.put("طم", 87);
    freq.put("طل", 412);
    freq.put("طك", 13);
    freq.put("طق", 116);
    freq.put("طف", 224);
    freq.put("طـ", 40);
    freq.put("طَ", 34);
    freq.put("طي", 639);
    freq.put("طى", 12);
    freq.put("طو", 361);
    freq.put("رشه", 19);
    freq.put("اخ ", 20);
    freq.put("رفن", 24);
    freq.put("تٌ ", 10);
    freq.put("طّ", 20);
    freq.put("طِ", 39);
    freq.put("صفح", 48);
    freq.put("ـو ", 30);
    freq.put("رشي", 10);
    freq.put("طا", 676);
    freq.put("طئ", 38);
    freq.put("طأ", 46);
    freq.put("طآ", 26);
    freq.put("كام", 68);
    freq.put("طح", 29);
    freq.put("لـِ", 13);
    freq.put("طت", 33);
    freq.put("طة", 95);
    freq.put("طب", 215);
    freq.put("طط", 47);
    freq.put("طر", 527);
    freq.put("رشد", 12);
    freq.put("طع", 185);
    freq.put("💃?", 15);
    freq.put("زلا", 12);
    freq.put("رفه", 53);
    freq.put("ام ", 1140);
    freq.put("صفا", 26);
    freq.put("رفق", 20);
    freq.put("،اذ", 9);
    freq.put("رفو", 39);
    freq.put("رفي", 39);
  }
  
}

