package com.rmtheis.langdetect.profile;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

import java.util.HashMap;

public class BG {
  private static final String name = "bg";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public BG() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 585684;
    n_words[1] = 707061;
    n_words[2] = 569957;

    freq.put("Вил", 18);
    freq.put("Вик", 13);
    freq.put("Вин", 15);
    freq.put("Вие", 19);
    freq.put("Вид", 53);
    freq.put("Виж", 52);
    freq.put("пок", 168);
    freq.put("пол", 498);
    freq.put("пои", 27);
    freq.put("поп", 64);
    freq.put("пом", 186);
    freq.put("пон", 152);
    freq.put("пов", 262);
    freq.put("пог", 41);
    freq.put("поб", 87);
    freq.put("пож", 50);
    freq.put("поз", 140);
    freq.put("под", 416);
    freq.put("пое", 23);
    freq.put("пощ", 12);
    freq.put("поя", 22);
    freq.put(" Ав", 39);
    freq.put("пот", 106);
    freq.put("пор", 402);
    freq.put("пос", 359);
    freq.put("поч", 281);
    freq.put("пох", 18);
    freq.put("со ", 25);
    freq.put(" Аз", 121);
    freq.put("Вис", 22);
    freq.put("Вит", 19);
    freq.put(" Ай", 33);
    freq.put("ей ", 119);
    freq.put(" Ам", 90);
    freq.put("НЕ ", 49);
    freq.put("смя", 48);
    freq.put("смъ", 21);
    freq.put("сму", 8);
    freq.put("смо", 18);
    freq.put("сми", 71);
    freq.put("сме", 218);
    freq.put("сма", 37);
    freq.put("ИИ ", 9);
    freq.put("вча", 11);
    freq.put("езк", 14);
    freq.put("ези", 173);
    freq.put("езп", 55);
    freq.put("вче", 40);
    freq.put("езн", 46);
    freq.put("езв", 17);
    freq.put("еза", 62);
    freq.put("езе", 89);
    freq.put("езд", 63);
    freq.put("тъж", 12);
    freq.put("тъв", 10);
    freq.put("тъп", 131);
    freq.put("тън", 37);
    freq.put("тъм", 20);
    freq.put("тъл", 16);
    freq.put("тък", 95);
    freq.put("тъй", 12);
    freq.put("ам ", 1307);
    freq.put("Ю", 83);
    freq.put("лти", 20);
    freq.put("ФА ", 10);
    freq.put("лто", 8);
    freq.put("тъч", 24);
    freq.put("тът", 143);
    freq.put("тър", 517);
    freq.put("езу", 25);
    freq.put("езс", 9);
    freq.put("езр", 20);
    freq.put("Ве", 166);
    freq.put("Ва", 221);
    freq.put("Вн", 13);
    freq.put("Во", 41);
    freq.put("Ви", 274);
    freq.put("Вк", 14);
    freq.put("Вл", 36);
    freq.put("че ", 1271);
    freq.put("Ско", 12);
    freq.put("аоб", 9);
    freq.put("Скъ", 11);
    freq.put("ПА ", 10);
    freq.put("обу", 57);
    freq.put("Е ", 282);
    freq.put("Ене", 14);
    freq.put("Отк", 36);
    freq.put("Оти", 10);
    freq.put("Вр", 44);
    freq.put("Вс", 113);
    freq.put("Отн", 21);
    freq.put("Ву", 8);
    freq.put("Отв", 11);
    freq.put("Отб", 8);
    freq.put("Вя", 15);
    freq.put("Въ", 104);
    freq.put("Отд", 9);
    freq.put("общ", 144);
    freq.put("ъжк", 31);
    freq.put("оо ", 22);
    freq.put("Озн", 36);
    freq.put("За ", 158);
    freq.put("ня ", 175);
    freq.put(" Яп", 14);
    freq.put(" Ям", 8);
    freq.put(" Ян", 39);
    freq.put(" Як", 8);
    freq.put(" Яв", 11);
    freq.put("омб", 24);
    freq.put("ома", 155);
    freq.put("омв", 14);
    freq.put("оме", 280);
    freq.put("оми", 240);
    freq.put("омн", 79);
    freq.put("омп", 120);
    freq.put("омо", 176);
    freq.put("тищ", 32);
    freq.put("тиш", 23);
    freq.put("тия", 165);
    freq.put("тис", 54);
    freq.put("тир", 211);
    freq.put("тит", 394);
    freq.put("тих", 37);
    freq.put("тиф", 11);
    freq.put("тич", 144);
    freq.put("тиц", 81);
    freq.put("тий", 16);
    freq.put("тии", 24);
    freq.put("тил", 85);
    freq.put("тик", 153);
    freq.put("тин", 294);
    freq.put("тим", 92);
    freq.put("тип", 19);
    freq.put("тиг", 84);
    freq.put("тив", 264);
    freq.put("тие", 103);
    freq.put("тид", 29);
    freq.put("тиз", 11);
    freq.put("омс", 10);
    freq.put("ому", 25);
    freq.put("омч", 44);
    freq.put("омя", 14);
    freq.put("ЕТ ", 11);
    freq.put("де ", 423);
    freq.put("зет", 12);
    freq.put("зер", 42);
    freq.put("зех", 14);
    freq.put("ю ", 71);
    freq.put("зен", 64);
    freq.put("зем", 114);
    freq.put("ът ", 686);
    freq.put("лял", 10);
    freq.put("ляк", 17);
    freq.put("лян", 65);
    freq.put("лям", 125);
    freq.put("ляб", 12);
    freq.put("ляг", 19);
    freq.put("ляв", 99);
    freq.put("ляд", 12);
    freq.put("ляз", 79);
    freq.put("ърш", 106);
    freq.put("ии ", 238);
    freq.put("ърс", 144);
    freq.put("ърт", 108);
    freq.put("ърх", 59);
    freq.put("ърц", 80);
    freq.put("Тол", 13);
    freq.put("Ток", 15);
    freq.put("Той", 26);
    freq.put("Топ", 21);
    freq.put("Тон", 12);
    freq.put("Том", 14);
    freq.put("Тов", 79);
    freq.put("Тоз", 23);
    freq.put("Тод", 18);
    freq.put("х", 3735);
    freq.put("Тот", 15);
    freq.put("Тор", 10);
    freq.put("ря ", 138);
    freq.put("ъри", 45);
    freq.put("ърл", 51);
    freq.put("ърк", 64);
    freq.put("ърн", 132);
    freq.put("ърм", 9);
    freq.put("ърп", 38);
    freq.put("ърб", 29);
    freq.put("ъра", 69);
    freq.put("ърг", 46);
    freq.put("ърв", 324);
    freq.put("ърд", 72);
    freq.put("ърз", 107);
    freq.put("ърж", 199);
    freq.put("ляш", 14);
    freq.put("уще", 8);
    freq.put("ляс", 9);
    freq.put("ляр", 25);
    freq.put("лят", 149);
    freq.put("Ви ", 33);
    freq.put("чет", 329);
    freq.put("чес", 278);
    freq.put("чер", 271);
    freq.put("чех", 10);
    freq.put("по ", 884);
    freq.put("чеш", 10);
    freq.put("соф", 50);
    freq.put("соц", 36);
    freq.put("соч", 21);
    freq.put("сор", 30);
    freq.put("сот", 26);
    freq.put("соз", 11);
    freq.put("соа", 9);
    freq.put("соб", 75);
    freq.put("сов", 169);
    freq.put("сон", 18);
    freq.put("соп", 8);
    freq.put("сок", 68);
    freq.put("сол", 32);
    freq.put("чев", 113);
    freq.put("чеб", 9);
    freq.put("чез", 20);
    freq.put("мвр", 65);
    freq.put("чел", 113);
    freq.put("чен", 340);
    freq.put("Шеф", 12);
    freq.put("Шес", 9);
    freq.put("ейб", 14);
    freq.put("ейв", 9);
    freq.put("ейд", 19);
    freq.put("ейл", 68);
    freq.put("ейк", 42);
    freq.put("ейн", 60);
    freq.put("ейм", 27);
    freq.put("тьо", 29);
    freq.put("ТЕ ", 49);
    freq.put("их ", 247);
    freq.put("см ", 8);
    freq.put("ейс", 186);
    freq.put("ейт", 70);
    freq.put("ейц", 16);
    freq.put("ез ", 385);
    freq.put("Дян", 20);
    freq.put("Дяд", 10);
    freq.put("аме", 593);
    freq.put("амб", 21);
    freq.put("ама", 371);
    freq.put("амп", 74);
    freq.put("амо", 350);
    freq.put("амн", 10);
    freq.put("амк", 8);
    freq.put("ами", 185);
    freq.put("аму", 10);
    freq.put("амс", 23);
    freq.put("амр", 9);
    freq.put("амя", 9);
    freq.put("амъ", 22);
    freq.put("Ню ", 9);
    freq.put("В ", 312);
    freq.put("ао ", 13);
    freq.put("Оба", 20);
    freq.put("Обз", 13);
    freq.put("Обе", 13);
    freq.put("Ех", 16);
    freq.put("Обл", 33);
    freq.put("Оби", 21);
    freq.put("Ес", 10);
    freq.put("Ер", 11);
    freq.put("Ет", 54);
    freq.put("Ен", 28);
    freq.put("Ем", 29);
    freq.put("Обр", 9);
    freq.put("Ей", 17);
    freq.put("Ел", 52);
    freq.put("Ек", 35);
    freq.put("Ед", 98);
    freq.put("Общ", 38);
    freq.put("Еб", 10);
    freq.put("Обя", 39);
    freq.put("Ег", 13);
    freq.put("Ев", 136);
    freq.put("От ", 94);
    freq.put("Защ", 65);
    freq.put("Зар", 17);
    freq.put("езо", 74);
    freq.put("ооп", 9);
    freq.put("ооо", 26);
    freq.put("ткр", 104);
    freq.put("Шу", 21);
    freq.put("ткъ", 18);
    freq.put("ооб", 15);
    freq.put("Ши", 14);
    freq.put("Шо", 26);
    freq.put("тка", 155);
    freq.put("Шв", 12);
    freq.put("тко", 53);
    freq.put("Ша", 36);
    freq.put("ткл", 8);
    freq.put("тки", 64);
    freq.put("Зам", 15);
    freq.put("Зап", 51);
    freq.put("Зак", 15);
    freq.put("Зал", 9);
    freq.put("Зад", 13);
    freq.put("Япо", 12);
    freq.put("Заб", 31);
    freq.put("Зав", 9);
    freq.put("Заг", 68);
    freq.put("Ще ", 81);
    freq.put(" Я ", 17);
    freq.put("няк", 348);
    freq.put("З", 797);
    freq.put("ням", 336);
    freq.put("няг", 14);
    freq.put("няв", 87);
    freq.put("ом ", 101);
    freq.put("ти ", 1251);
    freq.put("нят", 102);
    freq.put("тче", 26);
    freq.put("деи", 17);
    freq.put("СЕ ", 18);
    freq.put("дек", 43);
    freq.put("дел", 291);
    freq.put("дем", 54);
    freq.put("ден", 855);
    freq.put("део", 173);
    freq.put("деп", 31);
    freq.put("деа", 19);
    freq.put("деб", 46);
    freq.put("дев", 26);
    freq.put("узе", 11);
    freq.put("деж", 61);
    freq.put("цио", 190);
    freq.put("ъту", 23);
    freq.put("ътр", 28);
    freq.put("ътя", 17);
    freq.put("Гър", 39);
    freq.put("ции", 132);
    freq.put("юр", 37);
    freq.put("юс", 31);
    freq.put("ют", 95);
    freq.put("меч", 32);
    freq.put("юц", 19);
    freq.put("юч", 123);
    freq.put("Таз", 22);
    freq.put("ебр", 9);
    freq.put("Тай", 14);
    freq.put("Так", 25);
    freq.put("Тан", 10);
    freq.put("Тат", 8);
    freq.put("циа", 163);
    freq.put("юк", 14);
    freq.put("зе ", 63);
    freq.put("юм", 13);
    freq.put("юн", 49);
    freq.put("юа", 8);
    freq.put("юб", 195);
    freq.put("юв", 8);
    freq.put("юд", 39);
    freq.put("юж", 11);
    freq.put("юз", 31);
    freq.put("ъте", 12);
    freq.put("ътн", 40);
    freq.put("ъти", 44);
    freq.put("деш", 35);
    freq.put("дещ", 42);
    freq.put("дея", 39);
    freq.put("дер", 89);
    freq.put("дес", 97);
    freq.put("дет", 187);
    freq.put("деф", 10);
    freq.put("дец", 81);
    freq.put("иии", 24);
    freq.put("ужн", 18);
    freq.put("ля ", 224);
    freq.put("То ", 18);
    freq.put("ужд", 74);
    freq.put("иит", 77);
    freq.put("ър ", 432);
    freq.put("лбу", 106);
    freq.put("ков", 412);
    freq.put("коб", 16);
    freq.put("коа", 12);
    freq.put("коз", 25);
    freq.put("кож", 22);
    freq.put("кое", 135);
    freq.put("код", 20);
    freq.put("кол", 500);
    freq.put("кок", 38);
    freq.put("кой", 436);
    freq.put("кои", 237);
    freq.put("коп", 37);
    freq.put("кон", 360);
    freq.put("ком", 237);
    freq.put("ящо", 14);
    freq.put("ик ", 333);
    freq.put("ящи", 30);
    freq.put("яща", 10);
    freq.put("от ", 1996);
    freq.put("ия ", 3003);
    freq.put("еце", 30);
    freq.put("кот", 205);
    freq.put("Игр", 8);
    freq.put("кор", 178);
    freq.put("коч", 16);
    freq.put("кох", 34);
    freq.put("коф", 13);
    freq.put("лби", 16);
    freq.put("коя", 122);
    freq.put("лбо", 8);
    freq.put("имп", 76);
    freq.put("имо", 94);
    freq.put("имн", 51);
    freq.put("имк", 261);
    freq.put("ими", 189);
    freq.put("име", 180);
    freq.put("имв", 10);
    freq.put("имб", 8);
    freq.put("има", 743);
    freq.put("оря", 71);
    freq.put("оръ", 97);
    freq.put("орч", 10);
    freq.put("орц", 17);
    freq.put("орс", 77);
    freq.put("ору", 29);
    freq.put("орт", 233);
    freq.put("исш", 15);
    freq.put("исъ", 82);
    freq.put("ися", 10);
    freq.put("ист", 770);
    freq.put("ису", 22);
    freq.put("иси", 95);
    freq.put("иск", 392);
    freq.put("исл", 210);
    freq.put("исм", 12);
    freq.put("Це", 92);
    freq.put("исо", 127);
    freq.put("исп", 24);
    freq.put("иса", 135);
    freq.put("исв", 35);
    freq.put("исе", 26);
    freq.put("орн", 91);
    freq.put("орм", 144);
    freq.put("орп", 12);
    freq.put("оро", 140);
    freq.put("ори", 672);
    freq.put("орл", 12);
    freq.put("орк", 48);
    freq.put("оре", 346);
    freq.put("орд", 86);
    freq.put("орб", 25);
    freq.put("ора", 522);
    freq.put("орг", 82);
    freq.put("иму", 30);
    freq.put("имс", 15);
    freq.put("уло", 14);
    freq.put("Щ ", 64);
    freq.put("пка", 65);
    freq.put("пки", 27);
    freq.put("ее ", 82);
    freq.put("ст ", 598);
    freq.put("рги", 86);
    freq.put("рго", 38);
    freq.put("ью", 10);
    freq.put("рга", 170);
    freq.put("рге", 26);
    freq.put("мед", 75);
    freq.put("ДО ", 9);
    freq.put("щ", 3758);
    freq.put("зум", 13);
    freq.put("Юго", 9);
    freq.put("мей", 54);
    freq.put("ьо", 153);
    freq.put("ълн", 131);
    freq.put("ебе", 125);
    freq.put("цир", 20);
    freq.put("мео", 12);
    freq.put("──", 34);
    freq.put("егу", 15);
    freq.put("вук", 8);
    freq.put("егр", 18);
    freq.put("егъ", 8);
    freq.put("вув", 10);
    freq.put("я ", 4575);
    freq.put("йк ", 20);
    freq.put("уля", 19);
    freq.put("еше", 253);
    freq.put("сро", 17);
    freq.put("еша", 27);
    freq.put("ешо", 8);
    freq.put("сра", 24);
    freq.put("ешн", 85);
    freq.put("ешк", 68);
    freq.put("еши", 52);
    freq.put("сре", 276);
    freq.put("абр", 96);
    freq.put("Ска", 16);
    freq.put("еге", 11);
    freq.put("ега", 222);
    freq.put("его", 114);
    freq.put("егн", 22);
    freq.put("вуч", 22);
    freq.put("егл", 75);
    freq.put("вус", 16);
    freq.put("еги", 71);
    freq.put("П ", 104);
    freq.put("П", 2300);
    freq.put("Соз", 11);
    freq.put("Сол", 9);
    freq.put("Соф", 220);
    freq.put("хха", 9);
    freq.put("Аме", 25);
    freq.put("Ама", 43);
    freq.put("Ами", 17);
    freq.put("ов ", 764);
    freq.put("КО ", 20);
    freq.put("Жал", 9);
    freq.put(" гл", 317);
    freq.put(" ги", 164);
    freq.put(" го", 1184);
    freq.put(" гн", 11);
    freq.put(" га", 139);
    freq.put(" ге", 73);
    freq.put("оан", 8);
    freq.put("оал", 33);
    freq.put("ЕО ", 38);
    freq.put("Вт", 18);
    freq.put("це ", 67);
    freq.put(" он", 67);
    freq.put("оар", 11);
    freq.put("рс ", 54);
    freq.put(" оп", 234);
    freq.put(" гъ", 42);
    freq.put(" об", 714);
    freq.put(" гу", 32);
    freq.put(" гр", 427);
    freq.put("ике", 28);
    freq.put("икд", 18);
    freq.put("ика", 627);
    freq.put("икв", 20);
    freq.put("икн", 39);
    freq.put("ико", 272);
    freq.put("ики", 63);
    freq.put("икл", 35);
    freq.put("ящ ", 10);
    freq.put("ко ", 1156);
    freq.put("отъ", 38);
    freq.put("отя", 26);
    freq.put("оту", 13);
    freq.put("отт", 9);
    freq.put("отс", 44);
    freq.put("отр", 70);
    freq.put("отч", 20);
    freq.put("ият", 1056);
    freq.put("Хри", 25);
    freq.put("иян", 62);
    freq.put("отл", 45);
    freq.put("отк", 184);
    freq.put("оти", 317);
    freq.put("отп", 42);
    freq.put("ото", 1227);
    freq.put("отн", 178);
    freq.put("отм", 15);
    freq.put("отг", 50);
    freq.put("отв", 155);
    freq.put("отб", 74);
    freq.put("ота", 281);
    freq.put("отз", 9);
    freq.put("оте", 242);
    freq.put("отд", 43);
    freq.put("икс", 24);
    freq.put("икр", 20);
    freq.put("ику", 152);
    freq.put("икт", 22);
    freq.put("икъ", 31);
    freq.put("Л", 613);
    freq.put("им ", 421);
    freq.put("пин", 22);
    freq.put("пио", 38);
    freq.put("пий", 24);
    freq.put("пик", 17);
    freq.put("пил", 52);
    freq.put("пие", 33);
    freq.put("пиз", 20);
    freq.put("пиа", 23);
    freq.put("пив", 15);
    freq.put("пия", 47);
    freq.put("пиш", 112);
    freq.put("пих", 20);
    freq.put("пиц", 10);
    freq.put("пич", 26);
    freq.put("пир", 84);
    freq.put("пис", 189);
    freq.put("пит", 232);
    freq.put("Ц ", 31);
    freq.put("ис ", 126);
    freq.put("Що", 17);
    freq.put("Ща", 10);
    freq.put("Ще", 86);
    freq.put("Ман", 33);
    freq.put("Мал", 46);
    freq.put("Мак", 26);
    freq.put("Май", 55);
    freq.put("Мад", 18);
    freq.put("Маг", 26);
    freq.put("рба", 64);
    freq.put(" от", 2617);
    freq.put("рбе", 8);
    freq.put("рби", 44);
    freq.put(" ох", 13);
    freq.put("рбо", 14);
    freq.put(" оф", 114);
    freq.put("очн", 161);
    freq.put("Юна", 15);
    freq.put("Мая", 9);
    freq.put("Мат", 8);
    freq.put("Мас", 15);
    freq.put("Мар", 156);
    freq.put("еен", 13);
    freq.put("еем", 10);
    freq.put("вхо", 12);
    freq.put("еее", 44);
    freq.put("ста", 1206);
    freq.put("ств", 734);
    freq.put("сте", 331);
    freq.put("сти", 812);
    freq.put("рг ", 13);
    freq.put("стл", 29);
    freq.put("стн", 170);
    freq.put("сто", 630);
    freq.put("стр", 701);
    freq.put(" Ба", 216);
    freq.put("стт", 101);
    freq.put("сту", 80);
    freq.put("стъ", 206);
    freq.put("стя", 34);
    freq.put("дн", 1344);
    freq.put("Джи", 11);
    freq.put("Дже", 41);
    freq.put("ееш", 8);
    freq.put("йка", 93);
    freq.put("де", 2713);
    freq.put("йки", 60);
    freq.put("йко", 66);
    freq.put("Джа", 19);
    freq.put("ян", 390);
    freq.put("ям", 595);
    freq.put("ял", 212);
    freq.put("як", 557);
    freq.put("яй", 25);
    freq.put("яз", 117);
    freq.put("яж", 15);
    freq.put("Ист", 28);
    freq.put("яд", 187);
    freq.put("яг", 93);
    freq.put("яв", 641);
    freq.put("яб", 231);
    freq.put(" Тр", 158);
    freq.put("Сиг", 11);
    freq.put(" Ту", 80);
    freq.put("еш ", 216);
    freq.put("Сил", 38);
    freq.put("Сим", 44);
    freq.put("Син", 23);
    freq.put("Сит", 15);
    freq.put("Сир", 20);
    freq.put("яя", 14);
    freq.put("Иск", 43);
    freq.put("Люл", 10);
    freq.put("ящ", 69);
    freq.put("Исп", 32);
    freq.put("яц", 10);
    freq.put("ях", 251);
    freq.put("ят", 2047);
    freq.put("яс", 175);
    freq.put("яр", 89);
    freq.put("Ели", 14);
    freq.put("йкъ", 11);
    freq.put("Ако", 133);
    freq.put("ябъ", 8);
    freq.put("Акт", 13);
    freq.put(" Бр", 86);
    freq.put("Ей ", 14);
    freq.put(" ба", 296);
    freq.put(" бг", 12);
    freq.put(" бе", 584);
    freq.put(" би", 417);
    freq.put(" бл", 174);
    freq.put(" бо", 270);
    freq.put("дви", 78);
    freq.put("овл", 9);
    freq.put("овк", 67);
    freq.put("ови", 627);
    freq.put("ово", 525);
    freq.put("овн", 128);
    freq.put("овг", 17);
    freq.put("ова", 1186);
    freq.put("ове", 873);
    freq.put("овд", 75);
    freq.put("в", 25070);
    freq.put("др", 654);
    freq.put(" Бя", 15);
    freq.put("овъ", 32);
    freq.put("овя", 52);
    freq.put("овт", 30);
    freq.put("овс", 57);
    freq.put("овр", 22);
    freq.put("овц", 20);
    freq.put(" бр", 184);
    freq.put(" бу", 118);
    freq.put(" бъ", 423);
    freq.put(" бю", 34);
    freq.put(" бя", 96);
    freq.put("рст", 43);
    freq.put("рсъ", 8);
    freq.put("рся", 36);
    freq.put(" г ", 142);
    freq.put("цет", 55);
    freq.put("цер", 44);
    freq.put("цес", 29);
    freq.put("цед", 17);
    freq.put("цев", 9);
    freq.put("цеп", 43);
    freq.put("цен", 280);
    freq.put("цел", 72);
    freq.put("рса", 33);
    freq.put("рсе", 56);
    freq.put("рси", 131);
    freq.put("рск", 330);
    freq.put("рсо", 24);
    freq.put(" ем", 36);
    freq.put("Наз", 9);
    freq.put("Над", 47);
    freq.put(" еп", 37);
    freq.put(" ей", 23);
    freq.put(" ек", 101);
    freq.put(" ел", 59);
    freq.put(" ед", 546);
    freq.put("Нап", 47);
    freq.put("Нам", 13);
    freq.put(" ез", 37);
    freq.put("Нак", 8);
    freq.put("Нал", 12);
    freq.put("Наи", 9);
    freq.put("Най", 118);
    freq.put("оже", 489);
    freq.put("ожд", 61);
    freq.put("фор", 122);
    freq.put("ожб", 16);
    freq.put("фот", 35);
    freq.put("ожн", 75);
    freq.put("ожи", 102);
    freq.put("Да ", 128);
    freq.put("хо", 611);
    freq.put("ЕМ ", 10);
    freq.put("ям ", 68);
    freq.put("ябв", 210);
    freq.put("фов", 10);
    freq.put("фон", 135);
    freq.put("фол", 36);
    freq.put("фок", 8);
    freq.put("Нац", 37);
    freq.put("Нач", 9);
    freq.put("Нау", 8);
    freq.put("Нар", 16);
    freq.put("Нас", 21);
    freq.put(" еф", 29);
    freq.put(" ер", 14);
    freq.put(" ес", 36);
    freq.put("Наш", 12);
    freq.put("аса", 170);
    freq.put("асе", 66);
    freq.put("аси", 241);
    freq.put("аск", 62);
    freq.put("асл", 53);
    freq.put("асн", 101);
    freq.put("асо", 86);
    freq.put("асп", 18);
    freq.put("шив", 11);
    freq.put("км ", 11);
    freq.put("шил", 21);
    freq.put("шин", 26);
    freq.put("шим", 11);
    freq.put("гир", 10);
    freq.put("гис", 37);
    freq.put("У", 293);
    freq.put("гич", 42);
    freq.put("гия", 85);
    freq.put(" Та", 111);
    freq.put(" ру", 72);
    freq.put("гие", 15);
    freq.put("гий", 12);
    freq.put("гин", 49);
    freq.put("гио", 20);
    freq.put("гип", 13);
    freq.put("шит", 68);
    freq.put("шир", 11);
    freq.put("уро", 45);
    freq.put("ших", 23);
    freq.put("шиш", 10);
    freq.put("шия", 67);
    freq.put(" Ти", 47);
    freq.put("аст", 539);
    freq.put("асу", 46);
    freq.put("рхи", 15);
    freq.put("асъ", 14);
    freq.put("нзи", 41);
    freq.put("рха", 14);
    freq.put("ася", 38);
    freq.put("лея", 9);
    freq.put("Изп", 13);
    freq.put("Изк", 9);
    freq.put("Изл", 15);
    freq.put("яхн", 12);
    freq.put("яхм", 8);
    freq.put("леч", 70);
    freq.put("лец", 11);
    freq.put("лех", 16);
    freq.put("яха", 59);
    freq.put("Изв", 23);
    freq.put("лет", 289);
    freq.put("лес", 65);
    freq.put("лер", 62);
    freq.put("зга", 11);
    freq.put("згл", 68);
    freq.put("зго", 54);
    freq.put("згр", 33);
    freq.put("кче", 15);
    freq.put("оц ", 8);
    freq.put(" Г ", 15);
    freq.put("ио ", 84);
    freq.put("леп", 31);
    freq.put("лен", 605);
    freq.put("лем", 161);
    freq.put("лел", 33);
    freq.put("лек", 229);
    freq.put("лей", 97);
    freq.put("лез", 84);
    freq.put("леж", 114);
    freq.put("лее", 13);
    freq.put("лед", 827);
    freq.put("лег", 92);
    freq.put("лев", 216);
    freq.put("леб", 11);
    freq.put("иат", 33);
    freq.put("иар", 18);
    freq.put(" Вс", 113);
    freq.put(" Вр", 44);
    freq.put(" Ву", 8);
    freq.put(" Вт", 17);
    freq.put(" Вя", 15);
    freq.put(" Въ", 104);
    freq.put("сац", 9);
    freq.put("КС ", 16);
    freq.put("офь", 18);
    freq.put("офр", 16);
    freq.put("офт", 19);
    freq.put("офи", 385);
    freq.put("офо", 11);
    freq.put("офа", 31);
    freq.put("офе", 64);
    freq.put(" Ве", 165);
    freq.put(" Ва", 221);
    freq.put(" Вн", 10);
    freq.put(" Во", 41);
    freq.put(" Ви", 272);
    freq.put(" Вл", 36);
    freq.put(" Вк", 14);
    freq.put("иал", 198);
    freq.put("иан", 99);
    freq.put("иам", 9);
    freq.put("иад", 15);
    freq.put("бг ", 12);
    freq.put("Ит", 33);
    freq.put("Ир", 26);
    freq.put("Ис", 111);
    freq.put("хор", 209);
    freq.put("хот", 84);
    freq.put("Тру", 8);
    freq.put("иха", 246);
    freq.put("ихв", 9);
    freq.put("ихм", 27);
    freq.put("ихн", 17);
    freq.put("ихо", 33);
    freq.put("ре ", 343);
    freq.put("Тря", 24);
    freq.put("Тра", 44);
    freq.put("Тре", 21);
    freq.put("ихт", 25);
    freq.put("Три", 41);
    freq.put("Тро", 17);
    freq.put("хов", 27);
    freq.put("ход", 179);
    freq.put("хол", 50);
    freq.put("хом", 9);
    freq.put("Ик", 22);
    freq.put("Ил", 41);
    freq.put("Им", 112);
    freq.put("Ин", 137);
    freq.put("Ив", 75);
    freq.put("Иг", 18);
    freq.put("Из", 168);
    freq.put("Ид", 18);
    freq.put("Мон", 29);
    freq.put("Мом", 24);
    freq.put("Мол", 18);
    freq.put("Мод", 12);
    freq.put("Мож", 44);
    freq.put("рзе", 10);
    freq.put("рзв", 8);
    freq.put("рза", 32);
    freq.put("рзо", 34);
    freq.put("рзи", 32);
    freq.put("ец ", 153);
    freq.put("ДК ", 10);
    freq.put("ме ", 901);
    freq.put("еб ", 63);
    freq.put("Моя", 14);
    freq.put("Мос", 11);
    freq.put("Мор", 18);
    freq.put("ои", 500);
    freq.put("ой", 929);
    freq.put("ок", 1053);
    freq.put("ол", 2617);
    freq.put("ом", 1310);
    freq.put("он", 1948);
    freq.put("оо", 95);
    freq.put("оп", 857);
    freq.put("оа", 80);
    freq.put("об", 1980);
    freq.put("ов", 4498);
    freq.put("ог", 1348);
    freq.put("од", 2087);
    freq.put("ое", 416);
    freq.put("ож", 829);
    freq.put("оз", 662);
    freq.put("ефа", 35);
    freq.put("сфе", 14);
    freq.put("ефе", 52);
    freq.put("ефи", 33);
    freq.put("ефо", 70);
    freq.put("к", 20377);
    freq.put("ху ", 46);
    freq.put("ефт", 10);
    freq.put("ефъ", 9);
    freq.put("ош", 181);
    freq.put("ощ", 417);
    freq.put("вям", 24);
    freq.put("вян", 24);
    freq.put("оя", 551);
    freq.put("ор", 3024);
    freq.put("ос", 1969);
    freq.put("вяв", 60);
    freq.put("оу", 108);
    freq.put("оф", 577);
    freq.put("ох", 151);
    freq.put("оц", 167);
    freq.put("оч", 660);
    freq.put("ймс", 14);
    freq.put("зел", 56);
    freq.put(" Ел", 51);
    freq.put("руш", 26);
    freq.put("Лил", 12);
    freq.put("Лип", 13);
    freq.put("рут", 19);
    freq.put("Лив", 14);
    freq.put("рус", 86);
    freq.put("На ", 144);
    freq.put(" Ег", 13);
    freq.put(" е ", 2276);
    freq.put("збя", 19);
    freq.put("збу", 14);
    freq.put("збр", 50);
    freq.put("яма", 459);
    freq.put("збо", 62);
    freq.put("яме", 19);
    freq.put("зби", 92);
    freq.put("ями", 12);
    freq.put("збе", 49);
    freq.put("ямо", 30);
    freq.put("рук", 35);
    freq.put("ълч", 15);
    freq.put("руп", 62);
    freq.put("рум", 47);
    freq.put("рун", 12);
    freq.put("рув", 37);
    freq.put("руг", 176);
    freq.put("Лит", 10);
    freq.put("руб", 12);
    freq.put("руж", 24);
    freq.put("руд", 81);
    freq.put("кме", 24);
    freq.put("ши ", 131);
    freq.put("кмо", 13);
    freq.put("ас ", 312);
    freq.put("СП ", 42);
    freq.put("Гръ", 12);
    freq.put("Гру", 12);
    freq.put("ги ", 352);
    freq.put("Гри", 34);
    freq.put("Гра", 35);
    freq.put("Гре", 10);
    freq.put("дго", 14);
    freq.put("лга", 637);
    freq.put("лго", 22);
    freq.put("лги", 15);
    freq.put("иор", 20);
    freq.put("иот", 42);
    freq.put(" Ау", 9);
    freq.put(" Ат", 36);
    freq.put(" Ас", 28);
    freq.put(" Ар", 78);
    freq.put(" Ах", 14);
    freq.put(" Аф", 11);
    freq.put("Дес", 27);
    freq.put("Дет", 15);
    freq.put("ях ", 147);
    freq.put("Дец", 10);
    freq.put("ж", 4024);
    freq.put("Ти ", 23);
    freq.put("оце", 64);
    freq.put("оци", 89);
    freq.put(" Аг", 20);
    freq.put("Дей", 15);
    freq.put("АЛ ", 17);
    freq.put("Дел", 13);
    freq.put("Дем", 10);
    freq.put("Ден", 37);
    freq.put("Деп", 12);
    freq.put(" Ал", 86);
    freq.put(" Ак", 160);
    freq.put("Дев", 17);
    freq.put(" Ап", 47);
    freq.put(" Ан", 145);
    freq.put("ле ", 110);
    freq.put("уя ", 8);
    freq.put("иог", 10);
    freq.put("ъръ", 20);
    freq.put("иод", 12);
    freq.put("иоз", 36);
    freq.put("иол", 17);
    freq.put("ион", 349);
    freq.put("пде", 9);
    freq.put("цин", 20);
    freq.put("иум", 10);
    freq.put("с ", 3092);
    freq.put("оф ", 17);
    freq.put("иа ", 12);
    freq.put(" В ", 219);
    freq.put("рем", 420);
    freq.put("рен", 412);
    freq.put("рео", 13);
    freq.put("реп", 120);
    freq.put("реи", 16);
    freq.put("рей", 44);
    freq.put("рек", 250);
    freq.put("рел", 59);
    freq.put("ред", 1043);
    freq.put("рее", 9);
    freq.put("реж", 95);
    freq.put("рез", 353);
    freq.put("реа", 52);
    freq.put("реб", 97);
    freq.put("рев", 186);
    freq.put("рег", 89);
    freq.put("чни", 160);
    freq.put("чно", 202);
    freq.put("чна", 157);
    freq.put("чне", 19);
    freq.put("рея", 9);
    freq.put("реш", 177);
    freq.put("рещ", 227);
    freq.put("реф", 27);
    freq.put("рех", 35);
    freq.put("рец", 86);
    freq.put("реч", 43);
    freq.put("рер", 14);
    freq.put("рес", 384);
    freq.put("рет", 142);
    freq.put("ВР ", 28);
    freq.put("И ", 538);
    freq.put("хо ", 19);
    freq.put("мер", 261);
    freq.put("мес", 213);
    freq.put("мет", 297);
    freq.put("ебъ", 25);
    freq.put("вст", 61);
    freq.put("ебя", 9);
    freq.put("ебю", 9);
    freq.put("меш", 19);
    freq.put("вся", 60);
    freq.put("всъ", 20);
    freq.put("фа ", 43);
    freq.put("еци", 83);
    freq.put("ецк", 10);
    freq.put("ецо", 8);
    freq.put("еца", 141);
    freq.put("сце", 24);
    freq.put("фьо", 19);
    freq.put("ецъ", 8);
    freq.put("цид", 14);
    freq.put("еби", 60);
    freq.put("все", 210);
    freq.put("ебн", 47);
    freq.put("мее", 9);
    freq.put("меж", 79);
    freq.put("ебо", 10);
    freq.put("еба", 54);
    freq.put("мек", 18);
    freq.put("мел", 32);
    freq.put("вск", 142);
    freq.put("мен", 799);
    freq.put("вси", 240);
    freq.put("йон", 25);
    freq.put("Фут", 66);
    freq.put("о ", 12465);
    freq.put("хла", 20);
    freq.put("Сме", 16);
    freq.put("еф ", 23);
    freq.put("худ", 12);
    freq.put("хуб", 84);
    freq.put("циг", 32);
    freq.put("Офи", 20);
    freq.put("вя ", 93);
    freq.put("мс ", 23);
    freq.put(" Н ", 13);
    freq.put("йот", 8);
    freq.put("Че", 188);
    freq.put("Ча", 54);
    freq.put("Чо", 21);
    freq.put("Чи", 20);
    freq.put("апи", 134);
    freq.put("йм ", 9);
    freq.put("Чу", 34);
    freq.put("Дун", 11);
    freq.put("Еги", 8);
    freq.put("йви", 8);
    freq.put("йва", 10);
    freq.put("од ", 195);
    freq.put("Но ", 34);
    freq.put("фи ", 30);
    freq.put("век", 132);
    freq.put("вел", 84);
    freq.put("ъоб", 42);
    freq.put("вей", 41);
    freq.put("вен", 525);
    freq.put("веж", 60);
    freq.put("вез", 39);
    freq.put("вед", 136);
    freq.put("вее", 34);
    freq.put("КИ ", 78);
    freq.put("Йо", 49);
    freq.put("Йе", 9);
    freq.put("о", 46688);
    freq.put("веш", 16);
    freq.put("вещ", 25);
    freq.put("вея", 22);
    freq.put("вет", 570);
    freq.put("вер", 230);
    freq.put("вес", 127);
    freq.put("вец", 29);
    freq.put("веч", 490);
    freq.put("ахм", 32);
    freq.put("ахн", 9);
    freq.put("ахо", 53);
    freq.put("ахи", 10);
    freq.put("нгъ", 10);
    freq.put("Лош", 15);
    freq.put("ахл", 10);
    freq.put("аха", 367);
    freq.put("ахв", 8);
    freq.put("нгр", 13);
    freq.put("муз", 64);
    freq.put("мун", 32);
    freq.put("мул", 38);
    freq.put("пяв", 12);
    freq.put("пя", 112);
    freq.put("пю", 33);
    freq.put("пъ", 654);
    freq.put("пч", 21);
    freq.put("пц", 25);
    freq.put("пф", 19);
    freq.put("пу", 405);
    freq.put("пт", 147);
    freq.put("пс", 84);
    freq.put("пр", 4227);
    freq.put("по", 4215);
    freq.put("пн", 69);
    freq.put("пл", 569);
    freq.put("пк", 96);
    freq.put("пи", 1096);
    freq.put("пе", 995);
    freq.put("пд", 9);
    freq.put("пв", 45);
    freq.put("па", 1487);
    freq.put("пях", 9);
    freq.put("пяс", 15);
    freq.put("пят", 21);
    freq.put("ки ", 1856);
    freq.put("АН ", 11);
    freq.put("мус", 23);
    freq.put("нго", 17);
    freq.put("Лон", 25);
    freq.put("Лок", 13);
    freq.put("нги", 12);
    freq.put("Лоз", 11);
    freq.put("нге", 38);
    freq.put("ус ", 86);
    freq.put("Лов", 11);
    freq.put("ахт", 34);
    freq.put("нга", 34);
    freq.put("яст", 73);
    freq.put("ясъ", 21);
    freq.put("Д", 1622);
    freq.put("ууу", 18);
    freq.put("зпо", 82);
    freq.put("якв", 10);
    freq.put("зпи", 63);
    freq.put("зпл", 57);
    freq.put("яко", 346);
    freq.put("зпа", 22);
    freq.put("яки", 8);
    freq.put("зпъ", 47);
    freq.put("якъ", 33);
    freq.put("зпр", 87);
    freq.put("зпу", 13);
    freq.put("шва", 39);
    freq.put("ив ", 157);
    freq.put("ясн", 68);
    freq.put("яск", 8);
    freq.put("пло", 77);
    freq.put("па ", 179);
    freq.put(" са", 1013);
    freq.put(" сб", 22);
    freq.put(" св", 436);
    freq.put(" сг", 33);
    freq.put(" сд", 19);
    freq.put(" се", 2528);
    freq.put("идр", 9);
    freq.put("идя", 54);
    freq.put(" ск", 223);
    freq.put(" сл", 620);
    freq.put(" см", 322);
    freq.put(" сн", 306);
    freq.put(" со", 139);
    freq.put(" сп", 560);
    freq.put(" Че", 186);
    freq.put("ич ", 59);
    freq.put("кув", 158);
    freq.put("кум", 33);
    freq.put("кун", 11);
    freq.put("куп", 114);
    freq.put("кук", 18);
    freq.put("кул", 68);
    freq.put("кух", 20);
    freq.put("куч", 60);
    freq.put("кур", 113);
    freq.put("кус", 84);
    freq.put("кут", 16);
    freq.put("куш", 12);
    freq.put(" Жа", 17);
    freq.put("л ", 1565);
    freq.put(" Же", 47);
    freq.put(" Жи", 34);
    freq.put(" Жо", 10);
    freq.put(" ср", 294);
    freq.put("идж", 29);
    freq.put("иде", 355);
    freq.put(" су", 141);
    freq.put("идв", 45);
    freq.put(" сц", 22);
    freq.put("ида", 69);
    freq.put("идо", 26);
    freq.put("идн", 22);
    freq.put("иди", 139);
    freq.put("пва", 44);
    freq.put("Кли", 18);
    freq.put("Кла", 14);
    freq.put("бти", 9);
    freq.put("зче", 24);
    freq.put("мут", 16);
    freq.put("зчи", 24);
    freq.put("жен", 367);
    freq.put("есп", 18);
    freq.put("Ми ", 10);
    freq.put("есо", 38);
    freq.put("беб", 28);
    freq.put("рла", 62);
    freq.put("бед", 136);
    freq.put("без", 266);
    freq.put("рле", 22);
    freq.put("бел", 137);
    freq.put("бек", 19);
    freq.put("бен", 106);
    freq.put("бем", 11);
    freq.put("щин", 67);
    freq.put("щие", 8);
    freq.put("ет ", 314);
    freq.put("нгл", 60);
    freq.put("дюн", 8);
    freq.put("ахх", 10);
    freq.put("ДЖ ", 15);
    freq.put("щия", 58);
    freq.put("щит", 108);
    freq.put("ахр", 10);
    freq.put("бес", 20);
    freq.put("бер", 83);
    freq.put("бет", 40);
    freq.put("бещ", 25);
    freq.put("беш", 121);
    freq.put("рля", 19);
    freq.put("фо", 369);
    freq.put("А", 1259);
    freq.put(" зр", 28);
    freq.put("уде", 95);
    freq.put("Нов", 297);
    freq.put(" зъ", 27);
    freq.put("фия", 247);
    freq.put("оди", 579);
    freq.put("одк", 66);
    freq.put("одн", 155);
    freq.put("одм", 9);
    freq.put("одп", 36);
    freq.put("одо", 106);
    freq.put("взи", 14);
    freq.put("фиц", 64);
    freq.put("одг", 16);
    freq.put("одв", 9);
    freq.put("оде", 176);
    freq.put("фит", 28);
    freq.put("фис", 65);
    freq.put("фир", 66);
    freq.put("лък", 37);
    freq.put("въз", 159);
    freq.put("ве", 2938);
    freq.put("вз", 126);
    freq.put("взр", 19);
    freq.put("фин", 98);
    freq.put("одъ", 92);
    freq.put("фил", 112);
    freq.put("фик", 28);
    freq.put("фий", 18);
    freq.put("физ", 11);
    freq.put("одр", 26);
    freq.put("оду", 58);
    freq.put("одх", 20);
    freq.put("въп", 70);
    freq.put(" зд", 77);
    freq.put(" зе", 85);
    freq.put(" зв", 72);
    freq.put(" за", 4069);
    freq.put("вн", 552);
    freq.put("Нор", 12);
    freq.put(" зн", 227);
    freq.put("вън", 80);
    freq.put(" зи", 34);
    freq.put("неф", 8);
    freq.put("неч", 8);
    freq.put("нец", 37);
    freq.put("нес", 416);
    freq.put("нер", 155);
    freq.put("неу", 15);
    freq.put("аун", 21);
    freq.put("въл", 24);
    freq.put("ве ", 359);
    freq.put("нещ", 244);
    freq.put("ауз", 11);
    freq.put("ауд", 11);
    freq.put("шка", 69);
    freq.put("мво", 9);
    freq.put("шки", 74);
    freq.put("мск", 40);
    freq.put("Й ", 31);
    freq.put("яка", 137);
    freq.put("мст", 20);
    freq.put("рче", 41);
    freq.put("рча", 8);
    freq.put(" й ", 37);
    freq.put("нее", 9);
    freq.put("нед", 101);
    freq.put("нез", 40);
    freq.put("неж", 30);
    freq.put("неб", 19);
    freq.put("нег", 89);
    freq.put("нев", 162);
    freq.put("аут", 20);
    freq.put("нем", 70);
    freq.put("неп", 37);
    freq.put("нео", 26);
    freq.put("ней", 17);
    freq.put("ауч", 39);
    freq.put("нел", 61);
    freq.put("нек", 51);
    freq.put("кис", 14);
    freq.put("кир", 52);
    freq.put("кит", 366);
    freq.put("киф", 14);
    freq.put("му ", 174);
    freq.put("кия", 273);
    freq.put("йт ", 52);
    freq.put("уст", 119);
    freq.put("ах ", 359);
    freq.put("зни", 136);
    freq.put("пя ", 39);
    freq.put("зна", 469);
    freq.put("зне", 107);
    freq.put("зну", 28);
    freq.put("п ", 328);
    freq.put("усл", 54);
    freq.put("уск", 147);
    freq.put("уси", 83);
    freq.put("усп", 94);
    freq.put("усо", 11);
    freq.put("усн", 125);
    freq.put("усм", 35);
    freq.put("лзи", 14);
    freq.put("уса", 29);
    freq.put("усе", 109);
    freq.put("нг ", 71);
    freq.put("кив", 29);
    freq.put("кие", 11);
    freq.put("щта", 11);
    freq.put("кил", 23);
    freq.put("кин", 61);
    freq.put("кип", 33);
    freq.put("вс", 737);
    freq.put("ивя", 16);
    freq.put("ивш", 37);
    freq.put("ивъ", 24);
    freq.put("вър", 453);
    freq.put("ивс", 8);
    freq.put(" Дя", 35);
    freq.put(" Дъ", 47);
    freq.put(" Ду", 38);
    freq.put(" Др", 43);
    freq.put("як ", 13);
    freq.put("Цен", 70);
    freq.put("Цел", 12);
    freq.put("Цец", 8);
    freq.put(" До", 345);
    freq.put(" Дн", 110);
    freq.put(" Ди", 126);
    freq.put(" Дж", 135);
    freq.put(" Де", 178);
    freq.put(" Дв", 72);
    freq.put("АП ", 11);
    freq.put(" Да", 247);
    freq.put("ивн", 110);
    freq.put("иво", 210);
    freq.put("иви", 145);
    freq.put("ивл", 9);
    freq.put("ивк", 70);
    freq.put("иве", 128);
    freq.put("уу ", 15);
    freq.put(" с ", 1602);
    freq.put("пад", 174);
    freq.put("паз", 101);
    freq.put("пав", 12);
    freq.put("пам", 23);
    freq.put("пан", 154);
    freq.put("пак", 151);
    freq.put("пал", 73);
    freq.put("Кни", 8);
    freq.put("ку ", 28);
    freq.put("Ч", 374);
    freq.put("лу", 605);
    freq.put("лт", 179);
    freq.put("лс", 216);
    freq.put("лр", 15);
    freq.put("лч", 46);
    freq.put("лц", 20);
    freq.put("ичи", 52);
    freq.put("лф", 23);
    freq.put("лъ", 271);
    freq.put("лш", 32);
    freq.put("ля", 880);
    freq.put("лю", 376);
    freq.put("ича", 193);
    freq.put("ль", 22);
    freq.put("лг", 687);
    freq.put("лв", 199);
    freq.put("лб", 163);
    freq.put("ла", 2736);
    freq.put("лз", 96);
    freq.put("лж", 123);
    freq.put("ле", 3235);
    freq.put("лд", 49);
    freq.put("лк", 894);
    freq.put("ли", 4568);
    freq.put("лп", 13);
    freq.put("ло", 1527);
    freq.put("лн", 1178);
    freq.put("лм", 90);
    freq.put("зхо", 26);
    freq.put("пац", 9);
    freq.put("пач", 13);
    freq.put("пар", 372);
    freq.put("пас", 101);
    freq.put("пат", 89);
    freq.put("паш", 12);
    freq.put("хме", 71);
    freq.put("ид ", 60);
    freq.put(" Д ", 26);
    freq.put("Мих", 15);
    freq.put("Мит", 15);
    freq.put("Мис", 29);
    freq.put("Мир", 20);
    freq.put("Миш", 14);
    freq.put("бза", 24);
    freq.put("Муз", 14);
    freq.put("мич", 94);
    freq.put("мит", 189);
    freq.put("Мин", 61);
    freq.put("Мил", 45);
    freq.put("щи ", 184);
    freq.put(" си", 1543);
    freq.put("ете", 631);
    freq.put("сък", 38);
    freq.put("съл", 44);
    freq.put("съм", 394);
    freq.put("сън", 55);
    freq.put("съо", 42);
    freq.put("съп", 15);
    freq.put("съб", 143);
    freq.put("съв", 90);
    freq.put("съг", 21);
    freq.put("съд", 106);
    freq.put("съе", 13);
    freq.put("съж", 38);
    freq.put("съз", 53);
    freq.put("същ", 117);
    freq.put("етч", 9);
    freq.put("етр", 90);
    freq.put("етс", 57);
    freq.put("съю", 11);
    freq.put("ету", 10);
    freq.put("сър", 58);
    freq.put("със", 280);
    freq.put("сът", 53);
    freq.put("етя", 49);
    freq.put("съц", 14);
    freq.put("съч", 8);
    freq.put("мбо", 18);
    freq.put("мби", 22);
    freq.put("мба", 14);
    freq.put("рне", 106);
    freq.put("бли", 250);
    freq.put("рна", 291);
    freq.put("бло", 60);
    freq.put("рно", 208);
    freq.put("бла", 129);
    freq.put("рни", 184);
    freq.put("бле", 137);
    freq.put("щом", 9);
    freq.put("И", 1059);
    freq.put("Хор", 26);
    freq.put("Хот", 28);
    freq.put("Тъй", 8);
    freq.put("Тър", 49);
    freq.put("Хол", 16);
    freq.put("щот", 146);
    freq.put("блъ", 16);
    freq.put("бля", 9);
    freq.put("блю", 14);
    freq.put("блу", 18);
    freq.put(" Ру", 138);
    freq.put(" Чу", 34);
    freq.put(" Ръ", 8);
    freq.put("мня", 36);
    freq.put("ДА ", 36);
    freq.put("мни", 99);
    freq.put("мно", 332);
    freq.put("мна", 46);
    freq.put("мне", 39);
    freq.put(" Ра", 237);
    freq.put(" Ре", 151);
    freq.put(" Ри", 46);
    freq.put(" Ро", 127);
    freq.put(" ст", 1187);
    freq.put(" сх", 11);
    freq.put(" сч", 14);
    freq.put(" съ", 1306);
    freq.put("ъм ", 690);
    freq.put("уир", 8);
    freq.put("уис", 8);
    freq.put("уит", 89);
    freq.put("м ", 3186);
    freq.put(" ся", 26);
    freq.put("уик", 26);
    freq.put(" л ", 9);
    freq.put("Еди", 40);
    freq.put("Нищ", 11);
    freq.put("Нис", 11);
    freq.put("ъко", 26);
    freq.put("ъкн", 9);
    freq.put("ъкм", 14);
    freq.put("ъкл", 15);
    freq.put("ъки", 9);
    freq.put(" ня", 641);
    freq.put("ъкв", 9);
    freq.put("ъка", 55);
    freq.put("Час", 19);
    freq.put("Сег", 24);
    freq.put("Фо ", 21);
    freq.put("го ", 864);
    freq.put(" не", 2097);
    freq.put(" на", 6942);
    freq.put("ач ", 62);
    freq.put(" но", 916);
    freq.put(" ни", 462);
    freq.put("ъкр", 12);
    freq.put("Нин", 11);
    freq.put("Ник", 87);
    freq.put("Ние", 17);
    freq.put("шал", 9);
    freq.put("с", 26807);
    freq.put("шап", 10);
    freq.put("шан", 24);
    freq.put("шам", 39);
    freq.put("шав", 41);
    freq.put("мян", 34);
    freq.put("яд ", 20);
    freq.put("€", 8);
    freq.put("Я", 125);
    freq.put("гаш", 14);
    freq.put("гащ", 10);
    freq.put("гар", 708);
    freq.put("гас", 113);
    freq.put("гат", 289);
    freq.put("Фит", 10);
    freq.put("гац", 9);
    freq.put("Чет", 31);
    freq.put("Фин", 12);
    freq.put("Чер", 60);
    freq.put("Фил", 9);
    freq.put("ган", 135);
    freq.put("Чех", 8);
    freq.put("ух ", 24);
    freq.put("гав", 41);
    freq.put("гад", 48);
    freq.put("газ", 112);
    freq.put("цьо", 9);
    freq.put("мят", 52);
    freq.put("мяс", 69);
    freq.put("ащо", 258);
    freq.put("мях", 21);
    freq.put("аща", 158);
    freq.put("шат", 97);
    freq.put("шар", 10);
    freq.put("шач", 14);
    freq.put("аще", 8);
    freq.put(" у ", 62);
    freq.put("зли", 125);
    freq.put("зло", 51);
    freq.put("лня", 25);
    freq.put("зла", 40);
    freq.put("зле", 59);
    freq.put("кс ", 110);
    freq.put(" И ", 201);
    freq.put("учи", 158);
    freq.put("лне", 43);
    freq.put("злъ", 14);
    freq.put("учн", 12);
    freq.put("зля", 13);
    freq.put("лна", 267);
    freq.put("лно", 348);
    freq.put("учв", 40);
    freq.put("уче", 118);
    freq.put("лни", 429);
    freq.put("ква", 263);
    freq.put("кво", 351);
    freq.put("кви", 90);
    freq.put("иж ", 32);
    freq.put(" хо", 356);
    freq.put(" хи", 87);
    freq.put(" хл", 31);
    freq.put(" хе", 37);
    freq.put(" ха", 242);
    freq.put(" хв", 55);
    freq.put(" Кю", 11);
    freq.put(" Къ", 92);
    freq.put("сби", 8);
    freq.put(" Ку", 111);
    freq.put("Зе", 37);
    freq.put("Зд", 85);
    freq.put("Зв", 16);
    freq.put("За", 486);
    freq.put("Зо", 11);
    freq.put("Зн", 23);
    freq.put("Зл", 28);
    freq.put("Зи", 11);
    freq.put("хи ", 27);
    freq.put(" Кн", 11);
    freq.put(" Км", 10);
    freq.put("Рок", 10);
    freq.put(" Ки", 120);
    freq.put("сбу", 50);
    freq.put(" Ке", 26);
    freq.put("тах", 8);
    freq.put("бр ", 8);
    freq.put(" Ка", 503);
    freq.put("сбъ", 11);
    freq.put(" Ча", 54);
    freq.put("К ", 77);
    freq.put(" ху", 110);
    freq.put(" Чо", 21);
    freq.put("Рем", 8);
    freq.put("Рен", 11);
    freq.put("Реп", 8);
    freq.put("Рек", 12);
    freq.put("Ред", 15);
    freq.put("Рез", 17);
    freq.put("Реа", 18);
    freq.put("Рев", 8);
    freq.put("рн ", 9);
    freq.put(" Чи", 19);
    freq.put("Рож", 25);
    freq.put("еро", 136);
    freq.put("ерп", 19);
    freq.put("ерм", 88);
    freq.put("ерн", 222);
    freq.put("ерк", 40);
    freq.put("ерл", 21);
    freq.put("ери", 443);
    freq.put("ерд", 16);
    freq.put("ере", 256);
    freq.put("ерв", 139);
    freq.put("ерг", 79);
    freq.put("ера", 321);
    freq.put("ью ", 10);
    freq.put("цис", 12);
    freq.put("еря", 74);
    freq.put("фът", 12);
    freq.put("еръ", 31);
    freq.put("ерц", 19);
    freq.put("ерф", 16);
    freq.put("ерт", 136);
    freq.put("еру", 14);
    freq.put("ерс", 121);
    freq.put("Реш", 8);
    freq.put("Реф", 15);
    freq.put("Рец", 8);
    freq.put("Еба", 8);
    freq.put(" Р ", 14);
    freq.put("Жа", 18);
    freq.put("Же", 47);
    freq.put("мн ", 10);
    freq.put("Жо", 10);
    freq.put("тад", 27);
    freq.put("─", 35);
    freq.put("Рос", 12);
    freq.put("беж", 12);
    freq.put("рли", 44);
    freq.put("рло", 11);
    freq.put("Жив", 27);
    freq.put("ме", 2858);
    freq.put("мв", 87);
    freq.put("мг", 8);
    freq.put("ма", 3407);
    freq.put("мб", 86);
    freq.put("мо", 1811);
    freq.put("мп", 306);
    freq.put("мм", 40);
    freq.put("мн", 563);
    freq.put("мк", 296);
    freq.put("мл", 150);
    freq.put("ми", 2416);
    freq.put(" лу", 39);
    freq.put("ъмн", 33);
    freq.put(" лю", 158);
    freq.put(" ля", 65);
    freq.put("жби", 35);
    freq.put("жба", 54);
    freq.put("Ше", 31);
    freq.put(" лв", 150);
    freq.put(" ла", 88);
    freq.put(" ле", 321);
    freq.put(" ли", 689);
    freq.put("вгр", 39);
    freq.put("вгу", 8);
    freq.put("мч", 59);
    freq.put("мф", 15);
    freq.put("мт", 10);
    freq.put("му", 392);
    freq.put("мр", 115);
    freq.put("мс", 91);
    freq.put("мя", 208);
    freq.put("мъ", 340);
    freq.put("жъл", 15);
    freq.put("шов", 9);
    freq.put("шок", 25);
    freq.put("ачъ", 13);
    freq.put("шоп", 9);
    freq.put("ък ", 237);
    freq.put("нбу", 11);
    freq.put("гот", 149);
    freq.put("Фор", 28);
    freq.put("гор", 217);
    freq.put("гос", 46);
    freq.put("год", 433);
    freq.put("гое", 22);
    freq.put("гов", 292);
    freq.put("Фон", 10);
    freq.put("тур", 208);
    freq.put("гон", 29);
    freq.put("гол", 197);
    freq.put("гои", 10);
    freq.put("шоу", 10);
    freq.put("аче", 181);
    freq.put("ачв", 10);
    freq.put("шоф", 11);
    freq.put("ача", 121);
    freq.put("ачо", 15);
    freq.put("жът", 15);
    freq.put("ачн", 16);
    freq.put("ачк", 58);
    freq.put("ачи", 191);
    freq.put("РД ", 8);
    freq.put("мя ", 16);
    freq.put("ша ", 115);
    freq.put("Че ", 11);
    freq.put("яди", 21);
    freq.put("ядк", 13);
    freq.put("ядо", 37);
    freq.put("яда", 37);
    freq.put("яде", 25);
    freq.put("ядр", 12);
    freq.put(" ку", 257);
    freq.put("уха", 36);
    freq.put("га ", 588);
    freq.put("ухо", 22);
    freq.put("ухн", 24);
    freq.put("ухл", 8);
    freq.put("ащ ", 27);
    freq.put("кде", 18);
    freq.put(" ук", 12);
    freq.put(" ул", 69);
    freq.put(" уи", 31);
    freq.put(" уп", 68);
    freq.put(" ум", 65);
    freq.put(" ун", 39);
    freq.put(" ув", 65);
    freq.put(" уб", 80);
    freq.put(" уж", 24);
    freq.put(" уд", 72);
    freq.put("ЕВ ", 10);
    freq.put(" Ит", 33);
    freq.put(" Ис", 111);
    freq.put("Цв", 77);
    freq.put("ксо", 14);
    freq.put("ксп", 27);
    freq.put("кск", 23);
    freq.put("кси", 79);
    freq.put("ксе", 23);
    freq.put("кса", 34);
    freq.put("т", 39060);
    freq.put("лн ", 59);
    freq.put("кст", 44);
    freq.put("ксу", 9);
    freq.put(" Ил", 39);
    freq.put(" Ик", 22);
    freq.put("сгр", 24);
    freq.put(" Ин", 136);
    freq.put(" Им", 112);
    freq.put(" Иг", 17);
    freq.put(" Ив", 75);
    freq.put(" Из", 167);
    freq.put(" Ид", 18);
    freq.put("ижи", 28);
    freq.put(" ут", 147);
    freq.put("ижа", 22);
    freq.put(" ур", 30);
    freq.put(" ус", 267);
    freq.put("иже", 36);
    freq.put(" уч", 157);
    freq.put(" ух", 14);
    freq.put("кв ", 45);
    freq.put("Кю", 11);
    freq.put("Къ", 92);
    freq.put("Кр", 113);
    freq.put("Ку", 111);
    freq.put("хич", 10);
    freq.put("хит", 39);
    freq.put("зсъ", 9);
    freq.put("хир", 9);
    freq.put("З ", 34);
    freq.put("хия", 10);
    freq.put("зст", 33);
    freq.put("бръ", 17);
    freq.put("бря", 19);
    freq.put("бри", 132);
    freq.put("бро", 199);
    freq.put("бра", 354);
    freq.put(" К ", 8);
    freq.put("бре", 189);
    freq.put("зсл", 39);
    freq.put("хип", 11);
    freq.put("хим", 16);
    freq.put("хил", 21);
    freq.put("Км", 10);
    freq.put("Кн", 11);
    freq.put("Ко", 443);
    freq.put("Ки", 120);
    freq.put("Кл", 44);
    freq.put("Ке", 26);
    freq.put("Ка", 504);
    freq.put("Кв", 13);
    freq.put("аб ", 9);
    freq.put(" че", 978);
    freq.put(" ча", 330);
    freq.put(" чо", 128);
    freq.put(" чи", 74);
    freq.put("х ", 943);
    freq.put("еон", 19);
    freq.put(" Му", 31);
    freq.put(" Мю", 12);
    freq.put(" Мъ", 52);
    freq.put(" Ме", 141);
    freq.put(" Ма", 430);
    freq.put(" Мо", 207);
    freq.put(" Мн", 65);
    freq.put(" Мл", 40);
    freq.put(" Ми", 226);
    freq.put("н ", 3717);
    freq.put(" чу", 218);
    freq.put(" чр", 20);
    freq.put("тчи", 10);
    freq.put("агл", 25);
    freq.put("аги", 129);
    freq.put("аго", 204);
    freq.put("агн", 17);
    freq.put("ага", 258);
    freq.put("аге", 39);
    freq.put("г", 8202);
    freq.put("Луд", 28);
    freq.put("еин", 14);
    freq.put(" Гл", 62);
    freq.put("Луи", 8);
    freq.put("Лук", 19);
    freq.put(" Го", 122);
    freq.put("Сре", 21);
    freq.put("агу", 44);
    freq.put("агр", 74);
    freq.put(" Га", 71);
    freq.put("азб", 119);
    freq.put("иба", 29);
    freq.put(" Т ", 10);
    freq.put("лче", 20);
    freq.put(" У", 290);
    freq.put(" Фу", 75);
    freq.put(" Фр", 55);
    freq.put("Бер", 47);
    freq.put("фре", 31);
    freq.put(" р ", 50);
    freq.put("фра", 31);
    freq.put("фро", 14);
    freq.put("фри", 21);
    freq.put(" Ъ", 8);
    freq.put("Пер", 45);
    freq.put(" Гъ", 41);
    freq.put("Без", 43);
    freq.put("Бел", 40);
    freq.put("Бен", 13);
    freq.put(" Фо", 97);
    freq.put(" Фи", 49);
    freq.put(" Гю", 9);
    freq.put(" Фе", 88);
    freq.put(" Фа", 41);
    freq.put("узи", 79);
    freq.put(" Гу", 22);
    freq.put(" Гр", 107);
    freq.put("тек", 79);
    freq.put("тел", 990);
    freq.put("теи", 9);
    freq.put("тей", 18);
    freq.put("тео", 14);
    freq.put("узп", 8);
    freq.put("тем", 125);
    freq.put("тен", 361);
    freq.put("тев", 38);
    freq.put("тег", 68);
    freq.put("теа", 17);
    freq.put("теб", 65);
    freq.put("теж", 39);
    freq.put("тез", 78);
    freq.put("тед", 19);
    freq.put("уза", 18);
    freq.put("теш", 8);
    freq.put("тет", 86);
    freq.put("тер", 376);
    freq.put("тес", 114);
    freq.put("теч", 23);
    freq.put("теф", 28);
    freq.put("тех", 49);
    freq.put("кт ", 83);
    freq.put("ук ", 164);
    freq.put("лтъ", 10);
    freq.put("умъ", 27);
    freq.put("лту", 26);
    freq.put("лтр", 16);
    freq.put("умр", 22);
    freq.put(" Г", 724);
    freq.put(" От", 228);
    freq.put("дме", 10);
    freq.put(" Л", 609);
    freq.put("дми", 115);
    freq.put("умн", 19);
    freq.put("умо", 14);
    freq.put("уми", 69);
    freq.put("уме", 88);
    freq.put("лта", 69);
    freq.put("ума", 79);
    freq.put("лте", 14);
    freq.put(" М", 1414);
    freq.put(" п ", 36);
    freq.put("вну", 10);
    freq.put("ъжи", 23);
    freq.put("ъжн", 15);
    freq.put("ъжа", 37);
    freq.put("ъже", 78);
    freq.put("ъжд", 39);
    freq.put("Рум", 24);
    freq.put("же ", 349);
    freq.put("ютъ", 27);
    freq.put("ютю", 13);
    freq.put("КА ", 82);
    freq.put("юто", 11);
    freq.put("ютн", 14);
    freq.put("ъ", 9547);
    freq.put("юте", 8);
    freq.put("Рус", 99);
    freq.put("ъжъ", 10);
    freq.put("вна", 133);
    freq.put("вне", 38);
    freq.put("вни", 208);
    freq.put("вно", 151);
    freq.put("дпр", 16);
    freq.put("взе", 85);
    freq.put("йти", 17);
    freq.put("йто", 172);
    freq.put("йта", 56);
    freq.put("йте", 231);
    freq.put("ода", 436);
    freq.put("пче", 14);
    freq.put("ОП ", 13);
    freq.put("нлъ", 17);
    freq.put("риш", 40);
    freq.put("нла", 49);
    freq.put("бая", 8);
    freq.put("йтъ", 21);
    freq.put("юл", 50);
    freq.put("ка ", 2048);
    freq.put("рис", 298);
    freq.put("хно", 40);
    freq.put(" Сл", 149);
    freq.put("хни", 41);
    freq.put("аба", 84);
    freq.put("абв", 11);
    freq.put("абе", 80);
    freq.put(" ч ", 37);
    freq.put("ПС ", 8);
    freq.put("аби", 99);
    freq.put("абл", 57);
    freq.put("абн", 11);
    freq.put("або", 369);
    freq.put("Стр", 59);
    freq.put("Сту", 21);
    freq.put("нх", 11);
    freq.put("нф", 118);
    freq.put("нч", 173);
    freq.put("нц", 389);
    freq.put("нс", 838);
    freq.put("нр", 22);
    freq.put("ну", 224);
    freq.put("нт", 1407);
    freq.put("нь", 52);
    freq.put("ня", 1090);
    freq.put("ню", 21);
    freq.put("нш", 23);
    freq.put("нъ", 110);
    freq.put("не", 4703);
    freq.put("нд", 567);
    freq.put("нз", 73);
    freq.put("нж", 14);
    freq.put("нб", 22);
    freq.put("на", 12234);
    freq.put("нг", 273);
    freq.put("нв", 59);
    freq.put("нн", 269);
    freq.put("зул", 22);
    freq.put("но", 4778);
    freq.put("ни", 6919);
    freq.put("нл", 72);
    freq.put("нк", 430);
    freq.put("Ста", 170);
    freq.put("Сте", 35);
    freq.put(" М ", 13);
    freq.put("Сти", 25);
    freq.put("Сто", 60);
    freq.put("тч ", 8);
    freq.put("абс", 20);
    freq.put("абу", 9);
    freq.put("абъ", 10);
    freq.put("рпи", 14);
    freq.put("аг ", 12);
    freq.put("рпе", 16);
    freq.put("Око", 11);
    freq.put("анб", 10);
    freq.put("рил", 144);
    freq.put("рик", 144);
    freq.put("рпя", 11);
    freq.put("рии", 31);
    freq.put("ЕР ", 10);
    freq.put("рпу", 13);
    freq.put("Път", 21);
    freq.put("рин", 224);
    freq.put("Пър", 76);
    freq.put(" Тя", 23);
    freq.put("рим", 135);
    freq.put(" Тъ", 71);
    freq.put("сьо", 8);
    freq.put("риг", 62);
    freq.put("риб", 60);
    freq.put("мпт", 32);
    freq.put("риа", 76);
    freq.put("мпю", 32);
    freq.put("баз", 22);
    freq.put("рие", 160);
    freq.put("дъж", 12);
    freq.put("дъл", 167);
    freq.put("дък", 27);
    freq.put("дън", 23);
    freq.put("дър", 209);
    freq.put("дът", 29);
    freq.put("дъх", 22);
    freq.put("ц", 3658);
    freq.put("дъщ", 11);
    freq.put(" к ", 33);
    freq.put("мпа", 76);
    freq.put("мпе", 26);
    freq.put("мпл", 27);
    freq.put("мпи", 81);
    freq.put("мпо", 16);
    freq.put("пря", 41);
    freq.put("одя", 45);
    freq.put(" Те", 125);
    freq.put("одс", 32);
    freq.put("виз", 86);
    freq.put(" Тв", 20);
    freq.put(" То", 279);
    freq.put("Пъл", 10);
    freq.put("виш", 53);
    freq.put("Нощ", 10);
    freq.put("юде", 10);
    freq.put("юдж", 20);
    freq.put("при", 841);
    freq.put(" зо", 26);
    freq.put("йди", 8);
    freq.put("йдж", 10);
    freq.put("йде", 104);
    freq.put("йда", 15);
    freq.put(" зл", 64);
    freq.put("укт", 65);
    freq.put("укр", 9);
    freq.put("укс", 18);
    freq.put("укц", 8);
    freq.put("М", 1414);
    freq.put("нет", 389);
    freq.put("цът", 9);
    freq.put("те ", 3941);
    freq.put("нея", 31);
    freq.put("неш", 69);
    freq.put("зра", 114);
    freq.put("уко", 13);
    freq.put("укв", 12);
    freq.put("ука", 109);
    freq.put("жон", 17);
    freq.put("Фр", 55);
    freq.put("впе", 14);
    freq.put(" пя", 17);
    freq.put(" пъ", 514);
    freq.put(" пт", 9);
    freq.put(" пу", 176);
    freq.put(" пр", 3448);
    freq.put(" пс", 21);
    freq.put("шко", 18);
    freq.put("фар", 23);
    freq.put("фан", 44);
    freq.put("фал", 31);
    freq.put("фак", 42);
    freq.put("фай", 10);
    freq.put("хът", 9);
    freq.put(" по", 3196);
    freq.put(" Ги", 12);
    freq.put(" пл", 313);
    freq.put(" пи", 324);
    freq.put("ИЦ ", 9);
    freq.put(" пе", 339);
    freq.put(" па", 645);
    freq.put("лт ", 14);
    freq.put("ум ", 163);
    freq.put("Вер", 14);
    freq.put("Вес", 20);
    freq.put("Веч", 28);
    freq.put("ъж ", 69);
    freq.put("рях", 22);
    freq.put("рят", 65);
    freq.put("жед", 11);
    freq.put("Юл", 14);
    freq.put("Юн", 22);
    freq.put("жеб", 15);
    freq.put("жем", 26);
    freq.put("Юг", 12);
    freq.put("жел", 86);
    freq.put("жей", 15);
    freq.put("жех", 8);
    freq.put("жет", 113);
    freq.put("жер", 34);
    freq.put("жес", 45);
    freq.put("БА ", 14);
    freq.put("РИ ", 21);
    freq.put("жеш", 63);
    freq.put("рян", 27);
    freq.put("ряк", 9);
    freq.put("рял", 18);
    freq.put("ряз", 17);
    freq.put("ряд", 26);
    freq.put("ряв", 68);
    freq.put("ряг", 14);
    freq.put("ряб", 211);
    freq.put("нно", 91);
    freq.put("нни", 102);
    freq.put("нна", 70);
    freq.put("Вел", 72);
    freq.put("Вен", 14);
    freq.put("каш", 67);
    freq.put("ап ", 17);
    freq.put("кас", 29);
    freq.put("кар", 285);
    freq.put("кау", 17);
    freq.put("кат", 1179);
    freq.put("ках", 33);
    freq.put("каф", 50);
    freq.put("кач", 94);
    freq.put("кац", 43);
    freq.put("гва", 30);
    freq.put("кай", 39);
    freq.put("каи", 13);
    freq.put("кал", 172);
    freq.put("как", 587);
    freq.put("кан", 284);
    freq.put("кам", 220);
    freq.put("кап", 43);
    freq.put("каб", 16);
    freq.put("кав", 47);
    freq.put("кад", 47);
    freq.put("каз", 346);
    freq.put("каж", 114);
    freq.put("ког", 226);
    freq.put("псв", 23);
    freq.put("пса", 16);
    freq.put("гус", 9);
    freq.put("гур", 100);
    freq.put("пси", 19);
    freq.put("аят", 37);
    freq.put("ОН ", 13);
    freq.put("цик", 15);
    freq.put("аяв", 15);
    freq.put("гум", 12);
    freq.put("гул", 10);
    freq.put("губ", 60);
    freq.put("гув", 11);
    freq.put("се ", 2130);
    freq.put("иля", 38);
    freq.put("РА ", 27);
    freq.put("нен", 319);
    freq.put(" О ", 26);
    freq.put("Шам", 11);
    freq.put("неи", 11);
    freq.put("туц", 8);
    freq.put("ае ", 76);
    freq.put("тус", 21);
    freq.put("тут", 10);
    freq.put("сли", 99);
    freq.put("сло", 82);
    freq.put("сла", 174);
    freq.put("сле", 501);
    freq.put("еор", 51);
    freq.put("еот", 11);
    freq.put("Гал", 13);
    freq.put("Ган", 8);
    freq.put("Габ", 13);
    freq.put("Газ", 15);
    freq.put("ю", 822);
    freq.put("еоб", 23);
    freq.put(" Ши", 14);
    freq.put("Гар", 9);
    freq.put("еок", 83);
    freq.put("зя ", 16);
    freq.put("еоп", 9);
    freq.put("слъ", 49);
    freq.put("сля", 79);
    freq.put("слу", 247);
    freq.put("тун", 10);
    freq.put("туи", 75);
    freq.put("туй", 10);
    freq.put("тук", 101);
    freq.put("тул", 10);
    freq.put("туд", 78);
    freq.put("туе", 12);
    freq.put("туа", 37);
    freq.put("тув", 46);
    freq.put("азд", 47);
    freq.put("азе", 26);
    freq.put("азв", 255);
    freq.put("азг", 50);
    freq.put("аза", 282);
    freq.put("еду", 31);
    freq.put("азо", 52);
    freq.put("азп", 81);
    freq.put("азм", 45);
    freq.put("азн", 176);
    freq.put("азк", 73);
    freq.put("азл", 56);
    freq.put("ази", 340);
    freq.put("хах", 113);
    freq.put("хат", 8);
    freq.put("хар", 126);
    freq.put("хап", 18);
    freq.put("хам", 10);
    freq.put("хан", 23);
    freq.put("хал", 11);
    freq.put("хай", 23);
    freq.put("хаа", 8);
    freq.put("ща ", 305);
    freq.put("Я ", 100);
    freq.put("азч", 11);
    freq.put("азх", 20);
    freq.put("азт", 23);
    freq.put("азу", 18);
    freq.put("азр", 34);
    freq.put("азс", 35);
    freq.put("азя", 33);
    freq.put("фт ", 23);
    freq.put("Ф", 477);
    freq.put("зно", 49);
    freq.put("фо ", 14);
    freq.put("Вяр", 9);
    freq.put("Абе", 27);
    freq.put(" Шу", 21);
    freq.put("дре", 75);
    freq.put("дра", 271);
    freq.put("дро", 42);
    freq.put("кос", 68);
    freq.put("дри", 39);
    freq.put("лба", 22);
    freq.put("дба", 10);
    freq.put("дру", 182);
    freq.put("НИ ", 51);
    freq.put("дръ", 23);
    freq.put("Пре", 233);
    freq.put("кош", 14);
    freq.put("Пра", 41);
    freq.put(" Шо", 26);
    freq.put(" Шв", 12);
    freq.put("Про", 309);
    freq.put(" Ша", 36);
    freq.put("При", 124);
    freq.put(" Ше", 31);
    freq.put("нц ", 9);
    freq.put("тбе", 30);
    freq.put("тбо", 228);
    freq.put("нфр", 12);
    freq.put("Зел", 9);
    freq.put("Зем", 25);
    freq.put("до ", 372);
    freq.put("лзв", 67);
    freq.put("нфо", 65);
    freq.put("нфе", 28);
    freq.put("лф ", 8);
    freq.put("гит", 52);
    freq.put("По ", 76);
    freq.put("ъд ", 15);
    freq.put("дия", 73);
    freq.put("диш", 131);
    freq.put("дич", 9);
    freq.put("диц", 52);
    freq.put("дих", 35);
    freq.put("дит", 191);
    freq.put("дис", 64);
    freq.put("дир", 47);
    freq.put("дип", 14);
    freq.put("дио", 83);
    freq.put("дин", 637);
    freq.put("дим", 101);
    freq.put("дил", 52);
    freq.put("уан", 13);
    freq.put("дий", 11);
    freq.put("дии", 31);
    freq.put("диз", 55);
    freq.put("дие", 29);
    freq.put("дид", 24);
    freq.put("диг", 62);
    freq.put("див", 92);
    freq.put("лци", 15);
    freq.put("диа", 25);
    freq.put("ски", 1058);
    freq.put("Ико", 18);
    freq.put("НТ ", 35);
    freq.put("пи ", 112);
    freq.put(" Бе", 186);
    freq.put("яво", 20);
    freq.put("Р", 818);
    freq.put("явн", 24);
    freq.put("яви", 96);
    freq.put("яве", 12);
    freq.put("Фре", 8);
    freq.put("ява", 454);
    freq.put("явя", 18);
    freq.put("Цъ", 9);
    freq.put(" Би", 106);
    freq.put("ая ", 180);
    freq.put("Ца", 24);
    freq.put(" що", 81);
    freq.put(" ща", 54);
    freq.put(" ще", 1020);
    freq.put("себ", 48);
    freq.put("сег", 131);
    freq.put("сев", 16);
    freq.put("сед", 155);
    freq.put("сез", 44);
    freq.put("сей", 17);
    freq.put("сел", 120);
    freq.put("сек", 202);
    freq.put("сен", 225);
    freq.put("сем", 69);
    freq.put("сеп", 16);
    freq.put("исн", 21);
    freq.put("Год", 13);
    freq.put("Гол", 31);
    freq.put(" Ощ", 34);
    freq.put("Ци", 14);
    freq.put("еу", 24);
    freq.put(" Ос", 74);
    freq.put(" Ор", 26);
    freq.put("Едн", 52);
    freq.put(" Ох", 10);
    freq.put(" Оф", 33);
    freq.put(" Оч", 36);
    freq.put(" Ол", 31);
    freq.put(" Ок", 26);
    freq.put(" Он", 26);
    freq.put(" Ом", 9);
    freq.put(" Оп", 37);
    freq.put(" Об", 208);
    freq.put(" Ов", 9);
    freq.put(" Бл", 178);
    freq.put(" Оз", 38);
    freq.put("Гот", 13);
    freq.put("Гор", 26);
    freq.put("Гос", 14);
    freq.put("сес", 29);
    freq.put("сер", 101);
    freq.put("сет", 94);
    freq.put("сеч", 16);
    freq.put("сец", 67);
    freq.put("сещ", 41);
    freq.put(" щя", 23);
    freq.put("аем", 93);
    freq.put("аен", 53);
    freq.put("аел", 22);
    freq.put("аед", 16);
    freq.put("аеб", 9);
    freq.put(" Бо", 270);
    freq.put("хвъ", 39);
    freq.put("ео ", 85);
    freq.put("хва", 70);
    freq.put(" € ", 8);
    freq.put("зяв", 21);
    freq.put("Чуд", 18);
    freq.put("аеш", 27);
    freq.put("РТ ", 27);
    freq.put("аех", 9);
    freq.put("ает", 39);
    freq.put("щат", 142);
    freq.put("щас", 47);
    freq.put("щаш", 13);
    freq.put("Все", 51);
    freq.put("аз ", 308);
    freq.put("Вси", 44);
    freq.put("бъл", 203);
    freq.put("бъд", 180);
    freq.put(" № ", 43);
    freq.put("бър", 189);
    freq.put("ха ", 673);
    freq.put("ЛА ", 13);
    freq.put("Вся", 8);
    freq.put("Всъ", 10);
    freq.put("Яп", 14);
    freq.put("бни", 26);
    freq.put("Ян", 39);
    freq.put("Ям", 8);
    freq.put("Як", 9);
    freq.put("щад", 9);
    freq.put("бно", 52);
    freq.put("бна", 38);
    freq.put("Яв", 11);
    freq.put("щам", 35);
    freq.put("щан", 49);
    freq.put("фти", 10);
    freq.put("уац", 12);
    freq.put("фто", 8);
    freq.put("фта", 9);
    freq.put(" Цъ", 9);
    freq.put("фте", 12);
    freq.put("мля", 15);
    freq.put("млр", 13);
    freq.put("дци", 13);
    freq.put("млн", 52);
    freq.put("аис", 32);
    freq.put("мла", 53);
    freq.put(" Ца", 24);
    freq.put("Бли", 94);
    freq.put(" Це", 92);
    freq.put("Бло", 12);
    freq.put(" Ци", 14);
    freq.put("фту", 10);
    freq.put("Бла", 62);
    freq.put("Изо", 10);
    freq.put("нцу", 19);
    freq.put("нць", 9);
    freq.put("тго", 48);
    freq.put("аин", 19);
    freq.put("тгл", 8);
    freq.put("Сан", 30);
    freq.put("з", 11963);
    freq.put("др ", 11);
    freq.put("нца", 22);
    freq.put("нце", 98);
    freq.put("нци", 220);
    freq.put("ива", 319);
    freq.put("уал", 44);
    freq.put("дик", 37);
    freq.put("дох", 31);
    freq.put("дос", 203);
    freq.put("дор", 69);
    freq.put("дот", 9);
    freq.put("дош", 12);
    freq.put("доз", 17);
    freq.put("дож", 18);
    freq.put("доб", 398);
    freq.put("дог", 69);
    freq.put("дов", 166);
    freq.put("дон", 74);
    freq.put("дом", 82);
    freq.put("доп", 39);
    freq.put("дой", 42);
    freq.put("дол", 54);
    freq.put("док", 112);
    freq.put("ъдн", 12);
    freq.put("еню", 13);
    freq.put("ъди", 49);
    freq.put("ъде", 320);
    freq.put("влю", 10);
    freq.put("вля", 42);
    freq.put("ъдб", 8);
    freq.put("ъда", 39);
    freq.put("Пок", 13);
    freq.put("Пол", 60);
    freq.put("Поп", 20);
    freq.put("Пом", 21);
    freq.put("Пон", 24);
    freq.put("Пов", 34);
    freq.put("Пог", 14);
    freq.put("Пож", 12);
    freq.put("Поз", 24);
    freq.put("Под", 53);
    freq.put("Кур", 19);
    freq.put("Асе", 13);
    freq.put("юрд", 8);
    freq.put("ди ", 537);
    freq.put("Куб", 11);
    freq.put("Кун", 14);
    freq.put("Куп", 27);
    freq.put("Кул", 15);
    freq.put("Пот", 13);
    freq.put("Пор", 69);
    freq.put("Пос", 40);
    freq.put("Поч", 33);
    freq.put("вле", 104);
    freq.put("вла", 47);
    freq.put("ъдъ", 21);
    freq.put("вло", 22);
    freq.put("вли", 54);
    freq.put("ъдр", 11);
    freq.put("Тел", 15);
    freq.put("Тем", 22);
    freq.put("Теж", 12);
    freq.put("Тез", 8);
    freq.put("цве", 34);
    freq.put("ичо", 11);
    freq.put("Ш", 171);
    freq.put("дкр", 39);
    freq.put("увр", 13);
    freq.put("увс", 39);
    freq.put("ичк", 388);
    freq.put("Пус", 17);
    freq.put("дка", 38);
    freq.put("ува", 503);
    freq.put("уве", 32);
    freq.put("увк", 34);
    freq.put("дки", 28);
    freq.put("уво", 11);
    freq.put("дко", 25);
    freq.put("лши", 13);
    freq.put("лша", 10);
    freq.put("иче", 288);
    freq.put("ъв ", 434);
    freq.put("Име", 8);
    freq.put("Има", 98);
    freq.put("Тер", 17);
    freq.put("рт", 918);
    freq.put("ру", 672);
    freq.put("рр", 12);
    freq.put("рс", 726);
    freq.put("рц", 158);
    freq.put("рч", 58);
    freq.put("рф", 37);
    freq.put("рх", 95);
    freq.put("ръ", 739);
    freq.put("рш", 128);
    freq.put("рю", 11);
    freq.put("ря", 647);
    freq.put("ъчи", 21);
    freq.put("ъчк", 26);
    freq.put("ъчн", 53);
    freq.put("ъча", 21);
    freq.put("ъчв", 26);
    freq.put("ъче", 11);
    freq.put("ОТ ", 27);
    freq.put("рв", 538);
    freq.put("рг", 352);
    freq.put("ра", 7158);
    freq.put("рб", 134);
    freq.put("рж", 206);
    freq.put("рз", 127);
    freq.put("рд", 288);
    freq.put("ре", 4760);
    freq.put("рк", 334);
    freq.put("рл", 170);
    freq.put("ри", 4501);
    freq.put("ро", 3281);
    freq.put("рп", 70);
    freq.put("рм", 353);
    freq.put("рн", 806);
    freq.put("жно", 100);
    freq.put("ощи", 49);
    freq.put("жни", 54);
    freq.put("ощн", 32);
    freq.put("оща", 21);
    freq.put("у ", 593);
    freq.put("жна", 46);
    freq.put("още", 202);
    freq.put("ощь", 9);
    freq.put("ощт", 12);
    freq.put("ощу", 24);
    freq.put("йфо", 10);
    freq.put("пна", 24);
    freq.put("пне", 8);
    freq.put("пни", 21);
    freq.put("пно", 15);
    freq.put("ем ", 283);
    freq.put("ЗА ", 56);
    freq.put("спе", 255);
    freq.put("спа", 131);
    freq.put("спо", 288);
    freq.put("спл", 18);
    freq.put("спи", 81);
    freq.put("ай ", 847);
    freq.put("тят", 61);
    freq.put("тях", 62);
    freq.put(" ря", 16);
    freq.put("екъ", 24);
    freq.put("екц", 44);
    freq.put("екр", 51);
    freq.put("екс", 208);
    freq.put("ект", 262);
    freq.put("еку", 18);
    freq.put("ВА ", 47);
    freq.put("еко", 101);
    freq.put("еки", 183);
    freq.put("екл", 65);
    freq.put("еке", 26);
    freq.put("ека", 198);
    freq.put("екв", 15);
    freq.put("АТ ", 17);
    freq.put("тял", 15);
    freq.put("тяв", 22);
    freq.put("еят", 35);
    freq.put(" ям", 9);
    freq.put(" ян", 37);
    freq.put(" як", 44);
    freq.put("спр", 78);
    freq.put("спя", 42);
    freq.put(" яз", 11);
    freq.put(" яд", 53);
    freq.put(" яв", 26);
    freq.put(" яб", 8);
    freq.put("алт", 21);
    freq.put("алу", 13);
    freq.put("алс", 17);
    freq.put("алч", 13);
    freq.put("алъ", 34);
    freq.put("алш", 16);
    freq.put("аля", 81);
    freq.put("Ощ", 34);
    freq.put("Ор", 26);
    freq.put("Ос", 74);
    freq.put("От", 228);
    freq.put("Оф", 33);
    freq.put("Ох", 10);
    freq.put("Оч", 36);
    freq.put("п", 14654);
    freq.put(" Бю", 9);
    freq.put("Ок", 27);
    freq.put("Ол", 32);
    freq.put("Ом", 9);
    freq.put("Он", 28);
    freq.put("Оп", 37);
    freq.put("Об", 209);
    freq.put("Ов", 10);
    freq.put("Оз", 38);
    freq.put("алв", 9);
    freq.put("алг", 18);
    freq.put("ала", 333);
    freq.put("алб", 122);
    freq.put("Сед", 14);
    freq.put("алд", 20);
    freq.put("але", 296);
    freq.put("алк", 323);
    freq.put("али", 793);
    freq.put("Сек", 9);
    freq.put("ало", 237);
    freq.put("алн", 470);
    freq.put("───", 33);
    freq.put("ол ", 141);
    freq.put("фя", 11);
    freq.put("фь", 19);
    freq.put("фъ", 29);
    freq.put("ойт", 179);
    freq.put("фф", 19);
    freq.put("ойс", 26);
    freq.put("фт", 78);
    freq.put("фу", 133);
    freq.put("фр", 105);
    freq.put("фс", 12);
    freq.put("Е", 681);
    freq.put("Щас", 8);
    freq.put("ЯТ ", 11);
    freq.put(" ис", 324);
    freq.put("ойк", 78);
    freq.put("фл", 53);
    freq.put("фи", 791);
    freq.put("ойн", 85);
    freq.put("фе", 387);
    freq.put("нт ", 229);
    freq.put("фг", 8);
    freq.put("фа", 211);
    freq.put("ъвс", 19);
    freq.put("ъвр", 11);
    freq.put("чре", 23);
    freq.put("цки", 25);
    freq.put("Те ", 17);
    freq.put("ъще", 34);
    freq.put("ъща", 128);
    freq.put("ъщо", 53);
    freq.put("Укр", 8);
    freq.put("ъщн", 31);
    freq.put("ъщи", 54);
    freq.put("цка", 8);
    freq.put("Пия", 9);
    freq.put("Цър", 8);
    freq.put("Пир", 24);
    freq.put("Пит", 16);
    freq.put("ъве", 79);
    freq.put("ъва", 9);
    freq.put("пул", 31);
    freq.put("пук", 14);
    freq.put("Усп", 8);
    freq.put("пуб", 63);
    freq.put("пув", 30);
    freq.put("иша", 49);
    freq.put("ише", 133);
    freq.put("ишл", 13);
    freq.put("ишк", 31);
    freq.put("иши", 19);
    freq.put("ишо", 18);
    freq.put("ишн", 69);
    freq.put("шум", 13);
    freq.put("л", 19849);
    freq.put("юци", 18);
    freq.put("шур", 9);
    freq.put("р ", 1544);
    freq.put("пуш", 46);
    freq.put("йца", 23);
    freq.put("пус", 170);
    freq.put("пут", 33);
    freq.put("йци", 21);
    freq.put("Фан", 10);
    freq.put("ул", 417);
    freq.put("ук", 432);
    freq.put("уй", 37);
    freq.put("уи", 149);
    freq.put("уп", 442);
    freq.put("ун", 284);
    freq.put("ум", 512);
    freq.put("уг", 243);
    freq.put("ув", 642);
    freq.put("уб", 526);
    freq.put("уа", 141);
    freq.put("уз", 136);
    freq.put("уж", 221);
    freq.put("уе", 59);
    freq.put("рта", 232);
    freq.put("ущ", 13);
    freq.put("уш", 247);
    freq.put("уя", 15);
    freq.put("уу", 42);
    freq.put("ут", 612);
    freq.put("ус", 906);
    freq.put("ур", 769);
    freq.put("уч", 523);
    freq.put("уц", 46);
    freq.put("ух", 124);
    freq.put("уф", 18);
    freq.put("бе ", 195);
    freq.put("Шве", 12);
    freq.put("Б", 1983);
    freq.put("тст", 48);
    freq.put("тсъ", 10);
    freq.put("емя", 39);
    freq.put("ему", 10);
    freq.put("емс", 14);
    freq.put("еми", 256);
    freq.put("емо", 85);
    freq.put("емп", 21);
    freq.put("емн", 38);
    freq.put("емв", 51);
    freq.put("ета", 600);
    freq.put("ема", 207);
    freq.put("емб", 10);
    freq.put("еме", 391);
    freq.put("етв", 54);
    freq.put("тск", 96);
    freq.put("тсл", 10);
    freq.put("етн", 110);
    freq.put("ето", 1140);
    freq.put("айк", 122);
    freq.put("айл", 44);
    freq.put("айм", 10);
    freq.put("айн", 199);
    freq.put("айо", 35);
    freq.put("айп", 14);
    freq.put("ети", 331);
    freq.put("айв", 15);
    freq.put("айд", 72);
    freq.put("айе", 11);
    freq.put("айз", 8);
    freq.put("ея ", 103);
    freq.put("етк", 73);
    freq.put("етл", 37);
    freq.put("Същ", 9);
    freq.put("Сър", 20);
    freq.put("Със", 15);
    freq.put("мем", 9);
    freq.put("Съб", 17);
    freq.put("Съв", 19);
    freq.put("ек ", 145);
    freq.put("Още", 34);
    freq.put("дей", 68);
    freq.put("Арт", 8);
    freq.put(" я ", 128);
    freq.put("тя ", 109);
    freq.put("айс", 46);
    freq.put("айт", 294);
    freq.put("айф", 15);
    freq.put("айч", 14);
    freq.put("бюд", 15);
    freq.put("бюл", 9);
    freq.put("ДС ", 22);
    freq.put("бюр", 8);
    freq.put("бют", 9);
    freq.put("ВО ", 26);
    freq.put("ал ", 404);
    freq.put("рир", 53);
    freq.put("О ", 274);
    freq.put("Аге", 12);
    freq.put("олс", 34);
    freq.put("олт", 11);
    freq.put("олу", 142);
    freq.put("олф", 8);
    freq.put("етт", 8);
    freq.put("олш", 9);
    freq.put("олъ", 21);
    freq.put("олю", 34);
    freq.put("оля", 202);
    freq.put("риц", 29);
    freq.put("етъ", 120);
    freq.put("ола", 204);
    freq.put("олв", 9);
    freq.put("олд", 8);
    freq.put("оле", 451);
    freq.put("олз", 81);
    freq.put("оли", 374);
    freq.put("олк", 452);
    freq.put("олн", 119);
    freq.put("оло", 281);
    freq.put("нтъ", 132);
    freq.put("тпа", 16);
    freq.put("нтр", 79);
    freq.put("нтс", 35);
    freq.put("нту", 16);
    freq.put("нтн", 24);
    freq.put("нто", 51);
    freq.put("нти", 284);
    freq.put("нте", 236);
    freq.put("ой ", 480);
    freq.put("тпу", 19);
    freq.put("нта", 299);
    freq.put("ф ", 104);
    freq.put("опъ", 27);
    freq.put("опр", 100);
    freq.put("опс", 8);
    freq.put("опт", 22);
    freq.put("опу", 63);
    freq.put("№", 43);
    freq.put("Хай", 14);
    freq.put("лаг", 241);
    freq.put("инъ", 16);
    freq.put(" Юл", 14);
    freq.put(" Юн", 21);
    freq.put("два", 341);
    freq.put(" Юг", 12);
    freq.put("Хах", 12);
    freq.put("лак", 61);
    freq.put("Хар", 45);
    freq.put("аещ", 9);
    freq.put("лам", 127);
    freq.put("лан", 232);
    freq.put("опо", 91);
    freq.put("опи", 138);
    freq.put("опк", 12);
    freq.put("опл", 45);
    freq.put("опе", 106);
    freq.put("ину", 37);
    freq.put("опа", 169);
    freq.put("тле", 27);
    freq.put("тла", 32);
    freq.put("ца ", 407);
    freq.put("лас", 239);
    freq.put("тло", 15);
    freq.put("тли", 87);
    freq.put("лат", 344);
    freq.put("лац", 35);
    freq.put("Лет", 17);
    freq.put("Лес", 12);
    freq.put("инд", 49);
    freq.put("лащ", 41);
    freq.put("у", 8663);
    freq.put("уд ", 30);
    freq.put("Лек", 13);
    freq.put("Лед", 9);
    freq.put("Лев", 71);
    freq.put("МА ", 27);
    freq.put(" мо", 926);
    freq.put("ъх ", 16);
    freq.put("джъ", 23);
    freq.put("джо", 18);
    freq.put("джи", 75);
    freq.put("ужи", 30);
    freq.put("дже", 50);
    freq.put("льо", 19);
    freq.put("уже", 33);
    freq.put("ужв", 9);
    freq.put("джа", 56);
    freq.put("ужа", 32);
    freq.put("ужб", 14);
    freq.put("ер ", 360);
    freq.put("Й", 65);
    freq.put("По", 518);
    freq.put("Пл", 144);
    freq.put("До ", 24);
    freq.put("Пи", 85);
    freq.put("Пе", 168);
    freq.put("Па", 160);
    freq.put("ийс", 142);
    freq.put("ийт", 14);
    freq.put("ийц", 14);
    freq.put("оя ", 171);
    freq.put("ийк", 21);
    freq.put("ийн", 40);
    freq.put("Пъ", 116);
    freq.put("Пу", 164);
    freq.put("Пс", 9);
    freq.put("Пр", 711);
    freq.put("осв", 66);
    freq.put(" мр", 66);
    freq.put("осе", 62);
    freq.put("ите", 3254);
    freq.put("Дим", 55);
    freq.put("Дие", 16);
    freq.put("Диа", 11);
    freq.put("Дир", 8);
    freq.put("осн", 58);
    freq.put("Учи", 9);
    freq.put("Уча", 9);
    freq.put("йст", 104);
    freq.put("Уче", 12);
    freq.put("рау", 12);
    freq.put("рат", 619);
    freq.put("рас", 264);
    freq.put("рар", 18);
    freq.put("рач", 56);
    freq.put("рац", 76);
    freq.put("рах", 159);
    freq.put("раф", 72);
    freq.put("ращ", 71);
    freq.put("раш", 77);
    freq.put("рая", 95);
    freq.put("хн", 134);
    freq.put("хм", 86);
    freq.put("Л ", 41);
    freq.put("хи", 174);
    freq.put("хл", 63);
    freq.put("хе", 88);
    freq.put("ха", 1065);
    freq.put("хв", 115);
    freq.put("хъ", 19);
    freq.put("хх", 22);
    freq.put("хр", 123);
    freq.put("ху", 172);
    freq.put("хт", 82);
    freq.put("еи ", 22);
    freq.put("раг", 33);
    freq.put("рав", 916);
    freq.put("раб", 330);
    freq.put("раз", 826);
    freq.put("раж", 122);
    freq.put("рае", 55);
    freq.put("рад", 533);
    freq.put("рал", 166);
    freq.put("рак", 145);
    freq.put("рай", 196);
    freq.put("рап", 30);
    freq.put("ран", 841);
    freq.put("рам", 234);
    freq.put("сут", 47);
    freq.put("сур", 14);
    freq.put("ежи", 78);
    freq.put("ежк", 55);
    freq.put("ежн", 18);
    freq.put("ежа", 60);
    freq.put("ежд", 263);
    freq.put("еже", 39);
    freq.put("ан ", 409);
    freq.put("сув", 73);
    freq.put("суб", 16);
    freq.put("суа", 8);
    freq.put("сул", 17);
    freq.put("суп", 48);
    freq.put("сун", 13);
    freq.put("сум", 11);
    freq.put("апъ", 30);
    freq.put("апч", 8);
    freq.put("апт", 22);
    freq.put("апу", 35);
    freq.put("апр", 236);
    freq.put("ФБ ", 8);
    freq.put("Дър", 23);
    freq.put("щаб", 8);
    freq.put("йла", 10);
    freq.put("Чак", 16);
    freq.put("йли", 60);
    freq.put("йло", 20);
    freq.put("Дъл", 11);
    freq.put("апо", 212);
    freq.put("апк", 17);
    freq.put("апл", 57);
    freq.put("Аз ", 104);
    freq.put("апе", 31);
    freq.put("апв", 9);
    freq.put("апа", 164);
    freq.put("тна", 192);
    freq.put("тне", 46);
    freq.put("тни", 314);
    freq.put("тно", 310);
    freq.put("цял", 83);
    freq.put("нре", 8);
    freq.put("оп ", 57);
    freq.put("тнъ", 10);
    freq.put("тнь", 12);
    freq.put("цаи", 9);
    freq.put("цак", 8);
    freq.put("ИН ", 20);
    freq.put("итя", 8);
    freq.put("лът", 36);
    freq.put("лър", 24);
    freq.put("лъс", 21);
    freq.put("лъч", 19);
    freq.put("удя", 35);
    freq.put("удъ", 10);
    freq.put("лъг", 14);
    freq.put("лъж", 31);
    freq.put("удв", 8);
    freq.put("ню ", 9);
    freq.put("удн", 62);
    freq.put("удо", 97);
    freq.put("уди", 73);
    freq.put("лън", 67);
    freq.put("цар", 36);
    freq.put("цат", 126);
    freq.put("ося", 12);
    freq.put("ъхн", 17);
    freq.put("ЕС ", 37);
    freq.put("Ж ", 26);
    freq.put("шев", 32);
    freq.put("АД ", 19);
    freq.put("дж ", 15);
    freq.put("кюр", 8);
    freq.put("оян", 79);
    freq.put("оял", 8);
    freq.put("ояд", 16);
    freq.put("ояв", 46);
    freq.put("Доб", 179);
    freq.put("Дог", 21);
    freq.put("Дов", 12);
    freq.put("Дон", 13);
    freq.put("Дом", 13);
    freq.put("Док", 23);
    freq.put("Дос", 11);
    freq.put("Дор", 18);
    freq.put("ий ", 42);
    freq.put("Вла", 21);
    freq.put("оящ", 24);
    freq.put("оят", 200);
    freq.put("Мер", 22);
    freq.put("Мес", 16);
    freq.put("Мет", 8);
    freq.put("Меч", 9);
    freq.put(" Цв", 73);
    freq.put("Мед", 25);
    freq.put("Меж", 19);
    freq.put("Мел", 10);
    freq.put("Мен", 11);
    freq.put("сни", 366);
    freq.put("сно", 262);
    freq.put("сна", 187);
    freq.put("сне", 63);
    freq.put("Йор", 23);
    freq.put("свъ", 54);
    freq.put("Ла", 66);
    freq.put("Ле", 149);
    freq.put("ць", 9);
    freq.put("Ли", 103);
    freq.put("Ло", 99);
    freq.put("ця", 84);
    freq.put("еиз", 16);
    freq.put("вци", 21);
    freq.put("Лу", 69);
    freq.put("Ля", 9);
    freq.put("Лю", 42);
    freq.put("Бри", 20);
    freq.put("Бра", 42);
    freq.put("Бре", 8);
    freq.put("ра ", 1183);
    freq.put("сня", 35);
    freq.put("ТВ ", 37);
    freq.put("Слъ", 16);
    freq.put("анц", 124);
    freq.put("анч", 43);
    freq.put("анс", 345);
    freq.put("ант", 226);
    freq.put("Слу", 16);
    freq.put("аня", 47);
    freq.put("анш", 9);
    freq.put("анъ", 30);
    freq.put("кен", 36);
    freq.put("Няк", 58);
    freq.put("Ням", 80);
    freq.put("рдо", 15);
    freq.put("еж ", 23);
    freq.put(" Ч", 371);
    freq.put("анд", 235);
    freq.put("ане", 890);
    freq.put("Сли", 29);
    freq.put("ана", 528);
    freq.put("Сло", 11);
    freq.put("анг", 73);
    freq.put("анн", 58);
    freq.put("ано", 318);
    freq.put("Сла", 28);
    freq.put("ани", 1022);
    freq.put("Сле", 47);
    freq.put("анл", 19);
    freq.put("сб", 83);
    freq.put("са", 1650);
    freq.put("сг", 35);
    freq.put("св", 656);
    freq.put("се", 3558);
    freq.put("сд", 21);
    freq.put("си", 2849);
    freq.put("сл", 1234);
    freq.put("ск", 2526);
    freq.put("сн", 917);
    freq.put("см", 443);
    freq.put("сп", 916);
    freq.put("со", 583);
    freq.put("сс", 8);
    freq.put("ср", 332);
    freq.put("су", 281);
    freq.put("ст", 5666);
    freq.put("сх", 13);
    freq.put("сф", 25);
    freq.put("сч", 18);
    freq.put("сц", 29);
    freq.put("сш", 15);
    freq.put("вят", 151);
    freq.put("съ", 1610);
    freq.put("сь", 9);
    freq.put("ся", 198);
    freq.put("йл ", 20);
    freq.put("Ази", 12);
    freq.put("ЛИ ", 32);
    freq.put("юле", 12);
    freq.put("юли", 21);
    freq.put("Спр", 13);
    freq.put("ьо ", 34);
    freq.put("едв", 178);
    freq.put("еда", 386);
    freq.put("еде", 318);
    freq.put("едк", 12);
    freq.put("едл", 98);
    freq.put("еди", 626);
    freq.put("едо", 93);
    freq.put("едп", 44);
    freq.put("едм", 101);
    freq.put("едн", 596);
    freq.put("ца", 611);
    freq.put("едр", 8);
    freq.put("едс", 197);
    freq.put("едъ", 20);
    freq.put("едя", 25);
    freq.put("це", 629);
    freq.put("Спе", 26);
    freq.put("Спа", 25);
    freq.put("Спо", 80);
    freq.put("Спи", 9);
    freq.put("ци", 1869);
    freq.put("ИЕ ", 26);
    freq.put("гъ", 114);
    freq.put("гю", 9);
    freq.put("гу", 222);
    freq.put("гс", 10);
    freq.put("гр", 954);
    freq.put("Осв", 8);
    freq.put("Оск", 8);
    freq.put("Ита", 30);
    freq.put("Осн", 10);
    freq.put("Еко", 11);
    freq.put("Фра", 42);
    freq.put("Не ", 200);
    freq.put("Екс", 12);
    freq.put("Ост", 29);
    freq.put(" а ", 294);
    freq.put("Але", 37);
    freq.put("Али", 11);
    freq.put("гл", 664);
    freq.put("ги", 725);
    freq.put("го", 2300);
    freq.put("гн", 241);
    freq.put("гв", 34);
    freq.put("га", 2231);
    freq.put("ге", 225);
    freq.put("гд", 8);
    freq.put("он ", 263);
    freq.put("огъ", 24);
    freq.put("огр", 140);
    freq.put(" вх", 15);
    freq.put(" вч", 32);
    freq.put(" вс", 503);
    freq.put(" вр", 332);
    freq.put(" вт", 79);
    freq.put(" вя", 45);
    freq.put(" въ", 701);
    freq.put(" ве", 513);
    freq.put(" вд", 47);
    freq.put(" вз", 117);
    freq.put(" ва", 228);
    freq.put(" вн", 53);
    freq.put(" вм", 22);
    freq.put(" вп", 19);
    freq.put(" во", 175);
    freq.put(" ви", 838);
    freq.put(" вл", 109);
    freq.put(" вк", 106);
    freq.put("оги", 63);
    freq.put("огл", 57);
    freq.put("огн", 64);
    freq.put("ого", 490);
    freq.put("ога", 453);
    freq.put("М ", 66);
    freq.put("нъц", 8);
    freq.put("нъч", 9);
    freq.put("нър", 9);
    freq.put("нът", 42);
    freq.put("нъж", 18);
    freq.put("нъм", 9);
    freq.put("нък", 11);
    freq.put("зжи", 8);
    freq.put("яна", 61);
    freq.put("яне", 56);
    freq.put("янк", 34);
    freq.put("яни", 65);
    freq.put("яно", 20);
    freq.put("янн", 8);
    freq.put("да ", 3321);
    freq.put("рте", 36);
    freq.put("д", 18411);
    freq.put("ртв", 32);
    freq.put("ртн", 43);
    freq.put("щях", 19);
    freq.put("рто", 38);
    freq.put("рти", 229);
    freq.put("ъс ", 182);
    freq.put("ртф", 31);
    freq.put("Иде", 10);
    freq.put("рту", 18);
    freq.put("ртт", 9);
    freq.put("ртъ", 34);
    freq.put("ил ", 310);
    freq.put("т ", 7021);
    freq.put("яну", 33);
    freq.put("янс", 11);
    freq.put("Цац", 12);
    freq.put("оу ", 10);
    freq.put("ир ", 74);
    freq.put("чът", 13);
    freq.put("не ", 2267);
    freq.put("инь", 19);
    freq.put("лаб", 36);
    freq.put("лав", 201);
    freq.put("иня", 47);
    freq.put("лад", 225);
    freq.put("лае", 16);
    freq.put("лаж", 40);
    freq.put("дво", 40);
    freq.put("инф", 60);
    freq.put("лай", 93);
    freq.put("инц", 48);
    freq.put("инч", 18);
    freq.put("две", 60);
    freq.put("инс", 175);
    freq.put("инт", 185);
    freq.put("лап", 26);
    freq.put("лар", 43);
    freq.put("инн", 15);
    freq.put("ино", 143);
    freq.put("ини", 633);
    freq.put("лах", 14);
    freq.put("инк", 84);
    freq.put("лач", 33);
    freq.put("лаш", 35);
    freq.put("ине", 115);
    freq.put("дву", 17);
    freq.put("ина", 933);
    freq.put("инв", 37);
    freq.put("инг", 104);
    freq.put("кшъ", 8);
    freq.put("итн", 82);
    freq.put("оса", 62);
    freq.put("ито", 365);
    freq.put("ити", 257);
    freq.put("итл", 23);
    freq.put("итк", 32);
    freq.put("оск", 44);
    freq.put("осл", 207);
    freq.put("оси", 97);
    freq.put("осо", 76);
    freq.put("осп", 68);
    freq.put("осм", 26);
    freq.put("итв", 29);
    freq.put("пеш", 54);
    freq.put("пея", 15);
    freq.put("пет", 122);
    freq.put("пес", 84);
    freq.put("пер", 192);
    freq.put("печ", 133);
    freq.put("пец", 69);
    freq.put("пех", 32);
    freq.put("ТА ", 77);
    freq.put("пел", 29);
    freq.put("пек", 39);
    freq.put("пей", 60);
    freq.put("пен", 79);
    freq.put("пев", 16);
    freq.put("пее", 17);
    freq.put("пед", 19);
    freq.put("ост", 1022);
    freq.put("ить", 8);
    freq.put("оср", 26);
    freq.put("осф", 8);
    freq.put("итъ", 81);
    freq.put("осъ", 44);
    freq.put("итр", 61);
    freq.put("иту", 53);
    freq.put("ча ", 132);
    freq.put("Кан", 27);
    freq.put("рдс", 8);
    freq.put("ажд", 97);
    freq.put("ск ", 32);
    freq.put("щав", 34);
    freq.put("ещ ", 20);
    freq.put("рдн", 13);
    freq.put("рди", 53);
    freq.put("рдж", 30);
    freq.put("рде", 46);
    freq.put("рда", 50);
    freq.put("НА ", 159);
    freq.put("ед ", 496);
    freq.put("Ира", 15);
    freq.put("а", 73273);
    freq.put("Еми", 19);
    freq.put("ЗИ ", 9);
    freq.put("ьор", 98);
    freq.put("Лят", 9);
    freq.put("шо ", 45);
    freq.put("Айд", 17);
    freq.put(" ну", 67);
    freq.put(" аб", 57);
    freq.put("онц", 58);
    freq.put("онч", 22);
    freq.put("онф", 30);
    freq.put("онт", 139);
    freq.put("ону", 8);
    freq.put("онс", 109);
    freq.put("оня", 45);
    freq.put("онъ", 20);
    freq.put("Нес", 23);
    freq.put("ВИ ", 16);
    freq.put("Нещ", 23);
    freq.put(" ау", 22);
    freq.put(" ат", 43);
    freq.put(" ас", 18);
    freq.put(" ар", 88);
    freq.put(" ах", 12);
    freq.put(" аг", 36);
    freq.put(" ав", 117);
    freq.put("Ал ", 11);
    freq.put(" аа", 20);
    freq.put(" аз", 249);
    freq.put(" ад", 49);
    freq.put(" ал", 161);
    freq.put(" ак", 311);
    freq.put(" ай", 40);
    freq.put(" ап", 91);
    freq.put(" ан", 105);
    freq.put("ор ", 287);
    freq.put("Нед", 10);
    freq.put("Нев", 14);
    freq.put("Неп", 18);
    freq.put(" ам", 172);
    freq.put("Нек", 22);
    freq.put("онз", 14);
    freq.put("онд", 61);
    freq.put("оне", 196);
    freq.put("онг", 20);
    freq.put("она", 382);
    freq.put("оно", 136);
    freq.put("онн", 73);
    freq.put("онк", 77);
    freq.put("онл", 29);
    freq.put("они", 250);
    freq.put("г ", 433);
    freq.put("Му", 31);
    freq.put("Мю", 12);
    freq.put("Зна", 23);
    freq.put("Мъ", 52);
    freq.put("цув", 13);
    freq.put("ньо", 49);
    freq.put(" в ", 3056);
    freq.put("Ме", 141);
    freq.put("Ма", 430);
    freq.put("Мо", 207);
    freq.put("Мн", 65);
    freq.put("Мл", 40);
    freq.put("Ми", 226);
    freq.put("ог ", 45);
    freq.put("зда", 122);
    freq.put("зде", 32);
    freq.put("щна", 23);
    freq.put("зди", 28);
    freq.put("здо", 9);
    freq.put("щне", 15);
    freq.put("ром", 172);
    freq.put("люц", 19);
    freq.put("люч", 121);
    freq.put("лют", 18);
    freq.put("люс", 11);
    freq.put("люд", 16);
    freq.put("люб", 164);
    freq.put("Иво", 10);
    freq.put("щно", 52);
    freq.put("Ива", 58);
    freq.put("ита", 424);
    freq.put("здр", 128);
    freq.put("зду", 11);
    freq.put("здъ", 16);
    freq.put("тф", 41);
    freq.put("тх", 8);
    freq.put("тц", 10);
    freq.put("тч", 50);
    freq.put("тр", 2110);
    freq.put("тс", 178);
    freq.put("тт", 131);
    freq.put("ту", 668);
    freq.put("ть", 33);
    freq.put("тю", 34);
    freq.put("тя", 291);
    freq.put("тъ", 1032);
    freq.put("къп", 46);
    freq.put("към", 266);
    freq.put("къл", 43);
    freq.put("къд", 124);
    freq.put("къв", 98);
    freq.put("ъсм", 24);
    freq.put("ъсн", 69);
    freq.put("ъск", 15);
    freq.put("рт ", 193);
    freq.put("ъси", 13);
    freq.put("ъсе", 24);
    freq.put("ъса", 18);
    freq.put("илъ", 8);
    freq.put("даж", 70);
    freq.put("ушв", 9);
    freq.put("дад", 78);
    freq.put("уше", 40);
    freq.put("уши", 51);
    freq.put("ушк", 16);
    freq.put("дам", 188);
    freq.put("дал", 198);
    freq.put("дак", 8);
    freq.put("дай", 70);
    freq.put("дач", 22);
    freq.put("дах", 28);
    freq.put("ило", 116);
    freq.put("дат", 323);
    freq.put("дас", 12);
    freq.put("дар", 195);
    freq.put("илв", 19);
    freq.put("ила", 195);
    freq.put("яш ", 29);
    freq.put("иле", 133);
    freq.put("ъст", 188);
    freq.put("къщ", 67);
    freq.put("кът", 61);
    freq.put("къс", 94);
    freq.put("кър", 40);
    freq.put("Пад", 12);
    freq.put("те", 6617);
    freq.put("тз", 10);
    freq.put("та", 7744);
    freq.put("тб", 280);
    freq.put("Пав", 20);
    freq.put("тг", 57);
    freq.put("Пам", 10);
    freq.put("Пан", 15);
    freq.put("то", 6255);
    freq.put("тп", 50);
    freq.put("ти", 3602);
    freq.put("МО ", 18);
    freq.put("Пак", 19);
    freq.put("Пал", 9);
    freq.put("ирл", 8);
    freq.put("ирк", 25);
    freq.put("ири", 136);
    freq.put("иро", 103);
    freq.put("ирм", 46);
    freq.put("ира", 847);
    freq.put("ире", 65);
    freq.put("оум", 15);
    freq.put("оун", 10);
    freq.put("оуб", 12);
    freq.put("пля", 10);
    freq.put("плю", 10);
    freq.put("ла ", 612);
    freq.put("ч", 6786);
    freq.put("ин ", 638);
    freq.put("пла", 316);
    freq.put("пле", 101);
    freq.put("пли", 33);
    freq.put("оут", 12);
    freq.put("оуч", 14);
    freq.put("иру", 14);
    freq.put("ирт", 9);
    freq.put("ос ", 83);
    freq.put("рвя", 15);
    freq.put("рвю", 25);
    freq.put("ит ", 168);
    freq.put("ЩЕ ", 13);
    freq.put("ожа", 68);
    freq.put("СТ ", 18);
    freq.put("рва", 174);
    freq.put("рво", 65);
    freq.put("рви", 177);
    freq.put("пе ", 17);
    freq.put("ещу", 120);
    freq.put("чам", 49);
    freq.put("чан", 58);
    freq.put("чай", 54);
    freq.put("чак", 171);
    freq.put("чал", 78);
    freq.put("Н", 1871);
    freq.put("чав", 67);
    freq.put("вто", 176);
    freq.put("вти", 21);
    freq.put("ТО ", 42);
    freq.put("вта", 34);
    freq.put("чая", 16);
    freq.put("чаш", 28);
    freq.put("чар", 43);
    freq.put("час", 262);
    freq.put("чат", 115);
    freq.put("еща", 222);
    freq.put("еще", 56);
    freq.put("ещи", 51);
    freq.put("ещн", 27);
    freq.put("рд ", 57);
    freq.put("Тун", 9);
    freq.put("Туи", 18);
    freq.put("Тук", 12);
    freq.put("Н ", 134);
    freq.put("и", 51864);
    freq.put("Мно", 61);
    freq.put("Цве", 66);
    freq.put("бва", 251);
    freq.put("Чел", 10);
    freq.put("рже", 16);
    freq.put("бви", 18);
    freq.put("ржи", 23);
    freq.put("кн", 129);
    freq.put("еч ", 19);
    freq.put("Тур", 33);
    freq.put("А ", 779);
    freq.put("гах", 8);
    freq.put("кр", 900);
    freq.put("НО ", 41);
    freq.put("гай", 10);
    freq.put("ели", 703);
    freq.put("Чес", 56);
    freq.put("гал", 62);
    freq.put("гам", 59);
    freq.put("ев ", 290);
    freq.put("а ", 31113);
    freq.put("елб", 10);
    freq.put("ела", 158);
    freq.put("Раб", 38);
    freq.put("Раз", 88);
    freq.put("Рад", 41);
    freq.put("Рал", 8);
    freq.put("Рай", 18);
    freq.put("Ран", 9);
    freq.put("схе", 9);
    freq.put("ехн", 50);
    freq.put("ехо", 20);
    freq.put("ехи", 35);
    freq.put("ехе", 15);
    freq.put("еха", 29);
    freq.put("еак", 10);
    freq.put("еал", 61);
    freq.put("Дре", 9);
    freq.put("Дра", 14);
    freq.put("еат", 26);
    freq.put("хте", 60);
    freq.put("ако", 309);
    freq.put("хти", 15);
    freq.put("ащи", 165);
    freq.put("Апт", 8);
    freq.put("йна", 94);
    freq.put("йне", 25);
    freq.put("йни", 67);
    freq.put("йнк", 10);
    freq.put("йно", 87);
    freq.put("об ", 14);
    freq.put("Апа", 26);
    freq.put(" д ", 54);
    freq.put("озр", 8);
    freq.put("Сви", 8);
    freq.put("озд", 38);
    freq.put("озе", 24);
    freq.put("СИ ", 17);
    freq.put("ар ", 177);
    freq.put("оза", 88);
    freq.put("озв", 29);
    freq.put("озм", 11);
    freq.put("озн", 132);
    freq.put("озо", 44);
    freq.put("ози", 245);
    freq.put("стк", 13);
    freq.put("озл", 10);
    freq.put("Зла", 20);
    freq.put("елт", 17);
    freq.put("мря", 12);
    freq.put("мръ", 36);
    freq.put("за ", 2810);
    freq.put("ци ", 387);
    freq.put("атф", 8);
    freq.put("атч", 14);
    freq.put("атс", 18);
    freq.put("атр", 55);
    freq.put("ату", 80);
    freq.put("ЪТ ", 9);
    freq.put(" жи", 219);
    freq.put("атя", 31);
    freq.put("атъ", 69);
    freq.put("ате", 508);
    freq.put(" жу", 21);
    freq.put("атб", 10);
    freq.put("ата", 2789);
    freq.put("атв", 43);
    freq.put("атн", 89);
    freq.put("ато", 820);
    freq.put("ати", 397);
    freq.put("атл", 18);
    freq.put("атк", 43);
    freq.put("АК ", 9);
    freq.put("мре", 32);
    freq.put("мра", 28);
    freq.put("зву", 28);
    freq.put("звъ", 59);
    freq.put("бс", 132);
    freq.put("бр", 928);
    freq.put("бу", 409);
    freq.put("бт", 13);
    freq.put("бх", 16);
    freq.put("гла", 174);
    freq.put("бч", 10);
    freq.put("бщ", 183);
    freq.put("бъ", 583);
    freq.put("гли", 80);
    freq.put("бя", 289);
    freq.put("бю", 45);
    freq.put("рца", 16);
    freq.put("рце", 45);
    freq.put("рци", 95);
    freq.put("лв ", 147);
    freq.put("клю", 119);
    freq.put("кля", 18);
    freq.put("нже", 10);
    freq.put("клу", 45);
    freq.put("кло", 42);
    freq.put("кли", 153);
    freq.put("кле", 34);
    freq.put("Рим", 10);
    freq.put("кла", 163);
    freq.put("Шум", 21);
    freq.put("ба", 979);
    freq.put("бг", 14);
    freq.put("бв", 275);
    freq.put("бе", 1221);
    freq.put("глу", 35);
    freq.put("би", 1372);
    freq.put("гля", 12);
    freq.put("бк", 9);
    freq.put("бн", 127);
    freq.put("бм", 8);
    freq.put("бо", 1233);
    freq.put("зве", 103);
    freq.put("цов", 24);
    freq.put("зва", 311);
    freq.put("зво", 47);
    freq.put("яйц", 11);
    freq.put("яйт", 8);
    freq.put("зви", 73);
    freq.put(" Су", 34);
    freq.put("Х", 404);
    freq.put("ип ", 145);
    freq.put(" Б ", 13);
    freq.put("лдо", 13);
    freq.put("лде", 9);
    freq.put(" Съ", 147);
    freq.put("д ", 1307);
    freq.put("учк", 10);
    freq.put("чва", 204);
    freq.put("ечт", 23);
    freq.put("счу", 8);
    freq.put("уча", 172);
    freq.put("Пар", 39);
    freq.put("ЕН ", 66);
    freq.put("Не", 354);
    freq.put("Фе", 88);
    freq.put("На", 541);
    freq.put("Бър", 13);
    freq.put("Но", 365);
    freq.put("Ни", 147);
    freq.put("Фа", 41);
    freq.put("Бъл", 435);
    freq.put("Ня", 138);
    freq.put("Ню", 13);
    freq.put("Бъд", 17);
    freq.put("ечк", 16);
    freq.put("ечи", 25);
    freq.put("ечо", 8);
    freq.put("ечн", 37);
    freq.put("еча", 43);
    freq.put("ече", 697);
    freq.put("ав", 3068);
    freq.put("аг", 821);
    freq.put("аа", 145);
    freq.put("аб", 863);
    freq.put("аж", 521);
    freq.put("аз", 2105);
    freq.put("ад", 1785);
    freq.put("ае", 379);
    freq.put("ак", 2475);
    freq.put("ал", 3253);
    freq.put("аи", 122);
    freq.put("ай", 1792);
    freq.put("ао", 41);
    freq.put("ап", 989);
    freq.put("ам", 3027);
    freq.put("ан", 4552);
    freq.put("еве", 106);
    freq.put("вре", 265);
    freq.put("евг", 18);
    freq.put("евн", 73);
    freq.put("ево", 101);
    freq.put("еви", 134);
    freq.put("вро", 191);
    freq.put("вру", 27);
    freq.put("евр", 133);
    freq.put("евс", 75);
    freq.put("евт", 20);
    freq.put("връ", 127);
    freq.put("евъ", 45);
    freq.put("ат", 6417);
    freq.put("ау", 147);
    freq.put("ар", 3658);
    freq.put("ас", 1780);
    freq.put("ац", 538);
    freq.put("ач", 670);
    freq.put("аф", 185);
    freq.put("ах", 921);
    freq.put("аш", 761);
    freq.put("ащ", 616);
    freq.put("ая", 256);
    freq.put("Сни", 26);
    freq.put("ех ", 65);
    freq.put("уша", 103);
    freq.put("Оча", 27);
    freq.put("Ант", 26);
    freq.put("вю ", 26);
    freq.put("дае", 11);
    freq.put("еа ", 14);
    freq.put("дав", 307);
    freq.put("Анд", 32);
    freq.put("Ане", 8);
    freq.put("Ана", 17);
    freq.put("Анг", 38);
    freq.put("дан", 268);
    freq.put("илс", 15);
    freq.put("ушн", 11);
    freq.put("илк", 28);
    freq.put("или", 608);
    freq.put("С", 2329);
    freq.put("йн ", 81);
    freq.put("обр", 497);
    freq.put("обс", 92);
    freq.put("илм", 74);
    freq.put("обх", 16);
    freq.put("объ", 74);
    freq.put("илн", 130);
    freq.put("обя", 111);
    freq.put(" дя", 35);
    freq.put(" дю", 12);
    freq.put(" дъ", 201);
    freq.put(" ду", 156);
    freq.put(" др", 275);
    freq.put(" до", 1219);
    freq.put(" дн", 293);
    freq.put(" дл", 8);
    freq.put("чта", 14);
    freq.put(" ди", 192);
    freq.put(" дж", 56);
    freq.put(" де", 778);
    freq.put(" дд", 11);
    freq.put(" дв", 222);
    freq.put(" да", 3079);
    freq.put("обв", 45);
    freq.put("оба", 168);
    freq.put("обз", 16);
    freq.put("обе", 199);
    freq.put("обл", 157);
    freq.put("оби", 236);
    freq.put("даш", 36);
    freq.put("обо", 80);
    freq.put("обн", 57);
    freq.put("чти", 39);
    freq.put(" Кр", 111);
    freq.put("жур", 28);
    freq.put("ару", 28);
    freq.put("арт", 419);
    freq.put("арс", 283);
    freq.put("арч", 34);
    freq.put("арц", 14);
    freq.put("арх", 24);
    freq.put("арф", 9);
    freq.put("аръ", 48);
    freq.put("арш", 14);
    freq.put("аря", 126);
    freq.put("арг", 15);
    freq.put("арв", 31);
    freq.put("арб", 23);
    freq.put("ара", 518);
    freq.put("оз ", 20);
    freq.put("аре", 252);
    freq.put("ард", 71);
    freq.put("арл", 62);
    freq.put("арк", 129);
    freq.put("ари", 952);
    freq.put("аро", 179);
    freq.put("арн", 195);
    freq.put("арм", 47);
    freq.put("жул", 12);
    freq.put("яш", 39);
    freq.put("зам", 75);
    freq.put("зан", 123);
    freq.put("цип", 28);
    freq.put("зап", 259);
    freq.put("заи", 8);
    freq.put("зай", 43);
    freq.put("зак", 127);
    freq.put("зал", 87);
    freq.put("зад", 125);
    freq.put("зае", 46);
    freq.put("заб", 156);
    freq.put("зав", 156);
    freq.put("заг", 102);
    freq.put("Люб", 25);
    freq.put("тд", 57);
    freq.put("рфе", 19);
    freq.put("кни", 71);
    freq.put("кно", 20);
    freq.put("тв", 1200);
    freq.put("кна", 21);
    freq.put("кне", 12);
    freq.put("тм", 34);
    freq.put("ат ", 1403);
    freq.put("тн", 890);
    freq.put("Еле", 26);
    freq.put("ция", 627);
    freq.put("зая", 18);
    freq.put("заш", 8);
    freq.put("защ", 198);
    freq.put("зах", 59);
    freq.put("зац", 56);
    freq.put("тл", 171);
    freq.put("зар", 207);
    freq.put("зас", 69);
    freq.put("зат", 133);
    freq.put("цит", 192);
    freq.put("кци", 100);
    freq.put(" Кл", 44);
    freq.put("ЪР ", 12);
    freq.put("лва", 38);
    freq.put(" Кв", 13);
    freq.put("цо ", 9);
    freq.put("б ", 161);
    freq.put("оче", 82);
    freq.put("оча", 101);
    freq.put("ифт", 20);
    freq.put("очв", 102);
    freq.put("ифр", 10);
    freq.put(" хр", 88);
    freq.put("очи", 146);
    freq.put("очк", 29);
    freq.put("Кос", 32);
    freq.put("Кор", 20);
    freq.put("Коя", 10);
    freq.put("до", 1791);
    freq.put("дп", 108);
    freq.put("дм", 135);
    freq.put("Джо", 41);
    freq.put("дк", 139);
    freq.put("дл", 119);
    freq.put("ди", 2412);
    freq.put("АМ ", 14);
    freq.put("дж", 253);
    freq.put("дз", 9);
    freq.put("дд", 31);
    freq.put("щу ", 119);

    init3();
  }
  private static void init3() {
    
    freq.put("дв", 539);
    freq.put("дг", 16);
    freq.put("да", 5182);
    freq.put("дб", 19);
    freq.put("ипе", 29);
    freq.put("ипа", 31);
    freq.put("ипо", 24);
    freq.put("ипн", 10);
    freq.put("ипл", 23);
    freq.put("ипи", 18);
    freq.put("ипс", 48);
    freq.put("ипъ", 16);
    freq.put("дю", 13);
    freq.put("дя", 255);
    freq.put(" Бу", 147);
    freq.put("дъ", 529);
    freq.put("дц", 17);
    freq.put(" Бъ", 467);
    freq.put("дх", 25);
    freq.put("ду", 429);
    freq.put("Джу", 16);
    freq.put("дс", 299);
    freq.put("Ког", 37);
    freq.put("Коб", 9);
    freq.put("Коз", 14);
    freq.put("Кое", 9);
    freq.put("Кол", 116);
    freq.put("Кой", 52);
    freq.put("Кон", 53);
    freq.put("Ком", 42);
    freq.put("очт", 30);
    freq.put("ифо", 15);
    freq.put("ифл", 15);
    freq.put("ифи", 28);
    freq.put("кту", 45);
    freq.put("Бял", 10);
    freq.put("ктр", 48);
    freq.put("кть", 14);
    freq.put("ктъ", 14);
    freq.put("ох ", 26);
    freq.put("ури", 98);
    freq.put("урк", 17);
    freq.put("лже", 14);
    freq.put("урн", 133);
    freq.put("лжа", 71);
    freq.put("ура", 115);
    freq.put(" ръ", 91);
    freq.put("ург", 118);
    freq.put("урд", 8);
    freq.put("уре", 53);
    freq.put("лжи", 37);
    freq.put("урз", 13);
    freq.put("яци", 9);
    freq.put("що ", 529);
    freq.put(" ра", 1042);
    freq.put(" ре", 514);
    freq.put("уря", 14);
    freq.put("урс", 76);
    freq.put(" ри", 74);
    freq.put(" ро", 197);
    freq.put("урц", 27);
    freq.put("иц ", 91);
    freq.put("кте", 18);
    freq.put("кта", 59);
    freq.put("кто", 160);
    freq.put("ктн", 32);
    freq.put("кти", 163);
    freq.put("Дви", 9);
    freq.put("Два", 26);
    freq.put("Две", 18);
    freq.put(" Ем", 29);
    freq.put(" Ен", 27);
    freq.put("ига", 178);
    freq.put(" Ей", 17);
    freq.put(" Ек", 35);
    freq.put("иге", 12);
    freq.put(" Ед", 98);
    freq.put("игл", 10);
    freq.put("иги", 63);
    freq.put("иго", 39);
    freq.put(" Еб", 10);
    freq.put(" Ев", 136);
    freq.put("игн", 97);
    freq.put("яхт", 14);
    freq.put("ба ", 178);
    freq.put("ри ", 1109);
    freq.put("игу", 96);
    freq.put("игр", 160);
    freq.put(" Ех", 16);
    freq.put(" Ер", 11);
    freq.put(" Ес", 9);
    freq.put(" Ет", 53);
    freq.put("Дву", 13);
    freq.put("був", 11);
    freq.put("буд", 24);
    freq.put("бул", 43);
    freq.put("бук", 79);
    freq.put("бун", 15);
    freq.put("бум", 105);
    freq.put("ерб", 49);
    freq.put("хле", 12);
    freq.put("ркт", 8);
    freq.put("хля", 12);
    freq.put("рко", 49);
    freq.put("рки", 66);
    freq.put("аци", 489);
    freq.put("рке", 35);
    freq.put("рка", 113);
    freq.put("ркв", 20);
    freq.put("чо ", 47);
    freq.put("бут", 30);
    freq.put("бус", 31);
    freq.put("бур", 30);
    freq.put("буч", 13);
    freq.put("чих", 86);
    freq.put("чиц", 15);
    freq.put("чис", 70);
    freq.put("чит", 114);
    freq.put("Бог", 16);
    freq.put("чиш", 16);
    freq.put(" й", 48);
    freq.put("есъ", 21);
    freq.put("есу", 16);
    freq.put("ест", 822);
    freq.put("Щ", 135);
    freq.put("ма ", 1360);
    freq.put("еси", 139);
    freq.put("есл", 16);
    freq.put("еск", 158);
    freq.put("есн", 147);
    freq.put("есм", 8);
    freq.put("юн ", 9);
    freq.put("фър", 8);
    freq.put("еса", 109);
    freq.put("есв", 64);
    freq.put("есе", 316);
    freq.put("чие", 14);
    freq.put("чив", 56);
    freq.put("чим", 8);
    freq.put("чин", 123);
    freq.put("чии", 9);
    freq.put("чик", 10);
    freq.put("чил", 58);
    freq.put("вд", 141);
    freq.put("мва", 10);
    freq.put("въд", 9);
    freq.put("ва", 6493);
    freq.put("във", 296);
    freq.put("вг", 51);
    freq.put("вм", 36);
    freq.put("въо", 9);
    freq.put("во", 2295);
    freq.put("вп", 26);
    freq.put("ви", 3132);
    freq.put("вк", 349);
    freq.put("вл", 283);
    freq.put("АС ", 13);
    freq.put("вх", 15);
    freq.put("вц", 28);
    freq.put("вч", 58);
    freq.put("вр", 735);
    freq.put("вът", 23);
    freq.put("вт", 239);
    freq.put("ву", 84);
    freq.put("вю", 33);
    freq.put("вя", 443);
    freq.put("вш", 37);
    freq.put("въ", 1142);
    freq.put("е ", 17778);
    freq.put("Ева", 10);
    freq.put("йбо", 12);
    freq.put("ое ", 41);
    freq.put("Евр", 110);
    freq.put("ш ", 866);
    freq.put("ъпр", 105);
    freq.put("Бис", 8);
    freq.put(" и ", 2935);
    freq.put("ъпа", 19);
    freq.put("ъпв", 21);
    freq.put("ъпе", 14);
    freq.put("ъпи", 38);
    freq.put("ъпк", 31);
    freq.put("ъпл", 8);
    freq.put("ъпн", 31);
    freq.put("ъпо", 18);
    freq.put("аф ", 11);
    freq.put("Бот", 20);
    freq.put("утб", 175);
    freq.put("жаз", 13);
    freq.put("жав", 186);
    freq.put("жан", 48);
    freq.put("Ум", 9);
    freq.put("жал", 59);
    freq.put("жак", 10);
    freq.put("фла", 27);
    freq.put("пют", 31);
    freq.put("ЕЗ ", 17);
    freq.put("фли", 13);
    freq.put("нд ", 60);
    freq.put(" кн", 67);
    freq.put(" км", 35);
    freq.put("Кън", 15);
    freq.put(" ко", 1711);
    freq.put(" ки", 104);
    freq.put(" кл", 192);
    freq.put(" ке", 34);
    freq.put("Къд", 24);
    freq.put(" ка", 1684);
    freq.put(" кг", 15);
    freq.put(" кв", 109);
    freq.put(" кю", 10);
    freq.put("Къщ", 21);
    freq.put(" къ", 482);
    freq.put(" кр", 461);
    freq.put("Къс", 9);
    freq.put("Кър", 17);
    freq.put("шно", 59);
    freq.put("шни", 90);
    freq.put("шна", 59);
    freq.put("лин", 168);
    freq.put("ял ", 72);
    freq.put("лио", 60);
    freq.put("жах", 13);
    freq.put("жас", 27);
    freq.put("жар", 30);
    freq.put("жат", 60);
    freq.put("лив", 135);
    freq.put("охо", 49);
    freq.put(" тю", 9);
    freq.put("охи", 9);
    freq.put("охв", 10);
    freq.put("оха", 39);
    freq.put("Дав", 22);
    freq.put("Дан", 40);
    freq.put("Дам", 9);
    freq.put("Дал", 16);
    freq.put(" т", 4277);
    freq.put(" у", 1239);
    freq.put(" р", 2063);
    freq.put(" с", 12378);
    freq.put(" ц", 492);
    freq.put(" ч", 1794);
    freq.put(" ф", 799);
    freq.put(" х", 1051);
    freq.put(" ъ", 27);
    freq.put(" ш", 281);
    freq.put(" щ", 1189);
    freq.put(" ю", 60);
    freq.put(" я", 381);
    freq.put(" Ге", 115);
    freq.put("иби", 22);
    freq.put("ибл", 10);
    freq.put("ур ", 19);
    freq.put("ибе", 18);
    freq.put(" Т", 1036);
    freq.put("рве", 74);
    freq.put(" Р", 808);
    freq.put(" С", 2320);
    freq.put(" Ц", 297);
    freq.put("на ", 7750);
    freq.put(" Ф", 474);
    freq.put(" Х", 400);
    freq.put("ибр", 21);
    freq.put(" Ш", 170);
    freq.put(" Щ", 135);
    freq.put(" Ю", 81);
    freq.put(" Я", 123);
    freq.put(" в", 7003);
    freq.put(" г", 2544);
    freq.put(" а", 1894);
    freq.put(" б", 2630);
    freq.put(" ж", 539);
    freq.put(" з", 4724);
    freq.put(" д", 6613);
    freq.put(" е", 3501);
    freq.put(" к", 5205);
    freq.put(" л", 1662);
    freq.put(" и", 6209);
    freq.put(" яс", 28);
    freq.put(" о", 4791);
    freq.put(" п", 9057);
    freq.put(" м", 4884);
    freq.put(" н", 11182);
    freq.put("Кме", 10);
    freq.put("Дар", 10);
    freq.put(" В", 1463);
    freq.put("ици", 514);
    freq.put(" А", 1244);
    freq.put(" Б", 1975);
    freq.put(" Ж", 133);
    freq.put(" З", 797);
    freq.put(" Д", 1612);
    freq.put(" Е", 677);
    freq.put(" К", 1647);
    freq.put("ица", 348);
    freq.put(" И", 1053);
    freq.put(" Й", 64);
    freq.put("ице", 45);
    freq.put(" П", 2294);
    freq.put("охр", 9);
    freq.put(" Н", 1868);
    freq.put("хне", 13);
    freq.put("бащ", 19);
    freq.put("рия", 759);
    freq.put("хна", 23);
    freq.put("бат", 82);
    freq.put("рит", 477);
    freq.put("бар", 48);
    freq.put("бас", 33);
    freq.put("рич", 100);
    freq.put("бач", 33);
    freq.put("рих", 85);
    freq.put("риф", 20);
    freq.put("иг ", 17);
    freq.put(" Е ", 72);
    freq.put("бак", 11);
    freq.put("бал", 56);
    freq.put("рий", 59);
    freq.put("бай", 16);
    freq.put("рип", 28);
    freq.put("рио", 79);
    freq.put("бам", 15);
    freq.put("бан", 126);
    freq.put("бав", 238);
    freq.put("рив", 116);
    freq.put("хня", 15);
    freq.put("баб", 30);
    freq.put("риз", 111);
    freq.put("риж", 26);
    freq.put("бад", 20);
    freq.put("рид", 37);
    freq.put("лиш", 44);
    freq.put("чор", 8);
    freq.put("лия", 184);
    freq.put("Тя ", 20);
    freq.put("иш ", 219);
    freq.put("лих", 46);
    freq.put("рк ", 27);
    freq.put("ТИ ", 20);
    freq.put("чов", 158);
    freq.put(" О", 997);
    freq.put("ел ", 345);
    freq.put("ман", 215);
    freq.put("мам", 217);
    freq.put("мал", 344);
    freq.put("мак", 41);
    freq.put("май", 182);
    freq.put("маз", 27);
    freq.put("маг", 110);
    freq.put("мав", 18);
    freq.put("маш", 115);
    freq.put("мач", 75);
    freq.put("мац", 66);
    freq.put("мах", 52);
    freq.put("мат", 337);
    freq.put("мас", 66);
    freq.put("мар", 135);
    freq.put("Жи", 34);
    freq.put("Кам", 30);
    freq.put("чи ", 214);
    freq.put("ес ", 405);
    freq.put("юни", 19);
    freq.put("хро", 8);
    freq.put("ея", 155);
    freq.put("ещ", 684);
    freq.put("еш", 719);
    freq.put("хри", 11);
    freq.put("еъ", 13);
    freq.put("ех", 241);
    freq.put("еф", 250);
    freq.put("еч", 871);
    freq.put("ец", 437);
    freq.put("ес", 2296);
    freq.put("ер", 2617);
    freq.put("хра", 94);
    freq.put("ет", 3649);
    freq.put("в ", 5058);
    freq.put("м", 16526);
    freq.put("ен", 6258);
    freq.put("ем", 1443);
    freq.put("еп", 404);
    freq.put("ео", 309);
    freq.put("ей", 667);
    freq.put("еи", 72);
    freq.put("ел", 2566);
    freq.put("ек", 1364);
    freq.put("ее", 191);
    freq.put("ед", 3251);
    freq.put("ез", 1062);
    freq.put("еж", 553);
    freq.put("еб", 429);
    freq.put("еа", 130);
    freq.put("ег", 564);
    freq.put("ев", 1250);
    freq.put("ЛВ ", 8);
    freq.put("шъ", 30);
    freq.put("шу", 36);
    freq.put("Жен", 27);
    freq.put("оет", 143);
    freq.put("вдъ", 14);
    freq.put("спу", 11);
    freq.put(" яй", 12);
    freq.put("оем", 30);
    freq.put("оен", 65);
    freq.put("оек", 63);
    freq.put("вда", 12);
    freq.put("ИЯ ", 67);
    freq.put("оеж", 13);
    freq.put("оев", 36);
    freq.put("вди", 99);
    freq.put("шк", 164);
    freq.put("шл", 25);
    freq.put("ши", 422);
    freq.put("шо", 136);
    freq.put("шп", 10);
    freq.put("шм", 10);
    freq.put("шн", 211);
    freq.put("шв", 45);
    freq.put("ша", 384);
    freq.put("ше", 711);
    freq.put("жва", 18);
    freq.put("Сер", 34);
    freq.put("В", 1466);
    freq.put(" ил", 215);
    freq.put(" ик", 46);
    freq.put("лиг", 42);
    freq.put(" ин", 404);
    freq.put(" им", 785);
    freq.put(" иг", 116);
    freq.put(" из", 1181);
    freq.put("афт", 17);
    freq.put(" ид", 134);
    freq.put("ъп ", 20);
    freq.put("афо", 9);
    freq.put(" ия", 12);
    freq.put("афи", 61);
    freq.put(" ит", 22);
    freq.put("афе", 45);
    freq.put(" ир", 17);
    freq.put("афа", 15);
    freq.put("шли", 9);
    freq.put("шле", 10);
    freq.put("бах", 12);
    freq.put("змъ", 17);
    freq.put("гно", 35);
    freq.put("жа ", 168);
    freq.put("гни", 16);
    freq.put("гне", 47);
    freq.put("гна", 137);
    freq.put("рши", 67);
    freq.put("ршв", 22);
    freq.put("рша", 12);
    freq.put("лиз", 223);
    freq.put("рше", 13);
    freq.put("РБ ", 72);
    freq.put("нди", 120);
    freq.put("ндо", 42);
    freq.put("нда", 138);
    freq.put("ндж", 35);
    freq.put("нде", 41);
    freq.put("ндъ", 26);
    freq.put("нду", 41);
    freq.put("ндр", 33);
    freq.put("ндс", 9);
    freq.put("зми", 42);
    freq.put("яла", 70);
    freq.put("змо", 52);
    freq.put("зма", 34);
    freq.put("ещо", 183);
    freq.put("зме", 54);
    freq.put("яло", 57);
    freq.put(" ен", 44);
    freq.put("шън", 15);
    freq.put("фей", 36);
    freq.put("фек", 38);
    freq.put("фен", 58);
    freq.put("фев", 26);
    freq.put("Ру", 139);
    freq.put(" ме", 791);
    freq.put(" ма", 891);
    freq.put("Ръ", 8);
    freq.put("Кин", 12);
    freq.put(" мн", 330);
    freq.put(" мл", 139);
    freq.put(" мк", 18);
    freq.put(" ми", 1092);
    freq.put(" ее", 12);
    freq.put("гът", 16);
    freq.put("гър", 33);
    freq.put(" еж", 9);
    freq.put("гъл", 32);
    freq.put("шпа", 9);
    freq.put("гън", 10);
    freq.put("гъз", 8);
    freq.put(" еб", 28);
    freq.put("Ра", 237);
    freq.put(" му", 269);
    freq.put(" ев", 125);
    freq.put("Ре", 151);
    freq.put(" мя", 79);
    freq.put("Ри", 51);
    freq.put(" ег", 8);
    freq.put("Ро", 128);
    freq.put(" мъ", 197);
    freq.put("ОК ", 12);
    freq.put("фер", 99);
    freq.put("фес", 68);
    freq.put("фет", 23);
    freq.put("зо ", 64);
    freq.put("ут ", 32);
    freq.put("У ", 34);
    freq.put("зиц", 29);
    freq.put("зир", 89);
    freq.put("зис", 26);
    freq.put("зит", 44);
    freq.put("зия", 77);
    freq.put("наз", 43);
    freq.put("над", 208);
    freq.put("нае", 155);
    freq.put("нав", 146);
    freq.put("наг", 135);
    freq.put("наб", 48);
    freq.put("нао", 10);
    freq.put("нап", 323);
    freq.put("нам", 216);
    freq.put("нан", 77);
    freq.put("нак", 74);
    freq.put("нал", 602);
    freq.put("наи", 38);
    freq.put("най", 342);
    freq.put("ашк", 25);
    freq.put("аши", 130);
    freq.put("ашн", 31);
    freq.put("ли ", 1697);
    freq.put("аша", 58);
    freq.put("аше", 134);
    freq.put(" т ", 25);
    freq.put("нац", 96);
    freq.put("нач", 253);
    freq.put("нах", 168);
    freq.put("нат", 904);
    freq.put("нау", 36);
    freq.put("нар", 192);
    freq.put("нас", 256);
    freq.put("ная", 26);
    freq.put("наш", 92);
    freq.put("зид", 52);
    freq.put("зиа", 8);
    freq.put("зив", 20);
    freq.put("зиг", 14);
    freq.put("зим", 54);
    freq.put("зин", 93);
    freq.put("зии", 12);
    freq.put("зик", 109);
    freq.put("зил", 18);
    freq.put("язо", 20);
    freq.put("яза", 41);
    freq.put("язв", 32);
    freq.put("лка", 179);
    freq.put("цу", 27);
    freq.put("лки", 163);
    freq.put("лко", 523);
    freq.put("свя", 37);
    freq.put("уда", 62);
    freq.put(" фъ", 8);
    freq.put("кед", 14);
    freq.put("кел", 16);
    freq.put("кей", 9);
    freq.put(" фу", 121);
    freq.put("кем", 17);
    freq.put(" фр", 37);
    freq.put("ято", 126);
    freq.put("ятн", 82);
    freq.put("ие ", 846);
    freq.put("яти", 11);
    freq.put("яте", 151);
    freq.put("ята", 555);
    freq.put("ятъ", 20);
    freq.put("кет", 73);
    freq.put(" фо", 128);
    freq.put("кер", 24);
    freq.put(" фл", 21);
    freq.put("кеф", 21);
    freq.put(" фи", 228);
    freq.put(" фе", 142);
    freq.put(" фа", 106);
    freq.put("сва", 181);
    freq.put("цв", 40);
    freq.put("све", 227);
    freq.put("сви", 56);
    freq.put("цк", 38);
    freq.put("сво", 92);
    freq.put("Гле", 26);
    freq.put("Гла", 21);
    freq.put("Гло", 13);
    freq.put(" лъ", 35);
    freq.put(" Йо", 48);
    freq.put(" Йе", 9);
    freq.put("изо", 117);
    freq.put("изп", 187);
    freq.put("изм", 84);
    freq.put("изн", 139);
    freq.put("изк", 91);
    freq.put("изл", 146);
    freq.put("изи", 166);
    freq.put("изд", 59);
    freq.put("изе", 16);
    freq.put("изв", 145);
    freq.put("изг", 102);
    freq.put("иза", 220);
    freq.put("изб", 149);
    freq.put("Сев", 12);
    freq.put("щ ", 133);
    freq.put("ует", 14);
    freq.put("изя", 17);
    freq.put("ааа", 74);
    freq.put("изъ", 36);
    freq.put("изч", 38);
    freq.put("изх", 11);
    freq.put("изт", 66);
    freq.put("изу", 13);
    freq.put("изр", 57);
    freq.put("изс", 31);
    freq.put("ржа", 152);
    freq.put("бче", 8);
    freq.put("зри", 33);
    freq.put("зре", 44);
    freq.put("дя ", 87);
    freq.put("Суп", 20);
    freq.put("рош", 25);
    freq.put("роя", 92);
    freq.put("рос", 278);
    freq.put("рор", 36);
    freq.put("роу", 21);
    freq.put("рот", 180);
    freq.put("рох", 9);
    freq.put("роф", 116);
    freq.put("роч", 42);
    freq.put("роц", 36);
    freq.put("рой", 68);
    freq.put("рои", 112);
    freq.put("рол", 124);
    freq.put("рок", 81);
    freq.put("рон", 79);
    freq.put("ф", 2358);
    freq.put("роп", 164);
    freq.put("ся ", 42);
    freq.put("роб", 151);
    freq.put("щни", 22);
    freq.put("рог", 104);
    freq.put("ров", 382);
    freq.put("рое", 125);
    freq.put("род", 460);
    freq.put("роз", 72);
    freq.put("рож", 36);
    freq.put("зря", 11);
    freq.put("мм ", 10);
    freq.put(" ещ", 12);
    freq.put(" ет", 52);
    freq.put("К", 1654);
    freq.put("мон", 84);
    freq.put("мом", 148);
    freq.put("мой", 20);
    freq.put("мои", 15);
    freq.put("мол", 72);
    freq.put("мок", 17);
    freq.put("мое", 11);
    freq.put("мод", 55);
    freq.put("моз", 22);
    freq.put("мож", 349);
    freq.put("моб", 53);
    freq.put("Фу", 75);
    freq.put("мог", 162);
    freq.put("мов", 46);
    freq.put(" Са", 163);
    freq.put("Бал", 39);
    freq.put(" Св", 111);
    freq.put("Бай", 14);
    freq.put(" Сд", 10);
    freq.put(" Се", 145);
    freq.put("Бан", 41);
    freq.put(" Си", 172);
    freq.put(" Ск", 53);
    freq.put("Баб", 13);
    freq.put(" См", 35);
    freq.put(" Сн", 40);
    freq.put(" Со", 265);
    freq.put(" Сп", 155);
    freq.put(" Ср", 28);
    freq.put(" Ст", 378);
    freq.put("Бащ", 11);
    freq.put("Бар", 58);
    freq.put("Бас", 9);
    freq.put("Фо", 99);
    freq.put("моя", 33);
    freq.put("мощ", 59);
    freq.put("Фи", 49);
    freq.put("моц", 39);
    freq.put("мос", 30);
    freq.put("мор", 93);
    freq.put("моу", 11);
    freq.put("мот", 106);
    freq.put(" ло", 107);
    freq.put("АЙ ", 21);
    freq.put("уй ", 20);
    freq.put("ън ", 148);
    freq.put("мчи", 8);
    freq.put("ва ", 2881);
    freq.put("йер", 10);
    freq.put("фе ", 18);
    freq.put("зот", 8);
    freq.put("зор", 40);
    freq.put("зос", 11);
    freq.put("зоч", 13);
    freq.put("зох", 13);
    freq.put("мче", 47);
    freq.put("рън", 25);
    freq.put("ръм", 13);
    freq.put("ръп", 16);
    freq.put("рък", 67);
    freq.put("ръд", 8);
    freq.put("ръз", 54);
    freq.put("ръж", 29);
    freq.put("ръб", 14);
    freq.put("ръг", 61);
    freq.put("ръв", 37);
    freq.put("аца", 23);
    freq.put("аце", 11);
    freq.put(" м ", 58);
    freq.put("нве", 42);
    freq.put("нва", 14);
    freq.put("р", 28868);
    freq.put("Р ", 104);
    freq.put("ръщ", 71);
    freq.put("ръх", 20);
    freq.put("ръч", 77);
    freq.put("ръц", 42);
    freq.put("ръс", 104);
    freq.put("рът", 95);
    freq.put("зов", 63);
    freq.put("зоб", 28);
    freq.put("зод", 21);
    freq.put("зол", 10);
    freq.put("зоп", 25);
    freq.put("зон", 87);
    freq.put("кръ", 78);
    freq.put("Ук", 8);
    freq.put("ута", 57);
    freq.put("Уи", 19);
    freq.put("Уо", 14);
    freq.put("Ун", 35);
    freq.put("уте", 17);
    freq.put("утк", 12);
    freq.put("Ув", 14);
    freq.put("ути", 71);
    freq.put("уто", 36);
    freq.put("Уж", 9);
    freq.put("Уе", 10);
    freq.put("Уд", 15);
    freq.put("лии", 9);
    freq.put("лий", 55);
    freq.put("лик", 303);
    freq.put("лил", 38);
    freq.put("лим", 82);
    freq.put(" тр", 631);
    freq.put(" ту", 268);
    freq.put("лип", 136);
    freq.put("лиа", 47);
    freq.put(" тя", 110);
    freq.put("аш ", 354);
    freq.put("лид", 26);
    freq.put("лие", 84);
    freq.put("лиж", 11);
    freq.put(" тъ", 222);
    freq.put("яра", 14);
    freq.put("ярв", 27);
    freq.put("ярн", 22);
    freq.put(" те", 693);
    freq.put("лищ", 65);
    freq.put(" та", 683);
    freq.put(" тв", 119);
    freq.put("лир", 58);
    freq.put("лис", 175);
    freq.put("лит", 367);
    freq.put(" то", 1056);
    freq.put("лиф", 15);
    freq.put(" ти", 454);
    freq.put("лиц", 245);
    freq.put("лич", 230);
    freq.put("утр", 199);
    freq.put("Ут", 25);
    freq.put("Ус", 23);
    freq.put("Уч", 30);
    freq.put("кри", 240);
    freq.put("зи ", 497);
    freq.put("кро", 46);
    freq.put("кра", 413);
    freq.put("кре", 113);
    freq.put("лк ", 11);
    freq.put(" Зд", 85);
    freq.put(" Зе", 36);
    freq.put(" Зв", 16);
    freq.put(" За", 486);
    freq.put("Ж", 134);
    freq.put(" Зо", 11);
    freq.put(" Зн", 23);
    freq.put(" Зл", 28);
    freq.put(" Зи", 11);
    freq.put("Кир", 20);
    freq.put("Кит", 36);
    freq.put("иев", 86);
    freq.put("ием", 64);
    freq.put("иен", 68);
    freq.put("ят ", 1088);
    freq.put("иел", 13);
    freq.put("ке ", 14);
    freq.put("Фот", 28);
    freq.put("ойч", 22);
    freq.put("иер", 77);
    freq.put("иес", 8);
    freq.put("иет", 317);
    freq.put("Кил", 9);
    freq.put("иеш", 19);
    freq.put("Ким", 12);
    freq.put("Кип", 9);
    freq.put("ц ", 273);
    freq.put("бсо", 14);
    freq.put("бси", 9);
    freq.put("бсл", 10);
    freq.put("зце", 8);
    freq.put("щи", 440);
    freq.put("щн", 112);
    freq.put("що", 699);
    freq.put("ща", 666);
    freq.put("ще", 1502);
    freq.put("нза", 14);
    freq.put("рму", 20);
    freq.put("из ", 35);
    freq.put("рме", 25);
    freq.put("аа ", 46);
    freq.put("рма", 223);
    freq.put("рмо", 17);
    freq.put("рми", 57);
    freq.put("щь", 9);
    freq.put("щя", 27);
    freq.put("щу", 150);
    freq.put("щт", 12);
    freq.put("елн", 266);
    freq.put("бст", 52);
    freq.put("бсъ", 23);
    freq.put("елс", 130);
    freq.put("дял", 15);
    freq.put("дяв", 40);
    freq.put("дяд", 15);
    freq.put("сят", 29);
    freq.put("леш", 13);
    freq.put("щью", 9);
    freq.put("Мла", 37);
    freq.put("леф", 61);
    freq.put("Изг", 11);
    freq.put("сяв", 19);
    freq.put("ро ", 299);
    freq.put("сян", 8);
    freq.put("Изб", 19);
    freq.put("сяк", 71);
    freq.put("чко", 109);
    freq.put("дящ", 14);
    freq.put("чки", 301);
    freq.put("дят", 51);
    freq.put("чка", 112);
    freq.put("дях", 25);
    freq.put("вши", 27);
    freq.put("ммм", 25);
    freq.put("шот", 11);
    freq.put(" н ", 36);
    freq.put("жър", 20);
    freq.put("юбе", 12);
    freq.put("юби", 102);
    freq.put("юбо", 74);
    freq.put("си ", 1498);
    freq.put("лрд", 13);
    freq.put(" С ", 90);
    freq.put("зк", 234);
    freq.put("Дру", 18);
    freq.put("мо ", 364);
    freq.put("Ф ", 10);
    freq.put("юз ", 10);
    freq.put("ънъ", 8);
    freq.put("СВ ", 9);
    freq.put("ънш", 9);
    freq.put("ъня", 14);
    freq.put("ънт", 16);
    freq.put("ънс", 14);
    freq.put("ънц", 20);
    freq.put("ънч", 68);
    freq.put("вас", 35);
    freq.put("вар", 170);
    freq.put("ват", 892);
    freq.put("вах", 163);
    freq.put("вач", 23);
    freq.put("вац", 17);
    freq.put("ващ", 171);
    freq.put("ваш", 179);
    freq.put("вав", 16);
    freq.put("вад", 29);
    freq.put("важ", 75);
    freq.put("вай", 174);
    freq.put("вал", 261);
    freq.put("вак", 32);
    freq.put("ван", 703);
    freq.put("вам", 624);
    freq.put("ънк", 30);
    freq.put("ъни", 44);
    freq.put("ъна", 8);
    freq.put("ъне", 13);
    freq.put("ойд", 43);
    freq.put("цъ", 28);
    freq.put("че", 2788);
    freq.put("чв", 205);
    freq.put("ча", 1090);
    freq.put("чо", 222);
    freq.put("чн", 542);
    freq.put("чл", 8);
    freq.put("чк", 530);
    freq.put("чи", 820);
    freq.put("лс ", 9);
    freq.put("ул ", 87);
    freq.put("ш", 3079);
    freq.put("ъл ", 113);
    freq.put("чу", 255);
    freq.put("чт", 55);
    freq.put("чр", 24);
    freq.put("во ", 964);
    freq.put("чъ", 20);
    freq.put("ъ ", 39);
    freq.put("БГ ", 34);
    freq.put("луд", 31);
    freq.put("луз", 9);
    freq.put("луж", 70);
    freq.put("луб", 31);
    freq.put("унк", 20);
    freq.put("луг", 40);
    freq.put("лув", 20);
    freq.put("лун", 11);
    freq.put("лум", 14);
    freq.put("луп", 31);
    freq.put("унд", 34);
    freq.put("унг", 11);
    freq.put("уна", 60);
    freq.put(" А ", 158);
    freq.put(" о ", 39);
    freq.put("вме", 28);
    freq.put("лух", 10);
    freq.put("луч", 191);
    freq.put("лус", 9);
    freq.put("лут", 9);
    freq.put("луш", 60);
    freq.put("Изт", 18);
    freq.put("Изр", 12);
    freq.put("О", 1001);
    freq.put("но ", 2269);
    freq.put("мър", 65);
    freq.put("мът", 29);
    freq.put("мъч", 18);
    freq.put("мъл", 14);
    freq.put("мък", 16);
    freq.put("мън", 47);
    freq.put("мъд", 8);
    freq.put("мъж", 121);
    freq.put("жки", 39);
    freq.put("жко", 18);
    freq.put("жка", 45);
    freq.put("лм ", 30);
    freq.put("гет", 17);
    freq.put("гер", 50);
    freq.put("кг ", 15);
    freq.put("яга", 54);
    freq.put("ягв", 8);
    freq.put("са ", 874);
    freq.put("гел", 33);
    freq.put("гей", 22);
    freq.put("лоп", 8);
    freq.put("лом", 28);
    freq.put("лон", 87);
    freq.put("лок", 44);
    freq.put("лол", 8);
    freq.put("лож", 191);
    freq.put("лоз", 37);
    freq.put("лод", 30);
    freq.put("лов", 311);
    freq.put("лог", 139);
    freq.put("лоб", 32);
    freq.put(" шу", 12);
    freq.put(" ши", 29);
    freq.put(" шп", 10);
    freq.put("ав ", 99);
    freq.put(" ша", 72);
    freq.put(" ше", 84);
    freq.put("лош", 51);
    freq.put("лощ", 12);
    freq.put("лот", 126);
    freq.put("лоу", 17);
    freq.put("лор", 15);
    freq.put("лос", 38);
    freq.put(" Не", 354);
    freq.put(" На", 541);
    freq.put(" Но", 364);
    freq.put(" Ни", 146);
    freq.put("хе ", 11);
    freq.put("ик", 1703);
    freq.put("ил", 1708);
    freq.put("ии", 353);
    freq.put("ий", 319);
    freq.put("ио", 590);
    freq.put("ип", 380);
    freq.put("им", 2091);
    freq.put("ин", 3388);
    freq.put("ив", 1248);
    freq.put("иг", 682);
    freq.put("иа", 415);
    freq.put("иб", 124);
    freq.put("иж", 263);
    freq.put("из", 1946);
    freq.put("ид", 828);
    freq.put("ие", 1538);
    freq.put("адя", 38);
    freq.put("ижт", 45);
    freq.put("адъ", 99);
    freq.put("аду", 21);
    freq.put("адс", 40);
    freq.put("адр", 44);
    freq.put("Ас", 28);
    freq.put("тфо", 38);
    freq.put("Ква", 8);
    freq.put("адп", 26);
    freq.put("адо", 83);
    freq.put("адн", 126);
    freq.put("адм", 19);
    freq.put("адк", 37);
    freq.put("ади", 341);
    freq.put("адж", 52);
    freq.put("аде", 231);
    freq.put("адв", 50);
    freq.put("ада", 257);
    freq.put("иъ", 15);
    freq.put("иш", 563);
    freq.put("ищ", 242);
    freq.put("ия", 4201);
    freq.put("ит", 4861);
    freq.put("иу", 19);
    freq.put("ир", 1365);
    freq.put("ис", 2112);
    freq.put("иц", 1011);
    freq.put("ич", 1261);
    freq.put("иф", 113);
    freq.put("их", 632);
    freq.put(" Ню", 13);
    freq.put(" Ня", 138);
    freq.put("С ", 263);
    freq.put(" Ир", 26);
    freq.put("би ", 195);
    freq.put("€ ", 8);
    freq.put("Вра", 11);
    freq.put("Вре", 29);
    freq.put("ПО ", 11);
    freq.put("ми ", 925);
    freq.put(" У ", 9);
    freq.put("бод", 48);
    freq.put("бож", 17);
    freq.put("е", 50397);
    freq.put("бов", 63);
    freq.put("бог", 17);
    freq.put("бом", 13);
    freq.put("бон", 29);
    freq.put("боп", 14);
    freq.put("бой", 29);
    freq.put("бок", 32);
    freq.put("бол", 316);
    freq.put("бор", 205);
    freq.put("бос", 13);
    freq.put("бот", 365);
    freq.put("боя", 17);
    freq.put("Бив", 16);
    freq.put(" Ко", 442);
    freq.put("дхо", 18);
    freq.put("ъюз", 18);
    freq.put("ъю", 18);
    freq.put("ъщ", 301);
    freq.put("ъъ", 11);
    freq.put("ъф", 19);
    freq.put("ъх", 53);
    freq.put("ъц", 77);
    freq.put("ъч", 171);
    freq.put("ър", 2165);
    freq.put("ъс", 555);
    freq.put("ът", 867);
    freq.put("уле", 21);
    freq.put("ула", 51);
    freq.put("ълъ", 15);
    freq.put("лск", 75);
    freq.put("лси", 15);
    freq.put("ули", 89);
    freq.put("ълт", 29);
    freq.put("улк", 9);
    freq.put("воя", 47);
    freq.put("ч ", 209);
    freq.put("вот", 325);
    freq.put("вос", 29);
    freq.put("вор", 319);
    freq.put("вол", 145);
    freq.put("вок", 18);
    freq.put("вой", 51);
    freq.put("вои", 23);
    freq.put("воп", 12);
    freq.put("вог", 11);
    freq.put("вов", 15);
    freq.put("воб", 45);
    freq.put("воз", 23);
    freq.put("вое", 23);
    freq.put("вод", 212);
    freq.put("лст", 106);
    freq.put("улс", 10);
    freq.put("ълк", 16);
    freq.put("улт", 86);
    freq.put("ъле", 20);
    freq.put("ълж", 121);
    freq.put("ълз", 9);
    freq.put("ъла", 14);
    freq.put("ълб", 16);
    freq.put("ълг", 653);
    freq.put("ъм", 757);
    freq.put("ън", 444);
    freq.put("ъо", 54);
    freq.put("ъп", 321);
    freq.put("ъй", 25);
    freq.put("ък", 400);
    freq.put("ъл", 1181);
    freq.put("ъд", 495);
    freq.put("ъе", 20);
    freq.put("ъж", 307);
    freq.put("ъз", 327);
    freq.put("ъб", 211);
    freq.put("ъв", 589);
    freq.put("ъг", 125);
    freq.put("жду", 96);
    freq.put("ижд", 78);
    freq.put(" ол", 28);
    freq.put(" ок", 114);
    freq.put("път", 238);
    freq.put(" ом", 12);
    freq.put("пър", 211);
    freq.put("АЩ ", 60);
    freq.put(" ог", 52);
    freq.put(" ов", 12);
    freq.put(" од", 17);
    freq.put(" оз", 22);
    freq.put("лу ", 20);
    freq.put("ун ", 24);
    freq.put(" ощ", 193);
    freq.put("ъй ", 24);
    freq.put(" ос", 322);
    freq.put(" ор", 85);
    freq.put("пън", 8);
    freq.put("пък", 64);
    freq.put("пъл", 124);
    freq.put(" оч", 100);
    freq.put(" оц", 22);
    freq.put("жда", 410);
    freq.put("жде", 76);
    freq.put("жди", 22);
    freq.put("ждо", 15);
    freq.put("ББ ", 15);
    freq.put("зку", 22);
    freq.put("зкр", 37);
    freq.put("нои", 8);
    freq.put("ной", 8);
    freq.put("нок", 16);
    freq.put("нол", 25);
    freq.put("ном", 135);
    freq.put("нон", 28);
    freq.put("ноо", 21);
    freq.put("ноп", 26);
    freq.put("нов", 945);
    freq.put("ног", 336);
    freq.put("нод", 9);
    freq.put("ное", 27);
    freq.put("нож", 17);
    freq.put("ноз", 44);
    freq.put(" х ", 17);
    freq.put("нош", 21);
    freq.put("нощ", 119);
    freq.put("нор", 37);
    freq.put("нос", 374);
    freq.put("нот", 261);
    freq.put("зко", 20);
    freq.put("зкл", 24);
    freq.put("зки", 31);
    freq.put("ихи", 11);
    freq.put("зка", 92);
    freq.put("лма", 26);
    freq.put("уци", 35);
    freq.put("сат", 63);
    freq.put("лми", 19);
    freq.put("сах", 26);
    freq.put("б", 8703);
    freq.put(" цъ", 15);
    freq.put(" ця", 79);
    freq.put(" ца", 24);
    freq.put(" цв", 37);
    freq.put(" це", 253);
    freq.put(" ци", 75);
    freq.put("сал", 61);
    freq.put("сай", 89);
    freq.put("сам", 334);
    freq.put("сан", 82);
    freq.put("сав", 15);
    freq.put("саж", 18);
    freq.put("сад", 20);
    freq.put("яг ", 23);
    freq.put(" Ла", 63);
    freq.put(" Ле", 149);
    freq.put(" Ли", 103);
    freq.put(" Ло", 98);
    freq.put("Х ", 15);
    freq.put("ло ", 318);
    freq.put("авс", 16);
    freq.put("авр", 31);
    freq.put("авт", 84);
    freq.put("авя", 227);
    freq.put("авъ", 68);
    freq.put("кб ", 19);
    freq.put("аве", 272);
    freq.put("авд", 12);
    freq.put("ава", 1127);
    freq.put("авн", 147);
    freq.put("аво", 169);
    freq.put("ави", 630);
    freq.put("авл", 104);
    freq.put("авк", 61);
    freq.put("Здр", 85);
    freq.put(" Лу", 69);
    freq.put(" Лю", 42);
    freq.put(" Ля", 9);
    freq.put("Биз", 15);
    freq.put("зте", 13);
    freq.put("зто", 42);
    freq.put("и ", 17724);
    freq.put("хен", 8);
    freq.put("хем", 16);
    freq.put("хей", 13);
    freq.put("Мър", 12);
    freq.put("ад ", 286);
    freq.put("Оли", 21);
    freq.put("Вто", 17);
    freq.put("хех", 10);
    freq.put("Ц", 301);
    freq.put("Мъж", 35);
    freq.put(" Ща", 10);
    freq.put("зтр", 26);
    freq.put("зтъ", 14);
    freq.put("бхо", 11);
    freq.put("анк", 119);
    freq.put("Са", 163);
    freq.put("Св", 111);
    freq.put("Се", 146);
    freq.put("Сд", 10);
    freq.put("Си", 176);
    freq.put("Сл", 149);
    freq.put("Ск", 53);
    freq.put("Сн", 40);
    freq.put("См", 35);
    freq.put("Сп", 155);
    freq.put("Со", 265);
    freq.put("бив", 66);
    freq.put("биз", 46);
    freq.put("бие", 27);
    freq.put("бик", 32);
    freq.put("бил", 243);
    freq.put("бий", 38);
    freq.put("био", 21);
    freq.put("бим", 90);
    freq.put("бин", 42);
    freq.put("бит", 179);
    freq.put("бир", 149);
    freq.put("бис", 11);
    freq.put("бич", 104);
    freq.put("бих", 54);
    freq.put("бия", 31);
    freq.put("ощ ", 67);
    freq.put("Ср", 28);
    freq.put("Су", 35);
    freq.put("Ст", 380);
    freq.put("Съ", 148);
    freq.put("уд", 491);
    freq.put("миз", 10);
    freq.put("мие", 54);
    freq.put("миг", 24);
    freq.put("мив", 30);
    freq.put("мин", 315);
    freq.put("мил", 98);
    freq.put("мик", 61);
    freq.put("бо ", 21);
    freq.put(" Ук", 8);
    freq.put(" Уи", 19);
    freq.put(" Уо", 14);
    freq.put(" Ум", 9);
    freq.put(" Ун", 35);
    freq.put(" Ув", 14);
    freq.put(" Уж", 9);
    freq.put(" Уд", 15);
    freq.put(" Уе", 10);
    freq.put(" Ут", 25);
    freq.put(" Ус", 23);
    freq.put(" Уч", 30);
    freq.put("тде", 25);
    freq.put("миц", 86);
    freq.put("мих", 18);
    freq.put("тда", 25);
    freq.put("мис", 250);
    freq.put("мир", 113);
    freq.put("мия", 91);
    freq.put("ПИ ", 8);
    freq.put("миш", 19);
    freq.put("ГА ", 37);
    freq.put("Пут", 10);
    freq.put(" жа", 34);
    freq.put("фут", 106);
    freq.put("Гъ", 41);
    freq.put("Гю", 9);
    freq.put("Гу", 22);
    freq.put(" же", 228);
    freq.put("Гр", 107);
    freq.put("Гл", 62);
    freq.put("Ги", 12);
    freq.put("Го", 122);
    freq.put("Га", 71);
    freq.put("Ге", 117);
    freq.put("фун", 9);
    freq.put("тв ", 18);
    freq.put("тас", 49);
    freq.put("тар", 274);
    freq.put("тат", 385);
    freq.put("Рон", 14);
    freq.put("Ром", 12);
    freq.put("тач", 14);
    freq.put("тац", 29);
    freq.put("Роб", 13);
    freq.put("таш", 17);
    freq.put("МИ ", 34);
    freq.put("Род", 25);
    freq.put("тая", 61);
    freq.put("Пси", 8);
    freq.put(" жъ", 16);
    freq.put("таб", 39);
    freq.put("таг", 14);
    freq.put("тав", 416);
    freq.put("тае", 58);
    freq.put("я", 10446);
    freq.put("таз", 150);
    freq.put("таж", 40);
    freq.put("тай", 106);
    freq.put("таи", 12);
    freq.put("тал", 232);
    freq.put("так", 306);
    freq.put("тан", 569);
    freq.put("там", 191);
    freq.put("тап", 19);
    freq.put("уп ", 14);
    freq.put("йъ", 13);
    freq.put("йс", 401);
    freq.put("йр", 17);
    freq.put("йт", 575);
    freq.put("йф", 22);
    freq.put("йч", 45);
    freq.put("йц", 48);
    freq.put("йй", 9);
    freq.put("йл", 125);
    freq.put("йк", 269);
    freq.put("йн", 388);
    freq.put("йм", 43);
    freq.put("йп", 20);
    freq.put("йо", 52);
    freq.put("йб", 30);
    freq.put("йв", 33);
    freq.put("йе", 20);
    freq.put("йд", 154);
    freq.put("йз", 16);
    freq.put("убл", 180);
    freq.put("лча", 11);
    freq.put("дпи", 47);
    freq.put("уби", 107);
    freq.put("дпо", 33);
    freq.put("убо", 16);
    freq.put("лчи", 8);
    freq.put("дпа", 9);
    freq.put("уба", 118);
    freq.put("убе", 38);
    freq.put("й", 3918);
    freq.put("Т ", 180);
    freq.put("йс ", 19);
    freq.put("№ ", 43);
    freq.put("убя", 9);
    freq.put("Ата", 20);
    freq.put("убт", 9);
    freq.put("убс", 9);
    freq.put("убр", 8);
    freq.put("жи ", 143);
    freq.put("цо", 38);
    freq.put("юст", 12);
    freq.put("вяш", 13);
    freq.put("нк ", 22);
    freq.put("Кри", 34);
    freq.put("жор", 8);
    freq.put("Кра", 45);
    freq.put("ше ", 347);
    freq.put("гр ", 77);
    freq.put("вяр", 42);
    freq.put("вил", 115);
    freq.put("вик", 59);
    freq.put("вин", 398);
    freq.put("вим", 45);
    freq.put("ъед", 19);
    freq.put("вио", 9);
    freq.put("виг", 13);
    freq.put("вив", 15);
    freq.put("вие", 98);
    freq.put("вид", 354);
    freq.put("пръ", 40);
    freq.put("виж", 137);
    freq.put("вищ", 20);
    freq.put("пре", 1361);
    freq.put("пра", 802);
    freq.put("вия", 236);
    freq.put("вис", 97);
    freq.put("вир", 57);
    freq.put("про", 1117);
    freq.put("вит", 268);
    freq.put("вих", 111);
    freq.put("вич", 23);
    freq.put("виц", 53);
    freq.put("гле", 314);
    freq.put("Кръ", 14);
    freq.put("жов", 11);
    freq.put("жоб", 11);
    freq.put("Кру", 9);
    freq.put("жол", 10);
    freq.put("ОВ ", 16);
    freq.put("ним", 381);
    freq.put("нин", 57);
    freq.put("ник", 485);
    freq.put("нил", 21);
    freq.put("нии", 20);
    freq.put("ниж", 24);
    freq.put("низ", 57);
    freq.put("нид", 17);
    freq.put("ние", 784);
    freq.put("нив", 50);
    freq.put("ниг", 64);
    freq.put("ниа", 8);
    freq.put("Вол", 10);
    freq.put("Вой", 8);
    freq.put("гло", 43);
    freq.put("Вод", 12);
    freq.put("йче", 13);
    freq.put("йчо", 12);
    freq.put("йчи", 12);
    freq.put("ния", 973);
    freq.put("ниш", 45);
    freq.put("нищ", 87);
    freq.put("ниц", 313);
    freq.put("нич", 121);
    freq.put("ниф", 10);
    freq.put("них", 26);
    freq.put("нит", 767);
    freq.put("нир", 88);
    freq.put("нис", 168);
    freq.put("еп ", 15);
    freq.put(" П ", 8);
    freq.put("РС ", 9);
    freq.put("скъ", 45);
    freq.put("скр", 33);
    freq.put("ску", 61);
    freq.put("Св ", 16);
    freq.put("аж ", 50);
    freq.put("скл", 14);
    freq.put("ско", 354);
    freq.put("ска", 881);
    freq.put("скв", 24);
    freq.put("ске", 16);
    freq.put("ВЕ ", 12);
    freq.put("Ех ", 12);
    freq.put("ене", 269);
    freq.put("енд", 118);
    freq.put("енз", 35);
    freq.put("ена", 610);
    freq.put("енг", 16);
    freq.put("енн", 102);
    freq.put("ено", 390);
    freq.put("ени", 1505);
    freq.put("енк", 45);
    freq.put("тра", 582);
    freq.put("тре", 375);
    freq.put("три", 296);
    freq.put("тро", 433);
    freq.put("аит", 9);
    freq.put("Сар", 12);
    freq.put("аир", 9);
    freq.put("аил", 8);
    freq.put("Сай", 11);
    freq.put("Сам", 71);
    freq.put("аим", 9);
    freq.put("тру", 158);
    freq.put("тръ", 53);
    freq.put("тря", 201);
    freq.put("ИМ ", 11);
    freq.put("енч", 14);
    freq.put("енц", 130);
    freq.put("енс", 161);
    freq.put("ену", 9);
    freq.put("ент", 722);
    freq.put("ень", 14);
    freq.put("еня", 145);
    freq.put("уни", 86);
    freq.put("уне", 15);
    freq.put("твя", 19);
    freq.put("мки", 162);
    freq.put("твъ", 93);
    freq.put("мкб", 18);
    freq.put("мка", 114);
    freq.put("лук", 25);
    freq.put("тву", 10);
    freq.put("твр", 8);
    freq.put(" Хо", 88);
    freq.put(" Хи", 32);
    freq.put(" Хе", 39);
    freq.put(" Ха", 123);
    freq.put(" Хъ", 8);
    freq.put(" Хр", 45);
    freq.put(" Ху", 20);
    freq.put("Г ", 64);
    freq.put("тво", 424);
    freq.put("твл", 9);
    freq.put("бз", 29);
    freq.put("тви", 118);
    freq.put("тве", 165);
    freq.put("тва", 333);
    freq.put("бл", 640);
    freq.put("нча", 13);
    freq.put("нче", 116);
    freq.put("нчо", 28);
    freq.put("та ", 4656);
    freq.put("от", 5091);
    freq.put("вяд", 13);
    freq.put("звл", 27);
    freq.put("дна", 356);
    freq.put("упа", 81);
    freq.put("Арс", 17);
    freq.put("упе", 83);
    freq.put("дне", 279);
    freq.put("дни", 340);
    freq.put("упи", 61);
    freq.put("упк", 24);
    freq.put("дно", 342);
    freq.put("упо", 54);
    freq.put("унт", 20);
    freq.put("ъзр", 34);
    freq.put("ъзс", 23);
    freq.put("ъзк", 41);
    freq.put("ъзм", 60);
    freq.put("ъзн", 29);
    freq.put("ъзп", 32);
    freq.put("й ", 1604);
    freq.put("ъзв", 8);
    freq.put("ъзд", 64);
    freq.put("упр", 66);
    freq.put("упу", 30);
    freq.put("Аре", 12);
    freq.put("днъ", 18);
    freq.put("упя", 9);
    freq.put("Арм", 14);
    freq.put("жия", 13);
    freq.put("жиш", 17);
    freq.put("жих", 13);
    freq.put("уб ", 25);
    freq.put("жир", 9);
    freq.put("жит", 85);
    freq.put("Сел", 14);
    freq.put("Тр", 160);
    freq.put("Ту", 80);
    freq.put("Тя", 23);
    freq.put("Тъ", 71);
    freq.put("вка", 176);
    freq.put("вко", 8);
    freq.put("вкл", 43);
    freq.put("Ето", 46);
    freq.put("вки", 77);
    freq.put("вку", 26);
    freq.put("йск", 201);
    freq.put("йсе", 9);
    freq.put("Съд", 16);
    freq.put("пци", 19);
    freq.put("йсб", 48);
    freq.put("вкъ", 19);
    freq.put("Те", 125);
    freq.put("Та", 111);
    freq.put("Тв", 20);
    freq.put("То", 279);
    freq.put("Съз", 9);
    freq.put("Ти", 47);
    freq.put("жин", 21);
    freq.put("жим", 35);
    freq.put("жии", 9);
    freq.put("жил", 55);
    freq.put("жие", 21);
    freq.put("жив", 202);
    freq.put("НС ", 20);
    freq.put("Фер", 15);
    freq.put("нке", 13);
    freq.put("нка", 128);
    freq.put("нко", 84);
    freq.put("нки", 89);
    freq.put("ви ", 857);
    freq.put("Вал", 30);
    freq.put("Ван", 16);
    freq.put(" Аб", 37);
    freq.put("гри", 75);
    freq.put("гро", 38);
    freq.put("шег", 8);
    freq.put("гра", 599);
    freq.put("шен", 172);
    freq.put("гре", 83);
    freq.put("шеф", 25);
    freq.put("шех", 9);
    freq.put("гръ", 26);
    freq.put("шер", 9);
    freq.put("шес", 22);
    freq.put("шет", 35);
    freq.put("гру", 47);
    freq.put("шеш", 10);
    freq.put("ь", 184);
    freq.put("Вас", 29);
    freq.put("Вар", 109);
    freq.put("пр ", 16);
    freq.put("щув", 28);
    freq.put("Ваш", 17);
    freq.put("нкц", 16);
    freq.put("нкр", 18);
    freq.put("нку", 37);
    freq.put("Фей", 31);
    freq.put("Фен", 16);
    freq.put("ни ", 2305);
    freq.put(" Ад", 28);
    freq.put("айр", 13);
    freq.put(" По", 518);
    freq.put(" Пл", 144);
    freq.put(" Пи", 85);
    freq.put(" Пе", 168);
    freq.put(" Па", 159);
    freq.put("епа", 31);
    freq.put("епе", 34);
    freq.put("епл", 11);
    freq.put("епи", 55);
    freq.put("епо", 79);
    freq.put("епн", 14);
    freq.put("Т", 1048);
    freq.put("Кас", 10);
    freq.put("Кар", 45);
    freq.put("тте", 14);
    freq.put("Кат", 58);
    freq.put("тта", 114);
    freq.put("ажб", 60);
    freq.put("ажа", 78);
    freq.put("Кал", 21);
    freq.put("Как", 213);
    freq.put("аже", 116);
    freq.put("Све", 64);
    freq.put("Кап", 22);
    freq.put("Каб", 9);
    freq.put("ажи", 38);
    freq.put("ажн", 72);
    freq.put("Каз", 33);
    freq.put("уар", 64);
    freq.put("епу", 42);
    freq.put("епт", 44);
    freq.put("епр", 39);
    freq.put("епц", 11);
    freq.put("епя", 16);
    freq.put(" Пъ", 116);
    freq.put(" Пу", 162);
    freq.put(" Пр", 710);
    freq.put(" Пс", 9);
    freq.put("ен ", 1917);
    freq.put("тр ", 8);
    freq.put("Опи", 11);
    freq.put("аи ", 23);
    freq.put("бщо", 26);
    freq.put("бщи", 80);
    freq.put("бще", 52);
    freq.put("бща", 14);
    freq.put("км", 53);
    freq.put("ело", 132);
    freq.put("ко", 4535);
    freq.put("ки", 2800);
    freq.put("елк", 59);
    freq.put("кл", 582);
    freq.put("кд", 23);
    freq.put("ке", 242);
    freq.put("еле", 442);
    freq.put("ка", 5822);
    freq.put("кб", 19);
    freq.put("кв", 754);
    freq.put("кг", 16);
    freq.put("тюн", 12);
    freq.put("Буд", 8);
    freq.put("Бул", 16);
    freq.put("Бук", 8);
    freq.put(" юл", 13);
    freq.put(" юн", 18);
    freq.put("акъ", 133);
    freq.put("чуе", 9);
    freq.put("акц", 33);
    freq.put("акс", 64);
    freq.put("акр", 37);
    freq.put("аку", 57);
    freq.put("акт", 220);
    freq.put("Лиг", 10);
    freq.put("аки", 87);
    freq.put("акл", 24);
    freq.put("аке", 51);
    freq.put("чуж", 29);
    freq.put("ака", 428);
    freq.put("акв", 521);
    freq.put("Бур", 98);
    freq.put("тют", 9);
    freq.put("еля", 227);
    freq.put("кю", 17);
    freq.put("кш", 10);
    freq.put("елъ", 12);
    freq.put("къ", 849);
    freq.put("елч", 9);
    freq.put("кц", 105);
    freq.put("кч", 18);
    freq.put("елу", 16);
    freq.put("кс", 376);
    freq.put("кт", 639);
    freq.put("ку", 764);
    freq.put("жте", 49);
    freq.put("Г", 726);
    freq.put("ще ", 1304);
    freq.put("Вър", 11);
    freq.put("Въз", 34);
    freq.put("Във", 17);
    freq.put("Въп", 24);
    freq.put("Въл", 9);
    freq.put(" €", 8);
    freq.put("ГО ", 11);
    freq.put("зъм", 34);
    freq.put("зън", 8);
    freq.put("зък", 8);
    freq.put("зъб", 23);
    freq.put("ж ", 217);
    freq.put("душ", 49);
    freq.put("дух", 36);
    freq.put("дур", 11);
    freq.put("дус", 22);
    freq.put("ок ", 99);
    freq.put("тк", 405);
    freq.put("Ада", 10);
    freq.put("то ", 3727);
    freq.put("дуп", 32);
    freq.put("дум", 88);
    freq.put("дун", 36);
    freq.put("дук", 41);
    freq.put("дуз", 8);
    freq.put(" №", 43);
    freq.put("Бож", 21);
    freq.put("Беш", 8);
    freq.put("Бон", 15);
    freq.put("Бой", 47);
    freq.put("Бол", 20);
    freq.put("тмъ", 9);
    freq.put("оид", 14);
    freq.put("оиз", 56);
    freq.put("оим", 10);
    freq.put("оич", 8);
    freq.put("оис", 31);
    freq.put("оит", 247);
    freq.put("тме", 12);
    freq.put("Бор", 90);
    freq.put("Бос", 8);
    freq.put("Яне", 21);
    freq.put("ЕЦ ", 12);
    freq.put("Боя", 9);
    freq.put("уг ", 33);
    freq.put("нсе", 11);
    freq.put("нси", 72);
    freq.put("нск", 418);
    freq.put("нсп", 56);
    freq.put("нсо", 33);
    freq.put("МЕ ", 13);
    freq.put("нсу", 21);
    freq.put("нст", 150);
    freq.put("нсф", 10);
    freq.put("нсъ", 8);
    freq.put("дла", 55);
    freq.put("дло", 41);
    freq.put("дли", 11);
    freq.put("ъг ", 23);
    freq.put("Инд", 19);
    freq.put("Ина", 10);
    freq.put("Инв", 9);
    freq.put("Бр", 86);
    freq.put("Бу", 147);
    freq.put("Пет", 72);
    freq.put("Бъ", 469);
    freq.put("Бя", 15);
    freq.put("Бю", 9);
    freq.put("Ба", 216);
    freq.put("Бе", 187);
    freq.put("Пен", 12);
    freq.put("Би", 107);
    freq.put("Бл", 179);
    freq.put("Бо", 271);
    freq.put("Инф", 22);
    freq.put("Инс", 9);
    freq.put("Инт", 58);
    freq.put("ош ", 13);
    freq.put("уер", 13);
    freq.put("Д ", 78);
    freq.put("Ъ", 11);
    freq.put("ъбо", 44);
    freq.put("ъби", 74);
    freq.put("ъбе", 16);
    freq.put("ъба", 11);
    freq.put("ъбу", 18);
    freq.put("ъбр", 28);
    freq.put("Чов", 18);
    freq.put("Дне", 107);
    freq.put("Вкл", 8);
    freq.put("зч", 55);
    freq.put("зц", 13);
    freq.put("зх", 36);
    freq.put("зу", 67);
    freq.put("зт", 108);
    freq.put("зс", 101);
    freq.put("зр", 217);
    freq.put("зя", 60);
    freq.put("зъ", 94);
    freq.put("Утр", 25);
    freq.put("зз", 9);
    freq.put("зж", 9);
    freq.put("зе", 381);
    freq.put("зд", 356);
    freq.put("зг", 173);
    freq.put("зв", 659);
    freq.put("зб", 294);
    freq.put("за", 4882);
    freq.put("зп", 377);
    freq.put("зо", 404);
    freq.put("зн", 797);
    freq.put("зм", 211);
    freq.put("зл", 307);
    freq.put("ген", 86);
    freq.put("зи", 1180);
    freq.put("Ав", 39);
    freq.put("Аг", 20);
    freq.put("Аб", 37);
    freq.put("Аз", 121);
    freq.put("Ад", 29);
    freq.put("Ак", 161);
    freq.put("Ал", 88);
    freq.put("Ай", 33);
    freq.put("к ", 1646);
    freq.put("Ап", 47);
    freq.put("Ам", 91);
    freq.put("Ан", 145);
    freq.put("бях", 68);
    freq.put("бят", 8);
    freq.put("бяс", 23);
    freq.put("вра", 56);
    freq.put("ева", 216);
    freq.put("Онл", 13);
    freq.put("ври", 67);
    freq.put("ак ", 486);
    freq.put("бяд", 21);
    freq.put("бяг", 34);
    freq.put("бяв", 109);
    freq.put("бял", 16);
    freq.put("Ат", 38);
    freq.put("Ау", 9);
    freq.put("Ар", 81);
    freq.put("Хо", 88);
    freq.put("Аф", 11);
    freq.put("Ах", 16);
    freq.put("Хи", 32);
    freq.put("Хер", 8);
    freq.put("Хе", 40);
    freq.put("дст", 188);
    freq.put("Ха", 125);
    freq.put("ян ", 86);
    freq.put("щен", 58);
    freq.put("щеш", 19);
    freq.put("Авс", 18);
    freq.put("Авт", 17);
    freq.put("щес", 51);
    freq.put("щер", 17);
    freq.put("щет", 35);
    freq.put("теп", 15);
    freq.put("дсе", 19);
    freq.put("дск", 66);
    freq.put("жа", 641);
    freq.put("жб", 90);
    freq.put("жв", 19);
    freq.put("жд", 625);
    freq.put("же", 1162);
    freq.put("жи", 678);
    freq.put("Бил", 12);
    freq.put("жк", 107);
    freq.put("Бий", 13);
    freq.put("Био", 8);
    freq.put("жн", 212);
    freq.put("жо", 79);
    freq.put("тош", 23);
    freq.put("тоя", 162);
    freq.put(" Що", 17);
    freq.put("Ужа", 8);
    freq.put("Пуб", 114);
    freq.put("тот", 93);
    freq.put("тос", 33);
    freq.put("тор", 399);
    freq.put("точ", 120);
    freq.put(" Ще", 86);
    freq.put("тох", 12);
    freq.put("тоф", 13);
    freq.put("ока", 273);
    freq.put("оке", 15);
    freq.put("окл", 132);
    freq.put("оки", 63);
    freq.put("око", 227);
    freq.put("Хра", 15);
    freq.put("оку", 92);
    freq.put("окт", 36);
    freq.put("окс", 23);
    freq.put("окр", 60);
    freq.put("окъ", 15);
    freq.put("рху", 45);
    freq.put("тол", 171);
    freq.put("ток", 107);
    freq.put("той", 111);
    freq.put("тои", 42);
    freq.put("топ", 110);
    freq.put("тон", 81);
    freq.put("том", 115);
    freq.put("тог", 60);
    freq.put("тов", 648);
    freq.put("тоб", 32);
    freq.put("тоа", 22);
    freq.put("тоз", 111);
    freq.put("тое", 11);
    freq.put("тод", 15);
    freq.put("жт", 53);
    freq.put("жу", 53);
    freq.put("жъ", 64);
    freq.put("ду ", 61);
    freq.put(" шо", 55);
    freq.put("нул", 8);
    freq.put("ои ", 112);
    freq.put("нуж", 60);
    freq.put("нув", 47);
    freq.put("нуа", 37);
    freq.put("нут", 25);
    freq.put("нус", 19);
    freq.put("ичн", 259);
    freq.put("нс ", 46);
    freq.put("уго", 45);
    freq.put("уги", 103);
    freq.put("уга", 44);
    freq.put("Или", 33);
    freq.put("Пла", 41);
    freq.put("Пле", 35);
    freq.put("Пло", 61);
    freq.put("угъ", 9);
    freq.put("Хъ", 8);
    freq.put("ъцк", 16);
    freq.put("ъци", 42);
    freq.put("ъце", 19);
    freq.put("Уни", 24);
    freq.put("Унг", 8);
    freq.put("Хр", 45);
    freq.put("Ху", 20);
    freq.put("ошу", 10);
    freq.put("кич", 11);
    freq.put("сие", 20);
    freq.put("чув", 65);
    freq.put("ъга", 15);
    freq.put("чуд", 83);
    freq.put("ъгв", 13);
    freq.put("ОД ", 9);
    freq.put("ъгн", 22);
    freq.put("чук", 21);
    freq.put("чуп", 15);
    freq.put("ъгл", 34);
    freq.put("пто", 51);
    freq.put("пти", 40);
    freq.put("пте", 35);
    freq.put("пта", 9);
    freq.put("ища", 54);
    freq.put("Б ", 138);
    freq.put("ище", 82);
    freq.put("ищн", 19);
    freq.put("ищо", 83);
    freq.put("оше", 29);
    freq.put("оша", 39);
    freq.put("ошо", 35);
    freq.put("оши", 19);
    freq.put("ошл", 8);
    freq.put("ошк", 12);
    freq.put("юче", 25);
    freq.put("руа", 27);
    freq.put("ючв", 25);
    freq.put("ючо", 10);
    freq.put("ючи", 48);
    freq.put("До", 345);
    freq.put("Дн", 110);
    freq.put("Ди", 126);
    freq.put("Дж", 135);
    freq.put("Де", 180);
    freq.put("Дв", 72);
    freq.put("Да", 248);
    freq.put("Дя", 35);
    freq.put("Дъ", 47);
    freq.put("Ду", 38);
    freq.put("Др", 43);
    freq.put("Гер", 54);
    freq.put("сит", 99);
    freq.put("сир", 89);
    freq.put("сис", 63);
    freq.put("сич", 299);
    freq.put("сих", 31);
    freq.put("н", 38694);
    freq.put("сия", 145);
    freq.put("сив", 67);
    freq.put("сиг", 97);
    freq.put("сид", 11);
    freq.put("з ", 904);
    freq.put("сик", 21);
    freq.put("сил", 137);
    freq.put("сии", 24);
    freq.put("сий", 11);
    freq.put("сио", 44);
    freq.put("сип", 18);
    freq.put("сим", 63);
    freq.put("син", 71);
    freq.put("Гео", 37);
    freq.put("Ген", 13);
    freq.put("Юли", 13);
  }
  
}

