package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class CA {
  private static final String name = "ca";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public CA() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 685343;
    n_words[1] = 834094;
    n_words[2] = 646921;

    freq.put("rà ", 412);
    freq.put("tís", 22);
    freq.put("tít", 8);
    freq.put("xtr", 33);
    freq.put("IX ", 7);
    freq.put("xte", 10);
    freq.put("tíc", 57);
    freq.put("tíf", 11);
    freq.put("tai", 15);
    freq.put("tín", 9);
    freq.put("ràc", 282);
    freq.put("ràd", 13);
    freq.put("ràf", 15);
    freq.put("ràn", 26);
    freq.put("ràp", 11);
    freq.put("ràs", 54);
    freq.put("ràt", 19);
    freq.put("yu ", 8);
    freq.put("tí ", 92);
    freq.put("xt ", 10);
    freq.put("làn", 8);
    freq.put("NO ", 36);
    freq.put("òni", 53);
    freq.put("òno", 9);
    freq.put("làs", 44);
    freq.put(" y ", 53);
    freq.put("là ", 275);
    freq.put(" yo", 23);
    freq.put(" ya", 16);
    freq.put("k", 1331);
    freq.put(" yc", 7);
    freq.put("txo", 15);
    freq.put("ED ", 7);
    freq.put("txi", 31);
    freq.put("txe", 56);
    freq.put("Lí", 10);
    freq.put("txa", 53);
    freq.put("Ló", 7);
    freq.put("dna", 7);
    freq.put("xta", 10);
    freq.put("tx ", 11);
    freq.put("jma", 8);
    freq.put("dn ", 10);
    freq.put("xti", 11);
    freq.put("Lf", 8);
    freq.put("Le", 171);
    freq.put("Lc", 8);
    freq.put("La", 709);
    freq.put("Ln", 7);
    freq.put("Lo", 103);
    freq.put("Ll", 269);
    freq.put("Lm", 8);
    freq.put("Lj", 7);
    freq.put("Lh", 9);
    freq.put("Li", 101);
    freq.put("Lv", 7);
    freq.put("Lt", 9);
    freq.put("Lu", 44);
    freq.put("Lp", 9);
    freq.put("Lq", 14);
    freq.put("òpi", 11);
    freq.put("Lx", 7);
    freq.put("Ly", 13);
    freq.put("hon", 37);
    freq.put("hol", 40);
    freq.put("hom", 134);
    freq.put("hoh", 12);
    freq.put("hot", 10);
    freq.put("hor", 195);
    freq.put("hos", 24);
    freq.put("hop", 9);
    freq.put("hoq", 16);
    freq.put("A", 3582);
    freq.put("L ", 501);
    freq.put("èmi", 8);
    freq.put("ho ", 505);
    freq.put(" V ", 32);
    freq.put("zal", 19);
    freq.put("ucl", 10);
    freq.put("AP ", 25);
    freq.put("fir", 42);
    freq.put("fis", 48);
    freq.put("His", 12);
    freq.put("Hit", 10);
    freq.put("rò", 443);
    freq.put("ró", 53);
    freq.put("fix", 9);
    freq.put("rú", 10);
    freq.put("fic", 259);
    freq.put("rç", 396);
    freq.put("rà", 857);
    freq.put("rá", 13);
    freq.put("Hig", 12);
    freq.put("rí", 102);
    freq.put("rè", 125);
    freq.put("ré", 252);
    freq.put("fil", 94);
    freq.put(" Va", 275);
    freq.put(" Ve", 112);
    freq.put("upo", 115);
    freq.put(" Vi", 361);
    freq.put("pré", 105);
    freq.put(" Vo", 68);
    freq.put("zac", 49);
    freq.put(" Vu", 22);
    freq.put("atí", 83);
    freq.put("atè", 17);
    freq.put("Hi ", 32);
    freq.put("fi ", 40);
    freq.put("atò", 22);
    freq.put("ató", 38);
    freq.put("rU", 10);
    freq.put("rV", 11);
    freq.put("rW", 9);
    freq.put("rP", 20);
    freq.put("rR", 11);
    freq.put("rS", 22);
    freq.put("rZ", 11);
    freq.put("mde", 10);
    freq.put("rD", 11);
    freq.put("rE", 10);
    freq.put("rF", 16);
    freq.put("rG", 9);
    freq.put("rA", 19);
    freq.put("rB", 30);
    freq.put("rC", 16);
    freq.put("rL", 11);
    freq.put("rM", 21);
    freq.put("rN", 12);
    freq.put("rO", 9);
    freq.put("rH", 19);
    freq.put("rI", 9);
    freq.put("rJ", 12);
    freq.put("rt", 2621);
    freq.put("ru", 526);
    freq.put("rv", 237);
    freq.put("rw", 11);
    freq.put("rp", 81);
    freq.put("rq", 288);
    freq.put("rr", 1708);
    freq.put("rs", 1157);
    freq.put("smu", 12);
    freq.put("rx", 143);
    freq.put("¬", 12);
    freq.put("rz", 41);
    freq.put("rd", 1280);
    freq.put("re", 8446);
    freq.put("rf", 80);
    freq.put("rg", 413);
    freq.put("ra", 6789);
    freq.put("rb", 174);
    freq.put("rc", 1019);
    freq.put("rl", 411);
    freq.put("rm", 630);
    freq.put("rn", 785);
    freq.put("Eur", 56);
    freq.put("rh", 14);
    freq.put("ri", 4118);
    freq.put("rj", 38);
    freq.put("rk", 81);
    freq.put("atD", 10);
    freq.put("IM ", 11);
    freq.put(" Ví", 12);
    freq.put("uX", 7);
    freq.put("atg", 209);
    freq.put("atd", 25);
    freq.put("ate", 432);
    freq.put("atc", 31);
    freq.put("ata", 1081);
    freq.put("ato", 128);
    freq.put("atl", 27);
    freq.put("atj", 16);
    freq.put("ath", 18);
    freq.put("ati", 339);
    freq.put("atv", 22);
    freq.put("atw", 8);
    freq.put("att", 14);
    freq.put("atu", 187);
    freq.put("r ", 7654);
    freq.put("ats", 567);
    freq.put("atp", 11);
    freq.put("atx", 44);
    freq.put("sm ", 11);
    freq.put("yin", 8);
    freq.put("kfr", 14);
    freq.put("Due", 8);
    freq.put("Dur", 20);
    freq.put("xia", 10);
    freq.put("xic", 17);
    freq.put("xig", 26);
    freq.put("Cen", 26);
    freq.put("Cel", 30);
    freq.put("xil", 22);
    freq.put("xim", 33);
    freq.put("xin", 44);
    freq.put("adr", 172);
    freq.put("xiq", 12);
    freq.put("xir", 7);
    freq.put("nz ", 14);
    freq.put("Ces", 23);
    freq.put("Cer", 41);
    freq.put("xiv", 9);
    freq.put("YA ", 10);
    freq.put("Sob", 21);
    freq.put("xi ", 53);
    freq.put("eCa", 7);
    freq.put("í", 1510);
    freq.put("nza", 22);
    freq.put("nze", 13);
    freq.put("nzi", 7);
    freq.put("nzo", 21);
    freq.put("oqu", 81);
    freq.put("ïso", 18);
    freq.put("hY", 8);
    freq.put("Ass", 34);
    freq.put("Sos", 9);
    freq.put("Sor", 35);
    freq.put(" fe", 968);
    freq.put("Aso", 15);
    freq.put("lp ", 10);
    freq.put("nel", 89);
    freq.put("za ", 57);
    freq.put("lpu", 33);
    freq.put("lpr", 9);
    freq.put("neg", 110);
    freq.put("lpe", 34);
    freq.put("lpa", 53);
    freq.put("úvo", 21);
    freq.put("zte", 10);
    freq.put("iré", 19);
    freq.put("irà", 60);
    freq.put("nev", 36);
    freq.put("dP ", 24);
    freq.put("X", 540);
    freq.put("Riv", 15);
    freq.put("Rit", 8);
    freq.put("Riu", 8);
    freq.put("aWe", 46);
    freq.put("Rie", 8);
    freq.put("Rib", 34);
    freq.put("Ric", 22);
    freq.put("ua ", 160);
    freq.put("PS ", 12);
    freq.put("irH", 12);
    freq.put("mec", 52);
    freq.put("irr", 28);
    freq.put("irt", 20);
    freq.put("iru", 13);
    freq.put("iri", 90);
    freq.put("irl", 12);
    freq.put("irm", 35);
    freq.put("iro", 143);
    freq.put("ira", 345);
    freq.put("irc", 31);
    freq.put("ird", 7);
    freq.put("ire", 345);
    freq.put("irg", 9);
    freq.put("rgu", 46);
    freq.put("DM ", 8);
    freq.put("ir ", 857);
    freq.put("pre", 988);
    freq.put("Nar", 7);
    freq.put("fra", 221);
    freq.put("fre", 172);
    freq.put("fri", 26);
    freq.put("fro", 27);
    freq.put("fru", 32);
    freq.put("pro", 682);
    freq.put("cun", 19);
    freq.put("pru", 10);
    freq.put("uy ", 10);
    freq.put("BC ", 9);
    freq.put("lós", 8);
    freq.put("bin", 24);
    freq.put("bio", 26);
    freq.put("Din", 7);
    freq.put("tza", 177);
    freq.put("tze", 28);
    freq.put("bà", 19);
    freq.put("dhe", 13);
    freq.put("Of", 47);
    freq.put("Dif", 9);
    freq.put("bie", 46);
    freq.put("bè", 9);
    freq.put("uàr", 9);
    freq.put("bé", 287);
    freq.put("tz ", 13);
    freq.put(" L ", 282);
    freq.put("Bé ", 13);
    freq.put("olç", 9);
    freq.put("olè", 19);
    freq.put("bó", 10);
    freq.put("olí", 81);
    freq.put("olò", 28);
    freq.put("bit", 63);
    freq.put("hah", 82);
    freq.put("hai", 9);
    freq.put("hal", 17);
    freq.put("ham", 32);
    freq.put("han", 234);
    freq.put("Dip", 19);
    freq.put("hab", 25);
    freq.put("hac", 24);
    freq.put("had", 7);
    freq.put("hag", 87);
    freq.put("hay", 7);
    freq.put("hap", 9);
    freq.put("har", 27);
    freq.put("has", 80);
    freq.put("hat", 25);
    freq.put("hau", 99);
    freq.put("hav", 104);
    freq.put("ol·", 40);
    freq.put("ha ", 664);
    freq.put("ola", 403);
    freq.put("olb", 11);
    freq.put("olc", 27);
    freq.put("old", 37);
    freq.put("ole", 333);
    freq.put("olf", 21);
    freq.put("olg", 26);
    freq.put("oli", 321);
    freq.put(" X ", 33);
    freq.put("oll", 241);
    freq.put("olm", 11);
    freq.put("olo", 146);
    freq.put("olr", 13);
    freq.put("ols", 194);
    freq.put("olt", 799);
    freq.put("olu", 103);
    freq.put("olv", 10);
    freq.put("ïns", 7);
    freq.put("olz", 13);
    freq.put("AV ", 9);
    freq.put("fot", 137);
    freq.put("fou", 12);
    freq.put("olC", 7);
    freq.put("ump", 17);
    freq.put("for", 411);
    freq.put("fos", 38);
    freq.put("ume", 191);
    freq.put("fog", 9);
    freq.put("uma", 59);
    freq.put("foc", 22);
    freq.put("fol", 68);
    freq.put("fon", 108);
    freq.put("foo", 9);
    freq.put("umi", 40);
    freq.put("foi", 13);
    freq.put("ol ", 563);
    freq.put("tió", 21);
    freq.put(" Xi", 17);
    freq.put(" Xo", 8);
    freq.put(" Xa", 103);
    freq.put(" Xe", 15);
    freq.put(" Xu", 7);
    freq.put("o", 37680);
    freq.put("fo ", 45);
    freq.put("um ", 145);
    freq.put("mbl", 134);
    freq.put("soc", 136);
    freq.put("sob", 209);
    freq.put("mbi", 51);
    freq.put("sof", 27);
    freq.put("mbe", 43);
    freq.put("Fel", 82);
    freq.put("Fem", 21);
    freq.put("som", 137);
    freq.put("sol", 300);
    freq.put("Fei", 7);
    freq.put("sop", 42);
    freq.put("sos", 204);
    freq.put("Feu", 21);
    freq.put("Fer", 58);
    freq.put("Fes", 30);
    freq.put("sov", 11);
    freq.put("mbu", 12);
    freq.put("mbr", 94);
    freq.put("az ", 14);
    freq.put("so ", 96);
    freq.put("Us ", 37);
    freq.put("mb ", 1175);
    freq.put("azi", 37);
    freq.put("azo", 18);
    freq.put("aza", 9);
    freq.put("aze", 8);
    freq.put("azu", 11);
    freq.put("Sis", 15);
    freq.put("mbé", 126);
    freq.put("Siu", 7);
    freq.put("Sit", 26);
    freq.put("Sig", 14);
    freq.put("Sie", 8);
    freq.put("tea", 32);
    freq.put("Sin", 15);
    freq.put("Sim", 14);
    freq.put("Sil", 23);
    freq.put("us", 1456);
    freq.put("mro", 8);
    freq.put("mri", 11);
    freq.put("E", 3035);
    freq.put("Si ", 160);
    freq.put("Ú", 17);
    freq.put("xk ", 8);
    freq.put("nxa", 23);
    freq.put("osp", 66);
    freq.put("oss", 164);
    freq.put("ost", 610);
    freq.put("osi", 88);
    freq.put("per", 3078);
    freq.put("oso", 72);
    freq.put("osa", 449);
    freq.put("osc", 63);
    freq.put("ose", 283);
    freq.put("osd", 12);
    freq.put("osf", 7);
    freq.put("Aqu", 176);
    freq.put("vet", 39);
    freq.put("veu", 318);
    freq.put("ver", 637);
    freq.put("ves", 273);
    freq.put("VA ", 27);
    freq.put("veg", 84);
    freq.put("ved", 13);
    freq.put("vec", 9);
    freq.put("ven", 321);
    freq.put("osC", 8);
    freq.put("vem", 45);
    freq.put("vej", 9);
    freq.put("veh", 12);
    freq.put("vei", 131);
    freq.put("lra", 8);
    freq.put("Mà", 8);
    freq.put("Mé", 40);
    freq.put("lro", 14);
    freq.put("ped", 39);
    freq.put("aïs", 18);
    freq.put("Mò", 7);
    freq.put("os ", 940);
    freq.put("Mú", 7);
    freq.put("Tav", 9);
    freq.put("peg", 15);
    freq.put("Tar", 70);
    freq.put("Tas", 9);
    freq.put("ve ", 144);
    freq.put("Tal", 13);
    freq.put("Tam", 22);
    freq.put("Tan", 29);
    freq.put("M ", 331);
    freq.put("osé", 11);
    freq.put("dRo", 7);
    freq.put("úti", 13);
    freq.put("bc", 110);
    freq.put("nll", 43);
    freq.put("veï", 9);
    freq.put("Me", 294);
    freq.put("Ma", 916);
    freq.put("Mc", 14);
    freq.put("Mb", 9);
    freq.put("Mm", 12);
    freq.put("Ml", 11);
    freq.put("Mo", 457);
    freq.put("Mn", 12);
    freq.put("Mi", 246);
    freq.put("Mh", 7);
    freq.put("Mj", 7);
    freq.put("Mu", 107);
    freq.put("Mt", 9);
    freq.put("Mw", 7);
    freq.put("Mv", 10);
    freq.put("Mq", 8);
    freq.put("uff", 25);
    freq.put("Ms", 7);
    freq.put("Mr", 16);
    freq.put("UV ", 11);
    freq.put("My", 9);
    freq.put("or ", 659);
    freq.put("oen", 12);
    freq.put("ipc", 19);
    freq.put("ipa", 113);
    freq.put("oem", 10);
    freq.put("ipe", 26);
    freq.put("ipi", 48);
    freq.put("ipo", 41);
    freq.put("ipl", 15);
    freq.put("ipr", 7);
    freq.put("ips", 24);
    freq.put("ipt", 18);
    freq.put("ipu", 68);
    freq.put("tén", 7);
    freq.put("ip ", 96);
    freq.put("ua", 1357);
    freq.put("CF ", 14);
    freq.put("mba", 60);
    freq.put("sú", 10);
    freq.put("só", 205);
    freq.put("sò", 13);
    freq.put("ov ", 21);
    freq.put("ñ", 48);
    freq.put("sé", 77);
    freq.put("sè", 24);
    freq.put("sí", 132);
    freq.put("sà", 19);
    freq.put("té ", 147);
    freq.put("NC ", 22);
    freq.put("s ", 21145);
    freq.put("sY", 8);
    freq.put("sX", 14);
    freq.put("sS", 23);
    freq.put("sR", 20);
    freq.put("sQ", 10);
    freq.put("sP", 41);
    freq.put("sW", 9);
    freq.put("sV", 28);
    freq.put("sU", 15);
    freq.put("sT", 22);
    freq.put("sK", 7);
    freq.put("sJ", 21);
    freq.put("sI", 8);
    freq.put("sH", 11);
    freq.put("sO", 18);
    freq.put("sN", 19);
    freq.put("sM", 27);
    freq.put("sL", 12);
    freq.put("sC", 59);
    freq.put("sB", 28);
    freq.put("sA", 28);
    freq.put("sG", 23);
    freq.put("sF", 20);
    freq.put("sE", 20);
    freq.put("sD", 20);
    freq.put("sz", 8);
    freq.put("sy", 21);
    freq.put("sx", 12);
    freq.put("ss", 1795);
    freq.put("sr", 70);
    freq.put("sq", 159);
    freq.put("sp", 1487);
    freq.put("sw", 20);
    freq.put("sv", 62);
    freq.put("su", 678);
    freq.put("st", 4813);
    freq.put("sk", 74);
    freq.put("sj", 19);
    freq.put("si", 2514);
    freq.put("sh", 105);
    freq.put("so", 1778);
    freq.put("sn", 41);
    freq.put("sm", 351);
    freq.put("sl", 86);
    freq.put("sc", 1225);
    freq.put("sb", 93);
    freq.put("sa", 2760);
    freq.put("sg", 62);
    freq.put("sf", 138);
    freq.put("se", 3712);
    freq.put("sd", 140);
    freq.put("pít", 9);
    freq.put("ròn", 16);
    freq.put("ttp", 3121);
    freq.put("tti", 13);
    freq.put("tto", 7);
    freq.put("ttl", 7);
    freq.put("tta", 12);
    freq.put("tte", 146);
    freq.put("jim", 9);
    freq.put("jij", 11);
    freq.put("·lu", 19);
    freq.put("·li", 14);
    freq.put("mMo", 15);
    freq.put("·la", 29);
    freq.put("mMa", 7);
    freq.put("·le", 30);
    freq.put("nsd", 9);
    freq.put("tt ", 41);
    freq.put("ji ", 11);
    freq.put("iSa", 8);
    freq.put("Jor", 104);
    freq.put("Jos", 72);
    freq.put("Jov", 20);
    freq.put("Joa", 92);
    freq.put("blo", 80);
    freq.put("bli", 261);
    freq.put("·lí", 10);
    freq.put("ble", 392);
    freq.put("bla", 198);
    freq.put("Jon", 11);
    freq.put("Jo ", 92);
    freq.put("onj", 17);
    freq.put("oni", 398);
    freq.put("onn", 19);
    freq.put("àlb", 10);
    freq.put("onl", 10);
    freq.put("onc", 248);
    freq.put("ona", 1319);
    freq.put("onf", 87);
    freq.put(" Z ", 14);
    freq.put("àli", 20);
    freq.put("one", 380);
    freq.put("onz", 44);
    freq.put("ony", 81);
    freq.put("onr", 10);
    freq.put("ons", 957);
    freq.put("onp", 11);
    freq.put("onq", 8);
    freq.put("onv", 122);
    freq.put("ont", 585);
    freq.put("onu", 10);
    freq.put("onC", 7);
    freq.put("on ", 540);
    freq.put(" Za", 9);
    freq.put("rza", 14);
    freq.put("rzo", 8);
    freq.put("fm ", 16);
    freq.put("sai", 19);
    freq.put("san", 301);
    freq.put("sam", 78);
    freq.put("sal", 349);
    freq.put("sac", 57);
    freq.put("sab", 223);
    freq.put("saa", 19);
    freq.put("sag", 37);
    freq.put("saf", 10);
    freq.put("sae", 7);
    freq.put("sad", 47);
    freq.put("íni", 45);
    freq.put("sas", 79);
    freq.put("sar", 291);
    freq.put("sap", 114);
    freq.put("índ", 8);
    freq.put("sav", 22);
    freq.put("sau", 16);
    freq.put("sat", 188);
    freq.put("Eco", 13);
    freq.put("zon", 32);
    freq.put("ax ", 7);
    freq.put("uV", 12);
    freq.put("sa ", 829);
    freq.put("óc ", 64);
    freq.put("Ò ", 8);
    freq.put("ín ", 23);
    freq.put("uR", 9);
    freq.put("zo ", 35);
    freq.put("axa", 22);
    freq.put("rzó", 9);
    freq.put("axi", 15);
    freq.put("uE", 15);
    freq.put("fàc", 15);
    freq.put("ià ", 81);
    freq.put("uB", 22);
    freq.put("uy", 52);
    freq.put("iàr", 9);
    freq.put(" bà", 14);
    freq.put("És", 99);
    freq.put("uz", 25);
    freq.put(" bé", 130);
    freq.put("uq", 20);
    freq.put("up", 493);
    freq.put("NE ", 7);
    freq.put("ur", 2023);
    freq.put("um", 557);
    freq.put(" b ", 35);
    freq.put("ul", 1153);
    freq.put("càr", 28);
    freq.put("càs", 15);
    freq.put("un", 3730);
    freq.put("càm", 7);
    freq.put("È", 9);
    freq.put("uh", 16);
    freq.put("uk", 24);
    freq.put("cit", 231);
    freq.put("fiq", 8);
    freq.put("aís", 92);
    freq.put(" be", 186);
    freq.put(" ba", 408);
    freq.put("fit", 66);
    freq.put(" bc", 34);
    freq.put(" bl", 113);
    freq.put(" bo", 463);
    freq.put("uot", 11);
    freq.put(" bi", 89);
    freq.put(" bu", 130);
    freq.put(" bt", 13);
    freq.put("s", 44832);
    freq.put(" br", 88);
    freq.put("cà ", 17);
    freq.put(" by", 9);
    freq.put("ní ", 10);
    freq.put("fia", 60);
    freq.put("úri", 15);
    freq.put("fig", 15);
    freq.put("nís", 7);
    freq.put("fie", 14);
    freq.put("níf", 8);
    freq.put("ïn", 16);
    freq.put("ïm", 8);
    freq.put(" M€", 11);
    freq.put("fin", 298);
    freq.put("ït", 27);
    freq.put("ïs", 23);
    freq.put("ive", 383);
    freq.put("uia", 43);
    freq.put("iva", 218);
    freq.put("ivo", 19);
    freq.put("ivi", 176);
    freq.put("orx", 10);
    freq.put("IR ", 10);
    freq.put("iv ", 13);
    freq.put("I", 1200);
    freq.put(" gt", 7);
    freq.put(" gu", 267);
    freq.put(" gr", 512);
    freq.put("gda", 7);
    freq.put("uid", 43);
    freq.put("gdi", 17);
    freq.put("Mad", 97);
    freq.put("màx", 22);
    freq.put("NA ", 48);
    freq.put("acà", 12);
    freq.put("lDi", 13);
    freq.put("ací", 12);
    freq.put("acó", 15);
    freq.put("Man", 91);
    freq.put("ezt", 11);
    freq.put("tve", 15);
    freq.put("ezf", 8);
    freq.put("ac ", 173);
    freq.put("sDe", 11);
    freq.put("ddi", 9);
    freq.put("´", 42);
    freq.put("ez ", 153);
    freq.put("tv ", 111);
    freq.put("acc", 95);
    freq.put("aca", 272);
    freq.put("ace", 98);
    freq.put("ack", 68);
    freq.put("aci", 1000);
    freq.put("ach", 64);
    freq.put("aco", 231);
    freq.put("acl", 25);
    freq.put("acs", 26);
    freq.put("acr", 28);
    freq.put("acu", 72);
    freq.put("act", 250);
    freq.put("dd ", 9);
    freq.put("Nh", 8);
    freq.put("Ni", 86);
    freq.put("Nj", 11);
    freq.put("Nk", 7);
    freq.put("Nm", 7);
    freq.put("aç", 121);
    freq.put("No", 506);
    freq.put("uil", 103);
    freq.put("Na", 179);
    freq.put("aí", 94);
    freq.put("Ne", 118);
    freq.put("aï", 29);
    freq.put("Ng", 8);
    freq.put("añ", 23);
    freq.put("Ny", 7);
    freq.put("aó", 25);
    freq.put("Np", 9);
    freq.put("És ", 95);
    freq.put("Nt", 10);
    freq.put("Nu", 13);
    freq.put("Nv", 10);
    freq.put("heu", 44);
    freq.put("èct", 11);
    freq.put("hes", 16);
    freq.put("hez", 22);
    freq.put("hec", 8);
    freq.put("hel", 21);
    freq.put("hem", 142);
    freq.put("hen", 9);
    freq.put("èci", 20);
    freq.put("ècn", 16);
    freq.put("èco", 8);
    freq.put("N ", 282);
    freq.put("he ", 229);
    freq.put("mps", 151);
    freq.put("àni", 50);
    freq.put("ac", 2487);
    freq.put("ab", 1136);
    freq.put("ae", 182);
    freq.put("ad", 2556);
    freq.put("ag", 1070);
    freq.put("af", 431);
    freq.put("ai", 1425);
    freq.put("ah", 266);
    freq.put("ànc", 26);
    freq.put("aj", 602);
    freq.put("am", 3237);
    freq.put("al", 7804);
    freq.put("ao", 80);
    freq.put("an", 8354);
    freq.put("aq", 692);
    freq.put("ap", 1117);
    freq.put("Nú", 20);
    freq.put("ar", 9179);
    freq.put("Hor", 13);
    freq.put("at", 6328);
    freq.put("aw", 54);
    freq.put("av", 1362);
    freq.put("ay", 148);
    freq.put("ax", 61);
    freq.put("az", 118);
    freq.put("uis", 140);
    freq.put("aA", 54);
    freq.put("uí", 192);
    freq.put("aC", 93);
    freq.put("aB", 60);
    freq.put("aE", 39);
    freq.put("aD", 35);
    freq.put("aG", 46);
    freq.put("aF", 46);
    freq.put("aI", 25);
    freq.put("aH", 26);
    freq.put("aK", 12);
    freq.put("aJ", 20);
    freq.put("aM", 80);
    freq.put("aL", 52);
    freq.put("aO", 31);
    freq.put("aN", 32);
    freq.put("aQ", 10);
    freq.put("aP", 62);
    freq.put("aS", 48);
    freq.put("aR", 63);
    freq.put("aU", 21);
    freq.put("aT", 55);
    freq.put("aW", 51);
    freq.put("aV", 47);
    freq.put("aX", 11);
    freq.put("a ", 27133);
    freq.put("Ho ", 49);
    freq.put("àn ", 7);
    freq.put("oh ", 13);
    freq.put("uiu", 10);
    freq.put("rxi", 20);
    freq.put("at ", 2642);
    freq.put("rxo", 9);
    freq.put("rxa", 75);
    freq.put("rxe", 23);
    freq.put("uà", 16);
    freq.put("uit", 169);
    freq.put("Fir", 28);
    freq.put("Fis", 12);
    freq.put("sco", 333);
    freq.put("tZ", 7);
    freq.put("sch", 47);
    freq.put("tV", 12);
    freq.put("tT", 12);
    freq.put("tU", 10);
    freq.put("tR", 20);
    freq.put("tS", 14);
    freq.put("tP", 18);
    freq.put("ry", 50);
    freq.put("tN", 8);
    freq.put("tO", 13);
    freq.put("tL", 11);
    freq.put("tM", 22);
    freq.put("tJ", 14);
    freq.put("Fig", 9);
    freq.put("tH", 9);
    freq.put("tI", 15);
    freq.put("tF", 19);
    freq.put("tG", 14);
    freq.put("tD", 18);
    freq.put("tE", 10);
    freq.put("tB", 23);
    freq.put("tC", 22);
    freq.put("Fil", 19);
    freq.put("tA", 23);
    freq.put("smo", 36);
    freq.put("tz", 253);
    freq.put("tx", 181);
    freq.put("ty", 68);
    freq.put("tv", 156);
    freq.put("tw", 171);
    freq.put("tt", 3372);
    freq.put("tu", 1184);
    freq.put("tr", 2724);
    freq.put("ts", 2384);
    freq.put("tp", 3167);
    freq.put("tq", 18);
    freq.put("tn", 36);
    freq.put("to", 2292);
    freq.put("tl", 115);
    freq.put("tm", 218);
    freq.put("tj", 197);
    freq.put("tk", 11);
    freq.put("th", 188);
    freq.put("ti", 3560);
    freq.put("tf", 58);
    freq.put("tg", 314);
    freq.put("td", 74);
    freq.put("te", 4515);
    freq.put("tb", 137);
    freq.put("tc", 130);
    freq.put("ta", 7425);
    freq.put("odó", 10);
    freq.put("smi", 28);
    freq.put("sc ", 124);
    freq.put("sme", 207);
    freq.put("ro", 2519);
    freq.put("sma", 48);
    freq.put("t ", 12934);
    freq.put("scà", 8);
    freq.put("scò", 10);
    freq.put("tú", 25);
    freq.put("xos", 38);
    freq.put("tò", 132);
    freq.put("tó", 66);
    freq.put("xof", 9);
    freq.put("tí", 221);
    freq.put("xoc", 10);
    freq.put("tè", 85);
    freq.put("té", 164);
    freq.put("pàg", 12);
    freq.put("tà", 303);
    freq.put("tá", 12);
    freq.put("íli", 23);
    freq.put("xo ", 129);
    freq.put("vic", 88);
    freq.put("via", 451);
    freq.put("Aud", 11);
    freq.put("vid", 240);
    freq.put("vie", 103);
    freq.put("vin", 170);
    freq.put("vio", 44);
    freq.put("vil", 171);
    freq.put("vim", 13);
    freq.put("vir", 77);
    freq.put("vis", 351);
    freq.put("Aus", 7);
    freq.put("Aur", 9);
    freq.put("viv", 38);
    freq.put("Aut", 13);
    freq.put("vit", 73);
    freq.put("viu", 51);
    freq.put("¡", 16);
    freq.put(" d ", 1560);
    freq.put("VE ", 16);
    freq.put("vi ", 144);
    freq.put(" do", 445);
    freq.put(" dm", 7);
    freq.put(" dl", 38);
    freq.put(" di", 1931);
    freq.put("kll", 9);
    freq.put(" de", 8316);
    freq.put(" da", 235);
    freq.put(" dv", 25);
    freq.put(" du", 158);
    freq.put(" dr", 80);
    freq.put("vià", 7);
    freq.put("RS ", 13);
    freq.put("atr", 197);
    freq.put(" d´", 15);
    freq.put("xuc", 7);
    freq.put("xul", 8);
    freq.put("gl", 150);
    freq.put(" dí", 14);
    freq.put(" dè", 15);
    freq.put("ds ", 68);
    freq.put(" dó", 29);
    freq.put("ito", 145);
    freq.put("itl", 16);
    freq.put("itm", 13);
    freq.put("itj", 128);
    freq.put("ith", 15);
    freq.put("iti", 131);
    freq.put("itg", 44);
    freq.put("ite", 161);
    freq.put("itc", 12);
    freq.put("ita", 1157);
    freq.put("itz", 218);
    freq.put("itx", 37);
    freq.put("ity", 30);
    freq.put("itt", 156);
    freq.put("itu", 134);
    freq.put("itr", 28);
    freq.put("its", 203);
    freq.put("UR ", 9);
    freq.put("èxi", 25);
    freq.put("Àn", 24);
    freq.put(" ?", 26);
    freq.put("̶", 8);
    freq.put("rès", 26);
    freq.put("it ", 735);
    freq.put("rèn", 59);
    freq.put("rèc", 15);
    freq.put("rèd", 7);
    freq.put("À ", 12);
    freq.put("ctò", 22);
    freq.put(" A ", 405);
    freq.put("ità", 34);
    freq.put(" Ab", 31);
    freq.put(" Ac", 88);
    freq.put(" Ad", 56);
    freq.put(" Ae", 7);
    freq.put(" Af", 16);
    freq.put(" Ag", 39);
    freq.put(" Ah", 36);
    freq.put(" Ai", 159);
    freq.put(" Aj", 56);
    freq.put(" Al", 455);
    freq.put(" Am", 169);
    freq.put(" An", 258);
    freq.put(" Ap", 53);
    freq.put(" Aq", 176);
    freq.put(" Ar", 294);
    freq.put(" As", 56);
    freq.put(" At", 68);
    freq.put(" Au", 47);
    freq.put(" Av", 232);
    freq.put(" Az", 34);
    freq.put("NG ", 7);
    freq.put("w", 1015);
    freq.put("uem", 98);
    freq.put("Fra", 79);
    freq.put("Fre", 20);
    freq.put("Fri", 7);
    freq.put("uei", 143);
    freq.put("xio", 9);
    freq.put("jer", 15);
    freq.put("jes", 18);
    freq.put("aa ", 76);
    freq.put("jec", 74);
    freq.put("xis", 76);
    freq.put("jej", 18);
    freq.put("xit", 48);
    freq.put("ueg", 14);
    freq.put("xiu", 19);
    freq.put("aaa", 190);
    freq.put("aac", 20);
    freq.put("odi", 125);
    freq.put("aal", 22);
    freq.put("aan", 22);
    freq.put("aah", 7);
    freq.put("exè", 7);
    freq.put("aat", 9);
    freq.put("je ", 22);
    freq.put("lès", 38);
    freq.put("aar", 15);
    freq.put("OT ", 12);
    freq.put("uez", 25);
    freq.put("uet", 131);
    freq.put("ngs", 8);
    freq.put("uev", 17);
    freq.put("ex ", 48);
    freq.put("tp ", 3088);
    freq.put("Bla", 27);
    freq.put("M", 2694);
    freq.put("tpe", 11);
    freq.put("exe", 44);
    freq.put("exc", 45);
    freq.put("tpa", 7);
    freq.put("exa", 60);
    freq.put("exh", 7);
    freq.put("exi", 95);
    freq.put("ext", 64);
    freq.put("exu", 13);
    freq.put("tps", 37);
    freq.put("exs", 8);
    freq.put("exp", 161);
    freq.put(" È", 9);
    freq.put("exy", 10);
    freq.put("ugi", 9);
    freq.put("emà", 188);
    freq.put("Han", 8);
    freq.put("Hab", 8);
    freq.put("uge", 17);
    freq.put("oje", 43);
    freq.put("oja", 24);
    freq.put("ojo", 15);
    freq.put("àpi", 28);
    freq.put("ugu", 96);
    freq.put("oji", 7);
    freq.put("Ha ", 21);
    freq.put("òxi", 12);
    freq.put("cru", 19);
    freq.put("rfa", 7);
    freq.put("cra", 37);
    freq.put("rfe", 40);
    freq.put("cre", 343);
    freq.put("rfi", 13);
    freq.put("cri", 248);
    freq.put("cro", 37);
    freq.put("Fot", 15);
    freq.put("sev", 126);
    freq.put("seu", 216);
    freq.put("set", 190);
    freq.put("ses", 272);
    freq.put("ser", 674);
    freq.put("For", 57);
    freq.put("sep", 87);
    freq.put("sex", 30);
    freq.put("seg", 436);
    freq.put("sef", 8);
    freq.put("see", 7);
    freq.put("sed", 9);
    freq.put("sec", 72);
    freq.put("seb", 14);
    freq.put("sea", 16);
    freq.put("Fol", 10);
    freq.put("sen", 612);
    freq.put("Fon", 30);
    freq.put("sel", 126);
    freq.put("sej", 7);
    freq.put("sei", 20);
    freq.put("úme", 10);
    freq.put("Sí ", 30);
    freq.put("ue ", 2784);
    freq.put("se ", 482);
    freq.put("crò", 10);
    freq.put("crà", 30);
    freq.put("crè", 7);
    freq.put("cré", 9);
    freq.put("crí", 12);
    freq.put("lex", 109);
    freq.put("ui ", 814);
    freq.put("xap", 7);
    freq.put("xar", 143);
    freq.put("xas", 26);
    freq.put("xat", 62);
    freq.put("xav", 62);
    freq.put("tiv", 186);
    freq.put("xam", 56);
    freq.put("xan", 38);
    freq.put("Job", 7);
    freq.put("xac", 15);
    freq.put("xad", 23);
    freq.put("nri", 60);
    freq.put("nro", 8);
    freq.put("evé", 9);
    freq.put("nra", 9);
    freq.put("nre", 43);
    freq.put("ctr", 29);
    freq.put("Oli", 14);
    freq.put("Olo", 19);
    freq.put(" fà", 26);
    freq.put("xa ", 216);
    freq.put("voc", 50);
    freq.put("vol", 441);
    freq.put("vot", 85);
    freq.put("voq", 10);
    freq.put("vor", 109);
    freq.put("lx ", 8);
    freq.put("tir", 246);
    freq.put(" f ", 27);
    freq.put("psa", 14);
    freq.put("vo ", 25);
    freq.put("aña", 16);
    freq.put("Soc", 20);
    freq.put(" fr", 300);
    freq.put(" fu", 216);
    freq.put("Som", 52);
    freq.put("Sol", 54);
    freq.put("Son", 28);
    freq.put(" fa", 739);
    freq.put("Sop", 11);
    freq.put(" fc", 68);
    freq.put(" fb", 46);
    freq.put("Sou", 16);
    freq.put(" fg", 9);
    freq.put(" fi", 478);
    freq.put(" fm", 11);
    freq.put(" fl", 58);
    freq.put(" fo", 462);
    freq.put("O ", 290);
    freq.put("tMa", 10);
    freq.put("On", 42);
    freq.put("Om", 8);
    freq.put("Ol", 59);
    freq.put("Ok", 15);
    freq.put("Oj", 13);
    freq.put("Oi", 11);
    freq.put("Oh", 20);
    freq.put("bí", 12);
    freq.put("Oe", 11);
    freq.put("Od", 18);
    freq.put("Oc", 23);
    freq.put("Ob", 50);
    freq.put("Oa", 14);
    freq.put("tsa", 26);
    freq.put("Oz", 7);
    freq.put("bò", 9);
    freq.put("Ox", 8);
    freq.put("Ow", 12);
    freq.put("Ov", 15);
    freq.put("Ou", 13);
    freq.put("Ot", 8);
    freq.put("Os", 48);
    freq.put("Or", 95);
    freq.put("bú", 7);
    freq.put("Op", 35);
    freq.put("d", 23099);
    freq.put("b ", 1541);
    freq.put("ija", 13);
    freq.put("iji", 13);
    freq.put("Vel", 11);
    freq.put("ijo", 69);
    freq.put("UP ", 19);
    freq.put("bd", 34);
    freq.put("be", 995);
    freq.put("bf", 10);
    freq.put("ba", 1550);
    freq.put("bb", 24);
    freq.put("lAm", 8);
    freq.put("bl", 955);
    freq.put("bm", 27);
    freq.put("bn", 10);
    freq.put("bo", 894);
    freq.put("bi", 533);
    freq.put("bj", 31);
    freq.put("bt", 119);
    freq.put("bu", 296);
    freq.put("bv", 23);
    freq.put("bp", 15);
    freq.put("br", 937);
    freq.put("bs", 120);
    freq.put("Ft", 9);
    freq.put("by", 30);
    freq.put("bz", 10);
    freq.put("Fu", 59);
    freq.put("bB", 7);
    freq.put("bC", 8);
    freq.put("bL", 9);
    freq.put("bM", 13);
    freq.put("Ost", 7);
    freq.put("bJ", 8);
    freq.put("bK", 9);
    freq.put("bP", 9);
    freq.put("Oso", 15);
    freq.put("Osa", 8);
    freq.put("Osc", 11);
    freq.put("ME ", 13);
    freq.put(" C ", 55);
    freq.put("ci ", 131);
    freq.put("uBr", 10);
    freq.put("Lín", 7);
    freq.put("u ", 2823);
    freq.put("Fe", 247);
    freq.put(" Ch", 68);
    freq.put(" Ci", 136);
    freq.put("uY", 9);
    freq.put(" Co", 590);
    freq.put(" Cl", 77);
    freq.put("uT", 18);
    freq.put(" Ca", 958);
    freq.put("uP", 26);
    freq.put("uS", 14);
    freq.put(" Ce", 112);
    freq.put("uM", 16);
    freq.put("uL", 8);
    freq.put("uN", 9);
    freq.put("uI", 8);
    freq.put("uH", 7);
    freq.put("uJ", 11);
    freq.put(" Cr", 136);
    freq.put(" Cs", 8);
    freq.put("uG", 8);
    freq.put("uF", 8);
    freq.put("uA", 13);
    freq.put("uC", 7);
    freq.put(" Cu", 93);
    freq.put("cic", 36);
    freq.put("cib", 9);
    freq.put("cia", 1033);
    freq.put("AC ", 33);
    freq.put("cig", 7);
    freq.put("ux", 30);
    freq.put("cie", 433);
    freq.put("cid", 91);
    freq.put("uu", 102);
    freq.put("ut", 1225);
    freq.put("uw", 7);
    freq.put("uv", 61);
    freq.put("cio", 577);
    freq.put("cin", 139);
    freq.put("cim", 9);
    freq.put("cil", 60);
    freq.put("cis", 93);
    freq.put("cir", 34);
    freq.put("uo", 35);
    freq.put("cip", 119);
    freq.put("ui", 2251);
    freq.put("civ", 23);
    freq.put("ciu", 87);
    freq.put("uj", 107);
    freq.put("ue", 5046);
    freq.put("ud", 495);
    freq.put("ug", 332);
    freq.put("uf", 101);
    freq.put("agó", 12);
    freq.put("uc", 403);
    freq.put("ub", 343);
    freq.put("ag ", 38);
    freq.put("ago", 114);
    freq.put("agn", 17);
    freq.put("cià", 60);
    freq.put("agi", 122);
    freq.put("age", 74);
    freq.put("ciè", 22);
    freq.put("uñ", 7);
    freq.put("aga", 266);
    freq.put("ció", 891);
    freq.put("uï", 44);
    freq.put("ué", 78);
    freq.put("uè", 355);
    freq.put("agu", 151);
    freq.put("ags", 9);
    freq.put("agr", 219);
    freq.put("Jim", 8);
    freq.put("bve", 10);
    freq.put("pul", 75);
    freq.put("tàl", 9);
    freq.put("tr ", 12);
    freq.put("ègi", 9);
    freq.put("ogs", 7);
    freq.put("tri", 217);
    freq.put("evi", 157);
    freq.put("rdó", 11);
    freq.put("evo", 55);
    freq.put("tra", 854);
    freq.put("eva", 269);
    freq.put("tre", 1260);
    freq.put("eve", 118);
    freq.put("rdà", 21);
    freq.put("tru", 78);
    freq.put("onò", 30);
    freq.put("le ", 515);
    freq.put("uel", 180);
    freq.put("uen", 256);
    freq.put("àrq", 9);
    freq.put("àrr", 32);
    freq.put("uee", 9);
    freq.put("ued", 128);
    freq.put("odr", 107);
    freq.put("odu", 41);
    freq.put("uec", 10);
    freq.put("ueb", 7);
    freq.put("àre", 10);
    freq.put("àrd", 9);
    freq.put("Blo", 16);
    freq.put("Bli", 11);
    freq.put("odo", 21);
    freq.put("ueu", 40);
    freq.put("oda", 59);
    freq.put("odc", 8);
    freq.put("àri", 73);
    freq.put("ode", 306);
    freq.put("ues", 874);
    freq.put("uer", 273);
    freq.put("iU ", 56);
    freq.put("ct ", 20);
    freq.put("rd ", 175);
    freq.put("lea", 83);
    freq.put("leb", 61);
    freq.put("lec", 143);
    freq.put("led", 8);
    freq.put("lee", 13);
    freq.put("lef", 14);
    freq.put("leg", 237);
    freq.put("lei", 146);
    freq.put("lej", 15);
    freq.put("lel", 32);
    freq.put("lem", 218);
    freq.put("len", 490);
    freq.put("leo", 8);
    freq.put("ler", 288);
    freq.put("les", 1551);
    freq.put("let", 258);
    freq.put("leu", 66);
    freq.put("lev", 42);
    freq.put("od ", 51);
    freq.put("lez", 15);
    freq.put("rdu", 46);
    freq.put("ctu", 107);
    freq.put("rdv", 10);
    freq.put("trí", 8);
    freq.put("rdp", 13);
    freq.put("rds", 52);
    freq.put("rdr", 53);
    freq.put("trà", 24);
    freq.put("rde", 130);
    freq.put("cte", 251);
    freq.put("rdg", 8);
    freq.put("rda", 259);
    freq.put("cta", 171);
    freq.put("rdc", 9);
    freq.put("rdo", 69);
    freq.put("cto", 142);
    freq.put("rdi", 373);
    freq.put("cti", 173);
    freq.put("sgr", 17);
    freq.put("sgi", 10);
    freq.put("sga", 9);
    freq.put("zis", 25);
    freq.put("zin", 9);
    freq.put("zil", 7);
    freq.put("aBa", 18);
    freq.put("aBe", 7);
    freq.put("aBo", 8);
    freq.put("zi ", 14);
    freq.put("xce", 21);
    freq.put("ró ", 31);
    freq.put("xco", 8);
    freq.put("xcl", 8);
    freq.put("xcu", 13);
    freq.put("cni", 20);
    freq.put("On ", 14);
    freq.put("AB ", 13);
    freq.put("rón", 7);
    freq.put("npe", 9);
    freq.put("Q", 775);
    freq.put("Yl", 12);
    freq.put("Ont", 8);
    freq.put("úl", 71);
    freq.put("úm", 13);
    freq.put("ún", 48);
    freq.put("TY ", 9);
    freq.put("úb", 103);
    freq.put("afa", 90);
    freq.put("út", 15);
    freq.put("úv", 22);
    freq.put("úp", 9);
    freq.put("úr", 16);
    freq.put("ús", 67);
    freq.put("Sa ", 8);
    freq.put("nçó", 25);
    freq.put(" h ", 205);
    freq.put("ú ", 133);
    freq.put("bat", 155);
    freq.put("Yp", 9);
    freq.put("lza", 12);
    freq.put("ène", 8);
    freq.put("bas", 89);
    freq.put("San", 233);
    freq.put("Sal", 108);
    freq.put("Sab", 60);
    freq.put("zat", 28);
    freq.put("Sag", 12);
    freq.put(" hu", 64);
    freq.put(" ht", 3157);
    freq.put(" hi", 522);
    freq.put(" ho", 739);
    freq.put("afr", 36);
    freq.put("Sar", 30);
    freq.put(" ha", 1261);
    freq.put("Sap", 12);
    freq.put(" he", 426);
    freq.put("mni", 55);
    freq.put("nça", 219);
    freq.put("nço", 22);
    freq.put("bac", 27);
    freq.put("sèr", 9);
    freq.put("nç ", 16);
    freq.put(" hò", 7);
    freq.put("ña", 25);
    freq.put("ño", 15);
    freq.put("OM ", 16);
    freq.put("IT ", 14);
    freq.put("Ah ", 12);
    freq.put("iha", 12);
    freq.put("UN ", 10);
    freq.put("rós", 7);
    freq.put("tá ", 7);
    freq.put("ih ", 7);
    freq.put("én ", 16);
    freq.put("JB ", 7);
    freq.put("lly", 15);
    freq.put(" E ", 42);
    freq.put("ck ", 65);
    freq.put("sVi", 11);
    freq.put("otj", 11);
    freq.put("Són", 37);
    freq.put("Sóc", 17);
    freq.put(" El", 951);
    freq.put(" Em", 87);
    freq.put(" En", 329);
    freq.put("xor", 9);
    freq.put(" Eh", 12);
    freq.put(" Ei", 38);
    freq.put(" Ed", 44);
    freq.put(" Eb", 11);
    freq.put(" Ec", 14);
    freq.put(" Ex", 50);
    freq.put(" Et", 44);
    freq.put(" Eu", 66);
    freq.put(" Ev", 16);
    freq.put(" Ep", 15);
    freq.put(" Eq", 13);
    freq.put(" Er", 31);
    freq.put(" Es", 664);
    freq.put("cke", 14);
    freq.put("AA ", 10);
    freq.put("cko", 9);
    freq.put("rAm", 8);
    freq.put("cki", 13);
    freq.put("SLl", 10);
    freq.put("cks", 14);
    freq.put("cky", 10);
    freq.put("dbo", 8);
    freq.put("dba", 9);
    freq.put("da ", 1331);
    freq.put("jav", 8);
    freq.put("jat", 47);
    freq.put("jau", 25);
    freq.put("jar", 85);
    freq.put("jas", 24);
    freq.put("jan", 84);
    freq.put("ae ", 7);
    freq.put("jal", 15);
    freq.put("jam", 22);
    freq.put("jaj", 291);
    freq.put("jad", 27);
    freq.put("jaa", 10);
    freq.put("etó", 7);
    freq.put("aes", 19);
    freq.put("aer", 49);
    freq.put("h", 8411);
    freq.put("etè", 7);
    freq.put("ael", 42);
    freq.put("ja ", 583);
    freq.put("aen", 30);
    freq.put("Pr", 290);
    freq.put("Ps", 10);
    freq.put("btv", 11);
    freq.put("Pv", 9);
    freq.put("Pw", 8);
    freq.put("Pt", 13);
    freq.put("Pu", 137);
    freq.put("Pz", 11);
    freq.put("Px", 10);
    freq.put("Py", 10);
    freq.put("oma", 189);
    freq.put("bte", 83);
    freq.put("Pc", 9);
    freq.put("Pa", 452);
    freq.put("OP ", 9);
    freq.put("Pg", 7);
    freq.put("Pe", 562);
    freq.put("Pj", 9);
    freq.put("Pk", 8);
    freq.put("Ph", 25);
    freq.put("Pi", 162);
    freq.put("Po", 274);
    freq.put("Pl", 109);
    freq.put("Pm", 11);
    freq.put("et ", 790);
    freq.put("lg", 335);
    freq.put("P ", 320);
    freq.put("le", 4348);
    freq.put("eui", 11);
    freq.put("etr", 128);
    freq.put("ets", 186);
    freq.put("etw", 7);
    freq.put("ett", 24);
    freq.put("etu", 25);
    freq.put("etz", 9);
    freq.put("etx", 7);
    freq.put("ln", 19);
    freq.put("eta", 488);
    freq.put("etf", 18);
    freq.put("etg", 9);
    freq.put("etd", 7);
    freq.put("lo", 1820);
    freq.put("etj", 8);
    freq.put("eth", 8);
    freq.put("eti", 203);
    freq.put("tlo", 7);
    freq.put("eto", 53);
    freq.put("etl", 11);
    freq.put("etm", 148);
    freq.put("và", 17);
    freq.put("cj", 8);
    freq.put("ci", 4108);
    freq.put("lm", 266);
    freq.put("co", 6903);
    freq.put("cn", 172);
    freq.put("cm", 45);
    freq.put("cl", 573);
    freq.put("vè", 9);
    freq.put("vé", 31);
    freq.put("ca", 5276);
    freq.put("cg", 15);
    freq.put("ví", 100);
    freq.put("ce", 1425);
    freq.put("cd", 41);
    freq.put("cz", 8);
    freq.put("cy", 12);
    freq.put("cx", 11);
    freq.put("ucc", 39);
    freq.put("àti", 57);
    freq.put("Hel", 13);
    freq.put("cr", 771);
    freq.put("li", 2798);
    freq.put("cw", 8);
    freq.put("cv", 22);
    freq.put("cu", 779);
    freq.put("ct", 930);
    freq.put("Ges", 7);
    freq.put("Ger", 19);
    freq.put("cM", 14);
    freq.put("Get", 9);
    freq.put("cC", 13);
    freq.put("cB", 11);
    freq.put("cA", 10);
    freq.put("cG", 14);
    freq.put("cF", 13);
    freq.put("cE", 15);
    freq.put("cZ", 9);
    freq.put("cY", 8);
    freq.put("güí", 12);
    freq.put("cS", 7);
    freq.put("cR", 8);
    freq.put("cP", 9);
    freq.put("Geo", 18);
    freq.put("Gen", 82);
    freq.put("Gem", 14);
    freq.put("Gel", 7);
    freq.put("lgi", 7);
    freq.put("lgo", 25);
    freq.put("c ", 1983);
    freq.put("Uz", 10);
    freq.put("lge", 7);
    freq.put("He ", 33);
    freq.put("uc ", 61);
    freq.put("lgr", 15);
    freq.put("lgu", 185);
    freq.put("rbu", 8);
    freq.put("xò ", 319);
    freq.put("rbo", 19);
    freq.put("rbl", 8);
    freq.put("eus", 228);
    freq.put("rbi", 29);
    freq.put("cvi", 9);
    freq.put("rbe", 27);
    freq.put("cve", 7);
    freq.put("rba", 49);
    freq.put("va", 2121);
    freq.put("cé", 34);
    freq.put("vc", 10);
    freq.put("vd", 20);
    freq.put("ve", 2214);
    freq.put("vf", 8);
    freq.put("vg", 11);
    freq.put("vi", 2082);
    freq.put("vj", 7);
    freq.put("cà", 75);
    freq.put("vl", 23);
    freq.put("vm", 14);
    freq.put("vn", 13);
    freq.put("vo", 879);
    freq.put("vp", 22);
    freq.put("cú", 10);
    freq.put("vr", 10);
    freq.put("vs", 49);
    freq.put("vu", 589);
    freq.put("vv", 8);
    freq.put("có", 44);
    freq.put("vy", 10);
    freq.put("vz", 8);
    freq.put("vB", 7);
    freq.put("vC", 7);
    freq.put("vD", 11);
    freq.put("vF", 8);
    freq.put("vM", 9);
    freq.put("vN", 8);
    freq.put("vO", 10);
    freq.put("vQ", 7);
    freq.put("vR", 7);
    freq.put("vS", 8);
    freq.put("vT", 10);
    freq.put("vZ", 7);
    freq.put("güe", 24);
    freq.put("v ", 274);
    freq.put("phi", 13);
    freq.put("pho", 8);
    freq.put("lzu", 8);
    freq.put("lgú", 55);
    freq.put("yol", 201);
    freq.put("ofa", 8);
    freq.put("off", 26);
    freq.put("ofe", 101);
    freq.put("ofi", 81);
    freq.put("ofo", 7);
    freq.put("ofr", 15);
    freq.put("oft", 8);
    freq.put("xec", 25);
    freq.put("xel", 20);
    freq.put("xem", 69);
    freq.put("xen", 87);
    freq.put("xet", 13);
    freq.put("qué", 42);
    freq.put("xer", 100);
    freq.put("xes", 106);
    freq.put("Ui ", 7);
    freq.put("dG ", 7);
    freq.put("umn", 32);
    freq.put("wee", 39);
    freq.put("Oh ", 7);
    freq.put("wer", 26);
    freq.put("xe ", 27);
    freq.put("CN ", 60);
    freq.put("nve", 121);
    freq.put("nva", 7);
    freq.put("nvo", 55);
    freq.put("nvi", 223);
    freq.put("Àni", 17);
    freq.put("ía ", 79);
    freq.put(" hr", 7);
    freq.put("AT ", 70);
    freq.put("eu ", 1289);
    freq.put("fè ", 17);
    freq.put(" j ", 23);
    freq.put("lle", 777);
    freq.put("vs ", 34);
    freq.put(" ju", 344);
    freq.put(" jv", 7);
    freq.put(" jp", 10);
    freq.put(" js", 8);
    freq.put(" jr", 9);
    freq.put(" jm", 16);
    freq.put(" jl", 7);
    freq.put(" jo", 612);
    freq.put(" ji", 12);
    freq.put(" je", 29);
    freq.put(" ja", 511);
    freq.put("inú", 9);
    freq.put("inó", 15);
    freq.put("inè", 7);
    freq.put("púb", 96);
    freq.put("sQu", 9);
    freq.put("inx", 11);
    freq.put("iny", 55);
    freq.put("int", 392);
    freq.put("inu", 159);
    freq.put("inv", 74);
    freq.put("inq", 13);
    freq.put("ins", 393);
    freq.put("inm", 7);
    freq.put("inn", 22);
    freq.put("ino", 102);
    freq.put("inh", 41);
    freq.put("ini", 204);
    freq.put("inj", 7);
    freq.put("ink", 14);
    freq.put("ind", 362);
    freq.put("ine", 330);
    freq.put("inf", 184);
    freq.put("ing", 408);
    freq.put("ina", 898);
    freq.put("inc", 365);
    freq.put("eo ", 95);
    freq.put("Uf", 17);
    freq.put("tma", 165);
    freq.put("DA ", 24);
    freq.put("lç", 26);
    freq.put("U", 945);
    freq.put("in ", 366);
    freq.put("eoc", 43);
    freq.put("CI ", 7);
    freq.put("eon", 7);
    freq.put("nNa", 7);
    freq.put("eol", 14);
    freq.put("eos", 9);
    freq.put("eor", 34);
    freq.put("rep", 220);
    freq.put("lí", 163);
    freq.put("AH ", 7);
    freq.put("CS ", 13);
    freq.put("MA ", 20);
    freq.put("lè", 125);
    freq.put(" G ", 31);
    freq.put("lé", 37);
    freq.put("pti", 22);
    freq.put("cm ", 8);
    freq.put("tme", 24);
    freq.put("lò", 58);
    freq.put("pte", 91);
    freq.put("ló", 51);
    freq.put(" Gu", 103);
    freq.put(" Gr", 312);
    freq.put("Tun", 8);
    freq.put(" Ge", 148);
    freq.put(" Ga", 133);
    freq.put(" Go", 125);
    freq.put(" Gl", 19);
    freq.put(" Gi", 99);
    freq.put("glè", 17);
    freq.put("glé", 8);
    freq.put("cme", 8);
    freq.put("cma", 13);
    freq.put("è ", 405);
    freq.put("fa ", 237);
    freq.put("Fq", 9);
    freq.put("ak ", 18);
    freq.put("À", 34);
    freq.put("èx", 27);
    freq.put("LS ", 24);
    freq.put("èr", 52);
    freq.put("ès", 142);
    freq.put("èp", 9);
    freq.put("èt", 26);
    freq.put("èi", 30);
    freq.put("èn", 403);
    freq.put("èl", 14);
    freq.put("èm", 11);
    freq.put("èc", 55);
    freq.put("èf", 16);
    freq.put("èg", 9);
    freq.put("èd", 26);
    freq.put("glo", 14);
    freq.put("gla", 26);
    freq.put("gle", 69);
    freq.put("sla", 21);
    freq.put("aki", 15);
    freq.put("ako", 10);
    freq.put("aka", 16);
    freq.put("ake", 18);
    freq.put("nk ", 19);
    freq.put("Jes", 8);
    freq.put("ix", 1875);
    freq.put("bru", 35);
    freq.put("bro", 37);
    freq.put("bri", 134);
    freq.put("bre", 535);
    freq.put("OR ", 12);
    freq.put("er ", 3349);
    freq.put("ió ", 1172);
    freq.put("erP", 12);
    freq.put("erS", 8);
    freq.put("Nan", 10);
    freq.put("laç", 71);
    freq.put("erA", 8);
    freq.put("erB", 14);
    freq.put("ert", 603);
    freq.put("eru", 20);
    freq.put("erv", 194);
    freq.put("erp", 24);
    freq.put("erq", 169);
    freq.put("err", 492);
    freq.put("ers", 578);
    freq.put("iós", 28);
    freq.put("ery", 14);
    freq.put("erd", 280);
    freq.put("ere", 615);
    freq.put("erf", 49);
    freq.put("erg", 174);
    freq.put("era", 1012);
    freq.put("erb", 36);
    freq.put("erc", 224);
    freq.put("erl", 31);
    freq.put("im", 1575);
    freq.put("ern", 348);
    freq.put("ero", 294);
    freq.put("tni", 8);
    freq.put("eri", 524);
    freq.put("erk", 14);
    freq.put("uay", 9);
    freq.put("Aba", 13);
    freq.put("Nat", 24);
    freq.put("uap", 21);
    freq.put("uas", 27);
    freq.put("uar", 231);
    freq.put("la ", 4540);
    freq.put("uat", 54);
    freq.put("uai", 16);
    freq.put("ual", 263);
    freq.put("uan", 478);
    freq.put("uac", 34);
    freq.put("uad", 27);
    freq.put("brà", 7);
    freq.put("ib", 684);
    freq.put("lal", 52);
    freq.put("lam", 183);
    freq.put("lan", 632);
    freq.put("lai", 65);
    freq.put("lak", 12);
    freq.put("lad", 264);
    freq.put("lae", 34);
    freq.put("laf", 51);
    freq.put("lag", 50);
    freq.put("laa", 22);
    freq.put("lab", 89);
    freq.put("lac", 131);
    freq.put("fat", 25);
    freq.put("laz", 9);
    freq.put("lat", 213);
    freq.put("lau", 187);
    freq.put("lav", 83);
    freq.put("law", 35);
    freq.put("lap", 38);
    freq.put("lar", 545);
    freq.put("las", 194);
    freq.put("laM", 10);
    freq.put("laN", 8);
    freq.put("laO", 9);
    freq.put("erò", 391);
    freq.put("eró", 7);
    freq.put("laA", 7);
    freq.put("erç", 14);
    freq.put("erà", 98);
    freq.put("sèn", 11);
    freq.put("òbi", 23);
    freq.put("lqu", 15);
    freq.put("erí", 8);
    freq.put("laW", 45);
    freq.put("erè", 56);
    freq.put("eré", 9);
    freq.put("laS", 8);
    freq.put("zen", 11);
    freq.put("zem", 9);
    freq.put("zer", 15);
    freq.put("ze ", 22);
    freq.put("ntó", 7);
    freq.put("ntò", 11);
    freq.put("nté", 13);
    freq.put("ntí", 26);
    freq.put("ntà", 23);
    freq.put("àve", 13);
    freq.put("àvi", 8);
    freq.put("l", 39968);
    freq.put("nt ", 2637);
    freq.put("€", 79);
    freq.put("og ", 28);
    freq.put("ntp", 16);
    freq.put("nts", 479);
    freq.put("ntr", 579);
    freq.put("ntu", 62);
    freq.put("ntt", 8);
    freq.put("ntv", 7);
    freq.put("nti", 444);
    freq.put("ntj", 11);
    freq.put("taE", 7);
    freq.put("ntl", 10);
    freq.put("nto", 177);
    freq.put("nta", 821);
    freq.put("ntc", 34);
    freq.put("ntb", 11);
    freq.put("nte", 660);
    freq.put("ntd", 14);
    freq.put("ntf", 13);
    freq.put("lèn", 68);
    freq.put("íti", 89);
    freq.put("íto", 19);
    freq.put("ntA", 8);
    freq.put("mvi", 8);
    freq.put("ntC", 7);
    freq.put(" l ", 1566);
    freq.put("ten", 734);
    freq.put("Se ", 20);
    freq.put(" le", 1118);
    freq.put("B", 1930);
    freq.put(" la", 3738);
    freq.put(" lo", 188);
    freq.put(" ll", 728);
    freq.put(" li", 278);
    freq.put(" lu", 49);
    freq.put(" ls", 34);
    freq.put("tef", 11);
    freq.put("Sev", 10);
    freq.put("Seu", 8);
    freq.put("Set", 19);
    freq.put("Ser", 110);
    freq.put("Sex", 12);
    freq.put("Seg", 84);
    freq.put("Sec", 9);
    freq.put("Sen", 56);
    freq.put("Sem", 46);
    freq.put("Sel", 22);
    freq.put("Q ", 92);
    freq.put(" l´", 7);
    freq.put("ter", 773);
    freq.put("uït", 23);
    freq.put("teu", 167);
    freq.put("sSo", 8);
    freq.put("Qu", 484);
    freq.put("Qv", 8);
    freq.put(" lí", 44);
    freq.put("Qz", 7);
    freq.put("Qa", 11);
    freq.put("Últ", 10);
    freq.put("Qc", 7);
    freq.put("Qb", 8);
    freq.put("Qd", 11);
    freq.put("Qi", 8);
    freq.put("Qj", 12);
    freq.put("Qo", 9);
    freq.put("tse", 115);
    freq.put("uda", 82);
    freq.put("d ", 2280);
    freq.put("tsc", 11);
    freq.put("em ", 1474);
    freq.put("dón", 29);
    freq.put("il·", 19);
    freq.put("hri", 8);
    freq.put("dn", 27);
    freq.put("do", 1225);
    freq.put("dl", 62);
    freq.put("dm", 52);
    freq.put("dj", 28);
    freq.put("dk", 11);
    freq.put("dh", 29);
    freq.put("di", 3548);
    freq.put("df", 18);
    freq.put("dg", 36);
    freq.put("dd", 39);
    freq.put("de", 10674);
    freq.put("db", 32);
    freq.put("dc", 36);
    freq.put("DC ", 10);
    freq.put("da", 2529);
    freq.put("dy", 22);
    freq.put("dv", 60);
    freq.put("dw", 10);
    freq.put("dt", 25);
    freq.put("du", 512);
    freq.put("dr", 921);
    freq.put("ds", 96);
    freq.put("dp", 58);
    freq.put("dq", 13);
    freq.put("eme", 145);
    freq.put("dO", 15);
    freq.put("dL", 13);
    freq.put("dM", 13);
    freq.put("ema", 331);
    freq.put("emc", 15);
    freq.put("emb", 201);
    freq.put("dF", 9);
    freq.put("dG", 13);
    freq.put("dD", 7);
    freq.put("dE", 7);
    freq.put("dB", 17);
    freq.put("dC", 9);
    freq.put("dA", 17);
    freq.put("PA ", 17);
    freq.put("emt", 15);
    freq.put("emp", 486);
    freq.put("ems", 41);
    freq.put("dY", 8);
    freq.put("dV", 7);
    freq.put("dW", 13);
    freq.put("dT", 13);
    freq.put("dU", 9);
    freq.put("dR", 25);
    freq.put("dS", 11);
    freq.put("dP", 35);
    freq.put("dQ", 7);
    freq.put("w ", 110);
    freq.put(" I ", 319);
    freq.put("d´", 15);
    freq.put("il ", 252);
    freq.put("xD ", 21);
    freq.put("co ", 3138);
    freq.put("wg", 9);
    freq.put("wf", 13);
    freq.put("we", 175);
    freq.put("dí", 56);
    freq.put("wc", 7);
    freq.put("wb", 9);
    freq.put("dè", 153);
    freq.put("dé", 31);
    freq.put("wo", 33);
    freq.put("wn", 23);
    freq.put("wm", 10);
    freq.put(" Is", 22);
    freq.put(" It", 12);
    freq.put("wj", 9);
    freq.put("dà", 55);
    freq.put("wh", 27);
    freq.put("ww", 35);
    freq.put("wv", 9);
    freq.put("wu", 10);
    freq.put("wt", 10);
    freq.put(" Il", 25);
    freq.put("wr", 12);
    freq.put(" In", 235);
    freq.put("wp", 9);
    freq.put(" Ib", 18);
    freq.put(" Ic", 10);
    freq.put(" Id", 7);
    freq.put("dó", 52);
    freq.put("wy", 11);
    freq.put(" Ig", 29);
    freq.put("cop", 117);
    freq.put("cos", 297);
    freq.put("ile", 90);
    freq.put("wC", 10);
    freq.put("ilc", 7);
    freq.put("GB ", 9);
    freq.put("ila", 334);
    freq.put("ilo", 64);
    freq.put("ill", 547);
    freq.put("ilm", 16);
    freq.put("wK", 9);
    freq.put("ili", 250);
    freq.put("ilv", 36);
    freq.put("wV", 7);
    freq.put("ilt", 14);
    freq.put("ilu", 16);
    freq.put("ils", 55);
    freq.put("wP", 7);
    freq.put("coi", 28);
    freq.put("coh", 13);
    freq.put("com", 1138);
    freq.put("col", 386);
    freq.put("coo", 33);
    freq.put("wX", 7);
    freq.put("ópe", 7);
    freq.put("gn ", 11);
    freq.put("ai ", 163);
    freq.put("nió", 33);
    freq.put("epú", 13);
    freq.put("aix", 567);
    freq.put("ait", 24);
    freq.put("ais", 41);
    freq.put("air", 119);
    freq.put("aim", 21);
    freq.put("ail", 50);
    freq.put("ET ", 13);
    freq.put("gna", 98);
    freq.put("epè", 7);
    freq.put("gne", 30);
    freq.put("aie", 14);
    freq.put("aid", 15);
    freq.put("aig", 206);
    freq.put("gni", 27);
    freq.put("aia", 54);
    freq.put("gno", 15);
    freq.put("aic", 8);
    freq.put("ni ", 340);
    freq.put("ep ", 91);
    freq.put("th ", 25);
    freq.put("nik", 17);
    freq.put("nii", 10);
    freq.put("nin", 108);
    freq.put("nio", 33);
    freq.put("nil", 36);
    freq.put("nim", 256);
    freq.put("nib", 33);
    freq.put("nic", 289);
    freq.put("nia", 226);
    freq.put("nif", 63);
    freq.put("nig", 24);
    freq.put("nid", 20);
    freq.put("nie", 89);
    freq.put("Y", 315);
    freq.put("nis", 173);
    freq.put("nip", 18);
    freq.put("niq", 11);
    freq.put("niv", 129);
    freq.put("nit", 372);
    freq.put("niu", 71);
    freq.put("ept", 53);
    freq.put("epu", 32);
    freq.put("epr", 59);
    freq.put("eps", 7);
    freq.put("tho", 59);
    freq.put("epo", 42);
    freq.put("epl", 8);
    freq.put("thl", 22);
    freq.put("thi", 14);
    freq.put("epi", 37);
    freq.put("the", 39);
    freq.put("epe", 247);
    freq.put("epc", 24);
    freq.put("CV ", 16);
    freq.put("epa", 108);
    freq.put("rn ", 161);
    freq.put("lc ", 12);
    freq.put("Gau", 15);
    freq.put("Gat", 7);
    freq.put("Gas", 13);
    freq.put("Gar", 70);
    freq.put("Gan", 14);
    freq.put("Gam", 7);
    freq.put("Gal", 26);
    freq.put("Gab", 9);
    freq.put("Tri", 28);
    freq.put("rni", 41);
    freq.put("lcu", 8);
    freq.put("rno", 22);
    freq.put("Tro", 21);
    freq.put("Tra", 41);
    freq.put("rna", 354);
    freq.put("Tre", 50);
    freq.put("rne", 163);
    freq.put("lce", 9);
    freq.put("plà", 8);
    freq.put("rns", 17);
    freq.put("lco", 67);
    freq.put("Tru", 12);
    freq.put("lch", 10);
    freq.put("lci", 7);
    freq.put("zf ", 7);
    freq.put("zca", 9);
    freq.put("òme", 7);
    freq.put("pl ", 8);
    freq.put("àx ", 8);
    freq.put("ob ", 10);
    freq.put("Leo", 10);
    freq.put("Les", 98);
    freq.put("Lev", 11);
    freq.put("plu", 34);
    freq.put("rná", 7);
    freq.put("ple", 172);
    freq.put("aDe", 11);
    freq.put("BI ", 10);
    freq.put("pla", 258);
    freq.put("aDa", 8);
    freq.put("plo", 70);
    freq.put("pli", 161);
    freq.put("obo", 30);
    freq.put("àxi", 16);
    freq.put("obj", 23);
    freq.put("obi", 67);
    freq.put("obe", 111);
    freq.put("obc", 11);
    freq.put("oba", 177);
    freq.put("obu", 9);
    freq.put("obr", 366);
    freq.put("obs", 20);
    freq.put("Cur", 22);
    freq.put("Cug", 10);
    freq.put("Cue", 9);
    freq.put("Cub", 12);
    freq.put("Cul", 25);
    freq.put("túl", 8);
    freq.put("Cui", 11);
    freq.put("dèn", 114);
    freq.put("wal", 10);
    freq.put("dèf", 11);
    freq.put("way", 8);
    freq.put("udí", 11);
    freq.put("dès", 16);
    freq.put("war", 12);
    freq.put("ïna", 8);
    freq.put("xy ", 9);
    freq.put("tú ", 9);
    freq.put(" nú", 27);
    freq.put("mto", 11);
    freq.put("mta", 7);
    freq.put("ué ", 42);
    freq.put(" n ", 147);
    freq.put("Sy", 8);
    freq.put("üe", 35);
    freq.put("lBa", 8);
    freq.put(" ni", 366);
    freq.put("umu", 7);
    freq.put(" no", 2423);
    freq.put(" na", 213);
    freq.put(" nc", 7);
    freq.put(" ne", 331);
    freq.put(" ns", 24);
    freq.put(" nu", 48);
    freq.put("FC ", 41);
    freq.put("ums", 11);
    freq.put("M€", 11);
    freq.put("Sc", 14);
    freq.put("gu ", 14);
    freq.put("uís", 24);
    freq.put("Sf", 7);
    freq.put("XSa", 11);
    freq.put("uím", 8);
    freq.put("ó ", 1468);
    freq.put("umb", 14);
    freq.put("umo", 19);
    freq.put("gua", 420);
    freq.put("EO ", 21);
    freq.put("gue", 446);
    freq.put("gud", 37);
    freq.put("ós", 71);
    freq.put("ór", 20);
    freq.put("gui", 488);
    freq.put("óp", 8);
    freq.put("gun", 188);
    freq.put("gum", 12);
    freq.put("gul", 64);
    freq.put("gus", 50);
    freq.put("p", 19714);
    freq.put("ón", 370);
    freq.put("gut", 170);
    freq.put("óc", 70);
    freq.put("ód", 7);
    freq.put("hta", 8);
    freq.put("htt", 3133);
    freq.put("èri", 32);
    freq.put("PCo", 13);
    freq.put("PCa", 8);
    freq.put("èrc", 7);
    freq.put("ña ", 18);
    freq.put("ht ", 26);
    freq.put("gué", 27);
    freq.put("Sk", 14);
    freq.put("Mos", 20);
    freq.put("nBo", 7);
    freq.put("PC ", 24);
    freq.put("Mou", 34);
    freq.put("spà", 8);
    freq.put("MM ", 11);
    freq.put(" Ka", 25);
    freq.put(" Ke", 20);
    freq.put("ib ", 7);
    freq.put(" Ki", 23);
    freq.put(" Ko", 9);
    freq.put(" Km", 12);
    freq.put("ca ", 953);
    freq.put("Mon", 124);
    freq.put("Mom", 7);
    freq.put("F", 1549);
    freq.put("fb ", 12);
    freq.put("caC", 10);
    freq.put("kso", 7);
    freq.put("ibi", 67);
    freq.put(" K ", 26);
    freq.put("ibl", 139);
    freq.put("ibo", 23);
    freq.put("cas", 338);
    freq.put("car", 729);
    freq.put("cap", 293);
    freq.put("cav", 36);
    freq.put("cau", 58);
    freq.put("cat", 1054);
    freq.put("cai", 56);
    freq.put("cao", 9);
    freq.put("can", 469);
    freq.put("cam", 255);
    freq.put("cal", 345);
    freq.put("cac", 125);
    freq.put("cab", 182);
    freq.put("ibr", 75);
    freq.put("Mod", 14);
    freq.put("cag", 28);
    freq.put("caf", 36);
    freq.put("cae", 17);
    freq.put("cad", 201);
    freq.put("pq ", 41);
    freq.put("lò ", 12);
    freq.put("ao ", 18);
    freq.put("spr", 181);
    freq.put("spu", 25);
    freq.put("spi", 120);
    freq.put("spl", 45);
    freq.put("spo", 269);
    freq.put("spa", 414);
    freq.put("spe", 382);
    freq.put("gh ", 12);
    freq.put("lòg", 21);
    freq.put("aon", 8);
    freq.put("aol", 11);
    freq.put("lòn", 11);
    freq.put("aor", 15);
    freq.put("sp ", 20);
    freq.put("ght", 13);
    freq.put(" àn", 19);
    freq.put(" àl", 10);
    freq.put(" àr", 8);
    freq.put("iód", 7);
    freq.put("ER ", 53);
    freq.put("zón", 13);
    freq.put("IÓ ", 30);
    freq.put("Rt", 10);
    freq.put("Ru", 53);
    freq.put("eï", 21);
    freq.put("Rp", 7);
    freq.put("Che", 11);
    freq.put("usc", 54);
    freq.put("Jav", 20);
    freq.put("Chi", 9);
    freq.put("Jau", 42);
    freq.put("Rx", 10);
    freq.put("Ry", 7);
    freq.put("Rd", 10);
    freq.put("Re", 375);
    freq.put("mbo", 31);
    freq.put("Jaj", 31);
    freq.put("Ra", 201);
    freq.put("Rc", 12);
    freq.put("Rl", 9);
    freq.put("Ro", 233);
    freq.put("eñ", 7);
    freq.put("Ri", 137);
    freq.put("eó", 12);
    freq.put("nol", 51);
    freq.put("nom", 277);
    freq.put("non", 35);
    freq.put("noh", 8);
    freq.put("noi", 55);
    freq.put("nod", 8);
    freq.put("noe", 21);
    freq.put("noa", 17);
    freq.put("tjo", 52);
    freq.put("noc", 31);
    freq.put("R ", 231);
    freq.put("not", 128);
    freq.put("nou", 158);
    freq.put("nov", 171);
    freq.put("son", 269);
    freq.put("nop", 12);
    freq.put("Ja ", 159);
    freq.put("nos", 341);
    freq.put("órr", 10);
    freq.put("sor", 234);
    freq.put("sou", 40);
    freq.put("sot", 44);
    freq.put("em", 3323);
    freq.put("el", 8201);
    freq.put("eo", 256);
    freq.put("en", 9360);
    freq.put("ei", 1669);
    freq.put("eh", 97);
    freq.put("ek", 24);
    freq.put("ej", 165);
    freq.put("ee", 292);
    freq.put("ed", 860);
    freq.put("eg", 1541);
    freq.put("ef", 353);
    freq.put("ea", 514);
    freq.put("rl ", 9);
    freq.put("ec", 1670);
    freq.put("eb", 642);
    freq.put("ey", 78);
    freq.put("ex", 614);
    freq.put("ez", 244);
    freq.put("eu", 2163);
    freq.put("et", 2491);
    freq.put("ew", 42);
    freq.put("ev", 629);
    freq.put("eq", 151);
    freq.put("ep", 786);
    freq.put("es", 12214);
    freq.put("er", 9943);
    freq.put("eM", 32);
    freq.put("eL", 18);
    freq.put("eO", 13);
    freq.put("eN", 10);
    freq.put("eH", 9);
    freq.put("eJ", 10);
    freq.put("eE", 17);
    freq.put("eD", 16);
    freq.put("eG", 22);
    freq.put("eF", 25);
    freq.put("eA", 16);
    freq.put("eC", 26);
    freq.put("eB", 36);
    freq.put("Só", 58);
    freq.put("eY", 10);
    freq.put("eX", 9);
    freq.put("eZ", 10);
    freq.put("eU", 10);
    freq.put("eT", 27);
    freq.put("eW", 9);
    freq.put("eV", 17);
    freq.put("eQ", 7);
    freq.put("eP", 24);
    freq.put("eS", 25);
    freq.put("eR", 21);
    freq.put("iMa", 8);
    freq.put("rlo", 48);
    freq.put("rli", 21);
    freq.put("rle", 112);
    freq.put("rld", 7);
    freq.put("rla", 198);
    freq.put("e ", 13386);
    freq.put("lmi", 14);
    freq.put("lmo", 33);
    freq.put("lma", 66);
    freq.put("lme", 111);
    freq.put("fc", 80);
    freq.put("zan", 16);
    freq.put("xk", 18);
    freq.put("xh", 9);
    freq.put("xi", 423);
    freq.put("xn", 7);
    freq.put("xo", 227);
    freq.put("xl", 19);
    freq.put("xm", 33);
    freq.put("xb", 22);
    freq.put("xc", 69);
    freq.put("zad", 22);
    freq.put("xa", 677);
    freq.put("xf", 15);
    freq.put("xg", 11);
    freq.put("xd", 29);
    freq.put("xe", 486);
    freq.put("xz", 7);
    freq.put("xx", 30);
    freq.put("xy", 18);
    freq.put("xr", 24);
    freq.put("xs", 18);
    freq.put("xp", 190);
    freq.put("xq", 19);
    freq.put("zar", 63);
    freq.put("xw", 10);
    freq.put("xt", 90);
    freq.put("xu", 75);
    freq.put("xK", 7);
    freq.put("xH", 11);
    freq.put("xI", 8);
    freq.put("yia", 12);
    freq.put("xO", 9);
    freq.put("xC", 15);
    freq.put("xA", 8);
    freq.put("xF", 12);
    freq.put("xG", 8);
    freq.put("xD", 98);
    freq.put("xE", 12);
    freq.put("xZ", 8);
    freq.put("xY", 8);
    freq.put("xR", 8);
    freq.put("xS", 10);
    freq.put("xU", 7);
    freq.put("x ", 848);
    freq.put("gú ", 88);
    freq.put("pna", 13);
    freq.put("yi ", 7);
    freq.put("IB ", 18);
    freq.put("Pf", 7);
    freq.put("xè", 9);
    freq.put("xí", 96);
    freq.put("xà", 10);
    freq.put("xò", 326);
    freq.put("xó", 8);
    freq.put("Pho", 10);
    freq.put("Off", 10);
    freq.put("Ofi", 25);
    freq.put("ípi", 9);
    freq.put("fJ", 10);
    freq.put("ò", 1176);
    freq.put("ege", 55);
    freq.put("Web", 50);
    freq.put("Wer", 26);
    freq.put(" p ", 34);
    freq.put(" ps", 24);
    freq.put(" pr", 1351);
    freq.put(" pq", 42);
    freq.put(" pp", 14);
    freq.put(" pv", 8);
    freq.put(" pu", 353);
    freq.put("ííí", 8);
    freq.put(" pa", 1446);
    freq.put(" pf", 9);
    freq.put(" pe", 3204);
    freq.put(" pi", 247);
    freq.put(" ph", 11);
    freq.put(" po", 1314);
    freq.put(" pl", 318);
    freq.put("vu ", 7);
    freq.put(" Úl", 10);
    freq.put(" pú", 83);
    freq.put(" pà", 20);
    freq.put("sàp", 8);
    freq.put(" pè", 12);
    freq.put("vue", 8);
    freq.put("EM ", 26);
    freq.put("vul", 91);
    freq.put("vui", 473);
    freq.put("màt", 26);
    freq.put("màs", 8);
    freq.put("èti", 22);
    freq.put("màg", 13);
    freq.put("OE ", 21);
    freq.put(" Mà", 8);
    freq.put(" Mé", 39);
    freq.put("ei ", 128);
    freq.put(" Mò", 7);
    freq.put(" Mú", 7);
    freq.put("mà ", 209);
    freq.put("pàs", 9);
    freq.put("eis", 77);
    freq.put("eir", 27);
    freq.put("eit", 19);
    freq.put("eiv", 30);
    freq.put("eix", 975);
    freq.put("eia", 65);
    freq.put("CO ", 14);
    freq.put("eib", 10);
    freq.put("eie", 70);
    freq.put("eid", 54);
    freq.put("eig", 74);
    freq.put("eil", 7);
    freq.put("ein", 106);
    freq.put("uxe", 7);
    freq.put("cec", 11);
    freq.put("ceb", 46);
    freq.put(" Me", 249);
    freq.put(" Ma", 781);
    freq.put("etc", 14);
    freq.put(" Ml", 8);
    freq.put(" Mo", 392);
    freq.put(" Mi", 215);
    freq.put(" Mu", 87);
    freq.put(" Mr", 9);
    freq.put("cc ", 45);
    freq.put("cel", 403);
    freq.put("tle", 36);
    freq.put("NS ", 30);
    freq.put("ete", 278);
    freq.put("yd", 17);
    freq.put(" M ", 134);
    freq.put("xí ", 91);
    freq.put("cco", 8);
    freq.put("cci", 224);
    freq.put("cce", 48);
    freq.put("tll", 41);
    freq.put("cca", 26);
    freq.put("AI ", 8);
    freq.put("ck", 162);
    freq.put("Heu", 10);
    freq.put("am ", 127);
    freq.put("ps ", 296);
    freq.put("án", 23);
    freq.put("ch", 371);
    freq.put("ucr", 17);
    freq.put("Her", 28);
    freq.put("cc", 385);
    freq.put("cb", 98);
    freq.put("yv", 9);
    freq.put("ami", 196);
    freq.put("á ", 18);
    freq.put("psi", 10);
    freq.put("amm", 25);
    freq.put("pso", 7);
    freq.put("amo", 161);
    freq.put("ama", 287);
    freq.put("psc", 10);
    freq.put("amb", 1348);
    freq.put("ame", 635);
    freq.put("cf", 31);
    freq.put("amp", 296);
    freq.put("ams", 10);
    freq.put("amu", 60);
    freq.put("uce", 12);
    freq.put("t", 47509);
    freq.put("gz ", 7);
    freq.put("EP ", 10);
    freq.put("uca", 75);
    freq.put("cs", 430);
    freq.put("yG", 7);
    freq.put("Hem", 37);
    freq.put("cp", 34);
    freq.put("yX", 8);
    freq.put("uck", 11);
    freq.put("uci", 86);
    freq.put("uch", 20);
    freq.put("amí", 44);
    freq.put("cJ", 11);
    freq.put("tde", 29);
    freq.put("nme", 8);
    freq.put("nma", 21);
    freq.put("tdp", 22);
    freq.put("nmi", 8);
    freq.put("sra", 13);
    freq.put("sre", 13);
    freq.put("cL", 11);
    freq.put("sro", 21);
    freq.put("yT", 12);
    freq.put("Adr", 31);
    freq.put("Ade", 13);
    freq.put("lob", 32);
    freq.put("loc", 157);
    freq.put("loa", 27);
    freq.put("log", 87);
    freq.put("lok", 7);
    freq.put("loi", 12);
    freq.put("lon", 414);
    freq.put("loo", 10);
    freq.put("lol", 10);
    freq.put("lom", 38);
    freq.put("lor", 382);
    freq.put("los", 104);
    freq.put("lop", 48);
    freq.put("loq", 9);
    freq.put("lov", 43);
    freq.put("low", 29);
    freq.put("lot", 120);
    freq.put("lou", 38);
    freq.put("òli", 12);
    freq.put("iCa", 13);
    freq.put("J", 1223);
    freq.put("rja", 22);
    freq.put("lo ", 205);
    freq.put("cV", 9);
    freq.put("Ens", 53);
    freq.put("cU", 9);
    freq.put("rb ", 11);
    freq.put("Est", 235);
    freq.put("Esq", 28);
    freq.put("Esp", 289);
    freq.put("LaC", 12);
    freq.put("Esc", 83);
    freq.put("LaT", 24);
    freq.put("LaV", 13);
    freq.put(" sa", 516);
    freq.put("Lai", 16);
    freq.put("Lau", 27);
    freq.put("you", 19);
    freq.put("Lap", 9);
    freq.put("yor", 55);
    freq.put("Lar", 15);
    freq.put("Las", 7);
    freq.put("lga", 30);
    freq.put("Es ", 60);
    freq.put("Bru", 29);
    freq.put("La ", 509);
    freq.put("yo ", 26);
    freq.put("Bro", 9);
    freq.put("Bri", 11);
    freq.put("Bre", 8);
    freq.put("Bra", 16);
    freq.put("mp ", 92);
    freq.put("mpe", 107);
    freq.put("mpa", 233);
    freq.put("mpo", 198);
    freq.put("mpl", 146);
    freq.put("mpi", 71);
    freq.put("mpt", 75);
    freq.put("mpu", 42);
    freq.put("mpr", 349);
    freq.put(" rà", 28);
    freq.put(" rè", 8);
    freq.put("En ", 102);
    freq.put("Núr", 11);
    freq.put("pun", 174);
    freq.put(" r ", 39);
    freq.put("puj", 37);
    freq.put("pue", 21);
    freq.put(" ru", 69);
    freq.put(" rt", 13);
    freq.put(" re", 1436);
    freq.put(" ra", 197);
    freq.put(" rc", 17);
    freq.put(" rb", 8);
    freq.put(" rm", 7);
    freq.put(" ro", 227);
    freq.put(" ri", 133);
    freq.put("TS ", 27);
    freq.put("puy", 11);
    freq.put("put", 118);
    freq.put("ués", 32);
    freq.put("cè", 27);
    freq.put("S ", 489);
    freq.put("yó", 11);
    freq.put("cí", 34);
    freq.put("pur", 18);
    freq.put("Sz", 8);
    freq.put("fò", 12);
    freq.put("Sx", 9);
    freq.put("Sr", 22);
    freq.put("Sp", 74);
    freq.put("Sw", 7);
    freq.put("Su", 83);
    freq.put("St", 64);
    freq.put("fà", 35);
    freq.put("Sj", 8);
    freq.put("Si", 308);
    freq.put("Sh", 28);
    freq.put("So", 264);
    freq.put("Sn", 7);
    freq.put("Sm", 13);
    freq.put("fè", 28);
    freq.put("fé", 7);
    freq.put("Sa", 515);
    freq.put("fí", 24);
    freq.put("Se", 433);
    freq.put("Sd", 8);
    freq.put("RE ", 14);
    freq.put("f ", 220);
    freq.put("UD ", 7);
    freq.put("cò", 23);
    freq.put("hhh", 14);
    freq.put("eg ", 19);
    freq.put("fp", 15);
    freq.put("fq", 7);
    freq.put("fr", 496);
    freq.put("fs", 16);
    freq.put("ft", 26);
    freq.put("fu", 283);
    freq.put("fw", 8);
    freq.put("fx", 11);
    freq.put("fy", 17);
    freq.put("of ", 14);
    freq.put("fa", 1011);
    freq.put("fb", 52);
    freq.put("hh ", 16);
    freq.put("fd", 15);
    freq.put("fe", 1618);
    freq.put("ff", 166);
    freq.put("fg", 22);
    freq.put("fi", 977);
    freq.put("fj", 7);
    freq.put("fk", 10);
    freq.put("fl", 126);
    freq.put("fm", 36);
    freq.put("fo", 892);
    freq.put("a", 81949);
    freq.put("fQ", 7);
    freq.put("fU", 7);
    freq.put("fV", 9);
    freq.put("fW", 10);
    freq.put("fX", 7);
    freq.put("egr", 101);
    freq.put("fZ", 11);
    freq.put("egu", 536);
    freq.put("egi", 157);
    freq.put("ego", 183);
    freq.put("egn", 11);
    freq.put("egl", 26);
    freq.put("ega", 420);
    freq.put("CA ", 25);
    freq.put("fL", 8);
    freq.put("fN", 10);
    freq.put("fO", 10);
    freq.put("ce ", 59);
    freq.put("y ", 645);
    freq.put("uvi", 12);
    freq.put("ffi", 28);
    freq.put("uvo", 19);
    freq.put("fff", 62);
    freq.put("uve", 21);
    freq.put("ffa", 8);
    freq.put(" On", 34);
    freq.put(" Ol", 41);
    freq.put(" Oj", 8);
    freq.put(" Ok", 9);
    freq.put(" Oh", 12);
    freq.put(" Oi", 7);
    freq.put(" Of", 15);
    freq.put(" Od", 9);
    freq.put(" Ob", 37);
    freq.put(" Oc", 16);
    freq.put(" Ou", 8);
    freq.put(" Or", 77);
    freq.put(" Os", 43);
    freq.put(" Op", 25);
    freq.put("yi", 38);
    freq.put("yh", 8);
    freq.put("yk", 9);
    freq.put("ced", 23);
    freq.put("ym", 33);
    freq.put("yl", 24);
    freq.put("yo", 324);
    freq.put("yn", 22);
    freq.put("ya", 832);
    freq.put("cen", 248);
    freq.put("cem", 24);
    freq.put("yb", 20);
    freq.put("ye", 180);
    freq.put("sCo", 13);
    freq.put("yg", 8);
    freq.put("yf", 17);
    freq.put("yx", 8);
    freq.put("cet", 17);
    freq.put("ces", 213);
    freq.put("cer", 277);
    freq.put("cep", 60);
    freq.put("yp", 12);
    freq.put("ys", 336);
    freq.put("yr", 17);
    freq.put("yu", 18);
    freq.put("yt", 14);
    freq.put("yw", 12);
    freq.put("ff ", 45);
    freq.put("yI", 11);
    freq.put("ifu", 10);
    freq.put("yK", 8);
    freq.put("yM", 9);
    freq.put("yL", 9);
    freq.put("ifr", 16);
    freq.put("MI ", 7);
    freq.put("yE", 13);
    freq.put("yD", 15);
    freq.put(" O ", 69);
    freq.put("yF", 7);
    freq.put("ife", 96);
    freq.put("yZ", 8);
    freq.put("ifa", 24);
    freq.put("yS", 7);
    freq.put("yR", 10);
    freq.put("yU", 12);
    freq.put("ifi", 99);
    freq.put("yV", 7);
    freq.put("Enc", 36);
    freq.put("End", 14);
    freq.put("Enf", 12);
    freq.put("Eng", 15);
    freq.put("Enh", 12);
    freq.put("Enr", 28);
    freq.put("as ", 749);
    freq.put("Ent", 40);
    freq.put("Env", 9);
    freq.put("EnC", 10);
    freq.put("ass", 670);
    freq.put("asr", 10);
    freq.put("asq", 11);
    freq.put("asp", 41);
    freq.put("pui", 25);
    freq.put("asu", 38);
    freq.put("ast", 337);
    freq.put("pud", 7);
    freq.put("MB ", 30);
    freq.put("pug", 29);
    freq.put("pub", 64);
    freq.put("puc", 51);
    freq.put("asc", 100);
    freq.put("asa", 228);
    freq.put("asf", 19);
    freq.put("ase", 129);
    freq.put("asd", 8);
    freq.put("ask", 13);
    freq.put("asi", 83);
    freq.put("ash", 24);
    freq.put("aso", 54);
    freq.put("asn", 7);
    freq.put("asm", 22);
    freq.put("pus", 33);
    freq.put("ion", 718);
    freq.put("ifí", 13);
    freq.put("Ima", 13);
    freq.put("Clo", 13);
    freq.put("Cli", 10);
    freq.put("Cla", 43);
    freq.put("Imp", 24);
    freq.put("nc ", 258);
    freq.put("Clu", 17);
    freq.put("liç", 39);
    freq.put("st ", 534);
    freq.put("dt ", 10);
    freq.put("lió", 8);
    freq.put("tfo", 11);
    freq.put("tfe", 25);
    freq.put("ncr", 31);
    freq.put("ncs", 100);
    freq.put("ncu", 38);
    freq.put("nch", 55);
    freq.put("nci", 869);
    freq.put("ncl", 30);
    freq.put("nco", 86);
    freq.put("nca", 403);
    freq.put("nce", 298);
    freq.put("ste", 706);
    freq.put("stg", 11);
    freq.put("sta", 1421);
    freq.put("sto", 149);
    freq.put("sth", 18);
    freq.put("sti", 706);
    freq.put("stu", 145);
    freq.put("stv", 8);
    freq.put("stw", 14);
    freq.put("str", 651);
    freq.put("sts", 55);
    freq.put("Gom", 9);
    freq.put("Gol", 21);
    freq.put("Goo", 23);
    freq.put("ka ", 35);
    freq.put("God", 9);
    freq.put("iA ", 7);
    freq.put("Gov", 39);
    freq.put("Gor", 11);
    freq.put("lid", 122);
    freq.put("lie", 73);
    freq.put("lif", 21);
    freq.put("lig", 87);
    freq.put("Nin", 9);
    freq.put("lia", 225);
    freq.put("lib", 111);
    freq.put("lic", 509);
    freq.put("lil", 10);
    freq.put("lim", 57);
    freq.put("lin", 171);
    freq.put("lio", 96);
    freq.put("lii", 10);
    freq.put("lit", 474);
    freq.put("liu", 83);
    freq.put("liv", 80);
    freq.put("lip", 63);
    freq.put("liq", 33);
    freq.put("lir", 35);
    freq.put("lis", 176);
    freq.put("lix", 9);
    freq.put("Nit", 18);
    freq.put("kam", 9);
    freq.put("ncè", 7);
    freq.put("kar", 16);
    freq.put("Thi", 13);
    freq.put("The", 23);
    freq.put("stà", 204);
    freq.put("stá", 8);
    freq.put("stí", 26);
    freq.put("Ni ", 31);
    freq.put("stè", 22);
    freq.put("sté", 11);
    freq.put("stò", 57);
    freq.put("stó", 10);
    freq.put("ifo", 24);
    freq.put("Equ", 8);
    freq.put("aNe", 8);
    freq.put("yma", 13);
    freq.put("ox ", 13);
    freq.put("ymo", 8);
    freq.put("xeu", 13);
    freq.put("oxi", 13);
    freq.put("x", 4172);
    freq.put("bé ", 273);
    freq.put("Fòr", 7);
    freq.put("Plu", 9);
    freq.put("wor", 16);
    freq.put("rça", 358);
    freq.put("Ple", 8);
    freq.put("Pla", 78);
    freq.put("web", 91);
    freq.put("Obe", 10);
    freq.put("çon", 21);
    freq.put("Déu", 13);
    freq.put("Obr", 11);
    freq.put("Obs", 8);
    freq.put("rç ", 29);
    freq.put("Gon", 11);
    freq.put("War", 7);
    freq.put(" t ", 3233);
    freq.put(" € ", 65);
    freq.put(" tw", 119);
    freq.put(" tv", 65);
    freq.put(" tu", 259);
    freq.put(" ts", 9);
    freq.put(" tr", 693);
    freq.put("Aju", 47);
    freq.put(" to", 1075);
    freq.put(" ti", 346);
    freq.put(" th", 26);
    freq.put(" te", 963);
    freq.put(" tc", 7);
    freq.put(" tb", 19);
    freq.put(" ta", 699);
    freq.put("rPa", 8);
    freq.put("adh", 12);
    freq.put("dià", 12);
    freq.put("boi", 42);
    freq.put("gs ", 27);
    freq.put(" tú", 12);
    freq.put("nó ", 19);
    freq.put("DE ", 84);
    freq.put(" tí", 11);
    freq.put(" té", 125);
    freq.put(" tè", 17);
    freq.put("FA ", 12);
    freq.put("còc", 8);
    freq.put("bog", 7);
    freq.put("RC ", 73);
    freq.put("UB ", 13);
    freq.put("CCa", 7);
    freq.put("ee ", 42);
    freq.put("Tea", 31);
    freq.put("tut", 54);
    freq.put("eet", 49);
    freq.put("eep", 10);
    freq.put("ees", 30);
    freq.put("eer", 14);
    freq.put("eel", 14);
    freq.put("een", 21);
    freq.put("liz", 10);
    freq.put("eek", 7);
    freq.put("eee", 62);
    freq.put("eed", 9);
    freq.put("CC ", 18);
    freq.put("idà", 12);
    freq.put("tCa", 8);
    freq.put("ru ", 14);
    freq.put("ço ", 7);
    freq.put(" Qu", 456);
    freq.put(" Qa", 7);
    freq.put("id ", 162);
    freq.put("rui", 43);
    freq.put("run", 22);
    freq.put("rul", 25);
    freq.put("rum", 37);
    freq.put("rub", 24);
    freq.put("ruc", 49);
    freq.put("rua", 12);
    freq.put("ruf", 10);
    freq.put("rug", 17);
    freq.put("rue", 11);
    freq.put("rur", 8);
    freq.put("rus", 41);
    freq.put("rup", 103);
    freq.put("rut", 71);
    freq.put("idu", 17);
    freq.put("idr", 18);
    freq.put("ids", 11);
    freq.put(" Q ", 45);
    freq.put("ido", 93);
    freq.put("idi", 87);
    freq.put("ide", 309);
    freq.put("idb", 9);
    freq.put("ida", 399);
    freq.put("Eli", 19);
    freq.put("Ell", 10);
    freq.put("oha", 14);
    freq.put("Ele", 18);
    freq.put("aq ", 10);
    freq.put("Els", 206);
    freq.put("Tà", 15);
    freq.put("ut ", 322);
    freq.put("naç", 8);
    freq.put("aqu", 667);
    freq.put("El ", 671);
    freq.put("li ", 261);
    freq.put("utb", 74);
    freq.put("tum", 19);
    freq.put("àci", 287);
    freq.put("fde", 7);
    freq.put("utg", 8);
    freq.put("ute", 53);
    freq.put("utj", 16);
    freq.put("uti", 68);
    freq.put("uto", 99);
    freq.put("utr", 12);
    freq.put("uts", 146);
    freq.put("Lóp", 7);
    freq.put("utu", 59);
    freq.put("utx", 11);
    freq.put("àct", 24);
    freq.put("naB", 7);
    freq.put("naC", 13);
    freq.put("naA", 14);
    freq.put("naF", 11);
    freq.put("naG", 7);
    freq.put("Tx", 21);
    freq.put("Tv", 12);
    freq.put("Tw", 53);
    freq.put("Tt", 7);
    freq.put("Tu", 86);
    freq.put("Tr", 161);
    freq.put("Ts", 14);
    freq.put("naM", 9);
    freq.put("Tn", 7);
    freq.put("To", 282);
    freq.put("Tl", 7);
    freq.put("Tk", 8);
    freq.put("Th", 45);
    freq.put("Ti", 102);
    freq.put("Tf", 7);
    freq.put("Tg", 9);
    freq.put("Td", 27);
    freq.put("Te", 237);
    freq.put("Ta", 184);
    freq.put("nab", 42);
    freq.put("A ", 1016);
    freq.put("naa", 13);
    freq.put("naf", 23);
    freq.put("nag", 19);
    freq.put("nad", 190);
    freq.put("naj", 7);
    freq.put("nah", 11);
    freq.put("nai", 38);
    freq.put("nan", 174);
    freq.put("nal", 476);
    freq.put("nam", 63);
    freq.put("nar", 521);
    freq.put("nas", 79);
    freq.put("nap", 36);
    freq.put("nav", 79);
    freq.put("nat", 339);
    freq.put("nau", 68);
    freq.put("naz", 31);
    freq.put("T ", 3151);
    freq.put("Aa", 10);
    freq.put("Ac", 116);
    freq.put("Ab", 43);
    freq.put("Ae", 35);
    freq.put("Ad", 71);
    freq.put("Ag", 54);
    freq.put("Af", 20);
    freq.put("dve", 10);
    freq.put("dvd", 7);
    freq.put("Ak", 13);
    freq.put("Aj", 58);
    freq.put("Am", 202);
    freq.put("Al", 511);
    freq.put("Ao", 14);
    freq.put("An", 286);
    freq.put("Aq", 181);
    freq.put("Ap", 85);
    freq.put("As", 78);
    freq.put("Ar", 325);
    freq.put("Au", 57);
    freq.put("At", 75);
    freq.put("Aw", 8);
    freq.put("Av", 243);
    freq.put("Ay", 11);
    freq.put("Ax", 10);
    freq.put("Az", 39);
    freq.put("gu", 2073);
    freq.put("gt", 18);
    freq.put("Gis", 8);
    freq.put("Gir", 68);
    freq.put("gq", 11);
    freq.put("gp", 16);
    freq.put("gz", 9);
    freq.put("gy", 9);
    freq.put("gg", 26);
    freq.put("gf", 12);
    freq.put("ge", 1111);
    freq.put("gd", 38);
    freq.put("gc", 21);
    freq.put("Gib", 8);
    freq.put("ga", 1580);
    freq.put("go", 670);
    freq.put("gn", 208);
    freq.put("gm", 38);
    freq.put("Gil", 18);
    freq.put("gk", 7);
    freq.put("gi", 767);
    freq.put("zó", 15);
    freq.put("gV", 13);
    freq.put("gU", 7);
    freq.put("cBa", 8);
    freq.put("gR", 10);
    freq.put("gP", 7);
    freq.put("lke", 9);
    freq.put("gD", 8);
    freq.put("gB", 7);
    freq.put("gA", 10);
    freq.put("Not", 19);
    freq.put("Nou", 62);
    freq.put("Nov", 27);
    freq.put("gK", 7);
    freq.put("rto", 86);
    freq.put("Nor", 24);
    freq.put("Nos", 17);
    freq.put("iGa", 9);
    freq.put("g ", 706);
    freq.put("hi ", 439);
    freq.put("adí", 13);
    freq.put("No ", 272);
    freq.put("adè", 8);
    freq.put("Spo", 12);
    freq.put("Spa", 41);
    freq.put("adé", 7);
    freq.put("zl", 19);
    freq.put("zm", 10);
    freq.put("zn", 17);
    freq.put("zo", 90);
    freq.put("zh", 9);
    freq.put("zi", 70);
    freq.put("oz ", 7);
    freq.put("zk", 8);
    freq.put("zd", 9);
    freq.put("ze", 83);
    freq.put("zf", 15);
    freq.put("gü", 44);
    freq.put("za", 276);
    freq.put("zb", 12);
    freq.put("zc", 21);
    freq.put("zx", 12);
    freq.put("zy", 10);
    freq.put("zz", 41);
    freq.put("gà", 8);
    freq.put("zt", 19);
    freq.put("zu", 53);
    freq.put("zv", 8);
    freq.put("zp", 12);
    freq.put("zq", 16);
    freq.put("zr", 8);
    freq.put("gè", 33);
    freq.put("zM", 10);
    freq.put("aLl", 7);
    freq.put("aLi", 8);
    freq.put("Sí", 37);
    freq.put("zE", 7);
    freq.put("zG", 9);
    freq.put("zA", 16);
    freq.put("zB", 10);
    freq.put("aLa", 11);
    freq.put("zS", 7);
    freq.put("ull", 217);
    freq.put("oza", 8);
    freq.put("ozl", 10);
    freq.put("z ", 315);
    freq.put("Ahi", 14);
    freq.put("IA ", 39);
    freq.put("cés", 32);
    freq.put("win", 11);
    freq.put("Jq", 8);
    freq.put("wit", 175);
    freq.put("dàr", 15);
    freq.put("Js", 12);
    freq.put(" và", 8);
    freq.put(" ví", 84);
    freq.put("Jh", 8);
    freq.put("Ji", 14);
    freq.put("dà ", 28);
    freq.put("ien", 234);
    freq.put("ieb", 11);
    freq.put("ied", 8);
    freq.put("ieg", 13);
    freq.put("Mr ", 7);
    freq.put(" va", 828);
    freq.put(" ve", 853);
    freq.put(" vi", 755);
    freq.put(" vo", 558);
    freq.put(" vp", 17);
    freq.put(" vs", 33);
    freq.put(" vu", 107);
    freq.put("HI ", 10);
    freq.put(" v ", 28);
    freq.put("míl", 22);
    freq.put("hic", 27);
    freq.put("TO ", 11);
    freq.put("tòr", 99);
    freq.put("RAe", 26);
    freq.put("RAc", 18);
    freq.put("ens", 928);
    freq.put("RAs", 14);
    freq.put("RAp", 24);
    freq.put("sMa", 9);
    freq.put("RA ", 112);
    freq.put("ç", 893);
    freq.put("EG ", 12);
    freq.put("maq", 8);
    freq.put("ec ", 150);
    freq.put("hlo", 8);
    freq.put("mar", 729);
    freq.put("hle", 15);
    freq.put("mav", 22);
    freq.put("ece", 122);
    freq.put("ecc", 101);
    freq.put("eca", 140);
    freq.put("CE ", 17);
    freq.put("eco", 302);
    freq.put("ecn", 17);
    freq.put("ecl", 61);
    freq.put("eci", 147);
    freq.put("ech", 25);
    freq.put("ecu", 69);
    freq.put("ect", 440);
    freq.put("ecs", 10);
    freq.put("ecr", 60);
    freq.put("OC ", 16);
    freq.put("tK", 7);
    freq.put("rs ", 689);
    freq.put("AN ", 20);
    freq.put("aru", 14);
    freq.put(" Sr", 15);
    freq.put(" Sp", 57);
    freq.put(" St", 48);
    freq.put(" Su", 72);
    freq.put("arx", 115);
    freq.put(" Sh", 23);
    freq.put(" Si", 278);
    freq.put(" So", 229);
    freq.put("ary", 7);
    freq.put(" Sc", 11);
    freq.put(" Sa", 425);
    freq.put(" Se", 398);
    freq.put("rso", 111);
    freq.put("rsi", 115);
    freq.put("rse", 51);
    freq.put("rsa", 91);
    freq.put("rsc", 7);
    freq.put("R", 4205);
    freq.put("NU ", 8);
    freq.put("ben", 145);
    freq.put("bel", 91);
    freq.put("bem", 31);
    freq.put("bec", 14);
    freq.put("beg", 8);
    freq.put("bed", 7);
    freq.put("ber", 436);
    freq.put("bes", 66);
    freq.put(" S ", 73);
    freq.put("bet", 28);
    freq.put("beu", 27);
    freq.put("py ", 7);
    freq.put("ur ", 150);
    freq.put(" Só", 58);
    freq.put("uu ", 14);
    freq.put("Dep", 9);
    freq.put(" Sí", 37);
    freq.put("rtú", 9);
    freq.put("BA ", 8);
    freq.put("awn", 7);
    freq.put("awe", 34);
    freq.put("urd", 7);
    freq.put("ure", 528);
    freq.put(" èx", 24);
    freq.put("ura", 549);
    freq.put("urb", 20);
    freq.put("urc", 12);
    freq.put("urm", 7);
    freq.put("urn", 13);
    freq.put(" èp", 8);
    freq.put("uri", 198);
    freq.put("urj", 17);
    freq.put("urt", 84);
    freq.put("urv", 9);
    freq.put("urr", 35);
    freq.put("urs", 92);
    freq.put("Del", 39);
    freq.put("tb ", 20);
    freq.put("lsc", 7);
    freq.put("nge", 147);
    freq.put("nga", 89);
    freq.put("ngl", 45);
    freq.put("ngo", 33);
    freq.put("ngi", 31);
    freq.put("sh ", 18);
    freq.put("ngu", 298);
    freq.put("ngr", 82);
    freq.put("dp ", 12);
    freq.put("luí", 23);
    freq.put("íem", 24);
    freq.put("tbo", 86);
    freq.put("tba", 10);
    freq.put("sht", 7);
    freq.put("sha", 8);
    freq.put("shi", 22);
    freq.put("dpi", 7);
    freq.put("sho", 18);
    freq.put("Sr ", 12);
    freq.put("ües", 20);
    freq.put("ke ", 20);
    freq.put("TdP", 20);
    freq.put("üen", 10);
    freq.put("lup", 17);
    freq.put("lur", 9);
    freq.put("lus", 74);
    freq.put("lut", 70);
    freq.put("lux", 9);
    freq.put("lua", 11);
    freq.put("lub", 41);
    freq.put("luc", 70);
    freq.put("lud", 14);
    freq.put("lue", 18);
    freq.put("lug", 10);
    freq.put("ngü", 30);
    freq.put("lui", 104);
    freq.put("luj", 20);
    freq.put("lum", 65);
    freq.put("ngú", 37);
    freq.put("kel", 14);
    freq.put("kea", 9);
    freq.put("ket", 21);
    freq.put("ker", 18);
    freq.put("lu ", 17);
    freq.put("Loc", 11);
    freq.put("ot ", 623);
    freq.put("Lon", 11);
    freq.put("Lol", 8);
    freq.put("Lor", 7);
    freq.put("Los", 14);
    freq.put("OO ", 13);
    freq.put("yat", 39);
    freq.put("yas", 23);
    freq.put("yar", 78);
    freq.put("yam", 22);
    freq.put("aRa", 7);
    freq.put("yan", 26);
    freq.put("aRe", 8);
    freq.put("yae", 16);
    freq.put("yad", 14);
    freq.put("aRo", 22);
    freq.put("oth", 64);
    freq.put("oti", 131);
    freq.put("Lo ", 15);
    freq.put("otl", 12);
    freq.put("oto", 122);
    freq.put("ota", 282);
    freq.put("ote", 233);
    freq.put("otg", 11);
    freq.put("otx", 41);
    freq.put("otr", 25);
    freq.put("ots", 383);
    freq.put("ott", 11);
    freq.put("otu", 15);
    freq.put("otv", 16);
    freq.put("And", 83);
    freq.put("Ane", 13);
    freq.put("Ang", 19);
    freq.put("Ana", 18);
    freq.put("Ann", 44);
    freq.put("Ano", 11);
    freq.put("Ani", 17);
    freq.put("sBo", 7);
    freq.put("Ant", 55);
    freq.put("eó ", 9);
    freq.put("Any", 10);
    freq.put("You", 16);
    freq.put("Yor", 7);
    freq.put("PP ", 77);
    freq.put("otí", 44);
    freq.put("i", 45254);
    freq.put(" xD", 94);
    freq.put("pW", 8);
    freq.put(" xk", 8);
    freq.put("Be", 164);
    freq.put(" xi", 53);
    freq.put(" xo", 39);
    freq.put("Ba", 724);
    freq.put(" xm", 12);
    freq.put("Bc", 32);
    freq.put("Bl", 65);
    freq.put(" xb", 9);
    freq.put(" xa", 115);
    freq.put("Bo", 306);
    freq.put("Bh", 10);
    freq.put("Bi", 63);
    freq.put(" xe", 35);
    freq.put(" xd", 25);
    freq.put("Bt", 13);
    freq.put("Bu", 90);
    freq.put("Bv", 7);
    freq.put("Bq", 7);
    freq.put("Br", 86);
    freq.put("Bs", 8);
    freq.put(" xr", 8);
    freq.put(" xq", 12);
    freq.put("és ", 1924);
    freq.put("By", 7);
    freq.put(" xu", 35);
    freq.put("B ", 239);
    freq.put(" x ", 164);
    freq.put("xsa", 8);
    freq.put("ubt", 27);
    freq.put("ubv", 10);
    freq.put("U ", 203);
    freq.put("ubs", 36);
    freq.put("Bé", 14);
    freq.put("tgo", 8);
    freq.put("?", 46);
    freq.put("Uy", 9);
    freq.put("dui", 22);
    freq.put("RO ", 12);
    freq.put("Ut", 12);
    freq.put("lça", 19);
    freq.put("Uq", 7);
    freq.put("Up", 14);
    freq.put("Us", 49);
    freq.put("Ur", 46);
    freq.put("Um", 7);
    freq.put("Ul", 15);
    freq.put("Uo", 13);
    freq.put("Un", 328);
    freq.put("Ui", 16);
    freq.put("Uh", 9);
    freq.put("Ue", 10);
    freq.put("pv", 36);
    freq.put("LL ", 8);
    freq.put("Ua", 10);
    freq.put("Uc", 9);
    freq.put("dun", 7);
    freq.put("swa", 7);
    freq.put("dub", 33);
    freq.put("duc", 89);
    freq.put("ea ", 108);
    freq.put("sbc", 12);
    freq.put("hz", 8);
    freq.put("eak", 8);
    freq.put("hy", 10);
    freq.put("eam", 25);
    freq.put("eal", 81);
    freq.put("ean", 17);
    freq.put("hr", 31);
    freq.put("hs", 17);
    freq.put("eac", 26);
    freq.put("hv", 8);
    freq.put("ead", 19);
    freq.put("eag", 14);
    freq.put("hu", 108);
    freq.put("hj", 13);
    freq.put("dup", 7);
    freq.put("hh", 45);
    freq.put("hi", 788);
    freq.put("hn", 9);
    freq.put("ho", 1035);
    freq.put("hl", 36);
    freq.put("hm", 10);
    freq.put("hb", 12);
    freq.put("hc", 10);
    freq.put("eas", 16);
    freq.put("ear", 58);
    freq.put("ph", 32);
    freq.put("hd", 15);
    freq.put("he", 663);
    freq.put("pi", 798);
    freq.put("dme", 10);
    freq.put("dmi", 22);
    freq.put("hP", 13);
    freq.put("hV", 11);
    freq.put("hW", 8);
    freq.put("hU", 9);
    freq.put("hI", 7);
    freq.put("hO", 9);
    freq.put("hD", 12);
    freq.put("hE", 14);
    freq.put("òs ", 14);
    freq.put("nur", 28);
    freq.put("rq ", 7);
    freq.put(" tx", 24);
    freq.put(" Ur", 41);
    freq.put(" Us", 39);
    freq.put(" Ul", 11);
    freq.put(" Un", 305);
    freq.put(" Ui", 10);
    freq.put(" Uf", 11);
    freq.put("rqu", 267);
    freq.put("euE", 7);
    freq.put("hò", 8);
    freq.put("hí", 9);
    freq.put("òst", 11);
    freq.put("N", 1325);
    freq.put("bcn", 91);
    freq.put("ilb", 8);
    freq.put("mèd", 9);
    freq.put(" U ", 21);
    freq.put("mès", 8);
    freq.put("auc", 25);
    freq.put("aud", 83);
    freq.put("aug", 63);
    freq.put("auf", 8);
    freq.put("aum", 72);
    freq.put("aul", 131);
    freq.put("up ", 65);
    freq.put("aun", 15);
    freq.put("aup", 31);
    freq.put("aus", 76);
    freq.put("aur", 202);
    freq.put("aut", 96);
    freq.put("Eh ", 11);
    freq.put("upn", 13);
    freq.put("au ", 221);
    freq.put("upl", 27);
    freq.put("upi", 14);
    freq.put("upe", 102);
    freq.put("upc", 11);
    freq.put("upa", 75);
    freq.put("dré", 12);
    freq.put("drí", 15);
    freq.put("oSa", 11);
    freq.put("drà", 44);
    freq.put("upt", 10);
    freq.put("upr", 12);
    freq.put("ups", 18);
    freq.put("àgi", 26);
    freq.put("Igu", 21);
    freq.put("me ", 463);
    freq.put("ògi", 26);
    freq.put("Ign", 10);
    freq.put("nen", 206);
    freq.put("neo", 8);
    freq.put("Pun", 18);
    freq.put("nem", 134);
    freq.put("nej", 9);
    freq.put("Pui", 30);
    freq.put("Puj", 22);
    freq.put("nei", 71);
    freq.put("nef", 12);
    freq.put("Pue", 11);
    freq.put("ned", 72);
    freq.put("nee", 11);
    freq.put("neb", 8);
    freq.put("nec", 78);
    freq.put("nea", 13);
    freq.put("nez", 35);
    freq.put("Puy", 17);
    freq.put("ney", 9);
    freq.put("Put", 12);
    freq.put("dr ", 7);
    freq.put("net", 170);
    freq.put("neu", 124);
    freq.put("ner", 302);
    freq.put("nes", 536);
    freq.put("mee", 9);
    freq.put("med", 60);
    freq.put("meg", 22);
    freq.put("íci", 73);
    freq.put("mem", 53);
    freq.put("mel", 86);
    freq.put("men", 1492);
    freq.put("mei", 16);
    freq.put("meu", 211);
    freq.put("met", 186);
    freq.put("mev", 67);
    freq.put("mes", 339);
    freq.put("mer", 397);
    freq.put("ícu", 37);
    freq.put("íct", 9);
    freq.put("mez", 14);
    freq.put("meB", 11);
    freq.put("dru", 10);
    freq.put("ne ", 150);
    freq.put("dri", 241);
    freq.put("són", 130);
    freq.put("dro", 89);
    freq.put("dra", 97);
    freq.put("dre", 399);
    freq.put("St ", 9);
    freq.put("món", 76);
    freq.put("Tit", 12);
    freq.put("lwa", 9);
    freq.put("Á", 7);
    freq.put("Ste", 8);
    freq.put("uTu", 14);
    freq.put("Sta", 16);
    freq.put("Sto", 11);
    freq.put("V", 1372);
    freq.put("oví", 7);
    freq.put("Tim", 14);
    freq.put("Tin", 37);
    freq.put("´a", 14);
    freq.put("Lig", 15);
    freq.put("Lib", 11);
    freq.put("Lin", 22);
    freq.put("nèi", 21);
    freq.put("Liv", 7);
    freq.put("nès", 17);
    freq.put("Al ", 77);
    freq.put("cí ", 18);
    freq.put("aPi", 7);
    freq.put("eño", 7);
    freq.put("aPa", 16);
    freq.put("aPe", 12);
    freq.put("Li ", 11);
    freq.put("ova", 209);
    freq.put("ove", 277);
    freq.put("ovi", 102);
    freq.put("ovo", 19);
    freq.put("All", 26);
    freq.put("Alm", 16);
    freq.put("Ali", 20);
    freq.put("Alf", 16);
    freq.put("Alg", 35);
    freq.put("Ale", 71);
    freq.put("Alb", 97);
    freq.put("Alc", 28);
    freq.put("Ala", 23);
    freq.put("Alv", 28);
    freq.put("Alt", 34);
    freq.put("Alu", 7);
    freq.put("Als", 9);
    freq.put("bó ", 8);
    freq.put("ono", 100);
    freq.put("ong", 107);
    freq.put("ond", 122);
    freq.put("Úl", 10);
    freq.put("pí", 20);
    freq.put("SS ", 15);
    freq.put(" zo", 24);
    freq.put(" zi", 8);
    freq.put(" ze", 12);
    freq.put("is ", 673);
    freq.put("isV", 7);
    freq.put("isG", 8);
    freq.put("xur", 7);
    freq.put("xus", 8);
    freq.put("iss", 234);
    freq.put("isr", 14);
    freq.put("isq", 7);
    freq.put("isp", 63);
    freq.put(" z ", 17);
    freq.put("isu", 13);
    freq.put("ist", 793);
    freq.put("isi", 211);
    freq.put("ish", 17);
    freq.put("iso", 52);
    freq.put("xua", 8);
    freq.put("ism", 189);
    freq.put("isl", 15);
    freq.put("isc", 238);
    freq.put("isb", 19);
    freq.put("isa", 80);
    freq.put("isg", 11);
    freq.put("isf", 49);
    freq.put("ise", 49);
    freq.put("isd", 7);
    freq.put("jja", 18);
    freq.put("ri ", 363);
    freq.put("EC ", 19);
    freq.put("RM ", 7);
    freq.put("ty ", 46);
    freq.put("do ", 151);
    freq.put("don", 274);
    freq.put("doo", 7);
    freq.put("dol", 55);
    freq.put("dom", 39);
    freq.put("dob", 29);
    freq.put("doc", 44);
    freq.put("m", 20135);
    freq.put("dor", 436);
    freq.put("dos", 116);
    freq.put("dop", 10);
    freq.put("dov", 13);
    freq.put("dow", 10);
    freq.put("dot", 11);
    freq.put(" We", 34);
    freq.put(" Wa", 17);
    freq.put(" Wo", 14);
    freq.put(" Wh", 9);
    freq.put(" Wi", 20);
    freq.put("èn ", 14);
    freq.put("ba ", 195);
    freq.put("omà", 18);
    freq.put(" W ", 17);
    freq.put("omé", 143);
    freq.put("omí", 10);
    freq.put("omú", 9);
    freq.put("bav", 9);
    freq.put("ènc", 338);
    freq.put("bar", 371);
    freq.put("ènd", 20);
    freq.put("èni", 9);
    freq.put("bag", 11);
    freq.put("bad", 95);
    freq.put("bab", 19);
    freq.put("ènt", 13);
    freq.put("ban", 180);
    freq.put("bal", 226);
    freq.put("bam", 9);
    freq.put("baj", 12);
    freq.put("bai", 102);
    freq.put("om ", 744);
    freq.put("nju", 23);
    freq.put("Rub", 16);
    freq.put("un ", 1283);
    freq.put("Rus", 7);
    freq.put("omb", 76);
    freq.put("C", 3237);
    freq.put("omf", 14);
    freq.put("ome", 526);
    freq.put("omd", 7);
    freq.put("omi", 160);
    freq.put("omo", 39);
    freq.put("omn", 39);
    freq.put("omm", 19);
    freq.put("oms", 25);
    freq.put("omr", 11);
    freq.put("omp", 407);
    freq.put("omu", 73);
    freq.put("omt", 7);
    freq.put("unq", 23);
    freq.put("uns", 148);
    freq.put("unt", 445);
    freq.put("uny", 319);
    freq.put("una", 830);
    freq.put("unc", 130);
    freq.put("und", 116);
    freq.put("une", 92);
    freq.put("unf", 11);
    freq.put("ung", 11);
    freq.put("uni", 242);
    freq.put("unk", 16);
    freq.put("unn", 10);
    freq.put("uno", 20);
    freq.put("ón ", 318);
    freq.put("ió", 1273);
    freq.put("iò", 7);
    freq.put("onè", 32);
    freq.put("iè", 52);
    freq.put("ià", 108);
    freq.put("iç", 41);
    freq.put("eBa", 10);
    freq.put("C ", 525);
    freq.put("onà", 10);
    freq.put("mco", 11);
    freq.put("óna", 34);
    freq.put("mca", 26);
    freq.put("díc", 11);
    freq.put("Ci", 163);
    freq.put("Ch", 82);
    freq.put("Co", 670);
    freq.put("Cn", 7);
    freq.put("Cm", 9);
    freq.put("Cl", 96);
    freq.put("Cc", 13);
    freq.put("Cb", 8);
    freq.put("Ca", 1156);
    freq.put("Ví", 12);
    freq.put("Ce", 135);
    freq.put("Cd", 10);
    freq.put("sll", 13);
    freq.put("Cy", 10);
    freq.put("slo", 24);
    freq.put("sli", 7);
    freq.put("Cs", 16);
    freq.put("Cr", 156);
    freq.put("Cw", 8);
    freq.put("Cv", 9);
    freq.put("Cu", 113);
    freq.put("Ct", 8);
    freq.put("iy", 14);
    freq.put("Nac", 27);
    freq.put("iz", 74);
    freq.put("Nad", 64);
    freq.put("iq", 308);
    freq.put("ip", 518);
    freq.put("is", 2822);
    freq.put("ir", 2076);
    freq.put("iu", 1057);
    freq.put("it", 3489);
    freq.put("iw", 17);
    freq.put("iv", 829);
    freq.put("ii", 188);
    freq.put("ih", 34);
    freq.put("ik", 116);
    freq.put("ij", 105);
    freq.put("Nav", 19);
    freq.put("il", 1763);
    freq.put("io", 1518);
    freq.put("in", 4494);
    freq.put("ia", 4374);
    freq.put("ic", 3181);
    freq.put("ki ", 31);
    freq.put("ie", 1455);
    freq.put("id", 1209);
    freq.put("ig", 1389);
    freq.put("if", 312);
    freq.put("V ", 303);
    freq.put("iX", 10);
    freq.put("ínc", 10);
    freq.put("iQ", 8);
    freq.put("iP", 37);
    freq.put("iS", 26);
    freq.put("iR", 29);
    freq.put("iU", 63);
    freq.put("iT", 17);
    freq.put("iW", 9);
    freq.put("iV", 12);
    freq.put("iI", 11);
    freq.put("iH", 12);
    freq.put("iK", 13);
    freq.put("iJ", 13);
    freq.put("iM", 28);
    freq.put("iL", 20);
    freq.put("iO", 8);
    freq.put("iN", 13);
    freq.put("iA", 74);
    freq.put("iC", 29);
    freq.put("iB", 23);
    freq.put("iE", 8);
    freq.put("iD", 16);
    freq.put("iG", 26);
    freq.put("iF", 16);
    freq.put("kis", 15);
    freq.put("kin", 32);
    freq.put("kil", 12);
    freq.put("i ", 7633);
    freq.put("kie", 7);
    freq.put("Va", 331);
    freq.put("Vb", 7);
    freq.put("Vd", 8);
    freq.put("Ve", 137);
    freq.put("Vh", 7);
    freq.put("Vi", 421);
    freq.put("Vl", 11);
    freq.put("Vm", 8);
    freq.put("Vo", 82);
    freq.put("Vp", 7);
    freq.put("Vq", 7);
    freq.put("Vr", 8);
    freq.put("Vu", 30);
    freq.put("Vz", 9);
    freq.put("yel", 9);
    freq.put("yen", 20);
    freq.put("op ", 127);
    freq.put("yes", 41);
    freq.put("yer", 44);
    freq.put("yet", 29);
    freq.put("aVo", 7);
    freq.put("aVi", 7);
    freq.put("eur", 386);
    freq.put("aVa", 21);
    freq.put("opt", 13);
    freq.put("opu", 33);
    freq.put("opr", 11);
    freq.put("ops", 22);
    freq.put("ye ", 13);
    freq.put(" És", 98);
    freq.put("ope", 179);
    freq.put("opa", 163);
    freq.put("opc", 18);
    freq.put("opo", 112);
    freq.put("opi", 97);
    freq.put("Arr", 23);
    freq.put("Art", 46);
    freq.put("ï", 101);
    freq.put("Ara", 152);
    freq.put("Arc", 10);
    freq.put("Are", 23);
    freq.put("Arg", 9);
    freq.put("Ari", 7);
    freq.put("Arm", 8);
    freq.put("Arn", 15);
    freq.put("www", 12);
    freq.put("zu ", 10);
    freq.put("idí", 11);
    freq.put("bra", 176);
    freq.put("idè", 23);

    init3();
  }
  private static void init3() {
    
    freq.put("ww ", 15);
    freq.put("ÉS ", 16);
    freq.put("zun", 8);
    freq.put("zul", 22);
    freq.put("DN ", 8);
    freq.put("tè ", 10);
    freq.put("TE ", 17);
    freq.put("Z", 288);
    freq.put("iqu", 293);
    freq.put("tèt", 10);
    freq.put("tèn", 34);
    freq.put("tèg", 7);
    freq.put("tèc", 13);
    freq.put("HO ", 8);
    freq.put("nki", 11);
    freq.put("EA ", 11);
    freq.put("Win", 9);
    freq.put("Wil", 8);
    freq.put("Grà", 136);
    freq.put("Més", 36);
    freq.put("Grè", 10);
    freq.put("di ", 200);
    freq.put("diP", 8);
    freq.put("dil", 53);
    freq.put("dim", 85);
    freq.put("din", 165);
    freq.put("dio", 143);
    freq.put("dij", 43);
    freq.put("did", 39);
    freq.put("die", 151);
    freq.put("dif", 82);
    freq.put("dig", 159);
    freq.put("sCa", 23);
    freq.put("dia", 808);
    freq.put("dib", 41);
    freq.put("dic", 242);
    freq.put("dix", 17);
    freq.put("dit", 170);
    freq.put("diu", 226);
    freq.put("div", 101);
    freq.put("dip", 40);
    freq.put("diq", 7);
    freq.put("dir", 352);
    freq.put("dis", 332);
    freq.put("Gru", 16);
    freq.put(" Yo", 26);
    freq.put(" Ya", 11);
    freq.put(" Ye", 7);
    freq.put("Gre", 15);
    freq.put("Gra", 145);
    freq.put("zzz", 16);
    freq.put("tne", 10);
    freq.put("AM ", 8);
    freq.put("bo ", 88);
    freq.put("ión", 38);
    freq.put(" Y ", 18);
    freq.put("erm", 185);
    freq.put("diè", 9);
    freq.put("bor", 112);
    freq.put("bos", 23);
    freq.put("bot", 46);
    freq.put("bou", 13);
    freq.put("Wo", 21);
    freq.put("boj", 8);
    freq.put("bol", 127);
    freq.put("bom", 22);
    freq.put("bon", 313);
    freq.put("boo", 42);
    freq.put("boc", 12);
    freq.put("dió", 7);
    freq.put("oo ", 22);
    freq.put("ayo", 12);
    freq.put("aye", 23);
    freq.put("nyó", 11);
    freq.put("aya", 28);
    freq.put("ul ", 65);
    freq.put("ood", 21);
    freq.put("oog", 31);
    freq.put("Ben", 38);
    freq.put("Bel", 31);
    freq.put("ool", 25);
    freq.put("ooo", 75);
    freq.put("oon", 15);
    freq.put("ook", 46);
    freq.put("Bee", 7);
    freq.put("oot", 10);
    freq.put("oop", 30);
    freq.put("oor", 17);
    freq.put("Ber", 49);
    freq.put("Bes", 8);
    freq.put("Bet", 9);
    freq.put("aMo", 7);
    freq.put("uls", 34);
    freq.put("ulp", 45);
    freq.put("flu", 15);
    freq.put("ay ", 50);
    freq.put("ult", 232);
    freq.put("fli", 23);
    freq.put("uli", 78);
    freq.put("ulo", 10);
    freq.put("flo", 25);
    freq.put("ulm", 10);
    freq.put("fla", 28);
    freq.put("ula", 284);
    freq.put("fle", 29);
    freq.put("ulg", 29);
    freq.put("ule", 96);
    freq.put("Rod", 23);
    freq.put("ma ", 538);
    freq.put("rMa", 8);
    freq.put("nys", 303);
    freq.put("nyi", 27);
    freq.put("nyo", 246);
    freq.put("nym", 7);
    freq.put("nya", 732);
    freq.put("nye", 119);
    freq.put("Urd", 11);
    freq.put("map", 19);
    freq.put("mas", 126);
    freq.put("Urg", 12);
    freq.put("mau", 12);
    freq.put("mat", 580);
    freq.put("sna", 7);
    freq.put("sno", 17);
    freq.put("Uri", 9);
    freq.put("maa", 7);
    freq.put("mac", 105);
    freq.put("mad", 93);
    freq.put("mag", 87);
    freq.put("mai", 156);
    freq.put("maj", 36);
    freq.put("mam", 25);
    freq.put("mal", 228);
    freq.put("man", 647);
    freq.put("zna", 11);
    freq.put("Edi", 11);
    freq.put("q", 6429);
    freq.put("ulé", 7);
    freq.put("Lle", 72);
    freq.put("Edu", 29);
    freq.put("ny ", 247);
    freq.put("lsd", 8);
    freq.put("lse", 49);
    freq.put("lín", 22);
    freq.put("lsa", 31);
    freq.put("lso", 21);
    freq.put("lsm", 16);
    freq.put("lsi", 31);
    freq.put("lst", 8);
    freq.put(" ab", 157);
    freq.put(" ac", 481);
    freq.put(" ad", 130);
    freq.put(" ae", 19);
    freq.put(" af", 73);
    freq.put(" ag", 266);
    freq.put(" ah", 78);
    freq.put(" ai", 486);
    freq.put(" aj", 98);
    freq.put(" ak", 8);
    freq.put(" al", 2070);
    freq.put(" am", 1361);
    freq.put(" an", 941);
    freq.put(" ap", 283);
    freq.put(" aq", 593);
    freq.put(" ar", 543);
    freq.put(" as", 183);
    freq.put(" at", 153);
    freq.put(" au", 121);
    freq.put(" av", 359);
    freq.put("ls ", 2551);
    freq.put("orí", 7);
    freq.put("orç", 106);
    freq.put("Sho", 8);
    freq.put(" a ", 3805);
    freq.put("Víd", 10);
    freq.put("aTd", 21);
    freq.put("aTr", 8);
    freq.put("Lui", 7);
    freq.put("só ", 21);
    freq.put("Lun", 16);
    freq.put("orz", 12);
    freq.put("RT ", 2796);
    freq.put("G", 1449);
    freq.put("ort", 902);
    freq.put("oru", 20);
    freq.put("orr", 322);
    freq.put("ors", 327);
    freq.put("orp", 31);
    freq.put("orq", 22);
    freq.put("orn", 293);
    freq.put("oro", 59);
    freq.put("orl", 14);
    freq.put("orm", 283);
    freq.put("ork", 17);
    freq.put("ori", 328);
    freq.put("orf", 12);
    freq.put("org", 77);
    freq.put("ord", 555);
    freq.put("ore", 229);
    freq.put("orb", 15);
    freq.put("orc", 102);
    freq.put("sóc", 52);
    freq.put("ora", 505);
    freq.put("Apr", 16);
    freq.put("App", 11);
    freq.put("orM", 9);
    freq.put("Apo", 28);
    freq.put("Apa", 17);
    freq.put("lay", 22);
    freq.put("rís", 20);
    freq.put("rít", 13);
    freq.put("ríc", 7);
    freq.put("ríe", 19);
    freq.put("rín", 12);
    freq.put("Dé", 14);
    freq.put("PV ", 18);
    freq.put("núv", 16);
    freq.put("gèn", 26);
    freq.put("IS ", 18);
    freq.put("éu ", 31);
    freq.put("Dn", 8);
    freq.put("Do", 143);
    freq.put("Dl", 7);
    freq.put("Dm", 7);
    freq.put("Dj", 11);
    freq.put("Di", 333);
    freq.put("Dg", 9);
    freq.put("De", 451);
    freq.put("Dc", 10);
    freq.put("Da", 129);
    freq.put("Dx", 11);
    freq.put("Dv", 7);
    freq.put("Dw", 8);
    freq.put("Du", 43);
    freq.put("Dr", 35);
    freq.put("Ds", 9);
    freq.put("Dq", 7);
    freq.put("laP", 8);
    freq.put("D ", 267);
    freq.put("vel", 109);
    freq.put("ge ", 243);
    freq.put("lí ", 8);
    freq.put("Wg", 9);
    freq.put("Wf", 9);
    freq.put("We", 88);
    freq.put("Wb", 10);
    freq.put("Wa", 26);
    freq.put("HA ", 10);
    freq.put("Wl", 10);
    freq.put("Wj", 9);
    freq.put("Wi", 28);
    freq.put("Wh", 12);
    freq.put("Ww", 7);
    freq.put("Wv", 7);
    freq.put("Wu", 7);
    freq.put("Wt", 8);
    freq.put("Wy", 8);
    freq.put("ges", 147);
    freq.put("ger", 141);
    freq.put("get", 24);
    freq.put("lít", 74);
    freq.put("uta", 288);
    freq.put("geg", 10);
    freq.put("lím", 14);
    freq.put("gee", 7);
    freq.put("tuï", 21);
    freq.put("gei", 34);
    freq.put("líc", 22);
    freq.put("líd", 10);
    freq.put("gen", 333);
    freq.put("gem", 43);
    freq.put("gel", 89);
    freq.put("W ", 69);
    freq.put("ó", 2080);
    freq.put("tu ", 178);
    freq.put("j ", 106);
    freq.put("FO ", 7);
    freq.put("tur", 420);
    freq.put("tus", 24);
    freq.put("jx", 10);
    freq.put("ju", 555);
    freq.put("jv", 13);
    freq.put("jw", 9);
    freq.put("jp", 14);
    freq.put("jr", 15);
    freq.put("js", 18);
    freq.put("jl", 14);
    freq.put("jm", 30);
    freq.put("jo", 939);
    freq.put("tul", 26);
    freq.put("ji", 45);
    freq.put("jj", 25);
    freq.put("jk", 13);
    freq.put("jd", 9);
    freq.put("je", 185);
    freq.put("jf", 8);
    freq.put("jg", 13);
    freq.put("tud", 138);
    freq.put("ja", 1284);
    freq.put("jb", 7);
    freq.put("jc", 15);
    freq.put("jX", 8);
    freq.put("jY", 9);
    freq.put("tui", 48);
    freq.put("jV", 7);
    freq.put("jP", 8);
    freq.put("jR", 8);
    freq.put("jN", 12);
    freq.put("jO", 9);
    freq.put("jJ", 12);
    freq.put("jD", 7);
    freq.put("jF", 11);
    freq.put("jA", 8);
    freq.put("jC", 10);
    freq.put("tun", 26);
    freq.put("tua", 102);
    freq.put("tub", 22);
    freq.put("pañ", 19);
    freq.put("tuc", 26);
    freq.put("tue", 32);
    freq.put("tug", 8);
    freq.put("paí", 55);
    freq.put("paï", 9);
    freq.put("naI", 10);
    freq.put("É", 115);
    freq.put("bmi", 15);
    freq.put("iRo", 14);
    freq.put("naR", 10);
    freq.put("naP", 10);
    freq.put("mòr", 11);
    freq.put("mòb", 20);
    freq.put("oi ", 70);
    freq.put("pap", 30);
    freq.put("par", 1010);
    freq.put("pas", 342);
    freq.put("pat", 182);
    freq.put("pau", 54);
    freq.put("pab", 13);
    freq.put("pac", 102);
    freq.put("pad", 40);
    freq.put("pae", 15);
    freq.put("pag", 104);
    freq.put("pai", 75);
    freq.put("pal", 93);
    freq.put("pam", 27);
    freq.put("pan", 488);
    freq.put("àme", 18);
    freq.put("Bcn", 25);
    freq.put("nac", 186);
    freq.put("oig", 36);
    freq.put("oie", 22);
    freq.put("oid", 14);
    freq.put("oic", 22);
    freq.put("àmi", 8);
    freq.put("oia", 23);
    freq.put("oix", 21);
    freq.put("ois", 23);
    freq.put("oir", 17);
    freq.put("pa ", 227);
    freq.put("ujo", 25);
    freq.put("uje", 9);
    freq.put("uja", 56);
    freq.put("mo ", 64);
    freq.put(" cà", 30);
    freq.put(" cò", 7);
    freq.put(" có", 13);
    freq.put("mos", 139);
    freq.put("mor", 234);
    freq.put("ímp", 7);
    freq.put("mou", 21);
    freq.put("mot", 52);
    freq.put("ími", 17);
    freq.put("mon", 250);
    freq.put("mom", 71);
    freq.put("ixó", 8);
    freq.put("moc", 86);
    freq.put("mob", 30);
    freq.put("mog", 13);
    freq.put("mod", 62);
    freq.put("úni", 37);
    freq.put("Ebr", 11);
    freq.put("iç ", 31);
    freq.put("pòs", 7);
    freq.put("Neg", 22);
    freq.put("Nec", 15);
    freq.put("ptu", 19);
    freq.put("Ney", 13);
    freq.put("New", 13);
    freq.put("Neu", 14);
    freq.put("Med", 21);
    freq.put("Meg", 11);
    freq.put(" ci", 256);
    freq.put(" cn", 10);
    freq.put(" co", 5525);
    freq.put(" cl", 275);
    freq.put(" cm", 7);
    freq.put(" cc", 52);
    freq.put("Men", 43);
    freq.put(" ce", 277);
    freq.put("Met", 13);
    freq.put("Mes", 86);
    freq.put("Mer", 68);
    freq.put(" cr", 417);
    freq.put(" cp", 7);
    freq.put(" cu", 262);
    freq.put("Dra", 8);
    freq.put("Dre", 13);
    freq.put("Me ", 19);
    freq.put("km ", 23);
    freq.put(" c ", 57);
    freq.put("sAl", 7);
    freq.put("dvo", 15);
    freq.put("e", 72428);
    freq.put("Avu", 211);
    freq.put("svi", 20);
    freq.put("Ai", 171);
    freq.put("Avi", 15);
    freq.put("Ah", 41);
    freq.put("utè", 8);
    freq.put("sve", 14);
    freq.put("dva", 14);
    freq.put("Ó ", 35);
    freq.put("utò", 10);
    freq.put("FP ", 7);
    freq.put("ús ", 22);
    freq.put("GC ", 10);
    freq.put("èfi", 11);
    freq.put("úst", 7);
    freq.put("ú", 511);
    freq.put("US ", 15);
    freq.put("zqu", 9);
    freq.put("u", 25306);
    freq.put("úsi", 28);
    freq.put("Vai", 12);
    freq.put("Van", 36);
    freq.put("Val", 214);
    freq.put("iu ", 457);
    freq.put("gs", 46);
    freq.put("gr", 1139);
    freq.put("ws ", 18);
    freq.put("ium", 96);
    freq.put("iul", 48);
    freq.put("Va ", 26);
    freq.put("iue", 64);
    freq.put("iud", 14);
    freq.put("TA ", 41);
    freq.put("aja", 327);
    freq.put("ius", 133);
    freq.put("iur", 106);
    freq.put("iut", 87);
    freq.put("iuv", 7);
    freq.put("dús", 10);
    freq.put("SI ", 35);
    freq.put("gb", 21);
    freq.put("gg ", 7);
    freq.put("ça ", 491);
    freq.put("aba", 303);
    freq.put("abc", 10);
    freq.put("abe", 165);
    freq.put("abi", 96);
    freq.put("abl", 145);
    freq.put("abo", 115);
    freq.put("abr", 129);
    freq.put("abs", 28);
    freq.put("abt", 63);
    freq.put("abu", 27);
    freq.put("gh", 33);
    freq.put("M€ ", 11);
    freq.put("Nom", 31);
    freq.put("K", 377);
    freq.put("çat", 26);
    freq.put("çar", 54);
    freq.put("çan", 18);
    freq.put("çam", 16);
    freq.put("çad", 36);
    freq.put("çab", 11);
    freq.put("ab ", 22);
    freq.put("à", 2388);
    freq.put("qüe", 10);
    freq.put("ntm", 11);
    freq.put("uEs", 7);
    freq.put("Ràd", 11);
    freq.put("twe", 38);
    freq.put("twi", 119);
    freq.put("eym", 13);
    freq.put("LT ", 11);
    freq.put("de ", 5301);
    freq.put("FM ", 17);
    freq.put("OU ", 7);
    freq.put("deM", 8);
    freq.put("dex", 10);
    freq.put("ey ", 26);
    freq.put("dez", 22);
    freq.put("dep", 230);
    freq.put("der", 274);
    freq.put("des", 1028);
    freq.put("det", 85);
    freq.put("deu", 220);
    freq.put("dev", 38);
    freq.put("dei", 208);
    freq.put("dej", 15);
    freq.put("del", 1969);
    freq.put("dem", 377);
    freq.put("den", 337);
    freq.put("deo", 86);
    freq.put("sGa", 7);
    freq.put("dea", 37);
    freq.put("deb", 61);
    freq.put("dec", 116);
    freq.put("ded", 52);
    freq.put("dee", 14);
    freq.put("def", 96);
    freq.put("deg", 29);
    freq.put("iPa", 8);
    freq.put("xèr", 7);
    freq.put("csd", 15);
    freq.put("iPo", 7);
    freq.put("Don", 71);
    freq.put("Dol", 13);
    freq.put("Dom", 9);
    freq.put("Doc", 16);
    freq.put("Dor", 8);
    freq.put("Dos", 10);
    freq.put("cs ", 378);
    freq.put("ry ", 23);
    freq.put("çò ", 9);
    freq.put("èdi", 26);
    freq.put("ok ", 45);
    freq.put("pci", 61);
    freq.put("pca", 13);
    freq.put("Bat", 21);
    freq.put("Bau", 9);
    freq.put("Bar", 527);
    freq.put("Bas", 22);
    freq.put("Bay", 13);
    freq.put("Bag", 8);
    freq.put("Bad", 23);
    freq.put("oke", 9);
    freq.put("Ban", 25);
    freq.put("Bal", 46);
    freq.put("okl", 14);
    freq.put("Bai", 10);
    freq.put("oin", 19);
    freq.put("Un ", 149);
    freq.put("mm ", 21);
    freq.put("E ", 374);
    freq.put("mmm", 20);
    freq.put("Una", 93);
    freq.put("mmo", 13);
    freq.put("sba", 19);
    freq.put("mmi", 16);
    freq.put("mme", 27);
    freq.put("Uni", 56);
    freq.put("mma", 53);
    freq.put("sbo", 16);
    freq.put("Em", 94);
    freq.put("El", 972);
    freq.put("Eo", 8);
    freq.put("En", 356);
    freq.put("Ei", 56);
    freq.put("Eh", 18);
    freq.put("Ej", 14);
    freq.put("Ed", 49);
    freq.put("Eg", 12);
    freq.put("Ef", 7);
    freq.put("Ea", 10);
    freq.put("Ec", 22);
    freq.put("XL ", 9);
    freq.put("últ", 57);
    freq.put("Ey", 8);
    freq.put("Ex", 55);
    freq.put("Ez", 10);
    freq.put("Eu", 71);
    freq.put("Et", 45);
    freq.put("Ew", 7);
    freq.put("Ev", 20);
    freq.put("Eq", 24);
    freq.put("Ep", 18);
    freq.put("Es", 730);
    freq.put("Er", 39);
    freq.put("gó", 18);
    freq.put(" el", 3614);
    freq.put(" em", 431);
    freq.put(" en", 2161);
    freq.put(" eh", 38);
    freq.put(" ei", 43);
    freq.put("kon", 13);
    freq.put(" ed", 104);
    freq.put(" ee", 10);
    freq.put("X ", 107);
    freq.put(" eg", 12);
    freq.put(" ec", 54);
    freq.put("ït ", 16);
    freq.put("koz", 12);
    freq.put(" ex", 390);
    freq.put(" et", 241);
    freq.put(" eu", 91);
    freq.put(" ev", 32);
    freq.put("kor", 7);
    freq.put(" ep", 24);
    freq.put(" eq", 87);
    freq.put(" er", 155);
    freq.put(" es", 2433);
    freq.put("zg", 13);
    freq.put("gú", 92);
    freq.put("vía", 45);
    freq.put("Xj", 8);
    freq.put("b", 8890);
    freq.put("Xn", 8);
    freq.put("Xo", 11);
    freq.put("ko ", 8);
    freq.put("Xa", 120);
    freq.put(" e ", 71);
    freq.put("Xe", 17);
    freq.put("Xz", 9);
    freq.put("Xy", 7);
    freq.put("Xt", 7);
    freq.put("Xu", 12);
    freq.put("nàs", 8);
    freq.put("nàr", 14);
    freq.put("gí", 7);
    freq.put("k ", 312);
    freq.put("kB", 9);
    freq.put("Ate", 25);
    freq.put("kG", 9);
    freq.put("kK", 8);
    freq.put("Atl", 18);
    freq.put("kH", 7);
    freq.put("kO", 7);
    freq.put("kN", 8);
    freq.put("kM", 7);
    freq.put("kR", 8);
    freq.put("kP", 7);
    freq.put("kT", 8);
    freq.put("kc", 18);
    freq.put("kb", 14);
    freq.put("ka", 100);
    freq.put("kf", 24);
    freq.put("ke", 126);
    freq.put("kk", 19);
    freq.put("ki", 136);
    freq.put("zK", 7);
    freq.put("ko", 92);
    freq.put("kn", 16);
    freq.put("km", 30);
    freq.put("kl", 30);
    freq.put("ks", 50);
    freq.put("kr", 26);
    freq.put("kq", 9);
    freq.put("kp", 14);
    freq.put("kv", 9);
    freq.put("ku", 31);
    freq.put("kt", 15);
    freq.put("ky", 29);
    freq.put(" Bé", 14);
    freq.put("rés", 130);
    freq.put("réi", 9);
    freq.put("Ope", 8);
    freq.put("ré ", 109);
    freq.put(" Be", 132);
    freq.put(" Ba", 585);
    freq.put(" Bc", 19);
    freq.put(" Bl", 47);
    freq.put(" Bo", 253);
    freq.put(" Bi", 48);
    freq.put(" Bu", 77);
    freq.put("ik ", 13);
    freq.put(" Br", 59);
    freq.put("pn", 21);
    freq.put("DD ", 19);
    freq.put(" B ", 56);
    freq.put("éix", 10);
    freq.put("ika", 19);
    freq.put(" €", 68);
    freq.put("ike", 19);
    freq.put("iki", 26);
    freq.put("iko", 15);
    freq.put("TC ", 7);
    freq.put("lbu", 15);
    freq.put("ga ", 340);
    freq.put("lés", 21);
    freq.put("gav", 9);
    freq.put("gau", 57);
    freq.put("gat", 154);
    freq.put("gas", 71);
    freq.put("gar", 265);
    freq.put("gan", 187);
    freq.put("gam", 35);
    freq.put("gal", 140);
    freq.put("gai", 34);
    freq.put("gag", 14);
    freq.put("gaf", 43);
    freq.put("gad", 149);
    freq.put("gac", 15);
    freq.put("gab", 7);
    freq.put("lba", 88);
    freq.put("fut", 114);
    freq.put("fur", 21);
    freq.put("fus", 28);
    freq.put("fug", 10);
    freq.put("fue", 16);
    freq.put("fun", 45);
    freq.put("lbe", 122);
    freq.put("ful", 15);
    freq.put("fum", 15);
    freq.put("dg ", 8);
    freq.put("sy ", 7);
    freq.put("raz", 7);
    freq.put("ews", 11);
    freq.put("dga", 12);
    freq.put("mov", 16);
    freq.put("ew ", 12);
    freq.put("y", 2909);
    freq.put("gol", 63);
    freq.put("lda", 17);
    freq.put("çó", 28);
    freq.put("çò", 9);
    freq.put("lde", 108);
    freq.put("ldi", 31);
    freq.put("mol", 610);
    freq.put("ldo", 22);
    freq.put("bi ", 45);
    freq.put("ldr", 26);
    freq.put("ldu", 7);
    freq.put("cut", 42);
    freq.put("cus", 38);
    freq.put("cur", 132);
    freq.put("cup", 89);
    freq.put("cug", 10);
    freq.put("rga", 90);
    freq.put("cue", 12);
    freq.put("cud", 16);
    freq.put("rge", 71);
    freq.put("cua", 20);
    freq.put("rgi", 94);
    freq.put("cum", 36);
    freq.put("cul", 272);
    freq.put("cui", 45);
    freq.put("rgo", 41);
    freq.put("Dil", 8);
    freq.put("Dim", 17);
    freq.put("bil", 122);
    freq.put("ld ", 13);
    freq.put("Dij", 10);
    freq.put("Die", 14);
    freq.put("bid", 16);
    freq.put("Dig", 25);
    freq.put("bib", 26);
    freq.put("bic", 25);
    freq.put("bia", 48);
    freq.put("AL ", 50);
    freq.put("Diu", 31);
    freq.put("Div", 30);
    freq.put("bir", 50);
    freq.put("bis", 16);
    freq.put("Dir", 36);
    freq.put("Dis", 39);
    freq.put("rg ", 36);
    freq.put("cu ", 29);
    freq.put("zlo", 12);
    freq.put("aCa", 39);
    freq.put("uf ", 10);
    freq.put("ldé", 10);
    freq.put("aCo", 16);
    freq.put("ça", 695);
    freq.put("ço", 47);
    freq.put("oe ", 7);
    freq.put("pez", 35);
    freq.put("pet", 144);
    freq.put("peu", 45);
    freq.put("pep", 36);
    freq.put("ak", 99);
    freq.put("pes", 64);
    freq.put("pel", 330);
    freq.put("pen", 452);
    freq.put("pei", 16);
    freq.put("rgè", 13);
    freq.put("ape", 100);
    freq.put("pea", 22);
    freq.put("pec", 120);
    freq.put("ufe", 8);
    freq.put("àqu", 9);
    freq.put("ufo", 17);
    freq.put("oes", 39);
    freq.put("ufa", 19);
    freq.put("Bor", 30);
    freq.put("Bos", 19);
    freq.put("use", 68);
    freq.put("O", 804);
    freq.put("oet", 15);
    freq.put("Boi", 15);
    freq.put("Bol", 10);
    freq.put("Bom", 9);
    freq.put("Bon", 177);
    freq.put("Boo", 7);
    freq.put("Boa", 10);
    freq.put("usb", 7);
    freq.put("usa", 73);
    freq.put("uso", 17);
    freq.put("pe ", 77);
    freq.put("nsi", 93);
    freq.put("fem", 73);
    freq.put("nsl", 12);
    freq.put("nsm", 18);
    freq.put("nso", 64);
    freq.put("nsa", 260);
    freq.put("nsc", 44);
    freq.put("mí ", 23);
    freq.put("nse", 349);
    freq.put("nsf", 10);
    freq.put("ròx", 10);
    freq.put("nsp", 42);
    freq.put("nsr", 18);
    freq.put("nst", 154);
    freq.put("nsu", 97);
    freq.put("nsv", 7);
    freq.put("ròp", 7);
    freq.put("mko", 9);
    freq.put("nsC", 11);
    freq.put("usu", 18);
    freq.put("gó ", 16);
    freq.put("ust", 188);
    freq.put("uss", 44);
    freq.put(" R ", 45);
    freq.put("ns ", 1851);
    freq.put("rò ", 390);
    freq.put("sde", 99);
    freq.put("Flo", 12);
    freq.put("sdo", 10);
    freq.put("sdi", 12);
    freq.put("Map", 8);
    freq.put("Mas", 127);
    freq.put("Mar", 332);
    freq.put("Mau", 8);
    freq.put("Mat", 65);
    freq.put("May", 8);
    freq.put("Mac", 16);
    freq.put(" ge", 359);
    freq.put(" gc", 7);
    freq.put("Mag", 18);
    freq.put(" ga", 242);
    freq.put("Mai", 22);
    freq.put(" go", 196);
    freq.put(" gl", 24);
    freq.put("Maj", 21);
    freq.put("Mal", 64);
    freq.put(" gi", 64);
    freq.put(" ch", 48);
    freq.put("ly ", 17);
    freq.put(" g ", 19);
    freq.put("Mel", 10);
    freq.put("xbe", 7);
    freq.put(" b", 1804);
    freq.put(" c", 9491);
    freq.put(" a", 12298);
    freq.put(" f", 3507);
    freq.put(" g", 1802);
    freq.put(" d", 12982);
    freq.put(" e", 10089);
    freq.put(" j", 1682);
    freq.put(" k", 238);
    freq.put(" h", 6492);
    freq.put(" i", 4571);
    freq.put(" n", 3709);
    freq.put(" o", 1308);
    freq.put(" l", 7836);
    freq.put(" m", 6110);
    freq.put(" r", 2286);
    freq.put(" s", 5852);
    freq.put(" p", 8581);
    freq.put(" q", 3996);
    freq.put(" v", 3350);
    freq.put(" w", 244);
    freq.put(" t", 7805);
    freq.put(" u", 2602);
    freq.put(" z", 134);
    freq.put(" x", 711);
    freq.put(" y", 181);
    freq.put(" B", 1543);
    freq.put(" C", 2704);
    freq.put(" A", 3160);
    freq.put(" F", 1234);
    freq.put(" G", 1139);
    freq.put(" D", 1483);
    freq.put(" E", 2767);
    freq.put(" J", 996);
    freq.put(" K", 195);
    freq.put(" H", 644);
    freq.put(" I", 1003);
    freq.put(" N", 1084);
    freq.put(" O", 562);
    freq.put(" L", 1729);
    freq.put(" M", 2246);
    freq.put(" R", 3849);
    freq.put(" S", 2043);
    freq.put(" P", 2316);
    freq.put(" Q", 622);
    freq.put(" V", 1075);
    freq.put(" W", 202);
    freq.put(" T", 1478);
    freq.put(" U", 684);
    freq.put(" Z", 121);
    freq.put(" X", 369);
    freq.put(" Y", 162);
    freq.put("Azn", 11);
    freq.put("vlc", 8);
    freq.put("Azu", 17);
    freq.put("sé ", 72);
    freq.put(" à", 49);
    freq.put(" è", 61);
    freq.put(" é", 973);
    freq.put(" í", 7);
    freq.put(" ò", 12);
    freq.put(" ú", 102);
    freq.put(" À", 34);
    freq.put("Ort", 10);
    freq.put(" É", 114);
    freq.put(" Ò", 8);
    freq.put("Ori", 37);
    freq.put(" Ú", 17);
    freq.put("Org", 11);
    freq.put(" ¡", 12);
    freq.put("och", 15);
    freq.put("IU ", 17);
    freq.put("òv", 7);
    freq.put(" º", 48);
    freq.put(" ¿", 8);
    freq.put("oco", 41);
    freq.put(" Do", 129);
    freq.put("Veu", 9);
    freq.put("Ver", 33);
    freq.put(" Di", 288);
    freq.put("òx", 12);
    freq.put(" De", 392);
    freq.put(" Da", 110);
    freq.put("Veg", 14);
    freq.put("ii ", 48);
    freq.put("tà ", 182);
    freq.put("Ven", 35);
    freq.put(" Du", 36);
    freq.put(" Dr", 27);
    freq.put("Vei", 13);
    freq.put("Fp", 8);
    freq.put("cha", 50);
    freq.put("Fr", 115);
    freq.put("afè", 20);
    freq.put("che", 82);
    freq.put("Fx", 7);
    freq.put("chi", 44);
    freq.put("Fz", 8);
    freq.put("cho", 40);
    freq.put("Fa", 198);
    freq.put("Fb", 7);
    freq.put("chu", 10);
    freq.put("Ff", 7);
    freq.put("Fh", 7);
    freq.put("Fi", 148);
    freq.put("Fj", 9);
    freq.put("Fl", 27);
    freq.put("Fm", 7);
    freq.put("Fn", 9);
    freq.put("Fo", 140);
    freq.put("iit", 9);
    freq.put("tàs", 40);
    freq.put("tàr", 28);
    freq.put("iis", 10);
    freq.put(" D ", 113);
    freq.put("iia", 8);
    freq.put("tàn", 25);
    freq.put("iin", 12);
    freq.put("iii", 73);
    freq.put("ocs", 54);
    freq.put("ÇA ", 15);
    freq.put("ch ", 109);
    freq.put("f", 6447);
    freq.put("F ", 186);
    freq.put(" Dé", 14);
    freq.put("tac", 244);
    freq.put("Yi", 13);
    freq.put("afm", 8);
    freq.put("Fò", 7);
    freq.put("afo", 52);
    freq.put("Ym", 9);
    freq.put("afi", 69);
    freq.put("Yo", 31);
    freq.put("Ya", 17);
    freq.put("afe", 87);
    freq.put("Ye", 12);
    freq.put("Yd", 9);
    freq.put("Yf", 9);
    freq.put("Fà", 9);
    freq.put("afu", 18);
    freq.put("Ys", 9);
    freq.put("Yu", 8);
    freq.put("Yw", 8);
    freq.put("Yv", 12);
    freq.put("Y ", 101);
    freq.put("af ", 15);
    freq.put("xq ", 12);
    freq.put("lF", 17);
    freq.put("lG", 13);
    freq.put("lD", 21);
    freq.put("lE", 9);
    freq.put("lB", 15);
    freq.put("lC", 43);
    freq.put("lA", 27);
    freq.put("lN", 10);
    freq.put("lO", 9);
    freq.put("lL", 15);
    freq.put("lM", 16);
    freq.put("lJ", 7);
    freq.put("bje", 29);
    freq.put("lH", 9);
    freq.put("euB", 9);
    freq.put("lV", 12);
    freq.put("lT", 20);
    freq.put("lR", 19);
    freq.put("lS", 26);
    freq.put("lP", 26);
    freq.put("lX", 8);
    freq.put("lf", 86);
    freq.put("eul", 8);
    freq.put("ld", 254);
    freq.put("eun", 27);
    freq.put("lb", 282);
    freq.put("lc", 231);
    freq.put("tsh", 7);
    freq.put("la", 7730);
    freq.put("eue", 32);
    freq.put("eud", 11);
    freq.put("ll", 3591);
    freq.put("euf", 9);
    freq.put("eua", 35);
    freq.put("lk", 33);
    freq.put("lh", 27);
    freq.put("eub", 7);
    freq.put("lv", 242);
    freq.put("lw", 15);
    freq.put("lt", 1706);
    freq.put("lu", 981);
    freq.put("lr", 48);
    freq.put("ls", 2788);
    freq.put("lp", 165);
    freq.put("lq", 19);
    freq.put("nTa", 13);
    freq.put("eut", 33);
    freq.put("lz", 33);
    freq.put("tss", 7);
    freq.put("lx", 16);
    freq.put("ly", 46);
    freq.put("dad", 59);
    freq.put("dag", 13);
    freq.put("daa", 10);
    freq.put("dab", 18);
    freq.put("dac", 46);
    freq.put("dal", 201);
    freq.put("dam", 51);
    freq.put("dan", 139);
    freq.put("taC", 8);
    freq.put("dat", 147);
    freq.put("dau", 7);
    freq.put("dav", 109);
    freq.put("dap", 10);
    freq.put("dar", 228);
    freq.put("das", 27);
    freq.put("arç", 275);
    freq.put("què", 294);
    freq.put("quí", 159);
    freq.put("day", 11);
    freq.put("l ", 10630);
    freq.put("Nz", 8);
    freq.put("ts ", 2091);
    freq.put("emm", 36);
    freq.put("eml", 8);
    freq.put("emo", 146);
    freq.put("emn", 16);
    freq.put("lfa", 11);
    freq.put("emi", 131);
    freq.put("lfo", 28);
    freq.put("qu ", 8);
    freq.put("lfr", 12);
    freq.put("rez", 45);
    freq.put("emu", 14);
    freq.put("rex", 9);
    freq.put("rey", 8);
    freq.put("là", 349);
    freq.put("lá", 8);
    freq.put("rer", 261);
    freq.put("res", 1938);
    freq.put("Tur", 11);
    freq.put("req", 13);
    freq.put("rev", 137);
    freq.put("º", 51);
    freq.put("ret", 402);
    freq.put("reu", 369);
    freq.put("rej", 16);
    freq.put("rei", 303);
    freq.put("ren", 570);
    freq.put("reo", 27);
    freq.put("rel", 166);
    freq.put("rem", 535);
    freq.put("reb", 196);
    freq.put("rec", 572);
    freq.put("Tub", 18);
    freq.put("rea", 182);
    freq.put("ref", 138);
    freq.put("reg", 303);
    freq.put("red", 201);
    freq.put("ree", 26);
    freq.put("lf ", 9);
    freq.put("qua", 386);
    freq.put("que", 3975);
    freq.put("qui", 627);
    freq.put("quo", 13);
    freq.put("her", 102);
    freq.put("l·", 110);
    freq.put("l´", 7);
    freq.put("dó ", 21);
    freq.put("Tu ", 20);
    freq.put("re ", 1706);
    freq.put("aAl", 16);
    freq.put("ud ", 41);
    freq.put("às ", 125);
    freq.put("Paí", 37);
    freq.put("Paï", 9);
    freq.put("nuv", 16);
    freq.put("udu", 11);
    freq.put("ogu", 64);
    freq.put("àss", 15);
    freq.put("àst", 58);
    freq.put("ogr", 104);
    freq.put("ogl", 31);
    freq.put("ogo", 15);
    freq.put("àsi", 10);
    freq.put("ogi", 37);
    freq.put("udg", 7);
    freq.put("ude", 81);
    freq.put("oge", 46);
    freq.put("udi", 223);
    freq.put("oga", 37);
    freq.put("udo", 15);
    freq.put("nun", 87);
    freq.put("heh", 12);
    freq.put("tòn", 20);
    freq.put("nul", 7);
    freq.put("Pap", 7);
    freq.put("Par", 131);
    freq.put("Pas", 42);
    freq.put("Pat", 19);
    freq.put("Pau", 37);
    freq.put("nqu", 147);
    freq.put("Pac", 24);
    freq.put("Pad", 8);
    freq.put("Pag", 10);
    freq.put("Pal", 65);
    freq.put("Pan", 14);
    freq.put("mik", 10);
    freq.put("mil", 311);
    freq.put("min", 295);
    freq.put("mia", 95);
    freq.put("mic", 215);
    freq.put("mie", 20);
    freq.put("mid", 10);
    freq.put("mig", 94);
    freq.put("miq", 46);
    freq.put("mip", 7);
    freq.put("mis", 193);
    freq.put("mir", 206);
    freq.put("mit", 150);
    freq.put("sfr", 41);
    freq.put("Pa ", 12);
    freq.put("sfo", 32);
    freq.put("sfi", 9);
    freq.put("sfe", 31);
    freq.put("sfa", 8);
    freq.put("mus", 81);
    freq.put("mi ", 157);
    freq.put("ç ", 98);
    freq.put(" iP", 11);
    freq.put(" iN", 7);
    freq.put(" ix", 7);
    freq.put(" ip", 11);
    freq.put("Mor", 53);
    freq.put(" ir", 36);
    freq.put(" is", 35);
    freq.put(" it", 22);
    freq.put(" iu", 8);
    freq.put(" iv", 12);
    freq.put("Mot", 12);
    freq.put(" il", 62);
    freq.put(" im", 249);
    freq.put("ksc", 7);
    freq.put("Mol", 157);
    freq.put(" ia", 26);
    freq.put(" ib", 15);
    freq.put(" ic", 10);
    freq.put(" id", 64);
    freq.put(" if", 13);
    freq.put(" ig", 91);
    freq.put("xdd", 7);
    freq.put("ks ", 18);
    freq.put(" i ", 2815);
    freq.put("wd", 7);
    freq.put("wa", 55);
    freq.put(" Ir", 25);
    freq.put("wl", 12);
    freq.put("Km ", 8);
    freq.put("wk", 11);
    freq.put("S", 2402);
    freq.put(" Iv", 14);
    freq.put("è", 1242);
    freq.put("dú", 13);
    freq.put(" Im", 44);
    freq.put("aa", 408);
    freq.put(" Fò", 7);
    freq.put("uic", 28);
    freq.put(" Fà", 8);
    freq.put("oho", 11);
    freq.put("uie", 20);
    freq.put("ohi", 25);
    freq.put("ixu", 8);
    freq.put("uig", 66);
    freq.put("ock", 39);
    freq.put("ys ", 294);
    freq.put("wz", 8);
    freq.put("ohe", 12);
    freq.put(" in", 981);
    freq.put("Hol", 27);
    freq.put("OL ", 15);
    freq.put("Hom", 9);
    freq.put("uim", 118);
    freq.put("ànd", 12);
    freq.put("cor", 344);
    freq.put("cou", 7);
    freq.put("uin", 364);
    freq.put("cot", 71);
    freq.put("mín", 26);
    freq.put("uip", 89);
    freq.put("cov", 8);
    freq.put("as", 2607);
    freq.put("uir", 145);
    freq.put("au", 1084);
    freq.put("Hos", 37);
    freq.put(" Fr", 96);
    freq.put(" Fu", 45);
    freq.put("uiv", 9);
    freq.put(" Fa", 156);
    freq.put(" Fe", 219);
    freq.put("uix", 38);
    freq.put(" Fi", 124);
    freq.put(" Fl", 20);
    freq.put(" Fo", 118);
    freq.put("io ", 281);
    freq.put("coa", 14);
    freq.put("uiz", 11);
    freq.put("coc", 18);
    freq.put("wT", 7);
    freq.put("lCa", 12);
    freq.put("cod", 26);
    freq.put("iov", 9);
    freq.put("emò", 15);
    freq.put("ios", 75);
    freq.put("ior", 60);
    freq.put("Cav", 8);
    freq.put(" F ", 53);
    freq.put("iom", 22);
    freq.put("iol", 148);
    freq.put("ioe", 8);
    freq.put("iod", 77);
    freq.put("ioc", 16);
    freq.put("iob", 9);
    freq.put("GA ", 8);
    freq.put("tix", 7);
    freq.put("rMo", 7);
    freq.put("con", 1124);
    freq.put("fy ", 7);
    freq.put("adv", 16);
    freq.put("adu", 48);
    freq.put("esó", 15);
    freq.put("çó ", 28);
    freq.put("gma", 8);
    freq.put("gme", 20);
    freq.put("add", 11);
    freq.put("ade", 554);
    freq.put("ada", 1058);
    freq.put("adn", 8);
    freq.put("ado", 345);
    freq.put("adm", 28);
    freq.put("ços", 15);
    freq.put("adi", 171);
    freq.put(" mv", 7);
    freq.put("ad ", 64);
    freq.put("nja", 58);
    freq.put("esP", 13);
    freq.put("njo", 25);
    freq.put("esF", 7);
    freq.put("esC", 18);
    freq.put("esB", 8);
    freq.put("esA", 12);
    freq.put("esJ", 7);
    freq.put("esv", 26);
    freq.put("esu", 94);
    freq.put("est", 2229);
    freq.put("ess", 500);
    freq.put("esq", 67);
    freq.put("esp", 883);
    freq.put("esg", 26);
    freq.put("esf", 35);
    freq.put("ese", 235);
    freq.put("esd", 50);
    freq.put("esc", 540);
    freq.put("esb", 18);
    freq.put("esa", 301);
    freq.put("eso", 106);
    freq.put("esn", 10);
    freq.put("esm", 60);
    freq.put("esl", 11);
    freq.put("esk", 20);
    freq.put("esi", 205);
    freq.put("esh", 10);
    freq.put("dca", 16);
    freq.put("OS ", 29);
    freq.put("es ", 6462);
    freq.put("Twi", 48);
    freq.put("mú ", 10);
    freq.put("De ", 78);
    freq.put("pió", 7);
    freq.put("rcB", 8);
    freq.put("rcu", 29);
    freq.put("rcs", 10);
    freq.put("rcl", 10);
    freq.put("rco", 40);
    freq.put("rch", 16);
    freq.put("rci", 109);
    freq.put("rcd", 11);
    freq.put("rce", 363);
    freq.put("rca", 271);
    freq.put("rcb", 14);
    freq.put("rcc", 8);
    freq.put("mús", 23);
    freq.put("bur", 25);
    freq.put("bus", 81);
    freq.put("Des", 126);
    freq.put("Det", 7);
    freq.put("Deu", 10);
    freq.put("but", 37);
    freq.put("Dei", 9);
    freq.put("bui", 28);
    freq.put("bun", 13);
    freq.put("Dem", 93);
    freq.put("bul", 24);
    freq.put("bum", 13);
    freq.put("buc", 11);
    freq.put("Dec", 15);
    freq.put("buf", 16);
    freq.put("bue", 20);
    freq.put("Iva", 9);
    freq.put("j", 3576);
    freq.put("rc ", 75);
    freq.put("pij", 8);
    freq.put("pil", 50);
    freq.put("pin", 94);
    freq.put("pio", 45);
    freq.put("pia", 29);
    freq.put("pic", 75);
    freq.put("pid", 17);
    freq.put("pie", 32);
    freq.put("aGa", 9);
    freq.put("pig", 15);
    freq.put("pix", 11);
    freq.put("ub ", 39);
    freq.put("pip", 12);
    freq.put("piq", 17);
    freq.put("pir", 39);
    freq.put("pis", 84);
    freq.put("pit", 140);
    freq.put("piu", 31);
    freq.put("oad", 31);
    freq.put("oac", 15);
    freq.put("oan", 176);
    freq.put("oal", 27);
    freq.put("xó ", 8);
    freq.put("oat", 11);
    freq.put("oar", 9);
    freq.put("Acc", 17);
    freq.put("Aca", 34);
    freq.put("ubr", 9);
    freq.put("sva", 14);
    freq.put("pi ", 75);
    freq.put("Aco", 17);
    freq.put("ube", 58);
    freq.put("uba", 13);
    freq.put("Acu", 9);
    freq.put("Act", 19);
    freq.put("ubl", 66);
    freq.put("ubm", 16);
    freq.put("ubi", 38);
    freq.put("oa ", 18);
    freq.put("CBl", 9);
    freq.put("rre", 582);
    freq.put("scl", 27);
    freq.put("sci", 33);
    freq.put("nwi", 7);
    freq.put("bàs", 12);
    freq.put("Cro", 10);
    freq.put("sce", 39);
    freq.put("lt ", 500);
    freq.put("G ", 137);
    freq.put("sca", 367);
    freq.put("Gu", 137);
    freq.put("Gs", 8);
    freq.put("Gr", 336);
    freq.put("Gp", 7);
    freq.put("Gy", 7);
    freq.put("Ge", 165);
    freq.put("Ga", 178);
    freq.put("Go", 148);
    freq.put("Gn", 7);
    freq.put("Gm", 9);
    freq.put("Gl", 27);
    freq.put("Gi", 125);
    freq.put("Gh", 8);
    freq.put("xàm", 9);
    freq.put(" ka", 8);
    freq.put(" ke", 15);
    freq.put(" ki", 22);
    freq.put(" ko", 9);
    freq.put(" km", 25);
    freq.put(" kr", 8);
    freq.put("scu", 80);
    freq.put("mna", 19);
    freq.put("dí ", 9);
    freq.put("Fin", 58);
    freq.put("Z ", 79);
    freq.put("aio", 18);
    freq.put("mne", 40);
    freq.put("ain", 77);
    freq.put("scr", 123);
    freq.put(" k ", 61);
    freq.put("tiu", 215);
    freq.put("TT ", 36);
    freq.put("día", 12);
    freq.put("Zn", 11);
    freq.put("Zo", 11);
    freq.put("Ze", 11);
    freq.put("Zf", 8);
    freq.put("Za", 14);
    freq.put("Zc", 9);
    freq.put("dís", 17);
    freq.put("Zy", 7);
    freq.put("Zu", 10);
    freq.put("Zp", 11);
    freq.put("m ", 3369);
    freq.put("enç", 144);
    freq.put("enú", 12);
    freq.put("mE", 10);
    freq.put("mG", 9);
    freq.put("mF", 11);
    freq.put("mC", 13);
    freq.put("mM", 34);
    freq.put("mL", 7);
    freq.put("mO", 7);
    freq.put("mN", 7);
    freq.put("mI", 7);
    freq.put("mH", 7);
    freq.put("mK", 9);
    freq.put("mU", 14);
    freq.put("mT", 13);
    freq.put("mV", 8);
    freq.put("vpa", 16);
    freq.put("mP", 23);
    freq.put("mS", 9);
    freq.put("mR", 9);
    freq.put("mX", 7);
    freq.put("mZ", 7);
    freq.put("me", 3548);
    freq.put("md", 28);
    freq.put("mg", 17);
    freq.put("mf", 55);
    freq.put("ma", 3485);
    freq.put("ltu", 64);
    freq.put("mc", 56);
    freq.put("mb", 1762);
    freq.put("mm", 179);
    freq.put("ml", 29);
    freq.put("mo", 1690);
    freq.put("mn", 129);
    freq.put("mi", 1860);
    freq.put("mh", 20);
    freq.put("mk", 13);
    freq.put("mj", 15);
    freq.put("mu", 420);
    freq.put("mt", 48);
    freq.put("mv", 21);
    freq.put("mq", 7);
    freq.put("mp", 1487);
    freq.put("ms", 190);
    freq.put("mr", 44);
    freq.put("my", 25);
    freq.put("mx", 8);
    freq.put("sí ", 117);
    freq.put("ena", 385);
    freq.put("enc", 623);
    freq.put("end", 483);
    freq.put("ene", 431);
    freq.put("enf", 39);
    freq.put("eng", 215);
    freq.put("enh", 7);
    freq.put("eni", 395);
    freq.put("enj", 53);
    freq.put("enl", 34);
    freq.put("enn", 27);
    freq.put("eno", 107);
    freq.put("enq", 14);
    freq.put("enr", 45);
    freq.put("nú ", 9);
    freq.put("ent", 2649);
    freq.put("enu", 46);
    freq.put("env", 92);
    freq.put("enx", 12);
    freq.put("eny", 260);
    freq.put("enz", 10);
    freq.put("ON ", 15);
    freq.put("II ", 26);
    freq.put("en ", 2270);
    freq.put("mà", 304);
    freq.put("nút", 7);
    freq.put("mí", 93);
    freq.put("mé", 704);
    freq.put("mè", 29);
    freq.put("mó", 85);
    freq.put("mò", 39);
    freq.put("núm", 11);
    freq.put("mú", 34);
    freq.put("imM", 22);
    freq.put(" Hu", 35);
    freq.put(" Hi", 88);
    freq.put(" Ho", 135);
    freq.put(" Ha", 79);
    freq.put(" He", 121);
    freq.put("ima", 327);
    freq.put("clo", 46);
    freq.put("ime", 333);
    freq.put("cli", 59);
    freq.put("imf", 8);
    freq.put("imi", 114);
    freq.put("cle", 107);
    freq.put("imk", 8);
    freq.put("imm", 34);
    freq.put("cla", 291);
    freq.put("imo", 71);
    freq.put("imn", 14);
    freq.put("imp", 188);
    freq.put("ims", 67);
    freq.put("imu", 11);
    freq.put("imt", 8);
    freq.put("clu", 39);
    freq.put("JA ", 19);
    freq.put("SA ", 16);
    freq.put(" H ", 35);
    freq.put("im ", 305);
    freq.put("xC ", 8);
    freq.put("gom", 24);
    freq.put("imà", 8);
    freq.put("goo", 24);
    freq.put("gon", 210);
    freq.put("clà", 14);
    freq.put("aju", 92);
    freq.put("goc", 38);
    freq.put("ajj", 17);
    freq.put("ajo", 106);
    freq.put("got", 23);
    freq.put("gov", 71);
    freq.put("aje", 24);
    freq.put("gos", 54);
    freq.put("gor", 27);
    freq.put("W", 405);
    freq.put("Vic", 64);
    freq.put("Via", 18);
    freq.put("Vid", 22);
    freq.put("Vie", 7);
    freq.put("Vin", 30);
    freq.put("go ", 95);
    freq.put("Vil", 151);
    freq.put("Vis", 54);
    freq.put("Viv", 28);
    freq.put("aj ", 14);
    freq.put("be ", 93);
    freq.put("raç", 24);
    freq.put("nha", 9);
    freq.put("nho", 48);
    freq.put("nir", 127);
    freq.put("raó", 20);
    freq.put("toy", 7);
    freq.put(" Sk", 9);
    freq.put("tor", 557);
    freq.put("tos", 135);
    freq.put("top", 56);
    freq.put("toq", 13);
    freq.put("equ", 140);
    freq.put("EU ", 26);
    freq.put("tot", 673);
    freq.put("tou", 9);
    freq.put("ton", 247);
    freq.put("tol", 49);
    freq.put("tom", 49);
    freq.put("tob", 26);
    freq.put("toc", 98);
    freq.put("tof", 22);
    freq.put("tog", 27);
    freq.put("tod", 23);
    freq.put("toe", 7);
    freq.put("Fut", 16);
    freq.put("Fun", 21);
    freq.put("to ", 238);
    freq.put("raf", 70);
    freq.put("rag", 119);
    freq.put("rad", 479);
    freq.put("rae", 20);
    freq.put("rab", 58);
    freq.put("rac", 448);
    freq.put("raa", 17);
    freq.put("ran", 1155);
    freq.put("rao", 18);
    freq.put("ral", 304);
    freq.put("ram", 215);
    freq.put("raj", 27);
    freq.put("rak", 7);
    freq.put("rah", 13);
    freq.put("rai", 51);
    freq.put("rav", 82);
    freq.put("rat", 533);
    freq.put("rau", 113);
    freq.put("rar", 381);
    freq.put("ras", 259);
    freq.put("rap", 42);
    freq.put("raq", 13);
    freq.put("lbi", 19);
    freq.put("bs ", 31);
    freq.put("lbo", 13);
    freq.put("ray", 8);
    freq.put("eqü", 7);
    freq.put("raL", 7);
    freq.put("raM", 8);
    freq.put("raV", 8);
    freq.put("òci", 8);
    freq.put("ra ", 2184);
    freq.put("bst", 18);
    freq.put("bso", 20);
    freq.put("bse", 23);
    freq.put("bsc", 8);
    freq.put("eB ", 7);
    freq.put("AS ", 16);
    freq.put("tha", 11);
    freq.put("gní", 9);
    freq.put("aEs", 16);
    freq.put("és", 1973);
    freq.put("ér", 10);
    freq.put("éu", 33);
    freq.put("ét", 12);
    freq.put("éi", 14);
    freq.put("én", 28);
    freq.put("aEn", 14);
    freq.put("oci", 233);
    freq.put(" úl", 56);
    freq.put("Bil", 7);
    freq.put(" ún", 35);
    freq.put("òp", 17);
    freq.put("ocl", 16);
    freq.put("òr", 143);
    freq.put("òs", 34);
    freq.put("oca", 292);
    freq.put("Big", 9);
    freq.put("occ", 13);
    freq.put("Bib", 9);
    freq.put("òg", 30);
    freq.put("òb", 23);
    freq.put("òc", 11);
    freq.put("òl", 24);
    freq.put("òm", 45);
    freq.put("òn", 64);
    freq.put("ocr", 43);
    freq.put("ocu", 91);
    freq.put("oct", 31);
    freq.put("é ", 692);
    freq.put("oc ", 229);
    freq.put("ò ", 748);
    freq.put("urí", 14);
    freq.put("Pet", 28);
    freq.put("nut", 119);
    freq.put("Pep", 54);
    freq.put("nus", 12);
    freq.put("Per", 363);
    freq.put("uré", 13);
    freq.put("Pel", 23);
    freq.put("Pen", 47);
    freq.put("num", 10);
    freq.put("Ped", 23);
    freq.put("nue", 32);
    freq.put("nua", 40);
    freq.put("océ", 21);
    freq.put("mut", 12);
    freq.put("dBo", 9);
    freq.put("mur", 17);
    freq.put("íst", 37);
    freq.put("íss", 33);
    freq.put("mue", 7);
    freq.put("mud", 11);
    freq.put("mua", 11);
    freq.put("ísi", 13);
    freq.put("mul", 39);
    freq.put("mun", 213);
    freq.put("XD ", 15);
    freq.put("Exi", 7);
    freq.put("Ext", 9);
    freq.put("Exp", 19);
    freq.put("nu ", 12);
    freq.put("ís ", 136);
    freq.put(" me", 1041);
    freq.put("ela", 182);
    freq.put(" ma", 1565);
    freq.put(" mb", 7);
    freq.put(" mc", 11);
    freq.put(" ml", 9);
    freq.put(" mm", 20);
    freq.put(" mo", 1086);
    freq.put(" mh", 9);
    freq.put(" mi", 917);
    freq.put(" mj", 7);
    freq.put(" mt", 10);
    freq.put(" mu", 172);
    freq.put("Cr ", 13);
    freq.put("xx ", 11);
    freq.put(" mp", 7);
    freq.put("eld", 30);
    freq.put(" mr", 19);
    freq.put(" ms", 15);
    freq.put(" my", 12);
    freq.put(" m ", 324);
    freq.put("Cru", 8);
    freq.put("xxx", 8);
    freq.put("Cra", 8);
    freq.put("Cre", 62);
    freq.put("Cri", 41);
    freq.put("TV ", 127);
    freq.put("n", 39356);
    freq.put(" mà", 69);
    freq.put("rtu", 83);
    freq.put(" mí", 35);
    freq.put(" mè", 13);
    freq.put(" mé", 545);
    freq.put(" mò", 21);
    freq.put(" mó", 75);
    freq.put(" mú", 24);
    freq.put("elB", 7);
    freq.put("elC", 16);
    freq.put("Xar", 11);
    freq.put("lca", 87);
    freq.put("Xau", 7);
    freq.put("Xav", 81);
    freq.put("elP", 7);
    freq.put("vig", 11);
    freq.put("eli", 355);
    freq.put("elo", 344);
    freq.put("ell", 916);
    freq.put("elm", 48);
    freq.put("elb", 21);
    freq.put("elc", 48);
    freq.put("icà", 17);
    freq.put("elg", 17);
    freq.put("tDe", 8);
    freq.put("ele", 277);
    freq.put("elz", 10);
    freq.put("elr", 13);
    freq.put("els", 1504);
    freq.put("elp", 68);
    freq.put("elv", 19);
    freq.put("elt", 55);
    freq.put("elu", 11);
    freq.put("D", 1852);
    freq.put("IO ", 13);
    freq.put(" è ", 24);
    freq.put("el ", 4123);
    freq.put("aó ", 23);
    freq.put("hs ", 10);
    freq.put(" Ju", 94);
    freq.put("SCa", 7);
    freq.put(" Jo", 403);
    freq.put(" Ji", 8);
    freq.put(" Je", 26);
    freq.put(" Ja", 276);
    freq.put("ick", 31);
    freq.put("cnw", 7);
    freq.put("ici", 676);
    freq.put("Hy", 7);
    freq.put("ico", 147);
    freq.put("icm", 10);
    freq.put("icl", 93);
    freq.put("Hr", 7);
    freq.put("Hs", 12);
    freq.put("ica", 992);
    freq.put("Hw", 8);
    freq.put("ice", 66);
    freq.put("Hu", 41);
    freq.put("Hk", 7);
    freq.put("Hi", 95);
    freq.put("Hn", 8);
    freq.put("Ho", 168);
    freq.put("Hm", 11);
    freq.put("ics", 207);
    freq.put("cno", 15);
    freq.put("Ha", 88);
    freq.put("Hf", 8);
    freq.put("icu", 42);
    freq.put("He", 137);
    freq.put("SC ", 62);
    freq.put(" J ", 21);
    freq.put("ic ", 634);
    freq.put("cn ", 97);
    freq.put("H ", 114);
    freq.put("el·", 32);
    freq.put("aha", 94);
    freq.put("giR", 9);
    freq.put("ppe", 9);
    freq.put("ppi", 8);
    freq.put("ahi", 63);
    freq.put("aho", 38);
    freq.put("ppl", 13);
    freq.put("pps", 11);
    freq.put("nè", 47);
    freq.put("né", 15);
    freq.put("giu", 7);
    freq.put("git", 114);
    freq.put("gis", 40);
    freq.put("gir", 110);
    freq.put("giq", 8);
    freq.put("gip", 7);
    freq.put("nà", 38);
    freq.put("ná", 8);
    freq.put("nç", 292);
    freq.put("nú", 50);
    freq.put("gid", 14);
    freq.put("gic", 38);
    freq.put("gib", 9);
    freq.put("gia", 61);
    freq.put("gio", 22);
    freq.put("gin", 124);
    freq.put("nò", 36);
    freq.put("nó", 24);
    freq.put("ah ", 33);
    freq.put("pp ", 25);
    freq.put("án ", 8);
    freq.put("urg", 19);
    freq.put("Vol", 53);
    freq.put("Vot", 8);
    freq.put("gi ", 101);
    freq.put("nno", 25);
    freq.put("nI", 12);
    freq.put("nJ", 13);
    freq.put("uro", 157);
    freq.put("nL", 18);
    freq.put("nM", 23);
    freq.put("nN", 14);
    freq.put("nO", 14);
    freq.put("nA", 22);
    freq.put("nB", 18);
    freq.put("nC", 35);
    freq.put("nD", 16);
    freq.put("nE", 14);
    freq.put("nF", 10);
    freq.put("nG", 14);
    freq.put("nX", 9);
    freq.put("nZ", 7);
    freq.put("tó ", 49);
    freq.put("nny", 7);
    freq.put("nP", 26);
    freq.put("urà", 50);
    freq.put("nR", 22);
    freq.put("nS", 14);
    freq.put("nT", 21);
    freq.put("ós ", 68);
    freq.put("nV", 13);
    freq.put("nh", 73);
    freq.put("ni", 2542);
    freq.put("nj", 123);
    freq.put("nk", 61);
    freq.put("nl", 76);
    freq.put("nm", 57);
    freq.put("nn", 227);
    freq.put("no", 3117);
    freq.put("tit", 455);
    freq.put("na", 5317);
    freq.put("nb", 33);
    freq.put("nc", 2205);
    freq.put("nd", 1670);
    freq.put("ne", 2223);
    freq.put("nf", 379);
    freq.put("ng", 960);
    freq.put("nx", 53);
    freq.put("ny", 1730);
    freq.put("nz", 87);
    freq.put("tio", 48);
    freq.put("tii", 10);
    freq.put("ES ", 97);
    freq.put("np", 45);
    freq.put("nq", 154);
    freq.put("nr", 137);
    freq.put("ns", 3117);
    freq.put("nt", 6200);
    freq.put("nu", 384);
    freq.put("nv", 416);
    freq.put("nw", 10);
    freq.put("elè", 12);
    freq.put("squ", 149);
    freq.put("nn ", 10);
    freq.put("ich", 40);
    freq.put("n ", 6951);
    freq.put("icc", 35);
    freq.put("icb", 8);
    freq.put("ti ", 158);
    freq.put("lj", 11);
    freq.put("roh", 21);
    freq.put("roi", 38);
    freq.put("roj", 45);
    freq.put("rol", 87);
    freq.put("rom", 109);
    freq.put("ron", 246);
    freq.put("roo", 8);
    freq.put("lls", 193);
    freq.put("roa", 8);
    freq.put("rob", 240);
    freq.put("roc", 102);
    freq.put("rod", 127);
    freq.put("roe", 8);
    freq.put("rof", 84);
    freq.put("icf", 8);
    freq.put("rox", 12);
    freq.put("roy", 11);
    freq.put("lli", 298);
    freq.put("llo", 476);
    freq.put("lll", 7);
    freq.put("rop", 259);
    freq.put("roq", 8);
    freq.put("ror", 28);
    freq.put("ros", 216);
    freq.put("rot", 108);
    freq.put("rou", 77);
    freq.put("rov", 124);
    freq.put("lld", 12);
    freq.put("Dam", 15);
    freq.put("Dan", 27);
    freq.put("Dav", 35);
    freq.put("Dar", 7);
    freq.put("Què", 50);
    freq.put("Pq", 11);
    freq.put("Cie", 8);
    freq.put("ro ", 394);
    freq.put("Cin", 10);
    freq.put("Hb", 8);
    freq.put("Civ", 8);
    freq.put("Ciu", 36);
    freq.put("Hc", 7);
    freq.put("ll ", 568);
    freq.put(" dg", 7);
    freq.put("CiU", 59);
    freq.put("ict", 86);
    freq.put("Rey", 12);
    freq.put("lló", 26);
    freq.put("Res", 49);
    freq.put("Rep", 21);
    freq.put("Rev", 10);
    freq.put("Ret", 13);
    freq.put("Reu", 32);
    freq.put("llé", 9);
    freq.put("Rei", 53);
    freq.put("Ren", 17);
    freq.put("Reb", 9);
    freq.put("Rec", 73);
    freq.put("Rea", 14);
    freq.put("Ref", 9);
    freq.put("Reg", 28);
    freq.put("Red", 10);
    freq.put("Qua", 69);
    freq.put("Que", 182);
    freq.put("Qui", 166);
    freq.put("Agu", 23);
    freq.put("Agr", 9);
    freq.put("UdG", 7);
    freq.put("msa", 40);
    freq.put("Eva", 10);
    freq.put("úbl", 101);
    freq.put("obl", 164);
    freq.put("lmu", 15);
    freq.put("ms ", 113);
    freq.put(" on", 121);
    freq.put("Mik", 8);
    freq.put(" om", 43);
    freq.put(" oj", 9);
    freq.put(" ok", 31);
    freq.put(" oh", 13);
    freq.put(" oi", 32);
    freq.put(" of", 94);
    freq.put(" od", 11);
    freq.put("º ", 9);
    freq.put(" oc", 53);
    freq.put("Mig", 11);
    freq.put("Miq", 21);
    freq.put("Mis", 20);
    freq.put("Mir", 65);
    freq.put(" or", 159);
    freq.put("Mit", 15);
    freq.put(" op", 95);
    freq.put("cob", 74);
    freq.put("fíc", 13);
    freq.put("ky ", 9);
    freq.put(" o ", 270);
    freq.put("ºC", 39);
    freq.put("déu", 13);
    freq.put("dés", 14);
    freq.put("Í ", 12);
    freq.put("qr", 11);
    freq.put("ng ", 132);
    freq.put("qv", 14);
    freq.put("à ", 1248);
    freq.put(" ca", 2155);
    freq.put("EN ", 27);
    freq.put("üí", 12);
    freq.put("eje", 26);
    freq.put("eja", 103);
    freq.put("nCa", 24);
    freq.put("àb", 22);
    freq.put("àc", 314);
    freq.put("àf", 20);
    freq.put("àg", 29);
    freq.put("àd", 24);
    freq.put("àn", 111);
    freq.put("àl", 44);
    freq.put("àm", 30);
    freq.put("àr", 142);
    freq.put("às", 215);
    freq.put("àp", 33);
    freq.put("àq", 9);
    freq.put("àv", 21);
    freq.put("àt", 69);
    freq.put("àx", 24);
    freq.put("ní", 32);
    freq.put("iaM", 17);
    freq.put("iaL", 8);
    freq.put("ès ", 120);
    freq.put("anç", 143);
    freq.put("anà", 11);
    freq.put("prà", 12);
    freq.put("iaA", 8);
    freq.put("prè", 23);
    freq.put("iaC", 13);
    freq.put("iaB", 14);
    freq.put("prò", 21);
    freq.put("iaV", 7);
    freq.put("iaS", 9);
    freq.put("iaR", 16);
    freq.put("iam", 70);
    freq.put("ial", 355);
    freq.put("iao", 11);
    freq.put("ian", 276);
    freq.put("iai", 20);
    freq.put("€ ", 76);
    freq.put("iaj", 8);
    freq.put("iad", 77);
    freq.put("iag", 35);
    freq.put("iaf", 12);
    freq.put("iaa", 18);
    freq.put("gie", 13);
    freq.put("iac", 58);
    freq.put("iab", 37);
    freq.put("iax", 8);
    freq.put("rHo", 12);
    freq.put("iaz", 9);
    freq.put("iau", 7);
    freq.put("iat", 189);
    freq.put("iav", 10);
    freq.put("iap", 27);
    freq.put("ias", 66);
    freq.put("iar", 292);
    freq.put("hue", 9);
    freq.put("hul", 7);
    freq.put("hum", 34);
    freq.put("hui", 25);
    freq.put("èst", 11);
    freq.put("SE ", 13);
    freq.put("gim", 23);
    freq.put("gil", 23);
    freq.put(" Lí", 10);
    freq.put("ia ", 2560);
    freq.put("r", 44057);
    freq.put(" Ló", 7);
    freq.put("and", 379);
    freq.put("ane", 315);
    freq.put("ang", 151);
    freq.put("pra", 82);
    freq.put("ana", 883);
    freq.put("anb", 13);
    freq.put("anc", 385);
    freq.put("anl", 14);
    freq.put("anm", 22);
    freq.put("ann", 79);
    freq.put("ano", 208);
    freq.put("pri", 244);
    freq.put("ani", 417);
    freq.put("anj", 37);
    freq.put("ank", 23);
    freq.put("ant", 1919);
    freq.put("anu", 88);
    freq.put("anv", 104);
    freq.put("anp", 14);
    freq.put("anq", 83);
    freq.put("anr", 38);
    freq.put("ans", 543);
    freq.put("anx", 16);
    freq.put("any", 982);
    freq.put("anz", 18);
    freq.put("anB", 8);
    freq.put("anC", 7);
    freq.put("anM", 11);
    freq.put("anT", 15);
    freq.put("Har", 7);
    freq.put("anP", 17);
    freq.put("anR", 8);
    freq.put("new", 11);
    freq.put("an ", 1329);
    freq.put("ló ", 35);
    freq.put("uya", 10);
    freq.put("fcb", 60);
    freq.put("uyo", 18);
    freq.put(" Le", 153);
    freq.put(" La", 658);
    freq.put(" Lo", 79);
    freq.put(" Ll", 221);
    freq.put(" Li", 69);
    freq.put(" Lu", 36);
    freq.put(" Ly", 7);
    freq.put("eMa", 11);
    freq.put("eMo", 7);
    freq.put("rmà", 13);
    freq.put("nli", 13);
    freq.put("dy ", 8);
    freq.put("ss ", 68);
    freq.put("·l", 110);
    freq.put("ssu", 53);
    freq.put("H", 841);
    freq.put("sss", 43);
    freq.put("oce", 34);
    freq.put("moo", 16);
    freq.put("sso", 178);
    freq.put("ssi", 541);
    freq.put("sse", 252);
    freq.put("ssa", 595);
    freq.put("lun", 372);
    freq.put("rms", 10);
    freq.put("rmu", 16);
    freq.put("iLo", 7);
    freq.put("rma", 256);
    freq.put("rme", 181);
    freq.put("jot", 10);
    freq.put("rmi", 91);
    freq.put("rmo", 27);
    freq.put("ssí", 7);
    freq.put("rm ", 11);
    freq.put("üís", 12);
    freq.put("pot", 246);
    freq.put("pou", 12);
    freq.put("por", 629);
    freq.put("pos", 469);
    freq.put("pop", 17);
    freq.put("poq", 8);
    freq.put("pon", 82);
    freq.put("pol", 251);
    freq.put("pom", 19);
    freq.put("poi", 7);
    freq.put("pog", 21);
    freq.put("pod", 268);
    freq.put("poe", 13);
    freq.put("pob", 72);
    freq.put("poc", 124);
    freq.put("nni", 28);
    freq.put("Bur", 21);
    freq.put("Bus", 27);
    freq.put("But", 8);
    freq.put("nne", 28);
    freq.put("Bue", 12);
    freq.put("Aes", 17);
    freq.put("Aec", 8);
    freq.put("nna", 96);
    freq.put("po ", 36);
    freq.put("oks", 7);
    freq.put("ePo", 8);
    freq.put("Et ", 18);
    freq.put("nnu", 12);
    freq.put("I ", 520);
    freq.put("Ets", 20);
    freq.put("gió", 7);
    freq.put("Ix", 9);
    freq.put("tiz", 8);
    freq.put("Is", 31);
    freq.put("Ir", 34);
    freq.put("It", 16);
    freq.put("Iw", 7);
    freq.put("Iv", 17);
    freq.put("Ij", 7);
    freq.put("Im", 48);
    freq.put("Il", 28);
    freq.put("Io", 11);
    freq.put("In", 255);
    freq.put("Ia", 10);
    freq.put("Ic", 18);
    freq.put("Ib", 26);
    freq.put("Ie", 9);
    freq.put("Id", 13);
    freq.put("Ig", 39);
    freq.put("If", 7);
    freq.put(" qu", 3504);
    freq.put("tip", 31);
    freq.put("tiq", 60);
    freq.put("oki", 7);
    freq.put(" qe", 13);
    freq.put("tis", 138);
    freq.put("til", 116);
    freq.put("tim", 240);
    freq.put("tin", 544);
    freq.put("yc", 22);
    freq.put(" q ", 375);
    freq.put("tid", 82);
    freq.put("tie", 36);
    freq.put("tif", 46);
    freq.put("tig", 83);
    freq.put("Pil", 25);
    freq.put("Pin", 22);
    freq.put("Pic", 11);
    freq.put("Pie", 9);
    freq.put("tia", 70);
    freq.put("tib", 16);
    freq.put("Piq", 35);
    freq.put("Pir", 9);
    freq.put("tic", 711);
    freq.put("Pit", 9);
    freq.put("Piu", 17);
    freq.put("o ", 8339);
    freq.put("oO", 7);
    freq.put("oN", 13);
    freq.put("oM", 21);
    freq.put("oL", 12);
    freq.put("oK", 12);
    freq.put("oJ", 13);
    freq.put("oI", 7);
    freq.put("oH", 11);
    freq.put("oG", 15);
    freq.put("oF", 14);
    freq.put("oD", 12);
    freq.put("oC", 32);
    freq.put("oB", 16);
    freq.put("oA", 10);
    freq.put("oZ", 7);
    freq.put("oY", 7);
    freq.put("oX", 8);
    freq.put("oV", 18);
    freq.put("oT", 17);
    freq.put("oS", 29);
    freq.put("oR", 18);
    freq.put("oP", 27);
    freq.put("oo", 317);
    freq.put("on", 5322);
    freq.put("om", 2561);
    freq.put("ol", 3516);
    freq.put("ok", 111);
    freq.put("oj", 104);
    freq.put("oi", 298);
    freq.put("oh", 90);
    freq.put("og", 385);
    freq.put("of", 291);
    freq.put("oe", 116);
    freq.put("od", 773);
    freq.put("oc", 1191);
    freq.put("ob", 1010);
    freq.put("oa", 320);
    freq.put("oz", 36);
    freq.put("oy", 100);
    freq.put("ox", 41);
    freq.put("ow", 83);
    freq.put("ov", 648);
    freq.put("ou", 670);
    freq.put("ot", 2088);
    freq.put("os", 2865);
    freq.put("or", 4995);
    freq.put("oq", 87);
    freq.put("op", 808);
    freq.put("LE ", 11);
    freq.put("ju ", 12);
    freq.put("yal", 19);
    freq.put("EL ", 51);
    freq.put("ehe", 16);
    freq.put("ehi", 16);
    freq.put("jua", 23);
    freq.put("jug", 113);
    freq.put("jud", 79);
    freq.put("jue", 8);
    freq.put("jun", 144);
    freq.put("UE ", 37);
    freq.put("jul", 33);
    freq.put("jur", 14);
    freq.put("jus", 76);
    freq.put("juv", 11);
    freq.put("jut", 22);
    freq.put("eh ", 45);
    freq.put("PF ", 22);
    freq.put("rva", 41);
    freq.put("rve", 105);
    freq.put("cbe", 14);
    freq.put("rvi", 66);
    freq.put("cbo", 7);
    freq.put("cbl", 35);
    freq.put("vés", 22);
    freq.put("igu", 362);
    freq.put("igr", 23);
    freq.put("IC ", 26);
    freq.put("ige", 42);
    freq.put("igd", 23);
    freq.put("iga", 202);
    freq.put("igo", 32);
    freq.put("ign", 142);
    freq.put("igl", 8);
    freq.put("igi", 139);
    freq.put("igh", 19);
    freq.put("cb ", 20);
    freq.put("ig ", 352);
    freq.put("pto", 11);
    freq.put("alo", 127);
    freq.put("all", 723);
    freq.put("alm", 156);
    freq.put("alk", 14);
    freq.put("alh", 9);
    freq.put("ali", 436);
    freq.put("alf", 28);
    freq.put("alg", 211);
    freq.put("ald", 154);
    freq.put("ale", 463);
    freq.put("alb", 116);
    freq.put("alc", 89);
    freq.put("pta", 56);
    freq.put("ala", 659);
    freq.put("alv", 124);
    freq.put("alt", 477);
    freq.put("alu", 396);
    freq.put("als", 540);
    freq.put("alp", 25);
    freq.put(" N ", 63);
    freq.put("alD", 13);
    freq.put("alC", 10);
    freq.put("sUn", 7);
    freq.put("llp", 9);
    freq.put("far", 158);
    freq.put("fas", 53);
    freq.put("fav", 49);
    freq.put("al ", 2597);
    freq.put("fau", 8);
    freq.put("fai", 33);
    freq.put("fan", 156);
    freq.put("llu", 177);
    freq.put("fal", 110);
    freq.put("fam", 41);
    freq.put("fab", 15);
    freq.put("fac", 83);
    freq.put("rog", 113);
    freq.put("fag", 7);
    freq.put("fad", 9);
    freq.put("fae", 8);
    freq.put(" Ni", 69);
    freq.put(" No", 475);
    freq.put(" Na", 155);
    freq.put(" Ne", 90);
    freq.put(" Nu", 10);
    freq.put("tei", 294);
    freq.put("tej", 45);
    freq.put("tel", 263);
    freq.put("tem", 366);
    freq.put("alè", 58);
    freq.put("teo", 65);
    freq.put("alç", 16);
    freq.put("tec", 76);
    freq.put("ted", 21);
    freq.put("tee", 8);
    freq.put("alà", 214);
    freq.put("teg", 45);
    freq.put("tex", 21);
    freq.put("llc", 11);
    freq.put("nbo", 7);
    freq.put("llb", 8);
    freq.put("tep", 8);
    freq.put("teq", 9);
    freq.put("nba", 9);
    freq.put("tes", 817);
    freq.put("tet", 62);
    freq.put("lla", 815);
    freq.put("tev", 56);
    freq.put("sue", 8);
    freq.put("sud", 11);
    freq.put("suc", 23);
    freq.put("sub", 59);
    freq.put("sua", 49);
    freq.put("sun", 32);
    freq.put("sum", 72);
    freq.put("sul", 114);
    freq.put("llf", 12);
    freq.put("sus", 31);
    freq.put("sur", 82);
    freq.put("sup", 168);
    freq.put("te ", 605);
    freq.put("al·", 10);
    freq.put("su ", 12);
    freq.put("icr", 20);
    freq.put("ya ", 529);
    freq.put(" Nú", 20);
    freq.put("Tor", 76);
    freq.put("Top", 7);
    freq.put("Tot", 112);
    freq.put("rke", 17);
    freq.put("Ton", 33);
    freq.put("rka", 11);
    freq.put("Tom", 24);
    freq.put("òmi", 31);
    freq.put("rki", 14);
    freq.put("ódi", 7);
    freq.put("In ", 8);
    freq.put("rk ", 15);
    freq.put("á", 74);
    freq.put("Int", 63);
    freq.put("Inv", 7);
    freq.put("Ins", 26);
    freq.put("Inn", 7);
    freq.put("Ini", 25);
    freq.put("v", 8759);
    freq.put("Ind", 50);
    freq.put("Inf", 31);
    freq.put("Ing", 7);
    freq.put("Inc", 13);
    freq.put("úli", 11);
    freq.put(" Àn", 24);
    freq.put("Eb", 19);
    freq.put("oye", 8);
    freq.put("oya", 16);
    freq.put("Glo", 10);
    freq.put("Cir", 7);
    freq.put("lho", 14);
    freq.put("oy ", 52);
    freq.put(" só", 183);
    freq.put(" sè", 8);
    freq.put(" sé", 61);
    freq.put(" sí", 112);
    freq.put(" sà", 8);
    freq.put("·", 114);
    freq.put("L", 2015);
    freq.put("Era", 9);
    freq.put("Raf", 19);
    freq.put("aOf", 9);
    freq.put("Rad", 16);
    freq.put("Rac", 13);
    freq.put("Ram", 44);
    freq.put("Raj", 25);
    freq.put("Rah", 14);
    freq.put("Rau", 11);
    freq.put("Mus", 25);
    freq.put(" sr", 7);
    freq.put(" sp", 28);
    freq.put(" st", 61);
    freq.put(" su", 326);
    freq.put(" sk", 10);
    freq.put(" sh", 16);
    freq.put(" si", 915);
    freq.put(" so", 995);
    freq.put(" sl", 7);
    freq.put(" sm", 14);
    freq.put(" sb", 7);
    freq.put(" sc", 20);
    freq.put("Mun", 53);
    freq.put(" se", 2066);
    freq.put("iza", 11);
    freq.put("izc", 8);
    freq.put("gur", 133);
    freq.put("izz", 7);
    freq.put("uí ", 155);
    freq.put("ºC ", 39);
    freq.put(" s ", 397);
    freq.put("kol", 10);
    freq.put("iz ", 27);
    freq.put("koa", 8);
    freq.put(" ef", 23);
    freq.put("GT ", 13);
    freq.put("cón", 17);
    freq.put("imb", 18);
    freq.put("TL ", 8);
    freq.put("llò", 12);
    freq.put("cór", 11);
    freq.put("có ", 12);
    freq.put("llè", 9);
    freq.put("kov", 13);
    freq.put("uè ", 340);
    freq.put("llà", 84);
    freq.put("efr", 23);
    freq.put("efi", 46);
    freq.put("efl", 21);
    freq.put("efo", 53);
    freq.put("efa", 23);
    freq.put("efe", 165);
    freq.put("nòm", 29);
    freq.put("l·l", 110);
    freq.put("rte", 201);
    freq.put("cde", 23);
    freq.put("rtg", 9);
    freq.put("aró", 19);
    freq.put("rta", 488);
    freq.put("rtb", 9);
    freq.put("rtm", 14);
    freq.put("òvi", 7);
    freq.put("rtn", 10);
    freq.put("rti", 640);
    freq.put("rth", 8);
    freq.put("arà", 222);
    freq.put("rtv", 7);
    freq.put("rts", 201);
    freq.put("rtr", 37);
    freq.put("arè", 11);
    freq.put("aré", 60);
    freq.put("rty", 14);
    freq.put("arí", 18);
    freq.put("Jy", 7);
    freq.put("Ju", 111);
    freq.put("ies", 696);
    freq.put("ier", 119);
    freq.put("ieu", 41);
    freq.put("iet", 82);
    freq.put("iev", 14);
    freq.put("Jl", 8);
    freq.put("Jm", 12);
    freq.put("Jo", 441);
    freq.put("iem", 83);
    freq.put("iel", 67);
    freq.put("Jj", 10);
    freq.put("Jk", 7);
    freq.put("Jd", 9);
    freq.put("Je", 30);
    freq.put("iec", 8);
    freq.put("Jg", 7);
    freq.put("Ja", 290);
    freq.put("Jb", 7);
    freq.put("Jc", 8);
    freq.put("hip", 15);
    freq.put("hir", 66);
    freq.put("his", 76);
    freq.put("hit", 8);
    freq.put("rt ", 699);
    freq.put("hiv", 17);
    freq.put("mís", 13);
    freq.put("hia", 16);
    freq.put("hib", 25);
    freq.put("Xi", 22);
    freq.put("hih", 7);
    freq.put("lèc", 11);
    freq.put("hij", 7);
    freq.put("mfo", 7);
    freq.put("hil", 17);
    freq.put("him", 18);
    freq.put("hin", 16);
    freq.put("exà", 8);
    freq.put("tco", 12);
    freq.put("Xc", 9);
    freq.put("ie ", 42);
    freq.put("J ", 88);
    freq.put("arp", 9);
    freq.put("arq", 62);
    freq.put("arr", 692);
    freq.put("ars", 131);
    freq.put("art", 917);
    freq.put("rtà", 11);
    freq.put("rtí", 22);
    freq.put("Xf", 11);
    freq.put("arz", 18);
    freq.put("ara", 971);
    freq.put("arb", 70);
    freq.put("arc", 605);
    freq.put("ard", 382);
    freq.put("are", 426);
    freq.put("arg", 89);
    freq.put("ari", 848);
    freq.put("ark", 32);
    freq.put("arl", 336);
    freq.put("arm", 90);
    freq.put("arn", 91);
    freq.put("aro", 113);
    freq.put("àbi", 9);
    freq.put(" P ", 60);
    freq.put("àbr", 12);
    freq.put("tro", 238);
    freq.put("Bd", 8);
    freq.put("uuu", 60);
    freq.put("Bf", 7);
    freq.put("ar ", 2445);
    freq.put("pv ", 16);
    freq.put(" Pr", 264);
    freq.put("c", 25163);
    freq.put("Bb", 12);
    freq.put(" Pu", 107);
    freq.put(" Px", 8);
    freq.put(" Pa", 377);
    freq.put(" Pe", 512);
    freq.put(" Pi", 126);
    freq.put(" Ph", 12);
    freq.put(" Po", 224);
    freq.put(" Pl", 94);
    freq.put("tgr", 10);
    freq.put("pS", 7);
    freq.put("pP", 9);
    freq.put("Em ", 41);
    freq.put("pT", 13);
    freq.put("pU", 10);
    freq.put(" xg", 8);
    freq.put("pX", 7);
    freq.put("rió", 20);
    freq.put("pB", 10);
    freq.put("pC", 12);
    freq.put("pA", 13);
    freq.put("pF", 11);
    freq.put("pG", 10);
    freq.put("riè", 14);
    freq.put("tge", 270);
    freq.put("pK", 10);
    freq.put("tgn", 7);
    freq.put("pO", 7);
    freq.put("rià", 16);
    freq.put("pM", 15);
    freq.put("pr", 2182);
    freq.put("ps", 374);
    freq.put("pp", 96);
    freq.put("pq", 50);
    freq.put("dul", 10);
    freq.put("dum", 23);
    freq.put("pt", 212);
    freq.put("pu", 681);
    freq.put("pz", 7);
    freq.put("dua", 48);
    freq.put("px", 9);
    freq.put("py", 20);
    freq.put("dud", 12);
    freq.put("due", 39);
    freq.put("pb", 20);
    freq.put("pc", 93);
    freq.put("pa", 2943);
    freq.put("pf", 20);
    freq.put("pg", 24);
    freq.put("pd", 45);
    freq.put("pe", 4515);
    freq.put("pj", 9);
    freq.put("Fan", 14);
    freq.put("dur", 124);
    freq.put("dus", 24);
    freq.put("dut", 26);
    freq.put("po", 2294);
    freq.put("pl", 724);
    freq.put("pm", 20);
    freq.put(" ºC", 39);
    freq.put("Emp", 26);
    freq.put("du ", 14);
    freq.put("p ", 4016);
    freq.put("Bz", 8);
    freq.put("rix", 8);
    freq.put("riv", 64);
    freq.put("rit", 308);
    freq.put("riu", 96);
    freq.put("rir", 76);
    freq.put("ris", 345);
    freq.put("rip", 44);
    freq.put("riq", 25);
    freq.put("rin", 235);
    freq.put("rio", 261);
    freq.put("ril", 67);
    freq.put("rim", 239);
    freq.put("rik", 14);
    freq.put("rii", 9);
    freq.put("rif", 21);
    freq.put("rig", 96);
    freq.put("rid", 196);
    freq.put("rie", 203);
    freq.put("rib", 198);
    freq.put("ric", 247);
    freq.put("ria", 842);
    freq.put("pò", 12);
    freq.put("duï", 7);
    freq.put("pú", 97);
    freq.put("pà", 38);
    freq.put("pè", 34);
    freq.put("riA", 57);
    freq.put("Cop", 40);
    freq.put("Cos", 33);
    freq.put("Cor", 70);
    freq.put("Cot", 7);
    freq.put("Ill", 17);
    freq.put("Com", 218);
    freq.put("Col", 58);
    freq.put("Coo", 12);
    freq.put("Con", 195);
    freq.put("Ai ", 11);
    freq.put("aç ", 21);
    freq.put("Aix", 118);
    freq.put("Air", 12);
    freq.put("Ain", 12);
    freq.put("aço", 7);
    freq.put("aça", 88);
    freq.put("Llà", 10);
    freq.put("Ep ", 7);
    freq.put("zz ", 9);
    freq.put("egs", 8);
    freq.put("Ath", 11);
    freq.put("aMi", 7);
    freq.put("Roi", 14);
    freq.put("Roj", 7);
    freq.put("Rom", 32);
    freq.put("Ron", 19);
    freq.put("aMa", 33);
    freq.put("Rob", 17);
    freq.put("Roc", 21);
    freq.put("aMe", 14);
    freq.put("Llu", 54);
    freq.put("Rog", 23);
    freq.put("Lli", 38);
    freq.put("Llo", 37);
    freq.put("Lla", 41);
    freq.put("Ros", 32);
    freq.put("Rot", 7);
    freq.put("Rov", 8);
    freq.put("wn ", 7);
    freq.put(" ut", 25);
    freq.put(" up", 14);
    freq.put(" ur", 22);
    freq.put(" us", 199);
    freq.put(" ul", 51);
    freq.put(" un", 2132);
    freq.put(" ui", 11);
    freq.put(" ue", 8);
    freq.put(" uf", 15);
    freq.put("ixi", 114);
    freq.put("xpo", 25);
    freq.put("ixo", 147);
    freq.put("xpl", 74);
    freq.put("ixa", 309);
    freq.put("xpe", 32);
    freq.put("ixe", 297);
    freq.put("grà", 126);
    freq.put("xpr", 29);
    freq.put("xpu", 18);
    freq.put("gré", 18);
    freq.put("wni", 7);
    freq.put(" u ", 35);
    freq.put("ix ", 512);
    freq.put("z", 1386);
    freq.put("gru", 70);
    freq.put("ixí", 94);
    freq.put("gre", 165);
    freq.put("gra", 671);
    freq.put("ixò", 320);
    freq.put("gro", 27);
    freq.put("gri", 42);
    freq.put("eda", 177);
    freq.put("ede", 140);
    freq.put("edi", 182);
    freq.put("LA ", 74);
    freq.put("edo", 65);
    freq.put("rrà", 12);
    freq.put("edr", 57);
    freq.put("edu", 88);
    freq.put("rró", 8);
    freq.put("FF ", 26);
    freq.put("edB", 9);
    freq.put("ugm", 17);
    freq.put("EH ", 7);
    freq.put("uga", 150);
    freq.put("ed ", 94);
    freq.put("P", 2786);
    freq.put("UA ", 13);
    freq.put("vos", 138);
    freq.put("iba", 167);
    freq.put("rro", 179);
    freq.put("CB ", 22);
    freq.put("rri", 292);
    freq.put("edè", 13);
    freq.put("víc", 7);
    freq.put("rra", 519);
    freq.put("ibe", 158);
    freq.put("rry", 10);
    freq.put("ugr", 15);
    freq.put("rru", 39);
    freq.put("rrr", 38);
    freq.put("bdn", 10);
    freq.put("mèr", 9);
    freq.put("CBa", 38);
    freq.put("èix", 26);
    freq.put("cf ", 8);
    freq.put("rr ", 11);
    freq.put("caa", 8);
    freq.put("ibu", 37);
    freq.put("apr", 104);
    freq.put("aps", 61);
    freq.put("app", 41);
    freq.put(" ol", 52);
    freq.put("apt", 31);
    freq.put("apu", 42);
    freq.put("api", 59);
    freq.put("apo", 93);
    freq.put("apl", 49);
    freq.put("Ud", 13);
    freq.put("NT ", 39);
    freq.put("apa", 205);
    freq.put("apg", 8);
    freq.put("apd", 19);
    freq.put("Mil", 42);
    freq.put("sió", 257);
    freq.put("feg", 20);
    freq.put("fed", 10);
    freq.put("fee", 7);
    freq.put("feb", 31);
    freq.put("fec", 64);
    freq.put("àdi", 23);
    freq.put("fen", 149);
    freq.put("Hum", 17);
    freq.put("fel", 146);
    freq.put("Min", 32);
    freq.put("usk", 9);
    freq.put("Hui", 11);
    freq.put("usi", 124);
    freq.put("fei", 106);
    freq.put("fet", 172);
    freq.put("feu", 26);
    freq.put("fer", 566);
    freq.put("fes", 185);
    freq.put("usq", 30);
    freq.put("usp", 33);
    freq.put("Mic", 10);
    freq.put("Gua", 56);
    freq.put("Gue", 16);
    freq.put(" ob", 182);
    freq.put("Gui", 39);
    freq.put("wi", 205);
    freq.put("ap ", 267);
    freq.put(" Ru", 42);
    freq.put("fe ", 44);
    freq.put("us ", 727);
    freq.put(" Re", 332);
    freq.put(" Ra", 160);
    freq.put(" Ro", 164);
    freq.put(" Ri", 99);
    freq.put("tat", 1344);
    freq.put("tau", 40);
    freq.put("tav", 97);
    freq.put("tap", 35);
    freq.put("taq", 18);
    freq.put("tar", 760);
    freq.put("tas", 96);
    freq.put("ífi", 21);
    freq.put("tax", 21);
    freq.put("tad", 172);
    freq.put("taf", 40);
    freq.put("tag", 45);
    freq.put("ièn", 51);
    freq.put("taa", 31);
    freq.put("tab", 58);
    freq.put("apí", 11);
    freq.put("tal", 1336);
    freq.put("tam", 354);
    freq.put("tan", 620);
    freq.put("tao", 8);
    freq.put(" ot", 7);
    freq.put("tak", 8);
    freq.put("sis", 111);
    freq.put("sir", 7);
    freq.put(" ou", 17);
    freq.put("taP", 8);
    freq.put("siv", 24);
    freq.put("siu", 28);
    freq.put("sit", 255);
    freq.put(" os", 50);
    freq.put("sic", 189);
    freq.put("sib", 92);
    freq.put("sia", 54);
    freq.put("sig", 166);
    freq.put("sif", 13);
    freq.put("sie", 20);
    freq.put("sid", 93);
    freq.put("taM", 8);
    freq.put("sii", 15);
    freq.put("sio", 146);
    freq.put("sin", 157);
    freq.put("sim", 105);
    freq.put("sil", 45);
    freq.put("ta ", 1953);
    freq.put("rú ", 7);
    freq.put("si ", 708);
    freq.put(" Rà", 11);
    freq.put("ws", 33);
    freq.put("na ", 2702);
    freq.put("Cas", 83);
    freq.put("Car", 189);
    freq.put("Cap", 61);
    freq.put("Ibe", 8);
    freq.put("Cat", 430);
    freq.put("Cai", 22);
    freq.put("Can", 94);
    freq.put("Cam", 101);
    freq.put("Cal", 85);
    freq.put("Cab", 17);
    freq.put("Caf", 8);
    freq.put("Cad", 28);
    freq.put("Pre", 113);
    freq.put("nfe", 50);
    freq.put("Pra", 31);
    freq.put("nfa", 48);
    freq.put("nfo", 163);
    freq.put("Pro", 91);
    freq.put("nfl", 15);
    freq.put("Pri", 41);
    freq.put("nfi", 60);
    freq.put("nfu", 16);
    freq.put("nfr", 11);
    freq.put("by ", 15);
    freq.put("oun", 23);
    freq.put("ous", 103);
    freq.put("our", 78);
    freq.put("oup", 7);
    freq.put("h ", 555);
    freq.put("out", 33);
    freq.put("cèn", 7);
    freq.put("cès", 12);
    freq.put("ouT", 13);
    freq.put("vaj", 8);
    freq.put("ou ", 351);
    freq.put("lts", 98);
    freq.put("ltr", 286);
    freq.put("val", 335);
    freq.put("g", 9144);
    freq.put("lta", 395);
    freq.put("lte", 173);
    freq.put("lti", 123);
    freq.put("lto", 28);
    freq.put("ü", 70);
    freq.put("SÍ ", 9);
    freq.put("K ", 102);
    freq.put("seq", 10);
    freq.put("Kc", 7);
    freq.put("Ka", 36);
    freq.put("Ke", 28);
    freq.put("Kd", 8);
    freq.put("Ki", 29);
    freq.put("Ko", 18);
    freq.put("Km", 14);
    freq.put("Ks", 9);
    freq.put("Kr", 7);
    freq.put("Kp", 9);
    freq.put("Ku", 9);
    freq.put("vas", 52);
    freq.put("tpr", 8);
    freq.put("Fod", 7);
    freq.put("aSe", 8);
    freq.put("aSi", 8);
    freq.put("sem", 268);
    freq.put("pèn", 9);
    freq.put("xre", 10);
    freq.put("tós", 7);
    freq.put("Dia", 58);
    freq.put("whe", 7);
    freq.put("wha", 12);
    freq.put("hw", 10);
    freq.put("Ò", 8);
    freq.put("ht", 3184);
    freq.put("pèd", 8);
    freq.put("Pot", 44);
    freq.put("Pou", 8);
    freq.put("Por", 47);
    freq.put("Pos", 19);
    freq.put("Pop", 16);
    freq.put("Pon", 13);
    freq.put("Pol", 44);
    freq.put("víd", 33);
    freq.put("Pod", 34);
    freq.put("Pob", 14);
    freq.put("Cha", 41);
    freq.put("NI ", 12);
    freq.put("ebé", 20);
    freq.put("ha", 1562);
    freq.put(" w ", 17);
    freq.put("eat", 89);
    freq.put("q ", 504);
    freq.put("qP", 9);
    freq.put("qS", 8);
    freq.put("qV", 7);
    freq.put("no ", 1652);
    freq.put("qZ", 8);
    freq.put("qA", 7);
    freq.put("qC", 7);
    freq.put("qB", 9);
    freq.put("qG", 7);
    freq.put("qF", 10);
    freq.put("qI", 9);
    freq.put("qO", 8);
    freq.put("qp", 10);
    freq.put("qs", 11);
    freq.put(" we", 65);
    freq.put("qu", 5512);
    freq.put("qt", 14);
    freq.put("qw", 8);
    freq.put(" wa", 19);
    freq.put("qy", 8);
    freq.put(" wo", 15);
    freq.put(" wh", 19);
    freq.put(" wi", 12);
    freq.put("qa", 11);
    freq.put(" ww", 16);
    freq.put("qc", 11);
    freq.put("qb", 10);
    freq.put("qe", 25);
    freq.put("hS", 14);
    freq.put("qi", 13);
    freq.put("qj", 7);
    freq.put("qm", 9);
    freq.put("qo", 8);
    freq.put("qn", 7);
    freq.put("ebe", 49);
    freq.put("eba", 174);
    freq.put("ebc", 11);
    freq.put("ebl", 18);
    freq.put("ebo", 58);
    freq.put("ebi", 8);
    freq.put("jo ", 233);
    freq.put("ebu", 33);
    freq.put("ebr", 113);
    freq.put("ebs", 8);
    freq.put("dle", 10);
    freq.put("mCa", 7);
    freq.put("Jac", 7);
    freq.put("dls", 7);
    freq.put("iot", 28);
    freq.put("jop", 11);
    freq.put("jor", 263);
    freq.put("jos", 58);
    freq.put("eb ", 125);
    freq.put("jou", 52);
    freq.put("jov", 42);
    freq.put("joy", 27);
    freq.put("joa", 93);
    freq.put("joc", 41);
    freq.put("jog", 11);
    freq.put("jol", 28);
    freq.put("jon", 21);
    freq.put("dl ", 28);
    freq.put("qü", 16);
    freq.put("rpr", 21);
    freq.put("CD ", 8);
    freq.put("òri", 121);
    freq.put("rpa", 9);
    freq.put("rpe", 12);
    freq.put("avé", 15);
    freq.put("rpi", 7);
    freq.put("òru", 7);
    freq.put("rpo", 13);
    freq.put("Jua", 30);
    freq.put("Jug", 10);
    freq.put("Jun", 21);
    freq.put("Jul", 15);
    freq.put("Jus", 11);
    freq.put("rBa", 14);
    freq.put("més", 692);
    freq.put("rp ", 11);
    freq.put("é", 2795);
    freq.put(" Tà", 15);
    freq.put("tja", 130);
    freq.put("avu", 249);
    freq.put("AR ", 40);
    freq.put("avo", 95);
    freq.put("avi", 420);
    freq.put("ave", 187);
    freq.put("ava", 365);
    freq.put(" és", 968);
    freq.put("àfi", 17);
    freq.put("MT ", 7);
    freq.put("uqu", 15);
    freq.put(" T ", 65);
    freq.put("Vul", 13);
    freq.put("av ", 7);
    freq.put("pde", 21);
    freq.put(" Tx", 13);
    freq.put(" Tw", 50);
    freq.put(" Tv", 7);
    freq.put(" Tu", 47);
    freq.put(" Tr", 139);
    freq.put(" To", 258);
    freq.put(" Ti", 90);
    freq.put(" Th", 32);
    freq.put(" Te", 213);
    freq.put(" Ta", 147);
    freq.put("mfa", 7);
    freq.put("tcu", 12);
    freq.put("eEs", 7);
    freq.put("íde", 53);
    freq.put("Ei ", 15);
    freq.put("tch", 19);
    freq.put("tca", 60);
    freq.put("Far", 17);
    freq.put("Fav", 8);
    freq.put("ske", 7);
    freq.put("skf", 14);
    freq.put("ska", 18);
    freq.put("nor", 96);
    freq.put("Fal", 49);
    freq.put("Fam", 9);
    freq.put("Fab", 24);
    freq.put("Fac", 37);
    freq.put("ski", 9);
    freq.put("¿", 9);
    freq.put("mf ", 9);
    freq.put("Eix", 14);
    freq.put("T", 1816);
    freq.put("tc ", 13);
    freq.put("ndè", 91);
    freq.put("ndà", 11);
    freq.put("eïn", 10);
    freq.put("ndú", 7);
    freq.put("Fa ", 19);
    freq.put("Sub", 12);
    freq.put(" xl", 9);
    freq.put("Sus", 7);
    freq.put("Sur", 10);
    freq.put("Sup", 26);
    freq.put("nd ", 37);
    freq.put("qe ", 12);
    freq.put("ndi", 284);
    freq.put("ndo", 112);
    freq.put("nda", 210);
    freq.put("nde", 438);
    freq.put("yós", 7);
    freq.put("ndp", 7);
    freq.put("ndr", 363);
    freq.put("ndu", 48);
    freq.put("own", 8);
    freq.put("owe", 18);
    freq.put("ows", 12);
    freq.put("Ami", 18);
    freq.put("vai", 103);
    freq.put("van", 255);
    freq.put("Amo", 12);
    freq.put("vam", 34);
    freq.put("Ama", 24);
    freq.put("vac", 45);
    freq.put("Amb", 81);
    freq.put("Ame", 21);
    freq.put("vag", 45);
    freq.put("vad", 80);
    freq.put("var", 120);
    freq.put("Amp", 13);
    freq.put("vap", 7);
    freq.put("Amu", 7);
    freq.put("vat", 78);
    freq.put("uct", 42);
    freq.put("ow ", 19);
    freq.put("Tel", 20);
    freq.put("Tem", 42);
    freq.put("Ten", 32);
    freq.put("íí", 9);
    freq.put("Am ", 10);
    freq.put("va ", 897);
    freq.put("Tec", 9);
    freq.put("lve", 57);
    freq.put("lva", 106);
    freq.put("Rà", 14);
    freq.put("Ter", 75);
    freq.put("lvi", 62);
    freq.put("lm ", 13);
    freq.put("í ", 585);
    freq.put("ejo", 18);
    freq.put("my ", 7);
    freq.put("íe", 35);
    freq.put("íd", 60);
    freq.put("íg", 9);
    freq.put("íf", 23);
    freq.put("ía", 87);
    freq.put("íc", 125);
    freq.put("ím", 27);
    freq.put("íl", 24);
    freq.put("ío", 7);
    freq.put("ín", 99);
    freq.put("oel", 11);
    freq.put("ít", 115);
    freq.put("ív", 8);
    freq.put("íp", 17);
    freq.put("ís", 234);
    freq.put("ír", 9);
  }
  
}

