package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class CS {
  private static final String name = "cs";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public CS() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 220388;
    n_words[1] = 266082;
    n_words[2] = 212927;

    freq.put("jmě", 25);
    freq.put("xtu", 11);
    freq.put("tít", 11);
    freq.put("xtr", 10);
    freq.put("tív", 3);
    freq.put("yšu", 3);
    freq.put("dnů", 7);
    freq.put("éru", 4);
    freq.put("éri", 7);
    freq.put("xte", 4);
    freq.put("éro", 5);
    freq.put("tíh", 8);
    freq.put("tík", 5);
    freq.put("tím", 93);
    freq.put("tín", 3);
    freq.put("řbi", 5);
    freq.put("mla", 12);
    freq.put("SP ", 4);
    freq.put("lé ", 57);
    freq.put("dně", 85);
    freq.put("péč", 4);
    freq.put("tí ", 160);
    freq.put("xt ", 4);
    freq.put("ér ", 8);
    freq.put("NO ", 3);
    freq.put("kná", 3);
    freq.put("hoř", 9);
    freq.put("upí", 13);
    freq.put("ědo", 9);
    freq.put("iTu", 11);
    freq.put("éry", 3);
    freq.put("lmu", 5);
    freq.put(" yo", 4);
    freq.put("k", 8084);
    freq.put("uča", 10);
    freq.put("ED ", 4);
    freq.put("hw", 6);
    freq.put("Lá", 4);
    freq.put("uce", 26);
    freq.put("Lí", 8);
    freq.put("RL ", 3);
    freq.put("aul", 9);
    freq.put("dne", 177);
    freq.put("dna", 19);
    freq.put("yšl", 14);
    freq.put("dno", 117);
    freq.put("voc", 5);
    freq.put("dni", 53);
    freq.put("yšo", 3);
    freq.put("tíž", 5);
    freq.put("dnu", 27);
    freq.put("tíš", 3);
    freq.put("vom", 8);
    freq.put("dny", 38);
    freq.put("von", 4);
    freq.put("jmy", 5);
    freq.put("jmu", 4);
    freq.put("yše", 19);
    freq.put("jmo", 5);
    freq.put("jme", 24);
    freq.put("vot", 39);
    freq.put(" čá", 17);
    freq.put(" čí", 37);
    freq.put("anč", 13);
    freq.put("Le", 32);
    freq.put("vor", 23);
    freq.put("La", 22);
    freq.put("Lo", 27);
    freq.put("Li", 58);
    freq.put("Lu", 17);
    freq.put("Ly", 4);
    freq.put("Jse", 29);
    freq.put("hod", 278);
    freq.put(" č ", 7);
    freq.put("hon", 50);
    freq.put("hoo", 4);
    freq.put("hol", 43);
    freq.put("hom", 13);
    freq.put("hoj", 11);
    freq.put("hok", 12);
    freq.put("hoh", 4);
    freq.put("hov", 77);
    freq.put("how", 8);
    freq.put("hot", 40);
    freq.put("hou", 40);
    freq.put("hor", 32);
    freq.put("hos", 26);
    freq.put("hop", 41);
    freq.put("dný", 18);
    freq.put("hoz", 6);
    freq.put("A", 567);
    freq.put("KY ", 3);
    freq.put("L ", 28);
    freq.put("jmé", 16);
    freq.put("cz ", 105);
    freq.put(" če", 142);
    freq.put(" ča", 65);
    freq.put("ho ", 517);
    freq.put(" čl", 58);
    freq.put(" čo", 3);
    freq.put(" či", 27);
    freq.put(" čt", 51);
    freq.put(" ču", 10);
    freq.put(" V ", 74);
    freq.put("eš ", 71);
    freq.put("íš ", 71);
    freq.put("zam", 31);
    freq.put("hu ", 77);
    freq.put("rům", 18);
    freq.put("fir", 29);
    freq.put("fit", 3);
    freq.put("rý", 96);
    freq.put("fix", 3);
    freq.put("ňuj", 12);
    freq.put("fic", 19);
    freq.put("smí", 14);
    freq.put("rá", 607);
    freq.put("Hig", 3);
    freq.put("rí", 3);
    freq.put("fin", 28);
    freq.put("ré", 82);
    freq.put("fil", 45);
    freq.put(" Va", 39);
    freq.put("ešk", 8);
    freq.put(" Ve", 48);
    freq.put("íšt", 19);
    freq.put("ešn", 31);
    freq.put(" Vi", 30);
    freq.put("eše", 21);
    freq.put(" Vl", 24);
    freq.put(" Vo", 25);
    freq.put("ané", 29);
    freq.put(" Vs", 6);
    freq.put(" Vu", 3);
    freq.put(" Vy", 50);
    freq.put(" Vz", 11);
    freq.put("ešt", 115);
    freq.put("ází", 14);
    freq.put("atá", 8);
    freq.put("atí", 49);
    freq.put("até", 3);
    freq.put("fi ", 7);
    freq.put("atý", 3);
    freq.put("sáž", 4);
    freq.put("íbi", 9);
    freq.put("íbe", 11);
    freq.put("rD", 3);
    freq.put("zat", 48);
    freq.put("íbr", 3);
    freq.put("rt", 238);
    freq.put("ru", 383);
    freq.put("rv", 192);
    freq.put("rp", 23);
    freq.put("smy", 13);
    freq.put("rs", 76);
    freq.put("dst", 58);
    freq.put("ry", 195);
    freq.put("rz", 103);
    freq.put("zas", 89);
    freq.put("rd", 120);
    freq.put("re", 605);
    freq.put("rf", 14);
    freq.put("rg", 42);
    freq.put("ra", 1403);
    freq.put("rb", 29);
    freq.put("rc", 63);
    freq.put("rl", 33);
    freq.put("rm", 122);
    freq.put("rn", 243);
    freq.put("dse", 7);
    freq.put("rh", 55);
    freq.put("ri", 332);
    freq.put("sma", 19);
    freq.put("rk", 130);
    freq.put(" Vá", 40);
    freq.put("eší", 18);
    freq.put("ial", 11);
    freq.put(" Ví", 34);
    freq.put("uť ", 6);
    freq.put(" Vý", 20);
    freq.put("ázi", 6);
    freq.put("atd", 4);
    freq.put("ázk", 35);
    freq.put("€ ", 3);
    freq.put("ázn", 12);
    freq.put("ázo", 9);
    freq.put("atn", 52);
    freq.put("áza", 23);
    freq.put("atl", 6);
    freq.put("ázd", 11);
    freq.put("áze", 36);
    freq.put("ath", 5);
    freq.put("ati", 105);
    freq.put("šíř", 5);
    freq.put("att", 12);
    freq.put("atu", 53);
    freq.put("r ", 408);
    freq.put("ats", 3);
    freq.put("ds ", 6);
    freq.put("aty", 6);
    freq.put("Duk", 5);
    freq.put("xic", 3);
    freq.put("Cen", 24);
    freq.put("Cel", 7);
    freq.put(" Vč", 12);
    freq.put("xim", 5);
    freq.put("xis", 12);
    freq.put("Ces", 6);
    freq.put("rci", 11);
    freq.put(" Vě", 17);
    freq.put(" Vš", 19);
    freq.put("WS ", 3);
    freq.put("mlá", 6);
    freq.put(" Vž", 7);
    freq.put("nzu", 6);
    freq.put("í", 5494);
    freq.put("arš", 8);
    freq.put("nza", 8);
    freq.put("nze", 15);
    freq.put("ýpa", 6);
    freq.put("nzi", 9);
    freq.put("bne", 6);
    freq.put("nzo", 6);
    freq.put("ší ", 284);
    freq.put("kna", 6);
    freq.put("rň", 3);
    freq.put("atě", 8);
    freq.put("tvů", 9);
    freq.put("Asp", 6);
    freq.put("rž", 40);
    freq.put("rť", 6);
    freq.put("rš", 29);
    freq.put("Sou", 22);
    freq.put("Asi", 18);
    freq.put("rů", 76);
    freq.put("nen", 120);
    freq.put("smě", 23);
    freq.put("šíl", 5);
    freq.put("šín", 6);
    freq.put("šíc", 27);
    freq.put("nem", 192);
    freq.put("rč", 32);
    freq.put("žů ", 7);
    freq.put("šít", 4);
    freq.put("atř", 19);
    freq.put("neg", 3);
    freq.put("nzí", 6);
    freq.put("né ", 241);
    freq.put("SE ", 6);
    freq.put("Mě ", 9);
    freq.put("Děl", 4);
    freq.put("zta", 7);
    freq.put("Děk", 12);
    freq.put("Dět", 6);
    freq.put("irá", 6);
    freq.put("ztr", 15);
    freq.put("néh", 43);
    freq.put("Měs", 6);
    freq.put("ném", 22);
    freq.put("yfo", 4);
    freq.put("néz", 3);
    freq.put("UX ", 3);
    freq.put("new", 4);
    freq.put("nér", 3);
    freq.put("X", 25);
    freq.put("Měl", 10);
    freq.put("zt ", 3);
    freq.put("nes", 263);
    freq.put("ášk", 18);
    freq.put("épe", 6);
    freq.put("PS ", 11);
    freq.put("dý ", 23);
    freq.put("ahá", 12);
    freq.put("mec", 26);
    freq.put("irt", 5);
    freq.put("iru", 5);
    freq.put("mem", 9);
    freq.put("irl", 3);
    freq.put("irm", 20);
    freq.put("iro", 22);
    freq.put("ira", 18);
    freq.put("ire", 23);
    freq.put("dýc", 6);
    freq.put("wtf", 3);
    freq.put("dýn", 8);
    freq.put("náj", 7);
    freq.put("ir ", 5);
    freq.put("áln", 142);
    freq.put("álo", 24);
    freq.put("řka", 6);
    freq.put("ana", 47);
    freq.put("fra", 7);
    freq.put("fre", 5);
    freq.put("šť ", 4);
    freq.put("fri", 6);
    freq.put("anc", 50);
    freq.put("fro", 4);
    freq.put("adc", 8);
    freq.put("ane", 75);
    freq.put("ann", 14);
    freq.put("ano", 71);
    freq.put("řko", 3);
    freq.put("úža", 7);
    freq.put("ani", 119);
    freq.put("bří", 4);
    freq.put("Ř", 33);
    freq.put("ank", 44);
    freq.put("ant", 42);
    freq.put("Nav", 6);
    freq.put("ans", 21);
    freq.put("Vžd", 7);
    freq.put("Ok", 9);
    freq.put("dho", 4);
    freq.put("frá", 3);
    freq.put("dhe", 8);
    freq.put("dha", 11);
    freq.put("bí", 111);
    freq.put("jky", 4);
    freq.put("bé", 5);
    freq.put("jko", 5);
    freq.put("bře", 35);
    freq.put("žňu", 5);
    freq.put("LO ", 3);
    freq.put("šci", 4);
    freq.put("sje", 3);
    freq.put("olá", 17);
    freq.put("olé", 3);
    freq.put("olí", 25);
    freq.put("ču ", 4);
    freq.put("bit", 21);
    freq.put("hah", 8);
    freq.put("haj", 19);
    freq.put("hal", 39);
    freq.put("ham", 13);
    freq.put("han", 18);
    freq.put("hac", 4);
    freq.put("had", 18);
    freq.put("haz", 12);
    freq.put("umá", 4);
    freq.put("hap", 5);
    freq.put("har", 10);
    freq.put("has", 7);
    freq.put("hat", 28);
    freq.put("hav", 8);
    freq.put("péc", 3);
    freq.put("čup", 4);
    freq.put("čur", 7);
    freq.put("už", 365);
    freq.put("čum", 4);
    freq.put("čuj", 13);
    freq.put("azů", 3);
    freq.put("ha ", 76);
    freq.put("ola", 43);
    freq.put("old", 14);
    freq.put("ole", 179);
    freq.put("olf", 4);
    freq.put("ejč", 5);
    freq.put("oli", 160);
    freq.put(" X ", 6);
    freq.put("oll", 18);
    freq.put("oln", 35);
    freq.put("olo", 64);
    freq.put("Vy ", 3);
    freq.put("ols", 6);
    freq.put("olt", 6);
    freq.put("olu", 45);
    freq.put("olv", 3);
    freq.put("oly", 25);
    freq.put("ýp", 15);
    freq.put("fot", 66);
    freq.put("fou", 4);
    freq.put("fov", 7);
    freq.put("ump", 6);
    freq.put("for", 56);
    freq.put("dů ", 13);
    freq.put("ěny", 4);
    freq.put("fox", 5);
    freq.put("ume", 16);
    freq.put("bné", 3);
    freq.put("uma", 19);
    freq.put("bní", 27);
    freq.put("foc", 3);
    freq.put("fol", 11);
    freq.put("fon", 46);
    freq.put("umn", 6);
    freq.put("umi", 6);
    freq.put("ěšn", 11);
    freq.put("ol ", 19);
    freq.put("Vys", 4);
    freq.put("Vyp", 11);
    freq.put("Ofi", 3);
    freq.put("Vyu", 4);
    freq.put(" Xa", 3);
    freq.put("ěns", 6);
    freq.put("Vyd", 6);
    freq.put("Vyh", 3);
    freq.put("bír", 13);
    freq.put("ěto", 5);
    freq.put("důl", 10);
    freq.put("dům", 6);
    freq.put("důc", 5);
    freq.put("o", 16596);
    freq.put("fo ", 9);
    freq.put("zhů", 5);
    freq.put("ípr", 7);
    freq.put("dův", 15);
    freq.put("mbl", 3);
    freq.put("soc", 10);
    freq.put("sob", 77);
    freq.put("mbi", 9);
    freq.put("sof", 12);
    freq.put("mbe", 3);
    freq.put("sok", 5);
    freq.put("sol", 7);
    freq.put("son", 8);
    freq.put("sop", 4);
    freq.put("sos", 3);
    freq.put("sor", 10);
    freq.put("Fer", 4);
    freq.put("Fes", 3);
    freq.put("sov", 46);
    freq.put("b ", 84);
    freq.put("mbr", 7);
    freq.put("ěti", 29);
    freq.put("az ", 31);
    freq.put("bně", 13);
    freq.put("so ", 6);
    freq.put("hač", 3);
    freq.put("ětk", 3);
    freq.put("azi", 23);
    freq.put("azk", 7);
    freq.put("azl", 3);
    freq.put("azm", 3);
    freq.put("azn", 18);
    freq.put("azo", 15);
    freq.put("aza", 16);
    freq.put("azd", 16);
    freq.put("aze", 45);
    freq.put("azy", 21);
    freq.put("azu", 18);
    freq.put("azv", 8);
    freq.put("ého", 165);
    freq.put("olš", 3);
    freq.put("umř", 6);
    freq.put("khl", 32);
    freq.put("ěte", 28);
    freq.put("xkl", 5);
    freq.put("žba", 6);
    freq.put("foť", 4);
    freq.put("žby", 6);
    freq.put("E", 150);
    freq.put("umě", 9);
    freq.put("Si ", 3);
    freq.put("Ú", 31);
    freq.put("azé", 4);
    freq.put("azí", 15);
    freq.put("olč", 3);
    freq.put("ů", 748);
    freq.put("lný", 19);
    freq.put("osp", 18);
    freq.put("oss", 4);
    freq.put("upř", 5);
    freq.put("osu", 15);
    freq.put("ost", 495);
    freq.put("osv", 4);
    freq.put("osi", 26);
    freq.put("osh", 3);
    freq.put("osk", 15);
    freq.put("osm", 19);
    freq.put("osl", 112);
    freq.put("oso", 40);
    freq.put("osa", 17);
    freq.put("ose", 15);
    freq.put("Maš", 5);
    freq.put("též", 3);
    freq.put("ver", 83);
    freq.put("ves", 44);
    freq.put("vez", 11);
    freq.put("ved", 74);
    freq.put("Ta ", 7);
    freq.put("vec", 11);
    freq.put("ven", 85);
    freq.put("vel", 83);
    freq.put("vem", 22);
    freq.put("vej", 26);
    freq.put("vek", 12);
    freq.put("Má", 48);
    freq.put("Mí", 10);
    freq.put("Mé", 4);
    freq.put("ydá", 10);
    freq.put("os ", 25);
    freq.put("Tat", 4);
    freq.put("Tad", 10);
    freq.put("tku", 35);
    freq.put("ve ", 167);
    freq.put("Tam", 4);
    freq.put("Tan", 3);
    freq.put("Tah", 3);
    freq.put("Tak", 137);
    freq.put("M ", 39);
    freq.put("záž", 5);
    freq.put("osí", 25);
    freq.put("neš", 57);
    freq.put("úto", 11);
    freq.put("úte", 11);
    freq.put("lná", 10);
    freq.put("géd", 4);
    freq.put("zrc", 3);
    freq.put("zra", 16);
    freq.put("zář", 21);
    freq.put("zro", 9);
    freq.put("rmí", 5);
    freq.put("Me", 38);
    freq.put("ydl", 9);
    freq.put("Ma", 118);
    freq.put("Mc", 3);
    freq.put("Mb", 3);
    freq.put("Ml", 8);
    freq.put("Mo", 57);
    freq.put("Mn", 5);
    freq.put("Mi", 62);
    freq.put("yda", 12);
    freq.put("Mu", 26);
    freq.put("uff", 6);
    freq.put("Mr", 3);
    freq.put("My", 22);
    freq.put("Mz", 4);
    freq.put("sů", 11);
    freq.put("sť", 9);
    freq.put("ipa", 9);
    freq.put("ipe", 4);
    freq.put("iph", 5);
    freq.put("ipn", 12);
    freq.put("ipo", 20);
    freq.put("ipl", 5);
    freq.put("évk", 3);
    freq.put("ipr", 14);
    freq.put("ipt", 4);
    freq.put("ipu", 6);
    freq.put("ipy", 5);
    freq.put("veň", 7);
    freq.put("Zře", 3);
    freq.put("tét", 4);
    freq.put("tér", 4);
    freq.put("tém", 40);
    freq.put("tén", 6);
    freq.put("téh", 4);
    freq.put("ték", 3);
    freq.put("ip ", 17);
    freq.put("yť ", 7);
    freq.put("mba", 7);
    freq.put("več", 27);
    freq.put("DO ", 4);
    freq.put("sé", 11);
    freq.put("sí", 199);
    freq.put("sá", 52);
    freq.put("té ", 67);
    freq.put("zán", 5);
    freq.put("zál", 12);
    freq.put("zám", 4);
    freq.put("záj", 21);
    freq.put("zák", 26);
    freq.put("záh", 3);
    freq.put("zád", 3);
    freq.put("záb", 14);
    freq.put("zác", 14);
    freq.put("záz", 5);
    freq.put("záv", 24);
    freq.put("ě", 3245);
    freq.put("zár", 7);
    freq.put("zás", 15);
    freq.put("záp", 17);
    freq.put("ST ", 8);
    freq.put("ydě", 7);
    freq.put("s ", 1039);
    freq.put("Mě", 25);
    freq.put("Mů", 15);
    freq.put("dná", 46);
    freq.put("ííí", 8);
    freq.put("sy", 51);
    freq.put("ss", 38);
    freq.put("sr", 45);
    freq.put("sp", 369);
    freq.put("sw", 4);
    freq.put("sso", 4);
    freq.put("su", 143);
    freq.put("st", 2108);
    freq.put("sk", 719);
    freq.put("sj", 3);
    freq.put("si", 735);
    freq.put("sh", 66);
    freq.put("so", 411);
    freq.put("sn", 249);
    freq.put("sm", 213);
    freq.put("sl", 515);
    freq.put("sc", 76);
    freq.put("sb", 19);
    freq.put("sa", 178);
    freq.put("sf", 6);
    freq.put("se", 1850);
    freq.put("sd", 18);
    freq.put("pít", 7);
    freq.put("pív", 7);
    freq.put("KA ", 3);
    freq.put("onů", 12);
    freq.put("pír", 9);
    freq.put("pís", 7);
    freq.put("dné", 27);
    freq.put("ttp", 9);
    freq.put("ětr", 3);
    freq.put("tto", 4);
    freq.put("Kam", 8);
    freq.put("ttl", 3);
    freq.put("pím", 6);
    freq.put("pín", 5);
    freq.put("Kal", 3);
    freq.put("tte", 54);
    freq.put("Jst", 5);
    freq.put("Krá", 20);
    freq.put("jic", 34);
    freq.put("jin", 70);
    freq.put("jil", 3);
    freq.put("jim", 28);
    freq.put("blí", 31);
    freq.put("jit", 20);
    freq.put("dje", 7);
    freq.put("jis", 51);
    freq.put("jiz", 3);
    freq.put("pší", 52);
    freq.put("hcí", 3);
    freq.put(" Zů", 4);
    freq.put("můž", 83);
    freq.put("Že", 17);
    freq.put("pí ", 14);
    freq.put("tt ", 4);
    freq.put("Ži", 4);
    freq.put("veb", 3);
    freq.put("ji ", 138);
    freq.put("onč", 43);
    freq.put("áci", 28);
    freq.put("šan", 7);
    freq.put("ácn", 3);
    freq.put("šak", 9);
    freq.put("ácl", 9);
    freq.put("oně", 9);
    freq.put(" Zř", 3);
    freq.put("áct", 5);
    freq.put("íců", 9);
    freq.put("Men", 5);
    freq.put("CZ ", 11);
    freq.put("Jos", 6);
    freq.put("blu", 7);
    freq.put("oň ", 26);
    freq.put("Job", 20);
    freq.put("bli", 37);
    freq.put("hce", 84);
    freq.put("Joh", 6);
    freq.put("pši", 4);
    freq.put("mód", 4);
    freq.put("bla", 21);
    freq.put("blb", 17);
    freq.put("náš", 39);
    freq.put("Žá", 3);
    freq.put("íně", 5);
    freq.put("ácí", 16);
    freq.put("Jo ", 18);
    freq.put("onk", 9);
    freq.put("oni", 45);
    freq.put("onn", 3);
    freq.put(" ří", 66);
    freq.put("onl", 15);
    freq.put(" řá", 5);
    freq.put("ona", 51);
    freq.put("onf", 7);
    freq.put(" Z ", 16);
    freq.put("ond", 37);
    freq.put("one", 111);
    freq.put("onz", 15);
    freq.put("ony", 25);
    freq.put("íní", 5);
    freq.put("ons", 27);
    freq.put("rzl", 3);
    freq.put("mů ", 23);
    freq.put("ont", 46);
    freq.put("onu", 30);
    freq.put("uky", 6);
    freq.put("rz ", 8);
    freq.put("uku", 5);
    freq.put("ukt", 6);
    freq.put("ukr", 13);
    freq.put("uko", 15);
    freq.put("Hmm", 4);
    freq.put("ukl", 11);
    freq.put("již", 15);
    freq.put("uke", 4);
    freq.put("ukc", 8);
    freq.put("uka", 23);
    freq.put(" Zm", 4);
    freq.put(" Zl", 14);
    freq.put(" Zn", 8);
    freq.put(" Zk", 9);
    freq.put(" Zj", 3);
    freq.put(" Ze", 24);
    freq.put(" Zd", 15);
    freq.put("on ", 91);
    freq.put(" Za", 73);
    freq.put("All", 4);
    freq.put(" Zb", 15);
    freq.put("můj", 22);
    freq.put("mům", 3);
    freq.put(" Zu", 3);
    freq.put(" Zv", 12);
    freq.put(" Zp", 57);
    freq.put("rze", 30);
    freq.put("rza", 5);
    freq.put("rzo", 8);
    freq.put("drž", 29);
    freq.put("oří", 20);
    freq.put("rzi", 18);
    freq.put("rzu", 6);
    freq.put("Hm ", 5);
    freq.put("rzy", 13);
    freq.put("uk ", 23);
    freq.put("sak", 10);
    freq.put(" ři", 11);
    freq.put("sah", 15);
    freq.put("san", 14);
    freq.put("sam", 37);
    freq.put("sal", 19);
    freq.put("Alb", 4);
    freq.put("oná", 17);
    freq.put(" ře", 69);
    freq.put("sad", 21);
    freq.put("saz", 6);
    freq.put("ínk", 9);
    freq.put("íno", 11);
    freq.put("sar", 3);
    freq.put("sav", 6);
    freq.put("sau", 4);
    freq.put("sat", 12);
    freq.put("zob", 10);
    freq.put("zoi", 3);
    freq.put("zol", 4);
    freq.put("áke", 6);
    freq.put("zon", 10);
    freq.put("zor", 28);
    freq.put("zou", 9);
    freq.put("zov", 46);
    freq.put("bů ", 8);
    freq.put("uká", 34);
    freq.put(" Zí", 3);
    freq.put("utí", 20);
    freq.put("sa ", 23);
    freq.put(" Zá", 16);
    freq.put("ín ", 17);
    freq.put(" Ce", 38);
    freq.put("zo ", 8);
    freq.put("rzí", 6);
    freq.put("axy", 10);
    freq.put("axa", 3);
    freq.put("axe", 6);
    freq.put("axi", 8);
    freq.put("ytu", 5);
    freq.put("íbí", 18);
    freq.put("Sky", 3);
    freq.put("Ska", 3);
    freq.put("Skl", 3);
    freq.put(" šť", 3);
    freq.put("způ", 10);
    freq.put("Cyk", 3);
    freq.put("níč", 11);
    freq.put("zpě", 12);
    freq.put("níž", 9);
    freq.put("AC ", 4);
    freq.put(" bá", 8);
    freq.put("agé", 4);
    freq.put(" bí", 8);
    freq.put(" bý", 43);
    freq.put("uv", 102);
    freq.put("up", 313);
    freq.put("us", 428);
    freq.put("ncí", 7);
    freq.put("ur", 241);
    freq.put("um", 177);
    freq.put(" b ", 7);
    freq.put("vku", 19);
    freq.put("un", 193);
    freq.put("vkl", 4);
    freq.put("vko", 9);
    freq.put("vka", 27);
    freq.put("uj", 413);
    freq.put("ciz", 8);
    freq.put(" be", 116);
    freq.put(" ba", 104);
    freq.put(" bl", 81);
    freq.put(" bo", 99);
    freq.put(" bi", 15);
    freq.put(" bu", 282);
    freq.put(" bt", 4);
    freq.put("s", 9343);
    freq.put(" br", 55);
    freq.put(" by", 482);
    freq.put("ivě", 11);
    freq.put("ivá", 7);
    freq.put("iví", 7);
    freq.put("ivé", 9);
    freq.put("Vše", 15);
    freq.put("yz ", 18);
    freq.put("ní ", 1203);
    freq.put("ivý", 12);
    freq.put(" ša", 9);
    freq.put(" še", 23);
    freq.put(" ši", 4);
    freq.put(" šk", 60);
    freq.put(" šl", 11);
    freq.put(" šm", 4);
    freq.put(" šo", 6);
    freq.put(" šp", 31);
    freq.put(" št", 9);
    freq.put(" pí", 26);
    freq.put("zpo", 23);
    freq.put("úro", 8);
    freq.put("Kre", 7);
    freq.put("zpe", 13);
    freq.put("nít", 6);
    freq.put("yzv", 4);
    freq.put("fie", 8);
    freq.put("níz", 12);
    freq.put("níd", 7);
    freq.put("níc", 78);
    freq.put("fik", 20);
    freq.put("yzi", 4);
    freq.put("ním", 122);
    freq.put("ník", 78);
    freq.put("níh", 50);
    freq.put("FS ", 4);
    freq.put("Kdo", 12);
    freq.put("Kde", 12);
    freq.put("Kdy", 48);
    freq.put("étn", 4);
    freq.put("ive", 36);
    freq.put("iva", 46);
    freq.put("ivc", 5);
    freq.put("ivn", 61);
    freq.put("ivo", 58);
    freq.put("ivi", 17);
    freq.put("ivk", 5);
    freq.put("ivt", 3);
    freq.put("ivu", 4);
    freq.put("íšu", 8);
    freq.put(" bě", 39);
    freq.put("ešl", 6);
    freq.put("ěry", 8);
    freq.put(" šá", 3);
    freq.put("UT ", 4);
    freq.put(" šé", 9);
    freq.put(" ší", 9);
    freq.put("zpí", 7);
    freq.put("iv ", 26);
    freq.put("I", 145);
    freq.put("Mar", 31);
    freq.put(" bř", 3);
    freq.put("íše", 17);
    freq.put("tvý", 6);
    freq.put("aga", 8);
    freq.put("ort", 31);
    freq.put("ezó", 9);
    freq.put("tví", 43);
    freq.put("tvé", 13);
    freq.put("tvá", 9);
    freq.put("ezá", 3);
    freq.put("pov", 64);
    freq.put(" ží", 3);
    freq.put(" žá", 27);
    freq.put("My ", 5);
    freq.put("ddá", 7);
    freq.put("Lás", 3);
    freq.put("Češ", 6);
    freq.put("NA ", 6);
    freq.put("Mys", 14);
    freq.put("ací", 42);
    freq.put("Ně", 28);
    freq.put("Man", 12);
    freq.put("aš", 130);
    freq.put("ať", 17);
    freq.put("oní", 10);
    freq.put("ezt", 3);
    freq.put("ezu", 4);
    freq.put("ezv", 14);
    freq.put("Těš", 6);
    freq.put("ezp", 15);
    freq.put("tvr", 49);
    freq.put("ezl", 8);
    freq.put("ezm", 9);
    freq.put("ezn", 39);
    freq.put("ezo", 12);
    freq.put("ezi", 48);
    freq.put("ezk", 34);
    freq.put("ezd", 28);
    freq.put("eze", 45);
    freq.put("tva", 11);
    freq.put("eza", 35);
    freq.put("ezb", 3);
    freq.put("až", 203);
    freq.put("ac ", 12);
    freq.put("aň", 13);
    freq.put(" ži", 47);
    freq.put("ddi", 3);
    freq.put("ddo", 3);
    freq.put("ohř", 3);
    freq.put(" ža", 6);
    freq.put(" že", 393);
    freq.put("xuá", 4);
    freq.put("zna", 80);
    freq.put("ez ", 72);
    freq.put("aca", 6);
    freq.put("ace", 170);
    freq.put("ack", 36);
    freq.put("aci", 53);
    freq.put("ach", 80);
    freq.put("ač", 241);
    freq.put("acn", 3);
    freq.put("aď", 7);
    freq.put("jiš", 7);
    freq.put("acu", 13);
    freq.put("act", 5);
    freq.put("Dne", 69);
    freq.put("Ni", 26);
    freq.put("bje", 30);
    freq.put("No", 129);
    freq.put("tky", 56);
    freq.put("Na", 128);
    freq.put("Ne", 204);
    freq.put("Nu", 5);
    freq.put("her", 38);
    freq.put("hes", 10);
    freq.put("hez", 22);
    freq.put("hec", 5);
    freq.put("hel", 12);
    freq.put("hem", 35);
    freq.put("Běh", 3);
    freq.put("hej", 8);
    freq.put("N ", 30);
    freq.put("šky", 9);
    freq.put("mpr", 4);
    freq.put("Čec", 9);
    freq.put("Ček", 10);
    freq.put("Čer", 8);
    freq.put("Čes", 46);
    freq.put("he ", 27);
    freq.put("aa", 30);
    freq.put("Hod", 6);
    freq.put("ab", 238);
    freq.put("ae", 4);
    freq.put("ůle", 7);
    freq.put("ag", 92);
    freq.put("af", 66);
    freq.put("Hon", 8);
    freq.put("ůli", 20);
    freq.put("Hol", 5);
    freq.put("ůlk", 5);
    freq.put("am", 594);
    freq.put("al", 1339);
    freq.put("ao", 10);
    freq.put("an", 876);
    freq.put("ap", 305);
    freq.put("as", 677);
    freq.put("ar", 536);
    freq.put("au", 138);
    freq.put("ohy", 4);
    freq.put("aw", 3);
    freq.put("av", 720);
    freq.put("ay", 36);
    freq.put("ax", 39);
    freq.put("az", 248);
    freq.put("ohr", 11);
    freq.put("aP", 5);
    freq.put("ško", 63);
    freq.put("ddě", 3);
    freq.put("a ", 4754);
    freq.put("oh ", 3);
    freq.put("šíč", 4);
    freq.put("agu", 12);
    freq.put("rr", 29);
    freq.put("agr", 7);
    freq.put("smu", 24);
    freq.put("Fir", 10);
    freq.put(" b", 1355);
    freq.put("sco", 5);
    freq.put("sci", 7);
    freq.put("sch", 35);
    freq.put("sce", 6);
    freq.put("sca", 10);
    freq.put("smr", 20);
    freq.put("mni", 3);
    freq.put("Fia", 4);
    freq.put(" dě", 120);
    freq.put("ží", 131);
    freq.put("Fid", 3);
    freq.put("mno", 33);
    freq.put("žá", 40);
    freq.put("Fin", 5);
    freq.put("mne", 11);
    freq.put("Fil", 6);
    freq.put("scr", 5);
    freq.put("smo", 5);
    freq.put("kům", 10);
    freq.put("ty", 314);
    freq.put("tv", 179);
    freq.put("tw", 50);
    freq.put("tt", 85);
    freq.put("tu", 567);
    freq.put("tr", 568);
    freq.put("ts", 44);
    freq.put("tp", 15);
    freq.put("zme", 10);
    freq.put("tn", 293);
    freq.put("to", 1857);
    freq.put("tl", 141);
    freq.put("sml", 6);
    freq.put("tk", 180);
    freq.put("th", 26);
    freq.put("ti", 815);
    freq.put("tf", 12);
    freq.put("td", 5);
    freq.put("te", 1719);
    freq.put("tb", 29);
    freq.put("tc", 35);
    freq.put("dsk", 10);
    freq.put("orc", 9);
    freq.put("smi", 8);
    freq.put("mýc", 6);
    freq.put(" dř", 14);
    freq.put("sme", 68);
    freq.put(" dů", 29);
    freq.put("ro", 1668);
    freq.put("ků ", 53);
    freq.put("ílé", 5);
    freq.put("ílí", 3);
    freq.put("dsa", 3);
    freq.put("t ", 1913);
    freq.put("ílý", 3);
    freq.put("scé", 7);
    freq.put("mný", 6);
    freq.put("žr", 9);
    freq.put("žs", 25);
    freq.put("žt", 12);
    freq.put("žu", 36);
    freq.put("žh", 3);
    freq.put("ži", 209);
    freq.put("žk", 33);
    freq.put("žm", 3);
    freq.put("žn", 107);
    freq.put("žo", 14);
    freq.put("ža", 26);
    freq.put("žb", 19);
    freq.put("žc", 4);
    freq.put("žd", 85);
    freq.put("že", 696);
    freq.put("xov", 3);
    freq.put("íl ", 25);
    freq.put("tý", 91);
    freq.put("tí", 297);
    freq.put("té", 133);
    freq.put("tá", 261);
    freq.put("sér", 11);
    freq.put("ýzn", 5);
    freq.put("ýzv", 3);
    freq.put("ž ", 604);
    freq.put("íla", 13);
    freq.put("íle", 26);
    freq.put("ílk", 3);
    freq.put("íli", 21);
    freq.put("ílo", 5);
    freq.put("ílu", 4);
    freq.put("vic", 40);
    freq.put("via", 44);
    freq.put("Aud", 3);
    freq.put("vid", 136);
    freq.put("tř", 231);
    freq.put("vik", 3);
    freq.put("vin", 80);
    freq.put("ůst", 14);
    freq.put("vil", 53);
    freq.put("vim", 19);
    freq.put("vir", 8);
    freq.put("vis", 28);
    freq.put("Aut", 14);
    freq.put("ůso", 15);
    freq.put("viz", 30);
    freq.put(" M", 497);
    freq.put("kl ", 25);
    freq.put("íší", 3);
    freq.put("tů", 45);
    freq.put("kůž", 3);
    freq.put("tš", 40);
    freq.put("vi ", 41);
    freq.put("tě", 458);
    freq.put("změ", 26);
    freq.put("tč", 3);
    freq.put("atc", 13);
    freq.put(" do", 808);
    freq.put(" dn", 179);
    freq.put(" dl", 60);
    freq.put("kla", 101);
    freq.put(" di", 107);
    freq.put(" de", 204);
    freq.put("klo", 27);
    freq.put(" dc", 6);
    freq.put("kli", 54);
    freq.put(" da", 147);
    freq.put("klu", 26);
    freq.put(" dy", 3);
    freq.put("ato", 34);
    freq.put(" dv", 74);
    freq.put(" du", 21);
    freq.put(" dr", 89);
    freq.put("žší", 13);
    freq.put("isp", 14);
    freq.put("atk", 24);
    freq.put("žů", 7);
    freq.put("žš", 15);
    freq.put("zny", 3);
    freq.put("tsi", 4);
    freq.put("úpr", 4);
    freq.put("žň", 5);
    freq.put("úpl", 16);
    freq.put("atr", 20);
    freq.put("tyř", 14);
    freq.put("Čín", 3);
    freq.put(" dí", 75);
    freq.put("klá", 23);
    freq.put(" dé", 7);
    freq.put("klí", 11);
    freq.put(" dá", 82);
    freq.put("afé", 3);
    freq.put("ázv", 6);
    freq.put("itn", 13);
    freq.put("ito", 57);
    freq.put("IP ", 6);
    freq.put("ká ", 132);
    freq.put("itk", 11);
    freq.put("iti", 47);
    freq.put("ite", 72);
    freq.put("itc", 4);
    freq.put("ita", 32);
    freq.put("ity", 22);
    freq.put("itt", 48);
    freq.put("itu", 39);
    freq.put("itr", 14);
    freq.put("its", 5);
    freq.put("UR ", 3);
    freq.put("wra", 3);
    freq.put("ráš", 6);
    freq.put("ješ", 80);
    freq.put("kác", 19);
    freq.put("trh", 32);
    freq.put("kán", 22);
    freq.put("it ", 355);
    freq.put("kál", 4);
    freq.put("kár", 4);
    freq.put("káv", 15);
    freq.put("kát", 15);
    freq.put("káz", 29);
    freq.put("jeď", 4);
    freq.put("ječ", 6);
    freq.put("tro", 94);
    freq.put("trn", 9);
    freq.put("šeš", 3);
    freq.put(" A ", 132);
    freq.put("ití", 8);
    freq.put("ité", 6);
    freq.put("itá", 19);
    freq.put("itý", 6);
    freq.put("TB ", 9);
    freq.put("ftw", 3);
    freq.put("at ", 447);
    freq.put(" Aa", 3);
    freq.put(" Ab", 10);
    freq.put(" Ac", 9);
    freq.put(" Ad", 6);
    freq.put(" Af", 4);
    freq.put(" Ag", 3);
    freq.put(" Ah", 18);
    freq.put(" Ai", 3);
    freq.put(" Ak", 33);
    freq.put(" Al", 92);
    freq.put(" Am", 18);
    freq.put(" An", 57);
    freq.put(" Ap", 38);
    freq.put(" Ar", 15);
    freq.put(" As", 30);
    freq.put(" At", 12);
    freq.put(" Au", 21);
    freq.put("Več", 3);
    freq.put("ft ", 11);
    freq.put("áči", 5);
    freq.put("w", 301);
    freq.put("HD ", 8);
    freq.put("trv", 13);
    freq.put("Fra", 9);
    freq.put("xik", 3);
    freq.put("Fre", 6);
    freq.put("uel", 4);
    freq.put("Č", 186);
    freq.put("jes", 48);
    freq.put("jep", 3);
    freq.put("jev", 20);
    freq.put("aa ", 5);
    freq.put("jet", 33);
    freq.put("jez", 22);
    freq.put("jec", 3);
    freq.put("jed", 210);
    freq.put("itř", 7);
    freq.put("jej", 36);
    freq.put("jek", 14);
    freq.put("jeh", 26);
    freq.put("jen", 185);
    freq.put("jel", 24);
    freq.put("jem", 97);
    freq.put("káš", 3);
    freq.put("ďar", 4);
    freq.put("káž", 10);
    freq.put("šes", 5);
    freq.put("šer", 3);
    freq.put("aaa", 13);
    freq.put("yhl", 19);
    freq.put("Blo", 3);
    freq.put("aak", 5);
    freq.put("je ", 890);
    freq.put("itě", 24);
    freq.put("aar", 4);
    freq.put("šeh", 7);
    freq.put("kář", 5);
    freq.put("šej", 3);
    freq.put("šem", 21);
    freq.put("šel", 46);
    freq.put("šen", 50);
    freq.put("yha", 4);
    freq.put("Špi", 5);
    freq.put("ex ", 15);
    freq.put("tp ", 10);
    freq.put("Bla", 13);
    freq.put(" Ať", 5);
    freq.put("M", 505);
    freq.put(" Až", 15);
    freq.put("Rád", 5);
    freq.put("exe", 3);
    freq.put("exk", 7);
    freq.put("exi", 20);
    freq.put("ext", 25);
    freq.put("exu", 14);
    freq.put("exp", 6);
    freq.put("ťte", 5);
    freq.put("exy", 5);
    freq.put("čá", 38);
    freq.put("Č ", 6);
    freq.put("ědě", 32);
    freq.put("čí", 189);
    freq.put("ůne", 6);
    freq.put("ědč", 8);
    freq.put("ojd", 6);
    freq.put("oje", 103);
    freq.put("oja", 3);
    freq.put("ojn", 4);
    freq.put("ojo", 11);
    freq.put("Har", 4);
    freq.put("ojm", 9);
    freq.put("ojk", 7);
    freq.put("Hav", 9);
    freq.put("oji", 22);
    freq.put("zké", 9);
    freq.put("zká", 4);
    freq.put("zký", 7);
    freq.put("rf ", 3);
    freq.put("am ", 210);
    freq.put("lás", 32);
    freq.put("ps ", 10);
    freq.put("ždě", 10);
    freq.put("Če", 82);
    freq.put("Ča", 7);
    freq.put("Čl", 10);
    freq.put("Čt", 10);
    freq.put("Ču", 4);
    freq.put("oj ", 35);
    freq.put("rfu", 4);
    freq.put("cra", 3);
    freq.put("rfe", 5);
    freq.put("cre", 5);
    freq.put("cro", 10);
    freq.put("če", 383);
    freq.put("sev", 4);
    freq.put("set", 40);
    freq.put("ča", 159);
    freq.put("ser", 56);
    freq.put("For", 5);
    freq.put("čl", 63);
    freq.put("čo", 29);
    freq.put("čn", 267);
    freq.put("či", 183);
    freq.put("sez", 25);
    freq.put("čk", 171);
    freq.put("sex", 17);
    freq.put("ču", 33);
    freq.put("sef", 6);
    freq.put("sed", 36);
    freq.put("sec", 12);
    freq.put("seb", 23);
    freq.put("ojá", 10);
    freq.put("Fol", 4);
    freq.put("sen", 26);
    freq.put("sem", 486);
    freq.put("sel", 55);
    freq.put("sek", 32);
    freq.put("sej", 10);
    freq.put("seh", 7);
    freq.put("zkl", 10);
    freq.put("zko", 38);
    freq.put("zka", 25);
    freq.put("zky", 20);
    freq.put("tiz", 7);
    freq.put("zku", 39);
    freq.put("NĚ ", 3);
    freq.put("voř", 18);
    freq.put("zkr", 13);
    freq.put("ťák", 7);
    freq.put("č ", 176);
    freq.put("lel", 23);
    freq.put("ťác", 4);
    freq.put("Čí", 9);
    freq.put("ue ", 8);
    freq.put("se ", 975);
    freq.put("pda", 8);
    freq.put("ým ", 84);
    freq.put("lex", 7);
    freq.put("ojů", 4);
    freq.put("ždy", 24);
    freq.put("ml ", 8);
    freq.put("tiv", 67);
    freq.put("ždo", 12);
    freq.put("ěd ", 10);
    freq.put("tré", 14);
    freq.put("íje", 25);
    freq.put(" fó", 4);
    freq.put("kní", 5);
    freq.put("kné", 10);
    freq.put("íjm", 6);
    freq.put("íjn", 10);
    freq.put("mlo", 14);
    freq.put("Olo", 6);
    freq.put(" fá", 3);
    freq.put("kný", 7);
    freq.put("ědi", 3);
    freq.put("mlu", 31);
    freq.put("ěde", 4);
    freq.put("ojč", 3);
    freq.put("ěda", 9);
    freq.put("vod", 70);
    freq.put("voe", 4);
    freq.put("tmi", 4);
    freq.put("vob", 6);
    freq.put("psk", 16);
    freq.put("vol", 94);
    freq.put("sež", 5);
    freq.put("čů", 3);
    freq.put("voj", 47);
    freq.put("vok", 3);
    freq.put("hé ", 21);
    freq.put("vou", 107);
    freq.put("vov", 27);
    freq.put("vop", 6);
    freq.put("seš", 8);
    freq.put("vos", 17);
    freq.put("voz", 18);
    freq.put("zků", 5);
    freq.put("ždý", 21);
    freq.put("amo", 42);
    freq.put("amn", 10);
    freq.put("ždé", 7);
    freq.put("ždí", 6);
    freq.put("trý", 3);
    freq.put("amb", 15);
    freq.put("vo ", 56);
    freq.put("héh", 4);
    freq.put("loč", 5);
    freq.put("hém", 7);
    freq.put("kno", 25);
    freq.put(" fr", 21);
    freq.put(" fu", 56);
    freq.put("kni", 35);
    freq.put(" fy", 3);
    freq.put("kne", 24);
    freq.put("Sol", 4);
    freq.put("kle", 28);
    freq.put(" fa", 94);
    freq.put("ědí", 4);
    freq.put(" fb", 3);
    freq.put(" fe", 12);
    freq.put(" fi", 83);
    freq.put("knu", 17);
    freq.put(" fl", 9);
    freq.put(" fo", 102);
    freq.put("O ", 72);
    freq.put("uč", 78);
    freq.put("ijá", 3);
    freq.put("uď", 11);
    freq.put(" Dl", 4);
    freq.put("ijí", 7);
    freq.put("náb", 4);
    freq.put("nác", 12);
    freq.put("ří", 451);
    freq.put("nád", 13);
    freq.put("řá", 68);
    freq.put("nák", 9);
    freq.put("náh", 12);
    freq.put("nán", 16);
    freq.put("nál", 40);
    freq.put("nám", 92);
    freq.put("nár", 24);
    freq.put("nás", 51);
    freq.put("náp", 16);
    freq.put("náv", 40);
    freq.put("nát", 10);
    freq.put("náz", 18);
    freq.put("ásl", 9);
    freq.put("On", 23);
    freq.put("Om", 4);
    freq.put("Ol", 6);
    freq.put("uř", 22);
    freq.put("bá", 39);
    freq.put("Oh", 3);
    freq.put("Of", 8);
    freq.put("Od", 31);
    freq.put("Oc", 8);
    freq.put("Ob", 32);
    freq.put("bý", 72);
    freq.put("Ot", 12);
    freq.put("Os", 21);
    freq.put("Or", 20);
    freq.put("Op", 24);
    freq.put("ná ", 219);
    freq.put("Ři", 3);
    freq.put("d", 8039);
    freq.put("Řa", 3);
    freq.put("Ře", 18);
    freq.put("uť", 6);
    freq.put("uš", 136);
    freq.put("ijt", 3);
    freq.put("iju", 7);
    freq.put("šíh", 13);
    freq.put("říž", 8);
    freq.put("říš", 25);
    freq.put("ija", 8);
    freq.put("ijd", 17);
    freq.put("ije", 35);
    freq.put("iji", 3);
    freq.put("Vel", 10);
    freq.put("ijn", 3);
    freq.put("ři", 399);
    freq.put("řk", 12);
    freq.put("řj", 4);
    freq.put("řm", 4);
    freq.put("řo", 11);
    freq.put("řn", 7);
    freq.put("řa", 31);
    freq.put("yž ", 124);
    freq.put("řb", 7);
    freq.put("ře", 862);
    freq.put("UP ", 3);
    freq.put("řs", 22);
    freq.put("řu", 15);
    freq.put("řt", 3);
    freq.put("bd", 7);
    freq.put("be", 314);
    freq.put("ba", 311);
    freq.put("bb", 6);
    freq.put("bc", 37);
    freq.put("bl", 240);
    freq.put("bn", 74);
    freq.put("bo", 450);
    freq.put("bi", 182);
    freq.put("bj", 30);
    freq.put("bk", 13);
    freq.put("bt", 10);
    freq.put("bu", 456);
    freq.put("bv", 8);
    freq.put("bp", 3);
    freq.put("br", 207);
    freq.put("bs", 49);
    freq.put("by", 734);
    freq.put("Fu", 11);
    freq.put("Ří", 6);
    freq.put("ř ", 64);
    freq.put("Řá", 3);
    freq.put("Ost", 11);
    freq.put("šků", 7);
    freq.put("ťov", 6);
    freq.put(" C ", 12);
    freq.put("afá", 3);
    freq.put("nář", 22);
    freq.put("Oč", 8);
    freq.put("ci ", 294);
    freq.put("Fa", 48);
    freq.put("Líb", 5);
    freq.put("u ", 2856);
    freq.put("Fe", 9);
    freq.put(" Ch", 67);
    freq.put(" Ci", 16);
    freq.put(" Co", 58);
    freq.put(" Cl", 5);
    freq.put("uT", 3);
    freq.put(" Ca", 15);
    freq.put("náč", 6);
    freq.put(" Cz", 6);
    freq.put(" Cy", 3);
    freq.put("Fi", 35);
    freq.put(" Cr", 13);
    freq.put(" Cu", 6);
    freq.put("cia", 10);
    freq.put("ádí", 6);
    freq.put("ux", 18);
    freq.put("cie", 23);
    freq.put("uz", 162);
    freq.put("uu", 6);
    freq.put("ut", 365);
    freq.put("cii", 8);
    freq.put("cih", 3);
    freq.put("cio", 7);
    freq.put("cin", 9);
    freq.put("cim", 3);
    freq.put("cil", 7);
    freq.put("cis", 15);
    freq.put("ul", 217);
    freq.put("uo", 4);
    freq.put("cip", 4);
    freq.put("ui", 9);
    freq.put("uh", 153);
    freq.put("uk", 173);
    freq.put("cit", 26);
    freq.put("ue", 20);
    freq.put("ud", 557);
    freq.put("ug", 9);
    freq.put("uf", 34);
    freq.put("ua", 32);
    freq.put("uc", 156);
    freq.put("ub", 130);
    freq.put("říp", 24);
    freq.put("řís", 26);
    freq.put("řír", 6);
    freq.put("ózn", 4);
    freq.put("řít", 26);
    freq.put("řív", 20);
    freq.put("říz", 24);
    freq.put("říc", 19);
    freq.put("říb", 10);
    freq.put("říd", 28);
    freq.put("říh", 3);
    freq.put("řík", 51);
    freq.put("říj", 37);
    freq.put("řím", 30);
    freq.put("říl", 21);
    freq.put("řín", 5);
    freq.put("tic", 73);
    freq.put("řů", 9);
    freq.put("bč", 16);
    freq.put("ag ", 9);
    freq.put("jce", 13);
    freq.put("jch", 5);
    freq.put("bě", 146);
    freq.put("bů", 12);
    freq.put("amu", 20);
    freq.put("ůů", 6);
    freq.put("ří ", 85);
    freq.put("zaj", 59);
    freq.put("zín", 5);
    freq.put("ago", 7);
    freq.put("agn", 5);
    freq.put("ciá", 19);
    freq.put("agi", 8);
    freq.put("škr", 5);
    freq.put("age", 24);
    freq.put("šku", 15);
    freq.put("jc ", 6);
    freq.put("ška", 24);
    freq.put("uá", 38);
    freq.put("bř", 41);
    freq.put("ške", 3);
    freq.put("ijď", 12);
    freq.put("mým", 5);
    freq.put("Jin", 10);
    freq.put("Jih", 5);
    freq.put("odí", 43);
    freq.put("mýt", 4);
    freq.put("bvi", 7);
    freq.put("vzd", 18);
    freq.put("ev ", 17);
    freq.put("tr ", 22);
    freq.put("ěme", 16);
    freq.put("mý ", 10);
    freq.put("tri", 25);
    freq.put("evi", 71);
    freq.put("evk", 4);
    freq.put("evm", 3);
    freq.put("evn", 27);
    freq.put("evo", 24);
    freq.put("tra", 197);
    freq.put("eva", 23);
    freq.put("tre", 38);
    freq.put("eve", 31);
    freq.put("try", 7);
    freq.put("evy", 33);
    freq.put("evz", 5);
    freq.put("zít", 34);
    freq.put("rdí", 12);
    freq.put("evr", 9);
    freq.put("tru", 26);
    freq.put("evu", 4);
    freq.put("Čas", 3);
    freq.put("le ", 765);
    freq.put("ody", 24);
    freq.put("odz", 14);
    freq.put("Blu", 3);
    freq.put("odr", 19);
    freq.put("ods", 28);
    freq.put("odt", 6);
    freq.put("odu", 53);
    freq.put("odv", 13);
    freq.put("odh", 14);
    freq.put("odi", 105);
    freq.put("odj", 6);
    freq.put("odk", 15);
    freq.put("odl", 74);
    freq.put("odm", 12);
    freq.put("odn", 149);
    freq.put("odo", 57);
    freq.put("Ble", 5);
    freq.put("oda", 74);
    freq.put("odb", 11);
    freq.put("odc", 8);
    freq.put("odd", 6);
    freq.put("ode", 93);
    freq.put("odf", 3);
    freq.put("bni", 4);
    freq.put("cna", 3);
    freq.put("ct ", 29);
    freq.put("rd ", 34);
    freq.put("lea", 3);
    freq.put("leb", 9);
    freq.put("lec", 42);
    freq.put("led", 204);
    freq.put("lef", 37);
    freq.put("leg", 19);
    freq.put("leh", 22);
    freq.put("lej", 57);
    freq.put("lek", 47);
    freq.put("ůh ", 6);
    freq.put("lem", 57);
    freq.put("len", 128);
    freq.put("lep", 85);
    freq.put("ler", 26);
    freq.put("les", 54);
    freq.put("let", 159);
    freq.put("lev", 72);
    freq.put("od ", 197);
    freq.put("ley", 4);
    freq.put("lez", 32);
    freq.put("rdu", 11);
    freq.put("ctv", 15);
    freq.put("eví", 47);
    freq.put("rds", 3);
    freq.put("trá", 62);
    freq.put("evá", 4);
    freq.put("rdy", 7);
    freq.put("cty", 4);
    freq.put("rde", 10);
    freq.put("cte", 6);
    freq.put("rda", 6);
    freq.put("rdc", 3);
    freq.put("rdo", 5);
    freq.put("cto", 8);
    freq.put("rdi", 18);
    freq.put("cti", 8);
    freq.put("trč", 4);
    freq.put("mýš", 14);
    freq.put("evě", 14);
    freq.put("Již", 5);
    freq.put("ziv", 21);
    freq.put("zit", 33);
    freq.put("ziu", 4);
    freq.put("zir", 3);
    freq.put("zid", 6);
    freq.put("zie", 3);
    freq.put("zib", 3);
    freq.put("zic", 15);
    freq.put("zin", 13);
    freq.put("zil", 20);
    freq.put("zim", 32);
    freq.put("zik", 10);
    freq.put("Jiř", 5);
    freq.put("evř", 13);
    freq.put("oťá", 6);
    freq.put("oče", 28);
    freq.put("trů", 8);
    freq.put("evš", 8);
    freq.put(" zv", 81);
    freq.put("íhá", 6);
    freq.put("očk", 22);
    freq.put("zi ", 66);
    freq.put("trž", 6);
    freq.put("zí ", 47);
    freq.put("oz ", 9);
    freq.put("xce", 4);
    freq.put("očn", 33);
    freq.put("odů", 7);
    freq.put("oť ", 3);
    freq.put("cni", 9);
    freq.put("On ", 4);
    freq.put("leč", 45);
    freq.put("leš", 5);
    freq.put("Q", 5);
    freq.put("afo", 16);
    freq.put("lež", 21);
    freq.put("ího", 87);
    freq.put("odě", 25);
    freq.put("Ono", 4);
    freq.put("Onl", 4);
    freq.put("Ond", 4);
    freq.put("íha", 7);
    freq.put("afe", 13);
    freq.put("ún", 7);
    freq.put("úh", 3);
    freq.put("úk", 3);
    freq.put("úd", 9);
    freq.put("táž", 7);
    freq.put("TY ", 3);
    freq.put("nés", 3);
    freq.put("út", 23);
    freq.put("ády", 7);
    freq.put("úp", 20);
    freq.put("úr", 9);
    freq.put("ús", 26);
    freq.put("tář", 11);
    freq.put(" h ", 10);
    freq.put("Zná", 4);
    freq.put("aft", 6);
    freq.put("lzn", 3);
    freq.put("lze", 17);
    freq.put("Sak", 8);
    freq.put(" hy", 3);
    freq.put("San", 10);
    freq.put("Sam", 16);
    freq.put("éně", 14);
    freq.put(" hr", 102);
    freq.put(" hv", 6);
    freq.put(" hu", 33);
    freq.put(" ht", 15);
    freq.put(" hi", 14);
    freq.put(" ho", 296);
    freq.put(" hn", 30);
    freq.put(" hm", 7);
    freq.put(" hl", 96);
    freq.put("táč", 5);
    freq.put(" ha", 37);
    freq.put(" he", 61);
    freq.put("pár", 33);
    freq.put("pát", 37);
    freq.put("Bůh", 4);
    freq.put("zap", 53);
    freq.put(" há", 9);
    freq.put("tát", 42);
    freq.put("táv", 32);
    freq.put("ihy", 8);
    freq.put("ény", 4);
    freq.put("énu", 4);
    freq.put("IT ", 10);
    freq.put("ihu", 7);
    freq.put("úž", 7);
    freq.put("om ", 98);
    freq.put("ihn", 14);
    freq.put("iho", 19);
    freq.put("ihl", 26);
    freq.put("lph", 4);
    freq.put("tál", 51);
    freq.put("éne", 3);
    freq.put("tán", 14);
    freq.put("iha", 7);
    freq.put("táh", 12);
    freq.put("éna", 11);
    freq.put("ták", 14);
    freq.put("amě", 27);
    freq.put("pác", 3);
    freq.put("úř", 3);
    freq.put("tká", 13);
    freq.put(" hř", 18);
    freq.put("loz", 6);
    freq.put("tá ", 25);
    freq.put("én ", 3);
    freq.put("úč", 37);
    freq.put("cká", 27);
    freq.put("cké", 69);
    freq.put("cký", 61);
    freq.put("ý", 1384);
    freq.put(" E ", 19);
    freq.put("éná", 3);
    freq.put("ck ", 25);
    freq.put("SL ", 5);
    freq.put(" El", 7);
    freq.put(" En", 7);
    freq.put(" Ed", 3);
    freq.put(" Ex", 15);
    freq.put(" Eu", 8);
    freq.put(" Ev", 29);
    freq.put(" Ep", 3);
    freq.put(" Er", 9);
    freq.put("cke", 12);
    freq.put("cka", 23);
    freq.put("ckl", 3);
    freq.put("cko", 32);
    freq.put("ckn", 4);
    freq.put("cku", 9);
    freq.put("ckr", 3);
    freq.put("cky", 50);
    freq.put("ců", 28);
    freq.put("dbo", 10);
    freq.put("dba", 9);
    freq.put("dby", 5);
    freq.put("Pá", 8);
    freq.put("dbu", 5);
    freq.put("un ", 12);
    freq.put("jaz", 9);
    freq.put("jat", 3);
    freq.put("jas", 19);
    freq.put("jap", 3);
    freq.put("jan", 3);
    freq.put("jak", 419);
    freq.put("jad", 3);
    freq.put("ák ", 33);
    freq.put("jab", 4);
    freq.put("ši ", 21);
    freq.put("hla", 134);
    freq.put("áky", 8);
    freq.put("šiz", 3);
    freq.put("h", 4421);
    freq.put("áku", 18);
    freq.put("etý", 7);
    freq.put("šim", 14);
    freq.put("šil", 21);
    freq.put("etá", 8);
    freq.put("áko", 15);
    freq.put("ákl", 9);
    freq.put("áka", 23);
    freq.put("ůjč", 10);
    freq.put("ael", 3);
    freq.put("ja ", 21);
    freq.put("etí", 33);
    freq.put("Pr", 281);
    freq.put("vš", 138);
    freq.put("btw", 4);
    freq.put("Pt", 5);
    freq.put("Pu", 5);
    freq.put("oma", 63);
    freq.put("vů", 68);
    freq.put("Pa", 94);
    freq.put("OP ", 12);
    freq.put("Pe", 38);
    freq.put("Ph", 48);
    freq.put("Pi", 20);
    freq.put("Po", 206);
    freq.put("vž", 18);
    freq.put("et ", 157);
    freq.put("tl ", 19);
    freq.put("vř", 24);
    freq.put("lf", 6);
    freq.put("P ", 86);
    freq.put("eun", 3);
    freq.put("tsk", 25);
    freq.put("etr", 35);
    freq.put("ets", 6);
    freq.put("etv", 3);
    freq.put("etw", 5);
    freq.put("ett", 7);
    freq.put("etu", 32);
    freq.put("ety", 24);
    freq.put("vč", 24);
    freq.put("etb", 7);
    freq.put("tla", 19);
    freq.put("eta", 43);
    freq.put("tle", 28);
    freq.put("lo", 970);
    freq.put("etk", 9);
    freq.put("tli", 56);
    freq.put("eti", 38);
    freq.put("etn", 19);
    freq.put("eto", 38);
    freq.put("etl", 18);
    freq.put("ck", 327);
    freq.put("vá", 467);
    freq.put("ci", 459);
    freq.put("ch", 1724);
    freq.put("co", 392);
    freq.put("cn", 51);
    freq.put("cm", 12);
    freq.put("cl", 21);
    freq.put("cc", 28);
    freq.put("vé", 274);
    freq.put("ca", 84);
    freq.put("ví", 350);
    freq.put("ce", 992);
    freq.put("šič", 3);
    freq.put("cz", 150);
    freq.put("ůjd", 14);
    freq.put("uří", 3);
    freq.put("Hea", 3);
    freq.put("uca", 4);
    freq.put("cs", 6);
    freq.put("cr", 20);
    freq.put("cp", 3);
    freq.put("Heh", 3);
    freq.put("vý", 343);
    freq.put("cu", 34);
    freq.put("ct", 77);
    freq.put("Geo", 3);
    freq.put("Gen", 3);
    freq.put("vý ", 129);
    freq.put("dše", 6);
    freq.put("lgi", 5);
    freq.put("šiř", 3);
    freq.put("ěžo", 3);
    freq.put("ňa ", 3);
    freq.put("c ", 416);
    freq.put("dši", 7);
    freq.put("Sen", 6);
    freq.put("ůj ", 44);
    freq.put("uc ", 5);
    freq.put("unu", 7);
    freq.put("euv", 8);
    freq.put("výz", 9);
    freq.put("výv", 12);
    freq.put("výt", 3);
    freq.put("výr", 20);
    freq.put("výs", 19);
    freq.put("výp", 9);
    freq.put("rbo", 6);
    freq.put("dbě", 4);
    freq.put("vým", 24);
    freq.put("áků", 10);
    freq.put("výk", 6);
    freq.put("rbi", 4);
    freq.put("cvi", 7);
    freq.put("rbe", 3);
    freq.put("ly", 205);
    freq.put("výb", 18);
    freq.put("výc", 44);
    freq.put("rba", 9);
    freq.put("va", 821);
    freq.put("vb", 13);
    freq.put("vc", 25);
    freq.put("vd", 50);
    freq.put("ve", 706);
    freq.put("cí", 208);
    freq.put("vh", 7);
    freq.put("etě", 11);
    freq.put("cá", 8);
    freq.put("vk", 87);
    freq.put("vl", 138);
    freq.put("vm", 3);
    freq.put("vn", 344);
    freq.put("vo", 556);
    freq.put("vp", 5);
    freq.put("vr", 133);
    freq.put("vs", 77);
    freq.put("vt", 23);
    freq.put("vu", 94);
    freq.put("vy", 577);
    freq.put("vz", 80);
    freq.put("Pů", 5);
    freq.put("of ", 11);
    freq.put("Př", 115);
    freq.put("und", 13);
    freq.put("rťa", 5);
    freq.put("v ", 793);
    freq.put("pho", 12);
    freq.put("eál", 11);
    freq.put("dší", 3);
    freq.put("pha", 4);
    freq.put("etř", 26);
    freq.put("dak", 6);
    freq.put("off", 3);
    freq.put("ofe", 5);
    freq.put("Pě", 9);
    freq.put("ofi", 16);
    freq.put("dav", 23);
    freq.put("unn", 3);
    freq.put("oft", 12);
    freq.put("umo", 15);
    freq.put("ěh ", 6);
    freq.put("xem", 3);
    freq.put("Až ", 15);
    freq.put("Jso", 4);
    freq.put("web", 46);
    freq.put("Můž", 7);
    freq.put("wee", 17);
    freq.put("gum", 4);
    freq.put("ív ", 17);
    freq.put("wer", 7);
    freq.put("xe ", 6);
    freq.put("ěhn", 9);
    freq.put("ěho", 3);
    freq.put("ěha", 3);
    freq.put("ěhe", 16);
    freq.put("nve", 19);
    freq.put("ýdn", 12);
    freq.put("yov", 3);
    freq.put("ýde", 22);
    freq.put("mhl", 8);
    freq.put(" jí", 50);
    freq.put("íva", 37);
    freq.put("kré", 4);
    freq.put(" jé", 3);
    freq.put("íve", 9);
    freq.put("ívi", 3);
    freq.put("ívk", 5);
    freq.put(" já", 119);
    freq.put("vst", 19);
    freq.put("AT ", 4);
    freq.put("Saf", 3);
    freq.put("vse", 10);
    freq.put("vsi", 3);
    freq.put("Sad", 4);
    freq.put("ahr", 33);
    freq.put("ěhá", 3);
    freq.put("lle", 12);
    freq.put("vs ", 10);
    freq.put("kry", 7);
    freq.put("Sch", 13);
    freq.put("ině", 21);
    freq.put(" ju", 4);
    freq.put("krv", 3);
    freq.put(" js", 608);
    freq.put("kru", 11);
    freq.put(" jm", 13);
    freq.put("ívá", 26);
    freq.put(" jo", 59);
    freq.put("kri", 22);
    freq.put(" ji", 165);
    freq.put("kro", 30);
    freq.put(" jj", 7);
    freq.put(" je", 1169);
    freq.put(" jd", 32);
    freq.put("kra", 80);
    freq.put(" ja", 369);
    freq.put("kre", 22);
    freq.put("iný", 29);
    freq.put("iní", 4);
    freq.put("iné", 19);
    freq.put("iná", 51);
    freq.put("jzl", 7);
    freq.put("yro", 13);
    freq.put("yra", 5);
    freq.put("Můj", 8);
    freq.put("Zla", 3);
    freq.put("Kla", 10);
    freq.put("Zlo", 3);
    freq.put("Klo", 3);
    freq.put("áhá", 3);
    freq.put("Mně", 3);
    freq.put("iny", 48);
    freq.put("int", 43);
    freq.put("inu", 71);
    freq.put("inv", 18);
    freq.put("ins", 30);
    freq.put("inn", 27);
    freq.put("ino", 54);
    freq.put("ini", 49);
    freq.put("ink", 62);
    freq.put("ind", 29);
    freq.put("ine", 56);
    freq.put("inf", 31);
    freq.put("ing", 54);
    freq.put("ina", 117);
    freq.put("inc", 9);
    freq.put("eo ", 17);
    freq.put("odá", 35);
    freq.put("DA ", 4);
    freq.put("Zlí", 6);
    freq.put("U", 153);
    freq.put("bař", 5);
    freq.put("in ", 67);
    freq.put("eob", 4);
    freq.put("eod", 4);
    freq.put("eok", 3);
    freq.put("eom", 4);
    freq.put("eor", 7);
    freq.put("eop", 5);
    freq.put("res", 63);
    freq.put("Tur", 7);
    freq.put("pto", 5);
    freq.put("SN ", 4);
    freq.put("ětí", 6);
    freq.put("tně", 52);
    freq.put("Ješ", 18);
    freq.put(" G ", 9);
    freq.put("erč", 5);
    freq.put("áru", 5);
    freq.put("yře", 5);
    freq.put("běr", 13);
    freq.put("nkč", 13);
    freq.put("cm ", 7);
    freq.put("ře ", 78);
    freq.put("alg", 5);
    freq.put("ald", 4);
    freq.put(" Gu", 11);
    freq.put(" Gr", 11);
    freq.put("Tun", 11);
    freq.put("alc", 10);
    freq.put(" Ge", 10);
    freq.put(" Ga", 19);
    freq.put(" Go", 54);
    freq.put("rea", 41);
    freq.put("aký", 40);
    freq.put("yři", 7);
    freq.put("aké", 46);
    freq.put("aká", 20);
    freq.put("erů", 9);
    freq.put("řát", 14);
    freq.put("aly", 21);
    freq.put("řán", 4);
    freq.put("řád", 48);
    freq.put("alt", 3);
    freq.put("lač", 20);
    freq.put("árk", 6);
    freq.put("lýt", 3);
    freq.put("sln", 5);
    freq.put("árn", 24);
    freq.put("áro", 29);
    freq.put("Úst", 6);
    freq.put("Úsp", 3);
    freq.put("šok", 3);
    freq.put("laš", 8);
    freq.put("šov", 12);
    freq.put("laž", 6);
    freq.put("Cr", 13);
    freq.put("gli", 16);
    freq.put("aky", 120);
    freq.put("cmé", 4);
    freq.put("aks", 3);
    freq.put("akr", 26);
    freq.put("gle", 49);
    freq.put("aku", 26);
    freq.put("sla", 79);
    freq.put("akh", 32);
    freq.put("ako", 261);
    freq.put("lař", 4);
    freq.put("akl", 14);
    freq.put("akc", 35);
    freq.put("aka", 17);
    freq.put("glu", 5);
    freq.put("ake", 27);
    freq.put("nk ", 16);
    freq.put("Jes", 13);
    freq.put("brz", 15);
    freq.put("Jez", 3);
    freq.put("bru", 8);
    freq.put("bro", 31);
    freq.put("brn", 8);
    freq.put("Jed", 27);
    freq.put("yšš", 4);
    freq.put("bre", 11);
    freq.put("Jen", 16);
    freq.put("bra", 53);
    freq.put("er ", 185);
    freq.put("nka", 40);
    freq.put("nkc", 10);
    freq.put("nke", 10);
    freq.put("nko", 32);
    freq.put("erD", 3);
    freq.put("Je ", 54);
    freq.put("nku", 50);
    freq.put("nky", 67);
    freq.put("Nam", 8);
    freq.put("ert", 33);
    freq.put("eru", 56);
    freq.put("erv", 57);
    freq.put("erp", 6);
    freq.put("err", 10);
    freq.put("ih", 84);
    freq.put("tny", 5);
    freq.put("ik", 398);
    freq.put("erz", 36);
    freq.put("erd", 3);
    freq.put("ere", 75);
    freq.put("erf", 6);
    freq.put("erg", 18);
    freq.put("tna", 20);
    freq.put("era", 77);
    freq.put("erb", 4);
    freq.put("erc", 7);
    freq.put("erl", 9);
    freq.put("erm", 18);
    freq.put("ern", 92);
    freq.put("ero", 47);
    freq.put("tni", 8);
    freq.put("eri", 65);
    freq.put("erk", 17);
    freq.put("brý", 26);
    freq.put("uar", 4);
    freq.put("la ", 490);
    freq.put("ual", 16);
    freq.put("bré", 10);
    freq.put("Aby", 5);
    freq.put("uac", 6);
    freq.put("brá", 25);
    freq.put("ki ", 5);
    freq.put("far", 8);
    freq.put("lal", 56);
    freq.put("nká", 10);
    freq.put("lan", 48);
    freq.put("lah", 3);
    freq.put("laj", 15);
    freq.put("lak", 17);
    freq.put("lad", 104);
    freq.put("lab", 9);
    freq.put("lac", 35);
    freq.put("lax", 18);
    freq.put("lay", 8);
    freq.put("laz", 9);
    freq.put("lat", 130);
    freq.put("lau", 10);
    freq.put("lav", 105);
    freq.put("lap", 18);
    freq.put("lar", 7);
    freq.put("las", 117);
    freq.put("ár ", 28);
    freq.put("akž", 46);
    freq.put("tný", 15);
    freq.put("erý", 51);
    freq.put("tná", 15);
    freq.put("erá", 41);
    freq.put("tní", 126);
    freq.put("fan", 26);
    freq.put("tné", 17);
    freq.put("eré", 44);
    freq.put("zeb", 5);
    freq.put("zec", 8);
    freq.put("zej", 12);
    freq.put("zek", 9);
    freq.put("zen", 79);
    freq.put("zel", 20);
    freq.put("zem", 40);
    freq.put("zer", 16);
    freq.put("zes", 10);
    freq.put("zep", 15);
    freq.put("OM ", 5);
    freq.put("zev", 13);
    freq.put("zet", 7);
    freq.put("zeu", 5);
    freq.put("zez", 12);
    freq.put("ze ", 232);
    freq.put("ktř", 4);
    freq.put("táz", 19);
    freq.put("×", 4);
    freq.put("ntá", 17);
    freq.put("ějí", 21);
    freq.put("ýše", 9);
    freq.put("ýši", 6);
    freq.put("l", 9098);
    freq.put("éno", 7);
    freq.put("ítí", 11);
    freq.put("ítá", 13);
    freq.put("éni", 5);
    freq.put("táb", 4);
    freq.put("pěc", 7);
    freq.put("tác", 6);
    freq.put("Dvo", 3);
    freq.put("ěj ", 23);
    freq.put("tám", 15);
    freq.put("nt ", 47);
    freq.put("oše", 11);
    freq.put("ošo", 4);
    freq.put("ošn", 10);
    freq.put("ošm", 3);
    freq.put("ošl", 23);
    freq.put("ošk", 15);
    freq.put("€", 3);
    freq.put("oši", 4);
    freq.put("ošt", 10);
    freq.put("bá ", 7);
    freq.put("ít ", 106);
    freq.put("nty", 8);
    freq.put("ěju", 3);
    freq.put("Dva", 7);
    freq.put("nts", 4);
    freq.put("ntr", 20);
    freq.put("ntu", 22);
    freq.put("nti", 22);
    freq.put("ějc", 3);
    freq.put("ntk", 3);
    freq.put("ěja", 94);
    freq.put("nto", 32);
    freq.put("ntn", 16);
    freq.put("nta", 35);
    freq.put("ěji", 23);
    freq.put("nte", 54);
    freq.put("ějo", 6);
    freq.put("bát", 3);
    freq.put("bás", 6);
    freq.put("ítr", 32);
    freq.put(" Nu", 5);
    freq.put("lš", 82);
    freq.put("báz", 3);
    freq.put("ítk", 19);
    freq.put("íti", 6);
    freq.put("bác", 4);
    freq.put("lů", 22);
    freq.put("bál", 5);
    freq.put("íta", 21);
    freq.put("báj", 3);
    freq.put("bák", 4);
    freq.put("íte", 68);
    freq.put("ětl", 15);
    freq.put("ětm", 3);
    freq.put("ětn", 3);
    freq.put("alí", 9);
    freq.put("tem", 50);
    freq.put("zeň", 6);
    freq.put("alé", 17);
    freq.put("ypá", 3);
    freq.put("Se ", 5);
    freq.put("kt ", 55);
    freq.put("ypí", 3);
    freq.put(" le", 181);
    freq.put("B", 353);
    freq.put(" la", 23);
    freq.put("Va", 40);
    freq.put(" lo", 38);
    freq.put(" li", 139);
    freq.put(" lu", 17);
    freq.put("alá", 15);
    freq.put(" lz", 7);
    freq.put(" ly", 5);
    freq.put("kty", 4);
    freq.put("skř", 3);
    freq.put("ktu", 49);
    freq.put("ktr", 10);
    freq.put("zeč", 3);
    freq.put("ktn", 4);
    freq.put("kto", 17);
    freq.put("kti", 28);
    freq.put("áč ", 4);
    freq.put("kte", 153);
    freq.put("ítě", 22);
    freq.put("Q ", 3);
    freq.put("Vo", 25);
    freq.put("ter", 308);
    freq.put("ypr", 9);
    freq.put("ypu", 8);
    freq.put("udu", 62);
    freq.put("adů", 5);
    freq.put("ypa", 48);
    freq.put("tev", 34);
    freq.put("ype", 7);
    freq.put("ypi", 4);
    freq.put("ypn", 8);
    freq.put("ypo", 4);
    freq.put("ypl", 13);
    freq.put("ítř", 5);
    freq.put("Qu", 3);
    freq.put(" lá", 14);
    freq.put(" lí", 35);
    freq.put(" lé", 21);
    freq.put("ějš", 62);
    freq.put("ntů", 11);
    freq.put("uda", 11);
    freq.put("d ", 737);
    freq.put("ké ", 207);
    freq.put("hry", 10);
    freq.put("em ", 916);
    freq.put("ží ", 65);
    freq.put("hru", 13);
    freq.put("udn", 4);
    freq.put("hro", 36);
    freq.put("hrn", 12);
    freq.put("hri", 4);
    freq.put("hrd", 6);
    freq.put("hra", 96);
    freq.put("dn", 783);
    freq.put("do", 1234);
    freq.put("dl", 295);
    freq.put("dm", 34);
    freq.put("dj", 8);
    freq.put("dk", 87);
    freq.put("dh", 27);
    freq.put("di", 503);
    freq.put("df", 5);
    freq.put("dg", 4);
    freq.put("dd", 22);
    freq.put("de", 1052);
    freq.put("db", 35);
    freq.put("dc", 42);
    freq.put("da", 570);
    freq.put("kéh", 51);
    freq.put("dz", 15);
    freq.put("kém", 24);
    freq.put("dy", 490);
    freq.put("dv", 101);
    freq.put("dt", 12);
    freq.put("du", 359);
    freq.put("dr", 250);
    freq.put("ds", 88);
    freq.put("dp", 77);
    freq.put("eme", 82);
    freq.put("ema", 37);
    freq.put("emc", 3);
    freq.put("ilá", 3);
    freq.put("emo", 40);
    freq.put("ilí", 4);
    freq.put("emi", 38);
    freq.put("emk", 3);
    freq.put("ilé", 4);
    freq.put("emu", 32);
    freq.put("žít", 13);
    freq.put("emp", 6);
    freq.put("ems", 4);
    freq.put("ilý", 10);
    freq.put("emy", 9);
    freq.put("w ", 48);
    freq.put(" I ", 25);
    freq.put("ÍM ", 3);
    freq.put("il ", 228);
    freq.put("nič", 35);
    freq.put("co ", 280);
    freq.put("hrá", 48);
    freq.put("we", 74);
    freq.put("dí", 295);
    freq.put("wa", 33);
    freq.put("dé", 33);
    freq.put("wo", 6);
    freq.put("wn", 7);
    freq.put(" Ir", 3);
    freq.put(" Is", 3);
    freq.put(" It", 8);
    freq.put("bny", 3);
    freq.put(" Iv", 4);
    freq.put("dá", 310);
    freq.put("ww", 22);
    freq.put("wt", 5);
    freq.put("ws", 12);
    freq.put("wr", 3);
    freq.put(" In", 49);
    freq.put("ř", 1976);
    freq.put("cop", 4);
    freq.put("ild", 3);
    freq.put("ile", 52);
    freq.put("emá", 62);
    freq.put("GB ", 9);
    freq.put("ila", 113);
    freq.put("iln", 45);
    freq.put("ilo", 97);
    freq.put("ill", 12);
    freq.put("ilm", 35);
    freq.put("ilj", 4);
    freq.put("ilk", 9);
    freq.put("ili", 103);
    freq.put("epů", 3);
    freq.put("ilt", 5);
    freq.put("ilu", 25);
    freq.put("emý", 10);
    freq.put("cok", 5);
    freq.put("com", 10);
    freq.put("col", 6);
    freq.put("coo", 3);
    freq.put("ily", 29);
    freq.put("ay ", 24);
    freq.put("emě", 30);
    freq.put("dč", 11);
    freq.put("mbu", 9);
    freq.put("Úža", 3);
    freq.put("gn ", 6);
    freq.put("dě", 398);
    freq.put("bno", 13);
    freq.put("dů", 51);
    freq.put("šme", 4);
    freq.put("dš", 17);
    freq.put("dž", 4);
    freq.put("umí", 23);
    freq.put("emř", 12);
    freq.put("gnu", 3);
    freq.put("ait", 4);
    freq.put("emů", 23);
    freq.put("ail", 38);
    freq.put("ET ", 5);
    freq.put("epí", 8);
    freq.put("ěší", 24);
    freq.put("dř", 27);
    freq.put("gno", 8);
    freq.put("epá", 3);
    freq.put("ni ", 189);
    freq.put("žsk", 24);
    freq.put("th ", 12);
    freq.put("nij", 4);
    freq.put("nik", 108);
    freq.put("nih", 26);
    freq.put("nii", 4);
    freq.put("nin", 23);
    freq.put("nio", 6);
    freq.put("nil", 43);
    freq.put("nim", 22);
    freq.put("nic", 157);
    freq.put("nia", 3);
    freq.put("nif", 4);
    freq.put("nie", 11);
    freq.put("niz", 22);
    freq.put("Y", 17);
    freq.put("nis", 38);
    freq.put("niv", 9);
    freq.put("nit", 60);
    freq.put("niu", 4);
    freq.put("epy", 4);
    freq.put("ept", 26);
    freq.put("epu", 23);
    freq.put("epr", 23);
    freq.put("eps", 16);
    freq.put("což", 10);
    freq.put("epn", 4);
    freq.put("epo", 56);
    freq.put("epl", 50);
    freq.put("gná", 3);
    freq.put("epi", 14);
    freq.put("the", 5);
    freq.put("epe", 5);
    freq.put("epa", 12);
    freq.put("rn ", 3);
    freq.put("Gam", 7);
    freq.put("Gal", 10);
    freq.put("tůl", 4);
    freq.put("tům", 8);
    freq.put("Top", 3);
    freq.put("rnk", 4);
    freq.put("rni", 9);
    freq.put("rno", 22);
    freq.put("Tro", 6);
    freq.put("Tra", 8);
    freq.put("rna", 18);
    freq.put("Tre", 3);
    freq.put("rne", 35);
    freq.put("rny", 7);
    freq.put("lce", 17);
    freq.put("plá", 30);
    freq.put("rns", 5);
    freq.put("vdu", 28);
    freq.put("plí", 3);
    freq.put("plé", 4);
    freq.put("obí", 22);
    freq.put("Toh", 11);
    freq.put("obá", 7);
    freq.put("fór", 4);
    freq.put("obý", 3);
    freq.put("tů ", 29);
    freq.put("zce", 3);
    freq.put("rše", 5);
    freq.put("zch", 5);
    freq.put("NÍ ", 6);
    freq.put("Lea", 3);
    freq.put("yka", 6);
    freq.put("Led", 4);
    freq.put("Leg", 3);
    freq.put("háš", 3);
    freq.put("yko", 7);
    freq.put("ykn", 4);
    freq.put("ob ", 11);
    freq.put("ykl", 24);
    freq.put("Tim", 7);
    freq.put("ykr", 3);
    freq.put(" ně", 327);
    freq.put("Let", 12);
    freq.put("yku", 5);
    freq.put("kvě", 29);
    freq.put("ědu", 3);
    freq.put("rné", 13);
    freq.put("pls", 5);
    freq.put("háč", 7);
    freq.put("rní", 57);
    freq.put("kvů", 16);
    freq.put("rná", 14);
    freq.put("plz", 3);
    freq.put("ply", 37);
    freq.put("ple", 50);
    freq.put("rný", 15);
    freq.put("plo", 20);
    freq.put("pln", 66);
    freq.put("pli", 35);
    freq.put("obn", 44);
    freq.put("obo", 54);
    freq.put("obl", 87);
    freq.put("yk ", 4);
    freq.put("obj", 24);
    freq.put("obk", 4);
    freq.put("obi", 56);
    freq.put("obd", 5);
    freq.put("obe", 38);
    freq.put("obb", 4);
    freq.put("obc", 26);
    freq.put("oba", 20);
    freq.put("oby", 36);
    freq.put("obv", 7);
    freq.put("obt", 4);
    freq.put("obu", 28);
    freq.put("obr", 106);
    freq.put("obs", 34);
    freq.put("ýba", 3);
    freq.put("Í ", 13);
    freq.put("ěl ", 86);
    freq.put("Cul", 3);
    freq.put("wan", 3);
    freq.put("MP ", 4);
    freq.put("wai", 3);
    freq.put("rým", 7);
    freq.put("rně", 28);
    freq.put("way", 3);
    freq.put("Od ", 10);
    freq.put("wat", 3);
    freq.put("war", 12);
    freq.put(" né", 7);
    freq.put("olk", 21);
    freq.put(" ní", 26);
    freq.put("ěls", 8);
    freq.put(" ná", 206);
    freq.put("ěly", 4);
    freq.put("xy ", 16);
    freq.put("ěle", 26);
    freq.put("ěla", 112);
    freq.put("ěln", 7);
    freq.put("ělo", 28);
    freq.put("ěli", 39);
    freq.put("ělk", 4);
    freq.put("rý ", 73);
    freq.put("Odp", 3);
    freq.put("íru", 9);
    freq.put("írn", 4);
    freq.put("Odk", 4);
    freq.put("mto", 7);
    freq.put("írk", 10);
    freq.put("íre", 3);
    freq.put("Ode", 7);
    freq.put("mte", 3);
    freq.put("obč", 13);
    freq.put("ür", 3);
    freq.put(" n ", 5);
    freq.put("obě", 59);
    freq.put("háj", 8);
    freq.put("hám", 18);
    freq.put("hán", 13);
    freq.put("hác", 4);
    freq.put("hád", 7);
    freq.put("ház", 24);
    freq.put("háp", 21);
    freq.put("hát", 3);
    freq.put("háv", 5);
    freq.put(" ni", 113);
    freq.put("umu", 4);
    freq.put(" nj", 4);
    freq.put(" no", 287);
    freq.put("kva", 32);
    freq.put(" na", 1492);
    freq.put("kvo", 3);
    freq.put(" ne", 1509);
    freq.put("kvi", 3);
    freq.put(" ny", 14);
    freq.put("kvu", 4);
    freq.put("ělá", 58);
    freq.put("obř", 34);
    freq.put("ělí", 11);
    freq.put("Zdr", 6);
    freq.put(" nu", 19);
    freq.put("ělé", 6);
    freq.put("Sk", 20);
    freq.put("TW ", 3);
    freq.put("bný", 4);
    freq.put("há ", 13);
    freq.put("írá", 17);
    freq.put("plň", 4);
    freq.put("ďm", 4);
    freq.put("htí", 5);
    freq.put("ďa", 9);
    freq.put("Zde", 6);
    freq.put("fé", 9);
    freq.put("ďt", 26);
    freq.put("išl", 11);
    freq.put("gu ", 30);
    freq.put("išk", 4);
    freq.put("iše", 12);
    freq.put("jvt", 4);
    freq.put("yva", 6);
    freq.put("išt", 28);
    freq.put("ó ", 8);
    freq.put("umb", 9);
    freq.put(" Kč", 63);
    freq.put("ěši", 9);
    freq.put("óz", 5);
    freq.put("EO ", 6);
    freq.put("gue", 7);
    freq.put("guj", 22);
    freq.put("iš ", 16);
    freq.put("eká", 30);
    freq.put("gul", 7);
    freq.put("p", 6277);
    freq.put("ón", 24);
    freq.put("ól", 3);
    freq.put("ód", 14);
    freq.put("hte", 9);
    freq.put("hta", 8);
    freq.put("hto", 5);
    freq.put("OK ", 6);
    freq.put("htt", 11);
    freq.put("hty", 8);
    freq.put("ek ", 262);
    freq.put("ámě", 6);
    freq.put("yvá", 3);
    freq.put("jví", 10);
    freq.put("ht ", 10);
    freq.put("eko", 33);
    freq.put("ekn", 20);
    freq.put("spě", 33);
    freq.put("óó", 4);
    freq.put("eke", 4);
    freq.put("ekd", 14);
    freq.put("ekc", 12);
    freq.put("eka", 45);
    freq.put("Mos", 4);
    freq.put("eky", 4);
    freq.put("ekv", 15);
    freq.put("PC ", 14);
    freq.put("ekt", 54);
    freq.put("ww ", 11);
    freq.put("uzn", 9);
    freq.put("uzi", 31);
    freq.put("uze", 53);
    freq.put("uza", 14);
    freq.put("spí", 12);
    freq.put("spá", 14);
    freq.put("uzs", 3);
    freq.put(" Ka", 56);
    freq.put(" Kd", 72);
    freq.put(" Ke", 11);
    freq.put("išť", 5);
    freq.put(" Ki", 10);
    freq.put(" Kn", 3);
    freq.put(" Ko", 77);
    freq.put(" Kl", 17);
    freq.put(" Kr", 47);
    freq.put(" Kv", 8);
    freq.put(" Kt", 5);
    freq.put(" Ku", 29);
    freq.put("ca ", 21);
    freq.put("Mon", 5);
    freq.put("jvě", 10);
    freq.put("F", 212);
    freq.put("uz ", 26);
    freq.put("fb ", 4);
    freq.put("ámý", 6);
    freq.put("ibi", 11);
    freq.put(" K ", 13);
    freq.put("ibl", 4);
    freq.put("ibo", 7);
    freq.put("cas", 12);
    freq.put("iba", 8);
    freq.put("cap", 5);
    freq.put("ibe", 13);
    freq.put("cat", 5);
    freq.put("iby", 11);
    freq.put("can", 5);
    freq.put("cal", 14);
    freq.put("ibu", 8);
    freq.put("uzí", 4);
    freq.put("ám ", 409);
    freq.put("spr", 28);
    freq.put("spu", 12);
    freq.put("spi", 20);
    freq.put("spl", 17);
    freq.put("spo", 161);
    freq.put("spa", 38);
    freq.put("spe", 31);
    freq.put("Vlá", 14);
    freq.put("ňt", 9);
    freq.put("ňu", 13);
    freq.put("ňk", 3);
    freq.put("gh ", 6);
    freq.put("ňo", 4);
    freq.put("ňa", 10);
    freq.put("um ", 44);
    freq.put("ámi", 9);
    freq.put("ámo", 11);
    freq.put("áma", 6);
    freq.put("ámc", 4);
    freq.put("áme", 68);
    freq.put("ámy", 3);
    freq.put("aos", 5);
    freq.put("aop", 4);
    freq.put("sp ", 3);
    freq.put("áms", 3);
    freq.put("ght", 8);
    freq.put("ER ", 6);
    freq.put("ibý", 4);
    freq.put("ň ", 61);
    freq.put("htě", 40);
    freq.put("Ru", 32);
    freq.put("Chc", 12);
    freq.put("pův", 11);
    freq.put("Chl", 6);
    freq.put("Ry", 6);
    freq.put("Jap", 6);
    freq.put("Cho", 5);
    freq.put("Jan", 11);
    freq.put("Re", 68);
    freq.put("Chr", 6);
    freq.put("Cht", 9);
    freq.put("Chu", 5);
    freq.put("Chy", 8);
    freq.put("Ro", 53);
    freq.put("Jab", 5);
    freq.put("Ri", 7);
    freq.put("pně", 9);
    freq.put("teř", 20);
    freq.put("zař", 14);
    freq.put("nol", 8);
    freq.put("nom", 37);
    freq.put("non", 5);
    freq.put("noh", 31);
    freq.put("noj", 3);
    freq.put("nod", 19);
    freq.put("ěsn", 7);
    freq.put("ěsi", 3);
    freq.put("nob", 3);
    freq.put("noc", 34);
    freq.put("ěst", 49);
    freq.put("R ", 61);
    freq.put("noz", 6);
    freq.put("not", 35);
    freq.put("nou", 236);
    freq.put("nov", 246);
    freq.put("now", 3);
    freq.put("nop", 3);
    freq.put("Ja ", 4);
    freq.put("nos", 160);
    freq.put("zač", 81);
    freq.put("óru", 6);
    freq.put("sou", 217);
    freq.put("sot", 3);
    freq.put("em", 1356);
    freq.put("el", 931);
    freq.put("eo", 57);
    freq.put("en", 1677);
    freq.put("ei", 20);
    freq.put("eh", 149);
    freq.put("ek", 587);
    freq.put("ej", 759);
    freq.put("ee", 82);
    freq.put("ed", 999);
    freq.put("eg", 57);
    freq.put("ef", 100);
    freq.put("ea", 101);
    freq.put("rl ", 3);
    freq.put("ec", 637);
    freq.put("eb", 489);
    freq.put("koč", 5);
    freq.put("ey", 15);
    freq.put("Rá", 6);
    freq.put("ez", 395);
    freq.put("eu", 70);
    freq.put("et", 678);
    freq.put("ew", 15);
    freq.put("ev", 346);
    freq.put("ep", 339);
    freq.put("Afr", 3);
    freq.put("er", 1030);
    freq.put("ěně", 5);
    freq.put("eD", 3);
    freq.put("bíč", 4);
    freq.put("šin", 17);
    freq.put("Son", 3);
    freq.put("eR", 3);
    freq.put("rlo", 8);
    freq.put("rli", 3);
    freq.put("ěsí", 35);
    freq.put("rld", 5);
    freq.put("rla", 9);
    freq.put("e ", 6159);
    freq.put("lmi", 14);
    freq.put("lma", 4);
    freq.put("eté", 10);
    freq.put("tlí", 3);
    freq.put("výš", 17);
    freq.put("zan", 7);
    freq.put("xk", 7);
    freq.put("zal", 36);
    freq.put("xi", 30);
    freq.put("xn", 3);
    freq.put("xo", 5);
    freq.put("zah", 36);
    freq.put("Ps", 3);
    freq.put("xc", 4);
    freq.put("zad", 18);
    freq.put("xa", 5);
    freq.put("zab", 32);
    freq.put("zac", 38);
    freq.put("xe", 11);
    freq.put("mva", 4);
    freq.put("růz", 13);
    freq.put("xy", 16);
    freq.put("zaz", 5);
    freq.put("zav", 34);
    freq.put("xp", 12);
    freq.put("růs", 3);
    freq.put("zar", 8);
    freq.put("Sá", 3);
    freq.put("xt", 32);
    freq.put("xu", 29);
    freq.put("noč", 10);
    freq.put("xD", 31);
    freq.put("ěný", 10);
    freq.put("rů ", 32);
    freq.put("x ", 70);
    freq.put("pnu", 12);
    freq.put("noš", 3);
    freq.put("za ", 259);
    freq.put("pni", 3);
    freq.put("nož", 9);
    freq.put("ění", 41);
    freq.put("pno", 16);
    freq.put("ěné", 10);
    freq.put("pna", 6);
    freq.put("pne", 10);
    freq.put("ěná", 3);
    freq.put("Btw", 3);
    freq.put("vář", 7);
    freq.put("noř", 3);
    freq.put("bí ", 30);
    freq.put("íp ", 4);
    freq.put("eť", 3);
    freq.put("eš", 289);
    freq.put("ež", 141);
    freq.put("ěn ", 8);
    freq.put("Phi", 3);
    freq.put("Pho", 41);
    freq.put("eň", 28);
    freq.put("eř", 77);
    freq.put("Pl", 27);
    freq.put("Off", 5);
    freq.put("bíd", 22);
    freq.put("ípa", 15);
    freq.put("bíj", 7);
    freq.put("bíh", 5);
    freq.put("Dík", 31);
    freq.put("ípk", 4);
    freq.put("bíl", 8);
    freq.put("pné", 7);
    freq.put("ěno", 13);
    freq.put("pní", 3);
    freq.put("ěni", 16);
    freq.put("bíz", 16);
    freq.put("ěna", 4);
    freq.put("eč", 237);
    freq.put("eď", 63);
    freq.put("mrz", 8);
    freq.put("mrt", 28);
    freq.put("mrk", 7);
    freq.put("mrd", 7);
    freq.put("mra", 10);
    freq.put("Web", 8);
    freq.put("váš", 10);
    freq.put(" p ", 8);
    freq.put("věs", 5);
    freq.put("átn", 15);
    freq.put("éme", 3);
    freq.put("ěřu", 5);
    freq.put("ěři", 13);
    freq.put("ytí", 4);
    freq.put("ytá", 7);
    freq.put(" ps", 33);
    freq.put(" pr", 1009);
    freq.put(" pu", 39);
    freq.put(" pt", 18);
    freq.put(" py", 7);
    freq.put(" pc", 3);
    freq.put(" pa", 204);
    freq.put(" pe", 50);
    freq.put(" pi", 47);
    freq.put(" ph", 6);
    freq.put(" po", 1114);
    freq.put(" pn", 5);
    freq.put(" pl", 133);
    freq.put("hvě", 6);
    freq.put("ěř ", 18);
    freq.put("uvn", 3);
    freq.put("vu ", 55);
    freq.put("ytv", 11);
    freq.put(" Mů", 15);
    freq.put("ytr", 5);
    freq.put("yto", 7);
    freq.put("ytl", 4);
    freq.put("ytk", 7);
    freq.put("ěří", 18);
    freq.put("yti", 4);
    freq.put("jte", 58);
    freq.put("odp", 60);
    freq.put("yte", 19);
    freq.put("yta", 5);
    freq.put("žka", 5);
    freq.put("Kry", 3);
    freq.put("Kru", 4);
    freq.put(" pá", 83);
    freq.put("Kro", 3);
    freq.put(" pé", 5);
    freq.put("Kra", 3);
    freq.put(" Úp", 3);
    freq.put(" Ús", 9);
    freq.put(" Mě", 25);
    freq.put("vub", 3);
    freq.put("vul", 4);
    freq.put("vuj", 17);
    freq.put("eřs", 3);
    freq.put("RG ", 3);
    freq.put("jt ", 9);
    freq.put("yt ", 16);
    freq.put("hvi", 7);
    freq.put("hva", 10);
    freq.put("twe", 16);
    freq.put("vrh", 18);
    freq.put(" Má", 48);
    freq.put(" pě", 45);
    freq.put(" Mí", 10);
    freq.put(" Mé", 4);
    freq.put(" pů", 55);
    freq.put("eis", 9);
    freq.put("eit", 3);
    freq.put("au ", 7);
    freq.put(" př", 676);
    freq.put("žác", 5);
    freq.put("žád", 29);
    freq.put("žák", 4);
    freq.put("uxu", 12);
    freq.put("hví", 11);
    freq.put("hvá", 14);
    freq.put("vuč", 4);
    freq.put("yj", 20);
    freq.put("SD ", 7);
    freq.put("yl", 236);
    freq.put(" Úč", 4);
    freq.put(" Me", 37);
    freq.put(" Ma", 116);
    freq.put(" Mb", 3);
    freq.put(" Mc", 3);
    freq.put(" Ml", 8);
    freq.put(" Mn", 5);
    freq.put(" Mo", 54);
    freq.put(" Mi", 61);
    freq.put(" Mu", 24);
    freq.put("éf ", 4);
    freq.put(" Mr", 3);
    freq.put(" My", 22);
    freq.put(" Mz", 4);
    freq.put("yb", 107);
    freq.put("jtě", 4);
    freq.put("ye", 12);
    freq.put("ete", 129);
    freq.put("cej", 7);
    freq.put(" Úž", 3);
    freq.put("ux ", 3);
    freq.put("vě", 450);
    freq.put(" M ", 6);
    freq.put("tlo", 4);
    freq.put("cet", 22);
    freq.put("cce", 7);
    freq.put("cca", 11);
    freq.put("ác", 152);
    freq.put("áb", 38);
    freq.put("ád", 304);
    freq.put("ág", 3);
    freq.put("áf", 7);
    freq.put("áh", 41);
    freq.put("ák", 128);
    freq.put("áj", 45);
    freq.put("ám", 536);
    freq.put("ál", 353);
    freq.put("án", 396);
    freq.put("áp", 62);
    freq.put("ás", 212);
    freq.put("ár", 120);
    freq.put("át", 350);
    freq.put("áv", 303);
    freq.put("áz", 157);
    freq.put("loš", 3);
    freq.put("ňan", 4);
    freq.put("yt", 103);
    freq.put("ff ", 11);
    freq.put("lož", 41);
    freq.put("ami", 38);
    freq.put("á ", 1086);
    freq.put("amk", 5);
    freq.put("psi", 13);
    freq.put("amm", 3);
    freq.put("ásu", 4);
    freq.put("ást", 38);
    freq.put("ama", 73);
    freq.put("psa", 38);
    freq.put("ame", 66);
    freq.put("lů ", 18);
    freq.put("pse", 4);
    freq.put("ásc", 3);
    freq.put("ása", 9);
    freq.put("psy", 6);
    freq.put("Hez", 4);
    freq.put("áse", 6);
    freq.put("ásk", 9);
    freq.put("amp", 16);
    freq.put("ási", 21);
    freq.put("amr", 4);
    freq.put("áso", 3);
    freq.put("ásn", 29);
    freq.put("yni", 7);
    freq.put("žko", 14);
    freq.put("cy", 15);
    freq.put("očí", 31);
    freq.put("t", 11944);
    freq.put("áá", 21);
    freq.put("Ván", 4);
    freq.put("Vám", 10);
    freq.put("Vác", 8);
    freq.put("td ", 3);
    freq.put("yna", 7);
    freq.put("Hel", 8);
    freq.put("ucn", 7);
    freq.put("Vás", 10);
    freq.put("yčk", 3);
    freq.put("ync", 3);
    freq.put("oč ", 65);
    freq.put("uck", 10);
    freq.put("cv", 8);
    freq.put("uci", 14);
    freq.put("uch", 67);
    freq.put("amé", 7);
    freq.put("amí", 4);
    freq.put("amá", 9);
    freq.put("psá", 9);
    freq.put("yč ", 4);
    freq.put("amý", 3);
    freq.put("ásí", 6);
    freq.put("oča", 15);
    freq.put("sra", 21);
    freq.put("srd", 3);
    freq.put("dzi", 13);
    freq.put("oči", 25);
    freq.put("sro", 5);
    freq.put("srp", 12);
    freq.put("očt", 5);
    freq.put("áš", 123);
    freq.put("Ada", 4);
    freq.put("áž", 70);
    freq.put("lob", 16);
    freq.put("loc", 3);
    freq.put("loa", 7);
    freq.put("log", 51);
    freq.put("lod", 8);
    freq.put("lok", 7);
    freq.put("loh", 9);
    freq.put("lon", 26);
    freq.put("lol", 3);
    freq.put("lom", 23);
    freq.put("lor", 3);
    freq.put("los", 39);
    freq.put("lop", 15);
    freq.put("lov", 185);
    freq.put("low", 17);
    freq.put("lot", 16);
    freq.put("lou", 140);
    freq.put("ář", 109);
    freq.put("ádá", 17);
    freq.put("pu ", 53);
    freq.put("J", 527);
    freq.put("Muz", 3);
    freq.put("lo ", 327);
    freq.put("áč", 35);
    freq.put("Váš", 3);
    freq.put("Lan", 3);
    freq.put("udě", 46);
    freq.put("Lau", 3);
    freq.put("you", 4);
    freq.put("Lar", 4);
    freq.put("Bru", 4);
    freq.put("ůbe", 23);
    freq.put("nďa", 3);
    freq.put("Bro", 3);
    freq.put("Brn", 23);
    freq.put("Bri", 6);
    freq.put("Bre", 6);
    freq.put("Bra", 15);
    freq.put("řid", 36);
    freq.put("řic", 13);
    freq.put("řib", 12);
    freq.put("řim", 4);
    freq.put("řil", 32);
    freq.put("řin", 18);
    freq.put("řih", 23);
    freq.put("řik", 12);
    freq.put("řij", 43);
    freq.put("řit", 25);
    freq.put("řiv", 13);
    freq.put("řip", 31);
    freq.put("řis", 4);
    freq.put("řiz", 7);
    freq.put("áá ", 6);
    freq.put("při", 190);
    freq.put("ýle", 7);
    freq.put("pře", 364);
    freq.put("mpe", 3);
    freq.put("ři ", 88);
    freq.put("mpa", 13);
    freq.put(" rý", 3);
    freq.put("mpo", 3);
    freq.put("mpl", 9);
    freq.put("mpi", 3);
    freq.put("mpu", 8);
    freq.put(" rá", 72);
    freq.put("ož ", 21);
    freq.put("mpy", 3);
    freq.put("Byl", 10);
    freq.put("př ", 4);
    freq.put("ass", 4);
    freq.put("ůč", 3);
    freq.put("úči", 3);
    freq.put("asr", 6);
    freq.put("úča", 13);
    freq.put("úče", 11);
    freq.put("účt", 10);
    freq.put("asu", 30);
    freq.put("výl", 7);
    freq.put("pří", 156);
    freq.put("lič", 14);
    freq.put("přá", 16);
    freq.put(" ru", 38);
    freq.put("čně", 69);
    freq.put("výh", 18);
    freq.put(" ry", 45);
    freq.put("vet", 8);
    freq.put(" re", 189);
    freq.put(" ra", 102);
    freq.put("ůř", 4);
    freq.put("kze", 8);
    freq.put(" ro", 269);
    freq.put(" ri", 7);
    freq.put("výd", 3);
    freq.put("š", 1820);
    freq.put("ááá", 12);
    freq.put("vče", 20);
    freq.put("ůž", 93);
    freq.put("yst", 51);
    freq.put("řiš", 26);
    freq.put("nýc", 43);
    freq.put("ným", 30);
    freq.put("cé", 8);
    freq.put("nýh", 9);
    freq.put("ask", 9);
    freq.put("S ", 126);
    freq.put("čný", 12);
    freq.put("asn", 58);
    freq.put("čné", 12);
    freq.put("ční", 112);
    freq.put("vi", 573);
    freq.put("čná", 11);
    freq.put("asl", 14);
    freq.put("yřj", 4);
    freq.put("Sy", 8);
    freq.put("fó", 5);
    freq.put("ný ", 240);
    freq.put("Sr", 3);
    freq.put("Sp", 42);
    freq.put("Sw", 3);
    freq.put("Sv", 11);
    freq.put("Su", 15);
    freq.put("St", 111);
    freq.put("FC ", 3);
    freq.put("fá", 25);
    freq.put("Si", 15);
    freq.put("Sh", 12);
    freq.put("So", 39);
    freq.put("Sn", 19);
    freq.put("Sm", 5);
    freq.put("Sl", 43);
    freq.put("Sc", 18);
    freq.put("Kte", 5);
    freq.put("Sa", 55);
    freq.put("fí", 11);
    freq.put("Se", 32);
    freq.put("bur", 14);
    freq.put("egá", 6);
    freq.put("dář", 7);
    freq.put("f ", 52);
    freq.put("ucí", 11);
    freq.put("ů ", 285);
    freq.put("čno", 32);
    freq.put("čna", 3);
    freq.put("čne", 13);
    freq.put("fr", 29);
    freq.put("fs", 3);
    freq.put("ft", 23);
    freq.put("fu", 78);
    freq.put("fy", 7);
    freq.put("fa", 122);
    freq.put("fb", 4);
    freq.put("fe", 56);
    freq.put("ff", 29);
    freq.put("fi", 169);
    freq.put(" rů", 7);
    freq.put("fl", 21);
    freq.put("fo", 215);
    freq.put("a", 16007);
    freq.put("ůn", 10);
    freq.put("ům", 55);
    freq.put("ůl", 58);
    freq.put("ůj", 69);
    freq.put("ůh", 7);
    freq.put("egr", 6);
    freq.put("ůči", 3);
    freq.put("ůd", 4);
    freq.put("ůc", 6);
    freq.put("ůb", 25);
    freq.put("egu", 8);
    freq.put("egi", 12);
    freq.put("ego", 3);
    freq.put("ůz", 15);
    freq.put("ův", 45);
    freq.put("ega", 10);
    freq.put("ůs", 30);
    freq.put("ůr", 19);
    freq.put("ege", 8);
    freq.put("uvy", 6);
    freq.put("Hry", 3);
    freq.put("ffy", 3);
    freq.put("ce ", 564);
    freq.put("y ", 2387);
    freq.put("uvi", 35);
    freq.put("Hro", 3);
    freq.put("ffl", 3);
    freq.put("émo", 6);
    freq.put("ffi", 5);
    freq.put("uva", 12);
    freq.put("Hra", 15);
    freq.put("uve", 16);
    freq.put("stě", 63);
    freq.put(" On", 22);
    freq.put(" Ol", 6);
    freq.put(" Om", 4);
    freq.put(" Ok", 9);
    freq.put(" Oh", 3);
    freq.put(" Of", 8);
    freq.put(" Od", 31);
    freq.put(" Ob", 32);
    freq.put(" Oc", 8);
    freq.put(" Ot", 12);
    freq.put(" Or", 20);
    freq.put(" Os", 20);
    freq.put(" Op", 24);
    freq.put("yh", 48);
    freq.put("yk", 58);
    freq.put("ced", 3);
    freq.put("ym", 51);
    freq.put("ceb", 37);
    freq.put("yo", 12);
    freq.put("yn", 76);
    freq.put("ya", 7);
    freq.put("cen", 107);
    freq.put("cem", 20);
    freq.put("cel", 114);
    freq.put("cek", 13);
    freq.put("yd", 62);
    freq.put("yg", 4);
    freq.put("yf", 7);
    freq.put("yy", 7);
    freq.put("émy", 8);
    freq.put("asá", 8);
    freq.put("yz", 47);
    freq.put("ces", 40);
    freq.put("cer", 33);
    freq.put("cep", 7);
    freq.put("yp", 111);
    freq.put("ys", 226);
    freq.put("yr", 23);
    freq.put("yu", 13);
    freq.put("stř", 60);
    freq.put("así", 13);
    freq.put("yv", 20);
    freq.put("ift", 3);
    freq.put("stů", 20);
    freq.put("yD", 4);
    freq.put(" O ", 36);
    freq.put("édn", 6);
    freq.put("ife", 4);
    freq.put("iff", 3);
    freq.put("íčn", 7);
    freq.put("íčk", 21);
    freq.put("édi", 13);
    freq.put("íče", 17);
    freq.put("ifo", 3);
    freq.put("ifi", 18);
    freq.put("dig", 11);
    freq.put("kč ", 7);
    freq.put("č", 1800);
    freq.put("as ", 94);
    freq.put("uví", 7);
    freq.put("uvá", 8);
    freq.put("Hrá", 3);
    freq.put("liš", 13);
    freq.put("kač", 6);
    freq.put("liž", 4);
    freq.put("eá", 12);
    freq.put("pul", 13);
    freq.put("pum", 4);
    freq.put("kaš", 3);
    freq.put("asp", 22);
    freq.put("puj", 21);
    freq.put("ast", 154);
    freq.put("kčn", 19);
    freq.put("asy", 6);
    freq.put("pub", 20);
    freq.put("asc", 6);
    freq.put("asa", 10);
    freq.put("rhů", 3);
    freq.put("put", 7);
    freq.put("st ", 209);
    freq.put("asi", 112);
    freq.put("ash", 14);
    freq.put("aso", 22);
    freq.put("kaž", 37);
    freq.put("asm", 5);
    freq.put("pus", 36);
    freq.put(" F ", 5);
    freq.put("kař", 4);
    freq.put("Clo", 3);
    freq.put("žuj", 11);
    freq.put("tf ", 5);
    freq.put("php", 4);
    freq.put("yč", 13);
    freq.put("oď ", 4);
    freq.put("lió", 3);
    freq.put(" Oč", 8);
    freq.put("tfi", 4);
    freq.put("ceš", 7);
    freq.put("yš", 53);
    freq.put("yť", 8);
    freq.put("žu ", 25);
    freq.put("nch", 9);
    freq.put("nci", 45);
    freq.put("ncl", 4);
    freq.put("yž", 138);
    freq.put("nce", 76);
    freq.put("ste", 188);
    freq.put("uvě", 8);
    freq.put("sta", 382);
    freq.put("stl", 57);
    freq.put("stn", 95);
    freq.put("sto", 179);
    freq.put("sti", 224);
    freq.put("dte", 3);
    freq.put("stk", 17);
    freq.put("yř", 25);
    freq.put("stu", 128);
    freq.put("stv", 38);
    freq.put("str", 195);
    freq.put("sts", 3);
    freq.put("dtr", 4);
    freq.put("sty", 34);
    freq.put("Goo", 44);
    freq.put("ka ", 414);
    freq.put("rh ", 10);
    freq.put("lid", 96);
    freq.put("Nik", 11);
    freq.put("lif", 9);
    freq.put("lig", 14);
    freq.put("lia", 12);
    freq.put("lib", 19);
    freq.put("lic", 74);
    freq.put("lil", 25);
    freq.put("Nic", 6);
    freq.put("lin", 55);
    freq.put("lio", 19);
    freq.put("Nig", 4);
    freq.put("lij", 3);
    freq.put("lik", 132);
    freq.put("lit", 77);
    freq.put("liv", 47);
    freq.put("lip", 7);
    freq.put("lis", 52);
    freq.put("liz", 25);
    freq.put("kac", 45);
    freq.put("kab", 8);
    freq.put("kaf", 7);
    freq.put("kak", 5);
    freq.put("kaj", 13);
    freq.put("rhu", 16);
    freq.put("kan", 28);
    freq.put("kam", 72);
    freq.put("kal", 71);
    freq.put("kas", 4);
    freq.put("kar", 24);
    freq.put("kap", 20);
    freq.put("rhl", 5);
    freq.put("kau", 3);
    freq.put("kat", 55);
    freq.put("kaz", 41);
    freq.put("The", 9);
    freq.put("asů", 6);
    freq.put("li ", 377);
    freq.put("stá", 99);
    freq.put("dtí", 4);
    freq.put("stí", 55);
    freq.put("sté", 47);
    freq.put("íbě", 6);
    freq.put("stý", 7);
    freq.put("nco", 11);
    freq.put("tw ", 8);
    freq.put("ZA ", 3);
    freq.put("ymp", 3);
    freq.put(" tě", 78);
    freq.put("ymy", 3);
    freq.put("yme", 4);
    freq.put("ox ", 10);
    freq.put("ymn", 5);
    freq.put("nču", 4);
    freq.put(" tř", 69);
    freq.put("ym ", 17);
    freq.put("nče", 3);
    freq.put("nča", 3);
    freq.put("nčn", 8);
    freq.put("x", 267);
    freq.put("nči", 23);
    freq.put("ydn", 4);
    freq.put("řov", 10);
    freq.put("vyč", 3);
    freq.put("ymý", 4);
    freq.put("Plz", 8);
    freq.put("vžd", 17);
    freq.put("pná", 6);
    freq.put("Pla", 13);
    freq.put("Obl", 3);
    freq.put("yde", 6);
    freq.put("Obj", 6);
    freq.put("Obe", 4);
    freq.put("Obc", 6);
    freq.put("vyž", 5);
    freq.put("vyš", 18);
    freq.put("nčí", 19);
    freq.put("Wat", 3);
    freq.put(" t ", 5);
    freq.put("ydr", 10);
    freq.put("add", 8);
    freq.put("Zbý", 11);
    freq.put("ájm", 3);
    freq.put(" tz", 4);
    freq.put(" ty", 124);
    freq.put(" € ", 3);
    freq.put(" tw", 33);
    freq.put(" tv", 47);
    freq.put(" tu", 104);
    freq.put(" tr", 151);
    freq.put("N", 606);
    freq.put(" to", 1159);
    freq.put(" tm", 3);
    freq.put(" tl", 17);
    freq.put(" ti", 124);
    freq.put(" th", 7);
    freq.put(" te", 362);
    freq.put("adl", 53);
    freq.put(" ta", 731);
    freq.put("adk", 11);
    freq.put("půr", 3);
    freq.put("jpo", 3);
    freq.put("bou", 42);
    freq.put("ěhl", 4);
    freq.put("jpr", 4);
    freq.put("Obč", 3);
    freq.put("Kvi", 3);
    freq.put("gs ", 4);
    freq.put("vy ", 144);
    freq.put("ohn", 10);
    freq.put(" tý", 56);
    freq.put("lie", 9);
    freq.put(" tí", 41);
    freq.put(" té", 51);
    freq.put("tup", 60);
    freq.put(" tá", 13);
    freq.put("vyr", 13);
    freq.put("vys", 62);
    freq.put("vyp", 75);
    freq.put("vyv", 12);
    freq.put("vyt", 21);
    freq.put("vyu", 8);
    freq.put("vyz", 18);
    freq.put("vyb", 21);
    freq.put("vyc", 15);
    freq.put("vyf", 4);
    freq.put("vyd", 33);
    freq.put("lim", 10);
    freq.put("vyj", 14);
    freq.put("vyk", 27);
    freq.put("vyh", 27);
    freq.put("vyn", 12);
    freq.put("vyl", 9);
    freq.put("vym", 21);
    freq.put("čle", 6);
    freq.put("člo", 27);
    freq.put("utě", 21);
    freq.put("Mát", 8);
    freq.put("Mám", 23);
    freq.put("ee ", 8);
    freq.put("ťan", 5);
    freq.put("tut", 5);
    freq.put("ťas", 4);
    freq.put("veř", 30);
    freq.put("eex", 4);
    freq.put("eet", 21);
    freq.put("eem", 4);
    freq.put("Má ", 9);
    freq.put("een", 8);
    freq.put("eek", 7);
    freq.put("eej", 3);
    freq.put("eee", 13);
    freq.put("eed", 5);
    freq.put("idá", 18);
    freq.put("rhy", 4);
    freq.put("člá", 28);
    freq.put("ru ", 147);
    freq.put("ohe", 11);
    freq.put("svě", 62);
    freq.put("dvě", 22);
    freq.put("nař", 5);
    freq.put("naš", 46);
    freq.put(" Qu", 3);
    freq.put("Tř", 12);
    freq.put("naž", 17);
    freq.put("id ", 24);
    freq.put("ruj", 17);
    freq.put("ruk", 12);
    freq.put("ruh", 52);
    freq.put("run", 16);
    freq.put("rum", 11);
    freq.put("rub", 11);
    freq.put("ruc", 17);
    freq.put("rud", 4);
    freq.put("nač", 26);
    freq.put("ruz", 4);
    freq.put("rus", 17);
    freq.put("rup", 8);
    freq.put("svů", 6);
    freq.put("krá", 66);
    freq.put("ť", 93);
    freq.put("Tě", 11);
    freq.put("idu", 7);
    freq.put("ids", 4);
    freq.put("idn", 21);
    freq.put("ido", 11);
    freq.put("idl", 19);
    freq.put("idm", 6);
    freq.put("mči", 3);
    freq.put("idi", 50);
    freq.put("idd", 3);
    freq.put("ide", 66);
    freq.put("ida", 27);
    freq.put("Tý", 3);
    freq.put("rho", 5);
    freq.put("rhn", 7);
    freq.put("Ele", 4);
    freq.put("Tí", 4);
    freq.put("žké", 3);
    freq.put("Tá", 3);
    freq.put("ut ", 104);
    freq.put("šud", 6);
    freq.put("šuj", 8);
    freq.put("Máš", 3);
    freq.put("kus", 42);
    freq.put("tul", 21);
    freq.put("veš", 4);
    freq.put("šu ", 9);
    freq.put("sví", 7);
    freq.put("své", 36);
    freq.put("utk", 7);
    freq.put("uti", 11);
    freq.put("utn", 25);
    freq.put("uto", 72);
    freq.put("svá", 8);
    freq.put("utr", 6);
    freq.put("svý", 13);
    freq.put("utu", 12);
    freq.put("uty", 10);
    freq.put("puš", 4);
    freq.put("idě", 36);
    freq.put("Ty", 21);
    freq.put("Tv", 4);
    freq.put("Tw", 31);
    freq.put("Tu", 33);
    freq.put("Tr", 24);
    freq.put("To", 129);
    freq.put("Th", 14);
    freq.put("Ti", 31);
    freq.put("Te", 77);
    freq.put("Ta", 177);
    freq.put("nab", 34);
    freq.put("nac", 25);
    freq.put("vsk", 33);
    freq.put("naf", 3);
    freq.put("Bel", 3);
    freq.put("nad", 114);
    freq.put("ruč", 22);
    freq.put("naj", 39);
    freq.put("nak", 45);
    freq.put("nah", 31);
    freq.put("nan", 28);
    freq.put("nao", 3);
    freq.put("nal", 70);
    freq.put("nam", 71);
    freq.put("nar", 16);
    freq.put("nas", 43);
    freq.put("nap", 67);
    freq.put("nav", 41);
    freq.put("nat", 40);
    freq.put("nau", 9);
    freq.put("naz", 12);
    freq.put("ooo", 7);
    freq.put("iér", 8);
    freq.put("ruš", 21);
    freq.put("ruž", 10);
    freq.put("T ", 88);
    freq.put("Aa", 3);
    freq.put("svo", 28);
    freq.put("Ac", 9);
    freq.put("Ab", 10);
    freq.put("e", 19054);
    freq.put("Ad", 6);
    freq.put("Ag", 3);
    freq.put("svi", 6);
    freq.put("dve", 13);
    freq.put("Ah", 18);
    freq.put("Ak", 33);
    freq.put("Am", 18);
    freq.put("Al", 92);
    freq.put("sva", 6);
    freq.put("Ap", 38);
    freq.put("As", 30);
    freq.put("Ar", 16);
    freq.put("Au", 21);
    freq.put("At", 12);
    freq.put("ú", 155);
    freq.put("utý", 5);
    freq.put("zí", 127);
    freq.put("gu", 74);
    freq.put("gs", 4);
    freq.put("zé", 6);
    freq.put("zá", 202);
    freq.put("gy", 15);
    freq.put("ge", 85);
    freq.put("gb", 4);
    freq.put("zú", 3);
    freq.put("go", 54);
    freq.put("gn", 29);
    freq.put("gm", 4);
    freq.put("gl", 72);
    freq.put("gi", 86);
    freq.put("zó", 16);
    freq.put("lko", 21);
    freq.put("Nok", 9);
    freq.put("lke", 18);
    freq.put("Noc", 3);
    freq.put("lky", 34);
    freq.put("Not", 4);
    freq.put("Člo", 6);
    freq.put("Nov", 51);
    freq.put("lku", 13);
    freq.put("Nor", 6);
    freq.put("kce", 35);
    freq.put("př", 732);
    freq.put("ozí", 9);
    freq.put("kci", 26);
    freq.put("arý", 5);
    freq.put("ozó", 5);
    freq.put("g ", 76);
    freq.put("hi ", 5);
    freq.put("adí", 21);
    freq.put("Spr", 3);
    freq.put("No ", 45);
    freq.put("lk ", 4);
    freq.put("Spi", 6);
    freq.put("Spo", 10);
    freq.put("Spa", 15);
    freq.put("adé", 3);
    freq.put("zl", 61);
    freq.put("zm", 51);
    freq.put("zn", 259);
    freq.put("zo", 129);
    freq.put("zh", 69);
    freq.put("zi", 239);
    freq.put("zj", 32);
    freq.put("zk", 172);
    freq.put("zd", 197);
    freq.put("ze", 507);
    freq.put("za", 888);
    freq.put("zb", 55);
    freq.put("zc", 9);
    freq.put("zy", 51);
    freq.put("zz", 6);
    freq.put("zt", 31);
    freq.put("zu", 77);
    freq.put("zv", 144);
    freq.put("zp", 116);
    freq.put("Bů", 4);
    freq.put("zr", 41);
    freq.put("zs", 10);
    freq.put(" vš", 117);
    freq.put("ižn", 5);
    freq.put("Uč", 3);
    freq.put("iži", 12);
    freq.put("lké", 13);
    freq.put(" vů", 28);
    freq.put("lká", 13);
    freq.put("yck", 12);
    freq.put("lký", 11);
    freq.put("oč", 228);
    freq.put(" vž", 16);
    freq.put("ozd", 30);
    freq.put("oze", 34);
    freq.put("ozb", 6);
    freq.put("ozc", 5);
    freq.put("oza", 7);
    freq.put("ozn", 49);
    freq.put("ozo", 18);
    freq.put("ozl", 5);
    freq.put("ozm", 7);
    freq.put("z ", 561);
    freq.put("ozk", 8);
    freq.put("ozh", 47);
    freq.put("ozi", 26);
    freq.put("ozv", 24);
    freq.put("ozt", 5);
    freq.put("ozu", 13);
    freq.put("ozr", 3);
    freq.put("ozs", 3);
    freq.put("ozp", 12);
    freq.put(" vě", 117);
    freq.put("nže", 16);
    freq.put("Aha", 3);
    freq.put("iž ", 27);
    freq.put("Aho", 10);
    freq.put("zný", 10);
    freq.put("vbu", 6);
    freq.put("duš", 7);
    freq.put("vby", 3);
    freq.put("wif", 4);
    freq.put("wie", 3);
    freq.put("wic", 3);
    freq.put("win", 5);
    freq.put("wit", 50);
    freq.put("uš ", 3);
    freq.put("gů", 3);
    freq.put("nší", 10);
    freq.put("ším", 48);
    freq.put(" vá", 94);
    freq.put(" ví", 130);
    freq.put("ýho", 24);
    freq.put("ýhl", 4);
    freq.put("pš", 61);
    freq.put("ýhe", 3);
    freq.put(" vý", 137);
    freq.put("Ji", 28);
    freq.put("Noč", 4);
    freq.put("JS ", 3);
    freq.put("dčí", 3);
    freq.put("ízd", 7);
    freq.put("íze", 31);
    freq.put("íza", 3);
    freq.put("ízl", 4);
    freq.put("ízn", 5);
    freq.put("buc", 6);
    freq.put("ízk", 8);
    freq.put("pů", 74);
    freq.put("ČT ", 17);
    freq.put("zů", 13);
    freq.put("zš", 6);
    freq.put("krt", 4);
    freq.put("zát", 5);
    freq.put(" va", 45);
    freq.put(" vc", 5);
    freq.put(" ve", 313);
    freq.put("krk", 5);
    freq.put(" vi", 148);
    freq.put(" vh", 6);
    freq.put(" vk", 6);
    freq.put(" vl", 93);
    freq.put(" vo", 87);
    freq.put(" vn", 7);
    freq.put(" vp", 5);
    freq.put(" vs", 40);
    freq.put(" vr", 26);
    freq.put(" vu", 4);
    freq.put("zř", 26);
    freq.put("mít", 46);
    freq.put(" vy", 376);
    freq.put(" vz", 71);
    freq.put("ozš", 5);
    freq.put("dči", 6);
    freq.put("zn ", 4);
    freq.put("ízí", 11);
    freq.put(" v ", 661);
    freq.put("mín", 33);
    freq.put("xpo", 4);
    freq.put("TO ", 8);
    freq.put("ozř", 14);
    freq.put("hlý", 6);
    freq.put("jnu", 3);
    freq.put("jna", 8);
    freq.put("jne", 7);
    freq.put("jni", 6);
    freq.put("jno", 13);
    freq.put("hlá", 36);
    freq.put("vří", 4);
    freq.put("BF ", 3);
    freq.put("míc", 9);
    freq.put("jn ", 10);
    freq.put("beš", 7);
    freq.put("éž ", 3);
    freq.put("hly", 4);
    freq.put("ec ", 101);
    freq.put("iří", 5);
    freq.put("urč", 17);
    freq.put("hlu", 9);
    freq.put("mas", 23);
    freq.put("jný", 13);
    freq.put("hlo", 33);
    freq.put("jná", 6);
    freq.put("mar", 37);
    freq.put("hli", 26);
    freq.put("vře", 19);
    freq.put("jné", 17);
    freq.put("jní", 6);
    freq.put("mav", 40);
    freq.put("ase", 73);
    freq.put("kód", 7);
    freq.put("max", 8);
    freq.put("ece", 35);
    freq.put("eca", 5);
    freq.put("eco", 16);
    freq.put("ecn", 24);
    freq.put("eck", 78);
    freq.put("eci", 12);
    freq.put("ech", 335);
    freq.put("ect", 16);
    freq.put("ecy", 3);
    freq.put("hl ", 32);
    freq.put("rs ", 9);
    freq.put("art", 77);
    freq.put(" Sy", 8);
    freq.put(" Sr", 3);
    freq.put(" Sp", 41);
    freq.put(" Sv", 11);
    freq.put(" Sw", 3);
    freq.put(" St", 111);
    freq.put(" Su", 15);
    freq.put(" Sk", 18);
    freq.put(" Sh", 11);
    freq.put(" Si", 15);
    freq.put(" Sn", 19);
    freq.put(" So", 39);
    freq.put(" Sl", 41);
    freq.put(" Sm", 5);
    freq.put(" Sc", 18);
    freq.put(" Sa", 55);
    freq.put(" Se", 31);
    freq.put("rsk", 26);
    freq.put("rse", 6);
    freq.put("adš", 15);
    freq.put("rsa", 3);
    freq.put("rsc", 3);
    freq.put("R", 283);
    freq.put("rce", 13);
    freq.put("rst", 17);
    freq.put("NU ", 4);
    freq.put("bej", 12);
    freq.put("bek", 4);
    freq.put("beh", 5);
    freq.put("ben", 30);
    freq.put("urá", 15);
    freq.put("bel", 13);
    freq.put("jně", 41);
    freq.put("bec", 41);
    freq.put("bed", 5);
    freq.put("rca", 6);
    freq.put("bez", 80);
    freq.put("arc", 11);
    freq.put("ber", 55);
    freq.put("bes", 4);
    freq.put(" S ", 36);
    freq.put("bet", 12);

    init2();
  }
  private static void init2() {
    
    freq.put("are", 34);
    freq.put("buz", 4);
    freq.put("eď ", 55);
    freq.put("sv", 178);
    freq.put("py ", 35);
    freq.put("ark", 44);
    freq.put("ur ", 13);
    freq.put("arm", 27);
    freq.put("Jde", 8);
    freq.put(" Sá", 3);
    freq.put("bic", 15);
    freq.put("BA ", 4);
    freq.put("pyt", 3);
    freq.put("but", 4);
    freq.put("eďt", 5);
    freq.put("čák", 3);
    freq.put("ure", 12);
    freq.put("ulá", 14);
    freq.put("ura", 32);
    freq.put("urb", 5);
    freq.put("urc", 5);
    freq.put("urn", 17);
    freq.put("uro", 21);
    freq.put("uri", 12);
    freq.put("urk", 6);
    freq.put("urt", 13);
    freq.put("uru", 12);
    freq.put("urv", 13);
    freq.put("urs", 4);
    freq.put("bun", 4);
    freq.put("ury", 12);
    freq.put("urz", 24);
    freq.put("bul", 14);
    freq.put("žir", 4);
    freq.put("žis", 3);
    freq.put("živ", 61);
    freq.put("žit", 47);
    freq.put("žij", 14);
    freq.put("žil", 33);
    freq.put("ubí", 3);
    freq.put("tší", 25);
    freq.put("žid", 4);
    freq.put("nge", 15);
    freq.put("vši", 27);
    freq.put("ŠÍ ", 3);
    freq.put("ngl", 16);
    freq.put("ngo", 12);
    freq.put("vše", 86);
    freq.put("sh ", 10);
    freq.put("ngu", 34);
    freq.put("otě", 17);
    freq.put("ngr", 3);
    freq.put("ýst", 8);
    freq.put("ngy", 3);
    freq.put("všt", 8);
    freq.put("všu", 5);
    freq.put("tbo", 4);
    freq.put("tba", 21);
    freq.put("ži ", 14);
    freq.put("shr", 4);
    freq.put("sht", 6);
    freq.put("shu", 5);
    freq.put("otř", 31);
    freq.put("dpa", 6);
    freq.put("dpo", 54);
    freq.put("shi", 4);
    freq.put("dpl", 6);
    freq.put("sho", 23);
    freq.put("ke ", 36);
    freq.put("tši", 15);
    freq.put("lup", 13);
    freq.put("lus", 15);
    freq.put("lut", 5);
    freq.put("luv", 33);
    freq.put("vší", 3);
    freq.put("lux", 8);
    freq.put("luz", 11);
    freq.put("lub", 20);
    freq.put("luc", 11);
    freq.put("lud", 7);
    freq.put("lue", 4);
    freq.put("luh", 12);
    freq.put("luj", 29);
    freq.put("luk", 29);
    freq.put("lum", 3);
    freq.put("lun", 13);
    freq.put("ken", 22);
    freq.put("kem", 74);
    freq.put("Sra", 3);
    freq.put("kej", 47);
    freq.put("keh", 3);
    freq.put("kec", 7);
    freq.put("dní", 168);
    freq.put("key", 3);
    freq.put("ket", 24);
    freq.put("ker", 15);
    freq.put("lu ", 124);
    freq.put("žiž", 12);
    freq.put("ot ", 30);
    freq.put("Lon", 10);
    freq.put("Los", 3);
    freq.put("Lot", 3);
    freq.put("žiš", 4);
    freq.put("šit", 24);
    freq.put("blé", 39);
    freq.put("oti", 65);
    freq.put("otk", 38);
    freq.put("otl", 5);
    freq.put("otn", 21);
    freq.put("oto", 111);
    freq.put("ota", 37);
    freq.put("otb", 16);
    freq.put("otc", 8);
    freq.put("ote", 80);
    freq.put("Ryc", 3);
    freq.put("oty", 17);
    freq.put("otr", 11);
    freq.put("ots", 5);
    freq.put("ott", 4);
    freq.put("otu", 25);
    freq.put("otv", 15);
    freq.put("And", 27);
    freq.put("Ang", 4);
    freq.put("ndr", 34);
    freq.put("blá", 9);
    freq.put("Ano", 11);
    freq.put("Ani", 7);
    freq.put("Zůs", 4);
    freq.put("žič", 3);
    freq.put("dpů", 3);
    freq.put("You", 5);
    freq.put("jí ", 248);
    freq.put("keč", 3);
    freq.put("zy ", 30);
    freq.put("luž", 23);
    freq.put("luš", 24);
    freq.put("oté", 8);
    freq.put("otí", 5);
    freq.put("otá", 21);
    freq.put("keš", 5);
    freq.put("luč", 5);
    freq.put("Špa", 5);
    freq.put("i", 9355);
    freq.put("mře", 16);
    freq.put("zyl", 4);
    freq.put("zyk", 9);
    freq.put(" xD", 30);
    freq.put("dmě", 6);
    freq.put("Be", 41);
    freq.put("třn", 4);
    freq.put("třo", 5);
    freq.put("eač", 3);
    freq.put("Ba", 51);
    freq.put("Bl", 29);
    freq.put("tře", 133);
    freq.put("Bo", 53);
    freq.put("Bi", 9);
    freq.put("Bt", 3);
    freq.put("Bu", 32);
    freq.put("Br", 58);
    freq.put("hč", 4);
    freq.put("By", 17);
    freq.put("hů", 28);
    freq.put("HK ", 3);
    freq.put("hř", 29);
    freq.put("B ", 59);
    freq.put("áce", 24);
    freq.put(" x ", 21);
    freq.put("tř ", 4);
    freq.put("ést", 6);
    freq.put("GS ", 5);
    freq.put("ách", 63);
    freq.put("žce", 3);
    freq.put("jle", 28);
    freq.put("hně", 5);
    freq.put("U ", 43);
    freq.put("tří", 47);
    freq.put(" Už", 30);
    freq.put("Bá", 4);
    freq.put("hůn", 8);
    freq.put("Bí", 6);
    freq.put("hůr", 5);
    freq.put("ýbě", 9);
    freq.put("Bý", 3);
    freq.put("Uz", 6);
    freq.put("Uv", 7);
    freq.put("pp", 65);
    freq.put("Us", 3);
    freq.put("Ur", 5);
    freq.put("Um", 5);
    freq.put("Ul", 3);
    freq.put("Un", 6);
    freq.put("Uh", 4);
    freq.put("amy", 9);
    freq.put("Ud", 8);
    freq.put("Uf", 8);
    freq.put("hů ", 7);
    freq.put("ádk", 12);
    freq.put("duc", 22);
    freq.put("ea ", 6);
    freq.put("h ", 815);
    freq.put(" Če", 82);
    freq.put(" Ča", 7);
    freq.put("Mít", 3);
    freq.put(" Čl", 10);
    freq.put("Mís", 4);
    freq.put(" Ču", 4);
    freq.put(" Čt", 10);
    freq.put("eak", 15);
    freq.put("hy", 116);
    freq.put("eam", 14);
    freq.put("eal", 15);
    freq.put("ean", 6);
    freq.put("hr", 229);
    freq.put("hs", 5);
    freq.put("hp", 5);
    freq.put("hv", 48);
    freq.put("ead", 11);
    freq.put("eag", 6);
    freq.put("hu", 200);
    freq.put("hk", 7);
    freq.put("hi", 52);
    freq.put("hn", 207);
    freq.put("ho", 1224);
    freq.put("hl", 519);
    freq.put("hm", 18);
    freq.put("hc", 129);
    freq.put("eas", 4);
    freq.put("ear", 6);
    freq.put("ph", 23);
    freq.put("hd", 3);
    freq.put("Bě", 6);
    freq.put("dma", 5);
    freq.put("dus", 4);
    freq.put("dmi", 11);
    freq.put("Vzn", 3);
    freq.put("vra", 18);
    freq.put("jů ", 7);
    freq.put("bož", 10);
    freq.put("Vzp", 3);
    freq.put("Zít", 3);
    freq.put("hůř", 3);
    freq.put("hn ", 3);
    freq.put("aďa", 5);
    freq.put(" Čí", 9);
    freq.put(" Up", 6);
    freq.put("šic", 30);
    freq.put(" Ur", 4);
    freq.put(" Ul", 3);
    freq.put(" Um", 5);
    freq.put(" Un", 5);
    freq.put(" Uh", 4);
    freq.put(" Ud", 8);
    freq.put(" Uf", 8);
    freq.put("ymě", 4);
    freq.put("Už", 30);
    freq.put("hý", 28);
    freq.put("hó", 3);
    freq.put("hé", 33);
    freq.put("há", 133);
    freq.put("hna", 17);
    freq.put("hne", 33);
    freq.put("hni", 41);
    freq.put("ta", 1474);
    freq.put("dmí", 7);
    freq.put("hno", 52);
    freq.put("hnu", 24);
    freq.put("hny", 30);
    freq.put(" U ", 11);
    freq.put("MS ", 8);
    freq.put("ams", 14);
    freq.put("eč ", 5);
    freq.put("ěkn", 29);
    freq.put("aud", 7);
    freq.put("blo", 35);
    freq.put("up ", 38);
    freq.put("aun", 6);
    freq.put("aus", 12);
    freq.put("aur", 9);
    freq.put("aut", 67);
    freq.put("auz", 5);
    freq.put("eče", 63);
    freq.put("ící", 74);
    freq.put("ečn", 120);
    freq.put("ečk", 21);
    freq.put("eču", 4);
    freq.put("ečt", 14);
    freq.put("amt", 3);
    freq.put("upn", 19);
    freq.put("upo", 16);
    freq.put("ňte", 9);
    freq.put("hci", 37);
    freq.put("upk", 4);
    freq.put("upi", 45);
    freq.put("upg", 3);
    freq.put("upd", 7);
    freq.put("upe", 53);
    freq.put("upc", 10);
    freq.put("upa", 23);
    freq.put("upy", 8);
    freq.put("drá", 15);
    freq.put("upt", 5);
    freq.put("upu", 20);
    freq.put("upr", 9);
    freq.put("Stř", 6);
    freq.put("me ", 305);
    freq.put("žou", 3);
    freq.put("žov", 11);
    freq.put("íc ", 60);
    freq.put("amv", 3);
    freq.put("Pul", 3);
    freq.put("neo", 16);
    freq.put("nel", 15);
    freq.put("eDa", 3);
    freq.put("nej", 207);
    freq.put("nek", 64);
    freq.put("neh", 20);
    freq.put("nef", 15);
    freq.put("ově", 75);
    freq.put("ned", 99);
    freq.put("nee", 7);
    freq.put("neb", 206);
    freq.put("nec", 160);
    freq.put("nea", 4);
    freq.put("nez", 75);
    freq.put("ýca", 3);
    freq.put("nev", 118);
    freq.put("dr ", 3);
    freq.put("net", 56);
    freq.put("neu", 41);
    freq.put("ner", 46);
    freq.put("Kaž", 9);
    freq.put("nep", 93);
    freq.put("íco", 3);
    freq.put("med", 19);
    freq.put("у", 3);
    freq.put("íck", 3);
    freq.put("íci", 24);
    freq.put("ích", 150);
    freq.put("ečí", 3);
    freq.put("mel", 20);
    freq.put("íce", 49);
    freq.put("men", 113);
    freq.put("mek", 7);
    freq.put("mej", 8);
    freq.put("met", 28);
    freq.put("ovš", 4);
    freq.put("mes", 19);
    freq.put("mer", 42);
    freq.put("íct", 9);
    freq.put("ovů", 3);
    freq.put("mez", 43);
    freq.put("ií ", 13);
    freq.put("drz", 4);
    freq.put("upé", 3);
    freq.put("drs", 3);
    freq.put("dru", 53);
    freq.put("ne ", 323);
    freq.put("dri", 8);
    freq.put("orm", 50);
    freq.put("dro", 57);
    freq.put("dra", 57);
    freq.put("dre", 16);
    freq.put("Uve", 3);
    freq.put("ork", 23);
    freq.put("něj", 169);
    freq.put("něk", 134);
    freq.put("něl", 23);
    freq.put("něm", 24);
    freq.put(" Pě", 9);
    freq.put("Ste", 22);
    freq.put("Sta", 35);
    freq.put("Sto", 15);
    freq.put("auč", 8);
    freq.put("ový", 141);
    freq.put("Stu", 7);
    freq.put("ová", 179);
    freq.put("Str", 15);
    freq.put("V", 499);
    freq.put("ové", 182);
    freq.put("oví", 20);
    freq.put("Co ", 36);
    freq.put("arť", 3);
    freq.put("Lid", 10);
    freq.put("Lif", 3);
    freq.put("Lib", 17);
    freq.put("Lin", 7);
    freq.put("Lik", 4);
    freq.put("ov ", 13);
    freq.put("Lip", 3);
    freq.put("neř", 10);
    freq.put("Kad", 8);
    freq.put("meč", 3);
    freq.put("Kan", 7);
    freq.put("Al ", 3);
    freq.put("cí ", 136);
    freq.put("než", 88);
    freq.put("Kar", 12);
    freq.put("žím", 13);
    freq.put("Tic", 3);
    freq.put("ovr", 3);
    freq.put("ovs", 27);
    freq.put("neč", 38);
    freq.put("Stá", 7);
    freq.put("ovu", 17);
    freq.put("ůzn", 8);
    freq.put("ovy", 35);
    freq.put("ůzk", 5);
    freq.put("ovc", 5);
    freq.put("ova", 336);
    freq.put("ove", 77);
    freq.put("ovk", 34);
    freq.put("ovi", 134);
    freq.put("ovn", 86);
    freq.put("ovo", 154);
    freq.put("ovl", 7);
    freq.put("Alo", 3);
    freq.put("cím", 8);
    freq.put("cíl", 6);
    freq.put("cíh", 10);
    freq.put("Ale", 69);
    freq.put("cíc", 37);
    freq.put("meň", 6);
    freq.put("cít", 6);
    freq.put("Alp", 3);
    freq.put("cíp", 3);
    freq.put("rád", 69);
    freq.put("ráb", 6);
    freq.put("rác", 41);
    freq.put("rán", 68);
    freq.put("rál", 41);
    freq.put("rám", 12);
    freq.put("ráj", 3);
    freq.put("rák", 11);
    freq.put("ráv", 106);
    freq.put("rát", 102);
    freq.put("rár", 4);
    freq.put("rás", 30);
    freq.put("řad", 26);
    freq.put("ráz", 26);
    freq.put("ono", 20);
    freq.put(" zí", 46);
    freq.put(" zá", 180);
    freq.put("onc", 45);
    freq.put("PR ", 3);
    freq.put("rá ", 52);
    freq.put("láš", 30);
    freq.put("ong", 9);
    freq.put("éle", 3);
    freq.put("elé", 29);
    freq.put("zdy", 11);
    freq.put("isé", 4);
    freq.put("lář", 15);
    freq.put("isí", 25);
    freq.put("Úp", 3);
    freq.put("Ús", 9);
    freq.put("doč", 7);
    freq.put("Wor", 5);
    freq.put("íná", 35);
    freq.put("SS ", 10);
    freq.put(" zm", 32);
    freq.put(" zl", 26);
    freq.put(" zo", 20);
    freq.put(" zn", 70);
    freq.put(" zi", 36);
    freq.put(" zh", 8);
    freq.put(" zk", 61);
    freq.put(" zj", 21);
    freq.put(" ze", 157);
    freq.put(" zd", 64);
    freq.put(" za", 750);
    freq.put("zdo", 9);
    freq.put(" zc", 3);
    freq.put(" zb", 42);
    freq.put("xu ", 9);
    freq.put(" zu", 9);
    freq.put(" zt", 15);
    freq.put("is ", 71);
    freq.put(" zp", 68);
    freq.put(" zr", 30);
    freq.put("zde", 21);
    freq.put("isy", 3);
    freq.put("xus", 16);
    freq.put("iss", 6);
    freq.put("doš", 9);
    freq.put(" z ", 261);
    freq.put("isu", 11);
    freq.put("ist", 218);
    freq.put("isk", 50);
    freq.put("isi", 3);
    freq.put("ish", 3);
    freq.put("iso", 15);
    freq.put("Čím", 4);
    freq.put("ism", 13);
    freq.put("isl", 16);
    freq.put("isc", 12);
    freq.put("ise", 15);
    freq.put("Eur", 8);
    freq.put("Úč", 4);
    freq.put("gy ", 11);
    freq.put("lá ", 53);
    freq.put("uál", 38);
    freq.put("ráž", 14);
    freq.put("ukn", 17);
    freq.put("Ti ", 8);
    freq.put("Col", 4);
    freq.put("lám", 19);
    freq.put("lán", 73);
    freq.put("lák", 12);
    freq.put("lád", 74);
    freq.put("lác", 6);
    freq.put("láz", 10);
    freq.put("lát", 10);
    freq.put("láv", 12);
    freq.put("lár", 10);
    freq.put("jj ", 7);
    freq.put("ráč", 8);
    freq.put("Úž", 3);
    freq.put("ty ", 249);
    freq.put(" zř", 11);
    freq.put("ývo", 16);
    freq.put(" zů", 7);
    freq.put("do ", 373);
    freq.put("tyl", 9);
    freq.put("dí ", 105);
    freq.put("tyh", 7);
    freq.put("tyd", 9);
    freq.put("typ", 9);
    freq.put("doj", 17);
    freq.put("dok", 62);
    freq.put("doh", 11);
    freq.put("don", 5);
    freq.put("dol", 18);
    freq.put("dom", 81);
    freq.put("dob", 165);
    freq.put("doc", 20);
    freq.put("m", 7429);
    freq.put("dod", 8);
    freq.put("doz", 10);
    freq.put("dor", 21);
    freq.put("dos", 113);
    freq.put("dop", 70);
    freq.put("dov", 95);
    freq.put("dow", 16);
    freq.put("dot", 16);
    freq.put("dou", 108);
    freq.put(" We", 12);
    freq.put(" Wa", 9);
    freq.put(" Wo", 9);
    freq.put(" Wh", 6);
    freq.put(" Wi", 27);
    freq.put("rží", 14);
    freq.put("ači", 11);
    freq.put("ačk", 33);
    freq.put("ačl", 4);
    freq.put("ačo", 15);
    freq.put("ačn", 47);
    freq.put("ača", 23);
    freq.put("ače", 14);
    freq.put("zak", 25);
    freq.put("ba ", 93);
    freq.put("aču", 5);
    freq.put("ačt", 3);
    freq.put("sů ", 8);
    freq.put("omá", 30);
    freq.put("omé", 7);
    freq.put("omí", 26);
    freq.put("omý", 4);
    freq.put("bav", 54);
    freq.put("bat", 17);
    freq.put("ěží", 12);
    freq.put("bar", 18);
    freq.put("bas", 8);
    freq.put("ač ", 13);
    freq.put("baz", 5);
    freq.put("bag", 5);
    freq.put("bab", 9);
    freq.put("bac", 6);
    freq.put("ban", 31);
    freq.put("bal", 50);
    freq.put("Naš", 11);
    freq.put("iž", 58);
    freq.put("Vč", 12);
    freq.put("ržn", 4);
    freq.put("iš", 81);
    freq.put("Vě", 17);
    freq.put("rže", 11);
    freq.put("iř", 10);
    freq.put("ačí", 61);
    freq.put("Rum", 4);
    freq.put("ačá", 10);
    freq.put("ěž ", 13);
    freq.put("Ruz", 4);
    freq.put("iň", 4);
    freq.put("Svě", 4);
    freq.put("Dvě", 3);
    freq.put("Rus", 16);
    freq.put("omb", 15);
    freq.put("C", 310);
    freq.put("pěš", 16);
    freq.put("ome", 70);
    freq.put("omi", 31);
    freq.put("omh", 4);
    freq.put("omo", 63);
    freq.put("omn", 17);
    freq.put("oml", 18);
    freq.put("oms", 12);
    freq.put("omr", 3);
    freq.put("omp", 13);
    freq.put("omu", 78);
    freq.put("omt", 4);
    freq.put("omy", 12);
    freq.put("rž ", 3);
    freq.put("ěžn", 10);
    freq.put("Vš", 19);
    freq.put("uns", 3);
    freq.put("unt", 7);
    freq.put("ěžk", 14);
    freq.put("ěži", 3);
    freq.put("ěže", 12);
    freq.put("šou", 6);
    freq.put("una", 10);
    freq.put("unc", 9);
    freq.put("ič", 135);
    freq.put("une", 20);
    freq.put("iď", 3);
    freq.put("ung", 37);
    freq.put("uni", 30);
    freq.put("unk", 29);
    freq.put("Vž", 7);
    freq.put("uno", 4);
    freq.put("ón ", 3);
    freq.put("íny", 7);
    freq.put("ió", 7);
    freq.put("ié", 9);
    freq.put("ií", 14);
    freq.put("iá", 47);
    freq.put("C ", 51);
    freq.put(" řa", 7);
    freq.put("sl ", 14);
    freq.put("íns", 10);
    freq.put("mci", 5);
    freq.put("óna", 4);
    freq.put("mce", 5);
    freq.put("ínu", 5);
    freq.put("ónu", 3);
    freq.put("óny", 9);
    freq.put("Vá", 40);
    freq.put("Ci", 16);
    freq.put("Ch", 67);
    freq.put("Co", 59);
    freq.put("sly", 15);
    freq.put("Cl", 9);
    freq.put("slu", 62);
    freq.put("Ca", 19);
    freq.put("Ví", 34);
    freq.put("Ce", 38);
    freq.put("Mál", 3);
    freq.put("Cz", 6);
    freq.put("Cy", 3);
    freq.put("slo", 93);
    freq.put("sli", 19);
    freq.put("sle", 168);
    freq.put("Vý", 20);
    freq.put("Cu", 6);
    freq.put("Nab", 9);
    freq.put("ix", 15);
    freq.put("pě ", 6);
    freq.put("iz", 140);
    freq.put("Naj", 3);
    freq.put("ip", 110);
    freq.put("is", 488);
    freq.put("ir", 119);
    freq.put("iu", 18);
    freq.put("it", 809);
    freq.put("iw", 3);
    freq.put("iv", 312);
    freq.put("ii", 42);
    freq.put("Nas", 4);
    freq.put("Nap", 9);
    freq.put("ij", 104);
    freq.put("im", 279);
    freq.put("il", 790);
    freq.put("io", 88);
    freq.put("in", 898);
    freq.put("ia", 130);
    freq.put("ic", 644);
    freq.put("ib", 71);
    freq.put("ie", 146);
    freq.put("id", 382);
    freq.put("ig", 87);
    freq.put("if", 37);
    freq.put("V ", 100);
    freq.put("áčk", 7);
    freq.put("iP", 57);
    freq.put("áče", 16);
    freq.put("iT", 12);
    freq.put("íne", 8);
    freq.put("iH", 5);
    freq.put("iL", 5);
    freq.put("iO", 11);
    freq.put("omě", 20);
    freq.put("iD", 19);
    freq.put("Svo", 3);
    freq.put("Na ", 70);
    freq.put("pěj", 3);
    freq.put("pěk", 23);
    freq.put("omů", 17);
    freq.put("pěl", 5);
    freq.put("kii", 3);
    freq.put("pěv", 8);
    freq.put("kin", 16);
    freq.put("pět", 49);
    freq.put("kil", 8);
    freq.put("i ", 2629);
    freq.put("kia", 5);
    freq.put("kie", 3);
    freq.put("slý", 4);
    freq.put("Ve", 49);
    freq.put("Vi", 30);
    freq.put("Vl", 24);
    freq.put("ěžš", 3);
    freq.put("slí", 49);
    freq.put("Vs", 6);
    freq.put("Vu", 3);
    freq.put("Otá", 7);
    freq.put("Vy", 50);
    freq.put("Vz", 11);
    freq.put("slá", 4);
    freq.put("op ", 20);
    freq.put("yer", 3);
    freq.put("věď", 4);
    freq.put("ax ", 8);
    freq.put("eur", 14);
    freq.put("opt", 4);
    freq.put("opu", 16);
    freq.put("ěru", 10);
    freq.put("opr", 74);
    freq.put("ops", 19);
    freq.put("ye ", 8);
    freq.put("opy", 9);
    freq.put("ope", 38);
    freq.put("opa", 49);
    freq.put("opl", 16);
    freq.put("opn", 6);
    freq.put("opo", 35);
    freq.put("opi", 47);
    freq.put("Art", 3);
    freq.put("vda", 10);
    freq.put("věř", 26);
    freq.put("Arc", 3);
    freq.put("šet", 33);
    freq.put("vdi", 3);
    freq.put("www", 11);
    freq.put("bri", 14);
    freq.put("lči", 4);
    freq.put("Dál", 3);
    freq.put("Dám", 4);
    freq.put("zu ", 24);
    freq.put("idí", 67);
    freq.put("ČR ", 26);
    freq.put("idé", 11);
    freq.put("opá", 7);
    freq.put("opí", 11);
    freq.put("zur", 3);
    freq.put("zub", 8);
    freq.put("zuj", 25);
    freq.put("zum", 11);
    freq.put("vě ", 104);
    freq.put("vdě", 6);
    freq.put("opě", 22);
    freq.put("síl", 30);
    freq.put("věj", 10);
    freq.put("věk", 35);
    freq.put("věl", 23);
    freq.put("věn", 6);
    freq.put("TE ", 4);
    freq.put("věc", 34);
    freq.put("věd", 69);
    freq.put("věz", 11);
    freq.put("věr", 14);
    freq.put("Z", 304);
    freq.put("vět", 106);
    freq.put("opř", 13);
    freq.put("řec", 25);
    freq.put("Šlu", 7);
    freq.put("bča", 16);
    freq.put("NE ", 7);
    freq.put("EA ", 9);
    freq.put("Win", 16);
    freq.put("Wik", 6);
    freq.put("nkr", 8);
    freq.put("čty", 15);
    freq.put("čtv", 22);
    freq.put("Méd", 4);
    freq.put("čtu", 13);
    freq.put("Skv", 6);
    freq.put("čto", 3);
    freq.put("eží", 8);
    freq.put("čte", 20);
    freq.put("di ", 50);
    freq.put("FI ", 3);
    freq.put("ěčí", 3);
    freq.put("tnu", 4);
    freq.put("ióz", 4);
    freq.put("gé", 6);
    freq.put("šed", 3);
    freq.put("dil", 53);
    freq.put("dim", 13);
    freq.put("din", 104);
    freq.put("dio", 19);
    freq.put("dik", 8);
    freq.put("did", 7);
    freq.put("die", 16);
    freq.put("ers", 27);
    freq.put("dia", 14);
    freq.put("jho", 3);
    freq.put("dic", 12);
    freq.put("ér", 40);
    freq.put("dit", 63);
    freq.put("diu", 7);
    freq.put("div", 34);
    freq.put("dir", 5);
    freq.put("dis", 46);
    freq.put("ežr", 4);
    freq.put("zře", 24);
    freq.put(" Yo", 7);
    freq.put(" Ye", 3);
    freq.put("ery", 18);
    freq.put("iář", 3);
    freq.put("eže", 4);
    freq.put("Gra", 6);
    freq.put("zně", 16);
    freq.put("eži", 30);
    freq.put("tne", 13);
    freq.put("AM ", 3);
    freq.put("bo ", 115);
    freq.put("sně", 39);
    freq.put("DS ", 6);
    freq.put("ión", 3);
    freq.put("čář", 3);
    freq.put("maž", 3);
    freq.put("ež ", 88);
    freq.put("tno", 17);
    freq.put("box", 4);
    freq.put("dií", 4);
    freq.put("bor", 49);
    freq.put("bos", 5);
    freq.put("bot", 38);
    freq.put("diá", 8);
    freq.put("bov", 20);
    freq.put("boh", 20);
    freq.put("boj", 28);
    freq.put("bol", 12);
    freq.put("bom", 7);
    freq.put("bon", 11);
    freq.put("boo", 52);
    freq.put("boa", 10);
    freq.put("sí ", 38);
    freq.put("bod", 13);
    freq.put("dič", 17);
    freq.put("oo ", 10);
    freq.put("čtů", 4);
    freq.put("ábo", 7);
    freq.put("ul ", 31);
    freq.put("ood", 3);
    freq.put("oog", 52);
    freq.put("Ben", 6);
    freq.put(" Ří", 6);
    freq.put("sná", 21);
    freq.put("oom", 4);
    freq.put("ool", 7);
    freq.put(" Řá", 3);
    freq.put("sní", 31);
    freq.put("ook", 55);
    freq.put("sné", 21);
    freq.put("Bez", 11);
    freq.put("oot", 5);
    freq.put("oor", 6);
    freq.put("Ber", 8);
    freq.put("Bes", 3);
    freq.put("sný", 21);
    freq.put("Bet", 4);
    freq.put("čtě", 7);
    freq.put("zná", 44);
    freq.put("zné", 6);
    freq.put("ulv", 3);
    freq.put("diš", 4);
    freq.put("zní", 27);
    freq.put("ulu", 12);
    freq.put("fli", 3);
    freq.put("ulk", 16);
    freq.put("uli", 29);
    freq.put("uln", 5);
    freq.put("ulo", 14);
    freq.put("ull", 4);
    freq.put("fla", 7);
    freq.put("Hle", 5);
    freq.put("ula", 23);
    freq.put("fle", 6);
    freq.put("Hla", 8);
    freq.put("ule", 14);
    freq.put("akč", 3);
    freq.put("ma ", 137);
    freq.put("boč", 6);
    freq.put("iál", 36);
    freq.put("ián", 5);
    freq.put("nyn", 16);
    freq.put("nym", 5);
    freq.put("nyc", 4);
    freq.put("map", 10);
    freq.put(" Ři", 3);
    freq.put("sne", 10);
    freq.put("mat", 80);
    freq.put("sna", 64);
    freq.put("sno", 20);
    freq.put(" Řa", 3);
    freq.put("maz", 14);
    freq.put(" Ře", 18);
    freq.put("sni", 15);
    freq.put("mac", 29);
    freq.put("mad", 8);
    freq.put("mag", 10);
    freq.put("mai", 18);
    freq.put("mak", 5);
    freq.put("maj", 63);
    freq.put("mam", 31);
    freq.put("mal", 62);
    freq.put("sny", 4);
    freq.put("čás", 18);
    freq.put("čát", 12);
    freq.put("zne", 19);
    freq.put("ulý", 4);
    freq.put("zni", 33);
    freq.put("zno", 15);
    freq.put("q", 7);
    freq.put("ulé", 5);
    freq.put("ulí", 3);
    freq.put("ny ", 249);
    freq.put("Až", 15);
    freq.put("jé", 3);
    freq.put("gee", 6);
    freq.put("lsk", 26);
    freq.put("lsi", 6);
    freq.put("lst", 10);
    freq.put(" ab", 63);
    freq.put(" ac", 10);
    freq.put(" ad", 14);
    freq.put(" af", 6);
    freq.put(" ag", 10);
    freq.put(" ah", 6);
    freq.put(" aj", 5);
    freq.put(" ak", 62);
    freq.put(" al", 296);
    freq.put(" am", 21);
    freq.put(" an", 110);
    freq.put("gen", 25);
    freq.put(" ap", 42);
    freq.put(" ar", 16);
    freq.put(" as", 112);
    freq.put(" at", 16);
    freq.put(" au", 74);
    freq.put(" av", 5);
    freq.put(" az", 16);
    freq.put("Shr", 3);
    freq.put("ls ", 14);
    freq.put("She", 3);
    freq.put("orá", 12);
    freq.put(" a ", 1003);
    freq.put("Vík", 3);
    freq.put("Víc", 6);
    freq.put("Vít", 18);
    freq.put("řeč", 15);
    freq.put("lam", 42);
    freq.put("Lux", 4);
    freq.put("ně ", 579);
    freq.put("ův ", 12);
    freq.put("Luc", 3);
    freq.put("Luk", 3);
    freq.put("or ", 85);
    freq.put("Dů", 3);
    freq.put("Ker", 3);
    freq.put(" Žá", 3);
    freq.put("nět", 18);
    freq.put("RT ", 18);
    freq.put("G", 158);
    freq.put("ory", 31);
    freq.put("něz", 4);
    freq.put("oru", 74);
    freq.put("orr", 8);
    freq.put("ors", 8);
    freq.put("orn", 31);
    freq.put("oro", 40);
    freq.put("orl", 6);
    freq.put("něc", 66);
    freq.put("něd", 4);
    freq.put("Dě", 25);
    freq.put("ori", 36);
    freq.put("orf", 5);
    freq.put("org", 13);
    freq.put("ord", 15);
    freq.put("ore", 45);
    freq.put("orb", 7);
    freq.put("ůvo", 26);
    freq.put("něn", 44);
    freq.put("ora", 57);
    freq.put("řeš", 41);
    freq.put("App", 37);
    freq.put("cát", 5);
    freq.put("ak ", 753);
    freq.put("řež", 10);
    freq.put("gů ", 3);
    freq.put("Zř", 3);
    freq.put("Tím", 4);
    freq.put("Dí", 33);
    freq.put(" ať", 13);
    freq.put("Dá", 12);
    freq.put(" až", 59);
    freq.put(" ač", 3);
    freq.put(" Ša", 5);
    freq.put(" Šk", 14);
    freq.put(" Šm", 4);
    freq.put(" Šl", 8);
    freq.put(" Šp", 10);
    freq.put(" Šv", 5);
    freq.put(" Šu", 12);
    freq.put("IS ", 4);
    freq.put("zsk", 4);
    freq.put("tu ", 235);
    freq.put("Dn", 70);
    freq.put("Do", 101);
    freq.put("Dl", 4);
    freq.put("Di", 25);
    freq.put("ůvě", 4);
    freq.put("De", 38);
    freq.put("Da", 55);
    freq.put("Mzd", 4);
    freq.put("Dv", 13);
    freq.put("aků", 3);
    freq.put("Du", 11);
    freq.put("Dr", 24);
    freq.put("vky", 25);
    freq.put("ábn", 3);
    freq.put("něž", 7);
    freq.put("orů", 18);
    freq.put("Já ", 68);
    freq.put("orš", 12);
    freq.put("řeh", 24);
    freq.put("řek", 61);
    freq.put("řej", 79);
    freq.put("řem", 20);
    freq.put("řel", 50);
    freq.put("řen", 51);
    freq.put(" Šé", 3);
    freq.put("řeb", 65);
    freq.put("řed", 188);
    freq.put("D ", 228);
    freq.put("řez", 9);
    freq.put("řep", 13);
    freq.put("řes", 89);
    freq.put("řet", 26);
    freq.put("řev", 10);
    freq.put("šá", 7);
    freq.put("šé", 9);
    freq.put("ší", 403);
    freq.put("ge ", 14);
    freq.put("lí ", 67);
    freq.put("ába", 14);
    freq.put("We", 14);
    freq.put("ábe", 3);
    freq.put("Wa", 9);
    freq.put("Wo", 9);
    freq.put("Wi", 27);
    freq.put("Wh", 6);
    freq.put("а", 5);
    freq.put("šní", 38);
    freq.put("ges", 5);
    freq.put("ger", 9);
    freq.put("líz", 7);
    freq.put("Ša", 5);
    freq.put("get", 9);
    freq.put("líp", 6);
    freq.put("Šk", 14);
    freq.put("lís", 10);
    freq.put("lít", 13);
    freq.put("Šl", 8);
    freq.put("Šm", 4);
    freq.put("jí", 432);
    freq.put("Šp", 10);
    freq.put("lík", 13);
    freq.put("Šv", 5);
    freq.put("lím", 29);
    freq.put("lín", 15);
    freq.put("Šu", 12);
    freq.put("tuá", 29);
    freq.put("líb", 33);
    freq.put("líc", 4);
    freq.put("líd", 11);
    freq.put("já", 141);
    freq.put("gem", 9);
    freq.put("gel", 3);
    freq.put("W ", 15);
    freq.put("ute", 42);
    freq.put("ó", 70);
    freq.put("ažš", 4);
    freq.put("ša", 25);
    freq.put("šc", 6);
    freq.put("še", 330);
    freq.put("š ", 232);
    freq.put("ši", 140);
    freq.put("pař", 3);
    freq.put("šk", 128);
    freq.put("šm", 7);
    freq.put("šl", 90);
    freq.put("šo", 21);
    freq.put("šn", 89);
    freq.put("šp", 32);
    freq.put("šs", 4);
    freq.put("šr", 3);
    freq.put("šu", 31);
    freq.put("št", 236);
    freq.put("paň", 4);
    freq.put("j ", 318);
    freq.put("ain", 10);
    freq.put("paš", 3);
    freq.put("ůmě", 7);
    freq.put("tur", 41);
    freq.put("akz", 9);
    freq.put("CH ", 3);
    freq.put("tuz", 3);
    freq.put("tus", 10);
    freq.put("jz", 10);
    freq.put("jt", 77);
    freq.put("ju", 79);
    freq.put("jv", 29);
    freq.put("Šé", 3);
    freq.put("jp", 10);
    freq.put("jr", 4);
    freq.put("js", 659);
    freq.put("jl", 35);
    freq.put("jm", 85);
    freq.put("jn", 132);
    freq.put("jo", 107);
    freq.put("jh", 5);
    freq.put("ji", 376);
    freq.put("jj", 7);
    freq.put("jk", 17);
    freq.put("jd", 149);
    freq.put("je", 1716);
    freq.put("jf", 4);
    freq.put("tud", 36);
    freq.put("ja", 496);
    freq.put("jb", 10);
    freq.put("jc", 28);
    freq.put("tuh", 6);
    freq.put("dku", 20);
    freq.put("tuj", 56);
    freq.put("dky", 19);
    freq.put(" Že", 17);
    freq.put("dke", 3);
    freq.put("dka", 24);
    freq.put("dko", 7);
    freq.put("dkl", 6);
    freq.put(" Ži", 4);
    freq.put("tum", 19);
    freq.put("tun", 3);
    freq.put("Oči", 8);
    freq.put("cla", 11);
    freq.put("tua", 20);
    freq.put("žku", 3);
    freq.put("až ", 59);
    freq.put("líč", 13);
    freq.put("žky", 3);
    freq.put("líž", 21);
    freq.put("líš", 10);
    freq.put("ažu", 9);
    freq.put("ažr", 3);
    freq.put("ažs", 19);
    freq.put("ažd", 47);
    freq.put("aže", 23);
    freq.put("vyř", 9);
    freq.put("ěď ", 4);
    freq.put("ažo", 3);
    freq.put("aži", 12);
    freq.put("šš", 5);
    freq.put("ům ", 40);
    freq.put("šť", 15);
    freq.put("pap", 6);
    freq.put("par", 71);
    freq.put("pas", 21);
    freq.put("pat", 68);
    freq.put("pau", 3);
    freq.put("pav", 7);
    freq.put("jč", 18);
    freq.put("jď", 14);
    freq.put("pad", 152);
    freq.put("pag", 7);
    freq.put("pak", 60);
    freq.put("pal", 28);
    freq.put("pam", 27);
    freq.put("pan", 33);
    freq.put("oin", 3);
    freq.put("Hne", 4);
    freq.put("tuž", 3);
    freq.put("A ", 190);
    freq.put("oid", 31);
    freq.put("Ško", 11);
    freq.put("jů", 7);
    freq.put("tuš", 7);
    freq.put("ůmy", 7);
    freq.put("jš", 96);
    freq.put("nag", 3);
    freq.put("šší", 5);
    freq.put("uju", 56);
    freq.put("pa ", 22);
    freq.put("ujm", 4);
    freq.put("ujo", 8);
    freq.put("ažá", 3);
    freq.put("ujd", 3);
    freq.put("dků", 3);
    freq.put("Uz ", 6);
    freq.put("mo ", 28);
    freq.put("ím ", 467);
    freq.put("zl ", 4);
    freq.put(" cí", 11);
    freq.put("cyk", 11);
    freq.put("ěco", 67);
    freq.put("ěci", 21);
    freq.put("ěch", 26);
    freq.put("aří", 22);
    freq.put("moz", 24);
    freq.put("ímu", 9);
    freq.put("ímt", 3);
    freq.put("mov", 38);
    freq.put("mou", 25);
    freq.put("mot", 17);
    freq.put("mok", 3);
    freq.put("moj", 13);
    freq.put("ímo", 10);
    freq.put("ímn", 4);
    freq.put("ími", 9);
    freq.put("ímh", 4);
    freq.put("ímk", 5);
    freq.put("mol", 4);
    freq.put("íme", 42);
    freq.put("mob", 36);
    freq.put("íma", 51);
    freq.put("mod", 29);
    freq.put("zle", 14);
    freq.put("zla", 8);
    freq.put("zru", 6);
    freq.put("zlo", 13);
    freq.put("úno", 5);
    freq.put("zlu", 6);
    freq.put("ěc ", 13);
    freq.put("áží", 13);
    freq.put("Nen", 11);
    freq.put("Nem", 14);
    freq.put("Nej", 39);
    freq.put("Nek", 5);
    freq.put("Neh", 3);
    freq.put("Ned", 7);
    freq.put("Neb", 9);
    freq.put("ař ", 5);
    freq.put("ýšl", 14);
    freq.put("Nez", 10);
    freq.put("Nex", 5);
    freq.put("Nev", 8);
    freq.put("New", 4);
    freq.put("Net", 10);
    freq.put("Neu", 6);
    freq.put("Nes", 8);
    freq.put("Nep", 8);
    freq.put("Med", 3);
    freq.put(" ch", 273);
    freq.put(" ci", 31);
    freq.put(" co", 247);
    freq.put(" cl", 3);
    freq.put(" cm", 7);
    freq.put(" cc", 21);
    freq.put(" ca", 15);
    freq.put(" ce", 164);
    freq.put(" cz", 150);
    freq.put("Met", 4);
    freq.put(" cy", 8);
    freq.put("áž ", 6);
    freq.put("Mer", 3);
    freq.put("ěcí", 6);
    freq.put(" cv", 4);
    freq.put("Mex", 4);
    freq.put(" ct", 5);
    freq.put(" cu", 4);
    freq.put("fáz", 3);
    freq.put("aři", 15);
    freq.put("aře", 12);
    freq.put("Dru", 4);
    freq.put("Ne ", 19);
    freq.put("Dri", 5);
    freq.put("ímé", 3);
    freq.put("fám", 18);
    freq.put("Dra", 5);
    freq.put("ímá", 8);
    freq.put("zů ", 5);
    freq.put("žas", 10);
    freq.put("km ", 14);
    freq.put(" c ", 5);
    freq.put("áže", 10);
    freq.put("žad", 6);
    freq.put("ážn", 25);
    freq.put("áži", 9);
    freq.put("žal", 8);
    freq.put("zpr", 38);
    freq.put("zpu", 4);
    freq.put("Vče", 12);
    freq.put("yyy", 6);
    freq.put("moč", 3);
    freq.put(" šu", 6);
    freq.put("mož", 53);
    freq.put("na ", 1326);
    freq.put("áho", 12);
    freq.put("zpa", 4);
    freq.put("utá", 5);
    freq.put("moš", 7);
    freq.put("moř", 11);
    freq.put("Af", 4);
    freq.put("Ai", 3);
    freq.put("vho", 7);
    freq.put("dva", 34);
    freq.put("zůs", 7);
    freq.put("eši", 14);
    freq.put("An", 59);
    freq.put("býv", 28);
    freq.put("být", 40);
    freq.put("Neř", 4);
    freq.put("ařů", 3);
    freq.put("Drž", 4);
    freq.put("ajz", 7);
    freq.put("úst", 3);
    freq.put("Neč", 9);
    freq.put("úsp", 17);
    freq.put("US ", 5);
    freq.put("bý ", 3);
    freq.put("u", 7482);
    freq.put("úsm", 3);
    freq.put("edb", 5);
    freq.put("Van", 3);
    freq.put("Val", 4);
    freq.put("Vam", 3);
    freq.put("iu ", 4);
    freq.put("ář ", 26);
    freq.put("Var", 9);
    freq.put("Vas", 3);
    freq.put("gr", 65);
    freq.put("hy ", 49);
    freq.put("ws ", 12);
    freq.put("yzk", 11);
    freq.put("abí", 42);
    freq.put("DJ ", 4);
    freq.put("yzn", 6);
    freq.put("abý", 3);
    freq.put("ium", 8);
    freq.put("áře", 18);
    freq.put("éka", 7);
    freq.put("jdř", 4);
    freq.put("ius", 4);
    freq.put("ičn", 17);
    freq.put("ářs", 11);
    freq.put("aše", 43);
    freq.put("jdů", 4);
    freq.put("dež", 5);
    freq.put("ašl", 8);
    freq.put("ašn", 16);
    freq.put("aši", 20);
    freq.put("hyn", 5);
    freq.put("ašt", 13);
    freq.put("hys", 13);
    freq.put("hyt", 12);
    freq.put("ašs", 3);
    freq.put("deš", 21);
    freq.put("ga", 68);
    freq.put("Zvl", 3);
    freq.put("Zve", 4);
    freq.put("aba", 14);
    freq.put("abe", 10);
    freq.put("ují", 70);
    freq.put("abi", 31);
    freq.put("abl", 22);
    freq.put("abo", 6);
    freq.put("abr", 5);
    freq.put("abs", 7);
    freq.put("abu", 8);
    freq.put("aby", 67);
    freq.put("gh", 22);
    freq.put("áří", 22);
    freq.put("ryč", 3);
    freq.put("K", 442);
    freq.put("ášť", 3);
    freq.put("aší", 17);
    freq.put("ýbo", 9);
    freq.put("éto", 12);
    freq.put("Vaš", 13);
    freq.put("akt", 92);
    freq.put("kýc", 52);
    freq.put("kým", 32);
    freq.put("lka", 29);
    freq.put("kýh", 5);
    freq.put("twa", 4);
    freq.put("ťuj", 3);
    freq.put("twi", 20);
    freq.put("eyn", 4);
    freq.put("de ", 345);
    freq.put("ářů", 5);
    freq.put("Ať ", 5);
    freq.put("ký ", 144);
    freq.put("éta", 5);
    freq.put("dex", 3);
    freq.put("ey ", 5);
    freq.put("dez", 3);
    freq.put("jdn", 3);
    freq.put("jdi", 6);
    freq.put("dep", 11);
    freq.put("der", 33);
    freq.put("des", 66);
    freq.put("det", 26);
    freq.put("dev", 18);
    freq.put("deh", 4);
    freq.put("dej", 73);
    freq.put("dek", 23);
    freq.put("del", 68);
    freq.put("dem", 68);
    freq.put("den", 185);
    freq.put("deo", 26);
    freq.put("jdu", 23);
    freq.put("dea", 6);
    freq.put("deb", 13);
    freq.put("dec", 28);
    freq.put("def", 13);
    freq.put("jdr", 3);
    freq.put("sťt", 3);
    freq.put("Do ", 17);
    freq.put("iPa", 19);
    freq.put("áš ", 60);
    freq.put("ryh", 3);
    freq.put("Kč ", 62);
    freq.put("iPh", 33);
    freq.put("ryb", 6);
    freq.put("ryc", 40);
    freq.put("abů", 6);
    freq.put("ryt", 9);
    freq.put("íto", 9);
    freq.put("Dok", 3);
    freq.put("Doh", 3);
    freq.put("Don", 5);
    freq.put("bka", 3);
    freq.put("Dob", 28);
    freq.put("Doc", 8);
    freq.put("bko", 4);
    freq.put("Dod", 3);
    freq.put("Dos", 6);
    freq.put("Dop", 7);
    freq.put("Dou", 6);
    freq.put("áše", 12);
    freq.put("áši", 3);
    freq.put("ry ", 119);
    freq.put("ášt", 8);
    freq.put("uh ", 6);
    freq.put("koř", 3);
    freq.put("ok ", 85);
    freq.put("íká", 28);
    freq.put("koš", 4);
    freq.put("Při", 47);
    freq.put("pci", 6);
    freq.put("kož", 7);
    freq.put("pce", 7);
    freq.put("Bat", 5);
    freq.put("okr", 37);
    freq.put("Bar", 14);
    freq.put("okt", 4);
    freq.put("uha", 10);
    freq.put("oky", 16);
    freq.put("uho", 49);
    freq.put("uhl", 24);
    freq.put("oka", 14);
    freq.put("Bab", 12);
    freq.put("Ban", 10);
    freq.put("Bal", 3);
    freq.put("okl", 15);
    freq.put("oko", 88);
    freq.put("okn", 11);
    freq.put("zjí", 4);
    freq.put("uj ", 17);
    freq.put("vůb", 21);
    freq.put("vůl", 19);
    freq.put("kč", 27);
    freq.put("ód ", 6);
    freq.put("vůr", 4);
    freq.put("mm ", 9);
    freq.put("íke", 23);
    freq.put("íka", 22);
    freq.put("íko", 6);
    freq.put("íkl", 9);
    freq.put("E ", 62);
    freq.put("íku", 12);
    freq.put("vně", 74);
    freq.put("čí ", 57);
    freq.put("íky", 74);
    freq.put("vů ", 4);
    freq.put("ódy", 3);
    freq.put("я", 3);
    freq.put("uhé", 25);
    freq.put("oká", 18);
    freq.put("sba", 3);
    freq.put("oké", 4);
    freq.put("Uni", 4);
    freq.put("kř", 17);
    freq.put("uhý", 21);
    freq.put("mma", 4);
    freq.put("sbo", 4);
    freq.put("El", 7);
    freq.put("kš", 3);
    freq.put("En", 7);
    freq.put("zji", 22);
    freq.put("ík ", 38);
    freq.put("těž", 42);
    freq.put("Ed", 3);
    freq.put("zje", 6);
    freq.put("ků", 71);
    freq.put("čís", 26);
    freq.put("čím", 17);
    freq.put("čín", 38);
    freq.put("Ex", 17);
    freq.put("těš", 22);
    freq.put("Eu", 8);
    freq.put("Ev", 30);
    freq.put("kž", 46);
    freq.put("Er", 9);
    freq.put("rro", 6);
    freq.put("vím", 63);
    freq.put(" el", 16);
    freq.put(" em", 11);
    freq.put("kok", 6);
    freq.put("koj", 17);
    freq.put("kom", 62);
    freq.put("kol", 183);
    freq.put("koo", 3);
    freq.put(" ek", 3);
    freq.put(" ed", 5);
    freq.put(" ef", 6);
    freq.put("kob", 4);
    freq.put(" ea", 3);
    freq.put("kof", 3);
    freq.put(" ex", 31);
    freq.put(" et", 4);
    freq.put(" eu", 12);
    freq.put(" ev", 18);
    freq.put("kor", 47);
    freq.put("kou", 231);
    freq.put("kot", 10);
    freq.put(" er", 3);
    freq.put(" es", 13);
    freq.put("vná", 11);
    freq.put("Slu", 4);
    freq.put("vní", 129);
    freq.put("vné", 16);
    freq.put("Slo", 10);
    freq.put("Sli", 4);
    freq.put("Sle", 19);
    freq.put("vný", 11);
    freq.put("WP ", 8);
    freq.put("Sla", 4);
    freq.put("íni", 3);
    freq.put("ká", 315);
    freq.put("b", 3671);
    freq.put("ko ", 222);
    freq.put("ké", 283);
    freq.put("Xa", 3);
    freq.put(" e ", 8);
    freq.put("kó", 10);
    freq.put("ujt", 12);
    freq.put("ký", 237);
    freq.put("Cze", 6);
    freq.put("gá", 9);
    freq.put("Mla", 6);
    freq.put("k ", 1507);
    freq.put("íků", 18);
    freq.put("vír", 18);
    freq.put("Kin", 4);
    freq.put("tě ", 253);
    freq.put("uji", 37);
    freq.put("kB", 4);
    freq.put("vne", 8);
    freq.put("Ate", 6);
    freq.put("vna", 21);
    freq.put("vno", 21);
    freq.put("ůru", 7);
    freq.put("vni", 44);
    freq.put("vnu", 3);
    freq.put("aží", 15);
    freq.put("ůrc", 3);
    freq.put("vny", 6);
    freq.put("ůra", 4);
    freq.put("kc", 69);
    freq.put("ka", 883);
    freq.put("těs", 10);
    freq.put("ke", 245);
    freq.put("kd", 376);
    freq.put("kk", 6);
    freq.put("vůč", 3);
    freq.put("ki", 48);
    freq.put("kh", 35);
    freq.put("ko", 1332);
    freq.put("kn", 148);
    freq.put("km", 14);
    freq.put("kl", 298);
    freq.put("ks", 15);
    freq.put("kr", 258);
    freq.put("kp", 3);
    freq.put("kv", 102);
    freq.put("ku", 681);
    freq.put("kt", 332);
    freq.put("těn", 13);
    freq.put("kz", 10);
    freq.put("ky", 675);
    freq.put("těm", 5);
    freq.put("číš", 5);
    freq.put("těh", 5);
    freq.put(" Bá", 4);
    freq.put(" Bí", 6);
    freq.put("rét", 5);
    freq.put("Ď", 3);
    freq.put("rén", 8);
    freq.put("rém", 10);
    freq.put("réh", 5);
    freq.put(" Bý", 3);
    freq.put("Opr", 3);
    freq.put("Ope", 12);
    freq.put("ych", 220);
    freq.put("Opi", 3);
    freq.put("ína", 9);
    freq.put("iká", 25);
    freq.put("ré ", 51);
    freq.put("Ser", 5);
    freq.put("yce", 4);
    freq.put(" Be", 38);
    freq.put(" Ba", 48);
    freq.put(" Bl", 28);
    freq.put(" Bo", 49);
    freq.put(" Bi", 9);
    freq.put(" Bu", 32);
    freq.put(" Bt", 3);
    freq.put("ik ", 76);
    freq.put(" Br", 56);
    freq.put(" By", 17);
    freq.put("kcí", 7);
    freq.put("Sed", 3);
    freq.put("DD ", 15);
    freq.put("MF ", 5);
    freq.put("ikr", 9);
    freq.put(" B ", 7);
    freq.put("iku", 27);
    freq.put("ozj", 10);
    freq.put("iky", 38);
    freq.put("ika", 104);
    freq.put("ví ", 85);
    freq.put("ike", 12);
    freq.put("ikd", 34);
    freq.put("iki", 12);
    freq.put("iko", 28);
    freq.put("ikn", 11);
    freq.put("TC ", 6);
    freq.put("ikl", 10);
    freq.put("hřb", 6);
    freq.put("hře", 13);
    freq.put("hři", 8);
    freq.put("lbu", 3);
    freq.put("ga ", 12);
    freq.put("léd", 7);
    freq.put("lém", 43);
    freq.put("léh", 9);
    freq.put("lék", 8);
    freq.put("lét", 12);
    freq.put("lév", 5);
    freq.put("lép", 6);
    freq.put("fu ", 6);
    freq.put("gaz", 4);
    freq.put("gay", 3);
    freq.put("gat", 3);
    freq.put("gas", 5);
    freq.put("gar", 6);
    freq.put("gan", 18);
    freq.put("gal", 5);
    freq.put("Pře", 52);
    freq.put("lba", 13);
    freq.put("fur", 9);
    freq.put("Řec", 10);
    freq.put("lbc", 4);
    freq.put("fun", 49);
    freq.put("lbe", 6);
    freq.put("sy ", 20);
    freq.put(" Bů", 4);
    freq.put("cén", 7);
    freq.put("áfí", 7);
    freq.put("bs ", 17);
    freq.put("mos", 11);
    freq.put("lbo", 6);
    freq.put("mor", 14);
    freq.put("Spí", 4);
    freq.put("syc", 8);
    freq.put("dge", 4);
    freq.put("syn", 8);
    freq.put("sys", 10);
    freq.put("Pří", 15);
    freq.put("iků", 3);
    freq.put("ew ", 9);
    freq.put("moh", 62);
    freq.put("jba", 3);
    freq.put("y", 4187);
    freq.put("jbl", 5);
    freq.put(" Bě", 6);
    freq.put("mon", 32);
    freq.put("mom", 5);
    freq.put("ldi", 4);
    freq.put("ldo", 3);
    freq.put("bi ", 9);
    freq.put("moc", 95);
    freq.put("Sym", 3);
    freq.put("Á ", 6);
    freq.put("cur", 3);
    freq.put("sdě", 4);
    freq.put("rga", 14);
    freq.put("rge", 7);
    freq.put("aps", 21);
    freq.put("rgi", 9);
    freq.put("cul", 3);
    freq.put("cuk", 4);
    freq.put("cuj", 13);
    freq.put("bin", 12);
    freq.put("bio", 4);
    freq.put("bil", 75);
    freq.put("ld ", 19);
    freq.put("bij", 12);
    freq.put("ufá", 18);
    freq.put("bie", 4);
    freq.put("Dia", 4);
    freq.put("biz", 3);
    freq.put("apt", 4);
    freq.put("Div", 7);
    freq.put("bir", 6);
    freq.put("bis", 4);
    freq.put("Dis", 5);
    freq.put("šťu", 3);
    freq.put("rg ", 7);
    freq.put("api", 30);
    freq.put("cu ", 7);
    freq.put("šťo", 3);
    freq.put("apo", 47);
    freq.put("zli", 8);
    freq.put("ah", 182);
    freq.put("žeč", 3);
    freq.put("lyš", 13);
    freq.put("oe ", 6);
    freq.put("pet", 8);
    freq.put("pev", 5);
    freq.put("per", 75);
    freq.put("pes", 8);
    freq.put("pel", 18);
    freq.put("pem", 12);
    freq.put("pen", 51);
    freq.put("pej", 5);
    freq.put("pek", 30);
    freq.put("ávc", 4);
    freq.put("pec", 15);
    freq.put("ufa", 6);
    freq.put("Bor", 6);
    freq.put("Bos", 3);
    freq.put("Bou", 4);
    freq.put("O", 308);
    freq.put("Boh", 14);
    freq.put("Bol", 7);
    freq.put("Bon", 4);
    freq.put("Sně", 3);
    freq.put("Maď", 3);
    freq.put("uso", 11);
    freq.put("pe ", 15);
    freq.put("žeš", 7);
    freq.put("nsi", 3);
    freq.put("nsk", 74);
    freq.put("nso", 6);
    freq.put("ýhr", 5);
    freq.put("nsd", 5);
    freq.put("nsp", 13);
    freq.put("Žen", 5);
    freq.put("nst", 31);
    freq.put("nsu", 3);
    freq.put("mke", 3);
    freq.put("bič", 5);
    freq.put("mka", 3);
    freq.put("mko", 3);
    freq.put("Sní", 3);
    freq.put("mku", 3);
    freq.put("ust", 56);
    freq.put(" R ", 12);
    freq.put("Tři", 4);
    freq.put("ns ", 14);
    freq.put("Tře", 5);
    freq.put("Nec", 18);
    freq.put("Že ", 8);
    freq.put("Flo", 3);
    freq.put("sdo", 5);
    freq.put("zhr", 7);
    freq.put("tvo", 30);
    freq.put("zhl", 16);
    freq.put("zho", 38);
    freq.put("peř", 3);
    freq.put("tve", 5);
    freq.put("lym", 3);
    freq.put("lyn", 8);
    freq.put("Map", 3);
    freq.put("Mas", 6);
    freq.put(" gu", 6);
    freq.put(" gr", 18);
    freq.put("Mat", 7);
    freq.put("Sna", 10);
    freq.put(" gy", 3);
    freq.put("Mac", 12);
    freq.put(" ge", 19);
    freq.put("Mad", 3);
    freq.put("Mag", 6);
    freq.put(" ga", 16);
    freq.put(" go", 17);
    freq.put(" gl", 3);
    freq.put("Mam", 11);
    freq.put("Mal", 12);
    freq.put("že ", 518);
    freq.put(" gi", 5);
    freq.put("peč", 15);
    freq.put("ly ", 168);
    freq.put("žet", 24);
    freq.put("žer", 8);
    freq.put("žen", 73);
    freq.put("žel", 38);
    freq.put("žem", 10);
    freq.put("žek", 4);
    freq.put("žeh", 3);
    freq.put(" Dů", 3);
    freq.put(" c", 955);
    freq.put("véh", 39);
    freq.put(" a", 1973);
    freq.put(" f", 400);
    freq.put(" g", 94);
    freq.put(" d", 2034);
    freq.put(" e", 158);
    freq.put(" j", 2600);
    freq.put(" k", 1562);
    freq.put(" h", 742);
    freq.put(" i", 471);
    freq.put(" n", 4016);
    freq.put(" o", 1196);
    freq.put(" l", 489);
    freq.put(" m", 2074);
    freq.put(" r", 742);
    freq.put(" s", 3581);
    freq.put(" p", 3571);
    freq.put(" v", 2571);
    freq.put(" w", 90);
    freq.put(" t", 3186);
    freq.put(" u", 686);
    freq.put(" z", 2006);
    freq.put(" x", 54);
    freq.put(" y", 6);
    freq.put(" B", 337);
    freq.put(" C", 301);
    freq.put(" A", 565);
    freq.put(" F", 208);
    freq.put(" G", 156);
    freq.put(" D", 821);
    freq.put(" E", 148);
    freq.put(" J", 527);
    freq.put(" K", 440);
    freq.put(" H", 238);
    freq.put(" I", 144);
    freq.put(" N", 603);
    freq.put(" O", 295);
    freq.put(" L", 195);
    freq.put("chů", 13);
    freq.put(" R", 276);
    freq.put(" S", 545);
    freq.put(" P", 882);
    freq.put(" Q", 5);
    freq.put(" V", 498);
    freq.put(" W", 78);
    freq.put(" T", 622);
    freq.put(" U", 149);
    freq.put(" Z", 303);
    freq.put(" X", 23);
    freq.put(" Y", 15);
    freq.put("vli", 3);
    freq.put(" mů", 83);
    freq.put("vlo", 11);
    freq.put("vla", 57);
    freq.put("vle", 6);
    freq.put("chč", 3);
    freq.put("ař", 63);
    freq.put("tož", 32);
    freq.put("štá", 5);
    freq.put(" Dě", 25);
    freq.put("Mez", 5);
    freq.put(" é", 3);
    freq.put(" ú", 143);
    freq.put("Orl", 3);
    freq.put(" ×", 4);
    freq.put("Ori", 6);
    freq.put(" Ú", 31);
    freq.put("Org", 4);
    freq.put("nuá", 3);
    freq.put("vlá", 53);
    freq.put("ádě", 8);
    freq.put("oco", 6);
    freq.put(" Do", 100);
    freq.put(" Dn", 55);
    freq.put(" Š", 69);
    freq.put(" š", 193);
    freq.put("Ver", 3);
    freq.put(" Di", 23);
    freq.put("Bib", 3);
    freq.put(" De", 35);
    freq.put(" Da", 45);
    freq.put("Ved", 7);
    freq.put("ii ", 32);
    freq.put("Ven", 4);
    freq.put(" Dv", 13);
    freq.put(" Du", 10);
    freq.put(" ž", 483);
    freq.put(" Dr", 20);
    freq.put(" Ž", 29);
    freq.put("cha", 74);
    freq.put("Fr", 22);
    freq.put("chc", 114);
    freq.put("che", 27);
    freq.put("chi", 17);
    freq.put(" ň", 3);
    freq.put("chl", 83);
    freq.put("chm", 4);
    freq.put("chn", 110);
    freq.put("cho", 171);
    freq.put("ať ", 14);
    freq.put("chr", 30);
    freq.put("chs", 5);
    freq.put("cht", 56);
    freq.put("chu", 74);
    freq.put("chv", 41);
    freq.put("chw", 6);
    freq.put("chy", 63);
    freq.put(" Ř", 33);
    freq.put(" ř", 160);
    freq.put("Fl", 6);
    freq.put("Fo", 21);
    freq.put("yžt", 5);
    freq.put("MD ", 4);
    freq.put(" D ", 159);
    freq.put("Ve ", 12);
    freq.put("yže", 5);
    freq.put("iii", 6);
    freq.put("yža", 3);
    freq.put("ch ", 727);
    freq.put("f", 870);
    freq.put(" Ď", 3);
    freq.put(" Č", 186);
    freq.put("oct", 6);
    freq.put("F ", 18);
    freq.put(" Dí", 33);
    freq.put("aco", 20);
    freq.put("apí", 12);
    freq.put(" Dá", 12);
    freq.put("chá", 75);
    freq.put("ádu", 13);
    freq.put("ádr", 12);
    freq.put("afi", 18);
    freq.put("Yo", 8);
    freq.put("VD ", 4);
    freq.put("ché", 6);
    freq.put("Ye", 3);
    freq.put("afa", 3);
    freq.put("ává", 65);
    freq.put("áde", 12);
    freq.put("ádc", 3);
    freq.put("áda", 51);
    freq.put("ádn", 55);
    freq.put("ádo", 7);
    freq.put("ádl", 8);
    freq.put("chý", 4);
    freq.put("ádh", 7);
    freq.put("ádi", 17);
    freq.put("Y ", 15);
    freq.put("ád ", 63);
    freq.put("biš", 4);
    freq.put("da ", 194);
    freq.put("ižš", 8);
    freq.put("eum", 12);
    freq.put("lg", 8);
    freq.put("ld", 36);
    freq.put("le", 1937);
    freq.put("lb", 44);
    freq.put("lc", 22);
    freq.put("la", 1296);
    freq.put("ln", 379);
    freq.put("eud", 11);
    freq.put("ll", 79);
    freq.put("lm", 51);
    freq.put("lj", 5);
    freq.put("lk", 159);
    freq.put("lh", 13);
    freq.put("li", 1105);
    freq.put("lv", 16);
    freq.put("lt", 47);
    freq.put("lu", 399);
    freq.put("lr", 3);
    freq.put("ls", 60);
    freq.put("lp", 7);
    freq.put("yří", 4);
    freq.put("eut", 4);
    freq.put("reá", 8);
    freq.put("lz", 25);
    freq.put("eus", 6);
    freq.put(" vt", 12);
    freq.put("daf", 11);
    freq.put("dac", 5);
    freq.put("dal", 129);
    freq.put("dam", 16);
    freq.put("dan", 20);
    freq.put("víř", 8);
    freq.put("dai", 5);
    freq.put("daj", 33);
    freq.put("ohá", 6);
    freq.put("dat", 68);
    freq.put("ogů", 3);
    freq.put("dar", 30);
    freq.put("das", 3);
    freq.put("day", 6);
    freq.put("l ", 1232);
    freq.put("eu ", 6);
    freq.put("ts ", 6);
    freq.put("miň", 3);
    freq.put("emn", 21);
    freq.put("rez", 22);
    freq.put("žív", 29);
    freq.put("rex", 3);
    freq.put("lá", 362);
    freq.put("rer", 3);
    freq.put("Pař", 4);
    freq.put("rep", 51);
    freq.put("lí", 259);
    freq.put("rev", 11);
    freq.put("ret", 22);
    freq.put("lé", 154);
    freq.put("rej", 34);
    freq.put("rek", 60);
    freq.put("ren", 28);
    freq.put("rel", 19);
    freq.put("rem", 53);
    freq.put("reb", 9);
    freq.put("rec", 45);
    freq.put("Tub", 3);
    freq.put("lý", 79);
    freq.put("ref", 14);
    freq.put("reg", 14);
    freq.put("red", 19);
    freq.put("ree", 12);
    freq.put("mič", 4);
    freq.put("lf ", 3);
    freq.put("re ", 49);
    freq.put("Ž", 29);
    freq.put("lň", 4);
    freq.put("ud ", 54);
    freq.put("pgr", 3);
    freq.put("og ", 11);
    freq.put("mié", 7);
    freq.put("sha", 6);
    freq.put("dač", 3);
    freq.put("udr", 10);
    freq.put("ogy", 3);
    freq.put("zč", 3);
    freq.put("ogu", 11);
    freq.put("lč", 6);
    freq.put("ogr", 22);
    freq.put("udb", 13);
    freq.put("ogl", 52);
    freq.put("ogo", 9);
    freq.put("víč", 5);
    freq.put("ogi", 18);
    freq.put("ude", 226);
    freq.put("udk", 3);
    freq.put("udi", 30);
    freq.put("oga", 5);
    freq.put("udo", 58);
    freq.put("Zák", 3);
    freq.put("heh", 3);
    freq.put("šta", 5);
    freq.put("daň", 3);
    freq.put("nul", 46);
    freq.put("što", 5);
    freq.put("dař", 7);
    freq.put("Par", 20);
    freq.put("Pas", 3);
    freq.put("Pat", 4);
    freq.put("Pau", 4);
    freq.put("Pav", 4);
    freq.put("Pay", 3);
    freq.put("Pad", 21);
    freq.put("Pak", 4);
    freq.put("Pal", 11);
    freq.put("Pam", 4);
    freq.put("Pan", 8);
    freq.put("štv", 5);
    freq.put("mik", 6);
    freq.put("rež", 6);
    freq.put("mil", 76);
    freq.put("min", 85);
    freq.put("mia", 3);
    freq.put("mic", 13);
    freq.put("mix", 5);
    freq.put("miz", 5);
    freq.put("mis", 20);
    freq.put("mit", 16);
    freq.put("udá", 4);
    freq.put("reč", 10);
    freq.put("udí", 19);
    freq.put("mi ", 280);
    freq.put("xD ", 4);
    freq.put("tý ", 30);
    freq.put(" iP", 57);
    freq.put(" iT", 12);
    freq.put("užů", 7);
    freq.put(" iH", 5);
    freq.put(" iO", 11);
    freq.put("muz", 27);
    freq.put(" iD", 19);
    freq.put("Moz", 3);
    freq.put(" ip", 3);
    freq.put("Mor", 8);
    freq.put(" ir", 3);
    freq.put(" it", 11);
    freq.put(" ih", 5);
    freq.put("Moj", 7);
    freq.put(" im", 7);
    freq.put(" in", 122);
    freq.put("Moc", 5);
    freq.put("Mob", 6);
    freq.put(" id", 11);
    freq.put("Mod", 3);
    freq.put("týc", 3);
    freq.put("týd", 32);
    freq.put("týk", 4);
    freq.put("eří", 24);
    freq.put("tým", 19);
    freq.put("vrá", 14);
    freq.put("TA ", 4);
    freq.put("hlí", 18);
    freq.put("ks ", 6);
    freq.put(" i ", 187);
    freq.put("hlé", 10);
    freq.put("wd", 3);
    freq.put("epř", 28);
    freq.put("émů", 5);
    freq.put("váž", 25);
    freq.put("Pán", 4);
    freq.put("wl", 3);
    freq.put("eře", 38);
    freq.put("vrt", 28);
    freq.put("eři", 9);
    freq.put("vrz", 6);
    freq.put("vrc", 8);
    freq.put("S", 551);
    freq.put("wi", 71);
    freq.put("vrd", 17);
    freq.put("émě", 15);
    freq.put("wh", 3);
    freq.put("vro", 21);
    freq.put("dý", 39);
    freq.put("niž", 5);
    freq.put("ýt ", 41);
    freq.put("ohl", 136);
    freq.put("užb", 15);
    freq.put("Řid", 3);
    freq.put("uže", 36);
    freq.put("uži", 53);
    freq.put("užk", 5);
    freq.put("ac", 448);
    freq.put("užn", 4);
    freq.put("oho", 147);
    freq.put("užu", 3);
    freq.put("ad", 795);
    freq.put("Mož", 4);
    freq.put("ys ", 21);
    freq.put("ai", 60);
    freq.put("zby", 17);
    freq.put("Ná", 37);
    freq.put("ak", 1583);
    freq.put("už ", 196);
    freq.put("aj", 391);
    freq.put("oha", 20);
    freq.put("cor", 4);
    freq.put("ůln", 3);
    freq.put("cou", 6);
    freq.put("uin", 5);
    freq.put("ysk", 7);
    freq.put("yso", 7);
    freq.put("ysl", 98);
    freq.put("cov", 41);
    freq.put("Hot", 6);
    freq.put("yse", 3);
    freq.put("emí", 10);
    freq.put("Hou", 4);
    freq.put("ysr", 5);
    freq.put("ysp", 4);
    freq.put("ysv", 9);
    freq.put("at", 1043);
    freq.put("užá", 3);
    freq.put(" Fr", 22);
    freq.put(" Fu", 11);
    freq.put("uží", 42);
    freq.put(" Fa", 47);
    freq.put(" Fe", 9);
    freq.put("ohu", 29);
    freq.put(" Fi", 33);
    freq.put(" Fl", 5);
    freq.put(" Fo", 21);
    freq.put("io ", 12);
    freq.put("éma", 14);
    freq.put("vák", 5);
    freq.put("váh", 3);
    freq.put("ván", 111);
    freq.put("vál", 26);
    freq.put("vám", 59);
    freq.put("vád", 7);
    freq.put("émn", 6);
    freq.put("váz", 4);
    freq.put("ému", 25);
    freq.put("vár", 5);
    freq.put("vás", 31);
    freq.put("uhy", 4);
    freq.put("vát", 13);
    freq.put("iot", 6);
    freq.put("ios", 3);
    freq.put("ior", 5);
    freq.put("ion", 49);
    freq.put("ém ", 94);
    freq.put("ysí", 16);
    freq.put("vá ", 155);
    freq.put("con", 16);
    freq.put("fy ", 4);
    freq.put("Zpr", 52);
    freq.put("měř", 29);
    freq.put("uší", 16);
    freq.put("adv", 3);
    freq.put("adu", 50);
    freq.put("adr", 13);
    freq.put("ads", 4);
    freq.put("gma", 3);
    freq.put("ady", 71);
    freq.put("áji", 5);
    freq.put("měť", 3);
    freq.put("ade", 66);
    freq.put("adb", 5);
    freq.put("buď", 6);
    freq.put("esá", 10);
    freq.put("ada", 58);
    freq.put("adn", 67);
    freq.put("ado", 29);
    freq.put("esí", 6);
    freq.put("adm", 3);
    freq.put("áje", 34);
    freq.put("adi", 47);
    freq.put("oBo", 3);
    freq.put("Hyp", 5);
    freq.put("fyz", 3);
    freq.put("kří", 6);
    freq.put("ad ", 158);
    freq.put("ůl ", 20);
    freq.put("ui ", 3);
    freq.put("piš", 10);
    freq.put("ušt", 12);
    freq.put("uši", 15);
    freq.put("ušk", 15);
    freq.put("ušo", 3);
    freq.put("ušn", 15);
    freq.put("ušc", 4);
    freq.put("uše", 45);
    freq.put("esv", 9);
    freq.put("esu", 13);
    freq.put("est", 258);
    freq.put("ess", 17);
    freq.put("esp", 37);
    freq.put("adý", 5);
    freq.put("ubě", 5);
    freq.put("tma", 5);
    freq.put("ese", 49);
    freq.put("esc", 8);
    freq.put("esb", 3);
    freq.put("esa", 7);
    freq.put("adá", 59);
    freq.put("eso", 8);
    freq.put("esn", 41);
    freq.put("esm", 23);
    freq.put("esl", 46);
    freq.put("esk", 175);
    freq.put("esi", 35);
    freq.put("esh", 9);
    freq.put("nj ", 3);
    freq.put("jíž", 10);
    freq.put("dch", 11);
    freq.put("dci", 3);
    freq.put("dce", 22);
    freq.put("tta", 5);
    freq.put("OS ", 18);
    freq.put("pič", 10);
    freq.put("kře", 6);
    freq.put("es ", 199);
    freq.put("šla", 16);
    freq.put("Twi", 31);
    freq.put("bu ", 59);
    freq.put("měv", 3);
    freq.put("mět", 12);
    freq.put("měs", 68);
    freq.put("měr", 19);
    freq.put("ěnu", 8);
    freq.put("měd", 3);
    freq.put("rch", 19);
    freq.put("jšk", 5);
    freq.put("rck", 3);
    freq.put("měn", 49);
    freq.put("měl", 88);
    freq.put("měk", 3);
    freq.put("měj", 11);
    freq.put("Dex", 3);
    freq.put("Dep", 3);
    freq.put("bus", 16);
    freq.put("Des", 3);
    freq.put("adě", 29);
    freq.put("Dev", 3);
    freq.put("buj", 17);
    freq.put("Dej", 5);
    freq.put("Del", 4);
    freq.put("ubá", 3);
    freq.put("Den", 4);
    freq.put("Jdu", 3);
    freq.put("Dea", 4);
    freq.put("Deb", 3);
    freq.put("buf", 3);
    freq.put("bug", 3);
    freq.put("bud", 297);
    freq.put("Iva", 4);
    freq.put("j", 5076);
    freq.put("Hvě", 3);
    freq.put("mě ", 178);
    freq.put("rc ", 6);
    freq.put("pij", 7);
    freq.put("pik", 5);
    freq.put("pil", 42);
    freq.put("pin", 21);
    freq.put("pic", 9);
    freq.put("pid", 3);
    freq.put("pie", 6);
    freq.put("piz", 4);
    freq.put("ub ", 8);
    freq.put("pir", 12);
    freq.put("pis", 45);
    freq.put("pit", 39);
    freq.put("hle", 210);
    freq.put("piv", 21);
    freq.put("Her", 5);
    freq.put("oad", 8);
    freq.put("jší", 88);
    freq.put("oar", 11);
    freq.put("jíz", 7);
    freq.put("ubu", 12);
    freq.put("ěnn", 3);
    freq.put("Ace", 4);
    freq.put("ubs", 3);
    freq.put("pi ", 6);
    freq.put("jís", 3);
    freq.put("uby", 10);
    freq.put("jít", 24);
    freq.put("ube", 18);
    freq.put("uba", 11);
    freq.put("jím", 60);
    freq.put("ubl", 21);
    freq.put("jíc", 60);
    freq.put("ubo", 14);
    freq.put("ubi", 13);
    freq.put("jíd", 14);
    freq.put("ubk", 5);
    freq.put("taž", 7);
    freq.put("ěko", 43);
    freq.put(" ká", 13);
    freq.put("mč", 3);
    freq.put("ěkd", 79);
    freq.put("ěka", 11);
    freq.put(" kó", 8);
    freq.put("ých", 168);
    freq.put("ěku", 30);
    freq.put("ěkt", 15);
    freq.put("mě", 467);
    freq.put(" ký", 5);
    freq.put("TV ", 11);
    freq.put("uře", 7);
    freq.put("G ", 32);
    freq.put("uři", 8);
    freq.put("uřk", 3);
    freq.put("zd ", 5);
    freq.put("síš", 5);
    freq.put("ěk ", 26);
    freq.put("síč", 6);
    freq.put("mř", 21);
    freq.put("Zí", 3);
    freq.put("Gu", 12);
    freq.put("Koč", 3);
    freq.put("Gr", 11);
    freq.put("zdu", 8);
    freq.put("mů", 136);
    freq.put("Zá", 16);
    freq.put("zdr", 29);
    freq.put("Ok ", 3);
    freq.put("Ge", 10);
    freq.put("zdn", 19);
    freq.put("zdi", 9);
    freq.put("Ga", 20);
    freq.put("Go", 54);
    freq.put("mž", 5);
    freq.put("zda", 38);
    freq.put(" ka", 188);
    freq.put(" kd", 248);
    freq.put(" ke", 30);
    freq.put(" ki", 13);
    freq.put(" kn", 34);
    freq.put(" ko", 387);
    freq.put(" kl", 85);
    freq.put(" km", 14);
    freq.put(" kr", 121);
    freq.put(" ks", 3);
    freq.put(" kv", 44);
    freq.put(" kt", 131);
    freq.put(" ku", 71);
    freq.put(" ky", 9);
    freq.put("fér", 5);
    freq.put("enš", 12);
    freq.put("kuz", 9);
    freq.put("kut", 30);
    freq.put("Z ", 33);
    freq.put("kur", 33);
    freq.put("kup", 44);
    freq.put("kun", 3);
    freq.put("kum", 18);
    freq.put("kul", 19);
    freq.put("kuj", 37);
    freq.put("kud", 43);
    freq.put("kuc", 4);
    freq.put("kub", 5);
    freq.put("enž", 8);
    freq.put(" k ", 126);
    freq.put("abá", 10);
    freq.put("gne", 3);
    freq.put("enč", 4);
    freq.put("tz", 7);
    freq.put("eně", 20);
    freq.put("Zl", 14);
    freq.put("Zm", 4);
    freq.put("Zn", 8);
    freq.put("díc", 3);
    freq.put("Zj", 3);
    freq.put("Zk", 9);
    freq.put("Zd", 15);
    freq.put("Ze", 24);
    freq.put("dík", 35);
    freq.put("díl", 36);
    freq.put("Za", 74);
    freq.put("Zb", 15);
    freq.put("zdí", 12);
    freq.put("fé ", 3);
    freq.put("dít", 13);
    freq.put("dív", 34);
    freq.put("Zu", 4);
    freq.put("Zv", 12);
    freq.put("Zp", 57);
    freq.put("ku ", 361);
    freq.put("Koh", 4);
    freq.put("zma", 6);
    freq.put("Kom", 13);
    freq.put("Kol", 8);
    freq.put("zdě", 20);
    freq.put("Kon", 18);
    freq.put("Kod", 3);
    freq.put("Kos", 6);
    freq.put("Kou", 14);
    freq.put("ená", 62);
    freq.put("m ", 2604);
    freq.put("ené", 50);
    freq.put("sít", 15);
    freq.put("ení", 322);
    freq.put("sím", 50);
    freq.put("tm", 14);
    freq.put("síc", 51);
    freq.put("ený", 61);
    freq.put("me", 667);
    freq.put("mf", 4);
    freq.put("ma", 639);
    freq.put("ltu", 11);
    freq.put("mc", 11);
    freq.put("mb", 44);
    freq.put("mm", 18);
    freq.put("ml", 81);
    freq.put("mo", 514);
    freq.put("mn", 140);
    freq.put("mi", 552);
    freq.put("mh", 8);
    freq.put("mk", 17);
    freq.put("mu", 421);
    freq.put("mt", 13);
    freq.put("mv", 4);
    freq.put("mp", 52);
    freq.put("ms", 38);
    freq.put("mr", 65);
    freq.put("kův", 3);
    freq.put("my", 171);
    freq.put("mz", 3);
    freq.put("kuř", 4);
    freq.put(" ků", 4);
    freq.put("Zku", 5);
    freq.put("áři", 22);
    freq.put("ena", 74);
    freq.put("enb", 7);
    freq.put("enc", 38);
    freq.put("end", 51);
    freq.put("ene", 62);
    freq.put("eng", 7);
    freq.put("enh", 6);
    freq.put("eni", 55);
    freq.put("enk", 42);
    freq.put("enn", 19);
    freq.put("eno", 113);
    freq.put("ců ", 26);
    freq.put("ens", 36);
    freq.put("ent", 146);
    freq.put("enu", 32);
    freq.put("eny", 35);
    freq.put("enz", 31);
    freq.put(" kř", 10);
    freq.put("kuš", 11);
    freq.put("ON ", 5);
    freq.put("II ", 11);
    freq.put("en ", 374);
    freq.put("díš", 12);
    freq.put("Zů", 4);
    freq.put("má", 391);
    freq.put("mí", 180);
    freq.put("mé", 68);
    freq.put(" kč", 7);
    freq.put("aná", 29);
    freq.put("mó", 4);
    freq.put("mý", 39);
    freq.put("rDa", 3);
    freq.put("díž", 5);
    freq.put("UK ", 3);
    freq.put(" Hy", 6);
    freq.put("toř", 6);
    freq.put("šná", 5);
    freq.put(" Hr", 26);
    freq.put(" Hv", 3);
    freq.put(" Hu", 10);
    freq.put(" Hi", 10);
    freq.put(" Ho", 49);
    freq.put(" Hn", 3);
    freq.put(" Hm", 9);
    freq.put(" Hl", 18);
    freq.put("šný", 11);
    freq.put(" Ha", 27);
    freq.put(" He", 26);
    freq.put("ima", 28);
    freq.put("ime", 25);
    freq.put("če ", 32);
    freq.put("imi", 16);
    freq.put("cle", 4);
    freq.put("iml", 8);
    freq.put("imo", 15);
    freq.put("imn", 16);
    freq.put("imp", 5);
    freq.put("imu", 11);
    freq.put("ají", 200);
    freq.put("imy", 3);
    freq.put("clu", 4);
    freq.put("toš", 9);
    freq.put("éct", 3);
    freq.put("řsk", 21);
    freq.put("SA ", 13);
    freq.put("hyb", 25);
    freq.put("ílá", 13);
    freq.put("toč", 13);
    freq.put("im ", 131);
    freq.put("čec", 3);
    freq.put("čem", 14);
    freq.put("čel", 7);
    freq.put("čen", 43);
    freq.put("čeh", 4);
    freq.put("ček", 75);
    freq.put("čet", 47);
    freq.put("čep", 5);
    freq.put("čes", 45);
    freq.put("čer", 92);
    freq.put("áha", 9);
    freq.put("raš", 19);
    freq.put("šno", 4);
    freq.put("áhn", 8);
    freq.put("šni", 3);
    freq.put("áhl", 5);
    freq.put("BT ", 3);
    freq.put("raž", 43);
    freq.put("vič", 17);
    freq.put("imá", 11);
    freq.put("gol", 4);
    freq.put("goo", 9);
    freq.put("ajs", 10);
    freq.put("ajt", 3);
    freq.put("aji", 41);
    freq.put("ajk", 3);
    freq.put("ajn", 22);
    freq.put("ajo", 8);
    freq.put("got", 6);
    freq.put("gov", 18);
    freq.put("ajd", 17);
    freq.put("aje", 47);
    freq.put("ajf", 3);
    freq.put("gor", 5);
    freq.put("W", 81);
    freq.put("rův", 4);
    freq.put("Vid", 10);
    freq.put("rač", 23);
    freq.put("Vin", 4);
    freq.put("go ", 7);
    freq.put("Vir", 3);
    freq.put("aj ", 19);
    freq.put("be ", 40);
    freq.put("nhl", 5);
    freq.put("lbá", 3);
    freq.put("toz", 3);
    freq.put("tor", 105);
    freq.put("tos", 30);
    freq.put("top", 31);
    freq.put("tov", 102);
    freq.put("EU ", 17);
    freq.put("tot", 24);
    freq.put("tou", 67);
    freq.put("toj", 21);
    freq.put("tok", 20);
    freq.put("toh", 107);
    freq.put("ton", 19);
    freq.put("tol", 45);
    freq.put("tom", 123);
    freq.put("tob", 13);
    freq.put("toc", 5);
    freq.put("toa", 3);
    freq.put("tog", 6);
    freq.put("tod", 13);
    freq.put("Fun", 3);
    freq.put("češ", 11);
    freq.put("mné", 10);
    freq.put("to ", 1049);
    freq.put("mní", 33);
    freq.put("raf", 24);
    freq.put("rag", 13);
    freq.put("rad", 131);
    freq.put("rae", 3);
    freq.put("rab", 17);
    freq.put("rac", 104);
    freq.put("ran", 151);
    freq.put("ral", 31);
    freq.put("ram", 38);
    freq.put("raj", 51);
    freq.put("rak", 32);
    freq.put("rah", 44);
    freq.put("rai", 9);
    freq.put("rav", 253);
    freq.put("rat", 84);
    freq.put("rar", 9);
    freq.put("ras", 19);
    freq.put("rap", 19);
    freq.put("mná", 8);
    freq.put("raz", 81);
    freq.put("rax", 8);
    freq.put("tho", 3);
    freq.put("Řád", 3);
    freq.put("It ", 4);
    freq.put("ajů", 3);
    freq.put("ánk", 51);
    freq.put("ra ", 184);
    freq.put("bst", 3);
    freq.put("bso", 3);
    freq.put("bsk", 3);
    freq.put("bse", 5);
    freq.put("bsa", 12);
    freq.put("Ita", 3);
    freq.put("žra", 8);
    freq.put("šně", 21);
    freq.put("éz", 7);
    freq.put("ép", 6);
    freq.put("és", 7);
    freq.put("pky", 7);
    freq.put("ét", 24);
    freq.put("év", 6);
    freq.put("éh", 166);
    freq.put("ék", 13);
    freq.put("ém", 176);
    freq.put("él", 5);
    freq.put("én", 57);
    freq.put("éc", 3);
    freq.put("éd", 22);
    freq.put("éf", 12);
    freq.put("oci", 32);
    freq.put("och", 78);
    freq.put("ock", 13);
    freq.put(" ún", 7);
    freq.put(" úh", 3);
    freq.put(" úk", 3);
    freq.put("ocn", 12);
    freq.put("oca", 3);
    freq.put(" úd", 8);
    freq.put("Bie", 3);
    freq.put("oce", 69);
    freq.put(" út", 21);
    freq.put("ocs", 3);
    freq.put(" úp", 20);
    freq.put(" ús", 22);
    freq.put(" úr", 8);
    freq.put("lší", 76);
    freq.put("zdá", 15);
    freq.put("rší", 20);
    freq.put("Aaa", 3);
    freq.put("Šum", 7);
    freq.put("é ", 901);
    freq.put("zbý", 5);
    freq.put("oc ", 92);
    freq.put("šte", 8);
    freq.put("ybr", 8);
    freq.put(" mě", 257);
    freq.put("nux", 6);
    freq.put("Pet", 14);
    freq.put("nut", 58);
    freq.put("Pep", 4);
    freq.put("nus", 20);
    freq.put("Per", 5);
    freq.put("éé", 9);
    freq.put("Pen", 5);
    freq.put("nuj", 19);
    freq.put("ěma", 5);
    freq.put("ěmo", 3);
    freq.put("nud", 9);
    freq.put("nuc", 3);
    freq.put("mut", 12);
    freq.put("ocí", 9);
    freq.put("mus", 115);
    freq.put("mur", 3);
    freq.put("ísu", 3);
    freq.put("íst", 65);
    freq.put("Uff", 4);
    freq.put("ísp", 6);
    freq.put("ísn", 5);
    freq.put("ísm", 5);
    freq.put("ísl", 25);
    freq.put("ísk", 15);
    freq.put("mul", 18);
    freq.put("mun", 16);
    freq.put("muj", 13);
    freq.put("zba", 7);
    freq.put("zbo", 6);
    freq.put("zbl", 3);
    freq.put("zbi", 6);
    freq.put("Ext", 5);
    freq.put("zbr", 8);
    freq.put("Exp", 6);
    freq.put("ěm ", 11);
    freq.put("lšt", 3);
    freq.put("nu ", 174);
    freq.put("ell", 17);
    freq.put("Uf ", 3);
    freq.put("mu ", 179);
    freq.put("úda", 9);
    freq.put(" me", 133);
    freq.put("cný", 4);
    freq.put(" ma", 229);
    freq.put("éž", 3);
    freq.put(" ml", 36);
    freq.put(" mm", 6);
    freq.put(" mn", 49);
    freq.put(" mo", 278);
    freq.put(" mi", 337);
    freq.put(" mu", 179);
    freq.put(" úř", 3);
    freq.put(" mr", 32);
    freq.put(" my", 77);
    freq.put("éř", 4);
    freq.put(" úž", 7);
    freq.put(" úč", 34);
    freq.put(" m ", 8);
    freq.put("Cre", 3);
    freq.put("Cro", 5);
    freq.put("ahř", 3);
    freq.put("n", 13406);
    freq.put("ape", 21);
    freq.put("éč", 8);
    freq.put("Tri", 4);
    freq.put(" má", 236);
    freq.put(" mí", 88);
    freq.put(" mé", 24);
    freq.put(" mó", 4);
    freq.put(" mý", 10);
    freq.put("uje", 200);
    freq.put("muž", 25);
    freq.put("HP ", 19);
    freq.put("šné", 3);
    freq.put(" × ", 4);
    freq.put("muč", 3);
    freq.put("caf", 4);
    freq.put("ěmč", 3);
    freq.put("uď ", 5);
    freq.put("Xan", 3);
    freq.put(" Já", 74);
    freq.put("elk", 74);
    freq.put("eli", 65);
    freq.put("eln", 53);
    freq.put("elo", 56);
    freq.put("icí", 18);
    freq.put("elm", 15);
    freq.put("ela", 84);
    freq.put("eld", 4);
    freq.put("ele", 158);
    freq.put("elz", 3);
    freq.put("ely", 17);
    freq.put("rnu", 11);
    freq.put("els", 18);
    freq.put("cní", 8);
    freq.put("elt", 5);
    freq.put("elu", 16);
    freq.put("D", 888);
    freq.put("uďt", 5);
    freq.put("OH ", 3);
    freq.put("el ", 245);
    freq.put("Věc", 6);
    freq.put("Věd", 3);
    freq.put("Vět", 4);
    freq.put("áně", 7);
    freq.put("vit", 58);
    freq.put(" Ju", 15);
    freq.put(" Js", 41);
    freq.put(" Jo", 56);
    freq.put(" Ji", 28);
    freq.put(" Je", 139);
    freq.put(" Jd", 13);
    freq.put(" Ja", 141);
    freq.put("Hz", 3);
    freq.put("ici", 86);
    freq.put("Hy", 6);
    freq.put("ico", 8);
    freq.put("icm", 4);
    freq.put("nů", 30);
    freq.put("Hr", 26);
    freq.put("nš", 13);
    freq.put("ica", 14);
    freq.put("elá", 11);
    freq.put("Hv", 3);
    freq.put("ice", 105);
    freq.put("Hu", 13);
    freq.put("Hi", 10);
    freq.put("Hn", 5);
    freq.put("Ho", 49);
    freq.put("Hl", 18);
    freq.put("Hm", 9);
    freq.put("cno", 9);
    freq.put("Ha", 27);
    freq.put("tiš", 7);
    freq.put("icu", 4);
    freq.put("He", 27);
    freq.put("nč", 61);
    freq.put("nď", 3);
    freq.put("tič", 9);
    freq.put("ně", 1086);
    freq.put("půs", 15);
    freq.put("čce", 5);
    freq.put("ic ", 102);
    freq.put("nně", 11);
    freq.put("Táb", 3);
    freq.put("H ", 14);
    freq.put("šlo", 18);
    freq.put("nní", 16);
    freq.put("aha", 48);
    freq.put("ána", 11);
    freq.put("nné", 11);
    freq.put("šli", 12);
    freq.put("ppk", 4);
    freq.put("ppi", 5);
    freq.put("šle", 29);
    freq.put("ťá", 15);
    freq.put("áni", 10);
    freq.put("nná", 4);
    freq.put("ppl", 33);
    freq.put("pps", 4);
    freq.put("Nás", 5);
    freq.put("nný", 8);
    freq.put("áns", 11);
    freq.put("Náz", 8);
    freq.put("šlu", 4);
    freq.put("ány", 9);
    freq.put("né", 319);
    freq.put("git", 12);
    freq.put("gis", 10);
    freq.put("ní", 1595);
    freq.put("ná", 655);
    freq.put("elš", 5);
    freq.put("gig", 3);
    freq.put("gie", 16);
    freq.put("gic", 10);
    freq.put("ný", 326);
    freq.put("gin", 17);
    freq.put("gik", 3);
    freq.put("gii", 4);
    freq.put("ah ", 9);
    freq.put("pp ", 9);
    freq.put("án ", 31);
    freq.put("Vod", 14);
    freq.put("Vol", 7);
    freq.put("gi ", 3);
    freq.put("nno", 9);
    freq.put("ťo", 7);
    freq.put("šlí", 8);
    freq.put("ání", 183);
    freq.put("nne", 4);
    freq.put("ťa", 14);
    freq.put("nna", 3);
    freq.put("ěpo", 4);
    freq.put("nny", 4);
    freq.put("ťu", 3);
    freq.put("ťt", 5);
    freq.put("nh", 8);
    freq.put("ni", 778);
    freq.put("nj", 8);
    freq.put("nk", 261);
    freq.put("nl", 25);
    freq.put("nn", 74);
    freq.put("no", 1134);
    freq.put("tit", 81);
    freq.put("na", 2131);
    freq.put("nb", 14);
    freq.put("nc", 160);
    freq.put("nd", 228);
    freq.put("ne", 2352);
    freq.put("nf", 46);
    freq.put("ng", 137);
    freq.put("til", 62);
    freq.put("ny", 292);
    freq.put("nz", 53);
    freq.put("tio", 11);
    freq.put("tih", 13);
    freq.put("ES ", 6);
    freq.put("tif", 6);
    freq.put("ns", 156);
    freq.put("nt", 299);
    freq.put("nu", 346);
    freq.put("nv", 20);
    freq.put("ybí", 4);
    freq.put("ick", 165);
    freq.put("ť ", 44);
    freq.put("ich", 106);
    freq.put("n ", 747);
    freq.put("elí", 9);
    freq.put("icc", 3);
    freq.put("ti ", 239);
    freq.put("roh", 15);
    freq.put("roi", 27);
    freq.put("roj", 49);
    freq.put("rok", 82);
    freq.put("rol", 19);
    freq.put("rom", 64);
    freq.put("ron", 29);
    freq.put("roo", 6);
    freq.put("lls", 4);
    freq.put("rob", 105);
    freq.put("roc", 60);
    freq.put("rod", 130);
    freq.put("rof", 13);
    freq.put("rog", 14);
    freq.put("roz", 177);
    freq.put("llo", 19);
    freq.put("rop", 36);
    freq.put("ror", 9);
    freq.put("ros", 127);
    freq.put("rot", 87);
    freq.put("rou", 77);
    freq.put("rov", 144);
    freq.put("row", 6);
    freq.put("Dal", 16);
    freq.put("Dan", 5);
    freq.put("jéé", 3);
    freq.put("Dat", 15);
    freq.put("Dav", 10);
    freq.put("cne", 9);
    freq.put("nž", 21);
    freq.put("Š", 69);
    freq.put("Cik", 4);
    freq.put("Udě", 6);
    freq.put("elý", 22);
    freq.put("jdo", 13);
    freq.put("mně", 29);
    freq.put("icr", 9);
    freq.put("ll ", 15);
    freq.put("jde", 82);
    freq.put("ict", 15);
    freq.put("Res", 7);
    freq.put("Rep", 8);
    freq.put("žim", 3);
    freq.put("plu", 26);
    freq.put(" oš", 6);
    freq.put("Rek", 4);
    freq.put("Rel", 3);
    freq.put("Rec", 9);
    freq.put("Rea", 12);
    freq.put("Ref", 3);
    freq.put("Reg", 5);
    freq.put("Red", 3);
    freq.put("jdy", 3);
    freq.put("ýsl", 14);
    freq.put(" oč", 16);
    freq.put("Mil", 16);
    freq.put("šál", 3);
    freq.put("vša", 9);
    freq.put("pla", 91);
    freq.put("roš", 17);
    freq.put("rož", 4);
    freq.put("msu", 10);
    freq.put("mst", 4);
    freq.put("Psy", 3);
    freq.put("msk", 20);
    freq.put("ult", 26);
    freq.put("Evo", 5);
    freq.put("Eva", 4);
    freq.put("Evr", 16);
    freq.put("yjd", 7);
    freq.put("roč", 84);
    freq.put("čít", 36);
    freq.put(" on", 50);
    freq.put(" ol", 7);
    freq.put(" om", 20);
    freq.put(" ok", 53);
    freq.put(" oh", 14);
    freq.put("Min", 14);
    freq.put(" of", 18);
    freq.put(" od", 268);
    freq.put(" ob", 200);
    freq.put(" oc", 21);
    freq.put("kyd", 4);
    freq.put(" oz", 18);
    freq.put(" ov", 16);
    freq.put(" ot", 53);
    freq.put(" ou", 5);
    freq.put(" or", 22);
    freq.put(" os", 68);
    freq.put(" op", 86);
    freq.put("kyt", 9);
    freq.put("dé ", 18);
    freq.put(" vč", 22);
    freq.put("fíh", 6);
    freq.put("ky ", 622);
    freq.put(" o ", 246);
    freq.put("dél", 5);
    freq.put("dém", 4);
    freq.put("déh", 3);
    freq.put("Něj", 4);
    freq.put("Něk", 11);
    freq.put("Něm", 12);
    freq.put("sák", 3);
    freq.put("sán", 4);
    freq.put("sám", 16);
    freq.put("áne", 20);
    freq.put("iPo", 4);
    freq.put("sáz", 3);
    freq.put("sát", 14);
    freq.put("ejí", 36);
    freq.put("vte", 7);
    freq.put("ppe", 6);
    freq.put("TP ", 3);
    freq.put("vti", 15);
    freq.put("ahe", 4);
    freq.put("máč", 3);
    freq.put("huť", 5);
    freq.put("áno", 41);
    freq.put("nů ", 26);
    freq.put("ěje", 9);
    freq.put("aho", 18);
    freq.put("máš", 20);
    freq.put("ahl", 13);
    freq.put("učí", 9);
    freq.put("ng ", 43);
    freq.put("huž", 16);
    freq.put("Nám", 5);
    freq.put("dpr", 6);
    freq.put("Nár", 6);
    freq.put("ánu", 12);
    freq.put("mář", 3);
    freq.put("álů", 3);
    freq.put("prš", 6);
    freq.put("prů", 20);
    freq.put("ahu", 24);
    freq.put("anž", 13);
    freq.put("mim", 11);
    freq.put("ejl", 35);
    freq.put("ejm", 46);
    freq.put("ejn", 91);
    freq.put("ejo", 9);
    freq.put("ejh", 5);
    freq.put("eji", 53);
    freq.put("ejk", 7);
    freq.put("ejd", 50);
    freq.put("eje", 35);
    freq.put("eja", 16);
    freq.put("ejb", 10);
    freq.put("ejc", 20);
    freq.put("ejz", 3);
    freq.put("ejt", 53);
    freq.put("eju", 4);
    freq.put("ejv", 28);
    freq.put("ejp", 10);
    freq.put("ejr", 3);
    freq.put("ejs", 37);
    freq.put("uču", 5);
    freq.put("rýc", 7);
    freq.put("ýž", 3);
    freq.put("uče", 14);
    freq.put("dím", 47);
    freq.put("ýš", 31);
    freq.put("učn", 11);
    freq.put("uči", 19);
    freq.put("učk", 4);
    freq.put("elů", 9);
    freq.put("× ", 4);
    freq.put("Pěk", 6);
    freq.put("ej ", 161);
    freq.put("ž", 2091);
    freq.put("Šéf", 3);
    freq.put("aně", 40);
    freq.put("děd", 4);
    freq.put("álí", 12);
    freq.put("prá", 117);
    freq.put("děc", 3);
    freq.put("děn", 22);
    freq.put("aní", 20);
    freq.put("děl", 207);
    freq.put("děj", 26);
    freq.put("děk", 13);
    freq.put("epš", 60);
    freq.put("má ", 121);
    freq.put("dět", 64);
    freq.put("děs", 7);
    freq.put("děp", 4);
    freq.put("prý", 4);
    freq.put("aný", 37);
    freq.put("iam", 4);
    freq.put("IM ", 4);
    freq.put("ian", 14);
    freq.put("iak", 3);
    freq.put("iag", 5);
    freq.put("iac", 3);
    freq.put("ča ", 3);
    freq.put("iat", 5);
    freq.put("ias", 3);
    freq.put("iar", 10);
    freq.put("hud", 20);
    freq.put("már", 4);
    freq.put("mát", 31);
    freq.put("dě ", 40);
    freq.put("huc", 5);
    freq.put("hul", 3);
    freq.put("hum", 8);
    freq.put("huj", 24);
    freq.put("hut", 16);
    freq.put("mác", 14);
    freq.put("mád", 6);
    freq.put("hur", 7);
    freq.put("hus", 6);
    freq.put("máh", 5);
    freq.put("mák", 3);
    freq.put("mám", 138);
    freq.put("mál", 29);
    freq.put("mán", 7);
    freq.put("čas", 114);
    freq.put("čat", 3);
    freq.put(" Lá", 4);
    freq.put("dír", 3);
    freq.put(" Lí", 8);
    freq.put("ia ", 31);
    freq.put("r", 7500);
    freq.put("píš", 40);
    freq.put("čaj", 5);
    freq.put("Mir", 6);
    freq.put("čal", 21);
    freq.put("čan", 10);
    freq.put("pre", 60);
    freq.put("prd", 10);
    freq.put("ang", 23);
    freq.put("pra", 272);
    freq.put("álk", 9);
    freq.put("prc", 6);
    freq.put("áli", 21);
    freq.put("Ty ", 16);
    freq.put("pro", 673);
    freq.put("ále", 67);
    freq.put("pri", 38);
    freq.put("álc", 3);
    freq.put("ála", 20);
    freq.put("pru", 6);
    freq.put("anu", 33);
    freq.put("prv", 79);
    freq.put("ý ", 733);
    freq.put("prs", 7);
    freq.put("ály", 3);
    freq.put("álu", 8);
    freq.put("pry", 5);
    freq.put("any", 20);
    freq.put("anz", 4);
    freq.put("šro", 3);
    freq.put("ML ", 4);
    freq.put(" L ", 5);
    freq.put("ejš", 34);
    freq.put("avš", 5);
    freq.put("ás ", 71);
    freq.put("ýt", 53);
    freq.put("ýv", 50);
    freq.put("an ", 55);
    freq.put("pr ", 3);
    freq.put("ýs", 23);
    freq.put("ýr", 23);
    freq.put("ál ", 35);
    freq.put("ýz", 15);
    freq.put("ýd", 36);
    freq.put("ýc", 172);
    freq.put("ýb", 25);
    freq.put("ým", 127);
    freq.put("ýl", 9);
    freq.put("ýn", 11);
    freq.put("ýh", 38);
    freq.put("ýk", 10);
    freq.put(" Le", 29);
    freq.put(" La", 19);
    freq.put("yuž", 11);
    freq.put(" Lo", 27);
    freq.put(" Li", 55);
    freq.put(" Lu", 17);
    freq.put(" Ly", 4);
    freq.put("pož", 12);
    freq.put("tke", 6);
    freq.put("ěrn", 6);
    freq.put("ěro", 3);
    freq.put("tka", 40);
    freq.put("tko", 21);
    freq.put("ořs", 6);
    freq.put("itl", 3);
    freq.put("lní", 157);
    freq.put("ořn", 3);
    freq.put("rmá", 25);
    freq.put("lné", 17);
    freq.put("Za ", 15);
    freq.put("oři", 20);
    freq.put("nli", 21);
    freq.put("oře", 19);
    freq.put("dy ", 268);
    freq.put("ss ", 13);
    freq.put("ořa", 13);
    freq.put("poš", 22);
    freq.put("poř", 66);
    freq.put("poň", 26);
    freq.put("alh", 4);
    freq.put("dyz", 16);
    freq.put("ssu", 4);
    freq.put("H", 247);
    freq.put("ěr ", 12);
    freq.put("dyn", 6);
    freq.put("Buď", 4);
    freq.put("sse", 7);
    freq.put("ssa", 5);
    freq.put("dyb", 48);
    freq.put("dyc", 12);
    freq.put("poč", 60);
    freq.put("Ať", 5);
    freq.put("lny", 6);
    freq.put("rmu", 13);
    freq.put("rmy", 12);
    freq.put("tké", 3);
    freq.put("lno", 33);
    freq.put("rma", 43);
    freq.put("lni", 38);
    freq.put("rme", 3);
    freq.put("lne", 9);
    freq.put("kav", 6);
    freq.put("lna", 5);
    freq.put("rmo", 8);
    freq.put("ořá", 44);
    freq.put(" Tř", 12);
    freq.put("íro", 10);
    freq.put("aňt", 3);
    freq.put("ale", 327);
    freq.put("rm ", 5);
    freq.put("oží", 11);
    freq.put("aň ", 8);
    freq.put("Ě ", 3);
    freq.put("íra", 17);
    freq.put("poz", 59);
    freq.put("íž ", 10);
    freq.put("pot", 75);
    freq.put("pou", 98);
    freq.put("por", 102);
    freq.put("pos", 135);
    freq.put("pop", 38);
    freq.put("pon", 41);
    freq.put("pol", 154);
    freq.put("pom", 89);
    freq.put("poj", 35);
    freq.put("pok", 81);
    freq.put("poh", 36);
    freq.put("poi", 3);
    freq.put("pod", 217);
    freq.put("pob", 22);
    freq.put("poc", 37);
    freq.put("ůch", 5);
    freq.put("Bul", 3);
    freq.put("Bud", 18);
    freq.put("íži", 7);
    freq.put("dyž", 129);
    freq.put("ížk", 4);
    freq.put("ň", 108);
    freq.put("ížd", 9);
    freq.put("íže", 13);
    freq.put("dyť", 4);
    freq.put("těc", 16);
    freq.put("po ", 96);
    freq.put("uhe", 8);
    freq.put("oku", 98);
    freq.put("I ", 54);
    freq.put("íží", 10);
    freq.put("kám", 52);
    freq.put("yho", 14);
    freq.put("lně", 82);
    freq.put("rmě", 4);
    freq.put("Is", 3);
    freq.put("Ir", 3);
    freq.put("It", 9);
    freq.put("Iv", 4);
    freq.put("In", 49);
    freq.put("yhr", 8);
    freq.put("oke", 31);
    freq.put("Id", 3);
    freq.put("zši", 3);
    freq.put("tip", 28);
    freq.put("oki", 13);
    freq.put("tir", 7);
    freq.put("tis", 45);
    freq.put("tim", 28);
    freq.put("vzá", 3);
    freq.put("tin", 62);
    freq.put("sbí", 6);
    freq.put("yc", 244);
    freq.put("Výv", 4);
    freq.put("tik", 38);
    freq.put("Výs", 3);
    freq.put("Výh", 4);
    freq.put("Výb", 4);
    freq.put("VV ", 3);
    freq.put("ýml", 4);
    freq.put("ými", 15);
    freq.put("ýma", 6);
    freq.put("tib", 4);
    freq.put("ýmu", 10);
    freq.put("Pir", 3);
    freq.put("Pis", 4);
    freq.put("Kur", 3);
    freq.put("Kup", 10);
    freq.put("Kul", 3);
    freq.put("Kuc", 3);
    freq.put("Kub", 5);
    freq.put("vzh", 14);
    freq.put("vzo", 3);
    freq.put("vzn", 14);
    freq.put("zím", 14);
    freq.put("zíc", 8);
    freq.put("vza", 5);
    freq.put("o ", 4192);
    freq.put("alu", 36);
    freq.put("ělý", 6);
    freq.put("zír", 3);
    freq.put("zís", 13);
    freq.put("vzp", 9);
    freq.put("Jar", 5);
    freq.put("vzt", 4);
    freq.put("řjá", 4);
    freq.put("Hom", 4);
    freq.put("oB", 4);
    freq.put("cně", 4);
    freq.put("uTu", 3);
    freq.put("oo", 156);
    freq.put("on", 682);
    freq.put("om", 612);
    freq.put("ol", 702);
    freq.put("ok", 446);
    freq.put("oj", 263);
    freq.put("oi", 43);
    freq.put("oh", 383);
    freq.put("og", 135);
    freq.put("of", 53);
    freq.put("oe", 13);
    freq.put("od", 1158);
    freq.put("oc", 331);
    freq.put("ob", 733);
    freq.put("oa", 27);
    freq.put("oz", 360);
    freq.put("oy", 6);
    freq.put("ox", 16);
    freq.put("ow", 61);
    freq.put("ov", 1534);
    freq.put("ou", 1509);
    freq.put("ot", 580);
    freq.put("os", 840);
    freq.put("or", 625);
    freq.put("op", 395);
    freq.put("LE ", 3);
    freq.put("unf", 3);
    freq.put("ju ", 71);
    freq.put("Hok", 3);
    freq.put("rvé", 10);
    freq.put("rví", 3);
    freq.put("FB ", 18);
    freq.put("Řad", 3);
    freq.put("eht", 5);
    freq.put("pás", 5);
    freq.put("ehr", 14);
    freq.put("ehe", 8);
    freq.put("pád", 18);
    freq.put("eha", 5);
    freq.put("ehn", 12);
    freq.put("eho", 60);
    freq.put("ehl", 25);
    freq.put("pál", 8);
    freq.put("ehk", 4);
    freq.put("pán", 15);
    freq.put("juj", 3);
    freq.put("vůj", 13);
    freq.put("ýmů", 3);
    freq.put("pá ", 4);
    freq.put("eh ", 3);
    freq.put("oď", 4);
    freq.put("rva", 27);
    freq.put("rve", 47);
    freq.put("rvi", 11);
    freq.put("rvo", 5);
    freq.put("rvn", 79);
    freq.put("vém", 13);
    freq.put("vés", 3);
    freq.put("řu ", 4);
    freq.put("rvy", 5);
    freq.put("igy", 4);
    freq.put("ige", 6);
    freq.put("iga", 10);
    freq.put("ehá", 3);
    freq.put("igo", 3);
    freq.put("ign", 21);
    freq.put("čic", 4);
    freq.put("igi", 24);
    freq.put("igh", 11);
    freq.put("vé ", 213);
    freq.put("oň", 28);
    freq.put("Jak", 94);
    freq.put("hwa", 6);
    freq.put("řuj", 9);
    freq.put("oř", 131);
    freq.put("tlu", 6);
    freq.put("oť", 12);
    freq.put("čov", 24);
    freq.put("oš", 88);
    freq.put("ož", 193);
    freq.put("Hos", 6);
    freq.put("bět", 6);
    freq.put("alo", 121);
    freq.put("all", 24);
    freq.put("árt", 7);
    freq.put("lým", 6);
    freq.put("pti", 6);
    freq.put("ali", 158);
    freq.put("áry", 4);
    freq.put("pte", 8);
    freq.put("lýc", 5);
    freq.put("alb", 16);
    freq.put("lly", 9);
    freq.put("pta", 19);
    freq.put("ala", 126);
    freq.put("běd", 7);
    freq.put("lýz", 4);
    freq.put("špi", 3);
    freq.put("áre", 11);
    freq.put("čip", 4);
    freq.put("běl", 3);
    freq.put("ári", 3);
    freq.put("fa ", 8);
    freq.put("špa", 22);
    freq.put("běh", 41);
    freq.put("als", 15);
    freq.put("běj", 5);
    freq.put("špe", 5);
    freq.put(" N ", 5);
    freq.put("čit", 43);
    freq.put("lý ", 61);
    freq.put("al ", 306);
    freq.put("pt ", 7);
    freq.put("faj", 7);
    freq.put("fak", 36);
    freq.put("bě ", 46);
    freq.put("llu", 4);
    freq.put("fal", 10);
    freq.put("fac", 10);
    freq.put(" Ni", 26);
    freq.put("and", 60);
    freq.put(" No", 128);
    freq.put(" Na", 128);
    freq.put(" Ne", 202);
    freq.put("lli", 6);
    freq.put("Vse", 3);
    freq.put("ířo", 3);
    freq.put("íře", 9);
    freq.put("teh", 5);
    freq.put("tei", 9);
    freq.put("tej", 78);
    freq.put("tek", 62);
    freq.put("tel", 213);
    freq.put("Čtv", 3);
    freq.put("ten", 121);
    freq.put("teo", 4);
    freq.put("tea", 6);
    freq.put("teb", 33);
    freq.put("tec", 75);
    freq.put("ted", 59);
    freq.put("ěta", 9);
    freq.put("ptá", 17);
    freq.put("teg", 5);
    freq.put("tex", 17);
    freq.put("alý", 18);
    freq.put("tep", 19);
    freq.put("ětu", 9);
    freq.put("nba", 3);
    freq.put("tes", 36);
    freq.put("tet", 7);
    freq.put("lla", 7);
    freq.put("nbe", 6);
    freq.put("ěts", 11);
    freq.put("sud", 7);
    freq.put("sun", 20);
    freq.put("sum", 3);
    freq.put("suj", 4);
    freq.put("sus", 4);
    freq.put("sur", 6);
    freq.put("sup", 23);
    freq.put("te ", 466);
    freq.put("ět ", 96);
    freq.put("Čt ", 3);
    freq.put("su ", 65);
    freq.put(" Ná", 37);
    freq.put("ďte", 25);
    freq.put("íří", 5);
    freq.put("rku", 24);
    freq.put("rkv", 3);
    freq.put("běž", 22);
    freq.put("rky", 12);
    freq.put("alš", 74);
    freq.put("rke", 18);
    freq.put(" Ně", 28);
    freq.put("rka", 16);
    freq.put("Tom", 8);
    freq.put("rkn", 6);
    freq.put("rko", 20);
    freq.put("In ", 30);
    freq.put("žto", 3);
    freq.put("žta", 6);
    freq.put("žte", 3);
    freq.put("rk ", 15);
    freq.put("To ", 93);
    freq.put("faš", 5);
    freq.put("á", 4666);
    freq.put("yvo", 6);
    freq.put("Int", 9);
    freq.put("v", 7266);
    freq.put("Inf", 4);
    freq.put("upl", 21);
    freq.put("rký", 3);
    freq.put("ětš", 37);
    freq.put("rká", 6);
    freq.put("Už ", 28);
    freq.put("ro ", 276);
    freq.put("hči", 3);
    freq.put("číh", 4);
    freq.put("Akt", 22);
    freq.put("Ako", 3);
    freq.put("Akc", 3);
    freq.put("ď ", 70);
    freq.put("teč", 50);
    freq.put("lha", 4);
    freq.put("teď", 37);
    freq.put("lho", 4);
    freq.put("Ep", 3);
    freq.put("ětě", 11);
    freq.put("Och", 6);
    freq.put("Cit", 6);
    freq.put(" sé", 6);
    freq.put(" sí", 13);
    freq.put(" sá", 22);
    freq.put("izá", 6);
    freq.put("yn ", 7);
    freq.put("izí", 8);
    freq.put("L", 204);
    freq.put("Era", 3);
    freq.put("Rad", 12);
    freq.put("yno", 6);
    freq.put("Rac", 11);
    freq.put("yne", 7);
    freq.put("Ral", 3);
    freq.put("Rak", 4);
    freq.put("Rai", 3);
    freq.put("Rat", 3);
    freq.put("man", 46);
    freq.put("ór", 8);
    freq.put("ynu", 8);
    freq.put("ožá", 3);
    freq.put("Ray", 3);
    freq.put(" sy", 20);
    freq.put("Mus", 13);
    freq.put(" sr", 31);
    freq.put(" sp", 216);
    freq.put(" sv", 150);
    freq.put(" st", 488);
    freq.put(" su", 30);
    freq.put(" sj", 3);
    freq.put(" sk", 114);
    freq.put(" sh", 25);
    freq.put(" si", 387);
    freq.put(" sn", 83);
    freq.put(" so", 145);
    freq.put(" sl", 163);
    freq.put(" sm", 90);
    freq.put(" sb", 13);
    freq.put(" sc", 38);
    freq.put(" sa", 57);
    freq.put(" sd", 10);
    freq.put(" se", 1133);
    freq.put("iza", 14);
    freq.put("ize", 20);
    freq.put("izi", 19);
    freq.put("izn", 8);
    freq.put("izo", 31);
    freq.put("izp", 9);
    freq.put("izu", 10);
    freq.put("ate", 117);
    freq.put("izz", 3);
    freq.put("koh", 25);
    freq.put("SZ ", 3);
    freq.put(" en", 12);
    freq.put(" s ", 333);
    freq.put("iz ", 5);
    freq.put("yní", 15);
    freq.put("ožs", 3);
    freq.put("kon", 219);
    freq.put("yná", 5);
    freq.put("ožk", 3);
    freq.put("oži", 22);
    freq.put("ožn", 55);
    freq.put("ýko", 5);
    freq.put("oža", 3);
    freq.put("X ", 16);
    freq.put("ožd", 4);
    freq.put("ože", 59);
    freq.put("kod", 25);
    freq.put("yně", 7);
    freq.put("še ", 65);
    freq.put("ata", 36);
    freq.put("kop", 22);
    freq.put("kos", 25);
    freq.put("ašk", 3);
    freq.put("zyn", 4);
    freq.put("kov", 198);
    freq.put("LG ", 7);
    freq.put("Ze ", 4);
    freq.put("efu", 10);
    freq.put("efi", 17);
    freq.put("efl", 4);
    freq.put("efo", 39);
    freq.put("efa", 6);
    freq.put("efe", 8);
    freq.put("jse", 403);
    freq.put("jsm", 48);
    freq.put("jso", 118);
    freq.put("jsi", 43);
    freq.put("jsk", 10);
    freq.put("jst", 31);
    freq.put("ožň", 5);
    freq.put("Zem", 16);
    freq.put("ef ", 6);
    freq.put("aln", 8);
    freq.put("rte", 29);
    freq.put("rtf", 4);
    freq.put("rta", 16);
    freq.put("rtl", 6);
    freq.put("rto", 18);
    freq.put("rtn", 12);
    freq.put("rti", 26);
    freq.put("rth", 3);
    freq.put("rtk", 4);
    freq.put("rtu", 26);
    freq.put("ará", 33);
    freq.put("rtv", 13);
    freq.put("rtp", 4);
    freq.put("aré", 6);
    freq.put("rty", 19);
    freq.put("mí ", 21);
    freq.put("Ju", 15);
    freq.put("ies", 7);
    freq.put("ier", 8);
    freq.put("iet", 7);
    freq.put("iew", 3);
    freq.put("Js", 42);
    freq.put("Jo", 56);
    freq.put("iem", 4);
    freq.put("iel", 7);
    freq.put("ien", 14);
    freq.put("Jd", 13);
    freq.put("Je", 139);
    freq.put("ieb", 3);
    freq.put("Ja", 141);
    freq.put("hip", 5);
    freq.put("his", 10);
    freq.put("hit", 7);
    freq.put("rt ", 36);
    freq.put("pě", 119);
    freq.put("mís", 37);
    freq.put("mír", 11);
    freq.put("mím", 10);
    freq.put("hia", 3);
    freq.put("hic", 3);
    freq.put("hil", 6);
    freq.put("hin", 3);
    freq.put("pč", 3);
    freq.put(" Pá", 8);
    freq.put("ie ", 86);
    freq.put("J ", 9);
    freq.put("arr", 6);
    freq.put("ars", 21);
    freq.put("rtá", 7);
    freq.put("aru", 13);
    freq.put("arv", 3);
    freq.put("ary", 13);
    freq.put("arz", 6);
    freq.put("ápu", 17);
    freq.put("ara", 37);
    freq.put("arb", 9);
    freq.put("ápi", 4);
    freq.put("ard", 51);
    freq.put("ápo", 7);
    freq.put("arg", 5);
    freq.put("ari", 32);
    freq.put("ápa", 25);
    freq.put("arl", 11);
    freq.put("uu ", 3);
    freq.put("arn", 9);
    freq.put("aro", 40);
    freq.put("šec", 66);
    freq.put(" P ", 16);
    freq.put("Já", 74);
    freq.put("Ý ", 3);
    freq.put("áší", 14);
    freq.put("ar ", 26);
    freq.put("šek", 16);
    freq.put("tři", 34);
    freq.put(" Ps", 3);
    freq.put(" Pr", 280);
    freq.put("c", 5095);
    freq.put(" Pu", 4);
    freq.put(" Pt", 5);
    freq.put("mřu", 3);
    freq.put("ágr", 3);
    freq.put(" Pa", 71);
    freq.put("rič", 7);
    freq.put(" Pe", 38);
    freq.put(" Pi", 19);
    freq.put(" Ph", 15);
    freq.put(" Po", 198);
    freq.put(" Pl", 27);
    freq.put("rió", 3);
    freq.put("pB", 3);
    freq.put("ěve", 5);
    freq.put("ěvk", 4);
    freq.put("riá", 15);
    freq.put("pr", 1310);
    freq.put("ps", 100);
    freq.put("duj", 24);
    freq.put("duk", 9);
    freq.put("dul", 4);
    freq.put("pt", 66);
    freq.put("pu", 167);
    freq.put("dub", 10);
    freq.put("py", 43);
    freq.put("pc", 19);
    freq.put("pa", 539);
    freq.put("pg", 3);
    freq.put("pd", 10);
    freq.put("pe", 272);
    freq.put("dup", 5);
    freq.put("pk", 15);
    freq.put("dur", 3);
    freq.put("pi", 245);
    freq.put("pn", 78);
    freq.put("po", 1571);
    freq.put("pl", 377);
    freq.put("udy", 5);
    freq.put("ekl", 69);
    freq.put("ěv ", 5);
    freq.put("Fac", 32);
    freq.put("míš", 3);
    freq.put("ývá", 13);
    freq.put("míř", 4);
    freq.put("du ", 262);
    freq.put("p ", 128);
    freq.put("riz", 13);
    freq.put("riv", 8);
    freq.put("rit", 29);
    freq.put("Tip", 3);
    freq.put("ris", 29);
    freq.put("rip", 13);
    freq.put("Tis", 6);
    freq.put("rin", 15);
    freq.put("rio", 6);
    freq.put("ril", 13);
    freq.put("rim", 24);
    freq.put("rij", 10);
    freq.put("rik", 13);
    freq.put("rii", 7);
    freq.put("rig", 16);
    freq.put("rid", 11);
    freq.put("rie", 20);
    freq.put("rib", 4);
    freq.put("ric", 38);
    freq.put("ria", 11);
    freq.put("pá", 128);
    freq.put("pé", 10);
    freq.put("pí", 102);
    freq.put("Cop", 3);
    freq.put("Cor", 4);
    freq.put(" Př", 115);
    freq.put("Com", 4);
    freq.put("eku", 14);
    freq.put("ri ", 16);
    freq.put("ýva", 20);
    freq.put("ůžu", 22);
    freq.put("ůži", 3);
    freq.put(" Pů", 5);
    freq.put("ůže", 66);
    freq.put(" už", 218);
    freq.put("važ", 11);
    freq.put("éé ", 4);
    freq.put(" uš", 7);
    freq.put("tiž", 10);
    freq.put("WM ", 3);
    freq.put("Air", 3);
    freq.put("lje", 3);
    freq.put(" uč", 11);
    freq.put("uzy", 6);
    freq.put("uzu", 6);
    freq.put("ězí", 4);
    freq.put("kž ", 4);
    freq.put("yl ", 73);
    freq.put("átr", 5);
    freq.put("áts", 3);
    freq.put("gál", 5);
    freq.put("Epi", 3);
    freq.put("kže", 41);
    freq.put("ééé", 3);
    freq.put("Rom", 15);
    freq.put("alk", 14);
    freq.put("Roc", 6);
    freq.put("yly", 15);
    freq.put("Vla", 6);
    freq.put("Roz", 13);
    freq.put("yle", 10);
    freq.put("yla", 54);
    freq.put("ylo", 69);
    freq.put("yli", 10);
    freq.put("wn ", 3);
    freq.put(" uz", 34);
    freq.put(" ut", 14);
    freq.put(" uv", 36);
    freq.put(" up", 47);
    freq.put(" ur", 23);
    freq.put(" us", 13);
    freq.put(" ul", 13);
    freq.put(" um", 38);
    freq.put(" un", 21);
    freq.put(" uh", 6);
    freq.put(" uj", 8);
    freq.put(" uk", 31);
    freq.put(" ud", 46);
    freq.put(" ub", 6);
    freq.put(" uc", 16);
    freq.put("jďt", 12);
    freq.put("xpe", 6);
    freq.put("těv", 4);
    freq.put("tět", 9);
    freq.put("smá", 4);
    freq.put(" u ", 98);
    freq.put("ix ", 9);
    freq.put("dří", 20);
    freq.put("z", 4162);
    freq.put("ámé", 3);
    freq.put("řům", 3);
    freq.put("těz", 16);
    freq.put("ď", 113);
    freq.put("tph", 4);
    freq.put("gru", 5);
    freq.put("gre", 6);
    freq.put("gra", 42);
    freq.put("zén", 4);
    freq.put("gro", 3);
    freq.put("gri", 4);
    freq.put("řní", 6);
    freq.put("řů ", 6);
    freq.put("těl", 36);
    freq.put("těj", 20);
    freq.put("gr ", 4);
    freq.put("dře", 5);
    freq.put("iča", 4);
    freq.put("edc", 7);
    freq.put("ičc", 3);
    freq.put("eda", 61);
    freq.put("iče", 25);
    freq.put("edd", 4);
    freq.put("ede", 114);
    freq.put("iči", 8);
    freq.put("edk", 14);
    freq.put("ičk", 51);
    freq.put("edi", 61);
    freq.put("edn", 252);
    freq.put("edo", 62);
    freq.put("edl", 40);
    freq.put("edm", 10);
    freq.put("edr", 13);
    freq.put("eds", 38);
    freq.put("edp", 10);
    freq.put("edv", 8);
    freq.put("ičt", 3);
    freq.put("edt", 5);
    freq.put("edu", 60);
    freq.put("Hal", 4);
    freq.put("edy", 22);
    freq.put("ávš", 4);
    freq.put("usť", 4);
    freq.put("apř", 8);
    freq.put("Han", 5);
    freq.put("rče", 3);
    freq.put("rči", 21);
    freq.put("ič ", 5);
    freq.put("ed ", 120);
    freq.put("čká", 5);
    freq.put("P", 952);
    freq.put("yje", 3);
    freq.put("ďme", 4);
    freq.put("ávě", 40);
    freq.put("ahy", 13);
    freq.put("car", 8);
    freq.put("ičá", 5);
    freq.put("víl", 11);
    freq.put("edá", 40);
    freq.put("vík", 16);
    freq.put("rri", 4);
    freq.put("víd", 10);
    freq.put("ičí", 8);
    freq.put("víc", 73);
    freq.put("rra", 6);
    freq.put("edí", 15);
    freq.put("víz", 3);
    freq.put("rry", 10);
    freq.put("vít", 35);
    freq.put("ěď", 4);
    freq.put("ště", 136);
    freq.put("ěč", 4);
    freq.put("bdo", 3);
    freq.put("taň", 4);
    freq.put("čke", 8);
    freq.put("čka", 47);
    freq.put("čko", 30);
    freq.put("ěř", 57);
    freq.put(" €", 3);
    freq.put("Up", 6);
    freq.put("čku", 35);

    init3();
  }
  private static void init3() {
    
    freq.put("hko", 4);
    freq.put("čky", 40);
    freq.put("žno", 18);
    freq.put(" Uč", 3);
    freq.put("ěž", 75);
    freq.put("Řek", 5);
    freq.put("ěš", 47);
    freq.put("ěť", 4);
    freq.put("tač", 46);
    freq.put("jl ", 4);
    freq.put("apy", 5);
    freq.put("ávy", 8);
    freq.put("apr", 15);
    freq.put("ávu", 9);
    freq.put("app", 21);
    freq.put("edů", 4);
    freq.put("ávr", 14);
    freq.put("apu", 6);
    freq.put("ávn", 23);
    freq.put("ávo", 15);
    freq.put("apn", 10);
    freq.put("ávi", 22);
    freq.put("apl", 44);
    freq.put("ávk", 15);
    freq.put("áve", 12);
    freq.put("apa", 38);
    freq.put("áva", 64);
    freq.put("kyn", 5);
    freq.put("use", 73);
    freq.put("kym", 6);
    freq.put("usa", 6);
    freq.put("Hul", 6);
    freq.put("usn", 20);
    freq.put("usm", 3);
    freq.put("usl", 9);
    freq.put("usk", 26);
    freq.put("fek", 10);
    freq.put("usi", 47);
    freq.put("ush", 6);
    freq.put("kyc", 4);
    freq.put("usu", 7);
    freq.put("vuk", 5);
    freq.put("fer", 9);
    freq.put("fes", 12);
    freq.put("Hur", 3);
    freq.put("usp", 4);
    freq.put("Mic", 16);
    freq.put("usy", 3);
    freq.put("Gui", 3);
    freq.put("Gur", 6);
    freq.put(" č", 420);
    freq.put("ap ", 10);
    freq.put("áv ", 7);
    freq.put(" Ru", 32);
    freq.put("ězd", 9);
    freq.put("fe ", 13);
    freq.put("us ", 88);
    freq.put("ští", 42);
    freq.put(" Ry", 6);
    freq.put("pac", 16);
    freq.put(" Re", 64);
    freq.put(" Ra", 44);
    freq.put("edě", 23);
    freq.put(" Ro", 52);
    freq.put(" Ri", 7);
    freq.put("tat", 76);
    freq.put("tau", 3);
    freq.put("tav", 98);
    freq.put("éče", 3);
    freq.put("tar", 70);
    freq.put("tas", 6);
    freq.put("éči", 3);
    freq.put("taz", 10);
    freq.put("víš", 15);
    freq.put("tad", 49);
    freq.put("tag", 11);
    freq.put("taa", 4);
    freq.put("tab", 20);
    freq.put("tac", 25);
    freq.put("tal", 95);
    freq.put("tam", 91);
    freq.put("tan", 76);
    freq.put("apá", 6);
    freq.put("tah", 25);
    freq.put("tai", 7);
    freq.put("taj", 13);
    freq.put("tak", 557);
    freq.put("sis", 17);
    freq.put("kyp", 3);
    freq.put("siv", 9);
    freq.put("sit", 38);
    freq.put("usí", 59);
    freq.put("sic", 40);
    freq.put("ě ", 1216);
    freq.put("sig", 18);
    freq.put("sid", 3);
    freq.put("sio", 4);
    freq.put("sin", 10);
    freq.put("sim", 31);
    freq.put("sil", 49);
    freq.put("čků", 4);
    freq.put("ta ", 168);
    freq.put("ěs", 97);
    freq.put("ěr", 48);
    freq.put("ěp", 5);
    freq.put("ěv", 18);
    freq.put("ět", 275);
    freq.put("štn", 9);
    freq.put("ěz", 33);
    freq.put("šti", 17);
    freq.put("ěc", 136);
    freq.put("si ", 503);
    freq.put(" Rá", 6);
    freq.put("ěd", 93);
    freq.put("ěk", 237);
    freq.put("ěj", 248);
    freq.put("ěh", 49);
    freq.put("ěn", 135);
    freq.put("ěm", 44);
    freq.put("ěl", 399);
    freq.put("ybě", 7);
    freq.put("kve", 13);
    freq.put("byv", 5);
    freq.put("byt", 41);
    freq.put("byr", 3);
    freq.put("bys", 28);
    freq.put("Kč", 64);
    freq.put("byl", 196);
    freq.put("byd", 7);
    freq.put("bye", 5);
    freq.put("byc", 150);
    freq.put("Cas", 4);
    freq.put("Car", 6);
    freq.put("Cal", 3);
    freq.put("Pre", 9);
    freq.put("nfe", 5);
    freq.put("Pra", 76);
    freq.put("nfa", 4);
    freq.put("nfo", 33);
    freq.put("Pro", 136);
    freq.put("Pri", 14);
    freq.put("nfi", 3);
    freq.put("Prv", 20);
    freq.put("ýtv", 3);
    freq.put("by ", 288);
    freq.put("ýtu", 3);
    freq.put("ouk", 51);
    freq.put("ouh", 69);
    freq.put("oun", 12);
    freq.put("oum", 7);
    freq.put("oul", 11);
    freq.put("ouc", 49);
    freq.put("oub", 29);
    freq.put("ouf", 26);
    freq.put("oud", 33);
    freq.put("ouz", 47);
    freq.put("Poč", 3);
    freq.put("eň ", 20);
    freq.put("ous", 44);
    freq.put("our", 27);
    freq.put("oup", 75);
    freq.put("ouv", 18);
    freq.put("out", 110);
    freq.put("vce", 20);
    freq.put("vci", 3);
    freq.put("hý ", 18);
    freq.put("lt ", 6);
    freq.put("ják", 5);
    freq.put("jád", 9);
    freq.put("jác", 3);
    freq.put("ouT", 3);
    freq.put("vaj", 42);
    freq.put("eňt", 3);
    freq.put("Poř", 8);
    freq.put("vín", 6);
    freq.put("ou ", 752);
    freq.put("ltr", 4);
    freq.put("Prá", 17);
    freq.put("val", 169);
    freq.put("g", 688);
    freq.put("hýb", 3);
    freq.put("hýc", 4);
    freq.put("lta", 4);
    freq.put("lte", 7);
    freq.put("lti", 8);
    freq.put("šéf", 9);
    freq.put("ü", 3);
    freq.put("já ", 118);
    freq.put("Poš", 3);
    freq.put("Fot", 9);
    freq.put("K ", 39);
    freq.put("šsk", 3);
    freq.put("ses", 14);
    freq.put("čc", 7);
    freq.put("jčí", 4);
    freq.put("Ka", 56);
    freq.put("Ke", 11);
    freq.put("Kd", 72);
    freq.put("Ki", 10);
    freq.put("Ko", 77);
    freq.put("Kn", 3);
    freq.put("Kl", 17);
    freq.put("Kr", 47);
    freq.put("Kv", 8);
    freq.put("Ku", 29);
    freq.put("Kt", 5);
    freq.put("uta", 15);
    freq.put("vie", 7);
    freq.put("yby", 50);
    freq.put("čt", 90);
    freq.put("Prů", 5);
    freq.put("ybu", 3);
    freq.put("ybi", 5);
    freq.put("ybl", 3);
    freq.put("ybn", 4);
    freq.put("ybo", 8);
    freq.put("yba", 7);
    freq.put("ybe", 5);
    freq.put("kně", 15);
    freq.put("dá ", 97);
    freq.put("jář", 5);
    freq.put("ouš", 44);
    freq.put("ouž", 53);
    freq.put("ojí", 37);
    freq.put("ouř", 14);
    freq.put("jča", 3);
    freq.put("Po ", 20);
    freq.put("jče", 3);
    freq.put("dáf", 7);
    freq.put("dál", 31);
    freq.put("dám", 48);
    freq.put("dán", 26);
    freq.put("whi", 3);
    freq.put("dák", 5);
    freq.put("dát", 18);
    freq.put("dáv", 55);
    freq.put("ht", 99);
    freq.put("dár", 10);
    freq.put("zón", 16);
    freq.put("Poz", 5);
    freq.put("ouč", 21);
    freq.put("Pov", 9);
    freq.put("Pot", 8);
    freq.put("Pou", 4);
    freq.put("Por", 13);
    freq.put("Pos", 24);
    freq.put("Pop", 8);
    freq.put("Pol", 21);
    freq.put("Pom", 9);
    freq.put("Pok", 18);
    freq.put("Poh", 4);
    freq.put("Pod", 38);
    freq.put("Poc", 3);
    freq.put("ebá", 3);
    freq.put("Cha", 11);
    freq.put("ebí", 5);
    freq.put("dlá", 5);
    freq.put("ha", 284);
    freq.put("čič", 4);
    freq.put("dlí", 6);
    freq.put("eat", 9);
    freq.put("he", 175);
    freq.put("no ", 248);
    freq.put("Jas", 11);
    freq.put("pný", 5);
    freq.put("zaž", 8);
    freq.put(" we", 46);
    freq.put("qu", 4);
    freq.put(" wa", 7);
    freq.put(" wo", 4);
    freq.put("půl", 19);
    freq.put(" wh", 3);
    freq.put(" wi", 12);
    freq.put(" ww", 11);
    freq.put(" wt", 3);
    freq.put("půj", 22);
    freq.put("Ra", 47);
    freq.put("ebe", 46);
    freq.put(" Tě", 11);
    freq.put("eba", 45);
    freq.put("ebl", 3);
    freq.put("ebn", 18);
    freq.put("ebo", 194);
    freq.put("ebi", 11);
    freq.put("jo ", 55);
    freq.put("ebu", 79);
    freq.put("ebr", 4);
    freq.put("eby", 26);
    freq.put("dla", 40);
    freq.put("avř", 10);
    freq.put("dle", 89);
    freq.put("dli", 20);
    freq.put("dlo", 73);
    freq.put("dln", 8);
    freq.put("Bíl", 6);
    freq.put("dlu", 17);
    freq.put("dly", 6);
    freq.put("eb ", 42);
    freq.put("jou", 11);
    freq.put("jov", 21);
    freq.put("job", 6);
    freq.put("joj", 3);
    freq.put("joo", 3);
    freq.put("dl ", 29);
    freq.put("Zaj", 9);
    freq.put("Zak", 3);
    freq.put("Zah", 3);
    freq.put("avě", 23);
    freq.put("Zad", 5);
    freq.put("Zab", 3);
    freq.put("Zav", 4);
    freq.put("Zat", 7);
    freq.put("Zap", 9);
    freq.put("avý", 15);
    freq.put("CD ", 6);
    freq.put("či ", 36);
    freq.put("aví", 53);
    freq.put("rpe", 3);
    freq.put("avé", 20);
    freq.put("hm ", 9);
    freq.put("avá", 23);
    freq.put("rpn", 11);
    freq.put("méh", 6);
    freq.put("mém", 10);
    freq.put("mén", 30);
    freq.put("méd", 6);
    freq.put("Jul", 4);
    freq.put("Jus", 7);
    freq.put("IE ", 10);
    freq.put("čij", 3);
    freq.put("čim", 6);
    freq.put("čil", 43);
    freq.put("čin", 23);
    freq.put("tap", 4);
    freq.put("hme", 3);
    freq.put("čis", 13);
    freq.put("hma", 3);
    freq.put(" Tý", 3);
    freq.put("é", 1484);
    freq.put("mé ", 16);
    freq.put(" Tí", 4);
    freq.put(" Tá", 3);
    freq.put("Zač", 5);
    freq.put("avy", 89);
    freq.put("avz", 3);
    freq.put("avt", 3);
    freq.put("avu", 37);
    freq.put("avr", 10);
    freq.put("avs", 8);
    freq.put("avl", 5);
    freq.put("avn", 56);
    freq.put("avo", 48);
    freq.put("avi", 89);
    freq.put("avk", 8);
    freq.put("avd", 49);
    freq.put("ave", 60);
    freq.put("ava", 58);
    freq.put("avb", 12);
    freq.put("avc", 5);
    freq.put(" ér", 3);
    freq.put(" T ", 8);
    freq.put("žně", 26);
    freq.put("av ", 30);
    freq.put(" Uz", 6);
    freq.put(" Ty", 21);
    freq.put(" Tw", 31);
    freq.put(" Tv", 4);
    freq.put(" Tu", 19);
    freq.put("ble", 41);
    freq.put(" Tr", 24);
    freq.put(" To", 125);
    freq.put(" Ti", 30);
    freq.put(" Th", 14);
    freq.put(" Te", 75);
    freq.put(" Uv", 7);
    freq.put(" Ta", 176);
    freq.put("ídk", 22);
    freq.put("ídi", 10);
    freq.put("ídn", 6);
    freq.put("ídl", 11);
    freq.put("Teď", 17);
    freq.put("ídc", 3);
    freq.put("ída", 16);
    freq.put("íde", 11);
    freq.put("tco", 3);
    freq.put("vař", 11);
    freq.put("tch", 15);
    freq.put("tce", 7);
    freq.put("sku", 90);
    freq.put("skt", 3);
    freq.put("skv", 25);
    freq.put("át ", 112);
    freq.put("skr", 7);
    freq.put("Far", 3);
    freq.put("vaš", 11);
    freq.put("sky", 37);
    freq.put("ske", 15);
    freq.put("Fak", 6);
    freq.put("ska", 96);
    freq.put("nor", 18);
    freq.put("skl", 14);
    freq.put("sko", 115);
    freq.put("skn", 3);
    freq.put("ski", 3);
    freq.put("dvo", 28);
    freq.put("žný", 9);
    freq.put("vač", 15);
    freq.put("žní", 12);
    freq.put("T", 649);
    freq.put("žné", 12);
    freq.put("žná", 28);
    freq.put("áte", 94);
    freq.put("áta", 6);
    freq.put("ndá", 7);
    freq.put("áto", 31);
    freq.put("átk", 32);
    freq.put("Ptá", 3);
    freq.put("áti", 21);
    freq.put("átu", 5);
    freq.put("ndý", 8);
    freq.put("sk ", 15);
    freq.put("áty", 9);
    freq.put("kdo", 95);
    freq.put("ídí", 4);
    freq.put("íč", 49);
    freq.put("kde", 43);
    freq.put("ídá", 8);
    freq.put("iDn", 14);
    freq.put("kdy", 236);
    freq.put("Sup", 7);
    freq.put("myš", 16);
    freq.put("ěz ", 10);
    freq.put("ský", 103);
    freq.put("nd ", 22);
    freq.put("ýr ", 3);
    freq.put("ská", 55);
    freq.put("ské", 131);
    freq.put("íň", 4);
    freq.put("zvě", 12);
    freq.put("íř", 23);
    freq.put("ndi", 15);
    freq.put("ýro", 13);
    freq.put("íš", 122);
    freq.put("ndl", 14);
    freq.put("ndo", 22);
    freq.put("ěze", 6);
    freq.put("nda", 20);
    freq.put("átí", 5);
    freq.put("nde", 26);
    freq.put("ýra", 7);
    freq.put("ndy", 16);
    freq.put("ND ", 3);
    freq.put("nds", 6);
    freq.put("íž", 58);
    freq.put("ndu", 15);
    freq.put("own", 7);
    freq.put("owe", 11);
    freq.put("owd", 3);
    freq.put("owa", 3);
    freq.put("tců", 6);
    freq.put("ows", 10);
    freq.put("Ami", 3);
    freq.put("vak", 6);
    freq.put("van", 75);
    freq.put("zví", 9);
    freq.put("vam", 6);
    freq.put("Ama", 3);
    freq.put("vac", 17);
    freq.put("zvá", 6);
    freq.put("Ame", 11);
    freq.put("vad", 28);
    freq.put("vaz", 12);
    freq.put("zvý", 10);
    freq.put("var", 21);
    freq.put("vas", 6);
    freq.put("vap", 13);
    freq.put("vat", 222);
    freq.put("anů", 5);
    freq.put("uct", 8);
    freq.put("ow ", 18);
    freq.put("bch", 27);
    freq.put("Tel", 6);
    freq.put("Ten", 18);
    freq.put("íí", 11);
    freq.put("átů", 3);
    freq.put("va ", 148);
    freq.put("Tec", 5);
    freq.put("Ted", 3);
    freq.put("lve", 4);
    freq.put("ídě", 4);
    freq.put("lva", 6);
    freq.put("bce", 6);
    freq.put("Tep", 5);
    freq.put("Ter", 5);
    freq.put("Tes", 7);
    freq.put("ex", 102);
    freq.put("mys", 81);
    freq.put("lm ", 19);
    freq.put("ndě", 15);
    freq.put("myl", 4);
    freq.put("zvo", 9);
    freq.put("í ", 2666);
    freq.put("zvl", 23);
    freq.put("zva", 16);
    freq.put("zve", 28);
    freq.put("zvy", 15);
    freq.put("es", 962);
    freq.put("н", 3);
    freq.put("zvu", 10);
    freq.put("EN ", 5);
    freq.put("šťa", 3);
    freq.put("my ", 56);
    freq.put("íd", 99);
    freq.put("íc", 382);
    freq.put("íb", 49);
    freq.put("ím", 625);
    freq.put("íl", 126);
    freq.put("ín", 126);
    freq.put("íh", 103);
    freq.put("ík", 240);
    freq.put("íj", 46);
    freq.put("ít", 318);
    freq.put("ív", 100);
    freq.put("íp", 39);
    freq.put("ís", 127);
    freq.put("ír", 71);
    freq.put("íz", 72);
  }
  
}

