package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class DA {
  private static final String name = "da";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public DA() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 206555;
    n_words[1] = 253148;
    n_words[2] = 200626;

    freq.put("ørm", 4);
    freq.put("ørn", 37);
    freq.put("øri", 4);
    freq.put("ørk", 5);
    freq.put("øre", 178);
    freq.put("ørd", 31);
    freq.put("ørg", 27);
    freq.put("ørb", 3);
    freq.put("ørt", 31);
    freq.put("ørs", 114);
    freq.put("ørr", 16);
    freq.put("ør ", 146);
    freq.put("ér ", 9);
    freq.put("iTu", 5);
    freq.put("Af ", 3);
    freq.put(" yn", 4);
    freq.put(" yo", 9);
    freq.put(" ya", 3);
    freq.put("k", 6981);
    freq.put(" yd", 5);
    freq.put(" ye", 6);
    freq.put("Læ", 26);
    freq.put("ED ", 7);
    freq.put("Lå", 3);
    freq.put("Lø", 31);
    freq.put("dne", 6);
    freq.put("dna", 7);
    freq.put("dni", 29);
    freq.put("dnu", 29);
    freq.put("hu", 199);
    freq.put("Le", 30);
    freq.put("La", 57);
    freq.put("Lo", 39);
    freq.put("Li", 67);
    freq.put("Lu", 20);
    freq.put("Ly", 18);
    freq.put("hod", 3);
    freq.put("hon", 26);
    freq.put("hoo", 5);
    freq.put("hol", 118);
    freq.put("hom", 10);
    freq.put("hok", 4);
    freq.put("hov", 47);
    freq.put("how", 4);
    freq.put("hot", 11);
    freq.put("hou", 7);
    freq.put("hor", 24);
    freq.put("hos", 41);
    freq.put("hop", 21);
    freq.put("A", 360);
    freq.put("L ", 44);
    freq.put(" V ", 9);
    freq.put("fir", 9);
    freq.put("fis", 12);
    freq.put("ækk", 54);
    freq.put("Hit", 3);
    freq.put("Lør", 3);
    freq.put("fit", 5);
    freq.put("smø", 5);
    freq.put("fix", 3);
    freq.put("rø", 161);
    freq.put("æke", 6);
    freq.put("fic", 20);
    freq.put("ræ", 195);
    freq.put("fig", 3);
    freq.put("Hig", 3);
    freq.put("dsæ", 5);
    freq.put("fik", 50);
    freq.put("ækr", 4);
    freq.put("æks", 11);
    freq.put("Hil", 6);
    freq.put("fil", 61);
    freq.put(" Va", 29);
    freq.put(" Ve", 73);
    freq.put("au ", 5);
    freq.put(" Vi", 149);
    freq.put("upl", 5);
    freq.put(" Vo", 12);
    freq.put("iør", 4);
    freq.put(" Vu", 3);
    freq.put("æk ", 25);
    freq.put("jø ", 5);
    freq.put("fi ", 13);
    freq.put("atø", 3);
    freq.put("rt", 557);
    freq.put("ru", 273);
    freq.put("rv", 111);
    freq.put("rw", 7);
    freq.put("rp", 32);
    freq.put("rr", 175);
    freq.put("dsy", 4);
    freq.put("dsv", 6);
    freq.put("dst", 140);
    freq.put("dsu", 3);
    freq.put("dsr", 4);
    freq.put("ry", 113);
    freq.put("dsp", 24);
    freq.put("rd", 447);
    freq.put("re", 2690);
    freq.put("rf", 149);
    freq.put("rg", 266);
    freq.put("dsj", 7);
    freq.put("dsk", 47);
    freq.put("rb", 163);
    freq.put("rc", 20);
    freq.put("rl", 162);
    freq.put("rm", 178);
    freq.put("rn", 401);
    freq.put("ro", 455);
    freq.put("rh", 108);
    freq.put("ri", 912);
    freq.put("rj", 8);
    freq.put("rk", 358);
    freq.put(" Væ", 5);
    freq.put("atf", 5);
    freq.put("sys", 7);
    freq.put("ate", 83);
    freq.put("atc", 4);
    freq.put("ata", 21);
    freq.put("atn", 6);
    freq.put("ato", 19);
    freq.put("ath", 7);
    freq.put("ati", 144);
    freq.put("att", 63);
    freq.put("atu", 25);
    freq.put("r ", 7977);
    freq.put("ats", 17);
    freq.put("ds ", 88);
    freq.put("Dum", 3);
    freq.put("Dub", 3);
    freq.put("Cen", 5);
    freq.put("Du ", 66);
    freq.put("nze", 3);
    freq.put("lp ", 16);
    freq.put("knu", 3);
    freq.put("lpe", 27);
    freq.put("lpa", 3);
    freq.put("hus", 79);
    freq.put("nev", 4);
    freq.put("X", 15);
    freq.put("Rit", 3);
    freq.put("Rin", 3);
    freq.put("Rig", 5);
    freq.put("øtt", 14);
    freq.put("irr", 17);
    freq.put("irs", 10);
    freq.put("irt", 8);
    freq.put("iri", 3);
    freq.put("irk", 95);
    freq.put("irl", 3);
    freq.put("irm", 8);
    freq.put("ira", 8);
    freq.put("irc", 5);
    freq.put("ire", 28);
    freq.put("mrå", 7);
    freq.put("DM ", 5);
    freq.put("øt ", 3);
    freq.put("ir ", 30);
    freq.put("pre", 32);
    freq.put("fra", 214);
    freq.put("fre", 107);
    freq.put("fri", 45);
    freq.put("fro", 18);
    freq.put("fru", 6);
    freq.put("fry", 4);
    freq.put("pro", 106);
    freq.put("NR ", 4);
    freq.put("bå", 20);
    freq.put("bil", 104);
    freq.put("dho", 7);
    freq.put("dhe", 12);
    freq.put("bie", 3);
    freq.put("tz ", 3);
    freq.put("sme", 14);
    freq.put("hah", 77);
    freq.put("hal", 37);
    freq.put("ham", 24);
    freq.put("han", 177);
    freq.put("haa", 3);
    freq.put("hac", 5);
    freq.put("had", 16);
    freq.put("umø", 6);
    freq.put("haf", 12);
    freq.put("hag", 9);
    freq.put("har", 504);
    freq.put("has", 9);
    freq.put("hat", 12);
    freq.put("hau", 4);
    freq.put("hav", 177);
    freq.put("ha ", 79);
    freq.put("DR ", 17);
    freq.put("ola", 10);
    freq.put("olb", 7);
    freq.put("old", 171);
    freq.put("ole", 51);
    freq.put("olf", 7);
    freq.put("olg", 3);
    freq.put("oli", 85);
    freq.put("olk", 58);
    freq.put("oll", 39);
    freq.put("olm", 12);
    freq.put("olo", 20);
    freq.put("ols", 11);
    freq.put("olt", 9);
    freq.put("olu", 7);
    freq.put("fot", 5);
    freq.put("umt", 7);
    freq.put("for", 953);
    freq.put("fod", 10);
    freq.put("foe", 5);
    freq.put("umf", 3);
    freq.put("fol", 62);
    freq.put("fon", 20);
    freq.put("umi", 3);
    freq.put("fok", 4);
    freq.put("ol ", 39);
    freq.put("o", 8706);
    freq.put("fo ", 5);
    freq.put("um ", 41);
    freq.put("lm ", 36);
    freq.put("mbl", 3);
    freq.put("Fed", 9);
    freq.put("mbo", 4);
    freq.put("mbi", 6);
    freq.put("sof", 10);
    freq.put("mbe", 22);
    freq.put("som", 299);
    freq.put("sol", 25);
    freq.put("son", 41);
    freq.put("sor", 16);
    freq.put("Fes", 5);
    freq.put("sov", 24);
    freq.put("mbu", 3);
    freq.put("so ", 8);
    freq.put("azi", 4);
    freq.put("azo", 5);
    freq.put("up", 115);
    freq.put("Sid", 17);
    freq.put("Sik", 4);
    freq.put("Sil", 4);
    freq.put("E", 428);
    freq.put("Ida", 4);
    freq.put("oss", 15);
    freq.put("ost", 42);
    freq.put("osv", 4);
    freq.put("osi", 15);
    freq.put("osk", 7);
    freq.put("oso", 5);
    freq.put("Byg", 5);
    freq.put("ose", 16);
    freq.put("vev", 3);
    freq.put("vet", 144);
    freq.put("ver", 617);
    freq.put("ves", 28);
    freq.put("VA ", 3);
    freq.put("ved", 182);
    freq.put("Ta ", 3);
    freq.put("ven", 154);
    freq.put("vel", 96);
    freq.put("vem", 40);
    freq.put("vej", 83);
    freq.put("vek", 3);
    freq.put("vei", 3);
    freq.put("Må", 13);
    freq.put("Mæ", 8);
    freq.put("lre", 3);
    freq.put("os ", 85);
    freq.put("Mø", 7);
    freq.put("Tar", 3);
    freq.put("Tag", 17);
    freq.put("Taa", 3);
    freq.put("ve ", 286);
    freq.put("Tac", 3);
    freq.put("nle", 5);
    freq.put("Tak", 36);
    freq.put("M ", 31);
    freq.put("yd ", 13);
    freq.put("Me", 144);
    freq.put("Ma", 122);
    freq.put("ydd", 7);
    freq.put("yde", 109);
    freq.put("Mi", 99);
    freq.put("Mu", 15);
    freq.put("uff", 5);
    freq.put("Mr", 3);
    freq.put("My", 6);
    freq.put("yds", 12);
    freq.put("Kbh", 10);
    freq.put("Lid", 13);
    freq.put("ipe", 8);
    freq.put("iph", 4);
    freq.put("ipl", 6);
    freq.put("ips", 10);
    freq.put("ipp", 11);
    freq.put("Bod", 4);
    freq.put("øvs", 3);
    freq.put("øvr", 11);
    freq.put("øvl", 6);
    freq.put("øvn", 9);
    freq.put("øve", 50);
    freq.put("ip ", 23);
    freq.put("sø", 144);
    freq.put("Liv", 8);
    freq.put("øv ", 20);
    freq.put("sæ", 89);
    freq.put("så", 634);
    freq.put("TF ", 3);
    freq.put("ærg", 10);
    freq.put("ære", 297);
    freq.put("ærd", 53);
    freq.put("ærk", 54);
    freq.put("ærh", 3);
    freq.put("ærn", 5);
    freq.put("ærm", 15);
    freq.put("ærl", 21);
    freq.put("ærs", 12);
    freq.put("ærr", 25);
    freq.put("ært", 57);
    freq.put("s ", 1710);
    freq.put("sy", 125);
    freq.put("ær ", 35);
    freq.put("ss", 253);
    freq.put("sr", 19);
    freq.put("sq", 6);
    freq.put("sp", 343);
    freq.put("sw", 6);
    freq.put("dyn", 4);
    freq.put("su", 111);
    freq.put("st", 1868);
    freq.put("sk", 1412);
    freq.put("sj", 44);
    freq.put("si", 622);
    freq.put("sh", 71);
    freq.put("so", 448);
    freq.put("sn", 116);
    freq.put("sm", 181);
    freq.put("sl", 172);
    freq.put("sc", 47);
    freq.put("sb", 36);
    freq.put("sa", 344);
    freq.put("sg", 34);
    freq.put("sf", 46);
    freq.put("se", 1235);
    freq.put("sd", 60);
    freq.put("ttr", 3);
    freq.put("ttp", 5);
    freq.put("tti", 24);
    freq.put("tto", 6);
    freq.put("Al ", 3);
    freq.put("ttl", 3);
    freq.put("tta", 4);
    freq.put("tte", 294);
    freq.put("blø", 5);
    freq.put("djy", 3);
    freq.put(" po", 68);
    freq.put("dje", 5);
    freq.put("blå", 6);
    freq.put("blæ", 3);
    freq.put("tt ", 8);
    freq.put("Men", 106);
    freq.put("Jou", 3);
    freq.put("blu", 4);
    freq.put("Joa", 3);
    freq.put("Job", 17);
    freq.put("bli", 167);
    freq.put("ble", 133);
    freq.put("Hun", 15);
    freq.put("bla", 27);
    freq.put("Jon", 5);
    freq.put("køl", 5);
    freq.put("køn", 12);
    freq.put("køb", 49);
    freq.put("kød", 7);
    freq.put("kør", 47);
    freq.put("Jo ", 6);
    freq.put("bl ", 3);
    freq.put("onk", 11);
    freq.put("oni", 6);
    freq.put("onn", 5);
    freq.put("ono", 14);
    freq.put("onl", 21);
    freq.put("onc", 22);
    freq.put("ona", 24);
    freq.put("onf", 10);
    freq.put("ong", 17);
    freq.put("ond", 37);
    freq.put("one", 112);
    freq.put("ons", 52);
    freq.put("onv", 4);
    freq.put("ont", 38);
    freq.put("onu", 4);
    freq.put("ovn", 6);
    freq.put("Sæt", 8);
    freq.put("ukt", 25);
    freq.put("uks", 3);
    freq.put("uko", 3);
    freq.put("Hmm", 11);
    freq.put("Sæl", 11);
    freq.put("ukk", 34);
    freq.put("uke", 5);
    freq.put(" Ze", 4);
    freq.put("on ", 169);
    freq.put(" Za", 4);
    freq.put(" Zu", 3);
    freq.put("AT ", 4);
    freq.put("Hm ", 3);
    freq.put("uk ", 12);
    freq.put("sak", 5);
    freq.put("san", 50);
    freq.put("sam", 133);
    freq.put("sal", 19);
    freq.put("sab", 4);
    freq.put("rme", 65);
    freq.put("sag", 52);
    freq.put("sap", 3);
    freq.put("sav", 14);
    freq.put("sau", 3);
    freq.put("sat", 46);
    freq.put("zon", 7);
    freq.put("ax ", 7);
    freq.put("sa ", 6);
    freq.put("axe", 3);
    freq.put("Sku", 7);
    freq.put("Skr", 19);
    freq.put("Sky", 4);
    freq.put("øø", 18);
    freq.put("Ska", 45);
    freq.put("Sko", 6);
    freq.put("Ski", 4);
    freq.put("økk", 20);
    freq.put("øko", 10);
    freq.put("Cyk", 3);
    freq.put(" bå", 17);
    freq.put(" bæ", 6);
    freq.put("kjæ", 3);
    freq.put(" bø", 45);
    freq.put("øj", 127);
    freq.put("øk", 34);
    freq.put("øh", 3);
    freq.put("øn", 101);
    freq.put("øl", 95);
    freq.put("øm", 32);
    freq.put("øb", 127);
    freq.put("øf", 9);
    freq.put("øg", 89);
    freq.put("ød", 202);
    freq.put("øe", 12);
    freq.put("øy", 9);
    freq.put("NE ", 5);
    freq.put("ør", 599);
    freq.put("øs", 87);
    freq.put("øv", 102);
    freq.put("øt", 19);
    freq.put("cis", 12);
    freq.put(" b ", 7);
    freq.put("cir", 8);
    freq.put("Aww", 4);
    freq.put("VG ", 3);
    freq.put("un", 537);
    freq.put("Tø", 7);
    freq.put("ø ", 25);
    freq.put("jør", 9);
    freq.put("SÅ ", 11);
    freq.put("Løs", 3);
    freq.put(" be", 308);
    freq.put(" ba", 273);
    freq.put("ækn", 9);
    freq.put(" bl", 323);
    freq.put(" bo", 66);
    freq.put(" bi", 92);
    freq.put(" bj", 6);
    freq.put(" bu", 84);
    freq.put("s", 10341);
    freq.put(" br", 176);
    freq.put(" by", 31);
    freq.put("ivæ", 3);
    freq.put("rå", 63);
    freq.put("Løb", 3);
    freq.put("fie", 4);
    freq.put("Nyt", 9);
    freq.put("smæ", 4);
    freq.put("små", 20);
    freq.put("lyd", 51);
    freq.put("fin", 115);
    freq.put("ive", 325);
    freq.put("iva", 17);
    freq.put("ivl", 13);
    freq.put("ivn", 7);
    freq.put("ivi", 9);
    freq.put("ivt", 11);
    freq.put("ivs", 5);
    freq.put("iv ", 60);
    freq.put("I", 280);
    freq.put("ét ", 6);
    freq.put("Sne", 4);
    freq.put("gde", 25);
    freq.put("tvæ", 12);
    freq.put("gdo", 9);
    freq.put("fvi", 6);
    freq.put("æpp", 8);
    freq.put("My ", 3);
    freq.put("Man", 40);
    freq.put("tvi", 17);
    freq.put("tve", 9);
    freq.put("ac ", 15);
    freq.put("dds", 9);
    freq.put("ddi", 4);
    freq.put("dda", 36);
    freq.put("dde", 80);
    freq.put("tv ", 20);
    freq.put("acc", 7);
    freq.put("ace", 42);
    freq.put("ack", 40);
    freq.put("aci", 3);
    freq.put("ach", 16);
    freq.put("aco", 11);
    freq.put("act", 5);
    freq.put("dd ", 5);
    freq.put("Ni", 27);
    freq.put("bje", 7);
    freq.put("No", 78);
    freq.put("Na", 27);
    freq.put("Ne", 56);
    freq.put("Ny", 38);
    freq.put("Nu", 50);
    freq.put("het", 8);
    freq.put("her", 160);
    freq.put("hes", 8);
    freq.put("hey", 3);
    freq.put("hed", 121);
    freq.put("hee", 4);
    freq.put("hef", 9);
    freq.put("heg", 3);
    freq.put("hel", 179);
    freq.put("hem", 8);
    freq.put("hen", 76);
    freq.put("heh", 10);
    freq.put("hej", 5);
    freq.put("N ", 27);
    freq.put("he ", 55);
    freq.put("aa", 69);
    freq.put("uic", 3);
    freq.put("ab", 124);
    freq.put("ae", 43);
    freq.put("uid", 6);
    freq.put("ag", 926);
    freq.put("af", 687);
    freq.put("ai", 54);
    freq.put("ah", 137);
    freq.put("Hol", 30);
    freq.put("aj", 22);
    freq.put("am", 499);
    freq.put("Nå", 32);
    freq.put("Næ", 17);
    freq.put("an", 2305);
    freq.put("Nø", 8);
    freq.put("How", 5);
    freq.put("as", 313);
    freq.put("ar", 1867);
    freq.put("au", 72);
    freq.put("Hos", 3);
    freq.put("aw", 17);
    freq.put("av", 404);
    freq.put("ay", 54);
    freq.put("ax", 16);
    freq.put("az", 12);
    freq.put("bjø", 5);
    freq.put("aB", 6);
    freq.put("æmp", 15);
    freq.put("æmm", 6);
    freq.put("a ", 968);
    freq.put("oh ", 3);
    freq.put("smy", 3);
    freq.put("rs", 553);
    freq.put("smu", 33);
    freq.put("Fir", 9);
    freq.put("sco", 14);
    freq.put("sci", 4);
    freq.put("sch", 7);
    freq.put("sce", 11);
    freq.put("sms", 4);
    freq.put("sca", 7);
    freq.put("dss", 10);
    freq.put("mni", 7);
    freq.put("Fik", 8);
    freq.put("Fin", 13);
    freq.put("mne", 9);
    freq.put("Fil", 6);
    freq.put("smo", 5);
    freq.put("tz", 7);
    freq.put("dso", 11);
    freq.put("tv", 61);
    freq.put("tw", 63);
    freq.put("tt", 360);
    freq.put("tu", 169);
    freq.put("tr", 457);
    freq.put("dsl", 16);
    freq.put("tp", 19);
    freq.put("tn", 55);
    freq.put("to", 401);
    freq.put("tl", 76);
    freq.put("dsm", 7);
    freq.put("tj", 47);
    freq.put("tk", 11);
    freq.put("th", 77);
    freq.put("ti", 1856);
    freq.put("tf", 33);
    freq.put("tg", 3);
    freq.put("td", 8);
    freq.put("te", 2016);
    freq.put("tb", 15);
    freq.put("tc", 7);
    freq.put("ra", 780);
    freq.put("smi", 42);
    freq.put("dsi", 11);
    freq.put("dsf", 9);
    freq.put("Fi ", 3);
    freq.put("mn ", 6);
    freq.put("dsd", 4);
    freq.put("Må ", 4);
    freq.put("dse", 53);
    freq.put("dsb", 9);
    freq.put("pba", 3);
    freq.put("sma", 51);
    freq.put("dsa", 21);
    freq.put("t ", 6406);
    freq.put("Smu", 6);
    freq.put("fæt", 4);
    freq.put("fær", 39);
    freq.put("fæn", 7);
    freq.put("fæl", 26);
    freq.put("Smi", 4);
    freq.put("Sma", 6);
    freq.put("ømm", 16);
    freq.put(" y", 28);
    freq.put("tø", 112);
    freq.put("tæ", 153);
    freq.put("tå", 78);
    freq.put("øm ", 4);
    freq.put("vic", 12);
    freq.put("via", 34);
    freq.put("vig", 22);
    freq.put("vid", 90);
    freq.put("vie", 10);
    freq.put("vik", 25);
    freq.put("vin", 79);
    freq.put("vil", 238);
    freq.put("vir", 81);
    freq.put("vis", 230);
    freq.put("viv", 13);
    freq.put("vit", 16);
    freq.put("kl ", 43);
    freq.put(" d ", 24);
    freq.put("VE ", 5);
    freq.put("vi ", 171);
    freq.put(" do", 65);
    freq.put("kle", 28);
    freq.put(" dk", 38);
    freq.put("kla", 90);
    freq.put(" di", 276);
    freq.put(" de", 2312);
    freq.put("klo", 9);
    freq.put("kli", 28);
    freq.put(" da", 417);
    freq.put("klu", 17);
    freq.put(" dy", 21);
    freq.put(" dv", 5);
    freq.put(" du", 532);
    freq.put(" dr", 71);
    freq.put("atr", 10);
    freq.put("æbl", 5);
    freq.put("øse", 15);
    freq.put("klæ", 16);
    freq.put(" dé", 10);
    freq.put(" dæ", 13);
    freq.put(" då", 28);
    freq.put(" dø", 43);
    freq.put("itn", 5);
    freq.put("itl", 4);
    freq.put("tål", 3);
    freq.put("ith", 7);
    freq.put("iti", 72);
    freq.put("ite", 76);
    freq.put("tåe", 12);
    freq.put("ita", 22);
    freq.put("itz", 3);
    freq.put("ity", 12);
    freq.put("itt", 67);
    freq.put("itu", 12);
    freq.put("itr", 6);
    freq.put("its", 9);
    freq.put("tå ", 15);
    freq.put("it ", 161);
    freq.put("tro", 99);
    freq.put("cc ", 3);
    freq.put("DK ", 16);
    freq.put(" A ", 22);
    freq.put("gfr", 4);
    freq.put("ævn", 12);
    freq.put("fts", 5);
    freq.put("ævl", 3);
    freq.put("ftt", 3);
    freq.put("ftw", 4);
    freq.put("æve", 15);
    freq.put("at ", 912);
    freq.put("fta", 4);
    freq.put("fte", 207);
    freq.put("fti", 16);
    freq.put("fth", 3);
    freq.put(" Aa", 30);
    freq.put(" Ac", 4);
    freq.put(" Ad", 6);
    freq.put(" Af", 18);
    freq.put(" Ag", 4);
    freq.put(" Ah", 8);
    freq.put(" Ai", 4);
    freq.put(" Ak", 13);
    freq.put(" Al", 59);
    freq.put(" Am", 23);
    freq.put(" An", 36);
    freq.put(" Ap", 15);
    freq.put(" Ar", 29);
    freq.put(" As", 6);
    freq.put(" At", 11);
    freq.put(" Au", 7);
    freq.put(" Aw", 6);
    freq.put("NG ", 3);
    freq.put("evt", 4);
    freq.put("ft ", 53);
    freq.put("w", 360);
    freq.put("HD ", 5);
    freq.put("Fra", 15);
    freq.put("Fre", 26);
    freq.put("uel", 9);
    freq.put("Fri", 7);
    freq.put("KE ", 10);
    freq.put("æ ", 42);
    freq.put("Fry", 3);
    freq.put("jer", 131);
    freq.put("jes", 10);
    freq.put("", 4);
    freq.put("jev", 6);
    freq.put("aa ", 11);
    freq.put("jet", 9);
    freq.put("dfu", 3);
    freq.put("dfr", 3);
    freq.put("jeb", 5);
    freq.put("Blu", 3);
    freq.put("dfo", 7);
    freq.put("jeg", 659);
    freq.put("jed", 6);
    freq.put("dfe", 3);
    freq.put("jek", 31);
    freq.put("jen", 31);
    freq.put("jel", 5);
    freq.put("jem", 71);
    freq.put("æp", 9);
    freq.put("ær", 598);
    freq.put("uef", 5);
    freq.put("æt", 120);
    freq.put("æv", 36);
    freq.put("æb", 15);
    freq.put("æc", 10);
    freq.put("æd", 83);
    freq.put("æf", 24);
    freq.put("æg", 76);
    freq.put("æh", 15);
    freq.put("æi", 6);
    freq.put("æk", 112);
    freq.put("æl", 207);
    freq.put("Isæ", 9);
    freq.put("æn", 253);
    freq.put("aaa", 29);
    freq.put("aah", 4);
    freq.put("aak", 4);
    freq.put("je ", 39);
    freq.put("aar", 12);
    freq.put("uet", 3);
    freq.put("yhe", 22);
    freq.put("dfø", 7);
    freq.put("ex ", 9);
    freq.put("tp ", 5);
    freq.put("Bla", 8);
    freq.put("uer", 10);
    freq.put("Øst", 7);
    freq.put("emæ", 6);
    freq.put("bh ", 16);
    freq.put("M", 507);
    freq.put("ææ", 10);
    freq.put("Isl", 4);
    freq.put("åvi", 3);
    freq.put("tph", 5);
    freq.put("ext", 3);
    freq.put("tpr", 5);
    freq.put("Hah", 30);
    freq.put("Hal", 8);
    freq.put("Ham", 6);
    freq.put("Han", 39);
    freq.put("ugl", 20);
    freq.put("Hac", 3);
    freq.put("Had", 4);
    freq.put("uge", 103);
    freq.put("oje", 16);
    freq.put("ugs", 5);
    freq.put("Har", 113);
    freq.put("Has", 3);
    freq.put("Hau", 3);
    freq.put("Hav", 9);
    freq.put("ugt", 22);
    freq.put("rf ", 3);
    freq.put("Ha ", 6);
    freq.put("ug ", 34);
    freq.put("rfr", 10);
    freq.put("rfu", 6);
    freq.put("cru", 3);
    freq.put("rfa", 17);
    freq.put("rfe", 15);
    freq.put("cre", 7);
    freq.put("rfo", 80);
    freq.put("cro", 9);
    freq.put("set", 68);
    freq.put("ses", 31);
    freq.put("ser", 290);
    freq.put("For", 61);
    freq.put("sep", 8);
    freq.put("sex", 7);
    freq.put("seg", 4);
    freq.put("sef", 6);
    freq.put("see", 7);
    freq.put("sed", 10);
    freq.put("seb", 3);
    freq.put("sea", 5);
    freq.put("Fol", 12);
    freq.put("sen", 273);
    freq.put("sem", 10);
    freq.put("sel", 123);
    freq.put("sek", 22);
    freq.put("sej", 37);
    freq.put("sei", 7);
    freq.put("lem", 80);
    freq.put("se ", 308);
    freq.put("rfø", 6);
    freq.put("rfæ", 4);
    freq.put("pda", 21);
    freq.put("nr ", 8);
    freq.put("lex", 6);
    freq.put("ml ", 3);
    freq.put("tiv", 55);
    freq.put("nri", 10);
    freq.put("nra", 3);
    freq.put("Ole", 5);
    freq.put("mle", 31);
    freq.put("knæ", 4);
    freq.put(" fø", 152);
    freq.put("mli", 17);
    freq.put("Ols", 3);
    freq.put(" få", 194);
    freq.put(" fæ", 51);
    freq.put("vog", 3);
    freq.put("vol", 11);
    freq.put("vom", 4);
    freq.put("vok", 8);
    freq.put("vor", 293);
    freq.put(" f ", 10);
    freq.put("vo ", 10);
    freq.put("kno", 7);
    freq.put("Soc", 4);
    freq.put(" fr", 349);
    freq.put(" fu", 78);
    freq.put("kni", 27);
    freq.put(" fy", 20);
    freq.put("kne", 3);
    freq.put("Som", 11);
    freq.put("Sol", 5);
    freq.put("kna", 11);
    freq.put(" fa", 236);
    freq.put("Sor", 3);
    freq.put(" fe", 123);
    freq.put("Sov", 4);
    freq.put(" fi", 199);
    freq.put(" fj", 17);
    freq.put(" fl", 127);
    freq.put(" fo", 884);
    freq.put("O ", 42);
    freq.put("amv", 3);
    freq.put("On", 5);
    freq.put("Om", 5);
    freq.put("Ol", 9);
    freq.put("Ok", 14);
    freq.put("Oh", 4);
    freq.put("Og", 80);
    freq.put("Of", 5);
    freq.put("Od", 10);
    freq.put("Oc", 4);
    freq.put("Ob", 4);
    freq.put("Ov", 11);
    freq.put("bø", 55);
    freq.put("Or", 8);
    freq.put("Op", 17);
    freq.put("d", 11962);
    freq.put("Kha", 4);
    freq.put("b ", 96);
    freq.put(" Du", 77);
    freq.put("bd", 3);
    freq.put("be", 738);
    freq.put("ba", 390);
    freq.put("bb", 29);
    freq.put("bc", 6);
    freq.put("bl", 408);
    freq.put("bm", 3);
    freq.put("bn", 15);
    freq.put("bo", 203);
    freq.put("bh", 16);
    freq.put("bi", 175);
    freq.put("bj", 15);
    freq.put("bt", 23);
    freq.put("bu", 144);
    freq.put("br", 258);
    freq.put("bs", 53);
    freq.put("by", 94);
    freq.put("afé", 3);
    freq.put("bøs", 4);
    freq.put("bør", 39);
    freq.put("bøv", 3);
    freq.put("Fy", 9);
    freq.put("DE ", 6);
    freq.put("Død", 3);
    freq.put(" C ", 11);
    freq.put("æts", 4);
    freq.put("ætt", 57);
    freq.put("tig", 147);
    freq.put("u ", 900);
    freq.put("ætn", 7);
    freq.put(" Ch", 35);
    freq.put(" Ci", 13);
    freq.put(" Co", 38);
    freq.put(" Cl", 22);
    freq.put("uT", 3);
    freq.put(" Ca", 29);
    freq.put(" Ce", 7);
    freq.put(" Cy", 6);
    freq.put(" Cr", 9);
    freq.put(" Cu", 10);
    freq.put("cia", 30);
    freq.put("ux", 4);
    freq.put("cie", 16);
    freq.put("uu", 22);
    freq.put("ut", 148);
    freq.put("uv", 16);
    freq.put("cin", 7);
    freq.put("us", 332);
    freq.put("ur", 291);
    freq.put("um", 137);
    freq.put("ul", 265);
    freq.put("uo", 3);
    freq.put("cip", 6);
    freq.put("ui", 22);
    freq.put("uh", 20);
    freq.put("uk", 88);
    freq.put("cit", 9);
    freq.put("ue", 80);
    freq.put("ud", 474);
    freq.put("ug", 202);
    freq.put("uf", 26);
    freq.put("ua", 30);
    freq.put("uc", 79);
    freq.put("ub", 51);
    freq.put("ag ", 334);
    freq.put("ago", 5);
    freq.put("agn", 10);
    freq.put("agl", 7);
    freq.put("agi", 6);
    freq.put("agh", 4);
    freq.put("agg", 4);
    freq.put("age", 388);
    freq.put("agd", 21);
    freq.put("agb", 3);
    freq.put("aga", 7);
    freq.put("agu", 8);
    freq.put("agt", 65);
    freq.put("ags", 34);
    freq.put("agr", 5);
    freq.put("pul", 7);
    freq.put("ev ", 77);
    freq.put("åt ", 5);
    freq.put("tri", 43);
    freq.put("evi", 24);
    freq.put("evl", 5);
    freq.put("evn", 8);
    freq.put("evo", 7);
    freq.put("tra", 99);
    freq.put("eva", 12);
    freq.put("tre", 65);
    freq.put("eve", 175);
    freq.put("try", 17);
    freq.put("åte", 5);
    freq.put("evs", 4);
    freq.put("tru", 29);
    freq.put("le ", 577);
    freq.put("ody", 3);
    freq.put("uen", 12);
    freq.put("odp", 3);
    freq.put("ods", 28);
    freq.put("odt", 197);
    freq.put("odu", 16);
    freq.put("odv", 3);
    freq.put("odi", 13);
    freq.put("Blo", 7);
    freq.put("odk", 4);
    freq.put("Bli", 12);
    freq.put("odm", 10);
    freq.put("odn", 8);
    freq.put("oda", 7);
    freq.put("odb", 13);
    freq.put("odd", 10);
    freq.put("ode", 81);
    freq.put("ues", 10);
    freq.put("odg", 3);
    freq.put("ct ", 9);
    freq.put("rd ", 66);
    freq.put("lea", 8);
    freq.put("leb", 9);
    freq.put("lec", 5);
    freq.put("led", 113);
    freq.put("lee", 3);
    freq.put("lef", 26);
    freq.put("leg", 33);
    freq.put("lei", 4);
    freq.put("lej", 26);
    freq.put("lek", 13);
    freq.put("lel", 15);
    freq.put("ue ", 24);
    freq.put("len", 116);
    freq.put("lep", 3);
    freq.put("ler", 524);
    freq.put("les", 79);
    freq.put("let", 107);
    freq.put("lev", 168);
    freq.put("od ", 155);
    freq.put("ley", 8);
    freq.put("rdt", 11);
    freq.put("rdp", 3);
    freq.put("rds", 23);
    freq.put("rdr", 15);
    freq.put("trå", 10);
    freq.put("evæ", 12);
    freq.put("træ", 74);
    freq.put("rde", 134);
    freq.put("trø", 19);
    freq.put("rdf", 5);
    freq.put("rda", 84);
    freq.put("rdl", 3);
    freq.put("rdo", 9);
    freq.put("cto", 7);
    freq.put("rdi", 78);
    freq.put("rdj", 3);
    freq.put("aB ", 6);
    freq.put("sgr", 5);
    freq.put("sgu", 25);
    freq.put("zis", 3);
    freq.put("pfo", 4);
    freq.put("npo", 3);
    freq.put("Q", 5);
    freq.put("npu", 3);
    freq.put("æ", 1832);
    freq.put("båd", 16);
    freq.put("Ya", 8);
    freq.put("vmo", 3);
    freq.put("Kjæ", 4);
    freq.put("vm ", 3);
    freq.put(" hy", 22);
    freq.put("San", 5);
    freq.put("Sam", 14);
    freq.put("Sal", 3);
    freq.put(" hv", 415);
    freq.put(" hu", 139);
    freq.put(" ht", 10);
    freq.put(" hj", 114);
    freq.put(" hi", 54);
    freq.put(" ho", 158);
    freq.put(" hm", 6);
    freq.put("Sas", 4);
    freq.put("Sar", 8);
    freq.put(" ha", 913);
    freq.put("Sav", 5);
    freq.put(" he", 415);
    freq.put("pør", 29);
    freq.put("pøg", 5);
    freq.put(" hø", 109);
    freq.put("høj", 42);
    freq.put(" hæ", 26);
    freq.put(" hå", 77);
    freq.put("ihv", 4);
    freq.put("IT ", 7);
    freq.put("høn", 3);
    freq.put("iho", 3);
    freq.put("iha", 3);
    freq.put("høs", 3);
    freq.put("los", 7);
    freq.put("høv", 5);
    freq.put("én ", 17);
    freq.put(" E ", 12);
    freq.put("GF ", 3);
    freq.put("ck ", 58);
    freq.put(" El", 45);
    freq.put(" Em", 6);
    freq.put(" En", 89);
    freq.put(" Ej", 16);
    freq.put(" Ek", 7);
    freq.put(" Ed", 3);
    freq.put(" Ef", 16);
    freq.put(" Eg", 5);
    freq.put(" Ex", 9);
    freq.put(" Et", 25);
    freq.put(" Eu", 21);
    freq.put(" Ev", 9);
    freq.put(" Ep", 4);
    freq.put(" Er", 112);
    freq.put(" Es", 3);
    freq.put("cke", 34);
    freq.put("cki", 20);
    freq.put("cks", 7);
    freq.put("dbo", 14);
    freq.put("dba", 11);
    freq.put("dbe", 3);
    freq.put("dby", 18);
    freq.put("På", 19);
    freq.put("dbr", 11);
    freq.put("jar", 4);
    freq.put("jan", 8);
    freq.put("ae ", 3);
    freq.put("jal", 3);
    freq.put("jam", 5);
    freq.put("jag", 9);
    freq.put("gbe", 3);
    freq.put("aet", 8);
    freq.put("gbo", 3);
    freq.put("etø", 7);
    freq.put("etæ", 9);
    freq.put("ael", 10);
    freq.put("ja ", 92);
    freq.put("aen", 14);
    freq.put("Pr", 45);
    freq.put("Pu", 11);
    freq.put("oma", 21);
    freq.put("dbæ", 3);
    freq.put("bte", 12);
    freq.put("Pa", 61);
    freq.put("Pe", 29);
    freq.put("Ph", 23);
    freq.put("Pi", 17);
    freq.put("Po", 31);
    freq.put("Pl", 15);
    freq.put("et ", 3010);
    freq.put("år ", 414);
    freq.put("edj", 4);
    freq.put("P ", 35);
    freq.put("le", 1931);
    freq.put("bt ", 10);
    freq.put("lc", 3);
    freq.put("etr", 16);
    freq.put("ets", 32);
    freq.put("etv", 14);
    freq.put("etw", 5);
    freq.put("ett", 74);
    freq.put("års", 18);
    freq.put("ety", 16);
    freq.put("ård", 19);
    freq.put("åre", 23);
    freq.put("tla", 5);
    freq.put("eta", 34);
    freq.put("etf", 4);
    freq.put("tle", 14);
    freq.put("lo", 282);
    freq.put("årl", 26);
    freq.put("tli", 50);
    freq.put("eti", 13);
    freq.put("årh", 7);
    freq.put("åri", 19);
    freq.put("ck", 135);
    freq.put("ci", 95);
    freq.put("lm", 95);
    freq.put("co", 98);
    freq.put("vå", 17);
    freq.put("cm", 5);
    freq.put("cl", 19);
    freq.put("cc", 30);
    freq.put("ca", 70);
    freq.put("Hey", 5);
    freq.put("ce", 211);
    freq.put("cd", 3);
    freq.put("Hed", 3);
    freq.put("uce", 10);
    freq.put("ucc", 6);
    freq.put("vø", 6);
    freq.put("cr", 22);
    freq.put("Hen", 12);
    freq.put("li", 1639);
    freq.put("uck", 52);
    freq.put("cu", 14);
    freq.put("uch", 6);
    freq.put("Get", 3);
    freq.put("åse", 4);
    freq.put("Geo", 5);
    freq.put("Gen", 7);
    freq.put("lgk", 8);
    freq.put("c ", 41);
    freq.put("lgd", 4);
    freq.put("lge", 85);
    freq.put("lgr", 3);
    freq.put("lgs", 3);
    freq.put("lgt", 18);
    freq.put("rby", 4);
    freq.put("rbu", 6);
    freq.put("rbr", 8);
    freq.put("rbo", 13);
    freq.put("rbl", 6);
    freq.put("rbi", 19);
    freq.put("rbe", 89);
    freq.put("eur", 12);
    freq.put("rba", 13);
    freq.put("Esb", 3);
    freq.put("va", 590);
    freq.put("vb", 4);
    freq.put("vd", 61);
    freq.put("ve", 1649);
    freq.put("vf", 11);
    freq.put("vh", 5);
    freq.put("vi", 1024);
    freq.put("ph ", 3);
    freq.put("vl", 50);
    freq.put("vm", 6);
    freq.put("vn", 130);
    freq.put("vo", 331);
    freq.put("vr", 32);
    freq.put("vs", 45);
    freq.put("vt", 34);
    freq.put("vu", 7);
    freq.put("vv", 3);
    freq.put("of ", 15);
    freq.put("Såd", 17);
    freq.put("v ", 329);
    freq.put("phi", 3);
    freq.put("pho", 12);
    freq.put("phe", 4);
    freq.put("phy", 3);
    freq.put("off", 30);
    freq.put("ofe", 5);
    freq.put("ofi", 12);
    freq.put("oft", 25);
    freq.put("umo", 6);
    freq.put("xer", 4);
    freq.put("web", 18);
    freq.put("wee", 70);
    freq.put("wed", 4);
    freq.put("Oh ", 3);
    freq.put("wel", 6);
    freq.put("wes", 11);
    freq.put("wer", 14);
    freq.put("xe ", 5);
    freq.put("nve", 18);
    freq.put("nva", 3);
    freq.put("Lau", 3);
    freq.put("Lav", 4);
    freq.put("nvi", 11);
    freq.put("mhe", 9);
    freq.put("dge", 9);
    freq.put(" jæ", 3);
    freq.put("kræ", 20);
    freq.put("vss", 3);
    freq.put("vst", 9);
    freq.put("vsa", 5);
    freq.put("vsk", 3);
    freq.put("kr ", 23);
    freq.put("lle", 764);
    freq.put("vs ", 14);
    freq.put("Sco", 5);
    freq.put("kry", 13);
    freq.put("Sch", 12);
    freq.put(" ju", 20);
    freq.put("kru", 9);
    freq.put(" jo", 107);
    freq.put("kri", 134);
    freq.put("kro", 15);
    freq.put(" je", 697);
    freq.put("kra", 39);
    freq.put(" ja", 105);
    freq.put("kre", 80);
    freq.put("inæ", 3);
    freq.put("Løk", 17);
    freq.put("yrk", 6);
    freq.put("yra", 3);
    freq.put("nåe", 3);
    freq.put("yre", 25);
    freq.put("yrr", 3);
    freq.put("når", 105);
    freq.put("Kla", 9);
    freq.put("Klo", 4);
    freq.put("Kli", 4);
    freq.put("yr ", 17);
    freq.put("nå ", 20);
    freq.put("int", 83);
    freq.put("inu", 19);
    freq.put("inv", 13);
    freq.put("mæl", 5);
    freq.put("mæn", 21);
    freq.put("ins", 39);
    freq.put("inl", 3);
    freq.put("inm", 3);
    freq.put("mær", 24);
    freq.put("ino", 3);
    freq.put("ini", 47);
    freq.put("inj", 4);
    freq.put("ink", 46);
    freq.put("ind", 347);
    freq.put("ine", 147);
    freq.put("inf", 12);
    freq.put("ing", 619);
    freq.put("ina", 41);
    freq.put("inc", 5);
    freq.put("væ", 390);
    freq.put("eo ", 23);
    freq.put("mæ ", 4);
    freq.put("U", 114);
    freq.put("in ", 402);
    freq.put("eoe", 8);
    freq.put("eol", 4);
    freq.put("eos", 4);
    freq.put("tsæ", 6);
    freq.put("eop", 4);
    freq.put("sst", 15);
    freq.put("tså", 39);
    freq.put("AH ", 3);
    freq.put("MA ", 3);
    freq.put(" G ", 5);
    freq.put("cm ", 4);
    freq.put("pte", 16);
    freq.put(" Gu", 19);
    freq.put(" Gr", 32);
    freq.put("Tun", 8);
    freq.put(" Ge", 21);
    freq.put(" Ga", 28);
    freq.put(" Go", 96);
    freq.put(" Gl", 30);
    freq.put(" Gi", 19);
    freq.put("væn", 4);
    freq.put("væl", 13);
    freq.put("væk", 26);
    freq.put("væg", 13);
    freq.put("glæ", 30);
    freq.put("AG ", 5);
    freq.put("lø", 138);
    freq.put("væs", 4);
    freq.put("vær", 328);
    freq.put("ptu", 3);
    freq.put("gl ", 3);
    freq.put("ptr", 5);
    freq.put("ak ", 80);
    freq.put(" Gø", 5);
    freq.put(" Gæ", 5);
    freq.put(" Gå", 11);
    freq.put("Cr", 9);
    freq.put("gli", 10);
    freq.put("aks", 3);
    freq.put("gla", 45);
    freq.put("gle", 144);
    freq.put("aku", 4);
    freq.put("akt", 84);
    freq.put("akk", 57);
    freq.put("aki", 9);
    freq.put("ako", 4);
    freq.put("akn", 3);
    freq.put("aka", 13);
    freq.put("ake", 17);
    freq.put("Jer", 4);
    freq.put("Jes", 9);
    freq.put("Jep", 7);
    freq.put("bry", 17);
    freq.put("bru", 108);
    freq.put("bro", 25);
    freq.put("Jeg", 234);
    freq.put("bri", 20);
    freq.put("bre", 25);
    freq.put("Jen", 8);
    freq.put("bra", 34);
    freq.put("Fu", 37);
    freq.put("er ", 5293);
    freq.put("nke", 100);
    freq.put("nkl", 6);
    freq.put("nko", 7);
    freq.put("nkr", 7);
    freq.put("nks", 10);
    freq.put("nkt", 31);
    freq.put("nku", 8);
    freq.put("ert", 120);
    freq.put("eru", 17);
    freq.put("erv", 74);
    freq.put("erp", 12);
    freq.put("err", 41);
    freq.put("ih", 12);
    freq.put("ik", 944);
    freq.put("erd", 46);
    freq.put("ere", 709);
    freq.put("erf", 56);
    freq.put("erg", 38);
    freq.put("era", 60);
    freq.put("erb", 40);
    freq.put("erc", 4);
    freq.put("erl", 66);
    freq.put("erm", 34);
    freq.put("ern", 261);
    freq.put("ero", 14);
    freq.put("erh", 36);
    freq.put("eri", 170);
    freq.put("erj", 7);
    freq.put("erk", 31);
    freq.put("io", 204);
    freq.put("brø", 14);
    freq.put("uar", 8);
    freq.put("la ", 32);
    freq.put("uat", 5);
    freq.put("uam", 4);
    freq.put("ual", 3);
    freq.put("uan", 3);
    freq.put("bræ", 12);
    freq.put("uaf", 3);
    freq.put("ki ", 9);
    freq.put("lam", 25);
    freq.put("lan", 185);
    freq.put("lai", 5);
    freq.put("lak", 9);
    freq.put("lad", 119);
    freq.put("lag", 73);
    freq.put("lab", 4);
    freq.put("lac", 3);
    freq.put("lay", 5);
    freq.put("lat", 25);
    freq.put("ua ", 3);
    freq.put("lav", 88);
    freq.put("lap", 9);
    freq.put("lar", 64);
    freq.put("las", 28);
    freq.put("erø", 6);
    freq.put("erå", 8);
    freq.put("eræ", 4);
    freq.put("mpu", 11);
    freq.put("zer", 4);
    freq.put("fac", 13);
    freq.put("ze ", 5);
    freq.put("l", 10254);
    freq.put("tøj", 20);
    freq.put("tød", 5);
    freq.put("øer", 6);
    freq.put("tøv", 9);
    freq.put("tøt", 14);
    freq.put("tøs", 4);
    freq.put("tør", 54);
    freq.put("nty", 5);
    freq.put("kip", 3);
    freq.put("nts", 5);
    freq.put("ntr", 20);
    freq.put("ntu", 3);
    freq.put("nti", 23);
    freq.put("ntl", 39);
    freq.put("nto", 12);
    freq.put("nta", 57);
    freq.put("nte", 167);
    freq.put("mve", 6);
    freq.put("mvi", 4);
    freq.put("i ", 1643);
    freq.put("Se ", 19);
    freq.put("kt ", 61);
    freq.put(" le", 108);
    freq.put("B", 385);
    freq.put(" la", 217);
    freq.put(" lo", 63);
    freq.put(" li", 573);
    freq.put(" lu", 38);
    freq.put(" ly", 91);
    freq.put("Ses", 4);
    freq.put("Ser", 20);
    freq.put("Sep", 3);
    freq.put("ktu", 8);
    freq.put("ktl", 5);
    freq.put("kto", 12);
    freq.put("kti", 94);
    freq.put("Sen", 6);
    freq.put("Sel", 15);
    freq.put("kta", 9);
    freq.put("ter", 684);
    freq.put("udt", 14);
    freq.put("nbe", 12);
    freq.put("ype", 8);
    freq.put("ypi", 3);
    freq.put(" læ", 139);
    freq.put(" lå", 14);
    freq.put("Qv", 3);
    freq.put("Knu", 3);
    freq.put(" lø", 79);
    freq.put("ktø", 9);
    freq.put("ogn", 6);
    freq.put("udf", 10);
    freq.put("ogh", 3);
    freq.put("d ", 2261);
    freq.put("Tog", 4);
    freq.put("em ", 210);
    freq.put("hri", 25);
    freq.put("dn", 73);
    freq.put("do", 144);
    freq.put("dl", 137);
    freq.put("dm", 32);
    freq.put("dj", 9);
    freq.put("dk", 63);
    freq.put("dh", 27);
    freq.put("di", 623);
    freq.put("df", 31);
    freq.put("dg", 43);
    freq.put("dd", 139);
    freq.put("de", 5088);
    freq.put("db", 67);
    freq.put("DC ", 8);
    freq.put("da", 863);
    freq.put("dy", 36);
    freq.put("dv", 55);
    freq.put("dw", 6);
    freq.put("dt", 678);
    freq.put("du", 564);
    freq.put("dr", 329);
    freq.put("ds", 497);
    freq.put("dp", 14);
    freq.put("eme", 42);
    freq.put("åkn", 3);
    freq.put("emg", 4);
    freq.put("emf", 5);
    freq.put("ema", 29);
    freq.put("CK ", 8);
    freq.put("emb", 21);
    freq.put("emm", 108);
    freq.put("eml", 10);
    freq.put("emo", 24);
    freq.put("emn", 9);
    freq.put("emi", 29);
    freq.put("emt", 36);
    freq.put("emp", 15);
    freq.put("ems", 8);
    freq.put("emr", 6);
    freq.put("emy", 5);
    freq.put("w ", 58);
    freq.put(" I ", 89);
    freq.put("il ", 975);
    freq.put("xD ", 5);
    freq.put("co ", 8);
    freq.put("we", 131);
    freq.put("wc", 4);
    freq.put("wa", 24);
    freq.put("dé", 18);
    freq.put("dæ", 24);
    freq.put("wn", 7);
    freq.put(" Ir", 6);
    freq.put(" Is", 17);
    freq.put(" It", 7);
    freq.put(" Iv", 3);
    freq.put("wh", 6);
    freq.put(" Ih", 4);
    freq.put(" Ik", 21);
    freq.put(" Il", 3);
    freq.put(" Im", 10);
    freq.put(" In", 60);
    freq.put(" Ia", 3);
    freq.put(" Ib", 3);
    freq.put(" Id", 5);
    freq.put(" Ig", 3);
    freq.put("ilf", 22);
    freq.put("ild", 70);
    freq.put("ile", 49);
    freq.put("ilb", 44);
    freq.put("cot", 4);
    freq.put("GB ", 4);
    freq.put("ila", 4);
    freq.put("iln", 5);
    freq.put("ilo", 8);
    freq.put("ill", 378);
    freq.put("ilm", 53);
    freq.put("ilj", 6);
    freq.put("ilk", 26);
    freq.put("ili", 33);
    freq.put("ilv", 3);
    freq.put("ilt", 13);
    freq.put("cob", 5);
    freq.put("ils", 27);
    freq.put("com", 27);
    freq.put("emø", 4);
    freq.put("coo", 6);
    freq.put("ily", 3);
    freq.put("hae", 10);
    freq.put("gn ", 36);
    freq.put("niø", 3);
    freq.put("gns", 4);
    freq.put("gnv", 4);
    freq.put("air", 6);
    freq.put("ail", 21);
    freq.put("ET ", 17);
    freq.put("ain", 18);
    freq.put("bne", 13);
    freq.put("gne", 67);
    freq.put("gni", 15);
    freq.put("gno", 5);
    freq.put("ni ", 12);
    freq.put("Ikk", 19);
    freq.put("ep ", 9);
    freq.put("th ", 9);
    freq.put("nik", 14);
    freq.put("nin", 211);
    freq.put("nio", 6);
    freq.put("nil", 5);
    freq.put("nic", 9);
    freq.put("nia", 13);
    freq.put("nif", 3);
    freq.put("nig", 37);
    freq.put("nie", 12);
    freq.put("Y", 38);
    freq.put("nis", 47);
    freq.put("niv", 9);
    freq.put("nit", 28);
    freq.put("thu", 4);
    freq.put("epu", 5);
    freq.put("epr", 14);
    freq.put("eps", 9);
    freq.put("epp", 4);
    freq.put("tho", 6);
    freq.put("epo", 5);
    freq.put("epl", 11);
    freq.put("thi", 9);
    freq.put("epi", 6);
    freq.put("the", 31);
    freq.put("epe", 7);
    freq.put("Køb", 41);
    freq.put("tha", 9);
    freq.put("epa", 12);
    freq.put("rn ", 50);
    freq.put("Gam", 4);
    freq.put("Gal", 8);
    freq.put("Gad", 12);
    freq.put("Tri", 8);
    freq.put("rni", 27);
    freq.put("rnh", 5);
    freq.put("Tro", 36);
    freq.put("Tra", 7);
    freq.put("rna", 23);
    freq.put("Tre", 9);
    freq.put("rne", 256);
    freq.put("plø", 4);
    freq.put("rns", 3);
    freq.put("mis", 39);
    freq.put("rnu", 3);
    freq.put("Too", 3);
    freq.put("gøj", 9);
    freq.put("gør", 93);
    freq.put("Lea", 5);
    freq.put("Led", 8);
    freq.put("yke", 13);
    freq.put("Leg", 4);
    freq.put("ykk", 59);
    freq.put("yki", 4);
    freq.put("yko", 5);
    freq.put("ob ", 16);
    freq.put("ykl", 11);
    freq.put("Les", 3);
    freq.put("ykt", 3);
    freq.put("plu", 13);
    freq.put("ply", 6);
    freq.put("Træ", 3);
    freq.put("ple", 57);
    freq.put("rnø", 6);
    freq.put("pla", 70);
    freq.put("plo", 9);
    freq.put("pli", 13);
    freq.put("obo", 3);
    freq.put("obl", 28);
    freq.put("yk ", 17);
    freq.put("obj", 3);
    freq.put("obi", 28);
    freq.put("obe", 9);
    freq.put("obb", 9);
    freq.put("obc", 3);
    freq.put("oba", 4);
    freq.put("obr", 3);
    freq.put("obs", 21);
    freq.put("øgn", 9);
    freq.put("øgl", 3);
    freq.put("Cup", 4);
    freq.put("øge", 47);
    freq.put("øgt", 7);
    freq.put("øgs", 3);
    freq.put("way", 6);
    freq.put("mt ", 65);
    freq.put("war", 12);
    freq.put(" X ", 4);
    freq.put(" nå", 119);
    freq.put("øg ", 13);
    freq.put(" næ", 73);
    freq.put(" nø", 27);
    freq.put("mti", 20);
    freq.put("mta", 6);
    freq.put("Odd", 3);
    freq.put("Ode", 5);
    freq.put("mte", 6);
    freq.put(" n ", 6);
    freq.put(" ni", 15);
    freq.put("kve", 11);
    freq.put(" no", 332);
    freq.put("kva", 17);
    freq.put(" na", 57);
    freq.put(" ne", 139);
    freq.put("kvi", 13);
    freq.put(" ny", 140);
    freq.put(" nr", 7);
    freq.put(" nu", 197);
    freq.put("Sk", 92);
    freq.put("ums", 5);
    freq.put("Sn", 14);
    freq.put("Sm", 19);
    freq.put(" Ø ", 5);
    freq.put("ume", 6);
    freq.put("gu ", 27);
    freq.put("yve", 10);
    freq.put(" Øk", 5);
    freq.put(" Øn", 3);
    freq.put("umm", 44);
    freq.put(" Øs", 7);
    freq.put(" Ør", 4);
    freq.put(" Øv", 3);
    freq.put("EO ", 5);
    freq.put("gue", 7);
    freq.put("gud", 11);
    freq.put("ekæ", 5);
    freq.put("gui", 9);
    freq.put("gul", 13);
    freq.put("gus", 9);
    freq.put("p", 3026);
    freq.put("yv ", 4);
    freq.put("ekø", 3);
    freq.put("hta", 3);
    freq.put("hti", 4);
    freq.put("OK ", 4);
    freq.put("htt", 6);
    freq.put("Får", 5);
    freq.put("ek ", 13);
    freq.put("Få ", 5);
    freq.put("ht ", 10);
    freq.put("eko", 13);
    freq.put("ekn", 8);
    freq.put("ekl", 15);
    freq.put("ekk", 9);
    freq.put("kyn", 5);
    freq.put("eke", 30);
    freq.put("eka", 8);
    freq.put("eky", 4);
    freq.put("ekv", 3);
    freq.put("eku", 11);
    freq.put("ekt", 64);
    freq.put("eks", 53);
    freq.put("ekr", 20);
    freq.put("spø", 33);
    freq.put("fbr", 5);
    freq.put("SB ", 8);
    freq.put("spæ", 21);
    freq.put(" Kb", 10);
    freq.put("kse", 17);
    freq.put(" Ka", 88);
    freq.put(" Ke", 17);
    freq.put(" Kj", 6);
    freq.put(" Kh", 4);
    freq.put(" Ki", 16);
    freq.put(" Kn", 6);
    freq.put(" Ko", 61);
    freq.put(" Kl", 21);
    freq.put(" Kr", 27);
    freq.put(" Kv", 6);
    freq.put(" Ku", 16);
    freq.put("ca ", 18);
    freq.put("Mon", 3);
    freq.put("F", 426);
    freq.put("Mol", 3);
    freq.put("Mob", 4);
    freq.put("kyb", 3);
    freq.put(" K ", 12);
    freq.put("cas", 9);
    freq.put("car", 6);
    freq.put("ibe", 23);
    freq.put("cat", 7);
    freq.put("iby", 13);
    freq.put("can", 6);
    freq.put("cam", 7);
    freq.put("ibs", 3);
    freq.put("caf", 3);
    freq.put("cad", 4);
    freq.put("spr", 28);
    freq.put("spu", 7);
    freq.put("spi", 114);
    freq.put("spl", 17);
    freq.put("spo", 34);
    freq.put("spa", 37);
    freq.put("spe", 46);
    freq.put(" Kæ", 13);
    freq.put("gh ", 4);
    freq.put(" Kø", 53);
    freq.put("Næh", 3);
    freq.put("Næs", 10);
    freq.put("ght", 9);
    freq.put("KO ", 3);
    freq.put("ghe", 51);
    freq.put("ER ", 22);
    freq.put("gha", 3);
    freq.put("ghj", 4);
    freq.put("Ru", 13);
    freq.put("Jay", 3);
    freq.put("eå", 3);
    freq.put("Chi", 4);
    freq.put("no ", 13);
    freq.put("Ry", 7);
    freq.put("Re", 61);
    freq.put("Chr", 23);
    freq.put("Jam", 7);
    freq.put("Ra", 24);
    freq.put("Ro", 29);
    freq.put("Ri", 20);
    freq.put("nol", 6);
    freq.put("nom", 13);
    freq.put("non", 10);
    freq.put("tje", 35);
    freq.put("nok", 84);
    freq.put("noe", 7);
    freq.put("rlæ", 5);
    freq.put("aer", 5);
    freq.put("R ", 76);
    freq.put("rlø", 4);
    freq.put("not", 8);
    freq.put("nov", 11);
    freq.put("Ja ", 54);
    freq.put("nos", 4);
    freq.put("h", 3670);
    freq.put("em", 592);
    freq.put("el", 1391);
    freq.put("eo", 62);
    freq.put("en", 4607);
    freq.put("ei", 45);
    freq.put("eh", 82);
    freq.put("ek", 263);
    freq.put("ej", 383);
    freq.put("ee", 184);
    freq.put("ed", 1801);
    freq.put("eg", 1320);
    freq.put("ef", 215);
    freq.put("Rø", 9);
    freq.put("rl ", 9);
    freq.put("ec", 47);
    freq.put("eb", 164);
    freq.put("Rå", 3);
    freq.put("Sø", 23);
    freq.put("ey", 36);
    freq.put("ex", 25);
    freq.put("ez", 5);
    freq.put("Aft", 4);
    freq.put("et", 3372);
    freq.put("ew", 25);
    freq.put("ev", 331);
    freq.put("ep", 103);
    freq.put("es", 1063);
    freq.put("er", 7424);
    freq.put("eT", 3);
    freq.put("rli", 102);
    freq.put("tjæ", 3);
    freq.put("rle", 15);
    freq.put("rld", 4);
    freq.put("lms", 6);
    freq.put("rla", 18);
    freq.put("e ", 7343);
    freq.put(" i ", 1148);
    freq.put("lmo", 3);
    freq.put("lma", 10);
    freq.put("lme", 25);
    freq.put("rls", 3);
    freq.put("gby", 6);
    freq.put("xi", 6);
    freq.put("xo", 4);
    freq.put("xc", 5);
    freq.put("xa", 4);
    freq.put("xe", 19);
    freq.put("xx", 6);
    freq.put("xt", 7);
    freq.put("Eur", 19);
    freq.put("kys", 5);
    freq.put("xD", 24);
    freq.put("Sæ", 23);
    freq.put("x ", 53);
    freq.put("ush", 8);
    freq.put("jæl", 61);
    freq.put("egr", 10);
    freq.put("jær", 8);
    freq.put("jæv", 3);
    freq.put("øyd", 5);
    freq.put("Phi", 5);
    freq.put("Pho", 16);
    freq.put("wca", 4);
    freq.put("Off", 5);
    freq.put("egl", 18);
    freq.put("mre", 14);
    freq.put("mra", 5);
    freq.put("Web", 3);
    freq.put("Wel", 6);
    freq.put("Wes", 9);
    freq.put(" p ", 10);
    freq.put(" ps", 12);
    freq.put(" pr", 184);
    freq.put(" pu", 20);
    freq.put(" pt", 5);
    freq.put(" py", 3);
    freq.put(" pc", 7);
    freq.put(" pa", 99);
    freq.put(" pg", 5);
    freq.put(" pe", 68);
    freq.put(" pi", 42);
    freq.put(" ph", 5);
    freq.put("Kræ", 3);
    freq.put(" pl", 62);
    freq.put("ytt", 27);
    freq.put("ffa", 4);
    freq.put("yti", 6);
    freq.put("Kri", 11);
    freq.put(" pæ", 8);
    freq.put(" på", 805);
    freq.put("Kra", 4);
    freq.put("EM ", 3);
    freq.put("vun", 4);
    freq.put("vur", 3);
    freq.put("jt ", 15);
    freq.put("yt ", 37);
    freq.put("hvi", 99);
    freq.put("hvo", 161);
    freq.put("hva", 103);
    freq.put("hve", 73);
    freq.put(" Må", 13);
    freq.put(" Mæ", 8);
    freq.put("ei ", 7);
    freq.put("Mås", 6);
    freq.put(" Mø", 7);
    freq.put("eis", 5);
    freq.put("eit", 4);
    freq.put("IL ", 4);
    freq.put("etu", 10);
    freq.put("eie", 3);
    freq.put("ågn", 4);
    freq.put("eil", 10);
    freq.put("åge", 11);
    freq.put("ein", 8);
    freq.put("æbe", 7);
    freq.put("rwe", 3);
    freq.put(" Me", 142);
    freq.put(" Ma", 118);
    freq.put(" Mo", 33);
    freq.put(" Mi", 97);
    freq.put(" Mu", 15);
    freq.put(" Mr", 3);
    freq.put(" My", 6);
    freq.put("yb", 14);
    freq.put("NS ", 4);
    freq.put("ete", 35);
    freq.put("etj", 6);
    freq.put("eth", 8);
    freq.put(" M ", 12);
    freq.put("ccu", 3);
    freq.put("etn", 11);
    freq.put("eto", 24);
    freq.put("cco", 5);
    freq.put("cce", 11);
    freq.put("am ", 74);
    freq.put("ps ", 39);
    freq.put("ch", 125);
    freq.put("Her", 31);
    freq.put("yv", 18);
    freq.put("lg ", 35);
    freq.put("ami", 16);
    freq.put("psk", 4);
    freq.put("amm", 146);
    freq.put("aml", 33);
    freq.put("amo", 3);
    freq.put("amn", 5);
    freq.put("ama", 24);
    freq.put("amb", 6);
    freq.put("ame", 79);
    freq.put("pse", 3);
    freq.put("psy", 8);
    freq.put("amp", 61);
    freq.put("ams", 8);
    freq.put("amr", 3);
    freq.put("amt", 32);
    freq.put("pst", 7);
    freq.put("psu", 4);
    freq.put("cy", 26);
    freq.put("gjo", 14);
    freq.put("t", 13498);
    freq.put("yng", 19);
    freq.put("cs", 10);
    freq.put("Heh", 13);
    freq.put("Mør", 3);
    freq.put("uci", 3);
    freq.put("ct", 25);
    freq.put("nme", 8);
    freq.put("nma", 80);
    freq.put("nmo", 4);
    freq.put("sre", 7);
    freq.put("sri", 5);
    freq.put("lob", 5);
    freq.put("loc", 4);
    freq.put("loa", 10);
    freq.put("lof", 4);
    freq.put("log", 73);
    freq.put("lod", 12);
    freq.put("lok", 34);
    freq.put("lon", 8);
    freq.put("loo", 5);
    freq.put("lol", 4);
    freq.put("lom", 11);
    freq.put("lor", 11);
    freq.put("Ålb", 3);
    freq.put("lop", 4);
    freq.put("lov", 31);
    freq.put("low", 17);
    freq.put("lot", 25);
    freq.put("lou", 5);
    freq.put("J", 452);
    freq.put("lo ", 11);
    freq.put("hø ", 4);
    freq.put("Brø", 11);
    freq.put("fsi", 3);
    freq.put("Mua", 4);
    freq.put("fsn", 4);
    freq.put("nbr", 3);
    freq.put("Lan", 7);
    freq.put("Lad", 9);
    freq.put("Lag", 3);
    freq.put("Lat", 3);
    freq.put("Wis", 3);
    freq.put("you", 7);
    freq.put("Lar", 20);
    freq.put("Las", 4);
    freq.put("lga", 3);
    freq.put("Bry", 6);
    freq.put("Bru", 3);
    freq.put("Bro", 4);
    freq.put("Bri", 6);
    freq.put("Bre", 6);
    freq.put("Bra", 11);
    freq.put("mp ", 32);
    freq.put("ysk", 25);
    freq.put("mpe", 60);
    freq.put("mpa", 8);
    freq.put("mpo", 18);
    freq.put("mpl", 12);
    freq.put(" rø", 37);
    freq.put("mpi", 3);
    freq.put(" rå", 20);
    freq.put(" ræ", 10);
    freq.put("mpr", 3);
    freq.put("En ", 52);
    freq.put(" r ", 10);
    freq.put("håp", 3);
    freq.put("hår", 20);
    freq.put("håb", 23);
    freq.put("hån", 36);
    freq.put(" ru", 28);
    freq.put(" ry", 26);
    freq.put(" re", 249);
    freq.put(" ra", 48);
    freq.put(" ro", 30);
    freq.put(" ri", 82);
    freq.put("yst", 40);
    freq.put("jre", 19);
    freq.put("put", 14);
    freq.put("jru", 5);
    freq.put("jrs", 3);
    freq.put("S ", 66);
    freq.put("pur", 5);
    freq.put("ræs", 19);
    freq.put("Sy", 27);
    freq.put("jr ", 27);
    freq.put("fø", 197);
    freq.put("Sp", 46);
    freq.put("Sw", 3);
    freq.put("Sv", 12);
    freq.put("Su", 31);
    freq.put("St", 119);
    freq.put("FC ", 17);
    freq.put("Sj", 7);
    freq.put("Si", 42);
    freq.put("Sh", 14);
    freq.put("So", 37);
    freq.put("få", 194);
    freq.put("fæ", 80);
    freq.put("Sl", 9);
    freq.put("Sc", 20);
    freq.put("fé", 4);
    freq.put("Sa", 42);
    freq.put("Se", 78);
    freq.put("egø", 9);
    freq.put("RE ", 3);
    freq.put("egå", 7);
    freq.put("f ", 502);
    freq.put("hha", 4);
    freq.put("hhh", 21);
    freq.put("OG ", 8);
    freq.put("eg ", 907);
    freq.put("fr", 400);
    freq.put("fs", 36);
    freq.put("ft", 302);
    freq.put("fu", 110);
    freq.put("fv", 8);
    freq.put("fy", 28);
    freq.put("fa", 306);
    freq.put("fb", 9);
    freq.put("hh ", 25);
    freq.put("fd", 4);
    freq.put("fe", 266);
    freq.put("ff", 106);
    freq.put("fg", 11);
    freq.put("fh", 9);
    freq.put("fi", 304);
    freq.put("fj", 20);
    freq.put("fl", 164);
    freq.put("fm", 4);
    freq.put("Så", 128);
    freq.put("fo", 1072);
    freq.put("a", 12251);
    freq.put("egy", 25);
    freq.put("egs", 3);
    freq.put("ået", 69);
    freq.put("åst", 6);
    freq.put("egu", 4);
    freq.put("egt", 3);
    freq.put("åel", 3);
    freq.put("egi", 16);
    freq.put("åen", 6);
    freq.put("ego", 13);
    freq.put("egn", 71);
    freq.put("ö", 16);
    freq.put("åed", 4);
    freq.put("ega", 30);
    freq.put("egg", 16);
    freq.put("ege", 179);
    freq.put("ce ", 56);
    freq.put("y ", 252);
    freq.put("ffs", 3);
    freq.put("uvi", 3);
    freq.put("ffi", 20);
    freq.put("ffe", 62);
    freq.put("uve", 7);
    freq.put("SF ", 8);
    freq.put(" On", 5);
    freq.put(" Ol", 9);
    freq.put(" Om", 5);
    freq.put(" Ok", 14);
    freq.put(" Oh", 4);
    freq.put(" Of", 5);
    freq.put(" Og", 80);
    freq.put(" Od", 9);
    freq.put(" Ob", 4);
    freq.put(" Oc", 4);
    freq.put("if ", 4);
    freq.put(" Ov", 11);
    freq.put(" Or", 8);
    freq.put(" Os", 6);
    freq.put(" Op", 17);
    freq.put("yi", 4);
    freq.put("yh", 24);
    freq.put("yk", 115);
    freq.put("ced", 3);
    freq.put("ym", 18);
    freq.put("ceb", 32);
    freq.put("yo", 12);
    freq.put("yn", 159);
    freq.put("ya", 11);
    freq.put("cen", 45);
    freq.put("yc", 5);
    freq.put("cel", 7);
    freq.put("ye", 106);
    freq.put("yd", 160);
    freq.put("yg", 108);
    freq.put("ces", 12);
    freq.put("cer", 42);
    freq.put("cep", 6);
    freq.put("yp", 17);
    freq.put("ys", 116);
    freq.put("yr", 69);
    freq.put("yt", 75);
    freq.put("ff ", 7);
    freq.put("ift", 36);
    freq.put("ify", 4);
    freq.put(" O ", 13);
    freq.put("ife", 5);
    freq.put("ifa", 6);
    freq.put("ifo", 3);
    freq.put("ifi", 11);
    freq.put("dig", 263);
    freq.put("End", 11);
    freq.put("Ene", 3);
    freq.put("Eng", 4);
    freq.put("Enh", 8);
    freq.put("Eni", 5);
    freq.put("as ", 49);
    freq.put("sån", 7);
    freq.put("ass", 74);
    freq.put("pun", 10);
    freq.put("asu", 3);
    freq.put("ast", 79);
    freq.put("pud", 6);
    freq.put("pub", 4);
    freq.put("asc", 4);
    freq.put("asf", 3);
    freq.put("ase", 17);
    freq.put("asd", 3);
    freq.put("ask", 29);
    freq.put("asj", 4);
    freq.put("asi", 17);
    freq.put("ash", 12);
    freq.put("aso", 5);
    freq.put("asm", 6);
    freq.put("pus", 6);
    freq.put(" F ", 6);
    freq.put("ifø", 3);
    freq.put("Cle", 6);
    freq.put("Cla", 14);
    freq.put("Imp", 3);
    freq.put("st ", 325);
    freq.put("dt ", 564);
    freq.put("ncy", 3);
    freq.put("tfo", 8);
    freq.put("tfi", 6);
    freq.put("tfa", 11);
    freq.put("nch", 13);
    freq.put("nci", 3);
    freq.put("rhå", 9);
    freq.put("nce", 63);
    freq.put("ste", 653);
    freq.put("stf", 4);
    freq.put("Kær", 11);
    freq.put("dtn", 8);
    freq.put("stb", 3);
    freq.put("stl", 11);
    freq.put("dtb", 4);
    freq.put("stn", 4);
    freq.put("sto", 114);
    freq.put("sth", 4);
    freq.put("sti", 179);
    freq.put("stj", 17);
    freq.put("stk", 5);
    freq.put("stu", 41);
    freq.put("stv", 3);
    freq.put("Nu ", 46);
    freq.put("str", 118);
    freq.put("sts", 3);
    freq.put("dts", 6);
    freq.put("dtr", 8);
    freq.put("sty", 35);
    freq.put("Goo", 27);
    freq.put("ka ", 32);
    freq.put("God", 61);
    freq.put("rh ", 12);
    freq.put("lid", 141);
    freq.put("Nik", 3);
    freq.put("lif", 8);
    freq.put("lig", 791);
    freq.put("Nin", 3);
    freq.put("lia", 12);
    freq.put("lib", 12);
    freq.put("lic", 9);
    freq.put("lil", 44);
    freq.put("Nic", 6);
    freq.put("lin", 142);
    freq.put("lio", 8);
    freq.put("lii", 5);
    freq.put("Nie", 6);
    freq.put("lit", 66);
    freq.put("liv", 190);
    freq.put("lip", 19);
    freq.put("lir", 16);
    freq.put("lis", 57);
    freq.put("Nis", 4);
    freq.put("kab", 49);
    freq.put("kag", 14);
    freq.put("kaf", 36);
    freq.put("kad", 16);
    freq.put("rhu", 28);
    freq.put("kan", 337);
    freq.put("kam", 70);
    freq.put("kal", 304);
    freq.put("Tho", 25);
    freq.put("kar", 20);
    freq.put("kap", 6);
    freq.put("kav", 4);
    freq.put("rho", 19);
    freq.put("kat", 32);
    freq.put("rha", 12);
    freq.put("kay", 18);
    freq.put("rhe", 12);
    freq.put("stå", 69);
    freq.put("stæ", 31);
    freq.put("li ", 25);
    freq.put("stø", 54);
    freq.put("gæs", 9);
    freq.put("så ", 568);
    freq.put("gæt", 3);
    freq.put("gæl", 14);
    freq.put("ymp", 4);
    freq.put("ymr", 4);
    freq.put("ox ", 7);
    freq.put("dti", 10);
    freq.put("sta", 180);
    freq.put("oxe", 4);
    freq.put("dta", 17);
    freq.put("ydn", 5);
    freq.put("dte", 44);
    freq.put("Ø ", 6);
    freq.put("dær", 3);
    freq.put("dæl", 4);
    freq.put("Ple", 4);
    freq.put("dæk", 13);
    freq.put("Mo", 35);
    freq.put("ydb", 3);
    freq.put("Øk", 5);
    freq.put("Øn", 3);
    freq.put("Ør", 4);
    freq.put("Øs", 7);
    freq.put("Øv", 3);
    freq.put("Way", 4);
    freq.put(" t ", 12);
    freq.put("eså", 3);
    freq.put(" ty", 29);
    freq.put(" tw", 50);
    freq.put(" tv", 35);
    freq.put(" tu", 31);
    freq.put(" tr", 239);
    freq.put("N", 375);
    freq.put(" to", 146);
    freq.put(" tj", 14);
    freq.put(" ti", 1012);
    freq.put(" th", 24);
    freq.put(" te", 91);
    freq.put(" ta", 186);
    freq.put("gså", 150);
    freq.put("Kva", 4);
    freq.put("gs ", 33);
    freq.put("ohn", 4);
    freq.put(" tø", 27);
    freq.put(" tæ", 79);
    freq.put("FA ", 3);
    freq.put("gsp", 11);
    freq.put("gsr", 3);
    freq.put("gst", 20);
    freq.put("gsa", 3);
    freq.put("gsb", 5);
    freq.put("gse", 5);
    freq.put("gsd", 4);
    freq.put("gsf", 9);
    freq.put("gsh", 3);
    freq.put("gsk", 19);
    freq.put("gsm", 17);
    freq.put("gsl", 4);
    freq.put("gso", 11);
    freq.put("hju", 6);
    freq.put("hje", 84);
    freq.put("lik", 35);
    freq.put("oo ", 5);
    freq.put("ee ", 7);
    freq.put("eet", 46);
    freq.put("eep", 12);
    freq.put("ees", 3);
    freq.put("eer", 9);
    freq.put("eel", 10);
    freq.put("een", 20);
    freq.put("eek", 26);
    freq.put("eej", 4);
    freq.put("eee", 23);
    freq.put("eed", 10);
    freq.put("ru ", 3);
    freq.put("æft", 22);
    freq.put("hjæ", 35);
    freq.put(" Qv", 3);
    freq.put("id ", 99);
    freq.put("ruk", 9);
    freq.put("run", 37);
    freq.put("rul", 6);
    freq.put("rum", 24);
    freq.put("rug", 98);
    freq.put("rud", 31);
    freq.put("rue", 14);
    freq.put("rus", 14);
    freq.put("rup", 27);
    freq.put("rhv", 9);
    freq.put("rut", 4);
    freq.put("kas", 24);
    freq.put("idt", 168);
    freq.put("idr", 9);
    freq.put("ids", 58);
    freq.put("ido", 4);
    freq.put("idl", 40);
    freq.put("rhj", 5);
    freq.put("idi", 16);
    freq.put("idd", 42);
    freq.put("ide", 277);
    freq.put("ida", 30);
    freq.put("Eli", 3);
    freq.put("Ell", 27);
    freq.put("Ele", 6);
    freq.put("Tæ", 8);
    freq.put("Els", 9);
    freq.put("The", 20);
    freq.put("ut ", 30);
    freq.put(" æ ", 7);
    freq.put("løv", 7);
    freq.put("løs", 40);
    freq.put("lør", 30);
    freq.put("Nør", 4);
    freq.put("løg", 3);
    freq.put("løf", 4);
    freq.put("lød", 4);
    freq.put("løb", 27);
    freq.put("løn", 4);
    freq.put("løj", 17);
    freq.put(" ær", 10);
    freq.put("öl", 3);
    freq.put("ute", 19);
    freq.put("svæ", 39);
    freq.put("uti", 15);
    freq.put("utn", 8);
    freq.put("uto", 10);
    freq.put("utr", 4);
    freq.put("uts", 4);
    freq.put(" æb", 5);
    freq.put(" æd", 6);
    freq.put("utt", 34);
    freq.put("utu", 5);
    freq.put(" æl", 6);
    freq.put(" æn", 8);
    freq.put("ood", 15);
    freq.put("Tv", 3);
    freq.put("Tw", 26);
    freq.put("Tu", 20);
    freq.put("Tr", 67);
    freq.put("To", 41);
    freq.put("Tj", 5);
    freq.put("Th", 53);
    freq.put("Ti", 39);
    freq.put("Te", 23);
    freq.put("Ta", 75);
    freq.put("A ", 85);
    freq.put("nag", 15);
    freq.put("nad", 4);
    freq.put("nak", 29);
    freq.put("nan", 18);
    freq.put("nal", 57);
    freq.put("nam", 3);
    freq.put("nar", 27);
    freq.put("nas", 9);
    freq.put("nap", 8);
    freq.put("nav", 20);
    freq.put("nat", 53);
    freq.put("naz", 4);
    freq.put("oon", 3);
    freq.put("Beg", 6);
    freq.put("ook", 46);
    freq.put("T ", 106);
    freq.put("Aa", 30);
    freq.put("na ", 32);
    freq.put("dvi", 25);
    freq.put("Ad", 6);
    freq.put("Ag", 4);
    freq.put("svi", 17);
    freq.put("dve", 13);
    freq.put("Ah", 11);
    freq.put("Ak", 13);
    freq.put("sve", 9);
    freq.put("Am", 23);
    freq.put("Al", 59);
    freq.put("An", 37);
    freq.put("Ap", 15);
    freq.put("As", 8);
    freq.put("Ar", 29);
    freq.put("Au", 7);
    freq.put("At", 11);
    freq.put("Aw", 6);
    freq.put("Giv", 4);
    freq.put("gu", 85);
    freq.put("gt", 478);
    freq.put("gs", 308);
    freq.put("gr", 209);
    freq.put("gp", 8);
    freq.put("gy", 29);
    freq.put("gg", 152);
    freq.put("gf", 9);
    freq.put("ge", 2495);
    freq.put("gd", 40);
    freq.put("gb", 17);
    freq.put("ga", 309);
    freq.put("go", 339);
    freq.put("gn", 149);
    freq.put("gm", 12);
    freq.put("gl", 239);
    freq.put("gk", 14);
    freq.put("gj", 14);
    freq.put("gi", 181);
    freq.put("gh", 78);
    freq.put("lkn", 3);
    freq.put("lko", 11);
    freq.put("Tje", 3);
    freq.put("Nog", 26);
    freq.put("Bet", 7);
    freq.put("Nov", 7);
    freq.put("lkr", 3);
    freq.put("Nor", 35);
    freq.put(" ", 4);
    freq.put("g ", 3795);
    freq.put("hi ", 3);
    freq.put("Spr", 3);
    freq.put("No ", 4);
    freq.put("lk ", 37);
    freq.put("Spi", 11);
    freq.put("Spo", 8);
    freq.put("Spa", 8);
    freq.put("Spe", 6);
    freq.put("zl", 3);
    freq.put("zn", 6);
    freq.put("zo", 8);
    freq.put("zi", 6);
    freq.put("ulv", 6);
    freq.put("za", 7);
    freq.put("gø", 102);
    freq.put("gæ", 29);
    freq.put("gå", 126);
    freq.put("zy", 3);
    freq.put("zz", 5);
    freq.put("æng", 62);
    freq.put("uli", 30);
    freq.put("ull", 65);
    freq.put("ozn", 5);
    freq.put("z ", 19);
    freq.put("Aha", 3);
    freq.put("ænk", 60);
    freq.put("Ahh", 4);
    freq.put("uld", 51);
    freq.put("Spæ", 7);
    freq.put("wif", 4);
    freq.put("wie", 3);
    freq.put("wic", 5);
    freq.put("win", 5);
    freq.put("wik", 3);
    freq.put("wit", 38);
    freq.put(" vå", 12);
    freq.put(" væ", 299);
    freq.put("rår", 10);
    freq.put("rål", 3);
    freq.put("råb", 10);
    freq.put("råd", 36);
    freq.put("ied", 4);
    freq.put("hit", 18);
    freq.put(" va", 297);
    freq.put(" ve", 330);
    freq.put(" vi", 676);
    freq.put(" vl", 4);
    freq.put(" vo", 52);
    freq.put(" vu", 4);
    freq.put(" v ", 5);
    freq.put("lå ", 13);
    freq.put("yrt", 6);
    freq.put("jne", 7);
    freq.put("låe", 4);
    freq.put("låg", 4);
    freq.put("sæt", 53);
    freq.put("sær", 16);
    freq.put("sæs", 4);
    freq.put("lån", 14);
    freq.put("lår", 5);
    freq.put("låt", 5);
    freq.put("sæk", 5);
    freq.put("EG ", 4);
    freq.put("mar", 147);
    freq.put("hli", 3);
    freq.put("Ær", 3);
    freq.put("mav", 3);
    freq.put("ece", 3);
    freq.put("ecc", 3);
    freq.put("pæd", 4);
    freq.put("CE ", 4);
    freq.put("pæi", 6);
    freq.put("eck", 6);
    freq.put("eci", 14);
    freq.put("pæn", 28);
    freq.put("pær", 3);
    freq.put("ecs", 3);
    freq.put("x", 147);
    freq.put("hl ", 4);
    freq.put("Æ ", 7);
    freq.put("snu", 4);
    freq.put("IF ", 4);
    freq.put("rs ", 124);
    freq.put("rtæ", 22);
    freq.put(" Sy", 27);
    freq.put("be ", 46);
    freq.put(" Sv", 12);
    freq.put(" Sw", 3);
    freq.put(" St", 118);
    freq.put(" Su", 30);
    freq.put(" Sj", 7);
    freq.put(" Sk", 92);
    freq.put(" Sh", 13);
    freq.put(" Si", 41);
    freq.put(" Sn", 14);
    freq.put(" So", 37);
    freq.put(" Sl", 9);
    freq.put(" Sm", 19);
    freq.put(" Sc", 19);
    freq.put(" Sa", 41);
    freq.put(" Se", 78);
    freq.put("rsl", 11);
    freq.put("rsm", 5);
    freq.put("rso", 34);
    freq.put("rsi", 24);
    freq.put("rsk", 58);
    freq.put("rsd", 24);
    freq.put("rse", 45);
    freq.put("rsf", 8);
    freq.put("rsa", 8);
    freq.put("AS ", 4);
    freq.put("rsy", 4);
    freq.put("rst", 156);
    freq.put("rsv", 11);
    freq.put("rsp", 5);
    freq.put("rsr", 3);
    freq.put("bej", 57);
    freq.put("bek", 21);
    freq.put("beh", 25);
    freq.put("ben", 80);
    freq.put("bel", 22);
    freq.put("bem", 4);
    freq.put("bec", 4);
    freq.put("bea", 6);
    freq.put("bef", 15);
    freq.put("beg", 43);
    freq.put("bed", 93);
    freq.put("bee", 3);
    freq.put("ber", 171);
    freq.put("bes", 67);
    freq.put(" S ", 18);
    freq.put("bev", 17);
    freq.put("bet", 60);
    freq.put("sv", 121);
    freq.put("aw ", 3);
    freq.put(" Sø", 23);
    freq.put("ur ", 63);
    freq.put("uu ", 4);
    freq.put(" Sæ", 23);
    freq.put(" Så", 128);
    freq.put("rsæ", 8);
    freq.put("Ej ", 14);
    freq.put("rsø", 14);
    freq.put("Åh ", 9);
    freq.put("Jø", 3);
    freq.put("awe", 9);
    freq.put("urd", 39);
    freq.put("ure", 40);
    freq.put("urf", 4);
    freq.put("urg", 8);
    freq.put("æde", 67);
    freq.put("ura", 16);
    freq.put("urb", 4);
    freq.put("Hva", 47);
    freq.put("flå", 3);
    freq.put("urn", 12);
    freq.put("uro", 30);
    freq.put("Hve", 15);
    freq.put("uri", 9);
    freq.put("fje", 16);
    freq.put("urt", 20);
    freq.put("æds", 3);
    freq.put("ædt", 4);
    freq.put("urr", 12);
    freq.put("urs", 18);
    freq.put("Del", 9);
    freq.put("Ian", 3);
    freq.put("Den", 86);
    freq.put("wor", 14);
    freq.put("ngd", 9);
    freq.put("nge", 452);
    freq.put("ngf", 4);
    freq.put("nga", 20);
    freq.put("ngb", 12);
    freq.put("ngl", 37);
    freq.put("ngi", 5);
    freq.put("sh ", 9);
    freq.put("ngr", 18);
    freq.put("ngs", 71);
    freq.put("mga", 6);
    freq.put("Pla", 6);
    freq.put("tba", 5);
    freq.put("ng ", 524);
    freq.put("shu", 3);
    freq.put("sha", 3);
    freq.put("she", 8);
    freq.put("shi", 11);
    freq.put("shj", 3);
    freq.put("dpi", 5);
    freq.put("sho", 26);
    freq.put("ke ", 921);
    freq.put("lup", 10);
    freq.put("ngæ", 5);
    freq.put("lus", 14);
    freq.put("lut", 34);
    freq.put("lub", 16);
    freq.put("lud", 15);
    freq.put("lue", 5);
    freq.put("luf", 7);
    freq.put("lug", 7);
    freq.put("luk", 18);
    freq.put("ngø", 3);
    freq.put("lum", 3);
    freq.put("lun", 10);
    freq.put("ken", 162);
    freq.put("kel", 115);
    freq.put("kek", 5);
    freq.put("keh", 5);
    freq.put("ked", 76);
    freq.put("keb", 13);
    freq.put("key", 4);
    freq.put("kev", 5);
    freq.put("ket", 93);
    freq.put("kes", 29);
    freq.put("ker", 366);
    freq.put("kep", 9);
    freq.put("lu ", 4);
    freq.put("ot ", 35);
    freq.put("Lon", 12);
    freq.put("Lol", 9);
    freq.put("Lor", 3);
    freq.put("Lov", 6);
    freq.put("oth", 7);
    freq.put("oti", 14);
    freq.put("otl", 3);
    freq.put("oto", 11);
    freq.put("ota", 10);
    freq.put("ote", 24);
    freq.put("ots", 3);
    freq.put("ott", 11);
    freq.put(" År", 16);
    freq.put("And", 21);
    freq.put("Ann", 5);
    freq.put("inn", 13);
    freq.put("ya ", 4);
    freq.put("You", 13);
    freq.put(" Åå", 3);
    freq.put("Tæn", 7);
    freq.put("i", 12270);
    freq.put("ksh", 4);
    freq.put(" xD", 24);
    freq.put("oræ", 7);
    freq.put("Hæ ", 9);
    freq.put(" ød", 5);
    freq.put("Be", 83);
    freq.put("Ba", 60);
    freq.put("Bl", 36);
    freq.put("Bo", 37);
    freq.put("Bi", 26);
    freq.put("Bj", 6);
    freq.put("Bu", 20);
    freq.put(" xx", 4);
    freq.put("Br", 49);
    freq.put("By", 8);
    freq.put(" a ", 8);
    freq.put("Hæh", 5);
    freq.put("B ", 61);
    freq.put(" x ", 19);
    freq.put("jle", 7);
    freq.put("jli", 36);
    freq.put("U ", 21);
    freq.put("Går", 7);
    freq.put("Bø", 9);
    freq.put("RO ", 3);
    freq.put("Ul", 3);
    freq.put("Un", 30);
    freq.put("Uh", 10);
    freq.put("Ud", 12);
    freq.put("Uf", 6);
    freq.put("duc", 6);
    freq.put("ea ", 8);
    freq.put("h ", 181);
    freq.put("eah", 4);
    freq.put("eak", 10);
    freq.put("hy", 32);
    freq.put("eam", 11);
    freq.put("eal", 18);
    freq.put("ean", 8);
    freq.put("hr", 30);
    freq.put("hs", 3);
    freq.put("eac", 3);
    freq.put("hv", 438);
    freq.put("ead", 17);
    freq.put("eag", 11);
    freq.put("eaf", 3);
    freq.put("hj", 130);
    freq.put("hh", 53);
    freq.put("hi", 116);
    freq.put("hn", 6);
    freq.put("ho", 328);
    freq.put("hl", 9);
    freq.put("hm", 20);
    freq.put("eas", 9);
    freq.put("ear", 10);
    freq.put("eau", 4);
    freq.put("ph", 31);
    freq.put("he", 657);
    freq.put("dma", 4);
    freq.put("dus", 7);
    freq.put("dme", 7);
    freq.put("dmi", 5);
    freq.put("dmo", 10);
    freq.put("ID ", 4);
    freq.put("Os", 6);
    freq.put("hn ", 4);
    freq.put("eor", 5);
    freq.put(" Ul", 3);
    freq.put(" Un", 29);
    freq.put(" Uh", 10);
    freq.put("Lun", 4);
    freq.put(" Ud", 12);
    freq.put(" Uf", 6);
    freq.put("hø", 122);
    freq.put("nup", 4);
    freq.put("hæ", 41);
    freq.put("hå", 90);
    freq.put("bce", 3);
    freq.put(" U ", 5);
    freq.put("MS ", 6);
    freq.put("aud", 4);
    freq.put("aug", 12);
    freq.put("aul", 4);
    freq.put("up ", 34);
    freq.put("aus", 23);
    freq.put("aur", 8);
    freq.put("aut", 6);
    freq.put("Joh", 9);
    freq.put("drø", 10);
    freq.put("fho", 4);
    freq.put("fhe", 3);
    freq.put("upd", 3);
    freq.put("upe", 35);
    freq.put("upa", 3);
    freq.put("sjæ", 17);
    freq.put("ups", 5);
    freq.put("upp", 21);
    freq.put("dræ", 8);
    freq.put("me ", 204);
    freq.put("nen", 76);
    freq.put("neo", 3);
    freq.put("nel", 18);
    freq.put("nem", 47);
    freq.put("nej", 25);
    freq.put("neh", 4);
    freq.put("nei", 5);
    freq.put("nef", 8);
    freq.put("neg", 6);
    freq.put("ned", 92);
    freq.put("neb", 11);
    freq.put("nea", 6);
    freq.put("ney", 10);
    freq.put("Put", 4);
    freq.put("new", 3);
    freq.put("net", 88);
    freq.put("ner", 261);
    freq.put("nes", 152);
    freq.put("nep", 3);
    freq.put("mee", 4);
    freq.put("med", 642);
    freq.put("meg", 105);
    freq.put("meb", 7);
    freq.put("mel", 98);
    freq.put("men", 437);
    freq.put("met", 60);
    freq.put("mes", 71);
    freq.put("mer", 342);
    freq.put("dry", 4);
    freq.put("dru", 4);
    freq.put("ne ", 561);
    freq.put("dri", 79);
    freq.put("sjo", 19);
    freq.put("dro", 12);
    freq.put("dra", 17);
    freq.put("sja", 5);
    freq.put("dre", 191);
    freq.put("St ", 4);
    freq.put("Ste", 22);
    freq.put("Sta", 32);
    freq.put("Sto", 22);
    freq.put("Sti", 7);
    freq.put("Stu", 8);
    freq.put("ovæ", 3);
    freq.put("Str", 9);
    freq.put("V", 311);
    freq.put("Sty", 4);
    freq.put("Til", 21);
    freq.put("rio", 12);
    freq.put("Tin", 4);
    freq.put("vfø", 8);
    freq.put("ygg", 44);
    freq.put("yge", 24);
    freq.put("Lig", 14);
    freq.put("Lib", 7);
    freq.put("Lil", 7);
    freq.put("ygn", 5);
    freq.put("Lin", 6);
    freq.put("Tid", 5);
    freq.put("ov ", 32);
    freq.put("ygt", 17);
    freq.put("Kaf", 3);
    freq.put("Kan", 52);
    freq.put("Kam", 5);
    freq.put("Kar", 8);
    freq.put("Kat", 8);
    freq.put("ovr", 11);
    freq.put("ovs", 8);
    freq.put("ovt", 8);
    freq.put("yg ", 10);
    freq.put("ova", 4);
    freq.put("ove", 278);
    freq.put("ovi", 4);
    freq.put("Stø", 4);
    freq.put("ovo", 6);
    freq.put("ovl", 6);
    freq.put("All", 16);
    freq.put("Ali", 3);
    freq.put("Ald", 4);
    freq.put("Ale", 4);
    freq.put("Alb", 3);
    freq.put("Alt", 19);
    freq.put("Woz", 5);
    freq.put("Wow", 10);
    freq.put("Wor", 12);
    freq.put("Woo", 3);
    freq.put("SS ", 4);
    freq.put("øs ", 15);
    freq.put("is ", 227);
    freq.put("øss", 6);
    freq.put("øst", 32);
    freq.put("iss", 25);
    freq.put("isp", 3);
    freq.put("isu", 7);
    freq.put("ist", 217);
    freq.put("isk", 199);
    freq.put("isi", 13);
    freq.put("ish", 4);
    freq.put("isn", 13);
    freq.put("ism", 7);
    freq.put("isl", 4);
    freq.put("isc", 5);
    freq.put("isa", 4);
    freq.put("øsn", 14);
    freq.put("isf", 3);
    freq.put("ise", 91);
    freq.put(" tå", 5);
    freq.put("ød ", 63);
    freq.put("gyn", 24);
    freq.put("gym", 3);
    freq.put("På ", 19);
    freq.put("ty ", 19);
    freq.put("fgø", 3);
    freq.put("do ", 7);
    freq.put("tyl", 6);
    freq.put("tyn", 4);
    freq.put("tyk", 8);
    freq.put("tyd", 21);
    freq.put("tyv", 3);
    freq.put("typ", 8);
    freq.put("tyr", 30);
    freq.put("tys", 11);
    freq.put("dok", 4);
    freq.put("don", 16);
    freq.put("dol", 3);
    freq.put("dom", 34);
    freq.put("dob", 6);
    freq.put("doc", 5);
    freq.put("m", 6490);
    freq.put("dog", 33);
    freq.put("dor", 6);
    freq.put("dos", 4);
    freq.put("dop", 3);
    freq.put("dov", 12);
    freq.put("dow", 5);
    freq.put(" We", 22);
    freq.put(" Wa", 12);
    freq.put(" Wo", 34);
    freq.put(" Wi", 21);
    freq.put("kul", 57);
    freq.put("omæ", 5);
    freq.put(" W ", 3);
    freq.put("bat", 13);
    freq.put("bar", 202);
    freq.put("bas", 5);
    freq.put("æhæ", 11);
    freq.put("bag", 54);
    freq.put("bad", 14);
    freq.put("bab", 9);
    freq.put("bac", 16);
    freq.put("ban", 39);
    freq.put("bal", 15);
    freq.put("bam", 3);
    freq.put("bak", 13);
    freq.put("om ", 568);
    freq.put("Eft", 13);
    freq.put("øde", 76);
    freq.put("æh ", 3);
    freq.put("un ", 118);
    freq.put("Så ", 108);
    freq.put("Rus", 5);
    freq.put("omb", 8);
    freq.put("C", 205);
    freq.put("omg", 6);
    freq.put("ome", 36);
    freq.put("omk", 13);
    freq.put("omi", 19);
    freq.put("omh", 7);
    freq.put("omo", 5);
    freq.put("omm", 204);
    freq.put("oml", 3);
    freq.put("oms", 25);
    freq.put("omr", 6);
    freq.put("omp", 22);
    freq.put("omv", 4);
    freq.put("omt", 15);
    freq.put("Ø", 33);
    freq.put("uns", 9);
    freq.put("unt", 6);
    freq.put("omO", 4);
    freq.put("Hje", 3);
    freq.put("una", 4);
    freq.put("unc", 3);
    freq.put("und", 222);
    freq.put("une", 24);
    freq.put("unf", 5);
    freq.put("ung", 50);
    freq.put("uni", 14);
    freq.put("unk", 25);
    freq.put("unn", 55);
    freq.put("iø", 19);
    freq.put("C ", 49);
    freq.put("hør", 64);
    freq.put("Ci", 13);
    freq.put("Ch", 36);
    freq.put("Co", 39);
    freq.put("Væ", 5);
    freq.put("Cl", 22);
    freq.put("slu", 29);
    freq.put("Ca", 30);
    freq.put("Ce", 8);
    freq.put("Cy", 7);
    freq.put("slo", 16);
    freq.put("sli", 20);
    freq.put("sle", 38);
    freq.put("sla", 40);
    freq.put("Cu", 11);
    freq.put("ix", 14);
    freq.put("iz", 17);
    freq.put("ip", 68);
    freq.put("is", 831);
    freq.put("ir", 222);
    freq.put("iu", 10);
    freq.put("it", 471);
    freq.put("iv", 455);
    freq.put("ii", 27);
    freq.put("Nas", 4);
    freq.put("Nap", 3);
    freq.put("im", 180);
    freq.put("il", 1730);
    freq.put("Nat", 11);
    freq.put("in", 1854);
    freq.put("ia", 189);
    freq.put("ic", 132);
    freq.put("ib", 46);
    freq.put("ie", 299);
    freq.put("id", 758);
    freq.put("ig", 2004);
    freq.put("if", 79);
    freq.put("V ", 40);
    freq.put("iP", 23);
    freq.put("iT", 5);
    freq.put("iM", 4);
    freq.put("kis", 5);
    freq.put("kir", 4);
    freq.put("Sve", 10);
    freq.put("kiv", 5);
    freq.put("kit", 10);
    freq.put("kin", 36);
    freq.put("kil", 13);
    freq.put("kib", 3);
    freq.put("kig", 22);
    freq.put("kif", 12);
    freq.put("kie", 4);
    freq.put("kid", 14);
    freq.put("Va", 30);
    freq.put("slø", 12);
    freq.put("Ve", 73);
    freq.put("Vi", 149);
    freq.put("Vo", 12);
    freq.put("Vu", 3);
    freq.put("slå", 14);
    freq.put("slæ", 3);
    freq.put("nk ", 34);
    freq.put("yen", 20);
    freq.put("yea", 4);
    freq.put("op ", 118);
    freq.put("yes", 4);
    freq.put("yer", 8);
    freq.put("yet", 6);
    freq.put("vd ", 4);
    freq.put("opt", 17);
    freq.put("opu", 4);
    freq.put("opp", 42);
    freq.put("opr", 7);
    freq.put("ops", 17);
    freq.put("ye ", 63);
    freq.put("opd", 20);
    freq.put("ope", 22);
    freq.put("opf", 11);
    freq.put("opg", 11);
    freq.put("opa", 9);
    freq.put("opb", 6);
    freq.put("opc", 3);
    freq.put("opl", 37);
    freq.put("opm", 5);
    freq.put("oph", 10);
    freq.put("opi", 5);
    freq.put("Ars", 7);
    freq.put("Art", 4);
    freq.put("Arb", 4);
    freq.put("vde", 55);
    freq.put("Arh", 4);
    freq.put("Arl", 4);
    freq.put("www", 9);
    freq.put("OR ", 6);
    freq.put("idé", 7);
    freq.put("opæ", 7);
    freq.put("ww ", 12);
    freq.put("Å", 41);
    freq.put("TE ", 3);
    freq.put("Z", 16);
    freq.put("Sød", 3);
    freq.put("Win", 3);
    freq.put("Wil", 4);
    freq.put("fsl", 8);
    freq.put("Søn", 9);
    freq.put("fsp", 3);
    freq.put("fst", 11);
    freq.put("Læs", 15);
    freq.put("Lær", 9);
    freq.put("Wiz", 3);
    freq.put("Grø", 3);
    freq.put("Græ", 7);
    freq.put("di ", 40);
    freq.put("dil", 5);
    freq.put("din", 129);
    freq.put("dio", 17);
    freq.put("dik", 13);
    freq.put("did", 7);
    freq.put("die", 32);
    freq.put("ers", 201);
    freq.put("dia", 17);
    freq.put("dic", 7);
    freq.put("dit", 43);
    freq.put("diu", 3);
    freq.put("div", 5);
    freq.put("dir", 13);
    freq.put("dis", 24);
    freq.put(" Yo", 16);
    freq.put(" Ya", 8);
    freq.put(" Ye", 7);
    freq.put("Gre", 3);
    freq.put("Gra", 7);
    freq.put("Gro", 3);
    freq.put("Gri", 6);
    freq.put("tne", 17);
    freq.put("bo ", 7);
    freq.put("øøø", 13);
    freq.put("box", 5);
    freq.put("boy", 4);
    freq.put("tni", 33);
    freq.put("bor", 61);
    freq.put("bot", 3);
    freq.put("HA ", 10);
    freq.put("bok", 5);
    freq.put("bol", 30);
    freq.put("bom", 3);
    freq.put("bon", 3);
    freq.put("boo", 36);
    freq.put("boa", 5);
    freq.put("bod", 5);
    freq.put("boe", 11);
    freq.put("bog", 19);
    freq.put("ål", 57);
    freq.put("ån", 91);
    freq.put("åh", 10);
    freq.put("åk", 7);
    freq.put("åe", 84);
    freq.put("åd", 135);
    freq.put("åg", 19);
    freq.put("åb", 85);
    freq.put("åt", 12);
    freq.put("åv", 3);
    freq.put("åp", 4);
    freq.put("ås", 50);
    freq.put("år", 533);
    freq.put("ayn", 6);
    freq.put("aye", 3);
    freq.put("ul ", 15);
    freq.put("ays", 3);
    freq.put("Bek", 8);
    freq.put("oog", 29);
    freq.put("oof", 5);
    freq.put("Ben", 13);
    freq.put("oom", 6);
    freq.put("ool", 11);
    freq.put("ooo", 24);
    freq.put("Bea", 3);
    freq.put("å ", 1738);
    freq.put("Bed", 6);
    freq.put("oop", 3);
    freq.put("oor", 3);
    freq.put("Ber", 28);
    freq.put("Bes", 4);
    freq.put("snø", 3);
    freq.put("fly", 30);
    freq.put("ænt", 7);
    freq.put("æns", 10);
    freq.put("flu", 4);
    freq.put("ay ", 37);
    freq.put("ult", 25);
    freq.put("ulu", 4);
    freq.put("fli", 8);
    freq.put("æne", 23);
    freq.put("ænd", 79);
    freq.put("ulo", 4);
    freq.put("flo", 20);
    freq.put("fla", 14);
    freq.put("ænn", 4);
    freq.put("ula", 5);
    freq.put("fle", 65);
    freq.put("ulg", 5);
    freq.put("æni", 6);
    freq.put("ule", 38);
    freq.put("åå", 12);
    freq.put("ma ", 24);
    freq.put("ljø", 6);
    freq.put("nyt", 26);
    freq.put("nyh", 15);
    freq.put("nyl", 3);
    freq.put("nyd", 12);
    freq.put("nye", 62);
    freq.put("mas", 33);
    freq.put("sne", 18);
    freq.put("mat", 43);
    freq.put("sna", 42);
    freq.put("max", 5);
    freq.put("maz", 4);
    freq.put("sni", 45);
    freq.put("mac", 3);
    freq.put("åli", 4);
    freq.put("mae", 7);
    freq.put("mad", 28);
    freq.put("mag", 47);
    freq.put("mai", 13);
    freq.put("mak", 7);
    freq.put("maj", 3);
    freq.put("mal", 21);
    freq.put("man", 323);
    freq.put("flø", 9);
    freq.put("åll", 5);
    freq.put("zni", 5);
    freq.put("ålm", 4);
    freq.put("q", 17);
    freq.put("ny ", 37);
    freq.put("ulæ", 6);
    freq.put("flæ", 9);
    freq.put("lsd", 9);
    freq.put("lse", 168);
    freq.put("lsb", 3);
    freq.put("lsa", 4);
    freq.put("lso", 5);
    freq.put("lsl", 3);
    freq.put("lsk", 77);
    freq.put("lsi", 10);
    freq.put("lsv", 3);
    freq.put("lst", 20);
    freq.put("lsp", 4);
    freq.put("åle", 10);
    freq.put("kk ", 16);
    freq.put(" aa", 4);
    freq.put(" ab", 10);
    freq.put(" ac", 8);
    freq.put(" ad", 18);
    freq.put("øj ", 28);
    freq.put(" af", 542);
    freq.put(" ag", 9);
    freq.put(" ah", 4);
    freq.put(" ak", 34);
    freq.put(" al", 306);
    freq.put(" am", 13);
    freq.put(" an", 184);
    freq.put(" ap", 12);
    freq.put(" ar", 73);
    freq.put(" as", 17);
    freq.put(" at", 789);
    freq.put(" au", 15);
    freq.put(" av", 5);
    freq.put(" aw", 12);
    freq.put("ls ", 25);
    freq.put("kku", 4);
    freq.put("Sha", 3);
    freq.put("åls", 3);
    freq.put("kke", 877);
    freq.put("Shi", 4);
    freq.put("orå", 3);
    freq.put("Sho", 6);
    freq.put("øje", 59);
    freq.put("øjd", 4);
    freq.put("øjn", 5);
    freq.put("øjt", 13);
    freq.put("øjs", 3);
    freq.put("øjr", 7);
    freq.put("Luk", 7);
    freq.put("or ", 851);
    freq.put("Ken", 7);
    freq.put("Key", 3);
    freq.put("Ker", 5);
    freq.put("RT ", 47);
    freq.put("G", 307);
    freq.put("orv", 14);
    freq.put("orw", 3);
    freq.put("ort", 143);
    freq.put("oru", 12);
    freq.put("orr", 30);
    freq.put("ors", 132);
    freq.put("orp", 7);
    freq.put("orn", 62);
    freq.put("orl", 17);
    freq.put("orm", 82);
    freq.put("ork", 38);
    freq.put("orh", 27);
    freq.put("ori", 33);
    freq.put("orf", 80);
    freq.put("org", 171);
    freq.put("ord", 213);
    freq.put("ore", 115);
    freq.put("orb", 50);
    freq.put("ora", 20);
    freq.put("App", 11);
    freq.put("fej", 17);
    freq.put("dør", 15);
    freq.put("Før", 17);
    freq.put("Føl", 7);
    freq.put("døm", 5);
    freq.put("lau", 17);
    freq.put("døg", 3);
    freq.put("død", 21);
    freq.put("Yac", 4);
    freq.put("Dø", 5);
    freq.put("en ", 2888);
    freq.put("dø ", 5);
    freq.put("Do", 22);
    freq.put("Di", 26);
    freq.put("De", 568);
    freq.put("Da", 138);
    freq.put("Dy", 4);
    freq.put("Du", 77);
    freq.put("Dr", 12);
    freq.put("feu", 3);
    freq.put("D ", 110);
    freq.put("ge ", 818);
    freq.put("æs ", 22);
    freq.put("We", 23);
    freq.put("Wa", 12);
    freq.put("Wo", 36);
    freq.put("Wi", 21);
    freq.put("ges", 63);
    freq.put("ger", 535);
    freq.put("gep", 3);
    freq.put("jø", 18);
    freq.put("gev", 14);
    freq.put("get", 327);
    freq.put("gea", 4);
    freq.put("uta", 7);
    freq.put("geg", 10);
    freq.put("gef", 7);
    freq.put("ged", 11);
    freq.put("gek", 5);
    freq.put("jå", 3);
    freq.put("jæ", 76);
    freq.put("geh", 4);
    freq.put("gen", 573);
    freq.put("gem", 12);
    freq.put("gel", 84);
    freq.put("HAh", 3);
    freq.put("æse", 42);
    freq.put("W ", 10);
    freq.put("æsk", 13);
    freq.put("æsn", 4);
    freq.put("æso", 5);
    freq.put("æst", 93);
    freq.put("dvæ", 4);
    freq.put("j ", 174);
    freq.put("jy", 8);
    freq.put("dk ", 27);
    freq.put(" æg", 7);
    freq.put("jt", 19);
    freq.put("ju", 38);
    freq.put("tur", 70);
    freq.put("tus", 12);
    freq.put("tut", 5);
    freq.put("jr", 60);
    freq.put("js", 23);
    freq.put("jl", 61);
    freq.put("jn", 7);
    freq.put("jo", 149);
    freq.put("jh", 3);
    freq.put("tum", 5);
    freq.put("tun", 13);
    freq.put("jk", 6);
    freq.put("jd", 65);
    freq.put("je", 1012);
    freq.put("tub", 3);
    freq.put("tud", 25);
    freq.put("ja", 130);
    freq.put("tug", 7);
    freq.put("dke", 4);
    freq.put("dka", 4);
    freq.put("tul", 3);
    freq.put("cla", 5);
    freq.put("tua", 7);
    freq.put("Ty", 16);
    freq.put("tue", 15);
    freq.put("pap", 6);
    freq.put("par", 84);
    freq.put("pas", 16);
    freq.put("pat", 6);
    freq.put("pau", 5);
    freq.put("pac", 6);
    freq.put("pag", 9);
    freq.put("æl ", 8);
    freq.put("pak", 13);
    freq.put("pal", 8);
    freq.put("pam", 6);
    freq.put("pan", 26);
    freq.put("oin", 4);
    freq.put("mån", 22);
    freq.put("oid", 6);
    freq.put("oic", 3);
    freq.put("dko", 9);
    freq.put("ælp", 37);
    freq.put("æls", 6);
    freq.put("ælt", 3);
    freq.put("pa ", 11);
    freq.put("ælk", 5);
    freq.put("æll", 46);
    freq.put("æle", 11);
    freq.put("æld", 53);
    freq.put("ælg", 34);
    freq.put("sv ", 5);
    freq.put("mo ", 5);
    freq.put("mor", 149);
    freq.put("mov", 4);
    freq.put("mot", 11);
    freq.put("mok", 12);
    freq.put("moo", 4);
    freq.put("mon", 23);
    freq.put("mob", 19);
    freq.put("Sjæ", 5);
    freq.put("mod", 77);
    freq.put("Nem", 3);
    freq.put("Nej", 21);
    freq.put("Ned", 7);
    freq.put("New", 10);
    freq.put("Net", 5);
    freq.put("Med", 17);
    freq.put(" ch", 29);
    freq.put(" ci", 21);
    freq.put(" co", 49);
    freq.put(" cl", 12);
    freq.put(" cm", 5);
    freq.put(" cc", 7);
    freq.put(" ca", 29);
    freq.put(" cd", 3);
    freq.put(" ce", 8);
    freq.put(" cy", 20);
    freq.put("Mes", 6);
    freq.put("Mer", 3);
    freq.put(" cr", 12);
    freq.put(" cu", 7);
    freq.put("Dri", 5);
    freq.put("øll", 8);
    freq.put("ølg", 38);
    freq.put("øle", 27);
    freq.put("Ac", 4);
    freq.put("e", 31171);
    freq.put("Af", 18);
    freq.put("Ai", 5);
    freq.put("dva", 9);
    freq.put("nt ", 149);
    freq.put("sva", 44);
    freq.put("Ove", 11);
    freq.put("Vi ", 75);
    freq.put("u", 3854);
    freq.put("Van", 4);
    freq.put("Val", 10);
    freq.put("gv", 22);
    freq.put("Vad", 3);
    freq.put("Var", 12);
    freq.put("hy ", 5);
    freq.put("ws ", 5);
    freq.put("DJ ", 3);
    freq.put("edh", 4);
    freq.put("ium", 6);
    freq.put("wse", 4);
    freq.put("hyg", 20);
    freq.put("Gid", 6);
    freq.put("aba", 4);
    freq.put("abb", 3);
    freq.put("abe", 37);
    freq.put("abi", 6);
    freq.put("abl", 7);
    freq.put("abo", 8);
    freq.put("abr", 3);
    freq.put("abs", 15);
    freq.put("abt", 5);
    freq.put("aby", 9);
    freq.put("K", 384);
    freq.put("gge", 134);
    freq.put("gga", 7);
    freq.put("ggi", 3);
    freq.put("ab ", 25);
    freq.put("lke", 49);
    freq.put("twa", 5);
    freq.put("twe", 37);
    freq.put("twi", 20);
    freq.put("LT ", 4);
    freq.put("de ", 1322);
    freq.put("ey ", 26);
    freq.put("dep", 10);
    freq.put("der", 1218);
    freq.put("des", 96);
    freq.put("det", 1226);
    freq.put("dev", 5);
    freq.put("deh", 3);
    freq.put("dej", 27);
    freq.put("dek", 6);
    freq.put("del", 190);
    freq.put("dem", 84);
    freq.put("den", 771);
    freq.put("deo", 36);
    freq.put("dea", 10);
    freq.put("deb", 21);
    freq.put("ded", 11);
    freq.put("dee", 6);
    freq.put("def", 9);
    freq.put("deg", 13);
    freq.put("X ", 9);
    freq.put("svø", 4);
    freq.put("vøm", 3);
    freq.put("ryl", 11);
    freq.put("iPa", 7);
    freq.put("ryk", 25);
    freq.put("Tyk", 4);
    freq.put("ryg", 21);
    freq.put("ryd", 26);
    freq.put("ryt", 4);
    freq.put("rys", 8);
    freq.put("Tys", 9);
    freq.put("Don", 7);
    freq.put("Dol", 3);
    freq.put("bæ", 17);
    freq.put("cs ", 9);
    freq.put("ry ", 13);
    freq.put("uh ", 5);
    freq.put("ok ", 142);
    freq.put("AY ", 3);
    freq.put("pct", 7);
    freq.put("pca", 3);
    freq.put("oks", 12);
    freq.put("okr", 11);
    freq.put("oku", 7);
    freq.put("Bas", 3);
    freq.put("uha", 3);
    freq.put("sbø", 4);
    freq.put("uhh", 4);
    freq.put("oka", 28);
    freq.put("uhu", 3);
    freq.put("oke", 16);
    freq.put("Bac", 4);
    freq.put("oki", 5);
    freq.put("okk", 21);
    freq.put("oko", 5);
    freq.put("fa ", 6);
    freq.put("oil", 4);
    freq.put("mm ", 29);
    freq.put("bæk", 5);
    freq.put("E ", 67);
    freq.put("bær", 9);
    freq.put("sbr", 8);
    freq.put("mmu", 23);
    freq.put("mmm", 12);
    freq.put("mmo", 3);
    freq.put("Und", 12);
    freq.put("Ung", 6);
    freq.put("sbj", 3);
    freq.put("Uni", 10);
    freq.put("sbi", 4);
    freq.put("mma", 12);
    freq.put("sbo", 6);
    freq.put("gig", 4);
    freq.put("Em", 7);
    freq.put("El", 45);
    freq.put("En", 89);
    freq.put("Ek", 7);
    freq.put("Ej", 16);
    freq.put("Ed", 3);
    freq.put("Eg", 7);
    freq.put("Ef", 16);
    freq.put("Eb", 3);
    freq.put("Ex", 9);
    freq.put("Eu", 21);
    freq.put("Et", 25);
    freq.put("Ev", 9);
    freq.put("Ep", 4);
    freq.put("Es", 3);
    freq.put("Er", 112);
    freq.put(" el", 166);
    freq.put(" em", 12);
    freq.put(" en", 858);
    freq.put(" eh", 4);
    freq.put("kol", 58);
    freq.put(" ej", 15);
    freq.put(" ek", 36);
    freq.put(" ed", 4);
    freq.put(" ee", 3);
    freq.put(" ef", 88);
    freq.put(" eg", 41);
    freq.put("kod", 10);
    freq.put("kog", 6);
    freq.put("øn ", 19);
    freq.put("ze", 15);
    freq.put(" et", 246);
    freq.put(" eu", 11);
    freq.put("kos", 17);
    freq.put("kor", 33);
    freq.put(" er", 1354);
    freq.put("kov", 8);
    freq.put("Sla", 3);
    freq.put("øns", 23);
    freq.put("b", 2778);
    freq.put("ønt", 3);
    freq.put("kå", 5);
    freq.put("ko ", 12);
    freq.put(" e ", 21);
    freq.put("ønd", 38);
    freq.put("kø", 129);
    freq.put("ønl", 3);
    freq.put("ønn", 8);
    freq.put("At ", 8);
    freq.put("vn ", 62);
    freq.put("k ", 979);
    freq.put("Kir", 3);
    freq.put("Kim", 5);
    freq.put("Kig", 3);
    freq.put("vne", 44);
    freq.put("vni", 7);
    freq.put("vnt", 6);
    freq.put("vns", 4);
    freq.put("kb", 14);
    freq.put("ka", 967);
    freq.put("kf", 3);
    freq.put("ke", 1819);
    freq.put("kk", 903);
    freq.put("kj", 10);
    freq.put("ki", 145);
    freq.put("kh", 3);
    freq.put("ko", 442);
    freq.put("kn", 56);
    freq.put("km", 5);
    freq.put("kl", 235);
    freq.put("ks", 152);
    freq.put("kr", 336);
    freq.put("kp", 4);
    freq.put("kv", 44);
    freq.put("ku", 283);
    freq.put("kt", 251);
    freq.put("ååå", 6);
    freq.put("ky", 78);
    freq.put(" Bø", 9);
    freq.put("Opt", 7);
    freq.put("Op ", 3);
    freq.put(" Be", 83);
    freq.put(" Ba", 57);
    freq.put(" Bl", 36);
    freq.put(" Bo", 35);
    freq.put(" Bi", 26);
    freq.put(" Bj", 6);
    freq.put(" Bu", 19);
    freq.put("ik ", 149);
    freq.put(" Br", 48);
    freq.put(" By", 8);
    freq.put("iks", 14);
    freq.put("tæl", 25);
    freq.put("tæn", 69);
    freq.put(" B ", 12);
    freq.put("ikt", 9);
    freq.put("ikb", 3);
    freq.put("ika", 34);
    freq.put("GE ", 6);
    freq.put("ike", 59);
    freq.put("kte", 49);
    freq.put("ikk", 629);
    freq.put("tæt", 17);
    freq.put("iki", 7);
    freq.put("tæv", 3);
    freq.put("tæp", 4);
    freq.put("TC ", 4);
    freq.put("ikl", 24);
    freq.put("Yes", 4);
    freq.put("lbr", 5);
    freq.put("lbu", 29);
    freq.put("ga ", 36);
    freq.put("ND ", 3);
    freq.put("ran", 100);
    freq.put("gav", 27);
    freq.put("gat", 4);
    freq.put("gas", 11);
    freq.put("gar", 6);
    freq.put("gan", 131);
    freq.put("gam", 44);
    freq.put("gal", 14);
    freq.put("gag", 4);
    freq.put("gae", 4);
    freq.put("gad", 13);
    freq.put("gaa", 7);
    freq.put("lba", 33);
    freq.put("fug", 15);
    freq.put("fuc", 24);
    freq.put("fun", 23);
    freq.put("lbe", 9);
    freq.put("ful", 40);
    freq.put("Irr", 3);
    freq.put("ewc", 3);
    freq.put("ewa", 4);
    freq.put("ewe", 5);
    freq.put("ews", 4);
    freq.put("iøs", 15);
    freq.put("dga", 14);
    freq.put("syg", 25);
    freq.put("syd", 7);
    freq.put("syk", 11);
    freq.put("dgi", 9);
    freq.put("syn", 62);
    freq.put("sym", 5);
    freq.put("syl", 3);
    freq.put("dgr", 5);
    freq.put("ew ", 7);
    freq.put("y", 1378);
    freq.put("lda", 3);
    freq.put("lde", 201);
    freq.put("ldk", 6);
    freq.put("ldi", 42);
    freq.put("ldn", 10);
    freq.put("bi ", 13);
    freq.put("lds", 29);
    freq.put("ldr", 61);
    freq.put("ldt", 66);
    freq.put("rgr", 8);
    freq.put("rgs", 11);
    freq.put("rgt", 4);
    freq.put("cur", 3);
    freq.put("cup", 5);
    freq.put("rga", 9);
    freq.put("rge", 155);
    freq.put("rgi", 8);
    freq.put("rgo", 3);
    freq.put("bin", 15);
    freq.put("bio", 4);
    freq.put("Din", 4);
    freq.put("ld ", 177);
    freq.put("bid", 8);
    freq.put("Dig", 8);
    freq.put("bia", 3);
    freq.put("AL ", 5);
    freq.put("bit", 6);
    freq.put("bir", 4);
    freq.put("bis", 6);
    freq.put("Dir", 3);
    freq.put("Dis", 4);
    freq.put("rg ", 55);
    freq.put("uf ", 3);
    freq.put("oe ", 7);
    freq.put("pet", 7);
    freq.put("pep", 3);
    freq.put("per", 130);
    freq.put("pes", 4);
    freq.put("pel", 21);
    freq.put("pen", 70);
    freq.put("pej", 4);
    freq.put("pek", 7);
    freq.put("ped", 13);
    freq.put("pee", 3);
    freq.put("pef", 5);
    freq.put("peg", 9);
    freq.put("pea", 6);
    freq.put("pec", 15);
    freq.put("oer", 12);
    freq.put("Bor", 11);
    freq.put("use", 38);
    freq.put("O", 254);
    freq.put("oet", 5);
    freq.put("Bol", 3);
    freq.put("oen", 27);
    freq.put("Boo", 3);
    freq.put("feb", 4);
    freq.put("uft", 14);
    freq.put("oed", 20);
    freq.put("ä", 4);
    freq.put("pe ", 91);
    freq.put("fel", 5);
    freq.put("nsh", 4);
    freq.put("nsi", 22);
    freq.put("nsk", 168);
    freq.put("nsm", 20);
    freq.put("nso", 4);
    freq.put("al", 1208);
    freq.put("nsa", 10);
    freq.put("nsd", 11);
    freq.put("nse", 63);
    freq.put("nsf", 5);
    freq.put("nsy", 3);
    freq.put("møg", 5);
    freq.put("nsp", 15);
    freq.put("nss", 4);
    freq.put("nst", 59);
    freq.put("nsu", 5);
    freq.put("nsv", 7);
    freq.put("Snæ", 3);
    freq.put(" gø", 82);
    freq.put(" gæ", 19);
    freq.put(" gå", 103);
    freq.put("mkr", 12);
    freq.put("fer", 46);
    freq.put(" R ", 7);
    freq.put("sdr", 3);
    freq.put("ns ", 193);
    freq.put("Hus", 17);
    freq.put("sde", 3);
    freq.put("sda", 47);
    freq.put("Flo", 5);
    freq.put("Fle", 7);
    freq.put("lyt", 26);
    freq.put("lyv", 10);
    freq.put("lys", 41);
    freq.put("nsæ", 4);
    freq.put("nsø", 3);
    freq.put("Nyh", 7);
    freq.put("lyn", 7);
    freq.put("Nyd", 5);
    freq.put("lyk", 31);
    freq.put("Mas", 7);
    freq.put("fåe", 44);
    freq.put(" gr", 111);
    freq.put("Mat", 7);
    freq.put(" gy", 4);
    freq.put("Mac", 15);
    freq.put(" ge", 104);
    freq.put("får", 88);
    freq.put("Mad", 10);
    freq.put("Mag", 5);
    freq.put(" ga", 168);
    freq.put(" go", 311);
    freq.put(" gl", 79);
    freq.put(" gj", 12);
    freq.put("Mal", 5);
    freq.put(" gi", 81);
    freq.put("Flø", 3);
    freq.put("Meg", 7);
    freq.put("ly ", 17);
    freq.put("Ny ", 11);
    freq.put("kma", 3);
    freq.put("få ", 62);
    freq.put(" b", 1444);
    freq.put(" c", 210);
    freq.put(" a", 2069);
    freq.put(" f", 2452);
    freq.put(" g", 1107);
    freq.put(" d", 3857);
    freq.put(" e", 2896);
    freq.put(" j", 941);
    freq.put(" k", 1470);
    freq.put(" h", 2462);
    freq.put(" i", 2282);
    freq.put(" n", 1115);
    freq.put(" o", 1864);
    freq.put(" l", 1324);
    freq.put(" m", 2720);
    freq.put(" r", 541);
    freq.put(" s", 3904);
    freq.put(" p", 1419);
    freq.put(" q", 4);
    freq.put(" v", 1686);
    freq.put(" w", 103);
    freq.put(" t", 1984);
    freq.put(" u", 561);
    freq.put(" z", 9);
    freq.put(" x", 53);
    freq.put("øl ", 12);
    freq.put(" B", 369);
    freq.put(" C", 200);
    freq.put(" A", 358);
    freq.put(" F", 423);
    freq.put(" G", 304);
    freq.put(" D", 1139);
    freq.put(" E", 425);
    freq.put(" J", 452);
    freq.put(" K", 383);
    freq.put(" H", 827);
    freq.put(" I", 276);
    freq.put(" N", 373);
    freq.put(" O", 247);
    freq.put(" L", 339);
    freq.put(" M", 497);
    freq.put(" R", 234);
    freq.put(" S", 880);
    freq.put(" P", 291);
    freq.put(" Q", 5);
    freq.put(" V", 311);
    freq.put(" W", 109);
    freq.put(" T", 424);
    freq.put(" U", 112);
    freq.put(" Z", 15);
    freq.put(" X", 15);
    freq.put(" Y", 38);
    freq.put("vli", 12);
    freq.put("vlo", 4);
    freq.put("vle", 14);
    freq.put("vlt", 4);
    freq.put(" æ", 51);
    freq.put(" å", 136);
    freq.put(" é", 20);
    freq.put("æææ", 4);
    freq.put(" ø", 85);
    freq.put(" Æ", 12);
    freq.put(" Å", 41);
    freq.put("fat", 18);
    freq.put(" Ø", 33);
    freq.put("och", 3);
    freq.put("ock", 15);
    freq.put("næv", 13);
    freq.put("næs", 50);
    freq.put("nær", 14);
    freq.put("næp", 4);
    freq.put(" Do", 20);
    freq.put("Vet", 3);
    freq.put("Ver", 12);
    freq.put("Ves", 12);
    freq.put(" Di", 26);
    freq.put(" De", 567);
    freq.put(" Da", 136);
    freq.put("Veg", 3);
    freq.put("Ved", 15);
    freq.put("ii ", 3);
    freq.put(" Dy", 4);
    freq.put("Ven", 10);
    freq.put("Vel", 7);
    freq.put("Vej", 10);
    freq.put(" Dr", 12);
    freq.put("cha", 28);
    freq.put("Fr", 55);
    freq.put("che", 28);
    freq.put("chi", 15);
    freq.put("chm", 7);
    freq.put("cho", 9);
    freq.put("Fa", 59);
    freq.put("cht", 4);
    freq.put("Fe", 19);
    freq.put("Fi", 44);
    freq.put("Fl", 20);
    freq.put("DF ", 14);
    freq.put("Fo", 83);
    freq.put("iis", 4);
    freq.put(" D ", 70);
    freq.put("iig", 6);
    freq.put("iii", 11);
    freq.put("ch ", 27);

    init3();
  }
  private static void init3() {
    
    freq.put("f", 4151);
    freq.put("F ", 55);
    freq.put("BH ", 6);
    freq.put("Øns", 3);
    freq.put(" Dø", 5);
    freq.put("afl", 10);
    freq.put("afh", 9);
    freq.put("afi", 23);
    freq.put("Yo", 16);
    freq.put("Fø", 25);
    freq.put("afe", 10);
    freq.put("aff", 51);
    freq.put("afg", 7);
    freq.put("Ye", 7);
    freq.put("afb", 5);
    freq.put("Få", 12);
    freq.put("Fæ", 4);
    freq.put("aft", 81);
    freq.put("afv", 7);
    freq.put("afr", 4);
    freq.put("afs", 29);
    freq.put("Y ", 9);
    freq.put("af ", 439);
    freq.put("fem", 6);
    freq.put("lfæ", 14);
    freq.put("da ", 139);
    freq.put("lfø", 4);
    freq.put("lf", 42);
    freq.put("lg", 167);
    freq.put("ld", 605);
    freq.put("tsm", 5);
    freq.put("lb", 102);
    freq.put("tsk", 9);
    freq.put("tsh", 3);
    freq.put("la", 699);
    freq.put("ln", 10);
    freq.put("eud", 8);
    freq.put("ll", 1031);
    freq.put("tse", 5);
    freq.put("lj", 7);
    freq.put("lk", 114);
    freq.put("lh", 7);
    freq.put("tsa", 5);
    freq.put("lv", 136);
    freq.put("lt", 373);
    freq.put("lu", 149);
    freq.put("lr", 7);
    freq.put("ls", 346);
    freq.put("lp", 50);
    freq.put("tsy", 3);
    freq.put("tst", 3);
    freq.put("åsk", 36);
    freq.put("tss", 3);
    freq.put("tsp", 7);
    freq.put("ly", 194);
    freq.put("daf", 16);
    freq.put("dag", 400);
    freq.put("dal", 6);
    freq.put("dam", 22);
    freq.put("dan", 197);
    freq.put("dah", 3);
    freq.put("dak", 5);
    freq.put("dat", 42);
    freq.put("dar", 13);
    freq.put("das", 5);
    freq.put("Øv ", 3);
    freq.put("l ", 1781);
    freq.put("ts ", 59);
    freq.put("vl ", 13);
    freq.put("lie", 35);
    freq.put("lfi", 3);
    freq.put("lfr", 6);
    freq.put("læ", 275);
    freq.put("lå", 51);
    freq.put("rer", 219);
    freq.put("res", 219);
    freq.put("rep", 17);
    freq.put("Tus", 4);
    freq.put("rev", 69);
    freq.put("rew", 3);
    freq.put("ret", 275);
    freq.put("rej", 18);
    freq.put("rek", 41);
    freq.put("rei", 6);
    freq.put("ren", 206);
    freq.put("rel", 31);
    freq.put("rem", 87);
    freq.put("reb", 11);
    freq.put("rec", 3);
    freq.put("Tub", 4);
    freq.put("rea", 42);
    freq.put("ref", 21);
    freq.put("reg", 82);
    freq.put("red", 178);
    freq.put("ree", 14);
    freq.put("lf ", 7);
    freq.put("qua", 4);
    freq.put("que", 3);
    freq.put("qui", 3);
    freq.put("re ", 1123);
    freq.put("pga", 11);
    freq.put("ud ", 169);
    freq.put("pgr", 3);
    freq.put("og ", 892);
    freq.put("uds", 54);
    freq.put("udv", 22);
    freq.put("sfø", 7);
    freq.put("ogs", 153);
    freq.put("ogr", 34);
    freq.put("udb", 5);
    freq.put("ogl", 71);
    freq.put("uda", 5);
    freq.put("ogi", 30);
    freq.put("udg", 18);
    freq.put("udd", 20);
    freq.put("ude", 99);
    freq.put("oge", 208);
    freq.put("udk", 4);
    freq.put("ogg", 13);
    freq.put("udi", 15);
    freq.put("oga", 5);
    freq.put("udo", 7);
    freq.put("udl", 16);
    freq.put("udm", 3);
    freq.put("Pen", 5);
    freq.put("lim", 17);
    freq.put("Pap", 7);
    freq.put("Par", 23);
    freq.put("Pas", 4);
    freq.put("Pat", 5);
    freq.put("Pau", 4);
    freq.put("Pad", 7);
    freq.put("Pan", 4);
    freq.put("mik", 5);
    freq.put("mil", 43);
    freq.put("mio", 5);
    freq.put("min", 298);
    freq.put("mia", 5);
    freq.put("Go ", 3);
    freq.put("mie", 10);
    freq.put("mid", 50);
    freq.put("mig", 231);
    freq.put("Køg", 3);
    freq.put("mix", 5);
    freq.put("Kør", 5);
    freq.put("mir", 4);
    freq.put("mit", 57);
    freq.put("sfu", 5);
    freq.put("sfr", 3);
    freq.put("sfo", 8);
    freq.put("sfe", 12);
    freq.put("sfa", 5);
    freq.put("mi ", 9);
    freq.put(" iP", 23);
    freq.put(" iT", 5);
    freq.put(" iM", 4);
    freq.put("kst", 43);
    freq.put("ksp", 14);
    freq.put(" ip", 3);
    freq.put("Mor", 9);
    freq.put(" ir", 14);
    freq.put(" is", 22);
    freq.put(" it", 21);
    freq.put("Mov", 3);
    freq.put(" iv", 4);
    freq.put("Mot", 3);
    freq.put(" ih", 6);
    freq.put(" ik", 554);
    freq.put(" il", 4);
    freq.put(" im", 40);
    freq.put(" in", 279);
    freq.put("ksb", 3);
    freq.put(" ia", 5);
    freq.put("kso", 9);
    freq.put(" id", 55);
    freq.put("øb ", 15);
    freq.put(" if", 8);
    freq.put(" ig", 77);
    freq.put("øbt", 13);
    freq.put("øbs", 3);
    freq.put("ks ", 43);
    freq.put("øbe", 89);
    freq.put("vr ", 3);
    freq.put("wo", 20);
    freq.put("ksæ", 3);
    freq.put("då", 28);
    freq.put("S", 888);
    freq.put("wi", 65);
    freq.put("vre", 15);
    freq.put("vri", 10);
    freq.put("ww", 21);
    freq.put("ws", 11);
    freq.put("Øko", 4);
    freq.put(" Fø", 25);
    freq.put("ac", 145);
    freq.put("oho", 6);
    freq.put(" Få", 12);
    freq.put(" Fæ", 4);
    freq.put("ad", 547);
    freq.put("ånd", 39);
    freq.put("åne", 28);
    freq.put("ång", 3);
    freq.put("ys ", 14);
    freq.put("ånn", 7);
    freq.put("ak", 282);
    freq.put("OL ", 13);
    freq.put("emå", 3);
    freq.put("oha", 8);
    freq.put("cor", 14);
    freq.put("ao", 4);
    freq.put("byg", 16);
    freq.put("cou", 4);
    freq.put("ån ", 9);
    freq.put("Hov", 6);
    freq.put("ysi", 4);
    freq.put("ysn", 5);
    freq.put("ap", 79);
    freq.put("uis", 3);
    freq.put("yse", 19);
    freq.put("yss", 4);
    freq.put("at", 1336);
    freq.put(" Fr", 55);
    freq.put(" Fu", 37);
    freq.put(" Fy", 9);
    freq.put(" Fa", 59);
    freq.put(" Fe", 18);
    freq.put(" Fi", 42);
    freq.put(" Fl", 20);
    freq.put(" Fo", 83);
    freq.put("io ", 15);
    freq.put("uiz", 3);
    freq.put("iot", 8);
    freq.put("ior", 8);
    freq.put("ion", 155);
    freq.put("iol", 5);
    freq.put("iod", 5);
    freq.put("GA ", 4);
    freq.put("sæl", 7);
    freq.put("col", 8);
    freq.put("con", 16);
    freq.put("fy ", 5);
    freq.put("adv", 5);
    freq.put("adt", 4);
    freq.put("adr", 13);
    freq.put("ads", 42);
    freq.put("gma", 10);
    freq.put("esø", 14);
    freq.put("adg", 5);
    freq.put("add", 19);
    freq.put("ade", 111);
    freq.put("ada", 6);
    freq.put("ado", 6);
    freq.put("adl", 5);
    freq.put("adm", 3);
    freq.put("adi", 71);
    freq.put("Hyg", 6);
    freq.put("fyl", 7);
    freq.put("fyr", 11);
    freq.put("fys", 3);
    freq.put("ad ", 248);
    freq.put("nje", 5);
    freq.put("esv", 19);
    freq.put("esu", 11);
    freq.put("est", 291);
    freq.put("ess", 72);
    freq.put("esp", 35);
    freq.put("ese", 31);
    freq.put("esc", 5);
    freq.put("esb", 3);
    freq.put("esa", 13);
    freq.put("eso", 15);
    freq.put("esm", 3);
    freq.put("esl", 13);
    freq.put("esk", 50);
    freq.put("esi", 30);
    freq.put("esh", 3);
    freq.put("avl", 11);
    freq.put("OS ", 8);
    freq.put("es ", 434);
    freq.put("Twe", 9);
    freq.put("Twi", 17);
    freq.put("De ", 67);
    freq.put("bu ", 5);
    freq.put("rch", 7);
    freq.put("rce", 8);
    freq.put("bur", 40);
    freq.put("bus", 18);
    freq.put("Der", 60);
    freq.put("Des", 5);
    freq.put("Det", 323);
    freq.put("but", 13);
    freq.put("Dej", 7);
    freq.put("bun", 7);
    freq.put("Dem", 4);
    freq.put("bul", 3);
    freq.put("bum", 19);
    freq.put("bug", 3);
    freq.put("bud", 28);
    freq.put("j", 1862);
    freq.put("pil", 108);
    freq.put("pin", 16);
    freq.put("pib", 3);
    freq.put("pic", 3);
    freq.put("pie", 3);
    freq.put("pig", 16);
    freq.put("ub ", 8);
    freq.put("pip", 4);
    freq.put("pir", 11);
    freq.put("pis", 27);
    freq.put("Rys", 3);
    freq.put(" øk", 8);
    freq.put(" øj", 15);
    freq.put("oad", 10);
    freq.put("oac", 4);
    freq.put(" øn", 18);
    freq.put(" øm", 3);
    freq.put(" øl", 11);
    freq.put("oah", 3);
    freq.put("oar", 7);
    freq.put(" øs", 3);
    freq.put(" ør", 7);
    freq.put(" øv", 13);
    freq.put("Acc", 3);
    freq.put("ubr", 3);
    freq.put("pi ", 3);
    freq.put("ube", 9);
    freq.put("ubb", 13);
    freq.put("ubl", 7);
    freq.put(" gu", 26);
    freq.put(" kæ", 48);
    freq.put(" kø", 102);
    freq.put("øft", 6);
    freq.put("Oka", 6);
    freq.put("G ", 37);
    freq.put("Gu", 19);
    freq.put("Gr", 33);
    freq.put("Uh ", 5);
    freq.put("Ok ", 6);
    freq.put("Ge", 23);
    freq.put("Ga", 28);
    freq.put("Go", 96);
    freq.put("Gl", 30);
    freq.put("Gi", 19);
    freq.put(" kb", 5);
    freq.put(" ka", 465);
    freq.put(" ke", 60);
    freq.put(" ki", 35);
    freq.put(" kn", 18);
    freq.put(" ko", 290);
    freq.put(" kl", 141);
    freq.put(" kr", 106);
    freq.put(" kv", 31);
    freq.put(" ku", 150);
    freq.put(" ky", 8);
    freq.put("kus", 14);
    freq.put("kur", 21);
    freq.put("kup", 3);
    freq.put("kun", 131);
    freq.put("kum", 7);
    freq.put("gna", 5);
    freq.put("kug", 3);
    freq.put("kue", 10);
    freq.put("kud", 11);
    freq.put("kub", 4);
    freq.put(" k ", 5);
    freq.put("ødb", 5);
    freq.put("ødv", 6);
    freq.put("ødt", 25);
    freq.put("øds", 18);
    freq.put("Ze", 4);
    freq.put("ty", 113);
    freq.put("Za", 4);
    freq.put("Gø", 5);
    freq.put("Gæ", 5);
    freq.put("fé ", 4);
    freq.put("ect", 6);
    freq.put("Zu", 4);
    freq.put("ku ", 13);
    freq.put("Kom", 38);
    freq.put("Kol", 5);
    freq.put("Kon", 11);
    freq.put("ts", 159);
    freq.put("Kor", 4);
    freq.put("m ", 1055);
    freq.put("tm", 4);
    freq.put("mO", 4);
    freq.put("me", 1989);
    freq.put("md", 6);
    freq.put("mg", 11);
    freq.put("mf", 15);
    freq.put("ma", 721);
    freq.put("ltu", 14);
    freq.put("mb", 45);
    freq.put("mm", 571);
    freq.put("ml", 54);
    freq.put("mo", 317);
    freq.put("mn", 24);
    freq.put("mi", 769);
    freq.put("mh", 12);
    freq.put("mk", 16);
    freq.put("mu", 140);
    freq.put("mt", 103);
    freq.put("mv", 10);
    freq.put("mp", 152);
    freq.put("ms", 66);
    freq.put("mr", 31);
    freq.put("ta", 637);
    freq.put("my", 26);
    freq.put("kæv", 3);
    freq.put("kær", 35);
    freq.put("Lyn", 10);
    freq.put("kæf", 11);
    freq.put("kæl", 8);
    freq.put("kæm", 17);
    freq.put("ena", 22);
    freq.put("enb", 15);
    freq.put("enc", 16);
    freq.put("end", 525);
    freq.put("ene", 165);
    freq.put("enf", 14);
    freq.put("eng", 119);
    freq.put("enh", 57);
    freq.put("eni", 65);
    freq.put("enk", 10);
    freq.put("enl", 25);
    freq.put("enm", 20);
    freq.put("enn", 115);
    freq.put("eno", 15);
    freq.put("enp", 4);
    freq.put("enr", 13);
    freq.put("ens", 220);
    freq.put("ent", 234);
    freq.put("enu", 6);
    freq.put("eny", 3);
    freq.put("enz", 3);
    freq.put("Hel", 36);
    freq.put("ON ", 5);
    freq.put("må", 198);
    freq.put("mæ", 60);
    freq.put("ål ", 25);
    freq.put("ü", 4);
    freq.put("mø", 61);
    freq.put(" Hy", 6);
    freq.put("må ", 78);
    freq.put(" Hv", 206);
    freq.put(" Hu", 40);
    freq.put(" Hj", 10);
    freq.put(" Hi", 17);
    freq.put(" Ho", 55);
    freq.put(" Hm", 14);
    freq.put(" Ha", 229);
    freq.put(" He", 125);
    freq.put("ima", 12);
    freq.put("imb", 3);
    freq.put("ime", 57);
    freq.put("cli", 4);
    freq.put("imi", 13);
    freq.put("cle", 5);
    freq.put("imm", 5);
    freq.put("iml", 3);
    freq.put("imo", 29);
    freq.put("imp", 27);
    freq.put("ims", 4);
    freq.put("imr", 3);
    freq.put("JA ", 6);
    freq.put("måd", 18);
    freq.put("mål", 37);
    freq.put("SA ", 19);
    freq.put("måt", 3);
    freq.put("mås", 35);
    freq.put(" H ", 5);
    freq.put("im ", 18);
    freq.put("Fær", 3);
    freq.put("Hej", 16);
    freq.put("cy ", 4);
    freq.put(" Hø", 13);
    freq.put("BT ", 5);
    freq.put(" Hæ", 16);
    freq.put(" Hå", 29);
    freq.put("gol", 4);
    freq.put("goo", 11);
    freq.put("gon", 4);
    freq.put("imæ", 3);
    freq.put("god", 286);
    freq.put("ajs", 3);
    freq.put("got", 4);
    freq.put("aje", 6);
    freq.put("gor", 4);
    freq.put("W", 112);
    freq.put("Vid", 9);
    freq.put("Vik", 3);
    freq.put("Vin", 8);
    freq.put("go ", 16);
    freq.put("Vil", 35);
    freq.put("Vir", 8);
    freq.put("aj ", 8);
    freq.put(" Sp", 46);
    freq.put("nhe", 12);
    freq.put("nha", 49);
    freq.put("nho", 5);
    freq.put("nhv", 4);
    freq.put("lbæ", 3);
    freq.put("tor", 139);
    freq.put("tos", 7);
    freq.put("top", 49);
    freq.put("tov", 3);
    freq.put("EU ", 8);
    freq.put("tot", 7);
    freq.put("tou", 8);
    freq.put("ton", 9);
    freq.put("tol", 18);
    freq.put("tom", 13);
    freq.put("tob", 7);
    freq.put("tof", 5);
    freq.put("tog", 33);
    freq.put("tod", 10);
    freq.put("toe", 3);
    freq.put("Fuc", 23);
    freq.put("Ful", 7);
    freq.put("to ", 83);
    freq.put("ept", 21);
    freq.put("raf", 46);
    freq.put("rag", 35);
    freq.put("rad", 37);
    freq.put("rae", 5);
    freq.put("rab", 7);
    freq.put("rac", 9);
    freq.put("raa", 4);
    freq.put("lby", 5);
    freq.put("ral", 25);
    freq.put("ram", 53);
    freq.put("raj", 4);
    freq.put("rak", 26);
    freq.put("rah", 4);
    freq.put("rai", 9);
    freq.put("rav", 25);
    freq.put("rat", 81);
    freq.put("rar", 15);
    freq.put("ras", 21);
    freq.put("rap", 9);
    freq.put("bs ", 19);
    freq.put("lbo", 15);
    freq.put("Syg", 3);
    freq.put("Syd", 3);
    freq.put("Syn", 17);
    freq.put("It ", 3);
    freq.put("ra ", 257);
    freq.put("bst", 5);
    freq.put("mør", 12);
    freq.put("møl", 4);
    freq.put("bso", 6);
    freq.put("bsi", 5);
    freq.put("bsk", 3);
    freq.put("bse", 6);
    freq.put("mød", 33);
    freq.put("møb", 4);
    freq.put("Ita", 4);
    freq.put("R", 235);
    freq.put("ér", 9);
    freq.put("ét", 6);
    freq.put("cyk", 20);
    freq.put("én", 17);
    freq.put("oci", 17);
    freq.put("Bio", 4);
    freq.put("Bil", 10);
    freq.put("oca", 5);
    freq.put("Bie", 5);
    freq.put("oce", 6);
    freq.put("NU ", 3);
    freq.put("Aal", 8);
    freq.put("Aar", 11);
    freq.put("é ", 12);
    freq.put("AaB", 6);
    freq.put("oc ", 3);
    freq.put("Pet", 8);
    freq.put("nut", 15);
    freq.put("nus", 18);
    freq.put("Per", 11);
    freq.put("nul", 4);
    freq.put("num", 17);
    freq.put("nuf", 4);
    freq.put("nud", 6);
    freq.put("nue", 3);
    freq.put("nua", 4);
    freq.put("mut", 7);
    freq.put("mus", 37);
    freq.put("mur", 4);
    freq.put("Uff", 3);
    freq.put("mul", 35);
    freq.put("mun", 27);
    freq.put("muk", 21);
    freq.put("Exc", 4);
    freq.put("XD ", 4);
    freq.put("Hø", 13);
    freq.put("nu ", 200);
    freq.put(" me", 1152);
    freq.put(" ma", 391);
    freq.put(" mm", 7);
    freq.put(" mo", 211);
    freq.put(" mi", 603);
    freq.put(" mu", 60);
    freq.put(" ms", 3);
    freq.put(" my", 12);
    freq.put(" m ", 27);
    freq.put("Cro", 3);
    freq.put("TV ", 23);
    freq.put("elv", 90);
    freq.put("n", 13167);
    freq.put(" må", 171);
    freq.put(" mæ", 30);
    freq.put(" mø", 40);
    freq.put(" Jø", 3);
    freq.put("elk", 10);
    freq.put("elh", 3);
    freq.put("eli", 193);
    freq.put("elo", 9);
    freq.put("ell", 259);
    freq.put("elm", 3);
    freq.put("elb", 12);
    freq.put("ela", 19);
    freq.put("elf", 8);
    freq.put("eld", 68);
    freq.put("ele", 103);
    freq.put("ely", 8);
    freq.put("els", 249);
    freq.put("elp", 5);
    freq.put("Hæ", 16);
    freq.put("elt", 137);
    freq.put("Hå", 29);
    freq.put("D", 1168);
    freq.put("OH ", 8);
    freq.put("jys", 4);
    freq.put("nør", 4);
    freq.put("el ", 201);
    freq.put("nøy", 4);
    freq.put("Lyd", 3);
    freq.put("nød", 14);
    freq.put("nøg", 4);
    freq.put("jyl", 3);
    freq.put("nøj", 6);
    freq.put(" Ju", 18);
    freq.put(" Jo", 49);
    freq.put(" Je", 264);
    freq.put(" Ja", 86);
    freq.put("ick", 18);
    freq.put("ici", 17);
    freq.put("Hy", 6);
    freq.put("vår", 4);
    freq.put("ica", 9);
    freq.put("elæ", 3);
    freq.put("ice", 39);
    freq.put("Hu", 40);
    freq.put("Hj", 10);
    freq.put("våg", 9);
    freq.put("elø", 4);
    freq.put("Hi", 17);
    freq.put("Ho", 55);
    freq.put("Hm", 14);
    freq.put("ics", 5);
    freq.put("icr", 4);
    freq.put("Ha", 230);
    freq.put("He", 125);
    freq.put("eyb", 3);
    freq.put(" J ", 7);
    freq.put("ic ", 15);
    freq.put("H ", 34);
    freq.put("Lyk", 3);
    freq.put("ppa", 4);
    freq.put("aha", 92);
    freq.put("ppe", 87);
    freq.put("ahh", 8);
    freq.put("ppo", 3);
    freq.put("ahl", 3);
    freq.put("ppl", 14);
    freq.put("pps", 4);
    freq.put("giv", 62);
    freq.put("git", 13);
    freq.put("gis", 13);
    freq.put("gir", 5);
    freq.put("nå", 132);
    freq.put("næ", 88);
    freq.put("nø", 38);
    freq.put("gif", 7);
    freq.put("gie", 3);
    freq.put("gid", 12);
    freq.put("AD ", 5);
    freq.put("gio", 6);
    freq.put("gin", 12);
    freq.put("gil", 3);
    freq.put("gik", 16);
    freq.put("Hvi", 53);
    freq.put("ah ", 25);
    freq.put("pp ", 8);
    freq.put("Hvo", 91);
    freq.put("Voi", 3);
    freq.put("Vor", 7);
    freq.put("gi ", 20);
    freq.put("nno", 8);
    freq.put("nni", 16);
    freq.put("nne", 197);
    freq.put("nna", 7);
    freq.put("nny", 4);
    freq.put("sq ", 3);
    freq.put("nh", 74);
    freq.put("ni", 416);
    freq.put("nj", 7);
    freq.put("nk", 210);
    freq.put("nl", 71);
    freq.put("nm", 95);
    freq.put("nn", 257);
    freq.put("no", 401);
    freq.put("tit", 21);
    freq.put("na", 283);
    freq.put("nb", 31);
    freq.put("nc", 86);
    freq.put("nd", 1876);
    freq.put("ne", 1397);
    freq.put("nf", 51);
    freq.put("ng", 1219);
    freq.put("til", 921);
    freq.put("ny", 164);
    freq.put("nz", 5);
    freq.put("tio", 103);
    freq.put("tik", 60);
    freq.put("np", 9);
    freq.put("tie", 46);
    freq.put("nr", 25);
    freq.put("ns", 615);
    freq.put("nt", 497);
    freq.put("nu", 282);
    freq.put("nv", 34);
    freq.put("tic", 7);
    freq.put("Bør", 5);
    freq.put("squ", 3);
    freq.put("nn ", 22);
    freq.put("ich", 17);
    freq.put("ico", 3);
    freq.put("Bøg", 4);
    freq.put("n ", 4735);
    freq.put("mme", 480);
    freq.put("ti ", 35);
    freq.put("æt ", 49);
    freq.put("roi", 5);
    freq.put("roj", 15);
    freq.put("rok", 6);
    freq.put("rol", 28);
    freq.put("rom", 17);
    freq.put("ron", 24);
    freq.put("roo", 4);
    freq.put("lls", 3);
    freq.put("Hv", 206);
    freq.put("rob", 25);
    freq.put("roc", 10);
    freq.put("rod", 34);
    freq.put("roe", 29);
    freq.put("rof", 16);
    freq.put("rog", 34);
    freq.put("lli", 84);
    freq.put("mg ", 3);
    freq.put("llo", 21);
    freq.put("llm", 3);
    freq.put("rop", 45);
    freq.put("ror", 82);
    freq.put("ros", 16);
    freq.put("rot", 7);
    freq.put("rou", 8);
    freq.put("rov", 11);
    freq.put("row", 8);
    freq.put("Dag", 13);
    freq.put("Dam", 8);
    freq.put("Dan", 93);
    freq.put("Dat", 3);
    freq.put("ro ", 26);
    freq.put("Cis", 3);
    freq.put("Cit", 7);
    freq.put("ll ", 50);
    freq.put("Da ", 9);
    freq.put("jde", 53);
    freq.put("llø", 3);
    freq.put("Res", 8);
    freq.put("Ret", 6);
    freq.put("Ren", 6);
    freq.put("Rea", 9);
    freq.put("Reg", 10);
    freq.put("Red", 5);
    freq.put("Ree", 3);
    freq.put("rnå", 12);
    freq.put("Re ", 3);
    freq.put("Mil", 4);
    freq.put("jds", 11);
    freq.put("ngt", 28);
    freq.put("Min", 43);
    freq.put("q ", 4);
    freq.put("msu", 4);
    freq.put("mst", 16);
    freq.put("Ogs", 5);
    freq.put("msn", 3);
    freq.put("msl", 3);
    freq.put("msk", 4);
    freq.put("msi", 4);
    freq.put("Ude", 4);
    freq.put("mse", 3);
    freq.put("eco", 4);
    freq.put("Eve", 5);
    freq.put("Ud ", 3);
    freq.put("Og ", 75);
    freq.put("ms ", 15);
    freq.put(" on", 31);
    freq.put(" ol", 8);
    freq.put(" om", 272);
    freq.put(" ok", 29);
    freq.put(" oh", 4);
    freq.put("kyl", 34);
    freq.put(" of", 47);
    freq.put(" og", 960);
    freq.put(" od", 10);
    freq.put(" ob", 7);
    freq.put("Mid", 8);
    freq.put("kye", 4);
    freq.put("kyd", 8);
    freq.put(" ov", 173);
    freq.put(" ot", 3);
    freq.put(" ou", 4);
    freq.put(" or", 41);
    freq.put(" os", 46);
    freq.put(" op", 193);
    freq.put("dé ", 4);
    freq.put("msæ", 3);
    freq.put("Æ", 12);
    freq.put("ky ", 7);
    freq.put(" o ", 24);
    freq.put("lmi", 3);
    freq.put("dét", 4);
    freq.put("iPh", 16);
    freq.put("dér", 8);
    freq.put("gte", 57);
    freq.put("gti", 76);
    freq.put("gts", 4);
    freq.put("sht", 3);
    freq.put("dpr", 6);
    freq.put("gt ", 325);
    freq.put("vt ", 30);
    freq.put("ejl", 61);
    freq.put("ejd", 58);
    freq.put("eje", 64);
    freq.put("eja", 3);
    freq.put("ejt", 6);
    freq.put("ejr", 51);
    freq.put("ejs", 17);
    freq.put("ej ", 117);
    freq.put("åh ", 5);
    freq.put("præ", 18);
    freq.put("prø", 33);
    freq.put("iam", 5);
    freq.put("ial", 39);
    freq.put("ian", 41);
    freq.put("iaf", 5);
    freq.put("iac", 6);
    freq.put("iat", 10);
    freq.put("ias", 6);
    freq.put("iar", 4);
    freq.put("hul", 12);
    freq.put("hum", 17);
    freq.put("hun", 56);
    freq.put("huk", 3);
    freq.put("huu", 3);
    freq.put("hur", 18);
    freq.put("SE ", 4);
    freq.put("Mis", 3);
    freq.put(" Læ", 26);
    freq.put(" Lå", 3);
    freq.put("ia ", 37);
    freq.put("Mær", 5);
    freq.put("r", 17411);
    freq.put(" Lø", 31);
    freq.put("and", 490);
    freq.put("ane", 42);
    freq.put("anf", 3);
    freq.put("ang", 294);
    freq.put("pra", 5);
    freq.put("ana", 27);
    freq.put("anb", 10);
    freq.put("anc", 39);
    freq.put("anl", 8);
    freq.put("anm", 68);
    freq.put("ann", 39);
    freq.put("ano", 8);
    freq.put("pri", 61);
    freq.put("ani", 24);
    freq.put("ank", 52);
    freq.put("ant", 97);
    freq.put("anu", 9);
    freq.put("anv", 5);
    freq.put("ans", 230);
    freq.put("any", 8);
    freq.put(" L ", 7);
    freq.put("GO ", 3);
    freq.put("gko", 3);
    freq.put("gka", 9);
    freq.put("an ", 844);
    freq.put("pr ", 7);
    freq.put("lur", 4);
    freq.put(" Le", 29);
    freq.put(" La", 57);
    freq.put(" Lo", 39);
    freq.put(" Li", 67);
    freq.put(" Lu", 20);
    freq.put(" Ly", 18);
    freq.put("nlu", 4);
    freq.put("IP ", 4);
    freq.put("nla", 11);
    freq.put("rmæ", 3);
    freq.put("nli", 39);
    freq.put("dy ", 6);
    freq.put("ss ", 28);
    freq.put("Fyn", 5);
    freq.put("ssy", 6);
    freq.put("tk ", 5);
    freq.put("H", 834);
    freq.put("dyr", 13);
    freq.put("dys", 3);
    freq.put("ssl", 4);
    freq.put("sso", 9);
    freq.put("ssi", 33);
    freq.put("ssk", 3);
    freq.put("dyk", 4);
    freq.put("sse", 130);
    freq.put("dyg", 3);
    freq.put("ssa", 19);
    freq.put("rmt", 7);
    freq.put("rmu", 6);
    freq.put("nlø", 3);
    freq.put("rma", 42);
    freq.put("lni", 3);
    freq.put("nlæ", 6);
    freq.put("lne", 6);
    freq.put("rmi", 15);
    freq.put("rmo", 4);
    freq.put("rm ", 27);
    freq.put("pow", 3);
    freq.put("pot", 10);
    freq.put("por", 33);
    freq.put("pos", 27);
    freq.put("pop", 8);
    freq.put("pon", 19);
    freq.put("poo", 7);
    freq.put("pol", 32);
    freq.put("pok", 4);
    freq.put("poi", 3);
    freq.put("pod", 3);
    freq.put("poe", 3);
    freq.put("Bur", 9);
    freq.put("Bun", 3);
    freq.put("Et ", 22);
    freq.put("gå ", 25);
    freq.put("Bar", 26);
    freq.put("okt", 7);
    freq.put("yl", 80);
    freq.put("I ", 101);
    freq.put("går", 83);
    freq.put("dsh", 6);
    freq.put("gåe", 17);
    freq.put("Årh", 15);
    freq.put("Is", 17);
    freq.put("Ir", 6);
    freq.put("It", 7);
    freq.put("Iv", 3);
    freq.put("Ih", 4);
    freq.put("Ik", 21);
    freq.put("Im", 10);
    freq.put("Il", 3);
    freq.put("In", 64);
    freq.put("Ia", 3);
    freq.put("Ib", 3);
    freq.put("Id", 5);
    freq.put("Ig", 3);
    freq.put(" qu", 4);
    freq.put("tip", 8);
    freq.put("Ban", 12);
    freq.put("tir", 7);
    freq.put("tis", 128);
    freq.put("Bal", 6);
    freq.put("tim", 44);
    freq.put("tin", 83);
    freq.put("ES ", 8);
    freq.put("tid", 155);
    freq.put("tif", 8);
    freq.put("Tøm", 3);
    freq.put("røj", 6);
    freq.put("røm", 14);
    freq.put("Pin", 3);
    freq.put("røn", 22);
    freq.put("Pia", 9);
    freq.put("rød", 48);
    freq.put("røg", 4);
    freq.put("tia", 24);
    freq.put("rør", 8);
    freq.put("Tør", 3);
    freq.put("røv", 47);
    freq.put("Kun", 10);
    freq.put("Kul", 4);
    freq.put("gvi", 17);
    freq.put("o ", 380);
    freq.put("uTu", 3);
    freq.put("oo", 160);
    freq.put("on", 555);
    freq.put("om", 981);
    freq.put("ol", 540);
    freq.put("ok", 264);
    freq.put("oj", 16);
    freq.put("oi", 22);
    freq.put("oh", 23);
    freq.put("og", 1434);
    freq.put("of", 96);
    freq.put("oe", 75);
    freq.put("od", 562);
    freq.put("oc", 56);
    freq.put("ob", 131);
    freq.put("oa", 28);
    freq.put("oz", 7);
    freq.put("oy", 10);
    freq.put("ox", 13);
    freq.put("ow", 67);
    freq.put("ov", 374);
    freq.put("ou", 81);
    freq.put("ot", 122);
    freq.put("os", 204);
    freq.put("or", 2117);
    freq.put("op", 359);
    freq.put("LE ", 4);
    freq.put("rvæ", 6);
    freq.put("rvå", 3);
    freq.put("dø", 51);
    freq.put("FB ", 6);
    freq.put("Jul", 3);
    freq.put("ehu", 9);
    freq.put("EL ", 3);
    freq.put("igå", 8);
    freq.put("ehe", 20);
    freq.put("eha", 13);
    freq.put("eho", 18);
    freq.put("ehm", 3);
    freq.put("jud", 3);
    freq.put("jun", 4);
    freq.put("jul", 18);
    freq.put("jur", 3);
    freq.put("jus", 5);
    freq.put("eh ", 7);
    freq.put(" Ål", 3);
    freq.put("rva", 4);
    freq.put("rve", 56);
    freq.put("rvi", 20);
    freq.put("rvs", 8);
    freq.put(" Åh", 11);
    freq.put("igv", 16);
    freq.put("igu", 4);
    freq.put("igt", 298);
    freq.put("igs", 18);
    freq.put("ehø", 6);
    freq.put("igg", 52);
    freq.put("ige", 574);
    freq.put("iga", 22);
    freq.put("ign", 38);
    freq.put("igi", 11);
    freq.put("igh", 60);
    freq.put("rv ", 10);
    freq.put("ynd", 35);
    freq.put("hmm", 7);
    freq.put("ig ", 876);
    freq.put("alo", 6);
    freq.put("all", 166);
    freq.put("alm", 13);
    freq.put("alk", 11);
    freq.put("pti", 8);
    freq.put("ali", 50);
    freq.put("alg", 80);
    freq.put("ald", 136);
    freq.put("ale", 117);
    freq.put("alb", 30);
    freq.put("lly", 35);
    freq.put("pta", 6);
    freq.put("ala", 13);
    freq.put("aly", 9);
    freq.put("alv", 30);
    freq.put("alt", 150);
    freq.put("alu", 6);
    freq.put("Når", 18);
    freq.put("als", 22);
    freq.put("alp", 5);
    freq.put("far", 48);
    freq.put("fas", 16);
    freq.put("Nå ", 11);
    freq.put("pt ", 11);
    freq.put("fak", 34);
    freq.put("fai", 5);
    freq.put("fan", 79);
    freq.put("llu", 10);
    freq.put("fal", 63);
    freq.put("fam", 9);
    freq.put("æci", 10);
    freq.put("llt", 6);
    freq.put("fag", 5);
    freq.put("fad", 3);
    freq.put("fae", 4);
    freq.put(" Ni", 27);
    freq.put(" No", 78);
    freq.put(" Na", 26);
    freq.put(" Ne", 55);
    freq.put(" Ny", 38);
    freq.put(" Nu", 50);
    freq.put("tei", 3);
    freq.put("tek", 17);
    freq.put("tel", 51);
    freq.put("tem", 101);
    freq.put("ten", 230);
    freq.put("teo", 3);
    freq.put("tea", 9);
    freq.put("teb", 6);
    freq.put("tec", 3);
    freq.put("ted", 73);
    freq.put("tee", 9);
    freq.put("tef", 6);
    freq.put("teg", 33);
    freq.put("nbo", 3);
    freq.put("ptø", 4);
    freq.put("tep", 6);
    freq.put("nba", 9);
    freq.put("tes", 39);
    freq.put("tet", 125);
    freq.put("lla", 39);
    freq.put("tev", 6);
    freq.put("sug", 7);
    freq.put("sud", 3);
    freq.put("suc", 6);
    freq.put("sub", 3);
    freq.put("sun", 19);
    freq.put("sum", 3);
    freq.put("sul", 12);
    freq.put("suk", 5);
    freq.put("sus", 8);
    freq.put("sur", 19);
    freq.put("sup", 17);
    freq.put("te ", 601);
    freq.put("su ", 3);
    freq.put(" Nå", 32);
    freq.put(" Næ", 17);
    freq.put(" Nø", 8);
    freq.put("mmi", 5);
    freq.put("rkt", 10);
    freq.put("rku", 3);
    freq.put("rkr", 6);
    freq.put("rks", 28);
    freq.put("Tor", 9);
    freq.put("sbe", 7);
    freq.put("rke", 174);
    freq.put("rka", 10);
    freq.put("Tom", 4);
    freq.put("rkl", 15);
    freq.put("rkn", 7);
    freq.put("rko", 4);
    freq.put("rki", 3);
    freq.put("Å ", 15);
    freq.put("In ", 4);
    freq.put("Glæ", 17);
    freq.put("rk ", 83);
    freq.put("To ", 5);
    freq.put("Ål", 3);
    freq.put("Åh", 11);
    freq.put("Int", 6);
    freq.put("Inv", 4);
    freq.put("Ins", 9);
    freq.put("v", 4737);
    freq.put("Ind", 12);
    freq.put("Inf", 4);
    freq.put("Ing", 20);
    freq.put("År", 16);
    freq.put("rkø", 5);
    freq.put("rkæ", 3);
    freq.put("Glo", 4);
    freq.put("Gla", 3);
    freq.put("Gle", 5);
    freq.put("Akt", 10);
    freq.put("lhe", 3);
    freq.put("Åå", 3);
    freq.put("oy ", 5);
    freq.put(" sø", 107);
    freq.put("Er ", 102);
    freq.put(" sæ", 44);
    freq.put(" så", 438);
    freq.put("yn ", 16);
    freq.put("L", 340);
    freq.put("ksk", 3);
    freq.put("Eri", 6);
    freq.put("ynl", 3);
    freq.put("Rad", 6);
    freq.put("ynk", 3);
    freq.put("Ran", 4);
    freq.put("yne", 60);
    freq.put("Ram", 3);
    freq.put("Ras", 6);
    freq.put("ynt", 9);
    freq.put("yns", 4);
    freq.put(" sy", 88);
    freq.put("Mus", 5);
    freq.put(" sp", 207);
    freq.put(" sq", 4);
    freq.put(" sv", 69);
    freq.put(" sw", 3);
    freq.put(" st", 501);
    freq.put(" su", 64);
    freq.put(" sj", 31);
    freq.put(" sk", 606);
    freq.put(" sh", 16);
    freq.put(" si", 380);
    freq.put(" sn", 58);
    freq.put(" so", 325);
    freq.put(" sl", 82);
    freq.put(" sm", 96);
    freq.put(" sc", 17);
    freq.put(" sa", 243);
    freq.put(" sg", 25);
    freq.put(" se", 446);
    freq.put("ize", 4);
    freq.put("gur", 3);
    freq.put("ræ ", 3);
    freq.put("izz", 5);
    freq.put("koh", 3);
    freq.put("kok", 5);
    freq.put("kom", 194);
    freq.put(" s ", 52);
    freq.put("iz ", 8);
    freq.put("ræv", 5);
    freq.put("ræt", 30);
    freq.put("dår", 24);
    freq.put("kon", 82);
    freq.put("ræc", 10);
    freq.put("ræb", 4);
    freq.put("ræf", 12);
    freq.put("ræd", 15);
    freq.put("ræk", 30);
    freq.put("ræn", 44);
    freq.put("ræm", 7);
    freq.put("ræl", 13);
    freq.put("kob", 4);
    freq.put("sår", 5);
    freq.put("såd", 44);
    freq.put("æis", 6);
    freq.put("gpe", 3);
    freq.put("gpa", 3);
    freq.put("hæ ", 10);
    freq.put("efæ", 7);
    freq.put("kop", 6);
    freq.put(" ev", 25);
    freq.put("hær", 3);
    freq.put("hæv", 4);
    freq.put("hæh", 4);
    freq.put("hæl", 6);
    freq.put("hæn", 11);
    freq.put("åda", 61);
    freq.put("js ", 4);
    freq.put("ådg", 4);
    freq.put("åde", 50);
    freq.put("æs", 186);
    freq.put("ådt", 3);
    freq.put("efr", 5);
    freq.put("eft", 99);
    freq.put("efu", 9);
    freq.put("efi", 15);
    freq.put("efl", 8);
    freq.put("efo", 30);
    freq.put("efa", 17);
    freq.put("efe", 14);
    freq.put("eff", 4);
    freq.put("jse", 10);
    freq.put("åd ", 8);
    freq.put("jst", 4);
    freq.put("ef ", 4);
    freq.put("rte", 109);
    freq.put("rtf", 11);
    freq.put("rta", 12);
    freq.put("rto", 7);
    freq.put("rti", 65);
    freq.put("rtj", 5);
    freq.put("rtu", 6);
    freq.put("rtp", 7);
    freq.put("rts", 23);
    freq.put("rtr", 5);
    freq.put("rty", 5);
    freq.put("Ju", 18);
    freq.put("ies", 8);
    freq.put("ier", 76);
    freq.put("ieu", 3);
    freq.put("iet", 25);
    freq.put("iew", 5);
    freq.put("æm", 26);
    freq.put("Jo", 49);
    freq.put("iem", 5);
    freq.put("iel", 34);
    freq.put("ien", 42);
    freq.put("Je", 265);
    freq.put("ieb", 7);
    freq.put("Ja", 86);
    freq.put("ieg", 5);
    freq.put("hip", 12);
    freq.put("his", 23);
    freq.put("cd ", 3);
    freq.put("rt ", 272);
    freq.put("hic", 6);
    freq.put("hid", 3);
    freq.put("hil", 14);
    freq.put("him", 6);
    freq.put("hin", 21);
    freq.put("kæ", 79);
    freq.put(" På", 19);
    freq.put("ie ", 69);
    freq.put("J ", 15);
    freq.put("arp", 7);
    freq.put("arr", 16);
    freq.put("ars", 37);
    freq.put("art", 166);
    freq.put("arv", 12);
    freq.put("ara", 43);
    freq.put("arb", 59);
    freq.put("arc", 9);
    freq.put("ard", 41);
    freq.put("are", 279);
    freq.put("arf", 7);
    freq.put("arg", 9);
    freq.put("arh", 10);
    freq.put("ari", 42);
    freq.put("ark", 127);
    freq.put("arl", 19);
    freq.put("arm", 31);
    freq.put("arn", 18);
    freq.put("aro", 10);
    freq.put(" ån", 3);
    freq.put(" åh", 3);
    freq.put("al ", 351);
    freq.put(" åb", 22);
    freq.put(" P ", 17);
    freq.put(" år", 102);
    freq.put("uuu", 11);
    freq.put("ar ", 917);
    freq.put("fgh", 4);
    freq.put("fgi", 3);
    freq.put(" Pr", 43);
    freq.put("c", 942);
    freq.put(" Pu", 11);
    freq.put(" å ", 5);
    freq.put(" Pa", 53);
    freq.put(" Pe", 29);
    freq.put("ø", 1691);
    freq.put(" Pi", 17);
    freq.put(" Ph", 7);
    freq.put(" Po", 31);
    freq.put(" Pl", 15);
    freq.put("riø", 15);
    freq.put("pr", 267);
    freq.put("ps", 71);
    freq.put("pp", 124);
    freq.put("duk", 12);
    freq.put("dum", 17);
    freq.put("pt", 58);
    freq.put("pu", 54);
    freq.put("py", 7);
    freq.put("swe", 4);
    freq.put("due", 9);
    freq.put("pb", 7);
    freq.put("pc", 12);
    freq.put("pa", 201);
    freq.put("pf", 11);
    freq.put("pg", 17);
    freq.put("pd", 25);
    freq.put("pe", 393);
    freq.put("Fan", 10);
    freq.put("dur", 3);
    freq.put("pi", 201);
    freq.put("po", 157);
    freq.put("pl", 176);
    freq.put("pm", 5);
    freq.put("Emm", 3);
    freq.put("Fac", 26);
    freq.put("du ", 500);
    freq.put("p ", 287);
    freq.put("riv", 80);
    freq.put("rit", 45);
    freq.put("ris", 110);
    freq.put("rip", 9);
    freq.put("rin", 200);
    freq.put("Tim", 6);
    freq.put("ril", 22);
    freq.put("rim", 24);
    freq.put("rik", 56);
    freq.put("rii", 3);
    freq.put("rif", 12);
    freq.put("rig", 152);
    freq.put("rid", 12);
    freq.put("rie", 78);
    freq.put("rib", 15);
    freq.put("ric", 15);
    freq.put("ria", 16);
    freq.put("pø", 36);
    freq.put("pæ", 43);
    freq.put("på", 811);
    freq.put("Cop", 7);
    freq.put("Ill", 3);
    freq.put("Com", 11);
    freq.put("Col", 4);
    freq.put("ri ", 30);
    freq.put("Con", 7);
    freq.put("sød", 32);
    freq.put("søe", 5);
    freq.put("søg", 49);
    freq.put("søl", 4);
    freq.put("søn", 26);
    freq.put("sør", 6);
    freq.put("søs", 7);
    freq.put("søv", 7);
    freq.put("sø ", 3);
    freq.put("Air", 5);
    freq.put("Epi", 3);
    freq.put("zze", 3);
    freq.put("ylt", 3);
    freq.put("Rol", 6);
    freq.put("Rom", 5);
    freq.put("Roy", 3);
    freq.put("yld", 45);
    freq.put("yle", 8);
    freq.put("yll", 17);
    freq.put("Ros", 9);
    freq.put(" ut", 10);
    freq.put(" uv", 5);
    freq.put(" up", 22);
    freq.put(" ur", 3);
    freq.put(" us", 11);
    freq.put(" ul", 14);
    freq.put(" um", 5);
    freq.put(" un", 121);
    freq.put(" uh", 8);
    freq.put(" uk", 3);
    freq.put(" ud", 296);
    freq.put(" ue", 4);
    freq.put(" ug", 38);
    freq.put(" ua", 5);
    freq.put(" ub", 3);
    freq.put("grø", 8);
    freq.put("ixe", 8);
    freq.put("græ", 19);
    freq.put("grå", 4);
    freq.put("ixt", 3);
    freq.put(" u ", 7);
    freq.put(" Ky", 5);
    freq.put("å", 2860);
    freq.put("z", 75);
    freq.put("exi", 4);
    freq.put("gru", 29);
    freq.put("gre", 29);
    freq.put("gra", 83);
    freq.put("gro", 3);
    freq.put("gri", 32);
    freq.put("ctr", 3);
    freq.put("edb", 7);
    freq.put("åbe", 61);
    freq.put("eda", 65);
    freq.put("edg", 6);
    freq.put("edd", 26);
    freq.put("ede", 469);
    freq.put("åbl", 4);
    freq.put("edk", 4);
    freq.put("åbn", 12);
    freq.put("edi", 45);
    freq.put("edn", 8);
    freq.put("edo", 9);
    freq.put("edl", 17);
    freq.put("edm", 3);
    freq.put("edr", 55);
    freq.put("eds", 104);
    freq.put("edp", 4);
    freq.put("edv", 6);
    freq.put("edt", 43);
    freq.put("edu", 3);
    freq.put("edy", 3);
    freq.put("FF ", 4);
    freq.put("påv", 3);
    freq.put("pås", 3);
    freq.put("ed ", 892);
    freq.put("åb ", 3);
    freq.put("ugg", 4);
    freq.put("P", 317);
    freq.put("Gør", 5);
    freq.put("på ", 793);
    freq.put("rro", 10);
    freq.put("edæ", 3);
    freq.put("rri", 24);
    freq.put("rre", 89);
    freq.put("rra", 24);
    freq.put("rry", 11);
    freq.put("rrr", 8);
    freq.put("ugu", 8);
    freq.put("IG ", 4);
    freq.put("rr ", 6);
    freq.put("jl ", 14);
    freq.put("aps", 9);
    freq.put("app", 27);
    freq.put("Mik", 11);
    freq.put("apt", 3);
    freq.put("api", 4);
    freq.put("apa", 3);
    freq.put("æg ", 29);
    freq.put("ape", 9);
    freq.put("fed", 53);
    freq.put("fee", 7);
    freq.put("usc", 3);
    freq.put("kym", 4);
    freq.put("fea", 4);
    freq.put("fen", 27);
    freq.put("usm", 5);
    freq.put("usl", 7);
    freq.put("usk", 45);
    freq.put("fek", 10);
    freq.put("usi", 41);
    freq.put("fei", 4);
    freq.put("fet", 4);
    freq.put("ust", 44);
    freq.put("uss", 29);
    freq.put("fes", 38);
    freq.put("Hur", 5);
    freq.put("usp", 4);
    freq.put("Mic", 16);
    freq.put("Gud", 10);
    freq.put("ægt", 15);
    freq.put("Gul", 4);
    freq.put("Mig", 5);
    freq.put("æge", 13);
    freq.put("ap ", 17);
    freq.put("ægg", 17);
    freq.put(" Ru", 13);
    freq.put("fe ", 34);
    freq.put("us ", 99);
    freq.put(" Ry", 7);
    freq.put(" Re", 61);
    freq.put(" Ra", 24);
    freq.put(" Ro", 29);
    freq.put(" Ri", 19);
    freq.put("tat", 63);
    freq.put("tau", 6);
    freq.put("tav", 9);
    freq.put("tar", 65);
    freq.put("tas", 44);
    freq.put("tad", 53);
    freq.put("tae", 4);
    freq.put("tag", 125);
    freq.put("tab", 20);
    freq.put("tal", 110);
    freq.put("tam", 6);
    freq.put("tan", 56);
    freq.put("tai", 4);
    freq.put("tak", 36);
    freq.put("sis", 24);
    freq.put("kyp", 4);
    freq.put("siv", 8);
    freq.put("sit", 33);
    freq.put("Mit", 6);
    freq.put("sia", 7);
    freq.put("sig", 178);
    freq.put("sif", 3);
    freq.put("sie", 17);
    freq.put("sid", 138);
    freq.put("sik", 69);
    freq.put("dwi", 5);
    freq.put("sio", 31);
    freq.put("sin", 75);
    freq.put("sim", 18);
    freq.put("sil", 5);
    freq.put("ta ", 26);
    freq.put("Eks", 7);
    freq.put(" Rø", 9);
    freq.put(" Rå", 3);
    freq.put("si ", 12);
    freq.put("kbh", 5);
    freq.put("Hør", 4);
    freq.put(" Ær", 3);
    freq.put("kbr", 3);
    freq.put("bys", 4);
    freq.put("før", 124);
    freq.put("føl", 56);
    freq.put("føj", 4);
    freq.put("fød", 12);
    freq.put("byd", 6);
    freq.put("bye", 23);
    freq.put("Car", 13);
    freq.put("Can", 3);
    freq.put("Caf", 6);
    freq.put("Pre", 9);
    freq.put("nfe", 8);
    freq.put("nfo", 31);
    freq.put("Pro", 15);
    freq.put("Pri", 5);
    freq.put("nfi", 3);
    freq.put("nfr", 3);
    freq.put("soc", 14);
    freq.put("by ", 36);
    freq.put("oun", 8);
    freq.put("oul", 4);
    freq.put("ouc", 3);
    freq.put("ous", 3);
    freq.put("our", 18);
    freq.put("out", 20);
    freq.put("lt ", 198);
    freq.put("ouT", 3);
    freq.put("ou ", 9);
    freq.put("lts", 37);
    freq.put("ltr", 5);
    freq.put("Præ", 4);
    freq.put("g", 9316);
    freq.put("lta", 16);
    freq.put("lte", 35);
    freq.put("lti", 49);
    freq.put("lth", 12);
    freq.put("Prø", 10);
    freq.put("K ", 52);
    freq.put("Kb", 10);
    freq.put("Ka", 88);
    freq.put("Ke", 18);
    freq.put("Kj", 6);
    freq.put("Ki", 16);
    freq.put("Kh", 4);
    freq.put("Ko", 61);
    freq.put("Kn", 6);
    freq.put("Kl", 21);
    freq.put("Kr", 27);
    freq.put("Kv", 6);
    freq.put("Ku", 17);
    freq.put("Ky", 5);
    freq.put("Gå", 11);
    freq.put("ybr", 3);
    freq.put("ybo", 3);
    freq.put("JP ", 5);
    freq.put("Håb", 23);
    freq.put("Hål", 3);
    freq.put("hp", 4);
    freq.put("Kæ", 13);
    freq.put("whi", 4);
    freq.put("Rød", 7);
    freq.put("ht", 27);
    freq.put("Kø", 53);
    freq.put("Por", 3);
    freq.put("Pop", 3);
    freq.put("Pol", 18);
    freq.put("læd", 55);
    freq.put("læg", 45);
    freq.put("Cha", 6);
    freq.put("læn", 45);
    freq.put("læk", 22);
    freq.put("læs", 63);
    freq.put("lær", 41);
    freq.put("ebø", 4);
    freq.put("ha", 1169);
    freq.put("dlæ", 28);
    freq.put(" w ", 3);
    freq.put("eat", 24);
    freq.put("Jav", 3);
    freq.put("dlø", 5);
    freq.put(" we", 48);
    freq.put("qu", 13);
    freq.put(" wa", 5);
    freq.put(" wo", 15);
    freq.put(" wh", 5);
    freq.put(" wi", 18);
    freq.put(" ww", 5);
    freq.put("Jak", 3);
    freq.put("ebe", 15);
    freq.put("eba", 21);
    freq.put("ebb", 3);
    freq.put("ikr", 7);
    freq.put("ebl", 10);
    freq.put("ebo", 54);
    freq.put("ebi", 5);
    freq.put("jo ", 70);
    freq.put("ebu", 8);
    freq.put("ebr", 20);
    freq.put("ebs", 6);
    freq.put("dla", 12);
    freq.put("dle", 43);
    freq.put("dli", 44);
    freq.put("Jac", 5);
    freq.put("EF ", 3);
    freq.put("jor", 24);
    freq.put("eb ", 8);
    freq.put("jov", 19);
    freq.put("job", 20);
    freq.put("jok", 7);
    freq.put("rpr", 7);
    freq.put("rpe", 4);
    freq.put("rph", 3);
    freq.put("hm ", 3);
    freq.put("rpo", 7);
    freq.put("bbi", 3);
    freq.put("bbe", 21);
    freq.put("OB ", 9);
    freq.put("Jus", 7);
    freq.put("Juv", 4);
    freq.put("blo", 59);
    freq.put("tær", 29);
    freq.put("rp ", 4);
    freq.put("hmi", 6);
    freq.put(" Tø", 7);
    freq.put("é", 49);
    freq.put(" Tæ", 8);
    freq.put("tja", 4);
    freq.put("avs", 7);
    freq.put("AR ", 11);
    freq.put("avn", 87);
    freq.put("avo", 3);
    freq.put("avi", 8);
    freq.put("avd", 52);
    freq.put("ave", 198);
    freq.put("ava", 11);
    freq.put(" én", 17);
    freq.put(" T ", 6);
    freq.put("nog", 197);
    freq.put("av ", 19);
    freq.put(" Ty", 16);
    freq.put(" Tw", 25);
    freq.put(" Tv", 3);
    freq.put(" Tu", 12);
    freq.put(" Tr", 67);
    freq.put(" To", 40);
    freq.put(" Tj", 5);
    freq.put(" Ti", 38);
    freq.put(" Th", 52);
    freq.put(" Te", 23);
    freq.put(" Ta", 75);
    freq.put("mfo", 6);
    freq.put("mfu", 3);
    freq.put("tch", 6);
    freq.put("sku", 83);
    freq.put("skt", 4);
    freq.put("skv", 5);
    freq.put("skr", 135);
    freq.put("Far", 3);
    freq.put("sky", 58);
    freq.put("Fat", 3);
    freq.put("ske", 371);
    freq.put("Fak", 3);
    freq.put("ska", 333);
    freq.put("nor", 40);
    freq.put("Fal", 3);
    freq.put("skl", 10);
    freq.put("sko", 61);
    freq.put("ski", 49);
    freq.put("skj", 6);
    freq.put("Mod", 4);
    freq.put("T", 438);
    freq.put("sk ", 260);
    freq.put("Sun", 5);
    freq.put("Sus", 3);
    freq.put("Sur", 3);
    freq.put("Sup", 15);
    freq.put("nd ", 324);
    freq.put("skø", 10);
    freq.put("skæ", 21);
    freq.put("ndi", 52);
    freq.put("ndh", 17);
    freq.put("ndk", 6);
    freq.put("ndm", 8);
    freq.put("ndl", 51);
    freq.put("ndo", 25);
    freq.put("ndn", 30);
    freq.put("nda", 69);
    freq.put("ndb", 26);
    freq.put("nde", 868);
    freq.put("ndd", 3);
    freq.put("ndg", 6);
    freq.put("ndf", 8);
    freq.put("ndy", 3);
    freq.put("ndp", 3);
    freq.put("nds", 104);
    freq.put("ndr", 92);
    freq.put("ndu", 11);
    freq.put("ndt", 141);
    freq.put("ndw", 4);
    freq.put("ndv", 6);
    freq.put("own", 7);
    freq.put("owe", 14);
    freq.put("owa", 3);
    freq.put("ows", 6);
    freq.put("vak", 4);
    freq.put("van", 48);
    freq.put("val", 92);
    freq.put("vam", 3);
    freq.put("Ama", 15);
    freq.put("Amb", 3);
    freq.put("Ame", 3);
    freq.put("vag", 4);
    freq.put("vad", 133);
    freq.put("lv ", 65);
    freq.put("var", 260);
    freq.put("vas", 4);
    freq.put("vat", 14);
    freq.put("ö ", 3);
    freq.put("ea", 144);
    freq.put("ow ", 29);
    freq.put(" Æ ", 5);
    freq.put("lvt", 6);
    freq.put("Tel", 6);
    freq.put("Tem", 4);
    freq.put("lvs", 5);
    freq.put("Tea", 3);
    freq.put("va ", 26);
    freq.put("lve", 19);
    freq.put("lvd", 3);
    freq.put("lvf", 9);
    freq.put("lva", 6);
    freq.put("lvo", 6);
    freq.put("lvi", 4);
    freq.put("eu", 31);
    freq.put("myk", 3);
    freq.put("myn", 3);
    freq.put("myg", 3);
    freq.put("tår", 45);
    freq.put("Afr", 5);
    freq.put("EN ", 9);
    freq.put("my ", 10);
    freq.put("Mar", 25);
  }
  
}

