package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class DE {
  private static final String name = "de";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public DE() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2443013;
    n_words[1] = 2902212;
    n_words[2] = 2363399;

    freq.put("ße ", 536);
    freq.put("xtr", 108);
    freq.put("xte", 53);
    freq.put("ßen", 438);
    freq.put("ßes", 62);
    freq.put("ßer", 246);
    freq.put("xt ", 57);
    freq.put("fue", 75);
    freq.put("Jäh", 46);
    freq.put(" yo", 89);
    freq.put(" ya", 37);
    freq.put("k", 32760);
    freq.put(" ye", 28);
    freq.put("Lä", 98);
    freq.put("RL ", 26);
    freq.put("aul", 157);
    freq.put("Lö", 102);
    freq.put("Lü", 121);
    freq.put("dne", 106);
    freq.put("ht", 14436);
    freq.put("älf", 27);
    freq.put("dni", 34);
    freq.put("äll", 308);
    freq.put("dnu", 41);
    freq.put("aur", 136);
    freq.put("ält", 253);
    freq.put("Le", 1572);
    freq.put("La", 1100);
    freq.put("Lo", 423);
    freq.put("Li", 1373);
    freq.put("Lu", 362);
    freq.put("hof", 396);
    freq.put("hoe", 31);
    freq.put("hob", 47);
    freq.put("hoc", 233);
    freq.put("hon", 1986);
    freq.put("hoo", 78);
    freq.put("hol", 370);
    freq.put("hom", 52);
    freq.put("hok", 57);
    freq.put("hoh", 72);
    freq.put("how", 81);
    freq.put("hot", 239);
    freq.put("hor", 115);
    freq.put("hos", 113);
    freq.put("hop", 232);
    freq.put("A", 11593);
    freq.put("L ", 673);
    freq.put("Ö", 179);
    freq.put("ho ", 64);
    freq.put("DP ", 120);
    freq.put(" V ", 89);
    freq.put("AP ", 45);
    freq.put("fir", 33);
    freq.put("fis", 68);
    freq.put("Hir", 27);
    freq.put("Hit", 81);
    freq.put("fit", 53);
    freq.put("uot", 28);
    freq.put("fiz", 145);
    freq.put("rä", 1063);
    freq.put("fic", 117);
    freq.put("fia", 29);
    freq.put("Hie", 198);
    freq.put("Hig", 54);
    freq.put("fik", 55);
    freq.put("Hil", 147);
    freq.put("Him", 39);
    freq.put("Hin", 117);
    freq.put(" Va", 158);
    freq.put(" Ve", 1746);
    freq.put(" Vf", 35);
    freq.put(" Vi", 923);
    freq.put(" Vo", 1088);
    freq.put("Hi ", 35);
    freq.put("fi ", 113);
    freq.put("atü", 158);
    freq.put("mde", 44);
    freq.put("rt", 9368);
    freq.put("ru", 3869);
    freq.put("rv", 637);
    freq.put("rw", 1042);
    freq.put("rp", 591);
    freq.put("rr", 1929);
    freq.put("rs", 6577);
    freq.put("dst", 124);
    freq.put("ry", 327);
    freq.put("rz", 1816);
    freq.put("rd", 5227);
    freq.put("re", 16978);
    freq.put("rf", 1934);
    freq.put("rg", 4429);
    freq.put("ra", 10836);
    freq.put("rb", 2906);
    freq.put("rc", 1174);
    freq.put("rl", 2821);
    freq.put("rm", 2173);
    freq.put("sme", 60);
    freq.put("dse", 37);
    freq.put("rh", 1316);
    freq.put("ri", 8043);
    freq.put("rj", 47);
    freq.put("rk", 3082);
    freq.put("ial", 507);
    freq.put("md ", 40);
    freq.put(" Vö", 33);
    freq.put("Ega", 36);
    freq.put("ate", 1502);
    freq.put("atc", 74);
    freq.put("ata", 122);
    freq.put("ato", 147);
    freq.put("atl", 35);
    freq.put("atm", 45);
    freq.put("ath", 218);
    freq.put("ati", 1467);
    freq.put("att", 1168);
    freq.put("atu", 382);
    freq.put("r ", 55030);
    freq.put("ats", 346);
    freq.put("atz", 715);
    freq.put("ds ", 409);
    freq.put("füh", 505);
    freq.put("kfu", 159);
    freq.put("Dum", 33);
    freq.put("Dun", 36);
    freq.put("fün", 41);
    freq.put("füg", 75);
    freq.put("oße", 255);
    freq.put("oßa", 34);
    freq.put("Dur", 70);
    freq.put("für", 4093);
    freq.put("xib", 41);
    freq.put("Cen", 60);
    freq.put("xik", 26);
    freq.put("nz ", 847);
    freq.put("kno", 27);
    freq.put("Du ", 601);
    freq.put("oß ", 119);
    freq.put("nzw", 44);
    freq.put("nzu", 159);
    freq.put("nzt", 48);
    freq.put("nza", 48);
    freq.put("nze", 911);
    freq.put("fäh", 183);
    freq.put("nzi", 347);
    freq.put("iar", 74);
    freq.put("nzo", 25);
    freq.put("nzm", 38);
    freq.put("nzl", 98);
    freq.put("fäl", 317);
    freq.put("Son", 492);
    freq.put("Ass", 54);
    freq.put("Ast", 39);
    freq.put("fär", 30);
    freq.put("Sou", 62);
    freq.put("Asi", 27);
    freq.put("nen", 5256);
    freq.put("nel", 367);
    freq.put("knu", 25);
    freq.put("nzö", 35);
    freq.put("lpr", 39);
    freq.put("lpl", 26);
    freq.put("lpe", 47);
    freq.put("lpa", 40);
    freq.put("SE ", 59);
    freq.put("zte", 439);
    freq.put("X", 469);
    freq.put("oog", 271);
    freq.put("zt ", 2496);
    freq.put("Rin", 43);
    freq.put("Rie", 43);
    freq.put("Ric", 160);
    freq.put("PS ", 111);
    freq.put("irr", 101);
    freq.put("irs", 102);
    freq.put("irt", 276);
    freq.put("iru", 26);
    freq.put("iri", 88);
    freq.put("irk", 445);
    freq.put("irl", 75);
    freq.put("irm", 171);
    freq.put("irn", 81);
    freq.put("iro", 41);
    freq.put("ira", 250);
    freq.put("irb", 64);
    freq.put("irc", 124);
    freq.put("ird", 1145);
    freq.put("ire", 313);
    freq.put("irg", 394);
    freq.put("DM ", 42);
    freq.put("ir ", 4238);
    freq.put("and", 4062);
    freq.put("fra", 551);
    freq.put("fre", 889);
    freq.put("fri", 250);
    freq.put("fro", 103);
    freq.put("fru", 45);
    freq.put("ann", 4591);
    freq.put("anh", 49);
    freq.put("ää", 81);
    freq.put("ant", 916);
    freq.put("BC ", 26);
    freq.put("äß", 80);
    freq.put("BE ", 29);
    freq.put("bä", 129);
    freq.put("tzs", 41);
    freq.put("tzu", 231);
    freq.put("tzt", 2781);
    freq.put("Aff", 32);
    freq.put("bil", 586);
    freq.put("ä ", 60);
    freq.put("tzb", 49);
    freq.put("tze", 1306);
    freq.put("tzd", 141);
    freq.put("tzi", 114);
    freq.put("tzk", 33);
    freq.put("tzl", 108);
    freq.put("äne", 81);
    freq.put("änd", 570);
    freq.put("äng", 417);
    freq.put("dhe", 109);
    freq.put("änn", 147);
    freq.put("dha", 29);
    freq.put("big", 49);
    freq.put("frü", 204);
    freq.put("än", 1372);
    freq.put("äl", 647);
    freq.put("äm", 237);
    freq.put("äh", 1037);
    freq.put("äi", 27);
    freq.put("äf", 312);
    freq.put("äg", 377);
    freq.put("äd", 325);
    freq.put("äb", 48);
    freq.put("äc", 696);
    freq.put("tz ", 959);
    freq.put("ät", 1340);
    freq.put("äu", 803);
    freq.put("är", 1198);
    freq.put("äs", 567);
    freq.put("äp", 40);
    freq.put("ED ", 43);
    freq.put("hah", 515);
    freq.put("hai", 44);
    freq.put("hal", 1255);
    freq.put("ham", 129);
    freq.put("han", 532);
    freq.put("hao", 29);
    freq.put("haa", 61);
    freq.put("hab", 3079);
    freq.put("hac", 71);
    freq.put("had", 163);
    freq.put("hae", 67);
    freq.put("haf", 865);
    freq.put("bni", 117);
    freq.put("hap", 28);
    freq.put("har", 395);
    freq.put("has", 596);
    freq.put("hat", 2157);
    freq.put("hau", 1237);
    freq.put("bne", 34);
    freq.put("kön", 622);
    freq.put("ha ", 462);
    freq.put("Unb", 30);
    freq.put("DR ", 64);
    freq.put("ola", 196);
    freq.put("olc", 53);
    freq.put("old", 182);
    freq.put("ole", 273);
    freq.put("olf", 126);
    freq.put("olg", 629);
    freq.put("oli", 606);
    freq.put("olk", 142);
    freq.put("oll", 2916);
    freq.put("olo", 188);
    freq.put("ols", 89);
    freq.put("olt", 133);
    freq.put("olu", 139);
    freq.put("olv", 42);
    freq.put("olz", 133);
    freq.put("fot", 92);
    freq.put("umt", 65);
    freq.put("umw", 36);
    freq.put("ump", 130);
    freq.put("for", 755);
    freq.put("fos", 95);
    freq.put("umz", 33);
    freq.put("ume", 297);
    freq.put("umg", 89);
    freq.put("umf", 36);
    freq.put("uma", 83);
    freq.put("umb", 85);
    freq.put("fol", 574);
    freq.put("uml", 43);
    freq.put("fon", 184);
    freq.put("umi", 78);
    freq.put("ol ", 400);
    freq.put(" Xb", 26);
    freq.put("o", 75042);
    freq.put("fo ", 66);
    freq.put("um ", 3494);
    freq.put("mbl", 35);
    freq.put("Use", 52);
    freq.put("Fee", 25);
    freq.put("soe", 65);
    freq.put("mbi", 121);
    freq.put("sog", 121);
    freq.put("sof", 214);
    freq.put("Fen", 62);
    freq.put("mbe", 379);
    freq.put("Fel", 48);
    freq.put("som", 53);
    freq.put("sol", 1046);
    freq.put("Feh", 101);
    freq.put("Fei", 133);
    freq.put("Fet", 28);
    freq.put("Feu", 125);
    freq.put("Fer", 240);
    freq.put("Fes", 125);
    freq.put("sow", 250);
    freq.put("sov", 40);
    freq.put("mbu", 261);
    freq.put("soz", 74);
    freq.put("äls", 25);
    freq.put("mbH", 133);
    freq.put("az ", 26);
    freq.put("äst", 93);
    freq.put("äss", 220);
    freq.put("äsi", 75);
    freq.put("äse", 127);
    freq.put("äsc", 50);
    freq.put("so ", 3186);
    freq.put("azi", 157);
    freq.put("azo", 91);
    freq.put("azz", 25);
    freq.put("azu", 197);
    freq.put("Sir", 40);
    freq.put("Sit", 109);
    freq.put("Sic", 158);
    freq.put("Sie", 1055);
    freq.put("kha", 31);
    freq.put("khe", 34);
    freq.put("Sim", 66);
    freq.put("Sil", 94);
    freq.put("xkl", 39);
    freq.put("E", 8002);
    freq.put("Idi", 25);
    freq.put("Ide", 132);
    freq.put("koc", 64);
    freq.put("osp", 47);
    freq.put("oss", 292);
    freq.put("ost", 868);
    freq.put("osi", 136);
    freq.put("osh", 51);
    freq.put("osk", 30);
    freq.put("oso", 70);
    freq.put("osa", 41);
    freq.put("osc", 76);
    freq.put("ose", 478);
    freq.put("ögl", 157);
    freq.put("übe", 1691);
    freq.put("ves", 155);
    freq.put("öge", 90);
    freq.put("übs", 49);
    freq.put("übr", 134);
    freq.put("vea", 28);
    freq.put("ven", 325);
    freq.put("vel", 62);
    freq.put("vem", 93);
    freq.put("Mä", 281);
    freq.put("lre", 59);
    freq.put("Mö", 142);
    freq.put("Mü", 355);
    freq.put("Tat", 55);
    freq.put("Tau", 67);
    freq.put("Tar", 42);
    freq.put("Tas", 84);
    freq.put("Tag", 810);
    freq.put("Tab", 98);
    freq.put("Tal", 49);
    freq.put("tkr", 50);
    freq.put("Tan", 74);
    freq.put("RW ", 48);
    freq.put("ufh", 51);
    freq.put("M ", 549);
    freq.put("ufa", 46);
    freq.put("ufb", 68);
    freq.put("Me", 2322);
    freq.put("Ma", 2725);
    freq.put("Mc", 39);
    freq.put("Mo", 1571);
    freq.put("Mi", 1958);
    freq.put("Mu", 747);
    freq.put("uff", 110);
    freq.put("Mr", 33);
    freq.put("My", 47);
    freq.put("ipf", 38);
    freq.put("ipe", 51);
    freq.put("ipo", 35);
    freq.put("ipl", 45);
    freq.put("ips", 60);
    freq.put("ipp", 383);
    freq.put("Boa", 46);
    freq.put("ipz", 99);
    freq.put("ufs", 327);
    freq.put("uft", 730);
    freq.put("ip ", 103);
    freq.put("ßar", 30);
    freq.put("mba", 86);
    freq.put("sü", 220);
    freq.put("sö", 81);
    freq.put("Out", 58);
    freq.put("gze", 46);
    freq.put("TF ", 46);
    freq.put("ST ", 124);
    freq.put("Whi", 27);
    freq.put("sst", 1240);
    freq.put("s ", 36056);
    freq.put("ütt", 67);
    freq.put("sz", 254);
    freq.put("sy", 223);
    freq.put("ss", 10450);
    freq.put("sr", 378);
    freq.put("sp", 3075);
    freq.put("sw", 568);
    freq.put("sv", 250);
    freq.put("su", 1935);
    freq.put("st", 26342);
    freq.put("sk", 809);
    freq.put("sj", 38);
    freq.put("si", 8326);
    freq.put("sh", 976);
    freq.put("so", 6486);
    freq.put("sn", 173);
    freq.put("sm", 604);
    freq.put("sl", 702);
    freq.put("sc", 16795);
    freq.put("sb", 764);
    freq.put("sa", 3250);
    freq.put("sg", 680);
    freq.put("sf", 434);
    freq.put("se", 14405);
    freq.put("sd", 285);
    freq.put("tts", 46);
    freq.put("ttr", 42);
    freq.put("ttp", 143);
    freq.put("ttw", 76);
    freq.put("ttu", 100);
    freq.put("tti", 135);
    freq.put("tth", 29);
    freq.put("tto", 150);
    freq.put("ttl", 150);
    freq.put("ttb", 58);
    freq.put("tta", 240);
    freq.put("ttg", 129);
    freq.put("ttf", 35);
    freq.put("tte", 3716);
    freq.put("ähn", 120);
    freq.put("ähm", 25);
    freq.put("ähl", 271);
    freq.put("ähi", 57);
    freq.put("ähe", 83);
    freq.put("blö", 70);
    freq.put("ähr", 418);
    freq.put("Maß", 25);
    freq.put("tt ", 1219);
    freq.put("äh ", 40);
    freq.put("Jou", 28);
    freq.put("blu", 47);
    freq.put("Job", 203);
    freq.put("bli", 483);
    freq.put("Jog", 27);
    freq.put("Joh", 50);
    freq.put("bla", 213);
    freq.put("Jon", 30);
    freq.put(" gü", 71);
    freq.put("onj", 27);
    freq.put("onk", 57);
    freq.put("oni", 406);
    freq.put("onn", 802);
    freq.put("ono", 76);
    freq.put("onl", 201);
    freq.put("onm", 38);
    freq.put("ona", 541);
    freq.put("onf", 102);
    freq.put("ong", 162);
    freq.put("ond", 491);
    freq.put("one", 1023);
    freq.put("onz", 205);
    freq.put("ony", 102);
    freq.put("ons", 862);
    freq.put("onv", 27);
    freq.put("ont", 616);
    freq.put("eos", 87);
    freq.put("rz ", 432);
    freq.put("uku", 142);
    freq.put("ukt", 211);
    freq.put("Hmm", 48);
    freq.put("fme", 29);
    freq.put("fma", 40);
    freq.put(" Zo", 114);
    freq.put(" Zi", 331);
    freq.put(" Ze", 822);
    freq.put("ööö", 42);
    freq.put("on ", 7102);
    freq.put(" Za", 154);
    freq.put(" Zu", 770);
    freq.put(" Zw", 268);
    freq.put("rze", 561);
    freq.put("rzb", 33);
    freq.put("rza", 29);
    freq.put("rzl", 84);
    freq.put("rzi", 113);
    freq.put("rzw", 37);
    freq.put("rzu", 76);
    freq.put("rzt", 188);
    freq.put("Hm ", 38);
    freq.put("fm ", 75);
    freq.put("sak", 30);
    freq.put("sai", 30);
    freq.put("sah", 39);
    freq.put("san", 387);
    freq.put("sam", 662);
    freq.put("sal", 88);
    freq.put("sac", 196);
    freq.put("sab", 74);
    freq.put("sag", 877);
    freq.put("sad", 30);
    freq.put("sar", 80);
    freq.put("sau", 240);
    freq.put("sat", 287);
    freq.put("zoc", 30);
    freq.put("zog", 70);
    freq.put("Eck", 38);
    freq.put("zon", 122);
    freq.put("Ech", 52);
    freq.put("ax ", 113);
    freq.put("Öff", 29);
    freq.put("sa ", 124);
    freq.put(" Zü", 44);
    freq.put("rzä", 87);
    freq.put("axy", 41);
    freq.put("axi", 73);
    freq.put("wur", 499);
    freq.put("Sky", 53);
    freq.put("Ska", 42);
    freq.put("Ski", 26);
    freq.put("vid", 176);
    freq.put(" bä", 28);
    freq.put(" bö", 40);
    freq.put(" bü", 30);
    freq.put("up", 1115);
    freq.put("NE ", 125);
    freq.put(" b ", 85);
    freq.put("üll", 190);
    freq.put("üle", 56);
    freq.put("Awa", 32);
    freq.put("ült", 26);
    freq.put("rö", 578);
    freq.put("ool", 279);
    freq.put(" be", 6229);
    freq.put(" ba", 454);
    freq.put(" bl", 615);
    freq.put(" bo", 149);
    freq.put(" bi", 2990);
    freq.put(" bu", 140);
    freq.put("rü", 1787);
    freq.put("s", 135460);
    freq.put(" br", 772);
    freq.put(" by", 62);
    freq.put(" bz", 60);
    freq.put("ZT ", 36);
    freq.put("fig", 76);
    freq.put("fie", 138);
    freq.put("fin", 802);
    freq.put("fil", 166);
    freq.put("ive", 713);
    freq.put("iva", 207);
    freq.put("ivi", 188);
    freq.put("IR ", 39);
    freq.put("iv ", 249);
    freq.put("I", 7362);
    freq.put("Mar", 521);
    freq.put(" gr", 1080);
    freq.put("Düs", 76);
    freq.put("DI ", 36);
    freq.put("bür", 48);
    freq.put("uid", 30);
    freq.put("SV ", 92);
    freq.put("Prä", 71);
    freq.put("gd ", 26);
    freq.put("Mak", 34);
    freq.put(" gi", 898);
    freq.put("ezu", 25);
    freq.put("ezw", 29);
    freq.put("ezo", 57);
    freq.put("ezi", 199);
    freq.put("tve", 81);
    freq.put("eze", 258);
    freq.put("eza", 69);
    freq.put("ac ", 83);
    freq.put("ddi", 36);
    freq.put("´", 93);
    freq.put("dda", 82);
    freq.put("dde", 140);
    freq.put("Än", 26);
    freq.put("ez ", 46);
    freq.put("tv ", 44);
    freq.put("acc", 31);
    freq.put("ace", 455);
    freq.put("ack", 931);
    freq.put("ach", 7160);
    freq.put("act", 54);
    freq.put("Ni", 611);
    freq.put("bje", 27);
    freq.put("No", 756);
    freq.put("uil", 28);
    freq.put("Na", 1663);
    freq.put("Ne", 1843);
    freq.put("Nr", 40);
    freq.put("Nu", 438);
    freq.put("het", 50);
    freq.put("heu", 1281);
    freq.put("her", 2858);
    freq.put("hes", 376);
    freq.put("hey", 52);
    freq.put("hee", 44);
    freq.put("hef", 198);
    freq.put("hea", 53);
    freq.put("heb", 65);
    freq.put("hec", 153);
    freq.put("hel", 373);
    freq.put("hem", 527);
    freq.put("hen", 6806);
    freq.put("heo", 41);
    freq.put("heh", 62);
    freq.put("hei", 2524);
    freq.put("aß", 442);
    freq.put("hek", 67);
    freq.put("N ", 936);
    freq.put("Möb", 27);
    freq.put("Mög", 37);
    freq.put("he ", 3883);
    freq.put("Hof", 156);
    freq.put("ac", 8845);
    freq.put("ab", 8380);
    freq.put("Hob", 56);
    freq.put("Hoc", 134);
    freq.put("ag", 6334);
    freq.put("af", 2485);
    freq.put("ai", 1218);
    freq.put("ah", 4312);
    freq.put("Hol", 159);
    freq.put("aj", 261);
    freq.put("Nä", 90);
    freq.put("al", 14239);
    freq.put("Hoh", 32);
    freq.put("an", 22464);
    freq.put("aq", 25);
    freq.put("ap", 1209);
    freq.put("as", 14565);
    freq.put("ar", 11367);
    freq.put("Nü", 66);
    freq.put("at", 8997);
    freq.put("aw", 163);
    freq.put("av", 537);
    freq.put("ay", 968);
    freq.put("ax", 259);
    freq.put("az", 544);
    freq.put("ohr", 52);
    freq.put("a ", 8871);
    freq.put("oh ", 210);
    freq.put("agu", 65);
    freq.put("at ", 2386);
    freq.put("AZ ", 37);
    freq.put("uit", 52);
    freq.put("smu", 135);
    freq.put("Fir", 117);
    freq.put("Fis", 60);
    freq.put("sco", 75);
    freq.put("sch", 16591);
    freq.put("Fit", 34);
    freq.put("sca", 33);
    freq.put("mni", 62);
    freq.put(" a", 22280);
    freq.put("dsp", 26);
    freq.put("Fin", 270);
    freq.put("Fil", 232);
    freq.put("scr", 29);
    freq.put("smo", 41);
    freq.put("zmi", 31);
    freq.put("tz", 6099);
    freq.put("ty", 393);
    freq.put("tv", 157);
    freq.put("tw", 1488);
    freq.put("tt", 6456);
    freq.put("tu", 3623);
    freq.put("tr", 4633);
    freq.put("ts", 5409);
    freq.put("tp", 399);
    freq.put("tn", 340);
    freq.put("to", 3453);
    freq.put("tl", 1811);
    freq.put("tm", 585);
    freq.put("tj", 64);
    freq.put("tk", 194);
    freq.put("th", 1289);
    freq.put("ti", 8620);
    freq.put("tf", 443);
    freq.put("tg", 514);
    freq.put("td", 266);
    freq.put("te", 33338);
    freq.put("tb", 476);
    freq.put("tc", 263);
    freq.put("ta", 6736);
    freq.put("smi", 113);
    freq.put("Wäh", 63);
    freq.put("sc ", 35);
    freq.put("Wär", 93);
    freq.put("rn", 4865);
    freq.put("ro", 5362);
    freq.put("eiw", 43);
    freq.put("dsc", 139);
    freq.put("sma", 185);
    freq.put("t ", 57472);
    freq.put("mnä", 33);
    freq.put("Sma", 84);
    freq.put("tü", 620);
    freq.put("tö", 178);
    freq.put("tä", 767);
    freq.put("vic", 117);
    freq.put("Auc", 152);
    freq.put("via", 481);
    freq.put("Aud", 39);
    freq.put("Aug", 259);
    freq.put("Auf", 643);
    freq.put("vin", 44);
    freq.put("vil", 48);
    freq.put("vir", 29);
    freq.put("vis", 67);
    freq.put("Aus", 653);
    freq.put("Aut", 405);
    freq.put("vit", 63);
    freq.put("kl ", 66);
    freq.put("ünk", 27);
    freq.put("üne", 124);
    freq.put("ünd", 320);
    freq.put("üng", 38);
    freq.put("ünf", 107);
    freq.put("ünc", 203);
    freq.put(" d ", 148);
    freq.put("VE ", 30);
    freq.put("üns", 463);
    freq.put("vi ", 27);
    freq.put(" do", 1332);
    freq.put("kle", 527);
    freq.put("kla", 477);
    freq.put(" di", 9153);
    freq.put(" de", 13881);
    freq.put("klo", 38);
    freq.put("ün ", 53);
    freq.put(" da", 10255);
    freq.put("klu", 169);
    freq.put(" du", 2773);
    freq.put(" dr", 862);
    freq.put(" dp", 48);
    freq.put("atr", 77);
    freq.put("Auß", 85);
    freq.put("klä", 140);
    freq.put(" dü", 100);
    freq.put("itn", 71);
    freq.put("ito", 53);
    freq.put("IP ", 40);
    freq.put("itm", 62);
    freq.put("itk", 28);
    freq.put("ith", 61);
    freq.put("Dui", 29);
    freq.put("itg", 136);
    freq.put("ite", 2450);
    freq.put("itb", 82);
    freq.put("itc", 36);
    freq.put("ita", 643);
    freq.put("itz", 770);
    freq.put("ity", 133);
    freq.put("itt", 2143);
    freq.put("itu", 354);
    freq.put("itr", 134);
    freq.put("its", 650);
    freq.put("itp", 39);
    freq.put("fül", 71);
    freq.put("hze", 78);
    freq.put("swo", 30);
    freq.put("UR ", 187);
    freq.put("̶", 60);
    freq.put("it ", 6949);
    freq.put(" A ", 245);
    freq.put("MG ", 40);
    freq.put("itä", 283);
    freq.put("fts", 226);
    freq.put("Dus", 61);
    freq.put("ftu", 64);
    freq.put("ftw", 105);
    freq.put("fta", 54);
    freq.put("fte", 408);
    freq.put("kna", 104);
    freq.put("fti", 154);
    freq.put("ftl", 58);
    freq.put(" Aa", 47);
    freq.put(" Ab", 1344);
    freq.put(" Ac", 402);
    freq.put(" Ad", 194);
    freq.put(" Af", 72);
    freq.put(" Ag", 70);
    freq.put(" Ah", 153);
    freq.put(" Ai", 79);
    freq.put(" Ak", 300);
    freq.put(" Al", 1396);
    freq.put(" Am", 502);
    freq.put(" An", 1605);
    freq.put(" Ap", 479);
    freq.put(" Ar", 978);
    freq.put(" As", 171);
    freq.put(" At", 149);
    freq.put(" Au", 2278);
    freq.put(" Av", 48);
    freq.put(" Aw", 51);
    freq.put(" Ax", 26);
    freq.put("NG ", 131);
    freq.put("ft ", 1749);
    freq.put("w", 32238);
    freq.put("HD ", 52);
    freq.put("uem", 31);
    freq.put("Fra", 875);
    freq.put("Fre", 793);
    freq.put("uel", 345);
    freq.put("Fri", 209);
    freq.put("Fro", 54);
    freq.put("bhä", 35);
    freq.put("KE ", 55);
    freq.put("Fru", 25);
    freq.put("aa ", 153);
    freq.put("jet", 1574);
    freq.put("ädt", 51);
    freq.put("ädi", 38);
    freq.put("xis", 63);
    freq.put("jed", 467);
    freq.put("ädc", 99);
    freq.put("jek", 171);
    freq.put("dfa", 34);
    freq.put("äde", 103);
    freq.put("jem", 288);
    freq.put("Zwi", 78);
    freq.put("Zwa", 27);
    freq.put("Zwe", 153);
    freq.put("aaa", 412);
    freq.put("tsd", 58);
    freq.put("aab", 28);
    freq.put("aal", 44);
    freq.put("aan", 47);
    freq.put("aah", 48);
    freq.put("aat", 163);
    freq.put("je ", 76);
    freq.put("äßi", 52);
    freq.put("aar", 403);
    freq.put("bho", 29);
    freq.put("bha", 35);
    freq.put("uet", 52);
    freq.put("Frü", 114);
    freq.put("ex ", 274);
    freq.put("tp ", 135);
    freq.put("hge", 133);
    freq.put("kür", 54);
    freq.put("Isr", 26);
    freq.put("M", 11002);
    freq.put("Ist", 257);
    freq.put("kün", 108);
    freq.put("küh", 43);
    freq.put("tpa", 39);
    freq.put("exa", 40);
    freq.put("tpl", 57);
    freq.put("exk", 25);
    freq.put("exi", 103);
    freq.put("ext", 183);
    freq.put("exu", 37);
    freq.put("tpr", 32);
    freq.put("exp", 58);
    freq.put("exy", 41);
    freq.put("Hah", 95);
    freq.put("ugi", 31);
    freq.put("ugh", 62);
    freq.put("Hal", 432);
    freq.put("Ham", 288);
    freq.put("Han", 492);
    freq.put("ugl", 38);
    freq.put("Haa", 110);
    freq.put("Hab", 445);
    freq.put("Hac", 78);
    freq.put("ugg", 50);
    freq.put("Haf", 46);
    freq.put("Hag", 27);
    freq.put("ugz", 30);
    freq.put("oje", 157);
    freq.put("oja", 41);
    freq.put("Hap", 28);
    freq.put("ugr", 31);
    freq.put("Har", 167);
    freq.put("Has", 133);
    freq.put("Hat", 169);
    freq.put("Hau", 439);
    freq.put("ugu", 121);
    freq.put("ugt", 55);
    freq.put("rf ", 396);
    freq.put("ug ", 421);
    freq.put("rfs", 38);
    freq.put("rfr", 86);
    freq.put("rfu", 69);
    freq.put("rft", 79);
    freq.put("rfa", 283);
    freq.put("cra", 58);
    freq.put("rfe", 382);
    freq.put("cre", 61);
    freq.put("rfi", 54);
    freq.put("rfo", 294);
    freq.put("cro", 68);
    freq.put("rfl", 62);
    freq.put("Fot", 312);
    freq.put("seu", 86);
    freq.put("set", 447);
    freq.put("ses", 368);
    freq.put("ser", 2076);
    freq.put("For", 296);
    freq.put("sep", 47);
    freq.put("sex", 84);
    freq.put("see", 148);
    freq.put("Umf", 48);
    freq.put("sec", 51);
    freq.put("seb", 37);
    freq.put("Fol", 224);
    freq.put("sen", 3735);
    freq.put("sem", 208);
    freq.put("sel", 1077);
    freq.put("sek", 47);
    freq.put("sei", 1753);
    freq.put("seh", 1369);
    freq.put("pd ", 32);
    freq.put("ue ", 894);
    freq.put("Um ", 48);
    freq.put("se ", 2641);
    freq.put("rfü", 106);
    freq.put("pda", 120);
    freq.put("lex", 140);
    freq.put("ml ", 34);
    freq.put("tiv", 640);
    freq.put("xan", 27);
    freq.put("nri", 56);
    freq.put("nro", 25);
    freq.put("nra", 48);
    freq.put("nre", 129);
    freq.put("nru", 74);
    freq.put("Old", 39);
    freq.put("mle", 28);
    freq.put("Oli", 37);
    freq.put("mli", 163);
    freq.put(" fü", 4114);
    freq.put(" fä", 205);
    freq.put("mlu", 43);
    freq.put("ami", 528);
    freq.put("vol", 488);
    freq.put("vom", 467);
    freq.put("von", 3247);
    freq.put("vor", 1648);
    freq.put("So ", 455);
    freq.put("ühs", 77);
    freq.put("ühr", 313);
    freq.put(" f ", 46);
    freq.put("ühe", 144);
    freq.put("ühn", 28);
    freq.put("ühl", 408);
    freq.put("vo ", 43);
    freq.put("ame", 823);
    freq.put("WS ", 26);
    freq.put("Soc", 109);
    freq.put(" fr", 1280);
    freq.put(" fu", 313);
    freq.put("Sof", 131);
    freq.put("Soh", 36);
    freq.put("kne", 51);
    freq.put("Som", 124);
    freq.put("Sol", 193);
    freq.put("fän", 93);
    freq.put(" fa", 833);
    freq.put("Sor", 99);
    freq.put(" fe", 655);
    freq.put("üh ", 77);
    freq.put(" fi", 728);
    freq.put("Soz", 48);
    freq.put(" fl", 216);
    freq.put(" fo", 471);
    freq.put("O ", 569);
    freq.put("Übe", 293);
    freq.put("ß", 3543);
    freq.put("Oo", 38);
    freq.put("On", 391);
    freq.put("Om", 52);
    freq.put("Ol", 119);
    freq.put("Ok", 260);
    freq.put("Oh", 380);
    freq.put("Of", 119);
    freq.put("Oe", 27);
    freq.put("Od", 135);
    freq.put("Oc", 35);
    freq.put("Ob", 251);
    freq.put("bö", 84);
    freq.put("tsa", 178);
    freq.put("bü", 134);
    freq.put("Ou", 69);
    freq.put("Ot", 25);
    freq.put("Os", 152);
    freq.put("Or", 269);
    freq.put("Op", 223);
    freq.put("sön", 63);
    freq.put("d", 88175);
    freq.put("IV ", 37);
    freq.put("bd", 52);
    freq.put("be", 21832);
    freq.put("bf", 65);
    freq.put("bg", 312);
    freq.put("ba", 2511);
    freq.put("bb", 305);
    freq.put("bc", 54);
    freq.put("bl", 1820);
    freq.put("bm", 43);
    freq.put("bn", 173);
    freq.put("bo", 1443);
    freq.put("bh", 116);
    freq.put("bi", 4332);
    freq.put("bj", 41);
    freq.put("bk", 52);
    freq.put("bt", 1648);
    freq.put("bu", 1632);
    freq.put("bw", 170);
    freq.put("br", 1832);
    freq.put("bs", 1556);
    freq.put("by", 308);
    freq.put("bz", 144);
    freq.put("Fu", 463);
    freq.put("bH", 134);
    freq.put("Ost", 96);
    freq.put("DE ", 85);
    freq.put(" C ", 171);
    freq.put("afü", 185);
    freq.put("fzu", 34);
    freq.put("u ", 8177);
    freq.put("fze", 43);
    freq.put("Fe", 958);
    freq.put(" Ch", 752);
    freq.put(" Ci", 85);
    freq.put(" Co", 828);
    freq.put(" Cl", 206);
    freq.put("uT", 57);
    freq.put(" Ca", 465);
    freq.put(" Ce", 92);
    freq.put(" Cr", 119);
    freq.put(" Cu", 60);
    freq.put("cia", 166);
    freq.put("AC ", 35);
    freq.put("ux", 91);
    freq.put("uz", 231);
    freq.put("uu", 328);
    freq.put("ut", 8706);
    freq.put("uw", 55);
    freq.put("uv", 87);
    freq.put("cin", 31);
    freq.put("us", 9231);
    freq.put("ur", 8066);
    freq.put("um", 5227);
    freq.put("ul", 1670);
    freq.put("uo", 58);
    freq.put("un", 21668);
    freq.put("ui", 386);
    freq.put("uh", 767);
    freq.put("uk", 460);
    freq.put("ue", 4188);
    freq.put("ud", 815);
    freq.put("ug", 1586);
    freq.put("uf", 7334);
    freq.put("ua", 531);
    freq.put("uc", 7002);
    freq.put("ub", 1511);
    freq.put("äml", 52);
    freq.put("KG ", 29);
    freq.put("Zu ", 71);
    freq.put("EZ ", 55);
    freq.put("tic", 190);
    freq.put("äft", 252);
    freq.put("ag ", 2163);
    freq.put("äfe", 33);
    freq.put("Zur", 52);
    freq.put("Zus", 150);
    freq.put("uß", 561);
    freq.put("pfl", 135);
    freq.put("Zuc", 30);
    freq.put("Zug", 123);
    freq.put("Zuk", 105);
    freq.put("Zuh", 41);
    freq.put("Zum", 105);
    freq.put("ago", 61);
    freq.put("agn", 83);
    freq.put("agi", 110);
    freq.put("agg", 66);
    freq.put("age", 2582);
    freq.put("agd", 53);
    freq.put("aga", 147);
    freq.put("uis", 70);
    freq.put("agt", 547);
    freq.put("ags", 295);
    freq.put("tr ", 42);
    freq.put("b ", 3709);
    freq.put("tri", 781);
    freq.put("evi", 106);
    freq.put("tro", 718);
    freq.put("evo", 144);
    freq.put("tra", 1443);
    freq.put("eva", 45);
    freq.put("tre", 1057);
    freq.put("eve", 242);
    freq.put("tru", 230);
    freq.put("le ", 3726);
    freq.put("ody", 31);
    freq.put("uen", 975);
    freq.put("Blu", 144);
    freq.put("ued", 60);
    freq.put("odu", 192);
    freq.put("uec", 33);
    freq.put("ueb", 34);
    freq.put("odi", 51);
    freq.put("Blo", 357);
    freq.put("Bli", 145);
    freq.put("odo", 27);
    freq.put("oda", 69);
    freq.put("odc", 26);
    freq.put("Bla", 142);
    freq.put("ode", 1659);
    freq.put("ues", 379);
    freq.put("uer", 1303);
    freq.put("ct ", 62);
    freq.put("rd ", 1614);
    freq.put("sur", 84);
    freq.put("leb", 410);
    freq.put("lec", 426);
    freq.put("led", 55);
    freq.put("lee", 109);
    freq.put("lef", 187);
    freq.put("leg", 592);
    freq.put("leh", 91);
    freq.put("lei", 2724);
    freq.put("lek", 193);
    freq.put("lel", 29);
    freq.put("lem", 436);
    freq.put("len", 2992);
    freq.put("lep", 30);
    freq.put("ler", 1946);
    freq.put("les", 1371);
    freq.put("let", 678);
    freq.put("leu", 131);
    freq.put("lev", 57);
    freq.put("od ", 156);
    freq.put("ley", 56);
    freq.put("rdw", 29);
    freq.put("rds", 132);
    freq.put("rdr", 70);
    freq.put("trä", 281);
    freq.put("rde", 2519);
    freq.put("rda", 154);
    freq.put("trü", 29);
    freq.put("rdb", 49);
    freq.put("rdo", 58);
    freq.put("rdn", 96);
    freq.put("rdi", 335);
    freq.put("cti", 77);
    freq.put("trö", 31);
    freq.put("pf ", 265);
    freq.put("sgr", 44);
    freq.put("tdr", 25);
    freq.put("sga", 55);
    freq.put("sge", 517);
    freq.put("zit", 62);
    freq.put("Cla", 52);
    freq.put("zis", 67);
    freq.put("zip", 35);
    freq.put("zig", 330);
    freq.put("zie", 750);
    freq.put("zic", 31);
    freq.put("zia", 183);
    freq.put("zin", 194);
    freq.put("zil", 32);
    freq.put("zim", 92);
    freq.put("pfa", 40);
    freq.put("pfe", 502);
    freq.put("pfi", 51);
    freq.put("pfh", 35);
    freq.put("häu", 74);
    freq.put("pfs", 43);
    freq.put("hät", 357);
    freq.put("pfu", 25);
    freq.put("pft", 76);
    freq.put("häs", 29);
    freq.put("här", 40);
    freq.put(" Dü", 95);
    freq.put("zi ", 45);
    freq.put("tüc", 164);
    freq.put("tür", 283);
    freq.put("tüt", 116);
    freq.put("npl", 49);
    freq.put("npo", 49);
    freq.put("npf", 42);
    freq.put("npa", 94);
    freq.put("Q", 326);
    freq.put("hän", 167);
    freq.put("npr", 60);
    freq.put("ot", 3566);
    freq.put("Yo", 190);
    freq.put("Onl", 317);
    freq.put("One", 29);
    freq.put("Ye", 60);
    freq.put("lz ", 138);
    freq.put(" h ", 213);
    freq.put("lzi", 28);
    freq.put("lze", 150);
    freq.put("Höh", 56);
    freq.put("Sai", 51);
    freq.put("San", 128);
    freq.put("Sam", 262);
    freq.put("Sal", 91);
    freq.put("Sac", 205);
    freq.put("Saa", 64);
    freq.put("Sag", 68);
    freq.put(" hu", 122);
    freq.put(" ht", 202);
    freq.put(" hi", 1309);
    freq.put(" ho", 720);
    freq.put(" hm", 96);
    freq.put("Sar", 57);
    freq.put(" ha", 6673);
    freq.put("Hör", 48);
    freq.put(" he", 2222);
    freq.put("Sat", 101);
    freq.put("pür", 26);
    freq.put("Ris", 31);
    freq.put(" hü", 63);
    freq.put(" hö", 317);
    freq.put(" hä", 489);
    freq.put("ihr", 961);
    freq.put("IT ", 129);
    freq.put("ihi", 92);
    freq.put("ihn", 342);
    freq.put("ihm", 109);
    freq.put("iha", 28);
    freq.put("ihe", 138);
    freq.put("Tät", 33);
    freq.put(" E ", 211);
    freq.put("ck ", 1780);
    freq.put("SL ", 31);
    freq.put(" El", 300);
    freq.put(" Em", 174);
    freq.put(" En", 910);
    freq.put(" Eh", 96);
    freq.put(" Ei", 1720);
    freq.put(" Ed", 116);
    freq.put(" Ef", 32);
    freq.put(" Eg", 46);
    freq.put(" Ea", 32);
    freq.put(" Eb", 48);
    freq.put(" Ec", 105);
    freq.put(" Ex", 311);
    freq.put(" Ey", 34);
    freq.put(" Et", 47);
    freq.put(" Eu", 773);
    freq.put(" Ev", 76);
    freq.put(" Ep", 25);
    freq.put(" Er", 1293);
    freq.put(" Es", 696);
    freq.put("cke", 2040);
    freq.put("ckg", 44);
    freq.put("ckf", 63);
    freq.put("cka", 55);
    freq.put("AA ", 30);
    freq.put("ckb", 39);
    freq.put("ckm", 30);
    freq.put("ckl", 303);
    freq.put("cki", 120);
    freq.put("ckh", 27);
    freq.put("ckk", 36);
    freq.put("cku", 56);
    freq.put("ckt", 729);
    freq.put("ckw", 97);
    freq.put("cks", 315);
    freq.put("ckr", 25);
    freq.put("szi", 53);
    freq.put("dbl", 30);
    freq.put("dba", 95);
    freq.put("dbe", 77);
    freq.put("sze", 113);
    freq.put("dbr", 25);
    freq.put("szu", 40);
    freq.put("jap", 28);
    freq.put("jan", 55);
    freq.put("jam", 26);
    freq.put("jah", 126);
    freq.put("jag", 32);
    freq.put("jac", 31);
    freq.put("jaa", 80);
    freq.put("aer", 30);
    freq.put("aet", 28);
    freq.put("gba", 53);
    freq.put("h", 116711);
    freq.put("ael", 87);
    freq.put("ja ", 2103);
    freq.put("aen", 36);
    freq.put("Pr", 1840);
    freq.put("Ps", 49);
    freq.put("bts", 117);
    freq.put("Pu", 327);
    freq.put("oma", 283);
    freq.put("bte", 79);
    freq.put("Pa", 1377);
    freq.put("OP ", 37);
    freq.put("Pe", 466);
    freq.put("Ph", 401);
    freq.put("Pi", 417);
    freq.put("bti", 31);
    freq.put("Po", 1032);
    freq.put("Pl", 559);
    freq.put("et ", 2517);
    freq.put("tl ", 70);
    freq.put("lf", 839);
    freq.put("eul", 80);
    freq.put("tsl", 55);
    freq.put("P ", 634);
    freq.put("le", 16585);
    freq.put("bt ", 1340);
    freq.put("tsk", 91);
    freq.put("etr", 515);
    freq.put("ets", 288);
    freq.put("etw", 411);
    freq.put("ett", 1425);
    freq.put("etu", 30);
    freq.put("etz", 3094);
    freq.put("tsi", 40);
    freq.put("etb", 34);
    freq.put("ln", 854);
    freq.put("tla", 91);
    freq.put("eta", 263);
    freq.put("tle", 318);
    freq.put("lo", 3272);
    freq.put("eth", 74);
    freq.put("eti", 242);
    freq.put("tlo", 70);
    freq.put("eto", 56);
    freq.put("ck", 5993);
    freq.put("Heu", 396);
    freq.put("ci", 292);
    freq.put("lm", 628);
    freq.put("co", 873);
    freq.put("cm", 78);
    freq.put("cl", 116);
    freq.put("cc", 225);
    freq.put("tsb", 59);
    freq.put("lg ", 95);
    freq.put("Hey", 66);
    freq.put("ce", 1092);
    freq.put("tsc", 1933);
    freq.put("cy", 28);
    freq.put("Hea", 38);
    freq.put("vö", 71);
    freq.put("cs", 69);
    freq.put("cr", 235);
    freq.put("Hen", 25);
    freq.put("eub", 25);
    freq.put("uck", 764);
    freq.put("Hei", 341);
    freq.put("cu", 112);
    freq.put("ct", 222);
    freq.put("Ges", 713);
    freq.put("lv", 188);
    freq.put("Gew", 279);
    freq.put("Get", 38);
    freq.put("Geb", 232);
    freq.put("Geg", 119);
    freq.put("Gef", 185);
    freq.put("Ged", 102);
    freq.put("Gei", 109);
    freq.put("Geh", 189);
    freq.put("Geo", 39);
    freq.put("Gen", 223);
    freq.put("Gem", 83);
    freq.put("rb ", 61);
    freq.put("lga", 31);
    freq.put("unr", 25);
    freq.put("lge", 439);
    freq.put("tsv", 26);
    freq.put("tsw", 41);
    freq.put("lgr", 92);
    freq.put("lgs", 39);
    freq.put("lgt", 92);
    freq.put("tsr", 50);
    freq.put("rbu", 226);
    freq.put("rbt", 41);
    freq.put("rbs", 130);
    freq.put("rbr", 184);
    freq.put("rbo", 131);
    freq.put("rbl", 71);
    freq.put("tsp", 198);
    freq.put("rbi", 181);
    freq.put("rbe", 1611);
    freq.put("ly", 337);
    freq.put("rba", 209);
    freq.put("va", 498);
    freq.put("ve", 5609);
    freq.put("vi", 2537);
    freq.put("ph ", 31);
    freq.put("vl", 60);
    freq.put("vo", 5955);
    freq.put("vs", 88);
    freq.put("vt", 78);
    freq.put("of ", 291);
    freq.put("äge", 203);
    freq.put("unb", 110);
    freq.put("gün", 80);
    freq.put("zge", 42);
    freq.put("v ", 457);
    freq.put("phi", 54);
    freq.put("pho", 122);
    freq.put("pha", 53);
    freq.put("phe", 49);
    freq.put("phy", 26);
    freq.put("ofa", 66);
    freq.put("off", 849);
    freq.put("ofe", 114);
    freq.put("ofi", 145);
    freq.put("ofo", 172);
    freq.put("oft", 224);
    freq.put("ägt", 77);
    freq.put("xel", 27);
    freq.put("xen", 34);
    freq.put("ßt ", 312);
    freq.put("wec", 158);
    freq.put("web", 40);
    freq.put("weg", 777);
    freq.put("wee", 398);
    freq.put("wed", 75);
    freq.put("wei", 2967);
    freq.put("weh", 157);
    freq.put("Oh ", 210);
    freq.put("ehä", 28);
    freq.put("wem", 28);
    freq.put("wel", 468);
    freq.put("wes", 236);
    freq.put("wer", 2332);
    freq.put("wet", 108);
    freq.put("xe ", 25);
    freq.put("nve", 212);
    freq.put("Lau", 213);
    freq.put("nvo", 49);
    freq.put("ßte", 102);
    freq.put("Ohn", 68);
    freq.put("we ", 63);
    freq.put(" jä", 70);
    freq.put("krä", 69);
    freq.put("AT ", 44);
    freq.put("llg", 84);
    freq.put("vs ", 75);
    freq.put("Sch", 3316);
    freq.put(" ju", 161);
    freq.put(" jo", 86);
    freq.put("kri", 319);
    freq.put("kro", 41);
    freq.put(" je", 2419);
    freq.put("kra", 383);
    freq.put(" ja", 1986);
    freq.put("Scr", 32);
    freq.put("yri", 56);
    freq.put("Kle", 208);
    freq.put("Kla", 272);
    freq.put("Klo", 56);
    freq.put("Kli", 141);
    freq.put("Klu", 29);
    freq.put("inz", 410);
    freq.put("int", 1083);
    freq.put("inu", 356);
    freq.put("inv", 40);
    freq.put("inw", 102);
    freq.put("inp", 26);
    freq.put("inr", 66);
    freq.put("ins", 1316);
    freq.put("inl", 234);
    freq.put("inm", 197);
    freq.put("inn", 972);
    freq.put("ino", 159);
    freq.put("inh", 126);
    freq.put("ini", 748);
    freq.put("ink", 805);
    freq.put("ind", 3484);
    freq.put("ine", 9508);
    freq.put("inf", 909);
    freq.put("ing", 2880);
    freq.put("ina", 698);
    freq.put("inb", 149);
    freq.put("inc", 65);
    freq.put("eo ", 366);
    freq.put(" ▸ ", 95);
    freq.put("tma", 324);
    freq.put("hpa", 25);
    freq.put("DA ", 34);
    freq.put("U", 3892);
    freq.put("in ", 15440);
    freq.put("eob", 29);
    freq.put("eon", 46);
    freq.put("Rös", 30);
    freq.put("eor", 90);
    freq.put("tsä", 44);
    freq.put("ßß", 111);
    freq.put("Tut", 46);
    freq.put("CS ", 42);
    freq.put("MA ", 45);
    freq.put(" G ", 85);
    freq.put("ali", 669);
    freq.put("cm ", 68);
    freq.put("ald", 364);
    freq.put(" Gu", 781);
    freq.put(" Gr", 1316);
    freq.put("Tun", 68);
    freq.put(" Ge", 3008);
    freq.put(" Ga", 755);
    freq.put(" Go", 532);
    freq.put(" Gl", 535);
    freq.put(" Gm", 136);
    freq.put("Tub", 59);
    freq.put(" Gi", 276);
    freq.put("iTu", 37);
    freq.put("glä", 35);
    freq.put("AG ", 157);
    freq.put("glü", 110);
    freq.put("ärs", 33);
    freq.put("alt", 1634);
    freq.put("gl ", 35);
    freq.put("ßt", 424);
    freq.put("ßn", 26);
    freq.put("ßl", 60);
    freq.put("ßi", 88);
    freq.put("ßg", 27);
    freq.put("ße", 1320);
    freq.put("ak ", 49);
    freq.put("ßb", 176);
    freq.put("ßa", 40);
    freq.put(" Gö", 57);
    freq.put("LS ", 30);
    freq.put(" Gü", 80);
    freq.put("Fr", 2108);
    freq.put(" Gä", 66);
    freq.put("Cr", 130);
    freq.put("löt", 43);
    freq.put("lös", 147);
    freq.put("glo", 60);
    freq.put("aks", 33);
    freq.put("gla", 541);
    freq.put("gle", 928);
    freq.put("aku", 39);
    freq.put("akt", 717);
    freq.put("akk", 30);
    freq.put("löd", 79);
    freq.put("aki", 38);
    freq.put("ärg", 36);
    freq.put("aka", 58);
    freq.put("ake", 197);
    freq.put("ß ", 1119);
    freq.put("nk ", 739);
    freq.put("Jes", 29);
    freq.put("Jet", 444);
    freq.put("Nac", 849);
    freq.put("bru", 118);
    freq.put("bro", 114);
    freq.put("Jed", 78);
    freq.put("bre", 215);
    freq.put("Jen", 52);
    freq.put("OR ", 40);
    freq.put("Jem", 32);
    freq.put("tzw", 89);
    freq.put("iq", 37);
    freq.put("er ", 35052);
    freq.put("is", 15164);
    freq.put("nka", 163);
    freq.put("nke", 1651);
    freq.put("nkf", 142);
    freq.put("nkh", 32);
    freq.put("nki", 80);
    freq.put("nkl", 165);
    freq.put("nko", 129);
    freq.put("nkr", 158);
    freq.put("nks", 145);
    freq.put("nkt", 629);
    freq.put("nku", 112);
    freq.put("Nam", 134);
    freq.put("ert", 3687);
    freq.put("eru", 1062);
    freq.put("erv", 558);
    freq.put("erw", 838);
    freq.put("erp", 376);
    freq.put("err", 944);
    freq.put("ih", 1755);
    freq.put("ery", 25);
    freq.put("erz", 811);
    freq.put("erd", 1701);
    freq.put("ere", 3746);
    freq.put("erf", 858);
    freq.put("erg", 1456);
    freq.put("tna", 33);
    freq.put("era", 1854);
    freq.put("erb", 1283);
    freq.put("erc", 128);
    freq.put("erl", 1826);
    freq.put("erm", 758);
    freq.put("ern", 3926);
    freq.put("ero", 132);
    freq.put("erh", 940);
    freq.put("eri", 1428);
    freq.put("erj", 28);
    freq.put("erk", 1393);
    freq.put("brü", 93);
    freq.put("Abe", 772);
    freq.put("Abg", 57);
    freq.put("brö", 25);
    freq.put("uar", 121);
    freq.put("la ", 268);
    freq.put("uat", 67);
    freq.put("Abo", 41);
    freq.put("Naz", 34);
    freq.put("Abs", 165);
    freq.put("ual", 179);
    freq.put("Abw", 33);
    freq.put("brä", 26);
    freq.put("ki ", 119);
    freq.put("Zür", 25);
    freq.put(" rü", 71);
    freq.put("lal", 35);
    freq.put("lam", 172);
    freq.put("lan", 2004);
    freq.put("lah", 32);
    freq.put("lak", 57);
    freq.put("lad", 333);
    freq.put("laf", 455);
    freq.put("lag", 639);
    freq.put("lab", 66);
    freq.put("lac", 303);
    freq.put("lax", 48);
    freq.put("lay", 196);
    freq.put("lat", 662);
    freq.put("lau", 1431);
    freq.put("lav", 61);
    freq.put("pt ", 260);
    freq.put("lap", 103);
    freq.put("lar", 409);
    freq.put("las", 890);
    freq.put("erö", 228);
    freq.put("erü", 69);
    freq.put("erä", 182);
    freq.put("zeh", 55);
    freq.put("zei", 1259);
    freq.put("zen", 1298);
    freq.put("zel", 168);
    freq.put("zem", 34);
    freq.put("zer", 570);
    freq.put("zes", 117);
    freq.put("zep", 108);
    freq.put("änk", 54);
    freq.put("zeu", 192);
    freq.put("ze ", 697);
    freq.put("l", 89627);
    freq.put("änz", 44);
    freq.put("nt ", 2188);
    freq.put("€", 341);
    freq.put("tso", 33);
    freq.put("ntz", 27);
    freq.put("nts", 402);
    freq.put("ntr", 423);
    freq.put("ntu", 108);
    freq.put("ntt", 29);
    freq.put("ntw", 381);
    freq.put("nti", 505);
    freq.put("nth", 94);
    freq.put("ntl", 791);
    freq.put("nto", 137);
    freq.put("ntn", 47);
    freq.put("nta", 795);
    freq.put("nte", 3830);
    freq.put("ntd", 77);
    freq.put("ntg", 38);
    freq.put("ntf", 103);
    freq.put("tsm", 81);
    freq.put("öst", 83);
    freq.put("ösu", 65);
    freq.put(" l ", 34);
    freq.put("ösc", 82);
    freq.put("öse", 108);
    freq.put("ösi", 37);
    freq.put("tea", 58);
    freq.put("kt ", 1583);
    freq.put(" le", 1514);
    freq.put("B", 11318);
    freq.put(" la", 1305);
    freq.put(" lo", 477);
    freq.put(" li", 1164);
    freq.put("ös ", 26);
    freq.put(" lu", 167);
    freq.put("tef", 64);
    freq.put("Set", 40);
    freq.put("Ses", 32);
    freq.put("Ser", 224);
    freq.put("Sep", 142);
    freq.put("ktu", 282);
    freq.put("Nr ", 40);
    freq.put("ktr", 128);
    freq.put("Sex", 190);
    freq.put("ktl", 44);
    freq.put("See", 104);
    freq.put("kto", 243);
    freq.put("Sec", 41);
    freq.put("kti", 889);
    freq.put("Sea", 30);
    freq.put("Sen", 167);
    freq.put("Sem", 44);
    freq.put("Sel", 147);
    freq.put("Sek", 63);
    freq.put("kta", 68);
    freq.put("Sei", 363);
    freq.put("Seh", 145);
    freq.put("tsf", 61);
    freq.put("Q ", 55);
    freq.put("ter", 8019);
    freq.put("tsg", 59);
    freq.put("teu", 343);
    freq.put("tev", 85);
    freq.put("ype", 96);
    freq.put(" lä", 460);
    freq.put("Qu", 257);
    freq.put(" Öf", 31);
    freq.put(" Öl", 38);
    freq.put("Kna", 25);
    freq.put(" lö", 62);
    freq.put(" Ös", 43);
    freq.put("tse", 168);
    freq.put("yp ", 56);
    freq.put("män", 45);
    freq.put("d ", 18147);
    freq.put("sfä", 25);
    freq.put("em ", 3781);
    freq.put("hrz", 75);
    freq.put("hru", 204);
    freq.put("hrt", 352);
    freq.put("hrw", 25);
    freq.put("hrs", 218);
    freq.put("hrr", 63);
    freq.put("hrl", 114);
    freq.put("hro", 108);
    freq.put("hri", 652);
    freq.put("hrh", 94);
    freq.put("hre", 2447);
    freq.put("hrg", 44);
    freq.put("hra", 123);
    freq.put("hrb", 34);
    freq.put("dn", 206);
    freq.put("do", 2101);
    freq.put("dl", 782);
    freq.put("dm", 127);
    freq.put("dj", 33);
    freq.put("dk", 153);
    freq.put("dh", 178);
    freq.put("di", 12038);
    freq.put("df", 102);
    freq.put("dg", 155);
    freq.put("dd", 341);
    freq.put("de", 33009);
    freq.put("db", 264);
    freq.put("dc", 185);
    freq.put("da", 11644);
    freq.put("wö", 125);
    freq.put("dz", 27);
    freq.put("dy", 301);
    freq.put("dv", 44);
    freq.put("dw", 607);
    freq.put("dt", 613);
    freq.put("du", 3800);
    freq.put("dr", 1655);
    freq.put("ds", 902);
    freq.put("dp", 110);
    freq.put("eme", 916);
    freq.put("emd", 67);
    freq.put("ema", 1010);
    freq.put("CK ", 42);
    freq.put("emb", 299);
    freq.put("emm", 51);
    freq.put("eml", 73);
    freq.put("emo", 239);
    freq.put("emn", 60);
    freq.put("emi", 266);
    freq.put("emp", 367);
    freq.put("ems", 72);
    freq.put("hr ", 3641);
    freq.put("w ", 1278);
    freq.put(" I ", 120);
    freq.put("il ", 1249);
    freq.put("xD ", 208);
    freq.put("co ", 87);
    freq.put("mäß", 60);
    freq.put("toß", 26);
    freq.put("hrä", 26);
    freq.put("we", 9510);
    freq.put("wa", 5813);
    freq.put("wo", 2240);
    freq.put("wn", 126);
    freq.put(" Ir", 163);
    freq.put(" Is", 354);
    freq.put(" It", 86);
    freq.put("wi", 9354);
    freq.put("wh", 42);
    freq.put(" Ih", 555);
    freq.put("wu", 964);
    freq.put("wt", 49);
    freq.put(" Il", 25);
    freq.put(" Im", 409);
    freq.put(" In", 1887);
    freq.put(" Ic", 2821);
    freq.put(" Id", 168);
    freq.put("ilf", 290);
    freq.put("emä", 26);
    freq.put("ild", 788);
    freq.put("ile", 737);
    freq.put("ilb", 98);
    freq.put("ilc", 44);
    freq.put("GB ", 51);
    freq.put("ila", 90);
    freq.put("iln", 37);
    freq.put("ilo", 56);
    freq.put("ill", 1634);
    freq.put("ilm", 303);
    freq.put("ilk", 30);
    freq.put("ilh", 31);
    freq.put("ili", 523);
    freq.put("ilv", 53);
    freq.put("ilt", 122);
    freq.put("ilu", 76);
    freq.put("ils", 164);
    freq.put("emü", 70);
    freq.put("ilz", 55);
    freq.put("coo", 165);
    freq.put("ily", 65);
    freq.put("gn ", 121);
    freq.put("ai ", 63);
    freq.put("ais", 117);
    freq.put("air", 62);
    freq.put("ail", 363);
    freq.put("ET ", 36);
    freq.put("gna", 52);
    freq.put("aik", 33);
    freq.put("gne", 225);
    freq.put("aid", 36);
    freq.put("gni", 53);
    freq.put("gno", 68);
    freq.put("ni ", 178);
    freq.put("Müs", 32);
    freq.put("Mün", 231);
    freq.put("Mül", 49);
    freq.put("th ", 162);
    freq.put("nik", 254);
    freq.put("nin", 181);
    freq.put("nio", 106);
    freq.put("nim", 160);
    freq.put("dü", 122);
    freq.put("nic", 4984);
    freq.put("nia", 110);
    freq.put("nig", 739);
    freq.put("nie", 1087);
    freq.put("nix", 182);
    freq.put("Y", 421);
    freq.put("nis", 879);
    freq.put("nip", 32);
    freq.put("niv", 65);
    freq.put("nit", 323);
    freq.put("ept", 270);
    freq.put("epu", 56);
    freq.put("epr", 80);
    freq.put("epp", 113);
    freq.put("tho", 123);
    freq.put("epo", 135);
    freq.put("epl", 87);
    freq.put("thi", 107);
    freq.put("epi", 37);
    freq.put("epf", 32);
    freq.put("the", 553);
    freq.put("epe", 29);
    freq.put("tha", 176);
    freq.put("epa", 123);
    freq.put("rn ", 2149);
    freq.put("üst", 97);
    freq.put("üss", 538);
    freq.put("Gas", 109);
    freq.put("Gar", 138);
    freq.put("Gan", 111);
    freq.put("Gam", 131);
    freq.put("Gal", 99);
    freq.put("Gad", 72);
    freq.put("Gab", 33);
    freq.put("Tri", 165);
    freq.put("plö", 28);
    freq.put("rni", 157);
    freq.put("rnh", 34);
    freq.put("rno", 113);
    freq.put("Tro", 130);
    freq.put("Tra", 431);
    freq.put("rnb", 100);
    freq.put("rna", 273);
    freq.put("Tre", 200);
    freq.put("rne", 1216);
    freq.put("rnd", 85);
    freq.put("rnz", 34);
    freq.put("plä", 41);
    freq.put("rns", 255);
    freq.put("Tru", 29);
    freq.put("lch", 438);
    freq.put("rnt", 174);
    freq.put("Too", 34);
    freq.put("Lea", 48);
    freq.put("Leb", 360);
    freq.put("Lec", 28);
    freq.put("Led", 42);
    freq.put("Leg", 38);
    freq.put("Leh", 86);
    freq.put("Lei", 341);
    freq.put("Len", 44);
    freq.put("Tim", 111);
    freq.put("Ler", 25);
    freq.put("Les", 112);
    freq.put("Let", 74);
    freq.put("Leu", 261);
    freq.put("Lev", 31);
    freq.put("plu", 52);
    freq.put("Ä", 174);
    freq.put("Trä", 72);
    freq.put("rnä", 33);
    freq.put("ple", 363);
    freq.put("pla", 510);
    freq.put("plo", 66);
    freq.put("pli", 72);
    freq.put("obo", 46);
    freq.put("obl", 260);
    freq.put("obi", 285);
    freq.put("obe", 429);
    freq.put("obb", 139);
    freq.put("oba", 117);
    freq.put("obw", 43);
    freq.put("obu", 25);
    freq.put("obs", 127);
    freq.put("üü", 37);
    freq.put("Pfa", 66);
    freq.put("wan", 453);
    freq.put("wal", 231);
    freq.put("Pfe", 56);
    freq.put("wah", 294);
    freq.put("wag", 74);
    freq.put("üß", 300);
    freq.put("wac", 230);
    freq.put("Pfl", 109);
    freq.put("mt ", 1258);
    freq.put("wat", 62);
    freq.put("was", 2015);
    freq.put("war", 2225);
    freq.put(" X ", 74);
    freq.put(" nä", 336);
    freq.put("xy ", 78);
    freq.put(" nö", 48);
    freq.put("Öf", 32);
    freq.put("mts", 29);
    freq.put("Öl", 38);
    freq.put("wa ", 98);
    freq.put("Ös", 43);
    freq.put("Ode", 127);
    freq.put("mte", 121);
    freq.put("üt", 430);
    freq.put("ür", 5864);
    freq.put("üs", 700);
    freq.put("üp", 42);
    freq.put(" n ", 246);
    freq.put("üf", 156);
    freq.put("üg", 294);
    freq.put("üd", 220);
    freq.put("üb", 1921);
    freq.put("üc", 1521);
    freq.put("ün", 1401);
    freq.put("ül", 315);
    freq.put("üm", 86);
    freq.put("Sau", 82);
    freq.put("üh", 1104);
    freq.put("Tie", 110);
    freq.put(" ni", 5480);
    freq.put(" no", 2391);
    freq.put(" na", 1932);
    freq.put("Sw", 32);
    freq.put("ärz", 38);
    freq.put(" ne", 3138);
    freq.put("ü ", 39);
    freq.put(" nu", 1974);
    freq.put("Sk", 163);
    freq.put("ums", 190);
    freq.put("rk ", 353);
    freq.put("Sn", 47);
    freq.put("ößt", 91);
    freq.put("öße", 96);
    freq.put("umm", 338);
    freq.put("umo", 40);
    freq.put("guc", 259);
    freq.put("EO ", 57);
    freq.put("gue", 55);
    freq.put("gun", 383);
    freq.put("gum", 32);
    freq.put("gus", 100);
    freq.put("p", 19802);
    freq.put("ekü", 50);
    freq.put("gut", 1341);
    freq.put("htf", 30);
    freq.put("hte", 1700);
    freq.put("htb", 56);
    freq.put("hta", 28);
    freq.put("htm", 38);
    freq.put("htl", 78);
    freq.put("hti", 695);
    freq.put("htw", 25);
    freq.put("OK ", 27);
    freq.put("htu", 205);
    freq.put("htt", 182);
    freq.put("hts", 869);
    freq.put("htr", 33);
    freq.put("IN ", 169);
    freq.put("ek ", 76);
    freq.put("ht ", 10123);
    freq.put("Ink", 26);
    freq.put("Xbo", 26);
    freq.put("eko", 674);
    freq.put("ekl", 110);
    freq.put("eke", 88);
    freq.put("eka", 255);
    freq.put("PC ", 93);
    freq.put("ekt", 810);
    freq.put("eks", 44);
    freq.put("ekr", 58);
    freq.put("spü", 29);
    freq.put("uzi", 77);
    freq.put("uze", 37);
    freq.put("SB ", 41);
    freq.put(" iw", 47);
    freq.put("spä", 220);
    freq.put("kse", 51);
    freq.put(" Ka", 1681);
    freq.put(" Ke", 588);
    freq.put("ib ", 125);
    freq.put(" Ki", 848);
    freq.put(" Kn", 132);
    freq.put(" Ko", 1508);
    freq.put(" Kl", 720);
    freq.put(" Kr", 755);
    freq.put(" Ku", 636);
    freq.put("ksa", 71);
    freq.put("ca ", 144);
    freq.put(" im", 3663);
    freq.put("ksc", 37);
    freq.put("F", 8733);
    freq.put("uz ", 35);
    freq.put("ibi", 39);
    freq.put(" K ", 59);
    freq.put("ibl", 107);
    freq.put("So", 1872);
    freq.put("iba", 39);
    freq.put("ibb", 31);
    freq.put("ibe", 521);
    freq.put("cat", 36);
    freq.put("iby", 67);
    freq.put("can", 46);
    freq.put("cam", 70);
    freq.put("cal", 49);
    freq.put("ibs", 49);
    freq.put("ibt", 1079);
    freq.put("ibu", 98);
    freq.put("spr", 652);
    freq.put("spu", 38);
    freq.put("spi", 874);
    freq.put("spl", 96);
    freq.put("spo", 209);
    freq.put("spa", 552);
    freq.put("spe", 345);
    freq.put(" Kä", 94);
    freq.put(" Kö", 343);
    freq.put(" Kü", 210);
    freq.put("aos", 27);
    freq.put("ght", 164);
    freq.put("ghe", 29);
    freq.put("ER ", 326);
    freq.put("gha", 86);
    freq.put("ghl", 27);
    freq.put("Ru", 313);
    freq.put("Che", 212);
    freq.put("Chi", 137);
    freq.put("no ", 227);
    freq.put("Jap", 61);
    freq.put("Jan", 50);
    freq.put("Re", 2051);
    freq.put("Chr", 114);
    freq.put("mbo", 36);
    freq.put("Ra", 812);
    freq.put("Jah", 563);
    freq.put("Ro", 659);
    freq.put("Rh", 88);
    freq.put("Ri", 373);
    freq.put("eß", 272);
    freq.put("nol", 47);
    freq.put("nom", 182);
    freq.put("non", 75);
    freq.put("rlä", 105);
    freq.put("noc", 2279);
    freq.put("R ", 980);
    freq.put("soo", 114);
    freq.put("not", 91);
    freq.put("nov", 166);
    freq.put("son", 854);
    freq.put("nop", 52);
    freq.put("Ja ", 346);
    freq.put("nos", 99);
    freq.put("sor", 281);
    freq.put("sou", 31);
    freq.put("em", 7368);
    freq.put("el", 14387);
    freq.put("Rö", 57);
    freq.put("en", 69378);
    freq.put("ei", 39531);
    freq.put("eh", 8877);
    freq.put("ek", 2314);
    freq.put("ej", 47);
    freq.put("Rü", 155);
    freq.put("ed", 4901);
    freq.put("eg", 4986);
    freq.put("ef", 2441);
    freq.put("ea", 1638);
    freq.put("rl ", 112);
    freq.put("ec", 3797);
    freq.put("eb", 5563);
    freq.put("Rä", 39);
    freq.put("ey", 410);
    freq.put("ex", 858);
    freq.put("ez", 723);
    freq.put("lm ", 203);
    freq.put("et", 10179);
    freq.put("ew", 2128);
    freq.put("ev", 601);
    freq.put("eq", 66);
    freq.put("ep", 1060);
    freq.put("es", 20375);
    freq.put("er", 70534);
    freq.put("eM", 29);
    freq.put("fw", 84);
    freq.put("eB", 70);
    freq.put("usm", 37);
    freq.put("rlo", 150);
    freq.put("rli", 1141);
    freq.put("rle", 540);
    freq.put("rld", 50);
    freq.put("rla", 565);
    freq.put("e ", 61789);
    freq.put("lmi", 26);
    freq.put("rlu", 48);
    freq.put("lma", 96);
    freq.put("lme", 130);
    freq.put("rls", 70);
    freq.put("Sze", 27);
    freq.put("hh ", 139);
    freq.put("xk", 48);
    freq.put("xi", 218);
    freq.put("xo", 36);
    freq.put("zah", 213);
    freq.put("xc", 26);
    freq.put("xa", 52);
    freq.put("Euc", 90);
    freq.put("xe", 125);
    freq.put("xx", 110);
    freq.put("xy", 93);
    freq.put("xp", 195);
    freq.put("zau", 35);
    freq.put("zar", 41);
    freq.put("xt", 250);
    freq.put("xu", 62);
    freq.put("yin", 52);
    freq.put("xD", 662);
    freq.put("Sä", 40);
    freq.put("x ", 1143);
    freq.put("za ", 41);
    freq.put("ush", 138);
    freq.put("Pf", 289);
    freq.put("kyp", 43);
    freq.put("Phi", 43);
    freq.put("Pho", 292);
    freq.put("Pha", 30);
    freq.put("Phy", 25);
    freq.put("Off", 89);
    freq.put("ö", 5909);
    freq.put("Wec", 43);
    freq.put("Web", 273);
    freq.put("Weg", 183);
    freq.put("usr", 61);
    freq.put("Wei", 514);
    freq.put("Wen", 582);
    freq.put("Wel", 609);
    freq.put("Wes", 174);
    freq.put("Wer", 725);
    freq.put(" p ", 27);
    freq.put("Wet", 204);
    freq.put("öwe", 25);
    freq.put(" pr", 501);
    freq.put(" pu", 108);
    freq.put(" pa", 582);
    freq.put(" pf", 57);
    freq.put(" pe", 311);
    freq.put(" pi", 88);
    freq.put(" ph", 42);
    freq.put(" po", 227);
    freq.put(" pl", 203);
    freq.put("uvi", 28);
    freq.put("SF ", 29);
    freq.put("LD ", 44);
    freq.put("Kri", 248);
    freq.put("Kra", 186);
    freq.put("Kre", 273);
    freq.put("gwe", 100);
    freq.put("EM ", 61);
    freq.put("RG ", 35);
    freq.put("hve", 38);
    freq.put(" Mä", 280);
    freq.put("Äh", 33);
    freq.put("ei ", 3792);
    freq.put(" Mö", 141);
    freq.put(" Mü", 353);
    freq.put("Är", 53);
    freq.put("eip", 119);
    freq.put("eis", 1897);
    freq.put("eir", 70);
    freq.put("eit", 5480);
    freq.put("IL ", 43);
    freq.put("eiz", 200);
    freq.put("eic", 2088);
    freq.put("eib", 1008);
    freq.put("eie", 497);
    freq.put("eid", 1155);
    freq.put("eig", 1257);
    freq.put("eif", 275);
    freq.put("eih", 261);
    freq.put("eik", 72);
    freq.put("eim", 1084);
    freq.put("eil", 1940);
    freq.put("ein", 17078);
    freq.put("SD ", 27);
    freq.put("rwe", 454);
    freq.put(" Me", 2286);
    freq.put(" Ma", 2679);
    freq.put(" Mc", 38);
    freq.put(" Mo", 1547);
    freq.put(" Mi", 1947);
    freq.put("Sin", 239);
    freq.put(" Mu", 734);
    freq.put(" Mr", 32);
    freq.put("rwi", 128);
    freq.put(" My", 47);
    freq.put("yb", 66);
    freq.put("NS ", 37);
    freq.put("ete", 898);
    freq.put("eiß", 1062);
    freq.put("ux ", 36);
    freq.put("tli", 1208);
    freq.put(" M ", 107);
    freq.put("cco", 87);
    freq.put("cce", 32);
    freq.put("cer", 36);
    freq.put("am ", 1795);
    freq.put("ps ", 259);
    freq.put("ch", 72961);
    freq.put("Her", 528);
    freq.put("Hes", 39);
    freq.put("ca", 527);
    freq.put("nmö", 25);
    freq.put("amm", 823);
    freq.put("amo", 59);
    freq.put("lüc", 349);
    freq.put("Näc", 50);
    freq.put("amb", 316);
    freq.put("lüg", 49);
    freq.put("pse", 40);
    freq.put("lüs", 73);
    freq.put("amp", 378);
    freq.put("ams", 258);
    freq.put("amt", 131);
    freq.put("pst", 100);
    freq.put("t", 147695);
    freq.put("td ", 51);
    freq.put("Hel", 117);
    freq.put("ync", 35);
    freq.put("uch", 6157);
    freq.put("tdo", 29);
    freq.put("Ger", 368);
    freq.put("tde", 118);
    freq.put("nme", 110);
    freq.put("nma", 278);
    freq.put("nmo", 26);
    freq.put("nmi", 51);
    freq.put("sra", 96);
    freq.put("sre", 151);
    freq.put("sru", 65);
    freq.put("Käs", 31);
    freq.put("Adr", 47);
    freq.put("Gmb", 133);
    freq.put("lob", 56);
    freq.put("loc", 182);
    freq.put("loa", 79);
    freq.put("log", 625);
    freq.put("loh", 106);
    freq.put("lon", 119);
    freq.put("loo", 54);
    freq.put("lol", 126);
    freq.put("lom", 35);
    freq.put("lor", 141);
    freq.put("los", 836);
    freq.put("lop", 55);
    freq.put("lov", 28);
    freq.put("low", 233);
    freq.put("lot", 90);
    freq.put("lou", 55);
    freq.put("J", 3240);
    freq.put("Wie", 776);
    freq.put("Wid", 37);
    freq.put("lo ", 342);
    freq.put("Brü", 70);
    freq.put("Win", 288);
    freq.put("Gel", 286);
    freq.put("Ess", 108);
    freq.put(" sc", 5525);
    freq.put("loß", 46);
    freq.put("gän", 52);
    freq.put("Lam", 41);
    freq.put("Lan", 319);
    freq.put(" sa", 829);
    freq.put("Lad", 91);
    freq.put("Lag", 64);
    freq.put("Lab", 34);
    freq.put("Lac", 50);
    freq.put("Lat", 41);
    freq.put("Wis", 93);
    freq.put("you", 86);
    freq.put("Lap", 56);
    freq.put("Las", 92);
    freq.put("c ", 613);
    freq.put("Es ", 532);
    freq.put("jäh", 105);
    freq.put("Bru", 82);
    freq.put("Bro", 187);
    freq.put("Bri", 137);
    freq.put("Bre", 166);
    freq.put("Bra", 283);
    freq.put("mp ", 94);
    freq.put("tör", 96);
    freq.put("däm", 49);
    freq.put("ßli", 42);
    freq.put("mpf", 565);
    freq.put("mpe", 287);
    freq.put("mpa", 102);
    freq.put("mpo", 66);
    freq.put("mpl", 171);
    freq.put("mpi", 83);
    freq.put("mpu", 86);
    freq.put("mpr", 49);
    freq.put("mps", 25);
    freq.put("ass", 3153);
    freq.put(" r ", 45);
    freq.put("VW ", 31);
    freq.put("Hos", 32);
    freq.put(" ru", 393);
    freq.put(" re", 1214);
    freq.put(" ra", 456);
    freq.put("kze", 48);
    freq.put("ver", 4304);
    freq.put(" ro", 172);
    freq.put(" ri", 418);
    freq.put("TS ", 41);
    freq.put("ask", 70);
    freq.put("S ", 1521);
    freq.put("aso", 40);
    freq.put("asm", 34);
    freq.put("Sz", 27);
    freq.put("Sy", 175);
    freq.put("fö", 40);
    freq.put("Sp", 1604);
    freq.put("fü", 4809);
    freq.put("Su", 556);
    freq.put("St", 3542);
    freq.put("FC ", 96);
    freq.put("Si", 1840);
    freq.put("Sh", 356);
    freq.put("fä", 630);
    freq.put(" Üb", 327);
    freq.put("Sm", 110);
    freq.put("Sl", 50);
    freq.put("Sc", 3412);
    freq.put("Sa", 1225);
    freq.put("Se", 1813);
    freq.put("RE ", 59);
    freq.put("f ", 6093);
    freq.put("hha", 88);
    freq.put("hhe", 98);
    freq.put("hhh", 203);
    freq.put("ob ", 402);
    freq.put("▸", 97);
    freq.put("eg ", 586);
    freq.put("fp", 51);
    freq.put("fr", 2098);
    freq.put("fs", 570);
    freq.put("ft", 3085);
    freq.put("fu", 960);
    freq.put("Sü", 141);
    freq.put("fz", 127);
    freq.put("fa", 3231);
    freq.put("fb", 114);
    freq.put("fc", 34);
    freq.put("fe", 5823);
    freq.put("ff", 2609);
    freq.put("fg", 390);
    freq.put("fh", 106);
    freq.put("fi", 1839);
    freq.put("fk", 65);
    freq.put("fl", 935);
    freq.put("fm", 163);
    freq.put("fn", 239);
    freq.put("fo", 1855);
    freq.put("a", 147814);
    freq.put("egs", 116);
    freq.put("egr", 143);
    freq.put("egu", 94);
    freq.put("egt", 352);
    freq.put("egi", 440);
    freq.put("ego", 69);
    freq.put("egn", 107);
    freq.put("egl", 70);
    freq.put("ega", 349);
    freq.put("egg", 43);
    freq.put("ege", 2550);
    freq.put("ce ", 384);
    freq.put("y ", 2504);
    freq.put("fft", 180);
    freq.put("ffs", 40);
    freq.put("ffn", 168);
    freq.put("ffl", 34);
    freq.put("ffi", 180);
    freq.put("os ", 964);
    freq.put("fff", 28);
    freq.put("ffe", 1504);
    freq.put("uve", 43);
    freq.put("ffa", 27);
    freq.put(" On", 381);
    freq.put(" Oo", 36);
    freq.put(" Ol", 115);
    freq.put(" Om", 51);
    freq.put(" Ok", 259);
    freq.put(" Oh", 380);
    freq.put(" Of", 117);
    freq.put(" Od", 133);
    freq.put(" Oe", 26);
    freq.put(" Ob", 248);
    freq.put(" Oc", 35);
    freq.put("if ", 46);
    freq.put(" Ot", 25);
    freq.put(" Ou", 67);
    freq.put(" Or", 259);
    freq.put(" Os", 145);
    freq.put(" Op", 220);
    freq.put("yi", 61);
    freq.put("rwa", 281);
    freq.put("ym", 177);
    freq.put("ceb", 374);
    freq.put("yo", 149);
    freq.put("yn", 133);
    freq.put("ya", 97);
    freq.put("cen", 75);
    freq.put("yc", 51);
    freq.put("cel", 46);
    freq.put("ye", 454);
    freq.put("yd", 46);
    freq.put("rwo", 35);
    freq.put("ces", 71);
    freq.put("rwu", 40);
    freq.put("yp", 236);
    freq.put("ys", 506);
    freq.put("yr", 98);
    freq.put("yu", 38);
    freq.put("yt", 63);
    freq.put("ff ", 313);
    freq.put("ift", 185);
    freq.put(" O ", 213);
    freq.put("ife", 265);
    freq.put("iff", 266);
    freq.put("ifi", 93);
    freq.put("dig", 552);
    freq.put("End", 298);
    freq.put("Ene", 114);
    freq.put("Eng", 140);
    freq.put("as ", 8724);
    freq.put("Ent", 327);
    freq.put("pul", 49);
    freq.put("pun", 104);
    freq.put("asp", 30);
    freq.put("rwä", 58);
    freq.put("ve ", 558);
    freq.put("ast", 1284);
    freq.put("asy", 37);
    freq.put("pub", 29);
    freq.put("asc", 418);
    freq.put("asa", 31);
    freq.put("ase", 281);
    freq.put("put", 192);
    freq.put("asi", 192);
    freq.put("ash", 149);
    freq.put("rwü", 26);
    freq.put("pur", 65);
    freq.put("pus", 40);
    freq.put(" än", 68);
    freq.put(" äl", 31);
    freq.put(" äh", 76);
    freq.put(" är", 34);
    freq.put("Clo", 54);
    freq.put("Cli", 35);
    freq.put("Imm", 156);
    freq.put("tf ", 31);
    freq.put("Imp", 44);
    freq.put("Clu", 61);
    freq.put("st ", 11359);
    freq.put("dt ", 358);
    freq.put("Im ", 195);
    freq.put("tfo", 84);
    freq.put("tfi", 26);
    freq.put("tfe", 88);
    freq.put("tfa", 105);
    freq.put("rhö", 56);
    freq.put("nch", 617);
    freq.put("nci", 54);
    freq.put("nco", 41);
    freq.put("rhä", 80);
    freq.put("tfr", 41);
    freq.put("std", 37);
    freq.put("ste", 7073);
    freq.put("stf", 90);
    freq.put("stg", 75);
    freq.put("sta", 2341);
    freq.put("stb", 74);
    freq.put("stl", 186);
    freq.put("stm", 209);
    freq.put("dta", 44);
    freq.put("sto", 448);
    freq.put("sth", 111);
    freq.put("sti", 1544);
    freq.put("dte", 47);
    freq.put("stk", 41);
    freq.put("stu", 457);
    freq.put("stv", 31);
    freq.put("stw", 43);
    freq.put("stp", 55);
    freq.put("str", 1029);
    freq.put("sts", 173);
    freq.put("dtr", 25);
    freq.put("sty", 29);
    freq.put("stz", 28);
    freq.put("Gol", 112);
    freq.put("Goo", 222);
    freq.put("ka ", 161);
    freq.put("Got", 112);
    freq.put("lid", 47);
    freq.put("lie", 2076);
    freq.put("lif", 69);
    freq.put("lig", 727);
    freq.put("Nin", 30);
    freq.put("lia", 158);
    freq.put("lib", 37);
    freq.put("lic", 4211);
    freq.put("Nic", 262);
    freq.put("lin", 1871);
    freq.put("lio", 139);
    freq.put("Nig", 25);
    freq.put("Nie", 167);
    freq.put("lit", 635);
    freq.put("liv", 120);
    freq.put("lip", 75);
    freq.put("lis", 564);
    freq.put("liz", 232);
    freq.put("kac", 58);
    freq.put("kab", 39);
    freq.put("kaf", 27);
    freq.put("kad", 37);
    freq.put("rhu", 32);
    freq.put("kan", 1717);
    freq.put("kam", 202);
    freq.put("kal", 221);
    freq.put("kas", 90);
    freq.put("kar", 163);
    freq.put("kap", 96);
    freq.put("kau", 730);
    freq.put("kat", 202);
    freq.put("rha", 427);
    freq.put("kay", 133);
    freq.put("rhe", 441);
    freq.put("stä", 301);
    freq.put("bzu", 40);
    freq.put("li ", 191);
    freq.put("stö", 95);
    freq.put("stü", 303);
    freq.put("ymp", 61);
    freq.put("nce", 204);
    freq.put("Plä", 43);
    freq.put("ox ", 130);
    freq.put("dti", 30);
    freq.put("x", 3248);
    freq.put("dur", 552);
    freq.put("Ob ", 52);
    freq.put("dus", 137);
    freq.put("Plu", 65);
    freq.put("wor", 444);
    freq.put("wol", 438);
    freq.put("Ple", 38);
    freq.put("won", 44);
    freq.put("woh", 650);
    freq.put("Pla", 388);
    freq.put("woc", 172);
    freq.put("Obe", 116);
    freq.put("wo ", 349);
    freq.put("Wan", 214);
    freq.put("Wal", 118);
    freq.put("Wah", 244);
    freq.put("Wag", 36);
    freq.put("Wac", 59);
    freq.put("wen", 1678);
    freq.put("Wat", 34);
    freq.put("Was", 749);
    freq.put("War", 475);
    freq.put(" t ", 60);
    freq.put(" ty", 29);
    freq.put(" € ", 279);
    freq.put(" tw", 262);
    freq.put(" tv", 35);
    freq.put(" tu", 372);
    freq.put("ada", 58);
    freq.put(" ts", 28);
    freq.put(" tr", 798);
    freq.put("N", 6186);
    freq.put(" to", 660);
    freq.put(" ti", 156);
    freq.put(" th", 152);
    freq.put(" te", 402);
    freq.put(" ta", 336);
    freq.put("ohl", 548);
    freq.put("bot", 347);
    freq.put("gs ", 496);
    freq.put("sät", 58);
    freq.put(" tü", 30);
    freq.put("Nik", 41);
    freq.put(" tö", 32);
    freq.put("säc", 51);
    freq.put("FA ", 36);
    freq.put(" tä", 54);
    freq.put("gsp", 111);
    freq.put("gss", 172);
    freq.put("gsr", 40);
    freq.put("gst", 567);
    freq.put("gsw", 51);
    freq.put("gsv", 40);
    freq.put("gsz", 32);
    freq.put("gsa", 197);
    freq.put("EI ", 26);
    freq.put("gsc", 49);
    freq.put("gsb", 117);
    freq.put("gse", 50);
    freq.put("gsg", 79);
    freq.put("gsf", 83);
    freq.put("gsi", 26);
    freq.put("gsh", 42);
    freq.put("gsk", 83);
    freq.put("gsm", 67);
    freq.put("gsl", 50);
    freq.put("hja", 52);
    freq.put("ohi", 30);
    freq.put("lik", 112);
    freq.put("ee ", 672);
    freq.put("äti", 72);
    freq.put("eet", 421);
    freq.put("pät", 238);
    freq.put("eep", 32);
    freq.put("ees", 42);
    freq.put("eer", 238);
    freq.put("eel", 97);
    freq.put("een", 266);
    freq.put("eei", 77);
    freq.put("ruß", 28);
    freq.put("eek", 34);
    freq.put("eee", 200);
    freq.put("eed", 77);
    freq.put("Rüc", 120);
    freq.put(" Qu", 252);
    freq.put("id ", 487);
    freq.put("ruk", 54);
    freq.put("ruh", 145);
    freq.put("rui", 29);
    freq.put("run", 1691);
    freq.put("rum", 757);
    freq.put("ruc", 359);
    freq.put("ruf", 259);
    freq.put("rug", 27);
    freq.put("rud", 46);
    freq.put("rue", 46);
    freq.put("rur", 46);
    freq.put("rus", 127);
    freq.put("rup", 146);
    freq.put("rut", 48);
    freq.put("rhi", 142);
    freq.put("bge", 262);
    freq.put("idt", 38);
    freq.put("idu", 131);
    freq.put("ids", 45);
    freq.put("ido", 39);
    freq.put("MW ", 33);
    freq.put("Ohr", 58);
    freq.put("idi", 136);
    freq.put("idd", 31);
    freq.put("ide", 1427);
    freq.put("ida", 108);
    freq.put("Tü", 118);
    freq.put("rho", 95);
    freq.put("Tö", 29);
    freq.put("Elf", 25);
    freq.put("Ele", 122);
    freq.put("Tä", 48);
    freq.put("The", 427);
    freq.put("Elt", 66);
    freq.put("ußb", 147);
    freq.put("ut ", 1877);
    freq.put("uße", 247);
    freq.put("kus", 187);
    freq.put("bzw", 56);
    freq.put("uß ", 107);
    freq.put("öl", 367);
    freq.put("ute", 3246);
    freq.put("uth", 66);
    freq.put("uti", 231);
    freq.put("uto", 507);
    freq.put("utl", 91);
    freq.put("utr", 26);
    freq.put("uts", 1292);
    freq.put("utt", 452);
    freq.put("utu", 108);
    freq.put("utz", 570);
    freq.put("Ich", 2806);
    freq.put("ood", 76);
    freq.put("Tw", 635);
    freq.put("Tu", 285);
    freq.put("Tr", 1040);
    freq.put("Ts", 53);
    freq.put("To", 823);
    freq.put("oof", 89);
    freq.put("Tj", 32);
    freq.put("Th", 579);
    freq.put("Ti", 768);
    freq.put("Te", 1170);
    freq.put("Ta", 1372);
    freq.put("nab", 107);
    freq.put("nac", 1769);
    freq.put("nag", 170);
    freq.put("nad", 40);
    freq.put("naj", 112);
    freq.put("nah", 206);
    freq.put("ät ", 338);
    freq.put("nan", 453);
    freq.put("bze", 26);
    freq.put("nal", 675);
    freq.put("nam", 116);
    freq.put("nar", 150);
    freq.put("nas", 91);
    freq.put("nap", 100);
    freq.put("nat", 552);
    freq.put("nau", 432);
    freq.put("oon", 36);
    freq.put("ook", 521);
    freq.put("T ", 1612);
    freq.put("tmu", 81);
    freq.put("Aa", 48);
    freq.put("svo", 48);
    freq.put("na ", 484);
    freq.put("Ab", 1346);
    freq.put("e", 346865);
    freq.put("Ad", 198);
    freq.put("Ag", 72);
    freq.put("Af", 76);
    freq.put("dve", 30);
    freq.put("Ah", 158);
    freq.put("Ak", 302);
    freq.put("sve", 180);
    freq.put("Am", 504);
    freq.put("Al", 1407);
    freq.put("äte", 228);
    freq.put("An", 1612);
    freq.put("Ap", 488);
    freq.put("As", 186);
    freq.put("Ar", 985);
    freq.put("Au", 2308);
    freq.put("At", 150);
    freq.put("Aw", 52);
    freq.put("Av", 48);
    freq.put("äts", 73);
    freq.put("Ax", 26);
    freq.put("ätt", 394);
    freq.put("gw", 122);
    freq.put("gv", 25);
    freq.put("gu", 2283);
    freq.put("Git", 28);
    freq.put("gs", 2451);
    freq.put("Gir", 42);
    freq.put("Gip", 27);
    freq.put("zä", 152);
    freq.put("gz", 58);
    freq.put("gy", 60);
    freq.put("zü", 74);
    freq.put("gf", 60);
    freq.put("ge", 27310);
    freq.put("gd", 62);
    freq.put("Gib", 86);
    freq.put("ga", 2976);
    freq.put("go", 480);
    freq.put("gn", 581);
    freq.put("zö", 55);
    freq.put("gl", 2231);
    freq.put("gk", 271);
    freq.put("gi", 2237);
    freq.put("gh", 424);
    freq.put("Tja", 32);
    freq.put("lko", 164);
    freq.put("hül", 72);
    freq.put("lki", 38);
    freq.put("lke", 167);
    freq.put("hüb", 43);
    freq.put("lka", 61);
    freq.put("Not", 115);
    freq.put("Nov", 96);
    freq.put("Now", 87);
    freq.put("hüs", 32);
    freq.put("lks", 68);
    freq.put("Nor", 227);
    freq.put("tme", 102);
    freq.put("arü", 51);
    freq.put("kch", 26);
    freq.put("g ", 12659);
    freq.put("rtu", 189);
    freq.put("Spr", 160);
    freq.put("Spu", 26);
    freq.put("lk ", 87);
    freq.put("Spi", 555);
    freq.put("Spo", 211);
    freq.put("Spa", 383);
    freq.put("Spe", 208);
    freq.put("zl", 318);
    freq.put("zm", 76);
    freq.put("zn", 28);
    freq.put("zo", 293);
    freq.put("zh", 59);
    freq.put("zi", 1897);
    freq.put("zk", 83);
    freq.put("zd", 159);
    freq.put("ze", 4570);
    freq.put("zf", 59);
    freq.put("zg", 82);
    freq.put("za", 397);
    freq.put("zb", 141);
    freq.put("zc", 27);
    freq.put("gä", 108);
    freq.put("zy", 39);
    freq.put("zz", 153);
    freq.put("zt", 3046);
    freq.put("zu", 6680);
    freq.put("zv", 33);
    freq.put("zw", 902);
    freq.put("zp", 35);
    freq.put("zs", 90);
    freq.put("Ah ", 38);
    freq.put("ych", 34);
    freq.put("oze", 140);
    freq.put("ull", 132);
    freq.put("z ", 2767);
    freq.put("ozi", 127);
    freq.put("ozu", 37);
    freq.put("Ahn", 69);
    freq.put("sä", 166);
    freq.put("Spä", 27);
    freq.put("wig", 84);
    freq.put("wie", 3424);
    freq.put("wid", 57);
    freq.put("wic", 364);
    freq.put("win", 468);
    freq.put("wim", 37);
    freq.put("wil", 899);
    freq.put("iet", 378);
    freq.put("wit", 713);
    freq.put("wis", 567);
    freq.put("wir", 2676);
    freq.put(" vö", 43);
    freq.put("ied", 2143);
    freq.put(" va", 27);
    freq.put(" ve", 3082);
    freq.put(" vi", 1610);
    freq.put(" vl", 51);
    freq.put(" vo", 5294);
    freq.put(" vs", 70);
    freq.put("Hät", 47);
    freq.put("Hän", 42);
    freq.put(" v ", 72);
    freq.put("TO ", 26);
    freq.put("kre", 249);
    freq.put("hlü", 53);
    freq.put("hlä", 132);
    freq.put("RA ", 26);
    freq.put("ec ", 37);
    freq.put("hlu", 302);
    freq.put("hlt", 334);
    freq.put("hls", 81);
    freq.put("hlr", 27);
    freq.put("hlo", 133);
    freq.put("hlk", 36);
    freq.put("hli", 429);
    freq.put("hlf", 25);
    freq.put("hle", 1269);
    freq.put("hlb", 33);
    freq.put("hla", 1275);
    freq.put("Ama", 110);
    freq.put("CE ", 43);
    freq.put("eco", 39);
    freq.put("eck", 1136);
    freq.put("eci", 36);
    freq.put("ech", 2318);
    freq.put("ecu", 27);
    freq.put("ect", 87);
    freq.put("ecr", 46);
    freq.put("hl ", 815);
    freq.put("Urt", 29);
    freq.put("rs ", 847);
    freq.put("AN ", 95);
    freq.put(" Sz", 27);
    freq.put(" Sy", 174);
    freq.put("DU ", 150);
    freq.put(" Sp", 1591);
    freq.put(" Sw", 32);
    freq.put(" St", 3484);
    freq.put(" Su", 555);
    freq.put(" Sk", 162);
    freq.put(" Sh", 351);
    freq.put(" Si", 1818);
    freq.put(" Sn", 46);
    freq.put(" So", 1863);
    freq.put(" Sl", 50);
    freq.put(" Sm", 108);
    freq.put(" Sc", 3394);
    freq.put(" Sa", 1214);
    freq.put(" Se", 1792);
    freq.put("rsl", 31);
    freq.put("rso", 203);
    freq.put("rsi", 318);
    freq.put("rse", 393);
    freq.put("rsa", 282);
    freq.put("rsc", 1293);
    freq.put("R", 5769);
    freq.put("rst", 2409);
    freq.put("rsu", 233);
    freq.put("rsp", 262);
    freq.put("bek", 579);
    freq.put("beh", 154);
    freq.put("bei", 4148);
    freq.put("ben", 4239);
    freq.put("beo", 25);
    freq.put("bel", 544);
    freq.put("bem", 50);
    freq.put("beb", 50);
    freq.put("bec", 86);
    freq.put("bea", 165);
    freq.put("bef", 101);
    freq.put("beg", 214);
    freq.put("bed", 216);
    freq.put("bee", 100);
    freq.put("bez", 140);
    freq.put("urü", 256);
    freq.put("bes", 1538);
    freq.put(" S ", 235);
    freq.put("bev", 84);
    freq.put("bew", 247);
    freq.put("bet", 321);
    freq.put("beu", 45);
    freq.put("bie", 449);
    freq.put("arg", 79);
    freq.put("py ", 51);
    freq.put("ur ", 2889);
    freq.put(" Sü", 140);
    freq.put("arm", 328);
    freq.put("bur", 804);
    freq.put(" Sä", 40);
    freq.put("KW ", 41);
    freq.put("aww", 25);
    freq.put("rsö", 66);
    freq.put("awa", 49);
    freq.put("urd", 468);
    freq.put("ure", 445);
    freq.put("urf", 89);
    freq.put("urg", 711);
    freq.put("ura", 129);
    freq.put("urb", 51);
    freq.put("urc", 613);
    freq.put("url", 63);
    freq.put("urm", 79);
    freq.put("urn", 142);
    freq.put("uro", 676);
    freq.put("uri", 216);
    freq.put("urk", 26);
    freq.put("urt", 423);
    freq.put("urv", 36);
    freq.put("urr", 83);
    freq.put("urs", 227);
    freq.put("bun", 337);
    freq.put("bia", 26);
    freq.put("urz", 331);
    freq.put("mg ", 42);
    freq.put("bul", 40);
    freq.put("buc", 171);
    freq.put("nge", 4051);
    freq.put("nga", 160);
    freq.put("ngl", 334);
    freq.put("ngn", 29);
    freq.put("ngo", 55);
    freq.put("ngh", 41);
    freq.put("ngi", 88);
    freq.put("sh ", 126);
    freq.put("ngu", 81);
    freq.put("Psy", 28);
    freq.put("ngr", 140);
    freq.put("ngs", 1601);
    freq.put("mge", 131);
    freq.put("tbr", 33);
    freq.put("tbu", 27);
    freq.put("tbi", 29);
    freq.put("tbo", 31);
    freq.put("tba", 143);
    freq.put("tbe", 180);
    freq.put("ng ", 5858);
    freq.put("dpr", 32);
    freq.put("sha", 221);
    freq.put("she", 155);
    freq.put("dpa", 51);
    freq.put("shi", 180);
    freq.put("sho", 202);
    freq.put("ke ", 1596);
    freq.put("lus", 510);
    freq.put("lut", 212);
    freq.put("lub", 98);
    freq.put("luc", 67);
    freq.put("lue", 63);
    freq.put("luf", 45);
    freq.put("lug", 222);
    freq.put("lum", 91);
    freq.put("lun", 699);
    freq.put("ken", 2187);
    freq.put("kel", 583);
    freq.put("kei", 1755);
    freq.put("keh", 175);
    freq.put("ked", 25);
    freq.put("key", 31);
    freq.put("ket", 314);
    freq.put("kes", 120);
    freq.put("ker", 887);
    freq.put("lu ", 59);
    freq.put("Lob", 31);
    freq.put("Loc", 31);
    freq.put("Log", 65);
    freq.put("ot ", 512);
    freq.put("Lok", 25);
    freq.put("Loh", 32);
    freq.put("Lon", 38);
    freq.put("Lor", 33);
    freq.put("Los", 40);
    freq.put("Lov", 33);
    freq.put("Lot", 28);
    freq.put("An ", 66);
    freq.put("oth", 143);
    freq.put("oti", 203);
    freq.put("otl", 37);
    freq.put("oto", 550);
    freq.put("ota", 173);
    freq.put("ote", 904);
    freq.put("otz", 324);
    freq.put("ots", 166);
    freq.put("ott", 396);
    freq.put("And", 174);
    freq.put("Anf", 107);
    freq.put("Ang", 374);
    freq.put("Ana", 63);
    freq.put("öbe", 68);
    freq.put("Anl", 81);
    freq.put("Anm", 32);
    freq.put("Ann", 61);
    freq.put("Ano", 32);
    freq.put("Anh", 39);
    freq.put("Ani", 28);
    freq.put("Ank", 26);
    freq.put("Ant", 175);
    freq.put("Anw", 55);
    freq.put("Anr", 28);
    freq.put("Ans", 146);
    freq.put("ya ", 27);
    freq.put("Anz", 60);
    freq.put("You", 132);
    freq.put("Yor", 32);
    freq.put("zy ", 26);
    freq.put("mzu", 48);
    freq.put("i", 186253);
    freq.put(" xD", 661);
    freq.put("Be", 3220);
    freq.put("Ba", 1875);
    freq.put("Bl", 851);
    freq.put("Bo", 739);
    freq.put("Bi", 1371);
    freq.put("´s ", 52);
    freq.put("Bu", 952);
    freq.put(" xx", 34);
    freq.put("Br", 959);
    freq.put("NN ", 39);
    freq.put("B ", 605);
    freq.put(" x ", 195);
    freq.put("ubt", 67);
    freq.put("U ", 496);
    freq.put("Bä", 74);
    freq.put("Bö", 100);
    freq.put("Bü", 231);
    freq.put("?", 29);
    freq.put("swi", 77);
    freq.put("Up", 144);
    freq.put("Us", 85);
    freq.put("Ur", 237);
    freq.put("Um", 316);
    freq.put("Ul", 77);
    freq.put("Un", 1769);
    freq.put("Uh", 583);
    freq.put("LL ", 50);
    freq.put("dun", 596);
    freq.put("swa", 84);
    freq.put("zäh", 148);
    freq.put("ea ", 62);
    freq.put("h ", 33156);
    freq.put("hz", 116);
    freq.put("eah", 63);
    freq.put("eak", 121);
    freq.put("hy", 115);
    freq.put("eam", 269);
    freq.put("eal", 175);
    freq.put("ean", 144);
    freq.put("hr", 8433);
    freq.put("hs", 1690);
    freq.put("eac", 45);
    freq.put("hv", 56);
    freq.put("ead", 140);
    freq.put("eag", 63);
    freq.put("hu", 1662);
    freq.put("hj", 65);
    freq.put("hk", 264);
    freq.put("hh", 583);
    freq.put("hi", 3960);
    freq.put("hn", 3714);
    freq.put("ho", 4241);
    freq.put("hl", 5069);
    freq.put("hm", 2000);
    freq.put("hb", 281);
    freq.put("hc", 36);
    freq.put("eas", 80);
    freq.put("ear", 159);
    freq.put("eau", 71);
    freq.put("eat", 202);
    freq.put("hd", 129);
    freq.put("he", 19568);
    freq.put("dma", 38);
    freq.put("wäc", 45);
    freq.put("dme", 28);
    freq.put("wäh", 189);
    freq.put("dmi", 29);
    freq.put("hP", 29);
    freq.put("wär", 486);
    freq.put("wäs", 28);
    freq.put("hA", 26);
    freq.put("ID ", 34);
    freq.put("hn ", 646);
    freq.put(" Up", 141);
    freq.put(" Ur", 237);
    freq.put(" Us", 80);
    freq.put(" Ul", 74);
    freq.put(" Um", 316);
    freq.put(" Un", 1759);
    freq.put(" Uh", 583);
    freq.put("hü", 349);
    freq.put("hö", 1639);
    freq.put("hä", 1105);
    freq.put("hna", 181);
    freq.put("hne", 1412);
    freq.put("hni", 314);
    freq.put("hnh", 92);
    freq.put("hnl", 79);
    freq.put("hno", 55);
    freq.put("hns", 103);
    freq.put("hnu", 411);
    freq.put("hnt", 163);
    freq.put(" U ", 101);
    freq.put("MS ", 53);
    freq.put("Ehr", 43);
    freq.put("Ehe", 44);
    freq.put("aua", 34);
    freq.put("auc", 3627);
    freq.put("aub", 888);
    freq.put("aue", 1014);
    freq.put("aud", 69);
    freq.put("aug", 87);
    freq.put("auf", 5624);
    freq.put("auk", 30);
    freq.put("aum", 453);
    freq.put("blo", 217);
    freq.put("up ", 119);
    freq.put("aun", 234);
    freq.put("aup", 246);
    freq.put("aus", 3881);
    freq.put("Nür", 60);
    freq.put("aut", 658);
    freq.put("ble", 733);
    freq.put("au ", 1050);
    freq.put("drü", 176);
    freq.put("upd", 29);
    freq.put("upe", 328);
    freq.put("upt", 240);
    freq.put("ups", 33);
    freq.put("upp", 230);
    freq.put("me ", 1065);
    freq.put("auß", 143);
    freq.put("Pul", 28);
    freq.put("Pun", 130);
    freq.put("nem", 1042);
    freq.put("neh", 523);
    freq.put("nei", 368);
    freq.put("neg", 33);
    freq.put("ned", 55);
    freq.put("nee", 163);
    freq.put("neb", 119);
    freq.put("nec", 94);
    freq.put("Pub", 39);
    freq.put("ney", 36);
    freq.put("Put", 28);
    freq.put("new", 59);
    freq.put("net", 919);
    freq.put("neu", 1278);
    freq.put("ner", 3168);
    freq.put("nes", 849);
    freq.put("mee", 31);
    freq.put("med", 124);
    freq.put("meg", 50);
    freq.put("mec", 74);
    freq.put("mel", 524);
    freq.put("men", 3123);
    freq.put("mei", 2737);
    freq.put("meh", 1044);
    freq.put("met", 113);
    freq.put("mep", 40);
    freq.put("mes", 281);
    freq.put("mer", 2487);
    freq.put("äpp", 33);
    freq.put("dru", 171);
    freq.put("ne ", 7560);
    freq.put("dri", 276);
    freq.put("drh", 42);
    freq.put("dro", 192);
    freq.put("dra", 374);
    freq.put("fhö", 44);
    freq.put("dre", 384);
    freq.put("St ", 68);
    freq.put("ügt", 28);
    freq.put("kg ", 33);
    freq.put("ügb", 35);
    freq.put("üge", 186);
    freq.put("Ü", 338);
    freq.put("Tit", 186);
    freq.put("lwe", 54);
    freq.put("Std", 25);
    freq.put("Ste", 675);
    freq.put("Sta", 990);
    freq.put("Sto", 164);
    freq.put("Sti", 230);
    freq.put("Stu", 630);
    freq.put("kge", 43);
    freq.put("Str", 590);
    freq.put("V", 4476);
    freq.put("Sty", 25);
    freq.put("VB ", 35);
    freq.put("Co ", 70);
    freq.put("´s", 57);
    freq.put("Lie", 503);
    freq.put("Lif", 25);
    freq.put("Lig", 35);
    freq.put("Lib", 76);
    freq.put("Lic", 89);
    freq.put("Lim", 32);
    freq.put("Lin", 252);
    freq.put("Lik", 38);
    freq.put("Lit", 45);
    freq.put("Liv", 110);
    freq.put("Lip", 25);
    freq.put("Lis", 76);
    freq.put("Kac", 25);
    freq.put("Kab", 70);
    freq.put("Kaf", 141);
    freq.put("Kai", 44);
    freq.put("Kan", 357);
    freq.put("Kam", 173);
    freq.put("Kal", 90);
    freq.put("Kas", 70);
    freq.put("Kar", 294);
    freq.put("Kap", 73);
    freq.put("Kau", 104);
    freq.put("Kat", 204);
    freq.put("Tic", 77);
    freq.put("Rhe", 70);
    freq.put("Stä", 55);
    freq.put("Stö", 25);
    freq.put("ova", 61);
    freq.put("ove", 321);
    freq.put("Stü", 57);
    freq.put("ovi", 124);
    freq.put("ovo", 45);
    freq.put("All", 431);
    freq.put("Alk", 41);
    freq.put("Ali", 39);
    freq.put("Ale", 61);
    freq.put("Alb", 114);
    freq.put("Ala", 26);
    freq.put("Alt", 260);
    freq.put("Alu", 29);
    freq.put("Als", 299);
    freq.put("Alp", 34);
    freq.put("wus", 105);
    freq.put("dür", 78);
    freq.put("wun", 243);
    freq.put("wul", 48);
    freq.put("zw ", 66);
    freq.put(" zä", 45);
    freq.put(" Z ", 34);
    freq.put(" F ", 84);
    freq.put("zwi", 262);
    freq.put("zwa", 96);
    freq.put("zwe", 449);
    freq.put("Wow", 49);
    freq.put("Wor", 246);
    freq.put("Wol", 153);
    freq.put("Woh", 286);
    freq.put("SS ", 94);
    freq.put("Woc", 497);
    freq.put(" zo", 39);
    freq.put(" zi", 237);
    freq.put(" ze", 443);
    freq.put(" za", 111);
    freq.put(" zu", 5669);
    freq.put(" zw", 623);
    freq.put("is ", 2052);
    freq.put("zde", 147);
    freq.put("Wo ", 133);
    freq.put("xus", 27);
    freq.put("iss", 1315);
    freq.put("isp", 115);
    freq.put(" z ", 80);
    freq.put("isu", 47);
    freq.put("ist", 7052);
    freq.put("isk", 164);
    freq.put("xue", 25);
    freq.put("isi", 290);
    freq.put("ish", 150);
    freq.put("iso", 85);
    freq.put("ism", 132);
    freq.put("isl", 46);
    freq.put("isc", 2462);
    freq.put("isb", 54);
    freq.put("isa", 102);
    freq.put("ise", 897);
    freq.put("Eur", 647);
    freq.put("gy ", 32);
    freq.put("Col", 67);
    freq.put("Coo", 45);
    freq.put("RM ", 27);
    freq.put("Län", 43);
    freq.put("ty ", 263);
    freq.put("do ", 130);
    freq.put("tyl", 49);
    freq.put("eug", 272);
    freq.put("typ", 40);
    freq.put("don", 94);
    freq.put("doo", 88);
    freq.put("dol", 64);
    freq.put("dom", 37);
    freq.put("doc", 1064);
    freq.put("m", 65595);
    freq.put("ämm", 57);
    freq.put("ämp", 66);
    freq.put("dor", 338);
    freq.put("dos", 45);
    freq.put("dop", 40);
    freq.put("dow", 122);
    freq.put(" We", 3370);
    freq.put(" Wa", 1957);
    freq.put(" Wo", 1459);
    freq.put(" Wh", 87);
    freq.put(" Wi", 2194);
    freq.put(" Wu", 214);
    freq.put("ba ", 65);
    freq.put(" W ", 64);
    freq.put("völ", 52);
    freq.put("bat", 88);
    freq.put("bau", 376);
    freq.put("bar", 553);
    freq.put("bas", 82);
    freq.put("bay", 50);
    freq.put("bad", 87);
    freq.put("möc", 173);
    freq.put("bab", 32);
    freq.put("bac", 253);
    freq.put("mög", 164);
    freq.put("ban", 221);
    freq.put("bal", 472);
    freq.put("bam", 31);
    freq.put("bah", 134);
    freq.put(" Wä", 191);
    freq.put("om ", 839);
    freq.put(" Wö", 30);
    freq.put(" Wü", 157);
    freq.put("Eff", 30);
    freq.put("Ruh", 69);
    freq.put("Run", 109);
    freq.put("un ", 668);
    freq.put("Rus", 40);
    freq.put("omb", 129);
    freq.put("C", 3367);
    freq.put("omg", 28);
    freq.put("omf", 33);
    freq.put("ome", 379);
    freq.put("omi", 280);
    freq.put("omo", 82);
    freq.put("omm", 2246);
    freq.put("omp", 289);
    freq.put("fnu", 80);
    freq.put("uns", 1328);
    freq.put("unt", 981);
    freq.put("unv", 41);
    freq.put("unw", 31);
    freq.put("unz", 42);
    freq.put("una", 88);
    freq.put("fne", 110);
    freq.put("unc", 49);
    freq.put("und", 10174);
    freq.put("une", 206);
    freq.put("unf", 221);
    freq.put("ung", 6591);
    freq.put("uni", 184);
    freq.put("unk", 663);
    freq.put("unl", 33);
    freq.put("unm", 33);
    freq.put("unn", 80);
    freq.put("iö", 25);
    freq.put("eBa", 35);
    freq.put("iß", 1085);
    freq.put("C ", 675);
    freq.put("är ", 139);
    freq.put("sl ", 26);
    freq.put("gli", 500);
    freq.put("Ci", 94);
    freq.put("Ch", 774);
    freq.put("Co", 850);
    freq.put("Cl", 219);
    freq.put("Ca", 489);
    freq.put("äru", 32);
    freq.put("ärt", 137);
    freq.put("Ce", 93);
    freq.put("ärk", 114);
    freq.put("slo", 70);
    freq.put("ärm", 117);
    freq.put("sli", 225);
    freq.put("Vö", 33);
    freq.put("sle", 125);
    freq.put("äre", 467);
    freq.put("sla", 189);
    freq.put("Cu", 60);
    freq.put("ix", 354);
    freq.put("iz", 848);
    freq.put("Nad", 25);
    freq.put("Naj", 83);
    freq.put("ip", 932);
    freq.put("Nah", 33);
    freq.put("ir", 8008);
    freq.put("iu", 225);
    freq.put("it", 16163);
    freq.put("iw", 112);
    freq.put("iv", 1422);
    freq.put("ii", 323);
    freq.put("Nas", 39);
    freq.put("ik", 2078);
    freq.put("im", 6825);
    freq.put("il", 6543);
    freq.put("io", 3073);
    freq.put("in", 40153);
    freq.put("ia", 1987);
    freq.put("ic", 27384);
    freq.put("ib", 2234);
    freq.put("ie", 31908);
    freq.put("id", 2555);
    freq.put("ig", 7423);
    freq.put("if", 964);
    freq.put("V ", 502);
    freq.put("iP", 398);
    freq.put("iT", 45);
    freq.put("iM", 29);
    freq.put("iO", 63);
    freq.put("Na ", 171);
    freq.put("kis", 79);
    freq.put("kir", 49);
    freq.put("kip", 36);
    freq.put("kin", 229);
    freq.put("kil", 27);
    freq.put("i ", 5782);
    freq.put("kig", 47);
    freq.put("kie", 86);
    freq.put("Va", 159);
    freq.put("Ve", 1758);
    freq.put("Vf", 36);
    freq.put("Vi", 941);
    freq.put("Vo", 1099);
    freq.put("slä", 25);
    freq.put("Wün", 48);
    freq.put("yen", 62);
    freq.put("op ", 392);
    freq.put("Wür", 94);
    freq.put("yer", 303);
    freq.put("opt", 83);
    freq.put("opp", 221);
    freq.put("ops", 41);
    freq.put("ye ", 34);
    freq.put("ope", 105);
    freq.put("opf", 290);
    freq.put("opa", 160);
    freq.put("opo", 42);
    freq.put("oph", 98);
    freq.put("opi", 52);
    freq.put("Ars", 92);
    freq.put("Art", 237);
    freq.put("öff", 314);
    freq.put("Arz", 49);
    freq.put("Arb", 333);
    freq.put("Arc", 57);
    freq.put("Arg", 27);
    freq.put("öft", 31);
    freq.put("Arm", 80);
    freq.put("www", 217);
    freq.put("bri", 514);
    freq.put("zu ", 3342);
    freq.put("bra", 707);
    freq.put("eeh", 49);
    freq.put("Tur", 60);
    freq.put("opä", 34);
    freq.put("ww ", 177);
    freq.put("zur", 798);
    freq.put("zus", 327);
    freq.put("zuv", 46);
    freq.put("zut", 26);
    freq.put("zub", 36);
    freq.put("zuf", 82);
    freq.put("zug", 236);
    freq.put("zue", 31);
    freq.put("zuh", 71);
    freq.put("zun", 280);
    freq.put("zul", 55);
    freq.put("zum", 1215);
    freq.put("TE ", 107);
    freq.put("Z", 2794);
    freq.put("iqu", 33);
    freq.put("fs ", 92);
    freq.put("EA ", 36);
    freq.put("fsb", 38);
    freq.put("fsc", 62);
    freq.put("Wic", 32);
    freq.put("fsi", 27);
    freq.put("Wil", 180);
    freq.put("Wik", 40);
    freq.put("Wit", 66);
    freq.put("fst", 195);
    freq.put("Wir", 653);
    freq.put("Grö", 44);
    freq.put("Grü", 235);
    freq.put("di ", 95);
    freq.put("Bör", 70);
    freq.put("din", 464);
    freq.put("dio", 299);
    freq.put("dik", 38);
    freq.put("did", 62);
    freq.put("die", 8122);
    freq.put("ers", 4515);
    freq.put("dia", 213);
    freq.put("dic", 653);
    freq.put("diz", 70);
    freq.put("dit", 264);
    freq.put("diu", 48);
    freq.put("div", 60);
    freq.put("dir", 838);
    freq.put("dis", 197);
    freq.put("Gru", 227);
    freq.put(" Yo", 190);
    freq.put(" Ya", 64);
    freq.put(" Ye", 60);
    freq.put("Gre", 99);
    freq.put("Gra", 300);
    freq.put("Gro", 215);
    freq.put("Gri", 178);
    freq.put("tne", 222);
    freq.put("AM ", 36);
    freq.put("bo ", 60);
    freq.put("DS ", 47);
    freq.put("box", 82);
    freq.put("boy", 26);
    freq.put("hbe", 55);
    freq.put("tni", 51);
    freq.put("bor", 87);
    freq.put("hba", 138);
    freq.put("bol", 28);
    freq.put("bon", 106);
    freq.put("boo", 460);
    freq.put("hbu", 29);
    freq.put("boa", 51);
    freq.put("boc", 36);
    freq.put("bod", 45);
    freq.put("oo ", 216);
    freq.put("ayi", 45);
    freq.put("aye", 258);
    freq.put("ul ", 132);
    freq.put("ays", 48);
    freq.put("Bek", 48);
    freq.put("Beh", 41);
    freq.put("Bei", 482);
    freq.put("Ben", 99);
    freq.put("Bel", 101);
    freq.put("oom", 38);
    freq.put("Bec", 32);
    freq.put("ooo", 305);
    freq.put("Bea", 93);
    freq.put("Bef", 34);
    freq.put("Beg", 65);
    freq.put("Bed", 53);
    freq.put("Bee", 29);
    freq.put("Bez", 82);
    freq.put("oot", 97);
    freq.put("oop", 42);
    freq.put("oos", 29);
    freq.put("oor", 59);
    freq.put("Ber", 925);
    freq.put("Bes", 479);
    freq.put("Bev", 26);
    freq.put("Bew", 150);
    freq.put("Bet", 417);
    freq.put("uls", 34);
    freq.put("flu", 108);
    freq.put("ay ", 453);
    freq.put("maß", 42);
    freq.put("fli", 225);
    freq.put("ulk", 27);
    freq.put("uli", 224);
    freq.put("flo", 41);
    freq.put("fla", 172);
    freq.put("ula", 110);
    freq.put("fle", 277);
    freq.put("uld", 232);
    freq.put("ule", 355);
    freq.put("sn ", 43);
    freq.put("uan", 32);
    freq.put("ma ", 552);
    freq.put("nym", 50);
    freq.put("mas", 207);
    freq.put("mar", 430);
    freq.put("mau", 42);
    freq.put("mat", 429);
    freq.put("sna", 70);
    freq.put("Url", 143);
    freq.put("max", 37);
    freq.put("maz", 93);
    freq.put("maa", 25);
    freq.put("mac", 1670);
    freq.put("mag", 290);
    freq.put("mai", 100);
    freq.put("mah", 31);
    freq.put("mak", 26);
    freq.put("mal", 2936);
    freq.put("man", 2531);
    freq.put("flü", 48);
    freq.put("Ede", 41);
    freq.put("Edi", 35);
    freq.put("kma", 47);
    freq.put("q", 399);
    freq.put("ny ", 134);
    freq.put("flä", 30);
    freq.put("lse", 70);
    freq.put("lsb", 41);
    freq.put("lsc", 299);
    freq.put("lsa", 38);
    freq.put("lso", 550);
    freq.put("lsk", 25);
    freq.put("jä", 117);
    freq.put("lst", 423);
    freq.put("lsr", 43);
    freq.put("lsp", 51);
    freq.put(" aa", 32);
    freq.put(" ab", 3137);
    freq.put(" ac", 213);
    freq.put(" ad", 56);
    freq.put(" ag", 30);
    freq.put(" ah", 99);
    freq.put(" ak", 228);
    freq.put(" al", 3451);
    freq.put(" am", 1252);
    freq.put(" an", 3485);
    freq.put(" ap", 57);
    freq.put(" ar", 356);
    freq.put(" as", 50);
    freq.put(" at", 96);
    freq.put(" au", 9495);
    freq.put(" aw", 34);
    freq.put("ls ", 1998);
    freq.put("kku", 46);
    freq.put("Sha", 62);
    freq.put("kke", 30);
    freq.put("Shi", 82);
    freq.put("Sho", 180);
    freq.put(" a ", 135);
    freq.put(" Fü", 362);
    freq.put("Ab ", 114);
    freq.put("Lus", 95);
    freq.put("Lux", 40);
    freq.put("Lud", 25);
    freq.put("Luf", 111);
    freq.put("or ", 1510);
    freq.put("Ken", 89);
    freq.put("Kel", 45);
    freq.put("Kei", 243);
    freq.put("öd ", 43);
    freq.put("Key", 30);
    freq.put("Ker", 97);
    freq.put("orz", 59);
    freq.put("RT ", 750);
    freq.put("G", 8251);
    freq.put("ory", 46);
    freq.put("orw", 60);
    freq.put("ort", 1513);
    freq.put("oru", 103);
    freq.put("orr", 284);
    freq.put("ors", 454);
    freq.put("orp", 67);
    freq.put("orn", 230);
    freq.put("oro", 36);
    freq.put("orl", 120);
    freq.put("orm", 552);
    freq.put("ork", 134);
    freq.put("orh", 140);
    freq.put("ori", 347);
    freq.put("orf", 266);
    freq.put("org", 1331);
    freq.put("ord", 714);
    freq.put("ore", 453);
    freq.put("orb", 281);
    freq.put("orc", 45);
    freq.put("ora", 219);
    freq.put("App", 389);
    freq.put("ück", 1225);
    freq.put("üch", 290);
    freq.put("öde", 53);
    freq.put("Apo", 26);
    freq.put("Apf", 36);
    freq.put("fek", 149);
    freq.put("ua ", 33);
    freq.put("Dä", 36);
    freq.put("Dü", 95);
    freq.put("Dö", 37);
    freq.put("zsc", 39);
    freq.put("IS ", 50);
    freq.put("Do", 701);
    freq.put("Di", 3066);
    freq.put("De", 3061);
    freq.put("Da", 3309);
    freq.put("²", 27);
    freq.put("Du", 946);
    freq.put("Dr", 565);
    freq.put("iwi", 75);
    freq.put("D ", 2191);
    freq.put("ge ", 2932);
    freq.put("We", 3381);
    freq.put("Wa", 1982);
    freq.put("Wo", 1473);
    freq.put("Wi", 2214);
    freq.put("Wh", 88);
    freq.put("Wu", 214);
    freq.put("ges", 2970);
    freq.put("ger", 3073);
    freq.put("gep", 215);
    freq.put("gew", 733);
    freq.put("get", 347);
    freq.put("gez", 146);
    freq.put("gec", 28);
    freq.put("geb", 1223);
    freq.put("gea", 56);
    freq.put("uta", 62);
    freq.put("geg", 925);
    freq.put("gef", 794);
    freq.put("gee", 60);
    freq.put("ged", 224);
    freq.put("gek", 340);
    freq.put("gei", 382);
    freq.put("geh", 1880);
    freq.put("geo", 49);
    freq.put("gen", 8819);
    freq.put("gem", 655);
    freq.put("gel", 1306);
    freq.put("W ", 376);
    freq.put("tu ", 44);
    freq.put("j ", 33);
    freq.put("Wä", 191);
    freq.put("ain", 427);
    freq.put("Wö", 30);
    freq.put("Wü", 158);
    freq.put("CH ", 262);
    freq.put("ju", 217);
    freq.put("tur", 618);
    freq.put("tus", 76);
    freq.put("tut", 294);
    freq.put("tuh", 30);
    freq.put("jo", 145);
    freq.put("tul", 38);
    freq.put("tum", 108);
    freq.put("tun", 1691);
    freq.put("je", 2694);
    freq.put("tub", 59);
    freq.put("tud", 256);
    freq.put("ja", 2550);
    freq.put("tuf", 38);
    freq.put("rän", 164);
    freq.put("dkr", 37);
    freq.put("dka", 32);
    freq.put("dko", 48);
    freq.put("äis", 25);
    freq.put("paß", 177);
    freq.put("tua", 71);
    freq.put("Ty", 72);
    freq.put("tue", 227);
    freq.put("bma", 27);
    freq.put("hde", 76);
    freq.put("pap", 43);
    freq.put("par", 496);
    freq.put("pas", 451);
    freq.put("pat", 76);
    freq.put("pau", 50);
    freq.put("paz", 25);
    freq.put("paa", 190);
    freq.put("pac", 163);
    freq.put("pad", 32);
    freq.put("pag", 86);
    freq.put("pak", 43);
    freq.put("pal", 34);
    freq.put("pam", 39);
    freq.put("pan", 363);
    freq.put("oin", 113);
    freq.put("oil", 32);
    freq.put("A ", 856);
    freq.put("oid", 100);
    freq.put("pa ", 186);
    freq.put("röf", 227);
    freq.put("rös", 40);
    freq.put("röt", 53);
    freq.put("mo ", 133);
    freq.put("gre", 234);
    freq.put("mos", 44);
    freq.put("mor", 600);
    freq.put("Upd", 95);
    freq.put("mou", 39);
    freq.put("mot", 100);
    freq.put("mok", 80);
    freq.put("mon", 204);
    freq.put("mom", 79);
    freq.put("mob", 131);
    freq.put("mod", 113);
    freq.put("zle", 95);
    freq.put("Ebe", 27);
    freq.put("zla", 26);
    freq.put("zli", 171);
    freq.put("höh", 104);
    freq.put("Nei", 170);
    freq.put("höc", 29);
    freq.put("Nee", 40);
    freq.put("Neb", 53);
    freq.put("Dr ", 57);
    freq.put("Net", 219);
    freq.put("hör", 525);
    freq.put("Ner", 73);
    freq.put("Mee", 55);
    freq.put("Med", 260);
    freq.put(" ch", 192);
    freq.put(" co", 401);
    freq.put(" cl", 35);
    freq.put(" cm", 74);
    freq.put(" cc", 39);
    freq.put(" ca", 138);
    freq.put("Mei", 636);
    freq.put("Meh", 201);
    freq.put("Met", 119);
    freq.put("Mes", 124);
    freq.put("Mer", 190);
    freq.put(" cr", 30);
    freq.put("röß", 171);
    freq.put("Dru", 81);
    freq.put("Ne ", 35);
    freq.put("Dri", 54);
    freq.put("Dro", 59);
    freq.put("Dra", 74);
    freq.put("Dre", 230);
    freq.put("Me ", 33);
    freq.put("km ", 172);
    freq.put(" c ", 38);
    freq.put("VD ", 43);
    freq.put("rüß", 89);
    freq.put("Ac", 403);
    freq.put("ümm", 48);
    freq.put("Ai", 84);
    freq.put("Ava", 32);
    freq.put("ßba", 147);
    freq.put("ätz", 178);
    freq.put("US ", 212);
    freq.put("u", 90137);
    freq.put("Val", 31);
    freq.put("gt", 2152);
    freq.put("Vat", 43);
    freq.put("gr", 2091);
    freq.put("hy ", 25);
    freq.put("ws ", 339);
    freq.put("gp", 35);
    freq.put("DJ ", 31);
    freq.put("ium", 160);
    freq.put("tän", 188);
    freq.put("täg", 42);
    freq.put("täd", 25);
    freq.put("Süß", 30);
    freq.put("TA ", 37);
    freq.put("aja", 242);
    freq.put("tär", 113);
    freq.put("ius", 45);
    freq.put("täu", 34);
    freq.put("tät", 348);
    freq.put("gg", 373);
    freq.put("wse", 114);
    freq.put("hys", 39);
    freq.put("gb", 105);
    freq.put("gg ", 42);
    freq.put("gm", 59);
    freq.put("aba", 94);
    freq.put("abb", 54);
    freq.put("abe", 4758);
    freq.put("abg", 237);
    freq.put("abh", 67);
    freq.put("abi", 139);
    freq.put("abl", 149);
    freq.put("abn", 25);
    freq.put("abo", 82);
    freq.put("abr", 90);
    freq.put("abs", 291);
    freq.put("abt", 167);
    freq.put("abw", 49);
    freq.put("aby", 100);
    freq.put("abz", 45);
    freq.put("ggt", 29);
    freq.put("K", 8006);
    freq.put("gge", 185);

    init3();
  }
  private static void init3() {
    
    freq.put("züg", 31);
    freq.put("zün", 29);
    freq.put("ggi", 36);
    freq.put("ab ", 1908);
    freq.put("Wur", 47);
    freq.put("Süd", 82);
    freq.put("fwe", 28);
    freq.put("fwa", 39);
    freq.put("Wun", 94);
    freq.put("Noc", 140);
    freq.put("twa", 434);
    freq.put("eye", 38);
    freq.put("twe", 300);
    freq.put("twi", 369);
    freq.put("two", 293);
    freq.put("LT ", 48);
    freq.put("de ", 4849);
    freq.put("lkt", 29);
    freq.put("dex", 38);
    freq.put("ey ", 277);
    freq.put("dez", 30);
    freq.put("hüt", 137);
    freq.put("dep", 29);
    freq.put("der", 12863);
    freq.put("des", 1906);
    freq.put("det", 547);
    freq.put("deu", 464);
    freq.put("hür", 33);
    freq.put("dei", 534);
    freq.put("dek", 30);
    freq.put("del", 567);
    freq.put("dem", 1943);
    freq.put("den", 7856);
    freq.put("deo", 448);
    freq.put("dea", 64);
    freq.put("deb", 60);
    freq.put("dec", 163);
    freq.put("dee", 173);
    freq.put("def", 70);
    freq.put("iPa", 110);
    freq.put("iPh", 228);
    freq.put("iPo", 44);
    freq.put("Typ", 63);
    freq.put("Dok", 65);
    freq.put("Don", 126);
    freq.put("Dol", 38);
    freq.put("Dom", 57);
    freq.put("Doc", 79);
    freq.put("Dor", 125);
    freq.put("Dos", 27);
    freq.put("Dop", 40);
    freq.put("Dow", 61);
    freq.put("hfr", 29);
    freq.put("cs ", 58);
    freq.put("ry ", 260);
    freq.put("uh ", 82);
    freq.put("ok ", 562);
    freq.put("pt", 920);
    freq.put("AY ", 26);
    freq.put("pch", 44);
    freq.put("oks", 42);
    freq.put("okr", 98);
    freq.put("oku", 75);
    freq.put("Bas", 132);
    freq.put("uha", 113);
    freq.put("uhl", 38);
    freq.put("Bay", 238);
    freq.put("oka", 165);
    freq.put("Bad", 215);
    freq.put("uhu", 48);
    freq.put("oke", 58);
    freq.put("Bac", 83);
    freq.put("Ban", 233);
    freq.put("Bal", 124);
    freq.put("Bam", 43);
    freq.put("oko", 90);
    freq.put("mm ", 574);
    freq.put("Oma", 26);
    freq.put("E ", 1211);
    freq.put("sbr", 60);
    freq.put("Uns", 147);
    freq.put("Unt", 398);
    freq.put("sbu", 145);
    freq.put("mmu", 220);
    freq.put("mmt", 1177);
    freq.put("mms", 149);
    freq.put("mmm", 73);
    freq.put("mml", 55);
    freq.put("mmo", 73);
    freq.put("sba", 191);
    freq.put("mmi", 138);
    freq.put("mmh", 30);
    freq.put("Unf", 93);
    freq.put("sbe", 190);
    freq.put("mme", 3394);
    freq.put("Uni", 145);
    freq.put("sbi", 100);
    freq.put("mma", 70);
    freq.put("sbl", 34);
    freq.put("Em", 175);
    freq.put("El", 303);
    freq.put("En", 917);
    freq.put("Ei", 1725);
    freq.put("Eh", 98);
    freq.put("Ed", 117);
    freq.put("Eg", 49);
    freq.put("Ef", 33);
    freq.put("Ea", 34);
    freq.put("Ec", 107);
    freq.put("Eb", 51);
    freq.put("Ey", 35);
    freq.put("Ex", 315);
    freq.put("Eu", 782);
    freq.put("Et", 50);
    freq.put("Ev", 79);
    freq.put("Ep", 29);
    freq.put("Es", 698);
    freq.put("Er", 1303);
    freq.put("gö", 33);
    freq.put(" eB", 52);
    freq.put(" el", 74);
    freq.put(" em", 223);
    freq.put(" en", 832);
    freq.put(" eh", 406);
    freq.put(" ei", 8560);
    freq.put(" ek", 28);
    freq.put(" ed", 26);
    freq.put(" ef", 28);
    freq.put(" eg", 98);
    freq.put(" eb", 199);
    freq.put(" ec", 382);
    freq.put(" ex", 172);
    freq.put(" ey", 47);
    freq.put(" et", 346);
    freq.put(" eu", 531);
    freq.put("kos", 311);
    freq.put(" ew", 31);
    freq.put("kot", 85);
    freq.put(" er", 3177);
    freq.put(" es", 2747);
    freq.put("gü", 110);
    freq.put("toc", 95);
    freq.put("b", 44806);
    freq.put("kä", 141);
    freq.put("Xb", 26);
    freq.put("ko ", 129);
    freq.put(" e ", 107);
    freq.put("kö", 699);
    freq.put("kü", 275);
    freq.put("äck", 54);
    freq.put("k ", 4497);
    freq.put("Kis", 26);
    freq.put("Kir", 86);
    freq.put("Kit", 27);
    freq.put("Kin", 514);
    freq.put("Kil", 50);
    freq.put("Kie", 46);
    freq.put("Kid", 26);
    freq.put("Ato", 47);
    freq.put("RP ", 31);
    freq.put("Att", 34);
    freq.put("kc", 35);
    freq.put("kb", 82);
    freq.put("ka", 3940);
    freq.put("kg", 103);
    freq.put("kf", 231);
    freq.put("ke", 7813);
    freq.put("kd", 31);
    freq.put("kk", 150);
    freq.put("ki", 777);
    freq.put("kh", 79);
    freq.put("ko", 3393);
    freq.put("kn", 247);
    freq.put("km", 248);
    freq.put("kl", 2076);
    freq.put("ks", 841);
    freq.put("kr", 1125);
    freq.put("öhn", 77);
    freq.put("kw", 154);
    freq.put("kv", 28);
    freq.put("ku", 1298);
    freq.put("kt", 3983);
    freq.put("öhe", 104);
    freq.put("kz", 59);
    freq.put("ky", 121);
    freq.put(" Bä", 73);
    freq.put(" Bö", 100);
    freq.put(" Bü", 230);
    freq.put("Opt", 69);
    freq.put("Ope", 82);
    freq.put("Opf", 35);
    freq.put("Füß", 28);
    freq.put("ph", 378);
    freq.put(" Be", 3195);
    freq.put(" Ba", 1823);
    freq.put(" Bl", 845);
    freq.put(" Bo", 693);
    freq.put(" Bi", 1361);
    freq.put(" Bu", 947);
    freq.put("ik ", 716);
    freq.put(" Br", 953);
    freq.put("DD ", 89);
    freq.put(" B ", 166);
    freq.put("iku", 67);
    freq.put("ikt", 75);
    freq.put("ika", 331);
    freq.put("GE ", 37);
    freq.put("ike", 542);
    freq.put("kte", 533);
    freq.put("iki", 59);
    freq.put("iko", 105);
    freq.put("TC ", 44);
    freq.put("Füh", 49);
    freq.put("Yea", 40);
    freq.put("Für", 245);
    freq.put("nhä", 34);
    freq.put("lbs", 338);
    freq.put("rae", 59);
    freq.put("lbu", 121);
    freq.put("ga ", 263);
    freq.put("ND ", 104);
    freq.put("ewä", 74);
    freq.put("HE ", 54);
    freq.put("ewö", 60);
    freq.put("gaz", 50);
    freq.put("gau", 36);
    freq.put("gat", 75);
    freq.put("gas", 79);
    freq.put("gar", 732);
    freq.put("gan", 1045);
    freq.put("gam", 79);
    freq.put("gal", 196);
    freq.put("gag", 43);
    freq.put("gab", 266);
    freq.put("lba", 82);
    freq.put("fur", 220);
    freq.put("nhö", 40);
    freq.put("fuc", 62);
    freq.put("fun", 450);
    freq.put("lbe", 398);
    freq.put("aa", 1394);
    freq.put("sy ", 52);
    freq.put("Ira", 26);
    freq.put("Irg", 84);
    freq.put("ewi", 484);
    freq.put("ewo", 192);
    freq.put("bs ", 226);
    freq.put("ewa", 169);
    freq.put("ewe", 506);
    freq.put("ews", 289);
    freq.put("ewu", 71);
    freq.put("syc", 34);
    freq.put("dge", 111);
    freq.put("fuß", 32);
    freq.put("OW ", 26);
    freq.put("sym", 29);
    freq.put("sys", 75);
    freq.put("ew ", 224);
    freq.put("y", 5087);
    freq.put("ae", 301);
    freq.put("ldb", 38);
    freq.put("lda", 47);
    freq.put("lde", 734);
    freq.put("ldk", 27);
    freq.put("ldi", 131);
    freq.put("ldo", 101);
    freq.put("bi ", 72);
    freq.put("lds", 93);
    freq.put("ldu", 212);
    freq.put("rgr", 100);
    freq.put("rgs", 37);
    freq.put("rgt", 41);
    freq.put("rgu", 65);
    freq.put("üße", 165);
    freq.put("rga", 314);
    freq.put("rge", 2447);
    freq.put("rgh", 37);
    freq.put("rgi", 209);
    freq.put("rgl", 127);
    freq.put("rgo", 34);
    freq.put("bin", 1323);
    freq.put("Din", 152);
    freq.put("ld ", 1016);
    freq.put("Die", 2169);
    freq.put("Dig", 43);
    freq.put("Dia", 76);
    freq.put("Dic", 121);
    freq.put("AL ", 43);
    freq.put("bit", 385);
    freq.put("bir", 28);
    freq.put("bis", 1301);
    freq.put("Dir", 191);
    freq.put("Dis", 172);
    freq.put("üß ", 99);
    freq.put("rg ", 840);
    freq.put("uf ", 4136);
    freq.put("pez", 93);
    freq.put("pet", 69);
    freq.put("Kni", 29);
    freq.put("per", 1120);
    freq.put("pel", 226);
    freq.put("pen", 543);
    freq.put("rgä", 40);
    freq.put("pei", 144);
    freq.put("pek", 86);
    freq.put("ped", 43);
    freq.put("pee", 25);
    freq.put("ape", 98);
    freq.put("pec", 51);
    freq.put("Box", 48);
    freq.put("ufi", 38);
    freq.put("ufk", 27);
    freq.put("ufl", 74);
    freq.put("ufm", 114);
    freq.put("ufn", 57);
    freq.put("oes", 37);
    freq.put("oer", 40);
    freq.put("Bor", 64);
    freq.put("Bos", 41);
    freq.put("Bot", 46);
    freq.put("ufe", 772);
    freq.put("O", 3416);
    freq.put("ufg", 333);
    freq.put("Boh", 28);
    freq.put("ufz", 82);
    freq.put("usd", 42);
    freq.put("oen", 46);
    freq.put("Bon", 95);
    freq.put("Boo", 86);
    freq.put("oeb", 75);
    freq.put("ufr", 120);
    freq.put("Boc", 77);
    freq.put("Bod", 78);
    freq.put("ufw", 52);
    freq.put("ä", 9292);
    freq.put("üte", 75);
    freq.put("ütl", 28);
    freq.put("uso", 51);
    freq.put("Hum", 49);
    freq.put("ütz", 219);
    freq.put("pe ", 346);
    freq.put("Hun", 161);
    freq.put("nsh", 52);
    freq.put("nsi", 281);
    freq.put("nsk", 39);
    freq.put("nsl", 31);
    freq.put("nsm", 37);
    freq.put("nso", 177);
    freq.put("nsa", 281);
    freq.put("nsb", 72);
    freq.put("nsc", 1500);
    freq.put("nse", 1079);
    freq.put("nsf", 71);
    freq.put("nsg", 62);
    freq.put("usi", 467);
    freq.put("nsp", 334);
    freq.put("nsr", 26);
    freq.put("nss", 45);
    freq.put("nst", 2148);
    freq.put("nsu", 72);
    freq.put("nsv", 29);
    freq.put("nsw", 80);
    freq.put(" gö", 27);
    freq.put("mke", 27);
    freq.put("Kön", 99);
    freq.put("Köl", 166);
    freq.put("hön", 907);
    freq.put("usu", 28);
    freq.put("bäu", 44);
    freq.put(" gä", 28);
    freq.put("ust", 940);
    freq.put("Kör", 46);
    freq.put("bär", 37);
    freq.put("uss", 2050);
    freq.put(" R ", 66);
    freq.put("sdr", 35);
    freq.put("ns ", 2086);
    freq.put("Flu", 184);
    freq.put("Ult", 31);
    freq.put("Fli", 74);
    freq.put("sde", 78);
    freq.put("sda", 67);
    freq.put("Flo", 65);
    freq.put("Fla", 147);
    freq.put("sdo", 40);
    freq.put("Fle", 80);
    freq.put("sdi", 37);
    freq.put("usz", 60);
    freq.put("zhe", 30);
    freq.put("lys", 84);
    freq.put("nsä", 30);
    freq.put("New", 297);
    freq.put(" e", 18214);
    freq.put("Mas", 139);
    freq.put(" gu", 1513);
    freq.put("Mau", 72);
    freq.put("Mat", 133);
    freq.put("Max", 64);
    freq.put(" gg", 32);
    freq.put("Mac", 255);
    freq.put(" ge", 8994);
    freq.put("Mad", 43);
    freq.put("Mag", 148);
    freq.put(" ga", 1106);
    freq.put("Mai", 219);
    freq.put(" go", 153);
    freq.put(" gl", 975);
    freq.put("Mam", 49);
    freq.put("Mal", 223);
    freq.put("Man", 667);
    freq.put("ly ", 165);
    freq.put("au", 18479);
    freq.put("Mec", 57);
    freq.put(" g ", 78);
    freq.put("Mel", 80);
    freq.put(" b", 11742);
    freq.put(" c", 1008);
    freq.put("Men", 495);
    freq.put(" f", 8945);
    freq.put(" g", 15022);
    freq.put(" d", 38693);
    freq.put("ön ", 425);
    freq.put(" j", 4790);
    freq.put(" k", 8229);
    freq.put(" h", 12530);
    freq.put(" i", 26510);
    freq.put(" n", 15667);
    freq.put(" o", 3835);
    freq.put(" l", 5278);
    freq.put(" m", 20138);
    freq.put(" r", 2870);
    freq.put(" s", 23907);
    freq.put(" p", 2308);
    freq.put(" q", 127);
    freq.put(" v", 10277);
    freq.put(" w", 19798);
    freq.put(" t", 3458);
    freq.put(" u", 11424);
    freq.put(" z", 7309);
    freq.put(" x", 969);
    freq.put(" y", 179);
    freq.put(" B", 11127);
    freq.put(" C", 3261);
    freq.put(" A", 11476);
    freq.put(" F", 8639);
    freq.put(" G", 8155);
    freq.put(" D", 15798);
    freq.put(" E", 7932);
    freq.put(" J", 3226);
    freq.put(" K", 7960);
    freq.put(" H", 8079);
    freq.put(" I", 7286);
    freq.put(" N", 6120);
    freq.put(" O", 3262);
    freq.put(" L", 5628);
    freq.put(" M", 10854);
    freq.put(" R", 5713);
    freq.put(" S", 18162);
    freq.put(" P", 7257);
    freq.put(" Q", 319);
    freq.put(" V", 4436);
    freq.put(" W", 10383);
    freq.put(" T", 7578);
    freq.put(" U", 3874);
    freq.put(" Z", 2774);
    freq.put(" X", 449);
    freq.put(" Y", 412);
    freq.put("öne", 469);
    freq.put("vll", 44);
    freq.put("önn", 695);
    freq.put("önl", 62);
    freq.put("öni", 54);
    freq.put("öns", 42);
    freq.put("mäd", 33);
    freq.put(" ä", 254);
    freq.put(" ö", 148);
    freq.put(" ü", 1622);
    freq.put(" Ä", 172);
    freq.put("Ort", 61);
    freq.put(" Ö", 177);
    freq.put("Ori", 52);
    freq.put("Org", 39);
    freq.put("Ord", 44);
    freq.put(" Ü", 337);
    freq.put("Ora", 29);
    freq.put("oci", 104);
    freq.put("och", 4891);
    freq.put("ock", 573);
    freq.put(" Do", 678);
    freq.put("Ver", 1664);
    freq.put(" Di", 3046);
    freq.put(" De", 3040);
    freq.put(" Da", 3297);
    freq.put("ii ", 55);
    freq.put("Ven", 25);
    freq.put(" Du", 943);
    freq.put(" Dr", 555);
    freq.put("cha", 2085);
    freq.put("chb", 241);
    freq.put("chd", 102);
    freq.put("che", 11510);
    freq.put("chf", 91);
    freq.put("chg", 154);
    freq.put("chh", 206);
    freq.put("chi", 1409);
    freq.put("chj", 25);
    freq.put("chk", 248);
    freq.put("chl", 2571);
    freq.put("chm", 902);
    freq.put("chn", 1203);
    freq.put("cho", 1915);
    freq.put("chp", 41);
    freq.put("Fa", 1569);
    freq.put("chr", 1255);
    freq.put("chs", 1449);
    freq.put("cht", 12172);
    freq.put("chu", 1193);
    freq.put("chv", 49);
    freq.put("chw", 1338);
    freq.put("Fi", 840);
    freq.put("chz", 103);
    freq.put("Fl", 606);
    freq.put("DF ", 81);
    freq.put("Fo", 924);
    freq.put(" D ", 1140);
    freq.put("iin", 26);
    freq.put("iii", 193);
    freq.put("ch ", 30785);
    freq.put("f", 36286);
    freq.put("F ", 402);
    freq.put(" Dä", 34);
    freq.put("wä", 827);
    freq.put(" Dö", 37);
    freq.put("afo", 29);
    freq.put("chä", 350);
    freq.put("afi", 204);
    freq.put("Fö", 32);
    freq.put("Ya", 66);
    freq.put("afe", 425);
    freq.put("aff", 524);
    freq.put("Fü", 363);
    freq.put("afa", 31);
    freq.put("tai", 124);
    freq.put("Fä", 55);
    freq.put("chö", 941);
    freq.put("aft", 829);
    freq.put("chü", 208);
    freq.put("äum", 212);
    freq.put("Y ", 165);
    freq.put("af ", 137);
    freq.put("da ", 1369);
    freq.put("eum", 47);
    freq.put("lg", 853);
    freq.put("ld", 2606);
    freq.put("wü", 793);
    freq.put("lb", 1307);
    freq.put("lc", 485);
    freq.put("tsh", 32);
    freq.put("la", 8269);
    freq.put("eue", 2143);
    freq.put("eud", 81);
    freq.put("ll", 12084);
    freq.put("euf", 62);
    freq.put("lj", 27);
    freq.put("lk", 704);
    freq.put("euc", 489);
    freq.put("li", 11589);
    freq.put("ißt", 213);
    freq.put("lw", 104);
    freq.put("lt", 5864);
    freq.put("lu", 2156);
    freq.put("lr", 139);
    freq.put("ls", 3678);
    freq.put("lp", 260);
    freq.put("euz", 79);
    freq.put("euu", 25);
    freq.put("eut", 3253);
    freq.put("tst", 398);
    freq.put("tsu", 38);
    freq.put("lz", 445);
    freq.put("tss", 106);
    freq.put("eus", 76);
    freq.put("eur", 373);
    freq.put("dad", 28);
    freq.put("daf", 255);
    freq.put("dag", 43);
    freq.put("dab", 230);
    freq.put("dac", 211);
    freq.put("dal", 78);
    freq.put("dam", 401);
    freq.put("dan", 1858);
    freq.put("sid", 119);
    freq.put("dah", 98);
    freq.put("ägl", 74);
    freq.put("dak", 37);
    freq.put("dat", 295);
    freq.put("dau", 125);
    freq.put("dav", 133);
    freq.put("dap", 37);
    freq.put("dar", 517);
    freq.put("das", 5583);
    freq.put("day", 61);
    freq.put("daz", 193);
    freq.put("äus", 119);
    freq.put("l ", 13700);
    freq.put("eu ", 363);
    freq.put("ts ", 1570);
    freq.put("dwo", 61);
    freq.put("uhe", 204);
    freq.put("lfe", 331);
    freq.put("lfa", 45);
    freq.put("lfi", 36);
    freq.put("lft", 113);
    freq.put("lfs", 56);
    freq.put("lfr", 31);
    freq.put("rez", 31);
    freq.put("lä", 1199);
    freq.put("rer", 801);
    freq.put("res", 1216);
    freq.put("rep", 90);
    freq.put("rev", 32);
    freq.put("rew", 30);
    freq.put("ret", 332);
    freq.put("reu", 943);
    freq.put("lö", 331);
    freq.put("rek", 242);
    freq.put("reh", 134);
    freq.put("rei", 3663);
    freq.put("ren", 3735);
    freq.put("rel", 114);
    freq.put("rem", 489);
    freq.put("reb", 64);
    freq.put("rec", 859);
    freq.put("lü", 537);
    freq.put("rea", 376);
    freq.put("ref", 231);
    freq.put("reg", 280);
    freq.put("red", 436);
    freq.put("ree", 183);
    freq.put("müs", 265);
    freq.put("lf ", 107);
    freq.put("müt", 51);
    freq.put("qua", 114);
    freq.put("bwa", 48);
    freq.put("que", 109);
    freq.put("bwe", 52);
    freq.put("müd", 74);
    freq.put("qui", 58);
    freq.put("mün", 27);
    freq.put("quo", 28);
    freq.put("bwo", 50);
    freq.put("re ", 2568);
    freq.put("daß", 41);
    freq.put("ud ", 47);
    freq.put("og ", 291);
    freq.put(" öf", 87);
    freq.put("sfü", 47);
    freq.put("ogs", 27);
    freq.put("ogr", 282);
    freq.put("ogl", 262);
    freq.put("ogo", 49);
    freq.put("ogn", 44);
    freq.put("ogi", 143);
    freq.put("rüs", 74);
    freq.put("udd", 44);
    freq.put("ude", 320);
    freq.put("oge", 252);
    freq.put("ogg", 124);
    freq.put("udi", 288);
    freq.put("oga", 172);
    freq.put("udo", 26);
    freq.put("lim", 249);
    freq.put("rün", 311);
    freq.put("Pap", 159);
    freq.put("Par", 434);
    freq.put("Pas", 93);
    freq.put("Pat", 100);
    freq.put("Pau", 84);
    freq.put("Paa", 25);
    freq.put("Pac", 55);
    freq.put("Pad", 145);
    freq.put("Pak", 36);
    freq.put("Pal", 45);
    freq.put("rüg", 39);
    freq.put("Pan", 92);
    freq.put("mik", 37);
    freq.put("rüf", 75);
    freq.put("mil", 207);
    freq.put("min", 694);
    freq.put("mic", 1560);
    freq.put("mie", 363);
    freq.put("mid", 49);
    freq.put("mig", 50);
    freq.put("mix", 28);
    freq.put("mis", 426);
    freq.put("mir", 1763);
    freq.put("mit", 4842);
    freq.put("sfr", 57);
    freq.put("Nat", 192);
    freq.put("sfo", 72);
    freq.put("sfl", 29);
    freq.put("sfi", 28);
    freq.put("sfe", 78);
    freq.put("sfa", 82);
    freq.put("mus", 1139);
    freq.put("mi ", 94);
    freq.put(" iP", 387);
    freq.put(" iT", 39);
    freq.put(" iO", 61);
    freq.put("kst", 195);
    freq.put("ksp", 31);
    freq.put(" ip", 27);
    freq.put("Mor", 513);
    freq.put(" ir", 409);
    freq.put(" is", 5573);
    freq.put(" it", 67);
    freq.put("Mot", 146);
    freq.put(" ih", 1330);
    freq.put("Moi", 51);
    freq.put("Moo", 28);
    freq.put("Mon", 344);
    freq.put(" in", 6689);
    freq.put("Mob", 96);
    freq.put(" ic", 7916);
    freq.put(" id", 56);
    freq.put("ksh", 40);
    freq.put(" ig", 28);
    freq.put("TZ ", 27);
    freq.put("bH ", 130);
    freq.put("uhr", 124);
    freq.put("ks ", 268);
    freq.put(" i ", 100);
    freq.put("Zol", 31);
    freq.put("Zoo", 28);
    freq.put("dä", 71);
    freq.put("ölk", 47);
    freq.put("wl", 29);
    freq.put("öll", 90);
    freq.put("öln", 173);
    freq.put("S", 18340);
    freq.put("ww", 399);
    freq.put("zbu", 35);
    freq.put("ws", 520);
    freq.put("wr", 25);
    freq.put("käm", 54);
    freq.put(" Fö", 32);
    freq.put("ohn", 998);
    freq.put("oho", 74);
    freq.put(" Fä", 55);
    freq.put("käu", 34);
    freq.put("ad", 3695);
    freq.put("ys ", 120);
    freq.put("ohe", 135);
    freq.put("ak", 1243);
    freq.put("OL ", 93);
    freq.put("Hom", 82);
    freq.put("am", 5493);
    freq.put("oha", 45);
    freq.put("cor", 60);
    freq.put("ao", 78);
    freq.put("cou", 99);
    freq.put("uin", 48);
    freq.put("näh", 80);
    freq.put("ysi", 89);
    freq.put("näm", 37);
    freq.put("näc", 294);
    freq.put("Hot", 201);
    freq.put("yse", 39);
    freq.put("UM ", 28);
    freq.put("näp", 33);
    freq.put("när", 34);
    freq.put("yst", 214);
    freq.put(" Fr", 2094);
    freq.put(" Fu", 456);
    freq.put(" Fa", 1558);
    freq.put("oht", 38);
    freq.put(" Fe", 943);
    freq.put(" Fi", 818);
    freq.put(" Fl", 601);
    freq.put(" Fo", 912);
    freq.put("io ", 311);
    freq.put("Nö", 28);
    freq.put("cod", 30);
    freq.put("SO ", 48);
    freq.put("iot", 93);
    freq.put("ios", 67);
    freq.put("ior", 76);
    freq.put("ion", 2392);
    freq.put("iol", 30);
    freq.put("com", 157);
    freq.put("con", 192);
    freq.put("adt", 348);
    freq.put("adu", 61);
    freq.put("adr", 48);
    freq.put("ads", 45);
    freq.put("gma", 29);
    freq.put("ady", 36);
    freq.put("add", 124);
    freq.put("ade", 1618);
    freq.put("adb", 48);
    freq.put(" mm", 62);
    freq.put("zös", 35);
    freq.put("ado", 53);
    freq.put("adl", 28);
    freq.put("adi", 288);
    freq.put("Hyp", 27);
    freq.put("ad ", 808);
    freq.put("nja", 45);
    freq.put("ui ", 46);
    freq.put("nju", 30);
    freq.put("esw", 137);
    freq.put("esv", 29);
    freq.put("esu", 554);
    freq.put("est", 3273);
    freq.put("ess", 2199);
    freq.put("esr", 41);
    freq.put("esp", 441);
    freq.put("esg", 31);
    freq.put("esf", 29);
    freq.put("ese", 2211);
    freq.put("esd", 84);
    freq.put("esc", 1486);
    freq.put("esb", 76);
    freq.put("esa", 346);
    freq.put("eso", 383);
    freq.put("esm", 69);
    freq.put("esl", 147);
    freq.put("esk", 68);
    freq.put("esi", 455);
    freq.put("esh", 115);
    freq.put("dch", 129);
    freq.put("Büc", 59);
    freq.put("dca", 34);
    freq.put("OS ", 133);
    freq.put("Bür", 131);
    freq.put("es ", 8018);
    freq.put("Twe", 208);
    freq.put("Twi", 411);
    freq.put(" Äh", 33);
    freq.put("rco", 33);
    freq.put("rch", 936);
    freq.put("rce", 74);
    freq.put("rca", 37);
    freq.put("Dep", 45);
    freq.put("bus", 94);
    freq.put("Der", 1167);
    freq.put("Des", 211);
    freq.put("Det", 45);
    freq.put("Deu", 703);
    freq.put("Dei", 194);
    freq.put("Dek", 28);
    freq.put("Del", 37);
    freq.put("Dem", 182);
    freq.put("Den", 203);
    freq.put("bum", 116);
    freq.put("Dea", 49);
    freq.put("Deb", 43);
    freq.put("Dec", 44);
    freq.put("Def", 28);
    freq.put("j", 5886);
    freq.put("pil", 25);
    freq.put("pin", 144);
    freq.put("pio", 41);
    freq.put("pic", 64);
    freq.put("pie", 1363);
    freq.put("ub ", 435);
    freq.put("pir", 90);
    freq.put("pis", 74);
    freq.put("pit", 148);
    freq.put("oad", 86);
    freq.put("oac", 34);
    freq.put("oal", 39);
    freq.put("oah", 63);
    freq.put("oar", 41);
    freq.put("Üb", 327);
    freq.put("Acc", 75);
    freq.put("ubs", 105);
    freq.put("pi ", 40);
    freq.put("Ach", 266);
    freq.put("ube", 533);
    freq.put("uba", 38);
    freq.put("ubb", 34);
    freq.put("Act", 28);
    freq.put("ubl", 141);
    freq.put("ubi", 64);
    freq.put("oa ", 44);
    freq.put(" kä", 45);
    freq.put("iße", 278);
    freq.put("nwe", 180);
    freq.put(" kö", 642);
    freq.put("nwa", 126);
    freq.put("nwo", 53);
    freq.put("nwi", 51);
    freq.put(" kü", 145);
    freq.put("Okt", 135);
    freq.put("Oka", 60);
    freq.put("Uhr", 549);
    freq.put("mwe", 83);
    freq.put("G ", 703);
    freq.put("iß ", 507);
    freq.put("Gu", 792);
    freq.put("Gr", 1327);
    freq.put("Fic", 42);
    freq.put("Zü", 44);
    freq.put("Ok ", 53);
    freq.put("Ge", 3020);
    freq.put("Ga", 762);
    freq.put("Go", 543);
    freq.put("Gm", 138);
    freq.put("Gl", 538);
    freq.put("Gi", 279);
    freq.put(" ka", 2061);
    freq.put(" kg", 36);
    freq.put(" ke", 1598);
    freq.put(" ki", 107);
    freq.put(" kn", 133);
    freq.put(" ko", 1750);
    freq.put(" kl", 785);
    freq.put(" km", 177);
    freq.put(" kr", 368);
    freq.put(" ku", 299);
    freq.put("kut", 43);
    freq.put("Z ", 335);
    freq.put("kur", 313);
    freq.put("kup", 25);
    freq.put("kun", 375);
    freq.put("kum", 108);
    freq.put("kul", 98);
    freq.put("kuc", 48);
    freq.put(" k ", 28);
    freq.put("TT ", 38);
    freq.put("Gö", 57);
    freq.put("Zo", 115);
    freq.put("Zi", 334);
    freq.put("Ze", 827);
    freq.put("Gü", 80);
    freq.put("Za", 156);
    freq.put("Gä", 67);
    freq.put("Zu", 771);
    freq.put("Zw", 268);
    freq.put("ku ", 55);
    freq.put("Koh", 30);
    freq.put("Kom", 410);
    freq.put("Kol", 109);
    freq.put("Koo", 26);
    freq.put("Kon", 443);
    freq.put("Koc", 34);
    freq.put("ör ", 70);
    freq.put("Kop", 178);
    freq.put("Kos", 121);
    freq.put("Kor", 50);
    freq.put("Göt", 32);
    freq.put("m ", 16227);
    freq.put("enü", 71);
    freq.put("örs", 133);
    freq.put("örp", 61);
    freq.put("öru", 38);
    freq.put("ört", 306);
    freq.put("öre", 246);
    freq.put("örd", 91);
    freq.put("örn", 27);
    freq.put("me", 11855);
    freq.put("md", 114);
    freq.put("mg", 199);
    freq.put("mf", 162);
    freq.put("ma", 9576);
    freq.put("g", 59938);
    freq.put("mc", 32);
    freq.put("mb", 1103);
    freq.put("mm", 6057);
    freq.put("ml", 321);
    freq.put("mo", 1673);
    freq.put("mn", 150);
    freq.put("mi", 10217);
    freq.put("mh", 112);
    freq.put("mk", 95);
    freq.put("mu", 1835);
    freq.put("mt", 1540);
    freq.put("mw", 128);
    freq.put("mp", 1583);
    freq.put("ms", 957);
    freq.put("mr", 45);
    freq.put("my", 117);
    freq.put("mz", 67);
    freq.put("ena", 705);
    freq.put("enb", 618);
    freq.put("enc", 117);
    freq.put("end", 3672);
    freq.put("ene", 1520);
    freq.put("enf", 337);
    freq.put("eng", 417);
    freq.put("enh", 336);
    freq.put("eni", 765);
    freq.put("enj", 35);
    freq.put("enk", 907);
    freq.put("enl", 415);
    freq.put("enm", 138);
    freq.put("enn", 3183);
    freq.put("eno", 196);
    freq.put("enp", 220);
    freq.put("enr", 151);
    freq.put("ens", 2614);
    freq.put("ent", 3420);
    freq.put("enu", 271);
    freq.put("env", 103);
    freq.put("enw", 142);
    freq.put("enz", 479);
    freq.put("ON ", 102);
    freq.put("II ", 55);
    freq.put("en ", 46702);
    freq.put("mä", 225);
    freq.put("lth", 124);
    freq.put("mö", 377);
    freq.put("mü", 462);
    freq.put(" Hy", 58);
    freq.put(" Hu", 382);
    freq.put(" Hi", 772);
    freq.put(" Ho", 981);
    freq.put(" Hm", 90);
    freq.put(" Ha", 3008);
    freq.put(" He", 1673);
    freq.put("ima", 279);
    freq.put("imb", 34);
    freq.put("ime", 303);
    freq.put("imi", 187);
    freq.put("cle", 37);
    freq.put("imm", 2048);
    freq.put("iml", 32);
    freq.put("imo", 74);
    freq.put("imn", 25);
    freq.put("imp", 92);
    freq.put("ims", 61);
    freq.put("imu", 29);
    freq.put("clu", 31);
    freq.put("JA ", 28);
    freq.put("SA ", 92);
    freq.put(" H ", 60);
    freq.put("im ", 3517);
    freq.put("ep ", 53);
    freq.put(" Hü", 58);
    freq.put(" Hö", 147);
    freq.put(" Hä", 168);
    freq.put("gol", 42);
    freq.put("goo", 73);
    freq.put("gon", 58);
    freq.put("got", 46);
    freq.put("gor", 44);
    freq.put("W", 10485);
    freq.put("Vid", 368);
    freq.put("Vie", 372);
    freq.put("go ", 120);
    freq.put("Vir", 25);
    freq.put("Vis", 29);
    freq.put("be ", 2181);
    freq.put("nhe", 293);
    freq.put("nha", 265);
    freq.put("nho", 131);
    freq.put("tor", 647);
    freq.put("tos", 249);
    freq.put("top", 198);
    freq.put("equ", 63);
    freq.put("EU ", 114);
    freq.put("tot", 233);
    freq.put("tou", 71);
    freq.put("tok", 25);
    freq.put("toh", 26);
    freq.put("ton", 205);
    freq.put("too", 44);
    freq.put("tol", 336);
    freq.put("tom", 170);
    freq.put("tob", 196);
    freq.put("raß", 140);
    freq.put("tof", 164);
    freq.put("tog", 90);
    freq.put("Fus", 46);
    freq.put("äch", 639);
    freq.put("Fuc", 27);
    freq.put("Fun", 127);
    freq.put("to ", 537);
    freq.put("thu", 25);
    freq.put("raf", 370);
    freq.put("rag", 1121);
    freq.put("rad", 1368);
    freq.put("lbr", 52);
    freq.put("rab", 215);
    freq.put("rac", 338);
    freq.put("ran", 1566);
    freq.put("ral", 304);
    freq.put("ram", 346);
    freq.put("rak", 247);
    freq.put("rah", 117);
    freq.put("rai", 236);
    freq.put("rav", 65);
    freq.put("raw", 31);
    freq.put("rat", 1120);
    freq.put("rau", 2165);
    freq.put("rar", 118);
    freq.put("ras", 362);
    freq.put("rap", 99);
    freq.put("lbi", 28);
    freq.put("raz", 25);
    freq.put("rax", 29);
    freq.put("ray", 50);
    freq.put("Syn", 27);
    freq.put("Sym", 27);
    freq.put("Sys", 81);
    freq.put("ra ", 297);
    freq.put("bst", 700);
    freq.put("bsp", 30);
    freq.put("lb ", 172);
    freq.put("bso", 76);
    freq.put("bsi", 76);
    freq.put("bse", 103);
    freq.put("bsa", 36);
    freq.put("bsc", 202);
    freq.put("Fuß", 167);
    freq.put("Ita", 66);
    freq.put("AS ", 160);
    freq.put("muß", 40);
    freq.put("Bin", 233);
    freq.put("Bio", 58);
    freq.put("Bil", 412);
    freq.put("WE ", 54);
    freq.put("oca", 37);
    freq.put("Big", 38);
    freq.put("Bie", 213);
    freq.put("ür ", 4159);
    freq.put("Bit", 148);
    freq.put("Bir", 48);
    freq.put("Bis", 157);
    freq.put("é ", 50);
    freq.put("ßßß", 108);
    freq.put("ürs", 150);
    freq.put("ürt", 69);
    freq.put("ürz", 119);
    freq.put("ürc", 40);
    freq.put("ürb", 29);
    freq.put("üre", 60);
    freq.put("ürd", 520);
    freq.put("ürg", 101);
    freq.put("ürf", 103);
    freq.put("üri", 50);
    freq.put("ürk", 64);
    freq.put("ürm", 25);
    freq.put("ürl", 155);
    freq.put("üro", 87);
    freq.put("ürn", 78);
    freq.put("Ex ", 60);
    freq.put("Pet", 100);
    freq.put("nut", 426);
    freq.put("nur", 1567);
    freq.put("nus", 67);
    freq.put("Per", 215);
    freq.put("nun", 1062);
    freq.put("Pen", 52);
    freq.put("num", 61);
    freq.put("rüh", 345);
    freq.put("nug", 96);
    freq.put("nud", 30);
    freq.put("nue", 29);
    freq.put("rüc", 652);
    freq.put("rüb", 136);
    freq.put("mut", 151);
    freq.put("Kür", 29);
    freq.put("muc", 37);
    freq.put("Küc", 62);
    freq.put("mul", 46);
    freq.put("Kün", 52);
    freq.put("mun", 350);
    freq.put("Küh", 43);
    freq.put("zbe", 43);
    freq.put("zba", 30);
    freq.put("XD ", 54);
    freq.put("ber", 6550);
    freq.put("Ext", 41);
    freq.put("Exp", 132);
    freq.put("nu ", 43);
    freq.put("ell", 2842);
    freq.put(" me", 3803);
    freq.put(" ma", 5250);
    freq.put("elf", 238);
    freq.put(" mo", 807);
    freq.put(" mh", 27);
    freq.put(" mi", 7816);
    freq.put(" mu", 1072);
    freq.put("xx ", 31);
    freq.put("kwu", 68);
    freq.put(" my", 69);
    freq.put("üse", 30);
    freq.put(" m ", 429);
    freq.put("xxx", 46);
    freq.put("Cra", 34);
    freq.put("Cre", 48);
    freq.put("TV ", 194);
    freq.put("n", 216529);
    freq.put("Tür", 95);
    freq.put("Hä", 168);
    freq.put(" mä", 78);
    freq.put(" mö", 285);
    freq.put(" mü", 329);
    freq.put("kwü", 25);
    freq.put("HP ", 49);
    freq.put("öpf", 51);
    freq.put(" Jä", 55);
    freq.put("vig", 33);
    freq.put("elk", 81);
    freq.put("elh", 79);
    freq.put("eli", 409);
    freq.put("eln", 548);
    freq.put("elo", 98);
    freq.put("Hü", 58);
    freq.put("elm", 147);
    freq.put("elb", 623);
    freq.put("elc", 343);
    freq.put("ela", 404);
    freq.put("Hö", 147);
    freq.put("elg", 58);
    freq.put("eld", 898);
    freq.put("ele", 1646);
    freq.put("elz", 78);
    freq.put("rnu", 33);
    freq.put("elr", 30);
    freq.put("els", 483);
    freq.put("elp", 83);
    freq.put("elw", 30);
    freq.put("elt", 1452);
    freq.put("elu", 64);
    freq.put("D", 16568);
    freq.put("el ", 3504);
    freq.put("hs ", 167);
    freq.put(" Ju", 486);
    freq.put(" Jo", 445);
    freq.put(" Je", 715);
    freq.put(" Ja", 1248);
    freq.put("ick", 1193);
    freq.put("Hy", 58);
    freq.put("ico", 30);
    freq.put("ica", 102);
    freq.put("ice", 203);
    freq.put("Hu", 388);
    freq.put("Hi", 775);
    freq.put("Ho", 1016);
    freq.put("Hm", 90);
    freq.put("ics", 48);
    freq.put("icr", 50);
    freq.put("Ha", 3023);
    freq.put("elö", 47);
    freq.put("He", 1683);
    freq.put("hsc", 87);
    freq.put("hsa", 32);
    freq.put("hse", 305);
    freq.put("hsh", 25);
    freq.put("hsi", 35);
    freq.put("hso", 66);
    freq.put("hst", 863);
    freq.put(" J ", 40);
    freq.put("ic ", 253);
    freq.put("H ", 645);
    freq.put("ppc", 42);
    freq.put("aha", 601);
    freq.put("ppe", 593);
    freq.put("ahe", 109);
    freq.put("ppi", 81);
    freq.put("ahi", 50);
    freq.put("ppo", 45);
    freq.put("aho", 28);
    freq.put("ahl", 603);
    freq.put("ppl", 221);
    freq.put("pps", 138);
    freq.put("ppt", 115);
    freq.put("ppy", 39);
    freq.put("git", 124);
    freq.put("gis", 138);
    freq.put("gir", 30);
    freq.put("nä", 517);
    freq.put("gig", 68);
    freq.put("gie", 520);
    freq.put("nü", 178);
    freq.put("gib", 786);
    freq.put("gio", 93);
    freq.put("gin", 333);
    freq.put("nö", 107);
    freq.put("ah ", 327);
    freq.put("pp ", 399);
    freq.put("Vol", 202);
    freq.put("Vom", 42);
    freq.put("Von", 146);
    freq.put("Vor", 611);
    freq.put("nno", 197);
    freq.put("nnl", 50);
    freq.put("nni", 259);
    freq.put("nnh", 37);
    freq.put("nne", 2072);
    freq.put("nna", 121);
    freq.put("nny", 52);
    freq.put("nnu", 101);
    freq.put("nnt", 1232);
    freq.put("nns", 422);
    freq.put("nh", 801);
    freq.put("ni", 9433);
    freq.put("nj", 110);
    freq.put("nk", 4327);
    freq.put("nl", 1669);
    freq.put("nm", 516);
    freq.put("nn", 10712);
    freq.put("no", 3532);
    freq.put("tit", 147);
    freq.put("na", 5567);
    freq.put("nb", 1165);
    freq.put("nc", 1001);
    freq.put("nd", 24330);
    freq.put("ne", 22182);
    freq.put("nf", 2312);
    freq.put("ng", 13390);
    freq.put("til", 113);
    freq.put("ny", 234);
    freq.put("nz", 2757);
    freq.put("tio", 1651);
    freq.put("ES ", 121);
    freq.put("np", 342);
    freq.put("tie", 762);
    freq.put("nr", 369);
    freq.put("ns", 8639);
    freq.put("nt", 10147);
    freq.put("nu", 3498);
    freq.put("nv", 296);
    freq.put("nw", 449);
    freq.put("wör", 39);
    freq.put("nn ", 5965);
    freq.put("wöh", 46);
    freq.put("ich", 25425);
    freq.put("wöl", 35);
    freq.put("n ", 85157);
    freq.put("ti ", 137);
    freq.put("roh", 167);
    freq.put("roi", 109);
    freq.put("roj", 188);
    freq.put("rok", 44);
    freq.put("rol", 212);
    freq.put("rom", 239);
    freq.put("ron", 240);
    freq.put("roo", 32);
    freq.put("lls", 474);
    freq.put("roa", 28);
    freq.put("rob", 401);
    freq.put("llp", 34);
    freq.put("rod", 189);
    freq.put("Tsc", 36);
    freq.put("rof", 277);
    freq.put("rog", 255);
    freq.put("llk", 76);
    freq.put("roz", 136);
    freq.put("llh", 25);
    freq.put("llo", 490);
    freq.put("elä", 28);
    freq.put("llm", 31);
    freq.put("lll", 28);
    freq.put("rop", 302);
    freq.put("llb", 50);
    freq.put("ror", 94);
    freq.put("ros", 300);
    freq.put("rot", 509);
    freq.put("rou", 75);
    freq.put("rov", 50);
    freq.put("row", 143);
    freq.put("Daf", 28);
    freq.put("Dac", 91);
    freq.put("Dam", 114);
    freq.put("Dan", 783);
    freq.put("Dai", 46);
    freq.put("Dat", 198);
    freq.put("Dau", 71);
    freq.put("Dav", 54);
    freq.put("Dar", 97);
    freq.put("Das", 1385);
    freq.put("lh", 171);
    freq.put("Dax", 27);
    freq.put("Day", 34);
    freq.put("ro ", 688);
    freq.put("tw ", 39);
    freq.put("Cit", 37);
    freq.put("hPa", 27);
    freq.put("ll ", 2991);
    freq.put("Da ", 280);
    freq.put("Rez", 77);
    freq.put("Res", 142);
    freq.put("Rep", 60);
    freq.put("Rev", 67);
    freq.put("Ret", 119);
    freq.put("kli", 651);
    freq.put("Rek", 32);
    freq.put("Rei", 298);
    freq.put("Ren", 118);
    freq.put("Rel", 39);
    freq.put("Rem", 32);
    freq.put("Reb", 47);
    freq.put("Rec", 228);
    freq.put("Rea", 132);
    freq.put("Ref", 58);
    freq.put("Reg", 376);
    freq.put("Red", 86);
    freq.put("Qua", 159);
    freq.put("Que", 52);
    freq.put(" üb", 1608);
    freq.put("roß", 387);
    freq.put("Qui", 29);
    freq.put("Age", 41);
    freq.put("SC ", 36);
    freq.put("Re ", 69);
    freq.put("ngt", 439);
    freq.put("msu", 61);
    freq.put("mst", 417);
    freq.put("msp", 41);
    freq.put("mso", 28);
    freq.put("ngw", 92);
    freq.put("ult", 239);
    freq.put("mse", 50);
    freq.put("msc", 55);
    freq.put("msa", 35);
    freq.put("Eve", 46);
    freq.put("ms ", 188);
    freq.put(" on", 287);
    freq.put(" ol", 26);
    freq.put(" om", 35);
    freq.put(" ok", 199);
    freq.put(" oh", 545);
    freq.put("Min", 435);
    freq.put(" of", 393);
    freq.put("Mic", 130);
    freq.put(" ob", 367);
    freq.put("Mix", 30);
    freq.put(" ot", 59);
    freq.put("Mir", 110);
    freq.put(" or", 124);
    freq.put("Mit", 760);
    freq.put(" op", 69);
    freq.put(" oO", 48);
    freq.put("ky ", 56);
    freq.put(" o ", 269);
    freq.put("Zit", 51);
    freq.put("Zie", 94);
    freq.put("Zin", 28);
    freq.put("Zim", 91);
    freq.put("gte", 170);
    freq.put("HR ", 51);
    freq.put("ahn", 543);
    freq.put("ahm", 207);
    freq.put("gt ", 1878);
    freq.put("vt ", 42);
    freq.put("EN ", 325);
    freq.put("eß ", 40);
    freq.put("eßt", 71);
    freq.put("eße", 115);
    freq.put("eßl", 31);
    freq.put("prä", 187);
    freq.put("hu ", 47);
    freq.put("prü", 100);
    freq.put("iam", 26);
    freq.put("IM ", 28);
    freq.put("ian", 191);
    freq.put("€ ", 280);
    freq.put("iab", 28);
    freq.put("iat", 88);
    freq.put("ias", 52);
    freq.put("PD ", 139);
    freq.put("ebo", 699);
    freq.put("hub", 28);
    freq.put("hul", 528);
    freq.put("hum", 75);
    freq.put("hun", 396);
    freq.put("huh", 121);
    freq.put("hut", 201);
    freq.put("hur", 43);
    freq.put("hus", 86);
    freq.put(" Lä", 98);
    freq.put("ia ", 573);
    freq.put(" Lö", 101);
    freq.put("r", 156915);
    freq.put(" Lü", 121);
    freq.put("pre", 427);
    freq.put("ane", 249);
    freq.put("anf", 144);
    freq.put("ang", 2217);
    freq.put("pra", 208);
    freq.put("ana", 510);
    freq.put("anb", 54);
    freq.put("anc", 415);
    freq.put("anl", 122);
    freq.put("anm", 48);
    freq.put("pro", 553);
    freq.put("ano", 86);
    freq.put("pri", 299);
    freq.put("ani", 435);
    freq.put("ank", 1703);
    freq.put("pru", 92);
    freq.put("anu", 90);
    freq.put("anw", 50);
    freq.put("anp", 36);
    freq.put("anr", 42);
    freq.put("ans", 746);
    freq.put("any", 46);
    freq.put("anz", 1417);
    freq.put(" L ", 46);
    freq.put("gke", 237);
    freq.put("Löw", 31);
    freq.put("an ", 4296);
    freq.put("Lös", 55);
    freq.put("fch", 26);
    freq.put(" Le", 1563);
    freq.put(" La", 1086);
    freq.put(" Lo", 418);
    freq.put(" Li", 1354);
    freq.put(" Lu", 356);
    freq.put("rmö", 32);
    freq.put("tka", 54);
    freq.put("tko", 31);
    freq.put("itl", 82);
    freq.put("nla", 347);
    freq.put("nle", 118);
    freq.put("nli", 843);
    freq.put("dy ", 220);
    freq.put("ss ", 2943);
    freq.put("nlo", 309);
    freq.put("iti", 775);
    freq.put("ssy", 38);
    freq.put("ssu", 129);
    freq.put("H", 8300);
    freq.put("eun", 450);
    freq.put("ssp", 100);
    freq.put("sss", 71);
    freq.put("dys", 26);
    freq.put("ssl", 111);
    freq.put("sso", 101);
    freq.put("ssi", 842);
    freq.put("sse", 3851);
    freq.put("ssa", 338);
    freq.put("ssc", 384);
    freq.put("ssb", 101);
    freq.put("rms", 61);
    freq.put("rmu", 119);
    freq.put("rma", 564);
    freq.put("nlä", 26);
    freq.put("rme", 429);
    freq.put("lne", 128);
    freq.put("rmi", 378);
    freq.put("rmo", 82);
    freq.put("mti", 41);
    freq.put("för", 26);
    freq.put("rm ", 355);
    freq.put("ln ", 621);
    freq.put("Ihr", 476);
    freq.put("Ihn", 70);
    freq.put("pot", 119);
    freq.put("por", 451);
    freq.put("pos", 218);
    freq.put("pop", 25);
    freq.put("pon", 146);
    freq.put("pol", 188);
    freq.put("pom", 35);
    freq.put("Bur", 62);
    freq.put("Bus", 149);
    freq.put("But", 68);
    freq.put("Bun", 389);
    freq.put("Bul", 34);
    freq.put("Buc", 144);
    freq.put("Bud", 28);
    freq.put("po ", 41);
    freq.put("Bat", 56);
    freq.put("Bau", 253);
    freq.put("Bar", 157);
    freq.put("yl", 135);
    freq.put("I ", 403);
    freq.put("uhi", 67);
    freq.put("tiz", 32);
    freq.put("Is", 361);
    freq.put("Ir", 163);
    freq.put("It", 86);
    freq.put("Ih", 557);
    freq.put("Im", 413);
    freq.put("Il", 31);
    freq.put("In", 1937);
    freq.put("Bab", 91);
    freq.put("Ic", 2839);
    freq.put("Id", 169);
    freq.put(" qu", 90);
    freq.put("tip", 123);
    freq.put("oki", 53);
    freq.put("tir", 60);
    freq.put("rpu", 44);
    freq.put("tis", 746);
    freq.put("tim", 739);
    freq.put("tin", 596);
    freq.put("Bah", 188);
    freq.put("tik", 664);
    freq.put("oß", 482);
    freq.put("tif", 100);
    freq.put("tig", 1782);
    freq.put("Pil", 41);
    freq.put("Pin", 57);
    freq.put("Pie", 28);
    freq.put("tia", 84);
    freq.put("Piz", 37);
    freq.put("Pir", 134);
    freq.put("Pis", 27);
    freq.put("HT ", 80);
    freq.put("Kus", 26);
    freq.put("Kur", 193);
    freq.put("Kun", 253);
    freq.put("Kul", 68);
    freq.put("Gün", 43);
    freq.put("Kuc", 33);
    freq.put("ötc", 33);
    freq.put("öte", 53);
    freq.put("öti", 42);
    freq.put("o ", 8253);
    freq.put("ött", 30);
    freq.put("ötz", 55);
    freq.put("oO", 51);
    freq.put("uTu", 55);
    freq.put("oS", 26);
    freq.put("oo", 2122);
    freq.put("on", 13111);
    freq.put("om", 4727);
    freq.put("ol", 6382);
    freq.put("ok", 1220);
    freq.put("oj", 211);
    freq.put("oi", 328);
    freq.put("oh", 2233);
    freq.put("og", 1743);
    freq.put("of", 1949);
    freq.put("oe", 306);
    freq.put("od", 2285);
    freq.put("oc", 5691);
    freq.put("ob", 1935);
    freq.put("oa", 412);
    freq.put("häf", 182);
    freq.put("häd", 46);
    freq.put("oz", 351);
    freq.put("oy", 123);
    freq.put("ox", 201);
    freq.put("ow", 1270);
    freq.put("ov", 575);
    freq.put("ou", 1182);
    freq.put("häl", 166);
    freq.put("os", 3201);
    freq.put("or", 9049);
    freq.put("op", 1635);
    freq.put("LE ", 54);
    freq.put("FB ", 71);
    freq.put("eht", 1742);
    freq.put("ehu", 78);
    freq.put("ehr", 2237);
    freq.put("ehs", 106);
    freq.put("EL ", 94);
    freq.put("ehe", 2228);
    freq.put("RD ", 57);
    freq.put("eha", 256);
    freq.put("ehn", 180);
    freq.put("eho", 88);
    freq.put("ehl", 512);
    freq.put("ehm", 542);
    freq.put("ehi", 74);
    freq.put("nüb", 44);
    freq.put("nüg", 32);
    freq.put("hwä", 73);
    freq.put("jun", 124);
    freq.put("eh ", 542);
    freq.put("rve", 236);
    freq.put("rvi", 268);
    freq.put("rvo", 46);
    freq.put("rvt", 42);
    freq.put("ehö", 186);
    freq.put("igu", 255);
    freq.put("igt", 478);
    freq.put("igs", 214);
    freq.put("igr", 37);
    freq.put("ige", 3006);
    freq.put("iga", 223);
    freq.put("ign", 248);
    freq.put("igk", 236);
    freq.put("igi", 207);
    freq.put("igh", 231);
    freq.put("hwi", 177);
    freq.put("hwe", 599);
    freq.put("hwa", 358);
    freq.put("ftr", 108);
    freq.put("SG ", 29);
    freq.put("Hor", 58);
    freq.put("hwu", 96);
    freq.put("Män", 115);
    freq.put("Mäd", 111);
    freq.put("ig ", 2134);
    freq.put("Mär", 46);
    freq.put("pto", 58);
    freq.put("alo", 104);
    freq.put("all", 3393);
    freq.put("alm", 55);
    freq.put("alk", 212);
    freq.put("pti", 189);
    freq.put("llz", 37);
    freq.put("alf", 39);
    freq.put("pte", 246);
    freq.put("ale", 808);
    freq.put("alb", 342);
    freq.put("lly", 49);
    freq.put("ala", 213);
    freq.put("alz", 75);
    freq.put("aly", 96);
    freq.put("fa ", 46);
    freq.put("alu", 25);
    freq.put("pts", 62);
    freq.put("als", 1923);
    freq.put("alp", 31);
    freq.put(" N ", 61);
    freq.put("roc", 201);
    freq.put("far", 109);
    freq.put("fas", 340);
    freq.put("fav", 28);
    freq.put("al ", 4062);
    freq.put("fau", 34);
    freq.put("fak", 33);
    freq.put("fah", 569);
    freq.put("fai", 26);
    freq.put("fan", 434);
    freq.put("llu", 236);
    freq.put("fal", 701);
    freq.put("fam", 32);
    freq.put("fac", 797);
    freq.put("llt", 1264);
    freq.put("uwe", 27);
    freq.put(" Ni", 606);
    freq.put("Anb", 37);
    freq.put(" No", 755);
    freq.put(" Na", 1647);
    freq.put(" Ne", 1810);
    freq.put("lli", 700);
    freq.put(" Nr", 39);
    freq.put(" Nu", 437);
    freq.put("lln", 67);
    freq.put("teh", 775);
    freq.put("tei", 1061);
    freq.put("tek", 43);
    freq.put("tel", 2153);
    freq.put("tem", 489);
    freq.put("ten", 7733);
    freq.put("nbr", 89);
    freq.put("teb", 40);
    freq.put("tec", 310);
    freq.put("ted", 75);
    freq.put("tee", 44);
    freq.put("nbu", 164);
    freq.put("teg", 134);
    freq.put("tex", 55);
    freq.put("nbi", 82);
    freq.put("nbo", 69);
    freq.put("nbl", 59);
    freq.put("tep", 41);
    freq.put("LZ ", 42);
    freq.put("nba", 238);
    freq.put("tes", 1008);
    freq.put("tet", 1092);
    freq.put("lla", 271);
    freq.put("nbe", 435);
    freq.put("sue", 52);
    freq.put("suc", 907);
    freq.put("sun", 499);
    freq.put("sum", 74);
    freq.put("sul", 35);
    freq.put("sus", 36);
    freq.put("lle", 4961);
    freq.put("sup", 177);
    freq.put("te ", 9518);
    freq.put(" Nä", 89);
    freq.put(" Nü", 65);
    freq.put("Und", 765);
    freq.put(" Nö", 28);
    freq.put("rkt", 383);
    freq.put("rku", 130);
    freq.put("rkr", 53);
    freq.put("rks", 165);
    freq.put("Tor", 115);
    freq.put("Top", 125);
    freq.put("Ung", 53);
    freq.put("Tot", 74);
    freq.put("Tou", 118);
    freq.put("rke", 856);
    freq.put("Ton", 41);
    freq.put("rka", 326);
    freq.put("Tol", 66);
    freq.put("Tom", 38);
    freq.put("rkl", 464);
    freq.put("Toc", 25);
    freq.put("rkn", 28);
    freq.put("rko", 79);
    freq.put("rki", 64);
    freq.put("Tod", 79);
    freq.put("In ", 429);
    freq.put("äää", 45);
    freq.put("Glü", 222);
    freq.put("Int", 615);
    freq.put("Inv", 38);
    freq.put("Ins", 148);
    freq.put("Inn", 121);
    freq.put("Inh", 27);
    freq.put("v", 15518);
    freq.put("Ind", 146);
    freq.put("Inf", 254);
    freq.put("Ing", 60);
    freq.put("rkä", 49);
    freq.put("För", 25);
    freq.put("Glo", 47);
    freq.put("Gla", 123);
    freq.put("Gle", 105);
    freq.put("Akt", 225);
    freq.put("Akk", 37);
    freq.put("lhe", 57);
    freq.put("lha", 67);
    freq.put("lho", 26);
    freq.put("oy ", 39);
    freq.put(" sü", 168);
    freq.put("Er ", 141);
    freq.put(" sä", 26);
    freq.put("Erw", 66);
    freq.put("Ers", 267);
    freq.put("L", 5709);
    freq.put("Erz", 45);
    freq.put("Erd", 84);
    freq.put("Erf", 223);
    freq.put("Erg", 75);
    freq.put("Erl", 66);
    freq.put("Ern", 71);
    freq.put("Ero", 28);
    freq.put("Eri", 68);
    freq.put("Erk", 55);
    freq.put("Rad", 161);
    freq.put("Rab", 34);
    freq.put("Ran", 78);
    freq.put("Rah", 30);
    freq.put("Rai", 29);
    freq.put("Rat", 131);
    freq.put("Rau", 142);
    freq.put("Ras", 35);
    freq.put("Rap", 29);
    freq.put("Mut", 109);
    freq.put(" sy", 41);
    freq.put("Mus", 453);
    freq.put(" sp", 1056);
    freq.put(" st", 2155);
    freq.put(" su", 604);
    freq.put(" sk", 45);
    freq.put(" sh", 82);
    freq.put(" si", 4828);
    freq.put(" so", 4524);
    freq.put(" sm", 44);
    freq.put("Mul", 55);
    freq.put("Mun", 32);
    freq.put(" se", 3139);
    freq.put("ize", 312);
    freq.put("gur", 48);
    freq.put("izi", 286);
    freq.put("izu", 36);
    freq.put("izz", 49);
    freq.put("koh", 64);
    freq.put("kom", 1875);
    freq.put(" s ", 745);
    freq.put("kol", 100);
    freq.put("iz ", 68);
    freq.put("kon", 404);
    freq.put("X ", 215);
    freq.put("▸ ", 95);
    freq.put("efü", 203);
    freq.put("TL ", 108);
    freq.put("efä", 221);
    freq.put("kop", 91);
    freq.put(" ev", 57);
    freq.put("kor", 135);
    freq.put("jen", 36);
    freq.put("Nut", 89);
    freq.put("Nur", 188);
    freq.put("Nun", 48);
    freq.put("Num", 42);
    freq.put("LG ", 34);
    freq.put("efr", 143);
    freq.put("eft", 72);
    freq.put("efu", 164);
    freq.put("efi", 141);
    freq.put("efl", 53);
    freq.put("efo", 206);
    freq.put("efa", 330);
    freq.put("efe", 368);
    freq.put("eff", 254);
    freq.put("Zeh", 25);
    freq.put("Zei", 605);
    freq.put("Zen", 52);
    freq.put("Zel", 35);
    freq.put("Zer", 36);
    freq.put("Zeu", 49);
    freq.put("ef ", 213);
    freq.put("rte", 2263);
    freq.put("rtg", 32);
    freq.put("rta", 294);
    freq.put("rtb", 31);
    freq.put("rtm", 94);
    freq.put("rtl", 96);
    freq.put("rto", 77);
    freq.put("rtn", 130);
    freq.put("rti", 660);
    freq.put("rth", 93);
    freq.put("rtk", 26);
    freq.put("hi ", 145);
    freq.put("rtt", 51);
    freq.put("rtw", 27);
    freq.put("rtp", 80);
    freq.put("rts", 464);
    freq.put("rtr", 425);
    freq.put("rty", 107);
    freq.put("rtz", 43);
    freq.put("Ju", 489);
    freq.put("ies", 1816);
    freq.put("ier", 4523);
    freq.put("ieu", 71);
    freq.put("IA ", 31);
    freq.put("iew", 172);
    freq.put("iev", 41);
    freq.put("ieh", 740);
    freq.put("iek", 32);
    freq.put("Jo", 447);
    freq.put("iem", 220);
    freq.put("iel", 2848);
    freq.put("ien", 1534);
    freq.put("Je", 715);
    freq.put("iec", 201);
    freq.put("ieb", 1651);
    freq.put("iee", 28);
    freq.put("Ja", 1253);
    freq.put("ieg", 887);
    freq.put("ief", 321);
    freq.put("hip", 47);
    freq.put("hir", 189);
    freq.put("his", 183);
    freq.put("hit", 78);
    freq.put("rt ", 3908);
    freq.put("hia", 41);
    freq.put("hic", 341);
    freq.put("hie", 1118);
    freq.put("hif", 52);
    freq.put("hig", 160);
    freq.put("hih", 74);
    freq.put("hil", 324);
    freq.put("him", 103);
    freq.put("hin", 965);
    freq.put("hio", 26);
    freq.put("ie ", 13891);
    freq.put("J ", 90);
    freq.put("arp", 39);
    freq.put("arr", 231);
    freq.put("ars", 311);
    freq.put("art", 2165);
    freq.put("aru", 437);
    freq.put("ieß", 256);
    freq.put("arz", 252);
    freq.put("ara", 441);
    freq.put("arb", 744);
    freq.put("arc", 134);
    freq.put("ard", 419);
    freq.put("are", 830);
    freq.put("arf", 323);
    freq.put("aß ", 223);
    freq.put("ari", 458);
    freq.put("ark", 809);
    freq.put("arl", 221);
    freq.put("uu ", 35);
    freq.put("arn", 230);
    freq.put("aro", 66);
    freq.put(" P ", 137);
    freq.put("Jä", 55);
    freq.put("uuu", 159);
    freq.put("ar ", 2652);
    freq.put("aße", 158);
    freq.put("uun", 48);
    freq.put("fge", 245);
    freq.put("fga", 98);
    freq.put(" Ps", 47);
    freq.put(" Pr", 1817);
    freq.put("c", 83626);
    freq.put("Öst", 41);
    freq.put(" Pu", 321);
    freq.put(" Pa", 1220);
    freq.put(" Pf", 288);
    freq.put(" Pe", 463);
    freq.put("Fas", 84);
    freq.put(" Pi", 411);
    freq.put(" Ph", 165);
    freq.put(" Po", 973);
    freq.put(" Pl", 541);
    freq.put("Fav", 39);
    freq.put("tga", 135);
    freq.put("tge", 245);
    freq.put("tgl", 80);
    freq.put("pr", 1884);
    freq.put("ps", 480);
    freq.put("pp", 1784);
    freq.put("duk", 138);
    freq.put("dul", 31);
    freq.put("dum", 116);
    freq.put("wün", 230);
    freq.put("pu", 563);
    freq.put("pz", 100);
    freq.put("py", 64);
    freq.put("swe", 306);
    freq.put("due", 42);
    freq.put("pc", 74);
    freq.put("duz", 63);
    freq.put("pa", 2516);
    freq.put("pf", 1289);
    freq.put("pd", 164);
    freq.put("pe", 2820);
    freq.put("Fan", 238);
    freq.put("wür", 516);
    freq.put("pi", 2072);
    freq.put("po", 1326);
    freq.put("pl", 1157);
    freq.put("pm", 38);
    freq.put("Emp", 92);
    freq.put("Fac", 454);
    freq.put("du ", 2047);
    freq.put("p ", 1546);
    freq.put("riv", 124);
    freq.put("rit", 620);
    freq.put("riu", 72);
    freq.put("Tip", 167);
    freq.put("ris", 824);
    freq.put("rip", 68);
    freq.put("Tis", 55);
    freq.put("rin", 1364);
    freq.put("rio", 102);
    freq.put("ril", 137);
    freq.put("rim", 127);
    freq.put("rik", 197);
    freq.put("rif", 284);
    freq.put("rig", 594);
    freq.put("rid", 66);
    freq.put("rie", 1833);
    freq.put("rib", 40);
    freq.put("ric", 1190);
    freq.put("ria", 217);
    freq.put("pü", 59);
    freq.put("pä", 301);
    freq.put("Cor", 34);
    freq.put("Cou", 77);
    freq.put("Coa", 27);
    freq.put("Cod", 35);
    freq.put("Com", 210);
    freq.put("eku", 76);
    freq.put("ri ", 88);
    freq.put("Con", 167);
    freq.put("WM ", 48);
    freq.put("Air", 65);
    freq.put("ahh", 43);
    freq.put("fba", 62);
    freq.put("bös", 36);
    freq.put("bör", 38);
    freq.put("zz ", 27);
    freq.put("zza", 33);
    freq.put("Roh", 31);
    freq.put("Rol", 119);
    freq.put("Rom", 62);
    freq.put("Rob", 67);
    freq.put("Roc", 65);
    freq.put("yle", 44);
    freq.put("Ros", 96);
    freq.put("Rot", 96);
    freq.put("Rou", 32);
    freq.put("yli", 27);
    freq.put("wn ", 50);
    freq.put(" uu", 28);
    freq.put(" up", 59);
    freq.put(" ur", 51);
    freq.put(" us", 41);
    freq.put(" um", 1138);
    freq.put(" un", 9740);
    freq.put(" uh", 68);
    freq.put("ahr", 1732);
    freq.put("grö", 139);
    freq.put("xpo", 33);
    freq.put("xpl", 30);
    freq.put("grü", 173);
    freq.put("xpe", 96);
    freq.put("ixe", 29);
    freq.put("etc", 38);
    freq.put("wnl", 54);
    freq.put(" u ", 172);
    freq.put("räu", 214);
    freq.put("rät", 127);
    freq.put("räs", 151);
    freq.put("ix ", 265);
    freq.put("räg", 178);
    freq.put("räf", 68);
    freq.put("räc", 79);
    freq.put("ßig", 85);
    freq.put("z", 22370);
    freq.put("läc", 65);
    freq.put("läg", 90);
    freq.put("läf", 34);
    freq.put("läd", 47);
    freq.put("län", 235);
    freq.put("läs", 224);
    freq.put("lär", 169);
    freq.put("HH ", 32);
    freq.put("läu", 250);
    freq.put("lät", 67);
    freq.put("tph", 64);
    freq.put("gru", 187);
    freq.put("öhl", 33);
    freq.put("kp", 61);
    freq.put("gra", 771);
    freq.put("gro", 328);
    freq.put("gri", 221);
    freq.put("eda", 291);
    freq.put("Tho", 43);
    freq.put("edd", 56);
    freq.put("ede", 2809);
    freq.put("edi", 716);
    freq.put("edo", 50);
    freq.put("edl", 54);
    freq.put("edr", 146);
    freq.put("eds", 40);
    freq.put("rrü", 57);
    freq.put("edu", 73);
    freq.put("edy", 27);
    freq.put("FF ", 26);
    freq.put("uga", 44);
    freq.put("ed ", 479);
    freq.put("P", 7811);
    freq.put("uge", 523);
    freq.put("cas", 51);
    freq.put("car", 58);
    freq.put("rro", 112);
    freq.put("rri", 202);
    freq.put("rre", 542);
    freq.put("rra", 296);
    freq.put("ugs", 88);
    freq.put("rry", 156);
    freq.put("rru", 49);
    freq.put("rrt", 79);
    freq.put("rrs", 43);
    freq.put("rrr", 131);
    freq.put("IG ", 28);
    freq.put("Thi", 25);
    freq.put("hkr", 38);
    freq.put(" €", 336);
    freq.put("rr ", 133);
    freq.put("usn", 31);
    freq.put("hko", 29);
    freq.put("hke", 145);
    freq.put("aps", 119);
    freq.put("app", 355);
    freq.put("Mik", 26);
    freq.put("apt", 75);
    freq.put("apu", 87);
    freq.put("aph", 34);
    freq.put("api", 155);
    freq.put("NT ", 28);
    freq.put("apa", 121);
    freq.put("Mil", 201);
    freq.put("usg", 366);
    freq.put("usf", 97);
    freq.put("use", 685);
    freq.put("fee", 179);
    freq.put("usc", 478);
    freq.put("usb", 126);
    freq.put("usa", 328);
    freq.put("fen", 2288);
    freq.put("Lüb", 26);
    freq.put("fel", 493);
    freq.put("usl", 93);
    freq.put("usk", 80);
    freq.put("Lüf", 37);
    freq.put("feh", 348);
    freq.put("fei", 188);
    freq.put("usw", 126);
    freq.put("usv", 33);
    freq.put("fet", 59);
    freq.put("feu", 59);
    freq.put("fer", 931);
    freq.put("fes", 317);
    freq.put("Hur", 43);
    freq.put("usp", 93);
    freq.put(" od", 1178);
    freq.put("Mie", 61);
    freq.put("Gui", 29);
    freq.put("Gut", 645);
    freq.put("ap ", 77);
    freq.put(" Ru", 305);
    freq.put("fe ", 701);
    freq.put("us ", 2689);
    freq.put(" Re", 2030);
    freq.put(" Ra", 797);
    freq.put(" Ro", 652);
    freq.put(" Ri", 364);
    freq.put(" Rh", 88);
    freq.put("tat", 602);
    freq.put("tau", 314);
    freq.put("tap", 45);
    freq.put("tar", 947);
    freq.put("tas", 161);
    freq.put("tad", 391);
    freq.put("taf", 67);
    freq.put("tag", 1493);
    freq.put("taa", 161);
    freq.put("tab", 113);
    freq.put("tac", 76);
    freq.put("tal", 898);
    freq.put("tam", 87);
    freq.put("tan", 812);
    freq.put("tah", 38);
    freq.put("Mis", 119);
    freq.put("tak", 123);
    freq.put("sis", 235);
    freq.put(" ou", 42);
    freq.put("siv", 148);
    freq.put("sit", 394);
    freq.put("äub", 36);
    freq.put("äud", 34);
    freq.put("äuf", 306);
    freq.put("sic", 2328);
    freq.put("sia", 53);
    freq.put("dwa", 174);
    freq.put("sig", 320);
    freq.put("sie", 1925);
    freq.put("dwe", 109);
    freq.put("sik", 316);
    freq.put("dwi", 255);
    freq.put("sio", 404);
    freq.put("sin", 1792);
    freq.put("sim", 49);
    freq.put("sil", 54);
    freq.put("ta ", 212);
    freq.put(" Rö", 55);
    freq.put(" Rü", 154);
    freq.put(" Rä", 39);
    freq.put("si ", 111);
    freq.put("kba", 27);
    freq.put("öc", 293);
    freq.put("öd", 137);
    freq.put("nf ", 58);
    freq.put("bys", 46);
    freq.put("öh", 300);
    freq.put("cto", 46);
    freq.put("gh ", 55);
    freq.put("bye", 63);
    freq.put("Cas", 71);
    freq.put("Car", 109);
    freq.put("Cap", 34);
    freq.put("Cat", 27);
    freq.put("Can", 52);
    freq.put("Cam", 76);
    freq.put("Cal", 47);
    freq.put("Caf", 29);
    freq.put("Pre", 438);
    freq.put("nfe", 117);
    freq.put("Pra", 103);
    freq.put("nfa", 1115);
    freq.put("nfo", 370);
    freq.put("Pro", 1017);
    freq.put("nfl", 71);
    freq.put("Pri", 174);
    freq.put("nfi", 49);
    freq.put("nfu", 62);
    freq.put("nft", 207);
    freq.put("nfr", 129);
    freq.put("by ", 152);
    freq.put(" Än", 25);
    freq.put("oun", 200);
    freq.put("oul", 39);
    freq.put("ouc", 94);
    freq.put("oud", 42);
    freq.put("ous", 98);
    freq.put("our", 267);
    freq.put("oup", 54);
    freq.put(" Är", 53);
    freq.put("out", 158);
    freq.put("lt ", 2511);
    freq.put("ouT", 55);
    freq.put("ou ", 99);
    freq.put("üde", 119);
    freq.put("lts", 120);
    freq.put("ltr", 84);
    freq.put("nfä", 69);
    freq.put("ltw", 51);
    freq.put("ltu", 263);
    freq.put("ltb", 49);
    freq.put("lta", 128);
    freq.put("lte", 2073);
    freq.put("lti", 186);
    freq.put("nfü", 52);
    freq.put("lto", 29);
    freq.put("ü", 14452);
    freq.put("ltm", 33);
    freq.put("ltl", 28);
    freq.put("K ", 286);
    freq.put("Umw", 46);
    freq.put("Ums", 63);
    freq.put("Ka", 1692);
    freq.put("Ke", 590);
    freq.put("Ki", 856);
    freq.put("Ko", 1513);
    freq.put("Kn", 133);
    freq.put("Kl", 721);
    freq.put("Kr", 759);
    freq.put("Ku", 641);
    freq.put("vie", 1412);
    freq.put("lea", 56);
    freq.put("Umg", 45);
    freq.put("üfu", 34);
    freq.put("hp", 65);
    freq.put("Kä", 94);
    freq.put("hw", 1362);
    freq.put("Kö", 344);
    freq.put("Kü", 210);
    freq.put("Pow", 40);
    freq.put("Pot", 67);
    freq.put("Por", 137);
    freq.put("Pos", 146);
    freq.put("Pop", 28);
    freq.put("Pol", 382);
    freq.put("Pok", 38);
    freq.put("Pod", 84);
    freq.put("ebä", 38);
    freq.put("Cha", 268);
    freq.put("ebü", 40);
    freq.put("ha", 11813);
    freq.put(" w ", 358);
    freq.put("hf", 104);
    freq.put("hg", 174);
    freq.put("hnä", 33);
    freq.put(" we", 5503);
    freq.put("qu", 320);
    freq.put(" wa", 3610);
    freq.put(" wo", 1415);
    freq.put(" wh", 32);
    freq.put(" wi", 6806);
    freq.put(" ww", 141);
    freq.put(" wu", 627);
    freq.put("Am ", 221);
    freq.put("ebe", 2796);
    freq.put("eba", 193);
    freq.put("ebc", 30);
    freq.put("ebl", 191);
    freq.put("ebn", 118);
    freq.put("RN ", 36);
    freq.put("ebi", 114);
    freq.put("ebt", 208);
    freq.put("ebu", 279);
    freq.put("ebr", 224);
    freq.put("ebs", 273);
    freq.put("Tex", 47);
    freq.put("Neu", 850);
    freq.put("dle", 116);
    freq.put("dli", 536);
    freq.put("Jac", 49);
    freq.put("dlu", 46);
    freq.put("nöt", 42);
    freq.put("eb ", 255);
    freq.put("job", 45);
    freq.put(" wä", 533);
    freq.put("dl ", 37);
    freq.put("Zah", 96);
    freq.put(" wü", 680);
    freq.put("rpr", 123);
    freq.put("CD ", 47);
    freq.put("rpa", 127);
    freq.put("rpe", 99);
    freq.put("rpf", 27);
    freq.put("hm ", 290);
    freq.put("rpl", 39);
    freq.put("rpo", 93);
    freq.put("Jug", 99);
    freq.put("bbi", 58);
    freq.put("bbe", 104);
    freq.put("Jun", 168);
    freq.put("Jul", 57);
    freq.put("Jus", 65);
    freq.put("bby", 41);
    freq.put("IE ", 106);
    freq.put("Mom", 79);
    freq.put("hmt", 28);
    freq.put("hmu", 81);
    freq.put("hmm", 72);
    freq.put("hmi", 187);
    freq.put("hme", 877);
    freq.put("hma", 395);
    freq.put(" Tü", 118);
    freq.put("é", 79);
    freq.put(" Tö", 29);
    freq.put(" Tä", 48);
    freq.put("tja", 34);
    freq.put("AR ", 38);
    freq.put("avo", 213);
    freq.put("pzi", 91);
    freq.put("avi", 113);
    freq.put("ave", 97);
    freq.put("ava", 56);
    freq.put(" T ", 130);
    freq.put(" ▸", 97);
    freq.put(" Ty", 72);
    freq.put(" Tw", 630);
    freq.put(" Tu", 185);
    freq.put(" Ts", 45);
    freq.put(" Tr", 1024);
    freq.put(" To", 808);
    freq.put(" Tj", 32);
    freq.put(" Ti", 756);
    freq.put(" Th", 574);
    freq.put(" Te", 1153);
    freq.put(" Ta", 1358);
    freq.put("mfa", 30);
    freq.put("mfo", 32);
    freq.put("mfr", 46);
    freq.put("tch", 206);
    freq.put("sku", 160);
    freq.put("now", 36);
    freq.put("skr", 106);
    freq.put("Far", 122);
    freq.put("lmä", 29);
    freq.put("sky", 36);
    freq.put("ske", 85);
    freq.put("Fak", 29);
    freq.put("Fah", 230);
    freq.put("ska", 146);
    freq.put("nor", 162);
    freq.put("Fal", 165);
    freq.put("Fam", 110);
    freq.put("skl", 43);
    freq.put("sko", 83);
    freq.put("ski", 88);
    freq.put("Eis", 96);
    freq.put("Mod", 165);
    freq.put("T", 7782);
    freq.put("Eig", 83);
    freq.put("tc ", 29);
    freq.put("Ein", 1461);
    freq.put("sk ", 25);
    freq.put("Suc", 152);
    freq.put("Sun", 30);
    freq.put("Sui", 29);
    freq.put("Sur", 28);
    freq.put("Sup", 196);
    freq.put("nd ", 13102);
    freq.put("ndi", 669);
    freq.put("ndh", 122);
    freq.put("ndk", 75);
    freq.put("ndm", 25);
    freq.put("ndl", 598);
    freq.put("ndo", 253);
    freq.put("ndn", 58);
    freq.put("nda", 277);
    freq.put("ndc", 25);
    freq.put("ndb", 89);
    freq.put("nde", 6782);
    freq.put("ndg", 83);
    freq.put("ndf", 36);
    freq.put("ndy", 163);
    freq.put("nds", 492);
    freq.put("ndr", 321);
    freq.put("ndu", 309);
    freq.put("ndt", 92);
    freq.put("ndw", 472);
    freq.put("öb", 83);
    freq.put("own", 115);
    freq.put("owi", 100);
    freq.put("öf", 366);
    freq.put("ög", 253);
    freq.put("owe", 286);
    freq.put("owa", 159);
    freq.put("eo", 746);
    freq.put("ön", 1823);
    freq.put("öp", 69);
    freq.put("ör", 1064);
    freq.put("ös", 450);
    freq.put("öt", 219);
    freq.put("öw", 35);
    freq.put("ama", 257);
    freq.put("ows", 219);
    freq.put("van", 59);
    freq.put("val", 96);
    freq.put("öch", 274);
    freq.put("Ame", 53);
    freq.put("ee", 2353);
    freq.put("var", 32);
    freq.put("Amt", 32);
    freq.put("vat", 206);
    freq.put("ö ", 97);
    freq.put("üft", 76);
    freq.put("ow ", 306);
    freq.put("Tei", 196);
    freq.put("Tel", 179);
    freq.put("Tem", 81);
    freq.put("Ten", 36);
    freq.put("Tea", 112);
    freq.put("va ", 53);
    freq.put("Tec", 122);
    freq.put("Tee", 69);
    freq.put("lve", 133);
    freq.put("Ter", 128);
    freq.put("Tes", 115);
    freq.put("lvi", 27);
    freq.put("Teu", 40);
    freq.put("bca", 28);
    freq.put("eu", 7941);
    freq.put("öö", 86);
    freq.put("zve", 25);
    freq.put("süß", 129);
    freq.put("öß", 188);
    freq.put("my ", 95);
  }
  
}

