package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class EN {
  private static final String name = "en";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public EN() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2179270;
    n_words[1] = 2708449;
    n_words[2] = 2118130;

    freq.put("xtr", 95);
    freq.put("xte", 54);
    freq.put("xti", 32);
    freq.put("xt ", 557);
    freq.put("NO ", 94);
    freq.put(" y ", 94);
    freq.put("rlf", 39);
    freq.put(" yh", 25);
    freq.put(" yo", 12185);
    freq.put(" ya", 283);
    freq.put("k", 28080);
    freq.put(" ye", 1806);
    freq.put(" yr", 55);
    freq.put(" yu", 87);
    freq.put("ED ", 204);
    freq.put("RL ", 29);
    freq.put("aul", 113);
    freq.put("dne", 103);
    freq.put(" £ ", 171);
    freq.put("dni", 95);
    freq.put("dnt", 126);
    freq.put("lmf", 36);
    freq.put("dn ", 521);
    freq.put("Le", 718);
    freq.put("La", 560);
    freq.put("Lo", 1596);
    freq.put("Lm", 39);
    freq.put("Li", 1017);
    freq.put("Lu", 167);
    freq.put("Ly", 34);
    freq.put("hoe", 123);
    freq.put("hoc", 129);
    freq.put("hoa", 24);
    freq.put("hon", 627);
    freq.put("hoo", 690);
    freq.put("hol", 518);
    freq.put("hom", 508);
    freq.put("hoi", 82);
    freq.put("how", 1608);
    freq.put("hot", 772);
    freq.put("hou", 2312);
    freq.put("hor", 390);
    freq.put("hos", 429);
    freq.put("hop", 739);
    freq.put("A", 7718);
    freq.put("L ", 988);
    freq.put("ho ", 1197);
    freq.put("AO ", 64);
    freq.put(" V ", 61);
    freq.put("AP ", 53);
    freq.put("fir", 630);
    freq.put("fis", 73);
    freq.put("His", 68);
    freq.put("fiv", 34);
    freq.put("fit", 166);
    freq.put("uot", 77);
    freq.put("fix", 61);
    freq.put("fic", 461);
    freq.put("fig", 173);
    freq.put("fid", 28);
    freq.put("Hig", 84);
    freq.put("Hil", 38);
    freq.put("fil", 317);
    freq.put(" Va", 109);
    freq.put(" Ve", 190);
    freq.put("au ", 28);
    freq.put(" Vi", 521);
    freq.put(" Vo", 91);
    freq.put("Hi ", 98);
    freq.put("fi ", 78);
    freq.put("xp", 481);
    freq.put("rt", 5054);
    freq.put("ru", 1733);
    freq.put("rv", 595);
    freq.put("rw", 307);
    freq.put("rp", 424);
    freq.put("rr", 2853);
    freq.put("rs", 5812);
    freq.put("dst", 28);
    freq.put("ry", 4513);
    freq.put("rz", 43);
    freq.put("rd", 3105);
    freq.put("re", 25298);
    freq.put("rf", 529);
    freq.put("rg", 1144);
    freq.put("ra", 6479);
    freq.put("rb", 322);
    freq.put("rc", 837);
    freq.put("rl", 2075);
    freq.put("rm", 1626);
    freq.put("rn", 2060);
    freq.put("dse", 22);
    freq.put("rh", 122);
    freq.put("ri", 8982);
    freq.put("sma", 182);
    freq.put("rk", 1976);
    freq.put("IM ", 41);
    freq.put("OW ", 250);
    freq.put("atf", 39);
    freq.put("ate", 3025);
    freq.put("atc", 1212);
    freq.put("ata", 204);
    freq.put("ato", 206);
    freq.put("atl", 36);
    freq.put("atm", 65);
    freq.put("ath", 724);
    freq.put("ati", 2020);
    freq.put("att", 663);
    freq.put("atu", 485);
    freq.put("r ", 27190);
    freq.put("ats", 539);
    freq.put("ds ", 1929);
    freq.put("sm ", 79);
    freq.put("Swi", 55);
    freq.put("kfu", 38);
    freq.put("Swa", 28);
    freq.put("Dub", 35);
    freq.put("Dud", 23);
    freq.put("If ", 579);
    freq.put("kfa", 51);
    freq.put("Dur", 23);
    freq.put("Dut", 31);
    freq.put("xic", 43);
    freq.put("xie", 32);
    freq.put("Cen", 57);
    freq.put("Cel", 51);
    freq.put("xin", 61);
    freq.put("xis", 70);
    freq.put("xit", 22);
    freq.put("kno", 1696);
    freq.put("kni", 25);
    freq.put("Ass", 67);
    freq.put("Ast", 26);
    freq.put(" fb", 46);
    freq.put("Ask", 22);
    freq.put(" fe", 1418);
    freq.put("Asi", 28);
    freq.put("Ash", 35);
    freq.put("lp ", 321);
    freq.put("nel", 236);
    freq.put("lps", 35);
    freq.put("As ", 132);
    freq.put("lpi", 23);
    freq.put("lph", 47);
    freq.put("hus", 53);
    freq.put("nev", 540);
    freq.put("yfr", 62);
    freq.put("X", 586);
    freq.put("Ris", 49);
    freq.put("Rih", 24);
    freq.put("Rig", 63);
    freq.put("Rid", 24);
    freq.put("Ric", 67);
    freq.put("PS ", 69);
    freq.put("iry", 25);
    freq.put("irp", 52);
    freq.put("irr", 66);
    freq.put("irs", 643);
    freq.put("irt", 578);
    freq.put("iri", 104);
    freq.put("irk", 29);
    freq.put("irl", 665);
    freq.put("irm", 98);
    freq.put("iro", 72);
    freq.put("ira", 154);
    freq.put("irc", 66);
    freq.put("ird", 238);
    freq.put("ire", 822);
    freq.put("irg", 34);
    freq.put("wtf", 30);
    freq.put("wth", 26);
    freq.put("rgu", 54);
    freq.put("DM ", 59);
    freq.put("ir ", 972);
    freq.put("pre", 1060);
    freq.put("fra", 117);
    freq.put("fre", 452);
    freq.put("fri", 786);
    freq.put("fro", 1895);
    freq.put("fru", 34);
    freq.put("pro", 1411);
    freq.put("rgi", 74);
    freq.put("uy ", 388);
    freq.put("BC ", 93);
    freq.put("smi", 222);
    freq.put("BE ", 67);
    freq.put("dha", 23);
    freq.put("big", 329);
    freq.put("bie", 122);
    freq.put("tz ", 31);
    freq.put("hah", 1303);
    freq.put("hai", 334);
    freq.put("hak", 91);
    freq.put("hal", 398);
    freq.put("ham", 340);
    freq.put("han", 2975);
    freq.put("haa", 73);
    freq.put("hab", 43);
    freq.put("hac", 65);
    freq.put("had", 629);
    freq.put("hae", 78);
    freq.put("haf", 27);
    freq.put("hag", 28);
    freq.put("hap", 700);
    freq.put("har", 870);
    freq.put("has", 1017);
    freq.put("hat", 7276);
    freq.put("hau", 41);
    freq.put("hav", 3091);
    freq.put("haw", 29);
    freq.put("ha ", 1018);
    freq.put("ola", 222);
    freq.put("old", 871);
    freq.put("ole", 462);
    freq.put("olf", 54);
    freq.put("oli", 442);
    freq.put("olk", 56);
    freq.put("oll", 2094);
    freq.put("olo", 350);
    freq.put("ols", 79);
    freq.put("olt", 27);
    freq.put("olu", 250);
    freq.put("olv", 91);
    freq.put("oly", 62);
    freq.put("fou", 222);
    freq.put("ump", 178);
    freq.put("for", 6915);
    freq.put("fox", 26);
    freq.put("ume", 174);
    freq.put("uma", 116);
    freq.put("foc", 39);
    freq.put("umm", 231);
    freq.put("fon", 29);
    freq.put("foo", 326);
    freq.put("umi", 102);
    freq.put("ol ", 1739);
    freq.put(" Xx", 83);
    freq.put("o", 185861);
    freq.put("fo ", 95);
    freq.put("um ", 590);
    freq.put("mbl", 144);
    freq.put("soc", 148);
    freq.put("mbo", 50);
    freq.put("mbi", 84);
    freq.put("Fea", 52);
    freq.put("mbe", 723);
    freq.put("som", 2177);
    freq.put("sol", 263);
    freq.put("soo", 469);
    freq.put("son", 1459);
    freq.put("sor", 421);
    freq.put("Fer", 39);
    freq.put("Fes", 60);
    freq.put("mbu", 36);
    freq.put("mbr", 39);
    freq.put("mbs", 23);
    freq.put("az ", 30);
    freq.put("so ", 2844);
    freq.put("mb ", 116);
    freq.put("azi", 436);
    freq.put("azo", 36);
    freq.put("aza", 25);
    freq.put("aze", 63);
    freq.put("azy", 188);
    freq.put("azz", 49);
    freq.put("Sir", 30);
    freq.put("Sit", 52);
    freq.put("Sig", 42);
    freq.put("kha", 23);
    freq.put("Sin", 111);
    freq.put("Sim", 104);
    freq.put("Sil", 52);
    freq.put("nx ", 41);
    freq.put("E", 3030);
    freq.put("Ide", 26);
    freq.put("lr ", 75);
    freq.put("osp", 78);
    freq.put("oss", 393);
    freq.put("ost", 1248);
    freq.put("osi", 229);
    freq.put("osh", 144);
    freq.put("oso", 52);
    freq.put("osa", 42);
    freq.put("osc", 25);
    freq.put("ose", 977);
    freq.put("vet", 26);
    freq.put("ver", 4765);
    freq.put("ves", 587);
    freq.put("vey", 25);
    freq.put("veg", 30);
    freq.put("ved", 395);
    freq.put("vea", 69);
    freq.put("ven", 1302);
    freq.put("vel", 538);
    freq.put("vem", 113);
    freq.put("vei", 28);
    freq.put("lre", 294);
    freq.put("lri", 77);
    freq.put("os ", 491);
    freq.put("By ", 70);
    freq.put("Tar", 25);
    freq.put("Tay", 56);
    freq.put("Tab", 30);
    freq.put("Tal", 61);
    freq.put("Tak", 107);
    freq.put("M ", 644);
    freq.put("Me", 706);
    freq.put("Ma", 1750);
    freq.put("Mc", 104);
    freq.put("Mo", 1045);
    freq.put("Mi", 797);
    freq.put("yda", 64);
    freq.put("Mu", 355);
    freq.put("uff", 335);
    freq.put("Mr", 94);
    freq.put("My", 715);
    freq.put("ipa", 39);
    freq.put("ipe", 60);
    freq.put("iph", 31);
    freq.put("ipo", 42);
    freq.put("ipl", 52);
    freq.put("ips", 196);
    freq.put("ipp", 144);
    freq.put("ipt", 72);
    freq.put("ip ", 419);
    freq.put("mba", 99);
    freq.put("DO ", 50);
    freq.put("Liv", 181);
    freq.put("Our", 81);
    freq.put("Out", 89);
    freq.put("TF ", 35);
    freq.put(" pp", 92);
    freq.put("Whe", 418);
    freq.put("ST ", 244);
    freq.put("Wha", 643);
    freq.put("Who", 245);
    freq.put("Whi", 127);
    freq.put("s ", 53309);
    freq.put("Why", 316);
    freq.put("sy", 479);
    freq.put("ss", 4962);
    freq.put("sr", 104);
    freq.put("sq", 82);
    freq.put("sp", 1819);
    freq.put("sw", 644);
    freq.put("su", 2739);
    freq.put("st", 17341);
    freq.put("sk", 802);
    freq.put("si", 5517);
    freq.put("sh", 6339);
    freq.put("so", 8523);
    freq.put("sn", 844);
    freq.put("sm", 715);
    freq.put("sl", 1249);
    freq.put("sc", 1568);
    freq.put("sb", 130);
    freq.put("sa", 3266);
    freq.put("sg", 68);
    freq.put("sf", 151);
    freq.put("se", 11267);
    freq.put("sd", 220);
    freq.put("tty", 310);
    freq.put("ttr", 39);
    freq.put("ttp", 115);
    freq.put("ttt", 79);
    freq.put("tti", 744);
    freq.put("tto", 181);
    freq.put("ttl", 529);
    freq.put("tta", 310);
    freq.put("tte", 1834);
    freq.put("jin", 23);
    freq.put("tt ", 194);
    freq.put("Jos", 29);
    freq.put("bly", 231);
    freq.put("blu", 94);
    freq.put("blr", 77);
    freq.put("blo", 404);
    freq.put("bli", 255);
    freq.put("Joe", 71);
    freq.put("ble", 1294);
    freq.put("Joi", 40);
    freq.put("bla", 260);
    freq.put("Jon", 81);
    freq.put("onk", 56);
    freq.put("oni", 586);
    freq.put("onn", 578);
    freq.put("ono", 131);
    freq.put("onl", 806);
    freq.put("onm", 29);
    freq.put("onc", 308);
    freq.put("£ ", 174);
    freq.put("onf", 251);
    freq.put("ong", 1563);
    freq.put("ond", 903);
    freq.put("one", 4127);
    freq.put("ony", 135);
    freq.put("ons", 1376);
    freq.put("onv", 114);
    freq.put("ont", 1345);
    freq.put("onu", 38);
    freq.put("Hmm", 61);
    freq.put("uke", 37);
    freq.put(" Zo", 32);
    freq.put(" Ze", 39);
    freq.put("on ", 11421);
    freq.put(" Za", 42);
    freq.put(" Zu", 23);
    freq.put("AT ", 239);
    freq.put("uk ", 75);
    freq.put("sak", 27);
    freq.put("sai", 397);
    freq.put("san", 177);
    freq.put("sam", 334);
    freq.put("sal", 159);
    freq.put("sac", 32);
    freq.put("sab", 35);
    freq.put("sag", 132);
    freq.put("saf", 70);
    freq.put("sad", 168);
    freq.put("say", 917);
    freq.put("sas", 36);
    freq.put("sar", 81);
    freq.put("sap", 64);
    freq.put("saw", 183);
    freq.put("sav", 105);
    freq.put("sau", 57);
    freq.put("sat", 155);
    freq.put("Eco", 23);
    freq.put("zon", 79);
    freq.put("ax ", 94);
    freq.put("sa ", 109);
    freq.put("axy", 28);
    freq.put("axe", 22);
    freq.put("axi", 34);
    freq.put("Sky", 68);
    freq.put("vid", 919);
    freq.put("ux", 73);
    freq.put("uz", 174);
    freq.put("up", 3151);
    freq.put("us", 9057);
    freq.put("ur", 9057);
    freq.put("um", 1976);
    freq.put(" b ", 138);
    freq.put("ul", 4512);
    freq.put("Aww", 68);
    freq.put("un", 5844);
    freq.put("Awe", 46);
    freq.put("Awa", 54);
    freq.put("Hit", 50);
    freq.put(" be", 7474);
    freq.put(" bd", 41);
    freq.put(" bf", 28);
    freq.put(" ba", 2524);
    freq.put(" bc", 26);
    freq.put(" bb", 82);
    freq.put(" bl", 846);
    freq.put(" bo", 1740);
    freq.put(" bi", 1352);
    freq.put(" bu", 3194);
    freq.put(" bt", 86);
    freq.put("s", 123821);
    freq.put(" br", 1198);
    freq.put(" by", 1299);
    freq.put("Aw ", 23);
    freq.put("fie", 173);
    freq.put("fin", 1053);
    freq.put("ive", 2327);
    freq.put("iva", 265);
    freq.put("ivi", 332);
    freq.put("UT ", 114);
    freq.put("uic", 120);
    freq.put("iv ", 28);
    freq.put("I", 19076);
    freq.put("wpl", 23);
    freq.put(" gu", 854);
    freq.put("hx ", 52);
    freq.put("oov", 26);
    freq.put("gdo", 23);
    freq.put("My ", 658);
    freq.put(" gl", 239);
    freq.put("NA ", 82);
    freq.put(" gi", 1098);
    freq.put("eze", 24);
    freq.put("ddy", 77);
    freq.put("ac ", 86);
    freq.put("dds", 25);
    freq.put("ddr", 31);
    freq.put("ddi", 186);
    freq.put("´", 198);
    freq.put("ddl", 108);
    freq.put("dda", 65);
    freq.put("dde", 134);
    freq.put("ddd", 30);
    freq.put("ez ", 88);
    freq.put("tv ", 85);
    freq.put("acc", 343);
    freq.put("aca", 63);
    freq.put("ace", 1183);
    freq.put("ack", 2220);
    freq.put("aci", 102);
    freq.put("ach", 679);
    freq.put("aco", 77);
    freq.put("acr", 64);
    freq.put("act", 1129);
    freq.put("FL ", 25);
    freq.put("acy", 66);
    freq.put("dd ", 132);
    freq.put("Ni", 416);
    freq.put("bje", 39);
    freq.put("No", 1474);
    freq.put("Na", 324);
    freq.put("Ne", 1161);
    freq.put("Nu", 51);
    freq.put("het", 97);
    freq.put("hew", 44);
    freq.put("her", 5516);
    freq.put("hes", 719);
    freq.put("hey", 1709);
    freq.put("hed", 464);
    freq.put("hee", 303);
    freq.put("hef", 30);
    freq.put("hea", 1285);
    freq.put("hec", 557);
    freq.put("hel", 724);
    freq.put("hem", 887);
    freq.put("hen", 2511);
    freq.put("heo", 46);
    freq.put("heh", 147);
    freq.put("hei", 482);
    freq.put("N ", 1015);
    freq.put("he ", 17033);
    freq.put("aa", 747);
    freq.put("ac", 6117);
    freq.put("ab", 3259);
    freq.put("ae", 246);
    freq.put("uid", 59);
    freq.put("ag", 2996);
    freq.put("af", 1024);
    freq.put("Hon", 41);
    freq.put("ah", 2937);
    freq.put("Hol", 110);
    freq.put("aj", 116);
    freq.put("am", 5729);
    freq.put("uil", 155);
    freq.put("ao", 258);
    freq.put("uin", 112);
    freq.put("aq", 24);
    freq.put("ap", 2687);
    freq.put("as", 10778);
    freq.put("ar", 14907);
    freq.put("au", 2158);
    freq.put("at", 19853);
    freq.put("aw", 1711);
    freq.put("av", 4917);
    freq.put("ay", 9693);
    freq.put("ax", 205);
    freq.put("az", 836);
    freq.put("a ", 16736);
    freq.put("oh ", 470);
    freq.put("at ", 10269);
    freq.put("Fir", 132);
    freq.put("sco", 285);
    freq.put("sci", 68);
    freq.put("sch", 470);
    freq.put("Fit", 23);
    freq.put("sce", 81);
    freq.put("sca", 210);
    freq.put(" a", 39546);
    freq.put("Fig", 34);
    freq.put("scu", 97);
    freq.put("Fin", 205);
    freq.put("Fil", 63);
    freq.put("scr", 320);
    freq.put("smo", 57);
    freq.put("tz", 70);
    freq.put("dso", 27);
    freq.put("tv", 102);
    freq.put("tw", 1976);
    freq.put("tt", 4422);
    freq.put("tu", 2971);
    freq.put("tr", 3997);
    freq.put("ts", 4760);
    freq.put("tp", 183);
    freq.put("tn", 216);
    freq.put("to", 19813);
    freq.put("tl", 1422);
    freq.put("tm", 303);
    freq.put("th", 37258);
    freq.put("ti", 12335);
    freq.put("tf", 224);
    freq.put("tg", 30);
    freq.put("Eas", 76);
    freq.put("Ear", 64);
    freq.put("tb", 241);
    freq.put("Eat", 22);
    freq.put("ta", 6179);
    freq.put("dsh", 41);
    freq.put("smh", 30);
    freq.put("mn ", 175);
    freq.put("sme", 102);
    freq.put("ro", 8901);
    freq.put("t ", 58552);
    freq.put("Smi", 45);
    freq.put("Sma", 57);
    freq.put("xox", 66);
    freq.put("t´", 43);
    freq.put("xo ", 22);
    freq.put("vic", 251);
    freq.put("via", 745);
    freq.put("Aug", 99);
    freq.put("vie", 565);
    freq.put("vin", 813);
    freq.put("vio", 119);
    freq.put("vil", 117);
    freq.put("vir", 59);
    freq.put("vis", 264);
    freq.put("Aus", 52);
    freq.put("viv", 48);
    freq.put("Aut", 52);
    freq.put("vit", 140);
    freq.put(" d ", 478);
    freq.put("VE ", 306);
    freq.put("vi ", 32);
    freq.put(" do", 5167);
    freq.put(" dn", 24);
    freq.put(" dm", 41);
    freq.put(" di", 2152);
    freq.put(" de", 1954);
    freq.put("kli", 28);
    freq.put(" da", 2288);
    freq.put(" dy", 54);
    freq.put(" du", 396);
    freq.put(" dr", 976);
    freq.put("RS ", 93);
    freq.put("n´t", 41);
    freq.put("atr", 83);
    freq.put("xua", 26);
    freq.put("aty", 33);
    freq.put("itn", 80);
    freq.put("ito", 97);
    freq.put("IP ", 67);
    freq.put("itm", 26);
    freq.put("ith", 3396);
    freq.put("iti", 1006);
    freq.put("ite", 1744);
    freq.put("itc", 340);
    freq.put("ita", 334);
    freq.put("itz", 23);
    freq.put("ity", 912);
    freq.put("PY ", 38);
    freq.put("itt", 1325);
    freq.put("itu", 121);
    freq.put("itr", 22);
    freq.put("its", 861);
    freq.put("wre", 24);
    freq.put("UR ", 129);
    freq.put("wra", 24);
    freq.put("wro", 228);
    freq.put("wri", 257);
    freq.put("̶", 49);
    freq.put("Swe", 62);
    freq.put("it ", 7449);
    freq.put("cc ", 37);
    freq.put(" A ", 909);
    freq.put("MG ", 121);
    freq.put("fts", 23);
    freq.put("ftw", 55);
    freq.put("SH ", 48);
    freq.put("fte", 584);
    freq.put("fti", 22);
    freq.put(" Aa", 45);
    freq.put(" Ab", 146);
    freq.put(" Ac", 216);
    freq.put(" Ad", 250);
    freq.put(" Af", 154);
    freq.put(" Ag", 91);
    freq.put(" Ah", 148);
    freq.put(" Ai", 112);
    freq.put(" Al", 739);
    freq.put(" Am", 365);
    freq.put(" An", 1330);
    freq.put(" Ap", 280);
    freq.put(" Ar", 573);
    freq.put(" As", 316);
    freq.put(" At", 209);
    freq.put(" Au", 238);
    freq.put(" Av", 71);
    freq.put(" Aw", 215);
    freq.put("NG ", 370);
    freq.put("ft ", 440);
    freq.put("w", 47720);
    freq.put("HD ", 52);
    freq.put("Fra", 153);
    freq.put("Fre", 208);
    freq.put("ody", 436);
    freq.put("Fri", 244);
    freq.put("Fro", 108);
    freq.put("KE ", 101);
    freq.put("jer", 28);
    freq.put("jes", 26);
    freq.put("aa ", 97);
    freq.put("jec", 157);
    freq.put("jea", 85);
    freq.put("dfi", 26);
    freq.put("aaa", 365);
    freq.put("aan", 26);
    freq.put("aah", 74);
    freq.put("aar", 25);
    freq.put("aay", 38);
    freq.put("OT ", 154);
    freq.put("uet", 26);
    freq.put("Is ", 312);
    freq.put("ex ", 239);
    freq.put("tp ", 109);
    freq.put("odd", 62);
    freq.put("odg", 28);
    freq.put("Isr", 37);
    freq.put("M", 6816);
    freq.put("Isl", 48);
    freq.put("exe", 57);
    freq.put("exc", 312);
    freq.put("exa", 173);
    freq.put("exh", 24);
    freq.put("tph", 23);
    freq.put("ext", 714);
    freq.put("exu", 39);
    freq.put("exp", 394);
    freq.put("exy", 97);
    freq.put("Hah", 234);
    freq.put("Hai", 24);
    freq.put("ugi", 29);
    freq.put("ugh", 1631);
    freq.put("Hal", 87);
    freq.put("Ham", 51);
    freq.put("Han", 100);
    freq.put("ugl", 54);
    freq.put("ugb", 33);
    freq.put("uga", 50);
    freq.put("Hac", 28);
    freq.put("Had", 93);
    freq.put("uge", 81);
    freq.put("oje", 105);
    freq.put("ugs", 91);
    freq.put("Har", 205);
    freq.put("Has", 52);
    freq.put("Hat", 50);
    freq.put("ugu", 94);
    freq.put("rf ", 29);
    freq.put("Ha ", 40);
    freq.put("ug ", 128);
    freq.put("rfu", 123);
    freq.put("cru", 111);
    freq.put("cry", 165);
    freq.put("rfa", 29);
    freq.put("cra", 408);
    freq.put("rfe", 154);
    freq.put("cre", 593);
    freq.put("cri", 311);
    freq.put("rfo", 140);
    freq.put("cro", 226);
    freq.put("Fou", 71);
    freq.put("set", 341);
    freq.put("ses", 504);
    freq.put("ser", 743);
    freq.put("For", 427);
    freq.put("sep", 55);
    freq.put("sey", 65);
    freq.put("sex", 229);
    freq.put("sef", 34);
    freq.put("see", 1436);
    freq.put("sed", 949);
    freq.put("sec", 313);
    freq.put("sea", 352);
    freq.put("Fol", 216);
    freq.put("sen", 688);
    freq.put("sem", 56);
    freq.put("Foo", 75);
    freq.put("ue ", 707);
    freq.put("se ", 4540);
    freq.put("pda", 188);
    freq.put("lex", 82);
    freq.put("tiv", 553);
    freq.put("xam", 85);
    freq.put("xac", 92);
    freq.put("nre", 30);
    freq.put("Old", 29);
    freq.put("ctr", 82);
    freq.put("cts", 144);
    freq.put("mly", 25);
    freq.put("voc", 32);
    freq.put("vol", 133);
    freq.put("von", 33);
    freq.put("voi", 135);
    freq.put("vot", 131);
    freq.put("vou", 128);
    freq.put("vor", 228);
    freq.put("So ", 446);
    freq.put(" f ", 63);
    freq.put("vo ", 32);
    freq.put("tis", 288);
    freq.put("HY ", 26);
    freq.put("WS ", 29);
    freq.put("Soc", 123);
    freq.put(" fr", 2943);
    freq.put(" fu", 1413);
    freq.put(" ft", 52);
    freq.put("Sof", 43);
    freq.put("kne", 119);
    freq.put("Som", 274);
    freq.put("Sol", 79);
    freq.put("Soo", 50);
    freq.put("Son", 131);
    freq.put(" fa", 2540);
    freq.put("Sor", 117);
    freq.put("Sou", 170);
    freq.put(" ff", 28);
    freq.put(" fi", 2089);
    freq.put(" fl", 451);
    freq.put(" fo", 7936);
    freq.put("O ", 1174);
    freq.put("tly", 475);
    freq.put("Oo", 77);
    freq.put("On", 634);
    freq.put("Om", 77);
    freq.put("Ol", 72);
    freq.put("Ok", 146);
    freq.put("Oi", 23);
    freq.put("Oh", 387);
    freq.put("Of", 372);
    freq.put("Od", 22);
    freq.put("Oc", 137);
    freq.put("Ob", 65);
    freq.put("Ow", 41);
    freq.put("Ov", 60);
    freq.put("Ou", 181);
    freq.put("Ot", 37);
    freq.put("Os", 48);
    freq.put("Or", 181);
    freq.put("Op", 131);
    freq.put("d", 69914);
    freq.put("dun", 68);
    freq.put("b ", 1142);
    freq.put("UP ", 43);
    freq.put("bd", 65);
    freq.put("be", 9770);
    freq.put("bf", 36);
    freq.put("ba", 3518);
    freq.put("bb", 349);
    freq.put("bc", 59);
    freq.put("bl", 2631);
    freq.put("bm", 44);
    freq.put("bo", 4249);
    freq.put("bh", 51);
    freq.put("bi", 2036);
    freq.put("bj", 41);
    freq.put("bt", 215);
    freq.put("bu", 3761);
    freq.put("bv", 59);
    freq.put("bw", 24);
    freq.put("br", 1595);
    freq.put("bs", 709);
    freq.put("by", 1785);
    freq.put("Fu", 257);
    freq.put("DE ", 43);
    freq.put("ME ", 275);
    freq.put(" C ", 196);
    freq.put("SJ ", 23);
    freq.put("u ", 12272);
    freq.put("Fe", 351);
    freq.put(" Ch", 1163);
    freq.put(" Ci", 171);
    freq.put(" Co", 1588);
    freq.put(" Cl", 348);
    freq.put("uT", 83);
    freq.put(" Ca", 1272);
    freq.put(" Ce", 149);
    freq.put(" Cz", 27);
    freq.put(" Cy", 48);
    freq.put("Fi", 559);
    freq.put(" Cr", 359);
    freq.put(" Cu", 225);
    freq.put("cia", 765);
    freq.put("uy", 773);
    freq.put("cif", 31);
    freq.put("cie", 141);
    freq.put("cid", 156);
    freq.put("uu", 204);
    freq.put("ut", 9223);
    freq.put("uw", 22);
    freq.put("uv", 100);
    freq.put("cio", 84);
    freq.put("cin", 215);
    freq.put("NE ", 170);
    freq.put("cil", 66);
    freq.put("cis", 119);
    freq.put("cir", 34);
    freq.put("uo", 124);
    freq.put("cip", 58);
    freq.put("ui", 1036);
    freq.put("uh", 168);
    freq.put("uk", 201);
    freq.put("cit", 362);
    freq.put("ue", 1685);
    freq.put("ud", 1128);
    freq.put("ug", 2367);
    freq.put("uf", 392);
    freq.put("ua", 1095);
    freq.put("uc", 2980);
    freq.put("ub", 1066);
    freq.put("ag ", 207);
    freq.put("ago", 186);
    freq.put("agn", 36);
    freq.put("agi", 202);
    freq.put("agg", 73);
    freq.put("age", 1221);
    freq.put("aga", 712);
    freq.put("agu", 88);
    freq.put("ags", 62);
    freq.put("agr", 163);
    freq.put("Jim", 30);
    freq.put("bvi", 42);
    freq.put("ev ", 39);
    freq.put("tri", 603);
    freq.put("evi", 342);
    freq.put("tro", 513);
    freq.put("evo", 81);
    freq.put("tra", 1135);
    freq.put("eva", 94);
    freq.put("tre", 724);
    freq.put("eve", 3694);
    freq.put("try", 532);
    freq.put("tru", 462);
    freq.put("le ", 4826);
    freq.put("uel", 77);
    freq.put("uen", 60);
    freq.put("uee", 57);
    freq.put("ued", 33);
    freq.put("ods", 77);
    freq.put("odu", 182);
    freq.put("odi", 102);
    freq.put("Blo", 206);
    freq.put("odm", 24);
    freq.put("odn", 77);
    freq.put("odo", 26);
    freq.put("Ble", 25);
    freq.put("oda", 1230);
    freq.put("odb", 40);
    freq.put("odc", 31);
    freq.put("Bla", 189);
    freq.put("ode", 412);
    freq.put("ues", 589);
    freq.put("uer", 46);
    freq.put("ct ", 853);
    freq.put("rd ", 1652);
    freq.put("lea", 1911);
    freq.put("leb", 141);
    freq.put("lec", 264);
    freq.put("led", 570);
    freq.put("lee", 572);
    freq.put("lef", 184);
    freq.put("leg", 275);
    freq.put("lei", 29);
    freq.put("lem", 252);
    freq.put("len", 541);
    freq.put("lep", 63);
    freq.put("ler", 406);
    freq.put("les", 1135);
    freq.put("let", 811);
    freq.put("lev", 146);
    freq.put("lew", 30);
    freq.put("od ", 2265);
    freq.put("ley", 230);
    freq.put("ctu", 608);
    freq.put("rds", 375);
    freq.put("rdr", 26);
    freq.put("rde", 313);
    freq.put("cte", 224);
    freq.put("rda", 321);
    freq.put("cta", 49);
    freq.put("ctl", 123);
    freq.put("rdl", 25);
    freq.put("rdo", 52);
    freq.put("cto", 384);
    freq.put("rdi", 202);
    freq.put("cti", 905);
    freq.put("sgu", 32);
    freq.put("Cla", 74);
    freq.put("zin", 470);
    freq.put("zil", 25);
    freq.put("xce", 114);
    freq.put("xci", 222);
    freq.put("xcl", 37);
    freq.put("xcu", 23);
    freq.put("On ", 184);
    freq.put("Q", 308);
    freq.put("Onl", 155);
    freq.put("Onc", 25);
    freq.put("One", 231);
    freq.put("TY ", 46);
    freq.put("lz ", 61);
    freq.put(" h ", 98);
    freq.put(" hP", 30);
    freq.put("Sai", 34);
    freq.put("San", 67);
    freq.put("Sam", 117);
    freq.put("Sal", 74);
    freq.put(" hr", 44);
    freq.put(" hu", 696);
    freq.put(" ht", 184);
    freq.put("Say", 67);
    freq.put(" ho", 3309);
    freq.put(" hm", 78);
    freq.put("Sar", 27);
    freq.put(" ha", 7629);
    freq.put("Sav", 34);
    freq.put(" he", 4542);
    freq.put("Sat", 116);
    freq.put("OM ", 58);
    freq.put("IT ", 211);
    freq.put("ihi", 22);
    freq.put("iha", 30);
    freq.put("UN ", 38);
    freq.put("clo", 313);
    freq.put("lly", 2262);
    freq.put(" E ", 188);
    freq.put("ck ", 3526);
    freq.put(" El", 153);
    freq.put(" Em", 114);
    freq.put(" En", 414);
    freq.put(" Ei", 29);
    freq.put("ckB", 33);
    freq.put(" Ed", 153);
    freq.put(" Ef", 28);
    freq.put(" Eg", 28);
    freq.put(" Ea", 176);
    freq.put(" Ec", 46);
    freq.put(" Ex", 312);
    freq.put(" Ey", 38);
    freq.put(" Et", 25);
    freq.put(" Eu", 159);
    freq.put(" Ev", 386);
    freq.put(" Ep", 60);
    freq.put(" Er", 94);
    freq.put(" Es", 83);
    freq.put("cke", 732);
    freq.put("ckg", 27);
    freq.put("cka", 51);
    freq.put("AA ", 33);
    freq.put("ckb", 60);
    freq.put("ckl", 112);
    freq.put("cko", 39);
    freq.put("ckn", 31);
    freq.put("cki", 572);
    freq.put("ckh", 32);
    freq.put("ckp", 23);
    freq.put("cks", 381);
    freq.put("cky", 154);
    freq.put("dba", 45);
    freq.put("dby", 37);
    freq.put("ae ", 67);
    freq.put("jam", 44);
    freq.put("jai", 26);
    freq.put("jac", 31);
    freq.put("EX ", 22);
    freq.put("h", 98117);
    freq.put("ael", 103);
    freq.put("ja ", 38);
    freq.put("gby", 33);
    freq.put("Pr", 759);
    freq.put("Ps", 40);
    freq.put("btw", 69);
    freq.put("Pu", 153);
    freq.put("oma", 326);
    freq.put("Pa", 810);
    freq.put("OP ", 47);
    freq.put("Pe", 419);
    freq.put("Ph", 409);
    freq.put("Pi", 283);
    freq.put("Po", 567);
    freq.put("Pl", 582);
    freq.put("et ", 4687);
    freq.put("EY ", 57);
    freq.put("P ", 678);
    freq.put("eun", 24);
    freq.put("bt ", 100);
    freq.put("etr", 107);
    freq.put("ets", 750);
    freq.put("etw", 317);
    freq.put("ett", 1342);
    freq.put("etu", 90);
    freq.put("llu", 33);
    freq.put("la", 6758);
    freq.put("etc", 97);
    freq.put("tla", 44);
    freq.put("eta", 239);
    freq.put("tle", 792);
    freq.put("ete", 532);
    freq.put("tli", 64);
    freq.put("eti", 677);
    freq.put("tlo", 29);
    freq.put("eto", 56);
    freq.put("ck", 5988);
    freq.put("ci", 2099);
    freq.put("lm", 573);
    freq.put("co", 7687);
    freq.put("cn", 28);
    freq.put("Her", 186);
    freq.put("cl", 1471);
    freq.put("cc", 663);
    freq.put("cb", 25);
    freq.put("ca", 6740);
    freq.put("Hey", 192);
    freq.put("ce", 6056);
    freq.put("cd", 27);
    freq.put("Hee", 36);
    freq.put("uce", 106);
    freq.put("ucc", 97);
    freq.put("Hea", 217);
    freq.put("uca", 64);
    freq.put("cs", 378);
    freq.put("cr", 1831);
    freq.put("Hen", 35);
    freq.put("uck", 1207);
    freq.put("uci", 45);
    freq.put("uch", 1217);
    freq.put("Ger", 277);
    freq.put("Get", 208);
    freq.put("cC", 27);
    freq.put("cD", 22);
    freq.put("Geo", 58);
    freq.put("Tv ", 26);
    freq.put("rb ", 29);
    freq.put("lgi", 28);
    freq.put("c ", 1974);
    freq.put("He ", 304);
    freq.put("rbu", 33);
    freq.put("rbo", 40);
    freq.put("rbi", 49);
    freq.put("rbe", 54);
    freq.put("ly", 6657);
    freq.put("rba", 56);
    freq.put("va", 957);
    freq.put("ve", 16166);
    freq.put("vi", 4121);
    freq.put("ph ", 87);
    freq.put("vo", 897);
    freq.put("vr", 27);
    freq.put("vs", 110);
    freq.put("vu", 25);
    freq.put("vy", 82);
    freq.put("of ", 5986);
    freq.put("v ", 447);
    freq.put("phi", 103);
    freq.put("pho", 555);
    freq.put("yon", 655);
    freq.put("pha", 61);
    freq.put("phe", 82);
    freq.put("phy", 94);
    freq.put("ofa", 24);
    freq.put("off", 1024);
    freq.put("ofe", 51);
    freq.put("ofi", 97);
    freq.put("ofr", 39);
    freq.put("oft", 172);
    freq.put("xed", 59);
    freq.put("xec", 47);
    freq.put("xer", 31);
    freq.put("xes", 50);
    freq.put("web", 158);
    freq.put("wea", 424);
    freq.put("wee", 2097);
    freq.put("wed", 291);
    freq.put("wei", 179);
    freq.put("Oh ", 356);
    freq.put("wen", 188);
    freq.put("mh ", 32);
    freq.put("wel", 816);
    freq.put("wes", 365);
    freq.put("wer", 1116);
    freq.put("wev", 32);
    freq.put("wet", 30);
    freq.put(" hy", 51);
    freq.put("nve", 185);
    freq.put("nvo", 49);
    freq.put("nvi", 118);
    freq.put("we ", 1570);
    freq.put(" hi", 1871);
    freq.put("kr ", 22);
    freq.put("lle", 1010);
    freq.put("vs ", 99);
    freq.put("Sco", 82);
    freq.put("Sci", 37);
    freq.put("Sch", 103);
    freq.put(" ju", 2401);
    freq.put("Sca", 36);
    freq.put(" js", 22);
    freq.put(" jo", 532);
    freq.put(" ji", 25);
    freq.put(" je", 206);
    freq.put(" ja", 173);
    freq.put("Scr", 46);
    freq.put("yri", 89);
    freq.put("yre", 32);
    freq.put("yr ", 41);
    freq.put("OO ", 72);
    freq.put("int", 1398);
    freq.put("inu", 296);
    freq.put("inv", 172);
    freq.put("ins", 910);
    freq.put("inl", 57);
    freq.put("inm", 26);
    freq.put("inn", 348);
    freq.put("ino", 112);
    freq.put("inh", 31);
    freq.put("ini", 731);
    freq.put("inj", 54);
    freq.put("ink", 1743);
    freq.put("ind", 1488);
    freq.put("ine", 1906);
    freq.put("inf", 201);
    freq.put("ing", 18611);
    freq.put("ina", 710);
    freq.put("inb", 51);
    freq.put("inc", 533);
    freq.put("eo ", 838);
    freq.put(" ▸ ", 75);
    freq.put("DA ", 24);
    freq.put("U", 1747);
    freq.put("in ", 9122);
    freq.put("eof", 39);
    freq.put("eon", 507);
    freq.put("eos", 69);
    freq.put("eor", 83);
    freq.put("eop", 978);
    freq.put("eou", 90);
    freq.put("Tur", 81);
    freq.put("SN ", 23);
    freq.put("AH ", 50);
    freq.put("Wri", 35);
    freq.put("MA ", 49);
    freq.put(" G ", 97);
    freq.put("pte", 187);
    freq.put("reo", 40);
    freq.put(" Gu", 240);
    freq.put(" Gr", 534);
    freq.put("rel", 531);
    freq.put(" Ge", 672);
    freq.put(" Ga", 441);
    freq.put(" Go", 1324);
    freq.put(" Gl", 177);
    freq.put(" Gh", 38);
    freq.put(" Gi", 273);
    freq.put("iTu", 38);
    freq.put("reg", 183);
    freq.put("NY ", 53);
    freq.put("fa ", 62);
    freq.put("alr", 334);
    freq.put("ak ", 311);
    freq.put("LS ", 59);
    freq.put("Cr", 375);
    freq.put("gli", 194);
    freq.put("glo", 64);
    freq.put("aks", 71);
    freq.put("gla", 239);
    freq.put("gle", 449);
    freq.put("gly", 105);
    freq.put("aki", 500);
    freq.put("aka", 49);
    freq.put("akf", 50);
    freq.put("ake", 2135);
    freq.put("Jer", 49);
    freq.put("Jes", 60);
    freq.put("bru", 58);
    freq.put("bro", 469);
    freq.put("Jed", 40);
    freq.put("bre", 335);
    freq.put("Jen", 46);
    freq.put("OR ", 138);
    freq.put("er ", 11946);
    freq.put("nke", 128);
    freq.put("nkf", 39);
    freq.put("iu", 148);
    freq.put("nkl", 22);
    freq.put("nks", 874);
    freq.put("nky", 73);
    freq.put("Nam", 34);
    freq.put("ert", 525);
    freq.put("erv", 472);
    freq.put("erw", 88);
    freq.put("erp", 113);
    freq.put("err", 414);
    freq.put("ers", 3073);
    freq.put("ery", 1855);
    freq.put("erd", 247);
    freq.put("ere", 3979);
    freq.put("erf", 432);
    freq.put("erg", 187);
    freq.put("CT ", 30);
    freq.put("era", 683);
    freq.put("erb", 119);
    freq.put("erc", 164);
    freq.put("erl", 245);
    freq.put("erm", 598);
    freq.put("ern", 552);
    freq.put("ero", 197);
    freq.put("erh", 81);
    freq.put("eri", 953);
    freq.put("erk", 55);
    freq.put("io", 5076);
    freq.put("uar", 180);
    freq.put("la ", 270);
    freq.put("uat", 82);
    freq.put("Abo", 59);
    freq.put("uak", 22);
    freq.put("Abs", 31);
    freq.put("ual", 636);
    freq.put("uan", 34);
    freq.put("uad", 24);
    freq.put("uag", 54);
    freq.put("ki ", 79);
    freq.put("lal", 23);
    freq.put("lam", 127);
    freq.put("lan", 935);
    freq.put("lah", 48);
    freq.put("lai", 185);
    freq.put("lak", 26);
    freq.put("lad", 286);
    freq.put("lag", 79);
    freq.put("lab", 165);
    freq.put("lac", 639);
    freq.put("lax", 67);
    freq.put("lay", 1000);
    freq.put("laz", 62);
    freq.put("lat", 909);
    freq.put("lau", 285);
    freq.put("lav", 38);
    freq.put("fau", 30);
    freq.put("lap", 109);
    freq.put("lar", 382);
    freq.put("las", 973);
    freq.put("zec", 29);
    freq.put("Eye", 33);
    freq.put("zed", 69);
    freq.put("zen", 34);
    freq.put("zer", 51);
    freq.put("zes", 26);
    freq.put("ze ", 184);
    freq.put("l", 93505);
    freq.put("nt ", 4856);
    freq.put("€", 29);
    freq.put("nty", 69);
    freq.put("nts", 766);
    freq.put("ntr", 428);
    freq.put("ntu", 75);
    freq.put("nti", 911);
    freq.put("nth", 277);
    freq.put("ntl", 266);
    freq.put("nto", 486);
    freq.put("nta", 451);
    freq.put("nte", 1384);
    freq.put("ntd", 22);
    freq.put("YS ", 50);
    freq.put(" l ", 28);
    freq.put(" le", 1649);
    freq.put("B", 6344);
    freq.put(" la", 1732);
    freq.put(" lo", 5473);
    freq.put(" lm", 149);
    freq.put(" ll", 1028);
    freq.put(" li", 5040);
    freq.put(" lu", 339);
    freq.put("nbu", 30);
    freq.put(" ly", 118);
    freq.put("Sev", 23);
    freq.put("Set", 41);
    freq.put("Ser", 154);
    freq.put("Sep", 188);
    freq.put("Sex", 39);
    freq.put("See", 170);
    freq.put("kto", 33);
    freq.put("Sec", 81);
    freq.put("Sea", 115);
    freq.put("Sen", 74);
    freq.put("Sel", 97);
    freq.put("Q ", 80);
    freq.put("ypt", 26);
    freq.put("nbe", 64);
    freq.put("ype", 154);
    freq.put("ypi", 25);
    freq.put("Kno", 69);
    freq.put("Qu", 200);
    freq.put("uda", 23);
    freq.put(" I´", 32);
    freq.put("d ", 34990);
    freq.put("em ", 1057);
    freq.put("hru", 37);
    freq.put("hrs", 22);
    freq.put("hro", 337);
    freq.put("hri", 223);
    freq.put("hre", 185);
    freq.put("hra", 29);
    freq.put("dn", 877);
    freq.put("do", 6210);
    freq.put("dl", 480);
    freq.put("dm", 217);
    freq.put("dj", 29);
    freq.put("dk", 83);
    freq.put("dh", 75);
    freq.put("di", 4891);
    freq.put("df", 85);
    freq.put("dg", 300);
    freq.put("dd", 817);
    freq.put("de", 7605);
    freq.put("db", 114);
    freq.put("dc", 124);
    freq.put("DC ", 24);
    freq.put("da", 5888);
    freq.put("dy", 1454);
    freq.put("dv", 218);
    freq.put("dw", 199);
    freq.put("dt", 56);
    freq.put("du", 850);
    freq.put("dr", 1380);
    freq.put("ds", 2164);
    freq.put("dp", 64);
    freq.put("eme", 679);
    freq.put("ema", 394);
    freq.put("CK ", 135);
    freq.put("emb", 579);
    freq.put("emm", 28);
    freq.put("emo", 303);
    freq.put("emi", 350);
    freq.put("emp", 261);
    freq.put("ems", 257);
    freq.put("emy", 34);
    freq.put("hr ", 35);
    freq.put("w ", 10364);
    freq.put(" I ", 14196);
    freq.put("il ", 825);
    freq.put("xD ", 120);
    freq.put("co ", 177);
    freq.put("wf", 44);
    freq.put("we", 7303);
    freq.put("wd", 62);
    freq.put("wb", 59);
    freq.put("wa", 8237);
    freq.put("wo", 4322);
    freq.put("wn", 1295);
    freq.put(" Ir", 91);
    freq.put(" Is", 446);
    freq.put(" It", 1281);
    freq.put("wi", 7127);
    freq.put("wh", 5781);
    freq.put("ww", 808);
    freq.put("wu", 37);
    freq.put("wt", 87);
    freq.put(" Il", 24);
    freq.put(" Im", 264);
    freq.put(" In", 1018);
    freq.put("wp", 31);
    freq.put(" Ia", 25);
    freq.put(" Ic", 50);
    freq.put(" Id", 71);
    freq.put(" If", 578);
    freq.put("cop", 95);
    freq.put("ild", 328);
    freq.put("ile", 1025);
    freq.put("cou", 1274);
    freq.put("cot", 84);
    freq.put("cow", 30);
    freq.put("ila", 276);
    freq.put("ilo", 51);
    freq.put("ill", 3644);
    freq.put("ilm", 172);
    freq.put("ilk", 43);
    freq.put("ili", 353);
    freq.put("ilv", 39);
    freq.put("ilt", 67);
    freq.put("ilu", 23);
    freq.put("ils", 168);
    freq.put("cog", 31);
    freq.put("cof", 81);
    freq.put("coh", 34);
    freq.put("com", 2311);
    freq.put("col", 455);
    freq.put("coo", 401);
    freq.put("ily", 446);
    freq.put("gn ", 237);
    freq.put("ai ", 66);
    freq.put("gns", 32);
    freq.put("ait", 652);
    freq.put("ais", 119);
    freq.put("air", 648);
    freq.put("aim", 77);
    freq.put("ail", 861);
    freq.put("ET ", 159);
    freq.put("gna", 70);
    freq.put("gne", 156);
    freq.put("aid", 525);
    freq.put("aig", 110);
    freq.put("gni", 96);
    freq.put("gno", 74);
    freq.put("ni ", 213);
    freq.put("ep ", 862);
    freq.put("th ", 4543);
    freq.put("nin", 1558);
    freq.put("nio", 162);
    freq.put("nim", 95);
    freq.put("nic", 653);
    freq.put("nia", 106);
    freq.put("nif", 76);
    freq.put("nig", 1112);
    freq.put("nie", 193);
    freq.put("niz", 37);
    freq.put("Y", 3221);
    freq.put("nis", 445);
    freq.put("nip", 29);
    freq.put("niq", 33);
    freq.put("niv", 100);
    freq.put("nit", 471);
    freq.put("niu", 33);
    freq.put("thy", 72);
    freq.put("epy", 45);
    freq.put("thu", 72);
    freq.put("epu", 42);
    freq.put("ths", 152);
    freq.put("eps", 128);
    freq.put("epp", 41);
    freq.put("tho", 1363);
    freq.put("epo", 165);
    freq.put("epl", 235);
    freq.put("thl", 38);
    freq.put("thi", 5422);
    freq.put("epi", 252);
    freq.put("the", 19213);
    freq.put("epe", 147);
    freq.put("mic", 122);
    freq.put("tha", 5338);
    freq.put("epa", 157);
    freq.put("rn ", 559);
    freq.put("Gar", 64);
    freq.put("Gam", 101);
    freq.put("Gal", 50);
    freq.put("Gag", 50);
    freq.put("Gad", 52);
    freq.put("Tri", 99);
    freq.put("rni", 612);
    freq.put("rno", 83);
    freq.put("Tro", 43);
    freq.put("Tra", 238);
    freq.put("rna", 186);
    freq.put("Tre", 83);
    freq.put("rne", 375);
    freq.put("Try", 53);
    freq.put("rns", 100);
    freq.put("lco", 248);
    freq.put("Tru", 93);
    freq.put("rnt", 39);
    freq.put("pl ", 101);
    freq.put("Lea", 148);
    freq.put("Lee", 60);
    freq.put("Leg", 47);
    freq.put("Lei", 28);
    freq.put("ob ", 283);
    freq.put("Leo", 23);
    freq.put("Les", 51);
    freq.put("Let", 202);
    freq.put("Lev", 31);
    freq.put("plu", 71);
    freq.put("pls", 87);
    freq.put("plz", 36);
    freq.put("ply", 166);
    freq.put("ple", 2203);
    freq.put("pla", 1469);
    freq.put("plo", 195);
    freq.put("pli", 184);
    freq.put("obo", 101);
    freq.put("obl", 189);
    freq.put("obi", 161);
    freq.put("obe", 178);
    freq.put("obb", 58);
    freq.put("oba", 249);
    freq.put("obv", 40);
    freq.put("obs", 224);
    freq.put("Cut", 43);
    freq.put("Cus", 31);
    freq.put("Cur", 52);
    freq.put("Cup", 37);
    freq.put("wan", 1527);
    freq.put("wal", 295);
    freq.put("wak", 129);
    freq.put("MP ", 22);
    freq.put("wai", 535);
    freq.put("wah", 27);
    freq.put("wag", 41);
    freq.put("waa", 22);
    freq.put("way", 1613);
    freq.put("wav", 48);
    freq.put("wat", 958);
    freq.put("was", 2124);
    freq.put("war", 831);
    freq.put(" X ", 87);
    freq.put("xy ", 128);
    freq.put("wa ", 38);
    freq.put("mth", 29);
    freq.put(" n ", 181);
    freq.put(" ni", 1098);
    freq.put(" no", 5310);
    freq.put(" na", 705);
    freq.put(" ne", 3377);
    freq.put(" nd", 96);
    freq.put(" nu", 245);
    freq.put("Sk", 106);
    freq.put("TW ", 25);
    freq.put("ums", 75);
    freq.put("umb", 350);
    freq.put("fol", 1358);
    freq.put("umo", 68);
    freq.put("gua", 100);
    freq.put("umn", 38);
    freq.put("gue", 350);
    freq.put("gui", 84);
    freq.put("gun", 69);
    freq.put("gum", 30);
    freq.put("gul", 32);
    freq.put("gus", 133);
    freq.put("p", 35384);
    freq.put("gut", 23);
    freq.put("guy", 468);
    freq.put("hte", 135);
    freq.put("hto", 44);
    freq.put("htm", 23);
    freq.put("htl", 39);
    freq.put("hti", 49);
    freq.put("OK ", 94);
    freq.put("htt", 157);
    freq.put("hts", 214);
    freq.put("IN ", 220);
    freq.put("hty", 41);
    freq.put("ek ", 502);
    freq.put("ht ", 2931);
    freq.put("eke", 233);
    freq.put(" ip", 45);
    freq.put("PC ", 53);
    freq.put("eks", 155);
    freq.put("Blu", 53);
    freq.put(" iv", 50);
    freq.put("uzz", 46);
    freq.put(" Ka", 190);
    freq.put(" Ke", 248);
    freq.put(" Ki", 338);
    freq.put(" Kn", 95);
    freq.put(" Ko", 75);
    freq.put(" Kl", 29);
    freq.put(" Kr", 39);
    freq.put(" Ku", 44);
    freq.put(" il", 148);
    freq.put("ca ", 204);
    freq.put(" im", 763);
    freq.put("Mom", 30);
    freq.put("F", 4746);
    freq.put("uz ", 99);
    freq.put("fb ", 43);
    freq.put("BS ", 34);
    freq.put("ibi", 65);
    freq.put(" K ", 76);
    freq.put("ibl", 306);
    freq.put("cas", 324);
    freq.put("car", 745);
    freq.put("ibb", 29);
    freq.put("cap", 104);
    freq.put("ibe", 158);
    freq.put("cau", 779);
    freq.put("cat", 483);
    freq.put("cak", 83);
    freq.put("iby", 55);
    freq.put("can", 2570);
    freq.put("cam", 316);
    freq.put("cal", 944);
    freq.put("cab", 40);
    freq.put("ibr", 54);
    freq.put(" ig", 66);
    freq.put("ibu", 61);
    freq.put("cad", 43);
    freq.put("ao ", 135);
    freq.put("spr", 93);
    freq.put("spi", 281);
    freq.put("spl", 55);
    freq.put("spo", 345);
    freq.put("spa", 210);
    freq.put("spe", 759);
    freq.put("gh ", 1166);
    freq.put("aoo", 37);
    freq.put("use", 1812);
    freq.put("sp ", 24);
    freq.put("ght", 3520);
    freq.put("ghs", 39);
    freq.put("ghe", 77);
    freq.put("ER ", 323);
    freq.put("gha", 85);
    freq.put("ghb", 39);
    freq.put("ghl", 50);
    freq.put("gho", 31);
    freq.put("ghh", 31);
    freq.put("ghi", 57);
    freq.put("Ru", 183);
    freq.put("Jaz", 26);
    freq.put("Che", 373);
    freq.put("Jay", 41);
    freq.put("Chi", 205);
    freq.put("no ", 1212);
    freq.put("Ry", 44);
    freq.put("Jap", 61);
    freq.put("Cho", 60);
    freq.put("Jan", 41);
    freq.put("Re", 1311);
    freq.put("Chr", 160);
    freq.put("Fee", 110);
    freq.put("Chu", 49);
    freq.put("Ro", 531);
    freq.put("Ri", 323);
    freq.put("sod", 145);
    freq.put("sof", 94);
    freq.put("nol", 53);
    freq.put("nom", 104);
    freq.put("non", 159);
    freq.put("noo", 150);
    freq.put("noi", 45);
    freq.put("nod", 23);
    freq.put("nob", 64);
    freq.put("noc", 67);
    freq.put("R ", 922);
    freq.put("noy", 91);
    freq.put("not", 2636);
    freq.put("nou", 290);
    freq.put("nov", 69);
    freq.put("now", 3294);
    freq.put("nop", 46);
    freq.put("nor", 261);
    freq.put("nos", 64);
    freq.put("sou", 378);
    freq.put("em", 4005);
    freq.put("el", 8595);
    freq.put("eo", 2729);
    freq.put("en", 16134);
    freq.put("ei", 1807);
    freq.put("eh", 576);
    freq.put("ek", 1010);
    freq.put("ej", 49);
    freq.put("ee", 10726);
    freq.put("ed", 12193);
    freq.put("eg", 980);
    freq.put("ef", 1461);
    freq.put("ea", 15221);
    freq.put("rl ", 423);
    freq.put("ec", 4706);
    freq.put("eb", 1405);
    freq.put("ey", 3433);
    freq.put("ex", 2228);
    freq.put("ez", 170);
    freq.put("lm ", 161);
    freq.put("et", 9949);
    freq.put("ew", 3041);
    freq.put("ev", 4291);
    freq.put("eq", 153);
    freq.put("ep", 2609);
    freq.put("es", 15855);
    freq.put("er", 27479);
    freq.put("eM", 24);
    freq.put("eB", 36);
    freq.put("rlo", 76);
    freq.put("rli", 247);
    freq.put("rle", 63);
    freq.put("rld", 540);
    freq.put("lms", 30);
    freq.put("rla", 77);
    freq.put("e ", 85076);
    freq.put("lmi", 33);
    freq.put("rly", 351);
    freq.put("lmo", 120);
    freq.put("lma", 136);
    freq.put("lme", 33);
    freq.put("rls", 213);
    freq.put("hh ", 327);
    freq.put("xh", 33);
    freq.put("xi", 278);
    freq.put("xo", 167);
    freq.put("xc", 417);
    freq.put("xa", 220);
    freq.put("xf", 33);
    freq.put("xe", 224);
    freq.put("xx", 1482);
    freq.put("xy", 144);
    freq.put("zat", 23);
    freq.put("zar", 41);
    freq.put("xt", 822);
    freq.put("xu", 55);
    freq.put("fl", 652);
    freq.put("yin", 1043);
    freq.put("xD", 331);
    freq.put("x ", 1268);
    freq.put("za ", 88);
    freq.put("Of ", 161);
    freq.put("Phi", 40);
    freq.put("Pho", 329);
    freq.put("mr ", 35);
    freq.put("Off", 201);
    freq.put("Web", 105);
    freq.put("Wea", 53);
    freq.put("Wee", 81);
    freq.put("Wed", 67);
    freq.put("Wei", 35);
    freq.put("Wen", 39);
    freq.put("Wel", 294);
    freq.put("Wes", 74);
    freq.put("Wer", 24);
    freq.put(" p ", 130);
    freq.put(" ps", 37);
    freq.put(" pr", 2381);
    freq.put("We ", 578);
    freq.put(" pu", 732);
    freq.put(" pa", 1622);
    freq.put(" pe", 1839);
    freq.put(" pi", 910);
    freq.put(" ph", 531);
    freq.put(" po", 1411);
    freq.put(" pm", 128);
    freq.put(" pl", 2012);
    freq.put("yth", 484);
    freq.put("yti", 68);
    freq.put("LD ", 71);
    freq.put("EM ", 26);
    freq.put("ei ", 27);
    freq.put("eis", 34);
    freq.put("eir", 581);
    freq.put("eit", 120);
    freq.put("IL ", 40);
    freq.put("eiv", 68);
    freq.put("eic", 22);
    freq.put("eid", 24);
    freq.put("eig", 189);
    freq.put("eil", 59);
    freq.put("ein", 614);
    freq.put("ety", 58);
    freq.put("yh", 47);
    freq.put("cee", 27);
    freq.put("SD ", 67);
    freq.put("rwe", 26);
    freq.put(" Me", 688);
    freq.put(" Ma", 1708);
    freq.put(" Mc", 104);
    freq.put(" Mo", 1019);
    freq.put(" Mi", 770);
    freq.put(" Mu", 350);
    freq.put(" Mr", 93);
    freq.put("rwi", 40);
    freq.put(" My", 710);
    freq.put("yb", 492);
    freq.put("NS ", 59);
    freq.put("cei", 77);
    freq.put("ux ", 43);
    freq.put("eth", 732);
    freq.put(" M ", 141);
    freq.put("ccu", 44);
    freq.put("etn", 44);
    freq.put("cco", 212);
    freq.put("cci", 58);
    freq.put("cce", 208);
    freq.put("cca", 46);
    freq.put("am ", 1622);
    freq.put("ps ", 640);
    freq.put("ch", 8058);
    freq.put("cm", 23);
    freq.put("ami", 466);
    freq.put("psi", 25);
    freq.put("amm", 146);
    freq.put("pso", 38);
    freq.put("amo", 147);
    freq.put("amn", 152);
    freq.put("ama", 544);
    freq.put("amb", 114);
    freq.put("ame", 1720);
    freq.put("pse", 62);
    freq.put("psy", 26);
    freq.put("LY ", 141);
    freq.put("amp", 365);
    freq.put("ams", 271);
    freq.put("amu", 35);
    freq.put("pst", 39);
    freq.put("cy", 310);
    freq.put("t", 175373);
    freq.put("EP ", 38);
    freq.put("Hel", 163);
    freq.put("cq", 28);
    freq.put("Heh", 28);
    freq.put("cu", 1434);
    freq.put("ct", 3408);
    freq.put("tdo", 32);
    freq.put("nme", 94);
    freq.put("nma", 81);
    freq.put("sra", 41);
    freq.put("Adv", 48);
    freq.put("Add", 42);
    freq.put("Ade", 27);
    freq.put("Ada", 28);
    freq.put("Ado", 26);
    freq.put("Adm", 27);
    freq.put("lob", 70);
    freq.put("loc", 274);
    freq.put("loa", 334);
    freq.put("log", 524);
    freq.put("lod", 33);
    freq.put("lon", 683);
    freq.put("loo", 1445);
    freq.put("lol", 904);
    freq.put("lom", 22);
    freq.put("lor", 264);
    freq.put("los", 540);
    freq.put("lop", 125);
    freq.put("lov", 2079);
    freq.put("low", 1970);
    freq.put("lot", 460);
    freq.put("lou", 366);
    freq.put("loy", 74);
    freq.put("J", 2759);
    freq.put("lo ", 249);
    freq.put("Gen", 79);
    freq.put(" so", 6326);
    freq.put("Ess", 25);
    freq.put(" sl", 703);
    freq.put("Lam", 22);
    freq.put("Lan", 58);
    freq.put("Lad", 76);
    freq.put("Lab", 29);
    freq.put("Lat", 61);
    freq.put("Lau", 67);
    freq.put("you", 12168);
    freq.put("Law", 24);
    freq.put("yor", 40);
    freq.put("Las", 91);
    freq.put("Bru", 59);
    freq.put("yo ", 102);
    freq.put("Bro", 167);
    freq.put("Bri", 245);
    freq.put("Bre", 99);
    freq.put("Bra", 117);
    freq.put("mp ", 214);
    freq.put("mpe", 203);
    freq.put("mpa", 235);
    freq.put("mpo", 177);
    freq.put("mpl", 444);
    freq.put("mph", 40);
    freq.put("mpi", 162);
    freq.put("mpt", 108);
    freq.put("mpu", 94);
    freq.put("mpr", 109);
    freq.put("mps", 80);
    freq.put("ass", 895);
    freq.put(" r ", 153);
    freq.put(" ru", 464);
    freq.put(" rt", 31);
    freq.put(" re", 6201);
    freq.put(" rd", 50);
    freq.put(" ra", 795);
    freq.put(" ro", 750);
    freq.put(" ri", 976);
    freq.put("TS ", 86);
    freq.put("yst", 152);
    freq.put("ask", 394);
    freq.put(" Fr", 727);
    freq.put("S ", 1930);
    freq.put("asm", 40);
    freq.put("asl", 66);
    freq.put("Sy", 92);
    freq.put("LF ", 35);
    freq.put("Sq", 27);
    freq.put("Sp", 432);
    freq.put("Sw", 149);
    freq.put("Su", 667);
    freq.put("St", 1324);
    freq.put("FC ", 48);
    freq.put("Si", 508);
    freq.put("Sh", 927);
    freq.put("So", 1493);
    freq.put("Sn", 55);
    freq.put("Sm", 138);
    freq.put("Sl", 119);
    freq.put("Sc", 322);
    freq.put("Sa", 683);
    freq.put("Se", 1081);
    freq.put("RE ", 230);
    freq.put("f ", 10177);
    freq.put("hha", 37);
    freq.put("hhh", 405);
    freq.put("▸", 79);
    freq.put("eg ", 62);
    freq.put("fr", 3312);
    freq.put("fs", 74);
    freq.put("ft", 1184);
    freq.put("fu", 2271);
    freq.put("fy", 102);
    freq.put("fa", 2918);
    freq.put("fb", 55);
    freq.put("fc", 34);
    freq.put("fe", 3227);
    freq.put("ff", 2242);
    freq.put("fg", 53);
    freq.put("fi", 3300);
    freq.put("DY ", 41);
    freq.put("fm", 25);
    freq.put("fo", 9065);
    freq.put("a", 164048);
    freq.put("egs", 36);
    freq.put("egr", 85);
    freq.put("egu", 39);
    freq.put("egi", 197);
    freq.put("ego", 50);
    freq.put("egn", 30);
    freq.put("ö", 22);
    freq.put("ega", 206);
    freq.put("CA ", 31);
    freq.put("egg", 52);
    freq.put("ege", 175);
    freq.put("ce ", 3447);
    freq.put("y ", 34763);
    freq.put("ffs", 44);
    freq.put("ffo", 88);
    freq.put("ffl", 54);
    freq.put("ffi", 413);
    freq.put("ffe", 512);
    freq.put("uve", 34);
    freq.put("ffa", 32);
    freq.put(" On", 626);
    freq.put(" Oo", 76);
    freq.put(" Ol", 71);
    freq.put(" Om", 77);
    freq.put(" Ok", 146);
    freq.put(" Oh", 387);
    freq.put(" Oi", 22);
    freq.put(" Of", 361);
    freq.put(" Ob", 64);
    freq.put(" Oc", 135);
    freq.put("if ", 1462);
    freq.put(" Ov", 58);
    freq.put(" Ow", 41);
    freq.put(" Ot", 35);
    freq.put(" Ou", 174);
    freq.put(" Or", 179);
    freq.put(" Os", 36);
    freq.put(" Op", 131);
    freq.put("yi", 1078);
    freq.put("rwa", 206);
    freq.put("yk", 31);
    freq.put("ced", 208);
    freq.put("ym", 297);
    freq.put("ceb", 325);
    freq.put("yo", 13045);
    freq.put("yn", 235);
    freq.put("ya", 612);
    freq.put("cen", 342);
    freq.put("cem", 71);
    freq.put("cel", 258);
    freq.put("ye", 2746);
    freq.put("yd", 133);
    freq.put("yg", 34);
    freq.put("yf", 95);
    freq.put("yy", 337);
    freq.put("ces", 616);
    freq.put("cer", 349);
    freq.put("cep", 128);
    freq.put("uv ", 43);
    freq.put("yp", 277);
    freq.put("ys", 2351);
    freq.put("yr", 230);
    freq.put("yu", 222);
    freq.put("yt", 616);
    freq.put("yw", 244);
    freq.put("ff ", 990);
    freq.put("ift", 168);
    freq.put("ifu", 276);
    freq.put("MI ", 26);
    freq.put("yB", 25);
    freq.put("ify", 56);
    freq.put(" O ", 249);
    freq.put("kBe", 29);
    freq.put("ife", 670);
    freq.put("iff", 268);
    freq.put("ifa", 23);
    freq.put("ifo", 28);
    freq.put("ifi", 150);
    freq.put("End", 39);
    freq.put("Eng", 209);
    freq.put("Enj", 55);
    freq.put("as ", 4575);
    freq.put("Ent", 51);
    freq.put("pul", 106);
    freq.put("pun", 81);
    freq.put("asp", 35);
    freq.put("ve ", 8116);
    freq.put("asu", 92);
    freq.put("ast", 1767);
    freq.put("ios", 31);
    freq.put("asy", 127);
    freq.put("pub", 131);
    freq.put("asc", 33);
    freq.put("asa", 54);
    freq.put("ase", 1407);
    freq.put("put", 373);
    freq.put("asi", 233);
    freq.put("ash", 487);
    freq.put("aso", 326);
    freq.put("asn", 160);
    freq.put("pur", 118);
    freq.put("pus", 92);
    freq.put(" F ", 78);
    freq.put("KS ", 33);
    freq.put("Ima", 60);
    freq.put("Clo", 102);
    freq.put("Cli", 63);
    freq.put("Cle", 67);
    freq.put("Imm", 28);
    freq.put("tf ", 49);
    freq.put("Imp", 47);
    freq.put("nc ", 41);
    freq.put("Clu", 60);
    freq.put("st ", 7950);
    freq.put("Im ", 122);
    freq.put("tfo", 61);
    freq.put("tfi", 46);
    freq.put("ncr", 89);
    freq.put("nct", 40);
    freq.put("nch", 449);
    freq.put("nci", 209);
    freq.put("ncl", 110);
    freq.put("nco", 107);
    freq.put("tfu", 37);
    freq.put("nca", 51);
    freq.put("nce", 1911);
    freq.put("ste", 1943);
    freq.put("stf", 32);
    freq.put("sta", 1947);
    freq.put("stl", 174);
    freq.put("stm", 102);
    freq.put("sto", 1028);
    freq.put("sth", 37);
    freq.put("sti", 2009);
    freq.put("stu", 597);
    freq.put("str", 933);
    freq.put("sts", 272);
    freq.put("sty", 158);
    freq.put("Gol", 48);
    freq.put("Goo", 543);
    freq.put("ka ", 93);
    freq.put("Goi", 84);
    freq.put("ncy", 104);
    freq.put("God", 190);
    freq.put("Got", 141);
    freq.put("Gov", 31);
    freq.put("Gos", 30);
    freq.put("Gor", 27);
    freq.put("lid", 158);
    freq.put("Nik", 32);
    freq.put("lif", 566);
    freq.put("lig", 339);
    freq.put("Nin", 23);
    freq.put("lia", 333);
    freq.put("lib", 61);
    freq.put("lic", 540);
    freq.put("lil", 69);
    freq.put("Nic", 170);
    freq.put("lin", 1893);
    freq.put("Nia", 24);
    freq.put("Nig", 131);
    freq.put("lik", 2557);
    freq.put("lit", 812);
    freq.put("liv", 690);
    freq.put("lip", 153);
    freq.put("lis", 870);
    freq.put("liz", 92);
    freq.put("kag", 32);
    freq.put("Thu", 57);
    freq.put("Thr", 67);
    freq.put("Tho", 132);
    freq.put("kar", 28);
    freq.put("Thi", 590);
    freq.put("kat", 41);
    freq.put("rha", 55);
    freq.put("The", 2843);
    freq.put("Tha", 1110);
    freq.put("li ", 114);
    freq.put("ymp", 33);
    freq.put("yme", 37);
    freq.put("ox ", 167);
    freq.put("ymo", 140);
    freq.put("ym ", 49);
    freq.put("oxo", 63);
    freq.put("oxi", 40);
    freq.put("x", 7307);
    freq.put("Plu", 37);
    freq.put("Pls", 27);
    freq.put("wou", 900);
    freq.put("wow", 109);
    freq.put("wor", 2051);
    freq.put("wom", 165);
    freq.put("woo", 150);
    freq.put("won", 518);
    freq.put("Pla", 239);
    freq.put("Oba", 26);
    freq.put("wo ", 316);
    freq.put("Wan", 135);
    freq.put("Wal", 158);
    freq.put("Wak", 24);
    freq.put("Wai", 80);
    freq.put("Gon", 63);
    freq.put("Way", 88);
    freq.put("Wat", 228);
    freq.put("Was", 122);
    freq.put("War", 120);
    freq.put(" t ", 3953);
    freq.put(" ty", 108);
    freq.put(" tw", 1456);
    freq.put(" tv", 76);
    freq.put(" tu", 401);
    freq.put(" tr", 1900);
    freq.put("N", 4355);
    freq.put(" to", 16095);
    freq.put(" tm", 24);
    freq.put(" ti", 2037);
    freq.put(" th", 28595);
    freq.put(" te", 1390);
    freq.put(" tb", 43);
    freq.put(" ta", 1467);
    freq.put("iya", 31);
    freq.put("gs ", 987);
    freq.put("vy ", 67);
    freq.put("lie", 737);
    freq.put("FA ", 30);
    freq.put("gst", 27);
    freq.put("lim", 176);
    freq.put("ohh", 61);
    freq.put("lio", 200);
    freq.put("Xxx", 32);
    freq.put("ee ", 2045);
    freq.put("eey", 28);
    freq.put("eez", 66);
    freq.put("eet", 1703);
    freq.put("eev", 22);
    freq.put("eep", 1008);
    freq.put("ees", 180);
    freq.put("eer", 305);
    freq.put("eem", 194);
    freq.put("eel", 838);
    freq.put("een", 1337);
    freq.put("eei", 110);
    freq.put("eek", 890);
    freq.put("eee", 442);
    freq.put("eed", 1314);
    freq.put("eef", 25);
    freq.put("eec", 85);
    freq.put("ru ", 43);
    freq.put(" Qu", 190);
    freq.put("id ", 1672);
    freq.put("rui", 106);
    freq.put("run", 366);
    freq.put("rul", 96);
    freq.put("rum", 172);
    freq.put("rub", 51);
    freq.put("ruc", 90);
    freq.put("rug", 93);
    freq.put("rud", 32);
    freq.put("rue", 233);
    freq.put("rus", 254);
    freq.put("rup", 56);
    freq.put("rut", 89);
    freq.put("ids", 150);
    freq.put(" Q ", 36);
    freq.put("ido", 25);
    freq.put("idl", 23);
    freq.put("idk", 33);
    freq.put("idi", 237);
    freq.put("idf", 22);
    freq.put("idg", 83);
    freq.put("idd", 126);
    freq.put("ide", 2135);
    freq.put("ida", 343);
    freq.put("Eli", 27);
    freq.put("Ell", 27);
    freq.put("oha", 27);
    freq.put("Ele", 57);
    freq.put("kay", 243);
    freq.put("ut ", 6440);
    freq.put("utc", 53);
    freq.put("uta", 36);
    freq.put("utf", 27);
    freq.put("ute", 714);
    freq.put("uth", 325);
    freq.put("uti", 490);
    freq.put("uto", 168);
    freq.put("utl", 35);
    freq.put("utr", 34);
    freq.put("uts", 216);
    freq.put("utt", 275);
    freq.put("utu", 206);
    freq.put("uty", 80);
    freq.put("Ty", 53);
    freq.put("Tv", 26);
    freq.put("Tw", 488);
    freq.put("Tu", 357);
    freq.put("Tr", 615);
    freq.put("Ts", 23);
    freq.put("Ice", 23);
    freq.put("To", 1195);
    freq.put("oof", 55);
    freq.put("Th", 4834);
    freq.put("Ti", 411);
    freq.put("Te", 608);
    freq.put("Ta", 432);
    freq.put("nab", 56);
    freq.put("nac", 37);
    freq.put("nag", 196);
    freq.put("nad", 61);
    freq.put("nak", 48);
    freq.put("nah", 60);
    freq.put("nai", 84);
    freq.put("nan", 189);
    freq.put("nal", 921);
    freq.put("nam", 437);
    freq.put("nar", 112);
    freq.put("nas", 61);
    freq.put("nap", 80);
    freq.put("nat", 463);
    freq.put("ool", 1143);
    freq.put("oon", 574);
    freq.put("ook", 2134);
    freq.put("T ", 3666);
    freq.put("Aa", 47);
    freq.put("na ", 1391);
    freq.put("Ab", 147);
    freq.put("dvi", 68);
    freq.put("Ad", 256);
    freq.put("Ag", 91);
    freq.put("Af", 156);
    freq.put("dve", 87);
    freq.put("Ah", 153);
    freq.put("Am", 369);
    freq.put("Al", 744);
    freq.put("An", 1338);
    freq.put("Ap", 286);
    freq.put("As", 343);
    freq.put("Ar", 584);
    freq.put("Au", 243);
    freq.put("At", 209);
    freq.put("Aw", 220);
    freq.put("Av", 73);
    freq.put("gw", 39);
    freq.put("Giv", 72);
    freq.put("gu", 1384);
    freq.put("gt", 138);
    freq.put("gs", 1098);
    freq.put("Gir", 108);
    freq.put("gy", 245);
    freq.put("gg", 681);
    freq.put("gf", 26);
    freq.put("ge", 6108);
    freq.put("gd", 43);
    freq.put("gb", 72);
    freq.put("ga", 2054);
    freq.put("go", 5664);
    freq.put("gn", 700);
    freq.put("gm", 54);
    freq.put("gl", 1075);
    freq.put("gi", 2279);
    freq.put("gh", 5193);
    freq.put("Non", 23);
    freq.put("gT", 25);
    freq.put("lki", 266);
    freq.put("lke", 75);
    freq.put("Nob", 32);
    freq.put("Not", 366);
    freq.put("Nov", 63);
    freq.put("Now", 336);
    freq.put("lks", 76);
    freq.put("Nor", 117);
    freq.put("esb", 31);
    freq.put("g ", 20010);
    freq.put("hi ", 152);
    freq.put("Spr", 35);
    freq.put("No ", 416);
    freq.put("lk ", 396);
    freq.put("Spi", 46);
    freq.put("Spo", 83);
    freq.put("Spa", 89);
    freq.put("Spe", 146);
    freq.put("zl", 23);
    freq.put("zo", 126);
    freq.put("zi", 574);
    freq.put("oz ", 55);
    freq.put("ze", 446);
    freq.put("za", 215);
    freq.put("zy", 249);
    freq.put("zz", 263);
    freq.put("zu", 23);
    freq.put("Ah ", 61);
    freq.put("ych", 29);
    freq.put("ycl", 70);
    freq.put("Lma", 31);
    freq.put("oze", 25);
    freq.put("ull", 457);
    freq.put("z ", 598);
    freq.put("Ahh", 51);
    freq.put("wif", 95);
    freq.put("wid", 75);
    freq.put("wic", 79);
    freq.put("win", 1007);
    freq.put("wim", 41);
    freq.put("wil", 1519);
    freq.put("IA ", 32);
    freq.put("wit", 3755);
    freq.put("wis", 416);
    freq.put("wir", 33);
    freq.put("Ji", 65);
    freq.put("ied", 370);
    freq.put("Mr ", 74);
    freq.put(" va", 171);
    freq.put(" ve", 1390);
    freq.put(" vi", 1885);
    freq.put(" vo", 345);
    freq.put(" vs", 71);
    freq.put(" v ", 76);
    freq.put("TO ", 204);
    freq.put("RA ", 28);
    freq.put("FG ", 23);
    freq.put("Use", 63);
    freq.put("hly", 41);
    freq.put("ec ", 54);
    freq.put("mar", 514);
    freq.put("hli", 22);
    freq.put("hle", 60);
    freq.put("max", 22);
    freq.put("ece", 306);
    freq.put("ecc", 26);
    freq.put("eca", 591);
    freq.put("CE ", 89);
    freq.put("eco", 588);
    freq.put("ecl", 25);
    freq.put("eck", 695);
    freq.put("eci", 470);
    freq.put("ech", 289);
    freq.put("ecu", 175);
    freq.put("ect", 1281);
    freq.put("ecr", 169);
    freq.put("oxe", 38);
    freq.put("ecy", 22);
    freq.put("mac", 105);
    freq.put("IF ", 50);
    freq.put("rs ", 3209);
    freq.put("cy ", 213);
    freq.put("AN ", 154);
    freq.put(" Sy", 90);
    freq.put("be ", 3434);
    freq.put(" Sq", 26);
    freq.put(" Sw", 147);
    freq.put(" St", 1290);
    freq.put(" Su", 659);
    freq.put(" Sk", 103);
    freq.put(" Sh", 911);
    freq.put(" Si", 498);
    freq.put(" Sn", 54);
    freq.put(" So", 1482);
    freq.put(" Sl", 119);
    freq.put(" Sm", 135);
    freq.put(" Sc", 307);
    freq.put(" Sa", 677);
    freq.put(" Se", 1065);
    freq.put("rso", 352);
    freq.put("rsh", 86);
    freq.put("rsi", 177);
    freq.put("rsd", 54);
    freq.put("rse", 683);
    freq.put("rsa", 107);
    freq.put("rsc", 22);
    freq.put("cyc", 59);
    freq.put("R", 5408);
    freq.put("rst", 847);
    freq.put("beh", 106);
    freq.put("bei", 391);
    freq.put("ben", 69);
    freq.put("bel", 434);
    freq.put("bec", 612);
    freq.put("bea", 516);
    freq.put("bef", 324);
    freq.put("beg", 105);
    freq.put("bed", 421);
    freq.put("bee", 694);
    freq.put("bey", 52);
    freq.put("ber", 1299);
    freq.put("bes", 577);
    freq.put(" S ", 310);
    freq.put("bet", 663);
    freq.put("py ", 687);
    freq.put("aw ", 366);
    freq.put("ur ", 3999);
    freq.put("uu ", 39);
    freq.put("Dep", 36);
    freq.put("aww", 174);
    freq.put("aws", 54);
    freq.put("awn", 55);
    freq.put("awl", 33);
    freq.put("awk", 134);
    freq.put("Dev", 81);
    freq.put("awi", 27);
    freq.put("awh", 31);
    freq.put("awf", 34);
    freq.put("awe", 299);
    freq.put("awa", 430);
    freq.put("urd", 143);
    freq.put("ure", 1460);
    freq.put("urf", 44);
    freq.put("urg", 135);
    freq.put("ura", 227);
    freq.put("urb", 43);
    freq.put("urc", 125);
    freq.put("url", 41);
    freq.put("urn", 474);
    freq.put("uro", 185);
    freq.put("uri", 359);
    freq.put("urk", 58);
    freq.put("urt", 298);
    freq.put("uru", 25);
    freq.put("urv", 61);
    freq.put("urp", 142);
    freq.put("urr", 276);
    freq.put("urs", 826);
    freq.put("Del", 65);
    freq.put("ury", 82);
    freq.put("mg ", 197);
    freq.put("Den", 80);
    freq.put("buc", 33);
    freq.put("ngd", 24);
    freq.put("nge", 1037);
    freq.put("ngg", 23);
    freq.put("nga", 78);
    freq.put("ngl", 447);
    freq.put("ngo", 84);
    freq.put("ngh", 66);
    freq.put("Ple", 253);
    freq.put("Dee", 34);
    freq.put("ngt", 110);
    freq.put("ngu", 104);
    freq.put("bud", 41);
    freq.put("ngr", 241);
    freq.put("ngs", 805);
    freq.put("wok", 49);
    freq.put("tbh", 35);
    freq.put("tbo", 25);
    freq.put("tba", 136);
    freq.put("shr", 24);
    freq.put("sht", 27);
    freq.put("shu", 84);
    freq.put("shy", 38);
    freq.put("Ps ", 32);
    freq.put("sha", 498);
    freq.put("she", 1162);
    freq.put("shi", 1070);
    freq.put("shl", 33);
    freq.put("shm", 27);
    freq.put("sho", 1902);
    freq.put("ke ", 4136);
    freq.put("lur", 38);
    freq.put("lus", 161);
    freq.put("lut", 238);
    freq.put("luv", 37);
    freq.put("lub", 125);
    freq.put("luc", 204);
    freq.put("lud", 68);
    freq.put("lue", 192);
    freq.put("lug", 45);
    freq.put("lum", 73);
    freq.put("lun", 91);
    freq.put("ken", 461);
    freq.put("kel", 82);
    freq.put("t´s", 43);
    freq.put("kee", 304);
    freq.put("ked", 1013);
    freq.put("key", 180);
    freq.put("ket", 454);
    freq.put("kes", 521);
    freq.put("ker", 399);
    freq.put("Loc", 67);
    freq.put("Loa", 24);
    freq.put("Log", 31);
    freq.put("ot ", 4032);
    freq.put("Lon", 243);
    freq.put("Loo", 274);
    freq.put("Lol", 204);
    freq.put("Lor", 47);
    freq.put("Los", 59);
    freq.put("Lov", 464);
    freq.put("Low", 31);
    freq.put("Lot", 36);
    freq.put("Lou", 60);
    freq.put("iny", 61);
    freq.put("yay", 57);
    freq.put("yal", 63);
    freq.put("yan", 104);
    freq.put("yah", 31);
    freq.put("oth", 1581);
    freq.put("oti", 388);
    freq.put("otl", 36);
    freq.put("oto", 530);
    freq.put("ota", 225);
    freq.put("otb", 105);
    freq.put("otc", 23);
    freq.put("ote", 614);
    freq.put("oty", 25);
    freq.put("ots", 254);
    freq.put("ott", 498);
    freq.put("And", 720);
    freq.put("Ang", 80);
    freq.put("Ana", 47);
    freq.put("Ann", 74);
    freq.put("Ano", 80);
    freq.put("Ant", 54);
    freq.put("ya ", 240);
    freq.put("Yoo", 25);
    freq.put("You", 1670);
    freq.put("Yor", 77);
    freq.put("wkw", 133);
    freq.put("zy ", 228);
    freq.put("i", 138827);
    freq.put(" xD", 331);
    freq.put("Be", 1173);
    freq.put(" xo", 75);
    freq.put("Ba", 826);
    freq.put("Bl", 498);
    freq.put("Bo", 575);
    freq.put("Bi", 559);
    freq.put("´s ", 69);
    freq.put("Bu", 786);
    freq.put(" xx", 668);
    freq.put("Br", 703);
    freq.put("By", 93);
    freq.put("NN ", 23);
    freq.put("B ", 377);
    freq.put(" x ", 256);
    freq.put("GS ", 31);
    freq.put("Acc", 72);
    freq.put("U ", 683);
    freq.put("swi", 86);
    freq.put("RO ", 25);
    freq.put("Up", 179);
    freq.put("Us", 115);
    freq.put("Ur", 58);
    freq.put("Um", 30);
    freq.put("Ul", 26);
    freq.put("Un", 326);
    freq.put("Uh", 27);
    freq.put("Ug", 36);
    freq.put("LL ", 237);
    freq.put("swo", 40);
    freq.put("EE ", 113);
    freq.put("duc", 274);
    freq.put("swe", 466);
    freq.put("h ", 13044);
    freq.put("dm ", 31);
    freq.put("FE ", 25);
    freq.put("eah", 632);
    freq.put("eak", 622);
    freq.put("hy", 1230);
    freq.put("eam", 712);
    freq.put("eal", 1840);
    freq.put("ean", 782);
    freq.put("eaa", 27);
    freq.put("hs", 238);
    freq.put("eac", 448);
    freq.put("eab", 25);
    freq.put("ead", 1951);
    freq.put("eag", 60);
    freq.put("eaf", 22);
    freq.put("hj", 28);
    freq.put("hh", 814);
    freq.put("hi", 11415);
    freq.put("PM ", 38);
    freq.put("ho", 10259);
    freq.put("hl", 185);
    freq.put("hm", 191);
    freq.put("hb", 70);
    freq.put("eap", 66);
    freq.put("eas", 1880);
    freq.put("ear", 2928);
    freq.put("eau", 348);
    freq.put("ph", 1029);
    freq.put("eaw", 30);
    freq.put("eav", 286);
    freq.put("dma", 36);
    freq.put("dus", 39);
    freq.put("dmi", 100);
    freq.put("hP", 40);
    freq.put("dmo", 28);
    freq.put("te", 15057);
    freq.put("ID ", 68);
    freq.put("hn ", 133);
    freq.put(" Up", 172);
    freq.put(" Ur", 56);
    freq.put(" Us", 114);
    freq.put(" Ul", 26);
    freq.put(" Um", 30);
    freq.put(" Un", 325);
    freq.put(" Uh", 27);
    freq.put(" Ug", 35);
    freq.put("hni", 38);
    freq.put("hno", 50);
    freq.put(" U ", 291);
    freq.put("MS ", 38);
    freq.put("auc", 41);
    freq.put("aud", 63);
    freq.put("aug", 323);
    freq.put("Job", 128);
    freq.put("up ", 1775);
    freq.put("aun", 155);
    freq.put("aus", 844);
    freq.put("aur", 85);
    freq.put("aut", 452);
    freq.put("Joh", 135);
    freq.put("upo", 55);
    freq.put("upl", 157);
    freq.put("upi", 146);
    freq.put("upd", 140);
    freq.put("upe", 227);
    freq.put("upc", 30);
    freq.put("upa", 24);
    freq.put("upt", 48);
    freq.put("ups", 97);
    freq.put("upp", 350);
    freq.put("me ", 8598);
    freq.put("nen", 47);
    freq.put("Pun", 22);
    freq.put("nem", 114);
    freq.put("nei", 63);
    freq.put("nef", 27);
    freq.put("neg", 48);
    freq.put("ned", 572);
    freq.put("nee", 965);
    freq.put("nec", 171);
    freq.put("Pub", 30);
    freq.put("nea", 166);
    freq.put("nex", 409);
    freq.put("ney", 427);
    freq.put("Put", 22);
    freq.put("new", 1290);
    freq.put("net", 324);
    freq.put("neu", 22);
    freq.put("ner", 701);
    freq.put("nes", 1164);
    freq.put("mee", 314);
    freq.put("med", 395);
    freq.put("mea", 496);
    freq.put("meb", 72);
    freq.put("mem", 370);
    freq.put("mel", 209);
    freq.put("meo", 469);
    freq.put("men", 1474);
    freq.put("meh", 38);
    freq.put("met", 806);
    freq.put("mew", 115);
    freq.put("mep", 22);
    freq.put("mes", 992);
    freq.put("mer", 631);
    freq.put("mez", 23);
    freq.put("dry", 38);
    freq.put("dru", 113);
    freq.put("ne ", 5009);
    freq.put("dri", 340);
    freq.put("dro", 203);
    freq.put("dra", 187);
    freq.put("dre", 484);
    freq.put("St ", 49);
    freq.put("riv", 325);
    freq.put("lwa", 533);
    freq.put("Ste", 224);
    freq.put("kgr", 29);
    freq.put("Sta", 399);
    freq.put("Sto", 206);
    freq.put("Sti", 102);
    freq.put("Stu", 125);
    freq.put("Str", 186);
    freq.put("V", 1302);
    freq.put("Sty", 32);
    freq.put("dyi", 50);
    freq.put("rio", 421);
    freq.put("´t", 41);
    freq.put("´s", 69);
    freq.put("´m", 28);
    freq.put("Lif", 102);
    freq.put("Lig", 59);
    freq.put("Lib", 95);
    freq.put("Lil", 49);
    freq.put("Lim", 25);
    freq.put("Lin", 106);
    freq.put("Lio", 29);
    freq.put("Lik", 130);
    freq.put("Lit", 53);
    freq.put("ov ", 43);
    freq.put("Lis", 109);
    freq.put("Al ", 34);
    freq.put("Kar", 36);
    freq.put("Kat", 69);
    freq.put("ova", 95);
    freq.put("ove", 3820);
    freq.put("ovi", 414);
    freq.put("Alo", 25);
    freq.put("All", 257);
    freq.put("Alm", 30);
    freq.put("Ali", 54);
    freq.put("Ale", 58);
    freq.put("Alb", 33);
    freq.put("Ala", 27);
    freq.put("Alw", 39);
    freq.put("Alt", 31);
    freq.put("Alr", 42);
    freq.put("Als", 57);
    freq.put("ona", 619);
    freq.put("PR ", 25);
    freq.put(" Z ", 29);
    freq.put("Wou", 72);
    freq.put("Wow", 82);
    freq.put("Wor", 312);
    freq.put("Wom", 46);
    freq.put("Woo", 73);
    freq.put("Won", 49);
    freq.put("SS ", 101);
    freq.put(" zo", 37);
    freq.put("´m ", 28);
    freq.put("is ", 9647);
    freq.put("iss", 913);
    freq.put("isr", 22);
    freq.put("isp", 60);
    freq.put("isu", 34);
    freq.put("ist", 1723);
    freq.put("isk", 51);
    freq.put("isi", 436);
    freq.put("ish", 1206);
    freq.put("iso", 239);
    freq.put("isn", 204);
    freq.put("ism", 93);
    freq.put("isl", 54);
    freq.put("isc", 199);
    freq.put("isa", 142);
    freq.put("isg", 36);
    freq.put("ise", 620);
    freq.put("Eur", 130);
    freq.put("gy ", 162);
    freq.put("eu", 278);
    freq.put("BB ", 35);
    freq.put("Coo", 103);
    freq.put("gym", 34);
    freq.put("RM ", 24);
    freq.put("ty ", 1807);
    freq.put("do ", 1581);
    freq.put("tyl", 131);
    freq.put("typ", 107);
    freq.put("tyr", 23);
    freq.put("doi", 323);
    freq.put("don", 2147);
    freq.put("doo", 115);
    freq.put("dol", 72);
    freq.put("dom", 196);
    freq.put("doc", 83);
    freq.put("m", 56873);
    freq.put("dog", 99);
    freq.put("doe", 508);
    freq.put("dor", 108);
    freq.put("dos", 44);
    freq.put("dop", 37);
    freq.put("dow", 702);
    freq.put("dou", 107);
    freq.put(" We", 1370);
    freq.put(" Wa", 982);
    freq.put(" Wo", 678);
    freq.put(" Wh", 1755);
    freq.put(" Wi", 844);
    freq.put(" Wr", 68);
    freq.put("ba ", 86);
    freq.put(" W ", 57);
    freq.put("bat", 160);
    freq.put("bar", 199);
    freq.put("bas", 231);
    freq.put("bay", 27);
    freq.put("bag", 91);
    freq.put("bad", 339);
    freq.put("bab", 470);
    freq.put("bac", 1141);
    freq.put("ban", 324);
    freq.put("bal", 314);
    freq.put("bam", 36);
    freq.put("bak", 33);
    freq.put("om ", 2591);
    freq.put("Eff", 23);
    freq.put("Run", 46);
    freq.put("un ", 686);
    freq.put("Rus", 49);
    freq.put("omb", 133);
    freq.put("C", 6508);
    freq.put("omg", 156);
    freq.put("omf", 44);
    freq.put("ome", 4565);
    freq.put("omi", 518);
    freq.put("omo", 672);
    freq.put("omm", 419);
    freq.put("oml", 23);
    freq.put("oms", 65);
    freq.put("omp", 563);
    freq.put("omy", 45);
    freq.put("unr", 32);
    freq.put("uns", 129);
    freq.put("unt", 715);
    freq.put("una", 91);
    freq.put("unb", 33);
    freq.put("unc", 461);
    freq.put("und", 1645);
    freq.put("une", 202);
    freq.put("unf", 89);
    freq.put("ung", 418);
    freq.put("unh", 29);
    freq.put("uni", 372);
    freq.put("unk", 149);
    freq.put("unl", 86);
    freq.put("unn", 545);
    freq.put("uno", 45);
    freq.put("C ", 681);
    freq.put("Ci", 187);
    freq.put("Ch", 1185);
    freq.put("Co", 1625);
    freq.put("sly", 235);
    freq.put("Cl", 369);
    freq.put("slu", 22);
    freq.put("Ca", 1321);
    freq.put("Ce", 151);
    freq.put("Cz", 29);
    freq.put("Cy", 49);
    freq.put("slo", 131);
    freq.put("sli", 152);
    freq.put("sle", 526);
    freq.put("sla", 172);
    freq.put("Cu", 230);
    freq.put("iy", 45);
    freq.put("ix", 424);
    freq.put("iz", 495);
    freq.put("iq", 70);
    freq.put("ip", 1112);
    freq.put("is", 15826);
    freq.put("ir", 4684);
    freq.put("Nan", 24);
    freq.put("it", 18099);
    freq.put("iw", 29);
    freq.put("iv", 2981);
    freq.put("ii", 251);
    freq.put("ih", 72);
    freq.put("ik", 3032);
    freq.put("ij", 52);
    freq.put("im", 4354);
    freq.put("il", 7524);
    freq.put("Nat", 107);
    freq.put("in", 38768);
    freq.put("ia", 3377);
    freq.put("ic", 7119);
    freq.put("ib", 799);
    freq.put("ie", 5262);
    freq.put("id", 5344);
    freq.put("ig", 4970);
    freq.put("if", 3110);
    freq.put("V ", 346);
    freq.put("iP", 202);
    freq.put("iT", 45);
    freq.put("iO", 40);
    freq.put("kis", 122);
    freq.put("kip", 27);
    freq.put("kit", 77);
    freq.put("kin", 2589);
    freq.put("kil", 274);
    freq.put("kic", 70);
    freq.put("i ", 5288);
    freq.put("kia", 23);
    freq.put("kie", 93);
    freq.put("kid", 188);
    freq.put("Va", 114);
    freq.put("Ve", 191);
    freq.put("Vi", 546);
    freq.put("Vo", 95);
    freq.put("nk ", 2053);
    freq.put("yel", 54);
    freq.put("yeo", 24);
    freq.put("yea", 1024);
    freq.put("yee", 39);
    freq.put("yed", 208);
    freq.put("op ", 1011);
    freq.put("yep", 53);
    freq.put("yes", 579);
    freq.put("yer", 234);
    freq.put("yet", 231);
    freq.put("eur", 61);
    freq.put("opt", 72);
    freq.put("opu", 61);
    freq.put("opp", 283);
    freq.put("opr", 22);
    freq.put("ops", 137);
    freq.put("ye ", 229);
    freq.put("opy", 67);
    freq.put("ope", 1250);
    freq.put("opa", 28);
    freq.put("opl", 969);
    freq.put("opm", 24);
    freq.put("opo", 41);
    freq.put("oph", 58);
    freq.put("opi", 190);
    freq.put("Arr", 25);
    freq.put("Ars", 76);
    freq.put("Art", 107);
    freq.put("Arc", 43);
    freq.put("Are", 173);
    freq.put("Arg", 30);
    freq.put("Ari", 48);
    freq.put("Arm", 23);
    freq.put("www", 383);
    freq.put("bri", 397);
    freq.put("bra", 314);
    freq.put("ww ", 385);
    freq.put("TE ", 98);
    freq.put("Z", 257);
    freq.put("iqu", 64);
    freq.put("fs ", 52);
    freq.put("HO ", 26);
    freq.put("nki", 288);
    freq.put("RK ", 27);
    freq.put("Win", 242);
    freq.put("Wil", 218);
    freq.put("Wit", 179);
    freq.put("Wis", 94);
    freq.put("Wir", 28);
    freq.put("di ", 72);
    freq.put("dil", 24);
    freq.put("din", 1165);
    freq.put("dio", 272);
    freq.put("did", 876);
    freq.put("die", 434);
    freq.put("dif", 194);
    freq.put("dig", 64);
    freq.put("dia", 330);
    freq.put("dib", 56);
    freq.put("dic", 263);
    freq.put("dit", 331);
    freq.put("diu", 28);
    freq.put("div", 63);
    freq.put("dir", 143);
    freq.put("dis", 525);
    freq.put(" Yo", 1813);
    freq.put(" Ya", 100);
    freq.put(" Ye", 569);
    freq.put("Gre", 287);
    freq.put("Gra", 121);
    freq.put("Gro", 91);
    freq.put(" Yu", 78);
    freq.put("Gri", 23);
    freq.put("tne", 137);
    freq.put("AM ", 105);
    freq.put("bo ", 55);
    freq.put("tna", 43);
    freq.put("DS ", 56);
    freq.put(" Y ", 61);
    freq.put("box", 142);
    freq.put("boy", 336);
    freq.put("hbo", 52);
    freq.put("bor", 319);
    freq.put("bos", 51);
    freq.put("bot", 309);
    freq.put("bou", 1598);
    freq.put("bov", 25);
    freq.put("bow", 44);
    freq.put("HA ", 44);
    freq.put("bol", 39);
    freq.put("bom", 45);
    freq.put("bon", 74);
    freq.put("boo", 732);
    freq.put("boa", 97);
    freq.put("bod", 330);
    freq.put("oo ", 1630);
    freq.put("Be ", 123);
    freq.put("ayl", 93);
    freq.put("ayo", 78);
    freq.put("ayn", 69);
    freq.put("ayi", 507);
    freq.put("aye", 312);
    freq.put("aya", 33);
    freq.put("ayb", 296);
    freq.put("ayy", 37);
    freq.put("ul ", 689);
    freq.put("ays", 1285);
    freq.put("ood", 2256);
    freq.put("oog", 219);
    freq.put("Bei", 50);
    freq.put("Ben", 77);
    freq.put("Bel", 115);
    freq.put("oob", 45);
    freq.put("oom", 270);
    freq.put("Bec", 92);
    freq.put("ooo", 1368);
    freq.put("Bea", 155);
    freq.put("Bef", 26);
    freq.put("ooh", 85);
    freq.put("Bed", 22);
    freq.put("Bee", 74);
    freq.put("oot", 411);
    freq.put("oow", 31);
    freq.put("Bey", 39);
    freq.put("oop", 130);
    freq.put("oos", 150);
    freq.put("oor", 271);
    freq.put("Ber", 130);
    freq.put("Bes", 144);
    freq.put("Bet", 81);
    freq.put("fly", 104);
    freq.put("uly", 54);
    freq.put("uls", 28);
    freq.put("flu", 53);
    freq.put("ay ", 6592);
    freq.put("ult", 363);
    freq.put("fli", 142);
    freq.put("uli", 54);
    freq.put("ulo", 71);
    freq.put("flo", 118);
    freq.put("fla", 143);
    freq.put("ula", 215);
    freq.put("fle", 69);
    freq.put("uld", 2330);
    freq.put("ule", 106);
    freq.put("Ur ", 26);
    freq.put("sn ", 549);
    freq.put("ma ", 368);
    freq.put("idn", 391);
    freq.put("nyw", 144);
    freq.put("nyt", 240);
    freq.put("nyo", 228);
    freq.put("nym", 124);
    freq.put("nyb", 40);
    freq.put("nya", 26);
    freq.put("map", 34);
    freq.put("mas", 285);
    freq.put("sne", 68);
    freq.put("mat", 634);
    freq.put("sna", 50);
    freq.put("may", 382);
    freq.put("sno", 44);
    freq.put("maz", 405);
    freq.put("sni", 26);
    freq.put("snt", 82);
    freq.put("mad", 446);
    freq.put("mag", 278);
    freq.put("mai", 335);
    freq.put("mak", 1003);
    freq.put("maj", 40);
    freq.put("mam", 34);
    freq.put("mal", 410);
    freq.put("mao", 139);
    freq.put("man", 1732);
    freq.put("Edi", 61);
    freq.put("q", 1070);
    freq.put("Edw", 34);
    freq.put("ny ", 1545);
    freq.put("lse", 263);
    freq.put("lso", 310);
    freq.put("lsh", 50);
    freq.put("lst", 43);
    freq.put("kk ", 30);
    freq.put(" aa", 46);
    freq.put(" ab", 1666);
    freq.put(" ac", 946);
    freq.put(" ad", 565);
    freq.put(" af", 575);
    freq.put(" ag", 953);
    freq.put(" ah", 251);
    freq.put(" ai", 254);
    freq.put(" ak", 24);
    freq.put(" al", 3540);
    freq.put(" am", 1215);
    freq.put(" an", 9912);
    freq.put(" ap", 494);
    freq.put(" ar", 3251);
    freq.put(" as", 1901);
    freq.put(" at", 2733);
    freq.put(" au", 197);
    freq.put(" av", 180);
    freq.put(" aw", 1025);
    freq.put("Shu", 24);
    freq.put("ls ", 1225);
    freq.put("Sha", 202);
    freq.put("She", 299);
    freq.put("kkk", 41);
    freq.put("Shi", 91);
    freq.put("Sho", 283);
    freq.put(" a ", 9744);
    freq.put("Luc", 69);
    freq.put("or ", 7537);
    freq.put("Ken", 82);
    freq.put("Kee", 67);
    freq.put("RT ", 1837);
    freq.put("G", 4557);
    freq.put("ory", 356);
    freq.put("orw", 181);
    freq.put("ort", 1429);
    freq.put("oru", 54);
    freq.put("orr", 1212);
    freq.put("ors", 389);
    freq.put("orp", 54);
    freq.put("orn", 672);
    freq.put("oro", 109);
    freq.put("orl", 557);
    freq.put("orm", 580);
    freq.put("ork", 1210);
    freq.put("ori", 767);
    freq.put("org", 494);
    freq.put("ord", 876);
    freq.put("ore", 2316);
    freq.put("orb", 32);
    freq.put("orc", 148);
    freq.put("ora", 209);
    freq.put("App", 237);
    freq.put("Yay", 37);
    freq.put("Oth", 24);
    freq.put("law", 110);
    freq.put("IS ", 274);
    freq.put("Do", 1044);
    freq.put("Di", 590);
    freq.put("De", 964);
    freq.put("Da", 872);
    freq.put("Dy", 27);
    freq.put("Du", 187);
    freq.put("Dr", 285);
    freq.put("SW ", 25);
    freq.put("D ", 2120);
    freq.put("ge ", 1527);
    freq.put("We", 1385);
    freq.put("Wa", 997);
    freq.put("Wo", 693);
    freq.put("Wi", 861);
    freq.put("Wh", 1756);
    freq.put("Wr", 69);
    freq.put("ges", 445);
    freq.put("ger", 774);
    freq.put("get", 2277);
    freq.put("gea", 23);
    freq.put("gee", 28);
    freq.put("ged", 276);
    freq.put("geo", 107);
    freq.put("gen", 381);
    freq.put("gem", 58);
    freq.put("gel", 94);
    freq.put("W ", 530);
    freq.put("j ", 68);
    freq.put("ain", 1914);
    freq.put("dk ", 50);
    freq.put("CH ", 76);
    freq.put("tup", 166);
    freq.put("ju", 2491);
    freq.put("tur", 1230);
    freq.put("tus", 57);
    freq.put("tut", 57);
    freq.put("js", 38);
    freq.put("jo", 884);
    freq.put("tul", 49);
    freq.put("ji", 79);
    freq.put("tun", 187);
    freq.put("jk", 23);
    freq.put("je", 387);
    freq.put("tub", 103);
    freq.put("tuc", 57);
    freq.put("tud", 254);
    freq.put("ja", 280);
    freq.put("tuf", 215);
    freq.put("tum", 116);
    freq.put("tua", 414);
    freq.put("cqu", 28);
    freq.put("bmi", 24);
    freq.put("hda", 315);
    freq.put("oi ", 50);
    freq.put("pap", 88);
    freq.put("par", 892);
    freq.put("pas", 251);
    freq.put("pat", 156);
    freq.put("pay", 114);
    freq.put("pac", 249);
    freq.put("pad", 29);
    freq.put("pag", 177);
    freq.put("pai", 272);
    freq.put("pal", 64);
    freq.put("pam", 55);
    freq.put("pan", 315);
    freq.put("oin", 1618);
    freq.put("oil", 81);
    freq.put("A ", 1517);
    freq.put("oid", 96);
    freq.put("oic", 187);
    freq.put("ois", 68);
    freq.put("pa ", 78);
    freq.put("Up ", 98);
    freq.put("mo ", 130);
    freq.put("mos", 428);
    freq.put("mor", 2067);
    freq.put("Upd", 48);
    freq.put("nau", 27);
    freq.put("mov", 413);
    freq.put("mou", 230);
    freq.put("mot", 273);
    freq.put("mok", 45);
    freq.put("moo", 111);
    freq.put("mon", 666);
    freq.put("mom", 319);
    freq.put("moc", 28);
    freq.put("mob", 63);
    freq.put("mod", 101);
    freq.put("Nei", 23);
    freq.put("Nee", 106);
    freq.put("Nex", 58);
    freq.put("Nev", 118);
    freq.put("Dr ", 22);
    freq.put("Net", 77);
    freq.put("Mee", 45);
    freq.put("Med", 107);
    freq.put("Meg", 22);
    freq.put(" ci", 198);
    freq.put("Mea", 37);
    freq.put(" co", 5628);
    freq.put(" cl", 979);
    freq.put("Mem", 29);
    freq.put(" cc", 30);
    freq.put("Men", 55);
    freq.put(" ce", 275);
    freq.put("Met", 66);
    freq.put(" cy", 45);
    freq.put("Mer", 59);
    freq.put(" cr", 1011);
    freq.put("Mex", 23);
    freq.put(" cu", 780);
    freq.put("Dru", 36);
    freq.put("Dri", 54);
    freq.put("Dro", 30);
    freq.put("Dra", 63);
    freq.put("Dre", 72);
    freq.put("Me ", 175);
    freq.put("km ", 47);
    freq.put(" c ", 123);
    freq.put("VD ", 46);
    freq.put("yyy", 201);
    freq.put("Ac", 218);
    freq.put("yy ", 113);
    freq.put("e", 238051);
    freq.put("Ai", 130);
    freq.put("Ave", 24);
    freq.put("dva", 42);
    freq.put("Ove", 57);
    freq.put("US ", 164);
    freq.put("u", 69034);
    freq.put("Van", 31);
    freq.put("Val", 37);
    freq.put("gr", 2005);
    freq.put("hy ", 1028);
    freq.put("ws ", 778);
    freq.put("DJ ", 49);
    freq.put("ium", 77);
    freq.put("edn", 57);
    freq.put("ius", 60);
    freq.put("wse", 22);
    freq.put("hyp", 32);
    freq.put("hys", 52);
    freq.put("hyu", 46);
    freq.put("gg ", 55);
    freq.put("aba", 75);
    freq.put("abb", 64);
    freq.put("abe", 166);
    freq.put("abi", 138);
    freq.put("abl", 774);
    freq.put("abo", 1412);
    freq.put("abr", 39);
    freq.put("abs", 118);
    freq.put("abt", 27);
    freq.put("abu", 65);
    freq.put("aby", 237);
    freq.put("ggs", 28);
    freq.put("K", 1430);
    freq.put("gge", 281);
    freq.put("ggg", 49);
    freq.put("Noo", 24);
    freq.put("gga", 45);
    freq.put("ggl", 70);
    freq.put("ggi", 103);
    freq.put("ab ", 119);
    freq.put("twa", 78);
    freq.put("eye", 264);
    freq.put("twe", 981);
    freq.put("twi", 452);
    freq.put("two", 360);
    freq.put("eyo", 94);
    freq.put("eys", 61);
    freq.put("de ", 1495);
    freq.put("OU ", 284);
    freq.put("ey ", 2840);
    freq.put("tw ", 92);
    freq.put("dep", 137);
    freq.put("der", 1438);
    freq.put("des", 605);
    freq.put("det", 78);
    freq.put("dev", 124);
    freq.put("del", 246);
    freq.put("dem", 138);
    freq.put("den", 563);
    freq.put("deo", 890);
    freq.put("dea", 596);
    freq.put("deb", 78);
    freq.put("dec", 189);
    freq.put("ded", 518);
    freq.put("dee", 106);
    freq.put("def", 218);
    freq.put("Do ", 238);
    freq.put("X ", 192);
    freq.put("ryn", 28);
    freq.put("ryo", 354);
    freq.put("ryl", 32);
    freq.put("iPa", 69);
    freq.put("ryi", 252);
    freq.put("ryd", 54);
    freq.put("ryb", 77);
    freq.put("iPo", 22);
    freq.put("ryw", 38);
    freq.put("ryt", 293);
    freq.put("Typ", 23);
    freq.put("rys", 53);
    freq.put("Don", 395);
    freq.put("Dol", 27);
    freq.put("Dom", 35);
    freq.put("Doc", 39);
    freq.put("Dog", 29);
    freq.put("Doe", 56);
    freq.put("Dor", 28);
    freq.put("Dow", 101);
    freq.put("Dou", 28);
    freq.put("cs ", 342);
    freq.put("ry ", 3172);
    freq.put("uh ", 67);
    freq.put("ok ", 1441);
    freq.put("AY ", 179);
    freq.put("pco", 30);
    freq.put("Bat", 79);
    freq.put("Bar", 178);
    freq.put("Bas", 45);
    freq.put("Bay", 30);
    freq.put("oka", 192);
    freq.put("Bad", 64);
    freq.put("Bab", 68);
    freq.put("Bac", 130);
    freq.put("oki", 474);
    freq.put("Bal", 54);
    freq.put("mm ", 265);
    freq.put("Omg", 55);
    freq.put("E ", 2537);
    freq.put("mmy", 89);
    freq.put("sbu", 32);
    freq.put("mmu", 90);
    freq.put("mmm", 184);
    freq.put("mmo", 78);
    freq.put("sba", 28);
    freq.put("mmi", 128);
    freq.put("Unf", 24);
    freq.put("mme", 446);
    freq.put("Uni", 140);
    freq.put("sbi", 26);
    freq.put("Unl", 22);
    freq.put("Em", 117);
    freq.put("El", 155);
    freq.put("En", 419);
    freq.put("Ei", 32);
    freq.put("Ed", 158);
    freq.put("Eg", 28);
    freq.put("Ef", 29);
    freq.put("Ea", 178);
    freq.put("Ec", 48);
    freq.put("Ey", 38);
    freq.put("Ex", 315);
    freq.put("Eu", 161);
    freq.put("Et", 25);
    freq.put("Ev", 389);
    freq.put("Ep", 60);
    freq.put("Es", 91);
    freq.put("Er", 94);
    freq.put("McC", 26);
    freq.put("tow", 123);
    freq.put(" el", 308);
    freq.put(" em", 350);
    freq.put(" en", 1038);
    freq.put(" eh", 42);
    freq.put(" ei", 93);
    freq.put("kon", 34);
    freq.put(" ed", 128);
    freq.put(" ee", 27);
    freq.put(" ef", 77);
    freq.put(" eg", 32);
    freq.put(" ea", 821);
    freq.put(" ec", 65);
    freq.put(" ex", 1121);
    freq.put(" ey", 251);
    freq.put(" et", 77);
    freq.put(" eu", 45);
    freq.put(" ev", 2083);
    freq.put(" ep", 157);
    freq.put(" eq", 34);
    freq.put(" er", 98);
    freq.put(" es", 140);
    freq.put("Own", 27);
    freq.put("Sle", 49);
    freq.put("Sla", 22);
    freq.put("b", 32313);
    freq.put("ko ", 23);
    freq.put(" e ", 81);
    freq.put("Xx", 86);
    freq.put("Cze", 26);
    freq.put("At ", 124);
    freq.put("k ", 9945);
    freq.put("Kis", 28);
    freq.put("Kit", 23);
    freq.put("Kin", 90);
    freq.put("Kim", 34);
    freq.put("Kil", 52);
    freq.put("Kic", 25);
    freq.put("Kid", 47);
    freq.put("kB", 34);
    freq.put("Att", 47);
    freq.put("kc", 22);
    freq.put("kb", 82);
    freq.put("ka", 567);
    freq.put("kg", 39);
    freq.put("kf", 102);
    freq.put("ke", 7704);
    freq.put("kd", 28);
    freq.put("kk", 136);
    freq.put("ki", 3612);
    freq.put("kh", 64);
    freq.put("ko", 164);
    freq.put("kn", 1889);
    freq.put("km", 89);
    freq.put("kl", 211);
    freq.put("ks", 2125);
    freq.put("kr", 58);
    freq.put("kp", 35);
    freq.put("kw", 159);
    freq.put("ku", 109);
    freq.put("kt", 74);
    freq.put("ky", 479);
    freq.put("£", 178);
    freq.put("Ope", 81);
    freq.put(" Be", 1125);
    freq.put(" Ba", 792);
    freq.put(" Bl", 486);
    freq.put(" Bo", 536);
    freq.put(" Bi", 542);
    freq.put(" Bu", 782);
    freq.put("ik ", 38);
    freq.put(" Br", 695);
    freq.put(" By", 90);
    freq.put("DD ", 59);
    freq.put(" B ", 132);
    freq.put("ika", 28);
    freq.put("GE ", 39);
    freq.put("ike", 2818);
    freq.put("iki", 79);
    freq.put("TC ", 38);
    freq.put("Yea", 272);
    freq.put("Yep", 27);
    freq.put("Yes", 208);
    freq.put("lbu", 197);
    freq.put("ga ", 160);
    freq.put("ND ", 207);
    freq.put("HE ", 316);
    freq.put("gaz", 57);
    freq.put("gay", 68);
    freq.put("gav", 71);
    freq.put("gat", 98);
    freq.put("gas", 62);
    freq.put("gar", 147);
    freq.put("gap", 28);
    freq.put("gan", 183);
    freq.put("gam", 328);
    freq.put("gal", 102);
    freq.put("gai", 628);
    freq.put("gag", 44);
    freq.put("lba", 25);
    freq.put("fut", 77);
    freq.put("fur", 48);
    freq.put("fus", 100);
    freq.put("fuc", 579);
    freq.put("fun", 551);
    freq.put("lbe", 29);
    freq.put("ful", 839);
    freq.put("sy ", 322);
    freq.put("Ire", 37);
    freq.put("ewi", 83);
    freq.put("ewh", 42);
    freq.put("ewo", 105);
    freq.put("bs ", 299);
    freq.put("ewa", 60);
    freq.put("ewe", 85);
    freq.put("ews", 464);
    freq.put("syc", 26);
    freq.put("dge", 253);
    freq.put("cea", 28);
    freq.put("syn", 23);
    freq.put("sys", 54);
    freq.put("ew ", 2109);
    freq.put("y", 59402);
    freq.put("lda", 22);
    freq.put("lde", 149);
    freq.put("ldi", 137);
    freq.put("ldo", 30);
    freq.put("ldn", 275);
    freq.put("bi ", 37);
    freq.put("lds", 89);
    freq.put("ldr", 66);
    freq.put("ldw", 34);
    freq.put("rgr", 26);
    freq.put("cut", 389);
    freq.put("cus", 228);
    freq.put("cur", 300);
    freq.put("cup", 58);
    freq.put("rgy", 54);
    freq.put("cuz", 84);
    freq.put("rga", 94);
    freq.put("cue", 25);
    freq.put("cud", 31);
    freq.put("rge", 533);
    freq.put("rgh", 56);
    freq.put("cun", 30);
    freq.put("cum", 72);
    freq.put("cul", 163);
    freq.put("rgo", 135);
    freq.put("bin", 118);
    freq.put("bio", 36);
    freq.put("bil", 246);
    freq.put("ld ", 3475);
    freq.put("bik", 52);
    freq.put("Did", 119);
    freq.put("Die", 54);
    freq.put("bid", 32);
    freq.put("Dig", 44);
    freq.put("Dia", 45);
    freq.put("bia", 79);
    freq.put("biz", 27);
    freq.put("AL ", 77);
    freq.put("MY ", 132);
    freq.put("bit", 567);
    freq.put("bir", 292);
    freq.put("bis", 52);
    freq.put("Dir", 87);
    freq.put("Dis", 123);
    freq.put("rg ", 92);
    freq.put("oe ", 149);
    freq.put("pet", 163);
    freq.put("per", 1613);
    freq.put("pes", 89);
    freq.put("pel", 70);
    freq.put("pen", 884);
    freq.put("peo", 851);
    freq.put("ped", 241);
    freq.put("pee", 161);
    freq.put("pef", 51);
    freq.put("ape", 237);
    freq.put("pea", 404);
    freq.put("pec", 497);
    freq.put("Box", 22);
    freq.put("Boy", 84);
    freq.put("oes", 784);
    freq.put("Bor", 54);
    freq.put("Bos", 22);
    freq.put("Bot", 40);
    freq.put("Bou", 38);
    freq.put("O", 3904);
    freq.put("Hug", 24);
    freq.put("Bon", 48);
    freq.put("Boo", 106);
    freq.put("Bob", 31);
    freq.put("Bod", 22);
    freq.put("fec", 227);
    freq.put("ä", 28);
    freq.put("pe ", 929);
    freq.put("Hun", 37);
    freq.put("nsh", 135);
    freq.put("nsi", 357);
    freq.put("fem", 45);
    freq.put("nsl", 48);
    freq.put("nso", 98);
    freq.put("nsa", 46);
    freq.put("nsc", 29);
    freq.put("nse", 301);
    freq.put("nsf", 64);
    freq.put("nsp", 130);
    freq.put("nst", 480);
    freq.put("nsu", 105);
    freq.put("nsw", 128);
    freq.put("Ooo", 41);
    freq.put("fet", 45);
    freq.put("fer", 472);
    freq.put(" R ", 109);
    freq.put("ns ", 2131);
    freq.put("Fli", 26);
    freq.put("sda", 172);
    freq.put("Flo", 56);
    freq.put("Fla", 53);
    freq.put("lyw", 30);
    freq.put("lyr", 37);
    freq.put("lys", 45);
    freq.put("New", 662);
    freq.put("lym", 35);
    freq.put("lyi", 58);
    freq.put("Mas", 80);
    freq.put("Mar", 421);
    freq.put(" gr", 1167);
    freq.put("Mat", 113);
    freq.put("May", 177);
    freq.put("Max", 25);
    freq.put(" gy", 40);
    freq.put("Mac", 95);
    freq.put(" ge", 2236);
    freq.put("Mad", 84);
    freq.put("Mag", 60);
    freq.put(" ga", 637);
    freq.put("Mai", 49);
    freq.put(" go", 5103);
    freq.put("Mak", 150);
    freq.put("Mal", 65);
    freq.put(" gh", 27);
    freq.put("Man", 337);
    freq.put(" ch", 2176);
    freq.put("ly ", 6216);
    freq.put("kma", 24);
    freq.put(" g ", 40);
    freq.put("Mel", 25);
    freq.put(" b", 20079);
    freq.put(" c", 15772);
    freq.put(" ca", 4415);
    freq.put(" f", 19040);
    freq.put(" g", 11525);
    freq.put(" d", 13621);
    freq.put(" e", 7134);
    freq.put(" j", 3412);
    freq.put(" k", 3478);
    freq.put(" h", 18598);
    freq.put(" i", 27763);
    freq.put(" n", 11110);
    freq.put(" o", 21503);
    freq.put(" l", 15598);
    freq.put(" m", 23277);
    freq.put(" r", 9491);
    freq.put(" s", 33383);
    freq.put(" p", 11978);
    freq.put(" q", 551);
    freq.put(" v", 3992);
    freq.put(" w", 26246);
    freq.put(" t", 57614);
    freq.put(" u", 6189);
    freq.put(" z", 115);
    freq.put(" x", 1902);
    freq.put(" y", 14570);
    freq.put("Guy", 64);
    freq.put(" B", 6169);
    freq.put(" C", 6336);
    freq.put(" A", 7610);
    freq.put(" F", 4668);
    freq.put(" G", 4489);
    freq.put(" D", 6434);
    freq.put(" E", 2998);
    freq.put(" J", 2723);
    freq.put(" K", 1401);
    freq.put(" H", 5578);
    freq.put(" I", 19044);
    freq.put(" N", 4307);
    freq.put(" O", 3808);
    freq.put(" L", 5333);
    freq.put(" M", 6686);
    freq.put(" R", 5332);
    freq.put(" S", 9525);
    freq.put(" P", 4833);
    freq.put(" Q", 295);
    freq.put(" V", 1261);
    freq.put(" W", 6691);
    freq.put(" T", 10729);
    freq.put(" U", 1718);
    freq.put(" Z", 233);
    freq.put(" X", 563);
    freq.put(" Y", 3199);
    freq.put("fat", 116);
    freq.put("Ori", 25);
    freq.put(" £", 173);
    freq.put("ock", 647);
    freq.put("Or ", 79);
    freq.put(" Do", 1014);
    freq.put("Ver", 123);
    freq.put(" Di", 585);
    freq.put(" De", 935);
    freq.put(" Da", 861);
    freq.put("ii ", 46);
    freq.put(" Dy", 26);
    freq.put(" Du", 184);
    freq.put(" Dr", 281);
    freq.put("cha", 1187);
    freq.put("Fr", 730);
    freq.put("che", 1396);
    freq.put("chi", 1059);
    freq.put("chl", 24);
    freq.put("chn", 87);
    freq.put("cho", 694);
    freq.put("Fa", 793);
    freq.put("chr", 58);
    freq.put("cht", 44);
    freq.put("chu", 118);
    freq.put("chy", 38);
    freq.put("Fl", 186);
    freq.put("Fo", 851);
    freq.put(" D ", 862);
    freq.put("iin", 22);
    freq.put("iii", 128);
    freq.put("ch ", 3112);
    freq.put("f", 38923);
    freq.put("Bir", 131);
    freq.put("F ", 410);
    freq.put("afi", 65);
    freq.put("Yo", 1824);
    freq.put("Ya", 101);
    freq.put("afe", 112);
    freq.put("aff", 176);
    freq.put("Ye", 572);
    freq.put("tai", 330);
    freq.put("aft", 526);
    freq.put("Yu", 79);
    freq.put("afr", 48);
    freq.put("sip", 30);
    freq.put("Y ", 973);
    freq.put("af ", 37);
    freq.put("da ", 329);
    freq.put("lf", 807);
    freq.put("lg", 79);
    freq.put("ld", 4401);
    freq.put("le", 12692);
    freq.put("lb", 315);
    freq.put("lc", 313);
    freq.put("euk", 22);
    freq.put("tsi", 73);
    freq.put("eue", 28);
    freq.put("lo", 10487);
    freq.put("ll", 15420);
    freq.put("tse", 27);
    freq.put("lk", 857);
    freq.put("lh", 35);
    freq.put("li", 10431);
    freq.put("lv", 248);
    freq.put("lw", 564);
    freq.put("lt", 883);
    freq.put("lu", 1387);
    freq.put("lr", 464);
    freq.put("ls", 2002);
    freq.put("lp", 505);
    freq.put("eut", 49);
    freq.put("lz", 87);
    freq.put("LP ", 26);
    freq.put("dad", 104);
    freq.put("daf", 51);
    freq.put("dac", 43);
    freq.put("dal", 58);
    freq.put("dam", 215);
    freq.put("dan", 248);
    freq.put("dai", 47);
    freq.put("dat", 456);
    freq.put("dau", 41);
    freq.put("dar", 199);
    freq.put("das", 58);
    freq.put("day", 3942);
    freq.put("l ", 16640);
    freq.put("ts ", 4363);
    freq.put("lfr", 49);
    freq.put("rey", 76);
    freq.put("rer", 55);
    freq.put("res", 1999);
    freq.put("rep", 441);
    freq.put("req", 78);
    freq.put("rev", 389);
    freq.put("rew", 167);
    freq.put("ret", 673);
    freq.put("rek", 24);
    freq.put("reh", 44);
    freq.put("rei", 62);
    freq.put("ren", 1115);
    freq.put("Tum", 34);
    freq.put("Tun", 68);
    freq.put("rem", 525);
    freq.put("reb", 60);
    freq.put("rec", 781);
    freq.put("Tub", 82);
    freq.put("rea", 4415);
    freq.put("ref", 230);
    freq.put("Tue", 53);
    freq.put("red", 1211);
    freq.put("ree", 1167);
    freq.put("lf ", 638);
    freq.put("qua", 201);
    freq.put("que", 345);
    freq.put("qui", 373);
    freq.put("quo", 68);
    freq.put("re ", 10743);
    freq.put("ud ", 257);
    freq.put("og ", 338);
    freq.put("uds", 24);
    freq.put("ogy", 64);
    freq.put("ogu", 25);
    freq.put("udy", 89);
    freq.put("ogs", 48);
    freq.put("ogr", 216);
    freq.put("ogl", 212);
    freq.put("ogo", 26);
    freq.put("ogn", 57);
    freq.put("ogi", 79);
    freq.put("udg", 79);
    freq.put("udd", 125);
    freq.put("ude", 292);
    freq.put("oge", 159);
    freq.put("ogg", 99);
    freq.put("udi", 181);
    freq.put("oga", 58);
    freq.put("ogT", 24);
    freq.put("Peo", 108);
    freq.put("Par", 266);
    freq.put("Pas", 47);
    freq.put("Pat", 66);
    freq.put("Pau", 51);
    freq.put("nqu", 24);
    freq.put("Pay", 30);
    freq.put("Pac", 28);
    freq.put("Pad", 98);
    freq.put("Pag", 24);
    freq.put("Pai", 31);
    freq.put("Pal", 52);
    freq.put("Pan", 40);
    freq.put("mil", 706);
    freq.put("min", 1552);
    freq.put("Go ", 109);
    freq.put("mie", 80);
    freq.put("mid", 201);
    freq.put("mig", 212);
    freq.put("mix", 141);
    freq.put("mis", 728);
    freq.put("mir", 72);
    freq.put("mit", 275);
    freq.put("sfu", 39);
    freq.put("Pa ", 29);
    freq.put("sfo", 31);
    freq.put("sfe", 45);
    freq.put("mi ", 138);
    freq.put(" iP", 202);
    freq.put(" iT", 40);
    freq.put(" iO", 36);
    freq.put("kst", 34);
    freq.put("Mos", 72);
    freq.put("Mor", 304);
    freq.put(" ir", 67);
    freq.put(" is", 6095);
    freq.put(" it", 6429);
    freq.put("Mov", 61);
    freq.put("Mou", 25);
    freq.put("Mot", 79);
    freq.put("Moo", 56);
    freq.put("Mon", 226);
    freq.put(" in", 8152);
    freq.put("Mob", 66);
    freq.put("kso", 33);
    freq.put(" ic", 126);
    freq.put(" id", 335);
    freq.put("ksh", 51);
    freq.put(" if", 1436);
    freq.put("Mod", 51);
    freq.put("ks ", 1894);
    freq.put(" i ", 3628);
    freq.put("XD ", 63);
    freq.put("wm", 24);
    freq.put("wl", 172);
    freq.put("wk", 163);
    freq.put("S", 9683);
    freq.put("ws", 917);
    freq.put("wr", 544);
    freq.put("ohn", 157);
    freq.put("oho", 62);
    freq.put("uie", 39);
    freq.put("ad", 6104);
    freq.put("ys ", 1837);
    freq.put("ai", 5065);
    freq.put("wy", 44);

    init3();
  }
  private static void init3() {
    
    freq.put("Hoo", 26);
    freq.put("ak", 3228);
    freq.put("OL ", 233);
    freq.put("Hom", 91);
    freq.put("cos", 135);
    freq.put("al", 13533);
    freq.put("cor", 466);
    freq.put("an", 27068);
    freq.put("ysi", 69);
    freq.put("How", 499);
    freq.put("cov", 200);
    freq.put("uis", 99);
    freq.put("yse", 181);
    freq.put("uir", 67);
    freq.put("Hor", 40);
    freq.put("uit", 329);
    freq.put("coz", 31);
    freq.put(" Fu", 251);
    freq.put("Hop", 183);
    freq.put(" Fa", 775);
    freq.put(" Fe", 349);
    freq.put(" Fi", 542);
    freq.put(" Fl", 180);
    freq.put(" Fo", 829);
    freq.put("io ", 306);
    freq.put("coa", 61);
    freq.put("coc", 60);
    freq.put("cod", 93);
    freq.put("SO ", 97);
    freq.put("iou", 475);
    freq.put("iot", 109);
    freq.put("MB ", 22);
    freq.put("ior", 136);
    freq.put("ion", 3880);
    freq.put("iol", 53);
    freq.put("iod", 24);
    freq.put("GA ", 31);
    freq.put("con", 1619);
    freq.put("fy ", 61);
    freq.put("adv", 149);
    freq.put("adu", 42);
    freq.put("adr", 36);
    freq.put("ads", 198);
    freq.put("ady", 601);
    freq.put("adg", 32);
    freq.put("add", 303);
    freq.put("ade", 780);
    freq.put("adc", 33);
    freq.put("ada", 151);
    freq.put("adn", 22);
    freq.put("ado", 130);
    freq.put("adl", 94);
    freq.put("adm", 78);
    freq.put("adi", 509);
    freq.put("fyi", 26);
    freq.put("Hyu", 23);
    freq.put("ad ", 2791);
    freq.put("nja", 30);
    freq.put("njo", 241);
    freq.put("nju", 48);
    freq.put("esu", 156);
    freq.put("est", 2834);
    freq.put("ess", 2253);
    freq.put("esp", 309);
    freq.put("̩", 30);
    freq.put("EW ", 70);
    freq.put("tma", 123);
    freq.put("ese", 691);
    freq.put("esd", 113);
    freq.put("esc", 136);
    freq.put("tme", 96);
    freq.put("esa", 37);
    freq.put("eso", 392);
    freq.put("esn", 272);
    freq.put("esm", 22);
    freq.put("esl", 24);
    freq.put("esk", 42);
    freq.put("esi", 379);
    freq.put("esh", 151);
    freq.put("dca", 76);
    freq.put("OS ", 78);
    freq.put("tm ", 27);
    freq.put("es ", 7661);
    freq.put("Twe", 122);
    freq.put("Twi", 303);
    freq.put("Two", 56);
    freq.put("bu ", 25);
    freq.put("rcu", 55);
    freq.put("rcr", 23);
    freq.put("rcl", 31);
    freq.put("rco", 31);
    freq.put("rch", 305);
    freq.put("rci", 65);
    freq.put("rce", 210);
    freq.put("rca", 63);
    freq.put("buy", 190);
    freq.put("bur", 207);
    freq.put("bus", 311);
    freq.put("Der", 25);
    freq.put("Des", 102);
    freq.put("Det", 25);
    freq.put("but", 2340);
    freq.put("bui", 100);
    freq.put("bun", 55);
    freq.put("Dem", 106);
    freq.put("bul", 115);
    freq.put("bum", 242);
    freq.put("Dea", 203);
    freq.put("Deb", 29);
    freq.put("Dec", 68);
    freq.put("bug", 43);
    freq.put("Def", 52);
    freq.put("j", 4361);
    freq.put("pil", 90);
    freq.put("pin", 590);
    freq.put("pio", 61);
    freq.put("pia", 38);
    freq.put("pic", 661);
    freq.put("pid", 174);
    freq.put("pie", 157);
    freq.put("Rya", 28);
    freq.put("piz", 35);
    freq.put("ub ", 187);
    freq.put("pir", 201);
    freq.put("pis", 231);
    freq.put("pit", 150);
    freq.put("oad", 421);
    freq.put("oac", 67);
    freq.put("oan", 57);
    freq.put("oal", 101);
    freq.put("oah", 30);
    freq.put("oat", 92);
    freq.put("oas", 65);
    freq.put("oar", 91);
    freq.put("ubt", 63);
    freq.put("xxx", 752);
    freq.put("ubs", 122);
    freq.put("ube", 189);
    freq.put("uba", 28);
    freq.put("ubb", 76);
    freq.put("Act", 85);
    freq.put("ubl", 260);
    freq.put("ubm", 28);
    freq.put("ubi", 23);
    freq.put("ubj", 26);
    freq.put("oa ", 31);
    freq.put("dey", 38);
    freq.put("nwa", 34);
    freq.put("TV ", 178);
    freq.put("Oka", 63);
    freq.put("G ", 777);
    freq.put("nw ", 27);
    freq.put("Gu", 249);
    freq.put("Gr", 539);
    freq.put("Gy", 22);
    freq.put("Ok ", 70);
    freq.put("Ge", 675);
    freq.put("Ga", 454);
    freq.put("Go", 1334);
    freq.put("Gl", 178);
    freq.put("Gi", 277);
    freq.put("Gh", 38);
    freq.put(" ka", 62);
    freq.put(" ke", 424);
    freq.put(" ki", 874);
    freq.put(" kn", 1810);
    freq.put(" ko", 37);
    freq.put(" km", 59);
    freq.put(" ku", 37);
    freq.put("wd ", 38);
    freq.put("Z ", 94);
    freq.put("kul", 32);
    freq.put(" k ", 94);
    freq.put("TT ", 77);
    freq.put("Zo", 36);
    freq.put("Ze", 43);
    freq.put("ty", 2198);
    freq.put("Za", 45);
    freq.put("Zu", 23);
    freq.put("Kor", 24);
    freq.put("m ", 11152);
    freq.put("td", 71);
    freq.put("me", 15347);
    freq.put("md", 23);
    freq.put("mg", 226);
    freq.put("mf", 112);
    freq.put("ma", 7226);
    freq.put("ltu", 34);
    freq.put("mc", 39);
    freq.put("mb", 1329);
    freq.put("mm", 1457);
    freq.put("ml", 69);
    freq.put("mo", 4974);
    freq.put("mn", 233);
    freq.put("mi", 4314);
    freq.put("mh", 68);
    freq.put("tc", 1768);
    freq.put("mu", 1803);
    freq.put("mt", 67);
    freq.put("mw", 24);
    freq.put("mp", 1912);
    freq.put("ms", 969);
    freq.put("mr", 60);
    freq.put("my", 5005);
    freq.put("ena", 362);
    freq.put("enb", 24);
    freq.put("enc", 669);
    freq.put("end", 2195);
    freq.put("ene", 577);
    freq.put("eng", 298);
    freq.put("enh", 48);
    freq.put("eni", 528);
    freq.put("enj", 186);
    freq.put("enl", 54);
    freq.put("enm", 61);
    freq.put("enn", 210);
    freq.put("eno", 210);
    freq.put("enr", 34);
    freq.put("ens", 495);
    freq.put("ent", 3589);
    freq.put("enu", 69);
    freq.put("env", 28);
    freq.put("eny", 30);
    freq.put("enz", 31);
    freq.put("ON ", 243);
    freq.put("II ", 38);
    freq.put("en ", 6257);
    freq.put("UK ", 146);
    freq.put(" Hy", 42);
    freq.put(" Hu", 260);
    freq.put(" Hi", 411);
    freq.put(" Ho", 1233);
    freq.put(" Hm", 69);
    freq.put(" Ha", 1524);
    freq.put(" He", 1183);
    freq.put("ima", 306);
    freq.put("imb", 60);
    freq.put("ime", 1943);
    freq.put("cli", 219);
    freq.put("imi", 190);
    freq.put("cle", 423);
    freq.put("imm", 118);
    freq.put("cla", 292);
    freq.put("imo", 53);
    freq.put("imp", 394);
    freq.put("ims", 85);
    freq.put("imu", 23);
    freq.put("clu", 212);
    freq.put("SA ", 63);
    freq.put(" H ", 47);
    freq.put("im ", 1119);
    freq.put("gol", 89);
    freq.put("goo", 1400);
    freq.put("gon", 548);
    freq.put("goi", 768);
    freq.put("goe", 134);
    freq.put("god", 129);
    freq.put("goa", 78);
    freq.put("ajo", 52);
    freq.put("got", 1028);
    freq.put("gov", 69);
    freq.put("gos", 58);
    freq.put("gor", 83);
    freq.put("W", 6754);
    freq.put("Vic", 48);
    freq.put("Via", 22);
    freq.put("Vid", 188);
    freq.put("Vie", 77);
    freq.put("Vin", 27);
    freq.put("go ", 1190);
    freq.put("Vir", 39);
    freq.put("Vis", 68);
    freq.put(" Sp", 412);
    freq.put("nha", 64);
    freq.put("nho", 23);
    freq.put("tor", 1147);
    freq.put("tos", 254);
    freq.put("top", 627);
    freq.put("equ", 150);
    freq.put("EU ", 33);
    freq.put("tot", 165);
    freq.put("tou", 295);
    freq.put("tok", 24);
    freq.put("toi", 36);
    freq.put("ton", 836);
    freq.put("too", 1242);
    freq.put("tol", 206);
    freq.put("tom", 714);
    freq.put("tob", 109);
    freq.put("toc", 81);
    freq.put("tog", 206);
    freq.put("tod", 1081);
    freq.put("toe", 47);
    freq.put("Fuc", 82);
    freq.put("Fun", 76);
    freq.put("Ful", 44);
    freq.put("thx", 43);
    freq.put("to ", 12492);
    freq.put("ept", 364);
    freq.put("raf", 135);
    freq.put("rag", 202);
    freq.put("rad", 287);
    freq.put("rae", 41);
    freq.put("rab", 151);
    freq.put("rac", 610);
    freq.put("ran", 974);
    freq.put("epr", 82);
    freq.put("ral", 343);
    freq.put("ram", 250);
    freq.put("rak", 44);
    freq.put("rah", 47);
    freq.put("rai", 703);
    freq.put("rav", 175);
    freq.put("raw", 127);
    freq.put("rat", 991);
    freq.put("rau", 37);
    freq.put("rar", 92);
    freq.put("ras", 200);
    freq.put("rap", 354);
    freq.put("raz", 166);
    freq.put("lbo", 25);
    freq.put("ray", 134);
    freq.put("It ", 1042);
    freq.put("Sys", 30);
    freq.put("Syr", 26);
    freq.put("eph", 55);
    freq.put("ra ", 328);
    freq.put("bst", 38);
    freq.put("bso", 104);
    freq.put("bsi", 126);
    freq.put("bse", 52);
    freq.put("bsc", 67);
    freq.put("thd", 317);
    freq.put("Ita", 79);
    freq.put("AS ", 88);
    freq.put("Its", 142);
    freq.put("oci", 239);
    freq.put("och", 57);
    freq.put("Bil", 44);
    freq.put("WE ", 77);
    freq.put("oco", 106);
    freq.put("oca", 193);
    freq.put("Big", 125);
    freq.put("occ", 50);
    freq.put("Bie", 119);
    freq.put("oce", 76);
    freq.put("Bit", 50);
    freq.put("ocr", 31);
    freq.put("ocu", 94);
    freq.put("oct", 72);
    freq.put("é ", 28);
    freq.put("oc ", 30);
    freq.put("Pet", 56);
    freq.put("nut", 258);
    freq.put("nur", 22);
    freq.put("nus", 44);
    freq.put("Per", 136);
    freq.put("Pen", 33);
    freq.put("num", 150);
    freq.put("nui", 23);
    freq.put("nue", 96);
    freq.put("Pea", 46);
    freq.put("nua", 41);
    freq.put("mut", 23);
    freq.put("mus", 558);
    freq.put("mur", 33);
    freq.put("mug", 26);
    freq.put("muc", 808);
    freq.put("mum", 147);
    freq.put("mul", 52);
    freq.put("mun", 105);
    freq.put("Exe", 27);
    freq.put("Exc", 93);
    freq.put("Exa", 36);
    freq.put("Ext", 38);
    freq.put("Exp", 83);
    freq.put("nu ", 24);
    freq.put("kwa", 145);
    freq.put(" me", 5082);
    freq.put(" ma", 3762);
    freq.put(" mb", 35);
    freq.put(" mm", 103);
    freq.put(" mo", 3183);
    freq.put(" mi", 1923);
    freq.put(" mu", 1586);
    freq.put("xx ", 64);
    freq.put(" mp", 39);
    freq.put(" mr", 28);
    freq.put(" ms", 31);
    freq.put(" my", 4737);
    freq.put(" m ", 2661);
    freq.put("Cru", 29);
    freq.put("Cry", 29);
    freq.put("Cra", 70);
    freq.put("Cre", 128);
    freq.put("Cri", 48);
    freq.put("Cro", 60);
    freq.put("n", 139584);
    freq.put("wfu", 34);
    freq.put("rnm", 33);
    freq.put("HP ", 41);
    freq.put("eli", 864);
    freq.put("elo", 231);
    freq.put("ell", 2283);
    freq.put("elb", 27);
    freq.put("elc", 210);
    freq.put("ela", 300);
    freq.put("elf", 488);
    freq.put("eld", 175);
    freq.put("ele", 809);
    freq.put("ely", 744);
    freq.put("els", 476);
    freq.put("elp", 420);
    freq.put("elv", 78);
    freq.put("elt", 120);
    freq.put("elu", 25);
    freq.put("D", 6865);
    freq.put("OH ", 54);
    freq.put("el ", 1250);
    freq.put("ywa", 122);
    freq.put("ywo", 37);
    freq.put("ywh", 65);
    freq.put("hs ", 191);
    freq.put(" Ju", 943);
    freq.put(" Jo", 582);
    freq.put(" Ji", 60);
    freq.put(" Je", 273);
    freq.put(" Ja", 483);
    freq.put("ick", 1173);
    freq.put("ici", 372);
    freq.put("Hy", 50);
    freq.put("ico", 156);
    freq.put("icl", 120);
    freq.put("ica", 794);
    freq.put("ice", 1506);
    freq.put("Hu", 270);
    freq.put("icy", 32);
    freq.put("Hi", 413);
    freq.put("Ho", 1246);
    freq.put("Hm", 69);
    freq.put("ics", 325);
    freq.put("icr", 49);
    freq.put("Ha", 1551);
    freq.put("icu", 95);
    freq.put("ict", 464);
    freq.put("ril", 164);
    freq.put(" J ", 65);
    freq.put("ic ", 1414);
    freq.put("H ", 454);
    freq.put("thr", 451);
    freq.put("ppa", 115);
    freq.put("aha", 1532);
    freq.put("ppe", 564);
    freq.put("ahe", 46);
    freq.put("ppi", 242);
    freq.put("ppo", 379);
    freq.put("aho", 32);
    freq.put("ppl", 338);
    freq.put("pps", 43);
    freq.put("ppr", 148);
    freq.put("ppp", 29);
    freq.put("ppy", 572);
    freq.put("giv", 463);
    freq.put("git", 86);
    freq.put("gis", 58);
    freq.put("gir", 527);
    freq.put("gig", 49);
    freq.put("gif", 54);
    freq.put("gie", 67);
    freq.put("gic", 83);
    freq.put("gia", 48);
    freq.put("gio", 57);
    freq.put("gin", 680);
    freq.put("gil", 26);
    freq.put("ah ", 1066);
    freq.put("pp ", 143);
    freq.put("eyy", 34);
    freq.put("Vol", 28);
    freq.put("n´", 43);
    freq.put("nno", 375);
    freq.put("nnn", 87);
    freq.put("nni", 445);
    freq.put("ln", 64);
    freq.put("nA", 26);
    freq.put("nne", 568);
    freq.put("nna", 904);
    freq.put("nny", 403);
    freq.put("nh", 146);
    freq.put("ni", 5408);
    freq.put("nj", 336);
    freq.put("nk", 3565);
    freq.put("nl", 1334);
    freq.put("nm", 191);
    freq.put("nn", 2929);
    freq.put("no", 8706);
    freq.put("tit", 241);
    freq.put("na", 4340);
    freq.put("nb", 173);
    freq.put("nc", 3137);
    freq.put("nd", 16251);
    freq.put("ne", 12503);
    freq.put("nf", 687);
    freq.put("ng", 22178);
    freq.put("nx", 70);
    freq.put("ny", 2441);
    freq.put("tin", 3166);
    freq.put("tio", 2900);
    freq.put("ES ", 197);
    freq.put("np", 43);
    freq.put("nq", 27);
    freq.put("nr", 81);
    freq.put("tig", 69);
    freq.put("nt", 10142);
    freq.put("nu", 781);
    freq.put("nv", 384);
    freq.put("nw", 101);
    freq.put("squ", 79);
    freq.put("nn ", 105);
    freq.put("ich", 539);
    freq.put("n ", 38226);
    freq.put("ti ", 90);
    freq.put("roi", 78);
    freq.put("roj", 106);
    freq.put("rok", 125);
    freq.put("rol", 287);
    freq.put("rom", 2151);
    freq.put("ron", 652);
    freq.put("roo", 322);
    freq.put("lls", 353);
    freq.put("roa", 179);
    freq.put("rob", 428);
    freq.put("roc", 199);
    freq.put("rod", 204);
    freq.put("roe", 22);
    freq.put("rof", 150);
    freq.put("rog", 127);
    freq.put("roy", 59);
    freq.put("lli", 837);
    freq.put("Ian", 25);
    freq.put("llo", 1916);
    freq.put("Len", 40);
    freq.put("lll", 99);
    freq.put("rop", 413);
    freq.put("ror", 106);
    freq.put("ros", 278);
    freq.put("rot", 344);
    freq.put("rou", 1054);
    freq.put("rov", 188);
    freq.put("row", 1010);
    freq.put("Dad", 47);
    freq.put("Dal", 24);
    freq.put("Dam", 79);
    freq.put("Dan", 147);
    freq.put("Dai", 104);
    freq.put("Dat", 49);
    freq.put("Dav", 103);
    freq.put("Dar", 58);
    freq.put("Day", 192);
    freq.put("kle", 83);
    freq.put("ro ", 352);
    freq.put("Cin", 22);
    freq.put("Cit", 121);
    freq.put("hPa", 38);
    freq.put("ll ", 8343);
    freq.put("He", 1195);
    freq.put("Res", 119);
    freq.put("Rep", 104);
    freq.put("Rev", 89);
    freq.put("Ret", 59);
    freq.put("Reu", 24);
    freq.put("pme", 31);
    freq.put("Rel", 74);
    freq.put("Rem", 110);
    freq.put("Reb", 38);
    freq.put("Rec", 103);
    freq.put("Rea", 337);
    freq.put("Ref", 24);
    freq.put("Reg", 31);
    freq.put("Red", 100);
    freq.put("Qua", 50);
    freq.put("Que", 77);
    freq.put("Qui", 50);
    freq.put("Age", 28);
    freq.put("Aga", 30);
    freq.put("pm ", 122);
    freq.put("Re ", 26);
    freq.put("kly", 48);
    freq.put("ngi", 273);
    freq.put("sh ", 1388);
    freq.put("msu", 46);
    freq.put("mst", 36);
    freq.put("mse", 67);
    freq.put("Evi", 25);
    freq.put("Eve", 334);
    freq.put("ms ", 721);
    freq.put(" on", 7057);
    freq.put(" oo", 120);
    freq.put(" ol", 320);
    freq.put(" om", 182);
    freq.put("kyo", 52);
    freq.put(" ok", 402);
    freq.put(" oh", 437);
    freq.put("Min", 168);
    freq.put(" of", 6900);
    freq.put("Mic", 127);
    freq.put(" ob", 110);
    freq.put(" oc", 47);
    freq.put("Mig", 47);
    freq.put("Mix", 56);
    freq.put(" ov", 599);
    freq.put(" ow", 254);
    freq.put(" ot", 483);
    freq.put(" ou", 2387);
    freq.put(" or", 1266);
    freq.put(" op", 424);
    freq.put("ky ", 322);
    freq.put(" o ", 277);
    freq.put("iPh", 106);
    freq.put("Fan", 94);
    freq.put("gth", 56);
    freq.put("gto", 54);
    freq.put("ahh", 134);
    freq.put("ng ", 18407);
    freq.put("EN ", 126);
    freq.put(" wu", 28);
    freq.put("yu ", 32);
    freq.put("yup", 24);
    freq.put("yuk", 25);
    freq.put("yum", 33);
    freq.put("yun", 59);
    freq.put("hu ", 28);
    freq.put("iam", 106);
    freq.put("ial", 818);
    freq.put("ian", 683);
    freq.put("iag", 32);
    freq.put("iab", 38);
    freq.put("iat", 180);
    freq.put("ias", 45);
    freq.put("iar", 76);
    freq.put("huf", 22);
    freq.put("hug", 154);
    freq.put("AD ", 56);
    freq.put("huc", 49);
    freq.put("hul", 24);
    freq.put("hum", 131);
    freq.put("hun", 223);
    freq.put("huh", 43);
    freq.put("hut", 80);
    freq.put("hur", 298);
    freq.put("SE ", 168);
    freq.put("ia ", 759);
    freq.put("r", 112775);
    freq.put("Mir", 30);
    freq.put("and", 8959);
    freq.put("ane", 314);
    freq.put("anf", 30);
    freq.put("ang", 960);
    freq.put("pra", 143);
    freq.put("ana", 444);
    freq.put("anb", 23);
    freq.put("anc", 1026);
    freq.put("ann", 1018);
    freq.put("ano", 356);
    freq.put("pri", 482);
    freq.put("ani", 484);
    freq.put("ank", 1574);
    freq.put("ant", 2403);
    freq.put("anu", 72);
    freq.put("ans", 982);
    freq.put("anx", 35);
    freq.put("any", 1594);
    freq.put("ML ", 25);
    freq.put(" L ", 123);
    freq.put("kan", 30);
    freq.put("GO ", 63);
    freq.put("uys", 320);
    freq.put("an ", 6559);
    freq.put("uyi", 30);
    freq.put(" Le", 679);
    freq.put(" La", 547);
    freq.put(" Lo", 1570);
    freq.put(" Lm", 39);
    freq.put(" Li", 1001);
    freq.put(" Lu", 158);
    freq.put(" Ly", 33);
    freq.put("nly", 804);
    freq.put("itl", 90);
    freq.put("nle", 69);
    freq.put("nli", 254);
    freq.put("dy ", 1300);
    freq.put("ss ", 2423);
    freq.put("nlo", 166);
    freq.put("ssy", 77);
    freq.put("ssu", 144);
    freq.put("H", 5659);
    freq.put("ssw", 24);
    freq.put("sss", 142);
    freq.put("sso", 148);
    freq.put("ssi", 874);
    freq.put("ssh", 23);
    freq.put("sse", 644);
    freq.put("ssf", 38);
    freq.put("ssa", 228);
    freq.put("rms", 113);
    freq.put("rmy", 27);
    freq.put("rma", 697);
    freq.put("rme", 136);
    freq.put("lne", 39);
    freq.put("rmi", 138);
    freq.put("rmo", 47);
    freq.put("rm ", 411);
    freq.put("pow", 92);
    freq.put("pot", 150);
    freq.put("pou", 59);
    freq.put("por", 775);
    freq.put("pos", 722);
    freq.put("pop", 129);
    freq.put("pon", 262);
    freq.put("poo", 195);
    freq.put("pol", 230);
    freq.put("pok", 55);
    freq.put("poi", 233);
    freq.put("pod", 44);
    freq.put("poe", 24);
    freq.put("poc", 26);
    freq.put("Buy", 37);
    freq.put("Bur", 55);
    freq.put("Bus", 112);
    freq.put("I´", 32);
    freq.put("But", 439);
    freq.put("Bui", 26);
    freq.put("Bul", 26);
    freq.put("oks", 336);
    freq.put("yl", 351);
    freq.put("I ", 14408);
    freq.put("Is", 454);
    freq.put("Ir", 91);
    freq.put("It", 1283);
    freq.put("Im", 265);
    freq.put("Il", 27);
    freq.put("In", 1030);
    freq.put("Ia", 25);
    freq.put("oke", 549);
    freq.put("Ic", 51);
    freq.put("Id", 71);
    freq.put("If", 580);
    freq.put(" qu", 533);
    freq.put("tip", 88);
    freq.put("Ban", 107);
    freq.put("tir", 224);
    freq.put("´t ", 41);
    freq.put("til", 1054);
    freq.put("tim", 1721);
    freq.put("nz", 76);
    freq.put("yc", 141);
    freq.put("tie", 326);
    freq.put("tif", 362);
    freq.put("ns", 4219);
    freq.put("Pin", 42);
    freq.put("Pic", 90);
    freq.put("tia", 166);
    freq.put("Pir", 25);
    freq.put("tic", 994);
    freq.put("HT ", 70);
    freq.put("alt", 235);
    freq.put("o ", 26907);
    freq.put("uTu", 76);
    freq.put("An ", 70);
    freq.put("oo", 10965);
    freq.put("on", 24921);
    freq.put("om", 10293);
    freq.put("ol", 7343);
    freq.put("ok", 3105);
    freq.put("oj", 128);
    freq.put("oi", 2161);
    freq.put("oh", 818);
    freq.put("og", 1454);
    freq.put("of", 7483);
    freq.put("oe", 1103);
    freq.put("od", 5102);
    freq.put("oc", 1623);
    freq.put("ob", 1548);
    freq.put("oa", 1023);
    freq.put("oz", 130);
    freq.put("oy", 1042);
    freq.put("ox", 359);
    freq.put("ow", 10513);
    freq.put("ov", 4414);
    freq.put("ou", 26999);
    freq.put("ot", 8391);
    freq.put("os", 3770);
    freq.put("or", 19308);
    freq.put("op", 4266);
    freq.put("LE ", 106);
    freq.put("FB ", 49);
    freq.put("EL ", 42);
    freq.put("ehe", 212);
    freq.put("RD ", 51);
    freq.put("eha", 51);
    freq.put("eho", 72);
    freq.put("ehi", 89);
    freq.put("jud", 47);
    freq.put("jui", 25);
    freq.put("jun", 32);
    freq.put("UE ", 25);
    freq.put("jum", 60);
    freq.put("jur", 46);
    freq.put("jus", 2239);
    freq.put("OD ", 76);
    freq.put("eh ", 94);
    freq.put("rva", 34);
    freq.put("rve", 229);
    freq.put("rvi", 288);
    freq.put("rvo", 25);
    freq.put("Hot", 70);
    freq.put("igu", 71);
    freq.put("IC ", 77);
    freq.put("igg", 206);
    freq.put("ige", 70);
    freq.put("iga", 89);
    freq.put("ign", 544);
    freq.put("Hou", 100);
    freq.put("igi", 155);
    freq.put("igh", 3327);
    freq.put("hwa", 28);
    freq.put("hmm", 78);
    freq.put("ig ", 423);
    freq.put("Hos", 25);
    freq.put("pto", 82);
    freq.put("alo", 296);
    freq.put("all", 5467);
    freq.put("alm", 160);
    freq.put("alk", 729);
    freq.put("pti", 172);
    freq.put("ali", 681);
    freq.put("alf", 190);
    freq.put("alg", 27);
    freq.put("ald", 96);
    freq.put("ale", 540);
    freq.put("alb", 190);
    freq.put("alc", 60);
    freq.put("pta", 28);
    freq.put("ala", 199);
    freq.put("pty", 27);
    freq.put("aly", 129);
    freq.put("alw", 482);
    freq.put("ptu", 26);
    freq.put("alu", 49);
    freq.put("pts", 26);
    freq.put("als", 492);
    freq.put(" N ", 77);
    freq.put("llp", 24);
    freq.put("far", 236);
    freq.put("fas", 214);
    freq.put("fav", 341);
    freq.put("al ", 3011);
    freq.put("pt ", 277);
    freq.put("fak", 57);
    freq.put("fai", 217);
    freq.put("fan", 578);
    freq.put("fao", 44);
    freq.put("fal", 188);
    freq.put("fam", 245);
    freq.put("fab", 47);
    freq.put("fac", 507);
    freq.put(" Ni", 412);
    freq.put(" No", 1465);
    freq.put(" Na", 315);
    freq.put(" Ne", 1132);
    freq.put(" Nu", 50);
    freq.put("tei", 30);
    freq.put("tel", 854);
    freq.put("tem", 369);
    freq.put("ten", 1117);
    freq.put("tea", 554);
    freq.put("tec", 156);
    freq.put("ted", 2030);
    freq.put("tee", 150);
    freq.put("tef", 33);
    freq.put("teg", 63);
    freq.put("tex", 152);
    freq.put("nbo", 37);
    freq.put("tep", 100);
    freq.put("ter", 4770);
    freq.put("tes", 881);
    freq.put("tet", 32);
    freq.put("lla", 323);
    freq.put("tev", 188);
    freq.put("sug", 55);
    freq.put("suf", 26);
    freq.put("sue", 96);
    freq.put("sud", 40);
    freq.put("suc", 344);
    freq.put("sub", 175);
    freq.put("sua", 127);
    freq.put("sun", 265);
    freq.put("sum", 186);
    freq.put("sul", 129);
    freq.put("sui", 72);
    freq.put("sus", 96);
    freq.put("sur", 687);
    freq.put("sup", 397);
    freq.put("te ", 3362);
    freq.put("Any", 166);
    freq.put("Und", 42);
    freq.put("rks", 186);
    freq.put("Tor", 66);
    freq.put("Top", 177);
    freq.put("Tow", 41);
    freq.put("Tot", 30);
    freq.put("Tou", 88);
    freq.put("rke", 348);
    freq.put("Ton", 65);
    freq.put("Too", 101);
    freq.put("Tom", 106);
    freq.put("rki", 252);
    freq.put("Tod", 146);
    freq.put("mma", 136);
    freq.put("In ", 343);
    freq.put("rk ", 1056);
    freq.put("To ", 285);
    freq.put("á", 23);
    freq.put("Int", 246);
    freq.put("Inv", 35);
    freq.put("Ins", 95);
    freq.put("v", 23008);
    freq.put("Ind", 133);
    freq.put("Inf", 66);
    freq.put("Inc", 58);
    freq.put("oys", 165);
    freq.put("oyi", 97);
    freq.put("oyf", 58);
    freq.put("oye", 105);
    freq.put("oya", 68);
    freq.put("Glo", 55);
    freq.put("Gla", 72);
    freq.put("Gle", 42);
    freq.put("oy ", 453);
    freq.put("Oct", 108);
    freq.put("yn ", 53);
    freq.put("L", 5443);
    freq.put("EO ", 90);
    freq.put("Era", 24);
    freq.put("Eri", 22);
    freq.put("Rad", 78);
    freq.put("Rac", 27);
    freq.put("Ran", 45);
    freq.put("yne", 58);
    freq.put("Ram", 35);
    freq.put("yna", 38);
    freq.put("Rai", 117);
    freq.put("Rat", 30);
    freq.put("Ray", 32);
    freq.put(" sy", 90);
    freq.put("Mus", 190);
    freq.put(" sr", 27);
    freq.put(" sp", 1074);
    freq.put(" sq", 58);
    freq.put(" sw", 444);
    freq.put(" st", 4145);
    freq.put(" su", 1978);
    freq.put(" sk", 242);
    freq.put(" sh", 3622);
    freq.put(" si", 1640);
    freq.put(" sn", 157);
    freq.put("RY ", 85);
    freq.put("Muc", 34);
    freq.put(" sm", 512);
    freq.put("Mum", 27);
    freq.put(" sc", 942);
    freq.put(" sa", 2461);
    freq.put(" se", 3347);
    freq.put("iza", 67);
    freq.put("ize", 224);
    freq.put("gur", 69);
    freq.put("izi", 22);
    freq.put("wl ", 31);
    freq.put("izz", 87);
    freq.put(" s ", 5542);
    freq.put("iz ", 63);
    freq.put("wly", 53);
    freq.put("wle", 41);
    freq.put("▸ ", 75);
    freq.put("TL ", 33);
    freq.put("kou", 23);
    freq.put("efr", 39);
    freq.put("eft", 178);
    freq.put("efu", 169);
    freq.put("efi", 199);
    freq.put("efl", 28);
    freq.put("efo", 409);
    freq.put("efa", 37);
    freq.put("efe", 156);
    freq.put("eff", 118);
    freq.put("ef ", 102);
    freq.put("rte", 362);
    freq.put("rtf", 28);
    freq.put("rta", 251);
    freq.put("rtm", 40);
    freq.put("rtl", 33);
    freq.put("rto", 73);
    freq.put("rtn", 41);
    freq.put("rti", 555);
    freq.put("rth", 728);
    freq.put("rtu", 158);
    freq.put("rtp", 22);
    freq.put("rts", 422);
    freq.put("rty", 275);
    freq.put("OF ", 70);
    freq.put("Ju", 948);
    freq.put("ies", 1219);
    freq.put("ier", 293);
    freq.put("iet", 166);
    freq.put("iew", 345);
    freq.put("iev", 297);
    freq.put("Jo", 590);
    freq.put("iel", 180);
    freq.put("ien", 1043);
    freq.put("Je", 279);
    freq.put("iec", 71);
    freq.put("ieb", 224);
    freq.put("Ja", 497);
    freq.put("ief", 60);
    freq.put("hip", 284);
    freq.put("hir", 238);
    freq.put("his", 3465);
    freq.put("hit", 691);
    freq.put("rt ", 1925);
    freq.put("hiv", 23);
    freq.put("hia", 24);
    freq.put("hib", 30);
    freq.put("hic", 456);
    freq.put("hid", 55);
    freq.put("hie", 116);
    freq.put("hif", 31);
    freq.put("hig", 188);
    freq.put("hil", 606);
    freq.put("him", 638);
    freq.put("hin", 4249);
    freq.put("hio", 92);
    freq.put("ie ", 909);
    freq.put("J ", 217);
    freq.put("arp", 57);
    freq.put("arr", 590);
    freq.put("ars", 706);
    freq.put("art", 2071);
    freq.put("aru", 23);
    freq.put("arv", 50);
    freq.put("ary", 371);
    freq.put("ara", 354);
    freq.put("arb", 89);
    freq.put("arc", 283);
    freq.put("ard", 1514);
    freq.put("are", 3673);
    freq.put("arf", 30);
    freq.put("arg", 225);
    freq.put("ari", 685);
    freq.put("ark", 606);
    freq.put("arl", 530);
    freq.put("arm", 271);
    freq.put("arn", 325);
    freq.put("aro", 344);
    freq.put(" P ", 204);
    freq.put("uuu", 102);
    freq.put("ar ", 1964);
    freq.put("fgh", 30);
    freq.put(" Pr", 726);
    freq.put("c", 48507);
    freq.put(" Pu", 150);
    freq.put(" Pa", 685);
    freq.put(" Pe", 413);
    freq.put(" Pi", 280);
    freq.put(" Ph", 296);
    freq.put(" Po", 524);
    freq.put(" Pl", 576);
    freq.put("Fav", 23);
    freq.put("pr", 3118);
    freq.put("ps", 905);
    freq.put("pp", 2604);
    freq.put("dul", 86);
    freq.put("dum", 45);
    freq.put("pt", 847);
    freq.put("pu", 987);
    freq.put("swa", 44);
    freq.put("dua", 28);
    freq.put("py", 751);
    freq.put("dud", 82);
    freq.put("due", 56);
    freq.put("pb", 23);
    freq.put("pc", 64);
    freq.put("pa", 2811);
    freq.put("pd", 193);
    freq.put("pe", 6009);
    freq.put("pk", 23);
    freq.put("dur", 88);
    freq.put("pi", 2475);
    freq.put("po", 3049);
    freq.put("pl", 4513);
    freq.put("pm", 173);
    freq.put("Emi", 24);
    freq.put("Emp", 24);
    freq.put("p ", 5454);
    freq.put("riz", 57);
    freq.put("rix", 27);
    freq.put("Tit", 24);
    freq.put("rit", 989);
    freq.put("riu", 38);
    freq.put("Tip", 39);
    freq.put("ris", 687);
    freq.put("rip", 231);
    freq.put("rin", 1516);
    freq.put("Tim", 209);
    freq.put("Tin", 28);
    freq.put("rim", 157);
    freq.put("rik", 59);
    freq.put("rif", 46);
    freq.put("rig", 866);
    freq.put("rid", 455);
    freq.put("rie", 1481);
    freq.put("rib", 270);
    freq.put("ric", 693);
    freq.put("ria", 365);
    freq.put("Squ", 26);
    freq.put("Cop", 36);
    freq.put("Cos", 35);
    freq.put("Cor", 97);
    freq.put("Cou", 187);
    freq.put("Cov", 43);
    freq.put("Coa", 25);
    freq.put("Coc", 25);
    freq.put("Cod", 51);
    freq.put("Cof", 34);
    freq.put("Com", 376);
    freq.put("Col", 186);
    freq.put("ri ", 103);
    freq.put("Con", 356);
    freq.put("Air", 94);
    freq.put("zz ", 54);
    freq.put("yl ", 25);
    freq.put("bh ", 32);
    freq.put("zzz", 39);
    freq.put("zzy", 25);
    freq.put("zzi", 37);
    freq.put("Epi", 47);
    freq.put("zza", 63);
    freq.put("Rol", 51);
    freq.put("Rom", 46);
    freq.put("Ron", 33);
    freq.put("Roo", 39);
    freq.put("Roa", 33);
    freq.put("Rob", 65);
    freq.put("Roc", 76);
    freq.put("yle", 169);
    freq.put("ylo", 69);
    freq.put("Ros", 50);
    freq.put("Rou", 25);
    freq.put("yli", 51);
    freq.put("wn ", 984);
    freq.put(" up", 1869);
    freq.put(" ur", 353);
    freq.put(" us", 1187);
    freq.put(" um", 35);
    freq.put(" un", 1086);
    freq.put(" uh", 36);
    freq.put(" uk", 44);
    freq.put(" ug", 75);
    freq.put("ixi", 27);
    freq.put("xpo", 32);
    freq.put("xpl", 110);
    freq.put("xpa", 27);
    freq.put("xpe", 266);
    freq.put("ixe", 59);
    freq.put("xpr", 38);
    freq.put("ixt", 42);
    freq.put("wne", 42);
    freq.put("wni", 23);
    freq.put("wnl", 125);
    freq.put("wns", 42);
    freq.put(" u ", 1410);
    freq.put(" Ky", 42);
    freq.put("ix ", 261);
    freq.put("z", 2648);
    freq.put("NK ", 46);
    freq.put("exi", 149);
    freq.put("gry", 94);
    freq.put("gre", 903);
    freq.put("gra", 617);
    freq.put("gro", 289);
    freq.put("gri", 57);
    freq.put("edb", 29);
    freq.put("eda", 53);
    freq.put("edg", 57);
    freq.put("edd", 93);
    freq.put("ede", 147);
    freq.put("edi", 504);
    freq.put("LA ", 38);
    freq.put("edo", 62);
    freq.put("edl", 40);
    freq.put("edr", 35);
    freq.put("eds", 175);
    freq.put("edw", 53);
    freq.put("edu", 91);
    freq.put("edy", 54);
    freq.put("FF ", 49);
    freq.put("ed ", 10461);
    freq.put("ugg", 146);
    freq.put("P", 5164);
    freq.put("Kyu", 24);
    freq.put("rro", 725);
    freq.put("rri", 464);
    freq.put("rre", 340);
    freq.put("rra", 108);
    freq.put("Hap", 229);
    freq.put("rry", 829);
    freq.put("rru", 28);
    freq.put("rrr", 222);
    freq.put("bda", 39);
    freq.put("Hav", 265);
    freq.put("IG ", 30);
    freq.put(" €", 24);
    freq.put("rr ", 82);
    freq.put("aps", 102);
    freq.put("app", 1403);
    freq.put("Mik", 39);
    freq.put("apt", 115);
    freq.put("aph", 173);
    freq.put("api", 79);
    freq.put("apo", 80);
    freq.put("NT ", 140);
    freq.put("apa", 151);
    freq.put("Mil", 158);
    freq.put("fed", 28);
    freq.put("fee", 889);
    freq.put("usc", 28);
    freq.put("usb", 30);
    freq.put("usa", 70);
    freq.put("fea", 203);
    freq.put("fen", 111);
    freq.put("Hum", 108);
    freq.put("fel", 126);
    freq.put(" oi", 38);
    freq.put("usi", 809);
    freq.put("ush", 235);
    freq.put("MV ", 22);
    freq.put("few", 222);
    freq.put("usu", 82);
    freq.put("ust", 3769);
    freq.put("uss", 175);
    freq.put("fes", 131);
    freq.put("Hur", 42);
    freq.put("usp", 33);
    freq.put(" od", 48);
    freq.put("usy", 86);
    freq.put("Gua", 29);
    freq.put("Gue", 39);
    freq.put("Gui", 48);
    freq.put("Gun", 26);
    freq.put("Mid", 34);
    freq.put("ap ", 282);
    freq.put(" Ru", 178);
    freq.put("fe ", 656);
    freq.put("us ", 1581);
    freq.put(" Ry", 43);
    freq.put(" Re", 1293);
    freq.put(" Ra", 461);
    freq.put(" Ro", 525);
    freq.put(" Ri", 310);
    freq.put("tat", 431);
    freq.put("tau", 52);
    freq.put("tap", 54);
    freq.put("tar", 1063);
    freq.put("tas", 161);
    freq.put("tax", 32);
    freq.put("tay", 239);
    freq.put("tad", 26);
    freq.put("taf", 44);
    freq.put("tag", 270);
    freq.put("tab", 190);
    freq.put("tac", 198);
    freq.put("tal", 1208);
    freq.put("tam", 33);
    freq.put("tan", 732);
    freq.put("Mis", 97);
    freq.put("tak", 607);
    freq.put("sis", 279);
    freq.put("sir", 33);
    freq.put("kyp", 38);
    freq.put("siv", 177);
    freq.put("sit", 749);
    freq.put("siz", 50);
    freq.put("six", 38);
    freq.put("sic", 631);
    freq.put("sib", 158);
    freq.put("sia", 112);
    freq.put("dwa", 110);
    freq.put("sig", 441);
    freq.put("sie", 89);
    freq.put("sid", 468);
    freq.put("dwi", 65);
    freq.put("sio", 538);
    freq.put("sin", 1388);
    freq.put("sim", 128);
    freq.put("sil", 127);
    freq.put("ta ", 466);
    freq.put("si ", 46);
    freq.put("usl", 227);
    freq.put("kbe", 32);
    freq.put("ea ", 456);
    freq.put("bye", 87);
    freq.put("bya", 55);
    freq.put("Cas", 135);
    freq.put("Car", 252);
    freq.put("Cap", 57);
    freq.put("Cau", 35);
    freq.put("Cat", 75);
    freq.put("Can", 471);
    freq.put("Cam", 103);
    freq.put("Cal", 103);
    freq.put("Pre", 227);
    freq.put("nfe", 74);
    freq.put("Pra", 46);
    freq.put("nfa", 30);
    freq.put("nfo", 258);
    freq.put("Pro", 355);
    freq.put("nfl", 51);
    freq.put("Pri", 123);
    freq.put("nfi", 138);
    freq.put("nfu", 88);
    freq.put("nfr", 35);
    freq.put("by ", 1525);
    freq.put("oui", 47);
    freq.put("oun", 1742);
    freq.put("oul", 2412);
    freq.put("ouc", 165);
    freq.put("oub", 145);
    freq.put("oug", 1310);
    freq.put("oud", 260);
    freq.put("ous", 1274);
    freq.put("our", 4665);
    freq.put("oup", 243);
    freq.put("ouu", 29);
    freq.put("out", 3963);
    freq.put("lt ", 264);
    freq.put("ouT", 76);
    freq.put("ou ", 10445);
    freq.put("lts", 73);
    freq.put("g", 49400);
    freq.put("lty", 49);
    freq.put("lta", 70);
    freq.put("lte", 60);
    freq.put("lti", 100);
    freq.put("lth", 151);
    freq.put("lto", 42);
    freq.put("ü", 62);
    freq.put("K ", 622);
    freq.put("sev", 38);
    freq.put("Ka", 197);
    freq.put("Ke", 250);
    freq.put("Ki", 345);
    freq.put("Ko", 76);
    freq.put("Kn", 95);
    freq.put("Kl", 29);
    freq.put("Kr", 41);
    freq.put("Ku", 45);
    freq.put("Ky", 42);
    freq.put("ybo", 135);
    freq.put("ybe", 298);
    freq.put("wh ", 42);
    freq.put("hx", 62);
    freq.put("sel", 702);
    freq.put("hr", 873);
    freq.put("hp", 35);
    freq.put("whe", 1904);
    freq.put("wha", 1617);
    freq.put("who", 1078);
    freq.put("whi", 575);
    freq.put("hw", 66);
    freq.put("ht", 3817);
    freq.put("hu", 1170);
    freq.put("why", 536);
    freq.put("Pow", 53);
    freq.put("Pot", 62);
    freq.put("Por", 56);
    freq.put("Pos", 102);
    freq.put("Pop", 48);
    freq.put("Poo", 33);
    freq.put("Pol", 99);
    freq.put("hn", 314);
    freq.put("Pod", 38);
    freq.put("Cha", 327);
    freq.put("hc", 29);
    freq.put("ha", 20666);
    freq.put(" w ", 167);
    freq.put("hf", 27);
    freq.put("eat", 2073);
    freq.put("q ", 37);
    freq.put("hd", 342);
    freq.put("he", 32693);
    freq.put("TH ", 77);
    freq.put("Jas", 34);
    freq.put(" we", 4273);
    freq.put("qu", 993);
    freq.put(" wa", 6208);
    freq.put(" wo", 3616);
    freq.put(" wh", 5574);
    freq.put(" wi", 5611);
    freq.put(" ww", 135);
    freq.put(" wt", 37);
    freq.put("Jam", 86);
    freq.put(" wr", 514);
    freq.put("Am ", 54);
    freq.put("Ra", 473);
    freq.put("ebe", 281);
    freq.put("eba", 105);
    freq.put("ebl", 36);
    freq.put("ebo", 432);
    freq.put("ebi", 26);
    freq.put("ebt", 26);
    freq.put("ebu", 35);
    freq.put("ebr", 153);
    freq.put("ebs", 138);
    freq.put("lve", 189);
    freq.put("Jae", 22);
    freq.put("dle", 241);
    freq.put("dli", 71);
    freq.put("Jac", 89);
    freq.put("dly", 138);
    freq.put("jor", 56);
    freq.put("eb ", 110);
    freq.put("jou", 39);
    freq.put("joy", 259);
    freq.put("job", 186);
    freq.put("joi", 127);
    freq.put("jok", 103);
    freq.put("joo", 22);
    freq.put("rpr", 115);
    freq.put("CD ", 37);
    freq.put("rpe", 45);
    freq.put("rpi", 26);
    freq.put("hm ", 37);
    freq.put("rpl", 36);
    freq.put("rpo", 131);
    freq.put("bbl", 41);
    freq.put("bbi", 61);
    freq.put("bbe", 55);
    freq.put("Jun", 75);
    freq.put("Jul", 36);
    freq.put("Jum", 23);
    freq.put("Jus", 762);
    freq.put("bby", 60);
    freq.put("IE ", 38);
    freq.put("rp ", 25);
    freq.put("hme", 27);
    freq.put("hma", 25);
    freq.put("é", 49);
    freq.put("bb ", 44);
    freq.put("avy", 50);
    freq.put("AR ", 50);
    freq.put("avo", 336);
    freq.put("avi", 519);
    freq.put("ave", 3736);
    freq.put("ava", 173);
    freq.put(" T ", 287);
    freq.put(" ▸", 79);
    freq.put("av ", 64);
    freq.put(" Ty", 50);
    freq.put(" Tw", 478);
    freq.put(" Tu", 235);
    freq.put(" Tr", 599);
    freq.put(" To", 1172);
    freq.put(" Ti", 396);
    freq.put(" Th", 4817);
    freq.put(" Te", 599);
    freq.put(" Ta", 422);
    freq.put("mfa", 45);
    freq.put("mfo", 29);
    freq.put("tch", 1652);
    freq.put("tca", 26);
    freq.put("sks", 25);
    freq.put("Far", 36);
    freq.put("Fas", 44);
    freq.put("sky", 97);
    freq.put("Fat", 43);
    freq.put("ske", 164);
    freq.put("Fai", 47);
    freq.put("ska", 22);
    freq.put("Fal", 66);
    freq.put("Fam", 63);
    freq.put("Fab", 23);
    freq.put("Fac", 314);
    freq.put("ski", 204);
    freq.put("T", 10977);
    freq.put("tc ", 50);
    freq.put("sk ", 249);
    freq.put("Suc", 55);
    freq.put("Sub", 47);
    freq.put("Sun", 156);
    freq.put("Sum", 47);
    freq.put("Sur", 92);
    freq.put("Sup", 156);
    freq.put("nd ", 11606);
    freq.put("YC ", 30);
    freq.put("ndi", 585);
    freq.put("ndm", 26);
    freq.put("ndl", 143);
    freq.put("ndo", 542);
    freq.put("nda", 543);
    freq.put("nde", 1161);
    freq.put("ndy", 105);
    freq.put("nds", 1018);
    freq.put("ndr", 151);
    freq.put("ndu", 57);
    freq.put("ndw", 24);
    freq.put("owl", 119);
    freq.put("own", 1186);
    freq.put("owi", 364);
    freq.put("owe", 851);
    freq.put("owd", 49);
    freq.put("owa", 69);
    freq.put("owb", 22);
    freq.put("owt", 26);
    freq.put("oww", 25);
    freq.put("owp", 25);
    freq.put("ows", 384);
    freq.put("vai", 116);
    freq.put("van", 142);
    freq.put("val", 203);
    freq.put("vam", 22);
    freq.put("Ama", 94);
    freq.put("vac", 57);
    freq.put("Amb", 22);
    freq.put("Ame", 121);
    freq.put("vag", 25);
    freq.put("Amy", 31);
    freq.put("var", 44);
    freq.put("vat", 179);
    freq.put("uct", 201);
    freq.put("ow ", 7134);
    freq.put("Tel", 80);
    freq.put("Tem", 97);
    freq.put("Ten", 27);
    freq.put("Tea", 121);
    freq.put("va ", 86);
    freq.put("Tec", 74);
    freq.put("Tee", 29);
    freq.put("Tex", 36);
    freq.put("Ter", 51);
    freq.put("Tes", 49);
    freq.put("lvi", 36);
    freq.put("mys", 196);
    freq.put("Aft", 70);
    freq.put("Afr", 54);
    freq.put("my ", 4744);
  }
  
}

