package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ES {
  private static final String name = "es";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ES() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2559301;
    n_words[1] = 3138335;
    n_words[2] = 2481503;

    freq.put("rà ", 42);
    freq.put("req", 30);
    freq.put("gai", 31);
    freq.put("sn ", 33);
    freq.put(" ¿Y", 98);
    freq.put(" ¿V", 40);
    freq.put(" ¿T", 105);
    freq.put("cag", 121);
    freq.put(" ¿S", 108);
    freq.put(" ¿P", 155);
    freq.put(" ¿Q", 307);
    freq.put(" ¿N", 62);
    freq.put(" ¿O", 41);
    freq.put(" ¿L", 45);
    freq.put(" ¿M", 31);
    freq.put("unc", 926);
    freq.put(" ¿H", 58);
    freq.put("mbl", 119);
    freq.put("ufi", 57);
    freq.put("Van", 45);
    freq.put(" ¿D", 60);
    freq.put(" ¿E", 118);
    freq.put(" ¿C", 234);
    freq.put(" ¿A", 103);
    freq.put("niñ", 296);
    freq.put("tít", 56);
    freq.put("mp ", 70);
    freq.put("él ", 194);
    freq.put(" ¿y", 34);
    freq.put("móv", 117);
    freq.put(" ¿t", 35);
    freq.put("Vam", 127);
    freq.put("aum", 62);
    freq.put(" ¿s", 29);
    freq.put(" ¿p", 56);
    freq.put(" ¿q", 92);
    freq.put(" ¿n", 72);
    freq.put("éri", 70);
    freq.put("xte", 40);
    freq.put("lt ", 59);
    freq.put("aut", 301);
    freq.put("xta", 49);
    freq.put("G ", 157);
    freq.put("tai", 50);
    freq.put("bli", 527);
    freq.put(" ¿d", 29);
    freq.put(" ¿e", 56);
    freq.put("érd", 34);
    freq.put(" ¿c", 53);
    freq.put(" ¡C", 32);
    freq.put(" ¿a", 34);
    freq.put("ràc", 32);
    freq.put(" Gu", 228);
    freq.put(" Gr", 778);
    freq.put("alb", 62);
    freq.put("alc", 300);
    freq.put(" Ge", 250);
    freq.put("unt", 1077);
    freq.put("pta", 123);
    freq.put("ueg", 858);
    freq.put(" Ga", 435);
    freq.put("ra ", 12215);
    freq.put(" Go", 386);
    freq.put(" Gl", 40);
    freq.put("ala", 1245);
    freq.put("lím", 44);
    freq.put(" Gi", 113);
    freq.put("glé", 74);
    freq.put("Gu", 236);
    freq.put("sáb", 82);
    freq.put("Gr", 804);
    freq.put("MA ", 58);
    freq.put("¿Sa", 44);
    freq.put("lls", 26);
    freq.put("upe", 577);
    freq.put("¿Se", 33);
    freq.put("upa", 186);
    freq.put("dré", 93);
    freq.put("Ge", 255);
    freq.put("Vay", 151);
    freq.put("drí", 256);
    freq.put("aas", 87);
    freq.put("Ga", 441);
    freq.put("ait", 35);
    freq.put("Go", 395);
    freq.put("Gl", 42);
    freq.put("lín", 78);
    freq.put(" ¿ ", 66);
    freq.put("áre", 29);
    freq.put("Igu", 39);
    freq.put(" ka", 41);
    freq.put("ça ", 250);
    freq.put(" G ", 51);
    freq.put(" ke", 123);
    freq.put(" ki", 133);
    freq.put("ído", 157);
    freq.put("ajo", 612);
    freq.put(" km", 49);
    freq.put("Var", 34);
    freq.put("ais", 352);
    freq.put("Vas", 27);
    freq.put("orz", 28);
    freq.put("è ", 33);
    freq.put("Igl", 36);
    freq.put("Tom", 73);
    freq.put("dí ", 57);
    freq.put("neo", 79);
    freq.put("Pun", 43);
    freq.put("nem", 358);
    freq.put("nej", 35);
    freq.put("boc", 108);
    freq.put("nei", 50);
    freq.put(" y ", 12160);
    freq.put("Pue", 646);
    freq.put("ned", 76);
    freq.put("Z ", 48);
    freq.put("nec", 546);
    freq.put("Pub", 32);
    freq.put("nea", 164);
    freq.put("abi", 558);
    freq.put("slo", 33);
    freq.put("nez", 80);
    freq.put("nex", 39);
    freq.put("ney", 63);
    freq.put("Put", 41);
    freq.put("net", 311);
    freq.put("scr", 417);
    freq.put("ner", 1587);
    freq.put("nes", 3399);
    freq.put("Uno", 47);
    freq.put("mee", 31);
    freq.put("dep", 298);
    freq.put(" k ", 299);
    freq.put("ou ", 245);
    freq.put("mea", 34);
    freq.put("íci", 84);
    freq.put("TL ", 46);
    freq.put("mem", 76);
    freq.put("orr", 957);
    freq.put("meo", 36);
    freq.put("men", 4018);
    freq.put("ors", 44);
    freq.put("met", 633);
    freq.put("tís", 30);
    freq.put("mes", 520);
    freq.put("mer", 1643);
    freq.put("MJ ", 119);
    freq.put("ícu", 225);
    freq.put("íct", 30);
    freq.put("mez", 61);
    freq.put("día", 1637);
    freq.put("Zo", 43);
    freq.put("aug", 34);
    freq.put("glo", 81);
    freq.put("aks", 29);
    freq.put("gla", 150);
    freq.put("k", 3492);
    freq.put("roc", 196);
    freq.put("dru", 92);
    freq.put("gle", 310);
    freq.put("ne ", 2083);
    freq.put("sla", 105);
    freq.put("dri", 1035);
    freq.put("fé ", 52);
    freq.put("dís", 46);
    freq.put("óli", 80);
    freq.put("dro", 230);
    freq.put("tw", 822);
    freq.put("dra", 233);
    freq.put("Ped", 80);
    freq.put("dre", 812);
    freq.put(" yu", 33);
    freq.put("ake", 53);
    freq.put("dañ", 41);
    freq.put("nk ", 84);
    freq.put("Jes", 56);
    freq.put("sso", 43);
    freq.put("bob", 28);
    freq.put("Nac", 62);
    freq.put("uce", 165);
    freq.put("lmo", 81);
    freq.put("abí", 266);
    freq.put("ent", 10266);
    freq.put("rrá", 31);
    freq.put("bri", 351);
    freq.put("lma", 146);
    freq.put("Jej", 62);
    freq.put("món", 68);
    freq.put("pér", 28);
    freq.put("aun", 474);
    freq.put("OR ", 73);
    freq.put("m ", 1372);
    freq.put("tía", 108);
    freq.put("ené", 80);
    freq.put("ení", 195);
    freq.put("LA ", 149);
    freq.put("lme", 381);
    freq.put("líd", 33);
    freq.put("vol", 500);
    freq.put("enó", 26);
    freq.put("er ", 8967);
    freq.put("nfu", 49);
    freq.put(" mí", 464);
    freq.put("ora", 3410);
    freq.put("ni ", 1073);
    freq.put("sía", 32);
    freq.put("Val", 291);
    freq.put("Á", 106);
    freq.put("Ste", 61);
    freq.put("Rei", 30);
    freq.put("nke", 32);
    freq.put("ucc", 83);
    freq.put("ngu", 284);
    freq.put("Sto", 44);
    freq.put("órd", 35);
    freq.put("reí", 140);
    freq.put(" mé", 84);
    freq.put("xto", 39);
    freq.put("osp", 110);
    freq.put("Str", 37);
    freq.put("V", 2700);
    freq.put("iv", 2608);
    freq.put("tmo", 46);
    freq.put("rry", 123);
    freq.put("me", 17585);
    freq.put("eru", 35);
    freq.put("erv", 426);
    freq.put("mba", 197);
    freq.put("ma", 13455);
    freq.put("ltu", 107);
    freq.put("err", 1187);
    freq.put("mb", 3257);
    freq.put("mm", 390);
    freq.put("mo", 12837);
    freq.put("mn", 111);
    freq.put("mi", 10857);
    freq.put("ery", 38);
    freq.put("erz", 128);
    freq.put("ére", 31);
    freq.put("mu", 4388);
    freq.put("ere", 2990);
    freq.put("erf", 235);
    freq.put("erg", 304);
    freq.put("mp", 5890);
    freq.put("ms", 221);
    freq.put("erc", 766);
    freq.put("erl", 510);
    freq.put("erm", 1036);
    freq.put("ern", 1039);
    freq.put("ero", 6462);
    freq.put("my", 121);
    freq.put("eri", 1754);
    freq.put(" mñ", 31);
    freq.put("uay", 63);
    freq.put("Le", 456);
    freq.put("Nat", 28);
    freq.put("Lib", 76);
    freq.put("La", 2405);
    freq.put("Lo", 1540);
    freq.put("Ll", 267);
    freq.put(" mó", 115);
    freq.put("la ", 18002);
    freq.put("uat", 140);
    freq.put("Li", 391);
    freq.put("Lit", 38);
    freq.put("uah", 37);
    freq.put("Abr", 39);
    freq.put("Lu", 248);
    freq.put("ual", 1044);
    freq.put("rq ", 35);
    freq.put("Lis", 27);
    freq.put("uaa", 32);
    freq.put("uac", 135);
    freq.put("uad", 132);
    freq.put("brá", 131);
    freq.put("rmá", 26);
    freq.put("hog", 43);
    freq.put("ib", 2146);
    freq.put("end", 3777);
    freq.put("hoc", 86);
    freq.put("enf", 152);
    freq.put("eng", 1881);
    freq.put("hon", 239);
    freq.put("hoo", 49);
    freq.put("hol", 148);
    freq.put("hom", 366);
    freq.put("enl", 85);
    freq.put("off", 32);
    freq.put("Al ", 210);
    freq.put("eno", 2507);
    freq.put("Kar", 28);
    freq.put("hot", 108);
    freq.put("ens", 1603);
    freq.put("hor", 2254);
    freq.put("hos", 408);
    freq.put("eño", 679);
    freq.put("mpo", 1431);
    freq.put("eña", 352);
    freq.put("eny", 27);
    freq.put("enz", 274);
    freq.put("if", 1042);
    freq.put("eñe", 28);
    freq.put("Va ", 44);
    freq.put("uco", 45);
    freq.put("hoy", 962);
    freq.put("A", 6971);
    freq.put("lam", 957);
    freq.put("Not", 55);
    freq.put("lao", 39);
    freq.put("Mun", 84);
    freq.put("lai", 84);
    freq.put("L ", 496);
    freq.put("icó", 32);
    freq.put("lad", 826);
    freq.put("ON ", 68);
    freq.put("lag", 186);
    freq.put("ost", 990);
    freq.put("laa", 79);
    freq.put("lab", 420);
    freq.put("sc ", 109);
    freq.put("Tu ", 134);
    freq.put("¿En", 37);
    freq.put("ova", 145);
    freq.put("lax", 39);
    freq.put("II ", 65);
    freq.put("laz", 205);
    freq.put("ove", 514);
    freq.put("lat", 314);
    freq.put("lau", 97);
    freq.put("lav", 167);
    freq.put("ovi", 501);
    freq.put("lap", 34);
    freq.put("ovo", 51);
    freq.put("lar", 1731);
    freq.put("las", 5103);
    freq.put("en ", 18174);
    freq.put("Alo", 35);
    freq.put("All", 30);
    freq.put("Alm", 61);
    freq.put("má", 2527);
    freq.put("mà", 28);
    freq.put("ho ", 1964);
    freq.put("eró", 27);
    freq.put("mí", 589);
    freq.put("Alg", 238);
    freq.put("cat", 427);
    freq.put("Ale", 146);
    freq.put("mé", 191);
    freq.put("Alc", 45);
    freq.put("cía", 347);
    freq.put("Ala", 56);
    freq.put("mñ", 35);
    freq.put("erá", 512);
    freq.put("mó", 238);
    freq.put("lqu", 185);
    freq.put("fan", 307);
    freq.put("eré", 202);
    freq.put("núm", 79);
    freq.put("mú", 165);
    freq.put("ráf", 76);
    freq.put("gún", 312);
    freq.put("rác", 47);
    freq.put("rís", 54);
    freq.put("rán", 361);
    freq.put("fam", 242);
    freq.put(" Hu", 139);
    freq.put("Oja", 51);
    freq.put("Jim", 26);
    freq.put("fab", 37);
    freq.put(" Hi", 184);
    freq.put("oni", 887);
    freq.put(" Ho", 845);
    freq.put("rás", 366);
    freq.put("oña", 117);
    freq.put("Mag", 41);
    freq.put("oño", 179);
    freq.put("onn", 28);
    freq.put(" Ha", 1003);
    freq.put("YO ", 40);
    freq.put("bó ", 45);
    freq.put(" He", 365);
    freq.put("xo", 235);
    freq.put("ima", 1324);
    freq.put("fis", 61);
    freq.put("éci", 28);
    freq.put("His", 97);
    freq.put("ime", 944);
    freq.put("cli", 144);
    freq.put("rò", 45);
    freq.put("ró", 431);
    freq.put("imi", 583);
    freq.put("cle", 81);
    freq.put("tás", 217);
    freq.put("cla", 772);
    freq.put("imo", 1227);
    freq.put("imn", 35);
    freq.put("ssa", 69);
    freq.put("imp", 889);
    freq.put("ims", 47);
    freq.put("rç", 247);
    freq.put("imu", 35);
    freq.put("rá", 2206);
    freq.put("fie", 477);
    freq.put("fij", 96);
    freq.put("rí", 2065);
    freq.put("fin", 1084);
    freq.put("ré", 897);
    freq.put("JA ", 82);
    freq.put(" Va", 760);
    freq.put("Viv", 88);
    freq.put("ona", 2380);
    freq.put(" Ve", 419);
    freq.put("Jug", 29);
    freq.put("rá ", 1210);
    freq.put("ono", 1041);
    freq.put(" Vi", 757);
    freq.put("onf", 327);
    freq.put("ntó", 111);
    freq.put("SA ", 74);
    freq.put("fig", 44);
    freq.put(" Vo", 253);
    freq.put("ong", 424);
    freq.put("nté", 34);
    freq.put(" Vu", 66);
    freq.put("ond", 1122);
    freq.put("ntá", 53);
    freq.put("Mov", 38);
    freq.put(" H ", 40);
    freq.put("áma", 56);
    freq.put("Úl", 41);
    freq.put("im ", 69);
    freq.put("upu", 106);
    freq.put("yyy", 86);
    freq.put("upi", 96);
    freq.put("aní", 55);
    freq.put("l", 124872);
    freq.put("até", 29);
    freq.put("fi ", 90);
    freq.put("ony", 52);
    freq.put("ató", 111);
    freq.put("Joe", 39);
    freq.put("ába", 114);
    freq.put("íbl", 58);
    freq.put("Jue", 50);
    freq.put("UE ", 101);
    freq.put("ríe", 28);
    freq.put("áni", 106);
    freq.put("uch", 2199);
    freq.put("onr", 122);
    freq.put("bra", 1022);
    freq.put("¿no", 69);
    freq.put("éne", 30);
    freq.put("mbo", 129);
    freq.put("nt ", 522);
    freq.put("yol", 46);
    freq.put("imá", 49);
    freq.put("gol", 281);
    freq.put("goo", 58);
    freq.put("gon", 148);
    freq.put("rp", 373);
    freq.put("eí ", 28);
    freq.put("rr", 4376);
    freq.put("rs", 2414);
    freq.put("zar", 551);
    freq.put(" za", 81);
    freq.put("¬", 307);
    freq.put("goc", 101);
    freq.put("gob", 125);
    freq.put("rd", 3970);
    freq.put("re", 24034);
    freq.put("rf", 344);
    freq.put("rg", 1431);
    freq.put("ra", 29511);
    freq.put("rb", 423);
    freq.put("goz", 70);
    freq.put(" zu", 34);
    freq.put("got", 90);
    freq.put("rn", 1645);
    freq.put("gov", 31);
    freq.put("ri", 11793);
    freq.put("gos", 676);
    freq.put("gor", 169);
    freq.put("nts", 60);
    freq.put("ntr", 2660);
    freq.put(" Ví", 73);
    freq.put("tei", 75);
    freq.put("nti", 1562);
    freq.put("drá", 200);
    freq.put("pip", 28);
    freq.put("Dí", 69);
    freq.put("mbi", 1410);
    freq.put("W", 518);
    freq.put("nta", 4354);
    freq.put("kit", 32);
    freq.put("nte", 7420);
    freq.put("deb", 674);
    freq.put("eíd", 60);
    freq.put("ría", 1694);
    freq.put("eía", 51);
    freq.put("€ ", 174);
    freq.put("¡El", 36);
    freq.put("eíb", 58);
    freq.put("iss", 66);
    freq.put("alv", 177);
    freq.put("atl", 43);
    freq.put("isp", 282);
    freq.put("atu", 250);
    freq.put("go ", 4846);
    freq.put("isu", 41);
    freq.put("ist", 3084);
    freq.put("Vir", 34);
    freq.put("eun", 76);
    freq.put("isi", 857);
    freq.put("ish", 53);
    freq.put("r ", 30086);
    freq.put("Gi", 118);
    freq.put("ism", 1010);
    freq.put("eír", 32);
    freq.put("isc", 457);
    freq.put("pea", 100);
    freq.put("isa", 440);
    freq.put("dec", 1011);
    freq.put("isf", 269);
    freq.put("ise", 267);
    freq.put("zam", 95);
    freq.put(" l ", 203);
    freq.put("nho", 177);
    freq.put("raí", 36);
    freq.put("lá ", 149);
    freq.put("pir", 196);
    freq.put("nir", 151);
    freq.put("xD", 2160);
    freq.put("osa", 1388);
    freq.put("rañ", 139);
    freq.put("TU ", 28);
    freq.put("ñit", 36);
    freq.put("Dur", 45);
    freq.put("FA ", 33);
    freq.put("jja", 288);
    freq.put("me ", 8328);
    freq.put("xic", 65);
    freq.put("Man", 217);
    freq.put("xig", 54);
    freq.put("tor", 1336);
    freq.put("Cen", 57);
    freq.put("top", 105);
    freq.put("Cel", 31);
    freq.put("equ", 680);
    freq.put("xim", 254);
    freq.put("tot", 203);
    freq.put("adr", 1636);
    freq.put("xtr", 237);
    freq.put("xis", 197);
    freq.put("Ces", 97);
    freq.put("Cer", 44);
    freq.put("mme", 34);
    freq.put("Se ", 454);
    freq.put("tob", 48);
    freq.put("toc", 397);
    freq.put("YA ", 52);
    freq.put("Así", 128);
    freq.put("ax ", 39);
    freq.put(" le", 2995);
    freq.put("B", 3871);
    freq.put("uip", 303);
    freq.put(" la", 19181);
    freq.put("oíd", 29);
    freq.put(" lo", 11644);
    freq.put("NO ", 171);
    freq.put(" ll", 2392);
    freq.put("ajj", 277);
    freq.put(" li", 1333);
    freq.put("tee", 66);
    freq.put("laj", 86);
    freq.put(" lu", 915);
    freq.put("Fue", 67);
    freq.put(" ls", 34);
    freq.put("abé", 92);
    freq.put("fil", 179);
    freq.put(" ly", 32);
    freq.put("lás", 67);
    freq.put("ain", 149);
    freq.put("Sev", 92);
    freq.put("lla", 2804);
    freq.put("Ser", 195);
    freq.put("Sep", 83);
    freq.put("í", 11452);
    freq.put("tez", 35);
    freq.put("Sex", 49);
    freq.put("Seg", 214);
    freq.put("nza", 552);
    freq.put("Sec", 29);
    freq.put(" ep", 56);
    freq.put("Sen", 45);
    freq.put("Sem", 37);
    freq.put("Sel", 63);
    freq.put("rde", 1017);
    freq.put("ept", 393);
    freq.put("raf", 158);
    freq.put("rag", 225);
    freq.put("rad", 1688);
    freq.put("epu", 54);
    freq.put("rab", 902);
    freq.put("rac", 2104);
    freq.put("raa", 45);
    freq.put("ran", 3357);
    freq.put("rao", 70);
    freq.put("ral", 628);
    freq.put("ram", 701);
    freq.put("raj", 98);
    freq.put("más", 2159);
    freq.put("ose", 343);
    freq.put("rai", 119);
    freq.put("rav", 212);
    freq.put("Q ", 164);
    freq.put("rat", 969);
    freq.put("rau", 71);
    freq.put("rar", 1846);
    freq.put("ras", 2673);
    freq.put("rap", 144);
    freq.put("dur", 440);
    freq.put("cad", 1070);
    freq.put("¿Y ", 85);
    freq.put("raz", 618);
    freq.put("ase", 844);
    freq.put("ray", 82);
    freq.put("eud", 67);
    freq.put("der", 1664);
    freq.put("Ast", 56);
    freq.put("do ", 17032);
    freq.put("Te ", 426);
    freq.put("iño", 318);
    freq.put("aló", 68);
    freq.put("hul", 62);
    freq.put("piz", 37);
    freq.put("xió", 53);
    freq.put("máx", 37);
    freq.put("uvi", 187);
    freq.put("Asi", 54);
    freq.put("Len", 26);
    freq.put("hun", 67);
    freq.put("nen", 591);
    freq.put("Qu", 2084);
    freq.put(" lá", 47);
    freq.put("suf", 141);
    freq.put("oft", 39);
    freq.put(" lí", 126);
    freq.put("nel", 66);
    freq.put("ull", 166);
    freq.put("Últ", 41);
    freq.put("sud", 41);
    freq.put("suc", 103);
    freq.put("abe", 1472);
    freq.put("don", 741);
    freq.put("doo", 79);
    freq.put("dol", 304);
    freq.put("dom", 303);
    freq.put("dob", 154);
    freq.put("doc", 100);
    freq.put("m", 74518);
    freq.put("Ita", 32);
    freq.put("ví ", 26);
    freq.put("nef", 62);
    freq.put("doy", 91);
    freq.put("sun", 102);
    freq.put("dor", 1651);
    freq.put("ñññ", 26);
    freq.put("lpe", 78);
    freq.put("dow", 33);
    freq.put("dot", 57);
    freq.put("Cóm", 164);
    freq.put("éx", 64);
    freq.put(" We", 93);
    freq.put("mág", 61);
    freq.put(" Wa", 84);
    freq.put("api", 273);
    freq.put(" Wo", 59);
    freq.put("és", 865);
    freq.put("ér", 291);
    freq.put("ét", 120);
    freq.put(" Wh", 41);
    freq.put(" Wi", 130);
    freq.put("éi", 325);
    freq.put("ém", 36);
    freq.put("él", 245);
    freq.put("AD ", 30);
    freq.put("én", 1052);
    freq.put("éc", 114);
    freq.put("¿Te", 56);
    freq.put("éd", 65);
    freq.put("rta", 1428);
    freq.put("Cór", 27);
    freq.put("oci", 884);
    freq.put(" úl", 274);
    freq.put("Bil", 59);
    freq.put(" ún", 174);
    freq.put("uen", 3683);
    freq.put("em ", 159);
    freq.put("oco", 1044);
    freq.put("oca", 1019);
    freq.put("én ", 815);
    freq.put("Bie", 199);
    freq.put("oce", 364);
    freq.put("dón", 162);
    freq.put("iré", 117);
    freq.put("abs", 80);
    freq.put("nvi", 454);
    freq.put("irí", 103);
    freq.put("ba ", 1610);
    freq.put("irá", 190);
    freq.put("ocr", 102);
    freq.put("ocu", 369);
    freq.put("oct", 107);
    freq.put("sur", 198);
    freq.put("dn", 34);
    freq.put("do", 24230);
    freq.put("dl", 139);
    freq.put("dm", 160);
    freq.put("dj", 46);
    freq.put("di", 10758);
    freq.put("df", 47);
    freq.put("dd", 168);
    freq.put("de", 44847);
    freq.put("¿Cu", 95);
    freq.put("dc", 37);
    freq.put("omí", 75);
    freq.put("da", 15335);
    freq.put("ga ", 1788);
    freq.put("nev", 37);
    freq.put("tis", 310);
    freq.put("bi ", 55);
    freq.put("¿Co", 41);
    freq.put("dy", 140);
    freq.put("dv", 37);
    freq.put("X", 927);
    freq.put("app", 82);
    freq.put("du", 1634);
    freq.put("dr", 2991);
    freq.put("ds", 156);
    freq.put(" el", 13677);
    freq.put("eme", 436);
    freq.put("ruñ", 28);
    freq.put("neu", 32);
    freq.put("ema", 1514);
    freq.put("bas", 538);
    freq.put("emb", 473);
    freq.put("Riv", 36);
    freq.put("oc ", 47);
    freq.put("emo", 1931);
    freq.put("emi", 370);
    freq.put("emu", 51);
    freq.put("uss", 31);
    freq.put("bad", 314);
    freq.put("ò ", 66);
    freq.put("emp", 2462);
    freq.put("bec", 54);
    freq.put("ban", 643);
    freq.put("bao", 31);
    freq.put("bal", 338);
    freq.put("bam", 101);
    freq.put("baj", 899);
    freq.put(" em", 1118);
    freq.put("dó ", 34);
    freq.put("bai", 115);
    freq.put("abó", 41);
    freq.put("ua ", 261);
    freq.put("om ", 234);
    freq.put("ayi", 31);
    freq.put("w ", 293);
    freq.put("PS ", 35);
    freq.put("Pep", 103);
    freq.put("meg", 33);
    freq.put("Per", 753);
    freq.put("Pel", 53);
    freq.put("Pen", 82);
    freq.put("num", 53);
    freq.put(" I ", 171);
    freq.put("jóv", 56);
    freq.put("nud", 151);
    freq.put("nue", 1256);
    freq.put("nub", 71);
    freq.put("sá", 123);
    freq.put("nua", 68);
    freq.put("muu", 51);
    freq.put("mut", 27);
    freq.put("yer", 412);
    freq.put("ocí", 30);
    freq.put("mec", 32);
    freq.put("il ", 898);
    freq.put("mur", 86);
    freq.put("Rub", 87);
    freq.put("irr", 114);
    freq.put("irs", 122);
    freq.put("irt", 161);
    freq.put("iru", 45);
    freq.put("irv", 64);
    freq.put("mue", 445);
    freq.put("iri", 177);
    freq.put("irl", 189);
    freq.put("irm", 354);
    freq.put("irn", 38);
    freq.put("iro", 279);
    freq.put("Tri", 55);
    freq.put("ira", 1040);
    freq.put("íse", 35);
    freq.put("irc", 58);
    freq.put("ire", 582);
    freq.put("irg", 66);
    freq.put("só ", 59);
    freq.put("omb", 757);
    freq.put("C", 6637);
    freq.put("dí", 1814);
    freq.put("unk", 32);
    freq.put("wa", 213);
    freq.put("dé", 218);
    freq.put("wo", 91);
    freq.put(" Ir", 110);
    freq.put(" Is", 79);
    freq.put(" It", 43);
    freq.put("Sam", 52);
    freq.put("wi", 880);
    freq.put("dá", 81);
    freq.put("ww", 213);
    freq.put("Ext", 39);
    freq.put(" Ik", 30);
    freq.put("ws", 69);
    freq.put(" Im", 105);
    freq.put(" In", 600);
    freq.put("ued", 2430);
    freq.put(" Ib", 71);
    freq.put("mej", 1157);
    freq.put(" Id", 27);
    freq.put("dó", 233);
    freq.put("nu ", 27);
    freq.put(" Ig", 89);
    freq.put("DM ", 39);
    freq.put("gge", 30);
    freq.put("ild", 74);
    freq.put("ile", 558);
    freq.put("ilb", 48);
    freq.put("icí", 133);
    freq.put("ila", 531);
    freq.put("oki", 43);
    freq.put("ilo", 249);
    freq.put("ill", 1922);
    freq.put("Sal", 233);
    freq.put("lgú", 148);
    freq.put("ili", 738);
    freq.put("ilv", 36);
    freq.put("una", 4437);
    freq.put("ilt", 35);
    freq.put("ilu", 116);
    freq.put("und", 1094);
    freq.put("mu ", 53);
    freq.put("cog", 209);
    freq.put("ung", 70);
    freq.put("ir ", 2969);
    freq.put("coh", 77);
    freq.put("coj", 192);
    freq.put("com", 4960);
    freq.put("col", 750);
    freq.put("coo", 60);
    freq.put("ily", 27);
    freq.put(" me", 11009);
    freq.put("ela", 994);
    freq.put(" ma", 6232);
    freq.put("ón ", 4224);
    freq.put("lóg", 55);
    freq.put("iñ", 499);
    freq.put("Gas", 34);
    freq.put("ió", 3921);
    freq.put(" mo", 2125);
    freq.put(" mi", 6122);
    freq.put("elg", 99);
    freq.put("ié", 943);
    freq.put(" mu", 3952);
    freq.put(" ej", 159);
    freq.put(" ms", 35);
    freq.put("iá", 49);
    freq.put("ele", 1280);
    freq.put(" my", 83);
    freq.put("ana", 3180);
    freq.put("fra", 294);
    freq.put("TT ", 144);
    freq.put("Bal", 43);
    freq.put("che", 1396);
    freq.put("fre", 379);
    freq.put("hay", 1313);
    freq.put("lti", 572);
    freq.put("fri", 226);
    freq.put("C ", 352);
    freq.put("fro", 46);
    freq.put("Gam", 33);
    freq.put("lón", 154);
    freq.put("Leó", 33);
    freq.put("áli", 33);
    freq.put("fru", 270);
    freq.put("sab", 1252);
    freq.put("uja", 74);
    freq.put("ark", 128);
    freq.put("pro", 2234);
    freq.put("rge", 236);
    freq.put("ónd", 102);
    freq.put("ále", 30);
    freq.put(" m ", 205);
    freq.put("Cru", 36);
    freq.put("sag", 37);
    freq.put("óni", 128);
    freq.put("Gag", 52);
    freq.put("Cre", 245);
    freq.put("nió", 84);
    freq.put("Cri", 104);
    freq.put("íam", 94);
    freq.put("TV ", 120);
    freq.put("oqu", 301);
    freq.put("ían", 242);
    freq.put("€", 193);
    freq.put("Ci", 271);
    freq.put("Ch", 414);
    freq.put("Co", 1958);
    freq.put("aix", 38);
    freq.put("Cl", 198);
    freq.put("elv", 325);
    freq.put("Ca", 1433);
    freq.put(" yo", 2357);
    freq.put("BC ", 37);
    freq.put("Ví", 73);
    freq.put("Ce", 244);
    freq.put("n", 162888);
    freq.put("ape", 279);
    freq.put("ail", 233);
    freq.put("oes", 55);
    freq.put("gna", 137);
    freq.put("elt", 448);
    freq.put("Ze", 30);
    freq.put("Cr", 452);
    freq.put("aig", 69);
    freq.put("gni", 85);
    freq.put("gno", 100);
    freq.put("Cu", 685);
    freq.put("anq", 203);
    freq.put("sma", 197);
    freq.put("ix", 217);
    freq.put("iz", 1397);
    freq.put(" má", 2004);
    freq.put("Nad", 100);
    freq.put("bio", 317);
    freq.put("iq", 308);
    freq.put("ip", 1536);
    freq.put("is", 9817);
    freq.put("ir", 6779);
    freq.put("iu", 350);
    freq.put("it", 7422);
    freq.put("tío", 87);
    freq.put("Za", 145);
    freq.put("ii", 831);
    freq.put("ih", 41);
    freq.put("ik", 278);
    freq.put("ij", 857);
    freq.put("im", 5331);
    freq.put("il", 5378);
    freq.put("io", 9354);
    freq.put("in", 12628);
    freq.put("ia", 12028);
    freq.put("ic", 10028);
    freq.put("ki ", 116);
    freq.put("ie", 17667);
    freq.put("id", 9689);
    freq.put("ig", 4371);
    freq.put("Oj", 77);
    freq.put("V ", 205);
    freq.put("Tit", 34);
    freq.put("ínc", 29);
    freq.put("ado", 6930);
    freq.put("iP", 137);
    freq.put("aki", 88);
    freq.put("frí", 64);
    freq.put("any", 107);
    freq.put("nun", 662);
    freq.put("ólo", 315);
    freq.put("Ike", 30);
    freq.put("Of", 82);
    freq.put("ep ", 59);
    freq.put("th ", 61);
    freq.put("mbr", 1118);
    freq.put("Dig", 41);
    freq.put("nin", 264);
    freq.put("nio", 298);
    freq.put("nil", 77);
    freq.put("nim", 360);
    freq.put("kis", 37);
    freq.put("nic", 856);
    freq.put("nia", 566);
    freq.put("nif", 217);
    freq.put("nig", 28);
    freq.put("nid", 643);
    freq.put("Ob", 46);
    freq.put("niz", 111);
    freq.put("kin", 112);
    freq.put("óv", 197);
    freq.put("kil", 59);
    freq.put("Y", 3168);
    freq.put("i ", 12131);
    freq.put("nip", 29);
    freq.put("bia", 560);
    freq.put("niv", 210);
    freq.put("RE ", 55);
    freq.put("kie", 71);
    freq.put("Mál", 64);
    freq.put("Va", 797);
    freq.put("LO ", 69);
    freq.put("aúl", 34);
    freq.put("Ve", 437);
    freq.put("aún", 163);
    freq.put("cae", 173);
    freq.put("Vi", 776);
    freq.put("Cá", 43);
    freq.put(" L ", 110);
    freq.put("epr", 155);
    freq.put("Vo", 267);
    freq.put("epo", 244);
    freq.put("epl", 33);
    freq.put("Vu", 71);
    freq.put("epi", 125);
    freq.put("Có", 197);
    freq.put("the", 115);
    freq.put("epe", 306);
    freq.put("iña", 144);
    freq.put("epc", 60);
    freq.put("epa", 443);
    freq.put("cam", 1449);
    freq.put("yen", 172);
    freq.put("yea", 37);
    freq.put("yec", 108);
    freq.put("rn ", 61);
    freq.put("¡¡ ", 38);
    freq.put("olí", 209);
    freq.put("Xav", 47);
    freq.put("oló", 44);
    freq.put("op ", 116);
    freq.put("zon", 222);
    freq.put("tró", 55);
    freq.put("yes", 67);
    freq.put("Ech", 62);
    freq.put("vig", 43);
    freq.put("hah", 327);
    freq.put("haj", 70);
    freq.put("hak", 29);
    freq.put("hal", 84);
    freq.put("ham", 209);
    freq.put("han", 893);
    freq.put("Sól", 63);
    freq.put("haa", 30);
    freq.put("hab", 1560);
    freq.put("hac", 2486);
    freq.put("had", 158);
    freq.put("Gar", 70);
    freq.put("eld", 89);
    freq.put("hag", 370);
    freq.put("Gan", 54);
    freq.put("haz", 97);
    freq.put("Gal", 78);
    freq.put("upo", 321);
    freq.put("Dir", 65);
    freq.put("hap", 42);
    freq.put("els", 165);
    freq.put("har", 761);
    freq.put("has", 1393);
    freq.put("hat", 120);
    freq.put("Gab", 31);
    freq.put("hav", 98);
    freq.put("elu", 90);
    freq.put("opt", 56);
    freq.put("opu", 130);
    freq.put("rni", 88);
    freq.put("rno", 558);
    freq.put("D", 7014);
    freq.put("Tro", 42);
    freq.put("Tra", 220);
    freq.put("ye ", 170);
    freq.put("rna", 445);
    freq.put("Tre", 47);
    freq.put("rne", 439);
    freq.put("Coc", 44);
    freq.put("ope", 275);
    freq.put("lce", 55);
    freq.put("opa", 353);
    freq.put("opc", 67);
    freq.put("opl", 43);
    freq.put("lco", 92);
    freq.put("ub ", 135);
    freq.put("opo", 268);
    freq.put("opi", 366);
    freq.put("lch", 31);
    freq.put("ige", 199);
    freq.put("bro", 451);
    freq.put("Arr", 35);
    freq.put("Ars", 55);
    freq.put("Art", 60);
    freq.put("vis", 1223);
    freq.put("ha ", 2525);
    freq.put("el ", 17539);
    freq.put("fón", 28);
    freq.put("eli", 1243);
    freq.put("Ara", 41);
    freq.put("Are", 27);
    freq.put("Arg", 56);
    freq.put("bn ", 28);
    freq.put("aud", 103);
    freq.put("ola", 1330);
    freq.put("www", 118);
    freq.put("tub", 104);
    freq.put("old", 54);
    freq.put("ole", 847);
    freq.put("olf", 29);
    freq.put("olg", 31);
    freq.put(" Ju", 494);
    freq.put("oli", 690);
    freq.put(" X ", 52);
    freq.put("oll", 708);
    freq.put("olo", 1387);
    freq.put("olp", 67);
    freq.put(" Jo", 484);
    freq.put("ols", 117);
    freq.put(" Ji", 41);
    freq.put("olu", 287);
    freq.put("olv", 537);
    freq.put(" Je", 188);
    freq.put("eer", 328);
    freq.put(" Ja", 732);
    freq.put("bre", 2154);
    freq.put("ick", 125);
    freq.put("rg ", 32);
    freq.put("ici", 2265);
    freq.put("ich", 603);
    freq.put("ico", 1846);
    freq.put("ump", 286);
    freq.put("for", 888);
    freq.put("icl", 91);
    freq.put("icc", 45);
    freq.put("ica", 3118);
    freq.put("ice", 965);
    freq.put("Hu", 143);
    freq.put("ume", 277);
    freq.put("Hi", 186);
    freq.put("uma", 247);
    freq.put("Ho", 876);
    freq.put("fob", 28);
    freq.put(" ex", 1331);
    freq.put("ics", 57);
    freq.put("icr", 58);
    freq.put("fon", 225);
    freq.put("Ha", 1068);
    freq.put("veg", 43);
    freq.put("icu", 192);
    freq.put("ict", 189);
    freq.put("ol ", 1005);
    freq.put("plu", 37);
    freq.put("sfu", 40);
    freq.put("arq", 85);
    freq.put("Muj", 29);
    freq.put(" Xa", 67);
    freq.put("un ", 6630);
    freq.put(" Ea", 30);
    freq.put("ple", 686);
    freq.put("ww ", 90);
    freq.put("pla", 952);
    freq.put("plo", 182);
    freq.put("rt", 6698);
    freq.put(" J ", 47);
    freq.put("pli", 457);
    freq.put("Le ", 89);
    freq.put("obo", 105);
    freq.put("obl", 444);
    freq.put("obj", 51);
    freq.put("ció", 2701);
    freq.put("obi", 232);
    freq.put("ic ", 273);
    freq.put("o", 229483);
    freq.put("oba", 443);
    freq.put("érc", 58);
    freq.put("utb", 129);
    freq.put("fo ", 111);
    freq.put("um ", 166);
    freq.put("cn ", 90);
    freq.put("zue", 45);
    freq.put("H ", 141);
    freq.put("obr", 1015);
    freq.put("obs", 73);
    freq.put("zul", 56);
    freq.put("xu", 77);
    freq.put("áne", 29);
    freq.put("soc", 325);
    freq.put("sob", 694);
    freq.put("ars", 514);
    freq.put("Cur", 51);
    freq.put("ppe", 33);
    freq.put("sof", 87);
    freq.put("soi", 61);
    freq.put("mbe", 45);
    freq.put("Fel", 146);
    freq.put("ahi", 134);
    freq.put("som", 254);
    freq.put("sol", 1259);
    freq.put("soo", 39);
    freq.put("son", 1821);
    freq.put("ánt", 108);
    freq.put("sop", 91);
    freq.put("Cue", 59);
    freq.put("sor", 354);
    freq.put("Fer", 116);
    freq.put("Fes", 44);
    freq.put("Cua", 361);
    freq.put("rv", 517);
    freq.put("soy", 543);
    freq.put("mbu", 47);
    freq.put("Cul", 34);
    freq.put("uno", 970);
    freq.put("Cui", 32);
    freq.put("zca", 84);
    freq.put("tem", 730);
    freq.put("né", 158);
    freq.put("art", 2384);
    freq.put("git", 86);
    freq.put("gis", 61);
    freq.put("ní", 331);
    freq.put("az ", 181);
    freq.put("ná", 116);
    freq.put("¿Có", 71);
    freq.put("tió", 82);
    freq.put("nú", 153);
    freq.put("gid", 91);
    freq.put("gic", 117);
    freq.put("gia", 126);
    freq.put("gio", 180);
    freq.put("gin", 372);
    freq.put("gim", 39);
    freq.put("nó", 159);
    freq.put("ír ", 37);
    freq.put("war", 66);
    freq.put("ten", 4013);
    freq.put("wap", 30);
    freq.put("so ", 3256);
    freq.put("ah ", 226);
    freq.put("pp ", 67);
    freq.put("án ", 819);
    freq.put(" ná", 29);
    freq.put("mb ", 139);
    freq.put("aul", 72);
    freq.put("xy ", 32);
    freq.put("efa", 44);
    freq.put("ved", 76);
    freq.put(" nú", 88);
    freq.put("ME ", 65);
    freq.put("¿De", 33);
    freq.put("Z", 339);
    freq.put("reu", 87);
    freq.put("ura", 1255);
    freq.put("Ros", 73);
    freq.put("ió ", 471);
    freq.put("mat", 463);
    freq.put("aja", 6898);
    freq.put("azo", 764);
    freq.put("iqu", 294);
    freq.put("aza", 390);
    freq.put("urc", 72);
    freq.put("Odi", 55);
    freq.put("xit", 75);
    freq.put("mi ", 2709);
    freq.put("olt", 141);
    freq.put("aná", 29);
    freq.put("áxi", 39);
    freq.put("Com", 592);
    freq.put("Voy", 150);
    freq.put("nno", 36);
    freq.put("nnn", 77);
    freq.put("uro", 975);
    freq.put("nL", 31);
    freq.put("ñor", 233);
    freq.put("nni", 31);
    freq.put("ué ", 1338);
    freq.put(" n ", 125);
    freq.put("nne", 39);
    freq.put("aha", 362);
    freq.put("imb", 65);
    freq.put("Pos", 38);
    freq.put("soñ", 56);
    freq.put("üe", 99);
    freq.put("Sig", 95);
    freq.put("D ", 1462);
    freq.put("Cuá", 94);
    freq.put("sq ", 46);
    freq.put("ós ", 54);
    freq.put("Sim", 77);
    freq.put("Sta", 54);
    freq.put("nh", 212);
    freq.put("ni", 6639);
    freq.put("nj", 194);
    freq.put("nk", 227);
    freq.put("gió", 37);
    freq.put("nm", 223);
    freq.put("nn", 341);
    freq.put("no", 20426);
    freq.put("tit", 599);
    freq.put("na", 17348);
    freq.put("nb", 30);
    freq.put("nc", 6769);
    freq.put("nd", 12935);
    freq.put("ne", 9991);
    freq.put("nf", 1085);
    freq.put("ng", 3940);
    freq.put("nx", 26);
    freq.put("ny", 303);
    freq.put("nz", 728);
    freq.put("tio", 423);
    freq.put("ES ", 191);
    freq.put("tid", 990);
    freq.put("nq", 668);
    freq.put("nr", 192);
    freq.put("ns", 4066);
    freq.put("nt", 20590);
    freq.put("nu", 2629);
    freq.put("nv", 1084);
    freq.put("tic", 1539);
    freq.put(" ni", 1481);
    freq.put("egó", 40);
    freq.put("E", 8805);
    freq.put("urr", 521);
    freq.put(" no", 12239);
    freq.put("Lea", 28);
    freq.put(" na", 1555);
    freq.put("abu", 338);
    freq.put("urs", 242);
    freq.put(" ne", 794);
    freq.put("squ", 325);
    freq.put("nn ", 51);
    freq.put("mun", 769);
    freq.put("elé", 91);
    freq.put("tec", 331);
    freq.put("arz", 31);
    freq.put("ño ", 1150);
    freq.put("ve ", 921);
    freq.put("alá", 105);
    freq.put("Ú", 64);
    freq.put(" nu", 1690);
    freq.put("FC ", 27);
    freq.put("aus", 125);
    freq.put("oig", 33);
    freq.put("n ", 49971);
    freq.put("Pob", 35);
    freq.put("elí", 135);
    freq.put("ías", 952);
    freq.put("afo", 78);
    freq.put("blo", 559);
    freq.put("rk ", 76);
    freq.put("azó", 217);
    freq.put("ti ", 626);
    freq.put("roh", 43);
    freq.put("roi", 83);
    freq.put("roj", 110);
    freq.put("rol", 358);
    freq.put("rom", 450);
    freq.put("¿y", 34);
    freq.put("roo", 99);
    freq.put("osq", 73);
    freq.put("pep", 33);
    freq.put("rob", 600);
    freq.put("¿t", 35);
    freq.put("¿s", 29);
    freq.put("roe", 44);
    freq.put("¿q", 96);
    freq.put("¿p", 56);
    freq.put("rox", 68);
    freq.put("¿n", 72);
    freq.put("roz", 66);
    freq.put("llo", 1768);
    freq.put("ob ", 28);
    freq.put("oso", 857);
    freq.put("rop", 632);
    freq.put("¿e", 59);
    freq.put("¿d", 29);
    freq.put("¿c", 55);
    freq.put("rou", 42);
    freq.put("¿a", 34);
    freq.put("Aqu", 172);
    freq.put("Gad", 45);
    freq.put("vet", 56);
    freq.put("ver", 3953);
    freq.put("ves", 583);
    freq.put("¿Y", 99);
    freq.put("aco", 564);
    freq.put("¿V", 40);
    freq.put("Dan", 109);
    freq.put("¿T", 105);
    freq.put("¿S", 108);
    freq.put("aj ", 229);
    freq.put("¿Q", 311);
    freq.put("¿P", 159);
    freq.put("¿O", 41);
    freq.put("¿N", 63);
    freq.put("¿M", 31);
    freq.put("¿L", 46);
    freq.put("ép", 49);
    freq.put("Mol", 65);
    freq.put("Dar", 31);
    freq.put("¿H", 59);
    freq.put("Qué", 435);
    freq.put("veo", 269);
    freq.put("¿E", 118);
    freq.put("¿D", 60);
    freq.put("¿C", 234);
    freq.put("¿A", 103);
    freq.put("xám", 41);
    freq.put(" do", 1945);
    freq.put("Má", 168);
    freq.put("pej", 41);
    freq.put("Cie", 71);
    freq.put("egú", 113);
    freq.put("ro ", 9095);
    freq.put("umb", 183);
    freq.put("Mé", 38);
    freq.put("Cin", 37);
    freq.put("fol", 219);
    freq.put("Ciu", 26);
    freq.put("Cit", 47);
    freq.put("erp", 147);
    freq.put("ll ", 292);
    freq.put("caa", 29);
    freq.put("umo", 152);
    freq.put("¿ ", 93);
    freq.put("dil", 147);
    freq.put("dim", 123);
    freq.put("gua", 1155);
    freq.put("óx", 163);
    freq.put("Da ", 26);
    freq.put("gue", 981);
    freq.put("ós", 97);
    freq.put("ór", 99);
    freq.put("gui", 1464);
    freq.put("ers", 1371);
    freq.put("gun", 1243);
    freq.put("dib", 73);
    freq.put("gul", 105);
    freq.put("gus", 974);
    freq.put("p", 62521);
    freq.put("ge ", 234);
    freq.put("ón", 4673);
    freq.put("óm", 511);
    freq.put("ól", 430);
    freq.put("óc", 32);
    freq.put("diu", 30);
    freq.put("div", 195);
    freq.put("He", 371);
    freq.put("óg", 92);
    freq.put(" de", 36206);
    freq.put("dir", 655);
    freq.put("ód", 68);
    freq.put("ó ", 1234);
    freq.put("ruj", 29);
    freq.put("Rey", 49);
    freq.put("M ", 309);
    freq.put(" Yo", 836);
    freq.put("lló", 75);
    freq.put(" Ya", 700);
    freq.put("Rep", 58);
    freq.put("Rev", 43);
    freq.put("ída", 40);
    freq.put("Ret", 43);
    freq.put("osé", 56);
    freq.put("nli", 66);
    freq.put("Gre", 44);
    freq.put("dev", 79);
    freq.put("llí", 113);
    freq.put("Gra", 682);
    freq.put("Rec", 176);
    freq.put("llá", 69);
    freq.put("Rea", 188);
    freq.put("IN ", 50);
    freq.put("Reg", 58);
    freq.put("Red", 60);
    freq.put("uls", 60);
    freq.put("erd", 2179);
    freq.put("úti", 33);
    freq.put("Aún", 38);
    freq.put("rum", 95);
    freq.put("tng", 29);
    freq.put("útb", 152);
    freq.put("zón", 238);
    freq.put("rub", 51);
    freq.put("Que", 1210);
    freq.put("bib", 52);
    freq.put("oer", 35);
    freq.put("Qui", 410);
    freq.put("Bor", 42);
    freq.put("rva", 93);
    freq.put("era", 4467);
    freq.put("Me", 2003);
    freq.put("Bos", 30);
    freq.put("Ma", 2227);
    freq.put("erb", 81);
    freq.put("Mc", 56);
    freq.put("ht ", 60);
    freq.put(" Y ", 1323);
    freq.put("Mo", 699);
    freq.put("deo", 526);
    freq.put("Mi", 846);
    freq.put("clo", 44);
    freq.put("rug", 110);
    freq.put("Mu", 731);
    freq.put("ze ", 28);
    freq.put("O", 1907);
    freq.put("Agu", 74);
    freq.put("My", 26);
    freq.put(" du", 850);
    freq.put("nga", 687);
    freq.put("box", 28);
    freq.put("ruz", 60);
    freq.put("EO ", 34);
    freq.put("arc", 792);
    freq.put("gué", 35);
    freq.put("bos", 100);
    freq.put("bot", 144);
    freq.put("guí", 44);
    freq.put("dee", 34);
    freq.put("HA ", 29);
    freq.put("ata", 1175);
    freq.put("bol", 496);
    freq.put("bom", 61);
    freq.put("bon", 353);
    freq.put("boo", 258);
    freq.put("PC ", 29);
    freq.put("iód", 33);
    freq.put("uve", 129);
    freq.put("jat", 39);
    freq.put("dió", 114);
    freq.put("ipc", 29);
    freq.put("ard", 952);
    freq.put("ipa", 305);
    freq.put("gái", 28);
    freq.put("ipe", 88);
    freq.put("ott", 64);
    freq.put("jar", 607);
    freq.put("ipi", 127);
    freq.put("ipo", 594);
    freq.put("ipl", 60);
    freq.put("ngi", 41);
    freq.put("ips", 33);
    freq.put("ré ", 678);
    freq.put("Lig", 66);
    freq.put("dia", 1801);
    freq.put("Mou", 175);
    freq.put("ipt", 28);
    freq.put("ipu", 105);
    freq.put("asó", 48);
    freq.put("afa", 114);
    freq.put("ufr", 95);
    freq.put("ugo", 42);
    freq.put("ofo", 33);
    freq.put("sh ", 72);
    freq.put("ayo", 310);
    freq.put(" Ka", 96);
    freq.put("Min", 58);
    freq.put(" Ke", 65);
    freq.put("aye", 350);
    freq.put("msu", 26);
    freq.put(" Ki", 84);
    freq.put("aya", 960);
    freq.put(" Ko", 30);
    freq.put("tés", 46);
    freq.put("msn", 29);
    freq.put("tén", 44);
    freq.put("zza", 31);
    freq.put(" Ku", 37);
    freq.put("ayu", 306);
    freq.put(" il", 152);
    freq.put("ul ", 86);
    freq.put("ca ", 3189);
    freq.put("Lin", 52);
    freq.put("ánd", 222);
    freq.put("Mon", 159);
    freq.put("mañ", 832);
    freq.put("ood", 103);
    freq.put("ip ", 107);
    freq.put("uar", 512);
    freq.put("Ben", 99);
    freq.put("ngr", 173);
    freq.put("Bel", 64);
    freq.put("F", 2213);
    freq.put("ool", 62);
    freq.put("ooo", 1237);
    freq.put("úbl", 123);
    freq.put("uz ", 117);
    freq.put("ook", 297);
    freq.put("Sob", 34);
    freq.put("ma ", 2518);
    freq.put("oos", 79);
    freq.put("oor", 63);
    freq.put("Ber", 105);
    freq.put("Bes", 80);
    freq.put("arg", 594);
    freq.put(" ib", 219);
    freq.put("Bet", 35);
    freq.put("ibi", 383);
    freq.put(" K ", 32);
    freq.put("ibl", 590);
    freq.put("ibo", 51);
    freq.put("só", 335);
    freq.put("iba", 346);
    freq.put("DO ", 118);
    freq.put("cap", 455);
    freq.put("flu", 49);
    freq.put("ibe", 268);
    freq.put("ult", 577);
    freq.put("vez", 745);
    freq.put("ñ", 5918);
    freq.put("fli", 109);
    freq.put("sé", 450);
    freq.put("uli", 140);
    freq.put("cao", 59);
    freq.put("ulo", 584);
    freq.put("sí", 1188);
    freq.put("cal", 1136);
    freq.put("fla", 91);
    freq.put("ulc", 57);
    freq.put("ibr", 365);
    freq.put("jaa", 199);
    freq.put("fle", 113);
    freq.put("ibu", 99);
    freq.put("Mic", 50);
    freq.put("ms ", 128);
    freq.put(" on", 278);
    freq.put(" oo", 27);
    freq.put(" ol", 299);
    freq.put("obe", 166);
    freq.put(" oj", 250);
    freq.put(" ok", 90);
    freq.put(" oh", 51);
    freq.put(" oi", 83);
    freq.put(" of", 354);
    freq.put("Rod", 41);
    freq.put(" od", 141);
    freq.put("uan", 1875);
    freq.put(" ob", 313);
    freq.put(" oc", 277);
    freq.put("Mig", 34);
    freq.put("spi", 281);
    freq.put("spl", 30);
    freq.put(" oy", 91);
    freq.put("spa", 1198);
    freq.put(" ot", 1102);
    freq.put("ío ", 279);
    freq.put(" or", 515);
    freq.put(" os", 586);
    freq.put(" op", 357);
    freq.put("dé ", 38);
    freq.put("rvi", 249);
    freq.put("zó ", 43);
    freq.put("nyo", 33);
    freq.put("arj", 35);
    freq.put("mel", 191);
    freq.put("Mie", 81);
    freq.put("s ", 84015);
    freq.put("fíc", 72);
    freq.put("fía", 69);
    freq.put("maq", 48);
    freq.put("mas", 1921);
    freq.put("mar", 1538);
    freq.put("din", 342);
    freq.put("ena", 2425);
    freq.put("íos", 58);
    freq.put("Mi ", 258);
    freq.put("ky ", 57);
    freq.put("áme", 43);
    freq.put(" o ", 1522);
    freq.put("mac", 317);
    freq.put("enc", 2655);
    freq.put("mae", 34);
    freq.put("mad", 961);
    freq.put("mag", 357);
    freq.put("mai", 97);
    freq.put("neg", 216);
    freq.put("maj", 60);
    freq.put("mam", 222);
    freq.put("mal", 1218);
    freq.put("¿Al", 47);
    freq.put("ene", 3782);
    freq.put("ght", 51);
    freq.put("sy", 42);
    freq.put("dio", 1167);
    freq.put("déi", 57);
    freq.put("ss", 1001);
    freq.put("sr", 49);
    freq.put("déf", 33);
    freq.put("sp", 4414);
    freq.put("sv", 67);
    freq.put("su", 4910);
    freq.put("st", 21112);
    freq.put("q", 31397);
    freq.put("enh", 51);
    freq.put("si", 12446);
    freq.put("sh", 309);
    freq.put("so", 10078);
    freq.put("sn", 147);
    freq.put("sm", 1269);
    freq.put("sl", 195);
    freq.put("sc", 3328);
    freq.put("sb", 92);
    freq.put("sa", 11283);
    freq.put("sg", 159);
    freq.put("sf", 409);
    freq.put("se", 15618);
    freq.put("dés", 30);
    freq.put("eí", 250);
    freq.put("Ru", 203);
    freq.put("lse", 53);
    freq.put("ro", 16690);
    freq.put("lsa", 140);
    freq.put("Jav", 45);
    freq.put("Chi", 157);
    freq.put("ttp", 107);
    freq.put("eá", 27);
    freq.put("bié", 551);
    freq.put("lsi", 34);
    freq.put("cañ", 64);
    freq.put("Re", 929);
    freq.put("Chr", 29);
    freq.put("Jam", 35);
    freq.put("ñn ", 33);
    freq.put("Ra", 411);
    freq.put("lía", 59);
    freq.put("Señ", 52);
    freq.put("tta", 37);
    freq.put("Ro", 420);
    freq.put("eñ", 1102);
    freq.put("Ri", 187);
    freq.put("eó", 92);
    freq.put("sod", 39);
    freq.put(" aa", 54);
    freq.put(" ab", 924);
    freq.put(" ac", 2207);
    freq.put(" ad", 577);
    freq.put(" ae", 54);
    freq.put(" af", 214);
    freq.put(" ag", 723);
    freq.put(" ah", 1363);
    freq.put(" ai", 173);
    freq.put("jil", 26);
    freq.put(" ak", 36);
    freq.put("jij", 94);
    freq.put(" am", 1492);
    freq.put(" an", 1765);
    freq.put("tie", 2909);
    freq.put(" ap", 1259);
    freq.put(" aq", 777);
    freq.put(" ar", 856);
    freq.put(" as", 1422);
    freq.put(" at", 471);
    freq.put("jis", 29);
    freq.put(" av", 394);
    freq.put("nsa", 1207);
    freq.put(" ay", 556);
    freq.put(" az", 77);
    freq.put("gel", 135);
    freq.put("Tue", 40);
    freq.put("coi", 32);
    freq.put("ejó", 35);
    freq.put("nol", 139);
    freq.put("nom", 374);
    freq.put("non", 97);
    freq.put("noo", 72);
    freq.put("ulp", 163);
    freq.put("hop", 35);
    freq.put("ls ", 269);
    freq.put("Mel", 41);
    freq.put("uge", 39);
    freq.put("ros", 1803);
    freq.put("gam", 129);
    freq.put("aes", 73);
    freq.put("noc", 1238);
    freq.put("ert", 2361);
    freq.put("orí", 114);
    freq.put("R ", 386);
    freq.put("nsf", 33);
    freq.put("noz", 93);
    freq.put("▸", 79);
    freq.put("not", 311);
    freq.put("sht", 26);
    freq.put("nov", 315);
    freq.put(" us", 417);
    freq.put("Ja ", 32);
    freq.put("nos", 3825);
    freq.put(" a ", 14212);
    freq.put("así", 530);
    freq.put("ji ", 37);
    freq.put("áci", 92);
    freq.put("óri", 29);
    freq.put("sos", 723);
    freq.put("Vía", 39);
    freq.put("omo", 3002);
    freq.put(" wo", 33);
    freq.put("did", 646);
    freq.put("sot", 340);
    freq.put("em", 7745);
    freq.put("el", 25008);
    freq.put("eo", 2831);
    freq.put("en", 50167);
    freq.put("ei", 898);
    freq.put("eh", 376);
    freq.put("ek", 77);
    freq.put("ej", 3755);
    freq.put("ee", 2352);
    freq.put("ed", 5786);
    freq.put("eg", 5656);
    freq.put("ef", 1163);
    freq.put("ea", 3728);
    freq.put("rl ", 34);
    freq.put("ec", 8893);
    freq.put("eb", 2194);
    freq.put("Luc", 66);
    freq.put("ey", 534);
    freq.put("ex", 1830);
    freq.put("ez", 2274);
    freq.put("eu", 598);
    freq.put("et", 4718);
    freq.put("ew", 95);
    freq.put("ev", 3371);
    freq.put("eq", 695);
    freq.put("ep", 1958);
    freq.put("es", 47771);
    freq.put("er", 38267);
    freq.put("EN ", 101);
    freq.put("Jor", 52);
    freq.put("ejo", 1608);
    freq.put("nib", 127);
    freq.put("eji", 45);
    freq.put("sha", 44);
    freq.put("eje", 904);
    freq.put("eja", 1045);
    freq.put("blr", 39);
    freq.put(" añ", 951);
    freq.put("Job", 30);
    freq.put("Jod", 107);
    freq.put("dif", 350);
    freq.put("os ", 27691);
    freq.put("ble", 1519);
    freq.put("vea", 128);
    freq.put(" aú", 167);
    freq.put("ula", 714);
    freq.put("bla", 913);
    freq.put("Jon", 36);
    freq.put("on ", 8291);
    freq.put("àc", 34);
    freq.put("rlo", 753);
    freq.put("rli", 28);
    freq.put("RT ", 982);
    freq.put("G", 2693);
    freq.put("rle", 408);
    freq.put("ort", 1603);
    freq.put("oru", 39);
    freq.put("rla", 382);
    freq.put("e ", 101314);
    freq.put("orp", 170);
    freq.put("orq", 1055);
    freq.put("orn", 277);
    freq.put("qi", 53);
    freq.put("orl", 50);
    freq.put("ci ", 126);
    freq.put("ork", 67);
    freq.put("ven", 1528);
    freq.put("ori", 1138);
    freq.put("orf", 72);
    freq.put("org", 230);
    freq.put("ord", 677);
    freq.put("ore", 1392);
    freq.put("orb", 43);
    freq.put("orc", 166);
    freq.put("gir", 136);
    freq.put("Apr", 54);
    freq.put("App", 102);
    freq.put("ej ", 28);
    freq.put("Jo ", 41);
    freq.put("cán", 77);
    freq.put("cám", 47);
    freq.put("yun", 133);
    freq.put("aen", 51);
    freq.put("aka", 50);
    freq.put(" ce", 990);
    freq.put("lay", 307);
    freq.put("onj", 45);
    freq.put("xk", 28);
    freq.put("zal", 27);
    freq.put("xi", 822);
    freq.put("prá", 34);
    freq.put("ff", 377);
    freq.put("onl", 61);
    freq.put("onm", 106);
    freq.put("ttl", 27);
    freq.put("xc", 202);
    freq.put("zad", 269);
    freq.put("xa", 341);
    freq.put("pré", 28);
    freq.put("rgu", 167);
    freq.put("xd", 205);
    freq.put("xe", 130);
    freq.put("onz", 62);
    freq.put("má ", 59);
    freq.put("xx", 33);
    freq.put("xy", 38);
    freq.put("pró", 164);
    freq.put("Dos", 47);
    freq.put("Ire", 36);
    freq.put("ons", 1194);
    freq.put("xp", 458);
    freq.put("xq", 96);
    freq.put("onv", 321);
    freq.put("zas", 171);
    freq.put("xt", 399);
    freq.put("Eur", 170);
    freq.put("iam", 156);
    freq.put("ial", 1121);
    freq.put("ian", 766);
    freq.put("¬ ", 83);
    freq.put("iaj", 176);
    freq.put("iad", 454);
    freq.put("iag", 76);
    freq.put("rmu", 29);
    freq.put("iaa", 80);
    freq.put("gie", 65);
    freq.put("iac", 82);
    freq.put("iab", 58);
    freq.put("vem", 121);
    freq.put("Tot", 32);
    freq.put("ule", 115);
    freq.put("¿No", 49);
    freq.put("iat", 81);
    freq.put("Otr", 106);
    freq.put("Dó", 31);
    freq.put("ias", 2285);
    freq.put("iar", 738);
    freq.put("ty ", 149);
    freq.put("hue", 238);
    freq.put(" Zo", 41);
    freq.put("uía", 65);
    freq.put("mát", 92);
    freq.put("hub", 151);
    freq.put("huc", 35);
    freq.put(" Ze", 27);
    freq.put("hum", 204);
    freq.put("x ", 777);
    freq.put("dic", 1618);
    freq.put(" Za", 145);
    freq.put("za ", 1275);
    freq.put("ebi", 96);
    freq.put("rí ", 30);
    freq.put("hup", 53);
    freq.put("hur", 63);
    freq.put("SE ", 38);
    freq.put("bve", 27);
    freq.put(" ya", 2477);
    freq.put("Ya ", 681);
    freq.put("Mis", 93);
    freq.put("mán", 64);
    freq.put("clá", 34);
    freq.put("gil", 135);
    freq.put("erò", 38);
    freq.put("rza", 119);
    freq.put("rzo", 58);
    freq.put("Ali", 64);
    freq.put("ia ", 5463);
    freq.put("ncó", 26);
    freq.put("al ", 7292);
    freq.put("Alf", 29);
    freq.put("r", 152149);
    freq.put("nie", 297);
    freq.put("IS ", 69);
    freq.put("kyp", 29);
    freq.put("pre", 3369);
    freq.put("saj", 147);
    freq.put("ang", 264);
    freq.put("pra", 412);
    freq.put("san", 813);
    freq.put("sam", 201);
    freq.put("sal", 1562);
    freq.put("sac", 466);
    freq.put("Alb", 90);
    freq.put("saa", 43);
    freq.put("xá", 41);
    freq.put("reo", 933);
    freq.put("ani", 923);
    freq.put("anj", 92);
    freq.put("sad", 666);
    freq.put("pru", 111);
    freq.put("saz", 30);
    freq.put("say", 127);
    freq.put("ry ", 212);
    freq.put("gab", 55);
    freq.put("ans", 646);
    freq.put("sas", 1219);
    freq.put("sar", 1038);
    freq.put("saq", 43);
    freq.put("sap", 110);
    freq.put("íne", 40);
    freq.put("anz", 357);
    freq.put("sat", 92);
    freq.put("Do", 339);
    freq.put("omm", 34);
    freq.put("rmi", 864);
    freq.put("Pho", 96);
    freq.put("Di", 792);
    freq.put("vei", 38);
    freq.put("¬¬", 143);
    freq.put("De", 1531);
    freq.put(" án", 69);
    freq.put("Da", 330);
    freq.put("ás ", 2798);
    freq.put("TE ", 123);
    freq.put(" ár", 48);
    freq.put("PP ", 132);
    freq.put("üen", 68);
    freq.put("xac", 51);
    freq.put("Du", 142);
    freq.put("Dr", 75);
    freq.put("ts ", 411);
    freq.put("anó", 27);
    freq.put("Día", 49);
    freq.put("all", 1313);
    freq.put("bía", 278);
    freq.put("an ", 6453);
    freq.put("Soy", 115);
    freq.put("ló ", 44);
    freq.put("Ofe", 48);
    freq.put("sa ", 3196);
    freq.put("ál ", 59);
    freq.put("uya", 78);
    freq.put("bvi", 28);
    freq.put(" ye", 75);
    freq.put("uye", 76);
    freq.put("Sha", 42);
    freq.put("erí", 708);
    freq.put("ín ", 155);
    freq.put("tte", 715);
    freq.put("rò ", 39);
    freq.put("uyo", 153);
    freq.put("zo ", 792);
    freq.put(" Le", 444);
    freq.put("luv", 81);
    freq.put(" La", 2359);
    freq.put("oxe", 27);
    freq.put(" Lo", 1486);
    freq.put(" Ll", 260);
    freq.put(" Li", 380);
    freq.put(" Lu", 243);
    freq.put("ò", 116);
    freq.put("MG ", 27);
    freq.put("axi", 43);
    freq.put("Web", 33);
    freq.put(" € ", 164);
    freq.put("fes", 327);
    freq.put("Sky", 26);
    freq.put("nla", 83);
    freq.put(" p ", 67);
    freq.put("UY ", 26);
    freq.put("naa", 53);
    freq.put("lí ", 125);
    freq.put("uem", 107);
    freq.put("dy ", 125);
    freq.put("uf", 354);
    freq.put("tiu", 26);
    freq.put("We", 96);
    freq.put("Wa", 92);
    freq.put("Wo", 65);
    freq.put("ce ", 2464);
    freq.put("lub", 129);
    freq.put("Wi", 131);
    freq.put("Wh", 42);
    freq.put("tne", 28);
    freq.put("air", 105);
    freq.put("bez", 180);
    freq.put(" só", 261);
    freq.put("É ", 35);
    freq.put("Tar", 69);
    freq.put(" ps", 76);
    freq.put(" pr", 5017);
    freq.put(" pq", 75);
    freq.put("íe", 69);
    freq.put(" pu", 3644);
    freq.put("get", 36);
    freq.put("H", 3001);
    freq.put("lít", 170);
    freq.put("sss", 276);
    freq.put("jó", 139);
    freq.put(" pc", 27);
    freq.put(" pa", 10381);
    freq.put("àci", 32);
    freq.put("ssi", 180);
    freq.put("jé", 39);
    freq.put(" pe", 7415);
    freq.put("sse", 58);
    freq.put("dit", 288);
    freq.put(" pi", 1823);
    freq.put("líc", 118);
    freq.put(" po", 9791);
    freq.put("gen", 1661);
    freq.put("gem", 37);
    freq.put(" pl", 941);
    freq.put("W ", 42);
    freq.put("cid", 843);
    freq.put("lum", 103);
    freq.put("Vol", 49);
    freq.put("ó", 7740);
    freq.put("wer", 87);
    freq.put("boy", 27);
    freq.put("lun", 232);
    freq.put("alf", 27);
    freq.put("mmm", 167);
    freq.put("uti", 269);
    freq.put("ráp", 64);
    freq.put(" Úl", 39);
    freq.put("cio", 3324);
    freq.put(" sí", 483);
    freq.put("jor", 1270);
    freq.put("cin", 597);
    freq.put("bió", 31);
    freq.put("jos", 385);
    freq.put("alg", 1845);
    freq.put("cim", 294);
    freq.put("rme", 1157);
    freq.put("tu ", 1636);
    freq.put("eb ", 160);
    freq.put("cil", 430);
    freq.put("j ", 335);
    freq.put("rmo", 174);
    freq.put("cis", 226);
    freq.put("nis", 311);
    freq.put(" sá", 87);
    freq.put("ítu", 116);
    freq.put("cir", 615);
    freq.put("xa ", 77);
    freq.put("uza", 50);
    freq.put("vel", 267);
    freq.put("bsu", 30);
    freq.put("cip", 265);
    freq.put(" pú", 106);
    freq.put("uga", 760);
    freq.put("tú ", 306);
    freq.put("civ", 34);
    freq.put("fir", 214);
    freq.put("tus", 321);
    freq.put("ciu", 157);
    freq.put("uns", 45);
    freq.put("tup", 79);
    freq.put("ju", 1741);
    freq.put("tur", 873);
    freq.put("cit", 370);
    freq.put("tut", 71);
    freq.put("aíd", 74);
    freq.put("tuv", 209);
    freq.put("ale", 2248);
    freq.put("dip", 56);
    freq.put(" pá", 118);
    freq.put("jo", 3857);
    freq.put("tul", 270);
    freq.put("kea", 33);
    freq.put("jj", 352);
    freq.put("je", 2599);
    freq.put("aís", 180);
    freq.put("tuc", 233);
    freq.put("tud", 411);
    freq.put("ja", 11468);
    freq.put("écn", 35);
    freq.put(" be", 737);
    freq.put("z", 7657);
    freq.put(" ba", 1699);
    freq.put("fit", 37);
    freq.put("tui", 202);
    freq.put(" bl", 382);
    freq.put(" bo", 1030);
    freq.put(" bi", 1511);
    freq.put("S", 6765);
    freq.put("vui", 27);
    freq.put(" bu", 2028);
    freq.put("s", 176655);
    freq.put("odr", 349);
    freq.put(" br", 378);
    freq.put(" ¡T", 28);
    freq.put("gón", 29);
    freq.put(" by", 39);
    freq.put("ji", 355);
    freq.put("uci", 600);
    freq.put("tun", 134);
    freq.put("poy", 140);
    freq.put("yn ", 33);
    freq.put("pot", 141);
    freq.put("por", 7095);
    freq.put("pos", 887);
    freq.put("pop", 47);
    freq.put("poq", 83);
    freq.put("pon", 1524);
    freq.put("poo", 33);
    freq.put("pol", 722);
    freq.put("rú", 29);
    freq.put("íb", 90);
    freq.put("ños", 881);
    freq.put("pod", 835);
    freq.put("OE ", 100);
    freq.put("pob", 127);
    freq.put("poc", 923);
    freq.put("mbé", 27);
    freq.put("pañ", 1144);
    freq.put("ket", 113);
    freq.put(" Má", 161);
    freq.put("fic", 1088);
    freq.put("Bur", 27);
    freq.put("Bus", 77);
    freq.put("dis", 1174);
    freq.put(" Mé", 38);
    freq.put("▸ ", 75);
    freq.put("ei ", 42);
    freq.put("fia", 105);
    freq.put("bab", 89);
    freq.put("nit", 556);
    freq.put("rà", 95);
    freq.put("tug", 44);
    freq.put("paí", 139);
    freq.put("Bue", 829);
    freq.put("osi", 525);
    freq.put("nís", 35);
    freq.put("É", 42);
    freq.put("agó", 27);
    freq.put(" Oy", 39);
    freq.put("odu", 151);
    freq.put("vue", 768);
    freq.put("nna", 43);
    freq.put("clu", 289);
    freq.put("ahí", 188);
    freq.put("po ", 1202);
    freq.put("aid", 60);
    freq.put("eis", 294);
    freq.put("eir", 82);
    freq.put("eit", 45);
    freq.put("ary", 26);
    freq.put("au ", 67);
    freq.put("eix", 57);
    freq.put("ank", 94);
    freq.put("eia", 29);
    freq.put("CO ", 33);
    freq.put("tel", 766);
    freq.put("eib", 56);
    freq.put("eid", 47);
    freq.put("ein", 155);
    freq.put("ive", 673);
    freq.put("uia", 46);
    freq.put("iva", 757);
    freq.put("éti", 93);
    freq.put("seg", 1280);
    freq.put("ivo", 602);
    freq.put("ivi", 546);
    freq.put("oi ", 38);
    freq.put("Bar", 465);
    freq.put("tái", 57);
    freq.put("otó", 54);
    freq.put("Bas", 33);
    freq.put("pap", 266);
    freq.put(" Me", 1964);
    freq.put("par", 7339);
    freq.put("pas", 1997);
    freq.put("pat", 378);
    freq.put(" Ma", 2190);
    freq.put(" Mc", 55);
    freq.put("chi", 752);
    freq.put("paz", 116);
    freq.put(" Mo", 684);
    freq.put(" Mi", 828);
    freq.put("Lov", 51);
    freq.put("Sin", 105);
    freq.put(" Mu", 708);
    freq.put("pab", 45);
    freq.put("pac", 286);
    freq.put("pad", 387);
    freq.put("pag", 401);
    freq.put("I ", 464);
    freq.put("paj", 42);
    freq.put("Sil", 42);
    freq.put("pal", 517);
    freq.put("pam", 46);
    freq.put("pan", 394);
    freq.put("oin", 49);
    freq.put("nge", 254);
    freq.put("nac", 303);
    freq.put("I", 1729);
    freq.put("oid", 92);
    freq.put("Men", 176);
    freq.put("gru", 171);
    freq.put("osh", 33);
    freq.put("nl", 197);
    freq.put("mpa", 672);
    freq.put("ois", 87);
    freq.put("Ji", 42);
    freq.put("Mat", 77);
    freq.put(" M ", 95);
    freq.put("tiz", 69);
    freq.put("uju", 42);
    freq.put("Is", 80);
    freq.put("Ir", 113);
    freq.put("It", 47);
    freq.put("eto", 372);
    freq.put("pa ", 1246);
    freq.put("May", 43);
    freq.put("Ik", 30);
    freq.put("ujo", 74);
    freq.put("Im", 110);
    freq.put("aic", 88);
    freq.put("toy", 1160);
    freq.put("In", 619);
    freq.put("cce", 66);
    freq.put("ntí", 63);
    freq.put("uvo", 47);
    freq.put("Ib", 71);
    freq.put("Id", 29);
    freq.put("Ig", 90);
    freq.put("cer", 2078);
    freq.put("¡¡", 267);
    freq.put("ác", 175);
    freq.put("áb", 140);
    freq.put(" qu", 23208);
    freq.put("ág", 173);
    freq.put("áf", 87);
    freq.put("ái", 226);
    freq.put("tip", 186);
    freq.put("ps ", 123);
    freq.put("vid", 1482);
    freq.put("ám", 139);
    freq.put("ál", 259);
    freq.put("án", 1344);
    freq.put("áp", 90);
    freq.put("ás", 3024);
    freq.put("ár", 178);
    freq.put(" qe", 141);
    freq.put("uid", 432);
    freq.put(" qi", 28);
    freq.put("mo ", 4909);
    freq.put("ys", 120);
    freq.put("cn", 232);
    freq.put("til", 520);
    freq.put("ún ", 529);
    freq.put("cm", 32);
    freq.put("tim", 817);
    freq.put("BA ", 40);
    freq.put(" cá", 100);
    freq.put("tin", 870);
    freq.put("iós", 46);
    freq.put("puñ", 33);
    freq.put("ot ", 126);
    freq.put(" ge", 1211);
    freq.put("Les", 43);
    freq.put("vé", 88);
    freq.put(" có", 237);
    freq.put("Sí ", 140);
    freq.put("ami", 1495);
    freq.put("á ", 2683);
    freq.put("psi", 46);
    freq.put("pso", 40);
    freq.put("amo", 2678);
    freq.put("ást", 83);
    freq.put("mos", 4560);
    freq.put("mor", 795);
    freq.put(" ga", 1293);
    freq.put("ame", 1419);
    freq.put("mov", 207);
    freq.put("mou", 50);
    freq.put("mot", 207);
    freq.put(" q ", 2469);
    freq.put("moj", 68);
    freq.put("ása", 31);
    freq.put("ími", 45);
    freq.put("mon", 625);
    freq.put("mom", 353);
    freq.put("gro", 273);
    freq.put("moc", 254);
    freq.put("Tal", 33);
    freq.put("ási", 55);
    freq.put("lés", 95);
    freq.put("amu", 52);
    freq.put("tif", 135);
    freq.put("mod", 313);
    freq.put("oí", 55);
    freq.put("tig", 281);
    freq.put("Pil", 26);
    freq.put("Pin", 38);
    freq.put("aví", 136);
    freq.put("úni", 175);
    freq.put("Pie", 43);
    freq.put("ací", 79);
    freq.put("tia", 429);
    freq.put("aro", 962);
    freq.put("t", 106770);
    freq.put("Piq", 31);
    freq.put("gri", 287);
    freq.put("Pit", 41);
    freq.put("oñ", 323);
    freq.put("pok", 26);
    freq.put("oní", 56);
    freq.put("ezu", 31);
    freq.put("Nec", 68);
    freq.put("Lev", 34);
    freq.put("cs", 93);
    freq.put("alt", 832);
    freq.put("ezo", 79);
    freq.put("Tan", 57);
    freq.put("cr", 2833);
    freq.put("New", 31);
    freq.put("uic", 82);
    freq.put("anu", 298);
    freq.put("eza", 824);
    freq.put("ezc", 121);
    freq.put("Med", 91);
    freq.put(" ch", 1164);
    freq.put(" ci", 1061);
    freq.put(" cn", 100);
    freq.put(" co", 16585);
    freq.put(" cl", 794);
    freq.put("Mua", 26);
    freq.put(" cc", 86);
    freq.put(" ca", 7343);
    freq.put("Hol", 212);
    freq.put("o ", 95840);
    freq.put("Met", 46);
    freq.put("uo ", 60);
    freq.put("´", 51);
    freq.put("Mes", 117);
    freq.put("Mer", 105);
    freq.put(" cr", 1866);
    freq.put("Sue", 78);
    freq.put("NE ", 32);
    freq.put(" cu", 3807);
    freq.put("amé", 34);
    freq.put("Res", 74);
    freq.put("amá", 108);
    freq.put("mpi", 493);
    freq.put("édi", 55);
    freq.put("alr", 27);
    freq.put("nme", 51);
    freq.put("acc", 208);
    freq.put("fác", 82);
    freq.put("oro", 336);
    freq.put("ez ", 1121);
    freq.put("tv ", 52);
    freq.put("nmi", 111);
    freq.put("oo", 2717);
    freq.put("on", 23206);
    freq.put("om", 8751);
    freq.put("ol", 7641);
    freq.put("ok", 508);
    freq.put("oj", 887);
    freq.put("oi", 424);
    freq.put("oh", 306);
    freq.put("og", 1472);
    freq.put("of", 792);
    freq.put("oe", 266);
    freq.put("od", 5571);
    freq.put("oc", 5310);
    freq.put("ob", 2690);
    freq.put("oa", 224);
    freq.put("acl", 29);
    freq.put("ngo", 1654);
    freq.put("Si ", 955);
    freq.put("oz", 444);
    freq.put("oy", 4959);
    freq.put("ox", 189);
    freq.put("ow", 345);
    freq.put("ov", 1254);
    freq.put("ou", 791);
    freq.put("ot", 4440);
    freq.put("os", 33096);
    freq.put("or", 22559);
    freq.put("oq", 311);
    freq.put("op", 1767);
    freq.put("LE ", 58);
    freq.put("Ni", 299);
    freq.put("bje", 56);
    freq.put("ys ", 83);
    freq.put("No", 2139);
    freq.put("uié", 203);
    freq.put("Na", 342);
    freq.put("aí", 297);
    freq.put("Ne", 281);
    freq.put("méd", 29);
    freq.put("añ", 3680);
    freq.put("Ade", 68);
    freq.put("yas", 108);
    freq.put("orm", 1447);
    freq.put("car", 2084);
    freq.put("aú", 206);
    freq.put("Nu", 337);
    freq.put("Adi", 45);
    freq.put("het", 37);
    freq.put("loc", 338);
    freq.put("loa", 34);
    freq.put("log", 492);
    freq.put("her", 493);
    freq.put("hes", 331);
    freq.put("loj", 84);
    freq.put("lli", 233);
    freq.put("EL ", 107);
    freq.put("lon", 629);
    freq.put("loo", 93);
    freq.put("lol", 51);
    freq.put("lom", 87);
    freq.put("ode", 827);
    freq.put("hee", 27);
    freq.put("loq", 80);
    freq.put("lov", 121);
    freq.put("low", 164);
    freq.put("lot", 165);
    freq.put("hec", 442);
    freq.put("hel", 130);
    freq.put("hem", 200);
    freq.put("hen", 37);
    freq.put("ehh", 37);
    freq.put("jua", 56);
    freq.put("uin", 186);
    freq.put("jug", 532);
    freq.put("jud", 47);
    freq.put("jue", 435);
    freq.put("N ", 488);
    freq.put("caf", 84);
    freq.put("J", 2464);
    freq.put("jun", 222);
    freq.put("na ", 9100);
    freq.put("jul", 31);
    freq.put("jur", 51);
    freq.put("jus", 203);
    freq.put("rje", 37);
    freq.put("juv", 34);
    freq.put("yy ", 53);
    freq.put("rja", 27);
    freq.put("yad", 26);
    freq.put(" su", 3997);
    freq.put("tín", 49);
    freq.put("mpr", 1529);
    freq.put("Un ", 559);
    freq.put("lo ", 9855);
    freq.put("ZP ", 41);
    freq.put("lca", 220);
    freq.put("¡No", 31);
    freq.put(" sh", 65);
    freq.put("pá ", 37);
    freq.put("as ", 22311);
    freq.put("he ", 2322);
    freq.put("eh ", 258);
    freq.put("Win", 42);
    freq.put(" sn", 26);
    freq.put("bró", 33);
    freq.put("age", 262);
    freq.put("mps", 39);
    freq.put("aa", 2173);
    freq.put("oth", 33);
    freq.put("ac", 12169);
    freq.put("ab", 8307);
    freq.put("ae", 535);
    freq.put("ad", 17248);
    freq.put("ag", 2955);
    freq.put("af", 751);
    freq.put("ai", 1313);
    freq.put("ah", 2050);
    freq.put("ak", 314);
    freq.put("aj", 8904);
    freq.put("am", 10023);
    freq.put("al", 20302);
    freq.put("ao", 451);
    freq.put("an", 26766);
    freq.put("aq", 1046);
    freq.put("ap", 3262);
    freq.put("Ese", 64);
    freq.put("ar", 30921);
    freq.put("au", 1419);
    freq.put("at", 5326);
    freq.put("aw", 67);
    freq.put("av", 1882);
    freq.put("ay", 3804);
    freq.put("ax", 119);
    freq.put("afí", 55);
    freq.put("az", 1767);
    freq.put("Hot", 35);
    freq.put("Hoy", 423);
    freq.put("uí", 663);
    freq.put("igu", 1079);
    freq.put("inL", 27);
    freq.put("FP ", 27);
    freq.put("utó", 26);
    freq.put("Lad", 42);
    freq.put("zás", 32);
    freq.put("aji", 44);
    freq.put("oto", 928);
    freq.put("Jaj", 474);
    freq.put("SS ", 28);
    freq.put("aS", 27);
    freq.put("ús ", 52);
    freq.put("iga", 875);
    freq.put("ota", 726);
    freq.put("igo", 1330);
    freq.put("ign", 294);
    freq.put("you", 80);
    freq.put("igl", 70);
    freq.put("yos", 55);
    freq.put("yor", 226);
    freq.put("igi", 258);
    freq.put("igh", 59);
    freq.put("a ", 110083);
    freq.put("lga", 249);
    freq.put("sto", 3973);
    freq.put("uie", 2797);
    freq.put("ru", 1715);
    freq.put("sia", 337);
    freq.put("oh ", 83);
    freq.put(" zo", 103);
    freq.put("úa ", 34);
    freq.put("rpo", 122);
    freq.put("Es ", 665);
    freq.put("Hor", 63);
    freq.put("agu", 357);
    freq.put("rq", 1196);
    freq.put("at ", 356);
    freq.put("Nov", 26);
    freq.put("mud", 33);
    freq.put("Bru", 28);
    freq.put("zqu", 63);
    freq.put("La ", 1779);
    freq.put("yo ", 2460);
    freq.put("Bro", 34);
    freq.put("u", 103461);
    freq.put("NA ", 68);
    freq.put("Bri", 52);
    freq.put("ig ", 57);
    freq.put("uit", 660);
    freq.put("Bre", 28);
    freq.put("úsi", 145);
    freq.put("Bra", 83);
    freq.put("pto", 69);
    freq.put("alo", 891);
    freq.put("sco", 661);
    freq.put("alm", 491);
    freq.put("sci", 202);
    freq.put("sch", 37);
    freq.put("pti", 306);
    freq.put("lr ", 36);
    freq.put("sce", 135);
    freq.put("iu ", 53);
    freq.put("pte", 43);
    freq.put("nía", 259);
    freq.put("sca", 963);
    freq.put("lly", 46);
    freq.put("Oye", 38);
    freq.put("ry", 288);
    freq.put("árb", 37);
    freq.put("eda", 1407);
    freq.put("ndu", 169);
    freq.put("rz", 195);
    freq.put("Fie", 29);
    freq.put("scu", 753);
    freq.put("gs", 48);
    freq.put("fa ", 141);
    freq.put("alu", 486);
    freq.put("Fin", 82);
    freq.put("otr", 1387);
    freq.put("alp", 27);
    freq.put("gr", 3652);
    freq.put("smo", 908);
    freq.put("tz", 75);
    freq.put("ron", 1094);
    freq.put("tx", 55);
    freq.put("ty", 173);
    freq.put("tv", 73);
    freq.put(" N ", 36);
    freq.put("tt", 1033);
    freq.put("tu", 5444);
    freq.put("tr", 9487);
    freq.put("ts", 535);
    freq.put("tp", 141);
    freq.put("tn", 66);
    freq.put("to", 18880);
    freq.put("tl", 187);
    freq.put("tm", 139);
    freq.put("tj", 30);
    freq.put("th", 283);
    freq.put("ti", 12796);
    freq.put("tg", 30);
    freq.put("te", 24107);
    freq.put("tb", 430);
    freq.put("tc", 170);
    freq.put("ta", 25250);
    freq.put("lre", 29);
    freq.put("edi", 1266);
    freq.put("smi", 88);
    freq.put("iun", 40);
    freq.put("far", 103);
    freq.put("fas", 118);
    freq.put("mpl", 804);
    freq.put("rc", 1978);
    freq.put("fav", 372);
    freq.put("iud", 181);
    freq.put("fat", 44);
    freq.put("zá", 80);
    freq.put("rl", 1675);
    freq.put("mpu", 136);
    freq.put(" rá", 68);
    freq.put("gy", 27);
    freq.put("fal", 598);
    freq.put("rm", 3656);
    freq.put(" rí", 46);
    freq.put("fac", 268);
    freq.put("rog", 306);
    freq.put("sme", 31);
    freq.put("fad", 48);
    freq.put("Ana", 81);
    freq.put(" Ni", 293);
    freq.put("gg", 100);
    freq.put("and", 5620);
    freq.put("is ", 2517);
    freq.put("avé", 45);
    freq.put(" No", 2056);
    freq.put("roy", 108);
    freq.put(" Na", 335);
    freq.put(" Ne", 265);
    freq.put("ge", 2576);
    freq.put("rín", 40);
    freq.put("aje", 652);
    freq.put("oho", 70);
    freq.put("SI ", 48);
    freq.put("rj", 79);
    freq.put("mio", 218);
    freq.put("rk", 225);
    freq.put(" Nu", 330);
    freq.put("t ", 2772);
    freq.put("odí", 102);
    freq.put("ane", 521);
    freq.put("pul", 148);
    freq.put("tej", 33);
    freq.put("alí", 49);
    freq.put("xcu", 64);
    freq.put("ga", 6974);
    freq.put("rén", 46);
    freq.put("teo", 116);
    freq.put("tea", 314);
    freq.put("edu", 168);
    freq.put("ted", 156);
    freq.put("pun", 376);
    freq.put("Ani", 31);
    freq.put("tex", 37);
    freq.put("go", 6772);
    freq.put("Ven", 165);
    freq.put("asp", 64);
    freq.put("¬¬ ", 66);
    freq.put("aos", 59);
    freq.put("teq", 30);
    freq.put("ter", 3328);
    freq.put("tes", 1915);
    freq.put("tet", 73);
    freq.put("ror", 169);
    freq.put("tev", 55);
    freq.put("Ref", 31);
    freq.put("sug", 29);
    freq.put("rbo", 65);
    freq.put("sue", 767);
    freq.put("gl", 650);
    freq.put("tú", 357);
    freq.put("sub", 423);
    freq.put("sua", 171);
    freq.put("rot", 284);
    freq.put("sum", 161);
    freq.put("sul", 228);
    freq.put("uiz", 105);
    freq.put("tó", 462);
    freq.put("sui", 39);
    freq.put("abo", 555);
    freq.put("pud", 75);
    freq.put("abr", 965);
    freq.put("tí", 515);
    freq.put("sus", 646);
    freq.put("rov", 247);
    freq.put("té", 316);
    freq.put("aby", 28);
    freq.put("zó", 281);
    freq.put("tà", 31);
    freq.put("tá", 1845);
    freq.put(" ru", 292);
    freq.put("te ", 11555);
    freq.put("ntu", 171);
    freq.put("K", 477);
    freq.put(" re", 5109);
    freq.put("ggg", 30);
    freq.put(" ra", 973);
    freq.put("pub", 216);
    freq.put("Die", 45);
    freq.put(" ro", 665);
    freq.put(" ri", 485);
    freq.put("Wil", 46);
    freq.put("vil", 542);
    freq.put("ab ", 32);
    freq.put("à", 246);
    freq.put("ass", 144);
    freq.put("uís", 26);
    freq.put("su ", 1228);
    freq.put("oma", 669);
    freq.put("ont", 2385);
    freq.put("rul", 38);
    freq.put("caz", 45);
    freq.put("lán", 47);
    freq.put("xo ", 185);
    freq.put(" ª ", 72);
    freq.put("vic", 246);
    freq.put("via", 780);
    freq.put("nto", 3506);
    freq.put("ofr", 72);
    freq.put("¡ ", 68);
    freq.put("Tor", 91);
    freq.put("di ", 143);
    freq.put("Top", 26);
    freq.put("vin", 196);
    freq.put("vio", 323);
    freq.put("mab", 41);
    freq.put("Aun", 137);
    freq.put("vir", 252);
    freq.put("rke", 87);
    freq.put("ués", 305);
    freq.put("viv", 431);
    freq.put("Aut", 29);
    freq.put("vit", 228);
    freq.put("Uni", 106);
    freq.put("S ", 1135);
    freq.put("asi", 1064);
    freq.put("Tie", 177);
    freq.put("ve", 9359);
    freq.put("¡", 1331);
    freq.put("ear", 397);
    freq.put("ash", 75);
    freq.put("eye", 136);
    freq.put("ñas", 172);
    freq.put("ñar", 121);
    freq.put("twi", 534);
    freq.put("eym", 27);
    freq.put("Dav", 45);
    freq.put("ov ", 26);
    freq.put(" d ", 881);
    freq.put("ñad", 135);
    freq.put("vee", 37);
    freq.put("anc", 1334);
    freq.put("asm", 67);
    freq.put("VE ", 64);
    freq.put("de ", 27870);
    freq.put("ñal", 60);
    freq.put("ñan", 1082);
    freq.put("ae ", 129);
    freq.put("vec", 498);
    freq.put("iz ", 319);
    freq.put("vi ", 212);
    freq.put("fó", 46);
    freq.put("Vic", 65);
    freq.put("fú", 149);
    freq.put("Sp", 155);
    freq.put("Su", 450);
    freq.put("St", 211);
    freq.put("Sk", 38);
    freq.put("fá", 109);
    freq.put("Si", 1515);
    freq.put("Sh", 87);
    freq.put("So", 765);
    freq.put("Sc", 77);
    freq.put("fé", 62);
    freq.put("Sa", 891);
    freq.put("umn", 32);
    freq.put("tru", 225);
    freq.put("fí", 193);
    freq.put("Se", 1406);
    freq.put("osc", 72);
    freq.put("á", 8902);
    freq.put("ey ", 294);
    freq.put("dez", 81);
    freq.put(" dl", 61);
    freq.put("Vid", 72);
    freq.put(" di", 5359);
    freq.put("ís ", 198);
    freq.put("Int", 242);
    freq.put("aba", 2489);
    freq.put("Inv", 32);
    freq.put("des", 3864);
    freq.put("det", 242);
    freq.put("deu", 67);
    freq.put(" da", 1624);
    freq.put("Ins", 48);
    freq.put("bur", 254);
    freq.put("dei", 41);
    freq.put("dej", 872);
    freq.put("avo", 438);
    freq.put("del", 4425);
    freq.put("dem", 840);
    freq.put("den", 1204);
    freq.put("v", 29358);
    freq.put("Ind", 61);
    freq.put("dea", 292);
    freq.put("Inf", 69);
    freq.put("Ing", 47);
    freq.put("ded", 251);
    freq.put(" dr", 106);
    freq.put("def", 229);
    freq.put("Inc", 48);
    freq.put("oo ", 465);
    freq.put("upl", 41);
    freq.put("Una", 278);
    freq.put("ats", 70);
    freq.put("ann", 72);
    freq.put("f ", 388);
    freq.put(" Fi", 226);
    freq.put("pué", 288);
    freq.put("lal", 27);
    freq.put("Vil", 189);
    freq.put("uxo", 26);
    freq.put("pai", 121);
    freq.put("hhh", 167);
    freq.put("ucí", 35);
    freq.put("iPa", 42);
    freq.put("bat", 221);
    freq.put("ft ", 47);
    freq.put("iPh", 70);
    freq.put("ano", 1603);
    freq.put("att", 49);
    freq.put("Yor", 30);
    freq.put("oyo", 94);
    freq.put("íti", 247);
    freq.put("iso", 254);
    freq.put("oye", 194);
    freq.put("oya", 109);
    freq.put("xua", 51);
    freq.put("tle", 96);
    freq.put("fr", 1291);
    freq.put("fs", 28);
    freq.put("ft", 84);
    freq.put("fu", 1762);
    freq.put("Dom", 40);
    freq.put("Só", 65);
    freq.put("uté", 30);
    freq.put("pri", 1106);
    freq.put("isl", 52);
    freq.put("lan", 1501);
    freq.put("fa", 2369);
    freq.put("hh ", 139);
    freq.put("fe", 2340);
    freq.put("Sí", 158);
    freq.put("Et", 28);
    freq.put("Dor", 27);
    freq.put("fi", 3545);
    freq.put("Sá", 37);
    freq.put("fl", 452);
    freq.put("fo", 2192);
    freq.put("a", 313111);
    freq.put("bar", 833);
    freq.put(" dí", 1518);
    freq.put(" dé", 81);
    freq.put("leñ", 47);
    freq.put("ges", 122);
    freq.put("egr", 506);
    freq.put("cs ", 76);
    freq.put("egu", 1888);
    freq.put("afé", 51);
    freq.put("egi", 266);
    freq.put("ego", 1084);
    freq.put("ds ", 103);
    freq.put("egl", 122);
    freq.put("ega", 1520);
    freq.put("CA ", 61);
    freq.put(" dó", 75);
    freq.put("¿Po", 93);
    freq.put("ege", 58);
    freq.put("oy ", 4477);
    freq.put("ito", 1749);
    freq.put("itm", 48);
    freq.put("jó ", 33);
    freq.put("ger", 265);
    freq.put("iti", 580);
    freq.put("y ", 21104);
    freq.put("ite", 523);
    freq.put("itc", 53);
    freq.put("ita", 2379);
    freq.put("ok ", 325);
    freq.put(" sé", 323);
    freq.put("itz", 37);
    freq.put("ffi", 27);
    freq.put("ity", 88);
    freq.put("fff", 117);
    freq.put("itt", 703);
    freq.put("itu", 628);
    freq.put("itr", 92);
    freq.put("its", 62);
    freq.put(" On", 73);
    freq.put("izá", 50);
    freq.put(" Ol", 70);
    freq.put(" Oj", 75);
    freq.put(" Ok", 31);
    freq.put(" Oh", 69);
    freq.put(" Of", 82);
    freq.put(" Od", 63);
    freq.put(" Ob", 45);
    freq.put(" Oc", 43);
    freq.put("pci", 170);
    freq.put("uos", 27);
    freq.put("tp ", 112);
    freq.put("·", 34);
    freq.put("̶", 47);
    freq.put(" Ot", 116);
    freq.put(" Or", 151);
    freq.put(" Os", 181);
    freq.put(" Op", 84);
    freq.put("yi", 48);
    freq.put("Bat", 37);
    freq.put("ced", 168);
    freq.put("ym", 84);
    freq.put("yl", 56);
    freq.put("yo", 2985);
    freq.put("yn", 68);
    freq.put("ya", 3766);
    freq.put("cen", 1260);
    freq.put("cem", 133);
    freq.put("cel", 472);
    freq.put("ye", 1023);
    freq.put("L", 5923);
    freq.put("it ", 248);
    freq.put("Cla", 118);
    freq.put("yy", 145);
    freq.put("Ere", 95);
    freq.put("Bad", 29);
    freq.put("cet", 56);
    freq.put("ces", 1685);
    freq.put("Era", 30);
    freq.put("dig", 767);
    freq.put("cep", 200);
    freq.put("Ban", 54);
    freq.put("yp", 48);
    freq.put(" Aú", 35);
    freq.put("yr", 34);
    freq.put("yu", 411);
    freq.put("yt", 42);
    freq.put("yw", 31);
    freq.put("ff ", 170);
    freq.put("Raf", 31);
    freq.put("ifu", 41);
    freq.put("Rad", 42);
    freq.put("bús", 36);
    freq.put("dij", 246);
    freq.put("MI ", 48);
    freq.put("Ram", 76);
    freq.put("Raj", 71);
    freq.put(" O ", 237);
    freq.put("güe", 99);
    freq.put("ife", 280);
    freq.put("val", 669);
    freq.put("ifa", 49);
    freq.put("man", 2321);
    freq.put("die", 693);
    freq.put("pc ", 26);
    freq.put("stá", 1642);
    freq.put("ifi", 462);
    freq.put("uál", 69);
    freq.put(" A ", 1055);
    freq.put("Enc", 66);
    freq.put("Mus", 53);
    freq.put("Mur", 59);
    freq.put("Enh", 35);
    freq.put("tre", 1460);
    freq.put(" sp", 78);
    freq.put("uán", 122);
    freq.put("Muy", 151);
    freq.put(" st", 171);
    freq.put("itá", 62);
    freq.put("Mue", 36);
    freq.put(" sk", 26);
    freq.put("Enr", 29);
    freq.put(" si", 7028);
    freq.put("Ent", 180);
    freq.put(" so", 4547);
    freq.put("Muc", 233);
    freq.put(" sm", 42);
    freq.put("uda", 822);
    freq.put(" sa", 3135);
    freq.put("mm ", 118);
    freq.put(" se", 10755);
    freq.put("iza", 713);
    freq.put("éxi", 62);
    freq.put("úl ", 36);
    freq.put("adm", 109);
    freq.put("gur", 513);
    freq.put("E ", 1058);
    freq.put("izo", 152);
    freq.put("izq", 54);
    freq.put("abl", 1354);
    freq.put("¿A ", 37);
    freq.put("ate", 1034);
    freq.put("izz", 37);
    freq.put("uí ", 518);
    freq.put("En ", 859);
    freq.put("jer", 444);
    freq.put(" Ab", 95);
    freq.put(" Ac", 278);
    freq.put(" Ad", 190);
    freq.put("diz", 47);
    freq.put(" Af", 35);
    freq.put(" Ag", 184);
    freq.put(" Ah", 483);
    freq.put(" Ai", 81);
    freq.put(" Al", 1048);
    freq.put(" Am", 254);
    freq.put(" An", 618);
    freq.put("puc", 27);
    freq.put(" Ap", 232);
    freq.put(" Aq", 171);
    freq.put(" Ar", 354);
    freq.put(" As", 322);
    freq.put(" At", 161);
    freq.put(" Au", 248);
    freq.put(" Av", 85);
    freq.put("Tam", 84);
    freq.put("put", 457);
    freq.put(" Ay", 186);
    freq.put(" s ", 194);
    freq.put("Yo ", 742);
    freq.put("aso", 606);
    freq.put("ódi", 61);
    freq.put("pur", 91);
    freq.put("pus", 100);
    freq.put("Em", 208);
    freq.put("El", 2249);
    freq.put("En", 1291);
    freq.put("Eh", 29);
    freq.put("omp", 1303);
    freq.put("Ej", 27);
    freq.put("Ed", 107);
    freq.put("Ea", 30);
    freq.put("Ec", 99);
    freq.put("últ", 280);
    freq.put("stí", 28);
    freq.put("Ex", 161);
    freq.put("w", 2553);
    freq.put("tos", 2489);
    freq.put("Eu", 191);
    freq.put("ifí", 71);
    freq.put("twe", 260);
    freq.put("Ev", 48);
    freq.put("Raú", 30);
    freq.put(" ef", 81);
    freq.put("Es", 3355);
    freq.put("Er", 165);
    freq.put("Ima", 31);
    freq.put("rro", 825);
    freq.put("Fra", 158);
    freq.put("toq", 66);
    freq.put("Cli", 26);
    freq.put("Fre", 45);
    freq.put("ody", 33);
    freq.put("óxi", 159);
    freq.put("Fri", 27);
    freq.put("CB ", 27);
    freq.put("ála", 74);
    freq.put("Imp", 68);
    freq.put("ude", 129);
    freq.put("zo", 1317);
    freq.put("bul", 74);
    freq.put("oir", 44);
    freq.put("Sup", 170);
    freq.put("nc ", 37);
    freq.put("Clu", 26);
    freq.put("BB ", 27);
    freq.put(" ▸", 79);
    freq.put("cóm", 235);
    freq.put("jes", 191);
    freq.put(" en", 16256);
    freq.put("cón", 45);
    freq.put(" eh", 232);
    freq.put("oz ", 136);
    freq.put("jet", 134);
    freq.put("tiq", 39);
    freq.put(" ed", 244);
    freq.put(" ee", 40);
    freq.put("X ", 93);
    freq.put(" eg", 41);
    freq.put(" ea", 28);
    freq.put(" ec", 443);
    freq.put("jec", 49);
    freq.put("ion", 3091);
    freq.put("een", 197);
    freq.put("jef", 38);
    freq.put("lió", 46);
    freq.put("jej", 594);
    freq.put(" eu", 226);
    freq.put(" ev", 188);
    freq.put("jen", 61);
    freq.put(" eq", 366);
    freq.put(" er", 1111);
    freq.put("jem", 105);
    freq.put("omu", 184);
    freq.put("gü", 119);
    freq.put("tol", 121);
    freq.put("ncr", 159);
    freq.put("tom", 370);
    freq.put("ncu", 312);
    freq.put("za", 2941);
    freq.put("nch", 315);
    freq.put(" et", 177);
    freq.put("¿qu", 93);
    freq.put("ncl", 169);
    freq.put("uec", 76);
    freq.put("lac", 469);
    freq.put("nco", 605);
    freq.put("nca", 1204);
    freq.put("zc", 237);
    freq.put("nce", 734);
    freq.put("nki", 41);
    freq.put("íni", 46);
    freq.put("ste", 2450);
    freq.put("b", 30264);
    freq.put("aaa", 1163);
    freq.put("sta", 8155);
    freq.put("dam", 291);
    freq.put("exá", 41);
    freq.put("ko ", 54);
    freq.put("áge", 47);
    freq.put("Xa", 67);
    freq.put(" e ", 433);
    freq.put("có ", 40);
    freq.put("tog", 72);
    freq.put("Nun", 80);
    freq.put("i", 140205);
    freq.put("je ", 777);
    freq.put("htt", 130);
    freq.put("Jos", 87);
    freq.put("str", 1674);
    freq.put("aar", 34);
    freq.put(" es", 19795);
    freq.put("Gol", 56);
    freq.put("Goo", 146);
    freq.put("ka ", 93);
    freq.put("apí", 69);
    freq.put("zz", 100);
    freq.put("sti", 1914);
    freq.put("uez", 79);
    freq.put("elo", 1042);
    freq.put("Gob", 60);
    freq.put("ao ", 314);
    freq.put("¡Bu", 33);
    freq.put("oda", 948);
    freq.put("¡N", 46);
    freq.put("rru", 84);
    freq.put("lid", 790);
    freq.put("¡Q", 71);
    freq.put("lif", 59);
    freq.put("k ", 1276);
    freq.put("Nin", 37);
    freq.put("lia", 584);
    freq.put("ex ", 99);
    freq.put("lic", 1562);
    freq.put("lil", 34);
    freq.put("Nic", 55);
    freq.put("efr", 43);
    freq.put("ell", 1236);
    freq.put("bic", 137);
    freq.put("uè", 26);
    freq.put("rrr", 258);
    freq.put("lit", 401);
    freq.put("efi", 331);
    freq.put("liv", 191);
    freq.put("efl", 77);
    freq.put("liq", 29);
    freq.put("lir", 251);
    freq.put("efo", 208);
    freq.put("víd", 135);
    freq.put("cci", 586);
    freq.put("efe", 385);
    freq.put("liz", 628);
    freq.put("rin", 586);
    freq.put("Ter", 88);
    freq.put("Ate", 29);
    freq.put(" fi", 1754);
    freq.put("áti", 172);
    freq.put("Atl", 70);
    freq.put("¡V", 28);
    freq.put("M", 7565);
    freq.put("ncé", 30);
    freq.put("zos", 144);
    freq.put("Isl", 35);
    freq.put("spu", 545);
    freq.put("The", 95);
    freq.put("bac", 111);
    freq.put("kb", 37);
    freq.put("ka", 243);
    freq.put("éfo", 60);
    freq.put("stà", 26);
    freq.put("exc", 177);
    freq.put("ke", 639);
    freq.put("exa", 189);
    freq.put("kk", 26);
    freq.put("exo", 90);
    freq.put("ki", 535);
    freq.put("ko", 137);
    freq.put("sté", 131);
    freq.put("km", 53);
    freq.put("exi", 355);
    freq.put("ks", 135);
    freq.put("ext", 349);
    freq.put("exu", 55);
    freq.put("acá", 34);
    freq.put("ku", 62);
    freq.put("stó", 78);
    freq.put("vay", 312);
    freq.put("ky", 104);
    freq.put("une", 222);
    freq.put("rte", 2125);
    freq.put("ath", 28);
    freq.put("ugi", 37);
    freq.put("oju", 26);
    freq.put("Hal", 40);
    freq.put("Han", 59);
    freq.put("Hab", 108);
    freq.put("Hac", 163);
    freq.put("rti", 1299);
    freq.put("rth", 35);
    freq.put("sup", 537);
    freq.put("hi ", 204);
    freq.put("Hay", 252);
    freq.put("Haz", 38);
    freq.put("oje", 52);
    freq.put("rts", 34);
    freq.put("oja", 264);
    freq.put("ojo", 469);
    freq.put("Har", 63);
    freq.put("Has", 150);
    freq.put("mí ", 221);
    freq.put("ugu", 68);
    freq.put("oji", 40);
    freq.put("iez", 293);
    freq.put("Ju", 517);
    freq.put("ies", 846);
    freq.put("ier", 4347);
    freq.put("IA ", 82);
    freq.put("¿y ", 30);
    freq.put("iev", 30);
    freq.put("yma", 27);
    freq.put("Ope", 39);
    freq.put("Mir", 133);
    freq.put("Jo", 490);
    freq.put("iem", 1543);
    freq.put("iel", 233);
    freq.put("ien", 8809);
    freq.put("Je", 192);
    freq.put("iec", 43);
    freq.put("ieb", 147);
    freq.put("iee", 54);
    freq.put("Ja", 739);
    freq.put("ieg", 116);
    freq.put("hip", 91);
    freq.put("hir", 35);
    freq.put("his", 340);
    freq.put("hit", 51);
    freq.put("rt ", 182);
    freq.put("Ha ", 68);
    freq.put("hiz", 92);
    freq.put(" Án", 52);
    freq.put("hia", 27);
    freq.put("hib", 57);
    freq.put("hic", 462);
    freq.put("hie", 60);
    freq.put("ada", 3934);
    freq.put("hij", 215);
    freq.put("íde", 195);
    freq.put("hil", 164);
    freq.put("him", 48);
    freq.put("hin", 190);
    freq.put("áx", 40);
    freq.put("ági", 100);
    freq.put("cru", 107);
    freq.put("óvi", 121);
    freq.put("ñol", 320);
    freq.put("utu", 158);
    freq.put("apá", 40);
    freq.put(" Pá", 27);
    freq.put("cra", 189);
    freq.put("oxi", 65);
    freq.put("rfe", 162);
    freq.put("cre", 1523);
    freq.put("ie ", 625);
    freq.put("rfi", 78);
    freq.put("cri", 765);
    freq.put("J ", 217);
    freq.put("cro", 111);
    freq.put("át", 185);
    freq.put(" Be", 447);
    freq.put("Ago", 62);
    freq.put("seu", 27);
    freq.put("óve", 62);
    freq.put(" Ba", 770);
    freq.put("ser", 2199);
    freq.put("For", 84);
    freq.put("sep", 315);
    freq.put("rtí", 117);
    freq.put(" Bl", 165);
    freq.put(" Bo", 341);
    freq.put(" Bi", 343);
    freq.put("bé ", 46);
    freq.put("sex", 155);
    freq.put(" Bu", 1003);
    freq.put("ara", 6520);
    freq.put("see", 27);
    freq.put("ik ", 34);
    freq.put("sec", 199);
    freq.put("ype", 36);
    freq.put("sea", 714);
    freq.put(" Br", 230);
    freq.put("Fol", 26);
    freq.put("sen", 990);
    freq.put("sem", 545);
    freq.put("sel", 245);
    freq.put("arl", 888);
    freq.put("sej", 99);
    freq.put("sei", 49);
    freq.put("ozc", 92);
    freq.put("Vit", 28);
    freq.put("stu", 681);
    freq.put("¿Qu", 306);
    freq.put("uso", 187);
    freq.put("oza", 124);
    freq.put("use", 167);
    freq.put("rod", 247);
    freq.put("úme", 88);
    freq.put("chu", 262);
    freq.put("rça", 243);
    freq.put(" P ", 127);
    freq.put("oke", 55);
    freq.put("atr", 510);
    freq.put("Pla", 157);
    freq.put("lei", 55);
    freq.put("DD ", 289);
    freq.put("tro", 2380);
    freq.put("uuy", 26);
    freq.put(" B ", 57);
    freq.put("oss", 118);
    freq.put("béi", 77);
    freq.put("uuu", 300);
    freq.put("be ", 604);
    freq.put("Vue", 66);
    freq.put("lem", 458);
    freq.put("ar ", 8719);
    freq.put("ays", 28);
    freq.put("aaj", 107);
    freq.put("adu", 132);
    freq.put(" €", 183);
    freq.put("ike", 77);
    freq.put("se ", 7164);
    freq.put("té ", 127);
    freq.put("iki", 100);
    freq.put("leo", 152);
    freq.put("iko", 29);
    freq.put("to ", 8555);
    freq.put("TC ", 35);
    freq.put("cay", 38);
    freq.put(" Pr", 645);
    freq.put("c", 89979);
    freq.put("Nue", 220);
    freq.put(" Pu", 824);
    freq.put("nzo", 79);
    freq.put("rof", 252);
    freq.put("fos", 36);
    freq.put("rma", 1328);
    freq.put("Far", 30);
    freq.put(" Pa", 1242);
    freq.put(" Pe", 1149);
    freq.put(" Pi", 297);
    freq.put(" Ph", 39);
    freq.put(" Po", 1215);
    freq.put(" Pl", 188);
    freq.put("azu", 60);
    freq.put("arm", 689);
    freq.put("rpr", 158);
    freq.put("sky", 29);
    freq.put("tuy", 127);
    freq.put("¿po", 33);
    freq.put("rió", 95);
    freq.put("riñ", 111);
    freq.put("od ", 121);
    freq.put("Gon", 40);
    freq.put("aur", 119);
    freq.put("lbu", 36);
    freq.put("ubo", 70);
    freq.put(" t ", 153);
    freq.put("pr", 7500);
    freq.put("ps", 264);
    freq.put("pp", 247);
    freq.put("pq", 77);
    freq.put("dul", 83);
    freq.put("dum", 73);
    freq.put("pt", 604);
    freq.put("pu", 4979);
    freq.put("dua", 34);
    freq.put("amó", 50);
    freq.put("py", 46);
    freq.put("dud", 179);
    freq.put(" º ", 103);
    freq.put("tiv", 894);
    freq.put("lét", 40);
    freq.put("pc", 206);
    freq.put("pa", 15056);
    freq.put("nau", 34);
    freq.put("AS ", 215);
    freq.put("pe", 11853);
    freq.put("ska", 29);
    freq.put("ph", 113);
    freq.put("pi", 3816);
    freq.put("po", 13911);
    freq.put("pl", 2363);
    freq.put("ag ", 50);
    freq.put("nri", 113);
    freq.put("Fal", 101);
    freq.put("gay", 49);
    freq.put("ctu", 395);
    freq.put(" tw", 748);
    freq.put(" tv", 42);
    freq.put(" tu", 2545);
    freq.put("gat", 131);
    freq.put("gas", 727);
    freq.put(" tr", 2100);
    freq.put("nre", 36);
    freq.put("N", 3844);
    freq.put(" to", 4303);
    freq.put(" tn", 35);
    freq.put(" tm", 38);
    freq.put("gal", 367);
    freq.put("Emp", 136);
    freq.put(" ti", 3425);
    freq.put(" th", 92);
    freq.put("añí", 32);
    freq.put("gaf", 51);
    freq.put(" te", 7548);
    freq.put("gad", 688);
    freq.put("gac", 70);
    freq.put(" tb", 114);
    freq.put(" ta", 3132);
    freq.put("lba", 93);
    freq.put("fut", 235);
    freq.put("nci", 3144);
    freq.put("fur", 29);
    freq.put("fus", 44);
    freq.put("du ", 30);
    freq.put(" fú", 146);
    freq.put("Tú ", 55);
    freq.put(" fá", 92);
    freq.put("fug", 31);
    freq.put("p ", 757);
    freq.put("fue", 870);
    freq.put("fun", 314);
    freq.put("lbe", 58);
    freq.put("ful", 27);
    freq.put("fum", 61);
    freq.put(" fí", 36);
    freq.put("bor", 368);
    freq.put("fui", 92);
    freq.put("ant", 4658);
    freq.put("riz", 130);
    freq.put("nóm", 57);
    freq.put("voc", 193);
    freq.put("riv", 178);
    freq.put("unq", 417);
    freq.put("rit", 762);
    freq.put("riu", 56);
    freq.put("rir", 239);
    freq.put("ris", 874);
    freq.put("rip", 122);
    freq.put("riq", 47);
    freq.put("nés", 35);
    freq.put("rio", 1812);
    freq.put("ril", 248);
    freq.put("rim", 1052);
    freq.put("rik", 53);
    freq.put("vor", 384);
    freq.put("vos", 470);
    freq.put("rif", 80);
    freq.put("rig", 207);
    freq.put("rid", 1415);
    freq.put("rie", 560);
    freq.put("rib", 479);
    freq.put("ric", 616);
    freq.put("voz", 91);
    freq.put("ria", 1817);
    freq.put("pó", 57);
    freq.put("tir", 877);
    freq.put("pú", 132);
    freq.put("bs ", 64);
    freq.put("ceb", 253);
    freq.put("fút", 145);
    freq.put("gs ", 36);
    freq.put("pá", 203);
    freq.put("Via", 28);
    freq.put("pé", 44);
    freq.put("óp", 44);
    freq.put("pí", 107);
    freq.put("Cop", 47);
    freq.put("Cos", 74);
    freq.put("Cor", 138);
    freq.put("vo ", 1227);
    freq.put(" tú", 311);
    freq.put("lie", 261);
    freq.put("nó ", 41);
    freq.put(" ¬¬", 140);
    freq.put("ión", 3349);
    freq.put("gañ", 49);
    freq.put("feo", 65);
    freq.put(" tí", 229);
    freq.put("lig", 394);
    freq.put("aña", 1976);
    freq.put("uto", 613);
    freq.put(" té", 45);
    freq.put("Tod", 270);
    freq.put("Ir ", 31);
    freq.put("año", 1464);
    freq.put("añi", 56);
    freq.put("Col", 107);
    freq.put("ri ", 181);
    freq.put("Con", 797);
    freq.put("Soc", 78);
    freq.put(" fr", 644);
    freq.put(" fu", 1545);
    freq.put("lib", 407);
    freq.put("bod", 75);
    freq.put("ew ", 48);
    freq.put("Som", 74);
    freq.put("Sol", 235);
    freq.put("Son", 126);
    freq.put(" fa", 1849);
    freq.put("Sor", 32);
    freq.put(" fe", 816);
    freq.put("lim", 304);
    freq.put("y", 30353);
    freq.put("moo", 48);
    freq.put(" fl", 239);
    freq.put(" fo", 1236);
    freq.put("tíc", 78);
    freq.put("lda", 129);
    freq.put("lio", 180);
    freq.put("lde", 184);
    freq.put("wif", 28);
    freq.put("ldi", 77);
    freq.put("mol", 287);
    freq.put("ldo", 108);
    freq.put("yud", 216);
    freq.put("oa ", 70);
    freq.put("O ", 1200);
    freq.put("ldr", 56);
    freq.put(" oí", 49);
    freq.put("lip", 281);
    freq.put("amp", 679);
    freq.put("ohi", 44);
    freq.put("lik", 39);
    freq.put("ams", 60);
    freq.put("odi", 531);
    freq.put("Más", 90);
    freq.put("cut", 98);
    freq.put("cus", 124);
    freq.put("cur", 638);
    freq.put("cup", 301);
    freq.put("peñ", 44);
    freq.put("peó", 32);
    freq.put("aer", 162);
    freq.put("rga", 492);
    freq.put("cue", 1471);
    freq.put("cud", 40);
    freq.put("cuc", 374);
    freq.put("cub", 166);
    freq.put("cua", 1844);
    freq.put("cun", 52);
    freq.put("cum", 334);
    freq.put("cul", 1044);
    freq.put("ee ", 417);
    freq.put("cui", 103);
    freq.put("rgo", 228);
    freq.put("bin", 79);
    freq.put("On", 76);
    freq.put("bil", 268);
    freq.put("Ol", 78);
    freq.put("Ok", 32);
    freq.put("bá", 38);
    freq.put("Oh", 76);
    freq.put("urd", 41);
    freq.put("bí", 305);
    freq.put("bid", 210);
    freq.put("Od", 64);
    freq.put("Oc", 43);
    freq.put("bé", 178);
    freq.put("Dic", 58);
    freq.put("biz", 41);
    freq.put("apt", 55);
    freq.put("Oy", 43);
    freq.put("bó", 65);
    freq.put("ndí", 61);
    freq.put("bit", 206);
    freq.put("Ot", 120);
    freq.put("Os", 212);
    freq.put("Or", 154);
    freq.put("bú", 48);
    freq.put("Op", 85);
    freq.put("uy ", 1183);
    freq.put("ná ", 33);
    freq.put("d", 109047);
    freq.put("cc ", 45);
    freq.put("eet", 309);
    freq.put("ahh", 44);
    freq.put("uñ", 163);
    freq.put("ees", 175);
    freq.put("Án", 52);
    freq.put("eem", 54);
    freq.put("eel", 32);
    freq.put("ak ", 35);
    freq.put("idí", 34);
    freq.put("ava", 394);
    freq.put("eee", 660);
    freq.put("eed", 48);
    freq.put("apo", 386);
    freq.put("aci", 4628);
    freq.put("b ", 693);
    freq.put("apl", 122);
    freq.put("uf ", 30);
    freq.put("Mej", 52);
    freq.put("ohe", 33);
    freq.put("ija", 160);
    freq.put("ld ", 53);
    freq.put("ije", 120);
    freq.put("ça", 267);
    freq.put("cif", 45);
    freq.put("iji", 124);
    freq.put("oe ", 73);
    freq.put("ijo", 406);
    freq.put(" Qu", 1701);
    freq.put("pez", 327);
    freq.put("pet", 451);
    freq.put("rgü", 66);
    freq.put("peq", 197);
    freq.put("per", 6696);
    freq.put("pes", 278);
    freq.put("pel", 852);
    freq.put("pen", 1080);
    freq.put("peo", 327);
    freq.put("pei", 30);
    freq.put("cuá", 98);
    freq.put("Ley", 40);
    freq.put("ped", 357);
    freq.put("Os ", 126);
    freq.put("peg", 159);
    freq.put("rgí", 40);
    freq.put("id ", 915);
    freq.put("pec", 449);
    freq.put("bd", 26);
    freq.put("be", 3828);
    freq.put("rui", 100);
    freq.put("run", 38);
    freq.put("ba", 6069);
    freq.put("bb", 68);
    freq.put("cha", 2521);
    freq.put("bl", 3608);
    freq.put("ruc", 132);
    freq.put("bn", 56);
    freq.put("bo", 2708);
    freq.put("bi", 4917);
    freq.put("bj", 59);
    freq.put("rue", 227);
    freq.put("bt", 53);
    freq.put("bu", 2735);
    freq.put("bv", 57);
    freq.put("ruy", 29);
    freq.put("Bol", 45);
    freq.put("br", 4311);
    freq.put("bs", 233);
    freq.put("¿Es", 52);
    freq.put("rus", 94);
    freq.put("rup", 206);
    freq.put("wit", 782);
    freq.put("by", 106);
    freq.put("rut", 360);
    freq.put("fec", 336);
    freq.put("uff", 103);
    freq.put("Roj", 30);
    freq.put("Vie", 151);
    freq.put("Rom", 63);
    freq.put("Ron", 47);
    freq.put("alk", 36);
    freq.put("Rob", 43);
    freq.put("idu", 36);
    freq.put("idr", 46);
    freq.put("Llu", 27);
    freq.put(" Q ", 146);
    freq.put("ido", 3387);
    freq.put("bso", 51);
    freq.put("Llo", 48);
    freq.put("aa ", 483);
    freq.put("idi", 503);
    freq.put("DE ", 146);
    freq.put("Lla", 35);
    freq.put("ide", 1239);
    freq.put("pe ", 340);
    freq.put("Rou", 28);
    freq.put("Lle", 148);
    freq.put("ida", 3380);
    freq.put("ppl", 80);
    freq.put("nsi", 340);
    freq.put("Tú", 60);
    freq.put("nsm", 44);
    freq.put("Ell", 40);
    freq.put("nso", 333);
    freq.put(" ut", 73);
    freq.put(" uu", 26);
    freq.put(" C ", 86);
    freq.put("nsc", 52);
    freq.put("nse", 677);
    freq.put(" ur", 62);
    freq.put("Ele", 45);
    freq.put(" ul", 153);
    freq.put(" un", 11129);
    freq.put("Tí", 29);
    freq.put("bse", 41);
    freq.put("nsp", 95);
    freq.put(" uf", 34);
    freq.put("cho", 2394);
    freq.put("nst", 533);
    freq.put("nsu", 204);
    freq.put("Mañ", 211);
    freq.put("ut ", 64);
    freq.put("ixi", 28);
    freq.put("xpo", 36);
    freq.put("ixo", 29);
    freq.put("Su ", 29);
    freq.put("xpl", 174);
    freq.put("usu", 107);
    freq.put("xpe", 144);
    freq.put("ixe", 26);
    freq.put("gó ", 61);
    freq.put("ust", 1674);
    freq.put("grá", 45);
    freq.put("ack", 244);
    freq.put("xpr", 69);
    freq.put("grí", 49);
    freq.put("u ", 4055);
    freq.put(" R ", 42);
    freq.put("aqu", 1027);
    freq.put(" Ch", 403);
    freq.put(" Ci", 263);
    freq.put("jón", 49);
    freq.put(" Co", 1893);
    freq.put(" Cl", 190);
    freq.put("ña ", 988);
    freq.put("ns ", 422);
    freq.put("Noc", 39);
    freq.put("El ", 2050);
    freq.put(" Ca", 1398);
    freq.put("brí", 61);
    freq.put("Ult", 29);
    freq.put(" Ce", 240);
    freq.put("Fli", 30);
    freq.put("sde", 604);
    freq.put("Flo", 31);
    freq.put(" Cr", 434);
    freq.put("li ", 331);
    freq.put("Vis", 54);
    freq.put(" u ", 129);
    freq.put("ué", 1706);
    freq.put("zan", 260);
    freq.put(" Cu", 584);
    freq.put("cic", 85);
    freq.put("cib", 159);
    freq.put("cia", 4133);
    freq.put("uta", 764);
    freq.put("uy", 1524);
    freq.put("ux", 101);
    freq.put("cie", 1508);
    freq.put("uz", 261);
    freq.put("uu", 505);
    freq.put("ut", 2260);
    freq.put("ix ", 68);
    freq.put("uv", 375);
    freq.put("uq", 60);
    freq.put("up", 1450);
    freq.put("us", 4485);
    freq.put("ur", 4465);
    freq.put("um", 1519);
    freq.put("ul", 2795);
    freq.put("uo", 118);
    freq.put("un", 16708);
    freq.put("ui", 6590);
    freq.put("uh", 70);
    freq.put("uk", 63);
    freq.put("uj", 482);
    freq.put("ue", 39411);
    freq.put("ud", 1989);
    freq.put("ug", 1026);
    freq.put("Aú", 38);
    freq.put("ua", 4659);
    freq.put("Ni ", 88);
    freq.put("uc", 3627);
    freq.put("ub", 1586);
    freq.put("nsé", 37);
    freq.put("tib", 42);
    freq.put("Tw", 277);
    freq.put("Tu", 311);
    freq.put("Tr", 400);
    freq.put("oog", 153);
    freq.put("To", 614);
    freq.put("vot", 151);
    freq.put("Th", 156);
    freq.put("Ti", 321);
    freq.put("Te", 1113);
    freq.put("Ta", 343);
    freq.put("nab", 103);
    freq.put("A ", 2347);
    freq.put("ng ", 475);
    freq.put(" gu", 1535);
    freq.put(" gr", 2076);
    freq.put("nag", 34);
    freq.put("nad", 2023);
    freq.put("naj", 65);
    freq.put("nah", 45);
    freq.put("nai", 30);
    freq.put("nan", 552);
    freq.put("nal", 1348);
    freq.put("nam", 211);
    freq.put("nar", 1040);
    freq.put("nas", 1717);
    freq.put("Mac", 48);
    freq.put("gre", 360);
    freq.put("nav", 53);
    freq.put("Mad", 741);
    freq.put("nat", 242);
    freq.put("gra", 2405);
    freq.put("naz", 109);
    freq.put(" go", 596);
    freq.put(" gl", 63);
    freq.put("º", 153);
    freq.put("Mal", 126);
    freq.put(" gi", 223);
    freq.put("rds", 27);
    freq.put("Bea", 29);
    freq.put("exp", 408);
    freq.put("iér", 69);
    freq.put(" Cá", 43);
    freq.put("ac ", 81);
    freq.put("ly ", 128);
    freq.put("ígu", 27);
    freq.put("dos", 3163);
    freq.put(" Có", 120);
    freq.put("tua", 438);
    freq.put("ién", 844);
    freq.put("T ", 1431);
    freq.put("ago", 756);
    freq.put("agn", 50);
    freq.put("Ac", 290);
    freq.put("Ab", 98);
    freq.put("e", 326941);
    freq.put("Ad", 199);
    freq.put("Ag", 184);
    freq.put("Af", 38);
    freq.put("Ai", 82);
    freq.put("Ah", 492);
    freq.put("cié", 51);
    freq.put("Aj", 27);
    freq.put("Am", 261);
    freq.put("Al", 1107);
    freq.put("aga", 859);
    freq.put("An", 632);
    freq.put("Aq", 173);
    freq.put("Ap", 242);
    freq.put("As", 335);
    freq.put("Ar", 363);
    freq.put("Au", 250);
    freq.put("At", 163);
    freq.put("Av", 88);
    freq.put("Ay", 193);
    freq.put("uis", 226);
    freq.put("ú", 2349);
    freq.put("uá", 209);
    freq.put("agr", 247);
    freq.put(" b", 7968);
    freq.put(" c", 34320);
    freq.put("gu", 6612);
    freq.put(" a", 37639);
    freq.put(" f", 8431);
    freq.put(" g", 7088);
    freq.put(" d", 48840);
    freq.put(" e", 56137);
    freq.put(" j", 5230);
    freq.put(" k", 723);
    freq.put(" h", 16232);
    freq.put(" i", 7075);
    freq.put(" n", 18073);
    freq.put(" o", 6524);
    freq.put(" l", 38962);
    freq.put(" m", 32753);
    freq.put(" r", 7710);
    freq.put(" s", 31351);

    init3();
  }
  private static void init3() {
    
    freq.put(" p", 39676);
    freq.put(" q", 25892);
    freq.put(" v", 16380);
    freq.put(" w", 520);
    freq.put(" t", 24989);
    freq.put(" u", 12240);
    freq.put(" z", 251);
    freq.put("gn", 384);
    freq.put(" x", 3098);
    freq.put(" y", 17192);
    freq.put("ueñ", 456);
    freq.put("ap ", 75);
    freq.put("gi", 1545);
    freq.put("gh", 106);
    freq.put(" B", 3750);
    freq.put(" C", 6287);
    freq.put(" A", 6754);
    freq.put(" F", 2137);
    freq.put(" G", 2616);
    freq.put(" D", 4689);
    freq.put(" E", 8537);
    freq.put(" J", 2417);
    freq.put(" K", 453);
    freq.put(" H", 2878);
    freq.put(" I", 1698);
    freq.put(" N", 3715);
    freq.put(" O", 1776);
    freq.put(" L", 5787);
    freq.put(" M", 7417);
    freq.put(" R", 3444);
    freq.put(" S", 6524);
    freq.put(" P", 6919);
    freq.put(" Q", 2010);
    freq.put(" V", 2604);
    freq.put(" W", 494);
    freq.put(" T", 4422);
    freq.put(" U", 1599);
    freq.put(" Z", 325);
    freq.put("mil", 711);
    freq.put(" X", 913);
    freq.put(" Y", 3025);
    freq.put("né ", 29);
    freq.put("Nor", 44);
    freq.put("Nos", 159);
    freq.put("ch ", 118);
    freq.put("ed ", 357);
    freq.put("sú", 41);
    freq.put("leí", 70);
    freq.put("rés", 62);
    freq.put("P", 7324);
    freq.put("tue", 97);
    freq.put("d ", 5345);
    freq.put("g ", 885);
    freq.put("asq", 43);
    freq.put("zco", 125);
    freq.put("tri", 517);
    freq.put("evi", 569);
    freq.put("aró", 26);
    freq.put("rdó", 74);
    freq.put("evo", 950);
    freq.put("tra", 4620);
    freq.put("eva", 1160);
    freq.put("us ", 1102);
    freq.put("No ", 1707);
    freq.put("eve", 575);
    freq.put("ws ", 57);
    freq.put("Ahí", 40);
    freq.put("cas", 2003);
    freq.put("sé ", 422);
    freq.put("Spo", 51);
    freq.put("rdí", 36);
    freq.put("Spa", 67);
    freq.put("ddd", 45);
    freq.put("rae", 135);
    freq.put("evu", 45);
    freq.put("zl", 27);
    freq.put("zm", 28);
    freq.put("zn", 26);
    freq.put(" á", 164);
    freq.put("gó", 97);
    freq.put("zi", 128);
    freq.put("rri", 661);
    freq.put("uej", 107);
    freq.put("uee", 85);
    freq.put("ze", 95);
    freq.put("rre", 975);
    freq.put(" é", 433);
    freq.put("uea", 73);
    freq.put("gú", 322);
    freq.put("rra", 1247);
    freq.put(" í", 40);
    freq.put(" ó", 47);
    freq.put("Blo", 50);
    freq.put(" ñ", 29);
    freq.put("cau", 68);
    freq.put("gá", 66);
    freq.put("odo", 2370);
    freq.put(" ú", 470);
    freq.put("zu", 156);
    freq.put("gí", 142);
    freq.put("uev", 1259);
    freq.put("Bla", 93);
    freq.put("zq", 67);
    freq.put("ues", 3055);
    freq.put("uer", 2670);
    freq.put(" Re", 902);
    freq.put("Ah ", 94);
    freq.put(" Á", 105);
    freq.put("caj", 70);
    freq.put("med", 668);
    freq.put(" É", 40);
    freq.put("cai", 87);
    freq.put("arí", 462);
    freq.put("ct ", 51);
    freq.put("rd ", 148);
    freq.put("Ori", 46);
    freq.put(" Ú", 59);
    freq.put("Org", 29);
    freq.put("éf", 97);
    freq.put("can", 2160);
    freq.put("lea", 348);
    freq.put("leb", 113);
    freq.put(" ¡", 991);
    freq.put("led", 65);
    freq.put("flo", 72);
    freq.put("lef", 56);
    freq.put("och", 1148);
    freq.put(" ª", 82);
    freq.put("ozo", 46);
    freq.put("lej", 182);
    freq.put("acr", 73);
    freq.put("z ", 1959);
    freq.put("ock", 81);
    freq.put(" ¬", 159);
    freq.put("rr ", 75);
    freq.put("puj", 37);
    freq.put("cac", 703);
    freq.put("ler", 428);
    freq.put("les", 2503);
    freq.put("let", 504);
    freq.put("web", 173);
    freq.put("lev", 929);
    freq.put("cab", 1344);
    freq.put(" º", 127);
    freq.put("ley", 179);
    freq.put("lez", 98);
    freq.put("hís", 58);
    freq.put(" ¿", 2315);
    freq.put("Rel", 26);
    freq.put("ocl", 47);
    freq.put("tré", 28);
    freq.put("eni", 1152);
    freq.put("Áng", 26);
    freq.put("zac", 123);
    freq.put("xam", 106);
    freq.put("ctr", 86);
    freq.put("trá", 139);
    freq.put("cno", 56);
    freq.put("céi", 29);
    freq.put("Aho", 324);
    freq.put("ast", 1758);
    freq.put("ulg", 33);
    freq.put("cés", 33);
    freq.put("cte", 93);
    freq.put("rda", 1501);
    freq.put("cta", 482);
    freq.put("rdo", 665);
    freq.put("cto", 1038);
    freq.put("rdi", 416);
    freq.put("cti", 425);
    freq.put(" Do", 322);
    freq.put("pq ", 70);
    freq.put("éfi", 36);
    freq.put("Ver", 145);
    freq.put("tañ", 51);
    freq.put(" Di", 771);
    freq.put("apr", 387);
    freq.put("aps", 38);
    freq.put(" De", 1477);
    freq.put("sgr", 48);
    freq.put("am ", 224);
    freq.put("tav", 41);
    freq.put(" Da", 318);
    freq.put("iet", 114);
    freq.put("rít", 52);
    freq.put("onó", 64);
    freq.put("ii ", 216);
    freq.put("sgo", 63);
    freq.put("voy", 993);
    freq.put("Veo", 30);
    freq.put(" Du", 140);
    freq.put("apa", 1209);
    freq.put(" Dr", 74);
    freq.put("Mil", 82);
    freq.put("sió", 592);
    freq.put("Hue", 36);
    freq.put("Fr", 251);
    freq.put("LL ", 30);
    freq.put("usc", 338);
    freq.put("Fu", 159);
    freq.put("usa", 372);
    freq.put("fea", 46);
    freq.put("fen", 163);
    freq.put("Hum", 36);
    freq.put("fel", 392);
    freq.put("fem", 37);
    freq.put(" ví", 805);
    freq.put("usi", 350);
    freq.put("fei", 27);
    freq.put("Fa", 428);
    freq.put("fet", 58);
    freq.put("iej", 93);
    freq.put("fer", 665);
    freq.put("Fe", 364);
    freq.put("usq", 35);
    freq.put("usp", 40);
    freq.put("Fi", 235);
    freq.put("zil", 34);
    freq.put("Fl", 107);
    freq.put("spr", 56);
    freq.put("Fo", 218);
    freq.put("ue ", 22263);
    freq.put("Gua", 107);
    freq.put("iis", 27);
    freq.put("º ", 128);
    freq.put("Gui", 40);
    freq.put("aca", 1616);
    freq.put(" D ", 412);
    freq.put("Ñ", 30);
    freq.put("uel", 1606);
    freq.put("teg", 147);
    freq.put("xcl", 40);
    freq.put("bo ", 569);
    freq.put("iii", 446);
    freq.put("Me ", 1306);
    freq.put(" Ru", 203);
    freq.put("Opo", 30);
    freq.put("ace", 2924);
    freq.put("fe ", 153);
    freq.put("f", 15553);
    freq.put("ox ", 74);
    freq.put("km ", 42);
    freq.put("wh", 54);
    freq.put("ied", 314);
    freq.put("F ", 155);
    freq.put("nda", 1463);
    freq.put("tag", 106);
    freq.put(" Ra", 407);
    freq.put("enn", 64);
    freq.put(" Ro", 411);
    freq.put(" Ri", 181);
    freq.put(" c ", 64);
    freq.put("tat", 259);
    freq.put("tau", 55);
    freq.put(" Dí", 63);
    freq.put("ach", 449);
    freq.put("tap", 95);
    freq.put("taq", 53);
    freq.put("tar", 3705);
    freq.put("tas", 2389);
    freq.put("ífi", 62);
    freq.put("spo", 476);
    freq.put("ró ", 72);
    freq.put("omá", 58);
    freq.put("taz", 116);
    freq.put("tad", 1701);
    freq.put("taf", 56);
    freq.put("néi", 60);
    freq.put("taa", 92);
    freq.put("tab", 688);
    freq.put("tac", 652);
    freq.put("tal", 1455);
    freq.put("tam", 1703);
    freq.put("tan", 2766);
    freq.put("tao", 44);
    freq.put("cni", 54);
    freq.put("taj", 94);
    freq.put(" va", 3150);
    freq.put("sir", 69);
    freq.put("siq", 73);
    freq.put("sip", 27);
    freq.put(" ve", 5846);
    freq.put("siv", 129);
    freq.put("Yo", 855);
    freq.put("sit", 923);
    freq.put("Ya", 717);
    freq.put("ché", 29);
    freq.put("Ye", 26);
    freq.put("chí", 58);
    freq.put(" vo", 1817);
    freq.put("spe", 1783);
    freq.put("sic", 530);
    freq.put("sib", 271);
    freq.put(" vs", 57);
    freq.put(" vu", 734);
    freq.put("sie", 1168);
    freq.put("sid", 554);
    freq.put("agi", 272);
    freq.put("sii", 87);
    freq.put("xce", 75);
    freq.put("sio", 503);
    freq.put("sin", 1320);
    freq.put("sim", 563);
    freq.put("sil", 257);
    freq.put("sis", 442);
    freq.put("rón", 159);
    freq.put("íst", 71);
    freq.put("acu", 418);
    freq.put("ará", 802);
    freq.put("es ", 22834);
    freq.put("suy", 54);
    freq.put("Q", 2404);
    freq.put("uje", 265);
    freq.put("alq", 181);
    freq.put("ta ", 8835);
    freq.put("ald", 413);
    freq.put("afi", 203);
    freq.put("éis", 324);
    freq.put(" v ", 26);
    freq.put("dd ", 38);
    freq.put("Y ", 1557);
    freq.put("mío", 86);
    freq.put("enr", 30);
    freq.put(" vi", 3873);
    freq.put("bun", 32);
    freq.put("si ", 3667);
    freq.put("afe", 132);
    freq.put("ato", 759);
    freq.put("TO ", 96);
    freq.put("asc", 279);
    freq.put("áis", 214);
    freq.put("úl", 320);
    freq.put("úm", 93);
    freq.put("ún", 745);
    freq.put("da ", 7177);
    freq.put("Aye", 73);
    freq.put("úa", 52);
    freq.put("úb", 135);
    freq.put("kbe", 29);
    freq.put("lgu", 994);
    freq.put("ñer", 97);
    freq.put("zg", 32);
    freq.put("é ", 2958);
    freq.put("Ayu", 45);
    freq.put("úp", 53);
    freq.put("út", 198);
    freq.put("lf", 118);
    freq.put("lg", 2264);
    freq.put("ld", 680);
    freq.put("le", 14022);
    freq.put("lb", 239);
    freq.put("lc", 455);
    freq.put("la", 30932);
    freq.put("lo", 19926);
    freq.put("ll", 7873);
    freq.put("lm", 651);
    freq.put("lk", 68);
    freq.put("li", 7833);
    freq.put("lv", 1151);
    freq.put("lt", 2416);
    freq.put("lu", 2570);
    freq.put("lr", 73);
    freq.put("ls", 597);
    freq.put("lp", 287);
    freq.put("lq", 190);
    freq.put("asa", 2179);
    freq.put("sig", 847);
    freq.put(" h ", 187);
    freq.put("lz", 39);
    freq.put("asu", 171);
    freq.put("ly", 195);
    freq.put("dad", 3005);
    freq.put("coñ", 170);
    freq.put("daf", 56);
    freq.put("Twi", 250);
    freq.put("daa", 41);
    freq.put("dab", 157);
    freq.put("dac", 99);
    freq.put("Cas", 219);
    freq.put("enu", 236);
    freq.put("ecí", 109);
    freq.put("Cap", 66);
    freq.put("ú ", 429);
    freq.put("Ay ", 50);
    freq.put("Cat", 100);
    freq.put("dat", 155);
    freq.put("dav", 179);
    freq.put("dap", 26);
    freq.put("Can", 164);
    freq.put("Cam", 198);
    freq.put("Cal", 120);
    freq.put("qué", 890);
    freq.put("Cab", 52);
    freq.put("mñn", 30);
    freq.put("quí", 567);
    freq.put("day", 36);
    freq.put("daz", 61);
    freq.put("Cad", 130);
    freq.put("ññ", 30);
    freq.put("Dón", 31);
    freq.put("nfe", 141);
    freq.put("nya", 78);
    freq.put("San", 319);
    freq.put("ç", 282);
    freq.put("env", 326);
    freq.put("nfo", 416);
    freq.put("Sab", 140);
    freq.put("Pro", 213);
    freq.put("nfl", 53);
    freq.put("Pri", 132);
    freq.put("eu ", 109);
    freq.put(" hu", 645);
    freq.put(" ht", 158);
    freq.put(" hi", 889);
    freq.put("FB ", 28);
    freq.put(" ho", 2501);
    freq.put("nfr", 55);
    freq.put("rto", 1082);
    freq.put("len", 965);
    freq.put(" ha", 9397);
    freq.put("ñí", 36);
    freq.put(" he", 2366);
    freq.put("bis", 42);
    freq.put("oun", 48);
    freq.put("ec ", 32);
    freq.put("Neg", 46);
    freq.put("lfo", 33);
    freq.put("Dio", 201);
    freq.put("aré", 354);
    freq.put("muc", 1322);
    freq.put("ous", 66);
    freq.put("our", 197);
    freq.put("out", 59);
    freq.put("rez", 224);
    freq.put("rey", 75);
    freq.put("Nav", 60);
    freq.put("là", 33);
    freq.put("lá", 320);
    freq.put("rer", 417);
    freq.put("res", 5423);
    freq.put("rep", 663);
    freq.put("lí", 696);
    freq.put("rev", 496);
    freq.put("rfa", 71);
    freq.put("ret", 666);
    freq.put("lé", 303);
    freq.put("rej", 123);
    freq.put("may", 234);
    freq.put("rei", 271);
    freq.put("ren", 1670);
    freq.put("ló", 277);
    freq.put("rel", 390);
    freq.put("rem", 890);
    freq.put("reb", 146);
    freq.put("rec", 3240);
    freq.put("rea", 928);
    freq.put("ref", 583);
    freq.put("reg", 969);
    freq.put("red", 472);
    freq.put("ree", 449);
    freq.put("lob", 58);
    freq.put("ece", 2014);
    freq.put("maz", 72);
    freq.put("ecc", 303);
    freq.put("eca", 314);
    freq.put("CE ", 28);
    freq.put("eco", 787);
    freq.put("ecn", 73);
    freq.put("ecl", 133);
    freq.put("ss ", 274);
    freq.put("mir", 775);
    freq.put("eci", 1927);
    freq.put("ech", 1328);
    freq.put("qua", 65);
    freq.put("lé ", 44);
    freq.put("ecu", 468);
    freq.put("ect", 1245);
    freq.put("que", 22904);
    freq.put("ecr", 90);
    freq.put("nny", 42);
    freq.put("x", 6203);
    freq.put("qui", 3792);
    freq.put("ltr", 105);
    freq.put("zap", 39);
    freq.put("FE ", 30);
    freq.put("g", 31289);
    freq.put("ask", 64);
    freq.put("Ric", 54);
    freq.put("ña", 2728);
    freq.put("uña", 98);
    freq.put("lta", 1128);
    freq.put("snu", 27);
    freq.put("ñe", 221);
    freq.put("nLo", 27);
    freq.put("lte", 119);
    freq.put("vac", 419);
    freq.put("ñi", 100);
    freq.put("róx", 155);
    freq.put("re ", 4520);
    freq.put("fot", 575);
    freq.put("lto", 288);
    freq.put("ü", 138);
    freq.put("ño", 2669);
    freq.put("ñn", 39);
    freq.put("Fot", 51);
    freq.put("K ", 119);
    freq.put("sev", 52);
    freq.put("ént", 56);
    freq.put("uñe", 40);
    freq.put("rs ", 354);
    freq.put("arr", 1231);
    freq.put("ud ", 127);
    freq.put("set", 195);
    freq.put("azi", 40);
    freq.put("énd", 115);
    freq.put("ses", 656);
    freq.put("tán", 397);
    freq.put("Paí", 28);
    freq.put("mié", 44);
    freq.put("lor", 854);
    freq.put("¡¡¡", 107);
    freq.put("los", 6573);
    freq.put(" Sp", 148);
    freq.put(" St", 205);
    freq.put(" Su", 440);
    freq.put("UN ", 27);
    freq.put(" Sk", 38);
    freq.put(" Sh", 86);
    freq.put(" Si", 1492);
    freq.put(" So", 737);
    freq.put("ton", 709);
    freq.put("mno", 38);
    freq.put(" Sc", 74);
    freq.put(" Sa", 832);
    freq.put("ali", 1748);
    freq.put("nut", 233);
    freq.put("uas", 61);
    freq.put(" Se", 1342);
    freq.put("Ka", 98);
    freq.put("rso", 748);
    freq.put("rsi", 243);
    freq.put("Ke", 69);
    freq.put("ogu", 62);
    freq.put("rse", 791);
    freq.put("Ki", 98);
    freq.put("pág", 75);
    freq.put("Ko", 31);
    freq.put("rsa", 186);
    freq.put("ogr", 400);
    freq.put("ogl", 153);
    freq.put("ogo", 101);
    freq.put("R", 3516);
    freq.put("ogi", 123);
    freq.put("too", 82);
    freq.put("Ku", 37);
    freq.put("vas", 563);
    freq.put("oge", 156);
    freq.put("ogg", 26);
    freq.put("udi", 469);
    freq.put("oga", 148);
    freq.put("udo", 363);
    freq.put("vie", 1221);
    freq.put("ógi", 58);
    freq.put("bei", 48);
    freq.put("ben", 283);
    freq.put("bel", 243);
    freq.put("bem", 71);
    freq.put("beb", 120);
    freq.put("urí", 40);
    freq.put("bea", 34);
    freq.put("onc", 748);
    freq.put("arb", 133);
    freq.put("apu", 201);
    freq.put("UU ", 52);
    freq.put("AL ", 75);
    freq.put("sed", 31);
    freq.put("ber", 1288);
    freq.put("bes", 750);
    freq.put(" S ", 164);
    freq.put("sq", 381);
    freq.put("bet", 45);
    freq.put("are", 1792);
    freq.put("Pap", 214);
    freq.put("Par", 482);
    freq.put("Pas", 125);
    freq.put("Pat", 56);
    freq.put("Pau", 41);
    freq.put("ÓN ", 45);
    freq.put("nqu", 629);
    freq.put("og ", 174);
    freq.put(" E ", 54);
    freq.put("¡Es", 29);
    freq.put("urm", 53);
    freq.put("lin", 471);
    freq.put("seo", 132);
    freq.put("Pab", 50);
    freq.put("Pac", 37);
    freq.put("Pad", 67);
    freq.put("ari", 2024);
    freq.put("le ", 4371);
    freq.put("Pal", 80);
    freq.put("xd ", 36);
    freq.put("Pan", 37);
    freq.put("tón", 171);
    freq.put("sk", 204);
    freq.put("tól", 62);
    freq.put("MO ", 37);
    freq.put("ur ", 153);
    freq.put("ck ", 288);
    freq.put("lec", 556);
    freq.put("min", 1281);
    freq.put("mia", 158);
    freq.put(" Só", 61);
    freq.put("mic", 250);
    freq.put("mús", 136);
    freq.put("mie", 1524);
    freq.put("mid", 228);
    freq.put("mig", 754);
    freq.put("uu ", 56);
    freq.put("als", 129);
    freq.put("Dep", 59);
    freq.put("arn", 198);
    freq.put(" Sí", 151);
    freq.put("bru", 71);
    freq.put("ER ", 96);
    freq.put("mis", 1546);
    freq.put(" Sá", 37);
    freq.put("mit", 498);
    freq.put("Dia", 98);
    freq.put(" El", 2181);
    freq.put(" Em", 200);
    freq.put(" En", 1236);
    freq.put("río", 91);
    freq.put("caí", 68);
    freq.put(" Ej", 27);
    freq.put(" Ed", 103);
    freq.put("OY ", 26);
    freq.put("Edu", 63);
    freq.put("sfr", 256);
    freq.put("dái", 30);
    freq.put(" Ec", 96);
    freq.put("ogí", 79);
    freq.put("sfo", 32);
    freq.put("nq ", 34);
    freq.put("ute", 102);
    freq.put(" Ex", 153);
    freq.put("but", 61);
    freq.put("st ", 263);
    freq.put(" Et", 28);
    freq.put(" Eu", 185);
    freq.put(" Ev", 48);
    freq.put("ny ", 116);
    freq.put(" Er", 151);
    freq.put(" Es", 3267);
    freq.put("cke", 54);
    freq.put("ure", 124);
    freq.put("lee", 291);
    freq.put("urg", 113);
    freq.put("mus", 156);
    freq.put("urb", 95);
    freq.put("ckb", 31);
    freq.put("lpa", 155);
    freq.put("Pot", 34);
    freq.put("xD ", 420);
    freq.put("Por", 866);
    freq.put("Dej", 64);
    freq.put("tó ", 160);
    freq.put("Pon", 83);
    freq.put("Pol", 105);
    freq.put("afr", 41);
    freq.put("con", 9346);
    freq.put("cks", 41);
    freq.put("Lun", 41);
    freq.put("Del", 109);
    freq.put("Pod", 90);
    freq.put("sd", 667);
    freq.put("cky", 28);
    freq.put("ury", 28);
    freq.put("Dem", 68);
    freq.put("pít", 60);
    freq.put("ngl", 192);
    freq.put("Den", 41);
    freq.put("Cha", 112);
    freq.put(" iP", 134);
    freq.put("muy", 987);
    freq.put("NI ", 31);
    freq.put("bum", 32);
    freq.put("VI ", 26);
    freq.put("mux", 35);
    freq.put("uet", 171);
    freq.put("Pá", 30);
    freq.put("tb ", 107);
    freq.put("wor", 36);
    freq.put("eas", 343);
    freq.put("leg", 1355);
    freq.put("Che", 55);
    freq.put("one", 3061);
    freq.put(" ¡¡", 110);
    freq.put(" iz", 58);
    freq.put("Dec", 56);
    freq.put("urn", 61);
    freq.put("paq", 33);
    freq.put("co ", 2827);
    freq.put(" ip", 31);
    freq.put("Mor", 83);
    freq.put(" ir", 790);
    freq.put(" is", 60);
    freq.put(" it", 54);
    freq.put("jas", 235);
    freq.put("jap", 36);
    freq.put("Mot", 45);
    freq.put("jan", 264);
    freq.put("q ", 2804);
    freq.put("jal", 159);
    freq.put("jam", 148);
    freq.put("jaj", 6121);
    freq.put(" im", 1010);
    freq.put(" in", 3235);
    freq.put("lso", 68);
    freq.put("mua", 39);
    freq.put("jad", 272);
    freq.put("bue", 1679);
    freq.put("jab", 33);
    freq.put(" ig", 422);
    freq.put("xdd", 48);
    freq.put("ísi", 223);
    freq.put("no ", 13183);
    freq.put("uaj", 44);
    freq.put("act", 748);
    freq.put("vim", 72);
    freq.put("tbo", 287);
    freq.put("mul", 137);
    freq.put("Tem", 44);
    freq.put("TA ", 119);
    freq.put("tmb", 28);
    freq.put(" we", 204);
    freq.put("qu", 28292);
    freq.put("VA ", 44);
    freq.put(" wa", 86);
    freq.put("h", 29724);
    freq.put(" wh", 35);
    freq.put(" wi", 61);
    freq.put(" ww", 67);
    freq.put("qe", 176);
    freq.put("ks ", 90);
    freq.put(" i ", 272);
    freq.put("shi", 57);
    freq.put("tlé", 40);
    freq.put("muj", 198);
    freq.put("ael", 66);
    freq.put("ja ", 2347);
    freq.put("sho", 55);
    freq.put("Pr", 666);
    freq.put("ebe", 746);
    freq.put("eba", 298);
    freq.put("Pu", 851);
    freq.put("ebl", 227);
    freq.put("uim", 90);
    freq.put("ebo", 316);
    freq.put("vía", 793);
    freq.put("we", 623);
    freq.put("ofu", 27);
    freq.put("ke ", 209);
    freq.put("jo ", 1366);
    freq.put("ebu", 58);
    freq.put("Pa", 1319);
    freq.put("ebr", 201);
    freq.put("Pe", 1196);
    freq.put("ede", 1312);
    freq.put("Ph", 113);
    freq.put("Pi", 301);
    freq.put("Po", 1345);
    freq.put("Pl", 192);
    freq.put("lve", 453);
    freq.put("lur", 30);
    freq.put("lus", 231);
    freq.put("lut", 66);
    freq.put("ome", 1498);
    freq.put("dle", 34);
    freq.put("luy", 42);
    freq.put("luz", 91);
    freq.put("XD ", 131);
    freq.put("dlo", 31);
    freq.put("Jac", 29);
    freq.put("épo", 35);
    freq.put("et ", 506);
    freq.put("luc", 391);
    freq.put("lud", 301);
    freq.put("lue", 492);
    freq.put("lug", 108);
    freq.put("tá ", 1083);
    freq.put("lui", 67);
    freq.put("luj", 36);
    freq.put("ús", 249);
    freq.put("lul", 26);
    freq.put("omi", 785);
    freq.put("ngú", 59);
    freq.put(" ¡A", 44);
    freq.put(" ¡B", 45);
    freq.put("kel", 30);
    freq.put(" ¡D", 28);
    freq.put(" ¡E", 82);
    freq.put("jov", 73);
    freq.put(" ¡G", 31);
    freq.put(" ¡H", 33);
    freq.put("joy", 79);
    freq.put("ked", 51);
    freq.put(" ¡M", 49);
    freq.put(" ¡N", 43);
    freq.put(" ¡P", 33);
    freq.put(" ¡Q", 64);
    freq.put("P ", 460);
    freq.put(" ¡S", 51);
    freq.put("jod", 302);
    freq.put("joe", 34);
    freq.put(" ¡V", 28);
    freq.put("Ave", 32);
    freq.put(" ¡Y", 27);
    freq.put("joj", 35);
    freq.put("Exi", 26);
    freq.put("ker", 102);
    freq.put("jon", 180);
    freq.put("joo", 28);
    freq.put("etr", 402);
    freq.put("ets", 171);
    freq.put("dl ", 51);
    freq.put("ápi", 75);
    freq.put("etw", 49);
    freq.put("ett", 51);
    freq.put("etu", 63);
    freq.put("ady", 45);
    freq.put("è", 87);
    freq.put("llu", 140);
    freq.put("aho", 1014);
    freq.put("lu ", 42);
    freq.put("etc", 69);
    freq.put("CR ", 28);
    freq.put("eta", 1137);
    freq.put("ote", 586);
    freq.put("ete", 1081);
    freq.put("eti", 637);
    freq.put("Zar", 58);
    freq.put(" aj", 149);
    freq.put("Zap", 43);
    freq.put("ck", 530);
    freq.put("vá", 28);
    freq.put("ci", 16035);
    freq.put("ch", 7638);
    freq.put("co", 22722);
    freq.put("Exp", 48);
    freq.put("Her", 70);
    freq.put("cl", 1390);
    freq.put("cc", 763);
    freq.put(" al", 5809);
    freq.put("ca", 17107);
    freq.put("Lon", 100);
    freq.put("ví", 1006);
    freq.put("ce", 8930);
    freq.put("cd", 31);
    freq.put("Lor", 43);
    freq.put("Los", 643);
    freq.put("cy", 30);
    freq.put("Est", 1278);
    freq.put("rpe", 39);
    freq.put("lis", 531);
    freq.put("uca", 222);
    freq.put("Hel", 27);
    freq.put("Hem", 39);
    freq.put("ucl", 26);
    freq.put("uck", 50);
    freq.put("cu", 6792);
    freq.put("ct", 2625);
    freq.put("Ger", 26);
    freq.put("adl", 31);
    freq.put("Jua", 91);
    freq.put("rve", 149);
    freq.put("Get", 31);
    freq.put("tí ", 47);
    freq.put("Esp", 856);
    freq.put("Jun", 49);
    freq.put("jit", 72);
    freq.put("Jul", 36);
    freq.put("yar", 35);
    freq.put("uct", 143);
    freq.put("Jus", 201);
    freq.put("yan", 120);
    freq.put("uuc", 30);
    freq.put("pia", 198);
    freq.put("eón", 74);
    freq.put("més", 54);
    freq.put("mér", 49);
    freq.put("yaa", 32);
    freq.put("Gen", 134);
    freq.put(" au", 833);
    freq.put("OL ", 61);
    freq.put("oti", 396);
    freq.put("Lo ", 571);
    freq.put("Hom", 59);
    freq.put("lgo", 830);
    freq.put("cop", 227);
    freq.put("pid", 417);
    freq.put("c ", 849);
    freq.put("edo", 972);
    freq.put("cos", 1875);
    freq.put("uil", 312);
    freq.put("cor", 1200);
    freq.put("He ", 171);
    freq.put("emá", 259);
    freq.put("señ", 424);
    freq.put("ots", 44);
    freq.put("ª ", 76);
    freq.put("cot", 101);
    freq.put("And", 187);
    freq.put("mín", 41);
    freq.put("Ang", 63);
    freq.put(" Tú", 53);
    freq.put("vés", 61);
    freq.put("é", 6452);
    freq.put("rbu", 26);
    freq.put("bañ", 85);
    freq.put("as", 30963);
    freq.put("Ant", 176);
    freq.put(" Tí", 26);
    freq.put("uir", 556);
    freq.put("sól", 244);
    freq.put("rbi", 128);
    freq.put("uny", 44);
    freq.put("Esc", 127);
    freq.put("rbe", 47);
    freq.put("eur", 237);
    freq.put("ati", 752);
    freq.put("ya ", 3312);
    freq.put("rba", 129);
    freq.put("Hos", 30);
    freq.put("bir", 284);
    freq.put("va", 6127);
    freq.put("cé", 114);
    freq.put(" Fr", 248);
    freq.put(" Fu", 157);
    freq.put("Esa", 62);
    freq.put("cí", 431);
    freq.put("ñe ", 27);
    freq.put("onq", 27);
    freq.put("vi", 7390);
    freq.put("cá", 199);
    freq.put("uiv", 68);
    freq.put("vo", 4145);
    freq.put(" Fa", 422);
    freq.put("Eso", 257);
    freq.put("vs", 69);
    freq.put(" Fe", 351);
    freq.put("vu", 824);
    freq.put("có", 383);
    freq.put("ave", 323);
    freq.put("You", 51);
    freq.put(" Fl", 88);
    freq.put(" Fo", 208);
    freq.put("io ", 3481);
    freq.put(" éx", 41);
    freq.put("coa", 28);
    freq.put("of ", 57);
    freq.put("pis", 313);
    freq.put("RA ", 89);
    freq.put("edr", 146);
    freq.put(" ép", 36);
    freq.put(" és", 114);
    freq.put("coc", 275);
    freq.put("dal", 259);
    freq.put("cob", 156);
    freq.put(" él", 206);
    freq.put("vió", 47);
    freq.put("Car", 272);
    freq.put("toñ", 34);
    freq.put("AA ", 40);
    freq.put("uqu", 56);
    freq.put("dan", 721);
    freq.put(" T ", 158);
    freq.put("v ", 159);
    freq.put("SO ", 51);
    freq.put("dao", 32);
    freq.put("pho", 62);
    freq.put("unf", 78);
    freq.put("ay ", 1668);
    freq.put("Lam", 29);
    freq.put("tod", 2711);
    freq.put("iot", 90);
    freq.put("ios", 1775);
    freq.put("ior", 217);
    freq.put("dai", 36);
    freq.put("ioo", 33);
    freq.put(" F ", 38);
    freq.put("iom", 42);
    freq.put("iol", 218);
    freq.put("uni", 599);
    freq.put("Dis", 118);
    freq.put("iod", 143);
    freq.put("igr", 110);
    freq.put("¡A", 51);
    freq.put("¡C", 33);
    freq.put("¡B", 49);
    freq.put("¡E", 92);
    freq.put("¡D", 31);
    freq.put("¡G", 32);
    freq.put("ofe", 289);
    freq.put(" Tw", 271);
    freq.put("¡H", 37);
    freq.put(" Tu", 269);
    freq.put("ofi", 160);
    freq.put("¡M", 52);
    freq.put(" Tr", 396);
    freq.put(" id", 507);
    freq.put(" To", 592);
    freq.put("¡P", 40);
    freq.put("¡S", 55);
    freq.put("ske", 62);
    freq.put("¡T", 34);
    freq.put(" Ti", 300);
    freq.put(" Th", 152);
    freq.put("¡Y", 32);
    freq.put(" Te", 1042);
    freq.put("crí", 65);
    freq.put("rtu", 256);
    freq.put(" Ta", 328);
    freq.put("onu", 50);
    freq.put("Roc", 27);
    freq.put(" ▸ ", 75);
    freq.put("dar", 1102);
    freq.put("das", 1604);
    freq.put(" xD", 2148);
    freq.put("tch", 51);
    freq.put("mpe", 670);
    freq.put("AR ", 49);
    freq.put("lex", 117);
    freq.put("tca", 43);
    freq.put(" xk", 27);
    freq.put("Be", 463);
    freq.put("vab", 33);
    freq.put("tt ", 55);
    freq.put(" xo", 51);
    freq.put("Ba", 791);
    freq.put("wee", 281);
    freq.put("Bl", 168);
    freq.put(" xa", 60);
    freq.put("Bo", 351);
    freq.put("Oh ", 62);
    freq.put("Bi", 361);
    freq.put(" xd", 198);
    freq.put("ómo", 375);
    freq.put("Bu", 1042);
    freq.put("ade", 926);
    freq.put("Fan", 31);
    freq.put("nor", 463);
    freq.put("Br", 235);
    freq.put(" mm", 63);
    freq.put("Fac", 183);
    freq.put(" xq", 92);
    freq.put("és ", 757);
    freq.put("¿", 2375);
    freq.put("adi", 791);
    freq.put("Pre", 260);
    freq.put("amb", 1694);
    freq.put("umi", 101);
    freq.put("xe ", 39);
    freq.put("Mod", 30);
    freq.put("ómi", 61);
    freq.put("nve", 467);
    freq.put("T", 4637);
    freq.put("nva", 32);
    freq.put("nvo", 86);
    freq.put("IO ", 33);
    freq.put("tc ", 60);
    freq.put("ndé", 26);
    freq.put("B ", 206);
    freq.put("l ", 30021);
    freq.put("bie", 1980);
    freq.put("ía ", 3932);
    freq.put(" x ", 426);
    freq.put(" jó", 56);
    freq.put("ést", 54);
    freq.put("mía", 177);
    freq.put("sk ", 30);
    freq.put("ad ", 2422);
    freq.put("Las", 374);
    freq.put("uri", 498);
    freq.put("nja", 87);
    freq.put("Sub", 31);
    freq.put("nje", 29);
    freq.put("ui ", 414);
    freq.put("ubv", 26);
    freq.put("rgi", 110);
    freq.put("ueb", 318);
    freq.put("Sus", 30);
    freq.put("nfi", 236);
    freq.put("nju", 48);
    freq.put("¡Qu", 69);
    freq.put("pón", 26);
    freq.put("Lui", 45);
    freq.put("hí ", 219);
    freq.put("U ", 241);
    freq.put("tum", 112);
    freq.put("utr", 36);
    freq.put("esv", 42);
    freq.put("esu", 260);
    freq.put("est", 11200);
    freq.put("ess", 265);
    freq.put("esq", 156);
    freq.put("esp", 2844);
    freq.put("nd ", 172);
    freq.put("ñía", 33);
    freq.put("esg", 126);
    freq.put("esf", 73);
    freq.put("ese", 1408);
    freq.put("esd", 603);
    freq.put("esc", 1884);
    freq.put("esb", 35);
    freq.put("esa", 1935);
    freq.put("eso", 2023);
    freq.put("esn", 37);
    freq.put("esm", 60);
    freq.put("esl", 31);
    freq.put("esk", 26);
    freq.put("esi", 1247);
    freq.put("esh", 32);
    freq.put("qe ", 146);
    freq.put("óme", 42);
    freq.put("odé", 54);
    freq.put("oon", 50);
    freq.put("RO ", 72);
    freq.put("lle", 2204);
    freq.put("áct", 52);
    freq.put("léf", 60);
    freq.put("Us", 34);
    freq.put("Ur", 33);
    freq.put("vs ", 57);
    freq.put("Ul", 33);
    freq.put("Un", 1012);
    freq.put("Sar", 35);
    freq.put("OS ", 286);
    freq.put("nví", 35);
    freq.put("Uf", 33);
    freq.put("áfi", 74);
    freq.put("ndi", 1008);
    freq.put("Sch", 30);
    freq.put("ndo", 7268);
    freq.put(" ju", 1538);
    freq.put("nde", 2035);
    freq.put("aal", 26);
    freq.put("ndy", 26);
    freq.put(" jo", 618);
    freq.put("sí ", 1070);
    freq.put(" ji", 61);
    freq.put("by ", 74);
    freq.put(" jj", 28);
    freq.put(" je", 418);
    freq.put("nds", 33);
    freq.put("ndr", 612);
    freq.put(" ja", 2463);
    freq.put("EE ", 48);
    freq.put("pue", 3046);
    freq.put("duc", 499);
    freq.put("¿Ha", 48);
    freq.put("inú", 41);
    freq.put("owe", 96);
    freq.put("ea ", 1102);
    freq.put("ánc", 27);
    freq.put("Act", 54);
    freq.put("à ", 122);
    freq.put("due", 181);
    freq.put("ubl", 278);
    freq.put("añe", 115);
    freq.put("De ", 487);
    freq.put("ama", 1440);
    freq.put("h ", 1405);
    freq.put("ows", 55);
    freq.put("púb", 116);
    freq.put("Ami", 37);
    freq.put("AN ", 79);
    freq.put("vai", 71);
    freq.put("van", 746);
    freq.put("Amo", 39);
    freq.put("vam", 474);
    freq.put("Ama", 64);
    freq.put("rcu", 86);
    freq.put("aan", 36);
    freq.put("Ame", 37);
    freq.put("vag", 41);
    freq.put("vad", 235);
    freq.put("ubi", 469);
    freq.put("ouc", 37);
    freq.put("rco", 242);
    freq.put("rch", 180);
    freq.put("rci", 288);
    freq.put("var", 446);
    freq.put("rce", 389);
    freq.put("rca", 704);
    freq.put("vat", 108);
    freq.put("zor", 36);
    freq.put("eah", 35);
    freq.put("eak", 40);
    freq.put("hy", 30);
    freq.put("eam", 131);
    freq.put("eal", 543);
    freq.put("ean", 343);
    freq.put("hr", 57);
    freq.put("bus", 383);
    freq.put("eac", 91);
    freq.put("Des", 427);
    freq.put("Det", 26);
    freq.put("ead", 328);
    freq.put("ht", 250);
    freq.put("hu", 1011);
    freq.put("buj", 62);
    freq.put("hh", 329);
    freq.put("hi", 2171);
    freq.put("hn", 43);
    freq.put("ho", 6827);
    freq.put("hl", 41);
    freq.put("hm", 39);
    freq.put("buc", 35);
    freq.put("Deb", 67);
    freq.put("ha", 12717);
    freq.put("eat", 151);
    freq.put("Def", 28);
    freq.put("he", 4184);
    freq.put("aju", 30);
    freq.put("dus", 30);
    freq.put("Tel", 78);
    freq.put("dme", 44);
    freq.put("Ten", 349);
    freq.put("aah", 45);
    freq.put("avi", 491);
    freq.put("dmi", 93);
    freq.put("va ", 1898);
    freq.put("j", 21199);
    freq.put("réi", 53);
    freq.put("ai ", 68);
    freq.put("ow ", 118);
    freq.put("uap", 238);
    freq.put("lva", 281);
    freq.put("yon", 26);
    freq.put("lvo", 119);
    freq.put("lvi", 278);
    freq.put("Lue", 58);
    freq.put("pij", 32);
    freq.put("xq ", 89);
    freq.put("pil", 259);
    freq.put("OO ", 44);
    freq.put("pin", 400);
    freq.put("pio", 217);
    freq.put("int", 1364);
    freq.put("inu", 297);
    freq.put("inv", 371);
    freq.put("pic", 229);
    freq.put("Don", 111);
    freq.put("pie", 1024);
    freq.put("ins", 459);
    freq.put("inm", 70);
    freq.put("inn", 50);
    freq.put("ino", 1002);
    freq.put("inh", 106);
    freq.put("ini", 596);
    freq.put("inj", 32);
    freq.put("ink", 75);
    freq.put("ind", 562);
    freq.put("ine", 825);
    freq.put("inf", 427);
    freq.put("ing", 1092);
    freq.put("pit", 306);
    freq.put("ina", 2251);
    freq.put("arç", 240);
    freq.put("inc", 880);
    freq.put("Amé", 26);
    freq.put("eo ", 1929);
    freq.put("í ", 2547);
    freq.put("ít", 392);
    freq.put("urt", 49);
    freq.put("gía", 121);
    freq.put("ª", 86);
    freq.put("ejé", 28);
    freq.put(" Ur", 32);
    freq.put(" Us", 31);
    freq.put(" Ul", 33);
    freq.put("rcí", 28);
    freq.put(" Un", 981);
    freq.put("or ", 8946);
    freq.put(" mú", 139);
    freq.put("tma", 29);
    freq.put(" Uf", 32);
    freq.put("Mas", 78);
    freq.put("ubt", 26);
    freq.put("Aca", 153);
    freq.put("rqu", 1152);
    freq.put("DA ", 91);
    freq.put("ubr", 168);
    freq.put("pi ", 64);
    freq.put("hó", 27);
    freq.put("nfa", 110);
    freq.put("gar", 1140);
    freq.put("Bon", 91);
    freq.put("ube", 184);
    freq.put("hé", 45);
    freq.put("U", 1667);
    freq.put("uba", 141);
    freq.put("Sie", 126);
    freq.put("hí", 305);
    freq.put("eañ", 66);
    freq.put("my ", 106);
    freq.put("há", 43);
    freq.put("in ", 1901);
    freq.put("Mar", 511);
    freq.put("eoc", 161);
    freq.put("íd", 404);
    freq.put("íg", 50);
    freq.put("íf", 69);
    freq.put("ía", 5845);
    freq.put("íc", 357);
    freq.put("gan", 1521);
    freq.put("ím", 82);
    freq.put("ío", 354);
    freq.put("ín", 337);
    freq.put("eon", 96);
    freq.put("oel", 28);
    freq.put("eol", 44);
    freq.put("eos", 167);
    freq.put("eor", 280);
    freq.put("íp", 54);
    freq.put("ís", 562);
    freq.put("ír", 108);
    freq.put(" U ", 59);
    freq.put("Tur", 40);
  }
  
}

