package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ET {
  private static final String name = "et";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ET() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 132934;
    n_words[1] = 157648;
    n_words[2] = 124717;

    freq.put("aln", 12);
    freq.put("gai", 3);
    freq.put(" kä", 110);
    freq.put("rev", 5);
    freq.put("MA ", 6);
    freq.put("all", 165);
    freq.put("rew", 4);
    freq.put("gag", 6);
    freq.put("Loo", 10);
    freq.put("alm", 28);
    freq.put(" kö", 6);
    freq.put(" kõ", 159);
    freq.put("Ker", 3);
    freq.put("alj", 83);
    freq.put("blr", 5);
    freq.put("Ehk", 3);
    freq.put(" kü", 125);
    freq.put("alk", 28);
    freq.put("aua", 20);
    freq.put("Var", 4);
    freq.put("Val", 12);
    freq.put("aug", 9);
    freq.put("auk", 3);
    freq.put("aum", 3);
    freq.put("aul", 32);
    freq.put("up ", 6);
    freq.put("aun", 13);
    freq.put("aup", 17);
    freq.put("aus", 31);
    freq.put("rei", 16);
    freq.put("auu", 5);
    freq.put("gaa", 8);
    freq.put("Pos", 7);
    freq.put("G ", 23);
    freq.put("ren", 32);
    freq.put("ald", 30);
    freq.put(" Gu", 3);
    freq.put(" Gr", 14);
    freq.put("rel", 18);
    freq.put("neb", 13);
    freq.put("alb", 14);
    freq.put("Joh", 4);
    freq.put("AB ", 3);
    freq.put(" Ge", 5);
    freq.put("sse", 94);
    freq.put("aap", 3);
    freq.put("ava", 133);
    freq.put(" Go", 6);
    freq.put("ala", 122);
    freq.put("Tub", 4);
    freq.put("aju", 18);
    freq.put("upo", 3);
    freq.put("Gu", 6);
    freq.put("löö", 8);
    freq.put("num", 13);
    freq.put("Gr", 14);
    freq.put("upi", 14);
    freq.put("mi ", 57);
    freq.put("Kes", 14);
    freq.put("upe", 10);
    freq.put("cma", 3);
    freq.put("upa", 5);
    freq.put("õna", 9);
    freq.put("Ge", 7);
    freq.put("õnd", 8);
    freq.put("eS", 3);
    freq.put("Ga", 4);
    freq.put("õng", 3);
    freq.put("Go", 7);
    freq.put("õni", 10);
    freq.put("ens", 7);
    freq.put("upu", 5);
    freq.put("ärs", 14);
    freq.put("õnn", 33);
    freq.put("äbi", 38);
    freq.put(" ka", 545);
    freq.put("me ", 296);
    freq.put(" ke", 242);
    freq.put("äkk", 11);
    freq.put(" kk", 31);
    freq.put(" kh", 11);
    freq.put(" ki", 162);
    freq.put(" ko", 424);
    freq.put(" kl", 51);
    freq.put(" km", 3);
    freq.put(" kr", 44);
    freq.put(" ks", 4);
    freq.put(" kv", 3);
    freq.put("ais", 47);
    freq.put(" kt", 4);
    freq.put(" ku", 526);
    freq.put("pim", 21);
    freq.put(" ky", 4);
    freq.put("alt", 151);
    freq.put("nen", 31);
    freq.put("aim", 14);
    freq.put("nel", 31);
    freq.put("nem", 47);
    freq.put("nek", 31);
    freq.put("ly ", 13);
    freq.put("ail", 28);
    freq.put(" y ", 6);
    freq.put("neg", 4);
    freq.put("ned", 11);
    freq.put("nee", 42);
    freq.put("Z ", 13);
    freq.put("ärk", 25);
    freq.put("UD ", 5);
    freq.put("nea", 4);
    freq.put("orv", 6);
    freq.put("kum", 40);
    freq.put("ain", 104);
    freq.put("kuk", 21);
    freq.put("kuj", 8);
    freq.put("kui", 261);
    freq.put("rld", 4);
    freq.put("nev", 17);
    freq.put("Puu", 3);
    freq.put("net", 34);
    freq.put("tA", 5);
    freq.put("ner", 16);
    freq.put("Nüü", 17);
    freq.put("Pur", 3);
    freq.put("fuc", 11);
    freq.put("mee", 95);
    freq.put("med", 13);
    freq.put(" k ", 10);
    freq.put("ebe", 4);
    freq.put("not", 6);
    freq.put("ait", 25);
    freq.put("äb ", 10);
    freq.put("meo", 4);
    freq.put("ärn", 5);
    freq.put("mA ", 3);
    freq.put("meh", 13);
    freq.put("mek", 9);
    freq.put("ors", 6);
    freq.put("met", 39);
    freq.put("aub", 5);
    freq.put("mes", 56);
    freq.put("aid", 78);
    freq.put("TT ", 3);
    freq.put("aig", 41);
    freq.put("Jär", 8);
    freq.put("gli", 7);
    freq.put("dio", 11);
    freq.put("lol", 33);
    freq.put("äps", 14);
    freq.put(" yo", 18);
    freq.put("EV ", 3);
    freq.put("gla", 13);
    freq.put("k", 6002);
    freq.put("dru", 13);
    freq.put("gle", 5);
    freq.put("aku", 22);
    freq.put("sju", 15);
    freq.put("dri", 15);
    freq.put("aki", 15);
    freq.put("orm", 40);
    freq.put("ako", 18);
    freq.put("ärg", 47);
    freq.put("äpa", 8);
    freq.put("tw", 41);
    freq.put("dra", 25);
    freq.put("aka", 88);
    freq.put("sja", 30);
    freq.put("glt", 5);
    freq.put("ake", 41);
    freq.put("ku ", 95);
    freq.put("ats", 51);
    freq.put("Jes", 8);
    freq.put("Lä", 12);
    freq.put("tu", 909);
    freq.put("St ", 3);
    freq.put("Kol", 5);
    freq.put("Koo", 6);
    freq.put("ix", 11);
    freq.put("lmo", 3);
    freq.put("Kod", 6);
    freq.put("Kog", 3);
    freq.put("pia", 3);
    freq.put("ügi", 8);
    freq.put("bri", 13);
    freq.put("Jee", 5);
    freq.put("bre", 5);
    freq.put("Kor", 4);
    freq.put("aak", 24);
    freq.put("bra", 26);
    freq.put("dne", 3);
    freq.put("õr", 46);
    freq.put("mne", 6);
    freq.put("enä", 6);
    freq.put("m ", 357);
    freq.put("äle", 8);
    freq.put("älj", 63);
    freq.put("äli", 8);
    freq.put("äll", 32);
    freq.put("dnu", 8);
    freq.put("sn ", 3);
    freq.put(" Õn", 3);
    freq.put("aur", 25);
    freq.put("er ", 105);
    freq.put("nud", 195);
    freq.put("ält", 4);
    freq.put("Nah", 3);
    freq.put("ajo", 5);
    freq.put("aut", 20);
    freq.put("mE", 3);
    freq.put("Ste", 5);
    freq.put("Nai", 4);
    freq.put("mA", 5);
    freq.put("Sta", 4);
    freq.put("mol", 4);
    freq.put("Maa", 6);
    freq.put("ngu", 44);
    freq.put("kuh", 12);
    freq.put("ti", 648);
    freq.put("Pär", 9);
    freq.put("nkn", 4);
    freq.put("ris", 133);
    freq.put("Stu", 4);
    freq.put("nks", 11);
    freq.put("nkt", 8);
    freq.put("mP", 4);
    freq.put("mS", 3);
    freq.put("V", 235);
    freq.put("nky", 3);
    freq.put("öri", 4);
    freq.put("me", 728);
    freq.put("md", 10);
    freq.put("mg", 18);
    freq.put("mf", 9);
    freq.put("ma", 1555);
    freq.put("tiv", 10);
    freq.put("err", 13);
    freq.put("mb", 67);
    freq.put("mm", 239);
    freq.put("ml", 12);
    freq.put("mo", 89);
    freq.put("mn", 14);
    freq.put("mi", 1109);
    freq.put("mh", 8);
    freq.put("mk", 7);
    freq.put("mj", 3);
    freq.put("mu", 427);
    freq.put("mt", 5);
    freq.put("mw", 4);
    freq.put("mv", 8);
    freq.put("mp", 54);
    freq.put("ms", 67);
    freq.put("mr", 4);
    freq.put("erl", 11);
    freq.put("erm", 5);
    freq.put("ern", 10);
    freq.put("ero", 14);
    freq.put("my", 17);
    freq.put("mx", 3);
    freq.put("erk", 10);
    freq.put("Le", 14);
    freq.put("vor", 11);
    freq.put("La", 36);
    freq.put("enH", 4);
    freq.put("Lo", 24);
    freq.put("uas", 5);
    freq.put("uar", 4);
    freq.put("la ", 131);
    freq.put("täi", 60);
    freq.put("Lh", 3);
    freq.put("Li", 69);
    freq.put(" mü", 9);
    freq.put("Lu", 4);
    freq.put("enT", 3);
    freq.put("ual", 4);
    freq.put("uan", 7);
    freq.put("uaa", 3);
    freq.put("uab", 5);
    freq.put("uae", 9);
    freq.put("Ly", 4);
    freq.put("ena", 62);
    freq.put("hod", 3);
    freq.put("ib", 124);
    freq.put("hob", 4);
    freq.put("ene", 66);
    freq.put("eng", 15);
    freq.put("Kak", 4);
    freq.put("hoo", 32);
    freq.put("hol", 10);
    freq.put("hom", 88);
    freq.put("enl", 4);
    freq.put("hok", 4);
    freq.put("enn", 90);
    freq.put("hoi", 13);
    freq.put("Kas", 21);
    freq.put("how", 5);
    freq.put("hot", 14);
    freq.put("hou", 5);
    freq.put("hor", 4);
    freq.put("enu", 17);
    freq.put("hop", 7);
    freq.put("Kat", 8);
    freq.put("enx", 5);
    freq.put("aPe", 3);
    freq.put("A", 257);
    freq.put("lam", 40);
    freq.put("lan", 44);
    freq.put("pig", 5);
    freq.put("lai", 8);
    freq.put("L ", 38);
    freq.put("lak", 28);
    freq.put("lad", 16);
    freq.put("lae", 12);
    freq.put("ON ", 10);
    freq.put("lag", 11);
    freq.put("laa", 50);
    freq.put("lab", 12);
    freq.put("dei", 4);
    freq.put("ova", 8);
    freq.put("II ", 11);
    freq.put("Ö", 7);
    freq.put("lat", 50);
    freq.put("ua ", 27);
    freq.put("lav", 29);
    freq.put("ovi", 36);
    freq.put("lap", 25);
    freq.put("ou ", 13);
    freq.put("so ", 5);
    freq.put("las", 137);
    freq.put("en ", 184);
    freq.put("mä", 87);
    freq.put("All", 10);
    freq.put("jäl", 36);
    freq.put("Alk", 3);
    freq.put("fak", 5);
    freq.put("co ", 373);
    freq.put("Ale", 8);
    freq.put("bum", 7);
    freq.put("mõ", 124);
    freq.put("mö", 21);
    freq.put("opi", 18);
    freq.put("mü", 13);
    freq.put("ltl", 4);
    freq.put("mps", 17);
    freq.put("õuk", 5);
    freq.put("ofe", 3);
    freq.put("lt ", 316);
    freq.put(" Hu", 8);
    freq.put(" Hi", 9);
    freq.put("õib", 18);
    freq.put(" Ho", 38);
    freq.put("pü", 21);
    freq.put("õud", 18);
    freq.put("hu ", 15);
    freq.put(" Ha", 40);
    freq.put("õug", 3);
    freq.put(" He", 46);
    freq.put("õid", 55);
    freq.put("ima", 136);
    freq.put("rõ", 17);
    freq.put("rö", 3);
    freq.put("imb", 5);
    freq.put("ime", 193);
    freq.put("cli", 4);
    freq.put("fit", 4);
    freq.put("imi", 63);
    freq.put("imm", 6);
    freq.put("imo", 11);
    freq.put("rä", 50);
    freq.put("imp", 7);
    freq.put("ays", 3);
    freq.put("fia", 3);
    freq.put("imu", 40);
    freq.put("õmb", 10);
    freq.put("õmm", 6);
    freq.put("fii", 4);
    freq.put("Hil", 3);
    freq.put("äol", 3);
    freq.put("JA ", 14);
    freq.put(" Va", 56);
    freq.put("Pol", 9);
    freq.put("ona", 14);
    freq.put(" Ve", 17);
    freq.put("pä", 233);
    freq.put("dem", 6);
    freq.put(" Vi", 31);
    freq.put(" Vm", 4);
    freq.put("upl", 3);
    freq.put(" Vo", 5);
    freq.put("õil", 3);
    freq.put("iA", 3);
    freq.put("Kan", 4);
    freq.put("oks", 38);
    freq.put("IT ", 4);
    freq.put(" H ", 4);
    freq.put("õnu", 28);
    freq.put("im ", 23);
    freq.put("lko", 7);
    freq.put("l", 7795);
    freq.put("oda", 42);
    freq.put("fi ", 7);
    freq.put("cy ", 3);
    freq.put("güm", 3);
    freq.put("lõu", 7);
    freq.put("lka", 21);
    freq.put("õit", 36);
    freq.put("deo", 15);
    freq.put("rS", 3);
    freq.put("Poo", 4);
    freq.put("Wor", 3);
    freq.put("oku", 5);
    freq.put("rE", 3);
    freq.put(" tü", 33);
    freq.put("eum", 4);
    freq.put("mbo", 4);
    freq.put("nt ", 23);
    freq.put("rH", 5);
    freq.put("yol", 6);
    freq.put(" Hä", 5);
    freq.put("rt", 125);
    freq.put("ru", 155);
    freq.put("goo", 9);
    freq.put("gon", 3);
    freq.put("goi", 3);
    freq.put("imä", 10);
    freq.put("rr", 102);
    freq.put("rs", 87);
    freq.put("god", 3);
    freq.put("nim", 82);
    freq.put("rx", 3);
    freq.put("ry", 27);
    freq.put("rz", 7);
    freq.put("rd", 152);
    freq.put("re", 415);
    freq.put("rf", 9);
    freq.put("rg", 110);
    freq.put("nic", 4);
    freq.put("ra", 685);
    freq.put("rb", 23);
    freq.put("rc", 8);
    freq.put("rl", 41);
    freq.put("got", 7);
    freq.put("rn", 46);
    freq.put("is ", 645);
    freq.put("rh", 8);
    freq.put("ri", 667);
    freq.put("rj", 99);
    freq.put("rk", 110);
    freq.put("log", 10);
    freq.put("nia", 9);
    freq.put(" Vä", 15);
    freq.put("nts", 32);
    freq.put("ntr", 7);
    freq.put("ntu", 4);
    freq.put("Roo", 6);
    freq.put("nti", 23);
    freq.put("nth", 3);
    freq.put("tsl", 4);
    freq.put(" Võ", 46);
    freq.put("nid", 25);
    freq.put("W", 57);
    freq.put("nta", 24);
    freq.put("Ega", 3);
    freq.put("nie", 4);
    freq.put("nte", 17);
    freq.put("onl", 3);
    freq.put("xuu", 5);
    freq.put(" ew", 3);
    freq.put("ate", 83);
    freq.put("iak", 6);
    freq.put("ata", 197);
    freq.put("iss", 81);
    freq.put("isr", 4);
    freq.put("Vih", 3);
    freq.put("isp", 6);
    freq.put("isv", 8);
    freq.put("isu", 39);
    freq.put("ist", 360);
    freq.put("isk", 47);
    freq.put("Vis", 3);
    freq.put("isi", 92);
    freq.put("ish", 10);
    freq.put("iso", 5);
    freq.put("isn", 4);
    freq.put("ism", 10);
    freq.put("isl", 5);
    freq.put("aj ", 3);
    freq.put("isb", 3);
    freq.put("isa", 71);
    freq.put("be ", 24);
    freq.put("ise", 215);
    freq.put("sm ", 4);
    freq.put("nhe", 4);
    freq.put(" l ", 8);
    freq.put("uks", 80);
    freq.put("nho", 3);
    freq.put("nõu", 10);
    freq.put("on ", 520);
    freq.put("pum", 3);
    freq.put("äv", 5);
    freq.put("nõm", 4);
    freq.put("öse", 10);
    freq.put("osa", 22);
    freq.put("kib", 4);
    freq.put("nõe", 3);
    freq.put("nip", 15);
    freq.put("jja", 3);
    freq.put("tem", 17);
    freq.put("Kla", 6);
    freq.put("tor", 43);
    freq.put("kig", 3);
    freq.put("top", 11);
    freq.put("ltz", 5);
    freq.put("pis", 15);
    freq.put("tot", 4);
    freq.put("adr", 11);
    freq.put("tok", 4);
    freq.put("toh", 9);
    freq.put("toi", 27);
    freq.put("ton", 11);
    freq.put("too", 34);
    freq.put("tol", 10);
    freq.put("Se ", 3);
    freq.put("dik", 14);
    freq.put("toa", 13);
    freq.put("kt ", 11);
    freq.put("tog", 3);
    freq.put("tod", 5);
    freq.put("toe", 4);
    freq.put(" le", 87);
    freq.put("B", 128);
    freq.put("nh ", 5);
    freq.put(" la", 184);
    freq.put("Roc", 3);
    freq.put(" lo", 101);
    freq.put(" lm", 4);
    freq.put(" ll", 9);
    freq.put(" lk", 4);
    freq.put(" li", 163);
    freq.put("ös ", 3);
    freq.put("laj", 4);
    freq.put(" lu", 47);
    freq.put(" lt", 4);
    freq.put(" Öö", 3);
    freq.put("fil", 24);
    freq.put("Fuj", 3);
    freq.put(" ly", 3);
    freq.put("än ", 5);
    freq.put("xi ", 6);
    freq.put("Ots", 4);
    freq.put("Ses", 5);
    freq.put("Sep", 4);
    freq.put("ca ", 4);
    freq.put("ktu", 4);
    freq.put("Läh", 7);
    freq.put("ktr", 6);
    freq.put("kts", 5);
    freq.put("aal", 70);
    freq.put("See", 15);
    freq.put("Sed", 4);
    freq.put("uka", 24);
    freq.put("Lät", 3);
    freq.put(" ep", 3);
    freq.put("kte", 5);
    freq.put("to ", 21);
    freq.put("Sel", 19);
    freq.put("raf", 3);
    freq.put("rag", 9);
    freq.put("rad", 29);
    freq.put("äes", 10);
    freq.put("rab", 5);
    freq.put("Iga", 7);
    freq.put("uds", 7);
    freq.put("ran", 47);
    freq.put("ral", 37);
    freq.put("ram", 22);
    freq.put("ty ", 4);
    freq.put("rak", 29);
    freq.put("rah", 37);
    freq.put("õp", 109);
    freq.put("rav", 7);
    freq.put("Q ", 8);
    freq.put("rat", 52);
    freq.put("rau", 5);
    freq.put("rar", 3);
    freq.put("äev", 146);
    freq.put("rap", 4);
    freq.put("õs", 13);
    freq.put("fän", 9);
    freq.put("ase", 108);
    freq.put("lbo", 3);
    freq.put("rsi", 7);
    freq.put("õm", 27);
    freq.put("lmk", 3);
    freq.put("alõ", 5);
    freq.put("õbr", 17);
    freq.put("rte", 10);
    freq.put("õl", 39);
    freq.put("ash", 11);
    freq.put("do ", 10);
    freq.put("rsk", 14);
    freq.put("ack", 8);
    freq.put("ogu", 26);
    freq.put("Sor", 3);
    freq.put("tev", 5);
    freq.put("ype", 7);
    freq.put("õi", 376);
    freq.put("sSa", 4);
    freq.put("hun", 5);
    freq.put("tyl", 4);
    freq.put("AH ", 4);
    freq.put(" lä", 167);
    freq.put("mba", 16);
    freq.put("◄", 4);
    freq.put("ra ", 195);
    freq.put("uom", 4);
    freq.put("Laa", 3);
    freq.put("myo", 4);
    freq.put("rsa", 6);
    freq.put(" fi", 30);
    freq.put(" lõ", 76);
    freq.put("sud", 12);
    freq.put("Mui", 3);
    freq.put(" lü", 10);
    freq.put("õg", 6);
    freq.put("uuk", 17);
    freq.put("abe", 14);
    freq.put("dok", 4);
    freq.put("don", 7);
    freq.put("äme", 3);
    freq.put("dol", 6);
    freq.put("duu", 4);
    freq.put("nei", 45);
    freq.put("m", 5123);
    freq.put("ämm", 5);
    freq.put("stm", 13);
    freq.put("ük", 60);
    freq.put("Kp", 3);
    freq.put("abi", 15);
    freq.put("dor", 5);
    freq.put("dos", 3);
    freq.put("õb", 32);
    freq.put("dow", 4);
    freq.put("mäk", 3);
    freq.put("sul", 64);
    freq.put("män", 51);
    freq.put("udd", 7);
    freq.put("mäl", 4);
    freq.put("api", 17);
    freq.put(" Wo", 5);
    freq.put("SE ", 3);
    freq.put("d ", 1783);
    freq.put(" Wi", 5);
    freq.put("oge", 6);
    freq.put("kuv", 12);
    freq.put("mõt", 44);
    freq.put("mär", 13);
    freq.put("rta", 5);
    freq.put("par", 102);
    freq.put("ock", 9);
    freq.put("näh", 12);
    freq.put("dip", 9);
    freq.put("em ", 104);
    freq.put("kun", 59);
    freq.put("oga", 7);
    freq.put("sto", 13);
    freq.put(" ► ", 4);
    freq.put("õn", 115);
    freq.put("yea", 4);
    freq.put("hro", 4);
    freq.put("abs", 5);
    freq.put("hri", 7);
    freq.put("ba ", 95);
    freq.put("ngr", 4);
    freq.put("Bir", 6);
    freq.put("sur", 27);
    freq.put("dn", 16);
    freq.put("do", 54);
    freq.put("dl", 35);
    freq.put("dm", 17);
    freq.put("dj", 12);
    freq.put("dk", 19);
    freq.put("dh", 7);
    freq.put("di", 360);
    freq.put("räi", 4);
    freq.put("dd", 19);
    freq.put("de", 383);
    freq.put("db", 6);
    freq.put("dc", 4);
    freq.put("da", 948);
    freq.put("kug", 9);
    freq.put("dz", 3);
    freq.put("vöi", 5);
    freq.put("dy", 12);
    freq.put("dv", 6);
    freq.put("X", 54);
    freq.put("dt", 6);
    freq.put("du", 276);
    freq.put("dr", 69);
    freq.put("ds", 57);
    freq.put("dp", 3);
    freq.put(" el", 80);
    freq.put("eme", 45);
    freq.put("Juu", 5);
    freq.put("bat", 9);
    freq.put("dM", 5);
    freq.put("ema", 219);
    freq.put("bas", 12);
    freq.put("emb", 7);
    freq.put("emm", 19);
    freq.put("oog", 18);
    freq.put("emo", 9);
    freq.put("emi", 53);
    freq.put("◄ ", 4);
    freq.put("püh", 7);
    freq.put("emu", 11);
    freq.put("bad", 15);
    freq.put("püs", 6);
    freq.put("vää", 15);
    freq.put("ems", 5);
    freq.put("Rii", 7);
    freq.put("ban", 23);
    freq.put("dT", 3);
    freq.put("bam", 9);
    freq.put("dR", 3);
    freq.put(" em", 30);
    freq.put("uek", 4);
    freq.put("om ", 8);
    freq.put("w ", 39);
    freq.put("nut", 37);
    freq.put("nuu", 12);
    freq.put("nur", 11);
    freq.put("nus", 58);
    freq.put("nup", 7);
    freq.put("nun", 9);
    freq.put("nul", 41);
    freq.put("rün", 3);
    freq.put("nuk", 10);
    freq.put(" I ", 12);
    freq.put("nug", 13);
    freq.put("rüg", 5);
    freq.put(" en", 149);
    freq.put("aan", 89);
    freq.put("Pea", 12);
    freq.put("nua", 4);
    freq.put(" ye", 4);
    freq.put("mut", 12);
    freq.put("stk", 5);
    freq.put("õst", 3);
    freq.put("il ", 85);
    freq.put("xD ", 3);
    freq.put("Rub", 3);
    freq.put("irs", 4);
    freq.put("irt", 3);
    freq.put("iru", 11);
    freq.put("un ", 37);
    freq.put("vä ", 5);
    freq.put("irj", 55);
    freq.put("irk", 7);
    freq.put("irl", 3);
    freq.put("irm", 8);
    freq.put("irn", 3);
    freq.put("VL ", 5);
    freq.put("Kül", 5);
    freq.put("ira", 20);
    freq.put("mun", 8);
    freq.put("ird", 4);
    freq.put("ire", 37);
    freq.put("muk", 4);
    freq.put("irg", 6);
    freq.put("elj", 7);
    freq.put("C", 79);
    freq.put("wd", 3);
    freq.put("omg", 13);
    freq.put("wb", 3);
    freq.put("wa", 32);
    freq.put("XD ", 3);
    freq.put("wo", 12);
    freq.put("wn", 8);
    freq.put("omi", 19);
    freq.put(" Is", 10);
    freq.put(" It", 3);
    freq.put(" Iv", 3);
    freq.put("wh", 15);
    freq.put("ww", 35);
    freq.put(" Ik", 4);
    freq.put(" Il", 11);
    freq.put(" Im", 6);
    freq.put(" In", 19);
    freq.put("wp", 3);
    freq.put("dö", 4);
    freq.put("igr", 6);
    freq.put("aSi", 5);
    freq.put("nu ", 78);
    freq.put(" Ig", 7);
    freq.put("ilg", 5);
    freq.put("väs", 12);
    freq.put("vär", 23);
    freq.put("unt", 6);
    freq.put("ell", 243);
    freq.put("akv", 3);
    freq.put("ila", 24);
    freq.put("eae", 5);
    freq.put("ilo", 5);
    freq.put("ill", 76);
    freq.put("ilm", 100);
    freq.put("ilj", 29);
    freq.put("ilk", 6);
    freq.put("ili", 73);
    freq.put("una", 57);
    freq.put("ilt", 33);
    freq.put("ilu", 52);
    freq.put("und", 78);
    freq.put("ils", 5);
    freq.put("väg", 50);
    freq.put("ung", 7);
    freq.put("ir ", 7);
    freq.put("väh", 28);
    freq.put("õla", 8);
    freq.put("väl", 71);
    freq.put("coo", 8);
    freq.put("ily", 3);
    freq.put(" md", 5);
    freq.put(" me", 186);
    freq.put(" ma", 561);
    freq.put(" mb", 3);
    freq.put("ane", 108);
    freq.put(" mm", 16);
    freq.put(" mo", 29);
    freq.put("iõ", 6);
    freq.put(" mi", 643);
    freq.put(" mu", 316);
    freq.put("Nar", 4);
    freq.put(" ms", 12);
    freq.put("ele", 175);
    freq.put(" my", 6);
    freq.put("ana", 49);
    freq.put("che", 6);
    freq.put("fre", 5);
    freq.put("lti", 16);
    freq.put("fri", 7);
    freq.put("C ", 14);
    freq.put("Müü", 3);
    freq.put("Nas", 4);
    freq.put("aai", 21);
    freq.put("uve", 15);
    freq.put("pro", 38);
    freq.put("ab ", 240);
    freq.put("elk", 11);
    freq.put(" m ", 24);
    freq.put("sag", 11);
    freq.put("ää", 153);
    freq.put("xxx", 4);
    freq.put("ani", 66);
    freq.put("noh", 15);
    freq.put("öpä", 5);
    freq.put("els", 11);
    freq.put("ank", 8);
    freq.put("TV ", 3);
    freq.put("asj", 39);
    freq.put("moe", 3);
    freq.put("pru", 4);
    freq.put("Ch", 12);
    freq.put("Vä", 15);
    freq.put("Cl", 4);
    freq.put("Cc", 3);
    freq.put("elv", 11);
    freq.put("Ca", 9);
    freq.put("äpp", 9);
    freq.put("ärt", 4);
    freq.put("Ce", 3);
    freq.put("n", 6717);
    freq.put("äri", 43);
    freq.put("Tür", 3);
    freq.put("Cy", 3);
    freq.put("ärj", 10);
    freq.put("aii", 4);
    freq.put("Võ", 46);
    freq.put("aik", 16);
    freq.put("gne", 4);
    freq.put("ära", 166);
    freq.put("sle", 7);
    freq.put("epä", 10);
    freq.put("üsi", 45);
    freq.put("äre", 7);
    freq.put("ärd", 3);
    freq.put("Cu", 4);
    freq.put(" mä", 60);
    freq.put("Oo", 11);
    freq.put("iz", 7);
    freq.put("KE ", 8);
    freq.put("rtu", 28);
    freq.put("adn", 3);
    freq.put("iq", 7);
    freq.put("ip", 96);
    freq.put("is", 1631);
    freq.put("ir", 212);
    freq.put("iu", 44);
    freq.put("it", 762);
    freq.put("ä ", 36);
    freq.put("iv", 115);
    freq.put("ii", 1149);
    freq.put("ih", 118);
    freq.put("ik", 847);
    freq.put("ij", 35);
    freq.put("im", 502);
    freq.put("il", 661);
    freq.put("io", 81);
    freq.put("in", 1582);
    freq.put("ia", 183);
    freq.put("opp", 7);
    freq.put("ic", 61);
    freq.put("ki ", 106);
    freq.put("ie", 133);
    freq.put("id", 902);
    freq.put("ig", 361);
    freq.put("if", 29);
    freq.put("V ", 16);
    freq.put("änd", 4);
    freq.put("äng", 57);
    freq.put("äna", 124);
    freq.put("ado", 8);
    freq.put("iP", 4);
    freq.put("iS", 12);
    freq.put("änn", 16);
    freq.put("änk", 3);
    freq.put("any", 4);
    freq.put("änu", 10);
    freq.put("mdu", 4);
    freq.put("iK", 4);
    freq.put("ar ", 46);
    freq.put("iM", 5);
    freq.put("iL", 4);
    freq.put("Ait", 6);
    freq.put("Ikk", 4);
    freq.put("iC", 3);
    freq.put("sat", 35);
    freq.put("bid", 7);
    freq.put("ep ", 7);
    freq.put("th ", 5);
    freq.put("än", 222);
    freq.put("äo", 10);
    freq.put("äl", 132);
    freq.put("äm", 13);
    freq.put("nin", 49);
    freq.put("äk", 66);
    freq.put("öps", 5);
    freq.put("äi", 247);
    freq.put("kis", 24);
    freq.put("kir", 57);
    freq.put("äd", 45);
    freq.put("äe", 183);
    freq.put("äb", 51);
    freq.put("kiv", 4);
    freq.put("kiu", 3);
    freq.put("kit", 24);
    freq.put("kik", 4);
    freq.put("tz ", 6);
    freq.put("kii", 39);
    freq.put("kih", 6);
    freq.put("mä ", 3);
    freq.put("kin", 62);
    freq.put("kim", 12);
    freq.put("kil", 23);
    freq.put("Y", 40);
    freq.put("i ", 2882);
    freq.put("ät", 61);
    freq.put("Sad", 3);
    freq.put("üa ", 16);
    freq.put("äs", 49);
    freq.put("äp", 35);
    freq.put("kid", 28);
    freq.put("Va", 60);
    freq.put("Ve", 21);
    freq.put("sme", 10);
    freq.put("Vi", 35);
    freq.put("ept", 4);
    freq.put("Di", 11);
    freq.put("epr", 3);
    freq.put("Vm", 6);
    freq.put("epp", 15);
    freq.put("Vo", 7);
    freq.put("lma", 63);
    freq.put("ll ", 141);
    freq.put("asi", 163);
    freq.put("thi", 9);
    freq.put("epi", 15);
    freq.put("abr", 7);
    freq.put("the", 19);
    freq.put("epe", 13);
    freq.put("riu", 4);
    freq.put("tha", 8);
    freq.put("epa", 12);
    freq.put("nk ", 5);
    freq.put("dse", 27);
    freq.put("Koh", 7);
    freq.put(" Jõ", 5);
    freq.put("mie", 3);
    freq.put("rn ", 4);
    freq.put("läh", 80);
    freq.put("ED ", 7);
    freq.put("nci", 3);
    freq.put("biv", 7);
    freq.put(" lö", 9);
    freq.put("op ", 7);
    freq.put("kõr", 16);
    freq.put(" Jä", 13);
    freq.put("bit", 13);
    freq.put("Nii", 26);
    freq.put("hah", 104);
    freq.put("hai", 35);
    freq.put("üst", 10);
    freq.put("hak", 113);
    freq.put("hal", 40);
    freq.put("ham", 9);
    freq.put("han", 40);
    freq.put("elm", 14);
    freq.put("haa", 11);
    freq.put("hab", 10);
    freq.put("ela", 43);
    freq.put("had", 16);
    freq.put("elg", 25);
    freq.put("eld", 81);
    freq.put("hag", 4);
    freq.put("mõe", 14);
    freq.put("Tor", 5);
    freq.put("ely", 3);
    freq.put("Ly ", 3);
    freq.put("rnu", 13);
    freq.put("uug", 3);
    freq.put("üsa", 3);
    freq.put("hap", 16);
    freq.put("eur", 21);
    freq.put("har", 21);
    freq.put("has", 18);
    freq.put("hat", 35);
    freq.put("väi", 30);
    freq.put("Hä", 5);
    freq.put("elu", 46);
    freq.put("Tri", 11);
    freq.put("rni", 6);
    freq.put("rno", 3);
    freq.put("D", 617);
    freq.put("ops", 9);
    freq.put("Tra", 7);
    freq.put("rna", 10);
    freq.put("rne", 7);
    freq.put("köi", 3);
    freq.put("cho", 7);
    freq.put("plä", 3);
    freq.put("ai ", 38);
    freq.put("aud", 15);
    freq.put("õbe", 4);
    freq.put("ige", 94);
    freq.put("bro", 3);
    freq.put("leo", 4);
    freq.put("oni", 50);
    freq.put("Lol", 3);
    freq.put("iSa", 6);
    freq.put("utt", 40);
    freq.put("ha ", 141);
    freq.put("´i ", 3);
    freq.put("el ", 247);
    freq.put("Lõ", 9);
    freq.put("Mu ", 7);
    freq.put("ywo", 3);
    freq.put("jes", 15);
    freq.put("rka", 29);
    freq.put("ola", 21);
    freq.put("www", 27);
    freq.put(" Jy", 3);
    freq.put("ole", 388);
    freq.put("olf", 5);
    freq.put("olg", 5);
    freq.put(" Ju", 26);
    freq.put("oli", 265);
    freq.put(" X ", 8);
    freq.put("oll", 106);
    freq.put("olm", 26);
    freq.put("oln", 29);
    freq.put("pär", 64);
    freq.put(" Jo", 11);
    freq.put("olt", 14);
    freq.put("olu", 20);
    freq.put("olv", 4);
    freq.put(" Je", 19);
    freq.put("an ", 254);
    freq.put(" Ja", 51);
    freq.put("Ühi", 3);
    freq.put("wha", 9);
    freq.put("ick", 7);
    freq.put("rg ", 13);
    freq.put("ici", 13);
    freq.put("ich", 5);
    freq.put("ump", 7);
    freq.put("icm", 4);
    freq.put("eel", 169);
    freq.put("Lei", 3);
    freq.put("ica", 8);
    freq.put("Kä", 10);
    freq.put("päm", 3);
    freq.put("ice", 8);
    freq.put("Hu", 13);
    freq.put("ume", 22);
    freq.put("aww", 7);
    freq.put("Hi", 10);
    freq.put("uma", 58);
    freq.put("Ho", 39);
    freq.put("umb", 15);
    freq.put("fol", 5);
    freq.put("fon", 13);
    freq.put("Ha", 45);
    freq.put("umi", 65);
    freq.put("dia", 13);
    freq.put("He", 53);
    freq.put("ol ", 56);
    freq.put("plu", 5);
    freq.put("sa ", 216);
    freq.put("pls", 9);
    freq.put("Ä", 8);
    freq.put("köö", 4);
    freq.put("ple", 12);
    freq.put("ww ", 4);
    freq.put("pla", 30);
    freq.put("eed", 87);
    freq.put("älg", 5);
    freq.put("ööp", 5);
    freq.put(" J ", 7);
    freq.put("pli", 8);
    freq.put("aks", 285);
    freq.put("obl", 9);
    freq.put("mõl", 4);
    freq.put("obi", 18);
    freq.put("sli", 6);
    freq.put("ic ", 7);
    freq.put("obb", 4);
    freq.put("o", 5533);
    freq.put("Arm", 3);
    freq.put("fo ", 3);
    freq.put("um ", 20);
    freq.put("jõ", 34);
    freq.put("meg", 10);
    freq.put("H ", 19);
    freq.put("obu", 7);
    freq.put("obr", 3);
    freq.put("lm ", 40);
    freq.put("mbe", 13);
    freq.put("okt", 3);
    freq.put("xu", 8);
    freq.put("ahc", 3);
    freq.put("ppa", 16);
    freq.put("sob", 9);
    freq.put("soe", 8);
    freq.put("chu", 4);
    freq.put("dMf", 3);
    freq.put("ahe", 95);
    freq.put("ahj", 12);
    freq.put("ahk", 7);
    freq.put("üü", 193);
    freq.put("ahi", 8);
    freq.put("som", 7);
    freq.put("sol", 13);
    freq.put("soo", 31);
    freq.put("son", 15);
    freq.put("Cud", 3);
    freq.put("Fer", 3);
    freq.put("Fes", 4);
    freq.put("ppu", 8);
    freq.put("ahu", 18);
    freq.put("old", 9);
    freq.put("awe", 4);
    freq.put("mbr", 6);
    freq.put("am ", 68);
    freq.put("giv", 7);
    freq.put("art", 63);
    freq.put("git", 34);
    freq.put("gis", 23);
    freq.put("gip", 4);
    freq.put("rik", 38);
    freq.put("üü ", 5);
    freq.put("äst", 18);
    freq.put("ugh", 4);
    freq.put("nä", 141);
    freq.put("äss", 6);
    freq.put("gig", 5);
    freq.put("gid", 26);
    freq.put("nü", 105);
    freq.put("gib", 6);
    freq.put("gia", 7);
    freq.put("äsi", 12);
    freq.put("gin", 32);
    freq.put("gim", 16);
    freq.put("Kü", 9);
    freq.put("gik", 16);
    freq.put("nõ", 19);
    freq.put("mõi", 10);
    freq.put("aru", 52);
    freq.put("cke", 3);
    freq.put("ah ", 83);
    freq.put("pp ", 35);
    freq.put("TE ", 5);
    freq.put("mb ", 6);
    freq.put(" eu", 18);
    freq.put("Ees", 33);
    freq.put("😡?", 4);
    freq.put(" nü", 101);
    freq.put("nke", 6);
    freq.put("Z", 46);
    freq.put(" nõ", 16);
    freq.put("dka", 3);
    freq.put("Mar", 34);
    freq.put("mat", 89);
    freq.put("aja", 188);
    freq.put("iqu", 3);
    freq.put("üür", 3);
    freq.put("üüp", 4);
    freq.put("oik", 7);
    freq.put("AA ", 7);
    freq.put("üüt", 3);
    freq.put("llo", 15);
    freq.put("azz", 3);
    freq.put("rri", 17);
    freq.put("üüm", 5);
    freq.put("gi ", 344);
    freq.put("üüa", 18);
    freq.put("tš", 3);
    freq.put("äs ", 4);
    freq.put("üüd", 125);
    freq.put("nH", 5);
    freq.put("Sir", 6);
    freq.put("nJ", 3);
    freq.put("nK", 4);
    freq.put("ür", 28);
    freq.put("nM", 10);
    freq.put("nN", 4);
    freq.put("Sit", 10);
    freq.put(" n ", 5);
    freq.put("nB", 3);
    freq.put("vi ", 29);
    freq.put("nna", 221);
    freq.put("uri", 32);
    freq.put("üg", 10);
    freq.put("üd", 144);
    freq.put("Lin", 12);
    freq.put("Sig", 3);
    freq.put("D ", 279);
    freq.put("kho", 6);
    freq.put("nP", 4);
    freq.put("kha", 6);
    freq.put("Sii", 16);
    freq.put("üm", 23);
    freq.put("nT", 7);
    freq.put("nU", 3);
    freq.put("Sim", 3);
    freq.put("Sil", 3);
    freq.put("nh", 16);
    freq.put("ni", 722);
    freq.put("nj", 9);
    freq.put("nk", 70);
    freq.put("nl", 33);
    freq.put("nm", 9);
    freq.put("nn", 545);
    freq.put("no", 168);
    freq.put("tit", 32);
    freq.put("na", 876);
    freq.put("nb", 8);
    freq.put("nc", 17);
    freq.put("nd", 524);
    freq.put("ne", 775);
    freq.put("nf", 13);
    freq.put("ng", 343);
    freq.put("nx", 9);
    freq.put("ny", 18);
    freq.put("nz", 3);
    freq.put("tio", 10);
    freq.put("tih", 5);
    freq.put("tii", 28);
    freq.put("uff", 3);
    freq.put("tik", 35);
    freq.put("np", 8);
    freq.put("nr", 14);
    freq.put("ns", 57);
    freq.put("nt", 144);
    freq.put("nu", 502);
    freq.put("nv", 23);
    freq.put("õne", 24);
    freq.put(" ni", 314);
    freq.put(" nh", 6);
    freq.put(" nk", 5);
    freq.put("kve", 5);
    freq.put("E", 274);
    freq.put("urr", 4);
    freq.put(" no", 113);
    freq.put(" nn", 4);
    freq.put(" na", 169);
    freq.put("fü", 4);
    freq.put("abu", 5);
    freq.put(" ne", 115);
    freq.put(" nd", 4);
    freq.put("nn ", 27);
    freq.put(" ny", 5);
    freq.put("mmu", 16);
    freq.put("leh", 19);
    freq.put("ü ", 5);
    freq.put("Söö", 3);
    freq.put("rbu", 4);
    freq.put(" nr", 3);
    freq.put(" nu", 56);
    freq.put(" nt", 4);
    freq.put(" nv", 8);
    freq.put("nxu", 7);
    freq.put(" er", 33);
    freq.put(" nM", 4);
    freq.put("for", 6);
    freq.put("üüü", 8);
    freq.put("n ", 1436);
    freq.put("lot", 5);
    freq.put("mme", 82);
    freq.put("ceb", 12);
    freq.put("Öö", 3);
    freq.put("fä", 10);
    freq.put("ti ", 301);
    freq.put("nku", 5);
    freq.put("roh", 26);
    freq.put("lr ", 4);
    freq.put("now", 5);
    freq.put("rol", 25);
    freq.put("rom", 10);
    freq.put("ron", 22);
    freq.put("roo", 39);
    freq.put("lls", 4);
    freq.put("rob", 14);
    freq.put("roc", 7);
    freq.put("rod", 4);
    freq.put("ost", 72);
    freq.put("rr ", 5);
    freq.put("Tsa", 3);
    freq.put("osi", 18);
    freq.put("osk", 19);
    freq.put("osm", 3);
    freq.put("per", 36);
    freq.put("oso", 7);
    freq.put("lll", 48);
    freq.put("rop", 4);
    freq.put("lla", 143);
    freq.put("Tsu", 3);
    freq.put("rot", 13);
    freq.put("rou", 7);
    freq.put("rov", 7);
    freq.put("row", 3);
    freq.put("jh ", 3);
    freq.put("vet", 11);
    freq.put("gu ", 120);
    freq.put("ver", 49);
    freq.put("ögi", 6);
    freq.put("vep", 4);
    freq.put("Dan", 3);
    freq.put(" üü", 4);
    freq.put("di ", 120);
    freq.put("AS ", 6);
    freq.put("ved", 8);
    freq.put("vee", 86);
    freq.put("Ta ", 3);
    freq.put("Dar", 5);
    freq.put("vea", 8);
    freq.put("ven", 36);
    freq.put("vel", 11);
    freq.put("vem", 13);
    freq.put("Kai", 5);
    freq.put("vek", 11);
    freq.put("oid", 15);
    freq.put("vei", 22);
    freq.put("Mä", 10);
    freq.put("sza", 4);
    freq.put("ey ", 9);
    freq.put("ro ", 13);
    freq.put("teg", 92);
    freq.put("erv", 30);
    freq.put("Mõ", 11);
    freq.put("umm", 20);
    freq.put("äl ", 4);
    freq.put("Joo", 6);
    freq.put("Par", 15);
    freq.put("Mü", 4);
    freq.put("lsa", 5);
    freq.put("umo", 4);
    freq.put("äks", 29);
    freq.put("dil", 15);
    freq.put("gub", 6);
    freq.put("gua", 15);
    freq.put("foo", 4);
    freq.put("mma", 21);
    freq.put("dii", 7);
    freq.put("gue", 3);
    freq.put("gud", 8);
    freq.put("did", 25);
    freq.put("die", 3);
    freq.put("ers", 28);
    freq.put("sCa", 5);
    freq.put("gun", 13);
    freq.put("gum", 4);
    freq.put("gul", 11);
    freq.put("gus", 54);
    freq.put("p", 2825);
    freq.put("ge ", 124);
    freq.put("guv", 5);
    freq.put("ve ", 38);
    freq.put("gut", 9);
    freq.put("Tal", 25);
    freq.put("Tam", 4);
    freq.put("Tan", 7);
    freq.put("Tah", 11);
    freq.put("der", 14);
    freq.put("dir", 5);
    freq.put("dis", 46);
    freq.put("hte", 27);
    freq.put("des", 52);
    freq.put("M ", 38);
    freq.put("hta", 22);
    freq.put(" Yo", 6);
    freq.put(" Ya", 5);
    freq.put("htm", 4);
    freq.put("htl", 7);
    freq.put("yd ", 5);
    freq.put("ery", 3);
    freq.put("htu", 84);
    freq.put("Gre", 9);
    freq.put("hts", 46);
    freq.put("dev", 8);
    freq.put("sni", 9);
    freq.put("luj", 4);
    freq.put("Rea", 3);
    freq.put("IN ", 8);
    freq.put("Red", 5);
    freq.put("uls", 9);
    freq.put("kti", 17);
    freq.put("erd", 15);
    freq.put(" üt", 37);
    freq.put(" ür", 13);
    freq.put("smä", 3);
    freq.put("ere", 35);
    freq.put("õdu", 7);
    freq.put("erf", 5);
    freq.put("ek ", 9);
    freq.put("ög", 7);
    freq.put("oes", 11);
    freq.put("erg", 19);
    freq.put("AM ", 6);
    freq.put("bo ", 4);
    freq.put("del", 45);
    freq.put(" üm", 3);
    freq.put(" ül", 100);
    freq.put(" ük", 40);
    freq.put("rva", 66);
    freq.put("era", 50);
    freq.put("Me", 50);
    freq.put("Md", 3);
    freq.put("Mf", 4);
    freq.put("Ma", 142);
    freq.put("Mc", 3);
    freq.put("ht ", 53);
    freq.put("Mm", 5);
    freq.put("Mo", 24);
    freq.put("v", 2551);
    freq.put("Mi", 105);
    freq.put("Aga", 32);
    freq.put("Mu", 46);
    freq.put("prg", 4);
    freq.put("Kki", 3);
    freq.put("lõb", 7);
    freq.put("pm ", 3);
    freq.put("O", 222);
    freq.put("Mr", 7);
    freq.put("rue", 6);
    freq.put("My", 3);
    freq.put("deb", 4);
    freq.put("or ", 17);
    freq.put("eko", 22);
    freq.put("boy", 4);
    freq.put("ekl", 6);
    freq.put("ekk", 14);
    freq.put("kss", 6);
    freq.put("eki", 18);
    freq.put("Mil", 9);
    freq.put("erh", 3);
    freq.put("eke", 15);
    freq.put("bos", 5);
    freq.put("bot", 3);
    freq.put("eka", 31);
    freq.put("eri", 141);
    freq.put("ngl", 7);
    freq.put("hää", 12);
    freq.put("bol", 5);
    freq.put("boo", 12);
    freq.put("cha", 8);
    freq.put("eku", 19);
    freq.put("ekt", 19);
    freq.put("eks", 229);
    freq.put("jat", 22);
    freq.put("fbs", 4);
    freq.put("ipa", 19);
    freq.put("Lõu", 3);
    freq.put(" oh", 20);
    freq.put("ipe", 7);
    freq.put("ott", 21);
    freq.put("jar", 7);
    freq.put("ipi", 9);
    freq.put("ipo", 9);
    freq.put("ipl", 5);
    freq.put("ngi", 148);
    freq.put("ips", 7);
    freq.put("ipp", 8);
    freq.put(" iv", 3);
    freq.put("lem", 105);
    freq.put("eRo", 4);
    freq.put("spä", 11);
    freq.put("MM ", 4);
    freq.put(" ih", 6);
    freq.put("ayo", 3);
    freq.put(" Ka", 87);
    freq.put("kyl", 7);
    freq.put("lms", 10);
    freq.put(" Ke", 49);
    freq.put("ib ", 85);
    freq.put(" Kk", 5);
    freq.put("msu", 3);
    freq.put(" Ki", 30);
    freq.put(" Kn", 3);
    freq.put(" Ko", 42);
    freq.put(" Kl", 9);
    freq.put(" Kr", 24);
    freq.put("msn", 11);
    freq.put(" ik", 105);
    freq.put("ult", 77);
    freq.put("rve", 35);
    freq.put(" Ku", 64);
    freq.put("ksa", 38);
    freq.put("ul ", 196);
    freq.put("ruu", 10);
    freq.put("aih", 3);
    freq.put("ree", 49);
    freq.put("gav", 30);
    freq.put(" im", 21);
    freq.put("ood", 94);
    freq.put("ip ", 4);
    freq.put("ooa", 7);
    freq.put("jah", 45);
    freq.put("Bel", 3);
    freq.put("F", 114);
    freq.put("oom", 36);
    freq.put("ool", 171);
    freq.put("ooo", 63);
    freq.put("asa", 31);
    freq.put("aav", 18);
    freq.put("Eve", 5);
    freq.put("ook", 55);
    freq.put("Bee", 3);
    freq.put("ma ", 784);
    freq.put("oot", 42);
    freq.put("fb ", 6);
    freq.put("oop", 14);
    freq.put("oos", 54);
    freq.put("oor", 27);
    freq.put("Ber", 3);
    freq.put("Lik", 3);
    freq.put("kso", 4);
    freq.put("Bet", 3);
    freq.put("Rom", 4);
    freq.put("ibi", 5);
    freq.put(" K ", 12);
    freq.put("ksn", 3);
    freq.put("sü", 61);
    freq.put("cas", 6);
    freq.put("iba", 5);
    freq.put("äda", 39);
    freq.put("ibe", 11);
    freq.put("sõ", 73);
    freq.put("ulu", 33);
    freq.put("ulk", 5);
    freq.put("uli", 77);
    freq.put("uln", 6);
    freq.put("ulo", 3);
    freq.put("ull", 112);
    freq.put("ulm", 10);
    freq.put("fla", 3);
    freq.put("arh", 3);
    freq.put("jaa", 32);
    freq.put("ibu", 7);
    freq.put("uld", 14);
    freq.put("sä", 12);
    freq.put(" on", 486);
    freq.put(" oo", 47);
    freq.put(" ol", 459);
    freq.put(" om", 112);
    freq.put(" ok", 25);
    freq.put("ipä", 24);
    freq.put(" oi", 11);
    freq.put(" of", 3);
    freq.put(" od", 4);
    freq.put(" oe", 6);
    freq.put(" ob", 6);
    freq.put("Mid", 14);
    freq.put("Ost", 4);
    freq.put("spi", 9);
    freq.put("spl", 4);
    freq.put("spo", 8);
    freq.put(" ov", 3);
    freq.put("spa", 10);
    freq.put(" ot", 39);
    freq.put(" ou", 9);
    freq.put(" or", 8);
    freq.put(" os", 58);
    freq.put(" op", 9);
    freq.put("lb ", 8);
    freq.put("nyy", 5);
    freq.put("ST ", 6);
    freq.put(" pu", 62);
    freq.put(" Kä", 9);
    freq.put("ido", 5);
    freq.put("Osk", 4);
    freq.put("rvi", 31);
    freq.put("gh ", 3);
    freq.put("gar", 14);
    freq.put(" Kõ", 16);
    freq.put("mel", 41);
    freq.put("s ", 2560);
    freq.put("amm", 26);
    freq.put("oss", 23);
    freq.put(" Kü", 9);
    freq.put("naa", 37);
    freq.put("??", 4);
    freq.put("map", 7);
    freq.put("mas", 125);
    freq.put("sne", 4);
    freq.put("mau", 3);
    freq.put("din", 23);
    freq.put("sna", 11);
    freq.put("sS", 8);
    freq.put("sno", 4);
    freq.put("sP", 4);
    freq.put("aok", 7);
    freq.put("sV", 3);
    freq.put(" o ", 8);
    freq.put("sT", 6);
    freq.put("sK", 3);
    freq.put("pük", 6);
    freq.put("sI", 3);
    freq.put("enc", 3);
    freq.put("sO", 6);
    freq.put("mad", 68);
    freq.put("sM", 4);
    freq.put("sC", 7);
    freq.put("sB", 6);
    freq.put("lmi", 44);
    freq.put("Või", 38);
    freq.put("mam", 16);
    freq.put("mal", 86);
    freq.put("sE", 5);
    freq.put("sD", 3);
    freq.put("ght", 6);
    freq.put("sz", 5);
    freq.put("sy", 6);
    freq.put("ylm", 3);
    freq.put("ss", 352);
    freq.put("sr", 12);
    freq.put("sq", 4);
    freq.put("sp", 51);
    freq.put("sw", 6);
    freq.put("sv", 22);
    freq.put("su", 508);
    freq.put("st", 1508);
    freq.put("q", 52);
    freq.put("sj", 52);
    freq.put("si", 1248);
    freq.put("sh", 61);
    freq.put("so", 120);
    freq.put("sn", 38);
    freq.put("sm", 62);
    freq.put("sl", 37);
    freq.put("sc", 12);
    freq.put("sb", 7);
    freq.put("sa", 892);
    freq.put("yli", 5);
    freq.put("sg", 6);
    freq.put("sf", 7);
    freq.put("se", 1460);
    freq.put("sd", 9);
    freq.put("Ru", 6);
    freq.put("enk", 5);
    freq.put("gee", 4);
    freq.put("nsi", 7);
    freq.put("tts", 3);
    freq.put("ttp", 375);
    freq.put("Jar", 3);
    freq.put("ttu", 36);
    freq.put("ttt", 14);
    freq.put("Jan", 4);
    freq.put("Re", 30);
    freq.put("Chr", 4);
    freq.put("aha", 238);
    freq.put("tto", 3);
    freq.put("Ra", 32);
    freq.put("Jah", 4);
    freq.put("ttl", 5);
    freq.put("Jag", 3);
    freq.put("tta", 41);
    freq.put("Ro", 36);
    freq.put("Rh", 3);
    freq.put("Ri", 18);
    freq.put("tte", 155);
    freq.put("sod", 4);
    freq.put(" aa", 62);
    freq.put(" ab", 13);
    freq.put(" ph", 6);
    freq.put(" ad", 11);
    freq.put(" ae", 37);
    freq.put(" ag", 141);
    freq.put(" ah", 20);
    freq.put(" ai", 60);
    freq.put(" aj", 72);
    freq.put(" ak", 16);
    freq.put(" al", 140);
    freq.put(" am", 15);
    freq.put(" an", 80);
    freq.put(" ap", 16);
    freq.put(" ar", 142);
    freq.put(" as", 69);
    freq.put(" at", 4);
    freq.put(" au", 32);
    freq.put(" av", 14);
    freq.put(" aw", 13);
    freq.put("ent", 32);
    freq.put("äht", 11);
    freq.put("dij", 3);
    freq.put("tja", 12);
    freq.put("non", 8);
    freq.put("Ela", 6);
    freq.put("kky", 3);
    freq.put("Kau", 3);
    freq.put("noj", 5);
    freq.put("nok", 6);
    freq.put("kku", 66);
    freq.put("ahn", 3);
    freq.put("mus", 87);
    freq.put("ros", 8);
    freq.put("noa", 3);
    freq.put("aho", 7);
    freq.put("kkl", 3);
    freq.put("kko", 3);
    freq.put("aer", 15);
    freq.put("kki", 32);
    freq.put("She", 4);
    freq.put("kkk", 10);
    freq.put("kke", 24);
    freq.put("ng ", 71);
    freq.put("nov", 3);
    freq.put(" us", 22);
    freq.put("kka", 199);
    freq.put("Ja ", 25);
    freq.put("nos", 5);
    freq.put(" a ", 26);
    freq.put("eg ", 34);
    freq.put("nil", 15);
    freq.put("gal", 14);
    freq.put("aev", 15);
    freq.put("😘", 4);
    freq.put("eru", 6);
    freq.put("sor", 9);
    freq.put(" wo", 5);
    freq.put("ahv", 25);
    freq.put("´i", 3);
    freq.put("😊", 3);
    freq.put("em", 495);
    freq.put("el", 1180);
    freq.put("eo", 55);
    freq.put("en", 686);
    freq.put("ei", 842);
    freq.put("eh", 169);
    freq.put("ek", 394);
    freq.put("ej", 16);
    freq.put("ee", 1022);
    freq.put("ed", 565);
    freq.put("eg", 419);
    freq.put("ef", 28);
    freq.put("ea", 555);
    freq.put("rl ", 5);
    freq.put("ec", 22);
    freq.put("eb", 208);
    freq.put("ey", 23);
    freq.put("ex", 12);
    freq.put("ez", 3);
    freq.put("eu", 32);
    freq.put("et", 712);
    freq.put("ew", 15);
    freq.put("ev", 293);
    freq.put("ep", 88);
    freq.put("es", 948);
    freq.put("er", 547);
    freq.put("eL", 5);
    freq.put("eO", 6);
    freq.put("eN", 3);
    freq.put("nib", 4);
    freq.put("skl", 3);
    freq.put("eK", 7);
    freq.put("eE", 5);
    freq.put("nst", 18);
    freq.put("Kee", 7);
    freq.put("eja", 10);
    freq.put("eC", 4);
    freq.put("eB", 4);
    freq.put("öd ", 27);
    freq.put("blo", 5);
    freq.put("bli", 7);
    freq.put("os ", 36);
    freq.put("blj", 5);
    freq.put("ble", 15);
    freq.put("eT", 4);
    freq.put("Me ", 6);
    freq.put("bla", 7);
    freq.put("eP", 7);
    freq.put("hcl", 3);
    freq.put("eR", 8);
    freq.put("Meh", 6);
    freq.put("rlo", 6);
    freq.put("rli", 10);
    freq.put("RT ", 101);
    freq.put("G", 67);
    freq.put("wan", 5);
    freq.put("rle", 3);
    freq.put("erp", 5);
    freq.put("ort", 18);
    freq.put("oru", 6);
    freq.put("orr", 46);
    freq.put("e ", 3001);
    freq.put("bki", 3);
    freq.put("orn", 5);
    freq.put("oro", 4);
    freq.put("orl", 4);
    freq.put("wal", 7);
    freq.put("orj", 4);
    freq.put("ork", 7);
    freq.put("ori", 30);
    freq.put("rlu", 3);
    freq.put("org", 4);
    freq.put("ord", 55);
    freq.put("ore", 45);
    freq.put("Ü", 32);
    freq.put("ora", 9);
    freq.put("ödu", 10);
    freq.put("osu", 6);
    freq.put("App", 6);
    freq.put("aon", 3);
    freq.put("öda", 6);
    freq.put("tse", 56);
    freq.put("fc", 5);
    freq.put("ak ", 15);
    freq.put("sho", 10);
    freq.put(" ce", 5);
    freq.put("lay", 3);
    freq.put("onj", 4);
    freq.put("onk", 7);
    freq.put("onh", 5);
    freq.put("xi", 10);
    freq.put("iaI", 4);
    freq.put("xo", 5);
    freq.put("õig", 68);
    freq.put("eol", 12);
    freq.put("xb", 3);
    freq.put("õik", 96);
    freq.put("xa", 7);
    freq.put("õim", 20);
    freq.put(" Z ", 3);
    freq.put("aas", 102);
    freq.put("õin", 7);
    freq.put("onz", 3);
    freq.put("xx", 7);
    freq.put("ony", 4);
    freq.put("fek", 4);
    freq.put("rvu", 16);
    freq.put("õiv", 4);
    freq.put("prü", 4);
    freq.put("xp", 3);
    freq.put("xv", 3);
    freq.put("ont", 16);
    freq.put("Eur", 3);
    freq.put("iam", 6);
    freq.put("ial", 19);
    freq.put("ian", 23);
    freq.put("€ ", 5);
    freq.put("iaj", 6);
    freq.put("iad", 6);
    freq.put("uku", 23);
    freq.put("näd", 29);
    freq.put("iaa", 9);
    freq.put("dib", 21);
    freq.put("xD", 10);
    freq.put("uko", 13);
    freq.put("lnu", 39);
    freq.put("ukk", 10);
    freq.put("lar", 14);
    freq.put("uki", 9);
    freq.put("iat", 9);
    freq.put("uke", 35);
    freq.put("iav", 3);
    freq.put("Ott", 3);
    freq.put("ias", 17);
    freq.put("äsk", 5);
    freq.put("õi ", 49);
    freq.put("lme", 21);
    freq.put("hug", 4);
    freq.put("AD ", 10);
    freq.put("hub", 4);
    freq.put("hul", 41);
    freq.put("ööö", 5);
    freq.put("x ", 38);
    freq.put("hui", 17);
    freq.put("za ", 7);
    freq.put("huk", 4);
    freq.put("hut", 8);
    freq.put("huu", 14);
    freq.put("huv", 21);
    freq.put("NG ", 5);
    freq.put("hur", 5);
    freq.put("hus", 8);
    freq.put(" ya", 6);
    freq.put("Mis", 24);
    freq.put("kub", 10);
    freq.put(" Lä", 12);
    freq.put("rza", 3);
    freq.put("võl", 5);
    freq.put("ia ", 54);
    freq.put("või", 144);
    freq.put("asõ", 3);
    freq.put("võt", 44);
    freq.put("r", 3745);
    freq.put("võr", 10);
    freq.put("ehe", 35);
    freq.put("IS ", 8);
    freq.put("atm", 6);
    freq.put("ney", 3);
    freq.put("ogr", 5);
    freq.put("uk ", 3);
    freq.put("sak", 28);
    freq.put("saj", 9);
    freq.put("sai", 60);
    freq.put("ang", 23);
    freq.put("pra", 34);
    freq.put("san", 39);
    freq.put("sam", 77);
    freq.put("sal", 78);
    freq.put("anl", 6);
    freq.put("sab", 6);
    freq.put("saa", 227);
    freq.put("ano", 8);
    freq.put("rke", 10);
    freq.put("cor", 3);
    freq.put("sad", 38);
    freq.put("fc ", 4);
    freq.put("anu", 64);
    freq.put("say", 5);
    freq.put("ry ", 14);
    freq.put("ans", 6);
    freq.put("sas", 22);
    freq.put("sar", 13);
    freq.put("sap", 5);
    freq.put("sav", 4);
    freq.put("sau", 12);
    freq.put("öö ", 23);
    freq.put("Do", 3);
    freq.put("omm", 117);
    freq.put("rmi", 8);
    freq.put("Man", 5);
    freq.put(" L ", 11);
    freq.put("Dd", 3);
    freq.put("De", 15);
    freq.put("gek", 6);
    freq.put("anh", 3);
    freq.put("Da", 15);
    freq.put("ns ", 8);
    freq.put("ax ", 3);
    freq.put("Dv", 3);
    freq.put("mot", 9);
    freq.put("Du", 3);
    freq.put("Dr", 3);
    freq.put("ts ", 48);
    freq.put("Off", 7);
    freq.put("kyp", 7);
    freq.put("ööt", 9);
    freq.put("öös", 11);
    freq.put("öör", 6);
    freq.put("VmA", 3);
    freq.put("öön", 12);
    freq.put("ööm", 7);
    freq.put("ööl", 20);
    freq.put("öök", 19);
    freq.put("öög", 6);
    freq.put("lut", 29);
    freq.put("ööd", 46);
    freq.put("ööb", 3);
    freq.put("luu", 18);
    freq.put(" Le", 13);
    freq.put("vu ", 3);
    freq.put(" La", 35);
    freq.put("uss", 45);
    freq.put(" Lo", 22);
    freq.put("Mer", 9);
    freq.put(" Li", 49);
    freq.put("MG ", 7);
    freq.put("tke", 17);
    freq.put("nlu", 8);
    freq.put("fes", 8);
    freq.put("tka", 5);
    freq.put("tko", 9);
    freq.put("bu ", 5);
    freq.put("Sky", 3);
    freq.put("IP ", 8);
    freq.put("tki", 12);
    freq.put("nla", 6);
    freq.put(" p ", 4);
    freq.put("nle", 7);
    freq.put("nli", 5);
    freq.put("dy ", 5);
    freq.put("ss ", 65);
    freq.put("lig", 20);
    freq.put(" sü", 57);
    freq.put("Wa", 3);
    freq.put("Wo", 9);
    freq.put("ce ", 15);
    freq.put("lub", 17);
    freq.put("Wi", 5);
    freq.put("Wh", 3);
    freq.put("tne", 7);
    freq.put("Wu", 3);
    freq.put("Wt", 3);
    freq.put("oml", 5);
    freq.put("lud", 12);
    freq.put("pti", 7);
    freq.put("owa", 6);
    freq.put("ges", 8);
    freq.put(" pr", 87);
    freq.put("tõs", 9);
    freq.put("gev", 3);
    freq.put(" nä", 128);
    freq.put("get", 8);
    freq.put("ssu", 28);
    freq.put("H", 227);
    freq.put("lug", 23);
    freq.put("sss", 31);
    freq.put("gic", 3);
    freq.put(" pa", 319);
    freq.put("geg", 3);
    freq.put(" pf", 3);
    freq.put(" pe", 241);
    freq.put("ged", 16);
    freq.put("jä", 159);
    freq.put(" pi", 171);
    freq.put(" sõ", 66);
    freq.put(" po", 250);
    freq.put("gen", 10);
    freq.put(" pm", 10);
    freq.put(" pl", 51);
    freq.put(" bä", 3);
    freq.put("luk", 20);
    freq.put("W ", 12);
    freq.put("MrH", 4);
    freq.put("mon", 7);
    freq.put("üüs", 8);
    freq.put("lun", 20);
    freq.put("Lih", 6);
    freq.put("rks", 8);
    freq.put("geL", 3);
    freq.put("rms", 11);
    freq.put("uti", 52);
    freq.put("rmu", 8);
    freq.put("kät", 18);
    freq.put("cio", 3);
    freq.put("luv", 4);
    freq.put("mom", 7);
    freq.put("uto", 20);
    freq.put("rma", 55);
    freq.put("alg", 44);
    freq.put("div", 6);
    freq.put("rme", 13);
    freq.put("tu ", 135);
    freq.put("eb ", 132);
    freq.put("ur", 306);
    freq.put("j ", 20);
    freq.put("rmo", 3);
    freq.put("öll", 3);
    freq.put("üli", 11);
    freq.put(" b ", 5);
    freq.put("ülm", 8);
    freq.put("üll", 59);
    freq.put("üla", 11);
    freq.put("äi ", 8);
    freq.put("õrv", 17);
    freq.put("üle", 74);
    freq.put("üld", 15);
    freq.put("mim", 6);
    freq.put("ndl", 10);
    freq.put("ffa", 5);
    freq.put("Its", 5);
    freq.put("rko", 9);
    freq.put("utv", 20);
    freq.put("öel", 16);
    freq.put("üün", 7);
    freq.put("nka", 14);
    freq.put("fir", 7);
    freq.put("tus", 162);
    freq.put(" pö", 7);
    freq.put(" põ", 28);
    freq.put("uns", 7);
    freq.put("tup", 11);
    freq.put("ju", 541);
    freq.put("tur", 14);
    freq.put("utu", 40);
    freq.put("tut", 38);
    freq.put(" äg", 8);
    freq.put("jr", 3);
    freq.put("js", 6);
    freq.put("ale", 133);
    freq.put("räm", 3);
    freq.put("jn", 10);
    freq.put("jo", 88);
    freq.put("jh", 4);
    freq.put("ji", 9);
    freq.put("jj", 9);
    freq.put("jk", 6);
    freq.put("je", 74);
    freq.put("tub", 39);
    freq.put(" pü", 15);
    freq.put("tud", 93);
    freq.put("ja", 1119);
    freq.put("tug", 7);
    freq.put(" be", 27);
    freq.put("ehi", 7);
    freq.put("äin", 35);
    freq.put("uf", 10);
    freq.put(" ba", 25);
    freq.put("Mfe", 3);
    freq.put("äij", 3);
    freq.put("äik", 44);
    freq.put(" bm", 5);
    freq.put(" bl", 14);
    freq.put(" bo", 10);
    freq.put("äig", 7);
    freq.put(" bi", 18);
    freq.put("S", 400);
    freq.put("äib", 16);
    freq.put(" bu", 26);
    freq.put("rü", 10);
    freq.put("s", 9638);
    freq.put("tuk", 27);
    freq.put("vus", 18);
    freq.put(" br", 10);
    freq.put("äit", 34);
    freq.put("tul", 176);
    freq.put("KU ", 3);
    freq.put("äis", 44);
    freq.put("hvi", 14);
    freq.put("nno", 8);
    freq.put("hvl", 3);
    freq.put("õul", 12);
    freq.put("nnn", 34);
    freq.put("hva", 16);
    freq.put("pot", 5);
    freq.put(" pä", 141);
    freq.put("por", 15);
    freq.put("üt", 46);
    freq.put("pon", 3);
    freq.put("ivõ", 4);
    freq.put("pol", 131);
    freq.put("pom", 6);
    freq.put("pok", 6);
    freq.put("poh", 15);
    freq.put("poi", 15);
    freq.put("nnk", 5);
    freq.put("oon", 54);
    freq.put("poe", 14);
    freq.put("avo", 5);
    freq.put("tib", 5);
    freq.put("eOf", 3);
    freq.put(" Mä", 10);
    freq.put("õme", 3);
    freq.put("Kra", 3);
    freq.put("üp", 14);
    freq.put("fic", 10);
    freq.put("Bus", 4);
    freq.put(" Mõ", 11);
    freq.put("etL", 3);
    freq.put("bab", 7);
    freq.put(" Mü", 4);
    freq.put("bil", 6);
    freq.put("kep", 5);
    freq.put("Är", 4);
    freq.put("nne", 100);
    freq.put("õun", 7);
    freq.put("äta", 8);
    freq.put("äim", 8);
    freq.put(" e ", 13);
    freq.put("ls ", 7);
    freq.put("ltu", 3);
    freq.put("bac", 3);
    freq.put("Aeg", 3);
    freq.put("teR", 3);
    freq.put("htn", 7);
    freq.put("tiS", 3);
    freq.put("ono", 3);
    freq.put("aI ", 3);
    freq.put("po ", 3);
    freq.put("dwa", 3);
    freq.put("eis", 71);
    freq.put("eir", 4);
    freq.put("eiu", 12);
    freq.put("eit", 26);
    freq.put("eiv", 3);
    freq.put("fin", 8);
    freq.put("sva", 16);
    freq.put("Kad", 7);
    freq.put("Ä ", 3);
    freq.put("uon", 3);
    freq.put("eia", 9);
    freq.put("äid", 20);
    freq.put("eib", 6);
    freq.put("eie", 28);
    freq.put("eid", 101);
    freq.put("jU", 3);
    freq.put("eii", 6);
    freq.put("eik", 10);
    freq.put("eij", 5);
    freq.put("eim", 6);
    freq.put("eil", 86);
    freq.put("ein", 51);
    freq.put("ive", 18);
    freq.put("amä", 6);
    freq.put("vum", 12);
    freq.put("iva", 50);
    freq.put("nni", 92);
    freq.put("ivn", 3);
    freq.put("üa", 18);
    freq.put("ePr", 3);
    freq.put("ivi", 15);
    freq.put("oi ", 7);
    freq.put("nso", 3);
    freq.put("ivu", 3);
    freq.put("Et ", 3);
    freq.put("ivs", 4);
    freq.put("õva", 10);
    freq.put("lil", 20);
    freq.put("lõh", 11);
    freq.put("ül", 183);
    freq.put("Bas", 4);
    freq.put("tku", 4);
    freq.put(" Me", 42);
    freq.put("UT ", 4);
    freq.put("pas", 16);
    freq.put("pat", 15);
    freq.put(" Ma", 131);
    freq.put("Nöp", 5);
    freq.put("chi", 7);
    freq.put(" Mm", 3);
    freq.put(" Mo", 19);
    freq.put("muh", 3);
    freq.put(" Mi", 100);
    freq.put("Sin", 9);
    freq.put("akk", 101);
    freq.put(" Mu", 43);
    freq.put("pab", 3);
    freq.put("eta", 84);
    freq.put("pad", 6);
    freq.put("üh", 66);
    freq.put(" Mr", 6);
    freq.put("pah", 18);
    freq.put("I ", 69);
    freq.put("pak", 43);
    freq.put("pal", 98);
    freq.put("pam", 4);
    freq.put("pan", 67);
    freq.put("oin", 6);
    freq.put("oim", 12);
    freq.put("cel", 6);
    freq.put("iv ", 10);
    freq.put("nge", 29);
    freq.put("pse", 32);
    freq.put("I", 142);
    freq.put("ete", 56);
    freq.put("õhj", 6);
    freq.put("õhk", 6);
    freq.put("oia", 7);
    freq.put("yd", 11);
    freq.put("õta", 21);
    freq.put("oju", 27);
    freq.put("õht", 40);
    freq.put("õhu", 4);
    freq.put("yg", 5);
    freq.put("jõu", 30);
    freq.put("mst", 8);
    freq.put("mpa", 6);
    freq.put("oit", 13);
    freq.put("ois", 13);
    freq.put("tli", 16);
    freq.put("bso", 4);
    freq.put("nag", 85);
    freq.put("oka", 15);
    freq.put(" M ", 9);
    freq.put("nad", 26);
    freq.put("uju", 25);
    freq.put("Is", 15);
    freq.put("muu", 34);
    freq.put("It", 11);
    freq.put("öpf", 4);
    freq.put("Iv", 3);
    freq.put("Ii", 5);
    freq.put("naj", 3);
    freq.put("Ik", 6);
    freq.put("ujo", 4);
    freq.put("Im", 7);
    freq.put("Il", 13);
    freq.put("In", 20);
    freq.put("Hob", 3);
    freq.put("dki", 9);
    freq.put("uja", 5);
    freq.put("Ig", 7);
    freq.put("ant", 55);
    freq.put("tip", 12);
    freq.put("ps ", 27);
    freq.put("oki", 18);
    freq.put("kul", 56);
    freq.put("tir", 5);
    freq.put("uid", 94);
    freq.put("vä", 237);
    freq.put("tis", 61);
    freq.put("okk", 32);
    freq.put("käi", 69);
    freq.put("til", 26);
    freq.put("yIt", 5);
    freq.put("uh ", 9);
    freq.put("BA ", 8);
    freq.put("tin", 24);
    freq.put("yt", 8);
    freq.put("lõi", 5);
    freq.put(" ge", 15);
    freq.put("oko", 20);
    freq.put("lel", 23);
    freq.put("lg ", 7);
    freq.put(" gc", 3);
    freq.put("lük", 4);
    freq.put("amh", 3);
    freq.put("psi", 12);
    freq.put("taM", 3);
    freq.put("õis", 18);
    freq.put("amo", 11);
    freq.put("amn", 3);
    freq.put("ama", 225);
    freq.put("mor", 5);
    freq.put("tõr", 3);
    freq.put(" ga", 16);
    freq.put("Näe", 3);
    freq.put("tõu", 8);
    freq.put("Näg", 5);
    freq.put("pos", 14);
    freq.put("amy", 5);
    freq.put("tid", 31);
    freq.put("Mat", 5);
    freq.put("tõl", 3);
    freq.put("tõm", 13);
    freq.put("alv", 21);
    freq.put("Mah", 4);
    freq.put("amp", 18);
    freq.put("ams", 4);
    freq.put("tõd", 3);
    freq.put("tõe", 15);
    freq.put("Õnn", 3);
    freq.put("psu", 5);
    freq.put("Pii", 4);
    freq.put("tv ", 4);
    freq.put("tig", 5);
    freq.put("poo", 57);
    freq.put("oad", 5);
    freq.put("tia", 7);
    freq.put("Ran", 3);
    freq.put("arc", 3);
    freq.put("lau", 61);
    freq.put("t", 9092);
    freq.put("lic", 11);
    freq.put("Lov", 4);
    freq.put("Pir", 3);
    freq.put("gri", 8);
    freq.put("Pit", 3);
    freq.put("EP ", 3);
    freq.put("võ", 208);
    freq.put("Nel", 3);
    freq.put(" ää", 4);
    freq.put("noo", 18);
    freq.put("tvu", 22);
    freq.put("Kuu", 5);
    freq.put("Kus", 4);
    freq.put("üps", 3);
    freq.put("ouu", 5);
    freq.put("omp", 5);
    freq.put("cs", 7);
    freq.put("Kum", 4);
    freq.put("Rah", 3);
    freq.put("Kui", 39);
    freq.put("msa", 10);
    freq.put("mbi", 15);
    freq.put("až", 3);
    freq.put("öta", 6);
    freq.put("kme", 5);
    freq.put(" co", 385);
    freq.put(" cl", 3);
    freq.put("uck", 16);
    freq.put(" ca", 16);
    freq.put("Mei", 11);
    freq.put("pri", 18);
    freq.put("kmi", 3);
    freq.put("o ", 636);
    freq.put("Met", 4);
    freq.put("Rau", 3);
    freq.put("ötu", 3);
    freq.put("´", 3);
    freq.put("edu", 9);
    freq.put("ddl", 4);
    freq.put(" cr", 9);
    freq.put("dda", 3);
    freq.put("käs", 6);
    freq.put("mur", 19);
    freq.put("dde", 3);
    freq.put(" cu", 6);
    freq.put("oM", 4);
    freq.put("oL", 4);
    freq.put("oK", 3);
    freq.put("dee", 14);
    freq.put("oE", 3);
    freq.put("oC", 3);
    freq.put("oB", 3);
    freq.put("õõm", 7);
    freq.put("asn", 3);
    freq.put("nme", 3);
    freq.put("uTu", 4);
    freq.put("ci ", 3);
    freq.put("oT", 3);
    freq.put("oR", 3);
    freq.put("oo", 735);
    freq.put("on", 762);
    freq.put("om", 340);
    freq.put("ol", 989);
    freq.put("ok", 170);
    freq.put("oj", 49);
    freq.put("oi", 93);
    freq.put("km ", 4);
    freq.put("og", 73);
    freq.put("of", 20);
    freq.put("oe", 64);
    freq.put("od", 179);
    freq.put("oc", 21);
    freq.put("ob", 75);
    freq.put("oa", 37);
    freq.put("ngo", 4);
    freq.put("ô", 4);
    freq.put("oy", 10);
    freq.put("yat", 4);
    freq.put("ow", 37);
    freq.put("ov", 69);
    freq.put("ou", 72);
    freq.put("ot", 234);
    freq.put("os", 225);
    freq.put("or", 313);
    freq.put("op", 69);
    freq.put("LE ", 13);
    freq.put("Ni", 40);
    freq.put("ju ", 155);
    freq.put("Nl", 3);
    freq.put("Nm", 4);
    freq.put("No", 37);
    freq.put("Na", 28);
    freq.put("Nb", 3);
    freq.put("yyy", 4);
    freq.put("Ne", 12);
    freq.put("yyd", 5);
    freq.put("FB ", 3);
    freq.put("aõ", 4);
    freq.put("Nu", 5);
    freq.put("het", 36);
    freq.put("hev", 4);
    freq.put("loa", 5);
    freq.put("hep", 6);
    freq.put("sõb", 18);
    freq.put("her", 14);
    freq.put("hes", 10);
    freq.put("ni ", 142);
    freq.put("sõn", 11);
    freq.put("mix", 4);
    freq.put("lon", 14);
    freq.put("hey", 4);
    freq.put("sõi", 33);
    freq.put("lom", 3);
    freq.put("hed", 22);
    freq.put("hee", 10);
    freq.put("heg", 5);
    freq.put("lov", 9);
    freq.put("hea", 119);
    freq.put("heb", 26);
    freq.put("sõp", 6);
    freq.put("hel", 80);
    freq.put("hem", 28);
    freq.put("hen", 37);
    freq.put("ehm", 4);
    freq.put("heh", 6);
    freq.put("hei", 10);
    freq.put("ehh", 4);
    freq.put("hek", 20);
    freq.put("jub", 84);
    freq.put("ago", 4);
    freq.put("rju", 50);
    freq.put("jud", 11);
    freq.put("N ", 40);
    freq.put("juk", 3);
    freq.put("juh", 30);
    freq.put("J", 203);
    freq.put("jun", 7);
    freq.put("agm", 4);
    freq.put("jul", 21);
    freq.put("jum", 16);
    freq.put("jus", 55);
    freq.put("rje", 11);
    freq.put("Ab", 4);
    freq.put("yy ", 5);
    freq.put("jut", 68);
    freq.put("IE ", 3);
    freq.put("OD ", 5);
    freq.put("e", 12501);
    freq.put("mde", 4);
    freq.put("lo ", 21);
    freq.put("gga", 5);
    freq.put("ümm", 3);
    freq.put("ümn", 6);
    freq.put("üma", 3);
    freq.put("ümb", 3);
    freq.put("agh", 3);
    freq.put(" sh", 14);
    freq.put("är", 355);
    freq.put("agg", 4);
    freq.put("as ", 410);
    freq.put("he ", 94);
    freq.put("eh ", 13);
    freq.put("ümp", 3);
    freq.put("Ava", 5);
    freq.put("aa", 1022);
    freq.put("õra", 5);
    freq.put("ac", 35);
    freq.put("ab", 336);
    freq.put("ae", 159);
    freq.put("ad", 740);
    freq.put("ag", 543);
    freq.put("af", 16);
    freq.put("ai", 425);
    freq.put("ah", 574);
    freq.put("ak", 617);
    freq.put("aj", 224);
    freq.put("Nä", 15);
    freq.put("al", 1315);
    freq.put("ao", 39);
    freq.put("an", 928);
    freq.put("ap", 160);
    freq.put("as", 1348);
    freq.put("ar", 733);
    freq.put("Nü", 17);
    freq.put("at", 728);
    freq.put("aw", 20);
    freq.put("av", 247);
    freq.put("ay", 34);
    freq.put("ax", 4);
    freq.put("ohv", 9);
    freq.put("az", 9);
    freq.put("Nö", 6);
    freq.put("aA", 3);
    freq.put("igu", 22);
    freq.put("aB", 5);
    freq.put("aD", 3);
    freq.put("yoh", 3);
    freq.put("aI", 4);
    freq.put("aH", 3);
    freq.put("aK", 10);
    freq.put("aJ", 3);
    freq.put("aM", 12);
    freq.put("aL", 5);
    freq.put("aO", 3);
    freq.put("aN", 3);
    freq.put("igg", 4);
    freq.put("aP", 5);
    freq.put("aS", 9);
    freq.put("aR", 4);
    freq.put("aT", 5);
    freq.put("iga", 169);
    freq.put("ota", 38);
    freq.put("Lau", 14);
    freq.put("you", 12);
    freq.put("igl", 5);
    freq.put("utm", 3);
    freq.put("igi", 45);
    freq.put("igh", 7);
    freq.put("a ", 4919);
    freq.put("rv ", 9);
    freq.put("sia", 15);
    freq.put("oh ", 23);
    freq.put("rv", 160);
    freq.put("ote", 12);
    freq.put("Vaa", 14);
    freq.put("rw", 3);
    freq.put("jäi", 11);
    freq.put("bod", 4);
    freq.put("rp", 10);
    freq.put("lge", 33);
    freq.put("nüü", 104);
    freq.put("tlu", 12);
    freq.put("aH ", 3);
    freq.put("Män", 6);
    freq.put("at ", 146);
    freq.put("US ", 12);
    freq.put("mud", 5);
    freq.put("Mad", 6);
    freq.put("yo ", 4);
    freq.put("vas", 95);
    freq.put("Õn", 3);
    freq.put("u", 6842);
    freq.put("Bri", 6);
    freq.put("ig ", 3);
    freq.put("uit", 8);
    freq.put("jät", 15);
    freq.put("Ül", 11);
    freq.put("Ük", 11);
    freq.put("Bra", 3);
    freq.put("Õh", 5);
    freq.put("Vaj", 3);
    freq.put("alo", 21);
    freq.put("Vah", 3);
    freq.put("Vai", 3);
    freq.put("Van", 4);
    freq.put("sch", 3);
    freq.put("Fit", 3);
    freq.put("ali", 112);
    freq.put("Vab", 5);
    freq.put("iu ", 5);
    freq.put("pte", 5);
    freq.put("tä ", 4);
    freq.put("sy ", 4);
    freq.put("lly", 11);
    freq.put("€", 5);
    freq.put("tL", 3);
    freq.put("gt", 4);
    freq.put("ndu", 49);
    freq.put("Uus", 7);
    freq.put("Kõi", 11);
    freq.put("Kõh", 3);
    freq.put("ggo", 4);
    freq.put("gs", 8);
    freq.put("fa ", 3);
    freq.put("alu", 83);
    freq.put("alr", 3);
    freq.put("als", 16);
    freq.put("gr", 33);
    freq.put("smo", 4);
    freq.put("ots", 60);
    freq.put("tz", 9);
    freq.put("Oeh", 3);
    freq.put("ty", 17);
    freq.put("tv", 33);
    freq.put(" N ", 4);
    freq.put("tt", 719);
    freq.put("gp", 5);
    freq.put("tr", 140);
    freq.put("ts", 444);
    freq.put("tp", 378);
    freq.put("otu", 7);
    freq.put("tn", 24);
    freq.put("to", 232);
    freq.put("tl", 116);
    freq.put("tm", 47);
    freq.put("tj", 14);
    freq.put("tk", 57);
    freq.put("th", 54);
    freq.put("GI ", 6);
    freq.put("tf", 8);
    freq.put("tg", 13);
    freq.put("te", 1156);
    freq.put("tb", 6);
    freq.put("tc", 11);
    freq.put("ta", 1292);
    freq.put(" rõ", 10);
    freq.put("näi", 26);
    freq.put("iuk", 7);
    freq.put("täh", 18);
    freq.put("ium", 6);
    freq.put("tän", 105);
    freq.put("Ane", 5);
    freq.put("LA ", 4);
    freq.put("mpl", 3);
    freq.put("dsi", 13);
    freq.put("iud", 6);
    freq.put("õus", 10);
    freq.put("täd", 4);
    freq.put(" rä", 46);
    freq.put("nko", 5);
    freq.put("fai", 4);
    freq.put("fan", 6);
    freq.put("tnu", 10);
    freq.put("fal", 5);
    freq.put("rm", 118);
    freq.put("õue", 6);
    freq.put("fac", 8);
    freq.put("ius", 9);
    freq.put("faa", 3);
    freq.put("õua", 11);
    freq.put("iut", 4);
    freq.put("ert", 19);
    freq.put(" Ni", 34);
    freq.put("gg", 13);
    freq.put("pre", 4);
    freq.put("ro", 220);
    freq.put(" Nl", 3);
    freq.put(" No", 37);
    freq.put(" Na", 27);
    freq.put(" Ne", 11);
    freq.put("ge", 294);
    freq.put("SI ", 7);
    freq.put("sma", 29);
    freq.put("gc", 6);
    freq.put("dsa", 5);
    freq.put(" Nu", 4);
    freq.put("Ann", 12);
    freq.put("t ", 2251);
    freq.put("gb", 3);
    freq.put("teh", 67);
    freq.put("tei", 100);
    freq.put("tek", 37);
    freq.put("tel", 92);
    freq.put("ga", 896);
    freq.put("ten", 15);
    freq.put("teo", 4);
    freq.put("tea", 92);
    freq.put("teb", 3);
    freq.put("töö", 59);
    freq.put("ted", 25);
    freq.put("tee", 142);
    freq.put("ähk", 5);
    freq.put("go", 41);
    freq.put("lds", 17);
    freq.put("tep", 3);
    freq.put("ter", 105);
    freq.put("tes", 51);
    freq.put("tet", 20);
    freq.put("gm", 28);
    freq.put("Sma", 3);
    freq.put("sug", 20);
    freq.put("aba", 29);
    freq.put("tü", 39);
    freq.put("gl", 32);
    freq.put("moo", 19);
    freq.put("sub", 8);
    freq.put("tö", 65);
    freq.put("sun", 14);
    freq.put("sum", 12);
    freq.put("tõ", 60);
    freq.put("suk", 21);
    freq.put("sui", 7);
    freq.put("suh", 39);
    freq.put("suv", 25);
    freq.put("suu", 75);
    freq.put("sut", 35);
    freq.put("sus", 42);
    freq.put("r ", 229);
    freq.put("sup", 11);
    freq.put("tä", 210);
    freq.put("Jac", 3);
    freq.put(" ru", 17);
    freq.put("õrk", 6);
    freq.put("nam", 47);
    freq.put("te ", 272);
    freq.put("K", 489);
    freq.put("smi", 7);
    freq.put(" re", 63);
    freq.put("oan", 6);
    freq.put("Noo", 5);
    freq.put(" ra", 102);
    freq.put("näp", 6);
    freq.put(" õu", 11);
    freq.put("Noh", 3);
    freq.put(" ro", 59);
    freq.put(" rn", 5);
    freq.put(" ri", 45);
    freq.put("mod", 6);
    freq.put("ves", 25);
    freq.put("š", 11);
    freq.put("pea", 192);
    freq.put("Mi ", 3);
    freq.put("GU ", 3);
    freq.put("su ", 85);
    freq.put("oma", 112);
    freq.put("uts", 41);
    freq.put("lki", 5);
    freq.put(" Nä", 15);
    freq.put("rul", 8);
    freq.put("ev ", 74);
    freq.put(" Nü", 16);
    freq.put(" Nö", 6);
    freq.put("vib", 5);
    freq.put("rku", 9);
    freq.put("via", 9);
    freq.put("vig", 11);
    freq.put("vid", 27);
    freq.put("vie", 3);
    freq.put("eyI", 5);
    freq.put("vik", 27);
    freq.put("vih", 24);
    freq.put("vii", 77);
    freq.put("vin", 25);
    freq.put("Üli", 6);
    freq.put("vil", 23);
    freq.put("vim", 4);
    freq.put("vir", 7);
    freq.put("vis", 81);
    freq.put("vip", 3);
    freq.put("vc", 4);
    freq.put("Too", 3);
    freq.put("vit", 52);
    freq.put("puu", 13);
    freq.put("S ", 86);
    freq.put("Mõi", 3);
    freq.put("rki", 12);
    freq.put("ky ", 4);
    freq.put("rkk", 3);
    freq.put("ünn", 17);
    freq.put("kl ", 9);
    freq.put("twe", 14);
    freq.put("eyi", 3);
    freq.put("ünd", 5);
    freq.put("twi", 25);
    freq.put("rää", 38);
    freq.put(" d ", 9);
    freq.put("oet", 3);
    freq.put("täp", 15);
    freq.put("mui", 35);
    freq.put("anc", 7);
    freq.put("asm", 6);
    freq.put("avu", 5);
    freq.put("de ", 126);
    freq.put("ünt", 6);
    freq.put("pus", 7);
    freq.put("Mõn", 5);
    freq.put("mla", 6);
    freq.put("äää", 16);
    freq.put(" dM", 3);
    freq.put("ähe", 121);
    freq.put("Ss", 4);
    freq.put("lmu", 5);
    freq.put("Sp", 10);
    freq.put("Sw", 4);
    freq.put("Sv", 4);
    freq.put("Su", 31);
    freq.put("St", 23);
    freq.put("Sk", 3);
    freq.put("gO", 3);
    freq.put("Si", 55);
    freq.put("Sh", 11);
    freq.put("So", 25);
    freq.put("Üle", 4);
    freq.put("Sm", 6);
    freq.put("Sc", 3);
    freq.put(" äk", 6);
    freq.put("Sa", 70);
    freq.put(" Ül", 11);
    freq.put(" Ük", 11);
    freq.put("gM", 3);
    freq.put("Se", 55);
    freq.put(" Üh", 4);
    freq.put(" do", 19);
    freq.put("kle", 12);
    freq.put("gL", 3);
    freq.put("kla", 35);
    freq.put(" di", 20);
    freq.put(" de", 10);
    freq.put("õte", 14);
    freq.put("det", 21);
    freq.put("kli", 17);
    freq.put(" da", 17);
    freq.put("EK ", 4);
    freq.put("bur", 7);
    freq.put("klu", 9);
    freq.put("dek", 13);
    freq.put("Vas", 5);
    freq.put("Ini", 4);
    freq.put("den", 7);
    freq.put("Ink", 4);
    freq.put("ök ", 11);
    freq.put("dea", 6);
    freq.put(" du", 13);
    freq.put("Ing", 3);
    freq.put("ded", 5);
    freq.put(" dr", 7);
    freq.put("äki", 21);
    freq.put("hhp", 3);
    freq.put("hhu", 12);
    freq.put("nsu", 6);
    freq.put("bus", 26);
    freq.put("go ", 6);
    freq.put("f ", 28);
    freq.put("hha", 9);
    freq.put("lal", 27);
    freq.put("õrr", 4);
    freq.put("hhe", 3);
    freq.put("hhi", 3);
    freq.put("hhh", 70);
    freq.put("ohi", 11);
    freq.put("ob ", 14);
    freq.put("low", 4);
    freq.put("Vir", 3);
    freq.put("mai", 34);
    freq.put("õts", 9);
    freq.put("ääs", 9);
    freq.put("äär", 14);
    freq.put("põr", 7);
    freq.put("ääv", 4);
    freq.put("äät", 9);
    freq.put("ääk", 18);
    freq.put("lri", 3);
    freq.put("atu", 116);
    freq.put("ään", 10);
    freq.put("ääm", 3);
    freq.put("ääl", 12);
    freq.put("opt", 4);
    freq.put("ääb", 11);
    freq.put("äha", 8);
    freq.put("ääg", 26);
    freq.put("ääd", 6);
    freq.put("pap", 8);
    freq.put("fr", 14);
    freq.put("fs", 3);
    freq.put("ft", 8);
    freq.put("fu", 23);
    freq.put("fy", 3);
    freq.put("fz", 3);
    freq.put("Sö", 4);
    freq.put("fa", 45);
    freq.put("fb", 11);
    freq.put("hh ", 26);
    freq.put("fd", 4);
    freq.put("fe", 46);
    freq.put("ff", 30);
    freq.put("fh", 3);
    freq.put("fi", 76);
    freq.put("fk", 3);
    freq.put("fl", 8);
    freq.put("fm", 5);
    freq.put("fo", 46);
    freq.put("a", 16233);
    freq.put("fQ", 3);
    freq.put("ct ", 4);
    freq.put(" ◄", 4);
    freq.put("fW", 3);
    freq.put("egs", 3);
    freq.put("egu", 37);
    freq.put("mar", 48);
    freq.put("ne ", 391);
    freq.put("egi", 118);
    freq.put("ds ", 5);
    freq.put("ö", 433);
    freq.put("ega", 171);
    freq.put("ää ", 13);
    freq.put("ege", 43);
    freq.put("oy ", 5);
    freq.put("ito", 8);
    freq.put("itl", 9);
    freq.put("itm", 11);
    freq.put("itj", 7);
    freq.put("itk", 3);
    freq.put("ith", 3);
    freq.put("iti", 52);
    freq.put("y ", 110);
    freq.put("ite", 58);
    freq.put(" sö", 35);
    freq.put("itc", 6);
    freq.put("ita", 148);
    freq.put("uvi", 31);
    freq.put("ffi", 17);
    freq.put("ity", 4);
    freq.put("uva", 24);
    freq.put("itt", 114);
    freq.put("itu", 74);
    freq.put("itr", 4);
    freq.put("its", 99);
    freq.put(" sä", 7);
    freq.put(" On", 8);
    freq.put(" Oo", 9);
    freq.put(" Ol", 28);
    freq.put(" Om", 8);
    freq.put("UR ", 8);
    freq.put(" Ok", 5);
    freq.put(" Oh", 8);
    freq.put("paa", 18);
    freq.put(" Of", 4);
    freq.put(" Oe", 4);
    freq.put("ae ", 7);
    freq.put("ope", 8);
    freq.put("nto", 5);
    freq.put("usp", 6);
    freq.put("if ", 3);
    freq.put("Mon", 5);
    freq.put(" Ot", 7);
    freq.put(" Ou", 3);
    freq.put(" Or", 4);
    freq.put(" Os", 11);
    freq.put("pae", 4);
    freq.put("yi", 6);
    freq.put("yk", 3);
    freq.put("uhe", 7);
    freq.put("ym", 3);
    freq.put("yl", 23);
    freq.put("yo", 32);
    freq.put("yn", 5);
    freq.put("ya", 20);
    freq.put("yc", 3);
    freq.put("yb", 3);
    freq.put("ye", 11);
    freq.put("L", 237);
    freq.put("it ", 123);
    freq.put("uhi", 6);
    freq.put("yy", 17);
    freq.put("uht", 58);
    freq.put("uhu", 22);
    freq.put("oke", 17);
    freq.put("AT ", 4);
    freq.put("pai", 14);
    freq.put("uv ", 3);
    freq.put("yp", 11);
    freq.put("ys", 12);
    freq.put("yr", 5);
    freq.put("yu", 4);
    freq.put("Eri", 6);
    freq.put("yw", 5);
    freq.put("Erk", 4);
    freq.put("yI", 7);
    freq.put("Tar", 13);
    freq.put("Raa", 6);
    freq.put("yA", 3);
    freq.put("Tas", 4);
    freq.put("Rak", 4);
    freq.put(" O ", 14);
    freq.put("Rai", 7);
    freq.put("ife", 14);
    freq.put("yZ", 3);
    freq.put("Ras", 3);
    freq.put("man", 29);
    freq.put("yP", 3);
    freq.put("yS", 3);
    freq.put("aaž", 3);
    freq.put("ast", 354);
    freq.put("ifi", 5);
    freq.put("anv", 3);
    freq.put(" A ", 4);
    freq.put("M", 515);
    freq.put("dig", 7);
    freq.put("Mus", 7);
    freq.put("rHu", 4);
    freq.put(" sr", 5);
    freq.put(" ss", 11);
    freq.put("itä", 14);
    freq.put("pu ", 10);
    freq.put(" sw", 4);
    freq.put(" st", 37);
    freq.put(" su", 240);
    freq.put(" sk", 12);
    freq.put("itü", 3);
    freq.put(" si", 406);
    freq.put(" sn", 7);
    freq.put(" so", 69);
    freq.put(" sl", 7);
    freq.put(" sm", 3);
    freq.put(" sc", 3);
    freq.put("uda", 48);
    freq.put(" sa", 473);
    freq.put("õde", 5);
    freq.put("mm ", 16);
    freq.put(" se", 558);
    freq.put("Oma", 4);
    freq.put("Omg", 4);
    freq.put("oii", 5);
    freq.put("Krt", 4);
    freq.put("E ", 79);
    freq.put("lüü", 3);
    freq.put("SH ", 3);
    freq.put("õhn", 7);
    freq.put("dag", 66);
    freq.put("abl", 5);
    freq.put("kuu", 73);
    freq.put("►", 4);
    freq.put("Taa", 7);
    freq.put("pul", 9);
    freq.put(" Aa", 10);
    freq.put("pun", 15);
    freq.put("asp", 9);
    freq.put("puh", 22);
    freq.put("asv", 9);
    freq.put("asu", 46);
    freq.put(" Ag", 36);
    freq.put(" Ah", 10);
    freq.put(" Ai", 17);
    freq.put(" Ak", 3);
    freq.put(" Al", 30);
    freq.put(" Am", 7);
    freq.put(" An", 29);
    freq.put("Üks", 11);
    freq.put(" Ap", 9);
    freq.put("dit", 18);
    freq.put(" Ar", 9);
    freq.put(" As", 5);
    freq.put("mmi", 78);
    freq.put(" Au", 8);
    freq.put(" Av", 9);
    freq.put("sbe", 4);
    freq.put("Del", 3);
    freq.put(" eh", 29);
    freq.put(" s ", 22);
    freq.put("õhi", 4);
    freq.put("aso", 6);
    freq.put("ekõ", 3);
    freq.put("pur", 7);
    freq.put(" ei", 425);
    freq.put("Em", 8);
    freq.put("El", 31);
    freq.put("En", 11);
    freq.put("Ei", 39);
    freq.put("Eh", 6);
    freq.put("Ek", 7);
    freq.put("ion", 19);
    freq.put("Ee", 38);
    freq.put("Ed", 3);
    freq.put("Eg", 7);
    freq.put(" ek", 31);
    freq.put("but", 6);
    freq.put("õtl", 17);
    freq.put("õtm", 4);
    freq.put("ft ", 4);
    freq.put("Ex", 3);
    freq.put("w", 288);
    freq.put("tos", 14);
    freq.put("Eu", 4);
    freq.put("Et", 4);
    freq.put("Mel", 5);
    freq.put("Ev", 6);
    freq.put(" är", 144);
    freq.put("Es", 6);
    freq.put("Er", 14);
    freq.put("le ", 732);
    freq.put(" eg", 15);
    freq.put("ody", 5);
    freq.put("tf ", 5);
    freq.put(" ea", 5);
    freq.put("ude", 36);
    freq.put("uen", 3);
    freq.put("bul", 5);
    freq.put(" eb", 10);
    freq.put("mah", 14);
    freq.put("koi", 5);
    freq.put("koh", 75);
    freq.put("kok", 27);
    freq.put("koj", 23);
    freq.put("kom", 27);
    freq.put("kol", 38);
    freq.put("koo", 139);
    freq.put("kon", 46);
    freq.put(" ed", 22);
    freq.put(" ee", 88);
    freq.put("X ", 16);
    freq.put("kob", 4);
    freq.put("koe", 5);
    freq.put("kod", 35);
    freq.put("kog", 27);
    freq.put("ädi", 4);
    freq.put("een", 56);
    freq.put("jed", 4);
    freq.put("jee", 15);
    freq.put(" et", 305);
    freq.put("jek", 4);
    freq.put("kos", 16);
    freq.put("kor", 89);
    freq.put("jen", 4);
    freq.put("kot", 18);
    freq.put("jel", 6);
    freq.put("jem", 11);
    freq.put("omu", 3);
    freq.put("ods", 3);
    freq.put("mer", 29);
    freq.put("küü", 9);
    freq.put("uik", 4);
    freq.put("tom", 4);
    freq.put("odu", 44);
    freq.put("eli", 108);
    freq.put("mpi", 7);
    freq.put("hti", 28);
    freq.put("aaS", 4);
    freq.put("kop", 6);
    freq.put("Ära", 3);
    freq.put("age", 18);
    freq.put(" ev", 6);
    freq.put("när", 17);
    freq.put("aae", 5);
    freq.put("ste", 145);
    freq.put("aag", 10);
    freq.put("b", 1437);
    freq.put("aaa", 145);
    freq.put("sta", 232);
    freq.put("kä", 119);
    freq.put("rk ", 15);
    freq.put("ko ", 11);
    freq.put("öhö", 3);
    freq.put("Xf", 3);
    freq.put(" õn", 23);
    freq.put("stj", 4);
    freq.put("eln", 9);
    freq.put("aau", 5);
    freq.put("i", 12672);
    freq.put("je ", 4);
    freq.put("htt", 375);
    freq.put("kow", 3);
    freq.put("kõ", 165);
    freq.put("sts", 10);
    freq.put("Ren", 3);
    freq.put(" es", 56);
    freq.put("sty", 3);
    freq.put("dtu", 4);
    freq.put("kü", 130);
    freq.put("Goo", 4);
    freq.put("ka ", 349);
    freq.put("rry", 8);
    freq.put("sh ", 10);
    freq.put("odo", 4);
    freq.put("elo", 10);
    freq.put("ui ", 243);
    freq.put("nää", 3);
    freq.put("nak", 14);
    freq.put("max", 3);
    freq.put(" õe", 5);
    freq.put("ön ", 7);
    freq.put("tk ", 7);
    freq.put("rru", 9);
    freq.put("lid", 43);
    freq.put("pa ", 24);
    freq.put("lif", 12);
    freq.put("k ", 325);
    freq.put("nig", 8);
    freq.put("lia", 17);
    freq.put("ex ", 3);
    freq.put("tp ", 372);
    freq.put("Kis", 3);
    freq.put("Kir", 5);
    freq.put("lin", 147);
    freq.put("lio", 11);
    freq.put("lih", 41);
    freq.put("lii", 106);
    freq.put("rrr", 10);
    freq.put("Kik", 6);
    freq.put("efi", 3);
    freq.put("liv", 12);
    freq.put("lip", 10);
    freq.put("ues", 19);
    freq.put("Kim", 3);
    freq.put("efo", 13);
    freq.put("cci", 4);
    freq.put("eff", 5);
    freq.put("uji", 3);
    freq.put("rin", 42);
    freq.put("kab", 24);
    freq.put("kaa", 64);
    freq.put("war", 6);
    freq.put("kag", 12);
    freq.put("kae", 8);
    freq.put("kad", 39);
    freq.put("kak", 29);
    freq.put("kaj", 6);
    freq.put("kai", 32);
    freq.put("kah", 43);
    freq.put("kao", 13);
    freq.put("kan", 57);
    freq.put("kam", 31);
    freq.put("kal", 52);
    freq.put("kas", 190);
    freq.put("kar", 52);
    freq.put("kap", 14);
    freq.put("kav", 13);
    freq.put("kau", 38);
    freq.put("kat", 65);
    freq.put("kül", 71);
    freq.put("küm", 5);
    freq.put("The", 6);
    freq.put("Tha", 4);
    freq.put("kük", 3);
    freq.put("õõ", 12);
    freq.put("ka", 1155);
    freq.put("atk", 9);
    freq.put("li ", 254);
    freq.put("ke", 575);
    freq.put("exa", 5);
    freq.put("kk", 367);
    freq.put("kj", 7);
    freq.put("ki", 418);
    freq.put("kh", 17);
    freq.put("ko", 601);
    freq.put("kn", 18);
    freq.put("km", 14);
    freq.put("kl", 87);
    freq.put("ks", 908);
    freq.put("kr", 68);
    freq.put("kp", 6);
    freq.put("kw", 3);
    freq.put("kv", 14);
    freq.put("ku", 865);
    freq.put("kt", 56);
    freq.put("kz", 3);
    freq.put("ky", 25);
    freq.put("une", 32);
    freq.put("Hah", 6);
    freq.put("õel", 20);
    freq.put("ugi", 19);
    freq.put("Hak", 9);
    freq.put("Hal", 4);
    freq.put("Han", 10);
    freq.put("mõn", 50);
    freq.put("rra", 34);
    freq.put("uga", 43);
    freq.put("rtn", 3);
    freq.put("rti", 13);
    freq.put("uge", 23);
    freq.put("hi ", 18);
    freq.put("rtt", 4);
    freq.put("oje", 6);
    freq.put("rts", 8);
    freq.put("oja", 11);
    freq.put("Har", 7);
    freq.put("baa", 3);
    freq.put("rty", 3);
    freq.put("ões", 15);
    freq.put("ati", 54);
    freq.put("Jy", 3);
    freq.put("Ju", 27);
    freq.put("ies", 11);
    freq.put("iet", 11);
    freq.put("opa", 11);
    freq.put("nce", 7);
    freq.put("Jl", 3);
    freq.put("aaj", 6);
    freq.put("iek", 3);
    freq.put("Jo", 16);
    freq.put("iel", 22);
    freq.put("ien", 11);
    freq.put("Je", 20);
    freq.put("Jf", 3);
    freq.put("sil", 49);
    freq.put("iee", 3);
    freq.put("Ja", 55);
    freq.put("ieg", 10);
    freq.put("rd ", 35);
    freq.put("hip", 3);
    freq.put("hir", 5);
    freq.put("his", 10);
    freq.put("hit", 20);
    freq.put("rt ", 34);
    freq.put("maa", 84);
    freq.put("aad", 95);
    freq.put("ose", 11);
    freq.put("hia", 4);
    freq.put("aaf", 3);
    freq.put("hig", 3);
    freq.put("hii", 8);
    freq.put("tLi", 3);
    freq.put("hik", 16);
    freq.put("hil", 21);
    freq.put("him", 5);
    freq.put("hin", 44);
    freq.put("elf", 4);
    freq.put("gij", 9);
    freq.put(" Põ", 5);
    freq.put("lli", 152);
    freq.put("aab", 60);
    freq.put(" Pü", 6);
    freq.put("stl", 17);
    freq.put("cra", 3);
    freq.put("uim", 9);
    freq.put(" Pä", 15);
    freq.put("ie ", 39);
    freq.put("dur", 5);
    freq.put("J ", 15);
    freq.put("cro", 3);
    freq.put(" Be", 13);
    freq.put("sev", 8);
    freq.put("seu", 5);
    freq.put("set", 33);
    freq.put(" Ba", 8);
    freq.put("ser", 13);
    freq.put("arv", 67);
    freq.put("sep", 14);
    freq.put(" Bl", 5);
    freq.put(" Bo", 8);
    freq.put(" Bi", 5);
    freq.put("sti", 260);
    freq.put(" Bu", 9);
    freq.put("ara", 67);
    freq.put("see", 200);
    freq.put("ik ", 134);
    freq.put("ard", 42);
    freq.put("seb", 10);
    freq.put("sea", 51);
    freq.put(" Br", 8);
    freq.put("seo", 4);
    freq.put("sen", 30);
    freq.put("sem", 38);
    freq.put("sel", 275);
    freq.put("sek", 58);
    freq.put("uu ", 89);
    freq.put("sei", 31);
    freq.put("aro", 23);
    freq.put("mo ", 12);
    freq.put("stu", 109);
    freq.put("Jõ", 5);
    freq.put("leg", 32);
    freq.put("al ", 233);
    freq.put("eCu", 3);
    freq.put("õsi", 7);
    freq.put("wor", 6);
    freq.put(" Y ", 6);
    freq.put(" P ", 16);
    freq.put("atr", 14);
    freq.put("use", 140);
    freq.put("dut", 5);
    freq.put("Jä", 13);
    freq.put("asz", 4);
    freq.put("ms ", 12);
    freq.put("DD ", 13);
    freq.put("Age", 3);
    freq.put("kö", 10);
    freq.put("iks", 143);
    freq.put("ikr", 6);
    freq.put("JU ", 5);
    freq.put("lek", 105);
    freq.put(" B ", 3);
    freq.put("iku", 131);
    freq.put("uuu", 93);
    freq.put("fW ", 3);
    freq.put("aar", 59);
    freq.put("uup", 4);
    freq.put("uus", 60);
    freq.put("uur", 77);
    freq.put("uum", 10);
    freq.put("uul", 66);
    freq.put("ika", 98);
    freq.put("uun", 6);
    freq.put("uuh", 3);
    freq.put("ike", 95);
    freq.put("se ", 317);
    freq.put("ikk", 138);
    freq.put("uud", 54);
    freq.put("iki", 25);
    freq.put("ikh", 3);
    freq.put("iko", 37);
    freq.put("ikn", 3);
    freq.put("ot ", 32);
    freq.put("ikl", 13);
    freq.put(" Ps", 3);
    freq.put(" Pr", 18);
    freq.put("c", 747);
    freq.put("aKo", 3);
    freq.put(" Pu", 8);
    freq.put("omb", 5);
    freq.put("rof", 4);
    freq.put("õtk", 3);
    freq.put(" Pa", 51);
    freq.put("gei", 9);
    freq.put("SK ", 3);
    freq.put(" Pe", 17);
    freq.put(" Pi", 19);
    freq.put(" Po", 25);
    freq.put(" Pl", 5);
    freq.put("pS", 3);
    freq.put("rog", 3);
    freq.put("sky", 9);
    freq.put("pX", 3);
    freq.put("nr ", 4);
    freq.put("lex", 4);
    freq.put("rae", 28);
    freq.put("lbu", 4);
    freq.put("tgh", 3);
    freq.put("wel", 3);
    freq.put("tgl", 5);
    freq.put(" t ", 389);
    freq.put("pr", 109);
    freq.put("ps", 89);
    freq.put("pp", 141);
    freq.put("duk", 9);
    freq.put("pv", 3);
    freq.put("dum", 11);
    freq.put("pt", 19);
    freq.put("Fak", 5);
    freq.put("ydr", 3);
    freq.put("dub", 19);
    freq.put("py", 4);
    freq.put("dud", 35);
    freq.put("ei ", 407);
    freq.put("dug", 12);
    freq.put("pb", 3);
    freq.put("raK", 3);
    freq.put("pa", 452);
    freq.put("HE ", 3);
    freq.put("nau", 7);
    freq.put("xan", 3);
    freq.put("pe", 348);
    freq.put("pj", 3);
    freq.put("pk", 5);
    freq.put("ph", 10);
    freq.put("pi", 328);
    freq.put("pn", 3);
    freq.put("po", 293);
    freq.put("pl", 73);
    freq.put("pm", 15);
    freq.put("dul", 8);
    freq.put("nri", 8);
    freq.put("Ema", 5);
    freq.put("oms", 5);
    freq.put(" € ", 5);
    freq.put(" tw", 36);
    freq.put(" tv", 3);
    freq.put(" tu", 331);
    freq.put(" tt", 4);
    freq.put(" ts", 23);
    freq.put(" tr", 69);
    freq.put("rõd", 3);
    freq.put("N", 224);
    freq.put(" to", 126);
    freq.put("gan", 18);
    freq.put("gam", 42);
    freq.put(" tl", 4);
    freq.put(" tk", 3);
    freq.put("gaj", 5);
    freq.put(" ti", 31);
    freq.put(" th", 26);
    freq.put(" tg", 5);
    freq.put(" te", 517);
    freq.put("gad", 25);
    freq.put("gab", 8);
    freq.put(" ta", 328);
    freq.put("lba", 3);
    freq.put("fuu", 3);
    freq.put("Ole", 24);
    freq.put("du ", 44);
    freq.put("Oli", 4);
    freq.put("mli", 3);
    freq.put("gem", 35);
    freq.put(" fü", 4);
    freq.put("ove", 20);
    freq.put("p ", 461);
    freq.put("uua", 5);
    freq.put(" fä", 9);
    freq.put("õe", 41);
    freq.put("lbe", 3);
    freq.put("bor", 4);
    freq.put("ras", 72);
    freq.put("ami", 82);
    freq.put("umu", 3);
    freq.put("öid", 3);
    freq.put("riv", 9);
    freq.put("öik", 5);
    freq.put("gel", 49);
    freq.put("voo", 11);
    freq.put("voi", 7);
    freq.put("rip", 8);
    freq.put("vot", 4);
    freq.put("Tim", 4);
    freq.put("ril", 41);
    freq.put("rim", 45);
    freq.put("rij", 3);
    freq.put("Tii", 5);
    freq.put("öit", 3);
    freq.put("rii", 52);
    freq.put("rig", 16);
    freq.put("rid", 22);
    freq.put("rie", 15);
    freq.put("rib", 3);
    freq.put("ric", 5);
    freq.put("ria", 19);
    freq.put("leP", 3);
    freq.put("üht", 11);
    freq.put("pö", 7);
    freq.put("q ", 10);
    freq.put("onv", 3);
    freq.put("põ", 31);
    freq.put("riS", 5);
    freq.put("kn ", 6);
    freq.put("mos", 6);
    freq.put("ühe", 28);
    freq.put("aga", 317);
    freq.put("üha", 10);
    freq.put("äe ", 9);
    freq.put("raa", 58);
    freq.put("ssi", 86);
    freq.put("ühj", 5);
    freq.put("ühi", 10);
    freq.put("Vär", 3);
    freq.put("vo ", 3);
    freq.put("sär", 4);
    freq.put("lie", 7);
    freq.put(" tö", 54);
    freq.put(" tõ", 52);
    freq.put("Ilu", 8);
    freq.put("Väg", 7);
    freq.put("Väi", 5);
    freq.put("ok ", 19);
    freq.put(" tä", 193);
    freq.put("ri ", 97);
    freq.put("rõõ", 7);
    freq.put("Kon", 5);
    freq.put("möt", 3);
    freq.put(" fr", 8);
    freq.put(" fu", 17);
    freq.put("lib", 6);
    freq.put("õu", 76);
    freq.put("õt", 101);
    freq.put("ew ", 3);
    freq.put("äet", 3);
    freq.put("Sol", 3);
    freq.put("Soo", 9);
    freq.put("kna", 7);
    freq.put(" fa", 25);
    freq.put("EI ", 8);
    freq.put("ppe", 13);
    freq.put(" fb", 9);
    freq.put(" fe", 13);
    freq.put("õh", 70);
    freq.put("äen", 4);
    freq.put("lim", 23);
    freq.put("y", 354);
    freq.put("õd", 12);
    freq.put("äeb", 5);
    freq.put(" fm", 4);
    freq.put(" fl", 3);
    freq.put(" fo", 17);
    freq.put("äeg", 3);
    freq.put("hju", 15);
    freq.put("tim", 30);
    freq.put("lda", 43);
    freq.put("sla", 18);
    freq.put("lde", 19);
    freq.put("ldk", 3);
    freq.put("ldi", 60);
    freq.put("mao", 3);
    freq.put("bi ", 44);
    freq.put("O ", 31);
    freq.put("hje", 4);
    freq.put("hja", 10);
    freq.put("ldu", 22);
    freq.put("pöi", 4);
    freq.put("lik", 120);
    freq.put("oo ", 43);
    freq.put("uvõ", 6);
    freq.put("lit", 42);
    freq.put("cut", 3);
    freq.put("rgu", 6);
    freq.put("amu", 16);
    freq.put("olo", 21);
    freq.put("rga", 17);
    freq.put("rge", 12);
    freq.put("str", 24);
    freq.put("aps", 18);
    freq.put("ohh", 22);
    freq.put("rgi", 33);
    freq.put("öb", 3);
    freq.put("cul", 4);
    freq.put("ee ", 235);
    freq.put("Kin", 9);
    freq.put("bä", 4);
    freq.put("On", 11);
    freq.put("Om", 9);
    freq.put("Ol", 32);
    freq.put("Ok", 7);
    freq.put("bik", 7);
    freq.put("Oi", 5);
    freq.put("Oh", 9);
    freq.put("Of", 10);
    freq.put("Oe", 4);
    freq.put("bie", 4);
    freq.put("bib", 3);
    freq.put("Ain", 5);
    freq.put("ohk", 24);
    freq.put("apt", 3);
    freq.put("bü", 3);
    freq.put("Aid", 3);
    freq.put("Ou", 5);
    freq.put("Ot", 9);
    freq.put("Os", 16);
    freq.put("Or", 4);
    freq.put("Dir", 4);
    freq.put("Op", 3);
    freq.put("d", 4236);
    freq.put("ljo", 6);
    freq.put("lja", 108);
    freq.put("eet", 32);
    freq.put("ppi", 52);
    freq.put("eev", 8);
    freq.put("lje", 14);
    freq.put("eep", 8);
    freq.put("ees", 117);
    freq.put("eer", 54);
    freq.put("eem", 55);
    freq.put("õtt", 30);
    freq.put("tuu", 36);
    freq.put("Vee", 4);
    freq.put("eeh", 3);
    freq.put("eek", 22);
    freq.put("päh", 9);
    freq.put("eee", 64);
    freq.put("usS", 3);
    freq.put("eeg", 55);
    freq.put("elt", 111);
    freq.put("lju", 65);
    freq.put("eeb", 39);
    freq.put("kut", 45);
    freq.put("b ", 610);
    freq.put("iju", 9);
    freq.put("mpe", 4);
    freq.put("ru ", 49);
    freq.put("mmm", 15);
    freq.put("vne", 3);
    freq.put("upä", 12);
    freq.put("ohe", 26);
    freq.put("ija", 20);
    freq.put("ld ", 17);
    freq.put("agi", 115);
    freq.put("küp", 3);
    freq.put("tuj", 14);
    freq.put("oe ", 15);
    freq.put("nsa", 6);
    freq.put("ijo", 3);
    freq.put("gil", 27);
    freq.put("pet", 32);
    freq.put("aM ", 3);
    freq.put("liq", 3);
    freq.put("küs", 35);
    freq.put("Kun", 4);
    freq.put("rio", 6);
    freq.put("pes", 8);
    freq.put("pel", 14);
    freq.put("pen", 5);
    freq.put("peo", 12);
    freq.put("pek", 5);
    freq.put("ped", 7);
    freq.put("pee", 7);
    freq.put("ape", 10);
    freq.put(" Lõ", 9);
    freq.put("id ", 359);
    freq.put("ütl", 38);
    freq.put("bd", 3);
    freq.put("be", 124);
    freq.put("sjo", 4);
    freq.put("run", 6);
    freq.put("ba", 211);
    freq.put("bb", 7);
    freq.put("bc", 4);
    freq.put("bl", 50);
    freq.put("bm", 7);
    freq.put("lgi", 14);
    freq.put("bo", 47);
    freq.put("nis", 60);
    freq.put("bi", 152);
    freq.put("bj", 4);
    freq.put("bk", 3);
    freq.put("bt", 3);
    freq.put("bu", 70);
    freq.put("oeh", 5);
    freq.put("oen", 9);
    freq.put("br", 49);
    freq.put("bs", 18);
    freq.put("üs", 63);
    freq.put("rus", 25);
    freq.put("rup", 3);
    freq.put("by", 5);
    freq.put("rut", 13);
    freq.put(" vä", 225);
    freq.put("Roh", 3);
    freq.put("ahl", 3);
    freq.put("Pis", 3);
    freq.put("Rol", 5);
    freq.put("ä", 1949);
    freq.put("idy", 3);
    freq.put("aMa", 3);
    freq.put("Rob", 5);
    freq.put("idu", 59);
    freq.put("idr", 8);
    freq.put("ids", 10);
    freq.put("öh", 8);
    freq.put("Rog", 3);
    freq.put("bU", 3);
    freq.put("idl", 6);
    freq.put("yle", 6);
    freq.put("bQ", 3);
    freq.put("bR", 4);
    freq.put("idi", 38);
    freq.put("söö", 39);
    freq.put("lah", 45);
    freq.put("ide", 112);
    freq.put("pe ", 18);
    freq.put("bZ", 3);
    freq.put("ida", 281);
    freq.put("ahm", 4);
    freq.put("Vil", 4);
    freq.put("Tü", 3);
    freq.put("Eli", 8);
    freq.put("ME ", 8);
    freq.put("Ell", 5);
    freq.put("lää", 5);
    freq.put("Tö", 6);
    freq.put(" uu", 70);
    freq.put(" C ", 4);
    freq.put("Tõ", 5);
    freq.put(" up", 9);
    freq.put("nse", 3);
    freq.put("Ele", 5);
    freq.put(" um", 3);
    freq.put(" un", 35);
    freq.put(" uh", 7);
    freq.put(" ui", 3);
    freq.put(" uk", 8);
    freq.put("nsp", 3);
    freq.put("Tä", 38);
    freq.put(" ug", 3);
    freq.put("pms", 6);
    freq.put("Isa", 3);
    freq.put("mbl", 6);
    freq.put("Elu", 3);
    freq.put("ut ", 55);
    freq.put("ixi", 4);
    freq.put("mka", 3);
    freq.put(" Õh", 5);
    freq.put("usu", 22);
    freq.put(" sp", 16);
    freq.put("upp", 15);
    freq.put("kus", 82);
    freq.put("Ise", 4);
    freq.put("fer", 7);
    freq.put("u ", 1097);
    freq.put("Fe", 9);
    freq.put("lir", 3);
    freq.put(" Ch", 8);
    freq.put(" Co", 5);
    freq.put("Mir", 3);
    freq.put("ök", 19);
    freq.put("uT", 9);
    freq.put(" Ca", 4);
    freq.put("uS", 3);
    freq.put(" Ce", 3);
    freq.put("uM", 3);
    freq.put("tru", 8);
    freq.put("uO", 6);
    freq.put("lfi", 7);
    freq.put("sda", 3);
    freq.put("uE", 4);
    freq.put("uD", 4);
    freq.put("deg", 30);
    freq.put("öma", 6);
    freq.put(" u ", 12);
    freq.put("mse", 16);
    freq.put("doo", 4);
    freq.put("õrd", 3);
    freq.put("cia", 11);
    freq.put("uta", 123);
    freq.put("uy", 3);
    freq.put("ux", 3);
    freq.put("ute", 22);
    freq.put("uu", 571);
    freq.put("ut", 431);
    freq.put("ix ", 3);
    freq.put("uv", 83);
    freq.put("utn", 3);
    freq.put("up", 84);
    freq.put("us", 1001);
    freq.put("Tõe", 3);
    freq.put("um", 218);
    freq.put("ul", 747);
    freq.put("uo", 12);
    freq.put("un", 376);
    freq.put("ui", 386);
    freq.put("uh", 140);
    freq.put("uk", 203);
    freq.put("uj", 42);
    freq.put("ue", 62);
    freq.put("ud", 518);
    freq.put("ug", 120);
    freq.put("z", 118);
    freq.put("ua", 76);
    freq.put("uc", 24);
    freq.put("ub", 221);
    freq.put("tun", 113);
    freq.put("läb", 36);
    freq.put("cin", 3);
    freq.put("PM ", 3);
    freq.put("Tw", 13);
    freq.put("läi", 14);
    freq.put("Tu", 38);
    freq.put("Tr", 21);
    freq.put("Ts", 9);
    freq.put("naM", 4);
    freq.put("To", 19);
    freq.put("läp", 7);
    freq.put("dre", 13);
    freq.put("Th", 12);
    freq.put("Ti", 10);
    freq.put("Tg", 4);
    freq.put("Te", 43);
    freq.put("Ta", 81);
    freq.put("nab", 17);
    freq.put("A ", 94);
    freq.put(" gu", 9);
    freq.put(" gr", 9);
    freq.put("tic", 4);
    freq.put("nes", 29);
    freq.put("nae", 18);
    freq.put("air", 3);
    freq.put("tae", 8);
    freq.put("nah", 19);
    freq.put("nai", 21);
    freq.put("nan", 24);
    freq.put("nal", 46);
    freq.put("ag ", 8);
    freq.put("nar", 8);
    freq.put("nas", 89);
    freq.put("nap", 10);
    freq.put("gre", 7);
    freq.put("nav", 10);
    freq.put("Viv", 4);
    freq.put("nat", 36);
    freq.put("gra", 11);
    freq.put("aam", 44);
    freq.put(" go", 17);
    freq.put("lga", 24);
    freq.put("Maj", 4);
    freq.put("len", 131);
    freq.put("Mal", 4);
    freq.put(" gi", 4);
    freq.put("lä ", 4);
    freq.put("häs", 16);
    freq.put("pau", 5);
    freq.put("aen", 3);
    freq.put(" ch", 17);
    freq.put("ooh", 3);
    freq.put("aht", 38);
    freq.put("õmu", 4);
    freq.put("lis", 167);
    freq.put("ooj", 7);
    freq.put("T ", 153);
    freq.put("Aa", 11);
    freq.put("agn", 4);
    freq.put("äti", 7);
    freq.put("😡", 5);
    freq.put("Ae", 3);
    freq.put("Ad", 3);
    freq.put("Ag", 37);
    freq.put("ätl", 3);
    freq.put("Ai", 17);
    freq.put("Ah", 10);
    freq.put("Ak", 4);
    freq.put("Am", 11);
    freq.put("Al", 34);
    freq.put("äte", 3);
    freq.put("An", 35);
    freq.put("ruk", 15);
    freq.put("Ap", 10);
    freq.put("As", 7);
    freq.put("Ar", 10);
    freq.put("Au", 9);
    freq.put(" g ", 3);
    freq.put("Av", 10);
    freq.put("äts", 7);
    freq.put("agu", 61);
    freq.put("aye", 3);
    freq.put("agr", 5);
    freq.put("ätu", 3);
    freq.put("ätt", 25);
    freq.put(" b", 162);
    freq.put(" c", 456);
    freq.put("gu", 269);
    freq.put(" a", 995);
    freq.put(" f", 155);
    freq.put(" g", 92);
    freq.put(" d", 123);
    freq.put(" e", 1332);
    freq.put(" j", 1276);
    freq.put(" k", 2476);
    freq.put(" h", 1095);
    freq.put(" i", 533);
    freq.put(" n", 1068);
    freq.put(" o", 1331);
    freq.put(" l", 886);
    freq.put(" m", 2025);
    freq.put(" r", 364);

    init3();
  }
  private static void init3() {
    
    freq.put(" s", 2068);
    freq.put(" p", 1415);
    freq.put(" q", 11);
    freq.put(" v", 1301);
    freq.put(" w", 70);
    freq.put(" t", 2243);
    freq.put(" u", 185);
    freq.put(" z", 18);
    freq.put("gn", 11);
    freq.put(" x", 49);
    freq.put(" y", 47);
    freq.put("gk", 3);
    freq.put("gi", 574);
    freq.put("gh", 19);
    freq.put(" B", 88);
    freq.put(" C", 40);
    freq.put(" A", 223);
    freq.put(" F", 90);
    freq.put(" G", 48);
    freq.put(" D", 581);
    freq.put(" E", 236);
    freq.put(" J", 177);
    freq.put(" K", 436);
    freq.put(" H", 194);
    freq.put(" I", 112);
    freq.put(" N", 200);
    freq.put(" O", 176);
    freq.put(" L", 192);
    freq.put(" M", 444);
    freq.put(" R", 239);
    freq.put(" S", 335);
    freq.put(" P", 251);
    freq.put(" Q", 8);
    freq.put(" V", 217);
    freq.put(" W", 34);
    freq.put(" T", 350);
    freq.put(" U", 44);
    freq.put(" Z", 20);
    freq.put("mil", 41);
    freq.put(" X", 36);
    freq.put(" Y", 28);
    freq.put("Nor", 3);
    freq.put("hüp", 6);
    freq.put("vli", 3);
    freq.put("ch ", 9);
    freq.put("ed ", 295);
    freq.put("tak", 69);
    freq.put("Kri", 16);
    freq.put("end", 138);
    freq.put("vle", 3);
    freq.put("kI", 4);
    freq.put("P", 300);
    freq.put("önu", 5);
    freq.put("loo", 55);
    freq.put(" Wh", 3);
    freq.put("g ", 166);
    freq.put("mäe", 4);
    freq.put(" ?", 12);
    freq.put("oas", 12);
    freq.put("tri", 40);
    freq.put("evi", 24);
    freq.put("mp ", 4);
    freq.put("tro", 13);
    freq.put("tra", 42);
    freq.put("eva", 171);
    freq.put("ekr", 6);
    freq.put("us ", 321);
    freq.put("tre", 29);
    freq.put("eve", 11);
    freq.put("rua", 3);
    freq.put("päi", 6);
    freq.put("ebi", 17);
    freq.put("esi", 92);
    freq.put("Spo", 5);
    freq.put("akn", 6);
    freq.put("ddd", 3);
    freq.put("chr", 5);
    freq.put("evu", 4);
    freq.put("rro", 8);
    freq.put("uel", 4);
    freq.put("zn", 3);
    freq.put("zo", 4);
    freq.put("Rei", 8);
    freq.put("zi", 3);
    freq.put(" ä", 168);
    freq.put("egl", 5);
    freq.put("ze", 6);
    freq.put("rre", 7);
    freq.put("gü", 3);
    freq.put(" õp", 41);
    freq.put("za", 11);
    freq.put("zb", 3);
    freq.put("sö", 41);
    freq.put(" õl", 6);
    freq.put("odi", 31);
    freq.put("Blo", 3);
    freq.put("eLi", 4);
    freq.put(" ö", 55);
    freq.put("zy", 5);
    freq.put("zz", 10);
    freq.put(" õ", 140);
    freq.put("zu", 3);
    freq.put("hk ", 20);
    freq.put("ary", 5);
    freq.put("ieC", 3);
    freq.put(" ü", 240);
    freq.put("uer", 4);
    freq.put("zL", 3);
    freq.put("F ", 13);
    freq.put("Ah ", 5);
    freq.put("vb ", 7);
    freq.put("zH", 3);
    freq.put(" Ä", 7);
    freq.put("zK", 3);
    freq.put("lku", 7);
    freq.put(" Ö", 7);
    freq.put("ugu", 28);
    freq.put(" Õ", 16);
    freq.put("rac", 3);
    freq.put(" Ü", 32);
    freq.put("can", 4);
    freq.put("lea", 5);
    freq.put("leb", 64);
    freq.put("ES ", 8);
    freq.put("led", 73);
    freq.put("lee", 35);
    freq.put("lef", 15);
    freq.put("obe", 9);
    freq.put("hkr", 3);
    freq.put("lei", 36);
    freq.put("lej", 5);
    freq.put("cal", 6);
    freq.put("z ", 24);
    freq.put("ue ", 20);
    freq.put(" €", 5);
    freq.put("hku", 13);
    freq.put("usn", 4);
    freq.put("ler", 11);
    freq.put("les", 112);
    freq.put("let", 54);
    freq.put("lev", 47);
    freq.put("od ", 21);
    freq.put("ley", 3);
    freq.put("hka", 16);
    freq.put("stv", 4);
    freq.put("hke", 38);
    freq.put("rdu", 11);
    freq.put("eni", 27);
    freq.put("ula", 29);
    freq.put("rds", 9);
    freq.put("häl", 3);
    freq.put("Lii", 31);
    freq.put("puk", 19);
    freq.put("ulg", 11);
    freq.put("rde", 15);
    freq.put("rda", 33);
    freq.put("kud", 29);
    freq.put("wl", 5);
    freq.put("ule", 155);
    freq.put("rdi", 33);
    freq.put("cti", 7);
    freq.put("rdj", 4);
    freq.put("wif", 3);
    freq.put("mea", 3);
    freq.put(" Di", 10);
    freq.put("tau", 4);
    freq.put("apr", 4);
    freq.put("win", 6);
    freq.put(" De", 13);
    freq.put(" Dd", 3);
    freq.put("Mik", 18);
    freq.put(" Da", 13);
    freq.put("apu", 9);
    freq.put("ün", 33);
    freq.put("wit", 30);
    freq.put("wis", 3);
    freq.put("ii ", 283);
    freq.put("Ven", 12);
    freq.put(" Dv", 3);
    freq.put("apa", 30);
    freq.put("tüü", 7);
    freq.put("usf", 3);
    freq.put("Fr", 6);
    freq.put("fee", 6);
    freq.put("Fu", 8);
    freq.put("usa", 81);
    freq.put("äse", 3);
    freq.put("usm", 10);
    freq.put("usl", 8);
    freq.put("usk", 31);
    freq.put("Hui", 4);
    freq.put("usi", 62);
    freq.put("fei", 6);
    freq.put("Fa", 15);
    freq.put("Huv", 3);
    freq.put("ust", 224);
    freq.put(" võ", 194);
    freq.put(" R ", 8);
    freq.put(" vö", 6);
    freq.put("Fi", 9);
    freq.put("lne", 17);
    freq.put("Vii", 9);
    freq.put("Fm", 3);
    freq.put("Fo", 13);
    freq.put("iit", 53);
    freq.put("iiv", 21);
    freq.put("pfe", 4);
    freq.put("iip", 5);
    freq.put("iis", 284);
    freq.put("iir", 45);
    freq.put(" D ", 210);
    freq.put("iie", 16);
    freq.put("iid", 20);
    freq.put("iig", 46);
    freq.put("iia", 19);
    freq.put("iib", 6);
    freq.put("iim", 49);
    freq.put("iil", 15);
    freq.put("ap ", 3);
    freq.put("iin", 114);
    freq.put("iii", 140);
    freq.put("iik", 21);
    freq.put("Käi", 8);
    freq.put(" Ru", 6);
    freq.put("ace", 12);
    freq.put("fe ", 5);
    freq.put("f", 411);
    freq.put("mua", 3);
    freq.put("oh", 198);
    freq.put(" Re", 25);
    freq.put("Lõp", 4);
    freq.put("obo", 3);
    freq.put(" Ra", 29);
    freq.put("Mai", 3);
    freq.put("Mul", 19);
    freq.put(" Ro", 31);
    freq.put(" Ri", 15);
    freq.put(" c ", 4);
    freq.put("taa", 34);
    freq.put("tat", 55);
    freq.put("põl", 10);
    freq.put("tav", 57);
    freq.put("ach", 6);
    freq.put("tap", 16);
    freq.put("tar", 40);
    freq.put("tüd", 10);
    freq.put("tük", 3);
    freq.put("aco", 3);
    freq.put("raj", 4);
    freq.put("tüh", 8);
    freq.put("põn", 5);
    freq.put("tüm", 3);
    freq.put("tad", 53);
    freq.put("tür", 5);
    freq.put("tag", 56);
    freq.put("eno", 4);
    freq.put("tab", 70);
    freq.put("tüt", 3);
    freq.put("tal", 56);
    freq.put("põh", 7);
    freq.put("tan", 100);
    freq.put("tao", 6);
    freq.put("tah", 109);
    freq.put("tai", 4);
    freq.put("taj", 30);
    freq.put("uOl", 3);
    freq.put(" va", 398);
    freq.put("sir", 6);
    freq.put(" vb", 8);
    freq.put(" ve", 162);
    freq.put("siv", 3);
    freq.put("Yo", 9);
    freq.put("sit", 53);
    freq.put("Ya", 6);
    freq.put("On ", 3);
    freq.put("ppp", 7);
    freq.put(" vm", 8);
    freq.put(" vo", 25);
    freq.put("Mit", 6);
    freq.put("sib", 11);
    freq.put(" vs", 5);
    freq.put("kri", 20);
    freq.put("sig", 22);
    freq.put("apä", 26);
    freq.put("sie", 13);
    freq.put("sid", 90);
    freq.put("sik", 55);
    freq.put("sij", 5);
    freq.put("sii", 267);
    freq.put("Yr", 3);
    freq.put("sio", 27);
    freq.put("sin", 237);
    freq.put("sim", 89);
    freq.put(" jh", 4);
    freq.put("adu", 21);
    freq.put("sis", 57);
    freq.put("vut", 18);
    freq.put("ox", 5);
    freq.put("and", 129);
    freq.put("Q", 26);
    freq.put("sip", 10);
    freq.put("ta ", 286);
    freq.put("men", 50);
    freq.put("Eks", 6);
    freq.put("afi", 4);
    freq.put(" v ", 21);
    freq.put("dd ", 3);
    freq.put("rai", 15);
    freq.put("siu", 11);
    freq.put("ksi", 74);
    freq.put("Y ", 12);
    freq.put("Pr ", 3);
    freq.put("Moo", 7);
    freq.put("hum", 3);
    freq.put("enr", 8);
    freq.put(" vi", 223);
    freq.put("si ", 208);
    freq.put("mei", 57);
    freq.put("ato", 10);
    freq.put("döö", 4);
    freq.put("lF", 3);
    freq.put("da ", 473);
    freq.put("Aas", 4);
    freq.put("lK", 3);
    freq.put("Min", 20);
    freq.put("lgu", 24);
    freq.put("lR", 3);
    freq.put("lS", 4);
    freq.put("jne", 9);
    freq.put("dw", 3);
    freq.put("vmv", 3);
    freq.put("lz ", 5);
    freq.put("lZ", 3);
    freq.put("vms", 6);
    freq.put("lf", 14);
    freq.put("lg", 108);
    freq.put("ld", 185);
    freq.put("le", 1662);
    freq.put("lb", 25);
    freq.put("tsk", 6);
    freq.put("tsh", 3);
    freq.put("la", 764);
    freq.put("ln", 61);
    freq.put("lo", 203);
    freq.put("ll", 878);
    freq.put("lm", 199);
    freq.put("lj", 197);
    freq.put("lk", 64);
    freq.put("lh", 3);
    freq.put("li", 1091);
    freq.put("lv", 51);
    freq.put("lw", 4);
    freq.put("lt", 403);
    freq.put("lu", 398);
    freq.put("lr", 9);
    freq.put("ls", 59);
    freq.put("lp", 10);
    freq.put("öi", 15);
    freq.put("bin", 9);
    freq.put("tst", 4);
    freq.put(" h ", 17);
    freq.put("lz", 7);
    freq.put("tss", 4);
    freq.put("ly", 34);
    freq.put("dad", 29);
    freq.put("na ", 330);
    freq.put("daf", 3);
    freq.put("äga", 57);
    freq.put("daa", 8);
    freq.put("dab", 21);
    freq.put("äge", 13);
    freq.put("dal", 57);
    freq.put("Car", 6);
    freq.put("dan", 40);
    freq.put("ägi", 37);
    freq.put("dai", 3);
    freq.put("daj", 8);
    freq.put("dak", 20);
    freq.put("dat", 41);
    freq.put("dav", 22);
    freq.put("KS ", 10);
    freq.put("dar", 3);
    freq.put("ägu", 9);
    freq.put("bar", 7);
    freq.put("niu", 4);
    freq.put("day", 7);
    freq.put("ogl", 4);
    freq.put("Sak", 5);
    freq.put("Sai", 12);
    freq.put("Pra", 4);
    freq.put("San", 9);
    freq.put("l ", 1010);
    freq.put("Sal", 4);
    freq.put("nfo", 8);
    freq.put("Saa", 7);
    freq.put("ssa", 25);
    freq.put(" hu", 68);
    freq.put(" ht", 375);
    freq.put(" hk", 3);
    freq.put("Riv", 3);
    freq.put(" hi", 60);
    freq.put(" hh", 5);
    freq.put(" ho", 129);
    freq.put(" hm", 3);
    freq.put("Sar", 4);
    freq.put(" ha", 211);
    freq.put("Sap", 3);
    freq.put("Sav", 3);
    freq.put(" he", 160);
    freq.put(" üh", 40);
    freq.put("äka", 4);
    freq.put("oun", 10);
    freq.put("oul", 4);
    freq.put("hlv", 3);
    freq.put("► ", 4);
    freq.put("bim", 4);
    freq.put("üd ", 113);
    freq.put("Ok ", 3);
    freq.put("kva", 4);
    freq.put("wes", 4);
    freq.put("ous", 7);
    freq.put("our", 8);
    freq.put(" Är", 4);
    freq.put("hla", 4);
    freq.put("aob", 5);
    freq.put("üra", 3);
    freq.put("lä", 175);
    freq.put("ksu", 26);
    freq.put("res", 46);
    freq.put("Tur", 3);
    freq.put("mav", 6);
    freq.put("Tut", 8);
    freq.put("Tuu", 4);
    freq.put("ret", 25);
    freq.put("mis", 304);
    freq.put("lö", 10);
    freq.put("rek", 11);
    freq.put("lõ", 86);
    freq.put("Tul", 8);
    freq.put("wer", 3);
    freq.put("Tun", 4);
    freq.put("rem", 53);
    freq.put("reb", 6);
    freq.put("rec", 7);
    freq.put("lü", 13);
    freq.put("rea", 24);
    freq.put("ref", 5);
    freq.put("reg", 6);
    freq.put("red", 22);
    freq.put("emp", 7);
    freq.put("üds", 3);
    freq.put("üdr", 10);
    freq.put("aol", 3);
    freq.put("kst", 7);
    freq.put("päe", 144);
    freq.put("cre", 3);
    freq.put("eck", 4);
    freq.put("eht", 29);
    freq.put("ouT", 4);
    freq.put("üri", 18);
    freq.put("üda", 9);
    freq.put("ect", 12);
    freq.put("que", 5);
    freq.put("onn", 13);
    freq.put("x", 131);
    freq.put("Põh", 3);
    freq.put("üdi", 3);
    freq.put(" ◄ ", 4);
    freq.put("bal", 7);
    freq.put("ask", 32);
    freq.put("lts", 13);
    freq.put("läk", 25);
    freq.put("Ma ", 51);
    freq.put("g", 2449);
    freq.put(" hü", 8);
    freq.put("möl", 3);
    freq.put("uha", 14);
    freq.put("loe", 12);
    freq.put("put", 11);
    freq.put(" hõ", 3);
    freq.put("bak", 4);
    freq.put("aot", 13);
    freq.put("IF ", 5);
    freq.put("lte", 16);
    freq.put("lok", 7);
    freq.put("mae", 4);
    freq.put("re ", 66);
    freq.put("fot", 11);
    freq.put("lto", 3);
    freq.put("ü", 893);
    freq.put(" hä", 39);
    freq.put("Fot", 9);
    freq.put("K ", 37);
    freq.put("mag", 71);
    freq.put("nki", 4);
    freq.put("bii", 10);
    freq.put("rs ", 6);
    freq.put("arr", 14);
    freq.put("iht", 50);
    freq.put("ihu", 6);
    freq.put("ihk", 13);
    freq.put("ud ", 332);
    freq.put("ihi", 5);
    freq.put("iho", 4);
    freq.put("ihl", 3);
    freq.put("ihm", 12);
    freq.put("ses", 91);
    freq.put("iha", 14);
    freq.put("mak", 39);
    freq.put("ihe", 6);
    freq.put("lor", 8);
    freq.put("Täi", 6);
    freq.put("maj", 20);
    freq.put(" öe", 16);
    freq.put("Tän", 29);
    freq.put("los", 6);
    freq.put("usj", 4);
    freq.put(" Sp", 8);
    freq.put("ahh", 18);
    freq.put("nda", 105);
    freq.put(" St", 20);
    freq.put(" Su", 24);
    freq.put(" Sk", 3);
    freq.put(" Sh", 10);
    freq.put(" Si", 47);
    freq.put(" So", 22);
    freq.put(" Sm", 4);
    freq.put(" Sa", 53);
    freq.put("tps", 3);
    freq.put("Kil", 4);
    freq.put(" Se", 50);
    freq.put("õbu", 8);
    freq.put("Ka", 93);
    freq.put("rso", 5);
    freq.put("Kf", 4);
    freq.put("Ke", 50);
    freq.put("udu", 23);
    freq.put("Kk", 6);
    freq.put("rse", 10);
    freq.put("Ki", 37);
    freq.put("eha", 49);
    freq.put("Ko", 50);
    freq.put("Kn", 4);
    freq.put("nnu", 44);
    freq.put("Kl", 11);
    freq.put("Kr", 29);
    freq.put("R", 285);
    freq.put("ogi", 21);
    freq.put("Kv", 3);
    freq.put("Ku", 73);
    freq.put("eho", 4);
    freq.put("rst", 30);
    freq.put("udk", 8);
    freq.put("udi", 22);
    freq.put("udn", 6);
    freq.put("rss", 3);
    freq.put("nHe", 5);
    freq.put("seg", 56);
    freq.put("?😡", 4);
    freq.put("ben", 3);
    freq.put("bel", 10);
    freq.put("sok", 7);
    freq.put("arb", 5);
    freq.put("bed", 6);
    freq.put("ehk", 20);
    freq.put("oth", 3);
    freq.put("sed", 209);
    freq.put("rum", 8);
    freq.put("MU ", 3);
    freq.put("ber", 40);
    freq.put("bes", 9);
    freq.put(" S ", 20);
    freq.put("hav", 5);
    freq.put("bet", 9);
    freq.put("are", 61);
    freq.put("rm ", 17);
    freq.put("Pat", 3);
    freq.put("arg", 17);
    freq.put(" E ", 6);
    freq.put("aa ", 134);
    freq.put("Paa", 4);
    freq.put("Kap", 3);
    freq.put("ari", 115);
    freq.put("Pak", 6);
    freq.put("Pal", 16);
    freq.put("arj", 16);
    freq.put("uhk", 16);
    freq.put("she", 4);
    freq.put("mii", 8);
    freq.put("sk", 221);
    freq.put("mik", 106);
    freq.put("ark", 26);
    freq.put("ur ", 26);
    freq.put("ck ", 14);
    freq.put("min", 379);
    freq.put("mia", 6);
    freq.put("arl", 14);
    freq.put(" Sö", 4);
    freq.put("mid", 101);
    freq.put("mig", 7);
    freq.put("arm", 49);
    freq.put("eaa", 18);
    freq.put("Õht", 4);
    freq.put("arn", 7);
    freq.put(" öö", 34);
    freq.put("ER ", 5);
    freq.put("kto", 3);
    freq.put("mir", 6);
    freq.put("uhh", 4);
    freq.put("mit", 68);
    freq.put("asl", 5);
    freq.put(" El", 27);
    freq.put(" Em", 8);
    freq.put(" En", 10);
    freq.put(" Eh", 5);
    freq.put(" Ei", 39);
    freq.put(" Ek", 7);
    freq.put(" Ed", 3);
    freq.put(" Ee", 36);
    freq.put("otk", 3);
    freq.put(" Eg", 6);
    freq.put("Mam", 4);
    freq.put("ow ", 16);
    freq.put("eag", 7);
    freq.put("Kõ", 16);
    freq.put("st ", 636);
    freq.put(" Et", 4);
    freq.put(" Eu", 4);
    freq.put(" Ev", 5);
    freq.put("Püh", 5);
    freq.put("ny ", 7);
    freq.put(" Er", 12);
    freq.put(" Es", 5);
    freq.put("urd", 19);
    freq.put("ure", 58);
    freq.put("urg", 7);
    freq.put("ong", 22);
    freq.put("ura", 42);
    freq.put("urb", 10);
    freq.put("õpi", 10);
    freq.put("url", 5);
    freq.put("urm", 8);
    freq.put("urn", 8);
    freq.put("õpe", 26);
    freq.put("cki", 9);
    freq.put("Töp", 4);
    freq.put("urj", 8);
    freq.put("urk", 17);
    freq.put("urt", 7);
    freq.put("uru", 14);
    freq.put("urv", 9);
    freq.put("cks", 4);
    freq.put("ürg", 3);
    freq.put("hn", 13);
    freq.put("õpu", 23);
    freq.put("õpr", 5);
    freq.put("õps", 5);
    freq.put("õpp", 39);
    freq.put("Dem", 4);
    freq.put("ond", 25);
    freq.put("mg ", 16);
    freq.put("rja", 32);
    freq.put("Põ", 5);
    freq.put("dba", 3);
    freq.put("NI ", 3);
    freq.put("juu", 67);
    freq.put("au ", 12);
    freq.put("Pü", 6);
    freq.put("KA ", 8);
    freq.put("ohj", 3);
    freq.put("Pä", 16);
    freq.put("ksB", 4);
    freq.put("Kah", 5);
    freq.put("eda", 172);
    freq.put("edt", 3);
    freq.put("ear", 11);
    freq.put("nga", 17);
    freq.put(" w ", 6);
    freq.put("iri", 30);
    freq.put("jav", 3);
    freq.put(" ir", 3);
    freq.put(" is", 96);
    freq.put(" it", 9);
    freq.put("jas", 37);
    freq.put("jap", 5);
    freq.put("eat", 26);
    freq.put("kse", 79);
    freq.put(" ii", 8);
    freq.put("jal", 74);
    freq.put("jam", 24);
    freq.put("jaj", 6);
    freq.put("jak", 35);
    freq.put(" in", 78);
    freq.put("jai", 5);
    freq.put("ksm", 8);
    freq.put("jag", 25);
    freq.put("jad", 34);
    freq.put("eav", 11);
    freq.put(" id", 11);
    freq.put(" ie", 3);
    freq.put("ksk", 14);
    freq.put(" ig", 60);
    freq.put("Pla", 3);
    freq.put("tui", 6);
    freq.put("dma", 8);
    freq.put("no ", 46);
    freq.put("mub", 5);
    freq.put("tsC", 5);
    freq.put("Võt", 7);
    freq.put("ush", 6);
    freq.put("mul", 135);
    freq.put("nit", 17);
    freq.put("lsi", 9);
    freq.put("TA ", 9);
    freq.put("aes", 7);
    freq.put(" we", 8);
    freq.put("qu", 8);
    freq.put(" wa", 11);
    freq.put("h", 3114);
    freq.put("ars", 30);
    freq.put("äva", 4);
    freq.put("tti", 18);
    freq.put(" wh", 12);
    freq.put(" wi", 11);
    freq.put("sha", 10);
    freq.put(" wt", 5);
    freq.put("ks ", 606);
    freq.put("aeg", 84);
    freq.put("jää", 45);
    freq.put(" i ", 24);
    freq.put("shi", 20);
    freq.put("aem", 4);
    freq.put("ael", 12);
    freq.put("ja ", 702);
    freq.put("ž", 6);
    freq.put("Pr", 24);
    freq.put("Ps", 4);
    freq.put("Pp", 3);
    freq.put("eba", 18);
    freq.put("Pu", 17);
    freq.put("ebl", 3);
    freq.put("öl ", 5);
    freq.put("ebo", 15);
    freq.put("we", 39);
    freq.put("ke ", 119);
    freq.put("jo ", 4);
    freq.put("Pa", 55);
    freq.put("OP ", 3);
    freq.put("Kal", 9);
    freq.put("ebr", 3);
    freq.put("Pe", 24);
    freq.put("ede", 40);
    freq.put("wM", 3);
    freq.put("Ph", 3);
    freq.put("Pi", 20);
    freq.put("Po", 26);
    freq.put("Pl", 6);
    freq.put("ikv", 3);
    freq.put("lup", 7);
    freq.put("dla", 13);
    freq.put("lus", 111);
    freq.put("sp ", 4);
    freq.put("ome", 33);
    freq.put("dle", 13);
    freq.put("rgm", 19);
    freq.put("dli", 4);
    freq.put("kk ", 25);
    freq.put("lua", 3);
    freq.put("et ", 344);
    freq.put("sot", 4);
    freq.put("lue", 3);
    freq.put("uut", 41);
    freq.put("õ", 1092);
    freq.put("uro", 20);
    freq.put("Jaa", 8);
    freq.put("lul", 14);
    freq.put("lum", 19);
    freq.put("oht", 33);
    freq.put("ass", 79);
    freq.put("ken", 27);
    freq.put("kem", 33);
    freq.put("kel", 85);
    freq.put("kek", 6);
    freq.put("jou", 9);
    freq.put("kei", 11);
    freq.put("keh", 4);
    freq.put("omo", 6);
    freq.put("kee", 78);
    freq.put("ked", 15);
    freq.put("öle", 12);
    freq.put("ähm", 4);
    freq.put("rtk", 4);
    freq.put("Kar", 19);
    freq.put("P ", 43);
    freq.put("tsm", 7);
    freq.put("wi", 49);
    freq.put("joh", 4);
    freq.put("kev", 7);
    freq.put("ket", 17);
    freq.put("kes", 104);
    freq.put("ker", 50);
    freq.put("jon", 11);
    freq.put("joo", 47);
    freq.put("etr", 5);
    freq.put("ets", 22);
    freq.put("bee", 9);
    freq.put("ett", 56);
    freq.put("etu", 52);
    freq.put("one", 24);
    freq.put("llu", 49);
    freq.put("tsi", 133);
    freq.put("üks", 47);
    freq.put("lu ", 79);
    freq.put("tla", 18);
    freq.put("wt", 5);
    freq.put("ükk", 7);
    freq.put("tle", 68);
    freq.put("üki", 5);
    freq.put("etk", 19);
    freq.put("eth", 9);
    freq.put("eti", 39);
    freq.put("eto", 3);
    freq.put(" il", 88);
    freq.put("ck", 46);
    freq.put("ci", 25);
    freq.put("ch", 50);
    freq.put("co", 395);
    freq.put("cn", 4);
    freq.put("cm", 5);
    freq.put("cl", 10);
    freq.put("cc", 9);
    freq.put("käe", 16);
    freq.put("ca", 38);
    freq.put("bis", 21);
    freq.put("Hey", 5);
    freq.put("ce", 41);
    freq.put("edi", 17);
    freq.put("uue", 27);
    freq.put("cy", 6);
    freq.put("oho", 7);
    freq.put("ucc", 5);
    freq.put("Hea", 11);
    freq.put("vö", 6);
    freq.put("Hel", 11);
    freq.put("cr", 15);
    freq.put("Hen", 7);
    freq.put("tsa", 96);
    freq.put("hm ", 8);
    freq.put("Hei", 14);
    freq.put("cu", 10);
    freq.put("ct", 17);
    freq.put("Jub", 7);
    freq.put("dja", 11);
    freq.put("adl", 7);
    freq.put("öb ", 3);
    freq.put("uig", 8);
    freq.put("bbi", 3);
    freq.put("cB", 3);
    freq.put("ys ", 3);
    freq.put("lep", 20);
    freq.put("cF", 3);
    freq.put("Jum", 5);
    freq.put(" õh", 33);
    freq.put("sBa", 4);
    freq.put("Hoo", 5);
    freq.put("cR", 3);
    freq.put("mu ", 67);
    freq.put("Hol", 4);
    freq.put("rb ", 6);
    freq.put("wtf", 5);
    freq.put("oti", 18);
    freq.put("Hom", 19);
    freq.put("otl", 3);
    freq.put("oto", 27);
    freq.put("am", 582);
    freq.put("c ", 26);
    freq.put("ons", 11);
    freq.put("ild", 27);
    freq.put("oha", 19);
    freq.put("nTa", 3);
    freq.put("IK ", 6);
    freq.put("hmh", 3);
    freq.put("õge", 3);
    freq.put("hme", 7);
    freq.put("uin", 8);
    freq.put("tsu", 64);
    freq.put("hma", 13);
    freq.put("unu", 21);
    freq.put("And", 6);
    freq.put("süü", 19);
    freq.put("näk", 5);
    freq.put(" Tü", 3);
    freq.put("möö", 13);
    freq.put("näo", 9);
    freq.put("ndr", 28);
    freq.put("äh", 161);
    freq.put(" Tö", 6);
    freq.put(" Tõ", 5);
    freq.put("näe", 11);
    freq.put("uis", 3);
    freq.put("näg", 17);
    freq.put("Ant", 4);
    freq.put("rpo", 3);
    freq.put("rbi", 3);
    freq.put("aya", 6);
    freq.put("au", 218);
    freq.put(" Tä", 38);
    freq.put("ya ", 6);
    freq.put("rba", 4);
    freq.put("yst", 3);
    freq.put("bir", 4);
    freq.put("va", 927);
    freq.put("vb", 10);
    freq.put(" Fr", 3);
    freq.put(" Fu", 8);
    freq.put("ve", 331);
    freq.put("ži", 3);
    freq.put("vi", 420);
    freq.put("vj", 3);
    freq.put("vk", 3);
    freq.put("vl", 6);
    freq.put("vm", 11);
    freq.put("vn", 4);
    freq.put("vo", 42);
    freq.put(" Fa", 12);
    freq.put("pip", 6);
    freq.put("vs", 11);
    freq.put(" Fe", 8);
    freq.put("vu", 58);
    freq.put("vv", 5);
    freq.put("ohu", 14);
    freq.put(" Fi", 6);
    freq.put("ave", 13);
    freq.put("You", 5);
    freq.put("ärv", 25);
    freq.put("ann", 116);
    freq.put("pir", 12);
    freq.put(" Fo", 11);
    freq.put("io ", 15);
    freq.put("of ", 3);
    freq.put("vC", 3);
    freq.put("tas", 105);
    freq.put("RA ", 4);
    freq.put("zy ", 3);
    freq.put("vO", 3);
    freq.put("unc", 4);
    freq.put("Esi", 4);
    freq.put("dam", 42);
    freq.put("vX", 3);
    freq.put("äie", 22);
    freq.put("aia", 10);
    freq.put(" T ", 16);
    freq.put("v ", 202);
    freq.put("äg", 116);
    freq.put("pho", 6);
    freq.put("ay ", 9);
    freq.put(" õi", 16);
    freq.put("iou", 4);
    freq.put("ios", 4);
    freq.put("ioo", 26);
    freq.put(" F ", 3);
    freq.put("app", 30);
    freq.put("iol", 5);
    freq.put("müü", 11);
    freq.put("uni", 49);
    freq.put(" ►", 4);
    freq.put("av ", 56);
    freq.put("GA ", 7);
    freq.put("Sa ", 8);
    freq.put("unk", 9);
    freq.put("off", 6);
    freq.put("oov", 31);
    freq.put("Sha", 3);
    freq.put(" Tw", 10);
    freq.put(" Tu", 32);
    freq.put("ofi", 4);
    freq.put(" Ts", 8);
    freq.put(" Tr", 21);
    freq.put("AN ", 5);
    freq.put("õlg", 6);
    freq.put(" To", 18);
    freq.put("jau", 3);
    freq.put("ske", 28);
    freq.put("unn", 57);
    freq.put(" Ti", 6);
    freq.put(" Th", 9);
    freq.put("R ", 35);
    freq.put(" Te", 42);
    freq.put("õle", 12);
    freq.put(" Ta", 73);
    freq.put("onu", 5);
    freq.put("nik", 25);
    freq.put("das", 79);
    freq.put("apo", 4);
    freq.put(" xD", 9);
    freq.put("Ei ", 32);
    freq.put("tch", 6);
    freq.put("nv ", 8);
    freq.put("Mag", 6);
    freq.put("üp ", 3);
    freq.put("sku", 29);
    freq.put("Be", 16);
    freq.put("gmi", 20);
    freq.put("tt ", 60);
    freq.put(" xo", 3);
    freq.put("Ba", 13);
    freq.put("wee", 19);
    freq.put("skr", 3);
    freq.put("Bl", 5);
    freq.put("Bo", 15);
    freq.put("Oh ", 6);
    freq.put("Bi", 7);
    freq.put("mh ", 3);
    freq.put("Bk", 3);
    freq.put(" mõ", 120);
    freq.put("Bu", 11);
    freq.put("ger", 8);
    freq.put("ade", 77);
    freq.put("ska", 48);
    freq.put("nor", 34);
    freq.put("Br", 12);
    freq.put("ada", 141);
    freq.put("skm", 4);
    freq.put("Fac", 4);
    freq.put("sko", 23);
    freq.put("ski", 50);
    freq.put("skk", 3);
    freq.put("adi", 44);
    freq.put("amb", 16);
    freq.put("Ü ", 4);
    freq.put("oer", 6);
    freq.put("inK", 3);
    freq.put(" mö", 20);
    freq.put("oob", 9);
    freq.put("nve", 5);
    freq.put("mhh", 3);
    freq.put("T", 397);
    freq.put("nva", 4);
    freq.put("ode", 15);
    freq.put("nol", 5);
    freq.put("HK ", 3);
    freq.put("Eil", 5);
    freq.put("nvi", 3);
    freq.put("ame", 82);
    freq.put("B ", 14);
    freq.put("Sam", 4);
    freq.put("car", 8);
    freq.put(" jõ", 33);
    freq.put(" x ", 16);
    freq.put("krõ", 3);
    freq.put("No ", 19);
    freq.put("sk ", 8);
    freq.put("ad ", 401);
    freq.put("Sau", 3);
    freq.put(" jä", 152);
    freq.put("Las", 3);
    freq.put("TI ", 4);
    freq.put("Oot", 8);
    freq.put("Lep", 3);
    freq.put("nja", 4);
    freq.put("Bos", 4);
    freq.put("jan", 29);
    freq.put("Pri", 5);
    freq.put("Suh", 8);
    freq.put("Suv", 3);
    freq.put("Suu", 3);
    freq.put("Mak", 4);
    freq.put("vse", 3);
    freq.put("äh ", 6);
    freq.put("Kur", 12);
    freq.put("U ", 30);
    freq.put("tum", 22);
    freq.put("adö", 4);
    freq.put("esu", 11);
    freq.put("est", 338);
    freq.put("ess", 51);
    freq.put("jao", 9);
    freq.put("esp", 4);
    freq.put("nd ", 158);
    freq.put("oly", 3);
    freq.put("kur", 43);
    freq.put("lk ", 17);
    freq.put("iä", 3);
    freq.put("lse", 24);
    freq.put("tma", 23);
    freq.put("ese", 61);
    freq.put("tme", 8);
    freq.put("esa", 4);
    freq.put("Jõu", 5);
    freq.put("eso", 7);
    freq.put("tmi", 11);
    freq.put("esm", 11);
    freq.put("ga ", 606);
    freq.put("esk", 27);
    freq.put(" j ", 7);
    freq.put("?", 21);
    freq.put("esh", 4);
    freq.put("rit", 95);
    freq.put("Lis", 5);
    freq.put("Uu", 13);
    freq.put("õv", 14);
    freq.put("lle", 293);
    freq.put("dce", 3);
    freq.put("Us", 3);
    freq.put("vs ", 4);
    freq.put("Ul", 4);
    freq.put("Un", 6);
    freq.put("Kok", 3);
    freq.put("Uk", 3);
    freq.put("Ud", 3);
    freq.put("Ug", 3);
    freq.put("LL ", 3);
    freq.put("ndi", 80);
    freq.put("ndj", 4);
    freq.put("ndm", 11);
    freq.put("dun", 10);
    freq.put("ndo", 11);
    freq.put(" ju", 311);
    freq.put("oLi", 4);
    freq.put("pu", 122);
    freq.put("nde", 40);
    freq.put("krt", 5);
    freq.put("kru", 3);
    freq.put(" jo", 58);
    freq.put(" jn", 7);
    freq.put("kro", 3);
    freq.put("es ", 317);
    freq.put(" je", 29);
    freq.put("nds", 8);
    freq.put("kra", 18);
    freq.put(" ja", 662);
    freq.put("EE ", 7);
    freq.put("krd", 3);
    freq.put("kre", 12);
    freq.put("sül", 4);
    freq.put("sün", 20);
    freq.put("own", 3);
    freq.put("öd", 47);
    freq.put("öe", 16);
    freq.put("Twe", 3);
    freq.put("süd", 8);
    freq.put("ea ", 142);
    freq.put("Twi", 8);
    freq.put("öl", 24);
    freq.put("öm", 8);
    freq.put("ön", 16);
    freq.put("öp", 16);
    freq.put("ör", 8);
    freq.put("ös", 15);
    freq.put("öt", 15);
    freq.put("ngt", 3);
    freq.put("h ", 234);
    freq.put("oek", 3);
    freq.put("süs", 4);
    freq.put("vaj", 27);
    freq.put("vak", 18);
    freq.put("vah", 57);
    freq.put("vai", 54);
    freq.put("van", 66);
    freq.put("val", 176);
    freq.put("vam", 10);
    freq.put("vab", 24);
    freq.put("kõv", 10);
    freq.put("vaa", 81);
    freq.put("Ame", 5);
    freq.put("vag", 5);
    freq.put("vad", 137);
    freq.put("vae", 7);
    freq.put("nii", 245);
    freq.put("kõn", 13);
    freq.put("kõl", 6);
    freq.put("kõi", 110);
    freq.put("kõh", 8);
    freq.put("var", 50);
    freq.put("pf", 9);
    freq.put("vap", 12);
    freq.put("vat", 31);
    freq.put("ö ", 28);
    freq.put("eah", 3);
    freq.put("eak", 44);
    freq.put("hy", 7);
    freq.put("eam", 9);
    freq.put("eal", 127);
    freq.put("ean", 23);
    freq.put("hr", 18);
    freq.put("hs", 3);
    freq.put("hp", 6);
    freq.put("eab", 28);
    freq.put("hv", 39);
    freq.put("ead", 67);
    freq.put("ht", 659);
    freq.put("hu", 153);
    freq.put("hj", 31);
    freq.put("hk", 99);
    freq.put("hh", 140);
    freq.put("hi", 168);
    freq.put("Õ", 16);
    freq.put("ho", 197);
    freq.put("hl", 10);
    freq.put("hm", 37);
    freq.put("hb", 3);
    freq.put("hc", 3);
    freq.put("eas", 21);
    freq.put("ha", 636);
    freq.put("hg", 3);
    freq.put("bud", 4);
    freq.put("he", 540);
    freq.put("hZ", 3);
    freq.put("Tei", 7);
    freq.put("dus", 95);
    freq.put("dme", 3);
    freq.put("aah", 11);
    freq.put("avi", 24);
    freq.put("Tea", 5);
    freq.put("va ", 71);
    freq.put("j", 2120);
    freq.put("Tee", 10);
    freq.put("Teg", 5);
    freq.put("lve", 26);
    freq.put("lva", 9);
    freq.put("duv", 3);
    freq.put("Ter", 8);
    freq.put("lvi", 7);
    freq.put("ID ", 12);
    freq.put("pih", 7);
    freq.put("pii", 22);
    freq.put("pik", 36);
    freq.put("pil", 68);
    freq.put("OO ", 3);
    freq.put("pin", 18);
    freq.put("int", 18);
    freq.put("inu", 172);
    freq.put("inv", 6);
    freq.put("lõp", 52);
    freq.put("pid", 55);
    freq.put("Kev", 5);
    freq.put("ins", 17);
    freq.put("inl", 15);
    freq.put("inm", 6);
    freq.put("inn", 142);
    freq.put("ino", 13);
    freq.put("ub ", 73);
    freq.put("ini", 81);
    freq.put("öö", 179);
    freq.put("ink", 18);
    freq.put("ind", 120);
    freq.put("ine", 230);
    freq.put("inf", 8);
    freq.put("ing", 208);
    freq.put("pit", 14);
    freq.put("ina", 122);
    freq.put("inb", 3);
    freq.put("eo ", 6);
    freq.put("NE ", 6);
    freq.put("inT", 3);
    freq.put(" Uu", 10);
    freq.put("oal", 3);
    freq.put("inP", 3);
    freq.put("oaj", 3);
    freq.put(" Us", 3);
    freq.put(" Un", 4);
    freq.put("hpo", 3);
    freq.put("iSe", 3);
    freq.put("dim", 8);
    freq.put(" Uk", 3);
    freq.put("out", 6);
    freq.put("gau", 3);
    freq.put("tam", 109);
    freq.put("gat", 20);
    freq.put("DA ", 9);
    freq.put("Pro", 9);
    freq.put("hü", 8);
    freq.put("ile", 125);
    freq.put("pi ", 33);
    freq.put("gas", 59);
    freq.put("hö", 4);
    freq.put("hõ", 4);
    freq.put("ube", 23);
    freq.put("Kel", 10);
    freq.put("U", 73);
    freq.put("uba", 99);
    freq.put("ubl", 9);
    freq.put("my ", 5);
    freq.put("akt", 17);
    freq.put("gap", 7);
    freq.put("in ", 368);
    freq.put("ubi", 10);
    freq.put("hä", 42);
    freq.put("aat", 99);
    freq.put("hna", 7);
    freq.put("sää", 3);
    freq.put("Kei", 4);
    freq.put("oa ", 4);
    freq.put("eok", 3);
    freq.put("Co", 7);
    freq.put("big", 5);
    freq.put("eon", 6);
    freq.put("oel", 3);
    freq.put("jab", 10);
    freq.put("eos", 7);
    freq.put("blu", 5);
    freq.put("eop", 4);
    freq.put("eow", 5);
    freq.put("Üh", 4);
    freq.put("eot", 3);
    freq.put("gak", 6);
    freq.put("jär", 47);
    freq.put(" U ", 4);
    freq.put("rep", 6);
    freq.put("att", 24);
  }
  
}

