package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class FI {
  private static final String name = "fi";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public FI() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 217980;
    n_words[1] = 250697;
    n_words[2] = 213036;

    freq.put("Jää", 5);
    freq.put(" yö", 34);
    freq.put("HL ", 9);
    freq.put("Jän", 6);
    freq.put("Jät", 4);
    freq.put("Jär", 5);
    freq.put(" yh", 126);
    freq.put(" yk", 57);
    freq.put(" yl", 106);
    freq.put(" ym", 28);
    freq.put(" yo", 8);
    freq.put("k", 11343);
    freq.put(" yd", 7);
    freq.put(" ye", 5);
    freq.put(" yr", 31);
    freq.put(" ys", 14);
    freq.put("Lä", 23);
    freq.put("Lö", 7);
    freq.put("lma", 159);
    freq.put("äla", 10);
    freq.put("äle", 3);
    freq.put("älk", 46);
    freq.put("älj", 6);
    freq.put("äli", 55);
    freq.put("äll", 147);
    freq.put("ält", 46);
    freq.put("äly", 13);
    freq.put("von", 23);
    freq.put("öil", 3);
    freq.put("Päi", 22);
    freq.put("äl ", 5);
    freq.put("Le", 43);
    freq.put("La", 94);
    freq.put("Lo", 37);
    freq.put("Li", 83);
    freq.put("Lu", 71);
    freq.put("Ly", 8);
    freq.put("hob", 3);
    freq.put("hoa", 3);
    freq.put("hon", 40);
    freq.put("hoo", 6);
    freq.put("hol", 12);
    freq.put("hom", 20);
    freq.put("hoj", 7);
    freq.put("hok", 5);
    freq.put("hoi", 39);
    freq.put("how", 4);
    freq.put("hot", 20);
    freq.put("hou", 10);
    freq.put("hor", 7);
    freq.put("hos", 13);
    freq.put("hop", 7);
    freq.put("A", 415);
    freq.put("L ", 40);
    freq.put("Ö", 5);
    freq.put("Pää", 40);
    freq.put("ho ", 20);
    freq.put(" V ", 5);
    freq.put("fir", 8);
    freq.put("fis", 3);
    freq.put("Hir", 5);
    freq.put("uop", 19);
    freq.put("Hiu", 3);
    freq.put("fit", 3);
    freq.put("uot", 147);
    freq.put("rä", 161);
    freq.put("fic", 4);
    freq.put("Hie", 5);
    freq.put("fie", 3);
    freq.put("uok", 50);
    freq.put("uoj", 14);
    freq.put("fii", 16);
    freq.put("fin", 17);
    freq.put("uon", 74);
    freq.put("fil", 9);
    freq.put("uol", 135);
    freq.put(" Va", 133);
    freq.put(" Ve", 56);
    freq.put("au ", 7);
    freq.put(" Vi", 100);
    freq.put(" Vo", 48);
    freq.put(" Vu", 19);
    freq.put(" Vy", 4);
    freq.put("fi ", 26);
    freq.put("uo ", 27);
    freq.put("rP", 3);
    freq.put("rt", 282);
    freq.put("ru", 189);
    freq.put("rv", 189);
    freq.put("rp", 41);
    freq.put("rr", 130);
    freq.put("rs", 147);
    freq.put("Uut", 10);
    freq.put("ry", 72);
    freq.put("Uus", 27);
    freq.put("rd", 51);
    freq.put("re", 405);
    freq.put("rf", 6);
    freq.put("rg", 33);
    freq.put("ra", 844);
    freq.put("rb", 10);
    freq.put("rc", 10);
    freq.put("rl", 21);
    freq.put("rm", 150);
    freq.put("rn", 48);
    freq.put("ro", 388);
    freq.put("rh", 103);
    freq.put("ri", 1248);
    freq.put("sma", 18);
    freq.put("rk", 359);
    freq.put(" Vä", 43);
    freq.put("ate", 242);
    freq.put("iak", 25);
    freq.put("ata", 156);
    freq.put("ato", 55);
    freq.put("atk", 131);
    freq.put("ath", 5);
    freq.put("ati", 86);
    freq.put("att", 263);
    freq.put("atu", 69);
    freq.put("atr", 5);
    freq.put("ats", 93);
    freq.put("ds ", 3);
    freq.put("aty", 7);
    freq.put("kfe", 3);
    freq.put("xis", 3);
    freq.put(" fy", 4);
    freq.put("Asu", 5);
    freq.put("Ase", 3);
    freq.put("Ask", 3);
    freq.put("Asi", 9);
    freq.put("nen", 574);
    freq.put("nel", 61);
    freq.put("nem", 33);
    freq.put("nej", 3);
    freq.put("lpy", 5);
    freq.put("nei", 25);
    freq.put("lpp", 12);
    freq.put("lpo", 9);
    freq.put("lpe", 6);
    freq.put("lpa", 27);
    freq.put("hus", 3);
    freq.put("bi ", 4);
    freq.put("Puu", 9);
    freq.put("X", 55);
    freq.put("Rit", 3);
    freq.put("Ris", 5);
    freq.put("Rin", 6);
    freq.put("Rik", 4);
    freq.put("Rih", 4);
    freq.put("Rie", 3);
    freq.put("PS ", 9);
    freq.put("iry", 3);
    freq.put("irr", 8);
    freq.put("irs", 5);
    freq.put("irt", 41);
    freq.put("iru", 10);
    freq.put("irv", 21);
    freq.put("irh", 5);
    freq.put("iri", 36);
    freq.put("irj", 122);
    freq.put("irk", 17);
    freq.put("irm", 10);
    freq.put("iro", 11);
    freq.put("ira", 71);
    freq.put("ire", 22);
    freq.put("Yle", 31);
    freq.put("Yll", 4);
    freq.put("Yli", 9);
    freq.put("ir ", 11);
    freq.put("and", 41);
    freq.put("änä", 114);
    freq.put("ann", 127);
    freq.put("anh", 35);
    freq.put("ää", 1445);
    freq.put("ant", 159);
    freq.put("bä", 5);
    freq.put("ä ", 3372);
    freq.put("ne ", 173);
    freq.put("äne", 39);
    freq.put("änd", 18);
    freq.put("äng", 4);
    freq.put("äno", 7);
    freq.put("änn", 58);
    freq.put("äni", 34);
    freq.put("änk", 7);
    freq.put("änt", 35);
    freq.put("änp", 5);
    freq.put("äns", 19);
    freq.put("äny", 33);
    freq.put("än", 1173);
    freq.put("äo", 16);
    freq.put("äl", 355);
    freq.put("äm", 231);
    freq.put("äj", 90);
    freq.put("äk", 269);
    freq.put("äh", 324);
    freq.put("äi", 491);
    freq.put("äd", 17);
    freq.put("äe", 35);
    freq.put("äa", 14);
    freq.put("äy", 281);
    freq.put("äv", 182);
    freq.put("ät", 403);
    freq.put("är", 341);
    freq.put("äs", 391);
    freq.put("äp", 64);
    freq.put("Nau", 3);
    freq.put("än ", 783);
    freq.put("kö ", 51);
    freq.put("hah", 24);
    freq.put("hai", 37);
    freq.put("haj", 5);
    freq.put("hak", 43);
    freq.put("hal", 108);
    freq.put("ham", 11);
    freq.put("han", 209);
    freq.put("haa", 64);
    freq.put("hae", 3);
    freq.put("Sää", 3);
    freq.put("umä", 7);
    freq.put("hap", 7);
    freq.put("har", 53);
    freq.put("has", 27);
    freq.put("hat", 33);
    freq.put("hau", 27);
    freq.put("hav", 7);
    freq.put("Vyö", 4);
    freq.put("kön", 10);
    freq.put("emu", 23);
    freq.put("köj", 6);
    freq.put("kök", 8);
    freq.put("köh", 11);
    freq.put("köi", 10);
    freq.put("köt", 3);
    freq.put("kös", 8);
    freq.put("köy", 3);
    freq.put("ha ", 50);
    freq.put("ola", 83);
    freq.put("old", 6);
    freq.put("ole", 222);
    freq.put("olf", 4);
    freq.put("oli", 286);
    freq.put("olj", 4);
    freq.put("olk", 16);
    freq.put("oll", 397);
    freq.put("olm", 36);
    freq.put("olo", 31);
    freq.put("olt", 24);
    freq.put("olu", 40);
    freq.put("olv", 3);
    freq.put("oly", 3);
    freq.put("umu", 11);
    freq.put("ump", 14);
    freq.put("for", 17);
    freq.put("ume", 23);
    freq.put("jöi", 8);
    freq.put("uma", 82);
    freq.put("umb", 4);
    freq.put("umm", 27);
    freq.put("umo", 10);
    freq.put("foo", 5);
    freq.put("umi", 72);
    freq.put("foi", 4);
    freq.put("ol ", 28);
    freq.put("emp", 61);
    freq.put("o", 12205);
    freq.put("fo ", 3);
    freq.put("um ", 7);
    freq.put("soa", 12);
    freq.put("Use", 3);
    freq.put("mbo", 8);
    freq.put("mbi", 3);
    freq.put("sof", 10);
    freq.put("soi", 71);
    freq.put("soh", 6);
    freq.put("sok", 5);
    freq.put("soj", 4);
    freq.put("Usk", 3);
    freq.put("sol", 18);
    freq.put("soo", 3);
    freq.put("son", 29);
    freq.put("sop", 20);
    freq.put("sos", 26);
    freq.put("sor", 14);
    freq.put("Fes", 3);
    freq.put("sov", 15);
    freq.put("äsy", 14);
    freq.put("äst", 98);
    freq.put("äss", 91);
    freq.put("äsn", 3);
    freq.put("äsl", 3);
    freq.put("äsm", 4);
    freq.put("äsk", 23);
    freq.put("äsi", 63);
    freq.put("äse", 33);
    freq.put("äsa", 5);
    freq.put("so ", 39);
    freq.put("Eev", 3);
    freq.put("mb ", 6);
    freq.put("äs ", 51);
    freq.put("Sis", 6);
    freq.put("Sir", 3);
    freq.put("Sip", 4);
    freq.put("Siv", 4);
    freq.put("Sit", 15);
    freq.put("Sie", 7);
    freq.put("kho", 4);
    freq.put("Sik", 3);
    freq.put("Sii", 20);
    freq.put("Sin", 9);
    freq.put("Sim", 5);
    freq.put("Sil", 12);
    freq.put("E", 404);
    freq.put("blo", 29);
    freq.put("osy", 3);
    freq.put("osp", 8);
    freq.put("oss", 143);
    freq.put("osu", 12);
    freq.put("ost", 246);
    freq.put("osi", 152);
    freq.put("osk", 106);
    freq.put("osm", 7);
    freq.put("oso", 25);
    freq.put("osa", 79);
    freq.put("ose", 42);
    freq.put("vet", 50);
    freq.put("ver", 157);
    freq.put("ves", 23);
    freq.put("vey", 18);
    freq.put("ved", 10);
    freq.put("vee", 15);
    freq.put("tko", 59);
    freq.put("ven", 32);
    freq.put("vel", 81);
    freq.put("vem", 5);
    freq.put("vek", 7);
    freq.put("vei", 22);
    freq.put("Mä", 28);
    freq.put("ydä", 23);
    freq.put("os ", 188);
    freq.put("iöt", 6);
    freq.put("Tav", 166);
    freq.put("Tap", 17);
    freq.put("Tar", 84);
    freq.put("Taa", 3);
    freq.put("Tab", 3);
    freq.put("Tal", 21);
    freq.put("Tam", 28);
    freq.put("Tan", 6);
    freq.put("Tai", 22);
    freq.put("Tak", 5);
    freq.put("M ", 39);
    freq.put("veä", 4);
    freq.put("Me", 90);
    freq.put("Ma", 184);
    freq.put("ydi", 7);
    freq.put("Mo", 42);
    freq.put("yde", 24);
    freq.put("Mi", 188);
    freq.put("Mu", 136);
    freq.put("O", 367);
    freq.put("ydy", 9);
    freq.put("My", 10);
    freq.put("ipa", 41);
    freq.put("ipe", 24);
    freq.put("ipi", 21);
    freq.put("ipo", 9);
    freq.put("ips", 6);
    freq.put("ipp", 52);
    freq.put("ipu", 33);
    freq.put("ipy", 4);
    freq.put("Oul", 16);
    freq.put("sö", 30);
    freq.put("Out", 3);
    freq.put("ipä", 34);
    freq.put("iö ", 9);
    freq.put("ST ", 5);
    freq.put("dyt", 9);
    freq.put("s ", 1410);
    freq.put("sy", 261);
    freq.put("ss", 1347);
    freq.put("sr", 29);
    freq.put("älä", 18);
    freq.put("sso", 16);
    freq.put("su", 631);
    freq.put("st", 2864);
    freq.put("sk", 581);
    freq.put("sj", 15);
    freq.put("si", 2582);
    freq.put("sh", 39);
    freq.put("so", 334);
    freq.put("sn", 18);
    freq.put("BA ", 3);
    freq.put("sl", 42);
    freq.put("sc", 6);
    freq.put("sb", 7);
    freq.put("sa", 1664);
    freq.put("sf", 8);
    freq.put("se", 1676);
    freq.put("sd", 7);
    freq.put("tty", 84);
    freq.put("KA ", 7);
    freq.put("ttp", 13);
    freq.put("ttu", 211);
    freq.put("tti", 409);
    freq.put("tto", 128);
    freq.put("tta", 683);
    freq.put("tte", 386);
    freq.put("ähn", 6);
    freq.put("jie", 14);
    freq.put("ähk", 16);
    freq.put("ähi", 18);
    freq.put("jia", 17);
    freq.put("jin", 6);
    freq.put("jil", 12);
    freq.put("ähd", 52);
    freq.put("jii", 4);
    freq.put("jit", 5);
    freq.put("dje", 3);
    freq.put("jis", 3);
    freq.put("ähy", 3);
    freq.put("äht", 60);
    freq.put("tt ", 14);
    freq.put("äh ", 6);
    freq.put("ttö", 48);
    freq.put("ttä", 456);
    freq.put("Jor", 5);
    freq.put("Jos", 27);
    freq.put("Jot", 6);
    freq.put("Jou", 14);
    freq.put("ähä", 100);
    freq.put("Job", 12);
    freq.put("Joe", 5);
    freq.put("Joh", 7);
    freq.put("Jok", 15);
    freq.put("bla", 3);
    freq.put("Jon", 4);
    freq.put("Joo", 19);
    freq.put("Huo", 22);
    freq.put("iun", 8);
    freq.put("Jo ", 3);
    freq.put("Huh", 7);
    freq.put("onj", 7);
    freq.put("onk", 79);
    freq.put("onh", 4);
    freq.put("oni", 79);
    freq.put("onn", 105);
    freq.put("ono", 25);
    freq.put("onl", 34);
    freq.put("onc", 3);
    freq.put("ona", 55);
    freq.put("onf", 4);
    freq.put("ong", 28);
    freq.put("ond", 7);
    freq.put("one", 140);
    freq.put("ony", 14);
    freq.put("ons", 29);
    freq.put("onp", 6);
    freq.put("onv", 4);
    freq.put("ont", 77);
    freq.put("onu", 20);
    freq.put("uku", 43);
    freq.put("uks", 201);
    freq.put("uko", 46);
    freq.put("ukl", 3);
    freq.put("ukk", 111);
    freq.put("uki", 44);
    freq.put("ukh", 5);
    freq.put("uke", 48);
    freq.put("uka", 158);
    freq.put("LÄ ", 3);
    freq.put("on ", 1092);
    freq.put("sak", 26);
    freq.put("sai", 79);
    freq.put("sah", 4);
    freq.put("san", 154);
    freq.put("sam", 61);
    freq.put("sal", 78);
    freq.put("saa", 229);
    freq.put("saf", 4);
    freq.put("sad", 6);
    freq.put("sas", 38);
    freq.put("sar", 39);
    freq.put("sap", 8);
    freq.put("sav", 7);
    freq.put("sau", 18);
    freq.put("sat", 51);
    freq.put("sa ", 815);
    freq.put("öön", 12);
    freq.put("Sky", 5);
    freq.put("up", 208);
    freq.put("vkl", 4);
    freq.put("uos", 75);
    freq.put("uor", 63);
    freq.put("rö", 14);
    freq.put("uov", 12);
    freq.put(" be", 11);
    freq.put(" ba", 21);
    freq.put(" bl", 28);
    freq.put(" bo", 7);
    freq.put(" bi", 14);
    freq.put(" bu", 17);
    freq.put("s", 14354);
    freq.put(" br", 9);
    freq.put("ivä", 171);
    freq.put("uod", 45);
    freq.put("Hih", 9);
    freq.put("Hii", 4);
    freq.put("uoh", 13);
    freq.put("uom", 280);
    freq.put("ive", 28);
    freq.put("iva", 202);
    freq.put("ivo", 52);
    freq.put("ivi", 95);
    freq.put("ivu", 44);
    freq.put("ivy", 5);
    freq.put("iv ", 3);
    freq.put("I", 241);
    freq.put(" gr", 11);
    freq.put("äjä", 69);
    freq.put(" go", 5);
    freq.put("Myy", 4);
    freq.put("NA ", 6);
    freq.put("uih", 14);
    freq.put("tva", 3);
    freq.put("äji", 11);
    freq.put("äjo", 6);
    freq.put("ez ", 4);
    freq.put("tv ", 10);
    freq.put("ace", 35);
    freq.put("ack", 17);
    freq.put("ach", 5);
    freq.put("aco", 6);
    freq.put("FL ", 3);
    freq.put("te ", 95);
    freq.put("Ni", 91);
    freq.put("No", 96);
    freq.put("ohä", 4);
    freq.put("Na", 55);
    freq.put("Ne", 47);
    freq.put("Ny", 48);
    freq.put("aö", 3);
    freq.put("Nu", 16);
    freq.put("het", 72);
    freq.put("heu", 6);
    freq.put("hev", 3);
    freq.put("hep", 4);
    freq.put("her", 45);
    freq.put("hes", 16);
    freq.put("hed", 3);
    freq.put("hee", 46);
    freq.put("hea", 8);
    freq.put("hel", 85);
    freq.put("hem", 28);
    freq.put("hen", 71);
    freq.put("heh", 4);
    freq.put("hei", 71);
    freq.put("N ", 56);
    freq.put("he ", 32);
    freq.put("aa", 2954);
    freq.put("ac", 72);
    freq.put("ab", 35);
    freq.put("ae", 38);
    freq.put("uid", 6);
    freq.put("ag", 34);
    freq.put("Älä", 6);
    freq.put("ai", 2125);
    freq.put("ah", 377);
    freq.put("uik", 9);
    freq.put("aj", 384);
    freq.put("Nä", 31);
    freq.put("al", 1821);
    freq.put("ao", 23);
    freq.put("an", 2944);
    freq.put("uip", 6);
    freq.put("as", 1421);
    freq.put("ar", 1277);
    freq.put("au", 682);
    freq.put("at", 1646);
    freq.put("aw", 6);
    freq.put("av", 638);
    freq.put("ay", 36);
    freq.put("ohu", 7);
    freq.put("ohv", 7);
    freq.put("a ", 7143);
    freq.put("oh ", 7);
    freq.put("at ", 512);
    freq.put("Fir", 3);
    freq.put("sco", 5);
    freq.put("mni", 3);
    freq.put(" a", 989);
    freq.put("Fin", 20);
    freq.put("Fil", 4);
    freq.put("smo", 3);
    freq.put("ty", 623);
    freq.put("tv", 15);
    freq.put("tw", 42);
    freq.put("tt", 2435);
    freq.put("tu", 1459);
    freq.put("tr", 120);
    freq.put("ts", 312);
    freq.put("tp", 16);
    freq.put("tn", 11);
    freq.put("to", 1323);
    freq.put("tl", 11);
    freq.put("Uun", 3);
    freq.put("tj", 5);
    freq.put("tk", 361);
    freq.put("th", 29);
    freq.put("ti", 1823);
    freq.put("te", 1987);
    freq.put("tb", 6);
    freq.put("tc", 8);
    freq.put("ta", 3811);
    freq.put("smi", 18);
    freq.put("Uud", 37);
    freq.put("sme", 9);
    freq.put("rj", 368);
    freq.put("t ", 2374);
    freq.put("kao", 3);
    freq.put("tö", 188);
    freq.put("tä", 2192);
    freq.put("vic", 5);
    freq.put("via", 75);
    freq.put("Aud", 8);
    freq.put("vid", 26);
    freq.put("vie", 161);
    freq.put("vij", 6);
    freq.put("vik", 29);
    freq.put("vih", 28);
    freq.put("vii", 178);
    freq.put("vin", 79);
    freq.put("vio", 23);
    freq.put("vil", 34);
    freq.put("vim", 7);
    freq.put("vir", 44);
    freq.put("vis", 68);
    freq.put("vip", 3);
    freq.put("viv", 5);
    freq.put("Aut", 8);
    freq.put("vit", 97);
    freq.put("kl ", 3);
    freq.put("öks", 16);
    freq.put("öku", 7);
    freq.put("öki", 5);
    freq.put("ökk", 19);
    freq.put("öko", 4);
    freq.put("öka", 7);
    freq.put("vi ", 34);
    freq.put("tā", 3);
    freq.put(" do", 10);
    freq.put("kla", 18);
    freq.put(" di", 14);
    freq.put(" de", 12);
    freq.put("klo", 41);
    freq.put("kli", 7);
    freq.put(" da", 8);
    freq.put("klu", 5);
    freq.put(" du", 8);
    freq.put("viä", 34);
    freq.put("r ", 121);
    freq.put(" re", 43);
    freq.put("ito", 107);
    freq.put("IP ", 3);
    freq.put("itk", 57);
    freq.put("iti", 66);
    freq.put("ite", 198);
    freq.put("ita", 216);
    freq.put("ity", 113);
    freq.put("itv", 3);
    freq.put("itt", 609);
    freq.put("itu", 116);
    freq.put("itr", 9);
    freq.put("its", 94);
    freq.put("IPh", 3);
    freq.put("it ", 334);
    freq.put(" A ", 15);
    freq.put("itä", 478);
    freq.put("fta", 5);
    freq.put("fti", 3);
    freq.put(" Aa", 23);
    freq.put(" Ab", 5);
    freq.put(" Ad", 6);
    freq.put(" Af", 4);
    freq.put(" Ag", 4);
    freq.put(" Ah", 14);
    freq.put(" Ai", 68);
    freq.put(" Aj", 4);
    freq.put(" Ak", 14);
    freq.put(" Al", 39);
    freq.put(" Am", 12);
    freq.put(" An", 61);
    freq.put(" Ap", 21);
    freq.put(" Ar", 34);
    freq.put(" As", 22);
    freq.put(" At", 5);
    freq.put(" Au", 24);
    freq.put(" Av", 12);
    freq.put(" Aw", 3);
    freq.put("ft ", 3);
    freq.put("w", 224);
    freq.put("le ", 530);
    freq.put("Fra", 3);
    freq.put("BB ", 4);
    freq.put("jes", 44);
    freq.put("aa ", 1026);
    freq.put("jet", 16);
    freq.put("Blu", 9);
    freq.put("jed", 6);
    freq.put("jee", 9);
    freq.put("jek", 13);
    freq.put("jen", 87);
    freq.put("äde", 9);
    freq.put("aad", 24);
    freq.put("aaf", 4);
    freq.put("aaa", 15);
    freq.put("aab", 3);
    freq.put("aam", 103);
    freq.put("aal", 180);
    freq.put("aan", 874);
    freq.put("aai", 44);
    freq.put("aah", 18);
    freq.put("aak", 68);
    freq.put("aaj", 65);
    freq.put("aat", 211);
    freq.put("je ", 7);
    freq.put("aav", 65);
    freq.put("aap", 51);
    freq.put("aas", 113);
    freq.put("aar", 67);
    freq.put("uet", 10);
    freq.put("ex ", 10);
    freq.put("tp ", 13);
    freq.put("ädä", 4);
    freq.put("Isr", 5);
    freq.put("M", 758);
    freq.put("Ist", 3);
    freq.put("Iso", 11);
    freq.put("Isl", 3);
    freq.put("ext", 3);
    freq.put("Hai", 3);
    freq.put("oju", 3);
    freq.put("Hal", 112);
    freq.put("Ham", 5);
    freq.put("Han", 3);
    freq.put("Haa", 6);
    freq.put("Hab", 3);
    freq.put("seä", 6);
    freq.put("oja", 100);
    freq.put("ojo", 4);
    freq.put("Har", 17);
    freq.put("Hau", 11);
    freq.put("cro", 5);
    freq.put("sev", 16);
    freq.put("seu", 60);
    freq.put("set", 177);
    freq.put("ses", 178);
    freq.put("ser", 9);
    freq.put("For", 15);
    freq.put("sep", 5);
    freq.put("see", 153);
    freq.put("sea", 12);
    freq.put("seo", 7);
    freq.put("sen", 436);
    freq.put("sem", 65);
    freq.put("sel", 157);
    freq.put("sek", 90);
    freq.put("sei", 48);
    freq.put("seh", 4);
    freq.put("ue ", 21);
    freq.put("se ", 245);
    freq.put("uil", 28);
    freq.put("tiu", 6);
    freq.put("ml ", 3);
    freq.put("tiv", 33);
    freq.put("iä ", 167);
    freq.put("nra", 11);
    freq.put("Ole", 26);
    freq.put("Oli", 28);
    freq.put("Olk", 7);
    freq.put("Oll", 7);
    freq.put("iän", 4);
    freq.put("iäl", 3);
    freq.put("Olt", 4);
    freq.put("iäk", 4);
    freq.put("iäi", 6);
    freq.put("ami", 113);
    freq.put("voa", 5);
    freq.put("öid", 7);
    freq.put("vol", 6);
    freq.put("öih", 11);
    freq.put("voo", 6);
    freq.put("öin", 11);
    freq.put("voi", 247);
    freq.put("voj", 6);
    freq.put("vok", 4);
    freq.put("vot", 26);
    freq.put("öis", 24);
    freq.put("vop", 3);
    freq.put("öit", 18);
    freq.put("vos", 22);
    freq.put("Näm", 3);
    freq.put("öi ", 5);
    freq.put("vo ", 15);
    freq.put("häv", 8);
    freq.put("kno", 13);
    freq.put(" fu", 9);
    freq.put("kni", 9);
    freq.put("Soi", 8);
    freq.put("Som", 7);
    freq.put("Sol", 3);
    freq.put("Son", 9);
    freq.put(" fa", 28);
    freq.put("Sos", 9);
    freq.put("Sor", 5);
    freq.put(" fe", 8);
    freq.put("Sot", 6);
    freq.put(" fi", 59);
    freq.put("iää", 12);
    freq.put(" fl", 5);
    freq.put(" fo", 12);
    freq.put("pör", 5);
    freq.put("ijö", 8);
    freq.put("pöy", 6);
    freq.put("O ", 29);
    freq.put("ijä", 51);
    freq.put(" Dj", 5);
    freq.put("sö ", 3);
    freq.put("Oo", 19);
    freq.put("On", 80);
    freq.put("Om", 5);
    freq.put("Ol", 76);
    freq.put("Ok", 12);
    freq.put("Oi", 24);
    freq.put("Oh", 10);
    freq.put("Od", 5);
    freq.put("pö ", 4);
    freq.put("Oy", 6);
    freq.put("Ov", 3);
    freq.put("Ou", 21);
    freq.put("Ot", 9);
    freq.put("Os", 27);
    freq.put("Or", 6);
    freq.put("Op", 12);
    freq.put("sön", 5);
    freq.put("söl", 3);
    freq.put("d", 1715);
    freq.put("söi", 6);
    freq.put("söp", 6);
    freq.put("b ", 17);
    freq.put("iju", 13);
    freq.put("ijy", 3);
    freq.put("ija", 85);
    freq.put("ijo", 36);
    freq.put("be", 40);
    freq.put("ba", 49);
    freq.put("bb", 10);
    freq.put("bl", 47);
    freq.put("bo", 67);
    freq.put("bi", 68);
    freq.put("bu", 35);
    freq.put("br", 20);
    freq.put("bs", 12);
    freq.put("by", 11);
    freq.put("Fu", 6);
    freq.put("söä", 3);
    freq.put("Ost", 15);
    freq.put("Fy", 3);
    freq.put("Osa", 8);
    freq.put("ME ", 4);
    freq.put(" C ", 8);
    freq.put("u ", 794);
    freq.put(" Ch", 17);
    freq.put(" Ci", 8);
    freq.put(" Co", 19);
    freq.put("dok", 13);
    freq.put("uT", 8);
    freq.put(" Ca", 20);
    freq.put("uM", 4);
    freq.put(" Cr", 4);
    freq.put(" Cu", 8);
    freq.put("cia", 3);
    freq.put("uu", 1180);
    freq.put("ut", 1404);
    freq.put("uv", 236);
    freq.put("cin", 4);
    freq.put("us", 1165);
    freq.put("ur", 490);
    freq.put("um", 261);
    freq.put("ul", 887);
    freq.put("uo", 958);
    freq.put("un", 1252);
    freq.put("ui", 430);
    freq.put("uh", 273);
    freq.put("uk", 666);
    freq.put("uj", 95);
    freq.put("ue", 106);
    freq.put("ud", 238);
    freq.put("ug", 12);
    freq.put("uf", 11);
    freq.put("ua", 271);
    freq.put("uc", 11);
    freq.put("ub", 38);
    freq.put("dos", 14);
    freq.put("ago", 4);
    freq.put("agn", 3);
    freq.put("agi", 5);
    freq.put("ciä", 3);
    freq.put("age", 9);
    freq.put("aga", 6);
    freq.put("agu", 3);
    freq.put("pul", 38);
    freq.put("Djo", 4);
    freq.put("tri", 24);
    freq.put("evi", 32);
    freq.put("tro", 24);
    freq.put("evo", 11);
    freq.put("tra", 27);
    freq.put("eva", 65);
    freq.put("tre", 35);
    freq.put("eve", 27);
    freq.put("evy", 32);
    freq.put("tru", 3);
    freq.put("uem", 3);
    freq.put("uel", 5);
    freq.put("uen", 10);
    freq.put("uei", 6);
    freq.put("uee", 26);
    freq.put("odi", 24);
    freq.put("Blo", 10);
    freq.put("odo", 33);
    freq.put("oda", 9);
    freq.put("Bla", 4);
    freq.put("ode", 68);
    freq.put("ues", 17);
    freq.put("uer", 3);
    freq.put("ct ", 5);
    freq.put("rd ", 10);
    freq.put("lea", 9);
    freq.put("led", 3);
    freq.put("lee", 188);
    freq.put("lef", 19);
    freq.put("leg", 9);
    freq.put("leh", 52);
    freq.put("lei", 78);
    freq.put("lej", 11);
    freq.put("lek", 22);
    freq.put("lel", 30);
    freq.put("lem", 79);
    freq.put("len", 169);
    freq.put("lep", 5);
    freq.put("ler", 17);
    freq.put("les", 50);
    freq.put("let", 65);
    freq.put("lev", 90);
    freq.put("od ", 5);
    freq.put("ley", 5);
    freq.put("evä", 39);
    freq.put("rde", 5);
    freq.put("rda", 4);
    freq.put("rdo", 9);
    freq.put("cto", 6);
    freq.put("rdi", 19);
    freq.put("trö", 6);
    freq.put("zin", 3);
    freq.put("on", 1833);
    freq.put("npä", 27);
    freq.put("hät", 11);
    freq.put("häs", 12);
    freq.put("här", 7);
    freq.put("On ", 18);
    freq.put("npo", 3);
    freq.put("npi", 6);
    freq.put("npe", 11);
    freq.put("npa", 16);
    freq.put("Q", 4);
    freq.put("npy", 4);
    freq.put("ov", 218);
    freq.put("npu", 7);
    freq.put("häm", 8);
    freq.put("Yl", 46);
    freq.put("Onk", 31);
    freq.put("häl", 7);
    freq.put("Onn", 25);
    freq.put("Onl", 3);
    freq.put(" h ", 12);
    freq.put("Sak", 13);
    freq.put(" hy", 189);
    freq.put("San", 12);
    freq.put("Sam", 23);
    freq.put("Sal", 21);
    freq.put("Sac", 3);
    freq.put("Saa", 31);
    freq.put(" hu", 165);
    freq.put(" ht", 25);
    freq.put(" hi", 110);
    freq.put(" hh", 3);
    freq.put(" ho", 50);
    freq.put(" hm", 9);
    freq.put("Sar", 9);
    freq.put(" ha", 262);
    freq.put("kpl", 4);
    freq.put("Sav", 8);
    freq.put(" he", 164);
    freq.put("Sat", 9);
    freq.put(" hö", 8);
    freq.put(" hä", 61);
    freq.put("ihy", 3);
    freq.put("ihr", 7);
    freq.put("iht", 36);
    freq.put("ihu", 3);
    freq.put("ihk", 6);
    freq.put("ihi", 95);
    freq.put("iho", 7);
    freq.put("ihm", 53);
    freq.put("iha", 149);
    freq.put("ihd", 16);
    freq.put("ihe", 53);
    freq.put("Tän", 28);
    freq.put("Täm", 21);
    freq.put("Täl", 7);
    freq.put("UN ", 4);
    freq.put("Täy", 3);
    freq.put("Täs", 19);
    freq.put("Tät", 5);
    freq.put("too", 73);
    freq.put("ih ", 4);
    freq.put(" E ", 4);
    freq.put("ihä", 9);
    freq.put("ck ", 16);
    freq.put("Tää", 11);
    freq.put(" El", 50);
    freq.put(" Em", 9);
    freq.put(" En", 79);
    freq.put(" Eh", 13);
    freq.put(" Ei", 84);
    freq.put(" Ek", 4);
    freq.put(" Ed", 10);
    freq.put(" Ee", 6);
    freq.put(" Ex", 3);
    freq.put(" Et", 16);
    freq.put(" Eu", 22);
    freq.put(" Ep", 7);
    freq.put(" Er", 14);
    freq.put(" Es", 25);
    freq.put("cke", 5);
    freq.put("cka", 8);
    freq.put("AA ", 10);
    freq.put("cki", 7);
    freq.put("Pö", 9);
    freq.put("Pä", 63);
    freq.put("KI ", 3);
    freq.put("jav", 4);
    freq.put("jat", 133);
    freq.put("jau", 10);
    freq.put("jar", 14);
    freq.put("jas", 62);
    freq.put("jap", 9);
    freq.put("jan", 108);
    freq.put("jao", 7);
    freq.put("jal", 47);
    freq.put("jam", 8);
    freq.put("jaj", 12);
    freq.put("jak", 70);
    freq.put("jah", 3);
    freq.put("jai", 33);
    freq.put("jae", 5);
    freq.put("jaa", 73);
    freq.put("aes", 3);
    freq.put("aet", 6);
    freq.put("h", 3901);
    freq.put("etä", 86);
    freq.put("ael", 11);
    freq.put("ja ", 966);
    freq.put("aen", 13);
    freq.put("Pr", 29);
    freq.put("Pu", 55);
    freq.put("Py", 19);
    freq.put("oma", 235);
    freq.put("Pa", 129);
    freq.put("Pe", 86);
    freq.put("Ph", 18);
    freq.put("Pi", 84);
    freq.put("Po", 87);
    freq.put("Pl", 10);
    freq.put("et ", 446);
    freq.put("lg", 8);
    freq.put("P ", 29);
    freq.put("eun", 4);
    freq.put("etr", 18);
    freq.put("ets", 40);
    freq.put("etw", 5);
    freq.put("ett", 546);
    freq.put("etu", 54);
    freq.put("ety", 23);
    freq.put("etc", 3);
    freq.put("tla", 5);
    freq.put("eta", 76);
    freq.put("tle", 5);
    freq.put("lo", 633);
    freq.put("etj", 3);
    freq.put("etk", 43);
    freq.put("eti", 74);
    freq.put("eto", 75);
    freq.put("Het", 6);
    freq.put("ci", 21);
    freq.put("tse", 90);
    freq.put("vä", 731);
    freq.put("cm", 10);
    freq.put("Hes", 6);
    freq.put("cc", 9);
    freq.put("ca", 31);
    freq.put("ce", 55);
    freq.put("edi", 47);
    freq.put("Hee", 3);
    freq.put("vö", 4);
    freq.put("cs", 5);
    freq.put("gät", 15);
    freq.put("Hen", 9);
    freq.put("tsa", 25);
    freq.put("uck", 7);
    freq.put("Hei", 31);
    freq.put("cu", 5);
    freq.put("ct", 15);
    freq.put("kyi", 7);
    freq.put("lgi", 3);
    freq.put("lga", 3);
    freq.put("euv", 13);
    freq.put("rby", 3);
    freq.put("reä", 6);
    freq.put("ly", 138);
    freq.put("rba", 4);
    freq.put("va", 1783);
    freq.put("ve", 459);
    freq.put("vi", 943);
    freq.put("vk", 7);
    freq.put("vo", 369);
    freq.put("vr", 8);
    freq.put("vs", 7);
    freq.put("vu", 218);
    freq.put("vy", 55);
    freq.put("of ", 4);
    freq.put("v ", 48);
    freq.put("ysl", 4);
    freq.put("ofa", 3);
    freq.put("off", 4);
    freq.put("ofe", 3);
    freq.put("ofi", 13);
    freq.put("oft", 8);
    freq.put("ömä", 11);
    freq.put("jä ", 76);
    freq.put("web", 6);
    freq.put("wee", 19);
    freq.put("ehä", 13);
    freq.put("wel", 3);
    freq.put("wer", 9);
    freq.put("Sai", 25);
    freq.put("nve", 31);
    freq.put("nva", 13);
    freq.put("nvo", 6);
    freq.put("nvi", 3);
    freq.put("Oho", 3);
    freq.put("Ohj", 4);
    freq.put(" jä", 169);
    freq.put("ömi", 5);
    freq.put("öma", 8);
    freq.put("ömy", 6);
    freq.put("vsk", 4);
    freq.put("lle", 511);
    freq.put("nvä", 8);
    freq.put("kry", 4);
    freq.put("nös", 5);
    freq.put("Sch", 7);
    freq.put(" ju", 191);
    freq.put("Sca", 3);
    freq.put("kru", 5);
    freq.put(" jo", 575);
    freq.put("kri", 16);
    freq.put(" ji", 3);
    freq.put("Sau", 9);
    freq.put(" je", 31);
    freq.put("kra", 9);
    freq.put(" ja", 795);
    freq.put("inö", 7);
    freq.put("inä", 101);
    freq.put("yri", 45);
    freq.put("yrj", 3);
    freq.put("yrk", 9);
    freq.put("yry", 6);
    freq.put("yrs", 9);
    freq.put("Kla", 5);
    freq.put("Klo", 5);
    freq.put("Klu", 4);
    freq.put("iny", 15);
    freq.put("int", 187);
    freq.put("inu", 74);
    freq.put("inv", 18);
    freq.put("inp", 24);
    freq.put("ins", 33);
    freq.put("inl", 14);
    freq.put("inn", 146);
    freq.put("ino", 85);
    freq.put("inh", 9);
    freq.put("ini", 104);
    freq.put("inj", 10);
    freq.put("ink", 191);
    freq.put("ind", 21);
    freq.put("ine", 476);
    freq.put("inf", 7);
    freq.put("ing", 77);
    freq.put("ina", 253);
    freq.put("eo ", 17);
    freq.put("yrä", 7);
    freq.put("U", 162);
    freq.put("in ", 1935);
    freq.put("eoi", 6);
    freq.put("eon", 11);
    freq.put("eol", 12);
    freq.put("eos", 10);
    freq.put("eor", 3);
    freq.put("eop", 10);
    freq.put("jäs", 11);
    freq.put("eot", 5);
    freq.put("tsä", 20);
    freq.put("Tut", 8);
    freq.put("MA ", 5);
    freq.put(" G ", 7);
    freq.put("lö", 79);
    freq.put("cm ", 10);
    freq.put("Tuk", 8);
    freq.put("Tul", 19);
    freq.put("pte", 5);
    freq.put(" Gu", 3);
    freq.put(" Gr", 18);
    freq.put("Tun", 11);
    freq.put("teä", 7);
    freq.put("Tuo", 24);
    freq.put(" Ge", 6);
    freq.put(" Ga", 7);
    freq.put(" Go", 33);
    freq.put(" Gl", 4);
    freq.put("slu", 3);
    freq.put("Ca", 20);
    freq.put("ā", 5);
    freq.put("fa ", 4);
    freq.put("ak ", 7);
    freq.put("Cr", 4);
    freq.put("löt", 3);
    freq.put("lös", 9);
    freq.put("aks", 168);
    freq.put("gla", 14);
    freq.put("löy", 50);
    freq.put("gle", 21);
    freq.put("aku", 63);
    freq.put("akt", 16);
    freq.put("akk", 111);
    freq.put("aki", 116);
    freq.put("ako", 65);
    freq.put("akl", 3);
    freq.put("aka", 304);
    freq.put("lön", 3);
    freq.put("löi", 3);
    freq.put("glu", 3);
    freq.put("lök", 4);
    freq.put("Jer", 3);
    freq.put("Jes", 10);
    freq.put("Jep", 6);
    freq.put("bru", 3);
    freq.put("bro", 3);
    freq.put("iz", 3);
    freq.put("Jee", 8);
    freq.put("bre", 3);
    freq.put("Jen", 5);
    freq.put("bra", 4);
    freq.put("er ", 60);
    freq.put("tn ", 5);
    freq.put("nka", 72);
    freq.put("ir", 402);
    freq.put("erP", 3);
    freq.put("nke", 27);
    freq.put("iu", 59);
    freq.put("nkk", 69);
    freq.put("nko", 94);
    freq.put("nks", 16);
    freq.put("nku", 28);
    freq.put("nky", 3);
    freq.put("ert", 92);
    freq.put("eru", 36);
    freq.put("erv", 39);
    freq.put("erp", 5);
    freq.put("err", 64);
    freq.put("ers", 43);
    freq.put("erd", 3);
    freq.put("ere", 75);
    freq.put("erf", 3);
    freq.put("erg", 15);
    freq.put("era", 52);
    freq.put("erb", 8);
    freq.put("erl", 5);
    freq.put("erm", 12);
    freq.put("ern", 16);
    freq.put("ero", 77);
    freq.put("erh", 29);
    freq.put("eri", 246);
    freq.put("erj", 19);
    freq.put("erk", 106);
    freq.put("io", 269);
    freq.put("uas", 4);
    freq.put("uar", 3);
    freq.put("la ", 673);
    freq.put("uat", 10);
    freq.put("uai", 12);
    freq.put("ual", 8);
    freq.put("uan", 33);
    freq.put("uaa", 17);
    freq.put("brä", 5);
    freq.put("ki ", 287);
    freq.put("ī", 4);
    freq.put("lal", 20);
    freq.put("lam", 25);
    freq.put("lan", 157);
    freq.put("nkä", 42);
    freq.put("lai", 304);
    freq.put("laj", 12);
    freq.put("lak", 48);
    freq.put("laa", 165);
    freq.put("lac", 6);
    freq.put("lay", 9);
    freq.put("nkö", 7);
    freq.put("lat", 47);
    freq.put("ua ", 173);
    freq.put("lav", 7);
    freq.put("lap", 41);
    freq.put("lar", 16);
    freq.put("las", 154);
    freq.put("erä", 49);
    freq.put("pj ", 5);
    freq.put("ntö", 6);
    freq.put("ntä", 77);
    freq.put("l", 11706);
    freq.put("nt ", 27);
    freq.put("€", 16);
    freq.put("nty", 33);
    freq.put("nts", 4);
    freq.put("ntr", 5);
    freq.put("ntu", 62);
    freq.put("ntt", 80);
    freq.put("nti", 134);
    freq.put("nto", 204);
    freq.put("nta", 254);
    freq.put("nte", 119);
    freq.put("öss", 26);
    freq.put("öst", 20);
    freq.put(" l ", 3);
    freq.put("öse", 6);
    freq.put("ösk", 5);
    freq.put("Se ", 31);
    freq.put(" le", 115);
    freq.put("B", 128);
    freq.put(" la", 215);
    freq.put(" lo", 110);
    freq.put(" ll", 13);
    freq.put(" li", 231);
    freq.put("ös ", 67);
    freq.put(" lu", 152);
    freq.put(" lt", 5);
    freq.put(" ly", 23);
    freq.put("Sev", 3);
    freq.put("Seu", 7);
    freq.put("Set", 3);
    freq.put("Ser", 3);
    freq.put("Sep", 3);
    freq.put("ktr", 5);
    freq.put("kto", 8);
    freq.put("kti", 22);
    freq.put("kte", 4);
    freq.put("Sel", 7);
    freq.put("Sek", 3);
    freq.put("Sei", 10);
    freq.put("ärö", 3);
    freq.put("yps", 3);
    freq.put("ypp", 81);
    freq.put("ypu", 4);
    freq.put("äy ", 11);
    freq.put("teu", 16);
    freq.put("ype", 5);
    freq.put("ypi", 6);
    freq.put(" lä", 140);
    freq.put("Qu", 3);
    freq.put(" lö", 50);
    freq.put("mäk", 31);
    freq.put("mäh", 3);
    freq.put("mäi", 25);
    freq.put("män", 73);
    freq.put("mäl", 20);
    freq.put("d ", 115);
    freq.put("mäe", 14);
    freq.put("mär", 22);
    freq.put("mäs", 27);
    freq.put("mäp", 3);
    freq.put("mät", 27);
    freq.put("Fo", 17);
    freq.put("hri", 8);
    freq.put("hre", 9);
    freq.put("hra", 3);
    freq.put("dn", 3);
    freq.put("do", 193);
    freq.put("dl", 4);
    freq.put("dm", 6);
    freq.put("dj", 4);
    freq.put("dk", 3);
    freq.put("dh", 5);
    freq.put("di", 305);
    freq.put("df", 4);
    freq.put("dg", 3);
    freq.put("dd", 6);
    freq.put("de", 628);
    freq.put("da", 118);
    freq.put("dy", 43);
    freq.put("du", 82);
    freq.put("dr", 26);
    freq.put("ds", 9);
    freq.put("eme", 15);
    freq.put("ilä", 14);
    freq.put("ema", 90);
    freq.put("emm", 115);
    freq.put("emo", 8);
    freq.put("emi", 53);
    freq.put("ilö", 16);
    freq.put("vää", 90);
    freq.put("w ", 40);
    freq.put("mää", 100);
    freq.put(" I ", 15);
    freq.put("il ", 21);
    freq.put("xD ", 5);
    freq.put("co ", 8);
    freq.put("we", 40);
    freq.put("wa", 16);
    freq.put("wo", 10);
    freq.put("wn", 3);
    freq.put(" Ir", 11);
    freq.put(" Is", 27);
    freq.put(" It", 32);
    freq.put("wi", 50);
    freq.put("wh", 3);
    freq.put(" Ih", 24);
    freq.put(" Ii", 7);
    freq.put(" Ik", 6);
    freq.put(" Il", 32);
    freq.put(" In", 28);
    freq.put("dö", 6);
    freq.put(" Id", 3);
    freq.put("emä", 30);
    freq.put("väs", 36);
    freq.put("vär", 47);
    freq.put("vät", 97);
    freq.put("ila", 133);
    freq.put("väy", 7);
    freq.put("ilo", 31);
    freq.put("ill", 470);
    freq.put("ilm", 123);
    freq.put("ilj", 36);
    freq.put("ilk", 9);
    freq.put("ili", 100);
    freq.put("ilv", 5);
    freq.put("ilt", 89);
    freq.put("ilu", 89);
    freq.put("väe", 3);
    freq.put("ilp", 23);
    freq.put("väi", 17);
    freq.put("väh", 59);
    freq.put("väk", 21);
    freq.put("väm", 3);
    freq.put("väl", 77);
    freq.put("coo", 4);
    freq.put("vän", 76);
    freq.put("gn ", 3);
    freq.put("ai ", 190);
    freq.put("niä", 13);
    freq.put("ait", 139);
    freq.put("aiv", 55);
    freq.put("aip", 14);
    freq.put("ais", 547);
    freq.put("air", 17);
    freq.put("aim", 24);
    freq.put("ail", 148);
    freq.put("ET ", 3);
    freq.put("ain", 462);
    freq.put("aih", 59);
    freq.put("aik", 408);
    freq.put("aij", 8);
    freq.put("aie", 4);
    freq.put("aid", 35);
    freq.put("epä", 32);
    freq.put("ni ", 210);
    freq.put("Ike", 3);
    freq.put("ep ", 8);
    freq.put("th ", 3);
    freq.put("nik", 22);
    freq.put("nii", 223);
    freq.put("nin", 104);
    freq.put("nio", 17);
    freq.put("nil", 21);
    freq.put("nim", 73);
    freq.put("nia", 32);
    freq.put("nif", 4);
    freq.put("nig", 3);
    freq.put("nie", 21);
    freq.put("Y", 153);
    freq.put("nis", 126);
    freq.put("nip", 12);
    freq.put("niv", 9);
    freq.put("nit", 69);
    freq.put("ept", 4);
    freq.put("eps", 3);
    freq.put("epp", 15);
    freq.put("epo", 4);
    freq.put("thi", 4);
    freq.put("epi", 4);
    freq.put("the", 7);
    freq.put("epe", 6);
    freq.put("tha", 12);
    freq.put("epa", 10);
    freq.put("rn ", 5);
    freq.put("ykä", 16);
    freq.put("ykö", 7);
    freq.put("rni", 9);
    freq.put("rno", 8);
    freq.put("Tro", 4);
    freq.put("Tra", 6);
    freq.put("rna", 11);
    freq.put("rne", 10);
    freq.put("Tok", 3);
    freq.put("miu", 15);
    freq.put("pl ", 4);
    freq.put("Lea", 4);
    freq.put("yke", 3);
    freq.put("ykk", 29);
    freq.put("Lei", 10);
    freq.put("yki", 4);
    freq.put("yko", 8);
    freq.put("Len", 5);
    freq.put("yks", 132);
    freq.put("Lev", 8);
    freq.put("yky", 21);
    freq.put("Ä", 19);
    freq.put("ply", 3);
    freq.put("rnä", 3);
    freq.put("ple", 14);
    freq.put("pla", 14);
    freq.put("obo", 4);
    freq.put("obi", 14);
    freq.put("obe", 4);
    freq.put("obs", 12);
    freq.put("Cup", 6);
    freq.put("wan", 3);
    freq.put("way", 3);
    freq.put("war", 4);
    freq.put(" X ", 4);
    freq.put(" nä", 190);
    freq.put(" nö", 3);
    freq.put("mtn", 4);
    freq.put("Odo", 4);
    freq.put(" n ", 87);
    freq.put(" ni", 275);
    freq.put(" no", 144);
    freq.put(" na", 79);
    freq.put(" ne", 115);
    freq.put(" ny", 129);
    freq.put(" nu", 62);
    freq.put("htä", 56);
    freq.put("Bän", 8);
    freq.put("htö", 9);
    freq.put("yvy", 3);
    freq.put("yvi", 42);
    freq.put("kyk", 4);
    freq.put("gue", 4);
    freq.put("ekä", 20);
    freq.put("p", 4211);
    freq.put("ekö", 5);
    freq.put("hte", 97);
    freq.put("hta", 120);
    freq.put("hto", 45);
    freq.put("htm", 4);
    freq.put("hti", 113);
    freq.put("OK ", 5);
    freq.put("htu", 58);
    freq.put("htt", 17);
    freq.put("IN ", 10);
    freq.put("hty", 23);
    freq.put("yvä", 224);
    freq.put("ht ", 16);
    freq.put("eko", 46);
    freq.put("ekn", 18);
    freq.put("ekk", 58);
    freq.put("eki", 65);
    freq.put("eke", 46);
    freq.put("eka", 40);
    freq.put("eku", 14);
    freq.put("ekt", 18);
    freq.put("eks", 146);
    freq.put("ekr", 4);
    freq.put(" it", 80);
    freq.put(" iv", 3);
    freq.put("spä", 8);
    freq.put("MM ", 5);
    freq.put("kse", 292);
    freq.put(" Ka", 185);
    freq.put(" Ke", 80);
    freq.put(" Ki", 111);
    freq.put(" Ko", 172);
    freq.put(" Kl", 14);
    freq.put(" Kr", 21);
    freq.put(" Ku", 229);
    freq.put(" il", 120);
    freq.put(" Ky", 28);
    freq.put(" im", 3);
    freq.put("F", 146);
    freq.put("ibi", 3);
    freq.put(" K ", 3);
    freq.put("ibo", 7);
    freq.put("cas", 5);
    freq.put("iba", 3);
    freq.put("iby", 4);
    freq.put("can", 11);
    freq.put("cal", 4);
    freq.put("spu", 7);
    freq.put("spi", 6);
    freq.put("spo", 23);
    freq.put("spa", 42);
    freq.put("spe", 21);
    freq.put(" Kä", 44);
    freq.put("gh ", 3);
    freq.put("aol", 3);
    freq.put("aoj", 3);
    freq.put("aot", 4);
    freq.put("aos", 5);
    freq.put("aop", 5);
    freq.put("ght", 10);
    freq.put("KO ", 3);
    freq.put("ER ", 3);
    freq.put("Ru", 27);
    freq.put("Che", 5);
    freq.put("eä", 51);
    freq.put("Jat", 6);
    freq.put("Jar", 8);
    freq.put("yä ", 37);
    freq.put("Jan", 4);
    freq.put("Re", 35);
    freq.put("Jal", 6);
    freq.put("Jam", 3);
    freq.put("Ra", 47);
    freq.put("Jah", 3);
    freq.put("Ro", 34);
    freq.put("Ri", 31);
    freq.put("Jaa", 9);
    freq.put("nol", 28);
    freq.put("nom", 41);
    freq.put("non", 55);
    freq.put("noo", 25);
    freq.put("noh", 13);
    freq.put("noi", 93);
    freq.put("noj", 18);
    freq.put("nok", 10);
    freq.put("som", 29);
    freq.put("ääl", 74);
    freq.put("noa", 27);
    freq.put("lmö", 4);
    freq.put("mba", 3);
    freq.put("R ", 22);
    freq.put("not", 26);
    freq.put("nou", 19);
    freq.put("nov", 7);
    freq.put("now", 4);
    freq.put("lmä", 33);
    freq.put("Ja ", 64);
    freq.put("nos", 76);
    freq.put("sot", 28);
    freq.put("em", 401);
    freq.put("el", 1795);
    freq.put("eo", 83);
    freq.put("en", 3559);
    freq.put("ei", 1201);
    freq.put("eh", 322);
    freq.put("ek", 484);
    freq.put("ej", 59);
    freq.put("ee", 1177);
    freq.put("ed", 216);
    freq.put("eg", 181);
    freq.put("ef", 27);
    freq.put("ea", 234);
    freq.put("rl ", 4);
    freq.put("ec", 18);
    freq.put("eb", 43);
    freq.put("ey", 65);
    freq.put("ex", 16);
    freq.put("ez", 7);
    freq.put("eu", 203);
    freq.put("et", 1552);
    freq.put("ew", 15);
    freq.put("ev", 209);
    freq.put("ep", 97);
    freq.put("es", 1150);
    freq.put("er", 1065);
    freq.put("eO", 3);
    freq.put("rli", 4);
    freq.put("yää", 10);
    freq.put("rla", 5);
    freq.put("e ", 1767);
    freq.put("lmi", 53);
    freq.put("lmo", 24);
    freq.put("usl", 13);
    freq.put("lme", 48);
    freq.put("xi", 5);
    freq.put("xa", 4);
    freq.put("xt", 3);
    freq.put("Eur", 21);
    freq.put("yil", 6);
    freq.put("yin", 7);
    freq.put("xD", 14);
    freq.put("yij", 3);
    freq.put("yit", 3);
    freq.put("yis", 22);
    freq.put("Sä", 10);
    freq.put("x ", 28);
    freq.put("yi ", 31);
    freq.put("Pho", 16);
    freq.put("usr", 13);
    freq.put("ytö", 24);
    freq.put("ytä", 51);
    freq.put(" ps", 3);
    freq.put(" pr", 53);
    freq.put("HS ", 13);
    freq.put(" pp", 3);
    freq.put(" pu", 186);
    freq.put(" py", 54);
    freq.put(" pa", 389);
    freq.put(" pe", 226);
    freq.put(" pj", 5);
    freq.put(" pi", 305);
    freq.put(" po", 155);
    freq.put(" pl", 6);
    freq.put("vu ", 9);
    freq.put("yty", 72);
    freq.put("ytt", 175);
    freq.put("ytu", 4);
    freq.put("yto", 3);
    freq.put("ytk", 6);
    freq.put("yti", 11);
    freq.put("yte", 36);
    freq.put("yta", 4);
    freq.put(" pö", 9);
    freq.put("Kri", 4);
    freq.put(" pä", 274);
    freq.put("Kre", 15);
    freq.put("EM ", 7);
    freq.put("vun", 9);
    freq.put("vuo", 123);
    freq.put("vul", 14);
    freq.put("vuj", 7);
    freq.put("vui", 3);
    freq.put("vuv", 3);
    freq.put("vut", 17);
    freq.put("vuu", 10);
    freq.put("vus", 14);
    freq.put("yt ", 248);
    freq.put("hvi", 24);
    freq.put("Yri", 8);
    freq.put("hva", 7);
    freq.put("hve", 7);
    freq.put(" Mä", 28);
    freq.put("Äl", 10);
    freq.put("ei ", 356);
    freq.put("eip", 12);
    freq.put("eis", 189);
    freq.put("eir", 5);
    freq.put("eit", 103);
    freq.put("eiv", 28);
    freq.put("Ä ", 22);
    freq.put("eia", 4);
    freq.put("eid", 43);
    freq.put("eih", 22);
    freq.put("eik", 119);
    freq.put("eij", 19);
    freq.put("eim", 13);
    freq.put("eil", 166);
    freq.put("ein", 111);
    freq.put("SD ", 3);
    freq.put("yl", 310);
    freq.put(" Me", 90);
    freq.put(" Ma", 182);
    freq.put("Ää", 6);
    freq.put(" Mo", 38);
    freq.put(" Mi", 187);
    freq.put(" Mu", 136);
    freq.put(" My", 10);
    freq.put("ete", 44);
    freq.put(" M ", 10);
    freq.put("MK ", 4);
    freq.put("cci", 3);
    freq.put("eiä", 3);
    freq.put("ck", 46);
    freq.put("am ", 17);
    freq.put("ps ", 8);
    freq.put("Hev", 3);
    freq.put("ch", 35);
    freq.put("co", 51);
    freq.put("Her", 5);
    freq.put("yv", 275);
    freq.put("Näi", 16);
    freq.put("psi", 7);
    freq.put("amm", 55);
    freq.put("amo", 30);
    freq.put("amn", 4);
    freq.put("ama", 183);
    freq.put("psa", 4);
    freq.put("ame", 35);
    freq.put("ynn", 28);
    freq.put("pse", 19);
    freq.put("nmä", 3);
    freq.put("psy", 3);
    freq.put("amp", 69);
    freq.put("ams", 10);
    freq.put("amu", 45);
    freq.put("pst", 4);
    freq.put("psu", 9);
    freq.put("Kää", 3);
    freq.put("t", 19224);
    freq.put(" ää", 39);
    freq.put("Hel", 64);
    freq.put("cr", 7);
    freq.put("Heh", 8);
    freq.put("nmu", 8);
    freq.put("amä", 8);
    freq.put("nmy", 3);
    freq.put("nme", 3);
    freq.put("nma", 8);
    freq.put("sra", 18);
    freq.put("sri", 3);
    freq.put("Käy", 21);
    freq.put("Kät", 5);
    freq.put("sry", 6);
    freq.put("Kär", 5);
    freq.put("Käs", 7);
    freq.put("ys ", 85);
    freq.put("Adr", 3);
    freq.put("Ada", 3);
    freq.put("loc", 5);
    freq.put("loa", 13);
    freq.put("log", 47);
    freq.put("lod", 3);
    freq.put("loj", 8);
    freq.put("lok", 60);
    freq.put("loh", 7);
    freq.put("loi", 62);
    freq.put("lon", 41);
    freq.put("loo", 12);
    freq.put("lol", 19);
    freq.put("lom", 22);
    freq.put("lor", 3);
    freq.put("los", 66);
    freq.put("lop", 78);
    freq.put("lov", 8);
    freq.put("low", 9);
    freq.put("lot", 28);
    freq.put("lou", 39);
    freq.put("rju", 8);
    freq.put("iCl", 3);
    freq.put("J", 389);
    freq.put("rje", 50);
    freq.put("rja", 148);
    freq.put("rjo", 152);
    freq.put("lo ", 98);
    freq.put("jää", 46);
    freq.put("as ", 188);
    freq.put("Ess", 4);
    freq.put("Esp", 14);
    freq.put("Esk", 3);
    freq.put("Esi", 4);
    freq.put("yon", 6);
    freq.put("Lan", 3);
    freq.put("Mun", 8);
    freq.put("Lah", 8);
    freq.put("Lai", 7);
    freq.put("Lak", 6);
    freq.put("Laa", 4);
    freq.put("Lau", 22);
    freq.put("you", 6);
    freq.put("Lap", 10);
    freq.put("Las", 19);
    freq.put("c ", 26);
    freq.put("rjä", 8);
    freq.put("jäl", 51);
    freq.put("jän", 49);
    freq.put("jäi", 11);
    freq.put("jäh", 8);
    freq.put("La ", 4);
    freq.put("jäy", 6);
    freq.put("Bri", 3);
    freq.put("jät", 46);
    freq.put("Bre", 8);
    freq.put("Bra", 4);
    freq.put("jär", 66);
    freq.put("mp ", 4);
    freq.put("töt", 8);
    freq.put("töv", 3);
    freq.put("töp", 3);
    freq.put("tös", 19);
    freq.put("tör", 7);
    freq.put("töm", 15);
    freq.put("töl", 5);
    freq.put("tön", 21);
    freq.put("töi", 32);
    freq.put("tök", 17);
    freq.put("töj", 7);
    freq.put("dät", 13);
    freq.put("dän", 31);
    freq.put("ysk", 17);
    freq.put("mpe", 32);
    freq.put("mpa", 37);
    freq.put("mpo", 4);
    freq.put("ysi", 43);
    freq.put("mpi", 60);
    freq.put(" rä", 14);
    freq.put("mpu", 13);
    freq.put("mpp", 26);
    freq.put("yso", 7);
    freq.put("tö ", 27);
    freq.put("mpy", 3);
    freq.put("nän", 14);
    freq.put("dä ", 59);
    freq.put("En ", 33);
    freq.put("töö", 13);
    freq.put("puo", 76);
    freq.put("töä", 5);
    freq.put("asv", 35);
    freq.put("puj", 13);
    freq.put("puk", 9);
    freq.put("dää", 15);
    freq.put(" ru", 58);
    freq.put("mpä", 24);
    freq.put(" ry", 20);
    freq.put("yä", 50);
    freq.put("mpö", 4);
    freq.put(" ra", 140);
    freq.put(" ro", 33);
    freq.put(" ri", 52);
    freq.put("ysp", 6);
    freq.put("TS ", 4);
    freq.put("ysv", 16);
    freq.put("yst", 95);
    freq.put("ask", 55);
    freq.put("S ", 91);
    freq.put("puv", 6);
    freq.put(" Fy", 3);
    freq.put("asm", 5);
    freq.put("pus", 12);
    freq.put("Sy", 31);
    freq.put("Sp", 7);
    freq.put("Su", 165);
    freq.put("St", 67);
    freq.put("Sk", 6);
    freq.put("Si", 93);
    freq.put("Sh", 8);
    freq.put("So", 59);
    freq.put("Sl", 6);
    freq.put("Sc", 14);
    freq.put("Sa", 167);
    freq.put("Se", 85);
    freq.put("EK ", 4);
    freq.put("hhu", 3);
    freq.put("f ", 19);
    freq.put("hha", 3);
    freq.put("hhh", 22);
    freq.put("fr", 5);
    freq.put("ft", 16);
    freq.put("fu", 12);
    freq.put("fy", 6);
    freq.put("Sö", 5);
    freq.put("fa", 55);
    freq.put("fe", 39);
    freq.put("ff", 39);
    freq.put("fi", 105);
    freq.put("fk", 5);
    freq.put("fl", 7);
    freq.put("fo", 38);
    freq.put("a", 25924);
    freq.put("ego", 160);
    freq.put("ö", 948);
    freq.put("ega", 8);
    freq.put("ege", 4);
    freq.put("ce ", 12);
    freq.put("y ", 333);
    freq.put("uvu", 15);
    freq.put("ffo", 4);
    freq.put("uvi", 46);
    freq.put("ffi", 3);
    freq.put("uvo", 15);
    freq.put("uva", 151);
    freq.put("ffe", 6);
    freq.put("uve", 7);
    freq.put("ffa", 19);
    freq.put(" On", 77);
    freq.put(" Oo", 19);
    freq.put(" Ol", 76);
    freq.put(" Om", 5);
    freq.put(" Ok", 12);
    freq.put(" Oh", 10);
    freq.put(" Oi", 24);
    freq.put(" Od", 5);
    freq.put(" Oy", 6);
    freq.put(" Ov", 3);
    freq.put(" Ot", 9);
    freq.put(" Ou", 21);
    freq.put(" Or", 6);
    freq.put(" Os", 26);
    freq.put(" Op", 11);
    freq.put("yi", 79);
    freq.put("yh", 224);
    freq.put("yk", 224);
    freq.put("yj", 9);
    freq.put("ym", 125);
    freq.put("ceb", 27);
    freq.put("yo", 17);
    freq.put("yn", 223);
    freq.put("ya", 14);
    freq.put("cen", 8);
    freq.put("yb", 5);
    freq.put("ye", 28);
    freq.put("yd", 65);
    freq.put("yy", 392);
    freq.put("yp", 106);
    freq.put("ys", 368);
    freq.put("yr", 90);
    freq.put("yu", 3);
    freq.put("yt", 640);
    freq.put("yw", 6);
    freq.put("ff ", 4);
    freq.put("äom", 4);
    freq.put(" O ", 12);
    freq.put("ife", 5);
    freq.put("ifi", 5);
    freq.put("Ene", 5);
    freq.put("Eng", 8);
    freq.put("Enk", 3);
    freq.put("pu ", 27);
    freq.put("Enn", 5);
    freq.put("Enp", 3);
    freq.put("Ens", 15);
    freq.put("Ent", 3);
    freq.put("ass", 237);
    freq.put("pum", 5);
    freq.put("pun", 71);
    freq.put("asp", 9);
    freq.put("puh", 85);
    freq.put("pui", 21);
    freq.put("asu", 44);
    freq.put("ast", 509);
    freq.put("pud", 4);
    freq.put("asy", 3);
    freq.put("pua", 19);
    freq.put("asa", 35);
    freq.put("ase", 70);
    freq.put("put", 27);
    freq.put("puu", 36);
    freq.put("asi", 188);
    freq.put("ash", 7);
    freq.put("aso", 22);
    freq.put("pur", 20);
    freq.put("asl", 3);
    freq.put(" äl", 15);
    freq.put(" äk", 5);
    freq.put(" äi", 11);
    freq.put(" äs", 9);
    freq.put(" är", 5);
    freq.put("Clo", 3);
    freq.put("liä", 15);
    freq.put("st ", 67);
    freq.put("liö", 3);
    freq.put("nch", 3);
    freq.put("nce", 4);
    freq.put("ste", 320);
    freq.put("sta", 1157);
    freq.put("sto", 150);
    freq.put("sti", 406);
    freq.put("stu", 209);
    freq.put("str", 28);
    freq.put("sts", 3);
    freq.put("sty", 90);
    freq.put("Gol", 6);
    freq.put("Goo", 20);
    freq.put("ka ", 343);
    freq.put("Aja", 3);
    freq.put("ysä", 4);
    freq.put("lid", 5);
    freq.put("Nik", 4);
    freq.put("lif", 6);
    freq.put("Nii", 23);
    freq.put("Nin", 4);
    freq.put("lia", 61);
    freq.put("Nim", 46);
    freq.put("lil", 39);
    freq.put("Nic", 5);
    freq.put("lin", 235);
    freq.put("lio", 26);
    freq.put("lih", 13);
    freq.put("Nig", 3);
    freq.put("lij", 47);
    freq.put("lik", 74);
    freq.put("lit", 115);
    freq.put("liu", 7);
    freq.put("liv", 32);
    freq.put("lip", 57);
    freq.put("lis", 373);
    freq.put("kaa", 465);
    freq.put("kae", 8);
    freq.put("kad", 13);
    freq.put("kak", 54);
    freq.put("kaj", 10);
    freq.put("kai", 260);
    freq.put("kah", 45);
    freq.put("rhu", 3);
    freq.put("kan", 296);
    freq.put("kam", 44);
    freq.put("kal", 109);
    freq.put("rhi", 4);
    freq.put("kar", 85);
    freq.put("kap", 27);
    freq.put("kav", 68);
    freq.put("kau", 201);
    freq.put("kat", 324);
    freq.put("rha", 34);
    freq.put("The", 15);
    freq.put("rhe", 44);
    freq.put("stä", 392);
    freq.put("li ", 366);
    freq.put("stö", 31);
    freq.put("ymp", 15);
    freq.put("ymy", 21);
    freq.put("yma", 3);
    freq.put("ymb", 8);
    freq.put("ymi", 17);
    freq.put("ymm", 20);
    freq.put("ymo", 5);
    freq.put("ym ", 5);
    freq.put("x", 63);
    freq.put("Ykk", 3);
    freq.put("Yks", 7);
    freq.put("woo", 8);
    freq.put("ymä", 27);
    freq.put("Pla", 6);
    freq.put("Wal", 4);
    freq.put(" t ", 7);
    freq.put("esä", 22);
    freq.put(" ty", 127);
    freq.put(" € ", 16);
    freq.put(" tw", 33);
    freq.put(" tv", 8);
    freq.put(" tu", 474);
    freq.put(" ts", 9);
    freq.put(" tr", 27);
    freq.put("N", 428);
    freq.put(" to", 326);
    freq.put(" tm", 6);
    freq.put(" ti", 211);
    freq.put(" th", 7);
    freq.put(" te", 275);
    freq.put(" ta", 498);
    freq.put("vyö", 6);
    freq.put("iyh", 5);
    freq.put("iyt", 3);
    freq.put("vyä", 3);
    freq.put("rPo", 3);
    freq.put("sä ", 318);
    freq.put("boi", 3);
    freq.put("vy ", 8);
    freq.put("sät", 6);
    freq.put("säv", 4);
    freq.put("säp", 4);
    freq.put("sär", 8);
    freq.put("säs", 8);
    freq.put(" tö", 40);
    freq.put("säy", 3);
    freq.put("lig", 4);
    freq.put("säa", 3);
    freq.put("säl", 27);
    freq.put("säm", 4);
    freq.put("sän", 16);
    freq.put(" tä", 387);
    freq.put("säh", 12);
    freq.put("säi", 7);
    freq.put("säk", 13);
    freq.put("vys", 4);
    freq.put("vyt", 4);
    freq.put("vyy", 13);
    freq.put("EI ", 4);
    freq.put("lim", 32);
    freq.put("vyn", 7);
    freq.put("hju", 6);
    freq.put("lii", 215);
    freq.put("hje", 32);
    freq.put("hja", 24);
    freq.put("ohi", 21);
    freq.put("hjo", 15);
    freq.put("ee ", 305);
    freq.put("pä ", 37);
    freq.put("ohk", 5);
    freq.put("eet", 143);
    freq.put("pät", 12);
    freq.put("päs", 10);
    freq.put("pär", 24);
    freq.put("ees", 109);
    freq.put("eer", 12);
    freq.put("päo", 8);
    freq.put("eel", 52);
    freq.put("päm", 3);
    freq.put("een", 440);
    freq.put("päk", 4);
    freq.put("eeh", 3);
    freq.put("päi", 180);
    freq.put("päh", 7);
    freq.put("eee", 17);
    freq.put("eed", 4);
    freq.put("eeg", 3);
    freq.put("ru ", 5);
    freq.put(" Qu", 3);
    freq.put("id ", 9);
    freq.put("ruk", 10);
    freq.put("rui", 5);
    freq.put("run", 22);
    freq.put("ruo", 29);
    freq.put("rul", 5);
    freq.put("rum", 13);
    freq.put("AM ", 3);
    freq.put("rus", 46);
    freq.put("rup", 4);
    freq.put("ruv", 3);
    freq.put("rut", 7);
    freq.put("ruu", 33);
    freq.put("kas", 146);
    freq.put("idu", 9);
    freq.put("ido", 11);
    freq.put("idi", 16);
    freq.put("ide", 160);
    freq.put("ida", 38);
    freq.put("Eli", 24);
    freq.put("Elo", 7);
    freq.put("Ell", 3);
    freq.put("Tö", 4);
    freq.put("Ele", 4);
    freq.put("Tä", 96);
    freq.put("ut ", 404);
    freq.put("kur", 30);
    freq.put("tum", 58);
    freq.put("uta", 189);
    freq.put("ute", 91);
    freq.put("utk", 52);
    freq.put("uth", 3);
    freq.put("uti", 75);
    freq.put("uto", 82);
    freq.put("ätä", 57);
    freq.put("uts", 19);
    freq.put("utt", 350);
    freq.put("utu", 122);
    freq.put("uty", 3);
    freq.put("ätö", 21);
    freq.put("Ty", 104);
    freq.put("Tw", 20);
    freq.put("Tu", 121);
    freq.put("Tr", 12);
    freq.put("snä", 6);
    freq.put("Elä", 11);
    freq.put("To", 88);
    freq.put("Th", 22);
    freq.put("Ti", 53);
    freq.put("Te", 91);
    freq.put("Ta", 365);
    freq.put("A ", 83);
    freq.put("naa", 101);
    freq.put("nad", 3);
    freq.put("naj", 5);
    freq.put("nak", 50);
    freq.put("nah", 3);
    freq.put("nai", 80);
    freq.put("nan", 65);
    freq.put("nal", 53);
    freq.put("nam", 12);
    freq.put("nar", 11);
    freq.put("nas", 60);
    freq.put("nap", 8);
    freq.put("nav", 26);
    freq.put("nat", 80);
    freq.put("nau", 32);
    freq.put("oon", 147);
    freq.put("MÄ ", 4);
    freq.put("est", 451);
    freq.put("T ", 133);
    freq.put("ätk", 25);
    freq.put("svo", 6);
    freq.put("äti", 15);
    freq.put("Ab", 5);
    freq.put("e", 16052);
    freq.put("Ad", 6);
    freq.put("Ag", 4);
    freq.put("svi", 19);
    freq.put("Ai", 68);
    freq.put("Ah", 14);
    freq.put("Ak", 14);
    freq.put("Aj", 4);
    freq.put("Am", 12);
    freq.put("Al", 39);
    freq.put("äte", 33);
    freq.put("sva", 37);
    freq.put("Ap", 21);
    freq.put("äty", 19);
    freq.put("Ar", 34);
    freq.put("Au", 24);
    freq.put("At", 5);
    freq.put("Aw", 3);
    freq.put("Av", 12);
    freq.put("svu", 8);
    freq.put("ätt", 66);
    freq.put("gu", 13);
    freq.put("gs", 7);
    freq.put("gr", 20);
    freq.put("gy", 5);
    freq.put("gg", 10);
    freq.put("ge", 57);
    freq.put("gb", 3);
    freq.put("ga", 90);
    freq.put("go", 186);
    freq.put("gn", 9);
    freq.put("gl", 39);
    freq.put("gi", 159);
    freq.put("gh", 17);
    freq.put("lko", 92);
    freq.put("Non", 3);
    freq.put("Noi", 4);
    freq.put("lki", 61);
    freq.put("lke", 64);
    freq.put("lka", 125);
    freq.put("Nou", 4);
    freq.put("Nov", 4);
    freq.put("lku", 18);
    freq.put("Nop", 3);
    freq.put("lks", 3);
    freq.put("Nor", 11);
    freq.put("g ", 48);
    freq.put("hi ", 20);
    freq.put("esk", 112);
    freq.put("No ", 32);
    freq.put("zi", 5);
    freq.put("ulv", 4);
    freq.put("za", 3);
    freq.put("gä", 18);
    freq.put("lkä", 25);
    freq.put("rho", 17);
    freq.put("z ", 7);
    freq.put("Aho", 4);
    freq.put("Aht", 3);
    freq.put("Ju", 53);
    freq.put("sä", 519);
    freq.put("wii", 15);
    freq.put("iet", 128);
    freq.put("wit", 29);
    freq.put(" vä", 149);
    freq.put(" jy", 4);
    freq.put("Ja", 117);
    freq.put("Jyv", 9);
    freq.put("hiu", 7);
    freq.put(" va", 681);
    freq.put(" ve", 117);
    freq.put(" vi", 465);
    freq.put(" vk", 7);
    freq.put(" vo", 188);
    freq.put(" vr", 8);
    freq.put(" vu", 110);
    freq.put(" vy", 4);
    freq.put("kro", 7);
    freq.put("Hän", 7);
    freq.put("Häm", 16);
    freq.put(" v ", 20);
    freq.put("TO ", 4);
    freq.put("jne", 5);
    freq.put("Pyh", 3);
    freq.put("öyr", 3);
    freq.put("öys", 13);
    freq.put("öyt", 39);
    freq.put("öyd", 13);
    freq.put("öyh", 4);
    freq.put("mar", 64);
    freq.put("hli", 8);
    freq.put("hla", 11);
    freq.put("ece", 3);
    freq.put("eck", 3);
    freq.put("ect", 7);
    freq.put("OC ", 3);
    freq.put("rs ", 18);
    freq.put("AN ", 8);
    freq.put(" Sy", 31);
    freq.put("be ", 7);
    freq.put(" St", 63);
    freq.put(" Su", 162);
    freq.put(" Sk", 6);
    freq.put(" Sh", 7);
    freq.put(" Si", 92);
    freq.put(" So", 59);
    freq.put(" Sl", 6);
    freq.put(" Sc", 13);
    freq.put(" Sa", 167);
    freq.put(" Se", 85);
    freq.put("rsi", 41);
    freq.put("rsk", 15);
    freq.put("rse", 10);
    freq.put("rsa", 7);
    freq.put("pyö", 21);
    freq.put("AS ", 4);
    freq.put("rsy", 5);
    freq.put("rst", 15);
    freq.put("rsu", 7);
    freq.put("lPa", 9);
    freq.put("rss", 23);
    freq.put("ber", 10);
    freq.put("bes", 7);
    freq.put(" S ", 14);
    freq.put("bet", 6);
    freq.put("sp", 110);
    freq.put("sv", 77);
    freq.put("py ", 4);
    freq.put("ur ", 6);
    freq.put(" Sö", 5);
    freq.put("uu ", 193);
    freq.put(" Sä", 9);
    freq.put("pyy", 20);
    freq.put("sm", 56);
    freq.put("aww", 3);
    freq.put("pyr", 6);
    freq.put("pys", 24);
    freq.put("pyt", 4);
    freq.put("pyl", 3);
    freq.put("ure", 16);
    freq.put("urg", 4);
    freq.put("ura", 98);
    freq.put("urm", 15);
    freq.put("urn", 14);
    freq.put("uro", 54);
    freq.put("urh", 27);
    freq.put("uri", 111);
    freq.put("urj", 5);
    freq.put("urk", 43);
    freq.put("urt", 12);
    freq.put("uru", 29);
    freq.put("urv", 20);
    freq.put("urp", 6);
    freq.put("urr", 10);
    freq.put("urs", 14);
    freq.put("nge", 28);
    freq.put("nga", 24);
    freq.put("ngl", 15);
    freq.put("ngo", 12);
    freq.put("ngi", 70);
    freq.put("sh ", 4);
    freq.put("ngs", 3);
    freq.put("ngy", 3);
    freq.put("keä", 12);
    freq.put("ävi", 26);
    freq.put("shu", 3);
    freq.put("äve", 18);
    freq.put("äva", 8);
    freq.put("sha", 6);
    freq.put("ävy", 7);
    freq.put("she", 5);
    freq.put("shi", 10);
    freq.put("sho", 9);
    freq.put("ke ", 23);
    freq.put("lup", 14);
    freq.put("lur", 3);
    freq.put("lus", 102);
    freq.put("lut", 222);
    freq.put("luu", 66);
    freq.put("luv", 19);
    freq.put("lua", 75);
    freq.put("lub", 10);
    freq.put("lue", 47);
    freq.put("lui", 30);
    freq.put("luj", 12);
    freq.put("luk", 68);
    freq.put("lul", 17);
    freq.put("lum", 17);
    freq.put("lun", 58);
    freq.put("luo", 68);
    freq.put("ken", 149);
    freq.put("kem", 45);
    freq.put("kel", 94);
    freq.put("kek", 22);
    freq.put("kej", 12);
    freq.put("kei", 123);
    freq.put("keh", 30);
    freq.put("kee", 161);
    freq.put("ked", 13);
    freq.put("kea", 68);
    freq.put("key", 6);
    freq.put("kev", 25);
    freq.put("keu", 42);
    freq.put("ket", 49);
    freq.put("kes", 126);
    freq.put("ker", 123);
    freq.put("kep", 3);
    freq.put("uum", 33);
    freq.put("ävä", 120);
    freq.put("lu ", 109);
    freq.put("ähe", 58);
    freq.put("ot ", 81);
    freq.put("Loi", 7);
    freq.put("Lon", 4);
    freq.put("Los", 4);
    freq.put("Lop", 8);
    freq.put("Lot", 3);
    freq.put("An ", 4);
    freq.put("yas", 3);
    freq.put("yan", 3);
    freq.put("oth", 3);
    freq.put("oti", 107);
    freq.put("otk", 42);
    freq.put("oto", 58);
    freq.put("ota", 130);
    freq.put("ote", 93);
    freq.put("ots", 28);
    freq.put("ott", 237);
    freq.put("otu", 33);
    freq.put("And", 7);
    freq.put("Ang", 5);
    freq.put("Ann", 15);
    freq.put("Ano", 6);
    freq.put("Ank", 3);
    freq.put("Ant", 17);
    freq.put("You", 11);
    freq.put("Yor", 4);
    freq.put("i", 23179);
    freq.put(" xD", 14);
    freq.put("uMo", 4);
    freq.put("Be", 19);
    freq.put("Ba", 16);
    freq.put("Bl", 25);
    freq.put("Bo", 9);
    freq.put("Bi", 8);
    freq.put("Bu", 14);
    freq.put("Br", 18);
    freq.put("B ", 18);
    freq.put(" x ", 7);
    freq.put("TI ", 3);
    freq.put("U ", 19);
    freq.put("Bä", 8);
    freq.put("dui", 3);
    freq.put("Uu", 78);
    freq.put("Up", 5);
    freq.put("Us", 6);
    freq.put("Ur", 24);
    freq.put("Ul", 10);
    freq.put("Un", 16);
    freq.put("pt", 18);
    freq.put("ea ", 70);
    freq.put("h ", 95);
    freq.put("eah", 5);
    freq.put("eak", 8);
    freq.put("hy", 221);
    freq.put("eam", 20);
    freq.put("eal", 13);
    freq.put("ean", 20);
    freq.put("eaa", 15);
    freq.put("hs", 4);
    freq.put("eac", 3);
    freq.put("hv", 38);
    freq.put("ead", 5);
    freq.put("ht", 560);
    freq.put("hu", 249);
    freq.put("hj", 81);
    freq.put("hk", 108);
    freq.put("hh", 38);
    freq.put("hi", 340);
    freq.put("hn", 31);
    freq.put("ho", 219);
    freq.put("hl", 23);
    freq.put("hm", 114);
    freq.put("eas", 29);
    freq.put("ear", 7);
    freq.put("eat", 28);
    freq.put("hd", 295);
    freq.put("he", 499);
    freq.put("dma", 3);
    freq.put("pi", 707);
    freq.put("duu", 5);
    freq.put("Lui", 6);
    freq.put(" jn", 5);
    freq.put("hn ", 3);
    freq.put(" Uu", 76);
    freq.put(" Up", 4);
    freq.put(" Ur", 24);
    freq.put(" Us", 6);
    freq.put(" Ul", 9);
    freq.put(" Un", 14);
    freq.put("hö", 11);
    freq.put("jiä", 6);
    freq.put("hä", 232);
    freq.put("sää", 69);
    freq.put("hne", 3);
    freq.put("hni", 4);
    freq.put("hny", 17);
    freq.put("MS ", 5);
    freq.put("Ehd", 3);
    freq.put("Ehk", 9);
    freq.put("aua", 27);
    freq.put("aue", 3);
    freq.put("aud", 34);
    freq.put("auh", 45);
    freq.put("auk", 85);
    freq.put("aum", 3);
    freq.put("aul", 45);
    freq.put("up ", 10);
    freq.put("aun", 25);
    freq.put("aup", 90);
    freq.put("aus", 112);
    freq.put("aur", 37);
    freq.put("aut", 150);
    freq.put("auv", 10);
    freq.put("meä", 6);
    freq.put("ble", 10);
    freq.put("upo", 9);
    freq.put("upl", 6);
    freq.put("upi", 13);
    freq.put("upe", 23);
    freq.put("upa", 56);
    freq.put("äpä", 22);
    freq.put("upu", 32);
    freq.put("ups", 4);
    freq.put("upp", 44);
    freq.put("me ", 114);
    freq.put("Pul", 3);
    freq.put("neo", 8);
    freq.put("Pun", 16);
    freq.put("Puo", 9);
    freq.put("Puh", 5);
    freq.put("nek", 36);
    freq.put("neh", 4);
    freq.put("Puk", 6);
    freq.put("ned", 8);
    freq.put("nee", 125);
    freq.put("nea", 7);
    freq.put("ney", 7);
    freq.put("nev", 13);
    freq.put("dr ", 4);
    freq.put("net", 109);
    freq.put("neu", 16);
    freq.put("ner", 34);
    freq.put("nes", 45);
    freq.put("Pus", 3);
    freq.put("mee", 39);
    freq.put("med", 28);
    freq.put("oru", 23);
    freq.put("mea", 13);
    freq.put("mel", 51);
    freq.put("meo", 5);
    freq.put("men", 319);
    freq.put("mei", 96);
    freq.put("meh", 5);
    freq.put("mek", 15);
    freq.put("met", 77);
    freq.put("mes", 68);
    freq.put("mer", 75);
    freq.put("äpu", 5);
    freq.put("äpp", 12);
    freq.put("upä", 6);
    freq.put("äpy", 3);
    freq.put("sju", 4);
    freq.put("dri", 9);
    freq.put("äpe", 6);
    freq.put("sjo", 6);
    freq.put("äpa", 5);
    freq.put("dre", 5);
    freq.put("äpi", 10);
    freq.put("kg ", 4);
    freq.put("org", 6);
    freq.put("Ste", 14);
    freq.put("Sta", 24);
    freq.put("Sto", 7);
    freq.put("Sti", 3);
    freq.put("Stu", 5);
    freq.put("Str", 12);
    freq.put("V", 447);
    freq.put("rin", 172);
    freq.put("rio", 5);
    freq.put("Tin", 4);
    freq.put("Tii", 5);
    freq.put("Lie", 5);
    freq.put("Lib", 3);
    freq.put("Lin", 13);
    freq.put("Lii", 21);
    freq.put("Lik", 3);
    freq.put("ov ", 4);
    freq.put("Lip", 10);
    freq.put("Lis", 17);
    freq.put("Kaa", 6);
    freq.put("Kak", 5);
    freq.put("Kaj", 3);
    freq.put("Kai", 29);
    freq.put("Kah", 3);
    freq.put("Kan", 24);
    freq.put("Kal", 19);
    freq.put("Kas", 4);
    freq.put("Kar", 29);
    freq.put("Kap", 9);
    freq.put("Kav", 3);
    freq.put("Kau", 27);
    freq.put("Kat", 20);
    freq.put("ovs", 4);
    freq.put("ovu", 9);
    freq.put("ova", 109);
    freq.put("ove", 43);
    freq.put("ovi", 46);
    freq.put("ovo", 3);
    freq.put("All", 3);
    freq.put("Alk", 7);
    freq.put("Alf", 3);
    freq.put("Ale", 7);
    freq.put("Ala", 8);
    freq.put("Alu", 4);
    freq.put("Ymp", 3);
    freq.put(" id", 15);
    freq.put("isö", 19);
    freq.put("isä", 86);
    freq.put("Wow", 3);
    freq.put("Wor", 4);
    freq.put("Vär", 16);
    freq.put("Ään", 4);
    freq.put("SS ", 7);
    freq.put("eul", 12);
    freq.put("is ", 227);
    freq.put("fik", 6);
    freq.put("TK ", 4);
    freq.put("isy", 12);
    freq.put("iss", 343);
    freq.put("isr", 8);
    freq.put("isp", 20);
    freq.put("isv", 4);
    freq.put("isu", 120);
    freq.put("ist", 1014);
    freq.put("isk", 112);
    freq.put("isi", 420);
    freq.put("ish", 8);
    freq.put("iso", 51);
    freq.put("isn", 5);
    freq.put("ism", 27);
    freq.put("isl", 5);
    freq.put("isa", 63);
    freq.put("ise", 499);
    freq.put("ily", 19);
    freq.put("Väl", 3);
    freq.put("tyä", 21);
    freq.put("työ", 86);
    freq.put("ämä", 145);
    freq.put("Läh", 15);
    freq.put("Län", 3);
    freq.put("ty ", 66);
    freq.put("FK ", 4);
    freq.put("do ", 5);
    freq.put("tyl", 6);
    freq.put("tym", 30);
    freq.put("tyn", 38);
    freq.put("tyh", 8);
    freq.put("tyi", 39);
    freq.put("tyj", 3);
    freq.put("tyk", 56);
    freq.put("tye", 7);
    freq.put("tyy", 100);
    freq.put("tyt", 23);
    freq.put("tyv", 20);
    freq.put("tyr", 3);
    freq.put("tys", 110);
    freq.put("äma", 7);
    freq.put("doi", 10);
    freq.put("don", 27);
    freq.put("äme", 16);
    freq.put("dol", 37);
    freq.put("Lää", 3);
    freq.put("ämi", 16);
    freq.put("m", 6248);
    freq.put("ämm", 24);
    freq.put("ämp", 14);
    freq.put("ämy", 4);
    freq.put("dop", 3);
    freq.put("dow", 11);
    freq.put("dot", 65);
    freq.put(" We", 5);
    freq.put(" Wa", 10);
    freq.put(" Wo", 8);
    freq.put(" Wh", 5);
    freq.put(" Wi", 23);
    freq.put(" W ", 3);
    freq.put("omä", 4);
    freq.put("mös", 5);
    freq.put("bar", 11);
    freq.put("bas", 6);
    freq.put("bac", 5);
    freq.put("baa", 9);
    freq.put("ban", 6);
    freq.put("bal", 3);
    freq.put("mök", 6);
    freq.put("om ", 16);
    freq.put("Run", 3);
    freq.put("Ruo", 12);
    freq.put("un ", 466);
    freq.put("Rus", 6);
    freq.put("Ruu", 4);
    freq.put("omb", 3);
    freq.put("C", 118);
    freq.put("ome", 182);
    freq.put("omi", 99);
    freq.put("omo", 15);
    freq.put("omn", 3);
    freq.put("omm", 56);
    freq.put("omp", 11);
    freq.put("omu", 34);
    freq.put("uns", 12);
    freq.put("unt", 261);
    freq.put("unu", 54);
    freq.put("una", 100);
    freq.put("und", 10);
    freq.put("une", 35);
    freq.put("ung", 23);
    freq.put("unh", 8);
    freq.put("uni", 56);
    freq.put("unk", 34);
    freq.put("unm", 3);
    freq.put("unn", 151);
    freq.put("uno", 26);
    freq.put("iö", 33);
    freq.put("iä", 203);
    freq.put("C ", 29);
    freq.put("kiä", 24);
    freq.put("äry", 16);
    freq.put("Ci", 9);
    freq.put("Ch", 17);
    freq.put("Vä", 43);
    freq.put("Cl", 5);
    freq.put("ärp", 3);
    freq.put("ärs", 14);
    freq.put("ärr", 10);
    freq.put("ärt", 7);
    freq.put("ärv", 9);
    freq.put("äri", 118);
    freq.put("ärk", 42);
    freq.put("ärj", 43);
    freq.put("sli", 8);
    freq.put("akr", 4);
    freq.put("ära", 6);
    freq.put("sle", 9);
    freq.put("äre", 20);
    freq.put("sla", 14);
    freq.put("Cu", 8);
    freq.put("iy", 14);
    freq.put("ix", 8);
    freq.put("Naa", 3);
    freq.put("ip", 231);
    freq.put("is", 3055);
    freq.put("Nai", 33);
    freq.put("Nan", 3);
    freq.put("it", 2418);
    freq.put("iv", 602);
    freq.put("ii", 1573);
    freq.put("ih", 446);
    freq.put("ik", 1587);
    freq.put("ij", 200);
    freq.put("im", 677);
    freq.put("il", 1272);
    freq.put("Nat", 5);
    freq.put("in", 3824);
    freq.put("ia", 1059);
    freq.put("ic", 65);
    freq.put("ib", 22);
    freq.put("ie", 908);
    freq.put("id", 282);
    freq.put("ig", 69);
    freq.put("if", 18);
    freq.put("V ", 49);
    freq.put("iP", 24);
    freq.put("iS", 3);
    freq.put("iO", 3);
    freq.put("iC", 3);
    freq.put("öö ", 3);
    freq.put("kis", 125);
    freq.put("kir", 116);
    freq.put("kip", 28);
    freq.put("kiv", 63);
    freq.put("kiu", 4);
    freq.put("kit", 70);
    freq.put("kik", 23);
    freq.put("kij", 40);
    freq.put("kii", 122);
    freq.put("kio", 6);
    freq.put("kin", 367);
    freq.put("kim", 34);
    freq.put("kil", 75);
    freq.put("i ", 3769);
    freq.put("kia", 85);
    freq.put("kie", 68);
    freq.put("kid", 6);
    freq.put("Va", 134);
    freq.put("Ve", 56);
    freq.put("Vi", 101);
    freq.put("Vo", 48);
    freq.put("Vu", 19);
    freq.put("slä", 3);
    freq.put("Vy", 4);
    freq.put("ärä", 48);
    freq.put("nk ", 8);
    freq.put("yen", 4);
    freq.put("yea", 3);
    freq.put("op ", 5);
    freq.put("yes", 7);
    freq.put("opu", 54);
    freq.put("opp", 102);
    freq.put("opy", 4);
    freq.put("ope", 78);
    freq.put("opa", 45);
    freq.put("opo", 14);
    freq.put("opi", 74);
    freq.put("Art", 4);
    freq.put("Arv", 3);
    freq.put("Ara", 3);
    freq.put("Arc", 3);
    freq.put("Are", 7);
    freq.put("Ari", 5);
    freq.put("Ark", 3);
    freq.put("Arm", 3);
    freq.put("www", 15);
    freq.put("eep", 7);
    freq.put("eem", 29);
    freq.put("eek", 38);
    freq.put("Tur", 33);
    freq.put("opä", 9);
    freq.put("ww ", 15);
    freq.put("idä", 30);
    freq.put("TE ", 4);
    freq.put("Z", 4);
    freq.put("nki", 218);
    freq.put("Win", 10);
    freq.put("Wil", 5);
    freq.put("Wii", 3);
    freq.put(" Yö", 7);
    freq.put("di ", 24);
    freq.put("dil", 9);
    freq.put("din", 55);
    freq.put("dio", 40);
    freq.put("äon", 7);
    freq.put("dii", 5);
    freq.put("dik", 10);
    freq.put("did", 3);
    freq.put("die", 9);
    freq.put("dig", 5);
    freq.put("dia", 47);
    freq.put("dic", 3);
    freq.put("dit", 25);
    freq.put("dir", 3);
    freq.put("dis", 60);
    freq.put(" Yh", 20);
    freq.put(" Yk", 10);
    freq.put(" Yl", 46);
    freq.put(" Ym", 4);
    freq.put(" Yo", 16);
    freq.put(" Ya", 4);
    freq.put("Gre", 6);
    freq.put("Gra", 10);
    freq.put(" Yr", 9);
    freq.put(" Ys", 4);
    freq.put(" Yu", 4);
    freq.put("sjä", 5);
    freq.put("bou", 4);
    freq.put("Wo", 8);
    freq.put("bok", 6);
    freq.put("bol", 5);
    freq.put("bon", 9);
    freq.put("boo", 30);
    freq.put("oo ", 210);
    freq.put("ayl", 3);
    freq.put("aye", 3);
    freq.put("Pyö", 7);
    freq.put("ul ", 14);
    freq.put("ays", 3);
    freq.put("ood", 14);
    freq.put("oog", 22);
    freq.put("Ben", 3);
    freq.put("oom", 8);
    freq.put("ool", 13);
    freq.put("ooo", 24);
    freq.put("Bea", 4);
    freq.put("ook", 36);
    freq.put("oot", 28);
    freq.put("Bey", 3);
    freq.put("oop", 29);
    freq.put("oos", 17);
    freq.put("oor", 5);
    freq.put("Ber", 3);
    freq.put("yls", 5);
    freq.put("ylp", 7);
    freq.put("flu", 3);
    freq.put("ay ", 11);
    freq.put("ult", 33);
    freq.put("ulu", 159);
    freq.put("ulj", 14);
    freq.put("ulk", 102);
    freq.put("ulh", 3);
    freq.put("uli", 79);
    freq.put("ulo", 75);
    freq.put("ull", 207);
    freq.put("ulm", 10);
    freq.put("ula", 58);
    freq.put("ule", 124);
    freq.put("ma ", 129);
    freq.put("yöt", 47);
    freq.put("Pyy", 3);
    freq.put("nyy", 6);
    freq.put("yöp", 21);
    freq.put("yör", 31);
    freq.put("yös", 78);
    freq.put("nyr", 4);
    freq.put("nys", 3);
    freq.put("Pys", 4);
    freq.put("nyt", 197);
    freq.put("yöd", 10);
    freq.put("nyk", 22);
    freq.put("nyh", 3);
    freq.put("nyn", 6);
    freq.put("nym", 5);
    freq.put("yöl", 9);
    freq.put("yöm", 11);
    freq.put("yön", 33);
    freq.put("yöh", 20);
    freq.put("yök", 24);
    freq.put("map", 5);
    freq.put("mas", 147);
    freq.put("sne", 3);
    freq.put("mau", 7);
    freq.put("mat", 180);
    freq.put("mav", 6);
    freq.put("Urh", 19);
    freq.put("maa", 361);
    freq.put("mag", 3);
    freq.put("maf", 3);
    freq.put("mai", 91);
    freq.put("mah", 54);
    freq.put("mak", 61);
    freq.put("maj", 3);
    freq.put("mam", 4);
    freq.put("mal", 147);
    freq.put("man", 165);
    freq.put("pää", 192);
    freq.put("Ede", 7);
    freq.put("q", 12);
    freq.put("yö ", 24);
    freq.put("ny ", 46);
    freq.put("lse", 5);
    freq.put("lsi", 57);
    freq.put("kk ", 4);
    freq.put(" aa", 41);
    freq.put(" ab", 4);
    freq.put(" ad", 6);
    freq.put(" ag", 3);
    freq.put(" ah", 16);
    freq.put(" ai", 249);
    freq.put(" aj", 72);
    freq.put(" ak", 15);
    freq.put(" al", 181);
    freq.put(" am", 23);
    freq.put(" an", 47);
    freq.put(" ap", 14);
    freq.put(" ar", 48);
    freq.put(" as", 127);
    freq.put(" at", 10);
    freq.put(" au", 67);
    freq.put(" av", 48);
    freq.put(" aw", 3);
    freq.put("ls ", 6);
    freq.put("kku", 112);
    freq.put("Sha", 6);
    freq.put("kko", 200);
    freq.put("kki", 260);
    freq.put("kke", 71);
    freq.put("kka", 305);
    freq.put(" a ", 10);
    freq.put("ödä", 3);
    freq.put("Lup", 3);
    freq.put("lsä", 3);
    freq.put("Luu", 7);
    freq.put("Lue", 7);
    freq.put("lah", 26);
    freq.put("Luk", 19);
    freq.put("Lum", 9);
    freq.put("or ", 10);
    freq.put("Luo", 11);
    freq.put("Ken", 5);
    freq.put("Kem", 4);
    freq.put("Kel", 9);
    freq.put("Kei", 3);
    freq.put("Kes", 32);
    freq.put("Ker", 18);
    freq.put("RT ", 86);
    freq.put("G", 84);
    freq.put("orv", 14);
    freq.put("ort", 52);
    freq.put("kkö", 15);
    freq.put("orr", 9);
    freq.put("ors", 19);
    freq.put("orp", 4);
    freq.put("orn", 11);
    freq.put("oro", 23);
    freq.put("orm", 38);
    freq.put("orj", 14);
    freq.put("ork", 30);
    freq.put("ori", 248);
    freq.put("kkä", 44);
    freq.put("ord", 10);
    freq.put("ore", 28);
    freq.put("ora", 23);
    freq.put("ödy", 7);
    freq.put("App", 13);
    freq.put("Apu", 3);
    freq.put("lau", 83);
    freq.put("Ota", 6);
    freq.put("fei", 3);
    freq.put("JK ", 4);
    freq.put("IS ", 8);
    freq.put("Do", 9);
    freq.put("Dj", 5);
    freq.put("ÄN ", 4);
    freq.put("Di", 17);
    freq.put("Dd", 7);
    freq.put("De", 13);
    freq.put("Da", 20);
    freq.put("Du", 5);
    freq.put("Dr", 5);
    freq.put("D ", 146);
    freq.put("ge ", 9);
    freq.put("We", 8);
    freq.put("Wa", 12);
    freq.put("HA ", 3);
    freq.put("Wi", 23);
    freq.put("Wh", 5);
    freq.put("ges", 4);
    freq.put("ger", 9);
    freq.put("jö", 9);
    freq.put("jä", 380);
    freq.put("gen", 11);
    freq.put("RI ", 3);
    freq.put("gel", 19);
    freq.put("W ", 4);
    freq.put("tu ", 140);
    freq.put("j ", 13);
    freq.put("äi ", 9);
    freq.put("jy", 10);
    freq.put("tup", 13);
    freq.put("ju", 266);
    freq.put("tur", 49);
    freq.put("tus", 154);
    freq.put("tut", 84);
    freq.put("tuu", 156);
    freq.put("tuv", 14);
    freq.put("tuh", 10);
    freq.put("tui", 87);
    freq.put("jn", 5);
    freq.put("jo", 907);
    freq.put("tul", 198);
    freq.put("ji", 68);
    freq.put("jj", 3);
    freq.put("tuo", 103);
    freq.put("je", 234);
    freq.put("tub", 3);
    freq.put("tud", 10);
    freq.put("ja", 1582);
    freq.put("äil", 38);
    freq.put("äim", 6);
    freq.put("äin", 106);
    freq.put("z", 22);
    freq.put("äih", 4);
    freq.put("äij", 12);
    freq.put("äik", 4);
    freq.put("äid", 3);
    freq.put("tuj", 20);
    freq.put("tuk", 94);
    freq.put("äit", 19);
    freq.put("äiv", 160);
    freq.put("äir", 5);
    freq.put("äis", 125);
    freq.put("tun", 197);
    freq.put("tua", 51);
    freq.put("tue", 11);
    freq.put("hd ", 6);
    freq.put("Ts", 18);
    freq.put("hdu", 9);
    freq.put("hdy", 20);
    freq.put("hde", 90);
    freq.put("hda", 9);
    freq.put("hdo", 58);
    freq.put("hdi", 58);
    freq.put("oi ", 224);
    freq.put("pap", 13);
    freq.put("par", 131);
    freq.put("pas", 48);
    freq.put("pat", 31);
    freq.put("pau", 16);
    freq.put("paa", 81);
    freq.put("pad", 5);
    freq.put("pah", 70);
    freq.put("pai", 140);
    freq.put("paj", 3);
    freq.put("pak", 56);
    freq.put("pal", 198);
    freq.put("pan", 83);
    freq.put("oin", 208);
    freq.put("oim", 133);
    freq.put("oil", 75);
    freq.put("oik", 108);
    freq.put("oij", 4);
    freq.put("oii", 3);
    freq.put("oih", 31);
    freq.put("oid", 39);
    freq.put("oiv", 45);
    freq.put("oit", 284);
    freq.put("ois", 251);
    freq.put("oir", 23);
    freq.put("hdö", 5);
    freq.put("uju", 7);
    freq.put("pa ", 51);
    freq.put("hdä", 40);
    freq.put("uje", 16);
    freq.put("uja", 58);
    freq.put("ät ", 156);
    freq.put("röm", 6);
    freq.put("mo ", 17);
    freq.put("mos", 20);
    freq.put("mor", 4);
    freq.put("mop", 7);
    freq.put("mou", 12);
    freq.put("mot", 16);
    freq.put("mok", 8);
    freq.put("moj", 6);
    freq.put("moi", 36);
    freq.put("moo", 8);
    freq.put("mon", 58);
    freq.put("mol", 14);
    freq.put("mob", 4);
    freq.put("moa", 4);
    freq.put("mod", 5);
    freq.put("Nel", 9);
    freq.put("hön", 4);
    freq.put("höp", 3);
    freq.put("Net", 5);
    freq.put("Neu", 10);
    freq.put("Mee", 3);
    freq.put("Med", 6);
    freq.put(" ch", 6);
    freq.put(" co", 33);
    freq.put(" cm", 10);
    freq.put("Mel", 5);
    freq.put(" ca", 6);
    freq.put("Mei", 15);
    freq.put("Mek", 11);
    freq.put("Met", 13);
    freq.put("Mes", 7);
    freq.put("Mer", 19);
    freq.put("Ne ", 7);
    freq.put("Me ", 4);
    freq.put("km ", 4);
    freq.put("VD ", 7);
    freq.put("yyt", 53);
    freq.put("yyp", 79);
    freq.put("yys", 46);
    freq.put("yyr", 7);
    freq.put("yyy", 7);
    freq.put("yyd", 19);
    freq.put("yym", 8);
    freq.put("yyl", 24);
    freq.put("yyn", 49);
    freq.put("yyh", 8);
    freq.put("yyk", 8);
    freq.put("Aa", 23);
    freq.put("na ", 356);
    freq.put("yy ", 76);
    freq.put("Af", 4);
    freq.put("Avo", 6);
    freq.put("Ava", 3);
    freq.put("sve", 7);
    freq.put("An", 63);
    freq.put("As", 22);
    freq.put("Ove", 3);
    freq.put("US ", 5);
    freq.put("u", 11032);
    freq.put("öjä", 15);
    freq.put("Vak", 3);
    freq.put("Vai", 20);
    freq.put("Van", 14);
    freq.put("Val", 40);
    freq.put("Vaa", 18);
    freq.put("Var", 15);
    freq.put("Vas", 9);
    freq.put("Vap", 6);
    freq.put("Vau", 3);
    freq.put("hy ", 4);
    freq.put("ws ", 9);
    freq.put("täk", 22);
    freq.put("täj", 59);
    freq.put("täi", 63);
    freq.put("täh", 42);
    freq.put("ium", 5);
    freq.put("tän", 180);
    freq.put("täm", 82);
    freq.put("täl", 28);
    freq.put("täe", 5);
    freq.put("täy", 49);
    freq.put("TA ", 5);
    freq.put("täs", 79);
    freq.put("tär", 26);
    freq.put("ius", 13);
    freq.put("täp", 11);
    freq.put("täv", 98);
    freq.put("tät", 33);
    freq.put("hye", 4);
    freq.put("hyi", 7);
    freq.put("hyl", 10);
    freq.put("hym", 3);
    freq.put("hyp", 4);
    freq.put("SI ", 3);
    freq.put("hyt", 8);
    freq.put("hyv", 145);
    freq.put("hyy", 5);
    freq.put("aba", 4);
    freq.put("abi", 6);
    freq.put("abl", 12);
    freq.put("abo", 3);
    freq.put("abr", 3);
    freq.put("K", 927);
    freq.put("tää", 423);
    freq.put("ujä", 4);
    freq.put("gga", 3);
    freq.put("ggi", 3);
    freq.put("lkk", 28);
    freq.put("Nok", 30);
    freq.put("hyö", 23);
    freq.put("eyd", 7);
    freq.put("twe", 13);
    freq.put("eyk", 4);
    freq.put("twi", 27);
    freq.put("eyl", 3);
    freq.put("eyo", 3);
    freq.put("eyn", 3);
    freq.put("eys", 20);
    freq.put("eyt", 5);
    freq.put("äk ", 3);
    freq.put("ryö", 3);
    freq.put("Työ", 10);
    freq.put("ey ", 15);
    freq.put("äku", 8);
    freq.put("äks", 34);
    freq.put("der", 20);
    freq.put("des", 96);
    freq.put("det", 52);
    freq.put("äky", 18);
    freq.put("dei", 5);
    freq.put("dek", 19);
    freq.put("del", 76);
    freq.put("dem", 10);
    freq.put("den", 254);
    freq.put("deo", 37);
    freq.put("dea", 15);
    freq.put("dee", 9);
    freq.put("äki", 75);
    freq.put("ryn", 8);
    freq.put("iPa", 12);
    freq.put("ryh", 33);
    freq.put("ryi", 5);
    freq.put("iPh", 11);
    freq.put("Tyy", 86);
    freq.put("ryy", 5);
    freq.put("Tyt", 3);
    freq.put("ryt", 4);
    freq.put("rys", 4);
    freq.put("äkö", 30);
    freq.put("ry ", 8);
    freq.put("äkä", 25);
    freq.put("uh ", 10);
    freq.put("ok ", 25);
    freq.put("oks", 78);
    freq.put("okr", 6);
    freq.put("oku", 86);
    freq.put("uha", 33);
    freq.put("oky", 6);
    freq.put("uho", 13);
    freq.put("uhl", 18);
    freq.put("uhm", 3);
    freq.put("uhk", 22);
    freq.put("uhh", 3);
    freq.put("uhi", 10);
    freq.put("oka", 110);
    freq.put("uht", 21);
    freq.put("uhu", 48);
    freq.put("uhr", 6);
    freq.put("oki", 89);
    freq.put("mmä", 79);
    freq.put("okk", 29);
    freq.put("oko", 146);
    freq.put("PC ", 3);
    freq.put("mm ", 21);
    freq.put("Oma", 5);
    freq.put("E ", 34);
    freq.put("sbu", 4);
    freq.put("mmu", 9);
    freq.put("mmm", 5);
    freq.put("ake", 86);
    freq.put("mmo", 18);
    freq.put("mmi", 85);
    freq.put("Une", 3);
    freq.put("mme", 83);
    freq.put("Uni", 7);
    freq.put("Unk", 3);
    freq.put("mma", 96);
    freq.put("Em", 9);
    freq.put("El", 52);
    freq.put("En", 81);
    freq.put("Ei", 84);
    freq.put("Eh", 15);
    freq.put("Ek", 4);
    freq.put("Ee", 6);
    freq.put("Ed", 11);
    freq.put("XL ", 3);
    freq.put("Ex", 4);
    freq.put("Eu", 22);
    freq.put("Et", 16);
    freq.put("Ep", 7);
    freq.put("Es", 25);
    freq.put("Er", 14);
    freq.put(" el", 90);
    freq.put(" em", 4);
    freq.put(" en", 288);
    freq.put("koj", 28);
    freq.put(" eh", 64);
    freq.put(" ei", 377);
    freq.put("koo", 47);
    freq.put(" ek", 21);
    freq.put(" ed", 56);
    freq.put(" ee", 24);
    freq.put("X ", 10);
    freq.put("koe", 5);
    freq.put(" ea", 3);
    freq.put("kof", 3);
    freq.put(" ex", 5);
    freq.put(" et", 305);
    freq.put(" eu", 27);
    freq.put("kos", 115);
    freq.put("kor", 67);
    freq.put(" ep", 27);
    freq.put("kot", 80);
    freq.put(" er", 47);
    freq.put("kov", 44);
    freq.put("b", 390);
    freq.put("kä", 644);
    freq.put("ko ", 367);
    freq.put("öhö", 3);
    freq.put(" e ", 5);
    freq.put("kö", 115);
    freq.put("öhä", 21);
    freq.put("k ", 107);
    freq.put("Kir", 30);
    freq.put("Kip", 4);
    freq.put("Kiv", 5);
    freq.put("Kii", 41);
    freq.put("ujo", 7);
    freq.put("Kin", 6);
    freq.put("Kil", 4);
    freq.put("öh ", 3);
    freq.put("Kie", 14);
    freq.put("Atl", 3);
    freq.put("ka", 2509);
    freq.put("kg", 4);
    freq.put("kf", 4);
    freq.put("ke", 1129);
    freq.put("kd", 3);
    freq.put("kk", 1014);
    freq.put("ki", 1555);
    freq.put("kh", 9);
    freq.put("ko", 1537);
    freq.put("kn", 22);
    freq.put("km", 5);
    freq.put("kl", 78);
    freq.put("ks", 934);
    freq.put("kr", 44);
    freq.put("kp", 6);
    freq.put("ku", 1324);
    freq.put("kt", 43);
    freq.put("öhe", 4);
    freq.put("ky", 248);
    freq.put("öha", 3);
    freq.put(" Bä", 8);
    freq.put("Opp", 4);
    freq.put("Ope", 4);
    freq.put("Opi", 3);
    freq.put("ikö", 16);
    freq.put("ikä", 127);
    freq.put(" Be", 18);
    freq.put(" Ba", 16);
    freq.put(" Bl", 25);
    freq.put(" Bo", 7);
    freq.put(" Bi", 8);
    freq.put(" Bu", 14);
    freq.put("ik ", 15);
    freq.put(" Br", 18);
    freq.put("DD ", 18);
    freq.put("MF ", 4);
    freq.put("ikr", 6);
    freq.put(" B ", 4);
    freq.put("iku", 86);
    freq.put("iky", 4);
    freq.put("ika", 351);
    freq.put("ike", 180);
    freq.put("Sen", 12);
    freq.put("ikk", 401);
    freq.put("iki", 98);
    freq.put("iko", 172);
    freq.put("ikl", 4);
    freq.put("DDd", 3);
    freq.put("nhä", 4);
    freq.put("lbu", 5);
    freq.put("ga ", 9);
    freq.put("ram", 16);
    freq.put("syä", 4);
    freq.put("gau", 3);
    freq.put("gat", 6);
    freq.put("gas", 18);
    freq.put("gar", 4);
    freq.put("gan", 21);
    freq.put("gam", 4);
    freq.put("gal", 4);
    freq.put("syö", 27);
    freq.put("gai", 3);
    freq.put("gaa", 11);
    freq.put("fut", 5);
    freq.put("sy ", 14);
    freq.put("Ira", 3);
    freq.put("Upe", 4);
    freq.put("syd", 5);
    freq.put("syk", 28);
    freq.put("syi", 8);
    freq.put("syh", 4);
    freq.put("syn", 53);
    freq.put("sym", 19);
    freq.put("syl", 3);
    freq.put("sys", 4);
    freq.put("syr", 5);
    freq.put("syv", 6);
    freq.put("syt", 23);
    freq.put("syy", 56);
    freq.put("ew ", 8);
    freq.put("äet", 4);
    freq.put("äel", 4);
    freq.put("äem", 3);
    freq.put("äen", 19);
    freq.put("y", 3922);
    freq.put("eää", 8);
    freq.put("ldo", 3);
    freq.put("ldm", 3);
    freq.put("ad", 119);
    freq.put("rga", 8);
    freq.put("peä", 7);
    freq.put("rgi", 20);
    freq.put("bin", 9);
    freq.put("bil", 12);
    freq.put("ld ", 6);
    freq.put("Dii", 4);
    freq.put("bii", 13);
    freq.put("Dig", 7);
    freq.put("bic", 3);
    freq.put("bia", 9);
    freq.put("bit", 5);
    freq.put("bis", 4);
    freq.put("eäk", 6);
    freq.put("eän", 5);
    freq.put("eäs", 5);
    freq.put("oe ", 3);
    freq.put("pet", 41);
    freq.put("peu", 8);
    freq.put("per", 150);
    freq.put("pes", 24);
    freq.put("pel", 162);
    freq.put("pen", 12);
    freq.put("peh", 3);
    freq.put("pei", 17);
    freq.put("pek", 6);
    freq.put("ped", 3);
    freq.put("pee", 25);
    freq.put("ape", 35);
    freq.put("pea", 28);
    freq.put("eä ", 24);
    freq.put("ufo", 3);
    freq.put("oes", 6);
    freq.put("uff", 3);
    freq.put("oet", 6);
    freq.put("oeh", 7);
    freq.put("oen", 4);
    freq.put("uft", 3);
    freq.put("ä", 9577);
    freq.put("am", 572);
    freq.put("Hul", 4);
    freq.put("pe ", 15);
    freq.put("nsi", 92);
    freq.put("lyö", 4);
    freq.put("nsk", 13);
    freq.put("nsl", 4);
    freq.put("nso", 11);
    freq.put("nsa", 99);
    freq.put("nse", 12);
    freq.put("nsf", 3);
    freq.put("Hui", 13);
    freq.put("lyä", 7);
    freq.put("nsp", 3);
    freq.put("nss", 75);
    freq.put("nst", 7);
    freq.put("nsu", 14);
    freq.put("Oon", 11);
    freq.put("Oot", 4);
    freq.put("fer", 4);
    freq.put(" R ", 3);
    freq.put("ns ", 21);
    freq.put("usp", 26);
    freq.put("Ulk", 6);
    freq.put("Flo", 6);
    freq.put("Fla", 3);
    freq.put("lyt", 24);
    freq.put("lyv", 3);
    freq.put("lyw", 4);
    freq.put("lyp", 7);
    freq.put("lys", 12);
    freq.put("nsä", 25);
    freq.put("lyy", 10);
    freq.put("Nyt", 39);
    freq.put("Nyk", 5);
    freq.put("New", 7);
    freq.put(" e", 1426);
    freq.put("lym", 6);
    freq.put("lyn", 5);
    freq.put("lyh", 13);
    freq.put("lyi", 3);
    freq.put("lyk", 9);
    freq.put("Mas", 3);
    freq.put("Mar", 42);
    freq.put("Mau", 4);
    freq.put("Mat", 48);
    freq.put("Maa", 27);
    freq.put("Mac", 5);
    freq.put(" ge", 3);
    freq.put("Mad", 4);
    freq.put("Mag", 3);
    freq.put(" ga", 7);
    freq.put("Mai", 7);
    freq.put("Mah", 3);
    freq.put("Mak", 8);
    freq.put("Mal", 14);
    freq.put("Man", 11);
    freq.put("ly ", 25);
    freq.put(" b", 114);
    freq.put(" c", 64);
    freq.put("Men", 6);
    freq.put(" f", 130);
    freq.put(" g", 32);
    freq.put(" d", 63);
    freq.put("ön ", 50);
    freq.put(" j", 1776);
    freq.put(" k", 2916);
    freq.put(" h", 1062);
    freq.put(" i", 553);
    freq.put(" n", 1088);
    freq.put(" o", 2000);
    freq.put(" l", 1062);
    freq.put(" m", 2124);
    freq.put(" r", 364);
    freq.put(" s", 2172);
    freq.put(" p", 1676);
    freq.put(" q", 4);
    freq.put(" v", 1752);
    freq.put(" w", 37);
    freq.put(" t", 2440);
    freq.put(" u", 322);
    freq.put(" x", 24);
    freq.put(" y", 422);
    freq.put(" B", 125);
    freq.put(" C", 114);
    freq.put(" A", 413);
    freq.put(" F", 144);
    freq.put(" G", 83);
    freq.put(" D", 314);
    freq.put(" E", 401);
    freq.put(" J", 389);
    freq.put(" K", 924);
    freq.put(" H", 620);
    freq.put(" I", 239);
    freq.put(" N", 424);
    freq.put(" O", 358);
    freq.put(" L", 389);
    freq.put(" M", 752);
    freq.put(" R", 278);
    freq.put(" S", 777);
    freq.put(" P", 587);
    freq.put(" Q", 4);
    freq.put(" V", 445);
    freq.put(" W", 64);
    freq.put(" T", 1054);
    freq.put(" U", 158);
    freq.put(" Z", 4);
    freq.put(" X", 51);
    freq.put(" Y", 153);
    freq.put("öne", 7);
    freq.put("öna", 3);
    freq.put("önk", 3);
    freq.put("önh", 4);
    freq.put("önt", 17);
    freq.put("öns", 3);
    freq.put(" ä", 91);
    freq.put(" ö", 9);
    freq.put(" Ä", 19);
    freq.put("fat", 6);
    freq.put(" Ö", 5);
    freq.put("Org", 3);
    freq.put("önä", 5);
    freq.put(" Do", 8);
    freq.put("Vet", 4);
    freq.put("Ver", 20);
    freq.put("Ves", 6);
    freq.put(" Di", 17);
    freq.put(" De", 12);
    freq.put(" Dd", 4);
    freq.put(" Da", 20);
    freq.put("ii ", 126);
    freq.put("Ven", 13);
    freq.put(" Du", 5);
    freq.put(" Dr", 5);
    freq.put("Vei", 6);
    freq.put("cha", 6);
    freq.put("Fr", 8);
    freq.put("che", 7);
    freq.put("chi", 7);
    freq.put("Fa", 36);
    freq.put("chs", 3);
    freq.put("Fe", 8);
    freq.put("Fi", 31);
    freq.put("Fl", 13);
    freq.put("Yö", 7);
    freq.put("iit", 234);
    freq.put("iiv", 35);
    freq.put("iip", 9);
    freq.put("iis", 125);
    freq.put("iir", 51);
    freq.put(" D ", 77);
    freq.put("iid", 21);
    freq.put("iig", 24);
    freq.put("iia", 22);
    freq.put("iim", 59);
    freq.put("iil", 44);
    freq.put("iin", 522);
    freq.put("iii", 28);
    freq.put("iih", 30);
    freq.put("iik", 223);
    freq.put("ch ", 6);
    freq.put("f", 353);
    freq.put("F ", 12);
    freq.put("dös", 3);
    freq.put("SM ", 6);
    freq.put("Yh", 20);
    freq.put("Yk", 10);
    freq.put("Ym", 4);
    freq.put("afi", 13);
    freq.put("Yo", 16);
    freq.put("Ya", 4);
    freq.put("afe", 7);
    freq.put("aff", 4);
    freq.put("tai", 327);
    freq.put("apä", 15);
    freq.put("Ys", 4);
    freq.put("Yr", 9);
    freq.put("Yu", 4);
    freq.put("mä ", 159);
    freq.put("iiä", 9);
    freq.put("sip", 11);
    freq.put("Y ", 5);
    freq.put("da ", 36);
    freq.put("lP", 9);
    freq.put("lf", 8);
    freq.put("tso", 48);
    freq.put("ld", 20);
    freq.put("le", 1466);
    freq.put("lb", 8);
    freq.put("euk", 14);
    freq.put("tsi", 97);
    freq.put("eud", 19);
    freq.put("ll", 2238);
    freq.put("lm", 324);
    freq.put("lj", 138);
    freq.put("lk", 418);
    freq.put("lh", 10);
    freq.put("li", 1761);
    freq.put("lv", 109);
    freq.put("Älk", 3);
    freq.put("lt", 430);
    freq.put("lu", 946);
    freq.put("lr", 4);
    freq.put("ls", 78);
    freq.put("lp", 62);
    freq.put("eut", 28);
    freq.put("tsu", 16);
    freq.put("eus", 22);
    freq.put("eur", 85);
    freq.put("daa", 8);
    freq.put("dal", 9);
    freq.put("dam", 4);
    freq.put("dan", 14);
    freq.put("dat", 16);
    freq.put("dar", 3);
    freq.put("das", 17);
    freq.put("day", 4);
    freq.put("l ", 215);
    freq.put("ts ", 11);
    freq.put("lie", 25);
    freq.put("PA ", 3);
    freq.put("lä", 765);
    freq.put("rey", 3);
    freq.put("res", 37);
    freq.put("rep", 8);
    freq.put("rev", 3);
    freq.put("ret", 25);
    freq.put("reu", 6);
    freq.put("rej", 4);
    freq.put("rek", 14);
    freq.put("reh", 6);
    freq.put("rei", 80);
    freq.put("ren", 35);
    freq.put("rel", 15);
    freq.put("rem", 33);
    freq.put("Tub", 8);
    freq.put("rea", 19);
    freq.put("ref", 4);
    freq.put("red", 6);
    freq.put("ree", 58);
    freq.put("que", 3);
    freq.put("ylö", 3);
    freq.put("re ", 34);
    freq.put("ud ", 6);
    freq.put("og ", 4);
    freq.put("miä", 10);
    freq.put("lic", 4);
    freq.put("udu", 16);
    freq.put("ogl", 22);
    freq.put("uda", 10);
    freq.put("ogi", 39);
    freq.put("ude", 160);
    freq.put("udj", 3);
    freq.put("ogg", 4);
    freq.put("udi", 33);
    freq.put("udo", 6);
    freq.put("nun", 26);
    freq.put("nul", 10);
    freq.put("Pap", 5);
    freq.put("Par", 17);
    freq.put("Pas", 3);
    freq.put("Pat", 7);
    freq.put("Pau", 5);
    freq.put("Pek", 8);
    freq.put("Paa", 7);
    freq.put("Pad", 11);
    freq.put("Pai", 24);
    freq.put("Pak", 11);
    freq.put("Pal", 16);
    freq.put("Pan", 12);
    freq.put("mii", 45);
    freq.put("mih", 20);
    freq.put("mik", 85);
    freq.put("mij", 3);
    freq.put("Oik", 8);
    freq.put("mil", 56);
    freq.put("mio", 12);
    freq.put("min", 256);
    freq.put("mia", 50);
    freq.put("mie", 150);
    freq.put("mix", 3);
    freq.put("mip", 4);
    freq.put("mis", 273);
    freq.put("Ois", 6);
    freq.put("mit", 209);
    freq.put("miv", 6);
    freq.put("Pa ", 5);
    freq.put("sfo", 4);
    freq.put("mi ", 123);
    freq.put("Oi ", 5);
    freq.put(" iP", 22);
    freq.put(" iO", 3);
    freq.put(" iC", 3);
    freq.put("ksu", 34);
    freq.put("kst", 13);
    freq.put("vä ", 190);
    freq.put(" ir", 12);
    freq.put(" is", 48);
    freq.put("ksy", 36);
    freq.put("Mou", 8);
    freq.put("Mot", 4);
    freq.put(" ih", 143);
    freq.put(" ik", 43);
    freq.put("ksa", 54);
    freq.put("Mon", 11);
    freq.put(" in", 42);
    freq.put("Mol", 3);
    freq.put("Mob", 4);
    freq.put("kso", 18);
    freq.put("ksi", 391);
    freq.put("Mod", 3);
    freq.put("ks ", 87);
    freq.put(" i ", 6);
    freq.put("vr ", 3);
    freq.put(" iä", 3);
    freq.put("dä", 123);
    freq.put("rpi", 7);
    freq.put("öli", 4);
    freq.put("wl", 5);
    freq.put("öll", 17);
    freq.put("vrt", 3);
    freq.put("S", 787);
    freq.put("ww", 32);
    freq.put("ws", 15);
    freq.put("käl", 20);
    freq.put("käm", 3);
    freq.put("kän", 22);
    freq.put("käh", 4);
    freq.put("käi", 23);
    freq.put("käk", 4);
    freq.put("käd", 7);
    freq.put("ohn", 4);
    freq.put("oho", 23);
    freq.put("käy", 139);
    freq.put("kät", 15);
    freq.put("käv", 26);
    freq.put("käp", 9);
    freq.put("kär", 35);
    freq.put("käs", 50);
    freq.put("ohj", 57);
    freq.put("nä ", 154);
    freq.put("af", 30);
    freq.put("ohd", 25);
    freq.put("ohe", 3);
    freq.put("ak", 949);
    freq.put("uij", 10);
    freq.put("uim", 13);
    freq.put("kä ", 158);
    freq.put("cos", 3);
    freq.put("oha", 22);
    freq.put("ile", 87);
    freq.put("uin", 114);
    freq.put("näi", 49);
    freq.put("näh", 34);
    freq.put("näk", 59);
    freq.put("näj", 9);
    freq.put("näm", 6);
    freq.put("näl", 7);
    freq.put("ysm", 4);
    freq.put("ap", 372);
    freq.put("ysa", 5);
    freq.put("näe", 9);
    freq.put("uis", 107);
    freq.put("yse", 20);
    freq.put("näy", 41);
    freq.put("ysy", 30);
    freq.put("Hou", 7);
    freq.put("yss", 18);
    freq.put("näp", 7);
    freq.put("näs", 5);
    freq.put("när", 4);
    freq.put("nät", 9);
    freq.put("uit", 37);
    freq.put(" Fr", 8);
    freq.put(" Fu", 5);
    freq.put("Hop", 4);
    freq.put("kää", 128);
    freq.put("uiv", 28);
    freq.put(" Fa", 35);
    freq.put("oht", 121);
    freq.put(" Fe", 7);
    freq.put(" Fi", 31);
    freq.put(" Fl", 13);
    freq.put(" Fo", 17);
    freq.put("io ", 53);
    freq.put("iot", 21);
    freq.put("ios", 20);
    freq.put("iop", 24);
    freq.put("ioo", 4);
    freq.put("ion", 56);

    init3();
  }
  private static void init3() {
    
    freq.put("iol", 26);
    freq.put("iok", 8);
    freq.put("ioi", 43);
    freq.put("GA ", 3);
    freq.put("com", 5);
    freq.put("nää", 141);
    freq.put("col", 4);
    freq.put("con", 21);
    freq.put("njä", 9);
    freq.put("adu", 13);
    freq.put("ady", 3);
    freq.put("ade", 12);
    freq.put("ada", 21);
    freq.put("ado", 6);
    freq.put("adi", 40);
    freq.put("Hyv", 82);
    freq.put("fyy", 4);
    freq.put("ad ", 15);
    freq.put("nja", 18);
    freq.put("ui ", 56);
    freq.put("njo", 12);
    freq.put("nju", 4);
    freq.put("esu", 14);
    freq.put("tms", 5);
    freq.put("ess", 234);
    freq.put("tmu", 3);
    freq.put("esp", 5);
    freq.put("tma", 3);
    freq.put("ese", 22);
    freq.put("esa", 10);
    freq.put("eso", 3);
    freq.put("tml", 4);
    freq.put("esi", 136);
    freq.put("äai", 8);
    freq.put("äas", 6);
    freq.put("OS ", 7);
    freq.put("es ", 130);
    freq.put("Twi", 18);
    freq.put("piä", 8);
    freq.put(" Äl", 10);
    freq.put("bur", 5);
    freq.put("bus", 11);
    freq.put("Del", 3);
    freq.put("bul", 4);
    freq.put("bum", 6);
    freq.put("bud", 4);
    freq.put("j", 3485);
    freq.put("rc ", 3);
    freq.put("rri", 8);
    freq.put("pih", 10);
    freq.put("pii", 44);
    freq.put("pik", 44);
    freq.put("pil", 28);
    freq.put("pim", 19);
    freq.put("pin", 48);
    freq.put("pio", 22);
    freq.put("pia", 29);
    freq.put("pic", 4);
    freq.put("pid", 27);
    freq.put("pie", 41);
    freq.put("pip", 5);
    freq.put("pir", 12);
    freq.put("pis", 70);
    freq.put("pit", 158);
    freq.put("piv", 3);
    freq.put("oaa", 11);
    freq.put("oan", 4);
    freq.put("oam", 6);
    freq.put("oal", 5);
    freq.put("oav", 3);
    freq.put("oau", 4);
    freq.put("oat", 3);
    freq.put("oas", 6);
    freq.put("ubr", 3);
    freq.put("pi ", 130);
    freq.put("ube", 14);
    freq.put("ubi", 13);
    freq.put("oa ", 126);
    freq.put(" kä", 225);
    freq.put(" kö", 3);
    freq.put("G ", 9);
    freq.put("tä ", 968);
    freq.put("Gu", 4);
    freq.put("Gr", 18);
    freq.put("Ok ", 6);
    freq.put("Ge", 6);
    freq.put("Ga", 8);
    freq.put("Go", 33);
    freq.put("Gl", 4);
    freq.put(" ka", 704);
    freq.put(" kg", 4);
    freq.put(" ke", 317);
    freq.put(" ki", 288);
    freq.put(" ko", 479);
    freq.put(" kl", 56);
    freq.put(" km", 4);
    freq.put(" kr", 19);
    freq.put(" ks", 3);
    freq.put(" kp", 5);
    freq.put(" ku", 661);
    freq.put(" ky", 142);
    freq.put("kuv", 129);
    freq.put("kuu", 193);
    freq.put("kut", 87);
    freq.put("kus", 101);
    freq.put("aio", 4);
    freq.put("kup", 20);
    freq.put("kuo", 26);
    freq.put("kun", 236);
    freq.put("kum", 42);
    freq.put("kul", 68);
    freq.put("kuk", 42);
    freq.put("kuj", 15);
    freq.put("kui", 125);
    freq.put("kuh", 10);
    freq.put("kue", 13);
    freq.put("kud", 3);
    freq.put("kua", 17);
    freq.put("VL ", 3);
    freq.put("gne", 4);
    freq.put("TT ", 8);
    freq.put("ku ", 165);
    freq.put("Koi", 9);
    freq.put("Koh", 5);
    freq.put("Kok", 52);
    freq.put("Kom", 7);
    freq.put("Kol", 12);
    freq.put("Koo", 3);
    freq.put("Kon", 3);
    freq.put("Kos", 17);
    freq.put("Kor", 15);
    freq.put("Kou", 9);
    freq.put("Kot", 31);
    freq.put("Kov", 5);
    freq.put("enä", 47);
    freq.put("m ", 128);
    freq.put("tm", 18);
    freq.put("örs", 8);
    freq.put("ört", 3);
    freq.put("örk", 3);
    freq.put("öri", 15);
    freq.put("örm", 5);
    freq.put("me", 920);
    freq.put("mg", 3);
    freq.put("ma", 1435);
    freq.put("g", 689);
    freq.put("mb", 23);
    freq.put("mm", 405);
    freq.put("ml", 5);
    freq.put("mo", 223);
    freq.put("mn", 9);
    freq.put("mi", 1340);
    freq.put("mh", 4);
    freq.put("mu", 802);
    freq.put("mt", 7);
    freq.put("mp", 213);
    freq.put("ms", 21);
    freq.put("my", 174);
    freq.put("iuk", 11);
    freq.put("iul", 6);
    freq.put("ena", 55);
    freq.put("end", 12);
    freq.put("ene", 129);
    freq.put("eng", 42);
    freq.put("enh", 6);
    freq.put("eni", 114);
    freq.put("enj", 7);
    freq.put("enk", 138);
    freq.put("enl", 9);
    freq.put("enm", 6);
    freq.put("enn", 246);
    freq.put("eno", 40);
    freq.put("enp", 19);
    freq.put("enr", 11);
    freq.put("ens", 95);
    freq.put("ent", 197);
    freq.put("enu", 12);
    freq.put("env", 33);
    freq.put("eny", 5);
    freq.put("ON ", 7);
    freq.put("II ", 5);
    freq.put("örä", 18);
    freq.put("en ", 2296);
    freq.put("mä", 509);
    freq.put("Pör", 4);
    freq.put("Pöy", 3);
    freq.put("mö", 17);
    freq.put(" Hy", 87);
    freq.put(" Hu", 60);
    freq.put(" Hi", 33);
    freq.put(" Ho", 38);
    freq.put(" Ha", 173);
    freq.put(" He", 137);
    freq.put("ima", 103);
    freq.put("ime", 151);
    freq.put("imi", 215);
    freq.put("imm", 76);
    freq.put("imo", 14);
    freq.put("iut", 8);
    freq.put("imp", 21);
    freq.put("imu", 45);
    freq.put("imy", 6);
    freq.put("ajä", 5);
    freq.put("JA ", 4);
    freq.put("SA ", 8);
    freq.put(" H ", 5);
    freq.put("im ", 25);
    freq.put(" Hä", 29);
    freq.put("gon", 3);
    freq.put("imä", 19);
    freq.put("aju", 23);
    freq.put("aji", 40);
    freq.put("ajo", 28);
    freq.put("aja", 277);
    freq.put("aje", 10);
    freq.put("gos", 6);
    freq.put("gor", 157);
    freq.put("W", 70);
    freq.put("Vic", 3);
    freq.put("Vid", 9);
    freq.put("Vie", 22);
    freq.put("Vih", 7);
    freq.put("Vii", 19);
    freq.put("Vin", 4);
    freq.put("go ", 7);
    freq.put("Vil", 8);
    freq.put("Vim", 3);
    freq.put("Vir", 11);
    freq.put("Vit", 9);
    freq.put(" Sp", 7);
    freq.put("nhe", 8);
    freq.put("nha", 38);
    freq.put("nho", 16);
    freq.put("nhu", 5);
    freq.put("tor", 65);
    freq.put("tos", 126);
    freq.put("top", 22);
    freq.put("tov", 20);
    freq.put("EU ", 9);
    freq.put("tot", 63);
    freq.put("tou", 18);
    freq.put("toj", 33);
    freq.put("tok", 62);
    freq.put("toh", 6);
    freq.put("toi", 234);
    freq.put("ton", 126);
    freq.put("Syö", 4);
    freq.put("tol", 64);
    freq.put("tom", 66);
    freq.put("toa", 49);
    freq.put("tod", 25);
    freq.put("toe", 14);
    freq.put("Itä", 6);
    freq.put("to ", 245);
    freq.put("raf", 7);
    freq.put("rag", 4);
    freq.put("rad", 13);
    freq.put("rae", 7);
    freq.put("rab", 4);
    freq.put("rac", 5);
    freq.put("raa", 100);
    freq.put("ran", 135);
    freq.put("ral", 39);
    freq.put("TÄ ", 6);
    freq.put("raj", 14);
    freq.put("rak", 198);
    freq.put("rah", 23);
    freq.put("rai", 39);
    freq.put("rav", 19);
    freq.put("rat", 54);
    freq.put("rau", 27);
    freq.put("ras", 65);
    freq.put("rap", 20);
    freq.put("bs ", 5);
    freq.put("Syk", 5);
    freq.put("Sym", 4);
    freq.put("Sys", 3);
    freq.put("Syy", 9);
    freq.put("ra ", 50);
    freq.put("bsi", 7);
    freq.put("Ite", 3);
    freq.put("Ita", 8);
    freq.put("R", 278);
    freq.put("Its", 13);
    freq.put("én", 3);
    freq.put("och", 3);
    freq.put("ock", 10);
    freq.put("occ", 3);
    freq.put("NU ", 3);
    freq.put("Aam", 13);
    freq.put("Aal", 4);
    freq.put("Aar", 3);
    freq.put("Ex ", 3);
    freq.put("Pet", 10);
    freq.put("nut", 140);
    freq.put("nuu", 16);
    freq.put("nur", 7);
    freq.put("nus", 44);
    freq.put("Per", 28);
    freq.put("Pes", 8);
    freq.put("Pel", 24);
    freq.put("nuo", 18);
    freq.put("Pen", 3);
    freq.put("num", 8);
    freq.put("nuk", 42);
    freq.put("nui", 5);
    freq.put("nua", 4);
    freq.put("muu", 140);
    freq.put("mut", 163);
    freq.put("mup", 7);
    freq.put("mus", 79);
    freq.put("mur", 26);
    freq.put("mua", 21);
    freq.put("mum", 4);
    freq.put("mul", 70);
    freq.put("muo", 31);
    freq.put("mun", 93);
    freq.put("mui", 49);
    freq.put("muh", 4);
    freq.put("muk", 97);
    freq.put("XD ", 18);
    freq.put("nu ", 53);
    freq.put("mu ", 13);
    freq.put(" me", 310);
    freq.put(" ma", 341);
    freq.put(" mb", 5);
    freq.put(" mm", 11);
    freq.put(" mo", 76);
    freq.put(" mi", 518);
    freq.put(" mt", 5);
    freq.put(" mu", 609);
    freq.put(" my", 125);
    freq.put("öpö", 9);
    freq.put(" m ", 13);
    freq.put("öpä", 6);
    freq.put("VR ", 11);
    freq.put("TV ", 34);
    freq.put("n", 17359);
    freq.put("elt", 105);
    freq.put(" mä", 100);
    freq.put(" mö", 7);
    freq.put("öpa", 15);
    freq.put("öpo", 3);
    freq.put(" Jä", 23);
    freq.put("elj", 18);
    freq.put("elk", 44);
    freq.put("eli", 278);
    freq.put("elo", 49);
    freq.put("ell", 452);
    freq.put("elm", 95);
    freq.put("ela", 87);
    freq.put("eld", 3);
    freq.put("ele", 163);
    freq.put("ely", 35);
    freq.put("els", 62);
    freq.put("elp", 19);
    freq.put("elv", 40);
    freq.put("Hä", 29);
    freq.put("elu", 143);
    freq.put("D", 330);
    freq.put("el ", 42);
    freq.put("Aus", 3);
    freq.put("ywo", 4);
    freq.put("Lyh", 3);
    freq.put("hs ", 3);
    freq.put(" Jy", 12);
    freq.put(" Ju", 53);
    freq.put(" Jo", 120);
    freq.put(" Je", 34);
    freq.put(" Ja", 117);
    freq.put("ick", 8);
    freq.put("ici", 9);
    freq.put("Hy", 87);
    freq.put("ico", 3);
    freq.put("icc", 3);
    freq.put("ica", 10);
    freq.put("ice", 4);
    freq.put("Hu", 60);
    freq.put("Hi", 33);
    freq.put("Ho", 39);
    freq.put("icr", 4);
    freq.put("Ha", 173);
    freq.put("ict", 4);
    freq.put("ic ", 15);
    freq.put("H ", 6);
    freq.put("ppa", 116);
    freq.put("aha", 94);
    freq.put("ppe", 12);
    freq.put("ahe", 12);
    freq.put("ahj", 12);
    freq.put("ahk", 9);
    freq.put("ppi", 150);
    freq.put("ahi", 12);
    freq.put("ppo", 31);
    freq.put("aho", 22);
    freq.put("ahm", 7);
    freq.put("ahv", 26);
    freq.put("ppu", 87);
    freq.put("nnö", 12);
    freq.put("ppy", 4);
    freq.put("git", 9);
    freq.put("gis", 23);
    freq.put("gip", 3);
    freq.put("tiö", 23);
    freq.put("nä", 551);
    freq.put("gib", 5);
    freq.put("gia", 29);
    freq.put("tiä", 20);
    freq.put("gin", 55);
    freq.put("gil", 7);
    freq.put("gik", 3);
    freq.put("nö", 24);
    freq.put("ah ", 17);
    freq.put("pp ", 4);
    freq.put("de ", 23);
    freq.put("Vol", 4);
    freq.put("la", 1818);
    freq.put("Voi", 41);
    freq.put("gi ", 14);
    freq.put("nno", 80);
    freq.put("nnn", 6);
    freq.put("nni", 165);
    freq.put("ppä", 15);
    freq.put("nne", 249);
    freq.put("nna", 197);
    freq.put("nny", 44);
    freq.put("nnu", 96);
    freq.put("nh", 71);
    freq.put("ni", 980);
    freq.put("nj", 44);
    freq.put("nk", 591);
    freq.put("nl", 73);
    freq.put("nm", 28);
    freq.put("nn", 919);
    freq.put("no", 559);
    freq.put("tit", 55);
    freq.put("na", 951);
    freq.put("nb", 3);
    freq.put("nc", 14);
    freq.put("nd", 123);
    freq.put("ne", 1296);
    freq.put("nf", 16);
    freq.put("ng", 211);
    freq.put("til", 104);
    freq.put("ny", 301);
    freq.put("tin", 172);
    freq.put("tio", 62);
    freq.put("tih", 4);
    freq.put("tii", 183);
    freq.put("tij", 14);
    freq.put("tik", 79);
    freq.put("np", 77);
    freq.put("tie", 181);
    freq.put("nr", 19);
    freq.put("ns", 385);
    freq.put("nt", 1010);
    freq.put("nu", 380);
    freq.put("nv", 61);
    freq.put("tic", 9);
    freq.put("n ", 8518);
    freq.put("Leh", 7);
    freq.put("ti ", 560);
    freq.put("roi", 66);
    freq.put("lly", 25);
    freq.put("rok", 14);
    freq.put("rol", 19);
    freq.put("rom", 22);
    freq.put("ron", 31);
    freq.put("roo", 33);
    freq.put("lls", 4);
    freq.put("roa", 16);
    freq.put("rob", 4);
    freq.put("roc", 3);
    freq.put("rof", 13);
    freq.put("lli", 286);
    freq.put("llo", 81);
    freq.put("elä", 149);
    freq.put("rop", 13);
    freq.put("ror", 7);
    freq.put("ros", 35);
    freq.put("rot", 24);
    freq.put("rou", 9);
    freq.put("rov", 9);
    freq.put("Dam", 5);
    freq.put("Dan", 3);
    freq.put("Day", 3);
    freq.put("ro ", 38);
    freq.put("Cit", 7);
    freq.put("ll ", 25);
    freq.put("He", 141);
    freq.put("llö", 3);
    freq.put("Rek", 3);
    freq.put("Rei", 8);
    freq.put("Rea", 4);
    freq.put("Red", 5);
    freq.put("llä", 378);
    freq.put("äke", 27);
    freq.put("Que", 3);
    freq.put("äka", 13);
    freq.put("äko", 12);
    freq.put("Mil", 9);
    freq.put("äkk", 24);
    freq.put("kyä", 10);
    freq.put("yj ", 3);
    freq.put("Min", 29);
    freq.put("msu", 8);
    freq.put("Mia", 3);
    freq.put("yje", 3);
    freq.put("ms ", 9);
    freq.put("Mii", 3);
    freq.put(" oo", 137);
    freq.put(" ol", 504);
    freq.put(" om", 54);
    freq.put("kyn", 4);
    freq.put("kym", 12);
    freq.put("kyl", 109);
    freq.put(" of", 4);
    freq.put(" od", 28);
    freq.put("Mie", 18);
    freq.put(" oc", 4);
    freq.put("kyy", 14);
    freq.put(" ov", 70);
    freq.put("Mis", 24);
    freq.put(" ou", 14);
    freq.put(" or", 8);
    freq.put(" os", 126);
    freq.put(" op", 63);
    freq.put("kyt", 12);
    freq.put("YP ", 6);
    freq.put("ky ", 18);
    freq.put(" o ", 21);
    freq.put("ahd", 58);
    freq.put("ejä", 26);
    freq.put("ahh", 3);
    freq.put("nnä", 68);
    freq.put("ahn", 3);
    freq.put("ng ", 31);
    freq.put("ppl", 13);
    freq.put("aht", 96);
    freq.put("mim", 10);
    freq.put("EN ", 7);
    freq.put("ejo", 4);
    freq.put("eja", 27);
    freq.put("övä", 3);
    freq.put("hu ", 4);
    freq.put("ebe", 3);
    freq.put("iam", 5);
    freq.put("ial", 30);
    freq.put("ian", 108);
    freq.put("iai", 22);
    freq.put("iah", 6);
    freq.put("€ ", 16);
    freq.put("iaj", 4);
    freq.put("iaa", 100);
    freq.put("iat", 13);
    freq.put("iap", 3);
    freq.put("ias", 48);
    freq.put("iar", 6);
    freq.put("hua", 9);
    freq.put("hub", 3);
    freq.put("hul", 6);
    freq.put("hum", 10);
    freq.put("hun", 6);
    freq.put("huo", 102);
    freq.put("huh", 15);
    freq.put("hui", 20);
    freq.put("huj", 6);
    freq.put("huk", 5);
    freq.put("hut", 14);
    freq.put("huu", 23);
    freq.put("hup", 12);
    freq.put("hur", 5);
    freq.put("SE ", 4);
    freq.put(" Lä", 23);
    freq.put("ia ", 628);
    freq.put(" Lö", 7);
    freq.put("r", 5400);
    freq.put("gii", 3);
    freq.put("pre", 17);
    freq.put("ane", 57);
    freq.put("ang", 23);
    freq.put("ana", 191);
    freq.put("anc", 6);
    freq.put("anl", 10);
    freq.put("anm", 15);
    freq.put("pro", 32);
    freq.put("ano", 118);
    freq.put("pri", 14);
    freq.put("ani", 107);
    freq.put("anj", 16);
    freq.put("ank", 94);
    freq.put("pru", 3);
    freq.put("anu", 57);
    freq.put("anv", 3);
    freq.put("anp", 17);
    freq.put("anr", 3);
    freq.put("ans", 172);
    freq.put(" L ", 7);
    freq.put("Mit", 51);
    freq.put("ngä", 16);
    freq.put("an ", 1646);
    freq.put("Löy", 7);
    freq.put(" Le", 43);
    freq.put(" La", 93);
    freq.put(" Lo", 37);
    freq.put(" Li", 82);
    freq.put(" Lu", 71);
    freq.put(" Ly", 7);
    freq.put("tke", 29);
    freq.put("nlu", 7);
    freq.put("tka", 104);
    freq.put("iöm", 3);
    freq.put("iön", 5);
    freq.put("iöi", 4);
    freq.put("tki", 65);
    freq.put("nla", 25);
    freq.put("tku", 38);
    freq.put("rmä", 6);
    freq.put("nli", 13);
    freq.put("ss ", 20);
    freq.put("nlo", 28);
    freq.put("öä ", 9);
    freq.put("ssy", 11);
    freq.put("ssu", 40);
    freq.put("H", 625);
    freq.put("dys", 16);
    freq.put("dyn", 9);
    freq.put("ssi", 123);
    freq.put("dyk", 4);
    freq.put("sse", 16);
    freq.put("ssa", 818);
    freq.put("tkä", 49);
    freq.put("rmu", 8);
    freq.put("tkö", 16);
    freq.put("rma", 83);
    freq.put("rme", 17);
    freq.put("jot", 98);
    freq.put("rmi", 26);
    freq.put("rmo", 9);
    freq.put("ssä", 298);
    freq.put("Ihm", 4);
    freq.put("Iha", 19);
    freq.put("pot", 17);
    freq.put("por", 39);
    freq.put("pos", 26);
    freq.put("pop", 3);
    freq.put("pon", 10);
    freq.put("poo", 13);
    freq.put("pol", 41);
    freq.put("pom", 12);
    freq.put("poj", 11);
    freq.put("pok", 10);
    freq.put("poh", 20);
    freq.put("poi", 61);
    freq.put("poa", 4);
    freq.put("Bus", 4);
    freq.put("jon", 87);
    freq.put("Bul", 3);
    freq.put("po ", 9);
    freq.put("yhä", 16);
    freq.put("uhd", 12);
    freq.put("Et ", 3);
    freq.put("uhe", 72);
    freq.put("Bar", 4);
    freq.put("I ", 47);
    freq.put("mmö", 4);
    freq.put("Ete", 7);
    freq.put("Bay", 3);
    freq.put("tiy", 3);
    freq.put("yhj", 5);
    freq.put("yhk", 5);
    freq.put("yhm", 34);
    freq.put("Is", 27);
    freq.put("Ir", 11);
    freq.put("It", 32);
    freq.put("yhd", 32);
    freq.put("yhe", 6);
    freq.put("Ii", 7);
    freq.put("Ih", 25);
    freq.put("Ik", 6);
    freq.put("yhy", 19);
    freq.put("Il", 32);
    freq.put("In", 31);
    freq.put("oke", 50);
    freq.put("Id", 3);
    freq.put("yht", 104);
    freq.put("tip", 20);
    freq.put("tir", 10);
    freq.put("rpu", 4);
    freq.put("tis", 130);
    freq.put("ötä", 24);
    freq.put("tim", 55);
    freq.put("YV ", 3);
    freq.put("ES ", 7);
    freq.put("Pik", 6);
    freq.put("Pil", 6);
    freq.put("Pim", 5);
    freq.put("Pin", 9);
    freq.put("Pia", 5);
    freq.put("Pie", 8);
    freq.put("tia", 89);
    freq.put("Hon", 4);
    freq.put("hää", 8);
    freq.put("Pir", 4);
    freq.put("Pis", 6);
    freq.put("Pit", 29);
    freq.put("Kuv", 14);
    freq.put("Kuu", 16);
    freq.put("Kut", 3);
    freq.put("Kus", 3);
    freq.put("Kur", 7);
    freq.put("Kup", 4);
    freq.put("Kuo", 21);
    freq.put("Kun", 126);
    freq.put("Kum", 5);
    freq.put("Kul", 7);
    freq.put("Kuk", 8);
    freq.put("Kui", 11);
    freq.put("öta", 4);
    freq.put("öti", 4);
    freq.put("Hol", 9);
    freq.put("o ", 1396);
    freq.put("ött", 7);
    freq.put("hä ", 37);
    freq.put("öty", 7);
    freq.put("uTu", 8);
    freq.put("oP", 3);
    freq.put("oo", 563);
    freq.put("öt ", 25);
    freq.put("om", 663);
    freq.put("ol", 1189);
    freq.put("ok", 631);
    freq.put("oj", 173);
    freq.put("oi", 1431);
    freq.put("oh", 310);
    freq.put("og", 77);
    freq.put("of", 39);
    freq.put("oe", 36);
    freq.put("od", 148);
    freq.put("oc", 25);
    freq.put("ob", 44);
    freq.put("oa", 182);
    freq.put("oy", 9);
    freq.put("ox", 3);
    freq.put("ow", 45);
    freq.put("hän", 118);
    freq.put("ou", 344);
    freq.put("ot", 823);
    freq.put("os", 1017);
    freq.put("or", 568);
    freq.put("häi", 9);
    freq.put("op", 396);
    freq.put("LE ", 13);
    freq.put("ju ", 7);
    freq.put("FB ", 5);
    freq.put("eht", 77);
    freq.put("ehu", 7);
    freq.put("ehd", 79);
    freq.put("ehe", 27);
    freq.put("ve ", 26);
    freq.put("eha", 7);
    freq.put("ehn", 15);
    freq.put("eho", 18);
    freq.put("ehm", 3);
    freq.put("ehk", 33);
    freq.put("ehi", 32);
    freq.put("jua", 3);
    freq.put("juh", 16);
    freq.put("jui", 3);
    freq.put("jun", 29);
    freq.put("juo", 20);
    freq.put("jul", 54);
    freq.put("jum", 10);
    freq.put("jur", 3);
    freq.put("jus", 28);
    freq.put("juv", 3);
    freq.put("jut", 43);
    freq.put("juu", 43);
    freq.put("Mää", 5);
    freq.put("eh ", 8);
    freq.put("rva", 32);
    freq.put("rve", 61);
    freq.put("rvi", 51);
    freq.put("rvo", 43);
    freq.put("Hot", 4);
    freq.put("igu", 3);
    freq.put("Mä ", 15);
    freq.put("IC ", 3);
    freq.put("ige", 5);
    freq.put("iga", 26);
    freq.put("ign", 6);
    freq.put("igi", 12);
    freq.put("igh", 11);
    freq.put("Mäk", 5);
    freq.put("ig ", 3);
    freq.put("alo", 106);
    freq.put("all", 413);
    freq.put("alm", 36);
    freq.put("alj", 57);
    freq.put("alk", 167);
    freq.put("pti", 10);
    freq.put("ali", 254);
    freq.put("alg", 3);
    freq.put("ald", 5);
    freq.put("ale", 69);
    freq.put("alb", 6);
    freq.put("roj", 20);
    freq.put("ala", 280);
    freq.put("aly", 8);
    freq.put("alv", 49);
    freq.put("alt", 112);
    freq.put("alu", 201);
    freq.put("als", 3);
    freq.put("alp", 7);
    freq.put(" N ", 11);
    freq.put("alP", 9);
    freq.put("Tse", 16);
    freq.put("far", 7);
    freq.put("al ", 28);
    freq.put("fan", 17);
    freq.put("llu", 114);
    freq.put("fal", 4);
    freq.put("fac", 8);
    freq.put("faa", 5);
    freq.put(" Ni", 89);
    freq.put(" No", 95);
    freq.put(" Na", 55);
    freq.put(" Ne", 46);
    freq.put(" Ny", 48);
    freq.put(" Nu", 16);
    freq.put("teh", 72);
    freq.put("tei", 144);
    freq.put("tej", 16);
    freq.put("tek", 97);
    freq.put("tel", 344);
    freq.put("tem", 12);
    freq.put("ten", 367);
    freq.put("teo", 20);
    freq.put("tea", 14);
    freq.put("ted", 3);
    freq.put("tee", 221);
    freq.put("teg", 156);
    freq.put("tey", 11);
    freq.put("tep", 6);
    freq.put("ter", 174);
    freq.put("tes", 28);
    freq.put("tet", 155);
    freq.put("lla", 806);
    freq.put("tev", 23);
    freq.put("sua", 30);
    freq.put("suo", 106);
    freq.put("sun", 66);
    freq.put("sum", 15);
    freq.put("sul", 41);
    freq.put("suk", 20);
    freq.put("suj", 16);
    freq.put("sui", 21);
    freq.put("suh", 17);
    freq.put("KP ", 4);
    freq.put("suv", 9);
    freq.put("suu", 164);
    freq.put("sut", 34);
    freq.put("sus", 23);
    freq.put("sur", 21);
    freq.put("sup", 8);
    freq.put("äyt", 182);
    freq.put("äyr", 5);
    freq.put("äys", 21);
    freq.put("äyl", 7);
    freq.put("äym", 5);
    freq.put("äyn", 28);
    freq.put("äyk", 7);
    freq.put("äyd", 10);
    freq.put("su ", 38);
    freq.put(" Nä", 31);
    freq.put("okä", 4);
    freq.put("rku", 29);
    freq.put("Tor", 11);
    freq.put("Tos", 7);
    freq.put("Top", 3);
    freq.put("rky", 8);
    freq.put("Tot", 10);
    freq.put("rke", 52);
    freq.put("Toi", 36);
    freq.put("rka", 38);
    freq.put("Tol", 3);
    freq.put("Tom", 5);
    freq.put("rko", 34);
    freq.put("rki", 57);
    freq.put("Tod", 3);
    freq.put("rkk", 124);
    freq.put("In ", 4);
    freq.put("äää", 28);
    freq.put("rk ", 7);
    freq.put("Int", 8);
    freq.put("Inn", 4);
    freq.put("v", 4641);
    freq.put("Ind", 5);
    freq.put("Inf", 3);
    freq.put("rkä", 6);
    freq.put("ääs", 78);
    freq.put("äär", 64);
    freq.put("ääp", 5);
    freq.put("ääv", 36);
    freq.put("äät", 51);
    freq.put("ääk", 45);
    freq.put("ääj", 8);
    freq.put("ääh", 13);
    freq.put("ääo", 4);
    freq.put("ään", 484);
    freq.put("ääm", 15);
    freq.put("oyh", 4);
    freq.put("ääd", 6);
    freq.put("Aku", 3);
    freq.put("Akk", 3);
    freq.put("lha", 3);
    freq.put("lho", 6);
    freq.put("ää ", 518);
    freq.put(" sö", 10);
    freq.put(" sä", 53);
    freq.put("yn ", 72);
    freq.put("L", 391);
    freq.put("Eri", 9);
    freq.put("Rad", 6);
    freq.put("yni", 3);
    freq.put("ynk", 5);
    freq.put("Ran", 12);
    freq.put("yne", 11);
    freq.put("Raj", 3);
    freq.put("Rak", 4);
    freq.put("Rah", 3);
    freq.put("Rav", 4);
    freq.put("Rau", 4);
    freq.put("yny", 38);
    freq.put("ynt", 48);
    freq.put("Muu", 37);
    freq.put("Mut", 26);
    freq.put(" sy", 131);
    freq.put("Mus", 15);
    freq.put("Mur", 3);
    freq.put(" ss", 19);
    freq.put(" sp", 15);
    freq.put(" sv", 8);
    freq.put(" st", 47);
    freq.put(" su", 274);
    freq.put(" sk", 8);
    freq.put(" sh", 6);
    freq.put(" si", 583);
    freq.put("Mua", 3);
    freq.put(" so", 104);
    freq.put(" sl", 4);
    freq.put("Mul", 14);
    freq.put("Muo", 3);
    freq.put(" sa", 426);
    freq.put("Mui", 18);
    freq.put("Muk", 8);
    freq.put(" se", 468);
    freq.put("YT ", 3);
    freq.put("koi", 132);
    freq.put("koh", 91);
    freq.put("kok", 115);
    freq.put("Erä", 4);
    freq.put("kom", 55);
    freq.put(" s ", 11);
    freq.put("kol", 70);
    freq.put("ynä", 12);
    freq.put("kon", 173);
    freq.put("koa", 33);
    freq.put("atc", 3);
    freq.put("kod", 6);
    freq.put("kop", 28);
    freq.put(" ev", 3);
    freq.put("kou", 74);
    freq.put("Nuo", 11);
    freq.put("jel", 43);
    freq.put(" es", 78);
    freq.put("eff", 22);
    freq.put("rte", 14);
    freq.put("rta", 59);
    freq.put("rto", 39);
    freq.put("rti", 40);
    freq.put("rtu", 20);
    freq.put("rtt", 56);
    freq.put("rts", 3);
    freq.put("rty", 17);
    freq.put("Jy", 12);
    freq.put("iep", 4);
    freq.put("ies", 84);
    freq.put("ier", 38);
    freq.put("IA ", 4);
    freq.put("iew", 3);
    freq.put("iev", 7);
    freq.put("ieh", 38);
    freq.put("iek", 31);
    freq.put("Jo", 120);
    freq.put("iem", 29);
    freq.put("iel", 273);
    freq.put("ien", 179);
    freq.put("Je", 34);
    freq.put("ieb", 3);
    freq.put("ied", 54);
    freq.put("hip", 7);
    freq.put("hir", 16);
    freq.put("his", 17);
    freq.put("hit", 36);
    freq.put("rt ", 9);
    freq.put("hia", 8);
    freq.put("hid", 4);
    freq.put("hie", 30);
    freq.put("hih", 12);
    freq.put("hii", 9);
    freq.put("hik", 10);
    freq.put("hil", 21);
    freq.put("him", 12);
    freq.put("hin", 125);
    freq.put(" Pö", 9);
    freq.put(" Pä", 63);
    freq.put("ie ", 33);
    freq.put("J ", 3);
    freq.put("arp", 18);
    freq.put("rtä", 20);
    freq.put("arr", 27);
    freq.put("ars", 32);
    freq.put("art", 65);
    freq.put("aru", 12);
    freq.put("arv", 83);
    freq.put("ary", 3);
    freq.put("ara", 279);
    freq.put("arc", 3);
    freq.put("ard", 34);
    freq.put("are", 51);
    freq.put("arg", 3);
    freq.put("arh", 22);
    freq.put("ari", 245);
    freq.put("arj", 159);
    freq.put("ark", 100);
    freq.put("arl", 10);
    freq.put("arm", 65);
    freq.put("arn", 3);
    freq.put("aro", 42);
    freq.put(" P ", 6);
    freq.put("Jä", 23);
    freq.put("uuu", 32);
    freq.put("uut", 253);
    freq.put("uuv", 3);
    freq.put("uus", 179);
    freq.put("uur", 90);
    freq.put("ar ", 20);
    freq.put("uul", 94);
    freq.put("uun", 150);
    freq.put("hiä", 3);
    freq.put("uuh", 11);
    freq.put("uuk", 33);
    freq.put("uud", 92);
    freq.put("uua", 5);
    freq.put(" Pr", 27);
    freq.put("c", 326);
    freq.put(" Pu", 55);
    freq.put(" Py", 19);
    freq.put(" Pa", 106);
    freq.put(" Pe", 85);
    freq.put(" Pi", 84);
    freq.put(" Ph", 4);
    freq.put(" Po", 82);
    freq.put(" Pl", 10);
    freq.put("riö", 4);
    freq.put("riä", 14);
    freq.put("pr", 71);
    freq.put("ps", 59);
    freq.put("pp", 435);
    freq.put("duk", 5);
    freq.put("dul", 9);
    freq.put("dun", 15);
    freq.put("pu", 475);
    freq.put("py", 88);
    freq.put("dud", 3);
    freq.put("pa", 936);
    freq.put("pe", 508);
    freq.put("pj", 5);
    freq.put("ph", 7);
    freq.put("dus", 20);
    freq.put("dut", 10);
    freq.put("po", 284);
    freq.put("pl", 42);
    freq.put("Vää", 3);
    freq.put("du ", 9);
    freq.put("p ", 53);
    freq.put("riv", 12);
    freq.put("rit", 167);
    freq.put("ris", 134);
    freq.put("rip", 15);
    freq.put("Til", 9);
    freq.put("Tim", 4);
    freq.put("ril", 57);
    freq.put("rim", 26);
    freq.put("rik", 77);
    freq.put("rih", 3);
    freq.put("rii", 63);
    freq.put("Tie", 24);
    freq.put("rid", 6);
    freq.put("rie", 10);
    freq.put("ric", 5);
    freq.put("ria", 250);
    freq.put("pö", 27);
    freq.put("pä", 483);
    freq.put("Cor", 4);
    freq.put("Väy", 5);
    freq.put("Ilm", 14);
    freq.put("Ilv", 5);
    freq.put("Ilt", 6);
    freq.put("Väi", 4);
    freq.put("Väh", 9);
    freq.put("Com", 5);
    freq.put("Col", 3);
    freq.put("ri ", 212);
    freq.put("Con", 5);
    freq.put("Ai ", 12);
    freq.put("Aiv", 4);
    freq.put("Air", 4);
    freq.put("Ain", 18);
    freq.put("Aik", 22);
    freq.put("Epä", 4);
    freq.put("lji", 5);
    freq.put("ljo", 56);
    freq.put("lja", 38);
    freq.put("lje", 26);
    freq.put("ylä", 33);
    freq.put("NÄ ", 4);
    freq.put("yl ", 28);
    freq.put("ylv", 3);
    freq.put("dro", 6);
    freq.put("Rom", 5);
    freq.put("Ron", 3);
    freq.put("Roo", 6);
    freq.put("Rob", 3);
    freq.put("ljä", 10);
    freq.put("yly", 5);
    freq.put("yle", 31);
    freq.put("yla", 3);
    freq.put("yll", 101);
    freq.put("ylm", 6);
    freq.put("ylk", 6);
    freq.put("Rov", 9);
    freq.put("yli", 75);
    freq.put("smä", 5);
    freq.put("lää", 38);
    freq.put(" uu", 153);
    freq.put(" up", 5);
    freq.put(" ur", 18);
    freq.put(" us", 48);
    freq.put(" ul", 32);
    freq.put(" un", 29);
    freq.put(" uh", 21);
    freq.put(" ui", 3);
    freq.put(" uk", 7);
    freq.put("rä ", 30);
    freq.put("rät", 22);
    freq.put("räv", 4);
    freq.put("å", 3);
    freq.put("räs", 15);
    freq.put("ix ", 3);
    freq.put("räa", 6);
    freq.put("räl", 4);
    freq.put("rän", 21);
    freq.put("räi", 16);
    freq.put("räh", 5);
    freq.put("räk", 5);
    freq.put("räj", 9);
    freq.put("läa", 3);
    freq.put("läk", 31);
    freq.put("läi", 27);
    freq.put("läh", 104);
    freq.put("län", 16);
    freq.put("läm", 54);
    freq.put("läl", 3);
    freq.put("läs", 19);
    freq.put("lär", 4);
    freq.put("läp", 15);
    freq.put("lät", 27);
    freq.put("gre", 5);
    freq.put("gra", 9);
    freq.put("gro", 4);
    freq.put("lä ", 412);
    freq.put("rää", 18);
    freq.put("eda", 4);
    freq.put("ede", 51);
    freq.put("rrä", 10);
    freq.put("edo", 34);
    freq.put("Hak", 6);
    freq.put("edu", 22);
    freq.put("FF ", 3);
    freq.put("ed ", 22);
    freq.put("hkö", 11);
    freq.put("P", 630);
    freq.put("hkä", 41);
    freq.put("Kyl", 18);
    freq.put("oje", 59);
    freq.put("Kys", 3);
    freq.put("Kyr", 3);
    freq.put("rro", 33);
    freq.put("edä", 23);
    freq.put("rre", 14);
    freq.put("rra", 51);
    freq.put("rry", 6);
    freq.put("rru", 4);
    freq.put(" €", 16);
    freq.put("hku", 5);
    freq.put("hki", 6);
    freq.put("hko", 4);
    freq.put("hka", 25);
    freq.put("hke", 12);
    freq.put(" on", 734);
    freq.put("apr", 5);
    freq.put("aps", 29);
    freq.put("app", 63);
    freq.put("Mik", 40);
    freq.put("apt", 5);
    freq.put("apu", 36);
    freq.put("api", 38);
    freq.put("apo", 13);
    freq.put("apl", 4);
    freq.put("apa", 126);
    freq.put(" ok", 19);
    freq.put("use", 48);
    freq.put(" oh", 54);
    freq.put("usa", 22);
    freq.put("uso", 9);
    freq.put("usn", 5);
    freq.put("usm", 8);
    freq.put(" oi", 92);
    freq.put("usk", 95);
    freq.put("usj", 10);
    freq.put("usi", 156);
    freq.put("ush", 10);
    freq.put("usv", 13);
    freq.put("usu", 27);
    freq.put("ust", 317);
    freq.put("uss", 129);
    freq.put("fes", 15);
    freq.put("Hur", 3);
    freq.put("siä", 36);
    freq.put("Mic", 4);
    freq.put("usy", 3);
    freq.put(" ob", 3);
    freq.put(" Ru", 27);
    freq.put("us ", 255);
    freq.put(" Re", 35);
    freq.put(" Ra", 47);
    freq.put(" Ro", 34);
    freq.put(" Ri", 31);
    freq.put("tat", 60);
    freq.put("tau", 46);
    freq.put("tav", 176);
    freq.put("tap", 87);
    freq.put("tar", 170);
    freq.put("tas", 79);
    freq.put("tad", 12);
    freq.put("kys", 39);
    freq.put("taa", 721);
    freq.put("tab", 8);
    freq.put("tal", 114);
    freq.put("tam", 122);
    freq.put("tan", 150);
    freq.put("tao", 3);
    freq.put("tah", 16);
    freq.put(" ot", 53);
    freq.put("taj", 153);
    freq.put("tak", 120);
    freq.put("sis", 128);
    freq.put("sir", 7);
    freq.put("kyp", 7);
    freq.put("siv", 59);
    freq.put("siu", 3);
    freq.put("sit", 322);
    freq.put("siy", 3);
    freq.put("kyv", 5);
    freq.put("sic", 7);
    freq.put("sib", 3);
    freq.put("sia", 232);
    freq.put("sig", 5);
    freq.put("sie", 71);
    freq.put("sid", 19);
    freq.put("sik", 93);
    freq.put("sij", 27);
    freq.put("sii", 248);
    freq.put("sih", 8);
    freq.put("sio", 40);
    freq.put("sin", 393);
    freq.put("sim", 83);
    freq.put("sil", 88);
    freq.put("Eka", 3);
    freq.put("ta ", 1391);
    freq.put("si ", 685);
    freq.put(" Ää", 6);
    freq.put("öh", 35);
    freq.put("bya", 4);
    freq.put("Car", 7);
    freq.put("Cal", 4);
    freq.put("Pre", 8);
    freq.put("nfe", 3);
    freq.put("ltö", 4);
    freq.put("nfo", 6);
    freq.put("Pro", 15);
    freq.put("Pri", 5);
    freq.put("nfi", 6);
    freq.put("ltä", 98);
    freq.put("by ", 3);
    freq.put("ouk", 47);
    freq.put("ouh", 11);
    freq.put("oun", 21);
    freq.put("oul", 90);
    freq.put("oud", 16);
    freq.put("ous", 69);
    freq.put("our", 9);
    freq.put("oup", 5);
    freq.put("ouu", 7);
    freq.put("out", 44);
    freq.put("ouM", 4);
    freq.put("lt ", 9);
    freq.put("ouT", 8);
    freq.put("ou ", 4);
    freq.put("ltr", 3);
    freq.put("ltu", 15);
    freq.put("ltt", 22);
    freq.put("lty", 3);
    freq.put("lta", 213);
    freq.put("lti", 30);
    freq.put("lto", 28);
    freq.put("ü", 6);
    freq.put("K ", 35);
    freq.put("Ame", 5);
    freq.put("Ka", 186);
    freq.put("Ke", 80);
    freq.put("Ki", 113);
    freq.put("Ko", 173);
    freq.put("Kl", 14);
    freq.put("Kr", 21);
    freq.put("Ku", 229);
    freq.put("Ky", 28);
    freq.put("hr", 23);
    freq.put("Kä", 44);
    freq.put("Yhd", 13);
    freq.put("Yht", 6);
    freq.put("Pow", 3);
    freq.put("Por", 14);
    freq.put("Pos", 5);
    freq.put("Pop", 9);
    freq.put("Pol", 17);
    freq.put("Pom", 4);
    freq.put("Poj", 4);
    freq.put("Pok", 4);
    freq.put("Poh", 14);
    freq.put("Poi", 8);
    freq.put("Pod", 3);
    freq.put("Cha", 4);
    freq.put("ha", 711);
    freq.put("no ", 78);
    freq.put(" we", 9);
    freq.put("qu", 3);
    freq.put(" wa", 3);
    freq.put("Chr", 4);
    freq.put(" wi", 5);
    freq.put(" ww", 11);
    freq.put("Jak", 4);
    freq.put("iks", 126);
    freq.put("ebo", 28);
    freq.put("ebi", 4);
    freq.put("jo ", 77);
    freq.put("nö ", 3);
    freq.put("Jac", 5);
    freq.put("jop", 5);
    freq.put("jos", 139);
    freq.put("eb ", 3);
    freq.put("jou", 67);
    freq.put("joa", 7);
    freq.put("joh", 59);
    freq.put("joi", 112);
    freq.put("joj", 3);
    freq.put("jok", 90);
    freq.put("jol", 88);
    freq.put("Ter", 17);
    freq.put("nöi", 8);
    freq.put("joo", 65);
    freq.put("rpp", 6);
    freq.put("CD ", 14);
    freq.put("rpa", 6);
    freq.put("rpe", 13);
    freq.put("avä", 5);
    freq.put("bbi", 3);
    freq.put("Juk", 6);
    freq.put("Juh", 4);
    freq.put("Jun", 5);
    freq.put("Jul", 3);
    freq.put("Jum", 4);
    freq.put("Jus", 15);
    freq.put("Juu", 10);
    freq.put("hmm", 8);
    freq.put("hmo", 6);
    freq.put("hmi", 43);
    freq.put("hme", 18);
    freq.put("hma", 4);
    freq.put("é", 3);
    freq.put(" Tö", 4);
    freq.put(" Tä", 96);
    freq.put("Oyj", 3);
    freq.put("avu", 27);
    freq.put("ē", 5);
    freq.put("avo", 33);
    freq.put("avi", 55);
    freq.put("ave", 52);
    freq.put("ava", 459);
    freq.put(" T ", 12);
    freq.put("Vuo", 18);
    freq.put("hmä", 32);
    freq.put(" Ty", 104);
    freq.put(" Tw", 20);
    freq.put(" Tu", 111);
    freq.put(" Ts", 18);
    freq.put(" Tr", 12);
    freq.put(" To", 88);
    freq.put(" Ti", 51);
    freq.put(" Th", 22);
    freq.put("tju", 3);
    freq.put(" Te", 89);
    freq.put(" Ta", 365);
    freq.put("Ei ", 49);
    freq.put("tch", 6);
    freq.put("lex", 3);
    freq.put("sku", 121);
    freq.put("Far", 4);
    freq.put("nop", 25);
    freq.put("sky", 29);
    freq.put("ske", 105);
    freq.put("ska", 134);
    freq.put("nor", 10);
    freq.put("Fac", 25);
    freq.put("sko", 72);
    freq.put("ski", 92);
    freq.put("Eip", 3);
    freq.put("Eiv", 3);
    freq.put("T", 1068);
    freq.put("Eik", 18);
    freq.put("Eil", 6);
    freq.put("sk ", 7);
    freq.put("Suo", 122);
    freq.put("Sun", 6);
    freq.put("Sum", 4);
    freq.put("Sul", 3);
    freq.put("Suk", 5);
    freq.put("Suu", 8);
    freq.put("Sus", 3);
    freq.put("Sup", 6);
    freq.put("skö", 4);
    freq.put("nd ", 21);
    freq.put("skä", 13);
    freq.put("tae", 5);
    freq.put("ndi", 38);
    freq.put("ndo", 16);
    freq.put("nda", 8);
    freq.put("nde", 21);
    freq.put("ndr", 9);
    freq.put("öa", 4);
    freq.put("own", 3);
    freq.put("öd", 11);
    freq.put("öe", 4);
    freq.put("owe", 11);
    freq.put("öi", 82);
    freq.put("öj", 17);
    freq.put("ök", 63);
    freq.put("öl", 32);
    freq.put("öm", 36);
    freq.put("ön", 100);
    freq.put("myö", 84);
    freq.put("öp", 39);
    freq.put("ör", 57);
    freq.put("ös", 136);
    freq.put("öt", 74);
    freq.put("öv", 7);
    freq.put("öy", 78);
    freq.put("ows", 12);
    freq.put("vaj", 5);
    freq.put("vak", 34);
    freq.put("vah", 28);
    freq.put("vai", 212);
    freq.put("van", 145);
    freq.put("val", 195);
    freq.put("vam", 9);
    freq.put("vaa", 243);
    freq.put("vaf", 3);
    freq.put("var", 281);
    freq.put("vas", 161);
    freq.put("vap", 18);
    freq.put("vav", 8);
    freq.put("vat", 239);
    freq.put("vau", 43);
    freq.put("ö ", 132);
    freq.put("ow ", 14);
    freq.put("Teh", 5);
    freq.put("Tei", 8);
    freq.put("Tek", 20);
    freq.put("Ten", 3);
    freq.put("Tea", 7);
    freq.put("va ", 156);
    freq.put("Tec", 3);
    freq.put("Tee", 16);
    freq.put("lve", 54);
    freq.put("lva", 5);
    freq.put("Tep", 3);
    freq.put("lvo", 5);
    freq.put("lvi", 33);
    freq.put("myy", 42);
    freq.put("öä", 12);
    freq.put("mys", 15);
    freq.put("myr", 10);
    freq.put("myi", 3);
    freq.put("myk", 6);
    freq.put("myl", 3);
    freq.put("öö", 23);
    freq.put("yö", 318);
    freq.put("my ", 8);
    freq.put("Oy ", 3);
    freq.put("Co", 19);
    freq.put("lvä", 9);
  }
  
}

