package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class FR {
  private static final String name = "fr";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public FR() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2228383;
    n_words[1] = 2767543;
    n_words[2] = 2164754;

    freq.put("nço", 68);
    freq.put("gai", 48);
    freq.put("sn ", 25);
    freq.put("Cre", 25);
    freq.put("dez", 153);
    freq.put("MA ", 35);
    freq.put("lè", 588);
    freq.put(" G ", 84);
    freq.put("mbl", 416);
    freq.put("Mat", 104);
    freq.put("reu", 585);
    freq.put(" po", 7885);
    freq.put("boî", 26);
    freq.put("sch", 54);
    freq.put("auc", 586);
    freq.put("aub", 29);
    freq.put("tôt", 355);
    freq.put("mp ", 93);
    freq.put("aug", 65);
    freq.put("auf", 170);
    freq.put("ali", 998);
    freq.put("aum", 66);
    freq.put("blo", 381);
    freq.put("up ", 697);
    freq.put("Cro", 36);
    freq.put("fiq", 148);
    freq.put("xte", 90);
    freq.put("rei", 259);
    freq.put("aut", 2206);
    freq.put("G ", 325);
    freq.put("xto", 23);
    freq.put("éra", 425);
    freq.put("bru", 104);
    freq.put("ére", 493);
    freq.put("Joe", 23);
    freq.put("bur", 85);
    freq.put(" Gu", 168);
    freq.put(" Gr", 363);
    freq.put("Tun", 67);
    freq.put("alb", 151);
    freq.put("rug", 65);
    freq.put("alc", 109);
    freq.put("ble", 1773);
    freq.put("èè", 36);
    freq.put(" Ge", 224);
    freq.put("Eh ", 44);
    freq.put(" Ga", 295);
    freq.put("ava", 1700);
    freq.put(" Go", 381);
    freq.put(" Gl", 54);
    freq.put("ala", 468);
    freq.put("réé", 59);
    freq.put(" Gi", 119);
    freq.put("upo", 28);
    freq.put("Gu", 169);
    freq.put("éle", 146);
    freq.put("Gr", 367);
    freq.put("mni", 29);
    freq.put(" êt", 1109);
    freq.put("ë", 55);
    freq.put("upe", 722);
    freq.put("œur", 55);
    freq.put("drô", 84);
    freq.put("éli", 317);
    freq.put("Ok ", 105);
    freq.put("Ge", 239);
    freq.put("élu", 34);
    freq.put("Ga", 302);
    freq.put("ait", 5903);
    freq.put("Go", 384);
    freq.put("uts", 84);
    freq.put("upt", 33);
    freq.put("Gl", 54);
    freq.put("upr", 31);
    freq.put("ups", 59);
    freq.put("Gi", 120);
    freq.put(" ka", 64);
    freq.put("me ", 8693);
    freq.put(" ke", 111);
    freq.put("oré", 94);
    freq.put(" ki", 247);
    freq.put(" ko", 55);
    freq.put("umm", 31);
    freq.put(" km", 36);
    freq.put("ais", 12639);
    freq.put("Vas", 25);
    freq.put("lté", 28);
    freq.put("è ", 61);
    freq.put("air", 3144);
    freq.put("ptu", 39);
    freq.put("fér", 317);
    freq.put("nel", 257);
    freq.put("nem", 285);
    freq.put("Pui", 54);
    freq.put(" y ", 1712);
    freq.put("uot", 52);
    freq.put("lèn", 85);
    freq.put("Z ", 89);
    freq.put("ET ", 62);
    freq.put("Pub", 26);
    freq.put("nea", 56);
    freq.put("éré", 197);
    freq.put("érê", 49);
    freq.put("ngt", 157);
    freq.put("nez", 227);
    freq.put("nex", 44);
    freq.put("ney", 98);
    freq.put("Put", 167);
    freq.put("dr ", 395);
    freq.put("net", 497);
    freq.put("scr", 247);
    freq.put("ner", 944);
    freq.put("nes", 1169);
    freq.put("fém", 30);
    freq.put("mee", 32);
    freq.put("À", 81);
    freq.put(" k ", 32);
    freq.put("ou ", 2023);
    freq.put("mea", 29);
    freq.put("mec", 433);
    freq.put("TL ", 134);
    freq.put("èr", 1868);
    freq.put("ès", 1625);
    freq.put("èq", 24);
    freq.put("èv", 187);
    freq.put("èt", 337);
    freq.put("là ", 1113);
    freq.put("meu", 417);
    freq.put("ù", 373);
    freq.put("èn", 290);
    freq.put("èl", 99);
    freq.put("èm", 497);
    freq.put("èc", 182);
    freq.put("TT ", 96);
    freq.put("èg", 179);
    freq.put("èd", 38);
    freq.put(" Gé", 74);
    freq.put("gli", 48);
    freq.put("dio", 169);
    freq.put("Zo", 37);
    freq.put("glo", 40);
    freq.put("gla", 205);
    freq.put("k", 4569);
    freq.put("drr", 343);
    freq.put("gle", 439);
    freq.put(" èr", 51);
    freq.put("sla", 54);
    freq.put("dri", 82);
    freq.put("fé ", 81);
    freq.put("orm", 975);
    freq.put("aic", 24);
    freq.put("dro", 439);
    freq.put("tw", 1023);
    freq.put("dra", 374);
    freq.put("que", 11436);
    freq.put("aka", 30);
    freq.put("rés", 790);
    freq.put("dre", 1295);
    freq.put("der", 1097);
    freq.put("Gé", 75);
    freq.put("nk ", 52);
    freq.put("auj", 262);
    freq.put("sso", 331);
    freq.put("Là", 44);
    freq.put("Jeu", 74);
    freq.put("uce", 130);
    freq.put("ori", 445);
    freq.put("péd", 42);
    freq.put("RL ", 25);
    freq.put("aul", 106);
    freq.put("ent", 12004);
    freq.put("Jea", 116);
    freq.put("vp ", 31);
    freq.put("bri", 175);
    freq.put("lma", 48);
    freq.put("èvr", 27);
    freq.put("pér", 300);
    freq.put("oni", 288);
    freq.put("pét", 146);
    freq.put("bra", 230);
    freq.put("upé", 118);
    freq.put("adi", 269);
    freq.put("m ", 3572);
    freq.put("DJ ", 33);
    freq.put("met", 798);
    freq.put("ené", 25);
    freq.put("enê", 23);
    freq.put("voc", 61);
    freq.put("aus", 1539);
    freq.put(" sl", 54);
    freq.put("lme", 90);
    freq.put("réd", 146);
    freq.put("vol", 287);
    freq.put("aur", 829);
    freq.put("er ", 12190);
    freq.put("épa", 310);
    freq.put("det", 90);
    freq.put("ni ", 388);
    freq.put("Val", 80);
    freq.put("Ste", 65);
    freq.put("laî", 24);
    freq.put("ir", 11882);
    freq.put("rès", 1380);
    freq.put("nke", 26);
    freq.put("ucc", 60);
    freq.put("pé ", 191);
    freq.put(" mè", 239);
    freq.put("éro", 226);
    freq.put(" mé", 557);
    freq.put("Je ", 2984);
    freq.put("nks", 23);
    freq.put("osp", 37);
    freq.put("Str", 75);
    freq.put("V", 2000);
    freq.put("iv", 2918);
    freq.put("jme", 56);
    freq.put("me", 20538);
    freq.put("md", 541);
    freq.put("mg", 32);
    freq.put("mba", 150);
    freq.put("ma", 13453);
    freq.put("ltu", 64);
    freq.put("err", 839);
    freq.put("mb", 1787);
    freq.put("mm", 4255);
    freq.put("ml", 30);
    freq.put("mo", 8390);
    freq.put("mn", 148);
    freq.put("mi", 4923);
    freq.put("ery", 29);
    freq.put("mu", 818);
    freq.put("mt", 64);
    freq.put("erf", 73);
    freq.put("erg", 151);
    freq.put("mp", 4049);
    freq.put("ms", 388);
    freq.put("erc", 1623);
    freq.put("erl", 59);
    freq.put("erm", 461);
    freq.put("ern", 934);
    freq.put("ero", 209);
    freq.put("my", 162);
    freq.put("eri", 512);
    freq.put("Le", 3095);
    freq.put("Nat", 51);
    freq.put("Lib", 100);
    freq.put("La", 1679);
    freq.put("Lil", 54);
    freq.put("Lo", 540);
    freq.put("Lin", 45);
    freq.put("Lio", 25);
    freq.put("la ", 10044);
    freq.put("Por", 64);
    freq.put("Li", 514);
    freq.put("Lit", 25);
    freq.put("nèt", 39);
    freq.put("Liv", 55);
    freq.put("Lu", 164);
    freq.put("ual", 166);
    freq.put("lov", 60);
    freq.put("uaa", 31);
    freq.put("uad", 28);
    freq.put("rèt", 28);
    freq.put("Ly", 98);
    freq.put("ena", 683);
    freq.put("hod", 30);
    freq.put("ib", 1091);
    freq.put("end", 2936);
    freq.put("hoc", 77);
    freq.put("enf", 523);
    freq.put("eng", 129);
    freq.put("hon", 664);
    freq.put("hoo", 59);
    freq.put("hol", 48);
    freq.put("hom", 285);
    freq.put("enl", 56);
    freq.put("Kan", 25);
    freq.put("enn", 675);
    freq.put("hoi", 187);
    freq.put("how", 44);
    freq.put("hot", 654);
    freq.put("hou", 308);
    freq.put("hor", 259);
    freq.put("hos", 368);
    freq.put("hop", 137);
    freq.put("hoq", 63);
    freq.put("sse", 3343);
    freq.put("al ", 1761);
    freq.put("Va ", 38);
    freq.put("uco", 400);
    freq.put("A", 5867);
    freq.put("lam", 118);
    freq.put("lan", 1190);
    freq.put("éri", 1026);
    freq.put("lah", 46);
    freq.put("nym", 30);
    freq.put("L ", 1304);
    freq.put("lad", 158);
    freq.put("ON ", 170);
    freq.put("fr ", 155);
    freq.put("ost", 354);
    freq.put("lab", 109);
    freq.put("lac", 531);
    freq.put("ova", 74);
    freq.put("lax", 39);
    freq.put("II ", 42);
    freq.put(" Ça", 245);
    freq.put("lat", 428);
    freq.put("lau", 83);
    freq.put("lav", 83);
    freq.put("pt ", 90);
    freq.put("lap", 59);
    freq.put("re ", 15837);
    freq.put("lar", 259);
    freq.put("las", 565);
    freq.put("en ", 10610);
    freq.put("Alo", 159);
    freq.put("All", 250);
    freq.put("ho ", 92);
    freq.put("Ali", 40);
    freq.put("Alg", 43);
    freq.put("cat", 488);
    freq.put("Ale", 45);
    freq.put("mé", 1289);
    freq.put("mè", 329);
    freq.put("mê", 1271);
    freq.put("lou", 471);
    freq.put("mpu", 37);
    freq.put("vou", 2336);
    freq.put("lqu", 485);
    freq.put("mpr", 624);
    freq.put("mps", 862);
    freq.put(" V ", 24);
    freq.put("aw ", 25);
    freq.put("ngu", 272);
    freq.put("lt ", 56);
    freq.put("too", 34);
    freq.put("ugb", 76);
    freq.put("fam", 162);
    freq.put("ès ", 1573);
    freq.put(" Hu", 134);
    freq.put("zer", 45);
    freq.put("mn ", 53);
    freq.put(" Hi", 134);
    freq.put("OM ", 42);
    freq.put(" Ho", 324);
    freq.put(" Hm", 23);
    freq.put("ucl", 69);
    freq.put("onn", 3547);
    freq.put(" Ha", 521);
    freq.put(" He", 293);
    freq.put("xo", 68);
    freq.put("ima", 612);
    freq.put("fis", 104);
    freq.put("éci", 354);
    freq.put("His", 23);
    freq.put("ime", 2284);
    freq.put("cli", 311);
    freq.put("fit", 137);
    freq.put(" f ", 40);
    freq.put("imi", 262);
    freq.put("cle", 372);
    freq.put("fix", 38);
    freq.put("imm", 107);
    freq.put("cla", 647);
    freq.put("imo", 91);
    freq.put("ssa", 1008);
    freq.put("imp", 692);
    freq.put("ims", 32);
    freq.put("rç", 87);
    freq.put("imu", 55);
    freq.put("Hie", 28);
    freq.put("goû", 73);
    freq.put("fie", 157);
    freq.put("cap", 208);
    freq.put("clu", 118);
    freq.put("uoi", 1531);
    freq.put("rè", 1705);
    freq.put("ré", 4916);
    freq.put("rê", 697);
    freq.put(" Va", 239);
    freq.put("Viv", 66);
    freq.put("ona", 279);
    freq.put(" Ve", 223);
    freq.put("RS ", 51);
    freq.put(" Vi", 471);
    freq.put("onf", 342);
    freq.put("SA ", 74);
    freq.put("fig", 47);
    freq.put(" Vo", 614);
    freq.put("prè", 786);
    freq.put("nté", 486);
    freq.put("ews", 125);
    freq.put(" Vr", 34);
    freq.put(" Vu", 53);
    freq.put("éan", 111);
    freq.put("efu", 55);
    freq.put(" H ", 114);
    freq.put("ègu", 34);
    freq.put("li ", 274);
    freq.put("im ", 138);
    freq.put("fid", 40);
    freq.put("l", 102611);
    freq.put("até", 141);
    freq.put("rèm", 43);
    freq.put("isé", 236);
    freq.put("cy ", 39);
    freq.put("nné", 480);
    freq.put("élo", 61);
    freq.put("dep", 409);
    freq.put("th ", 85);
    freq.put("twi", 389);
    freq.put("Lan", 46);
    freq.put("by ", 140);
    freq.put("UE ", 92);
    freq.put("Wow", 24);
    freq.put("Wor", 36);
    freq.put("uto", 387);
    freq.put(" Hé", 69);
    freq.put("hés", 117);
    freq.put("eum", 31);
    freq.put("mdr", 501);
    freq.put("nt ", 13665);
    freq.put("Pho", 255);
    freq.put("SS ", 48);
    freq.put("rt", 6081);
    freq.put("gol", 214);
    freq.put("goo", 55);
    freq.put("gon", 50);
    freq.put(" zi", 33);
    freq.put("rq", 689);
    freq.put("rr", 4169);
    freq.put("rs", 6667);
    freq.put("imé", 106);
    freq.put("zar", 139);
    freq.put("gog", 28);
    freq.put(" za", 42);
    freq.put("ry", 567);
    freq.put("goc", 26);
    freq.put("éna", 179);
    freq.put("rd", 3761);
    freq.put("re", 30928);
    freq.put("rf", 365);
    freq.put("rg", 910);
    freq.put("ra", 13892);
    freq.put("rb", 301);
    freq.put("rc", 3182);
    freq.put("gou", 194);
    freq.put("got", 23);
    freq.put("rn", 1970);
    freq.put("is ", 18642);
    freq.put("rh", 71);
    freq.put("ri", 9762);
    freq.put("gos", 90);
    freq.put("gor", 89);
    freq.put("Sch", 24);
    freq.put("anè", 41);
    freq.put("miè", 223);
    freq.put(" Vé", 26);
    freq.put("ntp", 31);
    freq.put("nts", 953);
    freq.put("ntr", 1985);
    freq.put("ntu", 92);
    freq.put("syn", 47);
    freq.put("nti", 1185);
    freq.put("nth", 58);
    freq.put("FR ", 36);
    freq.put("omé", 44);
    freq.put("W", 841);
    freq.put("nta", 721);
    freq.put("nie", 587);
    freq.put("nte", 3103);
    freq.put("deb", 69);
    freq.put("Vic", 31);
    freq.put("Via", 28);
    freq.put("ané", 25);
    freq.put("atc", 205);
    freq.put("Vid", 81);
    freq.put("Vie", 72);
    freq.put("iss", 1413);
    freq.put("ato", 212);
    freq.put("isq", 133);
    freq.put("isp", 232);
    freq.put("Vin", 33);
    freq.put("go ", 157);
    freq.put("isu", 25);
    freq.put("ist", 1495);
    freq.put("piq", 66);
    freq.put("Vis", 36);
    freq.put("isi", 835);
    freq.put("ish", 46);
    freq.put("r ", 33342);
    freq.put("isn", 25);
    freq.put("ism", 180);
    freq.put("isl", 26);
    freq.put("isc", 221);
    freq.put("caf", 57);
    freq.put("isa", 618);
    freq.put("où ", 337);
    freq.put("be ", 343);
    freq.put("ise", 1733);
    freq.put(" tê", 230);
    freq.put("nhe", 51);
    freq.put(" l ", 5309);
    freq.put("raî", 81);
    freq.put("lèm", 137);
    freq.put("pir", 369);
    freq.put("eui", 79);
    freq.put("nir", 515);
    freq.put("ype", 126);
    freq.put("osa", 42);
    freq.put("nis", 514);
    freq.put("TU ", 29);
    freq.put("tel", 615);
    freq.put("nip", 23);
    freq.put("scè", 51);
    freq.put("prê", 112);
    freq.put("niq", 288);
    freq.put("rèc", 46);
    freq.put("Man", 134);
    freq.put("alè", 39);
    freq.put("tor", 427);
    freq.put("Cen", 30);
    freq.put("top", 150);
    freq.put("Cel", 71);
    freq.put("equ", 113);
    freq.put("xim", 41);
    freq.put("tot", 146);
    freq.put("xio", 55);
    freq.put("xtr", 83);
    freq.put("Cet", 107);
    freq.put("Ces", 54);
    freq.put("Cer", 53);
    freq.put("tol", 32);
    freq.put("Se ", 50);
    freq.put("tob", 129);
    freq.put("toc", 65);
    freq.put("ême", 1401);
    freq.put("kt ", 59);
    freq.put("tog", 49);
    freq.put("tod", 27);
    freq.put(" le", 15703);
    freq.put("B", 4717);
    freq.put("uip", 147);
    freq.put(" la", 10599);
    freq.put(" lo", 1556);
    freq.put("ted", 29);
    freq.put(" li", 1952);
    freq.put("tee", 42);
    freq.put("égo", 165);
    freq.put(" lu", 884);
    freq.put("Fuc", 30);
    freq.put("iat", 186);
    freq.put("rôl", 159);
    freq.put(" ly", 168);
    freq.put("Seu", 27);
    freq.put("égl", 32);
    freq.put("Ser", 71);
    freq.put("Ce ", 354);
    freq.put("ca ", 651);
    freq.put("Sex", 29);
    freq.put("péc", 135);
    freq.put("Sec", 79);
    freq.put("égi", 126);
    freq.put("nze", 28);
    freq.put(" ep", 51);
    freq.put("to ", 589);
    freq.put("Sel", 82);
    freq.put("ept", 456);
    freq.put("Sei", 36);
    freq.put("éné", 204);
    freq.put("raf", 54);
    freq.put("rag", 371);
    freq.put("rad", 270);
    freq.put("epu", 445);
    freq.put("rab", 170);
    freq.put("rac", 457);
    freq.put("raa", 23);
    freq.put("ran", 2871);
    freq.put("rao", 25);
    freq.put("ral", 292);
    freq.put("ram", 344);
    freq.put("raj", 47);
    freq.put("rah", 32);
    freq.put("rai", 4296);
    freq.put("rav", 603);
    freq.put("Q ", 36);
    freq.put("rat", 981);
    freq.put("rau", 67);
    freq.put("rar", 80);
    freq.put("ras", 549);
    freq.put("rap", 656);
    freq.put("dur", 253);
    freq.put("î", 333);
    freq.put("raz", 27);
    freq.put("ase", 294);
    freq.put("ray", 56);
    freq.put("Ass", 63);
    freq.put("tho", 137);
    freq.put("Jus", 198);
    freq.put("eud", 160);
    freq.put("rte", 1055);
    freq.put("xiè", 57);
    freq.put("do ", 198);
    freq.put("epl", 29);
    freq.put("Sym", 33);
    freq.put("teu", 797);
    freq.put("piz", 23);
    freq.put("Sor", 43);
    freq.put("rse", 342);
    freq.put("Sou", 94);
    freq.put("app", 1395);
    freq.put("on ", 15436);
    freq.put("tyl", 86);
    freq.put("nen", 234);
    freq.put("AH ", 49);
    freq.put("Qu", 1074);
    freq.put(" lâ", 45);
    freq.put("ra ", 1384);
    freq.put(" là", 914);
    freq.put("bst", 25);
    freq.put("uem", 82);
    freq.put("Chu", 30);
    freq.put(" lé", 97);
    freq.put(" lè", 67);
    freq.put(" fi", 1978);
    freq.put("sud", 41);
    freq.put("bar", 238);
    freq.put("bse", 57);
    freq.put("ogr", 242);
    freq.put("typ", 60);
    freq.put("lèv", 114);
    freq.put("euf", 237);
    freq.put("epe", 63);
    freq.put("don", 1184);
    freq.put("dol", 53);
    freq.put("dom", 134);
    freq.put("uel", 1317);
    freq.put("doc", 63);
    freq.put("bso", 44);
    freq.put("m", 66329);
    freq.put("dod", 27);
    freq.put("aér", 31);
    freq.put("Tom", 34);
    freq.put("ogn", 49);
    freq.put("tha", 66);
    freq.put("lph", 24);
    freq.put("dor", 567);
    freq.put("dos", 145);
    freq.put("dop", 44);
    freq.put("epa", 142);
    freq.put("dow", 51);
    freq.put("dou", 354);
    freq.put(" We", 161);
    freq.put(" Wa", 168);
    freq.put("éq", 180);
    freq.put(" Wo", 107);
    freq.put("és", 2077);
    freq.put("ér", 2444);
    freq.put("éu", 156);
    freq.put("ét", 2734);
    freq.put(" Wh", 54);
    freq.put(" Wi", 148);
    freq.put("éi", 43);
    freq.put("éh", 93);
    freq.put("éj", 589);
    freq.put("ém", 810);
    freq.put("él", 1157);
    freq.put("éo", 417);
    freq.put("én", 920);
    freq.put("éa", 528);
    freq.put("éc", 2561);
    freq.put("éb", 528);
    freq.put("ée", 3628);
    freq.put("éd", 787);
    freq.put("ég", 774);
    freq.put("éf", 624);
    freq.put("oci", 386);
    freq.put("och", 643);
    freq.put("Bil", 28);
    freq.put("WE ", 28);
    freq.put("em ", 237);
    freq.put("oco", 126);
    freq.put("oca", 224);
    freq.put("Big", 36);
    freq.put("occ", 135);
    freq.put("Bie", 243);
    freq.put("oce", 57);
    freq.put("Ya ", 57);
    freq.put("ama", 734);
    freq.put("iré", 314);
    freq.put("hro", 83);
    freq.put("hri", 99);
    freq.put("cau", 211);
    freq.put("abo", 203);
    freq.put("sus", 215);
    freq.put("ocr", 64);
    freq.put("hra", 72);
    freq.put("Bis", 79);
    freq.put("sur", 4593);
    freq.put("dn", 31);
    freq.put("do", 3391);
    freq.put("dl", 67);
    freq.put("dm", 125);
    freq.put("dj", 46);
    freq.put("dh", 108);
    freq.put("di", 6474);
    freq.put("dg", 70);
    freq.put("dd", 195);
    freq.put("de", 31138);
    freq.put("db", 24);
    freq.put("dc", 55);
    freq.put("da", 4544);
    freq.put("pk ", 32);
    freq.put("tis", 367);
    freq.put("Sai", 104);
    freq.put("UX ", 47);
    freq.put("dy", 171);
    freq.put("dv", 54);
    freq.put("X", 489);
    freq.put("dt", 27);
    freq.put("du", 4853);
    freq.put("dr", 3202);
    freq.put("ds", 872);
    freq.put("dp", 35);
    freq.put(" el", 1584);
    freq.put("eme", 3355);
    freq.put("ébé", 77);
    freq.put("bat", 342);
    freq.put("neu", 178);
    freq.put("ema", 1588);
    freq.put("bas", 325);
    freq.put("ilà", 230);
    freq.put("emb", 818);
    freq.put("emm", 487);
    freq.put("oc ", 80);
    freq.put("emo", 143);
    freq.put("emi", 707);
    freq.put("ilé", 35);
    freq.put("oke", 69);
    freq.put("bag", 50);
    freq.put("bad", 25);
    freq.put("bab", 88);
    freq.put("emp", 1288);
    freq.put("bec", 30);
    freq.put("ban", 318);
    freq.put("Vos", 32);
    freq.put("Rie", 68);
    freq.put("Ric", 37);
    freq.put("bah", 295);
    freq.put("bai", 215);
    freq.put("om ", 506);
    freq.put("tem", 1516);
    freq.put("w ", 737);
    freq.put("Pet", 108);
    freq.put("Peu", 61);
    freq.put("PS ", 115);
    freq.put("épi", 159);
    freq.put("nus", 78);
    freq.put("Per", 137);
    freq.put("uré", 179);
    freq.put("éé", 237);
    freq.put("Pen", 66);
    freq.put("num", 166);
    freq.put("nui", 439);
    freq.put(" I ", 99);
    freq.put("Nan", 167);
    freq.put("nue", 311);
    freq.put("aan", 38);
    freq.put("nuc", 35);
    freq.put("éç", 40);
    freq.put("nua", 40);
    freq.put("abi", 331);
    freq.put("xéc", 27);
    freq.put("il ", 4167);
    freq.put("mur", 60);
    freq.put("irr", 39);
    freq.put("irs", 174);
    freq.put("irt", 105);
    freq.put("iru", 27);
    freq.put("un ", 6549);
    freq.put("iri", 98);
    freq.put("irl", 76);
    freq.put("irm", 151);
    freq.put("iro", 146);
    freq.put("mum", 45);
    freq.put("ira", 558);
    freq.put("uee", 26);
    freq.put("irc", 38);
    freq.put("pôt", 33);
    freq.put("ire", 5551);
    freq.put("omb", 568);
    freq.put("C", 6866);
    freq.put("men", 5855);
    freq.put("Exc", 53);
    freq.put("dè", 168);
    freq.put("dé", 4075);
    freq.put(" Ip", 27);
    freq.put("wn", 60);
    freq.put(" Ir", 37);
    freq.put(" Is", 69);
    freq.put(" It", 63);
    freq.put("ngs", 48);
    freq.put(" Iv", 23);
    freq.put("wh", 32);
    freq.put("ww", 136);
    freq.put("omp", 1396);
    freq.put(" Il", 1063);
    freq.put(" Im", 96);
    freq.put(" In", 491);
    freq.put(" Ic", 34);
    freq.put(" Id", 34);
    freq.put("nu ", 245);
    freq.put("elo", 349);
    freq.put("DM ", 89);
    freq.put("gge", 30);
    freq.put("ild", 25);
    freq.put("ile", 753);
    freq.put("cou", 2966);
    freq.put("ell", 4165);
    freq.put("ila", 218);
    freq.put("ilo", 101);
    freq.put("ill", 3266);
    freq.put("ilm", 285);
    freq.put("tt ", 196);
    freq.put("ili", 625);
    freq.put("una", 86);
    freq.put("coc", 105);
    freq.put("unc", 34);
    freq.put("coe", 128);
    freq.put("ils", 1017);
    freq.put("unf", 75);
    freq.put("ung", 59);
    freq.put("ir ", 4420);
    freq.put("uni", 414);
    freq.put("ébr", 40);
    freq.put("léc", 106);
    freq.put("com", 3921);
    freq.put("Gau", 26);
    freq.put("coo", 313);
    freq.put("ily", 58);
    freq.put(" md", 532);
    freq.put(" me", 6542);
    freq.put("ela", 247);
    freq.put(" ma", 8842);
    freq.put("ead", 103);
    freq.put("can", 527);
    freq.put(" mm", 71);
    freq.put(" mn", 48);
    freq.put(" mo", 7198);
    freq.put(" mi", 1903);
    freq.put("elg", 39);
    freq.put("ié", 539);
    freq.put(" mu", 422);
    freq.put("lâc", 44);
    freq.put("Pas", 297);
    freq.put(" ms", 60);
    freq.put("hée", 55);
    freq.put("pra", 77);
    freq.put("ele", 322);
    freq.put(" my", 99);
    freq.put("ana", 384);
    freq.put("fra", 663);
    freq.put("Rou", 64);
    freq.put("che", 4114);
    freq.put("fre", 300);
    freq.put("Ros", 26);
    freq.put("lti", 79);
    freq.put("fri", 183);
    freq.put("C ", 2097);
    freq.put("fro", 161);
    freq.put("Sol", 40);
    freq.put("faç", 94);
    freq.put("anl", 25);
    freq.put("gn ", 38);
    freq.put("Gal", 46);
    freq.put("fru", 36);
    freq.put("mez", 51);
    freq.put("Boo", 44);
    freq.put("ann", 932);
    freq.put("ab ", 75);
    freq.put("niè", 194);
    freq.put("ano", 182);
    freq.put(" m ", 1475);
    freq.put("lms", 61);
    freq.put("pri", 1292);
    freq.put("xxx", 28);
    freq.put("spé", 173);
    freq.put("rêt", 482);
    freq.put("Gag", 50);
    freq.put("Cra", 27);
    freq.put("éni", 219);
    freq.put("els", 240);
    freq.put("Cri", 32);
    freq.put("elp", 32);
    freq.put("cac", 191);
    freq.put("Ci", 116);
    freq.put("Ch", 838);
    freq.put("Co", 1377);
    freq.put("aix", 35);
    freq.put("rix", 188);
    freq.put("Cl", 201);
    freq.put("Cc", 48);
    freq.put("Vé", 26);
    freq.put("Ca", 945);
    freq.put(" yo", 143);
    freq.put("anv", 35);
    freq.put("Ce", 706);
    freq.put("n", 141888);
    freq.put("aim", 1841);
    freq.put("ail", 893);
    freq.put("Cy", 33);
    freq.put("gna", 147);
    freq.put("aii", 52);
    freq.put("rgn", 23);
    freq.put("thé", 93);
    freq.put("gne", 900);
    freq.put("aie", 504);
    freq.put("Cr", 171);
    freq.put("aig", 111);
    freq.put("gni", 191);
    freq.put("gno", 244);
    freq.put("Cu", 71);
    freq.put("ôt", 589);
    freq.put("ix", 682);
    freq.put("iz", 344);
    freq.put("rtu", 184);
    freq.put("Dim", 31);
    freq.put("iq", 2367);
    freq.put("ip", 984);
    freq.put("is", 27103);
    freq.put(" ef", 200);
    freq.put("iu", 74);
    freq.put("it", 16132);
    freq.put(" mê", 1270);
    freq.put("Za", 94);
    freq.put("ii", 799);
    freq.put("ih", 102);
    freq.put("ik", 275);
    freq.put("ij", 57);
    freq.put("im", 4438);
    freq.put("il", 10920);
    freq.put("io", 6005);
    freq.put("in", 15447);
    freq.put("ia", 2906);
    freq.put("opp", 170);
    freq.put("ic", 3883);
    freq.put("ki ", 104);
    freq.put("ie", 14710);
    freq.put("id", 2372);
    freq.put("ig", 2122);
    freq.put("if", 1418);
    freq.put("V ", 264);
    freq.put("ué ", 434);
    freq.put("uje", 75);
    freq.put("Tro", 164);
    freq.put("art", 2022);
    freq.put("iP", 265);
    freq.put("fré", 24);
    freq.put("frè", 77);
    freq.put("hét", 23);
    freq.put("iT", 27);
    freq.put("dha", 70);
    freq.put("any", 49);
    freq.put("add", 40);
    freq.put("iO", 28);
    freq.put("Die", 56);
    freq.put("HP ", 47);
    freq.put("bid", 33);
    freq.put("ep ", 93);
    freq.put("iF", 24);
    freq.put("bie", 2156);
    freq.put("nin", 97);
    freq.put("nio", 93);
    freq.put("nim", 140);
    freq.put("kis", 26);
    freq.put("nic", 145);
    freq.put("nia", 170);
    freq.put("nif", 241);
    freq.put("nig", 46);
    freq.put("Ob", 71);
    freq.put("kik", 35);
    freq.put("tz ", 29);
    freq.put("lta", 114);
    freq.put("kin", 93);
    freq.put("kil", 43);
    freq.put("Y", 730);
    freq.put("i ", 24481);
    freq.put("kia", 23);
    freq.put("Cré", 34);
    freq.put("niv", 308);
    freq.put("kif", 107);
    freq.put("kie", 39);
    freq.put("mil", 457);
    freq.put("Va", 239);
    freq.put("Cé", 35);
    freq.put("Ve", 224);
    freq.put("sme", 211);
    freq.put("Rév", 25);
    freq.put("Vi", 475);
    freq.put(" pâ", 27);
    freq.put(" L ", 775);
    freq.put("epr", 331);
    freq.put("Rés", 48);
    freq.put("Rép", 47);
    freq.put("Vo", 625);
    freq.put("ône", 57);
    freq.put("epo", 178);
    freq.put("Vr", 34);
    freq.put("Vu", 53);
    freq.put("eph", 36);
    freq.put("epi", 52);
    freq.put("biz", 119);
    freq.put("the", 169);
    freq.put("gné", 148);
    freq.put("CV ", 24);
    freq.put("Cô", 26);
    freq.put("rén", 84);
    freq.put("yem", 87);
    freq.put("yel", 31);
    freq.put("yen", 175);
    freq.put("olè", 78);
    freq.put("olé", 200);
    freq.put("rn ", 36);
    freq.put("âch", 89);
    freq.put("yez", 85);
    freq.put("op ", 1562);
    freq.put("tin", 1049);
    freq.put("St ", 25);
    freq.put("rir", 596);
    freq.put("yer", 275);
    freq.put("yeu", 187);
    freq.put("bit", 311);
    freq.put("vig", 56);
    freq.put("hah", 833);
    freq.put("hai", 459);
    freq.put("eli", 238);
    freq.put("hal", 130);
    freq.put("ham", 265);
    freq.put("han", 1309);
    freq.put("mix", 62);
    freq.put("haa", 52);
    freq.put("hab", 260);
    freq.put("hac", 76);
    freq.put("had", 29);
    freq.put("Gar", 44);
    freq.put("haf", 66);
    freq.put("hag", 32);
    freq.put("Gam", 53);
    freq.put("Hé", 71);
    freq.put("hap", 107);
    freq.put("haq", 154);
    freq.put("har", 400);
    freq.put("has", 122);
    freq.put("hat", 262);
    freq.put("hau", 431);
    freq.put("icô", 26);
    freq.put("opt", 65);
    freq.put("opu", 53);
    freq.put("rni", 442);
    freq.put("lcu", 32);
    freq.put("rno", 45);
    freq.put("D", 5645);
    freq.put("opr", 79);
    freq.put("ops", 34);
    freq.put("Tra", 108);
    freq.put("Mêm", 116);
    freq.put("rna", 429);
    freq.put(" Ét", 52);
    freq.put("rne", 582);
    freq.put("vio", 151);
    freq.put("ope", 228);
    freq.put("opa", 78);
    freq.put("opl", 40);
    freq.put("lco", 94);
    freq.put(" Éc", 31);
    freq.put("oph", 141);
    freq.put("opi", 183);
    freq.put("plé", 56);
    freq.put("plè", 49);
    freq.put("bro", 113);
    freq.put("Arr", 69);
    freq.put(" è ", 23);
    freq.put("Art", 57);
    freq.put("Sur", 205);
    freq.put("vis", 562);
    freq.put("ha ", 509);
    freq.put("el ", 1483);
    freq.put("tib", 26);
    freq.put("ués", 52);
    freq.put("ï", 124);
    freq.put("mit", 229);
    freq.put("ape", 317);
    freq.put("rva", 71);
    freq.put("Arc", 47);
    freq.put("eet", 722);
    freq.put("DR ", 113);
    freq.put("Lyo", 80);
    freq.put("uez", 54);
    freq.put("aud", 462);
    freq.put("Arn", 25);
    freq.put("veu", 1301);
    freq.put("ola", 284);
    freq.put("hs ", 68);
    freq.put("tub", 50);
    freq.put("old", 86);
    freq.put("ole", 718);
    freq.put("MP ", 59);
    freq.put(" Ju", 360);
    freq.put("oli", 613);
    freq.put(" X ", 52);
    freq.put("oll", 1038);
    freq.put("olo", 356);
    freq.put("loc", 149);
    freq.put(" Jo", 409);
    freq.put("ols", 42);
    freq.put(" Ji", 26);
    freq.put("olu", 225);
    freq.put("ypo", 24);
    freq.put(" Je", 3268);
    freq.put("koz", 107);
    freq.put(" Ja", 311);
    freq.put("bre", 912);
    freq.put("ick", 161);
    freq.put("fou", 572);
    freq.put("ici", 871);
    freq.put("ich", 445);
    freq.put("ico", 242);
    freq.put("haî", 46);
    freq.put("icl", 184);
    freq.put("tei", 122);
    freq.put("ica", 654);
    freq.put("chr", 65);
    freq.put("ice", 471);
    freq.put("Hu", 134);
    freq.put("ume", 453);
    freq.put("Hi", 136);
    freq.put("Let", 32);
    freq.put("Ho", 331);
    freq.put("Hm", 23);
    freq.put("ics", 57);
    freq.put("icr", 52);
    freq.put("fon", 565);
    freq.put("Ha", 528);
    freq.put("umi", 80);
    freq.put("foi", 632);
    freq.put("icu", 117);
    freq.put("ict", 207);
    freq.put("ol ", 815);
    freq.put("Trè", 68);
    freq.put("rné", 409);
    freq.put("eek", 184);
    freq.put("upl", 118);
    freq.put("cu ", 51);
    freq.put("Rem", 29);
    freq.put("ple", 998);
    freq.put("ww ", 56);
    freq.put("pla", 1071);
    freq.put("Kha", 24);
    freq.put("plo", 292);
    freq.put("yri", 43);
    freq.put(" J ", 2456);
    freq.put("pli", 468);
    freq.put("Le ", 1682);
    freq.put("obo", 34);
    freq.put("obl", 291);
    freq.put("obj", 42);
    freq.put("sfo", 40);
    freq.put("www", 71);
    freq.put("ic ", 364);
    freq.put("oin", 1109);
    freq.put("o", 132531);
    freq.put("oba", 93);
    freq.put("ome", 567);
    freq.put("ai ", 5068);
    freq.put("fo ", 83);
    freq.put("um ", 408);
    freq.put("H ", 277);
    freq.put("obr", 133);
    freq.put("obs", 93);
    freq.put("xu", 44);
    freq.put("soc", 314);
    freq.put("mbo", 82);
    freq.put("soe", 114);
    freq.put("chu", 101);
    freq.put("ppe", 718);
    freq.put("sof", 29);
    freq.put("soi", 1411);
    freq.put("mbe", 249);
    freq.put("ppi", 39);
    freq.put("ahi", 50);
    freq.put("som", 191);
    freq.put("sol", 516);
    freq.put("son", 3734);
    freq.put("sop", 25);
    freq.put("sos", 30);
    freq.put("sor", 661);
    freq.put("Fer", 36);
    freq.put("Fes", 29);
    freq.put("rv", 726);
    freq.put("ît ", 83);
    freq.put("Cul", 24);
    freq.put("opo", 263);
    freq.put("uno", 34);
    freq.put("mbr", 604);
    freq.put("nè", 68);
    freq.put("né", 1738);
    freq.put("nê", 42);
    freq.put("dèl", 59);
    freq.put("gis", 87);
    freq.put("gir", 49);
    freq.put("giq", 133);
    freq.put("Pff", 30);
    freq.put("wag", 23);
    freq.put("eac", 32);
    freq.put("nç", 454);
    freq.put("éch", 355);
    freq.put("gie", 211);
    freq.put("gic", 42);
    freq.put("tié", 95);
    freq.put("gia", 41);
    freq.put("gio", 72);
    freq.put("gin", 253);
    freq.put("gim", 28);
    freq.put("gil", 35);
    freq.put("dès", 82);
    freq.put("war", 55);
    freq.put("ten", 2063);
    freq.put("ret", 1061);
    freq.put(" né", 119);
    freq.put("so ", 140);
    freq.put("ah ", 1237);
    freq.put(" Jv", 32);
    freq.put("VE ", 36);
    freq.put("TE ", 98);
    freq.put("îtr", 74);
    freq.put("mb ", 26);
    freq.put("oil", 467);
    freq.put("éco", 907);
    freq.put("xy ", 58);
    freq.put("ête", 893);
    freq.put("low", 577);
    freq.put("tiè", 74);
    freq.put("Z", 335);
    freq.put("îte", 36);
    freq.put("arv", 23);
    freq.put("ura", 1044);
    freq.put("azi", 64);
    freq.put("SK ", 100);
    freq.put("azo", 46);
    freq.put("iqu", 2362);
    freq.put("êta", 23);
    freq.put("urc", 126);
    freq.put("Voi", 150);
    freq.put("pèt", 41);
    freq.put("Vot", 35);
    freq.put("Vou", 331);
    freq.put("tèm", 45);
    freq.put("bér", 51);
    freq.put("ouu", 108);
    freq.put("Lun", 38);
    freq.put("gi ", 23);
    freq.put("olt", 44);
    freq.put("urn", 842);
    freq.put("nno", 265);
    freq.put("nnn", 64);
    freq.put("uro", 403);
    freq.put("mbé", 63);
    freq.put("nni", 263);
    freq.put("Au ", 209);
    freq.put(" n ", 1512);
    freq.put("ppé", 76);
    freq.put("vi ", 70);
    freq.put("imb", 39);
    freq.put("uri", 455);
    freq.put("thm", 40);
    freq.put("uvi", 66);
    freq.put("D ", 1115);
    freq.put("nny", 30);
    freq.put("oly", 27);
    freq.put("tea", 167);
    freq.put("nnu", 194);
    freq.put("urk", 33);
    freq.put("Sin", 140);
    freq.put("Sim", 81);
    freq.put("Sta", 116);
    freq.put("nh", 104);
    freq.put("ni", 4162);
    freq.put("nj", 336);
    freq.put("nk", 155);
    freq.put("nl", 120);
    freq.put("nm", 26);
    freq.put("nn", 5459);
    freq.put("no", 5925);
    freq.put("tit", 1123);
    freq.put("na", 4393);
    freq.put("nb", 52);
    freq.put("nc", 6644);
    freq.put("nd", 8511);
    freq.put("ne", 16244);
    freq.put("nf", 1468);
    freq.put("ng", 3060);
    freq.put("til", 552);
    freq.put("ny", 206);
    freq.put("nz", 77);
    freq.put("tio", 3782);
    freq.put("ES ", 232);
    freq.put("np", 30);
    freq.put("nq", 646);
    freq.put("nr", 480);
    freq.put("ns", 12032);
    freq.put("nt", 22931);
    freq.put("nu", 1786);
    freq.put("nv", 1361);
    freq.put("Pok", 26);
    freq.put(" ni", 339);
    freq.put("umu", 29);
    freq.put("OU ", 49);
    freq.put("E", 4102);
    freq.put(" èm", 123);
    freq.put(" no", 4019);
    freq.put("éal", 157);
    freq.put(" na", 503);
    freq.put("urs", 2683);
    freq.put(" ne", 2248);
    freq.put("squ", 660);
    freq.put("nn ", 93);
    freq.put("mun", 195);
    freq.put("vén", 29);
    freq.put("elé", 40);
    freq.put("tec", 124);
    freq.put("Rec", 59);
    freq.put("oît", 34);
    freq.put("rds", 166);
    freq.put("éai", 32);
    freq.put("tid", 46);
    freq.put(" nu", 758);
    freq.put("FC ", 28);
    freq.put("Tri", 82);
    freq.put("amb", 242);
    freq.put("for", 853);
    freq.put("n ", 42302);
    freq.put("Win", 47);
    freq.put("fos", 67);
    freq.put("mme", 3359);
    freq.put("plu", 2725);
    freq.put("rk ", 108);
    freq.put("uqu", 66);
    freq.put("ti ", 366);
    freq.put("éag", 24);
    freq.put("té ", 2376);
    freq.put("roi", 1243);
    freq.put("roj", 134);
    freq.put("éde", 79);
    freq.put("rol", 242);
    freq.put("rom", 363);
    freq.put("ron", 724);
    freq.put("roo", 56);
    freq.put("lls", 38);
    freq.put(" Êt", 26);
    freq.put("rob", 275);
    freq.put("roc", 592);
    freq.put("rod", 196);
    freq.put("Méd", 27);
    freq.put("rof", 380);
    freq.put("rog", 203);
    freq.put("osi", 190);
    freq.put("fè", 112);
    freq.put("lli", 459);
    freq.put("llo", 874);
    freq.put("ob ", 42);
    freq.put("oso", 49);
    freq.put("lll", 32);
    freq.put("rop", 1813);
    freq.put("roq", 40);
    freq.put("ror", 27);
    freq.put("ros", 684);
    freq.put("rot", 162);
    freq.put("fê", 96);
    freq.put("Grè", 45);
    freq.put("row", 32);
    freq.put("vet", 76);
    freq.put("one", 735);
    freq.put("ver", 1905);
    freq.put("ves", 323);
    freq.put("gea", 84);
    freq.put("Dam", 44);
    freq.put("Dan", 320);
    freq.put("di ", 832);
    freq.put("Dai", 37);
    freq.put("AS ", 83);
    freq.put("Dav", 69);
    freq.put("Les", 1168);
    freq.put("ép", 1364);
    freq.put("vec", 2465);
    freq.put("Dar", 37);
    freq.put("vea", 625);
    freq.put("ven", 1658);
    freq.put("uma", 120);
    freq.put("jva", 43);
    freq.put("Où ", 23);
    freq.put("vei", 255);
    freq.put("ert", 1047);
    freq.put("ey ", 319);
    freq.put("ro ", 477);
    freq.put("Sky", 25);
    freq.put("umb", 85);
    freq.put("Mé", 98);
    freq.put("erv", 599);
    freq.put("Mê", 118);
    freq.put("fol", 602);
    freq.put("usu", 35);
    freq.put("Cit", 43);
    freq.put("erp", 59);
    freq.put("hPa", 25);
    freq.put("ll ", 311);
    freq.put("arb", 100);
    freq.put("umo", 68);
    freq.put("dim", 102);
    freq.put("din", 270);
    freq.put("foo", 87);
    freq.put("gue", 988);
    freq.put("did", 115);
    freq.put("die", 369);
    freq.put("gui", 120);
    freq.put("ers", 2147);
    freq.put("dia", 353);
    freq.put("gum", 33);
    freq.put("dic", 221);
    freq.put("p", 63546);
    freq.put("ge ", 2301);
    freq.put("dix", 35);
    freq.put("uan", 1581);
    freq.put("Tab", 25);
    freq.put("dit", 1107);
    freq.put("urm", 35);
    freq.put("div", 86);
    freq.put("He", 296);
    freq.put("dip", 30);
    freq.put(" de", 25674);
    freq.put("dir", 1109);
    freq.put("rz", 24);
    freq.put("Rey", 27);
    freq.put("uva", 250);
    freq.put("M ", 460);
    freq.put("hta", 37);
    freq.put(" Yo", 164);
    freq.put(" Ya", 108);
    freq.put("Rep", 55);
    freq.put("Rev", 37);
    freq.put(" Ye", 78);
    freq.put("Ret", 80);
    freq.put("osé", 108);
    freq.put("OK ", 46);
    freq.put("llé", 264);
    freq.put("Gre", 61);
    freq.put("Ren", 113);
    freq.put("dev", 795);
    freq.put("arm", 213);
    freq.put("Gra", 140);
    freq.put("ale", 1293);
    freq.put("Gro", 68);
    freq.put("Rea", 50);
    freq.put("IN ", 88);
    freq.put("Reg", 52);
    freq.put("Gri", 23);
    freq.put("ade", 440);
    freq.put("erd", 705);
    freq.put("gét", 26);
    freq.put("gés", 36);
    freq.put("gér", 86);
    freq.put("Tum", 29);
    freq.put("ere", 487);
    freq.put("rum", 104);
    freq.put("ek ", 158);
    freq.put("Qua", 278);
    freq.put("gée", 72);
    freq.put("Que", 408);
    freq.put("aux", 1441);
    freq.put("Qui", 235);
    freq.put("gén", 257);
    freq.put("DS ", 34);
    freq.put("era", 1768);
    freq.put("Me", 958);
    freq.put("Md", 317);
    freq.put("lé ", 641);
    freq.put("Ma", 2449);
    freq.put("erb", 107);
    freq.put("Mc", 39);
    freq.put("ht ", 106);
    freq.put("Mm", 23);
    freq.put("Mo", 1457);
    freq.put("deo", 106);
    freq.put("Mi", 500);
    freq.put("clo", 92);
    freq.put("Bou", 165);
    freq.put("Mu", 115);
    freq.put("Mdr", 293);
    freq.put("ze ", 62);
    freq.put("O", 3709);
    freq.put("Mr", 29);
    freq.put("rue", 117);
    freq.put("My", 38);
    freq.put(" du", 3964);
    freq.put("or ", 273);
    freq.put("box", 82);
    freq.put("boy", 37);
    freq.put("xac", 74);
    freq.put("dié", 31);
    freq.put("Boi", 23);
    freq.put("ded", 50);
    freq.put("gué", 89);
    freq.put("bos", 114);
    freq.put("bot", 47);
    freq.put("bou", 946);
    freq.put("ty ", 158);
    freq.put("êt ", 131);
    freq.put("HA ", 31);
    freq.put("ata", 250);
    freq.put("bol", 58);
    freq.put("rko", 148);
    freq.put("oeu", 299);
    freq.put("gé ", 258);
    freq.put("AI ", 34);
    freq.put("PC ", 62);
    freq.put("deg", 60);
    freq.put("voy", 327);
    freq.put("Sér", 35);
    freq.put("ard", 1672);
    freq.put("ipa", 80);
    freq.put("Où", 23);
    freq.put("ipe", 239);
    freq.put("jar", 33);
    freq.put("iph", 42);
    freq.put("ipi", 28);
    freq.put("ipo", 54);
    freq.put("ipl", 64);
    freq.put("élé", 423);
    freq.put("spè", 191);
    freq.put("ips", 39);
    freq.put("ipp", 89);
    freq.put("Lig", 52);
    freq.put("Ség", 64);
    freq.put("lés", 77);
    freq.put("ipt", 89);
    freq.put(" où", 338);
    freq.put("Là ", 44);
    freq.put("Sén", 41);
    freq.put("Lia", 40);
    freq.put("are", 765);
    freq.put("sh ", 169);
    freq.put("ayo", 43);
    freq.put(" Ka", 221);
    freq.put("Min", 89);
    freq.put("în", 98);
    freq.put(" Ke", 72);
    freq.put("aye", 293);
    freq.put(" Kh", 29);
    freq.put(" Ki", 114);
    freq.put("aya", 67);
    freq.put(" Ko", 51);
    freq.put(" Kl", 24);
    freq.put("opé", 141);
    freq.put(" Kr", 29);
    freq.put("tém", 40);
    freq.put("téo", 32);
    freq.put("zza", 35);
    freq.put("tée", 226);
    freq.put("ul ", 475);
    freq.put("tég", 96);
    freq.put("ît", 198);
    freq.put("uas", 35);
    freq.put("ays", 137);
    freq.put("Mon", 549);
    freq.put("Evi", 27);
    freq.put("ip ", 200);
    freq.put("uar", 99);
    freq.put("Ben", 190);
    freq.put("ngr", 50);
    freq.put("Bel", 102);
    freq.put("F", 3323);
    freq.put("osh", 50);
    freq.put("Eva", 23);
    freq.put("ooo", 505);
    freq.put("Bea", 84);
    freq.put("ooh", 32);
    freq.put("ook", 463);
    freq.put("uat", 120);
    freq.put("ma ", 1528);
    freq.put("ose", 777);
    freq.put("fb ", 37);
    freq.put("oop", 69);
    freq.put("oos", 45);
    freq.put("oor", 31);
    freq.put("Ber", 80);
    freq.put("Bes", 37);
    freq.put("ugm", 47);
    freq.put("arg", 336);
    freq.put("Bet", 25);
    freq.put("aun", 35);
    freq.put("sû", 136);
    freq.put("ibi", 59);
    freq.put(" K ", 30);
    freq.put("ibl", 497);
    freq.put("Rad", 55);
    freq.put("Oul", 25);
    freq.put("cas", 536);
    freq.put("iba", 57);
    freq.put("Oua", 392);
    freq.put("déç", 39);
    freq.put("flu", 46);
    freq.put("ibe", 74);
    freq.put("Oue", 37);
    freq.put("vêt", 25);
    freq.put("fli", 95);
    freq.put("iby", 71);
    freq.put("sé", 1663);
    freq.put("sè", 36);
    freq.put("ulo", 232);
    freq.put("flo", 38);
    freq.put("cal", 379);
    freq.put("fla", 70);
    freq.put("cab", 59);
    freq.put("ibr", 118);
    freq.put("Mod", 38);
    freq.put("fle", 191);
    freq.put("ibu", 98);
    freq.put("Mic", 107);
    freq.put("ms ", 293);
    freq.put(" on", 3517);
    freq.put("ges", 526);
    freq.put(" ol", 32);
    freq.put(" om", 46);
    freq.put("fiè", 39);
    freq.put(" ok", 190);
    freq.put(" oh", 140);
    freq.put(" oi", 37);
    freq.put(" of", 308);
    freq.put(" od", 24);
    freq.put(" oe", 67);
    freq.put(" ob", 239);
    freq.put(" oc", 241);
    freq.put("uls", 47);
    freq.put("èqu", 24);
    freq.put("spi", 137);
    freq.put("uo ", 23);
    freq.put("Loo", 27);
    freq.put("spo", 420);
    freq.put("spa", 247);
    freq.put("Mis", 63);
    freq.put(" ou", 3408);
    freq.put(" or", 503);
    freq.put(" os", 81);
    freq.put(" op", 158);
    freq.put("ny ", 119);
    freq.put(" à ", 6932);
    freq.put("ST ", 59);
    freq.put("geu", 65);
    freq.put("ND ", 28);
    freq.put("get", 54);
    freq.put("dé ", 262);
    freq.put("rvi", 240);
    freq.put("ado", 320);
    freq.put("gh ", 27);
    freq.put("uag", 50);
    freq.put("gez", 24);
    freq.put("mel", 93);
    freq.put("Tél", 43);
    freq.put("s ", 89838);
    freq.put("amm", 199);
    freq.put("oss", 702);
    freq.put("maq", 35);
    freq.put("mas", 150);
    freq.put("sne", 34);
    freq.put("mau", 166);
    freq.put("mat", 1028);
    freq.put("max", 52);
    freq.put("ky ", 49);
    freq.put(" o ", 309);
    freq.put("sni", 30);
    freq.put("mac", 115);
    freq.put("enc", 1938);
    freq.put("uga", 62);
    freq.put("mad", 91);
    freq.put("mag", 697);
    freq.put("mai", 5473);
    freq.put("mak", 24);
    freq.put("maj", 50);
    freq.put("mam", 104);
    freq.put("obt", 34);
    freq.put("ene", 297);
    freq.put("dél", 139);
    freq.put("ibé", 65);
    freq.put("dén", 47);
    freq.put("déo", 274);
    freq.put("déj", 517);
    freq.put("déd", 58);
    freq.put("dée", 246);
    freq.put("déf", 201);
    freq.put("dég", 124);
    freq.put("sw", 29);
    freq.put("sv", 44);
    freq.put("déb", 348);
    freq.put("déc", 601);
    freq.put("q", 21814);
    freq.put("si", 7846);
    freq.put("sh", 653);
    freq.put("so", 8630);
    freq.put("sn", 119);
    freq.put("sm", 388);
    freq.put("sl", 164);
    freq.put("dét", 202);
    freq.put("sb", 66);
    freq.put("dév", 124);
    freq.put("dép", 317);
    freq.put("iPh", 171);
    freq.put("dér", 108);
    freq.put("dés", 246);
    freq.put("Ru", 103);
    freq.put("lse", 23);
    freq.put("gee", 47);
    freq.put("lsa", 47);
    freq.put("Chi", 127);
    freq.put("eç", 121);
    freq.put("ttp", 97);
    freq.put("no ", 186);
    freq.put("ppa", 247);
    freq.put("Jap", 42);
    freq.put("Cho", 53);
    freq.put("aît", 158);
    freq.put("Re", 691);
    freq.put("Chr", 115);
    freq.put("Jam", 63);
    freq.put("tto", 114);
    freq.put("Ra", 301);
    freq.put("Jai", 25);
    freq.put("tta", 199);
    freq.put("Ro", 436);
    freq.put("Rh", 38);
    freq.put("Ri", 208);
    freq.put("tte", 3219);
    freq.put("sod", 161);
    freq.put(" aa", 39);
    freq.put(" ab", 374);
    freq.put(" ac", 1172);
    freq.put(" ad", 480);
    freq.put("gte", 137);
    freq.put(" af", 292);
    freq.put(" ag", 248);
    freq.put(" ah", 505);
    freq.put(" ai", 5561);
    freq.put(" aj", 106);
    freq.put(" al", 1975);
    freq.put(" am", 925);
    freq.put(" an", 1861);
    freq.put(" ao", 100);
    freq.put(" ap", 1714);
    freq.put(" ar", 1508);
    freq.put("gts", 47);
    freq.put(" at", 759);
    freq.put(" au", 6220);
    freq.put(" av", 4844);
    freq.put(" ay", 49);
    freq.put("gel", 41);
    freq.put("coi", 122);
    freq.put("enu", 344);
    freq.put("nol", 116);
    freq.put("nom", 560);
    freq.put("àà", 43);
    freq.put("noo", 26);
    freq.put("rlé", 63);
    freq.put("env", 851);
    freq.put("Ç", 250);
    freq.put("ppo", 280);
    freq.put("uge", 256);
    freq.put("Kat", 24);
    freq.put("aro", 241);
    freq.put("nob", 35);
    freq.put("noc", 34);
    freq.put("nec", 99);
    freq.put("tjs", 28);
    freq.put("tjr", 40);
    freq.put("R ", 592);
    freq.put("nsf", 54);
    freq.put("▸", 76);
    freq.put("not", 380);
    freq.put("sht", 36);
    freq.put("nov", 89);
    freq.put("ppl", 275);
    freq.put("zé", 34);
    freq.put("oye", 380);
    freq.put("nor", 337);
    freq.put("nos", 243);
    freq.put(" a ", 5942);
    freq.put("eg ", 23);
    freq.put("TA ", 30);
    freq.put("ppr", 332);
    freq.put(" bâ", 39);
    freq.put("via", 767);
    freq.put("pèr", 293);
    freq.put("ppp", 30);
    freq.put("xie", 23);
    freq.put(" wo", 36);
    freq.put("sou", 1229);
    freq.put("uba", 49);
    freq.put("ony", 87);
    freq.put("mem", 262);
    freq.put("fen", 125);
    freq.put("em", 8678);
    freq.put("el", 8057);
    freq.put("eo", 304);
    freq.put("en", 35447);
    freq.put("ei", 2408);
    freq.put("eh", 203);
    freq.put("ek", 252);
    freq.put("ej", 173);
    freq.put("ee", 1898);
    freq.put("ed", 995);
    freq.put("eg", 897);
    freq.put("ef", 759);
    freq.put("ea", 3033);
    freq.put("rl ", 64);
    freq.put("ec", 5615);
    freq.put("eb", 1014);
    freq.put("Du ", 92);
    freq.put("tté", 61);
    freq.put("fs", 232);
    freq.put("ey", 492);
    freq.put("ex", 1630);
    freq.put("ez", 3040);
    freq.put("eu", 13176);
    freq.put("et", 14326);
    freq.put("ew", 345);
    freq.put("ev", 2127);
    freq.put("eq", 114);
    freq.put("Ré", 217);
    freq.put("es", 43085);
    freq.put("er", 24468);
    freq.put("eM", 26);
    freq.put("Ken", 24);
    freq.put("ejo", 59);
    freq.put("nib", 78);
    freq.put("Jou", 151);
    freq.put("sha", 40);
    freq.put(" aé", 31);
    freq.put("eja", 72);
    freq.put("blr", 64);
    freq.put("Job", 38);
    freq.put("bli", 712);
    freq.put("dif", 238);
    freq.put("os ", 1564);
    freq.put("Son", 61);
    freq.put("Joh", 33);
    freq.put("èce", 107);
    freq.put("aib", 32);
    freq.put("ula", 400);
    freq.put("Jol", 30);
    freq.put("Jon", 32);
    freq.put("qd", 56);
    freq.put("rlo", 51);
    freq.put("lag", 267);
    freq.put("rli", 44);
    freq.put("RT ", 1234);
    freq.put("G", 2124);
    freq.put("ory", 98);
    freq.put("rle", 760);
    freq.put("rld", 24);
    freq.put("ort", 2390);
    freq.put("oru", 51);
    freq.put("rla", 141);
    freq.put("e ", 136011);
    freq.put("orp", 87);
    freq.put("orn", 76);
    freq.put("oro", 45);
    freq.put("orl", 44);
    freq.put("git", 77);
    freq.put("ork", 64);
    freq.put("UI ", 39);
    freq.put("One", 68);
    freq.put("orf", 40);
    freq.put("org", 185);
    freq.put("ord", 768);
    freq.put("ore", 1222);
    freq.put("orc", 220);
    freq.put("ora", 365);
    freq.put("cem", 131);
    freq.put("NS ", 60);
    freq.put("wai", 31);
    freq.put("Apr", 127);
    freq.put("App", 214);
    freq.put("xpl", 247);
    freq.put("fb", 45);
    freq.put("ael", 36);
    freq.put("az ", 48);
    freq.put("lie", 1236);
    freq.put("lla", 570);
    freq.put("ulg", 23);
    freq.put("ud ", 301);
    freq.put("sho", 166);
    freq.put(" ce", 4378);
    freq.put("lay", 87);
    freq.put("onj", 247);
    freq.put("onh", 60);
    freq.put("xi", 388);
    freq.put("hu ", 45);
    freq.put("Euh", 55);
    freq.put("onb", 24);
    freq.put("xc", 250);
    freq.put("xa", 163);
    freq.put("pré", 1045);
    freq.put("rgu", 36);
    freq.put("ond", 1596);
    freq.put("xe", 340);
    freq.put("onz", 35);
    freq.put("xx", 61);
    freq.put("xy", 70);
    freq.put("xpe", 45);
    freq.put("ème", 476);
    freq.put("ons", 2551);
    freq.put("xp", 518);
    freq.put("onv", 141);
    freq.put("xt", 253);
    freq.put("Eur", 156);
    freq.put("iam", 95);
    freq.put("ial", 637);
    freq.put("égu", 77);
    freq.put("ian", 403);
    freq.put("iai", 65);
    freq.put("égr", 78);
    freq.put("€ ", 225);
    freq.put("Dé", 367);
    freq.put("iag", 66);
    freq.put("dib", 25);
    freq.put("xD", 557);
    freq.put("iab", 59);
    freq.put("vem", 190);
    freq.put("ége", 47);
    freq.put("usi", 539);
    freq.put("anç", 417);
    freq.put("éga", 181);
    freq.put("iau", 130);
    freq.put("grâ", 56);
    freq.put("Dou", 55);
    freq.put("iaq", 31);
    freq.put("fum", 79);
    freq.put("ias", 82);
    freq.put("iar", 72);
    freq.put("Côt", 26);
    freq.put(" Zo", 37);
    freq.put("way", 26);
    freq.put("èse", 36);
    freq.put(" Ze", 78);
    freq.put("hum", 209);
    freq.put("x ", 6495);
    freq.put(" Za", 91);
    freq.put("hui", 490);
    freq.put("za ", 44);
    freq.put("uté", 252);
    freq.put("hut", 55);
    freq.put("ush", 50);
    freq.put("hur", 25);
    freq.put("SE ", 65);
    freq.put(" ya", 170);
    freq.put("mt ", 30);
    freq.put("VD ", 32);
    freq.put("tig", 107);
    freq.put("ors", 1188);
    freq.put("gèr", 95);
    freq.put(" Là", 44);
    freq.put("Lad", 42);
    freq.put("ia ", 381);
    freq.put("r", 140947);
    freq.put("rce", 922);
    freq.put("grè", 42);
    freq.put("egr", 102);
    freq.put("OP ", 39);
    freq.put(" gé", 294);
    freq.put("uk ", 25);
    freq.put("pre", 2221);
    freq.put("ane", 283);
    freq.put("sai", 1768);
    freq.put("xé", 62);
    freq.put("sao", 42);
    freq.put("san", 1093);
    freq.put("sam", 120);
    freq.put("sal", 329);
    freq.put("sac", 201);
    freq.put("sab", 105);
    freq.put("pro", 2034);
    freq.put("Ang", 91);
    freq.put("sag", 347);
    freq.put("ani", 478);
    freq.put("sad", 33);
    freq.put("ant", 4722);
    freq.put("anu", 49);
    freq.put("say", 190);
    freq.put("pp ", 49);
    freq.put("ry ", 471);
    freq.put("ans", 4808);
    freq.put("sas", 34);
    freq.put("sar", 82);
    freq.put("sav", 386);
    freq.put("sau", 292);
    freq.put("sat", 296);
    freq.put("Do", 428);
    freq.put("Phi", 27);
    freq.put("rmi", 446);
    freq.put("Dj", 32);
    freq.put("odè", 41);
    freq.put("Di", 443);
    freq.put("Eco", 70);
    freq.put("De", 1067);
    freq.put("ède", 34);
    freq.put("zon", 93);
    freq.put("Da", 586);
    freq.put("ax ", 55);
    freq.put("²", 23);
    freq.put("zou", 27);
    freq.put("ego", 41);
    freq.put("mot", 330);
    freq.put("Du", 169);
    freq.put("Dr", 119);
    freq.put("ts ", 2615);
    freq.put("égé", 40);
    freq.put("lup", 26);
    freq.put("all", 1555);
    freq.put("adr", 141);
    freq.put("Off", 60);
    freq.put("pr ", 145);
    freq.put("éun", 61);
    freq.put("Toi", 79);
    freq.put("ust", 1023);
    freq.put("sa ", 1094);
    freq.put("bio", 73);
    freq.put("rèr", 77);
    freq.put(" ye", 210);
    freq.put("têt", 231);
    freq.put("Sha", 37);
    freq.put("tèr", 57);
    freq.put("éus", 92);
    freq.put(" Le", 3081);
    freq.put("vu ", 599);
    freq.put(" La", 1672);
    freq.put("uss", 1655);
    freq.put(" Lo", 530);
    freq.put(" Li", 506);
    freq.put(" Lu", 161);
    freq.put("MG ", 51);
    freq.put("axe", 64);
    freq.put("Nig", 23);
    freq.put("Ça ", 244);
    freq.put(" Ly", 97);
    freq.put("Web", 65);
    freq.put("SI ", 34);
    freq.put("set", 51);
    freq.put("fes", 210);
    freq.put("Wee", 27);
    freq.put(" sû", 136);
    freq.put("îne", 86);
    freq.put("oog", 233);
    freq.put("bin", 82);
    freq.put("Wes", 27);
    freq.put("cœu", 38);
    freq.put("tkt", 47);
    freq.put(" p ", 263);
    freq.put("nle", 46);
    freq.put("nli", 31);
    freq.put("xis", 126);
    freq.put("rmé", 119);
    freq.put("dy ", 144);
    freq.put("ss ", 351);
    freq.put("We", 163);
    freq.put("asé", 25);
    freq.put("élè", 64);
    freq.put("Wa", 174);
    freq.put("Wo", 111);
    freq.put("ce ", 6366);
    freq.put("lub", 84);
    freq.put("Wi", 151);
    freq.put("Wh", 54);
    freq.put("tne", 48);
    freq.put("urv", 81);
    freq.put("alh", 64);
    freq.put("tic", 478);
    freq.put("uvr", 423);
    freq.put(" ps", 132);
    freq.put(" pr", 5163);
    freq.put("ààà", 24);
    freq.put(" pu", 1155);
    freq.put(" pt", 116);
    freq.put("ssu", 369);
    freq.put("H", 1944);
    freq.put("sss", 136);
    freq.put("ffr", 258);
    freq.put(" pc", 78);
    freq.put("tué", 108);
    freq.put(" pa", 13843);
    freq.put("AC ", 49);
    freq.put("ssi", 2516);
    freq.put(" pf", 42);
    freq.put(" pe", 4879);
    freq.put(" pd", 32);
    freq.put(" pk", 40);
    freq.put(" pi", 863);
    freq.put(" ph", 785);
    freq.put("jà", 503);
    freq.put("gen", 1432);
    freq.put("gem", 150);
    freq.put(" pl", 4166);
    freq.put("agé", 52);
    freq.put("W ", 89);
    freq.put("cid", 210);
    freq.put(" bé", 122);
    freq.put("Ét", 52);
    freq.put("Tim", 58);
    freq.put(" bê", 52);
    freq.put("sum", 94);
    freq.put("ffl", 40);
    freq.put("aza", 41);
    freq.put("Éc", 31);
    freq.put("èch", 44);
    freq.put("ult", 377);
    freq.put("uth", 26);
    freq.put("mmm", 61);
    freq.put("uti", 780);
    freq.put("llè", 96);
    freq.put("éfl", 50);
    freq.put("cio", 25);
    freq.put("uvo", 127);
    freq.put("cin", 244);
    freq.put("rma", 530);
    freq.put("alg", 85);
    freq.put("NE ", 165);
    freq.put("rme", 644);
    freq.put("tu ", 3514);
    freq.put("lép", 114);
    freq.put("cil", 210);
    freq.put("j ", 5025);
    freq.put("ffe", 408);
    freq.put("trè", 525);
    freq.put("cis", 196);
    freq.put("éçu", 36);
    freq.put("émi", 173);
    freq.put("ël ", 35);
    freq.put(" b ", 23);
    freq.put(" ▸ ", 72);
    freq.put("cir", 47);
    freq.put("mol", 33);
    freq.put("ain", 3521);
    freq.put("uve", 2404);
    freq.put("tup", 28);
    freq.put("ald", 43);
    freq.put("cip", 163);
    freq.put("yth", 61);
    freq.put("jte", 48);
    freq.put("Blu", 29);
    freq.put("tur", 722);
    freq.put("êve", 152);
    freq.put("civ", 23);
    freq.put("oom", 47);
    freq.put("rô", 187);
    freq.put("qd ", 56);
    freq.put("tus", 34);
    freq.put("utt", 49);
    freq.put("Shi", 28);
    freq.put("uns", 31);
    freq.put("jt", 74);
    freq.put("ju", 1132);
    freq.put("jv", 85);
    freq.put("cit", 281);
    freq.put("jp", 45);
    freq.put("jr", 76);
    freq.put("js", 152);
    freq.put("jl", 51);
    freq.put("jm", 74);
    freq.put("rm ", 27);
    freq.put("jo", 3443);
    freq.put("ssé", 440);
    freq.put("ji", 44);
    freq.put("tun", 54);
    freq.put("jd", 39);
    freq.put("je", 8539);
    freq.put(" pé", 212);
    freq.put(" pè", 129);
    freq.put("tud", 225);
    freq.put("ja", 933);
    freq.put("ool", 433);
    freq.put("jc", 28);
    freq.put(" be", 1515);
    freq.put("uf", 772);
    freq.put(" ba", 1705);
    freq.put("unt", 63);
    freq.put(" bc", 54);
    freq.put(" bb", 26);
    freq.put(" bl", 756);
    freq.put(" bo", 2974);
    freq.put("écl", 141);
    freq.put(" bi", 2627);
    freq.put("P ", 558);
    freq.put("diq", 60);
    freq.put(" bu", 405);
    freq.put("s", 170432);
    freq.put("rki", 35);
    freq.put(" br", 519);
    freq.put("tul", 31);
    freq.put("oct", 138);
    freq.put(" by", 49);
    freq.put("éca", 76);
    freq.put("tum", 62);
    freq.put("ète", 306);
    freq.put("vre", 659);
    freq.put("été", 540);
    freq.put("yn ", 45);
    freq.put("pot", 275);
    freq.put("pou", 6067);
    freq.put("por", 1158);
    freq.put("ivé", 202);
    freq.put("pop", 80);
    freq.put("poq", 34);
    freq.put("pon", 661);
    freq.put("pol", 296);
    freq.put("pom", 91);
    freq.put("pok", 34);
    freq.put("poi", 364);
    freq.put("pod", 36);
    freq.put("éfi", 126);
    freq.put("avo", 1112);
    freq.put("poc", 57);
    freq.put("fic", 543);
    freq.put("Bur", 29);
    freq.put("kes", 34);
    freq.put("dis", 1164);
    freq.put(" Mé", 97);
    freq.put(" Mê", 118);
    freq.put("tue", 348);
    freq.put("fia", 82);
    freq.put("nit", 239);
    freq.put("bil", 393);
    freq.put("tug", 34);
    freq.put("nne", 3114);
    freq.put("cqu", 56);
    freq.put("Biz", 25);
    freq.put("râ", 84);
    freq.put("É", 147);
    freq.put("vue", 138);
    freq.put("nna", 920);
    freq.put("écr", 362);
    freq.put("po ", 83);
    freq.put("aid", 184);
    freq.put("mpe", 147);
    freq.put("rgi", 83);
    freq.put("IL ", 26);
    freq.put("au ", 3597);
    freq.put("fin", 1236);
    freq.put("cq ", 36);
    freq.put("Kad", 63);
    freq.put("ank", 69);
    freq.put("épé", 36);
    freq.put("ccé", 25);
    freq.put("fil", 902);
    freq.put("eig", 100);
    freq.put("Sho", 48);
    freq.put("eim", 24);
    freq.put("eil", 1279);
    freq.put("ein", 904);
    freq.put("ive", 1824);
    freq.put("iva", 211);
    freq.put("éth", 36);
    freq.put("éti", 184);
    freq.put("ivo", 56);
    freq.put("ivi", 231);
    freq.put("oi ", 5492);
    freq.put("Et ", 976);
    freq.put("bêt", 66);
    freq.put("ivr", 362);
    freq.put("Bar", 94);
    freq.put("mod", 256);
    freq.put("étu", 92);
    freq.put("étr", 197);
    freq.put("Bas", 49);
    freq.put(" Md", 317);
    freq.put(" Me", 946);
    freq.put("par", 5027);
    freq.put("pas", 8489);
    freq.put("pat", 248);
    freq.put(" Ma", 2424);
    freq.put(" Mc", 39);
    freq.put("chi", 747);
    freq.put("pay", 239);
    freq.put(" Mo", 1432);
    freq.put(" Mi", 487);
    freq.put(" Mu", 113);
    freq.put("pab", 51);
    freq.put("pac", 130);
    freq.put("pad", 60);
    freq.put(" Mr", 29);
    freq.put("pag", 427);
    freq.put("IR ", 27);
    freq.put("I ", 500);
    freq.put("pal", 83);
    freq.put(" My", 37);
    freq.put("pan", 164);
    freq.put("fs ", 217);
    freq.put("cel", 519);
    freq.put("iv ", 29);
    freq.put("lér", 44);
    freq.put("oii", 24);
    freq.put("nac", 99);
    freq.put("I", 2365);
    freq.put("oif", 63);
    freq.put("oie", 245);
    freq.put("oid", 161);
    freq.put("oic", 78);
    freq.put("Men", 39);
    freq.put("oot", 173);
    freq.put("yd", 33);
    freq.put("bla", 362);
    freq.put("Eta", 66);
    freq.put("yg", 32);
    freq.put("ux ", 4876);
    freq.put("oix", 206);
    freq.put("oiv", 50);
    freq.put("rêm", 25);
    freq.put("oit", 1115);
    freq.put("ois", 2684);
    freq.put("Ji", 26);
    freq.put("ycé", 108);
    freq.put("nag", 194);
    freq.put("oka", 28);
    freq.put(" M ", 155);
    freq.put("yea", 36);
    freq.put("ccu", 152);
    freq.put("Ip", 27);
    freq.put("Is", 69);
    freq.put("Ir", 38);
    freq.put("DI ", 23);
    freq.put("It", 64);
    freq.put("Iv", 25);
    freq.put("pa ", 268);
    freq.put("éfe", 80);
    freq.put("cco", 307);
    freq.put("ujo", 1036);
    freq.put("Im", 97);
    freq.put("Il", 1065);
    freq.put("toy", 70);
    freq.put("In", 507);
    freq.put("cce", 127);
    freq.put("ces", 1132);
    freq.put("Ic", 34);
    freq.put("éfo", 40);
    freq.put("cca", 63);
    freq.put("Id", 34);
    freq.put("ary", 32);
    freq.put("cer", 699);
    freq.put(" qq", 61);
    freq.put("nai", 811);
    freq.put("geo", 40);
    freq.put(" qu", 15293);
    freq.put("Loc", 25);
    freq.put("am ", 296);
    freq.put("Bey", 37);
    freq.put("xpé", 47);
    freq.put("rps", 59);
    freq.put("rép", 519);
    freq.put("tiq", 655);
    freq.put("oki", 48);
    freq.put("ôté", 115);
    freq.put("rpr", 89);
    freq.put(" qd", 56);
    freq.put("tir", 489);
    freq.put("mpo", 401);
    freq.put("uid", 74);
    freq.put("ucs", 110);
    freq.put("mo ", 104);
    freq.put("Bal", 44);
    freq.put("RE ", 125);
    freq.put(" cé", 77);
    freq.put("cm", 44);
    freq.put("rèv", 47);
    freq.put(" câ", 35);
    freq.put("Mac", 85);
    freq.put("mys", 24);
    freq.put("yt", 93);
    freq.put("vè", 45);
    freq.put(" ge", 1135);
    freq.put("oko", 37);
    freq.put("vê", 28);
    freq.put(" cô", 120);
    freq.put("ami", 754);
    freq.put("moy", 97);
    freq.put("orr", 224);
    freq.put("Mag", 58);
    freq.put("amo", 298);
    freq.put("amn", 35);
    freq.put("êt", 2148);
    freq.put("mor", 469);
    freq.put("êv", 176);
    freq.put(" ga", 1040);
    freq.put("ame", 569);
    freq.put("rsa", 199);
    freq.put("mou", 623);
    freq.put("Hey", 60);
    freq.put(" q ", 28);
    freq.put("êm", 1404);
    freq.put("ên", 26);
    freq.put("psy", 41);
    freq.put("uif", 25);
    freq.put("Lol", 95);
    freq.put("mom", 317);
    freq.put("gro", 587);
    freq.put("moc", 138);
    freq.put("mob", 128);
    freq.put("ams", 64);
    freq.put("Ze", 79);
    freq.put("amu", 57);
    freq.put("tif", 328);
    freq.put("êc", 79);
    freq.put("oï", 27);
    freq.put("oî", 35);
    freq.put(" âg", 59);
    freq.put("ttr", 506);
    freq.put("oë", 31);
    freq.put("oé", 41);
    freq.put("acé", 60);
    freq.put("Pie", 64);
    freq.put("tia", 91);
    freq.put("uei", 62);
    freq.put("uii", 50);
    freq.put("oû", 206);
    freq.put("t", 139847);
    freq.put("où", 338);
    freq.put("cam", 224);
    freq.put("Lov", 59);
    freq.put("Pir", 27);
    freq.put("gri", 112);
    freq.put("ètr", 26);
    freq.put("èle", 95);
    freq.put("édu", 114);
    freq.put("biè", 25);
    freq.put("iét", 93);
    freq.put("ôts", 23);
    freq.put("Lou", 107);
    freq.put("blè", 137);
    freq.put("cs", 383);
    freq.put("alt", 64);
    freq.put("évé", 48);
    freq.put("éja", 44);
    freq.put("Tan", 38);
    freq.put("ngl", 269);
    freq.put("New", 125);
    freq.put("Net", 31);
    freq.put("ôte", 65);
    freq.put("Med", 39);
    freq.put(" ch", 4479);
    freq.put(" ci", 380);
    freq.put("xce", 122);
    freq.put(" co", 10074);
    freq.put(" cl", 941);
    freq.put(" cm", 37);
    freq.put("Mem", 23);
    freq.put(" cc", 332);
    freq.put(" ca", 2829);
    freq.put("Mei", 23);
    freq.put("fi ", 118);
    freq.put("Hol", 70);
    freq.put("o ", 4120);
    freq.put("Met", 42);
    freq.put("ddi", 55);
    freq.put(" cy", 31);
    freq.put("uci", 128);
    freq.put("Mes", 105);
    freq.put("Mer", 514);
    freq.put(" cr", 1600);
    freq.put("uch", 694);
    freq.put(" cu", 365);
    freq.put("amé", 130);
    freq.put("amè", 32);
    freq.put("Rap", 40);
    freq.put("ye ", 202);
    freq.put("mpi", 150);
    freq.put("Ne ", 81);
    freq.put("acc", 618);
    freq.put("Dro", 37);
    freq.put("Dra", 24);
    freq.put("ci ", 1182);
    freq.put("ôt ", 356);
    freq.put("ez ", 2952);
    freq.put("tv ", 30);
    freq.put("mél", 49);
    freq.put("oo", 2402);
    freq.put("on", 32364);
    freq.put("om", 7237);
    freq.put("ol", 4918);
    freq.put("ok", 836);
    freq.put("oj", 158);
    freq.put("oi", 15670);
    freq.put("oh", 293);
    freq.put("og", 1277);
    freq.put("of", 846);
    freq.put("oe", 417);
    freq.put("od", 1193);
    freq.put("oc", 2164);
    freq.put("ob", 1079);
    freq.put("oa", 127);
    freq.put("acl", 40);
    freq.put("acs", 29);
    freq.put("ngo", 82);
    freq.put("acq", 42);
    freq.put("Si ", 562);
    freq.put("oz", 139);
    freq.put("oy", 994);
    freq.put("ox", 199);
    freq.put("ow", 897);
    freq.put("ov", 417);
    freq.put("ou", 33732);
    freq.put("ot", 3528);
    freq.put("os", 3992);
    freq.put("or", 8936);
    freq.put("oq", 307);
    freq.put("op", 3085);
    freq.put("LE ", 185);
    freq.put("Ni", 318);
    freq.put("bje", 54);
    freq.put("Jui", 24);
    freq.put("aze", 48);
    freq.put("aç", 129);
    freq.put("No", 1068);
    freq.put("aé", 47);
    freq.put("Na", 371);
    freq.put("rvé", 48);
    freq.put("yyy", 24);
    freq.put("Ne", 327);
    freq.put("aï", 74);
    freq.put("aî", 245);
    freq.put("çon", 214);
    freq.put(" sy", 277);
    freq.put("Num", 23);
    freq.put("Nu", 76);
    freq.put("het", 283);
    freq.put("heu", 740);
    freq.put("hev", 209);
    freq.put("log", 563);
    freq.put("her", 1021);
    freq.put("hes", 287);
    freq.put("EL ", 28);
    freq.put("loi", 373);
    freq.put("lon", 849);
    freq.put("hey", 30);
    freq.put("hez", 593);
    freq.put("lom", 54);
    freq.put("ode", 530);
    freq.put("hee", 32);
    freq.put("hef", 65);
    freq.put("loq", 65);
    freq.put("fir", 160);
    freq.put(" Cô", 26);
    freq.put("lot", 227);
    freq.put("hec", 52);
    freq.put("hel", 131);
    freq.put("hem", 219);
    freq.put("hen", 87);
    freq.put("loy", 44);
    freq.put("asq", 76);
    freq.put("hei", 309);
    freq.put("igé", 92);
    freq.put("umé", 211);
    freq.put("ago", 66);
    freq.put("uin", 173);
    freq.put("jug", 55);
    freq.put("N ", 625);
    freq.put("pu ", 118);
    freq.put("zz ", 69);
    freq.put("J", 7265);
    freq.put("na ", 330);
    freq.put("ulu", 36);
    freq.put("jum", 35);
    freq.put("jur", 82);
    freq.put("jus", 838);
    freq.put("wal", 28);
    freq.put("yag", 75);
    freq.put("Un ", 610);
    freq.put("lo ", 261);
    freq.put("agi", 348);
    freq.put("uvé", 192);
    freq.put("uêt", 63);
    freq.put("uli", 199);
    freq.put("mét", 140);
    freq.put("agg", 23);
    freq.put("oël", 23);
    freq.put("Avo", 30);
    freq.put("he ", 1704);
    freq.put("Avi", 37);
    freq.put("eh ", 66);
    freq.put(" sn", 49);
    freq.put("yab", 47);
    freq.put("Ava", 39);
    freq.put("aa", 1015);
    freq.put("oth", 67);
    freq.put("ac", 4900);
    freq.put("ab", 1994);
    freq.put("ae", 108);
    freq.put("ad", 2035);
    freq.put("ag", 4022);
    freq.put("af", 715);
    freq.put("ai", 34030);
    freq.put("ah", 2469);
    freq.put("ak", 288);
    freq.put("aj", 247);
    freq.put("am", 3809);
    freq.put("al", 8122);
    freq.put("ao", 256);
    freq.put("an", 21894);
    freq.put("aq", 548);
    freq.put("ap", 3485);
    freq.put("as", 13715);
    freq.put("ar", 14028);
    freq.put("au", 11832);
    freq.put("at", 7522);
    freq.put("aw", 97);
    freq.put("av", 6377);
    freq.put("ay", 1112);
    freq.put("ax", 234);
    freq.put("az", 295);
    freq.put("uis", 3159);
    freq.put("yon", 207);
    freq.put("igu", 206);
    freq.put("igt", 63);
    freq.put("igr", 61);
    freq.put("Ma ", 210);
    freq.put("cp ", 58);
    freq.put("ées", 534);
    freq.put("oto", 710);
    freq.put("The", 108);
    freq.put("noi", 235);
    freq.put("ige", 190);
    freq.put("éel", 57);
    freq.put("iga", 139);
    freq.put("ota", 153);
    freq.put("igo", 164);
    freq.put("ign", 839);
    freq.put("you", 137);
    freq.put("Spe", 34);
    freq.put("igi", 136);
    freq.put("igh", 118);
    freq.put("a ", 30554);
    freq.put("vé ", 361);
    freq.put("lga", 25);
    freq.put(" g ", 62);
    freq.put("uie", 176);
    freq.put("ru", 1448);
    freq.put("sia", 47);
    freq.put("Ê", 29);
    freq.put("oh ", 184);
    freq.put(" zo", 78);
    freq.put("ote", 666);
    freq.put("rét", 87);
    freq.put("rp", 271);
    freq.put("lge", 34);
    freq.put("clé", 83);
    freq.put("vée", 153);
    freq.put("at ", 888);
    freq.put("US ", 110);
    freq.put("uv ", 25);
    freq.put("Bru", 52);
    freq.put("La ", 1314);
    freq.put("yo ", 25);
    freq.put("gên", 24);
    freq.put(" ze", 24);
    freq.put("u", 136231);
    freq.put("Bri", 65);
    freq.put("ig ", 65);
    freq.put("uit", 1234);
    freq.put("ée ", 2746);
    freq.put("Bre", 111);
    freq.put("Bra", 77);
    freq.put("Fir", 26);
    freq.put("alo", 927);
    freq.put("sco", 176);
    freq.put("alm", 103);
    freq.put("sci", 120);
    freq.put(" R ", 50);
    freq.put("pti", 291);
    freq.put("lr ", 68);
    freq.put("sce", 71);
    freq.put("sms", 59);
    freq.put("pte", 743);
    freq.put("ptd", 31);
    freq.put("sca", 121);
    freq.put("lly", 53);
    freq.put("pta", 49);
    freq.put("€", 244);
    freq.put("lgr", 43);
    freq.put("gt", 236);
    freq.put("ndu", 350);
    freq.put("Fig", 48);
    freq.put("aly", 62);
    freq.put("scu", 103);
    freq.put("gs", 100);
    freq.put("fa ", 36);
    freq.put("alu", 112);
    freq.put("Fin", 108);
    freq.put("mne", 28);
    freq.put("Fil", 57);
    freq.put("Gir", 44);
    freq.put("hy ", 33);
    freq.put("ws ", 145);
    freq.put("ots", 147);
    freq.put("tz", 35);
    freq.put("edd", 42);
    freq.put("ty", 325);
    freq.put("tv", 43);
    freq.put(" N ", 143);
    freq.put("tt", 4610);
    freq.put("tu", 5579);
    freq.put("tr", 11307);
    freq.put("ts", 2796);
    freq.put("tp", 300);
    freq.put("tn", 73);
    freq.put("to", 9882);
    freq.put("tl", 129);
    freq.put("tm", 70);
    freq.put("tj", 77);
    freq.put("tk", 54);
    freq.put("th", 877);
    freq.put("ti", 11408);
    freq.put("tf", 54);
    freq.put("td", 68);
    freq.put("te", 23461);
    freq.put("tb", 46);
    freq.put("tc", 408);
    freq.put("ta", 7633);
    freq.put("edi", 443);
    freq.put("ium", 44);
    freq.put("smi", 38);
    freq.put("mpa", 472);
    freq.put("far", 44);
    freq.put("fas", 97);
    freq.put("mpl", 642);
    freq.put("ajo", 159);
    freq.put("fav", 44);
    freq.put("fat", 82);
    freq.put("fau", 923);
    freq.put("rl", 1195);
    freq.put("mpt", 418);
    freq.put("fai", 5160);
    freq.put("fan", 475);
    freq.put("gy", 48);
    freq.put("fal", 98);
    freq.put("rm", 1876);
    freq.put("fab", 42);
    freq.put("fac", 434);
    freq.put(" ré", 1806);
    freq.put(" rè", 49);
    freq.put(" rê", 168);
    freq.put(" Ni", 310);
    freq.put("gg", 102);
    freq.put("and", 3246);
    freq.put("ro", 9451);
    freq.put(" No", 1064);
    freq.put("eds", 46);
    freq.put(" Na", 369);
    freq.put(" Ne", 309);
    freq.put("ge", 5676);
    freq.put("eçu", 56);
    freq.put("aje", 33);
    freq.put("hyp", 65);
    freq.put("hys", 63);
    freq.put("eço", 64);
    freq.put("sma", 49);
    freq.put("sér", 307);
    freq.put("rré", 127);
    freq.put("rk", 423);
    freq.put(" Nu", 75);
    freq.put("t ", 54194);
    freq.put(" w", 582);
    freq.put("yé", 178);
    freq.put("ïd", 24);
    freq.put("xcu", 60);
    freq.put("ga", 2568);
    freq.put("pté", 40);
    freq.put("alé", 70);
    freq.put("ù ", 365);
    freq.put("teb", 37);
    freq.put("edu", 23);
    freq.put("mbi", 155);
    freq.put("lée", 206);
    freq.put("tef", 34);
    freq.put("DV ", 27);
    freq.put("tex", 83);
    freq.put("go", 1072);
    freq.put("tez", 249);
    freq.put("asp", 43);
    freq.put("nbo", 31);
    freq.put("oha", 28);
    freq.put("ter", 3789);
    freq.put("tes", 2902);
    freq.put("tet", 78);
    freq.put("gm", 72);
    freq.put("tev", 50);
    freq.put("ça ", 2919);
    freq.put("asc", 78);
    freq.put("suf", 60);
    freq.put("sue", 47);
    freq.put("Gil", 24);
    freq.put("suc", 87);
    freq.put("sub", 55);
    freq.put("sua", 23);
    freq.put("sun", 51);
    freq.put("tô", 366);
    freq.put("sul", 191);
    freq.put("abl", 818);
    freq.put("suj", 75);
    freq.put("sui", 2584);
    freq.put("rou", 1503);
    freq.put("mmu", 177);
    freq.put("abr", 96);
    freq.put("abs", 88);
    freq.put("tê", 236);
    freq.put("rov", 77);
    freq.put("tè", 137);
    freq.put("té", 3776);
    freq.put("aby", 43);
    freq.put("ang", 1389);
    freq.put("ccè", 51);
    freq.put(" ru", 256);
    freq.put("sés", 82);
    freq.put("rbi", 58);
    freq.put("lko", 42);
    freq.put("te ", 10468);
    freq.put("K", 723);
    freq.put("laq", 92);
    freq.put("mpê", 58);
    freq.put("mpé", 72);
    freq.put(" re", 5392);
    freq.put(" rd", 24);
    freq.put("mpô", 27);
    freq.put("sép", 29);
    freq.put(" ra", 1371);
    freq.put("pub", 359);
    freq.put("çai", 365);
    freq.put(" ro", 510);
    freq.put("puc", 31);
    freq.put(" ri", 1331);
    freq.put(" rh", 29);
    freq.put("rém", 92);
    freq.put("à", 8806);
    freq.put("ass", 2343);
    freq.put("su ", 52);
    freq.put("oma", 244);
    freq.put("PE ", 24);
    freq.put("mmo", 80);
    freq.put("TS ", 27);
    freq.put("éfé", 166);
    freq.put("rul", 27);
    freq.put("ev ", 30);
    freq.put("anq", 406);
    freq.put("sig", 224);
    freq.put("mmi", 50);
    freq.put("Une", 451);
    freq.put("câb", 23);
    freq.put("vic", 218);
    freq.put("Auc", 42);
    freq.put("Aub", 60);
    freq.put("uée", 160);
    freq.put("Aud", 25);
    freq.put("rkr", 30);
    freq.put("éto", 142);
    freq.put("vez", 425);
    freq.put("Top", 34);
    freq.put("Auj", 171);
    freq.put("vin", 127);
    freq.put("Aur", 76);
    freq.put("vil", 245);
    freq.put("Tou", 473);
    freq.put("vir", 178);
    freq.put("rke", 71);
    freq.put("Aus", 24);
    freq.put(" Fr", 983);
    freq.put("jrs", 30);
    freq.put("Aut", 53);
    freq.put("vit", 534);
    freq.put("Uni", 100);
    freq.put("yé ", 136);
    freq.put("S ", 1306);
    freq.put("vul", 23);
    freq.put(" s ", 1341);
    freq.put("Tie", 55);
    freq.put("séc", 68);
    freq.put("eye", 40);
    freq.put("Vu ", 39);
    freq.put("twe", 579);
    freq.put("aso", 38);
    freq.put("Oba", 30);
    freq.put("ull", 114);
    freq.put("ègl", 47);
    freq.put("eyo", 36);
    freq.put(" d ", 4342);
    freq.put("anc", 2608);
    freq.put("asm", 39);
    freq.put("oyé", 88);
    freq.put("vi", 5777);
    freq.put("de ", 20351);
    freq.put("Ta ", 62);
    freq.put("In ", 30);
    freq.put("Em", 99);
    freq.put("Sy", 89);
    freq.put("éte", 234);
    freq.put("sée", 306);
    freq.put("jr ", 27);
    freq.put("mph", 26);
    freq.put("Sp", 141);
    freq.put("Su", 518);
    freq.put("St", 427);
    freq.put("Sk", 47);
    freq.put("Not", 54);
    freq.put("Si", 905);
    freq.put("Sh", 150);
    freq.put("So", 486);
    freq.put("Sn", 25);
    freq.put("Sm", 32);
    freq.put("Sl", 35);
    freq.put("Sc", 103);
    freq.put("fé", 503);
    freq.put("Sa", 808);
    freq.put("éta", 1302);
    freq.put("çà ", 25);
    freq.put("vel", 743);
    freq.put("Se", 539);
    freq.put("Eh", 48);
    freq.put(" do", 2327);
    freq.put("vp", 38);
    freq.put(" dm", 40);
    freq.put("ège", 80);
    freq.put(" di", 3548);
    freq.put("Int", 183);
    freq.put("aki", 59);
    freq.put("Inv", 28);
    freq.put("des", 5167);
    freq.put(" dc", 31);
    freq.put("deu", 537);
    freq.put(" da", 3143);
    freq.put("Ins", 90);
    freq.put("deh", 57);
    freq.put("équ", 179);
    freq.put("dej", 70);
    freq.put("uxe", 45);
    freq.put("del", 176);
    freq.put("dem", 990);
    freq.put("den", 482);
    freq.put("v", 35363);
    freq.put("Ind", 31);
    freq.put("dea", 136);
    freq.put("Inf", 47);
    freq.put("dec", 92);
    freq.put(" ds", 107);
    freq.put(" dr", 464);
    freq.put("def", 28);
    freq.put("Inc", 26);
    freq.put("bia", 54);
    freq.put("qq ", 25);
    freq.put("doi", 464);
    freq.put("f ", 1503);
    freq.put("hha", 26);
    freq.put("lal", 89);
    freq.put("Vil", 61);
    freq.put("é ", 7685);
    freq.put("pai", 190);
    freq.put("hhh", 186);
    freq.put("iPa", 61);
    freq.put("xue", 29);
    freq.put("ûr ", 91);
    freq.put("leç", 25);
    freq.put("iPo", 31);
    freq.put("Yor", 35);
    freq.put("ôn", 60);
    freq.put("ôl", 172);
    freq.put("ôm", 64);
    freq.put("êté", 45);
    freq.put("iso", 1004);
    freq.put("ryt", 30);
    freq.put("io ", 244);
    freq.put("oya", 373);
    freq.put("ats", 299);
    freq.put("pap", 129);
    freq.put("fr", 1655);
    freq.put(" À ", 81);
    freq.put("ft", 98);
    freq.put("fu", 493);
    freq.put("Dom", 63);
    freq.put("our", 11708);
    freq.put("Gle", 28);
    freq.put("Cin", 30);
    freq.put("rmo", 70);
    freq.put("fa", 7754);
    freq.put("Sé", 181);
    freq.put("hh ", 132);
    freq.put("fe", 1671);
    freq.put("ff", 1846);
    freq.put("rin", 411);
    freq.put("fi", 3857);
    freq.put("xer", 49);
    freq.put("fl", 503);
    freq.put("fo", 3531);
    freq.put("a", 177307);
    freq.put("pât", 27);
    freq.put("lhe", 63);
    freq.put(" dé", 3144);
    freq.put(" dè", 84);
    freq.put("awa", 28);
    freq.put(" c ", 5570);
    freq.put("cs ", 351);
    freq.put("egu", 25);
    freq.put("ûre", 46);
    freq.put("mar", 1122);
    freq.put("ne ", 11697);
    freq.put("egi", 55);
    freq.put(" dû", 31);
    freq.put("ds ", 809);
    freq.put("ega", 590);
    freq.put("CA ", 33);
    freq.put("évi", 180);
    freq.put("oy ", 63);
    freq.put("itn", 33);
    freq.put("ito", 151);
    freq.put("IP ", 35);
    freq.put("fié", 45);
    freq.put("ith", 65);
    freq.put("iti", 828);
    freq.put("y ", 4224);
    freq.put("ffu", 54);
    freq.put("ite", 2623);
    freq.put("itc", 60);
    freq.put("ita", 477);
    freq.put("ffo", 57);
    freq.put("ok ", 558);
    freq.put(" sé", 511);
    freq.put("omo", 120);
    freq.put("éje", 26);
    freq.put("ffi", 426);
    freq.put("ity", 69);
    freq.put("fff", 88);
    freq.put("itt", 927);
    freq.put("itu", 378);
    freq.put("itr", 294);
    freq.put("its", 355);
    freq.put("ffa", 158);
    freq.put(" On", 712);
    freq.put(" Oo", 61);
    freq.put(" Ol", 55);
    freq.put(" Om", 24);
    freq.put("UR ", 80);
    freq.put(" Ok", 138);
    freq.put(" Oh", 284);
    freq.put(" Of", 75);
    freq.put("lai", 1535);
    freq.put(" Ob", 69);
    freq.put(" Oc", 38);
    freq.put("nto", 126);
    freq.put("usp", 41);
    freq.put("Sam", 88);
    freq.put("if ", 273);
    freq.put("tp ", 170);
    freq.put("ak ", 48);
    freq.put("lgi", 35);
    freq.put(" Ou", 1133);
    freq.put(" Or", 150);
    freq.put("▸ ", 72);
    freq.put(" Op", 54);
    freq.put("Bat", 27);
    freq.put("ym", 295);
    freq.put("yl", 180);
    freq.put("yo", 413);
    freq.put("yn", 177);
    freq.put("ya", 706);
    freq.put("cen", 382);
    freq.put("yc", 196);
    freq.put("yb", 70);
    freq.put("ye", 1167);
    freq.put("L", 7567);
    freq.put("it ", 8583);
    freq.put("Bay", 24);
    freq.put("yy", 41);
    freq.put("cev", 63);
    freq.put("ceu", 236);
    freq.put("cet", 812);
    freq.put("Bab", 25);
    freq.put("Bac", 36);
    freq.put("dig", 71);
    freq.put("cep", 172);
    freq.put("Ban", 67);
    freq.put("yp", 213);
    freq.put("ys", 445);
    freq.put("yr", 128);
    freq.put("yu", 34);
    freq.put("Eri", 28);
    freq.put("Bah", 219);
    freq.put("ff ", 200);
    freq.put("ayn", 52);
    freq.put("À ", 84);
    freq.put("Rac", 24);
    freq.put("dû ", 31);
    freq.put("ifs", 86);
    freq.put("yne", 29);
    freq.put("ulé", 83);
    freq.put("Ram", 24);
    freq.put(" O ", 174);
    freq.put("ël", 42);
    freq.put("ife", 78);
    freq.put("iff", 448);
    freq.put("lyc", 113);
    freq.put("ifa", 27);
    freq.put("man", 1796);
    freq.put("édi", 454);
    freq.put("pc ", 32);
    freq.put("ifo", 28);
    freq.put("ifi", 385);
    freq.put("éda", 45);
    freq.put(" A ", 624);
    freq.put("Enc", 70);
    freq.put("Enf", 146);
    freq.put("ité", 1097);
    freq.put(" sr", 23);
    freq.put("TF ", 91);
    freq.put(" sp", 401);
    freq.put(" sq", 32);
    freq.put(" sv", 36);
    freq.put(" st", 739);
    freq.put(" su", 7641);
    freq.put("éjà", 493);
    freq.put(" sk", 73);
    freq.put(" sh", 212);
    freq.put(" si", 2651);
    freq.put("Ent", 71);
    freq.put(" so", 5571);
    freq.put("Env", 48);
    freq.put(" sm", 115);
    freq.put(" sc", 269);
    freq.put("uda", 34);
    freq.put(" sa", 4107);
    freq.put("mm ", 111);
    freq.put(" se", 5303);
    freq.put("Wil", 35);
    freq.put("iza", 128);
    freq.put("ize", 26);
    freq.put("gur", 42);
    freq.put("afé", 65);
    freq.put("E ", 1425);
    freq.put("oig", 141);
    freq.put("trô", 60);
    freq.put(" Où", 23);
    freq.put("sid", 177);
    freq.put("izz", 54);
    freq.put("pha", 88);
    freq.put("En ", 513);
    freq.put(" Aa", 67);
    freq.put(" Ab", 64);
    freq.put(" Ac", 136);
    freq.put(" Ad", 111);
    freq.put("pui", 737);
    freq.put(" Af", 80);
    freq.put(" Ag", 80);
    freq.put(" Ah", 612);
    freq.put(" Ai", 101);
    freq.put("asy", 26);
    freq.put(" Al", 683);
    freq.put(" Am", 182);
    freq.put(" An", 390);
    freq.put(" Ao", 40);
    freq.put(" Ap", 353);
    freq.put("thi", 84);
    freq.put(" Ar", 336);
    freq.put(" As", 120);
    freq.put(" At", 120);
    freq.put(" Au", 703);
    freq.put(" Av", 274);
    freq.put("put", 338);
    freq.put(" Ay", 98);
    freq.put(" Az", 28);
    freq.put("ash", 164);
    freq.put("mma", 309);
    freq.put("evr", 210);
    freq.put("pur", 52);
    freq.put("pus", 37);
    freq.put("iz ", 53);
    freq.put("El", 411);
    freq.put("En", 929);
    freq.put("NG ", 23);
    freq.put("koo", 32);
    freq.put("ion", 5309);
    freq.put("Ed", 58);
    freq.put("Ef", 27);
    freq.put("but", 273);
    freq.put("phy", 57);
    freq.put("Ec", 107);
    freq.put("cté", 49);
    freq.put("nfi", 582);
    freq.put("ft ", 53);
    freq.put("pos", 916);
    freq.put("Ex", 184);
    freq.put("w", 3872);
    freq.put("édé", 57);
    freq.put("Eu", 233);
    freq.put("Et", 1114);
    freq.put("tph", 39);
    freq.put("Ev", 88);
    freq.put("Ep", 25);
    freq.put("Es", 213);
    freq.put("Er", 54);
    freq.put("Ima", 34);
    freq.put("rro", 116);
    freq.put("Fra", 814);
    freq.put("Clo", 38);
    freq.put("Cli", 37);
    freq.put("Fre", 95);
    freq.put("hèt", 48);
    freq.put("Fri", 34);
    freq.put("upa", 61);
    freq.put("Cla", 69);
    freq.put("lié", 138);
    freq.put("Imp", 41);
    freq.put("ude", 259);
    freq.put("uen", 170);
    freq.put("bul", 57);
    freq.put("elk", 46);
    freq.put("oir", 3655);
    freq.put("nc ", 713);
    freq.put("Clu", 31);
    freq.put("tou", 4640);
    freq.put(" ▸", 76);
    freq.put("hèm", 35);
    freq.put("zi", 173);
    freq.put("koi", 32);
    freq.put(" em", 524);
    freq.put(" en", 9953);
    freq.put(" eh", 25);
    freq.put("aa ", 90);
    freq.put("jet", 281);
    freq.put("jeu", 518);
    freq.put("X ", 166);
    freq.put("liè", 48);
    freq.put(" ea", 86);
    freq.put(" ec", 142);
    freq.put("jec", 52);
    freq.put("jea", 30);
    freq.put(" ex", 1153);
    freq.put("Res", 58);
    freq.put(" et", 7167);
    freq.put(" eu", 709);
    freq.put(" ev", 40);
    freq.put("kou", 28);
    freq.put("rre", 925);
    freq.put(" er", 204);
    freq.put(" es", 11893);
    freq.put("ag ", 86);
    freq.put("ncr", 93);
    freq.put("tom", 323);
    freq.put("nct", 105);
    freq.put("stè", 73);
    freq.put("odu", 151);
    freq.put("nch", 540);
    freq.put("nci", 269);
    freq.put("eub", 37);
    freq.put("ôme", 43);
    freq.put("nco", 1055);
    freq.put("nca", 100);
    freq.put("oyo", 45);
    freq.put("nce", 3364);
    freq.put("lèg", 83);
    freq.put("ste", 2225);
    freq.put("b", 21000);
    freq.put("aaa", 593);
    freq.put("sta", 799);
    freq.put("ko ", 99);
    freq.put("ké", 43);
    freq.put("sto", 487);
    freq.put(" e ", 279);
    freq.put("sti", 1030);
    freq.put("exé", 35);
    freq.put("i", 156069);
    freq.put("je ", 7606);
    freq.put("htt", 121);
    freq.put("stp", 72);
    freq.put("lèr", 70);
    freq.put("str", 582);
    freq.put("Nui", 25);
    freq.put("sty", 83);
    freq.put("spr", 67);
    freq.put("zy", 158);
    freq.put("Goo", 222);
    freq.put("ka ", 60);
    freq.put("js ", 31);
    freq.put("rry", 219);
    freq.put("udi", 285);
    freq.put("ébi", 53);
    freq.put("Mus", 67);
    freq.put("ofo", 28);
    freq.put("ueu", 435);
    freq.put("oda", 53);
    freq.put("ccr", 53);
    freq.put("lid", 87);
    freq.put("Nik", 31);
    freq.put("lif", 69);
    freq.put("k ", 1688);
    freq.put("Nin", 29);
    freq.put("lia", 147);
    freq.put("ex ", 149);
    freq.put("ofs", 43);
    freq.put("Nic", 126);
    freq.put("lin", 376);
    freq.put("Nia", 60);
    freq.put("uè", 26);
    freq.put("rrr", 555);
    freq.put("lit", 793);
    freq.put("efi", 25);
    freq.put("liv", 668);
    freq.put("lip", 203);
    freq.put("Kin", 44);
    freq.put("lir", 273);
    freq.put("efo", 63);
    freq.put("cci", 66);
    freq.put("uer", 727);
    freq.put("éat", 96);
    freq.put("efe", 76);
    freq.put("eff", 217);
    freq.put("éfa", 44);
    freq.put("abu", 74);
    freq.put("oft", 35);
    freq.put("udo", 103);
    freq.put("Roy", 100);
    freq.put("le ", 17895);
    freq.put("M", 7089);
    freq.put("Go ", 41);
    freq.put("ncu", 69);
    freq.put("ncè", 25);
    freq.put("jsu", 90);
    freq.put("Att", 73);
    freq.put("Thi", 25);
    freq.put("kat", 25);
    freq.put("kay", 38);
    freq.put("Tha", 28);
    freq.put("bac", 140);
    freq.put("kb", 34);
    freq.put("ka", 270);
    freq.put("â", 520);
    freq.put("kg", 25);
    freq.put("exc", 195);
    freq.put("ke", 717);
    freq.put("exa", 120);
    freq.put("kk", 37);
    freq.put("exo", 24);
    freq.put("ki", 561);
    freq.put("kh", 43);
    freq.put("ko", 393);
    freq.put("sté", 152);
    freq.put("km", 43);
    freq.put("kl", 47);
    freq.put("ks", 153);
    freq.put("kr", 82);
    freq.put("ext", 213);
    freq.put("exu", 40);
    freq.put("tps", 26);
    freq.put("ku", 52);
    freq.put("kt", 83);
    freq.put("ef ", 176);
    freq.put("ncl", 57);
    freq.put("ky", 124);
    freq.put("une", 4270);
    freq.put("exy", 40);
    freq.put("Hah", 125);
    freq.put("ath", 187);
    freq.put("ugi", 37);
    freq.put("Hal", 23);
    freq.put("Han", 36);
    freq.put("rév", 325);
    freq.put("Haa", 26);
    freq.put("rto", 350);
    freq.put("réu", 133);
    freq.put(" Bé", 24);
    freq.put("rth", 76);
    freq.put("sup", 467);
    freq.put("Moi", 477);
    freq.put("hi ", 135);
    freq.put("lum", 141);
    freq.put("rél", 75);
    freq.put("oje", 131);
    freq.put("arf", 196);
    freq.put("rtp", 40);
    freq.put("rts", 223);
    freq.put("rtr", 56);
    freq.put("réf", 354);
    freq.put("rég", 113);
    freq.put("Har", 133);
    freq.put("èèè", 29);
    freq.put("rty", 45);
    freq.put("Hau", 37);
    freq.put("ugu", 31);
    freq.put("réa", 337);
    freq.put("ymp", 196);
    freq.put("iez", 156);
    freq.put("rée", 867);
    freq.put("axi", 56);
    freq.put("Ju", 364);
    freq.put("ies", 538);
    freq.put("ier", 2048);
    freq.put("ieu", 1346);
    freq.put("iet", 109);
    freq.put("iew", 85);
    freq.put("iei", 49);
    freq.put("Jo", 417);
    freq.put("iem", 53);
    freq.put("iel", 356);
    freq.put("ien", 6061);
    freq.put("Je", 3273);
    freq.put("ieb", 131);
    freq.put("ox ", 123);
    freq.put("ied", 96);
    freq.put("ymo", 33);
    freq.put("hip", 42);
    freq.put("hiq", 54);
    freq.put("hir", 147);
    freq.put("his", 313);
    freq.put("hit", 60);
    freq.put("rt ", 1749);
    freq.put("hiv", 43);
    freq.put("Ha ", 40);
    freq.put("ddr", 42);
    freq.put("écu", 172);
    freq.put("ug ", 60);
    freq.put("âte", 111);
    freq.put("œu", 81);
    freq.put("hia", 117);
    freq.put("hib", 25);
    freq.put("hic", 58);
    freq.put("hie", 535);
    freq.put("hif", 43);
    freq.put("éac", 41);
    freq.put("hih", 50);
    freq.put("hil", 107);
    freq.put("him", 42);
    freq.put("hin", 226);
    freq.put("hio", 34);
    freq.put("viv", 168);
    freq.put("rfu", 28);
    freq.put("cru", 192);
    freq.put("Sep", 59);
    freq.put("uiè", 91);
    freq.put("rfa", 145);
    freq.put("cra", 343);
    freq.put("Quo", 38);
    freq.put("rfe", 25);
    freq.put("cre", 396);
    freq.put("ie ", 3491);
    freq.put(" Pé", 34);
    freq.put("cri", 722);
    freq.put("J ", 2545);
    freq.put("cro", 918);
    freq.put(" Be", 612);
    freq.put("Fou", 40);
    freq.put("seu", 692);
    freq.put("chè", 83);
    freq.put(" Ba", 689);
    freq.put("ser", 2340);
    freq.put("For", 96);
    freq.put("sep", 247);
    freq.put(" Bl", 291);
    freq.put(" Bo", 1390);
    freq.put("xes", 25);
    freq.put(" Bi", 506);
    freq.put("sez", 343);
    freq.put("bé ", 119);
    freq.put("sex", 141);
    freq.put(" Bu", 119);
    freq.put("ara", 542);
    freq.put("see", 23);
    freq.put("ik ", 47);
    freq.put("sec", 295);
    freq.put("oût", 202);
    freq.put("sea", 181);
    freq.put(" Br", 364);
    freq.put("Fol", 50);
    freq.put("sen", 1025);
    freq.put("Fon", 23);
    freq.put("Foo", 34);
    freq.put("arl", 934);
    freq.put("uu ", 70);
    freq.put("sei", 319);
    freq.put("yau", 25);
    freq.put("vra", 1217);
    freq.put("Plu", 157);
    freq.put("Vit", 25);
    freq.put("stu", 79);
    freq.put("aai", 46);
    freq.put("leg", 32);
    freq.put("use", 1028);
    freq.put("vas", 244);
    freq.put("wor", 31);
    freq.put(" Y ", 269);
    freq.put("Ple", 36);
    freq.put(" P ", 162);
    freq.put("atr", 197);
    freq.put("Pla", 121);
    freq.put("uah", 47);
    freq.put("DD ", 49);
    freq.put("Age", 40);
    freq.put("rço", 52);
    freq.put("bén", 36);
    freq.put(" B ", 73);
    freq.put("Déj", 45);
    freq.put("web", 110);
    freq.put("uuu", 587);
    freq.put("uut", 23);
    freq.put("sts", 39);
    freq.put("béb", 67);
    freq.put("upp", 187);
    freq.put("Déb", 32);
    freq.put("Déc", 91);
    freq.put("ar ", 1837);
    freq.put("ika", 31);
    freq.put("GE ", 29);
    freq.put("len", 613);
    freq.put("ike", 75);
    freq.put("se ", 6317);
    freq.put("uiv", 244);
    freq.put("uê", 64);
    freq.put("iki", 32);
    freq.put("Dép", 35);
    freq.put("ot ", 543);
    freq.put("Dés", 72);
    freq.put(" Pr", 546);
    freq.put("c", 67345);
    freq.put(" Pu", 320);
    freq.put(" Pt", 37);
    freq.put("Yea", 23);
    freq.put("Zel", 41);
    freq.put("bcp", 53);
    freq.put("ève", 159);
    freq.put(" Pa", 1518);
    freq.put(" Pf", 42);
    freq.put(" Pe", 425);
    freq.put(" Pi", 226);
    freq.put(" Ph", 124);
    freq.put(" Po", 953);
    freq.put(" Pl", 315);
    freq.put("Wal", 37);
    freq.put("sky", 49);
    freq.put("séa", 31);
    freq.put("uil", 545);
    freq.put("oqu", 304);
    freq.put("Ita", 39);
    freq.put("riè", 116);
    freq.put("rié", 70);
    freq.put("lbu", 147);
    freq.put("ady", 43);
    freq.put("War", 30);
    freq.put(" t ", 2022);
    freq.put("pr", 7743);
    freq.put("ps", 1276);
    freq.put("pp", 2112);
    freq.put("lég", 128);
    freq.put("dul", 29);
    freq.put("léa", 51);
    freq.put("pt", 1339);
    freq.put("pu", 1854);
    freq.put("lém", 53);
    freq.put("py", 44);
    freq.put("due", 69);
    freq.put("tiv", 431);
    freq.put("pb", 33);
    freq.put("pc", 85);
    freq.put("lév", 32);
    freq.put("pa", 15763);
    freq.put("pf", 52);
    freq.put("nau", 134);
    freq.put("pd", 44);
    freq.put("pe", 8076);
    freq.put("pk", 43);
    freq.put("ph", 1470);
    freq.put("pi", 2088);
    freq.put("po", 10217);
    freq.put("pl", 5693);
    freq.put("exe", 145);
    freq.put("tré", 416);
    freq.put("roy", 127);
    freq.put("gaz", 52);
    freq.put(" ty", 60);
    freq.put("ctu", 284);
    freq.put("Emm", 32);
    freq.put(" tv", 34);
    freq.put(" tu", 3762);
    freq.put(" tt", 92);
    freq.put(" ts", 41);
    freq.put(" tr", 4301);
    freq.put("new", 75);
    freq.put("N", 2645);
    freq.put(" to", 6371);
    freq.put("gan", 203);
    freq.put("gam", 85);
    freq.put("gal", 228);
    freq.put(" tk", 50);
    freq.put("Emp", 29);
    freq.put(" ti", 535);
    freq.put(" th", 218);
    freq.put("gag", 341);
    freq.put(" te", 3486);
    freq.put(" tc", 33);
    freq.put("adé", 37);
    freq.put(" ta", 1572);
    freq.put("fut", 96);
    freq.put("adm", 58);
    freq.put("fur", 24);
    freq.put("fus", 140);
    freq.put("du ", 3975);
    freq.put("cts", 32);
    freq.put("ove", 225);
    freq.put("tre", 4924);
    freq.put("p ", 3441);
    freq.put("fuc", 30);
    freq.put(" fé", 90);
    freq.put("ful", 25);
    freq.put(" fê", 96);
    freq.put("eke", 42);
    freq.put("fui", 33);
    freq.put("lic", 541);
    freq.put("sy ", 60);
    freq.put("Il ", 857);
    freq.put("ûr", 141);
    freq.put("riv", 637);
    freq.put("vom", 26);
    freq.put("rit", 825);
    freq.put("raq", 67);
    freq.put("jpe", 28);
    freq.put("ris", 1965);
    freq.put("rip", 178);
    freq.put("riq", 232);
    freq.put("nés", 67);
    freq.put("rio", 156);
    freq.put("ril", 116);
    freq.put("rim", 349);
    freq.put("voq", 28);
    freq.put("vor", 66);
    freq.put("vos", 230);
    freq.put("rif", 77);
    freq.put("rig", 298);
    freq.put("rid", 92);
    freq.put("rie", 2263);
    freq.put("rib", 179);
    freq.put("ric", 484);
    freq.put("ria", 208);
    freq.put("rde", 1191);
    freq.put("ewi", 25);
    freq.put("pô", 44);
    freq.put("cte", 441);
    freq.put("Êt", 26);
    freq.put("bs ", 100);
    freq.put("ût", 207);
    freq.put("yal", 100);
    freq.put("ceb", 357);
    freq.put("pâ", 28);
    freq.put("gs ", 83);
    freq.put("aha", 957);
    freq.put("pê", 84);
    freq.put("pè", 358);
    freq.put("pé", 1005);
    freq.put("ohn", 29);
    freq.put("bom", 27);
    freq.put("syc", 32);
    freq.put("Cop", 27);
    freq.put("hér", 97);
    freq.put("Cor", 75);
    freq.put("Cou", 200);
    freq.put("omm", 3213);
    freq.put("dge", 50);
    freq.put(" tô", 55);
    freq.put("cea", 45);
    freq.put("OW ", 32);
    freq.put("sym", 156);
    freq.put("sys", 61);
    freq.put("Coc", 27);
    freq.put("lig", 396);
    freq.put("Ils", 186);
    freq.put(" té", 361);
    freq.put("héh", 39);
    freq.put("FA ", 23);
    freq.put("pse", 67);
    freq.put("Com", 517);
    freq.put("Col", 99);
    freq.put("Coo", 48);
    freq.put("Con", 294);
    freq.put("Soc", 60);
    freq.put(" fr", 1256);
    freq.put(" fu", 298);
    freq.put("lib", 224);
    freq.put("Soi", 74);
    freq.put("yan", 153);
    freq.put("ew ", 146);
    freq.put("moi", 2935);
    freq.put("cti", 932);
    freq.put(" fa", 6955);
    freq.put(" fb", 39);
    freq.put(" fe", 826);
    freq.put("lim", 234);
    freq.put("y", 8855);
    freq.put("ths", 42);
    freq.put(" fl", 292);
    freq.put(" fo", 2684);
    freq.put("mon", 2818);
    freq.put("tim", 260);
    freq.put("lio", 190);
    freq.put("uuh", 32);
    freq.put("lde", 51);
    freq.put("éve", 247);
    freq.put("lem", 1149);
    freq.put("hès", 25);
    freq.put("bi ", 59);
    freq.put("O ", 434);
    freq.put("éhé", 58);
    freq.put("éé ", 49);
    freq.put("çà", 25);
    freq.put("aoû", 79);
    freq.put("cod", 107);
    freq.put("lik", 34);
    freq.put("oo ", 117);
    freq.put("elq", 484);
    freq.put("cut", 83);
    freq.put("cus", 129);
    freq.put("cur", 179);
    freq.put("cup", 120);
    freq.put("tru", 530);
    freq.put("ût ", 135);
    freq.put("rga", 134);
    freq.put("cue", 76);
    freq.put("rge", 438);
    freq.put("aps", 28);
    freq.put("cun", 206);
    freq.put("cum", 51);
    freq.put("cul", 425);
    freq.put("ee ", 266);
    freq.put("cui", 115);
    freq.put("rgo", 27);
    freq.put("Oo", 68);
    freq.put("On", 726);
    freq.put("Om", 25);
    freq.put("Ol", 58);
    freq.put("Ok", 138);
    freq.put("aup", 29);
    freq.put("bâ", 41);
    freq.put("Oh", 284);
    freq.put("urd", 540);
    freq.put("Of", 77);
    freq.put("mal", 860);
    freq.put("lis", 1060);
    freq.put("Oc", 39);
    freq.put("bé", 355);
    freq.put("bê", 68);
    freq.put("Air", 25);
    freq.put("tut", 85);
    freq.put("apt", 110);
    freq.put("efa", 71);
    freq.put("Dit", 31);
    freq.put("Aid", 25);
    freq.put("Ou", 1146);
    freq.put("gr", 2308);
    freq.put("Or", 153);
    freq.put("Dir", 93);
    freq.put("Op", 55);
    freq.put("aço", 108);
    freq.put("d", 70071);
    freq.put("cc ", 115);
    freq.put("eez", 29);
    freq.put("ûte", 32);
    freq.put("ahh", 76);
    freq.put("âbl", 23);
    freq.put("ees", 45);
    freq.put("eer", 37);
    freq.put("rg ", 89);
    freq.put("eel", 31);
    freq.put("ule", 1248);
    freq.put("een", 97);
    freq.put("ate", 934);
    freq.put("idè", 27);
    freq.put("idé", 571);
    freq.put("eee", 321);
    freq.put("eed", 35);
    freq.put("eeb", 28);
    freq.put("tie", 1021);
    freq.put("çu", 111);
    freq.put("aci", 193);
    freq.put("b ", 604);
    freq.put("uzz", 58);
    freq.put("uf ", 393);
    freq.put("ru ", 119);
    freq.put("Ven", 119);
    freq.put("ld ", 82);
    freq.put("ça", 3373);
    freq.put("ço", 308);
    freq.put("elu", 180);
    freq.put("oe ", 29);
    freq.put("rêv", 170);
    freq.put("ijo", 38);
    freq.put("rf ", 52);
    freq.put("ps ", 1080);
    freq.put("apa", 157);
    freq.put(" Qu", 1060);
    freq.put("pez", 40);
    freq.put("pet", 673);
    freq.put("peu", 2025);
    freq.put("liq", 349);
    freq.put("per", 2019);
    freq.put("pes", 169);
    freq.put("pel", 548);
    freq.put("pem", 30);
    freq.put("pen", 1214);
    freq.put("Sto", 103);
    freq.put("pei", 112);
    freq.put("rgé", 43);
    freq.put("éo ", 246);
    freq.put("cei", 33);
    freq.put("pea", 91);
    freq.put("id ", 230);
    freq.put("pec", 205);
    freq.put("bd", 38);
    freq.put("be", 2596);
    freq.put("pén", 37);
    freq.put("rui", 118);
    freq.put("run", 76);
    freq.put("ba", 2543);
    freq.put("bb", 88);
    freq.put("bc", 68);
    freq.put("bl", 3500);
    freq.put("ruc", 462);
    freq.put("Bor", 66);
    freq.put("bo", 4021);
    freq.put("bi", 3607);
    freq.put("bj", 59);
    freq.put("kan", 25);
    freq.put("bt", 58);
    freq.put("bu", 994);
    freq.put("oei", 33);
    freq.put("ébu", 160);
    freq.put("Bol", 23);
    freq.put("pêc", 72);
    freq.put("br", 1651);
    freq.put("bs", 269);
    freq.put("rus", 117);
    freq.put("rup", 36);
    freq.put("ufs", 56);
    freq.put("ééé", 137);
    freq.put("by", 264);
    freq.put("rut", 98);
    freq.put("fec", 92);
    freq.put("uff", 256);
    freq.put("éva", 35);
    freq.put("Rom", 41);
    freq.put("ncé", 185);
    freq.put("OI ", 70);
    freq.put("alk", 27);
    freq.put("Rob", 43);
    freq.put("Roc", 46);
    freq.put("ids", 31);
    freq.put("cad", 127);
    freq.put("ido", 52);
    freq.put("yle", 81);
    freq.put("rta", 645);
    freq.put("idi", 236);
    freq.put("DE ", 137);
    freq.put("ylo", 39);
    freq.put("ide", 941);
    freq.put("pe ", 884);
    freq.put("msu", 35);
    freq.put("ida", 191);
    freq.put("nsi", 243);
    freq.put("wn ", 39);
    freq.put("fem", 242);
    freq.put("ME ", 78);
    freq.put("Ell", 322);
    freq.put("nso", 408);
    freq.put(" ut", 235);
    freq.put("nsa", 185);
    freq.put(" C ", 1692);
    freq.put("nsc", 182);
    freq.put(" up", 55);
    freq.put("nse", 1212);
    freq.put(" ur", 71);
    freq.put(" us", 61);
    freq.put(" ul", 30);
    freq.put(" un", 10335);
    freq.put("tér", 330);
    freq.put("Té", 54);
    freq.put("nsp", 111);
    freq.put("tés", 239);
    freq.put("nst", 334);
    freq.put("nsu", 195);
    freq.put("tél", 312);
    freq.put("ut ", 4589);
    freq.put("ixi", 37);
    freq.put("xpo", 52);
    freq.put("Fa", 798);
    freq.put("éno", 178);
    freq.put("naî", 64);
    freq.put("fet", 116);
    freq.put("ffé", 126);
    freq.put("ixe", 49);
    freq.put("chs", 23);
    freq.put(" gâ", 31);
    freq.put("voi", 3036);
    freq.put("xpr", 102);
    freq.put("utr", 661);
    freq.put(" gê", 24);
    freq.put("u ", 20465);
    freq.put(" gè", 52);
    freq.put("gré", 116);
    freq.put("aqu", 541);
    freq.put(" Ch", 828);
    freq.put(" Ci", 108);
    freq.put(" Co", 1357);
    freq.put(" Cl", 195);
    freq.put("ns ", 8689);
    freq.put(" Cc", 48);
    freq.put(" Ca", 928);
    freq.put("tpe", 30);
    freq.put(" Ce", 704);
    freq.put("éab", 31);
    freq.put("paq", 27);
    freq.put("uic", 67);
    freq.put(" Cy", 32);
    freq.put("Sui", 91);
    freq.put("Flo", 31);
    freq.put(" Cr", 168);
    freq.put("Ou ", 102);
    freq.put(" u ", 99);
    freq.put("ué", 720);
    freq.put(" Cu", 69);
    freq.put("cia", 502);
    freq.put("uta", 565);
    freq.put("uy", 103);
    freq.put("ux", 5118);
    freq.put("cie", 568);
    freq.put("uz", 98);
    freq.put("uu", 867);
    freq.put("ut", 9804);
    freq.put("ix ", 508);
    freq.put("uv", 3489);
    freq.put("uq", 67);
    freq.put("up", 2221);
    freq.put("us", 12193);
    freq.put("ur", 24009);
    freq.put("um", 1557);
    freq.put("ul", 3334);
    freq.put("uo", 1631);
    freq.put("un", 11881);
    freq.put("ui", 12090);
    freq.put("uh", 377);
    freq.put("uk", 87);
    freq.put("uj", 1132);
    freq.put("ue", 14952);
    freq.put("ud", 1316);
    freq.put("ug", 685);
    freq.put("z", 4582);
    freq.put("ua", 3193);
    freq.put("uc", 2462);
    freq.put("ub", 1205);
    freq.put("nsé", 185);
    freq.put("âge", 56);
    freq.put("ood", 91);
    freq.put("Tw", 499);
    freq.put("Tu", 902);
    freq.put("Tr", 476);
    freq.put("Ts", 40);
    freq.put("To", 799);
    freq.put("vot", 478);
    freq.put("pée", 113);
    freq.put("ié ", 286);
    freq.put("Th", 218);
    freq.put("Ti", 179);
    freq.put("évo", 165);
    freq.put("lym", 34);
    freq.put("Te", 283);
    freq.put("EZ ", 33);
    freq.put("ayl", 38);
    freq.put("Ta", 297);
    freq.put("nab", 45);
    freq.put("A ", 1136);
    freq.put("ng ", 714);
    freq.put(" gu", 379);
    freq.put(" gr", 1585);
    freq.put("iis", 35);
    freq.put("nad", 58);
    freq.put("Max", 26);
    freq.put("pff", 33);
    freq.put("nan", 948);
    freq.put("dv ", 24);
    freq.put("nal", 754);
    freq.put("nam", 48);
    freq.put("nar", 173);
    freq.put("nas", 87);
    freq.put("nap", 43);
    freq.put("gre", 197);
    freq.put("nav", 48);
    freq.put("Mad", 75);

    init3();
  }
  private static void init3() {
    
    freq.put("nat", 432);
    freq.put("gra", 1149);
    freq.put("naz", 24);
    freq.put(" go", 429);
    freq.put(" gl", 112);
    freq.put("ark", 264);
    freq.put("Mam", 26);
    freq.put("Mal", 77);
    freq.put(" gi", 73);
    freq.put("ctr", 92);
    freq.put(" Cé", 35);
    freq.put("exp", 428);
    freq.put("iés", 49);
    freq.put("ovi", 71);
    freq.put("pau", 144);
    freq.put("ddy", 27);
    freq.put("iée", 61);
    freq.put("ac ", 360);
    freq.put("ly ", 167);
    freq.put("tua", 114);
    freq.put("lpe", 28);
    freq.put("T ", 2293);
    freq.put("rdr", 92);
    freq.put("Aa", 67);
    freq.put("agn", 737);
    freq.put("Ac", 140);
    freq.put("Ab", 64);
    freq.put("e", 313159);
    freq.put("Ad", 115);
    freq.put("Ag", 83);
    freq.put("Af", 82);
    freq.put("Ai", 106);
    freq.put("Ah", 618);
    freq.put("cié", 78);
    freq.put("ciè", 26);
    freq.put("Am", 184);
    freq.put("Al", 688);
    freq.put("Ao", 40);
    freq.put("An", 397);
    freq.put("ahu", 25);
    freq.put("Ap", 359);
    freq.put("As", 122);
    freq.put("Ar", 339);
    freq.put("Au", 706);
    freq.put("At", 121);
    freq.put("Aw", 23);
    freq.put("Av", 276);
    freq.put("Ay", 98);
    freq.put("agu", 164);
    freq.put("Az", 28);
    freq.put("nvi", 666);
    freq.put("agr", 103);
    freq.put("svp", 29);
    freq.put(" b", 10938);
    freq.put(" c", 31373);
    freq.put("gu", 1380);
    freq.put(" a", 36208);
    freq.put(" f", 14606);
    freq.put(" g", 5268);
    freq.put(" d", 47051);
    freq.put(" e", 34107);
    freq.put(" j", 17305);
    freq.put(" k", 654);
    freq.put(" h", 5184);
    freq.put(" i", 8956);
    freq.put(" n", 9598);
    freq.put(" o", 9922);
    freq.put(" l", 37376);
    freq.put(" m", 29399);
    freq.put(" r", 11048);
    freq.put(" s", 29662);
    freq.put(" p", 40395);
    freq.put(" q", 15465);
    freq.put(" v", 15997);
    freq.put("gb", 94);
    freq.put(" t", 24316);
    freq.put(" u", 10967);
    freq.put(" z", 226);
    freq.put("gn", 1694);
    freq.put(" x", 1399);
    freq.put(" y", 2263);
    freq.put("pul", 85);
    freq.put("ap ", 131);
    freq.put("gi", 1132);
    freq.put("gh", 177);
    freq.put(" B", 4635);
    freq.put(" C", 6786);
    freq.put("Non", 442);
    freq.put(" A", 5812);
    freq.put(" F", 3253);
    freq.put(" G", 2078);
    freq.put(" D", 5034);
    freq.put(" E", 4071);
    freq.put(" J", 7242);
    freq.put(" K", 704);
    freq.put(" H", 1915);
    freq.put(" I", 2337);
    freq.put(" N", 2610);
    freq.put(" O", 3616);
    freq.put(" L", 7509);
    freq.put(" M", 7003);
    freq.put(" R", 3645);
    freq.put(" S", 5251);
    freq.put(" P", 5766);
    freq.put(" Q", 1191);
    freq.put(" V", 1978);
    freq.put(" W", 822);
    freq.put(" T", 5110);
    freq.put(" U", 1763);
    freq.put(" Z", 323);
    freq.put("Nou", 300);
    freq.put(" X", 470);
    freq.put(" Y", 724);
    freq.put("né ", 400);
    freq.put("Nor", 86);
    freq.put("sél", 23);
    freq.put("ch ", 389);
    freq.put("ed ", 199);
    freq.put("âg", 62);
    freq.put("âb", 24);
    freq.put("âc", 156);
    freq.put("âl", 29);
    freq.put("rti", 1448);
    freq.put("ân", 23);
    freq.put("évu", 48);
    freq.put("Oui", 491);
    freq.put("obi", 180);
    freq.put("ât", 185);
    freq.put("P", 6114);
    freq.put("d ", 9966);
    freq.put("g ", 1425);
    freq.put("pun", 28);
    freq.put("év", 768);
    freq.put("an ", 1619);
    freq.put("tri", 541);
    freq.put("evi", 341);
    freq.put("tro", 2590);
    freq.put("evo", 274);
    freq.put("tra", 1665);
    freq.put("eva", 353);
    freq.put("us ", 7232);
    freq.put("No ", 23);
    freq.put("eve", 783);
    freq.put("mmé", 43);
    freq.put("sé ", 681);
    freq.put("flé", 45);
    freq.put("ri ", 237);
    freq.put("Spo", 49);
    freq.put("Spa", 23);
    freq.put("û", 408);
    freq.put("ddd", 25);
    freq.put("rdé", 60);
    freq.put("evu", 44);
    freq.put(" â", 92);
    freq.put("ody", 25);
    freq.put(" à", 6980);
    freq.put("zo", 172);
    freq.put("émo", 206);
    freq.put(" ç", 2983);
    freq.put("rri", 860);
    freq.put(" ê", 1112);
    freq.put("ze", 197);
    freq.put(" è", 208);
    freq.put(" é", 4410);
    freq.put("za", 294);
    freq.put("rra", 639);
    freq.put("asa", 58);
    freq.put("uir", 113);
    freq.put("odi", 93);
    freq.put("Blo", 82);
    freq.put("mia", 25);
    freq.put("gâ", 34);
    freq.put("zz", 156);
    freq.put("odo", 68);
    freq.put("Ble", 48);
    freq.put("zu", 29);
    freq.put("rru", 25);
    freq.put("urq", 448);
    freq.put("Bla", 125);
    freq.put("gê", 25);
    freq.put("gé", 795);
    freq.put("gè", 113);
    freq.put("ré ", 551);
    freq.put("F ", 365);
    freq.put(" À", 81);
    freq.put("cé ", 200);
    freq.put(" Ç", 250);
    freq.put(" Ê", 29);
    freq.put("med", 169);
    freq.put(" É", 145);
    freq.put("cai", 229);
    freq.put("réc", 278);
    freq.put("ych", 34);
    freq.put("ct ", 293);
    freq.put("rd ", 1402);
    freq.put("ycl", 32);
    freq.put("jà ", 495);
    freq.put("atu", 327);
    freq.put("hèr", 50);
    freq.put("xD ", 179);
    freq.put("Ora", 50);
    freq.put("lea", 116);
    freq.put("lec", 303);
    freq.put("lee", 66);
    freq.put("obe", 99);
    freq.put("lei", 355);
    freq.put("acr", 74);
    freq.put("z ", 3220);
    freq.put("ock", 171);
    freq.put(" €", 227);
    freq.put("rr ", 281);
    freq.put("lep", 36);
    freq.put("leq", 24);
    freq.put("ler", 1535);
    freq.put("les", 8131);
    freq.put("let", 574);
    freq.put("leu", 1446);
    freq.put("lev", 223);
    freq.put("sûr", 135);
    freq.put("od ", 143);
    freq.put("ley", 62);
    freq.put("lez", 399);
    freq.put("Zay", 31);
    freq.put("yes", 36);
    freq.put("aga", 216);
    freq.put("ozy", 105);
    freq.put("rdu", 130);
    freq.put("evé", 81);
    freq.put("Aha", 98);
    freq.put("xam", 25);
    freq.put("cée", 152);
    freq.put("céd", 85);
    freq.put("oon", 73);
    freq.put("Ahh", 34);
    freq.put("cém", 32);
    freq.put("cél", 60);
    freq.put("gl", 754);
    freq.put("cér", 30);
    freq.put("rda", 92);
    freq.put("cta", 63);
    freq.put("rdo", 112);
    freq.put("cto", 228);
    freq.put("rdi", 399);
    freq.put("Jv", 32);
    freq.put("enj", 41);
    freq.put(" Do", 409);
    freq.put("wif", 29);
    freq.put("Mec", 24);
    freq.put("Ver", 64);
    freq.put(" Dj", 32);
    freq.put(" Di", 433);
    freq.put("apr", 665);
    freq.put("win", 50);
    freq.put(" De", 1058);
    freq.put("Mik", 23);
    freq.put(" Da", 578);
    freq.put("aph", 179);
    freq.put("wit", 790);
    freq.put("ii ", 136);
    freq.put("tdr", 50);
    freq.put("Soy", 23);
    freq.put("NT ", 120);
    freq.put(" Du", 169);
    freq.put("éla", 100);
    freq.put("ypt", 27);
    freq.put(" Dr", 112);
    freq.put("Mil", 68);
    freq.put("cha", 2690);
    freq.put("Fr", 993);
    freq.put("thè", 75);
    freq.put("usc", 51);
    freq.put("Fu", 94);
    freq.put("usa", 61);
    freq.put(" vé", 156);
    freq.put("Hum", 59);
    freq.put("pue", 36);
    freq.put(" vê", 25);
    freq.put("chn", 96);
    freq.put("cho", 997);
    freq.put("chp", 29);
    freq.put(" œ", 28);
    freq.put("JE ", 51);
    freq.put("feu", 152);
    freq.put("fer", 532);
    freq.put("Fe", 123);
    freq.put("usq", 194);
    freq.put(" ça", 2948);
    freq.put("zin", 48);
    freq.put("Fi", 298);
    freq.put("uai", 986);
    freq.put("siè", 73);
    freq.put("Fl", 118);
    freq.put("DF ", 28);
    freq.put("Fo", 285);
    freq.put("ue ", 10417);
    freq.put("ba ", 92);
    freq.put("Gue", 49);
    freq.put("iir", 25);
    freq.put("évè", 33);
    freq.put("Gui", 54);
    freq.put("éos", 54);
    freq.put("éor", 31);
    freq.put(" D ", 548);
    freq.put("sra", 32);
    freq.put("xcl", 41);
    freq.put("bo ", 41);
    freq.put("iii", 490);
    freq.put("Me ", 46);
    freq.put(" Ru", 102);
    freq.put("ace", 1102);
    freq.put("fe ", 124);
    freq.put("f", 24062);
    freq.put("ocu", 63);
    freq.put("km ", 31);
    freq.put("Ja", 312);
    freq.put(" Re", 689);
    freq.put("nda", 636);
    freq.put("apé", 63);
    freq.put(" Ra", 288);
    freq.put("Mai", 1013);
    freq.put("zi ", 38);
    freq.put(" Ro", 434);
    freq.put(" Ri", 205);
    freq.put(" Rh", 37);
    freq.put("tat", 754);
    freq.put("tau", 92);
    freq.put("Ptd", 23);
    freq.put("tap", 159);
    freq.put("taq", 83);
    freq.put(" Dé", 367);
    freq.put("tas", 93);
    freq.put("ièr", 755);
    freq.put("aco", 190);
    freq.put("ièm", 100);
    freq.put("tax", 75);
    freq.put("éer", 51);
    freq.put("ièt", 82);
    freq.put("tad", 40);
    freq.put("taf", 71);
    freq.put("tag", 423);
    freq.put("eno", 142);
    freq.put("tab", 312);
    freq.put("tac", 190);
    freq.put("tal", 521);
    freq.put("Aaa", 48);
    freq.put("tan", 1002);
    freq.put("Mr ", 27);
    freq.put("tai", 2384);
    freq.put(" va", 3102);
    freq.put("sir", 242);
    freq.put("siq", 258);
    freq.put("kyp", 36);
    freq.put(" ve", 2327);
    freq.put("siv", 51);
    freq.put("Yo", 169);
    freq.put("krk", 28);
    freq.put("Ya", 108);
    freq.put("ché", 348);
    freq.put("On ", 622);
    freq.put("ném", 53);
    freq.put("Ye", 78);
    freq.put("afa", 26);
    freq.put(" vo", 5033);
    freq.put("spe", 289);
    freq.put("sic", 107);
    freq.put("sib", 271);
    freq.put(" vs", 74);
    freq.put(" vr", 1016);
    freq.put(" vu", 678);
    freq.put("sif", 47);
    freq.put(" çà", 25);
    freq.put("néc", 35);
    freq.put("sio", 990);
    freq.put("sin", 648);
    freq.put("sim", 182);
    freq.put("ô", 925);
    freq.put("adu", 64);
    freq.put("sis", 213);
    freq.put("omè", 23);
    freq.put("acu", 90);
    freq.put("néf", 23);
    freq.put("act", 671);
    freq.put("nég", 49);
    freq.put("Q", 1208);
    freq.put("enq", 38);
    freq.put("afo", 23);
    freq.put("ta ", 752);
    freq.put("mi ", 324);
    freq.put("ayé", 71);
    freq.put("née", 860);
    freq.put("afi", 134);
    freq.put(" v ", 46);
    freq.put("Y ", 367);
    freq.put("sit", 759);
    freq.put("af ", 48);
    freq.put("sén", 27);
    freq.put("enr", 438);
    freq.put(" →", 25);
    freq.put(" vi", 3495);
    freq.put("bun", 49);
    freq.put("si ", 2902);
    freq.put("mei", 296);
    freq.put(" Ré", 216);
    freq.put("aff", 333);
    freq.put("bor", 188);
    freq.put("oué", 101);
    freq.put("da ", 149);
    freq.put("Aye", 80);
    freq.put("aca", 292);
    freq.put("ens", 2984);
    freq.put("nér", 161);
    freq.put("own", 49);
    freq.put("usé", 95);
    freq.put("dw", 35);
    freq.put("Ca ", 324);
    freq.put("ach", 766);
    freq.put("lf", 58);
    freq.put("lg", 204);
    freq.put("ld", 224);
    freq.put("le", 33478);
    freq.put("lb", 206);
    freq.put("lc", 147);
    freq.put("cag", 31);
    freq.put("la", 15974);
    freq.put("eue", 36);
    freq.put("lo", 5810);
    freq.put("ll", 10786);
    freq.put("lm", 453);
    freq.put("lk", 90);
    freq.put("lh", 90);
    freq.put("li", 7401);
    freq.put("lv", 69);
    freq.put("age", 2165);
    freq.put("lt", 558);
    freq.put("lu", 4783);
    freq.put("lr", 85);
    freq.put("ls", 1677);
    freq.put("lp", 103);
    freq.put("lq", 492);
    freq.put("euu", 48);
    freq.put("eut", 1011);
    freq.put(" h ", 788);
    freq.put("lz", 27);
    freq.put("eup", 42);
    freq.put("eus", 600);
    freq.put("ly", 472);
    freq.put("bav", 26);
    freq.put("dag", 53);
    freq.put("sie", 455);
    freq.put("dac", 42);
    freq.put("Cas", 68);
    freq.put("Car", 178);
    freq.put("dan", 3358);
    freq.put("Cap", 35);
    freq.put("dai", 179);
    freq.put("Cat", 32);
    freq.put("dat", 257);
    freq.put("bau", 28);
    freq.put("dap", 26);
    freq.put("Can", 103);
    freq.put("Cam", 65);
    freq.put("Cal", 49);
    freq.put("qué", 345);
    freq.put("ène", 283);
    freq.put("quê", 63);
    freq.put("day", 66);
    freq.put("ogl", 232);
    freq.put("côt", 121);
    freq.put(" hy", 92);
    freq.put("Ray", 26);
    freq.put("San", 93);
    freq.put("ç", 3837);
    freq.put("Sal", 105);
    freq.put("nfo", 427);
    freq.put(" ég", 95);
    freq.put("Pro", 207);
    freq.put("nfl", 60);
    freq.put("Pri", 88);
    freq.put("eu ", 1562);
    freq.put(" hu", 680);
    freq.put(" ht", 163);
    freq.put(" hi", 532);
    freq.put("FB ", 55);
    freq.put(" ho", 633);
    freq.put("afr", 38);
    freq.put("âce", 61);
    freq.put("Sar", 146);
    freq.put("côn", 26);
    freq.put("sil", 93);
    freq.put("coû", 24);
    freq.put(" he", 980);
    freq.put("fêt", 95);
    freq.put("ouk", 29);
    freq.put("ouj", 607);
    freq.put("oui", 1348);
    freq.put("ouh", 152);
    freq.put("bis", 158);
    freq.put("oun", 127);
    freq.put("oum", 62);
    freq.put("ec ", 2852);
    freq.put("ouc", 759);
    freq.put("oub", 391);
    freq.put("oua", 673);
    freq.put("oug", 240);
    freq.put("ouf", 241);
    freq.put("oue", 619);
    freq.put("oud", 206);
    freq.put("qu ", 2741);
    freq.put("ouy", 24);
    freq.put("→", 26);
    freq.put("aré", 74);
    freq.put("ys ", 169);
    freq.put("wes", 26);
    freq.put("ous", 4604);
    freq.put("pam", 27);
    freq.put("ouq", 26);
    freq.put("oup", 1246);
    freq.put("ouv", 2932);
    freq.put("eni", 501);
    freq.put("out", 4280);
    freq.put("rez", 170);
    freq.put("rey", 69);
    freq.put("lâ", 52);
    freq.put("nça", 382);
    freq.put("là", 1162);
    freq.put("exi", 208);
    freq.put("rer", 691);
    freq.put("res", 3565);
    freq.put("rep", 616);
    freq.put("req", 23);
    freq.put("rev", 558);
    freq.put("cèn", 53);
    freq.put("lé", 1575);
    freq.put("rej", 62);
    freq.put("cèr", 25);
    freq.put("cès", 83);
    freq.put("ren", 2534);
    freq.put("wer", 242);
    freq.put("rel", 285);
    freq.put("rem", 1358);
    freq.put("reb", 78);
    freq.put("rec", 910);
    freq.put("rea", 230);
    freq.put("ref", 316);
    freq.put("reg", 614);
    freq.put("red", 343);
    freq.put("ree", 235);
    freq.put("fun", 44);
    freq.put("ece", 126);
    freq.put("maz", 45);
    freq.put("eca", 26);
    freq.put("CE ", 68);
    freq.put("eco", 459);
    freq.put("boi", 171);
    freq.put("ecl", 31);
    freq.put("eck", 58);
    freq.put("mir", 246);
    freq.put("eci", 102);
    freq.put("ech", 352);
    freq.put("qua", 1568);
    freq.put("ecu", 44);
    freq.put("ect", 1070);
    freq.put("ecs", 123);
    freq.put("ecr", 279);
    freq.put("x", 9609);
    freq.put("qui", 3723);
    freq.put("bal", 255);
    freq.put("quo", 1557);
    freq.put("ask", 51);
    freq.put("ltr", 49);
    freq.put("bam", 39);
    freq.put("g", 19947);
    freq.put("Jos", 26);
    freq.put("rfo", 86);
    freq.put("uha", 121);
    freq.put("Pré", 75);
    freq.put("aou", 102);
    freq.put("nfé", 49);
    freq.put(" hô", 38);
    freq.put(" hé", 152);
    freq.put("ono", 243);
    freq.put("lte", 135);
    freq.put("vac", 271);
    freq.put("Tu ", 747);
    freq.put(" hâ", 50);
    freq.put("Ess", 26);
    freq.put("aor", 23);
    freq.put("K ", 242);
    freq.put("mos", 46);
    freq.put("arq", 223);
    freq.put("rs ", 4933);
    freq.put("arr", 1575);
    freq.put("IT ", 57);
    freq.put("loo", 164);
    freq.put("Fla", 42);
    freq.put("Ah ", 480);
    freq.put("ihi", 68);
    freq.put("lol", 526);
    freq.put("Luc", 54);
    freq.put("ses", 1380);
    freq.put("iha", 26);
    freq.put("og ", 244);
    freq.put("aru", 56);
    freq.put("mes", 1579);
    freq.put("lor", 1011);
    freq.put(" Sy", 89);
    freq.put("udg", 41);
    freq.put("los", 135);
    freq.put("asi", 188);
    freq.put(" Sp", 133);
    freq.put("çu ", 84);
    freq.put("lop", 176);
    freq.put(" St", 412);
    freq.put(" Su", 513);
    freq.put("UN ", 30);
    freq.put(" Sk", 46);
    freq.put(" Sh", 146);
    freq.put(" Si", 900);
    freq.put(" Sn", 25);
    freq.put(" So", 478);
    freq.put(" Sl", 34);
    freq.put(" Sm", 30);
    freq.put(" Sc", 98);
    freq.put(" Sa", 800);
    freq.put("nut", 245);
    freq.put("mer", 1642);
    freq.put(" Se", 532);
    freq.put("udr", 196);
    freq.put("ght", 104);
    freq.put("Ka", 223);
    freq.put("rso", 687);
    freq.put("rsi", 182);
    freq.put("Ke", 73);
    freq.put("dém", 198);
    freq.put("ogu", 123);
    freq.put("rté", 101);
    freq.put("Ki", 118);
    freq.put("Kh", 29);
    freq.put("Ko", 52);
    freq.put("sy", 385);
    freq.put("yme", 24);
    freq.put("Kl", 25);
    freq.put("cyc", 26);
    freq.put("Kr", 32);
    freq.put("ogo", 52);
    freq.put("R", 3676);
    freq.put("ogi", 174);
    freq.put("épl", 49);
    freq.put("eho", 69);
    freq.put("oge", 61);
    freq.put("rsu", 51);
    freq.put("utô", 135);
    freq.put("rsp", 25);
    freq.put("rsq", 50);
    freq.put("vie", 2202);
    freq.put("épr", 80);
    freq.put("Van", 32);
    freq.put("ben", 218);
    freq.put("LA ", 97);
    freq.put("bel", 421);
    freq.put("Tay", 23);
    freq.put("mêm", 1260);
    freq.put("bea", 662);
    freq.put("onc", 1446);
    freq.put("nul", 143);
    freq.put("rca", 45);
    freq.put("ss", 8594);
    freq.put("AL ", 40);
    freq.put("arc", 1121);
    freq.put("ècl", 30);
    freq.put("sr", 74);
    freq.put("ber", 465);
    freq.put("bes", 261);
    freq.put(" S ", 158);
    freq.put("vau", 152);
    freq.put("sq", 665);
    freq.put("bet", 36);
    freq.put("beu", 57);
    freq.put("Pap", 31);
    freq.put("Par", 931);
    freq.put("sp", 1586);
    freq.put("Pat", 41);
    freq.put("Pau", 57);
    freq.put("nqu", 627);
    freq.put("éce", 107);
    freq.put("Pay", 28);
    freq.put("épu", 77);
    freq.put(" E ", 76);
    freq.put("oti", 255);
    freq.put("Pad", 90);
    freq.put("su", 8668);
    freq.put("ari", 1149);
    freq.put("py ", 32);
    freq.put("st", 16542);
    freq.put("Pal", 35);
    freq.put("sem", 990);
    freq.put("Pan", 42);
    freq.put("she", 31);
    freq.put("sk", 178);
    freq.put("sel", 157);
    freq.put("ur ", 13256);
    freq.put("ck ", 471);
    freq.put("mio", 28);
    freq.put("min", 965);
    freq.put("oga", 29);
    freq.put("mic", 75);
    freq.put("mie", 994);
    freq.put("mid", 139);
    freq.put("mig", 100);
    freq.put("ums", 25);
    freq.put("als", 48);
    freq.put("Dep", 80);
    freq.put(" Sé", 181);
    freq.put("arn", 76);
    freq.put("bug", 62);
    freq.put("bus", 165);
    freq.put("miq", 67);
    freq.put("ER ", 113);
    freq.put("mis", 912);
    freq.put("bât", 34);
    freq.put("Der", 52);
    freq.put("Dia", 46);
    freq.put(" El", 408);
    freq.put(" Em", 98);
    freq.put(" En", 925);
    freq.put("jui", 57);
    freq.put(" Eh", 48);
    freq.put("rsé", 30);
    freq.put(" Ed", 57);
    freq.put(" Ef", 27);
    freq.put("rrê", 307);
    freq.put(" Ec", 105);
    freq.put("sc", 1002);
    freq.put("ute", 2014);
    freq.put(" Ex", 181);
    freq.put("Dev", 29);
    freq.put("st ", 10808);
    freq.put(" Et", 1112);
    freq.put(" Eu", 230);
    freq.put(" Ev", 86);
    freq.put("RR ", 93);
    freq.put(" Ep", 25);
    freq.put("sa", 6490);
    freq.put(" Er", 54);
    freq.put(" Es", 210);
    freq.put("cke", 108);
    freq.put("ure", 2289);
    freq.put("urf", 32);
    freq.put("urg", 188);
    freq.put("ong", 564);
    freq.put("mus", 345);
    freq.put("urb", 62);
    freq.put("ckb", 25);
    freq.put("url", 37);
    freq.put("sg", 31);
    freq.put("Pot", 56);
    freq.put("Pou", 596);
    freq.put("cki", 39);
    freq.put("Pos", 60);
    freq.put("sf", 83);
    freq.put("urt", 430);
    freq.put("Pol", 39);
    freq.put("urp", 85);
    freq.put("se", 14773);
    freq.put("cks", 66);
    freq.put("Poi", 36);
    freq.put("Del", 40);
    freq.put("Pod", 36);
    freq.put("sd", 26);
    freq.put("épe", 87);
    freq.put("ury", 27);
    freq.put("Dem", 164);
    freq.put("aba", 111);
    freq.put("Den", 25);
    freq.put("Cha", 301);
    freq.put(" iP", 263);
    freq.put("bum", 145);
    freq.put(" iT", 24);
    freq.put("Rug", 23);
    freq.put("uet", 231);
    freq.put(" iO", 25);
    freq.put("Pé", 35);
    freq.put("Che", 165);
    freq.put("eda", 53);
    freq.put("nge", 1052);
    freq.put("ear", 57);
    freq.put("ère", 1857);
    freq.put("nga", 108);
    freq.put(" w ", 33);
    freq.put("co ", 199);
    freq.put(" ip", 46);
    freq.put("Mor", 109);
    freq.put(" ir", 146);
    freq.put(" is", 88);
    freq.put(" it", 102);
    freq.put("ngi", 28);
    freq.put("jap", 32);
    freq.put("Mot", 38);
    freq.put("jan", 37);
    freq.put("q ", 146);
    freq.put("jal", 51);
    freq.put("jam", 448);
    freq.put(" il", 3997);
    freq.put(" im", 883);
    freq.put(" in", 2589);
    freq.put("jai", 83);
    freq.put("cœ", 38);
    freq.put("Mob", 28);
    freq.put(" ic", 303);
    freq.put(" id", 266);
    freq.put("aîn", 80);
    freq.put(" ig", 29);
    freq.put("tui", 137);
    freq.put("Mou", 113);
    freq.put("bud", 36);
    freq.put("Vra", 34);
    freq.put("as ", 9799);
    freq.put("éph", 132);
    freq.put("mul", 103);
    freq.put("tba", 31);
    freq.put("ttt", 51);
    freq.put("ack", 320);
    freq.put("qq", 61);
    freq.put(" we", 268);
    freq.put("qu", 21468);
    freq.put(" wa", 90);
    freq.put("h", 25244);
    freq.put("ars", 405);
    freq.put("tti", 78);
    freq.put(" wh", 27);
    freq.put(" wi", 63);
    freq.put(" ww", 41);
    freq.put("hôt", 23);
    freq.put("ks ", 114);
    freq.put(" i ", 94);
    freq.put("shi", 154);
    freq.put("eté", 127);
    freq.put("va ", 1329);
    freq.put("ja ", 130);
    freq.put("gby", 76);
    freq.put("Pr", 556);
    freq.put("ebe", 201);
    freq.put("Tec", 26);
    freq.put("eba", 32);
    freq.put("Pt", 38);
    freq.put("Pu", 321);
    freq.put("ebo", 498);
    freq.put("we", 1255);
    freq.put("ke ", 196);
    freq.put("bte", 23);
    freq.put("ebu", 31);
    freq.put("Pa", 1620);
    freq.put("Pf", 42);
    freq.put("BB ", 31);
    freq.put("Pe", 428);
    freq.put("ede", 66);
    freq.put("Ph", 302);
    freq.put("Pi", 233);
    freq.put("Po", 990);
    freq.put("Pl", 325);
    freq.put("hé ", 282);
    freq.put("lur", 32);
    freq.put("lus", 2675);
    freq.put("lut", 431);
    freq.put("wa", 256);
    freq.put("dle", 28);
    freq.put("lux", 32);
    freq.put("ve ", 2038);
    freq.put("XD ", 92);
    freq.put("ngé", 184);
    freq.put("Jac", 53);
    freq.put("épo", 395);
    freq.put("wo", 101);
    freq.put("et ", 8616);
    freq.put("luc", 54);
    freq.put("lue", 90);
    freq.put("uh ", 191);
    freq.put("lui", 822);
    freq.put("omi", 369);
    freq.put("lun", 120);
    freq.put("ken", 46);
    freq.put("jor", 37);
    freq.put("kel", 51);
    freq.put("eb ", 131);
    freq.put("jou", 3051);
    freq.put("eul", 798);
    freq.put("joy", 33);
    freq.put("omn", 43);
    freq.put("Kar", 52);
    freq.put("S", 5338);
    freq.put("eun", 206);
    freq.put("écé", 61);
    freq.put("wi", 974);
    freq.put("key", 30);
    freq.put("Ave", 157);
    freq.put("joi", 107);
    freq.put("vri", 161);
    freq.put("ket", 118);
    freq.put("jol", 115);
    freq.put("ker", 133);
    freq.put("jon", 34);
    freq.put("euh", 91);
    freq.put("etr", 478);
    freq.put("ets", 469);
    freq.put("etw", 60);
    freq.put("ett", 2059);
    freq.put("etu", 31);
    freq.put("è", 5465);
    freq.put("llu", 131);
    freq.put("aho", 32);
    freq.put("lu ", 181);
    freq.put("etc", 69);
    freq.put("tla", 25);
    freq.put("eta", 329);
    freq.put("tle", 66);
    freq.put("ete", 680);
    freq.put("ws", 176);
    freq.put("eth", 29);
    freq.put("eti", 868);
    freq.put("eug", 37);
    freq.put("dû", 32);
    freq.put("ck", 881);
    freq.put("Heu", 67);
    freq.put("ci", 3924);
    freq.put("ch", 9838);
    freq.put("co", 14268);
    freq.put("Exp", 78);
    freq.put("Her", 32);
    freq.put("cl", 1641);
    freq.put("cc", 1204);
    freq.put("vé", 782);
    freq.put("ca", 4593);
    freq.put("ttl", 25);
    freq.put("Lon", 83);
    freq.put("cf", 24);
    freq.put("ce", 11180);
    freq.put("cd", 27);
    freq.put("Lor", 54);
    freq.put("êtr", 1008);
    freq.put("cy", 90);
    freq.put("Est", 94);
    freq.put("rpe", 38);
    freq.put("uca", 67);
    freq.put("nêt", 41);
    freq.put("Hel", 34);
    freq.put("cr", 2969);
    freq.put("cq", 95);
    freq.put("cp", 67);
    freq.put("uck", 124);
    freq.put("Hei", 25);
    freq.put("cu", 1470);
    freq.put("ct", 2464);
    freq.put("urr", 483);
    freq.put("ugg", 24);
    freq.put("mém", 63);
    freq.put("rve", 332);
    freq.put("mén", 64);
    freq.put("émé", 26);
    freq.put("iko", 63);
    freq.put("méc", 84);
    freq.put("Esp", 73);
    freq.put("mée", 70);
    freq.put("méd", 173);
    freq.put("Jul", 76);
    freq.put("uct", 160);
    freq.put("Hon", 25);
    freq.put(" as", 1419);
    freq.put("yai", 75);
    freq.put("TC ", 81);
    freq.put("IE ", 57);
    freq.put("més", 53);
    freq.put("mér", 318);
    freq.put("Geo", 54);
    freq.put("Gen", 114);
    freq.put("eux", 3452);
    freq.put("OL ", 155);
    freq.put("coq", 35);
    freq.put("phé", 37);
    freq.put("Hom", 43);
    freq.put("cop", 212);
    freq.put("pid", 85);
    freq.put("otb", 25);
    freq.put("c ", 10696);
    freq.put("edo", 40);
    freq.put("cos", 73);
    freq.put("pie", 272);
    freq.put("êch", 79);
    freq.put("cor", 1284);
    freq.put("vél", 63);
    freq.put("uc ", 325);
    freq.put("nee", 39);
    freq.put("hme", 39);
    freq.put("otr", 554);
    freq.put("pig", 41);
    freq.put("ott", 202);
    freq.put("cot", 169);
    freq.put("And", 93);
    freq.put("vér", 89);
    freq.put("ysi", 59);
    freq.put("euv", 158);
    freq.put("Ana", 31);
    freq.put("vés", 28);
    freq.put("é", 31478);
    freq.put("mé ", 227);
    freq.put("Ann", 77);
    freq.put("ébo", 29);
    freq.put("Hot", 35);
    freq.put("yse", 35);
    freq.put("reç", 91);
    freq.put("Ant", 53);
    freq.put("ast", 331);
    freq.put("Hou", 52);
    freq.put(" Té", 54);
    freq.put("éba", 138);
    freq.put("Hor", 35);
    freq.put("rbe", 118);
    freq.put("eur", 4515);
    freq.put("ati", 2776);
    freq.put("ya ", 161);
    freq.put("rba", 60);
    freq.put("yst", 123);
    freq.put("va", 6012);
    freq.put("cé", 623);
    freq.put("cè", 184);
    freq.put(" Fu", 91);
    freq.put("ve", 12114);
    freq.put("tar", 557);
    freq.put("câ", 36);
    freq.put("ph ", 25);
    freq.put("non", 1779);
    freq.put("vo", 7208);
    freq.put(" Fa", 774);
    freq.put("vr", 2079);
    freq.put("vs", 82);
    freq.put(" Fe", 122);
    freq.put("vu", 801);
    freq.put(" cœ", 38);
    freq.put(" Fi", 288);
    freq.put("ave", 3082);
    freq.put("You", 109);
    freq.put(" Fl", 115);
    freq.put(" Fo", 273);
    freq.put("cô", 149);
    freq.put("éma", 134);
    freq.put("of ", 205);
    freq.put("pis", 295);
    freq.put("éme", 233);
    freq.put("ls ", 1540);
    freq.put("zy ", 143);
    freq.put(" ép", 256);
    freq.put(" éq", 138);
    freq.put(" ét", 1882);
    freq.put("ues", 1229);
    freq.put(" év", 212);
    freq.put("dal", 63);
    freq.put("utu", 167);
    freq.put(" él", 214);
    freq.put(" ém", 151);
    freq.put(" én", 165);
    freq.put("dam", 126);
    freq.put("bon", 1760);
    freq.put("und", 155);
    freq.put(" éc", 1032);
    freq.put(" éd", 168);
    freq.put("ake", 103);
    freq.put(" T ", 466);
    freq.put("v ", 249);
    freq.put("oté", 126);
    freq.put("phi", 202);
    freq.put("lgé", 35);
    freq.put("pho", 831);
    freq.put("Bro", 39);
    freq.put("ay ", 329);
    freq.put("api", 261);
    freq.put("iou", 57);
    freq.put("iot", 47);
    freq.put("ios", 41);
    freq.put("ior", 72);
    freq.put("phe", 120);
    freq.put(" F ", 94);
    freq.put("œ", 90);
    freq.put("iol", 119);
    freq.put("phr", 71);
    freq.put("Dis", 88);
    freq.put("iod", 30);
    freq.put("von", 230);
    freq.put("crè", 61);
    freq.put("Lai", 25);
    freq.put("Mia", 24);
    freq.put("Sa ", 87);
    freq.put("ont", 3980);
    freq.put("cré", 289);
    freq.put("off", 308);
    freq.put("ofe", 70);
    freq.put(" Tw", 494);
    freq.put(" Tu", 864);
    freq.put("ofi", 145);
    freq.put(" Ts", 33);
    freq.put(" Tr", 470);
    freq.put("col", 614);
    freq.put(" To", 784);
    freq.put("jau", 24);
    freq.put("unn", 30);
    freq.put(" Ti", 176);
    freq.put(" Th", 212);
    freq.put(" é ", 27);
    freq.put("éfè", 103);
    freq.put(" Te", 271);
    freq.put("con", 3890);
    freq.put(" Ta", 292);
    freq.put("She", 24);
    freq.put("onu", 24);
    freq.put("Lag", 26);
    freq.put("bye", 80);
    freq.put("dar", 84);
    freq.put("xel", 23);
    freq.put("xem", 74);
    freq.put("das", 39);
    freq.put("blé", 47);
    freq.put(" xD", 557);
    freq.put("upi", 99);
    freq.put("û ", 37);
    freq.put("tch", 302);
    freq.put("nou", 1770);
    freq.put("lex", 95);
    freq.put("toi", 1705);
    freq.put("tca", 23);
    freq.put("Mau", 25);
    freq.put("Be", 632);
    freq.put("now", 37);
    freq.put("çoi", 94);
    freq.put("Ba", 696);
    freq.put("wee", 767);
    freq.put("Bl", 298);
    freq.put("nop", 24);
    freq.put("Bo", 1417);
    freq.put("Oh ", 260);
    freq.put("Bi", 508);
    freq.put("gme", 53);
    freq.put("Fau", 182);
    freq.put("ske", 59);
    freq.put("Bu", 130);
    freq.put("ger", 806);
    freq.put("Fai", 141);
    freq.put("Fan", 40);
    freq.put("Br", 370);
    freq.put("ada", 198);
    freq.put("Fab", 23);
    freq.put("Fac", 312);
    freq.put("és ", 896);
    freq.put("ski", 33);
    freq.put("adh", 81);
    freq.put("rcé", 50);
    freq.put("gt ", 31);
    freq.put("ôle", 166);
    freq.put("xe ", 148);
    freq.put("eto", 367);
    freq.put("éen", 116);
    freq.put("nfe", 61);
    freq.put("boo", 434);
    freq.put("nve", 315);
    freq.put("Qu ", 98);
    freq.put("T", 5208);
    freq.put("nva", 51);
    freq.put("Lau", 55);
    freq.put("nvo", 315);
    freq.put("abe", 103);
    freq.put("tc ", 65);
    freq.put("ndé", 147);
    freq.put("we ", 26);
    freq.put("B ", 273);
    freq.put("l ", 15415);
    freq.put("car", 587);
    freq.put("iè", 1061);
    freq.put("éss", 24);
    freq.put(" x ", 709);
    freq.put("ésu", 115);
    freq.put("Sac", 29);
    freq.put("ési", 300);
    freq.put("éso", 215);
    freq.put("Lar", 24);
    freq.put("ad ", 272);
    freq.put("ésa", 42);
    freq.put("ése", 416);
    freq.put("ntô", 168);
    freq.put("TV ", 101);
    freq.put("nja", 30);
    freq.put("Sud", 35);
    freq.put("ui ", 5866);
    freq.put("myt", 29);
    freq.put("njo", 255);
    freq.put("dc ", 33);
    freq.put("rqu", 683);
    freq.put("sli", 36);
    freq.put("Sup", 92);
    freq.put("U ", 246);
    freq.put("ièc", 84);
    freq.put("esu", 60);
    freq.put("est", 11913);
    freq.put("ess", 2128);
    freq.put("esq", 164);
    freq.put("esp", 587);
    freq.put("nd ", 2834);
    freq.put("règ", 48);
    freq.put("Bé", 24);
    freq.put("tma", 29);
    freq.put("ese", 75);
    freq.put("esc", 134);
    freq.put("esa", 32);
    freq.put("éne", 117);
    freq.put("eso", 186);
    freq.put("oms", 53);
    freq.put("ga ", 121);
    freq.put(" j ", 4949);
    freq.put("esi", 91);
    freq.put("esh", 55);
    freq.put("vid", 442);
    freq.put("Lis", 30);
    freq.put("dui", 188);
    freq.put("lle", 7917);
    freq.put("IS ", 155);
    freq.put("Ur", 24);
    freq.put("vs ", 75);
    freq.put("Un", 1185);
    freq.put("hât", 73);
    freq.put("OS ", 75);
    freq.put("Ton", 62);
    freq.put(" ha", 1012);
    freq.put("lys", 57);
    freq.put("ndi", 596);
    freq.put("tos", 325);
    freq.put("Sco", 24);
    freq.put("léb", 23);
    freq.put("ndo", 236);
    freq.put(" ju", 1083);
    freq.put(" jt", 72);
    freq.put(" jv", 85);
    freq.put("nde", 1778);
    freq.put(" jp", 44);
    freq.put(" js", 122);
    freq.put(" jr", 23);
    freq.put(" jm", 72);
    freq.put(" jl", 49);
    freq.put(" jo", 1823);
    freq.put("apo", 125);
    freq.put("Sau", 53);
    freq.put("Ça", 245);
    freq.put("es ", 27049);
    freq.put(" je", 8173);
    freq.put("nds", 468);
    freq.put("ndr", 1364);
    freq.put(" ja", 719);
    freq.put("EE ", 26);
    freq.put(" jc", 27);
    freq.put("fèr", 110);
    freq.put("piè", 55);
    freq.put("duc", 175);
    freq.put("Twe", 71);
    freq.put("owe", 270);
    freq.put("ea ", 37);
    freq.put("Twi", 423);
    freq.put("à ", 8643);
    freq.put("ubl", 633);
    freq.put("iné", 251);
    freq.put("SG ", 57);
    freq.put("De ", 210);
    freq.put("Pre", 155);
    freq.put("h ", 4141);
    freq.put("ton", 1083);
    freq.put("ows", 44);
    freq.put("Ami", 33);
    freq.put("lét", 29);
    freq.put("AN ", 51);
    freq.put("vai", 2498);
    freq.put("van", 906);
    freq.put("val", 272);
    freq.put("yro", 26);
    freq.put("Ama", 43);
    freq.put("rcu", 38);
    freq.put("ucu", 158);
    freq.put("oul", 1008);
    freq.put("Ame", 27);
    freq.put("vag", 44);
    freq.put("rcr", 78);
    freq.put("ubi", 36);
    freq.put("rcl", 29);
    freq.put("rco", 67);
    freq.put("rch", 823);
    freq.put("rci", 994);
    freq.put("var", 60);
    freq.put("HE ", 29);
    freq.put("Aff", 31);
    freq.put("vat", 146);
    freq.put("lob", 26);
    freq.put("buz", 35);
    freq.put("eah", 44);
    freq.put("eak", 46);
    freq.put("hy", 204);
    freq.put("eam", 87);
    freq.put("eal", 61);
    freq.put("ean", 229);
    freq.put("hr", 298);
    freq.put("hs", 78);
    freq.put("hp", 48);
    freq.put("Des", 269);
    freq.put("Deu", 61);
    freq.put("ht", 328);
    freq.put("hu", 946);
    freq.put("hh", 366);
    freq.put("hi", 2127);
    freq.put("hn", 146);
    freq.put("ho", 3360);
    freq.put("hl", 68);
    freq.put("hm", 77);
    freq.put("Dea", 33);
    freq.put("eas", 89);
    freq.put("ha", 5757);
    freq.put("eau", 2084);
    freq.put("eat", 74);
    freq.put("hd", 33);
    freq.put("he", 5910);
    freq.put("dus", 73);
    freq.put("Tel", 46);
    freq.put("dme", 23);
    freq.put("Ten", 30);
    freq.put("aah", 129);
    freq.put("avi", 376);
    freq.put("dmi", 53);
    freq.put("hP", 25);
    freq.put("j", 20311);
    freq.put("lèt", 57);
    freq.put("râc", 62);
    freq.put("auv", 322);
    freq.put("Éta", 32);
    freq.put("ow ", 443);
    freq.put("oux", 113);
    freq.put("lva", 27);
    freq.put("Ter", 42);
    freq.put("Tes", 46);
    freq.put("rc ", 91);
    freq.put("pil", 92);
    freq.put("pin", 275);
    freq.put("pio", 73);
    freq.put("int", 1802);
    freq.put("inu", 384);
    freq.put("inv", 249);
    freq.put("pic", 74);
    freq.put("Don", 175);
    freq.put("inq", 171);
    freq.put("ins", 1516);
    freq.put("lm ", 213);
    freq.put("inn", 99);
    freq.put("ino", 443);
    freq.put("ub ", 179);
    freq.put("ini", 729);
    freq.put("inj", 23);
    freq.put("ink", 42);
    freq.put("ind", 385);
    freq.put("ine", 2525);
    freq.put("inf", 315);
    freq.put("ing", 788);
    freq.put("pit", 198);
    freq.put("ina", 646);
    freq.put("arç", 60);
    freq.put("inc", 476);
    freq.put("Amé", 31);
    freq.put("hn ", 32);
    freq.put("eo ", 116);
    freq.put("gay", 45);
    freq.put(" € ", 211);
    freq.put(" Ur", 23);
    freq.put("ep", 1861);
    freq.put(" tw", 927);
    freq.put(" Un", 1181);
    freq.put("Afr", 31);
    freq.put("hpa", 30);
    freq.put("gau", 101);
    freq.put("Mas", 35);
    freq.put("tam", 51);
    freq.put("EN ", 79);
    freq.put("bry", 59);
    freq.put("gat", 108);
    freq.put("uur", 30);
    freq.put("ubr", 73);
    freq.put("ubs", 39);
    freq.put("pi ", 63);
    freq.put("gas", 87);
    freq.put("Ach", 24);
    freq.put("nfa", 237);
    freq.put("hô", 79);
    freq.put("gar", 1034);
    freq.put("Bon", 1000);
    freq.put("ube", 112);
    freq.put("hè", 196);
    freq.put("hé", 745);
    freq.put("U", 1778);
    freq.put("nre", 411);
    freq.put("uxi", 60);
    freq.put("Act", 72);
    freq.put("hâ", 74);
    freq.put("my ", 93);
    freq.put(" tp", 28);
    freq.put("in ", 4378);
    freq.put("Mar", 495);
    freq.put("mèn", 76);
    freq.put("vo ", 78);
    freq.put("CI ", 29);
    freq.put("eof", 39);
    freq.put("amp", 354);
    freq.put("hni", 56);
    freq.put("mèr", 207);
    freq.put("ê", 3884);
    freq.put("big", 30);
    freq.put("eon", 34);
    freq.put("hno", 44);
    freq.put(" xx", 23);
    freq.put("eop", 31);
    freq.put("UT ", 59);
    freq.put("Gén", 35);
    freq.put("mèt", 24);
    freq.put("MS ", 34);
    freq.put(" U ", 51);
    freq.put("att", 1011);
    freq.put(" tj", 73);
  }
  
}

