package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HE {
  private static final String name = "he";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HE() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 457587;
    n_words[1] = 561258;
    n_words[2] = 442245;

    freq.put("קטו", 43);
    freq.put(" ל ", 145);
    freq.put("קטל", 9);
    freq.put("קטן", 41);
    freq.put("קטט", 7);
    freq.put("קטי", 30);
    freq.put("קטנ", 67);
    freq.put("קטע", 64);
    freq.put("ניר", 46);
    freq.put("ניש", 20);
    freq.put("נית", 268);
    freq.put("נינ", 30);
    freq.put("ניס", 100);
    freq.put("ניע", 11);
    freq.put("ניף", 10);
    freq.put("ניפ", 9);
    freq.put("ניצ", 41);
    freq.put("ניק", 64);
    freq.put("לגר", 21);
    freq.put("ניי", 435);
    freq.put("ניך", 8);
    freq.put("ניכ", 16);
    freq.put("ניל", 11);
    freq.put("נים", 663);
    freq.put("נימ", 41);
    freq.put("נין", 9);
    freq.put("ניא", 26);
    freq.put("ניב", 48);
    freq.put("ניג", 13);
    freq.put("ניה", 174);
    freq.put("ניו", 147);
    freq.put("ניח", 25);
    freq.put("חסר", 55);
    freq.put("סק ", 31);
    freq.put("חסמ", 10);
    freq.put("חסי", 29);
    freq.put("חסו", 26);
    freq.put("חק ", 120);
    freq.put("טקס", 24);
    freq.put("נח ", 8);
    freq.put("בספ", 27);
    freq.put("בסק", 12);
    freq.put("בסנ", 6);
    freq.put("פרי", 160);
    freq.put("פרט", 58);
    freq.put("פרח", 15);
    freq.put("כלנ", 6);
    freq.put("פרו", 108);
    freq.put("פרה", 30);
    freq.put("פרד", 32);
    freq.put("פרג", 15);
    freq.put("פרא", 11);
    freq.put("בסו", 102);
    freq.put("בסב", 8);
    freq.put("פרת", 43);
    freq.put("פרש", 28);
    freq.put("פרק", 51);
    freq.put("בסל", 12);
    freq.put("פרץ", 11);
    freq.put("פרפ", 6);
    freq.put("בסי", 61);
    freq.put("פרע", 11);
    freq.put("פרס", 134);
    freq.put("פרנ", 19);
    freq.put("על ", 1104);
    freq.put("כלש", 6);
    freq.put(" מש", 747);
    freq.put(" מר", 286);
    freq.put(" מת", 715);
    freq.put("כלת", 40);
    freq.put(" מס", 403);
    freq.put(" מנ", 207);
    freq.put(" מע", 468);
    freq.put(" מפ", 249);
    freq.put(" מק", 267);
    freq.put(" מצ", 433);
    freq.put(" מי", 985);
    freq.put(" מט", 111);
    freq.put(" מכ", 342);
    freq.put(" מל", 241);
    freq.put(" מן", 17);
    freq.put(" ממ", 409);
    freq.put(" מב", 384);
    freq.put(" מא", 652);
    freq.put(" מד", 315);
    freq.put(" מג", 200);
    freq.put(" מו", 706);
    freq.put(" מה", 1468);
    freq.put(" מח", 502);
    freq.put(" מז", 269);
    freq.put("מרו", 128);
    freq.put("מרה", 35);
    freq.put("מרח", 21);
    freq.put("מרב", 13);
    freq.put("מרא", 47);
    freq.put("מרד", 10);
    freq.put("מרג", 86);
    freq.put("מרמ", 11);
    freq.put("מרי", 199);
    freq.put("מרט", 15);
    freq.put("מרכ", 48);
    freq.put("יסר", 7);
    freq.put("יסת", 20);
    freq.put("יספ", 19);
    freq.put("יסק", 19);
    freq.put("הפ", 618);
    freq.put("יסע", 6);
    freq.put("יסל", 10);
    freq.put("יסמ", 9);
    freq.put("יסי", 100);
    freq.put("יסט", 107);
    freq.put("יסו", 64);
    freq.put("יסה", 40);
    freq.put("יסב", 99);
    freq.put("יסא", 14);
    freq.put("מרץ", 10);
    freq.put("מרפ", 15);
    freq.put("מרק", 20);
    freq.put("מרצ", 17);
    freq.put("מרנ", 8);
    freq.put("גגי", 10);
    freq.put("הס", 460);
    freq.put("מרש", 12);
    freq.put("מרר", 8);
    freq.put("מרת", 178);
    freq.put("תני", 73);
    freq.put("م", 15);
    freq.put("■", 18);
    freq.put("אבר", 23);
    freq.put("תנא", 7);
    freq.put("תנד", 17);
    freq.put("תנג", 21);
    freq.put("תנו", 105);
    freq.put("תנה", 51);
    freq.put("תנח", 21);
    freq.put("בפנ", 42);
    freq.put("הי", 2984);
    freq.put("תנש", 18);
    freq.put("תנת", 26);
    freq.put("אבו", 41);
    freq.put("תנס", 10);
    freq.put("אבי", 132);
    freq.put("אבל", 506);
    freq.put("תנצ", 11);
    freq.put("צדק", 19);
    freq.put("הג", 577);
    freq.put("פגש", 45);
    freq.put("פגר", 45);
    freq.put("הא", 1012);
    freq.put("טלר", 7);
    freq.put("טלק", 7);
    freq.put("פגנ", 25);
    freq.put("פגע", 40);
    freq.put("טלנ", 9);
    freq.put("פגי", 19);
    freq.put("כלה", 18);
    freq.put("טלי", 39);
    freq.put("טלו", 32);
    freq.put("טלה", 15);
    freq.put("פגו", 15);
    freq.put("צדי", 13);
    freq.put("כלב", 66);
    freq.put("😒 ", 7);
    freq.put("כלל", 129);
    freq.put("😒?", 21);
    freq.put("ות?", 11);
    freq.put("ורז", 6);
    freq.put("ורח", 24);
    freq.put("ורה", 262);
    freq.put("ורו", 119);
    freq.put("ורג", 75);
    freq.put("ורד", 65);
    freq.put("ורא", 126);
    freq.put("ורב", 28);
    freq.put("ורמ", 53);
    freq.put("ורן", 20);
    freq.put("ורל", 25);
    freq.put("ורם", 20);
    freq.put("ות ", 4000);
    freq.put("ורכ", 13);
    freq.put("ורט", 55);
    freq.put("ורי", 467);
    freq.put("ורצ", 6);
    freq.put("ורק", 65);
    freq.put("ורפ", 10);
    freq.put("ורע", 11);
    freq.put("ורף", 54);
    freq.put("ורנ", 41);
    freq.put("ורס", 55);
    freq.put("ורת", 79);
    freq.put("עעע", 72);
    freq.put("ורר", 69);
    freq.put("ורש", 29);
    freq.put("נסב", 6);
    freq.put("נסג", 24);
    freq.put("נסה", 51);
    freq.put("נסו", 49);
    freq.put("נסט", 39);
    freq.put("נסי", 82);
    freq.put("ך", 3114);
    freq.put("נסע", 6);
    freq.put("נספ", 8);
    freq.put("נסק", 6);
    freq.put("נסת", 44);
    freq.put("כז ", 25);
    freq.put("זה ", 2478);
    freq.put("םם?", 6);
    freq.put("خ", 6);
    freq.put("םם ", 64);
    freq.put("זה?", 6);
    freq.put("דת", 307);
    freq.put("דש", 396);
    freq.put("דר", 644);
    freq.put("בלט", 8);
    freq.put("פא ", 16);
    freq.put("דף", 30);
    freq.put("דע", 590);
    freq.put("דס", 20);
    freq.put("דנ", 108);
    freq.put("דק", 177);
    freq.put("בלא", 22);
    freq.put("דפ", 83);
    freq.put("דכ", 44);
    freq.put("דך", 13);
    freq.put("די", 1983);
    freq.put("דט", 11);
    freq.put("דן", 87);
    freq.put("דמ", 187);
    freq.put("דם", 253);
    freq.put("דל", 177);
    freq.put("דד", 107);
    freq.put("דג", 43);
    freq.put("דב", 593);
    freq.put("דא", 114);
    freq.put("דח", 51);
    freq.put("דו", 1075);
    freq.put("דה", 654);
    freq.put("הבה", 157);
    freq.put("הבו", 82);
    freq.put("הבח", 34);
    freq.put("הבא", 99);
    freq.put("הבג", 10);
    freq.put("הבד", 31);
    freq.put("הבל", 22);
    freq.put("סם ", 36);
    freq.put("הבן", 23);
    freq.put("הבט", 19);
    freq.put("הבי", 259);
    freq.put("הבק", 6);
    freq.put("הבנ", 102);
    freq.put("הבס", 9);
    freq.put("הבע", 33);
    freq.put("הבר", 38);
    freq.put("הבת", 280);
    freq.put(" צב", 47);
    freq.put(" צא", 16);
    freq.put(" צד", 12);
    freq.put(" צו", 133);
    freq.put(" צה", 37);
    freq.put(" צח", 33);
    freq.put(" צי", 245);
    freq.put(" צל", 14);
    freq.put(" צמ", 31);
    freq.put(" צ׳", 9);
    freq.put(" צנ", 9);
    freq.put("רף ", 74);
    freq.put(" צע", 35);
    freq.put(" צפ", 52);
    freq.put(" צר", 251);
    freq.put("אב ", 99);
    freq.put("החג", 10);
    freq.put("החד", 71);
    freq.put("החב", 75);
    freq.put("החז", 40);
    freq.put("החה", 6);
    freq.put("החו", 102);
    freq.put("החי", 135);
    freq.put("החמ", 18);
    freq.put("החל", 123);
    freq.put("החנ", 15);
    freq.put("החס", 6);
    freq.put("החת", 15);
    freq.put("החר", 23);
    freq.put("החש", 35);
    freq.put("תנ ", 6);
    freq.put("גג ", 11);
    freq.put(" פמ", 14);
    freq.put(" פל", 74);
    freq.put(" פי", 241);
    freq.put(" פט", 15);
    freq.put(" פח", 64);
    freq.put(" פז", 9);
    freq.put(" פו", 195);
    freq.put(" פה", 141);
    freq.put(" פד", 14);
    freq.put(" פג", 26);
    freq.put(" פא", 78);
    freq.put(" פת", 101);
    freq.put(" פש", 116);
    freq.put(" פר", 280);
    freq.put(" פק", 20);
    freq.put(" פצ", 19);
    freq.put(" פע", 230);
    freq.put(" פס", 60);
    freq.put(" פנ", 45);
    freq.put("מר ", 329);
    freq.put("עלת", 18);
    freq.put("עלק", 7);
    freq.put("קמה", 21);
    freq.put(" מ ", 69);
    freq.put("קמי", 10);
    freq.put("קמפ", 14);
    freq.put("קמת", 27);
    freq.put("עלם", 13);
    freq.put("עלמ", 28);
    freq.put("עלי", 433);
    freq.put("עלו", 57);
    freq.put("עלה", 79);
    freq.put("עלב", 11);
    freq.put("נחנ", 146);
    freq.put("נחס", 8);
    freq.put("נחת", 14);
    freq.put("נחש", 16);
    freq.put("בס ", 19);
    freq.put("ז", 6357);
    freq.put("פר ", 256);
    freq.put("נחה", 11);
    freq.put("נחו", 16);
    freq.put("נחמ", 24);
    freq.put("נחל", 25);
    freq.put("נחם", 8);
    freq.put("נחי", 7);
    freq.put("חקנ", 16);
    freq.put("חקר", 20);
    freq.put("חקת", 36);
    freq.put("חקו", 16);
    freq.put("חקה", 6);
    freq.put("חקן", 6);
    freq.put("חקי", 69);
    freq.put("חס ", 33);
    freq.put("סקי", 49);
    freq.put("סקו", 21);
    freq.put("סקה", 13);
    freq.put("סקת", 19);
    freq.put("סקר", 15);
    freq.put("סקס", 35);
    freq.put("סקנ", 19);
    freq.put("ני ", 3188);
    freq.put(" לק", 292);
    freq.put(" לצ", 215);
    freq.put(" לפ", 497);
    freq.put(" לע", 483);
    freq.put(" לס", 177);
    freq.put(" לנ", 225);
    freq.put(" לת", 156);
    freq.put(" לש", 455);
    freq.put(" לר", 266);
    freq.put(" לח", 421);
    freq.put(" לז", 121);
    freq.put(" לו", 421);
    freq.put(" לה", 1575);
    freq.put("קט ", 69);
    freq.put(" לג", 163);
    freq.put(" לב", 499);
    freq.put(" לא", 2981);
    freq.put(" למ", 867);
    freq.put(" לל", 195);
    freq.put(" לכ", 378);
    freq.put(" לך", 479);
    freq.put(" לי", 1930);
    freq.put(" לט", 83);
    freq.put(" צ ", 52);
    freq.put(" סד", 32);
    freq.put("לכת", 193);
    freq.put("לכנ", 8);
    freq.put("לכס", 6);
    freq.put("הב ", 174);
    freq.put("לכמ", 8);
    freq.put("לכן", 32);
    freq.put("לכל", 97);
    freq.put("לכם", 187);
    freq.put("לכך", 19);
    freq.put("יה ", 1345);
    freq.put("לכי", 66);
    freq.put("לכה", 18);
    freq.put("לכו", 93);
    freq.put("לכא", 8);
    freq.put("לכב", 13);
    freq.put("ד?", 6);
    freq.put("פאק", 36);
    freq.put("פאס", 7);
    freq.put("פאנ", 7);
    freq.put("ד ", 2784);
    freq.put("פאר", 22);
    freq.put("פאו", 13);
    freq.put("פאד", 6);
    freq.put("פאן", 6);
    freq.put("פאל", 16);
    freq.put("פאי", 11);
    freq.put("בסר", 21);
    freq.put("םםם", 195);
    freq.put("זהב", 17);
    freq.put("זהו", 56);
    freq.put("זהה", 35);
    freq.put("זהי", 14);
    freq.put("בסד", 54);
    freq.put("זהר", 22);
    freq.put("פרצ", 31);
    freq.put("כזה", 88);
    freq.put("כזו", 6);
    freq.put("כזא", 25);
    freq.put("כזב", 31);
    freq.put("בסט", 21);
    freq.put("עפו", 7);
    freq.put("בסך", 8);
    freq.put("נס ", 150);
    freq.put("עפת", 7);
    freq.put("כזר", 7);
    freq.put("ות״", 8);
    freq.put("ותר", 549);
    freq.put("ותש", 8);
    freq.put("ותת", 46);
    freq.put("ותפ", 18);
    freq.put("ותק", 31);
    freq.put("ותנ", 50);
    freq.put("ותע", 6);
    freq.put("ותף", 6);
    freq.put("ותל", 8);
    freq.put("ותם", 76);
    freq.put("ותמ", 17);
    freq.put("ותן", 30);
    freq.put("ותי", 479);
    freq.put("ותך", 303);
    freq.put("ותכ", 27);
    freq.put("ותה", 183);
    freq.put("ותו", 256);
    freq.put("ותז", 6);
    freq.put("ותח", 30);
    freq.put("ותב", 29);
    freq.put("ותג", 6);
    freq.put("עע ", 10);
    freq.put("😬?", 7);
    freq.put("״", 291);
    freq.put("ف", 6);
    freq.put("במה", 53);
    freq.put("במו", 47);
    freq.put("במז", 8);
    freq.put("במח", 38);
    freq.put("במא", 17);
    freq.put("במב", 31);
    freq.put("במג", 6);
    freq.put("במד", 23);
    freq.put("במל", 21);
    freq.put("פג ", 8);
    freq.put("במט", 10);
    freq.put("במי", 90);
    freq.put("במכ", 14);
    freq.put("במצ", 22);
    freq.put("במק", 108);
    freq.put("במנ", 6);
    freq.put("במס", 32);
    freq.put("במע", 25);
    freq.put("שף ", 16);
    freq.put("במר", 25);
    freq.put("במש", 34);
    freq.put("במת", 22);
    freq.put("פפי", 8);
    freq.put("הרת", 12);
    freq.put("הרש", 38);
    freq.put("הרצ", 40);
    freq.put("הרפ", 8);
    freq.put("הרע", 16);
    freq.put("הרס", 11);
    freq.put("הרמ", 8);
    freq.put("הרכ", 26);
    freq.put("הרי", 86);
    freq.put("הרט", 9);
    freq.put("הרח", 20);
    freq.put("הרו", 116);
    freq.put("הרד", 6);
    freq.put("הרג", 137);
    freq.put("הרב", 154);
    freq.put("הרא", 123);
    freq.put("רץ ", 89);
    freq.put("אד ", 27);
    freq.put("️", 25);
    freq.put("גמר", 101);
    freq.put("קק ", 15);
    freq.put("גמי", 18);
    freq.put("גמד", 8);
    freq.put("גמו", 13);
    freq.put("גמה", 8);
    freq.put("אור", 160);
    freq.put("אוש", 68);
    freq.put("אות", 1390);
    freq.put("אופ", 102);
    freq.put("אוצ", 14);
    freq.put("אוק", 24);
    freq.put("אונ", 45);
    freq.put("אוס", 39);
    freq.put("תלת", 6);
    freq.put("💏?", 96);
    freq.put("מ", 22265);
    freq.put("קסמ", 6);
    freq.put("קסם", 12);
    freq.put("קסי", 74);
    freq.put("קסט", 17);
    freq.put("קסו", 9);
    freq.put("תלו", 33);
    freq.put("תלה", 16);
    freq.put("תלח", 6);
    freq.put("און", 46);
    freq.put("תלב", 22);
    freq.put("תלא", 6);
    freq.put("אוכ", 87);
    freq.put("אוה", 398);
    freq.put("אוו", 131);
    freq.put("אוז", 34);
    freq.put("אוח", 22);
    freq.put("תלי", 13);
    freq.put("תלט", 9);
    freq.put("אוג", 22);
    freq.put("תלך", 10);
    freq.put("רקל", 6);
    freq.put("רקט", 18);
    freq.put("רקי", 29);
    freq.put("רקה", 7);
    freq.put("רקו", 31);
    freq.put("רקד", 12);
    freq.put("רקא", 7);
    freq.put("יק ", 317);
    freq.put("רקת", 10);
    freq.put("רקר", 11);
    freq.put("רקש", 21);
    freq.put("רקע", 24);
    freq.put("רקס", 9);
    freq.put("טמב", 21);
    freq.put("טמו", 6);
    freq.put("טמה", 8);
    freq.put("טמי", 6);
    freq.put("טמט", 8);
    freq.put("בק ", 44);
    freq.put("טמפ", 7);
    freq.put("טמק", 7);
    freq.put("טמת", 7);
    freq.put("פת ", 141);
    freq.put("צבת", 8);
    freq.put("צבע", 40);
    freq.put("צבנ", 47);
    freq.put("שסי", 6);
    freq.put("שסו", 6);
    freq.put("צבי", 66);
    freq.put("צבן", 35);
    freq.put("צבא", 24);
    freq.put("צבו", 20);
    freq.put("נכ ", 7);
    freq.put("עט ", 69);
    freq.put(" ג׳", 26);
    freq.put("אבנ", 10);
    freq.put("אבק", 25);
    freq.put(" ר ", 48);
    freq.put("אבת", 7);
    freq.put(" תל", 101);
    freq.put(" תן", 18);
    freq.put(" תמ", 357);
    freq.put(" תי", 121);
    freq.put(" תט", 6);
    freq.put(" תכ", 47);
    freq.put(" תו", 309);
    freq.put(" תה", 77);
    freq.put(" תח", 128);
    freq.put(" תז", 34);
    freq.put(" תב", 87);
    freq.put(" תא", 98);
    freq.put(" תד", 35);
    freq.put(" תג", 110);
    freq.put("הד ", 7);
    freq.put(" תש", 117);
    freq.put(" תר", 128);
    freq.put(" תת", 101);
    freq.put(" תפ", 91);
    freq.put(" תק", 131);
    freq.put(" תצ", 36);
    freq.put(" תס", 37);
    freq.put(" תנ", 70);
    freq.put(" תע", 129);
    freq.put("ב ", 2548);
    freq.put("האמ", 83);
    freq.put("טלפ", 46);
    freq.put("לרק", 7);
    freq.put("לרצ", 17);
    freq.put("לרע", 6);
    freq.put("וּ", 11);
    freq.put("לפב", 9);
    freq.put("לפא", 6);
    freq.put("לפח", 49);
    freq.put("לפו", 65);
    freq.put("לפה", 12);
    freq.put("לפי", 121);
    freq.put("לפן", 8);
    freq.put("לפל", 19);
    freq.put("אבא", 91);
    freq.put("נף ", 8);
    freq.put("לפע", 52);
    freq.put("לפס", 20);
    freq.put("אבד", 35);
    freq.put("לרש", 13);
    freq.put("לפת", 39);
    freq.put("לפר", 44);
    freq.put("מט", 288);
    freq.put("מי", 2892);
    freq.put("מך", 76);
    freq.put("מכ", 491);
    freq.put("מל", 490);
    freq.put("מם", 103);
    freq.put("ממ", 571);
    freq.put("מן", 408);
    freq.put("מא", 1044);
    freq.put("מב", 566);
    freq.put("מג", 260);
    freq.put("מד", 635);
    freq.put("מה", 2638);
    freq.put("מו", 2640);
    freq.put("מז", 354);
    freq.put("מח", 844);
    freq.put("יך ", 701);
    freq.put("אבט", 14);
    freq.put("וש", 1360);
    freq.put("ור", 2863);
    freq.put("ות", 6366);
    freq.put("וץ", 280);
    freq.put("ופ", 904);
    freq.put("וק", 1276);
    freq.put("וצ", 833);
    freq.put("וס", 703);
    freq.put("ונ", 1659);
    freq.put("וף", 372);
    freq.put("וע", 937);
    freq.put("ום", 1462);
    freq.put("ול", 2967);
    freq.put("ון", 1585);
    freq.put("ומ", 1432);
    freq.put("וי", 1182);
    freq.put("וט", 588);
    freq.put("וכ", 647);
    freq.put("וך", 219);
    freq.put("וצ ", 10);
    freq.put("וה", 1175);
    freq.put("וח", 830);
    freq.put("וז", 490);
    freq.put("וב", 2157);
    freq.put("וא", 2328);
    freq.put("וד", 2023);
    freq.put("וג", 567);
    freq.put("מר", 1236);
    freq.put("מש", 1408);
    freq.put("מת", 1476);
    freq.put("ال", 12);
    freq.put("מנ", 636);
    freq.put("מס", 589);
    freq.put("מע", 820);
    freq.put("אבן", 6);
    freq.put("מפ", 382);
    freq.put("מץ", 15);
    freq.put("מצ", 724);
    freq.put("מק", 529);
    freq.put("לרכ", 9);
    freq.put("לרי", 31);
    freq.put("לרט", 9);
    freq.put(" י ", 62);
    freq.put("צב ", 102);
    freq.put("פתא", 45);
    freq.put("פתו", 37);
    freq.put("פתח", 89);
    freq.put("פתי", 83);
    freq.put("פתל", 6);
    freq.put("בקת", 12);
    freq.put("בקש", 98);
    freq.put("בקר", 55);
    freq.put("בקצ", 10);
    freq.put("בקנ", 9);
    freq.put("בקל", 12);
    freq.put("בקי", 38);
    freq.put("בקט", 23);
    freq.put("בקו", 42);
    freq.put("בקה", 8);
    freq.put("בקב", 22);
    freq.put("פתע", 32);
    freq.put("פתק", 8);
    freq.put("פתר", 9);
    freq.put("ללק", 6);
    freq.put("יקח", 13);
    freq.put("יקו", 181);
    freq.put("יקה", 182);
    freq.put("יקב", 14);
    freq.put("יקא", 29);
    freq.put("יקן", 6);
    freq.put("יקל", 16);
    freq.put("יקי", 117);
    freq.put("יקט", 28);
    freq.put("יקק", 7);
    freq.put("יקצ", 21);
    freq.put("יקס", 24);
    freq.put("יקנ", 16);
    freq.put("יקת", 13);
    freq.put("יקש", 21);
    freq.put("יקר", 145);
    freq.put("רק ", 513);
    freq.put("תל ", 66);
    freq.put("או ", 520);
    freq.put("חל ", 24);
    freq.put("קס ", 99);
    freq.put("גאד", 9);
    freq.put("גאו", 33);
    freq.put("גאה", 12);
    freq.put("גאי", 11);
    freq.put("גאל", 13);
    freq.put("אדר", 10);
    freq.put("תמצ", 13);
    freq.put("תמש", 48);
    freq.put("תמר", 18);
    freq.put("קקק", 39);
    freq.put("קקי", 16);
    freq.put("אדי", 39);
    freq.put("תמח", 6);
    freq.put("תמו", 304);
    freq.put("תמה", 7);
    freq.put("תמכ", 6);
    freq.put("תמי", 198);
    freq.put("תמט", 27);
    freq.put("תמן", 13);
    freq.put("אדו", 46);
    freq.put("ויל", 26);
    freq.put("ا ", 6);
    freq.put("הר ", 65);
    freq.put("יץ ", 167);
    freq.put("ןוי", 10);
    freq.put("ו?", 15);
    freq.put("הכב", 26);
    freq.put("ענו", 43);
    freq.put("ענה", 14);
    freq.put("עני", 176);
    freq.put("ענן", 12);
    freq.put("וצי", 215);
    freq.put("וצל", 15);
    freq.put("וצמ", 12);
    freq.put("וצא", 129);
    freq.put("וצד", 6);
    freq.put("וצה", 293);
    freq.put("ו ", 5418);
    freq.put("וצח", 10);
    freq.put("וצר", 48);
    freq.put("וצת", 10);
    freq.put("וצע", 13);
    freq.put("וצץ", 6);
    freq.put("וצצ", 6);
    freq.put("עננ", 11);
    freq.put("ענע", 14);
    freq.put("ענק", 21);
    freq.put("הלת", 10);
    freq.put("מ ", 138);
    freq.put("ענת", 7);
    freq.put("נם ", 37);
    freq.put("ב״", 9);
    freq.put("בס", 370);
    freq.put("בנ", 653);
    freq.put("בע", 805);
    freq.put("בפ", 293);
    freq.put("בק", 386);
    freq.put("בצ", 183);
    freq.put("בש", 559);
    freq.put("בר", 2590);
    freq.put("בת", 1100);
    freq.put("בב", 477);
    freq.put("בא", 1211);
    freq.put("בד", 596);
    freq.put("בג", 280);
    freq.put("בו", 2162);
    freq.put("בה", 1020);
    freq.put("בח", 617);
    freq.put("בז", 134);
    freq.put("בי", 2860);
    freq.put("בט", 441);
    freq.put("בכ", 402);
    freq.put("בך", 53);
    freq.put("בל", 1344);
    freq.put("בן", 270);
    freq.put("במ", 642);
    freq.put("הדמ", 14);
    freq.put("הדל", 13);
    freq.put("הדי", 53);
    freq.put("הדו", 45);
    freq.put("הדג", 14);
    freq.put("הדב", 108);
    freq.put("הדר", 67);
    freq.put("הדק", 10);
    freq.put("הדפ", 11);
    freq.put("הדע", 6);
    freq.put("הדף", 6);
    freq.put("הלח", 13);
    freq.put(" ת ", 51);
    freq.put(" רכ", 30);
    freq.put(" רי", 114);
    freq.put(" רט", 19);
    freq.put(" רמ", 29);
    freq.put(" רד", 10);
    freq.put(" רג", 129);
    freq.put(" רב", 114);
    freq.put("הלה", 23);
    freq.put(" רח", 31);
    freq.put(" רז", 21);
    freq.put(" רו", 636);
    freq.put(" רה", 10);
    freq.put("הלכ", 55);
    freq.put("הלי", 84);
    freq.put(" רש", 51);
    freq.put(" רע", 117);
    freq.put(" רק", 420);
    freq.put(" רצ", 88);
    freq.put(" רץ", 6);
    freq.put(" רפ", 29);
    freq.put("סעי", 9);
    freq.put("ורך", 28);
    freq.put("דל ", 59);
    freq.put("נכנ", 59);
    freq.put("נכת", 6);
    freq.put("נכש", 9);
    freq.put("נכו", 133);
    freq.put("נכי", 8);
    freq.put("לחמ", 50);
    freq.put("רכת", 42);
    freq.put("רכש", 7);
    freq.put("　 ", 17);
    freq.put("דס ", 14);
    freq.put("נץ ", 6);
    freq.put("ערס", 21);
    freq.put("רכי", 64);
    freq.put("רכב", 55);
    freq.put("רכז", 47);
    freq.put("רכה", 24);
    freq.put("רכו", 27);
    freq.put("כל ", 1082);
    freq.put("יט ", 117);
    freq.put("טגר", 23);
    freq.put("ופ ", 43);
    freq.put("ש״", 8);
    freq.put("שש", 216);
    freq.put("צוק", 8);
    freq.put("צופ", 25);
    freq.put("שת", 684);
    freq.put("צוע", 60);
    freq.put("צוף", 26);
    freq.put("צונ", 22);
    freq.put("שס", 25);
    freq.put("שנ", 874);
    freq.put("שף", 17);
    freq.put("שע", 537);
    freq.put("צות", 74);
    freq.put("שפ", 293);
    freq.put("שק", 358);
    freq.put("שצ", 54);
    freq.put("שי", 2836);
    freq.put("צוח", 33);
    freq.put("שכ", 375);
    freq.put("שך", 50);
    freq.put("שם", 278);
    freq.put("של", 3598);
    freq.put("שן", 67);
    freq.put("שמ", 1103);
    freq.put("צומ", 23);
    freq.put("שא", 1445);
    freq.put("שד", 94);
    freq.put("שג", 130);
    freq.put("שו", 2052);
    freq.put("שה", 1989);
    freq.put("שח", 321);
    freq.put("צוי", 27);
    freq.put("צח ", 56);
    freq.put("זלז", 9);
    freq.put("זלת", 6);
    freq.put("שק ", 56);
    freq.put("ועה", 81);
    freq.put("ועו", 71);
    freq.put("ועז", 7);
    freq.put(" 　 ", 12);
    freq.put("ועד", 81);
    freq.put("ועל", 55);
    freq.put("ועם", 21);
    freq.put("ועמ", 14);
    freq.put("כמע", 40);
    freq.put("ועי", 79);
    freq.put("ועכ", 8);
    freq.put("ימר", 10);
    freq.put("ימש", 13);
    freq.put("ימת", 36);
    freq.put("ימפ", 20);
    freq.put("ימצ", 15);
    freq.put("ימנ", 58);
    freq.put("ימל", 12);
    freq.put("ומא", 23);
    freq.put("ימן", 26);
    freq.put("ימט", 9);
    freq.put("ימי", 206);
    freq.put("ימכ", 10);
    freq.put("ימה", 120);
    freq.put("ימו", 187);
    freq.put("ימח", 8);
    freq.put("ימא", 12);
    freq.put("ומג", 12);
    freq.put("ועצ", 20);
    freq.put("ועק", 22);
    freq.put("וענ", 11);
    freq.put("ועס", 9);
    freq.put("כמי", 9);
    freq.put("כמה", 268);
    freq.put("כמו", 351);
    freq.put("וער", 68);
    freq.put("ועש", 6);
    freq.put("ועת", 13);
    freq.put("רי ", 581);
    freq.put("נקה", 15);
    freq.put("נקו", 38);
    freq.put("נקב", 10);
    freq.put("נקל", 6);
    freq.put("נקי", 29);
    freq.put("ומט", 44);
    freq.put("ערו", 72);
    freq.put("נקנ", 12);
    freq.put("נקר", 28);
    freq.put("תך ", 303);
    freq.put("בנה", 47);
    freq.put("אח ", 62);
    freq.put("ָ", 9);
    freq.put("מע ", 68);
    freq.put("גל ", 130);
    freq.put("קף ", 24);
    freq.put("", 11);
    freq.put("מטו", 73);
    freq.put("מטה", 17);
    freq.put("מטב", 21);
    freq.put("מטם", 11);
    freq.put("מטמ", 12);
    freq.put("מטי", 54);
    freq.put("מטע", 22);
    freq.put("מטר", 52);
    freq.put("אך ", 26);
    freq.put("חשו", 121);
    freq.put("חשד", 15);
    freq.put("חשב", 147);
    freq.put("חשמ", 19);
    freq.put("חשי", 21);
    freq.put("חשק", 21);
    freq.put("לני", 49);
    freq.put("לנט", 7);
    freq.put("לנו", 267);
    freq.put("לנה", 10);
    freq.put("לנד", 28);
    freq.put("أ", 6);
    freq.put("לנת", 13);
    freq.put("לנש", 15);
    freq.put("לנק", 8);
    freq.put("לנצ", 15);
    freq.put("לנס", 19);
    freq.put("בשם", 23);
    freq.put("בשל", 30);
    freq.put("בשמ", 16);
    freq.put("בשי", 73);
    freq.put("בשכ", 13);
    freq.put("בשו", 39);
    freq.put("בשב", 155);
    freq.put("בשד", 6);
    freq.put("בשר", 18);
    freq.put("בשת", 24);
    freq.put("בשפ", 8);
    freq.put("בשק", 19);
    freq.put("בשנ", 47);
    freq.put("בשע", 35);
    freq.put("פנק", 9);
    freq.put("פנס", 8);
    freq.put("הפכ", 24);
    freq.put("הפך", 20);
    freq.put("הפי", 94);
    freq.put("הפל", 36);
    freq.put("הפג", 23);
    freq.put("הפח", 16);
    freq.put("נן ", 45);
    freq.put("הפה", 10);
    freq.put("הפת", 31);
    freq.put("הפש", 9);
    freq.put("הפר", 90);
    freq.put("הפע", 48);
    freq.put("הפס", 78);
    freq.put("הפנ", 28);
    freq.put("הפק", 18);
    freq.put("הפצ", 9);
    freq.put("פנו", 35);
    freq.put("פנה", 20);
    freq.put("חגי", 17);
    freq.put("פני", 300);
    freq.put("פנט", 8);
    freq.put("מך ", 65);
    freq.put("מס ", 22);
    freq.put("בבנ", 13);
    freq.put("מנש", 15);
    freq.put("מנת", 42);
    freq.put("מנק", 15);
    freq.put("מנצ", 16);
    freq.put("מנס", 50);
    freq.put("מנע", 17);
    freq.put("גדר", 14);
    freq.put("מנם", 9);
    freq.put("מני", 185);
    freq.put("מנט", 15);
    freq.put("מנכ", 11);
    freq.put("מנו", 129);
    freq.put("מנה", 89);
    freq.put("מנח", 13);
    freq.put("מנג", 10);
    freq.put("נט ", 85);
    freq.put("איר", 161);
    freq.put("איש", 153);
    freq.put("אית", 352);
    freq.put("אינ", 153);
    freq.put("איס", 19);
    freq.put("איפ", 115);
    freq.put("איט", 22);
    freq.put("איי", 209);
    freq.put("איך", 250);
    freq.put("איכ", 60);
    freq.put("איל", 124);
    freq.put("אים", 233);
    freq.put("אימ", 49);
    freq.put("אין", 462);
    freq.put("תטי", 8);
    freq.put("איב", 28);
    freq.put("איג", 10);
    freq.put("איד", 18);
    freq.put("איה", 19);
    freq.put("בלל", 9);
    freq.put("איז", 330);
    freq.put("איח", 22);
    freq.put("מעת", 51);
    freq.put("מעש", 26);
    freq.put("מער", 91);
    freq.put("מענ", 89);
    freq.put("מעצ", 70);
    freq.put("בלח", 7);
    freq.put("בלה", 35);
    freq.put("גלע", 11);
    freq.put("גלל", 98);
    freq.put("בלו", 111);
    freq.put("גלי", 97);
    freq.put("גלו", 42);
    freq.put("גלה", 17);
    freq.put("גלג", 18);
    freq.put("מעכ", 8);
    freq.put("מעי", 50);
    freq.put("מעט", 75);
    freq.put("מעמ", 12);
    freq.put("מעל", 65);
    freq.put("מעד", 28);
    freq.put("מעג", 8);
    freq.put("מעב", 27);
    freq.put("בלב", 46);
    freq.put("מעו", 129);
    freq.put("בלת", 83);
    freq.put("אחת", 132);
    freq.put("אחר", 488);
    freq.put("אחז", 16);
    freq.put("אחח", 6);
    freq.put("⃣", 9);
    freq.put("אחו", 123);
    freq.put("אחד", 301);
    freq.put("אחמ", 7);
    freq.put("אחל", 50);
    freq.put("בלש", 8);
    freq.put("אחי", 61);
    freq.put("תךך", 14);
    freq.put("רינ", 35);
    freq.put("ריס", 40);
    freq.put("ריע", 16);
    freq.put("ריפ", 28);
    freq.put("ריץ", 7);
    freq.put("ריצ", 28);
    freq.put("ריק", 89);
    freq.put("ריר", 22);
    freq.put("ריש", 22);
    freq.put("רית", 103);
    freq.put("בלנ", 18);
    freq.put("גדל", 22);
    freq.put("דף ", 30);
    freq.put("ריא", 87);
    freq.put("ריב", 60);
    freq.put("ריג", 11);
    freq.put("ריד", 93);
    freq.put("ריה", 114);
    freq.put("ריו", 89);
    freq.put("נק ", 73);
    freq.put("ריח", 58);
    freq.put("ריט", 67);
    freq.put("ריי", 165);
    freq.put("ריך", 199);
    freq.put("ריכ", 119);
    freq.put("ריל", 11);
    freq.put("רים", 1048);
    freq.put("רימ", 26);
    freq.put("רין", 33);
    freq.put("טול", 19);
    freq.put("גדה", 7);
    freq.put("ימ ", 20);
    freq.put("טאו", 20);
    freq.put("טאר", 13);
    freq.put("מקצ", 21);
    freq.put("טאפ", 12);
    freq.put("וע ", 334);
    freq.put("מקנ", 20);
    freq.put("מקס", 34);
    freq.put("שקו", 40);
    freq.put("שקה", 7);
    freq.put("שקד", 19);
    freq.put("צחת", 15);
    freq.put("שקל", 61);
    freq.put("שקי", 30);
    freq.put("שקט", 40);
    freq.put("מקר", 61);
    freq.put("שקפ", 11);
    freq.put("צחי", 92);
    freq.put("צחו", 65);
    freq.put("שקש", 13);
    freq.put("שקר", 47);
    freq.put("זמה", 8);
    freq.put("זמן", 210);
    freq.put("זמי", 24);
    freq.put("אלפ", 24);
    freq.put("צו ", 41);
    freq.put("ש ", 2104);
    freq.put("אגת", 6);
    freq.put("מקד", 21);
    freq.put("זמנ", 50);
    freq.put("זמר", 19);
    freq.put("ופג", 8);
    freq.put("ופא", 25);
    freq.put("ופז", 8);
    freq.put("ופח", 6);
    freq.put("ופה", 83);
    freq.put("ופו", 62);
    freq.put("ופך", 13);
    freq.put("ופכ", 7);
    freq.put("ופט", 29);
    freq.put("ופי", 196);
    freq.put("ופן", 18);
    freq.put("ופל", 30);
    freq.put("מקי", 12);
    freq.put("יטת", 14);
    freq.put("יטר", 206);
    freq.put("יטנ", 9);
    freq.put("יטי", 98);
    freq.put("יטמ", 13);
    freq.put("יטל", 47);
    freq.put("יטד", 7);
    freq.put("יטב", 10);
    freq.put("יטח", 13);
    freq.put("יטה", 76);
    freq.put("יטו", 86);
    freq.put("ופע", 48);
    freq.put("כלו", 107);
    freq.put("ופנ", 42);
    freq.put("ופס", 26);
    freq.put("ופצ", 16);
    freq.put("ופק", 14);
    freq.put("ופפ", 7);
    freq.put("ופת", 30);
    freq.put("ופר", 91);
    freq.put("ופש", 84);
    freq.put("כלי", 56);
    freq.put("כלכ", 28);
    freq.put("לשנ", 55);
    freq.put("לשע", 13);
    freq.put("אי ", 347);
    freq.put("טז", 7);
    freq.put("לשת", 28);
    freq.put("אגב", 20);
    freq.put("לשה", 18);
    freq.put("לשח", 25);
    freq.put("לשל", 70);
    freq.put("לשם", 22);
    freq.put("לשמ", 63);
    freq.put("לשט", 11);
    freq.put("לשי", 67);
    freq.put("", 7);
    freq.put("ע", 12803);
    freq.put("״כ ", 9);
    freq.put("לצו", 26);
    freq.put("לצה", 38);
    freq.put("לצח", 20);
    freq.put("לצא", 41);
    freq.put("לצד", 7);
    freq.put("לצל", 20);
    freq.put("לצי", 76);
    freq.put("בש ", 29);
    freq.put("לצפ", 25);
    freq.put("לצע", 19);
    freq.put("לצר", 22);
    freq.put("לצת", 7);
    freq.put("פצי", 23);
    freq.put("פצו", 14);
    freq.put("התב", 24);
    freq.put("התא", 63);
    freq.put("התג", 46);
    freq.put("התו", 40);
    freq.put("התה", 9);
    freq.put("התח", 169);
    freq.put("התי", 42);
    freq.put("התכ", 40);
    freq.put("התל", 20);
    freq.put("התמ", 51);
    freq.put("התנ", 57);
    freq.put("התע", 53);
    freq.put("התפ", 37);
    freq.put("התק", 94);
    freq.put("חש ", 9);
    freq.put("התש", 12);
    freq.put("התר", 49);
    freq.put("פצצ", 13);
    freq.put("פצע", 13);
    freq.put("מט ", 8);
    freq.put("ומנ", 37);
    freq.put("ומס", 22);
    freq.put("ומע", 55);
    freq.put("ערת", 33);
    freq.put("ומפ", 18);
    freq.put("ומץ", 7);
    freq.put("ומצ", 14);
    freq.put("ומק", 18);
    freq.put("ומר", 378);
    freq.put("ומש", 30);
    freq.put("ומת", 68);
    freq.put("ערי", 75);
    freq.put("ומב", 23);
    freq.put("ערכ", 59);
    freq.put("ומד", 68);
    freq.put("ומה", 127);
    freq.put("ומו", 158);
    freq.put("ומז", 13);
    freq.put("ומח", 23);
    freq.put("ערב", 159);
    freq.put("ומי", 196);
    freq.put("ומך", 7);
    freq.put("ומכ", 26);
    freq.put("ומל", 24);
    freq.put("ערה", 22);
    freq.put("וממ", 12);
    freq.put("ומן", 22);
    freq.put("דקי", 14);
    freq.put("דקל", 6);
    freq.put("דקו", 53);
    freq.put("דקה", 36);
    freq.put("אנס", 23);
    freq.put("אנפ", 29);
    freq.put("אנש", 303);
    freq.put("אנר", 17);
    freq.put("אנד", 25);
    freq.put("אנג", 26);
    freq.put("אנא", 16);
    freq.put("אנח", 148);
    freq.put("אנו", 47);
    freq.put("אנה", 15);
    freq.put("אני", 2508);
    freq.put("אנט", 28);
    freq.put("אנל", 7);
    freq.put("דקת", 22);
    freq.put("👎?", 24);
    freq.put("?👊", 6);
    freq.put("?👎", 12);
    freq.put("?👌", 18);
    freq.put("טוב", 693);
    freq.put("😘 ", 7);
    freq.put("😘?", 27);
    freq.put("נש ", 6);
    freq.put("עת ", 362);
    freq.put("ד", 10653);
    freq.put("זע ", 7);
    freq.put("מממ", 33);
    freq.put("ממל", 21);
    freq.put("ממכ", 7);
    freq.put("ממך", 31);
    freq.put("ממי", 20);
    freq.put("ממח", 8);
    freq.put("ממו", 28);
    freq.put("ממה", 22);
    freq.put("ממת", 31);
    freq.put("ממש", 212);
    freq.put("ממר", 6);
    freq.put("ממק", 6);
    freq.put("ממצ", 7);
    freq.put("ממנ", 88);
    freq.put("?💏", 96);
    freq.put("יל ", 468);
    freq.put("הנח", 13);
    freq.put("הנו", 48);
    freq.put("הנה", 66);
    freq.put("הנד", 7);
    freq.put("הנג", 6);
    freq.put("הנב", 7);
    freq.put("הנא", 17);
    freq.put("הנמ", 7);
    freq.put("הנכ", 16);
    freq.put("הני", 41);
    freq.put("יס ", 126);
    freq.put("הנק", 8);
    freq.put("הנפ", 11);
    freq.put("הנע", 11);
    freq.put("הנס", 15);
    freq.put("טה ", 166);
    freq.put("הנת", 12);
    freq.put("הנש", 33);
    freq.put("הנר", 6);
    freq.put("רם ", 77);
    freq.put("חה ", 342);
    freq.put("לס ", 26);
    freq.put("כסף", 36);
    freq.put("כספ", 14);
    freq.put("קשו", 67);
    freq.put("קשה", 143);
    freq.put("קשב", 8);
    freq.put("קשן", 8);
    freq.put("קשי", 52);
    freq.put("מפר", 38);
    freq.put("מפת", 18);
    freq.put("לאז", 9);
    freq.put("מפס", 24);
    freq.put("מפנ", 14);
    freq.put("מפע", 17);
    freq.put("מפק", 10);
    freq.put("מפי", 33);
    freq.put("לאה", 46);
    freq.put("מפל", 33);
    freq.put("מפב", 13);
    freq.put("מפג", 66);
    freq.put("מפו", 26);
    freq.put("מפה", 26);
    freq.put("מפח", 40);
    freq.put("קשת", 25);
    freq.put("קשר", 112);
    freq.put("תהר", 7);
    freq.put("תהפ", 6);
    freq.put("תהנ", 11);
    freq.put("תהל", 7);
    freq.put("תהי", 77);
    freq.put("לאש", 12);
    freq.put("תהה", 16);
    freq.put("ת", 25463);
    freq.put("צץ", 10);
    freq.put("?🙏", 6);
    freq.put("חזר", 93);
    freq.put("חזק", 49);
    freq.put("חזי", 66);
    freq.put("גט ", 9);
    freq.put("חזה", 11);
    freq.put("חזו", 84);
    freq.put("לז", 138);
    freq.put("לח", 790);
    freq.put("לה", 3182);
    freq.put("לו", 2118);
    freq.put("לג", 259);
    freq.put("לד", 632);
    freq.put("לא", 3798);
    freq.put("צטל", 7);
    freq.put("למ", 1194);
    freq.put("לן", 54);
    freq.put("לל", 687);
    freq.put("לם", 448);
    freq.put("לך", 945);
    freq.put("לכ", 762);
    freq.put("?😍", 9);
    freq.put("לי", 5387);
    freq.put("ציג", 15);
    freq.put("ציד", 14);
    freq.put("ציא", 95);
    freq.put("ציב", 51);
    freq.put("ציה", 52);
    freq.put("ציו", 235);
    freq.put("צה", 521);
    freq.put("ציי", 174);
    freq.put("ציל", 46);
    freq.put("צים", 235);
    freq.put("ציע", 26);
    freq.put("?😡", 29);
    freq.put("ציצ", 30);
    freq.put("ציק", 13);
    freq.put("ציפ", 40);
    freq.put("?😤", 7);
    freq.put("צית", 49);
    freq.put("ציר", 22);
    freq.put("?😭", 39);
    freq.put("לצ", 323);
    freq.put("לק", 512);
    freq.put("לפ", 656);
    freq.put("לץ", 17);
    freq.put("לע", 575);
    freq.put("לף", 59);
    freq.put("לנ", 463);
    freq.put("לס", 248);
    freq.put("לת", 585);
    freq.put("לר", 340);
    freq.put("לש", 545);
    freq.put("שיפ", 26);
    freq.put("שיק", 51);
    freq.put("שיצ", 20);
    freq.put("שיס", 7);
    freq.put("שינ", 67);
    freq.put("שיע", 91);
    freq.put("שיש", 231);
    freq.put("שיר", 244);
    freq.put("שית", 115);
    freq.put("שיו", 387);
    freq.put("שיה", 86);
    freq.put("שיח", 99);
    freq.put("שיז", 10);
    freq.put("שיב", 71);
    freq.put("שיא", 39);
    freq.put("שיד", 25);
    freq.put("שיג", 38);
    freq.put("שים", 637);
    freq.put("שיל", 42);
    freq.put("שימ", 86);
    freq.put("שיי", 71);
    freq.put("שיט", 37);
    freq.put("שיכ", 59);
    freq.put("שיך", 45);
    freq.put("לע ", 10);
    freq.put("?😊", 8);
    freq.put("יגי", 78);
    freq.put("יגל", 13);
    freq.put("יגמ", 13);
    freq.put("יגא", 9);
    freq.put("יגד", 7);
    freq.put("יגה", 31);
    freq.put("יגו", 55);
    freq.put("ךךך", 65);
    freq.put("יגר", 33);
    freq.put("יגת", 12);
    freq.put("זני", 24);
    freq.put("שכנ", 41);
    freq.put("שכת", 23);
    freq.put("שכש", 8);
    freq.put("שכר", 27);
    freq.put("שכב", 35);
    freq.put("שכח", 41);
    freq.put("שכו", 74);
    freq.put("שכי", 22);
    freq.put("שכן", 18);
    freq.put("שכמ", 10);
    freq.put("שכל", 53);
    freq.put("זענ", 8);
    freq.put("זעק", 14);
    freq.put("ילח", 14);
    freq.put("ילה", 337);
    freq.put("ילו", 283);
    freq.put("ילג", 8);
    freq.put("ילד", 275);
    freq.put("ילא", 20);
    freq.put("ילב", 15);
    freq.put("ילמ", 29);
    freq.put("ילן", 9);
    freq.put("ילל", 9);
    freq.put("ילם", 6);
    freq.put("ילך", 41);
    freq.put("ילכ", 10);
    freq.put("ילט", 7);
    freq.put("ילי", 290);
    freq.put("ילק", 15);
    freq.put("ילפ", 9);
    freq.put("ילנ", 15);
    freq.put("ילת", 58);
    freq.put("ממ ", 17);
    freq.put("זעז", 6);
    freq.put("ונן", 12);
    freq.put("ונל", 13);
    freq.put("ונכ", 8);
    freq.put("ונט", 17);
    freq.put("וני", 423);
    freq.put("ונח", 9);
    freq.put("ונה", 465);
    freq.put("ונו", 226);
    freq.put("ונג", 18);
    freq.put("ונד", 40);
    freq.put("ונא", 176);
    freq.put("עק", 149);
    freq.put("ا", 70);
    freq.put("ונת", 83);
    freq.put("ונר", 18);
    freq.put("ונש", 14);
    freq.put("ונצ", 14);
    freq.put("ונק", 12);
    freq.put("ונפ", 15);
    freq.put("ונע", 17);
    freq.put("וננ", 24);
    freq.put("ונס", 36);
    freq.put("נשט", 8);
    freq.put("נשי", 401);
    freq.put("נשמ", 57);
    freq.put("נשא", 49);
    freq.put("נשב", 47);
    freq.put("נשו", 19);
    freq.put("טינ", 62);
    freq.put("צ", 5697);
    freq.put("נשר", 7);
    freq.put("נשק", 32);
    freq.put("טיר", 20);
    freq.put("בך ", 43);
    freq.put("להנ", 19);
    freq.put("טיב", 46);
    freq.put("👌?", 50);
    freq.put("👌 ", 19);
    freq.put("₪ ", 9);
    freq.put("טיו", 50);
    freq.put("טיז", 6);
    freq.put("טיח", 41);
    freq.put("דק ", 33);
    freq.put("ער ", 113);
    freq.put("לעס", 6);
    freq.put("לענ", 14);
    freq.put("לעק", 15);
    freq.put("לעצ", 62);
    freq.put("לעש", 140);
    freq.put("לער", 16);
    freq.put("לעת", 9);
    freq.put("יג ", 33);
    freq.put("לעב", 78);
    freq.put("לעד", 55);
    freq.put("לעו", 71);
    freq.put("לעז", 35);
    freq.put("לעי", 20);
    freq.put("לעל", 22);
    freq.put("לעמ", 12);
    freq.put("שי ", 230);
    freq.put("פעת", 12);
    freq.put("הצל", 78);
    freq.put("הצמ", 7);
    freq.put("הצי", 126);
    freq.put("הצט", 21);
    freq.put("הצו", 20);
    freq.put("הצה", 6);
    freq.put("הצב", 29);
    freq.put("הצד", 18);
    freq.put("הצג", 15);
    freq.put("צי ", 133);
    freq.put("הצפ", 13);
    freq.put("הצע", 47);
    freq.put("פעי", 28);
    freq.put("פעם", 223);
    freq.put("פעל", 18);
    freq.put("ל ", 6863);
    freq.put("פעמ", 91);
    freq.put("פעו", 32);
    freq.put("פעה", 23);
    freq.put("רן ", 69);
    freq.put("גטו", 6);
    freq.put("מצפ", 16);
    freq.put("אכז", 33);
    freq.put("מצע", 48);
    freq.put("אכו", 45);
    freq.put("אכי", 19);
    freq.put("אכן", 14);
    freq.put("אכל", 46);
    freq.put("מצר", 14);
    freq.put("מצח", 93);
    freq.put("מצו", 88);
    freq.put("מצה", 8);
    freq.put("מצד", 34);
    freq.put("אכפ", 38);
    freq.put("מצא", 102);
    freq.put("מצל", 50);
    freq.put("מצי", 131);
    freq.put("מצט", 24);
    freq.put("מפ ", 11);
    freq.put("תזכ", 25);
    freq.put("ْاْ", 13);
    freq.put("אם ", 587);
    freq.put("תזה", 12);
    freq.put("קש ", 38);
    freq.put("חהח", 6);
    freq.put("₪", 10);
    freq.put("כס ", 21);
    freq.put("ּ", 15);
    freq.put("טהו", 10);
    freq.put("טהה", 6);
    freq.put("ית ", 1318);
    freq.put("　　", 12);
    freq.put("קק", 92);
    freq.put("קצ", 218);
    freq.put("קפ", 118);
    freq.put("קף", 25);
    freq.put("קע", 68);
    freq.put("קס", 244);
    freq.put("קנ", 255);
    freq.put("קת", 189);
    freq.put("קש", 460);
    freq.put("קר", 996);
    freq.put("קח", 126);
    freq.put("קז", 6);
    freq.put("קו", 1427);
    freq.put("קה", 391);
    freq.put("קד", 193);
    freq.put("קב", 356);
    freq.put("קא", 144);
    freq.put("קן", 37);
    freq.put("קמ", 93);
    freq.put("קם", 23);
    freq.put("קל", 311);
    freq.put("צני", 23);
    freq.put("קי", 846);
    freq.put("קט", 353);
    freq.put(" ״ת", 10);
    freq.put(" ״ש", 7);
    freq.put(" ״פ", 7);
    freq.put(" ״ע", 10);
    freq.put(" ״נ", 6);
    freq.put(" ״מ", 6);
    freq.put(" ״כ", 6);
    freq.put(" ״ב", 6);
    freq.put(" ״א", 17);
    freq.put("מגי", 93);
    freq.put("מגן", 7);
    freq.put("מגמ", 6);
    freq.put("מגל", 15);
    freq.put("מגד", 9);
    freq.put("מגב", 12);
    freq.put("מגז", 6);
    freq.put("מגו", 18);
    freq.put("לחו", 68);
    freq.put("😡 ", 9);
    freq.put("د", 15);
    freq.put("מגר", 20);
    freq.put("מגע", 30);
    freq.put("מגנ", 30);
    freq.put("😡?", 43);
    freq.put("מל ", 38);
    freq.put("בדק", 17);
    freq.put("בדת", 35);
    freq.put("בדר", 81);
    freq.put("צע ", 65);
    freq.put("בדב", 11);
    freq.put("בדו", 59);
    freq.put("בדה", 30);
    freq.put("בדי", 168);
    freq.put("בדמ", 7);
    freq.put("בדל", 30);
    freq.put("העי", 82);
    freq.put("העל", 53);
    freq.put("העמ", 8);
    freq.put("העב", 51);
    freq.put("העד", 19);
    freq.put("העו", 98);
    freq.put("העש", 11);
    freq.put("הער", 70);
    freq.put("העת", 15);
    freq.put("הענ", 22);
    freq.put("העצ", 29);
    freq.put("ר״ ", 10);
    freq.put("👊?", 25);
    freq.put("לה ", 1460);
    freq.put("לה?", 7);
    freq.put("די ", 516);
    freq.put("😄?", 6);
    freq.put("ול ", 692);
    freq.put("טתי", 17);
    freq.put(" בא", 882);
    freq.put(" בב", 324);
    freq.put(" בג", 222);
    freq.put(" בד", 260);
    freq.put(" בה", 257);
    freq.put(" בו", 538);
    freq.put(" בז", 108);
    freq.put(" בח", 410);
    freq.put(" בט", 272);
    freq.put(" בי", 784);
    freq.put(" בך", 33);
    freq.put(" בכ", 333);
    freq.put(" בל", 377);
    freq.put(" במ", 590);
    freq.put(" בן", 108);
    freq.put(" ב״", 6);
    freq.put(" בנ", 335);
    freq.put(" בס", 289);
    freq.put(" בע", 492);
    freq.put(" בפ", 278);
    freq.put(" בצ", 114);
    freq.put(" בק", 200);
    freq.put(" בר", 457);
    freq.put(" בש", 460);
    freq.put(" בת", 293);
    freq.put("יזה", 320);
    freq.put("יזו", 52);
    freq.put("יזם", 6);
    freq.put("יזי", 60);
    freq.put("שן ", 61);
    freq.put("יזר", 15);
    freq.put("טר ", 224);
    freq.put("צן ", 17);
    freq.put("דכנ", 8);
    freq.put("דרד", 6);
    freq.put("אפש", 142);
    freq.put("אפר", 36);
    freq.put("רב ", 154);
    freq.put(" לד", 180);
    freq.put("אפס", 21);
    freq.put("אפל", 40);
    freq.put("אפי", 91);
    freq.put("אפו", 35);
    freq.put("אפה", 8);
    freq.put("דכו", 15);
    freq.put("דכן", 12);
    freq.put("סגו", 27);
    freq.put("?😂", 7);
    freq.put("?😁", 9);
    freq.put("לזו", 16);
    freq.put("לזה", 52);
    freq.put("לזל", 10);
    freq.put("לזי", 11);
    freq.put("לזכ", 18);
    freq.put("?😅", 6);
    freq.put("לב", 852);
    freq.put("לזר", 18);
    freq.put("סגנ", 6);
    freq.put("פע ", 14);
    freq.put("סגר", 45);
    freq.put("לט", 230);
    freq.put("️ ", 7);
    freq.put("אן ", 150);
    freq.put("להד", 11);
    freq.put("להג", 106);
    freq.put("להב", 80);
    freq.put("להא", 17);
    freq.put("להח", 38);
    freq.put("להז", 17);
    freq.put("להו", 84);
    freq.put("להה", 35);
    freq.put("להכ", 48);
    freq.put("להי", 302);
    freq.put("להט", 7);
    freq.put("להן", 28);
    freq.put("להמ", 35);
    freq.put("להם", 179);
    freq.put("להל", 23);
    freq.put("להע", 51);
    freq.put("להס", 59);
    freq.put("?😘", 17);
    freq.put("להק", 35);
    freq.put("להצ", 41);
    freq.put("להפ", 72);
    freq.put("להת", 217);
    freq.put("להש", 61);
    freq.put("להר", 79);
    freq.put("כף ", 14);
    freq.put("ל״", 7);
    freq.put("?😩", 7);
    freq.put("בד ", 128);
    freq.put("צעק", 9);
    freq.put("צעת", 23);
    freq.put("צער", 20);
    freq.put("צעד", 26);
    freq.put("?😳", 6);
    freq.put("צעו", 21);
    freq.put("צעה", 6);
    freq.put("צעי", 47);
    freq.put("?😱", 9);
    freq.put("?😰", 27);
    freq.put("מלא", 122);
    freq.put("מלג", 6);
    freq.put("מלו", 40);
    freq.put("מלה", 27);
    freq.put("מלח", 57);
    freq.put("מלי", 63);
    freq.put("מלט", 7);
    freq.put("מלכ", 25);
    freq.put("מלך", 13);
    freq.put("מלמ", 10);
    freq.put("מלץ", 12);
    freq.put("מלצ", 24);
    freq.put("ق", 8);
    freq.put("טנו", 12);
    freq.put("טנה", 42);
    freq.put(" ״ ", 23);
    freq.put("ם😂", 12);
    freq.put("ק?", 7);
    freq.put("מוז", 91);
    freq.put("ק ", 1982);
    freq.put("תגו", 37);
    freq.put("תגב", 8);
    freq.put("תגל", 10);
    freq.put("תגי", 92);
    freq.put("תגע", 82);
    freq.put("תגר", 16);
    freq.put("", 12);
    freq.put(" ️", 25);
    freq.put("רבר", 7);
    freq.put("רבת", 12);
    freq.put("רבנ", 20);
    freq.put("רבע", 43);
    freq.put("אפ ", 53);
    freq.put("רבי", 173);
    freq.put("😂?", 296);
    freq.put("רבן", 6);
    freq.put("חאה", 15);
    freq.put("רבה", 150);
    freq.put("רבו", 58);
    freq.put("😂 ", 38);
    freq.put("טרף", 13);
    freq.put("טרס", 9);
    freq.put("טרנ", 41);
    freq.put("טרק", 8);
    freq.put("טרפ", 11);
    freq.put("טרת", 13);
    freq.put("טרר", 6);
    freq.put("וך ", 204);
    freq.put("וקס", 23);
    freq.put("טרד", 8);
    freq.put("טרא", 14);
    freq.put("טרו", 54);
    freq.put("טרה", 48);
    freq.put("טרך", 10);
    freq.put("טרי", 129);
    freq.put("טרט", 8);
    freq.put("טרמ", 6);
    freq.put("טרל", 10);
    freq.put("יז ", 58);
    freq.put("יאא", 13);
    freq.put("יאב", 9);
    freq.put("יאה", 62);
    freq.put("יאו", 121);
    freq.put("יאט", 12);
    freq.put("יאי", 44);
    freq.put("יאמ", 23);
    freq.put("יאן", 15);
    freq.put("יאל", 114);
    freq.put("יאם", 13);
    freq.put("שם ", 263);
    freq.put("ח", 15922);
    freq.put(" ב ", 214);
    freq.put("יאנ", 15);
    freq.put("יאס", 6);
    freq.put("יאק", 10);
    freq.put("יאת", 14);
    freq.put("יאר", 24);
    freq.put("יאש", 8);
    freq.put("ולת", 38);
    freq.put("ולר", 46);
    freq.put("ולש", 35);
    freq.put("טת ", 44);
    freq.put("ולע", 20);
    freq.put("ולנ", 58);
    freq.put("ולס", 10);
    freq.put("ולצ", 46);
    freq.put("ולק", 25);
    freq.put("ולפ", 26);
    freq.put("צם ", 32);
    freq.put("ולך", 66);
    freq.put("ולכ", 110);
    freq.put("ולט", 19);
    freq.put("ולי", 325);
    freq.put("ולמ", 59);
    freq.put("ולן", 31);
    freq.put("ולל", 48);
    freq.put("ולם", 328);
    freq.put("ולג", 13);
    freq.put("ולד", 141);
    freq.put("ולא", 172);
    freq.put("ולב", 25);
    freq.put("ולח", 56);
    freq.put("ולה", 396);
    freq.put("ולו", 137);
    freq.put("דיף", 42);
    freq.put("דיע", 34);
    freq.put("דיס", 18);
    freq.put("דינ", 99);
    freq.put("דיק", 26);
    freq.put("דיפ", 31);
    freq.put("דית", 22);
    freq.put("דיש", 34);
    freq.put("דיר", 67);
    freq.put("אעש", 9);
    freq.put("אעא", 17);
    freq.put("דיד", 44);
    freq.put("דיג", 7);
    freq.put("דיב", 39);
    freq.put("דיא", 38);
    freq.put("דיח", 37);
    freq.put("דיו", 141);
    freq.put("דיה", 30);
    freq.put("דיכ", 15);
    freq.put("דיי", 262);
    freq.put("דין", 34);
    freq.put("דימ", 22);
    freq.put("דים", 376);
    freq.put("דיל", 18);
    freq.put("", 7);
    freq.put("לתר", 14);
    freq.put("לתת", 32);
    freq.put("בל ", 688);
    freq.put("לתע", 8);
    freq.put("לתפ", 16);
    freq.put("לתק", 15);
    freq.put("לתי", 118);
    freq.put("רד ", 99);
    freq.put("לתל", 9);
    freq.put("חג ", 34);
    freq.put("לתמ", 7);
    freq.put("לתא", 15);
    freq.put("לתו", 26);
    freq.put("לתה", 11);
    freq.put("לתח", 16);
    freq.put("קו ", 125);
    freq.put("בחש", 14);
    freq.put("בחר", 47);
    freq.put("בחצ", 11);
    freq.put("נטל", 16);
    freq.put("ף", 1177);
    freq.put("בחס", 8);
    freq.put("בחנ", 22);
    freq.put("תא ", 32);
    freq.put("בחן", 30);
    freq.put("בחמ", 8);
    freq.put("בחל", 15);
    freq.put("בחי", 195);
    freq.put("בחז", 16);
    freq.put("בחו", 179);
    freq.put("בחד", 25);
    freq.put("בחב", 14);
    freq.put("המפ", 39);
    freq.put("המק", 55);
    freq.put("המצ", 65);
    freq.put("המס", 50);
    freq.put("המנ", 35);
    freq.put("המע", 45);
    freq.put("המש", 160);
    freq.put("המר", 46);
    freq.put("המת", 58);
    freq.put("המו", 185);
    freq.put("המה", 20);
    freq.put("המח", 72);
    freq.put("המז", 27);
    freq.put("המב", 33);
    freq.put("המא", 31);
    freq.put("המד", 54);
    freq.put("המג", 11);
    freq.put("המל", 48);
    freq.put("הממ", 50);
    freq.put("המי", 118);
    freq.put("המט", 31);
    freq.put("המכ", 33);
    freq.put("■ ", 13);
    freq.put("הל ", 41);
    freq.put("״ ", 96);
    freq.put("בב ", 54);
    freq.put("קחת", 41);
    freq.put("קחו", 10);
    freq.put("קחה", 7);
    freq.put("קחי", 20);
    freq.put("ي", 30);
    freq.put("חלט", 40);
    freq.put("חלי", 86);
    freq.put("רוז", 22);
    freq.put("רוח", 74);
    freq.put("חלל", 7);
    freq.put("רוב", 127);
    freq.put("חלמ", 8);
    freq.put("רוד", 27);
    freq.put("חלא", 7);
    freq.put("חלב", 16);
    freq.put("רומ", 58);
    freq.put("רון", 169);
    freq.put("רוט", 32);
    freq.put("חלו", 109);
    freq.put("רוך", 42);
    freq.put("רוכ", 37);
    freq.put("רופ", 89);
    freq.put("חלש", 14);
    freq.put("חלת", 27);
    freq.put("רוק", 79);
    freq.put("רונ", 147);
    freq.put("רוס", 87);
    freq.put("רוע", 84);
    freq.put("רוף", 22);
    freq.put("י ", 12952);
    freq.put("חלף", 21);
    freq.put("רור", 66);
    freq.put("רוש", 105);
    freq.put("רות", 522);
    freq.put("חלק", 92);
    freq.put("תשו", 23);
    freq.put("י?", 44);
    freq.put("אתכ", 27);
    freq.put("😭 ", 8);
    freq.put("😭?", 49);
    freq.put("תשי", 14);
    freq.put("??", 12);
    freq.put("? ", 7);
    freq.put("מא ", 142);
    freq.put("ארכ", 7);
    freq.put("ארי", 83);
    freq.put("ארט", 19);
    freq.put("ארמ", 11);
    freq.put("ארל", 10);
    freq.put("וזנ", 20);
    freq.put("ארג", 35);
    freq.put("ארב", 36);
    freq.put("ארא", 8);
    freq.put("ארח", 11);
    freq.put("ארו", 112);
    freq.put("ארה", 29);
    freq.put("ארת", 17);
    freq.put("וזל", 9);
    freq.put("וזמ", 32);
    freq.put("וזן", 11);
    freq.put("וזא", 13);
    freq.put("וזב", 17);
    freq.put("ארס", 10);
    freq.put("ארנ", 12);
    freq.put("ארק", 16);
    freq.put("ארצ", 21);
    freq.put("ארץ", 69);
    freq.put("כזי", 20);
    freq.put("לגב", 32);
    freq.put("לגו", 34);
    freq.put("לגה", 8);
    freq.put("לגי", 31);
    freq.put("לגל", 38);
    freq.put("לגן", 6);
    freq.put("לגמ", 38);
    freq.put("תרו", 56);
    freq.put("רתת", 14);
    freq.put("רתו", 7);
    freq.put("רתם", 9);
    freq.put("רתי", 216);
    freq.put("פם ", 10);
    freq.put("לגנ", 8);
    freq.put("س", 10);
    freq.put("לסר", 15);
    freq.put("לגת", 10);
    freq.put("היס", 38);
    freq.put("רר ", 101);
    freq.put("צפו", 74);
    freq.put("צפה", 18);
    freq.put("צפי", 26);
    freq.put("צפר", 30);
    freq.put("צפת", 8);
    freq.put("לא ", 3009);
    freq.put("סא ", 14);
    freq.put("דם ", 226);
    freq.put("ברט", 37);
    freq.put("🙏 ", 6);
    freq.put("עתת", 9);
    freq.put("וט ", 201);
    freq.put("ן", 5632);
    freq.put("אצ ", 7);
    freq.put("מזע", 6);
    freq.put("מזר", 25);
    freq.put("זת ", 13);
    freq.put("יה?", 7);
    freq.put("מזו", 33);
    freq.put("מזה", 83);
    freq.put("מזד", 10);
    freq.put("מזג", 26);
    freq.put("מזמ", 24);
    freq.put("מזל", 82);
    freq.put("מזכ", 27);
    freq.put("מזי", 19);
    freq.put("שד ", 24);
    freq.put(" ד ", 21);
    freq.put("מאל", 64);
    freq.put("מאמ", 113);
    freq.put("מאי", 86);
    freq.put("מאכ", 12);
    freq.put("מאו", 228);
    freq.put("מאה", 22);
    freq.put("מאח", 78);
    freq.put("מאז", 35);
    freq.put("מאב", 38);
    freq.put("מאא", 9);
    freq.put("מאד", 21);
    freq.put("מאג", 7);
    freq.put("מאש", 42);
    freq.put("מאר", 24);
    freq.put("מאת", 13);
    freq.put("מאפ", 13);
    freq.put("מאק", 11);
    freq.put("מאס", 54);
    freq.put("מאנ", 18);
    freq.put("עתם", 18);
    freq.put("ור ", 998);
    freq.put("שתס", 6);
    freq.put("עתכ", 8);
    freq.put("עתי", 195);
    freq.put("יי", 4631);
    freq.put("יט", 730);
    freq.put("יכ", 854);
    freq.put("יך", 761);
    freq.put("ים", 6787);
    freq.put("יל", 1946);
    freq.put("ין", 1482);
    freq.put("ימ", 781);
    freq.put("יב", 1036);
    freq.put("יא", 1172);
    freq.put("יד", 1349);
    freq.put("יג", 311);
    freq.put("יו", 4193);
    freq.put("יה", 1920);
    freq.put("יח", 709);
    freq.put("יז", 557);
    freq.put("יש", 2271);
    freq.put("יר", 1740);
    freq.put("לרו", 30);
    freq.put("ית", 2526);
    freq.put("רו ", 253);
    freq.put("לרג", 21);
    freq.put("לרא", 124);
    freq.put("יס", 668);
    freq.put("ינ", 1509);
    freq.put("יף", 221);
    freq.put("יע", 640);
    freq.put("יץ", 180);
    freq.put("יפ", 930);
    freq.put("יק", 1190);
    freq.put("יצ", 584);
    freq.put("י״", 16);
    freq.put("בבק", 38);
    freq.put("בבצ", 6);
    freq.put("קח ", 47);
    freq.put("בבר", 20);
    freq.put("בבת", 17);
    freq.put("בבו", 67);
    freq.put("בבה", 23);
    freq.put("בבח", 10);
    freq.put("בבב", 37);
    freq.put("בבא", 8);
    freq.put("בבל", 6);
    freq.put("בבי", 145);
    freq.put("״מ", 11);
    freq.put("״ל", 12);
    freq.put("הלק", 8);
    freq.put("״כ", 18);
    freq.put("״י", 6);
    freq.put("״ח", 6);
    freq.put("הלש", 6);
    freq.put("״א", 29);
    freq.put("״ב", 9);
    freq.put(" ️ ", 7);
    freq.put("הלב", 57);
    freq.put("הלא", 20);
    freq.put("״ת", 11);
    freq.put("הלו", 69);
    freq.put("״ש", 12);
    freq.put("״צ", 7);
    freq.put("הלך", 29);
    freq.put("״פ", 7);
    freq.put("״ע", 10);
    freq.put("״נ", 6);
    freq.put("הלל", 6);
    freq.put("המ ", 6);
    freq.put("اْا", 13);
    freq.put("כ", 10667);
    freq.put("קוף", 15);
    freq.put("קוע", 26);
    freq.put("קוס", 20);
    freq.put("קונ", 42);
    freq.put("קוק", 26);
    freq.put("קופ", 75);
    freq.put("קות", 133);
    freq.put("קוש", 23);
    freq.put("קור", 241);
    freq.put("בח ", 18);
    freq.put("תאי", 43);
    freq.put("תאכ", 21);
    freq.put("תאמ", 34);
    freq.put("תאב", 12);
    freq.put("תאו", 74);
    freq.put("תאה", 28);
    freq.put("תאח", 10);
    freq.put("תאר", 44);
    freq.put("תאנ", 6);
    freq.put("תאפ", 11);
    freq.put("קוד", 112);
    freq.put("קוב", 49);
    freq.put("קוח", 29);
    freq.put("קוז", 6);
    freq.put("קוו", 77);
    freq.put("קוי", 10);
    freq.put("קוט", 13);
    freq.put("קון", 26);
    freq.put("קומ", 62);
    freq.put("קום", 177);
    freq.put("קול", 122);
    freq.put("חגו", 9);
    freq.put("חגג", 7);
    freq.put("רדה", 15);
    freq.put("רדו", 34);
    freq.put("לת ", 266);
    freq.put("רדי", 74);
    freq.put("רדמ", 14);
    freq.put("רדן", 8);
    freq.put("רדם", 14);
    freq.put("רדנ", 7);
    freq.put("רדת", 26);
    freq.put("רדר", 8);
    freq.put(" די", 265);
    freq.put(" דמ", 36);
    freq.put(" דל", 32);
    freq.put(" דם", 9);
    freq.put(" דג", 17);
    freq.put(" דא", 30);
    freq.put(" דב", 265);
    freq.put(" דח", 19);
    freq.put(" דה", 23);
    freq.put(" דו", 235);
    freq.put("שדר", 18);
    freq.put("שדי", 10);
    freq.put("😫?", 7);
    freq.put("שדו", 21);
    freq.put(" דת", 11);
    freq.put(" דר", 112);
    freq.put(" דע", 19);
    freq.put(" דף", 7);
    freq.put(" דנ", 43);
    freq.put(" דק", 77);
    freq.put(" דפ", 19);
    freq.put("יהמ", 6);
    freq.put("יהן", 16);
    freq.put("יהם", 63);
    freq.put("יהי", 261);
    freq.put("יהה", 10);
    freq.put("יהו", 108);
    freq.put("יהר", 7);
    freq.put("יהנ", 10);
    freq.put("צד ", 61);
    freq.put("אצב", 9);
    freq.put("וטנ", 8);
    freq.put("וטס", 10);
    freq.put("אצי", 17);
    freq.put("אצט", 8);
    freq.put("אצל", 91);
    freq.put("וטר", 32);
    freq.put("וטש", 6);
    freq.put("וטה", 26);
    freq.put("וטו", 144);
    freq.put("וטג", 6);
    freq.put("אצפ", 6);
    freq.put("וטא", 8);
    freq.put("וטב", 8);
    freq.put("וטל", 12);
    freq.put("וטט", 11);
    freq.put("וטי", 70);
    freq.put("סאמ", 11);
    freq.put(" ז ", 29);
    freq.put("סאו", 8);
    freq.put("לאן", 19);
    freq.put("לאמ", 35);
    freq.put("לאל", 33);
    freq.put("לאכ", 57);
    freq.put("לאי", 95);
    freq.put("לאט", 20);
    freq.put("לאח", 69);
    freq.put("ררת", 18);
    freq.put("לאו", 94);
    freq.put("ררר", 130);
    freq.put("לאד", 16);
    freq.put("לאג", 7);
    freq.put("לאב", 41);
    freq.put("לאא", 18);
    freq.put("צפ ", 7);
    freq.put("לאת", 12);
    freq.put("ררו", 8);
    freq.put("ררה", 6);
    freq.put("לאק", 18);
    freq.put("ררי", 13);
    freq.put("לאפ", 27);
    freq.put("לאף", 8);
    freq.put("לאס", 23);
    freq.put("לאנ", 47);
    freq.put("פן ", 46);
    freq.put("טל ", 81);
    freq.put("סאפ", 23);
    freq.put("ن", 18);
    freq.put("רת ", 635);
    freq.put("לג ", 17);
    freq.put("דן ", 76);
    freq.put("צצו", 6);
    freq.put("צצה", 10);
    freq.put("וז ", 52);
    freq.put("אר ", 137);
    freq.put("נגו", 14);
    freq.put("　", 33);
    freq.put("נגב", 7);
    freq.put("נגד", 76);
    freq.put("נגל", 30);
    freq.put("נגן", 8);
    freq.put("נגמ", 44);
    freq.put("נגי", 26);
    freq.put("קדש", 16);
    freq.put("קדת", 8);
    freq.put("זר ", 86);
    freq.put("קדו", 20);
    freq.put("קדי", 54);
    freq.put("קדם", 29);
    freq.put("קדמ", 26);
    freq.put("נגר", 7);
    freq.put("חטי", 9);
    freq.put("שב ", 135);
    freq.put("סך", 22);
    freq.put(" ו ", 42);
    freq.put("מסל", 10);
    freq.put(" טנ", 9);
    freq.put("שחו", 61);
    freq.put("שחב", 12);
    freq.put("שחי", 24);
    freq.put("שחק", 150);
    freq.put("טני", 37);
    freq.put("טנט", 6);
    freq.put("טנד", 8);
    freq.put("שחש", 15);
    freq.put("שחר", 28);
    freq.put(" ₪ ", 9);
    freq.put(" חצ", 63);
    freq.put(" חק", 6);
    freq.put(" חפ", 19);
    freq.put(" חנ", 36);
    freq.put(" חס", 69);
    freq.put(" חת", 80);
    freq.put(" חר", 57);
    freq.put(" חש", 153);
    freq.put("רח ", 39);
    freq.put(" חז", 99);
    freq.put(" חח", 530);
    freq.put(" חו", 664);
    freq.put(" חג", 34);
    freq.put(" חד", 205);
    freq.put(" חא", 10);
    freq.put(" חב", 290);
    freq.put(" חמ", 135);
    freq.put(" חן", 24);
    freq.put(" חל", 133);
    freq.put(" חם", 12);
    freq.put(" חכ", 45);
    freq.put(" חט", 9);
    freq.put(" חי", 448);
    freq.put("ירת", 43);
    freq.put("ירש", 16);
    freq.put("ירס", 13);
    freq.put("ירק", 21);
    freq.put("קב ", 41);
    freq.put("והג", 18);
    freq.put("והד", 25);
    freq.put("והא", 17);
    freq.put("והב", 388);
    freq.put("והח", 17);
    freq.put("והה", 34);
    freq.put("והו", 78);
    freq.put("והכ", 28);
    freq.put("והט", 9);
    freq.put("והי", 143);
    freq.put("והמ", 43);
    freq.put("והן", 6);
    freq.put("והל", 15);
    freq.put("והם", 15);
    freq.put("והע", 6);
    freq.put("והנ", 15);
    freq.put("והס", 14);
    freq.put("והצ", 11);
    freq.put("והק", 8);
    freq.put("והפ", 16);
    freq.put(" ׳", 13);
    freq.put("והת", 13);
    freq.put("והר", 34);
    freq.put("והש", 22);
    freq.put("ירט", 10);
    freq.put("נא ", 65);
    freq.put("ירן", 18);
    freq.put("ירל", 9);
    freq.put("ירג", 19);
    freq.put("ירד", 28);
    freq.put("ירא", 87);
    freq.put("ירב", 16);
    freq.put("ירז", 9);
    freq.put("ירח", 6);
    freq.put("ירה", 212);
    freq.put("ירו", 407);
    freq.put(" ״", 133);
    freq.put("אתם", 190);
    freq.put("אתן", 24);
    freq.put("אתמ", 69);
    freq.put("אתי", 98);
    freq.put("תשא", 12);
    freq.put("תשמ", 16);
    freq.put("אתה", 560);
    freq.put("תשל", 21);
    freq.put("אתז", 6);
    freq.put("תשכ", 18);
    freq.put("אתג", 6);
    freq.put("תשע", 18);
    freq.put("אתר", 57);
    freq.put("אתת", 16);
    freq.put("תשת", 12);
    freq.put("עו ", 61);
    freq.put("דבש", 10);
    freq.put("דבר", 534);
    freq.put("דבק", 9);
    freq.put("דבי", 13);
    freq.put("דבו", 8);
    freq.put("שתנ", 14);
    freq.put("בו ", 174);
    freq.put("שתע", 16);
    freq.put("שתפ", 16);
    freq.put("שתצ", 6);
    freq.put("שתק", 20);
    freq.put("שתר", 8);
    freq.put("שתש", 10);
    freq.put("שתת", 41);
    freq.put("שתב", 12);
    freq.put("שתג", 18);
    freq.put("שתד", 22);
    freq.put("שתה", 44);
    freq.put("שתו", 39);
    freq.put("שתח", 12);
    freq.put("שתי", 156);
    freq.put("שתכ", 9);
    freq.put("שתל", 21);
    freq.put("שתמ", 45);
    freq.put("כדו", 43);
    freq.put("כדא", 12);
    freq.put("כדי", 122);
    freq.put("זדי", 23);
    freq.put("זדמ", 13);
    freq.put("😩?", 19);
    freq.put("מה ", 1931);
    freq.put("כב ", 42);
    freq.put("גרת", 42);
    freq.put("בכת", 10);
    freq.put("בכר", 7);
    freq.put("בכנ", 20);
    freq.put("בכפ", 6);
    freq.put("בכי", 80);
    freq.put("בכמ", 8);
    freq.put("בכל", 184);
    freq.put("בכד", 8);
    freq.put("בכב", 6);
    freq.put("בכו", 47);
    freq.put("צת ", 138);
    freq.put("פי ", 202);
    freq.put("עדן", 39);
    freq.put("עדי", 254);
    freq.put("סה ", 147);
    freq.put("עדכ", 26);
    freq.put("עדה", 23);
    freq.put("עדו", 24);
    freq.put("עדר", 6);
    freq.put("עדת", 17);
    freq.put("הג ", 27);
    freq.put("לל ", 223);
    freq.put("הטר", 26);
    freq.put("הטע", 16);
    freq.put("😌 ", 7);
    freq.put("דב ", 12);
    freq.put("הטמ", 8);
    freq.put("הטל", 22);
    freq.put("הטי", 29);
    freq.put("הטו", 91);
    freq.put("הטב", 11);
    freq.put("כשת", 7);
    freq.put("עוט", 6);
    freq.put("עוי", 11);
    freq.put("עומ", 73);
    freq.put("עון", 42);
    freq.put("עול", 289);
    freq.put("עוג", 22);
    freq.put("עוד", 400);
    freq.put("עוב", 148);
    freq.put("עוז", 42);
    freq.put("עוו", 12);
    freq.put("בלי", 241);
    freq.put("את ", 2867);
    freq.put("עות", 226);
    freq.put("עור", 109);
    freq.put("עוש", 219);
    freq.put("כשמ", 25);
    freq.put("כשל", 24);
    freq.put("כשד", 6);
    freq.put("עונ", 100);
    freq.put("עוס", 7);
    freq.put("עוצ", 17);
    freq.put("עוק", 59);
    freq.put("עופ", 20);
    freq.put("כשה", 66);
    freq.put("נאד", 21);
    freq.put("קבת", 12);
    freq.put("נאו", 28);
    freq.put("נאה", 46);
    freq.put("נאי", 53);
    freq.put("קבע", 15);
    freq.put("נאל", 21);
    freq.put("וה ", 184);
    freq.put("קבל", 121);
    freq.put("נאצ", 10);
    freq.put("קבי", 42);
    freq.put("נאת", 118);
    freq.put("קבו", 91);
    freq.put("קבה", 7);
    freq.put("חמד", 28);
    freq.put("חמא", 19);
    freq.put("חמה", 25);
    freq.put("חמו", 70);
    freq.put("חמי", 71);
    freq.put("חמם", 13);
    freq.put("רחמ", 9);
    freq.put("רחי", 57);
    freq.put("רחה", 6);
    freq.put("אוף", 46);
    freq.put("רחב", 21);
    freq.put("רחת", 21);
    freq.put("רחש", 9);
    freq.put("רחק", 25);
    freq.put("חמת", 23);
    freq.put("חמש", 23);
    freq.put("ה😂", 11);
    freq.put(" ול", 402);
    freq.put(" ומ", 328);
    freq.put(" וט", 31);
    freq.put(" וי", 223);
    freq.put(" וכ", 136);
    freq.put(" וה", 439);
    freq.put(" וו", 185);
    freq.put(" וז", 112);
    freq.put(" וח", 118);
    freq.put(" וא", 630);
    freq.put(" וב", 209);
    freq.put(" וג", 112);
    freq.put(" וד", 44);
    freq.put("שבר", 42);
    freq.put("שבת", 240);
    freq.put("שבס", 8);
    freq.put("שבנ", 16);
    freq.put("שבע", 88);
    freq.put("אול", 153);
    freq.put("שבן", 10);
    freq.put("שבמ", 12);
    freq.put("שבי", 217);
    freq.put("שבט", 11);
    freq.put("שבכ", 8);
    freq.put("אום", 58);
    freq.put("שבו", 249);
    freq.put("שבה", 27);
    freq.put("שבח", 21);
    freq.put("שבא", 35);
    freq.put("שבג", 9);
    freq.put(" ור", 81);
    freq.put(" וש", 169);
    freq.put(" ות", 116);
    freq.put(" ופ", 55);
    freq.put("אוט", 89);
    freq.put(" וצ", 26);
    freq.put(" וק", 47);
    freq.put(" ונ", 115);
    freq.put(" וס", 48);
    freq.put(" וע", 150);
    freq.put("אוי", 60);
    freq.put("יתנ", 22);
    freq.put("יתק", 23);
    freq.put("יתר", 38);
    freq.put("יתת", 16);
    freq.put("קד ", 27);
    freq.put("זרת", 70);
    freq.put("זרק", 10);
    freq.put("תלמ", 30);
    freq.put("זרי", 54);
    freq.put("זרו", 54);
    freq.put("זרה", 58);
    freq.put("זרח", 47);
    freq.put("אוב", 38);
    freq.put("יתג", 8);
    freq.put("יתה", 180);
    freq.put("תלכ", 9);
    freq.put("יתח", 22);
    freq.put("יתי", 566);
    freq.put("יתך", 47);
    freq.put("אוד", 84);
    freq.put("יתם", 32);
    freq.put("יתמ", 6);
    freq.put("יתן", 21);
    freq.put("ללכ", 72);
    freq.put("ללך", 6);
    freq.put("ללי", 42);
    freq.put("ללמ", 33);
    freq.put("ללל", 104);
    freq.put("ללב", 15);
    freq.put("ללא", 45);
    freq.put("סהר", 8);
    freq.put("ללה", 56);
    freq.put("ללת", 13);
    freq.put("עד ", 269);
    freq.put("פיל", 153);
    freq.put("פים", 125);
    freq.put("פין", 8);
    freq.put("פיט", 20);
    freq.put("פיי", 202);
    freq.put("פיה", 16);
    freq.put("פיו", 35);
    freq.put("פיז", 11);
    freq.put("פיא", 8);
    freq.put("פיב", 14);
    freq.put("פיג", 27);
    freq.put("פיד", 92);
    freq.put("צתי", 14);
    freq.put("ْا", 13);
    freq.put("צינ", 44);
    freq.put("פיר", 82);
    freq.put("פיש", 6);
    freq.put("פית", 50);
    freq.put("פיפ", 16);
    freq.put("פיצ", 53);
    freq.put("פיק", 67);
    freq.put("פינ", 45);
    freq.put("פיס", 27);
    freq.put("פיע", 24);
    freq.put("בלע", 35);
    freq.put("כבד", 21);
    freq.put("כבו", 54);
    freq.put("כבה", 14);
    freq.put("כבי", 70);
    freq.put("כבת", 34);
    freq.put("כבר", 400);
    freq.put("מהש", 19);
    freq.put("מהר", 49);
    freq.put("מהת", 22);
    freq.put("מהס", 11);
    freq.put("מהנ", 16);
    freq.put("מהע", 18);
    freq.put("מהפ", 30);
    freq.put("מהק", 12);
    freq.put("מהצ", 18);
    freq.put("מהי", 48);
    freq.put("מהט", 10);
    freq.put("מהכ", 21);
    freq.put("מהם", 18);
    freq.put("מהל", 29);
    freq.put("מהמ", 73);
    freq.put("מהב", 48);
    freq.put("מהא", 48);
    freq.put("מהד", 26);
    freq.put("מהג", 10);
    freq.put("מהו", 29);
    freq.put("מהה", 61);
    freq.put("מהח", 34);
    freq.put("בוס", 56);
    freq.put("בונ", 23);
    freq.put("בוע", 193);
    freq.put("בוק", 337);
    freq.put("בוצ", 41);
    freq.put("בוש", 46);
    freq.put("בור", 220);
    freq.put("בות", 230);
    freq.put("בוב", 38);
    freq.put("בוא", 225);
    freq.put("בוד", 198);
    freq.put("בוג", 29);
    freq.put("בוו", 58);
    freq.put("בוה", 25);
    freq.put("בוח", 14);
    freq.put("בוז", 9);
    freq.put("בוי", 25);
    freq.put("בוט", 22);
    freq.put("בוכ", 31);
    freq.put("בום", 21);
    freq.put("בול", 78);
    freq.put("בון", 43);
    freq.put("ל?", 6);
    freq.put(" כ״", 7);
    freq.put(" כע", 12);
    freq.put(" כנ", 93);
    freq.put(" כס", 34);
    freq.put(" כפ", 66);
    freq.put(" כת", 69);
    freq.put(" כר", 73);
    freq.put(" כש", 298);
    freq.put(" כד", 160);
    freq.put(" כא", 231);
    freq.put(" כב", 417);
    freq.put(" כז", 115);
    freq.put(" כח", 39);
    freq.put(" כה", 32);
    freq.put(" כו", 413);
    freq.put(" כך", 150);
    freq.put(" ככ", 111);
    freq.put(" כי", 420);
    freq.put(" כמ", 596);
    freq.put(" כן", 224);
    freq.put(" כל", 721);
    freq.put("נתר", 9);
    freq.put("סך ", 19);
    freq.put("😌?", 18);
    freq.put("ואמ", 22);
    freq.put("ואן", 22);
    freq.put("ואל", 91);
    freq.put("ואם", 32);
    freq.put("ואט", 39);
    freq.put("ואי", 274);
    freq.put("ואז", 113);
    freq.put("ואח", 29);
    freq.put("ואה", 112);
    freq.put("ואו", 196);
    freq.put("ואג", 6);
    freq.put("ואא", 13);
    freq.put("ואב", 63);
    freq.put("ואת", 86);
    freq.put("ואר", 59);
    freq.put("ואש", 20);
    freq.put("ואצ", 14);
    freq.put("ואפ", 14);
    freq.put("ואף", 13);
    freq.put("ואנ", 179);
    freq.put("😊?", 15);
    freq.put("דוח", 21);
    freq.put("דוו", 66);
    freq.put("דוד", 60);
    freq.put("דוג", 14);
    freq.put("דוב", 43);
    freq.put("דוא", 35);
    freq.put("דון", 34);
    freq.put("דומ", 37);
    freq.put("דום", 28);
    freq.put("דול", 186);
    freq.put("דוכ", 10);
    freq.put("דד ", 49);
    freq.put("דוי", 9);
    freq.put("דוק", 36);
    freq.put("דופ", 12);
    freq.put("דוע", 17);
    freq.put("דוס", 7);
    freq.put("דונ", 17);
    freq.put("דות", 150);
    freq.put("דוש", 28);
    freq.put("דור", 138);
    freq.put("רני", 46);
    freq.put("רנט", 39);
    freq.put("רנד", 7);
    freq.put("רנג", 9);
    freq.put("רנו", 51);
    freq.put("רנה", 9);
    freq.put("תק ", 29);
    freq.put("רנס", 10);
    freq.put("רנק", 9);
    freq.put("לטפ", 8);
    freq.put("לטע", 13);
    freq.put("לטת", 20);
    freq.put("פוי", 37);
    freq.put("סטנ", 14);
    freq.put("סטר", 86);
    freq.put("סטג", 19);
    freq.put("סטא", 15);
    freq.put("וג ", 125);
    freq.put("סטה", 7);
    freq.put("סטו", 78);
    freq.put("סטט", 17);
    freq.put("סטי", 155);
    freq.put("סטמ", 6);
    freq.put("סטן", 6);
    freq.put("סטל", 16);
    freq.put("לטו", 49);
    freq.put("לטה", 13);
    freq.put("לטל", 7);
    freq.put("גש ", 60);
    freq.put("פור", 205);
    freq.put("פוש", 22);
    freq.put("פות", 124);
    freq.put("פת", 464);
    freq.put("פר", 1061);
    freq.put("פש", 507);
    freq.put("פצ", 81);
    freq.put("פק", 171);
    freq.put("פפ", 31);
    freq.put("פץ", 13);
    freq.put("פע", 451);
    freq.put("פוץ", 12);
    freq.put("פנ", 404);
    freq.put("פס", 348);
    freq.put("פמ", 20);
    freq.put("פן", 49);
    freq.put("פל", 404);
    freq.put("פם", 13);
    freq.put("פך", 40);
    freq.put("פכ", 35);
    freq.put("פט", 141);
    freq.put("פי", 1309);
    freq.put("פז", 33);
    freq.put("פח", 259);
    freq.put("פה", 723);
    freq.put("פו", 1106);
    freq.put("פג", 199);
    freq.put("פד", 31);
    freq.put("פא", 169);
    freq.put("פב", 30);
    freq.put("נ ", 50);
    freq.put("לדח", 8);
    freq.put("לדה", 55);
    freq.put("שרת", 49);
    freq.put("שרש", 7);
    freq.put("שרף", 8);
    freq.put("שרצ", 8);
    freq.put("טע ", 64);
    freq.put("שרפ", 7);
    freq.put("שרי", 81);
    freq.put("שרמ", 19);
    freq.put("לדא", 11);
    freq.put("שרד", 41);
    freq.put("שרא", 235);
    freq.put("שרה", 45);
    freq.put("שרו", 112);
    freq.put("לדמ", 13);
    freq.put("כשע", 8);
    freq.put("כשנ", 9);
    freq.put("זבת", 8);
    freq.put("כומ", 6);
    freq.put("כום", 11);
    freq.put("כול", 601);
    freq.put("כוכ", 20);
    freq.put("כוי", 29);
    freq.put("כוח", 92);
    freq.put("כוו", 91);
    freq.put("כוה", 9);
    freq.put("כוד", 14);
    freq.put("כוב", 19);
    freq.put("כוא", 46);
    freq.put("סע ", 22);
    freq.put("זבי", 12);
    freq.put("כות", 191);
    freq.put("זבל", 22);
    freq.put("ח ", 1561);
    freq.put("כופ", 6);
    freq.put("זבז", 9);
    freq.put("כוע", 48);
    freq.put("זבה", 8);
    freq.put("זבו", 23);
    freq.put("ח?", 11);
    freq.put("פוב", 6);
    freq.put("פוג", 27);
    freq.put("ب", 15);
    freq.put("צ׳י", 6);
    freq.put("קם ", 22);
    freq.put("צ׳ק", 7);
    freq.put("נה ", 1264);
    freq.put("עב ", 10);
    freq.put("הזר", 16);
    freq.put("כשכ", 8);
    freq.put("הזמ", 99);
    freq.put("הזי", 23);
    freq.put("הזכ", 24);
    freq.put("הזו", 48);
    freq.put("הזה", 252);
    freq.put("הזא", 81);
    freq.put("הזד", 22);
    freq.put("תה ", 985);
    freq.put("לדע", 53);
    freq.put("הה ", 220);
    freq.put("כשב", 9);
    freq.put(" ס ", 19);
    freq.put("כשא", 94);
    freq.put("מצב", 100);
    freq.put("לדת", 76);
    freq.put("כשז", 10);
    freq.put("לדר", 15);
    freq.put("נזק", 6);
    freq.put("בי ", 293);
    freq.put("קבר", 16);
    freq.put("נזי", 13);
    freq.put("נזכ", 24);
    freq.put("יר ", 541);
    freq.put("חפר", 10);
    freq.put("חפש", 78);
    freq.put("נאמ", 8);
    freq.put("חפו", 22);
    freq.put("חפי", 10);
    freq.put("טפו", 14);
    freq.put("סני", 17);
    freq.put("סנן", 6);
    freq.put("סנד", 11);
    freq.put("טפל", 11);
    freq.put("סנו", 6);
    freq.put("סננ", 9);
    freq.put("טפת", 7);
    freq.put("ףף ", 20);
    freq.put("ה", 36928);
    freq.put("חח", 4368);
    freq.put("חז", 310);
    freq.put("חו", 1841);
    freq.put("חה", 372);
    freq.put("חד", 828);
    freq.put("חג", 69);
    freq.put("חב", 556);
    freq.put("חא", 35);
    freq.put("חן", 82);
    freq.put("חמ", 298);
    freq.put("זב ", 23);
    freq.put("חל", 519);
    freq.put("חכ", 150);
    freq.put("חי", 1654);
    freq.put("חט", 30);
    freq.put("חק", 295);
    freq.put("חצ", 141);
    freq.put("חץ", 22);
    freq.put("חפ", 131);
    freq.put("חף", 6);
    freq.put("חע", 6);
    freq.put("חס", 175);
    freq.put("חנ", 309);
    freq.put("סער", 7);
    freq.put("סעת", 7);
    freq.put("חת", 652);
    freq.put("חש", 370);
    freq.put("חר", 914);
    freq.put("נע", 231);
    freq.put("נף", 9);
    freq.put("ננ", 98);
    freq.put("נס", 483);
    freq.put("נצ", 118);
    freq.put("נק", 245);
    freq.put("נפ", 251);
    freq.put("נץ", 6);
    freq.put("נת", 608);
    freq.put("נר", 307);
    freq.put("נש", 659);
    freq.put("שוי", 24);
    freq.put("שוט", 137);
    freq.put("שוכ", 21);
    freq.put("שוך", 6);
    freq.put("שום", 76);
    freq.put("טער", 21);
    freq.put("נ״", 8);
    freq.put("שומ", 73);
    freq.put("שוב", 229);
    freq.put("שוא", 61);
    freq.put("שוד", 24);
    freq.put("שוג", 7);
    freq.put("שוו", 109);
    freq.put("טענ", 10);
    freq.put("שוח", 26);
    freq.put("שוש", 8);
    freq.put("שור", 121);
    freq.put("טען", 15);
    freq.put("טעמ", 8);
    freq.put("טעי", 42);
    freq.put("יפן", 6);
    freq.put("טעו", 47);
    freq.put("שונ", 258);
    freq.put("שוף", 6);
    freq.put("שוע", 14);
    freq.put("שופ", 35);
    freq.put("שוק", 68);
    freq.put(" ", 10);
    freq.put("נד", 260);
    freq.put("נא", 395);
    freq.put("נב", 88);
    freq.put("נז", 61);
    freq.put("נח", 299);
    freq.put("נה", 1551);
    freq.put("נו", 2358);
    freq.put("נך", 11);
    freq.put("נכ", 244);
    freq.put("נט", 294);
    freq.put("ני", 5465);
    freq.put("נמ", 138);
    freq.put("נן", 48);
    freq.put("נל", 76);
    freq.put("נם", 39);
    freq.put(" יר", 120);
    freq.put(" יש", 931);
    freq.put(" ית", 64);
    freq.put("פו ", 82);
    freq.put(" יס", 41);
    freq.put(" יע", 99);
    freq.put("יפי", 102);
    freq.put(" יפ", 211);
    freq.put("פ ", 173);
    freq.put(" יק", 95);
    freq.put("יפו", 277);
    freq.put(" ח ", 50);
    freq.put("טם ", 18);
    freq.put("יפד", 7);
    freq.put(" יט", 9);
    freq.put(" יי", 93);
    freq.put(" יכ", 259);
    freq.put(" יל", 188);
    freq.put(" ים", 38);
    freq.put(" ימ", 119);
    freq.put(" יא", 185);
    freq.put(" יב", 59);
    freq.put(" יג", 49);
    freq.put(" יד", 123);
    freq.put(" יה", 221);
    freq.put(" יו", 1309);
    freq.put(" יז", 29);
    freq.put(" יח", 101);
    freq.put("גשמ", 6);
    freq.put("גשם", 29);
    freq.put("גשי", 13);
    freq.put("גשה", 18);
    freq.put("גשו", 28);
    freq.put("וגה", 9);
    freq.put("וגו", 30);
    freq.put("סט ", 72);
    freq.put("וגב", 14);
    freq.put("וגג", 19);
    freq.put("וגד", 16);
    freq.put("וגל", 45);
    freq.put("וגם", 73);
    freq.put("וגמ", 15);
    freq.put("וגן", 7);
    freq.put("וגי", 92);
    freq.put("וגנ", 7);
    freq.put("וגע", 27);
    freq.put("יפש", 29);
    freq.put("וגר", 53);
    freq.put("וגש", 10);
    freq.put("וגת", 7);
    freq.put("גשת", 29);
    freq.put("גשר", 6);
    freq.put("גשנ", 9);
    freq.put("תקי", 37);
    freq.put("תקל", 32);
    freq.put("יפנ", 17);
    freq.put("תקן", 12);
    freq.put("תקב", 21);
    freq.put("תקד", 20);
    freq.put("תקו", 78);
    freq.put("תקר", 24);
    freq.put("תקש", 95);
    freq.put("תקת", 9);
    freq.put("רחו", 68);
    freq.put("תקנ", 18);
    freq.put("תקע", 12);
    freq.put("תקף", 13);
    freq.put("תקפ", 21);
    freq.put("ْ", 15);
    freq.put("דדי", 12);
    freq.put("דו ", 116);
    freq.put("דדו", 8);
    freq.put("דדד", 21);
    freq.put("למל", 11);
    freq.put("לממ", 9);
    freq.put("למי", 182);
    freq.put("למט", 18);
    freq.put("למכ", 26);
    freq.put("למו", 142);
    freq.put("למה", 326);
    freq.put("למח", 34);
    freq.put("למב", 16);
    freq.put("למא", 11);
    freq.put("למד", 70);
    freq.put("למג", 9);
    freq.put("וא ", 906);
    freq.put("למש", 61);
    freq.put("למר", 44);
    freq.put("למת", 74);
    freq.put("למק", 14);
    freq.put("למצ", 40);
    freq.put("למס", 33);
    freq.put("למנ", 25);
    freq.put("למע", 34);
    freq.put("פכת", 10);
    freq.put("א", 31079);
    freq.put(" כ ", 58);
    freq.put("צרי", 294);
    freq.put("צרו", 37);
    freq.put("צרה", 8);
    freq.put("צרת", 8);
    freq.put("צרפ", 15);
    freq.put("פכה", 9);
    freq.put("פכו", 7);
    freq.put("ףףף", 47);
    freq.put("😰?", 32);
    freq.put("?", 2229);
    freq.put("ביש", 66);
    freq.put("ביר", 132);
    freq.put("בית", 405);
    freq.put("ביץ", 22);
    freq.put("ביפ", 7);
    freq.put("ביק", 66);
    freq.put("ביצ", 46);
    freq.put("ביס", 36);
    freq.put("בינ", 172);
    freq.put("ביע", 68);
    freq.put("בים", 382);
    freq.put("ביל", 168);
    freq.put("בין", 226);
    freq.put("בימ", 21);
    freq.put("ביי", 117);
    freq.put("ביט", 54);
    freq.put("ביכ", 13);
    freq.put("ביך", 6);
    freq.put("ביו", 153);
    freq.put("ביה", 26);
    freq.put("ביח", 39);
    freq.put("ביז", 12);
    freq.put("ביב", 158);
    freq.put("ביא", 94);
    freq.put("ביד", 36);
    freq.put("ביג", 10);
    freq.put("ען ", 32);
    freq.put(" סא", 19);
    freq.put("ההת", 34);
    freq.put("ההש", 10);
    freq.put("", 31);
    freq.put(" סה", 10);
    freq.put(" סו", 243);
    freq.put(" סח", 26);
    freq.put(" סט", 108);
    freq.put(" סי", 258);
    freq.put("ההס", 15);
    freq.put(" סכ", 9);
    freq.put(" סל", 66);
    freq.put("ההצ", 9);
    freq.put(" סמ", 42);
    freq.put("ההפ", 20);
    freq.put(" סנ", 21);
    freq.put(" סע", 25);
    freq.put(" ספ", 161);
    freq.put("ההמ", 7);
    freq.put("ההל", 6);
    freq.put(" סר", 108);
    freq.put("ההג", 18);
    freq.put("ההב", 20);
    freq.put("ההז", 6);
    freq.put("ההו", 57);
    freq.put("ההה", 515);
    freq.put("עבר", 136);
    freq.put("ק", 9085);
    freq.put("אשד", 9);
    freq.put("עבה", 11);
    freq.put("עבו", 185);
    freq.put("עבד", 19);
    freq.put("מינ", 140);
    freq.put("עבי", 44);
    freq.put("נהל", 34);
    freq.put("נהי", 50);
    freq.put("נהה", 28);
    freq.put("נהד", 15);
    freq.put("נהג", 43);
    freq.put("אשו", 202);
    freq.put("נהר", 17);
    freq.put("נהנ", 27);
    freq.put("בן ", 255);
    freq.put("لا", 6);
    freq.put("דר ", 181);
    freq.put("סלק", 6);
    freq.put("סלמ", 6);
    freq.put("סלט", 7);
    freq.put("סלי", 50);
    freq.put("סלח", 8);
    freq.put("סלו", 37);
    freq.put("סלב", 15);
    freq.put("טכנ", 19);
    freq.put("פבר", 27);
    freq.put("צגה", 12);
    freq.put("זוז", 15);
    freq.put("זוה", 17);
    freq.put("זוו", 13);
    freq.put("זוג", 49);
    freq.put("זוב", 13);
    freq.put("זומ", 6);
    freq.put("זון", 11);
    freq.put("זול", 12);
    freq.put("זוכ", 56);
    freq.put("זוי", 17);
    freq.put("עק ", 7);
    freq.put("זוק", 6);
    freq.put("זוע", 6);
    freq.put("זונ", 56);
    freq.put("זות", 19);
    freq.put("זור", 164);
    freq.put("כח ", 38);
    freq.put("כיכ", 20);
    freq.put("צנו", 11);
    freq.put("כיי", 31);
    freq.put("כין", 25);
    freq.put("כימ", 12);
    freq.put("כים", 167);
    freq.put("כיל", 21);
    freq.put("כיב", 15);
    freq.put("כיא", 8);
    freq.put("כיח", 16);
    freq.put("כיו", 45);
    freq.put("כיה", 10);
    freq.put("ושב", 227);
    freq.put("ושא", 46);
    freq.put("ושד", 6);
    freq.put("ושג", 22);
    freq.put("ושו", 68);
    freq.put("ושה", 192);
    freq.put("ושי", 179);
    freq.put("ושכ", 8);
    freq.put("ושך", 13);
    freq.put("ושם", 16);
    freq.put("ושל", 122);
    freq.put("ושן", 6);
    freq.put("ושמ", 39);
    freq.put("ושנ", 17);
    freq.put("ושע", 9);
    freq.put("ושפ", 19);
    freq.put("ושק", 11);
    freq.put("ושש", 18);
    freq.put("ושר", 75);
    freq.put("ושת", 25);
    freq.put("כית", 72);
    freq.put("כיש", 12);
    freq.put("כיר", 179);
    freq.put("כיף", 76);
    freq.put("כיס", 21);
    freq.put("כינ", 32);
    freq.put("כיפ", 23);
    freq.put("ע ", 1479);
    freq.put("טי ", 97);
    freq.put("פח ", 12);
    freq.put("ננו", 20);
    freq.put("ננה", 11);
    freq.put("נני", 27);
    freq.put("ננת", 26);
    freq.put("לך ", 873);
    freq.put("ךך ", 22);
    freq.put("דתי", 60);
    freq.put("", 19);
    freq.put("רע ", 56);
    freq.put("עצת", 8);
    freq.put("אא ", 35);
    freq.put("האח", 129);
    freq.put("האז", 16);
    freq.put("האו", 127);
    freq.put("האה", 38);
    freq.put("האד", 23);
    freq.put("האג", 20);
    freq.put("האב", 13);
    freq.put("ט", 6073);
    freq.put("האם", 44);
    freq.put("האל", 112);
    freq.put("האכ", 7);
    freq.put("האי", 129);
    freq.put("האק", 20);
    freq.put("האצ", 7);
    freq.put("האפ", 17);
    freq.put("האס", 16);
    freq.put("האנ", 59);
    freq.put("האת", 9);
    freq.put("האש", 27);
    freq.put("האר", 85);
    freq.put("תף ", 24);
    freq.put("גו ", 55);
    freq.put("יע ", 215);
    freq.put("חט ", 6);
    freq.put("חנת", 11);
    freq.put("חננ", 6);
    freq.put(" ם ", 16);
    freq.put("חנן", 6);
    freq.put("חני", 44);
    freq.put("חנה", 24);
    freq.put("חנו", 201);
    freq.put("ספה", 8);
    freq.put("ספו", 59);
    freq.put("ספא", 6);
    freq.put("ספל", 7);
    freq.put("ספט", 10);
    freq.put("ספי", 93);
    freq.put("בע ", 131);
    freq.put("ספק", 38);
    freq.put("ספס", 22);
    freq.put("ספת", 34);
    freq.put("ספר", 256);
    freq.put("בנת", 66);
    freq.put("בנש", 8);
    freq.put("פשט", 11);
    freq.put("פשי", 50);
    freq.put("פשה", 13);
    freq.put("פשו", 127);
    freq.put("בנס", 7);
    freq.put("בנק", 30);
    freq.put("בנט", 14);
    freq.put("בני", 217);
    freq.put("פשר", 149);
    freq.put("פשת", 29);
    freq.put("בנג", 6);
    freq.put("בנא", 34);
    freq.put("פשע", 7);
    freq.put("בנו", 197);
    freq.put("ינג", 80);
    freq.put("ינד", 16);
    freq.put("ינא", 11);
    freq.put("ינה", 283);
    freq.put("ינו", 329);
    freq.put("ינט", 89);
    freq.put("יני", 384);
    freq.put("ינמ", 15);
    freq.put("ינל", 18);
    freq.put("ינם", 24);
    freq.put("יננ", 9);
    freq.put("ינס", 55);
    freq.put("ינצ", 7);
    freq.put("ינק", 39);
    freq.put("ינפ", 20);
    freq.put("ינת", 96);
    freq.put("ינש", 10);
    freq.put("משך", 33);
    freq.put("משכ", 23);
    freq.put("משט", 30);
    freq.put("משי", 114);
    freq.put("משמ", 36);
    freq.put("משל", 96);
    freq.put("משם", 8);
    freq.put("משא", 23);
    freq.put("משב", 9);
    freq.put("משח", 109);
    freq.put("משה", 213);
    freq.put("משו", 97);
    freq.put("משת", 68);
    freq.put("משר", 45);
    freq.put("גדי", 40);
    freq.put("כ״כ", 7);
    freq.put("משע", 69);
    freq.put("גדו", 159);
    freq.put("משנ", 64);
    freq.put("משק", 36);
    freq.put("משפ", 126);
    freq.put("אגר", 17);
    freq.put("תסב", 8);
    freq.put("עם ", 1005);
    freq.put("קפת", 6);
    freq.put("קפה", 42);
    freq.put("קפו", 19);
    freq.put("קי ", 127);
    freq.put("קפי", 33);
    freq.put("אגו", 47);
    freq.put("אגה", 9);
    freq.put("תסת", 13);
    freq.put("אגד", 9);
    freq.put("תספ", 9);
    freq.put("אגי", 21);
    freq.put("נג ", 72);
    freq.put("רפו", 36);
    freq.put("רפא", 20);
    freq.put("רפי", 23);
    freq.put("יתכ", 15);
    freq.put("י😍", 7);
    freq.put("רפס", 6);
    freq.put("רפת", 23);
    freq.put("רפר", 9);
    freq.put("דחו", 23);
    freq.put("דחה", 6);
    freq.put("צי", 1309);
    freq.put("הא ", 19);
    freq.put("ج", 6);
    freq.put("אאא", 153);
    freq.put("אאו", 16);
    freq.put("רעי", 50);
    freq.put("ללו", 19);
    freq.put("רעו", 11);
    freq.put("רעה", 11);
    freq.put("רעב", 29);
    freq.put("רעש", 10);
    freq.put("רענ", 14);
    freq.put("סמס", 7);
    freq.put("שמר", 30);
    freq.put("דת ", 232);
    freq.put("סמר", 6);
    freq.put("סמת", 53);
    freq.put("שמש", 51);
    freq.put("סמה", 8);
    freq.put("סמו", 24);
    freq.put("סמא", 7);
    freq.put("שמת", 87);
    freq.put("סמל", 8);
    freq.put("סמי", 29);
    freq.put("שמפ", 18);
    freq.put("לךך", 18);
    freq.put("שמצ", 27);
    freq.put("עפ", 26);
    freq.put("עץ", 18);
    freq.put("עצ", 532);
    freq.put("שמק", 9);
    freq.put("ענ", 311);
    freq.put("עס", 63);
    freq.put("עע", 92);
    freq.put("עף", 7);
    freq.put("שמנ", 47);
    freq.put("ער", 615);
    freq.put("עש", 464);
    freq.put("עת", 631);
    freq.put("שמס", 14);
    freq.put("ע״", 7);
    freq.put("טיס", 43);
    freq.put("טיפ", 60);
    freq.put("שמע", 133);
    freq.put("טיק", 67);
    freq.put("פחת", 22);
    freq.put("טיש", 10);
    freq.put("טית", 34);
    freq.put("פחד", 49);
    freq.put("טיה", 22);
    freq.put("פחח", 14);
    freq.put("פחה", 37);
    freq.put("פחו", 99);
    freq.put("טיי", 85);
    freq.put("פחי", 19);
    freq.put("טיל", 23);
    freq.put("טים", 163);
    freq.put("טימ", 22);
    freq.put("טין", 52);
    freq.put("עה", 436);
    freq.put("עו", 1882);
    freq.put("עז", 149);
    freq.put("עח", 6);
    freq.put("עא", 25);
    freq.put("עב", 418);
    freq.put("עג", 139);
    freq.put("עד", 681);
    freq.put("על", 1770);
    freq.put("עם", 1020);
    freq.put("עמ", 352);
    freq.put("ען", 34);
    freq.put("עט", 87);
    freq.put("עי", 1034);
    freq.put("עכ", 313);
    freq.put("לפג", 11);
    freq.put(" עם", 731);
    freq.put("וש ", 217);
    freq.put("עץ ", 18);
    freq.put("כי ", 585);
    freq.put("כחו", 26);
    freq.put("כחה", 7);
    freq.put("כחי", 19);
    freq.put("עקב", 60);
    freq.put("עקה", 7);
    freq.put("עקו", 41);
    freq.put("עקי", 6);
    freq.put("זו ", 138);
    freq.put("עקש", 6);
    freq.put("עקת", 11);
    freq.put("כרו", 56);
    freq.put("כחת", 18);
    freq.put("שמל", 37);
    freq.put("שממ", 11);
    freq.put("שמן", 15);
    freq.put("שמט", 7);
    freq.put("שמי", 141);
    freq.put("ת😂", 8);
    freq.put("שמכ", 15);
    freq.put("דרנ", 6);
    freq.put("דרס", 9);
    freq.put("שמו", 159);
    freq.put("דרת", 22);
    freq.put("שמז", 9);
    freq.put("סל ", 20);
    freq.put("דרב", 10);
    freq.put("דרג", 11);
    freq.put("שמח", 130);
    freq.put("דרה", 30);
    freq.put("דרו", 88);
    freq.put("דרי", 65);
    freq.put("דרך", 119);
    freq.put("דרכ", 41);
    freq.put("דרמ", 17);
    freq.put("טח ", 43);
    freq.put("לפנ", 181);
    freq.put("אג ", 22);
    freq.put("קיו", 23);
    freq.put("קיה", 8);
    freq.put("קיד", 34);
    freq.put("קיב", 50);
    freq.put("קיא", 7);
    freq.put("קין", 8);
    freq.put("קימ", 9);
    freq.put("קים", 225);
    freq.put("קיל", 25);
    freq.put("קיי", 82);
    freq.put("קיט", 8);
    freq.put("קיק", 7);
    freq.put("קיצ", 23);
    freq.put("קיץ", 29);
    freq.put("קיפ", 16);
    freq.put("קיף", 6);
    freq.put("קיע", 7);
    freq.put("קיס", 7);
    freq.put("קינ", 33);
    freq.put("קית", 23);
    freq.put("קיש", 23);
    freq.put("קיר", 56);
    freq.put("נטר", 58);
    freq.put("נטע", 10);
    freq.put("נטנ", 8);
    freq.put("גד ", 85);
    freq.put("כך ", 172);
    freq.put("נטי", 53);
    freq.put("ו״", 11);
    freq.put("מש ", 195);
    freq.put("נטז", 7);
    freq.put("נטו", 25);
    freq.put("נטה", 9);
    freq.put("ערך", 28);
    freq.put("חצר", 6);
    freq.put(" ן ", 8);
    freq.put("חצי", 103);
    freq.put("חצו", 12);
    freq.put("פש ", 99);
    freq.put("בענ", 16);
    freq.put("בעצ", 50);
    freq.put("בעק", 19);
    freq.put("בער", 58);
    freq.put("בעת", 56);
    freq.put("اْ", 15);
    freq.put("בעב", 34);
    freq.put("בעד", 24);
    freq.put("בעה", 21);
    freq.put("בעו", 126);
    freq.put("בעז", 14);
    freq.put("בעי", 171);
    freq.put("בעל", 55);
    freq.put("בעמ", 10);
    freq.put("וו", 1954);
    freq.put("ان", 8);
    freq.put("גות", 39);
    freq.put("גור", 113);
    freq.put("גוש", 20);
    freq.put("גוע", 54);
    freq.put("גוף", 27);
    freq.put("גונ", 16);
    freq.put("גוס", 9);
    freq.put("נך ", 10);
    freq.put("גופ", 20);
    freq.put("יער", 40);
    freq.put("יעש", 26);
    freq.put("יעת", 15);
    freq.put("יענ", 7);
    freq.put("יעק", 16);
    freq.put("יעי", 58);
    freq.put("יעל", 28);
    freq.put("יעב", 22);
    freq.put("יעד", 16);
    freq.put("יעה", 67);
    freq.put("יעו", 95);
    freq.put("יעז", 11);
    freq.put("גוט", 7);
    freq.put("גוי", 15);
    freq.put("גומ", 14);
    freq.put("גון", 12);
    freq.put("גול", 74);
    freq.put("גום", 8);
    freq.put("גוג", 27);
    freq.put("גוד", 40);
    freq.put("גוב", 42);
    freq.put("גוז", 8);
    freq.put("גוו", 10);
    freq.put("נפל", 92);
    freq.put("נפי", 18);
    freq.put("נפט", 12);
    freq.put("נפו", 14);
    freq.put("נפג", 36);
    freq.put("נפת", 12);
    freq.put("נפש", 25);
    freq.put("נפר", 13);
    freq.put("נפצ", 10);
    freq.put("👍", 16);
    freq.put("👌", 121);
    freq.put("👏", 15);
    freq.put("👎", 42);
    freq.put("👋", 33);
    freq.put("👊", 47);
    freq.put(" ק ", 23);
    freq.put("אע", 49);
    freq.put("אף", 126);
    freq.put("אנ", 3214);
    freq.put("אס", 249);
    freq.put("אצ", 147);
    freq.put("אק", 185);
    freq.put("אפ", 479);
    freq.put("📢", 6);
    freq.put("את", 3980);
    freq.put("אר", 699);
    freq.put("אש", 619);
    freq.put("אג", 179);
    freq.put("אד", 298);
    freq.put("אא", 243);
    freq.put("אב", 1011);
    freq.put("אז", 572);
    freq.put("אח", 1266);
    freq.put("אה", 1085);
    freq.put("או", 3970);
    freq.put("אך", 27);
    freq.put("אכ", 198);
    freq.put("אט", 114);
    freq.put("אי", 3192);
    freq.put("אמ", 1059);
    freq.put("אן", 166);
    freq.put("אל", 1605);
    freq.put("אם", 591);
    freq.put("אַ", 8);
    freq.put("אָ", 7);
    freq.put("💦", 6);
    freq.put("💪", 9);
    freq.put("💕", 6);
    freq.put("💔", 6);
    freq.put("💙", 6);
    freq.put("💏", 98);
    freq.put("💋", 10);
    freq.put(" שט", 68);
    freq.put(" שי", 912);
    freq.put(" שכ", 171);
    freq.put(" של", 3108);
    freq.put(" שם", 118);
    freq.put(" שמ", 671);
    freq.put(" שא", 1094);
    freq.put(" שב", 408);
    freq.put(" שג", 69);
    freq.put(" שד", 38);
    freq.put(" שה", 750);
    freq.put(" שו", 631);
    freq.put(" שז", 140);
    freq.put(" שח", 139);
    freq.put(" ש״", 6);
    freq.put(" שר", 193);
    freq.put(" שש", 110);
    freq.put(" שת", 243);
    freq.put(" שנ", 485);
    freq.put(" שס", 21);
    freq.put(" שע", 327);
    freq.put(" שף", 7);
    freq.put(" שפ", 93);
    freq.put(" שצ", 52);
    freq.put(" שק", 179);
    freq.put("עית", 55);
    freq.put("עיר", 99);
    freq.put("עיצ", 20);
    freq.put("עיק", 48);
    freq.put("עיפ", 12);
    freq.put("עיף", 12);
    freq.put("עינ", 88);
    freq.put("עימ", 18);
    freq.put("עין", 23);
    freq.put("עיל", 76);
    freq.put("עים", 260);
    freq.put("נע ", 42);
    freq.put("עיי", 77);
    freq.put("עיה", 57);
    freq.put("עיו", 49);
    freq.put("עיג", 6);
    freq.put("עיד", 40);
    freq.put("׳", 128);
    freq.put("יכ ", 6);
    freq.put("נלח", 16);
    freq.put("נלא", 8);
    freq.put("וק ", 448);
    freq.put("עף ", 6);
    freq.put("נלך", 11);
    freq.put("נלי", 13);
    freq.put("וקי", 86);
    freq.put("יכנ", 30);
    freq.put("וקמ", 8);
    freq.put("צא ", 130);
    freq.put("נל ", 11);
    freq.put(" 😌", 24);
    freq.put("יפל", 11);
    freq.put("השר", 23);
    freq.put("השת", 57);
    freq.put("׳ק ", 7);
    freq.put("השפ", 13);
    freq.put("יפה", 334);
    freq.put("השק", 31);
    freq.put("השנ", 103);
    freq.put("יכש", 10);
    freq.put("השע", 29);
    freq.put("השל", 56);
    freq.put("השם", 40);
    freq.put("השמ", 59);
    freq.put(" 😏", 29);
    freq.put("השט", 16);
    freq.put("השי", 130);
    freq.put("יפר", 30);
    freq.put("השכ", 47);
    freq.put("שע ", 29);
    freq.put("השו", 70);
    freq.put("השח", 16);
    freq.put("השא", 36);
    freq.put("השב", 71);
    freq.put("השג", 8);
    freq.put("יפס", 21);
    freq.put(" 😊", 13);
    freq.put("🙌", 13);
    freq.put("🙏", 25);
    freq.put("🙊", 7);
    freq.put("😴", 6);
    freq.put("😶", 6);
    freq.put("😱", 45);
    freq.put("😰", 40);
    freq.put("😳", 35);
    freq.put("יכב", 6);
    freq.put("😥", 8);
    freq.put("😤", 19);
    freq.put("וקר", 249);
    freq.put("😡", 74);
    freq.put("😠", 12);
    freq.put("😢", 13);
    freq.put("😭", 84);
    freq.put("😬", 10);
    freq.put("😩", 32);
    freq.put("😨", 9);
    freq.put("😫", 14);
    freq.put("😪", 27);
    freq.put("😕", 6);
    freq.put("😔", 32);
    freq.put("😖", 9);
    freq.put("😓", 16);
    freq.put("😒", 48);
    freq.put("😜", 6);
    freq.put("😞", 10);
    freq.put("😘", 59);
    freq.put("😅", 45);
    freq.put("😄", 9);
    freq.put("😆", 8);
    freq.put("😁", 36);
    freq.put("😃", 9);
    freq.put("😂", 489);
    freq.put("😍", 204);
    freq.put("😌", 45);
    freq.put("😏", 50);
    freq.put("😎", 6);
    freq.put("😉", 22);
    freq.put("😈", 8);
    freq.put("😋", 10);
    freq.put("😊", 33);
    freq.put("וקק", 7);
    freq.put("אזע", 12);
    freq.put("קנת", 14);
    freq.put("אזר", 27);
    freq.put("יכל", 30);
    freq.put("אזו", 22);
    freq.put("קני", 83);
    freq.put("קנה", 38);
    freq.put("קנו", 49);
    freq.put("קנא", 44);
    freq.put("אזל", 13);
    freq.put("קנד", 9);
    freq.put("רצ ", 6);
    freq.put("תן ", 150);
    freq.put("רטנ", 6);
    freq.put("רטפ", 6);
    freq.put("רטת", 9);
    freq.put("אה ", 659);
    freq.put("רטא", 9);
    freq.put("רטו", 136);
    freq.put("רטה", 11);
    freq.put("רטי", 122);
    freq.put("רטט", 7);
    freq.put("רטן", 12);
    freq.put("גב ", 43);
    freq.put("שנג", 8);
    freq.put("שנד", 6);
    freq.put("שנא", 24);
    freq.put("שנח", 7);
    freq.put("שנה", 199);
    freq.put("שנו", 100);
    freq.put("שנכ", 13);
    freq.put("שני", 367);
    freq.put("שנמ", 7);
    freq.put("שנל", 8);
    freq.put("יצ ", 16);
    freq.put("שנע", 9);
    freq.put("שנצ", 10);
    freq.put("שנק", 7);
    freq.put("שנפ", 9);
    freq.put("שנת", 58);
    freq.put("שנר", 6);
    freq.put("שנש", 16);
    freq.put("זיז", 9);
    freq.put("זיה", 30);
    freq.put("זיו", 23);
    freq.put("זיכ", 11);
    freq.put("זיי", 29);
    freq.put("זין", 38);
    freq.put("זיל", 12);
    freq.put("זים", 40);
    freq.put("זיע", 7);
    freq.put("זינ", 16);
    freq.put("זיק", 64);
    freq.put("זית", 24);
    freq.put("זיר", 34);
    freq.put("עסו", 7);
    freq.put("ייץ", 76);
    freq.put("ייפ", 115);
    freq.put("ייק", 104);
    freq.put("ייצ", 96);
    freq.put("ייס", 149);
    freq.put("יינ", 158);
    freq.put("ייף", 29);
    freq.put("ייע", 15);
    freq.put("ייש", 42);
    freq.put("ייר", 65);
    freq.put("יית", 375);
    freq.put("ייו", 21);
    freq.put("ייה", 183);
    freq.put("ייח", 30);
    freq.put("ייז", 25);
    freq.put("ייב", 129);
    freq.put("ייא", 25);
    freq.put("ייד", 73);
    freq.put("ייג", 26);
    freq.put("יים", 858);
    freq.put("ייל", 142);
    freq.put("יין", 355);
    freq.put("יימ", 74);
    freq.put("ייי", 571);
    freq.put("ייט", 52);
    freq.put("ייכ", 20);
    freq.put("ייך", 145);
    freq.put("עסק", 33);
    freq.put("סת ", 81);
    freq.put("עסת", 7);
    freq.put("זכי", 46);
    freq.put(" 🙌", 8);
    freq.put(" 🙏", 7);
    freq.put("זכה", 13);
    freq.put("זכו", 64);
    freq.put("זכר", 70);
    freq.put(" 😔", 20);
    freq.put("ככל", 11);
    freq.put(" 😒", 14);
    freq.put(" 😓", 10);
    freq.put("ככה", 104);
    freq.put(" 😞", 7);
    freq.put(" 😘", 24);
    freq.put(" 😅", 21);
    freq.put("יכס", 25);
    freq.put("וקט", 15);
    freq.put(" 😁", 16);
    freq.put(" 😂", 130);
    freq.put("וקל", 23);
    freq.put("וקד", 56);
    freq.put(" 😍", 91);
    freq.put("וקב", 56);
    freq.put("וקא", 56);
    freq.put("וקח", 35);
    freq.put(" 😉", 15);
    freq.put("וקו", 66);
    freq.put("וקה", 53);
    freq.put("וקת", 6);
    freq.put("וקש", 11);
    freq.put("יכא", 24);
    freq.put(" 😰", 7);
    freq.put(" 😱", 17);
    freq.put("יכו", 410);
    freq.put("יכה", 124);
    freq.put("וקף", 8);
    freq.put("וקע", 6);
    freq.put("יכי", 85);
    freq.put("וקנ", 6);
    freq.put("יכן", 8);
    freq.put("וקצ", 7);
    freq.put("יכם", 26);
    freq.put("וקפ", 11);
    freq.put(" 😤", 6);
    freq.put(" 😠", 6);
    freq.put(" 😡", 26);
    freq.put(" 😭", 27);
    freq.put(" 😩", 8);
    freq.put(" 😪", 10);
    freq.put("נעו", 11);
    freq.put("נעל", 47);
    freq.put("נעמ", 9);
    freq.put("נעי", 34);
    freq.put("עי ", 66);
    freq.put("נעצ", 16);
    freq.put("נענ", 18);
    freq.put("נעש", 15);
    freq.put("נער", 23);
    freq.put("ه", 10);
    freq.put(" ש ", 93);
    freq.put("ירי", 226);
    freq.put("א?", 9);
    freq.put("הגי", 211);
    freq.put("א ", 5620);
    freq.put("הגל", 11);
    freq.put("הגמ", 11);
    freq.put("הגב", 58);
    freq.put("הגא", 8);
    freq.put("הגד", 73);
    freq.put("ישת", 26);
    freq.put("הגו", 37);
    freq.put("הגז", 15);
    freq.put("הגש", 13);
    freq.put("הגר", 25);
    freq.put("הגת", 8);
    freq.put("הגנ", 22);
    freq.put("הגע", 47);
    freq.put(" קח", 17);
    freq.put(" קה", 13);
    freq.put(" קו", 342);
    freq.put(" קד", 28);
    freq.put(" קא", 25);
    freq.put(" קב", 70);
    freq.put(" קמ", 53);
    freq.put(" קל", 71);
    freq.put(" קם", 9);
    freq.put(" קט", 109);
    freq.put(" קי", 177);
    freq.put(" קצ", 125);
    freq.put(" קק", 11);
    freq.put(" קפ", 42);
    freq.put(" קע", 8);
    freq.put(" קנ", 56);
    freq.put(" קס", 22);
    freq.put(" קר", 223);
    freq.put(" קש", 145);
    freq.put("עכש", 295);
    freq.put("עכב", 11);
    freq.put("סתי", 67);
    freq.put("סתכ", 53);
    freq.put("סתם", 83);
    freq.put("סתמ", 41);
    freq.put("כם ", 317);
    freq.put("סתב", 29);
    freq.put("יי?", 16);
    freq.put("סתד", 21);
    freq.put("סתה", 6);
    freq.put("סתו", 47);
    freq.put("יי ", 539);
    freq.put(" 👌", 40);
    freq.put(" 👍", 11);
    freq.put(" 👎", 8);
    freq.put(" 👏", 10);
    freq.put(" 👊", 14);
    freq.put(" 👋", 14);
    freq.put("וץ ", 262);
    freq.put("סתת", 7);
    freq.put("עס ", 9);
    freq.put("סתפ", 8);
    freq.put("בצר", 8);
    freq.put("בצפ", 32);
    freq.put("בצע", 40);
    freq.put("בצל", 11);
    freq.put("בצי", 32);
    freq.put("בצה", 11);
    freq.put("בצו", 12);
    freq.put("בצב", 8);
    freq.put("בצד", 20);
    freq.put("זי ", 26);
    freq.put("חם", 69);
    freq.put("יצה", 73);
    freq.put("יצו", 106);
    freq.put("יצח", 31);
    freq.put("יצא", 87);
    freq.put("יצב", 18);
    freq.put("יצל", 16);
    freq.put("יצן", 13);
    freq.put("יצט", 7);
    freq.put("יצי", 126);
    freq.put("יצפ", 9);
    freq.put("יצנ", 13);
    freq.put("יצע", 7);
    freq.put("יצר", 24);
    freq.put("יצת", 25);
    freq.put("גבע", 11);
    freq.put("גבר", 155);
    freq.put("שת ", 146);
    freq.put("גבו", 53);
    freq.put("טן ", 82);
    freq.put("אשי", 44);
    freq.put("גבל", 15);
    freq.put("גבי", 41);
    freq.put("תרג", 57);
    freq.put("ווש", 10);
    freq.put("רט ", 123);
    freq.put("תרח", 27);
    freq.put("אהר", 13);
    freq.put("קצת", 96);
    freq.put("תרי", 35);
    freq.put("קצר", 22);
    freq.put("קצי", 50);
    freq.put("קצב", 12);
    freq.put("קצה", 11);
    freq.put("קצו", 20);
    freq.put("אהל", 6);
    freq.put("אהי", 30);
    freq.put("אהו", 74);
    freq.put("אהה", 29);
    freq.put("אהב", 240);
    freq.put("רצי", 84);
    freq.put("רצל", 17);
    freq.put("רצא", 8);
    freq.put("תם ", 429);
    freq.put("רצו", 78);
    freq.put("אשת", 29);
    freq.put("רצח", 37);
    freq.put("אז ", 474);
    freq.put("תרצ", 13);
    freq.put("תרש", 7);
    freq.put("רצפ", 8);
    freq.put("תרת", 20);

    init3();
  }
  private static void init3() {
    
    freq.put("גן ", 88);
    freq.put("צאפ", 21);
    freq.put("צאנ", 7);
    freq.put("צאת", 134);
    freq.put("שעי", 15);
    freq.put("שעל", 19);
    freq.put("שעמ", 60);
    freq.put("שעב", 28);
    freq.put("שעד", 20);
    freq.put("שעה", 100);
    freq.put("שעו", 145);
    freq.put("שער", 29);
    freq.put("שעש", 37);
    freq.put("שעת", 32);
    freq.put("פדי", 12);
    freq.put("יפ ", 34);
    freq.put("צאו", 42);
    freq.put("צאה", 25);
    freq.put("צאי", 39);
    freq.put("　　　", 7);
    freq.put("לאר", 43);
    freq.put("יא ", 643);
    freq.put("כון", 151);
    freq.put("פץ ", 11);
    freq.put("ה?", 46);
    freq.put("סר ", 76);
    freq.put("מכא", 10);
    freq.put("מכב", 36);
    freq.put("מכה", 7);
    freq.put("מכו", 142);
    freq.put("מכי", 132);
    freq.put("מכל", 41);
    freq.put("מכם", 19);
    freq.put("ה ", 16584);
    freq.put("מכנ", 14);
    freq.put("מכר", 25);
    freq.put("מכש", 17);
    freq.put("מכת", 29);
    freq.put("לץ ", 16);
    freq.put("אדמ", 17);
    freq.put("לקט", 16);
    freq.put("לקי", 38);
    freq.put("לקל", 11);
    freq.put("אדם", 134);
    freq.put("לקח", 50);
    freq.put("לקה", 18);
    freq.put("לקו", 100);
    freq.put("יזכ", 14);
    freq.put("לקת", 12);
    freq.put("לקר", 48);
    freq.put("לקנ", 41);
    freq.put("תמל", 6);
    freq.put("לקצ", 6);
    freq.put("לקפ", 9);
    freq.put("כד", 185);
    freq.put("כב", 651);
    freq.put("כא", 311);
    freq.put("כח", 121);
    freq.put("כז", 207);
    freq.put("כו", 1677);
    freq.put("ג׳", 43);
    freq.put("ככ", 128);
    freq.put("כך", 182);
    freq.put("כי", 1380);
    freq.put("כט", 6);
    freq.put("כן", 382);
    freq.put("כמ", 685);
    freq.put("כם", 344);
    freq.put("כל", 1593);
    freq.put("גפ", 8);
    freq.put("בתי", 188);
    freq.put("בתכ", 10);
    freq.put("גנ", 162);
    freq.put("גס", 10);
    freq.put("גע", 530);
    freq.put("בתא", 30);
    freq.put("בתג", 10);
    freq.put("בתה", 6);
    freq.put("בתו", 75);
    freq.put("גת", 64);
    freq.put("בתח", 32);
    freq.put("גה", 87);
    freq.put("בתש", 9);
    freq.put("בתת", 12);
    freq.put("גח", 6);
    freq.put("גא", 105);
    freq.put("גב", 339);
    freq.put("גג", 42);
    freq.put("כ״", 7);
    freq.put("בתנ", 7);
    freq.put("גם", 517);
    freq.put("גמ", 173);
    freq.put("גן", 98);
    freq.put("גט", 21);
    freq.put("גי", 1029);
    freq.put("בתק", 7);
    freq.put("כף", 15);
    freq.put("כע", 15);
    freq.put("כס", 93);
    freq.put("כנ", 489);
    freq.put("כפ", 132);
    freq.put("כת", 450);
    freq.put("כש", 663);
    freq.put("כר", 365);
    freq.put("פקק", 8);
    freq.put("פקת", 23);
    freq.put("פקד", 13);
    freq.put("פקה", 6);
    freq.put("פקו", 14);
    freq.put("פקט", 17);
    freq.put("פקי", 31);
    freq.put(" ", 7);
    freq.put("קעק", 8);
    freq.put("קעת", 7);
    freq.put("כת ", 230);
    freq.put("ןן", 281);
    freq.put("ןכ", 7);
    freq.put("ןו", 16);
    freq.put("ןד", 12);
    freq.put("ןא", 8);
    freq.put("🎈", 6);
    freq.put("🎉", 7);
    freq.put("שפל", 11);
    freq.put("שפם", 6);
    freq.put("שפט", 50);
    freq.put("שפי", 30);
    freq.put("שפח", 67);
    freq.put("שפה", 9);
    freq.put("שפו", 30);
    freq.put("שפג", 8);
    freq.put("ר״", 11);
    freq.put("רת", 940);
    freq.put("רר", 318);
    freq.put("רש", 247);
    freq.put("רע", 203);
    freq.put("רף", 81);
    freq.put("רנ", 203);
    freq.put("רס", 312);
    freq.put("רצ", 273);
    freq.put("רק", 715);
    freq.put("רפ", 142);
    freq.put("רץ", 99);
    freq.put("רך", 208);
    freq.put("רכ", 281);
    freq.put("רט", 466);
    freq.put("רי", 3202);
    freq.put("רמ", 273);
    freq.put("רן", 74);
    freq.put("רל", 95);
    freq.put("רם", 84);
    freq.put("רג", 703);
    freq.put("רד", 325);
    freq.put("רא", 1498);
    freq.put("רב", 645);
    freq.put("רז", 80);
    freq.put("רח", 269);
    freq.put("רה", 1106);
    freq.put("רו", 2820);
    freq.put("נצ ", 11);
    freq.put("🏄", 6);
    freq.put("שפת", 22);
    freq.put("שפר", 13);
    freq.put("שפש", 6);
    freq.put(" 😳", 19);
    freq.put("שפע", 25);
    freq.put("כן ", 350);
    freq.put("יםם", 56);
    freq.put("ין ", 1411);
    freq.put("וף ", 324);
    freq.put("וסי", 119);
    freq.put("וסט", 68);
    freq.put("וסל", 17);
    freq.put("וסמ", 10);
    freq.put("וסב", 10);
    freq.put("וסא", 12);
    freq.put("וסד", 11);
    freq.put("וסו", 26);
    freq.put("וסה", 12);
    freq.put("וסר", 39);
    freq.put("זן ", 17);
    freq.put("וסס", 11);
    freq.put("וסף", 31);
    freq.put("וסע", 20);
    freq.put("וספ", 57);
    freq.put("וסק", 16);
    freq.put("דעד", 7);
    freq.put("נרי", 14);
    freq.put("דעה", 81);
    freq.put("דעו", 51);
    freq.put("נרד", 16);
    freq.put("נרג", 26);
    freq.put("נרא", 206);
    freq.put("צה ", 449);
    freq.put("דעת", 233);
    freq.put("טב ", 14);
    freq.put("רך ", 204);
    freq.put("כונ", 107);
    freq.put("אט ", 29);
    freq.put("פ", 8303);
    freq.put("אפק", 7);
    freq.put("", 7);
    freq.put("קע ", 37);
    freq.put("גם ", 507);
    freq.put("פק ", 39);
    freq.put("וצו", 38);
    freq.put("ג ", 591);
    freq.put(" עו", 902);
    freq.put("בת ", 624);
    freq.put("כ ", 104);
    freq.put("יךך", 10);
    freq.put("נמש", 13);
    freq.put("נמר", 7);
    freq.put("הוס", 29);
    freq.put("נמס", 9);
    freq.put("נמצ", 32);
    freq.put("נמי", 12);
    freq.put("נמל", 11);
    freq.put(" עי", 192);
    freq.put("נמו", 14);
    freq.put(" עכ", 282);
    freq.put("לק ", 89);
    freq.put(" עפ", 14);
    freq.put(" עצ", 253);
    freq.put("הול", 208);
    freq.put(" עף", 6);
    freq.put("סרת", 14);
    freq.put("ה״", 11);
    freq.put(" ער", 152);
    freq.put("בפו", 20);
    freq.put("הת", 815);
    freq.put("בפא", 11);
    freq.put("הש", 814);
    freq.put("הצ", 398);
    freq.put("הק", 406);
    freq.put("בפל", 9);
    freq.put("הע", 482);
    freq.put("הנ", 335);
    freq.put("בפי", 110);
    freq.put("המ", 1276);
    freq.put("הן", 117);
    freq.put("הל", 440);
    freq.put("הם", 513);
    freq.put("בפע", 22);
    freq.put("הכ", 747);
    freq.put("הט", 221);
    freq.put("בפס", 8);
    freq.put("הז", 580);
    freq.put("הח", 698);
    freq.put("הה", 1106);
    freq.put("הו", 2166);
    freq.put("בפת", 9);
    freq.put("הד", 375);
    freq.put("בפר", 44);
    freq.put("הב", 1403);
    freq.put("סרב", 6);
    freq.put("סרו", 16);
    freq.put("סרט", 159);
    freq.put("סרי", 39);
    freq.put("נ", 14717);
    freq.put("תכת", 19);
    freq.put("תכנ", 38);
    freq.put("תכף", 6);
    freq.put("אטר", 12);
    freq.put("אטס", 22);
    freq.put("אטי", 14);
    freq.put("אטמ", 6);
    freq.put("אטו", 8);
    freq.put("אטה", 9);
    freq.put("תכל", 66);
    freq.put("תכם", 65);
    freq.put("תכן", 8);
    freq.put("תכי", 12);
    freq.put("תכו", 74);
    freq.put("לטר", 12);
    freq.put("טבי", 10);
    freq.put("טבו", 11);
    freq.put("טבח", 14);
    freq.put("טבע", 29);
    freq.put("שצו", 9);
    freq.put("שצי", 8);
    freq.put("צהר", 30);
    freq.put("צהו", 7);
    freq.put("צהה", 7);
    freq.put("דע ", 140);
    freq.put("נר ", 16);
    freq.put("שצר", 29);
    freq.put("ת״ ", 6);
    freq.put("וס ", 212);
    freq.put("יןן", 17);
    freq.put("ים ", 6365);
    freq.put("וףף", 16);
    freq.put("לטי", 32);
    freq.put("כןן", 9);
    freq.put("ים?", 22);
    freq.put("לדו", 52);
    freq.put("ר?", 16);
    freq.put("נצח", 36);
    freq.put("נצי", 24);
    freq.put("נצל", 20);
    freq.put("דנט", 10);
    freq.put("דני", 50);
    freq.put("ר ", 6064);
    freq.put("דנד", 7);
    freq.put("דנה", 11);
    freq.put("דנו", 14);
    freq.put("דנק", 8);
    freq.put("פונ", 48);
    freq.put("פוס", 45);
    freq.put("נצר", 8);
    freq.put("פוע", 34);
    freq.put("פופ", 10);
    freq.put("פוצ", 15);
    freq.put("פוק", 30);
    freq.put("ן?", 10);
    freq.put("טד ", 12);
    freq.put("ן ", 5016);
    freq.put("רל ", 19);
    freq.put("חו ", 70);
    freq.put("?🎶", 11);
    freq.put("הקד", 12);
    freq.put("הקא", 7);
    freq.put("הקב", 14);
    freq.put("הקה", 9);
    freq.put("הקו", 91);
    freq.put("הקט", 60);
    freq.put("הקי", 34);
    freq.put("הקמ", 12);
    freq.put("הקל", 38);
    freq.put("תי ", 2189);
    freq.put(" ?", 790);
    freq.put("הקנ", 8);
    freq.put("הקצ", 13);
    freq.put("הקפ", 9);
    freq.put("הקת", 6);
    freq.put("הקר", 45);
    freq.put("הקש", 35);
    freq.put("גין", 10);
    freq.put("גיל", 129);
    freq.put("גים", 49);
    freq.put("גיט", 20);
    freq.put("גיי", 43);
    freq.put("גיז", 6);
    freq.put("גיה", 29);
    freq.put("גיו", 65);
    freq.put("גיג", 15);
    freq.put("גיד", 201);
    freq.put("גיא", 12);
    freq.put("גיב", 32);
    freq.put("פוט", 26);
    freq.put("גית", 17);
    freq.put("גיר", 15);
    freq.put("גיש", 120);
    freq.put("גיע", 170);
    freq.put("פוך", 25);
    freq.put("גינ", 36);
    freq.put("פול", 114);
    freq.put("פומ", 6);
    freq.put("פון", 148);
    freq.put("פוא", 25);
    freq.put("אלו", 147);
    freq.put("אלה", 297);
    freq.put("אלד", 10);
    freq.put("אלג", 6);
    freq.put("אלב", 24);
    freq.put("אלא", 33);
    freq.put("אלמ", 18);
    freq.put("אלל", 43);
    freq.put("אלכ", 18);
    freq.put("אלך", 15);
    freq.put("אלי", 420);
    freq.put("אלט", 6);
    freq.put("אלק", 11);
    freq.put("מקו", 225);
    freq.put("פוד", 10);
    freq.put("אלף", 28);
    freq.put("מקב", 38);
    freq.put("אלנ", 10);
    freq.put("מקל", 26);
    freq.put("אלת", 26);
    freq.put("פוז", 24);
    freq.put("פוח", 20);
    freq.put("פס ", 41);
    freq.put("תחר", 53);
    freq.put("תחש", 25);
    freq.put("תחת", 137);
    freq.put("תחנ", 27);
    freq.put("תחפ", 8);
    freq.put("מז ", 11);
    freq.put("תחי", 187);
    freq.put("תחל", 35);
    freq.put("תחמ", 6);
    freq.put("תחב", 50);
    freq.put("תחד", 9);
    freq.put("תחה", 10);
    freq.put("תחו", 46);
    freq.put("תחז", 26);
    freq.put("רמנ", 26);
    freq.put("רמר", 6);
    freq.put("רמת", 30);
    freq.put("חחח", 3782);
    freq.put("רמו", 47);
    freq.put("רמה", 30);
    freq.put("רמז", 13);
    freq.put("רמי", 37);
    freq.put("רמט", 12);
    freq.put("חחי", 7);
    freq.put("רמל", 24);
    freq.put("רמן", 26);
    freq.put("בר ", 1091);
    freq.put("טוו", 253);
    freq.put("טוח", 75);
    freq.put("טוא", 13);
    freq.put("😤?", 8);
    freq.put("טוג", 7);
    freq.put("טוד", 13);
    freq.put("םם", 308);
    freq.put("טום", 20);
    freq.put("טומ", 45);
    freq.put("טון", 85);
    freq.put("טוט", 19);
    freq.put("טוי", 46);
    freq.put("ם״", 9);
    freq.put("שרק", 19);
    freq.put("טופ", 20);
    freq.put("טוק", 15);
    freq.put("טונ", 17);
    freq.put("טוס", 38);
    freq.put("טוע", 19);
    freq.put("טוף", 10);
    freq.put("טור", 132);
    freq.put("טוש", 10);
    freq.put("טות", 40);
    freq.put("צ׳", 16);
    freq.put("צנ", 46);
    freq.put("צע", 223);
    freq.put("צף", 8);
    freq.put("צפ", 176);
    freq.put("צטר", 33);
    freq.put("צצ", 26);
    freq.put("צק", 8);
    freq.put("צר", 475);
    freq.put("צת", 167);
    freq.put("צטע", 20);
    freq.put("צא", 409);
    freq.put("צב", 355);
    freq.put("צג", 22);
    freq.put("צד", 101);
    freq.put("חר ", 254);
    freq.put("צו", 650);
    freq.put("צח", 281);
    freq.put("צט", 73);
    freq.put("ר", 22094);
    freq.put("צל", 345);
    freq.put("צם", 33);
    freq.put("צמ", 286);
    freq.put("צן", 20);
    freq.put("שו ", 96);
    freq.put("תוה", 14);
    freq.put("אממ", 13);
    freq.put("אמב", 17);
    freq.put("אסף", 9);
    freq.put("אספ", 14);
    freq.put("אמא", 160);
    freq.put("אסר", 7);
    freq.put("אסת", 13);
    freq.put("אסד", 8);
    freq.put("אסה", 9);
    freq.put("אסו", 40);
    freq.put("אסט", 23);
    freq.put("אסי", 31);
    freq.put("מי ", 709);
    freq.put("תון", 22);
    freq.put("כלס", 10);
    freq.put("אמת", 192);
    freq.put("ו", 44849);
    freq.put("׳י", 16);
    freq.put("׳מ", 9);
    freq.put("ת״", 16);
    freq.put("׳א", 8);
    freq.put("׳ו", 13);
    freq.put("ת׳", 7);
    freq.put("תר", 906);
    freq.put("תש", 161);
    freq.put("תת", 469);
    freq.put("תפ", 258);
    freq.put("תצ", 44);
    freq.put("תק", 442);
    freq.put("תנ", 384);
    freq.put("תס", 49);
    freq.put("תע", 312);
    freq.put("תף", 24);
    freq.put("תל", 234);
    freq.put("תם", 446);
    freq.put("תמ", 662);
    freq.put("תן", 154);
    freq.put("תט", 16);
    freq.put("תי", 3094);
    freq.put("תך", 366);
    freq.put("תכ", 297);
    freq.put("תה", 1160);
    freq.put("תו", 1172);
    freq.put("תז", 55);
    freq.put("תח", 697);
    freq.put("תא", 332);
    freq.put("תב", 312);
    freq.put("תג", 264);
    freq.put("תד", 82);
    freq.put("׳ס", 8);
    freq.put("׳ק", 8);
    freq.put("מןן", 7);
    freq.put("כוש", 26);
    freq.put("שט", 162);
    freq.put("כור", 93);
    freq.put("נת ", 256);
    freq.put("ון ", 1456);
    freq.put("חתן", 19);
    freq.put("כוס", 64);
    freq.put("חתי", 143);
    freq.put("חתו", 80);
    freq.put("ון?", 7);
    freq.put("חתנ", 10);
    freq.put("זף ", 6);
    freq.put(" רא", 293);
    freq.put("⃣ ", 6);
    freq.put("רצה", 20);
    freq.put("יד ", 602);
    freq.put("שך ", 48);
    freq.put("צ ", 126);
    freq.put("חרו", 156);
    freq.put("חרא", 35);
    freq.put("חרב", 7);
    freq.put("חרד", 24);
    freq.put("חרמ", 17);
    freq.put("חרט", 7);
    freq.put("חרי", 260);
    freq.put("חרפ", 8);
    freq.put("חרק", 17);
    freq.put("חרר", 33);
    freq.put("חרת", 68);
    freq.put("לסמ", 10);
    freq.put("לסט", 31);
    freq.put("לסי", 29);
    freq.put("לסו", 29);
    freq.put("לסב", 16);
    freq.put("לסג", 10);
    freq.put("לסד", 11);
    freq.put("ב", 22177);
    freq.put("ם?", 41);
    freq.put("טו ", 89);
    freq.put("ם ", 12439);
    freq.put("לספ", 39);
    freq.put("לסק", 6);
    freq.put("לסנ", 7);
    freq.put("ברג", 56);
    freq.put("ברד", 10);
    freq.put("ברא", 47);
    freq.put("ברב", 21);
    freq.put("ברז", 17);
    freq.put("ברח", 45);
    freq.put("ברה", 135);
    freq.put("ברו", 212);
    freq.put("ברך", 12);
    freq.put("ברכ", 28);
    freq.put("חח?", 7);
    freq.put("ברי", 524);
    freq.put("ברמ", 25);
    freq.put("ברל", 12);
    freq.put("🙏?", 10);
    freq.put("חח ", 477);
    freq.put("ברנ", 24);
    freq.put("ברס", 10);
    freq.put("ברצ", 18);
    freq.put("ברק", 34);
    freq.put("ברת", 139);
    freq.put("ברר", 27);
    freq.put("ברש", 17);
    freq.put("פספ", 13);
    freq.put("פסק", 28);
    freq.put("פסת", 30);
    freq.put("תח ", 66);
    freq.put("פסה", 6);
    freq.put("פסו", 16);
    freq.put("פסח", 24);
    freq.put("פסד", 11);
    freq.put("פסל", 12);
    freq.put("פסט", 26);
    freq.put("פסי", 126);
    freq.put("סנט", 8);
    freq.put("לדפ", 10);
    freq.put("מק ", 34);
    freq.put("אל ", 436);
    freq.put("מסע", 30);
    freq.put("מסנ", 11);
    freq.put("מסק", 21);
    freq.put("מספ", 113);
    freq.put("מסת", 88);
    freq.put("מסר", 31);
    freq.put("מסג", 7);
    freq.put("מסד", 9);
    freq.put("מסב", 18);
    freq.put("מסו", 66);
    freq.put("מסך", 13);
    freq.put("מסכ", 37);
    freq.put("מסט", 18);
    freq.put("מסי", 72);
    freq.put("מסמ", 6);
    freq.put("גי ", 43);
    freq.put(" ע", 4841);
    freq.put(" נ", 2354);
    freq.put(" ס", 1460);
    freq.put(" צ", 982);
    freq.put(" ק", 1578);
    freq.put(" פ", 1760);
    freq.put(" ת", 2429);
    freq.put(" ר", 2222);
    freq.put(" ש", 10130);
    freq.put("תיק", 56);
    freq.put("תיפ", 6);
    freq.put("תיע", 23);
    freq.put("תינ", 35);
    freq.put("תית", 73);
    freq.put("תיר", 37);
    freq.put("תיש", 21);
    freq.put("תיח", 27);
    freq.put("תיה", 34);
    freq.put("תיו", 48);
    freq.put("תיד", 30);
    freq.put("תיא", 12);
    freq.put("תיב", 10);
    freq.put("תימ", 16);
    freq.put("תין", 7);
    freq.put("תים", 48);
    freq.put("תיך", 34);
    freq.put("תיכ", 40);
    freq.put("תיי", 221);
    freq.put(" ג", 1516);
    freq.put(" ד", 1261);
    freq.put(" א", 14786);
    freq.put(" ב", 8652);
    freq.put(" ז", 2339);
    freq.put(" ח", 3178);
    freq.put(" ה", 12236);
    freq.put(" ו", 3825);
    freq.put(" ך", 8);
    freq.put(" כ", 4357);
    freq.put(" ט", 1187);
    freq.put(" י", 4590);
    freq.put(" מ", 10452);
    freq.put(" ן", 16);
    freq.put(" ל", 13211);
    freq.put(" ם", 16);
    freq.put("פה ", 643);
    freq.put("רלנ", 7);
    freq.put("חוף", 31);
    freq.put("חוס", 30);
    freq.put("חונ", 16);
    freq.put("חוק", 130);
    freq.put("חוצ", 16);
    freq.put("חוץ", 78);
    freq.put("חופ", 104);
    freq.put("חות", 297);
    freq.put("חוש", 217);
    freq.put("חור", 226);
    freq.put("חוד", 88);
    freq.put("חוג", 21);
    freq.put("חוב", 83);
    freq.put("חוז", 73);
    freq.put("חוו", 35);
    freq.put("חוכ", 7);
    freq.put("חוי", 10);
    freq.put("חוט", 11);
    freq.put("חון", 30);
    freq.put("חומ", 50);
    freq.put("חום", 29);
    freq.put("חול", 179);
    freq.put("רלי", 43);
    freq.put("רלו", 9);
    freq.put("😢?", 6);
    freq.put("לף ", 54);
    freq.put("ידך", 9);
    freq.put("ידי", 268);
    freq.put("ידן", 18);
    freq.put("ידל", 9);
    freq.put("ידב", 6);
    freq.put("ידא", 21);
    freq.put("ידו", 130);
    freq.put("ידה", 118);
    freq.put("ידת", 12);
    freq.put("ידר", 25);
    freq.put(" م", 9);
    freq.put("ידע", 66);
    freq.put("ידנ", 8);
    freq.put("ידפ", 6);
    freq.put(" ا", 17);
    freq.put(" ت", 6);
    freq.put("חת ", 371);
    freq.put("וןן", 20);
    freq.put("דפו", 20);
    freq.put("נתן", 16);
    freq.put("נתי", 173);
    freq.put("נתו", 8);
    freq.put("נתה", 15);
    freq.put("נתח", 11);
    freq.put("דפי", 14);
    freq.put("מן ", 387);
    freq.put("מקא", 11);
    freq.put("דפק", 26);
    freq.put("דפנ", 6);
    freq.put("דפס", 6);
    freq.put("נתת", 10);
    freq.put("נתפ", 6);
    freq.put("נתק", 28);
    freq.put("נתנ", 55);
    freq.put("ת?", 32);
    freq.put("לרד", 10);
    freq.put("ת ", 12501);
    freq.put("ל", 32861);
    freq.put("׳ ", 46);
    freq.put("👋?", 8);
    freq.put("👋 ", 6);
    freq.put("כלא", 15);
    freq.put("אס ", 67);
    freq.put("מיכ", 39);
    freq.put("מיט", 59);
    freq.put("מיי", 166);
    freq.put("מימ", 54);
    freq.put("מין", 112);
    freq.put("מיל", 190);
    freq.put("מים", 369);
    freq.put("מיג", 9);
    freq.put("מיד", 258);
    freq.put("מיא", 14);
    freq.put("מיז", 8);
    freq.put("מיח", 8);
    freq.put("מיה", 12);
    freq.put("מיו", 120);
    freq.put("מית", 167);
    freq.put("מיר", 48);
    freq.put("מיש", 294);
    freq.put("מיע", 6);
    freq.put("😅?", 16);
    freq.put("מיס", 11);
    freq.put("מיצ", 18);
    freq.put("מיק", 46);
    freq.put("מיץ", 6);
    freq.put("ום ", 1366);
    freq.put("חדד", 7);
    freq.put("חדו", 14);
    freq.put("חדי", 17);
    freq.put("גע ", 200);
    freq.put("חדש", 285);
    freq.put("חדר", 47);
    freq.put("חדת", 32);
    freq.put("ل", 24);
    freq.put("רגש", 86);
    freq.put("רגר", 12);
    freq.put("רגת", 11);
    freq.put("י", 55331);
    freq.put("רגנ", 24);
    freq.put("רגע", 196);
    freq.put("רגל", 76);
    freq.put("רגן", 16);
    freq.put("רגמ", 7);
    freq.put("רגי", 158);
    freq.put("רגו", 47);
    freq.put("יתו", 115);
    freq.put("יב ", 236);
    freq.put("שט ", 10);
    freq.put("צלי", 102);
    freq.put("צלך", 13);
    freq.put("צלם", 18);
    freq.put("צלמ", 14);
    freq.put("צלו", 10);
    freq.put("צלה", 10);
    freq.put("צלח", 69);
    freq.put("צלת", 6);
    freq.put("צלנ", 13);
    freq.put("צלצ", 11);
    freq.put("טשי", 8);
    freq.put(" אד", 168);
    freq.put(" אג", 80);
    freq.put(" אב", 731);
    freq.put(" אא", 16);
    freq.put(" אח", 901);
    freq.put(" אז", 370);
    freq.put(" או", 2514);
    freq.put(" אה", 318);
    freq.put(" אכ", 87);
    freq.put(" אך", 22);
    freq.put(" אי", 1762);
    freq.put(" אט", 12);
    freq.put(" אן", 7);
    freq.put(" אמ", 482);
    freq.put(" אם", 466);
    freq.put(" אל", 623);
    freq.put(" אף", 72);
    freq.put(" אע", 28);
    freq.put(" אס", 86);
    freq.put(" אנ", 2317);
    freq.put(" אק", 51);
    freq.put(" אצ", 101);
    freq.put(" אפ", 274);
    freq.put("שמה", 55);
    freq.put(" את", 2898);
    freq.put(" אש", 130);
    freq.put(" אר", 186);
    freq.put("שמא", 44);
    freq.put("שמב", 22);
    freq.put("שמג", 16);
    freq.put("שמד", 20);
    freq.put("יחח", 9);
    freq.put("יחז", 18);
    freq.put("יחו", 91);
    freq.put("יחה", 137);
    freq.put("יחד", 50);
    freq.put("יחל", 10);
    freq.put("זקנ", 17);
    freq.put("יחי", 112);
    freq.put("גנב", 10);
    freq.put("גנו", 31);
    freq.put("גנה", 20);
    freq.put("גני", 57);
    freq.put("גנט", 14);
    freq.put("רא ", 106);
    freq.put("חב ", 7);
    freq.put("גנת", 15);
    freq.put("יחס", 60);
    freq.put("זקה", 7);
    freq.put("זקו", 13);
    freq.put("יחת", 21);
    freq.put("יחש", 12);
    freq.put("יחר", 6);
    freq.put("וכת", 7);
    freq.put("וכש", 13);
    freq.put("וכר", 80);
    freq.put("וכנ", 80);
    freq.put("וכן", 45);
    freq.put("וכמ", 28);
    freq.put("וכל", 142);
    freq.put("וכי", 52);
    freq.put("וכח", 33);
    freq.put("וכז", 7);
    freq.put("וכו", 35);
    freq.put("וכה", 67);
    freq.put("וכב", 35);
    freq.put("וכא", 13);
    freq.put("מץ ", 13);
    freq.put("תו ", 297);
    freq.put("קר ", 352);
    freq.put("סדי", 6);
    freq.put("לוא", 16);
    freq.put("לוב", 47);
    freq.put("לוג", 70);
    freq.put("לוה", 62);
    freq.put("לוו", 138);
    freq.put("לוז", 8);
    freq.put("לוח", 54);
    freq.put("לוט", 23);
    freq.put("לוי", 62);
    freq.put("לול", 73);
    freq.put("לום", 187);
    freq.put("לומ", 104);
    freq.put("לון", 92);
    freq.put("לונ", 69);
    freq.put("לוס", 23);
    freq.put("לוף", 8);
    freq.put("לופ", 19);
    freq.put("לוץ", 7);
    freq.put("לוצ", 6);
    freq.put("לוק", 74);
    freq.put("לור", 15);
    freq.put("לוש", 75);
    freq.put("לות", 185);
    freq.put("ליי", 462);
    freq.put("סדנ", 6);
    freq.put("סדר", 123);
    freq.put("״א ", 9);
    freq.put("מדי", 176);
    freq.put("מדמ", 12);
    freq.put("מדב", 99);
    freq.put("מדה", 68);
    freq.put("מדו", 71);
    freq.put("מדר", 27);
    freq.put("מדת", 52);
    freq.put("מדע", 16);
    freq.put("ي ", 11);
    freq.put(" ⃣ ", 6);
    freq.put("😠?", 6);
    freq.put("בגר", 28);
    freq.put("בגב", 7);
    freq.put("בגד", 35);
    freq.put("בגו", 25);
    freq.put("מם ", 90);
    freq.put("בגי", 33);
    freq.put("בגל", 105);
    freq.put("בגן", 7);
    freq.put("שר", 1023);
    freq.put("צוץ", 14);
    freq.put("צף ", 8);
    freq.put("כעת", 7);
    freq.put("צור", 71);
    freq.put("כעס", 6);
    freq.put("קתי", 46);
    freq.put("צוו", 31);
    freq.put("תדא", 13);
    freq.put("תדל", 6);
    freq.put("צוד", 23);
    freq.put("צוא", 33);
    freq.put("תדע", 29);
    freq.put("צוב", 66);
    freq.put("תדר", 22);
    freq.put("שב", 1161);
    freq.put("צון", 14);
    freq.put("צול", 24);
    freq.put("צום", 22);
    freq.put("כנה", 40);
    freq.put("כנו", 41);
    freq.put("כנז", 9);
    freq.put("כני", 97);
    freq.put("שז", 150);
    freq.put("לו ", 651);
    freq.put("כננ", 6);
    freq.put("כנס", 166);
    freq.put("כנע", 18);
    freq.put("סד ", 18);
    freq.put("כנר", 54);
    freq.put("כנת", 37);
    freq.put("קרה", 125);
    freq.put("קרו", 132);
    freq.put("קרא", 74);
    freq.put("קרב", 28);
    freq.put("קרד", 6);
    freq.put("קרל", 8);
    freq.put("קרמ", 8);
    freq.put("קרן", 21);
    freq.put("קרט", 16);
    freq.put("קרי", 123);
    freq.put("אמי", 216);
    freq.put("תוד", 127);
    freq.put("תוא", 6);
    freq.put("תוב", 70);
    freq.put("תוח", 45);
    freq.put("אמן", 38);
    freq.put("תוו", 37);
    freq.put("תוך", 48);
    freq.put("תוכ", 72);
    freq.put("אף ", 118);
    freq.put("תוי", 7);
    freq.put("תומ", 37);
    freq.put("אמה", 12);
    freq.put("תול", 62);
    freq.put("תום", 16);
    freq.put("אמש", 11);
    freq.put("אמר", 237);
    freq.put("תונ", 49);
    freq.put("תוס", 16);
    freq.put("תוצ", 18);
    freq.put("תוק", 50);
    freq.put("תופ", 17);
    freq.put("תות", 46);
    freq.put("אמנ", 21);
    freq.put("תור", 74);
    freq.put("תוש", 19);
    freq.put("אמק", 9);
    freq.put("אמצ", 48);
    freq.put("קרק", 8);
    freq.put("קרנ", 19);
    freq.put("קרע", 8);
    freq.put("קרר", 10);
    freq.put("קרת", 16);
    freq.put("לקב", 41);
    freq.put("זק ", 49);
    freq.put("ראת", 64);
    freq.put("ראש", 352);
    freq.put("חבת", 7);
    freq.put("יכת", 21);
    freq.put("חבר", 409);
    freq.put("חבק", 23);
    freq.put("ראנ", 11);
    freq.put("ראק", 7);
    freq.put("ראי", 209);
    freq.put("חבל", 41);
    freq.put("ראן", 20);
    freq.put("חבי", 42);
    freq.put("ראל", 236);
    freq.put("חבו", 17);
    freq.put("ראו", 191);
    freq.put("ראה", 260);
    freq.put("יח ", 147);
    freq.put("טחי", 11);
    freq.put("טחו", 24);
    freq.put("צמח", 13);
    freq.put("צמו", 28);
    freq.put("צמה", 18);
    freq.put("צמא", 25);
    freq.put("צמן", 10);
    freq.put("צמם", 20);
    freq.put("צמך", 27);
    freq.put("צמי", 120);
    freq.put("צמר", 7);
    freq.put(" א ", 71);
    freq.put("טחת", 6);
    freq.put("שטר", 38);
    freq.put("צל ", 60);
    freq.put("ג׳מ", 7);
    freq.put("שטי", 24);
    freq.put("שטן", 7);
    freq.put("שטח", 14);
    freq.put("שטו", 49);
    freq.put("יבל", 55);
    freq.put("יבן", 6);
    freq.put("יבי", 164);
    freq.put("יבך", 6);
    freq.put("יבו", 216);
    freq.put("יבה", 96);
    freq.put("יבח", 6);
    freq.put("יבב", 8);
    freq.put("רג ", 43);
    freq.put("יבד", 17);
    freq.put("יבש", 13);
    freq.put("יבר", 92);
    freq.put("יבת", 66);
    freq.put("יבק", 6);
    freq.put("ح", 10);
    freq.put("יבנ", 14);
    freq.put("עשת", 16);
    freq.put("עשר", 37);
    freq.put("עשע", 7);
    freq.put("עשנ", 6);
    freq.put("געת", 110);
    freq.put("חד ", 394);
    freq.put("לקס", 9);
    freq.put("געי", 77);
    freq.put("געו", 11);
    freq.put("געה", 14);
    freq.put("געג", 98);
    freq.put("עשן", 16);
    freq.put("עשי", 97);
    freq.put("וםם", 17);
    freq.put("עשה", 95);
    freq.put("עשו", 182);
    freq.put("עצר", 38);
    freq.put("כה", 469);
    freq.put("קת ", 129);
    freq.put("לשר", 16);
    freq.put("בתל", 30);
    freq.put("בתמ", 16);
    freq.put("גר", 488);
    freq.put("גש", 202);
    freq.put("בג ", 13);
    freq.put("גו", 618);
    freq.put("גז", 72);
    freq.put("גד", 341);
    freq.put("גל", 459);
    freq.put("טא ", 9);
    freq.put("מד ", 83);
    freq.put("הסו", 54);
    freq.put("הסח", 6);
    freq.put("הסב", 34);
    freq.put("״אנ", 7);
    freq.put("הסל", 16);
    freq.put("הסמ", 8);
    freq.put("הסט", 24);
    freq.put("הסי", 68);
    freq.put("הסכ", 19);
    freq.put("הספ", 66);
    freq.put("הסק", 6);
    freq.put("הסר", 28);
    freq.put("הסת", 77);
    freq.put("ליש", 161);
    freq.put("וחת", 36);
    freq.put("וחש", 9);
    freq.put("וחר", 36);
    freq.put("וחנ", 10);
    freq.put("וחק", 38);
    freq.put("וחצ", 30);
    freq.put("אקט", 12);
    freq.put("אקי", 25);
    freq.put(" 　", 18);
    freq.put("וחמ", 14);
    freq.put("וחל", 16);
    freq.put("וחד", 70);
    freq.put("וחב", 9);
    freq.put("וחח", 8);
    freq.put("וחז", 8);
    freq.put("אקר", 11);
    freq.put("וחה", 55);
    freq.put("פל ", 64);
    freq.put("דלת", 21);
    freq.put("דלק", 13);
    freq.put("תתת", 141);
    freq.put("תתר", 11);
    freq.put("תתק", 22);
    freq.put("תתפ", 23);
    freq.put("תתף", 11);
    freq.put("תתע", 9);
    freq.put("תתן", 7);
    freq.put("תתמ", 7);
    freq.put("תתי", 9);
    freq.put("תתח", 29);
    freq.put("לח ", 77);
    freq.put("תתג", 7);
    freq.put("תתא", 7);
    freq.put("דלי", 44);
    freq.put("דלו", 12);
    freq.put("סחי", 21);
    freq.put("דך ", 10);
    freq.put("לבל", 30);
    freq.put("רשע", 9);
    freq.put("לבן", 36);
    freq.put("לבט", 13);
    freq.put("לבי", 118);
    freq.put("לבכ", 17);
    freq.put("רשר", 6);
    freq.put("לבו", 100);
    freq.put("רשת", 47);
    freq.put("לבח", 26);
    freq.put("לבב", 9);
    freq.put("😁?", 17);
    freq.put("לבד", 73);
    freq.put("רשה", 8);
    freq.put("רשו", 38);
    freq.put("לבת", 11);
    freq.put("רשי", 42);
    freq.put("לבצ", 11);
    freq.put("לבק", 20);
    freq.put("לבנ", 51);
    freq.put("רשם", 13);
    freq.put("רשמ", 38);
    freq.put("סחר", 9);
    freq.put("פמל", 10);
    freq.put("וי ", 227);
    freq.put("כו ", 46);
    freq.put(" ■ ", 13);
    freq.put("יו ", 594);
    freq.put("של ", 1232);
    freq.put("יפג", 14);
    freq.put("ص", 7);
    freq.put(" ג ", 119);
    freq.put("מבנ", 11);
    freq.put("מבצ", 30);
    freq.put("מבק", 36);
    freq.put("מבפ", 8);
    freq.put("מבר", 23);
    freq.put("יפא", 6);
    freq.put("מבא", 11);
    freq.put("מבז", 9);
    freq.put("מבח", 50);
    freq.put("מבה", 19);
    freq.put("מבו", 53);
    freq.put("מבט", 80);
    freq.put("מבי", 177);
    freq.put("מבן", 8);
    freq.put("מבל", 29);
    freq.put("שול", 68);
    freq.put("שון", 247);
    freq.put("בזק", 9);
    freq.put("שר ", 361);
    freq.put("בזמ", 45);
    freq.put("בזכ", 12);
    freq.put("בזה", 30);
    freq.put("בזו", 8);
    freq.put("בזב", 14);
    freq.put("טעם", 26);
    freq.put("و", 17);
    freq.put("שות", 333);
    freq.put("רה ", 1023);
    freq.put("חם ", 65);
    freq.put("קה ", 333);
    freq.put("יפת", 30);
    freq.put("נג", 316);
    freq.put("תב ", 46);
    freq.put("עז ", 7);
    freq.put("הם ", 488);
    freq.put("רזי", 15);
    freq.put("רזה", 11);
    freq.put(" ינ", 25);
    freq.put("בא ", 309);
    freq.put(" יצ", 123);
    freq.put("ن ", 7);
    freq.put("לש ", 7);
    freq.put("ט ", 982);
    freq.put(" הן", 27);
    freq.put(" המ", 1053);
    freq.put(" הם", 146);
    freq.put(" הל", 274);
    freq.put(" הכ", 603);
    freq.put(" הי", 1662);
    freq.put(" הט", 181);
    freq.put(" הח", 565);
    freq.put(" הז", 537);
    freq.put(" הו", 1032);
    freq.put(" הה", 238);
    freq.put(" הד", 284);
    freq.put(" הג", 365);
    freq.put(" הב", 572);
    freq.put(" הא", 893);
    freq.put("שגר", 22);
    freq.put("שגע", 7);
    freq.put("שגי", 13);
    freq.put("שגם", 20);
    freq.put("שגב", 10);
    freq.put("שגו", 13);
    freq.put(" הת", 467);
    freq.put(" הש", 665);
    freq.put(" הר", 557);
    freq.put(" הק", 326);
    freq.put(" הצ", 273);
    freq.put(" הפ", 433);
    freq.put(" הע", 392);
    freq.put(" הס", 337);
    freq.put(" הנ", 224);
    freq.put("🎶", 15);
    freq.put("ו״ ", 6);
    freq.put(" גו", 170);
    freq.put(" גז", 30);
    freq.put(" גב", 159);
    freq.put(" גא", 66);
    freq.put(" גד", 105);
    freq.put(" גם", 407);
    freq.put(" גל", 91);
    freq.put(" גן", 8);
    freq.put(" גמ", 32);
    freq.put(" גי", 105);
    freq.put("שלפ", 11);
    freq.put("שלנ", 82);
    freq.put("שלת", 14);
    freq.put("שלש", 7);
    freq.put("שלח", 79);
    freq.put("שלה", 191);
    freq.put("שלו", 366);
    freq.put("שלג", 7);
    freq.put("שלא", 260);
    freq.put("שלב", 29);
    freq.put("שלמ", 71);
    freq.put("שלם", 61);
    freq.put("שלך", 253);
    freq.put("שלכ", 53);
    freq.put("שלט", 21);
    freq.put("שלי", 838);
    freq.put(" גנ", 18);
    freq.put(" גע", 13);
    freq.put(" גש", 27);
    freq.put(" גר", 120);
    freq.put("יוט", 39);
    freq.put("יוכ", 18);
    freq.put("יוך", 34);
    freq.put("יום", 677);
    freq.put("יול", 39);
    freq.put("יון", 212);
    freq.put("יומ", 65);
    freq.put("יוב", 33);
    freq.put("יוא", 86);
    freq.put("יוד", 275);
    freq.put("יוג", 8);
    freq.put("יוו", 117);
    freq.put("יוח", 57);
    freq.put("יוז", 16);
    freq.put("לט ", 55);
    freq.put("יוש", 66);
    freq.put("יור", 90);
    freq.put("יות", 1170);
    freq.put("יוס", 33);
    freq.put("יונ", 112);
    freq.put("יוע", 12);
    freq.put("יוץ", 89);
    freq.put("יופ", 62);
    freq.put("יוק", 72);
    freq.put("יוצ", 167);
    freq.put("ויס", 13);
    freq.put("וינ", 24);
    freq.put("ויע", 8);
    freq.put("ויפ", 14);
    freq.put("ויק", 27);
    freq.put("ויצ", 16);
    freq.put("ויש", 50);
    freq.put("ויר", 56);
    freq.put("וית", 21);
    freq.put("ויב", 21);
    freq.put("ויא", 8);
    freq.put("ויד", 33);
    freq.put("ויו", 152);
    freq.put("ויה", 38);
    freq.put("ויח", 18);
    freq.put("ויז", 37);
    freq.put("ויי", 99);
    freq.put("ויט", 211);
    freq.put("ויכ", 13);
    freq.put("וים", 32);
    freq.put("וגז", 7);
    freq.put("וין", 16);
    freq.put("רש ", 32);
    freq.put("לב ", 209);
    freq.put("סח ", 25);
    freq.put("סבו", 109);
    freq.put("סבב", 24);
    freq.put("סבא", 10);
    freq.put("סבל", 24);
    freq.put("סבי", 80);
    freq.put("לחכ", 19);
    freq.put("לחי", 123);
    freq.put("😏?", 14);
    freq.put("לחן", 17);
    freq.put("לחל", 35);
    freq.put("לחם", 33);
    freq.put("לחג", 14);
    freq.put("לחד", 16);
    freq.put("לחב", 37);
    freq.put("לחז", 41);
    freq.put("לחח", 7);
    freq.put("לחה", 45);
    freq.put("תת ", 119);
    freq.put("לחת", 74);
    freq.put("לחר", 8);
    freq.put("לחש", 28);
    freq.put("לחנ", 14);
    freq.put("לחצ", 14);
    freq.put("לחק", 6);
    freq.put("לחפ", 36);
    freq.put("לחץ", 20);
    freq.put("סבר", 18);
    freq.put("סבת", 24);
    freq.put("פלג", 20);
    freq.put("פלא", 60);
    freq.put("פלו", 43);
    freq.put("פלה", 18);
    freq.put("פלי", 83);
    freq.put("פלט", 7);
    freq.put("פלל", 11);
    freq.put("וח ", 322);
    freq.put("אק ", 43);
    freq.put("פלס", 27);
    freq.put("פלצ", 9);
    freq.put("פלת", 37);
    freq.put("שג ", 30);
    freq.put(" ה ", 121);
    freq.put("לשפ", 8);
    freq.put("טכ", 21);
    freq.put("טט", 103);
    freq.put("טי", 923);
    freq.put("טמ", 80);
    freq.put("טן", 92);
    freq.put("טל", 265);
    freq.put("טם", 19);
    freq.put("טג", 33);
    freq.put("טד", 19);
    freq.put("טא", 88);
    freq.put("טב", 87);
    freq.put("ם", 13420);
    freq.put("טח", 95);
    freq.put("טה", 197);
    freq.put("טו", 1697);
    freq.put("טת", 64);
    freq.put("לשו", 51);
    freq.put("טר", 655);
    freq.put("טש", 19);
    freq.put("לשא", 21);
    freq.put("לשב", 28);
    freq.put("לשג", 6);
    freq.put("טע", 238);
    freq.put("טף", 10);
    freq.put("טנ", 134);
    freq.put("טס", 62);
    freq.put("טצ", 9);
    freq.put("טק", 38);
    freq.put("טפ", 63);
    freq.put("לשכ", 26);
    freq.put("באת", 47);
    freq.put("באר", 62);
    freq.put("באש", 12);
    freq.put("באנ", 23);
    freq.put("באס", 30);
    freq.put("באק", 7);
    freq.put("באפ", 16);
    freq.put("הסד", 25);
    freq.put("באי", 137);
    freq.put("באמ", 195);
    freq.put("באל", 81);
    freq.put("באד", 14);
    freq.put("באא", 6);
    freq.put("באב", 11);
    freq.put("באז", 10);
    freq.put("באח", 20);
    freq.put("באה", 82);
    freq.put("באו", 126);
    freq.put("רז ", 35);
    freq.put("חן ", 70);
    freq.put("עזב", 23);
    freq.put("עזא", 11);
    freq.put("כפי", 25);
    freq.put("עזו", 38);
    freq.put("עזה", 7);
    freq.put("כפו", 11);
    freq.put("עזע", 9);
    freq.put("כפר", 42);
    freq.put("כפת", 46);
    freq.put("עזר", 49);
    freq.put("תבל", 8);
    freq.put("תבי", 63);
    freq.put("תבה", 18);
    freq.put("תבו", 50);
    freq.put("תבג", 14);
    freq.put("תבד", 8);
    freq.put("תבא", 6);
    freq.put("תבת", 26);
    freq.put("תבר", 34);
    freq.put("תבק", 6);
    freq.put("עה ", 407);
    freq.put("קהי", 9);
    freq.put("קהל", 15);
    freq.put("הן ", 112);
    freq.put("רהה", 18);
    freq.put("ر", 21);
    freq.put(" נב", 32);
    freq.put("הכנ", 53);
    freq.put(" נה", 91);
    freq.put("ז ", 761);
    freq.put(" ננ", 10);
    freq.put(" נצ", 25);
    freq.put("😪?", 9);
    freq.put("😪 ", 7);
    freq.put("הכל", 186);
    freq.put("מח ", 61);
    freq.put("כאב", 51);
    freq.put("מוּ", 8);
    freq.put("כאו", 18);
    freq.put("כאי", 69);
    freq.put("כאל", 79);
    freq.put("כאן", 60);
    freq.put("כאף", 8);
    freq.put("כאפ", 9);
    freq.put("זגן", 17);
    freq.put("מות", 285);
    freq.put("מור", 228);
    freq.put("מוש", 137);
    freq.put("מוצ", 76);
    freq.put("מוק", 88);
    freq.put("מופ", 42);
    freq.put("מוע", 89);
    freq.put("מונ", 282);
    freq.put("מוס", 73);
    freq.put("מומ", 18);
    freq.put("מון", 74);
    freq.put("מול", 160);
    freq.put("מום", 18);
    freq.put("מוך", 32);
    freq.put("מוכ", 70);
    freq.put("מוט", 31);
    freq.put("מוי", 9);
    freq.put("ץץץ", 14);
    freq.put("מוח", 57);
    freq.put("מוה", 6);
    freq.put("מוו", 38);
    freq.put("מוג", 27);
    freq.put("מוד", 183);
    freq.put("מוא", 16);
    freq.put("מוב", 50);
    freq.put("צץ ", 9);
    freq.put("פט ", 61);
    freq.put("סו ", 51);
    freq.put("בהצ", 27);
    freq.put("בהק", 8);
    freq.put("בהפ", 10);
    freq.put("בהס", 9);
    freq.put("בהת", 22);
    freq.put("בהר", 24);
    freq.put("בהש", 7);
    freq.put("בהח", 18);
    freq.put("בהה", 6);
    freq.put("בהו", 26);
    freq.put("בהב", 6);
    freq.put("בהמ", 16);
    freq.put("בהל", 14);
    freq.put("בהם", 14);
    freq.put("בהכ", 8);
    freq.put("בהי", 40);
    freq.put("לד ", 105);
    freq.put("היר", 66);
    freq.put("היש", 59);
    freq.put("הית", 44);
    freq.put("היפ", 44);
    freq.put("היצ", 10);
    freq.put("היק", 14);
    freq.put("הינ", 13);
    freq.put("😍 ", 21);
    freq.put("היע", 12);
    freq.put("😍?", 99);
    freq.put("היל", 89);
    freq.put("הים", 106);
    freq.put("הימ", 54);
    freq.put("אקו", 20);
    freq.put("היט", 25);
    freq.put("היי", 435);
    freq.put("היכ", 37);
    freq.put("היה", 589);
    freq.put("היו", 697);
    freq.put("היח", 53);
    freq.put("היא", 442);
    freq.put("היב", 6);
    freq.put("היג", 29);
    freq.put("היד", 43);
    freq.put("חכי", 21);
    freq.put("חכם", 18);
    freq.put("חכמ", 20);
    freq.put("חכו", 27);
    freq.put("חכה", 56);
    freq.put("וו ", 122);
    freq.put("תר ", 555);
    freq.put("הפו", 73);
    freq.put("אש ", 139);
    freq.put("דעי", 64);
    freq.put("יש ", 942);
    freq.put("הר", 891);
    freq.put("וחי", 41);
    freq.put("ץ", 705);
    freq.put("אקס", 46);
    freq.put("גת ", 52);
    freq.put("סס", 64);
    freq.put("סנ", 68);
    freq.put("סף", 77);
    freq.put("סע", 94);
    freq.put("ספ", 554);
    freq.put("סק", 207);
    freq.put("סצ", 6);
    freq.put("סר", 325);
    freq.put("סת", 459);
    freq.put("שזה", 122);
    freq.put("שזו", 18);
    freq.put("וחו", 81);
    freq.put("טספ", 6);
    freq.put("טסט", 7);
    freq.put("טסא", 21);
    freq.put("סב", 303);
    freq.put("סא", 86);
    freq.put("סד", 166);
    freq.put("סג", 91);
    freq.put("סו", 798);
    freq.put("סה", 164);
    freq.put("סח", 75);
    freq.put("סי", 1120);
    freq.put("סט", 506);
    freq.put("סכ", 88);
    freq.put("ה״ ", 10);
    freq.put("סם", 39);
    freq.put("סל", 177);
    freq.put("סן", 7);
    freq.put("סמ", 162);
    freq.put(" טר", 58);
    freq.put(" טע", 68);
    freq.put(" טס", 13);
    freq.put("ף ", 1020);
    freq.put(" טק", 16);
    freq.put(" טפ", 20);
    freq.put("שא ", 36);
    freq.put(" טכ", 15);
    freq.put(" טי", 101);
    freq.put(" טמ", 19);
    freq.put(" טל", 68);
    freq.put(" טב", 21);
    freq.put(" טא", 20);
    freq.put(" טו", 728);
    freq.put(" טה", 10);
    freq.put("גרי", 67);
    freq.put("גרם", 37);
    freq.put("גרמ", 33);
    freq.put("גרב", 14);
    freq.put("גרד", 7);
    freq.put("גרו", 107);
    freq.put("גרה", 20);
    freq.put("ודח", 9);
    freq.put("ודו", 75);
    freq.put("ודה", 275);
    freq.put("ודד", 50);
    freq.put("ודא", 13);
    freq.put("ודמ", 17);
    freq.put("ודם", 55);
    freq.put("ודל", 18);
    freq.put("ודי", 172);
    freq.put("ודק", 36);
    freq.put("ודפ", 12);
    freq.put("ודע", 385);
    freq.put("ודנ", 18);
    freq.put("ך ", 2749);
    freq.put("ודת", 20);
    freq.put("ודש", 80);
    freq.put("ודר", 32);
    freq.put("גרש", 11);
    freq.put("גרר", 6);
    freq.put("ך?", 14);
    freq.put("גרס", 19);
    freq.put("גרע", 10);
    freq.put("גרפ", 10);
    freq.put("תצי", 9);
    freq.put("תצט", 7);
    freq.put("תצא", 8);
    freq.put("חי ", 140);
    freq.put("קא ", 48);
    freq.put("דאי", 27);
    freq.put("דאג", 31);
    freq.put("דאו", 34);
    freq.put("נב ", 7);
    freq.put("ع", 12);
    freq.put("לםם", 12);
    freq.put("כר ", 69);
    freq.put("סכנ", 20);
    freq.put("י״ ", 13);
    freq.put("סכי", 26);
    freq.put("סכם", 13);
    freq.put("סכו", 8);
    freq.put("הי ", 70);
    freq.put("דמע", 13);
    freq.put("דמנ", 13);
    freq.put("דמת", 27);
    freq.put("דמה", 15);
    freq.put("דמו", 42);
    freq.put("דמן", 6);
    freq.put("דמי", 59);
    freq.put("סוס", 13);
    freq.put("סונ", 14);
    freq.put("סוף", 155);
    freq.put("סוע", 9);
    freq.put("סופ", 91);
    freq.put("סוק", 15);
    freq.put("לדב", 53);
    freq.put("סוש", 24);
    freq.put("סור", 76);
    freq.put("סות", 38);
    freq.put("לדי", 147);
    freq.put("בה ", 709);
    freq.put("ס", 6717);
    freq.put("סוב", 31);
    freq.put("סוד", 45);
    freq.put("סוג", 41);
    freq.put("סוו", 13);
    freq.put("לדס", 7);
    freq.put("סוי", 22);
    freq.put("סוכ", 24);
    freq.put("סוך", 7);
    freq.put("סום", 19);
    freq.put("סול", 25);
    freq.put("סון", 30);
    freq.put("סומ", 41);
    freq.put("פטמ", 7);
    freq.put("פטל", 7);
    freq.put("פטי", 31);
    freq.put("פטו", 6);
    freq.put("פטר", 23);
    freq.put("מו ", 433);
    freq.put("לבה", 17);
    freq.put("לבג", 10);
    freq.put("מחפ", 47);
    freq.put("מחצ", 9);
    freq.put("מחק", 35);
    freq.put("מחנ", 20);
    freq.put("מחס", 11);
    freq.put("מחר", 156);
    freq.put("מחש", 49);
    freq.put("מחת", 6);
    freq.put("זג ", 9);
    freq.put("לבר", 26);
    freq.put("לבש", 23);
    freq.put("מחה", 27);
    freq.put("מחו", 84);
    freq.put("מחז", 35);
    freq.put("מחא", 16);
    freq.put("מחב", 38);
    freq.put("מחד", 29);
    freq.put("מחל", 57);
    freq.put("מחמ", 18);
    freq.put("מחי", 70);
    freq.put("מחכ", 63);
    freq.put("כשר", 27);
    freq.put("לבס", 12);
    freq.put("לבע", 8);
    freq.put("פך ", 35);
    freq.put("זא", 273);
    freq.put("זב", 112);
    freq.put("זג", 29);
    freq.put("זד", 46);
    freq.put("זה", 2726);
    freq.put("זו", 613);
    freq.put("זז", 51);
    freq.put("זי", 390);
    freq.put("זכ", 199);
    freq.put("זל", 125);
    freq.put("זם", 8);
    freq.put("זמ", 319);
    freq.put("זן", 19);
    freq.put("זנ", 39);
    freq.put("זע", 48);
    freq.put("זף", 6);
    freq.put("זצ", 7);
    freq.put("זק", 100);
    freq.put("זר", 409);
    freq.put("זת", 22);
    freq.put("ז׳", 8);
    freq.put("כרת", 53);
    freq.put("עגל", 12);
    freq.put("עגי", 15);
    freq.put("עגו", 28);
    freq.put("כרט", 26);
    freq.put("כרי", 63);
    freq.put("כרמ", 15);
    freq.put("לם ", 408);
    freq.put("כרג", 28);
    freq.put("כרה", 20);
    freq.put("עגע", 74);
    freq.put("כרז", 13);
    freq.put("קאר", 7);
    freq.put("נבו", 18);
    freq.put("נבח", 24);
    freq.put("נבי", 12);
    freq.put("נבל", 6);
    freq.put("קאי", 43);
    freq.put("נבר", 8);
    freq.put("קאו", 9);
    freq.put("חיח", 22);
    freq.put("חיז", 9);
    freq.put("חיו", 93);
    freq.put("חיה", 28);
    freq.put("חיד", 76);
    freq.put("חיב", 25);
    freq.put("חימ", 10);
    freq.put("חים", 149);
    freq.put("חיל", 177);
    freq.put("חיכ", 13);
    freq.put("חיי", 530);
    freq.put("חיק", 92);
    freq.put("חיצ", 20);
    freq.put("חיץ", 7);
    freq.put("חיפ", 41);
    freq.put("חיס", 10);
    freq.put("חינ", 68);
    freq.put("חית", 18);
    freq.put("חיש", 8);
    freq.put("חיר", 92);
    freq.put("ךך", 119);
    freq.put("וד ", 717);
    freq.put("כשפ", 7);
    freq.put("גר ", 84);
    freq.put("ףף", 75);
    freq.put(" ט ", 10);
    freq.put("שאב", 7);
    freq.put("שאח", 18);
    freq.put("שאה", 14);
    freq.put("שאו", 69);
    freq.put("שאי", 140);
    freq.put("שאמ", 38);
    freq.put("שאל", 96);
    freq.put("שאם", 22);
    freq.put("שאף", 11);
    freq.put("שאנ", 498);
    freq.put("שאס", 7);
    freq.put("שאפ", 18);
    freq.put("שאת", 341);
    freq.put("שאר", 105);
    freq.put("ַ", 13);
    freq.put("ס ", 986);
    freq.put(" זק", 29);
    freq.put(" זר", 24);
    freq.put(" ז׳", 6);
    freq.put("טס ", 13);
    freq.put(" זב", 18);
    freq.put(" זא", 126);
    freq.put(" זד", 9);
    freq.put(" זו", 256);
    freq.put(" זה", 1598);
    freq.put(" זז", 13);
    freq.put(" זי", 63);
    freq.put(" זכ", 44);
    freq.put(" זמ", 98);
    freq.put("ישנ", 60);
    freq.put("ישש", 9);
    freq.put("ישר", 242);
    freq.put("גתי", 6);
    freq.put("איו", 36);
    freq.put("סף ", 72);
    freq.put("ישו", 197);
    freq.put("ישה", 361);
    freq.put("ישח", 6);
    freq.put("ישב", 34);
    freq.put("ישא", 48);
    freq.put("ישג", 8);
    freq.put("ישל", 35);
    freq.put("ישן", 28);
    freq.put("ישמ", 27);
    freq.put("ישי", 218);
    freq.put("תרב", 23);
    freq.put("תרא", 56);
    freq.put("תרד", 6);
    freq.put("אשכ", 38);
    freq.put("אשל", 17);
    freq.put("וור", 42);
    freq.put("אשמ", 16);
    freq.put("וות", 97);
    freq.put("אשא", 7);
    freq.put("ווק", 69);
    freq.put("ווצ", 17);
    freq.put("אשה", 11);
    freq.put("וונ", 70);
    freq.put("ווע", 14);
    freq.put("אשר", 57);
    freq.put("וול", 37);
    freq.put("וון", 53);
    freq.put("ווי", 399);
    freq.put("ווט", 70);
    freq.put("ווכ", 12);
    freq.put("רוו", 61);
    freq.put("ווו", 378);
    freq.put("ווה", 174);
    freq.put("ווח", 60);
    freq.put("ווז", 6);
    freq.put("ווב", 12);
    freq.put("ווא", 214);
    freq.put("ווד", 41);
    freq.put("אשק", 10);
    freq.put("😳?", 17);
    freq.put("רוא", 139);
    freq.put("רוג", 40);
    freq.put("לר ", 42);
    freq.put("רול", 17);
    freq.put("רום", 68);
    freq.put("סעד", 17);
    freq.put("דשו", 59);
    freq.put("דשה", 82);
    freq.put("חלה", 46);
    freq.put("דשי", 52);
    freq.put("רוי", 31);
    freq.put("נד ", 39);
    freq.put("רוץ", 62);
    freq.put("רוצ", 357);
    freq.put("בטא", 10);
    freq.put("בטב", 9);
    freq.put("בטח", 60);
    freq.put("בטו", 147);
    freq.put("בטי", 77);
    freq.put("בטן", 17);
    freq.put("בטל", 43);
    freq.put("בטע", 15);
    freq.put("ש", 22095);
    freq.put("בטר", 9);
    freq.put(" ⃣", 9);
    freq.put("חלפ", 10);
    freq.put(" נ ", 14);
    freq.put("אומ", 316);
    freq.put(" ₪", 10);
    freq.put("הור", 117);
    freq.put("הוש", 10);
    freq.put("הות", 20);
    freq.put(" עז", 52);
    freq.put(" עב", 114);
    freq.put(" עא", 6);
    freq.put(" עד", 366);
    freq.put(" עג", 25);
    freq.put("הונ", 15);
    freq.put(" על", 1359);
    freq.put(" עמ", 95);
    freq.put("הופ", 64);
    freq.put("הוצ", 34);
    freq.put("הוק", 11);
    freq.put("הוט", 8);
    freq.put("הוי", 12);
    freq.put(" עק", 22);
    freq.put("הוכ", 15);
    freq.put(" עס", 17);
    freq.put(" ענ", 67);
    freq.put("הומ", 51);
    freq.put("הוא", 724);
    freq.put("הוב", 82);
    freq.put("הוג", 6);
    freq.put("הוד", 190);
    freq.put(" עש", 131);
    freq.put("הוו", 45);
    freq.put("הוז", 9);
    freq.put(" עת", 21);
    freq.put("ג", 6042);
    freq.put("עמק", 24);
    freq.put("ت", 21);
    freq.put("קן ", 33);
    freq.put("עמי", 138);
    freq.put("עממ", 15);
    freq.put("עמם", 55);
    freq.put("עמד", 28);
    freq.put("עמו", 67);
    freq.put("עמה", 6);
    freq.put("נול", 24);
    freq.put("נום", 14);
    freq.put("נומ", 12);
    freq.put("נון", 34);
    freq.put("נוט", 18);
    freq.put("נוי", 83);
    freq.put("נוך", 13);
    freq.put("נוכ", 21);
    freq.put("נוה", 7);
    freq.put("נוו", 50);
    freq.put("נוח", 24);
    freq.put("נוא", 32);
    freq.put("נוב", 27);
    freq.put("נוג", 23);
    freq.put("נוד", 20);
    freq.put("קלת", 11);
    freq.put("קלע", 7);
    freq.put("קלפ", 7);
    freq.put("קלט", 13);
    freq.put("קלי", 88);
    freq.put("קלל", 9);
    freq.put("קלא", 9);
    freq.put("סעמ", 20);
    freq.put("קלד", 6);
    freq.put("קלה", 12);
    freq.put("קלו", 29);
    freq.put("קלח", 23);
    freq.put("נור", 81);
    freq.put("נוש", 57);
    freq.put("נות", 641);
    freq.put("נופ", 29);
    freq.put("נוצ", 11);
    freq.put("נוק", 32);
    freq.put("נונ", 19);
    freq.put("נוס", 60);
    freq.put("נוע", 98);
    freq.put("ססו", 6);
    freq.put("אוא", 11);
    freq.put("ססס", 29);
    freq.put("אמו", 54);
    freq.put("מתג", 52);
    freq.put("מתב", 22);
    freq.put("מתא", 55);
    freq.put("מתח", 154);
    freq.put("מתו", 67);
    freq.put("מתה", 43);
    freq.put("מתכ", 44);
    freq.put("מתי", 247);
    freq.put("מתן", 12);
    freq.put("מתמ", 37);
    freq.put("מתם", 10);
    freq.put("מתל", 27);
    freq.put("שש ", 43);
    freq.put("מתע", 49);
    freq.put("מתנ", 82);
    freq.put("מתק", 56);
    freq.put("מתפ", 31);
    freq.put("מתת", 12);
    freq.put("מתר", 20);
    freq.put("תעז", 8);
    freq.put("תעו", 49);
    freq.put("תעה", 16);
    freq.put("תעד", 9);
    freq.put("תעב", 21);
    freq.put("תעל", 38);
    freq.put("ץ ", 638);
    freq.put("תעי", 8);
    freq.put("דהה", 10);
    freq.put("דהו", 7);
    freq.put("דהמ", 6);
    freq.put("דהי", 57);
    freq.put(" סב", 94);
    freq.put(" סג", 30);
    freq.put("תעק", 19);
    freq.put("תעצ", 18);
    freq.put("ההר", 22);
    freq.put("תעס", 12);
    freq.put("תענ", 22);
    freq.put("תעת", 7);
    freq.put("תעש", 52);
    freq.put("תער", 13);
    freq.put("לן ", 52);
    freq.put("סי ", 83);
    freq.put("רסי", 42);
    freq.put("רסל", 8);
    freq.put("רסם", 13);
    freq.put("רסמ", 53);
    freq.put("רסה", 16);
    freq.put("רסו", 45);
    freq.put("רסת", 18);
    freq.put("ןן ", 40);
    freq.put("רסק", 13);
    freq.put("🎶?", 12);
    freq.put("ליפ", 56);
    freq.put("ליץ", 13);
    freq.put("ליצ", 29);
    freq.put("ליק", 72);
    freq.put("לינ", 81);
    freq.put("ליס", 36);
    freq.put("ליע", 6);
    freq.put("ליף", 18);
    freq.put("ליר", 38);
    freq.put("ההי", 21);
    freq.put("לית", 111);
    freq.put(" סק", 46);
    freq.put("ליה", 114);
    freq.put("ליו", 201);
    freq.put("ליז", 20);
    freq.put("ליח", 104);
    freq.put("ליא", 52);
    freq.put("ליב", 61);
    freq.put("ליג", 20);
    freq.put("ליד", 88);
    freq.put("ליל", 251);
    freq.put("לים", 454);
    freq.put("לימ", 53);
    freq.put("לין", 37);
    freq.put("ליט", 101);
    freq.put(" סת", 134);
    freq.put("ליך", 60);
    freq.put("ליכ", 34);
    freq.put("כשי", 328);
    freq.put("צר ", 82);
    freq.put("דג ", 11);
    freq.put("טטו", 19);
    freq.put("טטה", 8);
    freq.put("טטט", 43);
    freq.put("גז ", 21);
    freq.put("וב ", 918);
    freq.put("ם״ ", 7);
    freq.put("עצב", 120);
    freq.put("כהן", 20);
    freq.put("ג׳י", 8);
    freq.put("עצו", 84);
    freq.put("עצה", 6);
    freq.put("כהה", 6);
    freq.put("ג׳ו", 9);
    freq.put("עצי", 25);
    freq.put("עצמ", 213);
    freq.put("עצם", 30);
    freq.put("עצל", 7);
    freq.put("זזז", 22);
    freq.put("זזה", 7);
    freq.put("שה ", 693);
    freq.put("זאר", 8);
    freq.put("זאת", 227);
    freq.put("זאו", 7);
    freq.put("טף ", 10);
    freq.put("זאז", 9);
    freq.put("סס ", 16);
    freq.put("כשח", 11);
    freq.put("חץ ", 21);
    freq.put("ריז", 21);
    freq.put("וזר", 111);
    freq.put("כשו", 6);
    freq.put("😱?", 23);
    freq.put("ארד", 37);
    freq.put("קל ", 77);
    freq.put("נו ", 886);
    freq.put("וזי", 59);
    freq.put(" ال", 10);
    freq.put("יכר", 33);
    freq.put("וזה", 120);
    freq.put("וזו", 17);
    freq.put("הו ", 472);
    freq.put(" ע ", 18);
    freq.put(" נד", 64);
    freq.put(" נג", 117);
    freq.put("הכפ", 9);
    freq.put(" נא", 51);
    freq.put(" נח", 70);
    freq.put(" נז", 35);
    freq.put(" נו", 394);
    freq.put("הכס", 17);
    freq.put(" נכ", 187);
    freq.put(" ני", 236);
    freq.put(" נט", 27);
    freq.put("הכת", 9);
    freq.put(" נמ", 102);
    freq.put("הכר", 41);
    freq.put(" נל", 22);
    freq.put(" נע", 127);
    freq.put(" נס", 73);
    freq.put("הכו", 54);
    freq.put(" נק", 55);
    freq.put("הכד", 7);
    freq.put("הכא", 11);
    freq.put(" נפ", 139);
    freq.put(" נת", 87);
    freq.put(" נש", 221);
    freq.put(" נר", 175);
    freq.put("הכי", 317);
    freq.put("עאע", 14);
    freq.put("בט ", 32);
    freq.put("כתב", 96);
    freq.put("כתה", 8);
    freq.put("כתו", 53);
    freq.put("כתי", 45);
    freq.put(" ■", 18);
    freq.put("נדי", 46);
    freq.put("נדמ", 7);
    freq.put("נדל", 19);
    freq.put("נדב", 34);
    freq.put("נדה", 9);
    freq.put("נדו", 34);
    freq.put("דש ", 176);
    freq.put("😔?", 11);
    freq.put("נדר", 35);
    freq.put("נדפ", 9);
    freq.put("שהמ", 35);
    freq.put("שהן", 14);
    freq.put("שהם", 74);
    freq.put("שהכ", 31);
    freq.put("שהט", 12);
    freq.put("שהי", 257);
    freq.put("שהז", 11);
    freq.put("שהח", 14);
    freq.put("שהה", 17);
    freq.put("שהו", 583);
    freq.put("שהג", 12);
    freq.put("שהא", 18);
    freq.put("שהב", 24);
    freq.put("שהת", 38);
    freq.put("שהר", 17);
    freq.put("שהש", 26);
    freq.put("שהצ", 18);
    freq.put("שהק", 11);
    freq.put("שהפ", 24);
    freq.put("שהע", 10);
    freq.put("שהס", 13);
    freq.put("צחק", 26);
    freq.put("זז ", 11);
    freq.put("כה ", 415);
    freq.put("גזע", 11);
    freq.put("גזר", 12);
    freq.put("ובי", 193);
    freq.put("ובט", 16);
    freq.put("ובכ", 28);
    freq.put("ובך", 8);
    freq.put("ובל", 65);
    freq.put("ובן", 22);
    freq.put("ובמ", 35);
    freq.put("ובב", 55);
    freq.put("ובא", 20);
    freq.put("ובד", 120);
    freq.put("ובו", 115);
    freq.put("ובה", 197);
    freq.put("ובח", 15);
    freq.put("ובש", 27);
    freq.put("ובר", 116);
    freq.put("ובת", 39);
    freq.put("ובס", 30);
    freq.put("ובנ", 20);
    freq.put("ובע", 33);
    freq.put("ובצ", 6);
    freq.put("גזי", 14);
    freq.put("גזמ", 6);
    freq.put("פז ", 18);
    freq.put("תפל", 20);
    freq.put("טט ", 16);
    freq.put("תפי", 28);
    freq.put("תפט", 6);
    freq.put("תפו", 40);
    freq.put("תפה", 6);
    freq.put("דגי", 9);
    freq.put("תפש", 9);
    freq.put("תפר", 30);
    freq.put("תפת", 24);
    freq.put("תפק", 27);
    freq.put("תפס", 45);
    freq.put("תפנ", 6);
    freq.put("נמא", 26);
    freq.put("״ש ", 6);
    freq.put("לי ", 2493);
    freq.put("סן ", 7);
    freq.put("לי?", 11);
    freq.put("שקע", 11);
    freq.put("סיר", 37);
    freq.put("סית", 62);
    freq.put("סיפ", 57);
    freq.put("סיק", 112);
    freq.put("סיס", 40);
    freq.put("סינ", 49);
    freq.put("סיף", 11);
    freq.put("סיע", 13);
    freq.put("ןןו", 7);
    freq.put("זל ", 95);
    freq.put("ןןן", 216);
    freq.put("רס ", 86);
    freq.put("סים", 127);
    freq.put("סיל", 20);
    freq.put("סין", 10);
    freq.put("סימ", 79);
    freq.put("סיי", 68);
    freq.put("סיט", 22);
    freq.put("סיכ", 74);
    freq.put("סיך", 9);
    freq.put("סיו", 70);
    freq.put("סיה", 28);
    freq.put("סיב", 104);
    freq.put("סיא", 8);
    freq.put("סיד", 16);
    freq.put("סיג", 15);
    freq.put("ץץ", 21);
    freq.put("דה ", 525);
    freq.put("תע ", 10);
    freq.put("פהה", 24);
    freq.put("גה ", 78);
    freq.put("יף ", 200);
    freq.put("ששש", 48);
    freq.put("ששת", 11);
    freq.put("ששו", 25);
    freq.put("ששל", 7);
    freq.put("ששמ", 14);
    freq.put("ששי", 16);
    freq.put("ששכ", 14);
    freq.put("מת ", 423);
  }
  
}

