package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HR {
  private static final String name = "hr";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HR() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 602963;
    n_words[1] = 734841;
    n_words[2] = 568399;

    freq.put("SP ", 9);
    freq.put("NO ", 65);
    freq.put(" y ", 13);
    freq.put("hoć", 27);
    freq.put(" yo", 61);
    freq.put(" ya", 7);
    freq.put("k", 19870);
    freq.put(" ye", 10);
    freq.put("ED ", 13);
    freq.put("OJ ", 22);
    freq.put("RL ", 14);
    freq.put("dne", 114);
    freq.put("dna", 166);
    freq.put("dno", 390);
    freq.put("dni", 195);
    freq.put("dnj", 104);
    freq.put("dnu", 56);
    freq.put("jmu", 14);
    freq.put("jmi", 7);
    freq.put("jmo", 20);
    freq.put("jml", 8);
    freq.put("jma", 36);
    freq.put("jme", 8);
    freq.put("Le", 93);
    freq.put("La", 136);
    freq.put("Lo", 69);
    freq.put("Lm", 12);
    freq.put("Lj", 86);
    freq.put("Li", 96);
    freq.put("Lv", 8);
    freq.put("Lt", 8);
    freq.put("Lu", 81);
    freq.put("Lp", 9);
    freq.put("Lz", 8);
    freq.put("Ly", 8);
    freq.put("hod", 55);
    freq.put("hoc", 38);
    freq.put("hon", 41);
    freq.put("hoo", 9);
    freq.put("hol", 22);
    freq.put("hom", 32);
    freq.put("hok", 9);
    freq.put("hov", 48);
    freq.put("hot", 24);
    freq.put("hor", 53);
    freq.put("hos", 15);
    freq.put("hop", 23);
    freq.put("A", 1436);
    freq.put("L ", 153);
    freq.put(" če", 125);
    freq.put(" ča", 47);
    freq.put("ho ", 43);
    freq.put(" čl", 9);
    freq.put("AO ", 54);
    freq.put(" čo", 59);
    freq.put(" či", 74);
    freq.put(" ču", 67);
    freq.put("DP ", 15);
    freq.put(" V ", 26);
    freq.put("eš ", 207);
    freq.put("xh", 13);
    freq.put("zam", 141);
    freq.put("EŠ ", 10);
    freq.put("AP ", 7);
    freq.put("zak", 121);
    freq.put("fir", 13);
    freq.put("uop", 36);
    freq.put("Hit", 11);
    freq.put("zah", 24);
    freq.put("fit", 12);
    freq.put("fiz", 16);
    freq.put("zai", 18);
    freq.put("fib", 11);
    freq.put("fic", 37);
    freq.put("fig", 7);
    freq.put("zag", 54);
    freq.put("fij", 41);
    freq.put("fik", 16);
    freq.put("fin", 90);
    freq.put("Hin", 9);
    freq.put(" Va", 86);
    freq.put("ešk", 44);
    freq.put(" Ve", 118);
    freq.put("ešl", 7);
    freq.put("ešn", 22);
    freq.put(" Vi", 135);
    freq.put(" Vj", 11);
    freq.put("eše", 18);
    freq.put(" Vl", 73);
    freq.put(" Vo", 75);
    freq.put("zac", 38);
    freq.put(" Vr", 46);
    freq.put(" Vu", 42);
    freq.put("ešt", 99);
    freq.put("fi ", 14);
    freq.put("uo ", 56);
    freq.put("rT", 10);
    freq.put("rU", 11);
    freq.put("rV", 9);
    freq.put("rW", 10);
    freq.put("rP", 8);
    freq.put("rS", 17);
    freq.put("rX", 9);
    freq.put("rZ", 7);
    freq.put("rD", 10);
    freq.put("rG", 8);
    freq.put("rA", 8);
    freq.put("rB", 12);
    freq.put("rC", 11);
    freq.put("rL", 16);
    freq.put("rM", 17);
    freq.put("rN", 16);
    freq.put("rO", 13);
    freq.put("rH", 10);
    freq.put("rI", 7);
    freq.put("rJ", 9);
    freq.put("rt", 528);
    freq.put("ru", 1451);
    freq.put("rv", 546);
    freq.put("rw", 20);
    freq.put("rp", 121);
    freq.put("rq", 26);
    freq.put("rr", 94);
    freq.put("rs", 435);
    freq.put("dst", 49);
    freq.put("ry", 69);
    freq.put("rz", 246);
    freq.put("zas", 137);
    freq.put("rd", 297);
    freq.put("re", 4038);
    freq.put("rf", 37);
    freq.put("rg", 140);
    freq.put("dsj", 33);
    freq.put("ra", 6514);
    freq.put("rb", 322);
    freq.put("rc", 275);
    freq.put("rl", 216);
    freq.put("rm", 230);
    freq.put("rn", 637);
    freq.put("dse", 19);
    freq.put("rh", 111);
    freq.put("ri", 3373);
    freq.put("rj", 45);
    freq.put("rk", 422);
    freq.put("IM ", 92);
    freq.put("ate", 455);
    freq.put("atc", 7);
    freq.put("hg", 14);
    freq.put("ata", 415);
    freq.put("atn", 104);
    freq.put("ato", 273);
    freq.put("atm", 11);
    freq.put("atj", 15);
    freq.put("atk", 79);
    freq.put("ath", 19);
    freq.put("ati", 850);
    freq.put("atv", 39);
    freq.put("att", 16);
    freq.put("atu", 135);
    freq.put("r ", 1632);
    freq.put("ats", 126);
    freq.put("atp", 7);
    freq.put("ds ", 11);
    freq.put("sm ", 17);
    freq.put("Duh", 9);
    freq.put("Dul", 7);
    freq.put("Dub", 12);
    freq.put("Dus", 16);
    freq.put("me ", 1033);
    freq.put("Cec", 11);
    freq.put("Cen", 18);
    freq.put("Cel", 7);
    freq.put("Cek", 17);
    freq.put("xim", 7);
    freq.put("ešć", 7);
    freq.put("knj", 80);
    freq.put("nzu", 7);
    freq.put("Sof", 10);
    freq.put("nza", 14);
    freq.put("nze", 15);
    freq.put("nzi", 22);
    freq.put("nzo", 9);
    freq.put("Son", 7);
    freq.put("seć", 42);
    freq.put("rž", 91);
    freq.put("rš", 90);
    freq.put("Sou", 13);
    freq.put("rđ", 10);
    freq.put("nel", 31);
    freq.put("y", 1236);
    freq.put("rć", 10);
    freq.put("oq ", 7);
    freq.put("rč", 36);
    freq.put("seč", 9);
    freq.put("Lje", 9);
    freq.put("nev", 70);
    freq.put("X", 268);
    freq.put("Lju", 65);
    freq.put("net", 140);
    freq.put("nes", 289);
    freq.put("Rij", 15);
    freq.put("ovč", 10);
    freq.put("Rib", 11);
    freq.put("PS ", 14);
    freq.put("iry", 7);
    freq.put("irs", 9);
    freq.put("irt", 8);
    freq.put("iru", 27);
    freq.put("iri", 141);
    freq.put("irk", 64);
    freq.put("irl", 21);
    freq.put("irn", 28);
    freq.put("iro", 74);
    freq.put("ira", 542);
    freq.put("ire", 76);
    freq.put("rgu", 8);
    freq.put("DM ", 20);
    freq.put("ir ", 82);
    freq.put("pre", 885);
    freq.put("prd", 12);
    freq.put("fra", 34);
    freq.put("ć", 1931);
    freq.put("fre", 18);
    freq.put("fri", 32);
    freq.put("fro", 11);
    freq.put("fru", 9);
    freq.put("pro", 937);
    freq.put("smj", 21);
    freq.put("cun", 15);
    freq.put("ant", 156);
    freq.put("BE ", 11);
    freq.put("iću", 47);
    freq.put("bio", 188);
    freq.put("Din", 26);
    freq.put("tza", 15);
    freq.put("iće", 67);
    freq.put("Dio", 7);
    freq.put("ića", 79);
    freq.put("jk ", 21);
    freq.put("ići", 21);
    freq.put("jku", 44);
    freq.put("jko", 57);
    freq.put("ić ", 310);
    freq.put("jke", 48);
    freq.put("jka", 96);
    freq.put("LO ", 32);
    freq.put("iš ", 156);
    freq.put("ču ", 26);
    freq.put("bit", 244);
    freq.put("hah", 389);
    freq.put("hai", 17);
    freq.put("haj", 23);
    freq.put("hak", 21);
    freq.put("hal", 43);
    freq.put("ham", 28);
    freq.put("han", 44);
    freq.put("hao", 14);
    freq.put("haa", 19);
    freq.put("hae", 16);
    freq.put("bnj", 8);
    freq.put("bni", 17);
    freq.put("bno", 36);
    freq.put("hap", 14);
    freq.put("anP", 26);
    freq.put("har", 53);
    freq.put("has", 15);
    freq.put("hat", 38);
    freq.put("hav", 8);
    freq.put("čuv", 16);
    freq.put("čup", 7);
    freq.put("čud", 19);
    freq.put("čun", 16);
    freq.put("čuj", 29);
    freq.put("ha ", 227);
    freq.put("ola", 317);
    freq.put("olc", 14);
    freq.put("old", 13);
    freq.put("ole", 245);
    freq.put("olf", 7);
    freq.put("oli", 936);
    freq.put("olj", 382);
    freq.put(" X ", 24);
    freq.put("oll", 55);
    freq.put("oln", 32);
    freq.put("olo", 178);
    freq.put("ols", 10);
    freq.put("olt", 9);
    freq.put("olu", 115);
    freq.put("AV ", 19);
    freq.put("fot", 56);
    freq.put("fov", 17);
    freq.put("for", 105);
    freq.put("umr", 61);
    freq.put("ume", 150);
    freq.put("uma", 61);
    freq.put("umb", 12);
    freq.put("fol", 43);
    freq.put("fon", 69);
    freq.put("foo", 9);
    freq.put("umi", 82);
    freq.put("umj", 14);
    freq.put("ol ", 76);
    freq.put(" Xb", 7);
    freq.put("mši", 16);
    freq.put("o", 49344);
    freq.put("fo ", 17);
    freq.put("um ", 101);
    freq.put("soc", 16);
    freq.put("sob", 169);
    freq.put("mbi", 18);
    freq.put("sof", 10);
    freq.put("mbe", 11);
    freq.put("sok", 27);
    freq.put("soj", 9);
    freq.put("Fej", 11);
    freq.put("sol", 29);
    freq.put("son", 86);
    freq.put("sop", 9);
    freq.put("sos", 13);
    freq.put("Ust", 14);
    freq.put("Fer", 8);
    freq.put("Fes", 8);
    freq.put("sov", 92);
    freq.put("mbr", 13);
    freq.put("az ", 92);
    freq.put("so ", 62);
    freq.put("Vec", 8);
    freq.put("azi", 293);
    freq.put("azl", 60);
    freq.put("azm", 56);
    freq.put("azn", 137);
    freq.put("azo", 57);
    freq.put("aza", 138);
    freq.put("azb", 42);
    freq.put("azd", 26);
    freq.put("aze", 239);
    freq.put("azg", 29);
    freq.put("azz", 8);
    freq.put("azr", 21);
    freq.put("azu", 152);
    freq.put("azv", 39);
    freq.put("Sir", 29);
    freq.put("kha", 8);
    freq.put("Sin", 29);
    freq.put("Sim", 9);
    freq.put("Sil", 9);
    freq.put("us", 1199);
    freq.put("žba", 9);
    freq.put("žbe", 18);
    freq.put("mri", 11);
    freq.put("E", 646);
    freq.put("Ide", 25);
    freq.put("eAr", 8);
    freq.put("osp", 50);
    freq.put("oss", 28);
    freq.put("osu", 59);
    freq.put("ost", 987);
    freq.put("osv", 55);
    freq.put("osi", 174);
    freq.put("osh", 43);
    freq.put("osk", 40);
    freq.put("osj", 32);
    freq.put("osm", 49);
    freq.put("osl", 297);
    freq.put("oso", 159);
    freq.put("osn", 77);
    freq.put("osa", 202);
    freq.put("osc", 9);
    freq.put("ose", 191);
    freq.put("osf", 9);
    freq.put("Aqu", 10);
    freq.put("vet", 199);
    freq.put("ver", 241);
    freq.put("ves", 105);
    freq.put("VA ", 29);
    freq.put("vez", 142);
    freq.put("veg", 13);
    freq.put("ved", 73);
    freq.put("Ta ", 8);
    freq.put("vec", 173);
    freq.put("ven", 161);
    freq.put("veo", 14);
    freq.put("vel", 123);
    freq.put("vem", 33);
    freq.put("vej", 8);
    freq.put("vek", 155);
    freq.put("ŠE ", 12);
    freq.put("os ", 217);
    freq.put("Tat", 16);
    freq.put("peg", 14);
    freq.put("Tar", 7);
    freq.put("Tas", 14);
    freq.put("Tad", 15);
    freq.put("ve ", 1002);
    freq.put("Tal", 8);
    freq.put("Tam", 19);
    freq.put("Taj", 21);
    freq.put("Tak", 48);
    freq.put("M ", 467);
    freq.put("ufi", 12);
    freq.put("zre", 25);
    freq.put("zra", 32);
    freq.put("zro", 8);
    freq.put("Me", 160);
    freq.put("Md", 7);
    freq.put("Ma", 550);
    freq.put("Mc", 10);
    freq.put("Mm", 10);
    freq.put("Ml", 25);
    freq.put("Mo", 262);
    freq.put("Mn", 21);
    freq.put("Mi", 332);
    freq.put("Mh", 7);
    freq.put("Mj", 13);
    freq.put("Mu", 55);
    freq.put("Mt", 10);
    freq.put("Mp", 7);
    freq.put("Mr", 60);
    freq.put("My", 8);
    freq.put("bt", 33);
    freq.put("ugi", 81);
    freq.put("ipa", 77);
    freq.put("ipe", 20);
    freq.put("ipj", 8);
    freq.put("ipi", 16);
    freq.put("ipn", 10);
    freq.put("ipo", 43);
    freq.put("ipl", 17);
    freq.put("ipr", 25);
    freq.put("ips", 27);
    freq.put("ipp", 8);
    freq.put("ipt", 9);
    freq.put("ipu", 34);
    freq.put("veš", 15);
    freq.put("ip ", 44);
    freq.put("već", 133);
    freq.put("mba", 28);
    freq.put("več", 53);
    freq.put("DO ", 14);
    freq.put("ov ", 97);
    freq.put("ñ", 7);
    freq.put("bI", 10);
    freq.put("ST ", 20);
    freq.put("s ", 2450);
    freq.put("sZ", 10);
    freq.put("bR", 10);
    freq.put("sS", 22);
    freq.put("sR", 12);
    freq.put("sP", 7);
    freq.put("sW", 11);
    freq.put("sU", 7);
    freq.put("sT", 18);
    freq.put("sK", 14);
    freq.put("sJ", 14);
    freq.put("sI", 11);
    freq.put("sO", 12);
    freq.put("sN", 14);
    freq.put("sM", 30);
    freq.put("sL", 11);
    freq.put("sB", 12);
    freq.put("sA", 15);
    freq.put("sG", 18);
    freq.put("sF", 12);
    freq.put("sE", 9);
    freq.put("sD", 13);
    freq.put("sz", 16);
    freq.put("sy", 43);
    freq.put("sx", 11);
    freq.put("ss", 193);
    freq.put("sr", 474);
    freq.put("sq", 21);
    freq.put("sp", 833);
    freq.put("sw", 14);
    freq.put("sv", 1412);
    freq.put("su", 1480);
    freq.put("st", 5108);
    freq.put("sk", 1587);
    freq.put("sj", 176);
    freq.put("si", 1721);
    freq.put("sh", 513);
    freq.put("so", 621);
    freq.put("sn", 670);
    freq.put("sm", 799);
    freq.put("sl", 1467);
    freq.put("sc", 152);
    freq.put("sb", 38);
    freq.put("sa", 4367);
    freq.put("sg", 8);
    freq.put("sf", 31);
    freq.put("se", 3826);
    freq.put("sd", 26);
    freq.put("──", 7);
    freq.put("KA ", 49);
    freq.put("ttp", 2327);
    freq.put("tti", 11);
    freq.put("tto", 9);
    freq.put("Kam", 11);
    freq.put("ttl", 7);
    freq.put("RH ", 13);
    freq.put("tta", 7);
    freq.put("neš", 93);
    freq.put("tte", 51);
    freq.put("jig", 67);
    freq.put("dju", 66);
    freq.put("ša ", 69);
    freq.put("jin", 61);
    freq.put("jio", 16);
    freq.put("jil", 26);
    freq.put("jim", 184);
    freq.put("jih", 116);
    freq.put("jiv", 112);
    freq.put("jit", 37);
    freq.put("jir", 12);
    freq.put("jis", 12);
    freq.put("dji", 42);
    freq.put("djo", 13);
    freq.put("Že", 31);
    freq.put("Ža", 11);
    freq.put("tt ", 11);
    freq.put("Ži", 20);
    freq.put("LI ", 80);
    freq.put("ji ", 935);
    freq.put("šam", 30);
    freq.put("šal", 38);
    freq.put("šao", 33);
    freq.put("šan", 29);
    freq.put("šak", 11);
    freq.put("šaj", 11);
    freq.put("šat", 8);
    freq.put("šav", 37);
    freq.put("šar", 7);
    freq.put("Jor", 7);
    freq.put("Jos", 31);
    freq.put("pšt", 28);
    freq.put("Jov", 53);
    freq.put("blu", 13);
    freq.put("pša", 8);
    freq.put("blo", 43);
    freq.put("bli", 82);
    freq.put("pše", 12);
    freq.put("blj", 56);
    freq.put("Joh", 19);
    freq.put("pši", 15);
    freq.put("Joj", 8);
    freq.put("Jok", 13);
    freq.put("bla", 61);
    freq.put(" đu", 8);
    freq.put("sač", 11);
    freq.put("sać", 7);
    freq.put("Jo ", 17);
    freq.put(" đe", 7);
    freq.put("onj", 39);
    freq.put("onk", 16);
    freq.put("oni", 288);
    freq.put("onn", 11);
    freq.put("ono", 275);
    freq.put("onl", 85);
    freq.put("onc", 69);
    freq.put("ona", 399);
    freq.put("onf", 7);
    freq.put(" Z ", 16);
    freq.put("ond", 169);
    freq.put("one", 270);
    freq.put("onz", 20);
    freq.put("ons", 63);
    freq.put("ont", 92);
    freq.put("onu", 85);
    freq.put("jiš", 7);
    freq.put("ukv", 13);
    freq.put("uku", 102);
    freq.put("ukt", 8);
    freq.put("uks", 11);
    freq.put("ukr", 25);
    freq.put("uko", 66);
    freq.put("ukn", 20);
    freq.put("ukl", 36);
    freq.put("uki", 36);
    freq.put("již", 8);
    freq.put("uke", 67);
    freq.put("ukc", 10);
    freq.put("uka", 187);
    freq.put("jić", 11);
    freq.put(" Zo", 36);
    freq.put(" Zn", 54);
    freq.put(" Zi", 31);
    freq.put(" Ze", 38);
    freq.put(" Zd", 15);
    freq.put("on ", 437);
    freq.put(" Za", 285);
    freq.put(" Zb", 11);
    freq.put(" Zu", 11);
    freq.put(" Zv", 26);
    freq.put("rze", 24);
    freq.put("rza", 63);
    freq.put("rzo", 18);
    freq.put("rzn", 15);
    freq.put("drž", 68);
    freq.put("rzi", 101);
    freq.put("rzu", 10);
    freq.put("uk ", 52);
    freq.put("sak", 68);
    freq.put("saj", 73);
    freq.put("sai", 8);
    freq.put("sah", 9);
    freq.put("sao", 128);
    freq.put("san", 198);
    freq.put("sam", 1975);
    freq.put("sal", 105);
    freq.put("sac", 15);
    freq.put("sab", 15);
    freq.put("sag", 9);
    freq.put("sad", 434);
    freq.put("saz", 28);
    freq.put("sas", 58);
    freq.put("sar", 48);
    freq.put("sap", 18);
    freq.put("sav", 137);
    freq.put("sat", 144);
    freq.put("zob", 8);
    freq.put("zoc", 8);
    freq.put("zod", 15);
    freq.put("zof", 9);
    freq.put("zol", 11);
    freq.put("zom", 11);
    freq.put("zon", 47);
    freq.put("Još", 29);
    freq.put("ax ", 21);
    freq.put("zos", 9);
    freq.put("zov", 108);
    freq.put("sa ", 824);
    freq.put("zo ", 24);
    freq.put("ood", 43);
    freq.put("axa", 10);
    freq.put("axi", 11);
    freq.put("Skr", 8);
    freq.put("Sko", 17);
    freq.put("Ski", 8);
    freq.put("đaj", 13);
    freq.put("uy", 8);
    freq.put("uz", 514);
    freq.put("uu", 102);
    freq.put("cij", 544);
    freq.put("ivš", 10);
    freq.put("uq", 8);
    freq.put("up", 754);
    freq.put("NE ", 164);
    freq.put("ur", 839);
    freq.put("um", 593);
    freq.put(" b ", 32);
    freq.put("ul", 540);
    freq.put("vku", 14);
    freq.put("un", 662);
    freq.put("vko", 48);
    freq.put("vka", 24);
    freq.put("uh", 120);
    freq.put("cit", 109);
    freq.put("ciz", 10);
    freq.put(" be", 347);
    freq.put(" bg", 9);
    freq.put(" ba", 456);
    freq.put("kje", 11);
    freq.put(" bm", 10);
    freq.put(" bl", 151);
    freq.put(" bo", 436);
    freq.put(" bi", 1101);
    freq.put(" bj", 7);
    freq.put(" bu", 358);
    freq.put(" bt", 14);
    freq.put("s", 28480);
    freq.put("kju", 7);
    freq.put(" by", 9);
    freq.put("RU ", 10);
    freq.put(" ša", 50);
    freq.put(" še", 29);
    freq.put(" ši", 12);
    freq.put(" šk", 25);
    freq.put(" šl", 7);
    freq.put(" šm", 8);
    freq.put(" šo", 20);
    freq.put(" št", 436);
    freq.put(" šu", 14);
    freq.put("vuc", 21);
    freq.put("fil", 111);
    freq.put("ive", 121);
    freq.put("iva", 380);
    freq.put("ivc", 18);
    freq.put("ivl", 27);
    freq.put("ivn", 106);
    freq.put("ivo", 372);
    freq.put("ivi", 141);
    freq.put("ivk", 7);
    freq.put("ivu", 16);
    freq.put("ivs", 14);
    freq.put("UT ", 9);
    freq.put("eša", 30);
    freq.put("iv ", 105);
    freq.put("I", 1446);
    freq.put(" gu", 86);
    freq.put("DI ", 21);
    freq.put("gda", 22);
    freq.put("gde", 86);
    freq.put("gdj", 38);
    freq.put("Mac", 16);
    freq.put("gd ", 8);
    freq.put("Mak", 37);
    freq.put("NA ", 155);
    freq.put("BO ", 7);
    freq.put("Man", 45);
    freq.put("aš", 590);
    freq.put("tvu", 21);
    freq.put("ezu", 48);
    freq.put("ezv", 11);
    freq.put("tvr", 59);
    freq.put("ezn", 56);
    freq.put("ezo", 39);
    freq.put("tvi", 334);
    freq.put("ezi", 102);
    freq.put("ezd", 62);
    freq.put("eze", 77);
    freq.put("tva", 256);
    freq.put("eza", 97);
    freq.put("ezb", 32);
    freq.put("až", 286);
    freq.put("ac ", 255);
    freq.put("jgl", 8);
    freq.put("jgo", 36);
    freq.put(" žr", 7);
    freq.put(" žu", 13);
    freq.put(" ži", 162);
    freq.put("ddi", 11);
    freq.put(" ža", 19);
    freq.put("dda", 8);
    freq.put(" že", 141);
    freq.put("acB", 7);
    freq.put("ez ", 169);
    freq.put("tv ", 12);
    freq.put("Hoć", 18);
    freq.put("aca", 176);
    freq.put("ać", 146);
    freq.put("ack", 95);
    freq.put("aci", 534);
    freq.put("ach", 57);
    freq.put("aco", 24);
    freq.put("acn", 22);
    freq.put("ađ", 122);
    freq.put("acr", 9);
    freq.put("acu", 84);
    freq.put("act", 10);
    freq.put("dd ", 10);
    freq.put("Nh", 9);
    freq.put("Ni", 361);
    freq.put("Nj", 33);
    freq.put("bja", 59);
    freq.put("No", 167);
    freq.put("Na", 326);
    freq.put("Ne", 558);
    freq.put("Nf", 7);
    freq.put("Nx", 8);
    freq.put("Ns", 7);
    freq.put("Nu", 19);
    freq.put("Nw", 8);
    freq.put("het", 17);
    freq.put("hev", 8);
    freq.put("her", 60);
    freq.put("hes", 13);
    freq.put("hed", 7);
    freq.put("hee", 17);
    freq.put("hef", 7);
    freq.put("hea", 13);
    freq.put("hec", 8);
    freq.put("hel", 17);
    freq.put("hem", 18);
    freq.put("hen", 15);
    freq.put("heh", 23);
    freq.put("hej", 17);
    freq.put("N ", 156);
    freq.put("zne", 56);
    freq.put("Ček", 7);
    freq.put("he ", 137);
    freq.put("nSt", 7);
    freq.put("aa", 594);
    freq.put("ac", 1461);
    freq.put("ab", 509);
    freq.put("ae", 121);
    freq.put("Hoc", 7);
    freq.put("ag", 618);
    freq.put("af", 208);
    freq.put("ai", 231);
    freq.put("ah", 780);
    freq.put("Hol", 18);
    freq.put("aj", 2862);
    freq.put("am", 5610);
    freq.put("al", 3546);
    freq.put("ao", 1185);
    freq.put("an", 5750);
    freq.put("aq", 29);
    freq.put("ap", 803);
    freq.put("as", 2469);
    freq.put("ar", 3032);
    freq.put("au", 245);
    freq.put("at", 3032);
    freq.put("aw", 42);
    freq.put("av", 2897);
    freq.put("ay", 149);
    freq.put("ax", 60);
    freq.put("ohv", 9);
    freq.put("az", 1413);
    freq.put("aA", 27);
    freq.put("aC", 30);
    freq.put("aB", 77);
    freq.put("aE", 16);
    freq.put("aD", 46);
    freq.put("aG", 29);
    freq.put("aF", 16);
    freq.put("aI", 16);
    freq.put("aH", 10);
    freq.put("aK", 45);
    freq.put("aJ", 32);
    freq.put("aM", 67);
    freq.put("aL", 20);
    freq.put("aO", 11);
    freq.put("aN", 27);
    freq.put("aQ", 8);
    freq.put("aP", 37);
    freq.put("aS", 68);
    freq.put("aR", 35);
    freq.put("aU", 7);
    freq.put("aT", 30);
    freq.put("aW", 12);
    freq.put("aV", 26);
    freq.put("aY", 11);
    freq.put("aX", 7);
    freq.put("aZ", 19);
    freq.put("a ", 26785);
    freq.put("oh ", 43);
    freq.put("uši", 34);
    freq.put("ška", 44);
    freq.put("at ", 364);
    freq.put("smu", 46);
    freq.put("sco", 12);
    freq.put("viš", 153);
    freq.put("sci", 19);
    freq.put("sch", 11);
    freq.put("sce", 53);
    freq.put("tT", 8);
    freq.put("tU", 9);
    freq.put("tR", 8);
    freq.put("tS", 11);
    freq.put("smr", 40);
    freq.put("mni", 22);
    freq.put("mnj", 12);
    freq.put("tM", 8);
    freq.put("tH", 11);
    freq.put("tI", 9);
    freq.put("tF", 8);
    freq.put("mna", 28);
    freq.put("tD", 13);
    freq.put("tE", 7);
    freq.put("tB", 7);
    freq.put("tC", 10);
    freq.put("Fil", 17);
    freq.put("smo", 242);
    freq.put("zmi", 63);
    freq.put("tz", 39);
    freq.put("tx", 7);
    freq.put("ty", 63);
    freq.put("tv", 1008);
    freq.put("tw", 114);
    freq.put("tt", 2438);
    freq.put("tu", 1103);
    freq.put("tr", 1795);
    freq.put("ts", 239);
    freq.put("tp", 2443);
    freq.put("tq", 9);
    freq.put("tn", 521);
    freq.put("to", 3816);
    freq.put("tl", 111);
    freq.put("tm", 71);
    freq.put("tj", 96);
    freq.put("tk", 363);
    freq.put("th", 148);
    freq.put("ti", 4256);
    freq.put("tf", 16);
    freq.put("tg", 15);
    freq.put("td", 24);
    freq.put("te", 3659);
    freq.put("tb", 8);
    freq.put("tc", 37);
    freq.put("ta", 4786);
    freq.put("smi", 121);
    freq.put("mn ", 10);
    freq.put("sme", 189);
    freq.put("ro", 2768);
    freq.put("vić", 172);
    freq.put(" s", 13505);
    freq.put("vič", 14);
    freq.put(" dž", 16);
    freq.put("viđ", 31);
    freq.put("sma", 105);
    freq.put("t ", 4341);
    freq.put("žr", 8);
    freq.put("žu", 71);
    freq.put("Smo", 7);
    freq.put("ži", 415);
    freq.put("žj", 8);
    freq.put("žn", 79);
    freq.put("žo", 7);
    freq.put("qma", 23);
    freq.put("ža", 176);
    freq.put("žb", 36);
    freq.put("žd", 56);
    freq.put("že", 553);
    freq.put("Sma", 12);
    freq.put("ž ", 10);
    freq.put("vib", 9);
    freq.put("vic", 420);
    freq.put("via", 128);
    freq.put("vig", 7);
    freq.put("vid", 395);
    freq.put("vie", 10);
    freq.put("vij", 240);
    freq.put("vik", 69);
    freq.put("vih", 76);
    freq.put("vin", 186);
    freq.put("vio", 82);
    freq.put("vil", 106);
    freq.put("vim", 279);
    freq.put("vir", 87);
    freq.put("vis", 268);
    freq.put("Aus", 9);
    freq.put("viv", 10);
    freq.put("vit", 511);
    freq.put("viz", 71);
    freq.put("kl ", 10);
    freq.put(" d ", 45);
    freq.put("VE ", 35);
    freq.put("vi ", 853);
    freq.put(" do", 1362);
    freq.put("kle", 58);
    freq.put(" dm", 20);
    freq.put(" dl", 15);
    freq.put(" dj", 83);
    freq.put(" di", 248);
    freq.put(" dg", 12);
    freq.put(" de", 595);
    freq.put("klo", 66);
    freq.put("kli", 70);
    freq.put(" da", 4564);
    freq.put("klu", 47);
    freq.put(" dz", 33);
    freq.put(" dv", 178);
    freq.put(" du", 199);
    freq.put(" dr", 528);
    freq.put(" dp", 8);
    freq.put("isp", 183);
    freq.put("RS ", 26);
    freq.put("atr", 83);
    freq.put("ćen", 37);
    freq.put("ćem", 47);
    freq.put("itn", 95);
    freq.put("ito", 166);
    freq.put("IP ", 14);
    freq.put("itk", 26);
    freq.put("ith", 14);
    freq.put("iti", 650);
    freq.put("itd", 10);
    freq.put("ite", 707);
    freq.put("itc", 20);
    freq.put("ita", 503);
    freq.put("itz", 22);
    freq.put("itv", 19);
    freq.put("qko", 19);
    freq.put("itt", 57);
    freq.put("itu", 106);
    freq.put("itr", 28);
    freq.put("its", 13);
    freq.put("jež", 25);
    freq.put("ješ", 87);
    freq.put("jeđ", 8);
    freq.put("it ", 248);
    freq.put("jeć", 49);
    freq.put("ječ", 46);
    freq.put("tro", 225);
    freq.put("cc ", 29);
    freq.put("šeš", 9);
    freq.put(" A ", 221);
    freq.put("fte", 11);
    freq.put("fti", 10);
    freq.put(" Aa", 13);
    freq.put(" Ac", 17);
    freq.put(" Ad", 25);
    freq.put(" Af", 12);
    freq.put(" Ag", 13);
    freq.put(" Ah", 10);
    freq.put(" Ai", 13);
    freq.put(" Aj", 44);
    freq.put(" Ak", 121);
    freq.put(" Al", 161);
    freq.put(" Am", 37);
    freq.put(" An", 144);
    freq.put(" Ap", 28);
    freq.put(" Aq", 10);
    freq.put(" Ar", 53);
    freq.put(" As", 19);
    freq.put(" At", 20);
    freq.put(" Au", 26);
    freq.put(" Av", 16);
    freq.put(" Ay", 8);
    freq.put(" Az", 12);
    freq.put("NG ", 13);
    freq.put("tru", 149);
    freq.put("ft ", 9);
    freq.put("w", 988);
    freq.put("oG ", 7);
    freq.put("Fra", 37);
    freq.put("Fre", 11);
    freq.put("Č", 98);
    freq.put("KE ", 30);
    freq.put("jer", 343);
    freq.put("jes", 370);
    freq.put("jep", 70);
    freq.put("jev", 174);
    freq.put("aa ", 159);
    freq.put("jet", 284);
    freq.put("jez", 76);
    freq.put("jeb", 191);
    freq.put("jec", 74);
    freq.put("jea", 10);
    freq.put("jef", 11);
    freq.put("jeg", 133);
    freq.put("jed", 770);
    freq.put("jee", 24);
    freq.put("jej", 8);
    freq.put("jek", 143);
    freq.put("jeh", 23);
    freq.put("jen", 488);
    freq.put("jeo", 14);
    freq.put("jel", 308);
    freq.put("jem", 545);
    freq.put("aaa", 286);
    freq.put("šet", 12);
    freq.put("abr", 74);
    freq.put("aam", 11);
    freq.put("aan", 7);
    freq.put("aah", 9);
    freq.put("LU ", 10);
    freq.put("aat", 24);
    freq.put("je ", 5491);
    freq.put("šeg", 10);
    freq.put("aar", 9);
    freq.put("odl", 86);
    freq.put("šem", 37);
    freq.put("šen", 42);
    freq.put("OT ", 11);
    freq.put("ex ", 40);
    freq.put("tp ", 2292);
    freq.put("M", 2068);
    freq.put("Isu", 11);
    freq.put("Ist", 29);
    freq.put("Isk", 13);
    freq.put("tpe", 7);
    freq.put("exe", 8);
    freq.put("tpa", 7);
    freq.put("exa", 18);
    freq.put("tpo", 14);
    freq.put("tpi", 18);
    freq.put("ext", 12);
    freq.put("exu", 9);
    freq.put("tps", 40);
    freq.put("tpr", 38);
    freq.put("Hah", 38);
    freq.put("Haj", 18);
    freq.put("oju", 114);
    freq.put("Hal", 11);
    freq.put("ojs", 14);
    freq.put("Han", 8);
    freq.put("ugl", 28);
    freq.put("uga", 151);
    freq.put("uge", 51);
    freq.put("oje", 551);
    freq.put("ojc", 14);
    freq.put("oja", 358);
    freq.put("Hap", 10);
    freq.put("ojo", 62);
    freq.put("Har", 18);
    freq.put("ojm", 20);
    freq.put("ojk", 91);
    freq.put("ugu", 36);
    freq.put("oji", 621);
    freq.put("Če", 27);
    freq.put("Ča", 8);
    freq.put("Ha ", 8);
    freq.put("Čo", 10);
    freq.put("ug ", 53);
    freq.put("Či", 16);
    freq.put("Ču", 15);
    freq.put("oj ", 677);
    freq.put("crv", 22);
    freq.put("crt", 14);
    freq.put("rfe", 11);
    freq.put("crk", 26);
    freq.put("rfo", 8);
    freq.put("cro", 27);
    freq.put("Fot", 7);
    freq.put("sev", 28);
    freq.put("set", 101);
    freq.put("ča", 356);
    freq.put("ser", 101);
    freq.put("For", 19);
    freq.put("sep", 13);
    freq.put("čl", 11);
    freq.put("čo", 63);
    freq.put("čn", 201);
    freq.put("či", 488);
    freq.put("sez", 17);
    freq.put("čk", 210);
    freq.put("sex", 22);
    freq.put("ču", 126);
    freq.put("see", 7);
    freq.put("sed", 59);
    freq.put("sec", 100);
    freq.put("seb", 150);
    freq.put("sea", 17);
    freq.put("seo", 18);
    freq.put("sen", 95);
    freq.put("Fon", 8);
    freq.put("sel", 106);
    freq.put("sek", 95);
    freq.put("sej", 8);
    freq.put("ZO ", 7);
    freq.put("č ", 60);
    freq.put("ue ", 29);
    freq.put("se ", 2648);
    freq.put("vođ", 11);
    freq.put("pda", 10);
    freq.put("lex", 34);
    freq.put("xax", 9);
    freq.put("tiv", 199);
    freq.put("žda", 45);
    freq.put("nro", 7);
    freq.put("mla", 62);
    freq.put("Old", 7);
    freq.put("ĆE ", 16);
    freq.put("mlj", 106);
    freq.put("Oli", 11);
    freq.put("mli", 9);
    freq.put("xa ", 18);
    freq.put("vod", 161);
    freq.put("vog", 108);
    freq.put("voc", 11);
    freq.put("vol", 342);
    freq.put("vom", 108);
    freq.put("von", 41);
    freq.put("voo", 12);
    freq.put("voj", 503);
    freq.put("vok", 17);
    freq.put("vot", 269);
    freq.put("vou", 14);
    freq.put("vov", 18);
    freq.put("psi", 25);
    freq.put("vor", 329);
    freq.put("vos", 40);
    freq.put("voz", 62);
    freq.put("kn ", 16);
    freq.put(" f ", 15);
    freq.put("psa", 18);
    freq.put("vo ", 796);
    freq.put("tis", 114);
    freq.put("pse", 14);
    freq.put(" fr", 77);
    freq.put(" fu", 65);
    freq.put("kni", 21);
    freq.put("kne", 35);
    freq.put("kna", 11);
    freq.put(" fa", 187);
    freq.put(" fb", 30);
    freq.put(" fe", 132);
    freq.put(" ff", 24);
    freq.put(" fi", 175);
    freq.put(" fk", 8);
    freq.put("knu", 14);
    freq.put(" fl", 23);
    freq.put(" fo", 147);
    freq.put("uđ", 45);
    freq.put("O ", 732);
    freq.put("uč", 267);
    freq.put("uć", 152);
    freq.put("Ves", 21);
    freq.put("Oo", 7);
    freq.put("On", 139);
    freq.put("Om", 11);
    freq.put("Ol", 30);
    freq.put("Ok", 37);
    freq.put("Oj", 8);
    freq.put("Oh", 12);
    freq.put("Og", 16);
    freq.put("Of", 25);
    freq.put("Oe", 8);
    freq.put("Od", 116);
    freq.put("Oc", 16);
    freq.put("Ob", 78);
    freq.put("Oa", 13);
    freq.put("đaš", 8);
    freq.put("Oz", 19);
    freq.put("Oy", 11);
    freq.put("Jas", 14);
    freq.put("Ow", 12);
    freq.put("Ov", 126);
    freq.put("Ou", 9);
    freq.put("Ot", 65);
    freq.put("Os", 57);
    freq.put("Or", 35);
    freq.put("Op", 59);
    freq.put("už", 181);
    freq.put("d", 21802);
    freq.put("uš", 264);
    freq.put(" Dz", 21);
    freq.put("ijs", 46);
    freq.put("b ", 218);
    freq.put("iju", 289);
    freq.put("ija", 1112);
    freq.put("ijd", 8);
    freq.put("ije", 1717);
    freq.put("iji", 268);
    freq.put("ijk", 8);
    freq.put("Vel", 29);
    freq.put("ijo", 31);
    freq.put("tsa", 9);
    freq.put("UP ", 11);
    freq.put("bd", 12);
    freq.put("be", 1053);
    freq.put("bf", 7);
    freq.put("bg", 41);
    freq.put("ba", 1689);
    freq.put("bb", 23);
    freq.put("bc", 13);
    freq.put("bl", 397);
    freq.put("bm", 15);
    freq.put("bn", 89);
    freq.put("bo", 1269);
    freq.put("bi", 2238);
    freq.put("bj", 124);
    freq.put("ij ", 19);
    freq.put("bu", 682);
    freq.put("bv", 20);
    freq.put("bw", 7);
    freq.put("bp", 8);
    freq.put("br", 934);
    freq.put("bs", 27);
    freq.put("by", 26);
    freq.put("bz", 13);
    freq.put("Fu", 26);
    freq.put("bC", 7);
    freq.put("bL", 11);
    freq.put("bH", 7);
    freq.put("Ost", 16);
    freq.put("bK", 9);
    freq.put("bT", 7);
    freq.put("bQ", 9);
    freq.put("Oso", 8);
    freq.put("DE ", 38);
    freq.put("oAd", 7);
    freq.put("ME ", 45);
    freq.put(" C ", 27);
    freq.put("đa ", 34);
    freq.put("Oč", 9);
    freq.put("ci ", 680);
    freq.put("Fb", 9);
    freq.put("u ", 9306);
    freq.put("Fe", 46);
    freq.put(" Ch", 30);
    freq.put(" Ci", 52);
    freq.put(" Co", 49);
    freq.put(" Cl", 16);
    freq.put("uZ", 8);
    freq.put("uT", 36);
    freq.put(" Ca", 45);
    freq.put("uP", 10);
    freq.put(" Ce", 68);
    freq.put("uO", 7);
    freq.put("uJ", 9);
    freq.put(" Cr", 109);
    freq.put("uG", 7);
    freq.put("đan", 25);
    freq.put("uA", 8);
    freq.put(" Cu", 30);
    freq.put("cic", 112);
    freq.put("cia", 14);
    freq.put("AC ", 16);
    freq.put("cig", 53);
    freq.put("ux", 25);
    freq.put("cie", 8);
    freq.put("cid", 9);
    freq.put("cik", 20);
    freq.put("ut", 1125);
    freq.put("cii", 7);
    freq.put("uv", 362);
    freq.put("cio", 67);
    freq.put("cin", 118);
    freq.put("cim", 157);
    freq.put("cil", 45);
    freq.put("cis", 41);
    freq.put("cir", 38);
    freq.put("uo", 117);
    freq.put("cip", 16);
    freq.put("ui", 50);
    freq.put("civ", 12);
    freq.put("uk", 651);
    freq.put("uj", 656);
    freq.put("ue", 86);
    freq.put("ud", 1201);
    freq.put("ug", 562);
    freq.put("uf", 46);
    freq.put("ua", 125);
    freq.put("uc", 564);
    freq.put("ub", 759);
    freq.put("aBa", 24);
    freq.put("zal", 105);
    freq.put("EZ ", 8);
    freq.put("ag ", 25);
    freq.put("jce", 10);
    freq.put("jca", 7);
    freq.put("jci", 26);
    freq.put("ago", 109);
    freq.put("agn", 12);
    freq.put("agl", 24);
    freq.put("agi", 63);
    freq.put("agg", 7);
    freq.put("age", 49);
    freq.put("šku", 7);
    freq.put("ški", 17);
    freq.put("ško", 66);
    freq.put("agu", 46);
    freq.put("agr", 144);
    freq.put("ške", 16);
    freq.put("Dju", 10);
    freq.put("qva", 8);
    freq.put("Dja", 7);
    freq.put("bva", 9);
    freq.put("Dje", 19);
    freq.put("Dji", 10);
    freq.put("Djo", 26);
    freq.put("ev ", 40);
    freq.put("tr ", 15);
    freq.put("Dj ", 16);
    freq.put("zič", 10);
    freq.put("evU", 7);
    freq.put("tri", 188);
    freq.put("evi", 221);
    freq.put("evj", 11);
    freq.put("evl", 13);
    freq.put("evn", 26);
    freq.put("evo", 198);
    freq.put("tra", 642);
    freq.put("eva", 207);
    freq.put("trc", 16);
    freq.put("tre", 476);
    freq.put("eve", 174);
    freq.put("trg", 13);
    freq.put("trq", 8);
    freq.put("trp", 11);
    freq.put("evr", 52);
    freq.put("evs", 13);
    freq.put("evt", 7);
    freq.put("evu", 18);
    freq.put("le ", 563);
    freq.put("uel", 13);
    freq.put("odz", 8);
    freq.put("Blu", 7);
    freq.put("odr", 84);
    freq.put("ods", 39);
    freq.put("odu", 136);
    freq.put("odv", 32);
    freq.put("odi", 513);
    freq.put("Blo", 9);
    freq.put("Bli", 34);
    freq.put("odm", 61);
    freq.put("odn", 148);
    freq.put("odo", 86);
    freq.put("oda", 261);
    freq.put("odb", 32);
    freq.put("Bla", 28);
    freq.put("ode", 169);
    freq.put("ues", 10);
    freq.put("odg", 93);
    freq.put("ct ", 7);
    freq.put("rd ", 32);
    freq.put("lea", 11);
    freq.put("leb", 15);
    freq.put("lec", 14);
    freq.put("led", 492);
    freq.put("lee", 40);
    freq.put("lef", 54);
    freq.put("leg", 49);
    freq.put("lei", 7);
    freq.put("lej", 28);
    freq.put("lek", 138);
    freq.put("lel", 27);
    freq.put("lem", 114);
    freq.put("len", 157);
    freq.put("leo", 26);
    freq.put("lep", 159);
    freq.put("ler", 64);
    freq.put("les", 114);
    freq.put("let", 123);
    freq.put("leu", 24);
    freq.put("lev", 53);
    freq.put("od ", 974);
    freq.put("lez", 39);
    freq.put("rdu", 7);
    freq.put("rdr", 7);
    freq.put("leL", 8);
    freq.put("rde", 24);
    freq.put("cte", 9);
    freq.put("rda", 65);
    freq.put("rdo", 27);
    freq.put("rdn", 12);
    freq.put("rdi", 58);
    freq.put("cti", 20);
    freq.put("rdj", 38);
    freq.put("trč", 12);
    freq.put("Đ", 27);
    freq.put("ziv", 272);
    freq.put("zit", 43);
    freq.put("zir", 41);
    freq.put("zis", 15);
    freq.put("zig", 8);
    freq.put("zid", 19);
    freq.put("zic", 55);
    freq.put("zin", 48);
    freq.put("zio", 32);
    freq.put("zil", 39);
    freq.put("zim", 184);
    freq.put("zij", 122);
    freq.put("zik", 81);
    freq.put("о", 7);
    freq.put("dza", 21);
    freq.put("aBo", 13);
    freq.put("aBr", 10);
    freq.put("zi ", 210);
    freq.put("oz ", 55);
    freq.put("cni", 48);
    freq.put("leć", 7);
    freq.put("On ", 24);
    freq.put("Q", 248);
    freq.put("afo", 14);
    freq.put("lež", 15);
    freq.put("mje", 122);
    freq.put("Oni", 8);
    freq.put("Ono", 27);
    freq.put("Onl", 22);
    freq.put("Ona", 30);
    freq.put("Ond", 10);
    freq.put("One", 10);
    freq.put("Yc", 9);
    freq.put("VI ", 41);
    freq.put("TY ", 7);
    freq.put("lz ", 7);
    freq.put("Sa ", 55);
    freq.put("kp ", 7);
    freq.put(" h ", 54);
    freq.put("Sak", 8);
    freq.put("Saj", 13);
    freq.put("San", 37);
    freq.put("Sam", 110);
    freq.put("Sal", 9);
    freq.put("Sab", 16);
    freq.put("zat", 147);
    freq.put(" hv", 62);
    freq.put(" hu", 34);
    freq.put("Sad", 68);
    freq.put(" hi", 77);
    freq.put(" ho", 182);
    freq.put(" hn", 9);
    freq.put(" hm", 15);
    freq.put(" hl", 24);
    freq.put("Sas", 9);
    freq.put("Sar", 40);
    freq.put(" ha", 264);
    freq.put("Sap", 8);
    freq.put("Sav", 20);
    freq.put(" he", 79);
    freq.put("Zna", 55);
    freq.put("zap", 135);
    freq.put("OM ", 39);
    freq.put("ihv", 9);
    freq.put("IT ", 15);
    freq.put("ihi", 22);
    freq.put("iho", 31);
    freq.put("iha", 33);
    freq.put("ćno", 19);
    freq.put("mno", 139);
    freq.put("ih ", 768);
    freq.put("mja", 9);
    freq.put("lly", 12);
    freq.put(" E ", 64);
    freq.put("ck ", 50);
    freq.put(" El", 15);
    freq.put(" Em", 13);
    freq.put(" En", 19);
    freq.put(" Eh", 7);
    freq.put(" Ek", 15);
    freq.put(" Ed", 15);
    freq.put(" Eg", 9);
    freq.put("BI ", 27);
    freq.put(" Ec", 8);
    freq.put(" Ex", 14);
    freq.put(" Et", 24);
    freq.put(" Eu", 36);
    freq.put(" Ev", 99);
    freq.put(" Ep", 7);
    freq.put(" Er", 12);
    freq.put("cke", 27);
    freq.put("cka", 92);
    freq.put("AA ", 14);
    freq.put("cko", 66);
    freq.put("cki", 45);
    freq.put("cku", 31);
    freq.put("ckp", 7);
    freq.put("cks", 14);
    freq.put("qv", 15);
    freq.put("dbi", 24);
    freq.put("dbo", 12);
    freq.put("dba", 42);
    freq.put("OD ", 32);
    freq.put("jaM", 11);
    freq.put("dbr", 10);
    freq.put("dbu", 10);
    freq.put("jaz", 7);
    freq.put("jav", 241);
    freq.put("jat", 164);
    freq.put("jar", 29);
    freq.put("jas", 108);
    freq.put("jap", 11);
    freq.put("jan", 357);
    freq.put("ae ", 22);
    freq.put("jal", 114);
    freq.put("jam", 193);
    freq.put("jaj", 149);
    freq.put("jak", 170);
    freq.put("jah", 11);
    freq.put("jag", 14);
    freq.put("jad", 42);
    freq.put("jab", 8);
    freq.put("jac", 93);
    freq.put("jaa", 22);
    freq.put("lK", 8);
    freq.put("aes", 22);
    freq.put("aet", 15);
    freq.put("h", 7438);
    freq.put("šir", 19);
    freq.put("šim", 26);
    freq.put("šil", 21);
    freq.put("šio", 13);
    freq.put("šin", 21);
    freq.put("ših", 9);
    freq.put("šij", 18);
    freq.put("ael", 25);
    freq.put("ja ", 2404);
    freq.put("Pr", 368);
    freq.put("vš", 13);
    freq.put("btw", 9);
    freq.put("Pu", 51);
    freq.put("oma", 230);
    freq.put("Pa", 264);
    freq.put("OP ", 9);
    freq.put("Pe", 140);
    freq.put("Pj", 11);
    freq.put("Ph", 30);
    freq.put("Pi", 83);
    freq.put("Po", 350);
    freq.put("Pl", 48);
    freq.put("et ", 377);
    freq.put("P ", 186);
    freq.put("bt ", 13);
    freq.put("qt ", 15);
    freq.put("tsk", 153);
    freq.put("etr", 36);
    freq.put("ets", 43);
    freq.put("etp", 8);
    freq.put("etv", 59);
    freq.put("ett", 12);
    freq.put("etu", 111);
    freq.put("vč", 12);
    freq.put("tla", 19);
    freq.put("eta", 348);
    freq.put("tle", 22);
    freq.put("ete", 304);
    freq.put("etj", 7);
    freq.put("etk", 82);
    freq.put("eth", 22);
    freq.put("eti", 321);
    freq.put("etn", 157);
    freq.put("eto", 187);
    freq.put("etl", 44);
    freq.put("ck", 367);
    freq.put("cj", 28);
    freq.put("ci", 2113);
    freq.put("ch", 427);
    freq.put("co", 2527);
    freq.put("cn", 195);
    freq.put("cm", 22);
    freq.put("cl", 41);
    freq.put("cc", 60);
    freq.put("cb", 18);
    freq.put("ca", 1588);
    freq.put("cg", 13);
    freq.put("oč", 230);
    freq.put("ce", 1798);
    freq.put("cd", 9);
    freq.put("cz", 8);
    freq.put("cy", 30);
    freq.put("ucb", 7);
    freq.put("uca", 113);
    freq.put("cs", 13);
    freq.put("cr", 195);
    freq.put("šić", 7);
    freq.put("cp", 12);
    freq.put("uck", 43);
    freq.put("cv", 35);
    freq.put("cu", 732);
    freq.put("ct", 57);
    freq.put("Ger", 8);
    freq.put("cI", 7);
    freq.put("cO", 11);
    freq.put("cN", 12);
    freq.put("cM", 14);
    freq.put("cL", 11);
    freq.put("cC", 7);
    freq.put("cB", 16);
    freq.put("cD", 13);
    freq.put("cZ", 7);
    freq.put("cS", 15);
    freq.put("cP", 7);
    freq.put("Geo", 10);
    freq.put("Gen", 10);
    freq.put("cU", 7);
    freq.put("jaš", 19);
    freq.put("lgo", 39);
    freq.put("lq", 27);
    freq.put("jač", 53);
    freq.put("uc ", 8);
    freq.put("qb", 7);
    freq.put("rbu", 12);
    freq.put("rbo", 11);
    freq.put("Tvi", 69);
    freq.put("rbi", 236);
    freq.put("cvi", 8);
    freq.put("rbe", 15);
    freq.put("cve", 12);
    freq.put("rba", 34);
    freq.put("va", 4245);
    freq.put("vc", 79);
    freq.put("vd", 107);
    freq.put("ve", 2700);
    freq.put("vg", 14);
    freq.put("vi", 4219);
    freq.put("vj", 207);
    freq.put("vk", 101);
    freq.put("vl", 368);
    freq.put("vm", 10);
    freq.put("vn", 496);
    freq.put("vo", 2903);
    freq.put("vp", 10);
    freq.put("vq", 27);
    freq.put("vr", 808);
    freq.put("vs", 120);
    freq.put("vt", 30);
    freq.put("vu", 438);
    freq.put("vv", 7);
    freq.put("vy", 25);
    freq.put("vz", 8);
    freq.put("vB", 8);
    freq.put("vF", 7);
    freq.put("vG", 7);
    freq.put("vJ", 9);
    freq.put("vL", 8);
    freq.put("vM", 7);
    freq.put("zgl", 69);
    freq.put("vU", 10);
    freq.put("zgo", 56);
    freq.put("zga", 15);
    freq.put("v ", 613);
    freq.put("pho", 21);
    freq.put("udž", 9);
    freq.put("ofa", 10);
    freq.put("off", 19);
    freq.put("ofe", 36);
    freq.put("ofi", 48);
    freq.put("ofo", 12);
    freq.put("oft", 7);
    freq.put("Up", 52);
    freq.put("ćuj", 9);
    freq.put("ćut", 16);
    freq.put("xex", 7);
    freq.put("umn", 22);
    freq.put("wee", 43);
    freq.put("day", 22);
    freq.put("wes", 8);
    freq.put("wer", 13);
    freq.put("ću ", 256);
    freq.put("nve", 12);
    freq.put(" hr", 150);
    freq.put("e", 51078);
    freq.put("VO ", 54);
    freq.put("gur", 88);
    freq.put("AT ", 18);
    freq.put("vsa", 9);
    freq.put("vse", 9);
    freq.put("vsi", 13);
    freq.put(" ht", 2361);
    freq.put("iso", 39);
    freq.put(" j ", 28);
    freq.put("lle", 50);
    freq.put(" ju", 206);
    freq.put("krs", 15);
    freq.put("krp", 7);
    freq.put("krv", 28);
    freq.put("kru", 36);
    freq.put(" jo", 373);
    freq.put("kri", 160);
    freq.put(" ji", 30);
    freq.put("kro", 72);
    freq.put(" jk", 9);
    freq.put("Mno", 12);
    freq.put(" je", 3921);
    freq.put(" jd", 11);
    freq.put(" jg", 9);
    freq.put("kra", 268);
    freq.put(" ja", 1092);
    freq.put(" jb", 24);
    freq.put("jzb", 11);
    freq.put("Zla", 10);
    freq.put("Kla", 7);
    freq.put("Kli", 8);
    freq.put("jz ", 14);
    freq.put("OO ", 9);
    freq.put("int", 121);
    freq.put("inu", 224);
    freq.put("inv", 11);
    freq.put("ins", 123);
    freq.put("inn", 10);
    freq.put("ino", 196);
    freq.put("inh", 8);
    freq.put("ini", 345);
    freq.put("inj", 141);
    freq.put("ink", 112);
    freq.put("ind", 57);
    freq.put("ine", 432);
    freq.put("inf", 41);
    freq.put("ing", 194);
    freq.put("ina", 659);
    freq.put("inb", 9);
    freq.put("inc", 58);
    freq.put("eo ", 207);
    freq.put("DA ", 195);
    freq.put("U", 865);
    freq.put("in ", 230);
    freq.put("eob", 9);
    freq.put("CI ", 20);
    freq.put("eog", 45);
    freq.put("eon", 16);
    freq.put("eom", 15);
    freq.put("eol", 9);
    freq.put("eos", 7);
    freq.put("eor", 16);
    freq.put("eop", 15);
    freq.put("eoz", 16);
    freq.put("krš", 8);
    freq.put("rep", 98);
    freq.put("brž", 9);
    freq.put("AH ", 8);
    freq.put("MA ", 78);
    freq.put(" G ", 19);
    freq.put("đem", 33);
    freq.put("đel", 7);
    freq.put("đen", 65);
    freq.put("pte", 12);
    freq.put(" Gu", 22);
    freq.put(" Gr", 81);
    freq.put("Tun", 7);
    freq.put(" Gd", 19);
    freq.put(" Ge", 26);
    freq.put(" Ga", 52);
    freq.put(" Go", 175);
    freq.put(" Gl", 48);
    freq.put(" Gh", 10);
    freq.put(" Gi", 20);
    freq.put("đe ", 57);
    freq.put("oću", 21);
    freq.put("slu", 228);
    freq.put("Cf", 12);
    freq.put("KK ", 9);
    freq.put("lač", 39);
    freq.put("lać", 23);
    freq.put("oćn", 13);
    freq.put("ak ", 571);
    freq.put("lađ", 12);
    freq.put("LS ", 7);
    freq.put("šok", 8);
    freq.put("laš", 28);
    freq.put("laž", 45);
    freq.put("Cr", 127);
    freq.put("gli", 32);
    freq.put("glj", 9);
    freq.put("akx", 12);
    freq.put("glo", 20);
    freq.put("aks", 52);
    freq.put("gla", 294);
    freq.put("gle", 446);
    freq.put("aku", 144);
    freq.put("akt", 70);
    freq.put("aki", 146);
    freq.put("ako", 1319);
    freq.put("akn", 18);
    freq.put("akm", 33);
    freq.put("akl", 72);
    freq.put("akc", 37);
    freq.put("aka", 333);
    freq.put("glu", 130);
    freq.put("ake", 97);
    freq.put("Jer", 24);
    freq.put("Jes", 30);
    freq.put("brz", 38);
    freq.put("ix", 28);
    freq.put("bru", 32);
    freq.put("Jeb", 21);
    freq.put("Jec", 13);
    freq.put("brk", 7);
    freq.put("Jed", 88);
    freq.put("bre", 92);
    freq.put("OR ", 12);
    freq.put("đeš", 9);
    freq.put("iq", 43);
    freq.put("er ", 653);
    freq.put("ip", 362);
    freq.put("nka", 114);
    freq.put("nkc", 16);
    freq.put("nke", 60);
    freq.put("nki", 20);
    freq.put("nkj", 7);
    freq.put("nko", 92);
    freq.put("Je ", 65);
    freq.put("nku", 25);
    freq.put("br ", 7);
    freq.put("ert", 66);
    freq.put("ii", 213);
    freq.put("erv", 84);
    freq.put("erw", 13);
    freq.put("erp", 14);
    freq.put("err", 27);
    freq.put("ih", 885);
    freq.put("ik", 1956);
    freq.put("erz", 28);
    freq.put("erd", 20);
    freq.put("ere", 196);
    freq.put("erf", 14);
    freq.put("erg", 31);
    freq.put("tna", 50);
    freq.put("era", 469);
    freq.put("erb", 55);
    freq.put("erc", 35);
    freq.put("erl", 28);
    freq.put("im", 3766);
    freq.put("ern", 133);
    freq.put("ero", 139);
    freq.put("erh", 12);
    freq.put("eri", 357);
    freq.put("erk", 55);
    freq.put("io", 1121);
    freq.put("uar", 23);
    freq.put("la ", 1626);
    freq.put("Što", 31);
    freq.put("ual", 33);
    freq.put("Šti", 10);
    freq.put("uan", 13);
    freq.put("uac", 19);
    freq.put("Šta", 39);
    freq.put("ki ", 632);
    freq.put("unč", 9);
    freq.put("lal", 22);
    freq.put("lam", 112);
    freq.put("lan", 272);
    freq.put("lao", 11);
    freq.put("lah", 18);
    freq.put("lai", 8);
    freq.put("laj", 71);
    freq.put("lak", 119);
    freq.put("lad", 333);
    freq.put("lag", 82);
    freq.put("laa", 27);
    freq.put("lab", 19);
    freq.put("lac", 103);
    freq.put("lay", 12);
    freq.put("laz", 242);
    freq.put("lat", 210);
    freq.put("lau", 11);
    freq.put("lav", 306);
    freq.put("lap", 28);
    freq.put("lar", 73);
    freq.put("las", 200);
    freq.put("laM", 9);
    freq.put("laD", 7);
    freq.put("laB", 7);
    freq.put("akš", 11);
    freq.put("zej", 12);
    freq.put("zen", 133);
    freq.put("zeo", 14);
    freq.put("zel", 83);
    freq.put("zem", 148);
    freq.put("zer", 44);
    freq.put("zes", 39);
    freq.put("zet", 38);
    freq.put("zez", 17);
    freq.put("pjo", 8);
    freq.put("pje", 73);
    freq.put("pju", 10);
    freq.put("l", 19439);
    freq.put("omš", 17);
    freq.put("mbo", 19);
    freq.put("nt ", 68);
    freq.put("oše", 29);
    freq.put("ćni", 15);
    freq.put("oša", 36);
    freq.put("ošl", 52);
    freq.put("ošk", 15);
    freq.put("oši", 10);
    freq.put("kis", 39);
    freq.put("ošt", 47);
    freq.put("Sve", 72);
    freq.put("nts", 12);
    freq.put("ntr", 53);
    freq.put("ntu", 36);
    freq.put("nti", 111);
    freq.put("nto", 29);
    freq.put("ntn", 27);
    freq.put("nta", 193);
    freq.put("Sva", 43);
    freq.put("nte", 170);
    freq.put("oš ", 145);
    freq.put(" l ", 59);
    freq.put("vqr", 8);
    freq.put("kib", 7);
    freq.put("TU ", 17);
    freq.put("Se ", 7);
    freq.put("kt ", 9);
    freq.put(" le", 273);
    freq.put("B", 1621);
    freq.put(" la", 293);
    freq.put(" lo", 164);
    freq.put(" lj", 524);
    freq.put(" li", 575);
    freq.put(" lu", 129);
    freq.put(" ly", 7);
    freq.put("Sev", 18);
    freq.put("Ser", 26);
    freq.put("ktu", 11);
    freq.put("ktn", 15);
    freq.put("kto", 62);
    freq.put("kti", 65);
    freq.put("kte", 31);
    freq.put("Sel", 20);
    freq.put("Sek", 15);
    freq.put("kta", 33);
    freq.put("Q ", 58);
    freq.put("ype", 12);
    freq.put("sSa", 9);
    freq.put("Qu", 18);
    freq.put("Qw", 10);
    freq.put("Qk", 7);
    freq.put("Qj", 8);
    freq.put("Ql", 7);
    freq.put("Qn", 12);
    freq.put("uda", 154);
    freq.put("d ", 3141);
    freq.put("udj", 41);
    freq.put("IH ", 26);
    freq.put("em ", 1164);
    freq.put("udn", 65);
    freq.put("hrv", 51);
    freq.put("hro", 12);
    freq.put("hri", 11);
    freq.put("hra", 45);
    freq.put("dn", 1043);
    freq.put("do", 1900);
    freq.put("dl", 163);
    freq.put("dm", 116);
    freq.put("dj", 690);
    freq.put("dk", 13);
    freq.put("dh", 20);
    freq.put("di", 2515);
    freq.put("df", 9);
    freq.put("dg", 124);
    freq.put("dd", 42);
    freq.put("de", 2220);
    freq.put("db", 106);
    freq.put("dc", 12);
    freq.put("da", 7002);
    freq.put("dz", 99);
    freq.put("dx", 8);
    freq.put("dy", 30);
    freq.put("dv", 313);
    freq.put("dw", 10);
    freq.put("dt", 18);
    freq.put("du", 705);
    freq.put("dr", 930);
    freq.put("ds", 180);
    freq.put("dp", 29);
    freq.put("dq", 18);
    freq.put("dN", 9);
    freq.put("dO", 11);
    freq.put("dL", 9);
    freq.put("dM", 8);
    freq.put("ema", 520);
    freq.put("dK", 8);
    freq.put("dI", 8);
    freq.put("emm", 8);
    freq.put("dG", 9);
    freq.put("dD", 17);
    freq.put("emn", 26);
    freq.put("dB", 13);
    freq.put("dC", 7);
    freq.put("PA ", 37);
    freq.put("emp", 19);
    freq.put("dX", 8);
    freq.put("dT", 9);
    freq.put("dR", 9);
    freq.put("dS", 9);
    freq.put("w ", 173);
    freq.put(" I ", 395);
    freq.put("MO ", 58);
    freq.put("il ", 83);
    freq.put("nič", 38);
    freq.put("nić", 25);
    freq.put("co ", 2314);
    freq.put("wf", 11);
    freq.put("we", 98);
    freq.put("wc", 24);
    freq.put("wb", 7);
    freq.put("wa", 92);
    freq.put("wo", 38);
    freq.put("wn", 24);
    freq.put("wm", 9);
    freq.put("wl", 8);
    freq.put("wk", 8);
    freq.put("wi", 119);
    freq.put("wh", 32);
    freq.put("ww", 72);
    freq.put("wu", 13);
    freq.put("wt", 10);
    freq.put("ws", 24);
    freq.put(" Im", 106);
    freq.put(" In", 64);
    freq.put("wp", 7);
    freq.put(" Ia", 10);
    freq.put("BU ", 7);
    freq.put(" Id", 36);
    freq.put("wz", 9);
    freq.put("wy", 8);
    freq.put(" Ig", 39);
    freq.put("cos", 7);
    freq.put("ile", 107);
    freq.put("wB", 7);
    freq.put("ila", 536);
    freq.put("iln", 25);
    freq.put("ilo", 291);
    freq.put("ill", 51);
    freq.put("ilm", 69);
    freq.put("ilj", 137);
    freq.put("ilk", 9);
    freq.put("ili", 633);
    freq.put("ilv", 10);
    freq.put("ilt", 7);
    freq.put("ilu", 44);
    freq.put("wS", 8);
    freq.put("ils", 9);
    freq.put("wQ", 12);
    freq.put("cok", 8);
    freq.put("com", 51);
    freq.put("wZ", 8);
    freq.put("coo", 11);
    freq.put("epš", 23);
    freq.put("─", 9);
    freq.put("gn ", 12);
    freq.put("ai ", 40);
    freq.put("šmi", 7);
    freq.put("dž", 63);
    freq.put("dsk", 42);
    freq.put("bna", 16);
    freq.put("aiz", 9);
    freq.put("ait", 10);
    freq.put("aiv", 8);
    freq.put("ais", 20);
    freq.put("air", 19);
    freq.put("aim", 10);
    freq.put("ail", 39);
    freq.put("ET ", 16);
    freq.put("gna", 11);
    freq.put("gne", 37);
    freq.put("gnj", 32);
    freq.put("aid", 17);
    freq.put("gni", 11);
    freq.put("gno", 20);
    freq.put("ni ", 1429);
    freq.put("ep ", 43);
    freq.put("th ", 20);
    freq.put("nij", 683);
    freq.put("nik", 542);
    freq.put("nih", 150);
    freq.put("nii", 8);
    freq.put("nin", 83);
    freq.put("nio", 53);
    freq.put("nil", 44);
    freq.put("nim", 338);
    freq.put("nic", 465);
    freq.put("nia", 34);
    freq.put("nif", 7);
    freq.put("nig", 27);
    freq.put("nie", 32);
    freq.put("niz", 50);
    freq.put("Y", 278);
    freq.put("nis", 532);
    freq.put("nip", 7);
    freq.put("niq", 13);
    freq.put("niv", 24);
    freq.put("nit", 155);
    freq.put("ept", 21);
    freq.put("epu", 19);
    freq.put("epr", 51);
    freq.put("eps", 28);
    freq.put("tho", 12);
    freq.put("epo", 184);
    freq.put("epl", 12);
    freq.put("thi", 18);
    freq.put("epi", 102);
    freq.put("the", 59);
    freq.put("epe", 35);
    freq.put("tha", 15);
    freq.put("epa", 61);
    freq.put("rn ", 30);
    freq.put("Gar", 17);
    freq.put("Gal", 9);
    freq.put("Gag", 7);
    freq.put("Gab", 8);
    freq.put("Tri", 27);
    freq.put("rnj", 31);
    freq.put("rni", 107);
    freq.put("rno", 213);
    freq.put("rnc", 8);
    freq.put("rna", 113);
    freq.put("Tre", 36);
    freq.put("rne", 97);
    freq.put("lce", 12);
    freq.put("rnu", 24);
    freq.put("lci", 12);
    freq.put("mir", 199);
    freq.put("rše", 18);
    freq.put("rša", 14);
    freq.put("ršk", 7);
    freq.put("rši", 30);
    freq.put("ob ", 17);
    freq.put("Lep", 31);
    freq.put("Let", 7);
    freq.put("plu", 14);
    freq.put("rš ", 13);
    freq.put("ple", 56);
    freq.put("aDe", 7);
    freq.put("pla", 287);
    freq.put("aDa", 9);
    freq.put("plo", 50);
    freq.put("plj", 59);
    freq.put("pli", 64);
    freq.put("obn", 41);
    freq.put("obo", 141);
    freq.put("obl", 111);
    freq.put("obj", 88);
    freq.put("obi", 263);
    freq.put("obe", 121);
    freq.put("oba", 243);
    freq.put("obz", 9);
    freq.put("obv", 7);
    freq.put("obu", 115);
    freq.put("obr", 371);
    freq.put("Cur", 7);
    freq.put("wan", 11);
    freq.put("wag", 7);
    freq.put("Vje", 10);
    freq.put("way", 10);
    freq.put("Od ", 49);
    freq.put("war", 8);
    freq.put("eSt", 9);
    freq.put("xy ", 9);
    freq.put("wa ", 13);
    freq.put("mti", 21);
    freq.put("Odl", 14);
    freq.put("Odo", 9);
    freq.put("mte", 7);
    freq.put(" n ", 26);
    freq.put(" ni", 1420);
    freq.put("umu", 26);
    freq.put(" nk", 12);
    freq.put(" nj", 291);
    freq.put(" no", 656);
    freq.put("kva", 110);
    freq.put(" na", 3567);
    freq.put("kvo", 62);
    freq.put(" ne", 3747);
    freq.put(" ng", 10);
    freq.put("kvi", 89);
    freq.put(" ny", 7);
    freq.put("kvu", 7);
    freq.put(" nq", 45);
    freq.put(" np", 11);
    freq.put("Zdr", 12);
    freq.put(" nu", 36);
    freq.put("TW ", 10);
    freq.put("išl", 55);
    freq.put("gu ", 348);
    freq.put("iši", 15);
    freq.put("iše", 203);
    freq.put("iša", 40);
    freq.put("jvu", 18);
    freq.put("jvi", 40);
    freq.put("jvo", 16);
    freq.put("išu", 24);
    freq.put("išt", 123);
    freq.put("jva", 15);
    freq.put("jve", 41);
    freq.put("umm", 7);
    freq.put("umo", 31);
    freq.put("guc", 20);
    freq.put("gub", 49);
    freq.put("gua", 7);
    freq.put("EO ", 38);
    freq.put("gug", 7);
    freq.put("gue", 12);
    freq.put("guj", 18);
    freq.put("gun", 7);
    freq.put("gum", 11);
    freq.put("gul", 9);
    freq.put("gus", 15);
    freq.put("p", 16042);
    freq.put("gut", 14);
    freq.put("guz", 15);
    freq.put("jv ", 8);
    freq.put("hte", 53);
    freq.put("hta", 18);
    freq.put("hto", 28);
    freq.put("htj", 11);
    freq.put("hti", 8);
    freq.put("OK ", 19);
    freq.put("htt", 2327);
    freq.put("žim", 25);
    freq.put("IN ", 12);
    freq.put("KI ", 26);
    freq.put("aoč", 8);
    freq.put("ek ", 347);
    freq.put("ht ", 27);
    freq.put("eko", 489);
    freq.put("ekn", 14);
    freq.put("ekl", 83);
    freq.put("eki", 258);
    freq.put("eke", 94);
    freq.put("ekc", 15);
    freq.put("eka", 514);
    freq.put("Mos", 16);
    freq.put("ekv", 7);
    freq.put("eku", 140);
    freq.put("ekt", 91);
    freq.put("eks", 165);
    freq.put("ekr", 24);
    freq.put("uzm", 33);
    freq.put("uzn", 44);
    freq.put("guć", 28);
    freq.put("uzi", 159);
    freq.put("uzd", 11);
    freq.put("uze", 78);
    freq.put("uza", 58);
    freq.put("uzb", 12);
    freq.put("uzu", 12);
    freq.put("uzv", 15);
    freq.put(" ih", 116);
    freq.put(" Ka", 489);
    freq.put(" Kg", 7);
    freq.put(" Ke", 40);
    freq.put("Vla", 73);
    freq.put(" Ki", 61);
    freq.put(" Kn", 8);
    freq.put(" Ko", 305);
    freq.put(" Kl", 29);
    freq.put(" Kr", 92);
    freq.put(" Ku", 70);
    freq.put("ksa", 49);
    freq.put("điv", 7);
    freq.put("Mon", 20);
    freq.put("F", 615);
    freq.put("caS", 10);
    freq.put(" io", 12);
    freq.put("uz ", 63);
    freq.put("fb ", 26);
    freq.put("caM", 8);
    freq.put("caB", 22);
    freq.put("kso", 9);
    freq.put("ibi", 33);
    freq.put(" K ", 27);
    freq.put("ksn", 8);
    freq.put("ibl", 16);
    freq.put("ibo", 26);
    freq.put("cas", 68);
    freq.put("car", 85);
    freq.put("cav", 17);
    freq.put("cat", 35);
    freq.put("cak", 31);
    freq.put("caj", 131);
    freq.put("cao", 24);
    freq.put("can", 93);
    freq.put("cam", 100);
    freq.put("cal", 48);
    freq.put("cac", 13);
    freq.put("caa", 17);
    freq.put(" ig", 136);
    freq.put("ibu", 11);
    freq.put("ao ", 1060);
    freq.put("spr", 129);
    freq.put("spu", 27);
    freq.put("spi", 81);
    freq.put("spj", 12);
    freq.put("spl", 56);
    freq.put("spo", 211);
    freq.put("spa", 204);
    freq.put("spe", 88);
    freq.put("gh ", 11);
    freq.put("aob", 8);
    freq.put("aoo", 12);
    freq.put("aon", 15);
    freq.put("aok", 7);
    freq.put("aos", 13);
    freq.put("aop", 11);
    freq.put("sp ", 16);
    freq.put("ght", 33);
    freq.put("KO ", 88);
    freq.put("ER ", 35);
    freq.put("Ru", 39);
    freq.put("Che", 8);
    freq.put("Rs", 7);
    freq.put("Jav", 7);
    freq.put("Chi", 7);
    freq.put("Jar", 9);
    freq.put("Ry", 8);
    freq.put("zaš", 61);
    freq.put("Jan", 26);
    freq.put("Re", 125);
    freq.put("Rg", 8);
    freq.put("Ra", 194);
    freq.put("Rb", 7);
    freq.put("Jag", 19);
    freq.put("Jad", 8);
    freq.put("Ro", 94);
    freq.put("Ri", 73);
    freq.put("Rk", 7);
    freq.put("JaS", 7);
    freq.put("nol", 23);
    freq.put("eNa", 8);
    freq.put("non", 21);
    freq.put("noo", 17);
    freq.put("noh", 8);
    freq.put("noj", 86);
    freq.put("nok", 57);
    freq.put("nod", 8);
    freq.put("Usk", 7);
    freq.put("nog", 387);
    freq.put("nob", 11);
    freq.put("noc", 67);
    freq.put("R ", 156);
    freq.put("noz", 9);
    freq.put("not", 36);
    freq.put("nou", 20);
    freq.put("nov", 564);
    freq.put("now", 8);
    freq.put("nop", 11);
    freq.put("Ja ", 206);
    freq.put("nos", 360);
    freq.put("sor", 24);
    freq.put("šit", 16);
    freq.put("sou", 9);
    freq.put("zađ", 7);
    freq.put("em", 2793);
    freq.put("el", 1996);
    freq.put("eo", 390);
    freq.put("en", 3568);
    freq.put("ei", 101);
    freq.put("eh", 169);
    freq.put("ek", 2270);
    freq.put("ej", 446);
    freq.put("ee", 471);
    freq.put("ed", 2535);
    freq.put("eg", 618);
    freq.put("ef", 181);
    freq.put("ea", 324);
    freq.put("rl ", 11);
    freq.put("ec", 976);
    freq.put("eb", 1085);
    freq.put("koč", 11);
    freq.put("ey", 67);
    freq.put("ex", 122);
    freq.put("ez", 734);
    freq.put("eu", 152);
    freq.put("et", 2172);
    freq.put("ew", 39);
    freq.put("ev", 1016);
    freq.put("eq", 9);
    freq.put("ep", 603);
    freq.put("es", 2131);
    freq.put("er", 2769);
    freq.put("eM", 15);
    freq.put("eL", 21);
    freq.put("eO", 10);
    freq.put("eN", 15);
    freq.put("eI", 13);
    freq.put("eH", 12);
    freq.put("eK", 14);
    freq.put("eJ", 12);
    freq.put("eE", 7);
    freq.put("eD", 15);
    freq.put("eG", 9);
    freq.put("eA", 17);
    freq.put("eC", 10);
    freq.put("eB", 15);
    freq.put("und", 43);
    freq.put("eX", 11);
    freq.put("eZ", 13);
    freq.put("eU", 7);
    freq.put("eT", 13);
    freq.put("eV", 9);
    freq.put("eP", 20);
    freq.put("eS", 29);
    freq.put("eR", 7);
    freq.put("rlo", 33);
    freq.put("rli", 47);
    freq.put("rlj", 31);
    freq.put("rle", 39);
    freq.put("rld", 7);
    freq.put("šće", 8);
    freq.put("rla", 31);
    freq.put("e ", 21038);
    freq.put("lmo", 21);
    freq.put("rlu", 8);
    freq.put("lma", 32);
    freq.put("lme", 12);
    freq.put("fc", 16);
    freq.put("usk", 116);
    freq.put("mrš", 11);
    freq.put("zan", 171);
    freq.put("zao", 28);
    freq.put("ZE ", 13);
    freq.put("xi", 24);
    freq.put("zaj", 92);
    freq.put("xo", 20);
    freq.put("xl", 16);
    freq.put("xm", 8);
    freq.put("xc", 13);
    freq.put("zad", 94);
    freq.put("xa", 47);
    freq.put("zab", 143);
    freq.put("Pp", 7);
    freq.put("xd", 21);
    freq.put("xe", 27);
    freq.put("xx", 38);
    freq.put("xy", 14);
    freq.put("zaz", 15);
    freq.put("zav", 155);
    freq.put("xs", 7);
    freq.put("xp", 12);
    freq.put("zau", 18);
    freq.put("zar", 77);
    freq.put("xw", 9);
    freq.put("xt", 23);
    freq.put("xu", 18);
    freq.put("xH", 7);
    freq.put("xN", 9);
    freq.put("xO", 10);
    freq.put("xL", 9);
    freq.put("noć", 68);
    freq.put("xD", 63);
    freq.put("xZ", 10);
    freq.put("xS", 12);
    freq.put("xQ", 9);
    freq.put("xT", 8);
    freq.put("xU", 7);
    freq.put("x ", 197);
    freq.put("noš", 7);
    freq.put("za ", 1343);
    freq.put("pni", 7);
    freq.put("nož", 8);
    freq.put("pno", 8);
    freq.put("aJo", 15);
    freq.put("Pf", 7);
    freq.put("kyp", 12);
    freq.put("qta", 7);
    freq.put("eš", 479);
    freq.put("ež", 90);
    freq.put("Pho", 21);
    freq.put("fB", 7);
    freq.put("fD", 7);
    freq.put("Off", 9);
    freq.put("fG", 7);
    freq.put("eč", 216);
    freq.put("fK", 8);
    freq.put("mrz", 58);
    freq.put("mrt", 28);
    freq.put("eć", 532);
    freq.put("mrs", 24);
    freq.put("mrl", 12);
    freq.put("wc ", 18);
    freq.put("mro", 8);
    freq.put("ege", 22);
    freq.put("mrd", 14);
    freq.put("mre", 39);
    freq.put("egd", 21);
    freq.put("eđ", 67);
    freq.put("mra", 26);
    freq.put("usr", 22);
    freq.put("Wee", 9);
    freq.put("kx ", 10);
    freq.put(" p ", 64);
    freq.put(" ps", 43);
    freq.put(" pr", 2620);
    freq.put(" pu", 412);
    freq.put(" pt", 14);
    freq.put(" pa", 976);
    freq.put(" pg", 9);
    freq.put(" pf", 8);
    freq.put(" pe", 332);
    freq.put(" pj", 54);
    freq.put(" pi", 483);
    freq.put(" ph", 16);
    freq.put(" po", 2835);
    freq.put(" pm", 11);
    freq.put(" pl", 297);
    freq.put("vu ", 258);
    freq.put("jtu", 13);
    freq.put("jto", 9);
    freq.put("jte", 148);
    freq.put("Kru", 8);
    freq.put("Kri", 14);
    freq.put("Kra", 33);
    freq.put("Kre", 27);
    freq.put("vud", 18);
    freq.put("EM ", 59);
    freq.put("vuj", 26);
    freq.put("vra", 157);
    freq.put("vur", 7);
    freq.put("vus", 9);
    freq.put("jt ", 17);
    freq.put("hva", 164);
    freq.put("ei ", 7);
    freq.put(" Oz", 10);
    freq.put("eis", 25);
    freq.put("eir", 7);
    freq.put("tlu", 10);
    freq.put("eiv", 8);
    freq.put("eiz", 7);
    freq.put("eig", 7);
    freq.put("ein", 18);
    freq.put("yi", 14);
    freq.put("yh", 12);
    freq.put("vuč", 14);
    freq.put("yk", 8);
    freq.put("yj", 36);
    freq.put("ym", 24);
    freq.put("ceb", 21);
    freq.put(" Me", 135);
    freq.put(" Ma", 473);
    freq.put(" Mc", 7);
    freq.put(" Ml", 23);
    freq.put(" Mn", 14);
    freq.put(" Mo", 235);
    freq.put(" Mi", 286);
    freq.put(" Mu", 48);
    freq.put("Vra", 24);
    freq.put(" Mr", 54);
    freq.put("yc", 11);
    freq.put("cel", 91);
    freq.put("aći", 33);
    freq.put("NS ", 18);
    freq.put("ye", 51);
    freq.put("aće", 40);
    freq.put("aća", 40);
    freq.put("ux ", 10);
    freq.put("tlj", 10);
    freq.put("aću", 27);
    freq.put("tli", 21);
    freq.put(" M ", 45);
    freq.put("odj", 142);
    freq.put("yx", 13);
    freq.put("tlo", 20);
    freq.put("yz", 10);
    freq.put("ccc", 7);
    freq.put("am ", 3324);
    freq.put("ps ", 62);
    freq.put("ucu", 16);
    freq.put("Hep", 10);
    freq.put("loš", 39);
    freq.put("Her", 7);
    freq.put("cez", 7);
    freq.put("lož", 34);
    freq.put("ami", 221);
    freq.put("psk", 81);
    freq.put("amj", 19);
    freq.put("amm", 11);
    freq.put("pso", 32);
    freq.put("amo", 847);
    freq.put("amn", 15);
    freq.put("ama", 609);
    freq.put("amb", 27);
    freq.put("ame", 255);
    freq.put("amf", 13);
    freq.put("amp", 62);
    freq.put("ams", 22);
    freq.put("amr", 11);
    freq.put("amu", 33);
    freq.put("amt", 23);
    freq.put("pst", 41);
    freq.put("psu", 13);
    freq.put("uce", 100);
    freq.put("t", 31824);
    freq.put("EP ", 10);
    freq.put("eL ", 7);
    freq.put("td ", 11);
    freq.put("yG", 7);
    freq.put("ucn", 19);
    freq.put("cq", 7);
    freq.put("uci", 207);
    freq.put("uch", 29);
    freq.put("srb", 39);
    freq.put("src", 55);
    freq.put("oča", 20);
    freq.put("sra", 74);
    freq.put("dze", 26);
    freq.put("oče", 89);
    freq.put("sre", 220);
    freq.put("dzi", 25);
    freq.put("oči", 90);
    freq.put("sri", 10);
    freq.put("očn", 27);
    freq.put("yT", 8);
    freq.put("srp", 45);
    freq.put("sru", 10);
    freq.put("Add", 11);
    freq.put("lob", 61);
    freq.put("loc", 23);
    freq.put("loa", 9);
    freq.put("log", 147);
    freq.put("lod", 15);
    freq.put("loj", 21);
    freq.put("lok", 52);
    freq.put("lon", 125);
    freq.put("loo", 11);
    freq.put("lol", 24);
    freq.put("lom", 95);
    freq.put("lor", 15);
    freq.put("los", 98);
    freq.put("lop", 35);
    freq.put("lov", 203);
    freq.put("low", 35);
    freq.put("lot", 8);
    freq.put("lou", 18);
    freq.put("loz", 49);
    freq.put("pu ", 82);
    freq.put("J", 1560);
    freq.put("rje", 28);
    freq.put("Muz", 7);
    freq.put("Đo", 7);
    freq.put("cNi", 7);
    freq.put("lo ", 639);
    freq.put("cT", 9);
    freq.put("đu", 70);
    freq.put("đa", 110);
    freq.put("đe", 190);
    freq.put("đi", 35);
    freq.put("Lan", 13);
    freq.put("Laj", 8);
    freq.put("Lak", 16);
    freq.put("Lad", 8);
    freq.put("Lag", 9);
    freq.put("Laz", 29);
    freq.put("you", 59);
    freq.put("Lar", 12);
    freq.put("Las", 7);
    freq.put("c ", 1184);
    freq.put("Bru", 13);
    freq.put("La ", 7);
    freq.put("Bro", 16);
    freq.put("IK ", 11);
    freq.put("Bri", 22);
    freq.put("Bre", 19);
    freq.put("Bra", 76);
    freq.put("mp ", 38);
    freq.put("mpe", 13);
    freq.put("mpa", 33);
    freq.put("mpo", 16);
    freq.put("mpl", 26);
    freq.put("mpj", 9);
    freq.put("mpi", 48);
    freq.put("mpu", 17);
    freq.put("mps", 17);
    freq.put("pul", 36);
    freq.put("pun", 103);
    freq.put("lić", 40);
    freq.put(" r ", 22);
    freq.put("puj", 29);
    freq.put("puk", 18);
    freq.put(" ru", 177);
    freq.put(" rt", 7);
    freq.put(" rs", 19);
    freq.put(" re", 535);
    freq.put(" rd", 9);
    freq.put(" ra", 850);
    freq.put(" ro", 203);
    freq.put(" ri", 118);
    freq.put(" rj", 15);
    freq.put("š", 3174);
    freq.put("ojt", 12);
    freq.put("GU ", 20);
    freq.put("TS ", 7);
    freq.put("vča", 7);
    freq.put("pru", 18);
    freq.put("put", 186);
    freq.put(" Fr", 48);
    freq.put("S ", 276);
    freq.put("asn", 199);
    freq.put("pur", 9);
    freq.put("pus", 148);
    freq.put("Sy", 7);
    freq.put("Sr", 199);
    freq.put("Sp", 88);
    freq.put("Sw", 10);
    freq.put("Sv", 201);
    freq.put("Su", 153);
    freq.put("St", 311);
    freq.put("Sk", 56);
    freq.put("Sj", 24);
    freq.put("Si", 105);
    freq.put("Sh", 54);
    freq.put("So", 66);
    freq.put("Sn", 16);
    freq.put("Sm", 35);
    freq.put("Sl", 114);
    freq.put("Sc", 11);
    freq.put("Sa", 422);
    freq.put("Se", 138);
    freq.put("EK ", 17);
    freq.put("RE ", 33);
    freq.put("f ", 181);
    freq.put("hha", 32);
    freq.put("hhh", 18);
    freq.put("OG ", 29);
    freq.put("čnu", 10);
    freq.put("čni", 51);
    freq.put("čnj", 8);
    freq.put("čno", 83);
    freq.put("čna", 19);
    freq.put("eg ", 86);
    freq.put("čne", 30);
    freq.put("fr", 115);
    freq.put("fs", 8);
    freq.put("ft", 47);
    freq.put("fu", 107);
    freq.put("fy", 15);
    freq.put("of ", 30);
    freq.put("fa", 314);
    freq.put("fb", 36);
    freq.put("hh ", 19);
    freq.put("fe", 284);
    freq.put("ff", 93);
    freq.put("fg", 12);
    freq.put("fi", 397);
    freq.put("fj", 11);
    freq.put("fk", 21);
    freq.put("fl", 47);
    freq.put("fm", 12);
    freq.put("fn", 9);
    freq.put("fo", 337);
    freq.put("a", 74237);
    freq.put("fR", 9);
    freq.put("fS", 7);
    freq.put("fT", 7);
    freq.put("IB ", 8);
    freq.put("egr", 25);
    freq.put("egu", 9);
    freq.put("fA", 12);
    freq.put("egi", 25);
    freq.put("ego", 240);
    freq.put("egn", 20);
    freq.put("fF", 10);
    freq.put("egl", 25);
    freq.put("fI", 9);
    freq.put("ega", 130);
    freq.put("CA ", 22);
    freq.put("zgr", 29);
    freq.put("fN", 10);
    freq.put("fO", 8);
    freq.put("ce ", 842);
    freq.put("y ", 413);
    freq.put("uvr", 10);
    freq.put("Hrv", 80);
    freq.put("zgu", 34);
    freq.put("uvi", 51);
    freq.put("uvj", 10);
    freq.put("ffi", 14);
    freq.put("uvo", 17);
    freq.put("uva", 145);
    freq.put("ffe", 9);
    freq.put("uve", 106);
    freq.put(" On", 125);
    freq.put(" Ol", 19);
    freq.put(" Ok", 30);
    freq.put(" Oh", 9);
    freq.put(" Of", 9);
    freq.put(" Og", 8);
    freq.put(" Od", 112);
    freq.put(" Ob", 69);
    freq.put(" Oc", 9);
    freq.put(" Oa", 8);
    freq.put("if ", 10);
    freq.put(" Ov", 120);
    freq.put(" Ot", 61);
    freq.put(" Or", 27);
    freq.put(" Os", 46);
    freq.put(" Op", 49);
    freq.put("ceg", 19);
    freq.put("rwa", 7);
    freq.put("cee", 9);
    freq.put("ced", 9);
    freq.put("cec", 9);
    freq.put("yl", 24);
    freq.put("yo", 83);
    freq.put("yn", 20);
    freq.put("ya", 72);
    freq.put("cen", 174);
    freq.put("cem", 102);
    freq.put("yb", 31);
    freq.put("cek", 100);
    freq.put("yd", 18);
    freq.put("yg", 11);
    freq.put("yf", 12);
    freq.put("yy", 20);
    freq.put("cev", 36);
    freq.put("cet", 64);
    freq.put("ces", 115);
    freq.put("cer", 96);
    freq.put("cep", 15);
    freq.put("uv ", 11);
    freq.put("yp", 28);
    freq.put("ys", 33);
    freq.put("yr", 21);
    freq.put("yu", 16);
    freq.put("yt", 14);
    freq.put("yw", 9);
    freq.put("ff ", 39);
    freq.put("yI", 10);
    freq.put("yK", 7);
    freq.put("yL", 10);
    freq.put("ifr", 10);
    freq.put("yN", 10);
    freq.put("MI ", 53);
    freq.put("yC", 9);
    freq.put("yB", 14);
    freq.put("yE", 8);
    freq.put("yD", 7);
    freq.put(" O ", 49);
    freq.put("ife", 26);
    freq.put("ifa", 12);
    freq.put("yP", 7);
    freq.put("yS", 9);
    freq.put("ifo", 11);
    freq.put("yU", 7);
    freq.put("ifi", 20);
    freq.put("dig", 23);
    freq.put("End", 8);
    freq.put("č", 2030);
    freq.put("as ", 854);
    freq.put("ćir", 7);
    freq.put("liš", 52);
    freq.put("Niš", 13);
    freq.put("kač", 22);
    freq.put("liž", 8);
    freq.put("ass", 30);
    freq.put("asr", 7);
    freq.put("kaš", 12);
    freq.put("asp", 99);
    freq.put("asv", 18);
    freq.put("asu", 41);
    freq.put("ast", 421);
    freq.put("pud", 9);
    freq.put("lič", 69);
    freq.put("asy", 9);
    freq.put("pub", 14);
    freq.put("puc", 34);
    freq.put("asc", 14);
    freq.put("asa", 154);
    freq.put("ase", 78);
    freq.put("ask", 65);
    freq.put("asi", 150);
    freq.put("ash", 99);
    freq.put("aso", 62);
    freq.put("kaž", 106);
    freq.put("asm", 48);
    freq.put("asl", 72);
    freq.put("ion", 209);
    freq.put("Ima", 91);
    freq.put("žuj", 13);
    freq.put("žuk", 7);
    freq.put("nc ", 15);
    freq.put("Clu", 10);
    freq.put("st ", 353);
    freq.put("Im ", 8);
    freq.put(" Oč", 9);
    freq.put("ncu", 31);
    freq.put("žu ", 35);
    freq.put("nch", 21);
    freq.put("nci", 154);
    freq.put("nco", 10);
    freq.put("nca", 34);
    freq.put("nce", 119);
    freq.put("ste", 451);
    freq.put("sta", 1538);
    freq.put("stl", 7);
    freq.put("sto", 1039);
    freq.put("sti", 802);
    freq.put("stu", 167);
    freq.put("stv", 308);
    freq.put("str", 394);
    freq.put("Gom", 8);
    freq.put("Gol", 18);
    freq.put("Goo", 19);
    freq.put("ka ", 1468);
    freq.put("God", 10);
    freq.put("Gog", 9);
    freq.put("eži", 36);
    freq.put("rh ", 46);
    freq.put("Ajd", 25);
    freq.put("Gos", 20);
    freq.put("Gor", 79);
    freq.put("Nij", 63);
    freq.put("Nik", 111);
    freq.put("lif", 24);
    freq.put("lig", 42);
    freq.put("Nin", 28);
    freq.put("lia", 27);
    freq.put("lib", 18);
    freq.put("lic", 376);
    freq.put("lil", 55);
    freq.put("Nic", 10);
    freq.put("lin", 262);
    freq.put("lio", 81);
    freq.put("lih", 14);
    freq.put("Nig", 9);
    freq.put("lij", 166);
    freq.put("lik", 646);
    freq.put("lit", 292);
    freq.put("liv", 46);
    freq.put("lip", 40);
    freq.put("lir", 29);
    freq.put("lis", 126);
    freq.put("Nis", 75);
    freq.put("liz", 72);
    freq.put("kac", 57);
    freq.put("kab", 16);
    freq.put("kaa", 21);
    freq.put("kaf", 73);
    freq.put("kad", 1071);
    freq.put("kak", 547);
    freq.put("kaj", 87);
    freq.put("kai", 17);
    freq.put("kah", 77);
    freq.put("kao", 383);
    freq.put("kan", 190);
    freq.put("kam", 215);
    freq.put("kal", 85);
    freq.put("kas", 100);
    freq.put("kar", 179);
    freq.put("kap", 42);
    freq.put("kav", 93);
    freq.put("kau", 15);
    freq.put("kat", 113);
    freq.put("rha", 14);
    freq.put("kaz", 293);
    freq.put("The", 31);
    freq.put("li ", 1795);
    freq.put("Ni ", 17);
    freq.put("bzi", 8);
    freq.put("ZA ", 56);
    freq.put("aNe", 15);
    freq.put("yma", 8);
    freq.put("ox ", 13);
    freq.put("nče", 7);
    freq.put("nča", 17);
    freq.put("x", 799);
    freq.put("nči", 12);
    freq.put("wor", 10);
    freq.put("woo", 8);
    freq.put("Pla", 24);
    freq.put("Obo", 12);
    freq.put("JU ", 39);
    freq.put("Obj", 11);
    freq.put("Obi", 10);
    freq.put("Oba", 13);
    freq.put("Obr", 11);
    freq.put("▀▀", 27);
    freq.put("War", 7);
    freq.put(" t ", 2301);
    freq.put(" tw", 81);
    freq.put(" tv", 442);
    freq.put(" tu", 261);
    freq.put(" tr", 773);
    freq.put("N", 2143);
    freq.put(" to", 1115);
    freq.put(" tl", 7);
    freq.put(" tk", 22);
    freq.put(" tj", 35);
    freq.put(" ti", 809);
    freq.put(" th", 55);
    freq.put(" te", 874);
    freq.put(" ta", 741);
    freq.put("VU ", 15);
    freq.put("jpo", 9);
    freq.put("Zbo", 9);
    freq.put("gs ", 13);
    freq.put("vy ", 14);
    freq.put("lid", 23);
    freq.put("lie", 16);
    freq.put("jp ", 7);
    freq.put("tup", 53);
    freq.put("lim", 478);
    freq.put("čla", 10);
    freq.put("lii", 9);
    freq.put("oGe", 7);
    freq.put("ee ", 104);
    freq.put("tut", 10);
    freq.put("eez", 7);
    freq.put("eet", 56);
    freq.put("eep", 35);
    freq.put("eer", 15);
    freq.put("eem", 7);
    freq.put("een", 43);
    freq.put("eek", 10);
    freq.put("eej", 10);
    freq.put("eee", 125);
    freq.put("eed", 8);
    freq.put("ru ", 295);
    freq.put("ld ", 25);
    freq.put("bg ", 28);
    freq.put("naš", 116);
    freq.put(" Qu", 12);
    freq.put("rhs", 9);
    freq.put("id ", 84);
    freq.put("ruj", 87);
    freq.put("ruk", 164);
    freq.put("run", 43);
    freq.put("nać", 9);
    freq.put("rul", 11);
    freq.put("rum", 20);
    freq.put("rub", 20);
    freq.put("ruc", 43);
    freq.put("rug", 331);
    freq.put("rud", 64);
    freq.put("puš", 39);
    freq.put("ruz", 57);
    freq.put("AR ", 18);
    freq.put("nađ", 31);
    freq.put("rus", 53);
    freq.put("rup", 44);
    freq.put("rut", 15);
    freq.put("rhi", 10);
    freq.put("idz", 8);
    freq.put("idu", 34);
    freq.put("idr", 11);
    freq.put(" Q ", 17);
    freq.put("ido", 46);
    freq.put("idj", 59);
    freq.put("idi", 278);
    freq.put("ide", 337);
    freq.put("ida", 100);
    freq.put("tuj", 58);
    freq.put("aq ", 9);
    freq.put("vst", 14);
    freq.put("kay", 12);
    freq.put("ut ", 132);
    freq.put("tuk", 28);
    freq.put("kus", 83);
    freq.put("šut", 7);
    freq.put("ušu", 9);
    freq.put("šu ", 44);
    freq.put("uta", 217);
    freq.put("ute", 57);
    freq.put("utj", 8);
    freq.put("utk", 30);
    freq.put("uti", 151);
    freq.put("utn", 55);
    freq.put("uto", 98);
    freq.put("utl", 9);
    freq.put("utr", 263);
    freq.put("utu", 72);
    freq.put("KU ", 30);
    freq.put("naB", 16);
    freq.put("naC", 7);
    freq.put("naG", 16);
    freq.put("Tx", 7);
    freq.put("Ty", 9);
    freq.put("Tv", 83);
    freq.put("Tw", 15);
    freq.put("Tt", 7);
    freq.put("Tu", 105);
    freq.put("rhu", 17);
    freq.put("Ts", 14);
    freq.put("naM", 10);
    freq.put("Tn", 11);
    freq.put("To", 153);
    freq.put("Tk", 17);
    freq.put("Th", 64);
    freq.put("Ti", 75);
    freq.put("Tf", 9);
    freq.put("Te", 92);
    freq.put("Tb", 8);
    freq.put("Ta", 174);
    freq.put("nab", 56);
    freq.put("A ", 1312);
    freq.put("naa", 31);
    freq.put("naf", 13);
    freq.put("nag", 67);
    freq.put("nad", 180);
    freq.put("ruč", 54);
    freq.put("naj", 500);
    freq.put("nak", 139);
    freq.put("nah", 11);
    freq.put("nai", 26);
    freq.put("Uz ", 8);
    freq.put("ruć", 9);
    freq.put("nal", 254);
    freq.put("nam", 539);
    freq.put("nar", 182);
    freq.put("nas", 537);
    freq.put("nap", 270);
    freq.put("nav", 109);
    freq.put("nat", 257);
    freq.put("nau", 31);
    freq.put("naz", 57);
    freq.put("oon", 31);
    freq.put("ruš", 34);
    freq.put("ruž", 53);
    freq.put("T ", 1653);
    freq.put("tmu", 10);
    freq.put("Aa", 18);
    freq.put("svo", 218);
    freq.put("dvo", 75);
    freq.put("Ab", 11);
    freq.put("svj", 34);
    freq.put("Ad", 38);
    freq.put("Ag", 19);
    freq.put("dvj", 7);
    freq.put("Ai", 21);
    freq.put("Ah", 19);
    freq.put("Ak", 125);
    freq.put("Aj", 46);
    freq.put("Am", 52);
    freq.put("Al", 179);
    freq.put("An", 163);
    freq.put("Aq", 16);
    freq.put("Ap", 36);
    freq.put("As", 22);
    freq.put("Ar", 73);
    freq.put("Au", 33);
    freq.put("At", 26);
    freq.put("Aw", 11);
    freq.put("Av", 26);
    freq.put("Ay", 10);
    freq.put("svu", 27);
    freq.put("svr", 16);
    freq.put("dvr", 12);
    freq.put("gu", 678);
    freq.put("gt", 16);
    freq.put("gs", 29);
    freq.put("gr", 806);
    freq.put("gq", 7);
    freq.put("gp", 8);
    freq.put("gz", 10);
    freq.put("gy", 17);
    freq.put("gg", 32);
    freq.put("gf", 12);
    freq.put("ge", 356);
    freq.put("gd", 167);
    freq.put("gb", 18);
    freq.put("ga", 1292);
    freq.put("go", 1769);
    freq.put("gn", 137);
    freq.put("gm", 25);
    freq.put("gl", 941);
    freq.put("gk", 11);
    freq.put("gj", 19);
    freq.put("gi", 389);
    freq.put("gh", 61);
    freq.put("Nol", 11);
    freq.put("gV", 11);
    freq.put("gS", 31);
    freq.put("gR", 7);
    freq.put("lki", 9);
    freq.put("lka", 77);
    freq.put("gE", 7);
    freq.put("gD", 7);
    freq.put("gB", 12);
    freq.put("gA", 10);
    freq.put("Not", 9);
    freq.put("gM", 9);
    freq.put("lku", 24);
    freq.put("Nor", 13);
    freq.put("kci", 77);
    freq.put("g ", 1197);
    freq.put("rtu", 39);
    freq.put("Spr", 10);
    freq.put("No ", 15);
    freq.put("lk ", 8);
    freq.put("Spl", 15);
    freq.put("Spo", 21);
    freq.put("Spa", 19);
    freq.put("tmo", 8);
    freq.put("zl", 206);
    freq.put("zm", 195);
    freq.put("zn", 1118);
    freq.put("zo", 340);
    freq.put("zh", 29);
    freq.put("zi", 1221);
    freq.put("zj", 37);
    freq.put("zk", 17);
    freq.put("zd", 287);
    freq.put("ze", 928);
    freq.put("zf", 8);
    freq.put("zg", 216);
    freq.put("za", 3156);
    freq.put("zb", 379);
    freq.put("zc", 8);
    freq.put("đ", 415);
    freq.put("zy", 11);
    freq.put("zz", 62);
    freq.put("zt", 10);
    freq.put("zu", 370);
    freq.put("zv", 334);
    freq.put("zw", 11);
    freq.put("zp", 13);
    freq.put("zr", 90);
    freq.put("zs", 13);
    freq.put("zN", 11);
    freq.put("zO", 11);
    freq.put("iži", 13);
    freq.put("zD", 12);
    freq.put("iže", 22);
    freq.put("zC", 9);
    freq.put("zX", 7);
    freq.put("zY", 8);
    freq.put("zZ", 7);
    freq.put("zT", 7);
    freq.put("zU", 8);
    freq.put("ozg", 11);
    freq.put("ozd", 64);
    freq.put("oze", 182);
    freq.put("ozb", 30);
    freq.put("oza", 112);
    freq.put("ozn", 163);
    freq.put("ozo", 51);
    freq.put("ozl", 11);
    freq.put("z ", 871);
    freq.put("ozi", 111);
    freq.put("ozv", 30);
    freq.put("ozu", 16);
    freq.put("ozz", 13);
    freq.put("duš", 39);
    freq.put("win", 12);
    freq.put("wil", 7);
    freq.put("IA ", 9);
    freq.put("wit", 59);
    freq.put("wis", 13);
    freq.put("Js", 7);
    freq.put("pš", 63);
    freq.put("jda", 37);
    freq.put("Ji", 15);
    freq.put("wi ", 9);
    freq.put("ien", 13);
    freq.put("ieb", 11);
    freq.put("ičn", 101);
    freq.put("zma", 39);
    freq.put("Mr ", 9);
    freq.put(" va", 444);
    freq.put(" ve", 576);
    freq.put(" vi", 936);
    freq.put(" vj", 51);
    freq.put(" vl", 106);
    freq.put(" vo", 444);
    freq.put(" vq", 7);
    freq.put(" vs", 28);
    freq.put(" vr", 430);
    freq.put(" vu", 45);
    freq.put("Mrz", 14);
    freq.put("Mrs", 7);
    freq.put(" v ", 53);
    freq.put("TO ", 107);
    freq.put("kre", 201);
    freq.put("jnu", 16);
    freq.put("zme", 66);
    freq.put("beć", 8);
    freq.put("jna", 37);
    freq.put("jne", 33);
    freq.put("jnj", 9);
    freq.put("jni", 70);
    freq.put("jno", 100);
    freq.put("iču", 12);
    freq.put("RA ", 26);
    freq.put("jn ", 8);
    freq.put("beš", 8);
    freq.put("ec ", 102);
    freq.put("miš", 44);
    freq.put("mar", 212);
    freq.put("hle", 7);
    freq.put("hla", 21);
    freq.put("mav", 9);
    freq.put("max", 10);
    freq.put("ece", 229);
    freq.put("kst", 34);
    freq.put("eca", 208);
    freq.put("CE ", 30);
    freq.put("eco", 19);
    freq.put("ecn", 34);
    freq.put("eck", 58);
    freq.put("eci", 165);
    freq.put("ech", 26);
    freq.put("ecu", 98);
    freq.put("ect", 14);
    freq.put("rs ", 56);
    freq.put("cy ", 11);
    freq.put("AN ", 38);
    freq.put(" Sr", 192);
    freq.put(" Sp", 80);
    freq.put(" Sv", 191);
    freq.put(" St", 261);
    freq.put(" Su", 111);
    freq.put(" Sj", 19);
    freq.put(" Sk", 47);
    freq.put(" Sh", 37);
    freq.put(" Si", 93);
    freq.put(" Sn", 9);
    freq.put(" So", 45);
    freq.put(" Sl", 104);
    freq.put(" Sm", 30);
    freq.put(" Sc", 9);
    freq.put(" Sa", 377);
    freq.put(" Se", 115);
    freq.put("rsn", 9);
    freq.put("rso", 10);
    freq.put("rsh", 9);
    freq.put("rsi", 49);
    freq.put("rsk", 106);
    freq.put("rse", 48);
    freq.put("rsa", 43);
    freq.put("cyb", 8);
    freq.put("R", 2381);
    freq.put("rst", 61);
    freq.put("rsu", 10);
    freq.put("NU ", 25);
    freq.put("bej", 13);
    freq.put("ben", 70);
    freq.put("beo", 11);
    freq.put("bel", 73);
    freq.put("bem", 31);
    freq.put("beb", 13);
    freq.put("bec", 11);
    freq.put("bea", 7);
    freq.put("beg", 21);
    freq.put("bed", 54);
    freq.put("bez", 164);
    freq.put("MU ", 16);
    freq.put("ber", 65);
    freq.put("bes", 55);
    freq.put(" S ", 43);
    freq.put("bet", 13);
    freq.put("IŠ ", 11);
    freq.put("py ", 12);
    freq.put("ur ", 23);
    freq.put("uu ", 22);
    freq.put("aro", 111);
    freq.put("BA ", 17);
    freq.put("Dev", 16);
    freq.put("awa", 13);
    freq.put("urd", 11);
    freq.put("ure", 83);
    freq.put("ura", 219);
    freq.put("urc", 19);
    freq.put("Hva", 30);
    freq.put("urn", 88);
    freq.put("uro", 87);
    freq.put("uri", 96);
    freq.put("urk", 15);
    freq.put("urt", 16);
    freq.put("uru", 32);
    freq.put("urv", 42);
    freq.put("urs", 44);
    freq.put("Del", 14);
    freq.put("urz", 19);
    freq.put("mg ", 13);
    freq.put("Den", 16);
    freq.put("živ", 207);
    freq.put("žit", 29);
    freq.put("žio", 11);
    freq.put("žil", 18);
    freq.put("Dea", 9);
    freq.put("žid", 8);
    freq.put("nge", 42);
    freq.put("nga", 33);
    freq.put("ngl", 42);
    freq.put("ngo", 27);
    freq.put("sh ", 125);
    freq.put("ngu", 18);
    freq.put("ngr", 14);
    freq.put("ngs", 13);
    freq.put("ži ", 69);
    freq.put("sht", 64);
    freq.put("shu", 9);
    freq.put("shv", 60);
    freq.put("sha", 65);
    freq.put("she", 39);
    freq.put("dpo", 7);
    freq.put("shi", 50);
    freq.put("shk", 15);
    freq.put("shm", 7);
    freq.put("sho", 47);
    freq.put("j", 22886);
    freq.put("ke ", 728);
    freq.put("lup", 108);
    freq.put("lus", 96);
    freq.put("lut", 33);
    freq.put("luv", 11);
    freq.put("luz", 35);
    freq.put("lub", 44);
    freq.put("luc", 65);
    freq.put("lud", 85);
    freq.put("luf", 15);
    freq.put("lug", 16);
    freq.put("luj", 26);
    freq.put("luk", 44);
    freq.put("lul", 7);
    freq.put("lum", 52);
    freq.put("Srb", 134);
    freq.put("ken", 71);
    freq.put("kem", 13);
    freq.put("kel", 10);
    freq.put("kej", 22);
    freq.put("Sre", 30);
    freq.put("Dzi", 7);
    freq.put("kee", 7);
    freq.put("ked", 33);
    freq.put("Srp", 15);
    freq.put("kev", 15);
    freq.put("ket", 35);
    freq.put("kes", 14);
    freq.put("ker", 52);
    freq.put("jic", 79);
    freq.put("lu ", 225);
    freq.put("ot ", 219);
    freq.put("Lon", 8);
    freq.put("Lor", 9);
    freq.put("Lov", 14);
    freq.put("žiš", 12);
    freq.put("dja", 120);
    freq.put("aRa", 8);
    freq.put("yan", 9);
    freq.put("dje", 435);
    freq.put("oti", 195);
    freq.put("otk", 98);
    freq.put("otn", 33);
    freq.put("oto", 159);
    freq.put("ota", 149);
    freq.put("ote", 119);
    freq.put("otp", 74);
    freq.put("otr", 91);
    freq.put("ots", 9);
    freq.put("ott", 11);
    freq.put("otu", 79);
    freq.put("otv", 64);
    freq.put("And", 55);
    freq.put("Ang", 13);
    freq.put("Ana", 33);
    freq.put("Ani", 8);
    freq.put("Anj", 8);
    freq.put("Ant", 17);
    freq.put("ya ", 35);
    freq.put("You", 38);
    freq.put("Yor", 10);
    freq.put("luž", 33);
    freq.put("luš", 39);
    freq.put("luđ", 8);
    freq.put("Yo ", 7);
    freq.put("rić", 40);
    freq.put("luč", 35);
    freq.put("Špa", 8);
    freq.put("i", 50587);
    freq.put("ksi", 60);
    freq.put(" Zl", 20);
    freq.put(" xD", 60);
    freq.put("Be", 171);
    freq.put("Bf", 12);
    freq.put("Bg", 13);
    freq.put("Ba", 270);
    freq.put("Bb", 7);
    freq.put("Bl", 86);
    freq.put("Bn", 7);
    freq.put("Bo", 258);
    freq.put("Bi", 152);
    freq.put("Bj", 12);
    freq.put(" xd", 17);
    freq.put("Bu", 75);
    freq.put("Bv", 7);
    freq.put(" xx", 10);
    freq.put("Bq", 8);
    freq.put("Br", 152);
    freq.put("Bs", 7);
    freq.put("B ", 124);
    freq.put(" x ", 27);
    freq.put("TI ", 97);
    freq.put("jlu", 8);
    freq.put("jle", 19);
    freq.put("jla", 7);
    freq.put("jlo", 11);
    freq.put("jli", 27);
    freq.put("U ", 588);
    freq.put(" Už", 7);
    freq.put("?", 28);
    freq.put("duh", 27);
    freq.put("Ux", 9);
    freq.put("Uz", 25);
    freq.put("RO ", 26);
    freq.put("Ut", 13);
    freq.put("Uw", 7);
    freq.put("Uv", 28);
    freq.put("pp", 71);
    freq.put("Us", 40);
    freq.put("Ur", 11);
    freq.put("Um", 24);
    freq.put("Ul", 20);
    freq.put("Uo", 10);
    freq.put("pq", 12);
    freq.put("Uh", 11);
    freq.put("Uk", 23);
    freq.put("Uj", 10);
    freq.put("Ue", 7);
    freq.put("pv", 9);
    freq.put("Ug", 17);
    freq.put("Uf", 7);
    freq.put("Uc", 9);
    freq.put("Ub", 25);
    freq.put("dun", 12);
    freq.put("EE ", 9);
    freq.put("duc", 19);
    freq.put("ea ", 56);
    freq.put("h ", 1424);
    freq.put("dm ", 21);
    freq.put(" Če", 27);
    freq.put(" Ča", 8);
    freq.put(" Čo", 10);
    freq.put(" Či", 16);
    freq.put(" Ču", 14);
    freq.put("eak", 20);
    freq.put("hy", 15);
    freq.put("eam", 27);
    freq.put("eal", 66);
    freq.put("ean", 23);
    freq.put("hr", 279);
    freq.put("hs", 23);
    freq.put("eac", 9);
    freq.put("hv", 174);
    freq.put("ead", 12);
    freq.put("eag", 10);
    freq.put("hu", 128);
    freq.put("hj", 10);
    freq.put("pj", 100);
    freq.put("hh", 78);
    freq.put("hi", 330);
    freq.put("hn", 87);
    freq.put("ho", 473);
    freq.put("hl", 46);
    freq.put("hm", 43);
    freq.put("hb", 16);
    freq.put("hc", 11);
    freq.put("eas", 14);
    freq.put("ear", 25);
    freq.put("ph", 42);
    freq.put("hd", 10);
    freq.put("he", 433);
    freq.put("dma", 45);
    freq.put("hX", 7);
    freq.put("dus", 61);
    freq.put("dme", 12);
    freq.put("dmi", 12);
    freq.put("hP", 7);
    freq.put("hQ", 11);
    freq.put("hT", 7);
    freq.put("dmo", 17);
    freq.put("hH", 7);
    freq.put("hI", 7);
    freq.put("pl", 549);
    freq.put("hA", 10);
    freq.put("hF", 7);
    freq.put("hE", 7);
    freq.put(" Uz", 21);
    freq.put(" Ut", 8);
    freq.put(" Uv", 24);
    freq.put(" Up", 42);
    freq.put(" Ur", 10);
    freq.put(" Us", 37);
    freq.put(" Ul", 14);
    freq.put(" Um", 17);
    freq.put(" Un", 22);
    freq.put(" Uo", 7);
    freq.put(" Uh", 9);
    freq.put(" Uk", 17);
    freq.put(" Ud", 9);
    freq.put(" Ug", 14);
    freq.put(" Ub", 20);
    freq.put("Už", 7);
    freq.put(" tp", 8);
    freq.put("hna", 15);
    freq.put("hni", 14);
    freq.put("hno", 12);
    freq.put("hnn", 17);
    freq.put("hnu", 8);
    freq.put(" U ", 236);
    freq.put("MS ", 12);
    freq.put("eč ", 17);
    freq.put("auc", 21);
    freq.put("aud", 10);
    freq.put("auk", 10);
    freq.put("aum", 10);
    freq.put("aul", 11);
    freq.put("up ", 49);
    freq.put("aus", 21);
    freq.put("aur", 7);
    freq.put("aut", 66);
    freq.put("auv", 10);
    freq.put("auz", 17);
    freq.put("eče", 89);
    freq.put("eča", 21);
    freq.put("ečn", 22);
    freq.put("eči", 30);
    freq.put("ečk", 35);
    freq.put("ble", 119);
    freq.put("upn", 14);
    freq.put("au ", 33);
    freq.put("upl", 45);
    freq.put("upk", 11);
    freq.put("upi", 154);
    freq.put("upd", 7);
    freq.put("upe", 125);
    freq.put("upc", 19);
    freq.put("upa", 124);
    freq.put("upu", 39);
    freq.put("upr", 52);
    freq.put("olk", 41);
    freq.put("Igr", 16);
    freq.put("Igo", 12);
    freq.put("Ign", 9);
    freq.put("nen", 46);
    freq.put("neo", 33);
    freq.put("Pun", 8);
    freq.put("nem", 499);
    freq.put("nej", 21);
    freq.put("nek", 812);
    freq.put("nei", 23);
    freq.put("neg", 198);
    freq.put("ned", 119);
    freq.put("nee", 10);
    freq.put("neb", 39);
    freq.put("nec", 113);
    freq.put("nea", 14);
    freq.put("nez", 65);
    freq.put("nex", 7);
    freq.put("ney", 11);
    freq.put("Put", 7);
    freq.put("dr ", 13);
    freq.put("sj ", 7);
    freq.put("neu", 16);
    freq.put("ner", 147);
    freq.put("Kaž", 10);
    freq.put("nep", 52);
    freq.put("Pus", 7);
    freq.put("mee", 18);
    freq.put("med", 79);
    freq.put("meg", 11);
    freq.put("Kać", 7);
    freq.put("mec", 16);
    freq.put("mem", 66);
    freq.put("mel", 39);
    freq.put("meo", 9);
    freq.put("men", 727);
    freq.put("meh", 33);
    freq.put("mek", 17);
    freq.put("mej", 28);
    freq.put("met", 219);
    freq.put("mev", 7);
    freq.put("mes", 116);
    freq.put("mer", 136);
    freq.put("mez", 9);
    freq.put("drz", 63);
    freq.put("dru", 343);
    freq.put("ne ", 2835);
    freq.put("sju", 7);
    freq.put("dri", 65);
    freq.put("drk", 9);
    freq.put("dro", 67);
    freq.put("dra", 206);
    freq.put("sja", 19);
    freq.put("dre", 54);
    freq.put("Uve", 12);
    freq.put("sje", 133);
    freq.put("kg ", 18);
    freq.put("cm ", 11);
    freq.put("Tit", 7);
    freq.put("nud", 26);
    freq.put("Ste", 34);
    freq.put("Sta", 148);
    freq.put("Sto", 54);
    freq.put("auč", 13);
    freq.put("Sti", 16);
    freq.put("Stv", 8);
    freq.put("Str", 25);
    freq.put("V", 1043);
    freq.put("rio", 85);
    freq.put("upš", 9);
    freq.put("Lig", 12);
    freq.put("Tij", 9);
    freq.put("Lin", 13);
    freq.put("Lij", 14);
    freq.put("Lik", 9);
    freq.put("Liv", 8);
    freq.put("Kac", 11);
    freq.put("meć", 12);
    freq.put("Kad", 167);
    freq.put("Kak", 117);
    freq.put("Kao", 19);
    freq.put("Kan", 16);
    freq.put("Al ", 18);
    freq.put("Kal", 9);
    freq.put("Kas", 10);
    freq.put("Kar", 57);
    freq.put("Kap", 11);
    freq.put("međ", 31);
    freq.put("Kat", 21);
    freq.put("Kaz", 26);
    freq.put("aPe", 11);
    freq.put("ovr", 44);
    freq.put("ovs", 35);
    freq.put("neč", 8);
    freq.put("meš", 24);
    freq.put("ovu", 92);
    freq.put("neć", 100);
    freq.put("ovc", 32);
    freq.put("ova", 886);
    freq.put("ovd", 62);
    freq.put("ove", 492);
    freq.put("ovj", 41);
    freq.put("ovk", 20);
    freq.put("ovi", 971);
    freq.put("ovn", 105);
    freq.put("ovo", 699);
    freq.put("ovl", 14);
    freq.put("Alo", 8);
    freq.put("Ali", 52);
    freq.put("Ale", 46);
    freq.put("Alb", 12);
    freq.put("Ala", 12);
    freq.put("drš", 7);
    freq.put("ong", 51);
    freq.put("mš", 17);
    freq.put("zdv", 9);
    freq.put("doč", 14);
    freq.put("dođ", 42);
    freq.put("SS ", 9);
    freq.put(" zm", 18);
    freq.put(" zl", 60);
    freq.put(" zo", 95);
    freq.put(" zn", 607);
    freq.put(" zi", 231);
    freq.put(" zh", 9);
    freq.put(" ze", 214);
    freq.put(" zd", 34);
    freq.put(" zg", 39);
    freq.put(" za", 2401);
    freq.put("zdo", 8);
    freq.put(" zb", 126);
    freq.put("će ", 390);
    freq.put("xu ", 9);
    freq.put(" zu", 36);
    freq.put("zdi", 29);
    freq.put("is ", 290);
    freq.put(" zr", 20);
    freq.put("isJ", 7);
    freq.put("ćer", 10);
    freq.put("ćev", 24);
    freq.put("ćet", 16);
    freq.put("iss", 47);
    freq.put("doš", 28);
    freq.put(" z ", 14);
    freq.put("isu", 136);
    freq.put("ist", 704);
    freq.put("isk", 156);
    freq.put("isi", 194);
    freq.put("ish", 87);
    freq.put("dož", 9);
    freq.put("isn", 96);
    freq.put("ism", 69);
    freq.put("isl", 475);
    freq.put("isc", 31);
    freq.put("isa", 461);
    freq.put("isf", 7);
    freq.put("ise", 307);
    freq.put("Eur", 33);
    freq.put("yBr", 12);
    freq.put("jjj", 9);
    freq.put("jja", 31);
    freq.put("Com", 8);
    freq.put("BB ", 8);
    freq.put("jj ", 9);
    freq.put("oNi", 10);
    freq.put(" ks", 8);
    freq.put("Izg", 12);
    freq.put("ty ", 30);
    freq.put("Izr", 7);
    freq.put("Izv", 16);
    freq.put("do ", 266);
    freq.put("Iz ", 13);
    freq.put("tyj", 14);
    freq.put("PO ", 16);
    freq.put("doj", 13);
    freq.put("dok", 167);
    freq.put("doh", 19);
    freq.put("don", 95);
    freq.put("doo", 7);
    freq.put("dol", 91);
    freq.put("dom", 114);
    freq.put("dob", 415);
    freq.put("doc", 16);
    freq.put("m", 23836);
    freq.put("dog", 51);
    freq.put("dod", 74);
    freq.put("doz", 35);
    freq.put("ćeš", 51);
    freq.put("kuv", 28);
    freq.put("dor", 32);
    freq.put("dos", 187);
    freq.put("dop", 33);
    freq.put("dov", 146);
    freq.put("dow", 13);
    freq.put("dot", 7);
    freq.put(" We", 20);
    freq.put(" Wa", 17);
    freq.put(" Wo", 12);
    freq.put(" Wh", 10);
    freq.put(" Wi", 19);
    freq.put(" Wr", 7);
    freq.put("ači", 137);
    freq.put("ačk", 63);
    freq.put("ačn", 30);
    freq.put("ača", 61);
    freq.put("ače", 74);
    freq.put("kul", 78);
    freq.put("ba ", 375);
    freq.put("aču", 29);
    freq.put(" W ", 20);
    freq.put("bav", 265);
    freq.put("bat", 43);
    freq.put("bar", 189);
    freq.put("bas", 72);
    freq.put("ač ", 28);
    freq.put("baz", 14);
    freq.put("bag", 12);
    freq.put("bad", 23);
    freq.put("bab", 42);
    freq.put("bac", 129);
    freq.put("ban", 125);
    freq.put("bao", 23);
    freq.put("bal", 151);
    freq.put("bam", 31);
    freq.put("baj", 39);
    freq.put("bak", 23);
    freq.put("bah", 7);
    freq.put("Bg ", 7);
    freq.put("om ", 1183);
    freq.put("iž", 54);
    freq.put("rži", 24);
    freq.put("iš", 654);
    freq.put("rža", 54);
    freq.put("rže", 8);
    freq.put("un ", 86);
    freq.put("Rus", 18);
    freq.put("kić", 20);
    freq.put("omc", 17);
    freq.put("omb", 32);
    freq.put("C", 800);
    freq.put("omg", 7);
    freq.put("ome", 347);
    freq.put("omk", 10);
    freq.put("omj", 8);
    freq.put("omi", 148);
    freq.put("omo", 108);
    freq.put("omn", 13);
    freq.put("oml", 14);
    freq.put("oms", 29);
    freq.put("omp", 69);
    freq.put("omu", 42);
    freq.put("kiš", 20);
    freq.put("unt", 16);
    freq.put("unu", 30);
    freq.put("iđ", 36);
    freq.put("una", 116);
    freq.put("unc", 46);
    freq.put("ič", 375);
    freq.put("une", 33);
    freq.put("ung", 17);
    freq.put("uni", 112);
    freq.put("unj", 35);
    freq.put("unk", 24);
    freq.put("ić", 535);
    freq.put("uno", 65);
    freq.put("bač", 20);
    freq.put("C ", 147);
    freq.put("sl ", 8);
    freq.put("oć ", 39);
    freq.put("mci", 20);
    freq.put("Ci", 59);
    freq.put("Ch", 46);
    freq.put("Co", 61);
    freq.put("Cl", 23);
    freq.put("Cc", 12);
    freq.put("Cb", 7);
    freq.put("Ca", 62);
    freq.put("Cg", 7);
    freq.put("slq", 7);
    freq.put("Ce", 85);
    freq.put("Cy", 7);
    freq.put("slo", 132);
    freq.put("oći", 39);
    freq.put("sli", 490);
    freq.put("slj", 49);
    freq.put("baš", 57);
    freq.put("oće", 43);
    freq.put("sle", 221);
    freq.put("Cp", 7);
    freq.put("oća", 9);
    freq.put("Cv", 9);
    freq.put("Cu", 37);
    freq.put("iy", 11);
    freq.put("Nac", 15);
    freq.put("iz", 1527);
    freq.put("Nad", 17);
    freq.put("Naj", 79);
    freq.put("Nak", 20);
    freq.put("is", 3337);
    freq.put("ir", 1130);
    freq.put("iu", 33);
    freq.put("it", 2726);
    freq.put("iw", 22);
    freq.put("iv", 1342);
    freq.put("Nar", 24);
    freq.put("Nas", 12);
    freq.put("Nap", 21);
    freq.put("ij", 3524);
    freq.put("Nav", 10);
    freq.put("il", 2052);
    freq.put("Nat", 20);
    freq.put("in", 3039);
    freq.put("ia", 372);
    freq.put("ic", 2746);
    freq.put("ib", 195);
    freq.put("ie", 199);
    freq.put("id", 992);
    freq.put("ig", 614);
    freq.put("if", 112);
    freq.put("V ", 135);
    freq.put("iZ", 10);
    freq.put("iP", 35);
    freq.put("iS", 20);
    freq.put("iR", 10);
    freq.put("iU", 9);
    freq.put("iT", 18);
    freq.put("iW", 7);
    freq.put("iV", 12);
    freq.put("iI", 10);
    freq.put("iH", 47);
    freq.put("iK", 11);
    freq.put("iJ", 15);
    freq.put("iM", 19);
    freq.put("iL", 16);
    freq.put("iO", 11);

    init3();
  }
  private static void init3() {
    
    freq.put("iN", 12);
    freq.put("iA", 12);
    freq.put("iC", 12);
    freq.put("iB", 13);
    freq.put("iE", 7);
    freq.put("iD", 13);
    freq.put("iG", 15);
    freq.put("iF", 8);
    freq.put("Na ", 68);
    freq.put("Svj", 10);
    freq.put("Svi", 55);
    freq.put("Dve", 11);
    freq.put("kir", 35);
    freq.put("kip", 33);
    freq.put("Dva", 7);
    freq.put("kiv", 25);
    freq.put("kit", 48);
    freq.put("kik", 8);
    freq.put("kij", 28);
    freq.put("kih", 63);
    freq.put("kin", 114);
    freq.put("kim", 93);
    freq.put("kil", 33);
    freq.put("kic", 74);
    freq.put("i ", 15892);
    freq.put("kid", 45);
    freq.put("Va", 100);
    freq.put("Ve", 132);
    freq.put("Vi", 149);
    freq.put("Vj", 15);
    freq.put("Vk", 8);
    freq.put("Vl", 81);
    freq.put("Vo", 87);
    freq.put("Vr", 56);
    freq.put("Vs", 7);
    freq.put("Vu", 54);
    freq.put("ku ", 612);
    freq.put("lq ", 8);
    freq.put("nk ", 53);
    freq.put("op ", 84);
    freq.put("yer", 16);
    freq.put("aVu", 7);
    freq.put("zor", 56);
    freq.put("eur", 60);
    freq.put("opt", 20);
    freq.put("opu", 100);
    freq.put("opp", 10);
    freq.put("opr", 80);
    freq.put("ops", 53);
    freq.put("ope", 126);
    freq.put("opa", 143);
    freq.put("opc", 33);
    freq.put("opl", 30);
    freq.put("opo", 56);
    freq.put("opi", 131);
    freq.put("opj", 7);
    freq.put("bro", 289);
    freq.put("Ars", 13);
    freq.put("Art", 9);
    freq.put("brn", 7);
    freq.put("vda", 17);
    freq.put("Ara", 10);
    freq.put("vde", 47);
    freq.put("vdj", 26);
    freq.put("www", 34);
    freq.put("bri", 125);
    freq.put("ljd", 24);
    freq.put("zu ", 112);
    freq.put("Jel", 66);
    freq.put("loč", 12);
    freq.put("ww ", 34);
    freq.put("zur", 25);
    freq.put("zut", 7);
    freq.put("zub", 17);
    freq.put("zuj", 36);
    freq.put("zul", 25);
    freq.put("zum", 105);
    freq.put("iq ", 18);
    freq.put("TE ", 105);
    freq.put("opš", 20);
    freq.put("Z", 984);
    freq.put("SU ", 23);
    freq.put("iqu", 7);
    freq.put("iqt", 9);
    freq.put("Ć", 43);
    freq.put("di ", 655);
    freq.put(" Đo", 7);
    freq.put("tnu", 21);
    freq.put("eru", 172);
    freq.put("dil", 99);
    freq.put("dim", 301);
    freq.put("din", 412);
    freq.put("dio", 188);
    freq.put("dii", 7);
    freq.put("dij", 113);
    freq.put("dik", 29);
    freq.put("did", 20);
    freq.put("die", 16);
    freq.put("ers", 69);
    freq.put("dia", 18);
    freq.put("dic", 116);
    freq.put("diz", 16);
    freq.put("dit", 154);
    freq.put("div", 47);
    freq.put("dip", 12);
    freq.put("dir", 69);
    freq.put("dis", 91);
    freq.put("Gru", 12);
    freq.put(" Yo", 47);
    freq.put(" Ya", 7);
    freq.put("eža", 23);
    freq.put("ežb", 7);
    freq.put("Gre", 18);
    freq.put("eže", 14);
    freq.put("Gra", 33);
    freq.put("Gro", 12);
    freq.put("Gri", 8);
    freq.put("tne", 62);
    freq.put("mać", 22);
    freq.put("AM ", 144);
    freq.put("bo ", 39);
    freq.put("mač", 26);
    freq.put(" Y ", 16);
    freq.put("maš", 55);
    freq.put("erm", 29);
    freq.put("nač", 75);
    freq.put("tno", 187);
    freq.put("box", 13);
    freq.put("boy", 8);
    freq.put("boz", 21);
    freq.put("tni", 162);
    freq.put("bor", 196);
    freq.put("bos", 36);
    freq.put("bot", 83);
    freq.put("bov", 14);
    freq.put("bow", 7);
    freq.put("boj", 100);
    freq.put("bok", 18);
    freq.put("bol", 327);
    freq.put("bom", 72);
    freq.put("bon", 26);
    freq.put("boo", 36);
    freq.put("tnj", 24);
    freq.put("bod", 55);
    freq.put("bog", 165);
    freq.put("dič", 8);
    freq.put("oo ", 100);
    freq.put("dić", 29);
    freq.put("aye", 16);
    freq.put("aya", 18);
    freq.put("ayu", 7);
    freq.put("ul ", 33);
    freq.put("ays", 7);
    freq.put("Bek", 9);
    freq.put("oog", 21);
    freq.put("Ben", 9);
    freq.put("Beo", 31);
    freq.put("Bel", 23);
    freq.put("oob", 9);
    freq.put("oom", 13);
    freq.put("ool", 24);
    freq.put("ooo", 144);
    freq.put("Bea", 8);
    freq.put("ook", 50);
    freq.put("ooj", 7);
    freq.put("Bez", 27);
    freq.put("oot", 7);
    freq.put("oos", 8);
    freq.put("Ber", 15);
    freq.put("ay ", 64);
    freq.put("ult", 67);
    freq.put("ulu", 22);
    freq.put("ulj", 71);
    freq.put("uli", 115);
    freq.put("ulo", 29);
    freq.put("ull", 12);
    freq.put("fla", 9);
    freq.put("ula", 122);
    freq.put("fle", 16);
    freq.put("ulg", 7);
    freq.put("Hla", 12);
    freq.put("ule", 31);
    freq.put("Rod", 8);
    freq.put("ma ", 1705);
    freq.put("nyB", 12);
    freq.put("idn", 11);
    freq.put("Še", 13);
    freq.put("nya", 12);
    freq.put("mas", 134);
    freq.put("sne", 66);
    freq.put("mat", 221);
    freq.put("sna", 91);
    freq.put("sno", 198);
    freq.put("maz", 25);
    freq.put("snj", 48);
    freq.put("sni", 229);
    freq.put("mac", 117);
    freq.put("snu", 27);
    freq.put("mad", 52);
    freq.put("mag", 31);
    freq.put("maf", 7);
    freq.put("mai", 23);
    freq.put("mah", 44);
    freq.put("mak", 90);
    freq.put("maj", 202);
    freq.put("mam", 404);
    freq.put("mal", 381);
    freq.put("mao", 28);
    freq.put("man", 382);
    freq.put("zna", 857);
    freq.put("bož", 16);
    freq.put("znj", 20);
    freq.put("zni", 90);
    freq.put("zno", 61);
    freq.put("q", 635);
    freq.put("znu", 24);
    freq.put("ny ", 26);
    freq.put("lsk", 23);
    freq.put("lsi", 7);
    freq.put("qh ", 11);
    freq.put("kk ", 11);
    freq.put(" aa", 20);
    freq.put(" ab", 17);
    freq.put(" ac", 12);
    freq.put(" ad", 35);
    freq.put(" ae", 13);
    freq.put(" af", 14);
    freq.put(" ag", 14);
    freq.put(" ah", 38);
    freq.put(" ai", 9);
    freq.put(" aj", 80);
    freq.put(" ak", 309);
    freq.put(" al", 544);
    freq.put(" am", 114);
    freq.put(" an", 134);
    freq.put(" ap", 71);
    freq.put(" ar", 38);
    freq.put(" as", 40);
    freq.put(" at", 30);
    freq.put(" au", 72);
    freq.put(" av", 47);
    freq.put(" az", 48);
    freq.put("ls ", 25);
    freq.put("Sha", 10);
    freq.put("kka", 9);
    freq.put("Sho", 13);
    freq.put(" a ", 892);
    freq.put("Luv", 7);
    freq.put("aTa", 11);
    freq.put("aTo", 7);
    freq.put("Luc", 8);
    freq.put("Lud", 12);
    freq.put("Luk", 26);
    freq.put("or ", 200);
    freq.put("Ken", 9);
    freq.put("Dž", 7);
    freq.put("Ker", 8);
    freq.put("RT ", 1489);
    freq.put("G", 891);
    freq.put("orv", 13);
    freq.put("ort", 101);
    freq.put("oru", 194);
    freq.put("ors", 33);
    freq.put("orp", 7);
    freq.put("orn", 85);
    freq.put("oro", 131);
    freq.put("orl", 9);
    freq.put("orm", 104);
    freq.put("orj", 11);
    freq.put("ork", 51);
    freq.put("ori", 600);
    freq.put("org", 49);
    freq.put("ord", 88);
    freq.put("ore", 274);
    freq.put("orb", 39);
    freq.put("orc", 25);
    freq.put("ora", 593);
    freq.put("Apa", 17);
    freq.put("orB", 7);
    freq.put("vje", 189);
    freq.put("ua ", 17);
    freq.put("UU ", 7);
    freq.put("Oti", 7);
    freq.put("Otk", 14);
    freq.put("Ota", 7);
    freq.put("Otp", 7);
    freq.put("Otv", 19);
    freq.put("JK ", 7);
    freq.put(" ot", 256);
    freq.put(" Ša", 14);
    freq.put(" Še", 13);
    freq.put(" Ši", 9);
    freq.put(" Šp", 10);
    freq.put(" Šu", 8);
    freq.put(" Št", 88);
    freq.put(" ou", 17);
    freq.put("pto", 15);
    freq.put("Do", 212);
    freq.put("Dl", 7);
    freq.put("Dj", 94);
    freq.put("Dk", 9);
    freq.put("Di", 100);
    freq.put("De", 153);
    freq.put("Db", 7);
    freq.put("Da", 357);
    freq.put("Dz", 26);
    freq.put("Dx", 11);
    freq.put("Dy", 9);
    freq.put("Dv", 26);
    freq.put("Dw", 9);
    freq.put("Dt", 11);
    freq.put("Du", 75);
    freq.put("Dr", 114);
    freq.put("Dp", 10);
    freq.put("ća ", 145);
    freq.put("ćas", 8);
    freq.put("D ", 437);
    freq.put("ćao", 7);
    freq.put("ćan", 31);
    freq.put("ćam", 39);
    freq.put("ćaj", 22);
    freq.put("Š ", 36);
    freq.put("ge ", 153);
    freq.put("Wf", 7);
    freq.put("We", 29);
    freq.put("Wa", 28);
    freq.put("Wo", 20);
    freq.put("Wj", 10);
    freq.put("Wi", 30);
    freq.put("Wh", 15);
    freq.put("а", 13);
    freq.put("Wu", 8);
    freq.put("Wt", 7);
    freq.put("Ws", 7);
    freq.put("Wr", 13);
    freq.put("ger", 37);
    freq.put("Ša", 15);
    freq.put("get", 21);
    freq.put("Ši", 11);
    freq.put("Šp", 10);
    freq.put("Št", 88);
    freq.put("Šu", 8);
    freq.put("gej", 13);
    freq.put("gen", 74);
    freq.put("RI ", 18);
    freq.put("gel", 18);
    freq.put("W ", 84);
    freq.put("oJa", 8);
    freq.put("ša", 289);
    freq.put("še", 418);
    freq.put("ši", 235);
    freq.put("šk", 151);
    freq.put("šm", 10);
    freq.put("šl", 139);
    freq.put("šo", 36);
    freq.put("šn", 109);
    freq.put("šu", 69);
    freq.put("št", 891);
    freq.put("tu ", 462);
    freq.put("j ", 1559);
    freq.put("paž", 8);
    freq.put("paš", 9);
    freq.put("tur", 135);
    freq.put("š ", 760);
    freq.put("tuz", 10);
    freq.put("jx", 9);
    freq.put("jy", 7);
    freq.put("jz", 49);
    freq.put("jt", 201);
    freq.put("ju", 2437);
    freq.put("jv", 149);
    freq.put("tus", 53);
    freq.put("jp", 31);
    freq.put("jr", 26);
    freq.put("js", 185);
    freq.put("jl", 94);
    freq.put("jm", 98);
    freq.put("jn", 281);
    freq.put("jo", 632);
    freq.put("jh", 11);
    freq.put("ji", 1731);
    freq.put("jj", 62);
    freq.put("jk", 288);
    freq.put("jd", 165);
    freq.put("je", 9913);
    freq.put("jf", 15);
    freq.put("jg", 63);
    freq.put("tud", 50);
    freq.put("pač", 7);
    freq.put("jb", 142);
    freq.put("jc", 53);
    freq.put("jT", 10);
    freq.put("jU", 8);
    freq.put("jV", 7);
    freq.put("jW", 13);
    freq.put("jQ", 7);
    freq.put("jR", 11);
    freq.put("jL", 8);
    freq.put("jM", 8);
    freq.put("jO", 9);
    freq.put("jH", 9);
    freq.put(" Ža", 11);
    freq.put("dka", 7);
    freq.put("tul", 25);
    freq.put("jG", 7);
    freq.put(" Ži", 20);
    freq.put("jB", 8);
    freq.put("tum", 11);
    freq.put("tun", 17);
    freq.put("cla", 12);
    freq.put("tua", 32);
    freq.put("tub", 43);
    freq.put("ađu", 14);
    freq.put("tuc", 8);
    freq.put("naD", 12);
    freq.put("ja", 4419);
    freq.put("ađe", 44);
    freq.put("naJ", 9);
    freq.put("ađa", 51);
    freq.put("tug", 21);
    freq.put("ađi", 10);
    freq.put("bma", 10);
    freq.put("Tr", 111);
    freq.put("ažu", 29);
    freq.put("naS", 10);
    freq.put(" bb", 8);
    freq.put("aže", 142);
    freq.put("aža", 18);
    freq.put("ažn", 29);
    freq.put("aži", 61);
    freq.put("naT", 15);
    freq.put("ze ", 345);
    freq.put("oi ", 48);
    freq.put("eć ", 90);
    freq.put("pap", 40);
    freq.put("par", 241);
    freq.put("pas", 70);
    freq.put("pat", 81);
    freq.put("pau", 15);
    freq.put("pav", 123);
    freq.put(" Že", 31);
    freq.put("tuđ", 12);
    freq.put("paz", 24);
    freq.put("jč", 8);
    freq.put("pac", 29);
    freq.put("pad", 109);
    freq.put("paj", 24);
    freq.put("pak", 80);
    freq.put("pal", 138);
    freq.put("pam", 95);
    freq.put("pan", 107);
    freq.put("pao", 29);
    freq.put("oin", 9);
    freq.put("tuž", 26);
    freq.put("nac", 196);
    freq.put(" br", 347);
    freq.put("eću", 68);
    freq.put("eći", 89);
    freq.put("ećn", 16);
    freq.put("eća", 115);
    freq.put("oit", 10);
    freq.put("ois", 55);
    freq.put("eće", 150);
    freq.put("šć", 18);
    freq.put("ujt", 14);
    freq.put("uju", 134);
    freq.put("nae", 31);
    freq.put("šč", 12);
    freq.put("pa ", 592);
    freq.put("ujo", 8);
    freq.put("uji", 17);
    freq.put("uje", 419);
    freq.put("uja", 21);
    freq.put("nan", 103);
    freq.put("nao", 42);
    freq.put("mo ", 1325);
    freq.put("Upo", 11);
    freq.put("mos", 40);
    freq.put("mor", 297);
    freq.put("mov", 74);
    freq.put("mou", 11);
    freq.put("mot", 52);
    freq.put("mok", 36);
    freq.put("moj", 405);
    freq.put("moi", 14);
    freq.put("moo", 27);
    freq.put("mon", 61);
    freq.put("mom", 111);
    freq.put("mol", 58);
    freq.put("moc", 41);
    freq.put("mob", 39);
    freq.put("Upr", 21);
    freq.put("mod", 58);
    freq.put("zle", 14);
    freq.put("zla", 67);
    freq.put("oiz", 19);
    freq.put("zlo", 65);
    freq.put("zli", 49);
    freq.put("Nen", 13);
    freq.put("Nem", 84);
    freq.put("Nek", 71);
    freq.put("Neg", 11);
    freq.put("Ned", 21);
    freq.put("MeN", 7);
    freq.put("Nec", 17);
    freq.put("ptu", 15);
    freq.put("Nev", 24);
    freq.put("New", 10);
    freq.put("Ner", 7);
    freq.put("Nes", 19);
    freq.put("Nep", 8);
    freq.put("Med", 16);
    freq.put(" ch", 97);
    freq.put(" ci", 222);
    freq.put(" cn", 7);
    freq.put(" co", 2370);
    freq.put(" cl", 16);
    freq.put(" cm", 8);
    freq.put(" cc", 25);
    freq.put("Men", 48);
    freq.put("kmi", 31);
    freq.put(" ce", 439);
    freq.put("Met", 11);
    freq.put("ža ", 20);
    freq.put(" cy", 14);
    freq.put("Mes", 17);
    freq.put("Mer", 16);
    freq.put(" cr", 152);
    freq.put(" cv", 26);
    freq.put(" cu", 239);
    freq.put("Dru", 33);
    freq.put("Ne ", 205);
    freq.put("Dra", 51);
    freq.put("Sja", 7);
    freq.put("Sje", 12);
    freq.put("žav", 63);
    freq.put("Me ", 10);
    freq.put(" c ", 40);
    freq.put("žab", 7);
    freq.put("VD ", 10);
    freq.put("žan", 28);
    freq.put("žao", 9);
    freq.put("žal", 18);
    freq.put("yyy", 7);
    freq.put("moć", 32);
    freq.put("mož", 149);
    freq.put("Ac", 22);
    freq.put("yy ", 9);
    freq.put("Ae", 8);
    freq.put("Af", 20);
    freq.put("Kg ", 9);
    freq.put("sve", 555);
    freq.put("dva", 147);
    freq.put("eši", 31);
    freq.put("sva", 251);
    freq.put("Ova", 35);
    freq.put("Ovd", 11);
    freq.put("Ove", 15);
    freq.put("Ovi", 17);
    freq.put("Ovo", 40);
    freq.put("goo", 40);
    freq.put("Az", 20);
    freq.put("US ", 8);
    freq.put("Neć", 9);
    freq.put("u", 22316);
    freq.put("gog", 22);
    freq.put("iča", 106);
    freq.put("Van", 20);
    freq.put("Val", 19);
    freq.put("Vam", 8);
    freq.put("iu ", 9);
    freq.put("deč", 26);
    freq.put("Var", 10);
    freq.put("Vas", 21);
    freq.put("deć", 29);
    freq.put("hy ", 7);
    freq.put("aš ", 235);
    freq.put("JI ", 41);
    freq.put("iči", 24);
    freq.put("и", 15);
    freq.put("LA ", 82);
    freq.put("TA ", 69);
    freq.put("aja", 270);
    freq.put("ius", 13);
    freq.put("akr", 22);
    freq.put("aše", 58);
    freq.put("ajc", 24);
    freq.put("aša", 42);
    freq.put("ašl", 10);
    freq.put("ašn", 43);
    freq.put("aši", 64);
    freq.put("ašk", 9);
    freq.put("ašu", 13);
    freq.put("ašt", 96);
    freq.put("SI ", 42);
    freq.put("ajf", 8);
    freq.put("deš", 29);
    freq.put("ajg", 45);
    freq.put("Zve", 18);
    freq.put("Gin", 10);
    freq.put("aba", 109);
    freq.put("abe", 40);
    freq.put("abi", 64);
    freq.put("abl", 35);
    freq.put("abo", 122);
    freq.put("а ", 8);
    freq.put("abu", 38);
    freq.put("lko", 55);
    freq.put("K", 1743);
    freq.put("akv", 186);
    freq.put("ab ", 8);
    freq.put("twe", 36);
    freq.put("nPe", 26);
    freq.put("twi", 43);
    freq.put("jd ", 16);
    freq.put("de ", 733);
    freq.put("OU ", 9);
    freq.put("gO", 8);
    freq.put("Nov", 76);
    freq.put("ey ", 29);
    freq.put("dez", 11);
    freq.put("jdi", 10);
    freq.put("dep", 12);
    freq.put("der", 128);
    freq.put("des", 114);
    freq.put("det", 91);
    freq.put("dev", 71);
    freq.put("dej", 42);
    freq.put("dek", 47);
    freq.put("del", 168);
    freq.put("dem", 244);
    freq.put("den", 118);
    freq.put("deo", 86);
    freq.put("sGa", 8);
    freq.put("dea", 22);
    freq.put("deb", 42);
    freq.put("dec", 105);
    freq.put("ded", 19);
    freq.put("dee", 12);
    freq.put("def", 23);
    freq.put("Do ", 15);
    freq.put("iPa", 7);
    freq.put("iPh", 19);
    freq.put("rys", 7);
    freq.put("Dok", 18);
    freq.put("Don", 8);
    freq.put("Dol", 15);
    freq.put("Dom", 17);
    freq.put("Dob", 63);
    freq.put("Dod", 15);
    freq.put("Dor", 13);
    freq.put("Dos", 12);
    freq.put("Dov", 8);
    freq.put("ry ", 32);
    freq.put("uh ", 24);
    freq.put("ok ", 244);
    freq.put("koš", 11);
    freq.put("pci", 37);
    freq.put("pca", 8);
    freq.put("pce", 11);
    freq.put("Bat", 10);
    freq.put("okr", 97);
    freq.put("Bar", 28);
    freq.put("Bas", 28);
    freq.put("okv", 18);
    freq.put("uho", 25);
    freq.put("Bay", 13);
    freq.put("oka", 222);
    freq.put("Bad", 18);
    freq.put("uhu", 13);
    freq.put("Bab", 15);
    freq.put("Ban", 35);
    freq.put("Bal", 63);
    freq.put("Baj", 12);
    freq.put("okl", 38);
    freq.put("oko", 190);
    freq.put("okn", 8);
    freq.put("BaP", 7);
    freq.put("uj ", 27);
    freq.put("mm ", 24);
    freq.put("E ", 1031);
    freq.put("oid", 16);
    freq.put("Unu", 7);
    freq.put("sbu", 14);
    freq.put("mmm", 30);
    freq.put("Una", 7);
    freq.put("sla", 323);
    freq.put("mme", 8);
    freq.put("Uni", 15);
    freq.put("mma", 10);
    freq.put("Em", 18);
    freq.put("El", 19);
    freq.put("kš", 13);
    freq.put("En", 25);
    freq.put("Ei", 8);
    freq.put("Eh", 9);
    freq.put("Ek", 20);
    freq.put("Ej", 7);
    freq.put("Ee", 7);
    freq.put("Ed", 18);
    freq.put("Eg", 14);
    freq.put("Ef", 7);
    freq.put("Ec", 14);
    freq.put("Eb", 9);
    freq.put("Ey", 7);
    freq.put("Ex", 19);
    freq.put("Eu", 37);
    freq.put("Et", 30);
    freq.put("Ev", 107);
    freq.put("Eq", 10);
    freq.put("Ep", 15);
    freq.put("Er", 16);
    freq.put("koG", 8);
    freq.put("koi", 67);
    freq.put("koh", 20);
    freq.put("kok", 34);
    freq.put("koj", 776);
    freq.put("kom", 481);
    freq.put("kol", 471);
    freq.put("koo", 16);
    freq.put("kon", 255);
    freq.put(" ed", 29);
    freq.put(" ee", 9);
    freq.put("koc", 23);
    freq.put(" eg", 8);
    freq.put("kod", 110);
    freq.put(" eb", 8);
    freq.put("kof", 7);
    freq.put("koz", 11);
    freq.put(" ex", 15);
    freq.put(" et", 48);
    freq.put(" eu", 64);
    freq.put(" ev", 120);
    freq.put("kor", 196);
    freq.put(" ep", 32);
    freq.put("kot", 34);
    freq.put(" er", 8);
    freq.put(" es", 46);
    freq.put("Slu", 20);
    freq.put("Slo", 17);
    freq.put("Baš", 9);
    freq.put("Sle", 33);
    freq.put("Sla", 29);
    freq.put("b", 9131);
    freq.put("Xb", 9);
    freq.put("ko ", 2462);
    freq.put(" e ", 232);
    freq.put("Xd", 7);
    freq.put("Xx", 7);
    freq.put("Xy", 7);
    freq.put("Xq", 8);
    freq.put("Xt", 10);
    freq.put("ši ", 60);
    freq.put("Mla", 21);
    freq.put("k ", 1745);
    freq.put("Kis", 11);
    freq.put("Kin", 22);
    freq.put("Kim", 8);
    freq.put("kB", 10);
    freq.put("kA", 10);
    freq.put("kG", 8);
    freq.put("kE", 8);
    freq.put("vno", 225);
    freq.put("kO", 7);
    freq.put("kN", 8);
    freq.put("kM", 7);
    freq.put("kR", 8);
    freq.put("vnu", 18);
    freq.put("kT", 10);
    freq.put("zI", 8);
    freq.put("kc", 103);
    freq.put("kb", 14);
    freq.put("ka", 5379);
    freq.put("kg", 34);
    freq.put("kf", 9);
    freq.put("ke", 1066);
    freq.put("kd", 16);
    freq.put("kk", 35);
    freq.put("kj", 36);
    freq.put("ki", 1387);
    freq.put("kh", 21);
    freq.put("ko", 5805);
    freq.put("kn", 189);
    freq.put("km", 46);
    freq.put("kl", 471);
    freq.put("ks", 304);
    freq.put("kr", 814);
    freq.put("kq", 9);
    freq.put("kp", 12);
    freq.put("kw", 14);
    freq.put("kv", 320);
    freq.put("ku", 1488);
    freq.put("kt", 238);
    freq.put("kz", 10);
    freq.put("ky", 34);
    freq.put("kx", 13);
    freq.put("Opr", 7);
    freq.put("gađ", 16);
    freq.put("Ope", 14);
    freq.put("gač", 10);
    freq.put("Opa", 13);
    freq.put(" Be", 141);
    freq.put(" Bg", 8);
    freq.put(" Ba", 214);
    freq.put(" Bl", 78);
    freq.put(" Bo", 219);
    freq.put(" Bi", 134);
    freq.put(" Bj", 7);
    freq.put(" Bu", 55);
    freq.put("ik ", 213);
    freq.put(" Br", 121);
    freq.put("DD ", 16);
    freq.put("iks", 14);
    freq.put("ikv", 9);
    freq.put("iku", 151);
    freq.put("ikt", 16);
    freq.put("ika", 673);
    freq.put("GE ", 12);
    freq.put("ike", 186);
    freq.put("iki", 98);
    freq.put("iko", 503);
    freq.put("ikn", 17);
    freq.put("rBa", 8);
    freq.put("ikl", 39);
    freq.put("lbu", 18);
    freq.put("ga ", 664);
    freq.put("ND ", 12);
    freq.put("fu ", 23);
    freq.put("gaz", 24);
    freq.put("gav", 17);
    freq.put("gat", 44);
    freq.put("gas", 28);
    freq.put("gar", 134);
    freq.put("gao", 44);
    freq.put("gan", 125);
    freq.put("gam", 34);
    freq.put("gal", 33);
    freq.put("gaj", 9);
    freq.put("gag", 7);
    freq.put("gad", 26);
    freq.put("gac", 35);
    freq.put("lba", 16);
    freq.put("fur", 8);
    freq.put("fud", 22);
    freq.put("tj ", 18);
    freq.put("fuc", 12);
    freq.put("fun", 20);
    freq.put("sy ", 9);
    freq.put("moz", 183);
    freq.put("Ira", 28);
    freq.put("ews", 7);
    freq.put("dgo", 87);
    freq.put("dgl", 9);
    freq.put("dgr", 8);
    freq.put("jbt", 7);
    freq.put("ew ", 15);
    freq.put("jbg", 15);
    freq.put("jbo", 92);
    freq.put("jbi", 8);
    freq.put("lda", 9);
    freq.put("lde", 13);
    freq.put("ceo", 30);
    freq.put("ldi", 10);
    freq.put("bi ", 511);
    freq.put("cuv", 22);
    freq.put("cut", 30);
    freq.put("cus", 24);
    freq.put("cur", 24);
    freq.put("cup", 8);
    freq.put("mog", 360);
    freq.put("cuz", 9);
    freq.put("rga", 41);
    freq.put("cud", 24);
    freq.put("rge", 18);
    freq.put("cuo", 8);
    freq.put("rgi", 28);
    freq.put("cum", 7);
    freq.put("cul", 24);
    freq.put("cuj", 52);
    freq.put("rgo", 19);
    freq.put("bin", 48);
    freq.put("Dim", 7);
    freq.put("bil", 355);
    freq.put("bim", 38);
    freq.put("bij", 323);
    freq.put("bik", 8);
    freq.put("bih", 162);
    freq.put("big", 9);
    freq.put("bid", 16);
    freq.put("bie", 9);
    freq.put("bib", 9);
    freq.put("bic", 111);
    freq.put("bia", 22);
    freq.put("biz", 10);
    freq.put("AL ", 14);
    freq.put("biv", 31);
    freq.put("Div", 13);
    freq.put("bir", 35);
    freq.put("bis", 49);
    freq.put("Dir", 9);
    freq.put("rg ", 13);
    freq.put("cu ", 445);
    freq.put("oe ", 17);
    freq.put("pet", 167);
    freq.put("pev", 54);
    freq.put("per", 190);
    freq.put("pes", 93);
    freq.put("pel", 29);
    freq.put("pen", 40);
    freq.put("peo", 10);
    freq.put("peh", 12);
    freq.put("pek", 30);
    freq.put("ped", 26);
    freq.put("ape", 49);
    freq.put("pec", 27);
    freq.put("Boy", 8);
    freq.put("Boz", 17);
    freq.put("ufo", 9);
    freq.put("oes", 7);
    freq.put("oer", 8);
    freq.put("Bor", 28);
    freq.put("Bos", 37);
    freq.put("O", 1308);
    freq.put("Boj", 28);
    freq.put("Bol", 27);
    freq.put("oen", 24);
    freq.put("Bon", 8);
    freq.put("Boo", 8);
    freq.put("Bob", 14);
    freq.put("Bog", 39);
    freq.put("lga", 8);
    freq.put("uso", 30);
    freq.put("pe ", 128);
    freq.put("žeš", 38);
    freq.put("nsi", 25);
    freq.put("nsk", 188);
    freq.put("nsa", 18);
    freq.put("nse", 20);
    freq.put("nsf", 7);
    freq.put("usj", 11);
    freq.put("nsp", 27);
    freq.put("Žel", 20);
    freq.put("Žen", 10);
    freq.put("nst", 102);
    freq.put("nsu", 12);
    freq.put("mke", 8);
    freq.put("bič", 14);
    freq.put("mka", 15);
    freq.put("bić", 19);
    freq.put("ust", 315);
    freq.put("uss", 8);
    freq.put(" R ", 21);
    freq.put("ČE ", 7);
    freq.put("ns ", 38);
    freq.put("usp", 71);
    freq.put("sda", 11);
    freq.put("Ula", 7);
    freq.put("mk ", 9);
    freq.put("tvo", 285);
    freq.put("zhe", 8);
    freq.put("tve", 33);
    freq.put("Mas", 16);
    freq.put("Mar", 154);
    freq.put(" gr", 279);
    freq.put("Mat", 33);
    freq.put("Max", 8);
    freq.put(" gy", 7);
    freq.put(" gd", 99);
    freq.put(" ge", 63);
    freq.put("Mad", 24);
    freq.put("Mag", 12);
    freq.put(" ga", 312);
    freq.put(" gn", 7);
    freq.put(" go", 715);
    freq.put(" gl", 496);
    freq.put("Maj", 44);
    freq.put("Mam", 18);
    freq.put("Mal", 58);
    freq.put("že ", 191);
    freq.put(" gi", 73);
    freq.put("Bož", 18);
    freq.put(" ck", 11);
    freq.put("ly ", 30);
    freq.put("žev", 7);
    freq.put("žet", 20);
    freq.put("žer", 8);
    freq.put("žen", 117);
    freq.put("Ma ", 39);
    freq.put("žel", 87);
    freq.put("žem", 60);
    freq.put(" g ", 26);
    freq.put("Mel", 8);
    freq.put(" b", 3358);
    freq.put(" c", 3847);
    freq.put(" a", 2657);
    freq.put(" f", 958);
    freq.put(" g", 2230);
    freq.put(" d", 8019);
    freq.put(" e", 923);
    freq.put(" j", 5783);
    freq.put(" k", 5922);
    freq.put(" h", 3389);
    freq.put(" i", 6588);
    freq.put(" n", 9900);
    freq.put(" o", 5089);
    freq.put(" l", 2103);
    freq.put(" m", 6346);
    freq.put(" r", 2029);
    freq.put(" Dž", 7);
    freq.put(" p", 8281);
    freq.put(" q", 124);
    freq.put(" v", 3199);
    freq.put(" w", 264);
    freq.put(" t", 7599);
    freq.put(" u", 4415);
    freq.put(" z", 4075);
    freq.put(" x", 205);
    freq.put(" y", 178);
    freq.put(" B", 1324);
    freq.put(" C", 594);
    freq.put(" A", 1206);
    freq.put(" F", 443);
    freq.put(" G", 674);
    freq.put(" D", 1995);
    freq.put(" E", 493);
    freq.put(" J", 1342);
    freq.put(" K", 1528);
    freq.put(" H", 629);
    freq.put(" I", 1254);
    freq.put(" N", 1904);
    freq.put(" O", 1085);
    freq.put(" L", 712);
    freq.put(" M", 1767);
    freq.put(" R", 2175);
    freq.put(" S", 2526);
    freq.put(" P", 1805);
    freq.put(" Q", 110);
    freq.put(" V", 874);
    freq.put(" W", 207);
    freq.put(" T", 1127);
    freq.put(" U", 685);
    freq.put(" Z", 823);
    freq.put(" X", 137);
    freq.put("Xi", 8);
    freq.put("vlj", 205);
    freq.put("vlo", 11);
    freq.put("vla", 135);
    freq.put(" ?", 17);
    freq.put("Već", 13);
    freq.put("Več", 16);
    freq.put("och", 27);
    freq.put("ock", 43);
    freq.put(" Do", 195);
    freq.put(" Š", 210);
    freq.put(" š", 613);
    freq.put("Ver", 21);
    freq.put(" Dj", 71);
    freq.put(" Di", 86);
    freq.put("oce", 134);
    freq.put(" De", 117);
    freq.put(" Da", 326);
    freq.put("ii ", 65);
    freq.put("Ven", 7);
    freq.put(" Dv", 20);
    freq.put(" Du", 62);
    freq.put(" ž", 348);
    freq.put(" Dr", 100);
    freq.put(" Ž", 84);
    freq.put("Fp", 7);
    freq.put("cha", 81);
    freq.put("Fr", 63);
    freq.put("Ft", 8);
    freq.put("che", 121);
    freq.put("chi", 59);
    freq.put("Fz", 7);
    freq.put("chk", 23);
    freq.put("chn", 19);
    freq.put("cho", 22);
    freq.put("Fa", 55);
    freq.put("JE ", 172);
    freq.put("chu", 10);
    freq.put("Fi", 54);
    freq.put("Fl", 10);
    freq.put("Fn", 7);
    freq.put("Fo", 50);
    freq.put(" D ", 189);
    freq.put("iii", 98);
    freq.put("ch ", 59);
    freq.put(" Ć", 40);
    freq.put(" ć", 352);
    freq.put("f", 2299);
    freq.put(" Č", 98);
    freq.put(" č", 385);
    freq.put("F ", 89);
    freq.put(" Đ", 26);
    freq.put(" đ", 17);
    freq.put("ač", 423);
    freq.put("Yh", 7);
    freq.put("Yj", 10);
    freq.put("afi", 58);
    freq.put("Yo", 60);
    freq.put("Ya", 9);
    freq.put("afe", 23);
    freq.put("aff", 9);
    freq.put("Ye", 8);
    freq.put("afa", 39);
    freq.put("aft", 8);
    freq.put("afu", 24);
    freq.put("Ys", 8);
    freq.put("Yu", 11);
    freq.put("afr", 7);
    freq.put("miz", 11);
    freq.put("Y ", 70);
    freq.put("af ", 8);
    freq.put("lF", 8);
    freq.put("lG", 9);
    freq.put("lD", 9);
    freq.put("da ", 4720);
    freq.put("lA", 13);
    freq.put("lN", 13);
    freq.put("bje", 55);
    freq.put("lV", 8);
    freq.put("lW", 8);
    freq.put("lU", 10);
    freq.put("lP", 8);
    freq.put("lf", 23);
    freq.put("lg", 63);
    freq.put("ld", 88);
    freq.put("le", 2426);
    freq.put("lb", 56);
    freq.put("lc", 49);
    freq.put("la", 4165);
    freq.put("ln", 364);
    freq.put("lo", 1819);
    freq.put("ll", 242);
    freq.put("lm", 119);
    freq.put("lj", 2452);
    freq.put("lk", 190);
    freq.put("lh", 26);
    freq.put("li", 4855);
    freq.put("lv", 41);
    freq.put("lw", 8);
    freq.put("lt", 111);
    freq.put("lu", 1014);
    freq.put("lr", 10);
    freq.put("ls", 86);
    freq.put("lp", 14);
    freq.put("euz", 11);
    freq.put("tst", 7);
    freq.put("lz", 20);
    freq.put("eus", 20);
    freq.put("ly", 61);
    freq.put("dad", 14);
    freq.put("eme", 279);
    freq.put("daa", 17);
    freq.put("dab", 12);
    freq.put("dac", 19);
    freq.put("dal", 228);
    freq.put("dam", 216);
    freq.put("dan", 883);
    freq.put("dao", 55);
    freq.put("dah", 19);
    freq.put("daj", 255);
    freq.put("dak", 52);
    freq.put("dat", 105);
    freq.put("dav", 92);
    freq.put("dar", 154);
    freq.put("das", 33);
    freq.put("sii", 7);
    freq.put("l ", 881);
    freq.put("emb", 12);
    freq.put("eu ", 21);
    freq.put("ts ", 28);
    freq.put("daR", 12);
    freq.put("eml", 40);
    freq.put("emo", 365);
    freq.put("emi", 158);
    freq.put("rez", 79);
    freq.put("emu", 91);
    freq.put("rey", 11);
    freq.put("rer", 17);
    freq.put("res", 250);
    freq.put("Tur", 23);
    freq.put("rev", 141);
    freq.put("ret", 222);
    freq.put("reu", 17);
    freq.put("rej", 43);
    freq.put("rek", 258);
    freq.put("reh", 8);
    freq.put("rei", 14);
    freq.put("ren", 384);
    freq.put("reo", 15);
    freq.put("rel", 69);
    freq.put("rem", 388);
    freq.put("reb", 393);
    freq.put("rec", 211);
    freq.put("Tub", 31);
    freq.put("rea", 89);
    freq.put("ref", 14);
    freq.put("reg", 41);
    freq.put("red", 517);
    freq.put("ree", 50);
    freq.put("mič", 10);
    freq.put("mić", 15);
    freq.put("qua", 16);
    freq.put("que", 14);
    freq.put("qui", 13);
    freq.put("hr ", 83);
    freq.put("Tu ", 10);
    freq.put("re ", 449);
    freq.put("Ž", 84);
    freq.put("ud ", 40);
    freq.put("og ", 716);
    freq.put("dač", 7);
    freq.put("euš", 11);
    freq.put("nuv", 9);
    freq.put("udr", 18);
    freq.put("uds", 16);
    freq.put("udv", 11);
    freq.put("daš", 16);
    freq.put("udu", 46);
    freq.put("ogu", 335);
    freq.put("ogr", 136);
    freq.put("udb", 37);
    freq.put("ogl", 189);
    freq.put("ogo", 259);
    freq.put("ogn", 21);
    freq.put("ogi", 58);
    freq.put("ude", 288);
    freq.put("oge", 42);
    freq.put("ogd", 12);
    freq.put("udi", 434);
    freq.put("oga", 336);
    freq.put("udo", 23);
    freq.put("Par", 50);
    freq.put("Pas", 13);
    freq.put("Pat", 7);
    freq.put("Pav", 15);
    freq.put("nqk", 25);
    freq.put("šti", 54);
    freq.put("Pal", 15);
    freq.put("Pam", 7);
    freq.put("Pan", 19);
    freq.put("nqm", 20);
    freq.put("mih", 10);
    freq.put("mik", 22);
    freq.put("mij", 125);
    freq.put("rež", 15);
    freq.put("mil", 167);
    freq.put("mio", 9);
    freq.put("min", 212);
    freq.put("mic", 85);
    freq.put("mie", 8);
    freq.put("mid", 10);
    freq.put("štu", 14);
    freq.put("mis", 475);
    freq.put("reš", 44);
    freq.put("mit", 37);
    freq.put("ređ", 17);
    freq.put("Pa ", 98);
    freq.put("sfo", 8);
    freq.put("reč", 34);
    freq.put("sfe", 12);
    freq.put("reć", 112);
    freq.put("mi ", 1210);
    freq.put("xD ", 22);
    freq.put(" iP", 25);
    freq.put(" iT", 9);
    freq.put("░", 7);
    freq.put("ksG", 8);
    freq.put("ksu", 31);
    freq.put("Moz", 17);
    freq.put(" iz", 1006);
    freq.put("ksp", 18);
    freq.put(" ip", 36);
    freq.put("Mor", 32);
    freq.put(" ir", 31);
    freq.put(" is", 568);
    freq.put(" it", 30);
    freq.put(" iv", 42);
    freq.put("kse", 24);
    freq.put("Moj", 60);
    freq.put(" ik", 39);
    freq.put("Moo", 10);
    freq.put(" im", 741);
    freq.put(" in", 297);
    freq.put("Mol", 9);
    freq.put(" ia", 20);
    freq.put(" ib", 7);
    freq.put(" ic", 9);
    freq.put(" id", 259);
    freq.put("Mod", 22);
    freq.put("ks ", 37);
    freq.put(" i ", 2849);
    freq.put(" Iz", 80);
    freq.put("Zor", 19);
    freq.put("Zov", 10);
    freq.put("sMe", 9);
    freq.put(" ii", 10);
    freq.put(" Ip", 9);
    freq.put(" Ir", 46);
    freq.put("vrs", 75);
    freq.put(" Is", 64);
    freq.put("vru", 16);
    freq.put("vrt", 42);
    freq.put(" It", 7);
    freq.put("vrb", 7);
    freq.put("S", 2866);
    freq.put(" Iv", 108);
    freq.put("vre", 208);
    freq.put("vrd", 30);
    freq.put("vri", 86);
    freq.put("vrh", 24);
    freq.put("vro", 68);
    freq.put("vrl", 20);
    freq.put(" Il", 31);
    freq.put(" il", 247);
    freq.put("uža", 19);
    freq.put("užb", 16);
    freq.put("uže", 30);
    freq.put("uži", 62);
    freq.put("užj", 8);
    freq.put("ohn", 22);
    freq.put("užn", 27);
    freq.put("oho", 29);
    freq.put("užu", 12);
    freq.put(" Ib", 7);
    freq.put("ad", 3635);
    freq.put("Mož", 19);
    freq.put("ys ", 7);
    freq.put(" iš", 15);
    freq.put("wx", 7);
    freq.put("ak", 3184);
    freq.put("OL ", 11);
    freq.put("ild", 9);
    freq.put("tje", 57);
    freq.put("cor", 16);
    freq.put("iđe", 8);
    freq.put("iđa", 28);
    freq.put(" ić", 9);
    freq.put("cov", 39);
    freq.put("uis", 8);
    freq.put("wO", 8);
    freq.put("uir", 9);
    freq.put("Hor", 7);
    freq.put("wL", 7);
    freq.put(" Fu", 19);
    freq.put(" Fa", 38);
    freq.put(" Fe", 38);
    freq.put("ći ", 182);
    freq.put(" Fi", 36);
    freq.put(" Fl", 7);
    freq.put(" Fo", 45);
    freq.put("io ", 728);
    freq.put("coc", 9);
    freq.put("cje", 18);
    freq.put(" Y", 154);
    freq.put("cob", 7);
    freq.put("wR", 8);
    freq.put("SO ", 9);
    freq.put("ioz", 13);
    freq.put("iov", 8);
    freq.put("iou", 7);
    freq.put("iot", 42);
    freq.put("ios", 16);
    freq.put("ior", 15);
    freq.put("iop", 7);
    freq.put(" F ", 15);
    freq.put("vrš", 50);
    freq.put("iol", 8);
    freq.put("ćin", 20);
    freq.put("ćim", 10);
    freq.put("iod", 10);
    freq.put("GA ", 22);
    freq.put("col", 22);
    freq.put("con", 15);
    freq.put("adv", 8);
    freq.put("adu", 113);
    freq.put("adr", 61);
    freq.put("ads", 18);
    freq.put("gma", 12);
    freq.put("adz", 12);
    freq.put("ady", 11);
    freq.put("adg", 7);
    freq.put("add", 12);
    freq.put("ade", 190);
    freq.put("adb", 12);
    freq.put("ada", 686);
    freq.put("adn", 200);
    freq.put("ado", 131);
    freq.put("adm", 11);
    freq.put("adj", 118);
    freq.put("м", 7);
    freq.put("adi", 494);
    freq.put("iče", 22);
    freq.put("ad ", 1477);
    freq.put("nja", 639);
    freq.put("nje", 993);
    freq.put("piš", 63);
    freq.put("nji", 314);
    freq.put("njo", 60);
    freq.put("ušt", 51);
    freq.put("njs", 18);
    freq.put("ušk", 47);
    freq.put("ušl", 7);
    freq.put("nju", 195);
    freq.put("ušn", 8);
    freq.put("uša", 65);
    freq.put("esM", 8);
    freq.put("uše", 37);
    freq.put("esv", 21);
    freq.put("esu", 50);
    freq.put("est", 686);
    freq.put("ess", 48);
    freq.put("esr", 18);
    freq.put("esp", 38);
    freq.put("tma", 36);
    freq.put("ese", 176);
    freq.put("esc", 40);
    freq.put("esa", 121);
    freq.put("eso", 45);
    freq.put("esn", 113);
    freq.put("esm", 109);
    freq.put("esl", 20);
    freq.put("esk", 107);
    freq.put("esi", 130);
    freq.put("esh", 55);
    freq.put("nj ", 16);
    freq.put("svi", 302);
    freq.put("OS ", 19);
    freq.put("pič", 16);
    freq.put("pić", 7);
    freq.put("es ", 312);
    freq.put("Twi", 9);
    freq.put("bu ", 105);
    freq.put("adž", 8);
    freq.put("rcu", 19);
    freq.put("rch", 10);
    freq.put("rci", 83);
    freq.put("CU ", 18);
    freq.put("rce", 84);
    freq.put("rca", 51);
    freq.put("buz", 7);
    freq.put("bur", 38);
    freq.put("bus", 44);
    freq.put("but", 10);
    freq.put("buj", 8);
    freq.put("buk", 44);
    freq.put("Dej", 19);
    freq.put("bun", 25);
    freq.put("Dem", 16);
    freq.put("bul", 20);
    freq.put("bum", 31);
    freq.put("bub", 26);
    freq.put("buc", 16);
    freq.put("Deb", 8);
    freq.put("bud", 268);
    freq.put("Iva", 82);
    freq.put("Ivo", 14);
    freq.put("rc ", 7);
    freq.put("ibe", 33);
    freq.put("aGo", 8);
    freq.put("pij", 105);
    freq.put("pil", 62);
    freq.put("pim", 35);
    freq.put("pin", 59);
    freq.put("pio", 36);
    freq.put("pic", 68);
    freq.put("piz", 40);
    freq.put("ub ", 24);
    freq.put("pir", 98);
    freq.put("pis", 245);
    freq.put("pit", 243);
    freq.put("aGr", 7);
    freq.put("piv", 34);
    freq.put("piH", 10);
    freq.put("oad", 9);
    freq.put("oal", 7);
    freq.put("oat", 22);
    freq.put("ubu", 15);
    freq.put("Aca", 12);
    freq.put("ubr", 31);
    freq.put("pi ", 79);
    freq.put("ube", 98);
    freq.put("uba", 240);
    freq.put("ubl", 56);
    freq.put("ubo", 79);
    freq.put("ubi", 190);
    freq.put("oa ", 32);
    freq.put("Gde", 12);
    freq.put("Cro", 32);
    freq.put("G ", 139);
    freq.put("sca", 10);
    freq.put("Gw", 7);
    freq.put("Gu", 29);
    freq.put("Gs", 9);
    freq.put("Gr", 101);
    freq.put("zdu", 20);
    freq.put("gnu", 12);
    freq.put("Gy", 9);
    freq.put("zdr", 77);
    freq.put("Ok ", 12);
    freq.put("Ge", 46);
    freq.put("Gd", 20);
    freq.put("Gc", 7);
    freq.put("Ga", 81);
    freq.put("Go", 193);
    freq.put("Gl", 50);
    freq.put("zda", 115);
    freq.put("Gi", 24);
    freq.put("Gh", 12);
    freq.put(" ka", 2309);
    freq.put(" kg", 14);
    freq.put(" ke", 127);
    freq.put(" kk", 9);
    freq.put(" ki", 150);
    freq.put(" kn", 99);
    freq.put(" ko", 1918);
    freq.put(" kl", 123);
    freq.put(" kr", 489);
    freq.put("scu", 12);
    freq.put(" kv", 62);
    freq.put(" ku", 471);
    freq.put("enš", 9);
    freq.put("pće", 7);
    freq.put("kuz", 7);
    freq.put("Fin", 7);
    freq.put("kut", 15);
    freq.put("Z ", 118);
    freq.put("kur", 109);
    freq.put("kup", 196);
    freq.put("kun", 35);
    freq.put("kum", 18);
    freq.put("ain", 28);
    freq.put("kuk", 26);
    freq.put("kuj", 58);
    freq.put("kuh", 10);
    freq.put("kud", 15);
    freq.put("kuc", 93);
    freq.put(" k ", 58);
    freq.put("enč", 7);
    freq.put("Zl", 25);
    freq.put("Zm", 7);
    freq.put("Zn", 64);
    freq.put("Zo", 38);
    freq.put("Zh", 7);
    freq.put("Zi", 37);
    freq.put("Zk", 7);
    freq.put("Zd", 19);
    freq.put("Ze", 50);
    freq.put("Zg", 7);
    freq.put("Za", 300);
    freq.put("Zb", 15);
    freq.put("Zc", 8);
    freq.put("Zx", 8);
    freq.put("Zy", 9);
    freq.put("Zz", 8);
    freq.put("Zu", 14);
    freq.put("Zv", 31);
    freq.put("Zw", 8);
    freq.put("Zp", 7);
    freq.put("Zr", 10);
    freq.put("Zs", 8);
    freq.put("Koj", 40);
    freq.put("Kom", 36);
    freq.put("Kol", 68);
    freq.put("Kon", 28);
    freq.put("Kod", 10);
    freq.put("Kog", 10);
    freq.put("Kop", 8);
    freq.put("Kos", 40);
    freq.put("Kor", 16);
    freq.put("Kov", 13);
    freq.put("m ", 7887);
    freq.put("nđe", 8);
    freq.put("mC", 9);
    freq.put("mB", 7);
    freq.put("Ko ", 40);
    freq.put("mO", 9);
    freq.put("mN", 7);
    freq.put("mI", 8);
    freq.put("mH", 8);
    freq.put("mK", 10);
    freq.put("mJ", 10);
    freq.put("mU", 8);
    freq.put("mV", 8);
    freq.put("mS", 9);
    freq.put("mX", 9);
    freq.put("me", 2681);
    freq.put("md", 17);
    freq.put("mg", 22);
    freq.put("mf", 32);
    freq.put("ma", 4305);
    freq.put("ltu", 24);
    freq.put("mc", 52);
    freq.put("mb", 105);
    freq.put("mm", 95);
    freq.put("ml", 188);
    freq.put("mo", 3424);
    freq.put("mn", 242);
    freq.put("mi", 2729);
    freq.put("mh", 8);
    freq.put("mk", 52);
    freq.put("mj", 144);
    freq.put("mu", 682);
    freq.put("mt", 42);
    freq.put("mw", 11);
    freq.put("mv", 12);
    freq.put("mq", 9);
    freq.put("mp", 229);
    freq.put("ms", 90);
    freq.put("mr", 270);
    freq.put("zmu", 12);
    freq.put("my", 30);
    freq.put("mx", 9);
    freq.put("mz", 14);
    freq.put("ena", 541);
    freq.put("enc", 58);
    freq.put("end", 152);
    freq.put("ene", 449);
    freq.put("eng", 51);
    freq.put("eni", 639);
    freq.put("enj", 326);
    freq.put("enk", 35);
    freq.put("enn", 22);
    freq.put("eno", 308);
    freq.put("ens", 86);
    freq.put("ent", 296);
    freq.put("enu", 163);
    freq.put("enz", 26);
    freq.put("kuš", 12);
    freq.put("ON ", 15);
    freq.put("uđe", 28);
    freq.put("II ", 15);
    freq.put("kuć", 53);
    freq.put("en ", 343);
    freq.put(" Hr", 93);
    freq.put(" Hv", 31);
    freq.put(" Hu", 13);
    freq.put(" Hi", 29);
    freq.put(" Ho", 59);
    freq.put(" Hl", 13);
    freq.put(" Ha", 123);
    freq.put(" He", 44);
    freq.put("ima", 1206);
    freq.put("imb", 8);
    freq.put("ime", 158);
    freq.put("če ", 106);
    freq.put("imi", 79);
    freq.put("cle", 8);
    freq.put("imk", 11);
    freq.put("imj", 7);
    freq.put("imm", 7);
    freq.put("iml", 47);
    freq.put("imo", 232);
    freq.put("imn", 28);
    freq.put("imp", 35);
    freq.put("imu", 33);
    freq.put("JA ", 135);
    freq.put("SA ", 33);
    freq.put("toč", 13);
    freq.put(" H ", 32);
    freq.put("im ", 1840);
    freq.put("čeg", 8);
    freq.put("čem", 29);
    freq.put("čel", 31);
    freq.put("čeo", 10);
    freq.put("čen", 52);
    freq.put("ček", 95);
    freq.put("čet", 49);
    freq.put("čev", 19);
    freq.put("čes", 21);
    freq.put("čer", 68);
    freq.put("šne", 9);
    freq.put("raš", 85);
    freq.put("šno", 23);
    freq.put("šni", 16);
    freq.put("šnj", 51);
    freq.put("bra", 315);
    freq.put("raž", 71);
    freq.put("gom", 70);
    freq.put("gol", 61);
    freq.put("Vi ", 14);
    freq.put("gon", 16);
    freq.put("goj", 22);
    freq.put("ajp", 19);
    freq.put("god", 378);
    freq.put("ajr", 11);
    freq.put("ajs", 33);
    freq.put("ajt", 133);
    freq.put("aju", 564);
    freq.put("ajv", 85);
    freq.put("aji", 73);
    freq.put("ajj", 30);
    freq.put("ajk", 120);
    freq.put("ajl", 72);
    freq.put("ajm", 55);
    freq.put("ajn", 146);
    freq.put("ajo", 19);
    freq.put("got", 46);
    freq.put("ajb", 101);
    freq.put("gov", 330);
    freq.put("ajd", 76);
    freq.put("aje", 374);
    freq.put("gos", 63);
    freq.put("gor", 225);
    freq.put("W", 357);
    freq.put("rać", 31);
    freq.put("Vid", 39);
    freq.put("Vik", 16);
    freq.put("rač", 52);
    freq.put("Vin", 9);
    freq.put("go ", 450);
    freq.put("Vil", 8);
    freq.put("Vir", 8);
    freq.put("DU ", 9);
    freq.put("Vit", 9);
    freq.put("rađ", 30);
    freq.put("aj ", 572);
    freq.put("be ", 356);
    freq.put("nha", 7);
    freq.put("nir", 57);
    freq.put("tor", 230);
    freq.put("tos", 29);
    freq.put("top", 97);
    freq.put("tov", 229);
    freq.put("EU ", 20);
    freq.put("tot", 33);
    freq.put("toj", 172);
    freq.put("tok", 79);
    freq.put("toi", 11);
    freq.put("ton", 101);
    freq.put("too", 15);
    freq.put("tol", 120);
    freq.put("tom", 181);
    freq.put("tob", 50);
    freq.put("toc", 19);
    freq.put("toa", 28);
    freq.put("tog", 116);
    freq.put("tod", 11);
    freq.put("češ", 11);
    freq.put("ace", 158);
    freq.put("to ", 2215);
    freq.put("raf", 48);
    freq.put("rag", 135);
    freq.put("rad", 668);
    freq.put("rae", 14);
    freq.put("rab", 51);
    freq.put("rac", 234);
    freq.put("raa", 22);
    freq.put("ran", 780);
    freq.put("rao", 82);
    freq.put("ral", 163);
    freq.put("ram", 343);
    freq.put("raj", 297);
    freq.put("rak", 152);
    freq.put("rah", 39);
    freq.put("rai", 10);
    freq.put("rav", 683);
    freq.put("raw", 7);
    freq.put("rat", 528);
    freq.put("rau", 17);
    freq.put("rar", 8);
    freq.put("ras", 362);
    freq.put("rap", 43);
    freq.put("raz", 437);
    freq.put("ray", 7);
    freq.put("raJ", 7);
    freq.put("iHo", 12);
    freq.put("ra ", 1027);
    freq.put("Viš", 11);
    freq.put("žrt", 8);
    freq.put("AS ", 29);
    freq.put("iH ", 21);
    freq.put("BiH", 21);
    freq.put("pka", 18);
    freq.put("pko", 8);
    freq.put("oci", 151);
    freq.put("Bio", 11);
    freq.put("Bil", 27);
    freq.put("ocj", 8);
    freq.put("oco", 11);
    freq.put("ocn", 38);
    freq.put("oca", 59);
    freq.put("Big", 9);
    freq.put("Bib", 7);
    freq.put("Bic", 8);
    freq.put("Bit", 24);
    freq.put("ocu", 35);
    freq.put("Bis", 9);
    freq.put("Aaa", 8);
    freq.put("oc ", 50);
    freq.put("Pet", 30);
    freq.put("nut", 144);
    freq.put("nur", 7);
    freq.put("nus", 7);
    freq.put("Per", 41);
    freq.put("Pel", 8);
    freq.put("nuo", 41);
    freq.put("nul", 57);
    freq.put("num", 7);
    freq.put("nuj", 8);
    freq.put("nuk", 13);
    freq.put("Pej", 7);
    freq.put("Pek", 7);
    freq.put("Ped", 7);
    freq.put("Pef", 7);
    freq.put("mut", 9);
    freq.put("muv", 13);
    freq.put("mus", 60);
    freq.put("mur", 13);
    freq.put("muz", 64);
    freq.put("mud", 14);
    freq.put("mum", 8);
    freq.put("mul", 11);
    freq.put("mun", 47);
    freq.put("muk", 18);
    freq.put("zbe", 36);
    freq.put("zba", 35);
    freq.put("zbo", 175);
    freq.put("zbl", 7);
    freq.put("zbi", 63);
    freq.put("zbu", 30);
    freq.put("zbr", 18);
    freq.put("nu ", 565);
    freq.put("mu ", 344);
    freq.put(" me", 1101);
    freq.put(" ma", 1072);
    freq.put(" mb", 9);
    freq.put(" mc", 15);
    freq.put(" ml", 59);
    freq.put(" mm", 10);
    freq.put(" mn", 128);
    freq.put(" mo", 1486);
    freq.put(" mi", 1711);
    freq.put(" mj", 62);
    freq.put(" mk", 8);
    freq.put(" mu", 354);
    freq.put("xx ", 11);
    freq.put(" mp", 26);
    freq.put(" mr", 132);
    freq.put(" ms", 9);
    freq.put(" my", 7);
    freq.put(" m ", 86);
    freq.put("xxx", 12);
    freq.put("Crn", 55);
    freq.put("TV ", 25);
    freq.put("n", 32787);
    freq.put("nMi", 7);
    freq.put("▀", 30);
    freq.put(" ef", 8);
    freq.put("Ć ", 13);
    freq.put("Tra", 28);
    freq.put("muš", 31);
    freq.put("elj", 346);
    freq.put("elk", 10);
    freq.put("eli", 423);
    freq.put("eln", 32);
    freq.put("elo", 174);
    freq.put("ell", 57);
    freq.put("elc", 10);
    freq.put("ela", 312);
    freq.put("eld", 9);
    freq.put("ele", 281);
    freq.put("ely", 15);
    freq.put("nMa", 11);
    freq.put("els", 20);
    freq.put("elu", 62);
    freq.put("D", 2313);
    freq.put("IO ", 28);
    freq.put("el ", 201);
    freq.put("icN", 11);
    freq.put("icM", 8);
    freq.put(" Ju", 80);
    freq.put("dži", 14);
    freq.put(" Jo", 173);
    freq.put(" Ji", 10);
    freq.put(" Je", 331);
    freq.put(" Ja", 336);
    freq.put("ick", 101);
    freq.put("ici", 368);
    freq.put("ich", 87);
    freq.put("ico", 52);
    freq.put("icn", 70);
    freq.put("Hr", 103);
    freq.put("nš", 13);
    freq.put("Hp", 8);
    freq.put("Hv", 37);
    freq.put("ice", 399);
    freq.put("Hu", 16);
    freq.put("Hh", 12);
    freq.put("Hi", 43);
    freq.put("Ho", 80);
    freq.put("Hl", 19);
    freq.put("cna", 35);
    freq.put("icr", 8);
    freq.put("Ha", 144);
    freq.put("tiš", 46);
    freq.put("Hd", 8);
    freq.put("He", 51);
    freq.put("nč", 39);
    freq.put("hsi", 9);
    freq.put("SC ", 10);
    freq.put("tič", 74);
    freq.put("nđ", 10);
    freq.put("tić", 37);
    freq.put(" J ", 19);
    freq.put("ic ", 607);
    freq.put("H ", 165);
    freq.put("šlo", 30);
    freq.put("aha", 408);
    freq.put("šlj", 49);
    freq.put("ppe", 9);
    freq.put("šli", 21);
    freq.put("ahh", 31);
    freq.put("šle", 8);
    freq.put("ahn", 11);
    freq.put("aho", 9);
    freq.put("šla", 29);
    freq.put("ahr", 86);
    freq.put("ahv", 14);
    freq.put("aht", 15);
    freq.put("ahu", 10);
    freq.put("ppy", 14);
    freq.put("git", 12);
    freq.put("gis", 9);
    freq.put("gir", 20);
    freq.put("gip", 11);
    freq.put("gie", 13);
    freq.put("IĆ ", 12);
    freq.put("AD ", 71);
    freq.put("gio", 9);
    freq.put("gin", 36);
    freq.put("gim", 24);
    freq.put("gil", 8);
    freq.put("gik", 7);
    freq.put("gij", 46);
    freq.put("gih", 11);
    freq.put("ah ", 126);
    freq.put("pp ", 12);
    freq.put("Vod", 10);
    freq.put("Vol", 47);
    freq.put("Voj", 8);
    freq.put("gi ", 127);
    freq.put("nH", 8);
    freq.put("nnn", 11);
    freq.put("nJ", 9);
    freq.put("nL", 14);
    freq.put("nM", 23);
    freq.put("nN", 7);
    freq.put("nO", 10);
    freq.put("nA", 13);
    freq.put("nB", 17);
    freq.put("nC", 10);
    freq.put("nD", 14);
    freq.put("nF", 8);
    freq.put("nG", 12);
    freq.put("nX", 9);
    freq.put("icS", 9);
    freq.put("nny", 26);
    freq.put("nP", 30);
    freq.put("nS", 20);
    freq.put("nT", 7);
    freq.put("nU", 10);
    freq.put("nV", 16);
    freq.put("nh", 25);
    freq.put("ni", 4938);
    freq.put("nj", 2253);
    freq.put("nk", 417);
    freq.put("nl", 130);
    freq.put("nm", 18);
    freq.put("nn", 147);
    freq.put("no", 3845);
    freq.put("tit", 176);
    freq.put("na", 8008);
    freq.put("nb", 31);
    freq.put("nc", 395);
    freq.put("nd", 773);
    freq.put("ne", 5905);
    freq.put("nf", 68);
    freq.put("ng", 417);
    freq.put("nx", 10);
    freq.put("ny", 64);
    freq.put("nz", 77);
    freq.put("tio", 115);
    freq.put("tih", 41);
    freq.put("tii", 10);
    freq.put("tij", 65);
    freq.put("ES ", 20);
    freq.put("np", 22);
    freq.put("nq", 60);
    freq.put("nr", 21);
    freq.put("ns", 470);
    freq.put("nt", 735);
    freq.put("nu", 942);
    freq.put("nv", 26);
    freq.put("nw", 12);
    freq.put("tiž", 13);
    freq.put("nn ", 17);
    freq.put("cnu", 11);
    freq.put("n ", 2464);
    freq.put("icc", 12);
    freq.put("ti ", 2000);
    freq.put("ica", 729);
    freq.put("džu", 8);
    freq.put("roi", 40);
    freq.put("roj", 112);
    freq.put("rok", 54);
    freq.put("rol", 109);
    freq.put("rom", 200);
    freq.put("ron", 84);
    freq.put("roo", 16);
    freq.put("Ps", 10);
    freq.put("roa", 26);
    freq.put("rob", 199);
    freq.put("roc", 50);
    freq.put("rod", 327);
    freq.put("roe", 11);
    freq.put("rof", 73);
    freq.put("rog", 96);
    freq.put("dže", 17);
    freq.put("roz", 97);
    freq.put("llo", 27);
    freq.put("lll", 8);
    freq.put("rop", 114);
    freq.put("ror", 17);
    freq.put("ros", 217);
    freq.put("rot", 110);
    freq.put("rou", 12);
    freq.put("rov", 287);
    freq.put("row", 8);
    freq.put("Dac", 9);
    freq.put("Dal", 13);
    freq.put("Dam", 13);
    freq.put("Dan", 111);
    freq.put("Daj", 12);
    freq.put("Dak", 7);
    freq.put("Dav", 17);
    freq.put("cne", 20);
    freq.put("Dar", 11);
    freq.put(" dn", 34);
    freq.put("Cik", 7);
    freq.put("Cij", 10);
    freq.put("tw ", 21);
    freq.put("cno", 66);
    freq.put("ll ", 57);
    freq.put("kla", 148);
    freq.put("Da ", 120);
    freq.put("jde", 63);
    freq.put("icu", 171);
    freq.put("ict", 19);
    freq.put(" dd", 8);
    freq.put("Res", 8);
    freq.put("Rep", 11);
    freq.put("ngS", 26);
    freq.put("Rek", 7);
    freq.put("aKo", 15);
    freq.put("klj", 63);
    freq.put("Rec", 8);
    freq.put("aKa", 12);
    freq.put("Rea", 27);
    freq.put("Red", 12);
    freq.put("Que", 8);
    freq.put("Age", 8);
    freq.put("jdu", 18);
    freq.put("pm ", 7);
    freq.put(" oč", 63);
    freq.put("roš", 55);
    freq.put("q ", 129);
    freq.put("msk", 23);
    freq.put("msi", 20);
    freq.put("Evo", 54);
    freq.put("Dač", 8);
    freq.put("Eve", 7);
    freq.put("Evr", 36);
    freq.put("yja", 22);
    freq.put("roč", 18);
    freq.put("rođ", 30);
    freq.put("ms ", 11);
    freq.put(" on", 748);
    freq.put("Mih", 12);
    freq.put("Mik", 13);
    freq.put(" om", 49);
    freq.put(" oj", 10);
    freq.put(" ok", 181);
    freq.put(" oh", 26);
    freq.put("Min", 34);
    freq.put(" of", 44);
    freq.put("█", 7);
    freq.put("Mic", 23);
    freq.put(" ob", 334);
    freq.put(" oc", 84);
    freq.put(" oz", 35);
    freq.put(" ov", 744);
    freq.put("Mis", 66);
    freq.put("Mir", 25);
    freq.put(" or", 91);
    freq.put("Mit", 8);
    freq.put(" op", 261);
    freq.put("Mi ", 18);
    freq.put("ky ", 12);
    freq.put(" o ", 308);
    freq.put("Ziv", 20);
    freq.put("Fan", 7);
    freq.put("vti", 9);
    freq.put("ahe", 7);
    freq.put("HR ", 13);
    freq.put("ahi", 20);
    freq.put("qr", 12);
    freq.put("ng ", 137);
    freq.put("qt", 35);
    freq.put(" wa", 21);
    freq.put("čaš", 11);
    freq.put(" wo", 16);
    freq.put(" ca", 127);
    freq.put("mim", 40);
    freq.put("EN ", 9);
    freq.put("ejo", 9);
    freq.put("eji", 19);
    freq.put("ejk", 12);
    freq.put("ejd", 15);
    freq.put("eje", 55);
    freq.put("eja", 64);
    freq.put(" wu", 8);
    freq.put("ejz", 29);
    freq.put("ejt", 30);
    freq.put("eju", 26);
    freq.put("ejv", 45);
    freq.put("ejs", 51);
    freq.put("uču", 10);
    freq.put("uče", 72);
    freq.put("uča", 56);
    freq.put("sTr", 12);
    freq.put("učn", 20);
    freq.put("uči", 95);
    freq.put("qj", 9);
    freq.put("anč", 14);
    freq.put("ej ", 53);
    freq.put("ž", 1432);
    freq.put("hu ", 30);
    freq.put("iam", 15);
    freq.put("ial", 22);
    freq.put("ian", 38);
    freq.put("iak", 16);
    freq.put("ča ", 51);
    freq.put("gic", 28);
    freq.put("hua", 8);
    freq.put("hul", 9);
    freq.put("hum", 16);
    freq.put("hun", 15);
    freq.put("SE ", 147);
    freq.put("čas", 22);
    freq.put("čar", 48);
    freq.put("čat", 8);
    freq.put("čav", 12);
    freq.put("ia ", 217);
    freq.put("r", 25223);
    freq.put("čak", 43);
    freq.put("čaj", 49);
    freq.put("čam", 24);
    freq.put("čal", 17);
    freq.put("čan", 54);
    freq.put("and", 259);
    freq.put("ane", 251);
    freq.put("ang", 62);
    freq.put("pra", 578);
    freq.put("ana", 951);
    freq.put("anb", 7);
    freq.put("anc", 140);
    freq.put("ann", 50);
    freq.put("ano", 308);
    freq.put("pri", 591);
    freq.put("ani", 739);
    freq.put("anj", 939);
    freq.put("ank", 205);
    freq.put("fc ", 7);
    freq.put("anu", 127);
    freq.put("prv", 161);
    freq.put("prs", 19);
    freq.put("ans", 158);
    freq.put("anz", 21);
    freq.put("anD", 7);
    freq.put("anB", 7);
    freq.put(" L ", 32);
    freq.put("anM", 10);
    freq.put("GO ", 16);
    freq.put("anV", 10);
    freq.put("е", 11);
    freq.put("anS", 10);
    freq.put("AJ ", 39);
    freq.put("an ", 1154);
    freq.put("pr ", 12);
    freq.put(" Le", 63);
    freq.put(" La", 111);
    freq.put(" Lo", 55);
    freq.put(" Lj", 77);
    freq.put(" Li", 85);
    freq.put(" Lu", 66);
    freq.put("gk ", 8);
    freq.put("pož", 18);
    freq.put("tke", 36);
    freq.put("tka", 93);
    freq.put("tko", 123);
    freq.put("tki", 41);
    freq.put("tku", 22);
    freq.put("tkr", 34);
    freq.put("nli", 103);
    freq.put("dy ", 14);
    freq.put("ss ", 61);
    freq.put("poš", 45);
    freq.put("H", 838);
    freq.put("sss", 11);
    freq.put("ssi", 31);
    freq.put("sse", 7);
    freq.put("ssa", 11);
    freq.put("ssS", 11);
    freq.put("ssO", 8);
    freq.put("poč", 67);
    freq.put("Src", 7);
    freq.put("lnu", 7);
    freq.put("lno", 165);
    freq.put("rma", 107);
    freq.put("lni", 103);
    freq.put("rme", 23);
    freq.put("lne", 24);
    freq.put("jot", 16);
    freq.put("rmi", 41);
    freq.put("lna", 48);
    freq.put("rmo", 17);
    freq.put("rml", 11);
    freq.put("rm ", 9);
    freq.put("niš", 77);
    freq.put("nno", 12);
    freq.put("poz", 243);
    freq.put("pov", 154);
    freq.put("pot", 188);
    freq.put("por", 325);
    freq.put("pos", 596);
    freq.put("pop", 132);
    freq.put("pon", 173);
    freq.put("pol", 345);
    freq.put("pom", 133);
    freq.put("poj", 83);
    freq.put("pok", 150);
    freq.put("poh", 9);
    freq.put("poi", 8);
    freq.put("pog", 131);
    freq.put("pod", 239);
    freq.put("poe", 25);
    freq.put("pob", 81);
    freq.put("poc", 87);
    freq.put("nni", 16);
    freq.put("Bur", 8);
    freq.put("Bul", 11);
    freq.put("nne", 15);
    freq.put("Bud", 20);
    freq.put("nna", 40);
    freq.put("po ", 338);
    freq.put("Nje", 19);
    freq.put("oks", 22);
    freq.put("oku", 86);
    freq.put("okt", 35);
    freq.put("ođu", 9);
    freq.put("uha", 20);
    freq.put("ođe", 76);
    freq.put("ođa", 10);
    freq.put("I ", 1015);
    freq.put("Ubi", 16);
    freq.put("ođi", 9);
    freq.put("uhi", 16);
    freq.put("Eto", 16);
    freq.put("Iy", 8);
    freq.put("uhv", 9);
    freq.put("Iz", 88);
    freq.put("tiz", 40);
    freq.put("Ip", 16);
    freq.put("Is", 74);
    freq.put("Ir", 51);
    freq.put("It", 9);
    freq.put("Iv", 117);
    freq.put("Ij", 10);
    freq.put("Im", 114);
    freq.put("Il", 37);
    freq.put("Io", 8);
    freq.put("In", 72);
    freq.put("Ia", 12);
    freq.put("oke", 55);
    freq.put("Ic", 7);
    freq.put("Ib", 10);
    freq.put("Id", 46);
    freq.put("Ig", 45);
    freq.put(" qu", 12);
    freq.put("tip", 41);
    freq.put("oki", 59);
    freq.put("tir", 66);
    freq.put(" qk", 8);
    freq.put("til", 111);
    freq.put("juć", 20);
    freq.put("tim", 295);
    freq.put("tin", 255);
    freq.put("juč", 49);
    freq.put("tik", 197);
    freq.put(" q ", 15);
    freq.put("tid", 8);
    freq.put("tie", 8);
    freq.put("tif", 11);
    freq.put("Pij", 10);
    freq.put("tig", 56);
    freq.put("Pin", 15);
    freq.put("tia", 25);
    freq.put("tic", 184);
    freq.put("Pit", 18);
    freq.put("Kuv", 8);
    freq.put("Kur", 18);
    freq.put("Kup", 8);
    freq.put("alt", 16);
    freq.put("Kul", 9);
    freq.put("Kuc", 8);
    freq.put("o ", 15642);
    freq.put("oO", 10);
    freq.put("oN", 18);
    freq.put("oM", 18);
    freq.put("oL", 13);
    freq.put("oK", 11);
    freq.put("oJ", 19);
    freq.put("oI", 9);
    freq.put("oH", 8);
    freq.put("oG", 25);
    freq.put("oD", 13);
    freq.put("oC", 16);
    freq.put("oB", 14);
    freq.put("oA", 14);
    freq.put("oZ", 10);
    freq.put("uTu", 31);
    freq.put("oW", 7);
    freq.put("oT", 10);
    freq.put("oS", 7);
    freq.put("oR", 14);
    freq.put("oP", 12);
    freq.put("oo", 497);
    freq.put("on", 2453);
    freq.put("om", 2333);
    freq.put("ol", 2471);
    freq.put("ok", 1091);
    freq.put("oj", 2615);
    freq.put("oi", 188);
    freq.put("oh", 134);
    freq.put("og", 2121);
    freq.put("of", 187);
    freq.put("oe", 91);
    freq.put("od", 2895);
    freq.put("oc", 582);
    freq.put("ob", 1554);
    freq.put("oa", 103);
    freq.put("oz", 866);
    freq.put("oy", 41);
    freq.put("ox", 31);
    freq.put("ow", 106);
    freq.put("ov", 3624);
    freq.put("ou", 300);
    freq.put("ot", 1343);
    freq.put("os", 2714);
    freq.put("or", 2667);
    freq.put("oq", 19);
    freq.put("op", 926);
    freq.put("LE ", 18);
    freq.put("ju ", 1265);
    freq.put("FB ", 13);
    freq.put("ehu", 7);
    freq.put("vsk", 57);
    freq.put("EL ", 13);
    freq.put("ehe", 39);
    freq.put("eha", 31);
    freq.put("ehn", 10);
    freq.put("eho", 8);
    freq.put("jub", 274);
    freq.put("juc", 53);
    freq.put("jug", 23);
    freq.put("jud", 311);
    freq.put("juj", 47);
    freq.put("jun", 55);
    freq.put("jum", 25);
    freq.put("jur", 26);
    freq.put("jus", 28);
    freq.put("jup", 7);
    freq.put("juv", 7);
    freq.put("jut", 163);
    freq.put("juz", 8);
    freq.put("eh ", 56);
    freq.put("rva", 201);
    freq.put("rve", 71);
    freq.put("oć", 171);
    freq.put("rvi", 137);
    freq.put("rvo", 82);
    freq.put("rvn", 15);
    freq.put("Jam", 9);
    freq.put("rvu", 14);
    freq.put("ođ", 104);
    freq.put("igu", 92);
    freq.put("igr", 130);
    freq.put("IC ", 11);
    freq.put("ige", 39);
    freq.put("igd", 9);
    freq.put("iga", 136);
    freq.put("igo", 16);
    freq.put("ign", 53);
    freq.put("igl", 34);
    freq.put("igi", 26);
    freq.put("igh", 44);
    freq.put("cb ", 9);
    freq.put("rv ", 13);
    freq.put("čov", 41);
    freq.put("oš", 352);
    freq.put("čok", 17);
    freq.put("ož", 298);
    freq.put("ig ", 8);
    freq.put("aln", 252);
    freq.put("alo", 384);
    freq.put("all", 35);
    freq.put("alm", 23);
    freq.put("alj", 313);
    freq.put("alk", 112);
    freq.put("pti", 19);
    freq.put("ali", 903);
    freq.put("alg", 36);
    freq.put("ald", 28);
    freq.put("ale", 272);
    freq.put("alb", 26);
    freq.put("alc", 13);
    freq.put("pta", 10);
    freq.put("ala", 731);
    freq.put("fa ", 31);
    freq.put("alu", 70);
    freq.put("als", 13);
    freq.put(" N ", 15);
    freq.put("lls", 9);
    freq.put("faz", 22);
    freq.put("far", 21);
    freq.put("fas", 8);
    freq.put("fav", 24);
    freq.put("al ", 270);
    freq.put("pt ", 11);
    freq.put("fak", 28);
    freq.put("fai", 10);
    freq.put("fan", 71);
    freq.put("llu", 9);
    freq.put("fal", 26);
    freq.put("fac", 33);
    freq.put(" Ni", 324);
    freq.put(" Nj", 30);
    freq.put(" No", 155);
    freq.put(" Na", 294);
    freq.put(" Ne", 525);
    freq.put("lli", 16);
    freq.put("dža", 12);
    freq.put(" Nu", 10);
    freq.put("teh", 19);
    freq.put("tei", 10);
    freq.put("tek", 99);
    freq.put("tel", 330);
    freq.put("tem", 70);
    freq.put("ten", 134);
    freq.put("teo", 21);
    freq.put("tea", 20);
    freq.put("teb", 127);
    freq.put("tec", 12);
    freq.put("ted", 37);
    freq.put("tee", 14);
    freq.put("tef", 31);
    freq.put("teg", 15);
    freq.put("tex", 8);
    freq.put("tez", 26);
    freq.put("nbo", 13);
    freq.put("tep", 18);
    freq.put("ter", 607);
    freq.put("tes", 67);
    freq.put("tet", 100);
    freq.put("lla", 39);
    freq.put("tev", 27);
    freq.put("sug", 8);
    freq.put("suf", 7);
    freq.put("sud", 73);
    freq.put("sub", 36);
    freq.put("sua", 15);
    freq.put("sun", 49);
    freq.put("sum", 60);
    freq.put("sul", 15);
    freq.put("suk", 17);
    freq.put("suj", 36);
    freq.put("suv", 15);
    freq.put("sut", 102);
    freq.put("sus", 54);
    freq.put("sur", 21);
    freq.put("sup", 78);
    freq.put("suz", 33);
    freq.put("kše", 10);
    freq.put("te ", 1753);
    freq.put("išn", 24);
    freq.put("su ", 801);
    freq.put("žić", 10);
    freq.put("rku", 38);
    freq.put("rkv", 18);
    freq.put("rke", 37);
    freq.put("vož", 7);
    freq.put("rka", 116);
    freq.put("Tol", 11);
    freq.put("Tom", 30);
    freq.put("rkl", 7);
    freq.put("rko", 136);
    freq.put("rki", 26);
    freq.put("ĆU ", 27);
    freq.put("ToA", 7);
    freq.put("rk ", 22);
    freq.put("To ", 54);
    freq.put("mne", 13);
    freq.put("upo", 85);
    freq.put("Int", 23);
    freq.put("Ins", 12);
    freq.put("v", 17766);
    freq.put("Ind", 7);
    freq.put("Ina", 15);
    freq.put("teš", 26);
    freq.put("zja", 24);
    freq.put("tež", 15);
    freq.put("ro ", 357);
    freq.put("oya", 7);
    freq.put("jao", 42);
    freq.put("Gla", 18);
    freq.put("Gle", 15);
    freq.put("Ako", 110);
    freq.put("suđ", 8);
    freq.put("Glu", 11);
    freq.put("lha", 10);
    freq.put("oy ", 16);
    freq.put("ću", 292);
    freq.put("yn ", 9);
    freq.put("će", 594);
    freq.put("ća", 278);
    freq.put("ćo", 13);
    freq.put("ćn", 48);
    freq.put("ći", 244);
    freq.put("L", 954);
    freq.put("Rad", 52);
    freq.put("Ran", 9);
    freq.put("Rak", 16);
    freq.put("Ras", 25);
    freq.put("ć ", 445);
    freq.put("Raz", 32);
    freq.put(" sy", 12);
    freq.put("Mus", 12);
    freq.put(" sr", 400);
    freq.put(" ss", 7);
    freq.put(" sp", 328);
    freq.put(" sq", 8);
    freq.put(" sv", 1294);
    freq.put(" sw", 7);
    freq.put(" st", 1566);
    freq.put(" su", 1034);
    freq.put(" sj", 74);
    freq.put(" sk", 313);
    freq.put(" sh", 141);
    freq.put(" si", 712);
    freq.put(" sn", 115);
    freq.put(" so", 187);
    freq.put(" sl", 540);
    freq.put(" sm", 497);
    freq.put(" sc", 33);
    freq.put(" sa", 3077);
    freq.put(" sd", 10);
    freq.put(" se", 2838);
    freq.put("iza", 196);
    freq.put("izb", 112);
    freq.put("izd", 84);
    freq.put("ize", 34);
    freq.put("izg", 114);
    freq.put("izi", 125);
    freq.put("izj", 19);
    freq.put("izl", 55);
    freq.put("izm", 66);
    freq.put("izn", 79);
    freq.put("izo", 44);
    freq.put("izr", 25);
    freq.put("izu", 69);
    freq.put("izv", 95);
    freq.put("izz", 19);
    freq.put(" sE", 7);
    freq.put(" el", 29);
    freq.put(" em", 65);
    freq.put(" en", 60);
    freq.put(" eh", 8);
    freq.put(" s ", 241);
    freq.put("iz ", 372);
    freq.put(" ej", 7);
    freq.put(" ek", 63);
    freq.put("Živ", 16);
    freq.put("oži", 31);
    freq.put("ožn", 11);
    freq.put("oža", 21);
    freq.put("X ", 75);
    freq.put("ožd", 46);
    freq.put("ože", 174);
    freq.put("kob", 15);
    freq.put(" ea", 8);
    freq.put("kog", 262);
    freq.put("še ", 248);
    freq.put("kop", 66);
    freq.put("kos", 103);
    freq.put("kou", 11);
    freq.put("kov", 261);
    freq.put(" ću", 112);
    freq.put("js ", 7);
    freq.put(" će", 218);
    freq.put("Zaš", 21);
    freq.put(" ći", 10);
    freq.put("eft", 12);
    freq.put("efi", 21);
    freq.put("efo", 63);
    freq.put("efa", 34);
    freq.put("efe", 12);
    freq.put("jsa", 13);
    freq.put("jsb", 12);
    freq.put("jsk", 74);
    freq.put("jst", 32);
    freq.put("jsu", 21);
    freq.put("UC ", 7);
    freq.put("Zen", 15);
    freq.put("Zel", 8);
    freq.put("Zem", 11);
    freq.put("ef ", 16);
    freq.put("rte", 28);
    freq.put("rta", 104);
    freq.put("rtm", 36);
    freq.put("rto", 24);
    freq.put("rtn", 10);
    freq.put("rti", 96);
    freq.put("hi ", 38);
    freq.put("rtv", 15);
    freq.put("rts", 7);
    freq.put("rty", 31);
    freq.put("Jz", 8);
    freq.put("Ju", 93);
    freq.put("ies", 12);
    freq.put("ier", 21);
    freq.put("iet", 13);
    freq.put("iev", 12);
    freq.put("Jm", 8);
    freq.put("Jn", 7);
    freq.put("Jo", 204);
    freq.put("iel", 19);
    freq.put("duž", 17);
    freq.put("Jk", 7);
    freq.put("Je", 346);
    freq.put("Jg", 7);
    freq.put("Ja", 373);
    freq.put("Jb", 11);
    freq.put("hip", 21);
    freq.put("hir", 12);
    freq.put("his", 22);
    freq.put("hit", 55);
    freq.put("rt ", 97);
    freq.put("hiv", 8);
    freq.put("duć", 18);
    freq.put("hic", 16);
    freq.put("pć", 8);
    freq.put("hih", 9);
    freq.put("hij", 18);
    freq.put("hil", 24);
    freq.put("him", 20);
    freq.put("hin", 43);
    freq.put("DZ ", 7);
    freq.put("šev", 33);
    freq.put("ie ", 64);
    freq.put("J ", 151);
    freq.put("riž", 11);
    freq.put("arr", 21);
    freq.put("ars", 80);
    freq.put("art", 201);
    freq.put("aru", 84);
    freq.put("vUn", 7);
    freq.put("ary", 8);
    freq.put("ara", 624);
    freq.put("arb", 20);
    freq.put("arc", 82);
    freq.put("ard", 89);
    freq.put("are", 199);
    freq.put("arf", 10);
    freq.put("arg", 16);
    freq.put("arh", 56);
    freq.put("ari", 526);
    freq.put("ark", 151);
    freq.put("arl", 63);
    freq.put("arm", 46);
    freq.put("arn", 137);
    freq.put("riš", 53);
    freq.put(" P ", 64);
    freq.put("uuu", 48);
    freq.put("ar ", 436);
    freq.put(" Ps", 7);
    freq.put(" Pr", 350);
    freq.put("c", 11811);
    freq.put(" Pu", 45);
    freq.put(" Pa", 236);
    freq.put("rič", 92);
    freq.put(" Pe", 94);
    freq.put(" Pj", 9);
    freq.put(" Pi", 69);
    freq.put(" Ph", 8);
    freq.put(" Po", 336);
    freq.put(" xa", 8);
    freq.put(" Pl", 41);
    freq.put("pR", 7);
    freq.put("pP", 10);
    freq.put("pC", 12);
    freq.put("pF", 14);
    freq.put("pE", 7);
    freq.put("pJ", 10);
    freq.put("pH", 8);
    freq.put("Bk", 7);
    freq.put("pN", 8);
    freq.put("pO", 7);
    freq.put("pL", 9);
    freq.put("pM", 7);
    freq.put("pr", 3234);
    freq.put("ps", 304);
    freq.put("duj", 21);
    freq.put("duk", 28);
    freq.put("dul", 14);
    freq.put("dum", 9);
    freq.put("pt", 91);
    freq.put("pu", 735);
    freq.put("dua", 9);
    freq.put("dub", 23);
    freq.put("py", 28);
    freq.put("dug", 43);
    freq.put("pc", 69);
    freq.put("duz", 37);
    freq.put("pa", 1871);
    freq.put("pf", 16);
    freq.put("pg", 18);
    freq.put("pd", 20);
    freq.put("pe", 858);
    freq.put("dup", 28);
    freq.put("pk", 40);
    freq.put("dur", 8);
    freq.put("pi", 1242);
    freq.put("pn", 39);
    freq.put("po", 3596);
    freq.put("duv", 12);
    freq.put("pm", 19);
    freq.put("Fac", 11);
    freq.put("du ", 258);
    freq.put("p ", 2744);
    freq.put("riz", 96);
    freq.put("riv", 136);
    freq.put("rit", 171);
    freq.put("riu", 11);
    freq.put("rir", 50);
    freq.put("ris", 320);
    freq.put("rip", 70);
    freq.put("riq", 10);
    freq.put("rin", 177);
    freq.put("Tim", 8);
    freq.put("ril", 126);
    freq.put("rim", 197);
    freq.put("rij", 581);
    freq.put("rik", 62);
    freq.put("rih", 35);
    freq.put("rii", 9);
    freq.put("rif", 18);
    freq.put("rig", 31);
    freq.put("rid", 51);
    freq.put("rie", 26);
    freq.put("rib", 60);
    freq.put("ric", 303);
    freq.put("ria", 37);
    freq.put("aga", 114);
    freq.put("Cor", 7);
    freq.put("Ili", 25);
    freq.put("Ti ", 21);
    freq.put("ri ", 481);
    freq.put("Con", 13);
    freq.put("arč", 8);
    freq.put(" už", 29);
    freq.put("važ", 16);
    freq.put(" uš", 16);
    freq.put("lj ", 56);
    freq.put("Air", 7);
    freq.put("lji", 316);
    freq.put("ljk", 36);
    freq.put("ljo", 12);
    freq.put("ljn", 82);
    freq.put("lja", 529);
    freq.put("lje", 655);
    freq.put(" uđ", 12);
    freq.put(" uč", 50);
    freq.put("ljs", 15);
    freq.put("lju", 706);
    freq.put("vne", 46);
    freq.put("zz ", 14);
    freq.put("vna", 59);
    freq.put("zzz", 9);
    freq.put("zzu", 7);
    freq.put("vni", 139);
    freq.put("zza", 10);
    freq.put("aMi", 11);
    freq.put("Rom", 17);
    freq.put("Ron", 10);
    freq.put("aMa", 22);
    freq.put("Rob", 11);
    freq.put("Roc", 9);
    freq.put("aMe", 7);
    freq.put(" Kj", 7);
    freq.put("Ros", 15);
    freq.put("wn ", 7);
    freq.put(" uz", 157);
    freq.put(" ut", 116);
    freq.put(" uv", 156);
    freq.put(" up", 151);
    freq.put(" ur", 79);
    freq.put(" us", 265);
    freq.put(" ul", 92);
    freq.put(" um", 150);
    freq.put(" un", 66);
    freq.put(" uo", 47);
    freq.put(" uh", 22);
    freq.put(" uj", 42);
    freq.put(" uk", 79);
    freq.put(" ud", 92);
    freq.put(" ug", 62);
    freq.put(" ub", 108);
    freq.put(" uc", 77);
    freq.put(" u ", 2476);
    freq.put("ca ", 797);
    freq.put("ix ", 13);
    freq.put("z", 10132);
    freq.put("gru", 43);
    freq.put("tpu", 17);
    freq.put("gre", 153);
    freq.put("grc", 7);
    freq.put("gra", 445);
    freq.put("gro", 52);
    freq.put("grl", 26);
    freq.put("gri", 46);
    freq.put("gr ", 10);
    freq.put("edb", 16);
    freq.put("ojv", 12);
    freq.put("eda", 614);
    freq.put("Tho", 18);
    freq.put("ede", 254);
    freq.put("edj", 87);
    freq.put("ičk", 100);
    freq.put("edi", 296);
    freq.put("edn", 565);
    freq.put("edo", 133);
    freq.put("edl", 28);
    freq.put("edm", 15);
    freq.put("edr", 27);
    freq.put("eds", 75);
    freq.put("edv", 56);
    freq.put("edu", 77);
    freq.put("edz", 9);
    freq.put("ugo", 131);
    freq.put("FF ", 20);
    freq.put("ući", 50);
    freq.put("ućn", 17);
    freq.put("uća", 22);
    freq.put("uće", 51);
    freq.put("rča", 8);
    freq.put("rče", 9);
    freq.put("rči", 11);
    freq.put("uću", 10);
    freq.put("ič ", 8);
    freq.put("ed ", 238);
    freq.put("guš", 7);
    freq.put("sJu", 7);
    freq.put("P", 2059);
    freq.put("iba", 42);
    freq.put("rro", 10);
    freq.put("rri", 7);
    freq.put("đi ", 16);
    freq.put("ojn", 34);
    freq.put("taš", 21);
    freq.put("rry", 19);
    freq.put("ugr", 13);
    freq.put("rrr", 24);
    freq.put("čke", 27);
    freq.put("čka", 61);
    freq.put("čko", 50);
    freq.put("čki", 50);
    freq.put("rr ", 11);
    freq.put("čku", 22);
    freq.put("hki", 10);
    freq.put("sić", 17);
    freq.put("hko", 8);
    freq.put("hka", 18);
    freq.put("ibr", 21);
    freq.put("AK ", 18);
    freq.put("Un", 41);
    freq.put("tač", 24);
    freq.put(" oo", 14);
    freq.put("apr", 165);
    freq.put("aps", 26);
    freq.put("app", 28);
    freq.put(" ol", 23);
    freq.put("apt", 14);
    freq.put("apu", 48);
    freq.put("api", 164);
    freq.put("apo", 77);
    freq.put("apl", 24);
    freq.put("Ud", 10);
    freq.put("zde", 24);
    freq.put("apa", 153);
    freq.put("Mil", 104);
    freq.put("use", 61);
    freq.put("usa", 156);
    freq.put("fen", 13);
    freq.put("usn", 33);
    freq.put("usm", 7);
    freq.put("fem", 8);
    freq.put("fej", 86);
    freq.put("fek", 8);
    freq.put("usi", 90);
    freq.put("ush", 38);
    freq.put("usv", 11);
    freq.put("usu", 35);
    freq.put("vuk", 42);
    freq.put("fer", 46);
    freq.put("fes", 47);
    freq.put(" og", 49);
    freq.put(" od", 1213);
    freq.put("ap ", 24);
    freq.put(" Ru", 33);
    freq.put("fe ", 35);
    freq.put("us ", 139);
    freq.put(" Re", 100);
    freq.put(" Ra", 163);
    freq.put(" Ro", 83);
    freq.put(" Ri", 63);
    freq.put("tat", 192);
    freq.put("tav", 331);
    freq.put("tap", 15);
    freq.put("tar", 368);
    freq.put("tas", 55);
    freq.put("tay", 7);
    freq.put("taz", 16);
    freq.put("tad", 52);
    freq.put("tae", 7);
    freq.put("tag", 31);
    freq.put("taa", 9);
    freq.put("tab", 23);
    freq.put("tac", 81);
    freq.put("tal", 305);
    freq.put("tam", 302);
    freq.put("tan", 484);
    freq.put("tao", 64);
    freq.put("tah", 10);
    freq.put("tai", 11);
    freq.put("taj", 267);
    freq.put("tak", 480);
    freq.put("sis", 66);
    freq.put("sir", 56);
    freq.put("sip", 30);
    freq.put("siv", 26);
    freq.put("sit", 74);
    freq.put(" os", 464);
    freq.put("sic", 85);
    freq.put("sia", 7);
    freq.put("sig", 67);
    freq.put("sif", 7);
    freq.put("sie", 8);
    freq.put("sid", 15);
    freq.put("sij", 116);
    freq.put("taN", 7);
    freq.put("sih", 25);
    freq.put("sio", 64);
    freq.put("sin", 103);
    freq.put("sim", 149);
    freq.put("sil", 93);
    freq.put("ta ", 1534);
    freq.put("šte", 81);
    freq.put("šta", 253);
    freq.put("što", 457);
    freq.put("Š", 215);
    freq.put("štv", 27);
    freq.put("si ", 659);
    freq.put("usl", 31);
    freq.put("kve", 43);
    freq.put("cto", 9);
    freq.put("na ", 3910);
    freq.put("Car", 13);
    freq.put("Can", 10);
    freq.put("Pre", 112);
    freq.put("nfe", 9);
    freq.put("Pra", 29);
    freq.put("nfo", 43);
    freq.put("Pro", 125);
    freq.put("Pri", 72);
    freq.put("Prv", 20);
    freq.put("by ", 16);
    freq.put("▀▀▀", 26);
    freq.put("oun", 16);
    freq.put("oum", 8);
    freq.put("oul", 9);
    freq.put("ouc", 11);
    freq.put("oub", 8);
    freq.put("oud", 10);
    freq.put("Poč", 11);
    freq.put("ous", 27);
    freq.put("our", 26);
    freq.put("out", 73);
    freq.put("vca", 19);
    freq.put("vce", 19);
    freq.put("vci", 15);
    freq.put("lt ", 7);
    freq.put("vcu", 13);
    freq.put("ouT", 31);
    freq.put("ou ", 46);
    freq.put("g", 8262);
    freq.put("Tko", 11);
    freq.put("lta", 33);
    freq.put("lte", 21);
    freq.put("lto", 7);
    freq.put("če", 505);
    freq.put("K ", 172);
    freq.put("voJ", 7);
    freq.put("ses", 42);
    freq.put("Kb", 7);
    freq.put("Ka", 521);
    freq.put("Kg", 15);
    freq.put("Ke", 49);
    freq.put("Kj", 9);
    freq.put("Ki", 70);
    freq.put("Kh", 8);
    freq.put("Ko", 335);
    freq.put("Kn", 17);
    freq.put("Kl", 30);
    freq.put("Kr", 111);
    freq.put("Kv", 8);
    freq.put("Ku", 77);
    freq.put("Kz", 7);
    freq.put("seg", 19);
    freq.put("aSu", 8);
    freq.put("aSt", 8);
    freq.put("ybi", 7);
    freq.put("aSa", 15);
    freq.put("ybe", 12);
    freq.put("sem", 86);
    freq.put("IZ ", 12);
    freq.put("som", 42);
    freq.put("hp", 9);
    freq.put("Po ", 9);
    freq.put("wha", 8);
    freq.put("whi", 10);
    freq.put("hw", 10);
    freq.put("ht", 2491);
    freq.put("Poz", 31);
    freq.put("hk", 46);
    freq.put("Pov", 13);
    freq.put("Pot", 16);
    freq.put("Por", 21);
    freq.put("Pos", 58);
    freq.put("Pop", 21);
    freq.put("Pon", 22);
    freq.put("Pol", 29);
    freq.put("Pom", 9);
    freq.put("Poj", 9);
    freq.put("Pok", 19);
    freq.put("Pog", 43);
    freq.put("Pod", 12);
    freq.put("Pob", 9);
    freq.put(" zv", 114);
    freq.put("Cha", 11);
    freq.put("NI ", 60);
    freq.put("ha", 1059);
    freq.put(" w ", 15);
    freq.put("čić", 54);
    freq.put("eat", 30);
    freq.put("đu ", 37);
    freq.put("qP", 7);
    freq.put("qS", 7);
    freq.put("čiš", 8);
    freq.put("no ", 1596);
    freq.put("Juč", 7);
    freq.put("qA", 8);
    freq.put("qG", 7);
    freq.put("qH", 7);
    freq.put("qJ", 9);
    freq.put("qq", 8);
    freq.put("qs", 7);
    freq.put(" we", 18);
    freq.put("qu", 54);
    freq.put(" wc", 18);
    freq.put("Jao", 20);
    freq.put("qx", 7);
    freq.put("qz", 8);
    freq.put(" wh", 24);
    freq.put(" wi", 33);
    freq.put("qa", 11);
    freq.put(" ww", 33);
    freq.put("qc", 7);
    freq.put("đub", 8);
    freq.put("qe", 10);
    freq.put("qg", 8);
    freq.put("qi", 13);
    freq.put("qh", 14);
    freq.put("qk", 38);
    freq.put("đuj", 14);
    freq.put("qm", 36);
    freq.put("ql", 9);
    freq.put("Jak", 8);
    freq.put("ebe", 288);
    freq.put("eba", 393);
    freq.put("ebn", 31);
    freq.put("ebo", 79);
    freq.put("ebi", 182);
    freq.put("jo ", 29);
    freq.put("ebu", 39);
    freq.put("ebr", 14);
    freq.put("hU", 10);
    freq.put(" B ", 28);
    freq.put("dla", 34);
    freq.put("dle", 8);
    freq.put("dlj", 9);
    freq.put("dli", 62);
    freq.put("Vuč", 13);
    freq.put("dlo", 17);
    freq.put("Za ", 54);
    freq.put("Jac", 10);
    freq.put("dlu", 27);
    freq.put("hO", 7);
    freq.put("jor", 22);
    freq.put("jos", 134);
    freq.put("eb ", 34);
    freq.put("jov", 22);
    freq.put("jod", 9);
    freq.put("jog", 9);
    freq.put("joj", 122);
    freq.put("jok", 20);
    freq.put("jol", 11);
    freq.put("jom", 83);
    freq.put("jon", 12);
    freq.put("joo", 10);
    freq.put("Zam", 22);
    freq.put("Zaj", 12);
    freq.put("Zak", 11);
    freq.put("diš", 52);
    freq.put("Zag", 47);
    freq.put("Zad", 14);
    freq.put("Zab", 9);
    freq.put("Zav", 8);
    freq.put("Zat", 24);
    freq.put("Zar", 14);
    freq.put("Zas", 19);
    freq.put("Zap", 12);
    freq.put("rps", 53);
    freq.put("či ", 113);
    freq.put("rpe", 7);
    freq.put("rpi", 8);
    freq.put("hm ", 9);
    freq.put("rpl", 10);
    freq.put("rpo", 10);
    freq.put("Jul", 7);
    freq.put("Jur", 7);
    freq.put("Jus", 17);
    freq.put("Juv", 7);
    freq.put("Jut", 13);
    freq.put("čij", 24);
    freq.put("čim", 52);
    freq.put("čil", 17);
    freq.put("čio", 18);
    freq.put("čin", 90);
    freq.put("čic", 20);
    freq.put("hmm", 8);
    freq.put("hmi", 7);
    freq.put("čis", 11);
    freq.put("čit", 62);
    freq.put("gSu", 25);
    freq.put("nom", 305);
    freq.put("avt", 8);
    freq.put("avu", 128);
    freq.put("avq", 12);
    freq.put("avr", 109);
    freq.put("avs", 21);
    freq.put("avl", 192);
    freq.put("avn", 228);
    freq.put("avo", 227);
    freq.put("avi", 722);
    freq.put("avj", 16);
    freq.put("avk", 59);
    freq.put("avd", 20);
    freq.put("ave", 197);
    freq.put("ava", 705);
    freq.put("avc", 15);
    freq.put(" T ", 20);
    freq.put("Vuk", 22);
    freq.put("još", 103);
    freq.put("av ", 218);
    freq.put(" Tw", 13);
    freq.put(" Tv", 72);
    freq.put(" Tu", 63);
    freq.put(" Ts", 9);
    freq.put(" Tr", 91);
    freq.put("Mog", 20);
    freq.put(" To", 137);
    freq.put(" Tk", 13);
    freq.put(" Ti", 62);
    freq.put(" Th", 46);
    freq.put("tju", 8);
    freq.put(" Te", 76);
    freq.put(" Ta", 155);
    freq.put("mfi", 14);
    freq.put("mfo", 7);
    freq.put("tch", 27);
    freq.put("ajz", 10);
    freq.put("sku", 140);
    freq.put("skr", 81);
    freq.put("Far", 7);
    freq.put("vaš", 31);
    freq.put("sky", 12);
    freq.put("ske", 152);
    freq.put("ska", 333);
    freq.put("nor", 78);
    freq.put("Fal", 7);
    freq.put("skl", 40);
    freq.put("sko", 426);
    freq.put("ski", 379);
    freq.put("vač", 31);
    freq.put("vać", 11);
    freq.put("T", 1394);
    freq.put("vađ", 13);
    freq.put("dq ", 7);
    freq.put("sk ", 11);
    freq.put("dvi", 31);
    freq.put("Sub", 11);
    freq.put("Sun", 46);
    freq.put("Sut", 28);
    freq.put("Sup", 16);
    freq.put("Suz", 10);
    freq.put("nd ", 88);
    freq.put("žno", 26);
    freq.put("žnj", 20);
    freq.put("žni", 13);
    freq.put("žne", 7);
    freq.put("žna", 13);
    freq.put("ndi", 98);
    freq.put("ndj", 36);
    freq.put("ndo", 46);
    freq.put("nda", 256);
    freq.put("nde", 62);
    freq.put("ndz", 14);
    freq.put("dve", 34);
    freq.put("nds", 9);
    freq.put("ndr", 82);
    freq.put("ndu", 32);
    freq.put("vaK", 7);
    freq.put("own", 11);
    freq.put("owe", 18);
    freq.put("eđu", 35);
    freq.put("eđa", 16);
    freq.put("eđe", 13);
    freq.put("ows", 7);
    freq.put("vaj", 214);
    freq.put("vak", 325);
    freq.put("vai", 12);
    freq.put("van", 570);
    freq.put("vao", 61);
    freq.put("val", 328);
    freq.put("vam", 350);
    freq.put("Te ", 9);
    freq.put("vac", 121);
    freq.put("vaa", 27);
    freq.put("Ame", 21);
    freq.put("vag", 10);
    freq.put("vad", 42);
    freq.put("vaz", 33);
    freq.put("crn", 78);
    freq.put("var", 318);
    freq.put("vas", 167);
    freq.put("vap", 11);
    freq.put("vav", 7);
    freq.put("vat", 401);
    freq.put("ow ", 41);
    freq.put("Tek", 10);
    freq.put("Ten", 8);
    freq.put("va ", 1084);
    freq.put("lve", 18);
    freq.put("lm ", 33);
    freq.put("zvj", 7);
    freq.put("zvi", 57);
    freq.put("zvo", 76);
    freq.put("zva", 72);
    freq.put("zve", 55);
    freq.put("zvr", 19);
    freq.put("zvu", 35);
    freq.put("my ", 13);
    freq.put("ndž", 22);
  }
  
}

