package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HU {
  private static final String name = "hu";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HU() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 752920;
    n_words[1] = 901527;
    n_words[2] = 697700;

    freq.put("érz", 107);
    freq.put("tít", 21);
    freq.put("xtr", 22);
    freq.put("tív", 45);
    freq.put("tíz", 10);
    freq.put("érs", 11);
    freq.put("ért", 879);
    freq.put("érv", 25);
    freq.put("érh", 38);
    freq.put("éri", 45);
    freq.put("érj", 26);
    freq.put("érk", 81);
    freq.put("érl", 40);
    freq.put("érn", 48);
    freq.put("tai", 61);
    freq.put("érb", 9);
    freq.put("érd", 325);
    freq.put("ére", 243);
    freq.put("érf", 47);
    freq.put("érg", 8);
    freq.put("yu ", 23);
    freq.put("SP ", 17);
    freq.put("lé ", 56);
    freq.put("kné", 19);
    freq.put("ér ", 117);
    freq.put("mli", 27);
    freq.put("mlo", 12);
    freq.put("érü", 11);
    freq.put(" y ", 27);
    freq.put("éré", 16);
    freq.put("mrő", 15);
    freq.put("xa ", 9);
    freq.put(" yo", 77);
    freq.put(" ya", 17);
    freq.put("k", 31572);
    freq.put(" ye", 17);
    freq.put("lük", 14);
    freq.put("ED ", 21);
    freq.put("pél", 9);
    freq.put("pén", 120);
    freq.put("Lá", 67);
    freq.put("érő", 36);
    freq.put("Lé", 12);
    freq.put("pés", 20);
    freq.put("dne", 67);
    freq.put("dna", 70);
    freq.put("dno", 10);
    freq.put("dni", 198);
    freq.put("tjü", 13);
    freq.put("órá", 120);
    freq.put("tíl", 13);
    freq.put("znó", 8);
    freq.put("orá", 92);
    freq.put("Lf", 11);
    freq.put("Lg", 11);
    freq.put("Ld", 11);
    freq.put("Le", 217);
    freq.put("Lb", 9);
    freq.put("Lc", 8);
    freq.put("La", 117);
    freq.put("Ln", 15);
    freq.put("Lo", 146);
    freq.put("Lm", 12);
    freq.put("Lj", 10);
    freq.put("Lk", 9);
    freq.put("Li", 158);
    freq.put("czk", 16);
    freq.put("Lt", 11);
    freq.put("Lu", 45);
    freq.put("Ls", 25);
    freq.put("Lp", 11);
    freq.put("Lz", 10);
    freq.put("Lx", 13);
    freq.put("Né", 81);
    freq.put("hog", 1637);
    freq.put("hob", 12);
    freq.put("hon", 152);
    freq.put("hoo", 17);
    freq.put("hol", 333);
    freq.put("hom", 21);
    freq.put("dné", 20);
    freq.put("hov", 28);
    freq.put("how", 21);
    freq.put("hot", 56);
    freq.put("hou", 16);
    freq.put("hor", 60);
    freq.put("hos", 53);
    freq.put("hop", 29);
    freq.put("hoz", 309);
    freq.put("A", 3030);
    freq.put("L ", 256);
    freq.put("lül", 41);
    freq.put("Ö", 73);
    freq.put("cz ", 16);
    freq.put("ho ", 24);
    freq.put(" V ", 44);
    freq.put("zao", 12);
    freq.put("zal", 146);
    freq.put("zam", 47);
    freq.put("gúj", 32);
    freq.put("AP ", 11);
    freq.put("zak", 202);
    freq.put("fir", 17);
    freq.put("uor", 20);
    freq.put("Hir", 10);
    freq.put("Hit", 10);
    freq.put("Hiv", 8);
    freq.put("ró", 629);
    freq.put("rü", 289);
    freq.put("zai", 29);
    freq.put("rú", 64);
    freq.put("fib", 16);
    freq.put("fic", 77);
    freq.put("fia", 68);
    freq.put("rá", 1199);
    freq.put("fid", 11);
    freq.put("fie", 19);
    freq.put("Hih", 10);
    freq.put("rí", 71);
    freq.put("fin", 74);
    freq.put("ré", 564);
    freq.put("fil", 178);
    freq.put("dsá", 11);
    freq.put(" Va", 198);
    freq.put("zae", 8);
    freq.put(" Ve", 69);
    freq.put(" Vi", 250);
    freq.put("zab", 193);
    freq.put(" Vo", 30);
    freq.put("Egé", 10);
    freq.put("zaa", 20);
    freq.put("atá", 208);
    freq.put("ázá", 25);
    freq.put("atí", 16);
    freq.put("até", 31);
    freq.put("Hi ", 8);
    freq.put("fi ", 67);
    freq.put("ató", 195);
    freq.put("lSp", 11);
    freq.put("atú", 14);
    freq.put("rT", 9);
    freq.put("rW", 8);
    freq.put("rP", 11);
    freq.put("rQ", 10);
    freq.put("rR", 13);
    freq.put("rS", 10);
    freq.put("zay", 9);
    freq.put("rZ", 16);
    freq.put("rD", 19);
    freq.put("rE", 10);
    freq.put("rF", 15);
    freq.put("rG", 11);
    freq.put("rA", 9);
    freq.put("rB", 14);
    freq.put("rC", 14);
    freq.put("rL", 13);
    freq.put("rM", 13);
    freq.put("rN", 8);
    freq.put("rO", 8);
    freq.put("rH", 18);
    freq.put("zat", 214);
    freq.put("rJ", 13);
    freq.put("rK", 12);
    freq.put("rt", 2946);
    freq.put("ru", 423);
    freq.put("rv", 392);
    freq.put("rw", 18);
    freq.put("rp", 84);
    freq.put("rq", 15);
    freq.put("rr", 568);
    freq.put("rs", 823);
    freq.put("áz ", 78);
    freq.put("zar", 150);
    freq.put("rx", 9);
    freq.put("ry", 284);
    freq.put("rz", 261);
    freq.put("zas", 57);
    freq.put("rd", 874);
    freq.put("re", 4071);
    freq.put("rf", 144);
    freq.put("rg", 357);
    freq.put("ra", 2942);
    freq.put("rb", 311);
    freq.put("rc", 432);
    freq.put("rl", 258);
    freq.put("rm", 449);
    freq.put("rn", 616);
    freq.put("Eur", 44);
    freq.put("rh", 217);
    freq.put("ri", 1730);
    freq.put("rj", 266);
    freq.put("rk", 436);
    freq.put(" Vá", 52);
    freq.put("Egy", 271);
    freq.put("ial", 131);
    freq.put(" Vé", 39);
    freq.put(" Ví", 10);
    freq.put("égt", 16);
    freq.put("iai", 35);
    freq.put("ázh", 13);
    freq.put("ázi", 41);
    freq.put("ate", 158);
    freq.put("atb", 57);
    freq.put("atc", 10);
    freq.put("ázn", 25);
    freq.put("ázo", 35);
    freq.put("atn", 150);
    freq.put("áza", 101);
    freq.put("ázb", 27);
    freq.put("atm", 20);
    freq.put("atj", 73);
    freq.put("atk", 83);
    freq.put("ath", 57);
    freq.put("ati", 154);
    freq.put("atv", 18);
    freq.put("bűn", 12);
    freq.put("ázz", 19);
    freq.put("atu", 79);
    freq.put("atr", 52);
    freq.put("ats", 56);
    freq.put("eír", 30);
    freq.put("ázs", 28);
    freq.put("ázt", 28);
    freq.put("ds ", 26);
    freq.put("aty", 56);
    freq.put("yin", 11);
    freq.put("fül", 28);
    freq.put("Dun", 10);
    freq.put("tré", 18);
    freq.put("füg", 33);
    freq.put("iac", 25);
    freq.put("für", 25);
    freq.put("gké", 27);
    freq.put("Cen", 10);
    freq.put("nz ", 25);
    freq.put("mlá", 10);
    freq.put("iat", 127);
    freq.put("Éde", 8);
    freq.put("xi ", 13);
    freq.put("nzt", 21);
    freq.put("í", 2680);
    freq.put("nza", 9);
    freq.put("ias", 59);
    freq.put("nze", 13);
    freq.put("mlé", 63);
    freq.put("rő", 343);
    freq.put("már", 904);
    freq.put("őgé", 9);
    freq.put("Son", 13);
    freq.put("Ass", 17);
    freq.put("rű", 107);
    freq.put("aér", 16);
    freq.put("lpo", 9);
    freq.put("nzá", 11);
    freq.put("neg", 46);
    freq.put("nzé", 17);
    freq.put("lpa", 11);
    freq.put("nee", 35);
    freq.put("né ", 34);
    freq.put("épé", 21);
    freq.put("épí", 19);
    freq.put("épü", 18);
    freq.put("zto", 254);
    freq.put("zti", 127);
    freq.put("zth", 23);
    freq.put("ztj", 9);
    freq.put("zte", 424);
    freq.put("iró", 12);
    freq.put("zta", 284);
    freq.put("zty", 10);
    freq.put("ztu", 50);
    freq.put("irá", 109);
    freq.put("ztr", 54);
    freq.put("néj", 10);
    freq.put("nék", 148);
    freq.put("néh", 55);
    freq.put("sms", 12);
    freq.put("nén", 56);
    freq.put("yfa", 9);
    freq.put("nél", 195);
    freq.put("ném", 89);
    freq.put("yfo", 11);
    freq.put("nég", 23);
    freq.put("néd", 20);
    freq.put("néz", 426);
    freq.put("nér", 18);
    freq.put("X", 860);
    freq.put("nép", 20);
    freq.put("név", 39);
    freq.put("nét", 37);
    freq.put("ner", 97);
    freq.put("Rit", 17);
    freq.put("Ris", 8);
    freq.put("ően", 30);
    freq.put("Ric", 11);
    freq.put("━", 41);
    freq.put("épc", 10);
    freq.put("épe", 355);
    freq.put("PS ", 11);
    freq.put("épn", 17);
    freq.put("épr", 18);
    freq.put("éps", 33);
    freq.put("épp", 86);
    freq.put("mef", 11);
    freq.put("épv", 16);
    freq.put("övő", 69);
    freq.put("épt", 29);
    freq.put("épz", 53);
    freq.put("ztí", 8);
    freq.put("zté", 46);
    freq.put("mec", 52);
    freq.put("irr", 13);
    freq.put("irs", 9);
    freq.put("irt", 46);
    freq.put("iru", 13);
    freq.put("iri", 30);
    freq.put("irk", 27);
    freq.put("irl", 65);
    freq.put("irn", 9);
    freq.put("iro", 93);
    freq.put("ira", 260);
    freq.put("ird", 60);
    freq.put("ire", 266);
    freq.put("ztó", 32);
    freq.put("ép ", 254);
    freq.put("wtf", 10);
    freq.put("nák", 13);
    freq.put("ir ", 42);
    freq.put("áln", 126);
    freq.put("álo", 222);
    freq.put("anf", 17);
    freq.put("sök", 27);
    freq.put("álm", 70);
    freq.put("pra", 43);
    freq.put("nám", 60);
    freq.put("ztő", 41);
    freq.put("álk", 70);
    freq.put("fra", 45);
    freq.put("álh", 32);
    freq.put("fre", 18);
    freq.put("fri", 76);
    freq.put("anc", 125);
    freq.put("fro", 23);
    freq.put("lón", 17);
    freq.put("fru", 16);
    freq.put("emb", 386);
    freq.put("áld", 28);
    freq.put("lóm", 19);
    freq.put("lój", 26);
    freq.put("lók", 41);
    freq.put("őm ", 36);
    freq.put("ála", 222);
    freq.put("ráz", 41);
    freq.put("okm", 8);
    freq.put("pru", 8);
    freq.put("irő", 20);
    freq.put("ans", 64);
    freq.put("jk ", 18);
    freq.put("bá", 464);
    freq.put("Bék", 11);
    freq.put("lóz", 20);
    freq.put("dhe", 27);
    freq.put("dha", 31);
    freq.put("áls", 27);
    freq.put("épő", 12);
    freq.put("bí", 123);
    freq.put("bie", 26);
    freq.put("ólj", 12);
    freq.put("bé", 98);
    freq.put("tz ", 20);
    freq.put("jko", 33);
    freq.put(" ág", 26);
    freq.put("olá", 79);
    freq.put("bó", 283);
    freq.put(" ám", 15);
    freq.put("bü", 28);
    freq.put("oló", 86);
    freq.put("hah", 92);
    freq.put("hai", 13);
    freq.put("haj", 148);
    freq.put("hak", 11);
    freq.put("hal", 308);
    freq.put("ham", 71);
    freq.put("han", 277);
    freq.put("haa", 27);
    freq.put("hab", 28);
    freq.put("hac", 9);
    freq.put("had", 70);
    freq.put("hag", 112);
    freq.put("haz", 142);
    freq.put("umá", 12);
    freq.put("hap", 9);
    freq.put("har", 131);
    freq.put("has", 177);
    freq.put("hat", 469);
    freq.put("mbő", 15);
    freq.put("hav", 33);
    freq.put("köd", 55);
    freq.put("gko", 17);
    freq.put("kön", 154);
    freq.put("köl", 63);
    freq.put("köv", 209);
    freq.put("köt", 78);
    freq.put("kör", 115);
    freq.put("kös", 161);
    freq.put("köz", 448);
    freq.put("d", 17087);
    freq.put("ha ", 770);
    freq.put("üté", 17);
    freq.put("ola", 173);
    freq.put("olb", 9);
    freq.put(" íg", 194);
    freq.put("old", 286);
    freq.put("ole", 46);
    freq.put("olf", 20);
    freq.put("olg", 186);
    freq.put("olh", 19);
    freq.put("oli", 123);
    freq.put("olj", 96);
    freq.put(" X ", 79);
    freq.put("oll", 136);
    freq.put("oln", 474);
    freq.put("olo", 205);
    freq.put("ols", 81);
    freq.put("olt", 962);
    freq.put("olu", 32);
    freq.put(" ír", 256);
    freq.put("oly", 536);
    freq.put(" íz", 24);
    freq.put("fot", 72);
    freq.put("ump", 19);
    freq.put("for", 243);
    freq.put("fos", 21);
    freq.put("jös", 15);
    freq.put("jöv", 87);
    freq.put("foz", 8);
    freq.put("jöt", 101);
    freq.put("fod", 9);
    freq.put("jöj", 11);
    freq.put("fog", 498);
    freq.put("uma", 16);
    freq.put("jön", 164);
    freq.put("foc", 21);
    freq.put("fol", 176);
    freq.put("fon", 130);
    freq.put("umi", 46);
    freq.put("fok", 45);
    freq.put("ol ", 440);
    freq.put(" Xc", 8);
    freq.put("ÁT ", 10);
    freq.put("o", 37700);
    freq.put("Idő", 8);
    freq.put("fo ", 17);
    freq.put("um ", 85);
    freq.put("soa", 13);
    freq.put("sob", 9);
    freq.put("óan", 18);
    freq.put("sog", 10);
    freq.put("sof", 30);
    freq.put("soh", 32);
    freq.put("Fel", 94);
    freq.put("som", 120);
    freq.put("sol", 201);
    freq.put("Feh", 12);
    freq.put("son", 213);
    freq.put("sop", 33);
    freq.put("sos", 67);
    freq.put("sor", 203);
    freq.put("Fer", 29);
    freq.put("Fes", 16);
    freq.put("mbu", 8);
    freq.put("mbr", 15);
    freq.put("az ", 2861);
    freq.put("so ", 34);
    freq.put("mb ", 12);
    freq.put("Idé", 9);
    freq.put("azi", 78);
    freq.put("azm", 10);
    freq.put("azn", 20);
    freq.put("azo", 146);
    freq.put("aza", 179);
    freq.put("azd", 59);
    freq.put("aze", 41);
    freq.put("azg", 8);
    freq.put("azy", 10);
    freq.put("azz", 84);
    freq.put("azs", 52);
    freq.put("azt", 459);
    freq.put("azu", 21);
    freq.put("mbá", 8);
    freq.put("kho", 19);
    freq.put("Sik", 9);
    freq.put("kha", 12);
    freq.put("khe", 17);
    freq.put("Sim", 23);
    freq.put("Sil", 8);
    freq.put("xkl", 8);
    freq.put("E", 1740);
    freq.put("Ú", 189);
    freq.put("azé", 160);
    freq.put("azá", 108);
    freq.put("azó", 23);
    freq.put("lr ", 13);
    freq.put("hó ", 21);
    freq.put("osz", 262);
    freq.put("가", 12);
    freq.put("osp", 8);
    freq.put("oss", 278);
    freq.put("ost", 699);
    freq.put("osv", 8);
    freq.put("osi", 32);
    freq.put("osh", 31);
    freq.put("osk", 16);
    freq.put("osl", 12);
    freq.put("oso", 87);
    freq.put("osn", 15);
    freq.put("osa", 185);
    freq.put("rmö", 11);
    freq.put("osb", 33);
    freq.put("ose", 71);
    freq.put("ögl", 9);
    freq.put("vet", 442);
    freq.put("ver", 290);
    freq.put("ves", 419);
    freq.put("pem", 23);
    freq.put("VA ", 8);
    freq.put("vez", 197);
    freq.put("rel", 136);
    freq.put("veg", 151);
    freq.put("ved", 70);
    freq.put("ipő", 20);
    freq.put("évő", 16);
    freq.put("ögt", 15);
    freq.put("vel", 413);
    freq.put("vem", 90);
    freq.put("vek", 68);
    freq.put("veh", 16);
    freq.put("vei", 8);
    freq.put("lra", 43);
    freq.put("Má", 133);
    freq.put("hód", 8);
    freq.put("Mé", 64);
    freq.put("lro", 14);
    freq.put("Mó", 14);
    freq.put("pee", 11);
    freq.put("os ", 788);
    freq.put("nor", 73);
    freq.put("Mú", 8);
    freq.put("Tat", 8);
    freq.put("Tav", 10);
    freq.put("Tar", 12);
    freq.put("ög ", 26);
    freq.put("Tay", 13);
    freq.put("Tab", 14);
    freq.put("Tal", 31);
    freq.put("Tam", 24);
    freq.put("Tan", 29);
    freq.put("M ", 285);
    freq.put("ufi", 9);
    freq.put("osó", 13);
    freq.put("yd ", 15);
    freq.put("osí", 32);
    freq.put("osá", 16);
    freq.put("úto", 22);
    freq.put("gét", 20);
    freq.put("gés", 174);
    freq.put("gér", 106);
    freq.put("gép", 88);
    freq.put("lná", 25);
    freq.put("ők ", 115);
    freq.put("zre", 49);
    freq.put("géb", 9);
    freq.put("zra", 14);
    freq.put("gén", 119);
    freq.put("ögö", 27);
    freq.put("gél", 15);
    freq.put("gző", 10);
    freq.put("Me", 392);
    freq.put("Md", 13);
    freq.put("Mf", 10);
    freq.put("Ma", 591);
    freq.put("Mc", 25);
    freq.put("Mb", 14);
    freq.put("Mm", 8);
    freq.put("Ml", 10);
    freq.put("Mo", 248);
    freq.put("Mn", 10);
    freq.put("Mi", 506);
    freq.put("Mh", 12);
    freq.put("Mk", 8);
    freq.put("Mj", 15);
    freq.put("Mu", 77);
    freq.put("Mt", 12);
    freq.put("lró", 8);
    freq.put("Mv", 10);
    freq.put("Mq", 11);
    freq.put("Mp", 14);
    freq.put("Ms", 17);
    freq.put("Mr", 36);
    freq.put("My", 26);
    freq.put("Mx", 10);
    freq.put("Mz", 8);
    freq.put("ugi", 17);
    freq.put("ref", 10);
    freq.put("őkn", 16);
    freq.put("sű", 16);
    freq.put("út ", 33);
    freq.put("őke", 93);
    freq.put("gé ", 14);
    freq.put("éve", 217);
    freq.put("ipa", 34);
    freq.put("éva", 38);
    freq.put("évb", 12);
    freq.put("ipe", 22);
    freq.put("évn", 11);
    freq.put("ipi", 16);
    freq.put("évi", 13);
    freq.put("ipl", 11);
    freq.put("évt", 12);
    freq.put("ips", 17);
    freq.put("évv", 13);
    freq.put("czy", 9);
    freq.put("évr", 10);
    freq.put("ipu", 12);
    freq.put("óó ", 29);
    freq.put("téz", 18);
    freq.put("tét", 90);
    freq.put("tév", 28);
    freq.put("tép", 8);
    freq.put("tér", 136);
    freq.put("tés", 322);
    freq.put("tél", 99);
    freq.put("tém", 35);
    freq.put("tén", 207);
    freq.put("ték", 261);
    freq.put("tég", 32);
    freq.put("téb", 19);
    freq.put("ip ", 51);
    freq.put("év ", 80);
    freq.put("bG", 10);
    freq.put("sú", 103);
    freq.put("sü", 158);
    freq.put("só", 197);
    freq.put("sö", 139);
    freq.put("fűz", 8);
    freq.put("sé", 821);
    freq.put("sí", 288);
    freq.put("sá", 694);
    freq.put("fűt", 8);
    freq.put("zán", 79);
    freq.put("zál", 87);
    freq.put("zám", 225);
    freq.put("záj", 38);
    freq.put("zák", 19);
    freq.put("gzi", 13);
    freq.put("zág", 195);
    freq.put("zád", 14);
    freq.put("gze", 25);
    freq.put("záb", 23);
    freq.put("évé", 20);
    freq.put("záa", 20);
    freq.put("dő ", 103);
    freq.put("zát", 17);
    freq.put("zár", 112);
    freq.put("zás", 249);
    freq.put("Whe", 8);
    freq.put("ST ", 21);
    freq.put("s ", 9079);
    freq.put("lné", 41);
    freq.put("dőt", 22);
    freq.put("sZ", 9);
    freq.put("sY", 9);
    freq.put("sX", 15);
    freq.put("dőr", 35);
    freq.put("dős", 23);
    freq.put("sS", 18);
    freq.put("sR", 16);
    freq.put("sP", 15);
    freq.put("sW", 18);
    freq.put("sV", 9);
    freq.put("sU", 9);
    freq.put("sT", 13);
    freq.put("sK", 12);
    freq.put("sJ", 12);
    freq.put("sI", 15);
    freq.put("sH", 21);
    freq.put("Mű", 16);
    freq.put("sN", 14);
    freq.put("sM", 23);
    freq.put("sL", 11);
    freq.put("sC", 13);
    freq.put("sB", 31);
    freq.put("sA", 19);
    freq.put("sF", 9);
    freq.put("sE", 13);
    freq.put("sD", 16);
    freq.put("sz", 10502);
    freq.put("sy", 81);
    freq.put("sx", 13);
    freq.put("ss", 1658);
    freq.put("sr", 211);
    freq.put("sq", 29);
    freq.put("sp", 213);
    freq.put("sw", 29);
    freq.put("sv", 74);
    freq.put("su", 329);
    freq.put("st", 2277);
    freq.put("sk", 434);
    freq.put("sj", 28);
    freq.put("si", 1586);
    freq.put("sh", 301);
    freq.put("so", 1621);
    freq.put("sn", 218);
    freq.put("sm", 320);
    freq.put("sl", 125);
    freq.put("sc", 120);
    freq.put("sb", 201);
    freq.put("sa", 2252);
    freq.put("sg", 109);
    freq.put("sf", 58);
    freq.put("se", 2349);
    freq.put("sd", 113);
    freq.put("pít", 43);
    freq.put("tty", 30);
    freq.put("KA ", 15);
    freq.put("pír", 19);
    freq.put("tts", 48);
    freq.put("ttp", 4816);
    freq.put("ttu", 40);
    freq.put("ska", 84);
    freq.put("tti", 146);
    freq.put("tth", 93);
    freq.put("tto", 47);
    freq.put("ttl", 30);
    freq.put("tta", 440);
    freq.put("tte", 795);
    freq.put("ác ", 18);
    freq.put("dju", 104);
    freq.put("lyó", 10);
    freq.put("bló", 11);
    freq.put("dja", 142);
    freq.put("blé", 22);
    freq.put("blá", 16);
    freq.put("djo", 19);
    freq.put("rző", 24);
    freq.put("tt ", 2042);
    freq.put("utá", 287);
    freq.put("bbi", 121);
    freq.put("ji ", 12);
    freq.put("áci", 89);
    freq.put("áco", 12);
    freq.put("ács", 110);
    freq.put("dj ", 38);
    freq.put("lyá", 49);
    freq.put("ttü", 43);
    freq.put("ttó", 41);
    freq.put("ínű", 26);
    freq.put("ft", 76);
    freq.put("yáz", 34);
    freq.put("tté", 72);
    freq.put("ttá", 71);
    freq.put("djö", 8);
    freq.put("djü", 19);
    freq.put("blr", 15);
    freq.put("djá", 84);
    freq.put("blo", 87);
    freq.put("bli", 21);
    freq.put("Joh", 15);
    freq.put("mód", 38);
    freq.put("bla", 76);
    freq.put("ugy", 196);
    freq.put("ven", 244);
    freq.put("mko", 11);
    freq.put("cos", 16);
    freq.put("mó ", 14);
    freq.put("onj", 29);
    freq.put("onk", 38);
    freq.put("onh", 10);
    freq.put("oni", 95);
    freq.put("onn", 100);
    freq.put("ono", 93);
    freq.put("onl", 73);
    freq.put("onm", 8);
    freq.put("onb", 29);
    freq.put("onc", 89);
    freq.put("ona", 97);
    freq.put("onf", 26);
    freq.put(" Z ", 31);
    freq.put("ond", 716);
    freq.put("one", 131);
    freq.put("onz", 21);
    freq.put("íné", 11);
    freq.put("ony", 223);
    freq.put("onr", 31);
    freq.put("ons", 80);
    freq.put("onp", 11);
    freq.put("onv", 18);
    freq.put("ont", 403);
    freq.put("onH", 11);
    freq.put("ttő", 55);
    freq.put("ukt", 12);
    freq.put("ukr", 19);
    freq.put("uko", 39);
    freq.put("ukn", 9);
    freq.put("ukk", 28);
    freq.put("uki", 38);
    freq.put("uke", 12);
    freq.put("ukc", 8);
    freq.put("uka", 47);
    freq.put(" Zl", 12);
    freq.put(" Zo", 27);
    freq.put(" Ze", 20);
    freq.put("ööö", 11);
    freq.put("on ", 1488);
    freq.put(" Za", 54);
    freq.put(" Zy", 8);
    freq.put(" Zu", 24);
    freq.put(" Zs", 69);
    freq.put(" Zr", 10);
    freq.put("rze", 84);
    freq.put("rza", 26);
    freq.put("rzi", 24);
    freq.put("löt", 21);
    freq.put("rzu", 11);
    freq.put("rzs", 17);
    freq.put("fm ", 9);
    freq.put("uk ", 269);
    freq.put("sak", 878);
    freq.put("saj", 204);
    freq.put("sai", 37);
    freq.put("san", 260);
    freq.put("sam", 46);
    freq.put("sal", 160);
    freq.put("sac", 12);
    freq.put("sab", 87);
    freq.put("saa", 10);
    freq.put("oná", 22);
    freq.put("sag", 27);
    freq.put("sad", 15);
    freq.put("ính", 25);
    freq.put("say", 17);
    freq.put("sas", 42);
    freq.put("uY", 13);
    freq.put("sap", 82);
    freq.put("sav", 13);
    freq.put("ócs", 11);
    freq.put("öö ", 10);
    freq.put("zob", 45);
    freq.put("zoc", 10);
    freq.put("zod", 8);
    freq.put("zof", 16);
    freq.put("zog", 17);
    freq.put("lna", 450);
    freq.put("zok", 274);
    freq.put("zol", 199);
    freq.put("zom", 194);
    freq.put("zon", 249);
    freq.put("rmo", 18);
    freq.put("zop", 16);
    freq.put("ax ", 32);
    freq.put("zos", 18);
    freq.put("zot", 153);
    freq.put("zov", 19);
    freq.put("yál", 34);
    freq.put("uká", 27);
    freq.put("uV", 11);
    freq.put("sa ", 215);
    freq.put("ín ", 15);
    freq.put("uR", 11);
    freq.put("zo ", 17);
    freq.put("eér", 12);
    freq.put("sde", 12);
    freq.put("rzé", 49);
    freq.put("uN", 15);
    freq.put("yán", 19);
    freq.put("axi", 14);
    freq.put("Sky", 15);
    freq.put("uE", 9);
    freq.put("XI ", 11);
    freq.put("ülé", 49);
    freq.put("vid", 397);
    freq.put("ülü", 11);
    freq.put("É ", 8);
    freq.put("uB", 12);
    freq.put("ülö", 152);
    freq.put("cig", 27);
    freq.put("kjá", 9);
    freq.put(" bá", 159);
    freq.put(" bí", 86);
    freq.put("És", 78);
    freq.put("Ér", 37);
    freq.put(" bé", 38);
    freq.put("Ét", 9);
    freq.put("Év", 8);
    freq.put("cik", 70);
    freq.put("Éj", 11);
    freq.put("Él", 30);
    freq.put(" bó", 12);
    freq.put("Én", 106);
    freq.put(" bü", 21);
    freq.put("Éd", 8);
    freq.put(" bú", 18);
    freq.put("cio", 18);
    freq.put("cin", 21);
    freq.put("us", 999);
    freq.put("ülj", 15);
    freq.put("üli", 68);
    freq.put("ülh", 22);
    freq.put("üln", 50);
    freq.put("üll", 8);
    freq.put("ülb", 11);
    freq.put("VG ", 31);
    freq.put("ülf", 19);
    freq.put("üle", 118);
    freq.put("üld", 91);
    freq.put("vki", 15);
    freq.put("üly", 72);
    freq.put("cip", 27);
    freq.put("üls", 14);
    freq.put("étő", 12);
    freq.put("ciu", 26);
    freq.put("cit", 31);
    freq.put("rö", 222);
    freq.put("gók", 13);
    freq.put(" be", 1173);
    freq.put("kja", 14);
    freq.put(" ba", 569);
    freq.put("fit", 14);
    freq.put("kje", 8);
    freq.put(" bl", 94);
    freq.put(" bo", 244);
    freq.put("ül ", 311);
    freq.put(" bi", 256);
    freq.put(" bk", 15);
    freq.put("gól", 23);
    freq.put(" bu", 211);
    freq.put(" bt", 17);
    freq.put("s", 37664);
    freq.put(" br", 84);
    freq.put(" by", 18);
    freq.put("ivá", 94);
    freq.put("lyu", 14);
    freq.put("ivé", 23);
    freq.put("étá", 28);
    freq.put("úrt", 8);
    freq.put("zpr", 11);
    freq.put("ZT ", 12);
    freq.put("úra", 21);
    freq.put("úri", 19);
    freq.put("fig", 57);
    freq.put("nít", 28);
    freq.put("smé", 35);
    freq.put("dsé", 14);
    freq.put("yze", 41);
    freq.put("fik", 21);
    freq.put("yzi", 9);
    freq.put("yzo", 13);
    freq.put("lyg", 11);
    freq.put("úr ", 12);
    freq.put("Jön", 11);
    freq.put("ive", 186);
    freq.put("étl", 25);
    freq.put("étk", 18);
    freq.put("éti", 20);
    freq.put("étf", 53);
    freq.put("éte", 256);
    freq.put("étb", 12);
    freq.put("ivi", 64);
    freq.put("éta", 17);
    freq.put("étv", 53);
    freq.put("étt", 14);
    freq.put("étr", 16);
    freq.put("éts", 26);
    freq.put("lyo", 62);
    freq.put("rű ", 63);
    freq.put("úrá", 9);
    freq.put("lyk", 17);
    freq.put("I", 1060);
    freq.put("Mas", 19);
    freq.put("ét ", 444);
    freq.put(" gu", 40);
    freq.put(" bő", 41);
    freq.put("yzé", 27);
    freq.put("bün", 9);
    freq.put(" bű", 15);
    freq.put("Max", 9);
    freq.put("ezü", 10);
    freq.put("tsá", 33);
    freq.put("tvé", 62);
    freq.put("ezé", 122);
    freq.put("tvá", 46);
    freq.put("ezá", 17);
    freq.put("gdo", 13);
    freq.put("Lán", 9);
    freq.put("Lát", 21);
    freq.put("Nő", 16);
    freq.put("Lás", 23);
    freq.put("epé", 14);
    freq.put("NA ", 11);
    freq.put("sic", 52);
    freq.put("Man", 39);
    freq.put("ezz", 94);
    freq.put("ezt", 406);
    freq.put("ezv", 14);
    freq.put("ezr", 11);
    freq.put("ezs", 10);
    freq.put("ezl", 24);
    freq.put("ezm", 21);
    freq.put("ezn", 103);
    freq.put("ezo", 32);
    freq.put("ezh", 18);
    freq.put("ezi", 78);
    freq.put("ezd", 239);
    freq.put("eze", 481);
    freq.put("tva", 44);
    freq.put("eza", 16);
    freq.put("ac ", 15);
    freq.put("ddi", 151);
    freq.put("dda", 34);
    freq.put("dde", 24);
    freq.put("ddd", 120);
    freq.put("áék", 8);
    freq.put("ez ", 719);
    freq.put("tv ", 31);
    freq.put("acc", 13);
    freq.put("áad", 35);
    freq.put("aca", 21);
    freq.put("ace", 142);
    freq.put("jg ", 8);
    freq.put("aci", 47);
    freq.put("ach", 24);
    freq.put("aco", 13);
    freq.put("acs", 126);
    freq.put("act", 34);
    freq.put("FL ", 17);
    freq.put("dd ", 139);
    freq.put("Nh", 8);
    freq.put("Ni", 151);
    freq.put("heW", 10);
    freq.put("Nl", 13);
    freq.put("Nm", 14);
    freq.put("Nn", 19);
    freq.put("No", 96);
    freq.put("aé", 25);
    freq.put("Na", 270);
    freq.put("Nc", 9);
    freq.put("Nd", 18);
    freq.put("Ne", 427);
    freq.put("Nf", 9);
    freq.put("Ng", 9);
    freq.put("Nx", 10);
    freq.put("Ny", 87);
    freq.put("kú ", 10);
    freq.put("Np", 10);
    freq.put("Nq", 8);
    freq.put("És ", 72);
    freq.put("Nt", 10);
    freq.put("Nu", 13);
    freq.put("Nv", 16);
    freq.put("Nw", 12);
    freq.put("het", 831);
    freq.put("hev", 10);
    freq.put("her", 104);
    freq.put("hes", 43);
    freq.put("hey", 18);
    freq.put("hez", 119);
    freq.put("hee", 23);
    freq.put("heg", 16);
    freq.put("hea", 18);
    freq.put("hec", 9);
    freq.put("hel", 313);
    freq.put("hem", 13);
    freq.put("hen", 57);
    freq.put("heh", 15);
    freq.put("hek", 11);
    freq.put("kúr", 8);
    freq.put("N ", 282);
    freq.put("zne", 81);
    freq.put("tsm", 8);
    freq.put("õ", 37);
    freq.put("Hof", 14);
    freq.put("Hog", 48);
    freq.put("ac", 542);
    freq.put("ab", 896);
    freq.put("ae", 101);
    freq.put("ad", 1647);
    freq.put("ag", 3139);
    freq.put("af", 140);
    freq.put("Hon", 16);
    freq.put("ah", 480);
    freq.put("Hol", 72);
    freq.put("aj", 1457);
    freq.put("am", 3129);
    freq.put("al", 4727);
    freq.put("ao", 58);
    freq.put("an", 6000);
    freq.put("aq", 15);
    freq.put("ap", 2055);
    freq.put("as", 2033);
    freq.put("ar", 3316);
    freq.put("au", 219);
    freq.put("at", 3967);
    freq.put("aw", 68);
    freq.put("av", 423);
    freq.put("ay", 296);
    freq.put("ax", 85);
    freq.put("az", 4358);
    freq.put("Hoz", 20);
    freq.put("sii", 38);
    freq.put("aA", 13);
    freq.put("aC", 27);
    freq.put("aB", 17);
    freq.put("aE", 9);
    freq.put("aD", 20);
    freq.put("aG", 16);
    freq.put("aF", 17);
    freq.put("aI", 13);
    freq.put("aH", 8);
    freq.put("aK", 18);
    freq.put("aJ", 11);
    freq.put("aM", 16);
    freq.put("aL", 18);
    freq.put("aO", 22);
    freq.put("aN", 15);
    freq.put("aP", 11);
    freq.put("aS", 26);
    freq.put("aR", 14);
    freq.put("aU", 9);
    freq.put("aT", 24);
    freq.put("aV", 18);
    freq.put("aY", 12);
    freq.put("aX", 12);
    freq.put("aZ", 13);
    freq.put("a ", 15166);
    freq.put("oh ", 16);
    freq.put("dsz", 111);
    freq.put("at ", 1011);
    freq.put("AZ ", 29);
    freq.put("uá", 56);
    freq.put("fiú", 61);
    freq.put("uit", 12);
    freq.put("sco", 27);
    freq.put("tZ", 14);
    freq.put("sch", 27);
    freq.put("Fő", 15);
    freq.put("tV", 14);
    freq.put("tW", 12);
    freq.put("tT", 14);
    freq.put("tR", 11);
    freq.put("tS", 13);
    freq.put("tP", 12);
    freq.put("tQ", 11);
    freq.put("tN", 14);
    freq.put("tO", 18);
    freq.put("tL", 11);
    freq.put(" a", 14911);
    freq.put("tJ", 10);
    freq.put("Fig", 17);
    freq.put("Fid", 22);
    freq.put("tI", 15);
    freq.put("scu", 8);
    freq.put("tG", 12);
    freq.put("tD", 8);
    freq.put("tE", 18);
    freq.put("tB", 16);
    freq.put("tC", 11);
    freq.put("scs", 16);
    freq.put("tA", 11);
    freq.put("smo", 11);
    freq.put("zmi", 13);
    freq.put("tz", 41);
    freq.put("tx", 20);
    freq.put("ty", 375);
    freq.put("tv", 287);
    freq.put("tw", 181);
    freq.put("tt", 8916);
    freq.put("tu", 1310);
    freq.put("tr", 633);
    freq.put("ts", 966);
    freq.put("tp", 4853);
    freq.put("zme", 16);
    freq.put("tn", 569);
    freq.put("to", 2736);
    freq.put("tl", 511);
    freq.put("tm", 143);
    freq.put("tj", 231);
    freq.put("tk", 314);
    freq.put("th", 613);
    freq.put("ti", 1536);
    freq.put("tf", 109);
    freq.put("tg", 38);
    freq.put("td", 27);
    freq.put("te", 6408);
    freq.put("tb", 257);
    freq.put("tc", 114);
    freq.put("göt", 13);
    freq.put("ta", 4360);
    freq.put("smi", 50);
    freq.put("klő", 14);
    freq.put("löm", 8);
    freq.put("sme", 151);
    freq.put("ro", 2264);
    freq.put("pbe", 11);
    freq.put("pba", 8);
    freq.put("sma", 28);
    freq.put("t ", 19507);
    freq.put("Fiú", 10);
    freq.put("tü", 193);
    freq.put("zmé", 30);
    freq.put("tú", 168);
    freq.put("tö", 841);
    freq.put("tõ", 12);
    freq.put("tó", 790);
    freq.put("tí", 100);
    freq.put("té", 1262);
    freq.put("tá", 1751);
    freq.put("sés", 47);
    freq.put("sér", 64);
    freq.put("sév", 9);
    freq.put("pbó", 13);
    freq.put("íli", 15);
    freq.put("rűe", 19);
    freq.put("ílt", 10);
    freq.put("ílu", 12);
    freq.put("őlt", 14);
    freq.put("vib", 8);
    freq.put("vic", 79);
    freq.put("via", 68);
    freq.put("vig", 26);
    freq.put("oén", 15);
    freq.put("vie", 26);
    freq.put("vik", 18);
    freq.put("vih", 27);
    freq.put("vii", 17);
    freq.put("vin", 47);
    freq.put("vil", 197);
    freq.put("tő", 682);
    freq.put("vir", 38);
    freq.put("vis", 313);
    freq.put("Aur", 12);
    freq.put("viv", 30);
    freq.put("Aut", 14);
    freq.put("vit", 51);
    freq.put("viz", 76);
    freq.put("ünn", 33);
    freq.put("ünk", 346);
    freq.put("séb", 15);
    freq.put("üne", 36);
    freq.put("ünd", 8);
    freq.put("ökr", 10);
    freq.put(" d ", 74);
    freq.put("ökk", 35);
    freq.put("VE ", 8);
    freq.put("ünt", 26);
    freq.put("öke", 18);
    freq.put("vi ", 58);
    freq.put("sék", 20);
    freq.put(" do", 323);
    freq.put(" dn", 10);
    freq.put("őle", 84);
    freq.put("kla", 34);
    freq.put(" di", 130);
    freq.put(" de", 1159);
    freq.put(" dd", 21);
    freq.put(" db", 21);
    freq.put(" da", 142);
    freq.put("klu", 36);
    freq.put(" dz", 23);
    freq.put("ato", 586);
    freq.put(" dw", 8);
    freq.put(" dv", 9);
    freq.put(" du", 85);
    freq.put(" dr", 73);
    freq.put("isv", 10);
    freq.put("BA ", 12);
    freq.put("tmé", 15);
    freq.put("att", 427);
    freq.put("ökö", 28);
    freq.put("öké", 30);
    freq.put("őn ", 27);
    freq.put("r ", 4386);
    freq.put("AK ", 23);
    freq.put(" dí", 30);
    freq.put("klá", 29);
    freq.put(" dé", 69);
    freq.put(" dá", 8);
    freq.put(" dü", 8);
    freq.put("kló", 12);
    freq.put("zdő", 53);
    freq.put(" dö", 66);
    freq.put("sm ", 8);
    freq.put("itn", 12);
    freq.put("ito", 64);
    freq.put("IP ", 8);
    freq.put("éjs", 26);
    freq.put("éjt", 20);
    freq.put("itk", 42);
    freq.put("ith", 29);
    freq.put("iti", 57);
    freq.put("itg", 10);
    freq.put("ite", 143);
    freq.put("itb", 10);
    freq.put("itc", 35);
    freq.put("ita", 167);
    freq.put("itz", 8);
    freq.put("éje", 11);
    freq.put("éjf", 10);
    freq.put("ity", 29);
    freq.put("itt", 466);
    freq.put("itu", 35);
    freq.put("itr", 11);
    freq.put("its", 66);
    freq.put("kác", 19);
    freq.put("káb", 115);
    freq.put("kák", 26);
    freq.put("káj", 16);
    freq.put("kái", 12);
    freq.put("kán", 51);
    freq.put("it ", 934);
    freq.put("kál", 39);
    freq.put("kás", 70);
    freq.put("kár", 123);
    freq.put("káv", 34);
    freq.put("kát", 45);
    freq.put("káz", 17);
    freq.put(" My", 19);
    freq.put("búc", 8);
    freq.put("búj", 13);
    freq.put("uál", 20);
    freq.put(" A ", 1062);
    freq.put("ití", 8);
    freq.put("gfr", 8);
    freq.put("tre", 106);
    freq.put("itá", 62);
    freq.put("gfo", 26);
    freq.put("éjé", 10);
    freq.put("itó", 15);
    freq.put("gfe", 28);
    freq.put("vab", 11);
    freq.put("fte", 12);
    freq.put("ruá", 19);
    freq.put(" Ab", 20);
    freq.put(" Ac", 27);
    freq.put(" Ad", 70);
    freq.put(" Af", 11);
    freq.put(" Ag", 20);
    freq.put(" Ah", 29);
    freq.put(" Ai", 11);
    freq.put(" Aj", 19);
    freq.put(" Ak", 89);
    freq.put(" Al", 126);
    freq.put(" Am", 110);
    freq.put(" An", 182);
    freq.put(" Ap", 49);
    freq.put(" Ar", 49);
    freq.put(" As", 41);
    freq.put(" At", 43);
    freq.put(" Au", 28);
    freq.put(" Av", 14);
    freq.put(" Aw", 11);
    freq.put(" Ay", 9);
    freq.put(" Az", 434);
    freq.put("NG ", 10);
    freq.put("tru", 27);
    freq.put("ft ", 34);
    freq.put("w", 1604);
    freq.put("HD ", 11);
    freq.put("Fra", 17);
    freq.put("Fre", 8);
    freq.put("vaa", 14);
    freq.put("Fri", 19);
    freq.put("KE ", 19);
    freq.put("űté", 11);
    freq.put("jer", 9);
    freq.put("jes", 133);
    freq.put("pók", 10);
    freq.put("aa ", 145);
    freq.put("jet", 27);
    freq.put("jez", 35);
    freq.put("ág ", 242);
    freq.put("jeg", 94);
    freq.put("jed", 18);
    freq.put("jek", 45);
    freq.put("jei", 12);
    freq.put("jen", 44);
    freq.put("jel", 321);
    freq.put("itő", 18);
    freq.put("ágo", 150);
    freq.put("ágn", 34);
    freq.put("aag", 14);
    freq.put("aaa", 243);
    freq.put("ágj", 9);
    freq.put("ági", 41);
    freq.put("ágh", 8);
    freq.put("aam", 18);
    freq.put("aan", 51);
    freq.put("ágb", 60);
    freq.put("ága", 43);
    freq.put("aaj", 13);
    freq.put("aat", 8);
    freq.put("je ", 149);
    freq.put("ágy", 61);
    freq.put("aar", 17);
    freq.put("águ", 9);
    freq.put("ágt", 19);
    freq.put("ágs", 8);
    freq.put("ágr", 70);
    freq.put("yha", 34);
    freq.put("lám", 52);
    freq.put("OT ", 11);
    freq.put("lán", 220);
    freq.put("láj", 43);
    freq.put("ex ", 40);
    freq.put("tp ", 4775);
    freq.put("odd", 10);
    freq.put("lád", 42);
    freq.put("ues", 9);
    freq.put("küv", 9);
    freq.put("lág", 147);
    freq.put("M", 2778);
    freq.put("küz", 8);
    freq.put("Ist", 37);
    freq.put("Isk", 8);
    freq.put("láb", 158);
    freq.put("űt ", 9);
    freq.put("kül", 277);
    freq.put("kün", 37);
    freq.put("lác", 15);
    freq.put("lök", 53);
    freq.put("ágí", 8);
    freq.put("exe", 13);
    freq.put("emá", 12);
    freq.put("exa", 23);
    freq.put("tpo", 8);
    freq.put("exk", 10);
    freq.put("ágá", 47);
    freq.put("exi", 16);
    freq.put("ext", 24);
    freq.put("exu", 13);
    freq.put("tps", 41);
    freq.put("tpp", 8);
    freq.put("exx", 8);
    freq.put("Haj", 29);
    freq.put("Hal", 26);
    freq.put("Ham", 26);
    freq.put("Han", 23);
    freq.put(" ór", 196);
    freq.put("uga", 29);
    freq.put(" óv", 9);
    freq.put(" ót", 41);
    freq.put("Hag", 10);
    freq.put("ógé", 14);
    freq.put("Hay", 9);
    freq.put("Haz", 8);
    freq.put("oje", 16);
    freq.put("oja", 12);
    freq.put("Hap", 9);
    freq.put("ugr", 28);
    freq.put("Har", 89);
    freq.put("Hat", 26);
    freq.put("Hav", 9);
    freq.put("ugt", 8);
    freq.put("Gye", 22);
    freq.put("zké", 8);
    freq.put(" Ó", 28);
    freq.put("Gyo", 10);
    freq.put("zká", 10);
    freq.put("Gyu", 19);
    freq.put("áh", 78);
    freq.put("zkö", 20);
    freq.put("lás", 297);
    freq.put("ps ", 71);
    freq.put("zkó", 9);
    freq.put("Ha ", 163);
    freq.put("ug ", 9);
    freq.put(" ó ", 12);
    freq.put("zó ", 90);
    freq.put("rfa", 13);
    freq.put("ás ", 708);
    freq.put("őrö", 16);
    freq.put("cre", 31);
    freq.put("rfi", 54);
    freq.put("rfo", 35);
    freq.put("cro", 9);
    freq.put("Fot", 12);
    freq.put("set", 156);
    freq.put("ses", 38);
    freq.put("ser", 89);
    freq.put("For", 29);
    freq.put("sep", 15);
    freq.put("sey", 8);
    freq.put("ógi", 18);
    freq.put("sef", 14);
    freq.put("see", 13);
    freq.put("Fog", 8);
    freq.put("sec", 19);
    freq.put("seb", 118);
    freq.put("sea", 13);
    freq.put("ojá", 15);
    freq.put("Fol", 15);
    freq.put("sen", 426);
    freq.put("sem", 477);
    freq.put("sel", 121);
    freq.put("sek", 171);
    freq.put("sej", 19);
    freq.put("sei", 49);
    freq.put("seh", 32);
    freq.put("őr ", 23);
    freq.put("zko", 29);
    freq.put("zki", 28);
    freq.put("zke", 26);
    freq.put("duk", 8);
    freq.put("zka", 12);
    freq.put("Gyö", 15);
    freq.put("tiz", 40);
    freq.put(" fő", 72);
    freq.put("ue ", 28);
    freq.put("se ", 394);
    freq.put(" fű", 21);
    freq.put("lep", 87);
    freq.put("őre", 75);
    freq.put("őri", 13);
    freq.put("nű ", 10);
    freq.put("rfü", 9);
    freq.put("öté", 28);
    freq.put("kű ", 9);
    freq.put("őrt", 9);
    freq.put("őrz", 11);
    freq.put("pda", 22);
    freq.put("lex", 45);
    freq.put("Győ", 15);
    freq.put("íj ", 10);
    freq.put("tiv", 52);
    freq.put("xan", 13);
    freq.put("Job", 20);
    freq.put("dul", 190);
    freq.put("nra", 17);
    freq.put("nre", 12);
    freq.put("Ola", 10);
    freq.put(" fó", 15);
    freq.put("mla", 18);
    freq.put("íja", 17);
    freq.put(" fö", 56);
    freq.put("Oli", 13);
    freq.put(" fú", 20);
    freq.put(" fü", 76);
    freq.put("kná", 17);
    freq.put(" fá", 88);
    freq.put("Olv", 9);
    freq.put(" fé", 247);
    freq.put("Oly", 18);
    freq.put("vod", 13);
    freq.put("ami", 707);
    freq.put("tmi", 10);
    freq.put("ásr", 66);
    freq.put("vol", 794);
    freq.put("von", 61);
    freq.put("voi", 14);
    freq.put("vot", 15);
    freq.put("vor", 8);
    freq.put("vos", 30);
    freq.put("kér", 297);
    freq.put("lün", 33);
    freq.put("amo", 88);
    freq.put("amn", 22);
    freq.put(" f ", 35);
    freq.put("hér", 32);
    freq.put("hét", 210);
    freq.put("héz", 32);
    freq.put("nró", 14);
    freq.put("héj", 8);
    freq.put("tró", 27);
    freq.put(" fN", 8);
    freq.put("kno", 13);
    freq.put(" fr", 135);
    freq.put(" fu", 144);
    freq.put(" ft", 25);
    freq.put("kni", 16);
    freq.put(" fy", 8);
    freq.put("Sok", 21);
    freq.put("kne", 85);
    freq.put("Som", 10);
    freq.put("kna", 114);
    freq.put(" fa", 339);
    freq.put("Sop", 11);
    freq.put(" fb", 55);
    freq.put(" fe", 1040);
    freq.put(" fi", 440);
    freq.put(" fl", 41);
    freq.put(" fo", 824);
    freq.put("pör", 20);
    freq.put("ijö", 8);
    freq.put("Vet", 10);
    freq.put("O ", 260);
    freq.put("ijá", 14);
    freq.put("éhá", 31);
    freq.put("ams", 34);
    freq.put("tin", 160);
    freq.put("náb", 27);
    freq.put("nác", 18);
    freq.put("amr", 16);
    freq.put("nád", 25);
    freq.put("amu", 48);
    freq.put("nán", 35);
    freq.put("nál", 470);
    freq.put("amt", 10);
    freq.put("nár", 52);
    freq.put("nás", 24);
    freq.put("náv", 10);
    freq.put("nát", 28);
    freq.put("ZP ", 12);
    freq.put("löl", 28);
    freq.put("Oo", 14);
    freq.put("On", 69);
    freq.put("Om", 10);
    freq.put("Ol", 74);
    freq.put("Ok", 34);
    freq.put("Oj", 10);
    freq.put("Oi", 11);
    freq.put("Oh", 14);
    freq.put("Of", 64);
    freq.put("Oe", 12);
    freq.put("Od", 16);
    freq.put("Oc", 8);
    freq.put("Ob", 20);
    freq.put("Oa", 8);
    freq.put("bö", 45);
    freq.put("tsa", 30);
    freq.put("Oz", 11);
    freq.put("Oy", 8);
    freq.put("Ox", 10);
    freq.put("Ow", 17);
    freq.put("Ov", 16);
    freq.put("Ou", 14);
    freq.put("Ot", 24);
    freq.put("Os", 22);
    freq.put("Or", 94);
    freq.put("bú", 34);
    freq.put("Op", 31);
    freq.put("sön", 24);
    freq.put("ná ", 28);
    freq.put("söm", 13);
    freq.put("Pin", 18);
    freq.put("sög", 10);
    freq.put("söt", 25);
    freq.put("sör", 18);
    freq.put("b ", 1378);
    freq.put("ija", 22);
    freq.put("ije", 30);
    freq.put("éha", 43);
    freq.put("éhe", 21);
    freq.put("sró", 22);
    freq.put("óéj", 8);
    freq.put("bd", 44);
    freq.put("be", 3069);
    freq.put("bf", 10);
    freq.put("bg", 16);
    freq.put("ba", 2463);
    freq.put("bb", 1576);
    freq.put("bc", 20);
    freq.put("bl", 321);
    freq.put("bm", 15);
    freq.put("bn", 33);
    freq.put("bo", 765);
    freq.put("bh", 17);
    freq.put("bi", 619);
    freq.put("bj", 35);
    freq.put("bk", 63);
    freq.put("bt", 47);
    freq.put("bu", 368);
    freq.put("bv", 17);
    freq.put("bp", 19);
    freq.put("bq", 10);
    freq.put("br", 273);
    freq.put("bs", 90);
    freq.put("by", 71);
    freq.put("bz", 14);
    freq.put("Fu", 39);
    freq.put("bE", 13);
    freq.put("bF", 8);
    freq.put("Osz", 9);
    freq.put("bA", 10);
    freq.put("bB", 8);
    freq.put("bL", 8);
    freq.put("bM", 11);
    freq.put("bO", 14);
    freq.put("bH", 9);
    freq.put("bI", 11);
    freq.put("bJ", 11);
    freq.put("bK", 10);
    freq.put("bT", 9);
    freq.put("bV", 8);
    freq.put("bQ", 13);
    freq.put("bR", 8);
    freq.put("chi", 57);
    freq.put("DE ", 25);
    freq.put("bX", 12);
    freq.put("bZ", 16);
    freq.put(" C ", 52);
    freq.put("ózá", 21);
    freq.put("ci ", 125);
    freq.put("Fb", 11);
    freq.put("Fc", 9);
    freq.put("ÓL ", 9);
    freq.put("u ", 525);
    freq.put("chu", 16);
    freq.put(" Ch", 78);
    freq.put(" Ci", 52);
    freq.put("BK ", 8);
    freq.put(" Co", 87);
    freq.put(" Cl", 31);
    freq.put("uZ", 10);
    freq.put("uU", 9);
    freq.put("uT", 244);
    freq.put("uW", 15);
    freq.put(" Ca", 78);
    freq.put("uQ", 10);
    freq.put("uP", 13);
    freq.put(" Ce", 15);
    freq.put("uM", 8);
    freq.put("uL", 14);
    freq.put("uO", 9);
    freq.put(" Cy", 12);
    freq.put("uI", 9);
    freq.put("uH", 8);
    freq.put("uK", 17);
    freq.put("uJ", 17);
    freq.put(" Cr", 40);
    freq.put(" Cs", 217);
    freq.put("uG", 16);
    freq.put("uF", 11);
    freq.put("uA", 8);
    freq.put("uC", 10);
    freq.put(" Cu", 15);
    freq.put("cic", 15);
    freq.put("cib", 8);
    freq.put("cia", 126);
    freq.put("AC ", 8);
    freq.put("uy", 22);
    freq.put("ux", 37);
    freq.put("cie", 8);
    freq.put("uz", 118);
    freq.put("uu", 179);
    freq.put("ut", 1117);
    freq.put("uw", 9);
    freq.put("uv", 35);
    freq.put("uq", 12);
    freq.put("up", 146);
    freq.put("NE ", 29);
    freq.put("ur", 591);
    freq.put("um", 346);
    freq.put("ul", 1169);
    freq.put("uo", 38);
    freq.put("un", 1093);
    freq.put("ui", 78);
    freq.put("uh", 109);
    freq.put("uk", 551);
    freq.put("uj", 90);
    freq.put("ue", 105);
    freq.put("ud", 1127);
    freq.put("ug", 407);
    freq.put("uf", 54);
    freq.put("ua", 42);
    freq.put("uc", 190);
    freq.put("ub", 433);
    freq.put("ózn", 15);
    freq.put("óza", 10);
    freq.put("ózs", 26);
    freq.put("EZ ", 11);
    freq.put("ózt", 14);
    freq.put("sla", 17);
    freq.put("pff", 8);
    freq.put("ag ", 116);
    freq.put("Zuz", 9);
    freq.put("usi", 52);
    freq.put("bű", 16);
    freq.put("zaj", 30);
    freq.put("zín", 132);
    freq.put("ago", 97);
    freq.put("agn", 10);
    freq.put("ciá", 18);
    freq.put("agj", 16);
    freq.put("agi", 44);
    freq.put("agg", 33);
    freq.put("age", 43);
    freq.put("agd", 8);
    freq.put("aga", 285);
    freq.put("ció", 165);
    freq.put("bő", 195);
    freq.put("agy", 2270);
    freq.put("agu", 37);
    freq.put("ags", 17);
    freq.put("agr", 18);
    freq.put("Jim", 8);
    freq.put("sg ", 10);
    freq.put("odá", 70);
    freq.put("o ", 5805);
    freq.put("pul", 27);
    freq.put("ev ", 10);
    freq.put("tr ", 12);
    freq.put("leí", 27);
    freq.put("zaf", 15);
    freq.put("tri", 57);
    freq.put("evi", 51);
    freq.put("tro", 100);
    freq.put("evo", 16);
    freq.put("tra", 173);
    freq.put("eva", 33);
    freq.put("zag", 20);
    freq.put("eve", 326);
    freq.put("try", 12);
    freq.put("rdá", 23);
    freq.put("rdí", 43);
    freq.put("rdé", 144);
    freq.put("le ", 492);
    freq.put("ody", 17);
    freq.put("Blu", 19);
    freq.put("odr", 17);
    freq.put("ods", 21);
    freq.put("odt", 59);
    freq.put("odu", 13);
    freq.put("odv", 8);
    freq.put("odi", 68);
    freq.put("Blo", 16);
    freq.put("odn", 31);
    freq.put("odo", 51);
    freq.put("oda", 131);
    freq.put("odb", 10);
    freq.put("őnö", 8);
    freq.put("Bla", 18);
    freq.put("ode", 45);
    freq.put("nűl", 13);
    freq.put("uer", 14);
    freq.put("ueM", 13);
    freq.put("Elő", 25);
    freq.put("tűn", 69);
    freq.put("ct ", 28);
    freq.put("rd ", 93);
    freq.put("tűz", 14);
    freq.put("lea", 42);
    freq.put("leb", 59);
    freq.put("lec", 32);
    freq.put("led", 83);
    freq.put("lee", 33);
    freq.put("lef", 114);
    freq.put("leg", 986);
    freq.put("leh", 382);
    freq.put("lei", 34);
    freq.put("lej", 135);
    freq.put("lek", 262);
    freq.put("lel", 154);
    freq.put("lem", 429);
    freq.put("len", 952);
    freq.put("ő", 3926);
    freq.put("ler", 97);
    freq.put("les", 825);
    freq.put("let", 857);
    freq.put("leu", 8);
    freq.put("lev", 104);
    freq.put("od ", 313);
    freq.put("ley", 12);
    freq.put("lez", 61);
    freq.put("ség", 460);
    freq.put("rdu", 31);
    freq.put("evé", 59);
    freq.put("tű ", 19);
    freq.put("rds", 13);
    freq.put("cts", 9);
    freq.put("trá", 68);
    freq.put("evá", 25);
    freq.put("rdz", 8);
    freq.put("rde", 318);
    freq.put("rda", 41);
    freq.put("rdo", 43);
    freq.put("cto", 25);
    freq.put("rdi", 37);
    freq.put("cti", 65);
    freq.put("sgy", 17);
    freq.put("uTu", 231);
    freq.put("onó", 8);
    freq.put("sga", 31);
    freq.put("yőz", 32);
    freq.put("ziv", 41);
    freq.put("zit", 42);
    freq.put("zir", 8);
    freq.put("zis", 41);
    freq.put("zip", 8);
    freq.put("űző", 9);
    freq.put("ziz", 9);
    freq.put("zif", 11);
    freq.put("zig", 56);
    freq.put("zid", 12);
    freq.put("zib", 15);
    freq.put("zia", 92);
    freq.put("zin", 139);
    freq.put("zil", 65);
    freq.put("zim", 21);
    freq.put("zij", 10);
    freq.put("zik", 348);
    freq.put("zii", 28);
    freq.put("tsz", 520);
    freq.put("öt ", 34);
    freq.put("tün", 109);
    freq.put("sra", 72);
    freq.put("trő", 16);
    freq.put("evő", 18);
    freq.put("őpo", 9);
    freq.put("úk ", 26);
    freq.put("zi ", 288);
    freq.put("evű", 10);
    freq.put("oz ", 183);
    freq.put("yfe", 9);
    freq.put("tük", 55);
    freq.put("ró ", 56);
    freq.put("np ", 8);
    freq.put("tül", 14);
    freq.put("zót", 38);
    freq.put("sgá", 30);
    freq.put("zió", 36);
    freq.put("ô", 11);
    freq.put("ról", 330);
    freq.put("rón", 10);
    freq.put("rdő", 24);
    freq.put("rók", 11);
    freq.put("npe", 8);
    freq.put("npa", 9);
    freq.put("rób", 99);
    freq.put("Q", 456);
    freq.put("afo", 9);
    freq.put("róz", 10);
    freq.put("rót", 16);
    freq.put("róp", 36);
    freq.put("afi", 18);
    freq.put("mje", 9);
    freq.put("Yo", 274);
    freq.put("Onl", 13);
    freq.put("One", 43);
    freq.put("aró", 15);
    freq.put("úl", 252);
    freq.put("ún", 41);
    freq.put("új", 480);
    freq.put("úk", 47);
    freq.put("úd", 12);
    freq.put("úg", 434);
    freq.put("TY ", 9);
    freq.put("Yd", 8);
    freq.put("úz", 78);
    freq.put("nés", 33);
    freq.put("út", 89);
    freq.put("úv", 8);
    freq.put("úr", 88);
    freq.put("ús", 74);
    freq.put("Yx", 13);
    freq.put("őrs", 12);
    freq.put(" h ", 388);
    freq.put("ú ", 222);
    freq.put("Yq", 9);
    freq.put("Yp", 14);
    freq.put("Saj", 28);
    freq.put(" hy", 18);
    freq.put("San", 22);
    freq.put("Sam", 19);
    freq.put("Sal", 10);
    freq.put(" hr", 9);
    freq.put("Saa", 8);
    freq.put(" hu", 210);
    freq.put(" ht", 4822);
    freq.put(" hi", 436);
    freq.put(" ho", 2025);
    freq.put(" hn", 9);
    freq.put(" hm", 33);
    freq.put(" ha", 1730);
    freq.put("ádi", 40);
    freq.put(" he", 387);
    freq.put(" hd", 9);
    freq.put("mni", 8);
    freq.put("rj ", 39);
    freq.put("zt ", 805);
    freq.put("úú", 88);
    freq.put("pás", 11);
    freq.put("lzá", 14);
    freq.put("tok", 508);
    freq.put("log", 194);
    freq.put(" hú", 50);
    freq.put(" hü", 67);
    freq.put(" hó", 91);
    freq.put(" hö", 12);
    freq.put(" hé", 200);
    freq.put(" hí", 109);
    freq.put("lok", 234);
    freq.put(" há", 483);
    freq.put("tát", 54);
    freq.put("táv", 36);
    freq.put("OM ", 19);
    freq.put("ény", 544);
    freq.put("énz", 66);
    freq.put("tás", 366);
    freq.put("ént", 170);
    freq.put("IT ", 22);
    freq.put("énn", 16);
    freq.put("ihi", 19);
    freq.put("iho", 21);
    freq.put("táb", 56);
    freq.put("énk", 30);
    freq.put("tál", 294);
    freq.put("éne", 244);
    freq.put("tán", 406);
    freq.put("iha", 51);
    freq.put("táh", 26);
    freq.put("éna", 8);
    freq.put("táj", 29);
    freq.put("ihe", 64);
    freq.put("UN ", 13);
    freq.put("mno", 8);
    freq.put("rós", 15);
    freq.put(" hő", 12);
    freq.put("ih ", 17);
    freq.put("én ", 782);
    freq.put("mja", 15);
    freq.put("lző", 10);
    freq.put(" hű", 14);
    freq.put("cké", 8);
    freq.put("nHu", 12);
    freq.put("mna", 37);
    freq.put("ehh", 19);
    freq.put(" E ", 69);
    freq.put("éné", 9);
    freq.put("ck ", 100);
    freq.put("pus", 52);
    freq.put(" El", 198);
    freq.put(" Em", 42);
    freq.put(" En", 69);
    freq.put(" Ed", 39);
    freq.put(" Eg", 296);
    freq.put(" Ea", 10);
    freq.put(" Eb", 18);
    freq.put(" Ec", 10);
    freq.put("vák", 16);
    freq.put(" Ex", 24);
    freq.put(" Ez", 189);
    freq.put(" Eu", 56);
    freq.put(" Ev", 40);
    freq.put(" Ep", 11);
    freq.put(" Er", 60);
    freq.put(" Es", 74);
    freq.put("cke", 36);
    freq.put("cka", 12);
    freq.put("AA ", 9);
    freq.put("cko", 15);
    freq.put("cki", 14);
    freq.put("con", 61);
    freq.put("cks", 15);
    freq.put("cky", 22);
    freq.put("szj", 9);
    freq.put("szk", 115);
    freq.put("szh", 19);
    freq.put("szi", 678);
    freq.put("szn", 190);
    freq.put("szo", 752);
    freq.put("szl", 118);
    freq.put("szm", 26);
    freq.put("dba", 33);
    freq.put("ztá", 258);
    freq.put("sza", 872);
    freq.put("dbe", 65);
    freq.put("szg", 12);
    freq.put("szd", 21);
    freq.put("sze", 2604);
    freq.put("Pá", 27);
    freq.put("szr", 40);
    freq.put("da ", 168);
    freq.put("szp", 25);
    freq.put("KI ", 21);
    freq.put("szv", 26);
    freq.put("szt", 1066);
    freq.put("szu", 141);
    freq.put("ztü", 32);
    freq.put("jav", 32);
    freq.put("jat", 63);
    freq.put("ván", 170);
    freq.put("jar", 23);
    freq.put("jas", 16);
    freq.put("jap", 14);
    freq.put("jan", 35);
    freq.put("ae ", 21);
    freq.put("jal", 15);
    freq.put("jam", 37);
    freq.put("jaj", 59);
    freq.put("jak", 53);
    freq.put("jah", 18);
    freq.put("jai", 43);
    freq.put("ák ", 418);
    freq.put("jab", 71);
    freq.put("jaa", 19);
    freq.put("Zsu", 17);
    freq.put("mtu", 35);
    freq.put("úúú", 52);
    freq.put("db ", 18);
    freq.put("sz ", 1407);
    freq.put("zr", 89);
    freq.put("Ó", 28);
    freq.put("Zsa", 11);
    freq.put("úc", 24);
    freq.put("hón", 52);
    freq.put("aer", 11);
    freq.put("etö", 25);
    freq.put("etõ", 9);
    freq.put("h", 16963);
    freq.put("etü", 19);
    freq.put("tlá", 15);
    freq.put("lU", 9);
    freq.put("áko", 27);
    freq.put("ákn", 15);
    freq.put("aeg", 8);
    freq.put("ákb", 8);
    freq.put("áka", 33);
    freq.put("eté", 170);
    freq.put("aem", 12);
    freq.put("ael", 15);
    freq.put("ja ", 720);
    freq.put("etí", 15);
    freq.put("Pr", 72);
    freq.put("btw", 12);
    freq.put("szé", 407);
    freq.put("Pv", 8);
    freq.put("Pt", 13);
    freq.put("Pu", 30);
    freq.put("Pz", 16);
    freq.put("Px", 9);
    freq.put("Py", 10);
    freq.put("oma", 128);
    freq.put("Pb", 11);
    freq.put("vű", 17);
    freq.put("Pa", 176);
    freq.put("bta", 14);
    freq.put("Pg", 10);
    freq.put("szü", 274);
    freq.put("Pe", 100);
    freq.put("Pk", 10);
    freq.put("Ph", 72);
    freq.put("Pi", 89);
    freq.put("Pn", 8);
    freq.put("Po", 107);
    freq.put("Pl", 37);
    freq.put("Pm", 16);
    freq.put("váb", 71);
    freq.put("vő", 123);
    freq.put("et ", 1997);
    freq.put("omi", 99);
    freq.put("eum", 13);
    freq.put("tso", 10);
    freq.put("tsl", 11);
    freq.put("P ", 273);
    freq.put("ofő", 8);
    freq.put("lc", 179);
    freq.put("etr", 94);
    freq.put("ets", 348);
    freq.put("etv", 26);
    freq.put("etw", 8);
    freq.put("ett", 1422);
    freq.put("etu", 14);
    freq.put("ety", 20);
    freq.put("etb", 65);
    freq.put("eue", 9);
    freq.put("tla", 127);
    freq.put("eta", 43);
    freq.put("etf", 11);
    freq.put("gbó", 9);
    freq.put("tle", 319);
    freq.put("ete", 1125);
    freq.put("etj", 17);
    freq.put("etk", 78);
    freq.put("eth", 35);
    freq.put("eti", 214);
    freq.put("etn", 235);
    freq.put("eto", 50);
    freq.put("etl", 214);
    freq.put("etm", 15);
    freq.put("ck", 281);
    freq.put("vá", 1072);
    freq.put("ci", 793);
    freq.put("ch", 362);
    freq.put("co", 5118);
    freq.put("cn", 10);
    freq.put("cm", 21);
    freq.put("cl", 42);
    freq.put("cc", 246);
    freq.put("vé", 810);
    freq.put("ca", 318);
    freq.put("cg", 13);
    freq.put("ví", 86);
    freq.put("ce", 641);
    freq.put("cd", 19);
    freq.put("lfö", 28);
    freq.put("cz", 81);
    freq.put("cy", 25);
    freq.put("vó", 29);
    freq.put("ucc", 33);
    freq.put("Hea", 11);
    freq.put("vö", 65);
    freq.put("cs", 3325);
    freq.put("cr", 75);
    freq.put("cq", 10);
    freq.put("cp", 19);
    freq.put("vü", 51);
    freq.put("cv", 21);
    freq.put("cu", 146);
    freq.put("ct", 159);
    freq.put("Ger", 18);
    freq.put("cI", 12);
    freq.put("cH", 10);
    freq.put("cO", 14);
    freq.put("cN", 13);
    freq.put("cM", 11);
    freq.put("cL", 13);
    freq.put("cB", 15);
    freq.put("cA", 9);
    freq.put("cG", 8);
    freq.put("cF", 10);
    freq.put("cD", 15);
    freq.put("cZ", 13);
    freq.put("cY", 9);
    freq.put("cS", 12);
    freq.put("cR", 8);
    freq.put("cQ", 12);
    freq.put("cP", 9);
    freq.put("cW", 12);
    freq.put("cV", 9);
    freq.put("cU", 9);
    freq.put("rb ", 9);
    freq.put("lgi", 9);
    freq.put("lgo", 118);
    freq.put("vén", 71);
    freq.put("c ", 581);
    freq.put("lge", 41);
    freq.put("lgy", 20);
    freq.put("gbő", 10);
    freq.put("ofá", 10);
    freq.put("ővé", 16);
    freq.put("rbu", 8);
    freq.put("ővá", 12);
    freq.put("rbo", 12);
    freq.put("eus", 11);
    freq.put("rbi", 32);
    freq.put("uny", 18);
    freq.put("rbe", 82);
    freq.put("eur", 39);
    freq.put("rba", 80);
    freq.put("va", 3877);
    freq.put("vb", 44);
    freq.put("vc", 23);
    freq.put("vd", 24);
    freq.put("ve", 2761);
    freq.put("vf", 21);
    freq.put("vg", 21);
    freq.put("vh", 18);
    freq.put("vi", 1499);
    freq.put("vj", 31);
    freq.put("vk", 26);
    freq.put("vl", 23);
    freq.put("vm", 61);
    freq.put("vn", 41);
    freq.put("vo", 983);
    freq.put("vp", 14);
    freq.put("vq", 14);
    freq.put("vr", 40);
    freq.put("vs", 50);
    freq.put("vt", 64);
    freq.put("vu", 29);
    freq.put("vv", 42);
    freq.put("vw", 13);
    freq.put("vx", 12);
    freq.put("vy", 17);
    freq.put("vz", 14);
    freq.put("vA", 12);
    freq.put("vB", 9);
    freq.put("vC", 10);
    freq.put("vE", 8);
    freq.put("vG", 12);
    freq.put("vH", 11);
    freq.put("vJ", 8);
    freq.put("vL", 9);
    freq.put("vM", 16);
    freq.put("vO", 8);
    freq.put("vP", 11);
    freq.put("vQ", 11);
    freq.put("nká", 116);
    freq.put("vS", 9);
    freq.put("vT", 16);
    freq.put("vV", 16);
    freq.put("vW", 10);
    freq.put("vX", 9);
    freq.put("vY", 8);
    freq.put("vZ", 10);
    freq.put("güg", 8);
    freq.put("v ", 437);
    freq.put("phi", 12);
    freq.put("ető", 262);
    freq.put("pho", 35);
    freq.put("eál", 32);
    freq.put("yon", 421);
    freq.put("pha", 32);
    freq.put("lgá", 58);
    freq.put("yom", 146);
    freq.put("phe", 19);
    freq.put("yol", 42);
    freq.put("etű", 18);
    freq.put("off", 79);
    freq.put("ofe", 15);
    freq.put("őve", 22);
    freq.put("ofi", 55);
    freq.put("rbó", 8);
    freq.put("ofo", 16);
    freq.put("yog", 22);
    freq.put("oft", 16);
    freq.put("üvő", 9);
    freq.put("rbá", 52);
    freq.put("umo", 32);
    freq.put("xel", 8);
    freq.put("xet", 8);
    freq.put("AR ", 9);
    freq.put("web", 25);
    freq.put("pőd", 10);
    freq.put("wee", 79);
    freq.put("wei", 8);
    freq.put("gum", 14);
    freq.put("wel", 11);
    freq.put("ív ", 56);
    freq.put("wer", 11);
    freq.put("pőt", 8);
    freq.put("xe ", 9);
    freq.put("eWa", 11);
    freq.put("gul", 39);
    freq.put("nve", 38);
    freq.put("pő ", 13);
    freq.put("mho", 8);
    freq.put("ívt", 12);
    freq.put(" jú", 22);
    freq.put("kró", 35);
    freq.put(" jö", 260);
    freq.put(" jó", 736);
    freq.put("kré", 30);
    freq.put(" jé", 26);
    freq.put("íve", 52);
    freq.put("ívj", 12);
    freq.put("ehé", 65);
    freq.put(" já", 230);
    freq.put("ívo", 11);
    freq.put("gur", 26);
    freq.put("vsz", 18);
    freq.put("öme", 20);
    freq.put("AT ", 25);
    freq.put("llg", 106);
    freq.put("inő", 27);
    freq.put(" j ", 36);
    freq.put("hív", 54);
    freq.put("öm ", 140);
    freq.put("vs ", 16);
    freq.put("nvé", 8);
    freq.put("ívó", 8);
    freq.put("nös", 12);
    freq.put("Sch", 18);
    freq.put(" ju", 160);
    freq.put("ívü", 37);
    freq.put("kru", 10);
    freq.put("ívá", 91);
    freq.put(" jo", 325);
    freq.put("kri", 49);
    freq.put("kro", 31);
    freq.put(" je", 268);
    freq.put("kra", 90);
    freq.put(" ja", 244);
    freq.put("kre", 96);
    freq.put("iné", 28);
    freq.put("iná", 192);
    freq.put("jzo", 33);
    freq.put("yri", 12);
    freq.put("yra", 26);
    freq.put("yre", 64);
    freq.put("zőt", 16);
    freq.put("Kla", 15);
    freq.put("Klu", 10);
    freq.put("Zls", 9);
    freq.put("jz ", 9);
    freq.put("iny", 21);
    freq.put("int", 998);
    freq.put("inu", 24);
    freq.put("zői", 10);
    freq.put("ins", 40);
    freq.put("inl", 8);
    freq.put("inn", 85);
    freq.put("ino", 55);
    freq.put("inh", 8);
    freq.put("ini", 89);
    freq.put("ink", 278);
    freq.put("ind", 1016);
    freq.put("ine", 334);
    freq.put("inf", 54);
    freq.put("ing", 332);
    freq.put("ina", 220);
    freq.put("inb", 15);
    freq.put("inc", 334);
    freq.put("eo ", 32);
    freq.put("óna", 77);
    freq.put("tma", 18);
    freq.put("krő", 21);
    freq.put("U", 602);
    freq.put("in ", 287);
    freq.put("vo ", 12);
    freq.put("eok", 9);
    freq.put("tsé", 119);
    freq.put("eoo", 8);
    freq.put("eon", 27);
    freq.put("eom", 8);
    freq.put("eol", 18);
    freq.put("eor", 12);
    freq.put("eot", 10);
    freq.put("rep", 88);
    freq.put("pto", 24);
    freq.put("Lég", 8);
    freq.put("árr", 16);
    freq.put("MA ", 14);
    freq.put("árs", 103);
    freq.put(" G ", 36);
    freq.put("árt", 185);
    freq.put("reu", 10);
    freq.put("áru", 50);
    freq.put("rej", 19);
    freq.put("alh", 20);
    freq.put("él ", 343);
    freq.put("pth", 8);
    freq.put("cm ", 9);
    freq.put("nbó", 11);
    freq.put("teá", 8);
    freq.put("pte", 59);
    freq.put("tsB", 15);
    freq.put("vül", 40);
    freq.put(" Gu", 37);
    freq.put(" Gr", 48);
    freq.put("erő", 115);
    freq.put("Vá", 52);
    freq.put("vün", 8);
    freq.put("lvo", 8);
    freq.put(" Gy", 107);
    freq.put(" Ge", 56);
    freq.put(" Ga", 88);
    freq.put(" Go", 94);
    freq.put(" Gl", 23);
    freq.put("lü", 99);
    freq.put(" Gi", 40);
    freq.put("élg", 28);
    freq.put("éld", 11);
    freq.put("éle", 401);
    freq.put("erű", 64);
    freq.put("éln", 62);
    freq.put("glá", 23);
    freq.put("élm", 13);
    freq.put("élj", 38);
    freq.put("akö", 25);
    freq.put("éli", 49);
    freq.put("élv", 17);
    freq.put("aké", 22);
    freq.put("élu", 34);
    freq.put("élr", 18);
    freq.put("éls", 17);
    freq.put("akí", 9);
    freq.put("Vé", 40);
    freq.put("aká", 99);
    freq.put("ree", 77);
    freq.put("ély", 151);
    freq.put("aly", 53);
    freq.put("Cf", 11);
    freq.put("alv", 43);
    freq.put("müv", 45);
    freq.put("lbu", 65);
    freq.put("alt", 135);
    freq.put("alu", 126);
    freq.put("alr", 18);
    freq.put("als", 58);
    freq.put("slo", 12);
    freq.put("árn", 109);
    freq.put("ak ", 2052);
    freq.put(" Gö", 9);
    freq.put("Ft ", 85);
    freq.put(" Gá", 18);
    freq.put(" Gé", 10);
    freq.put("gli", 23);
    freq.put("löv", 14);
    freq.put("aks", 22);
    freq.put("akr", 31);
    freq.put("gle", 128);
    freq.put("aku", 39);
    freq.put("élé", 24);
    freq.put("akk", 483);
    freq.put("akj", 10);
    freq.put("aki", 391);
    freq.put("akh", 11);
    freq.put("ako", 203);
    freq.put("akn", 42);
    freq.put("akm", 22);
    freq.put("akl", 10);
    freq.put("akc", 43);
    freq.put("akb", 12);
    freq.put("áig", 33);
    freq.put("lön", 95);
    freq.put("ake", 65);
    freq.put("nk ", 903);
    freq.put("bru", 35);
    freq.put("bro", 24);
    freq.put("bri", 58);
    freq.put("bre", 80);
    freq.put("Dfa", 9);
    freq.put("OR ", 9);
    freq.put("er ", 883);
    freq.put("ió ", 115);
    freq.put("nka", 157);
    freq.put("nkb", 29);
    freq.put("nkc", 8);
    freq.put("nke", 123);
    freq.put("nki", 260);
    freq.put("nkn", 13);
    freq.put("nko", 68);
    freq.put("nkr", 43);
    freq.put("élő", 27);
    freq.put("ert", 804);
    freq.put("eru", 25);
    freq.put("erv", 113);
    freq.put("erp", 27);
    freq.put("err", 195);
    freq.put("ers", 218);
    freq.put("iós", 57);
    freq.put("iór", 8);
    freq.put("óre", 8);
    freq.put("tny", 17);
    freq.put("ik", 2574);
    freq.put("erz", 72);
    freq.put("iót", 51);
    freq.put("erd", 114);
    freq.put("ere", 1385);
    freq.put("erf", 25);
    freq.put("erg", 87);
    freq.put("tna", 64);
    freq.put("era", 103);
    freq.put("erb", 64);
    freq.put("erc", 156);
    freq.put("erl", 32);
    freq.put("erm", 121);
    freq.put("ern", 161);
    freq.put("ero", 52);
    freq.put("erh", 36);
    freq.put("eri", 393);
    freq.put("erj", 83);
    freq.put("erk", 58);
    freq.put("Nat", 11);
    freq.put("uar", 8);
    freq.put("la ", 285);
    freq.put("mpe", 8);
    freq.put("brá", 9);
    freq.put("ib", 395);
    freq.put("mpa", 21);
    freq.put("nök", 56);
    freq.put("lal", 155);
    freq.put("V ", 186);
    freq.put("lan", 330);
    freq.put("lah", 68);
    freq.put("lai", 32);
    freq.put("laj", 36);
    freq.put("lak", 347);
    freq.put("lad", 160);
    freq.put("nké", 39);
    freq.put("lag", 112);
    freq.put("laa", 23);
    freq.put("lab", 62);
    freq.put("lac", 44);
    freq.put("nkó", 11);
    freq.put("lax", 11);
    freq.put("lay", 36);
    freq.put("laz", 31);
    freq.put("lat", 433);
    freq.put("lau", 47);
    freq.put("lav", 9);
    freq.put("mpi", 57);
    freq.put("lap", 210);
    freq.put("lar", 28);
    freq.put("las", 272);
    freq.put("faj", 34);
    freq.put("erü", 162);
    freq.put("tná", 33);
    freq.put("erá", 45);
    freq.put("erí", 21);
    freq.put("tné", 118);
    freq.put("eré", 99);
    freq.put("Csí", 8);
    freq.put("zef", 26);
    freq.put("zeg", 126);
    freq.put("zed", 110);
    freq.put("zek", 349);
    freq.put("zeh", 9);
    freq.put("zei", 12);
    freq.put("Csá", 9);
    freq.put("zel", 322);
    freq.put("zem", 553);
    freq.put("zer", 1298);
    freq.put("zes", 101);
    freq.put("zep", 65);
    freq.put("zev", 9);
    freq.put("zet", 616);
    freq.put("zez", 26);
    freq.put("zex", 28);
    freq.put("úgy", 399);
    freq.put("tár", 235);
    freq.put("ZI ", 10);
    freq.put("úgo", 8);
    freq.put("mbl", 27);
    freq.put("ze ", 202);
    freq.put("ntú", 8);
    freq.put("ntó", 24);
    freq.put("pja", 77);
    freq.put("ktő", 16);
    freq.put("ntö", 16);
    freq.put("nté", 110);
    freq.put("táz", 10);
    freq.put("ntá", 70);
    freq.put("iC", 15);
    freq.put("őtw", 8);
    freq.put("őtt", 140);
    freq.put("ító", 66);
    freq.put("l", 38207);
    freq.put("íté", 91);
    freq.put("ítá", 100);
    freq.put("zen", 375);
    freq.put("éni", 52);
    freq.put("Cso", 30);
    freq.put("Csi", 23);
    freq.put("Cse", 26);
    freq.put("tác", 13);
    freq.put("Csa", 116);
    freq.put("eU ", 13);
    freq.put("tám", 56);
    freq.put("nt ", 1119);
    freq.put("bá ", 8);
    freq.put("ít ", 59);
    freq.put("ták", 145);
    freq.put("nty", 11);
    freq.put("nts", 45);
    freq.put("ntr", 57);
    freq.put("pjá", 43);
    freq.put("ntt", 10);
    freq.put("nti", 99);
    freq.put("hP", 9);
    freq.put("ntk", 26);
    freq.put("ntj", 21);
    freq.put("mbi", 20);
    freq.put("nto", 155);
    freq.put("nta", 117);
    freq.put("ntb", 16);
    freq.put("nte", 603);
    freq.put("bát", 34);
    freq.put("bár", 115);
    freq.put("bás", 18);
    freq.put("íts", 58);
    freq.put("báz", 11);
    freq.put("ítj", 27);
    freq.put("mva", 8);
    freq.put("Ugy", 20);
    freq.put("íti", 15);
    freq.put("báb", 9);
    freq.put("bác", 12);
    freq.put("ítm", 8);
    freq.put("bán", 84);
    freq.put("bál", 124);
    freq.put("bám", 19);
    freq.put("bák", 9);
    freq.put("íte", 118);
    freq.put("öss", 184);
    freq.put(" l ", 56);
    freq.put("ösz", 205);
    freq.put("tek", 746);
    freq.put("öse", 19);
    freq.put("kib", 54);
    freq.put("Jól", 13);
    freq.put("űni", 33);
    freq.put("kt ", 30);
    freq.put("Józ", 10);
    freq.put(" le", 2515);
    freq.put("B", 1667);
    freq.put(" la", 265);
    freq.put("őtő", 9);
    freq.put(" lo", 135);
    freq.put(" li", 257);
    freq.put("ös ", 66);
    freq.put(" lv", 12);
    freq.put(" lu", 41);
    freq.put("tef", 12);
    freq.put("teg", 203);
    freq.put(" ly", 26);
    freq.put("Jó ", 67);
    freq.put("ktu", 21);
    freq.put("ktr", 11);
    freq.put("Seg", 10);
    freq.put("uY ", 8);
    freq.put("kto", 84);
    freq.put("kti", 12);
    freq.put("Sen", 10);
    freq.put("Sem", 17);
    freq.put("kta", 90);
    freq.put("Q ", 116);
    freq.put("udv", 16);
    freq.put("ter", 633);
    freq.put("teu", 8);
    freq.put("tev", 16);
    freq.put("ype", 28);
    freq.put("Qq", 8);
    freq.put("Qp", 13);
    freq.put("Qr", 9);
    freq.put("Qu", 22);
    freq.put("Qt", 9);
    freq.put("Qw", 12);
    freq.put("Qv", 10);
    freq.put("Qx", 8);
    freq.put("Qz", 15);
    freq.put(" lé", 148);
    freq.put(" Ön", 13);
    freq.put(" lö", 13);
    freq.put(" Ös", 11);
    freq.put(" Ör", 11);
    freq.put("Qe", 15);
    freq.put(" Öt", 17);
    freq.put("Qg", 10);
    freq.put("Qf", 16);
    freq.put("Qi", 12);
    freq.put("Qh", 9);
    freq.put("Qk", 11);
    freq.put("Qj", 11);
    freq.put("Qm", 11);
    freq.put("Ql", 19);
    freq.put("Qo", 8);
    freq.put("Qn", 8);
    freq.put("tse", 31);
    freq.put("ntő", 55);
    freq.put("któ", 22);
    freq.put("ktí", 21);
    freq.put("uda", 130);
    freq.put("ktá", 17);
    freq.put("ogj", 27);
    freq.put("d ", 2804);
    freq.put("udj", 95);
    freq.put("ké ", 58);
    freq.put("ÉN ", 8);
    freq.put("em ", 5085);
    freq.put("udn", 143);
    freq.put("dót", 9);
    freq.put("dós", 18);
    freq.put("Fo", 79);
    freq.put("hro", 19);
    freq.put("hri", 11);
    freq.put("dók", 9);
    freq.put("dn", 436);
    freq.put("do", 1788);
    freq.put("dl", 61);
    freq.put("dm", 93);
    freq.put("dj", 468);
    freq.put("dk", 67);
    freq.put("dh", 84);
    freq.put("di", 1309);
    freq.put("df", 32);
    freq.put("dg", 34);
    freq.put("dd", 567);
    freq.put("de", 3496);
    freq.put("db", 141);
    freq.put("dc", 21);
    freq.put("DC ", 9);
    freq.put("da", 1122);
    freq.put("kék", 31);
    freq.put("dz", 114);
    freq.put("kén", 214);
    freq.put("dx", 18);
    freq.put("dy", 103);
    freq.put("dv", 387);
    freq.put("dw", 25);
    freq.put("dt", 640);
    freq.put("du", 331);
    freq.put("dr", 324);
    freq.put("ds", 206);
    freq.put("dp", 24);
    freq.put("dq", 12);
    freq.put("dN", 15);
    freq.put("dO", 11);
    freq.put("dL", 11);
    freq.put("dM", 9);
    freq.put("ema", 58);
    freq.put("dK", 17);
    freq.put("dH", 9);
    freq.put("dI", 13);
    freq.put("dF", 13);
    freq.put("dG", 14);
    freq.put("dD", 13);
    freq.put("dE", 10);
    freq.put("dB", 8);
    freq.put("emh", 8);
    freq.put("dA", 11);
    freq.put("emu", 39);
    freq.put("emt", 51);
    freq.put("dZ", 11);
    freq.put("iló", 15);
    freq.put("ems", 33);
    freq.put("emr", 29);
    freq.put("dV", 14);
    freq.put("dW", 10);
    freq.put("dT", 17);
    freq.put("dU", 8);
    freq.put("dR", 8);
    freq.put("dS", 13);
    freq.put("dó ", 90);
    freq.put("dQ", 9);
    freq.put("w ", 270);
    freq.put(" I ", 68);
    freq.put("sű ", 11);
    freq.put("il ", 69);
    freq.put("xD ", 114);
    freq.put("cha", 68);
    freq.put("co ", 4812);
    freq.put("wg", 13);
    freq.put("wf", 9);
    freq.put(" Iz", 18);
    freq.put("dí", 156);
    freq.put("wc", 19);
    freq.put("wb", 16);
    freq.put("wa", 107);
    freq.put("dé", 502);
    freq.put(" Ip", 10);
    freq.put("wn", 34);
    freq.put("wm", 12);
    freq.put(" Is", 66);
    freq.put("wk", 19);
    freq.put("wj", 9);
    freq.put(" Iv", 14);
    freq.put("dá", 356);
    freq.put("ww", 55);
    freq.put("wv", 12);
    freq.put("dü", 78);
    freq.put("wt", 25);
    freq.put(" Il", 46);
    freq.put("wr", 17);
    freq.put(" In", 98);
    freq.put("wp", 24);
    freq.put("dö", 189);
    freq.put(" Ic", 11);
    freq.put(" Id", 32);
    freq.put("dó", 169);
    freq.put("wy", 15);
    freq.put(" Ig", 48);
    freq.put("wG", 11);
    freq.put("wF", 15);
    freq.put("wE", 11);
    freq.put("wD", 9);
    freq.put("wC", 13);
    freq.put("wB", 19);
    freq.put("wA", 9);
    freq.put("ila", 122);
    freq.put("ilo", 31);
    freq.put("ill", 373);
    freq.put("ilm", 157);
    freq.put("wK", 10);
    freq.put("ébe", 113);
    freq.put("wI", 9);
    freq.put("ili", 96);
    freq.put("wW", 11);
    freq.put("wV", 10);
    freq.put("ilt", 49);
    freq.put("wT", 15);
    freq.put("wS", 12);
    freq.put("wR", 11);
    freq.put("wQ", 12);
    freq.put("emü", 48);
    freq.put("ébr", 21);
    freq.put("com", 50);
    freq.put("wZ", 10);
    freq.put("wY", 18);
    freq.put("wX", 11);
    freq.put("ópa", 32);
    freq.put("che", 55);
    freq.put("gn ", 17);
    freq.put("ai ", 419);
    freq.put("niá", 17);
    freq.put("epü", 37);
    freq.put("squ", 15);
    freq.put("ait", 35);
    freq.put("gny", 35);
    freq.put("ais", 9);
    freq.put("air", 30);
    freq.put("aim", 33);
    freq.put("ail", 57);
    freq.put("ET ", 30);
    freq.put("ain", 86);
    freq.put("aii", 11);
    freq.put("aik", 8);
    freq.put("gne", 42);
    freq.put("aid", 33);
    freq.put("aig", 10);
    freq.put("gni", 31);
    freq.put("dő", 355);
    freq.put("ni ", 1924);
    freq.put("ópá", 13);
    freq.put("ep ", 38);
    freq.put("th ", 78);
    freq.put("nik", 151);
    freq.put("nii", 25);
    freq.put("nin", 232);
    freq.put("nil", 8);
    freq.put("nim", 29);
    freq.put("nib", 13);
    freq.put("nic", 40);
    freq.put("nia", 55);
    freq.put("nig", 20);
    freq.put("nie", 56);
    freq.put("niz", 9);
    freq.put("Y", 732);
    freq.put("ébő", 14);
    freq.put("nip", 10);
    freq.put("niv", 28);
    freq.put("nit", 57);
    freq.put("niu", 22);
    freq.put("ept", 44);
    freq.put("epu", 10);
    freq.put("epr", 17);
    freq.put("Rés", 13);
    freq.put("epp", 13);
    freq.put("tho", 85);
    freq.put("epo", 15);
    freq.put("epl", 40);
    freq.put("eph", 12);
    freq.put("epi", 35);
    freq.put("Rég", 10);
    freq.put("the", 183);
    freq.put("gné", 87);
    freq.put("epc", 10);
    freq.put("tha", 162);
    freq.put("epa", 14);
    freq.put("rn ", 28);
    freq.put("lc ", 16);
    freq.put("fó ", 12);
    freq.put("yká", 12);
    freq.put("Gaz", 12);
    freq.put("oph", 14);
    freq.put("yké", 36);
    freq.put("üsz", 12);
    freq.put("Gar", 13);
    freq.put("Gan", 8);
    freq.put("Gam", 9);
    freq.put("Gal", 15);
    freq.put("ykö", 10);
    freq.put("Gab", 16);
    freq.put("rni", 135);
    freq.put("rno", 27);
    freq.put("lcs", 117);
    freq.put("Tra", 18);
    freq.put("rna", 139);
    freq.put("rne", 82);
    freq.put("rny", 87);
    freq.put("plá", 19);
    freq.put("lco", 18);
    freq.put("fók", 8);
    freq.put("őzö", 9);
    freq.put("obá", 34);
    freq.put("őzé", 21);
    freq.put("fór", 8);
    freq.put("iOf", 10);
    freq.put("pl ", 24);
    freq.put("Lea", 8);
    freq.put("yka", 34);
    freq.put("pom", 37);
    freq.put("yke", 21);
    freq.put("Leg", 57);
    freq.put("Leh", 40);
    freq.put("yki", 9);
    freq.put("chr", 9);
    freq.put("yko", 15);
    freq.put("Len", 23);
    freq.put("Les", 12);
    freq.put("Let", 11);
    freq.put("yök", 17);
    freq.put("Lev", 18);
    freq.put("rné", 35);
    freq.put("pls", 11);
    freq.put(" j", 2460);
    freq.put("rná", 41);
    freq.put("ply", 9);
    freq.put("ple", 69);
    freq.put("pla", 57);
    freq.put("rnó", 8);
    freq.put("rnö", 12);
    freq.put("pli", 15);
    freq.put("obo", 47);
    freq.put("obl", 26);
    freq.put("obi", 59);
    freq.put("obe", 20);
    freq.put("őzt", 16);
    freq.put("oba", 63);
    freq.put(" nő", 87);
    freq.put("obt", 14);
    freq.put("obr", 11);
    freq.put("őze", 28);
    freq.put("túr", 34);
    freq.put("üü", 15);
    freq.put("olc", 77);
    freq.put("túl", 117);
    freq.put("wan", 11);
    freq.put("Bw", 16);
    freq.put("wai", 9);
    freq.put("háá", 9);
    freq.put("wat", 10);
    freq.put("ír ", 50);
    freq.put("war", 27);
    freq.put("DÓ ", 8);
    freq.put(" né", 530);
    freq.put("Íg", 31);
    freq.put("olk", 34);
    freq.put("kvá", 14);
    freq.put("Ím", 11);
    freq.put("xy ", 11);
    freq.put("tú ", 8);
    freq.put("Ír", 10);
    freq.put(" nö", 17);
    freq.put("írt", 132);
    freq.put("íru", 9);
    freq.put("Ön", 13);
    freq.put("írs", 15);
    freq.put("Ör", 11);
    freq.put("Ös", 13);
    freq.put("Öt", 17);
    freq.put("mto", 10);
    freq.put("írj", 59);
    freq.put("írd", 12);
    freq.put("íre", 53);
    freq.put("rnő", 9);
    freq.put("mta", 25);
    freq.put("chy", 8);
    freq.put("mte", 11);
    freq.put("üv", 83);
    freq.put("üt", 163);
    freq.put("ür", 63);
    freq.put("üs", 37);
    freq.put("kv ", 8);
    freq.put(" n ", 106);
    freq.put("üz", 77);
    freq.put("üg", 106);
    freq.put("üd", 26);
    freq.put("Sx", 8);
    freq.put("ün", 455);
    freq.put("ül", 1246);
    freq.put("üm", 16);
    freq.put("ük", 251);
    freq.put("üh", 11);
    freq.put("háh", 8);
    freq.put("hák", 10);
    freq.put("hál", 31);
    freq.put("hán", 80);
    freq.put("háb", 24);
    freq.put("mdo", 10);
    freq.put("ház", 159);
    freq.put("hár", 58);
    freq.put("hát", 331);
    freq.put(" ni", 247);
    freq.put(" nm", 12);
    freq.put(" no", 128);
    freq.put("kva", 18);
    freq.put(" na", 1258);
    freq.put("Sw", 20);
    freq.put(" ne", 3333);
    freq.put(" nd", 11);
    freq.put(" Üz", 15);
    freq.put(" ny", 479);
    freq.put("ü ", 14);
    freq.put(" np", 12);
    freq.put(" nu", 13);
    freq.put("Sk", 41);
    freq.put("plő", 18);
    freq.put("író", 32);
    freq.put("yib", 12);
    freq.put("írá", 37);
    freq.put("ohá", 16);
    freq.put("Új ", 76);
    freq.put("Sb", 9);
    freq.put("yvt", 9);
    freq.put("ume", 16);
    freq.put("szb", 29);
    freq.put("jöh", 18);
    freq.put("yva", 13);
    freq.put("ó ", 1845);
    freq.put("umb", 72);
    freq.put("Úja", 17);
    freq.put("umm", 8);
    freq.put("ibő", 22);
    freq.put("Újr", 13);
    freq.put("óz", 115);
    freq.put("EO ", 9);
    freq.put("eké", 25);
    freq.put("ós", 233);
    freq.put("ór", 343);
    freq.put("óp", 62);
    freq.put("ígé", 18);
    freq.put("óv", 171);
    freq.put("RY ", 9);
    freq.put("ót", 379);
    freq.put("gus", 32);
    freq.put("p", 13393);
    freq.put("ói", 72);
    freq.put("óh", 30);
    freq.put("yv ", 37);
    freq.put("ón", 162);
    freq.put("óm", 71);
    freq.put("gut", 12);
    freq.put("óc", 26);
    freq.put("ób", 232);
    freq.put("óa", 31);
    freq.put("óg", 88);
    freq.put("óf", 53);
    freq.put("óe", 9);
    freq.put("ód", 187);
    freq.put("OK ", 40);
    freq.put("htt", 4817);
    freq.put("szs", 38);
    freq.put("IN ", 8);
    freq.put("Pé", 36);
    freq.put("vőr", 18);
    freq.put("ek ", 2614);
    freq.put("vőh", 9);
    freq.put("yik", 291);
    freq.put("ht ", 31);
    freq.put("egá", 40);
    freq.put("eko", 50);
    freq.put("ekn", 63);
    freq.put("ekl", 54);
    freq.put("ekk", 118);
    freq.put("eki", 173);
    freq.put("ekh", 16);
    freq.put("óó", 68);
    freq.put("eke", 974);
    freq.put("ekc", 15);
    freq.put("ekb", 35);
    freq.put("eka", 90);
    freq.put("Mos", 106);
    freq.put("óé", 17);
    freq.put("ekv", 20);
    freq.put("eku", 29);
    freq.put("ekt", 118);
    freq.put("eks", 39);
    freq.put("ekr", 53);
    freq.put("uzi", 16);
    freq.put("uza", 11);
    freq.put("uzu", 11);
    freq.put("Mot", 10);
    freq.put("uzs", 39);
    freq.put(" Ka", 155);
    freq.put(" Kf", 10);
    freq.put(" Ke", 146);
    freq.put(" Ki", 238);
    freq.put(" Ko", 107);
    freq.put(" Kl", 31);
    freq.put(" Kr", 47);
    freq.put(" Ku", 44);
    freq.put("ca ", 72);
    freq.put(" im", 130);
    freq.put("ámí", 34);
    freq.put("F", 1338);
    freq.put("ámá", 24);
    freq.put("uz ", 9);
    freq.put("fb ", 30);
    freq.put("sőb", 28);
    freq.put("yiv", 8);
    freq.put("ibi", 19);
    freq.put(" K ", 39);
    freq.put("ibl", 18);
    freq.put("ibo", 23);
    freq.put("cas", 22);
    freq.put("car", 30);
    freq.put("ibb", 20);
    freq.put("ibe", 60);
    freq.put("cat", 34);
    freq.put("cak", 9);
    freq.put("cai", 11);
    freq.put("can", 40);
    freq.put("cam", 11);
    freq.put("cal", 27);
    freq.put("ghí", 14);
    freq.put(" ig", 397);
    freq.put("cad", 9);
    freq.put("uzí", 8);
    freq.put("ám ", 250);
    freq.put("spr", 11);
    freq.put("spi", 12);
    freq.put("spo", 75);
    freq.put("spa", 43);
    freq.put("dxd", 10);
    freq.put("spe", 36);
    freq.put(" Ká", 29);
    freq.put(" Ké", 89);
    freq.put(" Kí", 17);
    freq.put(" Kö", 139);
    freq.put(" Kü", 18);
    freq.put("ámi", 8);
    freq.put("áml", 11);
    freq.put("ámo", 124);
    freq.put("áma", 60);
    freq.put("aol", 15);
    freq.put("aor", 9);
    freq.put("ámp", 16);
    freq.put("ámr", 10);
    freq.put("ámu", 10);
    freq.put("ght", 38);
    freq.put("ghu", 9);
    freq.put("zóv", 79);
    freq.put("ÉS ", 24);
    freq.put("ibí", 9);
    freq.put("zór", 21);
    freq.put("zós", 8);
    freq.put("ibá", 31);
    freq.put("djé", 14);
    freq.put("zód", 20);
    freq.put("nné", 89);
    freq.put("ER ", 20);
    freq.put("gha", 70);
    freq.put("zób", 11);
    freq.put("zól", 114);
    freq.put("zón", 9);
    freq.put("ibó", 10);
    freq.put("ghi", 12);
    freq.put("zók", 16);
    freq.put("Rt", 12);
    freq.put("Ru", 27);
    freq.put("Rv", 13);
    freq.put("Rw", 12);
    freq.put("Rp", 11);
    freq.put("Rq", 8);
    freq.put("Rr", 12);
    freq.put("Rs", 10);
    freq.put("Jav", 10);
    freq.put("Chi", 12);
    freq.put("Rx", 8);
    freq.put("Ry", 23);
    freq.put("Rz", 13);
    freq.put("Rd", 10);
    freq.put("Re", 261);
    freq.put("Rf", 11);
    freq.put("mbo", 37);
    freq.put("Jaj", 16);
    freq.put("Ra", 64);
    freq.put("Rb", 11);
    freq.put("Rc", 9);
    freq.put("Rl", 13);
    freq.put("Rm", 10);
    freq.put("Rn", 10);
    freq.put("Ro", 153);
    freq.put("Rh", 12);
    freq.put("Ri", 69);
    freq.put("eó", 290);
    freq.put("Rk", 9);
    freq.put("Zso", 29);
    freq.put("mbe", 402);
    freq.put("xdx", 10);
    freq.put("sok", 457);
    freq.put("nol", 20);
    freq.put("nom", 135);
    freq.put("non", 33);
    freq.put("tje", 16);
    freq.put("nok", 132);
    freq.put("nod", 19);
    freq.put("noe", 8);
    freq.put("rlá", 24);
    freq.put("mba", 179);
    freq.put("lmé", 40);
    freq.put("gbe", 55);
    freq.put("R ", 213);
    freq.put("soo", 20);
    freq.put("noz", 14);
    freq.put("not", 26);
    freq.put("lmá", 38);
    freq.put("nov", 26);
    freq.put("now", 26);
    freq.put("Ja ", 30);
    freq.put("nos", 137);
    freq.put("Szé", 62);
    freq.put("Szí", 20);
    freq.put("órh", 15);
    freq.put("Szá", 20);
    freq.put("Szü", 14);
    freq.put("gbo", 12);
    freq.put("zá ", 41);
    freq.put("Szó", 18);
    freq.put("Szö", 9);
    freq.put("sot", 23);
    freq.put("em", 7018);
    freq.put("el", 7666);
    freq.put("eo", 165);
    freq.put("en", 7279);
    freq.put("ei", 415);
    freq.put("eh", 818);
    freq.put("ek", 4643);
    freq.put("ej", 573);
    freq.put("ee", 807);
    freq.put("ed", 1913);
    freq.put("eg", 7069);
    freq.put("ef", 280);
    freq.put("ea", 448);
    freq.put("rl ", 47);
    freq.put("ec", 446);
    freq.put("eb", 671);
    freq.put("műs", 38);
    freq.put("ey", 117);
    freq.put("Rá", 38);
    freq.put("ez", 2600);
    freq.put("eu", 90);
    freq.put("et", 6616);
    freq.put("ew", 77);
    freq.put("ev", 582);
    freq.put("eq", 15);
    freq.put("Ré", 32);
    freq.put("es", 4666);
    freq.put("er", 5810);
    freq.put("eM", 37);
    freq.put("eL", 11);
    freq.put("eO", 12);
    freq.put("eI", 13);
    freq.put("eH", 21);
    freq.put("eK", 11);
    freq.put("eJ", 13);
    freq.put("eE", 8);
    freq.put("eD", 27);
    freq.put("eG", 16);
    freq.put("eF", 14);
    freq.put("eA", 17);
    freq.put("eC", 16);
    freq.put("eB", 17);
    freq.put("etá", 9);
    freq.put("eY", 13);
    freq.put("eX", 9);
    freq.put("eZ", 11);
    freq.put("eU", 25);
    freq.put("eT", 28);
    freq.put("eW", 30);
    freq.put("eV", 13);
    freq.put("eQ", 12);
    freq.put("eP", 11);
    freq.put("eS", 18);
    freq.put("eR", 22);
    freq.put("tjá", 54);
    freq.put("mű ", 40);
    freq.put("rli", 18);
    freq.put("rle", 47);
    freq.put("rld", 9);
    freq.put("rla", 59);
    freq.put("e ", 7633);
    freq.put("lmi", 51);
    freq.put("lmj", 9);
    freq.put("lmk", 9);
    freq.put("lmo", 109);
    freq.put("lma", 202);
    freq.put("lme", 216);
    freq.put("Szi", 75);
    freq.put("Szo", 38);
    freq.put("Sza", 97);
    freq.put("Sze", 230);
    freq.put("óró", 12);
    freq.put("űbb", 8);
    freq.put("fc", 13);
    freq.put("lla", 428);
    freq.put("Szt", 8);
    freq.put("Szu", 10);
    freq.put("zan", 84);
    freq.put("xk", 19);
    freq.put("xh", 9);
    freq.put("xi", 59);
    freq.put("xn", 13);
    freq.put("xo", 36);
    freq.put("xl", 12);
    freq.put("xm", 14);
    freq.put("xb", 15);
    freq.put("xc", 18);
    freq.put("zad", 38);
    freq.put("xa", 45);
    freq.put("xf", 23);
    freq.put("xg", 9);
    freq.put("xd", 307);
    freq.put("xe", 47);
    freq.put("xx", 66);
    freq.put("xy", 22);
    freq.put("zaz", 27);
    freq.put("són", 11);
    freq.put("úcs", 24);
    freq.put("xr", 16);
    freq.put("xs", 23);
    freq.put("xp", 29);
    freq.put("xq", 8);
    freq.put("xv", 10);
    freq.put("xw", 13);
    freq.put("xt", 44);
    freq.put("xu", 37);
    freq.put("xJ", 12);
    freq.put("xK", 16);
    freq.put("xN", 8);
    freq.put("xO", 9);
    freq.put("xL", 14);
    freq.put("xM", 13);
    freq.put("xB", 19);
    freq.put("yil", 62);
    freq.put("xA", 13);
    freq.put("xF", 11);
    freq.put("xD", 318);
    freq.put("xE", 8);
    freq.put("xZ", 13);
    freq.put("yit", 122);
    freq.put("xX", 9);
    freq.put("xY", 11);
    freq.put("yis", 72);
    freq.put("yir", 225);
    freq.put("xR", 18);
    freq.put("xS", 8);
    freq.put("xP", 13);
    freq.put("xQ", 16);
    freq.put("xV", 14);
    freq.put("xW", 12);
    freq.put("xT", 12);
    freq.put("xU", 9);
    freq.put("a", 60493);
    freq.put("szá", 670);
    freq.put("egz", 18);
    freq.put("x ", 410);
    freq.put("egy", 2661);
    freq.put("za ", 234);
    freq.put("pni", 29);
    freq.put("pna", 15);
    freq.put("pne", 8);
    freq.put("szú", 52);
    freq.put("yi ", 210);
    freq.put("Pc", 10);
    freq.put("mró", 12);
    freq.put("egs", 102);
    freq.put("egr", 61);
    freq.put("OP ", 12);
    freq.put("kyp", 11);
    freq.put("Of ", 9);
    freq.put("zaé", 12);
    freq.put("szó", 285);
    freq.put("Pho", 52);
    freq.put("egj", 157);
    freq.put("szö", 220);
    freq.put("egi", 198);
    freq.put("egh", 95);
    freq.put("ego", 82);
    freq.put("úú ", 29);
    freq.put("egn", 268);
    freq.put("Off", 37);
    freq.put("egm", 47);
    freq.put("lmű", 13);
    freq.put("fG", 10);
    freq.put("bír", 85);
    freq.put("egc", 36);
    freq.put("bít", 9);
    freq.put("egb", 63);
    freq.put("bíz", 26);
    freq.put("ega", 159);
    freq.put("uss", 57);
    freq.put("sóg", 8);
    freq.put("egg", 201);
    freq.put("ò", 8);
    freq.put("ege", 416);
    freq.put("mre", 30);
    freq.put("egd", 21);
    freq.put("mra", 47);
    freq.put("Web", 8);
    freq.put(" p ", 48);
    freq.put("NB ", 10);
    freq.put("jtó", 33);
    freq.put("jté", 16);
    freq.put("jtá", 9);
    freq.put("ytá", 22);
    freq.put(" ps", 16);
    freq.put(" pr", 295);
    freq.put(" pu", 60);
    freq.put(" pt", 10);
    freq.put(" pc", 14);
    freq.put(" pa", 296);
    freq.put(" pf", 11);
    freq.put(" pe", 366);
    freq.put(" pi", 228);
    freq.put(" ph", 17);
    freq.put(" po", 314);
    freq.put(" pm", 8);
    freq.put(" pl", 108);
    freq.put("uva", 9);
    freq.put("zga", 35);
    freq.put("jtu", 10);
    freq.put("jts", 14);
    freq.put("yto", 26);
    freq.put("jto", 29);
    freq.put(" Mű", 16);
    freq.put("jte", 68);
    freq.put("yte", 16);
    freq.put("jta", 60);
    freq.put("yta", 79);
    freq.put(" pó", 30);
    freq.put("LD ", 11);
    freq.put(" pö", 16);
    freq.put(" Új", 113);
    freq.put(" Úg", 36);
    freq.put(" pá", 169);
    freq.put("Kri", 35);
    freq.put(" pé", 114);
    freq.put(" Úr", 10);
    freq.put("EM ", 52);
    freq.put("vul", 15);
    freq.put("gba", 70);
    freq.put("jt ", 53);
    freq.put("yt ", 102);
    freq.put("UF ", 12);
    freq.put(" Má", 133);
    freq.put("kín", 41);
    freq.put(" Mé", 64);
    freq.put("ei ", 139);
    freq.put("kít", 21);
    freq.put(" Mó", 14);
    freq.put(" Mú", 8);
    freq.put("lle", 435);
    freq.put("eis", 30);
    freq.put("eir", 11);
    freq.put("eit", 33);
    freq.put("éd ", 52);
    freq.put("eig", 19);
    freq.put("eik", 14);
    freq.put("eim", 46);
    freq.put("eil", 8);
    freq.put("ein", 67);
    freq.put("yi", 1073);
    freq.put("gbí", 11);
    freq.put("kí", 178);
    freq.put("ced", 16);
    freq.put("SD ", 14);
    freq.put("twi", 81);
    freq.put("ceb", 114);
    freq.put(" Me", 369);
    freq.put(" Ma", 547);
    freq.put(" Mc", 15);
    freq.put(" Mo", 234);
    freq.put(" Mi", 482);
    freq.put("ndü", 10);
    freq.put(" Mu", 63);
    freq.put(" Mr", 29);
    freq.put(" Ms", 9);
    freq.put("mbó", 25);
    freq.put("cc ", 49);
    freq.put("cel", 42);
    freq.put("cek", 29);
    freq.put("ux ", 25);
    freq.put("ceh", 13);
    freq.put("lJu", 8);
    freq.put("tli", 11);
    freq.put(" M ", 68);
    freq.put("odj", 23);
    freq.put("ccs", 72);
    freq.put("cco", 8);
    freq.put("cet", 26);
    freq.put("cci", 17);
    freq.put("cce", 53);
    freq.put("cca", 11);
    freq.put("AI ", 14);
    freq.put("ccc", 12);
    freq.put("áa", 36);
    freq.put("ác", 236);
    freq.put("áb", 753);
    freq.put("ád", 277);
    freq.put("ág", 867);
    freq.put("áf", 12);
    freq.put("ái", 56);
    freq.put("am ", 1382);
    freq.put("ák", 546);
    freq.put("áj", 420);
    freq.put("ám", 619);
    freq.put("ál", 2600);
    freq.put("án", 1994);
    freq.put("áp", 66);
    freq.put("ás", 1966);
    freq.put("ár", 3004);
    freq.put("át", 1932);
    freq.put("áv", 199);
    freq.put("ucs", 22);
    freq.put("áz", 465);
    freq.put("Her", 10);
    freq.put("véd", 54);
    freq.put("yw", 21);
    freq.put("cb", 37);
    freq.put("ff ", 27);
    freq.put("áss", 72);
    freq.put("á ", 284);
    freq.put("psi", 12);
    freq.put("amm", 40);
    freq.put("aml", 13);
    freq.put("ásu", 24);
    freq.put("ást", 169);
    freq.put("ama", 194);
    freq.put("ász", 128);
    freq.put("amb", 57);
    freq.put("ame", 192);
    freq.put("amf", 8);
    freq.put("psz", 63);
    freq.put("ásb", 38);
    freq.put("ása", 121);
    freq.put("LY ", 9);
    freq.put("ásf", 16);
    freq.put("ásk", 42);
    freq.put("amp", 51);
    freq.put("ási", 142);
    freq.put("ásh", 21);
    freq.put("áso", 215);
    freq.put("ásn", 35);
    freq.put("amH", 8);
    freq.put("srá", 27);
    freq.put("ótá", 22);
    freq.put("dzé", 19);
    freq.put("gju", 9);
    freq.put("gjo", 105);
    freq.put("t", 61531);
    freq.put("ótó", 8);
    freq.put("gje", 44);
    freq.put("gja", 44);
    freq.put("áá", 230);
    freq.put("uca", 10);
    freq.put("Vál", 15);
    freq.put("áé", 23);
    freq.put("áí", 10);
    freq.put("yú ", 9);
    freq.put("Hel", 32);
    freq.put("nm ", 8);
    freq.put("Vár", 21);
    freq.put("szű", 19);
    freq.put("ót ", 224);
    freq.put("édo", 8);
    freq.put("cw", 11);
    freq.put("uci", 23);
    freq.put("uch", 11);
    freq.put("psé", 22);
    freq.put("amí", 16);
    freq.put("amá", 42);
    freq.put("ásá", 118);
    freq.put("amú", 109);
    freq.put("nma", 25);
    freq.put("yúj", 11);
    freq.put("yúl", 9);
    freq.put("éde", 80);
    freq.put("óta", 91);
    freq.put("sre", 43);
    freq.put("gjö", 9);
    freq.put("tfő", 48);
    freq.put("óto", 15);
    freq.put("sro", 11);
    freq.put("yT", 13);
    freq.put("dzs", 54);
    freq.put("ifj", 8);
    freq.put("Gez", 23);
    freq.put("gjá", 24);
    freq.put("Adr", 17);
    freq.put("Add", 13);
    freq.put("Ada", 17);
    freq.put("lob", 12);
    freq.put("loc", 12);
    freq.put("Ide", 12);
    freq.put("lof", 8);
    freq.put("Hán", 9);
    freq.put("lod", 54);
    freq.put("eje", 199);
    freq.put("lon", 92);
    freq.put("loo", 17);
    freq.put("lol", 69);
    freq.put("esó", 21);
    freq.put("lor", 48);
    freq.put("los", 72);
    freq.put("lop", 21);
    freq.put("lov", 74);
    freq.put("low", 45);
    freq.put("lot", 97);
    freq.put("lou", 24);
    freq.put("loz", 24);
    freq.put("rju", 20);
    freq.put("J", 1051);
    freq.put("rje", 49);
    freq.put("rja", 61);
    freq.put("rjo", 9);
    freq.put(" su", 104);
    freq.put("Gei", 9);
    freq.put("lo ", 56);
    freq.put("sző", 25);
    freq.put("Geo", 8);
    freq.put("üüü", 12);
    freq.put("Ház", 10);
    freq.put(" si", 232);
    freq.put("Est", 18);
    freq.put("Esz", 28);
    freq.put("yoo", 13);
    freq.put("Lam", 8);
    freq.put("Lan", 10);
    freq.put("Mun", 17);
    freq.put("yok", 485);
    freq.put("Lak", 8);
    freq.put("Lad", 10);
    freq.put("yod", 10);
    freq.put("yob", 49);
    freq.put("Lac", 11);
    freq.put("yoz", 35);
    freq.put("Lau", 8);
    freq.put("you", 89);
    freq.put("yot", 27);
    freq.put("yos", 85);
    freq.put("yor", 83);
    freq.put("Las", 23);
    freq.put("lga", 134);
    freq.put("iza", 22);
    freq.put("rjü", 11);
    freq.put("rjú", 25);
    freq.put("dző", 11);
    freq.put("srő", 15);
    freq.put("rjá", 37);
    freq.put("Es ", 14);
    freq.put("izg", 32);
    freq.put("yo ", 15);
    freq.put("Bro", 17);
    freq.put("IK ", 8);
    freq.put("Bri", 24);
    freq.put("Bre", 11);
    freq.put("Bra", 11);
    freq.put("pő", 52);
    freq.put("mp ", 14);
    freq.put("töz", 33);
    freq.put("töt", 97);
    freq.put("uc ", 8);
    freq.put("tös", 9);
    freq.put("tör", 221);
    freq.put("töm", 32);
    freq.put("töl", 127);
    freq.put("tön", 23);
    freq.put("tök", 120);
    freq.put("töb", 164);
    freq.put("áá ", 29);
    freq.put("gdö", 10);
    freq.put(" rö", 63);
    freq.put(" ró", 78);
    freq.put("gün", 14);
    freq.put("mpo", 20);
    freq.put("mpl", 40);
    freq.put(" rú", 9);
    freq.put(" rá", 255);
    freq.put("mps", 9);
    freq.put(" ré", 310);
    freq.put("áár", 9);
    freq.put("yé", 194);
    freq.put(" r ", 52);
    freq.put("puk", 11);
    freq.put("pud", 8);
    freq.put(" ru", 52);
    freq.put("fű", 31);
    freq.put("HU ", 24);
    freq.put("mpá", 25);
    freq.put("egő", 22);
    freq.put(" re", 732);
    freq.put(" ra", 289);
    freq.put("mpó", 11);
    freq.put(" ro", 298);
    freq.put(" ri", 87);
    freq.put("fő", 142);
    freq.put("ááá", 151);
    freq.put("TS ", 8);
    freq.put("yst", 8);
    freq.put("jra", 73);
    freq.put("jro", 8);
    freq.put("cé", 83);
    freq.put("put", 9);
    freq.put(" Fr", 57);
    freq.put("S ", 339);
    freq.put("yó", 75);
    freq.put(" Ft", 87);
    freq.put("cí", 85);
    freq.put("tyá", 79);
    freq.put("vee", 27);
    freq.put("yö", 129);
    freq.put("cá", 40);
    freq.put("Sz", 634);
    freq.put("Sy", 20);
    freq.put("fó", 39);
    freq.put("fö", 102);
    freq.put("Ss", 21);
    freq.put("Sr", 13);
    freq.put("fú", 24);
    freq.put("Sp", 66);
    freq.put("fü", 109);
    freq.put("Sv", 16);
    freq.put("Su", 50);
    freq.put("St", 144);
    freq.put("FC ", 11);
    freq.put("fá", 124);
    freq.put("Si", 84);
    freq.put("Sh", 62);
    freq.put("So", 95);
    freq.put("Sn", 25);
    freq.put("Sm", 21);
    freq.put("Sl", 17);
    freq.put("Sc", 43);
    freq.put("fé", 316);
    freq.put("Sa", 137);
    freq.put("Sf", 13);
    freq.put("Se", 91);
    freq.put("Sd", 15);
    freq.put("egú", 33);
    freq.put("egó", 9);
    freq.put("egö", 11);
    freq.put("EK ", 44);
    freq.put("egé", 256);
    freq.put("egí", 87);
    freq.put("RE ", 14);
    freq.put("Fér", 11);
    freq.put("jrá", 14);
    freq.put("f ", 242);
    freq.put("hhe", 19);
    freq.put("lre", 32);
    freq.put("hhh", 27);
    freq.put("hho", 21);
    freq.put("Fél", 11);
    freq.put("ob ", 28);
    freq.put("eg ", 1344);
    freq.put("fq", 12);
    freq.put("fr", 197);
    freq.put("fs", 17);
    freq.put("━━━", 39);
    freq.put("fu", 209);
    freq.put("fw", 13);
    freq.put("fx", 15);
    freq.put("fy", 25);
    freq.put("fz", 11);
    freq.put("of ", 31);
    freq.put("fa", 518);
    freq.put("fb", 74);
    freq.put("hh ", 89);
    freq.put("fd", 12);
    freq.put("fe", 1391);
    freq.put("ff", 209);
    freq.put("fg", 28);
    freq.put("fh", 15);
    freq.put("fi", 782);
    freq.put("fj", 21);
    freq.put("fk", 12);
    freq.put("fl", 103);
    freq.put("fm", 22);
    freq.put("fo", 1273);
    freq.put("fP", 13);
    freq.put("fQ", 9);
    freq.put("fR", 16);
    freq.put("fS", 10);
    freq.put(" rő", 12);
    freq.put("fV", 10);
    freq.put("fW", 16);
    freq.put("fX", 11);
    freq.put("fY", 10);
    freq.put("fZ", 9);
    freq.put("egp", 32);
    freq.put("egv", 110);
    freq.put("egu", 30);
    freq.put("egt", 147);
    freq.put("egk", 167);
    freq.put("fA", 9);
    freq.put("fB", 9);
    freq.put("fC", 13);
    freq.put("fD", 8);
    freq.put("fE", 11);
    freq.put("fF", 10);
    freq.put("ö", 5226);
    freq.put("fH", 9);
    freq.put("fI", 10);
    freq.put("fJ", 8);
    freq.put("CA ", 9);
    freq.put("fL", 8);
    freq.put("egf", 84);
    freq.put("fN", 13);
    freq.put("fO", 12);
    freq.put("ce ", 102);
    freq.put("y ", 6168);
    freq.put("zgu", 13);
    freq.put("ffl", 16);
    freq.put("ffi", 80);
    freq.put("fff", 36);
    freq.put("ffe", 24);
    freq.put("uve", 12);
    freq.put(" On", 51);
    freq.put(" Ol", 69);
    freq.put(" Ok", 30);
    freq.put(" Oh", 12);
    freq.put(" Of", 26);
    freq.put(" Ob", 9);
    freq.put("lya", 423);
    freq.put("gül", 22);
    freq.put(" Ot", 22);
    freq.put(" Ou", 9);
    freq.put(" Or", 87);
    freq.put(" Os", 16);
    freq.put(" Op", 24);
    freq.put("asó", 13);
    freq.put("yh", 123);
    freq.put("yk", 152);
    freq.put("yj", 66);
    freq.put("ym", 112);
    freq.put("yl", 248);
    freq.put("yo", 1534);
    freq.put("yn", 159);
    freq.put("ya", 1392);
    freq.put("cen", 75);
    freq.put("yc", 33);
    freq.put("yb", 155);
    freq.put("ye", 2339);
    freq.put("yd", 61);
    freq.put("yg", 31);
    freq.put("yf", 61);
    freq.put("yy", 44);
    freq.put("yx", 15);
    freq.put("asá", 92);
    freq.put("yz", 129);
    freq.put("ces", 54);
    freq.put("cer", 64);
    freq.put("cep", 19);
    freq.put("yq", 11);
    freq.put("yp", 65);
    freq.put("ys", 329);
    freq.put("yr", 145);
    freq.put("yu", 344);
    freq.put("yt", 273);
    freq.put("así", 8);
    freq.put("yv", 159);
    freq.put("yI", 8);
    freq.put("ifu", 12);
    freq.put("yK", 16);
    freq.put("yJ", 11);
    freq.put("yM", 13);
    freq.put("yL", 15);
    freq.put("yO", 8);
    freq.put("yN", 24);
    freq.put("yA", 25);
    freq.put("MI ", 20);
    freq.put("yC", 19);
    freq.put("yB", 19);
    freq.put("yD", 15);
    freq.put(" O ", 110);
    freq.put("yY", 9);
    freq.put("ife", 37);
    freq.put("iff", 10);
    freq.put("yZ", 13);
    freq.put("édi", 30);
    freq.put("yQ", 9);
    freq.put("yP", 14);
    freq.put("yS", 16);
    freq.put("ifo", 28);
    freq.put("yU", 13);
    freq.put("ifi", 26);
    freq.put("yW", 15);
    freq.put("Eng", 19);
    freq.put("pu ", 8);
    freq.put("Enn", 12);
    freq.put("as ", 299);
    freq.put("eá", 53);
    freq.put("ass", 279);
    freq.put("asr", 21);
    freq.put("pun", 21);
    freq.put("asp", 11);
    freq.put("yí", 63);
    freq.put("ve ", 282);
    freq.put("ast", 117);
    freq.put("yá", 373);
    freq.put("asz", 716);
    freq.put("asc", 14);
    freq.put("asa", 61);
    freq.put("yú", 38);
    freq.put("yü", 95);
    freq.put("ase", 28);
    freq.put("asd", 32);
    freq.put("ask", 30);
    freq.put("asi", 41);
    freq.put("ash", 63);
    freq.put("aso", 79);
    freq.put("asn", 42);
    freq.put("asm", 15);
    freq.put("asl", 11);
    freq.put("gdí", 14);
    freq.put("ion", 164);
    freq.put("Ima", 8);
    freq.put("Cla", 8);
    freq.put("nc ", 106);
    freq.put("Clu", 10);
    freq.put("st ", 1053);
    freq.put("liá", 33);
    freq.put("özz", 8);
    freq.put("dt ", 122);
    freq.put("lió", 43);
    freq.put("ncz", 11);
    freq.put("tfe", 10);

    init2();
  }
  private static void init2() {
    
    freq.put("ncs", 466);
    freq.put("nch", 25);
    freq.put("nci", 78);
    freq.put("ofa", 9);
    freq.put("eü", 14);
    freq.put("nco", 39);
    freq.put("yű", 80);
    freq.put("nca", 9);
    freq.put("ncb", 11);
    freq.put("nce", 174);
    freq.put("óvo", 8);
    freq.put("stf", 8);
    freq.put("dto", 8);
    freq.put("sta", 215);
    freq.put("stb", 21);
    freq.put("óvi", 8);
    freq.put("stl", 11);
    freq.put("stm", 24);
    freq.put("dta", 303);
    freq.put("óve", 10);
    freq.put("sth", 15);
    freq.put("sti", 121);
    freq.put("dte", 100);
    freq.put("óva", 125);
    freq.put("stu", 9);
    freq.put("stv", 24);
    freq.put("stp", 8);
    freq.put("str", 83);
    freq.put("yő", 59);
    freq.put("sty", 21);
    freq.put("dtu", 24);
    freq.put("Imá", 14);
    freq.put("Gol", 9);
    freq.put("Goo", 32);
    freq.put("ka ", 372);
    freq.put("tfo", 20);
    freq.put("lid", 15);
    freq.put("Nik", 16);
    freq.put("lif", 12);
    freq.put("lig", 76);
    freq.put("Nin", 37);
    freq.put("lia", 62);
    freq.put("lib", 54);
    freq.put("lic", 38);
    freq.put("lil", 51);
    freq.put("Nic", 22);
    freq.put("lin", 303);
    freq.put("Nia", 45);
    freq.put("lih", 8);
    freq.put("Nig", 10);
    freq.put("lij", 9);
    freq.put("lik", 145);
    freq.put("lit", 90);
    freq.put("liu", 18);
    freq.put("liv", 61);
    freq.put("lip", 47);
    freq.put("lir", 25);
    freq.put("lis", 271);
    freq.put("liz", 37);
    freq.put("húz", 43);
    freq.put("kac", 25);
    freq.put("kab", 16);
    freq.put("kaa", 24);
    freq.put("kag", 8);
    freq.put("kaf", 9);
    freq.put("kad", 87);
    freq.put("kak", 28);
    freq.put("kaj", 45);
    freq.put("kai", 108);
    freq.put("kah", 26);
    freq.put("kan", 75);
    freq.put("kam", 80);
    freq.put("kal", 215);
    freq.put("kas", 55);
    freq.put("kar", 378);
    freq.put("kap", 325);
    freq.put("kav", 18);
    freq.put("Thi", 18);
    freq.put("kat", 459);
    freq.put("iAu", 12);
    freq.put("iAt", 8);
    freq.put("kay", 11);
    freq.put("rhe", 84);
    freq.put("ögé", 10);
    freq.put("dté", 11);
    freq.put("li ", 310);
    freq.put("stá", 72);
    freq.put("stí", 13);
    freq.put("dtá", 26);
    freq.put("sté", 56);
    freq.put("óvá", 15);
    freq.put("stó", 12);
    freq.put("Bp ", 8);
    freq.put("tw ", 20);
    freq.put("rhá", 26);
    freq.put("yma", 24);
    freq.put("ra ", 1305);
    freq.put("ymi", 9);
    freq.put("ox ", 21);
    freq.put("ymo", 8);
    freq.put("dup", 11);
    freq.put(" Ád", 10);
    freq.put("ste", 389);
    freq.put(" Ál", 43);
    freq.put(" tű", 65);
    freq.put(" Ár", 17);
    freq.put(" Át", 17);
    freq.put("oxu", 8);
    freq.put(" tő", 57);
    freq.put("oxo", 10);
    freq.put("x", 2002);
    freq.put("dur", 40);
    freq.put("lóg", 31);
    freq.put("sto", 56);
    freq.put("bé ", 12);
    freq.put("lód", 40);
    freq.put("ydi", 10);
    freq.put("wor", 16);
    freq.put("ymá", 45);
    freq.put("wol", 17);
    freq.put("woo", 11);
    freq.put("Pla", 15);
    freq.put("ső", 316);
    freq.put("Dél", 10);
    freq.put("zök", 12);
    freq.put("yde", 11);
    freq.put("bék", 13);
    freq.put("béd", 16);
    freq.put("adr", 56);
    freq.put("lób", 19);
    freq.put("bér", 22);
    freq.put("zön", 111);
    freq.put("Wan", 16);
    freq.put("Wal", 20);
    freq.put("Gon", 15);
    freq.put("War", 17);
    freq.put(" t ", 4982);
    freq.put("ade", 67);
    freq.put("lóa", 10);
    freq.put(" tz", 12);
    freq.put(" ty", 8);
    freq.put(" tw", 126);
    freq.put(" tv", 30);
    freq.put(" tu", 764);
    freq.put(" ts", 12);
    freq.put(" tr", 106);
    freq.put("N", 1719);
    freq.put(" to", 302);
    freq.put("zös", 37);
    freq.put(" ti", 200);
    freq.put("ája", 56);
    freq.put(" te", 1197);
    freq.put("esí", 71);
    freq.put(" ta", 684);
    freq.put("iya", 10);
    freq.put("ájd", 13);
    freq.put("gsá", 19);
    freq.put(" tL", 8);
    freq.put("adh", 16);
    freq.put("gsé", 17);
    freq.put("zöt", 76);
    freq.put("diá", 27);
    freq.put("gs ", 15);
    freq.put("vy ", 11);
    freq.put("õ ", 11);
    freq.put(" tü", 31);
    freq.put(" tú", 121);
    freq.put("lie", 32);
    freq.put("nó ", 15);
    freq.put(" tö", 432);
    freq.put("yH ", 10);
    freq.put(" tó", 35);
    freq.put(" tí", 11);
    freq.put(" té", 256);
    freq.put("FA ", 9);
    freq.put(" tá", 200);
    freq.put("pül", 48);
    freq.put("gsz", 138);
    freq.put("gse", 18);
    freq.put("lim", 48);
    freq.put("dió", 46);
    freq.put("lio", 8);
    freq.put("wBa", 8);
    freq.put("Más", 14);
    freq.put("Már", 97);
    freq.put("Mát", 8);
    freq.put("Máj", 10);
    freq.put("iph", 12);
    freq.put("lóv", 9);
    freq.put("hús", 14);
    freq.put("nDa", 8);
    freq.put("efo", 117);
    freq.put("ipo", 29);
    freq.put("tut", 40);
    freq.put("gr", 429);
    freq.put("ipr", 13);
    freq.put("eey", 9);
    freq.put("eet", 88);
    freq.put("ipp", 39);
    freq.put("ees", 34);
    freq.put("efe", 48);
    freq.put("eem", 25);
    freq.put("eel", 23);
    freq.put("een", 49);
    freq.put("eeh", 8);
    freq.put("eek", 27);
    freq.put("idé", 63);
    freq.put("eee", 248);
    freq.put("eed", 23);
    freq.put("idá", 10);
    freq.put("mhe", 12);
    freq.put("ipt", 11);
    freq.put("ru ", 18);
    freq.put("ohe", 10);
    freq.put(" Ql", 8);
    freq.put("id ", 114);
    freq.put("ruk", 27);
    freq.put("ruh", 38);
    freq.put("run", 42);
    freq.put("rul", 89);
    freq.put("rum", 36);
    freq.put("ruc", 13);
    freq.put("rug", 13);
    freq.put("rue", 14);
    freq.put("ruz", 22);
    freq.put("sim", 67);
    freq.put("rus", 44);
    freq.put("rut", 21);
    freq.put("krá", 9);
    freq.put("ncé", 11);
    freq.put(" Q ", 29);
    freq.put("ido", 48);
    freq.put("idi", 35);
    freq.put("idd", 18);
    freq.put("ide", 637);
    freq.put("ida", 32);
    freq.put("Elk", 15);
    freq.put("Tü", 8);
    freq.put("rho", 18);
    freq.put("Ell", 19);
    freq.put("Elm", 8);
    freq.put("Tö", 56);
    freq.put("nyö", 50);
    freq.put("Ela", 19);
    freq.put("Ele", 17);
    freq.put("rha", 63);
    freq.put("kaz", 13);
    freq.put("Els", 19);
    freq.put("Elv", 8);
    freq.put("The", 81);
    freq.put("Tá", 42);
    freq.put("ut ", 55);
    freq.put("tuk", 51);
    freq.put("kus", 137);
    freq.put("tul", 81);
    freq.put("njo", 17);
    freq.put("El ", 10);
    freq.put("utb", 8);
    freq.put("utc", 40);
    freq.put("uta", 187);
    freq.put("své", 16);
    freq.put("uth", 16);
    freq.put("uti", 60);
    freq.put("dvá", 8);
    freq.put("uto", 158);
    freq.put("svá", 19);
    freq.put("uts", 11);
    freq.put("utt", 37);
    freq.put("utu", 60);
    freq.put("uty", 42);
    freq.put("Elé", 11);
    freq.put("Tz", 14);
    freq.put("Tx", 11);
    freq.put("Ty", 13);
    freq.put("Tv", 15);
    freq.put("Tw", 38);
    freq.put("Tu", 322);
    freq.put("Tr", 42);
    freq.put("Ts", 10);
    freq.put("Ice", 9);
    freq.put("Tq", 9);
    freq.put("Tn", 8);
    freq.put("To", 139);
    freq.put("Tl", 18);
    freq.put("Tm", 13);
    freq.put("Tj", 8);
    freq.put("Tk", 10);
    freq.put("Th", 133);
    freq.put("Ti", 113);
    freq.put("Tf", 12);
    freq.put("Tg", 8);
    freq.put("Te", 338);
    freq.put("Tb", 12);
    freq.put("Tc", 10);
    freq.put("Ta", 175);
    freq.put("nab", 12);
    freq.put("A ", 1328);
    freq.put("naa", 23);
    freq.put("nag", 579);
    freq.put("nad", 42);
    freq.put("naj", 12);
    freq.put("nak", 844);
    freq.put("nah", 25);
    freq.put("nai", 46);
    freq.put("nan", 80);
    freq.put("nal", 179);
    freq.put("nam", 28);
    freq.put("nar", 32);
    freq.put("nas", 17);
    freq.put("nap", 1001);
    freq.put(" Ő ", 18);
    freq.put("nat", 169);
    freq.put("ool", 36);
    freq.put("naz", 14);
    freq.put("nay", 15);
    freq.put("oon", 20);
    freq.put("iér", 193);
    freq.put("esu", 23);
    freq.put("idő", 169);
    freq.put("így", 179);
    freq.put("sné", 9);
    freq.put("T ", 1238);
    freq.put("Aa", 13);
    freq.put("Ac", 32);
    freq.put("Ab", 32);
    freq.put("e", 70133);
    freq.put("Ad", 78);
    freq.put("Ag", 29);
    freq.put("Af", 19);
    freq.put("Ai", 21);
    freq.put("Ah", 41);
    freq.put("Ak", 99);
    freq.put("Aj", 26);
    freq.put("Am", 128);
    freq.put("Al", 137);
    freq.put("Ao", 11);
    freq.put("An", 199);
    freq.put("Aq", 10);
    freq.put("Ap", 58);
    freq.put("As", 51);
    freq.put("Ar", 67);
    freq.put("Au", 49);
    freq.put("At", 55);
    freq.put("Aw", 19);
    freq.put("Av", 25);
    freq.put("Ay", 22);
    freq.put("Ax", 11);
    freq.put("ú", 1961);
    freq.put("gw", 17);
    freq.put("zí", 331);
    freq.put("gu", 222);
    freq.put("gt", 268);
    freq.put("gs", 248);
    freq.put("zé", 1064);
    freq.put("gp", 67);
    freq.put("zá", 1187);
    freq.put("gy", 8852);
    freq.put("gx", 8);
    freq.put("zü", 372);
    freq.put("gf", 98);
    freq.put("ge", 1732);
    freq.put("gd", 71);
    freq.put("gc", 62);
    freq.put("gb", 185);
    freq.put("zú", 73);
    freq.put("go", 1229);
    freq.put("gn", 423);
    freq.put("zö", 396);
    freq.put("gl", 266);
    freq.put("gk", 211);
    freq.put("gj", 250);
    freq.put("gi", 763);
    freq.put("zó", 434);
    freq.put("gW", 9);
    freq.put("gV", 9);
    freq.put("gU", 10);
    freq.put("gT", 9);
    freq.put("gS", 10);
    freq.put("gR", 9);
    freq.put("gQ", 17);
    freq.put("gP", 11);
    freq.put("lke", 134);
    freq.put("gZ", 10);
    freq.put("gY", 9);
    freq.put("lka", 78);
    freq.put("gG", 8);
    freq.put("gE", 8);
    freq.put("gD", 11);
    freq.put("gC", 10);
    freq.put("gB", 13);
    freq.put("gA", 10);
    freq.put("Not", 8);
    freq.put("gN", 11);
    freq.put("Nov", 10);
    freq.put("gL", 10);
    freq.put("gK", 12);
    freq.put("gJ", 8);
    freq.put("Nor", 20);
    freq.put("tme", 22);
    freq.put("yák", 14);
    freq.put("ozá", 72);
    freq.put("Óri", 8);
    freq.put("kci", 67);
    freq.put("ozó", 55);
    freq.put("kcs", 12);
    freq.put("g ", 4046);
    freq.put("űű", 15);
    freq.put("rtu", 30);
    freq.put("No ", 12);
    freq.put("lk ", 13);
    freq.put("Spo", 26);
    freq.put("Spa", 11);
    freq.put("yáb", 9);
    freq.put("zl", 233);
    freq.put("zm", 117);
    freq.put("zn", 654);
    freq.put("zo", 1356);
    freq.put("zh", 111);
    freq.put("zi", 1308);
    freq.put("zj", 25);
    freq.put("zk", 162);
    freq.put("zd", 404);
    freq.put("ze", 4308);
    freq.put("zf", 25);
    freq.put("gü", 51);
    freq.put("za", 1691);
    freq.put("zb", 170);
    freq.put("zc", 16);
    freq.put("zx", 11);
    freq.put("zy", 41);
    freq.put("zz", 489);
    freq.put("zt", 2495);
    freq.put("zu", 300);
    freq.put("zv", 105);
    freq.put("zw", 10);
    freq.put("zp", 52);
    freq.put("zq", 8);
    freq.put("gé", 576);
    freq.put("zs", 509);
    freq.put("zL", 14);
    freq.put("zM", 14);
    freq.put("zN", 16);
    freq.put("zO", 10);
    freq.put("zI", 11);
    freq.put("zJ", 10);
    freq.put("lké", 66);
    freq.put("Sí", 8);
    freq.put("zE", 11);
    freq.put("zF", 14);
    freq.put("zG", 13);
    freq.put("zB", 11);
    freq.put("zC", 11);
    freq.put("lkü", 83);
    freq.put("zX", 10);
    freq.put("zY", 13);
    freq.put("zZ", 8);
    freq.put("zT", 10);
    freq.put("zU", 10);
    freq.put("zV", 11);
    freq.put("zW", 16);
    freq.put("zQ", 10);
    freq.put("zR", 10);
    freq.put("zS", 8);
    freq.put("ozg", 14);
    freq.put("ozd", 18);
    freq.put("oze", 15);
    freq.put("ozb", 9);
    freq.put("oza", 112);
    freq.put("ozn", 114);
    freq.put("ozo", 137);
    freq.put("z ", 6118);
    freq.put("ozh", 19);
    freq.put("ozi", 79);
    freq.put("ozt", 101);
    freq.put("ozu", 14);
    freq.put("ozs", 24);
    freq.put("ozz", 145);
    freq.put("cég", 37);
    freq.put("vbe", 19);
    freq.put("Aho", 12);
    freq.put("cél", 29);
    freq.put("ies", 48);
    freq.put("wif", 11);
    freq.put("gű", 19);
    freq.put("win", 22);
    freq.put("wil", 12);
    freq.put("wik", 9);
    freq.put("IA ", 8);
    freq.put("wit", 109);
    freq.put("íz ", 30);
    freq.put("Jr", 10);
    freq.put("gű ", 16);
    freq.put("Sá", 26);
    freq.put("gő", 57);
    freq.put(" vé", 385);
    freq.put(" ví", 38);
    freq.put("Jn", 12);
    freq.put("ű ", 237);
    freq.put(" vö", 10);
    freq.put("Jh", 11);
    freq.put("Ji", 20);
    freq.put("ízt", 10);
    freq.put("ien", 56);
    freq.put("TF ", 8);
    freq.put("íze", 14);
    freq.put("ízb", 10);
    freq.put("ízl", 8);
    freq.put("ízo", 10);
    freq.put("ízi", 23);
    freq.put("űs", 57);
    freq.put("űr", 36);
    freq.put("űt", 31);
    freq.put("űv", 45);
    freq.put("űz", 40);
    freq.put("űb", 13);
    freq.put("űe", 24);
    freq.put("ieg", 23);
    freq.put("záz", 54);
    freq.put("űk", 55);
    freq.put("űj", 20);
    freq.put("űl", 26);
    freq.put("űn", 94);
    freq.put("Jég", 8);
    freq.put("Mr ", 14);
    freq.put("zű", 25);
    freq.put(" va", 2424);
    freq.put(" vb", 8);
    freq.put(" ve", 561);
    freq.put(" vi", 997);
    freq.put(" vk", 15);
    freq.put(" vm", 50);
    freq.put(" vl", 9);
    freq.put(" vo", 808);
    freq.put(" vn", 10);
    freq.put(" vs", 17);
    freq.put(" vr", 9);
    freq.put(" vv", 12);
    freq.put("ző", 329);
    freq.put("iál", 49);
    freq.put("HI ", 8);
    freq.put("ízá", 9);
    freq.put(" v ", 69);
    freq.put("yör", 49);
    freq.put("yös", 9);
    freq.put("jna", 46);
    freq.put("jni", 16);
    freq.put("iáb", 35);
    freq.put("Pál", 16);
    freq.put("rős", 83);
    freq.put("ről", 202);
    freq.put("RA ", 19);
    freq.put("rő ", 27);
    freq.put("dná", 39);
    freq.put("EG ", 28);
    freq.put("ec ", 15);
    freq.put("jná", 29);
    freq.put("sne", 38);
    freq.put("hle", 9);
    freq.put("kór", 20);
    freq.put("kód", 17);
    freq.put("max", 21);
    freq.put("tM", 13);
    freq.put("ece", 49);
    freq.put("ecc", 58);
    freq.put("eco", 18);
    freq.put("eck", 26);
    freq.put("eci", 30);
    freq.put("ech", 45);
    freq.put("ect", 76);
    freq.put("ecs", 89);
    freq.put("óóó", 28);
    freq.put("ecz", 8);
    freq.put("dőd", 50);
    freq.put("kó ", 30);
    freq.put("sO", 19);
    freq.put("tK", 13);
    freq.put("dőb", 23);
    freq.put("rs ", 95);
    freq.put("dől", 16);
    freq.put("dőm", 16);
    freq.put("rtá", 91);
    freq.put(" Sz", 613);
    freq.put(" Sy", 8);
    freq.put(" Ss", 9);
    freq.put(" Sp", 45);
    freq.put(" Sv", 9);
    freq.put(" Sw", 12);
    freq.put(" St", 125);
    freq.put(" Su", 34);
    freq.put(" Sk", 31);
    freq.put(" Sh", 47);
    freq.put(" Si", 75);
    freq.put(" Sn", 18);
    freq.put(" So", 89);
    freq.put(" Sl", 11);
    freq.put(" Sm", 16);
    freq.put(" Sc", 27);
    freq.put(" Sa", 123);
    freq.put(" Se", 80);
    freq.put("rso", 33);
    freq.put("rsi", 15);
    freq.put("big", 11);
    freq.put("rsk", 30);
    freq.put("rse", 76);
    freq.put("rsa", 107);
    freq.put("R", 2021);
    freq.put("rsz", 372);
    freq.put("bej", 88);
    freq.put("bek", 81);
    freq.put("beh", 14);
    freq.put("bei", 14);
    freq.put("ben", 908);
    freq.put("beo", 10);
    freq.put("bel", 239);
    freq.put("bem", 38);
    freq.put("beb", 8);
    freq.put("bec", 22);
    freq.put("bea", 28);
    freq.put("bef", 42);
    freq.put("beg", 8);
    freq.put("bed", 9);
    freq.put("bee", 24);
    freq.put("bez", 8);
    freq.put("rtö", 42);
    freq.put("uró", 47);
    freq.put("ber", 389);
    freq.put("bes", 192);
    freq.put(" S ", 98);
    freq.put("bev", 41);
    freq.put("bet", 134);
    freq.put("ápo", 12);
    freq.put("rtó", 44);
    freq.put("pvi", 16);
    freq.put("rtü", 14);
    freq.put("py ", 15);
    freq.put("ur ", 35);
    freq.put("fg ", 9);
    freq.put("uu ", 40);
    freq.put(" Sí", 8);
    freq.put(" Sá", 25);
    freq.put("rsé", 16);
    freq.put("aww", 8);
    freq.put("rsá", 13);
    freq.put("awe", 8);
    freq.put("awa", 11);
    freq.put("urd", 10);
    freq.put("ure", 28);
    freq.put("urg", 23);
    freq.put("Sán", 12);
    freq.put("urc", 28);
    freq.put("urn", 18);
    freq.put("beá", 15);
    freq.put("uri", 30);
    freq.put("urk", 23);
    freq.put("urt", 18);
    freq.put("uru", 29);
    freq.put("urv", 113);
    freq.put("urr", 22);
    freq.put("urs", 9);
    freq.put("Del", 12);
    freq.put("mg ", 19);
    freq.put("múl", 81);
    freq.put("tb ", 17);
    freq.put("gőt", 8);
    freq.put("gős", 11);
    freq.put("nge", 227);
    freq.put("ngg", 8);
    freq.put("nga", 136);
    freq.put("ngb", 10);
    freq.put("ngl", 20);
    freq.put("ngn", 9);
    freq.put("ngo", 150);
    freq.put("ngh", 11);
    freq.put("ngi", 22);
    freq.put("ngj", 24);
    freq.put("sh ", 52);
    freq.put("ngu", 22);
    freq.put("ngv", 13);
    freq.put("ngr", 15);
    freq.put("ngs", 37);
    freq.put("ngy", 99);
    freq.put("ngz", 17);
    freq.put("gő ", 25);
    freq.put("tbo", 10);
    freq.put("tba", 102);
    freq.put("ttt", 28);
    freq.put("tbe", 83);
    freq.put("ng ", 219);
    freq.put("gök", 14);
    freq.put("ksz", 111);
    freq.put("sha", 46);
    freq.put("she", 24);
    freq.put("shi", 59);
    freq.put("ója", 65);
    freq.put("sho", 73);
    freq.put("ke ", 171);
    freq.put("lus", 67);
    freq.put("lut", 49);
    freq.put("ngá", 22);
    freq.put("luz", 9);
    freq.put("ngé", 28);
    freq.put("dve", 295);
    freq.put("lub", 52);
    freq.put("lud", 85);
    freq.put("lue", 28);
    freq.put("ngó", 36);
    freq.put("luk", 21);
    freq.put("lul", 24);
    freq.put("lum", 11);
    freq.put("lun", 90);
    freq.put("luo", 19);
    freq.put("ken", 138);
    freq.put("kem", 356);
    freq.put("kel", 732);
    freq.put("kek", 73);
    freq.put("kei", 13);
    freq.put("őjé", 18);
    freq.put("kee", 27);
    freq.put("ked", 521);
    freq.put("kec", 11);
    freq.put("kez", 441);
    freq.put("key", 22);
    freq.put("kev", 55);
    freq.put("ket", 577);
    freq.put("kes", 159);
    freq.put("ker", 486);
    freq.put("kep", 35);
    freq.put("lu ", 19);
    freq.put("keU", 9);
    freq.put("ójá", 44);
    freq.put("ot ", 545);
    freq.put("Lon", 25);
    freq.put("Lol", 9);
    freq.put("Lor", 8);
    freq.put("Lov", 27);
    freq.put("Lou", 26);
    freq.put("OO ", 10);
    freq.put("eót", 65);
    freq.put("pin", 35);
    freq.put("yat", 40);
    freq.put("yas", 35);
    freq.put("yar", 380);
    freq.put("yam", 104);
    freq.put("yal", 63);
    freq.put("yan", 423);
    freq.put("yai", 20);
    freq.put("yak", 65);
    freq.put("dje", 19);
    freq.put("yag", 34);
    freq.put("eók", 18);
    freq.put("eój", 19);
    freq.put("yab", 9);
    freq.put("oth", 44);
    freq.put("oti", 36);
    freq.put("otm", 10);
    freq.put("oto", 118);
    freq.put("ota", 40);
    freq.put("ote", 48);
    freq.put("otr", 13);
    freq.put("ott", 894);
    freq.put("And", 43);
    freq.put("Ane", 12);
    freq.put("Áll", 22);
    freq.put("Ang", 24);
    freq.put("Anc", 8);
    freq.put("tbő", 8);
    freq.put("Ann", 43);
    freq.put("Ani", 9);
    freq.put("Ant", 12);
    freq.put("sBl", 13);
    freq.put("eó ", 160);
    freq.put("Any", 26);
    freq.put("Föl", 12);
    freq.put("You", 254);
    freq.put("zy ", 21);
    freq.put("otá", 14);
    freq.put("mze", 35);
    freq.put("otó", 82);
    freq.put(" Ph", 48);
    freq.put("i", 34764);
    freq.put("ksi", 16);
    freq.put(" xB", 10);
    freq.put(" xD", 297);
    freq.put("Be", 225);
    freq.put("Bf", 10);
    freq.put("Bg", 12);
    freq.put(" xo", 9);
    freq.put("Ba", 275);
    freq.put("Bl", 65);
    freq.put("Bm", 13);
    freq.put("Bo", 147);
    freq.put("Bh", 8);
    freq.put("Bi", 109);
    freq.put("Bj", 18);
    freq.put(" xd", 272);
    freq.put("Bt", 14);
    freq.put("Bu", 129);
    freq.put("Bv", 12);
    freq.put(" xx", 33);
    freq.put("Bp", 19);
    freq.put("Bq", 10);
    freq.put("Br", 77);
    freq.put("Bs", 8);
    freq.put("és ", 2073);
    freq.put("By", 14);
    freq.put("hű", 15);
    freq.put("ész", 712);
    freq.put("ádn", 9);
    freq.put("B ", 206);
    freq.put("éss", 32);
    freq.put("ésr", 42);
    freq.put("hő", 28);
    freq.put("ést", 106);
    freq.put("ési", 53);
    freq.put("ésn", 25);
    freq.put("ésb", 25);
    freq.put("TI ", 27);
    freq.put("ése", 213);
    freq.put("ádo", 72);
    freq.put("jle", 28);
    freq.put("U ", 190);
    freq.put("Bá", 36);
    freq.put("ubs", 12);
    freq.put("Bé", 27);
    freq.put("mlí", 11);
    freq.put("?", 29);
    freq.put("Uz", 10);
    freq.put("Uu", 9);
    freq.put("Ut", 42);
    freq.put("Uw", 11);
    freq.put("Uv", 14);
    freq.put("Uq", 11);
    freq.put("Up", 20);
    freq.put("Us", 13);
    freq.put("Ur", 18);
    freq.put("Um", 13);
    freq.put("Ul", 13);
    freq.put("Uo", 8);
    freq.put("Un", 50);
    freq.put("Uh", 12);
    freq.put("Uk", 10);
    freq.put("Uj", 9);
    freq.put("Ue", 15);
    freq.put("Ud", 8);
    freq.put("Ug", 29);
    freq.put("ádj", 9);
    freq.put("Uc", 13);
    freq.put("Ub", 12);
    freq.put("gkö", 39);
    freq.put("dun", 22);
    freq.put("Kés", 22);
    freq.put("ésé", 79);
    freq.put("Kép", 10);
    freq.put("ea ", 59);
    freq.put("gör", 17);
    freq.put("h ", 945);
    freq.put("dug", 11);
    freq.put("dm ", 8);
    freq.put("AN ", 32);
    freq.put("lsá", 16);
    freq.put("rtő", 25);
    freq.put("hz", 14);
    freq.put("eah", 18);
    freq.put("hx", 20);
    freq.put("hy", 54);
    freq.put("eam", 46);
    freq.put("eal", 48);
    freq.put("ean", 29);
    freq.put("hr", 46);
    freq.put("hs", 22);
    freq.put("éső", 33);
    freq.put("hq", 10);
    freq.put("hv", 10);
    freq.put("hw", 21);
    freq.put("ht", 4880);
    freq.put("hu", 347);
    freq.put("hj", 20);
    freq.put("hk", 20);
    freq.put("hh", 181);
    freq.put("hi", 739);
    freq.put("hn", 52);
    freq.put("ho", 2804);
    freq.put("hl", 36);
    freq.put("hm", 71);
    freq.put("hb", 24);
    freq.put("hc", 19);
    freq.put("eas", 24);
    freq.put("ha", 2932);
    freq.put("hf", 17);
    freq.put("hg", 14);
    freq.put("hd", 26);
    freq.put("he", 1783);
    freq.put("hY", 10);
    freq.put("dme", 28);
    freq.put("hR", 9);
    freq.put("hS", 9);
    freq.put("ésű", 11);
    freq.put("hQ", 9);
    freq.put("hV", 14);
    freq.put("hW", 10);
    freq.put("hU", 9);
    freq.put("hJ", 8);
    freq.put("hK", 12);
    freq.put("hN", 20);
    freq.put("hO", 8);
    freq.put("hL", 8);
    freq.put("Műv", 8);
    freq.put("hB", 9);
    freq.put("hA", 11);
    freq.put("hE", 11);
    freq.put("Álm", 12);
    freq.put("hn ", 11);
    freq.put("jlő", 10);
    freq.put(" Ut", 32);
    freq.put(" Up", 9);
    freq.put(" Ur", 15);
    freq.put("só ", 80);
    freq.put(" Un", 41);
    freq.put(" Ug", 21);
    freq.put("hú", 73);
    freq.put("hü", 76);
    freq.put("hó", 98);
    freq.put("hö", 66);
    freq.put("hé", 301);
    freq.put("hí", 144);
    freq.put("há", 733);
    freq.put("hna", 8);
    freq.put("dmé", 30);
    freq.put("hno", 10);
    freq.put(" U ", 37);
    freq.put("MS ", 10);
    freq.put("lőz", 60);
    freq.put("lőt", 120);
    freq.put(" th", 64);
    freq.put("lőr", 39);
    freq.put("lős", 69);
    freq.put("lől", 42);
    freq.put("lőn", 18);
    freq.put("lői", 8);
    freq.put("lők", 33);
    freq.put("lőd", 44);
    freq.put("lőa", 36);
    freq.put("lőb", 46);
    freq.put("aud", 22);
    freq.put("aug", 11);
    freq.put("aul", 15);
    freq.put("up ", 16);
    freq.put("aus", 17);
    freq.put("aur", 30);
    freq.put("aut", 71);
    freq.put("mók", 8);
    freq.put("auz", 8);
    freq.put("ble", 42);
    freq.put("lő ", 100);
    freq.put("upo", 12);
    freq.put("upl", 16);
    freq.put("upe", 31);
    freq.put("upc", 9);
    freq.put("óló", 33);
    freq.put("drá", 56);
    freq.put("ólá", 14);
    freq.put("upp", 8);
    freq.put("vev", 9);
    freq.put("me ", 126);
    freq.put("neD", 13);
    freq.put("Ige", 28);
    freq.put("Iga", 15);
    freq.put("nen", 43);
    freq.put("neo", 20);
    freq.put("nel", 56);
    freq.put("nem", 2474);
    freq.put("nek", 1475);
    freq.put("neh", 69);
    freq.put("nei", 24);
    freq.put("esn", 38);
    freq.put("ned", 69);
    freq.put("eDi", 14);
    freq.put("iír", 17);
    freq.put("nez", 51);
    freq.put("ney", 18);
    freq.put("nev", 155);
    freq.put("new", 15);
    freq.put("net", 263);
    freq.put("ól ", 856);
    freq.put("nes", 131);
    freq.put("nep", 43);
    freq.put("mee", 16);
    freq.put("med", 49);
    freq.put("meg", 2388);
    freq.put("oru", 43);
    freq.put("mea", 13);
    freq.put("íci", 12);
    freq.put("fiz", 53);
    freq.put("mem", 30);
    freq.put("mel", 415);
    freq.put("meo", 13);
    freq.put("men", 554);
    freq.put("mei", 19);
    freq.put("meh", 23);
    freq.put("mek", 95);
    freq.put("met", 221);
    freq.put("mes", 176);
    freq.put("mer", 642);
    freq.put("mez", 62);
    freq.put("dry", 9);
    freq.put("sóm", 15);
    freq.put("ólt", 16);
    freq.put("dru", 10);
    freq.put("ne ", 837);
    freq.put("upá", 16);
    freq.put("dri", 49);
    freq.put("óln", 19);
    freq.put("ólo", 9);
    freq.put("dro", 50);
    freq.put("dra", 64);
    freq.put("dre", 58);
    freq.put("óla", 86);
    freq.put("ügy", 70);
    freq.put("sók", 33);
    freq.put("ügg", 32);
    freq.put("sóf", 9);
    freq.put("orc", 26);
    freq.put("riv", 19);
    freq.put("sób", 10);
    freq.put("Á", 137);
    freq.put("Ste", 20);
    freq.put("Sta", 36);
    freq.put("Sto", 26);
    freq.put("Dte", 24);
    freq.put("éko", 91);
    freq.put("ová", 100);
    freq.put("Str", 19);
    freq.put("V", 1210);
    freq.put("űen", 20);
    freq.put("Sty", 28);
    freq.put("oví", 8);
    freq.put("Vég", 24);
    freq.put("rio", 14);
    freq.put("ékn", 16);
    freq.put("Lig", 9);
    freq.put("Lia", 18);
    freq.put("Lil", 37);
    freq.put("Lin", 21);
    freq.put("Lit", 16);
    freq.put("Liv", 13);
    freq.put("KaT", 11);
    freq.put("tnő", 26);
    freq.put("Kan", 9);
    freq.put("Kam", 9);
    freq.put("Kar", 34);
    freq.put("Kap", 20);
    freq.put("Kat", 65);
    freq.put("drő", 8);
    freq.put("olv", 152);
    freq.put("ova", 113);
    freq.put("ove", 121);
    freq.put("ovi", 42);
    freq.put("ovo", 8);
    freq.put("cím", 81);
    freq.put("Alk", 10);
    freq.put("Ali", 22);
    freq.put("Ale", 34);
    freq.put("Alb", 8);
    freq.put("Ala", 16);
    freq.put("rág", 67);
    freq.put("rád", 36);
    freq.put("ráb", 48);
    freq.put("rác", 108);
    freq.put("ráa", 11);
    freq.put("rán", 170);
    freq.put("rál", 101);
    freq.put("rám", 64);
    freq.put("ráj", 67);
    freq.put("rák", 34);
    freq.put("rái", 8);
    freq.put("ráv", 11);
    freq.put("rát", 168);
    freq.put("rár", 17);
    freq.put("rás", 121);
    freq.put("bó ", 19);
    freq.put("dün", 16);
    freq.put("dül", 53);
    freq.put(" zá", 35);
    freq.put(" zö", 25);
    freq.put("rá ", 100);
    freq.put("ong", 99);
    freq.put("ból", 246);
    freq.put("elé", 323);
    freq.put("gyű", 36);
    freq.put("Új", 113);
    freq.put("Úg", 36);
    freq.put("áér", 13);
    freq.put("akó", 10);
    freq.put("isé", 29);
    freq.put("isí", 12);
    freq.put("isá", 14);
    freq.put("Úr", 10);
    freq.put("Wor", 14);
    freq.put("íná", 12);
    freq.put(" zm", 10);
    freq.put("zdm", 23);
    freq.put(" zo", 20);
    freq.put(" zi", 34);
    freq.put(" ze", 139);
    freq.put(" za", 89);
    freq.put("élt", 63);
    freq.put(" zu", 17);
    freq.put("mű", 179);
    freq.put("is ", 2027);
    freq.put(" zs", 107);
    freq.put("TK ", 9);
    freq.put("zde", 71);
    freq.put("Gn", 12);
    freq.put("tyű", 13);
    freq.put("isz", 508);
    freq.put("xus", 15);
    freq.put("iss", 321);
    freq.put("zda", 33);
    freq.put("isp", 17);
    freq.put(" z ", 51);
    freq.put("isu", 9);
    freq.put("ist", 231);
    freq.put("isk", 74);
    freq.put("isi", 42);
    freq.put("ish", 27);
    freq.put("iso", 35);
    freq.put("isn", 15);
    freq.put("ism", 169);
    freq.put("isl", 25);
    freq.put("isc", 22);
    freq.put("isb", 9);
    freq.put("isa", 45);
    freq.put("isg", 12);
    freq.put("isf", 10);
    freq.put("ise", 89);
    freq.put("esé", 107);
    freq.put("gy ", 4583);
    freq.put("uár", 34);
    freq.put("lá ", 12);
    freq.put("jjj", 21);
    freq.put("jje", 40);
    freq.put("jja", 25);
    freq.put("Com", 11);
    freq.put("BB ", 19);
    freq.put("Ily", 29);
    freq.put("lál", 270);
    freq.put("gyf", 24);
    freq.put("gye", 996);
    freq.put("gyd", 17);
    freq.put("gyb", 52);
    freq.put("gya", 598);
    freq.put("lák", 8);
    freq.put("gyo", 1033);
    freq.put("gyn", 43);
    freq.put("gym", 81);
    freq.put("gyl", 13);
    freq.put("gyk", 23);
    freq.put("gyj", 31);
    freq.put("gyi", 353);
    freq.put("gyh", 74);
    freq.put("gyv", 19);
    freq.put("gyu", 78);
    freq.put("gyt", 62);
    freq.put("gys", 204);
    freq.put("gyr", 49);
    freq.put("láz", 36);
    freq.put("lát", 351);
    freq.put("láv", 9);
    freq.put("gyz", 40);
    freq.put("lár", 42);
    freq.put("jj ", 46);
    freq.put("enő", 37);
    freq.put("jjö", 9);
    freq.put("ty ", 74);
    freq.put(" ző", 8);
    freq.put("do ", 49);
    freq.put("tyl", 43);
    freq.put("wd ", 15);
    freq.put("AH ", 10);
    freq.put("tyo", 11);
    freq.put("gyá", 86);
    freq.put("tyk", 25);
    freq.put("gyí", 8);
    freq.put("tya", 42);
    freq.put("gyé", 96);
    freq.put("gyö", 53);
    freq.put("gyó", 45);
    freq.put("tyu", 12);
    freq.put("gyü", 81);
    freq.put("tys", 8);
    freq.put("dok", 193);
    freq.put("don", 124);
    freq.put("doo", 13);
    freq.put("dol", 376);
    freq.put("dom", 423);
    freq.put("dob", 71);
    freq.put("m", 29476);
    freq.put("dog", 96);
    freq.put("dod", 94);
    freq.put("doz", 31);
    freq.put("dor", 112);
    freq.put("dos", 47);
    freq.put("dow", 15);
    freq.put("dot", 103);
    freq.put(" We", 31);
    freq.put(" Wa", 43);
    freq.put(" Wo", 30);
    freq.put(" Wi", 50);
    freq.put(" Ww", 9);
    freq.put("kul", 75);
    freq.put("ba ", 444);
    freq.put("omá", 85);
    freq.put("vöz", 9);
    freq.put(" W ", 42);
    freq.put("űso", 35);
    freq.put("vör", 8);
    freq.put("omó", 14);
    freq.put("kug", 16);
    freq.put("völ", 13);
    freq.put("vök", 25);
    freq.put("űsz", 8);
    freq.put("bat", 82);
    freq.put("bar", 200);
    freq.put("bas", 121);
    freq.put("baz", 41);
    freq.put("bag", 10);
    freq.put("bad", 85);
    freq.put("bab", 46);
    freq.put("bac", 23);
    freq.put("mög", 10);
    freq.put("ban", 1049);
    freq.put("bal", 127);
    freq.put("bam", 18);
    freq.put("baj", 136);
    freq.put("bak", 41);
    freq.put("om ", 1421);
    freq.put(" k ", 54);
    freq.put("un ", 36);
    freq.put("omb", 169);
    freq.put("C", 1200);
    freq.put("omg", 15);
    freq.put("omf", 10);
    freq.put("ome", 75);
    freq.put("omk", 12);
    freq.put("omj", 18);
    freq.put("űsé", 8);
    freq.put("omo", 168);
    freq.put("omn", 25);
    freq.put("omm", 80);
    freq.put("oml", 30);
    freq.put("oms", 39);
    freq.put("omr", 32);
    freq.put("omp", 20);
    freq.put("omu", 11);
    freq.put("omt", 28);
    freq.put("zso", 50);
    freq.put("unt", 30);
    freq.put("eló", 30);
    freq.put("una", 57);
    freq.put("unc", 10);
    freq.put("und", 49);
    freq.put("une", 9);
    freq.put("unf", 25);
    freq.put("ung", 130);
    freq.put("uni", 40);
    freq.put("unk", 582);
    freq.put("unn", 25);
    freq.put("uno", 18);
    freq.put("iú", 75);
    freq.put("iü", 9);
    freq.put("ón ", 45);
    freq.put("ió", 339);
    freq.put("ié", 218);
    freq.put("ií", 17);
    freq.put("iá", 285);
    freq.put("TT ", 28);
    freq.put("eBa", 10);
    freq.put("C ", 215);
    freq.put("Uta", 15);
    freq.put("Zm", 12);
    freq.put("ónk", 11);
    freq.put("óni", 8);
    freq.put("kié", 8);
    freq.put("kií", 16);
    freq.put("kiá", 25);
    freq.put("mcs", 18);
    freq.put("Ck", 13);
    freq.put("Cj", 8);
    freq.put("Ci", 61);
    freq.put("Ch", 105);
    freq.put("Co", 100);
    freq.put("Cm", 10);
    freq.put("Cl", 38);
    freq.put("Cc", 8);
    freq.put("Cb", 13);
    freq.put("Ca", 98);
    freq.put("Cg", 10);
    freq.put("Ví", 10);
    freq.put("Ce", 28);
    freq.put("Cd", 14);
    freq.put("Cz", 10);
    freq.put("Cy", 22);
    freq.put("Cx", 8);
    freq.put("sli", 19);
    freq.put("gla", 62);
    freq.put("Cs", 246);
    freq.put("Cr", 47);
    freq.put("Cq", 8);
    freq.put("Cp", 11);
    freq.put("Cw", 10);
    freq.put("Cv", 12);
    freq.put("Cu", 26);
    freq.put("Ct", 11);
    freq.put("iy", 27);
    freq.put("ix", 80);
    freq.put("iz", 647);
    freq.put("Nag", 86);
    freq.put("iq", 19);
    freq.put("ip", 325);
    freq.put("is", 3811);
    freq.put("ir", 1117);
    freq.put("iu", 154);
    freq.put("it", 2298);
    freq.put("iw", 38);
    freq.put("iv", 607);
    freq.put("ii", 494);
    freq.put("ih", 207);
    freq.put("Nap", 40);
    freq.put("ij", 95);
    freq.put("im", 683);
    freq.put("il", 1805);
    freq.put("io", 285);
    freq.put("in", 4509);
    freq.put("ia", 1136);
    freq.put("ic", 867);
    freq.put("ki ", 976);
    freq.put("ie", 482);
    freq.put("id", 1213);
    freq.put("ig", 1506);
    freq.put("if", 157);
    freq.put("iY", 8);
    freq.put("iX", 13);
    freq.put("iZ", 12);
    freq.put("iP", 43);
    freq.put("iS", 15);
    freq.put("iR", 15);
    freq.put("iT", 24);
    freq.put("iW", 10);
    freq.put("íne", 29);
    freq.put("iI", 11);
    freq.put("iH", 16);
    freq.put("iK", 22);
    freq.put("iJ", 9);
    freq.put("iM", 21);
    freq.put("iL", 17);
    freq.put("iO", 29);
    freq.put("iN", 15);
    freq.put("iA", 39);
    freq.put("dít", 92);
    freq.put("Így", 31);
    freq.put("iB", 13);
    freq.put("iE", 11);
    freq.put("iD", 23);
    freq.put("iG", 21);
    freq.put("iF", 14);
    freq.put("űnt", 30);
    freq.put("kiz", 11);
    freq.put("Na ", 85);
    freq.put("Utá", 8);
    freq.put("óná", 8);
    freq.put("kis", 285);
    freq.put("kir", 94);
    freq.put("kip", 24);
    freq.put("kiv", 112);
    freq.put("kit", 160);
    freq.put("kik", 146);
    freq.put("kij", 28);
    freq.put("kii", 30);
    freq.put("kih", 36);
    freq.put("kin", 271);
    freq.put("kim", 52);
    freq.put("kil", 30);
    freq.put("kic", 150);
    freq.put("i ", 7678);
    freq.put("kia", 56);
    freq.put("kig", 12);
    freq.put("kif", 40);
    freq.put("kie", 52);
    freq.put("kid", 29);
    freq.put("Va", 212);
    freq.put("Vc", 10);
    freq.put("Vd", 9);
    freq.put("Ve", 81);
    freq.put("Vi", 268);
    freq.put("Vj", 10);
    freq.put("Vk", 11);
    freq.put("Vm", 12);
    freq.put("Vn", 8);
    freq.put("Vo", 38);
    freq.put("Vp", 8);
    freq.put("Vq", 8);
    freq.put("Vs", 10);
    freq.put("Vt", 10);
    freq.put("Zr", 19);
    freq.put("Vv", 16);
    freq.put("Vw", 9);
    freq.put("Vx", 9);
    freq.put("Vy", 10);
    freq.put("Vz", 8);
    freq.put("ku ", 11);
    freq.put("slá", 25);
    freq.put("yei", 36);
    freq.put("yek", 233);
    freq.put("yem", 30);
    freq.put("yel", 182);
    freq.put("yen", 678);
    freq.put("yea", 19);
    freq.put("yeb", 21);
    freq.put("yed", 100);
    freq.put("yeg", 33);
    freq.put("yez", 61);
    freq.put("op ", 65);
    freq.put("yes", 171);
    freq.put("yer", 325);
    freq.put("yet", 221);
    freq.put("ődj", 8);
    freq.put("zor", 105);
    freq.put("ődi", 26);
    freq.put("vd ", 13);
    freq.put("ődt", 11);
    freq.put("EÓ ", 8);
    freq.put("opt", 27);
    freq.put("opp", 27);
    freq.put("opr", 10);
    freq.put("ops", 10);
    freq.put("ye ", 180);
    freq.put(" Ér", 37);
    freq.put(" És", 78);
    freq.put(" Ét", 9);
    freq.put(" Év", 8);
    freq.put("opd", 9);
    freq.put("ope", 39);
    freq.put(" Éj", 11);
    freq.put(" Él", 30);
    freq.put("opa", 18);
    freq.put(" Én", 106);
    freq.put("opo", 51);
    freq.put(" Éd", 8);
    freq.put("opi", 8);
    freq.put("Art", 8);
    freq.put("őd ", 16);
    freq.put("Ara", 13);
    freq.put("www", 24);
    freq.put("eep", 16);
    freq.put("eer", 31);
    freq.put("Jen", 16);
    freq.put("ődé", 28);
    freq.put("ődö", 31);
    freq.put("zör", 67);
    freq.put("zu ", 13);
    freq.put("bra", 48);
    freq.put("ww ", 18);
    freq.put("zur", 24);
    freq.put("zus", 53);
    freq.put("zup", 24);
    freq.put("zuc", 13);
    freq.put("zud", 11);
    freq.put("zuk", 13);
    freq.put("zuh", 12);
    freq.put("eeb", 10);
    freq.put("zun", 46);
    freq.put("zul", 39);
    freq.put("zum", 8);
    freq.put("Üze", 9);
    freq.put("TE ", 19);
    freq.put("Z", 685);
    freq.put("RKa", 10);
    freq.put("ört", 134);
    freq.put("zz ", 71);
    freq.put("Gáb", 8);
    freq.put("EA ", 9);
    freq.put("örb", 13);
    freq.put("Win", 18);
    freq.put("Wil", 11);
    freq.put("örg", 36);
    freq.put("kov", 47);
    freq.put("öre", 20);
    freq.put("Még", 47);
    freq.put("civ", 9);
    freq.put("di ", 174);
    freq.put("örn", 42);
    freq.put("diA", 8);
    freq.put("dil", 11);
    freq.put("din", 50);
    freq.put("dio", 27);
    freq.put("dik", 219);
    freq.put("did", 9);
    freq.put("die", 16);
    freq.put("dig", 450);
    freq.put("dia", 53);
    freq.put("dic", 23);
    freq.put("diz", 11);
    freq.put("dit", 40);
    freq.put("div", 24);
    freq.put("dir", 35);
    freq.put("dis", 36);
    freq.put(" Yo", 263);
    freq.put(" Ya", 14);
    freq.put("nyő", 8);
    freq.put("ery", 21);
    freq.put("Gre", 18);
    freq.put("Gra", 22);
    freq.put(" Yp", 8);
    freq.put(" Yt", 10);
    freq.put("iók", 24);
    freq.put("iój", 22);
    freq.put("nyű", 28);
    freq.put("AM ", 22);
    freq.put("bo ", 23);
    freq.put("ión", 12);
    freq.put("Wf", 9);
    freq.put(" Y ", 32);
    freq.put("ább", 277);
    freq.put("óin", 13);
    freq.put("iób", 12);
    freq.put("tno", 17);
    freq.put("box", 14);
    freq.put("boy", 12);
    freq.put("boz", 15);
    freq.put("tni", 155);
    freq.put("bor", 147);
    freq.put("bos", 15);
    freq.put("bot", 47);
    freq.put("bou", 14);
    freq.put("ióf", 12);
    freq.put("ű", 716);
    freq.put("HA ", 14);
    freq.put("bok", 18);
    freq.put("bol", 162);
    freq.put("bom", 14);
    freq.put("bon", 33);
    freq.put("boo", 134);
    freq.put("boa", 9);
    freq.put("boc", 53);
    freq.put("bod", 17);
    freq.put("bog", 18);
    freq.put("oo ", 53);
    freq.put("Wk", 8);
    freq.put("Wh", 19);
    freq.put("nyú", 24);
    freq.put("ayl", 16);
    freq.put("ayn", 52);
    freq.put("nyü", 8);
    freq.put("aye", 19);
    freq.put("nyó", 16);
    freq.put("aya", 26);
    freq.put("Wu", 10);
    freq.put("ayb", 8);
    freq.put("nyé", 62);
    freq.put("nyí", 45);
    freq.put("ayu", 12);
    freq.put("ul ", 222);
    freq.put("nyá", 145);
    freq.put("ays", 12);
    freq.put("Bek", 9);
    freq.put("oog", 44);
    freq.put("Ben", 30);
    freq.put("Bel", 46);
    freq.put("oom", 19);
    freq.put("Bec", 8);
    freq.put("ooo", 133);
    freq.put("Bea", 18);
    freq.put("Bef", 8);
    freq.put("ooh", 9);
    freq.put("ook", 152);
    freq.put("Bee", 8);
    freq.put("oot", 15);
    freq.put("oop", 15);
    freq.put("oor", 15);
    freq.put("Ber", 26);
    freq.put("Bes", 15);
    freq.put("Bet", 20);
    freq.put("ulz", 8);
    freq.put("zná", 100);
    freq.put("uly", 17);
    freq.put("uls", 11);
    freq.put("zné", 33);
    freq.put("flu", 22);
    freq.put("ay ", 99);
    freq.put("ult", 185);
    freq.put("ulu", 15);
    freq.put("fli", 23);
    freq.put("ulh", 13);
    freq.put("uli", 138);
    freq.put("uln", 81);
    freq.put("ulo", 58);
    freq.put("ull", 65);
    freq.put("fla", 16);
    freq.put("ulc", 25);
    freq.put("ula", 71);
    freq.put("fle", 9);
    freq.put("uld", 15);
    freq.put("ule", 23);
    freq.put("ges", 201);
    freq.put("sub", 11);
    freq.put("ma ", 478);
    freq.put("nyz", 41);
    freq.put("idn", 14);
    freq.put("ián", 67);
    freq.put("iák", 27);
    freq.put("iáj", 10);
    freq.put("nyr", 21);
    freq.put("nys", 42);
    freq.put("nyp", 12);
    freq.put("nyv", 112);
    freq.put("nyt", 90);
    freq.put("nyu", 145);
    freq.put("nyj", 20);
    freq.put("nyk", 65);
    freq.put("nyh", 17);
    freq.put("nyi", 550);
    freq.put("nyn", 15);
    freq.put("nyo", 287);
    freq.put("nyl", 124);
    freq.put("nym", 8);
    freq.put("nyb", 44);
    freq.put("iát", 17);
    freq.put("yön", 44);
    freq.put("nya", 219);
    freq.put("nyf", 13);
    freq.put("iás", 33);
    freq.put("nye", 470);
    freq.put("map", 9);
    freq.put("mas", 161);
    freq.put("Urg", 10);
    freq.put("mat", 218);
    freq.put("sna", 77);
    freq.put("may", 12);
    freq.put("sno", 10);
    freq.put("maz", 67);
    freq.put("sni", 47);
    freq.put("maa", 20);
    freq.put("mac", 41);
    freq.put("mad", 71);
    freq.put("mag", 531);
    freq.put("mai", 135);
    freq.put("mak", 30);
    freq.put("maj", 283);
    freq.put("mam", 42);
    freq.put("mal", 79);
    freq.put("ene", 463);
    freq.put("zna", 76);
    freq.put("Edd", 11);
    freq.put("geb", 21);
    freq.put("uló", 40);
    freq.put("zni", 314);
    freq.put("Edi", 14);
    freq.put("zno", 20);
    freq.put("q", 714);
    freq.put("ny ", 505);
    freq.put("ulá", 98);
    freq.put("lsg", 9);
    freq.put("lse", 20);
    freq.put("lso", 20);
    freq.put("lsz", 171);
    freq.put("kk ", 51);
    freq.put(" aa", 34);
    freq.put(" ab", 96);
    freq.put(" ac", 13);
    freq.put(" ad", 253);
    freq.put(" af", 13);
    freq.put(" ag", 81);
    freq.put(" ah", 142);
    freq.put("őjá", 12);
    freq.put(" aj", 107);
    freq.put(" ak", 1019);
    freq.put(" al", 576);
    freq.put(" am", 680);
    freq.put(" an", 582);
    freq.put("gen", 299);
    freq.put(" ap", 84);
    freq.put(" ar", 202);
    freq.put(" as", 130);
    freq.put(" at", 82);
    freq.put(" au", 80);
    freq.put(" av", 19);
    freq.put(" aw", 21);
    freq.put(" ay", 8);
    freq.put(" az", 3543);
    freq.put("orú", 29);
    freq.put("ls ", 38);
    freq.put("kku", 10);
    freq.put("Sha", 21);
    freq.put("kko", 542);
    freq.put("orí", 23);
    freq.put("She", 9);
    freq.put("oré", 8);
    freq.put("kke", 129);
    freq.put("Shi", 12);
    freq.put("űle", 12);
    freq.put("kka", 145);
    freq.put("Sho", 11);
    freq.put(" a ", 7043);
    freq.put("ödö", 11);
    freq.put("Víz", 9);
    freq.put("ödé", 12);
    freq.put("vjá", 8);
    freq.put("aTa", 11);
    freq.put("Té", 25);
    freq.put("Luc", 9);
    freq.put("lsó", 57);
    freq.put("vő ", 64);
    freq.put("Lum", 9);
    freq.put("or ", 1184);
    freq.put("Ken", 8);
    freq.put("Kel", 23);
    freq.put("Ked", 40);
    freq.put("ője", 42);
    freq.put("öd ", 10);
    freq.put(" bö", 25);
    freq.put("Kez", 15);
    freq.put("lae", 8);
    freq.put("Kes", 8);
    freq.put("Ker", 22);
    freq.put("━━", 40);
    freq.put("orz", 39);
    freq.put("RT ", 845);
    freq.put("G", 1100);
    freq.put("ory", 30);
    freq.put("orv", 47);
    freq.put("ort", 235);
    freq.put("kkö", 14);
    freq.put("orr", 96);
    freq.put("ors", 322);
    freq.put("orn", 71);
    freq.put("oro", 248);
    freq.put("orl", 36);
    freq.put("orm", 152);
    freq.put("kké", 12);
    freq.put("ork", 52);
    freq.put("orh", 12);
    freq.put("ori", 187);
    freq.put("org", 74);
    freq.put("ord", 156);
    freq.put("ore", 84);
    freq.put("orb", 53);
    freq.put("Ü", 34);
    freq.put("ora", 169);
    freq.put("dkí", 11);
    freq.put("App", 25);
    freq.put("cát", 8);
    freq.put("ödi", 23);
    freq.put("Apa", 10);
    freq.put("ödn", 8);
    freq.put("rít", 66);
    freq.put("Dé", 13);
    freq.put("Dá", 10);
    freq.put("zs ", 33);
    freq.put("lső", 208);
    freq.put("Dö", 8);
    freq.put("Ott", 16);
    freq.put("Dó", 11);
    freq.put("en ", 3060);
    freq.put("öhö", 35);
    freq.put("áír", 10);
    freq.put("zsu", 28);
    freq.put("zsz", 10);
    freq.put("zse", 64);
    freq.put("zsg", 53);
    freq.put("zsa", 42);
    freq.put("IS ", 22);
    freq.put("zsi", 77);
    freq.put("Ján", 10);
    freq.put("Dn", 11);
    freq.put("Do", 126);
    freq.put("Dl", 12);
    freq.put("Dm", 10);
    freq.put("Dj", 15);
    freq.put("Dk", 10);
    freq.put("Dh", 10);
    freq.put("Di", 115);
    freq.put("Df", 20);
    freq.put("Dg", 10);
    freq.put("Dd", 25);
    freq.put("De", 205);
    freq.put("Db", 11);
    freq.put("Dc", 10);
    freq.put("Da", 126);
    freq.put("Dz", 11);
    freq.put("Dx", 14);
    freq.put("Dy", 12);
    freq.put("Dv", 11);
    freq.put("Dw", 11);
    freq.put("Dt", 34);
    freq.put("Du", 47);
    freq.put("Dr", 34);
    freq.put("Ds", 12);
    freq.put("Dp", 10);
    freq.put("Dq", 11);
    freq.put("GY ", 44);
    freq.put("iwi", 13);
    freq.put(" b ", 46);
    freq.put("D ", 1957);
    freq.put("zsá", 42);
    freq.put("zsí", 9);
    freq.put("zsé", 36);
    freq.put("zeb", 41);
    freq.put("fes", 74);
    freq.put("kőz", 15);
    freq.put("ge ", 167);
    freq.put("ába", 289);
    freq.put("We", 40);
    freq.put("Wd", 14);
    freq.put("Wc", 9);
    freq.put("Wb", 8);
    freq.put("Wa", 79);
    freq.put("Wo", 45);
    freq.put("Wn", 12);
    freq.put("Wm", 9);
    freq.put("Wl", 9);
    freq.put("ábl", 20);
    freq.put("Wj", 12);
    freq.put("Wi", 57);
    freq.put("ábo", 40);
    freq.put("Ww", 17);
    freq.put("ábr", 9);
    freq.put("Ws", 10);
    freq.put("Wr", 11);
    freq.put("Wq", 11);
    freq.put("Wp", 11);
    freq.put("pti", 22);
    freq.put("Wy", 13);
    freq.put("jü", 93);
    freq.put("ger", 134);
    freq.put("jú", 65);
    freq.put("get", 225);
    freq.put("gez", 32);
    freq.put("jö", 398);
    freq.put("lít", 115);
    freq.put("jó", 803);
    freq.put("gec", 21);
    freq.put("jí", 11);
    freq.put("jé", 151);
    freq.put("gee", 18);
    freq.put("ged", 121);
    freq.put("gek", 64);
    freq.put("tuá", 13);
    freq.put("gei", 20);
    freq.put("geo", 9);
    freq.put("já", 1011);
    freq.put("gem", 119);
    freq.put("gel", 239);
    freq.put("jfé", 11);
    freq.put("W ", 156);
    freq.put("ute", 13);
    freq.put("ó", 5730);
    freq.put("cf", 18);
    freq.put("ült", 162);
    freq.put("utn", 23);
    freq.put("nhá", 26);
    freq.put("j ", 1022);
    freq.put("yéb", 47);
    freq.put("yém", 14);
    freq.put("yél", 19);
    freq.put("yén", 21);
    freq.put("yék", 31);
    freq.put("yét", 9);
    freq.put("ábó", 92);
    freq.put("yés", 9);
    freq.put("yér", 33);
    freq.put("tur", 44);
    freq.put("tus", 73);
    freq.put("jx", 13);
    freq.put("jy", 9);
    freq.put("jz", 65);
    freq.put("jt", 334);
    freq.put("ju", 484);
    freq.put("jv", 23);
    freq.put("jw", 11);
    freq.put("jp", 19);
    freq.put("jq", 11);
    freq.put("jr", 112);
    freq.put("js", 90);
    freq.put("jl", 83);
    freq.put("jm", 22);
    freq.put("jn", 189);
    freq.put("jo", 664);
    freq.put("jh", 17);
    freq.put("ji", 38);
    freq.put("jj", 163);
    freq.put("jk", 78);
    freq.put("jd", 374);
    freq.put("je", 964);
    freq.put("jf", 34);
    freq.put("jg", 20);
    freq.put("tud", 744);
    freq.put("ja", 1248);
    freq.put("jb", 31);
    freq.put("jc", 23);
    freq.put("jX", 14);
    freq.put("jY", 9);
    freq.put("jZ", 10);
    freq.put("jT", 16);
    freq.put("jV", 11);
    freq.put("jW", 11);
    freq.put("jP", 10);
    freq.put("jS", 9);
    freq.put("jL", 9);
    freq.put("écc", 11);
    freq.put("jN", 8);
    freq.put("jO", 16);
    freq.put("jH", 11);
    freq.put("cle", 8);
    freq.put("jD", 9);
    freq.put("dko", 11);
    freq.put("jF", 10);
    freq.put("jG", 8);
    freq.put("Pét", 10);
    freq.put("jB", 11);
    freq.put("tum", 29);
    freq.put("tun", 154);
    freq.put("íg ", 32);
    freq.put("imo", 45);
    freq.put("tub", 50);
    freq.put("tuc", 9);
    freq.put("tf ", 10);
    freq.put("őt ", 122);
    freq.put("É", 353);
    freq.put("Tp", 14);
    freq.put("Pén", 15);
    freq.put(" bb", 10);
    freq.put("Péc", 9);
    freq.put("pap", 38);
    freq.put("par", 164);
    freq.put("pas", 52);
    freq.put("pat", 94);
    freq.put("jM", 10);
    freq.put("dke", 19);
    freq.put("pad", 26);
    freq.put("pai", 17);
    freq.put("pak", 32);
    freq.put("pal", 58);
    freq.put("pan", 81);
    freq.put("oin", 8);
    freq.put("nac", 14);
    freq.put("oid", 35);
    freq.put("oic", 19);
    freq.put("pa ", 76);
    freq.put("ujj", 21);
    freq.put("rög", 33);
    freq.put("rök", 48);
    freq.put("röh", 27);
    freq.put("röm", 27);
    freq.put("röl", 20);
    freq.put("rös", 14);
    freq.put("röv", 24);
    freq.put("mo ", 26);
    freq.put(" cé", 61);
    freq.put(" cí", 76);
    freq.put("moz", 63);
    freq.put("mél", 163);
    freq.put("óbu", 10);
    freq.put("mos", 640);
    freq.put("mor", 90);
    freq.put("mot", 78);
    freq.put("óbb", 32);
    freq.put("óba", 80);
    freq.put("mon", 505);
    freq.put("mom", 36);
    freq.put("óbe", 13);
    freq.put("íme", 34);
    freq.put("mob", 31);
    freq.put("mog", 41);
    freq.put("mod", 63);
    freq.put("zle", 88);
    freq.put("zla", 9);
    freq.put("Ebb", 10);
    freq.put("úni", 15);
    freq.put("zli", 31);
    freq.put("Zf", 9);
    freq.put("úny", 18);
    freq.put("Jún", 8);
    freq.put("Nem", 227);
    freq.put("Nek", 71);
    freq.put("Nee", 10);
    freq.put("hög", 32);
    freq.put("ptu", 9);
    freq.put("Nex", 8);
    freq.put("Nev", 10);
    freq.put("New", 19);
    freq.put("Net", 15);
    freq.put("Meg", 182);
    freq.put(" ci", 127);
    freq.put(" co", 4879);
    freq.put(" cl", 13);
    freq.put(" cm", 9);
    freq.put("Mel", 31);
    freq.put("Men", 33);
    freq.put(" ce", 27);
    freq.put(" cy", 8);
    freq.put("Mes", 21);
    freq.put("Mer", 40);
    freq.put(" cr", 16);
    freq.put(" cs", 1547);
    freq.put("Mez", 10);
    freq.put("fáz", 13);
    freq.put("óbó", 12);
    freq.put("fár", 29);
    freq.put("Ne ", 36);
    freq.put("fáj", 54);
    freq.put("óbá", 82);
    freq.put("Dra", 8);
    freq.put("zlá", 8);
    freq.put("Me ", 29);
    freq.put("km ", 22);
    freq.put(" c ", 90);
    freq.put("zlé", 13);
    freq.put("VD ", 21);
    freq.put("zló", 35);
    freq.put("yyy", 13);
    freq.put("ői ", 47);
    freq.put(" Íg", 31);
    freq.put(" Ím", 11);
    freq.put(" Ír", 10);
    freq.put("zpo", 16);
    freq.put("ímű", 23);
    freq.put("na ", 624);
    freq.put("zav", 112);
    freq.put("még", 622);
    freq.put("yy ", 15);
    freq.put("Ae", 11);
    freq.put("svi", 9);
    freq.put("öjj", 12);
    freq.put("úsá", 8);
    freq.put("dva", 41);
    freq.put("Ó ", 55);
    freq.put("utó", 89);
    freq.put("ús ", 10);
    freq.put("őhé", 8);
    freq.put("gom", 107);
    freq.put("Zy", 10);
    freq.put("pól", 12);
    freq.put("Ór", 9);
    freq.put("goo", 22);
    freq.put("pót", 10);
    freq.put("úsv", 9);
    freq.put("Az", 441);
    freq.put("US ", 9);
    freq.put("Üz", 15);
    freq.put("úsz", 38);
    freq.put("u", 10298);
    freq.put("Vaj", 12);
    freq.put("tőe", 28);
    freq.put("Van", 45);
    freq.put("Val", 49);
    freq.put("gv", 177);
    freq.put("től", 166);
    freq.put("iu ", 11);
    freq.put("tőn", 12);
    freq.put("Vag", 23);
    freq.put("tőj", 13);
    freq.put("tők", 42);
    freq.put("tőt", 42);
    freq.put("tőv", 10);
    freq.put("ék ", 412);
    freq.put("tőr", 8);
    freq.put("tős", 53);
    freq.put("Var", 42);
    freq.put("Vas", 16);
    freq.put("tőz", 9);
    freq.put("Gir", 17);
    freq.put("hy ", 9);
    freq.put("abá", 60);
    freq.put("DJ ", 19);
    freq.put("abó", 12);
    freq.put("éks", 21);
    freq.put("ékp", 8);
    freq.put("ium", 32);
    freq.put("ggó", 11);
    freq.put("edn", 58);
    freq.put("ajo", 122);
    freq.put("gz", 78);
    freq.put("ékb", 23);
    freq.put("éka", 22);
    freq.put("TA ", 10);
    freq.put("rrá", 18);
    freq.put("éke", 145);
    freq.put("got", 113);
    freq.put("ékk", 18);
    freq.put("ius", 69);
    freq.put("ékh", 9);
    freq.put("ggé", 20);
    freq.put("iut", 15);
    freq.put("gg", 374);
    freq.put("pre", 106);
    freq.put("hyp", 17);
    freq.put("ga", 1569);
    freq.put("gg ", 9);
    freq.put("Gin", 9);
    freq.put("cső", 21);
    freq.put("gm", 73);
    freq.put("aba", 148);
    freq.put("abb", 275);
    freq.put("abd", 27);
    freq.put("abe", 32);
    freq.put("abi", 40);
    freq.put("abl", 71);
    freq.put("abo", 97);
    freq.put("abr", 20);
    freq.put("abs", 17);
    freq.put("abu", 10);
    freq.put("oD ", 8);
    freq.put("aby", 26);
    freq.put("gh", 219);
    freq.put("lko", 211);
    freq.put("ntu", 30);
    freq.put("KB ", 8);
    freq.put("ggy", 36);
    freq.put("gge", 216);
    freq.put("éká", 18);
    freq.put("hül", 69);
    freq.put("gga", 31);
    freq.put("zül", 213);
    freq.put("éké", 28);
    freq.put("zün", 91);
    freq.put("zük", 46);
    freq.put("ab ", 22);
    freq.put("à", 52);
    freq.put("nőv", 11);
    freq.put("nőt", 31);
    freq.put("nth", 63);
    freq.put("lki", 27);
    freq.put("nőj", 14);
    freq.put("nők", 19);
    freq.put("női", 17);
    freq.put("nőn", 10);
    freq.put("nőm", 14);
    freq.put("főn", 26);
    freq.put("fől", 22);
    freq.put("Ért", 12);
    freq.put("akt", 97);
    freq.put("főz", 8);
    freq.put("főr", 9);
    freq.put("fős", 9);
    freq.put("Érd", 18);
    freq.put("főt", 10);
    freq.put("iva", 183);
    freq.put("csí", 22);
    freq.put("csé", 63);
    freq.put("twe", 62);
    freq.put("ivc", 10);
    freq.put("csá", 83);
    freq.put("jd ", 263);
    freq.put("csü", 38);
    freq.put("LT ", 13);
    freq.put("csú", 61);
    freq.put("de ", 1110);
    freq.put("csö", 54);
    freq.put("csó", 52);
    freq.put("ivo", 11);
    freq.put("fő ", 33);
    freq.put("bké", 29);
    freq.put("gO", 13);
    freq.put("dex", 15);
    freq.put("ey ", 60);
    freq.put("jdo", 23);
    freq.put("jdn", 34);
    freq.put("der", 136);
    freq.put("des", 165);
    freq.put("jda", 22);
    freq.put("dev", 14);
    freq.put("deh", 22);
    freq.put("dei", 40);
    freq.put("dej", 43);
    freq.put("dek", 181);
    freq.put("del", 164);
    freq.put("gI", 11);
    freq.put("den", 593);
    freq.put("deo", 45);
    freq.put("jdu", 10);
    freq.put("dea", 14);
    freq.put("deb", 19);
    freq.put("dec", 20);
    freq.put("ded", 13);
    freq.put("dee", 22);
    freq.put("deg", 136);
    freq.put("ítv", 21);
    freq.put("pro", 164);
    freq.put("ülő", 41);
    freq.put("csm", 11);
    freq.put("cso", 326);
    freq.put("iPa", 9);
    freq.put("csi", 681);
    freq.put("csk", 81);
    freq.put("cse", 201);
    freq.put("wp ", 8);
    freq.put("iPh", 16);
    freq.put("csa", 1079);
    freq.put("íth", 30);
    freq.put("csb", 12);
    freq.put("csy", 22);
    freq.put("csu", 37);
    freq.put("csr", 12);
    freq.put("bke", 8);
    freq.put("Don", 12);
    freq.put("Dom", 14);
    freq.put("Dor", 41);
    freq.put("íta", 53);
    freq.put("deó", 288);
    freq.put("cs ", 404);
    freq.put("ry ", 158);
    freq.put("jó ", 520);
    freq.put("uh ", 8);
    freq.put("ok ", 2240);
    freq.put("őse", 30);
    freq.put("pcs", 96);
    freq.put("őss", 15);
    freq.put("pci", 8);
    freq.put("ősz", 112);
    freq.put("Bat", 21);
    freq.put("okr", 61);
    freq.put("Bar", 70);
    freq.put("Bas", 15);
    freq.put("uha", 33);
    freq.put("jól", 119);
    freq.put("uhh", 11);
    freq.put("Bay", 8);
    freq.put("jót", 27);
    freq.put("jóv", 12);
    freq.put("okb", 54);
    freq.put("Bab", 18);
    freq.put("ódá", 15);
    freq.put("jós", 10);
    freq.put("Ban", 33);
    freq.put("aka", 427);
    freq.put("Bal", 53);
    freq.put("Baj", 18);
    freq.put("Bak", 10);
    freq.put("oko", 181);
    freq.put("sle", 32);
    freq.put("ős ", 88);
    freq.put("uj ", 25);
    freq.put("úlé", 13);
    freq.put("pc ", 8);
    freq.put("fa ", 26);
    freq.put("ód ", 15);
    freq.put("mm ", 45);
    freq.put("úl ", 72);
    freq.put("ősé", 59);
    freq.put("E ", 344);
    freq.put("ősí", 16);
    freq.put("íks", 8);
    freq.put("ősö", 23);
    freq.put("mmy", 8);
    freq.put("uhá", 37);
    freq.put("mmu", 18);
    freq.put("jóé", 10);
    freq.put("oká", 58);
    freq.put("kő", 31);
    freq.put("sba", 97);
    freq.put("mmi", 176);
    freq.put("sbe", 50);
    freq.put("oké", 48);
    freq.put("Uni", 18);
    freq.put("ódn", 13);
    freq.put("ódo", 47);
    freq.put("mma", 55);
    freq.put("ódi", 36);
    freq.put("ódj", 12);
    freq.put("Em", 51);
    freq.put("El", 209);
    freq.put("Eo", 10);
    freq.put("En", 74);
    freq.put("Ei", 9);
    freq.put("Eh", 13);
    freq.put("Ek", 13);
    freq.put("Ej", 10);
    freq.put("Ed", 46);
    freq.put("Eg", 303);
    freq.put("Ef", 8);
    freq.put("Ea", 14);
    freq.put("Ec", 27);
    freq.put("Eb", 24);
    freq.put("últ", 57);
    freq.put("kű", 12);
    freq.put("úlv", 28);
    freq.put("Ey", 12);
    freq.put("Ex", 32);
    freq.put("Ez", 194);
    freq.put("Eu", 62);
    freq.put("Et", 15);
    freq.put("Ew", 15);
    freq.put("Ev", 50);
    freq.put("Eq", 9);
    freq.put("Ep", 14);
    freq.put("Es", 82);
    freq.put("Er", 74);
    freq.put("gö", 68);
    freq.put("ude", 33);
    freq.put("gó", 143);
    freq.put("gie", 15);
    freq.put(" el", 1827);
    freq.put("koh", 10);
    freq.put(" en", 352);
    freq.put("kom", 176);
    freq.put("kol", 271);
    freq.put("koo", 11);
    freq.put(" ek", 21);
    freq.put(" ed", 130);
    freq.put("koc", 47);
    freq.put(" eg", 2118);
    freq.put(" ea", 8);
    freq.put(" eb", 74);
    freq.put(" ec", 13);
    freq.put("koz", 283);
    freq.put(" ex", 42);
    freq.put(" ez", 1111);
    freq.put(" et", 72);
    freq.put(" eu", 38);
    freq.put("kos", 168);
    freq.put("kor", 1171);
    freq.put(" ep", 23);
    freq.put("kot", 111);
    freq.put(" er", 294);
    freq.put(" es", 626);
    freq.put("sün", 18);
    freq.put("zg", 95);
    freq.put("Í", 55);
    freq.put("gú", 43);
    freq.put("gic", 13);
    freq.put("ood", 25);
    freq.put("Xh", 8);
    freq.put("b", 12988);
    freq.put("Xn", 9);
    freq.put("Xo", 12);
    freq.put("Xm", 11);
    freq.put("Xb", 14);
    freq.put("Xc", 16);
    freq.put("ké", 1545);
    freq.put("Xa", 15);
    freq.put("Xf", 10);
    freq.put("Xd", 12);
    freq.put("Xe", 15);
    freq.put("kó", 123);
    freq.put("Xx", 12);
    freq.put("Xy", 9);
    freq.put("kö", 1311);
    freq.put("Xr", 12);
    freq.put("kú", 26);
    freq.put("Xp", 14);
    freq.put("Xq", 13);
    freq.put("Xw", 9);
    freq.put("Xt", 9);
    freq.put("Xu", 13);
    freq.put("gá", 419);
    freq.put("AD ", 12);
    freq.put("gí", 102);
    freq.put("k ", 11125);
    freq.put("Kis", 61);
    freq.put("Kir", 15);
    freq.put("Kiv", 14);
    freq.put("Kit", 19);
    freq.put("őne", 23);
    freq.put("Kin", 30);
    freq.put("Kim", 18);
    freq.put("Kil", 8);
    freq.put("Kic", 15);
    freq.put("Kia", 11);
    freq.put("őnk", 11);
    freq.put("kC", 11);
    freq.put("kB", 14);
    freq.put("kA", 14);
    freq.put("kG", 14);
    freq.put("kE", 15);
    freq.put("Ata", 9);
    freq.put("kJ", 11);
    freq.put("kI", 12);
    freq.put("kH", 8);
    freq.put("kO", 11);
    freq.put("kN", 11);
    freq.put("kM", 12);
    freq.put("kL", 8);
    freq.put("kS", 11);
    freq.put("Att", 33);
    freq.put("kW", 13);
    freq.put("kV", 10);
    freq.put("kU", 8);
    freq.put("kT", 11);
    freq.put("kY", 11);
    freq.put("kX", 9);
    freq.put("kc", 96);
    freq.put("kb", 274);
    freq.put("ka", 2430);
    freq.put("kg", 21);
    freq.put("kf", 31);
    freq.put("ke", 3869);
    freq.put("kd", 36);
    freq.put("kk", 954);
    freq.put("kj", 42);
    freq.put("ki", 2737);
    freq.put("kh", 77);
    freq.put("ko", 2831);
    freq.put("kn", 286);
    freq.put("km", 82);
    freq.put("kl", 229);
    freq.put("ks", 228);
    freq.put("kr", 385);
    freq.put("kq", 9);
    freq.put("kp", 31);
    freq.put("kw", 18);
    freq.put("kv", 72);
    freq.put("ku", 489);
    freq.put("kt", 405);
    freq.put("öhe", 26);
    freq.put("kz", 13);
    freq.put("ky", 102);
    freq.put("Ki ", 32);
    freq.put("bsé", 18);
    freq.put(" Bá", 36);
    freq.put("rét", 25);
    freq.put(" Bé", 27);
    freq.put("rés", 265);
    freq.put("rén", 38);
    freq.put("Tén", 13);
    freq.put("rém", 34);
    freq.put("rék", 24);
    freq.put("rég", 106);
    freq.put("réb", 14);
    freq.put("Opt", 9);
    freq.put("Ope", 10);
    freq.put("ikó", 16);
    freq.put("ikö", 26);
    freq.put("ína", 24);
    freq.put("lkö", 16);
    freq.put("iká", 78);
    freq.put("iké", 21);
    freq.put("Ky", 13);
    freq.put(" Be", 203);
    freq.put(" Ba", 234);
    freq.put(" Bl", 39);
    freq.put(" Bo", 128);
    freq.put(" Bi", 90);
    freq.put(" Bu", 125);
    freq.put(" Bt", 8);
    freq.put("ik ", 1125);
    freq.put(" Bp", 9);
    freq.put(" Br", 71);
    freq.put("DD ", 360);
    freq.put("iks", 10);
    freq.put("ikr", 22);
    freq.put(" B ", 53);
    freq.put("iku", 113);
    freq.put("ikt", 48);
    freq.put("ikb", 10);
    freq.put("éig", 11);
    freq.put("ike", 265);
    freq.put("kte", 50);
    freq.put("ikk", 72);
    freq.put("iki", 87);
    freq.put("iko", 350);
    freq.put("ikn", 15);
    freq.put("ikl", 31);
    freq.put("őbb", 78);
    freq.put("őbe", 59);
    freq.put("ceg", 11);
    freq.put("Irá", 10);
    freq.put("ga ", 187);
    freq.put("Néh", 20);
    freq.put("lég", 169);
    freq.put("léb", 10);
    freq.put("Ném", 13);
    freq.put("lél", 20);
    freq.put("ND ", 21);
    freq.put("lén", 41);
    freq.put("Nég", 9);
    freq.put("lék", 110);
    freq.put("Néz", 26);
    freq.put("lév", 28);
    freq.put("lép", 78);
    freq.put("lér", 59);
    freq.put("lés", 157);
    freq.put("Nép", 9);
    freq.put(" áá", 19);
    freq.put("gaz", 269);
    freq.put("gav", 10);
    freq.put("gat", 324);
    freq.put("gas", 88);
    freq.put("gar", 124);
    freq.put("gan", 33);
    freq.put("gam", 112);
    freq.put("gal", 199);
    freq.put("gak", 10);
    freq.put("gai", 19);
    freq.put("My ", 13);
    freq.put("gag", 10);
    freq.put("gad", 118);
    freq.put("gab", 38);
    freq.put("lba", 42);
    freq.put("fut", 73);
    freq.put("fur", 36);
    freq.put("fuc", 27);
    freq.put("fun", 10);
    freq.put("lbe", 40);
    freq.put("ful", 20);
    freq.put("sy ", 36);
    freq.put("Iro", 12);
    freq.put("yír", 16);
    freq.put("yít", 26);
    freq.put("raz", 29);
    freq.put("ewa", 9);
    freq.put("lbo", 17);
    freq.put("ews", 11);
    freq.put("ray", 12);
    freq.put("yíl", 21);
    freq.put("dge", 12);
    freq.put("íto", 111);
    freq.put("zlJ", 8);
    freq.put("mok", 68);
    freq.put("ew ", 33);
    freq.put("ppe", 79);
    freq.put("jba", 10);
    freq.put("y", 16843);
    freq.put("lda", 139);
    freq.put("lde", 40);
    freq.put("ldj", 27);
    freq.put("ldi", 43);
    freq.put("mol", 113);
    freq.put("ldo", 127);
    freq.put("bi ", 123);
    freq.put("lds", 17);
    freq.put("ldr", 18);
    freq.put("ldv", 10);
    freq.put("ldt", 23);
    freq.put("Á ", 15);
    freq.put("cus", 15);
    freq.put("rgy", 43);
    freq.put("rga", 86);
    freq.put("cuc", 22);
    freq.put("rge", 53);
    freq.put("rgi", 47);
    freq.put("cuk", 57);
    freq.put("rgo", 43);
    freq.put("bin", 20);
    freq.put("bio", 15);
    freq.put("bil", 68);
    freq.put("ld ", 120);
    freq.put("cem", 32);
    freq.put("bik", 29);
    freq.put("bii", 21);
    freq.put("Die", 9);
    freq.put("Dig", 9);
    freq.put("bic", 20);
    freq.put("bia", 8);
    freq.put("biz", 165);
    freq.put("AL ", 22);
    freq.put("bit", 35);
    freq.put("bir", 37);
    freq.put("bis", 14);
    freq.put("Dir", 36);
    freq.put("Dis", 8);
    freq.put("ÁR ", 11);
    freq.put("Ád", 10);
    freq.put("ppi", 15);
    freq.put("Ál", 43);
    freq.put("rg ", 11);
    freq.put("Ár", 17);
    freq.put("Át", 17);
    freq.put("zlo", 25);
    freq.put("ávi", 9);
    freq.put("ldá", 27);
    freq.put("aCs", 14);
    freq.put("ldö", 39);
    freq.put("NT ", 21);
    freq.put("oe ", 14);
    freq.put("üt ", 11);
    freq.put(" lá", 419);
    freq.put("pez", 22);
    freq.put("pet", 175);
    freq.put("per", 302);
    freq.put("pes", 169);
    freq.put("pel", 54);
    freq.put("rgá", 8);
    freq.put("pen", 118);
    freq.put("pei", 12);
    freq.put("pek", 93);
    freq.put("ped", 127);
    freq.put("rgé", 16);
    freq.put("ape", 97);
    freq.put("pea", 12);
    freq.put("pec", 32);
    freq.put("Box", 11);
    freq.put(" vá", 463);
    freq.put("ítő", 60);
    freq.put("Bor", 28);
    freq.put("use", 25);
    freq.put("O", 1077);
    freq.put("fee", 18);
    freq.put("Bol", 31);
    freq.put("oel", 8);
    freq.put("Bog", 13);
    freq.put("uff", 17);
    freq.put("ä", 10);
    freq.put("üti", 13);
    freq.put("uso", 43);
    freq.put("ütt", 45);
    freq.put(" ló", 17);
    freq.put("pe ", 48);
    freq.put("fel", 807);
    freq.put("nsh", 12);
    freq.put("rgő", 15);
    freq.put("nso", 33);
    freq.put("usk", 31);
    freq.put("nse", 27);
    freq.put("nsz", 42);
    freq.put("Júl", 8);
    freq.put("sd ", 51);
    freq.put("jük", 81);
    freq.put("Nyí", 10);
    freq.put("nst", 56);
    freq.put("lyé", 31);
    freq.put("höl", 8);
    freq.put(" gö", 15);
    freq.put(" gó", 23);
    freq.put("Kön", 16);
    freq.put("Köl", 10);
    freq.put("új ", 276);
    freq.put("Köv", 11);
    freq.put("gó ", 38);
    freq.put("ust", 90);
    freq.put("Kör", 9);
    freq.put("Kös", 46);
    freq.put(" gá", 35);
    freq.put("óká", 11);
    freq.put("Köz", 39);
    freq.put(" gé", 56);
    freq.put("ns ", 42);
    freq.put("ófo", 14);
    freq.put("Flo", 10);
    freq.put("ófi", 13);
    freq.put("ófe", 11);
    freq.put("sdi", 11);
    freq.put("gós", 11);
    freq.put("gór", 8);
    freq.put("gót", 12);
    freq.put("újd", 10);
    freq.put("úja", 52);
    freq.put("usz", 232);
    freq.put("zha", 49);
    freq.put("zhe", 36);
    freq.put("gód", 11);
    freq.put("gói", 12);
    freq.put("úju", 12);
    freq.put("újt", 22);
    freq.put("újs", 21);
    freq.put("újr", 53);
    freq.put("zho", 9);
    freq.put("lyt", 87);
    freq.put("nsé", 28);
    freq.put("lyr", 24);
    freq.put("lys", 27);
    freq.put("nsá", 41);
    freq.put("Jöv", 14);
    freq.put("lyz", 32);
    freq.put("Nyu", 15);
    freq.put("lye", 739);
    freq.put("Nyi", 13);
    freq.put("Nyo", 8);
    freq.put("lyb", 20);
    freq.put("lyl", 8);
    freq.put("lyn", 21);
    freq.put("Nya", 10);
    freq.put("lyh", 9);
    freq.put("lyi", 121);
    freq.put("Nye", 14);
    freq.put("Map", 9);
    freq.put(" gt", 8);
    freq.put("Mar", 81);
    freq.put(" gr", 52);
    freq.put("Mat", 26);
    freq.put("May", 9);
    freq.put("Sno", 12);
    freq.put(" gy", 445);
    freq.put("Mac", 12);
    freq.put(" ge", 69);
    freq.put("Mad", 26);
    freq.put("Mag", 190);
    freq.put(" ga", 108);
    freq.put("Mai", 10);
    freq.put(" go", 263);
    freq.put(" gl", 20);
    freq.put("Maj", 27);
    freq.put("Mam", 12);
    freq.put("Mal", 12);
    freq.put(" gi", 51);
    freq.put(" ch", 79);
    freq.put("ly ", 296);
    freq.put("újí", 9);
    freq.put("kma", 27);
    freq.put("Ma ", 80);
    freq.put(" g ", 54);
    freq.put(" cc", 18);
    freq.put(" b", 3286);
    freq.put(" c", 7251);
    freq.put(" ca", 76);
    freq.put(" f", 3828);
    freq.put(" g", 1375);
    freq.put(" d", 2423);
    freq.put(" e", 7406);
    freq.put("Az ", 335);
    freq.put(" k", 7136);
    freq.put(" h", 11238);
    freq.put(" i", 4353);
    freq.put(" n", 6463);
    freq.put(" o", 1921);
    freq.put(" l", 4048);
    freq.put(" m", 10954);
    freq.put(" r", 2382);
    freq.put(" s", 5980);
    freq.put(" p", 2231);
    freq.put(" q", 182);
    freq.put(" v", 6007);
    freq.put(" w", 371);
    freq.put(" t", 9821);
    freq.put(" u", 956);
    freq.put(" z", 692);
    freq.put(" x", 963);
    freq.put(" y", 275);
    freq.put(" B", 1319);
    freq.put(" C", 893);
    freq.put(" A", 2696);
    freq.put(" F", 1068);
    freq.put(" G", 793);
    freq.put(" D", 3507);
    freq.put(" E", 1466);
    freq.put(" J", 792);
    freq.put(" K", 1422);
    freq.put(" H", 1530);
    freq.put(" I", 797);
    freq.put(" N", 1402);
    freq.put(" O", 748);
    freq.put(" L", 1011);
    freq.put(" M", 2447);
    freq.put(" R", 1710);
    freq.put(" S", 1820);
    freq.put(" P", 1014);
    freq.put(" Q", 195);
    freq.put(" V", 927);
    freq.put(" W", 405);
    freq.put(" T", 1479);
    freq.put(" U", 366);
    freq.put(" Z", 415);
    freq.put(" X", 606);
    freq.put(" Y", 476);
    freq.put("sén", 14);
    freq.put("sém", 13);
    freq.put("sél", 42);
    freq.put("öng", 18);
    freq.put("öne", 13);
    freq.put("önd", 14);
    freq.put("önb", 29);
    freq.put("Azo", 8);
    freq.put("önn", 99);
    freq.put("önm", 9);
    freq.put("önl", 42);
    freq.put("önk", 16);
    freq.put("önj", 13);
    freq.put("önt", 94);
    freq.put("Azt", 52);
    freq.put(" ?", 14);
    freq.put("öny", 135);
    freq.put("ws ", 22);
    freq.put("sé ", 43);
    freq.put(" cu", 86);
    freq.put("ől ", 491);
    freq.put(" mű", 102);
    freq.put(" á", 787);
    freq.put(" è", 9);
    freq.put(" é", 3645);
    freq.put(" í", 489);
    freq.put(" ó", 273);
    freq.put(" ö", 429);
    freq.put("ósz", 30);
    freq.put(" ú", 732);
    freq.put(" ü", 248);
    freq.put(" Á", 136);
    freq.put(" É", 353);
    freq.put("Ors", 13);
    freq.put(" Í", 55);
    freq.put("Oro", 8);
    freq.put(" Ö", 71);
    freq.put(" Ú", 189);
    freq.put("Orb", 44);
    freq.put(" Ü", 34);
    freq.put("Azé", 27);
    freq.put("önö", 82);
    freq.put("ÉK ", 13);
    freq.put("Lsz", 8);
    freq.put(" Do", 94);
    freq.put(" Dm", 8);
    freq.put("Ver", 15);
    freq.put("Ves", 16);
    freq.put(" Di", 86);
    freq.put(" Df", 14);
    freq.put(" De", 193);
    freq.put(" Dd", 14);
    freq.put(" Da", 104);
    freq.put("Veg", 10);
    freq.put("ii ", 224);
    freq.put(" Du", 32);
    freq.put(" Dt", 27);
    freq.put(" Dr", 27);
    freq.put("Fp", 9);
    freq.put("Fq", 10);
    freq.put("Fr", 59);
    freq.put("Fs", 12);
    freq.put("Ft", 96);
    freq.put("afé", 8);
    freq.put("Fv", 10);
    freq.put("Fw", 10);
    freq.put("Fy", 9);
    freq.put("Fz", 17);
    freq.put("chl", 10);
    freq.put("chm", 11);
    freq.put("chn", 16);
    freq.put("cho", 20);
    freq.put("Fa", 162);
    freq.put(" Ő", 36);
    freq.put(" ő", 245);
    freq.put("Fe", 196);
    freq.put("Ff", 13);
    freq.put("Fg", 12);
    freq.put("Fi", 97);
    freq.put("Fj", 8);
    freq.put("Fk", 14);
    freq.put("Fl", 34);
    freq.put("Fn", 10);
    freq.put("ádé", 10);
    freq.put("iit", 11);
    freq.put("iis", 10);
    freq.put("iir", 10);
    freq.put("tsd", 20);
    freq.put("yáj", 38);
    freq.put(" D ", 1153);
    freq.put("iia", 10);
    freq.put("iin", 11);
    freq.put("iii", 135);
    freq.put("iih", 11);
    freq.put("iik", 9);
    freq.put("ch ", 56);
    freq.put("dön", 80);
    freq.put("dök", 10);
    freq.put("f", 6518);
    freq.put("dög", 16);
    freq.put("döb", 10);
    freq.put("F ", 181);
    freq.put("ack", 71);
    freq.put("döt", 34);
    freq.put("dös", 13);
    freq.put("dör", 11);
    freq.put(" Dé", 13);
    freq.put("kéz", 21);
    freq.put(" Dá", 10);
    freq.put(" Dö", 8);
    freq.put(" Dó", 11);
    freq.put("Yi", 14);
    freq.put("Yh", 13);
    freq.put("ádt", 12);
    freq.put("Yj", 12);
    freq.put("Ym", 11);
    freq.put("Yl", 8);
    freq.put("Fö", 12);
    freq.put("Ya", 28);
    freq.put("afe", 42);
    freq.put("Yc", 8);
    freq.put("Yb", 11);
    freq.put("Ye", 11);
    freq.put("afa", 15);
    freq.put("Yg", 10);
    freq.put("Yf", 10);
    freq.put("Yy", 12);
    freq.put("Fá", 13);
    freq.put("gcs", 44);
    freq.put("ádb", 10);
    freq.put("áda", 8);
    freq.put("aft", 11);
    freq.put("Fé", 30);
    freq.put("ádl", 9);
    freq.put("Yr", 10);
    freq.put("Yu", 10);
    freq.put("Yt", 19);
    freq.put("Yw", 8);
    freq.put("Yv", 10);
    freq.put("sis", 30);
    freq.put("kép", 481);
    freq.put("sip", 20);
    freq.put("két", 144);
    freq.put("Y ", 205);
    freq.put("af ", 11);
    freq.put("ád ", 74);
    freq.put("lF", 10);
    freq.put("lG", 8);
    freq.put("lD", 11);
    freq.put("lE", 10);
    freq.put("lB", 13);
    freq.put("lC", 9);
    freq.put("lA", 12);
    freq.put("lN", 11);
    freq.put("lO", 19);
    freq.put("lL", 13);
    freq.put("lM", 12);
    freq.put("lJ", 20);
    freq.put("lK", 13);
    freq.put("lH", 10);
    freq.put("lV", 9);
    freq.put("lW", 10);
    freq.put("lT", 10);
    freq.put("Nk", 16);
    freq.put("lR", 17);
    freq.put("lS", 19);
    freq.put("lQ", 9);
    freq.put("lX", 12);
    freq.put("lY", 16);
    freq.put("lf", 174);
    freq.put("lg", 402);
    freq.put("ld", 688);
    freq.put("le", 6365);
    freq.put("lb", 207);
    freq.put("bja", 14);
    freq.put("la", 3150);
    freq.put("ln", 1109);
    freq.put("lo", 1487);
    freq.put("ll", 2361);
    freq.put("lm", 817);
    freq.put("lj", 533);
    freq.put("lk", 652);
    freq.put("lh", 269);
    freq.put("li", 1825);
    freq.put("lv", 598);
    freq.put("lw", 23);
    freq.put("lt", 2806);
    freq.put("lu", 509);
    freq.put("lr", 132);
    freq.put("ls", 573);
    freq.put("lp", 52);
    freq.put("űve", 17);
    freq.put("sig", 47);
    freq.put("tst", 11);
    freq.put("tsu", 11);
    freq.put("lz", 61);
    freq.put("lx", 12);
    freq.put("ly", 2070);
    freq.put("eme", 338);
    freq.put("daf", 10);
    freq.put("dag", 21);
    freq.put("daa", 15);
    freq.put("dab", 8);
    freq.put("dal", 270);
    freq.put("dam", 38);
    freq.put("dan", 100);
    freq.put("dai", 28);
    freq.put("dak", 17);
    freq.put("dat", 127);
    freq.put("dav", 24);
    freq.put("dap", 87);
    freq.put("dar", 68);
    freq.put("das", 66);
    freq.put("day", 36);
    freq.put("CK ", 8);
    freq.put("emc", 11);
    freq.put("l ", 6367);
    freq.put("ilá", 158);
    freq.put("ts ", 70);
    freq.put("emm", 196);
    freq.put("rrő", 35);
    freq.put("eml", 97);
    freq.put("emo", 43);
    freq.put("lfe", 43);
    freq.put("emn", 23);
    freq.put("lfa", 11);
    freq.put("emi", 86);
    freq.put("lfo", 44);
    freq.put("zőr", 9);
    freq.put("zős", 10);
    freq.put("zőj", 11);
    freq.put("zők", 37);
    freq.put("lfr", 9);
    freq.put("zőg", 8);
    freq.put("ződ", 20);
    freq.put("zőb", 26);
    freq.put("rez", 101);
    freq.put("aú", 8);
    freq.put("lá", 1720);
    freq.put("rer", 10);
    freq.put("res", 344);
    freq.put("Tur", 8);
    freq.put("lí", 134);
    freq.put("rev", 36);
    freq.put("CS ", 11);
    freq.put("ret", 474);
    freq.put("lé", 821);
    freq.put("lö", 241);
    freq.put("rek", 369);
    freq.put("reh", 11);
    freq.put("rei", 26);
    freq.put("ren", 451);
    freq.put("ló", 574);
    freq.put("Tun", 9);
    freq.put("rem", 278);
    freq.put("reb", 24);
    freq.put("rec", 95);
    freq.put("Tub", 232);
    freq.put("rea", 114);
    freq.put("Tud", 45);
    freq.put("reg", 233);
    freq.put("red", 112);
    freq.put("emp", 38);
    freq.put("JÓ ", 8);
    freq.put("lf ", 12);
    freq.put("qua", 11);
    freq.put("que", 20);
    freq.put("ző ", 138);
    freq.put("re ", 996);
    freq.put("emz", 46);
    freq.put("ud ", 56);
    freq.put("lő", 651);
    freq.put("og ", 241);
    freq.put("mié", 147);
    freq.put(" öc", 13);
    freq.put("miá", 10);
    freq.put(" öl", 26);
    freq.put(" ön", 39);
    freq.put(" ös", 168);
    freq.put(" ör", 102);
    freq.put(" öt", 58);
    freq.put("mió", 8);
    freq.put("uds", 31);
    freq.put("ogy", 1718);
    freq.put("udt", 94);
    freq.put("udu", 10);
    freq.put("ogu", 15);
    freq.put("ogt", 22);
    freq.put("ogv", 9);
    freq.put("ogs", 44);
    freq.put("ogr", 63);
    freq.put("ogl", 91);
    freq.put("ogo", 204);
    freq.put("ogn", 36);
    freq.put("ogi", 32);
    freq.put("ogh", 9);
    freq.put("udd", 11);
    freq.put("sfé", 13);
    freq.put("oge", 19);
    freq.put("ogd", 9);
    freq.put("ogg", 22);
    freq.put("udi", 49);
    freq.put("oga", 213);
    freq.put("udo", 419);
    freq.put("ogc", 8);
    freq.put("ogb", 10);
    freq.put("üve", 65);
    freq.put("nun", 18);
    freq.put("Pap", 13);
    freq.put("Par", 50);
    freq.put("Pat", 25);
    freq.put("Pay", 11);
    freq.put("Pad", 11);
    freq.put("Pal", 10);
    freq.put("Pan", 25);
    freq.put("mii", 29);
    freq.put("mih", 10);
    freq.put("mik", 361);
    freq.put("mil", 274);
    freq.put("mio", 13);
    freq.put("min", 1274);
    freq.put("mia", 117);
    freq.put("mic", 23);
    freq.put("mib", 37);
    freq.put("mie", 37);
    freq.put("mix", 27);
    freq.put("miz", 24);
    freq.put(" öö", 8);
    freq.put("mis", 68);
    freq.put("mir", 76);
    freq.put("miu", 21);
    freq.put("mit", 454);
    freq.put("miv", 40);
    freq.put("ogó", 23);
    freq.put("sfi", 12);
    freq.put("sfe", 11);
    freq.put("ogá", 36);
    freq.put("mi ", 781);
    freq.put("xd ", 86);
    freq.put(" iP", 29);
    freq.put(" iT", 11);
    freq.put("yű ", 24);
    freq.put(" iO", 15);
    freq.put(" iA", 14);
    freq.put("Moz", 9);
    freq.put(" iz", 61);
    freq.put(" ip", 17);
    freq.put("Mor", 18);
    freq.put(" ir", 122);
    freq.put(" is", 1740);
    freq.put(" it", 329);
    freq.put("Mou", 10);
    freq.put(" iw", 9);
    freq.put("sők", 8);
    freq.put(" ii", 10);
    freq.put(" ij", 10);
    freq.put(" ik", 20);
    freq.put(" il", 313);
    freq.put("Mon", 49);
    freq.put(" in", 437);
    freq.put("Mol", 8);
    freq.put("Íme", 11);
    freq.put(" ia", 29);
    freq.put(" ib", 8);
    freq.put(" ic", 33);
    freq.put(" id", 423);
    freq.put(" if", 14);
    freq.put("Mod", 11);
    freq.put("xdd", 101);
    freq.put("mum", 10);
    freq.put("dőj", 14);
    freq.put("ölö", 12);
    freq.put("yás", 28);
    freq.put("ks ", 20);
    freq.put("dők", 18);
    freq.put(" i ", 61);
    freq.put("ső ", 214);
    freq.put("öl ", 18);
    freq.put("Zol", 22);
    freq.put("we", 168);
    freq.put("wd", 24);
    freq.put(" Fő", 15);
    freq.put(" Ór", 8);
    freq.put("jno", 77);
    freq.put("wo", 76);
    freq.put("ksá", 20);
    freq.put("he ", 111);
    freq.put("ksé", 25);
    freq.put(" Ir", 33);
    freq.put("ük ", 185);
    freq.put("wl", 18);
    freq.put("öln", 9);
    freq.put(" It", 73);
    freq.put("ölc", 22);
    freq.put("öle", 19);
    freq.put("öld", 112);
    freq.put("ölg", 16);
    freq.put("öly", 11);
    freq.put("S", 2143);
    freq.put("wi", 196);
    freq.put("vre", 12);
    freq.put("wh", 41);
    freq.put("ölt", 224);
    freq.put("è", 32);
    freq.put("üks", 23);
    freq.put("dú", 9);
    freq.put(" Ó ", 8);
    freq.put("üke", 15);
    freq.put(" Im", 36);
    freq.put("aa", 595);
    freq.put("wq", 10);
    freq.put(" Fö", 12);
    freq.put("ohn", 17);
    freq.put(" Fá", 12);
    freq.put("oho", 24);
    freq.put(" Fé", 30);
    freq.put("ohh", 9);
    freq.put("űvé", 25);
    freq.put("émá", 32);
    freq.put("ys ", 21);
    freq.put("wz", 9);
    freq.put("ai", 783);
    freq.put("Ná", 13);
    freq.put("wx", 8);
    freq.put("ak", 4179);
    freq.put("OL ", 17);
    freq.put("Hom", 14);
    freq.put("yűl", 11);
    freq.put("ild", 11);
    freq.put("oha", 113);
    freq.put("ile", 106);
    freq.put("ilb", 12);
    freq.put("cot", 19);
    freq.put("yűj", 19);
    freq.put("uis", 24);
    freq.put("yse", 17);
    freq.put("ysz", 219);
    freq.put("Hou", 8);
    freq.put("Hor", 30);
    freq.put("ébb", 9);
    freq.put("Hos", 14);
    freq.put("wL", 10);
    freq.put(" Fu", 30);
    freq.put("Hop", 10);
    freq.put("emé", 287);
    freq.put("ilk", 46);
    freq.put(" Fa", 144);
    freq.put(" Fe", 189);
    freq.put(" Fi", 86);
    freq.put("wH", 11);
    freq.put(" Fl", 23);
    freq.put(" Fo", 70);
    freq.put("io ", 30);
    freq.put("éma", 27);
    freq.put("ilv", 51);
    freq.put("émb", 8);
    freq.put("éme", 46);
    freq.put("vál", 317);
    freq.put("émi", 22);
    freq.put("vác", 13);
    freq.put("vág", 72);
    freq.put("ybő", 10);
    freq.put("vár", 293);
    freq.put("vás", 65);
    freq.put("vát", 13);
    freq.put("cod", 9);
    freq.put("iot", 15);
    freq.put("ios", 12);
    freq.put("ior", 10);
    freq.put(" F ", 59);
    freq.put("iol", 13);
    freq.put("pke", 9);
    freq.put("iof", 8);
    freq.put("cok", 27);
    freq.put("GA ", 9);
    freq.put("ém ", 112);
    freq.put("ysé", 12);
    freq.put("vá ", 13);
    freq.put("col", 54);
    freq.put("coo", 9);
    freq.put("ily", 448);
    freq.put("Can", 16);
    freq.put("njá", 11);
    freq.put("ező", 149);
    freq.put("njü", 16);
    freq.put("adv", 15);
    freq.put("adt", 225);
    freq.put("adu", 18);
    freq.put("gmo", 18);
    freq.put("ads", 24);
    freq.put("zöm", 10);
    freq.put("zöl", 37);
    freq.put("gma", 16);
    freq.put("esü", 28);
    freq.put("ájt", 8);
    freq.put("áju", 58);
    freq.put("gme", 12);
    freq.put("ady", 29);
    freq.put("tmá", 33);
    freq.put("add", 56);
    freq.put("ájk", 47);
    freq.put("ájl", 14);
    freq.put("ada", 145);
    freq.put("adn", 88);
    freq.put("ado", 143);
    freq.put("adl", 13);
    freq.put("adm", 12);
    freq.put("adj", 62);
    freq.put("zöv", 35);
    freq.put("gmu", 14);
    freq.put("adi", 79);
    freq.put("ltó", 19);
    freq.put("ad ", 303);
    freq.put("áj ", 57);
    freq.put("nja", 25);
    freq.put("nje", 24);
    freq.put("ui ", 9);
    freq.put("pko", 8);
    freq.put("ájú", 8);
    freq.put("est", 501);
    freq.put("ess", 298);
    freq.put("adó", 104);
    freq.put("esp", 26);
    freq.put("yát", 30);
    freq.put("yáv", 14);
    freq.put("esz", 1455);
    freq.put("ájö", 32);
    freq.put("yár", 105);
    freq.put("yám", 26);
    freq.put("ájé", 14);
    freq.put("ese", 523);
    freq.put("esd", 16);
    freq.put("esc", 19);
    freq.put("esb", 24);
    freq.put("esa", 13);
    freq.put("adá", 133);
    freq.put("eso", 36);
    freq.put("ájá", 77);
    freq.put("esm", 16);
    freq.put("esl", 19);
    freq.put("esk", 53);
    freq.put("esi", 95);
    freq.put("adé", 18);
    freq.put("nj ", 14);
    freq.put("OS ", 21);
    freq.put("es ", 1167);
    freq.put("piá", 15);
    freq.put("Twi", 15);
    freq.put("De ", 109);
    freq.put("bu ", 11);
    freq.put("rcu", 8);
    freq.put("rcr", 11);
    freq.put("rcs", 70);
    freq.put("tju", 26);
    freq.put("rco", 32);
    freq.put("rch", 14);
    freq.put("rci", 68);
    freq.put("rce", 77);
    freq.put("rca", 28);
    freq.put("rcb", 10);
    freq.put("buz", 14);
    freq.put("bur", 18);
    freq.put("bus", 58);
    freq.put("Der", 9);
    freq.put("Des", 8);
    freq.put("but", 14);
    freq.put("buk", 31);
    freq.put("múg", 132);
    freq.put("bun", 25);
    freq.put("Dem", 11);
    freq.put("bul", 64);
    freq.put("bum", 60);
    freq.put("bub", 8);
    freq.put("Dea", 11);
    freq.put("Deb", 14);
    freq.put("bug", 11);
    freq.put("bud", 25);
    freq.put("zcs", 8);
    freq.put("j", 8989);
    freq.put("rc ", 66);
    freq.put("pih", 23);
    freq.put("pik", 14);
    freq.put("pil", 67);
    freq.put("eső", 44);
    freq.put("pia", 55);
    freq.put("pic", 54);
    freq.put("pid", 8);
    freq.put("pig", 14);
    freq.put("piz", 25);
    freq.put("ub ", 44);
    freq.put("our", 57);
    freq.put("pip", 14);
    freq.put("pir", 45);
    freq.put("pis", 35);
    freq.put("pit", 29);
    freq.put(" rt", 11);
    freq.put("oad", 9);
    freq.put("hír", 78);
    freq.put("oal", 8);
    freq.put("oar", 23);
    freq.put("sva", 11);
    freq.put("pi ", 101);
    freq.put("jít", 10);
    freq.put("ube", 291);
    freq.put("Ő ", 32);
    freq.put("ubb", 10);
    freq.put("ubl", 18);
    freq.put("ubo", 11);
    freq.put("ubi", 17);
    freq.put("ÚJ ", 9);
    freq.put("ötn", 8);
    freq.put("tőd", 8);
    freq.put(" ká", 79);
    freq.put(" ké", 1024);
    freq.put(" kí", 137);
    freq.put(" kó", 33);
    freq.put(" kö", 980);
    freq.put(" kü", 184);
    freq.put("tőb", 13);
    freq.put("Cro", 8);
    freq.put("lt ", 1215);
    freq.put("G ", 239);
    freq.put("Ez ", 109);
    freq.put("zd ", 104);
    freq.put("örű", 36);
    freq.put("tői", 22);
    freq.put("vű ", 15);
    freq.put("Gv", 10);
    freq.put("Gu", 49);
    freq.put("Gt", 12);
    freq.put("Gs", 11);
    freq.put("Gr", 69);
    freq.put("Gq", 12);
    freq.put("Gp", 14);
    freq.put("Ezt", 38);
    freq.put("zdt", 39);
    freq.put("Gz", 16);
    freq.put("Gy", 116);
    freq.put("Gg", 8);
    freq.put("Gf", 9);
    freq.put("Ge", 92);
    freq.put("Gd", 9);
    freq.put("Gc", 10);
    freq.put("Ga", 102);
    freq.put("zdj", 16);
    freq.put("Go", 110);
    freq.put("Eze", 18);
    freq.put("Gm", 12);
    freq.put("Gl", 32);
    freq.put("Gk", 9);
    freq.put("Gj", 14);
    freq.put("Gi", 58);
    freq.put("Gh", 13);
    freq.put(" kb", 68);
    freq.put(" ka", 559);
    freq.put(" kg", 8);
    freq.put(" ke", 1346);
    freq.put(" kk", 11);
    freq.put(" kh", 9);
    freq.put(" ki", 1491);
    freq.put(" kn", 12);
    freq.put(" ko", 621);
    freq.put(" kl", 65);
    freq.put(" km", 22);
    freq.put(" kr", 77);
    freq.put("ő ", 1119);
    freq.put(" kv", 13);
    freq.put(" ku", 213);
    freq.put("fér", 55);
    freq.put("fés", 9);
    freq.put("Hét", 19);
    freq.put("kuu", 18);
    freq.put("kut", 52);
    freq.put("Z ", 176);
    freq.put("kur", 87);
    freq.put("kup", 21);
    freq.put("kun", 17);
    freq.put("kum", 16);
    freq.put("gna", 186);
    freq.put("kuk", 19);
    freq.put("Oké", 15);
    freq.put("scr", 11);
    freq.put("fén", 46);
    freq.put("fél", 187);
    freq.put("őp", 15);
    freq.put("ős", 365);
    freq.put("őr", 202);
    freq.put("őt", 305);
    freq.put("őv", 64);
    freq.put("xfa", 15);
    freq.put("őz", 137);
    freq.put("őa", 39);
    freq.put("őb", 155);
    freq.put("őe", 43);
    freq.put("őd", 154);
    freq.put("őg", 24);
    freq.put("őf", 25);
    freq.put("ői", 72);
    freq.put("őh", 19);
    freq.put("ők", 267);
    freq.put("őj", 76);
    freq.put("őm", 59);
    freq.put("ől", 618);
    freq.put("őn", 97);
    freq.put("Zl", 20);
    freq.put("Gö", 9);
    freq.put("Zn", 9);
    freq.put("Zo", 37);
    freq.put("Zi", 17);
    freq.put("Zd", 14);
    freq.put("Ze", 29);
    freq.put("díj", 46);
    freq.put("Zg", 12);
    freq.put("Za", 59);
    freq.put("dís", 8);
    freq.put("Zx", 12);
    freq.put("Ezé", 8);
    freq.put("Gá", 19);
    freq.put("Zu", 28);
    freq.put("Zv", 10);
    freq.put("Zw", 10);
    freq.put("zdá", 9);
    freq.put("Zq", 8);
    freq.put("Gé", 10);
    freq.put("Zs", 85);
    freq.put("lom", 303);
    freq.put("zma", 11);
    freq.put("Kom", 19);
    freq.put("Kol", 11);
    freq.put("Kon", 9);
    freq.put("ör ", 66);
    freq.put("Kos", 11);
    freq.put("Kor", 25);
    freq.put("Kov", 12);
    freq.put("ená", 8);
    freq.put("m ", 9017);
    freq.put("ené", 116);
    freq.put("sít", 174);
    freq.put("sír", 73);
    freq.put("síp", 12);
    freq.put("sík", 17);
    freq.put("det", 162);
    freq.put("enü", 48);
    freq.put("mE", 15);
    freq.put("mD", 14);
    freq.put("mG", 19);
    freq.put("mA", 9);
    freq.put("örv", 26);
    freq.put("mC", 15);
    freq.put("mB", 10);
    freq.put("mM", 12);
    freq.put("mN", 15);
    freq.put("mI", 11);
    freq.put("mH", 16);
    freq.put("mK", 10);
    freq.put("mJ", 13);
    freq.put("mT", 10);
    freq.put("mW", 12);
    freq.put("mV", 9);
    freq.put("mQ", 10);
    freq.put("mP", 9);
    freq.put("mS", 12);
    freq.put("mR", 8);
    freq.put("öri", 28);
    freq.put("mX", 16);
    freq.put("örm", 15);
    freq.put("mZ", 10);
    freq.put("me", 4936);
    freq.put("md", 27);
    freq.put("mg", 42);
    freq.put("mf", 48);
    freq.put("ma", 2689);
    freq.put("ltu", 46);
    freq.put("mc", 41);
    freq.put("mb", 764);
    freq.put("mm", 435);
    freq.put("ml", 183);
    freq.put("mo", 1795);
    freq.put("mn", 114);
    freq.put("mi", 3879);
    freq.put("mh", 47);
    freq.put("mk", 56);
    freq.put("mj", 52);
    freq.put("mu", 391);
    freq.put("mt", 127);
    freq.put("mw", 19);
    freq.put("mv", 31);
    freq.put("mq", 10);
    freq.put("mp", 244);
    freq.put("ms", 156);
    freq.put("mr", 137);
    freq.put("zmu", 10);
    freq.put("my", 69);
    freq.put("mx", 14);
    freq.put("mz", 64);
    freq.put("Ké", 89);
    freq.put("kés", 226);
    freq.put("tő ", 239);
    freq.put("ena", 34);
    freq.put("enb", 25);
    freq.put("enc", 265);
    freq.put("end", 421);
    freq.put("éku", 8);
    freq.put("enf", 12);
    freq.put("eng", 218);
    freq.put("enh", 25);
    freq.put("eni", 198);
    freq.put("enj", 38);
    freq.put("enk", 306);
    freq.put("enl", 40);
    freq.put("enn", 857);
    freq.put("eno", 25);
    freq.put("enr", 18);
    freq.put("ens", 70);
    freq.put("ent", 679);
    freq.put("env", 30);
    freq.put("eny", 217);
    freq.put("enz", 22);
    freq.put("örö", 121);
    freq.put("ON ", 22);
    freq.put("örü", 85);
    freq.put("II ", 25);
    freq.put("öré", 12);
    freq.put("őő", 20);
    freq.put("má", 1723);
    freq.put("mí", 69);
    freq.put("mé", 1260);
    freq.put("mö", 37);
    freq.put("mó", 69);
    freq.put("mü", 53);
    freq.put("mú", 224);
    freq.put(" Hy", 12);
    freq.put("áhá", 8);
    freq.put("őő ", 8);
    freq.put(" Hu", 95);
    freq.put(" Hj", 8);
    freq.put(" Hi", 71);
    freq.put(" Ho", 268);
    freq.put(" Hm", 9);
    freq.put(" Ha", 444);
    freq.put("éki", 12);
    freq.put(" He", 74);
    freq.put("ima", 68);
    freq.put("imb", 16);
    freq.put("ime", 85);
    freq.put("imi", 75);
    freq.put("imh", 9);
    freq.put("ajó", 30);
    freq.put("imm", 19);
    freq.put("cla", 11);
    freq.put("ajö", 13);
    freq.put("imn", 11);
    freq.put("imp", 61);
    freq.put("imu", 22);
    freq.put("écs", 26);
    freq.put("ajá", 169);
    freq.put("JA ", 16);
    freq.put("SA ", 16);
    freq.put(" H ", 40);
    freq.put("im ", 103);
    freq.put(" Hú", 12);
    freq.put(" Hó", 8);
    freq.put("áhh", 10);
    freq.put("áho", 41);
    freq.put("ieb", 18);
    freq.put(" Hé", 25);
    freq.put(" Hí", 20);
    freq.put(" Há", 102);
    freq.put("imá", 122);
    freq.put("gol", 165);
    freq.put("ajz", 51);
    freq.put("gon", 266);
    freq.put("gok", 193);
    freq.put("god", 85);
    freq.put("ajr", 15);
    freq.put("ajs", 12);
    freq.put("ajt", 146);
    freq.put("aju", 15);
    freq.put("ajj", 45);
    freq.put("ajk", 9);
    freq.put("ajl", 10);
    freq.put("ajn", 161);
    freq.put("goz", 74);
    freq.put("aja", 91);
    freq.put("gow", 9);
    freq.put("ajd", 332);
    freq.put("gos", 102);
    freq.put("gor", 27);
    freq.put("áh ", 13);
    freq.put("W", 711);
    freq.put("Vic", 17);
    freq.put("yád", 12);
    freq.put("Vid", 43);
    freq.put("Vik", 73);
    freq.put("Vin", 8);
    freq.put("go ", 30);
    freq.put("Vil", 28);
    freq.put("Vir", 8);
    freq.put("Vis", 23);
    freq.put("Viv", 24);
    freq.put("aj ", 172);
    freq.put("be ", 698);
    freq.put("nhe", 18);
    freq.put("nha", 23);
    freq.put("nho", 19);
    freq.put("nis", 73);
    freq.put("toz", 89);
    freq.put("tor", 332);
    freq.put("tos", 298);
    freq.put("top", 44);
    freq.put("tov", 68);
    freq.put("EU ", 14);
    freq.put("tot", 424);
    freq.put("tou", 9);
    freq.put("toj", 13);
    freq.put("Kár", 12);
    freq.put("ton", 223);
    freq.put("too", 16);
    freq.put("tol", 194);
    freq.put("tom", 224);
    freq.put("tob", 21);
    freq.put("toc", 11);
    freq.put("kém", 19);
    freq.put("tog", 55);
    freq.put("tod", 58);
    freq.put("Fut", 8);
    freq.put("Fuc", 8);
    freq.put("kél", 28);
    freq.put("őőő", 8);
    freq.put("to ", 110);
    freq.put("thu", 10);
    freq.put("raf", 30);
    freq.put("rag", 71);
    freq.put("rad", 196);
    freq.put("rae", 16);
    freq.put("rab", 72);
    freq.put("rac", 30);
    freq.put("raa", 23);
    freq.put("ran", 265);
    freq.put("ral", 83);
    freq.put("ram", 122);
    freq.put("raj", 143);
    freq.put("rak", 147);
    freq.put("eps", 19);
    freq.put("rav", 13);
    freq.put("rat", 151);
    freq.put("rau", 8);
    freq.put("rar", 20);
    freq.put("ras", 75);
    freq.put("rap", 20);
    freq.put("bs ", 24);
    freq.put("rax", 9);
    freq.put("Kf", 17);
    freq.put("Kh", 9);
    freq.put("thi", 29);
    freq.put("bsz", 25);
    freq.put("Ks", 11);
    freq.put("epe", 89);
    freq.put("győ", 36);
    freq.put("thb", 12);
    freq.put("AS ", 8);
    freq.put("Itt", 45);
    freq.put("Its", 17);
    freq.put("éz", 596);
    freq.put("api", 124);
    freq.put("ép", 993);
    freq.put("és", 3450);
    freq.put("ér", 2142);
    freq.put("ét", 1024);
    freq.put("év", 464);
    freq.put("éi", 13);
    freq.put("éh", 98);
    freq.put("ék", 875);
    freq.put("éj", 117);
    freq.put("ém", 265);
    freq.put("él", 1437);
    freq.put("én", 1950);
    freq.put("éc", 51);
    freq.put("éb", 194);
    freq.put("éd", 209);
    freq.put("ég", 1992);
    freq.put("nuá", 15);
    freq.put("oci", 45);
    freq.put("ock", 60);
    freq.put("WE ", 9);
    freq.put("oco", 10);
    freq.put(" új", 382);
    freq.put("oca", 10);
    freq.put("Big", 8);
    freq.put(" úg", 256);
    freq.put("Bie", 9);
    freq.put("oce", 11);
    freq.put("nő ", 61);
    freq.put("Bia", 14);
    freq.put("ocz", 11);
    freq.put("Biz", 17);
    freq.put("ísé", 8);
    freq.put(" út", 41);
    freq.put("ocs", 113);
    freq.put("Bir", 13);
    freq.put(" ús", 8);
    freq.put(" úr", 21);
    freq.put("é ", 351);
    freq.put("urá", 20);
    freq.put("üre", 14);
    freq.put("ürd", 20);
    freq.put("Pet", 20);
    freq.put("nus", 21);
    freq.put("Per", 31);
    freq.put("Pes", 11);
    freq.put("éé", 105);
    freq.put("rül", 265);
    freq.put("nul", 153);
    freq.put("rün", 12);
    freq.put("Ped", 12);
    freq.put("mut", 84);
    freq.put("ísz", 9);
    freq.put("mus", 65);
    freq.put("zür", 9);
    freq.put("eac", 13);
    freq.put("mug", 32);
    freq.put(" úú", 18);
    freq.put("Kül", 17);
    freq.put("mul", 43);
    freq.put("mun", 106);
    freq.put("K", 1725);
    freq.put("elj", 170);
    freq.put("zbe", 93);
    freq.put("zba", 47);
    freq.put("XD ", 96);
    freq.put("üst", 11);
    freq.put("rto", 129);
    freq.put("Exp", 8);
    freq.put("bep", 9);
    freq.put("üss", 11);
    freq.put("mu ", 15);
    freq.put("elc", 20);
    freq.put(" me", 3435);
    freq.put(" ma", 1585);
    freq.put("ead", 53);
    freq.put(" mc", 8);
    freq.put(" mm", 19);
    freq.put(" mo", 1081);
    freq.put(" mi", 2307);
    freq.put(" mt", 8);
    freq.put(" mu", 178);
    freq.put("xx ", 25);
    freq.put(" mp", 12);
    freq.put("yim", 10);
    freq.put(" ms", 10);
    freq.put(" my", 21);
    freq.put("eag", 11);
    freq.put("ely", 422);
    freq.put("nőr", 14);
    freq.put(" m ", 74);
    freq.put("nős", 32);
    freq.put("xxx", 10);
    freq.put("Cra", 8);
    freq.put("TV ", 26);
    freq.put("epő", 16);
    freq.put("n", 42883);
    freq.put(" má", 1123);
    freq.put(" mí", 13);
    freq.put(" mé", 729);
    freq.put(" mö", 11);
    freq.put(" mó", 36);
    freq.put("pló", 11);
    freq.put(" mú", 61);
    freq.put("HP ", 9);
    freq.put("xo ", 8);
    freq.put("vve", 25);
    freq.put(" Jú", 17);
    freq.put(" Jö", 31);
    freq.put(" Jó", 108);
    freq.put(" Jé", 14);
    freq.put(" Já", 27);
    freq.put("Hú", 12);
    freq.put("elk", 218);
    freq.put("elh", 125);
    freq.put("eli", 235);
    freq.put("eln", 180);
    freq.put("elo", 97);
    freq.put("ell", 871);
    freq.put("elm", 275);
    freq.put("elb", 37);
    freq.put("Hó", 8);
    freq.put("icá", 9);
    freq.put("ela", 128);
    freq.put("elf", 91);
    freq.put("elg", 27);
    freq.put("eld", 75);
    freq.put("ele", 1369);
    freq.put("elz", 25);
    freq.put("Hé", 25);
    freq.put("Hí", 20);
    freq.put("elr", 35);
    freq.put("els", 270);
    freq.put("elp", 12);
    freq.put("Há", 103);
    freq.put("elv", 207);
    freq.put("elt", 388);
    freq.put("elu", 17);
    freq.put("D", 4134);
    freq.put("tve", 69);
    freq.put("el ", 1361);
    freq.put("tós", 28);
    freq.put("tóp", 11);
    freq.put(" Ju", 67);
    freq.put("ltő", 17);
    freq.put(" Jo", 78);
    freq.put(" Ji", 14);
    freq.put(" Je", 64);
    freq.put("nő", 240);
    freq.put(" Jf", 8);
    freq.put(" Ja", 130);
    freq.put("Hz", 13);
    freq.put("Hx", 12);
    freq.put("Hy", 21);
    freq.put("ico", 29);
    freq.put("elí", 12);
    freq.put("Hr", 15);
    freq.put("főv", 9);
    freq.put("Hp", 11);
    freq.put("Hq", 11);
    freq.put("Hw", 10);
    freq.put("Ht", 9);
    freq.put("Hu", 139);
    freq.put("Hj", 13);
    freq.put("Hk", 9);
    freq.put("Hh", 8);
    freq.put("Hi", 80);
    freq.put("Hn", 15);
    freq.put("Ho", 289);
    freq.put("Hl", 9);
    freq.put("Hm", 14);
    freq.put("Hb", 11);
    freq.put("nű", 27);
    freq.put("Ha", 461);
    freq.put("Hf", 10);
    freq.put("Hg", 10);
    freq.put("icu", 10);
    freq.put("He", 90);
    freq.put("lút", 9);
    freq.put("sük", 11);
    freq.put(" J ", 39);
    freq.put("Tár", 24);
    freq.put("ic ", 100);
    freq.put("H ", 157);
    freq.put("ánd", 71);
    freq.put("ppa", 38);
    freq.put("áng", 10);
    freq.put("ána", 152);
    freq.put("ánb", 9);
    freq.put("ánc", 103);
    freq.put("ánl", 75);
    freq.put("ánn", 25);
    freq.put("áno", 57);
    freq.put("ppo", 23);
    freq.put("áni", 37);
    freq.put("Nál", 9);
    freq.put("ánk", 54);
    freq.put("ánt", 52);
    freq.put("ánu", 12);
    freq.put("nnü", 8);
    freq.put("ahu", 11);
    freq.put("ppy", 20);
    freq.put("tű", 113);
    freq.put("ány", 485);
    freq.put("né", 1205);
    freq.put("git", 51);
    freq.put("gis", 62);
    freq.put("ní", 35);
    freq.put("gip", 8);
    freq.put("ná", 802);
    freq.put("giz", 16);
    freq.put("gig", 56);
    freq.put("nú", 15);
    freq.put("nü", 62);
    freq.put("gia", 45);
    freq.put("gin", 146);
    freq.put("gim", 12);
    freq.put("nó", 43);
    freq.put("gik", 9);
    freq.put("tiá", 8);
    freq.put("nö", 179);
    freq.put("ah ", 85);
    freq.put("pp ", 90);
    freq.put("án ", 769);
    freq.put("ökn", 8);
    freq.put("ósá", 25);
    freq.put("ura", 55);
    freq.put("Vol", 18);
    freq.put("gi ", 209);
    freq.put("nH", 22);
    freq.put("nI", 11);
    freq.put("ppá", 9);
    freq.put("nK", 13);
    freq.put("nL", 10);
    freq.put("nM", 8);
    freq.put("nN", 19);
    freq.put("nO", 10);
    freq.put("nA", 18);
    freq.put("nB", 10);
    freq.put("nC", 11);
    freq.put("nD", 20);
    freq.put("nE", 10);
    freq.put("nF", 12);
    freq.put("nG", 14);
    freq.put("nY", 8);
    freq.put("nZ", 9);
    freq.put("nny", 499);
    freq.put("nP", 16);
    freq.put("nR", 13);
    freq.put("nS", 17);
    freq.put("nT", 16);
    freq.put("nU", 13);
    freq.put("nV", 14);
    freq.put("nW", 9);
    freq.put("nh", 101);
    freq.put("ni", 2863);
    freq.put("nj", 130);
    freq.put("nk", 1826);
    freq.put("nl", 275);
    freq.put("nm", 64);
    freq.put("nn", 1850);
    freq.put("no", 755);
    freq.put("tit", 68);
    freq.put("na", 3816);
    freq.put("nb", 153);
    freq.put("nc", 970);
    freq.put("nd", 2683);
    freq.put("ne", 5994);
    freq.put("nf", 163);
    freq.put("ng", 1186);
    freq.put("nx", 18);
    freq.put("ny", 3224);
    freq.put("nz", 148);
    freq.put("tio", 97);
    freq.put("tii", 15);
    freq.put("giá", 16);
    freq.put("ES ", 16);
    freq.put("np", 50);
    freq.put("nq", 13);
    freq.put("nr", 83);
    freq.put("ns", 332);
    freq.put("nt", 2717);
    freq.put("nu", 249);

    init3();
  }
  private static void init3() {
    
    freq.put("nv", 77);
    freq.put("nw", 11);
    freq.put("ick", 40);
    freq.put("cor", 19);
    freq.put("ici", 124);
    freq.put("óss", 10);
    freq.put("nn ", 56);
    freq.put("óso", 13);
    freq.put("ich", 37);
    freq.put("ósa", 8);
    freq.put("n ", 10016);
    freq.put("mme", 76);
    freq.put("icc", 71);
    freq.put("ti ", 510);
    freq.put("ica", 75);
    freq.put("roh", 64);
    freq.put("roi", 32);
    freq.put("roj", 15);
    freq.put("elá", 26);
    freq.put("rol", 143);
    freq.put("rom", 318);
    freq.put("ron", 185);
    freq.put("roo", 20);
    freq.put("lls", 17);
    freq.put("rob", 88);
    freq.put("roc", 39);
    freq.put("rod", 91);
    freq.put("rof", 40);
    freq.put("rog", 86);
    freq.put("llk", 8);
    freq.put("llj", 18);
    freq.put("roz", 90);
    freq.put("llh", 9);
    freq.put("llo", 163);
    freq.put("ice", 54);
    freq.put("llm", 9);
    freq.put("rop", 12);
    freq.put("llb", 13);
    freq.put("ror", 157);
    freq.put("ros", 406);
    freq.put("rot", 50);
    freq.put("rou", 14);
    freq.put("rov", 42);
    freq.put("row", 11);
    freq.put("Pp", 8);
    freq.put("icz", 11);
    freq.put("Dal", 16);
    freq.put("Dan", 35);
    freq.put("Dav", 11);
    freq.put("Dar", 15);
    freq.put("Day", 9);
    freq.put("iú ", 33);
    freq.put("elü", 76);
    freq.put("kle", 10);
    freq.put("ro ", 69);
    freq.put("dez", 150);
    freq.put("Cil", 9);
    freq.put("ics", 248);
    freq.put("Cit", 13);
    freq.put("ll ", 514);
    freq.put(" dj", 10);
    freq.put("elö", 31);
    freq.put("Hd", 8);
    freq.put("ict", 18);
    freq.put("lló", 37);
    freq.put("Res", 8);
    freq.put("plu", 26);
    freq.put("Ret", 10);
    freq.put("kli", 62);
    freq.put("Rek", 24);
    freq.put("llé", 51);
    freq.put("Ren", 31);
    freq.put("eül", 10);
    freq.put("Rem", 43);
    freq.put("Reb", 9);
    freq.put("Rec", 8);
    freq.put("llá", 131);
    freq.put("Rea", 33);
    freq.put("Reg", 30);
    freq.put("Red", 15);
    freq.put(" üv", 20);
    freq.put(" üt", 28);
    freq.put("jéb", 8);
    freq.put(" ür", 8);
    freq.put("jén", 27);
    freq.put(" üz", 56);
    freq.put(" üg", 50);
    freq.put("jét", 48);
    freq.put("jér", 14);
    freq.put(" ün", 31);
    freq.put(" ül", 39);
    freq.put("jéz", 11);
    freq.put("dem", 103);
    freq.put("ök ", 239);
    freq.put("Re ", 12);
    freq.put("yün", 32);
    freq.put("ulv", 17);
    freq.put("Mié", 41);
    freq.put("plo", 16);
    freq.put("ngt", 10);
    freq.put("msz", 55);
    freq.put("llő", 10);
    freq.put("yüt", 43);
    freq.put("mso", 22);
    freq.put("Evi", 13);
    freq.put("Eve", 18);
    freq.put("yja", 17);
    freq.put("ulj", 35);
    freq.put("yju", 11);
    freq.put("ms ", 17);
    freq.put(" on", 166);
    freq.put("Mih", 10);
    freq.put("Mik", 35);
    freq.put(" om", 33);
    freq.put("lku", 8);
    freq.put("Mil", 52);
    freq.put(" oh", 20);
    freq.put("Min", 135);
    freq.put(" of", 73);
    freq.put("obb", 380);
    freq.put("Mic", 14);
    freq.put("Mie", 10);
    freq.put("kye", 14);
    freq.put(" ov", 10);
    freq.put("iúk", 35);
    freq.put("Mis", 39);
    freq.put("Mir", 21);
    freq.put(" or", 147);
    freq.put("Mit", 42);
    freq.put(" op", 35);
    freq.put("Miv", 8);
    freq.put(" oO", 11);
    freq.put("mén", 203);
    freq.put("rú ", 24);
    freq.put("dé ", 9);
    freq.put("Hír", 15);
    freq.put("msá", 8);
    freq.put("Mi ", 60);
    freq.put("ky ", 43);
    freq.put(" o ", 146);
    freq.put("Tán", 9);
    freq.put("dél", 124);
    freq.put("yjá", 24);
    freq.put("dén", 50);
    freq.put("dék", 79);
    freq.put("dég", 29);
    freq.put("obs", 10);
    freq.put("déz", 14);
    freq.put("dés", 178);
    freq.put("sák", 31);
    freq.put("sán", 48);
    freq.put("sál", 15);
    freq.put("ryb", 8);
    freq.put("ság", 331);
    freq.put("aha", 117);
    freq.put("sás", 24);
    freq.put("sár", 129);
    freq.put("sáv", 22);
    freq.put("sát", 47);
    freq.put("vta", 20);
    freq.put("gta", 84);
    freq.put("vte", 9);
    freq.put("gte", 62);
    freq.put("égű", 15);
    freq.put("TP ", 9);
    freq.put("vti", 8);
    freq.put("gti", 9);
    freq.put("ahe", 15);
    freq.put("ejá", 51);
    freq.put("gto", 13);
    freq.put("gtu", 22);
    freq.put("ejö", 30);
    freq.put("ahh", 67);
    freq.put("ejó", 10);
    freq.put("Pf", 9);
    freq.put("hős", 12);
    freq.put("qp", 15);
    freq.put("aho", 128);
    freq.put(" we", 41);
    freq.put("nná", 26);
    freq.put("övi", 36);
    freq.put("öve", 264);
    freq.put("ppl", 27);
    freq.put("gt ", 8);
    freq.put(" wa", 37);
    freq.put("áns", 19);
    freq.put("ysá", 14);
    freq.put("EN ", 47);
    freq.put("gtá", 9);
    freq.put("elő", 471);
    freq.put("ejj", 13);
    freq.put("gté", 8);
    freq.put(" wt", 10);
    freq.put("gtö", 29);
    freq.put("ejt", 104);
    freq.put("eju", 8);
    freq.put(" wp", 11);
    freq.put("giv", 10);
    freq.put("övö", 29);
    freq.put("àn", 10);
    freq.put("àl", 13);
    freq.put("ecr", 10);
    freq.put("övé", 27);
    freq.put("gir", 39);
    freq.put("yus", 32);
    freq.put("yur", 11);
    freq.put("ej ", 24);
    freq.put("yuk", 26);
    freq.put("yum", 16);
    freq.put("yul", 41);
    freq.put("yun", 70);
    freq.put("yud", 14);
    freq.put("yug", 80);
    freq.put("hu ", 144);
    freq.put("aná", 119);
    freq.put("aní", 24);
    freq.put("pré", 16);
    freq.put("ané", 23);
    freq.put("álá", 40);
    freq.put("má ", 10);
    freq.put("pró", 107);
    freq.put("áló", 66);
    freq.put("anú", 14);
    freq.put("iam", 60);
    freq.put("égv", 16);
    freq.put("iao", 10);
    freq.put("ian", 90);
    freq.put("égs", 26);
    freq.put("égr", 79);
    freq.put("iak", 40);
    freq.put("iad", 35);
    freq.put("iaf", 15);
    freq.put("iaa", 27);
    freq.put("égz", 27);
    freq.put("égy", 66);
    freq.put("iab", 21);
    freq.put("égg", 31);
    freq.put("ége", 348);
    freq.put("égb", 22);
    freq.put("égn", 13);
    freq.put("égl", 14);
    freq.put("égk", 17);
    freq.put("égi", 185);
    freq.put("iar", 10);
    freq.put("más", 312);
    freq.put("hug", 11);
    freq.put("mát", 33);
    freq.put("hul", 31);
    freq.put("hum", 19);
    freq.put("hun", 54);
    freq.put("mác", 15);
    freq.put("máb", 34);
    freq.put("mád", 100);
    freq.put("hur", 14);
    freq.put("SE ", 15);
    freq.put("mák", 15);
    freq.put("máj", 54);
    freq.put("mám", 10);
    freq.put("mál", 47);
    freq.put("huz", 12);
    freq.put("mán", 156);
    freq.put(" Lá", 65);
    freq.put("ia ", 404);
    freq.put(" Lé", 12);
    freq.put("r", 29491);
    freq.put("ég ", 925);
    freq.put("and", 304);
    freq.put("ane", 119);
    freq.put("áll", 435);
    freq.put("ang", 310);
    freq.put("álj", 87);
    freq.put("ana", 226);
    freq.put("anb", 10);
    freq.put("áli", 130);
    freq.put("anl", 9);
    freq.put("ann", 503);
    freq.put("ano", 85);
    freq.put("pri", 88);
    freq.put("ani", 286);
    freq.put("anj", 14);
    freq.put("ank", 119);
    freq.put("ant", 176);
    freq.put("anu", 163);
    freq.put("lót", 37);
    freq.put("lór", 15);
    freq.put("lós", 51);
    freq.put("anr", 8);
    freq.put("ály", 168);
    freq.put("álv", 12);
    freq.put("ált", 462);
    freq.put("álu", 38);
    freq.put("álr", 8);
    freq.put("any", 353);
    freq.put("anz", 12);
    freq.put(" L ", 44);
    freq.put(" áh", 14);
    freq.put("égü", 40);
    freq.put(" ál", 400);
    freq.put("GO ", 15);
    freq.put(" án", 28);
    freq.put(" áp", 31);
    freq.put(" ná", 70);
    freq.put(" ár", 103);
    freq.put(" ás", 9);
    freq.put(" át", 120);
    freq.put("égá", 9);
    freq.put("gka", 26);
    freq.put("gke", 65);
    freq.put("égé", 103);
    freq.put("an ", 2832);
    freq.put("ló ", 208);
    freq.put("ál ", 326);
    freq.put("máá", 12);
    freq.put("uck", 56);
    freq.put(" á ", 8);
    freq.put(" Le", 211);
    freq.put(" La", 104);
    freq.put(" Lo", 121);
    freq.put(" Li", 140);
    freq.put(" Lu", 34);
    freq.put(" Ls", 13);
    freq.put("tke", 87);
    freq.put("eMa", 9);
    freq.put("tka", 38);
    freq.put("tko", 96);
    freq.put("lnö", 34);
    freq.put("nla", 56);
    freq.put("rmá", 105);
    freq.put("nle", 78);
    freq.put("nli", 43);
    freq.put("rmé", 53);
    freq.put("dy ", 48);
    freq.put("ss ", 181);
    freq.put("nlo", 24);
    freq.put("sou", 8);
    freq.put("tne", 117);
    freq.put("ssy", 11);
    freq.put("eM ", 15);
    freq.put("ssz", 817);
    freq.put("ssu", 16);
    freq.put("H", 1834);
    freq.put("sss", 19);
    freq.put("sso", 18);
    freq.put("ssi", 44);
    freq.put("sse", 91);
    freq.put("ssa", 173);
    freq.put("dyR", 8);
    freq.put("nló", 23);
    freq.put("tká", 22);
    freq.put("tké", 8);
    freq.put("tkö", 30);
    freq.put("lno", 19);
    freq.put("rma", 83);
    freq.put("lni", 417);
    freq.put("tkó", 9);
    freq.put("rme", 77);
    freq.put("lne", 91);
    freq.put("eb ", 20);
    freq.put("rmi", 70);
    freq.put("nlí", 12);
    freq.put("éjj", 22);
    freq.put("yőr", 18);
    freq.put("föl", 87);
    freq.put("föc", 10);
    freq.put("írn", 84);
    freq.put("íro", 123);
    freq.put("írh", 10);
    freq.put("Én ", 103);
    freq.put("tbó", 15);
    freq.put("ssü", 16);
    freq.put("uns", 11);
    freq.put("moc", 10);
    freq.put("ssí", 30);
    freq.put("rm ", 9);
    freq.put("ssé", 107);
    freq.put("ssá", 59);
    freq.put("ee ", 168);
    freq.put("nno", 28);
    freq.put("poz", 25);
    freq.put("pot", 144);
    freq.put("por", 161);
    freq.put("pos", 92);
    freq.put("pop", 16);
    freq.put("pon", 234);
    freq.put("pol", 82);
    freq.put("ahá", 9);
    freq.put("pok", 84);
    freq.put("poh", 13);
    freq.put("pof", 17);
    freq.put("pog", 11);
    freq.put("pod", 33);
    freq.put("áná", 21);
    freq.put("nni", 315);
    freq.put("űjt", 19);
    freq.put("But", 10);
    freq.put("Bun", 13);
    freq.put("Bul", 11);
    freq.put("nne", 473);
    freq.put("Bud", 76);
    freq.put(" e ", 143);
    freq.put("áné", 12);
    freq.put("nna", 314);
    freq.put("po ", 13);
    freq.put("yhá", 16);
    freq.put("oks", 49);
    freq.put("poé", 16);
    freq.put("oku", 9);
    freq.put("okt", 87);
    freq.put("lnő", 11);
    freq.put("ós ", 118);
    freq.put("I ", 335);
    freq.put("sús", 23);
    freq.put("kám", 20);
    freq.put("jók", 23);
    freq.put("oka", 299);
    freq.put("Iz", 25);
    freq.put("yho", 42);
    freq.put("Iq", 9);
    freq.put("Ip", 15);
    freq.put("Is", 77);
    freq.put("Ir", 43);
    freq.put("Iu", 9);
    freq.put("It", 89);
    freq.put("Iv", 20);
    freq.put("Ih", 8);
    freq.put("Ik", 12);
    freq.put("Ij", 11);
    freq.put("Im", 45);
    freq.put("Il", 56);
    freq.put("In", 111);
    freq.put("Ia", 21);
    freq.put("oke", 41);
    freq.put("Ic", 24);
    freq.put("Ib", 22);
    freq.put("Ie", 12);
    freq.put("Id", 41);
    freq.put("Ig", 54);
    freq.put("If", 8);
    freq.put(" qq", 9);
    freq.put("tip", 31);
    freq.put("oki", 65);
    freq.put("okh", 12);
    freq.put("ÉG ", 12);
    freq.put("tis", 80);
    freq.put("okk", 103);
    freq.put("til", 79);
    freq.put("gvé", 12);
    freq.put("ézd", 36);
    freq.put("éze", 124);
    freq.put("tim", 58);
    freq.put("ézh", 10);
    freq.put("ézi", 28);
    freq.put("gvá", 27);
    freq.put("ézm", 9);
    freq.put("ézn", 116);
    freq.put("okl", 11);
    freq.put("ézt", 80);
    freq.put("ézu", 16);
    freq.put("ézv", 12);
    freq.put("ötö", 31);
    freq.put("ézz", 48);
    freq.put("okn", 60);
    freq.put("tik", 170);
    freq.put(" q ", 37);
    freq.put("tie", 12);
    freq.put("tif", 9);
    freq.put("VV ", 8);
    freq.put("éz ", 61);
    freq.put("tig", 28);
    freq.put("Pil", 8);
    freq.put("oé", 18);
    freq.put("Pic", 9);
    freq.put("tia", 18);
    freq.put("tib", 21);
    freq.put("pzé", 9);
    freq.put("tic", 31);
    freq.put("Pit", 12);
    freq.put("Kul", 12);
    freq.put("gvi", 19);
    freq.put("öte", 30);
    freq.put("gvo", 13);
    freq.put("ézé", 17);
    freq.put("gva", 49);
    freq.put("ötl", 29);
    freq.put("gve", 43);
    freq.put("ött", 344);
    freq.put("őző", 37);
    freq.put("zír", 9);
    freq.put("zív", 97);
    freq.put("zít", 87);
    freq.put("oO", 20);
    freq.put("oN", 9);
    freq.put("oM", 17);
    freq.put("oL", 13);
    freq.put("oK", 9);
    freq.put("oJ", 10);
    freq.put("oI", 13);
    freq.put("oH", 9);
    freq.put("oG", 15);
    freq.put("oF", 13);
    freq.put("oE", 14);
    freq.put("oD", 17);
    freq.put("oC", 23);
    freq.put("oB", 11);
    freq.put("oA", 17);
    freq.put("oZ", 10);
    freq.put("oY", 9);
    freq.put("oX", 13);
    freq.put("oV", 14);
    freq.put("oU", 11);
    freq.put("oT", 16);
    freq.put("oS", 18);
    freq.put("oR", 11);
    freq.put("oQ", 9);
    freq.put("oP", 15);
    freq.put("oo", 579);
    freq.put("on", 3998);
    freq.put("om", 2543);
    freq.put("ol", 4299);
    freq.put("ok", 3473);
    freq.put("oj", 60);
    freq.put("oi", 95);
    freq.put("oh", 220);
    freq.put("og", 2887);
    freq.put("of", 267);
    freq.put("oe", 55);
    freq.put("od", 939);
    freq.put("oc", 296);
    freq.put("ob", 722);
    freq.put("oa", 65);
    freq.put("oz", 1144);
    freq.put("oy", 54);
    freq.put("ox", 62);
    freq.put("ow", 188);
    freq.put("ov", 420);
    freq.put("ou", 564);
    freq.put("ot", 1918);
    freq.put("os", 2646);
    freq.put("or", 3539);
    freq.put("oq", 12);
    freq.put("op", 323);
    freq.put("LE ", 12);
    freq.put("rvá", 60);
    freq.put("rvé", 37);
    freq.put("éző", 11);
    freq.put("MG ", 15);
    freq.put("Jul", 24);
    freq.put("pár", 151);
    freq.put("ehu", 23);
    freq.put("pát", 12);
    freq.put(" éé", 13);
    freq.put("EL ", 20);
    freq.put("mar", 345);
    freq.put("páb", 9);
    freq.put("ehe", 542);
    freq.put("igá", 16);
    freq.put("eha", 30);
    freq.put("eho", 74);
    freq.put("pál", 57);
    freq.put("pám", 9);
    freq.put("igé", 20);
    freq.put("ehi", 9);
    freq.put("juk", 189);
    freq.put("juh", 16);
    freq.put("jun", 32);
    freq.put("nül", 36);
    freq.put("jul", 22);
    freq.put("jus", 80);
    freq.put("jut", 99);
    freq.put("yad", 14);
    freq.put("OD ", 8);
    freq.put("mét", 71);
    freq.put("eh ", 20);
    freq.put("véb", 12);
    freq.put("rva", 126);
    freq.put("cba", 16);
    freq.put("vég", 345);
    freq.put("rve", 103);
    freq.put("vék", 10);
    freq.put("rvi", 9);
    freq.put("rvo", 32);
    freq.put("vél", 60);
    freq.put("vér", 50);
    freq.put("vés", 62);
    freq.put("vév", 12);
    freq.put("rúg", 21);
    freq.put("vét", 105);
    freq.put("véz", 8);
    freq.put("igu", 13);
    freq.put("igr", 10);
    freq.put("igy", 134);
    freq.put("igg", 10);
    freq.put("ige", 211);
    freq.put("iga", 222);
    freq.put("ehá", 17);
    freq.put("igo", 21);
    freq.put("ign", 32);
    freq.put("igi", 57);
    freq.put("igh", 48);
    freq.put("vé ", 15);
    freq.put("yne", 43);
    freq.put("ig ", 671);
    freq.put("aln", 34);
    freq.put("alo", 256);
    freq.put("all", 381);
    freq.put("alm", 233);
    freq.put("alj", 29);
    freq.put("alk", 141);
    freq.put("árv", 22);
    freq.put("ali", 167);
    freq.put("alf", 13);
    freq.put("alg", 14);
    freq.put("ald", 16);
    freq.put("ale", 80);
    freq.put("alb", 81);
    freq.put("lly", 38);
    freq.put("pta", 61);
    freq.put("ala", 924);
    freq.put("ára", 273);
    freq.put("árb", 21);
    freq.put("árc", 42);
    freq.put("árd", 45);
    freq.put("árf", 29);
    freq.put("árg", 41);
    freq.put("árh", 50);
    freq.put("ári", 93);
    freq.put("árj", 43);
    freq.put("árk", 45);
    freq.put("árl", 21);
    freq.put("árm", 85);
    freq.put("alp", 16);
    freq.put("áro", 302);
    freq.put("rkő", 13);
    freq.put(" N ", 43);
    freq.put("GI ", 9);
    freq.put("alS", 11);
    freq.put("öbb", 202);
    freq.put("far", 30);
    freq.put("fas", 77);
    freq.put("al ", 1083);
    freq.put("pt ", 9);
    freq.put("ár ", 1282);
    freq.put("fak", 33);
    freq.put("fai", 9);
    freq.put("fan", 70);
    freq.put("llu", 25);
    freq.put("fal", 58);
    freq.put("fam", 11);
    freq.put("fac", 96);
    freq.put("llt", 49);
    freq.put("fag", 40);
    freq.put(" Ni", 137);
    freq.put("vtá", 12);
    freq.put(" No", 81);
    freq.put(" Na", 249);
    freq.put(" Ne", 407);
    freq.put("lli", 128);
    freq.put(" Ny", 71);
    freq.put("lln", 47);
    freq.put("teh", 48);
    freq.put("tei", 26);
    freq.put("tej", 27);
    freq.put("áró", 76);
    freq.put("tel", 678);
    freq.put("tem", 1227);
    freq.put("ten", 497);
    freq.put("alé", 35);
    freq.put("nbs", 11);
    freq.put("tea", 15);
    freq.put("teb", 15);
    freq.put("tec", 24);
    freq.put("ted", 194);
    freq.put("tee", 32);
    freq.put("ptá", 16);
    freq.put("alá", 548);
    freq.put("árá", 40);
    freq.put("tez", 39);
    freq.put("tep", 16);
    freq.put("nba", 44);
    freq.put("tes", 369);
    freq.put("tet", 757);
    freq.put("aló", 124);
    freq.put("nbe", 42);
    freq.put("sug", 11);
    freq.put("MGe", 21);
    freq.put("sun", 49);
    freq.put("sum", 8);
    freq.put("sul", 87);
    freq.put("suk", 28);
    freq.put("suu", 24);
    freq.put("sut", 15);
    freq.put("sur", 11);
    freq.put("sup", 12);
    freq.put("szí", 288);
    freq.put("suz", 18);
    freq.put("pán", 65);
    freq.put("te ", 779);
    freq.put("lhő", 10);
    freq.put("nb ", 9);
    freq.put(" Né", 81);
    freq.put("mmm", 14);
    freq.put("su ", 17);
    freq.put(" Ná", 13);
    freq.put("mmo", 12);
    freq.put("ya ", 146);
    freq.put("yH", 29);
    freq.put("rku", 9);
    freq.put("rks", 12);
    freq.put("Tor", 19);
    freq.put("Top", 10);
    freq.put("jóó", 27);
    freq.put("Tot", 14);
    freq.put("Tou", 12);
    freq.put("rke", 111);
    freq.put("rka", 67);
    freq.put("Tom", 33);
    freq.put("rko", 52);
    freq.put("rki", 27);
    freq.put("yve", 61);
    freq.put("sbo", 11);
    freq.put("In ", 11);
    freq.put("Éle", 13);
    freq.put("rk ", 39);
    freq.put(" Nő", 16);
    freq.put("á", 16698);
    freq.put("mne", 36);
    freq.put("lhá", 9);
    freq.put("Int", 21);
    freq.put("lhí", 11);
    freq.put("Ins", 9);
    freq.put("v", 12778);
    freq.put("Ind", 20);
    freq.put("Inf", 9);
    freq.put("Ing", 8);
    freq.put("rkö", 8);
    freq.put("úli", 29);
    freq.put("rká", 26);
    freq.put("rké", 27);
    freq.put("vmi", 44);
    freq.put("lam", 383);
    freq.put("Gla", 13);
    freq.put("Akk", 37);
    freq.put("Aki", 31);
    freq.put("lhe", 57);
    freq.put("lha", 114);
    freq.put("lho", 20);
    freq.put("úly", 15);
    freq.put("lhi", 19);
    freq.put("lhu", 9);
    freq.put("úlz", 10);
    freq.put("oy ", 20);
    freq.put(" sú", 11);
    freq.put(" sü", 37);
    freq.put(" só", 11);
    freq.put(" sö", 41);
    freq.put(" sé", 31);
    freq.put(" sí", 62);
    freq.put("öző", 11);
    freq.put(" sá", 22);
    freq.put("izá", 31);
    freq.put("izé", 19);
    freq.put("yn ", 35);
    freq.put("izó", 8);
    freq.put("Err", 11);
    freq.put("gub", 11);
    freq.put("L", 1303);
    freq.put("Eri", 16);
    freq.put("Rad", 9);
    freq.put("yni", 17);
    freq.put(" éd", 31);
    freq.put("yna", 20);
    freq.put("Rai", 13);
    freq.put("guk", 20);
    freq.put("man", 116);
    freq.put(" ég", 27);
    freq.put(" sz", 3268);
    freq.put(" sy", 11);
    freq.put("Mus", 21);
    freq.put(" sr", 33);
    freq.put(" ss", 11);
    freq.put(" sp", 101);
    freq.put(" sq", 8);
    freq.put(" sv", 14);
    freq.put(" sw", 12);
    freq.put(" st", 149);
    freq.put("gun", 30);
    freq.put(" sj", 8);
    freq.put(" sk", 17);
    freq.put(" sh", 48);
    freq.put("Muf", 8);
    freq.put(" sn", 12);
    freq.put(" so", 464);
    freq.put(" sl", 14);
    freq.put(" sm", 29);
    freq.put(" sc", 23);
    freq.put("Hár", 8);
    freq.put(" sa", 199);
    freq.put("Hát", 69);
    freq.put(" se", 742);
    freq.put("ók", 299);
    freq.put("ize", 80);
    freq.put("ój", 120);
    freq.put("izi", 44);
    freq.put("izm", 14);
    freq.put("izn", 28);
    freq.put("izo", 61);
    freq.put("izs", 65);
    freq.put("izt", 145);
    freq.put("izu", 12);
    freq.put("izz", 34);
    freq.put("ekü", 50);
    freq.put(" em", 305);
    freq.put("SZ ", 32);
    freq.put("ól", 1088);
    freq.put("kok", 61);
    freq.put("sét", 79);
    freq.put("yX", 14);
    freq.put(" eh", 27);
    freq.put(" s ", 153);
    freq.put("iz ", 26);
    freq.put(" ej", 13);
    freq.put("kon", 278);
    freq.put("X ", 176);
    freq.put("Úgy", 36);
    freq.put("upa", 13);
    freq.put("kod", 106);
    freq.put("özi", 27);
    freq.put("özn", 19);
    freq.put("özl", 27);
    freq.put("özb", 65);
    freq.put("özg", 8);
    freq.put("öze", 88);
    freq.put("ata", 302);
    freq.put("efé", 8);
    freq.put("TL ", 14);
    freq.put("özp", 12);
    freq.put("özv", 17);
    freq.put("gpr", 28);
    freq.put("özt", 25);
    freq.put("jsá", 18);
    freq.put("kop", 31);
    freq.put(" ev", 58);
    freq.put("Erő", 12);
    freq.put("öz ", 14);
    freq.put("ekö", 21);
    freq.put("jem", 43);
    freq.put("llí", 77);
    freq.put("atl", 104);
    freq.put("sős", 13);
    freq.put("ön ", 192);
    freq.put("rok", 256);
    freq.put("özé", 67);
    freq.put("efu", 14);
    freq.put("efi", 26);
    freq.put("özü", 27);
    freq.put("efa", 20);
    freq.put("özö", 124);
    freq.put("bőg", 8);
    freq.put("Bár", 21);
    freq.put("őké", 20);
    freq.put("ébk", 26);
    freq.put("ből", 159);
    freq.put("bőr", 19);
    freq.put("jsz", 55);
    freq.put("Zen", 11);
    freq.put("ef ", 15);
    freq.put("rte", 381);
    freq.put("yR", 17);
    freq.put("rta", 276);
    freq.put("rtb", 24);
    freq.put("rtm", 8);
    freq.put("rtl", 16);
    freq.put("arú", 8);
    freq.put("rtn", 16);
    freq.put("rti", 72);
    freq.put("rth", 32);
    freq.put("rtj", 20);
    freq.put("hi ", 30);
    freq.put("ará", 207);
    freq.put("rtp", 9);
    freq.put("rts", 27);
    freq.put("rtr", 19);
    freq.put("rty", 91);
    freq.put("arí", 9);
    freq.put("Jy", 15);
    freq.put("Jt", 9);
    freq.put("Ju", 91);
    freq.put("Jv", 8);
    freq.put("ier", 51);
    freq.put("Jp", 10);
    freq.put("iet", 13);
    freq.put("iew", 13);
    freq.put("Js", 17);
    freq.put("Jm", 10);
    freq.put("iek", 24);
    freq.put("Jo", 82);
    freq.put("iem", 18);
    freq.put("iel", 68);
    freq.put("Jj", 12);
    freq.put("Jk", 14);
    freq.put("Je", 72);
    freq.put("Jf", 20);
    freq.put("Jg", 8);
    freq.put("Ja", 144);
    freq.put("Jb", 12);
    freq.put("Jc", 8);
    freq.put("hip", 31);
    freq.put("hir", 88);
    freq.put("his", 149);
    freq.put("hit", 89);
    freq.put("rt ", 1389);
    freq.put("hiv", 50);
    freq.put("aad", 23);
    freq.put("mít", 36);
    freq.put("ká", 612);
    freq.put("dmi", 8);
    freq.put("hia", 11);
    freq.put("hib", 47);
    freq.put("Xi", 11);
    freq.put("hid", 37);
    freq.put("hie", 11);
    freq.put("hig", 9);
    freq.put("hih", 16);
    freq.put("hii", 9);
    freq.put("míg", 30);
    freq.put("hil", 19);
    freq.put("hin", 64);
    freq.put("sőt", 8);
    freq.put("ágg", 12);
    freq.put(" Pá", 26);
    freq.put("ko ", 34);
    freq.put("ie ", 99);
    freq.put(" Pé", 36);
    freq.put("J ", 168);
    freq.put("arp", 13);
    freq.put("arr", 171);
    freq.put("ars", 82);
    freq.put("art", 420);
    freq.put("aru", 42);
    freq.put("arv", 15);
    freq.put("ápr", 30);
    freq.put("ary", 76);
    freq.put("rté", 142);
    freq.put("aah", 17);
    freq.put("ara", 479);
    freq.put("arb", 65);
    freq.put("arc", 138);
    freq.put("ard", 86);
    freq.put("are", 45);
    freq.put("arf", 13);
    freq.put("arg", 58);
    freq.put("arh", 25);
    freq.put("ari", 121);
    freq.put("arj", 24);
    freq.put("ark", 112);
    freq.put("arl", 35);
    freq.put("arm", 54);
    freq.put("arn", 52);
    freq.put("aro", 439);
    freq.put("Jú", 17);
    freq.put("Jö", 31);
    freq.put("Jó", 109);
    freq.put(" P ", 81);
    freq.put("Jé", 14);
    freq.put("Já", 27);
    freq.put("kív", 107);
    freq.put("uuu", 84);
    freq.put("uus", 13);
    freq.put("ar ", 471);
    freq.put("hiá", 42);
    freq.put("uuj", 8);
    freq.put("uud", 9);
    freq.put(" Pr", 62);
    freq.put("c", 12950);
    freq.put("Öss", 13);
    freq.put(" Pu", 21);
    freq.put(" Pz", 8);
    freq.put(" ős", 37);
    freq.put(" Pa", 150);
    freq.put(" Pe", 91);
    freq.put(" Pi", 75);
    freq.put("kü", 365);
    freq.put(" Po", 91);
    freq.put(" Pl", 27);
    freq.put("pR", 13);
    freq.put("pS", 11);
    freq.put("pQ", 12);
    freq.put("pW", 9);
    freq.put("pT", 13);
    freq.put("pU", 12);
    freq.put("pZ", 10);
    freq.put("pX", 12);
    freq.put("pY", 10);
    freq.put(" xf", 18);
    freq.put("pC", 15);
    freq.put("pA", 8);
    freq.put("pF", 9);
    freq.put("pG", 12);
    freq.put("pD", 10);
    freq.put("pE", 9);
    freq.put("pJ", 14);
    freq.put("pK", 9);
    freq.put("pI", 10);
    freq.put("pN", 9);
    freq.put("pO", 10);
    freq.put("riá", 39);
    freq.put("pr", 552);
    freq.put("ps", 215);
    freq.put("pp", 332);
    freq.put("pq", 8);
    freq.put("pv", 38);
    freq.put("pw", 9);
    freq.put("pt", 253);
    freq.put("pu", 180);
    freq.put("pz", 71);
    freq.put("Kér", 25);
    freq.put("px", 9);
    freq.put("py", 36);
    freq.put("Két", 20);
    freq.put("pb", 45);
    freq.put("pc", 138);
    freq.put("pa", 704);
    freq.put("pf", 32);
    freq.put("pd", 41);
    freq.put("pe", 1233);
    freq.put("pj", 157);
    freq.put("pk", 27);
    freq.put("ph", 120);
    freq.put("pi", 573);
    freq.put("pn", 75);
    freq.put("po", 1017);
    freq.put("pl", 295);
    freq.put("pm", 20);
    freq.put("Eme", 8);
    freq.put("usd", 8);
    freq.put("tg ", 9);
    freq.put("du ", 8);
    freq.put("p ", 6070);
    freq.put("ói ", 41);
    freq.put("riz", 39);
    freq.put("rix", 8);
    freq.put("Tit", 10);
    freq.put("rit", 101);
    freq.put("riu", 16);
    freq.put("ris", 253);
    freq.put("rip", 31);
    freq.put("Tis", 19);
    freq.put("rin", 396);
    freq.put("Tim", 19);
    freq.put("ril", 56);
    freq.put("rim", 31);
    freq.put("rik", 104);
    freq.put("rii", 34);
    freq.put("rig", 48);
    freq.put("rid", 31);
    freq.put("rie", 60);
    freq.put("rib", 22);
    freq.put("ric", 64);
    freq.put("Tib", 8);
    freq.put("ria", 106);
    freq.put("pó", 60);
    freq.put("pö", 32);
    freq.put("Ns", 11);
    freq.put("pü", 60);
    freq.put("fúj", 13);
    freq.put("pá", 339);
    freq.put("pé", 180);
    freq.put("pí", 63);
    freq.put("Ild", 8);
    freq.put("Cou", 10);
    freq.put("Ti ", 17);
    freq.put("Col", 14);
    freq.put("ri ", 220);
    freq.put("Con", 14);
    freq.put("CoD", 8);
    freq.put("őny", 19);
    freq.put("éé ", 8);
    freq.put("lj ", 88);
    freq.put("üzi", 9);
    freq.put("zzü", 25);
    freq.put("üzl", 17);
    freq.put("éés", 15);
    freq.put("éér", 9);
    freq.put("sőd", 10);
    freq.put("üze", 41);
    freq.put("üzd", 8);
    freq.put("zzé", 16);
    freq.put("zzá", 112);
    freq.put("ljo", 21);
    freq.put("lja", 118);
    freq.put("lje", 144);
    freq.put("ndá", 25);
    freq.put("lju", 29);
    freq.put("bör", 11);
    freq.put(" x ", 165);
    freq.put("böl", 11);
    freq.put("vna", 13);
    freq.put("iár", 32);
    freq.put("sk ", 12);
    freq.put("gáz", 39);
    freq.put("zzu", 18);
    freq.put("gát", 58);
    freq.put("gás", 59);
    freq.put("gár", 41);
    freq.put("zzo", 10);
    freq.put("gán", 47);
    freq.put("gám", 9);
    freq.put("gál", 101);
    freq.put("zze", 110);
    freq.put("ééé", 59);
    freq.put("gáb", 28);
    freq.put("zza", 103);
    freq.put("ylv", 11);
    freq.put("küd", 13);
    freq.put("Rol", 13);
    freq.put("Rom", 20);
    freq.put("Ron", 20);
    freq.put("ljá", 70);
    freq.put("Rob", 12);
    freq.put("Roc", 11);
    freq.put("kQ", 14);
    freq.put("yle", 169);
    freq.put("ljü", 28);
    freq.put("yla", 13);
    freq.put("ylo", 17);
    freq.put("yll", 8);
    freq.put("Ros", 22);
    freq.put("msu", 19);
    freq.put("ljö", 19);
    freq.put("wn ", 17);
    freq.put("Ism", 11);
    freq.put(" ut", 375);
    freq.put(" uu", 9);
    freq.put(" up", 19);
    freq.put(" ur", 21);
    freq.put(" us", 20);
    freq.put(" ul", 14);
    freq.put(" un", 100);
    freq.put(" uh", 10);
    freq.put(" uj", 34);
    freq.put(" ud", 8);
    freq.put(" uf", 9);
    freq.put(" ug", 160);
    freq.put("gró", 60);
    freq.put("cii", 38);
    freq.put("ixe", 13);
    freq.put("grá", 25);
    freq.put("zdu", 15);
    freq.put("Rád", 11);
    freq.put(" u ", 36);
    freq.put(" Ky", 10);
    freq.put("ix ", 34);
    freq.put("uro", 49);
    freq.put("z", 25515);
    freq.put("NK ", 12);
    freq.put("zét", 48);
    freq.put("zér", 273);
    freq.put("zés", 225);
    freq.put("zép", 205);
    freq.put("zéd", 30);
    freq.put("gre", 124);
    freq.put("zéb", 11);
    freq.put("gra", 132);
    freq.put("zén", 13);
    freq.put("gro", 32);
    freq.put("zél", 140);
    freq.put("zék", 46);
    freq.put("gri", 29);
    freq.put("cis", 8);
    freq.put("kx", 15);
    freq.put("zé ", 53);
    freq.put("nd ", 171);
    freq.put("cir", 10);
    freq.put("edb", 33);
    freq.put("eda", 18);
    freq.put("edd", 155);
    freq.put("ede", 154);
    freq.put("edj", 17);
    freq.put("edh", 9);
    freq.put("edi", 225);
    freq.put("LA ", 13);
    freq.put("edo", 21);
    freq.put("edl", 9);
    freq.put("edm", 29);
    freq.put("edr", 10);
    freq.put("edv", 288);
    freq.put("edt", 42);
    freq.put("edz", 50);
    freq.put("ugo", 47);
    freq.put("rró", 30);
    freq.put("FF ", 10);
    freq.put("ed ", 603);
    freq.put("rér", 10);
    freq.put("sar", 40);
    freq.put("P", 1317);
    freq.put("ugd", 17);
    freq.put("rél", 19);
    freq.put("iba", 153);
    freq.put("rro", 40);
    freq.put("rri", 31);
    freq.put("egl", 88);
    freq.put("rre", 151);
    freq.put("edé", 55);
    freq.put("rra", 123);
    freq.put("víz", 60);
    freq.put("rry", 87);
    freq.put("vít", 16);
    freq.put("rrr", 17);
    freq.put("edü", 42);
    freq.put("zdi", 11);
    freq.put("bda", 21);
    freq.put("ugu", 18);
    freq.put("IG ", 10);
    freq.put("ghá", 10);
    freq.put("rr ", 16);
    freq.put("lú", 21);
    freq.put("sat", 83);
    freq.put(" oo", 22);
    freq.put("apr", 61);
    freq.put("aps", 54);
    freq.put("app", 103);
    freq.put(" ol", 515);
    freq.put("apt", 108);
    freq.put("apu", 64);
    freq.put("apj", 119);
    freq.put("apk", 11);
    freq.put("aph", 31);
    freq.put("ávo", 20);
    freq.put("apn", 27);
    freq.put("apo", 339);
    freq.put("apl", 16);
    freq.put("apb", 19);
    freq.put("apc", 83);
    freq.put("apa", 93);
    freq.put("áva", 106);
    freq.put("apd", 8);
    freq.put(" ok", 172);
    freq.put("feg", 15);
    freq.put("fed", 14);
    freq.put("LL ", 27);
    freq.put("feb", 15);
    freq.put("usb", 21);
    freq.put("usa", 26);
    freq.put("fen", 88);
    freq.put("Hun", 83);
    freq.put("jün", 12);
    freq.put("fej", 179);
    freq.put("fek", 67);
    freq.put("feh", 32);
    freq.put("ush", 31);
    freq.put("Mia", 8);
    freq.put("fet", 9);
    freq.put("edő", 25);
    freq.put("fer", 39);
    freq.put(" R ", 58);
    freq.put("Hur", 8);
    freq.put("óké", 9);
    freq.put(" od", 64);
    freq.put(" ob", 10);
    freq.put("Ő", 36);
    freq.put("ap ", 589);
    freq.put(" Ru", 21);
    freq.put("Hu ", 19);
    freq.put("fe ", 9);
    freq.put("us ", 320);
    freq.put(" Ry", 9);
    freq.put("pac", 17);
    freq.put(" Re", 227);
    freq.put(" Ra", 57);
    freq.put(" Ro", 138);
    freq.put(" Ri", 52);
    freq.put("tat", 383);
    freq.put("tav", 46);
    freq.put("ndb", 35);
    freq.put("tap", 30);
    freq.put("tar", 256);
    freq.put("tas", 94);
    freq.put("yóg", 32);
    freq.put("taz", 41);
    freq.put("tad", 95);
    freq.put("tae", 9);
    freq.put("tag", 73);
    freq.put("ávé", 31);
    freq.put("tab", 35);
    freq.put("apí", 29);
    freq.put("tal", 695);
    freq.put("tam", 1007);
    freq.put("tan", 540);
    freq.put("apá", 46);
    freq.put(" ot", 208);
    freq.put("tak", 237);
    freq.put("óku", 9);
    freq.put("sir", 28);
    freq.put(" őr", 15);
    freq.put(" ou", 8);
    freq.put(" őt", 22);
    freq.put("siv", 12);
    freq.put("sit", 151);
    freq.put("siz", 11);
    freq.put(" os", 133);
    freq.put("óke", 12);
    freq.put("sib", 20);
    freq.put("sia", 9);
    freq.put("óka", 41);
    freq.put("sie", 18);
    freq.put("sid", 18);
    freq.put("sik", 233);
    freq.put("óko", 24);
    freq.put(" ők", 82);
    freq.put("sio", 32);
    freq.put("sin", 291);
    freq.put("ókk", 12);
    freq.put("sil", 41);
    freq.put("wu", 10);
    freq.put("élk", 83);
    freq.put("ta ", 673);
    freq.put("rai", 46);
    freq.put(" Ró", 14);
    freq.put("vcs", 12);
    freq.put(" ő ", 80);
    freq.put("si ", 433);
    freq.put(" Rá", 38);
    freq.put("ók ", 137);
    freq.put(" Ré", 32);
    freq.put("ws", 50);
    freq.put("kba", 108);
    freq.put("owo", 15);
    freq.put("kbe", 59);
    freq.put("own", 19);
    freq.put("jég", 8);
    freq.put("byu", 8);
    freq.put("owe", 18);
    freq.put("gh ", 19);
    freq.put("bye", 11);
    freq.put("Cas", 10);
    freq.put("Car", 23);
    freq.put("kb ", 62);
    freq.put("Cat", 12);
    freq.put("є", 9);
    freq.put("Pre", 11);
    freq.put("nfe", 26);
    freq.put("ltö", 162);
    freq.put("nfo", 64);
    freq.put("ltú", 12);
    freq.put("Pro", 35);
    freq.put("nfl", 12);
    freq.put("Pri", 9);
    freq.put("nfi", 12);
    freq.put("ltü", 22);
    freq.put("ltá", 98);
    freq.put("lté", 50);
    freq.put("by ", 33);
    freq.put("oui", 21);
    freq.put("sún", 14);
    freq.put("oun", 27);
    freq.put("súl", 14);
    freq.put("oul", 10);
    freq.put("súc", 14);
    freq.put("oud", 10);
    freq.put("őad", 36);
    freq.put("Jel", 17);
    freq.put("oux", 8);
    freq.put("ous", 35);
    freq.put("kbó", 22);
    freq.put("űkö", 49);
    freq.put("out", 79);
    freq.put("jáv", 18);
    freq.put("ját", 421);
    freq.put("jár", 189);
    freq.put("jás", 18);
    freq.put("ján", 165);
    freq.put("jál", 14);
    freq.put("cra", 15);
    freq.put("ják", 137);
    freq.put("jáb", 38);
    freq.put("ouT", 231);
    freq.put("vaj", 32);
    freq.put("ámb", 20);
    freq.put("vak", 34);
    freq.put("sú ", 16);
    freq.put("ou ", 50);
    freq.put("sod", 121);
    freq.put("lts", 41);
    freq.put("ltr", 8);
    freq.put("ltv", 8);
    freq.put("g", 23804);
    freq.put("ltt", 8);
    freq.put("őrü", 14);
    freq.put("nfé", 9);
    freq.put("ütö", 46);
    freq.put("ltb", 12);
    freq.put("lta", 580);
    freq.put("nfó", 18);
    freq.put("lte", 254);
    freq.put("vac", 35);
    freq.put("ltk", 11);
    freq.put("lti", 34);
    freq.put("lth", 17);
    freq.put("lto", 128);
    freq.put("ü", 2579);
    freq.put("ógy", 33);
    freq.put("K ", 306);
    freq.put("agá", 90);
    freq.put("kbő", 8);
    freq.put("Kb", 15);
    freq.put("Ka", 187);
    freq.put("Kg", 10);
    freq.put("úzz", 10);
    freq.put("Ke", 164);
    freq.put("Kd", 9);
    freq.put("Kk", 12);
    freq.put("Kj", 11);
    freq.put("Ki", 259);
    freq.put("úzt", 10);
    freq.put("Ko", 117);
    freq.put("Kn", 18);
    freq.put("Km", 10);
    freq.put("Kl", 40);
    freq.put("úzo", 13);
    freq.put("Kr", 54);
    freq.put("Kq", 8);
    freq.put("Kp", 8);
    freq.put("Kw", 16);
    freq.put("Kv", 19);
    freq.put("Ku", 49);
    freq.put("Kz", 17);
    freq.put("úze", 8);
    freq.put("Kx", 17);
    freq.put("seg", 119);
    freq.put("sed", 24);
    freq.put("ybo", 11);
    freq.put("yba", 54);
    freq.put("ybe", 53);
    freq.put("eai", 13);
    freq.put("wh ", 8);
    freq.put("eak", 24);
    freq.put("jék", 17);
    freq.put("hus", 8);
    freq.put("tón", 12);
    freq.put("tól", 203);
    freq.put("tój", 20);
    freq.put("tók", 61);
    freq.put("tói", 20);
    freq.put("tód", 21);
    freq.put("tób", 39);
    freq.put("tóa", 11);
    freq.put("tóz", 29);
    freq.put("tóv", 16);
    freq.put("tót", 41);
    freq.put("tór", 10);
    freq.put("hp", 9);
    freq.put("Dia", 11);
    freq.put("Ká", 29);
    freq.put("wha", 11);
    freq.put("dáb", 13);
    freq.put("dál", 23);
    freq.put("dám", 14);
    freq.put("dán", 26);
    freq.put("úzó", 8);
    freq.put("dái", 11);
    freq.put("Kí", 17);
    freq.put("dák", 14);
    freq.put("dát", 14);
    freq.put("Kö", 140);
    freq.put("dár", 18);
    freq.put("dás", 198);
    freq.put("úzá", 10);
    freq.put("Kü", 18);
    freq.put("ltű", 19);
    freq.put("gho", 12);
    freq.put("Pot", 9);
    freq.put("Por", 11);
    freq.put("Pos", 8);
    freq.put("tó ", 234);
    freq.put("Tör", 13);
    freq.put("Pon", 15);
    freq.put("Pol", 21);
    freq.put("Pok", 9);
    freq.put("Tök", 11);
    freq.put("Töb", 27);
    freq.put("eí", 30);
    freq.put("Cha", 32);
    freq.put("NI ", 20);
    freq.put("ebé", 23);
    freq.put("eé", 22);
    freq.put("bbő", 23);
    freq.put("Che", 28);
    freq.put("ear", 35);
    freq.put(" w ", 41);
    freq.put("eat", 41);
    freq.put("q ", 115);
    freq.put("sáb", 25);
    freq.put("eav", 8);
    freq.put("qQ", 9);
    freq.put("qP", 14);
    freq.put("qS", 11);
    freq.put("qR", 14);
    freq.put("qT", 13);
    freq.put("qW", 8);
    freq.put("qV", 8);
    freq.put("qY", 10);
    freq.put("qX", 12);
    freq.put("qB", 13);
    freq.put("qE", 12);
    freq.put("qD", 11);
    freq.put("qG", 14);
    freq.put("qF", 10);
    freq.put("qH", 9);
    freq.put("qK", 11);
    freq.put("qL", 10);
    freq.put("qO", 8);
    freq.put("qq", 11);
    freq.put("Jan", 25);
    freq.put("qr", 8);
    freq.put("qu", 51);
    freq.put("qt", 9);
    freq.put("qw", 11);
    freq.put("qv", 12);
    freq.put(" wo", 26);
    freq.put("Chr", 9);
    freq.put(" wh", 22);
    freq.put(" wi", 53);
    freq.put("qa", 13);
    freq.put("qc", 13);
    freq.put("qb", 11);
    freq.put("qe", 10);
    freq.put(" ws", 8);
    freq.put("qg", 13);
    freq.put("qf", 10);
    freq.put("qi", 13);
    freq.put("qh", 8);
    freq.put("qk", 8);
    freq.put("qj", 11);
    freq.put("ql", 14);
    freq.put("qo", 10);
    freq.put("ebe", 80);
    freq.put("eba", 22);
    freq.put("ebb", 251);
    freq.put("ebl", 10);
    freq.put("ebo", 143);
    freq.put("ebi", 10);
    freq.put("jo ", 47);
    freq.put("ebu", 9);
    freq.put("ebr", 57);
    freq.put("eby", 12);
    freq.put("dla", 23);
    freq.put("eö", 10);
    freq.put("dli", 11);
    freq.put("Jac", 11);
    freq.put("növ", 23);
    freq.put("jos", 16);
    freq.put("jot", 17);
    freq.put("jou", 12);
    freq.put("joz", 9);
    freq.put("hM", 13);
    freq.put("job", 284);
    freq.put("jog", 45);
    freq.put("joh", 8);
    freq.put("nöm", 75);
    freq.put("jok", 17);
    freq.put("jol", 15);
    freq.put("jom", 21);
    freq.put("jon", 121);
    freq.put("ejé", 36);
    freq.put("Zal", 14);
    freq.put("mle", 27);
    freq.put("lvi", 77);
    freq.put("ika", 218);
    freq.put("Zay", 26);
    freq.put("rpr", 11);
    freq.put("CD ", 8);
    freq.put("rpa", 12);
    freq.put("aví", 15);
    freq.put("rpe", 15);
    freq.put("avé", 8);
    freq.put("rpi", 12);
    freq.put("hm ", 28);
    freq.put("avá", 12);
    freq.put("rpo", 11);
    freq.put("bbo", 8);
    freq.put("mék", 29);
    freq.put("bbl", 8);
    freq.put("bbj", 9);
    freq.put("Jud", 11);
    freq.put("eid", 25);
    freq.put("bbe", 127);
    freq.put("méb", 10);
    freq.put("Jun", 8);
    freq.put("méd", 12);
    freq.put("bba", 207);
    freq.put("Jus", 13);
    freq.put("IE ", 12);
    freq.put("més", 31);
    freq.put("mér", 94);
    freq.put("bbs", 16);
    freq.put("bbr", 22);
    freq.put("vó ", 9);
    freq.put("hmm", 18);
    freq.put("hmi", 9);
    freq.put(" Tü", 8);
    freq.put("é", 16343);
    freq.put(" Tö", 56);
    freq.put("bb ", 961);
    freq.put(" Té", 22);
    freq.put(" Tá", 41);
    freq.put("tja", 95);
    freq.put("avy", 8);
    freq.put("avu", 12);
    freq.put("lmú", 22);
    freq.put("rpá", 8);
    freq.put("avo", 19);
    freq.put("avi", 62);
    freq.put("pze", 44);
    freq.put("ave", 42);
    freq.put("ava", 227);
    freq.put("jún", 10);
    freq.put("júl", 10);
    freq.put(" ép", 74);
    freq.put(" ér", 561);
    freq.put(" és", 1630);
    freq.put(" ét", 24);
    freq.put(" év", 302);
    freq.put(" éh", 11);
    freq.put(" éj", 67);
    freq.put(" ék", 12);
    freq.put(" él", 233);
    freq.put(" én", 630);
    freq.put(" éb", 19);
    freq.put("bbó", 12);
    freq.put(" T ", 87);
    freq.put(" Tw", 28);
    freq.put(" Tv", 8);
    freq.put(" Tu", 77);
    freq.put(" Tr", 39);
    freq.put("jú ", 27);
    freq.put(" To", 116);
    freq.put(" Ti", 98);
    freq.put(" Th", 98);
    freq.put(" é ", 9);
    freq.put(" Tf", 8);
    freq.put(" Te", 327);
    freq.put(" Ta", 143);
    freq.put("Jap", 11);
    freq.put("KV ", 10);
    freq.put("tcs", 10);
    freq.put("mfo", 10);
    freq.put("Kív", 8);
    freq.put("tch", 41);
    freq.put("tca", 31);
    freq.put("sku", 10);
    freq.put("át ", 845);
    freq.put("Far", 10);
    freq.put("sky", 22);
    freq.put("ske", 90);
    freq.put("Fak", 8);
    freq.put("Fan", 37);
    freq.put("rló", 9);
    freq.put("Fac", 58);
    freq.put("sko", 101);
    freq.put("ski", 18);
    freq.put("óra", 132);
    freq.put("T", 2062);
    freq.put("ndé", 73);
    freq.put("ndí", 33);
    freq.put("áta", 47);
    freq.put("átn", 67);
    freq.put("áto", 270);
    freq.put("átl", 29);
    freq.put("átm", 8);
    freq.put("átj", 25);
    freq.put("átk", 14);
    freq.put("áth", 42);
    freq.put("átv", 29);
    freq.put("átt", 120);
    freq.put("átu", 18);
    freq.put("átr", 36);
    freq.put("áts", 157);
    freq.put("ndó", 26);
    freq.put("dvi", 9);
    freq.put("óm ", 37);
    freq.put("óri", 36);
    freq.put("Sub", 9);
    freq.put("Sup", 10);
    freq.put("tcá", 13);
    freq.put("skü", 19);
    freq.put("yó ", 17);
    freq.put("ská", 25);
    freq.put("zú ", 29);
    freq.put("ské", 28);
    freq.put("no ", 57);
    freq.put("óru", 13);
    freq.put("ndi", 261);
    freq.put("ndh", 17);
    freq.put("ndk", 31);
    freq.put("ndj", 164);
    freq.put("ndo", 392);
    freq.put("átá", 22);
    freq.put("nda", 151);
    freq.put("léc", 16);
    freq.put("nde", 781);
    freq.put("ndd", 21);
    freq.put("áté", 116);
    freq.put("ndy", 22);
    freq.put("átó", 43);
    freq.put("lém", 24);
    freq.put("nds", 63);
    freq.put("ndr", 101);
    freq.put("ndu", 124);
    freq.put("ndt", 91);
    freq.put("ndv", 10);
    freq.put("sül", 54);
    freq.put("öb", 205);
    freq.put("öc", 42);
    freq.put("öd", 83);
    freq.put("öe", 11);
    freq.put("ög", 126);
    freq.put("öh", 69);
    freq.put("owd", 12);
    freq.put("öj", 15);
    freq.put("ök", 411);
    freq.put("öl", 474);
    freq.put("öm", 196);
    freq.put("ön", 792);
    freq.put("öp", 17);
    freq.put("ör", 686);
    freq.put("ös", 505);
    freq.put("öt", 535);
    freq.put("öv", 431);
    freq.put("süt", 68);
    freq.put("öz", 562);
    freq.put("ows", 21);
    freq.put("Ami", 44);
    freq.put("lét", 37);
    freq.put("zvé", 28);
    freq.put("vai", 13);
    freq.put("van", 950);
    freq.put("val", 816);
    freq.put("Te ", 50);
    freq.put("öci", 10);
    freq.put("Ró", 14);
    freq.put("Ame", 16);
    freq.put("vag", 1031);
    freq.put("vad", 73);
    freq.put("owB", 8);
    freq.put("vaz", 47);
    freq.put("öcs", 24);
    freq.put("lv ", 18);
    freq.put("var", 120);
    freq.put("vas", 248);
    freq.put("műk", 44);
    freq.put("vat", 126);
    freq.put("ö ", 30);
    freq.put("taa", 16);
    freq.put("ow ", 58);
    freq.put("lvt", 11);
    freq.put("Tel", 24);
    freq.put("íí", 15);
    freq.put("Tea", 16);
    freq.put("va ", 295);
    freq.put("Tec", 12);
    freq.put("Teg", 20);
    freq.put("lve", 124);
    freq.put("lva", 247);
    freq.put("Ter", 26);
    freq.put("Tes", 18);
    freq.put("Tet", 135);
    freq.put("ex", 185);
    freq.put("műv", 34);
    freq.put("lm ", 63);
    freq.put("öö", 29);
    freq.put("zva", 18);
    freq.put("zve", 35);
    freq.put("ep", 467);
    freq.put("Amú", 24);
    freq.put("gír", 20);
    freq.put("gít", 79);
    freq.put("ejl", 42);
    freq.put("zút", 14);
    freq.put("zúr", 11);
    freq.put("ndő", 41);
    freq.put("my ", 30);
    freq.put("íg", 233);
    freq.put("íc", 14);
    freq.put("ím", 97);
    freq.put("íl", 41);
    freq.put("ín", 186);
    freq.put("ík", 18);
    freq.put("íj", 50);
    freq.put("ít", 831);
    freq.put("ív", 319);
    freq.put("lvá", 59);
    freq.put("íp", 20);
    freq.put("ís", 17);
    freq.put("ír", 666);
    freq.put("lvé", 24);
    freq.put("íz", 150);
  }
  
}

